prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4407
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4407 - Oracle APEX Application Migration
--
-- Application Export:
--   Application:     4407
--   Name:            Oracle APEX Application Migration
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    101
--       Items:                1,275
--       Computations:            98
--       Validations:             70
--       Processes:              276
--       Regions:                445
--       Buttons:                179
--       Dynamic Actions:         24
--     Shared Components:
--       Logic:
--         Items:                 24
--         Processes:              6
--         Computations:           2
--         Build Options:          1
--       Navigation:
--         Tab Sets:               1
--           Tabs:                 1
--         Lists:                 23
--         Breadcrumbs:            1
--           Entries:             99
--         NavBar Entries:         3
--       Security:
--         Authentication:         1
--         Authorization:         10
--       User Interface:
--         Templates:
--           Page:                13
--           Region:              42
--           Label:               11
--           List:                15
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           2
--           Button:               9
--           Report:              14
--         LOVs:                  87
--         Shortcuts:              3
--         Plug-ins:               9
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Application Migration')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286625192012926584')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135325'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'zh-tw'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(539742725518650006.4407)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'S'
,p_deep_linking=>'Y'
,p_runtime_api_usage=>'T:O'
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'HELP'
,p_substitution_value_01=>unistr('\8AAA\660E')
,p_substitution_string_02=>'PRODUCT_NAME'
,p_substitution_value_02=>'Application Express'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>unistr('\5DE5\4F5C\5340: &COMPANY.')
,p_substitution_string_04=>'MSG_LANGUAGE'
,p_substitution_value_04=>unistr('\8A9E\8A00')
,p_substitution_string_05=>'MSG_COPYRIGHT'
,p_substitution_value_05=>unistr('\8457\4F5C\6B0A\6240\6709 &copy; 1999, 2019, Oracle. \4FDD\7559\4E00\5207\6B0A\5229.')
,p_substitution_string_06=>'MSG_USER'
,p_substitution_value_06=>unistr('\4F7F\7528\8005')
,p_substitution_string_07=>'MSG_JSCRIPT'
,p_substitution_value_07=>unistr('\60A8\5FC5\9808\555F\7528 JavaScript, \624D\80FD\57F7\884C\672C\7522\54C1.')
,p_substitution_string_08=>'MSG_TBL_SUMMARY'
,p_substitution_value_08=>unistr('\9801\9762\7248\9762\914D\7F6E\8868\683C')
,p_substitution_string_09=>'DELETE_MSG'
,p_substitution_value_09=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
,p_substitution_string_10=>'TABLES'
,p_substitution_value_10=>unistr('\8868\683C')
,p_substitution_string_11=>'QUERIES'
,p_substitution_value_11=>unistr('\67E5\8A62')
,p_substitution_string_12=>'FORMS'
,p_substitution_value_12=>unistr('\8868\55AE')
,p_substitution_string_13=>'TIME_FORMAT'
,p_substitution_value_13=>'AM hh:mi:ss'
,p_substitution_string_14=>'MODULES'
,p_substitution_value_14=>unistr('\6A21\7D44')
,p_substitution_string_15=>'DATE_FORMAT'
,p_substitution_value_15=>'yyyy/mm/dd'
,p_substitution_string_16=>'DATE_TIME_FORMAT'
,p_substitution_value_16=>'yyyy/mm/dd AM hh:mi:ss'
,p_substitution_string_17=>'CAPTION'
,p_substitution_value_17=>unistr('\6A19\984C')
,p_substitution_string_18=>'EXPORTER'
,p_substitution_value_18=>unistr('&MS_ACCESS. \7684\532F\51FA\5DE5\5177')
,p_substitution_string_19=>'MS_ACCESS'
,p_substitution_value_19=>'Microsoft Access'
,p_substitution_string_20=>'ROWSOURCE'
,p_substitution_value_20=>unistr('\8CC7\6599\5217\4F86\6E90')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141224'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/view_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1271017373539089.4407)
,p_name=>'View Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5149703147792571.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('UI \9810\8A2D\503C')
,p_list_item_link_target=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.::P37_OBJECT_ID,P37_OBJECT_NAME:&P30_OBJECT_ID.,&P30_VIEW_NAME.:'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_list_item_disp_condition=>'P30_VIEW_NAME'
,p_list_item_disp_condition2=>'-'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'37'
);
end;
/
prompt --application/shared_components/navigation/lists/ui_default_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1820113195766969.4407)
,p_name=>'UI_DEFAULT_ACTIONS'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1820619559778268.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\7DE8\8F2F')
,p_list_item_link_target=>'javascript:top.redirect(''f?p=4500:802:&SESSION.::&DEBUG.:RP,802:P800_SCHEMA,P802_TABLE_ID:&MW_SCHEMA.,&P37_TABLE_ID.'')'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'                      select count(table_id) cnt',
'                      from WWV_FLOW_HNT_TABLE_INFO ',
'                      where schema = :MW_SCHEMA ',
'                      and table_name = :P37_OBJECT_NAME',
'',
')',
'loop',
'  if c1.cnt = 1 then',
'     return true;',
'  else ',
'     return false;',
'  end if;',
'end loop;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1821004799783454.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5EFA\7ACB\9810\8A2D\503C')
,p_list_item_link_target=>'javascript:top.redirect(''f?p=4500:801:&SESSION.::&DEBUG.:RP,801,802:P800_SCHEMA,P801_TABLE_ID,P802_TABLE_ID:&MW_SCHEMA.,&P37_OBJECT_ID.,'')'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'                      select count(table_id) cnt',
'                      from WWV_FLOW_HNT_TABLE_INFO ',
'                      where schema = :MW_SCHEMA ',
'                      and table_name = :P37_OBJECT_NAME',
'',
')',
'loop',
'  if c1.cnt = 0 then',
'     return true;',
'  else ',
'     return false;',
'  end if;',
'end loop;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sqlquery_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(4097217982804529.4407)
,p_name=>'SQLQuery_Actions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4097906221804606.4407)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>unistr('\5C0B\627E\4E26\53D6\4EE3')
,p_list_item_link_target=>'javascript:toggleFind()'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/migration_project_home_page_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5333829890130844.4407)
,p_name=>'Migration Project Home Page Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5334206818133659.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\522A\9664\5C08\6848')
,p_list_item_link_target=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::P4_ID:&MW_PROJ_ID.:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'lower(:MW_MIG_TYPE) = ''forms'' and :MW_PROJ_ID is not null'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(245576610152839506.4407)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\522A\9664\5C08\6848')
,p_list_item_link_target=>'f?p=&APP_ID.:115:&SESSION.::&DEBUG.::P115_ID:&MW_PROJ_ID.:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'lower(:MW_MIG_TYPE) = ''access'' and :MW_PROJ_ID is not null'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2042020722686417.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\7DE8\8F2F\5C08\6848\8A73\7D30\8CC7\8A0A\548C\9069\7528\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::P88_ID,MW_MIG_TYPE:&MW_PROJ_ID.,forms:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'lower(:MW_MIG_TYPE) = ''forms'' and :MW_PROJ_ID is not null'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(245565612473707729.4407)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\7DE8\8F2F\5C08\6848\8A73\7D30\8CC7\8A0A')
,p_list_item_link_target=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.::P109_ID,MW_MIG_TYPE:&MW_PROJ_ID.,access:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'lower(:MW_MIG_TYPE) = ''access'' and :MW_PROJ_ID is not null',
''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(234409411736892970.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7522\751F\7684\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.::P72_ID,MW_MIG_TYPE:&MW_PROJ_ID.,forms:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
' from wwv_flows f , wwv_mig_generated_applications p',
'   where ',
'     p.security_group_id = :flow_security_group_id ',
'     and p.project_id = :MW_PROJ_ID',
'     and f.id = p.application_id ',
'     and :MW_MIG_TYPE = ''forms''',
'     and rownum = 1'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(266185817243988377.4407)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\95DC\65BC Forms \8F49\63DB')
,p_list_item_link_target=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'lower(:MW_MIG_TYPE) = ''forms'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19479228187673186.4407)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\9810\8A2D\503C')
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(989101155307021.4407)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=&APP_ID.:31:&SESSION.:LOAD:&DEBUG.:31,39,50,47:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':MW_MIG_TYPE = ''access'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'31'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(5969901318497244.4407)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.:CC:&DEBUG.:33,35,50:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>':MW_MIG_TYPE = ''access'''
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'33'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5877721161285352.4407)
,p_name=>'Home Page Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(266176122129942448.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5982\4F55\8F49\63DB Oracle Forms \61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/access_migration_work_flow
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5993506906527257.4407)
,p_name=>'access migration work flow'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/access_migration_work_flow_002
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(5994012793528903.4407)
,p_name=>'access migration work flow'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20724615487594175.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\64F7\53D6\300C&MS_ACCESS. \8CC7\6599\5EAB\300D\7684\8CC7\6599\5EAB\548C\61C9\7528\7A0B\5F0F\8CC7\8A0A')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(20726608261620475.4407)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\5C07\8CC7\6599\5EAB\7DB1\8981\8CC7\8A0A\8F09\5165 Oracle Migration Workbench \4E2D')
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/post_install_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(12190507786303266.4407)
,p_name=>'post-install-options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12190926140308520.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\57F7\884C\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=&FB_FLOW_ID.:&FB_FLOW_PAGE_ID.:&SESSION.'
,p_list_item_icon=>'htmldb/builder/run_flow.gif'
,p_list_item_icon_attributes=>'width="100" height="75" alt="#LIST_LABEL#" title="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(12191207917312790.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\7DE8\8F2F\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'javascript:redirect(''f?p=4000:1:&SESSION.::&DEBUG.:1,4150,RP:FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW,F4000_P4150_GOTO_PAGE,F4000_P1_PAGE:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.,1,1'');'
,p_list_item_icon=>'htmldb/builder/app_builder.gif'
,p_list_item_icon_attributes=>'height="75" width="100" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(14116007603720897.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7DE8\8F2F\61C9\7528\7A0B\5F0F\5C6C\6027')
,p_list_item_link_target=>'javascript:redirect(''f?p=4000:4001:&SESSION.::&DEBUG.:1:FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_LAST_VIEW:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,1'')'
,p_list_item_icon=>'htmldb/builder/edit_page.gif'
,p_list_item_icon_attributes=>'width="100" height="75" alt="#LIST_LABEL#" title="#LIST_LABEL#"'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_install',
'where flow_id = :FB_FLOW_ID',
'and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/anchors_for_800
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(19569219239904506.4407)
,p_name=>'anchors for 800'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19570730588904511.4407)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\5168\90E8\986F\793A')
,p_list_item_link_target=>'#ALL'
,p_list_text_01=>'ALL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19570103416904511.4407)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>unistr('\9801\7C64')
,p_list_item_link_target=>'#TABS'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19569515698904510.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A8D\8B49')
,p_list_item_link_target=>'#A'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19569832730904510.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4E3B\984C')
,p_list_item_link_target=>'#THEME'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(19570428087904511.4407)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5168\7403\5316')
,p_list_item_link_target=>'#G'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/query_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(21304628412941720.4407)
,p_name=>'Query_Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(21305311574946304.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5617\8A66\7DE8\8B6F\7121\6548\7684\67E5\8A62')
,p_list_item_link_target=>'javascript:doSubmit(''COMPILE_ALL'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select orig_qry_name ',
'from   wwv_mig_rev_queries',
'where  project_id = :MW_PROJ_ID',
'and    security_group_id = :flow_security_group_id',
'--and    dbid = :P10_DBID',
'and    (:P10_QUERY is null or instr(upper(orig_qry_name),upper(:P10_QUERY))>0)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/reports_sql_query_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(22752402136643992.4407)
,p_name=>'Reports SQL Query Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(22752602983644000.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5617\8A66\7DE8\8B6F\7121\6548\7684 SQL \67E5\8A62')
,p_list_item_link_target=>'javascript:doSubmit(''COMPILE_ALL'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select report_name from wwv_mig_rev_reports',
'where project_id = :MW_PROJ_ID',
'and security_group_id = :flow_security_group_id',
'-- and dbid = :P2_DBID',
'and (:P20_REPORT is null or instr(upper(report_name),upper(:P20_REPORT))>0)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/forms_sql_query_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(36541431940113088.4407)
,p_name=>'Forms SQL Query Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(36541620611113096.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5617\8A66\7DE8\8B6F\7121\6548\7684 SQL \67E5\8A62')
,p_list_item_link_target=>'javascript:doSubmit(''COMPILE_ALL'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select form_name from wwv_mig_rev_forms',
'where project_id = :MW_PROJ_ID',
'and security_group_id = :flow_security_group_id',
'-- and dbid = :P2_DBID',
'and (:P8_FORM is null or instr(upper(form_name),upper(:P8_FORM))>0)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/block_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(69191632587104379.4407)
,p_name=>'Block Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(69191805622124942.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A2D\5B9A\6240\6709\5340\584A\9805\76EE\7684\5B8C\6210\6027\8207\9069\7528\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.:76:P76_SET,P77_ID,P76_ATTRIBUTE:COMPLETE,&P77_ID.,ITEMS:'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P77_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(69192219821129073.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8A2D\5B9A\6240\6709\5340\584A\89F8\767C\7A0B\5F0F\7684\5B8C\6210\6027\8207\9069\7528\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.::P77_ID,P76_ATTRIBUTE:&P77_ID.,BLOCK_TRIGGERS:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/windows_details_anchors
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(74801410954327090.4407)
,p_name=>'Windows Details Anchors'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(74801611136327091.4407)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\5168\90E8\986F\793A')
,p_list_item_link_target=>'#ALL'
,p_list_text_01=>'ALL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(74801901648327091.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8996\7A97\8A73\7D30\8CC7\8A0A')
,p_list_item_link_target=>'#WIN'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(74802218329327092.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A3B\89E3')
,p_list_item_link_target=>'#ANN'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/project_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(139359500914809151.4407)
,p_name=>'Project Progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(139360031735818089.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5C08\6848\8A73\7D30\8CC7\8A0A')
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3996008910797187.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4E0A\50B3\6A94\6848')
,p_list_item_link_target=>'f?p=&APP_ID.:106:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'REQUEST_EQUALS_CONDITION'
,p_list_item_disp_condition=>'MULTIPLE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'106'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(139360700830828049.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
end;
/
prompt --application/shared_components/navigation/lists/primary_key_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(195220629580456752.4407)
,p_name=>'Primary Key Progress'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/table_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(195741723445523826.4407)
,p_name=>'Table Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(248614231558970584.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('UI \9810\8A2D\503C')
,p_list_item_link_target=>'f?p=&APP_ID.:37:&SESSION.:TABLE:&DEBUG.::P37_OBJECT_ID,P37_OBJECT_NAME:&P22_OBJECT_ID.,&P22_TABLE_NAME.:'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_count number := 0;',
'begin',
'  for c1 in',
'  (',
'    select count(*) cnt from sys.dba_tables',
'    where table_name = UPPER(:P22_TABLE_NAME)',
'    and owner = UPPER(:MW_SCHEMA)',
'  )',
'  loop',
'    l_count := c1.cnt;',
'  end loop;',
'   ',
'  if (l_count = 0) then',
'    return false;',
'  else',
'    return true;',
'  end if;',
'',
'end;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'37'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1493123088097034.4407)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5EFA\7ACB\8868\683C')
,p_list_item_link_target=>'javascript:top.redirect(''f?p=4500:1001:&SESSION.::&DEBUG.'')'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_count number := 0;',
'begin',
'  for c1 in',
'  (',
'    select count(*) cnt from sys.dba_tables',
'    where table_name = UPPER(:P22_TABLE_NAME)',
'    and owner = UPPER(:MW_SCHEMA)',
'  )',
'  loop',
'    l_count := c1.cnt;',
'  end loop;',
'   ',
'  if (l_count = 0) then',
'    return true;',
'  else',
'    return false;',
'  end if;',
'',
'end;'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(198375507749755277.4407)
,p_name=>'Actions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2020817804127339.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5C0B\627E\4E26\53D6\4EE3')
,p_list_item_link_target=>'javascript:toggleFind()'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_application_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(243690011375751560.4407)
,p_name=>'Create Application Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(4036501271524208.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'31,33,62'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(21425721745709207.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\4F7F\7528\8005\4ECB\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'50,138'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(243690703887758839.4407)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'39,35,137'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697470173974258886.4407)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697470327893258888.4407)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697470662901258889.4407)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697470949307258890.4407)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\7BA1\7406\670D\52D9')
,p_security_scheme=>wwv_flow_api.id(12520807849505738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697471260926258890.4407)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\7BA1\7406\670D\52D9')
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697470949307258890.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697471507504258890.4407)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(697470949307258890.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697472156533258890.4407)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('\8A2D\5B9A\5DE5\4F5C\5340\504F\597D\8A2D\5B9A')
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_api.id(697470949307258890.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697472468052258890.4407)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\7DE8\8F2F\516C\544A')
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697470949307258890.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697472712792258890.4407)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\5DE5\4F5C\5340\4F7F\7528\72C0\6CC1')
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697470949307258890.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697473048708258890.4407)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\7BA1\7406\4F7F\7528\8005\548C\7FA4\7D44')
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(12520807849505738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697473618023258892.4407)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>unistr('\5100\8868\677F')
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(10757522946749649)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1250770411742203704.4407)
,p_list_item_display_sequence=>600
,p_list_item_link_text=>unistr('\8B8A\66F4\6211\7684\5BC6\78BC')
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(10757522946749649)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697475141733260859.4407)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697475326910260859.4407)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6587\4EF6')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105954386750038550.4407)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A0E\8AD6\8AD6\58C7')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185498367480544603.4407)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7532\9AA8\6587\5168\7403\958B\767C\8005\6280\8853\7DB2\8DEF (OTN)')
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697476239423260860.4407)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(719061308852162669.4407)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\5411\4E0B\5C55\958B\529F\80FD')
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(179067116346985793)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719061800478162672.4407)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719062160873162672.4407)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('Web \8A66\7B97\8868\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719062425850162672.4407)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719062736675162672.4407)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\5EFA\7ACB')
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719063078186162672.4407)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\532F\5165')
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719063348455162672.4407)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\532F\51FA')
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719063666908162673.4407)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('\5DE5\4F5C\5340\516C\7528\7A0B\5F0F')
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719064277313162674.4407)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>unistr('\5168\90E8\5DE5\4F5C\5340\516C\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719064525048162674.4407)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719064849873162674.4407)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\9810\8A2D\503C')
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719065429984162674.4407)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>unistr('\5DE5\4F5C\5340\4E3B\984C')
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719065776747162674.4407)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\7FA4\7D44')
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719066091552162674.4407)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>unistr('Application Express \6AA2\8996')
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719066383614162675.4407)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('\4EA4\53C9\61C9\7528\7A0B\5F0F\5831\8868')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719063930051162673.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719066648600162675.4407)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719066966089162675.4407)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\79FB\8F49')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719061590378162671.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719067231530162675.4407)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('SQL \5DE5\4F5C\5BA4')
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>unistr('SQL \5DE5\4F5C\5BA4\5411\4E0B\5C55\958B\529F\80FD')
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(179067514487985813)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719067581003162676.4407)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\7269\4EF6\700F\89BD\5668')
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719067231530162675.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719067809534162676.4407)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('SQL \547D\4EE4')
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719067231530162675.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719068178929162676.4407)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('SQL \547D\4EE4\6A94')
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719067231530162675.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\516C\7528\7A0B\5F0F')
,p_parent_list_item_id=>wwv_flow_api.id(719067231530162675.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719068756225162676.4407)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>unistr('\5168\90E8\516C\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719069094224162676.4407)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719069336129162676.4407)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>unistr('\8CC7\6599\5DE5\4F5C\5BA4')
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719069612195162676.4407)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>unistr('\67E5\8A62\7522\751F\5668')
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(31861002515460748.4407)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(670894127837008710.4407)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>unistr('\7BC4\4F8B\8CC7\6599\96C6')
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(670894844747013294.4407)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>unistr('\7522\751F DDL')
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719070229829162677.4407)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>unistr('\4F7F\7528\8005\4ECB\9762\9810\8A2D\503C')
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719071743082162677.4407)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('\7DB1\8981\6BD4\8F03')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719070522553162677.4407)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\8868\683C\65B9\6CD5')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719072040157162678.4407)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>unistr('\8CC7\6E90\56DE\6536\7B52')
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719071149007162677.4407)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>unistr('\7269\4EF6\5831\8868')
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719070824530162677.4407)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>unistr('\95DC\65BC\8CC7\6599\5EAB')
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719071421480162677.4407)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>unistr('\8CC7\6599\5EAB\76E3\7763')
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719068483660162676.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719072326898162678.4407)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('RESTful \670D\52D9')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719067231530162675.4407)
,p_security_scheme=>wwv_flow_api.id(917866332358079308)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719072625958162678.4407)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\5718\968A\958B\767C')
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>unistr('\5718\968A\958B\767C\5411\4E0B\5C55\958B\529F\80FD')
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719072912088162678.4407)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>unistr('\6A19\7C64')
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719072625958162678.4407)
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719073237579162679.4407)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>unistr('\91CC\7A0B\7891')
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719072625958162678.4407)
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719073548823162679.4407)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>unistr('\6A23\677F')
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719072625958162678.4407)
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719073845443162679.4407)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>unistr('\516C\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719072625958162678.4407)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719074481727162680.4407)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719072625958162678.4407)
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719074718125162680.4407)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>unistr('\610F\898B\56DE\994B')
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719072625958162678.4407)
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719078981529162682.4407)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\5EAB')
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'tab-apps'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719079294052162682.4407)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>unistr('\751F\7522\529B\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE'
,p_parent_list_item_id=>wwv_flow_api.id(719078981529162682.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719079593122162682.4407)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>unistr('\7BC4\4F8B\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE'
,p_parent_list_item_id=>wwv_flow_api.id(719078981529162682.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(780158352938349051.4407)
,p_list_item_display_sequence=>425
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719078981529162682.4407)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/index_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(779101424545473712.4407)
,p_name=>'Index Progress'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1033467920343391.4407)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1950474972408405.4407)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14848604722940928.4407)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91989626237572391.4407)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072512514712055.4407)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831722661082993877.4407)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917670907930940079.4407)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(10757522946749649.4407)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('\672A\6388\6B0A\60A8\5B58\53D6\300C\5100\8868\677F\300D\8207\300C\76E3\7763\6D3B\52D5\300D.')
,p_reference_id=>786936829326142579.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12507920242253836.4407)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\60A8\6C92\6709\7DE8\8F2F\61C9\7528\7A0B\5F0F\7684\6388\6B0A')
,p_reference_id=>12480509677812756.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(12520807849505738.4407)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('\60A8\6C92\6709\7BA1\7406\61C9\7528\7A0B\5F0F\7684\6388\6B0A')
,p_reference_id=>12511219858301010.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(179067116346985793.4407)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786516029127697713.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(179067514487985813.4407)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('\60A8\6C92\6709\4F7F\7528\300CSQL \5DE5\4F5C\5BA4\300D\7684\6388\6B0A')
,p_reference_id=>786516265251697717.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(179068012781985813.4407)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\6B64\5DE5\4F5C\5340\672A\555F\7528\5718\968A\958B\767C')
,p_reference_id=>786516861027697723.4407
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(179068521244985816.4407)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786517166823697723.4407
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(517058292511719869.4407)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('\672A\555F\7528\300C\7522\751F\5668 SSO\300D')
,p_reference_id=>6738410669854771.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(763730133908664894.4407)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('\60A8\6C92\6709\5B89\88DD\300C\5957\88DD\61C9\7528\7A0B\5F0F\300D\7684\6388\6B0A')
,p_reference_id=>786517456817697723.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(917866332358079308.4407)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786519856057734816.4407
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(23539311828783426.4407)
,p_icon_sequence=>10
,p_icon_subtext=>unistr('\5DE5\4F5C\5340 &COMPANY.')
,p_icon_target=>'f?p=4500:1000:&SESSION.'
,p_icon_image_alt=>unistr('\5DE5\4F5C\5340 &COMPANY.')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(23542619886192515.4407)
,p_icon_sequence=>20
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">\767B\51FA</span> )')
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>unistr('\767B\51FA')
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'%null%'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(173021108627126551.4407)
,p_icon_sequence=>30
,p_icon_image=>'feedback'
,p_icon_subtext=>unistr('\610F\898B\56DE\994B')
,p_icon_target=>'javascript:popupURL(''f?p=4000:714:&SESSION.:::714:P714_APPLICATION_ID,P714_PAGE_ID:&APP_ID.,&APP_PAGE_ID.'');'
,p_icon_image_alt=>unistr('\610F\898B\56DE\994B')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(110414113197144197.4407)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/validate_sql
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(4688716774299999.4407)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'validate_sql'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_status varchar2(32767);',
'',
'begin',
'    wwv_flow_sw_api.check_priv(:MW_SCHEMA);',
'       l_status := wwv_flow_f4000_util.is_valid_report_query(',
'           p_plug_source => :P42_HIDDEN_SQL,',
'           p_plug_source_type => ''SQL_QUERY'', ',
'           p_owner => :MW_SCHEMA',
'       );',
'       sys.htp.p(l_status);',
'',
'exception',
'   when others then',
'      sys.htp.p(wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_process_comment=>'created 04-SEP-2006 15:23:00'
);
end;
/
prompt --application/shared_components/logic/application_processes/compile_sql_query
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(5201502110119821.4407)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'compile_sql_query'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_status varchar2(32767);',
'',
'begin',
'    wwv_flow_sw_api.check_priv(:MW_SCHEMA);',
'       --l_status := wwv_flow_sw_api.run_sql(',
'       wwv_flow_sw_api.run_sql(',
'            p_sql_cmd => :P42_HIDDEN_SQL,',
'            p_schema => :MW_SCHEMA,',
'            p_print_msg => ''Y'');',
'',
'       --sys.htp.p(l_status);',
'',
'exception',
'   when others then',
'      sys.htp.p(wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_process_comment=>'created 10-SEP-2006 15:20:00'
);
end;
/
prompt --application/shared_components/logic/application_processes/compile_view
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(5221631313264694.4407)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'compile_view'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_status varchar2(32767);',
'',
'begin',
'   wwv_flow_sw_api.check_priv(:OBJ_OWNER);',
'   for c1 in (',
'       select clob001 from htmldb_collections',
'       where collection_name = ''PLSQL_OBJECT_SOURCE''',
'   ) loop',
'       l_status := wwv_flow_plsql_editor.compile(',
'           :OBJ_OWNER,',
'           :P30_VIEW_NAME,',
'           :OBJ_TYPE, ',
'           c1.clob001',
'       );',
'       sys.htp.p(l_status);',
'   end loop;',
'',
'   htmldb_collection.truncate_collection(',
'      p_collection_name => ''PLSQL_OBJECT_SOURCE'' ',
'   );',
'',
'exception',
'   when others then',
'      sys.htp.p(wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
,p_process_comment=>'created 11-SEP-2006 15:20:00'
);
end;
/
prompt --application/shared_components/logic/application_processes/alertprocess
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(99262016635200707.4407)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'alertprocess'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_counter number;',
'  l_o_name  varchar2(2000);',
'begin',
'  sys.htp.prn(''<body>'');',
'  sys.htp.prn(''<desc>This was just put into session in Application Item TEMPORARY_ITEM</dec>'');',
'  sys.htp.prn(''<payload id="test">''||wwv_flow_escape.html(v(''TEMPORARY_ITEM''))||''</payload>'');',
'  sys.htp.prn(''</body>'');',
'end;'))
,p_security_scheme=>wwv_flow_api.id(12507920242253836)
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(234081087848021628.4407)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02);'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(5024124051039438.4407)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(322235223353586898.4407)
,p_name=>'F4400_LAST_VIEW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(11961301928828394.4407)
,p_name=>'FB_FLOW_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'Identifies the flow'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(11961713356831740.4407)
,p_name=>'FB_FLOW_PAGE_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'Identifies the flow page'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(29191130394180095.4407)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_item_comment=>'Used by Custom2 authentication for deep linking support'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(778553907302517468.4407)
,p_name=>'FSP_PROCESS_STATE_6049310398066402'
,p_item_comment=>'Used for stateful process management'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(21625221246066641.4407)
,p_name=>'GEN_APP_CRUMB'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(271674205052460273.4407)
,p_name=>'MW_APPLICATION_ID'
,p_protection_level=>'N'
,p_item_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'P51_APPLICATION_ID for ''forms''',
'P31_APPLICATION_ID for ''access'''))
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(244089523810904023.4407)
,p_name=>'MW_APPLICATION_NAME'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(260880122352971242.4407)
,p_name=>'MW_MIG_PAGE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(259371106880664444.4407)
,p_name=>'MW_MIG_TYPE'
,p_protection_level=>'N'
,p_item_comment=>'This would be used to distinguish between ''access'' and ''forms'''
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(271674030894458277.4407)
,p_name=>'MW_MODEL_ID'
,p_protection_level=>'N'
,p_item_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'P51_MODEL_ID for ''forms''',
'P31_MODEL_ID for ''access'''))
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(5155418520481129.4407)
,p_name=>'MW_PROJ_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(260863722586413096.4407)
,p_name=>'MW_PROJ_NAME'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(272369618450899026.4407)
,p_name=>'MW_SCHEMA'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2065732367350698.4407)
,p_name=>'OBJ_NAME'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2066611374354151.4407)
,p_name=>'OBJ_OWNER'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2066103409351846.4407)
,p_name=>'OBJ_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2813630577422955.4407)
,p_name=>'REP_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(2813227461422010.4407)
,p_name=>'REP_NAME'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(21496400301698024.4407)
,p_name=>'THEME_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(21496803764699067.4407)
,p_name=>'THEME_NEXT_PAGE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(1020942706007669499.4407)
,p_name=>'VIEW_DETAIL'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(3482631657882456.4407)
,p_name=>'VIEW_NAME'
,p_protection_level=>'N'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(5025409637044763.4407)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name;'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('\7121\6CD5\904B\7B97\5DE5\4F5C\5340\540D\7A31.')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(1020991600597677401.4407)
,p_computation_sequence=>10
,p_computation_item=>'VIEW_DETAIL'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''APEXIR_VIEW_DETAIL'');'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
wwv_flow_api.create_tab(
 p_id=>wwv_flow_api.id(4994327640932458.4407)
,p_tab_set=>'TS1'
,p_tab_sequence=>10
,p_tab_name=>'T_PAGE&NBSP;1'
,p_tab_text=>unistr('\7B2C&nbsp;1 \9801')
,p_tab_step=>1
,p_tab_also_current_for_pages=>'28,36,111,117,131,132,133,134,135,136,139,140,72'
);
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/0_1_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2268411818705410.4407)
,p_lov_name=>'0.1.RETURNS.Y.N'
,p_lov_query=>'.'||wwv_flow_api.id(2268411818705410.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2268719044705422.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2268911320705423.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'1'
);
end;
/
prompt --application/shared_components/user_interface/lovs/alignment_l_c_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6767129339658379.4407)
,p_lov_name=>'ALIGNMENT_L_C_R'
,p_lov_query=>'.'||wwv_flow_api.id(6767129339658379.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6767402068658388.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9760\5DE6')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6767619777658388.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\7F6E\4E2D')
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6767809516658388.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\9760\53F3')
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_wizard_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6745605530658343.4407)
,p_lov_name=>'APP WIZARD PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(6745605530658343.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6745905457658343.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7A7A\767D\9801\9762')
,p_lov_return_value=>'BLANK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6746129152658343.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5831\8868\9801\9762')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6746324613658344.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5728\7B2C\4E8C\500B\9801\9762\5305\542B\5177\7DE8\8F2F\8868\55AE\7684\5831\8868')
,p_lov_return_value=>'REPORTANDFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6746526869658344.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5217\8868\5316\8868\55AE')
,p_lov_return_value=>'TABULARFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6746711076658347.4407)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\5305\542B\63D2\5165, \66F4\65B0\4EE5\53CA\522A\9664\7684\8868\55AE')
,p_lov_return_value=>'FORM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/assignees
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(314823628966435555.4407)
,p_lov_name=>'ASSIGNEES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select Initcap(userid) d, userid r',
'from   wwv_flow_developers',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/block_types_all_or_db
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(71114111955709573.4407)
,p_lov_name=>'BLOCK TYPES (ALL OR DB)'
,p_lov_query=>'.'||wwv_flow_api.id(71114111955709573.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(71114307930709575.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5168\90E8\5340\584A')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(71114505124709576.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8CC7\6599\5EAB\5340\584A')
,p_lov_return_value=>'DB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(71115227886714191.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\975E\8CC7\6599\5EAB\5340\584A')
,p_lov_return_value=>'NON_DB'
);
end;
/
prompt --application/shared_components/user_interface/lovs/block_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(268418531368435734.4407)
,p_lov_name=>'BLOCK_ATTRIBUTES'
,p_lov_query=>'.'||wwv_flow_api.id(268418531368435734.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(268418811730435734.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9805\76EE')
,p_lov_return_value=>'ITEMS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(268419021098435735.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5340\584A\89F8\767C\7A0B\5F0F')
,p_lov_return_value=>'BLOCK_TRIGGERS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(268419208223435735.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\9805\76EE\89F8\767C\7A0B\5F0F')
,p_lov_return_value=>'ITEM_TRIGGERS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/complete_applicable
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(69212632381189500.4407)
,p_lov_name=>'COMPLETE APPLICABLE'
,p_lov_query=>'.'||wwv_flow_api.id(69212632381189500.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(69212804159189502.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5B8C\6210')
,p_lov_return_value=>'COMPLETE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(69213030923189504.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\9069\7528')
,p_lov_return_value=>'APPLICABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_action_checkbox_returns_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(71131114642729280.4407)
,p_lov_name=>'CONFIRM ACTION (CHECKBOX RETURNS Y)'
,p_lov_query=>'.'||wwv_flow_api.id(71131114642729280.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(71131330981729281.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\78BA\8A8D\52D5\4F5C')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/control_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2256220196537491.4407)
,p_lov_name=>'CONTROL_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(2256220196537491.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(8618000672306903.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('-\5168\90E8-')
,p_lov_return_value=>'-All-'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2256710033537514.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6587\5B57\6B04\4F4D')
,p_lov_return_value=>'109'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2260803975636949.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\9023\7D50\7269\4EF6\6846')
,p_lov_return_value=>'108'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2261108131638181.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6838\53D6\65B9\584A')
,p_lov_return_value=>'106'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2261414711640023.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\7D44\5408\65B9\584A')
,p_lov_return_value=>'111'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2261718520641190.4407)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\6309\9215')
,p_lov_return_value=>'104'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2262023022642469.4407)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\81EA\8A02\63A7\5236\9805')
,p_lov_return_value=>'107'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2262326831643559.4407)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\5F71\50CF')
,p_lov_return_value=>'103'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2262600297645319.4407)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\884C\5206\9694\7B26\865F')
,p_lov_return_value=>'102'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2262906877647260.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6E05\55AE\65B9\584A')
,p_lov_return_value=>'110'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2263200082654770.4407)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\7269\4EF6\6846')
,p_lov_return_value=>'114'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2263505622656371.4407)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\9078\9805\6309\9215')
,p_lov_return_value=>'105'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2263811163657942.4407)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\9078\9805\7FA4\7D44')
,p_lov_return_value=>'107'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2264115665659200.4407)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\9801\9762 ')
,p_lov_return_value=>'124'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2264420514660665.4407)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\5206\9801')
,p_lov_return_value=>'118'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2264724323661768.4407)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\77E9\5F62')
,p_lov_return_value=>'101'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2265028479662955.4407)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\5B50\8868\55AE')
,p_lov_return_value=>'112'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2265302290664876.4407)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\9801\7C64\63A7\5236\9805')
,p_lov_return_value=>'123'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2265611641667583.4407)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\5207\63DB\6309\9215')
,p_lov_return_value=>'122'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2256520690537508.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6A19\7C64')
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(29444330609608767.4407)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('ActiveX \63A7\5236\9805')
,p_lov_return_value=>'119'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_application_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22139623686037120.4407)
,p_lov_name=>'CREATE APPLICATION PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(22139623686037120.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22139901817037130.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\65B0\589E\7A7A\767D\9801\9762\81F3\61C9\7528\7A0B\5F0F')
,p_lov_return_value=>'BLANK'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22140103908037134.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\65B0\589E\5831\8868')
,p_lov_return_value=>'REPORT'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':MW_MIG_TYPE = ''forms'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22140731738037136.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65B0\589E\5305\542B\63D2\5165, \66F4\65B0\548C\522A\9664\7684\8868\55AE')
,p_lov_return_value=>'FORM'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':MW_MIG_TYPE = ''forms'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22140530052037136.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\65B0\589E\5217\8868\5316\8868\55AE')
,p_lov_return_value=>'TABULARFORM'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':MW_MIG_TYPE = ''forms'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(280920212112967858.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\65B0\589E\4E3B\8981\660E\7D30\8868\55AE')
,p_lov_return_value=>'MASTERDETAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22140326341037134.4407)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\5728\7B2C\4E8C\500B\9801\9762\65B0\589E\5305\542B\7DE8\8F2F\8868\55AE\7684\5831\8868')
,p_lov_return_value=>'REPORTANDFORM'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>':MW_MIG_TYPE = ''forms'''
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_index_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(779055021223322673.4407)
,p_lov_name=>'CREATE INDEX TYPES'
,p_reference_id=>16028009107759017.4407
,p_lov_query=>'.'||wwv_flow_api.id(779055021223322673.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(779055926644322686.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E00\822C')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(779056103800322686.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6587\5B57')
,p_lov_return_value=>'T'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_app_auth_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19566418654904504.4407)
,p_lov_name=>'CREATE.APP.AUTH.OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.CLOUD_IDM'') d ,''CLOUD_IDM'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.SSO'') d ,''SSO'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''SSO''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'') d ,:PRODUCT_NAME v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'') d,''DBACCOUNT'' v',
'from dual',
'where wwv_flow_authentication_dev.get_internal_authentication <> ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'') d,''DATABASE'' v from dual',
')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_app_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(278595623975456113.4407)
,p_lov_name=>'CREATE_APP_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(278595623975456113.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(278595906950456118.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4EE5\79FB\8F49\5C08\6848\70BA\57FA\790E')
,p_lov_return_value=>'PROJECT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(278596129859456119.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6839\64DA\73FE\6709\7684\61C9\7528\7A0B\5F0F\8A2D\8A08\6A21\578B')
,p_lov_return_value=>'MODEL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_of_analyze_opts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6559316394304960.4407)
,p_lov_name=>'Copy of ANALYZE.OPTS'
,p_lov_query=>'.'||wwv_flow_api.id(6559316394304960.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6559609247304983.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\904B\7B97\7D71\8A08\8CC7\6599')
,p_lov_return_value=>'COMPUTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6559807151304993.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\9810\4F30\7D71\8A08\8CC7\6599')
,p_lov_return_value=>'ESTIMATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6560024790304993.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\9A57\8B49\7D50\69CB')
,p_lov_return_value=>'VALIDATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_of_icon_detail_view_modes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(241290016427713003.4407)
,p_lov_name=>'Copy of ICON DETAIL VIEW MODES'
,p_reference_id=>144167830179232748.4407
,p_lov_query=>'.'||wwv_flow_api.id(241290016427713003.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(241290918526713047.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5716\793A')
,p_lov_return_value=>'ICON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(241291116048713048.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\8A73\7D30\8CC7\8A0A')
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dialog_page_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(615826477066801787.4407)
,p_lov_name=>'DIALOG_PAGE_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(615826477066801787.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615826742248801788.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E00\822C')
,p_lov_return_value=>'NORMAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615827073250801790.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5F37\5236\56DE\61C9')
,p_lov_return_value=>'MODAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(615827346475801791.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\975E\5F37\5236\56DE\61C9')
,p_lov_return_value=>'NON_MODAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4400_create_table
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(424367108710438570.4407)
,p_lov_name=>'F4400_CREATE_TABLE'
,p_lov_query=>'.'||wwv_flow_api.id(424367108710438570.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(424367324433438573.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5EFA\7ACB')
,p_lov_return_value=>'Create'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(23186314994289784.4407)
,p_lov_name=>'FORM TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(23186314994289784.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23186609421289796.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8868\55AE')
,p_lov_return_value=>'FORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23186832278289798.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5217\8868\5316\8868\55AE')
,p_lov_return_value=>'TABULARFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(23751426549888921.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5831\8868\548C\8868\55AE')
,p_lov_return_value=>'REPORTANDFORM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6766305855658377.4407)
,p_lov_name=>'FORMAT_MASK_DYNAMIC'
,p_reference_id=>44798420131812391.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(268441300013663276.4407)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES'
,p_reference_id=>114314002567890312.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''S''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_no_since
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(171118603155556151.4407)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_NO_SINCE'
,p_reference_id=>170713321121898589.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps_no_since
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(171164920018528849.4407)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS_NO_SINCE'
,p_reference_id=>170713631164901556.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''T''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps_tzr_no_since
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(171165200063532532.4407)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS_TZR_NO_SINCE'
,p_reference_id=>170713910516904980.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''T''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''Z'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/forms_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(331159827266175078.4407)
,p_lov_name=>'FORMS_COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(331159827266175078.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331160122134175092.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8B66\793A')
,p_lov_return_value=>'ALERTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113499816654228536.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\9023\9644\7684\7A0B\5F0F\5EAB')
,p_lov_return_value=>'ATTACHEDLIBRARY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331160328106175093.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5340\584A')
,p_lov_return_value=>'BLOCKS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331160510369175093.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5DE5\4F5C\5340')
,p_lov_return_value=>'CANVAS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331160729137175094.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5EA7\6A19')
,p_lov_return_value=>'COORDINATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331160905420175094.4407)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\7DE8\8F2F\5668')
,p_lov_return_value=>'EDITOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331161120382175094.4407)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\503C\6E05\55AE')
,p_lov_return_value=>'LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331161317587175094.4407)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\7A0B\5F0F\55AE\5143')
,p_lov_return_value=>'PROGRAMUNIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331161500603175094.4407)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\7279\6027\985E\5225')
,p_lov_return_value=>'PROPERTYCLASS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331161924782175099.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8868\55AE\5C64\6B21\89F8\767C\7A0B\5F0F')
,p_lov_return_value=>'FORM_TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331162130759175099.4407)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\5340\584A\5C64\6B21\89F8\767C\7A0B\5F0F')
,p_lov_return_value=>'BLOCK_TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113500431891232878.4407)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\5831\8868')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331162319111175099.4407)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\9805\76EE\5C64\6B21\89F8\767C\7A0B\5F0F')
,p_lov_return_value=>'ITEM_TRIGGER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331162531912175099.4407)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\8996\7A97')
,p_lov_return_value=>'WINDOWS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331162703578175099.4407)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\8996\89BA\5C6C\6027')
,p_lov_return_value=>'VISUALATTRIBUTES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113500020463229557.4407)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\6A21\7D44\53C3\6578')
,p_lov_return_value=>'MODULEPARAMETER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113500223926230617.4407)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\7269\4EF6\7FA4\7D44')
,p_lov_return_value=>'OBJECTGROUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(113500602240233782.4407)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\529F\80FD\8868')
,p_lov_return_value=>'MENU'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(331161728166175099.4407)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\8A18\9304\7FA4\7D44')
,p_lov_return_value=>'RECORDGROUPS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/home_page_navigation
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22899924972899541.4407)
,p_lov_name=>'HOME PAGE NAVIGATION'
,p_lov_query=>'.'||wwv_flow_api.id(22899924972899541.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22900214896899554.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\542B\9805\76EE\7B26\865F\7684\5782\76F4\6E05\55AE (\672A\6392\5217)')
,p_lov_return_value=>'Vertical Unordered List with Bullets'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22900432663899556.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5782\76F4\5F71\50CF\6E05\55AE')
,p_lov_return_value=>'Vertical Images List'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22900605440899556.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6C34\5E73\5F71\50CF\6E05\55AE')
,p_lov_return_value=>'Horizontal Images with Label List'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_languages_locales
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19539723892904486.4407)
,p_lov_name=>'I18N_LANGUAGES_LOCALES'
,p_reference_id=>107899321117195063.4407
,p_lov_query=>'.'||wwv_flow_api.id(19539723892904486.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698786472456179874.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E9E\585E\62DC\7136\6587 (az)')
,p_lov_return_value=>'az'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698786890820179874.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5357\975E\8377\862D\6587 (af)')
,p_lov_return_value=>'af'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698787296072179874.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (ar)')
,p_lov_return_value=>'ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698787641295179874.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\963F\723E\53CA\5229\4E9E) (ar-dz)')
,p_lov_return_value=>'ar-dz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698788071294179875.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\5DF4\6797) (ar-bh)')
,p_lov_return_value=>'ar-bh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698788403355179876.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\57C3\53CA) (ar-eg)')
,p_lov_return_value=>'ar-eg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698788800314179876.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\4F0A\62C9\514B) (ar-iq)')
,p_lov_return_value=>'ar-iq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698789217423179876.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\7D04\65E6) (ar-jo)')
,p_lov_return_value=>'ar-jo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698789676849179876.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\79D1\5A01\7279) (ar-kw)')
,p_lov_return_value=>'ar-kw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698790081543179877.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\9ECE\5DF4\5AE9) (ar-lb)')
,p_lov_return_value=>'ar-lb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698790443720179877.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\5229\6BD4\4E9E) (ar-ly)')
,p_lov_return_value=>'ar-ly'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698790855400179877.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\6469\6D1B\54E5) (ar-ma)')
,p_lov_return_value=>'ar-ma'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698791238115179877.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\963F\66FC) (ar-om)')
,p_lov_return_value=>'ar-om'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698791657832179878.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\5361\9054) (ar-qa)')
,p_lov_return_value=>'ar-qa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698792012391179878.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\6C99\70CF\5730\963F\62C9\4F2F) (ar-sa)')
,p_lov_return_value=>'ar-sa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698792403971179878.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\6558\5229\4E9E) (ar-sy)')
,p_lov_return_value=>'ar-sy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698792884723179878.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\7A81\5C3C\897F\4E9E) (ar-tn)')
,p_lov_return_value=>'ar-tn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698793228694179879.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\963F\62C9\4F2F\806F\5408\5927\516C\570B) (ar-ae)')
,p_lov_return_value=>'ar-ae'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698793626097179879.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\8449\9580) (ar-ye)')
,p_lov_return_value=>'ar-ye'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698794023370179879.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\85A9\59C6\6587 (as)')
,p_lov_return_value=>'as'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698794405071179879.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5DF4\65AF\514B\6587 (eu)')
,p_lov_return_value=>'eu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698794839634179879.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\767D\4FC4\7F85\65AF\6587 (be)')
,p_lov_return_value=>'be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698795248405179880.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5B5F\52A0\62C9\6587 (bn)')
,p_lov_return_value=>'bn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698795681073179880.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FDD\52A0\5229\4E9E\6587 (bg)')
,p_lov_return_value=>'bg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698796097303179880.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\52A0\6CF0\7F85\5C3C\4E9E\6587 (ca)')
,p_lov_return_value=>'ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698796447786179880.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (zh)')
,p_lov_return_value=>'zh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698796891163179881.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\4E2D\570B) (zh-cn)')
,p_lov_return_value=>'zh-cn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698797247208179881.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\9999\6E2F\7279\5225\884C\653F\5340) (zh-hk)')
,p_lov_return_value=>'zh-hk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698797671146179881.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\6FB3\9580\7279\5225\884C\653F\5340) (zh-mo)')
,p_lov_return_value=>'zh-mo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698798024745179881.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\65B0\52A0\5761) (zh-sg)')
,p_lov_return_value=>'zh-sg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698798498343179882.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\53F0\7063) (zh-tw)')
,p_lov_return_value=>'zh-tw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698798896690179882.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\514B\7F85\57C3\897F\4E9E\6587 (hr)')
,p_lov_return_value=>'hr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698799268286179882.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6377\514B\6587 (cs)')
,p_lov_return_value=>'cs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698799697903179882.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E39\9EA5\6587 (da)')
,p_lov_return_value=>'da'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698800019642179882.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8377\862D\6587 (\6BD4\5229\6642) (nl-be)')
,p_lov_return_value=>'nl-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698800499981179883.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8377\862D\6587 (\8377\862D) (nl)')
,p_lov_return_value=>'nl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698800849305179883.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (en)')
,p_lov_return_value=>'en'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698801236660179883.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\6FB3\5927\5229\4E9E) (en-au)')
,p_lov_return_value=>'en-au'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698801685632179883.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\8C9D\91CC\65AF) (en-bz)')
,p_lov_return_value=>'en-bz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698802089534179884.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\52A0\62FF\5927) (en-ca)')
,p_lov_return_value=>'en-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698802479782179884.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\611B\723E\862D) (en-ie)')
,p_lov_return_value=>'en-ie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698802879248179884.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\7259\8CB7\52A0) (en-jm)')
,p_lov_return_value=>'en-jm'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698803262669179884.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\7D10\897F\862D) (en-nz)')
,p_lov_return_value=>'en-nz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698803655556179884.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\83F2\5F8B\8CD3) (en-ph)')
,p_lov_return_value=>'en-ph'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698804032738179885.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\5357\975E) (en-za)')
,p_lov_return_value=>'en-za'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698804445573179885.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\5343\91CC\9054) (en-tt)')
,p_lov_return_value=>'en-tt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698804878210179885.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\82F1\570B) (en-gb)')
,p_lov_return_value=>'en-gb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698805267219179886.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\7F8E\570B) (en-us)')
,p_lov_return_value=>'en-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698805612592179886.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\8F9B\5DF4\5A01) (en-zw)')
,p_lov_return_value=>'en-zw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698806010916179886.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\611B\6C99\5C3C\4E9E\6587 (et)')
,p_lov_return_value=>'et'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698806408764179886.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('FYRO \99AC\5176\9813\6587 (mk)')
,p_lov_return_value=>'mk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698806878098179886.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\7F85\6587 (fo)')
,p_lov_return_value=>'fo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698807215966179887.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CE2\65AF\6587 (fa)')
,p_lov_return_value=>'fa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698807621416179887.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\745E\58EB) (fr-ch)')
,p_lov_return_value=>'fr-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698808071617179887.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82AC\862D\6587 (fi)')
,p_lov_return_value=>'fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698808477060179887.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\6BD4\5229\6642) (fr-be)')
,p_lov_return_value=>'fr-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698808855199179888.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\52A0\62FF\5927) (fr-ca)')
,p_lov_return_value=>'fr-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698809277622179888.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\6CD5\570B) (fr)')
,p_lov_return_value=>'fr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698809647907179888.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\76E7\68EE\5821) (fr-lu)')
,p_lov_return_value=>'fr-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698810010431179888.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\6469\7D0D\54E5) (fr-mc)')
,p_lov_return_value=>'fr-mc'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698810453693179888.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\84CB\723E\6587 (gd)')
,p_lov_return_value=>'gd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698810849922179889.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\52A0\91CC\65AF\4E9E\6587 (gl)')
,p_lov_return_value=>'gl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698811288421179889.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\5967\5730\5229) (de-at)')
,p_lov_return_value=>'de-at'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698811693469179889.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\5FB7\570B) (de)')
,p_lov_return_value=>'de'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698812020330179889.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\5217\652F\6566\65AF\767B) (de-li)')
,p_lov_return_value=>'de-li'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698812433852179890.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\76E7\68EE\5821) (de-lu)')
,p_lov_return_value=>'de-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698812808048179890.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\745E\58EB) (de-ch)')
,p_lov_return_value=>'de-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698813279987179890.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5E0C\81D8\6587 (el)')
,p_lov_return_value=>'el'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698813657889179890.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\53E4\5409\62C9\7279\6587 (gu)')
,p_lov_return_value=>'gu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698814041270179890.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5E0C\4F2F\4F86\6587 (he)')
,p_lov_return_value=>'he'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698814453862179891.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5370\5EA6\6587 (hi)')
,p_lov_return_value=>'hi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698814823839179891.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5308\7259\5229\6587 (hu)')
,p_lov_return_value=>'hu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698815278907179891.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\51B0\5CF6\6587 (is)')
,p_lov_return_value=>'is'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698815699889179891.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5370\5C3C\6587 (id)')
,p_lov_return_value=>'id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698816032815179892.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7FA9\5927\5229\6587 (\7FA9\5927\5229) (it)')
,p_lov_return_value=>'it'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698816414819179892.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7FA9\5927\5229\6587 (\745E\58EB) (it-ch)')
,p_lov_return_value=>'it-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698816803076179892.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65E5\6587 (ja)')
,p_lov_return_value=>'ja'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698817225741179892.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\574E\90A3\9054\6587 (kn)')
,p_lov_return_value=>'kn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698817690591179892.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\54C8\85A9\514B\6587 (kk)')
,p_lov_return_value=>'kk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698818096413179893.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\574E\52A0\5C3C\6587 (kok)')
,p_lov_return_value=>'kok'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698818468658179893.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\97D3\6587 (ko)')
,p_lov_return_value=>'ko'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698818882696179893.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5409\723E\5409\65AF\6587 (kz)')
,p_lov_return_value=>'kz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698819283822179893.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\62C9\812B\7DAD\4E9E\6587 (lv)')
,p_lov_return_value=>'lv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698819682279179894.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7ACB\9676\5B9B\6587 (lt)')
,p_lov_return_value=>'lt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698820040653179894.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\4F86\6587 (\99AC\4F86\897F\4E9E) (ms)')
,p_lov_return_value=>'ms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698820472700179894.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\4F86\4E9E\62C9\59C6\6587 (ml)')
,p_lov_return_value=>'ml'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698820880864179894.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\8033\5B83\6587 (mt)')
,p_lov_return_value=>'mt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698821246037179894.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\62C9\5730\6587 (mr)')
,p_lov_return_value=>'mr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698821653168179895.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5C3C\5E15\91CC\6587 (\5370\5EA6) (ne)')
,p_lov_return_value=>'ne'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698822039761179895.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\632A\5A01\6587 (\5DF4\514B\6469) (nb-no)')
,p_lov_return_value=>'nb-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698822458324179895.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\632A\5A01\6587 (\5DF4\514B\6469) (no)')
,p_lov_return_value=>'no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698822844504179895.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\632A\5A01\6587 (\5C3C\6D1B\65AF\514B) (nn-no)')
,p_lov_return_value=>'nn-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698823262940179896.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6B50\91CC\4E9E\6587 (or)')
,p_lov_return_value=>'or'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698823650820179896.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CE2\862D\6587 (pl)')
,p_lov_return_value=>'pl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698824085245179896.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8461\8404\7259\6587 (\5DF4\897F) (pt-br)')
,p_lov_return_value=>'pt-br'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698824483574179896.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8461\8404\7259\6587 (\8461\8404\7259) (pt)')
,p_lov_return_value=>'pt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698824857811179897.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65C1\906E\666E\6587 (pa)')
,p_lov_return_value=>'pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698825242033179897.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7F85\99AC\5C3C\4E9E\6587 (ro)')
,p_lov_return_value=>'ro'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698825657515179897.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FC4\6587 (ru)')
,p_lov_return_value=>'ru'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698826033268179897.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FC4\6587 (\6469\723E\591A\74E6) (ru-md)')
,p_lov_return_value=>'ru-md'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698826447727179897.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\585E\723E\7DAD\4E9E\6587 (sr)')
,p_lov_return_value=>'sr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698826883742179898.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65AF\6D1B\4F10\514B\6587 (sk)')
,p_lov_return_value=>'sk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698827248060179898.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65AF\6D1B\7DAD\5C3C\4E9E\6587 (sl)')
,p_lov_return_value=>'sl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698827698889179898.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\963F\6839\5EF7) (es-ar)')
,p_lov_return_value=>'es-ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698828008659179898.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\73BB\5229\7DAD\4E9E) (es-bo)')
,p_lov_return_value=>'es-bo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698828419820179899.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\667A\5229) (es-cl)')
,p_lov_return_value=>'es-cl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698828827489179899.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\54E5\502B\6BD4\4E9E) (es-co)')
,p_lov_return_value=>'es-co'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698829250689179899.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\54E5\65AF\5927\9ECE\52A0) (es-cr)')
,p_lov_return_value=>'es-cr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698829613012179899.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\591A\660E\5C3C\52A0) (es-do)')
,p_lov_return_value=>'es-do'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698830063654179900.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5384\74DC\591A) (es-ec)')
,p_lov_return_value=>'es-ec'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698830452785179900.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\85A9\723E\74E6\591A) (es-sv)')
,p_lov_return_value=>'es-sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698830836737179900.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\74DC\5730\99AC\62C9) (es-gt)')
,p_lov_return_value=>'es-gt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698831285105179900.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5B8F\90FD\62C9\65AF) (es-hn)')
,p_lov_return_value=>'es-hn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698831678043179901.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\58A8\897F\54E5) (es-mx)')
,p_lov_return_value=>'es-mx'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698832011277179903.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5C3C\52A0\62C9\74DC) (es-ni)')
,p_lov_return_value=>'es-ni'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698832427325179903.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5DF4\62FF\99AC) (es-pa)')
,p_lov_return_value=>'es-pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698832844262179904.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5DF4\62C9\572D) (es-py)')
,p_lov_return_value=>'es-py'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698833208263179904.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\7955\9B6F) (es-pe)')
,p_lov_return_value=>'es-pe'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698833697740179904.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\6CE2\591A\9ECE\5404) (es-pr)')
,p_lov_return_value=>'es-pr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698834004413179904.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\50B3\7D71\6392\5E8F) (es)')
,p_lov_return_value=>'es'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698834404589179905.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\7F8E\570B) (es-us)')
,p_lov_return_value=>'es-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698834850205179905.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\70CF\62C9\572D) (es-uy)')
,p_lov_return_value=>'es-uy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698835266744179905.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\59D4\5167\745E\62C9) (es-ve)')
,p_lov_return_value=>'es-ve'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698835641919179905.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\745E\5178\6587 (sv)')
,p_lov_return_value=>'sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698836045941179905.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\745E\5178\6587 (\82AC\862D) (sv-fi)')
,p_lov_return_value=>'sv-fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698836410459179906.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5766\7C73\723E\6587 (ta)')
,p_lov_return_value=>'ta'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698836891303179906.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CF0\76E7\56FA\6587 (te)')
,p_lov_return_value=>'te'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698837282382179906.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CF0\6587 (th)')
,p_lov_return_value=>'th'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698837644073179906.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\571F\8033\5176\6587 (tr)')
,p_lov_return_value=>'tr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698838027876179907.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\514B\862D\6587 (uk)')
,p_lov_return_value=>'uk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698838446940179907.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\723E\90FD\6587 (ur)')
,p_lov_return_value=>'ur'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698838899583179907.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\8332\5225\514B\6587 (uz)')
,p_lov_return_value=>'uz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698839224984179907.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8D8A\5357\6587 (vi)')
,p_lov_return_value=>'vi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698839631950179908.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\611B\723E\862D\6587 (ga)')
,p_lov_return_value=>'ga'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698840044619179908.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5A01\723E\65AF\6587 (cy)')
,p_lov_return_value=>'cy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698840402430179908.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\53F2\74E6\5E0C\91CC\6587 (sw)')
,p_lov_return_value=>'sw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698840835706179908.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\723E\5DF4\5C3C\4E9E\6587')
,p_lov_return_value=>'sq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(698841208904179909.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E9E\7F8E\5C3C\4E9E\6587')
,p_lov_return_value=>'hy'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_detail_view_modes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(28047631397181065.4407)
,p_lov_name=>'ICON DETAIL VIEW MODES'
,p_lov_query=>'.'||wwv_flow_api.id(28047631397181065.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28047820343181089.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5716\793A')
,p_lov_return_value=>'ICON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28048010957181093.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8A73\7D30\8CC7\8A0A')
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/included_blocks
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(71133622522750477.4407)
,p_lov_name=>'INCLUDED BLOCKS'
,p_lov_query=>'.'||wwv_flow_api.id(71133622522750477.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(71133818029750477.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\50C5\9650\5305\62EC\7684\5340\584A')
,p_lov_return_value=>'INCLUDED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(71134019860750477.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\50C5\9650\672A\5305\62EC\7684\5340\584A')
,p_lov_return_value=>'NOT_INCLUDED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(71134200603750478.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\6240\6709\5340\584A\985E\578B')
,p_lov_return_value=>'ALL_TYPES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_analysis_pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(281095800411569999.4407)
,p_lov_name=>'INCLUDE_ANALYSIS_PAGES'
,p_lov_query=>'.'||wwv_flow_api.id(281095800411569999.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(281096107722570008.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5305\62EC\5206\6790\9801\9762')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_types_without_plugins
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(29578107222858066.4407)
,p_lov_name=>'ITEM_TYPES (WITHOUT PLUGINS)'
,p_reference_id=>29544521926748713.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_native_plugins varchar2(255);',
'begin',
'    l_native_plugins := '' union all select display_name as d, name_with_prefix as r from wwv_flow_native_plugins where plugin_type = ''''ITEM TYPE'''' order by 1'';',
'',
'    if lower(wwv_flow.g_flow_language) = ''en'' then',
'        return ''select display_name as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    else',
'        return ''select wwv_flow_lang.system_message(''''ITEM_TYPE.''''||name) as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    end if;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/language_derived_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19567918562904506.4407)
,p_lov_name=>'LANGUAGE_DERIVED_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(19567918562904506.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19568227054904506.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6C92\6709 NLS (\61C9\7528\7A0B\5F0F\6C92\6709\7FFB\8B6F)')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19568409975904506.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4F7F\7528\61C9\7528\7A0B\5F0F\4E3B\8981\8A9E\8A00')
,p_lov_return_value=>'FLOW_PRIMARY_LANGUAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19568622313904506.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\700F\89BD\5668 (\4F7F\7528\700F\89BD\5668\8A9E\8A00\504F\597D\8A2D\5B9A)')
,p_lov_return_value=>'BROWSER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19568832579904506.4407)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\61C9\7528\7A0B\5F0F\504F\597D\8A2D\5B9A (\4F7F\7528 FSP_LANGUAGE_PREFERENCE)')))
,p_lov_return_value=>'FLOW_PREFERENCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19569003053904506.4407)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\9805\76EE\504F\597D\8A2D\5B9A (\4F7F\7528\542B\6709\504F\597D\8A2D\5B9A\7684\9805\76EE)')
,p_lov_return_value=>'ITEM_PREFERENCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19348705994876274.4407)
,p_lov_name=>'LIST PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||'' ''||name n, id',
'from wwv_flow_steps',
'where flow_id = :FB_FLOW_ID and security_group_id = :flow_security_group_id',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_projects
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5342113361182830.4407)
,p_lov_name=>'LIST PROJECTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select migration_name, id',
'from WWV_FLOW_MIGRATION_PROJECTS',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_applications
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(113527305075764379.4407)
,p_lov_name=>'LIST_APPLICATIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'from   wwv_flows f',
'where  id != nvl(:P88_GENERATED_APPLICATION_ID,null) and',
'       security_group_id = :flow_security_group_id and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and ',
'         security_group_id = :flow_security_group_id) and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(28213431851608144.4407)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select upper(c.schema) d, upper(c.schema) v',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
'where  c.security_group_id = :flow_security_group_id and',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :flow_user and',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or',
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas_qb
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4966919116932394.4407)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS-QB'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_mode varchar2(255) := null;',
'  l_dba  boolean := false;',
'  q      varchar2(32767) := null;',
'begin',
'  l_mode :=  ''NORMAL'';',
'  for c1 in (select patch_name, patch_status',
'             from wwv_flow_patches',
'             where flow_id = 4500',
'             and security_group_id = 10',
'             and patch_status = ''INCLUDE''',
'             and patch_name = ''XE'')',
'  loop',
'    l_mode := ''XE'';',
'  end loop;',
'  for c1 in (select 1 ',
'             from sys.dba_role_privs ',
'             where grantee=upper(:APP_USER) ',
'             and granted_role in (''DBA'', ''SELECT_CATALOG_ROLE''))',
'  loop',
'    l_dba := true;',
'  end loop;',
'  if l_mode = ''XE'' then',
'    if l_dba then',
'    	q:=''select upper(u.username) d, upper(u.username) v '';',
'      q:=q||''from   sys.dba_users u '';           ',
'      q:=q||''where  nvl(:P1002_POPUP,0) <> 1 '';',
'      if :APP_USER != ''SYS'' then',
'      q:=q||''and u.username != ''''SYS'''' '';',
'      end if;',
'      q:=q||''union all '';',
'      q:=q||''select :P1002_SCHEMA a,:P1002_SCHEMA b from dual '';',
'      q:=q||''where  :P1002_POPUP = 1 '';',
'      q:=q||''order by 1'';',
'    end if;',
'  end if;',
'',
'  if q is null then',
'    q:=''select upper(c.schema) d, upper(c.schema) v '';',
'    q:=q||''from   wwv_flow_company_schemas c, ''; ',
'    q:=q||''       wwv_flow_fnd_user u ''; ',
'    q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'    q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'    q:=q||''       u.user_name = :flow_user and '';',
'    q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'    q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'    q:=q||''  and  nvl(:P1002_POPUP,0) <> 1 '';',
'    q:=q||''union all '';',
'    q:=q||''select :P1002_SCHEMA a,:P1002_SCHEMA b from dual '';',
'    q:=q||''where  :P1002_POPUP = 1 '';',
'    q:=q||''order by 1'';',
'  end if;',
'  return q;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas_sc
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4967007334932394.4407)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS-SC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_mode varchar2(255) := null;',
'  l_dba  boolean := false;',
'  q      varchar2(32767) := null;',
'begin',
'  l_mode :=  ''NORMAL'';',
'  for c1 in (select patch_name, patch_status',
'             from wwv_flow_patches',
'             where flow_id = 4500',
'             and security_group_id = 10',
'             and patch_status = ''INCLUDE''',
'             and patch_name = ''XE'')',
'  loop',
'    l_mode := ''XE'';',
'  end loop;  ',
'  for c1 in (select 1 ',
'             from sys.dba_role_privs ',
'             where grantee=upper(:APP_USER) ',
'             and granted_role in (''DBA'', ''SELECT_CATALOG_ROLE''))',
'  loop',
'    l_dba := true;',
'  end loop;',
'  if l_mode = ''XE'' then',
'  	if l_dba then      ',
'      q:=''select upper(u.username) d, upper(u.username) v '';',
'      q:=q||''from   sys.dba_users u '';',
'      q:=q||''where  nvl(:P1003_POPUP,0) <> 1 '';',
'      if :APP_USER != ''SYS'' then',
'      q:=q||''and u.username != ''''SYS'''' '';',
'      end if;',
'      q:=q||''union all '';',
'      q:=q||''select :P1003_SCHEMA a,:P1003_SCHEMA b from dual '';',
'      q:=q||''where  :P1003_POPUP = 1 '';',
'      q:=q||''order by 1'';           ',
'    end if;',
'  end if;',
'',
'  if q is null then',
'    q:=''select upper(c.schema) d, upper(c.schema) v '';',
'    q:=q||''from   wwv_flow_company_schemas c, '';',
'    q:=q||''       wwv_flow_fnd_user u '';',
'    q:=q||''where  c.security_group_id = :flow_security_group_id and '';',
'    q:=q||''       u.security_group_id = :flow_security_group_id and '';',
'    q:=q||''       u.user_name = :flow_user and '';',
'    q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';',
'    q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';',
'    q:=q||''  and  nvl(:P1003_POPUP,0) <> 1 '';',
'    q:=q||''union all '';',
'    q:=q||''select :P1003_SCHEMA a,:P1003_SCHEMA b from dual '';',
'    q:=q||''where  :P1003_POPUP = 1 '';',
'    q:=q||''order by 1'';',
'  end if;',
'  return q;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_list_templates
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(23674523555471642.4407)
,p_lov_name=>'LIST_LIST_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''LIST''',
'and name in (''Vertical Images List'',''Horizontal Images with Label List'',''Vertical Unordered List without Bullet'')',
'and flow_id = 187',
'order by upper(name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5506106131506937.4407)
,p_lov_name=>'LIST_SCHEMAS'
,p_reference_id=>26396713461308449.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select username d, username v',
'from sys.dba_users ',
'where wwv_flow_provisioning.restricted_schema_i(username,:APP_USER) = 0',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/maximum_rows_per_page
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19349011344876284.4407)
,p_lov_name=>'MAXIMUM ROWS PER PAGE'
,p_lov_query=>'.'||wwv_flow_api.id(19349011344876284.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19349327517876285.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19349505541876288.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19349701912876288.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19349928986876288.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19350112513876289.4407)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19350314621876289.4407)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19350509941876289.4407)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19350721995876289.4407)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'75'
,p_lov_return_value=>'75'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19350914041876289.4407)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19351126542876290.4407)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19351308795876290.4407)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19351512640876290.4407)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_a
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4967521946932394.4407)
,p_lov_name=>'MAX_ROWS_A'
,p_lov_query=>'.'||wwv_flow_api.id(4967521946932394.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4967613030932395.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4967731506932395.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4967816619932395.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4967913039932395.4407)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968020929932395.4407)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968115166932395.4407)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968226890932395.4407)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968310568932395.4407)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968403957932395.4407)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968528192932396.4407)
,p_lov_disp_sequence=>5000
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968627917932396.4407)
,p_lov_disp_sequence=>10000
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4968704410932396.4407)
,p_lov_disp_sequence=>100000
,p_lov_disp_value=>'100000'
,p_lov_return_value=>'100000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/max_rows_b
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(5888327993309845.4407)
,p_lov_name=>'MAX_ROWS_B'
,p_lov_query=>'.'||wwv_flow_api.id(5888327993309845.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5888521524309850.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5888718257309853.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5888903813309853.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5889109860309853.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5889315250309854.4407)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5889515427309854.4407)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5889710061309854.4407)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5889908308309854.4407)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5890109498309854.4407)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5890312245309855.4407)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5890505497309855.4407)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5890701112309855.4407)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'10000'
,p_lov_return_value=>'10000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(5890929510309855.4407)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'50000'
,p_lov_return_value=>'50000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/migration_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(718168754653526761.4407)
,p_lov_name=>'MIGRATION_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(718168754653526761.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(718169068502526763.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Access'
,p_lov_return_value=>'access'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(718169362410526764.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8868\55AE')
,p_lov_return_value=>'forms'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_link_extra_column
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6746916502658348.4407)
,p_lov_name=>'MODEL_LINK_EXTRA_COLUMN'
,p_lov_query=>'.'||wwv_flow_api.id(6746916502658348.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6747215160658348.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4F7F\7528\984D\5916\8CC7\6599\6B04\4F86\986F\793A\9023\7D50.')
,p_lov_return_value=>'LINK_COLUMN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_link_to_page
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(148499929862732707.4407)
,p_lov_name=>'MODEL_LINK_TO_PAGE'
,p_lov_query=>'.'||wwv_flow_api.id(148499929862732707.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(148500204265732708.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E3B\984C\7279\5B9A\7DE8\8F2F\6309\9215')
,p_lov_return_value=>'LINK_COLUMN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(148500408124732708.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5831\8868\8CC7\6599\6B04')
,p_lov_return_value=>'REPORT_COLUMN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(148500632543732708.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\81EA\8A02\9023\7D50')
,p_lov_return_value=>'CUSTOM_LINK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_page_columns_p11
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6743817071658321.4407)
,p_lov_name=>'MODEL_PAGE_COLUMNS P11'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols',
'where  model_region_id = :P11_REGION_ID'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_page_columns_p47
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(13439106662908793.4407)
,p_lov_name=>'MODEL_PAGE_COLUMNS P47'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols',
'where  model_region_id = :P47_REGION_ID'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_parent_page_columns_p11
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6744227823658338.4407)
,p_lov_name=>'MODEL_PARENT_PAGE_COLUMNS P11'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'   select id from wwv_flow_model_page_regions',
'   where model_page_id = (',
'       select id ',
'       from   wwv_flow_model_pages ',
'       where  model_id = :P33_MODEL_ID',
'       and    id  = :P11_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_parent_page_columns_p47
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(13439511856910336.4407)
,p_lov_name=>'MODEL_PARENT_PAGE_COLUMNS P47'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'  select id from wwv_flow_model_page_regions',
'  where model_page_id = (   ',
'         select id ',
'         from   wwv_flow_model_pages ',
'         where  model_id = :MW_MODEL_ID',
'         and    id  = :P47_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(280355617935739625.4407)
,p_lov_name=>'MODEL_USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct wwv_flow_escape.html(m.created_by) d, m.created_by r',
'from wwv_flow_models m, wwv_flow_model_pages p, wwv_flow_company_schemas s',
'where m.id = p.model_id ',
'and   m.owner = s.schema',
'and m.security_group_id = :flow_security_group_id',
'and s.security_group_id = :flow_security_group_id',
'and m.model_complete = ''Y''',
'group by m.created_by'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_use_theme_button
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6747416812658349.4407)
,p_lov_name=>'MODEL_USE_THEME_BUTTON'
,p_lov_query=>'.'||wwv_flow_api.id(6747416812658349.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6747724917658349.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4F7F\7528\4E3B\984C\7279\5B9A\7DE8\8F2F\6309\9215')
,p_lov_return_value=>'THEME'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(237819027746437948.4407)
,p_lov_name=>'OBJECT STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(237819027746437948.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(237819217974437950.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6709\6548')
,p_lov_return_value=>'VALID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(237819502129437953.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\7121\6548')
,p_lov_return_value=>'INVALID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(237819724006437953.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\4E0D\660E')
,p_lov_return_value=>'UNKNOWN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/orignal_or_new_or_custom
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(69216414083288226.4407)
,p_lov_name=>'ORIGNAL OR NEW OR CUSTOM'
,p_lov_query=>'.'||wwv_flow_api.id(69216414083288226.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(69216620463288226.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\539F\59CB\67E5\8A62')
,p_lov_return_value=>'ORIGINAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(69218031530302696.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\81EA\8A02\67E5\8A62')
,p_lov_return_value=>'CUSTOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(69216804670288228.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\589E\5F37\7684\67E5\8A62')
,p_lov_return_value=>'ENHANCED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p24_column_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(281552116966737419.4407)
,p_lov_name=>'P24_COLUMN_LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r',
'from sys.dba_tab_columns',
'where owner =  UPPER(:P24_SCHEMA)',
'  and table_name= UPPER(:P24_TABLE_NAME)',
'   and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)',
'order by column_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p62_report_type_interactive_or_classic
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(338405502932654457.4407)
,p_lov_name=>'P62_REPORT_TYPE:INTERACTIVE_OR_CLASSIC'
,p_lov_query=>'.'||wwv_flow_api.id(338405502932654457.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(338405823457654459.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E92\52D5\5F0F')
,p_lov_return_value=>'INTERACTIVE'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ui_type_dev.supports_feature ( ',
'    p_ui_type_id => :P29_UI_TYPE_ID,',
'    p_name       => ''INTERACTIVE_REPORT'' )'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(338406105072654461.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E00\822C')
,p_lov_return_value=>'CLASSIC'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ui_type_dev.supports_feature ( ',
'    p_ui_type_id => :P29_UI_TYPE_ID,',
'    p_name       => ''CLASSIC_REPORT'' )'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_icons
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(25461000358572316.4407)
,p_lov_name=>'PAGE ICONS'
,p_lov_query=>'.'||wwv_flow_api.id(25461000358572316.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27927008443557504.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9802\7AEF')
,p_lov_return_value=>'menu/prod_apex_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/prod_apex_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27928514246578089.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\61C9\7528\7A0B\5F0F')
,p_lov_return_value=>'menu/application_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/bboard_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27928123811571390.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\9577\689D\5716')
,p_lov_return_value=>'menu/chart_bar_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/books_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25461723903572329.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\544A\793A\677F')
,p_lov_return_value=>'menu/bboard_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/bug_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25461506215572329.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\66F8\7C4D')
,p_lov_return_value=>'menu/books_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/users_business_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25461911706572329.4407)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\932F\8AA4')
,p_lov_return_value=>'menu/bug_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/calendar_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27930717624597930.4407)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\5546\696D\4F7F\7528\8005')
,p_lov_return_value=>'menu/users_business_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/clipboard_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25549627004478874.4407)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\884C\4E8B\66C6')
,p_lov_return_value=>'menu/calendar_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/db_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25550216746485324.4407)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\884C\4E8B\66C6\9801\9762')
,p_lov_return_value=>'menu/calendar_page_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/key_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25550530252489286.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5F9E\5C6C\7AEF')
,p_lov_return_value=>'menu/client_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/disk_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27933210960614982.4407)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\526A\8CBC\7C3F')
,p_lov_return_value=>'menu/clipboard_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/download_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25550807526492173.4407)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\8CC7\6599\5EAB')
,p_lov_return_value=>'menu/db_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/draw_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25551112721493680.4407)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\958B\767C')
,p_lov_return_value=>'menu/prod_sqldev_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/edit_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25551417223494996.4407)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\78C1\789F')
,p_lov_return_value=>'menu/disk_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/folder_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25551724495497041.4407)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\4E0B\8F09')
,p_lov_return_value=>'menu/download_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/globe_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27936122566656168.4407)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\7E6A\88FD')
,p_lov_return_value=>'menu/draw_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/info_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25552000039499512.4407)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\52D5\614B')
,p_lov_return_value=>'menu/dynamic_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/lightbulb_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25555706619501355.4407)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\7DE8\8F2F')
,p_lov_return_value=>'menu/edit_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_line_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25556010774502580.4407)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\8CC7\6599\593E')
,p_lov_return_value=>'menu/folder_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/lock_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27938119365674134.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8CC7\6599\593E (\9EC3\8272)')
,p_lov_return_value=>'menu/folder_yellow_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/mail_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25462100534572330.4407)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('\8868\55AE')
,p_lov_return_value=>'menu/form_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/memo_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(29268301849698547.4407)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>unistr('\8868\55AE\8655\7406\4F5C\696D')
,p_lov_return_value=>'menu/form_proc_page_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/client_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25556316315504154.4407)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>unistr('\8868\55AE\7CBE\9748')
,p_lov_return_value=>'menu/form_wiz_page_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/navigation_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27947623137722547.4407)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>unistr('\5168\7403')
,p_lov_return_value=>'menu/globe_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/news_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25556821510505685.4407)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>unistr('\9996\9801')
,p_lov_return_value=>'menu/home_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/package_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25557326012506996.4407)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>unistr('\8CC7\8A0A')
,p_lov_return_value=>'menu/info_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/page_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25558107096510945.4407)
,p_lov_disp_sequence=>27
,p_lov_disp_value=>unistr('\7D22\5F15\9375')
,p_lov_return_value=>'menu/key_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/pdf_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27951931149753320.4407)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\71C8\6CE1'),
''))
,p_lov_return_value=>'menu/lightbulb_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/phone_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25560204157547933.4407)
,p_lov_disp_sequence=>29
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6298\7DDA\5716'),
''))
,p_lov_return_value=>'menu/chart_line_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_pie_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25560514200550899.4407)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9396\5B9A'),
''))
,p_lov_return_value=>'menu/lock_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/pin_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28462102374102568.4407)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>unistr('\908F\8F2F')
,p_lov_return_value=>'menu/login_64.gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25461325295572327.4407)
,p_lov_disp_sequence=>32
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\767B\5165'),
''))
,p_lov_return_value=>'menu/login_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/application_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25560819394552358.4407)
,p_lov_disp_sequence=>33
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\90F5\4EF6'),
''))
,p_lov_return_value=>'menu/mail_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/search_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561324374563259.4407)
,p_lov_disp_sequence=>34
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5730\5716'),
''))
,p_lov_return_value=>'menu/global_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/server_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561629915564829.4407)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5099\5FD8\9304'),
''))
,p_lov_return_value=>'menu/memo_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/shapes_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25561906150567460.4407)
,p_lov_disp_sequence=>36
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5C0E\89BD'),
''))
,p_lov_return_value=>'menu/navigation_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/spreadsheet_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(27956109725775505.4407)
,p_lov_disp_sequence=>37
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5C0E\89BD\9801'),
''))
,p_lov_return_value=>'menu/navigation_page_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/todo_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(25562214462569827.4407)
,p_lov_disp_sequence=>38
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\65B0\805E'),
''))
,p_lov_return_value=>'menu/news_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/users_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56856828845814360.4407)
,p_lov_disp_sequence=>39
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5957\88DD\7A0B\5F0F'),
''))
,p_lov_return_value=>'menu/package_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/folder_yellow_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56858230839833869.4407)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9801\9762'),
''))
,p_lov_return_value=>'menu/page_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/global_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56859913440847773.4407)
,p_lov_disp_sequence=>41
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9801\9762\5716\8868'),
''))
,p_lov_return_value=>'menu/chart_page_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_page_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56860321751850200.4407)
,p_lov_disp_sequence=>42
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'PDF',
''))
,p_lov_return_value=>'menu/pdf_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_bar_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56860908722855900.4407)
,p_lov_disp_sequence=>43
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\96FB\8A71\865F\78BC'),
''))
,p_lov_return_value=>'menu/phone_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/calendar_page_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56867325654908047.4407)
,p_lov_disp_sequence=>44
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5713\9905\5716'),
''))
,p_lov_return_value=>'menu/chart_pie_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/dynamic_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56867603621911220.4407)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\56FA\5B9A'),
''))
,p_lov_return_value=>'menu/form_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/form_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28473627168374611.4407)
,p_lov_disp_sequence=>46
,p_lov_disp_value=>unistr('\5370\8868\6A5F')
,p_lov_return_value=>'menu/printer_64.gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56867912625913730.4407)
,p_lov_disp_sequence=>47
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5831\8868'),
''))
,p_lov_return_value=>'menu/report_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/home_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56868224053917050.4407)
,p_lov_disp_sequence=>48
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\641C\5C0B'),
''))
,p_lov_return_value=>'menu/search_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/login_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56868509078931677.4407)
,p_lov_disp_sequence=>49
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4F3A\670D\5668'),
''))
,p_lov_return_value=>'menu/server_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/prod_sqldev_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56868816350933757.4407)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5716\5F62'),
''))
,p_lov_return_value=>'menu/shapes_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/report_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56869125700936489.4407)
,p_lov_disp_sequence=>51
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8A66\7B97\8868'),
''))
,p_lov_return_value=>'menu/spreadsheet_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/tabform_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28475821037505347.4407)
,p_lov_disp_sequence=>52
,p_lov_disp_value=>unistr('\652F\63F4\7684\7269\4EF6')
,p_lov_return_value=>'menu/supporting_obj_64.gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56869407824940725.4407)
,p_lov_disp_sequence=>53
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5217\8868\5316\8868\55AE'),
''))
,p_lov_return_value=>'menu/tabform_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/trafficlight_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(56869716135943137.4407)
,p_lov_disp_sequence=>54
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5F85\8FA6\4E8B\9805\6E05\55AE'),
''))
,p_lov_return_value=>'menu/todo_64.gif'
,p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/tree_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(18140600744431403.4407)
,p_lov_disp_sequence=>55
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6D41\91CF\6307\793A'),
''))
,p_lov_return_value=>'menu/trafficlight_64.gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28477411602521473.4407)
,p_lov_disp_sequence=>56
,p_lov_disp_value=>unistr('\8CC7\6E90\56DE\6536')
,p_lov_return_value=>'menu/trash_64.gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(18140908709433629.4407)
,p_lov_disp_sequence=>57
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6A39\72C0\7D50\69CB'),
''))
,p_lov_return_value=>'menu/tree_64.gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(28478629610526666.4407)
,p_lov_disp_sequence=>58
,p_lov_disp_value=>'UI'
,p_lov_return_value=>'menu/ui_64.gif'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(18141630872440099.4407)
,p_lov_disp_sequence=>59
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4F7F\7528\8005'),
''))
,p_lov_return_value=>'menu/users_64.gif'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_source
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6596415880390663.4407)
,p_lov_name=>'PAGE SOURCE'
,p_lov_query=>'.'||wwv_flow_api.id(6596415880390663.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6596717246390682.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8868\683C')
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6596923554390682.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('SQL \67E5\8A62')
,p_lov_return_value=>'QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22078515151918053.4407)
,p_lov_name=>'PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(22078515151918053.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22078822992918064.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7A7A\767D')
,p_lov_return_value=>'BLANK'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22079009655918067.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5831\8868')
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#|native-sql-report'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'MW_MIG_TYPE'
,p_lov_disp_cond2=>'forms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22079224798918067.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8868\55AE')
,p_lov_return_value=>'FORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'MW_MIG_TYPE'
,p_lov_disp_cond2=>'forms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22079425635918067.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5217\8868\5316\8868\55AE')
,p_lov_return_value=>'TABULARFORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-tabular'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'MW_MIG_TYPE'
,p_lov_disp_cond2=>'forms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22079828922918067.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\4E3B\8981\660E\7D30')
,p_lov_return_value=>'MASTERDETAIL'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-master-detail'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'MW_MIG_TYPE'
,p_lov_disp_cond2=>'forms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22079600519918067.4407)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\5831\8868\548C\8868\55AE')
,p_lov_return_value=>'REPORTANDFORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-table-report'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'MW_MIG_TYPE'
,p_lov_disp_cond2=>'forms'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6575418257362951.4407)
,p_lov_name=>'PAGE TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(6575418257362951.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6575711448362973.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7A7A\767D')
,p_lov_return_value=>'BLANK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6575932241362977.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5831\8868')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6576110760362977.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8868\55AE')
,p_lov_return_value=>'FORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6576316945362977.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5217\8868\5316\8868\55AE')
,p_lov_return_value=>'TABULARFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6576530807362977.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5831\8868\548C\8868\55AE')
,p_lov_return_value=>'REPORTANDFORM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14320426249107116.4407)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\4E3B\8981\660E\7D30')
,p_lov_return_value=>'MASTERDETAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(230281621768293053.4407)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\9023\81F3\53E6\4E00\500B\5340\584A')
,p_lov_return_value=>'RELATED'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'77'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_icons_2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(18047316880000789.4407)
,p_lov_name=>'PAGE_ICONS_2'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select icon_name d, icon_name r',
'from WWV_FLOW_STANDARD_ICONS',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_source_002
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6744724810658339.4407)
,p_lov_name=>'PAGE_SOURCE'
,p_lov_query=>'.'||wwv_flow_api.id(6744724810658339.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6745016970658341.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8868\683C')
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6745208269658342.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('SQL \67E5\8A62')
,p_lov_return_value=>'QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6745404220658342.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8A66\7B97\8868\8CC7\6599')
,p_lov_return_value=>'SPREADSHEET'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/preserve_case_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(779187723922628339.4407)
,p_lov_name=>'PRESERVE.CASE.Y'
,p_reference_id=>88034811582507798.4407
,p_lov_query=>'.'||wwv_flow_api.id(779187723922628339.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(779188327836628367.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7DAD\6301\539F\4F86\5927\5C0F\5BEB\6A23\5F0F')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/priority
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(314799204604794684.4407)
,p_lov_name=>'PRIORITY'
,p_lov_query=>'.'||wwv_flow_api.id(314799204604794684.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(314799525641794689.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(314799718960794691.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'2'
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(314799927311794692.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'3'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(314800130270794692.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'4'
,p_lov_return_value=>'4'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(314800326438794693.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report_type_interactive_or_classic
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(148634518096505157.4407)
,p_lov_name=>'REPORT TYPE: INTERACTIVE OR CLASSIC'
,p_lov_query=>'.'||wwv_flow_api.id(148634518096505157.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(148634809457505157.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E92\52D5\5F0F')
,p_lov_return_value=>'INTERACTIVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(148635018301505157.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E00\822C')
,p_lov_return_value=>'CLASSIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/search_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2036623110176721.4407)
,p_lov_name=>'SEARCH_TYPE'
,p_reference_id=>246393217654948737.4407
,p_lov_query=>'.'||wwv_flow_api.id(2036623110176721.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(436684516000776967.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5927\5C0F\5BEB\9808\76F8\7B26')
,p_lov_return_value=>'CASE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_themes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(209126013152124776.4407)
,p_lov_name=>'SHOW THEMES'
,p_reference_id=>131260202585040081.4407
,p_lov_query=>'.'||wwv_flow_api.id(209126013152124776.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(209128020706124786.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\4E3B\984C')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(209128300783124786.4407)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\6A19\6E96\4E3B\984C')
,p_lov_return_value=>'STANDARD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(209128632624124786.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\81EA\8A02\4E3B\984C')
,p_lov_return_value=>'CUSTOM'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'800'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(209128931739124786.4407)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\820A\6709\4E3B\984C')
,p_lov_return_value=>'LEGACY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/source_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6520502328008192.4407)
,p_lov_name=>'SOURCE TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(6520502328008192.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6520822731008222.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8868\683C')
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6521010279008227.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\67E5\8A62')
,p_lov_return_value=>'QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6521202295008227.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('SQL \67E5\8A62')
,p_lov_return_value=>'SQL Query'
);
end;
/
prompt --application/shared_components/user_interface/lovs/source_object_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(241894613225273397.4407)
,p_lov_name=>'SOURCE_OBJECT_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(241894613225273397.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(241894832568273400.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('SQL \67E5\8A62')
,p_lov_return_value=>'SQL Query'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(241895018506273408.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\67E5\8A62')
,p_lov_return_value=>'QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(241895204500273408.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8868\683C')
,p_lov_return_value=>'TABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/standard_icon_size
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(115145707173040879.4407)
,p_lov_name=>'STANDARD_ICON_SIZE'
,p_lov_query=>'.'||wwv_flow_api.id(115145707173040879.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(115146201225040887.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'32x32'
,p_lov_return_value=>'32'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(115146031566040882.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'64x64'
,p_lov_return_value=>'64'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(145547208987259826.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'128x128'
,p_lov_return_value=>'128'
);
end;
/
prompt --application/shared_components/user_interface/lovs/tabs_for_800
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19566729798904505.4407)
,p_lov_name=>'TABS (FOR 800)'
,p_lov_query=>'.'||wwv_flow_api.id(19566729798904505.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567011806904505.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6C92\6709\9801\7C64')
,p_lov_return_value=>'NO_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567207329904505.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E00\5C64\9801\7C64')
,p_lov_return_value=>'SINGLE_LEVEL_TABS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(19567402803904505.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5169\5C64\9801\7C64')
,p_lov_return_value=>'TWO_LEVEL_TABS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/tabular_form_display_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6763505062658374.4407)
,p_lov_name=>'TABULAR_FORM_DISPLAY_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(6763505062658374.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6763828443658375.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A19\6E96\5831\8868\8CC7\6599\6B04')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6764005501658375.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\986F\793A\70BA\6587\5B57 (\4EE5 LOV \70BA\57FA\790E, \4E0D\5132\5B58\72C0\614B)')
,p_lov_return_value=>'TEXT_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6764214659658375.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\986F\793A\70BA\6587\5B57 (\5132\5B58\72C0\614B)')
,p_lov_return_value=>'DISPLAY_AND_SAVE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6764428704658375.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\986F\793A\70BA\6587\5B57 (\9041\96E2\7279\6B8A\5B57\5143, \4E0D\5132\5B58\72C0\614B)')
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6764615041658375.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\65E5\671F\9078\64C7\5668')
,p_lov_return_value=>'DATE_POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6764808473658376.4407)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\6587\5B57\6B04\4F4D')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6765021286658376.4407)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\6587\5B57\5340')
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6765214134658376.4407)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\9078\53D6\6E05\55AE (\975C\614B LOV)')
,p_lov_return_value=>'SELECT_LIST'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6765413782658376.4407)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\9078\53D6\6E05\55AE (\5177\540D\7684 LOV)')
,p_lov_return_value=>'SELECT_LIST_FROM_LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6765614697658376.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9078\53D6\6E05\55AE (\61C9\7528\67E5\8A62\7684 LOV)')
,p_lov_return_value=>'SELECT_LIST_FROM_QUERY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6765826112658376.4407)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\96B1\85CF ')
,p_lov_return_value=>'HIDDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6766003237658377.4407)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\5373\73FE\5F0F LOV (\5177\540D\7684 LOV)')
,p_lov_return_value=>'POPUP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6766204719658377.4407)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\5373\73FE\5F0F LOV (\61C9\7528\67E5\8A62\7684 LOV)')
,p_lov_return_value=>'POPUP_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/theme_list_for_ws_preferences
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(19567622224904505.4407)
,p_lov_name=>'THEME LIST FOR WS PREFERENCES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.theme_name)||'' (''|| wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||'')''||',
'       ''<a href="#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="theme_''||t.theme_id||''"></a>'' display_value,',
'       to_char(t.theme_id) theme_id',
'       from wwv_flow_themes t, wwv_flow_user_interfaces ui ',
'      where t.security_group_id in (11,12)',
'        and (t.THEME_SECURITY_GROUP_ID is null ',
'            or t.THEME_SECURITY_GROUP_ID = :flow_security_group_id) ',
'        and t.flow_id in (',
'              select id from wwv_flows f',
'               where (',
'                    (:P49_SHOW = ''ALL''      and f.application_type in (''STANDARD'',''THEME'')) or ',
'                    (:P49_SHOW = ''CUSTOM''   and f.application_type = ''STANDARD'') or ',
'                    (:P49_SHOW = ''STANDARD'' and f.application_type = ''THEME'') or',
'                    (:P49_SHOW = ''LEGACY''   and f.application_type = ''THEME'')',
'               ) ',
'               and f.security_group_id in (11,12)',
'               )',
'        and (',
'          (:P49_SHOW = ''STANDARD'' and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') > 0 ) or',
'          (:P49_SHOW in (''LEGACY'',''CUSTOM'' ) and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') = 0 ) or',
'          (:P49_SHOW = ''ALL'')',
'        )  ',
'        and ui.flow_id = t.flow_id',
'        and ui.theme_id = t.theme_id',
'        and ui.ui_type_id = :P49_UI_TYPE_ID',
'        order by t.flow_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/theme_list
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(21420921045690180.4407)
,p_lov_name=>'THEME_LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''<br/><a href="f?p=4400:''||:P50_NEXT||'':&SESSION.::::THEME_ID:''||t.theme_id||''"><img src="#IMAGE_PREFIX#themes/theme_''||t.theme_id||''/themeshot.png" alt="''||wwv_flow_lang.system_message('''
||'THEME'')||'' ''||t.theme_id||''" title="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" width="150" height="80" class="htmldbthemeshots" /></a>'' display_value, t.theme_id ',
'from (',
'    select substr(object_name,16) theme_id ',
'    from   user_objects ',
'    where  object_name like ''WWV_FLOW_THEME_%''',
'    and    object_type = ''PACKAGE''',
'    and    substr(object_name,16) in (',
'        ''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'',',
'        ''11'',''12'',''13'',''14'',''15'',''16'',''17'',''18'',''19'',''20'',',
'        ''21'',''22'',''23'',''24'',''25'',''26'',''27'',''28'',''29'',''30'',',
'        ''31'',''32'',''33'',''34'',''35'',''36'',''37'',''38'',''39'',''40'',',
'        ''41'',''42'',''43'',''44'',''45'',''46'',''47'',''48'',''49'',''50'',',
'        ''51'',''52'',''53'',''54'',''55'',''56'',''57'',''58'',''59'',''60'',',
'        ''61'',''62'',''63'',''64'',''65'',''66'',''67'',''68'',''69'',''70'',',
'        ''71'',''72'',''73'',''74'',''75'',''76'',''77'',''78'',''79'',''80'',',
'        ''81'',''82'',''83'',''84'',''85'',''86'',''87'',''88'',''89'',''90'',',
'        ''91'',''92'',''93'',''94'',''95'',''96'',''97'',''98'',''99'',''100''',
'    )',
') t',
'order by to_number(t.theme_id)',
'',
'',
'',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/theme_list_forms
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(252487730157991211.4407)
,p_lov_name=>'THEME_LIST_FORMS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.theme_name)||'' (''|| wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||'')''||case when t.theme_id in (8,10,14,15,16,18,19,20) then '' *'' end||''<a href="f?p=4400:''||:P138_NEXT||    ',
'       '':''||:APP_SESSION||''::::THEME_ID:''|| t.id ||    ',
'       ''"><img src="#IMAGE_PREFIX#f_spacer.gif" class="theme_''||t.theme_id||''"></a>'' display_value,',
'       to_char(t.theme_id) theme_app_id',
'       from wwv_flow_themes t, wwv_flow_user_interfaces ui ',
'      where t.security_group_id in (11,12) ',
'        and (t.THEME_SECURITY_GROUP_ID is null ',
'            or t.THEME_SECURITY_GROUP_ID = :flow_security_group_id) ',
'        and t.flow_id in (',
'              select id from wwv_flows f',
'               where (',
'                    (:P138_SHOW = ''ALL''      and f.application_type in (''STANDARD'',''THEME'')) or ',
'                    (:P138_SHOW = ''CUSTOM''   and f.application_type = ''STANDARD'') or ',
'                    (:P138_SHOW = ''STANDARD'' and f.application_type = ''THEME'') or',
'                    (:P138_SHOW = ''LEGACY''   and f.application_type = ''THEME'')',
'               ) ',
'               and f.security_group_id in (11,12)',
'               )',
'        and (',
'          (:P138_SHOW = ''STANDARD'' and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') > 0 ) or',
'          (:P138_SHOW in (''LEGACY'',''CUSTOM'' ) and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') = 0 ) or',
'          (:P138_SHOW = ''ALL'')',
'        )  ',
'        and ui.flow_id = t.flow_id',
'        and ui.theme_id = t.theme_id',
'        and ui.ui_type_id = :P29_UI_TYPE_ID',
'        order by t.flow_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/theme_list_pg50
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(209409616694693111.4407)
,p_lov_name=>'THEME_LIST_PG50'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.theme_name)||'' (''|| wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||'')''||case when t.theme_id in (8,10,14,15,16,18,19,20) then '' *'' end||''<a href="f?p=4400:''||:P50_NEXT||'':&SESSION.::::THEME_ID:''||t.id||''"><img s'
||'rc="#IMAGE_PREFIX#f_spacer.gif" class="theme-preview theme_''||t.theme_id||''"></a>'' display_value,',
'       to_char(t.id) theme_app_id',
'       from wwv_flow_themes t, wwv_flow_user_interfaces ui ',
'      where t.security_group_id = 12 ',
'        and (t.THEME_SECURITY_GROUP_ID is null ',
'            or t.THEME_SECURITY_GROUP_ID = :flow_security_group_id) ',
'        and t.flow_id in (',
'              select id from wwv_flows f',
'               where',
'                    (:P50_SHOW = ''STANDARD'' and f.application_type = ''THEME'') ',
'               and f.security_group_id = 12',
'               )',
'        and',
'          (:P50_SHOW = ''STANDARD'' and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') > 0 )',
'        and ui.flow_id = t.flow_id',
'        and ui.theme_id = t.theme_id',
'        and ui.ui_type_id = 1',
'        order by t.flow_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/theme_list_pg60
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(209438317312787904.4407)
,p_lov_name=>'THEME_LIST_PG60'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.theme_name)||'' (''|| wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||'')''||',
'       ''<a href="#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="theme_''||t.theme_id||''"></a>'' display_value,',
'       to_char(t.theme_id) theme_id',
'       from wwv_flow_themes t, wwv_flow_user_interfaces ui ',
'      where t.security_group_id in (11,12) ',
'        and (t.THEME_SECURITY_GROUP_ID is null ',
'            or t.THEME_SECURITY_GROUP_ID = :flow_security_group_id) ',
'        and t.flow_id in (',
'              select id from wwv_flows f',
'               where (',
'                    (:P60_SHOW = ''ALL''      and f.application_type in (''STANDARD'',''THEME'')) or ',
'                    (:P60_SHOW = ''CUSTOM''   and f.application_type = ''STANDARD'') or ',
'                    (:P60_SHOW = ''STANDARD'' and f.application_type = ''THEME'') or',
'                    (:P60_SHOW = ''LEGACY''   and f.application_type = ''THEME'')',
'               ) ',
'               and f.security_group_id in (11,12)',
'               )',
'        and (',
'          (:P60_SHOW = ''STANDARD'' and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') > 0 ) or',
'          (:P60_SHOW in (''LEGACY'',''CUSTOM'' ) and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') = 0 ) or',
'          (:P60_SHOW = ''ALL'')',
'        )  ',
'        and ui.flow_id = t.flow_id',
'        and ui.theme_id = t.theme_id',
'        and ui.ui_type_id = :P60_UI_TYPE_ID',
'        order by t.flow_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/tracking_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(315692701788575763.4407)
,p_lov_name=>'TRACKING.Y'
,p_lov_query=>'.'||wwv_flow_api.id(315692701788575763.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(315693011339575765.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/true_false_returns_true_false
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(316558909921607180.4407)
,p_lov_name=>'TRUE_FALSE_RETURNS_TRUE_FALSE'
,p_lov_query=>'.'||wwv_flow_api.id(316558909921607180.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(316559227102607184.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\771F')
,p_lov_return_value=>'true'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(316559418608607187.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'false'
);
end;
/
prompt --application/shared_components/user_interface/lovs/true_false_returns_yes_no
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(14399402420296792.4407)
,p_lov_name=>'TRUE_FALSE_RETURNS_YES_NO'
,p_lov_query=>'.'||wwv_flow_api.id(14399402420296792.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14399716540296797.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'true'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(14399901308296801.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'false'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_type_returns_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(209175006581217113.4407)
,p_lov_name=>'UI TYPE (RETURNS ID)'
,p_reference_id=>5268701303966420.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_name,',
'       id',
'  from wwv_flow_ui_types_dev',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ui_types_returns_name
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(209175310838217114.4407)
,p_lov_name=>'UI TYPES (RETURNS NAME)'
,p_reference_id=>5267730430927525.4407
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_name,',
'       name',
'  from wwv_flow_ui_types_dev',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/unique
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(779206215728670740.4407)
,p_lov_name=>'UNIQUE'
,p_reference_id=>88045300809552005.4407
,p_lov_query=>'.'||wwv_flow_api.id(779206215728670740.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(779206802692670742.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\552F\4E00')
,p_lov_return_value=>'UNIQUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/upload_file_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(76748016384925027.4407)
,p_lov_name=>'UPLOAD FILE OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(76748016384925027.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(76748312620925030.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('Forms \6A21\7D44 (_fmb.XML)')
,p_lov_return_value=>'FMB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(76748711484925032.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Oracle \5831\8868 (.XML)')
,p_lov_return_value=>'RPT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(76748522028925031.4407)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('PL/SQL \7A0B\5F0F\5EAB (.PLD)')
,p_lov_return_value=>'PLD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(79703010333991913.4407)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('Forms \529F\80FD\8868 (_mmb.XML)')
,p_lov_return_value=>'MMB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(79702822669986011.4407)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\7269\4EF6\7A0B\5F0F\5EAB (_olb.XML)')
,p_lov_return_value=>'OLB'
);
end;
/
prompt --application/shared_components/user_interface/lovs/y_n_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4991900002932438.4407)
,p_lov_name=>'Y.N.RETURNS.Y.N'
,p_lov_query=>'.'||wwv_flow_api.id(4991900002932438.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4992022817932438.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4992123292932438.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4992221700932438.4407)
,p_lov_name=>'YES.NO.RETURNS.Y.N'
,p_lov_query=>'.'||wwv_flow_api.id(4992221700932438.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4992326341932438.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4992416805932439.4407)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_checkbox
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4992521041932439.4407)
,p_lov_name=>'YES_CHECKBOX'
,p_lov_query=>'.'||wwv_flow_api.id(4992521041932439.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4992616669932439.4407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_n_or_y
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6766513696658378.4407)
,p_lov_name=>'YES_NO_RETURNS_N_OR_Y'
,p_lov_query=>'.'||wwv_flow_api.id(6766513696658378.4407)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6766813651658378.4407)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6767008938658378.4407)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(4994007614932454.4407)
,p_name=>' Breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1852527796058283.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('UI \9810\8A2D\503C')
,p_link=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:::'
,p_page_id=>37
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4994410640932460.4407)
,p_parent_id=>wwv_flow_api.id(20842908981034432.4407)
,p_short_name=>unistr('\61C9\7528\7A0B\5F0F\79FB\8F49')
,p_long_name=>unistr('\61C9\7528\7A0B\5F0F\79FB\8F49')
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5047002619003400.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\9996\9801')
,p_long_name=>unistr('\9996\9801')
,p_link=>'f?p=4500:1000:&SESSION.'
,p_page_id=>9999
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5164414899585897.4407)
,p_parent_id=>wwv_flow_api.id(4994410640932460.4407)
,p_short_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5332106319124470.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\522A\9664\5C08\6848')
,p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5495426866329726.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&FLOW_ID.:31:&SESSION.'
,p_page_id=>31
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5512616046380372.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&FLOW_ID.:39:&SESSION.'
,p_page_id=>39
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5531832640387831.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&FLOW_ID.:35:&SESSION.'
,p_page_id=>35
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(6732704381658181.4407)
,p_parent_id=>wwv_flow_api.id(5495426866329726.4407)
,p_short_name=>unistr('\65B0\9801\9762\5B9A\7FA9')
,p_link=>'f?p=&FLOW_ID.:11:&SESSION.'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(12617917013422394.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\5DF2\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.:::'
,p_page_id=>38
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(19535527057904468.4407)
,p_parent_id=>wwv_flow_api.id(4994410640932460.4407)
,p_short_name=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\9810\8A2D\503C')
,p_link=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.:::'
,p_page_id=>49
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(20842908981034432.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('<span class="u-VisuallyHidden">\61C9\7528\7A0B\5F0F\7522\751F\5668</span><span class="a-Icon icon-breadcrumb-previous" title="App Builder"></span>')
,p_link=>'f?p=4000:1500:&SESSION.'
,p_page_id=>4000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(21418918533690149.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>'&GEN_APP_CRUMB.'
,p_link=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:::'
,p_page_id=>50
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(27366508860204008.4407)
,p_parent_id=>wwv_flow_api.id(4994410640932460.4407)
,p_short_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_link=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::'
,p_page_id=>18
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(58428218287642891.4407)
,p_parent_id=>wwv_flow_api.id(322259821468692912.4407)
,p_short_name=>unistr('\5927\91CF\8B8A\66F4\9805\76EE')
,p_link=>'f?p=&FLOW_ID.:100:&SESSION.'
,p_page_id=>100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(67812632259194284.4407)
,p_parent_id=>wwv_flow_api.id(260269631013106353.4407)
,p_short_name=>unistr('\5927\91CF\8B8A\66F4 ')
,p_link=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::'
,p_page_id=>101
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(69193914408159567.4407)
,p_parent_id=>wwv_flow_api.id(314846432313713329.4407)
,p_short_name=>unistr('\8A2D\5B9A\5340\584A\9805\76EE\548C\89F8\767C\7A0B\5F0F\72C0\614B')
,p_link=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.:::'
,p_page_id=>76
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(71524122450032240.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('PL/SQL \7A0B\5F0F\5EAB')
,p_link=>'f?p=&FLOW_ID.:90:&SESSION.'
,p_page_id=>90
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(71623306452950668.4407)
,p_parent_id=>wwv_flow_api.id(71524122450032240.4407)
,p_short_name=>unistr('PL/SQL \7A0B\5F0F\5EAB\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:103:&SESSION.'
,p_page_id=>103
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(75218203617037177.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\5831\8868')
,p_link=>'f?p=&FLOW_ID.:107:&SESSION.'
,p_page_id=>107
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(75920600240856311.4407)
,p_parent_id=>wwv_flow_api.id(75218203617037177.4407)
,p_short_name=>unistr('\5831\8868\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.:::'
,p_page_id=>112
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(75934325053018651.4407)
,p_parent_id=>wwv_flow_api.id(75920600240856311.4407)
,p_short_name=>unistr('\5831\8868\8CC7\6599\9805\76EE\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:113:&SESSION.::&DEBUG.:::'
,p_page_id=>113
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(77348924309021199.4407)
,p_parent_id=>wwv_flow_api.id(4994410640932460.4407)
,p_short_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_link=>'f?p=&FLOW_ID.:106:&SESSION.'
,p_page_id=>106
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(79921005251148798.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\8868\55AE\529F\80FD\8868')
,p_link=>'f?p=&FLOW_ID.:108:&SESSION.'
,p_page_id=>108
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(104189931859822319.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\7DE8\8F2F\532F\5165\7684\8868\55AE\529F\80FD\8868')
,p_link=>'f?p=&FLOW_ID.:110:&SESSION.'
,p_page_id=>110
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(104245312994180290.4407)
,p_parent_id=>wwv_flow_api.id(79921005251148798.4407)
,p_short_name=>unistr('\8868\55AE\529F\80FD\8868\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:118:&SESSION.'
,p_page_id=>118
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(104269823031419198.4407)
,p_parent_id=>wwv_flow_api.id(104245312994180290.4407)
,p_short_name=>unistr('\8868\55AE\529F\80FD\8868\9805\76EE\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:119:&SESSION.'
,p_page_id=>119
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(104423214485138477.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\8868\55AE\529F\80FD\8868')
,p_link=>'f?p=&FLOW_ID.:120:&SESSION.'
,p_page_id=>120
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(106685629699912197.4407)
,p_parent_id=>wwv_flow_api.id(79921005251148798.4407)
,p_short_name=>unistr('\8868\55AE\529F\80FD\8868\7A0B\5F0F\55AE\5143\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:121:&SESSION.::&DEBUG.:::'
,p_page_id=>121
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(108646613257568171.4407)
,p_parent_id=>wwv_flow_api.id(108830108647335439.4407)
,p_short_name=>unistr('\8868\55AE\7269\4EF6\7A0B\5F0F\5EAB')
,p_link=>'f?p=&APP_ID.:116:&SESSION.::&DEBUG.:::'
,p_page_id=>116
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(108691121464719487.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\7269\4EF6\7A0B\5F0F\5EAB\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:122:&SESSION.::&DEBUG.:::'
,p_page_id=>122
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(108830108647335439.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\8868\55AE\7269\4EF6\7A0B\5F0F\5EAB')
,p_link=>'f?p=&APP_ID.:123:&SESSION.::&DEBUG.:::'
,p_page_id=>123
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(109059812442942860.4407)
,p_parent_id=>wwv_flow_api.id(108646613257568171.4407)
,p_short_name=>unistr('\5340\584A\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:124:&SESSION.::&DEBUG.:::'
,p_page_id=>124
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(109154409583316326.4407)
,p_parent_id=>wwv_flow_api.id(108646613257568171.4407)
,p_short_name=>unistr('\5DE5\4F5C\5340\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:125:&SESSION.::&DEBUG.:::'
,p_page_id=>125
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(109178129917451203.4407)
,p_parent_id=>wwv_flow_api.id(108646613257568171.4407)
,p_short_name=>unistr('\7269\4EF6\7A0B\5F0F\5EAB\9801\7C64\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:126:&SESSION.'
,p_page_id=>126
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(109194413816514795.4407)
,p_parent_id=>wwv_flow_api.id(108646613257568171.4407)
,p_short_name=>unistr('\7A0B\5F0F\55AE\5143\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:127:&SESSION.'
,p_page_id=>127
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(109201819511532096.4407)
,p_parent_id=>wwv_flow_api.id(108646613257568171.4407)
,p_short_name=>unistr('\7279\6027\985E\5225\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:128:&SESSION.'
,p_page_id=>128
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(109209307466558821.4407)
,p_parent_id=>wwv_flow_api.id(108646613257568171.4407)
,p_short_name=>unistr('\8996\89BA\5C6C\6027\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:129:&SESSION.'
,p_page_id=>129
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(109216730555569115.4407)
,p_parent_id=>wwv_flow_api.id(108646613257568171.4407)
,p_short_name=>unistr('\8996\7A97\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:130:&SESSION.'
,p_page_id=>130
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112430303041630046.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\9023\9644\7684\7A0B\5F0F\5EAB')
,p_link=>'f?p=&APP_ID.:111:&SESSION.::&DEBUG.:::'
,p_page_id=>111
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112436912612706611.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\6A21\7D44\53C3\6578')
,p_link=>'f?p=&APP_ID.:117:&SESSION.::&DEBUG.:::'
,p_page_id=>117
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112465602185941714.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\529F\80FD\8868')
,p_link=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:::'
,p_page_id=>131
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112472510376106352.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\5831\8868')
,p_link=>'f?p=&APP_ID.:132:&SESSION.::&DEBUG.:::'
,p_page_id=>132
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112478602462183690.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\7269\4EF6\7FA4\7D44')
,p_link=>'f?p=&APP_ID.:133:&SESSION.::&DEBUG.:::'
,p_page_id=>133
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112492719201662115.4407)
,p_parent_id=>wwv_flow_api.id(112430303041630046.4407)
,p_short_name=>unistr('\9023\9644\7684\7A0B\5F0F\5EAB\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:134:&SESSION.'
,p_page_id=>134
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112516310040839132.4407)
,p_parent_id=>wwv_flow_api.id(112436912612706611.4407)
,p_short_name=>unistr('\6A21\7D44\53C3\6578\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:135:&SESSION.'
,p_page_id=>135
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112526626990948689.4407)
,p_parent_id=>wwv_flow_api.id(112465602185941714.4407)
,p_short_name=>unistr('\529F\80FD\8868\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:136:&SESSION.'
,p_page_id=>136
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112580318636290312.4407)
,p_parent_id=>wwv_flow_api.id(112472510376106352.4407)
,p_short_name=>unistr('\5831\8868\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:139:&SESSION.'
,p_page_id=>139
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(112601822326605299.4407)
,p_parent_id=>wwv_flow_api.id(112478602462183690.4407)
,p_short_name=>unistr('\7269\4EF6\7FA4\7D44\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:140:&SESSION.'
,p_page_id=>140
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(234407916070869604.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\7522\751F\7684\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.:::'
,p_page_id=>72
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(235468412731477088.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::'
,p_page_id=>33
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(240083510253596317.4407)
,p_parent_id=>wwv_flow_api.id(112526626990948689.4407)
,p_short_name=>unistr('\529F\80FD\8868\9805\76EE\8A73\7D30\8CC7\8A0A')
,p_long_name=>unistr('\529F\80FD\8868\9805\76EE\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.:::'
,p_page_id=>143
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(245554523514521027.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\5C08\6848\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.:::'
,p_page_id=>109
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(245572815005822827.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\522A\9664\5C08\6848')
,p_link=>'f?p=&FLOW_ID.:115:&SESSION.'
,p_page_id=>115
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(245779832379989586.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&FLOW_ID.:137:&SESSION.'
,p_page_id=>137
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(245785402984009359.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&FLOW_ID.:138:&SESSION.'
,p_page_id=>138
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(246119121337171962.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\5DF2\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&FLOW_ID.:141:&SESSION.'
,p_page_id=>141
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(260268815298092438.4407)
,p_parent_id=>wwv_flow_api.id(4994410640932460.4407)
,p_short_name=>unistr('\5C08\6848: &MW_PROJ_NAME.')
,p_link=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.:::'
,p_page_id=>51
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(260269211966100921.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\4E0A\50B3\6A94\6848')
,p_link=>'f?p=&APP_ID.:52:&SESSION.::&DEBUG.:::'
,p_page_id=>52
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(260269420624103433.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\8868\55AE\7269\4EF6')
,p_link=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:RIR::'
,p_page_id=>53
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(260269631013106353.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\5340\584A')
,p_link=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:::'
,p_page_id=>54
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(260273821448113054.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\503C\6E05\55AE')
,p_link=>'f?p=&APP_ID.:57:&SESSION.::&DEBUG.:::'
,p_page_id=>57
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(260274026642114557.4407)
,p_parent_id=>wwv_flow_api.id(260273821448113054.4407)
,p_short_name=>unistr('\503C\6E05\55AE\8CC7\6599\6B04')
,p_link=>'f?p=&APP_ID.:58:&SESSION.::&DEBUG.:::'
,p_page_id=>58
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(271635118859345879.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:62:&SESSION.::&DEBUG.:::'
,p_page_id=>62
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(273180605772611383.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\8996\89BA\5C6C\6027')
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(273294203925337360.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\8B66\793A')
,p_link=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.:::'
,p_page_id=>44
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(273336915588457042.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\5DE5\4F5C\5340')
,p_link=>'f?p=&APP_ID.:59:&SESSION.::&DEBUG.:::'
,p_page_id=>59
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(273863921076840536.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\5EA7\6A19')
,p_link=>'f?p=&APP_ID.:63:&SESSION.::&DEBUG.:::'
,p_page_id=>63
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(274292620837821453.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\7DE8\8F2F\5668')
,p_link=>'f?p=&APP_ID.:64:&SESSION.::&DEBUG.:::'
,p_page_id=>64
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(274304227837934407.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\7279\6027\985E\5225')
,p_link=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.:::'
,p_page_id=>65
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(274320417977015263.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\8A18\9304\7FA4\7D44')
,p_link=>'f?p=&APP_ID.:66:&SESSION.::&DEBUG.:::'
,p_page_id=>66
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(274331528222063723.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\8996\7A97')
,p_link=>'f?p=&APP_ID.:67:&SESSION.::&DEBUG.:::'
,p_page_id=>67
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(274719200933630986.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\7A0B\5F0F\55AE\5143')
,p_link=>'f?p=&APP_ID.:69:&SESSION.::&DEBUG.:::'
,p_page_id=>69
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(278589112984456077.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::'
,p_page_id=>29
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(279007224931532674.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.:::'
,p_page_id=>71
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314798328091761183.4407)
,p_parent_id=>wwv_flow_api.id(274719200933630986.4407)
,p_short_name=>unistr('\7A0B\5F0F\55AE\5143\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:75:&SESSION.'
,p_page_id=>75
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314846432313713329.4407)
,p_parent_id=>wwv_flow_api.id(260269631013106353.4407)
,p_short_name=>unistr('\5340\584A\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:77:&SESSION.::&DEBUG.:::'
,p_page_id=>77
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314929817327756797.4407)
,p_parent_id=>wwv_flow_api.id(273294203925337360.4407)
,p_short_name=>unistr('\8B66\793A\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.:::'
,p_page_id=>78
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314954509050223904.4407)
,p_parent_id=>wwv_flow_api.id(273863921076840536.4407)
,p_short_name=>unistr('\5EA7\6A19\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:80:&SESSION.::&DEBUG.:::'
,p_page_id=>80
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314970210408427937.4407)
,p_parent_id=>wwv_flow_api.id(274292620837821453.4407)
,p_short_name=>unistr('\7DE8\8F2F\5668\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:::'
,p_page_id=>81
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314987310025613600.4407)
,p_parent_id=>wwv_flow_api.id(274304227837934407.4407)
,p_short_name=>unistr('\7279\6027\985E\5225\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:82:&SESSION.::&DEBUG.:::'
,p_page_id=>82
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(314999929144750446.4407)
,p_parent_id=>wwv_flow_api.id(274320417977015263.4407)
,p_short_name=>unistr('\8A18\9304\7FA4\7D44\8CC7\6599\6B04')
,p_link=>'f?p=&FLOW_ID.:83:&SESSION.'
,p_page_id=>83
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315010320822950845.4407)
,p_parent_id=>wwv_flow_api.id(274320417977015263.4407)
,p_short_name=>unistr('\8A18\9304\7FA4\7D44\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:84:&SESSION.::&DEBUG.:::'
,p_page_id=>84
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315017923397104096.4407)
,p_parent_id=>wwv_flow_api.id(314999929144750446.4407)
,p_short_name=>unistr('\8A18\9304\7FA4\7D44\8CC7\6599\6B04\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:85:&SESSION.::&DEBUG.:::'
,p_page_id=>85
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315044331460223321.4407)
,p_parent_id=>wwv_flow_api.id(274331528222063723.4407)
,p_short_name=>unistr('\8996\7A97\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.:::'
,p_page_id=>86
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315061813384395723.4407)
,p_parent_id=>wwv_flow_api.id(273180605772611383.4407)
,p_short_name=>unistr('\8996\89BA\5C6C\6027\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.:::'
,p_page_id=>87
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315114413346145040.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\5C08\6848\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:::'
,p_page_id=>88
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315195210391637347.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\8868\55AE\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:::'
,p_page_id=>89
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315274030027273127.4407)
,p_parent_id=>wwv_flow_api.id(4994410640932460.4407)
,p_short_name=>unistr('\5982\4F55\8F49\63DB Oracle Forms \61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.:::'
,p_page_id=>61
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315706431653635524.4407)
,p_parent_id=>wwv_flow_api.id(260273821448113054.4407)
,p_short_name=>unistr('\503C\6E05\55AE\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.:::'
,p_page_id=>91
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315720912804738460.4407)
,p_parent_id=>wwv_flow_api.id(260274026642114557.4407)
,p_short_name=>unistr('\503C\6E05\55AE\8CC7\6599\6B04\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.:::'
,p_page_id=>92
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(316135009682193537.4407)
,p_parent_id=>wwv_flow_api.id(260269420624103433.4407)
,p_short_name=>unistr('\89F8\767C\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:93:&SESSION.::&DEBUG.:::'
,p_page_id=>93
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(316591930532804037.4407)
,p_parent_id=>wwv_flow_api.id(322259821468692912.4407)
,p_short_name=>unistr('\9805\76EE\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:94:&SESSION.::&DEBUG.:::'
,p_page_id=>94
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(316667301097088940.4407)
,p_parent_id=>wwv_flow_api.id(273336915588457042.4407)
,p_short_name=>unistr('\5DE5\4F5C\5340\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:95:&SESSION.::&DEBUG.:::'
,p_page_id=>95
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(318012807265839395.4407)
,p_parent_id=>wwv_flow_api.id(316135009682193537.4407)
,p_short_name=>unistr('\89F8\767C\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:97:&SESSION.::&DEBUG.:::'
,p_page_id=>97
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(318044729960969212.4407)
,p_parent_id=>wwv_flow_api.id(316135009682193537.4407)
,p_short_name=>unistr('\5340\584A\89F8\767C\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:98:&SESSION.::&DEBUG.:::'
,p_page_id=>98
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(318120211220517720.4407)
,p_parent_id=>wwv_flow_api.id(316135009682193537.4407)
,p_short_name=>unistr('\5340\584A\9805\76EE\89F8\767C\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:99:&SESSION.::&DEBUG.:::'
,p_page_id=>99
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(322259821468692912.4407)
,p_parent_id=>wwv_flow_api.id(260268815298092438.4407)
,p_short_name=>unistr('\9805\76EE')
,p_link=>'f?p=&APP_ID.:74:&SESSION.::&DEBUG.:::'
,p_page_id=>74
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(388906791187308310.4407)
,p_parent_id=>wwv_flow_api.id(.4407)
,p_short_name=>unistr('\96F6')
,p_link=>'f?p=&FLOW_ID.:0:&SESSION.'
,p_page_id=>0
);
end;
/
prompt --application/shared_components/user_interface/templates/page/query_editor
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(80970826567624796.4407)
,p_theme_id=>3
,p_name=>'Query Editor.zh-tw'
,p_internal_name=>'QUERY_EDITOR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#editor/codearea.css" type="text/css" />',
'  <script src="#IMAGE_PREFIX#libraries/codemirror/3.20/lib/codemirror.js" type="text/javascript"></script>',
'  <script src="#IMAGE_PREFIX#editor/codearea.js" type="text/javascript"></script>',
'  <script src="#IMAGE_PREFIX#migration/javascript/codearea.js" type="text/javascript"></script>',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_06#',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-two-col">',
'      <div id="apex-sidebar">#REGION_POSITION_03##REGION_POSITION_05#</div>',
'      <div id="apex-content">#REGION_POSITION_02#',
'        <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/popup_info
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(107477536179540544.4407)
,p_theme_id=>3
,p_name=>'Popup Info.zh-tw'
,p_internal_name=>'POPUP_INFO'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8">',
'    <title>#TITLE#</title>',
'    <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'    ',
'    #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="aPopupPage">',
'    <noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>#REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##BODY#</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>19940022257958945.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_no_sidebar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(188007806099506276.4407)
,p_theme_id=>3
,p_name=>'APEX 4.2 - No SideBar.zh-tw'
,p_internal_name=>'APEX_4.2_NO_SIDEBAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#',
'<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="page-header">',
'  <div>',
'      <a id="apex-logo" href="#HOME_LINK#"><h1>#LOGO#</h1></a>',
'      <div class="nav-bar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="apex-top-bar-end">',
'    <div class="apex-top-bar">',
'       #REGION_POSITION_07#',
'    </div>',
'  </div>',
'  <div id="apex-breadcrumb-region-end">',
'    <div id="apex-breadcrumb-region">',
'      <div id="apex-breadcrumbs">#REGION_POSITION_08#</div>',
'      <div id="apex-help"><a href="&SYSTEM_HELP_URL." target="_blank"><img src="#IMAGE_PREFIX#f_spacer.gif" class="iconSmall help" alt="" /><span>&HELP.</span></a></div>',
'      <div id="apex-controls">#REGION_POSITION_06#</div>',
'    </div>',
'  </div>',
'</div>',
'',
'<div id="htmldbMessageHolder"><a name="SkipRepNav"></a>#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div class="htmldbBodyMargin">',
'  <div>#REGION_POSITION_01#</div>',
'  <div id="ContentBody">',
'    <div id="apex-content">#REGION_POSITION_02#',
'      <div id="apex-splash">#REGION_POSITION_04#<div id="BB">#BODY#</div></div>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="apex-footer-info">',
'  <div style="float:right;">#FLOW_VERSION#</div>',
'  <div style="float:right;">#CUSTOMIZE#</div>',
'</div>',
'<div id="apex-footer">',
'   <div class="content">',
'     <div style="float:left;">&MSG_COMPANY.&nbsp;&MSG_USER.:&nbsp;&USER.</div>',
'     <div style="float:right;">&MSG_LANGUAGE.:&nbsp;&BROWSER_LANGUAGE.&nbsp;|&nbsp;&MSG_COPYRIGHT.</div>',
'   </div>',
'</div>',
'#FORM_CLOSE# <a name="END"><br />',
'</a>',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion failRegion #REGION_CSS_CLASSES#" id="ERROR">',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    <p><strong>#MESSAGE#</strong></p>',
'    #ADDITIONAL_INFO#',
'    #TECHNICAL_INFO#',
'  </div>',
'  <span class="aButtonContainer">',
'    <button onclick="#BACK_LINK#" class="aButton hotButton"><span>#RETURN_TO_APPLICATION#</span></button>',
'  </span>',
'</section>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>187453329378870285.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(615336881957898393.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.zh-tw'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(704462054179768505.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.zh-tw'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4407
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159406701638605035.4407)
,p_page_template_id=>wwv_flow_api.id(704462054179768505.4407)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159407259033605035.4407)
,p_page_template_id=>wwv_flow_api.id(704462054179768505.4407)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(717527373719479827.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.zh-tw'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(717527796284479857.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.zh-tw'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4407
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159411172021605038.4407)
,p_page_template_id=>wwv_flow_api.id(717527796284479857.4407)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159411605117605038.4407)
,p_page_template_id=>wwv_flow_api.id(717527796284479857.4407)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159412102831605039.4407)
,p_page_template_id=>wwv_flow_api.id(717527796284479857.4407)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159412646115605039.4407)
,p_page_template_id=>wwv_flow_api.id(717527796284479857.4407)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159413128816605039.4407)
,p_page_template_id=>wwv_flow_api.id(717527796284479857.4407)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159413609167605039.4407)
,p_page_template_id=>wwv_flow_api.id(717527796284479857.4407)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159414184063605040.4407)
,p_page_template_id=>wwv_flow_api.id(717527796284479857.4407)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(717529266352479864.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page.zh-tw'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(717533351543479866.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Dialog.zh-tw'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen_002
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(722642182145084258.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen (2).zh-tw'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4407
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159417136338605043.4407)
,p_page_template_id=>wwv_flow_api.id(722642182145084258.4407)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159417622583605043.4407)
,p_page_template_id=>wwv_flow_api.id(722642182145084258.4407)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen_003
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(755516569909336701.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen (2) (3).zh-tw'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4407
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159418449363605044.4407)
,p_page_template_id=>wwv_flow_api.id(755516569909336701.4407)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159418976297605044.4407)
,p_page_template_id=>wwv_flow_api.id(755516569909336701.4407)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_code_mirror_screenpg4400_30
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(945932428446240861.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Code Mirror ScreenPg4400:30.zh-tw'
,p_internal_name=>'APEX_5.0_CODE_MIRROR_SCREENPG4400:30'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'  <script src="#IMAGE_PREFIX#libraries/codemirror/4.4/lib/codemirror.js" type="text/javascript"></script>',
'  <script src="#IMAGE_PREFIX#libraries/codemirror/4.4/addon/search/search.js" type="text/javascript"></script>',
'  <script src="#IMAGE_PREFIX#libraries/codemirror/4.4/addon/search/searchcursor.js" type="text/javascript"></script>    ',
'  <script src="#IMAGE_PREFIX#migration/javascript/codearea.js" type="text/javascript"></script>',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_code_mirror_screen_pg4400_42
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(945933718492246661.4407)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Code Mirror Screen Pg4400:42.zh-tw'
,p_internal_name=>'APEX_5.0_CODE_MIRROR_SCREEN_PG4400:42'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'<!--[if lt IE 9]><script src="#IMAGE_PREFIX#libraries/apex/html5_ie.js"></script><![endif]-->',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'  <script src="#IMAGE_PREFIX#libraries/codemirror/4.4/lib/codemirror.js" type="text/javascript"></script>',
'  <script src="#IMAGE_PREFIX#libraries/codemirror/4.4/addon/search/search.js" type="text/javascript"></script>',
'  <script src="#IMAGE_PREFIX#libraries/codemirror/4.4/addon/search/searchcursor.js" type="text/javascript"></script>  ',
'  <script src="#IMAGE_PREFIX#migration/javascript/query_codearea.js" type="text/javascript"></script>',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg" role="alert">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3791803543326.4407)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/done_for_plsql_editor
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(284356531027131709.4407)
,p_template_name=>'(Done) For PLSQL Editor'
,p_internal_name=>'DONE_FOR_PLSQL_EDITOR'
,p_template=>'<input type="button" onclick="#LINK#" value="#LABEL!ATTR#" class="htmldbButtonPLSQL" />'
,p_reference_id=>279355801390159799.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>0
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tbody class="FFFFFF">',
'<tr>',
'<td class="L" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'<td class="C"><a href="#LINK#">#LABEL#</a></td>',
'<td class="R" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_4_1_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(298386732681008864.4407)
,p_template_name=>'APEX 4.1 - Button'
,p_internal_name=>'APEX_4.1_BUTTON'
,p_template=>'<button class="aButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_hot_template=>'<button class="aButton hotButton" onclick="#LINK#" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" type="button"><span>#LABEL!HTML#</span></button> '
,p_reference_id=>275775519061831382.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="button-gray" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> ',
'',
'',
'<a href="#LINK#" class="button-orange" role="button" title="#LABEL#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span>#LABEL#</span></a> '))
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388884764363279239.4407)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(388884868720279239.4407)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(615474655515132947.4407)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(615475481194132964.4407)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(717597065463521923.4407)
,p_template_name=>'APEX 5.0 - Icon Badge Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><span class="a-But'
||'ton-badge"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><spa'
||'n class="a-Button-badge"></span></button>'
,p_reference_id=>631020282344854024.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(717597295252521926.4407)
,p_template_name=>'APEX 5.0 - Icon Badge Menu Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_reference_id=>631020159860848910.4407
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_c_htmldbgbr_100_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(5096822001046010.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Gray Box (c:htmldbGBR) (100%)  From 4999'
,p_internal_name=>'GRAY_BOX_C:HTMLDBGBR_100%_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17353903289599940.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/ppr_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(17268536952823952.4407)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#"><htmldb:PPR_#REGION_ID#>#BODY#</htmldb:PPR_#REGION_ID#></div>'
,p_page_plug_template_name=>'PPR Region'
,p_internal_name=>'PPR_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>81066912344850951.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/show_hide
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(23957836075509199.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Show / Hide'
,p_internal_name=>'SHOW_/_HIDE'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18662712241194598.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/top_bar_white_collapsed
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(27865014543291270.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="top-bar" #REGION_ATTRIBUTES#><div style="float: left">#BODY#</div><div style="float: left">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</div></div>',
''))
,p_page_plug_template_name=>'Top Bar (white) (collapsed)'
,p_internal_name=>'TOP_BAR_WHITE_COLLAPSED'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>21
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>17586323272111445.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_float_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(42543916149834442.4407)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="float:left;clear:both;">#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div (Float Left)'
,p_internal_name=>'APEX_4.0_DIV_FLOAT_LEFT'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>35979911951473325.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_div_with_id_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(42544325632834447.4407)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="#REGION_CSS_CLASSES#">#BODY#</div>'
,p_page_plug_template_name=>'APEX 4.0 - Div with ID and Region Attributes'
,p_internal_name=>'APEX_4.0_DIV_WITH_ID_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>35953114210282960.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(42545310353834448.4407)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Page Anchors'
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(42547302144834449.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Top Bar '
,p_internal_name=>'APEX_4.0_TOP_BAR_'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>6201209681355189.4407
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/report_region_c_htmldbreportregion
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(57445200966810854.4407)
,p_layout=>'TABLE'
,p_template=>'<table class="htmldbRR" width="400" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="BT" valign="bottom">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE##CREATE##CREATE2#&nbsp;&nbsp;&nbsp;'
||'#PREVIOUS##NEXT#</th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Report Region (c:htmldbReportRegion) '
,p_internal_name=>'REPORT_REGION_C:HTMLDBREPORTREGION_'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/graybox720px
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(70802026661900247.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'GrayBox720px'
,p_internal_name=>'GRAYBOX720PX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/top_bar_c_htmldbtopbar_no_br_expanding
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(74998905741675045.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion buttonRegion" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    #BODY#',
'    <span class="aButtonContainer">',
'      #CLOSE##COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#',
'    </span>',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Top Bar (c:htmldbTopBar) (no br , expanding) '
,p_internal_name=>'TOP_BAR_C:HTMLDBTOPBAR_NO_BR_,_EXPANDING_'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>17357218626599946.4407
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
end;
/
prompt --application/shared_components/user_interface/templates/region/info_c_htmldbinfo_from_4999
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(86904609451444726.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Info (c:htmldbInfo)  From 4999'
,p_internal_name=>'INFO_C:HTMLDBINFO_FROM_4999'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/gray_box_c_htmldbgraybox
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(111640222630525987.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion altHeading editRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'      <a href="#" class="aIconButton" onclick="uF();return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" class="upIcon" alt="&TOP." /></a>',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'Gray Box (c:htmldbGrayBox)'
,p_internal_name=>'GRAY_BOX_C:HTMLDBGRAYBOX'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>344742548.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/blank_wizard_region_c_htmldbbwr
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(111817633927197957.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbBWR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_ID#">',
'<thead>',
'<tr>',
'<th class="T"><br /></th>',
'<th class="BT" valign="bottom">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE#<img src="#IMAGE_PREFIX#htmldb/builder/1px_trans.gif" alt="" height="1" width="5" />#PREVIOUS##NEXT##CREATE##CREATE2#</th>',
'</tr>',
'</thead>',
'<tbody>',
'<tr>',
'<td colspan="2" class="B">#BODY#</td>',
'</tr>',
'</tbody>',
'</table>'))
,p_page_plug_template_name=>'Blank Wizard Region (c:htmldbBWR)'
,p_internal_name=>'BLANK_WIZARD_REGION_C:HTMLDBBWR'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>11
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/search_and_replace_region_editor
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(117834427983421754.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <script type="text/javascript">  ',
'    function toggleFind() {',
'      html_ToggleElement(''body#REGION_ID#'');  ',
'    }',
'  </script>',
'  <div id="body#REGION_ID#" style="display:none;">',
'    <table cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_ID#">',
'      <tr>',
'        <td valign="top">#BODY#</td>',
'        <td valign="top">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</td>',
'      </tr>',
'    </table>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Search and Replace Region (Editor)'
,p_internal_name=>'SEARCH_AND_REPLACE_REGION_EDITOR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>112829305325461983.4407
,p_translate_this_template=>'N'
,p_template_comment=>'Gray Head, white body'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(145308009821552281.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box'
,p_internal_name=>'WIZARD_BOX'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_box_success
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(161911336037559740.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion successRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>'Wizard Box (Success)'
,p_internal_name=>'WIZARD_BOX_SUCCESS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>149030901078827666.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186396719923353584.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body'
,p_internal_name=>'APEX_4.2_WIZARD_BODY'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209615589242480.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_divider
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186397129801353593.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'<div class="wizardRegionHeading">',
'  <h1>#TITLE#</h1>',
'  <div class="buttonContainer">',
'#EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'  </div>',
'</div>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Divider)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_DIVIDER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209811475242480.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186397626021353594.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_4.2_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210116661242480.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_buttons
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(186398106410353594.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardButtonsContainer" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="leftButtons">',
'    #PREVIOUS##DELETE##CHANGE##CLOSE#',
'  </div>',
'  <div class="rightButtons">',
'    #EDIT##CREATE##NEXT#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.2 - Wizard Buttons'
,p_internal_name=>'APEX_4.2_WIZARD_BUTTONS'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210411889242480.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(209319913704614572.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar (Gray Header)'
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/just_text
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(244065612129731419.4407)
,p_layout=>'TABLE'
,p_template=>'<span class="fielddata">#BODY#</span>'
,p_page_plug_template_name=>'just text'
,p_internal_name=>'JUST_TEXT'
,p_theme_id=>3
,p_theme_class_id=>6
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id_c_htmldbhid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(308527605517617057.4407)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Div with ID (c:htmldbHID)'
,p_internal_name=>'DIV_WITH_ID_C:HTMLDBHID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>245224629509817478.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(388878300928275048.4407)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_navigation
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(466754604149017218.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion sideNavRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Sidebar Navigation'
,p_internal_name=>'APEX_4.0_SIDEBAR_NAVIGATION'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>3
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>456726627253419549.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_search_and_replace_region_editor
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(468490817126374150.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <script type="text/javascript">  ',
'    function toggleFind() {',
'      html_ToggleElement(''body#REGION_ID#'');  ',
'    }',
'  </script>',
'  <div id="body#REGION_ID#" style="display:none;">',
'    <table cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_ID#">',
'      <tr>',
'        <td valign="top">#BODY#</td>',
'        <td valign="top">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</td>',
'      </tr>',
'    </table>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 4.0 - Search and Replace Region (Editor)'
,p_internal_name=>'APEX_4.0_SEARCH_AND_REPLACE_REGION_EDITOR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>112829305325461983.4407
,p_translate_this_template=>'N'
,p_template_comment=>'Gray Head, white body'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/show_hide_c_htmldbshowhidemin_minimal
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(615279444400385171.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title"><h3>',
'      <a href="#" onclick="htmldb_ToggleTableBody(''i#REGION_STATIC_ID#'',''body#REGION_STATIC_ID#''); return false;">',
'        <img src="#IMAGE_PREFIX#htmldb/builder/rollup_plus_dgray.gif" class="pseudoButtonActive" id="i#REGION_STATIC_ID#" alt="" />',
'        #TITLE#',
'      </a></h3>    ',
'    </div>',
'  </div>',
'  <div class="hide-show-body" style="display:none;" id="body#REGION_STATIC_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Show / Hide (c:htmldbShowHideMin) (minimal) '
,p_internal_name=>'SHOW_/_HIDE_C:HTMLDBSHOWHIDEMIN_MINIMAL_'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>34100919691512042.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717541321245505702.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717547914639505717.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717558830541505732.4407)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717561032869505733.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4407
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717571379515505738.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717581613788505755.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #SUB_REGION_HEADERS#',
'  #SUB_REGIONS#',
'</div>',
'<script type="text/javascript">',
'    $("##REGION_STATIC_ID#").tabs({',
'      create: function() {',
'        $(this).addClass(''ui-tabs--simpleInset'')',
'      }',
'    });',
'</script>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer-item" id="#SUB_REGION_ID#">',
'#SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717582314310505756.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717583097971505756.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--left #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Left)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174628415239478085.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar_items_right
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717583749098505758.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar-items a-Toolbar-items--right #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar Items (Right)'
,p_internal_name=>'APEX_5.0_TOOLBAR_ITEMS_RIGHT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174629130392501406.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717584444915505758.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717585174544505758.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(717585835676505759.4407)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/top_bar_c_htmldbtopbarm
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(837241027197472617.4407)
,p_layout=>'TABLE'
,p_template=>'<table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class="'
||'R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>'
,p_page_plug_template_name=>'Top Bar (c:htmldbTopBarM)'
,p_internal_name=>'TOP_BAR_C:HTMLDBTOPBARM'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17356300146599944.4407
,p_translate_this_template=>'N'
,p_template_comment=>'<table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td width="10"><img src="#IMAGE_PREFIX#htmldb/builder/bar_top.png" width="10" height="8" alt="" /></td><'
||'td rowspan="3" valign="middle" class="L">#BODY#</td><td rowspan="3" width="30" class="C"><br /></td><td rowspan="3" valign="middle" class="R" align="right" style="white-space:nowrap;"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHAN'
||'GE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr><tr><td style="background-image:url(#IMAGE_PREFIX#htmldb/builder/bar_bg.png)"><br /></td></tr><tr><td><img src="#IMAGE_PREFIX#htmldb/builder/bar_bottom.png" width="10" height="8"  alt="" /></td></tr>'
||'</tbody></table>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(982295578455380615.4407)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_tabbed_navigation_list_ppr
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(16748830093869757.4407)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="javascript:ob_PPR_TAB(''#LINK#'')" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
'',
''))
,p_list_template_name=>'Simple Tabbed Navigation List (PPR)'
,p_internal_name=>'SIMPLE_TABBED_NAVIGATION_LIST_PPR'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbTabbedNavigationList" border="0" cellpadding="0" cellspacing="0" summary=""><tr>',
'',
''))
,p_list_template_after_rows=>'<td width="100%"><br /></td></tr></table>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" class="tabcurrent" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td valign="bottom"><a href="#LINK#" #A01# title="#TEXT_ESC_SC#">#TEXT#</a></td>',
''))
,p_reference_id=>108849122001556988.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_c_htmldbul
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(25505514315218644.4407)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'Unordered List (c:htmldbUl)'
,p_internal_name=>'UNORDERED_LIST_C:HTMLDBUL'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/flowwizard
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(28326023456306547.4407)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-wiz-current"><span>#TEXT#</span></div>',
''))
,p_list_template_noncurrent=>'<div class="apex-wiz-non"><span>#TEXT#</span></div>'
,p_list_template_name=>'FlowWizard'
,p_internal_name=>'FLOWWIZARD'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="apex-wiz-bar">'
,p_list_template_after_rows=>'</div>'
,p_between_items=>'<div class="apex-wiz-arrow"></div>'
,p_reference_id=>60218330803141060.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(57485732443830698.4407)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>32421627622986728.4407
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_wizard_progress_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(186403927274357160.4407)
,p_list_template_current=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_noncurrent=>'<li class="#LIST_STATUS#"><span>#TEXT#</span></li>'
,p_list_template_name=>'APEX 4.2 - Wizard Progress Bar'
,p_internal_name=>'APEX_4.2_WIZARD_PROGRESS_BAR'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardProgress">',
'<ul>'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'</div>'))
,p_reference_id=>42216127932260877.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(188012120632520477.4407)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a class="nosub" href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a>',
'</div>',
''))
,p_list_template_name=>'APEX 4.0 - Pull Down Tabs'
,p_internal_name=>'APEX_4.0_PULL_DOWN_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div id="tabs" class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="aTabs dhtmlSubMenu pulldown-tabs" style="display:none;">',
''))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#LIST_ITEM_ID#" class="non-current">',
'    <a href="#LINK#" title="#TEXT_ESC_SC#" class="link_text">#TEXT#</a>',
'    <a href="#" onclick="app_AppMenuMultiOpenBottom3(this,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false); return false;" class="link_icon">',
'        <img src="#IMAGE_PREFIX#apex/builder/down_dark_12x12.gif" width="12" height="12" class="dhtmlMenu" alt="#IMAGE_ALT#"/>',
'    </a>',
'</div>',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span>#TEXT#</span><img class="htmldbMIMG" alt="" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></'
||'li>'
,p_reference_id=>9651611091899590.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/button_list_horizontal_c_htmldbbuttonlist
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(297456120972937317.4407)
,p_list_template_current=>'<td><a href="#LINK#" class="htmldbButtonListCurrent">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td><a href="#LINK#" class="htmldbButtonList">#TEXT#</a></td>'
,p_list_template_name=>'Button List Horizontal (c:htmldbButtonList)'
,p_internal_name=>'BUTTON_LIST_HORIZONTAL_C:HTMLDBBUTTONLIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="htmldbButtonList" summary="" border="0" cellpadding="0" cellspacing="3"><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_item_templ_curr_w_child=>'<td><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="20" height="1" /></td>'
,p_item_templ_noncurr_w_child=>'<td><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" width="20" height="1" /></td>'
,p_reference_id=>21059717155998569.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388881768589276766.4407)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(388882091994276767.4407)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_ob_button_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(468486529154333899.4407)
,p_list_template_current=>'<div class="list-button-c"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_list_template_noncurrent=>'<div class="list-button-nc"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_list_template_name=>'APEX 4.0 - OB Button List'
,p_internal_name=>'APEX_4.0_OB_BUTTON_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<div class="list-button-c-sub"><button onclick="#LINK#" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_item_templ_noncurr_w_child=>'<div class="list-button-nc-sub"><button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#</span></button></div>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>461050507240493294.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(717600482207527501.4407)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4407
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(717601073008527509.4407)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(717605241468527514.4407)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(717612455559527519.4407)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>'</ul></div>'
,p_reference_id=>168708522102193705.4407
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(717613155760527519.4407)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4407
);
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999_3
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(12080117446200458.4407)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report From 4999 (3)'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999_3'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(12080117446200458.4407)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(16025715508464036.4407)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report from 4999'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(16025715508464036.4407)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/dhtml_automatic_ppr_pagination_report_from_4999_2
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(27093615521778199.4407)
,p_row_template_name=>'(DHTML) Automatic PPR Pagination Report From 4999 (2)'
,p_internal_name=>'DHTML_AUTOMATIC_PPR_PAGINATION_REPORT_FROM_4999_2'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="#REGION_ID#" htmldb:href="p=&APP_ID.:&APP_PAGE_ID.:&SESSION.:pg_R_#REGION_ID#:NO:">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<span class="htmldbCSV">#CSV_LINK#</span>',
'',
'<script language=JavaScript type=text/javascript>',
'<!--',
'init_htmlPPRReport(''#REGION_ID#'');',
'',
'//-->',
'</script>',
'</htmldb:#REGION_ID#>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><span class="a-Icon icon-right-chevron"></span></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><span class="a-Icon icon-left-chevron"></span></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>6574616710304003.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(27093615521778199.4407)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/quick_pick_list_items
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(71513117037862466.4407)
,p_row_template_name=>'quick_pick_list_items'
,p_internal_name=>'QUICK_PICK_LIST_ITEMS'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(71513117037862466.4407)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/no_background
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(76759420671391228.4407)
,p_row_template_name=>'No Background'
,p_internal_name=>'NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# id="td#ROWNUM#_#COLNUM#" headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" class="htmldbRptNoBackground" summary="#REGION_TITLE#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>237868603542157245.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(76759420671391228.4407)
,p_row_template_before_first=>'<tr id="row#ROWNUM#">'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/standard_new_ajax
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(423989700900284158.4407)
,p_row_template_name=>'Standard (New Ajax)'
,p_internal_name=>'STANDARD_NEW_AJAX'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123728124628276646.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(423989700900284158.4407)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_2_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(615807510873782585.4407)
,p_row_template_name=>'APEX 4.2 - Standard Report'
,p_internal_name=>'APEX_4.2_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(615807510873782585.4407)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717617355030532055.4407)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717626502811532065.4407)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>6
,p_reference_id=>689060248369886348.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717627232649532066.4407)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(717627232649532066.4407)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(717629762332532068.4407)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(717629762332532068.4407)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1301545403414411920.4407)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1301546079854411976.4407)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_vertical_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_row_template_name=>'APEX 5.0 - Vertical Report'
,p_internal_name=>'APEX_5.0_VERTICAL_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'  <td class="a-Report-cell a-Report-cell--header" scope="row">#COLUMN_HEADER#</td>',
'  <td class="a-Report-cell">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report a-Report--vertical a-Report--staticRowColors #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" summary="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>1126924627125205941.4407
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_row_template_before_first=>' '
,p_row_template_after_last=>' '
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(7303307624468031.4407)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(8299228930814357.4407)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17388415351892041.4407
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(8299333804814359.4407)
,p_template_name=>'FormField_Required'
,p_internal_name=>'FORMFIELD_REQUIRED'
,p_template_body1=>'<em>*</em><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aRequired"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>' <span class="hideMeButHearMe">(#VALUE_REQUIRED#)</span></a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>3
,p_theme_class_id=>2
,p_reference_id=>17388508175892042.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_w_o_popup
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(17397530147569836.4407)
,p_template_name=>'FormField_Optional w/o popup'
,p_internal_name=>'FORMFIELD_OPTIONAL_W/O_POPUP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><span class="htmldbLabelOptional">'
,p_template_body2=>'</span></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>238114715839717766.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/htmldb_greenarealabel_c_htmldbgalabel
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(192650113649872658.4407)
,p_template_name=>'htmldb_GreenAreaLabel (c:htmldbGALabel)'
,p_internal_name=>'HTMLDB_GREENAREALABEL_C:HTMLDBGALABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>57728329098847875.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717588923649513843.4407)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span cl'
||'ass="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span></button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>692681574974429799.4407
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717589026268513847.4407)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717589175640513847.4407)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717589255196513848.4407)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717589391884513848.4407)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(717589433798513848.4407)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(11695812357642734.4407)
,p_name=>'breadcrumbs'
,p_internal_name=>'BREADCRUMBS'
,p_current_page_option=>'<span class="htmldbBreadcrumb">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#" class="htmldbBreadcrumb" title="#NAME#">#NAME#</a>'
,p_between_levels=>'<span class="htmldbBreadcrumbSep"><img alt="" src="#IMAGE_PREFIX#apex/apex_top_sep.gif"></span>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>60115300853820165.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(388885539927280786.4407)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>689285808648404711.4407
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(17794809471925337.4407)
,p_page_name=>'winlov'
,p_page_title=>unistr('\641C\5C0B\5C0D\8A71\65B9\584A')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>unistr('\641C\5C0B')
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>unistr('\95DC\9589')
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>unistr('\4E0B\4E00\6B65 &gt;')
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>unistr('&lt; \4E0A\4E00\6B65')
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>unistr('<div class="a-PopupLOV-pagination">\8CC7\6599\5217 #FIRST_ROW# - #LAST_ROW#</div>')
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4407
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/basic_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(16332238744642155.4407)
,p_cal_template_name=>'Basic Calendar'
,p_internal_name=>'BASIC_CALENDAR'
,p_day_of_week_format=>'<th scope="col">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation">',
' <tr>',
'   <td align="center" style="font-weight:bold;">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="1" cellpadding="1" cellspacing="1" summary="0">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div>#DD#</div><br />'
,p_day_open_format=>'<td valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" bgcolor="#d3d3d3">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div>#DD#</div>'
,p_weekend_open_format=>'<td valign="top">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div>#DD#</div>'
,p_nonday_open_format=>'<td valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72331791243517365.4407)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(204026017999796717.4407)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697242071987708856.4407)
,p_theme_id=>101
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698704913100187827.4407)
,p_theme_id=>101
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698705687714187831.4407)
,p_theme_id=>101
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698706384561187831.4407)
,p_theme_id=>101
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698707898791187834.4407)
,p_theme_id=>101
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717541738864505710.4407)
,p_theme_id=>101
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717542316594505712.4407)
,p_theme_id=>101
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717543317458505715.4407)
,p_theme_id=>101
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717549680800505720.4407)
,p_theme_id=>101
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717550601463505720.4407)
,p_theme_id=>101
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717552826700505724.4407)
,p_theme_id=>101
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717605796166527515.4407)
,p_theme_id=>101
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717617793522532059.4407)
,p_theme_id=>101
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(717620298707532062.4407)
,p_theme_id=>101
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746413867240402039.4407)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746415123319402039.4407)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746415402804402039.4407)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746415756912402039.4407)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746416856304402040.4407)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746417175634402040.4407)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746417439468402041.4407)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746417791586402041.4407)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746418091970402041.4407)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746418511171402041.4407)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746418879640402041.4407)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750713473964419653.4407)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750714243290419653.4407)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750714766202419653.4407)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750715065571419653.4407)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750715759706419653.4407)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750734422608422880.4407)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754708130489880624.4407)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754708485839880625.4407)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754708708314880625.4407)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754709589214880629.4407)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754710199201880630.4407)
,p_theme_id=>3
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754710880614880633.4407)
,p_theme_id=>3
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754719862052880640.4407)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(754720603123880642.4407)
,p_theme_id=>3
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(982295995240380688.4407)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754737007303881619.4407)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754737209175881619.4407)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(750715065571419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754737436088881619.4407)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(750715065571419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754737638442881619.4407)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754737847623881619.4407)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754737965175881619.4407)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754738177239881619.4407)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(750713473964419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754738333641881619.4407)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717541321245505702.4407)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(750713473964419653)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754755555778881635.4407)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754755728424881635.4407)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754755916579881635.4407)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754756153276881636.4407)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(754710880614880633)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754756358105881636.4407)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(754710880614880633)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754756517472881636.4407)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(754710880614880633)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754756783091881636.4407)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(754710880614880633)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754756937618881636.4407)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(754710880614880633)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754757152086881636.4407)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754757309457881636.4407)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754757591428881636.4407)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754757740097881637.4407)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754757918578881637.4407)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717617355030532055.4407)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(754710199201880630)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754761261484881639.4407)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(423989700900284158.4407)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(754708130489880624)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754761400722881639.4407)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(423989700900284158.4407)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(754708485839880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754761651542881639.4407)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(423989700900284158.4407)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754761869596881639.4407)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(423989700900284158.4407)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754762021870881639.4407)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(423989700900284158.4407)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754762152655881639.4407)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(423989700900284158.4407)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754762349821881640.4407)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(423989700900284158.4407)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(754709589214880629)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754765776459881647.4407)
,p_theme_id=>3
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(754720603123880642)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754765912204881648.4407)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(754720603123880642)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754766166737881648.4407)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(754720603123880642)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754766354287881648.4407)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(754720603123880642)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754766585115881648.4407)
,p_theme_id=>3
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(754720603123880642)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754766653822881648.4407)
,p_theme_id=>3
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754766704423881648.4407)
,p_theme_id=>3
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754766812259881648.4407)
,p_theme_id=>3
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754766945999881648.4407)
,p_theme_id=>3
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754767012844881648.4407)
,p_theme_id=>3
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717605241468527514.4407)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754772173714909618.4407)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(746417791586402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754772343875909618.4407)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(746418091970402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754772514954909619.4407)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746418511171402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754772713936909619.4407)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(746417439468402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754772969592909619.4407)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(746417791586402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754773165193909619.4407)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(746418091970402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754773372646909619.4407)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(746415756912402039)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754773519949909619.4407)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(746415756912402039)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754773789378909619.4407)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(746415756912402039)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754773998675909619.4407)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(746418879640402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754774074706909619.4407)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754774288744909620.4407)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(746417439468402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754774389018909620.4407)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754774550355909620.4407)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(746415402804402039)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754774790913909620.4407)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(746415402804402039)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754774928197909620.4407)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(746417175634402040)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754775103644909620.4407)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(746415123319402039)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754775381911909620.4407)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(746416856304402040)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754775441523909620.4407)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754775660468909620.4407)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(746415402804402039)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754775813694909621.4407)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(746415402804402039)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754776065739909621.4407)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(746413867240402039)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754776297063909621.4407)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(746413867240402039)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754776465709909621.4407)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(746413867240402039)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754776699943909621.4407)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(746413867240402039)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754776802169909621.4407)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(746413867240402039)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(754777048464909621.4407)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(746413867240402039)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787130386758949737.4407)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(615807510873782585.4407)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(754708130489880624)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787130501166949739.4407)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(615807510873782585.4407)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(754708485839880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787130777086949739.4407)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(615807510873782585.4407)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787130912272949739.4407)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(615807510873782585.4407)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787131152718949740.4407)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(615807510873782585.4407)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787131266624949740.4407)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(615807510873782585.4407)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787131473976949740.4407)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(615807510873782585.4407)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(754709589214880629)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787135165982949747.4407)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717629762332532068.4407)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(754708130489880624)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787135390571949748.4407)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717629762332532068.4407)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(754708485839880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787135591831949748.4407)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717629762332532068.4407)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787135724592949748.4407)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717629762332532068.4407)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787135968799949748.4407)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717629762332532068.4407)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787136079534949748.4407)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717629762332532068.4407)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787136246954949748.4407)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717629762332532068.4407)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(754709589214880629)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926400094461707537.4407)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388882091994276767.4407)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926400105379707537.4407)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(388882091994276767.4407)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(940696026353341575.4407)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717613155760527519.4407)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982297140919380729.4407)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982297207331380729.4407)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982297491972380730.4407)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(982295995240380688)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982297643708380731.4407)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(982295995240380688)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982297817894380731.4407)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(982295995240380688)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982298065649380731.4407)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(750734422608422880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982298275963380731.4407)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(750734422608422880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982298399084380731.4407)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(982298534419380732.4407)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(982295578455380615.4407)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(982295995240380688)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1199562733386032436.4407)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(615475481194132964.4407)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746418511171402041)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1301548189098411994.4407)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(754708485839880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1301548317576411994.4407)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1301548463306411994.4407)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1301548600373411994.4407)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1301548859296411994.4407)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(754709589214880629)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1301549034121411994.4407)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(1301546854306411979.4407)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(754708708314880625)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525656376951182083.4407)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(25505514315218644.4407)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525656418573182083.4407)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(25505514315218644.4407)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525656597746182083.4407)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(25505514315218644.4407)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525656677847182083.4407)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(25505514315218644.4407)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525656837976182083.4407)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(25505514315218644.4407)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(754719862052880640)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525657068492182084.4407)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(25505514315218644.4407)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(754719862052880640)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525665543833182125.4407)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525665684265182125.4407)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525665749666182125.4407)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525665803882182125.4407)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525666047914182125.4407)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(754719862052880640)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525666251560182125.4407)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(754719862052880640)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544815155691477984.4407)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(71513117037862466.4407)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544815281217477984.4407)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(71513117037862466.4407)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544815347929477984.4407)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(71513117037862466.4407)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544819459056478028.4407)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717627232649532066.4407)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544819576410478028.4407)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717627232649532066.4407)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544819686706478028.4407)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(717627232649532066.4407)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554819618737408397.4407)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(750713473964419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554819857236408397.4407)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(750713473964419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554820082922408398.4407)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554820231948408398.4407)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554820472701408398.4407)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750714766202419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554820626543408398.4407)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750715065571419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554820827783408398.4407)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750715759706419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554821052911408398.4407)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750715759706419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554821227724408398.4407)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554821347982408398.4407)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554821584532408398.4407)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717561032869505733.4407)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(750715065571419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554833157538526812.4407)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(717558830541505732.4407)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554833209939526812.4407)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717558830541505732.4407)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554833323453526812.4407)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717558830541505732.4407)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554848943308542281.4407)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554849028010542281.4407)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554849210343542282.4407)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554849486391542282.4407)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554849602457542282.4407)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750714766202419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554849851206542282.4407)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750715065571419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554850017912542282.4407)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750715759706419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554850283696542282.4407)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750715759706419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554850458207542282.4407)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(750734422608422880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554850672664542282.4407)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717547914639505717.4407)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(750734422608422880)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554868650507550818.4407)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554868825083550819.4407)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(750713473964419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554869078146550819.4407)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750715759706419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554869216994550819.4407)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(750715065571419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554869489625550819.4407)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554869685633550819.4407)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(750713473964419653)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554869806867550819.4407)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554870007990550819.4407)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750715759706419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554870233680550819.4407)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750714766202419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554870461189550820.4407)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(717571379515505738.4407)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(750714243290419653)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(693461711694627188.4407)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(5329329946120228.4407)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(25987905718244126.4407)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\78BA\5B9A\8981\96E2\958B\6B64\9801\9762\4E14\4E0D\5132\5B58\55CE?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/copy_query
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(1164031184432110786.4407)
,p_shortcut_name=>'COPY_QUERY'
,p_shortcut_type=>'FUNCTION_BODY'
,p_shortcut=>'return wwv_flow_lang.system_message(''LAYOUT.T_ALT_COPY'');'
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(539742725518650006.4407)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4407
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(12508114015253840.4407)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('\958B\767C\4EBA\54E1\6388\6B0A')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4407
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(786892751597512871.4407)
,p_plugin_id=>wwv_flow_api.id(12508114015253840.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786893197553512871.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786893665951512871.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786894118745512871.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786894639386512872.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786895109488512872.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786895666063512872.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786896170526512872.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786896685049512873.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786897131234512873.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786897670931512874.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786898177582512874.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786898698356512874.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(786892751597512871.4407)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(113746801077665432.4407)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('Apex \8A8D\8B49')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4407
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118571069226919712.4407)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>unistr('INTERNAL \793E\7FA4\767B\5165')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4407
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118571218674919713.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118573176030919714.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118571666680919713.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118572191508919713.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118572621988919713.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118573636552919714.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118574086899919714.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118574473450919715.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118574815028919715.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118571218674919713.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118575294643919715.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118575611383919715.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118576037179919716.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118576483874919716.4407)
,p_plugin_id=>wwv_flow_api.id(118571069226919712.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356673722109447686.4407)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNAL Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4407
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356676414209447689.4407)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>unistr('INTERNAL \8CC7\6599\5EAB\5E33\6236')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4407
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356702620211447720.4407)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>unistr('INTERNAL HTTP \6A19\982D\8B8A\6578')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4407
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356702825366447720.4407)
,p_plugin_id=>wwv_flow_api.id(356702620211447720.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356703225543447720.4407)
,p_plugin_id=>wwv_flow_api.id(356702620211447720.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356703604585447721.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356703225543447720.4407)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356704116696447721.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356703225543447720.4407)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356704629139447721.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356703225543447720.4407)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356705112469447721.4407)
,p_plugin_id=>wwv_flow_api.id(356702620211447720.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356703225543447720.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356705506521447721.4407)
,p_plugin_id=>wwv_flow_api.id(356702620211447720.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(356703225543447720.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356705931580447721.4407)
,p_plugin_id=>wwv_flow_api.id(356702620211447720.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356703225543447720.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356706302968447723.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356705931580447721.4407)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356706813660447723.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356705931580447721.4407)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356707302355447723.4407)
,p_plugin_id=>wwv_flow_api.id(356702620211447720.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356772222254447774.4407)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>unistr('INTERNAL LDAP \76EE\9304')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4407
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F38\5165\7528\65BC\8A8D\8B49\767B\5165\9801\9762\4E2D\4E4B LDAP \76EE\9304\7684\4F7F\7528\8005\540D\7A31\548C\5BC6\78BC. \8ACB\6CE8\610F, \5BC6\78BC\53EF\80FD\5340\5206\5927\5C0F\5BEB.</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356772524465447774.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356772914990447775.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356773311235447775.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356773726992447775.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356773311235447775.4407)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356774217591447776.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356773311235447775.4407)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356774727355447777.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356773311235447775.4407)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356775230743447777.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356775600458447777.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356776014259447777.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(356775600458447777.4407)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356776412929447777.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(356776807354447777.4407)
,p_plugin_id=>wwv_flow_api.id(356772222254447774.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356777211415447777.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356776807354447777.4407)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356777730419447778.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356776807354447777.4407)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(356778214152447778.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(356776807354447777.4407)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(356820303275447809.4407)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNAL Oracle Application Server Single Sign-On'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4407
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_wizard_selection
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3875713135796652572.4407)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.WIZARD_SELECTION'
,p_display_name=>unistr('\9078\64C7\7CBE\9748')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.WIZARD_SELECTION'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_wizard_selection'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_wizard_selection'
,p_standard_attributes=>'VISIBLE:SESSION_STATE:SOURCE:ELEMENT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(984455177424896145.4407)
,p_plugin_id=>wwv_flow_api.id(3875713135796652572.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Size'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'S'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(984455775699896945.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(984455177424896145.4407)
,p_display_sequence=>10
,p_display_value=>'Small'
,p_return_value=>'S'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(984456174405897554.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(984455177424896145.4407)
,p_display_sequence=>20
,p_display_value=>'Medium'
,p_return_value=>'M'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(984456573327898086.4407)
,p_plugin_attribute_id=>wwv_flow_api.id(984455177424896145.4407)
,p_display_sequence=>30
,p_display_value=>'Large'
,p_return_value=>'L'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1068330411136081671.4407)
,p_plugin_id=>wwv_flow_api.id(3875713135796652572.4407)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Submit Page'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
,p_help_text=>'Select whether or not to submit the page when making a selection'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845157921507834569.4407)
,p_plugin_id=>wwv_flow_api.id(3875713135796652572.4407)
,p_name=>'LOV'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4969928362302343.4407)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\684C\9762')
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=&APP_ID.:1:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4407
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\96F6')
,p_step_title=>unistr('\96F6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(57192300745493742.4407)
,p_plug_name=>'css'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'.apex_finderbar_left .formlayout label{font-size:12px !important;}',
'</style>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388872161135245638.4407)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-app-builder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388872344702245639.4407)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(388872161135245638.4407)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6069804183216033.4407)
,p_plug_name=>'APEX 5 - Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(388872344702245639.4407)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(719061308852162669.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388881768589276766.4407)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388872519195245639.4407)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(388872344702245639.4407)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388872712782245640.4407)
,p_plug_name=>'APEX 5 - Home Link'
,p_parent_plug_id=>wwv_flow_api.id(388872344702245639.4407)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>2
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388872926485245640.4407)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(388872161135245638.4407)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388873110214245640.4407)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(388872926485245640.4407)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P0_SEARCH" class="visuallyhidden">Search</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P0_SEARCH" placeholder="''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH.APPS'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388873370735245640.4407)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_api.id(388872926485245640.4407)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388906099189303730.4407)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(388873370735245640.4407)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697470173974258886.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388882091994276767.4407)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(486771916051301729.4407)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(388873370735245640.4407)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>130
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697475141733260859.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(388882091994276767.4407)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388873523987245640.4407)
,p_plug_name=>'APEX 5 - Account'
,p_parent_plug_id=>wwv_flow_api.id(388872926485245640.4407)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388873735351245641.4407)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-app-builder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388873919089245641.4407)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(388873735351245641.4407)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388906445953308310.4407)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(388873919089245641.4407)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(4994007614932454.4407)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(388885539927280786.4407)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(388874130522245641.4407)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(388873735351245641.4407)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(388878300928275048.4407)
,p_plug_display_sequence=>110
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388910562019343694.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388872712782245640.4407)
,p_button_name=>'Home'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388884868720279239.4407)
,p_button_image_alt=>unistr('\9996\9801')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4500:1000:&SESSION.::&DEBUG.::::'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-home'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3773582405867301547.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(388873370735245640.4407)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388884868720279239.4407)
,p_button_image_alt=>unistr('Spotlight \641C\5C0B')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388910719768343695.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(388873370735245640.4407)
,p_button_name=>'Administration'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388884764363279239.4407)
,p_button_image_alt=>unistr('\7BA1\7406')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388910943089343695.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(388873370735245640.4407)
,p_button_name=>'Feedback'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388884868720279239.4407)
,p_button_image_alt=>unistr('\610F\898B\56DE\994B')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(693461711694627188.4407)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(388911149774343695.4407)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(388873370735245640.4407)
,p_button_name=>'Help'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388884764363279239.4407)
,p_button_image_alt=>unistr('\8AAA\660E')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_tab_set=>'TS1'
,p_name=>unistr('\61C9\7528\7A0B\5F0F\79FB\8F49')
,p_step_title=>unistr('\61C9\7528\7A0B\5F0F\79FB\8F49')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(5872827478268282)
,p_step_template=>wwv_flow_api.id(717527796284479857.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/appmgr_overview.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5879119214294234.4407)
,p_plug_name=>unistr('\5DE5\4F5C')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_list_id=>wwv_flow_api.id(5877721161285352.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(234201503744613519.4407)
,p_name=>unistr('\6700\8FD1\7684\66F4\65B0')
,p_template=>wwv_flow_api.id(717561032869505733.4407)
,p_display_sequence=>60
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_column=>false
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4400P1b */ ',
'       id, migration_name,migration_type from ( ',
'select id,migration_name,migration_type, last_updated_on ',
'from wwv_mig_projects ',
'where security_group_id = :FLOW_SECURITY_GROUP_ID order by last_updated_on desc ) ',
'where rownum <= 5'))
,p_display_when_condition=>'select 1 from wwv_mig_projects where rownum = 1'
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(717627232649532066.4407)
,p_query_headings_type=>'QUERY_COLUMNS'
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_no_data_found=>unistr('\627E\4E0D\5230\8CC7\6599')
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(234201818939613530.4407)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>2
,p_column_heading=>'Id'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(234201912175613530.4407)
,p_query_column_id=>2
,p_column_alias=>'MIGRATION_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\79FB\8F49\540D\7A31')
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::P88_ID,MW_PROJ_ID,MW_MIG_TYPE:#ID#,#ID#,#MIGRATION_TYPE#'
,p_column_linktext=>'#MIGRATION_NAME#'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(424363625820178681.4407)
,p_query_column_id=>3
,p_column_alias=>'MIGRATION_TYPE'
,p_column_display_sequence=>3
,p_column_heading=>'Migration Type'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(315094409194849040.4407)
,p_plug_name=>unistr('\79FB\8F49\5C08\6848 (\8A73\7D30\6AA2\8996)')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_template=>wwv_flow_api.id(717558830541505732.4407)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4400P1a */',
'  --',
'  id,',
'  --',
'  MIGRATION_NAME "PROJECT_NAME",',
'  --',
'  ''f?p=4400:51:''||:app_session||'':::RIR:MW_PROJ_ID,MW_MIG_TYPE:''||id||'',''||migration_type edit_project_link,',
'  --',
'  ''f?p=4400:88:''||:app_session||''::NO:88:P88_ID,MW_MIG_TYPE,MW_PROJ_ID:''||id||'',''||migration_type||'',''||id edit_project_icon_link,',
'  --',
'  p.MIGRATION_TYPE TYPE,',
'  --',
'  database_schema,',
'  --',
'  decode(sign(length(description) - 100), 1, substr(description, 1, 97) || ''...'',  description) description,',
'  --',
'  created_on,',
'  --',
'  created_by CREATED,',
'  --',
'  LAST_UPDATED_ON updated,',
'  --',
'  LAST_UPDATED_BY updated_by,',
'  --',
'  sm.edit edit_text,',
'  --',
'  (select count(*) from wwv_mig_forms where project_id = p.id) imported_forms,',
'  --',
'  (select count(*) from wwv_mig_forms where project_id = p.id and SELECT_FOR_APP = ''Y'') included_forms,',
'  --',
'         (select count(*)',
'        from WWV_MIG_FRM_MODULES m,',
'             WWV_MIG_FRM_FORMMODULES fm,',
'             WWV_MIG_FRM_TRIGGERS t,',
'             WWV_MIG_FORMS forms',
'        where m.file_id = forms.id and',
'              m.id = fm.module_id and',
'              fm.id = t.formmodule_id and',
'              forms.project_id = p.id) +',
'       (select count(*)',
'        from WWV_MIG_FRM_MODULES m,',
'             WWV_MIG_FRM_FORMMODULES fm,',
'             WWV_MIG_FRM_BLOCKS t,',
'             WWV_MIG_FRM_BLK_TRIGGERS i,',
'             WWV_MIG_FORMS forms',
'        where m.file_id = forms.id and',
'              m.id = fm.module_id and',
'              fm.id = t.formmodule_id and',
'              t.id = i.block_id and',
'              forms.project_id = p.id) +',
'       (select count(*)',
'        from WWV_MIG_FRM_MODULES m,',
'             WWV_MIG_FRM_FORMMODULES fm,',
'             WWV_MIG_FRM_BLOCKS t,',
'             WWV_MIG_FRM_BLK_ITEMS i,',
'             WWV_MIG_FRM_BLK_ITEM_TRIGGERS it,',
'             WWV_MIG_FORMS forms',
'        where m.file_id = forms.id and',
'              m.id = fm.module_id and',
'              fm.id = t.formmodule_id and',
'              t.id = i.block_id and',
'              i.id = it.item_id and',
'              forms.project_id = p.id) all_triggers,',
'       (select count(*)',
'        from WWV_MIG_FRM_MODULES m,',
'             WWV_MIG_FRM_FORMMODULES fm,',
'             WWV_MIG_FRM_blocks t,',
'             wwv_mig_frm_rev_blocks rb,',
'             WWV_MIG_FORMS forms',
'        where m.file_id = forms.id and',
'              m.id = fm.module_id and',
'              fm.id = t.formmodule_id and',
'              t.id = rb.block_id and',
'              forms.project_id = p.id) blocks,',
'       (select count(*)',
'        from WWV_MIG_FRM_MODULES m,',
'             WWV_MIG_FRM_FORMMODULES fm,',
'             WWV_MIG_FRM_PROGRAMUNIT t,',
'             WWV_MIG_FORMS forms',
'        where m.file_id = forms.id and',
'              m.id = fm.module_id and',
'              fm.id = t.formmodule_id and',
'              forms.project_id = p.id) program_units,',
'       (select count(*)',
'        from   WWV_MIG_PLSQL_LIBS l',
'        where  l.project_id = p.id',
'        and    l.security_group_id = p.security_group_id) plls,',
'       (select count(*)',
'	from   WWV_MIG_FRM_MENUS m',
'	where  m.project_id = p.id',
'        and    m.security_group_id = p.security_group_id) menus,',
'       (select count(*)',
'        from   WWV_MIG_OLB l',
'	where  l.project_id = p.id',
'        and    l.security_group_id = p.security_group_id) olbs,',
'       (select count(*)',
'	from   WWV_MIG_RPTS l',
'	where  l.project_id = p.id',
'        and    l.security_group_id = p.security_group_id) reports',
'from WWV_MIG_PROJECTS p, (select wwv_flow_lang.system_message(''EDIT'') edit from dual)  sm',
'where security_group_id = :flow_security_group_id ',
'  and migration_type = ''forms'' -- No longer support Access Migration projects'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(315094518129849040.4407)
,p_name=>'Migration Projects (Detail View)'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_display_row_count=>'Y'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_rows_per_page=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315094723027849047.4407)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\7DE8\8F2F')
,p_column_link=>'#EDIT_PROJECT_ICON_LINK#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="#EDIT_TEXT# #PROJECT_NAME#">'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_column_type=>'NUMBER'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(6034625630619097.4407)
,p_db_column_name=>'PROJECT_NAME'
,p_display_order=>2
,p_column_identifier=>'Y'
,p_column_label=>unistr('\5C08\6848\540D\7A31')
,p_column_link=>'#EDIT_PROJECT_LINK#'
,p_column_linktext=>'#PROJECT_NAME#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315094929498849048.4407)
,p_db_column_name=>'TYPE'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\985E\578B')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315095003211849048.4407)
,p_db_column_name=>'DATABASE_SCHEMA'
,p_display_order=>5
,p_column_identifier=>'D'
,p_column_label=>unistr('\7DB1\8981')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315095123549849048.4407)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>6
,p_column_identifier=>'E'
,p_column_label=>unistr('\63CF\8FF0')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315099708437890161.4407)
,p_db_column_name=>'IMPORTED_FORMS'
,p_display_order=>7
,p_column_identifier=>'H'
,p_column_label=>unistr('\532F\5165\7684\8868\55AE')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315106521353026343.4407)
,p_db_column_name=>'EDIT_PROJECT_LINK'
,p_display_order=>8
,p_column_identifier=>'K'
,p_column_label=>unistr('\7DE8\8F2F\5C08\6848\9023\7D50')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315209501368903267.4407)
,p_db_column_name=>'INCLUDED_FORMS'
,p_display_order=>9
,p_column_identifier=>'M'
,p_column_label=>unistr('\8868\55AE')
,p_column_link=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.::MW_PROJ_ID:#ID#'
,p_column_linktext=>'#INCLUDED_FORMS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(321446706889030939.4407)
,p_db_column_name=>'ALL_TRIGGERS'
,p_display_order=>11
,p_column_identifier=>'P'
,p_column_label=>unistr('\89F8\767C\7A0B\5F0F')
,p_column_link=>'f?p=&APP_ID.:93:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#'
,p_column_linktext=>'#ALL_TRIGGERS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(321448000487066876.4407)
,p_db_column_name=>'BLOCKS'
,p_display_order=>12
,p_column_identifier=>'Q'
,p_column_label=>unistr('\5340\584A')
,p_column_link=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:RIR,54:MW_PROJ_ID:#ID#'
,p_column_linktext=>'#BLOCKS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(321450408715088146.4407)
,p_db_column_name=>'PROGRAM_UNITS'
,p_display_order=>13
,p_column_identifier=>'R'
,p_column_label=>unistr('\7A0B\5F0F\55AE\5143')
,p_column_link=>'f?p=&APP_ID.:69:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#'
,p_column_linktext=>'#PROGRAM_UNITS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(71517021240949505.4407)
,p_db_column_name=>'PLLS'
,p_display_order=>14
,p_column_identifier=>'S'
,p_column_label=>'PLL'
,p_column_link=>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#'
,p_column_linktext=>'#PLLS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(104443423787234843.4407)
,p_db_column_name=>'MENUS'
,p_display_order=>15
,p_column_identifier=>'U'
,p_column_label=>'MMB'
,p_column_link=>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.::MW_PROJ_ID:#ID#'
,p_column_linktext=>'#MENUS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(128365518899401801.4407)
,p_db_column_name=>'OLBS'
,p_display_order=>16
,p_column_identifier=>'V'
,p_column_label=>'OLB'
,p_column_link=>'f?p=&APP_ID.:123:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#'
,p_column_linktext=>'#OLBS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(75213304113023012.4407)
,p_db_column_name=>'REPORTS'
,p_display_order=>17
,p_column_identifier=>'T'
,p_column_label=>unistr('\5831\8868')
,p_column_link=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.::MW_PROJ_ID:#ID#'
,p_column_linktext=>'#REPORTS#'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315095327888849052.4407)
,p_db_column_name=>'CREATED'
,p_display_order=>18
,p_column_identifier=>'G'
,p_column_label=>unistr('\5EFA\7ACB\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315105426801971112.4407)
,p_db_column_name=>'UPDATED'
,p_display_order=>19
,p_column_identifier=>'I'
,p_column_label=>unistr('\66F4\65B0\6642\9593')
,p_column_type=>'DATE'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315105508017971113.4407)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>20
,p_column_identifier=>'J'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(229075224646348513.4407)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>21
,p_column_identifier=>'W'
,p_column_label=>unistr('\5EFA\7ACB\6642\9593')
,p_column_type=>'DATE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(245563223415625781.4407)
,p_db_column_name=>'EDIT_PROJECT_ICON_LINK'
,p_display_order=>22
,p_column_identifier=>'X'
,p_column_label=>unistr('\7DE8\8F2F\5C08\6848\5716\793A\9023\7D50')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(615345705692209651.4407)
,p_db_column_name=>'EDIT_TEXT'
,p_display_order=>23
,p_column_identifier=>'Z'
,p_column_label=>unistr('\7DE8\8F2F\6587\5B57')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(315211521023927797.4407)
,p_plug_name=>unistr('\5165\9580')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>unistr('<p>\6309\4E00\4E0B<b>\5EFA\7ACB\5C08\6848</b>\6309\9215\4EE5\958B\59CB\9032\884C\4F5C\696D. \82E5\8981\6AA2\8996\53CA\8FFD\8E64 Oracle Forms \8F49\63DB\9032\5EA6, \8ACB\6309\4E00\4E0B\5C08\6848\540D\7A31.</p>')
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(181232726612776571.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(315094409194849040.4407)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:1,RIR::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5160704939571862.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(315094409194849040.4407)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB\5C08\6848')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:3::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5093404006195831.4407)
,p_branch_action=>'f?p=&FLOW_ID.:1:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(322237519113604597.4407)
,p_computation_sequence=>10
,p_computation_item=>'F4400_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(5045106990995277.4407)
,p_computation_sequence=>20
,p_computation_item=>'COMPANY'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'wwv_flow.get_company_name;'
,p_computation_error_message=>unistr('\7121\6CD5\904B\7B97\5DE5\4F5C\5340\540D\7A31.')
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(718744019212474232.4407)
,p_name=>'Edit Report - Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(315094409194849040.4407)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(718744370174474233.4407)
,p_event_id=>wwv_flow_api.id(718744019212474232.4407)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(315094409194849040.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5906424933333777.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_RESET_PAGINATION'
,p_process_name=>'Reset Pagination'
,p_attribute_01=>'THIS_PAGE'
,p_process_when_button_id=>wwv_flow_api.id(181232726612776571.4407)
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_step_title=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(5872827478268282)
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/appmgr_start.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5089901406189380.4407)
,p_plug_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22185318309150806.4407)
,p_plug_name=>unistr('\5DE5\4F5C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717584444915505758.4407)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(5877721161285352.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717601073008527509.4407)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(139361423340834568.4407)
,p_plug_name=>'Project Progress Bar'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(139359500914809151.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717613155760527519.4407)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(186405615497363556.4407)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>40
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752114792956695878.4407)
,p_plug_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5090208060189382.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(186405615497363556.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(26942626908736981.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(186405615497363556.4407)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615475481194132964.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\9801')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P3_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_icon_css_classes=>'icon-right-chevron'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5090520028189386.4407)
,p_branch_name=>'Go To Page 18'
,p_branch_action=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(26942626908736981.4407)
,p_branch_sequence=>2
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(259371818448752970.4407)
,p_branch_name=>'Go To Page 3'
,p_branch_action=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>100
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5090717885189392.4407)
,p_name=>'P3_ID'
,p_item_sequence=>1
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(717589026268513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5090917843189398.4407)
,p_name=>'P3_MIGRATION_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_prompt=>unistr('\5C08\6848\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(717589391884513848.4407)
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\70BA\5C08\6848\8F38\5165\552F\4E00\7684\540D\7A31. \6B64\5C08\6848\540D\7A31\5FC5\9808\662F\76EE\524D\5DE5\4F5C\5340\4E2D\552F\4E00\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
,p_item_comment=>'Enter a name of your Microsoft Access Application migration project.  A project should be created for each application you would like to migrate.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5501926965266936.4407)
,p_name=>'P3_SCHEMA'
,p_item_sequence=>30.5
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_prompt=>unistr('\7DB1\8981')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LIST_AVAILABLE_SCHEMAS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select upper(c.schema) d, upper(c.schema) v',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
'where  c.security_group_id = :flow_security_group_id and',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :flow_user and',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or',
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)',
'order by 1'))
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9078\53D6\79FB\8F49\5C08\6848\95DC\806F\7684\7DB1\8981.'),
'<p>',
unistr('\82E5\662F Microsoft Access \79FB\8F49, \6B64\7DB1\8981\61C9\5305\542B\8981\79FB\8F49\81F3 Oracle &PRODUCT_NAME. \4E4B Microsoft Access \8CC7\6599\5EAB\7684\79FB\8F49\8CC7\6599\5EAB\7DB1\8981\7269\4EF6.'),
'<p>',
unistr('\82E5\662F Oracle Forms \79FB\8F49, \6B64\7DB1\8981\61C9\5305\542B\8981\79FB\8F49\81F3 Oracle &PRODUCT_NAME. \4E4B Oracle Forms \61C9\7528\7A0B\5F0F\95DC\806F\7684\8CC7\6599\5EAB\7DB1\8981\7269\4EF6.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(20684501575327983.4407)
,p_name=>'P3_DELETESTATUS'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_source=>'false'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589026268513847.4407)
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(26612328838945486.4407)
,p_name=>'P3_DESCRIPTION'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_prompt=>unistr('\63CF\8FF0')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>40
,p_cMaxlength=>32767
,p_cHeight=>5
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\8F38\5165\79FB\8F49\5C08\6848\7684\7C21\77ED\63CF\8FF0.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(26759304932143979.4407)
,p_name=>'P3_PROJECTID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'This is the ID'
,p_source=>'wwv_mig_acc_load.g_projectid'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589026268513847.4407)
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(77048105678192321.4407)
,p_name=>'P3_ERROR_MESSAGE'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap'
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259641100112249030.4407)
,p_name=>'P3_FORMS_FILE_NAME'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'FILE_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589026268513847.4407)
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259641705895818376.4407)
,p_name=>'P3_FORMS_MESSAGE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_source=>'return wwv_flow_lang.system_message(''F4400_P3_FIND_FORMS_FILE'', apex_util.prepare_url(''f?p=&APP_ID.:70:&APP_SESSION.::::''));'
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(717589026268513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259642022565851587.4407)
,p_name=>'P3_FORMS_XML_FILE'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'&P3_FORMS_XML_FILE.'
,p_prompt=>unistr('Forms \6A21\7D44 XML \6A94\6848')
,p_source=>'FILE_CONTENT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>50
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(717589391884513848.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\8981\4E0A\50B3\7684 Forms \6A21\7D44 XML \6A94\6848. \82E5\662F Forms \6A21\7D44, \8ACB\4E0A\50B3 Forms2XML \8F49\63DB\5DE5\5177\6240\7522\751F\7684 XML \6A94\6848.<br/>')
,p_attribute_01=>'DB_COLUMN'
,p_attribute_02=>'FILE_MIME_TYPE'
,p_attribute_03=>'FILE_NAME'
,p_attribute_04=>'FILE_CHAR_SET'
,p_attribute_05=>'FILE_UPDATED_ON'
,p_attribute_06=>'N'
,p_item_comment=>'Please select a valid Forms Module XML File, which is generated by the Forms2XML conversion tool, for an Oracle Forms Module. - previous Help Text before inclusion of PL/SQL Libraries.'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259642219626888621.4407)
,p_name=>'P3_FORMS_SECURITY_GROUP_ID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'SECURITY_GROUP_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259642432439892309.4407)
,p_name=>'P3_FORMS_FILE_MIME_TYPE'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'FILE_MIME_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259642613177896140.4407)
,p_name=>'P3_FORMS_XML_CONTENT'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'XML_CONTENT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259642821142898520.4407)
,p_name=>'P3_FORMS_FILE_CHAR_SET'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'FILE_CHAR_SET'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259643031877901559.4407)
,p_name=>'P3_FORMS_FILE_UPDATED_ON'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'FILE_UPDATED_ON'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259643209976914221.4407)
,p_name=>'P3_FORMS_SELECT_FOR_APP'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_source=>'SELECT_FOR_APP'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259643424867918452.4407)
,p_name=>'P3_FORMS_PROJECT_ID'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'PROJECT_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(265603315607927610.4407)
,p_name=>'P3_FORMS_FILE_DESCRIPTION'
,p_item_sequence=>105
,p_item_plug_id=>wwv_flow_api.id(5089901406189380.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Description'
,p_source=>'DESCRIPTION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>50
,p_cMaxlength=>2000
,p_cHeight=>5
,p_colspan=>2
,p_label_alignment=>'RIGHT-TOP'
,p_field_template=>wwv_flow_api.id(717589026268513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8F38\5165 Oracle Forms \8F49\63DB\5C08\6848\76F8\95DC\4E4B Forms XML \6A94\6848\7684\7C21\77ED\63CF\8FF0.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(303783022015617446.4407)
,p_computation_sequence=>10
,p_computation_item=>'P3_FORMS_FILE_NAME'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'substr(:P3_FORMS_XML_FILE, instr(:P3_FORMS_XML_FILE, ''/'', -1) + 1)'
,p_compute_when=>'P3_FORMS_XML_FILE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(303783229634619644.4407)
,p_computation_sequence=>20
,p_computation_item=>'P3_FORMS_FILE_DESCRIPTION'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'trim(:P3_FORMS_FILE_DESCRIPTION)'
,p_compute_when=>'P3_FORMS_XML_FILE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(303781506862594169.4407)
,p_computation_sequence=>30
,p_computation_item=>'P3_FORMS_FILE_CHAR_SET'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'nvl(:P3_FORMS_FILE_CHAR_SET, sys.owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))'
,p_compute_when=>'P3_FORMS_XML_FILE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(259654203124167669.4407)
,p_computation_sequence=>40
,p_computation_item=>'P3_FORMS_SELECT_FOR_APP'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(259654722171173110.4407)
,p_computation_sequence=>50
,p_computation_item=>'P3_FORMS_SECURITY_GROUP_ID'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'FLOW_SECURITY_GROUP_ID'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(58479100377142678.4407)
,p_computation_sequence=>60
,p_computation_item=>'MW_MIG_TYPE'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'''forms'''
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(32177326980058038.4407)
,p_validation_name=>'P3_MIGRATION_NAME Not NULL'
,p_validation_sequence=>10
,p_validation=>'P3_MIGRATION_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\60A8\5FC5\9808\8F38\5165\4E00\500B\552F\4E00\7684\300C\5C08\6848\540D\7A31\300D.')
,p_when_button_pressed=>wwv_flow_api.id(26942626908736981.4407)
,p_associated_item=>wwv_flow_api.id(5090917843189398.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(20474506389345075.4407)
,p_validation_name=>'P3_MIGRATION_NAME Must Be Unique'
,p_validation_sequence=>15
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'',
'  l_cnt number := 0;',
'  l_name varchar2(100);',
'  l_length number := 0;',
'',
'BEGIN',
'',
'  l_name := trim(:P3_MIGRATION_NAME);',
'  l_length := length(l_name);',
'',
'  if (l_length > 0) then',
'',
'    for c1 in (select count(*) cnt',
'               from wwv_mig_projects',
'               where upper(migration_name) = upper(:P3_MIGRATION_NAME)',
'               and security_group_id = :flow_security_group_id )',
'    loop',
'      l_cnt := c1.cnt;',
'    end loop;',
'    ',
'    if l_cnt > 0 then',
'      return false;',
'    else',
'      return true;',
'    end if;',
'',
'  else',
'    return false;',
'  end if;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\60A8\5FC5\9808\8F38\5165\4E00\500B\552F\4E00\7684\300C\5C08\6848\540D\7A31\300D.')
,p_validation_condition=>'P3_MIGRATION_NAME'
,p_validation_condition_type=>'ITEM_NOT_NULL_OR_ZERO'
,p_when_button_pressed=>wwv_flow_api.id(26942626908736981.4407)
,p_associated_item=>wwv_flow_api.id(5090917843189398.4407)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(36514304723490174.4407)
,p_validation_name=>'P3_DESCRIPTION Too Long'
,p_validation_sequence=>25
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_desc varchar2(32767);',
'  l_length number;',
'begin',
'',
'   l_desc := wwv_flow_utilities.clob_to_varchar2(trim(:P3_DESCRIPTION));',
'   l_length := lengthb(l_desc);',
'',
'   if (l_length > 2000) then',
'     return false;',
'   else',
'     return true;',
'   end if;',
'',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\60A8\5FC5\9808\8F38\5165\6B64\79FB\8F49\5C08\6848\7684\7C21\77ED\63CF\8FF0.')
,p_validation_condition=>'P3_DESCRIPTION'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(26942626908736981.4407)
,p_associated_item=>wwv_flow_api.id(26612328838945486.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(304521512235021174.4407)
,p_validation_name=>'P3_FORMS_FILE_NAME Not Null'
,p_validation_sequence=>30
,p_validation=>'P3_FORMS_FILE_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\9078\53D6\8981\4E0A\50B3\7684 Forms \6A94\6848. \82E5\662F Forms \6A21\7D44, \8ACB\4E0A\50B3 Forms2XML \8F49\63DB\5DE5\5177\7522\751F\7684 XML \6A94\6848, \5176\4E2D\5305\542B Forms \6A21\7D44\7684\8CC7\8A0A.')
,p_validation_condition=>':P3_FORMS_FILE_NAME is null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(26942626908736981.4407)
,p_associated_item=>wwv_flow_api.id(259642022565851587.4407)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(304521819526174685.4407)
,p_validation_name=>'P3_FORMS_XML_FILE check file extension'
,p_validation_sequence=>32
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select SUBSTR(UPPER(:P3_FORMS_XML_FILE), INSTR(UPPER(:P3_FORMS_XML_FILE),''_FMB.XML'')) xtn',
'             from dual) loop',
'    return (c1.xtn is not null and c1.xtn = ''_FMB.XML'');',
'end loop;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\8ACB\70BA Oracle Forms \6A21\7D44\9078\53D6 Forms2XML \8F49\63DB\5DE5\5177\7522\751F\7684\6709\6548 Forms \6A21\7D44 XML \6A94\6848.')
,p_validation_condition=>'(:P3_FORMS_FILE_NAME is not null) and (SUBSTR(UPPER(:P3_FORMS_XML_FILE), INSTR(UPPER(:P3_FORMS_XML_FILE),''_FMB.XML'')) is null)'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(26942626908736981.4407)
,p_associated_item=>wwv_flow_api.id(259642022565851587.4407)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(259640812616205423.4407)
,p_process_sequence=>36
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Create Forms Project'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    wwv_mig_frm_load_xml.g_project_id := wwv_flow_id.next_val;',
'',
'    insert into wwv_mig_projects (id, ',
'                                  migration_name, ',
'                                  description, ',
'                                  migration_type, ',
'                                  database_schema, ',
'                                  security_group_id) ',
'    values (wwv_mig_frm_load_xml.g_project_id, ',
'            :P3_MIGRATION_NAME,',
'            :P3_DESCRIPTION,',
'            ''forms'', ',
'            :P3_SCHEMA,',
'            :FLOW_SECURITY_GROUP_ID) ',
'    returning id into :P3_FORMS_PROJECT_ID;',
'',
'    commit;',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(26942626908736981.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(259644202404940358.4407)
,p_process_sequence=>37
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'FORMS:Insert Forms XML'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_MIG_FORMS'
,p_attribute_03=>'P3_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I'
,p_attribute_12=>'Y'
,p_process_when_button_id=>wwv_flow_api.id(26942626908736981.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(27579001640258883.4407)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set proj id variable'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  :MW_PROJ_ID := wwv_mig_frm_load_xml.g_project_id;',
'end;'))
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\522A\9664\5C08\6848')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\522A\9664\5C08\6848')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(5872827478268282)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(717533351543479866.4407)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'AEMIG/apm_mngproj.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5328821635120223.4407)
,p_plug_name=>unistr('\522A\9664\5C08\6848')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_footer=>unistr('\522A\9664\5C08\6848\5C07\4E0D\6703\522A\9664\4EFB\4F55\7522\751F\7684\61C9\7528\7A0B\5F0F.')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(209334630772713148.4407)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(486766524690194438.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(209334630772713148.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_css_classes=>'a-Button--large'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5329025505120224.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(209334630772713148.4407)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\522A\9664\5C08\6848')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'javascript:confirmDelete(htmldb_delete_message,''DELETE'');'
,p_button_condition=>'P4_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_button_css_classes=>'a-Button--large'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(5329826748120230.4407)
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5330014385120231.4407)
,p_name=>'P4_ID'
,p_item_sequence=>1
,p_item_plug_id=>wwv_flow_api.id(5328821635120223.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(5330200783120246.4407)
,p_name=>'P4_MIGRATION_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(5328821635120223.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5C08\6848\540D\7A31:')
,p_source=>'MIGRATION_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(64984201251447294.4407)
,p_name=>'P4_MIGRATION_TYPE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(5328821635120223.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(331997422021312408.4407)
,p_name=>'P4_PREVIOUS_PAGE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(5328821635120223.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(65100500314579469.4407)
,p_computation_sequence=>10
,p_computation_item=>'MW_PROJ_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select migration_name ',
'from wwv_mig_projects',
'where id = :P4_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(260880816380988418.4407)
,p_computation_sequence=>10
,p_computation_item=>'MW_MIG_PAGE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :MW_MIG_TYPE = ''access'' then',
'    return 2;',
'elsif :MW_MIG_TYPE = ''forms'' then',
'    return 51;',
'end if;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5330618824120250.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_MIG_PROJECTS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_MIG_PROJECTS'
,p_attribute_03=>'P4_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>unistr('\7121\6CD5\64F7\53D6\8CC7\6599\5217.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5330801289120251.4407)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_MIG_PROJECTS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_MIG_PROJECTS'
,p_attribute_03=>'P4_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>unistr('\522A\9664\5C08\6848\5931\6557.')
,p_process_success_message=>unistr('\5DF2\522A\9664\5C08\6848.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(20292309923256849.4407)
,p_process_sequence=>35
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Cleanup WWV_FLOW_FILE_OBJECTS$'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'delete from WWV_FLOW_FILE_OBJECTS$',
'where pathid = :P4_ID;',
'',
'end;'))
,p_process_error_message=>unistr('\7121\6CD5\5728\522A\9664\5C08\6848\6642\6E05\9664 wwv_flow_file_objects$.')
,p_process_when=>':MW_MIG_TYPE = ''access'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5331005030120252.4407)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_ITEMS'
,p_attribute_03=>'MW_PROJ_ID'
,p_process_when_button_id=>wwv_flow_api.id(5329025505120224.4407)
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\61C9\7528\7A0B\5F0F\6A21\578B')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\61C9\7528\7A0B\5F0F\6A21\578B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1569238156139449927.4407)
,p_plug_name=>unistr('\61C9\7528\7A0B\5F0F\6A21\578B')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717558830541505732.4407)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select	 (level-1)*15 indent,',
'         ID,',
'         PAGE_ID,',
'         page_name,',
'	 page_type,',
'         page_source,',
'         sys.dbms_lob.substr(replace(source,chr(10),''''),24,1) source,',
'	 PARENT_PAGE_ID',
' from	 WWV_FLOW_MODEL_PAGES',
'where model_id = :P7_MODEL_ID',
'start with parent_page_id is null and model_id = :P7_MODEL_ID',
'connect by prior id = parent_page_id and model_id = :P7_MODEL_ID',
'order siblings by display_sequence, id'))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1569238226622449927.4407)
,p_name=>'Application Model'
,p_max_row_count=>'1000000'
,p_max_row_count_message=>unistr('\6B64\5831\8868\7684\8CC7\6599\5217\6578\76EE\4E0A\9650\70BA #MAX_ROW_COUNT# \500B\8CC7\6599\5217.  \8ACB\5957\7528\7BE9\9078, \4EE5\6E1B\5C11\60A8\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_search_bar=>'N'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_owner=>'HILARY'
,p_internal_uid=>1569238226622449927
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569238445000449932.4407)
,p_db_column_name=>'INDENT'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\7E2E\6392')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569238594680449933.4407)
,p_db_column_name=>'ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569238626885449934.4407)
,p_db_column_name=>'PAGE_ID'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\9801\9762 ID')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569238792087449934.4407)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\9801\9762\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569238814211449934.4407)
,p_db_column_name=>'PAGE_TYPE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\9801\9762\985E\578B')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569238947721449934.4407)
,p_db_column_name=>'PAGE_SOURCE'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\9801\9762\4F86\6E90')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569239004342449934.4407)
,p_db_column_name=>'SOURCE'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\4F86\6E90')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1569239141279449934.4407)
,p_db_column_name=>'PARENT_PAGE_ID'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\7236\9805\9801\9762 ID')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1500323753871760221.4407)
,p_name=>'P7_MODEL_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1569238156139449927.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\65B0\9801\9762\5B9A\7FA9')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\65B0\9801\9762\5B9A\7FA9')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_html_page_onload=>'onLoad="modelDisableLinkText();modelDisableItem(document.getElementById(''P11_LINK_COLUMN''), document.getElementById(''P11_USE_LINK_COLUMN_0''),''ONLOAD'');"'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'',
'  function modelDisableItem(itemNode, checkItemNode, itemVal) ',
'  {',
'    if($x(itemNode))',
'    {',
'      if (itemVal!=''ONLOAD'') ',
'      {',
'        itemNode.value = itemVal;',
'      }   ',
'      html_disableItem(itemNode, checkItemNode.checked);',
'    }',
'  }',
'    ',
'  function modelDisableItem2(itemNode, checkItemNode, itemVal) ',
'  {',
'    itemNode.value = itemVal;',
'    if (checkItemNode.checked==false) ',
'    {',
'      if (document.getElementById(''P11_LINK_COLUMN'').value!=''LINK$'') ',
'      {',
'                document.getElementById(''P11_LINK_TEXT'').value=''#''+document.getElementById(''P11_LINK_COLUMN'').value+''#'';',
'            }    ',
'        }',
'        html_disableItem(itemNode, checkItemNode.checked);',
'    }',
'    ',
'  function modelDisableLinkText() ',
'  {',
'    if($x(''P11_LINK_TEXT''))',
'    {',
'      if (document.getElementById(''P11_LINK_TEXT'').value.length==0) ',
'      {',
'        html_disableItem(document.getElementById(''P11_LINK_TEXT''), true);',
'        html_disableItem($x(''P11_LINK_COLUMN''), true);',
'      } ',
'      else ',
'      {',
'        document.getElementById(''P11_USE_THEME_BUTTON_0'').checked=false;',
'      }',
'    }',
'  }',
'',
'    htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'  function modelDisableItems(itemVal)',
'  {',
'    if (itemVal==''LINK_COLUMN'')',
'    {',
'      html_disableItem(''P11_LINK_COLUMN'', true);',
'      html_disableItem(''P11_LINK_TEXT'', true);',
'    }',
'    if (itemVal == ''REPORT_COLUMN'')',
'    {',
'      html_disableItem(''P11_LINK_TEXT'', true);',
'      html_disableItem(''P11_LINK_COLUMN'',false);',
'    }',
'    if (itemVal == ''CUSTOM_LINK'')',
'    {',
'      html_disableItem(''P11_LINK_COLUMN'', true);',
'      html_disableItem(''P11_LINK_TEXT'',false);',
'    }',
'  }',
'',
'function setPageName(pName)',
'  {',
'    var get = new htmldb_Get(null,html_GetElement(''pFlowId'').value,''APPLICATION_PROCESS=dummy'',0);',
'    get.add(pName, $x(pName).value);',
'    gReturn = get.get();',
'    get = null;',
'  }',
'',
'</script>'))
,p_step_template=>wwv_flow_api.id(717533351543479866.4407)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6729919867658132.4407)
,p_plug_name=>unistr('\9801\9762\5B9A\7FA9')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6730106581658152.4407)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6730312066658152.4407)
,p_plug_name=>unistr('\6B64\9801\9762\8CC7\6599\6B04\95DC\806F\9805\76EE\7684\7236\9805\9801\9762')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--simple'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * from wwv_flow_model_pages ',
'where id = nvl(replace(:P11_PARENT_PAGE_ID,''%''||''null%'',0),0)',
'and page_type = ''REPORT'''))
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(6730500881658158.4407)
,p_name=>'&P11_COL_REGION_HEADING.'
,p_template=>wwv_flow_api.id(717561032869505733.4407)
,p_display_sequence=>35
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--simple'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_new_grid_row=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_TABFORM'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'"ID",',
'"ID" ID_DISPLAY,',
'"MODEL_REGION_ID",',
'"COLUMN_NAME",',
'"COLUMN_DISPLAY_NAME",',
'"DISPLAY_AS_FORM",',
'"DISPLAY_AS_TAB_FORM",',
'"DATATYPE",',
'"ALIGNMENT",',
'"FORMAT_MASK",',
'"HIDDEN_COLUMN",',
'"SORT_SEQUENCE",',
'"DISPLAY_WIDTH",',
'"MAX_WIDTH",',
'"HEIGHT",',
'"HELP_TEXT",',
'"SECURITY_GROUP_ID"',
'from "#OWNER#"."WWV_FLOW_MODEL_PAGE_COLS"',
'where model_region_id = :P11_REGION_ID',
'and column_name not like ''LINK$%'''))
,p_display_when_condition=>'P11_PAGE_TYPE'
,p_display_when_cond2=>'BLANK'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_translate_title=>'N'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(717629762332532068.4407)
,p_query_num_rows=>100000
,p_query_show_nulls_as=>'(null)'
,p_query_no_data_found=>unistr('\5831\8868\672A\50B3\56DE\4EFB\4F55\8CC7\6599\5217.')
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6730720154658161.4407)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_display_as=>'HIDDEN'
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_pk_col_source_type=>'T'
,p_lov_display_extra=>'YES'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'ID'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6730821661658161.4407)
,p_query_column_id=>2
,p_column_alias=>'ID_DISPLAY'
,p_column_display_sequence=>2
,p_column_heading=>'Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_column_width=>16
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'ID_DISPLAY'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(145631929464341240.4407)
,p_query_column_id=>3
,p_column_alias=>'MODEL_REGION_ID'
,p_column_display_sequence=>17
,p_column_heading=>'ID'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731006303658162.4407)
,p_query_column_id=>4
,p_column_alias=>'COLUMN_NAME'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\540D\7A31')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'COLUMN_NAME'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731132507658162.4407)
,p_query_column_id=>5
,p_column_alias=>'COLUMN_DISPLAY_NAME'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\6A19\984C / \6A19\7C64')
,p_use_as_row_header=>'N'
,p_display_as=>'TEXT'
,p_column_width=>12
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731220564658162.4407)
,p_query_column_id=>6
,p_column_alias=>'DISPLAY_AS_FORM'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\986F\793A\985E\578B')
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(29578107222858066)
,p_lov_show_nulls=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\9805\76EE\985E\578B -')
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731303016658162.4407)
,p_query_column_id=>7
,p_column_alias=>'DISPLAY_AS_TAB_FORM'
,p_column_display_sequence=>8
,p_column_heading=>unistr('\986F\793A\985E\578B')
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'TABULARFORM'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(6763505062658374)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731428904658162.4407)
,p_query_column_id=>8
,p_column_alias=>'DATATYPE'
,p_column_display_sequence=>9
,p_column_heading=>unistr('\8CC7\6599\985E\578B')
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'DATATYPE'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731528464658162.4407)
,p_query_column_id=>9
,p_column_alias=>'ALIGNMENT'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\5C0D\9F4A\65B9\5F0F')
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'REPORT:TABULARFORM'
,p_display_as=>'SELECT_LIST_FROM_LOV'
,p_named_lov=>wwv_flow_api.id(6767129339658379)
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'YES'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'ALIGNMENT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731606940658162.4407)
,p_query_column_id=>10
,p_column_alias=>'FORMAT_MASK'
,p_column_display_sequence=>10
,p_column_heading=>unistr('\683C\5F0F\906E\7F69')
,p_use_as_row_header=>'N'
,p_display_as=>'TEXT'
,p_column_width=>8
,p_derived_column=>'N'
,p_include_in_export=>'Y'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'FORMAT_MASK'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731722670658162.4407)
,p_query_column_id=>11
,p_column_alias=>'HIDDEN_COLUMN'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\986F\793A')
,p_display_when_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'REPORT:TABULARFORM'
,p_display_as=>'SELECT_LIST_FROM_LOV'
,p_named_lov=>wwv_flow_api.id(6766513696658378)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'NO'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731811895658163.4407)
,p_query_column_id=>12
,p_column_alias=>'SORT_SEQUENCE'
,p_column_display_sequence=>11
,p_column_heading=>unistr('\6392\5E8F\9806\5E8F')
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'REPORT'
,p_display_as=>'SELECT_LIST_FROM_QUERY'
,p_inline_lov=>'select i d, i r from wwv_flow_dual100 where i<=3'
,p_lov_show_nulls=>'YES'
,p_lov_null_text=>' - '
,p_lov_null_value=>'0'
,p_column_width=>4
,p_lov_display_extra=>'NO'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'SORT_SEQUENCE'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6731917042658164.4407)
,p_query_column_id=>13
,p_column_alias=>'DISPLAY_WIDTH'
,p_column_display_sequence=>13
,p_column_heading=>unistr('\9805\76EE\5BEC\5EA6')
,p_display_when_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM:TABULARFORM'
,p_display_as=>'TEXT'
,p_lov_show_nulls=>'NO'
,p_column_width=>3
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6732002070658164.4407)
,p_query_column_id=>14
,p_column_alias=>'MAX_WIDTH'
,p_column_display_sequence=>14
,p_column_heading=>unistr('\5BEC\5EA6\4E0A\9650')
,p_display_when_cond_type=>'NEVER'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'TEXT'
,p_lov_show_nulls=>'NO'
,p_column_width=>3
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6732122721658164.4407)
,p_query_column_id=>15
,p_column_alias=>'HEIGHT'
,p_column_display_sequence=>15
,p_column_heading=>unistr('\9AD8\5EA6')
,p_display_when_cond_type=>'NEVER'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'TEXT'
,p_lov_show_nulls=>'NO'
,p_column_width=>3
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6732218198658164.4407)
,p_query_column_id=>16
,p_column_alias=>'HELP_TEXT'
,p_column_display_sequence=>16
,p_column_heading=>'Help Text'
,p_hidden_column=>'Y'
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_SOURCE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(6732309118658164.4407)
,p_query_column_id=>17
,p_column_alias=>'SECURITY_GROUP_ID'
,p_column_display_sequence=>12
,p_column_heading=>'Security Group Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_column_width=>16
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'SECURITY_GROUP_ID'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6771905958671660.4407)
,p_column_sequence=>1
,p_query_column_name=>'ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772001065671662.4407)
,p_column_sequence=>2
,p_query_column_name=>'ID_DISPLAY'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(145630406324341237.4407)
,p_column_sequence=>3
,p_query_column_name=>'MODEL_REGION_ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772214682671662.4407)
,p_column_sequence=>4
,p_query_column_name=>'COLUMN_NAME'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772329426671663.4407)
,p_column_sequence=>5
,p_query_column_name=>'COLUMN_DISPLAY_NAME'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772410701671663.4407)
,p_column_sequence=>6
,p_query_column_name=>'DISPLAY_AS_FORM'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772525652671663.4407)
,p_column_sequence=>7
,p_query_column_name=>'DISPLAY_AS_TAB_FORM'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772619658671663.4407)
,p_column_sequence=>8
,p_query_column_name=>'DATATYPE'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772709319671663.4407)
,p_column_sequence=>9
,p_query_column_name=>'ALIGNMENT'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772828931671663.4407)
,p_column_sequence=>10
,p_query_column_name=>'FORMAT_MASK'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6772927954671663.4407)
,p_column_sequence=>11
,p_query_column_name=>'HIDDEN_COLUMN'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6773016727671663.4407)
,p_column_sequence=>12
,p_query_column_name=>'SORT_SEQUENCE'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6773127043671663.4407)
,p_column_sequence=>13
,p_query_column_name=>'DISPLAY_WIDTH'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6773214094671663.4407)
,p_column_sequence=>14
,p_query_column_name=>'MAX_WIDTH'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6773325993671663.4407)
,p_column_sequence=>15
,p_query_column_name=>'HEIGHT'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6773420706671663.4407)
,p_column_sequence=>16
,p_query_column_name=>'HELP_TEXT'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(6773512598671663.4407)
,p_column_sequence=>17
,p_query_column_name=>'SECURITY_GROUP_ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22898708565885414.4407)
,p_plug_name=>unistr('\5C0E\89BD')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--simple'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>45
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P11_PAGE_TYPE'
,p_plug_display_when_cond2=>'BLANK'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6732801370658186.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(6730106581658152.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(6733027183658198.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(6730106581658152.4407)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_condition=>'P11_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(6743722184658311.4407)
,p_branch_name=>'Go To Page 11'
,p_branch_action=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::P11_PARENT_PAGE_ID,P11_PAGE_NAME,P11_IMPLEMENTATION:&P11_PARENT_PAGE_ID.,&P11_PAGE_NAME.,&P11_IMPLEMENTATION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'P11_PARENT_PAGE_ID'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6733230991658200.4407)
,p_name=>'P11_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6733410117658218.4407)
,p_name=>'P11_PAGE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762:')
,p_source=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\552F\4E00\7684\9801\78BC.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6733911997658223.4407)
,p_name=>'P11_PAGE_TYPE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\985E\578B:')
,p_source=>'PAGE_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'APP WIZARD PAGE TYPE'
,p_lov=>'.'||wwv_flow_api.id(6745605530658343.4407)||'.'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
unistr('<li><b>\7A7A\767D</b/>: \5EFA\7ACB\4E0D\542B\5167\5EFA\529F\80FD\7684\9801\9762.</li>'),
unistr('<li><b>\5831\8868</b/>: \5EFA\7ACB\5167\542B SQL \67E5\8A62\683C\5F0F\5316\7D50\679C\7684\9801\9762. \60A8\53EF\4EE5\9078\64C7\5EFA\7ACB\4EE5\6240\9078\8868\683C\70BA\57FA\790E\7684\5831\8868, \6216\8005\4EE5\60A8\63D0\4F9B\7684\81EA\8A02 SQL SELECT \6558\8FF0\53E5\6216 PL/SQL \51FD\6578 (\50B3\56DE SQL SELECT \6558\8FF0\53E5) \70BA\57FA\790E\7684\5831\8868.</li>'),
unistr('<li><b>\8868\55AE</b/>: \5EFA\7ACB\8868\55AE\4F86\66F4\65B0\8CC7\6599\5EAB\8868\683C\4E2D\7684\55AE\4E00\8CC7\6599\5217.</li>'),
unistr('<li><b>\5217\8868\5316\8868\55AE</b/>: \5EFA\7ACB\4E00\500B\5728\8CC7\6599\5EAB\8868\683C\4E2D\7684\591A\500B\8CC7\6599\5217\57F7\884C\66F4\65B0, \63D2\5165\53CA\522A\9664\4F5C\696D\7684\8868\55AE.</li>'),
unistr('<li><b>\5831\8868\548C\8868\55AE</b/>: \5EFA\7ACB\5169\9801\7684\5831\8868\548C\8868\55AE\7D44\5408. \5728\7B2C\4E00\9801\4E2D, \4F7F\7528\8005\53EF\4EE5\9078\53D6\8981\66F4\65B0\7684\8CC7\6599\5217. \5728\7B2C\4E8C\9801\4E2D, \4F7F\7528\8005\53EF\4EE5\66F4\65B0\9078\53D6\7684\8868\683C\6216\8996\89C0\8868.</li>'),
'</ul>',
'',
''))
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6734408058658225.4407)
,p_name=>'P11_PARENT_PAGE_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\7236\9805\9801\9762')
,p_source=>'PARENT_PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(page_name)||'' (''||page_id||'')'' p, id r',
'from WWV_FLOW_MODEL_PAGES ',
'where model_id = :P33_MODEL_ID and id != :P11_ID',
'order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \6C92\6709\7236\9805 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\9801\9762\53EF\4EE5\662F\5176\4ED6\9801\9762\7684\5F9E\5C6C\9801\9762. \60A8\53EF\4EE5\4F7F\7528\9801\7C64, \5C0E\89BD\6E05\55AE\6216\8CC7\6599\6B04\9023\7D50\8A2D\5B9A\5F9E\7236\9805\9801\9762\5230\5B50\9805\9801\9762\7684\79FB\52D5. \5982\679C\9078\53D6\4E00\6216\5169\500B\5C64\6B21\7684\9801\7C64, \5373\53EF\4F7F\7528\9801\7C64\5B58\53D6\6700\4E0A\5C64\9801\9762. \81F3\65BC\8F03\4F4E\5C64\6B21\7684\9801\9762, \53EF\4EE5\4F7F\7528\7236\9805\5831\8868\9801\9762\7684\8CC7\6599\6B04\9023\7D50\6216\4F7F\7528\5C0E\89BD\6E05\55AE (\82E5\672A\5B9A\7FA9\9023\7D50) \5B58\53D6. \5982\679C\9078\53D6\5169\500B\5C64\6B21\7684\9801\7C64, \4E5F\53EF\4EE5\4F7F\7528\7B2C\4E8C\5C64\7684\9801\7C64\5B58\53D6\7B2C\4E8C\5C64\7684\9801\9762.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6734918325658227.4407)
,p_name=>'P11_PARENT_LINK_FROM_COLUMN1'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8CC7\6599\6B04 1')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select PARENT_LINK_FROM_COLUMN1 from wwv_flow_model_page_regions',
'where model_page_id = :P11_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PARENT_PAGE_COLUMNS P11'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'   select id from wwv_flow_model_page_regions',
'   where model_page_id = (',
'       select id ',
'       from   wwv_flow_model_pages ',
'       where  model_id = :P33_MODEL_ID',
'       and    id  = :P11_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 - ')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\503C\64F7\53D6\800C\5F97. \8CC7\6599\6B04 1 \6B04\4F4D\4E2D\986F\793A\7684\662F\884D\751F\7B2C\4E00\500B\4E3B\7D22\5F15\9375\503C\7684\5831\8868\8CC7\6599\6B04.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6735430175658228.4407)
,p_name=>'P11_PARENT_LINK_FROM_COLUMN2'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8CC7\6599\6B04 2')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select PARENT_LINK_FROM_COLUMN2 from wwv_flow_model_page_regions',
'where model_page_id = :P11_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PARENT_PAGE_COLUMNS P11'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'   select id from wwv_flow_model_page_regions',
'   where model_page_id = (',
'       select id ',
'       from   wwv_flow_model_pages ',
'       where  model_id = :P33_MODEL_ID',
'       and    id  = :P11_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\503C\64F7\53D6\800C\5F97. \8CC7\6599\6B04 2 \6B04\4F4D\4E2D\986F\793A\7684\662F\884D\751F\7B2C\4E8C\500B\4E3B\7D22\5F15\9375\503C\7684\5831\8868\8CC7\6599\6B04.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6735927001658229.4407)
,p_name=>'P11_LINK_TO_COLUMN1'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'&P11_PAGE_ITEM_LABEL.'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_TO_COLUMN1 from wwv_flow_model_page_regions',
'where model_page_id = :P11_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PAGE_COLUMNS P11'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols',
'where  model_region_id = :P11_REGION_ID'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 - ')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\64F7\53D6\800C\5F97. \9801\9762\9805\76EE\6B04\4F4D\4E2D\986F\793A\7684\662F\5C07\6703\4F7F\7528\8CC7\6599\6B04\9023\7D50\63D0\4F9B\7684\503C\8D77\59CB\7684\4E3B\7D22\5F15\9375\9805\76EE.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6736430699658230.4407)
,p_name=>'P11_LINK_TO_COLUMN2'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'&P11_PAGE_ITEM_LABEL.'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_TO_COLUMN2 from wwv_flow_model_page_regions',
'where model_page_id = :P11_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PAGE_COLUMNS P11'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols',
'where  model_region_id = :P11_REGION_ID'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\64F7\53D6\800C\5F97. \9801\9762\9805\76EE\6B04\4F4D\4E2D\986F\793A\7684\662F\5C07\6703\4F7F\7528\8CC7\6599\6B04\9023\7D50\63D0\4F9B\7684\503C\8D77\59CB\7684\4E3B\7D22\5F15\9375\9805\76EE.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6736927642658231.4407)
,p_name=>'P11_PAGE_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\540D\7A31')
,p_source=>'PAGE_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_tag_attributes=>'onChange="setPageName(this.id);"'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\60A8\61C9\7528\7A0B\5F0F\4E2D\9801\9762\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6737429039658231.4407)
,p_name=>'P11_SOURCE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\4F86\6E90\67E5\8A62:')
,p_source=>'select ''<pre>''||source||''</pre>'' from wwv_flow_model_pages where id = :P11_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P11_PAGE_SOURCE'
,p_display_when2=>'QUERY'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\65B0\9801\9762\7684\4F86\6E90. \5831\8868\53EF\4EE5\8868\683C\548C\67E5\8A62\4F5C\70BA\5176\57FA\790E. \8868\55AE\548C\5217\8868\5316\8868\55AE\5247\53EA\80FD\4EE5\8868\683C\4F5C\70BA\5176\57FA\790E.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6737926932658233.4407)
,p_name=>'P11_DISPLAY_SEQUENCE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9806\5E8F')
,p_source=>'DISPLAY_SEQUENCE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>5
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\8F38\5165\9801\9762\986F\793A\9806\5E8F')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6738403658658234.4407)
,p_name=>'P11_PAGE_SOURCE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\4F86\6E90:')
,p_source=>'PAGE_SOURCE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'PAGE_SOURCE'
,p_lov=>'.'||wwv_flow_api.id(6744724810658339.4407)||'.'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\6307\5B9A\9801\9762\4F86\6E90. \5831\8868\53EF\4EE5\8868\683C\548C\67E5\8A62\4F5C\70BA\5176\57FA\790E. \8868\55AE\548C\5217\8868\5316\8868\55AE\5247\53EA\80FD\4EE5\8868\683C\4F5C\70BA\5176\57FA\790E.')
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6738914217658236.4407)
,p_name=>'P11_SOURCE_TABLE'
,p_item_sequence=>65
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\4F86\6E90\8868\683C:')
,p_source=>'select source from wwv_flow_model_pages where id = :P11_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_display_when=>'P11_PAGE_SOURCE'
,p_display_when2=>'TABLE'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\9801\9762\4F86\6E90. \5831\8868\53EF\4EE5\8868\683C\548C\67E5\8A62\4F5C\70BA\5176\57FA\790E. \8868\55AE\548C\5217\8868\5316\8868\55AE\5247\53EA\80FD\4EE5\8868\683C\4F5C\70BA\5176\57FA\790E.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6739402858658237.4407)
,p_name=>'P11_COL_REGION_HEADING'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P11_PAGE_TYPE in (''REPORT'',''TABULARFORM'') then',
'   return wwv_flow_lang.system_message(''REPORT COLUMNS'');',
'elsif :P11_PAGE_TYPE = ''FORM'' then',
'   return wwv_flow_lang.system_message(''PAGE ITEMS'');',
'end if;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6739616942658239.4407)
,p_name=>'P11_LINK_COLUMN'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_prompt=>unistr('\9023\7D50\8CC7\6599\6B04')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_COLUMN from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P11_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PARENT_PAGE_COLUMNS P11'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'   select id from wwv_flow_model_page_regions',
'   where model_page_id = (',
'       select id ',
'       from   wwv_flow_model_pages ',
'       where  model_id = :P33_MODEL_ID',
'       and    id  = :P11_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\9023\7D50\8CC7\6599\6B04 -')
,p_lov_null_value=>'LINK$'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\6307\5B9A\8981\7528\4F86\986F\793A\8CC7\6599\6B04\9023\7D50\7684\8CC7\6599\6B04. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6740130126658240.4407)
,p_name=>'P11_LINK_TEXT'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_prompt=>unistr('\9023\7D50\6587\5B57')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_TEXT from wwv_flow_model_page_regions',
'where model_page_id = :P11_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\8981\4EE5\9023\7D50\65B9\5F0F\986F\793A\7684 HTML \6587\5B57. \8ACB\4F7F\7528\5F71\50CF\6A19\8A18\4F86\986F\793A\5F71\50CF.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6740600503658240.4407)
,p_name=>'P11_USE_LINK_COLUMN'
,p_item_sequence=>205
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''LINK_COLUMN'' from wwv_flow_model_page_cols',
'where model_region_id = nvl(replace(:P11_REGION_ID,''%''||''null%'',0),0)',
'and column_name like ''LINK$%'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'MODEL_LINK_EXTRA_COLUMN'
,p_lov=>'.'||wwv_flow_api.id(6746916502658348.4407)||'.'
,p_tag_attributes=>'onClick="modelDisableItem(document.getElementById(''P11_LINK_COLUMN''), this,''LINK$'');"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6740814562658243.4407)
,p_name=>'P11_REPORT_COLUMN_LABEL'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_source=>'wwv_flow_lang.system_message(''REPORT_COLUMN'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6741003911658244.4407)
,p_name=>'P11_PAGE_ITEM_LABEL'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P11_PAGE_TYPE in (''REPORT'',''TABULARFORM'') then',
'   return wwv_flow_lang.system_message(''REPORT_COLUMN'');',
'elsif :P11_PAGE_TYPE = ''FORM'' then',
'   return wwv_flow_lang.system_message(''PAGE_ITEM'');',
'end if;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6741223255658244.4407)
,p_name=>'P11_PARENT_REPORT_COLUM_HEADING'
,p_item_sequence=>212
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_source=>'wwv_flow_lang.system_message(''PARENT_REPORT_COLUMN'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6741427461658245.4407)
,p_name=>'P11_REPORT_COLUMN_HEADING'
,p_item_sequence=>214
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_source=>'wwv_flow_lang.system_message(''LINK_TO_THIS_PAGE_ITEM'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6741624076658245.4407)
,p_name=>'P11_USE_THEME_BUTTON'
,p_item_sequence=>211
,p_item_plug_id=>wwv_flow_api.id(6730312066658152.4407)
,p_item_default=>'THEME'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'MODEL_USE_THEME_BUTTON'
,p_lov=>'.'||wwv_flow_api.id(6747416812658349.4407)||'.'
,p_tag_attributes=>' onClick="modelDisableItem2(document.getElementById(''P11_LINK_TEXT''), this,'''');"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(23542508469159976.4407)
,p_name=>'P11_NAVIGATION'
,p_item_sequence=>290
,p_item_plug_id=>wwv_flow_api.id(22898708565885414.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Vertical Unordered List with Bullets'
,p_prompt=>unistr('\9078\53D6\5C0E\89BD\6A23\5F0F:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(LIST_TEMPLATE_NAME,''Vertical Unordered List with Bullets'')',
'from   wwv_mig_rev_apexapp',
'where  project_id = :MW_PROJ_ID',
'and    page_id = :P11_PAGE_ID',
'and    security_group_id = :flow_security_group_id',
'and    flow_id = :MW_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HOME PAGE NAVIGATION'
,p_lov=>'.'||wwv_flow_api.id(22899924972899541.4407)||'.'
,p_cHeight=>1
,p_tag_attributes2=>'class="instructiontext"'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li><b>\542B\9805\76EE\7B26\865F\7684\5782\76F4\6E05\55AE (\672A\6392\5217)</b>: \4EE5\542B\9805\76EE\7B26\865F\7684\5782\76F4\6587\5B57\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('<li><b>\5782\76F4\5F71\50CF\6E05\55AE</b>: \4EE5\5782\76F4\7684\5F71\50CF\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('<li><b>\6C34\5E73\5F71\50CF\6E05\55AE</b>: \4EE5\6C34\5E73\7684\5F71\50CF\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('\9810\8A2D\9078\9805\70BA\300C\542B\9805\76EE\7B26\865F\7684\5782\76F4\6E05\55AE (\672A\6392\5217)\300D.  \6B64\6E05\55AE\6703\986F\793A\5728\7236\9805\9801\9762\7684\5C0E\89BD\5340\57DF.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(26653801782406050.4407)
,p_name=>'P11_PAGE_ICON'
,p_item_sequence=>300
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_prompt=>unistr('\9801\9762\5716\793A')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LIST_ITEM_ICON',
'from wwv_mig_rev_apexapp',
'where page_id = :P11_PAGE_ID',
'and project_id = :MW_PROJ_ID',
'and security_group_id = :flow_security_group_id',
'--and dbid = :P2_DBID',
'and flow_id = :MW_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'PAGE_ICONS_2'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select icon_name d, icon_name r',
'from WWV_FLOW_STANDARD_ICONS',
'order by 1'))
,p_cSize=>30
,p_cHeight=>1
,p_tag_attributes=>'onchange="htmldb_item_change(this)"'
,p_display_when=>'P11_PAGE_TYPE'
,p_display_when2=>'BLANK'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\5F9E\7522\751F\7684 Oracle &PRODUCT_NAME. \61C9\7528\7A0B\5F0F\5167\9078\53D6\4E00\500B\8981\8207\6B64\9801\9762\7522\751F\95DC\806F\7684\9801\9762\5716\793A.  \8ACB\4F7F\7528\624B\96FB\7B52\5716\793A\4F86\67E5\770B\5716\793A\9078\9805\53CA\9078\53D6\5716\793A.')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(28672507940647978.4407)
,p_name=>'P11_SELECTED_ICON'
,p_item_sequence=>310
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_post_element_text=>'<img src="#IMAGE_PREFIX#menu/&P11_PAGE_ICON." width="64" height="64" border="1" bordercolor="black" alt="&P11_PAGE_ICON.">'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P11_PAGE_TYPE'
,p_display_when2=>'BLANK'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(145638213414355723.4407)
,p_name=>'P11_REGION_ID'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ID from WWV_FLOW_MODEL_PAGE_REGIONS',
'where model_page_id = :P11_ID',
'and region_id = 1'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(148666515504542253.4407)
,p_name=>'P11_IMPLEMENTATION'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(6729919867658132.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'INTERACTIVE'
,p_prompt=>unistr('\5BE6\884C')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select REPORT_IMPLEMENTATION ',
'from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P11_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'REPORT TYPE: INTERACTIVE OR CLASSIC'
,p_lov=>'.'||wwv_flow_api.id(148634518096505157.4407)||'.'
,p_cHeight=>1
,p_display_when=>'P47_PAGE_TYPE'
,p_display_when2=>'REPORT'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(6741913947658249.4407)
,p_computation_sequence=>10
,p_computation_item=>'P11_LINK_COLUMN'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'LINK$01'
,p_compute_when=>'P11_USE_LINK_COLUMN'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(6742130493658254.4407)
,p_validation_name=>'P11_PAGE_NAME'
,p_validation_sequence=>10
,p_validation=>'P11_PAGE_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\9801\9762\540D\7A31.')
,p_when_button_pressed=>wwv_flow_api.id(6733027183658198.4407)
,p_associated_item=>wwv_flow_api.id(6736927642658231.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(615920809930275615.4407)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(6732801370658186.4407)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(615921151675275615.4407)
,p_event_id=>wwv_flow_api.id(615920809930275615.4407)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1158731833766170402.4407)
,p_name=>'Update Selected Icon'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P11_PAGE_ICON'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1158732136148170402.4407)
,p_event_id=>wwv_flow_api.id(1158731833766170402.4407)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6742217414658260.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_MODEL_PAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_MODEL_PAGES'
,p_attribute_03=>'P11_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>unistr('\7121\6CD5\64F7\53D6\8CC7\6599\5217.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6742423703658297.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(6730500881658158.4407)
,p_process_type=>'NATIVE_TABFORM_UPDATE'
,p_process_name=>'ApplyMRU'
,p_attribute_02=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_attribute_03=>'ID'
,p_process_error_message=>unistr('\7121\6CD5\8655\7406\66F4\65B0.')
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
,p_process_success_message=>unistr('\5DF2\66F4\65B0 #MRU_COUNT# \500B\8CC7\6599\5217, \5DF2\63D2\5165 #MRI_COUNT# \500B\8CC7\6599\5217.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(150171726759383753.4407)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update wwv_flow_model_page_regions'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'    update ',
'        WWV_FLOW_MODEL_PAGE_REGIONS',
'    set ',
'        LINK_COLUMN = :P11_LINK_COLUMN,',
'        LINK_TEXT = :P11_LINK_TEXT,',
'        PARENT_LINK_FROM_COLUMN1 = :P11_PARENT_LINK_FROM_COLUMN1,',
'        LINK_TO_COLUMN1 = :P11_LINK_TO_COLUMN1',
'    where ',
'        MODEL_PAGE_ID = :P11_ID',
'    and ',
'        SECURITY_GROUP_ID = :flow_security_group_id;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
,p_process_when=>'P11_PARENT_PAGE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(150172305766387130.4407)
,p_process_sequence=>23
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Link Column2 Information'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'update WWV_FLOW_MODEL_PAGE_REGIONS',
'    set PARENT_LINK_FROM_COLUMN2 = :P11_PARENT_LINK_FROM_COLUMN2,',
'    LINK_TO_COLUMN2 = :P11_LINK_TO_COLUMN2',
'    where MODEL_PAGE_ID = :P11_ID',
'    and SECURITY_GROUP_ID = :flow_security_group_id;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
,p_process_when=>'if (:P11_PARENT_LINK_FROM_COLUMN2 IS NOT NULL) and (:P11_LINK_TO_COLUMN IS NOT NULL) and (:P11_PARENT_PAGE_ID IS NOT NULL)'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6742602326658298.4407)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_MODEL_PAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_MODEL_PAGES'
,p_attribute_03=>'P11_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>unistr('\7121\6CD5\8655\7406\8868\683C WWV_FLOW_MODEL_PAGES \7684\8CC7\6599\5217.')
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
,p_process_success_message=>unistr('\52D5\4F5C\5DF2\8655\7406.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(23542915049161829.4407)
,p_process_sequence=>31
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Page Navigation setting'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'  update wwv_mig_rev_apexapp',
'  set list_template_name = :P11_NAVIGATION',
'  where page_id = :P11_PAGE_ID',
'  and flow_id = :MW_APPLICATION_ID',
'  and project_id = :MW_PROJ_ID',
'  and security_group_id = :flow_security_group_id',
'  and owner = :MW_SCHEMA;',
'',
'  if :P11_PAGE_TYPE = ''BLANK'' then',
'    update wwv_mig_rev_apexapp',
'    set list_item_icon = ''migration/mig_menu1.png''',
'    where page_id = :P11_PAGE_ID',
'    and flow_id = :MW_APPLICATION_ID',
'    and project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and owner = :MW_SCHEMA;',
'  else',
'    update wwv_mig_rev_apexapp',
'    set list_item_icon = :P11_PAGE_ICON',
'    where page_id = :P11_PAGE_ID',
'    and flow_id = :MW_APPLICATION_ID',
'    and project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and owner = :MW_SCHEMA;',
'  end if;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(148668001436547606.4407)
,p_process_sequence=>32
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Report Implementation'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    update WWV_FLOW_MODEL_PAGE_REGIONS',
'    set REPORT_IMPLEMENTATION = :P11_IMPLEMENTATION',
'    where MODEL_PAGE_ID = :P11_ID',
'    and SECURITY_GROUP_ID = :flow_security_group_id;',
' end;'))
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
,p_process_when=>'P11_PAGE_TYPE'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'REPORT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6742821137658299.4407)
,p_process_sequence=>35
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add link column'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'insert into wwv_flow_model_page_cols (',
'   model_region_id,',
'   column_name,',
'   column_display_name,               ',
'   datatype,',
'   display_as_tab_form',
') values (',
'   :P11_REGION_ID,',
'   ''LINK$01'',',
'   ''&nbsp;'',',
'   ''VARCHAR2'',',
'   ''WITHOUT_MODIFICATION''',
');'))
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'   if :P11_USE_LINK_COLUMN is not null then',
'      for c1 in (',
'         select 1 from wwv_flow_model_page_cols',
'         where model_region_id = :P11_REGION_ID',
'         and column_name like ''LINK$%''',
'      ) loop',
'         return false;',
'      end loop;',
'      return true;',
'   else',
'      return false;',
'   end if;',
'',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6743005207658300.4407)
,p_process_sequence=>36
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete link column'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'delete from wwv_flow_model_page_cols',
'where model_region_id = :P11_REGION_ID',
'and column_name like ''LINK$%'';'))
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'   if :P11_USE_LINK_COLUMN is null then',
'      for c1 in (',
'         select 1 from wwv_flow_model_page_cols',
'         where model_region_id = nvl(replace(:P11_REGION_ID,''%''||''null%'',0),0)',
'         and column_name like ''LINK$%''',
'   	  ) loop',
'	        return true;',
'   	  end loop;',
'	     return false;',
'   else',
'      return false;',
'   end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6743229743658301.4407)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'43,11'
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6743403424658301.4407)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reload base and close'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.prn(''<script  language="JavaScript">''||chr(10));',
'sys.htp.prn(''v_flowid = opener.document.getElementById(''''pFlowId'''').value;''||chr(10));',
'sys.htp.prn(''v_stepid = opener.document.getElementById(''''pFlowStepId'''').value;''||chr(10));',
'sys.htp.prn(''v_sessionid = opener.document.getElementById(''''pInstance'''').value;''||chr(10));',
'sys.htp.prn(''v_redirect = ''''f?p=''''+v_flowid+'''':''''+v_stepid+'''':''''+v_sessionid;''||chr(10));',
'sys.htp.prn(''window.opener.window.location=v_redirect;''||chr(10));',
'sys.htp.prn(''window.close();'');',
'sys.htp.prn(''</script>''||chr(10));'))
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(615920447573273279.4407)
,p_process_sequence=>60
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(6733027183658198.4407)
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_api.create_page(
 p_id=>17.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\8996\89BA\5C6C\6027')
,p_step_title=>unistr('\8996\89BA\5C6C\6027')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280692031983283006)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(717527373719479827.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/fmig_rev.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(310700721366880725.4407)
,p_plug_name=>unistr('\8996\89BA\5C6C\6027')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717558830541505732.4407)
,p_plug_display_sequence=>35
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select b.id,',
'       b.name,',
'       b.fontname,',
'       b.fontspacing,',
'       b.fontsize,',
'       b.fontstyle,',
'       b.fontweight,',
'       InitCap(b.fillpattern),',
'       InitCap(b.backcolor),',
'       InitCap(b.foregroundcolor),',
'       b.VisualAttribute_comment,',
'       sys.dbms_lob.substr(b.VisualAttribute_comment, 100,1)||decode( sign(10-length(b.VisualAttribute_comment)), -1, '' ...'', null) comment_snippet,',
'       b.FrameTitleBackColor,',
'       b.FrameTitleFillPattern,',
'       b.FrameTitleFontName,',
'       b.FrameTitleFontSize,',
'       b.FrameTitleFontSpacing,',
'       b.FrameTitleFontStyle,',
'       b.FrameTitleFontWeight,',
'       b.FrameTitleForegroundColor,',
'       b.ParentFilename,',
'       b.ParentFilepath,',
'       b.PersistentClientInfoLength,',
'       b.PromptBackColor,',
'       b.PromptFillPattern,',
'       b.PromptFontName,',
'       b.PromptFontSize,',
'       b.PromptFontSpacing,',
'       b.PromptFontStyle,',
'       b.PromptFontWeight,',
'       b.PromptForegroundColor,',
'       decode(b.SmartClass,''true'',t.y,''false'',t.n) smartclass,',
'       decode(b.SubclassObjectGroup,''true'',t.y,''false'',t.n) SubclassObjectGroup,',
'       b.VisualAttributeType,',
'       decode(b.applicable,''Y'',t.y,''N'',t.n) applicable,',
'       decode(b.complete,''Y'',t.y,''N'',t.n) complete,',
'       b.priority,',
'       b.assignee,',
'       b.notes,',
'       substr(b.notes,1,30)||decode( sign(10-length(b.notes )), -1, '' ...'', null) notes_snippet,',
'       b.tags',
'',
'from   wwv_mig_forms p, wwv_mig_frm_modules m, wwv_mig_frm_formmodules f, ',
'       wwv_mig_frm_rev_formmodules rf, wwv_mig_frm_visualattributes b,',
'       (select wwv_flow_lang.system_message(''APEXIR_YES'') y, wwv_flow_lang.system_message(''APEXIR_NO'') n from dual) t',
'',
'where  p.id = m.file_id',
'and    m.id = f.module_id',
'and    f.id = b.formmodule_id',
'and    f.id = rf.formmodule_id',
'and    p.id = :P17_FILE_ID',
'and    p.project_id = :MW_PROJ_ID',
'and    p.security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css">',
'table.apexir_WORKSHEET_DATA td{',
'white-space:nowrap;',
'}',
'</style>'))
,p_plug_footer=>'<br/>'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(310700815979880725.4407)
,p_name=>'Visual Attributes'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_display_row_count=>'Y'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'C'
,p_show_rows_per_page=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.::P87_ID:#ID#'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="&VIEW_DETAIL.">'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'ASHISH'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315053832185336012.4407)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'I'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701022805881037.4407)
,p_db_column_name=>'NAME'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701120889881040.4407)
,p_db_column_name=>'FONTNAME'
,p_display_order=>3
,p_column_identifier=>'B'
,p_column_label=>unistr('\5B57\578B\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701305497881040.4407)
,p_db_column_name=>'FONTSIZE'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\5B57\578B\5927\5C0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701232337881040.4407)
,p_db_column_name=>'FONTSPACING'
,p_display_order=>5
,p_column_identifier=>'C'
,p_column_label=>unistr('\5B57\578B\9593\8DDD')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701415885881041.4407)
,p_db_column_name=>'FONTWEIGHT'
,p_display_order=>6
,p_column_identifier=>'E'
,p_column_label=>unistr('\5B57\578B\7C97\7D30')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701613330881041.4407)
,p_db_column_name=>'INITCAP(B.BACKCOLOR)'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\80CC\666F\8272\5F69')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701702664881042.4407)
,p_db_column_name=>'INITCAP(B.FOREGROUNDCOLOR)'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\524D\666F\8272\5F69')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310701519442881041.4407)
,p_db_column_name=>'INITCAP(B.FILLPATTERN)'
,p_display_order=>9
,p_column_identifier=>'F'
,p_column_label=>unistr('\586B\6EFF\5716\6A23')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315054202308336014.4407)
,p_db_column_name=>'PRIORITY'
,p_display_order=>13
,p_column_identifier=>'M'
,p_column_label=>unistr('\512A\5148\9806\5E8F')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315054304419336014.4407)
,p_db_column_name=>'ASSIGNEE'
,p_display_order=>14
,p_column_identifier=>'N'
,p_column_label=>unistr('\6307\5B9A\5C0D\8C61')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315054404935336014.4407)
,p_db_column_name=>'NOTES'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>unistr('\9644\8A3B')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315054500003336015.4407)
,p_db_column_name=>'TAGS'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>unistr('\6A19\8A18')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315674130429451643.4407)
,p_db_column_name=>'APPLICABLE'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>unistr('\9069\7528')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315674217045451643.4407)
,p_db_column_name=>'COMPLETE'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('\5B8C\6210')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(321124725125002129.4407)
,p_db_column_name=>'NOTES_SNIPPET'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('\9644\8A3B\7A0B\5F0F\78BC\7247\6BB5')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187789526461015136.4407)
,p_db_column_name=>'FONTSTYLE'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('\5B57\578B\6A23\5F0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187789615158015137.4407)
,p_db_column_name=>'VISUALATTRIBUTE_COMMENT'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\8A3B\89E3')
,p_column_type=>'CLOB'
,p_heading_alignment=>'LEFT'
,p_rpt_show_filter_lov=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187789713220015137.4407)
,p_db_column_name=>'FRAMETITLEBACKCOLOR'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\80CC\666F\8272\5F69')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187789810766015137.4407)
,p_db_column_name=>'FRAMETITLEFILLPATTERN'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\586B\6EFF\6A23\5F0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187789924622015138.4407)
,p_db_column_name=>'FRAMETITLEFONTNAME'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\5B57\578B\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790001358015138.4407)
,p_db_column_name=>'FRAMETITLEFONTSIZE'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\5B57\578B\5927\5C0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790102931015138.4407)
,p_db_column_name=>'FRAMETITLEFONTSPACING'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\5B57\578B\9593\8DDD')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790208428015138.4407)
,p_db_column_name=>'FRAMETITLEFONTSTYLE'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\5B57\578B\6A23\5F0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790321027015139.4407)
,p_db_column_name=>'FRAMETITLEFONTWEIGHT'
,p_display_order=>28
,p_column_identifier=>'AB'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\5B57\578B\7C97\7D30')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790421993015139.4407)
,p_db_column_name=>'FRAMETITLEFOREGROUNDCOLOR'
,p_display_order=>29
,p_column_identifier=>'AC'
,p_column_label=>unistr('\5716\6587\6846\6A19\984C\524D\666F\8272\5F69')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790519191015141.4407)
,p_db_column_name=>'PARENTFILENAME'
,p_display_order=>30
,p_column_identifier=>'AD'
,p_column_label=>unistr('\7236\9805\6A94\6848\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790612265015141.4407)
,p_db_column_name=>'PARENTFILEPATH'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\7236\9805\6A94\6848\8DEF\5F91')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790719351015142.4407)
,p_db_column_name=>'PERSISTENTCLIENTINFOLENGTH'
,p_display_order=>32
,p_column_identifier=>'AF'
,p_column_label=>unistr('\6C38\4E45\7684\5F9E\5C6C\7AEF\9577\5EA6')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790808748015142.4407)
,p_db_column_name=>'PROMPTBACKCOLOR'
,p_display_order=>33
,p_column_identifier=>'AG'
,p_column_label=>unistr('\63D0\793A\80CC\666F\8272\5F69')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187790920718015142.4407)
,p_db_column_name=>'PROMPTFILLPATTERN'
,p_display_order=>34
,p_column_identifier=>'AH'
,p_column_label=>unistr('\63D0\793A\586B\6EFF\5716\6848')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791018440015142.4407)
,p_db_column_name=>'PROMPTFONTNAME'
,p_display_order=>35
,p_column_identifier=>'AI'
,p_column_label=>unistr('\63D0\793A\5B57\578B\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791131361015142.4407)
,p_db_column_name=>'PROMPTFONTSIZE'
,p_display_order=>36
,p_column_identifier=>'AJ'
,p_column_label=>unistr('\63D0\793A\5B57\578B\5927\5C0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791207034015143.4407)
,p_db_column_name=>'PROMPTFONTSPACING'
,p_display_order=>37
,p_column_identifier=>'AK'
,p_column_label=>unistr('\63D0\793A\5B57\578B\9593\8DDD')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791313221015145.4407)
,p_db_column_name=>'PROMPTFONTSTYLE'
,p_display_order=>38
,p_column_identifier=>'AL'
,p_column_label=>unistr('\63D0\793A\5B57\578B\6A23\5F0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791400115015145.4407)
,p_db_column_name=>'PROMPTFONTWEIGHT'
,p_display_order=>39
,p_column_identifier=>'AM'
,p_column_label=>unistr('\63D0\793A\5B57\578B\7C97\7D30')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791513995015145.4407)
,p_db_column_name=>'PROMPTFOREGROUNDCOLOR'
,p_display_order=>40
,p_column_identifier=>'AN'
,p_column_label=>unistr('\63D0\793A\524D\666F\8272\5F69')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791605594015145.4407)
,p_db_column_name=>'SMARTCLASS'
,p_display_order=>41
,p_column_identifier=>'AO'
,p_column_label=>unistr('\667A\6167\985E\5225')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791723893015146.4407)
,p_db_column_name=>'SUBCLASSOBJECTGROUP'
,p_display_order=>42
,p_column_identifier=>'AP'
,p_column_label=>unistr('\5B50\985E\5225\7269\4EF6\7FA4\7D44')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(187791832137015146.4407)
,p_db_column_name=>'VISUALATTRIBUTETYPE'
,p_display_order=>43
,p_column_identifier=>'AQ'
,p_column_label=>unistr('\8996\89BA\5C6C\6027\985E\578B')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(269307729951725602.4407)
,p_db_column_name=>'COMMENT_SNIPPET'
,p_display_order=>44
,p_column_identifier=>'AR'
,p_column_label=>unistr('\8A3B\89E3\7A0B\5F0F\78BC\7247\6BB5')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(313185523976028280.4407)
,p_plug_name=>unistr('\8996\89BA\5C6C\6027')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(186397626021353594.4407)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\6B64\9801\9762\53EF\4F9B\60A8\6AA2\8996\5F9E Oracle Forms \61C9\7528\7A0B\5F0F\64F7\53D6\4E4B\8996\89BA\5C6C\6027\7684\76F8\95DC\8CC7\8A0A.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(273183013799611405.4407)
,p_branch_action=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>11
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(273182124862611393.4407)
,p_name=>'P17_FILE_ID'
,p_item_sequence=>10
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
end;
/
prompt --application/pages/page_00018
begin
wwv_flow_api.create_page(
 p_id=>18.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\8F09\5165\547D\4EE4\6A94')
,p_alias=>'LOADSCRIPT'
,p_step_title=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_footer_text=>'<div id="AjaxLoading" style="display:none;"><img src="#IMAGE_PREFIX#processing3.gif" id="wait" /></div>'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(5872827478268282)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>	#AjaxLoading{padding:5px;font-size:18px;width:200px;text-align:center;left:50%;top:5%;position:absolute;border:2px solid #666;background-color:#FFF;}',
'</style>',
'<script language="JavaScript" type="text/javascript">',
'function doSubmit(r){',
'		html_ShowElement(''AjaxLoading'');',
'	window.setTimeout(''html_GetElement("wait").src = html_GetElement("wait").src'', 100);',
'	flowSelectAll();',
'	document.wwv_flow.p_request.value = r;',
'	document.wwv_flow.submit();',
'} // End doSubmit()',
'</script>',
''))
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/appmgr_start.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27599720425595483.4407)
,p_plug_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(186396719923353584.4407)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    wwv_mig_frm_load_xml.display_load_confirm (',
'       p_project_id          => :MW_PROJ_ID,',
'       p_date_time_format    => ''&DATE_TIME_FORMAT.'');  ',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_column_width=>'valign="top"'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(139367206221018805.4407)
,p_plug_name=>'Project Progress Bar'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>90
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(139359500914809151.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717613155760527519.4407)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(186501211388390803.4407)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>100
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752114931102695878.4407)
,p_plug_name=>unistr('\5EFA\7ACB\79FB\8F49\5C08\6848')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(29974228020245841.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(186501211388390803.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2063416744723079.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(186501211388390803.4407)
,p_button_name=>'NEXT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615475481194132964.4407)
,p_button_image_alt=>unistr('\4E0A\50B3\5176\4ED6\6A94\6848')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:106:&SESSION.:MULTIPLE:&DEBUG.:106:P106_PROJECT_ID:&MW_PROJ_ID.'
,p_button_condition=>'MW_MIG_TYPE'
,p_button_condition2=>'forms'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27368704904296961.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(186501211388390803.4407)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(259874213290130837.4407)
,p_branch_name=>'Go To Page 51'
,p_branch_action=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.::MW_PROJ_NAME:&P3_MIGRATION_NAME.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
,p_branch_sequence=>20
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(29168925935188290.4407)
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_branch_point=>'BEFORE_COMPUTATION'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(29974228020245841.4407)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27398716352531699.4407)
,p_name=>'P18_FILE_ID'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(139367206221018805.4407)
,p_prompt=>'File Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27402126226572414.4407)
,p_name=>'P18_SCRIPT_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(139367206221018805.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27438219299338383.4407)
,p_name=>'P18_PROJECT_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(139367206221018805.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Project Id'
,p_source=>'MW_PROJ_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27622828408099260.4407)
,p_name=>'P18_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(139367206221018805.4407)
,p_prompt=>'ID'
,p_source=>'MW_PROJ_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(27381212000991083.4407)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check Privileges'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_sw_api.check_priv (',
'    p_schema => :P3_SCHEMA',
'    );'))
,p_process_error_message=>unistr('\6AA2\67E5\6B0A\9650\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3998117240951026.4407)
,p_process_sequence=>75
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Update XML Column'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_clob        clob;',
'  l_charset     varchar2(100);',
'begin',
'    --',
'  FOR c1 in (SELECT id, file_content blob_content, file_char_set, file_name',
'             FROM   wwv_mig_forms',
'             WHERE  project_id = :MW_PROJ_ID',
'             AND    security_group_id = :flow_security_group_id',
'  ) LOOP',
'      --',
'      -- If no character set was specified at file upload time,',
'      -- default to the DAD character set',
'      --',
'      if c1.file_char_set is null then',
'          l_charset := nvl(sys.owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''), ''utf-8'');',
'      else',
'          l_charset := c1.file_char_set;',
'      end if;',
'      --',
'      l_clob := wwv_flow_utilities.blob_to_clob(',
'                  p_blob    => c1.blob_content,',
'                  p_charset => l_charset);',
'',
'      begin',
'          update wwv_mig_forms',
'             set xml_content = XMLTYPE(l_clob)',
'           where id = c1.id;',
'      exception when others then',
'          wwv_flow_error.raise_internal_error (',
'              p_error_code => wwv_flow_lang.system_message(''F4400.XML_PROCESSING_ERROR'', wwv_flow_escape.html(c1.file_name) ));',
'      end;',
'',
'      -- exit;',
'      --',
'  end loop;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
,p_process_success_message=>unistr('\66F4\65B0 XML \8CC7\6599\6B04')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(6757312227913592.4407)
,p_process_sequence=>85
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Parse & Load XML into Forms (fmb) & Reports (rpt) & Menus (mmb) & Object Library (olb) Tables'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'  FOR c1 in (SELECT id, file_name',
'             FROM   wwv_mig_forms',
'             WHERE  project_id = :MW_PROJ_ID',
'             AND    security_group_id = :flow_security_group_id',
'  ) LOOP',
'',
'      if (wwv_mig_frm_load_xml.is_valid_forms_xml(',
'                          p_file_id => c1.id,',
'                          p_project_id => :MW_PROJ_ID,',
'                          p_security_group_id => :flow_security_group_id)) then',
'',
'          wwv_mig_frm_load_xml.load_all_nodes(',
'                            p_file_id => c1.id);',
'      ',
'      else',
'          delete wwv_mig_forms where id = c1.id;',
'          delete wwv_mig_projects where id = :MW_PROJ_ID;',
'          commit;',
'          apex_application.g_unrecoverable_error := true;',
'          wwv_flow_error.raise_internal_error ( p_error_code => wwv_flow_lang.system_message(''F4400.XML_PARSING_ERROR'', wwv_flow_escape.html(c1.file_name)) );',
'      end if;',
'      ',
'  END LOOP;',
'',
'  FOR c2 in (SELECT id, file_name',
'             FROM   wwv_mig_rpts',
'             WHERE  project_id = :MW_PROJ_ID',
'             AND    security_group_id = :flow_security_group_id',
'  ) LOOP',
'',
'      if (wwv_mig_rpt_load_xml.is_valid_report_xml(',
'                          p_file_id => c2.id,',
'                          p_project_id => :MW_PROJ_ID,',
'                          p_security_group_id => :flow_security_group_id)) then',
'',
'      ',
'          wwv_mig_rpt_load_xml.load_all_nodes (',
'                            p_file_id => c2.id);',
'',
'      else',
'          delete wwv_mig_rpts where id = c2.id;',
'          delete wwv_mig_projects where id = :MW_PROJ_ID;',
'          commit;',
'          apex_application.g_unrecoverable_error := true;',
'          wwv_flow_error.raise_internal_error ( p_error_code => wwv_flow_lang.system_message(''F4400.XML_PARSING_ERROR'', wwv_flow_escape.html(c2.file_name)) );',
'      end if;',
'  END LOOP;',
'',
'',
'  FOR c3 in (SELECT id, file_name',
'             FROM   wwv_mig_frm_menus',
'             WHERE  project_id = :MW_PROJ_ID',
'             AND    security_group_id = :flow_security_group_id',
'  ) LOOP',
'      if (wwv_mig_frmmenu_load_xml.is_valid_menu_xml(',
'                                p_file_id => c3.id,',
'                                p_project_id => :MW_PROJ_ID,',
'                                p_security_group_id => :flow_security_group_id)) then ',
'          ',
'          wwv_mig_frmmenu_load_xml.load_all_nodes (',
'                            p_file_id => c3.id);',
'      else',
'          delete wwv_mig_frm_menus where id = c3.id;',
'          delete wwv_mig_projects where id = :MW_PROJ_ID;',
'          commit;',
'          apex_application.g_unrecoverable_error := true;',
'          wwv_flow_error.raise_internal_error ( p_error_code => wwv_flow_lang.system_message(''F4400.XML_PARSING_ERROR'', wwv_flow_escape.html(c3.file_name)) );',
'      end if;',
'  END LOOP;',
'',
'  FOR c4 in (SELECT id, file_name',
'             FROM   wwv_mig_olb',
'             WHERE  project_id = :MW_PROJ_ID',
'             AND    security_group_id = :flow_security_group_id',
'  ) LOOP',
'      if (wwv_mig_frm_olb_load_xml.is_valid_olb_xml(',
'                                p_file_id => c4.id,',
'                                p_project_id => :MW_PROJ_ID,',
'                                p_security_group_id => :flow_security_group_id)) then ',
'          ',
'          wwv_mig_frm_olb_load_xml.load_all_nodes (',
'                            p_file_id => c4.id);',
'      else',
'          delete wwv_mig_frm_menus where id = c4.id;',
'          delete wwv_mig_projects where id = :MW_PROJ_ID;',
'          commit;',
'',
'          apex_application.g_unrecoverable_error := true;',
'          wwv_flow_error.raise_internal_error ( p_error_code => wwv_flow_lang.system_message(''F4400.XML_PARSING_ERROR'', wwv_flow_escape.html(c4.file_name)) ); ',
'      end if;',
'  END LOOP;',
'',
'  :MW_SCHEMA := :P3_SCHEMA;',
'END;'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\5C08\6848.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(14427106883395495.4407)
,p_process_sequence=>86
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Load Revision Tables'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'  FOR c1 in (SELECT id',
'               FROM wwv_mig_forms',
'              WHERE project_id        = :MW_PROJ_ID',
'                AND security_group_id = :FLOW_SECURITY_GROUP_ID',
'  ) LOOP',
'      wwv_mig_frm_utilities.load_frm_revision_tables (',
'        p_file_id => c1.id);',
'  END LOOP;',
'',
'END;'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(331103124281483603.4407)
,p_process_sequence=>90
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Set Component Applicability'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_mig_frm_utilities.set_component_defaults(p_project_id => :MW_PROJ_ID,',
'                                             p_security_group_id => :flow_security_group_id);'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
,p_process_comment=>'To be moved to wwv_mig_frm_load.plb when XML parsing work is complete.'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(331183118532967298.4407)
,p_process_sequence=>100
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Set Trigger Applicability'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_mig_frm_utilities.set_trigger_defaults(p_project_id => :MW_PROJ_ID,',
'                                           p_security_group_id => :flow_security_group_id);',
'',
'-- Set Form-Level Triggers across Migration Project',
'wwv_mig_frm_utilities.set_formtrig_applicability(',
'                       p_project_id => :MW_PROJ_ID,',
'                       p_security_group_id => :flow_security_group_id);',
'-- Set Block-Level Triggers across Migration Project',
'wwv_mig_frm_utilities.set_blktrig_applicability(',
'                       p_project_id => :MW_PROJ_ID,',
'                       p_security_group_id => :flow_security_group_id);',
'-- Set Item-Level Triggers across Migration Project',
'wwv_mig_frm_utilities.set_itemtrig_applicability(',
'                       p_project_id => :MW_PROJ_ID,',
'                       p_security_group_id => :flow_security_group_id);'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(72937719491257872.4407)
,p_process_sequence=>110
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Set Block Query'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_block_id            number;',
'    l_status              varchar2(4)     := null;',
'    l_block_name          varchar2(255);',
'    l_block_source        varchar(32676);',
'    l_enhanced_query      varchar2(32676);',
'    l_original_query      varchar2(32676);',
'begin',
'',
'    for c1 in ( select b.id block_id,',
'                       b.name block_name,',
'                       querydatasourcename block_source',
'                from   wwv_mig_forms p, ',
'                       wwv_mig_frm_modules m, ',
'                       wwv_mig_frm_formmodules f, ',
'                       wwv_mig_frm_blocks b ',
'                where  p.id = m.file_id',
'                and    m.id = f.module_id',
'                and    f.id = b.formmodule_id',
'                and    p.project_id = :MW_PROJ_ID',
'    ) LOOP',
'        l_block_id       := c1.block_id;',
'        l_block_name     := c1.block_name;',
'        l_block_source   := c1.block_source;',
'        l_status         := null;',
'        l_original_query := ''select ''||chr(10);',
'',
'        if (wwv_mig_frm_utilities.get_block_mapping(',
'                      p_project_id => :MW_PROJ_ID,',
'                      p_security_group_id => :flow_security_group_id,',
'                      p_block_id => c1.block_id,',
'                      p_schema => :MW_SCHEMA)  not in (''MASTERDETAIL'',''BLANK'')) then',
'',
'            if l_block_source is not null then ',
'                for c2 in ( select i.id, ',
'                                   nvl(i.columnname,i.name) column_name,',
'                                   i.id block_item_id,',
'                                   i.databaseitem',
'                            from   wwv_mig_forms p, ',
'                                   wwv_mig_frm_modules m, ',
'                                   wwv_mig_frm_formmodules f, ',
'                                   wwv_mig_frm_blocks b, ',
'                                   wwv_mig_frm_blk_items i',
'                            where  p.id = m.file_id',
'                            and    m.id = f.module_id',
'                            and    f.id = b.formmodule_id',
'                            and    b.id = i.block_id',
'                            and    ((upper(i.databaseitem) = ''TRUE'' and i.itemtype <> ''Push Button'') or ',
'                (i.databaseitem is null and (i.itemtype is null or i.itemtype <> ''Push Button'')))',
'                            and    p.project_id = :MW_PROJ_ID',
'                            and    b.id = l_block_id',
'                ) LOOP',
'                    l_original_query := l_original_query || l_status ||''    "''||trim(l_block_name)||''"."''|| trim(c2.column_name) || ''"''; ',
'                    l_status := '',''||chr(10);',
'                END LOOP;',
'          -- code to check the Table name existing in in the schema, else use the upper case of that',
'           if wwv_flow_builder.is_valid_table_or_view(:MW_SCHEMA, trim(l_block_source)) = ''U'' then ',
'                      l_block_source := upper(l_block_source);',
'           end if;',
'           l_original_query := l_original_query || chr(10) || '' from "'' || trim(l_block_source) ||''" "''|| trim(l_block_name) || ''"'';',
'',
'                l_enhanced_query := wwv_mig_frm_utilities.trigger_parse_block_sql(:MW_PROJ_ID, l_block_id, :MW_SCHEMA);',
'           ',
'                UPDATE wwv_mig_frm_blocks ',
'                SET    original_query = l_original_query, ',
'                       enhanced_query = l_enhanced_query, ',
'                       use_query = decode(l_enhanced_query,null,''ORIGINAL'',''ENHANCED''),',
'                       complete = decode(l_enhanced_query,null,''N'',''Y''),',
'                       notes = decode(l_enhanced_query,null,null,wwv_flow_lang.system_message(''F4400_ENHANCED_QRY_NOTE''))',
'                WHERE  id = l_block_id;',
'',
'',
'                -- Set COMPLETE to ''Y'' for block & associated items using Enhanced Query',
'                if (l_enhanced_query is not null) then',
'                    -- Fix for bug 7630444 - Only update POST-QUERY trigger',
'                    --UPDATE wwv_mig_frm_blk_triggers',
'                    --SET    complete = ''Y''',
'                    --WHERE  block_id = l_block_id;',
'',
'                    UPDATE wwv_mig_frm_blk_triggers',
'                    SET    notes = wwv_flow_lang.system_message(''F4400_ENHANCED_QRY_TRIG_NOTE''),',
'                           complete = ''Y''',
'                    WHERE  block_id = l_block_id',
'                    AND    name = ''POST-QUERY'';',
'                    --AND    complete = ''Y'';',
'',
'                    FOR c3 IN (select i.id item_id',
'                               from   wwv_mig_forms p, wwv_mig_frm_modules m, ',
'                                      wwv_mig_frm_formmodules f, wwv_mig_frm_rev_formmodules rf, ',
'                                      wwv_mig_frm_blocks b, wwv_mig_frm_rev_blocks rb, ',
'                                      wwv_mig_frm_blk_items i, wwv_mig_frm_rev_blk_items ri',
'                               where  p.id = m.file_id',
'                               and    m.id = f.module_id',
'                               and    f.id = b.formmodule_id',
'                               and    f.id = rf.formmodule_id',
'                               and    b.id = rb.block_id',
'                               and    b.id = i.block_id',
'                               and    b.id = l_block_id',
'                               and    i.id = ri.item_id',
'                    ) LOOP',
'        ',
'                        UPDATE wwv_mig_frm_blk_items',
'                        SET    complete = ''Y''',
'                        WHERE  id = c3.item_id;',
'            ',
'                        -- Fix for bug 76030444 - do not update Item-level Triggers',
'                        --UPDATE wwv_mig_frm_blk_item_triggers',
'                        --SET    complete = ''Y''',
'                        --WHERE  item_id = c3.item_id;',
'        ',
'                   END LOOP;',
'                END IF;',
'',
'                commit;',
'            END IF;',
'',
'        -- Bug fix 8264049',
'        elsif (wwv_mig_frm_utilities.get_block_mapping(',
'                      p_project_id => :MW_PROJ_ID,',
'                      p_security_group_id => :flow_security_group_id,',
'                      p_block_id => c1.block_id,',
'                      p_schema => :MW_SCHEMA) = ''BLANK'' AND c1.block_source is not null) then',
'',
'            UPDATE wwv_mig_frm_blocks ',
'                SET    notes = wwv_flow_lang.system_message(''F4400_UNKNOWN_DBSRC_NOTE'')',
'                WHERE  id = l_block_id;',
'',
'        END IF;    ',
'',
'    END LOOP;',
'END;'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(106592605139500826.4407)
,p_process_sequence=>120
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Convert POST-QUERY to LOV'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'       l_block_id       number;',
'begin',
'',
'  for c1 in ( ',
'       select b.id block_id',
'       from   wwv_mig_forms p, ',
'              wwv_mig_frm_modules m, ',
'              wwv_mig_frm_formmodules f, ',
'              wwv_mig_frm_blocks b ',
'       where  p.id = m.file_id',
'       and    m.id = f.module_id',
'       and    f.id = b.formmodule_id',
'       and    p.project_id = :MW_PROJ_ID',
'      )',
'  loop',
'',
'    l_block_id     := c1.block_id;',
'    wwv_mig_frm_utilities.trigger_query_to_lov(:MW_PROJ_ID,l_block_id);',
'    commit;',
'  end loop;',
'end ;'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(111087104127190429.4407)
,p_process_sequence=>130
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'FORMS:Exclude Blocks Without Database Source'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'  FOR c1 in (SELECT id',
'               FROM wwv_mig_forms',
'              WHERE project_id        = :MW_PROJ_ID',
'                AND security_group_id = :FLOW_SECURITY_GROUP_ID',
'  ) LOOP',
'      wwv_mig_frm_utilities.set_block_inclusion (',
'        p_file_id => c1.id,',
'        p_project_id => :MW_PROJ_ID,',
'        p_security_group_id => :flow_security_group_id);',
'  END LOOP;',
'',
'END;'))
,p_process_when_button_id=>wwv_flow_api.id(27368704904296961.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(28910517081996474.4407)
,p_process_sequence=>20
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'clean up projects & files tables'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'delete from wwv_flow_file_objects$',
'where id = :P18_FILE_ID;',
'',
'delete from wwv_mig_projects',
'where ID = :MW_PROJ_ID;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(29974228020245841.4407)
);
end;
/
prompt --application/pages/page_00019
begin
wwv_flow_api.create_page(
 p_id=>19.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\6A94\6848\4E0B\8F09\9023\7D50\9801\9762 4400:112 \6240\9700\7684\5831\8868\8A73\7D30\8CC7\8A0A')
,p_step_title=>unistr('\5831\8868\8A73\7D30\8CC7\8A0A')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280692031983283006)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(704462054179768505.4407)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_comment=>'Page is required for use of download link on pg 4400:112 - do not delete.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(239396826523553343.4407)
,p_plug_name=>'Report Details needed for File Download Link'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(239397104332553346.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_button_name=>'SAVE'
,p_button_static_id=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_CHANGE'
,p_button_condition=>'P19_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(239397424547553348.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_button_name=>'CANCEL'
,p_button_static_id=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(239397004964553346.4407)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_button_name=>'CREATE'
,p_button_static_id=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P19_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(239397232552553346.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_button_name=>'DELETE'
,p_button_static_id=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\522A\9664')
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'javascript:confirmDelete(htmldb_delete_message,''DELETE'');'
,p_button_condition=>'P19_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(239398007373553351.4407)
,p_branch_action=>'f?p=&APP_ID.:19:&SESSION.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(239398227422553354.4407)
,p_name=>'P19_ID'
,p_item_sequence=>1
,p_item_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(239398420629553366.4407)
,p_name=>'P19_FILE_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6A94\6848\540D\7A31')
,p_source=>'FILE_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(239398632444553367.4407)
,p_name=>'P19_FILE_MIME_TYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6A94\6848 Mime \985E\578B')
,p_source=>'FILE_MIME_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(239398800645553367.4407)
,p_name=>'P19_FILE_CONTENT'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6A94\6848\5167\5BB9')
,p_source=>'FILE_CONTENT'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'DB_COLUMN'
,p_attribute_02=>'FILE_MIME_TYPE'
,p_attribute_03=>'FILE_NAME'
,p_attribute_04=>'FILE_CHAR_SET'
,p_attribute_05=>'FILE_UPDATED_ON'
,p_attribute_06=>'Y'
,p_attribute_08=>'attachment'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(239399017561553367.4407)
,p_name=>'P19_FILE_CHAR_SET'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(239396826523553343.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6A94\6848\5B57\5143\96C6')
,p_source=>'FILE_CHAR_SET'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(239399332606553370.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_MIG_RPTS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_MIG_RPTS'
,p_attribute_03=>'P19_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>unistr('\7121\6CD5\64F7\53D6\8CC7\6599\5217.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(239399519451553370.4407)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_MIG_RPTS'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_MIG_RPTS'
,p_attribute_03=>'P19_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'I:U:D'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>unistr('\7121\6CD5\8655\7406\8868\683C WWV_MIG_RPTS \7684\8CC7\6599\5217.')
,p_process_success_message=>unistr('\52D5\4F5C\5DF2\8655\7406.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(239399727988553371.4407)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'19'
,p_process_when_button_id=>wwv_flow_api.id(239397232552553346.4407)
);
end;
/
prompt --application/pages/page_00029
begin
wwv_flow_api.create_page(
 p_id=>29.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(206300026914921040.4407)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>80
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(239864519008497337.4407)
,p_name=>unistr('\7121\6548\7684\7269\4EF6')
,p_template=>wwv_flow_api.id(717584444915505758.4407)
,p_display_sequence=>50
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 objects_c001,c002 objects_c002',
'  from apex_collections ',
' where collection_name = ''MISSING_OBJECTS'' ',
' and (c003 = ''TABLE'' or c003 = ''COLUMN'')',
' order by c001'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from apex_collections ',
' where collection_name = ''MISSING_OBJECTS'' ',
' and (c003 = ''TABLE'' or c003 = ''COLUMN'' ) and rownum <= 1'))
,p_display_condition_type=>'EXISTS'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(16025715508464036.4407)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\7121\6548\7684\7269\4EF6.')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(269630128581676988.4407)
,p_query_column_id=>1
,p_column_alias=>'OBJECTS_C001'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\7269\4EF6\540D\7A31')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(269630229938676988.4407)
,p_query_column_id=>2
,p_column_alias=>'OBJECTS_C002'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\8CC7\6599\6B04\540D\7A31')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(247871227528958530.4407)
,p_name=>unistr('\7121\6548\7684\5831\8868\67E5\8A62')
,p_template=>wwv_flow_api.id(717584444915505758.4407)
,p_display_sequence=>60
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 report_c001, clob001 report_c002',
'  from  apex_collections ',
'  where collection_name = ''INVALID_QUERIES'' ',
'  and   (c003 = ''QUERY'' )',
'  order by c001'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from apex_collections ',
' where collection_name = ''INVALID_QUERIES'' ',
' and rownum <= 1'))
,p_display_condition_type=>'EXISTS'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(16025715508464036.4407)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\7121\6548\7684\7269\4EF6.')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(269631014298691701.4407)
,p_query_column_id=>1
,p_column_alias=>'REPORT_C001'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\6A94\6848\540D\7A31')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(269631130788691702.4407)
,p_query_column_id=>2
,p_column_alias=>'REPORT_C002'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\67E5\8A62')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(252804824792427729.4407)
,p_name=>unistr('\7121\6548\7684\5340\584A\67E5\8A62')
,p_template=>wwv_flow_api.id(717584444915505758.4407)
,p_display_sequence=>70
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001,c004,c002',
'  from apex_collections ',
' where collection_name = ''MISSING_OBJECTS'' ',
' and (c003 = ''QUERY'')',
' order by c001'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from apex_collections ',
' where collection_name = ''MISSING_OBJECTS'' ',
' and (c003 = ''QUERY'' ) and rownum <= 1'))
,p_display_condition_type=>'EXISTS'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(16025715508464036.4407)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\7121\6548\7684\7269\4EF6.')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(252805014580427739.4407)
,p_query_column_id=>1
,p_column_alias=>'C001'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\7269\4EF6\540D\7A31')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(252954018090492004.4407)
,p_query_column_id=>2
,p_column_alias=>'C004'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\6A94\6848\540D\7A31')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(252805103972427739.4407)
,p_query_column_id=>3
,p_column_alias=>'C002'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\5340\584A')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(278588114138456057.4407)
,p_plug_name=>'&nbsp;'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'&nbsp;'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(278588321794456058.4407)
,p_plug_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_column_width=>'valign=top'
,p_plug_header=>unistr('\8F38\5165\61C9\7528\7A0B\5F0F\540D\7A31. \7136\5F8C, \9078\53D6\61C9\7528\7A0B\5F0F\5EFA\7ACB\65B9\6CD5\8207\7DB1\8981. <p />')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752115519352695879.4407)
,p_plug_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(278589228220456078.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(206300026914921040.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(278589411891456080.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(206300026914921040.4407)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615475481194132964.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\9801')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(279021622948132764.4407)
,p_branch_action=>'f?p=&APP_ID.:71:&SESSION.:CC:&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(278589411891456080.4407)
,p_branch_sequence=>12
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'',
'  l_page_no number;',
'',
'begin',
'',
'  if :P29_CREATE_METHOD = ''MODEL'' then',
'',
'    select count(1) into l_page_no ',
'    from wwv_flow_model_pages',
'    where model_id = :MW_MODEL_ID;',
'',
'    if l_page_no>0 then',
'      return false;',
'    else',
'      return true;',
'    end if;',
'',
'  end if;',
'',
'end;'))
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(278594901766456108.4407)
,p_branch_action=>'f?p=&APP_ID.:62:&SESSION.:CC:&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(278589411891456080.4407)
,p_branch_sequence=>15
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(278595324235456111.4407)
,p_branch_action=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>40
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(162822711592134516.4407)
,p_name=>'P29_DELETE_FILE'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(209180019208227909.4407)
,p_name=>'P29_UI_TYPE_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_item_default=>'1'
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cHeight=>1
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\9078\53D6\61C9\7528\7A0B\5F0F\7684\4F7F\7528\8005\4ECB\9762. \5C0D\65BC\4E3B\8981\91DD\5C0D\684C\9762\4F7F\7528\800C\8A2D\8A08\7684\61C9\7528\7A0B\5F0F, \8ACB\9078\64C7\300C\684C\9762\300D, \5C0D\65BC\5176\4ED6\4ECB\9762 (\5982\667A\6167\578B\624B\6A5F\6216\5E73\677F\96FB\8166), \8ACB\9078\64C7\76F8\5C0D\61C9\7684\4F7F\7528\8005\4ECB\9762.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(278589807509456081.4407)
,p_name=>'P29_SCHEMA'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>':MW_SCHEMA'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('\7DB1\8981:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P29_CREATE_METHOD'
,p_display_when2=>'PROJECT'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'N'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\60A8\7684\61C9\7528\7A0B\5F0F\6703\5C07 SQL \5256\6790\6210\7279\5B9A\8CC7\6599\5EAB\7DB1\8981, \4F86\53D6\5F97\5176\6B0A\9650. \8ACB\6307\5B9A\8CC7\6599\5EAB\7DB1\8981\64C1\6709\8005.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(278590301104456086.4407)
,p_name=>'P29_APPLICATION_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_item_default=>'&MW_PROJ_NAME.'
,p_prompt=>unistr('\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589391884513848.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\4F9B\958B\767C\4EBA\54E1\8B58\5225\61C9\7528\7A0B\5F0F\7684\540D\7A31. \9810\8A2D\503C\53D6\81EA\300C\79FB\8F49\5C08\6848\300D\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(278590830675456086.4407)
,p_name=>'P29_APPLICATION_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F:')
,p_source=>'MW_APPLICATION_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>12
,p_cMaxlength=>120
,p_cHeight=>1
,p_cattributes_element=>'class="fielddatabold"'
,p_read_only_when=>'P29_IN_PROGRESS'
,p_read_only_when2=>'N'
,p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_read_only_disp_attr=>'class="fielddatabold"'
,p_field_template=>wwv_flow_api.id(717589391884513848.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\8B58\5225\61C9\7528\7A0B\5F0F\7684\6574\6578\503C.  \61C9\7528\7A0B\5F0F ID \5728\8CC7\6599\5EAB\4E2D\5FC5\9808\662F\552F\4E00\7684.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(278591321748456087.4407)
,p_name=>'P29_MODEL_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(278591506024456087.4407)
,p_name=>'P29_CREATE_METHOD'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'PROJECT'
,p_prompt=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CREATE_APP_OPTIONS'
,p_lov=>'.'||wwv_flow_api.id(278595623975456113.4407)||'.'
,p_display_when=>'P29_IN_PROGRESS'
,p_display_when2=>'Y'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9078\64C7\5EFA\7ACB\6A21\5F0F:'),
'<ul>',
unistr('<li>\9078\53D6<b>\4EE5\79FB\8F49\5C08\6848\70BA\57FA\790E</b>: \6839\64DA\60A8\7684\300C\79FB\8F49\5C08\6848\300D\9078\64C7\9805\76EE\5EFA\7ACB\9801\9762\53CA\624B\52D5\8F38\5165\5176\4ED6\9801\9762.</li>'),
unistr('<li>\9078\53D6<b>\4EE5\73FE\6709\7684\61C9\7528\7A0B\5F0F\8A2D\8A08\6A21\578B\70BA\57FA\790E</b>: \91CD\8907\4F7F\7528\73FE\6709\7684\61C9\7528\7A0B\5F0F\5B9A\7FA9.<br />'),
unistr('\4F7F\7528\73FE\6709\61C9\7528\7A0B\5F0F\5B9A\7FA9\6642, \60A8\7121\9808\91CD\65B0\8F38\5165\61C9\7528\7A0B\5F0F\7279\6027\503C\5373\53EF\57F7\884C\6B64\7CBE\9748.</li>'),
'</ul>'))
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(278592032395456087.4407)
,p_name=>'P29_IN_PROGRESS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>4
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(279019820776075452.4407)
,p_name=>'P29_NEXT'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(278588321794456058.4407)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(278592325496456092.4407)
,p_computation_sequence=>10
,p_computation_item=>'P29_IN_PROGRESS'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'''Y'''
,p_compute_when=>'CC'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(290467619833436499.4407)
,p_computation_sequence=>10
,p_computation_item=>'MW_SCHEMA'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select DATABASE_SCHEMA ',
'  from wwv_mig_projects ',
'  where id = :MW_PROJ_ID and security_group_id = :flow_security_group_id'))
,p_compute_when=>'MW_PROJ_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1829537178161817884.4407)
,p_computation_sequence=>10
,p_computation_item=>'P29_UI_TYPE_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(278592500691456097.4407)
,p_validation_name=>'P29_APPLICATION_ID'
,p_validation_sequence=>0
,p_validation=>'P29_APPLICATION_ID'
,p_validation_type=>'ITEM_IS_NUMERIC'
,p_error_message=>unistr('\503C\5FC5\9808\662F\6578\503C')
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(278590830675456086.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(278592708551456100.4407)
,p_validation_name=>'P29_APPLICATION_ID Not Null'
,p_validation_sequence=>1
,p_validation=>'P29_APPLICATION_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\8981\6709\61C9\7528\7A0B\5F0F ID')
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(278590830675456086.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'generated 23-FEB-2005 00:51'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(278592900995456100.4407)
,p_validation_name=>'P29_APPLICATION_NAME Not Null'
,p_validation_sequence=>2
,p_validation=>'P29_APPLICATION_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\8F38\5165\540D\7A31')
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(278590301104456086.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'generated 23-FEB-2005 00:49'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(278593126512456100.4407)
,p_validation_name=>'Application ID available'
,p_validation_sequence=>12
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_models ',
' where flow_id = :P29_APPLICATION_ID ',
'   and model_complete = ''Y''',
'   and flow_id in (select id from wwv_flows)',
'union all',
'select 1 from wwv_flows ',
' where id = :P29_APPLICATION_ID'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('\300C\61C9\7528\7A0B\5F0F ID\300D\5DF2\7D93\5B58\5728, \6216\662F\4FDD\7559\7D66\5176\4ED6\61C9\7528\7A0B\5F0F\6A21\578B.')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'   if wwv_flow_utilities.is_numeric(:P29_APPLICATION_ID) then',
'     for c in (',
'        select 1 from wwv_flow_models',
'        where id = :P29_MODEL_ID',
'        and flow_id is null',
'     ) loop',
'       return true;',
'     end loop;',
'     return false;',
'  else',
'     return false;',
'  end if;',
'end;'))
,p_validation_condition_type=>'FUNCTION_BODY'
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(278590830675456086.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(278593321657456100.4407)
,p_validation_name=>'P29_APPLICATION_ID'
,p_validation_sequence=>22
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_utilities.is_available_application_id(',
'    p_security_group_id => :flow_security_group_id,',
'    p_application_id    => :P29_APPLICATION_ID,',
'    p_check_reserved    => FALSE ) = FALSE then',
'    --',
'    return FALSE;',
'else',
'    return TRUE;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\4FDD\7559\7684\300C\61C9\7528\7A0B\5F0F ID\300D.')
,p_validation_condition=>'wwv_flow_utilities.is_numeric(:P29_APPLICATION_ID)'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(278590830675456086.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(278593521673456100.4407)
,p_validation_name=>'P29_APPLICATION_NAME unique'
,p_validation_sequence=>32
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_models m, wwv_flows f',
'where m.name = :P29_APPLICATION_NAME',
'and m.flow_id = f.id',
'and m.security_group_id = :flow_security_group_id',
'and f.security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31\5FC5\9808\662F\552F\4E00\7684, \540D\7A31\70BA &P29_APPLICATION_NAME. \7684\61C9\7528\7A0B\5F0F\6A21\578B\5DF2\7D93\5B58\5728.')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_models',
'where id = :P29_MODEL_ID',
'and flow_id is null'))
,p_validation_condition_type=>'EXISTS'
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(278590301104456086.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(247289717153463818.4407)
,p_validation_name=>'project does not have any datasource associated'
,p_validation_sequence=>49
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_boolean       boolean := false;',
'begin',
'    for c1 in (select 1',
'                 from wwv_mig_forms f',
'                      , wwv_mig_frm_modules m',
'                      , wwv_mig_frm_formmodules fml',
'                      , wwv_mig_frm_rev_formmodules rfml',
'                      , wwv_mig_frm_blocks b',
'                      , wwv_mig_frm_rev_blocks rb',
'',
'                where f.select_for_app    = ''Y''',
'                  and m.file_id           = f.id',
'                  and fml.module_id       = m.id',
'                  and rfml.formmodule_id  = fml.id',
'                  and f.project_id        = :MW_PROJ_ID',
'                  and f.security_group_id = :FLOW_SECURITY_GROUP_ID',
'                  and rfml.select_for_app = ''Y''',
'                  and b.formmodule_id     = fml.id',
'                  and rb.block_id         = b.id',
'                  and rb.select_for_app   = ''Y''',
'                  and rb.querydatasourcename is not null',
'                  and (rb.querydatasourcetype <> ''None'' ',
'                      or rb.querydatasourcetype is null) ',
'                  and rownum <= 1)',
'    loop',
'        l_boolean := true;',
'    end loop;',
'    return l_boolean;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5C08\6848 &MW_PROJ_NAME. \672A\5305\542B\4EFB\4F55\8207\8CC7\6599\5EAB\7269\4EF6\76F8\95DC\7684\300C\5340\584A\300D.')
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(.4407)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(310769309382235563.4407)
,p_validation_name=>'P29_SCHEMA does not have associated tables or views'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_mig_frm_utilities.is_valid_datasource(',
'           p_project_id => :MW_PROJ_ID,',
'           p_schema     => :P29_SCHEMA);'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8CC7\6599\5EAB\7DB1\8981 &P29_SCHEMA. \672A\5305\542B\5C08\6848 &MW_PROJ_NAME. \7684\76F8\95DC\8CC7\6599\5EAB\7269\4EF6. \8ACB\78BA\5B9A\5C08\6848\7684\76F8\95DC\8CC7\6599\5EAB\7DB1\8981\5305\542B\8207\4E0A\50B3\4E4B Forms \6A21\7D44 .XML \6A94\6848\76F8\95DC\7684\8CC7\6599\5EAB\7269\4EF6. '),
'',
''))
,p_associated_item=>wwv_flow_api.id(278589807509456081.4407)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(247845429279760400.4407)
,p_validation_name=>'Valid Query'
,p_validation_sequence=>60
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_query  varchar2(32767);',
'    l_status boolean          := true;',
'    l_clob   clob             := empty_clob;',
'begin',
'    apex_collection.create_or_truncate_collection ( p_collection_name => ''INVALID_QUERIES'') ;',
'',
'    for c1 in ( select replace(replace(replace(e.cdata,''&amp;#10;'', '' ''), ',
'                                                       ''&apos;'', chr(39)),chr(10),'' '') sql_query, ',
'                       a.file_name filename',
'                from   wwv_mig_rpts a, wwv_mig_report b,',
'                       wwv_mig_rpt_data c, wwv_mig_rpt_datasrc d, wwv_mig_rpt_datasrc_select e',
'                where  a.project_id = :MW_PROJ_ID',
'                and    a.security_group_id = :flow_security_group_id',
'                and    a.id = b.file_id',
'                and    b.id = c.report_id',
'                and    c.id = d.data_id',
'                and    d.id = e.datasrc_id',
'                and    a.select_for_app = ''Y'') ',
'    loop',
'        if c1.sql_query is not null then',
'            l_query := wwv_flow_utilities.clob_to_varchar2(c1.sql_query);',
'',
'            if (wwv_mig_frm_utilities.is_valid_query(p_query  => l_query,',
'                                                     p_schema => :P29_SCHEMA) = false ) then ',
'                l_status := false;',
'',
'                sys.dbms_lob.createtemporary( l_clob, FALSE, sys.dbms_lob.session );',
'                sys.dbms_lob.open(l_clob,sys.dbms_lob.lob_readwrite);',
'                sys.dbms_lob.writeappend(l_clob,length(l_query),l_query);',
'                sys.dbms_lob.close( l_clob );',
'',
'                apex_collection.add_member(',
'                    p_collection_name => ''INVALID_QUERIES'',',
'                    p_c001            => c1.filename,',
'                    p_clob001         => l_clob,',
'                    p_c003            => ''QUERY'') ;',
'            end if;',
'        end if;',
'    end loop;',
'',
'    return l_status;',
'',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5728 &MW_PROJ_NAME. \627E\5230\7121\6548\7684\67E5\8A62. \8ACB\78BA\5B9A\8207\4E0A\50B3\7684 Reports \6A21\7D44 .XML \6A94\76F8\95DC\7684\67E5\8A62\6709\6548.')
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(.4407)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(478594321359730668.4407)
,p_validation_name=>'Restricted schema, may not create application.'
,p_validation_sequence=>70
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_provisioning.restricted_schema(',
'       p_schema            => :P29_SCHEMA, ',
'       p_security_group_id => wwv_flow_security.g_security_group_id) then',
'   return false;',
'else',
'   return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\9650\5236\7684\7DB1\8981, \4E0D\80FD\5EFA\7ACB\61C9\7528\7A0B\5F0F.')
,p_when_button_pressed=>wwv_flow_api.id(278589411891456080.4407)
,p_associated_item=>wwv_flow_api.id(.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(278593829217456102.4407)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create WWV_FLOW_MODELS row'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'',
'  l_id number;',
'  l_flow_id number;',
'  ',
'begin',
'',
'    l_id := wwv_flow_id.next_val;',
'    ',
'    -- Set Application ID',
'    :MW_APPLICATION_ID := wwv_flow_utilities.minimum_free_flow;',
'    ',
'    -- Create application model',
'    insert into WWV_FLOW_MODELS (id, ',
'                                 name, ',
'                                 model_complete, ',
'                                 created_by, ',
'                                 created_on,  ',
'                                 session_id, ',
'                                 flow_id, ',
'                                 owner',
'                                 ) ',
'                          values (l_id, ',
'                                  :P29_APPLICATION_NAME, ',
'                                  ''N'', ',
'                                  :app_user,',
'                                  sysdate,',
'                                  :app_session,',
'                                  :MW_APPLICATION_ID,',
'                                  :APP_USER',
'                                 );',
'   -- Set Model ID',
'   :MW_MODEL_ID  := l_id;  ',
'   :P29_MODEL_ID := l_id;',
'',
'end;'))
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
begin
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(278594025700456104.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set model name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'update WWV_FLOW_MODELS ',
'   set name    = :P29_APPLICATION_NAME,',
'       flow_id = :P29_APPLICATION_ID,',
'       owner   = :P29_SCHEMA',
' where id      = :MW_MODEL_ID;',
'',
':MW_SCHEMA := :P29_SCHEMA;',
'',
'end;'))
,p_process_error_message=>unistr('\66F4\65B0\6A21\578B\540D\7A31\6642\767C\751F\932F\8AA4.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(278589411891456080.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(310802406573332106.4407)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete File If Requested'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'delete from WWV_MIG_FORMS ',
'where id = :P29_DELETE_FILE;'))
,p_process_error_message=>unistr('\672A\522A\9664\6A94\6848.')
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
,p_process_success_message=>unistr('\5DF2\9806\5229\522A\9664\6A94\6848.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(247904911308057972.4407)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Clear Invalid Objects Collections'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_collection.create_or_truncate_collection',
'                    ( p_collection_name => ''MISSING_OBJECTS'') ;',
'',
'apex_collection.create_or_truncate_collection',
'                    ( p_collection_name => ''INVALID_QUERIES'') ;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(278594405783456105.4407)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear cache'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'31'
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(278594613727456105.4407)
,p_process_sequence=>50
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Workspace Defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   defaults_found boolean := false;',
'begin',
'for c1 in (',
'   select DEFAULT_AUTHENTICATION_SCHEME,',
'          DEFAULT_APPLICATION_THEME,',
'          DEFAULT_TABS,',
'          DEFAULT_LANGUAGE,',
'          DEFAULT_LANGUAGE_DERIVED',
'   from   WWV_FLOW_APP_BUILD_PREF',
'   where  security_group_id = :flow_security_group_id',
'   )',
'   loop',
'   	:P39_CREATE_TABS := nvl(c1.DEFAULT_TABS,''SINGLE_LEVEL_TABS'');',
'   	:P39_AUTHENTICATION := nvl(c1.DEFAULT_AUTHENTICATION_SCHEME,:PRODUCT_NAME);',
'   	:P39_LANGUAGE := nvl(c1.DEFAULT_LANGUAGE,v(''BROWSER_LANGUAGE''));',
'   	wwv_flow.update_cache_with_write(',
'   	 ''P39_DEFAULT_LANGUAGE_DERIVED'', c1.DEFAULT_LANGUAGE_DERIVED);',
'   	--:P50_THEME  := nvl(c1.DEFAULT_APPLICATION_THEME,''21'');',
'    --    :THEME_ID  := nvl(c1.DEFAULT_APPLICATION_THEME,''21'');',
'   	defaults_found := true;',
'   end loop;',
'if not defaults_found then',
'   :P39_CREATE_TABS := ''SINGLE_LEVEL_TABS'';',
'   :P39_AUTHENTICATION := :PRODUCT_NAME;',
'   :P39_LANGUAGE := ''en'';',
'   --:P50_THEME  := ''21'';',
'   --:THEME_ID  := ''21'';',
'end if;',
'end;'))
);
end;
/
prompt --application/pages/page_00031
begin
wwv_flow_api.create_page(
 p_id=>31.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3883824817792350.4407)
,p_plug_name=>'New Application Information'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>11
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3884017314792351.4407)
,p_plug_name=>'Create Application Tasks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>31
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(243690011375751560.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717613155760527519.4407)
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(12572910630259725.4407)
,p_name=>'Selected Application Objects'
,p_display_sequence=>71
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_report_attributes=>'style="width:100%;"'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select	 (level-1)*15 indent,',
'         ID,',
'         PAGE_ID,',
'         substr(page_name,1,24) page_name,',
'	 page_type,',
'         page_mode,',
'         page_source,',
'         sys.dbms_lob.substr(replace(source,chr(10),''''),24,1) source,',
'	 PARENT_PAGE_ID,',
'         substr(page_name,1,24) page_name_edit,',
'         id delete_page_icon',
' from	 WWV_FLOW_MODEL_PAGES,',
'         (select wwv_flow_lang.system_message(''DELETE'') msg_delete from dual) m',
'where model_id = :P31_MODEL_ID',
'start with parent_page_id is null and model_id = :P31_MODEL_ID',
'connect by prior id = parent_page_id and model_id = :P31_MODEL_ID',
'order siblings by display_sequence, id'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(615807510873782585.4407)
,p_query_num_rows=>50000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>unistr('\60A8\5C1A\672A\9078\53D6\61C9\7528\7A0B\5F0F\4E2D\6240\8981\542B\62EC\7684\5831\8868\6216\8868\55AE.')
,p_query_row_count_max=>50000
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(12572910630259725.4407)
,p_plug_column_width=>'nowrap="nowrap"'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573117189259796.4407)
,p_query_column_id=>1
,p_column_alias=>'INDENT'
,p_column_display_sequence=>2
,p_column_heading=>'Indent'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573221624259796.4407)
,p_query_column_id=>2
,p_column_alias=>'ID'
,p_column_display_sequence=>3
,p_column_heading=>'Id'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573319068259796.4407)
,p_query_column_id=>3
,p_column_alias=>'PAGE_ID'
,p_column_display_sequence=>4
,p_column_heading=>'ID'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573406516259797.4407)
,p_query_column_id=>4
,p_column_alias=>'PAGE_NAME'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\540D\7A31')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573530380259797.4407)
,p_query_column_id=>5
,p_column_alias=>'PAGE_TYPE'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\985E\578B')
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(6575418257362951)
,p_lov_show_nulls=>'NO'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(615809982814795378.4407)
,p_query_column_id=>6
,p_column_alias=>'PAGE_MODE'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\9801\9762\6A21\5F0F')
,p_use_as_row_header=>'N'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(615826477066801787)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573625133259797.4407)
,p_query_column_id=>7
,p_column_alias=>'PAGE_SOURCE'
,p_column_display_sequence=>8
,p_column_heading=>unistr('\4F86\6E90')
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(6596415880390663)
,p_lov_show_nulls=>'NO'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573715373259797.4407)
,p_query_column_id=>8
,p_column_alias=>'SOURCE'
,p_column_display_sequence=>9
,p_column_heading=>unistr('\4F86\6E90')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(12573807869259798.4407)
,p_query_column_id=>9
,p_column_alias=>'PARENT_PAGE_ID'
,p_column_display_sequence=>10
,p_column_heading=>'Parent Page Id'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(615862766136814522.4407)
,p_query_column_id=>10
,p_column_alias=>'PAGE_NAME_EDIT'
,p_column_display_sequence=>1
,p_column_heading=>unistr('<span class="u-VisuallyHidden">\7DE8\8F2F</span>')
,p_column_link=>'f?p=&APP_ID.:47:&SESSION.::&DEBUG.:47:P47_ID:#ID#'
,p_column_linktext=>unistr('<span class="a-Icon icon-edit-page"></span><span class="u-VisuallyHidden">\7DE8\8F2F #PAGE_NAME#</span>')
,p_column_link_attr=>'class="a-Button a-Button--small a-Button--noLabel a-Button--withIcon a-Button--noUI"'
,p_column_alignment=>'CENTER'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(615905484311021219.4407)
,p_query_column_id=>11
,p_column_alias=>'DELETE_PAGE_ICON'
,p_column_display_sequence=>11
,p_column_heading=>unistr('<span class="u-VisuallyHidden">\522A\9664</span>')
,p_column_link=>'f?p=&APP_ID.:31:&SESSION.:DELETE:&DEBUG.::P31_DELETE_PAGE:#ID#'
,p_column_linktext=>'<span class="a-Icon icon-remove"></span><span class="u-VisuallyHidden">BUTTON_TEXT</span>'
,p_column_link_attr=>'class="a-Button a-Button--small a-Button--noLabel a-Button--withIcon a-Button--noUI"'
,p_column_alignment=>'CENTER'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22037912165559028.4407)
,p_plug_name=>unistr('\65B0\589E\9801\9762')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>81
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('\6309\4E00\4E0B<b>\65B0\589E\9801\9762</b>, \5728\61C9\7528\7A0B\5F0F\4E2D\5EFA\7ACB\4E00\500B\7A7A\767D\7684\9801\9762. \7A7A\767D\9801\9762\6C92\6709\5167\5EFA\7684\529F\80FD. \6309<b>\4E0B\4E00\6B65</b>, \4FDD\7559\76EE\524D\7684\9078\9805\4E26\9032\5165\7CBE\9748\7684\4E0B\4E00\6B65.')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(209368806980188860.4407)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>101
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752115653587695880.4407)
,p_plug_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(12578825615320868.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(209368806980188860.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:33,35::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(20540327988584425.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(209368806980188860.4407)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.:::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'',
'  l_reports  number := 0;',
'  l_forms    number := 0;',
'  l_any      number := 0;',
'  l_defs     number := 0;',
'  l_dbid     number := 0;',
'',
'BEGIN ',
'',
'  for c5 in',
'  (',
'    select dbid from wwv_mig_access',
'    where project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and linkdbid is null     ',
'  )',
'  loop',
'    if :P2_DBID <> 0 then',
'      if c5.dbid = :P2_DBID then',
'        l_dbid := :P2_DBID;',
'      end if;',
'    else',
'      l_dbid := c5.dbid;',
'    end if;',
'  end loop;',
'   ',
'  ',
'    for c4 in ',
'    (',
'      select count(*) cnt from wwv_flow_app_build_pref',
'      where created_by = :APP_USER',
'      and security_group_id = :flow_security_group_id',
'    )',
'    loop',
'      l_defs := c4.cnt;',
'    end loop;',
'',
'  -- Retrieve forms & reports page items for parent/non-linked MDB file  ',
'  if l_dbid <> 0 then',
'',
'    for c1 in',
'    (   select distinct count(status) cnt ',
'        from wwv_mig_rev_reports',
'        where project_id = :MW_PROJ_ID',
'        and dbid = l_dbid',
'        and status = ''INCLUDE''',
'    )',
'    LOOP',
'      l_reports := l_reports + c1.cnt;',
'    END LOOP;',
'',
'    for c2 in',
'    (   select distinct count(status) cntforms ',
'        from wwv_mig_rev_forms',
'        where project_id = :MW_PROJ_ID',
'        and dbid = l_dbid',
'        and status = ''INCLUDE''',
'    )',
'    LOOP',
'      l_forms := l_forms + c2.cntforms;',
'    END LOOP;',
'',
'   end if;',
'',
'    for c3 in (',
'       select count(*) cnt',
'        from WWV_FLOW_MODEL_PAGES',
'        where model_id = :P31_MODEL_ID',
'    )',
'    LOOP',
'      l_any := c3.cnt;',
'    END LOOP;',
'',
'   ',
'   if (l_reports = 0) AND (l_forms = 0) AND (l_any = 0) then',
'     return false;',
'   else   ',
'     if l_defs > 0 then',
'       return true;',
'     else',
'       return false;',
'     end if;',
'   end if;',
'',
'END;'))
,p_button_condition_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(12579631502322581.4407)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(209368806980188860.4407)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615475481194132964.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\9801')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'',
'  l_reports number := 0;',
'  l_forms   number := 0;',
'  l_any     number := 0;',
'  l_dbid    number := 0;',
'',
'BEGIN ',
'',
'   for c4 in',
'   (',
'     select dbid from wwv_mig_access',
'     where project_id = :MW_PROJ_ID',
'     and security_group_id = :flow_security_group_id',
'     and linkdbid is null',
'   )',
'   loop',
'     if :P2_DBID <> 0 then',
'       if c4.dbid = :P2_DBID then',
'         l_dbid := :P2_DBID;',
'       end if;',
'     else',
'       l_dbid := c4.dbid;',
'     end if;',
'   end loop;',
'',
'   if l_dbid <> 0 then',
'     for c1 in',
'     (   select distinct count(status) cnt ',
'         from wwv_mig_rev_reports',
'         where project_id = :MW_PROJ_ID',
'         and dbid = l_dbid',
'         and status = ''INCLUDE''',
'     )',
'     LOOP',
'       l_reports := l_reports + c1.cnt;',
'     END LOOP;',
'',
'     for c2 in',
'     (   select distinct count(status) cntforms ',
'         from wwv_mig_rev_forms',
'         where project_id = :MW_PROJ_ID',
'         and dbid = l_dbid',
'         and status = ''INCLUDE''',
'     )',
'     LOOP',
'       l_forms := l_forms + c2.cntforms;',
'     END LOOP;',
'   end if;',
'',
'   for c3 in (',
'              select count(*) cnt',
'              from WWV_FLOW_MODEL_PAGES',
'              where model_id = :P31_MODEL_ID',
'   )',
'   LOOP',
'     l_any := c3.cnt;',
'   END LOOP;',
' ',
'',
'  if (l_reports = 0) AND (l_forms = 0) AND (l_any = 0) then',
'     return false;',
'  else   ',
'     return true;',
'  end if; ',
'',
'END;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(22040503404774195.4407)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_button_name=>'ADD_PAGE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\65B0\589E\9801\9762')
,p_button_position=>'TEMPLATE_DEFAULT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(21469504158959585.4407)
,p_branch_action=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.::P50_PREVIOUS,P50_NEXT,GEN_APP_CRUMB:31,39,&P31_CRUMB.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(12579631502322581.4407)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(22159232287285565.4407)
,p_branch_action=>'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(22040503404774195.4407)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3885913396792388.4407)
,p_name=>'P31_MODEL_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3883824817792350.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3886109081792402.4407)
,p_name=>'P31_SCHEMA'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3883824817792350.4407)
,p_prompt=>'Schema:'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3886311653792402.4407)
,p_name=>'P31_APPLICATION_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3883824817792350.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3886525613792403.4407)
,p_name=>'P31_APPLICATION_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(3883824817792350.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3886704813792403.4407)
,p_name=>'P31_DELETE_PAGE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(3883824817792350.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13310119884306229.4407)
,p_name=>'P31_SUBORDINATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(12572910630259725.4407)
,p_source=>'Home Page (1)'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(21638217268103406.4407)
,p_name=>'P31_CRUMB'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(3884017314792351.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_lang.system_message(''F4400_BREADCRUMB'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22044826025039209.4407)
,p_name=>'P31_OWNER'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_item_default=>'&P2_SCHEMA.'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cHeight=>1
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\8CC7\6599\5EAB\7DB1\8981\64C1\6709\8005.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22050204703193837.4407)
,p_name=>'P31_PAGE_TYPE_RADIOGRP'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_item_default=>'BLANK'
,p_prompt=>unistr('\9801\9762\985E\578B:')
,p_source=>'BLANK'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'PAGE TYPE'
,p_lov=>'.'||wwv_flow_api.id(22078515151918053.4407)||'.'
,p_tag_attributes=>'onChange="setAction(this.value);"'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<b>\7A7A\767D</b/></ br>'),
'<ul>',
unistr('\5EFA\7ACB\4E00\500B\6C92\6709\5167\5EFA\529F\80FD\7684\9801\9762.'),
'<br><br>',
unistr('\60A8\53EF\4EE5\5229\7528\7A7A\767D\9801\9762\4F86\5354\52A9\700F\89BD\60A8\7684\61C9\7528\7A0B\5F0F.  \4F8B\5982, \60A8\53EF\4EE5\5F9E\4E00\500B\9801\9762\5B58\53D6\60A8\6240\6709\7684\300C\8868\55AE\300D, \5F9E\53E6\4E00\500B\9801\9762\5B58\53D6\6240\6709\300C\5831\8868\300D.  \5728\6B64\60C5\6CC1\4E0B, \60A8\53EF\4EE5\5EFA\7ACB\4E00\500B\300C\7A7A\767D\9801\9762\300D, \7136\5F8C\4F7F\7528\300C\9801\9762\5B9A\7FA9\300D\4F86\7DE8\8F2F\9801\9762, \5373\53EF\63A7\5236\700F\89BD\7522\751F\7684\61C9\7528\7A0B\5F0F. '),
'',
unistr('<p><b>\6CE8\610F:</b> \60A8\4E5F\53EF\4EE5\85C9\7531\5EFA\7ACB\65B0\9801\9762\7684\65B9\5F0F\4F86\5EFA\7ACB\5831\8868\548C\8868\55AE. \60A8\53EF\4EE5\5F9E\300C\9801\9762\5B9A\7FA9\300D, \6216\8005\6309\57F7\884C\4E2D\61C9\7528\7A0B\5F0F\5167\4E4B\300C\958B\767C\4EBA\54E1\5DE5\5177\5217\300D\4E0A\7684<b>\5EFA\7ACB</b>\6309\9215, \5728\300C\61C9\7528\7A0B\5F0F\300D\9996\9801\4E2D\5EFA\7ACB\65B0\7684\9801\9762.</p>'),
''))
,p_attribute_01=>'6'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22053624452275303.4407)
,p_name=>'P31_PAGE_TYPE_DESC_SELECTLIST'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\52D5\4F5C:')
,p_post_element_text=>'<div id="actionText" class="fielddatabold" style="width:400px;">'
,p_source=>'P31_PAGE_TYPE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CREATE APPLICATION PAGE TYPE'
,p_lov=>'.'||wwv_flow_api.id(22139623686037120.4407)||'.'
,p_cHeight=>1
,p_tag_attributes=>'readonly="readonly"'
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\6307\5B9A\76EE\524D\9078\53D6\7684\9801\9762\985E\578B.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22055027138294971.4407)
,p_name=>'P31_SUBORDINATE_OPTION'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_prompt=>unistr('\5F9E\5C6C\65BC\9801\9762')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(page_name)||'' (''||page_id||'')'' p, id r',
'from WWV_FLOW_MODEL_PAGES ',
'where model_id = :P31_MODEL_ID',
'order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \6700\4E0A\5C64\9801\9762 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_display_when=>'select 1 from wwv_flow_model_pages where model_id = :P31_MODEL_ID'
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\5728\65B0\589E\9801\9762\81F3\60A8\7684\61C9\7528\7A0B\5F0F\6642, \53EF\4EE5\540C\6642\65B0\589E\5F9E\5C6C\9801\9762. \5982\679C\67D0\500B\9801\9762\662F\53E6\4E00\500B\9801\9762\7684\5F9E\5C6C\9801\9762, \7CBE\9748\5C07\6703\8981\6C42\60A8\63D0\4F9B\9023\7D50\7236\9805\9801\9762\7684\65B9\6CD5.<br /><br />'),
unistr('\5411\4E0B\5C55\958B\5831\8868\9801\9762\5305\542B\9023\81F3\53E6\4E00\500B\63D0\4F9B\66F4\8A73\7D30\8CC7\8A0A\4E4B\9801\9762\7684\9023\7D50, \5373\662F\5F9E\5C6C\9801\9762\7684\4E00\500B\7BC4\4F8B.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22147414953129170.4407)
,p_name=>'P31_PAGE_SOURCE'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('\6307\5B9A\65B0\9801\9762\7684\4F86\6E90. \5831\8868\53EF\4EE5\8868\683C\548C\67E5\8A62\4F5C\70BA\5176\57FA\790E. \8868\55AE\548C\5217\8868\5316\8868\55AE\5247\53EA\80FD\4EE5\8868\683C\4F5C\70BA\5176\57FA\790E.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22150200455153388.4407)
,p_name=>'P31_NAME'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\540D\7A31')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select max(page_id) + 1 max_page',
'   from   wwv_flow_model_pages',
'   where  model_id = :P31_MODEL_ID',
') loop',
'   return wwv_flow_lang.system_message(''MODEL_PAGE'',nvl(c1.max_page,1));',
'end loop;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\6B64\9801\9762\5728\60A8\61C9\7528\7A0B\5F0F\5167\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22185201063522544.4407)
,p_name=>'P31_PAGE_TYPE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<b>\7A7A\767D</b/></ br>'),
'<ul>',
unistr('\5EFA\7ACB\4E00\500B\6C92\6709\5167\5EFA\529F\80FD\7684\9801\9762.'),
'<br><br>',
unistr('\60A8\53EF\4EE5\5229\7528\7A7A\767D\9801\9762\4F86\5354\52A9\700F\89BD\60A8\7684\61C9\7528\7A0B\5F0F.  \4F8B\5982, \60A8\53EF\4EE5\5F9E\4E00\500B\9801\9762\5B58\53D6\60A8\6240\6709\7684\300C\8868\55AE\300D, \5F9E\53E6\4E00\500B\9801\9762\5B58\53D6\6240\6709\300C\5831\8868\300D.  \5728\6B64\60C5\6CC1\4E0B, \60A8\53EF\4EE5\5EFA\7ACB\4E00\500B\300C\7A7A\767D\9801\9762\300D, \7136\5F8C\4F7F\7528\300C\9801\9762\5B9A\7FA9\300D\4F86\7DE8\8F2F\9801\9762, \5373\53EF\63A7\5236\700F\89BD\7522\751F\7684\61C9\7528\7A0B\5F0F. '),
'',
unistr('<p><b>\6CE8\610F:</b> \60A8\4E5F\53EF\4EE5\85C9\7531\5EFA\7ACB\65B0\9801\9762\7684\65B9\5F0F\4F86\5EFA\7ACB\5831\8868\548C\8868\55AE. \60A8\53EF\4EE5\5F9E\300C\9801\9762\5B9A\7FA9\300D, \6216\8005\6309\57F7\884C\4E2D\61C9\7528\7A0B\5F0F\5167\4E4B\300C\958B\767C\4EBA\54E1\5DE5\5177\5217\300D\4E0A\7684<b>\5EFA\7ACB</b>\6309\9215, \5728\300C\61C9\7528\7A0B\5F0F\300D\9996\9801\4E2D\5EFA\7ACB\65B0\7684\9801\9762.</p>'),
''))
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22235518350650597.4407)
,p_name=>'P31_PAGE_TYPE_DESC'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(22037912165559028.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'BLANK'
,p_prompt=>unistr('\52D5\4F5C:')
,p_source=>'P31_PAGE_TYPE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'CREATE APPLICATION PAGE TYPE'
,p_lov=>'.'||wwv_flow_api.id(22139623686037120.4407)||'.'
,p_cattributes_element=>'class="fielddatabold"'
,p_tag_attributes=>'readonly="readonly"'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8B58\5225\76EE\524D\9078\53D6\7684\9801\9762\985E\578B (\7A7A\767D\9801\9762). \60A8\53EF\4EE5\5229\7528\300C\7A7A\767D\9801\9762\300D\4F86\5354\52A9\700F\89BD\60A8\7684\61C9\7528\7A0B\5F0F. \4F8B\5982, \60A8\53EF\4EE5\5F9E\4E00\500B\9801\9762\5B58\53D6\60A8\6240\6709\7684\300C\8868\55AE\300D, \5F9E\53E6\4E00\500B\9801\9762\5B58\53D6\6240\6709\300C\5831\8868\300D. \5728\6B64\60C5\6CC1\4E0B, \60A8\53EF\4EE5\5EFA\7ACB\4E00\500B\300C\7A7A\767D\9801\9762\300D, \7136\5F8C\4F7F\7528\300C\9801\9762\5B9A\7FA9\300D\4F86\7DE8\8F2F\9801\9762, \5373\53EF\63A7\5236\6240\7522\751F\61C9\7528\7A0B\5F0F\7684\700F\89BD. ')
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(22152900464229023.4407)
,p_computation_sequence=>10
,p_computation_item=>'P31_NAME'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select max(page_id) + 1 max_page',
'   from   wwv_flow_model_pages',
'   where  model_id = :P31_MODEL_ID',
') loop',
'   return wwv_flow_lang.system_message(''MODEL_PAGE'',nvl(c1.max_page,1));',
'end loop;'))
,p_compute_when=>':P31_NAME IS NULL'
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(22153826437236582.4407)
,p_computation_sequence=>20
,p_computation_item=>'P31_SUBORDINATE_OPTION'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'null'
,p_compute_when=>'P31_SUBORDINATE_OPTION'
,p_compute_when_text=>'0'
,p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(3887010733792408.4407)
,p_computation_sequence=>70
,p_computation_item=>'P31_SCHEMA'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P2_SCHEMA'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(3887231310792412.4407)
,p_computation_sequence=>71
,p_computation_item=>'P31_APPLICATION_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select migration_name',
'from   wwv_mig_projects',
'where  id = :MW_PROJ_ID',
'and    security_group_id = :flow_security_group_id',
''))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(13203028028646290.4407)
,p_validation_name=>'Must create at least one page'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 r',
'from WWV_FLOW_MODEL_PAGES',
'where model_id = :P31_MODEL_ID'))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('\60A8\81F3\5C11\5FC5\9808\5B9A\7FA9\4E00\500B\9801\9762.')
,p_when_button_pressed=>wwv_flow_api.id(12579631502322581.4407)
,p_associated_item=>wwv_flow_api.id(.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(720833567750839767.4407)
,p_name=>'Edit Page - Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(12572910630259725.4407)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(720833885964839773.4407)
,p_event_id=>wwv_flow_api.id(720833567750839767.4407)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(22154709384250585.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add Page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  l_dbid  number := 0;',
'',
'begin',
'',
'for c3 in',
'(',
'  select dbid from wwv_mig_access',
'  where project_id = :MW_PROJ_ID',
'  and security_group_id = :flow_security_group_id',
'  and linkdbid is null',
')',
'loop',
'  if :P2_DBID <> 0 then',
'    l_dbid := :P2_DBID;',
'  else',
'    l_dbid := c3.dbid;',
'  end if;',
'end loop;',
'',
'wwv_flow_model_api.add_page (',
'   p_model_id        => :MW_MODEL_ID,         ',
'   p_page_name       => :P31_NAME, ',
'   p_page_type       => ''BLANK'', ',
'   p_page_source     => null, ',
'   p_parent_page_num => :P31_SUBORDINATE_OPTION,',
'   p_owner           => :MW_SCHEMA,',
'   p_table           => null, ',
'   p_query           => null, ',
'   p_spreadsheet_data=> null, ',
'   p_report_filter   => null, ',
'   p_form_and_report => null',
');',
'',
'for c2 in (',
'  select page_id ',
'  from WWV_FLOW_MODEL_PAGES',
'  where model_id = :MW_MODEL_ID ',
'  and page_name = :P31_NAME',
'  and security_group_id = :flow_security_group_id',
')',
'loop',
'',
'  insert into wwv_mig_rev_apexapp (',
'                                   project_id, ',
'                                   dbid,',
'                                   flow_id,',
'                                   page_id,',
'                                   list_template_name,',
'                                   owner)',
'                           values (',
'                                   :MW_PROJ_ID,',
'                                   l_dbid,',
'                                   :MW_APPLICATION_ID,',
'                                   c2.page_id,',
'                                   ''Vertical Unordered List with Bullets'',',
'                                   :MW_SCHEMA);',
'',
'end loop;',
'',
'end;'))
,p_process_error_message=>unistr('\7121\6CD5\65B0\589E\9801\9762\81F3\61C9\7528\7A0B\5F0F.')
,p_process_when_button_id=>wwv_flow_api.id(22040503404774195.4407)
,p_process_when=>'nvl(:REQUEST,''ADD_PAGE'') NOT IN (''NEXT'',''PREVIOUS'')'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
end;
/
begin
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(22157632156276074.4407)
,p_process_sequence=>15
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reset Session State'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P31_SUBORDINATE_OPTION := null;',
':P31_PAGE := null;',
':P31_NAME := null;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3887501576792424.4407)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear cache'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'39'
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(19755104056924680.4407)
,p_process_sequence=>15
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Retrieve Application Defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   defaults_found boolean := false;',
'begin',
'for c1 in (',
'   select DEFAULT_AUTHENTICATION_SCHEME,',
'          DEFAULT_APPLICATION_THEME,',
'          DEFAULT_TABS,',
'          DEFAULT_LANGUAGE,',
'          DEFAULT_LANGUAGE_DERIVED',
'   from   WWV_FLOW_APP_BUILD_PREF',
'   where  security_group_id = :flow_security_group_id',
'   )',
'   loop',
'   	:P39_CREATE_TABS := nvl(c1.DEFAULT_TABS,''SINGLE_LEVEL_TABS'');',
'   	:P39_AUTHENTICATION := nvl(c1.DEFAULT_AUTHENTICATION_SCHEME,:PRODUCT_NAME);',
'   	:P39_LANGUAGE := nvl(c1.DEFAULT_LANGUAGE,v(''BROWSER_LANGUAGE''));',
'   	wwv_flow.update_cache_with_write(',
'   	 ''P39_DEFAULT_LANGUAGE_DERIVED'', c1.DEFAULT_LANGUAGE_DERIVED);',
'   --	:P50_THEME  := nvl(c1.DEFAULT_APPLICATION_THEME,''21'');',
'   --     :THEME_ID  := nvl(c1.DEFAULT_APPLICATION_THEME,''21'');',
'   	defaults_found := true;',
'   end loop;',
'if not defaults_found then',
'   :P39_CREATE_TABS := ''SINGLE_LEVEL_TABS'';',
'   :P39_AUTHENTICATION := :PRODUCT_NAME;',
'   :P39_LANGUAGE := ''en'';',
'  -- :P50_THEME  := ''21'';',
'  -- :THEME_ID  := ''21'';',
'end if;',
'end;'))
,p_process_error_message=>unistr('\7121\6CD5\64F7\53D6\61C9\7528\7A0B\5F0F\9810\8A2D\503C.')
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3887704729792425.4407)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete page if requested'
,p_process_sql_clob=>'delete from WWV_FLOW_MODEL_PAGES where id = :P31_DELETE_PAGE;'
,p_process_error_message=>unistr('\7121\6CD5\522A\9664\9801\9762')
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3887927650792425.4407)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create WWV_FLOW_MODELS row'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'',
'  l_id number;',
'  l_owner varchar2(50);',
'  l_flow_id number;',
'  ',
'begin',
'',
'    -- Set Application OWNER  ',
'    for c1 in (select owner',
'               from wwv_mig_rev_tables',
'               where security_group_id = wwv_flow_security.g_security_group_id',
'               and project_id = :MW_PROJ_ID) ',
'    loop',
'        l_owner := c1.owner;',
'        exit;',
'    end loop;',
'',
'    l_id := wwv_flow_id.next_val;',
'    ',
'    -- Set Application Variables',
'    -- :P31_APPLICATION_ID := wwv_flow_utilities.minimum_free_flow;',
'    :MW_APPLICATION_ID  := wwv_flow_utilities.minimum_free_flow;',
'    :MW_APPLICATION_NAME := :P31_APPLICATION_NAME;',
'    ',
'    -- Create application model',
'    insert into WWV_FLOW_MODELS (id, ',
'                                 name, ',
'                                 model_complete, ',
'                                 created_by, ',
'                                 created_on,  ',
'                                 session_id, ',
'                                 flow_id, ',
'                                 owner',
'                                 ) ',
'                          values (l_id, ',
'                                  :MW_APPLICATION_NAME, ',
'                                  ''N'', ',
'                                  :app_user,',
'                                  sysdate,',
'                                  :app_session,',
'                                  :MW_APPLICATION_ID,',
'                                  :MW_SCHEMA',
'                                 );',
'   -- Set Model ID',
'  :P31_MODEL_ID := l_id;',
'  :MW_MODEL_ID := l_id;',
'',
'end;'))
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(11626704773016987.4407)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add Home Page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'',
' l_cnt_forms     number := 0;',
' l_dbid          number := 0;',
'',
'begin',
'',
'  for c5 in',
'  (',
'    select dbid from wwv_mig_access',
'    where project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and linkdbid is null',
'  )',
'  loop ',
'    if :P2_DBID <> 0 then',
'      if c5.dbid = :P2_DBID then',
'        l_dbid := :P2_DBID;',
'      end if;',
'    else',
'      l_dbid := c5.dbid;',
'    end if;',
'  end loop;',
'  ',
'  if l_dbid <> 0 then',
'',
'    for c1 in (select count(*) cnt',
'               from  wwv_mig_rev_forms',
'               where status = ''INCLUDE''',
'               and   project_id = :MW_PROJ_ID',
'               and   security_group_id= :flow_security_group_id',
'               and   dbid = l_dbid',
'    )',
'    loop',
'      l_cnt_forms := c1.cnt;',
'    end loop;',
'',
'    --',
'    -- Only create Home Page if forms have been selected for inclusion',
'    -- in the application',
'    --',
'',
'    if (l_cnt_forms <> 0) then ',
'      wwv_flow_model_api.add_page (',
'         p_model_id        => :P31_MODEL_ID,         ',
'         p_page_name       => ''Home Page'', ',
'         p_page_type       => ''BLANK'', ',
'         p_page_source     => null, ',
'         p_parent_page_num => NULL,',
'         p_owner           => :MW_SCHEMA,',
'         p_table           => null, ',
'         p_query           => null, ',
'         p_spreadsheet_data=> null, ',
'         p_report_filter   => null, ',
'         p_form_and_report => null',
'    );',
'',
'    -- Set default Home Page navigation to vertical list',
'    for c2 in (',
'               select page_id ',
'               from WWV_FLOW_MODEL_PAGES',
'               where model_id = :P31_MODEL_ID ',
'               -- and page_name = ''Home Page''',
'               and page_type = ''BLANK''',
'               and security_group_id = :flow_security_group_id',
'    )',
'    loop',
'',
'    insert into wwv_mig_rev_apexapp (',
'                                     project_id, ',
'                                     dbid,',
'                                     flow_id,',
'                                     page_id,',
'                                     list_template_name,',
'                                     list_item_icon,',
'                                     owner)',
'                             values (',
'                                     :MW_PROJ_ID,',
'                                     l_dbid,',
'                                     :MW_APPLICATION_ID,',
'                                     c2.page_id,',
'                                     ''Vertical Unordered List with Bullets'',',
'                                     ''migration/mig_menu1.png'',',
'                                     :MW_SCHEMA);',
'    end loop;',
'',
'  end if;',
'',
'end if;',
'',
'end;'))
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3954600570748164.4407)
,p_process_sequence=>50
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add pages for forms on forms'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  l_parent_page_id number := 0;',
'  l_dbid           number := 0;',
'BEGIN',
'',
'  --',
'  -- Set DBID',
'  --',
'  for c5 in',
'  (',
'    select dbid from wwv_mig_access',
'    where project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and linkdbid is null',
'  )',
'  loop ',
'    if :P2_DBID <> 0 then',
'      if c5.dbid = :P2_DBID then',
'        l_dbid := :P2_DBID;',
'      end if;',
'    else',
'      l_dbid := c5.dbid;',
'    end if;',
'  end loop;',
'',
'  -- Retrieve forms & reports page items for parent/non-linked MDB file  ',
'  if l_dbid <> 0 then',
'',
'',
'    --',
'    --  Set Home Page as parent page for all pages',
'    --',
'    for c2 in (',
'               select id',
'               from   WWV_FLOW_MODEL_PAGES ',
'               where  model_id = :MW_MODEL_ID ',
'               and    page_id = 1',
'               and    page_name = ''Home Page''',
'               and    security_group_id = :flow_security_group_id',
'    )',
'    loop ',
'      l_parent_page_id := c2.id;',
'    end loop;',
'',
'',
'    --',
'    -- Add new page',
'    --',
'    for c1 in (',
'               select form_name, source_name, owner, source_syntax, mig_type',
'               from   wwv_mig_rev_forms',
'               where  security_group_id = :flow_security_group_id',
'               and    status = ''INCLUDE''',
'               and    project_id = :MW_PROJ_ID',
'               and    dbid = l_dbid',
'    )',
'    loop',
' ',
'      if c1.source_name is null then',
'        -- Generate a Report based on a SQL Query for Access Form on SQL Query',
'        wwv_flow_model_api.add_page (',
'           p_model_id        => :MW_MODEL_ID,         ',
'           p_page_name       => c1.form_name, ',
'           p_page_type       => ''REPORT'', ',
'           p_page_source     => ''QUERY'', ',
'           p_parent_page_num => l_parent_page_id,  ',
'           p_owner           => c1.owner, ',
'           p_table           => null, ',
'           p_query           => c1.source_syntax, ',
'           p_spreadsheet_data=> null, ',
'           p_report_filter   => null, ',
'           p_form_and_report => null);',
'',
'      else',
'        -- Generate Form based on a table for Access Form on table/view',
'        wwv_flow_model_api.add_page (',
'           p_model_id        => :MW_MODEL_ID,         ',
'           p_page_name       => c1.form_name, ',
'           p_page_type       => c1.mig_type, ',
'           p_page_source     => ''TABLE'', ',
'           p_parent_page_num => l_parent_page_id,  ',
'           p_owner           => c1.owner, ',
'           p_table           => c1.source_name, ',
'           p_query           => null, ',
'           p_spreadsheet_data=> null, ',
'           p_report_filter   => null, ',
'           p_form_and_report => null);',
'',
'      end if;',
'',
'    end loop;',
'',
'',
'    --',
'    -- Update the Model Page Column information with MS Access label text',
'    --',
'    for c3 in (',
'               select    distinct a.ctrlcaption caption,',
'                         d.column_name colname,',
'                         d.model_region_id model_region_id,',
'                         f.model_page_id model_page_id,',
'                         e.formcaption formcaption',
'       ',
'               from   wwv_mig_acc_forms_controls a, ',
'                      wwv_mig_rev_forms b, ',
'                      wwv_flow_model_pages c, ',
'                      wwv_flow_model_page_regions f,',
'                      wwv_flow_model_page_cols d,',
'                      wwv_mig_acc_forms e',
'',
'               where  a.project_id = :MW_PROJ_ID',
'               and    b.project_id = a.project_id',
'               and    e.project_id = b.project_id',
'               and    b.formid = a.formid',
'               and    e.formid = b.formid',
'               and    UPPER(b.source_name) = UPPER(to_char(c.source))',
'               and    a.dbid = l_dbid',
'               and    a.security_group_id = :flow_security_group_id',
'               and    a.formid = b.formid',
'               and    a.controltype = 100',
'               and    c.model_id = :MW_MODEL_ID',
'               and    f.model_page_id = c.id',
'               and    d.model_region_id =f.id',
'               and    UPPER(a.parent) LIKE UPPER(d.column_name)',
'    )',
'    loop',
'',
'       -- Set item label in generated application',
'       update wwv_flow_model_page_cols',
'       set column_display_name = c3.caption',
'       where model_region_id = c3.model_region_id',
'       and security_group_id = :flow_security_group_id',
'       and column_name = c3.colname;',
'',
'     ',
'       if c3.formcaption is not null then',
'         -- Set item label in generated application',
'         update wwv_flow_model_pages',
'         set page_name = c3.formcaption',
'         where id = c3.model_page_id',
'         and model_id = :MW_MODEL_ID',
'         and security_group_id = :flow_security_group_id;',
'       end if;',
'',
'    end loop;',
'  ',
'  end if;',
'',
'END;'))
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(21990506830472414.4407)
,p_process_sequence=>60
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add Reports Home Page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'',
' l_cnt_reports   number := 0;',
' l_dbid          number := 0;',
'',
'begin',
'',
'  --',
'  -- Set DBID',
'  --',
'  for c4 in',
'  (',
'    select dbid from wwv_mig_access',
'    where project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and linkdbid is null',
'  )',
'  loop',
'    if :P2_DBID <> 0 then',
'      if c4.dbid = :P2_DBID then',
'        l_dbid := :P2_DBID;',
'      end if;',
'    else',
'      l_dbid := c4.dbid;',
'    end if;',
'  end loop;',
'',
'  -- Retrieve forms & reports page items for parent/non-linked MDB file  ',
'  if l_dbid <> 0 then',
'',
'',
'    for c2 in (select count(*) cnt',
'               from  wwv_mig_rev_reports',
'               where status = ''INCLUDE''',
'               and   project_id = :MW_PROJ_ID',
'               and   security_group_id= :flow_security_group_id',
'               and   dbid = l_dbid)',
'    loop',
'      l_cnt_reports := c2.cnt;',
'    end loop;',
'',
'    if (l_cnt_reports <> 0) then',
'  ',
'      --',
'      -- Only create Reports Home Page if reports have been selected for inclusion',
'      -- in the application',
'      --',
'      wwv_flow_model_api.add_page (',
'         p_model_id        => :MW_MODEL_ID,         ',
'         p_page_name       => ''Reports Home Page'', ',
'         p_page_type       => ''BLANK'', ',
'         p_page_source     => null, ',
'         p_parent_page_num => NULL,  ',
'         p_owner           => :MW_SCHEMA,',
'         p_table           => null, ',
'         p_query           => null, ',
'         p_spreadsheet_data=> null, ',
'         p_report_filter   => null, ',
'         p_form_and_report => null,',
'         p_implementation  => ''INTERACTIVE'');',
'',
'',
'      for c2 in (',
'                 select page_id ',
'                 from WWV_FLOW_MODEL_PAGES',
'                 where model_id = :MW_MODEL_ID ',
'                 and page_name = ''Reports Home Page''',
'                 and security_group_id = :flow_security_group_id',
'      )',
'      loop',
'  ',
'        insert into wwv_mig_rev_apexapp (',
'                                        project_id, ',
'                                        dbid,',
'                                        flow_id,',
'                                        page_id,',
'                                        list_template_name,',
'                                        owner)',
'                                values (',
'                                        :MW_PROJ_ID,',
'                                        l_dbid,',
'                                        :MW_APPLICATION_ID,',
'                                        c2.page_id,',
'                                       ''Vertical Unordered List with Bullets'',',
'                                       :MW_SCHEMA);',
'',
'      end loop;',
'',
'    end if;',
'    ',
'  end if;',
'',
'end;'))
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(3888107460792425.4407)
,p_process_sequence=>70
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add pages for reports on reports'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  l_parent_page_id number := 0;',
'  l_dbid           number := 0;',
'BEGIN',
'',
'  for c4 in',
'  (',
'    select dbid from wwv_mig_access',
'    where project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and linkdbid is null',
'  ) ',
'  loop',
'    if :P2_DBID <> 0 then',
'      if c4.dbid = :P2_DBID then',
'        l_dbid := :P2_DBID;',
'      end if;',
'    else',
'      l_dbid := c4.dbid;',
'    end if;',
'  end loop;',
'',
'',
'  -- Retrieve forms & reports page items for parent/non-linked MDB file  ',
'  if l_dbid <> 0 then',
'',
'    --',
'    -- Set Home Page as parent page for all pages',
'    --',
'    for c2 in (',
'               select id',
'               from   WWV_FLOW_MODEL_PAGES ',
'               where  model_id = :MW_MODEL_ID ',
'               --  and    page_id = 1',
'               and    page_name = ''Reports Home Page''',
'               and    security_group_id = :flow_security_group_id',
'    )',
'    loop ',
'      l_parent_page_id := c2.id;',
'    end loop;',
'  ',
'    --',
'    -- Add New Page',
'    --',
'    for c1 in (',
'               select report_name, source_name, owner, source_syntax',
'               from   wwv_mig_rev_reports',
'               where  security_group_id = :flow_security_group_id',
'               and    status = ''INCLUDE''',
'               and    project_id = :MW_PROJ_ID',
'               and    dbid = l_dbid',
'    )',
'    loop',
'      if c1.source_name is null then',
'',
'        -- Generate a Report based on a SQL Query for Access Report on SQL Query',
'        wwv_flow_model_api.add_page (',
'            p_model_id        => :MW_MODEL_ID,         ',
'            p_page_name       => c1.report_name, ',
'            p_page_type       => ''REPORT'', ',
'            p_page_source     => ''QUERY'', ',
'            p_parent_page_num => l_parent_page_id,  ',
'            p_owner           => c1.owner, ',
'            p_table           => null, ',
'            p_query           => c1.source_syntax,',
'            p_implementation  => ''INTERACTIVE''); ',
'',
'      else',
'',
'        -- Generate Report based on a table for Access Report on table/view',
'         wwv_flow_model_api.add_page (',
'            p_model_id        => :MW_MODEL_ID,         ',
'            p_page_name       => c1.report_name, ',
'            p_page_type       => ''REPORT'', ',
'            p_page_source     => ''TABLE'', ',
'            p_parent_page_num => l_parent_page_id,  ',
'            p_owner           => c1.owner, ',
'            p_table           => c1.source_name, ',
'            p_query           => null, ',
'            p_spreadsheet_data=> null, ',
'            p_report_filter   => null, ',
'            p_form_and_report => null,',
'            p_implementation  => ''INTERACTIVE'');',
'',
'      end if;',
'',
'    end loop;',
'',
'',
'    --',
'    -- Update the Model Page Column information with MS Access label text',
'    --',
'    for c3 in (',
'               select    distinct a.ctrlcaption caption,',
'                         d.column_name colname,',
'                         d.model_region_id model_region_id,',
'                         f.model_page_id model_page_id,',
'                         e.repcaption repcaption',
'       ',
'               from   wwv_mig_acc_rpts_controls a, ',
'                      wwv_mig_rev_reports b, ',
'                      wwv_flow_model_pages c, ',
'                      wwv_flow_model_page_cols d,',
'                      wwv_flow_model_page_regions f,',
'                      wwv_mig_acc_reports e',
'',
'               where  a.project_id = :MW_PROJ_ID',
'               and    b.project_id = a.project_id',
'               and    e.project_id = b.project_id',
'               and    b.reportid = a.reportid',
'               and    e.reportid = b.reportid',
'               and    UPPER(b.source_name) = UPPER(to_char(c.source))',
'               and    a.dbid = l_dbid',
'               and    a.security_group_id = :flow_security_group_id',
'               and    a.reportid = b.reportid',
'               and    a.controltype = 100',
'               and    c.model_id = :MW_MODEL_ID',
'               and    f.model_page_id = c.id',
'               and    d.model_region_id = f.id',
'               and    UPPER(a.parent) LIKE UPPER(d.column_name)',
'    )',
'    loop',
'',
'       -- Set item label in generated application',
'       update wwv_flow_model_page_cols',
'       set column_display_name = c3.caption',
'       where model_region_id = c3.model_region_id',
'       and security_group_id = :flow_security_group_id',
'       and column_name = c3.colname;',
'  ',
'       if c3.repcaption is not null then',
'          -- Set item label in generated application',
'          update wwv_flow_model_pages',
'          set page_name = c3.repcaption',
'          where id = c3.model_page_id',
'          and model_id = :MW_MODEL_ID',
'          and security_group_id = :flow_security_group_id;',
'       end if;',
'',
'    end loop;',
'',
'  end if;',
'',
'end;'))
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(25630222038255936.4407)
,p_process_sequence=>80
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update wwv_mig_rev_apexapp table'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  l_dbid  number := 0;',
'BEGIN',
'',
'for c2 in (',
'  select dbid from wwv_mig_access',
'  where project_id = :MW_PROJ_ID',
'  and security_group_id = :flow_security_group_id',
'  and linkdbid is null',
')',
'loop',
'  if :P2_DBID <> 0 then',
'    l_dbid := :P2_DBID;',
'  else',
'    l_dbid := c2.dbid;',
'  end if;',
'end loop;',
'',
'for c1 in (',
'     select page_id, page_type',
'     from wwv_flow_model_pages',
'     where model_id = :MW_MODEL_ID',
'     and page_type <> ''BLANK''',
')',
'loop',
'  if c1.page_type = ''REPORT'' then',
'    insert into wwv_mig_rev_apexapp (',
'                                     project_id, ',
'                                     dbid,',
'                                     flow_id,',
'                                     page_id,',
'                                     list_item_icon,',
'                                     owner)',
'                             values (',
'                                     :MW_PROJ_ID,',
'                                     l_dbid,',
'                                     :MW_APPLICATION_ID,',
'                                     c1.page_id,',
'                                     ''report_64.gif'',',
'                                     :MW_SCHEMA);',
'  else',
'     insert into wwv_mig_rev_apexapp (',
'                                     project_id, ',
'                                     dbid,',
'                                     flow_id,',
'                                     page_id,',
'                                     list_item_icon,',
'                                     owner)',
'                             values (',
'                                     :MW_PROJ_ID,',
'                                     l_dbid,',
'                                     :MW_APPLICATION_ID,',
'                                     c1.page_id,',
'                                     ''form_64.gif'',',
'                                     :MW_SCHEMA);',
'  end if;',
'',
'end loop;',
'',
'END;'))
,p_process_when=>'LOAD'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00033
begin
wwv_flow_api.create_page(
 p_id=>33.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22430028383277950.4407)
,p_plug_name=>unistr('\65B0\589E\9801\9762')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>61
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('\6309\4E00\4E0B<b>\65B0\589E\9801\9762</b>, \5728\61C9\7528\7A0B\5F0F\4E2D\5EFA\7ACB\4E00\500B\7A7A\767D\7684\9801\9762. \7A7A\767D\9801\9762\6C92\6709\5167\5EFA\7684\529F\80FD. \6309<b>\4E0B\4E00\6B65</b>, \4FDD\7559\76EE\524D\7684\9078\9805\4E26\9032\5165\7CBE\9748\7684\4E0B\4E00\6B65\9A5F.')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(209371209666208559.4407)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>81
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(235485531370344111.4407)
,p_plug_name=>'New Application Information'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>11
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(243691316354762429.4407)
,p_plug_name=>'Create Application Tasks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>31
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(243690011375751560.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717613155760527519.4407)
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(244274600951771794.4407)
,p_name=>unistr('\9078\53D6\7684\61C9\7528\7A0B\5F0F\7269\4EF6')
,p_template=>wwv_flow_api.id(717585174544505758.4407)
,p_display_sequence=>41
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select	 (level-1)*15 indent,',
'         ID,',
'         PAGE_ID,',
'         substr(page_name,1,24) page_name,',
'	 page_type,',
'         page_mode,',
'         page_source,',
'         sys.dbms_lob.substr(replace(source,chr(10),''''),24,1) source,',
'	 PARENT_PAGE_ID,',
'         substr(page_name,1,24) page_name_edit,',
'         id delete_page_icon',
' from	 WWV_FLOW_MODEL_PAGES,',
'         (select wwv_flow_lang.system_message(''DELETE'') msg_delete from dual) m',
'where model_id = :P33_MODEL_ID',
'start with parent_page_id is null and model_id = :P33_MODEL_ID',
'connect by prior id = parent_page_id and model_id = :P33_MODEL_ID',
'order siblings by display_sequence, id'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(717629762332532068.4407)
,p_query_num_rows=>50000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>unistr('\60A8\5C1A\672A\9078\53D6\7DAD\8B77\61C9\7528\7A0B\5F0F\4E2D\6240\8981\542B\62EC\7684\8868\683C\6216\67E5\8A62.')
,p_query_row_count_max=>50000
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.set_region_column_width(
 p_id=>wwv_flow_api.id(244274600951771794.4407)
,p_plug_column_width=>'nowrap="nowrap"'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244274926359771806.4407)
,p_query_column_id=>1
,p_column_alias=>'INDENT'
,p_column_display_sequence=>2
,p_column_heading=>'Indent'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244275024274771806.4407)
,p_query_column_id=>2
,p_column_alias=>'ID'
,p_column_display_sequence=>3
,p_column_heading=>'Id'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244275104180771806.4407)
,p_query_column_id=>3
,p_column_alias=>'PAGE_ID'
,p_column_display_sequence=>4
,p_column_heading=>'ID'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244275214662771806.4407)
,p_query_column_id=>4
,p_column_alias=>'PAGE_NAME'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\540D\7A31')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_cattributes_element=>'nowrap="nowrap"'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244275319836771807.4407)
,p_query_column_id=>5
,p_column_alias=>'PAGE_TYPE'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\985E\578B')
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(6575418257362951)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(615919966309262895.4407)
,p_query_column_id=>6
,p_column_alias=>'PAGE_MODE'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\9801\9762\6A21\5F0F')
,p_use_as_row_header=>'N'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(615826477066801787)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244275432091771807.4407)
,p_query_column_id=>7
,p_column_alias=>'PAGE_SOURCE'
,p_column_display_sequence=>8
,p_column_heading=>unistr('\4F86\6E90')
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(6596415880390663)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244275500572771807.4407)
,p_query_column_id=>8
,p_column_alias=>'SOURCE'
,p_column_display_sequence=>9
,p_column_heading=>unistr('\4F86\6E90')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(244275616132771807.4407)
,p_query_column_id=>9
,p_column_alias=>'PARENT_PAGE_ID'
,p_column_display_sequence=>10
,p_column_heading=>'Parent Page Id'
,p_hidden_column=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(615918322507235343.4407)
,p_query_column_id=>10
,p_column_alias=>'PAGE_NAME_EDIT'
,p_column_display_sequence=>1
,p_column_heading=>unistr('<span class="u-VisuallyHidden">\7DE8\8F2F</span>')
,p_column_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::P11_ID:#ID#'
,p_column_linktext=>unistr('<span class="a-Icon icon-edit-page"></span><span class="u-VisuallyHidden">\7DE8\8F2F #PAGE_NAME#</span>')
,p_column_link_attr=>'class="a-Button a-Button--small a-Button--noLabel a-Button--withIcon a-Button--noUI"'
,p_column_alignment=>'CENTER'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(615918411353235345.4407)
,p_query_column_id=>11
,p_column_alias=>'DELETE_PAGE_ICON'
,p_column_display_sequence=>11
,p_column_heading=>unistr('<span class="u-VisuallyHidden">\522A\9664</span>')
,p_column_link=>'f?p=&APP_ID.:33:&SESSION.:DELETE:&DEBUG.::P33_DELETE_PAGE:#ID#'
,p_column_linktext=>'<span class="a-Icon icon-remove"></span><span class="u-VisuallyHidden">BUTTON_TEXT</span>'
,p_column_link_attr=>'class="a-Button a-Button--small a-Button--noLabel a-Button--withIcon a-Button--noUI"'
,p_column_alignment=>'CENTER'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752115895115695880.4407)
,p_plug_name=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(243717827661831952.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(209371209666208559.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:33,35::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(20583424103677922.4407)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(209371209666208559.4407)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'',
'  l_tables number := 0;',
'  l_queries   number := 0;',
'  l_any     number := 0;',
'  l_defs    number := 0;',
'  l_dbid    number := 0;',
'',
'BEGIN ',
'',
'for c5 in ',
'(',
'  select dbid from wwv_mig_access',
'  where project_id = :MW_PROJ_ID',
'  and security_group_id = :flow_security_group_id',
')',
'loop',
'',
'  if :P2_DBID <> 0 then',
'    l_dbid := :P2_DBID;',
'  else',
'    l_dbid := c5.dbid;',
'  end if;',
'',
'  for c4 in ',
'  (',
'    select count(*) cnt from wwv_flow_app_build_pref',
'    where created_by = :APP_USER',
'    and security_group_id = :flow_security_group_id',
'  )',
'  loop',
'    l_defs := c4.cnt;',
'  end loop;',
'',
'  for c1 in',
'  (   ',
'    select distinct count(status) cnt ',
'    from wwv_mig_rev_tables',
'    where project_id = :MW_PROJ_ID',
'    and dbid = l_dbid',
'    and status = ''INCLUDE''',
'  )',
'  LOOP',
'    l_tables := l_tables + c1.cnt;',
'  END LOOP;',
'',
'  for c2 in',
'  (   ',
'    select distinct count(status) cntforms ',
'    from wwv_mig_rev_queries',
'    where project_id = :MW_PROJ_ID',
'    and dbid = l_dbid',
'    and status = ''INCLUDE''',
'  )',
'  LOOP',
'    l_queries := l_queries + c2.cntforms;',
'  END LOOP;',
'',
'  for c3 in ',
'  (',
'    select count(*) cnt',
'    from WWV_FLOW_MODEL_PAGES',
'    where model_id = :P33_MODEL_ID',
'  )',
'  LOOP',
'    l_any := c3.cnt;',
'  END LOOP;',
'',
'END LOOP;',
'',
'if (l_tables = 0) AND (l_queries = 0) AND (l_any = 0) then',
'   return false;',
'else   ',
'   if l_defs > 0 then',
'     return true;',
'   else',
'     return false;',
'   end if;',
'end if;',
'',
'END;'))
,p_button_condition_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(243713022681821016.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(209371209666208559.4407)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615475481194132964.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\9801')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'',
'  l_tables   number := 0;',
'  l_queries  number := 0;',
'  l_pages    number := 0;',
'  l_dbid     number := 0;',
'',
'BEGIN ',
'',
'   for c4 in',
'   (',
'       select dbid from wwv_mig_access',
'       where project_id = :MW_PROJ_ID',
'       and security_group_id = :flow_security_group_id',
'   )   ',
'   loop',
'     if (:P2_DBID <> 0) and (:P2_DBID is not null) then',
'       l_dbid := :P2_DBID;',
'     else',
'       l_dbid := c4.dbid;',
'     end if;',
'',
'     for c1 in',
'     (   ',
'           select distinct count(status) cnt ',
'           from wwv_mig_rev_tables',
'           where project_id = :MW_PROJ_ID',
'           and dbid = l_dbid',
'           and status = ''INCLUDE''',
'           and security_group_id = :flow_security_group_id',
'     )',
'     LOOP',
'       l_tables := l_tables + c1.cnt;',
'     END LOOP;',
'',
'     for c2 in',
'     (   ',
'       select distinct count(status) cntqueries ',
'       from wwv_mig_rev_queries',
'       where project_id = :MW_PROJ_ID',
'       and dbid = l_dbid',
'       and status = ''INCLUDE''',
'       and security_group_id = :flow_security_group_id',
'     )',
'     LOOP',
'       l_queries := l_queries + c2.cntqueries;',
'     END LOOP;',
'   ',
'     for c3 in ',
'     (',
'       select count(*) cnt',
'       from WWV_FLOW_MODEL_PAGES',
'       where model_id = :P33_MODEL_ID',
'     )',
'     LOOP',
'       l_pages := c3.cnt;',
'     END LOOP;',
'',
'   END LOOP;',
'',
'   if (l_tables = 0) AND (l_queries = 0) AND (l_pages = 0) then',
'     return false;',
'   else   ',
'     return true;',
'   end if;',
'',
'END;'))
,p_button_condition_type=>'FUNCTION_BODY'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(22478213735491367.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(22430028383277950.4407)
,p_button_name=>'ADD_PAGE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--primary'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\65B0\589E\9801\9762')
,p_button_position=>'TEMPLATE_DEFAULT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(21542618326905003.4407)
,p_branch_action=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.::P50_PREVIOUS,P50_NEXT,GEN_APP_CRUMB:33,35,&P33_CRUMB.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(243713022681821016.4407)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(22479126202494963.4407)
,p_branch_action=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(21637330989097831.4407)
,p_name=>'P33_CRUMB'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(243691316354762429.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_lang.system_message(''F4400_P33_BREADCRUMB'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22470310440452560.4407)
,p_name=>'P33_PAGE_TYPE'
,p_item_sequence=>64
,p_item_plug_id=>wwv_flow_api.id(22430028383277950.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when_type=>'NEVER'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22471524985456807.4407)
,p_name=>'P33_PAGE_TYPE_DESC'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(22430028383277950.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'BLANK'
,p_prompt=>unistr('\52D5\4F5C:')
,p_source=>'P33_PAGE_TYPE'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'CREATE APPLICATION PAGE TYPE'
,p_lov=>'.'||wwv_flow_api.id(22139623686037120.4407)||'.'
,p_cattributes_element=>'class="fielddatabold"'
,p_tag_attributes=>'readonly="readonly"'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8B58\5225\76EE\524D\9078\53D6\7684\9801\9762\985E\578B (\7A7A\767D\9801\9762). \60A8\53EF\4EE5\5229\7528\300C\7A7A\767D\9801\9762\300D\4F86\5354\52A9\700F\89BD\60A8\7684\61C9\7528\7A0B\5F0F. \4F8B\5982, \60A8\53EF\4EE5\5F9E\4E00\500B\9801\9762\5B58\53D6\60A8\6240\6709\7684\300C\8868\55AE\300D, \5F9E\53E6\4E00\500B\9801\9762\5B58\53D6\6240\6709\300C\5831\8868\300D. \5728\6B64\60C5\6CC1\4E0B, \60A8\53EF\4EE5\5EFA\7ACB\4E00\500B\300C\7A7A\767D\9801\9762\300D, \7136\5F8C\4F7F\7528\300C\9801\9762\5B9A\7FA9\300D\4F86\7DE8\8F2F\9801\9762, \5373\53EF\63A7\5236\6240\7522\751F\61C9\7528\7A0B\5F0F\7684\700F\89BD.')
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22472400528459221.4407)
,p_name=>'P33_SUBORDINATE_OPTION'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(22430028383277950.4407)
,p_prompt=>unistr('\5F9E\5C6C\65BC\9801\9762')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(page_name)||'' (''||page_id||'')'' p, id r',
'from WWV_FLOW_MODEL_PAGES ',
'where model_id = :P33_MODEL_ID',
'order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \6700\4E0A\5C64\9801\9762 -')
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_display_when=>'select 1 from wwv_flow_model_pages where model_id = :P33_MODEL_ID'
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\5728\65B0\589E\9801\9762\81F3\60A8\7684\61C9\7528\7A0B\5F0F\6642, \53EF\4EE5\540C\6642\65B0\589E\5F9E\5C6C\9801\9762. \5982\679C\67D0\500B\9801\9762\662F\53E6\4E00\500B\9801\9762\7684\5F9E\5C6C\9801\9762, \7CBE\9748\5C07\6703\8981\6C42\60A8\63D0\4F9B\9023\7D50\7236\9805\9801\9762\7684\65B9\6CD5.<br /><br />'),
unistr('\5411\4E0B\5C55\958B\5831\8868\9801\9762\5305\542B\9023\81F3\53E6\4E00\500B\63D0\4F9B\66F4\8A73\7D30\8CC7\8A0A\4E4B\9801\9762\7684\9023\7D50, \5373\662F\5F9E\5C6C\9801\9762\7684\4E00\500B\7BC4\4F8B.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(22477103692488522.4407)
,p_name=>'P33_NAME'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(22430028383277950.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\540D\7A31')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select max(page_id) + 1 max_page',
'   from   wwv_flow_model_pages',
'   where  model_id = :P33_MODEL_ID',
') loop',
'   return wwv_flow_lang.system_message(''MODEL_PAGE'',nvl(c1.max_page,1));',
'end loop;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\6B64\9801\9762\5728\60A8\61C9\7528\7A0B\5F0F\5167\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(235486125960352065.4407)
,p_name=>'P33_MODEL_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(235485531370344111.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(235490118790482495.4407)
,p_name=>'P33_SCHEMA'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(235485531370344111.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cHeight=>1
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(235490810956489671.4407)
,p_name=>'P33_APPLICATION_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(235485531370344111.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(236095302117667905.4407)
,p_name=>'P33_APPLICATION_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(235485531370344111.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(244345114437042199.4407)
,p_name=>'P33_DELETE_PAGE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(235485531370344111.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(23366831338791576.4407)
,p_computation_sequence=>10
,p_computation_item=>'P33_NAME'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select max(page_id) + 1 max_page',
'   from   wwv_flow_model_pages',
'   where  model_id = :P33_MODEL_ID',
') loop',
'   return wwv_flow_lang.system_message(''MODEL_PAGE'',nvl(c1.max_page,1));',
'end loop;'))
,p_compute_when=>':P33_NAME IS NULL'
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(23368404457793235.4407)
,p_computation_sequence=>20
,p_computation_item=>'P33_SUBORDINATE_OPTION'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'null'
,p_compute_when=>'P33_SUBORDINATE_OPTION'
,p_compute_when_text=>'0'
,p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(243680918732734747.4407)
,p_computation_sequence=>70
,p_computation_item=>'P33_SCHEMA'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P2_SCHEMA'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(244233014157453844.4407)
,p_computation_sequence=>71
,p_computation_item=>'P33_APPLICATION_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select migration_name',
'from   wwv_mig_projects',
'where  id = :MW_PROJ_ID',
'and    security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(21595810286997271.4407)
,p_validation_name=>'Must create at least one page'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 r',
'from WWV_FLOW_MODEL_PAGES',
'where model_id = :P33_MODEL_ID'))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('\60A8\81F3\5C11\5FC5\9808\5B9A\7FA9\4E00\500B\9801\9762.')
,p_when_button_pressed=>wwv_flow_api.id(243713022681821016.4407)
,p_associated_item=>wwv_flow_api.id(.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(22478620314493277.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add Page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_model_api.add_page (',
'   p_model_id        => :MW_MODEL_ID,         ',
'   p_page_name       => :P33_NAME, ',
'   p_page_type       => ''BLANK'', ',
'   p_page_source     => null, ',
'   p_parent_page_num => :P33_SUBORDINATE_OPTION,  ',
'   p_owner           => :MW_SCHEMA, ',
'   p_table           => null, ',
'   p_query           => null, ',
'   p_spreadsheet_data => null, ',
'   p_report_filter   => null, ',
'   p_form_and_report => null,',
'   p_implementation  => null,',
'   p_master_table    => null,',
'   p_detail_table    => null',
');'))
,p_process_error_message=>unistr('\7121\6CD5\65B0\589E\9801\9762\81F3\61C9\7528\7A0B\5F0F.')
,p_process_when=>'nvl(:REQUEST,''ADD_PAGE'') NOT IN (''NEXT'',''PREVIOUS'')'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(248131305440933513.4407)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear cache'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'35'
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(19996909063162712.4407)
,p_process_sequence=>15
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Retrieve Application Defaults'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   defaults_found boolean := false;',
'begin',
'for c1 in (',
'   select DEFAULT_AUTHENTICATION_SCHEME,',
'          DEFAULT_APPLICATION_THEME,',
'          DEFAULT_TABS,',
'          DEFAULT_LANGUAGE,',
'          DEFAULT_LANGUAGE_DERIVED',
'   from   WWV_FLOW_APP_BUILD_PREF',
'   where  security_group_id = :flow_security_group_id',
'   )',
'   loop',
'   	:P35_CREATE_TABS := nvl(c1.DEFAULT_TABS,''SINGLE_LEVEL_TABS'');',
'   	:P35_AUTHENTICATION := nvl(c1.DEFAULT_AUTHENTICATION_SCHEME,:PRODUCT_NAME);',
'   	:P35_LANGUAGE := nvl(c1.DEFAULT_LANGUAGE,v(''BROWSER_LANGUAGE''));',
'   	wwv_flow.update_cache_with_write(',
'   	 ''P35_DEFAULT_LANGUAGE_DERIVED'', c1.DEFAULT_LANGUAGE_DERIVED);',
'   	--:P50_THEME  := nvl(c1.DEFAULT_APPLICATION_THEME,''21'');',
'    --    :THEME_ID  := nvl(c1.DEFAULT_APPLICATION_THEME,''21'');',
'   	defaults_found := true;',
'   end loop;',
'if not defaults_found then',
'   :P35_CREATE_TABS := ''SINGLE_LEVEL_TABS'';',
'   :P35_AUTHENTICATION := :PRODUCT_NAME;',
'   :P35_LANGUAGE := ''en'';',
'   --:P50_THEME  := ''21'';',
'   --:THEME_ID  := ''21'';',
'end if;',
'end;'))
,p_process_error_message=>unistr('\7121\6CD5\64F7\53D6\61C9\7528\7A0B\5F0F\9810\8A2D\503C.')
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(244343817507014637.4407)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete page if requested'
,p_process_sql_clob=>'delete from WWV_FLOW_MODEL_PAGES where id = :P33_DELETE_PAGE;'
,p_process_error_message=>unistr('\7121\6CD5\522A\9664\9801\9762')
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(235499308644697129.4407)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create WWV_FLOW_MODELS row'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'',
'  l_id number;',
'  l_owner varchar2(50);',
'  l_flow_id number;',
'  ',
'begin',
'',
'    -- Set Application OWNER  ',
'    for c1 in (select owner',
'               from wwv_mig_rev_tables',
'               where security_group_id = wwv_flow_security.g_security_group_id',
'               and project_id = :MW_PROJ_ID',
'    )',
'    loop',
'        l_owner := c1.owner;',
'        exit;',
'    end loop;',
'',
'    l_id := wwv_flow_id.next_val;',
'    ',
'    -- Set Application ID',
'    :MW_APPLICATION_ID := wwv_flow_utilities.minimum_free_flow;',
'    :MW_APPLICATION_NAME := :P33_APPLICATION_NAME;',
'',
'    ',
'    -- Create application model',
'    insert into WWV_FLOW_MODELS (id, ',
'                                 name, ',
'                                 model_complete, ',
'                                 created_by, ',
'                                 created_on,  ',
'                                 session_id, ',
'                                 flow_id, ',
'                                 owner',
'                                 ) ',
'                          values (l_id, ',
'                                  :MW_APPLICATION_NAME, ',
'                                  ''N'', ',
'                                  :app_user,',
'                                  sysdate,',
'                                  :app_session,',
'                                  :MW_APPLICATION_ID,',
'                                  :MW_SCHEMA',
'                                 );',
'   -- Set Model ID',
'  :P33_MODEL_ID := l_id;',
'  :MW_MODEL_ID  := l_id;',
'',
'end;'))
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13370808861843231.4407)
,p_process_sequence=>35
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add Home Page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'',
'  l_cnt_tables     number := 0;',
'  l_cnt_queries    number := 0;',
'  l_dbid           number := 0;',
'begin',
'',
'  for c1 in (select count(*) cnt',
'             from  wwv_mig_rev_tables',
'             where status = ''INCLUDE''',
'             and   project_id = :MW_PROJ_ID',
'             and   security_group_id= :flow_security_group_id',
'             and   (dbid = wwv_flow_escape.html(:P2_DATABASE) or nvl(wwv_flow_escape.html(:P2_DATABASE),''0'') = ''0''))',
'  loop',
'    l_cnt_tables := c1.cnt;',
'  end loop;',
'',
'  for c2 in (select count(*) cnt',
'             from  wwv_mig_rev_queries',
'             where status = ''INCLUDE''',
'             and   project_id = :MW_PROJ_ID',
'             and   security_group_id= :flow_security_group_id',
'             and   (dbid = wwv_flow_escape.html(:P2_DATABASE) or nvl(wwv_flow_escape.html(:P2_DATABASE),''0'') = ''0''))',
'  loop',
'    l_cnt_queries := c2.cnt;',
'  end loop;',
'',
'',
'if (l_cnt_tables <> 0) or (l_cnt_queries <> 0) then',
'',
'  --',
'  -- Only create Home Page if tables or queries have been selected for inclusion',
'  -- in the maintenance application',
'  --',
'  wwv_flow_model_api.add_page (',
'     p_model_id        => :MW_MODEL_ID,         ',
'     p_page_name       => ''Home Page'', ',
'     p_page_type       => ''BLANK'', ',
'     p_page_source     => null, ',
'     p_parent_page_num => NULL,  ',
'     p_owner           => :MW_SCHEMA, ',
'     p_table           => null, ',
'     p_query           => null, ',
'     p_spreadsheet_data=> null, ',
'     p_report_filter   => null, ',
'     p_form_and_report => null',
'  );',
'',
'',
'  -- Set default Home Page navigation to vertical list',
'  for c2 in (',
'    select page_id ',
'    from WWV_FLOW_MODEL_PAGES',
'    where model_id = :MW_MODEL_ID ',
'    and page_name = ''Home Page''',
'    and security_group_id = :flow_security_group_id',
'  )',
'  loop',
'',
'    for c6 in (',
'               select dbid from wwv_mig_access',
'               where project_id = :MW_PROJ_ID',
'               and security_group_id = :flow_security_group_id',
'               and linkdbid is null',
'    )',
'    loop',
'      if :P2_DBID <> 0 then',
'        l_dbid := :P2_DBID;',
'      else',
'        l_dbid := c6.dbid;',
'      end if;',
'    end loop;',
'  ',
'    insert into wwv_mig_rev_apexapp (',
'                                     project_id, ',
'                                     dbid,',
'                                     flow_id,',
'                                     page_id,',
'                                     list_template_name,',
'                                     list_item_icon,',
'                                     owner)',
'                             values (',
'                                     :MW_PROJ_ID,',
'                                     l_dbid,',
'                                     :MW_APPLICATION_ID,',
'                                     c2.page_id,',
'                                     ''Vertical Unordered List with Bullets'',',
'                                     ''migration/mig_menu1.png'',',
'                                     :MW_SCHEMA);',
'',
'  end loop;',
'',
'end if;',
'',
'end;'))
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
begin
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(236086002014535423.4407)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add page for REPORTANDFORM on TABLE'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  l_parent_page_id number := 0;',
'  l_dbid           number := 0;',
'BEGIN',
'',
'for c2 in (',
'           select id',
'           from   WWV_FLOW_MODEL_PAGES ',
'           where  model_id = :MW_MODEL_ID ',
'           and    page_id = 1',
'           and    page_name = ''Home Page''',
'           and    security_group_id = :flow_security_group_id',
')',
'loop ',
'   l_parent_page_id := c2.id;',
'end loop;',
'',
'  for c1 in (select mig_table_name table_name, owner',
'             from   wwv_mig_rev_tables',
'             where  security_group_id = :flow_security_group_id',
'             and    status = ''INCLUDE''',
'             and    project_id = :MW_PROJ_ID',
'             and    mig_table_name is not null',
'             and    (dbid = wwv_flow_escape.html(:P2_DATABASE) or nvl(wwv_flow_escape.html(:P2_DATABASE),''0'') = ''0'')',
'  )',
'  loop',
'',
'    wwv_flow_model_api.add_page (',
'       p_model_id        => :MW_MODEL_ID,         ',
'       p_page_name       => c1.table_name, ',
'       p_page_type       => ''REPORTANDFORM'', ',
'       p_page_source     => ''TABLE'', ',
'       p_parent_page_num => l_parent_page_id,  ',
'       p_owner           => c1.owner, ',
'       p_table           => c1.table_name, ',
'       p_query           => null, ',
'       p_spreadsheet_data=> null, ',
'       p_report_filter   => null, ',
'       p_form_and_report => null,',
'       p_implementation  => ''INTERACTIVE'' ',
'    );',
'  end loop;',
'',
'',
'END;'))
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(236776623070530114.4407)
,p_process_sequence=>50
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Add page for REPORT on VIEWS (referred to as TABLE)'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  l_parent_page_id number := 0;',
'BEGIN',
'',
'for c2 in (',
'           select id',
'           from   WWV_FLOW_MODEL_PAGES ',
'           where  model_id = :MW_MODEL_ID ',
'           and    page_id = 1',
'           and    page_name = ''Home Page''',
'           and    security_group_id = :flow_security_group_id',
')',
'loop ',
'   l_parent_page_id := c2.id;',
'end loop;',
'',
'  for c1 in (select mig_view_name view_name, owner',
'             from   wwv_mig_rev_queries',
'             where  security_group_id = :flow_security_group_id',
'             and    status = ''INCLUDE''',
'             and    project_id = :MW_PROJ_ID',
'             and    mig_view_name is not null',
'             and    (dbid = wwv_flow_escape.html(:P2_DATABASE) or nvl(wwv_flow_escape.html(:P2_DATABASE),''0'') = ''0'')',
'  )',
'  loop',
'',
'    wwv_flow_model_api.add_page (',
'       p_model_id        => :MW_MODEL_ID,         ',
'       p_page_name       => c1.view_name, ',
'       p_page_type       => ''REPORT'', ',
'       p_page_source     => ''TABLE'', ',
'       p_parent_page_num => l_parent_page_id,  ',
'       p_owner           => c1.owner, ',
'       p_table           => c1.view_name, ',
'       p_query           => null, ',
'       p_spreadsheet_data=> null, ',
'       p_report_filter   => null, ',
'       p_form_and_report => null,',
'       p_implementation  => ''INTERACTIVE''',
'    );',
'  end loop;',
'',
'END;'))
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(26893224263535618.4407)
,p_process_sequence=>90
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update wwv_mig_rev_apexapp table'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'DECLARE',
'  l_dbid  number := 0;',
'BEGIN',
'',
'for c2 in (',
'  select dbid from wwv_mig_access',
'  where project_id = :MW_PROJ_ID',
'  and security_group_id = :flow_security_group_id',
')',
'loop',
'  if :P2_DBID <> 0 then',
'    l_dbid := :P2_DBID;',
'  else',
'    l_dbid := c2.dbid;',
'  end if;',
'end loop;',
'',
'for c1 in (',
'     select page_id, page_type',
'     from wwv_flow_model_pages',
'     where model_id = :MW_MODEL_ID',
'     and page_type <> ''BLANK''',
')',
'loop',
'  if c1.page_type = ''REPORT'' then',
'    insert into wwv_mig_rev_apexapp (',
'                                     project_id, ',
'                                     dbid,',
'                                     flow_id,',
'                                     page_id,',
'                                     list_item_icon,',
'                                     owner)',
'                             values (',
'                                     :MW_PROJ_ID,',
'                                     l_dbid,',
'                                     :MW_APPLICATION_ID,',
'                                     c1.page_id,',
'                                     ''application_64.gif'',',
'                                     :MW_SCHEMA);',
'  else',
'     insert into wwv_mig_rev_apexapp (',
'                                     project_id, ',
'                                     dbid,',
'                                     flow_id,',
'                                     page_id,',
'                                     list_item_icon,',
'                                     owner)',
'                             values (',
'                                     :MW_PROJ_ID,',
'                                     l_dbid,',
'                                     :MW_APPLICATION_ID,',
'                                     c1.page_id,',
'                                     ''page_64.gif'',',
'                                     :MW_SCHEMA);',
'  end if;',
'',
'end loop;',
'',
'END;'))
,p_process_when=>'CC'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00035
begin
wwv_flow_api.create_page(
 p_id=>35.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_footer_text=>'<div id="AjaxLoading" style="display:none;"><img src="#IMAGE_PREFIX#processing3.gif" id="wait" /></div>'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>	#AjaxLoading{padding:5px;font-size:18px;width:200px;text-align:center;left:50%;top:5%;position:absolute;border:2px solid #666;background-color:#FFF;}',
'</style>',
'<script language="JavaScript" type="text/javascript">',
'function doSubmit(r){',
'		html_ShowElement(''AjaxLoading'');',
'	window.setTimeout(''html_GetElement("wait").src = html_GetElement("wait").src'', 100);',
'	flowSelectAll();',
'	document.wwv_flow.p_request.value = r;',
'	document.wwv_flow.submit();',
'} // End doSubmit()',
'</script>',
''))
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(243730110117005665.4407)
,p_plug_name=>'New Application Information'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>11
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(243730332736005671.4407)
,p_plug_name=>'Create Application Tasks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>31
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(243690011375751560.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717613155760527519.4407)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(243730719905005672.4407)
,p_plug_name=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(186396719923353584.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'--  l_theme           number := null;',
'begin',
'',
'wwv_flow_wiz_confirm.create_application (',
'    p_application_id    => :MW_APPLICATION_ID,',
'    p_application       => ''0'',',
'    p_application_name  => :MW_APPLICATION_NAME,',
'    p_schema            => :MW_SCHEMA,',
'    p_language          => :P35_LANGUAGE,',
'    p_authentication    => :P35_AUTHENTICATION,',
'    p_create_tabs       => :P35_CREATE_TABS,',
'    p_navigation_type   => :P35_NAVIGATION_TYPE,',
'    p_shared_components => null,',
'    p_copy_options      => null,',
'    p_theme_app_id      => :P50_THEME,',
'    p_subscribe_theme   => ''N'');',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(338392003877597996.4407)
,p_plug_name=>unistr('\7CBE\9748\6309\9215')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>41
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752116081072695881.4407)
,p_plug_name=>unistr('\7522\751F\7DAD\8B77\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(243730927154005674.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(338392003877597996.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(243731118254005674.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(338392003877597996.4407)
,p_button_name=>'CREATE_APPLICATION'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(243731301371005675.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(338392003877597996.4407)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388884868720279239.4407)
,p_button_image_alt=>unistr('\4E0A\4E00\9801')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.::P50_NEXT,P50_PREVIOUS:35,33'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(12129113159992545.4407)
,p_branch_action=>'f?p=4000:1:&SESSION.::&DEBUG.:1,4150,RP:FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW,F4000_P4150_GOTO_PAGE,F4000_P1_PAGE:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.,1,1'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(243731118254005674.4407)
,p_branch_sequence=>30
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(12213617717448025.4407)
,p_branch_action=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.:38::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>40
,p_branch_condition_type=>'NEVER'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19897217524975835.4407)
,p_name=>'P35_CREATE_TABS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(243730719905005672.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19897823065977521.4407)
,p_name=>'P35_AUTHENTICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(243730719905005672.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19899114726098043.4407)
,p_name=>'P35_LANGUAGE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(243730719905005672.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19899720959099841.4407)
,p_name=>'P35_DEFAULT_LANGUAGE_DERIVED'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(243730719905005672.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1164618448635783990.4407)
,p_name=>'P35_THEME_STYLE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(243730719905005672.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'  select s.id ',
'  from wwv_flow_themes t, wwv_flow_theme_styles s',
'  where t.id = :P50_THEME',
'  and t.theme_id = s.theme_id',
'  and t.flow_id = s.flow_id',
'  and s.is_current = ''Y''',
') loop',
'  return c1.id;',
'end loop;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1164618654594786423.4407)
,p_name=>'P35_NAVIGATION_TYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(243730719905005672.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select navigation_type ',
'from wwv_flow_themes',
'where id = :P50_THEME'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(340064009317830349.4407)
,p_computation_sequence=>10
,p_computation_item=>'P50_THEME'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      select t.id id',
'        from wwv_flows f, wwv_flow_user_interfaces ui, wwv_flow_themes t',
'       where f.security_group_id = 12 ',
'         and f.application_type = ''THEME''',
'         and f.id = ui.flow_id',
'         and f.id = t.flow_id',
'         and ui.theme_id = t.theme_id',
'         and ui.ui_type_id = :P50_UI_TYPE_ID',
'         and instr('',''||wwv_flow_platform.get_preference(''DEFAULT_THEMES'')||'','','',''||t.theme_id||'','') > 0'))
,p_compute_when=>'P50_THEME'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(759408309022924368.4407)
,p_computation_sequence=>20
,p_computation_item=>'P50_THEME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      select t.id id',
'        from wwv_flows f, wwv_flow_user_interfaces ui, wwv_flow_themes t',
'       where f.security_group_id = 12 ',
'         and f.application_type = ''THEME''',
'         and f.id = ui.flow_id',
'         and f.id = t.flow_id',
'         and ui.theme_id = t.theme_id',
'         and ui.ui_type_id = :P50_UI_TYPE_ID',
'         and instr('',''||wwv_flow_platform.get_preference(''DEFAULT_THEMES'')||'','','',''||t.theme_id||'','') > 0'))
,p_compute_when=>'THEME_ID'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(21619623015019908.4407)
,p_computation_sequence=>25
,p_computation_item=>'P50_THEME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'THEME_ID'
,p_compute_when=>'THEME_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(243733116849005772.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_copy_from_theme_flow_id  number;',
'    l_copy_from_theme_id       number;',
'    l_id                       number;',
'    l_theme                    number          := :P50_THEME;',
'    l_copy_from_theme          number          := null;',
'    l_cnt                      number          := null;',
'    l_theme_style_id           number          := :P35_THEME_STYLE;',
'    l_subscribe_theme          varchar2(1)     := ''Y'';',
'    l_list_temp                varchar2(100);',
'    l_auth                     varchar2(100);',
'    l_tabs                     varchar2(100);',
'    l_lang                     varchar2(100);',
'    l_lang_derived             varchar2(100);',
'    l_list_temp_name           varchar2(100);',
'    l_icon                     varchar2(4000);',
'begin',
'',
'    --',
'    -- Create application modules',
'    --',
'    wwv_flow.g_import_in_progress := true;',
'',
'    -- Retrieve Theme Information',
'    if :P50_THEME is not null then       ',
'       select id, ',
'              flow_id',
'         into l_copy_from_theme_id,',
'              l_copy_from_theme_flow_id',
'         from wwv_flow_themes',
'        where security_group_id = 12',
'          and id = :P50_THEME;',
'    end if;',
'',
'    -- Set theme based on user selection    ',
'    l_theme := :P50_THEME;',
'    l_auth  := :P35_AUTHENTICATION;',
'    l_tabs  := :P35_CREATE_TABS;',
'    l_lang  := :P35_LANGUAGE;',
'    l_lang_derived := :P35_DEFAULT_LANGUAGE_DERIVED;',
'',
'    wwv_flow_create_model_app.create_modules (',
'        p_flow_id                    => :MW_APPLICATION_ID,    ',
'        p_model_id                   => :MW_MODEL_ID,',
'        p_navigation_type            => :P35_NAVIGATION_TYPE,',
'        p_create_tabs                => l_tabs,',
'        p_authentication             => l_auth,',
'        p_flow_language              => l_lang,',
'        p_flow_language_derived_from => l_lang_derived,',
'        p_copy_from_theme_id         => l_copy_from_theme_id,',
'        p_copy_from_theme_flow_id    => l_copy_from_theme_flow_id,',
'        p_copy_from_flow_id          => null,',
'        p_copy_option                => null,',
'        p_theme_style_id             => l_theme_style_id,',
'        p_subscribe_theme            => l_subscribe_theme);',
'    ',
'    wwv_flow.update_cache_with_write(''FB_FLOW_ID'',:MW_APPLICATION_ID);',
'    wwv_flow.update_cache_with_write(''FB_FLOW_PAGE_ID'',wwv_flow_create_model_app.g_home_page_id);',
'',
'    wwv_flow.g_import_in_progress := false;',
'',
'    -- Populate audit trail table',
'    select wwv_seq.nextval into l_id from dual;',
'',
'    insert into wwv_flow_builder_audit_trail (',
'        id, AUDIT_DATE, AUDIT_ACTION, FLOW_TABLE,',
'        FLOW_TABLE_PK, FLOW_USER, FLOW_ID, PAGE_ID, SCN)',
'    values (',
'        l_id, sysdate, ''I'', ''WWV_FLOWS'',',
'        :P33_APPLICATION_ID, :app_user,',
'        :P33_APPLICATION_ID, null, null);',
'',
'   -- Rename automatically generated Navigation regions and Lists',
'   l_cnt := 1;',
'   for c5 in (',
'              select page_id from wwv_flow_page_plugs',
'              where flow_id = :MW_APPLICATION_ID',
'              and plug_name = ''Navigation''',
'              and list_template_id is not null',
'   )',
'   loop',
'',
'     update wwv_flow_page_plugs',
'     set plug_name = ''Navigation_''||l_cnt',
'     where flow_id = :MW_APPLICATION_ID',
'     and page_id = c5.page_id;',
'',
'     l_cnt := l_cnt + 1;',
'   ',
'   end loop;',
'',
'   l_cnt := 1;',
'   for c6 in (',
'              select id from wwv_flow_lists',
'              where flow_id = :MW_APPLICATION_ID',
'              and name = ''Navigation''',
'   )',
'   loop',
'',
'     update wwv_flow_lists',
'     set name = ''Navigation_''||l_cnt',
'     where flow_id = :MW_APPLICATION_ID',
'     and id = c6.id;',
'',
'     l_cnt := l_cnt + 1;',
'   ',
'   end loop;',
'',
'',
'   -- Set Navigation templates',
'   l_cnt := 1;',
'   for c1 in (',
'               select list_template_name',
'               from wwv_mig_rev_apexapp',
'               where flow_id = :MW_APPLICATION_ID',
'               and project_id = :MW_PROJ_ID',
'               and security_group_id = :flow_security_group_id',
'               and dbid = :P2_DBID',
'               and owner = :MW_SCHEMA',
'               and list_template_name is not null ',
'   )',
'   loop       ',
'     l_list_temp_name := c1.list_template_name;',
'',
'     for c2 in (',
'              select id',
'              from wwv_flow_list_templates',
'              where flow_id = :MW_APPLICATION_ID',
'              and list_template_name like ''%''||l_list_temp_name',
'     )',
'     loop',
'        l_list_temp := c2.id;',
'     end loop;',
' ',
'     update wwv_flow_page_plugs',
'     set list_template_id = l_list_temp ',
'     where flow_id = :MW_APPLICATION_ID',
'     and plug_name = ''Navigation_''||l_cnt',
'     and list_template_id is not null;',
'',
'     -- Set Navigation region template to "No Template"',
'     update wwv_flow_page_plugs',
'     set plug_template = 0',
'     where list_template_id = l_list_temp ',
'     and flow_id = :MW_APPLICATION_ID',
'     and plug_name = ''Navigation_''||l_cnt',
'     and list_template_id is not null;',
'    ',
'     l_cnt := l_cnt + 1;',
'',
'   end loop;',
'',
'   -- Rename Navigation regions to original ',
'   update wwv_flow_page_plugs',
'   set plug_name = ''Navigation''',
'   where flow_id = :MW_APPLICATION_ID',
'   and list_template_id is not null;',
'',
' ',
'   -- Set list item icons',
'   for c3 in (',
'              select a.page_name, b.list_item_icon ',
'              from wwv_flow_model_page_regions c, wwv_flow_model_pages a ',
'',
'              LEFT JOIN wwv_mig_rev_apexapp b',
'              on a.page_id = b.page_id',
'              and b.flow_id = :MW_APPLICATION_ID',
'              and b.project_id = :MW_PROJ_ID',
'              and b.security_group_id = a.security_group_id',
'              and b.dbid = :P2_DBID',
'  ',
'              where c.link_column is null',
'              and a.model_id = :MW_MODEL_ID',
'              and c.model_page_id = a.id',
'              and a.security_group_id = :flow_security_group_id',
'              and c.security_group_id = a.security_group_id',
'   )',
'   loop',
'      ',
'      if (instr(c3.list_item_icon,''migration/mig_menu'') > 0) then',
'          l_icon := c3.list_item_icon;',
'      else',
'          l_icon := ''menu/''||c3.list_item_icon;',
'      end if;',
'      ',
'      update wwv_flow_list_items',
'      set list_item_icon = l_icon',
'      where flow_id = :MW_APPLICATION_ID',
'      and list_item_link_text = c3.page_name',
'      and security_group_id = :flow_security_group_id;',
'       ',
'   end loop;',
'',
' -- Commented out by JKallman, only for testing purposes.  Should be uncommented for production',
'      delete from wwv_flow_models',
'      where id = :MW_MODEL_ID;',
'',
'    :P33_MODEL_ID := null;',
'',
'end;'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\61C9\7528\7A0B\5F0F &MW_APPLICATION_ID. - &MW_APPLICATION_NAME.')
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\61C9\7528\7A0B\5F0F &MW_APPLICATION_ID. - &MW_APPLICATION_NAME..')
);
end;
/
prompt --application/pages/page_00037
begin
wwv_flow_api.create_page(
 p_id=>37.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('UI \9810\8A2D\503C')
,p_step_title=>unistr('UI \9810\8A2D\503C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280691928866282085)
,p_step_template=>wwv_flow_api.id(717527796284479857.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_rectables.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1778512334454437.4407)
,p_name=>'Table/View Level UI Defaults'
,p_display_sequence=>30
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select t.FORM_REGION_TITLE,',
'       t.REPORT_REGION_TITLE',
'  from WWV_FLOW_HNT_TABLE_INFO t',
' where t.table_id = (select table_id ',
'                      from WWV_FLOW_HNT_TABLE_INFO ',
'                      where schema = :MW_SCHEMA ',
'                      and table_name = :P37_OBJECT_NAME)'))
,p_fixed_header=>'NONE'
,p_query_row_template=>2
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('<span class="instructiontext">\6B64\300C\8868\683C/\8996\89C0\8868\300D\76EE\524D\672A\8A2D\5B9A\300C\4F7F\7528\8005\4ECB\9762\9810\8A2D\503C\300D.</span><br /><br />')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1778719233454474.4407)
,p_query_column_id=>1
,p_column_alias=>'FORM_REGION_TITLE'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\5831\8868\5340\57DF\6A19\984C:')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1778811465454477.4407)
,p_query_column_id=>2
,p_column_alias=>'REPORT_REGION_TITLE'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\8868\55AE\5340\57DF\6A19\984C:')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1779522030457223.4407)
,p_name=>'Column Level UI Defaults'
,p_display_sequence=>40
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT ',
'sys.htf.anchor(''f?p=4500:803:''||:FLOW_SESSION||''::NO:803:P803_TABLE_ID,P803_COLUMN_ID:''||wwv_flow_escape.html(table_id)||'',''||wwv_flow_escape.html(column_id)',
'           ||'',''||wwv_flow_escape.html(column_name),wwv_flow_escape.html(COLUMN_NAME)) COLUMN_NAME, ',
'       LABEL, ',
'       DISPLAY_SEQ_REPORT, ',
'       DISPLAY_SEQ_FORM,',
'       decode(display_in_report,''Y'',DISPLAY_AS_REPORT,''-'') DISPLAY_AS_REPORT,',
'       decode(display_in_report,''Y'',DISPLAY_AS_TAB_FORM,''-'') DISPLAY_AS_TAB_FORM,',
'       decode(display_in_form,''Y'',DISPLAY_AS_FORM,''-'') DISPLAY_AS_FORM',
'  FROM WWV_FLOW_HNT_COLUMN_INFO',
' where table_id = (select table_id ',
'                      from WWV_FLOW_HNT_TABLE_INFO ',
'                      where schema = :MW_SCHEMA ',
'                      and table_name = :P37_OBJECT_NAME)'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(717629762332532068.4407)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_num_rows_type=>'ROW_RANGES'
,p_query_row_count_max=>10000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1779713194457227.4407)
,p_query_column_id=>1
,p_column_alias=>'COLUMN_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\8CC7\6599\6B04\540D\7A31')
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1779820406457228.4407)
,p_query_column_id=>2
,p_column_alias=>'LABEL'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\6A19\7C64')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1779905157457228.4407)
,p_query_column_id=>3
,p_column_alias=>'DISPLAY_SEQ_REPORT'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\5831\8868<br />\9806\5E8F')
,p_heading_alignment=>'LEFT'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1780007057457228.4407)
,p_query_column_id=>4
,p_column_alias=>'DISPLAY_SEQ_FORM'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\5831\8868<br />\986F\793A')
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1780107523457228.4407)
,p_query_column_id=>5
,p_column_alias=>'DISPLAY_AS_REPORT'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5217\8868\5316\8868\55AE<br />\986F\793A')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1780215271457228.4407)
,p_query_column_id=>6
,p_column_alias=>'DISPLAY_AS_TAB_FORM'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\8868\55AE<br />\9806\5E8F')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1780325488457228.4407)
,p_query_column_id=>7
,p_column_alias=>'DISPLAY_AS_FORM'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\8868\55AE<br />\986F\793A')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_disable_sort_column=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1821904930792982.4407)
,p_plug_name=>'UI DEFAULT ACTIONS'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717583097971505756.4407)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(1820113195766969.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717612455559527519.4407)
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(248612806278963241.4407)
,p_plug_name=>unistr('UI \9810\8A2D\503C')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>11
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'sys.htp.p(''<span class="instructiontext">'');',
'sys.htp.p(wwv_flow_lang.system_message(''4500_UI_DEF_HINT_TEXT''));',
'sys.htp.p(''</span><br />'');',
'end;',
'',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(960822954811848.4407)
,p_name=>'P37_OBJECT_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1778512334454437.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1846910489945911.4407)
,p_name=>'P37_OBJECT_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1778512334454437.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(785427502404852343.4407)
,p_name=>'P37_TABLE_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1778512334454437.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(785428302582890203.4407)
,p_computation_sequence=>10
,p_computation_item=>'P37_TABLE_ID'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select table_id ',
'from WWV_FLOW_HNT_TABLE_INFO ',
'where schema = :MW_SCHEMA ',
'and table_name = :P37_OBJECT_NAME'))
);
end;
/
prompt --application/pages/page_00038
begin
wwv_flow_api.create_page(
 p_id=>38.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\5DF2\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\5DF2\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(12186911356184146.4407)
,p_plug_name=>'&nbsp;'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'&nbsp;'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(12187106358184149.4407)
,p_plug_name=>unistr('\5DE5\4F5C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717584444915505758.4407)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_header=>unistr('<p>\60A8\7684\532F\5165\6A94\6848\5728\532F\51FA\5132\5B58\5340\57DF\4E2D.  \9664\975E\60A8\6253\7B97\518D\5B89\88DD\4E00\6B21, \5426\5247\8ACB\5C07\5B83\79FB\9664.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(209373728759242462.4407)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>110
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(209402230144592934.4407)
,p_plug_name=>unistr('\6210\529F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585174544505758.4407)
,p_plug_display_sequence=>80
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
' wwv_flow_wiz_confirm.create_success_page(',
'    p_success_msg => wwv_flow_lang.system_message(''APP_SUCCESS_MSG''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752116159764695882.4407)
,p_plug_name=>unistr('\5DF2\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(209398105079576288.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(209373728759242462.4407)
,p_button_name=>'RUN_APP'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\57F7\884C\61C9\7528\7A0B\5F0F')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&FB_FLOW_ID.:&FB_FLOW_PAGE_ID.:&SESSION.'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(209398328628583046.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(209373728759242462.4407)
,p_button_name=>'EDIT_APP'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\7DE8\8F2F\61C9\7528\7A0B\5F0F')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=4000:1:&SESSION.::&DEBUG.:1,4150,RP:FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW,F4000_P4150_GOTO_PAGE,F4000_P1_PAGE:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.,1,1'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(12187422025184163.4407)
,p_branch_action=>'f?p=&FB_FLOW_ID.:1:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'RUN'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(12187613634184163.4407)
,p_branch_action=>'f?p=4400:1:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'EDIT'
,p_save_state_before_branch_yn=>'Y'
);
end;
/
prompt --application/pages/page_00039
begin
wwv_flow_api.create_page(
 p_id=>39.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_footer_text=>'<div id="AjaxLoading" style="display:none;"><img src="#IMAGE_PREFIX#processing3.gif" id="wait" /></div>'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>	#AjaxLoading{padding:5px;font-size:18px;width:200px;text-align:center;left:50%;top:5%;position:absolute;border:2px solid #666;background-color:#FFF;}',
'</style>',
'<script language="JavaScript" type="text/javascript">',
'function doSubmit(r){',
'		html_ShowElement(''AjaxLoading'');',
'	window.setTimeout(''html_GetElement("wait").src = html_GetElement("wait").src'', 100);',
'	flowSelectAll();',
'	document.wwv_flow.p_request.value = r;',
'	document.wwv_flow.submit();',
'} // End doSubmit()',
'</script>',
''))
,p_step_template=>wwv_flow_api.id(717529266352479864.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(982815464260216.4407)
,p_plug_name=>'New Application Information'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>11
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(983012318260226.4407)
,p_plug_name=>'Create Application Tasks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>31
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(243690011375751560.4407)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(717613155760527519.4407)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(983412301260232.4407)
,p_plug_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(186396719923353584.4407)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_app_name varchar2(400) := null;',
'begin',
'',
'  if :MW_MIG_TYPE = ''access'' then',
'    --l_app_name := :MW_PROJ_NAME;',
'    l_app_name := :MW_APPLICATION_NAME;',
'  else',
'    l_app_name := :P29_APPLICATION_NAME;',
'  end if;',
'',
'  wwv_flow_wiz_confirm.create_application (',
'      p_application_id    => :MW_APPLICATION_ID,',
'      p_application       => ''0'',',
'      p_application_name  => l_app_name,',
'      p_schema            => :MW_SCHEMA,',
'      p_language          => :P39_LANGUAGE,',
'      p_authentication    => :P39_AUTHENTICATION,',
'      p_create_tabs       => :P39_CREATE_TABS,',
'      p_navigation_type   => :P39_NAVIGATION_TYPE,',
'      p_shared_components => null,',
'      p_copy_options      => null,',
'      p_theme_app_id      => :P50_THEME,',
'      p_subscribe_theme   => ''N'');',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(338362722091518111.4407)
,p_plug_name=>unistr('\7CBE\9748\6309\9215')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>41
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752116200108695882.4407)
,p_plug_name=>unistr('\7522\751F\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717585835676505759.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(983617435260234.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(338362722091518111.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&P39_CANCEL.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(983826096260237.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(338362722091518111.4407)
,p_button_name=>'CREATE_APPLICATION'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(984001698260238.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(338362722091518111.4407)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(388884868720279239.4407)
,p_button_image_alt=>unistr('\4E0A\4E00\9801')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.::P50_NEXT,P50_PREVIOUS,P50_CANCEL:39,&P50_PREVIOUS.,&P50_CANCEL.'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(986316925260263.4407)
,p_branch_name=>'Go To Page 1'
,p_branch_action=>'f?p=4000:1:&SESSION.::&DEBUG.:1,4150,RP:FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW,F4000_P4150_GOTO_PAGE,F4000_P1_PAGE:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.,1,1&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(983826096260237.4407)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(12603525362377501.4407)
,p_branch_name=>'Go To Page 38'
,p_branch_action=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.:38::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'NEVER'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19751332753904613.4407)
,p_name=>'P39_CREATE_TABS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(983412301260232.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19751905525906197.4407)
,p_name=>'P39_AUTHENTICATION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(983412301260232.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19752512452908217.4407)
,p_name=>'P39_LANGUAGE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(983412301260232.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19753118339909905.4407)
,p_name=>'P39_DEFAULT_LANGUAGE_DERIVED'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(983412301260232.4407)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(271761625070036519.4407)
,p_name=>'P39_CANCEL'
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(983412301260232.4407)
,p_use_cache_before_default=>'NO'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1164305314044398556.4407)
,p_name=>'P39_THEME_STYLE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(983412301260232.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'  select s.id ',
'  from wwv_flow_themes t, wwv_flow_theme_styles s',
'  where t.id = :P50_THEME',
'  and t.theme_id = s.theme_id',
'  and t.flow_id = s.flow_id',
'  and s.is_current = ''Y''',
') loop',
'  return c1.id;',
'end loop;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1164308066327451106.4407)
,p_name=>'P39_NAVIGATION_TYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(983412301260232.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select navigation_type ',
'from wwv_flow_themes',
'where id = :P50_THEME'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(21501813741872231.4407)
,p_computation_sequence=>10
,p_computation_item=>'P50_THEME'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'THEME_ID'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(340063523982823565.4407)
,p_computation_sequence=>10
,p_computation_item=>'P50_THEME'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      select t.id id',
'        from wwv_flows f, wwv_flow_user_interfaces ui, wwv_flow_themes t',
'       where f.security_group_id = 12 ',
'         and f.application_type = ''THEME''',
'         and f.id = ui.flow_id',
'         and f.id = t.flow_id',
'         and ui.theme_id = t.theme_id',
'         and ui.ui_type_id = 1',
'         and instr('',''||wwv_flow_platform.get_preference(''DEFAULT_THEMES'')||'','','',''||t.theme_id||'','') > 0'))
,p_compute_when=>'P50_THEME'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(985228492260254.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_copy_from_theme_flow_id  number;',
'    l_copy_from_theme_id       number;',
'    l_theme                    number          := :P50_THEME;',
'    l_copy_from_theme          number          := null;',
'    l_id                       number;',
'    l_theme_style_id           number          := :P39_THEME_STYLE;',
'    l_subscribe_theme          varchar2(1)     := ''Y'';',
'    l_list_temp                varchar2(100);',
'    l_cnt                      number          := null;',
'    l_auth                     varchar2(100)   := :P39_AUTHENTICATION;',
'    l_tabs                     varchar2(100)   := :P39_CREATE_TABS;',
'    l_lang                     varchar2(100)   := :P39_LANGUAGE;',
'    l_lang_derived             varchar2(100)   := :P39_DEFAULT_LANGUAGE_DERIVED;',
'    l_date_format              varchar2(400)   := :P39_DATE_FORMAT;',
'    l_list_template            varchar2(400);',
'    l_icon                     varchar2(4000);',
'begin',
'    --',
'    -- Create application modules',
'    --',
'    wwv_flow.g_import_in_progress := true;',
'',
'    -- Retrieve Theme Information',
'    if :P50_THEME is not null then       ',
'       select id, ',
'              flow_id',
'         into l_copy_from_theme_id,',
'              l_copy_from_theme_flow_id',
'         from wwv_flow_themes',
'        where security_group_id = 12',
'          and id = :P50_THEME;',
'    end if;',
'',
'    wwv_flow_create_model_app.create_modules (',
'        p_flow_id                    => :MW_APPLICATION_ID,',
'        p_model_id                   => :MW_MODEL_ID,',
'        p_navigation_type            => :P39_NAVIGATION_TYPE,',
'        p_create_tabs                => l_tabs,',
'        p_authentication             => l_auth,',
'        p_flow_language              => l_lang,',
'        p_flow_language_derived_from => l_lang_derived,',
'        p_date_format                => l_date_format,',
'        p_copy_from_theme_id         => l_copy_from_theme_id,',
'        p_copy_from_theme_flow_id    => l_copy_from_theme_flow_id,',
'        p_copy_from_flow_id          => null,',
'        p_copy_option                => null,',
'        p_theme_style_id             => l_theme_style_id,',
'        p_subscribe_theme            => l_subscribe_theme);',
'',
'',
'    wwv_flow.update_cache_with_write(''FB_FLOW_ID'', :MW_APPLICATION_ID);',
'    wwv_flow.update_cache_with_write(''FB_FLOW_PAGE_ID'', wwv_flow_create_model_app.g_home_page_id);',
'',
'    wwv_flow.g_import_in_progress := false;',
'',
'    -- Populate audit trail table',
'    select wwv_seq.nextval into l_id from dual;',
'',
'    insert into wwv_flow_builder_audit_trail (',
'        id, audit_date, audit_action, flow_table,',
'        flow_table_pk, flow_user, flow_id, page_id, scn)',
'    values (',
'        l_id, sysdate, ''I'', ''WWV_FLOWS'',',
'        :MW_APPLICATION_ID, :APP_USER,',
'        :MW_APPLICATION_ID, null, null);',
'',
'    -- Rename automatically generated Navigation regions and Lists',
'    l_cnt := 1;',
'    for c5 in (select page_id from wwv_flow_page_plugs',
'               where flow_id   = :MW_APPLICATION_ID',
'                 and plug_name = ''Navigation''',
'                 and list_template_id is not null)',
'    loop',
'        update wwv_flow_page_plugs',
'           set plug_name = ''Navigation_'' || l_cnt',
'         where flow_id   = :MW_APPLICATION_ID',
'           and page_id   = c5.page_id;',
'',
'        l_cnt := l_cnt + 1;',
'    end loop;',
'',
'    l_cnt := 1;',
'    for c6 in (select id from wwv_flow_lists',
'                where flow_id = :MW_APPLICATION_ID',
'                  and name    = ''Navigation'')',
'    loop',
'        update wwv_flow_lists',
'           set name    = ''Navigation_'' || l_cnt',
'         where flow_id = :MW_APPLICATION_ID',
'           and id      = c6.id;',
'',
'        l_cnt := l_cnt + 1;',
'    end loop;',
'',
'    -- Set Navigation templates',
'    l_cnt := 1;',
'    --    if :MW_MIG_TYPE = ''access'' then',
'    for c1 in (select list_template_name',
'                 from wwv_mig_rev_apexapp',
'                where flow_id           = :MW_APPLICATION_ID',
'                  and project_id        = :MW_PROJ_ID',
'                  and security_group_id = :FLOW_SECURITY_GROUP_ID',
'                  and dbid              = :P2_DBID',
'                  and owner             = :MW_SCHEMA',
'                  and list_template_name is not null)',
'    loop       ',
'        -- Fix for bug 8233884',
'        l_list_template := c1.list_template_name;',
'        -- Fix for bug 9729191:following IF-statement no longer required.',
'        /*if (l_theme = 9) then',
'            if (c1.list_template_name = ''Horizontal Images with Label List'') then',
'                l_list_template := ''Horizontal Images with Label Text'';',
'            end if;',
'        elsif (l_theme = 1) then',
'            l_list_template := ''APEX 4.0 - ''||l_list_template;',
'        end if; */',
'',
'        for c2 in (select id',
'                     from wwv_flow_list_templates',
'                    where flow_id            = :MW_APPLICATION_ID',
'                      and list_template_name like ''%''||l_list_template)',
'        loop',
'            l_list_temp := c2.id;',
'        end loop;',
'',
'     /*   update wwv_flow_lists',
'           set display_row_template_id = l_list_temp',
'         where flow_id                 = :MW_APPLICATION_ID',
'           and security_group_id       = :FLOW_SECURITY_GROUP_ID',
'           and name                    = ''Navigation_'' || l_cnt; */',
'',
'        update wwv_flow_page_plugs',
'           set list_template_id = l_list_temp',
'         where flow_id          = :MW_APPLICATION_ID',
'           and plug_name        = ''Navigation_'' || l_cnt',
'           and list_template_id is not null;',
'',
'        -- Set Navigation region template to "No Template"',
'        update wwv_flow_page_plugs',
'           set plug_template    = 0',
'         where list_template_id = l_list_temp',
'           and flow_id          = :MW_APPLICATION_ID',
'           and plug_name        = ''Navigation_'' || l_cnt',
'           and list_template_id is not null;',
'',
'        l_cnt := l_cnt + 1;',
'    end loop;',
'',
'    -- Rename Navigation regions to original',
'    update wwv_flow_page_plugs',
'       set plug_name = ''Navigation''',
'     where flow_id = :MW_APPLICATION_ID',
'       and list_template_id is not null;',
'',
'',
'    -- Set list item icons',
'    for c3 in (select a.page_name,',
'                      b.list_item_icon',
'                 from wwv_flow_model_page_regions c,',
'                      wwv_flow_model_pages a',
'                      left join wwv_mig_rev_apexapp b',
'                             on a.page_id           = b.page_id',
'                            and b.flow_id           = :MW_APPLICATION_ID',
'                            and b.project_id        = :MW_PROJ_ID',
'                            and b.security_group_id = a.security_group_id',
'                            and b.dbid              = :P2_DBID',
'                            and b.owner             = :MW_SCHEMA',
'                where c.link_column is null',
'                  and a.model_id          = :MW_MODEL_ID',
'                  and c.model_page_id     = a.id',
'                  and a.security_group_id = :FLOW_SECURITY_GROUP_ID',
'                  and c.security_group_id = a.security_group_id)',
'    loop',
'        if (instr(c3.list_item_icon, ''migration/mig_menu'') > 0) then',
'            l_icon := c3.list_item_icon;',
'        else',
'            l_icon := ''menu/'' || c3.list_item_icon;',
'        end if;',
'',
'        update wwv_flow_list_items',
'           set list_item_icon      = l_icon',
'         where flow_id             = :MW_APPLICATION_ID',
'           and list_item_link_text = c3.page_name',
'           and security_group_id   = :FLOW_SECURITY_GROUP_ID;',
'    end loop;',
'',
'    -- Set MODEL_COMPLETE to ''Y''',
'    update wwv_flow_models ',
'       set model_complete = ''Y''',
'     where id             = :MW_MODEL_ID;',
'',
'end;'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\61C9\7528\7A0B\5F0F &MW_APPLICATION_ID. - &MW_APPLICATION_NAME.')
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\61C9\7528\7A0B\5F0F &MW_APPLICATION_ID. - &MW_APPLICATION_NAME..')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(283133920154496190.4407)
,p_process_sequence=>15
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update APEX Application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_mig_frm_update_apx_app.update_page_plug (',
'    p_flow_id           => :MW_APPLICATION_ID,',
'    p_model_id          => :MW_MODEL_ID,',
'    p_project_id        => :MW_PROJ_ID,',
'    p_security_group_id => :FLOW_SECURITY_GROUP_ID',
');',
'',
'wwv_mig_frm_update_apx_app.update_forms_pages(',
'    p_flow_id           => :MW_APPLICATION_ID,',
'    p_model_id          => :MW_MODEL_ID,',
'    p_project_id        => :MW_PROJ_ID,',
'    p_security_group_id => :FLOW_SECURITY_GROUP_ID',
');'))
,p_process_when=>'MW_MIG_TYPE'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'forms'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(332006229396446922.4407)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Associate APP_ID With Project'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    update wwv_mig_projects',
'    set    generated_application_id = :MW_APPLICATION_ID',
'    where  id = :MW_PROJ_ID',
'    and    security_group_id = :flow_security_group_id;',
'',
'    insert into wwv_mig_generated_applications ',
'       (security_group_id, project_id, application_id ) ',
'    values (:flow_security_group_id, :MW_PROJ_ID,:MW_APPLICATION_ID); ',
'',
'    -- Set Application Logo Using Application Name',
'    wwv_mig_frm_update_apx_app.set_apex_app_logo(',
'                       p_app_name => :P29_APPLICATION_NAME,',
'                       p_flow_id => :MW_APPLICATION_ID,',
'                       p_security_group_id => :flow_security_group_id);',
'',
'',
'    for c1 in ( select page_id, mig_comments',
'                from   wwv_flow_model_pages',
'                where  model_id = :MW_MODEL_ID',
'    ) loop',
'        update wwv_flow_steps',
'        set    page_comment = c1.mig_comments',
'        where  id           = c1.page_id',
'        and    flow_id      = :MW_APPLICATION_ID;',
'    end loop;',
'',
'end;'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(280705505897417341.4407)
,p_process_sequence=>25
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Clean Up Incomplete Models'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  delete from wwv_flow_models ',
'  where model_complete = ''N''',
'  and security_group_id = :flow_security_group_id',
'  and session_id not in (select id from wwv_flow_sessions$);',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(983826096260237.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(271789731098123351.4407)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fetch Navigation Page Values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :MW_MIG_TYPE = ''access'' then',
'    :P39_CANCEL := 2;',
'    :P50_CANCEL := 2;',
'    :P50_PREVIOUS := 31;',
'else',
'    :P39_CANCEL := 51;',
'    :P50_CANCEL := 51;',
'    :P50_PREVIOUS := 62;',
'end if;'))
);
end;
/
prompt --application/pages/page_00044
begin
wwv_flow_api.create_page(
 p_id=>44.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\8B66\793A')
,p_step_title=>unistr('\8B66\793A')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280692031983283006)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(717527373719479827.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/fmig_rev_forms.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(310697619006866627.4407)
,p_plug_name=>unistr('\8B66\793A')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717558830541505732.4407)
,p_plug_display_sequence=>35
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select b.id,',
'       b.name,',
'       b.alertstyle,',
'       b.alertmessage,',
'       b.button1label,',
'       b.button2label,',
'       b.visualattributename,',
'       decode(b.SmartClass,''true'',t.y,''false'',t.n) SmartClass,',
'       decode(b.SubclassObjectGroup,''true'', t.y,''false'',t.n) SubclassObjectGroup,',
'       b.FontName,',
'       b.FontSize,',
'       b.ForegroundColor,',
'       b.FontSpacing,',
'       b.FontStyle,',
'       b.FontWeight,',
'       b.LanguageDirection,',
'       b.ParentFilename,',
'       b.ParentFilepath,',
'       b.ParentName,',
'       b.ParentModule,',
'       b.ParentModuleType,',
'       b.ParentType,',
'       b.PersistentClientInfoLength,',
'       b.BackColor,',
'       b.alert_Comment,',
'       b.FillPattern,',
'       decode(b.applicable,''Y'',t.y,''N'',t.n) applicable,',
'       decode(b.complete,''Y'',t.y,''N'',t.n) complete,',
'       b.priority,',
'       b.assignee,',
'       b.notes, ',
'       substr(b.notes,1,30)||decode(sign(20-length(b.notes )), -1, '' ...'', null) notes_snippet,',
'       b.tags,',
'       p.file_name',
'from   wwv_mig_forms p,',
'       wwv_mig_frm_modules m,',
'       wwv_mig_frm_formmodules f, ',
'       wwv_mig_frm_rev_formmodules rf,',
'       wwv_mig_frm_alerts b,',
'       (select wwv_flow_lang.system_message(''APEXIR_YES'') y, wwv_flow_lang.system_message(''APEXIR_NO'') n from dual) t',
'',
'where  p.id = m.file_id',
'and    m.id = f.module_id',
'and    f.id = b.formmodule_id',
'and    f.id = rf.formmodule_id',
'and    p.project_id = :MW_PROJ_ID',
'and    p.security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(310697725961866627.4407)
,p_name=>'Alerts'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_display_row_count=>'Y'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'C'
,p_show_rows_per_page=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link=>'f?p=&APP_ID.:78:&SESSION.::&DEBUG.::P78_ID:#ID#'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="&VIEW_DETAIL.">'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'ASHISH'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314922713318618144.4407)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'N'
,p_column_label=>'ID'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310697908519866638.4407)
,p_db_column_name=>'NAME'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310698005670866640.4407)
,p_db_column_name=>'ALERTSTYLE'
,p_display_order=>3
,p_column_identifier=>'B'
,p_column_label=>unistr('\6A23\5F0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310698116983866640.4407)
,p_db_column_name=>'ALERTMESSAGE'
,p_display_order=>4
,p_column_identifier=>'C'
,p_column_label=>unistr('\8A0A\606F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310698202668866641.4407)
,p_db_column_name=>'BUTTON1LABEL'
,p_display_order=>5
,p_column_identifier=>'D'
,p_column_label=>unistr('\6309\9215 1 \6A19\7C64')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310698319433866641.4407)
,p_db_column_name=>'BUTTON2LABEL'
,p_display_order=>6
,p_column_identifier=>'E'
,p_column_label=>unistr('\6309\9215 2 \6A19\7C64')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(310698414758866641.4407)
,p_db_column_name=>'VISUALATTRIBUTENAME'
,p_display_order=>7
,p_column_identifier=>'F'
,p_column_label=>unistr('\8996\89BA\5C6C\6027\540D\7A31')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314922210920611503.4407)
,p_db_column_name=>'PRIORITY'
,p_display_order=>11
,p_column_identifier=>'J'
,p_column_label=>unistr('\512A\5148\9806\5E8F')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314922329481611503.4407)
,p_db_column_name=>'ASSIGNEE'
,p_display_order=>12
,p_column_identifier=>'K'
,p_column_label=>unistr('\6307\5B9A\5C0D\8C61')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314922406631611503.4407)
,p_db_column_name=>'NOTES'
,p_display_order=>13
,p_column_identifier=>'L'
,p_column_label=>unistr('\9644\8A3B')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(314922507468611503.4407)
,p_db_column_name=>'TAGS'
,p_display_order=>14
,p_column_identifier=>'M'
,p_column_label=>unistr('\6A19\8A18')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315670020124429744.4407)
,p_db_column_name=>'APPLICABLE'
,p_display_order=>15
,p_column_identifier=>'O'
,p_column_label=>unistr('\9069\7528')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(315670131507429745.4407)
,p_db_column_name=>'COMPLETE'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>unistr('\5B8C\6210')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(316767429939183493.4407)
,p_db_column_name=>'NOTES_SNIPPET'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>unistr('\9644\8A3B\7A0B\5F0F\78BC\7247\6BB5')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(69090932326668383.4407)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('\6A94\6848\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112481714402452336.4407)
,p_db_column_name=>'SMARTCLASS'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('\667A\6167\985E\5225')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112481805089452336.4407)
,p_db_column_name=>'SUBCLASSOBJECTGROUP'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('\5B50\985E\5225\7269\4EF6\7FA4\7D44')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112481931389452336.4407)
,p_db_column_name=>'FONTNAME'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5B57\578B\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482020722452337.4407)
,p_db_column_name=>'FONTSIZE'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>unistr('\5B57\578B\5927\5C0F')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482118905452337.4407)
,p_db_column_name=>'FOREGROUNDCOLOR'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>unistr('\524D\666F\8272\5F69')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482218839452337.4407)
,p_db_column_name=>'FONTSPACING'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('\5B57\578B\9593\8DDD')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482320782452337.4407)
,p_db_column_name=>'FONTSTYLE'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('\5B57\578B\6A23\5F0F')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482402273452337.4407)
,p_db_column_name=>'FONTWEIGHT'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\5B57\578B\7C97\7D30')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482518798452338.4407)
,p_db_column_name=>'LANGUAGEDIRECTION'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\8A9E\8A00\65B9\5411')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482600328452338.4407)
,p_db_column_name=>'PARENTFILENAME'
,p_display_order=>28
,p_column_identifier=>'AB'
,p_column_label=>unistr('\7236\9805\6A94\6848\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482714069452338.4407)
,p_db_column_name=>'PARENTFILEPATH'
,p_display_order=>29
,p_column_identifier=>'AC'
,p_column_label=>unistr('\7236\9805\6A94\6848\8DEF\5F91')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482821927452338.4407)
,p_db_column_name=>'PARENTNAME'
,p_display_order=>30
,p_column_identifier=>'AD'
,p_column_label=>unistr('\7236\9805\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112482913780452338.4407)
,p_db_column_name=>'PARENTMODULE'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\7236\9805\6A21\7D44')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112483007296452339.4407)
,p_db_column_name=>'PARENTMODULETYPE'
,p_display_order=>32
,p_column_identifier=>'AF'
,p_column_label=>unistr('\7236\9805\6A21\7D44\985E\578B')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112483121797452339.4407)
,p_db_column_name=>'PARENTTYPE'
,p_display_order=>33
,p_column_identifier=>'AG'
,p_column_label=>unistr('\7236\9805\985E\578B')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112483206721452339.4407)
,p_db_column_name=>'PERSISTENTCLIENTINFOLENGTH'
,p_display_order=>34
,p_column_identifier=>'AH'
,p_column_label=>unistr('\6C38\4E45\5F9E\5C6C\7AEF\8CC7\8A0A\9577\5EA6')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112483325479452339.4407)
,p_db_column_name=>'BACKCOLOR'
,p_display_order=>35
,p_column_identifier=>'AI'
,p_column_label=>unistr('\80CC\666F\8272\5F69')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112483404482452340.4407)
,p_db_column_name=>'ALERT_COMMENT'
,p_display_order=>36
,p_column_identifier=>'AJ'
,p_column_label=>unistr('\8A3B\89E3')
,p_allow_sorting=>'N'
,p_column_type=>'CLOB'
,p_rpt_show_filter_lov=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(112483509775452340.4407)
,p_db_column_name=>'FILLPATTERN'
,p_display_order=>37
,p_column_identifier=>'AK'
,p_column_label=>unistr('\586B\6EFF\5716\6A23')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(313082917481007511.4407)
,p_plug_name=>unistr('\8B66\793A')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(186397626021353594.4407)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\6B64\9801\9762\53EF\4F9B\60A8\6AA2\8996\5F9E Oracle Forms \61C9\7528\7A0B\5F0F\64F7\53D6\4E4B\300C\8B66\793A\300D\7684\76F8\95DC\8CC7\8A0A.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(273296602397337376.4407)
,p_branch_action=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>11
);
end;
/
prompt --application/pages/page_00047
begin
wwv_flow_api.create_page(
 p_id=>47.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\65B0\9801\9762\5B9A\7FA9')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\65B0\9801\9762\5B9A\7FA9')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_html_page_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'onLoad="modelDisableLinkText();',
'modelDisableItem(document.getElementById(''P47_LINK_COLUMN''), document.getElementById(''P47_USE_LINK_COLUMN_0''),''ONLOAD'');"'))
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'',
'  function modelDisableItem(itemNode, checkItemNode, itemVal) ',
'  {',
'    if($x(itemNode))',
'    {',
'      if (itemVal!=''ONLOAD'') ',
'      {',
'        itemNode.value = itemVal;',
'      }   ',
'      html_disableItem(itemNode, checkItemNode.checked);',
'    }',
'  }',
'    ',
'  function modelDisableItem2(itemNode, checkItemNode, itemVal) ',
'  {',
'    itemNode.value = itemVal;',
'    if (checkItemNode.checked==false) ',
'    {',
'      if (document.getElementById(''P47_LINK_COLUMN'').value!=''LINK$'') ',
'      {',
'document.getElementById(''P47_LINK_TEXT'').value=''#''+document.getElementById(''P47_LINK_COLUMN'').value+''#'';',
'      }    ',
'    }',
'    html_disableItem(itemNode, checkItemNode.checked);',
'  }',
'    ',
'  function modelDisableLinkText() ',
'  {',
'    if ($x(''P47_LINK_TEXT''))',
'    {',
'      if (document.getElementById(''P47_LINK_TEXT'').value.length==0) ',
'      {',
'        html_disableItem(document.getElementById(''P47_LINK_TEXT''), true);',
'      } ',
'      else ',
'      {',
'        document.getElementById(''P47_USE_THEME_BUTTON_0'').checked=false;',
'      }',
'    }',
'  }',
'',
'  htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'',
'  function setIconList()',
'  {',
'    doSubmit();',
'  }',
'',
'',
'  function setIconHidden()',
'  {',
'html_SetSelectedValue(''P47_PAGE_ICON'',document.getElementById(''P47_HIDDEN'').value);',
'doSubmit();',
'  }',
'',
'',
'  function setPageName(pName)',
'  {',
'    var get = new htmldb_Get(null,html_GetElement(''pFlowId'').value,''APPLICATION_PROCESS=dummy'',0);',
'    get.add(pName, $x(pName).value);',
'    gReturn = get.get();',
'    get = null;',
'  }',
'',
'</script>',
'',
'<style type="text/css">',
'pre {',
' white-space: pre-wrap;       /* css-3 */',
' white-space: -moz-pre-wrap;  /* Mozilla, since 1999 */',
' white-space: -pre-wrap;      /* Opera 4-6 */',
' white-space: -o-pre-wrap;    /* Opera 7 */',
' word-wrap: break-word;       /* Internet Explorer 5.5+ */',
'}',
'</style>',
'',
''))
,p_step_template=>wwv_flow_api.id(717533351543479866.4407)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(13330721654478373.4407)
,p_plug_name=>unistr('\9801\9762\5B9A\7FA9')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_1'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(13330905566478410.4407)
,p_plug_name=>unistr('\6B64\9801\9762\8CC7\6599\6B04\95DC\806F\9805\76EE\7684\7236\9805\9801\9762')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--simple'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_1'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * from wwv_flow_model_pages ',
'where id = nvl(replace(:P47_PARENT_PAGE_ID,''%''||''null%'',0),0)',
'and page_type = ''REPORT'''))
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(13331127381478411.4407)
,p_name=>'&P47_COL_REGION_HEADING.'
,p_template=>wwv_flow_api.id(717561032869505733.4407)
,p_display_sequence=>35
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--simple'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_new_grid_row=>false
,p_display_column=>1
,p_display_point=>'BODY_1'
,p_source_type=>'NATIVE_TABFORM'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'"ID",',
'"ID" ID_DISPLAY,',
'"MODEL_REGION_ID",',
'"COLUMN_NAME",',
'"COLUMN_DISPLAY_NAME",',
'"DISPLAY_AS_FORM",',
'"DISPLAY_AS_TAB_FORM",',
'"DATATYPE",',
'"ALIGNMENT",',
'"FORMAT_MASK",',
'"HIDDEN_COLUMN",',
'"SORT_SEQUENCE",',
'"DISPLAY_WIDTH",',
'"MAX_WIDTH",',
'"HEIGHT",',
'"HELP_TEXT",',
'"SECURITY_GROUP_ID"',
'from "#OWNER#"."WWV_FLOW_MODEL_PAGE_COLS"',
'where model_region_id = :P47_REGION_ID',
'and column_name not like ''LINK$%'''))
,p_display_when_condition=>'P47_PAGE_TYPE'
,p_display_when_cond2=>'BLANK'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_translate_title=>'N'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(717629762332532068.4407)
,p_query_num_rows=>100000
,p_query_show_nulls_as=>'(null)'
,p_query_no_data_found=>unistr('\5831\8868\672A\50B3\56DE\4EFB\4F55\8CC7\6599\5217.')
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332020089478425.4407)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_display_as=>'HIDDEN'
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_pk_col_source_type=>'T'
,p_lov_display_extra=>'YES'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'ID'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13331304168478418.4407)
,p_query_column_id=>2
,p_column_alias=>'ID_DISPLAY'
,p_column_display_sequence=>3
,p_column_heading=>'Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_column_width=>16
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'ID_DISPLAY'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(145691929313567095.4407)
,p_query_column_id=>3
,p_column_alias=>'MODEL_REGION_ID'
,p_column_display_sequence=>17
,p_column_heading=>'ID'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13331510923478424.4407)
,p_query_column_id=>4
,p_column_alias=>'COLUMN_NAME'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\540D\7A31')
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_column_width=>16
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'COLUMN_NAME'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13331604705478424.4407)
,p_query_column_id=>5
,p_column_alias=>'COLUMN_DISPLAY_NAME'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\6A19\984C / \6A19\7C64')
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT'
,p_lov_show_nulls=>'NO'
,p_column_width=>12
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13331711542478424.4407)
,p_query_column_id=>6
,p_column_alias=>'DISPLAY_AS_FORM'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\986F\793A\985E\578B')
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(29578107222858066)
,p_lov_show_nulls=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\9805\76EE\985E\578B -')
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13331803099478424.4407)
,p_query_column_id=>7
,p_column_alias=>'DISPLAY_AS_TAB_FORM'
,p_column_display_sequence=>8
,p_column_heading=>unistr('\986F\793A\985E\578B')
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'TABULARFORM'
,p_display_as=>'TEXT_FROM_LOV_ESC'
,p_named_lov=>wwv_flow_api.id(6763505062658374)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13331908097478424.4407)
,p_query_column_id=>8
,p_column_alias=>'DATATYPE'
,p_column_display_sequence=>9
,p_column_heading=>unistr('\8CC7\6599\985E\578B')
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'YES'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'DATATYPE'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332109663478425.4407)
,p_query_column_id=>9
,p_column_alias=>'ALIGNMENT'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\5C0D\9F4A\65B9\5F0F')
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'REPORT:TABULARFORM'
,p_display_as=>'SELECT_LIST_FROM_LOV'
,p_named_lov=>wwv_flow_api.id(6767129339658379)
,p_lov_show_nulls=>'NO'
,p_column_width=>16
,p_lov_display_extra=>'YES'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'ALIGNMENT'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332208162478425.4407)
,p_query_column_id=>10
,p_column_alias=>'FORMAT_MASK'
,p_column_display_sequence=>10
,p_column_heading=>unistr('\683C\5F0F\906E\7F69')
,p_heading_alignment=>'LEFT'
,p_display_as=>'TEXT'
,p_named_lov=>wwv_flow_api.id(6766305855658377)
,p_lov_show_nulls=>'NO'
,p_column_width=>8
,p_lov_display_extra=>'YES'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'FORMAT_MASK'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332331719478425.4407)
,p_query_column_id=>11
,p_column_alias=>'HIDDEN_COLUMN'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\986F\793A')
,p_display_when_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'REPORT:TABULARFORM'
,p_display_as=>'SELECT_LIST_FROM_LOV'
,p_named_lov=>wwv_flow_api.id(6766513696658378)
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'NO'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332424568478425.4407)
,p_query_column_id=>12
,p_column_alias=>'SORT_SEQUENCE'
,p_column_display_sequence=>11
,p_column_heading=>unistr('\6392\5E8F\9806\5E8F')
,p_heading_alignment=>'LEFT'
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'REPORT'
,p_display_as=>'SELECT_LIST_FROM_QUERY'
,p_inline_lov=>'select i d, i r from wwv_flow_dual100 where i<=3'
,p_lov_show_nulls=>'YES'
,p_lov_null_text=>' - '
,p_lov_null_value=>'0'
,p_column_width=>4
,p_lov_display_extra=>'NO'
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'SORT_SEQUENCE'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332530823478426.4407)
,p_query_column_id=>13
,p_column_alias=>'DISPLAY_WIDTH'
,p_column_display_sequence=>13
,p_column_heading=>unistr('\9805\76EE\5BEC\5EA6')
,p_display_when_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM:TABULARFORM'
,p_display_as=>'TEXT'
,p_lov_show_nulls=>'NO'
,p_column_width=>3
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332601367478426.4407)
,p_query_column_id=>14
,p_column_alias=>'MAX_WIDTH'
,p_column_display_sequence=>14
,p_column_heading=>unistr('\5BEC\5EA6\4E0A\9650')
,p_display_when_cond_type=>'NEVER'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'TEXT'
,p_lov_show_nulls=>'NO'
,p_column_width=>3
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332720837478426.4407)
,p_query_column_id=>15
,p_column_alias=>'HEIGHT'
,p_column_display_sequence=>15
,p_column_heading=>unistr('\9AD8\5EA6')
,p_display_when_cond_type=>'NEVER'
,p_display_when_condition=>'P483_PAGE_TYPE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'TEXT'
,p_lov_show_nulls=>'NO'
,p_column_width=>3
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332805459478426.4407)
,p_query_column_id=>16
,p_column_alias=>'HELP_TEXT'
,p_column_display_sequence=>16
,p_column_heading=>'Help Text'
,p_hidden_column=>'Y'
,p_display_when_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_when_condition=>'P483_PAGE_SOURCE'
,p_display_when_condition2=>'FORM'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(13332900365478426.4407)
,p_query_column_id=>17
,p_column_alias=>'SECURITY_GROUP_ID'
,p_column_display_sequence=>12
,p_column_heading=>'Security Group Id'
,p_heading_alignment=>'LEFT'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_column_width=>16
,p_ref_schema=>'FLOWS_030000'
,p_ref_table_name=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_ref_column_name=>'SECURITY_GROUP_ID'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729126301034212.4407)
,p_column_sequence=>1
,p_query_column_name=>'ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729222233034214.4407)
,p_column_sequence=>2
,p_query_column_name=>'ID_DISPLAY'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(145690410241567093.4407)
,p_column_sequence=>3
,p_query_column_name=>'MODEL_REGION_ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729404648034214.4407)
,p_column_sequence=>4
,p_query_column_name=>'COLUMN_NAME'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729516740034214.4407)
,p_column_sequence=>5
,p_query_column_name=>'COLUMN_DISPLAY_NAME'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729604747034214.4407)
,p_column_sequence=>6
,p_query_column_name=>'DISPLAY_AS_FORM'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729715124034214.4407)
,p_column_sequence=>7
,p_query_column_name=>'DISPLAY_AS_TAB_FORM'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729827450034214.4407)
,p_column_sequence=>8
,p_query_column_name=>'DATATYPE'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27729931577034214.4407)
,p_column_sequence=>9
,p_query_column_name=>'ALIGNMENT'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730024480034214.4407)
,p_column_sequence=>10
,p_query_column_name=>'FORMAT_MASK'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730113269034214.4407)
,p_column_sequence=>11
,p_query_column_name=>'HIDDEN_COLUMN'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730231669034214.4407)
,p_column_sequence=>12
,p_query_column_name=>'SORT_SEQUENCE'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730300311034214.4407)
,p_column_sequence=>13
,p_query_column_name=>'DISPLAY_WIDTH'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730419993034214.4407)
,p_column_sequence=>14
,p_query_column_name=>'MAX_WIDTH'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730528093034215.4407)
,p_column_sequence=>15
,p_query_column_name=>'HEIGHT'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730628930034215.4407)
,p_column_sequence=>16
,p_query_column_name=>'HELP_TEXT'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_region_rpt_cols(
 p_id=>wwv_flow_api.id(27730711220034215.4407)
,p_column_sequence=>17
,p_query_column_name=>'SECURITY_GROUP_ID'
,p_display_as=>'TEXT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(13333025835478426.4407)
,p_plug_name=>'Button Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23374331038819917.4407)
,p_plug_name=>unistr('\5C0E\89BD')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--simple'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>45
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_1'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_column_width=>'class="fielddatasmall"'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P47_PAGE_TYPE'
,p_plug_display_when_cond2=>'BLANK'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(755294479589836810.4407)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(13333025835478426.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(13333400093478437.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(13333025835478426.4407)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_condition=>'P47_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(25975206985465785.4407)
,p_branch_action=>'f?p=&APP_ID.:47:&SESSION.::&DEBUG.::P47_PARENT_PAGE_ID,P47_PAGE_NAME,P47_IMPLEMENTATION:&P47_PARENT_PAGE_ID.,&P47_PAGE_NAME.,&P47_IMPLEMENTATION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'P47_PARENT_PAGE_ID'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13333600007478439.4407)
,p_name=>'P47_PAGE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762:')
,p_source=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\552F\4E00\7684\9801\78BC.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13334124341478470.4407)
,p_name=>'P47_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13334325657478470.4407)
,p_name=>'P47_PAGE_TYPE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\985E\578B:')
,p_source=>'PAGE_TYPE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'APP WIZARD PAGE TYPE'
,p_lov=>'.'||wwv_flow_api.id(6745605530658343.4407)||'.'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
unistr('<li><b>\7A7A\767D</b/>: \5EFA\7ACB\4E0D\542B\5167\5EFA\529F\80FD\7684\9801\9762.</li>'),
unistr('<li><b>\5831\8868</b/>: \5EFA\7ACB\5167\542B SQL \67E5\8A62\683C\5F0F\5316\7D50\679C\7684\9801\9762. \60A8\53EF\4EE5\9078\64C7\5EFA\7ACB\4EE5\6240\9078\8868\683C\70BA\57FA\790E\7684\5831\8868, \6216\8005\4EE5\60A8\63D0\4F9B\7684\81EA\8A02 SQL SELECT \6558\8FF0\53E5\6216 PL/SQL \51FD\6578 (\50B3\56DE SQL SELECT \6558\8FF0\53E5) \70BA\57FA\790E\7684\5831\8868.</li>'),
unistr('<li><b>\8868\55AE</b/>: \5EFA\7ACB\8868\55AE\4F86\66F4\65B0\8CC7\6599\5EAB\8868\683C\4E2D\7684\55AE\4E00\8CC7\6599\5217.</li>'),
unistr('<li><b>\5217\8868\5316\8868\55AE</b/>: \5EFA\7ACB\4E00\500B\5728\8CC7\6599\5EAB\8868\683C\4E2D\7684\591A\500B\8CC7\6599\5217\57F7\884C\66F4\65B0, \63D2\5165\53CA\522A\9664\4F5C\696D\7684\8868\55AE.</li>'),
unistr('<li><b>\5831\8868\548C\8868\55AE</b/>: \5EFA\7ACB\5169\9801\7684\5831\8868\548C\8868\55AE\7D44\5408. \5728\7B2C\4E00\9801\4E2D, \4F7F\7528\8005\53EF\4EE5\9078\53D6\8981\66F4\65B0\7684\8CC7\6599\5217. \5728\7B2C\4E8C\9801\4E2D, \4F7F\7528\8005\53EF\4EE5\66F4\65B0\9078\53D6\7684\8868\683C\6216\8996\89C0\8868.</li>'),
'</ul>',
'',
''))
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13334808983478471.4407)
,p_name=>'P47_PARENT_PAGE_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\7236\9805\9801\9762')
,p_source=>'PARENT_PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(page_name)||'' (''||page_id||'')'' p, id r',
'from WWV_FLOW_MODEL_PAGES ',
'where model_id = :MW_MODEL_ID and id != :P47_ID',
'order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \6C92\6709\7236\9805 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\9801\9762\53EF\4EE5\662F\5176\4ED6\9801\9762\7684\5F9E\5C6C\9801\9762. \60A8\53EF\4EE5\4F7F\7528\9801\7C64, \5C0E\89BD\6E05\55AE\6216\8CC7\6599\6B04\9023\7D50\8A2D\5B9A\5F9E\7236\9805\9801\9762\5230\5B50\9805\9801\9762\7684\79FB\52D5. \5982\679C\9078\53D6\4E00\6216\5169\500B\5C64\6B21\7684\9801\7C64, \5373\53EF\4F7F\7528\9801\7C64\5B58\53D6\6700\4E0A\5C64\9801\9762. \81F3\65BC\8F03\4F4E\5C64\6B21\7684\9801\9762, \53EF\4EE5\4F7F\7528\7236\9805\5831\8868\9801\9762\7684\8CC7\6599\6B04\9023\7D50\6216\4F7F\7528\5C0E\89BD\6E05\55AE (\82E5\672A\5B9A\7FA9\9023\7D50) \5B58\53D6. \5982\679C\9078\53D6\5169\500B\5C64\6B21\7684\9801\7C64, \4E5F\53EF\4EE5\4F7F\7528\7B2C\4E8C\5C64\7684\9801\7C64\5B58\53D6\7B2C\4E8C\5C64\7684\9801\9762.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13335326501478473.4407)
,p_name=>'P47_PARENT_LINK_FROM_COLUMN1'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8CC7\6599\6B04 1')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select PARENT_LINK_FROM_COLUMN1 from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P47_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PARENT_PAGE_COLUMNS P47'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'  select id from wwv_flow_model_page_regions',
'  where model_page_id = (   ',
'         select id ',
'         from   wwv_flow_model_pages ',
'         where  model_id = :MW_MODEL_ID',
'         and    id  = :P47_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 - ')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\503C\64F7\53D6\800C\5F97. \8CC7\6599\6B04 1 \6B04\4F4D\4E2D\986F\793A\7684\662F\884D\751F\7B2C\4E00\500B\4E3B\7D22\5F15\9375\503C\7684\5831\8868\8CC7\6599\6B04.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13335815188478474.4407)
,p_name=>'P47_PARENT_LINK_FROM_COLUMN2'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8CC7\6599\6B04 2')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select PARENT_LINK_FROM_COLUMN2 from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P47_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PARENT_PAGE_COLUMNS P47'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'  select id from wwv_flow_model_page_regions',
'  where model_page_id = (   ',
'         select id ',
'         from   wwv_flow_model_pages ',
'         where  model_id = :MW_MODEL_ID',
'         and    id  = :P47_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\503C\64F7\53D6\800C\5F97. \8CC7\6599\6B04 2 \6B04\4F4D\4E2D\986F\793A\7684\662F\884D\751F\7B2C\4E8C\500B\4E3B\7D22\5F15\9375\503C\7684\5831\8868\8CC7\6599\6B04.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13336322212478474.4407)
,p_name=>'P47_LINK_TO_COLUMN1'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'&P47_PAGE_ITEM_LABEL.'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_TO_COLUMN1 from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P47_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PAGE_COLUMNS P47'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols',
'where  model_region_id = :P47_REGION_ID'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 - ')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\64F7\53D6\800C\5F97. \9801\9762\9805\76EE\6B04\4F4D\4E2D\986F\793A\7684\662F\5C07\6703\4F7F\7528\8CC7\6599\6B04\9023\7D50\63D0\4F9B\7684\503C\8D77\59CB\7684\4E3B\7D22\5F15\9375\9805\76EE.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13336814549478475.4407)
,p_name=>'P47_LINK_TO_COLUMN2'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'&P47_PAGE_ITEM_LABEL.'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_TO_COLUMN2 from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P47_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PAGE_COLUMNS P47'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols',
'where  model_region_id = :P47_REGION_ID'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\5831\8868\548C\8868\55AE\662F\4F7F\7528\5831\8868\9801\9762\4E2D\7684\8CC7\6599\6B04\9023\7D50\800C\9023\7D50\5728\4E00\8D77. \7576\4F7F\7528\8005\9EDE\9078\9023\7D50\6642, \4FBF\6703\524D\5F80\8868\55AE\9801\9762. \8868\55AE\9801\9762\4E2D\7684\8CC7\6599\5247\662F\4F7F\7528\9023\7D50\6240\63D0\4F9B\7684\4E3B\7D22\5F15\9375\64F7\53D6\800C\5F97. \9801\9762\9805\76EE\6B04\4F4D\4E2D\986F\793A\7684\662F\5C07\6703\4F7F\7528\8CC7\6599\6B04\9023\7D50\63D0\4F9B\7684\503C\8D77\59CB\7684\4E3B\7D22\5F15\9375\9805\76EE.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13337300780478476.4407)
,p_name=>'P47_PAGE_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\540D\7A31')
,p_source=>'PAGE_NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_tag_attributes=>'onChange="setPageName(this.id);"'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\60A8\61C9\7528\7A0B\5F0F\4E2D\9801\9762\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13337811348478479.4407)
,p_name=>'P47_SOURCE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\4F86\6E90\67E5\8A62:')
,p_source=>'select ''<pre>''||source||''</pre>'' from wwv_flow_model_pages where id = :P47_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P47_PAGE_SOURCE'
,p_display_when2=>'QUERY'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\65B0\9801\9762\7684\4F86\6E90. \5831\8868\53EF\4EE5\8868\683C\548C\67E5\8A62\4F5C\70BA\5176\57FA\790E. \8868\55AE\548C\5217\8868\5316\8868\55AE\5247\53EA\80FD\4EE5\8868\683C\4F5C\70BA\5176\57FA\790E.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13338302290478480.4407)
,p_name=>'P47_DISPLAY_SEQUENCE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9806\5E8F')
,p_source=>'DISPLAY_SEQUENCE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>5
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\8F38\5165\9801\9762\986F\793A\9806\5E8F')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13338832216478481.4407)
,p_name=>'P47_PAGE_SOURCE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\4F86\6E90:')
,p_source=>'PAGE_SOURCE'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'PAGE_SOURCE'
,p_lov=>'.'||wwv_flow_api.id(6744724810658339.4407)||'.'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\6307\5B9A\9801\9762\4F86\6E90. \5831\8868\53EF\4EE5\8868\683C\548C\67E5\8A62\4F5C\70BA\5176\57FA\790E. \8868\55AE\548C\5217\8868\5316\8868\55AE\5247\53EA\80FD\4EE5\8868\683C\4F5C\70BA\5176\57FA\790E.')
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13339302995478482.4407)
,p_name=>'P47_SOURCE_TABLE'
,p_item_sequence=>65
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\4F86\6E90\8868\683C:')
,p_source=>'select source from wwv_flow_model_pages where id = :P47_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_display_when=>'P47_PAGE_SOURCE'
,p_display_when2=>'TABLE'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'I'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\9801\9762\4F86\6E90. \5831\8868\53EF\4EE5\8868\683C\548C\67E5\8A62\4F5C\70BA\5176\57FA\790E. \8868\55AE\548C\5217\8868\5316\8868\55AE\5247\53EA\80FD\4EE5\8868\683C\4F5C\70BA\5176\57FA\790E.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13339817026478482.4407)
,p_name=>'P47_COL_REGION_HEADING'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P47_PAGE_TYPE in (''REPORT'',''TABULARFORM'') then',
'   return wwv_flow_lang.system_message(''REPORT COLUMNS'');',
'elsif :P47_PAGE_TYPE = ''FORM'' then',
'   return wwv_flow_lang.system_message(''PAGE ITEMS'');',
'end if;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13340012947478484.4407)
,p_name=>'P47_LINK_COLUMN'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_prompt=>unistr('\9023\7D50\8CC7\6599\6B04')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_COLUMN from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P47_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'MODEL_PARENT_PAGE_COLUMNS P47'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(column_name) d, column_name r',
'from   wwv_flow_model_page_cols  s',
'where  model_region_id in (',
'  select id from wwv_flow_model_page_regions',
'  where model_page_id = (   ',
'         select id ',
'         from   wwv_flow_model_pages ',
'         where  model_id = :MW_MODEL_ID',
'         and    id  = :P47_PARENT_PAGE_ID',
'))',
'and column_name not like ''LINK$%'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\9023\7D50\8CC7\6599\6B04 -')
,p_lov_null_value=>'LINK$'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\6307\5B9A\8981\7528\4F86\986F\793A\8CC7\6599\6B04\9023\7D50\7684\8CC7\6599\6B04. ')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13340518774478484.4407)
,p_name=>'P47_LINK_TEXT'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_prompt=>unistr('\9023\7D50\6587\5B57')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LINK_TEXT from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P47_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\8981\4EE5\9023\7D50\65B9\5F0F\986F\793A\7684 HTML \6587\5B57. \8ACB\4F7F\7528\5F71\50CF\6A19\8A18\4F86\986F\793A\5F71\50CF.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13341014194478485.4407)
,p_name=>'P47_REPORT_COLUMN_LABEL'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_source=>'wwv_flow_lang.system_message(''REPORT_COLUMN'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13341226332478485.4407)
,p_name=>'P47_PAGE_ITEM_LABEL'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P47_PAGE_TYPE in (''REPORT'',''TABULARFORM'') then',
'   return wwv_flow_lang.system_message(''REPORT_COLUMN'');',
'elsif :P47_PAGE_TYPE = ''FORM'' then',
'   return wwv_flow_lang.system_message(''PAGE_ITEM'');',
'end if;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_HIDDEN'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13341427696478486.4407)
,p_name=>'P47_PARENT_REPORT_COLUM_HEADING'
,p_item_sequence=>212
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_source=>'wwv_flow_lang.system_message(''PARENT_REPORT_COLUMN'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13341632200478489.4407)
,p_name=>'P47_REPORT_COLUMN_HEADING'
,p_item_sequence=>214
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_source=>'wwv_flow_lang.system_message(''LINK_TO_THIS_PAGE_ITEM'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13341822908478489.4407)
,p_name=>'P47_USE_THEME_BUTTON'
,p_item_sequence=>211
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_item_default=>'THEME'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'MODEL_USE_THEME_BUTTON'
,p_lov=>'.'||wwv_flow_api.id(6747416812658349.4407)||'.'
,p_tag_attributes=>' onClick="modelDisableItem2(document.getElementById(''P47_LINK_TEXT''), this,'''');"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(13342018207478491.4407)
,p_name=>'P47_USE_LINK_COLUMN'
,p_item_sequence=>205
,p_item_plug_id=>wwv_flow_api.id(13330905566478410.4407)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''LINK_COLUMN'' from wwv_flow_model_page_cols',
'where model_region_id = nvl(replace(:P47_REGION_ID,''%''||''null%'',0),0)',
'and column_name like ''LINK$%'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'MODEL_LINK_EXTRA_COLUMN'
,p_lov=>'.'||wwv_flow_api.id(6746916502658348.4407)||'.'
,p_tag_attributes=>'onClick="modelDisableItem(document.getElementById(''P47_LINK_COLUMN''), this,''LINK$'');"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(23374620800819995.4407)
,p_name=>'P47_NAVIGATION'
,p_item_sequence=>290
,p_item_plug_id=>wwv_flow_api.id(23374331038819917.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Vertical Unordered List with Bullets'
,p_prompt=>unistr('\9078\53D6\5C0E\89BD\6A23\5F0F:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(LIST_TEMPLATE_NAME,''Vertical Unordered List with Bullets'')',
'from   wwv_mig_rev_apexapp',
'where  project_id = :MW_PROJ_ID',
'and    page_id = :P47_PAGE_ID',
'and    security_group_id = :flow_security_group_id',
'and    flow_id = :MW_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HOME PAGE NAVIGATION'
,p_lov=>'.'||wwv_flow_api.id(22899924972899541.4407)||'.'
,p_cHeight=>1
,p_tag_attributes2=>'class="instructiontext"'
,p_colspan=>6
,p_display_when=>'MW_MIG_TYPE'
,p_display_when2=>'access'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li><b>\542B\9805\76EE\7B26\865F\7684\5782\76F4\6E05\55AE (\672A\6392\5217)</b>: \4EE5\542B\9805\76EE\7B26\865F\7684\5782\76F4\6587\5B57\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('<li><b>\5782\76F4\5F71\50CF\6E05\55AE</b>: \4EE5\5782\76F4\7684\5F71\50CF\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('<li><b>\6C34\5E73\5F71\50CF\6E05\55AE</b>: \4EE5\6C34\5E73\7684\5F71\50CF\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('\9810\8A2D\9078\9805\70BA\300C\542B\9805\76EE\7B26\865F\7684\5782\76F4\6E05\55AE (\672A\6392\5217)\300D.  \6B64\6E05\55AE\6703\986F\793A\5728\7236\9805\9801\9762\7684\5C0E\89BD\5340\57DF.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25483508426707109.4407)
,p_name=>'P47_PAGE_ICON'
,p_item_sequence=>300
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_prompt=>unistr('\9801\9762\5716\793A')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LIST_ITEM_ICON',
'from wwv_mig_rev_apexapp',
'where page_id = :P47_PAGE_ID',
'and project_id = :MW_PROJ_ID',
'and security_group_id = :flow_security_group_id',
'-- and dbid = :P2_DBID',
'and flow_id = :MW_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'PAGE_ICONS_2'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select icon_name d, icon_name r',
'from WWV_FLOW_STANDARD_ICONS',
'order by 1'))
,p_cSize=>30
,p_cHeight=>1
,p_tag_attributes=>'onchange="htmldb_item_change(this);"'
,p_display_when=>':MW_MIG_TYPE <> ''forms'' and :P47_PAGE_TYPE <> ''BLANK'''
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\5F9E\7522\751F\7684 Oracle &PRODUCT_NAME. \61C9\7528\7A0B\5F0F\5167\9078\53D6\4E00\500B\8981\8207\6B64\9801\9762\7522\751F\95DC\806F\7684\9801\9762\5716\793A.  \8ACB\4F7F\7528\624B\96FB\7B52\5716\793A\4F86\67E5\770B\5716\793A\9078\9805\53CA\9078\53D6\5716\793A.')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27702628744836182.4407)
,p_name=>'P47_SELECTED_ICON'
,p_item_sequence=>330
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_post_element_text=>'<img src="#IMAGE_PREFIX#menu/&P47_PAGE_ICON." width="64" height="64" border="1" bordercolor="black" alt="&P47_PAGE_ICON.">'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'PAGE_ICONS_2'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select icon_name d, icon_name r',
'from WWV_FLOW_STANDARD_ICONS',
'order by 1'))
,p_cSize=>30
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_display_when=>'(:P47_PAGE_TYPE <> ''BLANK'' and :MW_MIG_TYPE <> ''forms'')'
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(115196810027372830.4407)
,p_name=>'P47_PAGE_ICON_SIZE'
,p_item_sequence=>350
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'64'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select icon_size',
'from wwv_flow_standard_icons',
'where icon_name = :P47_SELECTED_ICON'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(145676828932530484.4407)
,p_name=>'P47_REGION_ID'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ID from WWV_FLOW_MODEL_PAGE_REGIONS',
'where model_page_id = :P47_ID',
'and region_id = 1'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(148624710346493468.4407)
,p_name=>'P47_IMPLEMENTATION'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'INTERACTIVE'
,p_prompt=>unistr('\5BE6\884C')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select REPORT_IMPLEMENTATION ',
'from WWV_FLOW_MODEL_PAGE_REGIONS',
'where MODEL_PAGE_ID = :P47_ID',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'REPORT TYPE: INTERACTIVE OR CLASSIC'
,p_lov=>'.'||wwv_flow_api.id(148634518096505157.4407)||'.'
,p_cHeight=>1
,p_display_when=>'P47_PAGE_TYPE'
,p_display_when2=>'REPORT'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(276046226685623476.4407)
,p_name=>'P47_NAVIGATION_FORMS'
,p_item_sequence=>330
,p_item_plug_id=>wwv_flow_api.id(23374331038819917.4407)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Horizontal Images with Label List'
,p_prompt=>unistr('\9078\53D6\5C0E\89BD\6A23\5F0F:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(LIST_TEMPLATE_NAME,''Horizontal Images with Label List'')',
'from   wwv_mig_frm_rev_apex_app',
'where  project_id = :MW_PROJ_ID',
'and    page_id = :P47_PAGE_ID',
'and    security_group_id = :flow_security_group_id',
'and    flow_id = :MW_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'HOME PAGE NAVIGATION'
,p_lov=>'.'||wwv_flow_api.id(22899924972899541.4407)||'.'
,p_cHeight=>1
,p_tag_attributes2=>'class="instructiontext"'
,p_display_when=>'MW_MIG_TYPE'
,p_display_when2=>'forms'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li><b>\542B\9805\76EE\7B26\865F\7684\5782\76F4\6E05\55AE (\672A\6392\5217)</b>: \4EE5\542B\9805\76EE\7B26\865F\7684\5782\76F4\6587\5B57\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('<li><b>\5782\76F4\5F71\50CF\6E05\55AE</b>: \4EE5\5782\76F4\7684\5F71\50CF\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('<li><b>\6C34\5E73\5F71\50CF\6E05\55AE</b>: \4EE5\6C34\5E73\7684\5F71\50CF\6E05\55AE\65B9\5F0F\986F\793A\9078\53D6\7684\9801\9762.</li>'),
'<br>',
unistr('\9810\8A2D\9078\9805\70BA\300C\542B\9805\76EE\7B26\865F\7684\5782\76F4\6E05\55AE (\672A\6392\5217)\300D.  \6B64\6E05\55AE\6703\986F\793A\5728\7236\9805\9801\9762\7684\5C0E\89BD\5340\57DF.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(276053605046655111.4407)
,p_name=>'P47_PAGE_ICON_FORMS'
,p_item_sequence=>320
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_item_default=>'interactive_report_bx_128x128.png'
,p_prompt=>unistr('\9801\9762\5716\793A')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LIST_ITEM_ICON',
'from wwv_mig_frm_rev_apex_app',
'where page_id = :P47_PAGE_ID',
'and project_id = :MW_PROJ_ID',
'and security_group_id = :flow_security_group_id',
'and flow_id = :MW_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'PAGE_ICONS_2'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select icon_name d, icon_name r',
'from WWV_FLOW_STANDARD_ICONS',
'order by 1'))
,p_cSize=>30
,p_cHeight=>1
,p_tag_attributes=>'onchange="htmldb_item_change(this);"'
,p_display_when=>':MW_MIG_TYPE <> ''access'''
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\5F9E\7522\751F\7684 Oracle &PRODUCT_NAME. \61C9\7528\7A0B\5F0F\5167\9078\53D6\4E00\500B\8981\8207\6B64\9801\9762\7522\751F\95DC\806F\7684\9801\9762\5716\793A.  \8ACB\4F7F\7528\624B\96FB\7B52\5716\793A\4F86\67E5\770B\5716\793A\9078\9805\53CA\9078\53D6\5716\793A.')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(276067218832829387.4407)
,p_name=>'P47_SELECTED_ICON_FORMS'
,p_item_sequence=>340
,p_item_plug_id=>wwv_flow_api.id(13330721654478373.4407)
,p_use_cache_before_default=>'NO'
,p_post_element_text=>'<img src="#IMAGE_PREFIX#menu/&P47_PAGE_ICON_FORMS." width="128" height="128" border="1" bordercolor="black" alt="&P47_PAGE_ICON_FORMS.">'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'PAGE_ICONS_2'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select icon_name d, icon_name r',
'from WWV_FLOW_STANDARD_ICONS',
'order by 1'))
,p_cSize=>30
,p_cHeight=>1
,p_display_when=>':MW_MIG_TYPE <> ''access'''
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(13342315527478494.4407)
,p_computation_sequence=>10
,p_computation_item=>'P47_LINK_COLUMN'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'LINK$01'
,p_compute_when=>'P47_USE_LINK_COLUMN'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(28035714067240377.4407)
,p_computation_sequence=>20
,p_computation_item=>'P47_PAGE_ICON'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LIST_ITEM_ICON',
'from wwv_mig_rev_apexapp',
'where page_id = :P47_PAGE_ID',
'and project_id = :MW_PROJ_ID',
'and security_group_id = :flow_security_group_id',
'and dbid = :P2_DBID',
'and flow_id = :P31_APPLICATION_ID'))
,p_compute_when=>'BEFORE'
,p_compute_when_type=>'NEVER'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(74561218939780662.4407)
,p_computation_sequence=>30
,p_computation_item=>'P47_PAGE_ICON_FORMS'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select LIST_ITEM_ICON',
'from wwv_mig_frm_rev_apex_app',
'where page_id = :P47_PAGE_ID',
'and project_id = :MW_PROJ_ID',
'and security_group_id = :flow_security_group_id',
'and flow_id = :MW_APPLICATION_ID'))
,p_compute_when=>':MW_PROJ_TYPE = ''forms'''
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(13342513257478500.4407)
,p_validation_name=>'P47_PAGE_NAME'
,p_validation_sequence=>10
,p_validation=>'P47_PAGE_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\9801\9762\540D\7A31.')
,p_when_button_pressed=>wwv_flow_api.id(13333400093478437.4407)
,p_associated_item=>wwv_flow_api.id(13337300780478476.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(25586023625809101.4407)
,p_validation_name=>'displaying icon option'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P47_PAGE_TYPE <> ''BLANK'' then',
'  return true;',
'else',
'  return false;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\986F\793A\5716\793A\9078\64C7\9078\9805')
,p_validation_condition_type=>'NEVER'
,p_associated_item=>wwv_flow_api.id(25483508426707109.4407)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(755294562801836811.4407)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(755294479589836810.4407)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(755294666170836812.4407)
,p_event_id=>wwv_flow_api.id(755294562801836811.4407)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1142729444770397034.4407)
,p_name=>'Update Selected Icon'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P47_PAGE_ICON'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1142729539375397035.4407)
,p_event_id=>wwv_flow_api.id(1142729444770397034.4407)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1158721139478023784.4407)
,p_name=>'Update Selected Icon - Forms'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P47_PAGE_ICON_FORMS'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1158721403639023818.4407)
,p_event_id=>wwv_flow_api.id(1158721139478023784.4407)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13342601710478511.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_MODEL_PAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_MODEL_PAGES'
,p_attribute_03=>'P47_ID'
,p_attribute_04=>'ID'
,p_attribute_14=>'N'
,p_process_error_message=>unistr('\7121\6CD5\64F7\53D6\8CC7\6599\5217.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13343419449478524.4407)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_api.id(13331127381478411.4407)
,p_process_type=>'NATIVE_TABFORM_UPDATE'
,p_process_name=>'ApplyMRU'
,p_attribute_02=>'WWV_FLOW_MODEL_PAGE_COLS'
,p_attribute_03=>'ID'
,p_process_error_message=>unistr('\7121\6CD5\8655\7406\66F4\65B0.')
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_success_message=>unistr('\5DF2\66F4\65B0 #MRU_COUNT# \500B\8CC7\6599\5217, \5DF2\63D2\5165 #MRI_COUNT# \500B\8CC7\6599\5217.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(150169618317371848.4407)
,p_process_sequence=>15
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update wwv_flow_model_page_regions'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'    update ',
'        WWV_FLOW_MODEL_PAGE_REGIONS',
'    set ',
'        LINK_COLUMN = :P47_LINK_COLUMN,',
'        LINK_TEXT = :P47_LINK_TEXT,',
'        PARENT_LINK_FROM_COLUMN1 = :P47_PARENT_LINK_FROM_COLUMN1,',
'        LINK_TO_COLUMN1 = :P47_LINK_TO_COLUMN1',
'    where ',
'        MODEL_PAGE_ID = :P47_ID',
'    and ',
'        SECURITY_GROUP_ID = :flow_security_group_id;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_when=>'P47_PARENT_PAGE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(150170604942377470.4407)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Column2 link information'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'update WWV_FLOW_MODEL_PAGE_REGIONS',
'    set PARENT_LINK_FROM_COLUMN2 = :P47_PARENT_LINK_FROM_COLUMN2,',
'    LINK_TO_COLUMN2 = :P47_LINK_TO_COLUMN2',
'    where MODEL_PAGE_ID = :P47_ID',
'    and SECURITY_GROUP_ID = :flow_security_group_id;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_when=>'(:P47_PARENT_LINK_FROM_COLUMN2 IS NOT NULL) and (:P47_LINK_TO_COLUMN2 IS NOT NULL) and (:P47_PARENT_PAGE_ID IS NOT NULL)'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13343617037478525.4407)
,p_process_sequence=>25
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_MODEL_PAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_MODEL_PAGES'
,p_attribute_03=>'P47_ID'
,p_attribute_04=>'ID'
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_process_error_message=>unistr('\7121\6CD5\8655\7406\8868\683C WWV_FLOW_MODEL_PAGES \7684\8CC7\6599\5217.')
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_success_message=>unistr('\52D5\4F5C\5DF2\8655\7406.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(23514400448053548.4407)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Page Navigation setting - Access'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'  update wwv_mig_rev_apexapp',
'  set list_template_name = :P47_NAVIGATION',
'  where page_id = :P47_PAGE_ID',
'  and flow_id = :MW_APPLICATION_ID',
'  and project_id = :MW_PROJ_ID',
'  and security_group_id = :flow_security_group_id',
'  and owner = :MW_SCHEMA;',
'',
'  if :P47_PAGE_TYPE = ''BLANK'' then',
'    update wwv_mig_rev_apexapp',
'    set list_item_icon = ''migration/mig_menu1.png''',
'    where page_id = :P47_PAGE_ID',
'    and flow_id = :MW_APPLICATION_ID',
'    and project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and owner = :MW_SCHEMA;',
'  else',
'    update wwv_mig_rev_apexapp',
'    set list_item_icon = :P47_PAGE_ICON',
'    where page_id = :P47_PAGE_ID',
'    and flow_id = :MW_APPLICATION_ID',
'    and project_id = :MW_PROJ_ID',
'    and security_group_id = :flow_security_group_id',
'    and owner = :MW_SCHEMA;',
'  end if;',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_when=>'MW_MIG_TYPE'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'access'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(275871505299248316.4407)
,p_process_sequence=>31
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Page Navigation setting - Forms'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'',
'  update wwv_mig_frm_rev_apex_app',
'  set    list_template_name = :P47_NAVIGATION_FORMS',
'  where  page_id = :P47_PAGE_ID',
'  and    flow_id = :MW_APPLICATION_ID',
'  and    project_id = :MW_PROJ_ID',
'  and    security_group_id = :flow_security_group_id',
'  and    owner = :MW_SCHEMA;',
'',
'  update wwv_mig_frm_rev_apex_app',
'  set    list_item_icon = :P47_PAGE_ICON_FORMS',
'  where  page_id = :P47_PAGE_ID',
'  and    flow_id = :MW_APPLICATION_ID',
'  and    project_id = :MW_PROJ_ID',
'  and    security_group_id = :flow_security_group_id',
'  and    owner = :MW_SCHEMA;   ',
'',
'',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_when=>':MW_MIG_TYPE = ''forms'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(148640708100530606.4407)
,p_process_sequence=>35
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Report Implementation'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    update WWV_FLOW_MODEL_PAGE_REGIONS',
'    set REPORT_IMPLEMENTATION = :P47_IMPLEMENTATION',
'    where MODEL_PAGE_ID = :P47_ID',
'    and SECURITY_GROUP_ID = :flow_security_group_id;',
' end;'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_when=>'P47_PAGE_TYPE'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'REPORT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13343826376478526.4407)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add link column'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'insert into wwv_flow_model_page_cols (',
'   model_region_id,',
'   column_name,',
'   column_display_name,               ',
'   datatype,',
'   display_as_tab_form',
') values (',
'   :P47_REGION_ID,',
'   ''LINK$01'',',
'   ''&nbsp;'',',
'   ''VARCHAR2'',',
'   ''WITHOUT_MODIFICATION''',
');'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'   if :P47_USE_LINK_COLUMN is not null then',
'      for c1 in (',
'         select 1 from wwv_flow_model_page_cols',
'         where model_region_id = nvl(replace(:P47_REGION_ID,''%''||''null%'',0),0)',
'         and column_name like ''LINK$%''',
'      ) loop',
'         return false;',
'      end loop;',
'      return true;',
'   else',
'      return false;',
'   end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
end;
/
begin
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13342806158478523.4407)
,p_process_sequence=>45
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete link column'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'delete from wwv_flow_model_page_cols',
'where model_region_id = :P47_REGION_ID',
'and column_name like ''LINK$%'';'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'   if :P47_USE_LINK_COLUMN is null then',
'      for c1 in (',
'         select 1 from wwv_flow_model_page_cols',
'         where model_region_id = nvl(replace(:P47_REGION_ID,''%''||''null%'',0),0)',
'         and column_name like ''LINK$%''',
'   	  ) loop',
'	        return true;',
'   	  end loop;',
'	     return false;',
'   else',
'      return false;',
'   end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13343006880478523.4407)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'reset page'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'43,47'
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(13343218194478524.4407)
,p_process_sequence=>55
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reload base and close'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.prn(''<script  language="JavaScript">''||chr(10));',
'sys.htp.prn(''v_flowid = opener.document.getElementById(''''pFlowId'''').value;''||chr(10));',
'sys.htp.prn(''v_stepid = opener.document.getElementById(''''pFlowStepId'''').value;''||chr(10));',
'sys.htp.prn(''v_sessionid = opener.document.getElementById(''''pInstance'''').value;''||chr(10));',
'sys.htp.prn(''v_redirect = ''''f?p=''''+v_flowid+'''':''''+v_stepid+'''':''''+v_sessionid;''||chr(10));',
'sys.htp.prn(''window.opener.window.location=v_redirect;''||chr(10));',
'sys.htp.prn(''window.close();'');',
'sys.htp.prn(''</script>''||chr(10));'))
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(615906589321044496.4407)
,p_process_sequence=>65
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(13333400093478437.4407)
);
end;
/
prompt --application/pages/page_00049
begin
wwv_flow_api.create_page(
 p_id=>49.4407
,p_user_interface_id=>wwv_flow_api.id(4969928362302343.4407)
,p_name=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\9810\8A2D\503C')
,p_step_title=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\9810\8A2D\503C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(280687701592255307)
,p_css_file_urls=>'#IMAGE_PREFIX#css/apex_ui_themes.css'
,p_step_template=>wwv_flow_api.id(717527796284479857.4407)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEMIG/apm_howgenapp.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19533524129904461.4407)
,p_plug_name=>unistr('\4E3B\984C')
,p_region_name=>'THEME'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19533714252904461.4407)
,p_plug_name=>unistr('\8A2D\5B9A\503C')
,p_region_name=>'TABS'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19534118551904461.4407)
,p_plug_name=>unistr('\5168\7403\5316')
,p_region_name=>'G'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19534312911904462.4407)
,p_plug_name=>'Run Application'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'wwv_flow_region_layout.show_apex_home_pg_elink (',
'    p_page   =>:fb_flow_page_id,',
'    p_flow   =>:fb_flow_id,',
'    p_session=>:app_session);',
'exception when others then',
'  sys.htp.prn(''&nbsp;'');',
'end;',
'',
'',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19534530937904462.4407)
,p_plug_name=>unistr('\6309\9215\65B9\584A')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717541321245505702.4407)
,p_plug_display_sequence=>1
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19534903611904462.4407)
,p_plug_name=>unistr('\61C9\7528\7A0B\5F0F\9810\8A2D\503C')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(717561032869505733.4407)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(wwv_flow_lang.system_message(''F4400_P49_DEFS_HELP''));',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(46279312659679054.4407)
,p_plug_name=>unistr('\5340\57DF\986F\793A\9078\53D6\5668')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(42545310353834448.4407)
,p_plug_display_sequence=>2
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19535627341904468.4407)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(19534530937904462.4407)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:&P49_CANCEL.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19535812256904472.4407)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(19534530937904462.4407)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(615474655515132947.4407)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>'P49_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(19539625210904484.4407)
,p_branch_action=>'f?p=&APP_ID.:&P49_CANCEL.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19536012665904473.4407)
,p_name=>'P49_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(19533714252904461.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Id'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19536207493904474.4407)
,p_name=>'P49_DEFAULT_AUTHENTICATION_SC'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(19533714252904461.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9810\8A2D\8A8D\8B49\914D\7F6E')
,p_source=>'DEFAULT_AUTHENTICATION_SCHEME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CREATE.APP.AUTH.OPTIONS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.CLOUD_IDM'') d ,''CLOUD_IDM'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.SSO'') d ,''SSO'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''SSO''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'') d ,:PRODUCT_NAME v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'') d,''DBACCOUNT'' v',
'from dual',
'where wwv_flow_authentication_dev.get_internal_authentication <> ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'') d,''DATABASE'' v from dual',
')'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8A8D\8B49\662F\5EFA\7ACB\4F7F\7528\8005\8B58\5225, \8B93\4F7F\7528\8005\53EF\4EE5\5B58\53D6\61C9\7528\7A0B\5F0F\7684\7A0B\5E8F.<p/>'),
unistr('\8ACB\6307\5B9A\9810\8A2D\4F7F\7528\7684\8A8D\8B49\914D\7F6E:'),
'<ul>',
unistr('<li><b>&PRODUCT_NAME.</b> - \4F7F\7528\4EE5\300C&PRODUCT_NAME. \670D\52D9\7BA1\7406\300D\61C9\7528\7A0B\5F0F\5EFA\7ACB\53CA\7DAD\8B77\7684\4F7F\7528\8005\5E33\6236\8B49\660E\8CC7\6599. \9019\4E9B\662F\60A8\767B\5165 &PRODUCT_NAME. \958B\767C\74B0\5883\6642\6240\4F7F\7528\7684\5E33\6236. \60A8\4E5F\53EF\4EE5\5728\6B64\4F7F\7528\8005\5E33\6236\5132\5B58\5340\57DF\4E2D, \70BA\60A8\61C9\7528\7A0B\5F0F\7684\4E00\822C\4F7F\7528\8005\5EFA\7ACB\5E33\6236.</li>'),
unistr('<li><b>\4E0D\8A8D\8B49</b> - \4E5F\7A31\70BA\8CC7\6599\5EAB\8A8D\8B49, \6B64\9078\9805\8B93\4F7F\7528\8005\53EF\4EE5\4F7F\7528\5132\5B58\5728 modplsql DAD \5B9A\7FA9\4E2D\7684\5E33\6236\8B49\660E\8CC7\6599\5B58\53D6\60A8\7684\61C9\7528\7A0B\5F0F. \5728\591A\6578\60C5\6CC1\4E0B, \9019\8B93\4F7F\7528\8005\5728\53D6\60A8\7684\61C9\7528\7A0B\5F0F\6642\4E26\4E0D\9700\8981\767B\5165. \9019\662F\5EFA\7ACB\300C\516C\7528\300D\61C9\7528\7A0B\5F0F\7684\6700\5FEB\901F\65B9\5F0F.</li>'),
unistr('<li><b>\8CC7\6599\5EAB\5E33\6236</b> - \767B\5165\60A8\61C9\7528\7A0B\5F0F\7684\4F7F\7528\8005\9700\8981\8F38\5165\8CC7\6599\5EAB\7DB1\8981\540D\7A31 (\6216\4F7F\7528\8005\540D\7A31) \53CA\5176\5BC6\78BC\4F86\9032\884C\8A8D\8B49. \9019\9805\5E33\6236\8CC7\8A0A\5B8C\5168\5728 Oracle \8CC7\6599\5EAB\5167\7BA1\7406.</li>'),
'</ul>'))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19536721346904475.4407)
,p_name=>'P49_DEFAULT_APPLICATION_THEME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(19533524129904461.4407)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9810\8A2D\61C9\7528\7A0B\5F0F\4E3B\984C:')
,p_post_element_text=>'<p />'
,p_source=>'DEFAULT_APPLICATION_THEME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'THEME LIST FOR WS PREFERENCES'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(t.theme_name)||'' (''|| wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||'')''||',
'       ''<a href="#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="theme_''||t.theme_id||''"></a>'' display_value,',
'       to_char(t.theme_id) theme_id',
'       from wwv_flow_themes t, wwv_flow_user_interfaces ui ',
'      where t.security_group_id in (11,12)',
'        and (t.THEME_SECURITY_GROUP_ID is null ',
'            or t.THEME_SECURITY_GROUP_ID = :flow_security_group_id) ',
'        and t.flow_id in (',
'              select id from wwv_flows f',
'               where (',
'                    (:P49_SHOW = ''ALL''      and f.application_type in (''STANDARD'',''THEME'')) or ',
'                    (:P49_SHOW = ''CUSTOM''   and f.application_type = ''STANDARD'') or ',
'                    (:P49_SHOW = ''STANDARD'' and f.application_type = ''THEME'') or',
'                    (:P49_SHOW = ''LEGACY''   and f.application_type = ''THEME'')',
'               ) ',
'               and f.security_group_id in (11,12)',
'               )',
'        and (',
'          (:P49_SHOW = ''STANDARD'' and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') > 0 ) or',
'          (:P49_SHOW in (''LEGACY'',''CUSTOM'' ) and instr('',''||wwv_flow_platform.get_preference(''TOP_THEMES'')||'','','',''||t.theme_id||'','') = 0 ) or',
'          (:P49_SHOW = ''ALL'')',
'        )  ',
'        and ui.flow_id = t.flow_id',
'        and ui.theme_id = t.theme_id',
'        and ui.ui_type_id = :P49_UI_TYPE_ID',
'        order by t.flow_id'))
,p_field_template=>wwv_flow_api.id(717589175640513847.4407)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\9078\53D6\4E00\500B\4E3B\984C. \4E3B\984C\662F\6A23\677F\96C6\5408, \5B9A\7FA9\6574\500B\61C9\7528\7A0B\5F0F\7684\7248\9762\914D\7F6E\548C\6A23\5F0F.')
,p_attribute_01=>'1'
,p_attribut