prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4418
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4418 - Oracle APEX  System Messages and Native Types
--
-- Application Export:
--   Application:     4418
--   Name:            Oracle APEX  System Messages and Native Types
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                      1
--     Shared Components:
--       Logic:
--       Navigation:
--         Lists:                  3
--       Security:
--         Authentication:         1
--       User Interface:
--         Templates:
--           Page:                 2
--           Region:               1
--           Label:                1
--           List:                 1
--           Popup LOV:            1
--           Calendar:             3
--           Breadcrumb:           2
--           Button:               1
--           Report:               1
--         Plug-ins:             124
--       Globalization:
--         Messages:          14,593
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX  System Messages and Native Types')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286626842586927440')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135328'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'zh-tw'
,p_flow_language_derived_from=>'SESSION'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(91645213681389498.4418)
,p_populate_roles=>'A'
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'UNAVAILABLE'
,p_flow_unavailable_text=>'This application is currently unavailable.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141232'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_global
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562090986404402217.4418)
,p_name=>'Spotlight \ Custom Entries - Global'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48650898565635010.4418)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\767B\51FA')
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_list_text_01=>unistr('\767B\51FA Application Express')
,p_list_text_09=>'Y'
,p_list_text_10=>'logout exit quit :q'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(281916990329150760.4418)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\4EE5\8A66\7B97\8868\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:447:&APP_SESSION.::NO:448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT::'
,p_list_text_01=>unistr('\532F\5165\60A8\7684 excel \6216 csv \6A94\6848\4E26\5EFA\7ACB\61C9\7528\7A0B\5F0F')
,p_list_text_09=>'Y'
,p_list_text_10=>'excel csv xsl xslx spreadsheet data paste load import'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(282255839842182292.4418)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Oracle APEX \9996\9801')
,p_list_item_link_target=>'f?p=4500:1000:&APP_SESSION.'
,p_list_text_10=>unistr('\9996\9801\958B\59CB')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(296033420364984683.4418)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\700F\89BD\5B57\578B APEX \5716\793A')
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/fontapex'');'
,p_list_text_01=>unistr('\700F\89BD\5B57\578B APEX \5716\793A\3001\65B0\589E\4FEE\98FE\689D\4EF6\4EE5\53CA\8907\88FD\60A8\9700\8981\7684 CSS \6216 HTML.')
,p_list_text_09=>'Y'
,p_list_text_10=>'icons font apex library graphics'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_app_level
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562091518091404815.4418)
,p_name=>'Spotlight \ Custom Entries - App Level'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562091727563404815.4418)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\532F\51FA\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:4900:&SESSION.::NO:::'
,p_list_text_01=>unistr('\5C07\61C9\7528\7A0B\5F0F {APP_ID} \532F\51FA\6210 SQL \6A94\6848')
,p_list_text_09=>'Y'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(562093357853428158.4418)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\672A\4F7F\7528\7684\6E05\55AE')
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/spotlight_custom_entries_page_designer
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(562092153904409717.4418)
,p_name=>'Spotlight \ Custom Entries - Page Designer'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(48392393581618193.4418)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4E3B\63A7\53F0\65E5\8A8C')
,p_list_item_link_target=>'javascript:console.log(''hello friend'');'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14843831009863117.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14859012524941040.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(86380554411225400.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91997339122572414.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(460407779408652225.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.STARRATING_MODERN'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(497671453666914719.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_STAR_RATING'
,p_attribute_01=>'fa-star'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082458703597614427.4418)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1082517678315623391.4418)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765072678475712055.4418)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831649180083980462.4418)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780276458994154.4418)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1832884277947217587.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'PLUGIN_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1840861033969283097.4418)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917665913120940054.4418)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1990227023531717243.4418)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/one_level_tabs
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626406749381989.4418)
,p_theme_id=>1
,p_name=>'One Level Tabs.zh-tw'
,p_internal_name=>'ONE_LEVEL_TABS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>',
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>',
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>',
'  </tr>',
'</table>',
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">',
'  <tr>',
'    <td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>',
'  </tr>',
'  <tr>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>',
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>',
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>',
'  </tr>',
'<tr>',
'<td><br /></td>',
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_02##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">',
'  <tr>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>',
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>',
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>',
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>',
'  </tr>',
'</table>',
'<br />',
'#REGION_POSITION_05#',
'#FORM_CLOSE# ',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success">#SUCCESS_MESSAGE#</div>'
,p_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
'',
''))
,p_non_current_tab=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>',
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>',
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
''))
,p_notification_message=>'<div class="t1notification">#MESSAGE#</div>'
,p_navigation_bar=>'<div class="t1NavigationBar">#BAR_BODY#</div>'
,p_navbar_entry=>'<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'12'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(91626529080381989.4418)
,p_theme_id=>1
,p_name=>'Printer Friendly.zh-tw'
,p_internal_name=>'PRINTER_FRIENDLY'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top">',
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>',
'#BODY##REGION_POSITION_04#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
,p_template_comment=>'3'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(91626823864381990.4418)
,p_template_name=>'Button'
,p_internal_name=>'BUTTON'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">',
'<tr>',
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>',
'<td class="t1C"><a href="#LINK#">#LABEL!HTML#</a></td>',
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>',
'</tr>',
'</table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/region/reports_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(91632832228382001.4418)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">',
'<tr>',
'<td class="t1RegionHeader">#TITLE#</td>',
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>',
'</tr>',
'<tr>',
'<td class="t1Body" colspan="2">#BODY#</td>',
'</tr>',
'</table>'))
,p_page_plug_template_name=>'Reports Region'
,p_internal_name=>'REPORTS_REGION'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>1
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(91636711305382010.4418)
,p_list_template_current=>'<li class="t1current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_internal_name=>'VERTICAL_UNORDERED_LIST_WITH_BULLETS'
,p_theme_id=>1
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(91638400927382012.4418)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>1
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(91638400927382012.4418)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_with_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(91641225667382016.4418)
,p_template_name=>'Optional with help'
,p_internal_name=>'OPTIONAL_WITH_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641730492382017.4418)
,p_name=>'Hierarchical Menu'
,p_internal_name=>'HIERARCHICAL_MENU'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>1
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(91641814330382017.4418)
,p_name=>'Breadcrumb Menu'
,p_internal_name=>'BREADCRUMB_MENU'
,p_before_first=>'<div class="t1BreadcrumbMenu">'
,p_current_page_option=>'<span class="t1current">#NAME#</span>'
,p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;&gt;&nbsp;'
,p_after_last=>'</div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(91642503902382024.4418)
,p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif'
,p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>unistr('\641C\5C0B\5C0D\8A71\65B9\584A')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">',
'',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="t1PopupHead">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>unistr('\641C\5C0B')
,p_close_button_text=>unistr('\95DC\9589')
,p_next_button_text=>unistr('\4E0B\4E00\6B65 >')
,p_prev_button_text=>unistr('< \4E0A\4E00\6B65')
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>unistr('<br /><div style="padding:2px; font-size:8pt;">\8CC7\6599\5217  #FIRST_ROW# - #LAST_ROW#</div>')
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="t1PopupBody">'
,p_theme_id=>1
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/small_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91641910982382018.4418)
,p_cal_template_name=>'Small Calendar'
,p_internal_name=>'SMALL_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#DY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallCalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#" class="t1SmallCalendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallWeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="#CALENDAR_TITLE# #START_DL#" class="t1SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642102481382020.4418)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarHolder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarHolder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar_alternative_1
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(91642303533382020.4418)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_internal_name=>'CALENDAR,_ALTERNATIVE_1'
,p_day_of_week_format=>'<th scope="col" valign="bottom" class="t1DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="t1DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="t1Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="t1Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="t1WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="t1WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="t1NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="t1NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="t1MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t1WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="t1Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="t1NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t1Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="2" summary="#CALENDAR_TITLE# #START_DL#" class="t1DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="t1Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="t1Today">'
,p_daily_time_open_format=>'<th scope="row" class="t1Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>1
,p_theme_class_id=>2
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285090644503873294)
,p_name=>'2DCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \67F1\72C0\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285092931978873296)
,p_name=>'2DCOLUMN_LINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \67F1\72C0\6298\7DDA\5716')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285090835306873294)
,p_name=>'2DDOUGHNUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \74B0\5708\5716')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285092745564873296)
,p_name=>'2DHSTACKED_PCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C34\5E73\5806\758A 2D \67F1\72C0\5716 (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285090926870873294)
,p_name=>'2DLINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \6298\7DDA\5716')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285091024823873294)
,p_name=>'2DPIE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \5713\9905\5716')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285092528335873295)
,p_name=>'2DSTACKED_PCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5806\758A 2D \67F1\72C0\5716 (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285091179375873294)
,p_name=>'3DCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('3D \67F1\72C0\5716')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285092825828873296)
,p_name=>'3DHSTACKED_PCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C34\5E73\5806\758A 3D \67F1\72C0\5716 (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285091217818873294)
,p_name=>'3DPIE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('3D \5713\9905\5716')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285092681442873295)
,p_name=>'3DSTACKED_PCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5806\758A 3D \67F1\72C0\5716 (\767E\5206\6BD4)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988578006873936)
,p_name=>'4000.912.0.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\8981\63D2\5165\300C\5C6C\6027\5B57\5178\300D\4E2D\7684\300C\9805\76EE\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988388123873936)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\8981\66F4\65B0\7684\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988791406873936)
,p_name=>'4000.912.0.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\7528\4EE5\66F4\65B0\300C\5C6C\6027\5B57\5178\300D\7684\300C\9805\76EE\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989192446873937)
,p_name=>'4000.912.0.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\8981\63D2\5165\300C\5C6C\6027\5B57\5178\300D\4E2D\7684\300C\5831\8868\8CC7\6599\6B04\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989359849873937)
,p_name=>'4000.912.0.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\7528\4EE5\66F4\65B0\300C\5C6C\6027\5B57\5178\300D\7684\300C\5831\8868\8CC7\6599\6B04\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988262182873936)
,p_name=>'4000.912.REVIEW.N.ITEMS.FOR.UPDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\67E5 %0 \500B\8981\66F4\65B0\7684\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988972861873936)
,p_name=>'4000:912:0.RC.FOR.UPDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\8981\66F4\65B0\7684\300C\5831\8868\8CC7\6599\6B04\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988449761873936)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\67E5\8981\63D2\5165\300C\5C6C\6027\5B57\5178\300D\4E2D\7684 %0 \500B\300C\9805\76EE\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988631265873936)
,p_name=>'4000:912:REVIEW.N.ITEMS.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\67E5\7528\4EE5\66F4\65B0\300C\5C6C\6027\5B57\5178\300D\7684 %0 \500B\300C\9805\76EE\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989042450873937)
,p_name=>'4000:912:REVIEW.N.RC.FOR.INSERT.INTO.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\67E5\8981\63D2\5165\300C\5C6C\6027\5B57\5178\300D\4E2D\7684 %0 \500B\300C\5831\8868\8CC7\6599\6B04\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285988866902873936)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\67E5 %0 \500B\8981\66F4\65B0\7684\300C\5831\8868\8CC7\6599\6B04\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989272451873937)
,p_name=>'4000:912:REVIEW.N.RC.FOR.UPDATE.OF.AD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\67E5\7528\4EE5\66F4\65B0\300C\5C6C\6027\5B57\5178\300D\7684 %0 \500B\300C\5831\8868\8CC7\6599\6B04\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285679011295873724)
,p_name=>'4000_424_VALUE_MUST_BE_NUMERIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\5FC5\9808\662F\6578\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285663531537873713)
,p_name=>'4000_639_SEQ_MESG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<span class="fielddata"> \7121\6CD5\91CD\65B0\6392\5217, \56E0\70BA\300C\5340\57DF\300D\9806\5E8F\4E0D\662F\552F\4E00\7684.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285663695320873713)
,p_name=>'4000_641_SEQ_MESG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<span class="fielddata">\7121\6CD5\91CD\65B0\6392\5217, \56E0\70BA\300C\6309\9215\300D\9806\5E8F\4E0D\662F\552F\4E00\7684.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285663707772873713)
,p_name=>'4000_646_SEQ_MESG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<span class="fielddata">\7121\6CD5\91CD\65B0\6392\5217, \56E0\70BA\300C\5C0E\89BD\5217\300D\9806\5E8F\4E0D\662F\552F\4E00\7684.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285663831325873713)
,p_name=>'4000_749_SEQ_MESG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<span class="fielddata">\7121\6CD5\91CD\65B0\6392\5217, \56E0\70BA\300C\5340\57DF\9805\76EE\300D\9806\5E8F\4E0D\662F\552F\4E00\7684.</span>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285743484356873768)
,p_name=>'4000_APPLICATION_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285235115485873400)
,p_name=>'4000_EDIT_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\61C9\7528\7A0B\5F0F: %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285635179628873692)
,p_name=>'4000_INVALID_DATE_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7684\65E5\671F\683C\5F0F\7121\6548.  \884C\4E8B\66C6\65E5\671F\683C\5F0F\5FC5\9808\662F YYYYMMDD.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285684237960873728)
,p_name=>'4000_TREE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A39\72C0\7D50\69CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285743502275873768)
,p_name=>'4000_WORKSPACE_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340 ID')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285516266335873605)
,p_name=>'4050_106_ENTER_SCHEMA_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\8981\5EFA\7ACB\4E4B\65B0\7DB1\8981\7684\540D\7A31.  \8ACB\9078\64C7\7DB1\8981\7684\5BC6\78BC, \7136\5F8C\9078\64C7\9810\8A2D\7684\8868\683C\7A7A\9593\548C\66AB\6642\8868\683C\7A7A\9593.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285516344466873605)
,p_name=>'4050_106_EXISTING_SCHEMA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\73FE\6709\7DB1\8981\7684\540D\7A31.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285516450202873605)
,p_name=>'4050_106_WHEN_DONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\5728\5B8C\6210\5F8C\6309\300C\4E0B\4E00\6B65 &gt;\300D\6309\9215.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409453095873527)
,p_name=>'4050_110_DROP_TABLESPACES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8868\683C\7A7A\9593\548C\76F8\95DC\7684\8CC7\6599\6A94: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409387384873527)
,p_name=>'4050_110_DROP_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8CC7\6599\5EAB\4F7F\7528\8005: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322036157874182)
,p_name=>'4050_139_WEB_SERVICE_ACTIVITY_LOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \670D\52D9\6D3B\52D5\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285509621684873600)
,p_name=>'4050_19_LOG_ENTRIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\6D3B\52D5\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285128247804873321)
,p_name=>'4050_31_LOG_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\767B\5165\5B58\53D6\65E5\8A8C\300D\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285509193709873600)
,p_name=>'4050_3_CHANGE_REQUESTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285509218989873600)
,p_name=>'4050_3_RUNTIME_REQUESTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A0B\5F0F\5BE6\969B\57F7\884C\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285508903397873600)
,p_name=>'4050_3_SERVICE_REQUESTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285511618520873601)
,p_name=>'4050_46_AD_HOC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300CSQL \547D\4EE4\8655\7406\5668\300D\6B77\53F2\8A18\9304\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285511579257873601)
,p_name=>'4050_46_CONTROL_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\63A7\5236\6A94\300D\57F7\884C\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285511401707873601)
,p_name=>'4050_46_SCRIPT_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\547D\4EE4\6A94\6A94\6848\300D\57F7\884C\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285511732687873602)
,p_name=>'4050_46_SQL_ARCHIVES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300CSQL \5B58\6A94\300D\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285513750118873603)
,p_name=>'4050_61_ACTIVE_LOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F5C\7528\4E2D\65E5\8A8C\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285513871097873603)
,p_name=>'4050_61_CURRENT_LOG_NO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\65E5\8A8C\7DE8\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285513990386873603)
,p_name=>'4050_61_CUR_LOG_TIME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\65E5\8A8C\6642\9593\6233\8A18')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285514587265873604)
,p_name=>'4050_61_HOURS_UNTIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8DDD\96E2\4E0B\4E00\6B21\65E5\8A8C\5207\63DB\7684\6642\9593 (\5C0F\6642)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285514191773873603)
,p_name=>'4050_61_INTERVAL_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5929\6578\9593\9694 (\5E38\6578)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285514417159873604)
,p_name=>'4050_61_NEXT_LOG_SWITCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5B9A\7684\4E0B\4E00\6B21\65E5\8A8C\5207\63DB, \91DD\5C0D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285514865139873604)
,p_name=>'4050_70_DEV_ACT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\6D3B\52D5\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515033807873604)
,p_name=>'4050_71_CLICK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F4\63A5\9023\7D50\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515806850873604)
,p_name=>'4050_75_AD_HOC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300CSQL \547D\4EE4\8655\7406\5668\300D\6B77\53F2\8A18\9304\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515768445873604)
,p_name=>'4050_75_CTRL_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\63A7\5236\6A94\300D\57F7\884C\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515541698873604)
,p_name=>'4050_75_SCRIPT_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\547D\4EE4\6A94\6A94\6848\300D\57F7\884C\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515949384873605)
,p_name=>'4050_75_SQL_ARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300CSQL \5B58\6A94\300D\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285516042523873605)
,p_name=>'4050_82_WORKSPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340 %1 \6709 %2 \500B\61C9\7528\7A0B\5F0F\548C %3 \500B\4F7F\7528\8005.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285516140790873605)
,p_name=>'4050_85_CLICK_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\9EDE\9078\8A08\6578\300D\65E5\8A8C\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285714262617873748)
,p_name=>'4050_PACKAGED_APPLICATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\751F\7522\529B\548C\7BC4\4F8B\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285714339013873748)
,p_name=>'4050_PACKAGED_WEBSHEETS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\4F8B Web \8A66\7B97\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285713597089873748)
,p_name=>'4050_WORKSPACE_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340\8A08\6578')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253805939873414)
,p_name=>'4150_COLUMN_NUMBER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04 %0')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285437581424873547)
,p_name=>'4350_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285437695869873547)
,p_name=>'4350_EDIT_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\61C9\7528\7A0B\5F0F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143374185873332)
,p_name=>'4500 800 HD DBA'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Database Express Edition 2 Day DBA.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143440954873332)
,p_name=>'4500 800 HD DEV'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Database Express Edition 2 Day Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143296714873332)
,p_name=>'4500 800 HD HTMLDB'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Application Express 2 Day Plus Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143589392873333)
,p_name=>'4500 800 HD JAVA'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus Java Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143621799873333)
,p_name=>'4500 800 HD NET'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143700805873333)
,p_name=>'4500 800 HD PHP'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Database Express Edition 2 Day Plus PHP Developer.'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143864782873333)
,p_name=>'4500 800 MSG DBA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AAA\660E\4E00\822C\65E5\5E38\7684\7BA1\7406\5DE5\4F5C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285143925441873333)
,p_name=>'4500 800 MSG DEV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AAA\660E\5982\4F55\5584\52A0\5229\7528 Oracle Database Express Edition \958B\767C\74B0\5883.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285144099439873333)
,p_name=>'4500 800 MSG HTMLDB'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\4E00\7CFB\5217\7684\6559\5B78\8AB2\7A0B, \8AAA\660E\5982\4F55\7D44\5EFA\4EE5\8CC7\6599\5EAB\70BA\4E2D\5FC3\7684 Web \61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285144295538873333)
,p_name=>'4500 800 MSG JAVA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\6587\4EF6\63D0\4F9B\7684\6559\5B78\8AB2\7A0B\5305\542B\5982\4F55\4F7F\7528 Java \548C JDBC \4F86\9023\7DDA Oracle Database XE, \4EE5\53CA\5982\4F55\7528\4F86\958B\767C\5B58\53D6\53CA\4FEE\6539\8CC7\6599\7684\7C21\55AE Java \61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285144312378873333)
,p_name=>'4500 800 MSG NET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\6587\4EF6\8AAA\660E Oracle Data Provider for .NET \548C Oracle Developer Tools for Visual Studio .NET \7684\4E3B\8981\529F\80FD. \5B83\9010\6B65\5F15\5C0E\60A8\5B8C\6210\5B89\88DD\548C\8A2D\5B9A\7D44\614B\7684\5DE5\4F5C, \8AAA\660E\5982\4F55\4F7F\7528 Oracle Data Provider for .NET \548C Oracle Developer Tools for Visual Studio .NET \7D44\5EFA\57FA\672C\7684\61C9\7528\7A0B\5F0F, \4EE5\53CA\5982\4F55\5EFA\7ACB\4E26\4F7F\7528 PL/SQL \548C .NET \9810\5B58\7A0B\5E8F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285144115580873333)
,p_name=>'4500 800 MSG PHP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\6587\4EF6\63D0\4F9B\7684\6559\5B78\8AB2\7A0B\5305\542B\5982\4F55\4E0B\8F09\4E26\5B89\88DD Apache \548C Zend Core PHP \9A45\52D5\7A0B\5F0F, \5982\4F55\4F7F\7528 PHP \4F86\9023\7DDA Oracle Database XE, \4EE5\53CA\5982\4F55\4F7F\7528 PHP \4F86\958B\767C\5B58\53D6\53CA\4FEE\6539\8CC7\6599\7684\7C21\55AE\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114021765873311)
,p_name=>'4500_1002_QB_CLONE_ALIAS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285113996779873311)
,p_name=>'4500_1002_QB_CLONE_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114280988873311)
,p_name=>'4500_1002_QB_CLONE_CONDITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285572956936873646)
,p_name=>'4500_1002_QB_CLONE_DEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114651810873312)
,p_name=>'4500_1002_QB_CLONE_FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114779434873312)
,p_name=>'4500_1002_QB_CLONE_GROUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44\4F9D\64DA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114148853873311)
,p_name=>'4500_1002_QB_CLONE_OBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114526888873312)
,p_name=>'4500_1002_QB_CLONE_OUTPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114327353873311)
,p_name=>'4500_1002_QB_CLONE_SORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114474615873311)
,p_name=>'4500_1002_QB_CLONE_SORT_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285117863272873314)
,p_name=>'4500_1002_QB_JOIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285111319705873309)
,p_name=>'4500_1002_QB_JOIN_HINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4E00\4E0B\6B64\8655\53EF\9078\53D6\8981\7D50\5408\7684\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118221429873314)
,p_name=>'4500_1002_QB_MAX_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\591A\53EF\4EE5\9078\53D6 60 \500B\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285111276185873309)
,p_name=>'4500_1002_QB_REMOVE_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285111170175873309)
,p_name=>'4500_1002_QB_SHOW_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A/\96B1\85CF\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285117911059873314)
,p_name=>'4500_1002_QB_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285109510152873308)
,p_name=>'4500_1220_SCRIPT_RESULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \7684\7D50\679C, \57F7\884C %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409666187873527)
,p_name=>'4500_46_RET_TO_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8FD4\56DE\539F\59CB\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285125536729873319)
,p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\524D %0 \500B\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285602602262873669)
,p_name=>'4500_SESS_EVENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285602554164873669)
,p_name=>'4500_SESS_KILOBYTES'
,p_message_language=>'zh-tw'
,p_message_text=>'KB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285602478767873669)
,p_name=>'4500_SESS_MEGABYTES'
,p_message_language=>'zh-tw'
,p_message_text=>'MB'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285147297640873335)
,p_name=>'4500_UI_DEF_HINT_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\4F7F\7528\300C\4F7F\7528\8005\4ECB\9762\9810\8A2D\503C\300D\7522\751F\5340\57DF\548C\9805\76EE\7279\6027\7684\6700\521D\503C, \4EE5\63D0\4F9B\55AE\4E00\61C9\7528\7A0B\5F0F\4E2D\6216\591A\500B\61C9\7528\7A0B\5F0F\9593\591A\500B\9801\9762\7684\4E00\81F4\6027.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285191650717873368)
,p_name=>'4550_COOKIES_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\61C9\7528\7A0B\5F0F\9700\8981\555F\7528 Cookie.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285191544274873368)
,p_name=>'4550_JAVASCRIPT_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\61C9\7528\7A0B\5F0F\9700\8981\555F\7528 JavaScript.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285383232810873508)
,p_name=>'4800_9015_UPDATE_OVERDUE_FEATURES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07 %0 \500B\903E\671F\529F\80FD\66F4\65B0\70BA\9078\53D6\7684\65B0\91CC\7A0B\7891.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285633423502873691)
,p_name=>'ABOUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\65BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286394280205874239)
,p_name=>'ABOUT_TO_CREATE_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\78BA\8A8D\8981\5C07\4E0B\5217 %0 \4F4D\4F7F\7528\8005\65B0\589E\81F3\60A8\7684\5DE5\4F5C\5340.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285645826225873700)
,p_name=>'ACCEPTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\63A5\53D7')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285612258048873676)
,p_name=>'ACCESSIBILITY_ASSIGNEE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F14\52A9\529F\80FD\6307\5B9A\5C0D\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285610341461873675)
,p_name=>'ACCESSIBILITY_IMPACT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F14\52A9\529F\80FD\5F71\97FF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285612707921873676)
,p_name=>'ACCESSIBILITY_STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F14\52A9\529F\80FD\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286473335184874298)
,p_name=>'ACCESSIBILITY_TESTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F14\52A9\529F\80FD\5DF2\6E2C\8A66')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124393706873319)
,p_name=>'ACCESS_CONTROL_ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285283758512873436)
,p_name=>'ACCESS_CONTROL_ADMIN_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\6B0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122834687873317)
,p_name=>'ACCESS_CONTROL_ADMIN_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\7BA1\7406\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285561474645873637)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285672563718873719)
,p_name=>'ACCESS_CONTROL_ADMIN_ROLE_DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7D66\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\7684\89D2\8272.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123087374873318)
,p_name=>'ACCESS_CONTROL_APP_ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123674081873318)
,p_name=>'ACCESS_CONTROL_APP_MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123587025873318)
,p_name=>'ACCESS_CONTROL_APP_MODE_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\5982\4F55\63A7\5236\6B64\61C9\7528\7A0B\5F0F\7684\5B58\53D6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124861936873319)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\8655\7406\8A2D\5B9A\61C9\7528\7A0B\5F0F\6A21\5F0F\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124906585873319)
,p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8A2D\5B9A\61C9\7528\7A0B\5F0F\6A21\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284637977873436)
,p_name=>'ACCESS_CONTROL_CANNOT_DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\4E0D\80FD\5C07\81EA\5DF1\522A\9664.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284717942873436)
,p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\4E0D\80FD\79FB\9664\81EA\5DF1\7684\7BA1\7406\54E1\6B0A\9650.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122931912873318)
,p_name=>'ACCESS_CONTROL_CONFIRM_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285561339716873637)
,p_name=>'ACCESS_CONTROL_CONTRIB_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53C3\8207\6B0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285561515457873637)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285672649882873720)
,p_name=>'ACCESS_CONTROL_CONTRIB_ROLE_DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7D66\61C9\7528\7A0B\5F0F\63D0\4F9B\8005\7684\89D2\8272.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285605006236873671)
,p_name=>'ACCESS_CONTROL_CREATE_APP_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\6703\5EFA\7ACB\4E0B\5217\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285561626160873638)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\6703\5EFA\7ACB\4E0B\5217\61C9\7528\7A0B\5F0F\5B58\53D6\89D2\8272:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285140431705873330)
,p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\6703\5EFA\7ACB\4E0B\5217\6388\6B0A\914D\7F6E:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285214186650873385)
,p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\5EFA\7ACB\5B58\53D6\63A7\5236\9801\9762. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285214086240873384)
,p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\5EFA\7ACB\5B58\53D6\63A7\5236\8868\683C. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285287275284873438)
,p_name=>'ACCESS_CONTROL_DUP_USERNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\4E0D\80FD\8F38\5165\91CD\8907\7684\4F7F\7528\8005\540D\7A31.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285283879101873436)
,p_name=>'ACCESS_CONTROL_EDIT_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236 - \7DE8\8F2F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124598835873319)
,p_name=>'ACCESS_CONTROL_FIND_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\67E5\8A62\689D\4EF6 (\6C92\6709\5927\5C0F\5BEB\4E4B\5206), \7136\5F8C\6309<b>\57F7\884C</b>\6309\9215.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124680151873319)
,p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\53D6\5F97\61C9\7528\7A0B\5F0F\7BA1\7406\6A21\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124429502873319)
,p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\6B21\8B8A\66F4\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123981795873318)
,p_name=>'ACCESS_CONTROL_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123158074873318)
,p_name=>'ACCESS_CONTROL_MODE1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\70BA\5B8C\6574\5B58\53D6\6B0A, \4E0D\4F7F\7528\5B58\53D6\63A7\5236\6E05\55AE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123231029873318)
,p_name=>'ACCESS_CONTROL_MODE2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9650\5236\5B58\53D6. \50C5\5141\8A31\5B58\53D6\63A7\5236\6E05\55AE\4E2D\5B9A\7FA9\7684\4F7F\7528\8005\5B58\53D6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123334501873318)
,p_name=>'ACCESS_CONTROL_MODE3'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\516C\7528\552F\8B80. \7531\5B58\53D6\63A7\5236\6E05\55AE\63A7\5236\7DE8\8F2F\8207\7BA1\7406\6B0A\9650.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123462072873318)
,p_name=>'ACCESS_CONTROL_MODE4'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50C5\9650\7BA1\7406\5B58\53D6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124799723873319)
,p_name=>'ACCESS_CONTROL_NO_PRIV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\52D5\4F5C\7684\6B0A\9650.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124219343873318)
,p_name=>'ACCESS_CONTROL_PRIV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285604958800873671)
,p_name=>'ACCESS_CONTROL_READER_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95B1\8B80\8005\6B0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285604896572873671)
,p_name=>'ACCESS_CONTROL_READER_ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95B1\8B80\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285672705743873720)
,p_name=>'ACCESS_CONTROL_READER_ROLE_DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7D66\61C9\7528\7A0B\5F0F\95B1\8B80\8005\7684\89D2\8272.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285141244865873331)
,p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\76F8\5C0D\65BC\6B64\61C9\7528\7A0B\5F0F\4E4B\8A8D\8B49\914D\7F6E\7684\4F7F\7528\8005\540D\7A31.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123764369873318)
,p_name=>'ACCESS_CONTROL_SET_APP_MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285242272577873405)
,p_name=>'ACCESS_CONTROL_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5EFA\7ACB\5B58\53D6\63A7\5236\9801\9762.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285124175570873318)
,p_name=>'ACCESS_CONTROL_USERNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285561774953873638)
,p_name=>'ACCESS_CONTROL_USE_AUTH_ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\73FE\6709\7684\5B58\53D6\63A7\5236\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285141146727873331)
,p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\73FE\6709\7684\6388\6B0A\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285140381030873330)
,p_name=>'ACCESS_CONTROL_USE_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\73FE\6709\7684\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285283967884873436)
,p_name=>'ACCESS_CONTROL_VIEW_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236 - \6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285573610237873646)
,p_name=>'ACCESS_DENIED_SIMPLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\88AB\62D2')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285144614373873333)
,p_name=>'ACCOUNT_CREATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5EFA\7ACB\5E33\6236.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285267521707873424)
,p_name=>'ACCOUNT_HAS_BEEN_CREATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684 %0 \5E33\6236\5DF2\7D93\5EFA\7ACB.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285142083663873331)
,p_name=>'ACCOUNT_LOCKED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E33\6236\5DF2\88AB\9396\5B9A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285934655799873897)
,p_name=>'ACCOUNT_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E33\6236\529F\80FD\8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285592173245873662)
,p_name=>'ACKNOWLEDGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8A8D\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285592365758873662)
,p_name=>'ACKNOWLEDGED_NO_ACTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8A8D\53EF, \7121\9808\63A1\53D6\52D5\4F5C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285656222821873708)
,p_name=>'ACL_ADD_USER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324835908874184)
,p_name=>'ACL_TABLE.ACCESS_DASHBOARD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\5100\8868\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324998930874184)
,p_name=>'ACL_TABLE.ACCESS_MONITOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\76E3\7763\6D3B\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324020633874183)
,p_name=>'ACL_TABLE.ADD_MODIFY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E / \4FEE\6539')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324763461874184)
,p_name=>'ACL_TABLE.ADMIN_WHEN_RUNNING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\61C9\7528\7A0B\5F0F\6642\9032\884C\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286323221330874182)
,p_name=>'ACL_TABLE.ADMIN_WITHIN_BUILDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\4E2D\9032\884C\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286323908158874183)
,p_name=>'ACL_TABLE.ANNOTATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A3B\89E3 (\6A94\6848\3001\6A19\8A18\3001\9644\8A3B)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322921774874182)
,p_name=>'ACL_TABLE.APEX_AUTH_WO_ACL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\4F7F\7528\5B58\53D6\63A7\5236\6E05\55AE\9032\884C Application Express \5E33\6236\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322814661874182)
,p_name=>'ACL_TABLE.AUTH_WITH_ACL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\5B58\53D6\63A7\5236\6E05\55AE\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286323687183874183)
,p_name=>'ACL_TABLE.EDIT_SQL_ACCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F SQL \5B58\53D6\548C\5EFA\8B70\7684\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327909871874186)
,p_name=>'ACL_TABLE.INTRO_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\904E\61C9\7528\7A0B\5F0F\8A8D\8B49\5F8C, \5373\7531\5B58\53D6\63A7\5236\6C7A\5B9A\4F7F\7528\8005\80FD\5920\5728\61C9\7528\7A0B\5F0F\5167\57F7\884C\54EA\4E9B\52D5\4F5C. \4E0B\8868\986F\793A\4E0D\540C\985E\578B\4E4B\4F7F\7528\8005\6240\80FD\57F7\884C\7684\529F\80FD (\6839\64DA\6B64\61C9\7528\7A0B\5F0F\5167\4F7F\7528\7684\8A8D\8B49\800C\5B9A).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286325054319874184)
,p_name=>'ACL_TABLE.MAINTAIN_ACL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DAD\8B77\5B58\53D6\63A7\5236\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286323755840874183)
,p_name=>'ACL_TABLE.RUN_AND_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\4E26\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286323429694874183)
,p_name=>'ACL_TABLE.UPDATE_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F\7279\6027')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285983165456873932)
,p_name=>'ACTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322375729874182)
,p_name=>'ACTION_MENU_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\529F\80FD\8868\8A2D\5B9A\503C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285155736189873342)
,p_name=>'ACTIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F5C\7528\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285569207147873643)
,p_name=>'ACTIVITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6D3B\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285613734780873677)
,p_name=>'ACTIVITY_SUMMARY'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6D3B\52D5\6458\8981'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285849296701873839)
,p_name=>'ADDED_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286319872820874180)
,p_name=>'ADDED_TO_PURGE_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\65B0\589E\81F3\6C38\4E45\6E05\9664\6E05\55AE')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285968800755873922)
,p_name=>'ADDITIONAL_INFORMATION_REQUESTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8981\6C42\984D\5916\8CC7\8A0A')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285523417623873610)
,p_name=>'ADD_ARGUEMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\5F15\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285513508170873603)
,p_name=>'ADD_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285729750451873759)
,p_name=>'ADD_COLUMN_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285371513858873500)
,p_name=>'ADD_CONSTRAINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\9650\5236\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285511338154873601)
,p_name=>'ADD_MORE...'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\5176\4ED6\9805\76EE...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285584170669873656)
,p_name=>'ADD_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285737239906873764)
,p_name=>'ADD_USER_INTERFACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\4F7F\7528\8005\4ECB\9762')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285740886038873767)
,p_name=>'ADJUST_PROVISIONED_SPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ABF\6574 %0 MB \7684\5DF2\4F48\5EFA\7684\7A7A\9593')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285509850014873600)
,p_name=>'ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285136021761873327)
,p_name=>'ADMINISTRATOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340\7BA1\7406\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285613520764873677)
,p_name=>'ADMINISTRATORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285517161206873605)
,p_name=>'ADMIN_EMAIL_MUST_BE_PROV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\63D0\4F9B\7BA1\7406\54E1\96FB\5B50\90F5\4EF6')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681231954873726)
,p_name=>'ADVISOR.CATEGORY.ACCESSIBILITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F14\52A9\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285171680125873353)
,p_name=>'ADVISOR.CATEGORY.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285171944603873353)
,p_name=>'ADVISOR.CATEGORY.PERFORMANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6548\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172000547873353)
,p_name=>'ADVISOR.CATEGORY.QA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\54C1\8CEA\4FDD\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285171740702873353)
,p_name=>'ADVISOR.CATEGORY.SECURITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\5168\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172124018873353)
,p_name=>'ADVISOR.CATEGORY.USABILITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\7528\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285171881900873353)
,p_name=>'ADVISOR.CATEGORY.WARNING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B66\544A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285814552617873816)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE "%1" \53D7\5230\4FDD\8B77, \7121\6CD5\900F\904E AJAX \547C\53EB\8A2D\5B9A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285814664522873816)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE "%1" \53D7\5230\4FDD\8B77, \7121\6CD5\900F\904E AJAX \547C\53EB\8A2D\5B9A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846508871873837)
,p_name=>'ADVISOR.CHECK.AJAX_ITEMS_WITH_SSP.MSG_AJAX_ITEMS_WITH_SSP.REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE "%1" \53D7\5230\4FDD\8B77, \7121\6CD5\900F\904E AJAX \547C\53EB\8A2D\5B9A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285202452224873376)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_MISSING_SYS_PREFIX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\907A\6F0F SYS \7DB1\8981\524D\7F6E\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286024403486873962)
,p_name=>'ADVISOR.CHECK.APEX_CODE_SMELL.MSG_WWV_FLOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('WWV_FLOW API \4F7F\7528\72C0\6CC1 (\6539\7528 APEX API)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285964524221873919)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IG_COLUMN_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5340\57DF\4F86\6E90 SQL \6558\8FF0\53E5\300D\4E2D\6C92\6709\8CC7\6599\6B04 %0 \5B58\5728!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181927561873361)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_IR_FILTER_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\4E92\52D5\5F0F\5831\8868\300D\8CC7\6599\6B04 %0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179665883873359)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285148036085873336)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_REGION_COLUMN_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5340\57DF\4F86\6E90 SQL \6558\8FF0\53E5\300D\4E2D\6C92\6709\8CC7\6599\6B04 %0 \5B58\5728!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286059098251873987)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_TABFORM_COLUMN_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5217\8868\5316\8868\55AE\300D\8CC7\6599\6B04 %0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179757070873359)
,p_name=>'ADVISOR.CHECK.APPL_PAGE_ITEM_REF.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\53EF\53C3\7167\70BA\61C9\7528\7A0B\5F0F\6216\9801\9762\9805\76EE\540D\7A31.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286400293916874244)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_APP_PROC_AUTHORIZATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Ajax \56DE\547C\61C9\7528\7A0B\5F0F\8655\7406\4F5C\696D\672A\53D7\6388\6B0A\914D\7F6E\4FDD\8B77.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286399830307874244)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_PAGE_AUTHORIZATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\672A\53D7\6388\6B0A\914D\7F6E\4FDD\8B77.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180635023873360)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_NO_TARGET_AUTH_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\6A19\9801\9762 %1 (\5728\61C9\7528\7A0B\5F0F %0 \5167) \5C1A\672A\5B9A\7FA9\6388\6B0A\914D\7F6E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286401944962874245)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_PARENT_PAGE_AUTH_DIFFERENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9801\9762\7684\6388\6B0A\8207\7236\9805\9801\9762 %0 \7684\6388\6B0A "%1" \4E0D\540C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180792837873360)
,p_name=>'ADVISOR.CHECK.AUTHORIZATION.MSG_TARGET_AUTH_DIFFERENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\6A19\9801\9762\4E0A\7684\6388\6B0A "%0" \8207 "%1" \4E0D\540C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179286334873359)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179179959873359)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_UNKNOWN_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\57F7\884C\9023\7D50\8B8A\6578\8A9E\6CD5\6AA2\67E5. \932F\8AA4: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179326722873359)
,p_name=>'ADVISOR.CHECK.BIND_VARIABLE_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\53EF\4F7F\7528\9023\7D50\8B8A\6578\8A9E\6CD5\53C3\7167 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181384343873360)
,p_name=>'ADVISOR.CHECK.BRANCH_SEQUENCE.MSG_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6\5206\652F\4E4B\524D\6709\7121\689D\4EF6\6027\5206\652F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286399610791874243)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_AUTOCOMPLETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\81EA\52D5\5B8C\6210\300D\5728\542B\6709\5BC6\78BC\9805\76EE\7684\9801\9762\6703\8A2D\70BA\300C\958B\555F\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286399710764874244)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_CACHE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5FEB\53D6\300D\5141\8A31\700F\89BD\5668\5FEB\53D6\6A5F\5BC6\8CC7\6599.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286284644818874154)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_BROWSER_FRAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5167\5D4C\65BC\6846\67B6\4E2D\300D\6703\8B93\61C9\7528\7A0B\5F0F\6613\906D\53D7 clickjacking \653B\64CA.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286284730503874154)
,p_name=>'ADVISOR.CHECK.BROWSER_SECURITY.MSG_HTML_ESCAPING_MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300CHTML \9041\96E2\6A21\5F0F\300D\50C5\80FD\9041\96E2\4E00\7D44\6709\9650\5B57\5143.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285105825936873305)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_ID_FOUND_IN_ATTRIBUTES'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\300C\6309\9215\5C6C\6027\300D\4E2D\7684 ID \70BA\300C\52D5\614B\52D5\4F5C\300D(%0) \4E2D\53C3\7167\7684\6309\9215. '),
'',
unistr('\5728\300C\6309\9215\5C6C\6027\300D\4E2D\5B9A\7FA9 ID \6642, \5C07\5C0E\81F4\53C3\7167\6309\9215\7684\300C\52D5\614B\52D5\4F5C\300D\7121\6CD5\904B\4F5C. \8ACB\8003\616E\79FB\9664\6B64 ID, \56E0\70BA\6309\9215\9810\8A2D\5C07\6703\7522\751F ID.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285105910711873305)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_COMPATIBLE.MSG_TEMPLATE_BUTTON_NO_BUTTON_ID'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\300C\52D5\614B\52D5\4F5C\300D(%0) \4E2D\53C3\7167\4E4B\67D0\500B\6309\9215\6240\4F7F\7528\7684\300C\6309\9215\6A23\677F\300D\672A\5305\62EC #BUTTON_ID# \66FF\4EE3\5B57\4E32.'),
'',
unistr('\6A23\677F:'),
'%1',
'',
unistr('\8ACB\8003\616E\65B0\589E #BUTTON_ID# \66FF\4EE3\5B57\4E32\81F3\6B64\6A23\677F, \6216\8005\5C07\6309\9215\6A23\677F\8B8A\66F4\70BA\5305\62EC #BUTTON_ID# \66FF\4EE3\5B57\4E32\7684\6309\9215\6A23\677F.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285108502719873307)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_ACTION_NOT_DEFINED_BY_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\52D5\614B\52D5\4F5C\300D(%0) \4E2D\53C3\7167\4E4B\67D0\500B\6309\9215\7684\300C\52D5\4F5C\300D\4E0D\662F\7531\300C\52D5\614B\52D5\4F5C\5B9A\7FA9\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285115238625873312)
,p_name=>'ADVISOR.CHECK.BUTTON_DA_INCONSISTENT_REFS.MSG_NO_BUTTON_DEFINED_FOR_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215 (%0) \542B\6709\300C\52D5\614B\52D5\4F5C\5B9A\7FA9\300D\7684\300C\52D5\4F5C\300D, \4F46\662F\6C92\6709\53C3\7167\6B64\6309\9215\7684\76F8\5C0D\61C9\300C\52D5\614B\52D5\4F5C\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285682751492873727)
,p_name=>'ADVISOR.CHECK.CHART_TYPE_IS_ACCESSIBLE.MSG_ANYCHART_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9019\662F\820A\7684 AnyChart \5716\8868\985E\578B. \60A8\61C9\4F7F\7528\300C\61C9\7528\7A0B\5F0F\5347\7D1A\300D\5DE5\5177\79FB\8F49\6B64\5716\8868, \4EE5\4FBF\4F7F\7528\4EE5 Oracle JET \70BA\57FA\790E\7684\65B0\5716\8868, \5C07\6703\5927\5E45\63D0\5347\5176\53EF\7528\6027\8207\8F14\52A9\529F\80FD\6027.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180324391873360)
,p_name=>'ADVISOR.CHECK.CLEAR_CACHE_PAGE_NUMBER.MSG_OTHER_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664\5FEB\53D6\9801\9762 %0 \4E0D\662F\76EE\524D\7684\9801\9762\6216\76EE\6A19\9801\9762 %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179016163873359)
,p_name=>'ADVISOR.CHECK.COLUMN_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371820406874223)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_ATTRIBUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\5C6C\6027\503C\5DF2\88AB\53D6\4EE3.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286373381866874224)
,p_name=>'ADVISOR.CHECK.DEPRECATED_ATTRIBUTES.MSG_COMPONENT_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\5143\4EF6\985E\578B\5DF2\88AB\53D6\4EE3.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285814731466873816)
,p_name=>'ADVISOR.CHECK.DESC_AJAX_ITEMS_WITH_SSP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('AJAX \547C\53EB\4E2D\7684\53D7\4FDD\8B77\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285202367315873376)
,p_name=>'ADVISOR.CHECK.DESC_APEX_CODE_SMELL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A0B\5F0F\78BC\58DE\5473\9053 (APEX \5167\90E8)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177187004873357)
,p_name=>'ADVISOR.CHECK.DESC_APPL_PAGE_ITEM_REF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9805\76EE\3001\9801\9762\9805\76EE\3001\8CC7\6599\6B04\6216\4E92\52D5\5F0F\5831\8868\7BE9\9078\7684\5BA3\544A\5F0F\53C3\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286399501119874243)
,p_name=>'ADVISOR.CHECK.DESC_AUTHORIZATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6388\6B0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176872512873357)
,p_name=>'ADVISOR.CHECK.DESC_BIND_VARIABLE_SYNTAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50\8B8A\6578\8A9E\6CD5\53C3\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178218443873358)
,p_name=>'ADVISOR.CHECK.DESC_BRANCH_SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6\5206\652F\4E4B\524D\6709\7121\689D\4EF6\6027\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286400007546874244)
,p_name=>'ADVISOR.CHECK.DESC_BROWSER_SECURITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\5668\5B89\5168\6027\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285105738103873305)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_COMPATIBLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215\8207\300C\52D5\614B\52D5\4F5C\300D\4E0D\76F8\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285115052518873312)
,p_name=>'ADVISOR.CHECK.DESC_BUTTON_DA_INCONSISTENT_REFS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\52D5\614B\52D5\4F5C\300D\8207\300C\6309\9215\300D\4E4B\9593\7684\53C3\7167\4E0D\4E00\81F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285682578710873727)
,p_name=>'ADVISOR.CHECK.DESC_CHART_TYPE_IS_ACCESSIBLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\985E\578B\652F\63F4\8F14\52A9\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177484874873357)
,p_name=>'ADVISOR.CHECK.DESC_CLEAR_CACHE_PAGE_NUMBER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664\5FEB\53D6\9801\78BC\7B49\65BC\76EE\6A19\6216\76EE\524D\7684\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176703033873357)
,p_name=>'ADVISOR.CHECK.DESC_COLUMN_SYNTAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\8A9E\6CD5\53C3\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371793264874223)
,p_name=>'ADVISOR.CHECK.DESC_DEPRECATED_ATTRIBUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\88AB\53D6\4EE3\7684\5C6C\6027\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177768408873358)
,p_name=>'ADVISOR.CHECK.DESC_DML_PROCESSES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\64F7\53D6\3001DML \4EE5\53CA MR* \8655\7406\4F5C\696D\6709\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178177280873358)
,p_name=>'ADVISOR.CHECK.DESC_HARDCODED_APPLICATION_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\786C\5F0F\7DE8\78BC\7684\61C9\7528\7A0B\5F0F ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285588754291873659)
,p_name=>'ADVISOR.CHECK.DESC_HAS_HELP_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE\6709\8AAA\660E\5167\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681046367873726)
,p_name=>'ADVISOR.CHECK.DESC_HAS_PAGE_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6709\9801\9762\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285707125764873743)
,p_name=>'ADVISOR.CHECK.DESC_IMAGE_ITEM_HAS_ALT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\5F71\50CF\9805\76EE\5DF2\5B9A\7FA9\5F71\50CF\66FF\4EE3\6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286284426170874154)
,p_name=>'ADVISOR.CHECK.DESC_INSECURE_APPLICATION_DEFAULTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\9396\5B9A\61C9\7528\7A0B\5F0F\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176966566873357)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53C3\7167\7684\9805\76EE\5C6C\65BC\76EE\524D\7684\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177035136873357)
,p_name=>'ADVISOR.CHECK.DESC_IS_ITEM_OF_TARGET_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53C3\7167\7684\9805\76EE\662F\76EE\6A19\9801\9762\7684\9801\9762\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681771121873726)
,p_name=>'ADVISOR.CHECK.DESC_ITEMS_NO_CONTEXT_CHANGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE\4E0D\6703\5F15\767C\975E\9810\671F\7684\5167\5BB9\8B8A\66F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285682962213873727)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_HAS_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE\6709\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178468807873358)
,p_name=>'ADVISOR.CHECK.DESC_ITEM_NAME_LENGTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE\6216\5217\8868\5316\8868\55AE\8CC7\6599\6B04\540D\7A31\9577\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177276702873357)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_ITEM_REF_AS_STRING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B57\4E32\5F62\5F0F\7684\9801\9762\9805\76EE\53C3\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177391119873357)
,p_name=>'ADVISOR.CHECK.DESC_PAGE_NUMBER_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53C3\7167\7684\9801\78BC\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681369007873726)
,p_name=>'ADVISOR.CHECK.DESC_REGION_HAS_ROW_HEADER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\6709\8CC7\6599\5217\6A19\982D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178613838873358)
,p_name=>'ADVISOR.CHECK.DESC_REPORT_DEFAULT_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\6709\9810\8A2D\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286400130848874244)
,p_name=>'ADVISOR.CHECK.DESC_SESSION_STATE_PROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\968E\6BB5\4F5C\696D\72C0\614B\4FDD\8B77')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177881836873358)
,p_name=>'ADVISOR.CHECK.DESC_SQL_INJECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66FF\4EE3\8A9E\6CD5\7684\7528\6CD5\4E0D\6B63\78BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176623769873357)
,p_name=>'ADVISOR.CHECK.DESC_SUBSTITUTION_SYNTAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66FF\4EE3\8A9E\6CD5\53C3\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177667258873358)
,p_name=>'ADVISOR.CHECK.DESC_TARGET_PAGE_AUTH_USABILITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\5143\4EF6\4E5F\8A2D\5B9A\76EE\6A19\9801\9762\6388\6B0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681522450873726)
,p_name=>'ADVISOR.CHECK.DESC_THEME_STYLE_IS_ACCESSIBLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C\6A23\5F0F\5DF2\901A\904E\8F14\52A9\529F\80FD\6E2C\8A66')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285803415543873809)
,p_name=>'ADVISOR.CHECK.DESC_UI_INCLUDES_COMPATIBILITY_JS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4ECB\9762\5305\62EC\76F8\5BB9 JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178345095873358)
,p_name=>'ADVISOR.CHECK.DESC_VALIDATION_ASSOCIATED_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9A57\8B49\95DC\806F\7684\9805\76EE\6216\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177588827873358)
,p_name=>'ADVISOR.CHECK.DESC_VALID_SQL_PLSQL_CODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6709\6548\7684 SQL \6216 PL/SQL \7A0B\5F0F\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178085123873358)
,p_name=>'ADVISOR.CHECK.DESC_VERIFY_CLOB_PROPERTY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9A57\8B49 Clob \7279\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285177982129873358)
,p_name=>'ADVISOR.CHECK.DESC_V_FUNCTION_IN_SQL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \6558\8FF0\53E5\4E2D\4F7F\7528 V \51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178541002873358)
,p_name=>'ADVISOR.CHECK.DESC_WHEN_BUTTON_PRESSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4E0B\6309\9215\7684\53C3\7167\6309\9215\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180935091873360)
,p_name=>'ADVISOR.CHECK.DML_PROCESSES.MSG_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8B6F\932F\8AA4 - %0 \6558\8FF0\53E5: %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181248362873360)
,p_name=>'ADVISOR.CHECK.HARDCODED_APPLICATION_ID.MSG_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50\5305\542B\7684\76EE\524D\300C\61C9\7528\7A0B\5F0F ID\300D\70BA\786C\5F0F\7DE8\78BC\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285588638486873659)
,p_name=>'ADVISOR.CHECK.HAS_HELP_TEXT.MSG_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5B9A\7FA9\8AAA\660E\5167\5BB9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681183075873726)
,p_name=>'ADVISOR.CHECK.HAS_PAGE_TITLE.MSG_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9801\9762\6C92\6709\9801\9762\6A19\984C. \6709\610F\7FA9\7684\9801\9762\6A19\984C\5C0D\8F14\52A9\529F\80FD\975E\5E38\91CD\8981, \53EF\5354\52A9\4F7F\7528\8005\77AD\89E3\76EE\524D\9801\9762\7684\5167\5BB9\548C\76EE\7684.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285707270929873743)
,p_name=>'ADVISOR.CHECK.IMAGE_ITEM_HAS_ALT.MSG_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9805\76EE\907A\6F0F\5F71\50CF\5FC5\9808\63D0\4F9B\7684\66FF\4EE3\6587\5B57. \672C\9805\4F7F\7528\7684\826F\597D\6587\5B57, \61C9\6B63\78BA\63CF\8FF0\5F71\50CF\5167\5BB9, \4E26\4E14\4E0D\61C9\91CD\8907\9801\9762\4E0A\5DF2\986F\793A\65BC\5F71\50CF\5167\5BB9\4E2D\7684\4EFB\4F55\53EF\898B\8CC7\8A0A (\4EE5\907F\514D\767C\751F\91CD\8907). \6CE8\610F: \5982\679C\5F71\50CF\662F\7531\4F7F\7528\8005\63D0\4F9B, \4E5F\61C9\540C\6642\63D0\4F9B\5F71\50CF\66FF\4EE3\6587\5B57, \82E5\63D0\4F9B\9069\7576\7684\6307\5F15, \53EF\5354\52A9\4F7F\7528\8005\63D0\4F9B\9AD8\54C1\8CEA\6587\5B57.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286284580717874154)
,p_name=>'ADVISOR.CHECK.INSECURE_APPLICATION_DEFAULTS.MSG_RUNTIME_API_USAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\7A0B\5F0F\5BE6\969B\57F7\884C API \7528\6CD5\300D\5141\8A31\60A8\4FEE\6539\61C9\7528\7A0B\5F0F\548C\5DE5\4F5C\5340.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179401132873359)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_PAGE.MSG_NOT_ITEM_OF_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\662F\9801\9762 %1 \4E2D\7684\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179536484873359)
,p_name=>'ADVISOR.CHECK.IS_ITEM_OF_TARGET_PAGE.MSG_NOT_ITEM_OF_TARGET_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\662F\76EE\6A19\9801\9762 %1 \4E2D\7684\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681877859873726)
,p_name=>'ADVISOR.CHECK.ITEMS_NO_CONTEXT_CHANGE.MSG_CAUSES_CHANGE_OF_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9801\9762\9805\76EE\7684\300C\9078\64C7\6642\7684\9801\9762\52D5\4F5C\300D\8A2D\5B9A\53EF\80FD\6703\8B93\4F7F\7528\8005\7684\5167\5BB9\767C\751F\672A\9810\671F\8B8A\66F4. \8ACB\8003\616E\5207\63DB\6210\300C\7121\300D, \4EE5\78BA\4FDD\4E0D\6703\767C\751F\5167\5BB9\8B8A\66F4, \4E26\5C07\6B64\529F\80FD\6539\70BA\4F7F\7528\300C\52D5\614B\52D5\4F5C\300D\6216\300C\968E\5C64\5F0F LOV\300D(\82E5\9700\8981\7559\5728\76F8\540C\9801\9762). \6216\8005, \4E5F\53EF\4EE5\8003\616E\5411\4F7F\7528\8005\63D0\4F9B\76F8\95DC\8CC7\8A0A, \8B93\5176\77E5\9053\5C07\6703\767C\751F\4EC0\9EBC\52D5\4F5C (\4F8B\5982\5728\6A19\7C64\4E2D\65B0\589E\300C\555F\52D5\65B0\9801\9762\300D). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285707032213873743)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_NO_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE\5FC5\9808\5B9A\7FA9\6A19\7C64. \5982\679C\60A8\504F\597D\4E0D\986F\793A\6A19\7C64\6587\5B57, \4ECD\61C9\5B9A\7FA9\6A19\7C64, \7136\5F8C\9078\53D6\300C\96B1\85CF\300D\6A19\7C64\6A23\677F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285683038419873727)
,p_name=>'ADVISOR.CHECK.ITEM_HAS_LABEL.MSG_PLACEHOLDER_BUT_NO_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9805\76EE\5B9A\7FA9\4E86\300C\503C\9810\7559\4F4D\7F6E\300D\503C, \4F46\6C92\6709\6A19\7C64. \60A8\4E0D\61C9\53EA\4F7F\7528\9810\7559\4F4D\7F6E\6587\5B57\4F5C\70BA\9805\76EE\7684\7C64\6A19, \56E0\70BA\9019\6A23\6703\7522\751F\8F14\52A9\529F\80FD\554F\984C. \82E5\8981\7372\5F97\66F4\4F73\7684\8F14\52A9\529F\80FD, \5FC5\9808\8981\5B9A\7FA9\9805\76EE\6A19\7C64. \5982\679C\60A8\504F\597D\4E0D\986F\793A\6A19\7C64\6587\5B57, \4ECD\61C9\5B9A\7FA9\6A19\7C64, \7136\5F8C\9078\53D6\300C\96B1\85CF\300D\6A19\7C64\6A23\677F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181668129873361)
,p_name=>'ADVISOR.CHECK.ITEM_NAME_LENGTH.MSG_TOO_LONG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\7A31\9577\5EA6\70BA %0 \500B\5B57\5143, \4F46\6700\591A\4E0D\53EF\8D85\904E 30 \500B\5B57\5143.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179863352873359)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \53EF\80FD\4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285179911599873359)
,p_name=>'ADVISOR.CHECK.PAGE_ITEM_REF_AS_STRING.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \53EF\80FD\4E0D\662F\4E00\500B\9801\9762\6216\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180207400873360)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_CLEAR_CACHE_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664\5FEB\53D6\9801\9762 %1 (\5728\61C9\7528\7A0B\5F0F %0 \5167) \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180066102873359)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762 %0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180141555873359)
,p_name=>'ADVISOR.CHECK.PAGE_NUMBER_EXISTS.MSG_TARGET_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\6A19\9801\9762 %1 (\5728\61C9\7528\7A0B\5F0F %0 \5167) \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285605133237873671)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_COL_TOGGLE_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\8CC7\6599\6B04\5207\63DB\5340\57DF\4E2D\7684\8CC7\6599\6B04\90FD\6C92\6709\5C07\300C\4F5C\70BA\8CC7\6599\5217\6A19\982D\300D\8A2D\70BA\300C\662F\300D. \8CC7\6599\5217\6A19\982D\8CC7\6599\6B04\61C9\662F\6700\80FD\4EE3\8868\76EE\524D\8CC7\6599\5217\7684\8CC7\6599\6B04 (\4F8B\5982\5BA2\6236\8CC7\8A0A\5831\8868\4E2D\7684\5BA2\6236\540D\7A31).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285605266175873671)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_REFLOW_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\56DE\6D41\5831\8868\5340\57DF\4E2D\7684\8CC7\6599\6B04\90FD\6C92\6709\5C07\300C\4F5C\70BA\8CC7\6599\5217\6A19\982D\300D\8A2D\70BA\300C\662F\300D. \8CC7\6599\5217\6A19\982D\8CC7\6599\6B04\61C9\662F\6700\80FD\4EE3\8868\76EE\524D\8CC7\6599\5217\7684\8CC7\6599\6B04 (\4F8B\5982\5BA2\6236\8CC7\8A0A\5831\8868\4E2D\7684\5BA2\6236\540D\7A31).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681491269873726)
,p_name=>'ADVISOR.CHECK.REGION_HAS_ROW_HEADER.MSG_TABFORM_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\5217\8868\5316\8868\55AE\5340\57DF\4E2D\7684\8CC7\6599\6B04\90FD\6C92\6709\5C07\300C\4F5C\70BA\8CC7\6599\5217\6A19\982D\300D\8A2D\70BA\300C\662F\300D. \8CC7\6599\5217\6A19\982D\8CC7\6599\6B04\61C9\662F\6700\80FD\4EE3\8868\76EE\524D\8CC7\6599\5217\7684\8CC7\6599\6B04 (\4F8B\5982\5BA2\6236\8CC7\8A0A\8868\683C\4E2D\7684\5BA2\6236\540D\7A31). \6B64\8CC7\8A0A\6703\5728\5448\73FE\5217\8868\5316\8868\55AE\6642\4F7F\7528, \70BA\6BCF\500B\8CC7\6599\5217\7684\8868\55AE\6B04\4F4D\63D0\4F9B\552F\4E00\7684\6A19\7C64.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181885942873361)
,p_name=>'ADVISOR.CHECK.REPORT_DEFAULT_ORDER.MSG_NO_DEFAULT_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\6C92\6709\9810\8A2D\9806\5E8F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286284899144874154)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_BOOKMARK_CHECKSUM_FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\66F8\7C64\96DC\6E4A\51FD\6578\300D\8A2D\70BA\820A\6709\6F14\7B97\6CD5.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286284965556874154)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_APP_PROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\505C\7528\300C\968E\6BB5\4F5C\696D\72C0\614B\4FDD\8B77\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286399978904874244)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PAGE_PROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\5177\6709\64F7\53D6\8655\7406\4F5C\696D\7684\9801\9762\4E0A, \60A8\61C9\8A72\4F7F\7528\300C\9801\9762\5B58\53D6\4FDD\8B77\300D, \4E26\5C0D\900F\904E URL \50B3\905E\7684\9805\76EE\555F\7528\4FDD\8B77.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285138535345873329)
,p_name=>'ADVISOR.CHECK.SESSION_STATE_PROTECTION.MSG_NO_PREPARE_URL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\5305\542B\4E0D\662F\900F\904E APEX_UTIL.PREPARE_URL \50B3\9001\7684 "f?p" URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181004174873360)
,p_name=>'ADVISOR.CHECK.SQL_INJECTION.MSG_ITEM_SUBSTITUTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5075\6E2C\5230\53EF\80FD\7684 SQL \96B1\78BC\653B\64CA. SQL\3001PL/SQL \7A0B\5F0F\78BC\6216\8655\7406\4F5C\696D\8868\683C\540D\7A31\4E2D\7684\66FF\4EE3\8A9E\6CD5\4F7F\7528 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178890876873359)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178975789873359)
,p_name=>'ADVISOR.CHECK.SUBSTITUTION_SYNTAX.MSG_WRONG_REFERENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\53EF\4F7F\7528\66FF\4EE3\8A9E\6CD5\53C3\7167 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180892043873360)
,p_name=>'ADVISOR.CHECK.TARGET_PAGE_AUTH_USABILITY.MSG_NO_AUTH_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\6A19\9801\9762 %1 (\5728\61C9\7528\7A0B\5F0F %0 \5167) \5DF2\5B9A\7FA9\6388\6B0A\914D\7F6E, \4F46\76EE\524D\7684\5143\4EF6\672A\5B9A\7FA9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285681686072873726)
,p_name=>'ADVISOR.CHECK.THEME_STYLE_IS_ACCESSIBLE.MSG_NOT_ACCESSIBLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\76EE\524D\7684\4E3B\984C\6A23\5F0F\5C1A\672A\901A\904E\8F14\52A9\529F\80FD\6E2C\8A66. \8ACB\5207\63DB\6210\300C\8F14\52A9\529F\80FD\5DF2\6E2C\8A66\300D\8A2D\70BA\300C\662F\300D\7684\4E3B\984C\6A23\5F0F, \6216\8005\82E5\76EE\524D\7684\4E3B\984C\6A23\5F0F\5DF2\901A\904E\6E2C\8A66, \8ACB\5C07\5176\300C\4E3B\984C\300D\8A2D\5B9A\503C\4E0B\7684\300C\8F14\52A9\529F\80FD\5DF2\6E2C\8A66\300D\5C6C\6027\8A2D\70BA\300C\662F\300D.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285803668513873809)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_JQUERY_MIGRATE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4F7F\7528\8005\4ECB\9762\5305\62EC jQuery Migrate. \79FB\8F49\81F3\65B0\7248\7684 jQuery \6642, jQuery Migrate \53EF\56DE\5FA9\5DF2\79FB\9664\7684 API, \4E26\65BC\700F\89BD\5668\4E3B\63A7\53F0\4E2D\4F7F\7528\4E86\5DF2\79FB\9664\6216\5DF2\88AB\53D6\4EE3\7684 API \6642\986F\793A\8B66\544A. \5176\4E2D\5305\62EC\60A8\61C9\7528\7A0B\5F0F\4E2D\6BCF\500B\9801\9762\4E0A\7684\984D\5916 JavaScript \6A94\6848. \70BA\4E86\5354\52A9\79FB\9664\9019\4E9B\5167\5BB9, \8ACB\8907\67E5 jQuery Migrate \5347\7D1A\6307\5357, \4EE5\77AD\89E3\5FC5\9808\8B8A\66F4\7684 API \8A73\7D30\8CC7\8A0A, \7136\5F8C\5728\78BA\8A8D\61C9\7528\7A0B\5F0F\4E0D\518D\4F7F\7528\9019\4E9B API \4E4B\5F8C, \5C07\300C\5305\62EC jQuery Migrate\300D\8A2D\70BA\300C\5426\300D.'),
'',
'https://github.com/jquery/jquery-migrate'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285803548100873809)
,p_name=>'ADVISOR.CHECK.UI_INCLUDES_COMPATIBILITY_JS.MSG_LEGACY_JS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4ECB\9762\5305\62EC\5DF2\88AB\53D6\4EE3\6216\5DF2\4E0D\518D\652F\63F4\7684 JavaScript \51FD\6578. \5176\4E2D\5305\62EC\60A8 App \4E2D\6BCF\500B\9801\9762\4E0A\7684\984D\5916 JavaScript \6A94\6848. \70BA\4E86\5354\52A9\79FB\9664\9019\4E9B\5167\5BB9, \8ACB\8907\67E5\300C\7248\6B21\6CE8\610F\4E8B\9805\300D\4E2D\300C\5DF2\88AB\53D6\4EE3\7684\529F\80FD\300D\5C0F\7BC0, \60A8\53EF\4EE5\5728\6B64\627E\5230\5982\4F55\6AA2\67E5\5DF2\88AB\53D6\4EE3\6216\5DF2\4E0D\518D\652F\63F4\51FD\6578\4E4B\76F8\4F9D\6027\7684\6307\793A, \4E26\9032\4E00\6B65\57F7\884C\76F8\95DC\8655\7406, \8B93\60A8\7684 App \4E0D\518D\542B\6709\9019\4E9B\5167\5BB9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181554056873361)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5B9A\7FA9\76F8\95DC\300C\9805\76EE\300D\6216\300C\8CC7\6599\6B04\300D, \4F46\300C\932F\8AA4\8A0A\606F\986F\793A\4F4D\7F6E\300D\9700\8981\5B83.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181411091873360)
,p_name=>'ADVISOR.CHECK.VALIDATION_ASSOCIATED_ITEM.MSG_NOT_EQUAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\95DC\300C\9805\76EE\300D\6216\300C\8CC7\6599\6B04\300D\8207\300C\9A57\8B49\8868\793A\5F0F 1\300D\4E2D\6307\5B9A\7684 "%0" \4E0D\540C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180439917873360)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8B6F\932F\8AA4 - %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285180511088873360)
,p_name=>'ADVISOR.CHECK.VALID_SQL_PLSQL_CODE.MSG_NOT_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5B9A\7FA9 SQL \6216 PL/SQL \7A0B\5F0F\78BC.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285178798208873358)
,p_name=>'ADVISOR.CHECK.VERIFY_CLOB_PROPERTY.MSG_TOO_LONG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9577\5EA6\8D85\904E 32767 \500B\5B57\5143. \53EA\6703\6AA2\67E5\524D 32767 \500B\5B57\5143. \9577\5EA6: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181158006873360)
,p_name=>'ADVISOR.CHECK.V_FUNCTION_IN_SQL.MSG_CONTAINS_CALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \6558\8FF0\53E5\4E2D\5305\542B V/NV/DV \51FD\6578\547C\53EB (\53EF\80FD\6703\5C0E\81F4\6548\80FD\554F\984C).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285181733094873361)
,p_name=>'ADVISOR.CHECK.WHEN_BUTTON_PRESSED.MSG_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53C3\7167\7684\6309\9215\5DF2\4E0D\5B58\5728.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575280747873647)
,p_name=>'AFTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E4B\5F8C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285516599915873605)
,p_name=>'AGREEMENT_MISSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\907A\6F0F\5408\7D04')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285321449529873463)
,p_name=>'ALIAS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5225\540D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286027634465873965)
,p_name=>'ALLOW_APP_BUILDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\7D44\5EFA\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285944496778873904)
,p_name=>'ALLOW_PACKAGED_APP_INS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5141\8A31\5B89\88DD\751F\7522\529B\548C\7BC4\4F8B\61C9\7528\7A0B\5F0F.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285779730049873793)
,p_name=>'ALLOW_RESTFUL_SERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4F7F\7528 RESTful \670D\52D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286027715129873965)
,p_name=>'ALLOW_SQL_WORKSHOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4F7F\7528 SQL \5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286027975894873965)
,p_name=>'ALLOW_TEAM_DEVELOPMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4F7F\7528\5718\968A\958B\767C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286027523958873964)
,p_name=>'ALLOW_TO_BE_PURGED_YN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\5C07\5DE5\4F5C\5340\6C38\4E45\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286027892582873965)
,p_name=>'ALLOW_WEBSHEET_DEV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4F7F\7528 Web \8A66\7B97\8868\958B\767C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285340789489873477)
,p_name=>'ALL_APPLICATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285126524326873320)
,p_name=>'ALL_APPLICATIONS_NULL_DISP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \5168\90E8 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285126380130873320)
,p_name=>'ALL_CATEGORIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\985E\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285126668353873320)
,p_name=>'ALL_CATEGORIES_NULL_DISP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \6240\6709\985E\5225 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286030655431873967)
,p_name=>'ALL_MILESTONES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285708673951873744)
,p_name=>'ALL_RELEASES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\7248\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285346644989873481)
,p_name=>'ALL_STATIC_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\975C\614B\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285345236570873480)
,p_name=>'ALL_THEMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\4E3B\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286052379593873982)
,p_name=>'ALL_TYPES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286052792203873983)
,p_name=>'ALL_TYPES_NULL_DISP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \6240\6709\985E\578B -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285341861880873478)
,p_name=>'ALL_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\4F7F\7528\8005')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286394435803874240)
,p_name=>'ALREADY_IN_ACL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\5DF2\7D93\6709 APEX \5E33\6236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286384369508874232)
,p_name=>'ALREADY_IN_WS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\5DF2\7D93\5728\5DE5\4F5C\5340\4E2D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286345078716874199)
,p_name=>'ALWAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\5F8B\6210\7ACB')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285098050149873299)
,p_name=>'AM_PM'
,p_message_language=>'zh-tw'
,p_message_text=>'AM / PM'
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285591912560873661)
,p_name=>'ANALYSIS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\6790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285592071180873661)
,p_name=>'ANALYZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309 %0 \5206\6790')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285730978030873760)
,p_name=>'ANALYZE_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528 %0 \65B9\6CD5\5206\6790')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285199689921873374)
,p_name=>'ANCHOR.SHOW_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\986F\793A')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285344142605873480)
,p_name=>'ANONYMOUS_BLOCK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\533F\540D\5340\584A')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285186512979873364)
,p_name=>'ANSWERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B54\6848')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285138225961873329)
,p_name=>'ANY_DEVELOPER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('(\4EFB\4F55\958B\767C\4EBA\54E1)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286360126776874214)
,p_name=>'APEX.ACTIONS.TOGGLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5207\63DB %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286399341838874243)
,p_name=>'APEX.ACTIVE_STATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('(\4F5C\7528\4E2D)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286462982354874290)
,p_name=>'APEX.ACTIVITY_BY_HOUR.APPCHANGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8B8A\66F4:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286462893700874290)
,p_name=>'APEX.ACTIVITY_BY_HOUR.HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\6642:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286467636789874293)
,p_name=>'APEX.ACTIVITY_BY_HOUR.K'
,p_message_language=>'zh-tw'
,p_message_text=>'%0 K'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463029604874290)
,p_name=>'APEX.ACTIVITY_BY_HOUR.PAGEVIEWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6AA2\8996: ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285985035502873934)
,p_name=>'APEX.AJAX_SERVER_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Ajax \547C\53EB\91DD\5C0D %1 \50B3\56DE\4F3A\670D\5668\932F\8AA4 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286282437498874152)
,p_name=>'APEX.API.RUNTIME_API_USAGE.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5DF2\7981\6B62 API \547C\53EB.'),
unistr('\8ACB\6D3D\8A62\60A8\7684\7BA1\7406\54E1.'),
unistr('\6709\95DC\6B64\672A\9810\671F\4E8B\4EF6\7684\8A73\7D30\8CC7\8A0A, \8ACB\900F\904E\9664\932F ID "%0" \4F86\53D6\5F97.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285389141012873512)
,p_name=>'APEX.APPLICATION.ALIAS.NON_UNIQUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\5C07\61C9\7528\7A0B\5F0F\5225\540D "%0" \8F49\63DB\6210\552F\4E00\7684\61C9\7528\7A0B\5F0F ID.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285389260935873512)
,p_name=>'APEX.APPLICATION.ALIAS.NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5B58\5728\5225\540D\70BA "%0" \7684\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285346855814873482)
,p_name=>'APEX.APPLICATION.ALIAS.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('ERR-1816 \8F49\63DB\61C9\7528\7A0B\5F0F\5225\540D p_flow_alias_or_id (%0) \6642\767C\751F\672A\9810\671F\7684\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285215686270873386)
,p_name=>'APEX.ASSERT.DESUPPORTED_API'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Application Express \7248\672C %1 \5DF2\4E0D\518D\652F\63F4 API \547C\53EB "%0". \6709\95DC\6B64\672A\9810\671F\4E8B\4EF6\7684\8A73\7D30\8CC7\8A0A, \8ACB\900F\904E\9664\932F ID "%2" \4F86\53D6\5F97.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285222365819873391)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNC.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8A8D\8B49\51FD\6578\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285109913637873308)
,p_name=>'APEX.AUTHENTICATION.AUTH_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8A8D\8B49\51FD\6578\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286477794390874301)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.HOST_PREFIX_MISMATCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A Oracle Cloud Identity Management \50B3\56DE\7684\79DF\7528\6236\540D\7A31 %0 \4F7F\7528\7DB2\57DF %1!<br/>\8ACB<a href="&LOGOUT_URL.">\91CD\65B0\767B\5165</a>\4E26\6307\5B9A\6388\6B0A\7684\79DF\7528\6236\540D\7A31, \6216\8005\8B8A\66F4\60A8\7684 URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285103009866873303)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.USER_IS_NOT_DEVELOPER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5E33\6236 "%0" \6C92\6709\5DE5\4F5C\5340 "%1" \7684\5FC5\8981\958B\767C\6B0A\9650 (DB_DEVELOPER \6216 DB_ADMINISTRATOR)!<br/> \8ACB\5728\7372\5F97\6B0A\9650\4E4B\5F8C<a href="&LOGOUT_URL.">\91CD\65B0\767B\5165</a>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285098475649873300)
,p_name=>'APEX.AUTHENTICATION.CLOUD_IDM.WRONG_GROUP_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A Oracle Cloud Identity Management \50B3\56DE\7684\79DF\7528\6236\540D\7A31\4F7F\7528\76EE\524D\7684\5DE5\4F5C\5340!<br/>\8ACB<a href="&LOGOUT_URL.">\91CD\65B0\767B\5165</a>\4E26\6307\5B9A\6388\6B0A\7684\79DF\7528\6236\540D\7A31.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285236643912873401)
,p_name=>'APEX.AUTHENTICATION.HEADER.DUPLICATE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('HTTP \6A19\982D %0 \50B3\9001\4E86\5169\6B21, \9019\6709\53EF\80FD\662F\653B\64CA.'),
'<ul>',
unistr('<li>\7B2C\4E00\500B\503C: "%1"</li>'),
unistr('<li>\7B2C\4E8C\500B\503C: "%2"</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285103281171873303)
,p_name=>'APEX.AUTHENTICATION.HOST_PREFIX_MISMATCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57FA\65BC\5B89\5168\56E0\7D20, \4E0D\5141\8A31\4EE5 URL \4E2D\7684\7DB2\57DF\57F7\884C\6B64\5DE5\4F5C\5340\7684\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285222019575873390)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.ASK_FOR_INSTALLATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\8981\6C42\60A8\7684 DBA \57F7\884C $OH/rdbms/admin/catldap.sql.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285221983320873390)
,p_name=>'APEX.AUTHENTICATION.LDAP.DBMS_LDAP.MISSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SYS.DBMS_LDAP \5957\88DD\7A0B\5F0F\4E0D\5B58\5728\6216\7121\6548.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285221829282873390)
,p_name=>'APEX.AUTHENTICATION.LDAP.EDIT_USER_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\7DE8\8F2F LDAP \4F7F\7528\8005\51FD\6578\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285222159378873391)
,p_name=>'APEX.AUTHENTICATION.LDAP.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406 LDAP \8A8D\8B49\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285223315764873391)
,p_name=>'APEX.AUTHENTICATION.LOGIN.ILLEGAL_PAGE_ARG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('login_page \7A0B\5E8F\7684 p_flow_page \5F15\6578\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285222836472873391)
,p_name=>'APEX.AUTHENTICATION.LOGIN.INVALID_ARG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1 \4E2D\7684 p_session \7121\6548.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285222644317873391)
,p_name=>'APEX.AUTHENTICATION.LOGIN.MALFORMED_ARGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2 \7684\5F15\6578\683C\5F0F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285223000638873391)
,p_name=>'APEX.AUTHENTICATION.LOGIN.NULL_USER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\81F3\767B\5165\7A0B\5E8F\7684\4F7F\7528\8005\540D\7A31\662F\7A7A\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122725788873317)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.COUNTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\7B49\5019 <span id="apex_login_throttle_sec">%0</span> \79D2\4EE5\518D\6B21\767B\5165.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285127790472873321)
,p_name=>'APEX.AUTHENTICATION.LOGIN_THROTTLE.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\767B\5165\5617\8A66\5DF2\88AB\5C01\9396.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285563050636873639)
,p_name=>'APEX.AUTHENTICATION.NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\8A8D\8B49 "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285136381379873327)
,p_name=>'APEX.AUTHENTICATION.NO_SECURITY_GROUP_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\5168\6027\7FA4\7D44 ID \662F\7A7A\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285222531054873391)
,p_name=>'APEX.AUTHENTICATION.POST_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\8A8D\8B49\5F8C\8655\7406\4F5C\696D\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285222243443873391)
,p_name=>'APEX.AUTHENTICATION.PRE_AUTH_PROC.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8A8D\8B49\524D\8655\7406\4F5C\696D\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285241743250873405)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD.INSTRUCTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\5728\8D77\59CB\300C\91CD\8A2D\5BC6\78BC\300D\8981\6C42\7684\76F8\540C\700F\89BD\5668\4E2D\958B\555F\6B64 URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286462122799874289)
,p_name=>'APEX.AUTHENTICATION.RESET_PASSWORD_URL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8A2D\5BC6\78BC URL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285103456292873303)
,p_name=>'APEX.AUTHENTICATION.RM_GROUP_NOT_GRANTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C1A\672A\5C07\8CC7\6E90\7BA1\7406\7A0B\5F0F\7528\6236\7FA4\7D44 %0 \6388\4E88 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285103588639873303)
,p_name=>'APEX.AUTHENTICATION.RM_INFO_TO_GRANT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\4F7F\7528 DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP \6388\4E88\7F3A\5C11\7684\6B0A\9650.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285299599382873447)
,p_name=>'APEX.AUTHENTICATION.SESSION_SENTRY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\968E\6BB5\4F5C\696D\611F\6E2C\51FD\6578\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285299649533873447)
,p_name=>'APEX.AUTHENTICATION.SESSION_VERIFY_FUNCTION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\968E\6BB5\4F5C\696D\9A57\8B49\51FD\6578\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285299840084873447)
,p_name=>'APEX.AUTHENTICATION.SSO.ASK_FOR_INSTALLATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\8981\6C42\60A8\7684 %0 \7BA1\7406\54E1\8A2D\5B9A Oracle Application Server Single Sign-On \5F15\64CE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285375939127873503)
,p_name=>'APEX.AUTHENTICATION.SSO.BAD_URLC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('sso \50B3\56DE\4E4B %1 \6B0A\6756\4E2D\7684 %0 \7121\6548.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285223265019873391)
,p_name=>'APEX.AUTHENTICATION.SSO.FIX_PARTNER_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\7DE8\8F2F\8A8D\8B49\914D\7F6E\4E26\65B0\589E\61C9\7528\7A0B\5F0F\540D\7A31.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285375518464873502)
,p_name=>'APEX.AUTHENTICATION.SSO.ILLEGAL_CALLER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \7A0B\5E8F\7684\547C\53EB\7AEF\7121\6548:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285375791581873503)
,p_name=>'APEX.AUTHENTICATION.SSO.INVALID_APP_SESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('urlc \6B0A\6756\4E2D\7684\61C9\7528\7A0B\5F0F\968E\6BB5\4F5C\696D\7121\6548: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285375386374873502)
,p_name=>'APEX.AUTHENTICATION.SSO.MISSING_APP_REGISTRATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('portal_sso_redirect \767C\751F\932F\8AA4: \6C92\6709\61C9\7528\7A0B\5F0F\8A3B\518A\8CC7\8A0A: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285299707010873447)
,p_name=>'APEX.AUTHENTICATION.SSO.PACKAGE_MISSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('WWSEC_SSO_ENABLER_PRIVATE \5957\88DD\7A0B\5F0F\4E0D\5B58\5728\6216\7121\6548.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285223190287873391)
,p_name=>'APEX.AUTHENTICATION.SSO.PARTNER_APP_IS_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\8A8D\8B49\914D\7F6E\4E2D\627E\4E0D\5230\8A3B\518A\7684\5925\4F34\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285375425964873502)
,p_name=>'APEX.AUTHENTICATION.SSO.REGISTER_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\4F9D\7167\5B89\88DD\6307\5357\7684\8AAA\660E\4F86\8A3B\518A\6B64\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285299946109873447)
,p_name=>'APEX.AUTHENTICATION.SSO.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406 SSO \8A8D\8B49\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378914800874228)
,p_name=>'APEX.AUTHENTICATION.UNAUTHORIZED_URL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A\7684 URL:  %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285299395139873447)
,p_name=>'APEX.AUTHENTICATION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8A8D\8B49\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285103303021873303)
,p_name=>'APEX.AUTHENTICATION.WORKSPACE_NOT_ASSIGNED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340 "%0" \975E\4F5C\7528\4E2D. \8ACB\6D3D\8A62\60A8\7684\7BA1\7406\54E1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285104560968873304)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED'
,p_message_language=>'zh-tw'
,p_message_text=>'%0'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285125206646873319)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\61C9\7528\7A0B\5F0F\300D\5B89\5168\6027\6AA2\67E5\62D2\7D55\5B58\53D6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285125362487873319)
,p_name=>'APEX.AUTHORIZATION.ACCESS_DENIED.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\9801\9762\300D\5B89\5168\6027\6AA2\67E5\62D2\7D55\5B58\53D6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285125428862873319)
,p_name=>'APEX.AUTHORIZATION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\6388\6B0A\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285602235910873669)
,p_name=>'APEX.AUTO_COMPLETE.NOT_IN_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\55AE\4E2D\6C92\6709 #LABEL# \5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285984600925873933)
,p_name=>'APEX.BRANCH.SHOW_ONLY_NOT_SUPPORTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\9001\51FA\6642\91CD\65B0\8F09\5165\300D\9801\9762\5C6C\6027\82E5\8A2D\70BA\300C\50C5\5728\6210\529F\6642\8F09\5165\300D, \5C31\4E0D\652F\63F4\300C\50C5\986F\793A\5206\652F\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285349661980873484)
,p_name=>'APEX.BRANCH.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\5206\652F\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285670183305873718)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528 %1 %0 \5EFA\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285670298393873718)
,p_name=>'APEX.BUILT_WITH_LOVE_USING_APEX.ACCESSIBLE.LOVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AA0\5FC3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285706814227873743)
,p_name=>'APEX.CALCULATOR.ICON_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5373\73FE\5F0F\8A08\7B97\6A5F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286334928766874191)
,p_name=>'APEX.CALENDAR.EVENT_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\63CF\8FF0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286334725544874191)
,p_name=>'APEX.CALENDAR.EVENT_END'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\675F\65E5\671F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286335026808874191)
,p_name=>'APEX.CALENDAR.EVENT_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6 ID')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286334624685874191)
,p_name=>'APEX.CALENDAR.EVENT_START'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\59CB\65E5\671F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286334832101874191)
,p_name=>'APEX.CALENDAR.EVENT_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\6A19\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285802912427873808)
,p_name=>'APEX.CLIPBOARD.COPIED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8907\88FD\5230\526A\8CBC\7C3F.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285795934773873804)
,p_name=>'APEX.CLIPBOARD.NOTSUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\700F\89BD\5668\4E0D\652F\63F4\5F9E\6309\9215\6216\529F\80FD\8868\9032\884C\8907\88FD. \8ACB\5617\8A66 Ctrl+C \6216 Command+C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285672225183873719)
,p_name=>'APEX.CLOSE_NOTIFICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589\901A\77E5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285094098198873296)
,p_name=>'APEX.COLOR_PICKER.ICON_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5373\73FE\5F0F\8272\5F69\9078\64C7\5668: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286448114055874279)
,p_name=>'APEX.COMBOBOX.LIST_OF_VALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\6E05\55AE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286448225485874279)
,p_name=>'APEX.COMBOBOX.SHOW_ALL_VALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\555F\6E05\55AE: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286399468691874243)
,p_name=>'APEX.COMPLETED_STATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('(\5DF2\5B8C\6210)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285104721838873304)
,p_name=>'APEX.COMPUTATION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\904B\7B97\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285327021671873467)
,p_name=>'APEX.CONDITION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\689D\4EF6\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285389743828873513)
,p_name=>'APEX.CONDITION.UNKNOWN_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\660E\7684\689D\4EF6\985E\578B "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285354905171873487)
,p_name=>'APEX.CONTACT_ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\6D3D\8A62\60A8\7684\61C9\7528\7A0B\5F0F\7BA1\7406\54E1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285437291074873547)
,p_name=>'APEX.CONTACT_ADMIN.DEBUG'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8ACB\6D3D\8A62\60A8\7684\61C9\7528\7A0B\5F0F\7BA1\7406\54E1.'),
unistr('\6709\95DC\6B64\672A\9810\671F\4E8B\4EF6\7684\8A73\7D30\8CC7\8A0A, \8ACB\900F\904E\9664\932F ID "%0" \4F86\53D6\5F97.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321916074874182)
,p_name=>'APEX.CORRECT_ERRORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\5148\66F4\6B63\932F\8AA4\5F8C\518D\5132\5B58.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286403648468874246)
,p_name=>'APEX.CURRENT_PROGRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\9032\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286022904592873961)
,p_name=>'APEX.DATA_HAS_CHANGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\4E2D\7684\76EE\524D\8CC7\6599\7248\672C\81EA\4F7F\7528\8005\8D77\59CB\66F4\65B0\8655\7406\4F5C\696D\5F8C\5DF2\7D93\8B8A\66F4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285706759691873743)
,p_name=>'APEX.DATEPICKER.ICON_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5373\73FE\5F0F\884C\4E8B\66C6: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285715825955873749)
,p_name=>'APEX.DATEPICKER_VALUE_GREATER_MAX_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \5927\65BC\6307\5B9A\7684\6700\5927\65E5\671F %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285721103646873753)
,p_name=>'APEX.DATEPICKER_VALUE_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \4E0D\7B26\5408\683C\5F0F %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285715734147873749)
,p_name=>'APEX.DATEPICKER_VALUE_LESS_MIN_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \5C0F\65BC\6307\5B9A\7684\6700\5C0F\65E5\671F %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285715903931873749)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \4E0D\5728 %0 \5230 %1 \7684\6709\6548\7BC4\570D\4E4B\9593.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285719496086873752)
,p_name=>'APEX.DATEPICKER_VALUE_NOT_IN_YEAR_RANGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \4E0D\5728 %0 \5230 %1 \7684\6709\6548\5E74\5EA6\7BC4\570D\5167.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322678103874182)
,p_name=>'APEX.DIALOG.CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286428326653874265)
,p_name=>'APEX.DIALOG.CLOSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286433305340874268)
,p_name=>'APEX.DIALOG.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322439213874182)
,p_name=>'APEX.DIALOG.OK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285533821142873618)
,p_name=>'APEX.DIALOG.PAGE.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\9806\5229\5448\73FE\300C\61C9\7528\7A0B\5F0F %0 \5C0D\8A71\65B9\584A\300D\9801\9762 %1.  \8ACB\78BA\5B9A\9801\9762 %1 \4E0A\4F7F\7528\4E4B\9801\9762\6A23\677F\7684\6A23\677F\985E\578B\70BA\300C\5C0D\8A71\65B9\584A\9801\9762\300D, \4E14\5DF2\5B9A\7FA9\9069\7576\7684 JavaScript \5C0D\8A71\65B9\584A\521D\59CB\5316\3001\5C0D\8A71\65B9\584A\95DC\9589\53CA\5C0D\8A71\65B9\584A\53D6\6D88\7A0B\5F0F\78BC.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322530466874182)
,p_name=>'APEX.DIALOG.SAVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450064734874280)
,p_name=>'APEX.EMAIL.COPYRIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8457\4F5C\6B0A\6240\6709 &copy; %0, \4FDD\7559\4E00\5207\6B0A\5229.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450800951874281)
,p_name=>'APEX.EMAIL.CREATE_WORKSPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5DE5\4F5C\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286449903319874280)
,p_name=>'APEX.EMAIL.DISCLAIMER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\70BA\7CFB\7D71\7522\751F\8A0A\606F. \8ACB\52FF\56DE\8986\6B64\8A0A\606F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459792371874288)
,p_name=>'APEX.EMAIL.ENVIRONMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\74B0\5883')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286472310269874297)
,p_name=>'APEX.EMAIL.GENERIC_USER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Oracle Application Express \4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286451416006874281)
,p_name=>'APEX.EMAIL.GET_STARTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5165\9580')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450125358874280)
,p_name=>'APEX.EMAIL.GREETING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \60A8\597D,')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286451111490874281)
,p_name=>'APEX.EMAIL.PASSWORD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459821547874288)
,p_name=>'APEX.EMAIL.PREVENT_PURGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\6C38\4E45\6E05\9664\5DE5\4F5C\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286451398807874281)
,p_name=>'APEX.EMAIL.PURGE.BODY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\53EF\4EE5\6309\4E00\4E0B\4E0B\65B9\7684\6309\9215\4E26\4F9D\64DA\87A2\5E55\4E0A\7684\6307\793A\9032\884C\4F5C\696D, \8B93\60A8\7684\5DE5\4F5C\5340\4E0D\6703\88AB\6C38\4E45\6E05\9664. \5982\679C\60A8\672A\5728 %0 \5929\5167\9032\884C\6B64\4F5C\696D, \60A8\7684\5DE5\4F5C\5340\5C07\6703\81EA\52D5\88AB\79FB\9664.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459592477874287)
,p_name=>'APEX.EMAIL.PURGE.FOOTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\679C\60A8\5DF2\4E0D\518D\9700\8981\4F7F\7528\5DE5\4F5C\5340, \5C31\4E0D\9700\8981\63A1\53D6\52D5\4F5C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286460009643874288)
,p_name=>'APEX.EMAIL.PURGE.HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\5340\5373\5C07\88AB\6C38\4E45\6E05\9664!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459357194874287)
,p_name=>'APEX.EMAIL.PURGE.INTRO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\5340 %0 \6700\8FD1\4E26\7121\4EFB\4F55\6D3B\52D5, \56E0\6B64\6392\5B9A\70BA\5C07\65BC\8FD1\671F\6C38\4E45\6E05\9664.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459214872874287)
,p_name=>'APEX.EMAIL.PURGE.SUBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B66\544A! \60A8\7684\5DE5\4F5C\5340 "%0" \5373\5C07\88AB\6C38\4E45\6E05\9664.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459610434874287)
,p_name=>'APEX.EMAIL.PURGE_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C38\4E45\6E05\9664\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286460384315874288)
,p_name=>'APEX.EMAIL.REQUEST_ACTION_REQ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\5B8C\6210\60A8\7684\5DE5\4F5C\5340\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286460166916874288)
,p_name=>'APEX.EMAIL.REQUEST_APPROVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\5340 "%0" \5DF2\5C31\7DD2!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286460470432874288)
,p_name=>'APEX.EMAIL.REQUEST_APPROVE_2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\5340 "%0" \5DF2\7D93\6838\51C6!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286460250230874288)
,p_name=>'APEX.EMAIL.REQUEST_DECLINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\5340\8981\6C42\88AB\62D2\7D55.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450796284874281)
,p_name=>'APEX.EMAIL.USERNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459986222874288)
,p_name=>'APEX.EMAIL.WARNING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B66\544A!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450673864874281)
,p_name=>'APEX.EMAIL.WORKSPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450295994874281)
,p_name=>'APEX.EMAIL.WS_REQ_APPR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340\8981\6C42\5DF2\6838\51C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450966208874281)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_FOOTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4E00\4E0B\4E0B\65B9\7684\6309\9215\4EE5\5B8C\6210\6838\51C6\8655\7406\4F5C\696D, \4E26\8A2D\5B9A\60A8\7684\5BC6\78BC.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450498376874281)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_INTRO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\5340\8981\6C42\5DF2\7D93\6838\51C6!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286451084169874281)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_FOOTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\6309\4E00\4E0B\4E0B\65B9\7684\6309\9215\4EE5\958B\59CB\9032\884C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286451288502874281)
,p_name=>'APEX.EMAIL.WS_REQ_APPR_READY_INTRO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\5DE5\4F5C\5340\5DF2\5C31\7DD2!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450359146874281)
,p_name=>'APEX.EMAIL.WS_REQ_DECL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340\8981\6C42\88AB\62D2\7D55')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286450523058874281)
,p_name=>'APEX.EMAIL.WS_REQ_DECL_INTRO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\62B1\6B49, \60A8\7684\5DE5\4F5C\5340\8981\6C42\88AB\62D2\7D55.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285349979408873484)
,p_name=>'APEX.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285100278409873301)
,p_name=>'APEX.ERROR.CALLBACK_FAILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\932F\8AA4\8655\7406\56DE\547C\6642\767C\751F\4E0B\5217\932F\8AA4: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285141387188873331)
,p_name=>'APEX.ERROR.ERROR_PAGE.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E6A\88FD\932F\8AA4\9801\9762\6642\767C\751F\932F\8AA4: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285104025610873304)
,p_name=>'APEX.ERROR.INTERNAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5167\90E8\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286392413171874238)
,p_name=>'APEX.ERROR.INTERNAL.CONTACT_ADMINISTRATOR'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8ACB\6D3D\8A62\60A8\7684\7BA1\7406\54E1.'),
unistr('\6709\95DC\6B64\672A\9810\671F\4E8B\4EF6\7684\8A73\7D30\8CC7\8A0A, \8ACB\900F\904E\9664\932F ID "%0" \4F86\53D6\5F97.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286473253314874298)
,p_name=>'APEX.ERROR.ORA-28353'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('ORA-28353: \7121\6CD5\958B\555F\516C\4E8B\5305. \61C9\7528\7A0B\5F0F\8CC7\6599\76EE\524D\7121\6CD5\5B58\53D6.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286374689602874225)
,p_name=>'APEX.ERROR.PAGE_NOT_AVAILABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\62B1\6B49, \6B64\9801\9762\4E0D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285109858994873308)
,p_name=>'APEX.ERROR.TECHNICAL_INFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6280\8853\8CC7\8A0A (\552F\6709\958B\767C\4EBA\54E1\80FD\5920\898B\5230)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285937649618873899)
,p_name=>'APEX.ERROR_MESSAGE_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4\8A0A\606F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286011513662873953)
,p_name=>'APEX.EXPECTED_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\671F\683C\5F0F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735156488873763)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.ALREADY_IN_ACL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\5DF2\5728\5B58\53D6\63A7\5236\6E05\55AE\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735086760873763)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.CREATE_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\78BA\8A8D\8981\5C07\4E0B\5217 %0 \4F4D <strong>%1</strong> \4F7F\7528\8005\65B0\589E\81F3\60A8\7684\5B58\53D6\63A7\5236\6E05\55AE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735575445873763)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.DUPLICATE_USE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\5728\91CD\8907\7684\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735214098873763)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_AT_SIGN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\96FB\5B50\90F5\4EF6\5730\5740\300D\4E2D\907A\6F0F at \7B26\865F (@)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735377974873763)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.MISSING_DO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\96FB\5B50\90F5\4EF6\5730\5740\300D\4E2D\907A\6F0F\53E5\865F (.)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735465500873763)
,p_name=>'APEX.FEATURE.ACL.BULK_USER.USERNAME_TOO_LONG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31\592A\9577')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735755804873763)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_ONLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EA\6709\61C9\7528\7A0B\5F0F\5B58\53D6\63A7\5236\6E05\55AE\4E2D\5B9A\7FA9\7684\4F7F\7528\8005\53EF\4EE5\5B58\53D6\6B64\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735820521873763)
,p_name=>'APEX.FEATURE.ACL.INFO.ACL_VALUE_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\9810\671F\7684\5B58\53D6\63A7\5236\8A2D\5B9A\503C: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735673214873763)
,p_name=>'APEX.FEATURE.ACL.INFO.ALL_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\5DF2\8A8D\8B49\7684\4F7F\7528\8005\90FD\53EF\4EE5\5B58\53D6\6B64\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286281260691874151)
,p_name=>'APEX.FEATURE.CONFIG.DISABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\505C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286281175604874151)
,p_name=>'APEX.FEATURE.CONFIG.ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\555F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286282245417874152)
,p_name=>'APEX.FEATURE.CONFIG.IS_DISABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0: \5DF2\505C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286281317442874152)
,p_name=>'APEX.FEATURE.CONFIG.IS_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0: \5DF2\555F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285670952105873718)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.QUEUED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6392\5165\4F47\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285671046594873718)
,p_name=>'APEX.FEATURE.EMAIL_REPORTING.SENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\50B3\9001')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286281029349874151)
,p_name=>'APEX.FEATURE.TOP_USERS.USERNAME.NOT_IDENTIFIED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\8B58\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285134628460873326)
,p_name=>'APEX.FEEDBACK.FEEDBACK_ENTRIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\610F\898B\56DE\994B\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285134793402873326)
,p_name=>'APEX.FEEDBACK.OPEN_FEEDBACK_ENTRIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F85\8655\7406\7684\610F\898B\56DE\994B\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285134868930873326)
,p_name=>'APEX.FEEDBACK.USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286024635811873962)
,p_name=>'APEX.FILE_BROWSE.DOWNLOAD_LINK_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\8F09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286017881798873957)
,p_name=>'APEX.FS.BATCH_APPLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018367895873958)
,p_name=>'APEX.FS.CLEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018430578873958)
,p_name=>'APEX.FS.CLEAR_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018533161873958)
,p_name=>'APEX.FS.CLEAR_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286349102453874202)
,p_name=>'APEX.FS.COLUMN_UNAUTHORIZED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9762\5411 %0 \6240\53C3\7167\7684\8CC7\6599\6B04 %1 \7121\6CD5\4F7F\7528\6216\672A\7D93\6388\6B0A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286341508966874196)
,p_name=>'APEX.FS.FACET_VALUE_LIMIT_EXCEEDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8D85\51FA\9762\5411 %1 \7684\76F8\7570\503C\9650\5236 (%0).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286020045042873959)
,p_name=>'APEX.FS.FC_TYPE_UNSUPPORTED_FOR_DATE_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('DATE \6216 TIMESTAMP \8CC7\6599\6B04\4E0D\652F\63F4\9762\5411 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286017939332873957)
,p_name=>'APEX.FS.FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018065657873958)
,p_name=>'APEX.FS.GO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019695381873959)
,p_name=>'APEX.FS.INPUT_CURRENT_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B49\65BC %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019836231873959)
,p_name=>'APEX.FS.NO_SEARCH_COLUMNS_PROVIDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\91DD\5C0D\9762\5411 %0 \63D0\4F9B\4EFB\4F55\641C\5C0B\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019318317873958)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \81F3 %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019415080873959)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_HI'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9AD8\65BC %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019535136873959)
,p_name=>'APEX.FS.RANGE_CURRENT_LABEL_OPEN_LO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F4E\65BC %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286359912337874214)
,p_name=>'APEX.FS.RANGE_LOV_ITEM_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\570D\9762\5411 %0 \7684 LOV \9805\76EE #%2 ("%1") \7121\6548 (\907A\6F0F "|" \5340\9694\7B26\865F).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019737051873959)
,p_name=>'APEX.FS.RANGE_MANUAL_NOT_SUPPORTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\4E0D\652F\63F4\624B\52D5\8F38\5165\7BC4\570D\9762\5411 %0, \56E0\70BA\8CC7\6599\6B04\70BA DATE \6216 TIMESTAMP.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018934480873958)
,p_name=>'APEX.FS.RANGE_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018279356873958)
,p_name=>'APEX.FS.SEARCH_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018112882873958)
,p_name=>'APEX.FS.SEARCH_PLACEHOLDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019172355873958)
,p_name=>'APEX.FS.SELECT_PLACEHOLDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018792976873958)
,p_name=>'APEX.FS.SHOW_LESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\8F03\5C11\9805\76EE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018812387873958)
,p_name=>'APEX.FS.SHOW_MORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\66F4\591A\9805\76EE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019006790873958)
,p_name=>'APEX.FS.STAR_RATING_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \9846\661F\4EE5\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286019929219873959)
,p_name=>'APEX.FS.TEXT_FIELD_ONLY_FOR_NUMBER_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\50C5 NUMBER \8CC7\6599\6B04\652F\63F4\6587\5B57\6B04\4F4D\9762\5411 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286349340297874202)
,p_name=>'APEX.FS.UNSUPPORTED_DATA_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\591A\9762\5411\641C\5C0B\4E0D\652F\63F4 %0 \8CC7\6599\985E\578B (%1).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286282801990874153)
,p_name=>'APEX.GO_TO_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D\5F80\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285495738788873590)
,p_name=>'APEX.GROUP.NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\7FA4\7D44 "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285741696615873767)
,p_name=>'APEX.GV.AGG_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\805A\7E3D.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850263233873840)
,p_name=>'APEX.GV.BREAK_COLLAPSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285741798754873767)
,p_name=>'APEX.GV.BREAK_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63A7\5236\5206\6BB5.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850136124873840)
,p_name=>'APEX.GV.BREAK_EXPAND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C55\958B\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286479440659874302)
,p_name=>'APEX.GV.COLUMN_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04 %0.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285849972255873840)
,p_name=>'APEX.GV.DELETED_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\522A\9664 %0 \500B\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286438919397874272)
,p_name=>'APEX.GV.DUP_REC_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8907\7684\8B58\5225')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728667640873759)
,p_name=>'APEX.GV.FIRST_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C\4E00\500B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285741982176873767)
,p_name=>'APEX.GV.GROUP_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44\6A19\982D.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285741867607873767)
,p_name=>'APEX.GV.HEADER_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\982D.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728721622873759)
,p_name=>'APEX.GV.LAST_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\500B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890581905873867)
,p_name=>'APEX.GV.LOAD_MORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F09\5165\5176\4ED6\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728438517873758)
,p_name=>'APEX.GV.NEXT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285742069330873767)
,p_name=>'APEX.GV.PAGE_RANGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728861809873759)
,p_name=>'APEX.GV.PAGE_RANGE_XY'
,p_message_language=>'zh-tw'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728936052873759)
,p_name=>'APEX.GV.PAGE_RANGE_XYZ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 - %1, \5171 %2')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728556337873758)
,p_name=>'APEX.GV.PREV_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286438738519874272)
,p_name=>'APEX.GV.ROW_ADDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\65B0\589E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286438865485874272)
,p_name=>'APEX.GV.ROW_CHANGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8B8A\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286479252297874302)
,p_name=>'APEX.GV.ROW_COLUMN_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217 %0, \8CC7\6599\6B04 %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286479399935874302)
,p_name=>'APEX.GV.ROW_CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217 %0.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286438614985874272)
,p_name=>'APEX.GV.ROW_DELETED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\522A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285770831413873787)
,p_name=>'APEX.GV.ROW_HEADER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\6A19\982D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285727734946873758)
,p_name=>'APEX.GV.SELECTION_CELL_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9078\53D6 %0 \500B\5132\5B58\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285729023069873759)
,p_name=>'APEX.GV.SELECTION_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9078\53D6 %0 \500B\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286074489920873998)
,p_name=>'APEX.GV.SELECT_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\9078')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850056694873840)
,p_name=>'APEX.GV.SELECT_PAGE_N'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C %0 \9801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285770730598873787)
,p_name=>'APEX.GV.SELECT_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773350067873788)
,p_name=>'APEX.GV.SORTED_ASCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\589E\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773404234873789)
,p_name=>'APEX.GV.SORTED_DESCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\6E1B\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285727907744873758)
,p_name=>'APEX.GV.SORT_ASCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\589E\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728237824873758)
,p_name=>'APEX.GV.SORT_ASCENDING_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\589E\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728096328873758)
,p_name=>'APEX.GV.SORT_DESCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\6E1B\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728343814873758)
,p_name=>'APEX.GV.SORT_DESCENDING_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\6E1B\6392\5E8F %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285728114651873758)
,p_name=>'APEX.GV.SORT_OFF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285849855012873840)
,p_name=>'APEX.GV.TOTAL_PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\6578 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286413154246874253)
,p_name=>'APEX.HELP.VIEW_DOC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286432656413874268)
,p_name=>'APEX.ICON_LIST.GRID_DIM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\683C\9078\53D6\6E05\55AE %0 \8CC7\6599\6B04 %1 \8CC7\6599\5217. \4F7F\7528\65B9\5411\9375')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285848941091873839)
,p_name=>'APEX.ICON_LIST.LIST_DIM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\6E05\55AE %0 \8CC7\6599\5217. \4F7F\7528\65B9\5411\9375')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286479033029874302)
,p_name=>'APEX.IG.ACC_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\52D5\5F0F\65B9\683C %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711191021873746)
,p_name=>'APEX.IG.ACTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712153504873747)
,p_name=>'APEX.IG.ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712047579873747)
,p_name=>'APEX.IG.ADD_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286446761655874278)
,p_name=>'APEX.IG.AGGREGATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\805A\7E3D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286409697832874251)
,p_name=>'APEX.IG.AGGREGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\805A\7E3D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412693516874253)
,p_name=>'APEX.IG.ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285969848879873923)
,p_name=>'APEX.IG.ALL_TEXT_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\6587\5B57\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971041726873923)
,p_name=>'APEX.IG.ALTERNATIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66FF\4EE3\9805\76EE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972199763873924)
,p_name=>'APEX.IG.AND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E14')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286318160438874179)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8FD1\4F3C\76F8\7570\8A08\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447724777874279)
,p_name=>'APEX.IG.APPROX_COUNT_DISTINCT_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\8FD1\4F3C\76F8\7570\8A08\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405734164874248)
,p_name=>'APEX.IG.AREA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411221918874252)
,p_name=>'APEX.IG.ASCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\589E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971158226873924)
,p_name=>'APEX.IG.AUTHORIZATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6388\6B0A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286446826850874278)
,p_name=>'APEX.IG.AUTO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\52D5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286318507018874179)
,p_name=>'APEX.IG.AVG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E73\5747\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447437749874278)
,p_name=>'APEX.IG.AVG_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\5E73\5747\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405286932874248)
,p_name=>'APEX.IG.AXIS_LABEL_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64\8EF8\6A19\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405401528874248)
,p_name=>'APEX.IG.AXIS_VALUE_DECIMAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\6578\4F4D\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405392587874248)
,p_name=>'APEX.IG.AXIS_VALUE_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\503C\8EF8\6A19\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419433901874258)
,p_name=>'APEX.IG.BACKGROUND_COLOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\80CC\666F\8272\5F69')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405877125874248)
,p_name=>'APEX.IG.BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9577\689D\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953577838873910)
,p_name=>'APEX.IG.BETWEEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4ECB\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286421142636874259)
,p_name=>'APEX.IG.BOTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8C\8005')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405945238874248)
,p_name=>'APEX.IG.BUBBLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6CE1\6CE1\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712335289873747)
,p_name=>'APEX.IG.CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972039073873924)
,p_name=>'APEX.IG.CASE_SENSITIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6709\5927\5C0F\5BEB\4E4B\5225')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286448339668874279)
,p_name=>'APEX.IG.CASE_SENSITIVE_WITH_BRACKETS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('(\6709\5927\5C0F\5BEB\4E4B\5225)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286357829330874213)
,p_name=>'APEX.IG.CHANGES_SAVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5132\5B58\8B8A\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712785341873747)
,p_name=>'APEX.IG.CHANGE_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285973184982873925)
,p_name=>'APEX.IG.CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285968540448873922)
,p_name=>'APEX.IG.CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\67E5\8A62\8D85\51FA\6BCF\4E00\5716\8868 %0 \500B\8CC7\6599\9EDE\7684\6578\76EE\4E0A\9650. \8ACB\5957\7528\7BE9\9078\689D\4EF6\4F86\6E1B\5C11\60A8\57FA\790E\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711004219873746)
,p_name=>'APEX.IG.CHART_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774326305873789)
,p_name=>'APEX.IG.CLEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404702602874247)
,p_name=>'APEX.IG.CLOSE_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6536\76E4\50F9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420135869874259)
,p_name=>'APEX.IG.COLORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8272\5F69')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420077393874258)
,p_name=>'APEX.IG.COLOR_BLUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\85CD\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419951978874258)
,p_name=>'APEX.IG.COLOR_GREEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DA0\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419767486874258)
,p_name=>'APEX.IG.COLOR_ORANGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A59\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419822755874258)
,p_name=>'APEX.IG.COLOR_RED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D05\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419694377874258)
,p_name=>'APEX.IG.COLOR_YELLOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9EC3\8272')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971415147873924)
,p_name=>'APEX.IG.COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711276484873746)
,p_name=>'APEX.IG.COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286424983376874262)
,p_name=>'APEX.IG.COLUMN_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\7528\9014')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971523445873924)
,p_name=>'APEX.IG.COMPLEX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\96DC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711427895873746)
,p_name=>'APEX.IG.COMPUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954141155873911)
,p_name=>'APEX.IG.CONTAINS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\542B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285977439491873928)
,p_name=>'APEX.IG.CONTROL_BREAK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774117661873789)
,p_name=>'APEX.IG.COPY_CB'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\5230\526A\8CBC\7C3F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774296564873789)
,p_name=>'APEX.IG.COPY_DOWN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286317980370874179)
,p_name=>'APEX.IG.COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286318094906874179)
,p_name=>'APEX.IG.COUNT_DISTINCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7570\8A08\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447669758874279)
,p_name=>'APEX.IG.COUNT_DISTINCT_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\76F8\7570\8A08\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447547259874279)
,p_name=>'APEX.IG.COUNT_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\8A08\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286439061055874272)
,p_name=>'APEX.IG.CREATE_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970089692873923)
,p_name=>'APEX.IG.DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286422338589874260)
,p_name=>'APEX.IG.DATA_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\985E\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286421370834874259)
,p_name=>'APEX.IG.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286357667952874212)
,p_name=>'APEX.IG.DATE_INVALID_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\65E5\671F\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285955070826873911)
,p_name=>'APEX.IG.DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970733606873923)
,p_name=>'APEX.IG.DEFAULT_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\503C')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970593998873923)
,p_name=>'APEX.IG.DEFAULT_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\985E\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712244818873747)
,p_name=>'APEX.IG.DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425988250874263)
,p_name=>'APEX.IG.DELETE_REPORT_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\5B9A\8981\522A\9664\6B64\5831\8868\55CE?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979273447873929)
,p_name=>'APEX.IG.DELETE_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978091007873929)
,p_name=>'APEX.IG.DELETE_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411321322874252)
,p_name=>'APEX.IG.DESCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\6E1B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972838005873925)
,p_name=>'APEX.IG.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710739469873746)
,p_name=>'APEX.IG.DETAIL_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A73\7D30\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286373531173874224)
,p_name=>'APEX.IG.DIRECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\5411')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972502770873925)
,p_name=>'APEX.IG.DISABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\505C\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954288531873911)
,p_name=>'APEX.IG.DOES_NOT_CONTAIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5305\542B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954454815873911)
,p_name=>'APEX.IG.DOES_NOT_START_WITH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\982D\4E0D\70BA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406022596874248)
,p_name=>'APEX.IG.DONUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\74B0\5708\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285977670442873928)
,p_name=>'APEX.IG.DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\8F09')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426932138874263)
,p_name=>'APEX.IG.DOWNLOAD_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412238497874253)
,p_name=>'APEX.IG.DUPLICATE_AGGREGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8907\7684\805A\7E3D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412336955874253)
,p_name=>'APEX.IG.DUPLICATE_CONTROLBREAK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8907\7684\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979113524873929)
,p_name=>'APEX.IG.DUPLICATE_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8907\7684\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285977901393873929)
,p_name=>'APEX.IG.DUPLICATE_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711860961873746)
,p_name=>'APEX.IG.EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286410719256874252)
,p_name=>'APEX.IG.EDIT_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\5716\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434775088874269)
,p_name=>'APEX.IG.EDIT_GROUP_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\7FA4\7D44\4F9D\64DA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426566655874263)
,p_name=>'APEX.IG.EMAIL_BCC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\4EF6\526F\672C (bcc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426715751874263)
,p_name=>'APEX.IG.EMAIL_BODY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A0A\606F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426467308874263)
,p_name=>'APEX.IG.EMAIL_CC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\526F\672C (cc)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426158399874263)
,p_name=>'APEX.IG.EMAIL_SENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\5DF2\50B3\9001.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426687065874263)
,p_name=>'APEX.IG.EMAIL_SUBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\65E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426323191874263)
,p_name=>'APEX.IG.EMAIL_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6536\4EF6\8005 (to)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972236217873924)
,p_name=>'APEX.IG.ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\555F\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285952546974873910)
,p_name=>'APEX.IG.EQUALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B49\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425524220874262)
,p_name=>'APEX.IG.EXAMPLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\4F8B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972331872873924)
,p_name=>'APEX.IG.EXPRESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425484981874262)
,p_name=>'APEX.IG.FD_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\985E\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286074316220873998)
,p_name=>'APEX.IG.FILE_PREPARED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A94\6848\5DF2\5099\59A5. \958B\59CB\4E0B\8F09\4E2D.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774439242873789)
,p_name=>'APEX.IG.FILL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\586B\5165')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285795888652873804)
,p_name=>'APEX.IG.FILL_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\9805\76EE\586B\5165\65B9\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285795731329873803)
,p_name=>'APEX.IG.FILL_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\586B\5165\9078\64C7\9805\76EE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711387797873746)
,p_name=>'APEX.IG.FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971605821873924)
,p_name=>'APEX.IG.FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447193249874278)
,p_name=>'APEX.IG.FILTER_WITH_DOTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411551160874252)
,p_name=>'APEX.IG.FIRST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C\4E00\500B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711589363873746)
,p_name=>'APEX.IG.FLASHBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5012\6EAF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970167227873923)
,p_name=>'APEX.IG.FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286421046373874259)
,p_name=>'APEX.IG.FORMATMASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\683C\5F0F\906E\7F69')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425817871874263)
,p_name=>'APEX.IG.FORMAT_CSV'
,p_message_language=>'zh-tw'
,p_message_text=>'CSV'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425796016874263)
,p_name=>'APEX.IG.FORMAT_HTML'
,p_message_language=>'zh-tw'
,p_message_text=>'HTML'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978824374873929)
,p_name=>'APEX.IG.FREEZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51CD\7D50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972438287873925)
,p_name=>'APEX.IG.FUNCTIONS_AND_OPERATORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578\548C\904B\7B97\5B50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406120847874248)
,p_name=>'APEX.IG.FUNNEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6F0F\6597\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286317899434874178)
,p_name=>'APEX.IG.GO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953133075873910)
,p_name=>'APEX.IG.GREATER_THAN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5927\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953294743873910)
,p_name=>'APEX.IG.GREATER_THAN_OR_EQUALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5927\65BC\6216\7B49\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972785572873925)
,p_name=>'APEX.IG.GRID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710556184873746)
,p_name=>'APEX.IG.GRID_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\683C\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412569067874253)
,p_name=>'APEX.IG.GROUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972963871873925)
,p_name=>'APEX.IG.GROUP_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44\4F9D\64DA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710866163873746)
,p_name=>'APEX.IG.GROUP_BY_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44\4F9D\64DA\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286421695006874260)
,p_name=>'APEX.IG.HD_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\689D\4EF6\985E\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420506556874259)
,p_name=>'APEX.IG.HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420711938874259)
,p_name=>'APEX.IG.HEADING_ALIGN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\984C\5C0D\9F4A\65B9\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447099914874278)
,p_name=>'APEX.IG.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286432872223874268)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\76F4\63A5\5728\6B64\4E92\52D5\5F0F\65B9\683C\5167\63D2\5165\3001\66F4\65B0\53CA\522A\9664\8CC7\6599.</p>'),
'',
unistr('<p>\82E5\8981\63D2\5165\65B0\8CC7\6599\5217, \8ACB\6309\4E00\4E0B\300C\65B0\589E\8CC7\6599\5217\300D\6309\9215.</p>'),
'',
unistr('<p>\82E5\8981\7DE8\8F2F\73FE\6709\8CC7\6599, \8ACB\6309\5169\4E0B\7279\5B9A\5132\5B58\683C. \82E5\662F\8981\9032\884C\8F03\5927\91CF\7684\7DE8\8F2F\5DE5\4F5C, \8ACB\6309\4E00\4E0B\300C\7DE8\8F2F\300D\4EE5\9032\5165\7DE8\8F2F\6A21\5F0F. \5728\7DE8\8F2F\6A21\5F0F\4E2D, \60A8\53EF\4EE5\6309\4E00\4E0B\6216\4F7F\7528\9375\76E4\4F86\7DE8\8F2F\7279\5B9A\5132\5B58\683C.</p>'),
'',
unistr('<p>\82E5\8981\8907\88FD\53CA\522A\9664\8CC7\6599\5217, \8ACB\4F7F\7528\300C\8B8A\66F4\300D\529F\80FD\8868. \82E5\8981\555F\7528\300C\8B8A\66F4\300D\529F\80FD\8868, \8ACB\4F7F\7528\6838\53D6\65B9\584A\4F86\9078\53D6\4E00\6216\591A\500B\8CC7\6599\5217.</p>'),
'',
unistr('<p>\82E5\8981\8907\88FD\9078\53D6\7684\8CC7\6599\5217, \8ACB\6309\4E00\4E0B\300C\8B8A\66F4\300D\529F\80FD\8868\4E26\9078\53D6\300C\8907\88FD\8CC7\6599\5217\300D. \82E5\8981\522A\9664\9078\53D6\7684\8CC7\6599\5217, \8ACB\6309\4E00\4E0B\300C\8B8A\66F4\300D\529F\80FD\8868\4E26\9078\53D6\300C\522A\9664\8CC7\6599\5217\300D.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286435290199874270)
,p_name=>'APEX.IG.HELP.ACTIONS.EDITING_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286435390333874270)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4E92\52D5\5F0F\65B9\683C\6703\4EE5\53EF\641C\5C0B\4E14\53EF\81EA\8A02\7684\5831\8868\5F62\5F0F\5448\73FE\4E00\7D44\8CC7\6599. \60A8\53EF\4EE5\57F7\884C\6578\7A2E\4F5C\696D\4F86\9650\5236\50B3\56DE\7684\8A18\9304, \4EE5\53CA\8B8A\66F4\8CC7\6599\7684\986F\793A\65B9\5F0F.</p>'),
'',
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\300C\641C\5C0B\300D\6B04\4F4D\4F86\7BE9\9078\50B3\56DE\7684\8A18\9304. \6309\4E00\4E0B\300C\52D5\4F5C\300D\5373\53EF\5B58\53D6\8A31\591A\53EF\4F9B\4FEE\6539\5831\8868\7248\9762\914D\7F6E\7684\9078\9805, \6216\8005\4F7F\7528\5DF2\986F\793A\8CC7\6599\6B04\7684\300C\8CC7\6599\6B04\6A19\984C\300D\529F\80FD\8868.</p>'),
'',
unistr('<p>\82E5\8981\5C07\60A8\7684\81EA\8A02\9805\5132\5B58\81F3\5831\8868, \8ACB\4F7F\7528\300C\5831\8868\8A2D\5B9A\503C\300D. \60A8\4E5F\53EF\4EE5\5C07\5831\8868\7684\8CC7\6599\4E0B\8F09\81F3\5916\90E8\6A94\6848, \6216\4F7F\7528\96FB\5B50\90F5\4EF6\5C07\8CC7\6599\50B3\9001\7D66\81EA\5DF1\6216\5176\4ED6\4EBA.</p>'),
'',
unistr('<p>\82E5\8981\77AD\89E3\8A73\7D30\8CC7\8A0A, \8ACB\53C3\95B1 <em>Oracle Application Express End User''s Guide</em> \4E2D\7684 "Using Interactive Grids".')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286435046306874269)
,p_name=>'APEX.IG.HELP.ACTIONS.INTRO_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286432773471874268)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\81EA\8A02\4E92\52D5\5F0F\65B9\683C, \8B93\5176\904B\7528\5167\5EFA\7684\529F\80FD, \4EE5\5404\7A2E\4E0D\540C\65B9\5F0F\986F\793A\8CC7\6599.</p>'),
'',
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\300C\8CC7\6599\6B04\6A19\984C\300D\529F\80FD\8868\6216\300C\52D5\4F5C\300D\529F\80FD\8868\4F86\6C7A\5B9A\8981\986F\793A\7684\8CC7\6599\6B04\3001\986F\793A\9806\5E8F\4EE5\53CA\51CD\7D50\8CC7\6599\6B04. \60A8\4E5F\53EF\4EE5\5B9A\7FA9\5404\7A2E\50B3\56DE\8CC7\6599\7684\8CC7\6599\7BE9\9078\548C\6392\5E8F.</p>'),
'',
unistr('<p>\4F7F\7528\300C\6AA2\8996\300D\6309\9215 (\5728\300C\641C\5C0B\300D\6B04\4F4D\65C1\908A) \5373\53EF\5B58\53D6\61C9\7528\7A0B\5F0F\958B\767C\4EBA\54E1\5DF2\7D93\5B9A\7FA9\7684\5176\4ED6\8CC7\6599\6AA2\8996. \60A8\4E5F\53EF\4EE5\5EFA\7ACB\5716\8868\6216\6AA2\8996\73FE\6709\5716\8868.</p>  '),
'',
unistr('<p><em>\6CE8\610F: \6309\4E00\4E0B\4E92\52D5\5F0F\65B9\683C\5C0D\8A71\65B9\584A\4E2D\7684<strong>\8AAA\660E</strong>, \5373\53EF\53D6\5F97\6240\9078\51FD\6578\7684\8A73\7D30\8CC7\8A0A.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286435194866874269)
,p_name=>'APEX.IG.HELP.ACTIONS.REPORTING_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285977861418873928)
,p_name=>'APEX.IG.HELP.ACTIONS_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\52D5\5F0F\65B9\683C\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429725827874266)
,p_name=>'APEX.IG.HELP.AGGREGATE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5C0D\8A71\65B9\584A\4F86\805A\7E3D\8CC7\6599\6B04. \805A\7E3D\7684\503C\6703\986F\793A\5728\8CC7\6599\7684\5E95\7AEF, \82E5\5B9A\7FA9\300C\63A7\5236\5206\6BB5\300D\7684\8A71, \5247\986F\793A\5728\6BCF\500B\5206\9694\7684\5E95\7AEF.</p>'),
'',
unistr('<p><strong>\805A\7E3D\6E05\55AE</strong><br>'),
unistr('\300C\805A\7E3D\300D\6E05\55AE\6703\986F\793A\5DF2\5B9A\7FA9\7684\805A\7E3D. \82E5\8981\505C\7528\73FE\6709\7684\805A\7E3D, \8ACB\5C07\5B83\53D6\6D88\9078\53D6.<br>'),
unistr('\6309\4E00\4E0B\300C\65B0\589E\300D( &plus; ) \5373\53EF\5EFA\7ACB\65B0\805A\7E3D, \6309\4E00\4E0B\300C\522A\9664\300D( &minus; ) \5373\53EF\79FB\9664\73FE\6709\805A\7E3D.</p>'),
'',
unistr('<p><strong>\805A\7E3D\8A2D\5B9A\503C</strong><br>'),
unistr('\8ACB\4F7F\7528\53F3\5074\7684\8868\55AE\4F86\5B9A\7FA9\805A\7E3D.<br>'),
unistr('\9078\53D6\8CC7\6599\6B04\540D\7A31\548C\805A\7E3D\985E\578B.<br>'),
unistr('(\9078\64C7\6027) \8F38\5165\805A\7E3D\7684\5DE5\5177\63D0\793A.<br>'),
unistr('\82E5\60A8\5DF2\5B9A\7FA9\300C\63A7\5236\5206\6BB5\300D\4E26\9078\53D6<strong>\986F\793A\6574\9AD4\503C</strong>\7684\8A71, \5247\6703\5728\8CC7\6599\7684\5E95\7AEF\986F\793A\6574\9AD4\5E73\5747\503C\3001\7E3D\8A08\6216\985E\4F3C\7684\503C.</p>'),
'',
unistr('<p><em>\6CE8\610F: \82E5\8981\5B58\53D6\300C\805A\7E3D\300D\5C0D\8A71\65B9\584A, \60A8\53EF\4EE5\4F7F\7528\300C\52D5\4F5C\300D\529F\80FD\8868\6216\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C\548C\7E3D\548C ( &sum; ).</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434176139874269)
,p_name=>'APEX.IG.HELP.AGGREGATE_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\805A\7E3D\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286430406342874266)
,p_name=>'APEX.IG.HELP.CHART'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5C0D\8A71\65B9\584A\5B9A\7FA9\986F\793A\70BA\500B\5225\8CC7\6599\6AA2\8996\7684\5716\8868.<br> '),
unistr('\8ACB\9078\53D6\4E00\7A2E\5716\8868\985E\578B\3001\8A2D\5B9A\5716\8868\8A2D\5B9A\503C, \7136\5F8C\6309\4E00\4E0B<strong>\5132\5B58</strong>.</p>'),
'',
unistr('<p><strong>\5716\8868\8A2D\5B9A\503C</strong></br>'),
unistr('\986F\793A\7684\5716\8868\5C6C\6027\6703\56E0\5716\8868\985E\578B\800C\6709\6240\4E0D\540C. \60A8\53EF\8F38\5165\4E00\4E9B\5C6C\6027\4F86\5B9A\7FA9\5716\8868. \5E36\6709\7D05\8272\661F\865F\7684\5C6C\6027\662F\5FC5\8981\5C6C\6027.</p>'),
'',
unistr('<p>\4E0B\65B9\662F\4E0D\540C\5716\8868\985E\578B\7684\6240\6709\53EF\7528\5C6C\6027 (\4F9D\5B57\6BCD\6392\5217):'),
'<ul>',
unistr('  <li>\805A\7E3D - \9078\53D6\805A\7E3D\95DC\806F\5716\8868\503C\7684\65B9\5F0F.</li> '),
unistr('  <li>\6536\76E4\50F9 - \9078\53D6\5305\542B\6BCF\65E5\80A1\7968\6536\76E4\50F9\683C\7684\8CC7\6599\6B04 (\50C5\9650\80A1\7968\5206\6790\5716).</li> '),
unistr('  <li>\5C0F\6578\4F4D\6578 - \8F38\5165\6368\5165\503C\7684\5C0F\6578\4F4D\6578.</li> '),
unistr('  <li>\65B9\5411 -  \8207\300C\6392\5E8F\65B9\5F0F\300D\5C6C\6027\76F8\95DC, \6307\5B9A\8CC7\6599\662F\8981\4F9D\905E\589E\9084\662F\905E\6E1B\9806\5E8F\6392\5E8F.</li> '),
unistr('  <li>\9AD8 - \9078\53D6\5305\542B\9AD8\503C\7684\8CC7\6599\6B04 (\50C5\9650\7BC4\570D\5716\548C\80A1\7968\5206\6790\5716).</li> '),
unistr('  <li>\6A19\7C64 - \9078\53D6\5305\542B\6BCF\500B\8CC7\6599\9EDE\6587\5B57\7684\8CC7\6599\6B04.</li> '),
unistr('  <li>\6A19\7C64\8EF8\6A19\984C - \8F38\5165\6A19\7C64\8EF8\4E0A\6240\986F\793A\7684\6A19\984C.</li> '),
unistr('  <li>\4F4E - \9078\53D6\5305\542B\4F4E\503C\7684\8CC7\6599\6B04 (\50C5\9650\7BC4\570D\5716\548C\80A1\7968\5206\6790\5716).</li> '),
unistr('  <li>\7A7A\503C - \8207\300C\6392\5E8F\65B9\5F0F\300D\5C6C\6027\76F8\95DC, \6307\5B9A\76F8\8F03\65BC\5305\542B\975E\7A7A\503C\7684\8A18\9304, \60A8\5E0C\671B\5982\4F55\6392\5E8F\5305\542B\7A7A\503C\7684\8A18\9304.</li> '),
unistr('  <li>\958B\76E4\50F9 - \9078\53D6\5305\542B\6BCF\65E5\80A1\7968\958B\76E4\50F9\683C\7684\8CC7\6599\6B04 (\50C5\9650\80A1\7968\5206\6790\5716).</li> '),
unistr('  <li>\65B9\5411 - \9078\53D6\8981\4EE5\5782\76F4\9084\662F\6C34\5E73\65B9\5F0F\986F\793A\5716\8868\5143\7D20 (\4F8B\5982\9577\689D).</li> '),
unistr('  <li>\6578\5217 - \9078\53D6\7528\65BC\5B9A\7FA9\591A\91CD\6578\5217\52D5\614B\67E5\8A62\7684\8CC7\6599\6B04.</li> '),
unistr('  <li>\5806\758A - \6307\5B9A\662F\5426\5C07\8CC7\6599\9805\76EE\5806\758A.</li> '),
unistr('  <li>\6392\5E8F\65B9\5F0F - \9078\53D6\8981\4F9D\6A19\7C64\9084\662F\503C\6392\5E8F\5716\8868.</li> '),
unistr('  <li>\76EE\6A19 - \9078\53D6\7528\65BC\5B9A\7FA9\6B64\5716\8868\4E4B\76EE\6A19\503C\7684\8CC7\6599\6B04. \5982\679C\8A2D\5B9A, \5C07\7531\300C\503C\300D\5C6C\6027\5B9A\7FA9\5207\7247\5167\7684\586B\6EFF\5340\57DF, \800C\300C\76EE\6A19\300D\5247\4EE3\8868\6574\500B\5207\7247\7684\503C (\50C5\9650\6F0F\6597\5716).</li> '),
unistr('  <li>\503C - \9078\53D6\5305\542B\8981\7E6A\88FD\4E4B\8CC7\6599\7684\8CC7\6599\6B04.</li> '),
unistr('  <li>\503C\8EF8\6A19\984C - \8F38\5165\503C\8EF8\4E0A\6240\986F\793A\7684\6A19\984C.</li> '),
unistr('  <li>\6210\4EA4\91CF - \9078\53D6\5305\542B\6BCF\65E5\80A1\7968\6210\4EA4\91CF\7684\8CC7\6599\6B04 (\50C5\9650\80A1\7968\5206\6790\5716).</li> '),
unistr('  <li>X - \9078\53D6\5305\542B\6B64\5716\8868\4E4B X \8EF8\503C\7684\8CC7\6599\6B04 (\50C5\9650\6CE1\6CE1\5716\548C\6563\5E03\5716).</li> '),
unistr('  <li>Y - \9078\53D6\5305\542B\6B64\5716\8868\4E4B Y \8EF8\503C\7684\8CC7\6599\6B04 (\50C5\9650\6CE1\6CE1\5716\548C\6563\5E03\5716).</li> '),
unistr('  <li>Z - \9078\53D6\5305\542B\9577\689D\5BEC\5EA6\6216\6CE1\6CE1\534A\5F91\7684\8CC7\6599\6B04 (\50C5\9650\9577\689D\5716\3001\6CE1\6CE1\5716\4EE5\53CA\7BC4\570D\5716)</li> '),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434563254874269)
,p_name=>'APEX.IG.HELP.CHART_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429453808874265)
,p_name=>'APEX.IG.HELP.COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\5728\6B64\5C0D\8A71\65B9\584A\4E2D\9078\64C7\986F\793A\7684\8CC7\6599\6B04\548C\986F\793A\9806\5E8F.</p>'),
'',
unistr('<p>\82E5\8981\96B1\85CF\8CC7\6599\6B04, \53EA\8981\5C07\5B83\53D6\6D88\9078\53D6.<br>'),
unistr('\82E5\8981\91CD\65B0\6392\5217\8CC7\6599\6B04, \8ACB\6309\4E00\4E0B\300C\4E0A\79FB\300D( &uarr; ) \6216\300C\4E0B\79FB\300D( &darr; ).<br>'),
unistr('\4F7F\7528\4E0B\62C9\5F0F\9078\53D6\5668\5373\53EF\5217\51FA\6240\6709\8CC7\6599\6B04\3001\986F\793A\7684\8CC7\6599\6B04\6216\672A\986F\793A\7684\8CC7\6599\6B04.</p>'),
'',
unistr('<p>(\9078\64C7\6027) \53EF\4F7F\7528\8868\55AE\6307\5B9A\8CC7\6599\6B04\7684\6700\5C0F\5BEC\5EA6 (\50CF\7D20).</p>'),
'',
unistr('<p><em>\6CE8\610F: \60A8\4E5F\53EF\4EE5\6309\4E00\4E0B\62D6\66F3\63A7\9EDE (\4F4D\65BC\8CC7\6599\6B04\6A19\984C\7684\958B\982D) \4E26\5C07\8CC7\6599\6B04\5411\5DE6\6216\5411\53F3\62D6\66F3, \4EE5\91CD\65B0\6392\5217\986F\793A\7684\8CC7\6599\6B04. \60A8\4E5F\53EF\4EE5\9078\53D6\8CC7\6599\6B04\5340\9694\7B26\865F (\5728\6A19\984C\4E4B\9593), \7136\5F8C\5C07\5176\5411\5DE6\6216\5411\53F3\79FB\52D5, \4EE5\8B8A\66F4\986F\793A\4E4B\8CC7\6599\6B04\7684\5BEC\5EA6.</em</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434460204874269)
,p_name=>'APEX.IG.HELP.COLUMNS_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429822150874266)
,p_name=>'APEX.IG.HELP.COMPUTE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5C0D\8A71\65B9\584A, \4F9D\64DA\5C0D\73FE\6709\8CC7\6599\6B04\57F7\884C\7684\7B97\8853\548C\51FD\6578\904B\7B97, \5B9A\7FA9\5176\4ED6\8CC7\6599\6B04.</p>'),
'',
unistr('<p><strong>\904B\7B97\6E05\55AE</strong><br>'),
unistr('\300C\904B\7B97\300D\6E05\55AE\6703\986F\793A\5DF2\5B9A\7FA9\7684\904B\7B97. \82E5\8981\505C\7528\73FE\6709\7684\904B\7B97, \8ACB\5C07\5B83\53D6\6D88\9078\53D6.<br>'),
unistr('\6309\4E00\4E0B\300C\65B0\589E\300D( &plus; ) \5373\53EF\65B0\589E\904B\7B97, \6309\4E00\4E0B\300C\522A\9664\300D( &minus; ) \5373\53EF\79FB\9664\73FE\6709\904B\7B97.</p>'),
'',
unistr('<p><strong>\904B\7B97\8A2D\5B9A\503C</strong><br>'),
unistr('\8ACB\4F7F\7528\6B64\8868\55AE\5B9A\7FA9\904B\7B97.<br>'),
unistr('\8F38\5165\8CC7\6599\6B04\660E\7D30, \4F8B\5982\6A19\984C\3001\6A19\7C64, \4E26\9078\53D6\5C0D\9F4A\65B9\5F0F\8A2D\5B9A\503C.<br> '),
unistr('\5728\300C\8868\793A\5F0F\300D\6587\5B57\5340\4E2D\8F38\5165\904B\7B97\7684\8CC7\6599\6B04\548C\95DC\806F\7684\51FD\6578.<br>'),
unistr('\70BA\65B0\8CC7\6599\6B04\9078\53D6\9069\7576\7684\8CC7\6599\985E\578B\548C\683C\5F0F\906E\7F69 (\6B64\70BA\9078\64C7\6027).</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434031105874269)
,p_name=>'APEX.IG.HELP.COMPUTE_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286430162920874266)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5C0D\8A71\65B9\584A\5B9A\7FA9\4E00\6216\591A\500B\8CC7\6599\6B04\7684\63A7\5236\5206\6BB5.</p>'),
'',
unistr('<p><strong>\63A7\5236\5206\6BB5\6E05\55AE</strong><br>'),
unistr('\300C\63A7\5236\5206\6BB5\300D\6E05\55AE\6703\986F\793A\5DF2\5B9A\7FA9\7684\63A7\5236\5206\6BB5. \82E5\8981\505C\7528\73FE\6709\7684\63A7\5236\5206\6BB5\8CC7\6599\6B04, \8ACB\5C07\5B83\53D6\6D88\9078\53D6.<br>'),
unistr('\6309\4E00\4E0B\300C\65B0\589E\300D( &plus; ) \5373\53EF\5728\63A7\5236\5206\6BB5\4E2D\5305\542B\65B0\8CC7\6599\6B04, \6309\4E00\4E0B\300C\522A\9664\300D( &minus; ) \5373\53EF\79FB\9664\63A7\5236\5206\6BB5\4E2D\7684\73FE\6709\8CC7\6599\6B04.<br>'),
unistr('\82E5\8981\91CD\65B0\6392\5217\8CC7\6599\6B04, \8ACB\6309\4E00\4E0B\300C\4E0A\79FB\300D( &uarr; ) \6216\300C\4E0B\79FB\300D( &darr; ), \5C07\9078\53D6\7684\8CC7\6599\6B04\79FB\52D5\81F3\5176\4ED6\8CC7\6599\6B04\7684\4E0A\65B9\6216\4E0B\65B9.</p>'),
'',
unistr('<p><strong>\63A7\5236\5206\6BB5\8A2D\5B9A\503C</strong><br>'),
unistr('\8ACB\4F7F\7528\6B64\8868\55AE\5B9A\7FA9\63A7\5236\5206\6BB5\8CC7\6599\6B04.<br>'),
unistr('\9078\53D6\4E00\500B\63A7\5236\5206\6BB5\8CC7\6599\6B04\3001\6392\5E8F\65B9\5411\4EE5\53CA\7A7A\503C\8CC7\6599\6B04 (\4E0D\542B\503C\7684\8CC7\6599\6B04) \7684\6392\5217\65B9\5F0F.</p>'),
'',
unistr('<p><em>\6CE8\610F: \82E5\662F\6AA2\8996\4E92\52D5\5F0F\65B9\683C, \60A8\53EF\4EE5\6309\4E00\4E0B\300C\8CC7\6599\6B04\6A19\984C\300D\4E26\9078\53D6\63A7\5236\5206\6BB5\5716\793A\4F86\5B9A\7FA9\63A7\5236\5206\6BB5.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286433743008874269)
,p_name=>'APEX.IG.HELP.CONTROL_BREAK_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63A7\5236\5206\6BB5\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286430307555874266)
,p_name=>'APEX.IG.HELP.DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5C0D\8A71\65B9\584A\5C07\6240\6709\76EE\524D\7684\8CC7\6599\5217\4E0B\8F09\81F3\5916\90E8\6A94\6848. \6B64\6A94\6848\5C07\53EA\6703\5305\542B\76EE\524D\986F\793A\7684\8CC7\6599\6B04 (\5728\8CC7\6599\5957\7528\4EFB\4F55\7BE9\9078\548C\6392\5E8F\6240\5F97\7684\8CC7\6599\6B04).</p>'),
'',
unistr('<p>\8ACB\9078\53D6\6A94\6848\683C\5F0F, \7136\5F8C\6309\4E00\4E0B\300C\4E0B\8F09\300D.<br>'),
unistr('\6CE8\610F: CSV \5C07\4E0D\6703\5305\62EC\50CF\805A\7E3D\548C\63A7\5236\5206\6BB5\7684\6587\5B57\683C\5F0F.</p>'),
'',
unistr('<p>\82E5\8981\4EE5\96FB\5B50\90F5\4EF6\50B3\9001\6A94\6848, \8ACB\9078\53D6\300C\4EE5\96FB\5B50\90F5\4EF6\50B3\9001\300D, \4E26\8F38\5165\96FB\5B50\90F5\4EF6\8A73\7D30\8CC7\8A0A (\6536\4EF6\8005\3001\4E3B\65E8\548C\8A0A\606F).</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286433536981874268)
,p_name=>'APEX.IG.HELP.DOWNLOAD_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\8F09\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429580258874265)
,p_name=>'APEX.IG.HELP.FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5C0D\8A71\65B9\584A\8A2D\5B9A\9650\5236\50B3\56DE\4E4B\8CC7\6599\5217\7684\8CC7\6599\7BE9\9078.</p>'),
'',
unistr('<p><strong>\7BE9\9078\6E05\55AE</strong><br>'),
unistr('\300C\7BE9\9078\300D\6E05\55AE\6703\986F\793A\5B9A\7FA9\7684\7BE9\9078. \82E5\8981\505C\7528\73FE\6709\7684\7BE9\9078, \8ACB\5C07\5B83\53D6\6D88\9078\53D6.<br>'),
unistr('\6309\4E00\4E0B\300C\65B0\589E\300D( &plus; ) \5373\53EF\5EFA\7ACB\65B0\7BE9\9078, \6309\4E00\4E0B\300C\522A\9664\300D( &minus; ) \5373\53EF\79FB\9664\73FE\6709\7BE9\9078.</p>'),
'',
unistr('<p><strong>\7BE9\9078\8A2D\5B9A\503C</strong><br>'),
unistr('\8ACB\4F7F\7528\6B64\8868\55AE\5B9A\7FA9\7BE9\9078\7279\6027.<br>'),
unistr('\9078\53D6\9069\7576\7684\7BE9\9078\985E\578B:<br>'),
unistr('&nbsp;&nbsp;&nbsp;\8CC7\6599\5217 - \53EF\7BE9\9078\4EFB\4F55\53EF\7BE9\9078\8CC7\6599\6B04\4E2D\7684\8A5E\5F59.<br>'),
unistr('&nbsp;&nbsp;&nbsp;\8CC7\6599\6B04 - \4F7F\7528\6307\5B9A\7684\904B\7B97\5B50\548C\503C\7BE9\9078\7279\5B9A\8CC7\6599\6B04.</p>'),
'',
unistr('<p><em>\6CE8\610F: \82E5\662F\6AA2\8996\4E92\52D5\5F0F\65B9\683C, \60A8\53EF\4EE5\76F4\63A5\5728\300C\641C\5C0B\300D\6B04\4F4D\4E2D\8F38\5165\4EE5\5B9A\7FA9\8CC7\6599\5217\7BE9\9078. \6309\4E00\4E0B\300C\9078\53D6\8981\641C\5C0B\7684\8CC7\6599\6B04\300D\5373\53EF\5C07\641C\5C0B\7BC4\570D\9650\65BC\7279\5B9A\8CC7\6599\6B04. \6216\8005, \53EF\958B\555F\300C\8CC7\6599\6B04\6A19\984C\300D\529F\80FD\8868\4E26\9078\53D6\4E00\500B\503C, \4EE5\5EFA\7ACB\8CC7\6599\6B04\7BE9\9078.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434356369874269)
,p_name=>'APEX.IG.HELP.FILTER_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429936617874266)
,p_name=>'APEX.IG.HELP.FLASHBACK'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\5728\6B64\5C0D\8A71\65B9\584A\4E2D\6AA2\8996\904E\53BB\6642\9593\9EDE\7684\8CC7\6599.</p>'),
unistr('<p>\8ACB\8F38\5165\904E\53BB\7684\5206\9418\6578\4EE5\57F7\884C\5012\6EAF\67E5\8A62.</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286433993647874269)
,p_name=>'APEX.IG.HELP.FLASHBACK_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5012\6EAF\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434698853874269)
,p_name=>'APEX.IG.HELP.GROUP_BY_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44\4F9D\64DA\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286430026301874266)
,p_name=>'APEX.IG.HELP.HIGHLIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\5C0D\8A71\65B9\584A, \4F9D\64DA\8F38\5165\7684\689D\4EF6, \6A19\793A\8CC7\6599\7684\8CC7\6599\5217\6216\8CC7\6599\6B04.</p>'),
'',
unistr('<p><strong>\6A19\793A\6E05\55AE</strong><br>'),
unistr('\300C\6A19\793A\300D\6E05\55AE\6703\986F\793A\5DF2\5B9A\7FA9\7684\6A19\793A\9805\76EE. \82E5\8981\505C\7528\73FE\6709\7684\6A19\793A, \8ACB\5C07\5B83\53D6\6D88\9078\53D6.<br>'),
unistr('\6309\4E00\4E0B\300C\65B0\589E\300D( &plus; ) \5373\53EF\5EFA\7ACB\65B0\6A19\793A, \6309\4E00\4E0B\300C\522A\9664\300D( &minus; ) \5373\53EF\79FB\9664\73FE\6709\6A19\793A.</p>'),
'',
unistr('<p><strong>\6A19\793A\8A2D\5B9A\503C</strong><br>'),
unistr('\8ACB\4F7F\7528\6B64\8868\55AE\5B9A\7FA9\6A19\793A\7279\6027.<br>'),
unistr('\8F38\5165\540D\7A31\3001\9078\53D6\300C\8CC7\6599\5217\300D\6216\300C\8CC7\6599\6B04\300D, \7136\5F8C\9078\53D6\80CC\666F\548C\6587\5B57\7684 HTML \8272\5F69\4EE3\78BC.<br>'),
unistr('\9078\53D6\9069\7576\7684<strong>\689D\4EF6\985E\578B</strong>\4EE5\6A19\793A\7279\5B9A\8CC7\6599:<br>'),
unistr('&nbsp;&nbsp;&nbsp;\8CC7\6599\5217 - \6A19\793A\4EFB\4E00\8CC7\6599\6B04\4E2D\7684\8A5E\5F59.<br>'),
unistr('&nbsp;&nbsp;&nbsp;\8CC7\6599\6B04 - \4F9D\64DA\6307\5B9A\7684\904B\7B97\5B50\548C\503C, \5728\7279\5B9A\8CC7\6599\6B04\5167\6A19\793A.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286433823582874269)
,p_name=>'APEX.IG.HELP.HIGHLIGHT_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286430277882874266)
,p_name=>'APEX.IG.HELP.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\5728\6B64\5C0D\8A71\65B9\584A\4E2D\5132\5B58\60A8\5C0D\76EE\524D\7684\65B9\683C\7248\9762\914D\7F6E\548C\7D44\614B\6240\505A\7684\8B8A\66F4.<br>'),
unistr('\61C9\7528\7A0B\5F0F\958B\767C\4EBA\54E1\53EF\4EE5\5B9A\7FA9\591A\500B\66FF\4EE3\7684\5831\8868\7248\9762\914D\7F6E. \82E5\60C5\6CC1\5141\8A31, \60A8\548C\5176\4ED6\4E00\822C\4F7F\7528\8005\90FD\53EF\4EE5\5C07\5831\8868\53E6\5B58\70BA\300C\516C\7528\300D, \8B93\5831\8868\53EF\4F9B\65B9\683C\7684\5176\4ED6\6240\6709\4F7F\7528\8005\4F7F\7528. \60A8\4E5F\53EF\4EE5\5C07\5831\8868\53E6\5B58\70BA\53EA\6709\60A8\80FD\5920\6AA2\8996\7684\300C\5C08\7528\300D\5831\8868.</p>'),
unistr('<p>\8ACB\5F9E\53EF\7528\7684\985E\578B\4E2D\9078\53D6, \7136\5F8C\8F38\5165\9810\5B58\5831\8868\7684\540D\7A31.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286433632816874268)
,p_name=>'APEX.IG.HELP.REPORT_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5831\8868\8AAA\660E'),
''))
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429627082874265)
,p_name=>'APEX.IG.HELP.SORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\5728\6B64\5C0D\8A71\65B9\584A\4E2D\8A2D\5B9A\986F\793A\9806\5E8F.</p>'),
'',
unistr('<p><strong>\6392\5E8F\6E05\55AE</strong><br>'),
unistr('\300C\6392\5E8F\300D\5C0D\8A71\65B9\584A\6703\986F\793A\5DF2\8A2D\5B9A\7684\6392\5E8F\898F\5247\6E05\55AE.<br>'),
unistr('\6309\4E00\4E0B\300C\65B0\589E\300D( &plus; ) \5373\53EF\5EFA\7ACB\6392\5E8F\8CC7\6599\6B04, \6309\4E00\4E0B\300C\522A\9664\300D( &minus; ) \5373\53EF\79FB\9664\6392\5E8F\8CC7\6599\6B04.<br>'),
unistr('\6309\4E00\4E0B\300C\4E0A\79FB\300D( &uarr; ) \548C\300C\4E0B\79FB\300D( &darr; ) \5373\53EF\5C07\9078\53D6\7684\6392\5E8F\8CC7\6599\6B04\79FB\5230\5176\4ED6\6392\5E8F\8CC7\6599\6B04\7684\4E0A\65B9\6216\4E0B\65B9.</p>'),
'',
unistr('<p><strong>\6392\5E8F\8A2D\5B9A\503C</strong><br>'),
unistr('\8ACB\9078\53D6\4E00\500B\6392\5E8F\8CC7\6599\6B04\3001\6392\5E8F\65B9\5411\4EE5\53CA\7A7A\503C\8CC7\6599\6B04 (\4E0D\542B\503C\7684\8CC7\6599\6B04) \7684\6392\5217\65B9\5F0F.</p>'),
'',
unistr('<p><em>\6CE8\610F: \8CC7\6599\53EF\4EE5\4F9D\7167\672A\986F\793A\7684\8CC7\6599\6B04\6392\5E8F; \4F46\662F\4E26\975E\6240\6709\8CC7\6599\6B04\90FD\53EF\4EE5\6392\5E8F.</em><br>'),
unistr('<em>\6309\8CC7\6599\6B04\6A19\984C\672B\7AEF\7684\5411\4E0A (\905E\589E) \6216\5411\4E0B (\905E\6E1B) \7BAD\865F, \5373\53EF\6392\5E8F\986F\793A\7684\8CC7\6599\6B04. \82E5\8981\5C07\5F8C\7E8C\7684\8CC7\6599\6B04\52A0\5230\73FE\6709\6392\5E8F, \8ACB\6309\4F4F Shift \9375, \7136\5F8C\6309\4E00\4E0B\5411\4E0A\6216\5411\4E0B\7BAD\865F.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434211503874269)
,p_name=>'APEX.IG.HELP.SORT_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286433418198874268)
,p_name=>'APEX.IG.HELP.SUBSCRIPTION_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A02\95B1\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978756160873929)
,p_name=>'APEX.IG.HIDE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711743120873746)
,p_name=>'APEX.IG.HIGHLIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404823215874247)
,p_name=>'APEX.IG.HIGH_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9AD8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405625053874248)
,p_name=>'APEX.IG.HORIZONTAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C34\5E73')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954996156873911)
,p_name=>'APEX.IG.HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\6642')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285972614926873925)
,p_name=>'APEX.IG.ICON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710651911873746)
,p_name=>'APEX.IG.ICON_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\793A\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285952994024873910)
,p_name=>'APEX.IG.IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978354512873929)
,p_name=>'APEX.IG.INACTIVE_SETTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\975E\4F5C\7528\4E2D\8A2D\5B9A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978440625873929)
,p_name=>'APEX.IG.INACTIVE_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\975E\4F5C\7528\4E2D\8A2D\5B9A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286025724408873963)
,p_name=>'APEX.IG.INTERNAL_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\300C\4E92\52D5\5F0F\65B9\683C\300D\8981\6C42\6642\767C\751F\5167\90E8\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286432965112874268)
,p_name=>'APEX.IG.INVALID_DATE_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\65E5\671F\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286443553716874276)
,p_name=>'APEX.IG.INVALID_SETTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286443671889874276)
,p_name=>'APEX.IG.INVALID_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\8A2D\5B9A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419389311874258)
,p_name=>'APEX.IG.INVALID_SORT_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\6392\5E8F\65B9\5F0F\300D\8A2D\70BA %0, \4F46\5C1A\672A\9078\53D6\7528\65BC %0 \7684\8CC7\6599\6B04.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412413960874253)
,p_name=>'APEX.IG.INVALID_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286400670827874244)
,p_name=>'APEX.IG.INVISIBLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\986F\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953728538873911)
,p_name=>'APEX.IG.IN_THE_LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953974724873911)
,p_name=>'APEX.IG.IN_THE_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285952800725873910)
,p_name=>'APEX.IG.IS_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\662F\7A7A\7684')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285952759236873910)
,p_name=>'APEX.IG.IS_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F\7A7A\7684')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420690297874259)
,p_name=>'APEX.IG.LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404146296874247)
,p_name=>'APEX.IG.LABEL_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411624540874252)
,p_name=>'APEX.IG.LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\500B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851632798873841)
,p_name=>'APEX.IG.LAST.DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D 1 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851846401873841)
,p_name=>'APEX.IG.LAST.HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D 1 \5C0F\6642')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285852343442873841)
,p_name=>'APEX.IG.LAST.MINUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB 1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851397932873841)
,p_name=>'APEX.IG.LAST.MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\500B\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851407439873841)
,p_name=>'APEX.IG.LAST.WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851527095873841)
,p_name=>'APEX.IG.LAST.X_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851721991873841)
,p_name=>'APEX.IG.LAST.X_HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \5C0F\6642')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285852400135873841)
,p_name=>'APEX.IG.LAST.X_MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285852242442873841)
,p_name=>'APEX.IG.LAST.X_MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \500B\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285852163167873841)
,p_name=>'APEX.IG.LAST.X_WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851174598873840)
,p_name=>'APEX.IG.LAST.X_YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851266020873841)
,p_name=>'APEX.IG.LAST.YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53BB\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420888703874259)
,p_name=>'APEX.IG.LAYOUT_ALIGN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0D\9F4A\5132\5B58\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420956827874259)
,p_name=>'APEX.IG.LAYOUT_USEGROUPFOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\7FA4\7D44 - ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953303913873910)
,p_name=>'APEX.IG.LESS_THAN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953430273873910)
,p_name=>'APEX.IG.LESS_THAN_OR_EQUALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\65BC\6216\7B49\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406235515874248)
,p_name=>'APEX.IG.LINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6298\7DDA\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406372815874248)
,p_name=>'APEX.IG.LINE_WITH_AREA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6298\7DDA\5340\57DF\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286421274816874259)
,p_name=>'APEX.IG.LISTAGG'
,p_message_language=>'zh-tw'
,p_message_text=>'Listagg'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404986187874247)
,p_name=>'APEX.IG.LOW_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F4E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426852957874263)
,p_name=>'APEX.IG.MAILADDRESSES_COMMASEP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\4F7F\7528\9017\865F\5340\9694\591A\500B\5730\5740')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954580368873911)
,p_name=>'APEX.IG.MATCHES_REGULAR_EXPRESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B26\5408\6B63\898F\8868\793A\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286318466344874179)
,p_name=>'APEX.IG.MAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5927\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447908527874279)
,p_name=>'APEX.IG.MAX_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\6700\5927\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286318608639874179)
,p_name=>'APEX.IG.MEDIAN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E2D\9593\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286448090763874279)
,p_name=>'APEX.IG.MEDIAN_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\4E2D\9593\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286318373785874179)
,p_name=>'APEX.IG.MIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5C0F\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954898116873911)
,p_name=>'APEX.IG.MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286320112358874180)
,p_name=>'APEX.IG.MINUTES_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\9418\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447852391874279)
,p_name=>'APEX.IG.MIN_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\6700\5C0F\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285955453988873912)
,p_name=>'APEX.IG.MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978688251873929)
,p_name=>'APEX.IG.MORE_DATA_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5305\542B\7684\8CC7\6599\5217\7B46\6578\8D85\904E %0, \9019\5DF2\8D85\904E\5141\8A31\7684\4E0A\9650. \8ACB\5957\7528\5176\4ED6\7BE9\9078\4EE5\6AA2\8996\7D50\679C.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970686332873923)
,p_name=>'APEX.IG.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\7A31')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970893000873923)
,p_name=>'APEX.IG.NAMED_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5177\540D\7684\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850524728873840)
,p_name=>'APEX.IG.NEXT.DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C 1 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850356951873840)
,p_name=>'APEX.IG.NEXT.HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C 1 \5C0F\6642')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285852549248873841)
,p_name=>'APEX.IG.NEXT.MINUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\4F86 1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850851375873840)
,p_name=>'APEX.IG.NEXT.MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\500B\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850756280873840)
,p_name=>'APEX.IG.NEXT.WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850640730873840)
,p_name=>'APEX.IG.NEXT.X_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C %0 \5929')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850485492873840)
,p_name=>'APEX.IG.NEXT.X_HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C %0 \5C0F\6642')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285852638601873842)
,p_name=>'APEX.IG.NEXT.X_MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\4F86 %0 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851949179873841)
,p_name=>'APEX.IG.NEXT.X_MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\4F86 %0 \500B\6708')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285852018539873841)
,p_name=>'APEX.IG.NEXT.X_WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\4F86 %0 \9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285851061557873840)
,p_name=>'APEX.IG.NEXT.X_YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C %0 \5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285850930721873840)
,p_name=>'APEX.IG.NEXT.YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953658643873910)
,p_name=>'APEX.IG.NOT_BETWEEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\4ECB\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285952611230873910)
,p_name=>'APEX.IG.NOT_EQUALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\7B49\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286473018266874297)
,p_name=>'APEX.IG.NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('ID \70BA %0 \7684\5340\57DF\4E0D\662F\300C\4E92\52D5\5F0F\65B9\683C\300D\5340\57DF, \6216\8005\4E0D\5B58\5728\65BC\61C9\7528\7A0B\5F0F %1 \4E2D.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953033633873910)
,p_name=>'APEX.IG.NOT_IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5728')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285953852031873911)
,p_name=>'APEX.IG.NOT_IN_THE_LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5728\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954089288873911)
,p_name=>'APEX.IG.NOT_IN_THE_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5728\5F8C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978556398873929)
,p_name=>'APEX.IG.NO_DATA_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\8CC7\6599')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411441150874252)
,p_name=>'APEX.IG.NULLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286421427900874260)
,p_name=>'APEX.IG.NUMBER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411974685874253)
,p_name=>'APEX.IG.OFF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412033382874253)
,p_name=>'APEX.IG.ON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\555F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285936038814873898)
,p_name=>'APEX.IG.ONE_MINUTE_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('1 \5206\9418\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429184665874265)
,p_name=>'APEX.IG.OPEN_COLORPICKER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\555F\8272\5F69\9078\64C7\5668: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404624667874247)
,p_name=>'APEX.IG.OPEN_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\76E4\50F9')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971770775873924)
,p_name=>'APEX.IG.OPERATOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97\5B50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404005895874247)
,p_name=>'APEX.IG.ORIENTATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\5411')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406459769874248)
,p_name=>'APEX.IG.PIE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5713\9905\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285973077815873925)
,p_name=>'APEX.IG.PIVOT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A1E\7D10\5206\6790\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710908507873746)
,p_name=>'APEX.IG.PIVOT_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A1E\7D10\5206\6790\8868\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286429019252874265)
,p_name=>'APEX.IG.PLACEHOLDER_INVALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528 "%0" \5340\9694\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406541450874249)
,p_name=>'APEX.IG.POLAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6975\5EA7\6A19\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420377695874259)
,p_name=>'APEX.IG.POSITION_CENTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E2D\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420454701874259)
,p_name=>'APEX.IG.POSITION_END'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\5C3E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286420255406874259)
,p_name=>'APEX.IG.POSITION_START'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\982D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970915074873923)
,p_name=>'APEX.IG.PRIMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971235404873924)
,p_name=>'APEX.IG.PRIMARY_DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\9810\8A2D\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286266208658874140)
,p_name=>'APEX.IG.PRIMARY_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406682367874249)
,p_name=>'APEX.IG.RADAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96F7\9054\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406779570874249)
,p_name=>'APEX.IG.RANGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\570D\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286430557740874266)
,p_name=>'APEX.IG.REFRESH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979394503873930)
,p_name=>'APEX.IG.REFRESH_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978163879873929)
,p_name=>'APEX.IG.REFRESH_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712492705873747)
,p_name=>'APEX.IG.REMOVE_CONTROL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970349815873923)
,p_name=>'APEX.IG.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463780365874290)
,p_name=>'APEX.IG.REPORT.DELETED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\522A\9664\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463487992874290)
,p_name=>'APEX.IG.REPORT.SAVED.ALTERNATIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\70BA\6240\6709\4F7F\7528\8005\5132\5B58\66FF\4EE3\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463398380874290)
,p_name=>'APEX.IG.REPORT.SAVED.DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\70BA\6240\6709\4F7F\7528\8005\5132\5B58\9810\8A2D\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463682710874290)
,p_name=>'APEX.IG.REPORT.SAVED.PRIVATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5132\5B58\5C08\7528\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463502522874290)
,p_name=>'APEX.IG.REPORT.SAVED.PUBLIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\70BA\6240\6709\4F7F\7528\8005\5132\5B58\516C\7528\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285935924192873898)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF.X.MINUTES_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\9418\524D\7684\5831\8868\8CC7\6599')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285935841568873898)
,p_name=>'APEX.IG.REPORT_DATA_AS_OF_ONE_MINUTE_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('1 \5206\9418\524D\7684\5831\8868\8CC7\6599')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434972837874269)
,p_name=>'APEX.IG.REPORT_EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868 - \7DE8\8F2F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286434802231874269)
,p_name=>'APEX.IG.REPORT_SAVE_AS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868 - \53E6\5B58\65B0\6A94')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712514878873747)
,p_name=>'APEX.IG.REPORT_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\8A2D\5B9A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286473171232874298)
,p_name=>'APEX.IG.REPORT_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\975C\614B ID \70BA %0 \7684\300C\9810\5B58\4E92\52D5\5F0F\65B9\683C\300D\4E0D\5B58\5728.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447205980874278)
,p_name=>'APEX.IG.REPORT_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711600676873746)
,p_name=>'APEX.IG.RESET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8A2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979448882873930)
,p_name=>'APEX.IG.REVERT_CHANGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\5FA9\8B8A\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978204783873929)
,p_name=>'APEX.IG.REVERT_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\5FA9\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971396112873924)
,p_name=>'APEX.IG.ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970257348873923)
,p_name=>'APEX.IG.ROWS_PER_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\9801\8CC7\6599\5217\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286471756947874296)
,p_name=>'APEX.IG.ROW_ACTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\52D5\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286478966830874302)
,p_name=>'APEX.IG.ROW_ACTIONS_FOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217 %0 \7684\52D5\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285711958745873746)
,p_name=>'APEX.IG.SAVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286054316067873984)
,p_name=>'APEX.IG.SAVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5132\5B58')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710107481873745)
,p_name=>'APEX.IG.SAVED_REPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\5B58\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710241103873745)
,p_name=>'APEX.IG.SAVED_REPORT_DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710311205873745)
,p_name=>'APEX.IG.SAVED_REPORT_PRIVATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C08\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710469253873745)
,p_name=>'APEX.IG.SAVED_REPORT_PUBLIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\516C\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286446906309874278)
,p_name=>'APEX.IG.SAVE_AS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53E6\5B58\65B0\6A94')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285977533115873928)
,p_name=>'APEX.IG.SAVE_REPORT_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\5831\8868\8A2D\5B9A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406858256874249)
,p_name=>'APEX.IG.SCATTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6563\5E03\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285710067972873745)
,p_name=>'APEX.IG.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425683225874263)
,p_name=>'APEX.IG.SEARCH.ALL_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B: \6240\6709\6587\5B57\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285709905312873745)
,p_name=>'APEX.IG.SEARCH.COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286424468985874262)
,p_name=>'APEX.IG.SEARCH.ORACLE_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B: \5168\6587')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285935711128873898)
,p_name=>'APEX.IG.SEARCH_FOR.X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B ''%0''')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286400363216874244)
,p_name=>'APEX.IG.SELECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6 -')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774543014873789)
,p_name=>'APEX.IG.SELECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286373161799874224)
,p_name=>'APEX.IG.SELECT_1_ROW_IN_MASTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\4E3B\8981\5340\57DF\4E2D\7684 1 \500B\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285709856341873745)
,p_name=>'APEX.IG.SELECT_COLUMNS_TO_SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\8981\641C\5C0B\7684\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286470761621874296)
,p_name=>'APEX.IG.SEL_ACTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\52D5\4F5C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774740897873789)
,p_name=>'APEX.IG.SEL_MODE_CELL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\5132\5B58\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774636683873789)
,p_name=>'APEX.IG.SEL_MODE_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426258980874263)
,p_name=>'APEX.IG.SEND_AS_EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4EE5\96FB\5B50\90F5\4EF6\50B3\9001')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286409747471874251)
,p_name=>'APEX.IG.SERIES_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285670757268873718)
,p_name=>'APEX.IG.SHOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285661838874155)
,p_name=>'APEX.IG.SHOW_OVERALL_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\6574\9AD4\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979041694873929)
,p_name=>'APEX.IG.SINGLE_ROW_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\55AE\4E00\8CC7\6599\5217\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285973245405873925)
,p_name=>'APEX.IG.SORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286409805368874251)
,p_name=>'APEX.IG.SORT_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F\4F9D\64DA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286471860145874297)
,p_name=>'APEX.IG.SORT_ONLY_ONE_PER_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\500B\8CC7\6599\6B04\53EA\80FD\5B9A\7FA9\4E00\7A2E\6392\5E8F\65B9\5F0F.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286470942850874296)
,p_name=>'APEX.IG.SRV_CHANGE_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\529F\80FD\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412153389874253)
,p_name=>'APEX.IG.STACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5806\758A\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285954371333873911)
,p_name=>'APEX.IG.STARTS_WITH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\982D\70BA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286406950411874249)
,p_name=>'APEX.IG.STOCK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\80A1\7968\5206\6790\5716')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285599481768873667)
,p_name=>'APEX.IG.STRETCH_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EF6\4F38\8CC7\6599\6B04\5BEC\5EA6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285977778188873928)
,p_name=>'APEX.IG.SUBSCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A02\95B1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286318245362874179)
,p_name=>'APEX.IG.SUM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\548C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286479134517874302)
,p_name=>'APEX.IG.SUMMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\52D5\5F0F\65B9\683C. \5831\8868: %0, \8996\89C0\8868: %1.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286447328608874278)
,p_name=>'APEX.IG.SUM_OVERALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\9AD4\7E3D\548C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405114641874248)
,p_name=>'APEX.IG.TARGET_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\6A19')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419511284874258)
,p_name=>'APEX.IG.TEXT_COLOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57\8272\5F69')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285712610728873747)
,p_name=>'APEX.IG.TOGGLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5207\63DB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285581362874155)
,p_name=>'APEX.IG.TOOLTIP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\5177\63D0\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285970485076873923)
,p_name=>'APEX.IG.TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\985E\578B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285978997249873929)
,p_name=>'APEX.IG.UNFREEZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89E3\9664\51CD\7D50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971941079873924)
,p_name=>'APEX.IG.UNIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\55AE\4F4D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286426091300874263)
,p_name=>'APEX.IG.UNSAVED_CHANGES_CONTINUE_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6709\672A\5132\5B58\7684\8B8A\66F4. \8981\7E7C\7E8C\55CE?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285971825979873924)
,p_name=>'APEX.IG.VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404223644874247)
,p_name=>'APEX.IG.VALUE_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286413272255874254)
,p_name=>'APEX.IG.VALUE_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\8F38\5165\503C.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286357773880874212)
,p_name=>'APEX.IG.VALUE_TIMESTAMP_TZ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C (\4E0D\80FD\8B8A\66F4\6642\5340)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286421548788874260)
,p_name=>'APEX.IG.VARCHAR2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405528156874248)
,p_name=>'APEX.IG.VERTICAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5782\76F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285969927550873923)
,p_name=>'APEX.IG.VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286400423131874244)
,p_name=>'APEX.IG.VISIBLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\986F\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286405082817874247)
,p_name=>'APEX.IG.VOLUME_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6210\4EA4\91CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285955309893873912)
,p_name=>'APEX.IG.WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9031')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286400547331874244)
,p_name=>'APEX.IG.WIDTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5C0F\8CC7\6599\6B04\5BEC\5EA6 (\50CF\7D20)')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885578943873864)
,p_name=>'APEX.IG.X.BETWEEN.Y.AND.Z'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4ECB\65BC %1 \5230 %2 \4E4B\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885211025873863)
,p_name=>'APEX.IG.X.CONTAINS.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5305\542B %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885392972873864)
,p_name=>'APEX.IG.X.DOES_NOT_CONTAIN.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \672A\5305\542B %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285666969621873715)
,p_name=>'APEX.IG.X.DOES_NOT_START_WITH.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\662F\4EE5 %1 \70BA\958B\982D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884026200873863)
,p_name=>'APEX.IG.X.EQUALS.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \7B49\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884291201873863)
,p_name=>'APEX.IG.X.GREATER_THAN.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5927\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884383464873863)
,p_name=>'APEX.IG.X.GREATER_THAN_OR_EQUALS.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5927\65BC\6216\7B49\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885043935873863)
,p_name=>'APEX.IG.X.IN.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728 %1 \4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886208470873864)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D %1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886059973873864)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D %1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885860945873864)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D %1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886683901873865)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D %1 \500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886482637873864)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D %1 \9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886879637873865)
,p_name=>'APEX.IG.X.IN_THE_LAST.Y.YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D %1 \5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886162836873864)
,p_name=>'APEX.IG.X.IN_THE_LAST_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D 1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885935875873864)
,p_name=>'APEX.IG.X.IN_THE_LAST_HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D 1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885708589873864)
,p_name=>'APEX.IG.X.IN_THE_LAST_MINUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D 1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886500856873865)
,p_name=>'APEX.IG.X.IN_THE_LAST_MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\4E0A\500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886306679873864)
,p_name=>'APEX.IG.X.IN_THE_LAST_WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\4E0A\9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886769436873865)
,p_name=>'APEX.IG.X.IN_THE_LAST_YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\53BB\5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888675191873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C %1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888469163873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C %1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888295146873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C %1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889011923873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\4E0B %1 \500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888818699873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\4E0B %1 \9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889239321873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT.Y.YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C %1 \5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888525689873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C 1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888347191873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT_HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C 1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888120332873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MINUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C 1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888969945873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT_MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\4E0B\500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888743331873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT_WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\4E0B\9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889104508873866)
,p_name=>'APEX.IG.X.IN_THE_NEXT_YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\660E\5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884728369873863)
,p_name=>'APEX.IG.X.IS_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\662F\7A7A\7684')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884671353873863)
,p_name=>'APEX.IG.X.IS_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \662F\7A7A\7684')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884485987873863)
,p_name=>'APEX.IG.X.LESS_THAN.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5C0F\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884588634873863)
,p_name=>'APEX.IG.X.LESS_THAN_OR_EQUALS.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5C0F\65BC\6216\7B49\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884878476873863)
,p_name=>'APEX.IG.X.LIKE.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \540C\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885403658873864)
,p_name=>'APEX.IG.X.MATCHES_REGULAR_EXPRESSION.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \7B26\5408\6B63\898F\8868\793A\5F0F %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285936182647873898)
,p_name=>'APEX.IG.X.MINUTES_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\9418\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885614274873864)
,p_name=>'APEX.IG.X.NOT_BETWEEN.Y.AND.Z'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\4ECB\65BC %1 \5230 %2 \4E4B\9593')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884116306873863)
,p_name=>'APEX.IG.X.NOT_EQUALS.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\7B49\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285885126028873863)
,p_name=>'APEX.IG.X.NOT_IN.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728 %1 \4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887428089873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D %1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887246831873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D %1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887017486873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D %1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887863139873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D %1 \500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887672828873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D %1 \9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285888051900873866)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST.Y.YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D %1 \5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887353236873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D 1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887129353873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D 1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285886943120873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MINUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D 1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887770926873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\4E0A\500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887571750873865)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\4E0A\9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285887962393873866)
,p_name=>'APEX.IG.X.NOT_IN_THE_LAST_YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\53BB\5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889894393873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C %1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889668625873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C %1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889474044873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C %1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890281466873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\4E0B %1 \500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890076179873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\4E0B %1 \9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890401457873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT.Y.YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C %1 \5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889782593873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C 1 \5929\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889508794873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C 1 \5C0F\6642\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889396771873866)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MINUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C 1 \5206\9418')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890139293873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\4E0B\500B\6708\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285889915996873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\4E0B\9031\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890304066873867)
,p_name=>'APEX.IG.X.NOT_IN_THE_NEXT_YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\660E\5E74\4E2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285884931257873863)
,p_name=>'APEX.IG.X.NOT_LIKE.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\540C\65BC %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285946023836873905)
,p_name=>'APEX.IG.X.STARTS_WITH.Y'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \958B\982D\70BA %1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404343632874247)
,p_name=>'APEX.IG.X_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>'X'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285955541786873912)
,p_name=>'APEX.IG.YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E74')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404417459874247)
,p_name=>'APEX.IG.Y_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>'Y'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286404528520874247)
,p_name=>'APEX.IG.Z_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>'Z'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425075230874262)
,p_name=>'APEX.IG_FORMAT_SAMPLE_1'
,p_message_language=>'zh-tw'
,p_message_text=>'Monday, 12 January, 2016'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425140825874262)
,p_name=>'APEX.IG_FORMAT_SAMPLE_2'
,p_message_language=>'zh-tw'
,p_message_text=>'January'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425233676874262)
,p_name=>'APEX.IG_FORMAT_SAMPLE_3'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('16 \5C0F\6642\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286425334903874262)
,p_name=>'APEX.IG_FORMAT_SAMPLE_4'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('16 \5C0F\6642\5167')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285281158389873434)
,p_name=>'APEX.INSTANCE_ADMIN.BIPUB_OPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5217\5370\652F\63F4\5FC5\9808\662F\300C\6A19\6E96\300D\6216\300C\9032\968E\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285281262238873434)
,p_name=>'APEX.INSTANCE_ADMIN.FIRST_SCHEMA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\79FB\9664\7B2C\4E00\500B\4F48\5EFA\7684\7DB1\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285170049960873352)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\61C9\7528\7A0B\5F0F ID.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285708083940873744)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_EMAIL_ADDRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\96FB\5B50\90F5\4EF6\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285151160953873338)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_HISTORY_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\5FC5\9808\662F\96F6\6216\6B63\6574\6578.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285281305482873434)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_PORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\9023\63A5\57E0\865F\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285743887385873769)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_SUBSCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\8A02\95B1 ID.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285281438939873434)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WALLET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\516C\4E8B\5305\8DEF\5F91\5FC5\9808\5728\8868\55AE\6A94\6848\4E2D: <filesystempath>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285372871017873501)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\5DE5\4F5C\5340.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285372760186873500)
,p_name=>'APEX.INSTANCE_ADMIN.INVALID_WORKSPACE_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\5DE5\4F5C\5340 ID.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285300382691873448)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REGEXP_MISMATCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\8655\7406\53C3\6578 "%0" \7684\503C "%1" \4E0D\7B26\5408\6B63\898F\8868\793A\5F0F "%2"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285300285556873448)
,p_name=>'APEX.INSTANCE_ADMIN.PARAMETER_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\8655\7406\53C3\6578 "%0" \5FC5\9808\6709\4E00\500B\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285281546182873434)
,p_name=>'APEX.INSTANCE_ADMIN.PARM_NOTFOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\57F7\884C\8655\7406\53C3\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285739401884873766)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.APEX-AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285104812179873304)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.CLOUD_IDM-AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC (\50C5\7528\65BC\5DE5\4F5C\5340\4F7F\7528\8005\5E33\6236\5132\5B58\5340\57DF\8A8D\8B49)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286024941841873963)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.HEADER-AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC (\50C5\7528\65BC\5DE5\4F5C\5340\4F7F\7528\8005\5E33\6236\5132\5B58\5340\57DF\8A8D\8B49)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846452201873837)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.LDAP-AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC (\50C5\7528\65BC\5DE5\4F5C\5340\4F7F\7528\8005\5E33\6236\5132\5B58\5340\57DF\8A8D\8B49)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285426680696873539)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SOCIAL-AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC (\50C5\7528\65BC\5DE5\4F5C\5340\4F7F\7528\8005\5E33\6236\5132\5B58\5340\57DF\8A8D\8B49)')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285739323815873766)
,p_name=>'APEX.INSTANCE_ADMIN.PASSWORD_REGION_TITLE.SSO-AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC (\50C5\7528\65BC\5DE5\4F5C\5340\4F7F\7528\8005\5E33\6236\5132\5B58\5340\57DF\8A8D\8B49)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285283445484873436)
,p_name=>'APEX.INSTANCE_ADMIN.PRINTSVR_PROTOCOL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5217\5370\4F3A\670D\5668\5354\5B9A\5FC5\9808\662F HTTP \6216 HTTPS')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285283576621873436)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DB1\8981\4E0D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285283686021873436)
,p_name=>'APEX.INSTANCE_ADMIN.SCHEMA_RESTRICTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DB1\8981\53D7\5230\9650\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129715362873322)
,p_name=>'APEX.ISSUES.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129565188873322)
,p_name=>'APEX.ISSUES.APPLICATION_NO_LONGER_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5DF2\4E0D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286074135491873998)
,p_name=>'APEX.ISSUES.ASSIGN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354440363874209)
,p_name=>'APEX.ISSUES.CARDS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5361\7247')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131686652873324)
,p_name=>'APEX.ISSUES.COMMENTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\52A0\8A3B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131541979873324)
,p_name=>'APEX.ISSUES.COMMENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A3B\89E3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106365572873306)
,p_name=>'APEX.ISSUES.DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106192976873305)
,p_name=>'APEX.ISSUES.DELETE_COMMENT_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\5B9A\8981\5C07\6B64\8A3B\89E3\522A\9664?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286058508144873987)
,p_name=>'APEX.ISSUES.DELETE_ISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\554F\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285115916884873313)
,p_name=>'APEX.ISSUES.DELETE_ISSUE_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\5B9A\8981\522A\9664\6B64\554F\984C\55CE?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133276143873325)
,p_name=>'APEX.ISSUES.DOCUMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132158198873324)
,p_name=>'APEX.ISSUES.DOCUMENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106235383873305)
,p_name=>'APEX.ISSUES.EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286282017475874152)
,p_name=>'APEX.ISSUES.EDIT_COMMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\8A3B\89E3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286282144491874152)
,p_name=>'APEX.ISSUES.EDIT_ISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\554F\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130301063873323)
,p_name=>'APEX.ISSUES.ERR_APP_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7684\61C9\7528\7A0B\5F0F\4E0D\5B58\5728\65BC\6B64\5DE5\4F5C\5340\4E2D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130743252873323)
,p_name=>'APEX.ISSUES.ERR_ATTEMPTING_TO_DELETE_COMMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5617\8A66\522A\9664\8A3B\89E3\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130656914873323)
,p_name=>'APEX.ISSUES.ERR_COMMENT_NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\8A3B\89E3.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130965895873323)
,p_name=>'APEX.ISSUES.ERR_ISSUE_NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\554F\984C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131015422873323)
,p_name=>'APEX.ISSUES.ERR_MARKING_ISSUE_FOR_DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5617\8A66\5C07\554F\984C\6A19\793A\70BA\8981\522A\9664\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130495124873323)
,p_name=>'APEX.ISSUES.ERR_PAGE_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7684\9801\9762\4E0D\5B58\5728\65BC\6B64\5DE5\4F5C\5340\6216\63D0\4F9B\7684\61C9\7528\7A0B\5F0F\4E2D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130814681873323)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_DELETE_COMMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A\4F7F\7528\8005\522A\9664\6B64\8A3B\89E3.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131115084873323)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_TO_DELETE_ISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A\4F7F\7528\8005\522A\9664\6B64\554F\984C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130552196873323)
,p_name=>'APEX.ISSUES.ERR_USER_NOT_AUTH_VISIBILITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A\4F7F\7528\8005\8B8A\66F4\6B64\8A3B\89E3\7684\53EF\898B\6027.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286290951832874159)
,p_name=>'APEX.ISSUES.FILE_SIZE_CHECK_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\67E5\6A94\6848\5927\5C0F\6642\767C\751F\554F\984C. \8ACB\6D3D\8A62\7CFB\7D71\7BA1\7406\54E1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286290800541874159)
,p_name=>'APEX.ISSUES.FILE_SIZE_PLURAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4E2D\4E00\500B\6A94\6848\5927\65BC %0 \500B\4F4D\5143\7D44\7684\6A94\6848\5927\5C0F\4E0A\9650.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286290782967874158)
,p_name=>'APEX.ISSUES.FILE_SIZE_SINGULAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A94\6848\5927\65BC %0 \500B\4F4D\5143\7D44\7684\6A94\6848\5927\5C0F\4E0A\9650.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106411440873306)
,p_name=>'APEX.ISSUES.HIDE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133044584873325)
,p_name=>'APEX.ISSUES.IMAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F71\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131941147873324)
,p_name=>'APEX.ISSUES.IMAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F71\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129386664873322)
,p_name=>'APEX.ISSUES.ISSUE_NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7CFB\7D71\4E2D\627E\4E0D\5230\7684\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285090064728873294)
,p_name=>'APEX.ISSUES.JS.ADD_NOTIFICATION_PREFS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\4F7F\7528\8005\7684\504F\597D\8A2D\5B9A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131794058873324)
,p_name=>'APEX.ISSUES.JS.ATTACH_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\52A0\6A94\6848')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131436710873324)
,p_name=>'APEX.ISSUES.JS.CLOSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8655\7406')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286360092940874214)
,p_name=>'APEX.ISSUES.JS.HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132711664873325)
,p_name=>'APEX.ISSUES.JS.IS_EMPTY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F\7A7A\7684.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132596011873324)
,p_name=>'APEX.ISSUES.JS.ONE_OF_THESE_FILES_IS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9019\4E9B\6A94\6848\5176\4E2D\4E4B\4E00')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131354258873324)
,p_name=>'APEX.ISSUES.JS.OPEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F85\8655\7406')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133872786873325)
,p_name=>'APEX.ISSUES.JS.PERMANENTLY_DELETE_SELECTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C38\4E45\522A\9664\9078\53D6\9805\76EE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286059479678873987)
,p_name=>'APEX.ISSUES.JS.PURGE_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\6C38\4E45\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133760403873325)
,p_name=>'APEX.ISSUES.JS.RESINSTATE_SELECTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6062\5FA9\9078\53D6\9805\76EE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131867588873324)
,p_name=>'APEX.ISSUES.JS.RESPONSE_TEMPLATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\61C9\6A23\677F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132667750873325)
,p_name=>'APEX.ISSUES.JS.SINGLE_TOO_LARGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\592A\5927\7121\6CD5\4E0A\50B3. <br>\6A94\6848\5FC5\9808\5C0F\65BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132928424873325)
,p_name=>'APEX.ISSUES.JS.SUPPORTED_FILE_TYPES_ARE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\652F\63F4\7684\6A94\6848\985E\578B\70BA: ')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285927418874155)
,p_name=>'APEX.ISSUES.JS.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\56DE\61C9\6A23\677F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132482779873324)
,p_name=>'APEX.ISSUES.JS.THIS_FILE_IS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\6A94\6848')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132852024873325)
,p_name=>'APEX.ISSUES.JS.UNSUPPORTED_FILE_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\662F\652F\63F4\7684\6A94\6848\985E\578B.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998298766873943)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.BUG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998890240873944)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.DOCUMENTATIONISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\4EF6\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998399081873943)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.ENHANCEMENTREQUEST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\589E\5F37\529F\80FD\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998437032873943)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.FEATUREREQUEST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998734224873943)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.INSTALLATIONISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\88DD\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998602694873943)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.PERFORMANCEISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6548\80FD\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998525715873943)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.SECURITYISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\5168\6027\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998942211873944)
,p_name=>'APEX.ISSUES.LABELS.CATEGORY.TRAININGISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A13\7DF4\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999683579873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.ADMINISTRATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999330291873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.CSSHTML'
,p_message_language=>'zh-tw'
,p_message_text=>'CSS / HTML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999460316873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DAJAVASCRIPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\614B\52D5\4F5C / JavaScript')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999163636873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.DATABASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999701956873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.EXTINTEGRATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5916\90E8\7CFB\7D71\6574\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999298623873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.RESTINTEGRATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('REST \6574\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999584115873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.SECURITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\5168\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999064103873944)
,p_name=>'APEX.ISSUES.LABELS.FUNCTIONALAREA.UIUX'
,p_message_language=>'zh-tw'
,p_message_text=>'UI / UX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998111736873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7D66\554F\984C\7684\985E\5225.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997217429873942)
,p_name=>'APEX.ISSUES.LABELS.GROUP.CATEGORY.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\985E\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285998060928873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D7\554F\984C\5F71\97FF\7684\529F\80FD\5340\57DF.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997387375873942)
,p_name=>'APEX.ISSUES.LABELS.GROUP.FUNCTIONALAREA.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997957093873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7D66\554F\984C\7684\91CD\8981\6027\7A0B\5EA6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997489807873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.IMPORTANCE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8981\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997807467873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\554F\984C\7684\6295\5165\7A0B\5EA6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997564905873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.LEVELOFEFFORT.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6295\5165\7A0B\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997775110873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\554F\984C\7684\9032\5EA6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997608450873943)
,p_name=>'APEX.ISSUES.LABELS.GROUP.PROGRESS.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9032\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000147268873945)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.BACKLOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A4D\58D3\7684\6848\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999884805873944)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.CRITICAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56B4\91CD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285999981900873944)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.IMPORTANT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000099061873944)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.NORMAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\822C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000273849873945)
,p_name=>'APEX.ISSUES.LABELS.IMPORTANCE.WILLNOTADDRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\4E0D\8655\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000358476873945)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.EASY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F15\9B06\4FEE\6B63')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000584612873945)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.LARGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5927\91CF\958B\767C\4EBA\529B\6295\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000439041873945)
,p_name=>'APEX.ISSUES.LABELS.LEVELOFEFFORT.MODERATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E2D\5EA6\4EBA\529B\6295\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000955842873945)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.CANNOTFIX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\4FEE\6B63')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286001051876873945)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.COMPLETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000777149873945)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.REQUIRESMOREINFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\5176\4ED6\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000825006873945)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WAITINGONTHIRDPARTY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B49\5F85\7B2C\4E09\65B9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286000632875873945)
,p_name=>'APEX.ISSUES.LABELS.PROGRESS.WORKINGONIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286011380017873953)
,p_name=>'APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\300C\6A19\7C64\7FA4\7D44\300D\7684\4E00\6216\591A\500B\6210\54E1\5DF2\6307\5B9A\7D66\67D0\500B\554F\984C, \56E0\6B64\4E0D\80FD\522A\9664\6B64\7FA4\7D44.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285131213345873324)
,p_name=>'APEX.ISSUES.MARKED_DUPLICATE_OF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6A19\793A\70BA\91CD\8907 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286058962644873987)
,p_name=>'APEX.ISSUES.MENU.ASSIGNEES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\5C0D\8C61')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286058867483873987)
,p_name=>'APEX.ISSUES.MENU.LABELS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286059383010873987)
,p_name=>'APEX.ISSUES.MENU.MILESTONES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CC\7A0B\7891')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286058779967873987)
,p_name=>'APEX.ISSUES.MENU.STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\72C0\614B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129115355873322)
,p_name=>'APEX.ISSUES.MILESTONES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\500B\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286001619149873946)
,p_name=>'APEX.ISSUES.MILESTONES.CODEFREEZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A0B\5F0F\78BC\51CD\7D50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286001845572873946)
,p_name=>'APEX.ISSUES.MILESTONES.FINALRELEASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\7D42\7248\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286001709424873946)
,p_name=>'APEX.ISSUES.MILESTONES.UIFREEZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('UI \51CD\7D50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133683899873325)
,p_name=>'APEX.ISSUES.NOTIFY.ADDED_A_COMMENT_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5DF2\5C07\8A3B\89E3\65B0\589E\81F3 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285089721032873293)
,p_name=>'APEX.ISSUES.NOTIFY.HAS_CHANGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8B8A\66F4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286015571174873956)
,p_name=>'APEX.ISSUES.NOTIFY.ISSUE_HAS_CHANGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340 %1 \4E2D\7684\554F\984C\7DE8\865F %0 \5DF2\8B8A\66F4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286290690593874158)
,p_name=>'APEX.ISSUES.NO_LABLES_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C1A\672A\5B9A\7FA9\4EFB\4F55\6A19\7C64.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132399522873324)
,p_name=>'APEX.ISSUES.OTHER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129876080873323)
,p_name=>'APEX.ISSUES.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129608523873322)
,p_name=>'APEX.ISSUES.PAGE_NO_LONGER_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\5DF2\4E0D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286351938816874205)
,p_name=>'APEX.ISSUES.PURGE_BUTTON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\6C38\4E45\6E05\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286074205841873998)
,p_name=>'APEX.ISSUES.REMOVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129404215873322)
,p_name=>'APEX.ISSUES.REMOVED_ASSOCIATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\79FB\9664\61C9\7528\7A0B\5F0F\548C\9801\9762\95DC\806F, \5F9E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130122203873323)
,p_name=>'APEX.ISSUES.REMOVED_THE_ATTACHMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\79FB\9664\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286325751925874184)
,p_name=>'APEX.ISSUES.REPLACE_COMMENT_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\4EE5\6B64\6A23\677F\53D6\4EE3\60A8\76EE\524D\7684\8A3B\89E3\55CE?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327707270874186)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_BODY'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\597D! '),
'',
unistr('\9019\662F\60A8\7684\7B2C\4E00\500B\554F\984C! \60A8\53EF\4EE5\5EFA\7ACB\554F\984C\4F86\8FFD\8E64\60A8\6240\6709 APEX \5C08\6848\7684\5DE5\4F5C\3001\529F\80FD\3001\932F\8AA4\53CA\610F\898B\56DE\994B!  \60A8\53EF\4EE5\4F7F\7528\7C21\6613\5F0F Markdown \70BA\554F\984C\65B0\589E\6A19\7C64\3001\65B0\589E\6307\5B9A\5C0D\8C61\3001\8A2D\5B9A\91CC\7A0B\7891, \751A\81F3\662F\5957\7528\683C\5F0F!  '),
'',
unistr('\4EE5\4E0B\662F\60A8\53EF\4EE5\4F7F\7528 Markdown \8655\7406\54EA\4E9B\4F5C\696D\7684\5FEB\901F\7BC4\4F8B:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327688810874186)
,p_name=>'APEX.ISSUES.SAMPLE_ISSUE_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B61\8FCE\4F7F\7528 Oracle APEX \4E2D\7684\5718\968A\958B\767C!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286074589519873998)
,p_name=>'APEX.ISSUES.SELECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130238097873323)
,p_name=>'APEX.ISSUES.SET_STATUS_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\72C0\614B\8A2D\70BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106664258873306)
,p_name=>'APEX.ISSUES.SHOW_ACTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327533619874186)
,p_name=>'APEX.ISSUES.SHOW_MORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\66F4\591A\9805\76EE...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129957318873323)
,p_name=>'APEX.ISSUES.SUBSCRIBED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8A02\95B1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286291078170874159)
,p_name=>'APEX.ISSUES.SUMMARY_LINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340 %1 \4E2D\7684 %0 \6709 %2 \500B\65B0\7684\901A\77E5.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285994731826873941)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7528\4F86\8A18\9304\932F\8AA4\7684\6A23\677F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285994606663873940)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285994503629873940)
,p_name=>'APEX.ISSUES.TEMPLATE.BUG.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\9810\671F\7684\884C\70BA**'),
unistr('- \544A\8A34\6211\5011\60A8\8A8D\70BA\61C9\8A72\767C\751F\7684\60C5\6CC1.'),
'',
'',
unistr('**\76EE\524D\7684\884C\70BA**'),
unistr('- \544A\8A34\6211\5011\767C\751F\7684\60C5\6CC1.'),
'',
'',
unistr('**\53D7\5F71\97FF\8005**'),
unistr('- \544A\8A34\6211\5011\53D7\5F71\97FF\7684\4EBA/\7269. '),
'',
unistr('**\53EF\80FD\7684\89E3\6C7A\65B9\6848**'),
unistr('- \5982\679C\53EF\4EE5, \8ACB\63D0\8B70\60A8\8981\5982\4F55\4FEE\6B63\6B64\932F\8AA4.'),
'',
unistr('**\932F\8AA4\91CD\73FE\6B65\9A5F**'),
unistr('- \63D0\4F9B\4E00\7D44\6E05\695A\7684\932F\8AA4\91CD\73FE\6B65\9A5F, \5305\62EC\64F7\53D6\756B\9762\548C\7A0B\5F0F\78BC\7247\6BB5 (\5982\679C\9069\7528).'),
'1.',
'2.',
'3.',
'',
unistr('**\76F8\95DC\8CC7\8A0A**'),
unistr('- \767C\751F\932F\8AA4\6642, \60A8\6B63\5617\8A66\5B8C\6210\4EC0\9EBC. \932F\8AA4\53EA\767C\751F\5728\7279\5B9A\60C5\6CC1\4E0B, \6216\662F\4E00\5929\4E2D\7684\7279\5B9A\6642\9593\7B49\7B49.'),
'',
unistr('**\74B0\5883**'),
'',
unistr('- \7248\672C: '),
unistr('- \5E73\53F0: '),
unistr('- \5B50\7CFB\7D71:'),
'',
'______',
'',
unistr('_**\6CE8\610F:** \82E5\8981\5C07\554F\984C\8207\61C9\7528\7A0B\5F0F\548C (\6216) \9801\9762\5EFA\7ACB\95DC\806F, \8ACB\5148\8A18\9304\8A72\554F\984C, \7136\5F8C\4F7F\7528**\52D5\4F5C**\4E0B\62C9\5F0F\6E05\55AE\4F86\95DC\806F\61C9\7528\7A0B\5F0F\548C\9801\9762._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995882276873941)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\63D0\51FA\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995713096873941)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\63D0\51FA\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995966034873941)
,p_name=>'APEX.ISSUES.TEMPLATE.BUGRAISED.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5DF2\5728\9069\7576\7684\5916\90E8\7CFB\7D71\63D0\51FA**\932F\8AA4**.'),
'',
unistr('- \932F\8AA4\8FFD\8E64\7CFB\7D71: '),
unistr('- \932F\8AA4 ID: '),
unistr('- \932F\8AA4 URL: '),
'',
unistr('\8A3B\89E3:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285994939109873941)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7528\4F86\8A18\9304\529F\80FD\8981\6C42\7684\6A23\677F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285994839585873941)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD\8981\6C42\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995091622873941)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATURE.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\529F\80FD\6458\8981**'),
unistr(' - \63D0\4F9B\4E00\500B\6BB5\843D\7684\529F\80FD\8981\6C42\4E00\822C\7E3D\89BD.'),
'',
'',
unistr('**\76F8\95DC\8CC7\8A0A**'),
unistr(' - \6B64\8981\6C42\662F\8207\7279\5B9A\60C5\6CC1\9084\662F\8655\7406\4F5C\696D\76F8\95DC? \4F8B\5982, "\6BCF\7576 [...] \6642, \6211\5C31\6703\6CAE\55AA"'),
'',
'',
unistr(' - \8ACB\63D0\4F9B\4EFB\4F55\652F\63F4\8CC7\8A0A, \5305\62EC\64F7\53D6\756B\9762\3001\4F7F\7528\6848\4F8B\7B49\7B49.'),
'',
'',
unistr('**\504F\597D\7684\89E3\6C7A\65B9\6848**'),
unistr('- \63D0\4F9B\60A8\60F3\8981\5BE6\884C\4E4B\505A\6CD5\7684\6E05\695A\63CF\8FF0.'),
'',
'',
unistr('**\66FF\4EE3\89E3\6C7A\65B9\6848**'),
unistr('- \63D0\4F9B\6240\8003\91CF\4E4B\66FF\4EE3\89E3\6C7A\65B9\6848\3001\529F\80FD\6216\6240\4F7F\7528\4E4B\56E0\61C9\63AA\65BD\7684\63CF\8FF0.'),
'',
'',
'______',
unistr('_**\6CE8\610F:** \82E5\8981\5C07\554F\984C\8207\61C9\7528\7A0B\5F0F\548C (\6216) \9801\9762\5EFA\7ACB\95DC\806F, \8ACB\5148\8A18\9304\554F\984C, \7136\5F8C\4F7F\7528**\52D5\4F5C**\4E0B\62C9\5F0F\6E05\55AE\4F86\95DC\806F\61C9\7528\7A0B\5F0F\548C\9801\9762._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996187735873942)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\63D0\51FA\529F\80FD\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996084907873942)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\63D0\51FA\529F\80FD\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996254998873942)
,p_name=>'APEX.ISSUES.TEMPLATE.FEATUREFILED.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5DF2\5728\9069\7576\7684\5916\90E8\7CFB\7D71\63D0\51FA**\529F\80FD\8981\6C42**.'),
'',
unistr('- \529F\80FD\8FFD\8E64\7CFB\7D71: '),
unistr('- \529F\80FD ID: '),
unistr('- \529F\80FD\5B9A\7FA9 URL: '),
'',
unistr('\8A3B\89E3:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997080640873942)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\5F8C\7E8C\8FFD\8E64\52D5\4F5C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996934551873942)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\5F8C\7E8C\8FFD\8E64\52D5\4F5C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285997186392873942)
,p_name=>'APEX.ISSUES.TEMPLATE.FOLLOWUP.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8ACB\57F7\884C\4E0B\5217\52D5\4F5C: '),
'',
'1.',
'2.',
'3.',
'4.',
'',
unistr('\8A3B\89E3: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995289865873941)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7528\4F86\8A62\554F\7A0B\5E8F\554F\984C\7684\6A23\677F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995149016873941)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\4F55\9032\884C ...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995317556873941)
,p_name=>'APEX.ISSUES.TEMPLATE.HOWDOI.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\554F\984C**'),
unistr('- \5118\53EF\80FD\7C21\8981\5730\9673\8FF0\60A8\7684\554F\984C\6216\8981\6C42.'),
'',
unistr('**\4E00\822C\76F8\95DC\8CC7\8A0A**'),
unistr('- \60A8\60F3\8981\505A\4EC0\9EBC? '),
'',
'',
unistr('- \60A8\67E5\770B\904E\54EA\4E9B\5176\4ED6\5730\65B9\6216\8207\54EA\4E9B\5176\4ED6\4EBA\54E1\806F\7E6B\4F86\5C0B\627E\7B54\6848? '),
'',
'',
unistr('**\74B0\5883** '),
unistr('\6B64\554F\984C\662F\5426\70BA\74B0\5883\3001\7A0B\5F0F\8A2D\8A08\8A9E\8A00\6216\5176\4ED6\9818\57DF\7279\5B9A\7684\554F\984C?'),
'',
'______',
unistr('_**\6CE8\610F:** \82E5\8981\5C07\554F\984C\8207\61C9\7528\7A0B\5F0F\548C (\6216) \9801\9762\5EFA\7ACB\95DC\806F, \8ACB\5148\8A18\9304\8A72\554F\984C, \7136\5F8C\4F7F\7528**\52D5\4F5C**\4E0B\62C9\5F0F\6E05\55AE\4F86\95DC\806F\61C9\7528\7A0B\5F0F\548C\9801\9762._')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996700648873942)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53C3\8003\5DF2\77E5\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996697462873942)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\77E5\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996851648873942)
,p_name=>'APEX.ISSUES.TEMPLATE.KNOWNISSUE.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7D93\904E\8907\67E5\4E4B\5F8C, \5224\65B7\9019\662F\5DF2\77E5\554F\984C, \8ACB\53C3\95B1\4E0B\65B9\8A73\7D30\8CC7\8A0A.'),
'',
unistr('- \932F\8AA4\8FFD\8E64\7CFB\7D71: '),
unistr('- \932F\8AA4 ID: '),
unistr('- \932F\8AA4 URL: '),
'',
unistr('\8A3B\89E3: ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996430790873942)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\6C42\5176\4ED6\8CC7\8A0A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996323286873942)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\5176\4ED6\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285996525240873942)
,p_name=>'APEX.ISSUES.TEMPLATE.MOREINFO.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('**\9700\8981\6B64\554F\984C\7684\5176\4ED6\8CC7\8A0A:**'),
'',
unistr('\8ACB\5728\4E0B\65B9\63D0\4F9B\8981\6C42\7684\8CC7\8A0A. \82E5\7121\6B64\8CC7\8A0A, \5C07\96E3\4EE5\9032\4E00\6B65\5206\985E\53CA\8655\7406\554F\984C.'),
'',
'',
unistr('\8A3B\89E3:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995552593873941)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\4E0D\6703\91DD\5C0D\6B64\554F\984C\63A1\53D6\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995484565873941)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\63A1\53D6\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285995606871873941)
,p_name=>'APEX.ISSUES.TEMPLATE.WONTACTION.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5728\4ED4\7D30\8003\91CF\4E4B\5F8C, **\5C07\4E0D\91DD\5C0D\6B64\554F\984C\63A1\53D6\9032\4E00\6B65\7684\52D5\4F5C**. '),
'',
unistr('\8A3B\89E3:')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133363675873325)
,p_name=>'APEX.ISSUES.TEXT_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132245252873324)
,p_name=>'APEX.ISSUES.TEXT_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129042749873322)
,p_name=>'APEX.ISSUES.THIS_ISSUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016686012873957)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_ATTACHMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\65B0\589E\9644\4EF6 %0 \81F3 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286015645405873956)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_LABELS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\65B0\589E %0 \81F3 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286017251032873957)
,p_name=>'APEX.ISSUES.TIMELINE.ADDED_MILESTONES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\65B0\589E %0 \81F3 %1 %2				')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286015840636873956)
,p_name=>'APEX.ISSUES.TIMELINE.ASSIGNED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5C07 %0 \6307\5B9A\7D66 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016244917873956)
,p_name=>'APEX.ISSUES.TIMELINE.ASSOCIATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5C07 %0 \8207 %1 %2 \5EFA\7ACB\95DC\806F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133527633873325)
,p_name=>'APEX.ISSUES.TIMELINE.EDITED_A_COMMENT_FOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\7DE8\8F2F %0	%1 \7684\8A3B\89E3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286017131611873957)
,p_name=>'APEX.ISSUES.TIMELINE.HIDDEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\554F\984C\5DF2\7D93\96B1\85CF.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016045489873956)
,p_name=>'APEX.ISSUES.TIMELINE.MARKED_DUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5C07 %0 \6A19\793A\70BA %1 %2 \7684\91CD\8907\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286017023136873957)
,p_name=>'APEX.ISSUES.TIMELINE.OPENED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \7684\958B\555F\8005\70BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016708782873957)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_ATTACHMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5C07\9644\4EF6 %0 \81EA %1 %2 \4E2D\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286015718419873956)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_LABELS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5C07 %0 \81EA %1 %2 \4E2D\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286017347393873957)
,p_name=>'APEX.ISSUES.TIMELINE.REMOVED_MILESTONES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5C07 %0 \81EA %1 %2 \4E2D\79FB\9664 			')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016859543873957)
,p_name=>'APEX.ISSUES.TIMELINE.STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5C07 %0 \7684\72C0\614B\8A2D\70BA %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016469128873956)
,p_name=>'APEX.ISSUES.TIMELINE.SUBSCRIBED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8A02\95B1 %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286015962822873956)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSIGNED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\53D6\6D88\5C07 %0 \6307\5B9A\7D66 %1 %2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016384535873956)
,p_name=>'APEX.ISSUES.TIMELINE.UNASSOCIATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\79FB\9664\61C9\7528\7A0B\5F0F\548C\9801\9762\8207 %0 %1 \7684\95DC\806F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016168442873956)
,p_name=>'APEX.ISSUES.TIMELINE.UNMARKED_DUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\53D6\6D88\5C07 %0 \6A19\793A\70BA %1 \7684\91CD\8907\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016558676873956)
,p_name=>'APEX.ISSUES.TIMELINE.UNSUBSCRIBED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\53D6\6D88\8A02\95B1 %0 %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286016992273873957)
,p_name=>'APEX.ISSUES.TIMELINE_MARKED_DUPLICATE_OF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%2 \5DF2\5C07 %0 %1 \6A19\793A\70BA\91CD\8907\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285129204381873322)
,p_name=>'APEX.ISSUES.UNASSIGNED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\53D6\6D88\6307\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106531160873306)
,p_name=>'APEX.ISSUES.UNHIDE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88\96B1\85CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285130080878873323)
,p_name=>'APEX.ISSUES.UNSUBSCRIBED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\53D6\6D88\8A02\95B1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286058634431873987)
,p_name=>'APEX.ISSUES.UPDATE_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133105051873325)
,p_name=>'APEX.ISSUES.ZIP_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\58D3\7E2E\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285132098399873324)
,p_name=>'APEX.ISSUES.ZIP_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\58D3\7E2E\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286364965633874218)
,p_name=>'APEX.ITEM.FILE.BROWSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286362883528874216)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286362972486874216)
,p_name=>'APEX.ITEM.FILE.CHOOSE_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286467894373874294)
,p_name=>'APEX.ITEM.HELP_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AAA\660E\6587\5B57: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286320931971874181)
,p_name=>'APEX.ITEM.NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\9805\76EE %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285116615894873313)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \4E0D\5728 %0 \5230 %1 \7684\6709\6548\7BC4\570D\4E4B\9593.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285116797122873313)
,p_name=>'APEX.ITEM_TYPE.SLIDER.VALUE_NOT_MULTIPLE_OF_STEP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \4E0D\662F %0 \7684\500D\6578.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285116070987873313)
,p_name=>'APEX.ITEM_TYPE.YES_NO.INVALID_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \5FC5\9808\7B26\5408\503C %0 \8207 %1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285116299551873313)
,p_name=>'APEX.ITEM_TYPE.YES_NO.NO_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775872694873790)
,p_name=>'APEX.ITEM_TYPE.YES_NO.OFF_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775980759873790)
,p_name=>'APEX.ITEM_TYPE.YES_NO.ON_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\555F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285116189665873313)
,p_name=>'APEX.ITEM_TYPE.YES_NO.YES_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285087269818873291)
,p_name=>'APEX.LIST_MANAGER.ADD_ENTRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286032725479873968)
,p_name=>'APEX.LIST_MANAGER.BUTTON_ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286032897219873968)
,p_name=>'APEX.LIST_MANAGER.BUTTON_REMOVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285087393936873292)
,p_name=>'APEX.LIST_MANAGER.SELECTED_ENTRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\7684\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264526941874139)
,p_name=>'APEX.LTO.ADVANCED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9032\968E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264889031874139)
,p_name=>'APEX.LTO.CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264616788874139)
,p_name=>'APEX.LTO.COMMON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264954615874139)
,p_name=>'APEX.LTO.LIVE_TEMPLATE_OPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5373\6642\6A23\677F\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286266144041874140)
,p_name=>'APEX.LTO.NOT_APPLICABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\5143\4EF6\4E26\672A\5728\9801\9762\4E2D\5448\73FE, \56E0\6B64\7121\6CD5\4F7F\7528\300C\6A23\677F\9078\9805\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264423538874139)
,p_name=>'APEX.LTO.NO_OPTIONS_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\4EFB\4F55\300C\6A23\677F\9078\9805\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264746326874139)
,p_name=>'APEX.LTO.SAVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286262250729874137)
,p_name=>'APEX.MARKDOWN.BOLD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7C97\9AD4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263582468874138)
,p_name=>'APEX.MARKDOWN.IMAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F71\50CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263124701874138)
,p_name=>'APEX.MARKDOWN.INLINE_CODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5167\5D4C\7A0B\5F0F\78BC')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358062654874213)
,p_name=>'APEX.MARKDOWN.INSERT_IMAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D2\5165\5F71\50CF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358109451874213)
,p_name=>'APEX.MARKDOWN.INSERT_LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D2\5165\9023\7D50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286262370007874137)
,p_name=>'APEX.MARKDOWN.ITALIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\659C\9AD4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286359827571874214)
,p_name=>'APEX.MARKDOWN.LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263491493874138)
,p_name=>'APEX.MARKDOWN.LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\55AE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263375161874138)
,p_name=>'APEX.MARKDOWN.ORDERED_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6392\5217\7684\6E05\55AE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286262492516874138)
,p_name=>'APEX.MARKDOWN.PREVIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\89BD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286262906649874138)
,p_name=>'APEX.MARKDOWN.PREVIEW_EMPTY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\53EF\9810\89BD\7684\5167\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263068452874138)
,p_name=>'APEX.MARKDOWN.STRIKETHROUGH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\7DDA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263298400874138)
,p_name=>'APEX.MARKDOWN.UNORDERED_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6392\5217\7684\6E05\55AE')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890939687873868)
,p_name=>'APEX.MENU.CURRENT_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286431106654874267)
,p_name=>'APEX.MENU.OVERFLOW_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285890865750873868)
,p_name=>'APEX.MENU.PROCESSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8F09\5165')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286341761179874196)
,p_name=>'APEX.NOTIFICATION_MESSAGE_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\77E5\8A0A\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253053034873413)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\77E5\8A0A\606F\7E3D\548C\6AA2\9A57\5167\5BB9\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285252909513873413)
,p_name=>'APEX.NOTIFICATION_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\77E5\8A0A\606F\7E3D\548C\6AA2\9A57\683C\5F0F\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285966445505873920)
,p_name=>'APEX.NUMBER_FIELD.VALUE_GREATER_MAX_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \5927\65BC\6307\5B9A\7684\6700\5927\503C %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285966593439873920)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \5FC5\9808\662F\6578\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285966635596873920)
,p_name=>'APEX.NUMBER_FIELD.VALUE_INVALID2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \4E0D\7B26\5408\6578\5B57\683C\5F0F %0 (\7BC4\4F8B: %1).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285966381473873920)
,p_name=>'APEX.NUMBER_FIELD.VALUE_LESS_MIN_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \5C0F\65BC\6307\5B9A\7684\6700\5C0F %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285966273420873920)
,p_name=>'APEX.NUMBER_FIELD.VALUE_NOT_BETWEEN_MIN_MAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \4E0D\5728 %0 \5230 %1 \7684\6709\6548\7BC4\570D\4E4B\9593.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285492069489873587)
,p_name=>'APEX.PAGE.DUPLICATE_SUBMIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\7D93\9001\51FA\6B64\9801\9762, \7121\6CD5\91CD\65B0\9001\51FA.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285354734481873487)
,p_name=>'APEX.PAGE.NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\61C9\7528\7A0B\5F0F "%0" \9801\9762 "%1".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285635673400873693)
,p_name=>'APEX.PAGE_ITEM_IS_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\8F38\5165 #LABEL# \503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371385314874223)
,p_name=>'APEX.PAGE_NAME.ABOUT_THIS_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\65BC\6B64\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371156402874222)
,p_name=>'APEX.PAGE_NAME.CONFIGURATION_OPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\614B\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371261398874222)
,p_name=>'APEX.PAGE_NAME.THEME_STYLE_SELECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286033179207873969)
,p_name=>'APEX.POPUP_LOV.BUTTON_CLOSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286033096695873968)
,p_name=>'APEX.POPUP_LOV.BUTTON_FIND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0B\627E %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286033322145873969)
,p_name=>'APEX.POPUP_LOV.BUTTON_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286033280667873969)
,p_name=>'APEX.POPUP_LOV.BUTTON_PREV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285110620759873309)
,p_name=>'APEX.POPUP_LOV.FILTER_REQ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\81F3\5C11\6709 %0 \500B\5B57\5143\7684\641C\5C0B\8A5E.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285684956823873728)
,p_name=>'APEX.POPUP_LOV.ICON_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5373\73FE\5F0F\503C\6E05\55AE: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285110729580873309)
,p_name=>'APEX.POPUP_LOV.INITIAL_FILTER_REQ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\641C\5C0B\8A5E.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285110506573873309)
,p_name=>'APEX.POPUP_LOV.NO_RESULTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\4EFB\4F55\7D50\679C.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285110440795873309)
,p_name=>'APEX.POPUP_LOV.REMOVE_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285853101800873842)
,p_name=>'APEX.POPUP_LOV.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\8A5E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286032930452873968)
,p_name=>'APEX.POPUP_LOV.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\5C0D\8A71\65B9\584A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285113205722873311)
,p_name=>'APEX.PROCESS.NATIVE.GET_NEXT_OR_PREV_PK_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\53D6\5F97\4E0B\4E00\500B\6216\4E0A\4E00\500B\4E3B\7D22\5F15\9375\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846154155873837)
,p_name=>'APEX.PROCESS.NATIVE.WEB_SERVICE.NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230 Web \670D\52D9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285356211985873488)
,p_name=>'APEX.PROCESS.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8655\7406\4F5C\696D\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286325322594874184)
,p_name=>'APEX.PROCESSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8655\7406')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285139907234873330)
,p_name=>'APEX.QOS.REQUEST_LIMIT_REACHED'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7531\65BC\8CC7\6599\5EAB\968E\6BB5\4F5C\696D\8CC7\6E90\7684\9650\5236, Application Express \7121\6CD5\8655\7406\8981\6C42. \8ACB\7A0D\5F8C\518D\8A66.'),
'<p/>',
unistr('\6709\95DC\6B64\672A\9810\671F\4E8B\4EF6\7684\8A73\7D30\8CC7\8A0A, \8ACB\900F\904E\9664\932F ID "%0" \4F86\53D6\5F97.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286382390682874231)
,p_name=>'APEX.REGION.CSSCALENDAR.ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285804592462873809)
,p_name=>'APEX.REGION.CSSCALENDAR.ALL_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286454677941874284)
,p_name=>'APEX.REGION.CSSCALENDAR.BUTTON.SENDEMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\9080\8ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286454350613874284)
,p_name=>'APEX.REGION.CSSCALENDAR.CHOOSE_ACTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819680297873819)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_ALLDAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\6AA2\8996 (\5168\65E5)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819429471873819)
,p_name=>'APEX.REGION.CSSCALENDAR.DAILY_TIME_SPECIFIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\6AA2\8996 (\8CC7\6599\8207\6642\9593)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344261217874198)
,p_name=>'APEX.REGION.CSSCALENDAR.DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286291183772874159)
,p_name=>'APEX.REGION.CSSCALENDAR.DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63CF\8FF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285202216902873376)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.CSV'
,p_message_language=>'zh-tw'
,p_message_text=>'CSV'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285202079298873376)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.ICALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>'iCal'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285201981101873376)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.PDF'
,p_message_language=>'zh-tw'
,p_message_text=>'PDF'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285202146419873376)
,p_name=>'APEX.REGION.CSSCALENDAR.DOWNLOAD.XML'
,p_message_language=>'zh-tw'
,p_message_text=>'XML'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285201689078873375)
,p_name=>'APEX.REGION.CSSCALENDAR.ENDDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\675F\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285201853718873375)
,p_name=>'APEX.REGION.CSSCALENDAR.EVENTNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286454443569874284)
,p_name=>'APEX.REGION.CSSCALENDAR.INVITATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9080\8ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344383782874198)
,p_name=>'APEX.REGION.CSSCALENDAR.LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344041675874198)
,p_name=>'APEX.REGION.CSSCALENDAR.MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6708\4EFD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286359034468874214)
,p_name=>'APEX.REGION.CSSCALENDAR.NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412799644874253)
,p_name=>'APEX.REGION.CSSCALENDAR.NOEVENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286455090203874284)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.FORM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\73FE\6709\4E8B\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286454944100874284)
,p_name=>'APEX.REGION.CSSCALENDAR.OPTION.SEND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\900F\904E\96FB\5B50\90F5\4EF6\50B3\9001\9080\8ACB.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286359155185874214)
,p_name=>'APEX.REGION.CSSCALENDAR.PREVIOUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286398483314874243)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286398046515874242)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.BUTTON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286462024401874289)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\6B04\4F4D\90FD\662F\5FC5\8981\7684.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286461998022874289)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.DIALOG.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\9080\8ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286454072418874283)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.SUBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\65E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286398320884874242)
,p_name=>'APEX.REGION.CSSCALENDAR.SENDEMAIL.TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6536\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285201799419873375)
,p_name=>'APEX.REGION.CSSCALENDAR.STARTDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379073851874228)
,p_name=>'APEX.REGION.CSSCALENDAR.TABLEFORM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \76F8\95DC\8868\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819242689873819)
,p_name=>'APEX.REGION.CSSCALENDAR.TIME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286359795017874214)
,p_name=>'APEX.REGION.CSSCALENDAR.TODAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4ECA\65E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286345150427874199)
,p_name=>'APEX.REGION.CSSCALENDAR.VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344123230874198)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819590501873819)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_ALLDAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9031\6AA2\8996 (\5168\65E5)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819333416873819)
,p_name=>'APEX.REGION.CSSCALENDAR.WEEKLY_TIME_SPECIFIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9031\6AA2\8996 (\8CC7\6599\8207\6642\9593)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344735756874199)
,p_name=>'APEX.REGION.CSSCALENDAR.YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E74\5EA6')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285113583330873311)
,p_name=>'APEX.REGION.FLASH_CHART.INITIALIZING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8D77\59CB...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285372940481873501)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8F09\5165\8CC7\6599...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286383881197874232)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_RESOURCES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8F09\5165\8CC7\6E90...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286383999236874232)
,p_name=>'APEX.REGION.FLASH_CHART.LOADING_TEMPLATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8F09\5165\6A23\677F...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285113649964873311)
,p_name=>'APEX.REGION.FLASH_CHART.NO_DATA_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\8CC7\6599.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285278491398873432)
,p_name=>'APEX.REGION.FLASH_CHART.SHOW_XML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A XML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285373009059873501)
,p_name=>'APEX.REGION.FLASH_CHART.WAITING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8F09\5165\8CC7\6599, \8ACB\7A0D\5019.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344400491874198)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344594252874198)
,p_name=>'APEX.REGION.JQM_COLUMN_TOGGLE.LOAD_MORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F09\5165\5176\4ED6\9805\76EE...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285545392429873626)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.BACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285141461486873331)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.LOAD_MORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F09\5165\5176\4ED6\9805\76EE...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285166428256873349)
,p_name=>'APEX.REGION.JQM_LIST_VIEW.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286344691548874198)
,p_name=>'APEX.REGION.JQM_REFLOW.LOAD_MORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F09\5165\5176\4ED6\9805\76EE...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358390408874213)
,p_name=>'APEX.REGION.NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\5340\57DF ID %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285152635577873339)
,p_name=>'APEX.REGION.NO_DATA_FOUND_MESSAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285360673529873492)
,p_name=>'APEX.REGION.PAGINATION.RESET_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\91CD\8A2D\5340\57DF\5206\9801.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285113429808873311)
,p_name=>'APEX.REGION.PAGINATION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\5340\57DF\5206\9801\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285842750874155)
,p_name=>'APEX.REGION.RESPONSIVE_TABLE.COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358245894874213)
,p_name=>'APEX.REGION.TYPE_NOT_SUPPORTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\652F\63F4\5340\57DF\985E\578B %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285113314768873311)
,p_name=>'APEX.REGION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5448\73FE\5340\57DF "#COMPONENT_NAME#" \6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285635767286873693)
,p_name=>'APEX.REGION_COLUMN_IS_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\8F38\5165 #COLUMN_HEADER# \503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285815895405873817)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\555F\7528 REST \7684 SQL \670D\52D9\8A8D\8B49\5931\6557.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285140226414873330)
,p_name=>'APEX.REMOTESQL.AUTHENTICATION_FAILED_FOR_LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49\5931\6557. \503C\6E05\55AE\4F7F\7528\53C3\7167\7121\6548 Web \8B49\660E\8CC7\6599\7684\300C\555F\7528 REST \7684 SQL\300D\8CC7\6599\4F86\6E90, \56E0\6B64\60A8\7121\6CD5\7DE8\8F2F\6B64 LOV \7684\8CC7\6599\6B04\8CC7\8A0A. \8ACB\6AA2\67E5\8A8D\8B49\8B49\660E\8CC7\6599. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354182663874208)
,p_name=>'APEX.REMOTESQL.COMMUNICATION_FAILURE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\8A0A\5931\6557. \547C\53EB\503C\6E05\55AE\6240\53C3\7167\7684\300C\555F\7528 REST \7684 SQL\300D\8CC7\6599\4F86\6E90\6642\767C\751F\554F\984C, \9019\5C07\4F7F\60A8\7121\6CD5\7DE8\8F2F LOV \7684\8CC7\6599\6B04\8CC7\8A0A. \8ACB\6AA2\67E5\300C\555F\7528 REST \7684 SQL\300D\8CC7\6599\4F86\6E90\662F\5426\6B63\78BA\904B\4F5C, \4EE5\53CA\5C0D\61C9\7684\8A8D\8B49\8B49\660E\8CC7\6599\662F\5426\6B63\78BA.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285883593106873862)
,p_name=>'APEX.REMOTESQL.OAUTH_IS_RECOMMENDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B66\544A: Oracle \5EFA\8B70\4F7F\7528\300COAuth \5F9E\5C6C\7AEF\8B49\660E\8CC7\6599\300D\9032\884C\555F\7528 REST \7684 SQL \8A8D\8B49.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285817261854873818)
,p_name=>'APEX.REMOTESQL.REMOTE_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9060\7AEF\4F3A\670D\5668\4E0A\767C\751F\932F\8AA4: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774022970873789)
,p_name=>'APEX.REMOTESQL.SERVER_NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\555F\7528 ORDS REST \7684\6307\5B9A SQL \57F7\884C\8655\7406.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285375260676873502)
,p_name=>'APEX.REMOTESQL.SERVER_SENT_REDIRECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F3A\670D\5668\5DF2\50B3\9001\91CD\65B0\5C0E\5411\81F3: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285663271678873713)
,p_name=>'APEX.REMOTESQL.SQL_STATEMENT_TOO_LONG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \6558\8FF0\53E5\9577\5EA6\8D85\904E 32.767 \500B\4F4D\5143\7D44.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285683154881873727)
,p_name=>'APEX.REMOTESQL.TEST_MESSAGE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6B61\8FCE\4F7F\7528 Application Express! \60A8\76EE\524D\4EE5 #USER# \8EAB\5206\9032\884C\9023\7DDA.'),
unistr('\672C\6A5F\8CC7\6599\5EAB\6642\6233\70BA: #SYSDATE#.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286011200174873953)
,p_name=>'APEX.REST.DEFAULT_SCHEMA_WARNING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\6B63\5728\7DE8\8F2F\5DE5\4F5C\5340\9810\8A2D\7DB1\8981\7684\5225\540D. \8A2D\5B9A\6B64\5225\540D\6703\4E00\4F75\8B8A\66F4\5DE5\4F5C\5340\5C64\6B21\7684\300C\8DEF\5F91\524D\7F6E\78BC\300D. \9019\6703\5F71\97FF\60A8\53EF\80FD\5DF2\5B9A\7FA9\4E4B\4EFB\4F55 APEX \578B RESTful \670D\52D9\7684 URL.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285670410048873718)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ORDS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684 ORDS \7248\672C\4E0D\652F\63F4 REST \7BA1\7406\4ECB\9762.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285670581541873718)
,p_name=>'APEX.RESTADMIN.UNSUPPORTED_ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('REST \7BA1\7406\4ECB\9762\4E0D\652F\63F4\6307\5B9A\7684\5F9E\5C6C\7AEF\89D2\8272.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286449810409874280)
,p_name=>'APEX.RICH_TEXT_EDITOR.ACCESSIBLE_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0, Rich Text \7DE8\8F2F\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285660840804873711)
,p_name=>'APEX.RICH_TEXT_EDITOR.MAXIMUM_LENGTH_EXCEEDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Rich Text HTML \6A19\8A18\8D85\904E\9805\76EE\7684\6700\5927\9577\5EA6 (\4E0A\9650\70BA %1 \500B\5B57\5143, \4F46\5BE6\969B\6709 %0 \500B\5B57\5143)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286343025879874197)
,p_name=>'APEX.RV.DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286268878746874142)
,p_name=>'APEX.RV.DUPLICATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8907')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264066952874139)
,p_name=>'APEX.RV.EXCLUDE_HIDDEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\7684\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263945838874139)
,p_name=>'APEX.RV.EXCLUDE_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\9664\7A7A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286343156339874197)
,p_name=>'APEX.RV.INSERT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285803297601873809)
,p_name=>'APEX.RV.MOVE_DOWN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\79FB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285803355300873809)
,p_name=>'APEX.RV.MOVE_UP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\79FB')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263795930874139)
,p_name=>'APEX.RV.NEXT_RECORD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264390388874139)
,p_name=>'APEX.RV.NOT_GROUPED_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263871332874139)
,p_name=>'APEX.RV.PREV_RECORD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264179827874139)
,p_name=>'APEX.RV.REC_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217 %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286264241130874139)
,p_name=>'APEX.RV.REC_XY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C %0 \500B\8CC7\6599\5217, \5171 %1 \500B\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286268938441874142)
,p_name=>'APEX.RV.REFRESH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286269022042874142)
,p_name=>'APEX.RV.REVERT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\5FA9\8B8A\66F4')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286263680578874138)
,p_name=>'APEX.RV.SETTINGS_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\503C\529F\80FD\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285738072358873765)
,p_name=>'APEX.SAMPLE_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F8B\5982, %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285660941679873711)
,p_name=>'APEX.SC.REFERENCES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \500B\53C3\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286002544902873946)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\516C\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286002688721873946)
,p_name=>'APEX.SEARCH.AU.APPLICATION_UTILITIES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \61C9\7528\7A0B\5F0F\516C\7528\7A0B\5F0F \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286010069807873952)
,p_name=>'APEX.SEARCH.GO_TO_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\81F3\9801\9762')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009921380873952)
,p_name=>'APEX.SEARCH.GO_TO_SHARED_COMPONENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D\5F80\5171\7528\7684\5143\4EF6')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286002712691873946)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286002818115873947)
,p_name=>'APEX.SEARCH.P1500.APP_BUILDER_TASKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\5DE5\4F5C > ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286002994256873947)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003042634873947)
,p_name=>'APEX.SEARCH.SC.APP_ITEMS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \61C9\7528\7A0B\5F0F\9805\76EE \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003126946873947)
,p_name=>'APEX.SEARCH.SC.APP_LOGIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\908F\8F2F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003245065873947)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003389867873947)
,p_name=>'APEX.SEARCH.SC.AUTHENTICATION_SCHEMES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \5B89\5168\6027\8A8D\8B49\914D\7F6E \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003484956873947)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6388\6B0A\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003506631873947)
,p_name=>'APEX.SEARCH.SC.AUTHORIZATION_SCHEMES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \5B89\5168\6027\6388\6B0A\914D\7F6E \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003693864873947)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003725550873947)
,p_name=>'APEX.SEARCH.SC.BREADCRUMBS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \5C0E\89BD\8DEF\5F91 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003881287873947)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\5EFA\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286003951677873947)
,p_name=>'APEX.SEARCH.SC.BUILD_OPTIONS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \7D44\5EFA\9078\9805 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004097559873947)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5143\4EF6\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004144798873948)
,p_name=>'APEX.SEARCH.SC.COMPONENT_SETTINGS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \5143\4EF6\8A2D\5B9A\503C \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004263408873948)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004350931873948)
,p_name=>'APEX.SEARCH.SC.COMPUTATIONS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \61C9\7528\7A0B\5F0F\904B\7B97 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004436462873948)
,p_name=>'APEX.SEARCH.SC.CREATE_APPLICATION_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004501410873948)
,p_name=>'APEX.SEARCH.SC.CREATE_AUTHENTICATION_SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\8A8D\8B49\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004666774873948)
,p_name=>'APEX.SEARCH.SC.CREATE_BUILD_OPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7D44\5EFA\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004793022873948)
,p_name=>'APEX.SEARCH.SC.CREATE_COMPUTATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004879122873948)
,p_name=>'APEX.SEARCH.SC.CREATE_EMAIL_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\96FB\5B50\90F5\4EF6\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286004905517873948)
,p_name=>'APEX.SEARCH.SC.CREATE_PLUG-IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB Plug-in')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005000771873948)
,p_name=>'APEX.SEARCH.SC.CREATE_THEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\4E3B\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005121934873948)
,p_name=>'APEX.SEARCH.SC.CREATE_WEB_CREDENTIALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB Web \8B49\660E\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005223666873948)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\5B9A\7FA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005335385873948)
,p_name=>'APEX.SEARCH.SC.DATA_LOAD_DEFINITIONS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \8CC7\6599\8F09\5165\5B9A\7FA9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005480312873948)
,p_name=>'APEX.SEARCH.SC.DATA_SOURCES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005500311873949)
,p_name=>'APEX.SEARCH.SC.DEFINITION_ATTRIBUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B9A\7FA9\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005629864873949)
,p_name=>'APEX.SEARCH.SC.EMAIL_TEMPLATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005719672873949)
,p_name=>'APEX.SEARCH.SC.LAYOUTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\7248\9762\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005806482873949)
,p_name=>'APEX.SEARCH.SC.LAYOUTS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \5831\8868\7248\9762\914D\7F6E \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286005931135873949)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\820A\6709 Web \670D\52D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006051337873949)
,p_name=>'APEX.SEARCH.SC.LEGACY_WEB_SERVICES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \820A\6709 Web \670D\52D9 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006188145873949)
,p_name=>'APEX.SEARCH.SC.LISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006293962873949)
,p_name=>'APEX.SEARCH.SC.LISTS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \4E00\822C\5C0E\89BD\6E05\55AE \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006373898873949)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006420978873949)
,p_name=>'APEX.SEARCH.SC.LIST_OF_VALUES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \503C\6E05\55AE \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006563028873949)
,p_name=>'APEX.SEARCH.SC.NAVIGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006668819873949)
,p_name=>'APEX.SEARCH.SC.OTHER_COMPONENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6\5143\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006754467873949)
,p_name=>'APEX.SEARCH.SC.PLUG-INS'
,p_message_language=>'zh-tw'
,p_message_text=>'Plug-in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006897961873950)
,p_name=>'APEX.SEARCH.SC.PLUG-INS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C Plug-in \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286006908277873950)
,p_name=>'APEX.SEARCH.SC.PROCESSES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007019580873950)
,p_name=>'APEX.SEARCH.SC.PROCESSES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \61C9\7528\7A0B\5F0F\8655\7406\4F5C\696D \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007146571873950)
,p_name=>'APEX.SEARCH.SC.QUERIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007295132873950)
,p_name=>'APEX.SEARCH.SC.QUERIES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \5831\8868\67E5\8A62 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007321925873950)
,p_name=>'APEX.SEARCH.SC.REPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007492667873950)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528 REST \7684 SQL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007526554873950)
,p_name=>'APEX.SEARCH.SC.REST_ENABLED_SQL_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \555F\7528 REST \7684 SQL \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007650184873950)
,p_name=>'APEX.SEARCH.SC.SECURITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\5168\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007780845873950)
,p_name=>'APEX.SEARCH.SC.SESSION_STATE_PROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\968E\6BB5\4F5C\696D\72C0\614B\4FDD\8B77')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286007805346873950)
,p_name=>'APEX.SEARCH.SC.SET_APPLICATION_SESSION_STATE_PROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\72C0\614B\4FDD\8B77')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008001963873950)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5171\7528\7684\5143\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008120119873950)
,p_name=>'APEX.SEARCH.SC.SHARED_COMPONENTS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008213386873951)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6377\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008380166873951)
,p_name=>'APEX.SEARCH.SC.SHORTCUTS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \6377\5F91 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008480145873951)
,p_name=>'APEX.SEARCH.SC.TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\7C64 (\820A\6709)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008570471873951)
,p_name=>'APEX.SEARCH.SC.TEMPLATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008678034873951)
,p_name=>'APEX.SEARCH.SC.TEMPLATES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C UI \6A23\677F \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008775236873951)
,p_name=>'APEX.SEARCH.SC.THEMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008860822873951)
,p_name=>'APEX.SEARCH.SC.THEMES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C UI \4E3B\984C \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286008983949873951)
,p_name=>'APEX.SEARCH.SC.UI'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4ECB\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009082268873951)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \8B49\660E\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009198484873951)
,p_name=>'APEX.SEARCH.SC.WEB_CREDENTIALS_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C \5B89\5168\6027 Web \8B49\660E\8CC7\6599 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009249301873951)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \4F86\6E90\6A21\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009347172873951)
,p_name=>'APEX.SEARCH.SC.WEB_SOURCE_MODULES_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\81F3: \5171\7528\7684\5143\4EF6 \005C Web \4F86\6E90\6A21\7D44 \005C %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009469449873951)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009543062873951)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009601191873952)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.CREATE_OBJECT_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728 SQL \5DE5\4F5C\5BA4\4E2D\5EFA\7ACB %LIST_ITEM_NAME%')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009737158873952)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.SCRIPT_EDITOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\547D\4EE4\6A94\7DE8\8F2F\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286009828407873952)
,p_name=>'APEX.SEARCH.SQL_WORKSHOP.TASKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4\5DE5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286392344797874238)
,p_name=>'APEX.SESSION.DB_SESSION_CLEANUP.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8CC7\6599\5EAB\968E\6BB5\4F5C\696D\6E05\9664\7A0B\5F0F\78BC\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285354214372873487)
,p_name=>'APEX.SESSION.DB_SESSION_INIT.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8CC7\6599\5EAB\968E\6BB5\4F5C\696D\8A2D\5B9A\7A0B\5F0F\78BC\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285127963627873321)
,p_name=>'APEX.SESSION.EXPIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\968E\6BB5\4F5C\696D\5DF2\7D93\904E\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286384071021874232)
,p_name=>'APEX.SESSION.EXPIRED.CLOSE_DIALOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\95DC\9589\6B64\5C0D\8A71\65B9\584A, \7136\5F8C\6309\700F\89BD\5668\7684\300C\91CD\65B0\8F09\5165\300D\6309\9215\4EE5\53D6\5F97\65B0\7684\968E\6BB5\4F5C\696D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286444237046874276)
,p_name=>'APEX.SESSION.EXPIRED.NEW_SESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4E00\4E0B<a href="%0">\6B64\8655</a>\4EE5\5EFA\7ACB\65B0\7684\968E\6BB5\4F5C\696D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285807323292873811)
,p_name=>'APEX.SESSION.RAS.NO_DYNAMIC_ROLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\5728\4F7F\7528\8005 "%0" \7684 Real Application Security \968E\6BB5\4F5C\696D\4E2D\555F\7528\4EFB\4F55\300C\52D5\614B\89D2\8272\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285347178002873482)
,p_name=>'APEX.SESSION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('ERR-99900 \7121\6CD5\5EFA\7ACB\552F\4E00\7684\968E\6BB5\4F5C\696D ID: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286455350669874284)
,p_name=>'APEX.SESSION_STATE.DB_COLUMN_SOURCE_USED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE %0 \662F\4EE5\300C\8CC7\6599\5EAB\8CC7\6599\6B04\300D\70BA\57FA\790E, \4F46\662F\300C\4F7F\7528\7684\4F86\6E90\300D\5C6C\6027\8A2D\70BA\300C\53EA\6709\7576\968E\6BB5\4F5C\696D\72C0\614B\7684\76EE\524D\503C\662F\7A7A\503C\6642\300D. \9019\5341\5206\5371\96AA, \53EF\80FD\6703\5728\6AA2\8996\548C\5132\5B58\591A\7B46\8A18\9304\6642\5C0E\81F4\610F\5916\8986\5BEB\8CC7\6599. \8ACB\4E00\5F8B\5C07\300C\4F7F\7528\7684\4F86\6E90\300D\8A2D\70BA\300C\6C38\9060, \53D6\4EE3\968E\6BB5\4F5C\696D\4E2D\4EFB\4F55\73FE\6709\7684\503C\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286364825933874218)
,p_name=>'APEX.SESSION_STATE.DISABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\505C\7528\5B58\53D6\968E\6BB5\4F5C\696D\72C0\614B, \5DF2\5C01\9396\5617\8A66\8B80\53D6/\5BEB\5165.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285165577245873349)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5617\8A66\5728\986F\793A\8655\7406\671F\9593, \5132\5B58\968E\6BB5\4F5C\696D\4E2D\7684\9805\76EE %0. \9805\76EE\64C1\6709\300C\50C5\9650\5167\90E8\300D\4FDD\8B77.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285146938602873335)
,p_name=>'APEX.SESSION_STATE.INTERNAL_ONLY_VIOLATION2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5617\8A66\5728\63A5\53D7\8655\7406\671F\9593, \5132\5B58\968E\6BB5\4F5C\696D\4E2D\7684\9805\76EE %0. \9805\76EE\64C1\6709\300C\50C5\9650\5167\90E8\300D\4FDD\8B77, \6216\8005\4E0D\662F\53EF\516C\5E03\7684\8868\55AE\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285421429276873536)
,p_name=>'APEX.SESSION_STATE.ITEM_VALUE_PROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\968E\6BB5\4F5C\696D\72C0\614B\4FDD\8B77\9055\898F: \53EF\80FD\7684\539F\56E0\662F\624B\52D5\66F4\6539\53D7\4FDD\8B77\7684\9801\9762\9805\76EE %0. \5982\679C\60A8\4E0D\78BA\5B9A\9020\6210\6B64\932F\8AA4\7684\539F\56E0, \8ACB\6D3D\8A62\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\53D6\5F97\5354\52A9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286480379889874303)
,p_name=>'APEX.SESSION_STATE.PAGE_PROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\4FDD\8B77\9055\898F: \53EF\80FD\7684\539F\56E0\662F\9001\51FA\5C1A\672A\5B8C\6210\8F09\5165\7684\9801\9762, \6216\624B\52D5\66F4\6539\53D7\4FDD\8B77\9801\9762\9805\76EE. \5982\9700\9032\4E00\6B65\7684\5354\52A9, \8ACB\6D3D\8A62\61C9\7528\7A0B\5F0F\7BA1\7406\54E1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286477210007874301)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5305\542B\4E0B\5217\5176\4E2D\4E00\500B\7121\6548\5B57\5143 &<>"/;,*|=% \6216 --')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286477374292874301)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.NO_SPECIAL_CHAR_NL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5305\542B\4E0B\5217\5176\4E2D\4E00\500B\7121\6548\5B57\5143 &<>"/;,*|=% \6216 -- \6216\65B0\884C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286477053835874300)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.US_ONLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5305\542B\7279\6B8A\5B57\5143. \50C5\5141\8A31\5B57\5143 a-Z\30010-9 \8207\7A7A\683C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286477191851874301)
,p_name=>'APEX.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5305\542B <, > \6216 " \7B49\7121\6548\7684\5B57\5143.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285146508497873335)
,p_name=>'APEX.SESSION_STATE.SSP_CHECKSUM_MISSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\4E00\6216\591A\500B request, clear cache \6216\5F15\6578\503C\4F5C\70BA\53C3\6578\50B3\9001\6642, \672A\63D0\4F9B\7E3D\548C\6AA2\9A57\4F86\986F\793A\9700\8981\7E3D\548C\6AA2\9A57\7684\9801\9762\8655\7406.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285408401683873526)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\968E\6BB5\4F5C\696D\72C0\614B\4FDD\8B77\9055\898F: \53EF\80FD\7684\539F\56E0\662F\624B\52D5\66F4\6539\5167\542B\7E3D\548C\6AA2\9A57\7684 URL, \6216\4F7F\7528\7684\9023\7D50\5305\542B\932F\8AA4\6216\907A\6F0F\7684\7E3D\548C\6AA2\9A57. \5982\679C\60A8\4E0D\78BA\5B9A\9020\6210\6B64\932F\8AA4\7684\539F\56E0, \8ACB\6D3D\8A62\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\53D6\5F97\5354\52A9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285146629514873335)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION2_FOR_DEVELOPERS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\91DD\5C0D\8981\6C42\3001\6E05\9664\5FEB\53D6\3001\5F15\6578\540D\7A31\4EE5\53CA\5F15\6578\503C (%0) \904B\7B97\7684\7E3D\548C\6AA2\9A57, \8207\50B3\9001\81F3\986F\793A\7A0B\5E8F (%1) \7684\7E3D\548C\6AA2\9A57\4E0D\7B26.'),
'',
unistr('\6CE8\610F: \4E00\822C\4F7F\7528\8005\6703\6536\5230\4E0D\540C\7684\932F\8AA4\8A0A\606F.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285145557611873334)
,p_name=>'APEX.SESSION_STATE.SSP_VIOLATION_FOR_DEVELOPERS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5617\8A66\5728\9032\884C\986F\793A\8655\7406\6642\5132\5B58\968E\6BB5\4F5C\696D\72C0\614B\4E2D\7684\9805\76EE %0. \9805\76EE\4FDD\8B77\5C64\6B21\70BA:'),
'  %1',
'',
unistr('\672A\50B3\5165\7E3D\548C\6AA2\9A57, \6216\50B3\5165\7684\7E3D\548C\6AA2\9A57\9069\7528\65BC\4FDD\8B77\5C64\6B21\70BA "%2" \7684\9805\76EE.'),
'',
unistr('\6CE8\610F: \4E00\822C\4F7F\7528\8005\6703\6536\5230\4E0D\540C\7684\932F\8AA4\8A0A\606F.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285356004405873488)
,p_name=>'APEX.SESSION_STATE.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('ERR-1022 \7121\6CD5\5132\5B58\5C6C\6027.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286265054858874139)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_OFF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\9AD8\5C0D\6BD4\6A21\5F0F\8A2D\70BA\95DC\9589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286265108373874140)
,p_name=>'APEX.SET_HIGH_CONTRAST_MODE_ON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\9AD8\5C0D\6BD4\6A21\5F0F\8A2D\70BA\958B\555F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285380840071873506)
,p_name=>'APEX.SHUTTLE.CONTROL_BOTTOM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E95\7AEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285381095442873506)
,p_name=>'APEX.SHUTTLE.CONTROL_DOWN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5411\4E0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285381145295873507)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285381203713873507)
,p_name=>'APEX.SHUTTLE.CONTROL_MOVE_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285381304366873507)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285381406159873507)
,p_name=>'APEX.SHUTTLE.CONTROL_REMOVE_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285381502107873507)
,p_name=>'APEX.SHUTTLE.CONTROL_RESET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8A2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285380749383873506)
,p_name=>'APEX.SHUTTLE.CONTROL_TOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9802\7AEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285380941797873506)
,p_name=>'APEX.SHUTTLE.CONTROL_UP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5411\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418216003874257)
,p_name=>'APEX.SINCE.SHORT.DAYS_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>'%0d'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418965515874258)
,p_name=>'APEX.SINCE.SHORT.DAYS_FROM_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5929\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418117942874257)
,p_name=>'APEX.SINCE.SHORT.HOURS_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>'%0h'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419098525874258)
,p_name=>'APEX.SINCE.SHORT.HOURS_FROM_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5C0F\6642\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286417971890874257)
,p_name=>'APEX.SINCE.SHORT.MINUTES_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>'%0m'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419118229874258)
,p_name=>'APEX.SINCE.SHORT.MINUTES_FROM_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\9418\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418543370874257)
,p_name=>'APEX.SINCE.SHORT.MONTHS_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \500B\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418716219874258)
,p_name=>'APEX.SINCE.SHORT.MONTHS_FROM_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \500B\6708\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418060563874257)
,p_name=>'APEX.SINCE.SHORT.SECONDS_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>'%0s'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418859960874258)
,p_name=>'APEX.SINCE.SHORT.SECONDS_FROM_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \79D2\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418329559874257)
,p_name=>'APEX.SINCE.SHORT.WEEKS_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>'%0w'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286419222839874258)
,p_name=>'APEX.SINCE.SHORT.WEEKS_FROM_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5468\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418499910874257)
,p_name=>'APEX.SINCE.SHORT.YEARS_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>'%0y'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286418630053874257)
,p_name=>'APEX.SINCE.SHORT.YEARS_FROM_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5E74\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285594657104873663)
,p_name=>'APEX.SPLITTER.COLLAPSE_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285594511687873663)
,p_name=>'APEX.SPLITTER.RESTORE_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\5FA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286001576935873946)
,p_name=>'APEX.STAR_RATING.CLEAR_RATING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664\8A55\6BD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285965568727873919)
,p_name=>'APEX.STAR_RATING.INVALID_RATING_RANGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728 1 - %1 \7684\6709\6548\8A55\6BD4\7BC4\570D\5167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285965680483873920)
,p_name=>'APEX.STAR_RATING.IS_NOT_NUMERIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\662F\6578\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285937555203873899)
,p_name=>'APEX.SUCCESS_MESSAGE_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6210\529F\8A0A\606F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253211601873414)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_CONTENT_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6210\529F\8A0A\606F\7E3D\548C\6AA2\9A57\5167\5BB9\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253175360873413)
,p_name=>'APEX.SUCCESS_MSG.CHECKSUM_FORMAT_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6210\529F\8A0A\606F\7E3D\548C\6AA2\9A57\683C\5F0F\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286449434226874280)
,p_name=>'APEX.TABS.NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286449327978874280)
,p_name=>'APEX.TABS.PREVIOUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285104662465873304)
,p_name=>'APEX.TABULAR_FORM.COLUMN_DEFAULT_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97\8CC7\6599\6B04 #COMPONENT_NAME# \7684\9810\8A2D\503C\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285105289957873305)
,p_name=>'APEX.TABULAR_FORM.MRD.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\300C\522A\9664\591A\91CD\8CC7\6599\5217\300D\8655\7406\4F5C\696D\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285390234004873513)
,p_name=>'APEX.TABULAR_FORM.MRU.FCS_MISSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\63D0\4F9B\5FC5\8981\7684\7E3D\548C\6838\67E5\8CC7\6599\6B04 ("FCS")')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285390486906873513)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_PRIM_KEY_VALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\63D0\4F9B\4E3B\7D22\5F15\9375\503C, \81F3\5C11\5FC5\9808\63D0\4F9B\4E00\500B\8CC7\6599\5217\624D\80FD\9032\884C\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285391296561873514)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_SEC_KEY_VALS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\63D0\4F9B\8B58\5225\4E4B\6B21\8981\7D22\5F15\9375\8CC7\6599\6B04\7684\6B21\8981\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285508128167873599)
,p_name=>'APEX.TABULAR_FORM.MRU.NO_VALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\5217\8868\5316\8868\55AE\4E2D\627E\4E0D\5230\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285390178485873513)
,p_name=>'APEX.TABULAR_FORM.MRU.PRIM_KEY_COL_NOT_SPECIFIED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6307\5B9A\4E3B\7D22\5F15\9375\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285391104334873514)
,p_name=>'APEX.TABULAR_FORM.MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7684\6B21\8981\7D22\5F15\9375\8CC7\6599\6B04\4E0D\5728\9078\53D6\7684\67E5\8A62\6E05\55AE\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285390060298873513)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_NAME_NOT_SPECIFIED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6307\5B9A\300C\8868\683C\540D\7A31\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285389923346873513)
,p_name=>'APEX.TABULAR_FORM.MRU.TABLE_OWNER_NOT_SPECIFIED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6307\5B9A\300C\8868\683C\64C1\6709\8005\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285412270344873529)
,p_name=>'APEX.TABULAR_FORM.MRU.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\300C\66F4\65B0\591A\91CD\8CC7\6599\5217\300D\8655\7406\4F5C\696D\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286412894503874253)
,p_name=>'APEX.TB.TOOLBAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\5177\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273565060873428)
,p_name=>'APEX.TEAM.COMMITTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273301622873428)
,p_name=>'APEX.TEAM.CONTRIBUTOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285275206433873430)
,p_name=>'APEX.TEAM.CREATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD %0 \5DF2\65B0\589E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285275388571873430)
,p_name=>'APEX.TEAM.DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD %0 \5DF2\522A\9664.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285095675515873298)
,p_name=>'APEX.TEAM.DEPRECATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA 19.2 \7248\8D77\5DF2\4E0D\518D\4F7F\7528\300CAPEX \5718\968A\958B\767C\300D\529F\80FD, \5C07\6703\5728\672A\4F86\7248\6B21\4E2D\79FB\9664. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273695194873429)
,p_name=>'APEX.TEAM.ESTIMATED_EFFORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\4F30\5DE5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273968754873429)
,p_name=>'APEX.TEAM.FEATURE_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63CF\8FF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273114145873428)
,p_name=>'APEX.TEAM.FEATURE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273709847873429)
,p_name=>'APEX.TEAM.FEATURE_STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273835500873429)
,p_name=>'APEX.TEAM.MILESTONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285274103637873429)
,p_name=>'APEX.TEAM.NO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273223548873428)
,p_name=>'APEX.TEAM.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285273499426873428)
,p_name=>'APEX.TEAM.RELEASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7248\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285272232633873428)
,p_name=>'APEX.TEAM.SAVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD %0 \5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285274033338873429)
,p_name=>'APEX.TEAM.YES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286452223521874282)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_NAV_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C55\958B/\96B1\85CF\5C0E\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286452343073874282)
,p_name=>'APEX.TEMPLATE.EXPAND_COLLAPSE_SIDE_COL_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C55\958B/\96B1\85CF\5074\908A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285128395870873321)
,p_name=>'APEX.THEMES.COPY_THEME_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\8907\88FD\61C9\7528\7A0B\5F0F "%1" \4E2D\7684\4E3B\984C "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286444731097874277)
,p_name=>'APEX.THEMES.INCOMPATIBLE_THEME'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\532F\5165\7684\4E3B\984C\8207\76EE\524D\7684\4E3B\984C\4E0D\76F8\5BB9.'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286410560685874252)
,p_name=>'APEX.THEMES.INVALID_THEME_NUMBER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C\7DE8\865F\7121\6548, \6216\8005\4E3B\984C\4E0D\662F\76EE\524D\7684 UI \4E3B\984C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285734406377873762)
,p_name=>'APEX.TIME.DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('1 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285734267764873762)
,p_name=>'APEX.TIME.HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('1 \5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285734521478873762)
,p_name=>'APEX.TIME.N_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285734328990873762)
,p_name=>'APEX.TIME.N_HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285734129451873762)
,p_name=>'APEX.TIME.N_MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\9418')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285734706920873762)
,p_name=>'APEX.TIME.N_WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285734659201873762)
,p_name=>'APEX.TIME.WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('1 \9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286363907529874217)
,p_name=>'APEX.TREE.ID_AND_PARENT_ID_COLUMNS_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\8981\6709\4E3B\7D22\5F15\9375\8CC7\6599\6B04\548C\7236\9805\7D22\5F15\9375\8CC7\6599\6B04, \624D\80FD\904B\7B97\968E\5C64.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286364061255874217)
,p_name=>'APEX.TREE.NODE_LEVEL_AND_STATUS_COLUMNS_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\82E5\672A\904B\7B97\968E\5C64, \5FC5\9808\8981\6709\7BC0\9EDE\5C64\6B21\8CC7\6599\6B04\548C\7BC0\9EDE\72C0\614B\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286471923939874297)
,p_name=>'APEX.UI.BACK_TO_TOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\958B\982D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285289605414873440)
,p_name=>'APEX.UI.DARK_MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6DF1\8272\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285289867936873440)
,p_name=>'APEX.UI.DISABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\505C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285289789791873440)
,p_name=>'APEX.UI.ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285729352144873759)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\5F9E\4E0B\65B9\6E05\55AE\4E2D\9078\53D6\4E00\500B\4F7F\7528\8005\4ECB\9762:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285731894104873761)
,p_name=>'APEX.UI_TYPE.CLIENT_DETECTION.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 - \9078\53D6\4F7F\7528\8005\4ECB\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285104987894873304)
,p_name=>'APEX.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\8981\6C42\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285249844094873411)
,p_name=>'APEX.USER.CHECK_SGID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A\7684\5B58\53D6 (\672A\8A2D\5B9A\5B89\5168\6027\7FA4\7D44\5957\88DD\7A0B\5F0F\8B8A\6578).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285250431935873411)
,p_name=>'APEX.USER.FETCH_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\64F7\53D6\5C0B\627E\4F7F\7528\8005\8CC7\8A0A. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285237682592873402)
,p_name=>'APEX.USER.NOT_ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005 %0 \9700\8981\6709 ADMIN \6B0A\9650\624D\80FD\57F7\884C\9019\9805\4F5C\696D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285250355391873411)
,p_name=>'APEX.USER.NO_EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005 %0 \5C1A\672A\63D0\4F9B\96FB\5B50\90F5\4EF6\5730\5740.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285205836379873378)
,p_name=>'APEX.USER.UNAUTHORIZED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A\7684\5B58\53D6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285250215661873411)
,p_name=>'APEX.USER.USER_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005 %0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285356182075873488)
,p_name=>'APEX.VALIDATION.UNHANDLED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\9A57\8B49\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285738344644873765)
,p_name=>'APEX.VALUE_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\8F38\5165\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286461598498874289)
,p_name=>'APEX.WAIT_UNTIL_PAGE_LOADED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\7B49\5230\9801\9762\5B8C\5168\8F09\5165\5F8C\518D\8A66\4E00\6B21.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285480785874155)
,p_name=>'APEX.WARN_ON_UNSAVED_CHANGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9801\9762\6709\672A\5132\5B58\7684\8B8A\66F4.')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286365314776874218)
,p_name=>'APEX.WEBSRC.CANNOT_PARSE_DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Application Express \7121\6CD5\5F9E %0 \985E\578B\7684\56DE\61C9\8CC7\6599\904B\7B97\8CC7\6599\8A2D\5B9A\6A94.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285796185429873804)
,p_name=>'APEX.WEBSRC.DATAPROFILE.MANY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285796098082873804)
,p_name=>'APEX.WEBSRC.DATAPROFILE.ONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286349299291874202)
,p_name=>'APEX.WEBSRC.FILTER_EXPR_INVALID_JSON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078\8868\793A\5F0F\4E0D\662F\6709\6548\7684 JSON.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286340954901874196)
,p_name=>'APEX.WEBSRC.FILTER_NOT_SUPPORTED_BY_ORDS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Oracle REST Data Services \4E0D\652F\63F4\7BE9\9078.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285682682449873727)
,p_name=>'APEX.WEBSRC.HIDE_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF\9078\53D6\7684\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775549693873790)
,p_name=>'APEX.WEBSRC.HTTP200'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 200: \6210\529F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775629773873790)
,p_name=>'APEX.WEBSRC.HTTP201'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 201: \5DF2\5EFA\7ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775070541873790)
,p_name=>'APEX.WEBSRC.HTTP400'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 400: \7121\6548\7684\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774837253873789)
,p_name=>'APEX.WEBSRC.HTTP401'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 401: \672A\6388\6B0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775162581873790)
,p_name=>'APEX.WEBSRC.HTTP403'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 403: \7981\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285774953756873790)
,p_name=>'APEX.WEBSRC.HTTP404'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 404: \627E\4E0D\5230')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775222126873790)
,p_name=>'APEX.WEBSRC.HTTP405'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 405: \65B9\6CD5\4E0D\5141\8A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285094834732873297)
,p_name=>'APEX.WEBSRC.HTTP407'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 407: \9700\8981\4EE3\7406\4E3B\6A5F\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285095124674873297)
,p_name=>'APEX.WEBSRC.HTTP409'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 409: \767C\751F\885D\7A81')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285094910896873297)
,p_name=>'APEX.WEBSRC.HTTP412'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 412: \5148\6C7A\689D\4EF6\5931\6557')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285095003937873297)
,p_name=>'APEX.WEBSRC.HTTP428'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 428: \5FC5\9808\8981\6709\5148\6C7A\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775331703873790)
,p_name=>'APEX.WEBSRC.HTTP500'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 500: \5167\90E8\4F3A\670D\5668\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285775417095873790)
,p_name=>'APEX.WEBSRC.HTTP502'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 502: \7121\6548\7684\9598\9053')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286365728563874218)
,p_name=>'APEX.WEBSRC.HTTP503'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 503: \670D\52D9\7121\6CD5\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286365870448874218)
,p_name=>'APEX.WEBSRC.HTTP504'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP 504: \9598\9053\903E\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285347090874154)
,p_name=>'APEX.WEBSRC.HTTP_ERROR_OCCURRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \4F86\6E90\50B3\56DE HTTP \932F\8AA4: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773946033873789)
,p_name=>'APEX.WEBSRC.MODULE_NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230 Web \4F86\6E90\6A21\7D44.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318250294873461)
,p_name=>'APEX.WEBSRC.NO_ARRAY_SELECTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\9078\53D6\5668 "%0" \672A\9078\53D6\8981\8996\70BA\8868\683C\7684\7269\4EF6\9663\5217.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318326412873461)
,p_name=>'APEX.WEBSRC.NO_SINGLE_ROW_SELECTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\9078\53D6\5668 "%0" \672A\9078\53D6\8981\8996\70BA\55AE\4E00\8CC7\6599\5217\7684\7269\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285276762874154)
,p_name=>'APEX.WEBSRC.REQUIRED_PARAM_MISSING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\63D0\4F9B "%1" \985E\578B\4E4B\5FC5\8981 Web \4F86\6E90 IN \53C3\6578 "%0" \7684\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286267836457874142)
,p_name=>'APEX.WEBSRC.RESPONSE_BODY_TOO_LARGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\61C9\4E3B\9AD4\592A\5927, \56E0\6B64\7121\6CD5\986F\793A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285682844031873727)
,p_name=>'APEX.WEBSRC.SHOW_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\9078\53D6\7684\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285738208066873765)
,p_name=>'APEX.WEBSRC.SMALL_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\820A\6709 ORDS REST \670D\52D9\4F7F\7528\5C0F\578B\56FA\5B9A\9801\9762\5927\5C0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285683216726873727)
,p_name=>'APEX.WEBSRC.TIMEOUT_EXCEEDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\64F7\53D6\6240\6709 Web \4F86\6E90\8CC7\6599\6642\8D85\904E\903E\6642\6642\9593.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285657950870873709)
,p_name=>'APEX.WEBSRC.TOO_MANY_NEXT_PAGE_REQUESTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\672C\6A5F SQL \7BE9\9078\689D\4EF6\9700\8981\5411 REST \670D\52D9\63D0\51FA\592A\591A\300C\4E0B\4E00\9801\300D\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285738184317873765)
,p_name=>'APEX.WEBSRC.UNKNOWN_ORDS2_FIXED_PAGE_SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\820A\6709 ORDS REST \670D\52D9\7684\56FA\5B9A\9801\9762\5927\5C0F\4E0D\660E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389717519874236)
,p_name=>'APEXDEV.IG.COLUMN_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\52D5\614B\52D5\4F5C ''#COMPONENT_NAME#'' \6307\5B9A\7684\4E92\52D5\5F0F\65B9\683C\8CC7\6599\6B04 ''%0'' \4E0D\5B58\5728.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389993594874236)
,p_name=>'APEXDEV.IG.DML.COMPLEX_VIEW_LOCK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\8CC7\6599\5217\9396\5B9A\6642, \8655\7406\4F5C\696D ''%0'' \767C\751F ''%1. \8655\7406\4F5C\696D\82E5\4F7F\7528 instead-of \89F8\767C\7A0B\5F0F\5C0D\8907\96DC\8996\89C0\8868\767C\51FA SELECT FOR UPDATE \4EE5\9396\5B9A\8CC7\6599\5217, \5C31\53EF\80FD\6703\767C\751F\6B64\932F\8AA4. \8ACB\5C07\8655\7406\4F5C\696D\5C6C\6027\300C\9396\5B9A\8CC7\6599\5217\300D\8A2D\70BA\300C\5426\300D\6216\300CPL/SQL \7A0B\5F0F\78BC\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389806398874236)
,p_name=>'APEXDEV.IG.DML.VIRTUAL_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C DML \547D\4EE4\6642, \8655\7406\4F5C\696D ''%0'' \767C\751F ''%1''. \8CC7\6599\6B04\82E5\662F\4EE5\805A\7E3D\6216 SQL \8868\793A\5F0F\70BA\57FA\790E, \5C31\53EF\80FD\6703\767C\751F\6B64\932F\8AA4. \8ACB\5C07\8CC7\6599\6B04\5C6C\6027\300C\50C5\4F9B\67E5\8A62\300D\8A2D\70BA\300C\662F\300D, \4EE5\4FBF\4E0D\5728 INSERT \548C UPDATE \6558\8FF0\53E5\4E2D\5305\62EC\6B64\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286053985297873984)
,p_name=>'APEXDEV.IG.MASTER_DETAIL_COLUMN_NOT_POPULATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\660E\7D30\8CC7\6599\6B04 ''%0'' \672A\5305\542B\503C. \8ACB\78BA\5B9A\5728\76F8\5C0D\61C9\7684\4E3B\8981\5340\57DF\8655\7406\4F5C\696D\4E4B\5F8C\57F7\884C\8655\7406\4F5C\696D ''%1''.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371543984874223)
,p_name=>'APEXDEV.IG.NO_MASTER_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\52D5\5F0F\65B9\683C ''%0'' \672A\5B9A\7FA9\4E3B\8981\660E\7D30\95DC\4FC2\6240\9700\7684\4E3B\8981\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285727649255873758)
,p_name=>'APEXDEV.IG.NO_PK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\52D5\5F0F\65B9\683C ''%0'' \672A\5B9A\7FA9\9032\884C\7DE8\8F2F\6216\4E3B\8981\660E\7D30\95DC\4FC2\6240\9700\7684\4E3B\7D22\5F15\9375\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286343214489874197)
,p_name=>'APEXDEV.IG.RELOAD_ON_SUBMIT_EDITABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\82E5\70BA\300C\53EF\7DE8\8F2F\4E92\52D5\5F0F\65B9\683C\300D,\300C\9001\51FA\6642\91CD\65B0\8F09\5165\300D\9801\9762\5C6C\6027\5FC5\9808\8A2D\70BA\300C\50C5\5728\6210\529F\6642\8F09\5165\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286343350761874197)
,p_name=>'APEXDEV.TABFORM.RELOAD_ON_SUBMIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\82E5\70BA\300C\5217\8868\5316\8868\55AE\300D,\300C\9001\51FA\6642\91CD\65B0\8F09\5165\300D\9801\9762\5C6C\6027\5FC5\9808\8A2D\70BA\300C\4E00\5F8B\6210\7ACB\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285311026873437)
,p_name=>'APEXIR_3D'
,p_message_language=>'zh-tw'
,p_message_text=>'3D'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378692767874228)
,p_name=>'APEXIR_ACTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285506046786873597)
,p_name=>'APEXIR_ACTIONS_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\529F\80FD\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285410961506873528)
,p_name=>'APEXIR_ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285495692919873590)
,p_name=>'APEXIR_ADD_FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285495510417873590)
,p_name=>'APEXIR_ADD_GROUP_BY_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F9D\8CC7\6599\6B04\65B0\589E\7FA4\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285820076823873820)
,p_name=>'APEXIR_ADD_PIVOT_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\6A1E\7D10\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285820186835873820)
,p_name=>'APEXIR_ADD_ROW_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\5217\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285983889166873933)
,p_name=>'APEXIR_ADD_SUBSCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8A02\95B1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285539300873437)
,p_name=>'APEXIR_AGGREGATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\805A\7E3D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530026357873615)
,p_name=>'APEXIR_AGGREGATE_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\805A\7E3D\986F\793A\65BC\6BCF\500B\63A7\5236\5206\6BB5\4E4B\5F8C\8207\5831\8868\7D50\5C3E\8655.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285533182912873617)
,p_name=>'APEXIR_AGGREGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\805A\7E3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411486489873529)
,p_name=>'APEXIR_AGG_AVG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E73\5747\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285420321983873535)
,p_name=>'APEXIR_AGG_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285437373519873547)
,p_name=>'APEXIR_AGG_COUNT_DISTINCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7570\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411561927873529)
,p_name=>'APEXIR_AGG_MAX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5927\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411797476873529)
,p_name=>'APEXIR_AGG_MEDIAN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E2D\9593\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411620447873529)
,p_name=>'APEXIR_AGG_MIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5C0F\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411811800873529)
,p_name=>'APEXIR_AGG_MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411381754873528)
,p_name=>'APEXIR_AGG_SUM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\548C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413161597873530)
,p_name=>'APEXIR_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284574052873436)
,p_name=>'APEXIR_ALL_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285135344283873327)
,p_name=>'APEXIR_ALL_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375127537874225)
,p_name=>'APEXIR_ALTERNATIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66FF\4EE3\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377280438874227)
,p_name=>'APEXIR_ALTERNATIVE_DEFAULT_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66FF\4EE3\9810\8A2D\503C:  %0 ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285371295848873499)
,p_name=>'APEXIR_AND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E14')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285292081365873442)
,p_name=>'APEXIR_APPLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286341189768874196)
,p_name=>'APEXIR_AREA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255908831873416)
,p_name=>'APEXIR_ASCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\589E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285383745933873508)
,p_name=>'APEXIR_AS_OF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65BC %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377806421874227)
,p_name=>'APEXIR_AVERAGE_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E73\5747\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286341000083874196)
,p_name=>'APEXIR_BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9577\689D\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285288436533873439)
,p_name=>'APEXIR_BETWEEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4ECB\65BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254679650873415)
,p_name=>'APEXIR_BGCOLOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\80CC\666F\8272\5F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980883207873931)
,p_name=>'APEXIR_BLACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9ED1\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256758487873416)
,p_name=>'APEXIR_BLUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\85CD\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285498471116873592)
,p_name=>'APEXIR_BOTTOM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E95\7AEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285412703753873529)
,p_name=>'APEXIR_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\884C\4E8B\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257366980873417)
,p_name=>'APEXIR_CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285297421724873446)
,p_name=>'APEXIR_CATEGORY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\985E\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254575259873415)
,p_name=>'APEXIR_CELL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285412651272873529)
,p_name=>'APEXIR_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501680901873594)
,p_name=>'APEXIR_CHART_INITIALIZING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5728\8D77\59CB...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285855949414873844)
,p_name=>'APEXIR_CHART_LABEL_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\5716\8868\6A19\7C64.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285968422611873922)
,p_name=>'APEXIR_CHART_MAX_DATAPOINT_CNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7684\67E5\8A62\8D85\51FA\6BCF\4E00\5716\8868 %0 \500B\8CC7\6599\9EDE\7684\6578\76EE\4E0A\9650. \8ACB\5957\7528\7BE9\9078\689D\4EF6\4F86\6E1B\5C11\60A8\57FA\790E\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285962445463873917)
,p_name=>'APEXIR_CHART_MAX_ROW_CNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5716\8868\300D\67E5\8A62\7684\8CC7\6599\5217\8A08\6578\4E0A\9650\9650\5236\7684\662F\57FA\790E\67E5\8A62\4E2D\7684\8CC7\6599\5217\6578\76EE, \800C\4E0D\662F\9650\5236\986F\793A\7684\8CC7\6599\5217\6578\76EE.  \60A8\7684\57FA\790E\67E5\8A62\8D85\51FA\8CC7\6599\5217\8A08\6578\4E0A\9650 (%0 \500B\8CC7\6599\5217).  \8ACB\5957\7528\7BE9\9078\4EE5\6E1B\5C11\60A8\57FA\790E\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284811412873437)
,p_name=>'APEXIR_CHART_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285938260345873900)
,p_name=>'APEXIR_CHECK_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\52FE\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285384143707873509)
,p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\5831\8868\4E0B\8F09\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285486872813873583)
,p_name=>'APEXIR_CLEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257266653873416)
,p_name=>'APEXIR_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530101845873615)
,p_name=>'APEXIR_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286357321380874212)
,p_name=>'APEXIR_COLUMN_FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078...')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285496518703873590)
,p_name=>'APEXIR_COLUMN_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490554142873586)
,p_name=>'APEXIR_COLUMN_HEADING_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\6A19\984C\529F\80FD\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501471308873594)
,p_name=>'APEXIR_COLUMN_INFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286367552246874220)
,p_name=>'APEXIR_COLUMN_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285496254699873590)
,p_name=>'APEXIR_COLUMN_N'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285365525548873495)
,p_name=>'APEXIR_COMPARISON_CONTAINS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\542B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370246031873499)
,p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5305\542B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255684003873415)
,p_name=>'APEXIR_COMPARISON_IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370459843873499)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5728\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285415883223873532)
,p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5728\5F8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370380247873499)
,p_name=>'APEXIR_COMPARISON_IS_IN_LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285415703395873532)
,p_name=>'APEXIR_COMPARISON_IS_IN_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\5F8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255527849873415)
,p_name=>'APEXIR_COMPARISON_IS_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\662F\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255417720873415)
,p_name=>'APEXIR_COMPARISON_IS_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255206240873415)
,p_name=>'APEXIR_COMPARISON_LIKE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540C\65BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255790920873415)
,p_name=>'APEXIR_COMPARISON_NOT_IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255358712873415)
,p_name=>'APEXIR_COMPARISON_NOT_LIKE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\540C\65BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285366295686873496)
,p_name=>'APEXIR_COMPARISON_REGEXP_LIKE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B26\5408\6B63\898F\8868\793A\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285384042599873509)
,p_name=>'APEXIR_COMPUTATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285962088110873917)
,p_name=>'APEXIR_COMPUTATION_EXPRESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97\8868\793A\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530467630873615)
,p_name=>'APEXIR_COMPUTATION_FOOTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8CC7\6599\6B04\5225\540D\5EFA\7ACB\904B\7B97.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530508704873615)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E1'
,p_message_language=>'zh-tw'
,p_message_text=>'(B+C)*100'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530629169873615)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E2'
,p_message_language=>'zh-tw'
,p_message_text=>'INITCAP(B)||'', ''||INITCAP(C)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530747574873615)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E3'
,p_message_language=>'zh-tw'
,p_message_text=>'CASE WHEN A = 10 THEN B + C ELSE B END'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122699595873317)
,p_name=>'APEXIR_COMPUTATION_FOOTER_E4'
,p_message_language=>'zh-tw'
,p_message_text=>'ROUND(C / 1000000)'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413870157873530)
,p_name=>'APEXIR_COMPUTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497245079873591)
,p_name=>'APEXIR_CONTROL_BREAK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63A7\5236\5206\6BB5')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505451181873597)
,p_name=>'APEXIR_CONTROL_BREAKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63A7\5236\5206\6BB5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286385966982874233)
,p_name=>'APEXIR_CONTROL_BREAK_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63A7\5236\5206\6BB5\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114862130873312)
,p_name=>'APEXIR_COUNT_DISTINCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7570\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378354220874228)
,p_name=>'APEXIR_COUNT_DISTINCT_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7570\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378208824874228)
,p_name=>'APEXIR_COUNT_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\6578 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285981355764873931)
,p_name=>'APEXIR_DAILY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286470886540874296)
,p_name=>'APEXIR_DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501573812873594)
,p_name=>'APEXIR_DATA_AS_OF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\9418\524D\7684\5831\8868\8CC7\6599.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286332659243874189)
,p_name=>'APEXIR_DATA_GRID_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\65B9\683C\8AAA\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285755518873437)
,p_name=>'APEXIR_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376847200874227)
,p_name=>'APEXIR_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285527705738873613)
,p_name=>'APEXIR_DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286374984072874225)
,p_name=>'APEXIR_DEFAULT_REPORT_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\5831\8868\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257402264873417)
,p_name=>'APEXIR_DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414643087873531)
,p_name=>'APEXIR_DELETE_CHECKED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\52FE\9078\7684\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285286656711873438)
,p_name=>'APEXIR_DELETE_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\522A\9664\9019\4E9B\5831\8868\8A2D\5B9A\503C?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531928472873616)
,p_name=>'APEXIR_DELETE_CONFIRM_JS_DIALOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286265606064874140)
,p_name=>'APEXIR_DELETE_DEFAULT_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\9810\8A2D\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285496943362873591)
,p_name=>'APEXIR_DELETE_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256062194873416)
,p_name=>'APEXIR_DESCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\6E1B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285297570186873446)
,p_name=>'APEXIR_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63CF\8FF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490416734873586)
,p_name=>'APEXIR_DETAIL_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\55AE\4E00\8CC7\6599\5217\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285528783093873614)
,p_name=>'APEXIR_DIRECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\5411 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505920742873597)
,p_name=>'APEXIR_DISABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\505C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285529949885873615)
,p_name=>'APEXIR_DISABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\505C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285807799873437)
,p_name=>'APEXIR_DISPLAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256933611873416)
,p_name=>'APEXIR_DISPLAYED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284449219873436)
,p_name=>'APEXIR_DISPLAYED_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\7684\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285528677159873614)
,p_name=>'APEXIR_DISPLAY_IN_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\5728\5831\8868\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257682350873417)
,p_name=>'APEXIR_DONUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\74B0\5708\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285498368330873592)
,p_name=>'APEXIR_DOWN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5411\4E0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413925435873530)
,p_name=>'APEXIR_DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\8F09')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285644560873437)
,p_name=>'APEXIR_DO_NOT_AGGREGATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \4E0D\805A\7E3D -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285528519630873614)
,p_name=>'APEXIR_DO_NOT_DISPLAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286386145526874233)
,p_name=>'APEXIR_DUPLICATE_PIVOT_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8907\7684\6A1E\7D10\5206\6790\8868\8CC7\6599\6B04.  \6A1E\7D10\5206\6790\8868\8CC7\6599\6B04\6E05\55AE\5FC5\9808\662F\552F\4E00\7684.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286386507263874234)
,p_name=>'APEXIR_EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286325256867874184)
,p_name=>'APEXIR_EDIT_ALTERNATIVE_DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\66FF\4EE3\9810\8A2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501729839873594)
,p_name=>'APEXIR_EDIT_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\5716\8868\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531729530873616)
,p_name=>'APEXIR_EDIT_CHART2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532230398873616)
,p_name=>'APEXIR_EDIT_FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286028147578873965)
,p_name=>'APEXIR_EDIT_GROUP_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\7FA4\7D44\4F9D\64DA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532189212873616)
,p_name=>'APEXIR_EDIT_HIGHLIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\6A19\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285844803791873836)
,p_name=>'APEXIR_EDIT_PIVOT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\6A1E\7D10\5206\6790\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375236229874225)
,p_name=>'APEXIR_EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285200514022873375)
,p_name=>'APEXIR_EMAIL_ADDRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375521721874226)
,p_name=>'APEXIR_EMAIL_BCC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\4EF6\526F\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375775312874226)
,p_name=>'APEXIR_EMAIL_BODY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\9AD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375463652874226)
,p_name=>'APEXIR_EMAIL_CC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\526F\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376497710874226)
,p_name=>'APEXIR_EMAIL_FREQUENCY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\983B\7387')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285235370243873400)
,p_name=>'APEXIR_EMAIL_NOT_CONFIGURED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C1A\672A\8A2D\5B9A\6B64\61C9\7528\7A0B\5F0F\7684\96FB\5B50\90F5\4EF6.  \8ACB\6D3D\8A62\60A8\7684\7BA1\7406\54E1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980446408873930)
,p_name=>'APEXIR_EMAIL_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\96FB\5B50\90F5\4EF6\5730\5740.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375802107874226)
,p_name=>'APEXIR_EMAIL_SEE_ATTACHED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\770B\9644\52A0\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375603354874226)
,p_name=>'APEXIR_EMAIL_SUBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\65E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285982308818873932)
,p_name=>'APEXIR_EMAIL_SUBJECT_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\96FB\5B50\90F5\4EF6\4E3B\65E8.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375367832874225)
,p_name=>'APEXIR_EMAIL_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6536\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505863773873597)
,p_name=>'APEXIR_ENABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254392959873414)
,p_name=>'APEXIR_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\555F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532038448873616)
,p_name=>'APEXIR_ENABLE_DISABLE_ALT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528/\505C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531467890873616)
,p_name=>'APEXIR_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530835475873615)
,p_name=>'APEXIR_EXAMPLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\4F8B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531844939873616)
,p_name=>'APEXIR_EXAMPLES_WITH_COLON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\4F8B:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284308193873436)
,p_name=>'APEXIR_EXCLUDE_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\9664\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532707996873617)
,p_name=>'APEXIR_EXPAND_COLLAPSE_ALT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C55\958B/\96B1\85CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285529608843873614)
,p_name=>'APEXIR_EXPRESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413413071873530)
,p_name=>'APEXIR_FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505351717873597)
,p_name=>'APEXIR_FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285589880482873660)
,p_name=>'APEXIR_FILTER_EXPRESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078\8868\793A\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286452707507874282)
,p_name=>'APEXIR_FILTER_EXPR_TOO_LONG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078\8868\793A\5F0F\592A\9577.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285589732432873660)
,p_name=>'APEXIR_FILTER_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532930814873617)
,p_name=>'APEXIR_FINDER_ALT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\8981\641C\5C0B\7684\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413764292873530)
,p_name=>'APEXIR_FLASHBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5012\6EAF')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285529309544873614)
,p_name=>'APEXIR_FLASHBACK_DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\82E5\60F3\6AA2\8996\5148\524D\6642\9EDE\7684\8CC7\6599, \53EF\4EE5\4F7F\7528\5012\6EAF\67E5\8A62.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531225673873616)
,p_name=>'APEXIR_FLASHBACK_ERROR_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\57F7\884C\5012\6EAF\8981\6C42')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285981040032873931)
,p_name=>'APEXIR_FLASHBACK_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5012\6EAF\6301\7E8C\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989692319873937)
,p_name=>'APEXIR_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\683C\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285383904407873509)
,p_name=>'APEXIR_FORMAT_MASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\683C\5F0F\906E\7F69 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285496683319873591)
,p_name=>'APEXIR_FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530321465873615)
,p_name=>'APEXIR_FUNCTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286374884281874225)
,p_name=>'APEXIR_FUNCTIONS_OPERATORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578/\904B\7B97\5B50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285962577347873917)
,p_name=>'APEXIR_FUNCTION_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285496179358873590)
,p_name=>'APEXIR_FUNCTION_N'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413290391873530)
,p_name=>'APEXIR_GO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980924376873931)
,p_name=>'APEXIR_GRAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7070\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254829916873415)
,p_name=>'APEXIR_GREEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DA0\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285114918534873312)
,p_name=>'APEXIR_GROUP_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44\4F9D\64DA')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375959212874226)
,p_name=>'APEXIR_GROUP_BY_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F9D\8CC7\6599\6B04 %0 \7FA4\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285856003265873844)
,p_name=>'APEXIR_GROUP_BY_COL_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\7FA4\7D44\4F9D\64DA\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285962323530873917)
,p_name=>'APEXIR_GROUP_BY_MAX_ROW_CNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\7FA4\7D44\4F9D\64DA\300D\67E5\8A62\7684\8CC7\6599\5217\8A08\6578\4E0A\9650\9650\5236\7684\662F\57FA\790E\67E5\8A62\4E2D\7684\8CC7\6599\5217\6578\76EE, \800C\4E0D\662F\9650\5236\986F\793A\7684\8CC7\6599\5217\6578\76EE.  \60A8\7684\57FA\790E\67E5\8A62\8D85\51FA\8CC7\6599\5217\8A08\6578\4E0A\9650 (%0 \500B\8CC7\6599\5217).  \8ACB\5957\7528\7BE9\9078\4EE5\6E1B\5C11\60A8\57FA\790E\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285776447338873791)
,p_name=>'APEXIR_GROUP_BY_SORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\6392\5E8F\7FA4\7D44')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286386092165874233)
,p_name=>'APEXIR_GROUP_BY_SORT_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\6392\5E8F\9806\5E8F\7FA4\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284960864873437)
,p_name=>'APEXIR_HCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C34\5E73\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285523178844873610)
,p_name=>'APEXIR_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AAA\660E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488716492873585)
,p_name=>'APEXIR_HELP_01'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\4E00\822C\4F7F\7528\8005\53EF\5728\4E92\52D5\5F0F\5831\8868\81EA\8A02\5831\8868. \4F7F\7528\8005\53EF\4EE5\9078\53D6\60F3\8981\7684\8CC7\6599\6B04, \4E26\7BE9\9078\3001\6A19\793A\53CA\6392\5E8F, \4EE5\66F4\6539\5831\8868\8CC7\6599\7684\7248\9762\914D\7F6E. \4E5F\53EF\4EE5\5B9A\7FA9\5206\6BB5\3001\805A\7E3D\3001\5716\8868\3001\7FA4\7D44\65B9\5F0F\4EE5\53CA\65B0\589E\81EA\5DF1\7684\904B\7B97. \4E5F\53EF\4EE5\5EFA\7ACB\8A02\95B1, \4F9D\6307\5B9A\7684\9593\9694\900F\904E\96FB\5B50\90F5\4EF6\6536\5230 HTML \7248\672C\7684\5831\8868. \4F7F\7528\8005\53EF\4EE5\5EFA\7ACB\591A\7A2E\4E0D\540C\7684\5831\8868, \4E26\5132\5B58\70BA\5177\540D\5831\8868, \4F9B\516C\7528\6216\79C1\4EBA\6AA2\8996\4E4B\7528. '),
'<p/>',
unistr('\5F8C\9762\7684\6BB5\843D\6703\6458\8981\8AAA\660E\60A8\53EF\4EE5\81EA\8A02\4E92\52D5\5F0F\5831\8868\7684\65B9\5F0F. \5982\9700\77AD\89E3\8A73\7D30\8CC7\8A0A, \8ACB\53C3\95B1 <i>Oracle Application Express End User''s Guide</i> \7684 "Using Interactive Reports"</a>.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285506145881873597)
,p_name=>'APEXIR_HELP_ACTIONS_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\52D5\4F5C\300D\529F\80FD\8868\6703\986F\793A\5728\300C\641C\5C0B\300D\5217\4E2D\300C\57F7\884C\300D\6309\9215\7684\53F3\908A. \60A8\53EF\4EE5\4F7F\7528\6B64\529F\80FD\8868\4F86\81EA\8A02\4E92\52D5\5F0F\5831\8868.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489737711873586)
,p_name=>'APEXIR_HELP_AGGREGATE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\805A\7E3D\662F\6307\5C0D\8CC7\6599\6B04\57F7\884C\7B97\8853\904B\7B97. \5728\6BCF\500B\63A7\5236\5206\6BB5\4E4B\5F8C\8207\5831\8868\7D50\5C3E\8655, \65BC\5B9A\7FA9\8981\8A08\7B97\805A\7E3D\7684\8CC7\6599\6B04\5167\986F\793A\805A\7E3D\503C. \9078\9805\5305\62EC:'),
'<p>',
'</p><ul>',
unistr('<li><b>\805A\7E3D</b>: \9078\53D6\5148\524D\5B9A\7FA9\7684\805A\7E3D\9032\884C\7DE8\8F2F.</li>'),
unistr('<li><b>\51FD\6578</b>: \8981\57F7\884C\7684\51FD\6578 (\4F8B\5982 SUM\3001MIN).</li>'),
unistr('<li><b>\8CC7\6599\6B04</b>: \9078\53D6\8981\5957\7528\7B97\8853\51FD\6578\7684\8CC7\6599\6B04. \53EA\6703\986F\793A\6578\503C\8CC7\6599\6B04.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489851271873586)
,p_name=>'APEXIR_HELP_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\53EF\4EE5\66FF\6BCF\4E00\4EFD\5132\5B58\7684\5831\8868\5B9A\7FA9\4E00\500B\5716\8868. \5B9A\7FA9\4E4B\5F8C, \5C31\53EF\4EE5'),
unistr('\4F7F\7528\300C\641C\5C0B\300D\5217\6AA2\8996\5716\793A, \5728\5716\8868\8207\5831\8868\6AA2\8996\4E4B\9593\5207\63DB.'),
unistr('\9078\9805\5305\62EC:  '),
'<p>',
'</p><ul>',
unistr('<li><b>\5716\8868\985E\578B</b>: \6307\5B9A\8981\5305\542B\7684\5716\8868\985E\578B.'),
unistr('\53EF\9078\53D6\7684\985E\578B\5305\62EC\6C34\5E73\9577\689D\5716\3001\5782\76F4\9577\689D\5716\3001\5713\9905\5716\6216\6298\7DDA\5716.</li>'),
unistr('<li><b>\6A19\7C64</b>: \9078\53D6\8981\7576\4F5C\6A19\7C64\7684\8CC7\6599\6B04.</li>'),
unistr('<li><b>\6A19\7C64\7684\5EA7\6A19\8EF8\6A19\984C</b>: \5728\8207\9078\53D6\70BA\300C\6A19\7C64\300D\4E4B\8CC7\6599\6B04\95DC\806F\7684\5EA7\6A19\8EF8\986F\793A\7684\6A19\984C.'),
unistr('\9019\4E0D\9069\7528\65BC\5713\9905\5716.</li>'),
unistr('<li><b>\503C</b>: \9078\53D6\8981\7576\4F5C\503C\7684\8CC7\6599\6B04.  \82E5\4F7F\7528 COUNT \51FD\6578,'),
unistr('\5C31\4E0D\9700\8981\9078\53D6\300C\503C\300D.</li>'),
unistr('<li><b>\503C\7684\5EA7\6A19\8EF8\6A19\984C</b>: \5728\8207\9078\53D6\70BA\300C\503C\300D\4E4B\8CC7\6599\6B04\95DC\806F\7684\5EA7\6A19\8EF8\986F\793A\7684\6A19\984C.'),
unistr('\9019\4E0D\9069\7528\65BC\5713\9905\5716.</li>'),
unistr('<li><b>\51FD\6578</b>: \8981\5728\9078\53D6\70BA\300C\503C\300D\4E4B\8CC7\6599\6B04\57F7\884C\7684\9078\64C7\6027\51FD\6578.</li>'),
unistr('<li><b>\6392\5E8F</b>: \53EF\6392\5E8F\60A8\7684\7D50\679C\96C6.</li></ul>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489108959873585)
,p_name=>'APEXIR_HELP_COLUMN_HEADING_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6309\4E00\4E0B\4EFB\4E00\8CC7\6599\6B04\6A19\984C\5373\53EF\986F\793A\8CC7\6599\6B04\6A19\984C\529F\80FD\8868. \9078\9805\5305\62EC:'),
'<p></p>',
'<ul>',
unistr('<li><b>\905E\589E\6392\5E8F</b>\5716\793A: \6309\8CC7\6599\6B04, \4EE5\905E\589E\9806\5E8F\6392\5E8F\5831\8868.</li>'),
unistr('<li><b>\905E\6E1B\6392\5E8F</b>\5716\793A: \6309\8CC7\6599\6B04, \4EE5\905E\6E1B\9806\5E8F\6392\5E8F\5831\8868.</li>'),
unistr('<li><b>\96B1\85CF\8CC7\6599\6B04</b>: \96B1\85CF\8CC7\6599\6B04. \60A8\7121\6CD5\96B1\85CF\6240\6709\8CC7\6599\6B04. \82E5\8CC7\6599\6B04\7121\6CD5\96B1\85CF, \5C31\4E0D\6703\6709\300C\96B1\85CF\8CC7\6599\6B04\300D\5716\793A.</li>'),
unistr('<li><b>\5206\6BB5\8CC7\6599\6B04</b>: \6839\64DA\8CC7\6599\6B04\5EFA\7ACB\5206\6BB5\7FA4\7D44. \5831\8868\5C07\6703\4EE5\8A72\8CC7\6599\6B04\4F5C\70BA\4E3B\8981\8A18\9304.</li>'),
unistr('<li><b>\8CC7\6599\6B04\8CC7\8A0A</b>: \986F\793A\8CC7\6599\6B04\7684\8AAA\660E\5167\5BB9 (\5982\679C\6709\7684\8A71).</li>'),
unistr('<li><b>\6587\5B57\5340</b>: \53EF\65BC\5176\4E2D\8F38\5165\6C92\6709\5927\5C0F\5BEB\4E4B\5206\7684\641C\5C0B\689D\4EF6'),
unistr('(\4E0D\9700\4F7F\7528\842C\7528\5B57\5143).'),
unistr('\8F38\5165\503C\5C07\53EF\6E1B\5C11\529F\80FD\8868\5E95\7AEF\7684\503C\6E05\55AE.'),
unistr('\60A8\53EF\4EE5\5F9E\5E95\7AEF\9078\53D6\4E00\500B\503C,'),
unistr('\9078\53D6\7684\503C\4FBF\6703\4F7F\7528 ''='' \5EFA\7ACB\70BA\7BE9\9078'),
unistr('(\4F8B\5982, <code>column = ''ABC''</code>). \6216\8005, \60A8\53EF\4EE5\6309\4E00\4E0B\300C\624B\96FB\7B52\300D \5716\793A\4E26\8F38\5165\503C, \4F7F\7528 ''LIKE'' \4FEE\98FE\689D\4EF6'),
unistr('\5C07\503C\5EFA\7ACB\70BA\7BE9\9078 (\4F8B\5982, <code>column LIKE ''%ABC%''</code>).</li>'),
unistr('<li><b>\552F\4E00\503C\6E05\55AE</b>: \5305\542B\7B26\5408\7BE9\9078\689D\4EF6'),
unistr('\7684\524D 500 \500B\552F\4E00\503C. \82E5\8CC7\6599\6B04\662F\65E5\671F, \5247\6703\986F\793A'),
unistr('\65E5\671F\7BC4\570D\6E05\55AE. \5982\679C\9078\53D6\67D0\500B\503C, \5C07\6703\4F7F\7528'),
unistr('''='' \5EFA\7ACB\4E00\500B\7BE9\9078 (\4F8B\5982, <code>column = ''ABC''</code>).</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489696406873585)
,p_name=>'APEXIR_HELP_COMPUTE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\53EF\8B93\60A8\65B0\589E\7D93\904E\904B\7B97\7684\8CC7\6599\6B04\5230\60A8\7684\5831\8868. \53EF\4EE5\662F\5957\7528\81F3\73FE\6709\8CC7\6599\6B04\7684\7B97\8853\904B\7B97 (\4F8B\5982, <code>NBR_HOURS/24</code>) \6216\6A19\6E96\7684 Oracle'),
unistr('\51FD\6578. \90E8\5206\986F\793A\70BA\7BC4\4F8B\548C\5176\4ED6\9805\76EE (\4F8B\5982\4E5F\53EF\4EE5\4F7F\7528 <code>TO_DATE)</code>). \9078\9805\5305\62EC:'),
'<p></p>',
'<ul>',
unistr('<li><b>\904B\7B97</b>: \9078\53D6\5148\524D\5B9A\7FA9\7684\904B\7B97\4F86\52A0\4EE5\7DE8\8F2F.</li>'),
unistr('<li><b>\8CC7\6599\6B04\6A19\984C</b>: \65B0\8CC7\6599\6B04\7684\6A19\984C.</li>'),
unistr('<li><b>\683C\5F0F\906E\7F69</b>: \8CC7\6599\6B04\5957\7528\7684 Oracle \683C\5F0F\906E\7F69 (\4F8B\5982 S9999).</li>'),
unistr('<li><b>\904B\7B97</b>: \8981\57F7\884C\7684\904B\7B97. \5728\904B\7B97\5167, \4E3B\8981\4F7F\7528\986F\793A\7684\5225\540D\53C3\7167\8CC7\6599\6B04.</li>'),
'</ul>',
unistr('<p>\5728\904B\7B97\4E0B\65B9, \60A8\67E5\8A62\4E2D\7684\8CC7\6599\6B04\6703\4EE5\5176\76F8\95DC\5225\540D'),
unistr('\986F\793A. \6309\4E00\4E0B\8CC7\6599\6B04\540D\7A31\6216\5225\540D\5373\53EF\5C07\5176\5305\62EC\5728'),
unistr('\300C\904B\7B97\300D\4E2D. \300C\8CC7\6599\6B04\300D\7684\65C1\908A\662F\4E00\500B\9375\53F0. \6B64\9375\53F0\7684\529F\80FD\70BA'),
unistr('\5E38\7528\6309\9375\7684\6377\5F91. \6700\53F3\908A\5247\662F\300C\51FD\6578\300D.</p>'),
unistr('<p>\4E0B\5217\7BC4\4F8B\904B\7B97\793A\7BC4\5982\4F55\986F\793A\5831\916C\7E3D\8A08:</p>'),
'<pre>CASE WHEN A = ''SALES'' THEN B + C ELSE B END</pre>',
unistr('(\5176\4E2D\7684 A \662F ORGANIZATION, B \662F SALARY, \800C C \662F COMMISSION)</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285506231858873598)
,p_name=>'APEXIR_HELP_CONTROL_BREAK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\4E00\6216\6578\500B\8CC7\6599\6B04\5EFA\7ACB\5206\7D44. \9019\53EF\5C07\4E92\52D5\5F0F\5831\8868\7684\8CC7\6599\6B04\986F\793A\70BA\4E3B\8981\8A18\9304.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490350761873586)
,p_name=>'APEXIR_HELP_DETAIL_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\82E5\8981\4E00\6B21\6AA2\8996\67D0\500B\55AE\4E00\8CC7\6599\5217\7684\8A73\7D30\8CC7\8A0A, \8ACB\6309\4E00\4E0B\60F3\8981\6AA2\8996\4E4B\8CC7\6599\5217\7684\55AE\4E00\8CC7\6599\5217\6AA2\8996\5716\793A. \5982\679C\6709\7684\8A71, \55AE\4E00\8CC7\6599\5217\6AA2\8996\4E00\5F8B\662F\7B2C\4E00\500B\8CC7\6599\6B04. \6839\64DA\81EA\8A02\4E92\52D5\5F0F\5831\8868\65B9\5F0F\7684\4E0D\540C, \55AE\4E00\8CC7\6599\5217\6AA2\8996\6709\53EF\80FD\662F\6A19\6E96\6AA2\8996\6216\5141\8A31\66F4\65B0\7684\81EA\8A02\9801\9762.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490286406873586)
,p_name=>'APEXIR_HELP_DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\53EF\4EE5\4E0B\8F09\76EE\524D\7684\7D50\679C\96C6. \4E0B\8F09\683C\5F0F\5C07\6839\64DA\5B89\88DD\548C'),
unistr('\5831\8868\5B9A\7FA9\7684\4E0D\540C\800C\6709\6240\4E0D\540C, \53EF\80FD\5305\62EC CSV\3001'),
unistr('HTML\3001\96FB\5B50\90F5\4EF6\3001XLS\3001PDF \6216 RTF.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489334068873585)
,p_name=>'APEXIR_HELP_FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5728\67E5\8A62\65B0\589E\6216\4FEE\6539 <code>WHERE</code> \5B50\53E5, \4EE5\5F37\8ABF\5831\8868\91CD\9EDE. \60A8\53EF\4EE5\6839\64DA\8CC7\6599\6B04\6216\8CC7\6599\5217\7BE9\9078.  '),
unistr('<p>\82E5\6309\8CC7\6599\6B04\7BE9\9078, \8ACB\9078\53D6\4E00\500B\8CC7\6599\6B04 (\4E0D\4E00\5B9A\8981\662F'),
unistr('\986F\793A\7684\8CC7\6599\6B04), \63A5\8457\9078\53D6\4E00\500B\6A19\6E96 Oracle \904B\7B97\5B50 (=\3001!=\3001not in\3001between), \7136\5F8C\8F38\5165\64DA\4EE5\6BD4\8F03\7684\8868\793A\5F0F. \8868\793A\5F0F\6709\5927\5C0F\5BEB\4E4B\5206. \8ACB\4F7F\7528 % \4F5C\70BA\842C\7528\5B57\5143 (\4F8B\5982, <code>STATE_NAME'),
'like A%)</code>.</p>',
unistr('<p>\82E5\6309\8CC7\6599\5217\7BE9\9078, \53EF\4EE5\5EFA\7ACB\8907\96DC\7684 <code>WHERE</code> \5B50\53E5, \65B9\6CD5\70BA\4F7F\7528'),
unistr('\8CC7\6599\6B04\5225\540D\548C\4EFB\4F55\7684 Oracle \51FD\6578\6216\904B\7B97\5B50 (\4F8B\5982, <code>G = ''VA'' \6216 G = ''CT''</code>, \5176\4E2D\7684'),
unistr('<code>G</code> \662F <code>CUSTOMER_STATE</code> \7684\5225\540D).</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489981205873586)
,p_name=>'APEXIR_HELP_FLASHBACK'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\53EF\4EE5\5229\7528\5012\6EAF\67E5\8A62\6AA2\8996\5148\524D\6642\9EDE\7684\8CC7\6599.'),
unistr('\4F9D\7167\9810\8A2D, \53EF\4EE5\5012\6EAF\7684\6642\9593\70BA 3 \5C0F\6642 (\6216 180 \5206\9418),'),
unistr('\4F46\5BE6\969B\6642\9593\5C07\6839\64DA\6BCF\500B\8CC7\6599\5EAB\800C\6709\6240\4E0D\540C.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989540034873937)
,p_name=>'APEXIR_HELP_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\5229\7528\683C\5F0F\81EA\8A02\5831\8868\7684\986F\793A.'),
unistr('\683C\5F0F\5305\542B\4E0B\5217\5B50\529F\80FD\8868:</p>'),
unistr('<ul><li>\6392\5E8F</li>'),
unistr('<li>\63A7\5236\5206\6BB5</li>'),
unistr('<li>\6A19\793A</li>'),
unistr('<li>\904B\7B97</li>'),
unistr('<li>\805A\7E3D</li>'),
unistr('<li>\5716\8868</li>'),
unistr('<li>\7FA4\7D44\4F9D\64DA</li>'),
unistr('<li>\6A1E\7D10\5206\6790\8868</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980202128873930)
,p_name=>'APEXIR_HELP_GROUP_BY'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\53EF\4EE5\66FF\6BCF\4E00\4EFD\5132\5B58\7684\5831\8868\5B9A\7FA9\4E00\500B\300C\7FA4\7D44\4F9D\64DA\300D\6AA2\8996.'),
unistr('\5B9A\7FA9\4E4B\5F8C, \5C31\53EF\4EE5\4F7F\7528\300C\641C\5C0B\300D\5217\4E0A\7684\6AA2\8996\5716\793A, \5728\7FA4\7D44\4F9D\64DA'),
unistr('\8207\5831\8868\6AA2\8996\4E4B\9593\5207\63DB. \82E5\8981\5EFA\7ACB\300C\7FA4\7D44\4F9D\64DA\300D\6AA2\8996,'),
unistr('\8ACB\9078\53D6:'),
'<p></p><ul>',
unistr('<li>\8981\7FA4\7D44\7684\8CC7\6599\6B04</li>'),
unistr('<li>\8981\805A\7E3D\7684\8CC7\6599\6B04\8207\8981\57F7\884C\7684\51FD\6578 (average\3001sum\3001count... \7B49\7B49)</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489510933873585)
,p_name=>'APEXIR_HELP_HIGHLIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\53EF\8B93\60A8\5B9A\7FA9\7BE9\9078. \7CFB\7D71\5C07\4F7F\7528\7BE9\9078\76F8\95DC\7279\6027, \5C07\7B26\5408\7BE9\9078\689D\4EF6\7684\8CC7\6599\5217\53CD\767D\986F\793A. \9078\9805\5305\62EC:</p>'),
'<ul>',
unistr('<li><b>\540D\7A31</b>: \53EA\7528\65BC\986F\793A.</li>'),
unistr('<li><b>\9806\5E8F</b>: \6307\5B9A\898F\5247\7684\8A55\4F30\9806\5E8F.</li>'),
unistr('<li><b>\555F\7528</b>: \6307\5B9A\555F\7528\6216\505C\7528\898F\5247.</li>'),
unistr('<li><b>\6A19\793A\985E\578B</b>: \6307\5B9A\61C9\8A72\6A19\793A\8CC7\6599\5217\6216\5132\5B58\683C.'),
unistr('\5982\679C\9078\53D6\300C\5132\5B58\683C\300D, \5247\6703\6A19\793A\300C\6A19\793A\689D\4EF6\300D\4E2D\53C3\7167\7684'),
unistr('\8CC7\6599\6B04.</li>'),
unistr('<li><b>\80CC\666F\8272\5F69</b>: \65B0\7684\6A19\793A\5340\57DF\80CC\666F\8272\5F69.</li>'),
unistr('<li><b>\6587\5B57\8272\5F69</b>: \65B0\7684\6A19\793A\5340\57DF\4E2D\6587\5B57\8272\5F69.</li>'),
unistr('<li><b>\6A19\793A\689D\4EF6</b>: \5B9A\7FA9\7BE9\9078\689D\4EF6.</li>'),
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285086229982873291)
,p_name=>'APEXIR_HELP_PIVOT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\60A8\53EF\4EE5\66FF\6BCF\4E00\4EFD\5132\5B58\7684\5831\8868\5B9A\7FA9\4E00\500B\300C\6A1E\7D10\5206\6790\8868\300D\6AA2\8996. \5B9A\7FA9\4E4B\5F8C, \5C31\53EF\4EE5\4F7F\7528\300C\641C\5C0B\300D\5217\4E0A\7684\6AA2\8996\5716\793A, \5728\6A1E\7D10\5206\6790\8868\8207\5831\8868\6AA2\8996\4E4B\9593\9032\884C\5207\63DB. \82E5\8981\5EFA\7ACB\300C\6A1E\7D10\5206\6790\8868\300D\6AA2\8996, \8ACB\9078\53D6: '),
'<p></p>',
'<ul>',
unistr('<li>\6A1E\7D10\5206\6790\8868\4F5C\7528\7684\8CC7\6599\6B04</li>'),
unistr('<li>\8981\986F\793A\70BA\8CC7\6599\5217\7684\8CC7\6599\6B04</li>'),
unistr('<li>\8207\8981\57F7\884C\51FD\6578 (average\3001sum\3001count \7B49\7B49) \805A\7E3D\7684\8CC7\6599\6B04</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531065014873615)
,p_name=>'APEXIR_HELP_REPORT_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5982\679C\60A8\81EA\8A02\4E92\52D5\5F0F\5831\8868, \5831\8868\8A2D\5B9A\503C\6703\986F\793A\5728\300C\641C\5C0B\300D\5217\4E0B\65B9\548C\5831\8868\7684\4E0A\65B9.'),
unistr('\60A8\53EF\4EE5\4F7F\7528\5DE6\908A\7684\5716\793A\96B1\85CF\53CA\5C55\958B\6B64\5340\57DF.'),
'<p>',
unistr('\60A8\53EF\4EE5\5C0D\6BCF\4E00\500B\5831\8868\8A2D\5B9A\57F7\884C\4E0B\5217\4F5C\696D:'),
'</p><ul>',
unistr('<li>\6309\4E00\4E0B\540D\7A31\4F86\7DE8\8F2F\67D0\9805\8A2D\5B9A\503C.</li>'),
unistr('<li>\53D6\6D88\52FE\9078\6216\52FE\9078\300C\555F\7528/\505C\7528\300D\6838\53D6\65B9\584A, \4EE5\505C\7528/\555F\7528\67D0\9805\8A2D\5B9A\503C. \60A8\53EF\4EE5\4F7F\7528\6B64\63A7\5236\9805\66AB\6642\95DC\9589\548C\958B\555F\67D0\9805\8A2D\5B9A\503C.</li>'),
unistr('<li>\6309\4E00\4E0B\300C\79FB\9664\300D\5716\793A, \4EE5\79FB\9664\67D0\9805\8A2D\5B9A\503C.</li>'),
'</ul>',
unistr('<p>\5982\679C\60A8\5DF2\7D93\5EFA\7ACB\5716\8868\3001\7FA4\7D44\4F9D\64DA\6216\6A1E\7D10\5206\6790\8868, \53EF\4EE5\4F7F\7528\53F3\65B9\986F\793A\7684\300C\5831\8868\6AA2\8996\300D\3001'),
unistr('\300C\5716\8868\6AA2\8996\300D\3001\300C\7FA4\7D44\4F9D\64DA\6AA2\8996\300D\548C\300C\6A1E\7D10\5206\6790\8868\6AA2\8996\300D\9023\7D50, \5728\5B83\5011\8207\57FA\672C\5831\8868\4E4B\9593'),
unistr('\5207\63DB. \5982\679C\60A8\6AA2\8996\5716\8868\3001\7FA4\7D44\4F9D\64DA\6216\6A1E\7D10\5206\6790\8868, \4E5F\53EF\4EE5\4F7F\7528\300C\7DE8\8F2F\300D\9023\7D50\4F86\7DE8\8F2F'),
unistr('\8A2D\5B9A\503C.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490116945873586)
,p_name=>'APEXIR_HELP_RESET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\5831\8868\91CD\8A2D\70BA\9810\8A2D\503C, \79FB\9664\4E4B\524D\8A2D\5B9A\7684\81EA\8A02\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989860485873937)
,p_name=>'APEXIR_HELP_ROWS_PER_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\6BCF\9801\6240\8981\986F\793A\7684\8A18\9304\6578\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490096950873586)
,p_name=>'APEXIR_HELP_SAVE_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5132\5B58\81EA\8A02\5831\8868\4F9B\672A\4F86\4F7F\7528. \59B3\9700\8981\63D0\4F9B\540D\7A31\548C\9078\64C7\6027\7684\63CF\8FF0, \4E5F\53EF\4EE5\8B93\5831\8868\53EF\4F9B\516C\958B\5B58\53D6 (\4EA6\5373, \80FD\5920\5B58\53D6\4E3B\8981\9810\8A2D\5831\8868\7684\6240\6709\4F7F\7528\8005). \60A8\53EF\4EE5\5132\5B58\56DB\7A2E\985E\578B\7684\4E92\52D5\5F0F\5831\8868:</p>'),
'<ul>',
unistr('<li><strong>\4E3B\8981\9810\8A2D</strong> (\50C5\9650\958B\767C\4EBA\54E1).\300C\4E3B\8981\9810\8A2D\300D\662F\4E00\958B\59CB\986F\793A\7684\5831\8868.\300C\4E3B\8981\9810\8A2D\300D\5831\8868\4E0D\53EF\91CD\65B0\547D\540D\6216\52A0\4EE5\522A\9664.</li>'),
unistr('<li><strong>\66FF\4EE3\5831\8868</strong> (\50C5\9650\958B\767C\4EBA\54E1). \53EF\8B93\958B\767C\4EBA\54E1\5EFA\7ACB\591A\500B\5831\8868\7248\9762\914D\7F6E. \53EA\6709\958B\767C\4EBA\54E1\80FD\5920\5132\5B58\3001\91CD\65B0\547D\540D\6216\522A\9664\300C\66FF\4EE3\5831\8868\300D.</li>'),
unistr('<li><strong>\516C\7528\5831\8868</strong> (\4E00\822C\4F7F\7528\8005). \53EF\7531\5EFA\7ACB\5831\8868\7684\4E00\822C\4F7F\7528\8005\5132\5B58\3001\91CD\65B0\547D\540D\6216\522A\9664. \5176\4ED6\4F7F\7528\8005\53EF\4EE5\6AA2\8996\4EE5\53CA\5C07\7248\9762\914D\7F6E\53E6\5B58\70BA\53E6\4E00\4EFD\5831\8868.</li>'),
unistr('<li><strong>\5C08\7528\5831\8868</strong> (\4E00\822C\4F7F\7528\8005). \53EA\6709\5EFA\7ACB\5831\8868\7684\4E00\822C\4F7F\7528\8005\53EF\4EE5\6AA2\8996\3001\5132\5B58\3001\91CD\65B0\547D\540D\6216\522A\9664\5831\8868.</li>'),
'</ul>',
unistr('<p>\82E5\60A8\5132\5B58\81EA\8A02\5831\8868, \6703\5728\300C\641C\5C0B\300D\5217\4E2D\300C\8CC7\6599\5217\300D\9078\53D6\5668 (\82E5\555F\7528\6B64\529F\80FD) \7684\5DE6\908A\986F\793A\300C\5831\8868\300D\9078\53D6\5668.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489028591873585)
,p_name=>'APEXIR_HELP_SEARCH_BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\500B\5831\8868\9801\9762\7684\9802\7AEF\90FD\6709\4E00\500B\641C\5C0B\5340\57DF. \6B64\5340\57DF (\6216\300C\641C\5C0B\300D\5217) \63D0\4F9B\4E0B\5217\529F\80FD:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285990475885873938)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ACTIONS_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<li><b>\52D5\4F5C\529F\80FD\8868</b>: \53EF\4F9B\81EA\8A02\5831\8868. \8ACB\53C3\95B1\5F8C\9762\7684\6BB5\843D.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989920625873937)
,p_name=>'APEXIR_HELP_SEARCH_BAR_FINDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<li><b>\9078\53D6\8CC7\6599\6B04\5716\793A</b>: \53EF\6307\5B9A\8981\641C\5C0B\7684\8CC7\6599\6B04 (\6216\5168\90E8\8CC7\6599\6B04).</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285990252925873937)
,p_name=>'APEXIR_HELP_SEARCH_BAR_REPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<li><b>\5831\8868</b>: \986F\793A\66FF\4EE3\9810\8A2D\503C\4EE5\53CA\9810\5B58\7684\5C08\7528\6216\516C\7528\5831\8868.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285990135681873937)
,p_name=>'APEXIR_HELP_SEARCH_BAR_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<li><b>\8CC7\6599\5217</b>: \8A2D\5B9A\6BCF\9801\6240\8981\986F\793A\7684\8A18\9304\6578\76EE.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285990051993873937)
,p_name=>'APEXIR_HELP_SEARCH_BAR_TEXTBOX'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<li><b>\6587\5B57\5340</b>: \53EF\4F9B\60A8\8F38\5165\4E0D\5340\5206\5927\5C0F\5BEB\7684\641C\5C0B\689D\4EF6 (\6703\81EA\52D5\4F7F\7528\842C\7528\5B57\5143).</li>'),
unistr('<li><b>\57F7\884C\6309\9215</b>: \57F7\884C\641C\5C0B. \5982\679C\6E38\6A19\5728\641C\5C0B\6587\5B57\5340\4E2D, \5247\6309 Enter \9375\4E5F\6703\57F7\884C\641C\5C0B.</li>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285990361024873937)
,p_name=>'APEXIR_HELP_SEARCH_BAR_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<li><b>\6AA2\8996\5716\793A</b>: \53EF\5728\5831\8868\7684\5DF2\5B9A\7FA9\5716\793A\3001\5831\8868\3001\8A73\7D30\8CC7\8A0A\3001\5716\8868\3001\7FA4\7D44\4F9D\64DA\8207\6A1E\9215\5206\6790\8868\6AA2\8996\4E4B\9593\5207\63DB.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286332763127874190)
,p_name=>'APEXIR_HELP_SEARCH_BAR_WS_MANAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<li><b>\7BA1\7406</b>: \53EF\7BA1\7406\7279\6027\3001\8CC7\6599\6B04\3001\8CC7\6599\5217\4EE5\53CA\6AA2\8996\5831\8868\6216\8CC7\6599\65B9\683C\7684\6B77\53F2\8A18\9304.</li>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489230888873585)
,p_name=>'APEXIR_HELP_SELECT_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7528\4EE5\4FEE\6539\986F\793A\7684\8CC7\6599\6B04. \6703\986F\793A\5728\53F3\65B9\7684\8CC7\6599\6B04. \5728\5DE6\65B9\7684\8CC7\6599\6B04\5247\6703\96B1\85CF\8D77\4F86. \60A8\53EF\4EE5\4F7F\7528\6700\53F3\65B9\7684\7BAD\982D\91CD\65B0\6392\5217\986F\793A\7684\8CC7\6599\6B04. \7D93\904E\904B\7B97\7684\8CC7\6599\6B04\524D\9762\6703\52A0\4E0A <b>**</b>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285489436520873585)
,p_name=>'APEXIR_HELP_SORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7528\4EE5\8B8A\66F4\6392\5E8F\7684\8CC7\6599\6B04\53CA\6C7A\5B9A\662F\6309\905E\589E\6216\905E\6E1B\9806\5E8F'),
unistr('\6392\5E8F. \60A8\4E5F\53EF\4EE5\6307\5B9A\8655\7406 <code>NULL</code> \7684\65B9\5F0F.'),
unistr('\9810\8A2D\70BA\4E00\5F8B\5728\6700\5F8C\9762\6216\4E00\5F8B\5728\6700\524D\9762\986F\793A <code>NULL</code>.'),
unistr('\6392\5E8F\7D50\679C\6703\986F\793A\5728\5831\8868\4E2D\8CC7\6599\6B04\6A19\984C\7684\53F3\65B9.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979895703873930)
,p_name=>'APEXIR_HELP_SUBSCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8A02\95B1\6642, \60A8\9700\8981\63D0\4F9B\96FB\5B50\90F5\4EF6\5730\5740 (\82E5\6709\591A\500B\96FB\5B50\90F5\4EF6\5730\5740, \4F7F\7528\9017\865F\5340\9694)\3001\96FB\5B50\90F5\4EF6\4E3B\65E8\3001\983B\7387\4EE5\53CA\958B\59CB\548C\7D50\675F\65E5\671F. \7522\751F\7684\96FB\5B50\90F5\4EF6\6703\5305\62EC\4E00\500B\5176\4E2D\5305\542B\76EE\524D\8CC7\6599\4E4B HTML \7248\672C\7684\4E92\52D5\5F0F\5831\8868 (\4F7F\7528\65B0\589E\8A02\95B1\6642\7684\5831\8868\8A2D\5B9A).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286332254574874189)
,p_name=>'APEXIR_HELP_WS_01'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8CC7\6599\65B9\683C\57FA\672C\4E0A\662F\53EF\9AD8\5EA6\81EA\8A02\7684\53EF\7DE8\8F2F\5831\8868. \4F7F\7528\8005\53EF\4EE5\9078\53D6\60F3\8981\7684\8CC7\6599\6B04, \4E26\7BE9\9078\3001\6A19\793A\4EE5\53CA\6392\5E8F, \4EE5\66F4\6539\5831\8868\8CC7\6599\7684\7248\9762\914D\7F6E. \4E5F\53EF\4EE5\5B9A\7FA9\5206\6BB5\3001\805A\7E3D\3001\5716\8868\3001\7FA4\7D44\65B9\5F0F\4EE5\53CA\65B0\589E\81EA\5DF1\7684\904B\7B97. \4F7F\7528\8005\53EF\4EE5\5EFA\7ACB\591A\7A2E\4E0D\540C\7684\5831\8868, \4E26\5132\5B58\70BA\5177\540D\5831\8868, \4F9B\79C1\4EBA\6AA2\8996\4E4B\7528. '),
'<p/>',
unistr('\60A8\53EF\4EE5\4F7F\7528\641C\5C0B\5217\3001\52D5\4F5C\529F\80FD\8868\3001\7BA1\7406\529F\80FD\8868\6216\8CC7\6599\6B04\6A19\984C\529F\80FD\8868\4F86\81EA\8A02\8CC7\6599\65B9\683C.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286384641960874232)
,p_name=>'APEXIR_HELP_WS_ACTIONS_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\52D5\4F5C\300D\529F\80FD\8868\6703\986F\793A\5728\300C\641C\5C0B\300D\5217\4E2D\300C\57F7\884C\300D\6309\9215\7684\53F3\908A. \60A8\53EF\4EE5\4F7F\7528\6B64\529F\80FD\8868\4F86\81EA\8A02\8CC7\6599\65B9\683C\5831\8868.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286333038117874190)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E / \7DE8\8F2F\8CC7\6599\5217\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286333188682874190)
,p_name=>'APEXIR_HELP_WS_ADD_EDIT_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\65B0\589E\8CC7\6599\5217\81F3\8CC7\6599\65B9\683C, \8ACB\6309\4E00\4E0B\300C\65B0\589E\8CC7\6599\5217\300D. \82E5\8981\7DE8\8F2F\67D0\500B\8CC7\6599\5217\7684\8A73\7D30\8CC7\8A0A, \8ACB\6309\4E00\4E0B\60A8\8981\7DE8\8F2F\4E4B\8CC7\6599\5217\7684\7DE8\8F2F\8CC7\6599\5217\5716\793A (\7B2C\4E00\500B\8CC7\6599\6B04). \5C07\6703\986F\793A\300C\65B0\589E/\7DE8\8F2F\8CC7\6599\5217\300D\9801\9762, \5176\4E2D\986F\793A\8CC7\6599\65B9\683C\7684\8CC7\6599\6B04. </p>'),
'',
unistr('<p>\7DE8\8F2F\8CC7\6599\5217\6642, \60A8\53EF\4EE5\57F7\884C\4E0B\5217\52D5\4F5C:</p>'),
'',
'<p><ul>',
unistr('<li><b>\522A\9664</b>\8CC7\6599\5217.</li>'),
unistr('<li><b>\5957\7528\8B8A\66F4</b>, \5132\5B58\5C0D\8CC7\6599\5217\6240\505A\7684\8B8A\66F4.</li>'),
unistr('<li>\5728<b>\52D5\4F5C</b>\5167, \65B0\589E\8CC7\6599\5217, \65B0\589E\6A94\6848\3001\9644\8A3B\3001\9023\7D50\6216\6A19\8A18, \4EE5\53CA\8907\67E5\6B77\53F2\8A18\9304.</li>'),
unistr('<li>\5C0E\89BD<b>\4E0B\4E00\500B\548C\4E0A\4E00\500B</b>\8CC7\6599\5217.</li>'),
unistr('<li>\5728<b>\7BA1\7406</b>\5167, \8A2D\5B9A\8CC7\6599\6B04\7279\6027\3001\8CC7\6599\6B04\7FA4\7D44\3001\9A57\8B49\4EE5\53CA\503C\6E05\55AE.</li>'),
'</ul></p>',
'',
unistr('<p>\9801\9762\5E95\7AEF\7684\300C\8A3B\89E3\300D\5340\57DF\5C07\6703\986F\793A\8207\76EE\524D\8CC7\6599\5217\95DC\806F\7684\6240\6709\6A94\6848\3001\9644\8A3B\3001\9023\7D50\6216\6A19\8A18.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286384724271874232)
,p_name=>'APEXIR_HELP_WS_CONTROL_BREAK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\4E00\6216\6578\500B\8CC7\6599\6B04\5EFA\7ACB\5206\7D44. \9019\53EF\5C07\8CC7\6599\65B9\683C\7684\8CC7\6599\6B04\986F\793A\70BA\4E3B\8981\8A18\9304.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286332934148874190)
,p_name=>'APEXIR_HELP_WS_DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\8B93\76EE\524D\7684\7D50\679C\96C6\53EF\4F9B\4E0B\8F09, \4E0B\8F09\683C\5F0F'),
unistr('\5305\62EC CSV\3001HTML \6216\96FB\5B50\90F5\4EF6.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286384820283874232)
,p_name=>'APEXIR_HELP_WS_REPORT_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5982\679C\60A8\81EA\8A02\8CC7\6599\65B9\683C\5831\8868, \5831\8868\8A2D\5B9A\503C\6703\986F\793A\5728\300C\641C\5C0B\300D\5217\4E0B\65B9,'),
unistr('\5831\8868\7684\4E0A\65B9. \60A8\53EF\4EE5\4F7F\7528\5DE6\908A\7684\5716\793A\96B1\85CF\53CA\986F\793A\6B64\5340\57DF.'),
'<p>',
unistr('\60A8\53EF\4EE5\5C0D\6BCF\4E00\9805\5831\8868\8A2D\5B9A\57F7\884C\4E0B\5217\4F5C\696D:'),
'</p><ul>',
unistr('<li>\6309\4E00\4E0B\540D\7A31\4F86\7DE8\8F2F\67D0\9805\8A2D\5B9A.</li>'),
unistr('<li>\53D6\6D88\52FE\9078\6216\52FE\9078\300C\555F\7528/\505C\7528\300D\6838\53D6\65B9\584A, \505C\7528/\555F\7528\67D0\9805\8A2D\5B9A. \60A8\53EF\4EE5\4F7F\7528\6B64\63A7\5236\9805\66AB\6642\95DC\9589\53CA\958B\555F\67D0\9805\8A2D\5B9A.</li>'),
unistr('<li>\6309\4E00\4E0B\300C\79FB\9664\300D\5716\793A, \79FB\9664\67D0\9805\8A2D\5B9A.</li>'),
'</ul>',
unistr('<p>\5982\679C\60A8\5DF2\7D93\5EFA\7ACB\5716\8868\6216\7FA4\7D44\4F9D\64DA, \53EF\4EE5\4F7F\7528\53F3\65B9\7684\300C\5831\8868\6AA2\8996\300D\3001'),
unistr('\300C\5716\8868\6AA2\8996\300D\4EE5\53CA\300C\7FA4\7D44\4F9D\64DA\6AA2\8996\300D\9023\7D50, \5728\5B83\5011\8207\57FA\672C\5831\8868\4E4B\9593'),
unistr('\505A\5207\63DB. \5728\6AA2\8996\5716\8868\6216\7FA4\7D44\4F9D\64DA\6642, \4E5F\53EF\4EE5\4F7F\7528\300C\7DE8\8F2F\300D\9023\7D50'),
unistr('\4F86\7DE8\8F2F\8A2D\5B9A\503C.</p>'),
''))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286332885332874190)
,p_name=>'APEXIR_HELP_WS_SAVE_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5132\5B58\81EA\8A02\7684\8CC7\6599\65B9\683C\5831\8868\7248\9762\914D\7F6E, \4F9B\672A\4F86\4F7F\7528. \60A8\9700\8981\63D0\4F9B\540D\7A31\548C\9078\64C7\6027\7684\63CF\8FF0. \60A8\53EF\4EE5\5132\5B58\4E09\7A2E\985E\578B\7684\8CC7\6599\65B9\683C\5831\8868\7248\9762\914D\7F6E:</p>'),
'<ul>',
unistr('<li><strong>\4E3B\8981\9810\8A2D</strong> (\50C5\9650\7BA1\7406\54E1).\300C\4E3B\8981\9810\8A2D\300D\662F\4E00\958B\59CB\986F\793A\7684\7248\9762\914D\7F6E. \300C\4E3B\8981\9810\8A2D\300D\5831\8868\4E0D\53EF\91CD\65B0\547D\540D\6216\52A0\4EE5\522A\9664.</li>'),
unistr('<li><strong>\66FF\4EE3\5831\8868</strong> (\50C5\9650\7BA1\7406\54E1). \53EF\8B93\7BA1\7406\54E1\5EFA\7ACB\591A\500B\5831\8868\7248\9762\914D\7F6E. \53EA\6709\7BA1\7406\54E1\80FD\5920\5132\5B58\3001\91CD\65B0\547D\540D\6216\522A\9664\300C\66FF\4EE3\5831\8868\300D.</li>'),
unistr('<li><strong>\5C08\7528\5831\8868</strong> (\6240\6709\4F7F\7528\8005). \5EFA\7ACB\5831\8868\7248\9762\914D\7F6E\7684\4F7F\7528\8005\53EF\4EE5\6AA2\8996\3001\5132\5B58\3001\91CD\65B0\547D\540D\6216\522A\9664\5831\8868.</li>'),
'</ul>',
unistr('<p>\82E5\60A8\5132\5B58\81EA\8A02\5831\8868, \6703\5728\300C\641C\5C0B\300D\5217\4E2D\300C\8CC7\6599\5217\300D\9078\53D6\5668 (\82E5\555F\7528\6B64\529F\80FD) \7684\5DE6\908A\986F\793A\300C\5831\8868\300D\9078\53D6\5668.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501332041873594)
,p_name=>'APEXIR_HIDE_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413667750873530)
,p_name=>'APEXIR_HIGHLIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505509088873597)
,p_name=>'APEXIR_HIGHLIGHTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531179991873616)
,p_name=>'APEXIR_HIGHLIGHT_CONDITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980786940873931)
,p_name=>'APEXIR_HIGHLIGHT_STYLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254437450873414)
,p_name=>'APEXIR_HIGHLIGHT_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255137822873415)
,p_name=>'APEXIR_HIGHLIGHT_WHEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\793A\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286341353575874196)
,p_name=>'APEXIR_HORIZONTAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C34\5E73')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286444858507874277)
,p_name=>'APEXIR_INACTIVE_SETTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('1 \500B\975E\4F5C\7528\4E2D\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286444999842874277)
,p_name=>'APEXIR_INACTIVE_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \500B\975E\4F5C\7528\4E2D\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490702664873586)
,p_name=>'APEXIR_INTERACTIVE_REPORT_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\52D5\5F0F\5831\8868\8AAA\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532472052873616)
,p_name=>'APEXIR_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285504055660873596)
,p_name=>'APEXIR_INVALID_COMPUTATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\904B\7B97\8868\793A\5F0F. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285201509894873375)
,p_name=>'APEXIR_INVALID_END_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\675F\65E5\671F\5FC5\9808\665A\65BC\958B\59CB\65E5\671F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285650889154873704)
,p_name=>'APEXIR_INVALID_FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\7BE9\9078\8868\793A\5F0F. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377400484874227)
,p_name=>'APEXIR_INVALID_FILTER_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\7BE9\9078\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286445057383874277)
,p_name=>'APEXIR_INVALID_SETTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('1 \500B\7121\6548\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286445183207874277)
,p_name=>'APEXIR_INVALID_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \500B\7121\6548\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285981161341873931)
,p_name=>'APEXIR_IN_MINUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('(\5206\9418)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324240410874183)
,p_name=>'APEXIR_IS_IN_THE_LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\524D %1 \4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324524552874183)
,p_name=>'APEXIR_IS_IN_THE_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5728\5F8C %1 \4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324480345874183)
,p_name=>'APEXIR_IS_NOT_IN_THE_LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\524D %1 \4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324617687874183)
,p_name=>'APEXIR_IS_NOT_IN_THE_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \4E0D\5728\5F8C %1 \4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530233615873615)
,p_name=>'APEXIR_KEYPAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9375\53F0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285472508873437)
,p_name=>'APEXIR_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285498900776873592)
,p_name=>'APEXIR_LABEL_AXIS_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64\7684\5EA7\6A19\8EF8\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846217874873837)
,p_name=>'APEXIR_LABEL_PREFIX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64\524D\7F6E\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417814333873533)
,p_name=>'APEXIR_LAST_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D 1 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418013031873533)
,p_name=>'APEXIR_LAST_HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D 1 \5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417528217873533)
,p_name=>'APEXIR_LAST_MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\500B\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417630723873533)
,p_name=>'APEXIR_LAST_WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417760733873533)
,p_name=>'APEXIR_LAST_X_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417987869873533)
,p_name=>'APEXIR_LAST_X_HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417338508873533)
,p_name=>'APEXIR_LAST_X_YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB %0 \5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417406145873533)
,p_name=>'APEXIR_LAST_YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53BB\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285209878873437)
,p_name=>'APEXIR_LINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6298\7DDA\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257528806873417)
,p_name=>'APEXIR_LINE_WITH_AREA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6298\7DDA\5340\57DF\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285964402849873918)
,p_name=>'APEXIR_MANAGE_SUBSCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\6309\4E00\4E0B<a href=''%0''>\6B64\8655</a>\4F86\7BA1\7406\60A8\7684\8A02\95B1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377317228874227)
,p_name=>'APEXIR_MAP_IT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E6A\88FD\5730\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501981937873594)
,p_name=>'APEXIR_MAX_QUERY_COST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\8A62\9810\4F30\6703\8D85\904E\5141\8A31\7684\8CC7\6E90\4E0A\9650.  \8ACB\4FEE\6539\60A8\7684\5831\8868\8A2D\5B9A\503C, \7136\5F8C\518D\8A66\4E00\6B21.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370173012873499)
,p_name=>'APEXIR_MAX_ROW_CNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\5831\8868\7684\8CC7\6599\5217\6578\76EE\4E0A\9650\70BA %0 \500B\8CC7\6599\5217.  \8ACB\5957\7528\7BE9\9078\4F86\6E1B\5C11\60A8\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377977586874227)
,p_name=>'APEXIR_MAX_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5927\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378124393874228)
,p_name=>'APEXIR_MEDIAN_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E2D\9593\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285383826411873508)
,p_name=>'APEXIR_MIN_AGO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\9418\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378048148874227)
,p_name=>'APEXIR_MIN_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5C0F\503C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376991080874227)
,p_name=>'APEXIR_MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6708\4EFD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285981563070873931)
,p_name=>'APEXIR_MONTHLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6708\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532618115873617)
,p_name=>'APEXIR_MORE_DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497888918873591)
,p_name=>'APEXIR_MOVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497753699873591)
,p_name=>'APEXIR_MOVE_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\79FB\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463221421874290)
,p_name=>'APEXIR_MULTIIR_PAGE_REGION_STATIC_ID_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\5305\542B\591A\500B\4E92\52D5\5F0F\5831\8868, \56E0\6B64\5FC5\9808\6307\5B9A\5340\57DF\975C\614B ID.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256265900873416)
,p_name=>'APEXIR_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487121471873584)
,p_name=>'APEXIR_NEW_AGGREGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\5EFA\805A\7E3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285279494352873433)
,p_name=>'APEXIR_NEW_CATEGORY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \65B0\985E\5225 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286446521053874278)
,p_name=>'APEXIR_NEW_CATEGORY_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\985E\5225')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487238149873584)
,p_name=>'APEXIR_NEW_COMPUTATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\5EFA\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411964814873529)
,p_name=>'APEXIR_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418425584873534)
,p_name=>'APEXIR_NEXT_DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C 1 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418221983873533)
,p_name=>'APEXIR_NEXT_HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C 1 \5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418745830873534)
,p_name=>'APEXIR_NEXT_MONTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\500B\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418630136873534)
,p_name=>'APEXIR_NEXT_WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418518978873534)
,p_name=>'APEXIR_NEXT_X_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C %0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418379438873534)
,p_name=>'APEXIR_NEXT_X_HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C %0 \5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418903866873534)
,p_name=>'APEXIR_NEXT_X_YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F8C %0 \5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285418837970873534)
,p_name=>'APEXIR_NEXT_YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256572312873416)
,p_name=>'APEXIR_NO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532854571873617)
,p_name=>'APEXIR_NONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \7121 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980541777873930)
,p_name=>'APEXIR_NOT_VALID_EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\662F\6709\6548\7684\96FB\5B50\90F5\4EF6\5730\5740.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414759495873531)
,p_name=>'APEXIR_NO_AGGREGATION_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5B9A\7FA9\805A\7E3D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285368935779873498)
,p_name=>'APEXIR_NO_COLUMN_INFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\8CC7\6599\6B04\8CC7\8A0A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414838582873531)
,p_name=>'APEXIR_NO_COMPUTATION_DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5B9A\7FA9\904B\7B97.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376702540874226)
,p_name=>'APEXIR_NO_END_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \6C92\6709\7D50\675F\65E5\671F -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285527970052873613)
,p_name=>'APEXIR_NULLS_ALWAYS_FIRST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\503C\4E00\5F8B\986F\793A\5728\6700\524D\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285527803155873613)
,p_name=>'APEXIR_NULLS_ALWAYS_LAST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\503C\4E00\5F8B\986F\793A\5728\6700\5F8C\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285528816590873614)
,p_name=>'APEXIR_NULL_SORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\503C\6392\5E8F %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285504138980873596)
,p_name=>'APEXIR_NUMERIC_FLASHBACK_TIME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5012\6EAF\6642\9593\5FC5\9808\662F\6578\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285503613652873596)
,p_name=>'APEXIR_NUMERIC_SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9806\5E8F\5FC5\9808\662F\6578\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285529531886873614)
,p_name=>'APEXIR_OPERATOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97\5B50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254989366873415)
,p_name=>'APEXIR_ORANGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A59\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286341206076874196)
,p_name=>'APEXIR_ORIENTATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\5411')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257013190873416)
,p_name=>'APEXIR_OTHER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378407408874228)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_COUNT_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\8A08\6578\767E\5206\6BD4 %0 (%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377689090874227)
,p_name=>'APEXIR_PERCENT_OF_TOTAL_SUM_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\548C\767E\5206\6BD4 %0 (%)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376132439874226)
,p_name=>'APEXIR_PERCENT_TOTAL_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\8A08\6578\767E\5206\6BD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376065004874226)
,p_name=>'APEXIR_PERCENT_TOTAL_SUM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\548C\767E\5206\6BD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285129621873437)
,p_name=>'APEXIR_PIE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5713\9905\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819977416873820)
,p_name=>'APEXIR_PIVOT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A1E\7D10\5206\6790\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847519773873838)
,p_name=>'APEXIR_PIVOT_AGG_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\805A\7E3D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847896020873838)
,p_name=>'APEXIR_PIVOT_AGG_NOT_ON_ROW_COL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\4E0D\80FD\5C0D\88AB\9078\53D6\4F5C\70BA\8CC7\6599\5217\8CC7\6599\6B04\7684\8CC7\6599\6B04\57F7\884C\805A\7E3D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285845327974873837)
,p_name=>'APEXIR_PIVOT_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A1E\7D10\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285845197883873836)
,p_name=>'APEXIR_PIVOT_COLUMN_N'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A1E\7D10\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847326285873838)
,p_name=>'APEXIR_PIVOT_COLUMN_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\6A1E\7D10\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285086131293873291)
,p_name=>'APEXIR_PIVOT_MAX_ROW_CNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\6A1E\7D10\5206\6790\8868\300D\67E5\8A62\7684\8CC7\6599\5217\8A08\6578\4E0A\9650\9650\5236\7684\662F\57FA\790E\67E5\8A62\4E2D\7684\8CC7\6599\5217\6578\76EE, \800C\4E0D\662F\9650\5236\986F\793A\7684\8CC7\6599\5217\6578\76EE. \60A8\7684\57FA\790E\67E5\8A62\8D85\51FA\8CC7\6599\5217\8A08\6578\4E0A\9650 (%0 \500B\8CC7\6599\5217). \8ACB\5957\7528\7BE9\9078\4EE5\6E1B\5C11\60A8\57FA\790E\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286459122623874287)
,p_name=>'APEXIR_PIVOT_ROW_COLUMN_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\9078\53D6\5176\4ED6\8CC7\6599\5217\8CC7\6599\6B04.  \6B64\8CC7\6599\5217\8CC7\6599\6B04\4E2D\7684 HTML \8868\793A\5F0F\6216\9023\7D50\5305\542B\5B9A\7FA9\70BA\6A1E\7D10\5206\6790\8868\6216\805A\7E3D\8CC7\6599\6B04\7684\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846306698873837)
,p_name=>'APEXIR_PIVOT_SORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A1E\7D10\5206\6790\8868\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980618572873930)
,p_name=>'APEXIR_PREVIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285412061164873529)
,p_name=>'APEXIR_PREVIOUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286375003555874225)
,p_name=>'APEXIR_PRIMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285984363193873933)
,p_name=>'APEXIR_PRIMARY_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285644882058873699)
,p_name=>'APEXIR_PRIVATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C08\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285286515627873438)
,p_name=>'APEXIR_PUBLIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\516C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256880619873416)
,p_name=>'APEXIR_RED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D05\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286463118618874290)
,p_name=>'APEXIR_REGION_STATIC_ID_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\975C\614B ID %0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497990916873592)
,p_name=>'APEXIR_REMOVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285411015019873528)
,p_name=>'APEXIR_REMOVE_AGGREGATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\805A\7E3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285498092573873592)
,p_name=>'APEXIR_REMOVE_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286445256948874277)
,p_name=>'APEXIR_REMOVE_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497380914873591)
,p_name=>'APEXIR_REMOVE_CONTROL_BREAK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\63A7\5236\5206\6BB5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497007207873591)
,p_name=>'APEXIR_REMOVE_FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497196315873591)
,p_name=>'APEXIR_REMOVE_FLASHBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\5012\6EAF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286445377965874277)
,p_name=>'APEXIR_REMOVE_GROUP_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\7FA4\7D44\4F9D\64DA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497428904873591)
,p_name=>'APEXIR_REMOVE_HIGHLIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\6A19\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286445466517874277)
,p_name=>'APEXIR_REMOVE_PIVOT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\6A1E\7D10\5206\6790\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286386662710874234)
,p_name=>'APEXIR_REMOVE_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286265583310874140)
,p_name=>'APEXIR_RENAME_DEFAULT_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\547D\540D\9810\8A2D\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285533207554873617)
,p_name=>'APEXIR_RENAME_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\547D\540D\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285412594384873529)
,p_name=>'APEXIR_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286378506881874228)
,p_name=>'APEXIR_REPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246015611873408)
,p_name=>'APEXIR_REPORT_ALIAS_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5225\540D\70BA %0 \7684\300C\9810\5B58\4E92\52D5\5F0F\300D\5831\8868\4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285795448180873803)
,p_name=>'APEXIR_REPORT_DISPLAY_COLUMN_LIMIT_REACHED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\4E2D\986F\793A\8CC7\6599\6B04\7684\6578\76EE\5DF2\9054\4E0A\9650. \8ACB\6309\4E00\4E0B\300C\52D5\4F5C\300D\529F\80FD\8868\4E0B\7684\300C\9078\53D6\8CC7\6599\6B04\300D, \5C07\5831\8868\986F\793A\8CC7\6599\6B04\6E05\55AE\6700\5C0F\5316.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285648186453873702)
,p_name=>'APEXIR_REPORT_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246183527873408)
,p_name=>'APEXIR_REPORT_ID_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\9810\5B58\4E92\52D5\5F0F\5831\8868\300DID %0 \4E0D\5B58\5728.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285530983348873615)
,p_name=>'APEXIR_REPORT_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285384309531873509)
,p_name=>'APEXIR_REPORT_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414196136873530)
,p_name=>'APEXIR_RESET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8A2D')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285286707701873438)
,p_name=>'APEXIR_RESET_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\5831\8868\56DE\5FA9\6210\9810\8A2D\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256634725873416)
,p_name=>'APEXIR_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286370807419874222)
,p_name=>'APEXIR_ROWID_NOT_SUPPORTED_FOR_WEBSOURCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\4E0D\80FD\4F7F\7528 ROWID \4F5C\70BA Web \4F86\6E90\7684\4E3B\7D22\5F15\9375\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285496058780873590)
,p_name=>'APEXIR_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285989778416873937)
,p_name=>'APEXIR_ROWS_PER_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\9801\8CC7\6599\5217\6578')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285845477090873837)
,p_name=>'APEXIR_ROW_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285845237034873837)
,p_name=>'APEXIR_ROW_COLUMN_N'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847473736873838)
,p_name=>'APEXIR_ROW_COLUMN_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\8CC7\6599\5217\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847665670873838)
,p_name=>'APEXIR_ROW_COL_DIFF_FROM_PIVOT_COL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\8CC7\6599\6B04\5FC5\9700\8207\6A1E\7D10\8CC7\6599\6B04\4E0D\540C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285592768417873662)
,p_name=>'APEXIR_ROW_FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285384462964873509)
,p_name=>'APEXIR_ROW_OF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C %0 \500B\8CC7\6599\5217, \5171 %1 \500B\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285383644372873508)
,p_name=>'APEXIR_ROW_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285415628497873532)
,p_name=>'APEXIR_ROW_TEXT_CONTAINS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\6587\5B57\5305\542B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106017478873305)
,p_name=>'APEXIR_RPT_DISP_COL_EXCEED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\4E2D\986F\793A\8CC7\6599\6B04\7684\6578\76EE\5DF2\9054\4E0A\9650. \8ACB\6309\4E00\4E0B\300C\52D5\4F5C\300D\529F\80FD\8868\4E0B\7684\300C\9078\53D6\8CC7\6599\6B04\300D, \5C07\5831\8868\986F\793A\8CC7\6599\6B04\6E05\55AE\6700\5C0F\5316.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255808809873415)
,p_name=>'APEXIR_SAVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505738360873597)
,p_name=>'APEXIR_SAVED_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\5B58\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505667896873597)
,p_name=>'APEXIR_SAVED_REPORT_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\5B58\5831\8868 = "%0"')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414523180873531)
,p_name=>'APEXIR_SAVE_AS_DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53E6\5B58\70BA\9810\8A2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285527153299873613)
,p_name=>'APEXIR_SAVE_DEFAULT_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\5831\8868\8A2D\5B9A\503C\5C07\6210\70BA\6240\6709\4F7F\7528\8005\7684\9810\8A2D\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286265424348874140)
,p_name=>'APEXIR_SAVE_DEFAULT_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\9810\8A2D\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414037311873530)
,p_name=>'APEXIR_SAVE_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\5831\8868')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286446492489874278)
,p_name=>'APEXIR_SAVE_REPORT_DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\5831\8868 *')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286001363179873945)
,p_name=>'APEXIR_SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285490673487873586)
,p_name=>'APEXIR_SEARCH_BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286446312136874278)
,p_name=>'APEXIR_SEARCH_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B: %0')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286050681878873981)
,p_name=>'APEXIR_SEARCH_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\5831\8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285962245216873917)
,p_name=>'APEXIR_SELECTED_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\7684\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256199105873416)
,p_name=>'APEXIR_SELECT_CATEGORY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\985E\5225 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257709285873417)
,p_name=>'APEXIR_SELECT_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\8CC7\6599\6B04 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413367042873530)
,p_name=>'APEXIR_SELECT_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285533063590873617)
,p_name=>'APEXIR_SELECT_COLUMNS_FOOTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D93\904E\904B\7B97\7684\8CC7\6599\6B04\524D\9762\6703\52A0\4E0A **.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285926694873437)
,p_name=>'APEXIR_SELECT_FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\51FD\6578 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285495412632873590)
,p_name=>'APEXIR_SELECT_GROUP_BY_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \4F9D\8CC7\6599\6B04\9078\53D6\7FA4\7D44 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285844966719873836)
,p_name=>'APEXIR_SELECT_PIVOT_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\6A1E\7D10\8CC7\6599\6B04 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377580253874227)
,p_name=>'APEXIR_SELECT_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285845038769873836)
,p_name=>'APEXIR_SELECT_ROW_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\8CC7\6599\5217\8CC7\6599\6B04 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376310748874226)
,p_name=>'APEXIR_SELECT_SORT_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('-  \9078\53D6\6392\5E8F\8CC7\6599\6B04 -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532503623873617)
,p_name=>'APEXIR_SELECT_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285095851934873298)
,p_name=>'APEXIR_SEND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256323038873416)
,p_name=>'APEXIR_SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413594774873530)
,p_name=>'APEXIR_SORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501128720873594)
,p_name=>'APEXIR_SORT_ASCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\589E\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376250329874226)
,p_name=>'APEXIR_SORT_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501273796873594)
,p_name=>'APEXIR_SORT_DESCENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\905E\6E1B\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286385840305874233)
,p_name=>'APEXIR_SORT_ORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285486701447873583)
,p_name=>'APEXIR_SPACE_AS_IN_ONE_EMPTY_STRING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\683C\9375')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285529809448873615)
,p_name=>'APEXIR_STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\72C0\614B %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285981232679873931)
,p_name=>'APEXIR_SUBSCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A02\95B1')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376622063874226)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\675F\65BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285962155757873917)
,p_name=>'APEXIR_SUBSCRIPTION_ENDING_UNIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\55AE\4F4D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286376538149874226)
,p_name=>'APEXIR_SUBSCRIPTION_STARTING_FROM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\59CB\65BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377724411874227)
,p_name=>'APEXIR_SUM_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\548C %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327015749874185)
,p_name=>'APEXIR_TABLE_SUMMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF = %0, \5831\8868 = %1, \6AA2\8996 = %2, \986F\793A\7684\8CC7\6599\5217\958B\982D = %3, \986F\793A\7684\8CC7\6599\5217\7D50\5C3E = %4, \8CC7\6599\5217\7E3D\6578 = %5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285437113893873547)
,p_name=>'APEXIR_TABLE_SUMMARY_NO_TOTAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF = %0, \5831\8868 = %1, \6AA2\8996 = %2, \986F\793A\7684\8CC7\6599\5217\958B\982D = %3, \986F\793A\7684\8CC7\6599\5217\7D50\5C3E = %4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285255061710873415)
,p_name=>'APEXIR_TEXT_COLOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57\8272\5F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370721874873499)
,p_name=>'APEXIR_TIME_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370625888873499)
,p_name=>'APEXIR_TIME_HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370584790873499)
,p_name=>'APEXIR_TIME_MINS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\9418')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370966161873499)
,p_name=>'APEXIR_TIME_MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285370875609873499)
,p_name=>'APEXIR_TIME_WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285371068341873499)
,p_name=>'APEXIR_TIME_YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286386428865874234)
,p_name=>'APEXIR_TOGGLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5207\63DB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285498191322873592)
,p_name=>'APEXIR_TOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9802\7AEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531314388873616)
,p_name=>'APEXIR_UNAUTHORIZED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6388\6B0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286360222598874214)
,p_name=>'APEXIR_UNGROUPED_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5206\7D44\7684\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285503816560873596)
,p_name=>'APEXIR_UNIQUE_COLUMN_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\8CC7\6599\6B04\6A19\984C\300D\5FC5\9808\662F\552F\4E00\7684.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285503500463873596)
,p_name=>'APEXIR_UNIQUE_HIGHLIGHT_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\6A19\793A\540D\7A31\300D\5FC5\9808\662F\552F\4E00\7684.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285284233979873436)
,p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\652F\63F4\7684\8CC7\6599\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285498273772873592)
,p_name=>'APEXIR_UP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5411\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285503710952873596)
,p_name=>'APEXIR_VALID_COLOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\8F38\5165\6709\6548\7684\8272\5F69.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285503925533873596)
,p_name=>'APEXIR_VALID_FORMAT_MASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\8F38\5165\6709\6548\7684\683C\5F0F\906E\7F69.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285257183448873416)
,p_name=>'APEXIR_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285499032358873592)
,p_name=>'APEXIR_VALUE_AXIS_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\7684\5EA7\6A19\8EF8\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285532388673873616)
,p_name=>'APEXIR_VALUE_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\8F38\5165\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285285021383873437)
,p_name=>'APEXIR_VCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5782\76F4\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286341454929874196)
,p_name=>'APEXIR_VERTICAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5782\76F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531553057873616)
,p_name=>'APEXIR_VIEW_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286030410023873967)
,p_name=>'APEXIR_VIEW_DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\8A73\7D30\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286449545624874280)
,p_name=>'APEXIR_VIEW_DOES_NOT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\672A\5B9A\7FA9 %0 \6AA2\8996.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286030551081873967)
,p_name=>'APEXIR_VIEW_GROUP_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\7FA4\7D44\4F9D\64DA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286030354618873967)
,p_name=>'APEXIR_VIEW_ICONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\5716\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285844727248873836)
,p_name=>'APEXIR_VIEW_PIVOT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\6A1E\7D10\5206\6790\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285531686603873616)
,p_name=>'APEXIR_VIEW_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377109950874227)
,p_name=>'APEXIR_WEEK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285981444288873931)
,p_name=>'APEXIR_WEEKLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9031\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285412471260873529)
,p_name=>'APEXIR_WORKING_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379354682874228)
,p_name=>'APEXIR_X_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379280650874228)
,p_name=>'APEXIR_X_HOURS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5C0F\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379101523874228)
,p_name=>'APEXIR_X_MINS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5206\9418')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379539122874229)
,p_name=>'APEXIR_X_MONTHS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \500B\6708')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379452958874228)
,p_name=>'APEXIR_X_WEEKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \9031')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379624383874229)
,p_name=>'APEXIR_X_YEARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5E74')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286377004568874227)
,p_name=>'APEXIR_YEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E74\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254778389873415)
,p_name=>'APEXIR_YELLOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9EC3\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285256461305873416)
,p_name=>'APEXIR_YES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285103102156873303)
,p_name=>'APEX_ADMIN_SERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Application Express \7BA1\7406\670D\52D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286325685842874184)
,p_name=>'APEX_AUTHENTICATION.NOT_CONFIGURED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\66FF\6B64\61C9\7528\7A0B\5F0F\8A2D\5B9A\8A8D\8B49.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285498800322873592)
,p_name=>'APEX_GROUP.SESSION_STATE.RESTRICTED_CHAR.WEB_SAFE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5305\542B < \6216 > \7121\6548\5B57\5143.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285716052998873749)
,p_name=>'APEX_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285572789088873646)
,p_name=>'APEX_SAMPLE_LOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\5217\8CC7\6599\5EAB\7269\4EF6\5C07%0\81F3\9078\53D6\7684\7DB1\8981\4E2D:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285572832558873646)
,p_name=>'APEX_SAMPLE_LOAD_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229%0\4E0B\5217\8CC7\6599\5EAB\7269\4EF6:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286060741208873988)
,p_name=>'APEX_SCROLL_DOWN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5411\4E0B\6372\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286060834121873989)
,p_name=>'APEX_SCROLL_TO_TOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6372\52D5\81F3\9802\7AEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285108718374873307)
,p_name=>'APEX_WIZARD_FORM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8868\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286325162154874184)
,p_name=>'APEX_WS_EDIT_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285743677438873768)
,p_name=>'APEX_WS_INVALID_OBJECTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286383574390874232)
,p_name=>'APEX_WS_NO_PEER_PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\5C0D\7B49\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286328494630874186)
,p_name=>'APEX_WS_SETUP_CREATE_OBJ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\5EFA\7ACB\7684\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286328626877874186)
,p_name=>'APEX_WS_SETUP_DELETE_TABLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8868\683C\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286328816716874187)
,p_name=>'APEX_WS_SETUP_DROP_OBJECTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991523037873938)
,p_name=>'APEX_WS_SETUP_DROP_TABLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285990874724873938)
,p_name=>'APEX_WS_SETUP_MSG1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\5728 <b>%0</b> \7DB1\8981\4E2D\5EFA\7ACB\9019\4E9B\7269\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286328913869874187)
,p_name=>'APEX_WS_SETUP_MSG10'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<b>%0</b> \7DB1\8981\4E2D\5DF2\6709\9019\4E9B\7269\4EF6\5B58\5728, \4E14\7531\5176\4ED6\5DE5\4F5C\5340\4F7F\7528. \82E5\7E7C\7E8C\7684\8A71, \6703\540C\6642\5C07 <b>%0</b> \64C1\6709\7684\73FE\6709\300CWeb \8A66\7B97\8868\300D\7269\4EF6\8207\6B64\5DE5\4F5C\5340\95DC\806F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286329067836874187)
,p_name=>'APEX_WS_SETUP_MSG11'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\9078\53D6\7528\65BC\9019\4E9B\7269\4EF6\7684\7DB1\8981:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286329172053874187)
,p_name=>'APEX_WS_SETUP_MSG12'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\4F7F\7528\7684\73FE\6709\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286330075962874188)
,p_name=>'APEX_WS_SETUP_MSG13'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\4F7F\7528\4E0B\5217\8CC7\8A0A\91CD\8907\4F7F\7528\300CWeb \8A66\7B97\8868\300D\8CC7\6599\5EAB\7269\4EF6.  \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285990960873873938)
,p_name=>'APEX_WS_SETUP_MSG2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\82E5\8981\65B0\7DB1\8981\4E2D\5EFA\7ACB\300CWeb \8A66\7B97\8868\300D\7269\4EF6, \8ACB\4F7F\7528<a href=%0>\8981\6C42\8CC7\6599\5EAB\7DB1\8981</a>\7CBE\9748.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991013554873938)
,p_name=>'APEX_WS_SETUP_MSG3'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\300CWeb \8A66\7B97\8868\300D\9700\8981\4E0B\5217\7269\4EF6:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991150458873938)
,p_name=>'APEX_WS_SETUP_MSG5'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\4F7F\7528\4E0B\5217\8CC7\8A0A\5EFA\7ACB Web \8A66\7B97\8868\8CC7\6599\5EAB\7269\4EF6.  \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991255597873938)
,p_name=>'APEX_WS_SETUP_MSG6'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\5EFA\7ACB\7684\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991370048873938)
,p_name=>'APEX_WS_SETUP_MSG7'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\79FB\9664\300CWeb \8A66\7B97\8868\300D\8CC7\6599\5EAB\7269\4EF6.  \9019\5C07\6703\522A\9664\300CWeb \8A66\7B97\8868\300D\8CC7\6599\5EAB\7269\4EF6\4EE5\53CA\5305\542B\60A8\5DE5\4F5C\5340\4E2D\300CWeb \8A66\7B97\8868\300D\5143\4EF6\7684\5167\90E8\8CC7\6599.  \8981\7E7C\7E8C\55CE?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991689387873938)
,p_name=>'APEX_WS_SETUP_MSG8'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\66F4\6B63\4E0B\5217\7121\6548\7684\7269\4EF6, \624D\80FD\6B63\78BA\57F7\884C\300CWeb \8A66\7B97\8868\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286328579664874186)
,p_name=>'APEX_WS_SETUP_MSG9'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\79FB\9664\6B64\5DE5\4F5C\5340\7684\300CWeb \8A66\7B97\8868\300D\5B9A\7FA9. \5C07\4E0D\6703\522A\9664\5176\4ED6\5DE5\4F5C\5340\4E5F\4F7F\7528\7684\300CWeb \8A66\7B97\8868\300D\8CC7\6599\5EAB\7269\4EF6. \5C07\6703\522A\9664\8207\6B64\5DE5\4F5C\5340\95DC\806F\7684\8A18\9304. \8981\7E7C\7E8C\55CE?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991717121873938)
,p_name=>'APEX_WS_SETUP_OBJECT_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7269\4EF6\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991893834873939)
,p_name=>'APEX_WS_SETUP_OBJECT_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7269\4EF6\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285991419771873938)
,p_name=>'APEX_WS_SETUP_SCHEMA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DB1\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286328337530874186)
,p_name=>'APEX_WS_SETUP_USE_EXISTING_OBJ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\4F7F\7528\7684\73FE\6709\7269\4EF6')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285120092248873316)
,p_name=>'API_PRECONDITION_VIOLATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9055\53CD API \5148\6C7A\689D\4EF6')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285278341084873432)
,p_name=>'APP.SETTING.CANNOT.GET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\53D6\5F97\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C %0 \7684\503C, \56E0\70BA\95DC\806F\7684\7D44\5EFA\9078\9805\5DF2\505C\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285278220318873432)
,p_name=>'APP.SETTING.CANNOT.SET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\8A2D\5B9A\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C %0 \7684\503C, \56E0\70BA\95DC\806F\7684\7D44\5EFA\9078\9805\5DF2\505C\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286355046910874209)
,p_name=>'APP.SETTING.INVALID.VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8A2D\5B9A %0 \503C\7121\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354978700874209)
,p_name=>'APP.SETTING.NOT.DEFINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5B9A\7FA9\8981\6C42\7684\61C9\7528\7A0B\5F0F\8A2D\5B9A %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286355123890874209)
,p_name=>'APP.SETTING.VALUE.NOT.NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8A2D\5B9A %0 \4E0D\53EF\8A2D\70BA\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285171407925873353)
,p_name=>'APPLICACTION_COMPUTATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285171365619873353)
,p_name=>'APPLICACTION_PROCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8655\7406\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285736609187873764)
,p_name=>'APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285816878083873818)
,p_name=>'APPLICATION BUILDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285641321093873697)
,p_name=>'APPLICATION COMPUTATION CONDITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\904B\7B97\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285644004275873699)
,p_name=>'APPLICATION IMAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5F71\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285641473507873697)
,p_name=>'APPLICATION PROCESS CONDITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8655\7406\4F5C\696D\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285568130263873642)
,p_name=>'APPLICATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285713840456873748)
,p_name=>'APPLICATIONS_INITCAP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285614190537873677)
,p_name=>'APPLICATION_ACTIVITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\6D3B\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285654648817873706)
,p_name=>'APPLICATION_ALIAS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285652656139873705)
,p_name=>'APPLICATION_DELETED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\522A\9664\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285102823462873303)
,p_name=>'APPLICATION_DEVELOPMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\958B\767C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285653649045873706)
,p_name=>'APPLICATION_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285610792766873675)
,p_name=>'APPLICATION_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7DE8\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500085045873593)
,p_name=>'APPLICATION_ID_RESERVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4FDD\7559\7684\300C\61C9\7528\7A0B\5F0F ID\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285499926247873593)
,p_name=>'APPLICATION_ID_VALIDATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\61C9\7528\7A0B\5F0F ID\300D\5FC5\9808\662F\6B63\6574\6578.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286032168266873968)
,p_name=>'APPLICATION_IMAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5F71\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285683945516873728)
,p_name=>'APPLICATION_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285200469025873374)
,p_name=>'APPLICATION_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285165812622873349)
,p_name=>'APPLICATION_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285654510073873706)
,p_name=>'APPLICATION_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286383153315874231)
,p_name=>'APPLICATION_NAMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285776984606873791)
,p_name=>'APPLICATION_OVERRIDE_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8986\5BEB ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285652128033873705)
,p_name=>'APPLICATION_OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286383077577874231)
,p_name=>'APPLICATION_PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285288574638873439)
,p_name=>'APPLICATION_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285652318689873705)
,p_name=>'APPLICATION_STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285738658599873765)
,p_name=>'APPLICATION_VERSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7248\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118435929873314)
,p_name=>'APPLICATION_X'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285597993048873666)
,p_name=>'APPROVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6838\51C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285658890212873710)
,p_name=>'APP_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5EFA\7ACB\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286385781584874233)
,p_name=>'APP_TEMPLATE_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A23\677F\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285152826196873339)
,p_name=>'APP_TYPE_DATABASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285152982364873339)
,p_name=>'APP_TYPE_PACKAGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\751F\7522\529B\6216\7BC4\4F8B\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285680302307873725)
,p_name=>'APP_TYPE_PACKAGED_WS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\4F8B Web \8A66\7B97\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285152757429873339)
,p_name=>'APP_TYPE_WEBSHEET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \8A66\7B97\8868\61C9\7528\7A0B\5F0F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285597440934873665)
,p_name=>'ARCHIVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5B58\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285166194795873349)
,p_name=>'ARCHIVELOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\8A8C\5B58\6A94\529F\80FD: \958B\555F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285417088540873533)
,p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F15\6578\5FC5\9808\8981\6709\7E3D\548C\6AA2\9A57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285512841668873602)
,p_name=>'ARGUMENT_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F15\6578\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285513032562873603)
,p_name=>'ARGUMENT_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F15\6578\985E\578B')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285591330667873661)
,p_name=>'ASAP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5118\5FEB')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285587936859873658)
,p_name=>'ASSIGNED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6307\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285286195515873438)
,p_name=>'ASSIGNEE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\5C0D\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286410621957874252)
,p_name=>'ASSIGN_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285346722513873481)
,p_name=>'ASSOCIATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\95DC\7684')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285288028509873439)
,p_name=>'ASSOCIATED_FEATURES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\95DC\529F\80FD')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285619382749873681)
,p_name=>'ATTACHMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\4EF6')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286427070178874264)
,p_name=>'AT_RISK_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5177\98A8\96AA')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316688470873460)
,p_name=>'AUTH.CONFIRM_MIGRATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\5C07\6B64\61C9\7528\7A0B\5F0F\7684\81EA\8A02\8A8D\8B49\9078\9805\79FB\8F49\81F3\8A8D\8B49\914D\7F6E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316171740873459)
,p_name=>'AUTH.CURRENT_AUTH_METHOD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\8A8D\8B49\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316523251873460)
,p_name=>'AUTH.CUSTOM_AUTH_FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02\8A8D\8B49\51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316281040873459)
,p_name=>'AUTH.LOGIN_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\767B\5165\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316474126873459)
,p_name=>'AUTH.LOGIN_URL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\767B\5165 URL')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316387603873459)
,p_name=>'AUTH.NONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285321705870873463)
,p_name=>'AUTHENTICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285642377861873698)
,p_name=>'AUTHENTICATION FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49\51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285642037924873697)
,p_name=>'AUTHENTICATION SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285336897823873474)
,p_name=>'AUTHENTICATION.CONFIRM_DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\522A\9664\61C9\7528\7A0B\5F0F %0 \7684\67D0\4E00\500B\8A8D\8B49\914D\7F6E. \5982\679C\61C9\7528\7A0B\5F0F\76EE\524D\4E0D\662F\4F7F\7528 SCHEME \8A8D\8B49, \6216\8005\914D\7F6E\4E0D\662F\76EE\524D\7684\8A8D\8B49\914D\7F6E, \5247\522A\9664\914D\7F6E\5C0D\61C9\7528\7A0B\5F0F\4F5C\696D\5C07\7121\5F71\97FF. \5982\679C\61C9\7528\7A0B\5F0F\76EE\524D\4F7F\7528 SCHEME \8A8D\8B49, \4E26\4E14\9019\662F\76EE\524D\7684\8A8D\8B49\914D\7F6E, \90A3\9EBC\61C9\7528\7A0B\5F0F\5C07\6703\7E7C\7E8C\4F7F\7528 SCHEME \8A8D\8B49\57F7\884C, \4F46\662F\6709\4E00\500B\9810\8A2D\8A8D\8B49\914D\7F6E. \9019\5C07\6703\4F7F\7528\4EE5 Open Door \8B49\660E\8CC7\6599\9A57\8B49\7684\5167\5EFA\767B\5165\9801\9762 (\4EA6\5373, \4EFB\4F55\4EBA\90FD\80FD\57F7\884C\61C9\7528\7A0B\5F0F). ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338729437873476)
,p_name=>'AUTHENTICATION.MAKE_CURRENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4E00\4E0B\300C\8B8A\6210\76EE\524D\7684\300D\6309\9215, \8B93\60A8\7684\61C9\7528\7A0B\5F0F\4F7F\7528\6B64\8A8D\8B49\914D\7F6E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846632958873838)
,p_name=>'AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Application Express \5E33\6236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285099468635873300)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846749104873838)
,p_name=>'AUTHENTICATION_NAME.NATIVE_CUSTOM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847065276873838)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846866279873838)
,p_name=>'AUTHENTICATION_NAME.NATIVE_DB_ACCOUNTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\5E33\6236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280094360874151)
,p_name=>'AUTHENTICATION_NAME.NATIVE_HTTP_HEADER_VARIABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTTP \6A19\982D\8B8A\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847271898873838)
,p_name=>'AUTHENTICATION_NAME.NATIVE_IAS_SSO'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Application Server Single Sign-On'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285846943984873838)
,p_name=>'AUTHENTICATION_NAME.NATIVE_LDAP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('LDAP \76EE\9304')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847102970873838)
,p_name=>'AUTHENTICATION_NAME.NATIVE_OPEN_DOOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Open Door \8B49\660E\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285089651830873293)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SAML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SAML \767B\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285128142302873321)
,p_name=>'AUTHENTICATION_NAME.NATIVE_SOCIAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\793E\7FA4\767B\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285685063340873728)
,p_name=>'AUTHENTICATION_SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285641925647873697)
,p_name=>'AUTHORIZATION SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6388\6B0A\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285099556530873300)
,p_name=>'AUTHORIZATION_NAME.NATIVE_CLOUD_IDM'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118646476873314)
,p_name=>'AUTHORIZATION_NAME.NATIVE_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Exists SQL \67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118725390873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_FUNCTION_BODY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\56DE\5E03\6797\503C\7684 PL/SQL \51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285495869558873590)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_IN_GROUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\89D2\8272\6216\7FA4\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285495911916873590)
,p_name=>'AUTHORIZATION_NAME.NATIVE_IS_NOT_IN_GROUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\4F7F\7528\89D2\8272\6216\7FA4\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118859282873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_EQUALS_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F 1 \4E2D\7684\9805\76EE\503C\7B49\65BC\8868\793A\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118998961873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F 1 \4E2D\7684\9805\76EE\4E0D\662F\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285119000433873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_IS_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F 1 \4E2D\7684\9805\76EE\662F\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285119194777873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_ITEM_NOT_EQUALS_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F 1 \4E2D\7684\9805\76EE\503C\4E0D\7B49\65BC\8868\793A\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285119232083873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('NOT Exists SQL \67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285119347702873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_EQUALS_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F 1 \7684\504F\597D\8A2D\5B9A\503C\7B49\65BC\8868\793A\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285119468884873315)
,p_name=>'AUTHORIZATION_NAME.NATIVE_PREF_NOT_EQUALS_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\793A\5F0F 1 \7684\504F\597D\8A2D\5B9A\503C\4E0D\7B49\65BC\8868\793A\5F0F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285184452473873363)
,p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A55\4F30\6BCF\4E00\500B\9801\9762\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285184536043873363)
,p_name=>'AUTHZ_CACHE_PER_SESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\4E00\500B\968E\6BB5\4F5C\696D\8A55\4F30\4E00\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285121804313873317)
,p_name=>'AUTH_ACCOUNT_EXPIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E33\6236\5931\6548')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285121742781873317)
,p_name=>'AUTH_ACCOUNT_LOCKED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E33\6236\5DF2\9396\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122112586873317)
,p_name=>'AUTH_ATTEMPTS_EXCEEDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8D85\904E\767B\5165\5617\8A66\6B21\6578\4E0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122261638873317)
,p_name=>'AUTH_INTERNAL_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\660E\7684\5167\90E8\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122048475873317)
,p_name=>'AUTH_PASSWORD_FIRST_USE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C\4E00\6B21\4F7F\7528\5BC6\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285121923364873317)
,p_name=>'AUTH_PASSWORD_INCORRECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\78BC\4E0D\6B63\78BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285121511915873317)
,p_name=>'AUTH_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\5E38, \9806\5229\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285121624064873317)
,p_name=>'AUTH_UNKNOWN_USER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\660E\7684\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285236467916873401)
,p_name=>'AUTH_UNKNOWN_WORKSPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\660E\7684\5DE5\4F5C\5340\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246992780873409)
,p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\660E\7684\5DE5\4F5C\5340\540D\7A31: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285390780493873514)
,p_name=>'AUTOCOMMIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\78BA\8A8D\300D\6558\8FF0\53E5\4E0D\9069\7528, \6703\81EA\52D5\78BA\8A8D\6240\6709\6558\8FF0\53E5.')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285714483338873748)
,p_name=>'AUTOPROVISION_MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F48\5EFA\6A21\5F0F')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285097139861873299)
,p_name=>'AUTO_FIRST_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C\4E00\500B\9805\76EE')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285740337402873766)
,p_name=>'AVAILABILITY_INIT_CAP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\7528\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285126710276873320)
,p_name=>'AVAILABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285944077760873903)
,p_name=>'AVAILABLE_TO_DEVELOPERS_ONLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EA\6709\958B\767C\4EBA\54E1\53EF\4EE5\4F7F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285943980799873903)
,p_name=>'AVAILABLE_WITH_EDIT_LINKS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\900F\904E\958B\767C\4EBA\54E1\5DE5\5177\5217\63D0\4F9B\4F7F\7528')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285614950383873678)
,p_name=>'AVERAGE_RENDER_TIME_SECONDS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E73\5747\5448\73FE\6642\9593 (\79D2)')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285185221274873363)
,p_name=>'BACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285595871792873664)
,p_name=>'BAR_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9577\689D\5716')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286017593082873957)
,p_name=>'BASIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57FA\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285140581793873330)
,p_name=>'BASIC_DEVELOPER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57FA\672C\958B\767C\4EBA\54E1')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575161297873647)
,p_name=>'BEFORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E4B\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286388449226874235)
,p_name=>'BEFORE LIST ENTRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\55AE\9805\76EE\4E4B\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286409327205874251)
,p_name=>'BEFORE_FIRST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C\4E00\500B\4E4B\524D')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285645281864873700)
,p_name=>'BIND_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285644519155873699)
,p_name=>'BIND_VARIABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50\8B8A\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285644677198873699)
,p_name=>'BIND_VARIABLE_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50\8B8A\6578\6A19\7C64')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285660415568873711)
,p_name=>'BLACK_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9ED1\8272\6587\5B57')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285103979167873304)
,p_name=>'BLANK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\767D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285618547170873680)
,p_name=>'BLOB_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('BLOB \8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285778670140873792)
,p_name=>'BLOB_DOWNLOAD_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\8F09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285155682593873341)
,p_name=>'BLOB_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Blob \683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285779004413873792)
,p_name=>'BLOB_FORMAT_ATTACHMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285778716281873792)
,p_name=>'BLOB_FORMAT_DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>'DOWNLOAD'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285778814248873792)
,p_name=>'BLOB_FORMAT_IMAGE'
,p_message_language=>'zh-tw'
,p_message_text=>'IMAGE'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285778941891873792)
,p_name=>'BLOB_FORMAT_INLINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5167\5D4C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285619593846873681)
,p_name=>'BLOB_FORMAT_MASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('BLOB \683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285619070663873681)
,p_name=>'BLOB_LAST_UPDATED_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('BLOB \4E0A\6B21\66F4\65B0\6642\9593\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285618456937873680)
,p_name=>'BLOB_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('BLOB \8868\683C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285660336749873711)
,p_name=>'BLUE_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\85CD\8272\6587\5B57')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285635572216873693)
,p_name=>'BRANCH CONDITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\652F\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285188874690873366)
,p_name=>'BRANCHES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\652F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285412967410873530)
,p_name=>'BREADCRUMB'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575872757873648)
,p_name=>'BREADCRUMB LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575915029873648)
,p_name=>'BREADCRUMB LONG NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\5B8C\6574\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285413024406873530)
,p_name=>'BREADCRUMBS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285668958470873717)
,p_name=>'BREADCRUMB_ENTRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285684125899873728)
,p_name=>'BREADCRUMB_ENTRY_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\9805\76EE: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500261100873593)
,p_name=>'BREADCRUMB_PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285584047834873656)
,p_name=>'BREADCRUMB_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285249217460873411)
,p_name=>'BREADCRUMB_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5EFA\7ACB\5C0E\89BD\8DEF\5F91.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285578444242873652)
,p_name=>'BROWSE_ICON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\5716\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285578257996873651)
,p_name=>'BROWSE_PACKAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\5957\88DD\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285512525435873602)
,p_name=>'BROWSE_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\8868\683C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285107271034873306)
,p_name=>'BUFFER CACHE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE9\885D\5340\5FEB\53D6')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285591819195873661)
,p_name=>'BUG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285616062021873679)
,p_name=>'BUGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285638520527873695)
,p_name=>'BUGS_ASSIGNED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6307\5B9A\7684\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285677773278873723)
,p_name=>'BUGS_ASSIGNED_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6307\5B9A\7684\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285135839199873327)
,p_name=>'BUGS_CLOSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\89E3\6C7A\7684\932F\8AA4 (%0/%1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286053274165873983)
,p_name=>'BUGS_PERCENT_CLOSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4\5DF2\8655\7406\767E\5206\6BD4 (%0/%1):')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285677801929873723)
,p_name=>'BUGS_UNASSIGNED_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\6307\5B9A\7684\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285677951036873723)
,p_name=>'BUGS_WITHOUT_FIXBY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\4FEE\6B63\5B8C\6210\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286053601166873983)
,p_name=>'BUG_FEEDBACK_DASH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4: %1 \500B\5DF2\8655\7406, \5171 %0 \500B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286417581216874257)
,p_name=>'BUG_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4: %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285631844697873690)
,p_name=>'BUILD QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285099060613873300)
,p_name=>'BUILDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7522\751F\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285737800202873765)
,p_name=>'BUILDER.PLUGINS'
,p_message_language=>'zh-tw'
,p_message_text=>'Plug-in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285733372799873762)
,p_name=>'BUILDER.UNSUPPORTED_COMPONENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('[\4E0D\652F\63F4]')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286028037341873965)
,p_name=>'BUILDER_NOTIFICATION_MESSAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340\8A0A\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285329018414873469)
,p_name=>'BUILD_OPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\5EFA\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285802269270873808)
,p_name=>'BUILD_OPTION_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\5EFA\9078\9805: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286416250220874256)
,p_name=>'BUILD_STATUS_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\5EFA\72C0\614B: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285803142765873808)
,p_name=>'BUILD_VERSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7F6E\7248\672C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285671351924873719)
,p_name=>'BUILT_IN_REPORT_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5167\5EFA\7684\5831\8868\6A23\677F')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285574366250873647)
,p_name=>'BUTTON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575090391873647)
,p_name=>'BUTTON LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780321449873793)
,p_name=>'BUTTON.ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285115657334873312)
,p_name=>'BUTTON.DA.INVALID.BUTTON_ATTR_CONTAIN_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\4E4B\6309\9215\7684\300C\6309\9215\5C6C\6027\300D\4E0D\53EF\5305\542B ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285115530726873312)
,p_name=>'BUTTON.DA.INVALID.NOT_DEFINED_BY_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\7684\6309\9215\5FC5\9808\662F\4E00\500B\300C\52D5\4F5C\300D\8A2D\70BA\300C\52D5\614B\52D5\4F5C\5B9A\7FA9\300D\7684\6309\9215')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285115890012873312)
,p_name=>'BUTTON.DA.INVALID.TEMPLATE_NO_BUTTON_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\7684\6309\9215\4F7F\7528\672A\5305\542B #BUTTON_ID# \66FF\4EE3\5B57\4E32\7684\300C\6309\9215\6A23\677F\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780104989873793)
,p_name=>'BUTTON.DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285189127984873366)
,p_name=>'BUTTON.INVALID.ACTION.REDIRECT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\9801\9762.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285165317929873348)
,p_name=>'BUTTON.INVALID.ACTION.REPORT_QRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\5831\8868\67E5\8A62.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285152570197873339)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9664\975E\300C\6309\9215\8981\6C42\4F86\6E90\985E\578B\300D\70BA\300C\4E00\5F8B\662F\7A7A\503C\300D, \5426\5247\5FC5\9808\66FF\6240\6709\300C\6309\9215\8981\6C42\4F86\6E90\985E\578B\300D\6307\5B9A\300C\6309\9215\8981\6C42\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285153202093873340)
,p_name=>'BUTTON.INVALID.ACTION.SOURCE_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\6309\9215\8981\6C42\4F86\6E90\985E\578B.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285189268195873366)
,p_name=>'BUTTON.INVALID.ACTION.URL_TARGET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A URL \76EE\6A19.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118140050873314)
,p_name=>'BUTTON.INVALID.BUTTON_ATTR_HAS_ID_WHEN_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\52D5\4F5C\300D\70BA\300C\52D5\614B\52D5\4F5C\5B9A\7FA9\300D\6642,\300C\6309\9215\5C6C\6027\300D\4E0D\53EF\5305\542B ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285190893621873367)
,p_name=>'BUTTON.INVALID.STYLE.IMAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\5F71\50CF.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285190999556873367)
,p_name=>'BUTTON.INVALID.STYLE.NO_STYLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\6A23\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285190711013873367)
,p_name=>'BUTTON.INVALID.STYLE.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\6A23\677F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285118073276873314)
,p_name=>'BUTTON.INVALID.TEMPLATE_NO_BUTTON_ID_WHEN_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\6309\9215\6A23\5F0F\300D\70BA\300C\4EE5\6A23\677F\70BA\57FA\790E\7684\6309\9215\300D\4E14\300C\52D5\4F5C\300D\70BA\300C\52D5\614B\52D5\4F5C\5B9A\7FA9\300D\6642, \6240\9078\7684\300C\6309\9215\6A23\677F\300D\5FC5\9808\5305\542B #BUTTON_ID# \66FF\4EE3\5B57\4E32')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285105668211873305)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_AFFECTED_ELEMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\522A\9664\6309\9215, \56E0\70BA\6B64\6309\9215\5DF2\5728\300C\52D5\614B\52D5\4F5C\300D\4E2D\88AB\53C3\7167 (\9801\9762: %0, \52D5\614B\52D5\4F5C: ''%1'', \52D5\4F5C: ''%2'', \5C6C\6027:\300C\53D7\5F71\97FF\7684\5143\7D20\300D).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285105512505873305)
,p_name=>'BUTTON.INVALID_DELETE.REFERENCED_BY.DA_WHEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\522A\9664\6309\9215, \56E0\70BA\6B64\6309\9215\5DF2\5728\300C\52D5\614B\52D5\4F5C\300D\4E2D\88AB\53C3\7167 (\9801\9762: %0, \52D5\614B\52D5\4F5C: ''%1'', \5C6C\6027:\300C\6642\6A5F\300D).')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780297675873793)
,p_name=>'BUTTON.SUBMIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9001\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285776139044873790)
,p_name=>'BUTTON.TEMPLATE.JAVASCRIPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\7528\65BC "onclick" \5C6C\6027\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285779666642873793)
,p_name=>'BUTTON.TEMPLATE.LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\7528\65BC "href" \5C6C\6027\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285189082419873366)
,p_name=>'BUTTONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285645789703873700)
,p_name=>'BUTTON_ATTRIBUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285097958533873299)
,p_name=>'BUTTON_CSS_CLASSES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215 CSS \985E\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285296414988873445)
,p_name=>'BUTTON_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7522\751F\7684\6309\9215 ID \5C07\662F\6309\9215\7684\300C\975C\614B ID\300D(\5982\679C\5B9A\7FA9), \6216\8005\82E5\672A\5B9A\7FA9\7684\8A71, \5C07\662F\683C\5F0F\70BA ''B'' || [\5167\90E8\6309\9215 ID] \7684\5167\90E8\7522\751F ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286416065063874256)
,p_name=>'BUTTON_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285650986697873704)
,p_name=>'BUTTON_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215\6A23\677F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285185926978873364)
,p_name=>'BYTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F4D\5143\7D44')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285591411007873661)
,p_name=>'BY_NEXT_PATCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\4E0B\500B\4FEE\6B63\7A0B\5F0F\4FEE\6B63')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285591542457873661)
,p_name=>'BY_NEXT_RELEASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\4E0B\500B\7248\6B21\4FEE\6B63')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515434671874329)
,p_name=>'CA.ABOUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\65BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481768345874304)
,p_name=>'CA.ABOUT.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\65BC\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481621680874304)
,p_name=>'CA.ABOUT.PAGE.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5167\542B\4E00\500B\95DC\65BC\6B64\61C9\7528\7A0B\5F0F\9801\9762, \5167\5BB9\4E3B\8981\5305\62EC\61C9\7528\7A0B\5F0F\63CF\8FF0\3001\61C9\7528\7A0B\5F0F\7248\672C\4EE5\53CA\9801\6578.'),
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306551309873452)
,p_name=>'CA.ABOUT.PAGE.HELP.CONTENT.CONTAINER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5167\5BB9\5BB9\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515612446874329)
,p_name=>'CA.ABOUT.THIS.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\65BC\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515721614874329)
,p_name=>'CA.ABOUT.THIS.APPLICATION.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\53EF\4EE5\5728\9019\88E1\8F38\5165\95DC\65BC\6B64\61C9\7528\7A0B\5F0F\7684\6587\5B57.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515314113874329)
,p_name=>'CA.ABOUT.THIS.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\65BC\6B64\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527663208874338)
,p_name=>'CA.ABOUT.THIS.PREVIEW.RELEASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\65BC\6B64\9810\89BD\767C\884C\7248\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482093641874304)
,p_name=>'CA.ACCESS.CONTROL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517998992874331)
,p_name=>'CA.ACCESS.CONTROL.ACTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507452158874323)
,p_name=>'CA.ACCESS.CONTROL.CONFIGURATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\7D44\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286480499675874303)
,p_name=>'CA.ACCESS.CONTROL.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528\4EE5\89D2\8272\70BA\57FA\790E\7684\4F7F\7528\8005\6388\6B0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482174232874304)
,p_name=>'CA.ACCESS.CONTROL.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\61C9\7528\7A0B\5F0F\5167\4F75\5165\4EE5\89D2\8272\70BA\57FA\790E\7684\4F7F\7528\8005\8A8D\8B49.'),
unistr('\4F7F\7528\8005\53EF\4EE5\5B9A\7FA9\70BA\7BA1\7406\54E1\3001\63D0\4F9B\8005\6216\95B1\8B80\8005.'),
unistr('\60A8\53EF\4EE5\63A5\8457\5B9A\7FA9\4E0D\540C\89D2\8272\7684\5B58\53D6\6B0A, \4EE5\900F\904E\61C9\7528\7A0B\5F0F\5B58\53D6\4E0D\540C\7684\5143\4EF6, \4F8B\5982\9801\9762\3001\529F\80FD\8868\9805\76EE\3001\5340\57DF\3001\8CC7\6599\6B04\3001\9805\76EE\53CA\6309\9215\7B49\7B49.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\5177\6709\5B58\53D6\63A7\5236\529F\80FD\9023\7D50\7684\7BA1\7406\9801\9762\5340\57DF</li>'),
unistr('<li>\7BA1\7406\5B58\53D6\63A7\5236\7684\4F7F\7528\8005\8868\683C</li>'),
unistr('<li>\8A2D\5B9A\5DF2\8A8D\8B49\4F7F\7528\8005\5B58\53D6\5C64\6B21\7684\7D44\614B\9801\9762</li>'),
unistr('<li>\6307\5B9A\4F7F\7528\8005\540D\7A31\662F\5426\70BA\96FB\5B50\90F5\4EF6\5730\5740\7684\7D44\614B\9801\9762</li>'),
unistr('<li>\5831\544A\8207\7DE8\8F2F\4F7F\7528\8005\5B58\53D6\6B0A\7684\7BA1\7406\4F7F\7528\8005\5B58\53D6\9801\9762</li>'),
unistr('<li>\53EF\65B0\589E\55AE\4E00\4F7F\7528\8005\529F\80FD\7684\65B0\589E\4F7F\7528\8005\9801\9762</li>'),
unistr('<li>\53EF\65B0\589E\591A\500B\4F7F\7528\8005\529F\80FD\7684\65B0\589E\591A\500B\4F7F\7528\8005\9801\9762 (\53EA\9069\7528\65BC\96FB\5B50\90F5\4EF6\4F7F\7528\8005\540D\7A31)</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506310472874322)
,p_name=>'CA.ACCESS.ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507068933874323)
,p_name=>'CA.ACCESS.ROLE.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\89D2\8272 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285225920658873393)
,p_name=>'CA.ACCESS.ROLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506477611874323)
,p_name=>'CA.ACCOUNT.LOCKED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E33\6236\5DF2\9396\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253702014873414)
,p_name=>'CA.ACKNOWLEDGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8A8D\53EF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517742795874331)
,p_name=>'CA.ACL.INFORMATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('ACL \8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518428322874331)
,p_name=>'CA.ACL.NOT.ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4E0D\662F\7BA1\7406\54E1, \56E0\6B64\6B0A\9650\4E0D\8DB3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518518676874332)
,p_name=>'CA.ACL.NOT.AUTHORIZED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5C1A\672A\53D6\5F97\5B58\53D6\6B0A\6216\60A8\7684\5E33\6236\88AB\9396\5B9A, \56E0\6B64\7121\6B0A\6AA2\8996\6B64\61C9\7528\7A0B\5F0F. \8ACB\6D3D\8A62\61C9\7528\7A0B\5F0F\7BA1\7406\54E1.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518641011874332)
,p_name=>'CA.ACL.NOT.CONTRIBUTOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4E0D\662F\63D0\4F9B\8005, \6B0A\9650\4E0D\8DB3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508124137874324)
,p_name=>'CA.ACL.SAVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\8A2D\5B9A\503C\5DF2\5132\5B58.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512859912874327)
,p_name=>'CA.ACTION.BUTTON.HTML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\6309\9215 HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511784610874326)
,p_name=>'CA.ACTION.LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511804041874326)
,p_name=>'CA.ACTION.LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\9023\7D50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514460465874328)
,p_name=>'CA.ACTION.LINK.HTML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\9023\7D50 HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499998256874318)
,p_name=>'CA.ACTION.PROCESSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\5DF2\8655\7406.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505404620874322)
,p_name=>'CA.ACTIVITY.BY.HOUR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F9D\5C0F\6642\5340\5206\7684\6D3B\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539780924874347)
,p_name=>'CA.ACTIVITY.DASHBOARD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6D3B\52D5\5100\8868\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482264534874304)
,p_name=>'CA.ACTIVITY.REPORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6D3B\52D5\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481423331874304)
,p_name=>'CA.ACTIVITY.REPORTING.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\62EC\4F7F\7528\8005\6D3B\52D5\548C\932F\8AA4\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482342992874304)
,p_name=>'CA.ACTIVITY.REPORTING.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5167\542B\4E00\822C\4F7F\7528\8005\61C9\7528\7A0B\5F0F\6D3B\52D5\7684\6578\500B\5831\8868. \53EF\4F9B\5224\65B7\6700\6D3B\8E8D\7684\4F7F\7528\8005\3001\6700\5E38\4F7F\7528\7684\9801\9762\3001\9801\9762\6548\80FD\4EE5\53CA\767C\751F\7684\932F\8AA4, \8B93\60A8\66F4\52A0\77AD\89E3\61C9\7528\7A0B\5F0F\7684\4F7F\7528\72C0\6CC1\53CA\9700\8981\6539\5584\7684\5340\57DF.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5831\8868:'),
'<ul>',
unistr('<li>\6700\5E38\4F7F\7528\7684\4F7F\7528\8005\5831\8868</li>'),
unistr('<li>\61C9\7528\7A0B\5F0F\932F\8AA4\65E5\8A8C\5831\8868</li>'),
unistr('<li>\9801\9762\6548\80FD (\4F9D\9801\9762\5340\5206\7684\6D3B\52D5\548C\6548\80FD)</li>'),
unistr('<li>\4F9D\9801\9762\5340\5206\7684\61C9\7528\7A0B\5F0F\6D3B\52D5\5831\8868</li>'),
unistr('<li>\9801\9762\6AA2\8996\660E\7D30\5831\8868</li>'),
'',
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628166889873687)
,p_name=>'CA.ACTUAL.START.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BE6\969B\958B\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517606107874331)
,p_name=>'CA.ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513049535874327)
,p_name=>'CA.ADD.EMAIL.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\96FB\5B50\90F5\4EF6\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530671863874341)
,p_name=>'CA.ADD.MULTI.USERS.STEP.2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\591A\500B\4F7F\7528\8005 - \6B65\9A5F 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515939593874330)
,p_name=>'CA.ADD.NEW.WIDGET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498917857874317)
,p_name=>'CA.ADD.NOTIFICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371445383874223)
,p_name=>'CA.ADD.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507178389874323)
,p_name=>'CA.ADD.USER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531005636874341)
,p_name=>'CA.ADD.USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483834648874306)
,p_name=>'CA.ADDING.PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484303643874306)
,p_name=>'CA.ADDING.PAGES.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6309\4E00\4E0B<strong>\65B0\589E\9801\9762</strong>\5373\53EF\65B0\589E\61C9\7528\7A0B\5F0F\7684\9801\9762. \7136\5F8C\9078\53D6\4E00\7A2E\9801\9762\985E\578B (\4F8B\5982\7A7A\767D\3001\5716\8868\3001\8868\55AE\3001\5831\8868\7B49) \4E26\5B9A\7FA9\5176\5C6C\6027. \60A8\53EF\80FD\4E5F\9700\8981\6307\5B9A\6709\6548\7684\8868\683C\6216\8996\89C0\8868, \6216\8005\4F7F\7528 SQL \5DE5\4F5C\5BA4\6E96\5099\5DE5\4F5C\5340\7684\8CC7\6599\5EAB\7269\4EF6.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513882016874328)
,p_name=>'CA.ADDITIONAL.HTML.TEMPLATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9032\968E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627499490873687)
,p_name=>'CA.ADDITIONAL.INFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\984D\5916\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506856577874323)
,p_name=>'CA.ADDRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487090650874308)
,p_name=>'CA.ADMIN.ACCESS.CONTROL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487628011874309)
,p_name=>'CA.ADMIN.ACCESS.CONTROL.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\70BA\6B64\61C9\7528\7A0B\5F0F\7684\5DF2\8A8D\8B49\4F7F\7528\8005\8A2D\5B9A\5B58\53D6\5C64\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486184748874307)
,p_name=>'CA.ADMIN.ACTIVITY.REPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6D3B\52D5\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487189415874308)
,p_name=>'CA.ADMIN.ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488832229874309)
,p_name=>'CA.ADMIN.ADMINISTRATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487575508874309)
,p_name=>'CA.ADMIN.ADMINISTRATORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285663115653873713)
,p_name=>'CA.ADMIN.APP.CONFIGURATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7D44\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773853844873789)
,p_name=>'CA.ADMIN.APP.USER_INTERFACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4ECB\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522479131874334)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7BA1\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522559101874335)
,p_name=>'CA.ADMIN.APPLICATION.ADMINISTRATION.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\5143\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485774202874307)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485866677874307)
,p_name=>'CA.ADMIN.APPLICATION.APPEARANCE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\9810\8A2D\61C9\7528\7A0B\5F0F\5916\89C0\8207\611F\89BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485416462874307)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\614B\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485322184874307)
,p_name=>'CA.ADMIN.APPLICATION.CONFIGURATION.OPTIONS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528\6216\505C\7528\61C9\7528\7A0B\5F0F\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486450667874308)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\932F\8AA4\65E5\8A8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486514293874308)
,p_name=>'CA.ADMIN.APPLICATION.ERROR.LOG.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\61C9\7528\7A0B\5F0F\8A18\9304\7684\932F\8AA4\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485980625874307)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486039580874307)
,p_name=>'CA.ADMIN.APPLICATION.SETTINGS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\540D\7A31\548C\7C21\8981\63CF\8FF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485571108874307)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485656816874307)
,p_name=>'CA.ADMIN.APPLICATION.UPDATES.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DAD\8B77\61C9\7528\7A0B\5F0F\66F4\65B0\7684\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485012506874307)
,p_name=>'CA.ADMIN.CONFIGURATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487444932874308)
,p_name=>'CA.ADMIN.CONTRIBUTORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538511779874346)
,p_name=>'CA.ADMIN.DASHBOARD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5100\8868\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538444307874346)
,p_name=>'CA.ADMIN.DASHBOARD.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\61C9\7528\7A0B\5F0F\6D3B\52D5\5EA6\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490567987874311)
,p_name=>'CA.ADMIN.DEFAULT.TZ'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\6642\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490652064874311)
,p_name=>'CA.ADMIN.DEFAULT.TZ.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\6B64\61C9\7528\7A0B\5F0F\7684\9810\8A2D\6642\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488382331874309)
,p_name=>'CA.ADMIN.EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490784316874311)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490848223874311)
,p_name=>'CA.ADMIN.EMAIL.SETTINGS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\662F\5426\50B3\9001\96FB\5B50\90F5\4EF6\4EE5\53CA\56DE\8986\7684\5C0D\8C61')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487802537874309)
,p_name=>'CA.ADMIN.FEEDBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\610F\898B\56DE\994B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488151919874309)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\610F\898B\56DE\994B\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488247119874309)
,p_name=>'CA.ADMIN.FEEDBACK.SETTINGS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\662F\5426\5141\8A31\9644\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487920502874309)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\610F\898B\56DE\994B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488030040874309)
,p_name=>'CA.ADMIN.MANAGE.FEEDBACK.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7531\61C9\7528\7A0B\5F0F\4F7F\7528\8005\9001\51FA\7684\6240\6709\610F\898B\56DE\994B\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488418635874309)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488538770874309)
,p_name=>'CA.ADMIN.MANAGE.TEMPLATES.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\6B64\61C9\7528\7A0B\5F0F\4F7F\7528\7684\96FB\5B50\90F5\4EF6\6A23\677F HTML \548C CSS')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485199801874307)
,p_name=>'CA.ADMIN.NOTIFICATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286485288753874307)
,p_name=>'CA.ADMIN.NOTIFICATIONS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\9996\9801\986F\793A\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523172573874335)
,p_name=>'CA.ADMIN.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486630037874308)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6548\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486762601874308)
,p_name=>'CA.ADMIN.PAGE.PERFORMANCE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F9D\61C9\7528\7A0B\5F0F\9801\9762\5340\5206\7684\6D3B\52D5\548C\6548\80FD\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486834114874308)
,p_name=>'CA.ADMIN.PAGE.VIEWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486915227874308)
,p_name=>'CA.ADMIN.PAGE.VIEWS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F9D\4F7F\7528\8005\5340\5206\7684\6BCF\500B\9801\9762\6AA2\8996\5831\8868 (\5305\62EC\5B58\53D6\65E5\671F\548C\7D93\6B77\6642\9593)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487357252874308)
,p_name=>'CA.ADMIN.READERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95B1\8B80\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531776380874341)
,p_name=>'CA.ADMIN.SEND.EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531874560874341)
,p_name=>'CA.ADMIN.SEND.EMAIL.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F9E\6B64\61C9\7528\7A0B\5F0F\50B3\9001\4EE5\6A23\677F\70BA\57FA\790E\7684\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486296938874308)
,p_name=>'CA.ADMIN.TOP.USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286486370407874308)
,p_name=>'CA.ADMIN.TOP.USERS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4F7F\7528\8005\805A\7E3D\7684\9801\9762\6AA2\8996\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487295197874308)
,p_name=>'CA.ADMIN.USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286487760460874309)
,p_name=>'CA.ADMIN.USERS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\5B58\53D6\63A7\5236\8A2D\5B9A\503C\4E26\505C\7528\5B58\53D6\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488661636874309)
,p_name=>'CA.ADMIN.VIEW.LOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\65E5\8A8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488716472874309)
,p_name=>'CA.ADMIN.VIEW.LOG.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\6B64\61C9\7528\7A0B\5F0F\50B3\9001\7684\96FB\5B50\90F5\4EF6\65E5\8A8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409772245873527)
,p_name=>'CA.ADVANCED'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\9032\968E</strong> - \5C55\958B\67E5\770B\9032\968E\9078\9805.'),
'    <ul>',
unistr('      <li><strong>\8A2D\70BA\9996\9801</strong> - \5C07\6B64\9801\9762\8A2D\70BA\61C9\7528\7A0B\5F0F\9996\9801.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\5148\524D\5B9A\7FA9\70BA\9996\9801\7684\4EFB\4F55\9801\9762\5C07\6703\88AB\66F4\65B0.</li>'),
unistr('      <li><strong>\8A2D\70BA\7BA1\7406\9801\9762</strong> - \5C07\6B64\9801\9762\65B0\589E\81F3\300C\7BA1\7406\300D\9801\9762, \800C\4E0D\662F\61C9\7528\7A0B\5F0F\4E2D\7684\4E00\822C\9801\9762. \6309\4E00\4E0B\4E3B\529F\80FD\8868\4E2D\7684\300C\7BA1\7406\300D, \7136\5F8C\5F9E\300C\61C9\7528\7A0B\5F0F\7BA1\7406\300D\6E05\55AE\9078\53D6, \5373\53EF\5B58\53D6\6B64\9801\9762.<br>'),
unistr('        <em><strong>\6CE8\610F:</strong> \9801\9762\4E0D\53EF\540C\6642\70BA\9996\9801\53C8\4F4D\65BC\7BA1\7406\9801\9762\4E4B\4E0B.</em></li>'),
'      &nbsp;<br>',
unistr('      <li><strong>\9801\9762\8AAA\660E</strong> - \8F38\5165\8981\65B0\589E\81F3\9801\9762\8AAA\660E\5167\5BB9\7684\6587\5B57.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285280063881873433)
,p_name=>'CA.ADVANCED.PAGE_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\9032\968E</strong> - \53EF\5C55\958B\4EE5\67E5\770B\9032\968E\9078\9805.'),
'    <ul>',
unistr('      <li><strong>\9801\9762\8AAA\660E</strong> - \53EF\8F38\5165\8981\65B0\589E\81F3\9801\9762\8AAA\660E\6587\5B57\4E2D\7684\6587\5B57.</li>'),
'    </ul>',
'  </li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523580720874335)
,p_name=>'CA.ADVANCED.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9032\968E\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523689954874335)
,p_name=>'CA.ADVANCED.SETTINGS.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\8A2D\5B9A\5176\4ED6\5B9A\7FA9\3001\5B89\5168\6027\4EE5\53CA\5168\7403\5316\8A2D\5B9A\503C.  \5EFA\7ACB\61C9\7528\7A0B\5F0F\6642\53EF\4EE5\5957\7528\9019\4E9B\8A2D\5B9A\503C, \4E5F\53EF\4EE5\5728\61C9\7528\7A0B\5F0F\5EFA\7ACB\4E4B\5F8C\7DE8\8F2F.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526664586874338)
,p_name=>'CA.ADVANCED.SETTINGS.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\8ACB\95B1\8B80\6BCF\500B\8A2D\5B9A\7684\9805\76EE\8AAA\660E (<span class="fa fa-question-circle" aria-hidden="true"></span>) \4EE5\77AD\89E3\8A73\7D30\8CC7\8A0A.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532402295874342)
,p_name=>'CA.AFTER.ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\4E4B\5F8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512733579874327)
,p_name=>'CA.AFTER.ROWS.HTML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\4E4B\5F8C HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515864506874330)
,p_name=>'CA.ALL.COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511984579874327)
,p_name=>'CA.ALLOW.OPT.OUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\9078\64C7\9000\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621068651873682)
,p_name=>'CA.ALLOW.RUNS.IN.RESTRICTED.MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4EE5\9650\5236\6A21\5F0F\57F7\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505382301874322)
,p_name=>'CA.APP.ERROR.LOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\932F\8AA4\65E5\8A8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501236294874319)
,p_name=>'CA.APP.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285674007901873721)
,p_name=>'CA.APP.SETTING.ACL_ENABLED.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F\5426\958B\555F\5B58\53D6\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285674108598873721)
,p_name=>'CA.APP.SETTING.ACL_SCOPE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7D66\4E0D\5728\5B58\53D6\63A7\5236\6E05\55AE\4E2D\7684\5DF2\8A8D\8B49\4F7F\7528\8005\7684\9810\8A2D\5B58\53D6\5C64\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501634874874319)
,p_name=>'CA.APP.SETTINGS.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C\5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501417368874319)
,p_name=>'CA.APP.SUBTITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7C21\8981\63CF\8FF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501554491874319)
,p_name=>'CA.APP.SUBTITLE.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\9019\88E1\8F38\5165\7684\6587\5B57\6703\986F\793A\5728\61C9\7528\7A0B\5F0F\9996\9801\7684\61C9\7528\7A0B\5F0F\540D\7A31\4E0B\65B9.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490928330874311)
,p_name=>'CA.APPEARANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5916\89C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491044700874311)
,p_name=>'CA.APPEARANCE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\5B9A\7FA9\61C9\7528\7A0B\5F0F (\542B\5C0E\89BD\6240\5728\4F4D\7F6E) \7684\9810\8A2D\8272\5F69\914D\7F6E (\4E3B\984C\6A23\5F0F) \4EE5\53CA\7528\65BC\61C9\7528\7A0B\5F0F\7684\9810\8A2D\5716\793A.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510470776874325)
,p_name=>'CA.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497551260874316)
,p_name=>'CA.APPLICATION.APPEARANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5916\89C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491568469874311)
,p_name=>'CA.APPLICATION.ICON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5716\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491624215874312)
,p_name=>'CA.APPLICATION.ICON.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6309\4E00\4E0B<strong>\9078\64C7\65B0\5716\793A</strong>\5373\53EF\9078\53D6\5716\793A\8272\5F69\548C\5176\4E2D\4E00\500B\53EF\7528\7684\5716\793A. \9078\53D6\7684\9805\76EE\6703\986F\793A\5728\61C9\7528\7A0B\5F0F\7684\9996\9801\4E2D.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491947741874312)
,p_name=>'CA.APPLICATION.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492062713874312)
,p_name=>'CA.APPLICATION.ID.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\8F38\5165\61C9\7528\7A0B\5F0F\552F\4E00\7684\6578\5B57 ID. \6B64\6B04\4F4D\5305\542B\9810\8A2D\6703\81EA\52D5\7522\751F\7684 ID.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511046402874326)
,p_name=>'CA.APPLICATION.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503271646874320)
,p_name=>'CA.APPLICATION.SESSIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\968E\6BB5\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481809229874304)
,p_name=>'CA.APPLICATION.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286480738899874303)
,p_name=>'CA.APPLICATION.SETTINGS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\61C9\7528\7A0B\5F0F\540D\7A31\548C\7C21\8981\63CF\8FF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481920840874304)
,p_name=>'CA.APPLICATION.SETTINGS.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8A31\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\66F4\65B0\4E0D\540C\7684\8A2D\5B9A\503C, \4F8B\5982\61C9\7528\7A0B\5F0F\540D\7A31\53CA\63CF\8FF0\3001\9810\8A2D\6642\5340\7B49\7B49.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\7BA1\7406\9801\9762\6E05\55AE\9805\76EE\548C\8868\55AE</li>'),
unistr('<li>\8A2D\5B9A\61C9\7528\7A0B\5F0F\540D\7A31</li>'),
unistr('<li>\8A2D\5B9A\9996\9801\4E3B\8996\89BA\5340\5B50\6A19\984C</li>'),
unistr('<li>\4F7F\7528\610F\898B\56DE\994B\6642\8A2D\5B9A\610F\898B\56DE\994B\63A5\6536\8005</li>'),
unistr('<li>\8A2D\5B9A\61C9\7528\7A0B\5F0F\9810\8A2D\6642\5340</li>'),
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537598073874346)
,p_name=>'CA.APPLICATIONITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539339860874347)
,p_name=>'CA.APPLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541164434874348)
,p_name=>'CA.APPLY.APP.DEFAULTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528\61C9\7528\7A0B\5F0F\9810\8A2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496797519874315)
,p_name=>'CA.APPLY.CHANGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528\8B8A\66F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539187044874347)
,p_name=>'CA.APPLY.FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771768946873787)
,p_name=>'CA.APP_BANNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F9E\5EFA\7ACB\61C9\7528\7A0B\5F0F\7CBE\9748 %0 \5EFA\7ACB\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773068225873788)
,p_name=>'CA.APP_SETTING.SAVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543345677874350)
,p_name=>'CA.ATTACHMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487439379873584)
,p_name=>'CA.ATTACHMENT.COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\4EF6\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543436753874350)
,p_name=>'CA.ATTACHMENT.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\4EF6\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487329918873584)
,p_name=>'CA.ATTACHMENT.SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\4EF6\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539420641874347)
,p_name=>'CA.ATTR.DEFAULT.DUPLICATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\7D93\5B9A\7FA9\9019\500B %0 \7684\5C6C\6027\9810\8A2D\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507566202874323)
,p_name=>'CA.AUTH.USER.MAY.ACCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4EFB\4F55\5DF2\8A8D\8B49\7684\4F7F\7528\8005\90FD\53EF\4EE5\5B58\53D6\6B64\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492769277874312)
,p_name=>'CA.AUTHENTICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492867807874312)
,p_name=>'CA.AUTHENTICATION.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\9078\53D6\4F7F\7528\8005\5728\61C9\7528\7A0B\5F0F\4E2D\7684\8A8D\8B49\65B9\5F0F.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623769635873684)
,p_name=>'CA.AUTO.DROP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\52D5\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503924559874321)
,p_name=>'CA.AVG.ELAPSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E73\5747\7D93\6B77\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285671127558873718)
,p_name=>'CA.BACK.TO.JOBS.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8FD4\56DE\5DE5\4F5C\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488145280873584)
,p_name=>'CA.BCC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC6\4EF6\526F\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532386046874342)
,p_name=>'CA.BEFORE.ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\4E4B\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512695370874327)
,p_name=>'CA.BEFORE.ROWS.HTML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\4E4B\524D HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514141106874328)
,p_name=>'CA.BEGIN.ROW.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\4E4B\524D\5167\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489462563874310)
,p_name=>'CA.BLANK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\7A7A\767D\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489599278874310)
,p_name=>'CA.BLANK.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\7A7A\767D\9801\9762\4F5C\70BA\9810\7559\4F4D\7F6E. \5EFA\7ACB\61C9\7528\7A0B\5F0F\4E4B\5F8C, \5C31\53EF\4EE5\5F9E\300C\9801\9762\8A2D\8A08\5DE5\5177\300D\5FEB\901F\5EFA\7ACB\9801\9762\4E0A\7684\5340\57DF.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('<!--  <li><strong>\5305\62EC\9801\9762\5C0E\89BD</strong> - \52FE\9078\6B64\9078\9805\5373\53EF\4EE5\5361\7247\6E05\55AE\65B9\5F0F\986F\793A\61C9\7528\7A0B\5F0F\4E2D\5B9A\7FA9\7684\6240\6709\5176\4ED6\9801\9762.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\6B64\9078\9805\4E00\822C\7528\65BC\61C9\7528\7A0B\5F0F\9996\9801.</li>'),
'-->',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522862990874335)
,p_name=>'CA.BLUEPRINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\85CD\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522968101874335)
,p_name=>'CA.BLUEPRINT.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\85CD\5716\6703\4EE5 JSON \683C\5F0F\5217\51FA\61C9\7528\7A0B\5F0F\5B9A\7FA9.</p>'),
unistr('<p>\7B2C\4E00\6B21\9032\5165\6B64\756B\9762\6642, \76EE\524D\7684\61C9\7528\7A0B\5F0F\5B9A\7FA9\6703\8F49\63DB\6210 JSON \6587\4EF6\4E26\986F\793A. \60A8\53EF\4EE5\7DE8\8F2F\6B64\6587\4EF6\4EE5\66F4\65B0\61C9\7528\7A0B\5F0F\7279\6027, \7136\5F8C\6309\4E00\4E0B<strong>\5957\7528\85CD\5716</strong>\4EE5\8B8A\66F4\76EE\524D\7684\61C9\7528\7A0B\5F0F\8A73\7D30\8CC7\8A0A.</p>'),
'<p>&nbsp;</p>',
unistr('<p>\5982\679C\60A8\9700\8981\5EFA\7ACB\5927\91CF\7684\76F8\4F3C\9801\9762, \53EF\4EE5\8907\88FD\4E00\500B\9801\9762\7684\76F8\95DC JSON \7A0B\5F0F\78BC\4E26\9032\884C\591A\6B21\8CBC\4E0A, \7136\5F8C\5C0D JSON \9032\884C\4E9B\8A31\8ABF\6574, \9019\6703\6BD4\91DD\5C0D\6BCF\500B\9801\9762\624B\52D5\4F7F\7528<strong>\65B0\589E\9801\9762</strong>\5FEB\5F97\8A31\591A.</p>'),
unistr('<p>\6309\4E00\4E0B<strong>\8F09\5165\4E0A\4E00\500B\85CD\5716</strong>, \53EF\4F7F\7528\4E4B\524D\7522\751F\4E4B\61C9\7528\7A0B\5F0F\7684\5B9A\7FA9\4F86\53D6\4EE3\85CD\5716. \60A8\53EF\4EE5\5229\7528\6B64\65B9\5F0F, \5728\518D\6B21\7522\751F\61C9\7528\7A0B\5F0F\4E4B\524D\5148\65B0\589E\5176\4ED6\9801\9762\3001\8B8A\66F4\529F\80FD\6216\5FAE\8ABF\8A2D\5B9A\503C, \8F15\9B06\5730\91CD\8907\9032\884C\61C9\7528\7A0B\5F0F\8A2D\8A08.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511500936874326)
,p_name=>'CA.BODY1.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672C\65871 \6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511689972874326)
,p_name=>'CA.BODY2.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672C\65872 \6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532787580874342)
,p_name=>'CA.BOTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8C\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497979601874316)
,p_name=>'CA.BRANCH.TO.ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\9801\9762\7684\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285408629462873527)
,p_name=>'CA.BUTTON.BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497674552874316)
,p_name=>'CA.BUTTONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490192960874310)
,p_name=>'CA.CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\884C\4E8B\66C6\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490201841874311)
,p_name=>'CA.CALENDAR.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\884C\4E8B\66C6\7684\9801\9762.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\8868\683C\6216\8996\89C0\8868</strong> (\5FC5\8981) - \9078\53D6\884C\4E8B\66C6\7684\8CC7\6599\5EAB\7269\4EF6.</li>'),
unistr('  <li><strong>\986F\793A\8CC7\6599\6B04</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\884C\4E8B\66C6\4E8B\4EF6\4E2D\6240\8981\986F\793A\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\958B\59CB\65E5\671F\8CC7\6599\6B04</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7576\4F5C\884C\4E8B\66C6\4E8B\4EF6\958B\59CB\65E5\671F\7684\65E5\671F\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\7D50\675F\65E5\671F\8CC7\6599\6B04</strong> - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7576\4F5C\884C\4E8B\66C6\4E8B\4EF6\7D50\675F\65E5\671F\7684\65E5\671F\8CC7\6599\6B04.<br>'),
unistr('      &nbsp;&nbsp;&nbsp;\5982\679C\6307\5B9A\7D50\675F\65E5\671F, \5C07\6703\986F\793A\6301\7E8C\4E00\6BB5\6642\9593\7684\4E8B\4EF6. </li>'),
unistr('  <li><strong>\986F\793A\6642\9593</strong> - \9078\53D6<strong>\662F</strong>\5373\53EF\986F\793A\4E8B\4EF6\7684\6642\9593\90E8\5206, \540C\6642\555F\7528\6BCF\9031\548C\6BCF\65E5\884C\4E8B\66C6\6AA2\8996. \9078\53D6<strong>\5426</strong>\5C31\53EA\6703\986F\793A\4E8B\4EF6\65E5\671F.</li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496600650874315)
,p_name=>'CA.CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498525071874317)
,p_name=>'CA.CANCEL.DIALOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88\5C0D\8A71\65B9\584A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388720750873512)
,p_name=>'CA.CANCEL.MODAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88\5F37\5236\56DE\61C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508484316874324)
,p_name=>'CA.CANNOT.REMOVE.ADMIN.RIGHTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\7121\6CD5\76F4\63A5\5F9E\81EA\5DF1\7684\8A18\9304\4E2D\79FB\9664\7BA1\7406\6B0A\9650.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540350202874348)
,p_name=>'CA.CARD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\5361\7247\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540238581874348)
,p_name=>'CA.CARD.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\5361\7247\7684\9801\9762.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\8868\683C\6216\8996\89C0\8868</strong> (\5FC5\8981) - \9078\53D6\5361\7247\7684\8CC7\6599\5EAB\7269\4EF6.</li>'),
unistr('  <li><strong>\5361\7247\6A19\984C</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\8981\4F5C\70BA\5361\7247\6A19\984C\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\63CF\8FF0\8CC7\6599\6B04</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\8981\4F5C\70BA\5361\7247\63CF\8FF0\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\5176\4ED6\6587\5B57\8CC7\6599\6B04</strong> - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\4F5C\70BA\5361\7247\6B21\8981\63CF\8FF0\7684\8CC7\6599\6B04.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538868182874347)
,p_name=>'CA.CARDS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5361\7247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538993114874347)
,p_name=>'CA.CARDS.VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5361\7247\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488261999873584)
,p_name=>'CA.CC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\526F\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772467905873788)
,p_name=>'CA.CHANGE_FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489212755874310)
,p_name=>'CA.CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\5716\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489396560874310)
,p_name=>'CA.CHART.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\5340\57DF\5716\3001\9577\689D\5716\3001\6298\7DDA\5716\6216\5713\9905\5716\7684\9801\9762.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\5716\8868\985E\578B</strong> - \9078\53D6\8981\986F\793A\7684\5716\8868\985E\578B [<strong>\5340\57DF\5716</strong>\3001<strong>\9577\689D\5716</strong>\3001<strong>\6298\7DDA\5716</strong>\3001<strong>\5713\9905\5716</strong>].</li>'),
unistr('  <li><strong>\8868\683C\6216\8996\89C0\8868</strong> (\5FC5\8981) - \9078\53D6\5716\8868\7684\8CC7\6599\5EAB\7269\4EF6.</li>'),
unistr('  <li><strong>\6A19\7C64\8CC7\6599\6B04</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\8981\4F5C\70BA\5716\8868\6A19\7C64\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\503C\805A\7E3D</strong> - \9078\53D6\503C\8CC7\6599\6B04\7684\986F\793A\6216\805A\7E3D\65B9\5F0F<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\8CC7\6599\6B04\503C\3001\7E3D\548C\3001\8A08\6578].</li>'),
unistr('  <li><strong>\503C\8CC7\6599\6B04</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7528\65BC\8A08\7B97\986F\793A\4E4B\5716\8868\503C\7684\6578\503C\8CC7\6599\6B04.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489673729874310)
,p_name=>'CA.CHART.EXAMPLES'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<h3>\7BC4\4F8B</h3>'),
unistr('<p>\8907\67E5\7BC4\4F8B\4EE5\77AD\89E3\4F7F\7528\4E0D\540C<strong>\5F59\7E3D</strong>\985E\578B\7684\65B9\5F0F:</p>'),
unistr('<p><strong>\7BC4\4F8B 1:</strong> \91DD\5C0D\6BCF\500B\54E1\5DE5\986F\793A\7BA1\7406\8005\7684\54E1\5DE5\4EBA\6578\7684\300C\54E1\5DE5\300D\5716\8868.'),
'<code><ul>',
unistr('  <li>\8868\683C\6216\8996\89C0\8868 - \9078\53D6 EMP.</li>'),
unistr('  <li>\6A19\7C64\8CC7\6599\6B04 - \9078\53D6 ENAME.</li>'),
unistr('  <li>\5F59\7E3D - \9078\53D6<u><strong>\8CC7\6599\6B04\503C</strong></u>.</li>'),
unistr('  <li>\503C\8CC7\6599\6B04 - \9078\53D6 MGR.</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\7BC4\4F8B 2:</strong> \986F\793A\542B\6709\6BCF\500B\5DE5\4F5C\7E3D\85AA\8CC7\7684\300C\54E1\5DE5\300D\5716\8868.'),
'<code><ul>',
unistr('  <li>\8868\683C\6216\8996\89C0\8868 - \9078\53D6 EMP.</li>'),
unistr('  <li>\6A19\7C64\8CC7\6599\6B04 - \9078\53D6 JOB.</li>'),
unistr('  <li>\5F59\7E3D - \9078\53D6<u><strong>\7E3D\548C</strong></u>.</li>'),
unistr('  <li>\503C\8CC7\6599\6B04 - \9078\53D6 SAL.</li>'),
'</ul></code>',
'</p>',
unistr('<p><strong>\7BC4\4F8B 3:</strong> \986F\793A\542B\6709\6BCF\500B\90E8\9580\4E2D\54E1\5DE5\6578\76EE\7684\300C\54E1\5DE5\300D\5716\8868.'),
'<code><ul>',
unistr('  <li>\8868\683C\6216\8996\89C0\8868 - \9078\53D6 EMP.</li>'),
unistr('  <li>\6A19\7C64\8CC7\6599\6B04 - \9078\53D6 DEPTNO.</li>'),
unistr('  <li>\5F59\7E3D - \9078\53D6<u><strong>\8A08\6578</strong></u>.</li>'),
unistr('  <li>\503C\8CC7\6599\6B04 - \9078\53D6 EMPNO.</li>'),
'</ul></code>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625745484873686)
,p_name=>'CA.CLIENT.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F9E\5C6C\7AEF ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543519352874350)
,p_name=>'CA.CLOSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253689240873414)
,p_name=>'CA.CLOSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8655\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541576409874349)
,p_name=>'CA.COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517444676874331)
,p_name=>'CA.COLUMN.1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517540742874331)
,p_name=>'CA.COLUMN.2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504820574874321)
,p_name=>'CA.COLUMN.ALIAS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537357769874346)
,p_name=>'CA.COMMENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A3B\89E3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502544956874320)
,p_name=>'CA.COMPONENT.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5143\4EF6\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507376146874323)
,p_name=>'CA.CONFIG.ACCESS.CONTROL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\5B58\53D6\63A7\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497787611874316)
,p_name=>'CA.CONFIG.APPEARANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\5916\89C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497869396874316)
,p_name=>'CA.CONFIG.APPEARANCE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\61C9\7528\7A0B\5F0F\5916\89C0\662F\7531\4E3B\984C\6A23\5F0F\5B9A\7FA9.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501183038874319)
,p_name=>'CA.CONFIG.OPTION.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\614B\9078\9805\5DF2\66F4\65B0. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483029062874305)
,p_name=>'CA.CONFIGURATION.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\614B\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481360606874304)
,p_name=>'CA.CONFIGURATION.SETTINGS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528\6216\505C\7528\61C9\7528\7A0B\5F0F\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483122598874305)
,p_name=>'CA.CONFIGURATION.SETTINGS.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8B93\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\80FD\5920\555F\7528\6216\505C\7528\61C9\7528\7A0B\5F0F\5167\7684\7279\5B9A\529F\80FD. \9078\53D6\7684\529F\80FD\82E5\9700\8981\518D\7D93\904E\958B\767C\624D\80FD\63D0\4F9B\7D66\4E00\822C\4F7F\7528\8005\4F7F\7528, \6B64\529F\80FD\5C31\975E\5E38\5BE6\7528.<br>'),
unistr('\6B64\529F\80FD\4E5F\53EF\4EE5\62D3\5C55\81F3\61C9\7528\7A0B\5F0F\7279\5B9A\529F\80FD. \958B\767C\4EBA\54E1\82E5\5B9A\7FA9\984D\5916\7684\7D44\5EFA\9078\9805\4E26\4E14\5C07\5B83\5011\8207\61C9\7528\7A0B\5F0F\7684\7279\5B9A\529F\80FD\95DC\806F\7684\8A71, \5C31\53EF\4EE5\5C07\9019\4E9B\7D44\5EFA\9078\9805\52A0\5230\7BA1\7406\54E1\7684\7D44\614B\8A2D\5B9A\503C. \4F8B\5982, \5728\300C\5BA2\6236\8FFD\8E64\5668\5957\88DD\61C9\7528\7A0B\5F0F\300D\5167, \7BA1\7406\54E1\53EF\4EE5\958B\555F\6216\95DC\9589\50CF\806F\7D61\4EBA\3001\8CC7\6599\8F09\5165\3001\5730\7406\4F4D\7F6E\7B49\7B49\7684\529F\80FD.'),
'</p>',
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\53EF\4EE5\555F\7528\53CA\505C\7528\61C9\7528\7A0B\5F0F\529F\80FD</li>'),
unistr('<li>\5141\8A31\90E8\7F72\9078\64C7\6027\529F\80FD\7684\4F7F\7528\529F\80FD</li>'),
unistr('<li>\652F\63F4\5C07\76F8\95DC\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C\5206\7D44</li>'),
unistr('<li>\61C9\7528\7A0B\5F0F\958B\767C\4EBA\54E1\53EF\4EE5\4F7F\7528\7D44\5EFA\9078\9805\63A7\5236\5143\4EF6</li>'),
unistr('<li>\53EF\5F9E\7BA1\7406\9801\9762\57F7\884C\4E0A\8FF0\52D5\4F5C</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285620698949873682)
,p_name=>'CA.CONNECT.CREDENTIAL.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7DDA\8B49\660E\8CC7\6599\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285620793702873682)
,p_name=>'CA.CONNECT.CREDENTIAL.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7DDA\8B49\660E\8CC7\6599\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286350653671874204)
,p_name=>'CA.CONTEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\95DC\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507865245874324)
,p_name=>'CA.CONTRIBUTOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627690541873687)
,p_name=>'CA.CPU.USED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\7684 CPU')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516365324874330)
,p_name=>'CA.CREATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521469076874334)
,p_name=>'CA.CREATE.ADMIN.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7BA1\7406\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519026771874332)
,p_name=>'CA.CREATE.APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520139865874333)
,p_name=>'CA.CREATE.APP.COMP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519468003874332)
,p_name=>'CA.CREATE.APP.ICON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\5716\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520054813874333)
,p_name=>'CA.CREATE.APP.ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520225407874333)
,p_name=>'CA.CREATE.APP.PROCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\8655\7406\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286361649008874215)
,p_name=>'CA.CREATE.APP.SETTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527486969874338)
,p_name=>'CA.CREATE.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285672476851873719)
,p_name=>'CA.CREATE.APP_ROLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519608028874332)
,p_name=>'CA.CREATE.AUTH.SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6388\6B0A\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520483238874333)
,p_name=>'CA.CREATE.BLANK.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7A7A\767D\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519534229874332)
,p_name=>'CA.CREATE.BUILD.OPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7D44\5EFA\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520883092874333)
,p_name=>'CA.CREATE.CALENDAR.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\884C\4E8B\66C6\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533795936874343)
,p_name=>'CA.CREATE.CARDS.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5361\7247\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520637972874333)
,p_name=>'CA.CREATE.CHART.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5716\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521171901874333)
,p_name=>'CA.CREATE.CR.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\4E00\822C\5831\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520719015874333)
,p_name=>'CA.CREATE.DASHBOARD.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5100\8868\677F\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518992195874332)
,p_name=>'CA.CREATE.END'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541010347874348)
,p_name=>'CA.CREATE.FACETED_SEARCH.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\591A\9762\5411\641C\5C0B\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521726194874334)
,p_name=>'CA.CREATE.FEATURES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538309192874346)
,p_name=>'CA.CREATE.FILTERED.CONTENT.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7D93\904E\7BE9\9078\7684\5167\5BB9\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520510694874333)
,p_name=>'CA.CREATE.FORM.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\8868\55AE\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519166443874332)
,p_name=>'CA.CREATE.GLOBAL.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5168\57DF\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521353143874334)
,p_name=>'CA.CREATE.HOMEPAGE.NAV.LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\9996\9801\5C0E\89BD\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521220479874334)
,p_name=>'CA.CREATE.IG.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\4E92\52D5\5F0F\65B9\683C\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521087864874333)
,p_name=>'CA.CREATE.IR.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\4E92\52D5\5F0F\5831\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527149790874338)
,p_name=>'CA.CREATE.MD.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\4E3B\8981\660E\7D30\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519836329874333)
,p_name=>'CA.CREATE.NAV.BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5C0E\89BD\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523078093874335)
,p_name=>'CA.CREATE.PAGE.GROUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\9801\9762\7FA4\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521691402874334)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\7FFB\8B6F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521565684874334)
,p_name=>'CA.CREATE.PERFORM.TRANSLATION.V'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C %0 \7684\7FFB\8B6F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520994418874333)
,p_name=>'CA.CREATE.REPORT.FORM.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5831\8868\548C\8868\55AE\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527399444874338)
,p_name=>'CA.CREATE.SAVE_BLUE.PRINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\85CD\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519911282874333)
,p_name=>'CA.CREATE.SHORT.CUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6377\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286520341086874333)
,p_name=>'CA.CREATE.SIGN.IN.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\767B\5165\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518812060874332)
,p_name=>'CA.CREATE.START'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519244417874332)
,p_name=>'CA.CREATE.SUP.OBJ.SCRIPTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\652F\63F4\7269\4EF6\547D\4EE4\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519768966874332)
,p_name=>'CA.CREATE.TEXT.MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6587\5B57\8A0A\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533830361874343)
,p_name=>'CA.CREATE.TIMELINE.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6642\9593\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541205872874348)
,p_name=>'CA.CREATE.WIZARD.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7CBE\9748\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500479497874318)
,p_name=>'CA.CREATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500576945874318)
,p_name=>'CA.CREATED.BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286488984096874310)
,p_name=>'CA.CREATING.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F ...')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621398100873682)
,p_name=>'CA.CREDENTIAL.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B49\660E\8CC7\6599\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627586301873687)
,p_name=>'CA.CREDENTIAL.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B49\660E\8CC7\6599\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501039076874319)
,p_name=>'CA.CURRENT.STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522055644874334)
,p_name=>'CA.CUSTOM.QRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285719278215873752)
,p_name=>'CA.CUSTOM.THEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\81EA\8A02\4E3B\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285719397401873752)
,p_name=>'CA.CUSTOM.THEME.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5C07\7CBE\9748\5207\63DB\70BA\4F7F\7528\81EA\8A02\4E3B\984C, \800C\975E\901A\7528\4E3B\984C.</p>'),
'',
unistr('<p>\9078\53D6\61C9\7528\7A0B\5F0F\7684\5DE5\4F5C\5340\4E3B\984C. \5982\679C\4E3B\984C\652F\63F4\4E3B\984C\6A23\5F0F, \5247\540C\6642\53EF\9078\53D6\6A23\5F0F.</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388427329873512)
,p_name=>'CA.CUSTOM_THEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02\4E3B\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522687676874335)
,p_name=>'CA.DASHBOARD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\5100\8868\677F\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286349053025874202)
,p_name=>'CA.DASHBOARD.CHART.N'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522709282874335)
,p_name=>'CA.DASHBOARD.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\542B\6709\591A\500B\5716\8868\7684\5100\8868\677F\9801\9762.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
'  </ul>',
'</ul>',
'&nbsp;<br>',
unistr('<p>\6BCF\500B\5716\8868 (\5716\8868 1\3001\5716\8868 2\3001\5716\8868 3 \4EE5\53CA\5716\8868 4) \6703\6839\64DA<em>\7BC4\4F8B\8CC7\6599</em>\9810\8A2D\70BA\4E0D\540C\7684\5716\8868\985E\578B. '),
unistr('  \56E0\6B64\60A8\4E0D\9700\8981\8F38\5165\4EFB\4F55\9032\4E00\6B65\7684\8A73\7D30\8CC7\8A0A\5373\53EF\65B0\589E\6B64\9801\9762.'),
unistr('  \4F46\662F, \60A8\53EF\4EE5\5C07\9810\8A2D\503C\53D6\4EE3\70BA\81EA\5DF1\9078\64C7\7684\503C\4F86\81EA\8A02\6BCF\500B\5716\8868.<br>'),
unistr('  \82E5\8981\81EA\8A02\5716\8868, \8ACB\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\5716\8868\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\5716\8868\7684\540D\7A31.</li>'),
unistr('  <li><strong>\5716\8868\985E\578B</strong> - \9078\53D6\8981\986F\793A\7684\5716\8868\985E\578B [<strong>\5340\57DF\5716</strong>\3001<strong>\9577\689D\5716</strong>\3001<strong>\6298\7DDA\5716</strong>\3001<strong>\5713\9905\5716</strong>].</li>'),
unistr('  <li><strong>\8868\683C\6216\8996\89C0\8868</strong> (\5FC5\8981) - \9078\53D6\5716\8868\7684\8CC7\6599\5EAB\7269\4EF6.</li>'),
unistr('  <li><strong>\6A19\7C64\8CC7\6599\6B04</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\8981\4F5C\70BA\5716\8868\6A19\7C64\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\503C\805A\7E3D</strong> - \9078\53D6\503C\8CC7\6599\6B04\7684\986F\793A\6216\805A\7E3D\65B9\5F0F<br>'),
unistr('      &nbsp;&nbsp;&nbsp;[\8CC7\6599\6B04\503C\3001\7E3D\548C\3001\8A08\6578].</li>'),
unistr('  <li><strong>\503C\8CC7\6599\6B04</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7528\65BC\8A08\7B97\986F\793A\4E4B\5716\8868\503C\7684\6578\503C\8CC7\6599\6B04.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534497526874343)
,p_name=>'CA.DATATYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535563865874344)
,p_name=>'CA.DATEFORMATMASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F\683C\5F0F\906E\7F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501717008874319)
,p_name=>'CA.DEFAULT.TIME.ZONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\6642\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501865530874319)
,p_name=>'CA.DEFAULT.TIME.ZONE.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\6642\5340\5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523484264874335)
,p_name=>'CA.DEFAULTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5C6C\6027\9810\8A2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523759314874335)
,p_name=>'CA.DEFAULTS.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64 JSON \6587\4EF6\53EF\4F9B\7CBE\7D30\63A7\5236\7522\751F\7684\5831\8868\548C\8868\55AE\8CC7\6599\6B04\540D\7A31\3001\683C\5F0F\906E\7F69\7B49\7B49.  \60A8\4E5F\53EF\4EE5\5B9A\7FA9\503C\6E05\55AE\548C\5176\4ED6\5171\7528\5143\4EF6. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540828296874348)
,p_name=>'CA.DEFAULTS.LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\6E05\55AE\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540906824874348)
,p_name=>'CA.DEFAULTS.LOV.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\65B0\589E\503C\6E05\55AE (LOV) \5C6C\6027. LOV \53EF\5728\8868\683C\8CC7\6599\6B04\5B9A\7FA9\4E2D\4F7F\7528.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:'),
'  <ul>',
unistr('    <li><strong>\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\503C\6E05\55AE\7684\540D\7A31.</li>'),
unistr('    <li><strong>\985E\578B</strong> - \9078\53D6\503C\6E05\55AE\985E\578B [\7D50\69CB\5316\3001\52D5\614B\3001\975C\614B].<br>'),
unistr('      \82E5\70BA<u>\7D50\69CB\5316</u>\985E\578B - '),
'      <ul>',
unistr('          <li><strong>\8868\683C</strong> (\5FC5\8981) - \9078\53D6\503C\6E05\55AE\6240\4F9D\64DA\7684\8868\683C\6216\8996\89C0\8868.</li>'),
unistr('          <li><strong>\986F\793A\8CC7\6599\6B04</strong> (\5FC5\8981) - \9078\53D6\8981\5C0D\4E00\822C\4F7F\7528\8005\986F\793A\7684\8CC7\6599\6B04.</li>'),
unistr('          <li><strong>\7D22\5F15\9375\8CC7\6599\6B04</strong> (\5FC5\8981) - \9078\53D6\8981\50B3\56DE\7684\8CC7\6599\6B04\503C. \9019\901A\5E38\662F\8868\683C\7684\4E3B\7D22\5F15\9375.</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \82E5\70BA<u>\52D5\614B</u>\985E\578B -'),
'      <ul>',
unistr('          <li><strong>SQL \67E5\8A62</strong> (\5FC5\8981) - \8F38\5165\50B3\56DE\5169\500B\503C (\986F\793A\503C\548C\50B3\56DE\503C) \7684\6709\6548 SQL select \6558\8FF0\53E5.</li>'),
'      </ul>',
'      &nbsp;<br>',
unistr('      \82E5\70BA<u>\975C\614B</u>\985E\578B -'),
'      <ul>',
unistr('          <li><strong>\975C\614B\503C\6E05\55AE</strong> (\5FC5\8981) - \8F38\5165\683C\5F0F\5982\4E0B\7684\6709\6548\975C\614B\6E05\55AE:'),
'          <ul>',
unistr('            <li><code>STATIC2:Display1;Value1,Display2;Value2,...</code><br>\6E05\55AE\4F9D\8F38\5165\9806\5E8F\986F\793A</li>'),
unistr('            <li><code>STATIC:Display1;Value1,Display2;Value2,...</code><br>\6E05\55AE\4F9D\5B57\6BCD\9806\5E8F\6392\5217</li>'),
unistr('            <li><code>STATIC2|STATIC:Value1,Value2,...</code><br>\986F\793A\503C\8207\50B3\56DE\503C\76F8\540C</li>'),
'          </ul>',
'      </ul>',
'    </li>',
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542048546874349)
,p_name=>'CA.DEFAULTS.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542146113874349)
,p_name=>'CA.DEFAULTS.REPORT.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7DE8\8F2F\6240\6709\5831\8868\7684\5C6C\6027.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:'),
'  <ul>',
unistr('    <li><strong>\6BCF\9801\8CC7\6599\5217\6578</strong> - \8F38\5165\9810\8A2D\8981\986F\793A\7684\5831\8868\8CC7\6599\5217\6578.</li>'),
unistr('    <li><strong>\5206\9801\65B9\6CD5</strong> - \9078\53D6\986F\793A\5831\8868\5206\9801\7684\65B9\5F0F.</li>'),
unistr('    <li><strong>\6578\503C\683C\5F0F\906E\7F69</strong> - \8F38\5165\8981\5957\7528\81F3\6578\5B57\8CC7\6599\6B04\548C\9805\76EE\7684\683C\5F0F\906E\7F69.</li>'),
unistr('    <li><strong>\65E5\671F\683C\5F0F\906E\7F69</strong> - \8F38\5165\8981\5957\7528\81F3\65E5\671F\8CC7\6599\6B04\548C\9805\76EE\7684\683C\5F0F\906E\7F69.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541896676874349)
,p_name=>'CA.DEFAULTS.TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541633828874349)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C\8CC7\6599\6B04\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541793456874349)
,p_name=>'CA.DEFAULTS.TABLE.COLUMN.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7DE8\8F2F\6240\9078\8868\683C\8CC7\6599\6B04\7684\5C6C\6027.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:'),
'  <ul>',
unistr('    <li><strong>\8868\683C</strong> (\50C5\4F9B\986F\793A) - \95DC\806F\7684\8868\683C.</li>'),
unistr('    <li><strong>\8CC7\6599\6B04</strong> (\50C5\4F9B\986F\793A) - \70BA\5176\5B9A\7FA9\5C6C\6027\7684\8CC7\6599\6B04.</li>'),
unistr('    <li><strong>\6A19\7C64</strong> - \8F38\5165\5831\8868\6A19\984C\548C\8868\55AE\6A19\7C64\4E2D\6240\8981\4F7F\7528\7684\6A19\7C64.</li>'),
unistr('    <li><strong>\8868\55AE\63A7\5236\9805</strong> - \9078\53D6\8868\55AE\8981\4F7F\7528\7684\9805\76EE\985E\578B.</li>'),
unistr('    <li><strong>\503C\6E05\55AE</strong> - \9078\53D6\8981\7528\4F86\9069\7576\5730\986F\793A\4F7F\7528\8005\6613\8A18\540D\7A31\7684\73FE\6709\503C\6E05\55AE.</li>'),
unistr('    <li><strong>\683C\5F0F\906E\7F69</strong> - \6839\64DA\8CC7\6599\6B04\985E\578B (\6587\5B57\3001\6578\5B57\3001\65E5\671F\7B49) \8F38\5165\9069\7576\7684\683C\5F0F\906E\7F69.</li>'),
unistr('    <li><strong>\975C\614B\9810\8A2D\503C</strong> - \8F38\5165\8CC7\6599\6B04\7684\6587\5B57\9810\8A2D\503C.</li>'),
unistr('    <li><strong>\5305\62EC\5728\8868\55AE\4E0A</strong> - \8868\55AE\82E5\61C9\8A72\5305\542B\6B64\8CC7\6599\6B04, \8ACB\6309\4E00\4E0B\300C\662F\300D.</li>'),
unistr('    <li><strong>\5305\62EC\5728\5831\8868\4E0A</strong> - \5831\8868\82E5\61C9\8A72\5305\542B\6B64\8CC7\6599\6B04, \8ACB\6309\4E00\4E0B\300C\662F\300D.</li>'),
unistr('    <li><strong>\5FC5\8981</strong> - \5982\679C\5FC5\9808\5728\8868\55AE\7684\9019\500B\8CC7\6599\6B04\4E2D\8F38\5165\8CC7\6599, \8ACB\6309\4E00\4E0B\300C\662F\300D.</li>'),
unistr('    <li><strong>\8AAA\660E</strong> - \8F38\5165\65B0\589E\81F3\9805\76EE\8AAA\660E\5C6C\6027\7684\8AAA\660E\6587\5B57.</li>'),
'  </ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541929569874349)
,p_name=>'CA.DEFAULTS.TABLE.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7DE8\8F2F\6240\9078\8868\683C\7684\5C6C\6027.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:'),
'  <ul>',
unistr('    <li><strong>\8868\683C</strong> (\50C5\4F9B\986F\793A) - \95DC\806F\7684\8868\683C.</li>'),
unistr('    <li><strong>\6A19\7C64 (\55AE\6578)</strong> (\5FC5\8981) - \8F38\5165\8981\5728\8868\55AE\9801\9762\4E0A\4F7F\7528\7684\6A19\7C64.</li>'),
unistr('    <li><strong>\6A19\7C64 (\8907\6578)</strong> (\5FC5\8981) - \8F38\5165\8981\5728\5340\57DF\6A19\984C\548C\9801\9762\540D\7A31\4E2D\4F7F\7528\7684\6A19\7C64.</li>'),
unistr('    <li><strong>\4E3B\8981\986F\793A\8CC7\6599\6B04</strong> - \9078\53D6\8981\986F\793A\7684\7B2C\4E00\500B\8CC7\6599\6B04, \4F8B\5982\5728\5361\7247\5340\57DF\4E2D.</li>'),
unistr('    <li><strong>\6B21\8981\986F\793A\8CC7\6599\6B04</strong> - \9078\53D6\8981\986F\793A\7684\7B2C\4E8C\500B\8CC7\6599\6B04, \4F8B\5982\5728\5361\7247\5340\57DF\4E2D.</li>'),
unistr('    <li><strong>\4E3B\7D22\5F15\9375\8CC7\6599\6B04</strong> - \9078\53D6\8868\683C\7684\552F\4E00\4E3B\7D22\5F15\9375\8CC7\6599\6B04.</li>'),
unistr('    <li><strong>\63CF\8FF0</strong> - \8F38\5165\8868\683C\7684\63CF\8FF0.</li>'),
'  </ul>',
'</p>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621189854873682)
,p_name=>'CA.DEFERRED.DROP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EF6\7DE9\7684\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536127534874345)
,p_name=>'CA.DEFINITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B9A\7FA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518747695874332)
,p_name=>'CA.DEINSTALL.COMPLETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89E3\9664\5B89\88DD\5B8C\6210.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499037271874317)
,p_name=>'CA.DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518374614874331)
,p_name=>'CA.DELETE.CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484608868874306)
,p_name=>'CA.DELETE.PAGE.CONFIRM.MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\5B9A\8981\522A\9664\6B64\9801\9762\55CE?')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508844659874324)
,p_name=>'CA.DELETE.PHOTO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\76F8\7247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499744476874318)
,p_name=>'CA.DESCRIPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63CF\8FF0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516911043874330)
,p_name=>'CA.DESKTOP.NAVIGATION.BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\684C\9762\5C0E\89BD\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516847914874330)
,p_name=>'CA.DESKTOP.NAVIGATION.MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\684C\9762\5C0E\89BD\529F\80FD\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498090973874316)
,p_name=>'CA.DESKTOP.THEME.STYLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\684C\9762\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498135525874316)
,p_name=>'CA.DESKTOP.THEME.STYLE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\4E3B\984C\6A23\5F0F\6703\5957\7528\81F3\6240\6709\4F7F\7528\8005.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621518082873683)
,p_name=>'CA.DESTINATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\7684\5730')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621630815873683)
,p_name=>'CA.DESTINATION.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\7684\5730\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388521000873512)
,p_name=>'CA.DIALOG.BUTTONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0D\8A71\65B9\584A\6309\9215')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513355416874328)
,p_name=>'CA.DISPATCH.EMAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\767C\9001\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532978907874342)
,p_name=>'CA.DISPATCH.EMAILS.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C7A\5B9A\662F\5426\61C9\5F9E\96FB\5B50\90F5\4EF6\67B6\69CB\9001\51FA\96FB\5B50\90F5\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499528557874317)
,p_name=>'CA.DISPLAY.FROM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\81EA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499437156874317)
,p_name=>'CA.DISPLAY.SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499676228874318)
,p_name=>'CA.DISPLAY.UNTIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\81F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534650103874344)
,p_name=>'CA.DISPLAYCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503146472874320)
,p_name=>'CA.DISTINCT .USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\540C\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516445403874330)
,p_name=>'CA.DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\8F09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523338605874335)
,p_name=>'CA.DRAG.TO.REORDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\62D6\66F3\4EE5\91CD\65B0\6392\5217\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409871863873527)
,p_name=>'CA.DRILL.DOWN.LINK'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr('  <li><strong>\5411\4E0B\5C55\958B\9023\7D50</strong> - \5C55\958B\5373\53EF\67E5\770B\7528\65BC\5B9A\7FA9\5411\4E0B\5C55\958B\9023\7D50\7684\5C6C\6027.'),
'&nbsp;<br>',
unistr('    <em><strong>\6CE8\610F:</strong> \76EE\524D\7684\9801\9762\662F\4EE5\8868\683C\6216\8996\89C0\8868\70BA\57FA\790E\4E14\5831\8868\985E\578B\70BA\300C\4E92\52D5\5F0F\5831\8868\300D, \540C\6642\60A8\5DF2\5B9A\7FA9\5831\8868 (\4E92\52D5\5F0F\5831\8868) \6216\4E3B\8981\660E\7D30 (\4E3B\8981\660E\7D30) \9801\9762\6642, \624D\6703\986F\793A\5411\4E0B\5C55\958B\9023\7D50.</em>'),
'  <ul>',
unistr('    <li><strong>\9023\7D50\8CC7\6599\6B04</strong> - \9078\53D6\5728\5831\8868\4E2D\5C07\8B8A\6210\9023\7D50\8CC7\6599\6B04\7684\8CC7\6599\6B04.</li>'),
unistr('    <li><strong>\9023\7D50\7D22\5F15\9375</strong> - \9078\53D6\9023\7D50\7D22\5F15\9375 (\5916\4F86\7D22\5F15\9375) \8CC7\6599\6B04, \7528\4EE5\8B58\5225\9023\7D50\76EE\6A19\9801\9762\4E2D\7684\7279\5B9A\8A18\9304.</li>'),
unistr('    <li><strong>\9023\7D50\81F3\9801\9762</strong> - \9078\53D6\9023\7D50\7684\5C0E\89BD\76EE\6A19\5831\8868\6216\8868\55AE\9801\9762.</li>'),
unistr('    <li><strong>\76EE\6A19\7D22\5F15\9375</strong> - \5F9E\9023\7D50\7684\5C0E\89BD\76EE\6A19\6216\4F5C\70BA\57FA\790E\7684\5831\8868\9801\9762\8868\683C\9078\53D6\76EE\6A19\7D22\5F15\9375 (\4E3B\7D22\5F15\9375) \8CC7\6599\6B04.'),
'  </ul>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502227330874320)
,p_name=>'CA.ELAPSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D93\6B77\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484841264874306)
,p_name=>'CA.EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\67B6\69CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532562175874342)
,p_name=>'CA.EMAIL.ADDRESSES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542509246874349)
,p_name=>'CA.EMAIL.DEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484738822874306)
,p_name=>'CA.EMAIL.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8A2D\5B9A\53CA\50B3\9001\96FB\5B50\90F5\4EF6\7684\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484961075874307)
,p_name=>'CA.EMAIL.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\542B\62EC\5F9E\60A8\7684\61C9\7528\7A0B\5F0F\50B3\9001\96FB\5B50\90F5\4EF6\7684\529F\80FD. \53EF\4F7F\7528\96FB\5B50\90F5\4EF6\7BC4\4F8B\6A23\677F, \50B3\9001\5C08\696D\7684\96FB\5B50\90F5\4EF6\7D66\4F7F\7528\8005. \50B3\9001\7684\96FB\5B50\90F5\4EF6\90FD\6703\8A18\9304\4E0B\4F86, \8B93\7BA1\7406\54E1\80FD\5920\8FFD\8E64\96FB\5B50\90F5\4EF6\6D3B\52D5.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\53EF\64F4\5145\7684 HTML \96FB\5B50\90F5\4EF6\6A23\677F\7CFB\7D71</li>'),
unistr('<li>\53EF\900F\904E APEX \5957\88DD\7A0B\5F0F\50B3\9001\90F5\4EF6\7684 PL/SQL \5957\88DD\7A0B\5F0F</li>'),
unistr('<li>\96FB\5B50\90F5\4EF6\6D3B\52D5\548C\72C0\614B\7684\8A18\9304\529F\80FD</li>'),
unistr('<li>\7BA1\7406\6A23\677F\7684\7BA1\7406 UI</li>'),
unistr('<li>\6AA2\8996\96FB\5B50\90F5\4EF6\65E5\8A8C\7684\7BA1\7406 UI</li>'),
unistr('<li>\50B3\9001\96FB\5B50\90F5\4EF6\7684\7BA1\7406 UI</li>'),
'</ul>',
'</p>',
unistr('<p><em>\6CE8\610F: \9078\53D6\300C\610F\898B\56DE\994B\300D\6642\624D\6703\555F\7528\6B64\529F\80FD</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538225352874346)
,p_name=>'CA.EMAIL.FROM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\5BC4\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512304145874327)
,p_name=>'CA.EMAIL.LOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\65E5\8A8C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543165413874350)
,p_name=>'CA.EMAIL.P10940.EMAIL.DETAILS.REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\8F38\5165\96FB\5B50\90F5\4EF6\8A2D\5B9A\503C\8A73\7D30\8CC7\8A0A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542681478874349)
,p_name=>'CA.EMAIL.P10940.EMAILS.FROM.INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5BC4\4EF6\8005\5730\5740\300D\4E0D\662F\6709\6548\7684\96FB\5B50\90F5\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534105178874343)
,p_name=>'CA.EMAIL.P11030.EMAILS.FROM.INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5BC4\4EF6\8005\5730\5740\300D\4E0D\662F\6709\6548\7684\96FB\5B50\90F5\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533338335874343)
,p_name=>'CA.EMAIL.PROCESSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\5DF2\8655\7406.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488579301873585)
,p_name=>'CA.EMAIL.REPORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285674389853873721)
,p_name=>'CA.EMAIL.REPORTING.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\6392\5165\4F47\5217\7B49\5F85\50B3\9001\53CA\5DF2\7D93\50B3\9001\7684\6240\6709\96FB\5B50\90F5\4EF6\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513252598874328)
,p_name=>'CA.EMAIL.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513668272874328)
,p_name=>'CA.EMAIL.SETTINGS.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\8A2D\5B9A\503C\5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538698207874347)
,p_name=>'CA.EMAIL.STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513711132874328)
,p_name=>'CA.EMAIL.TEMPLATE.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\6A23\677F\8A73\7D30\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286025449489873963)
,p_name=>'CA.EMAIL.TEMPLATE.SUBJECT_EXAMPLE.SO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5B9A\7684 #SERVICE_NAME# \505C\6A5F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285726857359873757)
,p_name=>'CA.EMAIL2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512238641874327)
,p_name=>'CA.EMAILS.SENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\7684\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542771696874350)
,p_name=>'CA.ENABLE.ATTACHMENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528\9644\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626639216873686)
,p_name=>'CA.ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623880176873684)
,p_name=>'CA.END.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\675F\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514366831874328)
,p_name=>'CA.END.ROW.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\4E4B\5F8C\5167\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530488372874340)
,p_name=>'CA.ENTER.USERNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\6B64\8655\8F38\5165\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502886872874320)
,p_name=>'CA.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505180744874322)
,p_name=>'CA.ERROR.BACKTRACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4\8FFD\8E64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505070098874322)
,p_name=>'CA.ERROR.CODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4\4EE3\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504359649874321)
,p_name=>'CA.ERROR.MESSAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4\8A0A\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628339045873688)
,p_name=>'CA.ERROR.NUMBER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4\7DE8\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627369406873687)
,p_name=>'CA.ERRORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624299541873685)
,p_name=>'CA.EVENT.CONDITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624361158873685)
,p_name=>'CA.EVENT.QUEUE.AGENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\4F47\5217\4EE3\7406\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624414905873685)
,p_name=>'CA.EVENT.QUEUE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\4F47\5217\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624592107873685)
,p_name=>'CA.EVENT.QUEUE.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\4F47\5217\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624197962873685)
,p_name=>'CA.EVENT.RULE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E8B\4EF6\898F\5247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530726464874341)
,p_name=>'CA.EXCEPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7570\5E38\72C0\6CC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543602504874350)
,p_name=>'CA.EXPERIENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D93\9A57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626337301873686)
,p_name=>'CA.FAILURE.COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5931\6557\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500824719874318)
,p_name=>'CA.FEATURE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280891757874151)
,p_name=>'CA.FEATURE.ABOUT_PAGE.APP_VERSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\7248\672C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280963858874151)
,p_name=>'CA.FEATURE.ABOUT_PAGE.PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772890975873788)
,p_name=>'CA.FEATURE.ACL.ADD_USERS_TO_ACL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\4F7F\7528\8005\65B0\589E\81F3\5B58\53D6\63A7\5236\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772691639873788)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.ADD.NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D\5F80\4E0B\4E00\6B65')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772743149873788)
,p_name=>'CA.FEATURE.ACL.MULTIPLE_USER.CREATE_COLLECTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\96C6\5408')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772501311873788)
,p_name=>'CA.FEATURE.ACL.USER.EDIT.CANNOT_CHANGE_LAST_ADMIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\8B8A\66F4\6700\5F8C\4E00\500B\7BA1\7406\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280510287874151)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.LAST_ACTIVITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\6B21\6D3B\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772321533873788)
,p_name=>'CA.FEATURE.ACTIVITY_REPORT.NO_ACTIVITY_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\6D3B\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280712587874151)
,p_name=>'CA.FEATURE.EXCEPTION.REASON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\539F\56E0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772909523873788)
,p_name=>'CA.FEATURE.FEEDBACK.AT_LEAST_ONE_REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81F3\5C11\8981\6709\4E00\9805\610F\898B\56DE\994B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773287342873788)
,p_name=>'CA.FEATURE.FEEDBACK.GET_FILE_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\5F97\6A94\6848 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771865960873787)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771991283873788)
,p_name=>'CA.FEATURE.THEME_STYLE.SAVE_USER_PREF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5132\5B58\4E00\822C\4F7F\7528\8005\6A23\5F0F\504F\597D\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280615597874151)
,p_name=>'CA.FEATURE.USERNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489040277874310)
,p_name=>'CA.FEATURES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489150840874310)
,p_name=>'CA.FEATURES.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\529F\80FD\300D\63D0\4F9B\61C9\7528\7A0B\5F0F\5C64\6B21\529F\80FD, \800C\4E14\901A\5E38\53EA\80FD\5728\61C9\7528\7A0B\5F0F\5167\65B0\589E\4E00\6B21. \8ACB\9078\64C7\61C9\7528\7A0B\5F0F\8981\5305\62EC\7684\529F\80FD.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482978169874305)
,p_name=>'CA.FEEDBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\610F\898B\56DE\994B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286480942751874303)
,p_name=>'CA.FEEDBACK.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4F7F\7528\8005\63D0\4F9B\610F\898B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482894920874305)
,p_name=>'CA.FEEDBACK.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\63D0\4F9B\4E00\822C\4F7F\7528\8005\5C07\4E00\822C\8A3B\89E3\53CD\61C9\7D66\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\548C\958B\767C\4EBA\54E1\6642\6240\63A1\7528\7684\6A5F\5236. \5F35\8CBC\9805\76EE\5305\62EC\6709\7528\7684\968E\6BB5\4F5C\696D\72C0\614B\8CC7\8A0A, \53EF\5E6B\52A9\5224\65B7\4E00\822C\4F7F\7528\8005\5F9E\4F55\8655\50B3\9001\610F\898B\56DE\994B. \63D0\4F9B\9019\6A23\65B9\4FBF\7684\610F\898B\56DE\994B\7BA1\9053, \52A0\5F37\4E86\4F7F\7528\8005\793E\7FA4\8207\61C9\7528\7A0B\5F0F\64C1\6709\8005\4E4B\9593\7684\6E9D\901A, \85C9\6B64\4FC3\9032\4E00\822C\4F7F\7528\8005\7684\6EFF\610F\5EA6.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\4E00\822C\4F7F\7528\8005\6309\4E00\4E0B\5C0E\89BD\5217\5716\793A\5373\53EF\7559\4E0B\610F\898B\56DE\994B\7684\529F\80FD</li>'),
unistr('<li>\6AA2\8996\8207\66F4\65B0\610F\898B\56DE\994B\7684\7BA1\7406\5831\8868</li>'),
unistr('<li>\610F\898B\56DE\994B\6703\64F7\53D6\4F7F\7528\8005\3001\65E5\671F\548C\6642\9593\53CA\4F7F\7528\8005\4EE3\7406\7A0B\5F0F\8CC7\8A0A</li>'),
'</ul>',
'</p>'))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286544095131874350)
,p_name=>'CA.FEEDBACK.OR_EXPERIENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\63D0\4F9B\610F\898B\56DE\994B\6216\60A8\7684\7D93\9A57.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543070916874350)
,p_name=>'CA.FEEDBACK.RECIPIENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6536\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542447880874349)
,p_name=>'CA.FEEDBACK.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\610F\898B\56DE\994B\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510356744874325)
,p_name=>'CA.FEEDBACK.SETTINGS.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\610F\898B\56DE\994B\8A2D\5B9A\503C\5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543200653874350)
,p_name=>'CA.FEEDBACK.SUBMITTED.SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9001\51FA\610F\898B\56DE\994B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623968538873684)
,p_name=>'CA.FILE.WATCHER.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A94\6848\76E3\8996\5668\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624055658873684)
,p_name=>'CA.FILE.WATCHER.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A94\6848\76E3\8996\5668\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285279172951873432)
,p_name=>'CA.FILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\63D0\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285279288838873433)
,p_name=>'CA.FILED.BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\51FA\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538768141874347)
,p_name=>'CA.FILTER.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514709535874329)
,p_name=>'CA.FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541406649874349)
,p_name=>'CA.FINISH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509067762874324)
,p_name=>'CA.FIRST.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285620970497873682)
,p_name=>'CA.FLAGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65D7\6A19')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490489281874311)
,p_name=>'CA.FORM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8868\55AE\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490376629874311)
,p_name=>'CA.FORM.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\8868\55AE\9801\9762\7684\9801\9762, \8B93\4E00\822C\4F7F\7528\8005\53EF\4EE5\7DAD\8B77\8CC7\6599.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\8868\683C</strong> (\5FC5\8981) - \9078\53D6\8868\55AE\7684\8868\683C.</li>'),
unistr('<li><strong>\5305\62EC\5831\8868</strong> (\5FC5\8981) - \9078\53D6\6B64\9078\9805\5373\53EF\5EFA\7ACB\5831\8868\548C\8868\55AE. \7B2C\4E00\9801\6703\662F\4E92\52D5\5F0F\5831\8868. \6BCF\500B\8CC7\6599\5217\90FD\6703\6709\8868\55AE\9023\7D50, \8B93\4F7F\7528\8005\53EF\66F4\65B0\8A18\9304. </li>'),
'  &nbsp;<br>',
unistr('<li><strong>\9032\968E</strong> - \5C55\958B\5373\53EF\67E5\770B\9032\968E\9078\9805.'),
'     <ul>',
unistr('      <li><strong>\9801\9762\8AAA\660E</strong> - \8F38\5165\8981\65B0\589E\81F3\9801\9762\8AAA\660E\5167\5BB9\4E2D\7684\6587\5B57.</li>'),
'      </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285408844453873527)
,p_name=>'CA.FORM.ITEM.REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\9805\76EE\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516646744874330)
,p_name=>'CA.FORM.ON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \76F8\95DC\8868\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530294846874340)
,p_name=>'CA.FORM.TYPE.NOT.VALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\8868\55AE\985E\578B\4E0D\662F\4E00\500B\6709\6548\7684\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536600140874345)
,p_name=>'CA.FORMATMASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\683C\5F0F\906E\7F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535612908874344)
,p_name=>'CA.FORMCONTROL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\63A7\5236\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500289284874318)
,p_name=>'CA.FROM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513455723874328)
,p_name=>'CA.FROM.ADDRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC4\4EF6\8005\5730\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538120396874346)
,p_name=>'CA.FROM.ADDRESS.EMAIL.SETTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\5BC4\4EF6\8005\5730\5740\300D\96FB\5B50\90F5\4EF6\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534020389874343)
,p_name=>'CA.FROM.EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC4\4EF6\8005\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533905295874343)
,p_name=>'CA.FROM.WHO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC4\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286282799199874153)
,p_name=>'CA.FS.SEARCH.TABLE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503745931874321)
,p_name=>'CA.FULL.PAGE.VIEWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6574\9801\9762\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512409602874327)
,p_name=>'CA.FULL.TEMPLATE.HTML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6574\6A23\677F HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535171129874344)
,p_name=>'CA.FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483393839874305)
,p_name=>'CA.GLOBAL.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\57DF\641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481131293874303)
,p_name=>'CA.GLOBAL.SEARCH.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\61C9\7528\7A0B\5F0F\641C\5C0B\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483256471874305)
,p_name=>'CA.GLOBAL.SEARCH.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8A31\4F7F\7528\8005\641C\5C0B\61C9\7528\7A0B\5F0F\5167\7D22\5F15\9375\8868\683C\6216\8996\89C0\8868\4E2D\7684\6587\5B57. \9032\968E\641C\5C0B\9801\9762\5305\62EC\7BE9\9078, \65B9\4FBF\4F7F\7528\8005\7E2E\5C0F\641C\5C0B\7D50\679C.<br>'),
unistr('\9019\9805\5F37\5927\7684\529F\80FD\9700\8981\9032\4E00\6B65\7684\958B\767C\624D\80FD\5B9A\7FA9 SQL (\6839\64DA\63D0\4F9B\7684\7BC4\4F8B).</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\5728\6A19\982D\5217\986F\793A\641C\5C0B\5716\793A</li>'),
unistr('<li>\5305\62EC\5177\6709\5074\908A\5217\7BE9\9078\7684\8A73\7D30\8CC7\8A0A\641C\5C0B\7D50\679C\9801\9762</li>'),
unistr('<li>\9700\8981\958B\767C\4EBA\54E1\5BE6\884C\5B9A\7FA9\61C9\7528\7A0B\5F0F\641C\5C0B\7684 SQL</li>'),
unistr('<li>\542B\6709\8AAA\660E\7528\7684\7BC4\4F8B\8CC7\6599</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625609797873686)
,p_name=>'CA.GLOBAL.UID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\57DF\552F\4E00 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771486261873787)
,p_name=>'CA.GLOBAL_PAGE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\57DF\9801\9762 - \684C\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388681312873512)
,p_name=>'CA.GO.TO.ADMIN.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D\5F80\7BA1\7406\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489934165874310)
,p_name=>'CA.GRID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\4E92\52D5\5F0F\65B9\683C\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286490068077874310)
,p_name=>'CA.GRID.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\70BA\4E92\52D5\5F0F\65B9\683C\7684\9801\9762, \9019\8207\8A66\7B97\8868\76F8\4F3C. \5982\679C\53EF\7DE8\8F2F, \4F7F\7528\8005\5C31\53EF\76F4\63A5\5728\9801\9762\4E0A\7DE8\8F2F\591A\500B\8CC7\6599\5217 (\4EA6\5373\555F\7528\300C\5141\8A31\7DE8\8F2F\300D).</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\67E5\8A62\985E\578B</strong> - \9078\53D6\5831\8868\7684\4F86\6E90 [<strong>\8868\683C\6216\8996\89C0\8868</strong>\6216 <strong>SQL \67E5\8A62</strong>].<br>'),
unistr('    <strong>\8868\683C\6216\8996\89C0\8868</strong>:'),
'    <ul>',
unistr('      <li><strong>\8868\683C\6216\8996\89C0\8868</strong> (\5FC5\8981) - \9078\53D6\65B9\683C\7684\8CC7\6599\5EAB\7269\4EF6.</li>'),
'    </ul>',
unistr('    <strong>SQL \67E5\8A62</strong>:'),
'    <ul>',
unistr('      <li><strong>SQL \67E5\8A62</strong> (\5FC5\8981) - \8F38\5165\50B3\56DE\4E0D\540C\8CC7\6599\6B04\7684\6709\6548 SQL \6558\8FF0\53E5.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\65B9\683C\985E\578B</strong> - \9078\53D6\4F7F\7528\8005\662F\5426\80FD\5728\65B9\683C\4E2D\7DE8\8F2F\8CC7\6599\5217 [<strong>\5141\8A31\7DE8\8F2F</strong>\6216<strong>\552F\8B80</strong>]. \82E5\8981\555F\7528\7DE8\8F2F, \8ACB\9078\53D6<strong>\5141\8A31\7DE8\8F2F</strong>.</li>'),
'  &nbsp;<br>',
unistr('  <em><strong>\8B66\544A:</strong> \5982\679C\9078\53D6\7684\67E5\8A62\985E\578B\662F <strong>SQL \67E5\8A62</strong>, \52A0\4E0A\65B9\683C\985E\578B\70BA<strong>\5141\8A31\7DE8\8F2F</strong>, \800C\4E14\60A8\7684\67E5\8A62\7D50\5408\4E86\5169\500B\6216\66F4\591A\8868\683C\7684\8A71, \7576\4F7F\7528\8005\5617\8A66\53CA\66F4\65B0\8A18\9304\6642, \7522\751F\7684\4E92\52D5\5F0F\65B9\683C\5C07\6703\5931\6557.'),
unistr('\6B64\5916, \5982\679C\9078\53D6\7684\65B9\683C\985E\578B\662F<strong>\5141\8A31\7DE8\8F2F</strong>, \4E14\67E5\8A62 (\6216\9078\53D6\4E86\8868\683C\6216\8996\89C0\8868) \4F7F\7528\7684\8996\89C0\8868\7121\6CD5\66F4\65B0\7684\8A71, \7576\4F7F\7528\8005\5617\8A66\53CA\66F4\65B0\8A18\9304\6642, \7522\751F\7684\4E92\52D5\5F0F\65B9\683C\4E5F\5C07\6703\5931\6557.</em><br>'),
'  </li>',
'</ul>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515254753874329)
,p_name=>'CA.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8AAA\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507630901874323)
,p_name=>'CA.HELP.ALLOW.OTHER.USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\679C\5B58\53D6\63A7\5236\6E05\55AE\6703\5B9A\7FA9\6240\6709\4F7F\7528\8005, \8ACB\9078\64C7<strong>\5426</strong>; \5982\679C\6709\4E0D\5728\5B58\53D6\63A7\5236\6E05\55AE\7684\4F7F\7528\8005, \4F46\6703\4F7F\7528\6B64\61C9\7528\7A0B\5F0F\8005, \8ACB\9078\64C7<strong>\662F</strong>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501349852874319)
,p_name=>'CA.HELP.APP.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6574\500B\61C9\7528\7A0B\5F0F\90FD\6703\4F7F\7528\6B64\8655\8F38\5165\7684\6587\5B57, \5C24\5176\662F\51FA\73FE\5728\6BCF\500B\9801\9762\7684\5DE6\4E0A\89D2\8655. \6B64\8B8A\66F4\6703\5728\7BA1\7406\54E1\5B8C\6210\8B8A\66F4\6642\7ACB\5373\751F\6548, \4F46\5176\4ED6\4F7F\7528\8005\53EA\6703\5728\9032\884C\65B0\7684\968E\6BB5\4F5C\696D (\4F8B\5982\4E0B\6B21\767B\5165\6642) \6642\770B\5230\9019\500B\8B8A\66F4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495960674874315)
,p_name=>'CA.HELP.HOME.FEEDBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\5728\61C9\7528\7A0B\5F0F\7684\4EFB\4F55\9801\9762\4E2D, \6309\4E00\4E0B\5C0E\89BD\5217\7684\300C\610F\898B\56DE\994B\300D\5716\793A ( <span class="fa fa-comment-o" aria-hidden="true"></span> ), \5373\53EF\7559\4E0B\8981\7D66\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\7684\610F\898B\56DE\994B.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495617316874315)
,p_name=>'CA.HELP.HOME.MAIN.SIDE.MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\9019\662F\61C9\7528\7A0B\5F0F\7684\9996\9801. \60A8\53EF\4EE5\6309\4E00\4E0B\5361\7247\6216\4F7F\7528\9801\9762\5074\908A\7684\5C0E\89BD\529F\80FD\8868, \4F86\5B58\53D6\61C9\7528\7A0B\5F0F\7684\4E0D\540C\9801\9762.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495892427874315)
,p_name=>'CA.HELP.HOME.MAIN.TOP.MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\9019\662F\61C9\7528\7A0B\5F0F\7684\9996\9801. \60A8\53EF\4EE5\6309\4E00\4E0B\5361\7247\6216\4F7F\7528\9801\9762\9802\7AEF\7684\5C0E\89BD\529F\80FD\8868, \4F86\5B58\53D6\61C9\7528\7A0B\5F0F\7684\4E0D\540C\9801\9762.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496093122874315)
,p_name=>'CA.HELP.HOME.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\5728\6B64\9801\9762\7684<strong>\641C\5C0B\61C9\7528\7A0B\5F0F</strong>\6B04\4F4D\8F38\5165\641C\5C0B\8A5E, \6216\5728\4EFB\4F55\9801\9762\6309\4E00\4E0B\5C0E\89BD\5217\4E0A\7684\300C\641C\5C0B\300D\5716\793A ( <span class="fa fa-search" aria-hidden="true"></span> ), \5373\53EF\641C\5C0B\61C9\7528\7A0B\5F0F\4E2D\7684\5B57\8A5E.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496321422874315)
,p_name=>'CA.HELP.HOME.SIGN.OUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6309\4E00\4E0B\5C0E\89BD\5217\4E0A\7684\540D\7A31\4E0B\62C9\5F0F\6E05\55AE, \5373\53EF\767B\51FA\61C9\7528\7A0B\5F0F.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496230165874315)
,p_name=>'CA.HELP.HOME.TIME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6309\4E00\4E0B\5C0E\89BD\5217\4E2D\7684\4F7F\7528\8005\529F\80FD\8868 ( <span class="fa fa-user" aria-hidden="true"></span> ), \5373\53EF\66F4\65B0\6642\5340\504F\597D\8A2D\5B9A\53CA\767B\51FA\61C9\7528\7A0B\5F0F.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495734415874315)
,p_name=>'CA.HELP.HOME.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9996\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496415573874315)
,p_name=>'CA.HELP.HOME.USER'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6309\4E00\4E0B\9801\9762\53F3\4E0A\89D2\5C0E\89BD\5217\4E2D\7684\4F7F\7528\8005\529F\80FD\8868 ( <span class="fa fa-user" aria-hidden="true"></span> ), \5373\53EF\5B58\53D6\4F7F\7528\8005\8A2D\5B9A\6A94\53CA\767B\51FA\61C9\7528\7A0B\5F0F.<br>'),
unistr('\4F9D\5E8F\6309\4E00\4E0B<strong>\6AA2\8996\6211\7684\8A2D\5B9A\6A94</strong>\548C<strong>\66F4\65B0\8A2D\5B9A\6A94</strong>, \5373\53EF\8F38\5165\500B\4EBA\8A73\7D30\8CC7\8A0A\53CA\4E0A\50B3\76F8\7247\6216\5927\982D\8CBC.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496165733874315)
,p_name=>'CA.HELP.HOME.USER.TIME'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6309\4E00\4E0B\5C0E\89BD\5217\4E2D\7684\4F7F\7528\8005\529F\80FD\8868 ( <span class="fa fa-user" aria-hidden="true"></span> ), \5373\53EF\5B58\53D6\60A8\7684\4F7F\7528\8005\8A2D\5B9A\6A94\3001\66F4\65B0\6642\5340\504F\597D\8A2D\5B9A\53CA\767B\51FA\61C9\7528\7A0B\5F0F.<br>'),
unistr('\4F9D\5E8F\6309\4E00\4E0B<strong>\6AA2\8996\6211\7684\8A2D\5B9A\6A94</strong>\548C<strong>\66F4\65B0\8A2D\5B9A\6A94</strong>, \5373\53EF\8F38\5165\500B\4EBA\8A73\7D30\8CC7\8A0A\53CA\4E0A\50B3\76F8\7247\6216\5927\982D\8CBC.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522273432874334)
,p_name=>'CA.HELP.IG.PAGE.READONLY'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5C0B\627E\8CC7\6599, \8ACB\5728\300C\641C\5C0B\300D\5C0D\8A71\65B9\584A\4E2D\8F38\5165\641C\5C0B\8A5E; \60A8\4E5F\53EF\4EE5\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C\4F86\9650\5236\50B3\56DE\7684\8A18\9304.</p>'),
'',
unistr('<p>\6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215\53EF\57F7\884C\591A\7A2E\529F\80FD, \5305\62EC\9078\53D6\986F\793A / \96B1\85CF\7684\8CC7\6599\6B04, \53CA\5176\986F\793A\9806\5E8F\8207\57F7\884C\591A\7A2E\8CC7\6599\8207\683C\5F0F\529F\80FD.  \60A8\9084\53EF\4EE5\4F7F\7528\5716\8868\9078\9805\5B9A\7FA9\8CC7\6599\7684\5176\4ED6\6AA2\8996.</p>'),
'',
unistr('<p>\82E5\8981\5132\5B58\81EA\8A02\9805\76EE, \8ACB\9078\53D6\300C\5831\8868\300D; \60A8\4E5F\53EF\4EE5\6309\4E00\4E0B\300C\4E0B\8F09\300D\4F86\5378\8F09\8CC7\6599.<p>'),
'<br>',
unistr('<p>\5982\9700\5176\4ED6\8CC7\8A0A, \8ACB\6309\4E00\4E0B\300C\52D5\4F5C\300D\529F\80FD\8868\5E95\90E8\7684\300C\8AAA\660E\300D.</p>'),
'',
unistr('<p>\6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215\5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522195554874334)
,p_name=>'CA.HELP.IG.PAGE.UPDATABLE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\76F4\63A5\5728\6B64\4E92\52D5\5F0F\65B9\683C\5167\63D2\5165\3001\66F4\65B0\53CA\522A\9664\8CC7\6599.<br>'),
unistr('  \82E5\8981\63D2\5165\65B0\8CC7\6599\5217, \8ACB\6309\4E00\4E0B\300C\65B0\589E\8CC7\6599\5217\300D\6309\9215.<br>'),
unistr('  \5728\5132\5B58\683C\4E2D\6309\5169\4E0B\6216\6309\4E00\4E0B<strong>\7DE8\8F2F</strong>\6309\9215, \5373\53EF\66F4\65B0\8CC7\6599\503C, \65B9\6CD5\8207\5728\8A66\7B97\8868\4E2D\7DE8\8F2F\8CC7\6599\76F8\4F3C.</p>'),
'',
unistr('<p>\4F7F\7528\5831\8868\9802\7AEF\7684\300C\8CC7\6599\5217\52D5\4F5C\300D\529F\80FD\8868 (<span class="fa fa-bars" aria-hidden="true"></span>) \53EF\8907\88FD\3001\522A\9664\3001\91CD\65B0\6574\7406\6216\56DE\5FA9\9078\53D6\7684\8CC7\6599\5217.<br> '),
unistr('  \60A8\4E5F\53EF\4EE5\4F7F\7528\500B\5225\8CC7\6599\5217\7684\300C\8CC7\6599\5217\52D5\4F5C\300D\529F\80FD\8868, \5B58\53D6\55AE\4E00\8CC7\6599\5217\6AA2\8996\6216\65B0\589E\8CC7\6599\5217.</p>'),
'',
unistr('<p>\82E5\8981\5C0B\627E\8CC7\6599, \8ACB\5728\300C\641C\5C0B\300D\5C0D\8A71\65B9\584A\4E2D\8F38\5165\641C\5C0B\8A5E; \4E5F\53EF\4EE5\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C\4F86\9650\5236\50B3\56DE\7684\8A18\9304.</p>'),
'',
unistr('<p>\82E5\8981\57F7\884C\591A\7A2E\529F\80FD, \53EF\4EE5\6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215, \5305\62EC\9078\53D6\986F\793A/\96B1\85CF\7684\8CC7\6599\6B04, \8207\5176\986F\793A\9806\5E8F\4EE5\53CA\57F7\884C\591A\7A2E\8CC7\6599\548C\683C\5F0F\529F\80FD.  \60A8\4E5F\53EF\4EE5\4F7F\7528\5716\8868\9078\9805\5B9A\7FA9\8CC7\6599\7684\5176\4ED6\6AA2\8996.</p>'),
'',
unistr('<p>\82E5\8981\5132\5B58\81EA\8A02\9805\76EE, \8ACB\9078\53D6\5831\8868, \6216\8005\6309\4E00\4E0B\300C\4E0B\8F09\300D\4F86\5378\8F09\8CC7\6599.<p>'),
'',
unistr('<p>\5982\9700\5176\4ED6\8CC7\8A0A, \8ACB\6309\4E00\4E0B\300C\52D5\4F5C\300D\529F\80FD\8868\5E95\7AEF\7684\300C\8AAA\660E\300D.</p> '),
'',
unistr('<p>\6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215\5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495572546874314)
,p_name=>'CA.HELP.IR.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5C0B\627E\8CC7\6599, \8ACB\5728\300C\641C\5C0B\300D\5C0D\8A71\65B9\584A\4E2D\8F38\5165\641C\5C0B\8A5E; \60A8\4E5F\53EF\4EE5\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C\4F86\9650\5236\50B3\56DE\7684\8A18\9304.</p>'),
'',
unistr('<p>\6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215\53EF\57F7\884C\591A\7A2E\529F\80FD, \5305\62EC\9078\53D6\986F\793A / \96B1\85CF\7684\8CC7\6599\6B04\53CA\5176\986F\793A\9806\5E8F\8207\57F7\884C\591A\7A2E\8CC7\6599\8207\683C\5F0F\529F\80FD.  \60A8\9084\53EF\4EE5\4F7F\7528\300C\5716\8868\300D\3001\300C\7FA4\7D44\65B9\5F0F\300D\548C\300C\6A1E\7D10\5206\6790\8868\300D\9078\9805\5B9A\7FA9\8CC7\6599\7684\5176\4ED6\6AA2\8996.</p>'),
'',
unistr('<p>\5982\679C\60A8\60F3\5132\5B58\81EA\8A02\9078\53D6\5831\8868, \8ACB\6309\4E00\4E0B\300C\4E0B\8F09\300D\4EE5\5378\8F09\8CC7\6599. \8ACB\5728\300C\8A02\95B1\300D\4E0B\65B9\8F38\5165\60A8\7684\96FB\5B50\90F5\4EF6\5730\5740\548C\6642\9593\7BC4\570D, \4EE5\4FBF\5B9A\671F\50B3\9001\8CC7\6599\7D66\60A8.<p>'),
'',
unistr('<p>\5982\9700\5176\4ED6\8CC7\8A0A, \8ACB\6309\4E00\4E0B\300C\52D5\4F5C\300D\529F\80FD\8868\5E95\90E8\7684\300C\8AAA\660E\300D.</p>'),
'',
unistr('<p>\6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215\5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531240503874341)
,p_name=>'CA.HELP.MD.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\5831\8868\9801\9762\6703\5728\9801\9762\5074\908A\986F\793A\9078\53D6\5668\4E2D\7684\4E3B\8981\8A18\9304. '),
unistr('  \9078\53D6\4E00\7B46\8A18\9304\5373\53EF\67E5\770B\4E3B\8981\8A18\9304\548C\5B9A\7FA9\7684\6240\6709\660E\7D30\8A18\9304.<br> '),
unistr('  \6309\4E00\4E0B\7DE8\8F2F\5716\793A ( <span class="fa fa-pencil-square-o" aria-hidden="true"></span> ) \5373\53EF\7DE8\8F2F\4E3B\8981\8A18\9304.'),
unistr('  \81F3\65BC\660E\7D30\8A18\9304, \6309\4E00\4E0B\6BCF\500B\8CC7\6599\5217\958B\982D\8655\7684\925B\7B46\5716\793A, \5373\53EF\7DE8\8F2F\8A72\7B46\8A18\9304.</p>'),
unistr('<p>\82E5\8981\9650\5236\9078\53D6\5668\4E2D\986F\793A\7684\8CC7\6599, \8ACB\5728\641C\5C0B\5C0D\8A71\65B9\584A\4E2D\8F38\5165\641C\5C0B\8A5E.</p>'),
'',
unistr('<p>\82E5\8981\65B0\589E\4E3B\8981\8A18\9304, \8ACB\6309\4E00\4E0B\9801\9762\9802\7AEF\7684<strong>\5EFA\7ACB</strong>.'),
unistr('  \81F3\65BC\660E\7D30\8A18\9304, \8ACB\6309\4E00\4E0B\660E\7D30\5340\57DF\9802\7AEF\7684\52A0\865F\5716\793A (+), \5373\53EF\65B0\589E\660E\7D30\8A18\9304.</p>'),
'',
unistr('<p>\6309\4E00\4E0B\9801\9762\9802\7AEF\7684<strong>\91CD\8A2D</strong>\5373\53EF\5C07\9801\9762\91CD\8A2D\56DE\9810\8A2D\503C, \56E0\800C\79FB\9664\5148\524D\5B9A\7FA9\7684\6240\6709\641C\5C0B\8A5E.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493591064874313)
,p_name=>'CA.HELP.P10000.ADMINISTRATION.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7BA1\7406\9801\9762\53EF\8B93\61C9\7528\7A0B\5F0F\64C1\6709\8005 (\7BA1\7406\54E1) \8A2D\5B9A\61C9\7528\7A0B\5F0F, \4E26\7DAD\8B77\7528\65BC\6574\500B\61C9\7528\7A0B\5F0F\7684\4E00\822C\8CC7\6599.'),
unistr('\9078\53D6\5176\4E2D\4E00\500B\53EF\7528\8A2D\5B9A\503C\5F8C, \7BA1\7406\54E1\5C31\80FD\8B8A\66F4\61C9\7528\7A0B\5F0F\7684\986F\793A\65B9\5F0F\548C (\6216) \4E00\822C\4F7F\7528\8005\53EF\7528\7684\529F\80FD.</p>'),
unistr('<p>\6B64\9801\9762\50C5\4F9B\7BA1\7406\54E1\5B58\53D6.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494704185874314)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.CONFIGURE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9078\53D6\4EFB\4F55\9069\7576\7684\5DF2\8A8D\8B49\4F7F\7528\8005.<br>'),
unistr('\5982\679C\9078\53D6<strong>\5426</strong>, \5247\53EA\6709\6307\5B9A\7684\4F7F\7528\8005\80FD\5920\5B58\53D6\6B64\61C9\7528\7A0B\5F0F, \9019\9EBC\505A\6709\52A9\65BC\63D0\9AD8\61C9\7528\7A0B\5F0F\7684\5B89\5168\6027.'),
unistr('\4E0D\904E, \5047\5982\61C9\7528\7A0B\5F0F\7684\4F7F\7528\8005\6578\91CF\5F88\591A\4E14\96E3\4EE5\7DAD\8B77, \5EFA\8B70\60A8\9078\64C7<strong>\662F</strong>, \4E26\53EA\8F38\5165\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\548C\63D0\4F9B\8005 (\9078\64C7\6027).<br>'),
unistr('\5982\679C\60A8\9078\53D6<strong>\662F</strong>, \9084\5FC5\9808\9078\53D6\8981\5982\4F55\8655\7406\4E0D\5728\4F7F\7528\8005\6E05\55AE\4E2D\7684\4F7F\7528\8005.</p>'),
unistr('<p>\9078\53D6\5FC5\9808\63D0\4F9B\96FB\5B50\90F5\4EF6\5730\5740\6216\4F7F\7528\8005\540D\7A31 (\4EFB\4F55\6587\6578\5B57\503C).<br>'),
unistr('\4E00\822C\4F86\8AAA, \5982\679C\61C9\7528\7A0B\5F0F\63A1\7528 (\6216\5C07\8A2D\70BA\63A1\7528) Oracle Access Manager \6216 SSO \7B49\96C6\4E2D\5F0F\8A8D\8B49\914D\7F6E, \8ACB\52D9\5FC5\5C07\6B64\8A2D\5B9A\8A2D\70BA<strong>\96FB\5B50\90F5\4EF6\5730\5740</strong>.</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \6B64\61C9\7528\7A0B\5F0F\652F\63F4\4E0B\5217 3 \7A2E\5B58\53D6\5C64\6B21: \95B1\8B80\8005\3001\63D0\4F9B\8005\548C\7BA1\7406\54E1.'),
'<ul>',
unistr('  <li><strong>\95B1\8B80\8005</strong>: \5177\5099\6240\6709\8CC7\8A0A\7684\552F\8B80\5B58\53D6, \800C\4E14\53EF\4EE5\6AA2\8996\5831\8868.</li>'),
unistr('  <li><strong>\63D0\4F9B\8005</strong>: \53EF\5EFA\7ACB\3001\7DE8\8F2F\53CA\522A\9664\8CC7\8A0A\53CA\6AA2\8996\5831\8868.</li>'),
unistr('  <li><strong>\7BA1\7406\54E1</strong>: \4E0D\4F46\5177\5099\300C\63D0\4F9B\8005\300D\529F\80FD, \9084\80FD\5B58\53D6\61C9\7528\7A0B\5F0F\7684\300C\7BA1\7406\300D\5340\6BB5\4EE5\57F7\884C\61C9\7528\7A0B\5F0F\7D44\614B.</li>'),
'</ul>',
'</em></p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494995856874314)
,p_name=>'CA.HELP.P10100.ACCESS.CONTROL.USERS.FORM'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\6B64\8868\55AE\4E2D\8F38\5165\4F7F\7528\8005\3001\4F7F\7528\8005\96FB\5B50\90F5\4EF6\5730\5740\4E26\8A2D\5B9A\5176\5B58\53D6\5C64\6B21.'),
unistr('\9019\500B\5728<em>\8A2D\5B9A\5B58\53D6\63A7\5236</em>\5E95\4E0B\5B9A\7FA9\7684\8A2D\5B9A\503C\6703\6C7A\5B9A\4F7F\7528\8005\540D\7A31\5FC5\9808\4F7F\7528\96FB\5B50\90F5\4EF6\5730\5740\6216\4EFB\4F55\6587\6578\5B57\503C.</p>'),
unistr('<p>\6B64\61C9\7528\7A0B\5F0F\652F\63F4\4E0B\5217 3 \500B\5B58\53D6\5C64\6B21: \95B1\8B80\8005\3001\63D0\4F9B\8005\548C\7BA1\7406\54E1.</p>'),
'<ul>',
unistr('  <li><strong>\95B1\8B80\8005</strong>: \5177\5099\6240\6709\8CC7\8A0A\7684\552F\8B80\5B58\53D6, \800C\4E14\53EF\4EE5\6AA2\8996\5831\8868.</li>'),
unistr('  <li><strong>\63D0\4F9B\8005</strong>: \53EF\5EFA\7ACB\3001\7DE8\8F2F\53CA\522A\9664\8CC7\8A0A\53CA\6AA2\8996\5831\8868.</li>'),
unistr('  <li><strong>\7BA1\7406\54E1</strong>: \4E0D\4F46\5177\5099\300C\63D0\4F9B\8005\300D\529F\80FD, \9084\80FD\5B58\53D6\61C9\7528\7A0B\5F0F\7684\300C\7BA1\7406\300D\5340\6BB5\4EE5\57F7\884C\61C9\7528\7A0B\5F0F\7D44\614B.</li>'),
'</ul>',
unistr('<p>\7DE8\8F2F\73FE\6709\4F7F\7528\8005\6642, \60A8\53EF\4EE5\9396\5B9A\5C0D\65B9\7684\5E33\6236, \907F\514D\4ED6\5011\5B58\53D6\61C9\7528\7A0B\5F0F.</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong>   \5982\679C\4F7F\7528 Oracle Application Express \5E33\6236, \5728\6B64\8655\8F38\5165\7684\4F7F\7528\8005\4E5F\5FC5\9808\7531\5DE5\4F5C\5340\7BA1\7406\54E1\5B9A\7FA9\70BA\4E00\822C\4F7F\7528\8005, \4E14\5DE5\4F5C\5340\7BA1\7406\54E1\4E5F\53EF\4EE5\8A2D\5B9A\4ED6\5011\7684\5BC6\78BC.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494831552874314)
,p_name=>'CA.HELP.P10110.ACCESS.CONTROL.USERS.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9019\500B\9801\9762\986F\793A\61C9\7528\7A0B\5F0F\4F7F\7528\8005\548C\6240\6388\4E88\5B58\53D6\5C64\6B21\7684\5831\8868.</p>'),
unistr('<p>\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C, \5373\53EF\6392\5E8F\4E26\7BE9\9078\8CC7\6599; \6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215, \5373\53EF\81EA\8A02\986F\793A\7684\8CC7\6599\6B04\53CA\57F7\884C\591A\7A2E\5176\4ED6\9032\968E\529F\80FD.<br>'),
unistr('\6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215, \5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>'),
unistr('<p>\6309\4E00\4E0B\300C\7DE8\8F2F\300D\5716\793A (\9EC3\8272\925B\7B46), \5373\53EF\7DE8\8F2F\4F7F\7528\8005\8A73\7D30\8CC7\8A0A\548C\5B58\53D6\5C64\6B21\6216\522A\9664\4F7F\7528\8005.</p>'),
unistr('<p>\6309\4E00\4E0B\5831\8868\9802\7AEF\7684<strong>\65B0\589E\4F7F\7528\8005</strong>, \5373\53EF\65B0\589E\4F7F\7528\8005\53CA\5176\5B58\53D6\5C64\6B21.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508323510874324)
,p_name=>'CA.HELP.P10120.ACCESS.ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5982\679C\555F\7528\5B58\53D6\63A7\5236, \7BA1\7406\54E1\5C31\80FD\9650\5236\5DF2\8A8D\8B49\4F7F\7528\8005\5C0D\67D0\4E9B\61C9\7528\7A0B\5F0F\529F\80FD\7684\5B58\53D6. \6B64\61C9\7528\7A0B\5F0F\652F\63F4\4E0B\5217 3 \7A2E\89D2\8272: \95B1\8B80\8005\3001\63D0\4F9B\8005\4EE5\53CA\7BA1\7406\54E1.<p>'),
'<ul>',
unistr('  <li><strong>\95B1\8B80\8005</strong>: \5C0D\6240\6709\8CC7\8A0A\6709\552F\8B80\5B58\53D6\6B0A, \800C\4E14\53EF\4EE5\6AA2\8996\5831\8868.</li>'),
unistr('  <li><strong>\63D0\4F9B\8005</strong>: \53EF\5EFA\7ACB\3001\7DE8\8F2F\53CA\522A\9664\8CC7\8A0A, \4EE5\53CA\6AA2\8996\5831\8868.</li>'),
unistr('  <li><strong>\7BA1\7406\54E1</strong>: \9664\4E86\5177\5099\300C\63D0\4F9B\8005\300D\6B0A\9650\4E4B\5916, \9084\80FD\57F7\884C\61C9\7528\7A0B\5F0F\7D44\614B\8A2D\5B9A.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530301504874340)
,p_name=>'CA.HELP.P10140_PRELIM_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\4EE5\9017\865F\3001\5206\865F\6216\7A7A\683C\5340\9694\7684\4F7F\7528\8005\540D\7A31. \73FE\6709\6216\91CD\8907\7684\4F7F\7528\8005\540D\7A31\5C07\6703\81EA\52D5\5FFD\7565.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493743151874313)
,p_name=>'CA.HELP.P10200.CONFIGURATION.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7D44\614B\8A2D\5B9A\503C\53EF\8B93\60A8\5C07\7279\5B9A\529F\80FD\8A2D\70BA\4E00\822C\8005\53EF\4EE5\4F7F\7528 (\555F\7528) \6216\4E0D\53EF\4F7F\7528 (\505C\7528).</p>'),
unistr('<p>\5982\679C\7279\5B9A\529F\80FD\5C1A\672A\5B8C\5168\6E96\5099\5C31\7DD2\6216\9700\8981\66AB\6642\79FB\9664, \8ACB\6309\4E00\4E0B<strong>\505C\7528</strong>.'),
unistr('\5982\679C\529F\80FD\5DF2\53EF\4F9B\4F7F\7528, \53EA\8981\6309\4E00\4E0B<strong>\555F\7528</strong>\5373\53EF.</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \6B64\8655\6240\505A\7684\8B8A\66F4\4E0D\6703\53CD\6620\5728\4E00\822C\4F7F\7528\8005\76EE\524D\57F7\884C\7684\61C9\7528\7A0B\5F0F\4E2D. \4E00\822C\4F7F\7528\8005\767B\51FA\4E26\91CD\65B0\767B\5165\5F8C, \7CFB\7D71\624D\6703\547C\53EB\5DF2\4FEE\6B63\7684\529F\80FD\8A2D\5B9A\503C.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493843632874313)
,p_name=>'CA.HELP.P10300.THEME.SELECTOR'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9078\53D6\7528\65BC\986F\793A\61C9\7528\7A0B\5F0F\7684\9810\8A2D\8272\5F69\914D\7F6E.</p>'),
unistr('<p>\52FE\9078<strong>\5141\8A31\4E00\822C\4F7F\7528\8005\9078\64C7\4E3B\984C\6A23\5F0F</strong>\5F8C, \6BCF\500B\4F7F\7528\8005\53EA\8981\6309\4E00\4E0B\9996\9801\5DE6\4E0B\89D2\7684<em>\81EA\8A02</em>\9023\7D50, \5373\53EF\5F9E\53EF\7528\7684\4E3B\984C\6A23\5F0F\4E2D\9078\53D6\6240\9700\6A23\5F0F.</p>')))
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494447799874314)
,p_name=>'CA.HELP.P10400.ACTIVITY.REPORTING.ERROR.LOG'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9019\500B\9801\9762\63D0\4F9B\6B64\61C9\7528\7A0B\5F0F\8A18\9304\7684\6240\6709\672A\9810\671F\932F\8AA4\7684\4E92\52D5\5F0F\5831\8868.</p>'),
unistr('<p>\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C\5373\53EF\6392\5E8F\4E26\7BE9\9078\8CC7\6599; \6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215\53EF\81EA\8A02\986F\793A\7684\8CC7\6599\6B04\53CA\57F7\884C\591A\7A2E\5176\4ED6\9032\968E\529F\80FD. \6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215\5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494319516874314)
,p_name=>'CA.HELP.P10500.ACTIVITY.REPORTING.TOP.USERS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\6B64\5831\8868\548C\5716\8868\4F86\67E5\770B\6307\5B9A\6642\9593\7BC4\570D\5167\9801\9762\6AA2\8996\6B21\6578\6700\591A\7684\4F7F\7528\8005.</p>'),
unistr('<p>\9078\53D6\9801\9762\9802\7AEF\7684\5831\8868\6642\9593\7BC4\570D (\9810\8A2D\503C = 1 \5929) \4E26\9078\64C7\5831\8868\548C\5716\8868\5716\793A.</p>'),
unistr('<p>\5982\679C\60A8\4F7F\7528\7684\662F\4E92\52D5\5F0F\5831\8868, \8ACB\4F7F\7528\641C\5C0B\6B04\4F4D\6216\9078\53D6<strong>\4F7F\7528\8005</strong>\8CC7\6599\6B04\6A19\984C, \4EE5\9078\53D6\7279\5B9A\4F7F\7528\8005. \60A8\53EA\8981\6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215, \5373\53EF\57F7\884C\986F\793A / \96B1\85CF\8CC7\6599\6B04\3001\6BCF\9801\8CC7\6599\5217\6578\548C\7BE9\9078\7B49\591A\7A2E\529F\80FD. \6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215\5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494508989874314)
,p_name=>'CA.HELP.P10510.ACTIVITY.REPORTING.PERFORMANCE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9019\500B\9801\9762\63D0\4F9B\9801\9762\6548\80FD\548C\4F7F\7528\6B21\6578\7684\4E92\52D5\5F0F\5831\8868. \6B64\5831\8868\662F\4F9D<strong>\52A0\6B0A\6548\80FD</strong> (\4E2D\9593\503C\7D93\6B77\6642\9593\8207\9801\9762\6AA2\8996\6B21\6578\7684\4E58\7A4D) \6392\5E8F.</p>'),
unistr('<p>\8996\9700\8981\9078\53D6\9801\9762\9802\7AEF\7684\5831\8868\6642\9593\7BC4\570D (\9810\8A2D\503C = 1 \5929).<br>'),
unistr('\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C, \5373\53EF\6392\5E8F\4E26\7BE9\9078\8CC7\6599; \6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215, \5373\53EF\81EA\8A02\986F\793A\7684\8CC7\6599\6B04\53CA\57F7\884C\591A\7A2E\5176\4ED6\9032\968E\529F\80FD. \6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215, \5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494692881874314)
,p_name=>'CA.HELP.P10520.ACTIVITY.REPORTING.VIEWS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9019\500B\9801\9762\63D0\4F9B\6700\8FD1\9801\9762\6AA2\8996\72C0\6CC1\7684\4E92\52D5\5F0F\5831\8868.</p>'),
unistr('<p>\8996\9700\8981\9078\53D6\9801\9762\9802\7AEF\7684\5831\8868\6642\9593\7BC4\570D (\9810\8A2D\503C = 1 \5929).<br>'),
unistr('\6309\4E00\4E0B\8CC7\6599\6B04\6A19\984C\5373\53EF\6392\5E8F\4E26\7BE9\9078\8CC7\6599; \6309\4E00\4E0B<strong>\52D5\4F5C</strong>\6309\9215\53EF\81EA\8A02\986F\793A\7684\8CC7\6599\6B04\53CA\57F7\884C\591A\7A2E\5176\4ED6\9032\968E\529F\80FD. \6309\4E00\4E0B<strong>\91CD\8A2D</strong>\6309\9215\5373\53EF\5C07\4E92\52D5\5F0F\5831\8868\91CD\8A2D\56DE\9810\8A2D\503C.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493611651874313)
,p_name=>'CA.HELP.P10600.NOTIFICATION'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F5C\7528\4E2D\7684\901A\77E5\6703\986F\793A\5728\9996\9801\4E0A.</p>'),
unistr('<p>\6B64\5831\8868\6703\986F\793A\5DF2\5B9A\7FA9\7684\901A\77E5\53CA\5176\986F\793A\671F\9593.</p>'),
unistr('<p>\6309\4E00\4E0B\300C\7DE8\8F2F\300D\5716\793A (\9EC3\8272\925B\7B46) \5373\53EF\7DE8\8F2F\73FE\6709\901A\77E5; \6309\4E00\4E0B<strong>\65B0\589E\901A\77E5</strong>\5373\53EF\63D2\5165\65B0\901A\77E5.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493914133874313)
,p_name=>'CA.HELP.P10700.APPLICATION.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F38\5165\61C9\7528\7A0B\5F0F\7684\540D\7A31\548C\7C21\8981\63CF\8FF0.</p>'),
unistr('<p>\61C9\7528\7A0B\5F0F\540D\7A31\6703\986F\793A\5728\9996\9801\4E2D. \7C21\8981\63CF\8FF0\6703\986F\793A\5728\61C9\7528\7A0B\5F0F\540D\7A31\4E0B\65B9.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494104600874313)
,p_name=>'CA.HELP.P10920.FEEDBACK.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4E00\822C\4F7F\7528\8005\53EF\4EE5\5728\61C9\7528\7A0B\5F0F\7684\4EFB\4F55\4E00\822C\9801\9762\4E2D\8F38\5165\610F\898B\56DE\994B.</p>'),
unistr('<p>\6B64\5831\8868\986F\793A\5DF2\8F38\5165\7684\610F\898B\56DE\994B\3001\7BA1\7406\54E1\8F38\5165\7684\4EFB\4F55\56DE\61C9\548C\610F\898B\56DE\994B\72C0\614B.</p>'),
unistr('<p>\6309\4E00\4E0B\300C\7DE8\8F2F\300D\5716\793A (\9EC3\8272\925B\7B46) \5373\53EF\8F38\5165\56DE\61C9\6216\66F4\65B0\610F\898B\56DE\994B\72C0\614B.</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \5982\679C\60A8\5DF2\5B9A\7FA9\610F\898B\56DE\994B\6536\4EF6\8005, \7CFB\7D71\4E5F\6703\5C07\9001\51FA\7684\610F\898B\56DE\994B\900F\904E\96FB\5B50\90F5\4EF6, \50B3\9001\5230\610F\898B\56DE\994B\6536\4EF6\8005\6E05\55AE\4E2D\7684\96FB\5B50\90F5\4EF6\5730\5740.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510224541874325)
,p_name=>'CA.HELP.P10940.COMMA.SEP.EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\96FB\5B50\90F5\4EF6\5730\5740\6E05\55AE (\4EE5\9017\865F\5340\9694)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494265416874314)
,p_name=>'CA.HELP.P10940.FEEDBACK.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p><strong>\555F\7528\9644\4EF6</strong> - \5982\679C\555F\7528, \4F7F\7528\8005\5C07\53EF\4E0A\50B3\652F\6301\610F\898B\56DE\994B\7684\9644\4EF6.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495236470874314)
,p_name=>'CA.HELP.P11000.EMAIL.TEMPLATES.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9801\9762\5217\51FA\5DF2\5B9A\7FA9\7684\96FB\5B50\90F5\4EF6\6A23\677F, \4EE5\53CA\6A23\677F\5728\5DF2\50B3\9001\96FB\5B50\90F5\4EF6\4E2D\53C3\7167\7684\6B21\6578.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495040263874314)
,p_name=>'CA.HELP.P11010.EMAIL.LOG'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\9801\9762\5217\51FA\5DF2\50B3\9001\7684\96FB\5B50\90F5\4EF6.</p>'),
unistr('<p>\6309\4E00\4E0B\300C\653E\5927\93E1\300D\5716\793A\5373\53EF\6AA2\8996\5DF2\50B3\9001\96FB\5B50\90F5\4EF6\7684\8A73\7D30\8CC7\8A0A.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495106943874314)
,p_name=>'CA.HELP.P11020.EMAIL.TEMPLATES.FORM.EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\4E0B\5217\6B04\4F4D\4E2D\8F38\5165\503C, \4EE5\5B9A\7FA9\96FB\5B50\90F5\4EF6\6A23\677F:</p>'),
'<ul>',
unistr('  <li><strong>\6A23\677F\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6709\610F\7FA9\7684\6A23\677F\540D\7A31.</li>'),
unistr('  <li><strong>HTML \6A23\677F</strong> (\5FC5\8981) - \8F38\5165\5EFA\69CB\50B3\9001\7D66\6536\4EF6\8005\4E4B\96FB\5B50\90F5\4EF6\7684 HTML \7A0B\5F0F\78BC, \4EE5\50B3\905E HTML \578B\7684\96FB\5B50\90F5\4EF6.'),
unistr('    \66FF\4EE3\503C\5305\62EC:'),
'    <ul>',
unistr('        <li><strong>#APP_NAME#</strong> - \5C07\53D6\4EE3\70BA\61C9\7528\7A0B\5F0F\7684\540D\7A31</li>'),
unistr('        <li><strong>#BODY1#</strong> - \5C07\53D6\4EE3\70BA\50B3\5165\7684 p_body1_text \503C</li> '),
unistr('        <li><strong>#TABLE#</strong> - \5C07\53D6\4EE3\70BA\50B3\5165\7684 p_table_content \503C, \4F7F\7528\8868\683C\958B\555F HTML\3001\8868\683C\8CC7\6599\5217 HTML \4EE5\53CA\8868\683C\95DC\9589 HTML</li> '),
unistr('        <li><strong>#BODY2#</strong> - \5C07\53D6\4EE3\70BA\50B3\5165\7684 p_body2_text \503C</li> '),
unistr('        <li><strong>#ACTION#</strong> - \5C07\53D6\4EE3\70BA\50B3\5165\7684 p_action_label \548C p_action_link \503C, \4F7F\7528\300C\52D5\4F5C\9023\7D50\300D\6A23\677F</li>'),
'     </ul></li>',
unistr('  <li><strong>\7D14\6587\5B57\6A23\677F</strong> (\5FC5\8981) - \8F38\5165\5EFA\69CB\96FB\5B50\90F5\4EF6\7684\7D14\6587\5B57, \4EE5\50B3\9001\96FB\5B50\90F5\4EF6\7D66\4E0D\63A5\53D7 HTML \578B\96FB\5B50\90F5\4EF6\7684\6536\4EF6\8005.  \9019\4F7F\7528\7684\66FF\4EE3\503C\8207 HTML \6A23\677F\76F8\540C, \53EA\4E0D\904E #TABLE# \548C #ACTION# \5C07\6703\5448\73FE\70BA\7D14\6587\5B57.</li>'),
'<ul>',
unistr('<p>\53E6\6709\5176\4ED6 HTML \6A23\677F\53EF\7528\4F86\5EFA\7ACB\66F4\9032\968E\7684\96FB\5B50\90F5\4EF6.  \9019\4E9B\5305\62EC:</p>'),
'<ul>',
unistr('  <li><strong>\8CC7\6599\5217\4E4B\524D</strong> - \8F38\5165\53D6\4EE3 HTML \6A23\677F\4E2D\4E4B #TABLE# \7684 HTML.  \53EA\6709\5728\50B3\9001 p_table_content \6642\624D\6703\4F7F\7528.</li>'),
unistr('  <li><strong>\8CC7\6599\5217\6A23\677F</strong> - \8F38\5165\5448\73FE\8868\683C\4E4B\6BCF\500B\8CC7\6599\5217\7684 HTML.  \9019\5305\62EC\4F7F\7528 #LABEL# \548C #VALUE# \66FF\4EE3\503C\7684 row open/close \548C data open/close.    \53EA\6709\5728\50B3\9001 p_table_content \6642\624D\6703\4F7F\7528.</li>'),
unistr('  <li><strong>\8CC7\6599\5217\4E4B\5F8C</strong> - \8F38\5165\7D50\675F table \6216 div \7684 HTM.  \53EA\6709\5728\50B3\9001 p_table_content \6642\624D\6703\4F7F\7528.</li>'),
unistr('  <li><strong>\52D5\4F5C\9023\7D50 HTML</strong> - \8F38\5165\53D6\4EE3 HTML \6A23\677F\4E2D\4E4B #ACTION# \7684 HTML.  \61C9\5305\542B #ACTION_LINK# \548C #ACTION_TEXT#.  \53EA\6709\5728\50B3\9001 p_action_label \548C p_action_link \6642\624D\6703\4F7F\7528.</li>'),
'</ul>',
unistr('<p><em><strong>\6CE8\610F:</strong> \53EF\4EE5\4F7F\7528<strong>\9810\8A2D\6A23\677F</strong>\4E2D\7684\9805\76EE\4F5C\70BA\7BC4\4F8B\4F86\958B\767C\81EA\5DF1\7684\6A23\677F. \6B64\9810\8A2D\6A23\677F\4F7F\7528\5168\90E8\7684\66FF\4EE3\8B8A\6578, \60A8\53EF\4EE5\9078\64C7\662F\5426\8981\5728\81EA\5DF1\7684\96FB\5B50\90F5\4EF6\6A23\677F\4E2D\4F7F\7528.</em></p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495330695874314)
,p_name=>'CA.HELP.P11030.EMAIL.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9078\53D6\5176\4E2D\4E00\500B<strong>\767C\9001\96FB\5B50\90F5\4EF6</strong>\9078\9805, \4EE5\555F\7528\6216\505C\7528\50B3\9001\96FB\5B50\90F5\4EF6.</p>'),
unistr('<p>\8F38\5165\61C9\7528\7A0B\5F0F\554F\984C\7684\4E3B\8981\806F\7D61\4EBA\96FB\5B50\90F5\4EF6\5730\5740\4F5C\70BA<strong>\96FB\5B50\90F5\4EF6\5BC4\4EF6\8005</strong>.  \9019\500B\503C\53EF\4EE5\5728\4F7F\7528\96FB\5B50\90F5\4EF6\529F\80FD\6642\4F7F\7528\6216\8986\5BEB.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513525997874328)
,p_name=>'CA.HELP.P11030.EMAILS.FROM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9019\662F\5C07\7528\65BC\50B3\9001\96FB\5B50\90F5\4EF6\7684\5BC4\4EF6\8005\5730\5740. \9019\500B\503C\53EF\4EE5\5728\4F7F\7528\96FB\5B50\90F5\4EF6\529F\80FD\6642\8986\5BEB.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531906071874342)
,p_name=>'CA.HELP.P11060.SEND.EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\586B\5165\4E0B\5217\9805\76EE\4E26\6309\4E00\4E0B\300C\50B3\9001\96FB\5B50\90F5\4EF6\300D.  \6240\6709\50B3\9001\7684\96FB\5B50\90F5\4EF6\90FD\6703\8A18\9304\5230\96FB\5B50\90F5\4EF6\65E5\8A8C\4E2D.'),
'    <ul>',
unistr('        <li><strong>\5BC4\4EF6\8005</strong> - \5982\679C\96FB\5B50\90F5\4EF6\8A2D\5B9A\503C\4E2D\8A2D\5B9A\4E86\300C\5BC4\4EF6\8005\5730\5740\300D, \8A72\96FB\5B50\90F5\4EF6\5730\5740\5C31\6703\662F\4E00\500B\5BC4\4EF6\8005\9078\9805.  \5982\679C\6B64\61C9\7528\7A0B\5F0F\4F7F\7528\300C\96FB\5B50\90F5\4EF6\5730\5740\300D\4F5C\70BA\4F7F\7528\8005\540D\7A31, \60A8\4FBF\53EF\4EE5\9078\64C7\5F9E\60A8\7684\96FB\5B50\90F5\4EF6\50B3\9001\96FB\5B50\90F5\4EF6.  \6700\5F8C, \60A8\4E00\5F8B\53EF\4EE5\5C07\300C\5BC4\4EF6\8005\300D\8A2D\70BA\548C\300C\6536\4EF6\8005\300D\76F8\540C.</li>'),
unistr('        <li><strong>\6536\4EF6\8005</strong> - \5982\679C\6B64\61C9\7528\7A0B\5F0F\4F7F\7528\300C\96FB\5B50\90F5\4EF6\5730\5740\300D\4F5C\70BA\4F7F\7528\8005\540D\7A31, \60A8\4FBF\53EF\4EE5\9078\64C7\5C07\96FB\5B50\90F5\4EF6\50B3\9001\7D66\300C\96FB\5B50\90F5\4EF6\5730\5740\300D\548C (\6216)\300C\4F7F\7528\8005\300D.</li>'),
unistr('        <li><strong>\96FB\5B50\90F5\4EF6\5730\5740</strong> - \5C07\6536\5230\6B64\96FB\5B50\90F5\4EF6\7684\96FB\5B50\90F5\4EF6\5730\5740\6E05\55AE (\4F7F\7528\9017\865F\5340\9694). \4E0D\6703\5305\542B\7121\6548\7684\96FB\5B50\90F5\4EF6\5730\5740.</li>'),
unistr('        <li><strong>\89D2\8272</strong> - \50B3\9001\96FB\5B50\90F5\4EF6\7D66\6240\9078\89D2\8272\7684\6240\6709\4F7F\7528\8005, \6216\50B3\9001\7D66\6240\6709\5B9A\7FA9\7684\4F7F\7528\8005.  \9078\53D6\6E05\55AE\5305\62EC\89D2\8272\6E05\55AE\53CA\8A72\89D2\8272\5167\7684\4F7F\7528\8005\6578\76EE.</li>'),
unistr('        <li><strong>\6A23\677F</strong> - \9078\53D6\7528\4F86\5EFA\7ACB\96FB\5B50\90F5\4EF6\672C\6587\7684\96FB\5B50\90F5\4EF6\6A23\677F.</li>'),
unistr('        <li><strong>\4E3B\65E8</strong> - \96FB\5B50\90F5\4EF6\7684\4E3B\65E8.</li>'),
unistr('        <li><strong>\96FB\5B50\90F5\4EF6\672C\6587</strong> - \8981\7D0D\5165\4F5C\70BA\96FB\5B50\90F5\4EF6\672C\6587\7684\6587\5B57.</li>'),
unistr('        <li><strong>\5141\8A31\9078\64C7\9000\51FA</strong> - \90E8\5206\96FB\5B50\90F5\4EF6\662F\7121\8AD6\4F7F\7528\8005\662F\5426\9078\64C7\4E0D\63A5\6536\96FB\5B50\90F5\4EF6\90FD\61C9\8A72\50B3\9001. \9019\985E\96FB\5B50\90F5\4EF6\5305\62EC\6545\969C\8A0A\606F\7B49. \6B64\65D7\6A19\8B58\5225\662F\5426\5141\8A31\4E0D\50B3\9001\6B64\96FB\5B50\90F5\4EF6, \9084\662F\7121\8AD6\4F7F\7528\8005\7684\504F\597D\8A2D\5B9A\70BA\4F55\90FD\61C9\8A72\50B3\9001\6B64\96FB\5B50\90F5\4EF6.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533693030874343)
,p_name=>'CA.HELP.P11060.SEND.EMAIL.NO.ACL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\586B\5165\4E0B\5217\9805\76EE\4E26\6309\4E00\4E0B\300C\50B3\9001\96FB\5B50\90F5\4EF6\300D.  \6240\6709\50B3\9001\7684\96FB\5B50\90F5\4EF6\90FD\6703\8A18\9304\5230\96FB\5B50\90F5\4EF6\65E5\8A8C\4E2D.'),
'    <ul>',
unistr('        <li><strong>\5BC4\4EF6\8005</strong> - \5982\679C\96FB\5B50\90F5\4EF6\8A2D\5B9A\503C\4E2D\8A2D\5B9A\4E86\300C\5BC4\4EF6\8005\5730\5740\300D, \8A72\96FB\5B50\90F5\4EF6\5730\5740\5C07\6703\662F\5BC4\4EF6\8005\7684\9078\9805\4E4B\4E00.  \5426\5247, \60A8\53EF\4EE5\5C07\300C\5BC4\4EF6\8005\300D\8A2D\70BA\548C\300C\6536\4EF6\8005\300D\76F8\540C.</li>'),
unistr('        <li><strong>\96FB\5B50\90F5\4EF6\5730\5740</strong> - \5C07\6536\5230\6B64\96FB\5B50\90F5\4EF6\7684\96FB\5B50\90F5\4EF6\5730\5740\6E05\55AE (\4F7F\7528\9017\865F\5340\9694). \767C\73FE\7684\7121\6548\96FB\5B50\90F5\4EF6\5730\5740\5C07\4E0D\6703\5305\542B\5728\5167.</li>'),
unistr('        <li><strong>\6A23\677F</strong> - \9078\53D6\7528\4F86\5EFA\7ACB\96FB\5B50\90F5\4EF6\672C\6587\7684\96FB\5B50\90F5\4EF6\6A23\677F.</li>'),
unistr('        <li><strong>\4E3B\65E8</strong> - \96FB\5B50\90F5\4EF6\7684\4E3B\65E8.</li>'),
unistr('        <li><strong>\96FB\5B50\90F5\4EF6\672C\6587</strong> - \8981\5305\542B\4F5C\70BA\96FB\5B50\90F5\4EF6\672C\6587\7684\6587\5B57.</li>'),
unistr('        <li><strong>\5141\8A31\9078\64C7\9000\51FA</strong> - \90E8\5206\96FB\5B50\90F5\4EF6\7121\8AD6\4F7F\7528\8005\662F\5426\9078\64C7\4E0D\63A5\6536\96FB\5B50\90F5\4EF6\90FD\5FC5\9808\50B3\9001. \6545\969C\8A0A\606F\7B49\5747\70BA\9019\985E\96FB\5B50\90F5\4EF6. \6B64\65D7\6A19\8B58\5225\662F\5426\5141\8A31\9078\64C7\9000\51FA\6B64\96FB\5B50\90F5\4EF6, \6216\662F\5426\7121\8AD6\4F7F\7528\8005\504F\597D\8A2D\5B9A\70BA\4F55\90FD\5FC5\9808\50B3\9001.</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286494067225874313)
,p_name=>'CA.HELP.P12000.TIME.ZONE.SUPPORT'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\70BA\6B64\61C9\7528\7A0B\5F0F\7684\6240\6709\4F7F\7528\8005\9078\53D6\9810\8A2D\6642\5340.</p>'),
unistr('<p>\500B\5225\4F7F\7528\8005\53EA\8981\6309\4E00\4E0B\4F7F\7528\8005\540D\7A31 (\4F4D\65BC\53F3\4E0A\89D2) \4E26\9078\53D6<strong>\504F\597D\8A2D\5B9A</strong>, \5373\53EF\8986\5BEB\9019\9805\8A2D\5B9A. \6B64\5916, \4F7F\7528\8005\4E5F\53EF\4EE5\6309\4E00\4E0B\986F\793A\5728\9996\9801\5E95\90E8\7684\6642\5340\9023\7D50\4F86\8B8A\66F4\9019\9805\8A2D\5B9A.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509925623874325)
,p_name=>'CA.HELP.P2000.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9801\9762\7528\65BC\4E0B\8F09\8A2D\5B9A\6A94\76F8\7247, \7121\6CD5\76F4\63A5\900F\904E UI \5B58\53D6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509638946874325)
,p_name=>'CA.HELP.P20000.USER.PROFILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\4F7F\7528\8005\8A2D\5B9A\6A94\300D\9801\9762\53EF\8B93\60A8\5728\87A2\5E55\4E0A\8F15\9B06\67E5\770B\4F7F\7528\8005\7684\76F8\95DC\8CC7\8A0A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509343556874325)
,p_name=>'CA.HELP.P20030.PHOTO.UPLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\4E0A\50B3\6B63\65B9\5F62\7684\76F8\7247, \5426\5247\53EF\80FD\6703\626D\66F2\8B8A\5F62. \5EFA\8B70\5F71\50CF\5927\5C0F\70BA 250x250 \50CF\7D20.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286495419080874314)
,p_name=>'CA.HELP.P20200.USER.PROFILE.MODAL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\8868\55AE\53EF\8B93\60A8\66F4\65B0\500B\4EBA\8A73\7D30\8CC7\8A0A\53CA\4E0A\50B3\76F8\7247\6216\5927\982D\8CBC.</p>'),
unistr('<p>\82E5\8981\4E0A\50B3\5F71\50CF, \8ACB\6309\4E00\4E0B<strong>\700F\89BD</strong>\6216\5C07\5F71\50CF\62D6\653E\5230\6309\9215\4E0A.<br>'),
unistr('\8ACB\4E0A\50B3\6B63\65B9\5F62\7684\76F8\7247, \5426\5247\53EF\80FD\6703\626D\66F2\8B8A\5F62. \5EFA\8B70\7684\5F71\50CF\5927\5C0F\70BA 250x250 \50CF\7D20.</p>'),
unistr('<p>\6309\4E00\4E0B<strong>\522A\9664\76F8\7247</strong>\5373\53EF\5C07\5F71\50CF\522A\9664.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515544671874329)
,p_name=>'CA.HELP.P20210.ABOUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\53EF\4EE5\5F9E\6B64\9801\9762\5B58\53D6\6240\6709\61C9\7528\7A0B\5F0F\8AAA\660E\6587\5B57.\300C\6587\4EF6\300D\5340\57DF\4E2D\7684\9023\7D50\6703\63D0\4F9B\66F4\591A\6B64\61C9\7528\7A0B\5F0F\529F\80FD\7684\6DF1\5165\8AAA\660E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496556988874315)
,p_name=>'CA.HELP.P20400.APP.PREF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\53EF\4EE5\5728\6B64\9801\9762\4E2D\8A2D\5B9A\5E33\6236\7684\61C9\7528\7A0B\5F0F\504F\597D\8A2D\5B9A. \504F\597D\8A2D\5B9A\6703\5F71\97FF\6642\5340\7B49\591A\500B\61C9\7528\7A0B\5F0F\5C64\9762. \82E5\8981\77AD\89E3\5404\500B\504F\597D\8A2D\5B9A\7684\529F\80FD, \8ACB\6309\4E00\4E0B\9805\76EE\5C64\7D1A\8AAA\660E\5716\793A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488631254873585)
,p_name=>'CA.HELP.P20500.EMAIL.REPORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6B64\5831\8868\986F\793A\5DF2\6392\5165\4F47\5217\7B49\5F85\50B3\9001\53CA\5DF2\7D93\50B3\9001\7684\6240\6709\96FB\5B50\90F5\4EF6.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285620588292873682)
,p_name=>'CA.HELP.P20600.JOB.REPORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6B64\5831\8868\5305\62EC\9078\64C7\53D7\6B64\61C9\7528\7A0B\5F0F\76E3\7763\7684\6240\6709\5DE5\4F5C.  \6309\4E00\4E0B\5DE5\4F5C\540D\7A31\5373\53EF\6AA2\8996\6BCF\500B\5DE5\4F5C\7684\8A73\7D30\8CC7\8A0A.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627162147873687)
,p_name=>'CA.HELP.P20610.JOB.RUN.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6B64\5831\8868\5305\542B\95DC\65BC\9078\64C7\53D7\6B64\61C9\7528\7A0B\5F0F\76E3\7763\7684\5DE5\4F5C\57F7\884C\8A73\7D30\8CC7\8A0A.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286480882064874303)
,p_name=>'CA.HELP.PAGE.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\95DC\65BC\6B64\61C9\7528\7A0B\5F0F\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497229498874316)
,p_name=>'CA.HELP.RECEIVE.EMAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\679C\60A8\4E0D\60F3\6536\5230\5F9E\9019\500B\61C9\7528\7A0B\5F0F\50B3\9001\7684\96FB\5B50\90F5\4EF6, \8ACB\5C07\6B64\9078\9805\8A2D\70BA\300C\5426\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531485547874341)
,p_name=>'CA.HELP.SEARCH.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\641C\5C0B\5C0D\8A71\65B9\584A\4E2D\8F38\5165\641C\5C0B\8A5E\4E26\6309\4E00\4E0B<strong>\641C\5C0B</strong>.<br>'),
unistr('\6309\4E00\4E0B\4EFB\4F55\7D50\679C\6A19\984C\5373\53EF\700F\89BD\81F3\7279\5B9A\8A18\9304.</p>'),
unistr('<p>\82E5\8981\9650\5236\641C\5C0B, \8ACB\53D6\6D88\52FE\9078\4E00\6216\591A\500B\4F86\6E90, \5373\53EF\5C07\8A72\5831\8868\81EA\641C\5C0B\7D50\679C\4E2D\79FB\9664.</p>'),
unistr('<p>\6309\4E00\4E0B<strong>\91CD\8A2D</strong>\5373\53EF\79FB\9664\76EE\524D\7684\641C\5C0B\8A5E\4E26\52FE\9078\6240\6709\4F86\6E90.</p> ')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497046790874316)
,p_name=>'CA.HELP.TIME.ZONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\6574\500B\61C9\7528\7A0B\5F0F\4E2D\4F7F\7528\7684\504F\597D\6642\5340.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409177376873527)
,p_name=>'CA.HIDDEN.ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF\7684\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517177979874330)
,p_name=>'CA.HOME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9996\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523244200874335)
,p_name=>'CA.HOME.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9996\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539690418874347)
,p_name=>'CA.HOURLY.PAGE.EVENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\5C0F\6642\7684\9801\9762\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487708288873584)
,p_name=>'CA.HTML.BODY.SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTML \5167\6587\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513924162874328)
,p_name=>'CA.HTML.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('HTML \6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510676642874326)
,p_name=>'CA.IN.PROGRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9032\884C\4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535856533874344)
,p_name=>'CA.INCLUDEONFORMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\62EC\5728\8868\55AE\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535776078874344)
,p_name=>'CA.INCLUDEONREPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\62EC\5728\5831\8868\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286519392125874332)
,p_name=>'CA.INSTALL.SUP.OBJ.SCRIPTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\88DD\652F\63F4\7269\4EF6\547D\4EE4\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621206230873682)
,p_name=>'CA.INSTANCE.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\8655\7406 ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622487913873683)
,p_name=>'CA.INSTANCE.STICKINESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\8655\7406\505C\6EEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493090362874313)
,p_name=>'CA.INTRO.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B61\8FCE\4F7F\7528\6B64\96F2\7AEF\9650\5B9A\7684\9810\89BD, \4EE5\5168\65B0\53CA\66F4\5F37\5927\7684\65B9\5F0F\5EFA\7ACB\529F\80FD\66F4\52A0\5B8C\5584\7684\61C9\7528\7A0B\5F0F. \6A19\6E96\7684\300C\5EFA\7ACB\61C9\7528\7A0B\5F0F\7CBE\9748\300D\53EA\80FD\8B93\60A8\9078\53D6\8981\7522\751F\7684\9801\9762, \800C\6B64\7CBE\9748\53EF\5FEB\901F\5C07\6578\500B\5176\4ED6\529F\80FD\9810\5148\8F09\5165\61C9\7528\7A0B\5F0F.</p>'),
unistr('<p>\4F7F\7528\6B64\7CBE\9748\6240\7522\751F\7684\61C9\7528\7A0B\5F0F\5C07\66F4\5177\652F\63F4\6027, \4E14\9084\53EF\4EE5\5305\62EC\6240\9078\529F\80FD\7684\300C\652F\63F4\7269\4EF6\300D, \4F8B\5982\5B58\53D6\63A7\5236\3001\96FB\5B50\90F5\4EF6\67B6\69CB\3001\610F\898B\56DE\994B\7B49\7B49.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493215645874313)
,p_name=>'CA.INTRO.HOWTO.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9996\5148, \8F38\5165\61C9\7528\7A0B\5F0F\540D\7A31. \63A5\8457, \65B0\589E\4E00\6216\591A\500B\61C9\7528\7A0B\5F0F\7684\9801\9762. \52FE\9078\60F3\8981\5305\62EC\7684\529F\80FD. \9078\64C7\61C9\7528\7A0B\5F0F\5916\89C0, \7136\5F8C\8907\67E5\8A2D\5B9A\503C.<br>'),
unistr('\53EA\8981\9019\6A23 - \518D\6309\4E00\4E0B<strong>\5EFA\7ACB\61C9\7528\7A0B\5F0F</strong>, \60A8\5C31\5B8C\6210\4E86!</p>'),
unistr('<p>\6309\4E00\4E0B<strong>\6AA2\8996\85CD\5716</strong>\5373\53EF\91CD\8907\4F7F\7528\5148\524D\7522\751F\4E4B\61C9\7528\7A0B\5F0F\7684\6A21\578B, \6216\5FEB\901F\8907\88FD\9801\9762.</p>'),
unistr('<p><em><strong>\6CE8\610F:</strong> \6BCF\500B\5340\6BB5\548C\6BCF\500B\300C\65B0\589E\9801\9762\300D\5747\5305\62EC\8A73\7D30\7684\8AAA\660E, \4EE5\9032\4E00\6B65\5354\52A9\60A8\4F5C\696D.</em></p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493105628874313)
,p_name=>'CA.INTRO.HOWTO.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\4F55\4F7F\7528\6B64\7CBE\9748')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527850717874338)
,p_name=>'CA.INTRO.KNOWN.ISSUES.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\767C\884C\6642\767C\73FE\7684\91CD\5927\554F\984C\5982\4E0B:'),
'<ol>',
unistr('  <li>\300C\5F9E\85CD\5716\5EFA\7ACB\61C9\7528\7A0B\5F0F\7CBE\9748\300D\672A\7FFB\8B6F.</li>'),
unistr('  <li>\4F7F\7528\6B64\7CBE\9748\7522\751F\7684\5DF2\7FFB\8B6F\61C9\7528\7A0B\5F0F\53EA\6709\5C40\90E8\7FFB\8B6F.</li>'),
unistr('  <li>\300C\5831\8868\5411\4E0B\5C55\958B\300D\53EA\80FD\5411\4E0B\5C55\958B\4E00\500B\8CC7\6599\6B04.</li>'),
unistr('  <li>\7121\6CD5\7522\751F\7BE9\9078\5831\8868\9801\9762.</li>'),
unistr('  <li>\96FB\5B50\90F5\4EF6\529F\80FD\63D0\4F9B\4F4E\968E\7684 API, \4F46\662F\9084\672A\5305\542B\8F03\9AD8\968E\7684\96FB\5B50\90F5\4EF6\529F\80FD.</li>'),
unistr('  <li>\5F9E\53C3\7167\907A\6F0F\8868\683C\7684\85CD\5716\7522\751F\61C9\7528\7A0B\5F0F\5C07\6703\5931\6557.</li>'),
unistr('  <li>\9032\968E\8A2D\5B9A\503C - \65E5\671F\683C\5F0F\4E0D\6703\5957\7528\81F3\7522\751F\7684\61C9\7528\7A0B\5F0F.</li>'),
'</ol>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527765826874338)
,p_name=>'CA.INTRO.KNOWN.ISSUES.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\77E5\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493446177874313)
,p_name=>'CA.INTRO.RELEASE.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\767C\884C\6642\9593: %0.</p>'),
'',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286493321196874313)
,p_name=>'CA.INTRO.RELEASE.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7248\6B21\8A73\7D30\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492928767874313)
,p_name=>'CA.INTRO.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F9E\85CD\5716\5EFA\7ACB\61C9\7528\7A0B\5F0F\7CBE\9748 {\50C5\9650\96F2\7AEF\9810\89BD}')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504553653874321)
,p_name=>'CA.IP.ADDRESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('IP \4F4D\5740')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502751606874320)
,p_name=>'CA.IR.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('IR \641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505741916874322)
,p_name=>'CA.IR.SEARCHES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('IR \641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534285740874343)
,p_name=>'CA.ITEMNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625246778873685)
,p_name=>'CA.JOB.ACTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626730571873686)
,p_name=>'CA.JOB.CLASS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\985E\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625825113873686)
,p_name=>'CA.JOB.CREATOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5EFA\7ACB\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626911943873687)
,p_name=>'CA.JOB.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623464272873684)
,p_name=>'CA.JOB.PRIORITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\512A\5148\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285620475417873682)
,p_name=>'CA.JOB.REPORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285663041480873713)
,p_name=>'CA.JOB.REPORTING.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\652F\63F4\6B64\61C9\7528\7A0B\5F0F\7684\5DE5\4F5C\72C0\614B\548C\57F7\884C\8A73\7D30\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627090638873687)
,p_name=>'CA.JOB.RUN.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\57F7\884C\8A73\7D30\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625993497873686)
,p_name=>'CA.JOB.STYLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626075164873686)
,p_name=>'CA.JOB.SUBNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5B50\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625337286873685)
,p_name=>'CA.JOB.TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622059594873683)
,p_name=>'CA.JOB.WEIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\52A0\6B0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534775311874344)
,p_name=>'CA.KEYCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D22\5F15\9375\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536587743874345)
,p_name=>'CA.LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535052897874344)
,p_name=>'CA.LABELCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536773719874345)
,p_name=>'CA.LABELPLURAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64 (\8907\6578)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536431755874345)
,p_name=>'CA.LABELSINGULAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64 (\55AE\6578)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492156161874312)
,p_name=>'CA.LANGUAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A9E\8A00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492244189874312)
,p_name=>'CA.LANGUAGE.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\6B64\61C9\7528\7A0B\5F0F\7684\4E3B\8981\8A9E\8A00.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527203520874338)
,p_name=>'CA.LANGUAGE.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\4E3B\8981\8A9E\8A00\6C7A\5B9A\5728\61C9\7528\7A0B\5F0F\7522\751F\5668\4E2D\7522\751F\4E4B\9801\9762\548C\5143\4EF6\7684\986F\793A\8A9E\8A00. \82E5\9078\53D6\591A\500B\7FFB\8B6F, \53EF\8B93\4E00\822C\4F7F\7528\8005\9078\64C7\61C9\7528\7A0B\5F0F\5BE6\969B\57F7\884C\6642\7684\8A9E\8A00.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771689900873787)
,p_name=>'CA.LANGUAGE_SELECTOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A9E\8A00\9078\53D6\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509108074874325)
,p_name=>'CA.LAST.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\59D3\6C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626193402873686)
,p_name=>'CA.LAST.RUN.DURATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\6B21\57F7\884C\6301\7E8C\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626261594873686)
,p_name=>'CA.LAST.START.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\6B21\958B\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540010042874348)
,p_name=>'CA.LATEST.ACTIVITY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\65B0\6D3B\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535967347874345)
,p_name=>'CA.LISTOFVALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531381646874341)
,p_name=>'CA.LOAD.BLUEPRINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F09\5165\85CD\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628528589873688)
,p_name=>'CA.LOG.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A18\9304\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628794780873688)
,p_name=>'CA.LOG.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\8A8C ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622793516873683)
,p_name=>'CA.LOGGING.LEVEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\8A8C\8A18\9304\5C64\7D1A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409901719873527)
,p_name=>'CA.LOOKUP.COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'&nbsp;<br>',
'<ul>',
unistr(' <li><strong>\67E5\5C0B\8CC7\6599\6B04</strong> - \5C55\958B\4EE5\67E5\770B\5B9A\7FA9\5C0D\5176\4ED6\8868\683C\67E5\5C0B\7684\5C6C\6027. \4F7F\7528\67E5\5C0B\8CC7\6599\6B04\53EF\4F7F\7528\986F\793A\8CC7\6599\6B04\4F86\53D6\4EE3 ID, \4F8B\5982\986F\793A\90E8\9580\540D\7A31\800C\975E\90E8\9580\7DE8\865F.<br>'),
unistr('<em><strong>\6CE8\610F:</strong> \76EE\524D\7684\9801\9762\662F\4EE5\8868\683C\6216\8996\89C0\8868\70BA\57FA\790E, \4E14\5177\6709\5176\4ED6\8868\683C\7684\5916\4F86\7D22\5F15\9375\9650\5236\689D\4EF6\6642, \624D\6703\986F\793A\67E5\5C0B\8CC7\6599\6B04.'),
'  <ul>',
unistr('    <li><strong>\67E5\5C0B\7D22\5F15\9375</strong> - \9078\53D6\8981\8B8A\66F4\70BA\8F38\51FA\986F\793A\8CC7\6599\6B04\7684\8CC7\6599\6B04.</li>'),
unistr('    <li><strong>\986F\793A\8CC7\6599\6B04</strong> - \9078\53D6\8981\986F\793A\7684\8CC7\6599\6B04 (\5F9E\67E5\5C0B\8868\683C).</li>'),
'    &nbsp;<br>',
unistr('    <em><strong>\6CE8\610F:</strong> \8ACB\50C5\9078\53D6\5177\6709\5176\4ED6\8868\683C\53C3\7167 (\4F7F\7528\5916\4F86\7D22\5F15\9375) \7684\8CC7\6599\6B04.</em></li>'),
'  </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286513129463874327)
,p_name=>'CA.MANAGE.EMAIL.TEMPLATES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\96FB\5B50\90F5\4EF6\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511191976874326)
,p_name=>'CA.MANAGE.FEEDBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\610F\898B\56DE\994B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507246126874323)
,p_name=>'CA.MANAGE.USER.ACCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BA1\7406\4F7F\7528\8005\5B58\53D6\6B0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540688860874348)
,p_name=>'CA.MASTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\4E3B\8981\660E\7D30\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540717114874348)
,p_name=>'CA.MASTER.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\4E3B\8981-\660E\7D30\9801\9762\7684\9801\9762, \8B93\4E00\822C\4F7F\7528\8005\53EF\4EE5\6AA2\8996\53CA\7DAD\8B77\8CC7\6599.<br>'),
'&nbsp;</p>',
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\9801\9762\985E\578B</strong> - \9078\53D6\9801\9762\985E\578B [\4E26\6392\3001\5806\758A].<br>'),
unistr('    <strong>\4E26\6392</strong>: <br>'),
unistr('<em>\904B\7528\4E26\6392\7248\9762\914D\7F6E\548C\542B\6709\5F37\5236\56DE\61C9\7DE8\8F2F\8996\7A97\4E4B\5831\8868\5340\57DF\7684\55AE\4E00\9801\9762\4E3B\8981-\660E\7D30.</em>'),
'    <ul>',
unistr('      <li><strong>\8868\683C</strong> (\5FC5\8981) - \9078\53D6\9801\9762\7684\4E3B\8981\8868\683C.</li>'),
unistr('      <li><strong>\4E3B\8981\986F\793A\8CC7\6599\6B04</strong> (\5FC5\8981) - \9078\53D6\8981\5728\4E3B\8981\8A18\9304\6E05\55AE\4E2D\986F\793A\7684\8CC7\6599\6B04.</li>'),
unistr('      <li><strong>\6B21\8981\986F\793A\8CC7\6599\6B04</strong> (\5FC5\8981) - \9078\53D6\8981\5728\4E3B\8981\8A18\9304\6E05\55AE\4E2D\300C\4E3B\8981\986F\793A\8CC7\6599\6B04\300D\5E95\4E0B\986F\793A\7684\63CF\8FF0\6027\8CC7\6599\6B04.</li>'),
unistr('      <li><strong>\660E\7D30\8868\683C 1</strong> (\5FC5\8981) - \9078\53D6\9801\9762\7684\7B2C\4E00\500B\660E\7D30\8868\683C.</li>'),
unistr('      <li><strong>\660E\7D30\8868\683C 2</strong> - \9078\53D6\9801\9762\7684\7B2C\4E8C\500B\660E\7D30\8868\683C.</li>'),
unistr('      <li><strong>\660E\7D30\8868\683C 3</strong> - \9078\53D6\9801\9762\7684\7B2C\4E09\500B\660E\7D30\8868\683C.</li>'),
unistr('      <li><strong>\660E\7D30\8868\683C 4</strong> - \9078\53D6\9801\9762\7684\7B2C\56DB\500B\660E\7D30\8868\683C.</li>'),
'    </ul>',
unistr('   <strong>\5806\758A</strong>: <br>'),
unistr('<em>\904B\7528\53EF\7DE8\8F2F\4E92\52D5\5F0F\65B9\683C\7684\55AE\4E00\9801\9762\4E3B\8981-\660E\7D30.</em>'),
'    <ul>',
unistr('      <li><strong>\8868\683C</strong> (\5FC5\8981) - \9078\53D6\53EF\7DE8\8F2F\4E92\52D5\5F0F\65B9\683C\7684\4E3B\8981\8868\683C.</li>'),
unistr('      <li><strong>\660E\7D30\8868\683C</strong> (\5FC5\8981) - \9078\53D6\9801\9762\7684\660E\7D30\8868\683C.</li>'),
unistr('      <em><strong>\6CE8\610F:</strong> \4F7F\7528\6B64\7CBE\9748\6642, \53EA\80FD\65B0\589E\4E00\500B\660E\7D30\8868\683C (\53EF\7DE8\8F2F\4E92\52D5\5F0F\65B9\683C). \4F46\5728\7522\751F\5F8C, \53EF\8F15\9B06\65B0\589E\5176\4ED6\660E\7D30\8868\683C.</em>'),
'    </ul>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771556443873787)
,p_name=>'CA.MASTER_RECORDS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\8A18\9304')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503407955874320)
,p_name=>'CA.MAX.ELAPSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\9577\7D93\6B77\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623230155873684)
,p_name=>'CA.MAX.FAILURES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5931\6557\6B21\6578\4E0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622842156873684)
,p_name=>'CA.MAX.RUN.DURATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\6301\7E8C\6642\9593\4E0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623353361873684)
,p_name=>'CA.MAX.RUNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\6B21\6578\4E0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534912784874344)
,p_name=>'CA.MAXIMUMROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\6578\76EE\4E0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537942278874346)
,p_name=>'CA.MAXIMUMWIDTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5927\5BEC\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528535173874339)
,p_name=>'CA.MD.ADD.FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528988883874339)
,p_name=>'CA.MD.ADD.ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528404357874339)
,p_name=>'CA.MD.APPLY.FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529356695874340)
,p_name=>'CA.MD.DATE.VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529421231874340)
,p_name=>'CA.MD.DATE.VALUE.2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F\503C 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528601108874339)
,p_name=>'CA.MD.EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528009758874339)
,p_name=>'CA.MD.FILTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527989746874339)
,p_name=>'CA.MD.FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529042158874339)
,p_name=>'CA.MD.NO.FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528352038874339)
,p_name=>'CA.MD.NO.RECORD.SELECTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\9078\53D6\8A18\9304')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528293619874339)
,p_name=>'CA.MD.NO.RECORDS.FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\8A18\9304')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528868629874339)
,p_name=>'CA.MD.ROWS.DELETED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5DF2\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528760645874339)
,p_name=>'CA.MD.ROWS.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5DF2\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286528193440874339)
,p_name=>'CA.MD.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529153796874339)
,p_name=>'CA.MD.VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529291502874340)
,p_name=>'CA.MD.VALUE.2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502962290874320)
,p_name=>'CA.MEDIAN.ELAPSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E2D\9593\503C\6B77\6642')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512093475874327)
,p_name=>'CA.MESSAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A0A\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537443194874346)
,p_name=>'CA.METRIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EA6\91CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503889230874321)
,p_name=>'CA.MIN.ELAPSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\77ED\7D93\6B77\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506633500874323)
,p_name=>'CA.MOBILE.PHONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\884C\52D5\96FB\8A71\865F\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502421774874320)
,p_name=>'CA.MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516243938874330)
,p_name=>'CA.MORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5176\4ED6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505802926874322)
,p_name=>'CA.MOST RECENT'
,p_message_language=>'zh-tw'
,p_message_text=>'Most_Recent'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539823709874347)
,p_name=>'CA.MOST.ACTIVE.PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5E38\4F7F\7528\4E2D\7684\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285410074393873528)
,p_name=>'CA.MULTIPLE.REPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\591A\4EFD\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285410191320873528)
,p_name=>'CA.MULTIPLE.REPORTS.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\52FE\9078\4E00\6216\591A\500B\8868\683C\6216\8996\89C0\8868\540D\7A31. \6216\8005, \6309\4E00\4E0B\6A19\982D\4E2D\7684\6838\53D6\65B9\584A\4EE5\9078\53D6\6216\53D6\6D88\9078\53D6\5217\51FA\7684\6240\6709\8CC7\6599\5EAB\7269\4EF6.</p>'),
unistr('<p>\5C07\6703\70BA\52FE\9078\7684\6BCF\500B\8CC7\6599\5EAB\7269\4EF6\65B0\589E\4E00\500B\542B\6709\4E92\52D5\5F0F\5831\8868\7684\9801\9762.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499837762874318)
,p_name=>'CA.MUST.BE.VALID.TIMESTAMP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('#LABEL# \5FC5\9808\662F\6709\6548\7684\6642\6233.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537253364874345)
,p_name=>'CA.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491307039874311)
,p_name=>'CA.NAVIGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491459578874311)
,p_name=>'CA.NAVIGATION.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\9078\53D6\8981\5728\61C9\7528\7A0B\5F0F\7684\5074\908A\9084\662F\61C9\7528\7A0B\5F0F\7684\9802\7AEF\986F\793A\529F\80FD\8868.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543962212874350)
,p_name=>'CA.NEGATIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\597D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543867265874350)
,p_name=>'CA.NEUTRAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\666E\901A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529906820874340)
,p_name=>'CA.NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623083583873684)
,p_name=>'CA.NEXT.RUN.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\6B21\57F7\884C\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621967241873683)
,p_name=>'CA.NLS.ENV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('NLS \74B0\5883')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285719738283873752)
,p_name=>'CA.NO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5426')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510758195874326)
,p_name=>'CA.NO.ACTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286522345791874334)
,p_name=>'CA.NO.HELP.AVAILABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9801\9762\6C92\6709\76F8\95DC\8AAA\660E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409252955873527)
,p_name=>'CA.NO.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\6709\6548\7684\4F7F\7528\8005\5B58\5728 - \9801\9762\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530923291874341)
,p_name=>'CA.NO.VALID.USER.FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\4EFB\4F55\6709\6548\7684\65B0\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527065487874338)
,p_name=>'CA.NONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506965002874323)
,p_name=>'CA.NOTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9644\8A3B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482473301874304)
,p_name=>'CA.NOTIFICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481293389874304)
,p_name=>'CA.NOTIFICATION.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\9996\9801\986F\793A\901A\77E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482557877874304)
,p_name=>'CA.NOTIFICATION.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8B93\61C9\7528\7A0B\5F0F\7BA1\7406\54E1\80FD\5920\6307\5B9A\5C07\5728\61C9\7528\7A0B\5F0F\9996\9801\4E0A\5411\6240\6709\4E00\822C\4F7F\7528\8005\986F\793A\7684\8B66\793A (\9EC3\8272) \6216\932F\8AA4 (\7D05\8272). \9019\9805\529F\80FD\5C0D\65BC\5C07\91CD\8981\8CC7\8A0A\50B3\9001\5230\4E00\822C\4F7F\7528\8005\793E\7FA4\975E\5E38\5BE6\7528.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:<ul>'),
unistr('<li>\80FD\5920\5B9A\7FA9\901A\77E5</li>'),
unistr('<li>\5728\61C9\7528\7A0B\5F0F\9996\9801\4E0A\986F\793A\901A\77E5</li>'),
unistr('<li>\80FD\5920\63A7\5236\901A\77E5\986F\793A\7684\6642\9593</li>'),
unistr('<li>\652F\63F4\4EE5\8272\5F69\5340\5206\901A\77E5\7684\985E\578B</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499149796874317)
,p_name=>'CA.NOTIFICATION.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502686880874320)
,p_name=>'CA.NUM.ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\6578\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625132287873685)
,p_name=>'CA.NUMBER.OF.ARGUMENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F15\6578\6578\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621725792873683)
,p_name=>'CA.NUMBER.OF.DESTINATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\7684\5730\6578\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535487059874344)
,p_name=>'CA.NUMBERFORMATMASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\5B57\683C\5F0F\906E\7F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504116407874321)
,p_name=>'CA.OCCURRENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\51FA\73FE\6B21\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286544138583874351)
,p_name=>'CA.ONE.ADMIN.REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9664\975E\6709\53E6\4E00\4F4D\7BA1\7406\54E1, \5426\5247\60A8\7121\6CD5\57F7\884C\6B64\52D5\4F5C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510993158874326)
,p_name=>'CA.OPEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F85\8655\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483901603874306)
,p_name=>'CA.ORGANIZING.PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\7E54\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484274049874306)
,p_name=>'CA.ORGANIZING.PAGES.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F9D\5E0C\671B\5728\61C9\7528\7A0B\5F0F\4E2D\986F\793A\7684\9806\5E8F\6392\5217\9801\9762. <br>'),
unistr('\82E5\60F3\91CD\65B0\6392\5217\6E05\55AE\4E2D\9801\9762\7684\9806\5E8F, \8ACB\6309\4F4F\6BCF\500B\9801\9762\6E05\55AE\7D50\5C3E\8655\7684<em>\62D6\66F3\4EE5\91CD\65B0\6392\5217\9801\9762</em>\5716\793A ( <span class="fa fa-bars" aria-hidden="true"></span> ), \7136\5F8C\5C07\8A72\9801\9762\4E0A\4E0B\62D6\653E.</p>'),
unistr('<p>\9996\9801\4E00\5F8B\6703\512A\5148\986F\793A, \800C\4E14\4E0D\80FD\91CD\65B0\6392\5217.<br>'),
unistr('\7BA1\7406\9801\9762\4E00\5F8B\6703\986F\793A\5728\6E05\55AE\5E95\7AEF, \800C\5B83\5011\7684\9806\5E8F\6703\6C7A\5B9A\9019\4E9B\9801\9762\5728\300C\7BA1\7406\300D\9801\9762\4E4B\300C\61C9\7528\7A0B\5F0F\7BA1\7406\300D\6E05\55AE\4E2D\7684\986F\793A\9806\5E8F.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627280387873687)
,p_name=>'CA.OUTPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628421012873688)
,p_name=>'CA.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502374290874320)
,p_name=>'CA.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505541735874322)
,p_name=>'CA.PAGE.EVENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518064189874331)
,p_name=>'CA.PAGE.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\8AAA\660E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504643397874321)
,p_name=>'CA.PAGE.ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773596718873789)
,p_name=>'CA.PAGE.MD.EDIT_MASTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\4E3B\8981\8A18\9304')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773726214873789)
,p_name=>'CA.PAGE.MD.PERFORM_SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286501984574874319)
,p_name=>'CA.PAGE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517351452874331)
,p_name=>'CA.PAGE.NAVIGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\5C0E\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504054323874321)
,p_name=>'CA.PAGE.PERFORMANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6548\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530038233874340)
,p_name=>'CA.PAGE.TYPE.NOT.VALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\985E\578B "%0" \4E0D\662F\4E00\500B\6709\6548\7684\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503381360874320)
,p_name=>'CA.PAGE.VIEWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484488590874306)
,p_name=>'CA.PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484560272874306)
,p_name=>'CA.PAGES.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5B9A\7FA9\521D\59CB\61C9\7528\7A0B\5F0F\6240\8981\5305\62EC\7684\9801\9762. \60A8\81F3\5C11\5FC5\9808\5148\5B9A\7FA9\4E00\500B\9801\9762\5F8C, \624D\80FD\5EFA\7ACB\61C9\7528\7A0B\5F0F.</p>'),
unistr('<p>\60A8\53EF\4EE5\4F7F\7528\6B64\7CBE\9748\5EFA\7ACB\4E0D\9650\6578\76EE\7684\9801\9762, \4EE5\64B0\5BEB\61C9\7528\7A0B\5F0F. \5EFA\7ACB\61C9\7528\7A0B\5F0F\4E4B\5F8C, \53EF\4F7F\7528\300C\5EFA\7ACB\9801\9762\7CBE\9748\300D\65B0\589E\66F4\591A\9801\9762.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535389673874344)
,p_name=>'CA.PAGINATIONMETHOD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\9801\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503657584874321)
,p_name=>'CA.PARTIAL.PAGE.VIEWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\90E8\5206\9801\9762\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509463035874325)
,p_name=>'CA.PHOTO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510051893874325)
,p_name=>'CA.PHOTO.DELETED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7247\5DF2\522A\9664.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509571024874325)
,p_name=>'CA.PHOTO.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7247\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509208816874325)
,p_name=>'CA.PHOTO.UPLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F8\7247\4E0A\50B3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514044646874328)
,p_name=>'CA.PLAIN.TEXT.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D14\6587\5B57\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286543753306874350)
,p_name=>'CA.POSITIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\597D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496814404874315)
,p_name=>'CA.PREFERENCES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\504F\597D\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286541378168874348)
,p_name=>'CA.PREVIOUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536011476874345)
,p_name=>'CA.PRIMARYDISPLAYCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536958015874345)
,p_name=>'CA.PRIMARYKEYCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\7D22\5F15\9375\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537012121874345)
,p_name=>'CA.PRIMARYPARENTTABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\7236\9805\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504200447874321)
,p_name=>'CA.PROCEDURE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A0B\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497473461874316)
,p_name=>'CA.PROCESS.EMAIL.SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96FB\5B50\90F5\4EF6\504F\597D\8A2D\5B9A\5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773105905873788)
,p_name=>'CA.PROCESS.FETCH_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\64F7\53D6\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498610119874317)
,p_name=>'CA.PROCESS.THEME.PREFERENCE.SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\5916\89C0\8A2D\5B9A\503C\5DF2\5132\5B58.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497330554874316)
,p_name=>'CA.PROCESS.TIME.ZONE.SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6642\5340\504F\597D\8A2D\5B9A\5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509827269874325)
,p_name=>'CA.PROFILE.PHOTO.DOWNLOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\6A94\76F8\7247\4E0B\8F09')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625420090873685)
,p_name=>'CA.PROGRAM.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A0B\5F0F\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625552024873685)
,p_name=>'CA.PROGRAM.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A0B\5F0F\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536341144874345)
,p_name=>'CA.QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622272733873683)
,p_name=>'CA.RAISE.EVENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F15\767C\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285254075453873414)
,p_name=>'CA.RATING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A55\6BD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507792845874324)
,p_name=>'CA.READERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95B1\8B80\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286497191708874316)
,p_name=>'CA.RECEIVE.EMAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63A5\6536\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539928301874347)
,p_name=>'CA.RECENT.ERRORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\8FD1\767C\751F\7684\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280314387874151)
,p_name=>'CA.RECENT.ERRORS.LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286280482347874151)
,p_name=>'CA.RECENT.ERRORS.VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499346622874317)
,p_name=>'CA.RED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D05\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512999564874327)
,p_name=>'CA.REFERENCED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\53C3\7167')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772211641873788)
,p_name=>'CA.REFRESH.ADMIN_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406\7BA1\7406\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285389605129873513)
,p_name=>'CA.REFRESH.ON.DIALOG.CLOSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0D\8A71\65B9\584A\95DC\9589\6642\91CD\65B0\6574\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285773680788873789)
,p_name=>'CA.REFRESH_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498881038874317)
,p_name=>'CA.REGION.BUTTONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498750867874317)
,p_name=>'CA.REGION.FORM.ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\9805\76EE\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504797371874321)
,p_name=>'CA.REGION.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516773830874330)
,p_name=>'CA.RELEASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7248\6B21 %0')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484065198874306)
,p_name=>'CA.REMOVING.PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286484187487874306)
,p_name=>'CA.REMOVING.PAGES.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6309\4E00\4E0B<strong>\7DE8\8F2F</strong>\4EE5\9078\53D6\9801\9762; \7136\5F8C\6309\4E00\4E0B<strong>\522A\9664\9801\9762</strong>, \4EE5\79FB\9664\61C9\7528\7A0B\5F0F\4E2D\7684\9801\9762.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626874295873686)
,p_name=>'CA.REPEAT.INTERVAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8907\9593\9694')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488326488873584)
,p_name=>'CA.REPLY.TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\8986')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489884526874310)
,p_name=>'CA.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\5831\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286489724459874310)
,p_name=>'CA.REPORT.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\70BA\4E92\52D5\5F0F\5831\8868\6216\4E00\822C\5831\8868\7684\9801\9762.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\67E5\8A62\985E\578B</strong> - \9078\53D6\5831\8868\7684\4F86\6E90 [<strong>\8868\683C\6216\8996\89C0\8868</strong>\6216 <strong>SQL \67E5\8A62</strong>]:<br>'),
unistr('    <strong>\8868\683C\6216\8996\89C0\8868</strong>:'),
'    <ul>',
unistr('      <li>\8868\683C\6216\8996\89C0\8868 (\5FC5\8981) - \9078\53D6\5831\8868\7684\8CC7\6599\5EAB\7269\4EF6.</li>'),
unistr('      <li>\5305\62EC\8868\55AE - \9078\53D6\5373\53EF\5305\62EC\4E00\500B\9023\7D50\7684\8868\55AE\9801\9762, \4F9B\4F7F\7528\8005\7DAD\8B77\8868\683C\503C.</li>'),
'    </ul>',
unistr('    <strong>SQL \67E5\8A62</strong>:'),
'    <ul>',
unistr('      <li>SQL \67E5\8A62 (\5FC5\8981) - \8F38\5165\50B3\56DE\4E0D\540C\8CC7\6599\6B04\7684\6709\6548 SQL \6558\8FF0\53E5.</li>'),
'    </ul>',
'  </li>',
unistr('  <li><strong>\5831\8868\985E\578B</strong> - \9078\53D6\5831\8868\985E\578B (<strong>\4E92\52D5\5F0F\5831\8868</strong>\6216<strong>\4E00\822C\5831\8868</strong>).</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481587754874304)
,p_name=>'CA.REPORT.N.WITH.FORM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\542B\8868\55AE\7684 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286326347297874185)
,p_name=>'CA.REPORT.TABLE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539013749874347)
,p_name=>'CA.REPORT.VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\6AA2\8996')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537694614874346)
,p_name=>'CA.REPORTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628294593873687)
,p_name=>'CA.REQ.START.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\6C42\7684\958B\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537833935874346)
,p_name=>'CA.REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514852244874329)
,p_name=>'CA.RESET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8A2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510828037874326)
,p_name=>'CA.RESOLVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\89E3\6C7A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510533895874326)
,p_name=>'CA.RESPONSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\61C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623565670873684)
,p_name=>'CA.RESTART.ON.FAILURE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5931\6557\6642\91CD\65B0\555F\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623653132873684)
,p_name=>'CA.RESTART.ON.RECOVERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FA9\539F\6642\91CD\65B0\555F\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285620866876873682)
,p_name=>'CA.RESTARTABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\91CD\65B0\555F\52D5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285623178591873684)
,p_name=>'CA.RETRY.COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\8A66\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532859732874342)
,p_name=>'CA.ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504920966874321)
,p_name=>'CA.ROW.NUMBER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\7DE8\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514227482874328)
,p_name=>'CA.ROW.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532259057874342)
,p_name=>'CA.ROW.TEMPLATE.HTML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\6A23\677F HTML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533525843874343)
,p_name=>'CA.ROWS.CONTENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\5167\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505608940874322)
,p_name=>'CA.ROWS.FETCHED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\64F7\53D6\7684\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286535202040874344)
,p_name=>'CA.ROWSPERPAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\9801\8CC7\6599\5217\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626415627873686)
,p_name=>'CA.RUN.COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628028222873687)
,p_name=>'CA.RUN.DURATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\6301\7E8C\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622913022873684)
,p_name=>'CA.SCHEDULE.LIMIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\7A0B\9650\5236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624925458873685)
,p_name=>'CA.SCHEDULE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\7A0B\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285625010321873685)
,p_name=>'CA.SCHEDULE.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\7A0B\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624838897873685)
,p_name=>'CA.SCHEDULE.TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\7A0B\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492350664874312)
,p_name=>'CA.SCHEMA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DB1\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492495500874312)
,p_name=>'CA.SCHEMA.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\9078\53D6\8CC7\6599\5EAB\7DB1\8981, \5176\4E2D\5132\5B58\4E86\60A8\8981\5728\6B64\61C9\7528\7A0B\5F0F\4E2D\4F7F\7528\7684\8CC7\6599\5EAB\7269\4EF6.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534381582874343)
,p_name=>'CA.SCOPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\570D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514903091874329)
,p_name=>'CA.SEARCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515067234874329)
,p_name=>'CA.SEARCH.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286515150166874329)
,p_name=>'CA.SEARCH.DIALOG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\5C0D\8A71\65B9\584A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539247600874347)
,p_name=>'CA.SEARCH.FILTERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\7BE9\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521867072874334)
,p_name=>'CA.SEARCH.HIDDEN.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6B64\9801\9762\4E0D\6703\986F\793A\7A31\70BA\300C\5DF2\641C\5C0B\8868\683C\300D\7684\300C\5171\7528\5143\4EF6\300D\6E05\55AE.'),
'',
unistr('\6240\6709\6700\521D\5F9E\300C\5EFA\7ACB\61C9\7528\7A0B\5F0F\300D\7CBE\9748\7522\751F\7684\4E92\52D5\5F0F\5831\8868\9801\9762\90FD\6703\81EA\52D5\52A0\5230\6B64\6E05\55AE\4E2D. '),
unistr('\82E5\8981\5C07\81EA\5DF1\7684\8868\683C\52A0\5230\6B64\6E05\55AE\4E2D, \8ACB\700F\89BD\81F3\300C\5171\7528\5143\4EF6\300D, \9078\53D6\300C\6E05\55AE\300D, \7136\5F8C\6309\4E00\4E0B\300C\5DF2\641C\5C0B\8868\683C\300D.'),
unistr('  \8F38\5165\4E0B\5217\5C6C\6027:'),
unistr('    \9805\76EE: \6E05\55AE\9805\76EE\6A19\7C64 - \8F38\5165\8868\683C\7684\986F\793A\540D\7A31.'),
unistr('    \76EE\6A19: \9801\9762 - \9078\53D6\8981\700F\89BD\7684\9069\7576\9801\9762 (\6700\597D\662F\4E92\52D5\5F0F\5831\8868)'),
unistr('    \76EE\6A19: \6E05\9664\5FEB\53D6 - \8F38\5165\9700\8981\6E05\9664\7684\6240\6709\9801\9762 (\4E00\822C\548C\300C\9801\9762\300D\4E0B\8F38\5165\7684\6578\5B57\76F8\540C).'),
unistr('       \82E5\662F\700F\89BD\81F3\300C\4E92\52D5\5F0F\5831\8868\300D\9801\9762, \8ACB\65B0\589E CIR,RIR \4EE5\6E05\9664\4EFB\4F55\73FE\6709\7684\7BE9\9078\7B49\7B49.'),
unistr('    \76EE\6A19: \8A2D\5B9A\9019\4E9B\9805\76EE - \9078\53D6 (\6216\8F38\5165) \8981\586B\5165\7684\9069\7576\9801\9762\9805\76EE.'),
unistr('       \82E5\662F\700F\89BD\81F3\300C\4E92\52D5\5F0F\5831\8868\300D\9801\9762, \8ACB\8F38\5165 IR_[COLUMN_NAME].'),
unistr('    \76EE\6A19: \4F7F\7528\9019\4E9B\503C - \8F38\5165 =PK='),
unistr('    \4F7F\7528\8005\5B9A\7FA9\5C6C\6027: 1 - \8F38\5165\8981\641C\5C0B\5167\5BB9\7684\8868\683C\540D\7A31 (\5927\5BEB\5B57\6BCD).'),
unistr('    \4F7F\7528\8005\5B9A\7FA9\5C6C\6027: 2 - \8F38\5165\4E3B\8981\8CC7\6599\6B04\540D\7A31 (\5927\5BEB\5B57\6BCD).'),
unistr('    \4F7F\7528\8005\5B9A\7FA9\5C6C\6027: 3 (\9078\64C7\6027) -  \8981\641C\5C0B\7684\8CC7\6599\6B04\6E05\55AE (\4F7F\7528\9017\865F\5340\9694).'),
unistr('       \82E5\672A\6307\5B9A\4EFB\4F55\8CC7\6599\6B04, \5247\6703\641C\5C0B\6240\6709\6587\5B57 (varchar2) \548C\5B57\5143\5927\578B\7269\4EF6 (clob) \8CC7\6599\6B04.'),
'',
unistr('\6CE8\610F: \5982\679C\5217\51FA\4E00\500B\4EE5\4E0A\7684\8868\683C, \5247\53EA\6703\5C0D\4F7F\7528\8005\986F\793A\53EF\641C\5C0B\7684\8868\683C\6E05\55AE.')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514693234874329)
,p_name=>'CA.SEARCH.RESULTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\641C\5C0B\7D50\679C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536864132874345)
,p_name=>'CA.SECONDARYDISPLAYCOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B21\8981\986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511273609874326)
,p_name=>'CA.SELECTED.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\53D6\7684\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487673326873584)
,p_name=>'CA.SEND.BEGIN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\958B\59CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488079679873584)
,p_name=>'CA.SEND.COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\8A08\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487531624873584)
,p_name=>'CA.SEND.END'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\7D50\675F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487930187873584)
,p_name=>'CA.SEND.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542837272874350)
,p_name=>'CA.SEND.FEEDBACK.EMAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\9001\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542975042874350)
,p_name=>'CA.SEND.FEEDBACK.EMAILS.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C7A\5B9A\6536\5230\65B0\610F\898B\56DE\994B\6642\662F\5426\61C9\50B3\9001\96FB\5B50\90F5\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286539545597874347)
,p_name=>'CA.SEND.FROM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BC4\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532011100874342)
,p_name=>'CA.SEND.TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6536\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516515007874330)
,p_name=>'CA.SERIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \6578\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627999009873687)
,p_name=>'CA.SESSION.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\968E\6BB5\4F5C\696D ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534525316874343)
,p_name=>'CA.SESSIONSTATEPROTECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\968E\6BB5\4F5C\696D\72C0\614B\4FDD\8B77')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491729552874312)
,p_name=>'CA.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491886340874312)
,p_name=>'CA.SETTINGS.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\6307\5B9A\7528\65BC\7522\751F\61C9\7528\7A0B\5F0F\7684\8A2D\5B9A\503C.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516125213874330)
,p_name=>'CA.SHOW.ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388837764873512)
,p_name=>'CA.SHOW.HIDE.SCOPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A/\96B1\85CF\7BC4\570D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517262786874331)
,p_name=>'CA.SHOW.TIMEZONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\6642\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517032200874330)
,p_name=>'CA.SIGN.IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\767B\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518297414874331)
,p_name=>'CA.SIGN.OUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\767B\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285627838338873687)
,p_name=>'CA.SLAVE.PID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50D5\7AD9 PID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621833433873683)
,p_name=>'CA.SOURCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530112887874340)
,p_name=>'CA.SOURCE.TYPE.NOT.VALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\4F86\6E90\985E\578B\4E0D\662F\4E00\500B\6709\6548\7684\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286521987376874334)
,p_name=>'CA.SOURCES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285624709385873685)
,p_name=>'CA.START.DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\59CB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285626558843873686)
,p_name=>'CA.STATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537792092874346)
,p_name=>'CA.STATICDEFAULT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\975C\614B\9810\8A2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500918213874319)
,p_name=>'CA.STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622503943873683)
,p_name=>'CA.STOP.ON.WINDOW.CLOSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8996\7A97\95DC\9589\6642\505C\6B62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622692425873683)
,p_name=>'CA.STORE.OUTPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\653E\5340\8F38\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511437599874326)
,p_name=>'CA.SUBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\65E8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286510111306874325)
,p_name=>'CA.SUBMIT.FEEDBACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9001\51FA\610F\898B\56DE\994B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286534801210874344)
,p_name=>'CA.SUGGESTEDVISULIZATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\8B70\7684\8996\89BA\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526725528874338)
,p_name=>'CA.SUPPORTING.OBJECTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\652F\63F4\7684\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526895884874338)
,p_name=>'CA.SUPPORTING.OBJECTS.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('<p>\5728\5B89\88DD\547D\4EE4\6A94\4E2D\8F38\5165\7A0B\5F0F\78BC, \901A\5E38\7528\65BC\5EFA\7ACB\6216\64CD\63A7\8CC7\6599\5EAB\7269\4EF6, \6216\662F\5C0D\73FE\6709\8A18\9304\57F7\884C\63D2\5165/\66F4\65B0/\522A\9664. \5728\89E3\9664\5B89\88DD\547D\4EE4\6A94\4E2D\8F38\5165\7A0B\5F0F\78BC, \901A\5E38\7528\65BC\79FB\9664 (\522A\9664) \8CC7\6599\5EAB\7269\4EF6. \9019\4E9B\547D\4EE4\6A94\5C07\6703\4F75\5165\652F\63F4\7269\4EF6, \4EE5\4FBF\60A8\532F\51FA\61C9\7528\7A0B\5F0F\6642\6703\5728\6E2C\8A66\548C\751F\7522\74B0\5883\4E2D\57F7\884C\76F8\540C\7684\66F4\65B0.</p>')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526993198874338)
,p_name=>'CA.SUPPORTING.OBJECTS.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5728\5B89\88DD\547D\4EE4\6A94\4E2D\8F38\5165\532F\5165\61C9\7528\7A0B\5F0F\5F8C\6703\57F7\884C\7684\6709\6548 SQL \548C (\6216) PL/SQL \6558\8FF0\53E5.</p>'),
unistr('<p>\5982\679C\4E5F\8981\5728\76EE\524D\7684\74B0\5883\4E2D\57F7\884C\9019\4E9B\6558\8FF0\53E5, \800C\4E0D\662F\53EA\5728\5C07\61C9\7528\7A0B\5F0F\532F\5165\5176\4ED6\74B0\5883\6642\57F7\884C, \8ACB\6309\4E00\4E0B<strong>\5EFA\7ACB\61C9\7528\7A0B\5F0F\6642\57F7\884C</strong>.</p>'),
unistr('<p>\5728\89E3\9664\5B89\88DD\547D\4EE4\6A94\4E2D\8F38\5165\61C9\7528\7A0B\5F0F\81EA\61C9\7528\7A0B\5F0F\7522\751F\5668\522A\9664\5F8C\6703\57F7\884C\7684\6709\6548 SQL \548C (\6216) PL/SQL \6558\8FF0\53E5.</p>'),
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285622127939873683)
,p_name=>'CA.SYSTEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7CFB\7D71')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286536289006874345)
,p_name=>'CA.TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492502382874312)
,p_name=>'CA.TABLE.PREFIX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67B6\69CB\7269\4EF6\524D\7F6E\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286492677557874312)
,p_name=>'CA.TABLE.PREFIX.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F38\5165\4F9B\61C9\7528\7A0B\5F0F\4F7F\7528\7684\7269\4EF6\524D\7F6E\78BC. \90E8\5206\529F\80FD\6703\5728\5176\5EFA\7ACB\7684\8CC7\6599\5EAB\7269\4EF6\52A0\4E0A\6B64\524D\7F6E\78BC (\5305\62EC\5957\88DD\7A0B\5F0F\548C\8868\683C).</p>'),
unistr('<p>\8B66\544A: \8ACB\78BA\5B9A\8F38\5165\672A\7531\5176\4ED6\61C9\7528\7A0B\5F0F\4F7F\7528\7684\552F\4E00\524D\7F6E\78BC. \5982\679C\4E0D\662F\975E\552F\4E00\7684, \5EFA\7ACB\61C9\7528\7A0B\5F0F\6642\53EF\80FD\6703\767C\751F\932F\8AA4, \800C\4E14\7121\6CD5\6B63\5E38\904B\4F5C.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286537100859874345)
,p_name=>'CA.TABLECOLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532190756874342)
,p_name=>'CA.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286514545524874329)
,p_name=>'CA.TEMPLATE.EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\6A23\677F\540D\7A31\5DF2\7D93\88AB\4F7F\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286511315428874326)
,p_name=>'CA.TEMPLATE.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A23\677F\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500093110874318)
,p_name=>'CA.TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285487856938873584)
,p_name=>'CA.TEXT.BODY.SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57\5167\6587\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512556888874327)
,p_name=>'CA.TEXT.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498236921874316)
,p_name=>'CA.THEME.PREFERENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\822C\4F7F\7528\8005\4E3B\984C\504F\597D\8A2D\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498421718874317)
,p_name=>'CA.THEME.PREFERENCE.HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52FE\9078\5F8C, \4E00\822C\4F7F\7528\8005\5C31\53EF\4EE5\4F7F\7528\300C\81EA\8A02\300D\9023\7D50, \9078\64C7\6240\9700\7684\4E3B\984C\6A23\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286498320131874317)
,p_name=>'CA.THEME.PREFERENCE.LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4E00\822C\4F7F\7528\8005\9078\64C7\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482660186874305)
,p_name=>'CA.THEME.SELECTOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286481096185874303)
,p_name=>'CA.THEME.SELECTOR.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\9810\8A2D\61C9\7528\7A0B\5F0F\5916\89C0\8207\611F\89BA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286482774271874305)
,p_name=>'CA.THEME.SELECTOR.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8B93\7BA1\7406\54E1\80FD\5920\9078\53D6\61C9\7528\7A0B\5F0F\7684\9810\8A2D\8272\5F69\914D\7F6E (\4E3B\984C\6A23\5F0F). \7BA1\7406\54E1\4E5F\53EF\4EE5\9078\64C7\8B93\4E00\822C\4F7F\7528\8005\80FD\5920\9078\64C7\81EA\5DF1\7684\4E3B\984C\6A23\5F0F. \4E00\822C\4F7F\7528\8005\53EA\8981\6309\4E00\4E0B\9996\9801\5E95\7AEF\7684<em>\81EA\8A02</em>\6309\9215, \7136\5F8C\5F9E\53EF\7528\7684\4E3B\984C\6A23\5F0F\4E2D\9078\53D6\5373\53EF. \4F8B\5982, \6709\8996\529B\969C\7919\7684\4F7F\7528\8005\53EF\4EE5\9078\64C7\4F7F\7528\5177\6709\66F4\9AD8\8272\5F69\5C0D\6BD4\7684 <em>Vista</em> \4E3B\984C\6A23\5F0F.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\7BA1\7406\54E1\53EF\4EE5\5B9A\7FA9\9810\8A2D\4E3B\984C\6A23\5F0F</li>'),
unistr('<li>\8B93\4E00\822C\4F7F\7528\8005\80FD\5920\9078\53D6\4E0D\540C\7684\4E3B\984C\6A23\5F0F</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491169097874311)
,p_name=>'CA.THEME.STYLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286491238681874311)
,p_name=>'CA.THEME.STYLE.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9078\53D6\7528\65BC\986F\793A\61C9\7528\7A0B\5F0F\7684\9810\8A2D\4E3B\984C\6A23\5F0F.</p>'),
unistr('<p>\6A23\5F0F\53EF\5FEB\901F\5730\8B8A\66F4\70BA\53E6\4E00\500B\9810\5148\5B9A\7FA9\7684\6A23\5F0F, \6216\7522\751F\5F8C\518D\4FEE\6539\7684\6A23\5F0F. \82E5\8981\8B8A\66F4\6A23\5F0F, \8ACB\57F7\884C\61C9\7528\7A0B\5F0F, \7136\5F8C\6309\4E00\4E0B\300C\958B\767C\4EBA\54E1\300D\5DE5\5177\5217\4E2D\7684<strong>\4E3B\984C\6372\52D5\5668</strong>.</p>')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505282396874322)
,p_name=>'CA.TIME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286496988187874316)
,p_name=>'CA.TIME.ZONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6642\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483710439874305)
,p_name=>'CA.TIME.ZONE.SUPPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6642\5340\652F\63F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286480680739874303)
,p_name=>'CA.TIME.ZONE.SUPPORT.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\9810\8A2D\503C\548C\4F7F\7528\8005\6642\5340')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483419161874305)
,p_name=>'CA.TIME.ZONE.SUPPORT.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8A31\4E00\822C\4F7F\7528\8005\8A2D\5B9A\81EA\5DF1\7684\672C\5730\6642\5340. \9019\9805\529F\80FD\5F88\91CD\8981, \82E5\61C9\7528\7A0B\5F0F\8868\683C\4F7F\7528\4E86\6642\5340\611F\77E5\7684\8CC7\6599\985E\578B (\4F8B\5982\672C\5730\6642\5340\7684\6642\6233), \5982\6B64\4E00\4F86\5831\8868\548C\8CC7\6599\9805\76EE\4FBF\6703\53CD\6620\4E00\822C\4F7F\7528\8005\7684\6240\5728\4F4D\7F6E.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\5141\8A31\7BA1\7406\54E1\8A2D\5B9A\9810\8A2D\6642\5340</li>'),
unistr('<li>\5141\8A31\4E00\822C\4F7F\7528\8005\9078\53D6\81EA\5DF1\7684\6642\5340\504F\597D\8A2D\5B9A</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540136515874348)
,p_name=>'CA.TIMEFRAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6642\9593\7BC4\570D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540410018874348)
,p_name=>'CA.TIMELINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\6642\9593\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286540566203874348)
,p_name=>'CA.TIMELINE.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\986F\793A\6642\9593\8868\7684\9801\9762, \9019\5C0D\986F\793A\66F4\65B0\7279\5225\6709\7528.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\9801\9762\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\8868\683C\6216\8996\89C0\8868</strong> (\5FC5\8981) - \9078\53D6\6642\9593\8868\7684\8CC7\6599\5EAB\7269\4EF6.</li>'),
unistr('  <li><strong>\4F7F\7528\8005\540D\7A31</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7576\4F5C\6642\9593\8868\9805\76EE\4E4B\986F\793A\4F7F\7528\8005\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\65E5\671F</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7576\4F5C\6642\9593\8868\9805\76EE\65E5\671F\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\4E8B\4EF6\540D\7A31</strong> (\5FC5\8981) - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7576\4F5C\6642\9593\8868\9805\76EE\6A19\984C\7684\8CC7\6599\6B04.</li>'),
unistr('  <li><strong>\63CF\8FF0</strong> - \5F9E\8868\683C\6216\8996\89C0\8868\4E2D\9078\53D6\7576\4F5C\6642\9593\8868\9805\76EE\63CF\8FF0\7684\8CC7\6599\6B04.</li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502148457874319)
,p_name=>'CA.TIMESTAMP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6642\6233')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506725690874323)
,p_name=>'CA.TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285488472316873585)
,p_name=>'CA.TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6536\4EF6\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286505938101874322)
,p_name=>'CA.TOP.USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506094542874322)
,p_name=>'CA.TOP.USERS.CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005\5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503536810874320)
,p_name=>'CA.TOTAL.ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\7E3D\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286507932884874324)
,p_name=>'CA.TREAT.AUTH.USERS.NO.IN.ACL.AS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5728\5B58\53D6\63A7\5236\6E05\55AE\4E2D\7684\4F7F\7528\8005\9810\8A2D\89D2\8272:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500124218874318)
,p_name=>'CA.TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285719076682873752)
,p_name=>'CA.UI.DEFAULTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4ECB\9762\9810\8A2D\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285719121252873752)
,p_name=>'CA.UI.DEFAULTS.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\4F7F\7528\8005\4ECB\9762\8A2D\5B9A\503C\7684\9810\8A2D\503C, \4F8B\5982\6BCF\9801\7684\8CC7\6599\5217\6578\76EE\53CA\65B0\589E\503C\6E05\55AE\5B9A\7FA9. \5728\61C9\7528\7A0B\5F0F\4E2D\7522\751F\5143\4EF6\6642, \6703\4F7F\7528\9019\4E9B\8A2D\5B9A\503C. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500321977874318)
,p_name=>'CA.UNTIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76F4\5230')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772038378873788)
,p_name=>'CA.UPDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286509754380874325)
,p_name=>'CA.UPDATE.PROFILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\8A2D\5B9A\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500617674874318)
,p_name=>'CA.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286500707373874318)
,p_name=>'CA.UPDATED.BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286502070260874319)
,p_name=>'CA.USER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529651518874340)
,p_name=>'CA.USER.ADD_MULTIPLE_1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\591A\500B\4F7F\7528\8005 - \6B65\9A5F 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529758875874340)
,p_name=>'CA.USER.ADD_MULTIPLE_2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\591A\500B\4F7F\7528\8005 - \6B65\9A5F 2')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529852785874340)
,p_name=>'CA.USER.ADD_MULTIPLE_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\591A\500B\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286504426543874321)
,p_name=>'CA.USER.AGENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\4EE3\7406\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286517873683874331)
,p_name=>'CA.USER.COUNTS.REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\6578\76EE\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506233718874322)
,p_name=>'CA.USER.NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508723428874324)
,p_name=>'CA.USER.PROFILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\8A2D\5B9A\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483656602874305)
,p_name=>'CA.USER.PROFILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\8A2D\5B9A\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286480587613874303)
,p_name=>'CA.USER.PROFILES.DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5141\8A31\4F7F\7528\8005\66F4\65B0\81EA\5DF1\7684\8A2D\5B9A\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286483536002874305)
,p_name=>'CA.USER.PROFILES.DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5141\8A31\4E00\822C\4F7F\7528\8005\8F38\5165\95DC\65BC\81EA\5DF1\7684\5176\4ED6\8CC7\8A0A (\5305\62EC\5716\7247\6216\5927\982D\8CBC), \5C07\4ED6\5011\7684\5E33\6236\500B\4EBA\5316.</p>'),
unistr('<p>\5305\62EC\4E0B\5217\5143\4EF6:'),
'<ul>',
unistr('<li>\8A2D\5B9A\4E00\822C\4F7F\7528\8005\8A2D\5B9A\6A94\7684\8A2D\5B9A\9801\9762</li>'),
unistr('<li>\4E0A\50B3\5716\7247 / \5927\982D\8CBC\7684\529F\80FD</li>'),
'</ul>',
'</p>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508993629874324)
,p_name=>'CA.USERNAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508072869874324)
,p_name=>'CA.USERNAME.FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530541274874340)
,p_name=>'CA.USERNAMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285726756143873757)
,p_name=>'CA.USERNAME_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531177957874341)
,p_name=>'CA.USERS.ADDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\5DF2\65B0\589E.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286532672594874342)
,p_name=>'CA.USERS.BY.ROLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F9D\89D2\8272\5340\5206\7684\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286512198192874327)
,p_name=>'CA.USERS.INCLUDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\542B\7684\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286530874055874341)
,p_name=>'CA.USERS.TO.ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\65B0\589E\7684\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508236664874324)
,p_name=>'CA.USRENAME.FORMAT.UPDATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31\683C\5F0F\5DF2\66F4\65B0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285409087685873527)
,p_name=>'CA.VALID.USER.EXIST.PAGEINFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6709\6548\7684\4F7F\7528\8005\5B58\5728 - \9801\9762\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523834841874336)
,p_name=>'CA.VALIDATION.APP.ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\61C9\7528\7A0B\5F0F ID\300D\5DF2\7D93\5B58\5728, \6216\662F\4FDD\7559\4F9B\5176\4ED6\61C9\7528\7A0B\5F0F\4F7F\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285667384913873716)
,p_name=>'CA.VALIDATION.APP.NAME.NOT.NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\6307\5B9A\61C9\7528\7A0B\5F0F\540D\7A31.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533236596874342)
,p_name=>'CA.VALIDATION.EMAIL.REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\63D0\4F9B\96FB\5B50\90F5\4EF6\5730\5740\4EE5\50B3\9001\96FB\5B50\90F5\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533096593874342)
,p_name=>'CA.VALIDATION.EMAIL.ROLE.REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\63D0\4F9B\96FB\5B50\90F5\4EF6\5730\5740\6216\9078\53D6\4E00\7D44\4F7F\7528\8005\4EE5\50B3\9001\96FB\5B50\90F5\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533149976874342)
,p_name=>'CA.VALIDATION.ROLE.REQUIRED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\9078\53D6\4E00\7D44\4F7F\7528\8005\4EE5\50B3\9001\96FB\5B50\90F5\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286523929446874336)
,p_name=>'CA.VALIDATION.TABLE.PREFIX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C\524D\7F6E\78BC\4E0D\80FD\8D85\904E 6 \500B\5B57\5143, \5FC5\9808\4EE5\5B57\6BCD\70BA\958B\982D, \800C\4E14\53EA\80FD\5305\542B\5B57\6BCD\3001\6578\5B57\4EE5\53CA\5E95\7DDA.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524084580874336)
,p_name=>'CA.VALIDATION.TABLE.PREFIX.USED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\8F38\5165\5176\4ED6\8868\683C\524D\7F6E\78BC. \4E0B\5217\8CC7\6599\5EAB\7269\4EF6\5DF2\7D93\5B58\5728: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508650660874324)
,p_name=>'CA.VERIFY.EMAIL.ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8005\540D\7A31\4E0D\662F\6709\6548\7684\96FB\5B50\90F5\4EF6\5730\5740\683C\5F0F. \8ACB\6CE8\610F\4E0B\65B9\7684\61C9\7528\7A0B\5F0F\4F7F\7528\8005\540D\7A31\683C\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286508555303874324)
,p_name=>'CA.VERIFY.EMAIL.FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9A57\8B49\96FB\5B50\90F5\4EF6\5730\5740\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506163274874322)
,p_name=>'CA.VIEW.AS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286527597426874338)
,p_name=>'CA.VIEW.BLUEPRINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\85CD\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286516002943874330)
,p_name=>'CA.VIEW.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\8A73\7D30\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286533496674874343)
,p_name=>'CA.VIEW.EMAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\96FB\5B50\90F5\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286518151023874331)
,p_name=>'CA.VIEW.MY.PROFILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6AA2\8996\6211\7684\8A2D\5B9A\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286503068898874320)
,p_name=>'CA.WEIGHTED.PERFORMANCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52A0\6B0A\6548\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286538030459874346)
,p_name=>'CA.WIDTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BEC\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542215772874349)
,p_name=>'CA.WIZARD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7CBE\9748\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285408949058873527)
,p_name=>'CA.WIZARD.CONTAINER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7CBE\9748\5BB9\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286542336802874349)
,p_name=>'CA.WIZARD.DETAILS'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5EFA\7ACB\4E00\500B\7576\4F5C\7CBE\9748\7684\9801\9762\96C6\5408. \7CBE\9748\901A\5E38\7528\65BC\8F38\5165\591A\500B\6B65\9A5F\7684\8CC7\6599.</p>'),
unistr('<p>\8F38\5165\4E0B\5217\5C6C\6027:</p>'),
'<ul>',
unistr('  <li><strong>\7CBE\9748\540D\7A31</strong> (\5FC5\8981) - \8F38\5165\6B64\9801\9762\7684\540D\7A31.</li>'),
unistr('  <li><strong>\8A2D\5B9A\5716\793A</strong> - \9078\53D6\6B64\9801\9762\5728\5C0E\89BD\529F\80FD\8868\4E2D\7684\986F\793A\5716\793A.</li>'),
unistr('  <li><strong>\9801\9762\6A21\5F0F</strong> (\5FC5\8981) - \9078\53D6\7CBE\9748\6B65\9A5F\662F\8981\986F\793A\70BA\5F37\5236\56DE\61C9\9801\9762\9084\662F\4E00\822C\9801\9762. \8ACB\9078\53D6<strong>\5F37\5236\56DE\61C9\9801\9762</strong>\6216<strong>\5B8C\6574\9801\9762</strong>.</li>'),
unistr('  <li><strong>\6B65\9A5F 1 ... 8</strong> - \8F38\5165\7CBE\9748\5404\6B65\9A5F\7684\9801\9762\540D\7A31.<br><em><strong>\6CE8\610F:</strong> \8F38\5165\524D\9762\5404\6B65\9A5F\7684\540D\7A31\5F8C, \7CFB\7D71\5C31\6703\986F\793A 5 - 8 \6B65\9A5F.</em></li>'),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286506588468874323)
,p_name=>'CA.WORK.PHONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\516C\53F8\96FB\8A71\865F\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286499267930874317)
,p_name=>'CA.YELLOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9EC3\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285719667821873752)
,p_name=>'CA.YES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\662F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253955358873414)
,p_name=>'CACHED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5FEB\53D6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285137639101873328)
,p_name=>'CACHE_CREATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5EFA\7ACB\5FEB\53D6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285125150905873319)
,p_name=>'CALENDAR.CHECK.AJAX_DELETE_NOT_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\522A\9664\8CC7\6599\300D\529F\80FD\76EE\524D\505C\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285109607116873308)
,p_name=>'CALENDAR.CHECK.AJAX_INSERT_NOT_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\529F\80FD\76EE\524D\505C\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285109792829873308)
,p_name=>'CALENDAR.CHECK.AJAX_UPDATE_NOT_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\8CC7\6599\529F\80FD\76EE\524D\505C\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285292902346873442)
,p_name=>'CALENDAR.NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285292874522873442)
,p_name=>'CALENDAR.PREVIOUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\4E00\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285150599738873338)
,p_name=>'CALENDAR_EASY_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7C21\6613\884C\4E8B\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286314001353874176)
,p_name=>'CALENDAR_ENTRY_EDIT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\884C\4E8B\66C6\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285098266614873300)
,p_name=>'CALENDAR_POPUP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \7684\884C\4E8B\66C6\5373\73FE\5F0F\8996\7A97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285248767464873410)
,p_name=>'CALENDAR_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5EFA\7ACB\884C\4E8B\66C6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285651582082873704)
,p_name=>'CALENDAR_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\820A\6709\884C\4E8B\66C6\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285150490811873338)
,p_name=>'CALENDAR_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\884C\4E8B\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285502036682873595)
,p_name=>'CAL_TEMPLATE_NOT_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5617\8A66\5F9E\61C9\7528\7A0B\5F0F %0 \8907\88FD\6A23\677F ID \70BA %1 \7684\6A23\677F\6642, \627E\4E0D\5230\884C\4E8B\66C6\6A23\677F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285652980367873705)
,p_name=>'CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285091371485873295)
,p_name=>'CANDLESTICK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('K \7DDA\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285987622798873935)
,p_name=>'CASCADING STYLE SHEETS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\968E\5C64\5F0F\6A23\5F0F\8868')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285709034056873745)
,p_name=>'CENTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7F6E\4E2D')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285743112658873768)
,p_name=>'CHANGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286373295414874224)
,p_name=>'CHANGE_AUTHENTICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285647387611873701)
,p_name=>'CHANGE_DATABASE_SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\8CC7\6599\5EAB\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285265583475873423)
,p_name=>'CHANGE_PW_REQUEST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285647126035873701)
,p_name=>'CHANGE_REQUEST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\8981\6C42')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285934870143873897)
,p_name=>'CHANGE_WORKSPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B8A\66F4\5DE5\4F5C\5340')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285619190668873681)
,p_name=>'CHARACTER_SET_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B57\5143\96C6\8CC7\6599\6B04')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285344414017873480)
,p_name=>'CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285096672533873298)
,p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7121\6548\7684\5716\8868\67E5\8A62: %0<br><br> \8ACB\4F7F\7528\4E0B\5217\8A9E\6CD5:'),
'<pre>',
'SELECT LINK, LABEL, VALUE',
'FROM   ...',
'</pre>',
'<table class="instructiontext">',
'<tr><td>LINK</td><td>URL</td></tr>',
unistr('<tr><td>LABEL</td><td>\9577\689D\4E0A\7684\6587\5B57</td></tr>'),
unistr('<tr><td>VALUE</td><td>\5B9A\7FA9\9577\689D\5927\5C0F\7684\6578\5B57\8CC7\6599\6B04</td></tr>'),
'</table>',
''))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285287735109873439)
,p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7121\6548\7684\5716\8868\67E5\8A62.<br /><br /> \8ACB\4F7F\7528\4E0B\5217\8A9E\6CD5: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'),
'<table class="instructiontext">',
'<tr>',
'<td>VALUE</td>',
unistr('<td>\5B9A\7FA9\8A08\91CF\503C\7684\6578\503C\8CC7\6599\6B04.</td>'),
'</tr>',
'<tr>',
'<td>MAX</td>',
unistr('<td>\5B9A\7FA9\6700\5927\8A08\91CF\503C\7684\6578\503C\8CC7\6599\6B04.</td>'),
'</tr>',
'<tr>',
unistr('<td>LOW (\9078\64C7\6027)</td>'),
unistr('<td>\5B9A\7FA9\4E0A\4E00\500B\6700\5C0F\8A08\91CF\503C\7684\6578\503C\8CC7\6599\6B04.</td>'),
'</tr>',
'<tr>',
unistr('<td>HIGH (\9078\64C7\6027)</td>'),
unistr('<td>\5B9A\7FA9\4E0A\4E00\500B\6700\5927\8A08\91CF\503C\7684\6578\503C\8CC7\6599\6B04.</td>'),
'</tr>',
'</table>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285362642241873493)
,p_name=>'CHART.INVALID_CHART_TYPE_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6548\7684\5716\8868\985E\578B.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285096520434873298)
,p_name=>'CHART.INVALID_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\7121\6CD5\5256\6790 SQL \67E5\8A62!'),
'<p>%0</p>',
unistr('\67D0\4E9B\7279\5B9A\67E5\8A62\53EA\6709\5728\60A8\7684\61C9\7528\7A0B\5F0F\57F7\884C\6642\624D\80FD\57F7\884C, \5982\679C\60A8\67E5\8A62\7684\8A9E\6CD5\6B63\78BA, \90A3\60A8\53EF\4EE5\4E0D\9700\9A57\8B49\5C31\5C07\67E5\8A62\5132\5B58\8D77\4F86 (\8ACB\53C3\95B1\67E5\8A62\4F86\6E90\4E0B\65B9\7684\9078\9805).')))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286428438094874265)
,p_name=>'CHART_DEGREES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285596054127873664)
,p_name=>'CHART_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285125923260873320)
,p_name=>'CHART_SERIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\6578\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285643624065873699)
,p_name=>'CHART_SERIES_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%1 \7684\5716\8868\6578\5217\932F\8AA4 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285241988671873405)
,p_name=>'CHART_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5EFA\7ACB\5716\8868.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285201219452873375)
,p_name=>'CHECK$'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\9078\53D6\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286360908495874215)
,p_name=>'CHECKED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\52FE\9078')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285599937870873667)
,p_name=>'CHECKSUM_REQUIRED_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\7E3D\548C\6AA2\9A57 - \61C9\7528\7A0B\5F0F\5C64\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285416444129873532)
,p_name=>'CHECKSUM_REQUIRED_SESSION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\7E3D\548C\6AA2\9A57 - \968E\6BB5\4F5C\696D\5C64\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285416330292873532)
,p_name=>'CHECKSUM_REQUIRED_USER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\7E3D\548C\6AA2\9A57 - \4F7F\7528\8005\5C64\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285416275803873532)
,p_name=>'CHECKSUM_REQUIRED_WORKSPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981\7E3D\548C\6AA2\9A57 - \61C9\7528\7A0B\5F0F\5C64\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286430816018874266)
,p_name=>'CHECK_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\52FE\9078')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285583999397873656)
,p_name=>'CLASSIC_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\822C\884C\4E8B\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285586942406873658)
,p_name=>'CLASSIC_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\822C\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285286209557873438)
,p_name=>'CLASSIC_REPORT_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\822C\5831\8868\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285584550534873656)
,p_name=>'CLASSIC_TREE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\822C\6A39\72C0\7D50\69CB')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285582733973873655)
,p_name=>'CLEAN_UP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664\9801\9762')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285120167577873316)
,p_name=>'CLEAR_COMMAND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664\547D\4EE4')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285592680810873662)
,p_name=>'CLOSED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8655\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285640261843873696)
,p_name=>'CLOSED_LAST_7_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB 7 \5929\7684\5DF2\8655\7406\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405942561873524)
,p_name=>'CLOSE_WINDOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589\8996\7A97')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524496085874336)
,p_name=>'CODE_EDITOR.CLOSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526185049874337)
,p_name=>'CODE_EDITOR.FIND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0B\627E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524358520874336)
,p_name=>'CODE_EDITOR.FIND_INPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0B\627E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526050174874337)
,p_name=>'CODE_EDITOR.FIND_NEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0B\627E\4E0B\4E00\500B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525961542874337)
,p_name=>'CODE_EDITOR.FIND_PREV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0B\627E\4E0A\4E00\500B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525778213874337)
,p_name=>'CODE_EDITOR.HINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\52D5\5B8C\6210')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525037677874336)
,p_name=>'CODE_EDITOR.INDENT_SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E2E\6392\5927\5C0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525221844874337)
,p_name=>'CODE_EDITOR.INDENT_WITH_TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Tab \5B57\5143\63D2\5165\7A7A\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524600932874336)
,p_name=>'CODE_EDITOR.MATCH_CASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5927\5C0F\5BEB\9808\76F8\7B26')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524508604874336)
,p_name=>'CODE_EDITOR.MATCH_RE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B63\898F\8868\793A\5F0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286529552912874340)
,p_name=>'CODE_EDITOR.QUERY_BUILDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\8A62\7522\751F\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526298479874337)
,p_name=>'CODE_EDITOR.REDO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\505A')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525880873874337)
,p_name=>'CODE_EDITOR.REPLACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\4EE3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524110857874336)
,p_name=>'CODE_EDITOR.REPLACE_ALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\53D6\4EE3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524201625874336)
,p_name=>'CODE_EDITOR.REPLACE_INPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\4EE3')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526589444874338)
,p_name=>'CODE_EDITOR.REPLACE_SKIP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7565\904E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525503356874337)
,p_name=>'CODE_EDITOR.SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\503C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524885762874336)
,p_name=>'CODE_EDITOR.SHORTCUT_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>'%0 - %1'
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525380686874337)
,p_name=>'CODE_EDITOR.SHOW_LINE_NUMBERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\884C\865F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524738097874336)
,p_name=>'CODE_EDITOR.SHOW_RULER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\5C3A\898F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525104711874336)
,p_name=>'CODE_EDITOR.TAB_SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Tab \5B57\5143\5927\5C0F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286524911607874336)
,p_name=>'CODE_EDITOR.THEMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526327302874337)
,p_name=>'CODE_EDITOR.UNDO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9084\539F')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525460123874337)
,p_name=>'CODE_EDITOR.USE_PLAIN_TEXT_EDITOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\7D14\6587\5B57\7DE8\8F2F\5668')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286525673688874337)
,p_name=>'CODE_EDITOR.VALIDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9A57\8B49')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286526459023874337)
,p_name=>'CODE_EDITOR.VALIDATION_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9A57\8B49\6210\529F')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285522884098873610)
,p_name=>'COLLAPSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF ')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285133431975873325)
,p_name=>'COLOR_PALETTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8272\5F69\9078\76E4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285359238826873491)
,p_name=>'COLOR_PALETTE_ANALOGIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\985E\6BD4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285358813710873490)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\88DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285359461189873491)
,p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\88DC\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285359381471873491)
,p_name=>'COLOR_PALETTE_MONOTONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\55AE\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285358919584873490)
,p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\5272\4E92\88DC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285359108015873490)
,p_name=>'COLOR_PALETTE_TETRADE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DB\5206\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285359060359873490)
,p_name=>'COLOR_PALETTE_TRIADE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E09\5206\6CD5')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979747191873930)
,p_name=>'COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286415824885874255)
,p_name=>'COLUMN_DISPLAY_NAME_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\540D\7A31: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515191066873604)
,p_name=>'COLUMN_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\540D\7A31')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285720823684873753)
,p_name=>'COM.ORACLE.APEX.ACL_ALL_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709\5DF2\8A8D\8B49\7684\4F7F\7528\8005\90FD\53EF\4EE5\5B58\53D6\6B64\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285720990595873753)
,p_name=>'COM.ORACLE.APEX.ACL_ONLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EA\6709\61C9\7528\7A0B\5F0F\5B58\53D6\63A7\5236\6E05\55AE\4E2D\5B9A\7FA9\7684\4F7F\7528\8005\53EF\4EE5\5B58\53D6\6B64\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285721082024873753)
,p_name=>'COM.ORACLE.APEX.ACL_SETTING_VALUE_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\9810\671F\7684\5B58\53D6\63A7\5236\8A2D\5B9A\503C: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285126813823873320)
,p_name=>'COMING_SOON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8FD1\671F\63A8\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515627216873604)
,p_name=>'COMMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A3B\89E3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285653113740873705)
,p_name=>'COMMENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A3B\89E3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285407110996873525)
,p_name=>'COMPILE_FAILURE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8B6F\5931\6557, \884C <a href="javascript:goToLine(''%0'')">%0</a> (%2)<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285737108168873764)
,p_name=>'COMPILE_FAILURE_TRIGGER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8B6F\5931\6557, \884C %0 (%2). \767C\751F\7DE8\8B6F\932F\8AA4\7684\884C\865F\8207\7B2C\4E00\500B BEGIN \6558\8FF0\53E5\6709\95DC. \9019\53EA\6703\5F71\97FF\8CC7\6599\5EAB\89F8\767C\7A0B\5F0F\7684\7DE8\8B6F.<br />%1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285407037067873525)
,p_name=>'COMPILE_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\7DE8\8B6F PL/SQL \7A0B\5F0F\78BC (%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285589946658873660)
,p_name=>'COMPLETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285597394793873665)
,p_name=>'COMPLETED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5B8C\6210')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285604373263873670)
,p_name=>'COMPLETE_NO_ISSUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6210 / \6C92\6709\554F\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285640884988873697)
,p_name=>'COMPONENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5143\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285797631082873805)
,p_name=>'COMPONENT_NAME_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5143\4EF6\540D\7A31: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286068961918873994)
,p_name=>'COMPONENT_NOT_ENABLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\555F\7528\5143\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285245434826873408)
,p_name=>'COMPONENT_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5EFA\7ACB\5143\4EF6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411127562874252)
,p_name=>'COMPONENT_SUMMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5143\4EF6\6458\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285188676577873366)
,p_name=>'COMPUTATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285664305035873714)
,p_name=>'COMP_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5B89\88DD\61C9\7528\7A0B\5F0F\5143\4EF6.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285407706215873526)
,p_name=>'CONDITIONAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\689D\4EF6\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285497687677873591)
,p_name=>'CONDITIONS_POPUP_LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5373\73FE\5F0F\503C\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285581495243873654)
,p_name=>'CONDITIONS_SHORTCUT_ALWAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\5F8B\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317427081873460)
,p_name=>'CONDITIONS_SHORTCUT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316968154873460)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE / \8CC7\6599\6B04=\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317010672873460)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE / \8CC7\6599\6B04\4E0D\662F\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286283052931874153)
,p_name=>'CONDITIONS_SHORTCUT_ITEM_NULL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE/\8CC7\6599\6B04\662F\7A7A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317538522873460)
,p_name=>'CONDITIONS_SHORTCUT_NEVER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\5F8B\4E0D\6210\7ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317630526873460)
,p_name=>'CONDITIONS_SHORTCUT_NONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317274989873460)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\542B\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317337628873460)
,p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5305\542B\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285316813706873460)
,p_name=>'CONDITIONS_SHORTCUT_PLSQL'
,p_message_language=>'zh-tw'
,p_message_text=>'PL/SQL'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317193799873460)
,p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\6C42=e1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285328781597873468)
,p_name=>'CONDITION_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\689D\4EF6\985E\578B')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285542819098873624)
,p_name=>'CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093149228873296)
,p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2 \9801\4E3B\8981\660E\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093024944873296)
,p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('3 \9801\4E3B\8981\660E\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303441793873450)
,p_name=>'CONFIRM.ACTUAL_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BE6\969B\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285589138586873659)
,p_name=>'CONFIRM.AGG_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\8CC7\6599\6B04\805A\7E3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285589226028873659)
,p_name=>'CONFIRM.AGG_FUNCTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\4F7F\7528\7684\805A\7E3D\51FD\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285300832866873448)
,p_name=>'CONFIRM.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314218707873458)
,p_name=>'CONFIRM.APPLICATION_ALIAS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314363461873458)
,p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\8A9E\8A00')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314120510873458)
,p_name=>'CONFIRM.APPLICATION_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285195313504873371)
,p_name=>'CONFIRM.ARRAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\544A\7D50\679C\6A39\72C0\7D50\69CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285195493454873371)
,p_name=>'CONFIRM.ARRAY_PARMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\544A\7D50\679C\53C3\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314483876873458)
,p_name=>'CONFIRM.AUTHENTICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780847737873793)
,p_name=>'CONFIRM.BRANCH_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50\5230\5206\652F\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505061044873597)
,p_name=>'CONFIRM.BREAK_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\6BB5\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303260054873450)
,p_name=>'CONFIRM.BUTTON_BRANCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \6309\9215\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303146362873450)
,p_name=>'CONFIRM.BUTTON_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \6309\9215\986F\793A\6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106862429873306)
,p_name=>'CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528\65B0\589E\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285106745151873306)
,p_name=>'CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528\62D6\653E\529F\80FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723273461873755)
,p_name=>'CONFIRM.CANCEL_BRANCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780667104873793)
,p_name=>'CONFIRM.CANCEL_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88\6309\9215\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771178997873787)
,p_name=>'CONFIRM.CASE_SENSITIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6709\5927\5C0F\5BEB\4E4B\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405481274873524)
,p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\8B8A\66F4\300C\4E92\52D5\5F0F\5831\8868\300D\67E5\8A62.  \5982\679C\60A8\79FB\9664\67E5\8A62\4E2D\7684\8CC7\6599\6B04, \5C07\6703\4E00\4F75\505C\7528\53C3\7167\9019\4E9B\8CC7\6599\6B04\7684\73FE\6709\7BE9\9078\3001\6A19\793A\898F\5247\4EE5\53CA\5176\4ED6\5831\8868\8A2D\5B9A\503C. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304392393873451)
,p_name=>'CONFIRM.CHART_AXIS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\5EA7\6A19\8EF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285653465815873706)
,p_name=>'CONFIRM.CHART_DIAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\91CF\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285653564991873706)
,p_name=>'CONFIRM.CHART_DIALSWEEP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\91CF\5716 (\6307\793A)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305097810873451)
,p_name=>'CONFIRM.CHART_HORIZONTAL_BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C34\5E73\9577\689D\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305260368873451)
,p_name=>'CONFIRM.CHART_LINE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6298\7DDA\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304547508873451)
,p_name=>'CONFIRM.CHART_NUMBER_MASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\5B57\906E\7F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305157068873451)
,p_name=>'CONFIRM.CHART_PIE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5713\9905\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304232046873451)
,p_name=>'CONFIRM.CHART_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304425910873451)
,p_name=>'CONFIRM.CHART_SCALE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\6578\4F4D\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305318337873451)
,p_name=>'CONFIRM.CHART_SCATTER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6563\5E03\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304899216873451)
,p_name=>'CONFIRM.CHART_SIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\5927\5C0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304756858873451)
,p_name=>'CONFIRM.CHART_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304622139873451)
,p_name=>'CONFIRM.CHART_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304904294873451)
,p_name=>'CONFIRM.CHART_VERTICAL_BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5782\76F4\9577\689D\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285195526656873371)
,p_name=>'CONFIRM.COLLECTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66AB\6642\7D50\679C\96C6\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301647474873449)
,p_name=>'CONFIRM.COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285504806226873597)
,p_name=>'CONFIRM.COLUMN_HEADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285680781929873725)
,p_name=>'CONFIRM.COLUMN_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723466058873755)
,p_name=>'CONFIRM.COLUMN_NAMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313908365873458)
,p_name=>'CONFIRM.COL_HEAD_SORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\8CC7\6599\6B04\6A19\984C\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285420639199873535)
,p_name=>'CONFIRM.COPY_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\8907\88FD\61C9\7528\7A0B\5F0F.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312585039873457)
,p_name=>'CONFIRM.COPY_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\8907\88FD\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302109038873449)
,p_name=>'CONFIRM.CREATE.NEW.TABSET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\6703\5EFA\7ACB "%0" \6B64\65B0\9801\7C64\96C6, \4E26\7531\6B64\9801\9762\4F7F\7528.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314031499873458)
,p_name=>'CONFIRM.CREATE_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\61C9\7528\7A0B\5F0F.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306602199873452)
,p_name=>'CONFIRM.CREATE_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\884C\4E8B\66C6\9801\9762.   \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309849077873455)
,p_name=>'CONFIRM.CREATE_DRILL_DOWN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\5411\4E0B\5C55\958B\5831\8868\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285369547843873498)
,p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\300C\4E92\52D5\5F0F\5831\8868\300D\9801\9762. \8ACB\78BA\8A8D\60A8\6240\9078\64C7\7684\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312875933873457)
,p_name=>'CONFIRM.CREATE_EASY_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\5831\8868\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285100411566873301)
,p_name=>'CONFIRM.CREATE_FLASH_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB Flash \5716\8868\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286386753896874234)
,p_name=>'CONFIRM.CREATE_FLOW_APP_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\8207\76EE\524D\5DE5\4F5C\5340\4E2D\73FE\6709\300C\8CC7\6599\5EAB\300D\61C9\7528\7A0B\5F0F\76F8\540C\7684 ID \4F86\5EFA\7ACB\300C\8CC7\6599\5EAB\300D\61C9\7528\7A0B\5F0F. \5C07\6703\522A\9664\73FE\6709\7684\300C\8CC7\6599\5EAB\300D\61C9\7528\7A0B\5F0F, \4E26\4EE5\65B0\7684\300C\8CC7\6599\5EAB\300D\61C9\7528\7A0B\5F0F\53D6\4EE3. \8ACB\78BA\8A8D\60A8\7684\9078\64C7. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285677503674873723)
,p_name=>'CONFIRM.CREATE_FORM_AND_LIST_VIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\8868\55AE\548C\6E05\55AE\6AA2\8996\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285588895032873659)
,p_name=>'CONFIRM.CREATE_FORM_AND_REPORT_WITH_ANALYSIS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5EFA\7ACB\8868\55AE\548C\5177\6709\5206\6790\9801\9762\7684\5831\8868\9801\9762. \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306200703873452)
,p_name=>'CONFIRM.CREATE_FORM_ON_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5728 SQL \67E5\8A62\5EFA\7ACB\8868\55AE.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306122213873452)
,p_name=>'CONFIRM.CREATE_FORM_ON_SP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5728\9810\5B58\7A0B\5E8F\5EFA\7ACB\8868\55AE.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306094571873452)
,p_name=>'CONFIRM.CREATE_FORM_ON_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5728\8868\683C\9801\9762\5EFA\7ACB\8868\55AE.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285151535760873338)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5728 Web \670D\52D9\53C3\7167\9801\9762\5EFA\7ACB\8868\55AE.   \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285208396552873380)
,p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5728 Web \670D\52D9\53C3\7167\9801\9762\5EFA\7ACB\8868\55AE\548C\5831\8868.   \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285618120685873680)
,p_name=>'CONFIRM.CREATE_MAP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\4F86\5EFA\7ACB\300C\5730\5716\300D\9801\9762. \8ACB\78BA\8A8D\60A8\9078\64C7\7684\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285090543374873294)
,p_name=>'CONFIRM.CREATE_MASTER_DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\4E3B\8981\660E\7D30\9801\9762. \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307825219873453)
,p_name=>'CONFIRM.CREATE_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\5C0E\89BD\8DEF\5F91\5340\57DF\548C\5C0E\89BD\8DEF\5F91\9078\9805.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285596118145873664)
,p_name=>'CONFIRM.CREATE_MODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6A21\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305820960873452)
,p_name=>'CONFIRM.CREATE_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286462210753874289)
,p_name=>'CONFIRM.CREATE_PAGE_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286462309556874289)
,p_name=>'CONFIRM.CREATE_PAGE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308624957873454)
,p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\8868\55AE\548C\5831\8868\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286382609099874231)
,p_name=>'CONFIRM.CREATE_REGION_PLUGIN_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312622583873457)
,p_name=>'CONFIRM.CREATE_REPORT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\5831\8868\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306399547873452)
,p_name=>'CONFIRM.CREATE_SIMPLE_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\300CHTML \9577\689D\5716\9801\9762\300D.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312238300873456)
,p_name=>'CONFIRM.CREATE_SUMMARY_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\6458\8981\9801\9762. \6309\300C\65B0\589E\5176\4ED6\9805\76EE\300D\6309\9215\53EF\65B0\589E\5176\4ED6\9801\9762\548C (\6216) \5340\57DF\7684\9805\76EE. \6309\300C\5B8C\6210\300D\53EF\5EFA\7ACB\6458\8981\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306438598873452)
,p_name=>'CONFIRM.CREATE_SVG_CHART'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB SVG \5716\8868\9801\9762.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305792394873452)
,p_name=>'CONFIRM.CREATE_TABULAR_FORM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\5217\8868\5316\8868\55AE.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306990297873453)
,p_name=>'CONFIRM.CREATE_TREE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\4F86\5EFA\7ACB\6A39\72C0\7D50\69CB\9801\9762. \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305973082873452)
,p_name=>'CONFIRM.CREATE_WIZARD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\7CBE\9748.  \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286386384651874234)
,p_name=>'CONFIRM.CREATE_WS_APP_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\4F7F\7528\8207\76EE\524D\5DE5\4F5C\5340\4E2D\73FE\6709\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F\76F8\540C\7684 ID \4F86\5EFA\7ACB\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F. \5C07\6703\522A\9664\73FE\6709\7684\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F, \4E26\4EE5\65B0\7684\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F\53D6\4EE3. \8ACB\78BA\8A8D\60A8\7684\9078\64C7. ')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500671361873593)
,p_name=>'CONFIRM.CSV_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9023\7D50\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286319319723874180)
,p_name=>'CONFIRM.DATA_LOAD_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\5B9A\7FA9\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286393956361874239)
,p_name=>'CONFIRM.DATA_LOAD_NAME_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\4F7F\7528\73FE\6709\7684\8868\683C\67E5\5C0B\548C\8F49\63DB\898F\5247\91CD\65B0\5EFA\7ACB\6B64\300C\8CC7\6599\8F09\5165\5B9A\7FA9\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285771241703873787)
,p_name=>'CONFIRM.DATA_LOAD_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306720350873452)
,p_name=>'CONFIRM.DATE_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285596211885873664)
,p_name=>'CONFIRM.DEFAULT_AUTH_SCHEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\8A8D\8B49\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305655895873452)
,p_name=>'CONFIRM.DELETE_PROCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285310507527873455)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30 %0 \986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093516158873296)
,p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30\986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312176453873456)
,p_name=>'CONFIRM.DETAIL_MENU_COL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30\5C0E\89BD\8DEF\5F91\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285311362049873456)
,p_name=>'CONFIRM.DETAIL_ORDER_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30\8868\683C %0 \9806\5E8F\4F9D\64DA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285310007000873455)
,p_name=>'CONFIRM.DETAIL_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30\9801\9762 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093409651873296)
,p_name=>'CONFIRM.DETAIL_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285310395487873455)
,p_name=>'CONFIRM.DETAIL_TABLE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30\8868\683C\540D\7A31 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285310124150873455)
,p_name=>'CONFIRM.DETAIL_TAB_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30\9801\7C64\6A19\7C64 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723700024873755)
,p_name=>'CONFIRM.DISPLAY_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\50B3\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303736012873450)
,p_name=>'CONFIRM.DISPLAY_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285680469486873725)
,p_name=>'CONFIRM.DISPLAY_COLUMN_2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\50B3\8CC7\6599\6B04 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285680519718873725)
,p_name=>'CONFIRM.DISPLAY_COLUMN_3'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\50B3\8CC7\6599\6B04 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308078234873453)
,p_name=>'CONFIRM.DISPLAY_POINT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\4F4D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286471120292874296)
,p_name=>'CONFIRM.EDIT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286471220824874296)
,p_name=>'CONFIRM.EDIT_PAGE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285493576233873588)
,p_name=>'CONFIRM.ENABLE_CSV_OUTPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('CSV \8F38\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285494208337873589)
,p_name=>'CONFIRM.ENABLE_PRINT_OUTPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5217\5370\8F38\51FA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285494875603873589)
,p_name=>'CONFIRM.ENABLE_SORTING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528\8CC7\6599\6B04\6A19\984C\6392\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285544778993873625)
,p_name=>'CONFIRM.EXISTING_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\6703\5728\73FE\6709\7BA1\7406\9801\9762\65B0\589E\4E00\500B\5340\57DF:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723384886873755)
,p_name=>'CONFIRM.FINISH_BRANCH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6210\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309144324873454)
,p_name=>'CONFIRM.FORM_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309206998873454)
,p_name=>'CONFIRM.FORM_PAGE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309469744873454)
,p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\9801\9762\9801\7C64\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309377973873454)
,p_name=>'CONFIRM.FORM_PAGE_TAB_SET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\9801\9762\9801\7C64\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285596341173873665)
,p_name=>'CONFIRM.IMPORT_SHARED_COMPONENTS_FROM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\532F\5165\5171\7528\5143\4EF6\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286053861398873983)
,p_name=>'CONFIRM.INCLUDE_CUSTOM_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\62EC\81EA\8A02\884C\4E8B\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093759234873296)
,p_name=>'CONFIRM.INCLUDE_MASTER_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\5305\62EC\4E3B\8981\5831\8868?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285311890724873456)
,p_name=>'CONFIRM.INC_BREAD_CRUMB'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5305\62EC\5C0E\89BD\8DEF\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302943336873450)
,p_name=>'CONFIRM.INFORMATION_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\8A0A\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303070381873450)
,p_name=>'CONFIRM.INFORMATION_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\8A0A\9810\8A2D\6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285151796682873339)
,p_name=>'CONFIRM.INPUT_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285195732722873371)
,p_name=>'CONFIRM.INPUT_REGION_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\5340\57DF\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285195605175873371)
,p_name=>'CONFIRM.INPUT_REGION_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\55AE\5340\57DF\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305493046873452)
,p_name=>'CONFIRM.INSERT_PROCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D2\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302717269873450)
,p_name=>'CONFIRM.ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723671653873755)
,p_name=>'CONFIRM.KEY_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50B3\56DE\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285722586622873754)
,p_name=>'CONFIRM.KEY_COLUMN_1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\5C0B\7D22\5F15\9375\8CC7\6599\6B04 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285722657475873754)
,p_name=>'CONFIRM.KEY_COLUMN_2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D22\5F15\9375\8CC7\6599\6B04 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285722725536873754)
,p_name=>'CONFIRM.KEY_COLUMN_3'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D22\5F15\9375\8CC7\6599\6B04 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285306864425873453)
,p_name=>'CONFIRM.LABEL_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285680602762873725)
,p_name=>'CONFIRM.LOOKUP_OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\5C0B\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723513910873755)
,p_name=>'CONFIRM.LOOKUP_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\5C0B\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093895375873296)
,p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\660E\7D30\7248\9762\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093324916873296)
,p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093678764873296)
,p_name=>'CONFIRM.MASTER_SORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\4E3B\8981\8A18\9304\65B9\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285093277966873296)
,p_name=>'CONFIRM.MASTER_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\8981\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285504968139873597)
,p_name=>'CONFIRM.MAXIMUM_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\6578\76EE\4E0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500455706873593)
,p_name=>'CONFIRM.MAX_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6BCF\9801\8CC7\6599\5217\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285378298057873504)
,p_name=>'CONFIRM.MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308396337873454)
,p_name=>'CONFIRM.MENU_LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\9023\7D50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285311946997873456)
,p_name=>'CONFIRM.MENU_ROOT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\6839\76EE\9304')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308139370873453)
,p_name=>'CONFIRM.MENU_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308440605873454)
,p_name=>'CONFIRM.MENU_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285226072029873393)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5C07\6B64 Flash \5716\8868\5347\7D1A\70BA\65B0\7684 Flash 6 \5716\8868. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285590032941873660)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_FLASH6_XML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5C07\6839\64DA\81EA\8A02 XML \7684 Flash \5716\8868\5347\7D1A\70BA\65B0\7684 Flash 6 \5716\8868.  \56E0\70BA\76EE\524D\548C Flash 6 \5716\8868\4E4B\9593 XML \7D50\69CB\7684\5DEE\7570, \5C07\4E0D\6703\986F\793A\5347\7D1A\7684\5716\8868. \60A8\5FC5\9808\4FEE\6539\5347\7D1A\4E4B\5716\8868\7684\81EA\8A02 XML, \624D\80FD\5920\4F7F\7528\65B0\7684 XML \7D50\69CB. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285164346240873348)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5C07\6B64 Flash \5716\8868\5347\7D1A\70BA\65B0\7684 HTML5 \5716\8868. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285164420372873348)
,p_name=>'CONFIRM.MIGRATE_FLASH_TO_HTML5_XML'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5C07\6839\64DA\81EA\8A02 XML \7684 Flash \5716\8868\5347\7D1A\70BA\65B0\7684 HTML5 \5716\8868.  \56E0\70BA\76EE\524D\548C HTML5 \5716\8868\4E4B\9593 XML \7D50\69CB\7684\5DEE\7570, \5C07\4E0D\6703\986F\793A\5347\7D1A\7684\5716\8868. \60A8\5FC5\9808\4FEE\6539\5347\7D1A\4E4B\5716\8868\7684\81EA\8A02 XML, \624D\80FD\5920\4F7F\7528\65B0\7684 XML \7D50\69CB. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285164285391873348)
,p_name=>'CONFIRM.MIGRATE_HTML_TO_HTML5'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5C07\6B64 HTML \5716\8868\5347\7D1A\70BA\65B0\7684 HTML5 \5716\8868. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286407108551874249)
,p_name=>'CONFIRM.MIGRATE_JSTREE_TO_APEXTREE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5C07 jsTree \5347\7D1A\70BA\65B0\7684\300C\6A39\72C0\7D50\69CB\300D. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285292195297873442)
,p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\5347\7D1A SVG \5716\8868\7684\9650\5236\5982\4E0B:  '),
'<ul>',
'<li>',
unistr('\53EA\6703\79FB\8F49\5EA7\6A19\8EF8\683C\5F0F\5B57\4E32\4E2D\5B9A\7FA9\7684\6578\5B57\683C\5F0F.  \5C07\5FFD\7565\65E5\671F\548C\6642\9593\683C\5F0F.'),
'</li>',
'<li>',
unistr('\5C07\79FB\8F49\542B\6709\4E0B\5217\9805\76EE\7684\6578\5B57\683C\5F0F\5143\7D20:'),
'<br />',
unistr('0,9,D,G,, (\9017\865F),. (\53E5\865F),$,C,L,FM'),
'</li>',
'<li>',
unistr('Flash \5716\8868\4E2D\6BCF\500B\6578\5217\7684\6A19\7C64\5C07\81EA\6BCF\500B\6578\5217\7684\8CC7\6599\6B04\5225\540D\884D\751F.  '),
unistr('SVG \5716\8868\4E2D\6BCF\500B\6578\5217\7684\6A19\7C64\5247\662F\81EA\300C\6578\5217\540D\7A31\300D\5C6C\6027\884D\751F.'),
'</li>',
'<li>',
unistr('\300CFlash \8A08\91CF\300D\5716\8868\6703\986F\793A\5BE6\969B\7684\503C\800C\975E\767E\5206\6BD4.'),
'</li>',
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285247259605873409)
,p_name=>'CONFIRM.MIGRATE_SVG_TO_HTML5'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\5C07 SVG \5716\8868\5347\7D1A\70BA HTML5 \5716\8868.  \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286382448618874231)
,p_name=>'CONFIRM.NAVIGATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314781292873458)
,p_name=>'CONFIRM.NAV_BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286032693843873968)
,p_name=>'CONFIRM.NAV_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\529F\80FD\8868\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285607920340873673)
,p_name=>'CONFIRM.NEW_ADMIN_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0B\5217\9801\9762\5C07\6703\65B0\589E\70BA\65B0\7684\7BA1\7406\9801\9762:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405634189873524)
,p_name=>'CONFIRM.NEW_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303596975873450)
,p_name=>'CONFIRM.NEW_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780438833873793)
,p_name=>'CONFIRM.NEXT_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\4E0B\4E00\6B65\6309\9215\300D\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302003477873449)
,p_name=>'CONFIRM.NO.TABSET.SELECTED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\9078\53D6\6B64\9801\9762\7684\9801\7C64\96C6.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302616532873449)
,p_name=>'CONFIRM.NO_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285151836759873339)
,p_name=>'CONFIRM.OUTPUT_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\51FA\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303911239873450)
,p_name=>'CONFIRM.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285300980827873448)
,p_name=>'CONFIRM.PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314538274873458)
,p_name=>'CONFIRM.PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301015707873448)
,p_name=>'CONFIRM.PAGE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301997189873449)
,p_name=>'CONFIRM.PAGE_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285310420478873455)
,p_name=>'CONFIRM.PARENT_DISPLAY_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\986F\793A\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308551431873454)
,p_name=>'CONFIRM.PARENT_MENU'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\5C0E\89BD\8DEF\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312099585873456)
,p_name=>'CONFIRM.PARENT_MENU_COL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\5C0E\89BD\8DEF\5F91\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285310691922873455)
,p_name=>'CONFIRM.PARENT_ORDER_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\8868\683C\6392\5217\9806\5E8F\4F9D\64DA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309982380873455)
,p_name=>'CONFIRM.PARENT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285310232297873455)
,p_name=>'CONFIRM.PARENT_TABLE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\8868\683C\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302553290873449)
,p_name=>'CONFIRM.PARENT_TAB_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\9801\7C64\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302441063873449)
,p_name=>'CONFIRM.PARENT_TAB_SET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\9801\7C64\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405341850873524)
,p_name=>'CONFIRM.PARSING_SCHEMA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5256\6790\7DB1\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414398213873531)
,p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406\90E8\5206\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780580821873793)
,p_name=>'CONFIRM.PREVIOUS_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\4E0A\4E00\6B65\6309\9215\300D\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301860513873449)
,p_name=>'CONFIRM.PRIMARY_KEY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\7D22\5F15\9375\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309544515873455)
,p_name=>'CONFIRM.PRIMARY_KEY_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\7D22\5F15\9375\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500730003873594)
,p_name=>'CONFIRM.PRINT_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\51FA\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285505193248873597)
,p_name=>'CONFIRM.PRINT_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5217\5370\9023\7D50\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500864837873594)
,p_name=>'CONFIRM.PRINT_OUTPUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\5217\5370')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303843326873450)
,p_name=>'CONFIRM.PROCESS_OPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\4F5C\696D\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500567587873593)
,p_name=>'CONFIRM.REGION_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302834428873450)
,p_name=>'CONFIRM.REGION_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301174600873448)
,p_name=>'CONFIRM.REGION_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307927531873453)
,p_name=>'CONFIRM.REGION_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405528842873524)
,p_name=>'CONFIRM.REMOVED_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\7684\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309653838873455)
,p_name=>'CONFIRM.REPORT_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285522953190873610)
,p_name=>'CONFIRM.REPORT_IMPLEMENTATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\5BE6\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308714760873454)
,p_name=>'CONFIRM.REPORT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308882531873454)
,p_name=>'CONFIRM.REPORT_PAGE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309021298873454)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\9801\9762\9801\7C64\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308957728873454)
,p_name=>'CONFIRM.REPORT_PAGE_TAB_SET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\9801\9762\9801\7C64\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285195939412873371)
,p_name=>'CONFIRM.REPORT_REGION_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\5340\57DF\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285195823023873371)
,p_name=>'CONFIRM.REPORT_REGION_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\5340\57DF\6A19\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312957484873457)
,p_name=>'CONFIRM.REPORT_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285198405166873373)
,p_name=>'CONFIRM.ROW_VERSION_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217\7248\672C\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313101755873457)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: HTML (\6A19\6E96)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313498301873457)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME11'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5916\89C0 1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313589757873457)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME12'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5916\89C0 2')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405131660873524)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME13'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5916\89C0 3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405295093873524)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME14'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5916\89C0 4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285196409474873371)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME15'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5916\89C0 5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313200930873457)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5782\76F4\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313667959873457)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME21'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\532F\51FA: CSV')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313764447873458)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME22'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\532F\51FA: XML')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313329609873457)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME3'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5782\76F4\5831\8868, \5916\89C0 1 (\5305\62EC\7A7A\503C\8CC7\6599\6B04)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285404924856873524)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME4'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \5782\76F4\5831\8868, \5916\89C0 2 (\6392\9664\7A7A\503C\8CC7\6599\6B04)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405086731873524)
,p_name=>'CONFIRM.RPT_TEMPLATE_NAME5'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D: \91CD\76F4\5831\8868, \5916\89C0 2 (\5305\62EC\7A7A\503C\8CC7\6599\6B04)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723840941873755)
,p_name=>'CONFIRM.RULE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\898F\5247\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285724067737873755)
,p_name=>'CONFIRM.RULE_SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285724192475873755)
,p_name=>'CONFIRM.RULE_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\898F\5247\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285125656546873319)
,p_name=>'CONFIRM.RUN_SCRIPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\8981\6C42\57F7\884C\4E0B\5217\547D\4EE4\6A94.  \8ACB\78BA\8A8D\60A8\7684\8981\6C42.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285308274021873454)
,p_name=>'CONFIRM.SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313017672873457)
,p_name=>'CONFIRM.SORT_OPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6392\5E8F\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304184450873451)
,p_name=>'CONFIRM.SQL_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285414250556873531)
,p_name=>'CONFIRM.STANDARD_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\6E96')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285542427546873624)
,p_name=>'CONFIRM.STARTING_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\6703\5F9E\4EE5\4E0B\9801\9762\958B\59CB\5EFA\7ACB\591A\500B\9801\9762:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285304094796873451)
,p_name=>'CONFIRM.STORED_PROCEDURE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\5B58\7A0B\5E8F\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285406908492873525)
,p_name=>'CONFIRM.STORED_PROCEDURE_OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\5B58\7A0B\5E8F\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285780775744873793)
,p_name=>'CONFIRM.SUBMIT_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6210\6309\9215\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286397924437874242)
,p_name=>'CONFIRM.SUBSCRIBE_THEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A02\95B1\4E3B\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285303327677873450)
,p_name=>'CONFIRM.SUGGESTED_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\8B70\7684\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285588962743873659)
,p_name=>'CONFIRM.TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C/\8996\89C0\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285589043480873659)
,p_name=>'CONFIRM.TABLE_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\8CC7\6599\6B04\5F59\7E3D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285807927003873812)
,p_name=>'CONFIRM.TABLE_LOOKUPS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C\67E5\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301500985873449)
,p_name=>'CONFIRM.TABLE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301469724873449)
,p_name=>'CONFIRM.TABLE_OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285980036308873930)
,p_name=>'CONFIRM.TABLE_RULE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F49\63DB\898F\5247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285724223998873755)
,p_name=>'CONFIRM.TABLE_RULES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F49\63DB\898F\5247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405802598873524)
,p_name=>'CONFIRM.TABLE_VIEW_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C/\8996\89C0\8868\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285405710196873524)
,p_name=>'CONFIRM.TABLE_VIEW_OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C/\8996\89C0\8868\64C1\6709\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314621795873458)
,p_name=>'CONFIRM.TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302358552873449)
,p_name=>'CONFIRM.TABSET.INCOMPLETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B66\544A, \9801\7C64\96C6\8CC7\8A0A\4E0D\5B8C\6574.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301317038873448)
,p_name=>'CONFIRM.TAB_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\7C64\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285312716132873457)
,p_name=>'CONFIRM.TAB_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\7C64\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301229244873448)
,p_name=>'CONFIRM.TAB_SET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\7C64\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285313891870873458)
,p_name=>'CONFIRM.TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A23\677F:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307551489873453)
,p_name=>'CONFIRM.TREE_LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6839\64DA\5177\6709\5373\73FE\5F0F\503C\6E05\55AE\7684\65B0\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307257129873453)
,p_name=>'CONFIRM.TREE_MAX_LEVEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C64\6B21\4E0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307011228873453)
,p_name=>'CONFIRM.TREE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A39\72C0\7D50\69CB\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307408858873453)
,p_name=>'CONFIRM.TREE_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A39\72C0\7D50\69CB\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307608663873453)
,p_name=>'CONFIRM.TREE_SQL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4EE5\300CSQL \67E5\8A62\300D\70BA\57FA\790E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307323258873453)
,p_name=>'CONFIRM.TREE_START'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\59CB\6A39\72C0\7D50\69CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307742042873453)
,p_name=>'CONFIRM.TREE_STATIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\975C\614B\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285307105539873453)
,p_name=>'CONFIRM.TREE_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A39\72C0\7D50\69CB\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314849566873458)
,p_name=>'CONFIRM.UI_THEME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285314930706873458)
,p_name=>'CONFIRM.UI_THEME1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\85CD\8272\548C\9EC3\8910\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285315053757873458)
,p_name=>'CONFIRM.UI_THEME2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D05\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285315133590873459)
,p_name=>'CONFIRM.UI_THEME4'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6D77\85CD\548C\7070\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285315271379873459)
,p_name=>'CONFIRM.UI_THEME5'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A44\6B16\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285315332343873459)
,p_name=>'CONFIRM.UI_THEME6'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6697\7D05\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285315472382873459)
,p_name=>'CONFIRM.UI_THEME7'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7C21\55AE\85CD\8272\548C\9EC3\8910\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285315590300873459)
,p_name=>'CONFIRM.UI_THEME8'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\85CD\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285315698940873459)
,p_name=>'CONFIRM.UI_THEME_NONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285301700781873449)
,p_name=>'CONFIRM.UPDATEABLE_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\66F4\65B0\7684\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285305552112873452)
,p_name=>'CONFIRM.UPDATE_PROCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285302266685873449)
,p_name=>'CONFIRM.USE.EXISTING.TABSET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\9801\9762\5C07\6703\4F7F\7528\73FE\6709\7684\9801\7C64\96C6 "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285151677181873339)
,p_name=>'CONFIRM.WEB_SERVICE_REF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \670D\52D9\53C3\7167, \4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285309782521873455)
,p_name=>'CONFIRM.WHERE_CLAUSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Where \5B50\53E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285578358291873652)
,p_name=>'CONFIRMATION_ICON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\8A8D\5716\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285590446754873660)
,p_name=>'CONFIRMED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285590704732873661)
,p_name=>'CONFIRMED_BY_QA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\7531 QA \78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285501020802873594)
,p_name=>'CONFIRM_BREAK_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\6BB5\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285500902831873594)
,p_name=>'CONFIRM_PRINT_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5217\5370\683C\5F0F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285619217306873681)
,p_name=>'CONTENT_DISPOSITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5167\5BB9\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285654460827873706)
,p_name=>'CONTENT_SERVED_IN_KBYTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\7684\5167\5BB9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285491929771873587)
,p_name=>'CONTINUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E7C\7E8C')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286531501748874341)
,p_name=>'CONTRIBUTORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\8005')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286424114888874261)
,p_name=>'COPY.PAGE.NEW_STATIC_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\975C\614B ID')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285188374146873365)
,p_name=>'COPYRIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8457\4F5C\6B0A\6240\6709 &copy; %0, \4FDD\7559\4E00\5207\6B0A\5229.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246787223873409)
,p_name=>'COPY_APP_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\7D93\8907\88FD\60A8\7684\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285382335763873507)
,p_name=>'COPY_BUTTON.EXECUTION_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C copy_button \6642\767C\751F\932F\8AA4: %0 >> %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285421263222873536)
,p_name=>'COPY_DEPLOYMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\7269\4EF6\5B9A\7FA9\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285220065675873389)
,p_name=>'COPY_EXISTING_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285678370716873724)
,p_name=>'COPY_FEATURE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\529F\80FD: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285420810891873535)
,p_name=>'COPY_FROM_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\4F86\6E90\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285855033559873843)
,p_name=>'COPY_FROM_APP_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6839\64DA\6A23\677F\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285420927585873535)
,p_name=>'COPY_FROM_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\4F86\6E90\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285248983628873410)
,p_name=>'COPY_LIST_ENTRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\6E05\55AE\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285382790429873508)
,p_name=>'COPY_NAMED_LOV.EXECUTION_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C copy_named_lov \6642\767C\751F\932F\8AA4: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285382646028873508)
,p_name=>'COPY_NAMED_LOV.NOT_FOUND_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\300C\503C\6E05\55AE\300DID "%0".')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285382583731873508)
,p_name=>'COPY_NAMED_LOV.NUMERIC_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\503C\6E05\55AE\300DID "%0" \4E0D\662F\6578\5B57.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285659338042873710)
,p_name=>'COPY_PAGE.COPY_FROM_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\4F86\6E90\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285659497308873710)
,p_name=>'COPY_PAGE.COPY_TO_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\76EE\6A19\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285658329902873709)
,p_name=>'COPY_PAGE.SELECT_AUTHORIZATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\6388\6B0A -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285658216504873709)
,p_name=>'COPY_PAGE.SELECT_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\6E05\55AE -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285658174846873709)
,p_name=>'COPY_PAGE.SELECT_NAMED_LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('- \9078\53D6\503C\6E05\55AE -')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285730279752873760)
,p_name=>'COPY_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07 %0 \8907\88FD\5230\8868\683C %1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285421084499873535)
,p_name=>'COPY_TO_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\76EE\6A19\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285421154464873535)
,p_name=>'COPY_TO_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\76EE\6A19\540D\7A31')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285346543738873481)
,p_name=>'CORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6838\5FC3')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285513474949873603)
,p_name=>'COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\6578')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285571220278873645)
,p_name=>'CREATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285817415217873818)
,p_name=>'CREATE APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285817593040873818)
,p_name=>'CREATE OBJECT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286027161937873964)
,p_name=>'CREATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286027252943873964)
,p_name=>'CREATED_BY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285678035189873723)
,p_name=>'CREATED_LAST_7_DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904E\53BB 7 \5929\5EFA\7ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285383413656873508)
,p_name=>'CREATED_ON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285220168669873389)
,p_name=>'CREATE_APP_FROM_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5F9E\61C9\7528\7A0B\5F0F\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321337634874181)
,p_name=>'CREATE_APP_WIZ.CANDLE_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('K \7DDA\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321176685874181)
,p_name=>'CREATE_APP_WIZ.COL_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \548C 3D \67F1\72C0\3001\9577\689D\548C\5806\758A\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321834572874181)
,p_name=>'CREATE_APP_WIZ.GAUGE_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\91CF\548C\8A08\91CF\767E\5206\6BD4\5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321282590874181)
,p_name=>'CREATE_APP_WIZ.PIE_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \548C 3D \5713\9905\548C\74B0\5708\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321550350874181)
,p_name=>'CREATE_APP_WIZ.PROJECTGANTT_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C08\6848\7518\7279\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321703006874181)
,p_name=>'CREATE_APP_WIZ.RANGE_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('2D \548C 3D \7BC4\570D\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321648166874181)
,p_name=>'CREATE_APP_WIZ.RESOURCEGANTT_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6E90\7518\7279\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286321482148874181)
,p_name=>'CREATE_APP_WIZ.SCATTER_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6563\5E03\6A19\8A18\5716')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338426147873475)
,p_name=>'CREATE_CONDITION.AND'
,p_message_language=>'zh-tw'
,p_message_text=>'AND'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338228270873475)
,p_name=>'CREATE_CONDITION.ARROW_DOWN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5411\4E0B\7BAD\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338315990873475)
,p_name=>'CREATE_CONDITION.ARROW_RIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5411\53F3\7BAD\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338034447873475)
,p_name=>'CREATE_CONDITION.COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338149492873475)
,p_name=>'CREATE_CONDITION.CONDITIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338546790873476)
,p_name=>'CREATE_CONDITION.OR'
,p_message_language=>'zh-tw'
,p_message_text=>'OR'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338658515873476)
,p_name=>'CREATE_CONDITION.PREVIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\89BD\689D\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285678811841873724)
,p_name=>'CREATE_DEMO_APP.GRANT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4E00\4E0B\4E0B\65B9\7684\300C\6388\4E88\6B0A\9650\300D\6309\9215,  \5C07\9019\4E9B\6B0A\9650\6388\4E88 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285678695444873724)
,p_name=>'CREATE_DEMO_APP.NO_CREATE_PRIV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \6C92\6709 CREATE TABLE, CREATE VIEW, CREATE TRIGGER, CREATE SEQUENCE \6216 CREATE PROCEDURE \6B0A\9650, \56E0\6B64\7121\6CD5\5B89\88DD\793A\7BC4\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285678790526873724)
,p_name=>'CREATE_DEMO_APP.NO_EXEC_PRIV'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('%0 \6C92\6709 CTX_DOC \548C CTX_DDL \7684\57F7\884C\6B0A\9650, \56E0\6B64\7121\6CD5\5B89\88DD\300C\7E3D\7D71\5C31\8077\6F14\8AAA\300D\793A\7BC4.  \8ACB\4EE5\5177\6709\6B0A\9650\7684\4F7F\7528\8005\8EAB\5206\57F7\884C\4E0B\5217\6388\6B0A: '),
'<pre>',
'GRANT EXECUTE ON CTXSYS.CTX_DDL TO %0; ',
'GRANT EXECUTE ON CTXSYS.CTX_DOC TO %0;',
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286025248768873963)
,p_name=>'CREATE_DIALOG_CLOSED_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6309\9215 - \5C0D\8A71\65B9\584A\5DF2\95DC\9589')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285122500814873317)
,p_name=>'CREATE_DYNAMIC_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\52D5\614B\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285406610825873525)
,p_name=>'CREATE_DYNAMIC_LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\52D5\614B\503C\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285100514032873301)
,p_name=>'CREATE_FLOW.CLOUD_IDM'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Cloud Identity Management'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285140037676873330)
,p_name=>'CREATE_FLOW.DBACCOUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\5E33\6236')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285843657770873835)
,p_name=>'CREATE_FLOW.HTMLDB_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Application Express \8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285679273084873724)
,p_name=>'CREATE_FLOW.LDAP'
,p_message_language=>'zh-tw'
,p_message_text=>'LDAP'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286382516533874231)
,p_name=>'CREATE_FLOW.NAVIGATION_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\529F\80FD\8868\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285843706340873835)
,p_name=>'CREATE_FLOW.NO_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\8A8D\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285843344032873835)
,p_name=>'CREATE_FLOW.NO_TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\9801\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285843461774873835)
,p_name=>'CREATE_FLOW.ONE_LEVEL_TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E00\5C64\9801\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285679303615873724)
,p_name=>'CREATE_FLOW.SSO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\55AE\4E00\767B\5165 (SSO)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285843562711873835)
,p_name=>'CREATE_FLOW.TWO_LEVEL_TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5169\5C64\9801\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285219917755873389)
,p_name=>'CREATE_FROM_SPREADSHEET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4EE5\8A66\7B97\8868\5EFA\7ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285096957695873299)
,p_name=>'CREATE_GLOBAL_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\679C\9078\53D6\7684\9801\9762\6A23\677F\5167\5305\542B\5168\57DF\9801\9762\5143\4EF6\4E4B\5340\57DF\7684\986F\793A\4F4D\7F6E, \5C31\6703\5728\6240\6709\9801\9762\4E2D\986F\793A\5168\57DF\9801\9762\5143\4EF6.  \4E0D\904E, \60A8\53EF\4EE5\4F7F\7528\300C\689D\4EF6\6027\986F\793A\300D\5C6C\6027\4F86\6291\5236\986F\793A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285371612234873500)
,p_name=>'CREATE_INDEX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\7D22\5F15')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285527219235873613)
,p_name=>'CREATE_ITEM_WIZ.NO_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\76F8\95DC\7684\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285346244043873481)
,p_name=>'CREATE_NEW_LOGIN_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\65B0\767B\5165\9801\9762.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285340182098873477)
,p_name=>'CREATE_PACKAGE.BACK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\56DE\5230\300C\5EFA\7ACB\8868\683C\7CBE\9748\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339639523873476)
,p_name=>'CREATE_PACKAGE.BROWSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\700F\89BD\5957\88DD\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339561957873476)
,p_name=>'CREATE_PACKAGE.CREATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\88DD\7A0B\5F0F "%0" \5DF2\7D93\5728 "%1" \7DB1\8981\4E2D\5EFA\7ACB.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285340232496873477)
,p_name=>'CREATE_PACKAGE.FAILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\8868\683C "%0" \5931\6557.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285340077100873477)
,p_name=>'CREATE_PACKAGE.HOME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9996\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339825640873477)
,p_name=>'CREATE_PACKAGE.RETURN_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8FD4\56DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339920731873477)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL&nbsp;\5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339742591873476)
,p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4\9996\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285335464236873473)
,p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\627E\4E0D\5230\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285335007518873473)
,p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285335362861873473)
,p_name=>'CREATE_PAGE_ITEM.PROMPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285335168824873473)
,p_name=>'CREATE_PAGE_ITEM.REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285335201548873473)
,p_name=>'CREATE_PAGE_ITEM.SET_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\4E00\4E0B\4EE5\8A2D\5B9A\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285333165179873472)
,p_name=>'CREATE_PROCESS.PAGE_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285333200018873472)
,p_name=>'CREATE_PROCESS.REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339476566873476)
,p_name=>'CREATE_TABLE.HOME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9996\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339248954873476)
,p_name=>'CREATE_TABLE.RETURN_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8FD4\56DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339118380873476)
,p_name=>'CREATE_TABLE.RUN_SCRIPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C\547D\4EE4\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338888858873476)
,p_name=>'CREATE_TABLE.SCRIPT_CREATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5728 SQL \547D\4EE4\6A94\5132\5B58\5340\57DF\4E2D\5EFA\7ACB\8868\683C %0 \7684\5EFA\7ACB\8868\683C\547D\4EE4\6A94.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285338971271873476)
,p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\524D\5F80\300C\547D\4EE4\6A94\5132\5B58\5340\57DF\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339339088873476)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL&nbsp;\5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285339034988873476)
,p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('SQL \5DE5\4F5C\5BA4\9996\9801')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285796203146873804)
,p_name=>'CREATE_TABULAR_FORM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5217\8868\5316\8868\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286401834276874245)
,p_name=>'CREATE_TO_DO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\5F85\8FA6\4E8B\9805')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285731026635873760)
,p_name=>'CREATE_TRIGGER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\89F8\767C\7A0B\5F0F %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285669249604873717)
,p_name=>'CREATE_WS_OBJ_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5EFA\7ACB Web \8A66\7B97\8868\8CC7\6599\5EAB\7269\4EF6.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285621452051873683)
,p_name=>'CREDENTIAL.OWNER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B49\660E\8CC7\6599\64C1\6709\8005')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285583824178873656)
,p_name=>'CSS_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\884C\4E8B\66C6')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285496740098873591)
,p_name=>'CURRENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575696026873648)
,p_name=>'CURRENT ENTRY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575381899873647)
,p_name=>'CURRENT FORM ELEMENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\8868\55AE\5143\7D20')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285359508007873491)
,p_name=>'CURRENT ITEM HELP TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\9805\76EE\8AAA\660E\6587\5B57')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575489566873648)
,p_name=>'CURRENT ITEM IDENTIFICATION NUMBER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\9805\76EE ID \865F\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285575516080873648)
,p_name=>'CURRENT ITEM LABEL NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\9805\76EE\6A19\7C64\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285634526767873692)
,p_name=>'CURRENT TAB'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\9801\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285321389130873463)
,p_name=>'CURRENT_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285328361379873468)
,p_name=>'CURRENT_IMAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\5F71\50CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285935062167873897)
,p_name=>'CURRENT_ITEM_CONTAINER_ID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\4EE5\5728\5305\88DD\76EE\524D\6B04\4F4D\4E4B\5BB9\5668\5143\7D20\4F7F\7528\7684 ID, \65BC\300C\5728\6A19\7C64\548C\9805\76EE\4E4B\524D\300D\5C6C\6027\4E2D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286410300489874251)
,p_name=>'CURRENT_ITEM_HELP_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\9805\76EE\8AAA\660E\6A19\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285287175062873438)
,p_name=>'CURRENT_MILESTONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285327499739873468)
,p_name=>'CURRENT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285602135725873669)
,p_name=>'CURRENT_PAGE_CONTAINS_NO_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\524D\7684\9801\9762\6C92\6709\5305\542B\4EFB\4F55\9805\76EE.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285492580732873588)
,p_name=>'CUSTOM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285535273151873619)
,p_name=>'CUSTOMIZE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285571185957873644)
,p_name=>'CUSTOMIZE LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02\9023\7D50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285580731374873653)
,p_name=>'CUSTOMIZE.USER_PAGE_PREFS_RESET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\91CD\8A2D\4F7F\7528\8005 %0 \7684\9801\9762\504F\597D\8A2D\5B9A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285580830491873653)
,p_name=>'CUSTOMIZE.USER_PREFS_CHANGED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\8B8A\66F4\4F7F\7528\8005 %0 \7684\504F\597D\8A2D\5B9A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285580669283873653)
,p_name=>'CUSTOMIZE.USER_PREFS_RESET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\91CD\8A2D\4F7F\7528\8005 %0 \7684\9801\9762\504F\597D\8A2D\5B9A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286285046742874154)
,p_name=>'CUSTOM_APPLICATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\8A02\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285121400802873317)
,p_name=>'CUSTOM_AUTH_SCHEME_DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\5B9A\7FA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285375883773873503)
,p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('%0 \767C\751F\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285287306424873438)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\8981\4F5C\70BA\60A8\5728\6B64\968E\6BB5\4F5C\696D\4E4B\4F7F\7528\8005 ID \7684\5B57\4E32.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285287423697873438)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\60A8\7684 %0 \4F7F\7528\8005\540D\7A31\548C\5BC6\78BC.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285287522940873439)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\60A8\7684\4F7F\7528\8005\540D\7A31\548C\5BC6\78BC, \4F9B LDAP \4E3B\6A5F\9032\884C\9A57\8B49: %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285287623970873439)
,p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F38\5165\60A8\7684\8CC7\6599\5EAB\7DB1\8981\4F7F\7528\8005\540D\7A31\548C\5BC6\78BC.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286054119165873984)
,p_name=>'CUSTOM_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\8F09\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286059266397873987)
,p_name=>'CUSTOM_CALENDAR.END_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D50\675F\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286059139719873987)
,p_name=>'CUSTOM_CALENDAR.START_DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\59CB\65E5\671F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285731996753873761)
,p_name=>'DA.SET_VALUE.SQL.HELP_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5982\679C True \52D5\4F5C\662F\8A2D\5B9A\985E\578B\70BA SQL \6558\8FF0\53E5\7684\8A2D\5B9A\503C, \90A3\9EBC\60A8\5FC5\9808\4EE5\8207 SQL \6558\8FF0\53E5\7684\8CC7\6599\6B04\9806\5E8F\76F8\540C\7684\9806\5E8F\5B9A\7FA9\300C\53D7\5F71\97FF\7684\5143\7D20\300D. \60A8\4E4B\524D\5B9A\7FA9\7684 SQL \6558\8FF0\53E5\70BA:</p>'),
'<pre>%0</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285292731803873442)
,p_name=>'DAILY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\66C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285509970775873600)
,p_name=>'DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285817080667873818)
,p_name=>'DATA WORKSHOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5DE5\4F5C\5BA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285387405565873511)
,p_name=>'DATA.LOAD.ALL_COL_MAPPED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\90E8\7684 %0 \500B\8CC7\6599\6B04\90FD\5DF2\81EA\52D5\5C0D\61C9\81F3 %1 \8868\683C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388261735873512)
,p_name=>'DATA.LOAD.APPEND_INCOMPLETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C <code>%0</code> \4E2D\7684\8CC7\6599\5DF2\9644\52A0 <b id="incompl_success_row_count"></b> \500B\65B0\8CC7\6599\5217. <b class="u-danger-text" id="incompl_fail_row_count"></b> \500B\8CC7\6599\5217\88AB\62D2\7D55.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285387847466873511)
,p_name=>'DATA.LOAD.APPEND_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C <code>%0</code> \4E2D\7684\8CC7\6599\5DF2\9644\52A0 <b id="success_row_count"></b> \500B\65B0\8CC7\6599\5217!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388027907873512)
,p_name=>'DATA.LOAD.APPEND_WARNING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C <code>%0</code> \4E2D\7684\8CC7\6599\5DF2\9644\52A0 <b id="err_success_row_count"></b> \500B\65B0\8CC7\6599\5217. <b class="u-danger-text" id="err_fail_row_count"></b> \500B\8CC7\6599\5217\88AB\62D2\7D55.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285097470691873299)
,p_name=>'DATA.LOAD.CHOOSE_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\6A94\6848')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285135073615873326)
,p_name=>'DATA.LOAD.CONFIGURATION_SAVED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\614B\5DF2\5132\5B58!')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285387541314873511)
,p_name=>'DATA.LOAD.DEFINE_COL_MAPPING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\5B9A\7FA9\8CC7\6599\6B04\5C0D\61C9, \4EE5\4FBF\5C07\6B64\8CC7\6599\8F09\5165 %0 \8868\683C\4E2D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285097373618873299)
,p_name=>'DATA.LOAD.DRAG_DROP_FILE_HERE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\6A94\6848\62D6\653E\5230\6B64\8655, \6216')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285097281215873299)
,p_name=>'DATA.LOAD.FILE_FORMATS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\652F\63F4\7684\683C\5F0F\70BA csv\3001xlsx\3001txt\3001xml\3001json')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285098381955873300)
,p_name=>'DATA.LOAD.INVALID_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\50B3\7684\6A94\6848\7121\6548, \6216\526F\6A94\540D\4E0D\6B63\78BA.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285266680654873423)
,p_name=>'DATA.LOAD.INVALID_SELECTOR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\7684 XML \6216 JSON \9078\53D6\5668\7121\6548.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285814937491873816)
,p_name=>'DATA.LOAD.JOB_INTERMITTENTLY_FAILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\5DE5\4F5C\57F7\884C\610F\5916\505C\6B62.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285739183170873765)
,p_name=>'DATA.LOAD.JOB_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DE5\4F5C\5340 %0 \4E2D\7684\8CC7\6599\8F09\5165\5DE5\4F5C: \8F09\5165\8868\683C %1 \4E2D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285387654886873511)
,p_name=>'DATA.LOAD.MAP_REMAINING_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\81EA\52D5\5C07 %1 \500B\4E2D\7684 %0 \500B\8CC7\6599\6B04\5C0D\61C9\81F3 %2 \8868\683C. \8ACB\8A2D\5B9A\5176\9918\7684 %3 \500B\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285732717973873761)
,p_name=>'DATA.LOAD.NO_FILE_CONTENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\4E0A\50B3\7684\6A94\6848\4E2D\627E\4E0D\5230\8CC7\6599.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285732857201873761)
,p_name=>'DATA.LOAD.NO_WORKSHEET_CONTENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\5DE5\4F5C\8868 "%0" \4E2D\627E\4E0D\5230\8CC7\6599.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285097748513873299)
,p_name=>'DATA.LOAD.NO_XLSX_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\7684\6A94\6848\4E0D\662F XLSX \6A94\6848.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285779508513873793)
,p_name=>'DATA.LOAD.PASTED_DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CBC\4E0A\7684\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388313263873512)
,p_name=>'DATA.LOAD.REPLACE_INCOMPLETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C <code>%0</code> \4E2D\7684\8CC7\6599\5DF2\7531 <b id="incompl_success_row_count"></b> \500B\65B0\8CC7\6599\5217\53D6\4EE3. <b class="u-danger-text" id="incompl_fail_row_count"></b> \500B\8CC7\6599\5217\88AB\62D2\7D55.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285387994362873512)
,p_name=>'DATA.LOAD.REPLACE_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C <code>%0</code> \4E2D\7684\8CC7\6599\5DF2\7531 <b id="success_row_count"></b> \500B\65B0\8CC7\6599\5217\53D6\4EE3!')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285388172313873512)
,p_name=>'DATA.LOAD.REPLACE_WARNING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C <code>%0</code> \4E2D\7684\8CC7\6599\5DF2\7531 <b id="err_success_row_count"></b> \500B\65B0\8CC7\6599\5217\53D6\4EE3. <b class="u-danger-text" id="err_fail_row_count"></b> \500B\8CC7\6599\5217\88AB\62D2\7D55.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285387724386873511)
,p_name=>'DATA.LOAD.SELECT_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8ACB\9078\53D6\8981\8F09\5165\7684\8CC7\6599\6B04.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286394668926874240)
,p_name=>'DATABASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285817689183873818)
,p_name=>'DATABASE BROWSER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\700F\89BD\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286333235417874190)
,p_name=>'DATABASE.DEMO.SAMPLE.APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\4F8B\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286394797788874240)
,p_name=>'DATABASE_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285141730055873331)
,p_name=>'DATABASE_APPLICATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285169546012873352)
,p_name=>'DATABASE_APPS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285664175382873713)
,p_name=>'DATABASE_APP_SUCCESS_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5B89\88DD\61C9\7528\7A0B\5F0F <strong>%0</strong>.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285561020001873637)
,p_name=>'DATABASE_LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\9023\7D50')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285613846499873677)
,p_name=>'DATABASE_OBJECT_COUNTS_BY_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F9D\7269\4EF6\985E\578B\5340\5206\7684\8CC7\6599\5EAB\7269\4EF6\6578\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285617022623873679)
,p_name=>'DATABASE_ROLE_PRIVILEGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\89D2\8272\6B0A\9650')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285164046511873348)
,p_name=>'DATABASE_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285724792359873756)
,p_name=>'DATA_GRID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\65B9\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286323863588874183)
,p_name=>'DATA_GRIDS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\65B9\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286324348195874183)
,p_name=>'DATA_GRID_DATA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\65B9\683C\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286314314395874176)
,p_name=>'DATA_LOAD.ADVANCED_SETTINGS_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\9032\968E\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285250986866873412)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\4F7F\7528\7684\65E5\671F/\6578\5B57\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285251019259873412)
,p_name=>'DATA_LOAD.APP_DATE_FORMAT_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9078\64C7\662F\8981\63D0\4F9B\81EA\8A02\683C\5F0F\906E\7F69, \9084\662F\4F7F\7528\6A19\6E96\683C\5F0F\906E\7F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285165405514873349)
,p_name=>'DATA_LOAD.CHARSET'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A94\6848\5B57\5143\96C6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285805665649873810)
,p_name=>'DATA_LOAD.COLUMN_NAMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285804182900873809)
,p_name=>'DATA_LOAD.COLUMN_NAMES_MAPPING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\76EE\6A19\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285662234539873712)
,p_name=>'DATA_LOAD.COLUMN_NAME_ALIASES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\540D\7A31\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286018697193873958)
,p_name=>'DATA_LOAD.CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5C07\8CC7\6599\4E0A\50B3\81F3\60A8\7684\8868\683C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286025974572873963)
,p_name=>'DATA_LOAD.COPY_PASTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\4E26\8CBC\4E0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286012284527873953)
,p_name=>'DATA_LOAD.COPY_PASTE_TEXTAREA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\4E26\8CBC\4E0A\5206\9694\7684\8CC7\6599')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354672833874209)
,p_name=>'DATA_LOAD.CURRENCY_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E63\5225\7B26\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354774749874209)
,p_name=>'DATA_LOAD.CURRENCY_ITEM_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\679C\60A8\7684\8CC7\6599\5305\542B\570B\969B\5E63\5225\7B26\865F, \8ACB\5728\6B64\8655\8F38\5165\865F. \4F8B\5982, \5982\679C\60A8\7684\8CC7\6599\5305\542B "&euro;1,234.56" \6216 "&yen;1,234.56", \8ACB\8F38\5165 "&euro;" \6216 "&yen;".  \5426\5247, \8CC7\6599\5C07\7121\6CD5\6B63\78BA\8F09\5165.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285170441831873352)
,p_name=>'DATA_LOAD.DATA_LOADING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286314456879874176)
,p_name=>'DATA_LOAD.DATE_FORMAT_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\61C9\7528\7A0B\5F0F\6A19\6E96\683C\5F0F\906E\7F69')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286314508931874176)
,p_name=>'DATA_LOAD.DATE_FORMAT_CUSTOM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D0\4F9B\5DF2\4E0A\50B3\8CC7\6599\6B04\81EA\8A02\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286356205154874211)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5C0F\6578\9EDE\7B26\865F\53EF\5340\9694\6574\6578\548C\6578\5B57\7684\5C0F\6578\90E8\5206.</p>'),
unistr('<p> \4EFB\4F55\5B57\5143\7686\53EF\7576\6210\5C0F\6578\9EDE\7B26\865F. \6307\5B9A\7684\5B57\5143\5FC5\9808\662F\55AE\4F4D\5143\7D44, \800C\4E14\5C0F\6578\9EDE\7B26\865F\5FC5\9808\8207\7FA4\7D44\5340\9694\7B26\865F\4E0D\540C. \5B57\5143\53EF\4EE5\662F\7A7A\683C, \4F46\4E0D\80FD\662F\6578\5B57\5B57\5143\6216\4E0B\5217\4EFB\4E00\5B57\5143:</p>'),
'<ul class="noIndent">',
unistr('<li>\52A0\865F (+)</li>'),
unistr('<li>\9023\5B57\865F (-)</li> '),
unistr('<li>\5C0F\65BC\7B26\865F (<)</li>'),
unistr('<li>\5927\65BC\7B26\865F (>)</li> '),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286355307523874210)
,p_name=>'DATA_LOAD.DECIMAL_CHARACTER_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0F\6578\9EDE\7B26\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285662492501873712)
,p_name=>'DATA_LOAD.DISPLAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285805556845873810)
,p_name=>'DATA_LOAD.DO_NOT_LOAD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\8F09\5165')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286350277793874203)
,p_name=>'DATA_LOAD.FAILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286262774052874138)
,p_name=>'DATA_LOAD.FAILED_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5931\6557\7684\8CC7\6599\5217:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286334291285874191)
,p_name=>'DATA_LOAD.FAILED_RECORD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5931\6557\7684\8A18\9304')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354240248874208)
,p_name=>'DATA_LOAD.FILE_NAME_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\4E0A\50B3\7684\6A94\6848\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285804484000873809)
,p_name=>'DATA_LOAD.FIRST_COLUMN_NAMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F86\6E90\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286022688696873961)
,p_name=>'DATA_LOAD.FIRST_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7B2C\4E00\500B\8CC7\6599\5217\542B\6709\8CC7\6599\6B04\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354387339874208)
,p_name=>'DATA_LOAD.FIRST_ROW_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\679C\8CC7\6599\7684\7B2C\4E00\5217\662F\8CC7\6599\6B04\540D\7A31, \8ACB\9078\53D6\6B64\65B9\584A.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285805734491873810)
,p_name=>'DATA_LOAD.FORMAT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F / \6578\5B57\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354531189874209)
,p_name=>'DATA_LOAD.GLOBALIZATION_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5168\7403\5316')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286355275572874209)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7FA4\7D44\5340\9694\7B26\865F\662F\4E00\500B\5340\9694\6574\6578\7FA4\7D44\7684\5B57\5143, \4F8B\5982\986F\793A\5343\4F4D\8207\767E\842C\4F4D.</p>'),
unistr('<p>\4EFB\4F55\5B57\5143\7686\53EF\7576\6210\7FA4\7D44\5340\9694\7B26\865F. \6307\5B9A\7684\5B57\5143\5FC5\9808\662F\55AE\4F4D\5143\7D44, \800C\4E14\7FA4\7D44\5340\9694\7B26\865F\5FC5\9808\8207\5176\4ED6\5C0F\6578\9EDE\7B26\865F\4E0D\540C. \5B57\5143\53EF\4EE5\662F\7A7A\683C, \4F46\4E0D\80FD\662F\6578\5B57\5B57\5143\6216\4E0B\5217\4EFB\4E00\5B57\5143:</p>'),
'<ul class="noIndent">',
unistr('<li>\52A0\865F (+)</li>'),
unistr('<li>\9023\5B57\865F (-)</li> '),
unistr('<li>\5C0F\65BC\7B26\865F (<)</li>'),
unistr('<li>\5927\65BC\7B26\865F (>)</li> '),
'</ul>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286354859003874209)
,p_name=>'DATA_LOAD.GROUP_SEPARATOR_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7FA4\7D44\5340\9694\7B26\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286349999531874203)
,p_name=>'DATA_LOAD.INSERT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D2\5165\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286262587241874138)
,p_name=>'DATA_LOAD.INSERTED_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\63D2\5165\7684\8CC7\6599\5217:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286351732282874205)
,p_name=>'DATA_LOAD.IR_MAX_ROW_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\67E5\8A62\50B3\56DE #MAX_ROW_COUNT# \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285661107282873711)
,p_name=>'DATA_LOAD.JUSTCHANGED_RECORD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A18\9304\5DF2\88AB\5176\4ED6\4F7F\7528\8005\8B8A\66F4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285277405333873431)
,p_name=>'DATA_LOAD.LABEL_CASE_SENSITIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6709\5927\5C0F\5BEB\4E4B\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285277354011873431)
,p_name=>'DATA_LOAD.LABEL_UNIQUE_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\552F\4E00\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285985712774873934)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\5931\6557')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285985884236873934)
,p_name=>'DATA_LOAD.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\5DF2\8655\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286011450959873953)
,p_name=>'DATA_LOAD.LOAD_TO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\532F\5165\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286415335053874255)
,p_name=>'DATA_LOAD.LOOKUP_FAILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7121\6CD5\64F7\53D6\67E5\5C0B\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286031893276873968)
,p_name=>'DATA_LOAD.MAPPING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599/\8868\683C\5C0D\61C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285722978149873754)
,p_name=>'DATA_LOAD.MAPPING_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B65\9A5F 2 - \9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286414006729874254)
,p_name=>'DATA_LOAD.NO_PREVIEW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\63D0\4F9B\6A94\6848\9810\89BD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286353474663874207)
,p_name=>'DATA_LOAD.OPTIONAL_ENCLOSE_ITEM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\754C\7B26\865F (\9078\64C7\6027)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286317727910874178)
,p_name=>'DATA_LOAD.PROGRESS_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\7CBE\9748\9032\5EA6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723124792873754)
,p_name=>'DATA_LOAD.RESULTS_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B65\9A5F 4 - \9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285662334954873712)
,p_name=>'DATA_LOAD.RETURN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8FD4\56DE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285660644797873711)
,p_name=>'DATA_LOAD.REVIEW_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\82E5\8981\8B93\8CC7\6599\5217\8907\67E5:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285805840573873810)
,p_name=>'DATA_LOAD.ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285802380051873808)
,p_name=>'DATA_LOAD.RULES_PLSQL_EXPRESSION_EXAMPLES'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'to_char(sysdate)',
'',
'my_func (',
'    p_1 => :SAL,',
'    p_2 => :COMM)',
'',
unistr('\5176\4E2D SAL \548C COMM \70BA\5DF2\4E0A\50B3\8CC7\6599\7684\8CC7\6599\6B04\540D\7A31'),
unistr('\800C my_func \70BA\50B3\56DE\503C\7684\51FD\6578, \8A72\503C\6703\6210\70BA\5B9A\7FA9\6B64\8F49\63DB\898F\5247'),
unistr('\4E4B\8CC7\6599\6B04\7684\65B0\503C.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285802557759873808)
,p_name=>'DATA_LOAD.RULES_PLSQL_FUNCTION_EXAMPLES'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'declare',
'    l_result number;',
'begin',
'    l_result := :SAL * :COMM;',
'    return l_result;',
'end;',
'',
unistr('\50B3\56DE\7684\7D50\679C\5C07\662F\5B9A\7FA9\6B64\8F49\63DB\898F\5247\4E4B\8CC7\6599\6B04\7684\65B0\503C.'),
'',
unistr(':SAL \548C :COMM \6307\7684\662F\5DF2\4E0A\50B3\8CC7\6599\7684 SAL \548C COMM \8CC7\6599\6B04\540D\7A31.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285802475401873808)
,p_name=>'DATA_LOAD.RULES_SQL_QUERY_EXAMPLES'
,p_message_language=>'zh-tw'
,p_message_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'select depno',
' from dept',
'where dname = :DEPTNAME',
'  and loc   = :LOC',
'',
unistr('\5176\4E2D :DEPNAME \548C :LOC \6307\7684\662F\5DF2\4E0A\50B3\8CC7\6599\7684 DEPNAME \548C LOC \8CC7\6599\6B04\540D\7A31.'),
'</pre>'))
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286353289688874207)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6307\5B9A\8CC7\6599\6B04\5340\9694\7B26\865F\5B57\5143. \8ACB\4F7F\7528 <code>\005Ct</code> \4F5C\70BA Tab \5340\9694\7B26\865F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286353347765874207)
,p_name=>'DATA_LOAD.SEPARATOR_ITEM_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\9694\7B26\865F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285662587866873712)
,p_name=>'DATA_LOAD.SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286407000343874249)
,p_name=>'DATA_LOAD.SEQUENCE_ACTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9806\5E8F : \52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286314138453874176)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528\9032\968E\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286314207658874176)
,p_name=>'DATA_LOAD.SHOW_ADVANCED_SETTINGS_HELP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\8CC7\6599\8F09\5165\7684\9032\968E\8A2D\5B9A\503C: \8CA8\5E63\7B26\865F\3001\5C0F\6578\9EDE\7B26\865F\3001\6A94\6848\7DE8\78BC\6216\65E5\671F\683C\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286031232938873967)
,p_name=>'DATA_LOAD.SOURCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285722825394873754)
,p_name=>'DATA_LOAD.SOURCE_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B65\9A5F 1 - \9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286394936373874240)
,p_name=>'DATA_LOAD.TAB_SEPARTOR_NOTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('(\005Ct \4EE3\8868 tab)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285735972280873763)
,p_name=>'DATA_LOAD.TRANSFORMATION_FAILED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8F49\63DB\898F\5247\5931\6557')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286352035280874206)
,p_name=>'DATA_LOAD.UNIQUE_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\552F\4E00\8CC7\6599\6B04 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286350030862874203)
,p_name=>'DATA_LOAD.UPDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\8CC7\6599\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286262625688874138)
,p_name=>'DATA_LOAD.UPDATED_COUNT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66F4\65B0\7684\8CC7\6599\5217:')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286462744275874290)
,p_name=>'DATA_LOAD.UPLOADED_NULL_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\4E0A\50B3\7A7A\503C.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286025801100873963)
,p_name=>'DATA_LOAD.UPLOAD_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0A\50B3\4F7F\7528\9017\865F (*.csv) \6216 Tab \5340\9694\7684\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286031400445873967)
,p_name=>'DATA_LOAD.UPLOAD_RESULTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\7D50\679C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286031389205873967)
,p_name=>'DATA_LOAD.VALIDATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\9A57\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285723062587873754)
,p_name=>'DATA_LOAD.VALIDATION_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B65\9A5F 3 - \9801\9762\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285727103178873757)
,p_name=>'DATA_LOAD_WIZARD_CREATED_SUCCESSFULLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\9806\5229\5EFA\7ACB\8CC7\6599\8F09\5165\7CBE\9748\9801\9762.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285985966197873934)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599/\8868\683C\5C0D\61C9\5931\6557')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285986037146873934)
,p_name=>'DATA_SAVE.LOAD_DATA_PROCESS_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C\5DF2\8655\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285585310238873657)
,p_name=>'DATA_UPLOAD_COLUMN_MAPPING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\4E0A\50B3\8CC7\6599\6B04\5C0D\61C9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285510842440873601)
,p_name=>'DATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285715462085873749)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\9805\76EE %1 \8F38\5165\7684\300C\6A19\793A\65E5\671F\300D\5C6C\6027\503C %0 \4E0D\7B26\5408 %2 \683C\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285721208316873753)
,p_name=>'DATEPICKER.DEFAULT_DATE_INVALID_RELATIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\9805\76EE %1 \8F38\5165\7684\300C\6A19\793A\65E5\671F\300D\5C6C\6027\503C %0 \4E0D\662F\76F8\5C0D\65E5\671F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285715638461873749)
,p_name=>'DATEPICKER.MAX_DATE_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\9805\76EE %1 \8F38\5165\7684\300C\6700\5927\65E5\671F\300D\5C6C\6027\503C %0 \4E0D\7B26\5408 %2 \683C\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285721451900873753)
,p_name=>'DATEPICKER.MAX_DATE_INVALID_RELATIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\9805\76EE %1 \8F38\5165\7684\300C\6700\5927\65E5\671F\300D\5C6C\6027\503C %0 \4E0D\662F\76F8\5C0D\65E5\671F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285715529282873749)
,p_name=>'DATEPICKER.MIN_DATE_INVALID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\9805\76EE %1 \8F38\5165\7684\300C\6700\5C0F\65E5\671F\300D\5C6C\6027\503C %0 \4E0D\7B26\5408 %2 \683C\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285721355649873753)
,p_name=>'DATEPICKER.MIN_DATE_INVALID_RELATIVE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91DD\5C0D\9805\76EE %1 \8F38\5165\7684\300C\6700\5C0F\65E5\671F\300D\5C6C\6027\503C %0 \4E0D\662F\76F8\5C0D\65E5\671F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285849335317873839)
,p_name=>'DATE_ADDED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\65E5\671F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286322125167874182)
,p_name=>'DATE_OF_LAST_RUN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Oracle Application Express \8CC7\6599\5EAB\5DE5\4F5C\8207\4E0A\6B21\57F7\884C\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285341329272873478)
,p_name=>'DAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285341453548873478)
,p_name=>'DAYS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5929')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285638078948873694)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5230\9054\6700\7D42\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285638154687873695)
,p_name=>'DAYS_BEFORE_FINAL_MILESTONE_OF_RELASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5230\9054\7248\6B21 %0 \7684\6700\7D42\91CC\7A0B\7891')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285720595616873753)
,p_name=>'DA_NAME.NATIVE_ADD_CLASS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\985E\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327196191874185)
,p_name=>'DA_NAME.NATIVE_ALERT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B66\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286325866073874184)
,p_name=>'DA_NAME.NATIVE_CANCEL_EVENT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88\4E8B\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327341863874186)
,p_name=>'DA_NAME.NATIVE_CLEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286327240438874185)
,p_name=>'DA_NAME.NATIVE_CONFIRM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\78BA\8A8D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285086970854873291)
,p_name=>'DA_NAME.NATIVE_DIALOG_CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88\5C0D\8A71\65B9\584A')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285087077981873291)
,p_name=>'DA_NAME.NATIVE_DIALOG_CLOSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\95DC\9589\5C0D\8A71\65B9\584A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246619285873409)
,p_name=>'DA_NAME.NATIVE_DISABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\505C\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246527095873409)
,p_name=>'DA_NAME.NATIVE_ENABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\555F\7528')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286319428750874180)
,p_name=>'DA_NAME.NATIVE_EXECUTE_PLSQL_CODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C PL/SQL \7A0B\5F0F\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246415313873409)
,p_name=>'DA_NAME.NATIVE_HIDE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285632894728873691)
,p_name=>'DA_NAME.NATIVE_JAVASCRIPT_CODE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C JavaScript \7A0B\5F0F\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285992896589873939)
,p_name=>'DA_NAME.NATIVE_REFRESH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\6574\7406')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285720695382873753)
,p_name=>'DA_NAME.NATIVE_REMOVE_CLASS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664\985E\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285720756406873753)
,p_name=>'DA_NAME.NATIVE_SET_CSS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285965797197873920)
,p_name=>'DA_NAME.NATIVE_SET_FOCUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\7126\9EDE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285632735760873691)
,p_name=>'DA_NAME.NATIVE_SET_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285246372287873408)
,p_name=>'DA_NAME.NATIVE_SHOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285965874600873920)
,p_name=>'DA_NAME.NATIVE_SUBMIT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9001\51FA\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285903316555873876)
,p_name=>'DA_NAME.NATIVE_TREE_COLLAPSE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96B1\85CF\6A39\72C0\7D50\69CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285903207048873876)
,p_name=>'DA_NAME.NATIVE_TREE_EXPAND'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C55\958B\6A39\72C0\7D50\69CB')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285123857481873318)
,p_name=>'DBACCOUNT_AUTH_SCHEME_DESC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\5E33\6236')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285628922855873688)
,p_name=>'DB_COLS_CASE_SEN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\8868\683C\8207\8CC7\6599\6B04\540D\7A31\6709\5927\5C0F\5BEB\4E4B\5225')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285741221501873767)
,p_name=>'DB_OBJECT_CREATION_EXCEPTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5EAB\7269\4EF6\5EFA\7ACB\7570\5E38\72C0\6CC1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285137565614873328)
,p_name=>'DB_PRODUCT_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>'Oracle Database'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286385187987874233)
,p_name=>'DB_SERVICES_ALIAS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5225\540D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381528884874230)
,p_name=>'DB_SERVICES_ALL_MIMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6240\6709 Mime')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286385082304874233)
,p_name=>'DB_SERVICES_CREATE_HANDLER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\8655\7406\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381878370874230)
,p_name=>'DB_SERVICES_CREATE_METHOD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381645984874230)
,p_name=>'DB_SERVICES_CREATE_PARAMETER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\53C3\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381741064874230)
,p_name=>'DB_SERVICES_CREATE_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286388841597874235)
,p_name=>'DB_SERVICES_DB_SERVICES_MODULE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('RESTful \670D\52D9\6A21\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286384952558874233)
,p_name=>'DB_SERVICES_HANDLER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389347817874236)
,p_name=>'DB_SERVICES_HANDLER_BIND_VARIABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\7A0B\5F0F\9023\7D50\8B8A\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358781437874213)
,p_name=>'DB_SERVICES_HANDLER_METHOD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\7A0B\5F0F\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389682023874236)
,p_name=>'DB_SERVICES_HANDLER_SOURCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\7A0B\5F0F\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358811761874213)
,p_name=>'DB_SERVICES_HANDLER_SRC_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\7A0B\5F0F\4F86\6E90\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381390156874230)
,p_name=>'DB_SERVICES_METHOD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\6CD5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286388994960874236)
,p_name=>'DB_SERVICES_MODULE_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A21\7D44\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389408390874236)
,p_name=>'DB_SERVICES_MODULE_URI'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A21\7D44 URI \524D\7F6E\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381957715874230)
,p_name=>'DB_SERVICES_NO_SOURCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6C92\6709\4F86\6E90')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381273987874230)
,p_name=>'DB_SERVICES_PARAMETER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53C3\6578')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389119701874236)
,p_name=>'DB_SERVICES_RESTFUL_SERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('RESTful \670D\52D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286381427923874230)
,p_name=>'DB_SERVICES_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286389524460874236)
,p_name=>'DB_SERVICES_TEMPLATE_URI'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('URI \6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358691792874213)
,p_name=>'DB_SERVICES_URI'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D71\4E00\8CC7\6E90\8B58\5225\9805 (URI)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286388676445874235)
,p_name=>'DB_SERVICES_URI_PRIFIX'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('URI \524D\7F6E\78BC')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286388791392874235)
,p_name=>'DB_SERVICES_URI_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('URI \6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286358964121874213)
,p_name=>'DB_SERVICE_QUERY_ONE_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\67E5\8A62\4E00\500B\8CC7\6599\5217')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285534366424873618)
,p_name=>'DEBUG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9664\932F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285649372714873703)
,p_name=>'DEBUGGING_OFF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\61C9\7528\7A0B\5F0F\672A\555F\7528\9664\932F\529F\80FD.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285646055973873700)
,p_name=>'DECLINED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\62D2\7D55')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286460603459874288)
,p_name=>'DEFAULT_DIALOGBTNR_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\5C0D\8A71\65B9\584A\6309\9215\5340\57DF\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286460535712874288)
,p_name=>'DEFAULT_DIALOGR_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\5C0D\8A71\65B9\584A\5167\5BB9\5340\57DF\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285986738728873935)
,p_name=>'DEFAULT_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285515270205873604)
,p_name=>'DEFAULT_TABLESPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\8868\683C\7A7A\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285516914721873605)
,p_name=>'DEFAULT_TABLESPACE_INIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\8868\683C\7A7A\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285804615680873809)
,p_name=>'DEFAULT_TEMPLATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\6A23\677F')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285119598832873315)
,p_name=>'DEFINED_BY_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\614B\52D5\4F5C\5B9A\7FA9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286050378888873981)
,p_name=>'DEFINED_TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\61C9\7528\7A0B\5F0F\6709 %0 \500B\7D44\7E54\70BA %1 \500B\9801\7C64\96C6\7684\9801\7C64, \4E14\5DF2\5B9A\7FA9 %2 \500B\7236\9805\9801\7C64.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285406514289873525)
,p_name=>'DEFINE_LOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B9A\7FA9\503C\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285571497009873645)
,p_name=>'DEFINITION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B9A\7FA9')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285739092879873765)
,p_name=>'DEINSTALLATION_SCRIPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89E3\9664\5B89\88DD\547D\4EE4\6A94')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285343103858873479)
,p_name=>'DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285234707210873400)
,p_name=>'DELETED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\522A\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286323398702874183)
,p_name=>'DELETE_APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285796382026873804)
,p_name=>'DELETE_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664: %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285772191233873788)
,p_name=>'DELETE_LINK_TEXT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664 %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285148151793873336)
,p_name=>'DELETE_MSG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285185815387873364)
,p_name=>'DEMO.COLLECT.DESCR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\53EF\4EE5\5229\7528\300C\96C6\5408\5C55\793A\300D\5132\5B58\53EF\65BC Oracle Application Express \968E\6BB5\4F5C\696D\5167\4F7F\7528\4E4B\8CC7\6599\7684\8CC7\6599\5217. \6B64\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F\793A\7BC4\8AAA\660E\5982\4F55\4F7F\7528 PL/SQL \4F86\5EFA\7ACB\53CA\7BA1\7406\61C9\7528\96C6\5408\7684\968E\6BB5\4F5C\696D\72C0\614B.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285185664540873364)
,p_name=>'DEMO.SAMPLE.APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7BC4\4F8B\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285185748121873364)
,p_name=>'DEMO.SAMPLE.APP.DESCR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Product Portal \662F\4E00\500B\5F37\8ABF\901A\7528\8A2D\8A08\6982\5FF5\7684\7BC4\4F8B\61C9\7528\7A0B\5F0F. \5176\4E2D\5305\62EC\5BA2\6236\3001\7522\54C1\4EE5\53CA\8A02\55AE\7684\5C08\7528\9801\9762, \4E26\4E14\793A\7BC4\5831\8868\3001\5716\8868\3001\884C\4E8B\66C6\3001\5730\5716\4EE5\53CA\6A39\72C0\7D50\69CB\7684\7528\6CD5.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285594155729873663)
,p_name=>'DEMONSTRABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\793A\7BC4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285323938711873465)
,p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5065\5168\5831\8868\8207\5206\9801\6982\5FF5\7684\7BC4\4F8B.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285323675934873465)
,p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528 %0 \5EFA\7ACB\7684\7DDA\4E0A\5132\5B58\7BC4\4F8B.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285324368137873465)
,p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\77AD\89E3\4F7F\7528 Oracle Text \8207 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285324724593873466)
,p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F7F\7528 %0 \5EFA\7ACB\4E4B\61C9\7528\7A0B\5F0F\7684\5C08\6848\72C0\614B\8FFD\8E64\7BC4\4F8B.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285324187130873465)
,p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B78\7FD2\4F7F\7528 Web \670D\52D9\8207 %0.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322486269873464)
,p_name=>'DEMO_APPLICATION.ACTION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285320230332873462)
,p_name=>'DEMO_APPLICATION.APPLICATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319954844873462)
,p_name=>'DEMO_APPLICATION.BASIC_LEXER'
,p_message_language=>'zh-tw'
,p_message_text=>'BASIC_LEXER'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285323820764873465)
,p_name=>'DEMO_APPLICATION.BUSINESS_LOOK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F01\696D\9801\9762\5916\89C0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322580986873464)
,p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\96C6\5408\5C55\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285320000558873462)
,p_name=>'DEMO_APPLICATION.CONTEXT_INDEX'
,p_message_language=>'zh-tw'
,p_message_text=>'CONTEXT INDEX'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319480890873462)
,p_name=>'DEMO_APPLICATION.CREATE_BASIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\5EFA\7ACB\300C\57FA\672C\7BC4\4F8B\793A\7BC4\61C9\7528\7A0B\5F0F\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318021953873461)
,p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07 (\91CD\65B0) \5EFA\7ACB\4F01\696D\9801\9762\5916\89C0\300C\793A\7BC4\61C9\7528\7A0B\5F0F\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319586782873462)
,p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\5EFA\7ACB\300C\96C6\5408\5C55\793A\793A\7BC4\61C9\7528\7A0B\5F0F\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319603089873462)
,p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5728\7DB1\8981 %0 \5EFA\7ACB\6216\91CD\65B0\5EFA\7ACB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317923042873461)
,p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EFA\7ACB\793A\7BC4 Web \670D\52D9\7684\7BC4\4F8B\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318132298873461)
,p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\5EFA\7ACB\300CWorldCup Mania \793A\7BC4\61C9\7528\7A0B\5F0F\300D.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285128016478873321)
,p_name=>'DEMO_APPLICATION.DEINSTALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\79FB\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322243573873464)
,p_name=>'DEMO_APPLICATION.DEMO_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\793A\7BC4\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285320584204873462)
,p_name=>'DEMO_APPLICATION.FREE_SPACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5927\7D04\6709 %0 MB \7684\53EF\7528\7A7A\9593.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285323083905873464)
,p_name=>'DEMO_APPLICATION.INSTALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B89\88DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322767910873464)
,p_name=>'DEMO_APPLICATION.INSTALLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5B89\88DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285437714898873548)
,p_name=>'DEMO_APPLICATION.INSTALL_DEMO_APP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\60A8\5373\5C07\5B89\88DD\300C\7BC4\4F8B\61C9\7528\7A0B\5F0F\300D, \5B83\6703\793A\7BC4 %0 \7684\4E3B\8981\529F\80FD.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285323762988873465)
,p_name=>'DEMO_APPLICATION.INSTALL_NOW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7ACB\5373\5B89\88DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322671196873464)
,p_name=>'DEMO_APPLICATION.LEARN_ABOUT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\77AD\89E3 %0 \8CFC\7269\8ECA\6982\5FF5.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285776326399873790)
,p_name=>'DEMO_APPLICATION.LOCKED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9396\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285320327976873462)
,p_name=>'DEMO_APPLICATION.NEED_7M'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\300C\7E3D\7D71\5C31\8077\6F14\8AAA\793A\7BC4\300D\5927\7D04\9700\8981 7 MB \7684\53EF\7528\78C1\789F\7A7A\9593, \800C\4E14\53EF\80FD\9700\8981 2 \5206\9418\7684\6642\9593\624D\80FD\5B89\88DD\5230\60A8\7684\7DB1\8981.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285437414314873547)
,p_name=>'DEMO_APPLICATION.NOT_ENOUGH_SPACE_ERR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\9593\4E0D\8DB3, \7121\6CD5\5EFA\7ACB\6B64\793A\7BC4.  \8ACB\81F3\7BA1\7406\9801\9762, \524D\5F80\4F48\5EFA\670D\52D9, \7136\5F8C\6309\4E00\4E0B\9023\7D50\4F86\8981\6C42\984D\5916\7684\5132\5B58. %0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322967775873464)
,p_name=>'DEMO_APPLICATION.NOT_INSTALLED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\672A\5B89\88DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318830559873461)
,p_name=>'DEMO_APPLICATION.OBJECT_EXIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317780183873460)
,p_name=>'DEMO_APPLICATION.OBJECT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318721908873461)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319869301873462)
,p_name=>'DEMO_APPLICATION.OBJECT_NAME2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7269\4EF6\540D\7A31')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285317800573873460)
,p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E0D\5B58\5728')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318404933873461)
,p_name=>'DEMO_APPLICATION.OBJECT_RECREATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C07\91CD\65B0\5EFA\7ACB\4E0B\5217\8CC7\6599\5EAB\7269\4EF6 (\5982\679C\5B58\5728)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318610241873461)
,p_name=>'DEMO_APPLICATION.OBJECT_TYPE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7269\4EF6\985E\578B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319323913873462)
,p_name=>'DEMO_APPLICATION.PACKAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\88DD\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285323591708873465)
,p_name=>'DEMO_APPLICATION.PETSTORE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5BF5\7269\5E97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285324212847873465)
,p_name=>'DEMO_APPLICATION.PRESIDENTIAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7E3D\7D71\5C31\8077\6F14\8AAA')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285324563893873465)
,p_name=>'DEMO_APPLICATION.PROJECT_TRACKING'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C08\6848\8FFD\8E64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285520996871873608)
,p_name=>'DEMO_APPLICATION.RE_INSTALL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\91CD\65B0\5B89\88DD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322866641873464)
,p_name=>'DEMO_APPLICATION.RUN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\57F7\884C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318505865873461)
,p_name=>'DEMO_APPLICATION.SCHEMA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DB1\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319100103873461)
,p_name=>'DEMO_APPLICATION.SEQUENCE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9806\5E8F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322308775873464)
,p_name=>'DEMO_APPLICATION.STATUS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\72C0\614B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285318938428873461)
,p_name=>'DEMO_APPLICATION.TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285322121563873464)
,p_name=>'DEMO_APPLICATION.TABLE_SUMMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\793A\7BC4\61C9\7528\7A0B\5F0F\5B89\88DD\72C0\614B\5831\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285319247394873461)
,p_name=>'DEMO_APPLICATION.TRIGGER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89F8\767C\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285776522442873791)
,p_name=>'DEMO_APPLICATION.UNLOCKED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\89E3\9664\9396\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285165077195873348)
,p_name=>'DEMO_APPLICATION.UPDATE_AVAILABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\7528\7684\66F4\65B0')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286415027567874255)
,p_name=>'DEMO_APPLICATION.WEBSHEET_OBJECT_VALIDATE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FC5\9808\66F4\6B63\4E0B\5217\7121\6548\7684\7269\4EF6, \624D\80FD\6B63\78BA\57F7\884C\300CWeb \8A66\7B97\8868\300D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285324041637873465)
,p_name=>'DEMO_APPLICATION.WEB_SERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \670D\52D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285320696677873462)
,p_name=>'DEMO_APPLICATION.WILL_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5982\679C\672A\91CD\65B0\5EFA\7ACB\6B64\793A\7BC4, \53EF\80FD\6703\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253597453873414)
,p_name=>'DEMO_FLOW.CREATED_ERROR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7A7A\9593\4E0D\8DB3, \7121\6CD5\5EFA\7ACB\6B64\793A\7BC4.  \8ACB\81F3\7BA1\7406\9801\9762, \7136\5F8C\6309\4E00\4E0B\300C\8981\6C42\8B8A\66F4\76EE\524D\7684\670D\52D9\300D\9023\7D50\4F86\8981\6C42\984D\5916\7684\5132\5B58.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285253460514873414)
,p_name=>'DEMO_FLOW.CREATED_SUCCESS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\5EFA\7ACB %0 \793A\7BC4\61C9\7528\7A0B\5F0F.')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286024522117873962)
,p_name=>'DEPRECATED'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5DF2\88AB\53D6\4EE3')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285201421107873375)
,p_name=>'DERIVED$'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\884D\751F\7684\8CC7\6599\6B04')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285594004569873663)
,p_name=>'DESIRABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9700\8981')
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285669932797873718)
,p_name=>'DETAIL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285736798257873764)
,p_name=>'DETAILS_FOR_ALT_TAG'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A73\7D30\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285670001773873718)
,p_name=>'DETAIL_2'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\660E\7D30 2')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285136186773873327)
,p_name=>'DEVELOPER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285742928638873768)
,p_name=>'DEVELOPERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285614442701873678)
,p_name=>'DEVELOPER_ACTIVITY_SUMMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\6D3B\52D5\6458\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285639349572873695)
,p_name=>'DEVELOPER_SUMMARY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\6458\8981')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819850416873820)
,p_name=>'DEVELOPER_TOOLBAR_CLEAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\9664')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285819778899873820)
,p_name=>'DEVELOPER_TOOLBAR_COPY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285848411437873839)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9664\932F (%0)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285847937545873838)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9810\8A2D\9664\932F\5C64\6B21')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285848172457873838)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL4'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\8A0A (\9810\8A2D\503C)')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285848258898873839)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL6'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8FFD\8E64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285848333283873839)
,p_name=>'DEVELOPER_TOOLBAR_DEBUG_LEVEL9'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B8C\6574\8FFD\8E64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285807408142873811)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\8F09\5165\6642\767C\751F\4E00\6216\591A\500B\932F\8AA4. \8ACB\958B\555F\700F\89BD\5668\7684 JavaScript \4E3B\63A7\53F0, \4EE5\67E5\770B\9019\4E9B\932F\8AA4.')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285808059581873812)
,p_name=>'DEVELOPER_TOOLBAR_ERRORS_BTN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('JavaScript \932F\8AA4')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285902932117873876)
,p_name=>'DEVELOPER_TOOLBAR_NO_BUILDER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B64\529F\80FD\9700\8981\958B\555F\300CApplication Express \61C9\7528\7A0B\5F0F\7522\751F\5668\300D\8996\7A97. \8981\5728\6B64\8996\7A97\4E2D\958B\555F\300C\7522\751F\5668\300D\55CE?')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285882875935873862)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\5DE5\5177\5217\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285891122408873868)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_AUTO_HIDE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\81EA\52D5\96B1\85CF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285891357271873868)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_DISPLAY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\4F4D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285891288427873868)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_ICONS_ONLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\50C5\986F\793A\5716\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285891526393873868)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_BOTTOM'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5E95\7AEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285891493530873868)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_LEFT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9760\5DE6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285891636491873868)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_RIGHT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9760\53F3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285899254365873873)
,p_name=>'DEVELOPER_TOOLBAR_OPTIONS_POS_TOP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9802\7AEF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285814140592873816)
,p_name=>'DEVELOPER_TOOLBAR_PAGE_INFO'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\8CC7\8A0A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285814373200873816)
,p_name=>'DEVELOPER_TOOLBAR_PERF_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6548\80FD\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285882928059873862)
,p_name=>'DEVELOPER_TOOLBAR_QUICK_EDIT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5FEB\901F\7DE8\8F2F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285814225363873816)
,p_name=>'DEVELOPER_TOOLBAR_SHOW_PERF'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\986F\793A\9801\9762\6642\9593')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286431030367874267)
,p_name=>'DEVELOPER_TOOLBAR_THEME_ROLLER'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C\6372\52D5\5668')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285891084800873868)
,p_name=>'DEVELOPER_TOOLBAR_TITLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\5DE5\5177\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285587501286873658)
,p_name=>'DEVELOPMENT_TASK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\5DE5\4F5C')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285770638076873787)
,p_name=>'DIAL_CHART_ALERT_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8B66\793A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285770538219873787)
,p_name=>'DIAL_CHART_HIGH_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9AD8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285770457525873786)
,p_name=>'DIAL_CHART_LOW_VALUE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4F4E\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285090725558873294)
,p_name=>'DIAL_PCT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A08\91CF (\767E\5206\6BD4)')
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172234220873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174894705873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A8D\8B49\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174913047873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_AUTHORIZATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6388\6B0A\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174044405873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BC_ENTRIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173935071873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BREADCRUMBS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286472889803874297)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_BUILD_OPTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7D44\5EFA\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173662058873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_COMPUTATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173880642873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174145962873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LISTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174267915873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LIST_ENTRIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174324348873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOVS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\6E05\55AE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285110342028873308)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\6E05\55AE\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174423315873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_LOV_ENTRIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174543929873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_NAV_BAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172310926873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173531823873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BRANCHES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5206\652F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172700194873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_BUTTONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285560534465873637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHARTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285560761173873637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_A'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5EA7\6A19\8EF8')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285560647473873637)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_CHART_S'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173207995873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_COMP'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\904B\7B97')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285219477205873388)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\614B\52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285219550915873389)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_DA_ACTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\614B\52D5\4F5C - \52D5\4F5C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285992104947873939)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Flash 5 \5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285992264355873939)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH5_S'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172808706873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_CH'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Flash \5716\8868')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172932015873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_FLASH_S'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6578\5217')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173040151873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('IR \5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173161524873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_IR_COL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172534252873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_ITEMS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173422140873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_PROC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8655\7406\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172498428873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REGIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286284279757874154)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_REG_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285172627772873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_RPT_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286379779898874229)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_TREES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A39\72C0\7D50\69CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173323519873354)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PAGE_VAL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9A57\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174621050873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PARENT_TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7236\9805\9801\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285173749351873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_PROCESSES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8655\7406\4F5C\696D')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286410954304874252)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_LAYOUTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\7248\9762\914D\7F6E')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286411737414874252)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QRY_STMTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\67E5\8A62 SQL \6558\8FF0\53E5')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286410836247874252)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_RPT_QUERIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\67E5\8A62')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286349844022874203)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SETTINGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\8A2D\5B9A\503C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175050099873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SHORTCUTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6377\5F91')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285170219722873352)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_STATIC_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\61C9\7528\7A0B\5F0F\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176578276873357)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUBSTITUTIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\66FF\4EE3\9805\76EE')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286472594235874297)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJECTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\652F\63F4\7684\7269\4EF6')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286472681550874297)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_BOPT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\652F\63F4\7684\7269\4EF6\7D44\5EFA\9078\9805')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176315363873357)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_CHCK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\652F\63F4\7269\4EF6\9A57\8B49')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176427838873357)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_SUPP_OBJ_SCR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\652F\63F4\7269\4EF6\547D\4EE4\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285174776908873355)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TABS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\7C64')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175441172873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C0E\89BD\8DEF\5F91\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175564543873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_BUTTON'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6309\9215\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175627951873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_CALENDAR'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\884C\4E8B\66C6\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285245971912873408)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_GRID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B9\683C\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175728173873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LABEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A19\7C64\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175814622873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_LIST'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6E05\55AE\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175932089873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_PAGE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9801\9762\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176073181873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_POPUPLOV'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5373\73FE\5F0F LOV \6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176166641873357)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REGION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5340\57DF\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285176262665873357)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TEMP_REPORT'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\6A23\677F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175302754873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEMES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285152465911873339)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285098569842873300)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_THEME_STYLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E3B\984C\6A23\5F0F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285619678191873681)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANSLATIONS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6587\5B57\8A0A\606F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285144953362873334)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_DYNAMIC'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\52D5\614B\7FFB\8B6F')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285145097655873334)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TRANS_REPOS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53EF\7FFB\8B6F\7684\5167\5BB9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175212431873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_TREES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6A39\72C0\7D50\69CB')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285175125367873356)
,p_name=>'DICTIONARY_VIEW.APEX_APPLICATION_WEB_SERVICES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('Web \670D\52D9')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286370987369874222)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_ROLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\89D2\8272')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286371015815874222)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USERS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\4F7F\7528\8005')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285661365645873711)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_ACL_USER_ROLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5B58\53D6\63A7\5236\4F7F\7528\8005\89D2\8272\6307\5B9A')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286414616852874255)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_CONCATENATED_FILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E32\63A5\7684\6A94\6848')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285568509264873643)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5256\6790\8A2D\5B9A\6A94')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285568600199873643)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DATA_PROFILE_COLS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5256\6790\8A2D\5B9A\6A94\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286444383961874276)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_DEVELOPER_COMMENTS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\958B\767C\4EBA\54E1\8A3B\89E3')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285979974117873930)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285968194160873921)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\8868\683C')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285968201550873921)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_LOOKUPS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\8868\683C\67E5\5C0B')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285968313116873922)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_LOAD_TABLE_RULES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\8F09\5165\8868\683C\8F49\63DB\898F\5247')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285105369823873305)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_CALENDARS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\884C\4E8B\66C6\9801\9762')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285883793305873862)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\4E92\52D5\5F0F\65B9\683C\5340\57DF')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285883826857873863)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5831\8868\8CC7\6599\6B04')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285883930312873863)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PAGE_IG_COL_GROUPS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\7FA4\7D44')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285192623469873369)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGINS'
,p_message_language=>'zh-tw'
,p_message_text=>'Plug-in'
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285192724835873369)
,p_name=>'DICTIONARY_VIEW.APEX_APPL_PLUGIN_ATTRIBUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5C6C\6027')
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(285618231704873680)
,p_name=>'