prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4757
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4757 - Oracle APEX Productivity and Sample Applications
--
-- Application Export:
--   Application:     4757
--   Name:            Oracle APEX Productivity and Sample Applications
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     38
--       Items:                  194
--       Computations:            21
--       Validations:             39
--       Processes:               48
--       Regions:                147
--       Buttons:                 69
--       Dynamic Actions:         36
--     Shared Components:
--       Logic:
--         Items:                  4
--         Processes:              2
--         Computations:           2
--         Build Options:          1
--       Navigation:
--         Lists:                 13
--         Breadcrumbs:            1
--           Entries:             26
--         NavBar Entries:         1
--       Security:
--         Authentication:         1
--         Authorization:         14
--       User Interface:
--         Templates:
--           Page:                 7
--           Region:              11
--           Label:                7
--           List:                 6
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:               6
--           Report:               8
--         LOVs:                  24
--         Plug-ins:              12
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Productivity and Sample Applications')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286632300684935833')
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20191024135349'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'zh-tw'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(539943211297143567.4757)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_runtime_api_usage=>'O:W'
,p_security_scheme=>wwv_flow_api.id(806250634212071966)
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'HELP'
,p_substitution_value_01=>unistr('\8AAA\660E')
,p_substitution_string_02=>'PRODUCT_NAME'
,p_substitution_value_02=>'Application Express'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>unistr('\5DE5\4F5C\5340: &COMPANY.')
,p_substitution_string_04=>'MSG_LANGUAGE'
,p_substitution_value_04=>unistr('\8A9E\8A00')
,p_substitution_string_05=>'MSG_COPYRIGHT'
,p_substitution_value_05=>unistr('\8457\4F5C\6B0A\6240\6709 &copy; 1999, 2019, Oracle. \4FDD\7559\4E00\5207\6B0A\5229.')
,p_substitution_string_06=>'MSG_USER'
,p_substitution_value_06=>unistr('\4F7F\7528\8005')
,p_substitution_string_07=>'MSG_JSCRIPT'
,p_substitution_value_07=>unistr('\60A8\5FC5\9808\555F\7528 JavaScript, \624D\80FD\57F7\884C\672C\7522\54C1.')
,p_substitution_string_08=>'MSG_TBL_SUMMARY'
,p_substitution_value_08=>unistr('\9801\9762\7248\9762\914D\7F6E\8868\683C')
,p_substitution_string_09=>'EDIT'
,p_substitution_value_09=>unistr('\7DE8\8F2F')
,p_substitution_string_10=>'DONE'
,p_substitution_value_10=>unistr('\5B8C\6210')
,p_substitution_string_11=>'TOP'
,p_substitution_value_11=>unistr('\8FD4\56DE\9801\9996')
,p_substitution_string_12=>'CLOSE'
,p_substitution_value_12=>unistr('\95DC\9589')
,p_substitution_string_13=>'CONFIRM'
,p_substitution_value_13=>unistr('\78BA\8A8D')
,p_substitution_string_14=>'DATE_FORMAT'
,p_substitution_value_14=>'yyyy/mm/dd'
,p_substitution_string_15=>'LONG_DATE_FORMAT'
,p_substitution_value_15=>unistr('fmDay yyyy"\5E74"mm"\6708"dd"\65E5"')
,p_substitution_string_16=>'TIME_FORMAT'
,p_substitution_value_16=>'AM hh:mi:ss'
,p_substitution_string_17=>'DATE_TIME_FORMAT'
,p_substitution_value_17=>'yyyy/mm/dd AM hh:mi:ss'
,p_substitution_string_18=>'RETURN_TO_APP'
,p_substitution_value_18=>unistr('\8FD4\56DE\61C9\7528\7A0B\5F0F')
,p_substitution_string_19=>'DELETE_MSG'
,p_substitution_value_19=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
,p_substitution_string_20=>'PAGE'
,p_substitution_value_20=>unistr('\9801\9762')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141356'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697584654501422607.4757)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697584848032422609.4757)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697585197430422609.4757)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697585449821422609.4757)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\7BA1\7406\670D\52D9')
,p_security_scheme=>wwv_flow_api.id(404682514053862570)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697585763975422610.4757)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\7BA1\7406\670D\52D9')
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697585449821422609.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697586015426422610.4757)
,p_list_item_display_sequence=>215
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(697585449821422609.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697586354477422610.4757)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('\63D0\51FA\670D\52D9\8981\6C42')
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(697585449821422609.4757)
,p_security_scheme=>wwv_flow_api.id(404682514053862570)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697586632510422611.4757)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('\8A2D\5B9A\5DE5\4F5C\5340\504F\597D\8A2D\5B9A')
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_api.id(697585449821422609.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697586992140422611.4757)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\7DE8\8F2F\516C\544A')
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697585449821422609.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697587277472422611.4757)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\5DE5\4F5C\5340\4F7F\7528\72C0\6CC1')
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(697585449821422609.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697587582961422612.4757)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\7BA1\7406\4F7F\7528\8005\548C\7FA4\7D44')
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(404682514053862570)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697587853738422612.4757)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\76E3\7763\6D3B\52D5')
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(404690492509862587)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697588196393422612.4757)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>unistr('\5100\8868\677F')
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_api.id(404690492509862587)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1250834841571213656.4757)
,p_list_item_display_sequence=>600
,p_list_item_link_text=>unistr('\8B8A\66F4\6211\7684\5BC6\78BC')
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(404690492509862587)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(697615600061428203.4757)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1815078936809651210.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\5EAB\6587\4EF6')
,p_list_item_link_target=>'&SYSTEM_HELP_URL./htmdb/utilizing-packaged-applications.html'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697615898751428203.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6587\4EF6')
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkDocLib'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2105955959214049535.4757)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\8A0E\8AD6\8AD6\58C7')
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2185501568508575816.4757)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\7532\9AA8\6587\5168\7403\958B\767C\8005\6280\8853\7DB2\8DEF (OTN)')
,p_list_item_link_target=>'http://otn.oracle.com/apex'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697616716682428203.4757)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(697617094963428203.4757)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\95DC\65BC')
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(719097510387175373.4757)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW::'
,p_list_item_icon_alt_attribute=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\5411\4E0B\5C55\958B\529F\80FD')
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_api.id(746087390984722118)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719098028313175375.4757)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>unistr('\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:DATABASE:'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719098321380175375.4757)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('Web \8A66\7B97\8868\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::P1500_SHOW:WEBSHEET:'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719098639990175375.4757)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719098992508175375.4757)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\5EFA\7ACB')
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,4011,4012,4013,4059,4061,35,262,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719099266704175376.4757)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\532F\5165')
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719099546300175376.4757)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\532F\51FA')
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719099824007175376.4757)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>unistr('\5DE5\4F5C\5340\516C\7528\7A0B\5F0F')
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719100455998175377.4757)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>unistr('\5168\90E8\5DE5\4F5C\5340\516C\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719100773299175377.4757)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719101097849175377.4757)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\9810\8A2D\503C')
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719101644205175378.4757)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>unistr('\5DE5\4F5C\5340\4E3B\984C')
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719101935050175380.4757)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\7FA4\7D44')
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719102257549175380.4757)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>unistr('Application Express \6AA2\8996')
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719102594130175381.4757)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>unistr('\4EA4\53C9\61C9\7528\7A0B\5F0F\5831\8868')
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719100155318175376.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719102894713175381.4757)
,p_list_item_display_sequence=>169
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719103155672175381.4757)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\79FB\8F49')
,p_list_item_link_target=>'f?p=4400:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719097773376175375.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719103492129175381.4757)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('SQL \5DE5\4F5C\5BA4')
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>unistr('SQL \5DE5\4F5C\5BA4\5411\4E0B\5C55\958B\529F\80FD')
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_api.id(404692541807863512)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719103785484175382.4757)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\7269\4EF6\700F\89BD\5668')
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719103492129175381.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719104043205175382.4757)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('SQL \547D\4EE4')
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719103492129175381.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719104303044175382.4757)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('SQL \547D\4EE4\6A94')
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719103492129175381.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\516C\7528\7A0B\5F0F')
,p_parent_list_item_id=>wwv_flow_api.id(719103492129175381.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719104915398175382.4757)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>unistr('\5168\90E8\516C\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719105254051175382.4757)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719105556872175383.4757)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>unistr('\8CC7\6599\5DE5\4F5C\5BA4')
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719105899675175383.4757)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>unistr('\67E5\8A62\7522\751F\5668')
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713695916716440293.4757)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(671322230212043723.4757)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>unistr('\7BC4\4F8B\8CC7\6599\96C6')
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719106178230175383.4757)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>unistr('\7522\751F DDL')
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719106492099175384.4757)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>unistr('\4F7F\7528\8005\4ECB\9762\9810\8A2D\503C')
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719107910006175384.4757)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>unistr('\7DB1\8981\6BD4\8F03')
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719106738745175384.4757)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\8868\683C\65B9\6CD5')
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719108292576175384.4757)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>unistr('\8CC7\6E90\56DE\6536\7B52')
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719107342427175384.4757)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>unistr('\7269\4EF6\5831\8868')
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719107028410175384.4757)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>unistr('\95DC\65BC\8CC7\6599\5EAB')
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719107689961175384.4757)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>unistr('\8CC7\6599\5EAB\76E3\7763')
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_parent_list_item_id=>wwv_flow_api.id(719104635487175382.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719108571085175384.4757)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('RESTful \670D\52D9')
,p_list_item_link_target=>'f?p=4850:500:&SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(719103492129175381.4757)
,p_security_scheme=>wwv_flow_api.id(404702144894863525)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719108853679175384.4757)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\5718\968A\958B\767C')
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>unistr('\5718\968A\958B\767C\5411\4E0B\5C55\958B\529F\80FD')
,p_list_text_01=>'tab-team-dev'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719109132011175385.4757)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>unistr('\6A19\7C64')
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719108853679175384.4757)
,p_security_scheme=>wwv_flow_api.id(750863634498892275)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719109459789175385.4757)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>unistr('\91CC\7A0B\7891')
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719108853679175384.4757)
,p_security_scheme=>wwv_flow_api.id(750863634498892275)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719109779086175385.4757)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>unistr('\6A23\677F')
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_api.id(719108853679175384.4757)
,p_security_scheme=>wwv_flow_api.id(750863634498892275)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719110005247175385.4757)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>unistr('\516C\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719108853679175384.4757)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719110684924175385.4757)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719108853679175384.4757)
,p_security_scheme=>wwv_flow_api.id(750863634498892275)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719110951891175386.4757)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>unistr('\610F\898B\56DE\994B')
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(719108853679175384.4757)
,p_security_scheme=>wwv_flow_api.id(750863634498892275)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719115154029175388.4757)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\5EAB')
,p_list_item_link_target=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:RP:::'
,p_list_text_01=>'tab-apps'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719115401508175388.4757)
,p_list_item_display_sequence=>405
,p_list_item_link_text=>unistr('\751F\7522\529B\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:PACKAGE:'
,p_parent_list_item_id=>wwv_flow_api.id(719115154029175388.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(765806790177816119.4757)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>unistr('\7BC4\4F8B\61C9\7528\7A0B\5F0F')
,p_list_item_link_target=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:RP,50:P50_APP_GROUP:SAMPLE:'
,p_parent_list_item_id=>wwv_flow_api.id(719115154029175388.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(765807759158824637.4757)
,p_list_item_display_sequence=>415
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(719115154029175388.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(719116059754175389.4757)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:6:::'
,p_parent_list_item_id=>wwv_flow_api.id(719115154029175388.4757)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_apps_homepage_large_icons
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(750862626609892264.4757)
,p_name=>'APEX 5 Apps Homepage Large Icons'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(750865255905892284.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5957\88DD\61C9\7528\7A0B\5F0F\5EAB')
,p_list_item_link_target=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:50:::'
,p_list_item_icon=>'pkg-apps'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(806250634212071966)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(750864917368892284.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5100\8868\677F')
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-dashboards'
,p_security_scheme=>wwv_flow_api.id(806250634212071966)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(750867323547901636.4757)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'pkg-apps-admin'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/install_pkg_app_steps
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(755598782624864560.4757)
,p_name=>'install pkg app steps'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(755598958319864565.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A8D\8B49')
,p_list_item_link_target=>'f?p=&APP_ID.:828:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(755605746913926308.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:83:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apps_admin_manage_service
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(798354195880640621.4757)
,p_name=>'Apps Admin - Manage Service'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(798354314490640626.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\63D0\51FA\670D\52D9\8981\6C42')
,p_list_item_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:100,101,102,103,104:::'
,p_list_item_icon=>'icon-admin-service-request'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_list_text_01=>unistr('\8981\6C42\5B58\53D6\984D\5916\7684\5132\5B58\6216\7D42\6B62\5DE5\4F5C\5340.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(404682514053862570)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(798354600868640627.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8A2D\5B9A\5DE5\4F5C\5340\504F\597D\8A2D\5B9A')
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:22:::'
,p_list_item_icon=>'icon-admin-workspace-preferences'
,p_list_text_01=>unistr('\8A2D\5B9A\63A7\5236\5DE5\4F5C\5340\4E4B\529F\80FD\7684\504F\597D\8A2D\5B9A.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(404682514053862570)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(798354927640640627.4757)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7BA1\7406\4F7F\7528\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:300:::'
,p_list_item_icon=>'icon-apex-user'
,p_list_text_01=>unistr('\63A7\5236 Application Express \5DE5\4F5C\5340\7BA1\7406\54E1\3001\61C9\7528\7A0B\5F0F\958B\767C\4EBA\54E1\4EE5\53CA\4E00\822C\4F7F\7528\8005\7684\5B58\53D6\6B0A.')
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_api.id(1020614257688498212)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apps_admin_manage_interactive_report_settings
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(798364561880730346.4757)
,p_name=>'Apps Admin - Manage Interactive Report Settings'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(798365057920730347.4757)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\9810\5B58\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-saved-reports'
,p_list_text_01=>unistr('\6AA2\8996\53CA\7BA1\7406\5957\88DD\61C9\7528\7A0B\5F0F\4F7F\7528\8005\6240\5EFA\7ACB\7684\9810\5B58\4E92\52D5\5F0F\5831\8868.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(798364738779730346.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A02\95B1')
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-report-subscriptions'
,p_list_text_01=>unistr('\6AA2\8996\53CA\7BA1\7406\5957\88DD\61C9\7528\7A0B\5F0F\4F7F\7528\8005\6240\5EFA\7ACB\7684\4E92\52D5\5F0F\5831\8868\8A02\95B1\9805\76EE.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/users_and_groups_apex_5_0
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(802137241064353033.4757)
,p_name=>'users and groups APEX 5.0'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(802137448713353036.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\4F7F\7528\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'300'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(802137757188353046.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\7FA4\7D44')
,p_list_item_link_target=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'53'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(802138028621353046.4757)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7FA4\7D44\6307\5B9A\9805\76EE')
,p_list_item_link_target=>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.:RP,51:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/request_service_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(805116320497552727.4757)
,p_name=>'Request Service Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(805116571468552728.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8A73\7D30\7684\8868\683C\7A7A\9593\4F7F\7528\72C0\6CC1\5831\8868 (\53EF\80FD\9700\8981\5E7E\79D2\9418\6642\9593)')
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/request_service_train
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(805118624066572072.4757)
,p_name=>'Request Service Train'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(805118852090572072.4757)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>unistr('\6307\5B9A\8981\6C42')
,p_list_item_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'100'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(805119135311572072.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5B9A\7FA9\8981\6C42')
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'101,102'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(805119463661572072.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'104,105'
);
end;
/
prompt --application/shared_components/navigation/lists/user_admin_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(805137189383669602.4757)
,p_name=>'user_admin_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(805137300235669602.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8B8A\66F4\6211\7684\5BC6\78BC')
,p_list_item_link_target=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:24:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(805137509572669602)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(805139777603669606.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\522A\9664\591A\4F4D\4F7F\7528\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.:RIR:::'
,p_security_scheme=>wwv_flow_api.id(404682514053862570)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/app_admin_activity_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(808592810483273051.4757)
,p_name=>'App Admin - Activity Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(815829845963386613.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5957\88DD\61C9\7528\7A0B\5F0F\6D3B\52D5')
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-activity'
,p_list_text_01=>unistr('\5957\88DD\61C9\7528\7A0B\5F0F\6D3B\52D5\7684\6708\884C\4E8B\66C6\6703\6309\65E5\671F\5831\544A\4E0D\540C\7684\4F7F\7528\8005\548C\9801\9762\6AA2\8996\7E3D\8A08.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808593312294273056.4757)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\9801\9762\6AA2\8996')
,p_list_item_link_target=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RP,29:::'
,p_list_item_icon=>'icon-utilities-page-views'
,p_list_text_01=>unistr('\6BCF\500B\9801\9762\6AA2\8996\7684\4E92\52D5\5F0F\5831\8868.  \6AA2\8996\4F7F\7528\8005\3001\7D93\6B77\6642\9593\4EE5\53CA\9801\9762.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808593649251273056.4757)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:RP,30:::'
,p_list_item_icon=>'icon-apex-user'
,p_list_text_01=>unistr('\6309\4F7F\7528\8005\805A\7E3D\7684\9801\9762\6AA2\8996\5831\8868.')
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/admin_tasks
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(808614585475666760.4757)
,p_name=>'admin_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(808614733789666761.4757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\8B8A\66F4\6211\7684\5BC6\78BC')
,p_list_item_link_target=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:24:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_security_scheme=>wwv_flow_api.id(805137509572669602)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(928426032340953.4757)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1794098480405417.4757)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(92005937971572441.4757)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(539923825535132353.4757)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765073051796712055.4757)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831780486249994155.4757)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917695181258940200.4757)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2010925785324119040.4757)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.FLOTLINECHART2'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(404682514053862570.4757)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>unistr('\60A8\6C92\6709\7BA1\7406\61C9\7528\7A0B\5F0F\7684\6388\6B0A')
,p_reference_id=>12511219858301010.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(404690492509862587.4757)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>unistr('\672A\6388\6B0A\60A8\5B58\53D6\300C\5100\8868\677F\300D\8207\300C\76E3\7763\6D3B\52D5\300D.')
,p_reference_id=>786936829326142579.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(404692541807863512.4757)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('\60A8\6C92\6709\4F7F\7528\300CSQL \5DE5\4F5C\5BA4\300D\7684\6388\6B0A')
,p_reference_id=>786516265251697717.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(404693461378863512.4757)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\6B64\5DE5\4F5C\5340\672A\555F\7528\5718\968A\958B\767C')
,p_reference_id=>786516861027697723.4757
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(404702144894863525.4757)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786519856057734816.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(517057690758689585.4757)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>unistr('\672A\555F\7528\300C\7522\751F\5668 SSO\300D')
,p_reference_id=>6738410669854771.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(746087390984722118.4757)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786516029127697713.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(750863029365892273.4757)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786517166823697723.4757
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(750863634498892275.4757)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\60A8\6C92\6709\7DE8\8F2F\61C9\7528\7A0B\5F0F\7684\6388\6B0A')
,p_reference_id=>12480509677812756.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_builder_workspace_authentication
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(805137509572669602.4757)
,p_name=>'APEX Builder Workspace Authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication = ''APEX'';'
,p_error_message=>unistr('\300C\958B\767C\74B0\5883\300D\6B63\5728\4F7F\7528\5916\90E8\300C\8A8D\8B49\300D')
,p_reference_id=>786940505486177571.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(805427695742857816.4757)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650.')
,p_reference_id=>786932326296107981.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apps_only_workspace
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(805549616798538577.4757)
,p_name=>'Apps Only Workspace'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow.apps_only_workspace;'
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650.')
,p_reference_id=>815805295659547960.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(806250634212071966.4757)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('\60A8\6C92\6709\5B89\88DD\300C\5957\88DD\61C9\7528\7A0B\5F0F\300D\7684\6388\6B0A')
,p_reference_id=>786517456817697723.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apps_only_manage_user_access
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(1020614257688498212.4757)
,p_name=>'Apps Only Manage User Access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authorization.is_authorized_developer( p_developer_authorization => ''ADMIN'') and  wwv_flow.apps_only_workspace;'
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650.')
,p_reference_id=>1020612387794480463.4757
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(539940611479132428.4757)
,p_icon_sequence=>10
,p_icon_subtext=>unistr('\767B\51FA')
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>unistr('\767B\51FA')
,p_icon_height=>32
,p_icon_width=>32
,p_icon_height2=>24
,p_icon_width2=>24
,p_nav_entry_is_feedback_yn=>'N'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(110414540190169198.4757)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(234071020630412401.4757)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02);'))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(789451369950334881.4757)
,p_name=>'APPS_ONLY_WORKSPACE'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(805305720618296184.4757)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
,p_item_comment=>'Prints workspace name referenced in page templates'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(805473839925021275.4757)
,p_name=>'F4750_P301_USER_ID'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(801935533242345735.4757)
,p_name=>'LAST_VIEW'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(805306383623314462.4757)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>unistr('\7121\6CD5\904B\7B97\5DE5\4F5C\5340\540D\7A31.')
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(789457530043363220.4757)
,p_computation_sequence=>10
,p_computation_item=>'APPS_ONLY_WORKSPACE'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow.apps_only_workspace then',
'    return ''Y'';',
'else',
'    return ''N'';',
'end if;'))
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/accessibility_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(750872384409975173.4757)
,p_lov_name=>'ACCESSIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(750872384409975173.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(750872651883975174.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\87A2\5E55\52A9\8B80\7A0B\5F0F')
,p_lov_return_value=>'SCREEN_READER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/account_lock_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805398623015787070.4757)
,p_lov_name=>'ACCOUNT_LOCK_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(805398623015787070.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805398984329787071.4757)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9396\5B9A')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805399223273787071.4757)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\89E3\9664\9396\5B9A')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_end_users
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492829526790527241.4757)
,p_lov_name=>'APEX END USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select user_name d, user_name r',
'from wwv_flow_fnd_user u',
'where security_group_id = :flow_security_group_id',
'and not exists (select null',
'                from wwv_flow_developers d',
'                where d.security_group_id = u.security_group_id',
'                and d.userid            = u.user_name',
'                and (instr(d.developer_role,''ADMIN'') > 0',
'                     or instr(d.developer_role,''EDIT'') > 0))',
'and nvl(u.account_locked,''N'') = ''N''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_mult_user_strip_domain
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805346280616446827.4757)
,p_lov_name=>'CREATE.MULT.USER.STRIP.DOMAIN'
,p_lov_query=>'.'||wwv_flow_api.id(805346280616446827.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805346589515446828.4757)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8A2D\5B9A\5B8C\6574\96FB\5B50\90F5\4EF6\5730\5740\7684\4F7F\7528\8005\540D\7A31')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805346868716446830.4757)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6392\9664\4F7F\7528\8005\540D\7A31\7684 @ \7DB2\57DF\90E8\5206')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/developer_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(801895490296261989.4757)
,p_lov_name=>'DEVELOPER TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(801895490296261989.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(801895719161261989.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(801896091470261989.4757)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/expire_user_accounts
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805446669974928665.4757)
,p_lov_name=>'EXPIRE USER ACCOUNTS'
,p_lov_query=>'.'||wwv_flow_api.id(805446669974928665.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805446914472928666.4757)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\555F\7528')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805447209740928666.4757)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\505C\7528')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4350_fnd_group_ids
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(801896378178261989.4757)
,p_lov_name=>'F4350_FND_GROUP_IDS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(group_name) d, id r',
'  from wwv_flow_fnd_user_groups_noapp',
' where security_group_id in (:flow_security_group_id,10)',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_interval
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805284490639012075.4757)
,p_lov_name=>'IR_NOTIFY_INTERVAL'
,p_lov_query=>'.'||wwv_flow_api.id(805284490639012075.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805284794704012075.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6BCF\65E5')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805285009454012075.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6BCF\9031')
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805285318472012075.4757)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6BCF\6708')
,p_lov_return_value=>'M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805215191044829557.4757)
,p_lov_name=>'IR_NOTIFY_STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(805215191044829557.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805215448430829557.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5DF2\9001\51FA')
,p_lov_return_value=>'SUBMITTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805215780495829557.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5DF2\50B3\9001')
,p_lov_return_value=>'SENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805216003045829557.4757)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\932F\8AA4')
,p_lov_return_value=>'ERROR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_report_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805395834107760451.4757)
,p_lov_name=>'IR_REPORT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(805395834107760451.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805396132813760451.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E3B\8981\9810\8A2D\503C')
,p_lov_return_value=>'PRIMARY_DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805396419095760452.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\66FF\4EE3\9810\8A2D\503C')
,p_lov_return_value=>'ALTERNATIVE_DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805396707756760452.4757)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\516C\7528')
,p_lov_return_value=>'PUBLIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805397045712760452.4757)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5C08\7528')
,p_lov_return_value=>'	PRIVATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_user_rpt_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805149229047727280.4757)
,p_lov_name=>'IR_USER_RPT_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(805149229047727280.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805149598764727280.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\516C\7528')
,p_lov_return_value=>'PUBLIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(805149816021727280.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5C08\7528')
,p_lov_return_value=>'PRIVATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(805509014809047810.4757)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(schema) d, schema r',
'',
'from   wwv_flow_company_schemas',
'',
'where  security_group_id = :flow_security_group_id',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p11001_component
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(49858589128480256.4757)
,p_lov_name=>'P11001_COMPONENT'
,p_lov_query=>'.'||wwv_flow_api.id(49858589128480256.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(632592103695134630.4757)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\591A\9762\5411\641C\5C0B')
,p_lov_return_value=>'Faceted Search'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49859193897480260.4757)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\589E\5F37\5373\73FE\5F0F LOV')
,p_lov_return_value=>'Enhanced Popup LOV'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49859564794480260.4757)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\5171\7528\7684 LOV \64F4\5145')
,p_lov_return_value=>'Expanded Shared LOVs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49859901359480260.4757)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\555F\7528 REST \7684\4E92\52D5\5F0F\65B9\683C')
,p_lov_return_value=>'REST Enabled Interactive Grid'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(632592811832140769.4757)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\65B0\5718\968A\958B\767C')
,p_lov_return_value=>'New Team Development'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49858779305480258.4757)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\5EFA\7ACB\61C9\7528\7A0B\5F0F\7CBE\9748')
,p_lov_return_value=>'Create Application Wizard'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49860319574480261.4757)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('Oracle JET \5716\8868')
,p_lov_return_value=>'Oracle JET Charts'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49860715620480261.4757)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('SQL \5DE5\4F5C\5BA4')
,p_lov_return_value=>'SQL Workshop'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49861101819480262.4757)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\901A\7528\4E3B\984C')))
,p_lov_return_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'Universal Theme'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49861512099480262.4757)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\5B89\5168\6027')
,p_lov_return_value=>'Security'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49861946850480262.4757)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\751F\7522\529B\548C\7BC4\4F8B\61C9\7528\7A0B\5F0F')
,p_lov_return_value=>'Packaged Applications'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(49862347729480262.4757)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
unistr('\5176\4ED6')))
,p_lov_return_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'Other'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/p30_view_as
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(818319918283815176.4757)
,p_lov_name=>'P30_VIEW_AS'
,p_lov_query=>'.'||wwv_flow_api.id(818319918283815176.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(818320265337815178.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5716\8868')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(818320554241815181.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5831\8868')
,p_lov_return_value=>'REPORT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p7_pkg_app_tasks
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(931635900643222282.4757)
,p_lov_name=>'P7_PKG_APP_TASKS'
,p_lov_query=>'.'||wwv_flow_api.id(931635900643222282.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(931678677005143844.4757)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\66F4\65B0')
,p_lov_return_value=>'UPDATE'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-pkg-app-install'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications a, wwv_flow_pkg_app_map m',
'where a.app_id = m.app_id',
'and m.security_group_id = :flow_security_group_id',
'and a.app_id = :P7_APP_ID',
'and a.build_version > m.installed_build_version',
'and nvl(m.application_locked,''Y'') = ''Y'''))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(931639477437295149.4757)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>unistr('\8B8A\66F4\8A8D\8B49')
,p_lov_return_value=>'CHANGE_AUTH'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-pkg-app-chg-auth'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications a, wwv_flow_pkg_app_map m',
'where a.app_id = m.app_id',
'and m.security_group_id = :flow_security_group_id',
'and a.app_id = :P7_APP_ID',
'and a.app_type = ''DB'''))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(931636881822222290.4757)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\89E3\9664\9396\5B9A')
,p_lov_return_value=>'UNLOCK'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-pkg-app-unlock'
,p_lov_disp_cond_type=>'FUNCTION_BODY'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_db_app_n_locked boolean := false;',
'begin',
'	for c1 in (select null',
'	           from wwv_flow_pkg_applications a, wwv_flow_pkg_app_map m',
'	           where a.app_id = m.app_id',
'	           and m.security_group_id = :flow_security_group_id',
'	           and a.app_id = :P7_APP_ID',
'	           and a.app_type = ''DB''',
'	           and nvl(m.application_locked,''Y'') = ''Y'')',
'	loop',
'		l_db_app_n_locked := true;',
'	end loop;',
'',
'	if l_db_app_n_locked then',
'		-- unlock available to full workspace with user who has builder access',
'		if not wwv_flow.apps_only_workspace and wwv_flow_authorization.is_authorized_developer (p_developer_authorization => ''EDIT'') then',
'			return true;',
'		end if;',
'	end if;',
'	return false;',
'end;'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(931636596704222290.4757)
,p_lov_disp_sequence=>55
,p_lov_disp_value=>unistr('\79FB\9664')
,p_lov_return_value=>'REMOVE'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-pkg-app-remove'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications a, wwv_flow_pkg_app_map m',
'where a.app_id = m.app_id',
'and m.security_group_id = :flow_security_group_id',
'and a.app_id = :P7_APP_ID'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/packaged_app_auth_option
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(806412552593441624.4757)
,p_lov_name=>'PACKAGED_APP_AUTH_OPTION'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'       name_with_prefix      as r',
'  from wwv_flow_native_plugins',
' where plugin_type = ''AUTHENTICATION TYPE''',
'   and (          name_with_prefix = ''NATIVE_APEX_ACCOUNTS''',
'         or (     name_with_prefix = ''NATIVE_HTTP_HEADER_VARIABLE''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_HHEAD'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_LDAP''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_LDAP'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_IAS_SSO''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_SSO'') = ''Y'' ))',
'union all',
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_CLOUD_IDM''),',
'       ''NATIVE_CLOUD_IDM''',
'  from sys.dual',
' where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/packaged_app_auth_option_pg46
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1446553355204723865.4757)
,p_lov_name=>'PACKAGED_APP_AUTH_OPTION_PG46'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'       name_with_prefix      as r',
'  from wwv_flow_native_plugins',
' where plugin_type = ''AUTHENTICATION TYPE''',
'   and (          name_with_prefix = ''NATIVE_APEX_ACCOUNTS''',
'         or (     name_with_prefix = ''NATIVE_HTTP_HEADER_VARIABLE''',
'              and :P7_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_HHEAD'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_LDAP''',
'              and :P7_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_LDAP'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_IAS_SSO''',
'              and :P7_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_SSO'') = ''Y'' ))',
'union all',
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_CLOUD_IDM''),',
'       ''NATIVE_CLOUD_IDM''',
'  from sys.dual',
' where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pkg_app_filters
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(732467706666833564.4757)
,p_lov_name=>'PKG_APP_FILTERS'
,p_lov_query=>'.'||wwv_flow_api.id(732467706666833564.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(732468018544833566.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(732468465377833567.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\751F\7522\529B')
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(732468825603833568.4757)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\7BC4\4F8B')
,p_lov_return_value=>'SAMPLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(732469239311833568.4757)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\81EA\8A02')
,p_lov_return_value=>'CUSTOM'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flow_pkg_applications where app_group = ''CUSTOM'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(765481466461093464.4757)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5DF2\5B89\88DD')
,p_lov_return_value=>'INSTALLED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pkg_app_new_user
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492829835934527241.4757)
,p_lov_name=>'PKG_APP_NEW_USER'
,p_lov_query=>'.'||wwv_flow_api.id(492829835934527241.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492830130329527242.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5EFA\7ACB Application Express \4F7F\7528\8005')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pkg_app_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1224176768409642192.4757)
,p_lov_name=>'PKG_APP_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(1224176768409642192.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1224177077201642193.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8CC7\6599\5EAB')
,p_lov_return_value=>'DB'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1224177391006642199.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Web \8A66\7B97\8868')
,p_lov_return_value=>'WS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/reqeuest_service
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(801842749107764598.4757)
,p_lov_name=>'REQEUEST SERVICE'
,p_lov_query=>'.'||wwv_flow_api.id(801842749107764598.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(801843300324764602.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_lov_return_value=>'STORAGE'
,p_lov_template=>'#DISPLAY_VALUE#| icon-request-storage'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(801843660323764602.4757)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\8981\6C42\7D42\6B62')
,p_lov_return_value=>'TERMINATION'
,p_lov_template=>'#DISPLAY_VALUE#| icon-request-termination'
);
end;
/
prompt --application/shared_components/user_interface/lovs/timeframe
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(788989098726838748.4757)
,p_lov_name=>'TIMEFRAME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, to_char(t) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5*60 t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15*60 t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 3600 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 2*3600  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3*3600  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4*3600  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6*3600 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8*3600 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12*3600 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 18*3600 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1*24*60*60 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2*24*60*60 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3*24*60*60 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4*24*60*60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5*24*60*60 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 6*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7*24*60*60 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14*24*60*60 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365*24*60*60 t from dual order by 2',
') q'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_app_admin_user_method
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492828601280527238.4757)
,p_lov_name=>'WS_APP_ADMIN_USER_METHOD'
,p_lov_query=>'.'||wwv_flow_api.id(492828601280527238.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492828905310527238.4757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4F7F\7528\73FE\6709\4F7F\7528\8005')
,p_lov_return_value=>'E'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492829287682527240.4757)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5EFA\7ACB\65B0\4F7F\7528\8005')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_or_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(801893675976261985.4757)
,p_lov_name=>'YES_NO_RETURNS_Y_OR_N'
,p_lov_query=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(801893956418261987.4757)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(801894275092261987.4757)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(539941826945132432.4757)
,p_name=>' Breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492870030976684874.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:237:&SESSION.::&DEBUG.:::'
,p_page_id=>237
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492870967641701682.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:83:&SESSION.::&DEBUG.:::'
,p_page_id=>83
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492886054526780174.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\89E3\9664\9396\5B9A App')
,p_link=>'f?p=&APP_ID.:234:&SESSION.::&DEBUG.:::'
,p_page_id=>234
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492897834760858127.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\8B8A\66F4\8A8D\8B49')
,p_link=>'f?p=&APP_ID.:46:&SESSION.::&DEBUG.:::'
,p_page_id=>46
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(492907884020873126.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:262:&SESSION.::&DEBUG.:::'
,p_page_id=>262
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(657001585526112940.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.:::'
,p_page_id=>210
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(798343358044477984.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\61C9\7528\7A0B\5F0F\7BA1\7406')
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(801841660268764588.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\8981\6C42\670D\52D9')
,p_link=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::'
,p_page_id=>100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(801862732676237146.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\7BA1\7406\4F7F\7528\8005')
,p_link=>'f?p=&APP_ID.:300:&SESSION.'
,p_page_id=>300
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(801882533106261969.4757)
,p_parent_id=>wwv_flow_api.id(801862732676237146.4757)
,p_short_name=>unistr('\5EFA\7ACB\4F7F\7528\8005')
,p_link=>'f?p=&APP_ID.:301:&SESSION.'
,p_page_id=>301
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(801914548585279875.4757)
,p_parent_id=>wwv_flow_api.id(801862732676237146.4757)
,p_short_name=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_link=>'f?p=&APP_ID.:302:&SESSION.'
,p_page_id=>302
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(802132173906156777.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\7BA1\7406\9810\5B58\5831\8868')
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805157126884739471.4757)
,p_parent_id=>wwv_flow_api.id(801862732676237146.4757)
,p_short_name=>unistr('\522A\9664\591A\4F4D\4F7F\7528\8005')
,p_link=>'f?p=&APP_ID.:305:&SESSION.'
,p_page_id=>305
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805218510881843962.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\7BA1\7406\8A02\95B1')
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805436491214880000.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\8A2D\5B9A\5DE5\4F5C\5340\504F\597D\8A2D\5B9A')
,p_link=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::'
,p_page_id=>22
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805495463822047787.4757)
,p_parent_id=>wwv_flow_api.id(801862732676237146.4757)
,p_short_name=>unistr('\7DE8\8F2F\4F7F\7528\8005')
,p_link=>'f?p=&APP_ID.:306:&SESSION.'
,p_page_id=>306
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805527573061252965.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_link=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::'
,p_page_id=>101
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805527784325261035.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_link=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.:::'
,p_page_id=>104
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805528069374265591.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\8981\6C42\7D42\6B62\670D\52D9')
,p_link=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.:::'
,p_page_id=>102
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(805528699371274068.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\8981\6C42\7D42\6B62\670D\52D9')
,p_link=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:::'
,p_page_id=>105
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(806256027000082685.4757)
,p_parent_id=>wwv_flow_api.id(.4757)
,p_short_name=>unistr('<span class="u-VisuallyHidden">\61C9\7528\7A0B\5F0F</span><span class="a-Icon icon-breadcrumb-previous" title="\61C9\7528\7A0B\5F0F"></span>')
,p_link=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:::'
,p_page_id=>50
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(806264496767109365.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\61C9\7528\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:81:&SESSION.::&DEBUG.:::'
,p_page_id=>81
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(806412249977441620.4757)
,p_parent_id=>wwv_flow_api.id(806256027000082685.4757)
,p_short_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:828:&SESSION.::&DEBUG.:::'
,p_page_id=>828
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(815830255443389334.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\61C9\7528\7A0B\5F0F\6D3B\52D5')
,p_link=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::'
,p_page_id=>27
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(818291039720192108.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\9801\9762\6AA2\8996')
,p_link=>'f?p=&APP_ID.:29:&SESSION.'
,p_page_id=>29
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(818309602620781722.4757)
,p_parent_id=>wwv_flow_api.id(798343358044477984.4757)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_link=>'f?p=&APP_ID.:30:&SESSION.'
,p_page_id=>30
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(740687851443061408.4757)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Dialog.zh-tw'
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(741365982136994250.4757)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Dialog.zh-tw'
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(741366253443994295.4757)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Edit Screen.zh-tw'
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770.4757
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159383727979557769.4757)
,p_page_template_id=>wwv_flow_api.id(741366253443994295.4757)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159384215152557769.4757)
,p_page_template_id=>wwv_flow_api.id(741366253443994295.4757)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(741368521013994306.4757)
,p_theme_id=>3
,p_name=>'APEX 5.0 - No Side Bar.zh-tw'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(741369094170994311.4757)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Right Side Bar.zh-tw'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222.4757
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159388197690557772.4757)
,p_page_template_id=>wwv_flow_api.id(741369094170994311.4757)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159388693002557772.4757)
,p_page_template_id=>wwv_flow_api.id(741369094170994311.4757)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159389182341557773.4757)
,p_page_template_id=>wwv_flow_api.id(741369094170994311.4757)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159389650711557773.4757)
,p_page_template_id=>wwv_flow_api.id(741369094170994311.4757)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159390101350557773.4757)
,p_page_template_id=>wwv_flow_api.id(741369094170994311.4757)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159390691860557773.4757)
,p_page_template_id=>wwv_flow_api.id(741369094170994311.4757)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(159391143887557774.4757)
,p_page_template_id=>wwv_flow_api.id(741369094170994311.4757)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_sign_up_wizard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(741370435290994312.4757)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Sign Up Wizard.zh-tw'
,p_internal_name=>'APEX_5.0_SIGN_UP_WIZARD'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--simpleWizard" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'<div class="u-Layout u-Layout--centerVertically">',
'  #BODY#',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702692008314080052.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(741371098457994312.4757)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Wizard Page.zh-tw'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(404710483554908976.4757)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4757
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(404710812892908978.4757)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4757
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(404711161197908978.4757)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4757
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_large
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(510958289243179645.4757)
,p_template_name=>'APEX 5.0 - Button (Large)'
,p_internal_name=>'APEX_5.0_BUTTON_LARGE'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--large a-Button--hot #BUTTON_CSS_CLASSES#" type="button" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174756119980565636.4757
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_small
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(510958400671179662.4757)
,p_template_name=>'APEX 5.0 - Button (Small)'
,p_internal_name=>'APEX_5.0_BUTTON_SMALL'
,p_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" class="a-Button a-Button--small a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174755910284562884.4757
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(758581488338548971.4757)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233.4757
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(404667570222803088.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region'
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587.4757
,p_translate_this_template=>'N'
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(404672496027804677.4757)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Div with ID, Class, and Region Attributes'
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>716895227337398760.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(662132465401686364.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h1><a href="javascript:void(0);" onclick="$(''##REGION_STATIC_ID#_content'').slideToggle();$(''##REGION_STATIC_ID#_img'').toggleClass(''expanded'');" class="hideShowLink"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideShow" alt="" id="#REGION_STATIC'
||'_ID#_img"/>#TITLE#</a></h1>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Body (Hide/Show)'
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(740735067061086300.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(740771588500180474.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Region'
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(746534672114889110.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_header
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(805131422007607886.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardHeader" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Wizard Header'
,p_internal_name=>'APEX_5.0_WIZARD_HEADER'
,p_theme_id=>3
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210710875242480.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(805132117516607920.4757)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>'APEX 5.0 - Wizard Title Region'
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(805538978589340502.4757)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(805699740467941340.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'      <button class="a-Button a-Button--icon a-Button--hideShow" type="button"></button>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Hide + Show Region'
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_processing_spinner_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1164683681838385745.4757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ProcessingRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <span class="u-Processing"><span class="u-Processing-spinner"></span></span>',
'  <div class="a-ProcessingRegion-title">#TITLE#</div>',
'  <div class="a-ProcessingRegion-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Processing Spinner Region'
,p_internal_name=>'APEX_5.0_PROCESSING_SPINNER_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1147280303078953726.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(404660636766798903.4757)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(404660915136798904.4757)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(750892319717997379.4757)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508.4757
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(755602131069880061.4757)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(798348984564602568.4757)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(805146703039709510.4757)
,p_list_template_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_noncurrent=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_list_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>3
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="a-LinksList-item is-current #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#'
||'</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="a-LinksList-item#A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="a-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a><'
||'/li>'
,p_item_templ_curr_w_child=>'<li class="a-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="a-LinksList-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksList-label">#TEXT#</span><span class="a-LinksList-'
||'badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="a-LinksList-item #A03#"><a href="#LINK#" class="a-LinksLisa-link" #A02#><span class="a-LinksList-icon"><span class="t-Icon #IMAGE#"></span></span><span class="a-LinksLisa-label">#TEXT#</span><span class="a-LinksList-badge">#A01#</span></a>'
||'</li>'
,p_reference_id=>60219508156141083.4757
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(741378333819007312.4757)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(741383139242007378.4757)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>6
,p_reference_id=>689060248369886348.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(741383847997007380.4757)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846.4757
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(741383847997007380.4757)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(741385154282007399.4757)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4757
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(741385154282007399.4757)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805120647160580956.4757)
,p_row_template_name=>'APEX 5.0 - Portlet  Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805120945120580960.4757)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>46763700145123930.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_one_column_unordered_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(805706496589034856.4757)
,p_row_template_name=>'APEX 5.0 - One Column Unordered List'
,p_internal_name=>'APEX_5.0_ONE_COLUMN_UNORDERED_LIST'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_after_column_heading=>'<tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>123725814882271159.4757
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(805706496589034856.4757)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_app_cards_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(932270054883616955.4757)
,p_row_template_name=>'APEX 5.0 - App Cards Report'
,p_internal_name=>'APEX_5.0_APP_CARDS_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AppCards-item #ID#">',
'  <div class="a-AppCards-itemContainer">',
'    <div class="a-AppCards-iconContainer">',
'      <span class="a-AppCards-icon #ICON_CLASS#"></span>',
'    </div>',
'    <div class="a-AppCards-contentContainer" id="#ID#_name">',
'      <h2 class="a-AppCards-name">#APP_NAME#</h2>',
'      <div class="a-AppCards-info">#APP_INFO#</div>',
'    </div>',
'    <div class="a-AppCards-actionsContainer">',
'        #MODIFY_APP_BUTTON#',
'        #RUN_APP_BUTTON#',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_condition1=>':CARD_LINK is null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AppCards-item #ID#">',
'  <div class="a-AppCards-itemContainer">',
'    <a href="#CARD_LINK#" class="a-AppCards-link">',
'      <div class="a-AppCards-iconContainer">',
'        <span class="a-AppCards-icon #ICON_CLASS#"></span>',
'      </div>',
'      <div class="a-AppCards-contentContainer" id="#ID#_name">',
'        <h2 class="a-AppCards-name">#APP_NAME#</h2>',
'        <div class="a-AppCards-info">#APP_INFO#</div>',
'      </div>',
'    </a>',
'  </div>',
'</li>'))
,p_row_template_condition2=>':CARD_LINK is not null'
,p_row_template_before_rows=>'<ul class="a-AppCards #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>3
,p_theme_class_id=>7
,p_reference_id=>932268343459577530.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(741012333966774170.4757)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span cl'
||'ass="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span></button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>692681574974429799.4757
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(741376158824001765.4757)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487444299516703815.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(741376298358001771.4757)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492676964457041934.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(741376307162001773.4757)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>487443659585685414.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(741376417814001773.4757)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>492677038682043223.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(750871254241940005.4757)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1212080564184792020.4757)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>687907221148719616.4757
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(404662212565801043.4757)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(539940326974132424.4757)
,p_page_name=>'winlov'
,p_page_title=>unistr('\641C\5C0B\5C0D\8A71\65B9\584A')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>unistr('\641C\5C0B')
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>unistr('\95DC\9589')
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>unistr('\4E0B\4E00\6B65 &gt;')
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>unistr('&lt; \4E0A\4E00\6B65')
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>unistr('<div class="a-PopupLOV-pagination">\8CC7\6599\5217 #FIRST_ROW# - #LAST_ROW#</div>')
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>17343114994581872.4757
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/default_calander
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(539940232021132423.4757)
,p_cal_template_name=>'Default Calander'
,p_internal_name=>'DEFAULT_CALANDER'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
,p_reference_id=>353925314576528967.4757
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(72333757135541211.4757)
,p_theme_id=>3
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(607578911660270943.4757)
,p_theme_id=>3
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(697253623117708869.4757)
,p_theme_id=>3
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698708764949187835.4757)
,p_theme_id=>3
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698709451036187835.4757)
,p_theme_id=>3
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698710164448187835.4757)
,p_theme_id=>3
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(698711710498187841.4757)
,p_theme_id=>3
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(740735413933086306.4757)
,p_theme_id=>3
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(740735719132086313.4757)
,p_theme_id=>3
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(740736131546086315.4757)
,p_theme_id=>3
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741378782415007354.4757)
,p_theme_id=>3
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(741379667978007374.4757)
,p_theme_id=>3
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746441836569425940.4757)
,p_theme_id=>3
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746443190371425941.4757)
,p_theme_id=>3
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746443452881425941.4757)
,p_theme_id=>3
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746443757575425941.4757)
,p_theme_id=>3
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746444836374425941.4757)
,p_theme_id=>3
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746445145634425941.4757)
,p_theme_id=>3
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746445421077425942.4757)
,p_theme_id=>3
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746445725296425945.4757)
,p_theme_id=>3
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746446077015425945.4757)
,p_theme_id=>3
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746446530805425946.4757)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746446884162425946.4757)
,p_theme_id=>3
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746535083802889112.4757)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(746535358980889115.4757)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750899131263089224.4757)
,p_theme_id=>3
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(750899683273089226.4757)
,p_theme_id=>3
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(798349340561602593.4757)
,p_theme_id=>3
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747463006528132175.4757)
,p_theme_id=>3
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(746445725296425945)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747463277324132175.4757)
,p_theme_id=>3
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_api.id(746446077015425945)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747463446233132175.4757)
,p_theme_id=>3
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746446530805425946)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747463631373132175.4757)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_api.id(746445421077425942)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747463892204132175.4757)
,p_theme_id=>3
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_api.id(746445725296425945)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747464099568132175.4757)
,p_theme_id=>3
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_api.id(746446077015425945)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747464257097132175.4757)
,p_theme_id=>3
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_api.id(746443757575425941)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747464408083132175.4757)
,p_theme_id=>3
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(746443757575425941)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747464690649132175.4757)
,p_theme_id=>3
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_api.id(746443757575425941)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747464847493132175.4757)
,p_theme_id=>3
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_api.id(746446884162425946)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747464983019132175.4757)
,p_theme_id=>3
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747465129834132176.4757)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_api.id(746445421077425942)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747465242839132176.4757)
,p_theme_id=>3
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747465484278132176.4757)
,p_theme_id=>3
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_api.id(746443452881425941)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747465645644132176.4757)
,p_theme_id=>3
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_api.id(746443452881425941)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747465815587132176.4757)
,p_theme_id=>3
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(746445145634425941)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747466092646132176.4757)
,p_theme_id=>3
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(746443190371425941)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747466208356132176.4757)
,p_theme_id=>3
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_api.id(746444836374425941)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747466360014132176.4757)
,p_theme_id=>3
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747466555388132176.4757)
,p_theme_id=>3
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_api.id(746443452881425941)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747466798216132176.4757)
,p_theme_id=>3
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_api.id(746443452881425941)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747466963230132176.4757)
,p_theme_id=>3
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_api.id(746441836569425940)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747467175674132176.4757)
,p_theme_id=>3
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_api.id(746441836569425940)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747467399810132176.4757)
,p_theme_id=>3
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_api.id(746441836569425940)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747467514327132177.4757)
,p_theme_id=>3
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_api.id(746441836569425940)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747467776225132177.4757)
,p_theme_id=>3
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_api.id(746441836569425940)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747467997690132177.4757)
,p_theme_id=>3
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_api.id(746441836569425940)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747473828460136685.4757)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747473950983136685.4757)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747474127360136685.4757)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(746535083802889112)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747474348131136685.4757)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(746535083802889112)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747474514470136685.4757)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(746535083802889112)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747474707581136685.4757)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(746535358980889115)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747474944578136686.4757)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(746535358980889115)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747475015417136686.4757)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747475237721136686.4757)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(746534672114889110.4757)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(746535083802889112)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747475664720136688.4757)
,p_theme_id=>3
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747475812078136688.4757)
,p_theme_id=>3
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(740736131546086315)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747476008148136688.4757)
,p_theme_id=>3
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(740736131546086315)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747476278021136688.4757)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(740735719132086313)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747476495301136688.4757)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(740735719132086313)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747476598371136688.4757)
,p_theme_id=>3
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747476784777136688.4757)
,p_theme_id=>3
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_api.id(740735413933086306)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747476963807136688.4757)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(740735067061086300.4757)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_api.id(740735413933086306)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747478061061136695.4757)
,p_theme_id=>3
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747478236458136695.4757)
,p_theme_id=>3
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747478465916136695.4757)
,p_theme_id=>3
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747478620563136695.4757)
,p_theme_id=>3
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_api.id(741379667978007374)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747478816770136695.4757)
,p_theme_id=>3
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(741379667978007374)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747479061860136695.4757)
,p_theme_id=>3
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_api.id(741379667978007374)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747479231007136697.4757)
,p_theme_id=>3
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(741379667978007374)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747479414686136697.4757)
,p_theme_id=>3
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(741379667978007374)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747479631087136697.4757)
,p_theme_id=>3
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747479882130136697.4757)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747480030416136697.4757)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747480265456136697.4757)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(747480483547136697.4757)
,p_theme_id=>3
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741378333819007312.4757)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(741378782415007354)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787127352847949731.4757)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741385154282007399.4757)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(698708764949187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787127585732949731.4757)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741385154282007399.4757)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698709451036187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787127711546949731.4757)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741385154282007399.4757)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698710164448187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787127972338949731.4757)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741385154282007399.4757)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698710164448187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787128199893949731.4757)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741385154282007399.4757)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698710164448187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787128259567949731.4757)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741385154282007399.4757)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(787128429850949731.4757)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741385154282007399.4757)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698711710498187841)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798350813694602633.4757)
,p_theme_id=>3
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(798349340561602593)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798351014569602633.4757)
,p_theme_id=>3
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(798349340561602593)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798351220332602633.4757)
,p_theme_id=>3
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(798349340561602593)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798351489652602634.4757)
,p_theme_id=>3
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(798349340561602593)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798351687944602634.4757)
,p_theme_id=>3
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(798349340561602593)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798351753474602634.4757)
,p_theme_id=>3
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798351813649602634.4757)
,p_theme_id=>3
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798351937390602634.4757)
,p_theme_id=>3
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798352054616602634.4757)
,p_theme_id=>3
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(798352116411602634.4757)
,p_theme_id=>3
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(805706717271034862.4757)
,p_theme_id=>3
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805706496589034856.4757)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(698708764949187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(805706847390034864.4757)
,p_theme_id=>3
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805706496589034856.4757)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(698709451036187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(805706992942034864.4757)
,p_theme_id=>3
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805706496589034856.4757)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(698710164448187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(805707090166034864.4757)
,p_theme_id=>3
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805706496589034856.4757)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(805707148450034864.4757)
,p_theme_id=>3
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805706496589034856.4757)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_api.id(698710164448187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(805707237455034864.4757)
,p_theme_id=>3
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805706496589034856.4757)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_api.id(698711710498187841)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(805707357730034864.4757)
,p_theme_id=>3
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(805706496589034856.4757)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(698710164448187835)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926400418677707541.4757)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(404660915136798904.4757)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926400594637707541.4757)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(404660915136798904.4757)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(940695744751341570.4757)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1199562503035032434.4757)
,p_theme_id=>3
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(746446530805425946)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1241666929781396960.4757)
,p_theme_id=>3
,p_name=>'USED_IN_DIALOG'
,p_display_name=>'Used in Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1164683681838385745.4757)
,p_css_classes=>'a-ProcessingRegion--dialog'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525662345070182113.4757)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525662481640182113.4757)
,p_theme_id=>3
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525662510081182113.4757)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525662661993182113.4757)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525662869499182113.4757)
,p_theme_id=>3
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(697253623117708869)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525663077488182113.4757)
,p_theme_id=>3
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(697253623117708869)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544819964749478035.4757)
,p_theme_id=>3
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741383847997007380.4757)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544820012780478035.4757)
,p_theme_id=>3
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741383847997007380.4757)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1544820102363478035.4757)
,p_theme_id=>3
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(741383847997007380.4757)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554817344758408390.4757)
,p_theme_id=>3
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(740735413933086306)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554817556033408390.4757)
,p_theme_id=>3
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_api.id(740735413933086306)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554817788346408390.4757)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(740735719132086313)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554817927221408390.4757)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(740735719132086313)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554818142196408390.4757)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750899131263089224)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554818375607408390.4757)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(740736131546086315)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554818564149408390.4757)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750899683273089226)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554818775823408390.4757)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750899683273089226)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554818958443408390.4757)
,p_theme_id=>3
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_api.id(740735719132086313)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554819000019408390.4757)
,p_theme_id=>3
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554819282202408390.4757)
,p_theme_id=>3
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(404667570222803088.4757)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_api.id(740736131546086315)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554830602794526786.4757)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(805538978589340502.4757)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554830783243526786.4757)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805538978589340502.4757)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554830803540526786.4757)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805538978589340502.4757)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554836989856542249.4757)
,p_theme_id=>3
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554837048702542249.4757)
,p_theme_id=>3
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554837210657542249.4757)
,p_theme_id=>3
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_api.id(740735719132086313)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554837432873542249.4757)
,p_theme_id=>3
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_api.id(740735719132086313)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554837628193542249.4757)
,p_theme_id=>3
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_api.id(750899131263089224)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554837892538542249.4757)
,p_theme_id=>3
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_api.id(740736131546086315)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554838070925542250.4757)
,p_theme_id=>3
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_api.id(750899683273089226)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554838282191542250.4757)
,p_theme_id=>3
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_api.id(750899683273089226)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554838444739542251.4757)
,p_theme_id=>3
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(746535358980889115)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554838651314542251.4757)
,p_theme_id=>3
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(805699740467941340.4757)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(746535358980889115)
,p_template_types=>'REGION'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(693462664348655994.4757)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(539943211297143567.4757)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040.4757
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(118599641342932798.4757)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>unistr('INTERNAL \793E\7FA4\767B\5165')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118599810078932799.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118601790657932801.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118600266087932800.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118600756213932800.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(118601249611932801.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118602285176932801.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118602644797932801.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118603087505932801.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118603441760932801.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(118599810078932799.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118603843637932802.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Application Express automatically adds the "openid" scope. The authent'
||'ication provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118604239098932802.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118604619207932802.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(118605005878932802.4757)
,p_plugin_id=>wwv_flow_api.id(118599641342932798.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(404682856933862574.4757)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('\958B\767C\4EBA\54E1\6388\6B0A')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(786917664404512895.4757)
,p_plugin_id=>wwv_flow_api.id(404682856933862574.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786918050520512895.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786918529213512895.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786919007037512895.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786919500675512895.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786920021088512896.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786920500573512897.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786921046133512897.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786921504189512899.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786922057592512900.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786922519973512900.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786923007253512901.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(786923552272512901.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(786917664404512895.4757)
,p_display_sequence=>120
,p_display_value=>'PKG_APPS: Ability to install packaged applications'
,p_return_value=>'PKG_APPS'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_plugin_dynamic_attribute
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(499279834326550209.4757)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_display_name=>unistr('Plug-In \52D5\614B\5C6C\6027')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_plugin_attribute'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_plugin_attribute'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:SOURCE'
,p_substitute_attributes=>true
,p_reference_id=>6480508142096556.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(760226818503948428.4757)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>unistr('INTERNAL Application Express \5E33\6236')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(760229135394948431.4757)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNAL Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(760232319702948435.4757)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>unistr('INTERNAL \8CC7\6599\5EAB\5E33\6236')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(760287411454948485.4757)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>unistr('INTERNAL HTTP \6A19\982D\8B8A\6578')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760287640967948485.4757)
,p_plugin_id=>wwv_flow_api.id(760287411454948485.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760288013514948486.4757)
,p_plugin_id=>wwv_flow_api.id(760287411454948485.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760288416604948486.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760288013514948486.4757)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760288913478948486.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760288013514948486.4757)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760289423625948487.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760288013514948486.4757)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760289933508948487.4757)
,p_plugin_id=>wwv_flow_api.id(760287411454948485.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(760288013514948486.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>',
'<p>',
'<h3>Example:</h3>',
'<pre>http://sso.mycompany.com/?success=#CALLBACK#</pre>',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760290335785948487.4757)
,p_plugin_id=>wwv_flow_api.id(760287411454948485.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(760288013514948486.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760290725567948487.4757)
,p_plugin_id=>wwv_flow_api.id(760287411454948485.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(760288013514948486.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'BUILTIN_URL,URL'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760291117778948488.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760290725567948487.4757)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760291619641948488.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760290725567948487.4757)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760292139060948488.4757)
,p_plugin_id=>wwv_flow_api.id(760287411454948485.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(760360526050948543.4757)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>unistr('INTERNAL LDAP \76EE\9304')
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528.4757
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F38\5165\7528\65BC\8A8D\8B49\767B\5165\9801\9762\4E2D\4E4B LDAP \76EE\9304\7684\4F7F\7528\8005\540D\7A31\548C\5BC6\78BC. \8ACB\6CE8\610F, \5BC6\78BC\53EF\80FD\5340\5206\5927\5C0F\5BEB.</p>'),
''))
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760360721990948543.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760361111417948543.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760361533802948544.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760361938927948544.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760361533802948544.4757)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760362419420948544.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760361533802948544.4757)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760362933267948544.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760361533802948544.4757)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760363417836948545.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760363827848948545.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760364216062948545.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(760363827848948545.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760364637771948545.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(760365024887948545.4757)
,p_plugin_id=>wwv_flow_api.id(760360526050948543.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760365437846948545.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760365024887948545.4757)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760365918613948546.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760365024887948545.4757)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(760366434328948546.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(760365024887948545.4757)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(760375920088948554.4757)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNAL Oracle Application Server Single Sign-On'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859.4757
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_wizard_selection
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(931633487189212464.4757)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.WIZARD_SELECTION'
,p_display_name=>unistr('\9078\64C7\7CBE\9748')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.WIZARD_SELECTION'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_wizard_selection'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_wizard_selection'
,p_standard_attributes=>'VISIBLE:SESSION_STATE:SOURCE:ELEMENT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_reference_id=>3260301366184169092.4757
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(931633787892213491.4757)
,p_plugin_id=>wwv_flow_api.id(931633487189212464.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Size'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'S'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(931634195040213494.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(931633787892213491.4757)
,p_display_sequence=>10
,p_display_value=>'Small'
,p_return_value=>'S'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(931634625437213498.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(931633787892213491.4757)
,p_display_sequence=>20
,p_display_value=>'Medium'
,p_return_value=>'M'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(931635198372213498.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(931633787892213491.4757)
,p_display_sequence=>30
,p_display_value=>'Large'
,p_return_value=>'L'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(931635685556213498.4757)
,p_plugin_id=>wwv_flow_api.id(931633487189212464.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Submit Page'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
,p_help_text=>'Select whether or not to submit the page when making a selection'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(845155986163834531.4757)
,p_plugin_id=>wwv_flow_api.id(931633487189212464.4757)
,p_name=>'LOV'
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2448359566117403168.4757)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>unistr('\65B0\589E\5168\90E8\52FE\9078\6838\53D6\65B9\584A')
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4757
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\300C\65B0\589E\5168\90E8\52FE\9078\6838\53D6\65B9\584A\300D\52D5\614B\52D5\4F5C\6703\5C07\542B\6709 #CHECK_ALL_CHECKBOX# \5B57\4E32\7684\8CC7\6599\6B04\6A19\984C\5448\73FE\70BA\53EF\5B58\53D6\7684\5168\90E8\52FE\9078\6A23\5F0F\6838\53D6\65B9\584A, \800C\6B64\6838\53D6\65B9\584A\6703\52FE\9078\548C\53D6\6D88\52FE\9078\5176\5C0D\61C9\8CC7\6599\6B04\4E2D\7684\6240\6709\6838\53D6\65B9\584A.<p>'),
'<p>',
unistr('\82E5\8981\4F7F\7528\6B64 Plug-in, \8ACB\78BA\5B9A\5DF2\8A2D\5B9A\4E0B\5217\5C6C\6027:'),
'<ol>',
unistr('<li>\5728\5831\8868\8CC7\6599\6B04\4E2D, \5C07 ''#CHECK_ALL_CHECKBOX#'' \5B9A\7FA9\70BA\300C\6A19\984C\300D\503C.</li>'),
unistr('<li>\5728\300C\52D5\614B\52D5\4F5C - \6642\6A5F\300D\5C6C\6027\4E2D, \9078\53D6\542B\6709\8CC7\6599\6B04\7684\5831\8868\5340\57DF.</li>'),
unistr('<li>\5B9A\7FA9\300C\52D5\614B\52D5\4F5C\300D\4EE5\89F8\767C\300C\91CD\65B0\6574\7406\5F8C\300D, \4EE5\53CA\300C\8F09\5165\9801\9762\6642\89F8\767C\300D\7684\52D5\4F5C (\5982\679C\900F\904E\9078\53D6\300C\9801\9762\8A2D\8A08\5DE5\5177\300D\4E4B\300C\5448\73FE\300D\5340\6BB5\4E2D\7684\5340\57DF\4E26\5F9E\9019\88E1\5EFA\7ACB\300C\52D5\614B\52D5\4F5C\300D\4F86\5EFA\7ACB\300C\52D5\614B\52D5\4F5C\300D, \5247\5169\8005\9810\8A2D\90FD\9069\7528).</li>'),
unistr('<li>\9019\4E0D\6703\8655\7406\6BCF\500B\8CC7\6599\5217\4E0A\5448\73FE\7684\6838\53D6\65B9\584A\7684\8F14\52A9\529F\80FD, \800C\4E14\5FC5\9808\5206\5225\5728\5340\57DF\4F86\6E90\4E2D\9032\884C (\5982\9700\7BC4\4F8B, \8ACB\53C3\95B1 4000:656\300C\5340\57DF\300D\5340\57DF).</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_html5_bar_chart
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.HTML5_BAR_CHART'
,p_display_name=>unistr('HTML 5 \9577\689D\5716 ***')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.HTML5_BAR_CHART'),'#IMAGE_PREFIX#plugins/com.oracle.apex.html5_bar_chart/1.0/')
,p_javascript_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.js'
,p_css_file_urls=>'#PLUGIN_FILES#com_oracle_apex_html5_bar_chart.css'
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'FUNCTION RENDER (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN,',
'    P_IS_PRINTER_FRIENDLY IN BOOLEAN',
') RETURN APEX_PLUGIN.T_REGION_RENDER_RESULT IS',
'BEGIN',
'    sys.HTP.PRN(''<div id="''||APEX_ESCAPE.HTML_ATTRIBUTE(P_REGION.STATIC_ID)||''_chart" class="hbc">'');',
'    sys.HTP.PRN(''</div>'');',
'    ',
'    APEX_JAVASCRIPT.ADD_ONLOAD_CODE (',
'        P_CODE => ''com_oracle_apex_html5_bar_chart(''||',
'            APEX_JAVASCRIPT.ADD_VALUE(P_REGION.STATIC_ID)||',
'            ''{''||',
'                -- Why is this attribute needed if is not used?',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''pageItems'', ',
'                    APEX_PLUGIN_UTIL.PAGE_ITEM_NAMES_TO_JQUERY(P_REGION.AJAX_ITEMS_TO_SUBMIT)',
'                )||',
'                APEX_JAVASCRIPT.ADD_ATTRIBUTE(',
'                    ''ajaxIdentifier'', ',
'                    APEX_PLUGIN.GET_AJAX_IDENTIFIER, ',
'                    FALSE, ',
'                    FALSE',
'                )||',
'            ''}''||',
'        '');''',
'    );',
'    ',
'    RETURN NULL;',
'END RENDER;',
'',
'FUNCTION AJAX (',
'    P_REGION IN APEX_PLUGIN.T_REGION,',
'    P_PLUGIN IN APEX_PLUGIN.T_PLUGIN',
') RETURN APEX_PLUGIN.T_REGION_AJAX_RESULT IS',
'    -- Map region attributes to function constants',
'    -- MODERN, CLASSIC',
'    C_CHART_TYPE CONSTANT VARCHAR2(7) := P_REGION.ATTRIBUTE_15;',
'    -- MODERN, MODERN_2, SOLAR, METRO, CUSTOM, COLUMN',
'    C_COLOR_SCHEME CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_17;',
'    C_CUSTOM_CHART_COLORS CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_10;',
'    C_COLOR_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_19;',
'    -- NONE, IMAGE, ICON, INITIALS',
'    C_ICON_TYPE CONSTANT VARCHAR2(8) := case when C_CHART_TYPE = ''ICON'' then P_REGION.ATTRIBUTE_01 end;',
'    C_LABEL_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_02;',
'    C_LABEL_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_03;',
'    C_VALUE_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_04;',
'    C_VALUE_LINK CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_05;',
'    -- ABOVE, AROUND',
'    C_TEXT_POSITION VARCHAR2(6) := P_REGION.ATTRIBUTE_18;',
'    C_CHART_CSS_CLASSES CONSTANT VARCHAR2(32767) := P_REGION.ATTRIBUTE_06;',
'    C_IMAGE_URL CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_07;',
'    C_CSS_ICON_CLASS_NAME CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_08;',
'    C_INITIALS_COLUMN CONSTANT VARCHAR2(255) := P_REGION.ATTRIBUTE_09;',
'    -- ABSOLUTE, RELATIVE',
'    C_BAR_WIDTH_CALCULATION CONSTANT VARCHAR2(8) := P_REGION.ATTRIBUTE_16;',
'    C_DISPLAY CONSTANT VARCHAR2(19) := P_REGION.ATTRIBUTE_11;',
'    C_PREFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_12;',
'    C_POSTFIX_FOR_VALUE CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_13;',
'    C_MAXIMUM_ROWS CONSTANT NUMBER := P_REGION.ATTRIBUTE_14;',
'    C_MESSAGE_WHEN_NO_DATA_FOUND CONSTANT VARCHAR2(4000) := P_REGION.ATTRIBUTE_20;',
'    ',
'    L_COLOR_COLUMN_NUMBER PLS_INTEGER;',
'    L_LABEL_COLUMN_NUMBER PLS_INTEGER;',
'    L_VALUE_COLUMN_NUMBER PLS_INTEGER;',
'    L_INITIALS_COLUMN_NUMBER PLS_INTEGER;',
'    ',
'    L_COLUMN_VALUE_LIST APEX_PLUGIN_UTIL.T_COLUMN_VALUE_LIST2;',
'    ',
'    L_COLOR VARCHAR2(4000) := NULL;',
'    L_LABEL VARCHAR2(4000) := NULL;',
'    L_LABEL_LINK VARCHAR2(4000) := NULL;',
'    L_VALUE VARCHAR2(4000) := NULL;',
'    L_VALUE_LINK VARCHAR2(4000) := NULL;',
'    L_IMAGE_URL VARCHAR2(4000) := NULL;',
'    L_CSS_ICON_CLASS_NAME VARCHAR2(4000) := NULL;',
'    L_INITIALS VARCHAR2(4000) := NULL;',
'    L_MESSAGE_WHEN_NO_DATA_FOUND VARCHAR2(4000) := NULL;',
'',
'    L_CUSTOM_CHART_COLORS_TABLE APEX_APPLICATION_GLOBAL.VC_ARR2;',
'    L_CUSTOM_CHART_COLORS VARCHAR2(32767) := NULL;',
'BEGIN',
'    L_COLUMN_VALUE_LIST := APEX_PLUGIN_UTIL.GET_DATA2(',
'        P_SQL_STATEMENT  => P_REGION.SOURCE,',
'        P_MIN_COLUMNS    => 1,',
'        P_MAX_COLUMNS    => NULL,',
'        P_COMPONENT_NAME => P_REGION.NAME,',
'        P_MAX_ROWS => C_MAXIMUM_ROWS',
'    );',
'',
'    L_COLOR_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Color Column'',',
'        P_COLUMN_ALIAS      => C_COLOR_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => C_COLOR_SCHEME = ''COLUMN'',',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_LABEL_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Label Column'',',
'        P_COLUMN_ALIAS      => C_LABEL_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    L_VALUE_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'        P_ATTRIBUTE_LABEL   => ''Value Column'',',
'        P_COLUMN_ALIAS      => C_VALUE_COLUMN,',
'        P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'        P_IS_REQUIRED       => TRUE,',
'        P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'    );',
'    if C_ICON_TYPE = ''INITIALS'' then',
'        L_INITIALS_COLUMN_NUMBER := APEX_PLUGIN_UTIL.GET_COLUMN_NO (',
'            P_ATTRIBUTE_LABEL   => ''Initials Column'',',
'            P_COLUMN_ALIAS      => C_INITIALS_COLUMN,',
'            P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'            P_IS_REQUIRED       => true,',
'            P_DATA_TYPE         => APEX_PLUGIN_UTIL.C_DATA_TYPE_VARCHAR2',
'        );',
'    end if;',
'    -- Begin output as JSON',
'    sys.OWA_UTIL.MIME_HEADER(''application/json'', FALSE);',
'    sys.HTP.P(''Cache-Control: no-cache'');',
'    sys.HTP.P(''Pragma: no-cache'');',
'    sys.OWA_UTIL.HTTP_HEADER_CLOSE;',
'    ',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        L_CUSTOM_CHART_COLORS_TABLE := APEX_UTIL.STRING_TO_TABLE(CASE WHEN C_CUSTOM_CHART_COLORS IS NOT NULL THEN TRIM(BOTH '''''''' FROM APEX_ESCAPE.JS_LITERAL(C_CUSTOM_CHART_COLORS)) END, '':'');',
'        L_CUSTOM_CHART_COLORS := ''"color_scheme":['';',
'        FOR I IN L_CUSTOM_CHART_COLORS_TABLE.FIRST .. L_CUSTOM_CHART_COLORS_TABLE.LAST LOOP',
'            IF I > 1 THEN',
'                L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||'','';',
'            END IF;',
'            L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''"''||L_CUSTOM_CHART_COLORS_TABLE(I)||''"'';',
'        END LOOP;',
'        L_CUSTOM_CHART_COLORS := L_CUSTOM_CHART_COLORS||''],'';',
'    END IF;',
'',
'    L_MESSAGE_WHEN_NO_DATA_FOUND := APEX_ESCAPE.HTML_WHITELIST(',
'        APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                P_VALUE  => C_MESSAGE_WHEN_NO_DATA_FOUND,',
'                P_ESCAPE => FALSE',
'            )',
'        );',
'',
'    sys.HTP.PRN(',
'        ''{''||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''chart_type'',',
'                C_CHART_TYPE,',
'                FALSE,',
'                TRUE',
'            )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''message_when_no_data_found'',',
'            L_MESSAGE_WHEN_NO_DATA_FOUND,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''chart_css_class_names'',',
'            C_CHART_CSS_CLASSES,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    sys.HTP.PRN(',
'        APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'            ''icon_type'',',
'            C_ICON_TYPE,',
'            TRUE,',
'            TRUE',
'        )',
'    );',
'    IF C_COLOR_SCHEME = ''CUSTOM'' THEN',
'        sys.HTP.PRN(',
'            L_CUSTOM_CHART_COLORS',
'        );',
'    ELSE',
'        sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''color_scheme'',',
'                C_COLOR_SCHEME,',
'                TRUE,',
'                TRUE',
'            )',
'        );',
'    END IF;',
'    sys.HTP.PRN(',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''text_position'',',
'                C_TEXT_POSITION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''bar_width_calculation'',',
'                C_BAR_WIDTH_CALCULATION,',
'                FALSE,',
'                TRUE',
'            )||',
'            APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                ''display'',',
'                C_DISPLAY,',
'                FALSE,',
'                TRUE',
'            )||',
'            CASE ',
'            	WHEN C_DISPLAY IN (''VALUE'') THEN',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''prefix_for_value'',',
'						C_PREFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)||',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''postfix_for_value'',',
'						C_POSTFIX_FOR_VALUE,',
'						TRUE,',
'						TRUE',
'					)',
'			END||',
'            ''"items":[''',
'    );',
'    ',
'    --FOR L_ROW_NUMBER IN L_COLUMN_VALUE_LIST(1).VALUE_LIST.FIRST .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.LAST LOOP',
'    FOR L_ROW_NUMBER IN 1 .. L_COLUMN_VALUE_LIST(1).VALUE_LIST.COUNT LOOP',
'        BEGIN',
'            APEX_PLUGIN_UTIL.SET_COMPONENT_VALUES (',
'                P_COLUMN_VALUE_LIST => L_COLUMN_VALUE_LIST,',
'                P_ROW_NUM => L_ROW_NUMBER ',
'            );',
'            ',
'            IF L_ROW_NUMBER > 1 THEN',
'            	sys.HTP.PRN('', '');',
'            END IF;',
'            ',
'            sys.HTP.PRN(''{'');',
'            ',
'            L_LABEL := APEX_PLUGIN_UTIL.ESCAPE (',
'                APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                    P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).DATA_TYPE,',
'                    P_VALUE => L_COLUMN_VALUE_LIST(L_LABEL_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                ),',
'                P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label'',',
'                    L_LABEL,',
'                    FALSE',
'            	)',
'            );',
'            L_LABEL_LINK := ',
'                CASE ',
'                    WHEN C_LABEL_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_LABEL_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''label_link'',',
'                    L_LABEL_LINK',
'                )',
'            );',
'            L_VALUE := APEX_PLUGIN_UTIL.ESCAPE (',
'               APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                   P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).DATA_TYPE,',
'                   P_VALUE => L_COLUMN_VALUE_LIST(L_VALUE_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'               ),',
'               P_REGION.ESCAPE_OUTPUT',
'            );',
'            sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value'',',
'                    L_VALUE,',
'                    FALSE,',
'                    C_VALUE_LINK IS NOT NULL OR L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            L_VALUE_LINK := ',
'                CASE ',
'                    WHEN C_VALUE_LINK IS NOT NULL THEN ',
'                        APEX_UTIL.PREPARE_URL (',
'                            APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                P_VALUE  => C_VALUE_LINK,',
'                                P_ESCAPE => FALSE',
'                            )',
'                        )',
'                END;',
'             sys.HTP.PRN(',
'            	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    ''value_link'',',
'                    L_VALUE_LINK,',
'                    TRUE,',
'                    L_COLOR_COLUMN_NUMBER IS NOT NULL OR C_CHART_TYPE = ''ICON''',
'                )',
'            );',
'            IF L_COLOR_COLUMN_NUMBER IS NOT NULL THEN',
'                L_COLOR := APEX_PLUGIN_UTIL.ESCAPE (',
'                   APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'                       P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).DATA_TYPE,',
'                       P_VALUE => L_COLUMN_VALUE_LIST(L_COLOR_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'                   ),',
'                   P_REGION.ESCAPE_OUTPUT',
'                );',
'                sys.HTP.PRN(',
'                    APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                        ''color'',',
'                        L_COLOR,',
'                        FALSE,',
'                        C_CHART_TYPE = ''ICON''',
'                    )',
'                );',
'            END IF;',
'            IF C_ICON_TYPE = ''IMAGE'' THEN',
'				L_IMAGE_URL := ',
'                    CASE ',
'                        WHEN C_IMAGE_URL IS NOT NULL THEN ',
'                            APEX_UTIL.PREPARE_URL (',
'                                APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                                    P_VALUE  => C_IMAGE_URL,',
'                                    P_ESCAPE => FALSE',
'                                )',
'                            )',
'                    END;',
'				sys.HTP.PRN(',
'					APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''image_url'',',
'						L_IMAGE_URL,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''ICON'' THEN',
'				L_CSS_ICON_CLASS_NAME := APEX_PLUGIN_UTIL.REPLACE_SUBSTITUTIONS (',
'                    P_VALUE  => C_CSS_ICON_CLASS_NAME,',
'                    P_ESCAPE => TRUE',
'                );',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'						''icon_css_class_name'',',
'						L_CSS_ICON_CLASS_NAME,',
'						FALSE,',
'						FALSE',
'					)',
'				);',
'			ELSIF C_ICON_TYPE = ''INITIALS'' THEN',
'				L_INITIALS := APEX_PLUGIN_UTIL.ESCAPE (',
'					APEX_PLUGIN_UTIL.GET_VALUE_AS_VARCHAR2 (',
'						P_DATA_TYPE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).DATA_TYPE,',
'						P_VALUE => L_COLUMN_VALUE_LIST(L_INITIALS_COLUMN_NUMBER).VALUE_LIST(L_ROW_NUMBER)',
'					),',
'					P_REGION.ESCAPE_OUTPUT',
'				);',
'				sys.HTP.PRN(',
'                	APEX_JAVASCRIPT.ADD_ATTRIBUTE (',
'                    	''initials'',',
'	                    L_INITIALS,',
'	                    FALSE,',
'	                    FALSE',
'    	            )',
'    	        );',
'            END IF;',
'            ',
'			sys.HTP.PRN(''}'');',
'            ',
'            APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'        EXCEPTION',
'            WHEN OTHERS THEN',
'                APEX_PLUGIN_UTIL.CLEAR_COMPONENT_VALUES;',
'                RAISE;',
'        END;',
'    END LOOP;',
'    sys.HTP.PRN(',
'            '']''||',
'        ''}''',
'    );',
'    ',
'    RETURN NULL;',
'END AJAX;'))
,p_api_version=>1
,p_render_function=>'RENDER'
,p_ajax_function=>'AJAX'
,p_standard_attributes=>'SOURCE_SQL:AJAX_ITEMS_TO_SUBMIT:ESCAPE_OUTPUT'
,p_substitute_attributes=>false
,p_reference_id=>5610141522737396215.4757
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('<p>\6B64 Plugin \53EF\7E6A\88FD\5167\542B\6A19\7C64\3001\503C\3001\751A\81F3\5716\793A\7684\6C34\5E73\9577\689D\5716</p>')
,p_version_identifier=>'1.0'
,p_files_version=>16
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702355529511248080.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Icon Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'INITIALS'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702363631015248091.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'    <li><strong>Image</strong>: Adds an image HTML element on the left side of the chart.</li>',
'    <li><strong>CSS Icon</strong>: Unlike the &quot;Image&quot; icon, instead of displaying an image HTML element, it displays an icon with the given CSS class.</li>',
'    <li><strong>Initials</strong>: Opposed to both, the &quot;Image&quot; and &quot;CSS Icon&quot; icons, this one displays a colored circle containing the given initials.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702355979684248080.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702355529511248080.4757)
,p_display_sequence=>10
,p_display_value=>'Image'
,p_return_value=>'IMAGE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702356481590248081.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702355529511248080.4757)
,p_display_sequence=>20
,p_display_value=>'CSS Icon'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702356936166248081.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702355529511248080.4757)
,p_display_sequence=>30
,p_display_value=>'Initials'
,p_return_value=>'INITIALS'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702357400024248082.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Label Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702357878459248082.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Label Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the label is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702358237093248082.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Value Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_help_text=>'<p>A query column from which the label to be displayed is given. Notice that this value is not displayed on the chart items when the chart has been configured to display the bar width percentage instead.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702358660466248082.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Value Link'
,p_attribute_type=>'LINK'
,p_is_required=>false
,p_is_translatable=>false
,p_reference_scope=>'ROW'
,p_help_text=>'<p>A URL to be opened whenever the displayed value is clicked. This attribute supports substitution strings.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702359094583248083.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>5
,p_prompt=>'Chart CSS Class Names'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'<p>CSS class names to be added to the root element of the chart separated with spaces.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702359481010248083.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>13
,p_prompt=>'Image URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702355529511248080.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'IMAGE'
,p_help_text=>'<p>The Image URL to be displayed as the chart icon. This attribute supports Substitution strings referring to som query column like in <strong>&amp;IMAGE_URL.</strong> which would reference the <strong>IMAGE_URL</strong> column value for each of the '
||'bars presented on the char. Notice that substitutions with no value will be replaced with an empty string.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702359871575248083.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>12
,p_prompt=>'CSS Icon Class Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702355529511248080.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ICON'
,p_help_text=>'<p>The Icon CSS Class Name.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702360236107248083.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>14
,p_prompt=>'Initials Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702355529511248080.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'INITIALS'
,p_help_text=>'<p>A query column from which initials to be displayed as an icon are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702360668295248084.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>7
,p_prompt=>'Custom Chart Colors'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'CUSTOM'
,p_help_text=>'<p>A list of CSS supported colors separated by colons.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702361078930248085.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Display'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'VALUE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Displays either the item value or the calculated bar width on the right most text in the chart item.</p>'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702361441009248086.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702361078930248085.4757)
,p_display_sequence=>10
,p_display_value=>'Value'
,p_return_value=>'VALUE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702361954958248087.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702361078930248085.4757)
,p_display_sequence=>20
,p_display_value=>'Bar Width'
,p_return_value=>'BAR_WIDTH'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702362420463248090.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Prefix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1702361078930248085.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is prepended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702362822753248090.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'Postfix for Value'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_api.id(1702361078930248085.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'VALUE'
,p_help_text=>'<p>When the value is displayed on the right most side of the chart item. The value of this attribute is appended to it.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702363218589248091.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Maximum Rows'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'5'
,p_is_translatable=>false
,p_help_text=>'<p>The maximum number of items to be displayed inside the region. Notice bar width calculations are made based on the number of items displayed.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702363631015248091.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>4
,p_prompt=>'Chart Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'TEXT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Defines how the chart will be displayed. There are two types of chart: </p>',
'<ul>',
'    <li><strong>Icon Chart</strong>: Displays bars with the label and value above and add an icon on the left.</li>',
'    <li><strong>Text Chart</strong>: Displays bars with the label and value either above or inline with the bar.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702364048848248091.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702363631015248091.4757)
,p_display_sequence=>10
,p_display_value=>'Icon Chart'
,p_return_value=>'ICON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702364572708248092.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702363631015248091.4757)
,p_display_sequence=>20
,p_display_value=>'Text Chart'
,p_return_value=>'TEXT'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702365000696248092.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>16
,p_display_sequence=>105
,p_prompt=>'Bar Width Calculation'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ABSOLUTE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Bar widths for each one of the chart items can be calculated in two ways:</p>',
'<ul>',
'    <li><strong>Absolute</strong>: 100% bar width is represented by the maximum value on the displayed chart items.</li>',
'    <li><strong>Relative</strong>: 100% bar width is represented by the sum of the values of all the displayed chart items.</li>',
'</ul>'))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702365418121248092.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702365000696248092.4757)
,p_display_sequence=>10
,p_display_value=>'Absolute'
,p_return_value=>'ABSOLUTE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702365918099248092.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702365000696248092.4757)
,p_display_sequence=>20
,p_display_value=>'Relative'
,p_return_value=>'RELATIVE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>17
,p_display_sequence=>6
,p_prompt=>'Color Scheme'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'MODERN'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The colors to be used in the chart bars. There are two special types of configuration: </p>',
'<ul>',
'    <li><strong>Custom</strong>: Provides a text box to receive a colon separated list of css supported colors.</li>',
'</ul>',
'<ul>',
'    <li><strong>Query Column</strong>: Provides a select list with the query columns which expects a css valid color.</li>',
'</ul>',
''))
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702366855761248093.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_display_sequence=>5
,p_display_value=>'Default'
,p_return_value=>'DEFAULT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702367365406248093.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_display_sequence=>10
,p_display_value=>'Modern'
,p_return_value=>'MODERN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702367872275248094.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_display_sequence=>20
,p_display_value=>'Modern 2'
,p_return_value=>'MODERN_2'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702368370601248094.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_display_sequence=>30
,p_display_value=>'Solar'
,p_return_value=>'SOLAR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702368806714248094.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_display_sequence=>40
,p_display_value=>'Metro'
,p_return_value=>'METRO'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702369311435248095.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_display_sequence=>50
,p_display_value=>'Custom'
,p_return_value=>'CUSTOM'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702369866487248096.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_display_sequence=>60
,p_display_value=>'Query Column'
,p_return_value=>'COLUMN'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702370379885248096.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>18
,p_display_sequence=>55
,p_prompt=>'Text Position'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'AROUND'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702363631015248091.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'TEXT'
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When displaying a text chart, two options are available for displaying the label and value texts:</p>',
'<ul>',
'    <li><strong>Above the bar</strong>: The label and value texts are displayed above the bar at the left and right most sides of it respectively.</li>',
'    <li><strong>Inline with the bar</strong>: The label, the bar and the value are displayed in one line on that order.</li>',
'</ul>'))
);
end;
/
begin
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702370735296248096.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702370379885248096.4757)
,p_display_sequence=>10
,p_display_value=>'Above the bar'
,p_return_value=>'ABOVE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1702371254406248096.4757)
,p_plugin_attribute_id=>wwv_flow_api.id(1702370379885248096.4757)
,p_display_sequence=>20
,p_display_value=>'Inline with the bar'
,p_return_value=>'AROUND'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702371794292248097.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>19
,p_display_sequence=>8
,p_prompt=>'Chart Colors Column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1702366482126248093.4757)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'IN_LIST'
,p_depending_on_expression=>'COLUMN'
,p_help_text=>'<p>A query column from which CSS supported colors are given.</p>'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1702372131614248097.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>20
,p_display_sequence=>200
,p_prompt=>'Message When No Data Found'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_default_value=>'No data found.'
,p_is_translatable=>true
,p_help_text=>'<p>Message to be displayed when no data was found.</p>'
);
wwv_flow_api.create_plugin_std_attribute(
 p_id=>wwv_flow_api.id(1702375560504248101.4757)
,p_plugin_id=>wwv_flow_api.id(3347748742822204626.4757)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>1
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(539940534604132427.4757)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\684C\9762')
,p_display_seq=>10
,p_use_auto_detect=>false
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=&APP_ID.:50:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4757
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5168\57DF\9801\9762 - \684C\9762')
,p_step_title=>unistr('\5168\57DF\9801\9762 - \684C\9762')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_protection_level=>'D'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404677206185829568.4757)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404677418056829569.4757)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_api.id(404677206185829568.4757)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(384690703142932822.4757)
,p_plug_name=>'APEX 5 - Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_api.id(404677418056829569.4757)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(719097510387175373.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(404660636766798903.4757)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'not wwv_flow.apps_only_workspace'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404677698967829569.4757)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_api.id(404677418056829569.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<a href="f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404677861324829570.4757)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_api.id(404677206185829568.4757)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404678078196829570.4757)
,p_plug_name=>'APEX 5 - Search'
,p_parent_plug_id=>wwv_flow_api.id(404677861324829570.4757)
,p_region_css_classes=>'a-Header-search'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-SearchBox a-SearchBox--noGoButton a-SearchBox--autoExpand a-SearchBox--fill">'');',
'sys.htp.p(''  <div class="a-SearchBox-field">'');',
'sys.htp.p(''    <span class="a-SearchBox-icon"><span class="a-Icon icon-search"></span></span>'');',
'sys.htp.p(''    <label for="P0_SEARCH" class="visuallyhidden">Search</label>'');',
'sys.htp.p(''    <input type="text" class="a-SearchBox-input" id="P0_SEARCH" placeholder="''||wwv_flow_lang.system_message(''WWV_FLOW_QUICK_FLOW.SEARCH'')||''">'');',
'sys.htp.p(''  </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404678295558829570.4757)
,p_plug_name=>'APEX 5 - Header Navigation lists'
,p_parent_plug_id=>wwv_flow_api.id(404677861324829570.4757)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404724225488161526.4757)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_api.id(404678295558829570.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697584654501422607.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(404660915136798904.4757)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_required_role=>'!'||wwv_flow_api.id(805549616798538577)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(486772230808301732.4757)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_api.id(404678295558829570.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(697615600061428203.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(404660915136798904.4757)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404678402039829570.4757)
,p_plug_name=>'APEX 5 - Header Account'
,p_parent_plug_id=>wwv_flow_api.id(404677861324829570.4757)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404678655419829570.4757)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-pkg-apps'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'50'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404678877158829570.4757)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_api.id(404678655419829570.4757)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(384690882838932823.4757)
,p_plug_name=>'APEX 5- Breadcrumb'
,p_parent_plug_id=>wwv_flow_api.id(404678877158829570.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_menu_id=>wwv_flow_api.id(539941826945132432.4757)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(404662212565801043.4757)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404679005997829570.4757)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_api.id(404678655419829570.4757)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3773582323250301546.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(404678295558829570.4757)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404711161197908978.4757)
,p_button_image_alt=>unistr('Spotlight \641C\5C0B')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
,p_security_scheme=>'!'||wwv_flow_api.id(805549616798538577)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(384690975801932824.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(404678295558829570.4757)
,p_button_name=>'ADMINISTRATION'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710812892908978.4757)
,p_button_image_alt=>unistr('\7BA1\7406')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
,p_security_scheme=>'!'||wwv_flow_api.id(805549616798538577)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(384691038290932825.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(404678295558829570.4757)
,p_button_name=>'FEEDBACK'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404711161197908978.4757)
,p_button_image_alt=>unistr('\610F\898B\56DE\994B')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_api.id(693462664348655994.4757)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(384691145501932826.4757)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(404678295558829570.4757)
,p_button_name=>'HELP'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710812892908978.4757)
,p_button_image_alt=>unistr('\8AAA\660E')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(385808567373243610.4757)
,p_name=>'P0_WINDOW_MGMT_MODE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(404677206185829568.4757)
,p_source=>'APEX_WINDOW_MGMT_MODE'
,p_source_type=>'PREFERENCE'
,p_source_post_computation=>'NVL(:P0_WINDOW_MGMT_MODE, ''FOCUS'')'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(385808664685243611.4757)
,p_name=>'P0_WINDOW_MGMT_SHARE_WINDOW'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(404677206185829568.4757)
,p_source=>'APEX_WINDOW_MGMT_SHARE_WINDOW'
,p_source_type=>'PREFERENCE'
,p_source_post_computation=>'NVL(:P0_WINDOW_MGMT_SHARE_WINDOW, ''N'')'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8A2D\5B9A\5100\8868\677F\5831\8868\6642\9593\7BC4\570D')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\8A2D\5B9A\5100\8868\677F\5831\8868\6642\9593\7BC4\570D')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741365982136994250.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'200'
,p_dialog_width=>'500'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(788987310597838727.4757)
,p_plug_name=>unistr('\8A2D\5B9A\9996\9801\5831\8868\6642\9593\7BC4\570D')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(789086631472668997.4757)
,p_plug_name=>'wizard buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--wizard'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(788987501255838728.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(789086631472668997.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(788987706351838731.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(789086631472668997.4757)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(788987926490838731.4757)
,p_name=>'P5_TIMEFRAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(788987310597838727.4757)
,p_prompt=>unistr('\5831\8868\6642\9593\7BC4\570D')
,p_source=>'nvl(:P2_TIMEFRAME,604800)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, to_char(t) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5*60 t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15*60 t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 3600 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 2*3600  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3*3600  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4*3600  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6*3600 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8*3600 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12*3600 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 18*3600 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1*24*60*60 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2*24*60*60 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3*24*60*60 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4*24*60*60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5*24*60*60 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 6*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7*24*60*60 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14*24*60*60 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365*24*60*60 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8A2D\5B9A\9650\5236\5100\8868\677F\4E2D\986F\793A\4E4B\76E3\7763\67E5\8A62\7684\6642\9593\7BC4\570D.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(789083446179622323.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(788987501255838728.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(789083777258622324.4757)
,p_event_id=>wwv_flow_api.id(789083446179622323.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(788988650941838740.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set timeframe'
,p_process_sql_clob=>':P2_TIMEFRAME := :P5_TIMEFRAME;'
,p_process_when_button_id=>wwv_flow_api.id(788987706351838731.4757)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(788988458278838734.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_USER_PREFERENCES'
,p_process_name=>'Set Dashboard Reporting Timeframe Preference'
,p_attribute_01=>'SET_PREFERENCE_TO_ITEM_VALUE'
,p_attribute_02=>'FSP_P2_TIMEFRAME_PREFERENCE'
,p_attribute_03=>'P5_TIMEFRAME'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(789083864577624973.4757)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(788987706351838731.4757)
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\7BA1\7406\9996\9801')
,p_step_title=>unistr('\7BA1\7406\9996\9801')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(387694845181435038.4757)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#:a-Region--slimPadding:a-Region--sideRegion'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6839\64DA\60A8\6B0A\9650\7684\4E0D\540C, \60A8\53EF\4EE5\5728\300C\7BA1\7406\300D\4E2D\7BA1\7406\53CA\76E3\7763\60A8\5DE5\4F5C\5340\4E2D\7684\751F\7522\529B\548C\7BC4\4F8B\61C9\7528\7A0B\5F0F.</p>'),
unistr('<p><a target="_blank" href="&SYSTEM_HELP_URL./htmdb/utilizing-packaged-app-admin.html#GUID-0298F67D-EF2D-4A2D-A4F7-19CB2DD5D618">\77AD\89E3\5176\4ED6\8CC7\8A0A ...</a></p>')))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(656960126007052421.4757)
,p_plug_name=>unistr('\7BA1\7406\670D\52D9')
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(798354195880640621.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_plug_required_role=>wwv_flow_api.id(404682514053862570)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(656960270626052422.4757)
,p_plug_name=>unistr('\7BA1\7406\4E92\52D5\5F0F\5831\8868\8A2D\5B9A\503C')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-MediaList--noBadge'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(798364561880730346.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(808594161563279237.4757)
,p_plug_name=>unistr('\6D3B\52D5\5831\8868')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(808592810483273051.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(808616103208685071.4757)
,p_plug_name=>unistr('\5DE5\4F5C')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_list_id=>wwv_flow_api.id(808614585475666760.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(808638904045321480.4757)
,p_name=>'RENDERING: Change Password - Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(808616103208685071.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(808639250092321484.4757)
,p_event_id=>wwv_flow_api.id(808638904045321480.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var lSuccessMsg = this.data.APEX_SUCCESS_MESSAGE,',
'    lUrl = ''f?p=&APP_ID.:6:&SESSION.::'';',
'',
'if ( lSuccessMsg ) {',
'   lUrl += ''&success_msg='' + lSuccessMsg;',
'}',
'setTimeout(function() {',
'    apex.navigation.redirect(lUrl);',
'}, 0);'))
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\61C9\7528\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_page_mode=>'MODAL'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'$(".a-IconList--wizard").removeClass("a-IconList--wizard").addClass("a-IconList--featured");'
,p_step_template=>wwv_flow_api.id(741365982136994250.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(931637196591229164.4757)
,p_plug_name=>unistr('\61C9\7528\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_region_template_options=>'#DEFAULT#:a-Form--autoWidthLabels'
,p_region_attributes=>'style="margin: 24px 0"'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(931641436807391977.4757)
,p_plug_name=>'wizard buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--wizard'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1284871957378082013.4757)
,p_plug_name=>'&P7_APP_NAME.'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(931641795693396998.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(931641436807391977.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(931687732997369569.4757)
,p_branch_name=>'update app'
,p_branch_action=>'f?p=&APP_ID.:262:&SESSION.::&DEBUG.:262,209:P262_APPLICATION_ID,P262_ID,P81_APP_TYPE:&P7_APP_ID.,&P7_INSTALLED_APP_ID.,&P7_APP_TYPE.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P7_PKG_APP_TASK'
,p_branch_condition_text=>'UPDATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(932258382537362398.4757)
,p_branch_name=>'remove'
,p_branch_action=>'f?p=&APP_ID.:237:&SESSION.::&DEBUG.:237:P237_APPLICATION_ID,P81_APP_TYPE:&P7_INSTALLED_APP_ID.,&P7_APP_TYPE.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P7_PKG_APP_TASK'
,p_branch_condition_text=>'REMOVE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(935935713446136112.4757)
,p_branch_name=>'unlock'
,p_branch_action=>'f?p=&APP_ID.:234:&SESSION.::&DEBUG.:234:P234_APPLICATION_ID,P81_APP_TYPE:&P7_INSTALLED_APP_ID.,&P7_APP_TYPE.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>40
,p_branch_condition_type=>'PLSQL_EXPRESSION'
,p_branch_condition=>':P7_PKG_APP_TASK = ''UNLOCK'' and not wwv_flow.apps_only_workspace and wwv_flow_authorization.is_authorized_developer (p_developer_authorization => ''EDIT'')'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(935936897243165511.4757)
,p_branch_name=>'change authentication'
,p_branch_action=>'f?p=&APP_ID.:46:&SESSION.::&DEBUG.:46:P46_APPLICATION_ID,P81_APP_TYPE:&P7_INSTALLED_APP_ID.,&P7_APP_TYPE.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>50
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P7_PKG_APP_TASK'
,p_branch_condition_text=>'CHANGE_AUTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(931637438528238233.4757)
,p_name=>'P7_PKG_APP_TASK'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(931637196591229164.4757)
,p_prompt=>unistr('\5DE5\4F5C')
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'P7_PKG_APP_TASKS'
,p_lov=>'.'||wwv_flow_api.id(931635900643222282.4757)||'.'
,p_field_template=>wwv_flow_api.id(1212080564184792020.4757)
,p_item_css_classes=>'a-IconList--featured'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'S'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(931638459475251094.4757)
,p_name=>'P7_APP_ID'
,p_item_sequence=>1
,p_item_plug_id=>wwv_flow_api.id(931637196591229164.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(931639936453303973.4757)
,p_name=>'P7_APP_NAME'
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(931637196591229164.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(932256936321321854.4757)
,p_name=>'P7_INSTALLED_APP_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(931637196591229164.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(933142221496546817.4757)
,p_name=>'P7_APP_TYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(931637196591229164.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(931641976701401005.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(931641795693396998.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(931642239083401010.4757)
,p_event_id=>wwv_flow_api.id(931641976701401005.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(933143447617575022.4757)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get app_name, app_type and installed_app_id'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select a.app_name,',
'           case when a.app_type = ''DB'' then',
'                m.installed_app_id',
'           when a.app_type = ''WS'' then',
'                m.installed_ws_id',
'           end installed_app_id,',
'           case when a.app_type = ''DB'' then',
'                ''DATABASE''',
'           when a.app_type = ''WS'' then',
'                ''WEBSHEET''',
'           end app_type',
'		   from wwv_flow_pkg_applications a, wwv_flow_pkg_app_map m',
'		   where a.app_id = m.app_id',
'		   and m.security_group_id = :flow_security_group_id',
'		   and a.app_id = :P7_APP_ID)',
'loop',
'        :P7_APP_NAME := c1.app_name;',
'	:P7_APP_TYPE := c1.app_type;',
'	:P7_INSTALLED_APP_ID := c1.installed_app_id;',
'end loop;'))
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\7BA1\7406\9810\5B58\5831\8868')
,p_step_title=>unistr('\7BA1\7406\9810\5B58\5831\8868')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_ir_notifi.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(802126799972115514.4757)
,p_plug_name=>unistr('\751F\7522\529B\548C\7BC4\4F8B\61C9\7528\7A0B\5F0F\9810\5B58\5831\8868')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805538978589340502.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_item.checkbox(1, r.id, null, null,'':'', ''f''||lpad(''''||1,2,''0'') || ''_'' || lpad(''''||rownum,4,''0''), wwv_flow_lang.system_message(''REPORT_LABEL'', wwv_flow_escape.html(r.name))) id,',
'       m.installed_app_id application_id,',
'       a.app_name application,',
'       r.page_id page,',
'       (select p.plug_name from wwv_flow_page_plugs p where p.id = r.region_id ) region_name,',
'       r.visibility report_type, ',
'       r.name report_name, ',
'       lower(r.created_by) created_by,',
'       r.created_on,',
'       lower(r.updated_by) updated_by,',
'       r.updated_on',
'from wwv_flow_worksheet_rpts_dev r, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where r.flow_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and r.security_group_id = :flow_security_group_id',
'and r.visibility in (''PUBLIC'', ''PRIVATE'')'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(802126998751115520.4757)
,p_name=>'Saved Reports'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\5957\88DD\61C9\7528\7A0B\5F0F\6C92\6709\4EFB\4F55\4F7F\7528\8005\9810\5B58\5831\8868.')
,p_allow_report_categories=>'N'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_owner=>'CBCHO'
,p_internal_uid=>802126998751115520
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(802127096586115528.4757)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'#CHECK_ALL_CHECKBOX#'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(724233147515924810.4757)
,p_db_column_name=>'APPLICATION_ID'
,p_display_order=>11
,p_column_identifier=>'Y'
,p_column_label=>unistr('\61C9\7528\7A0B\5F0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387694785877435037.4757)
,p_db_column_name=>'APPLICATION'
,p_display_order=>21
,p_column_identifier=>'X'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387694112699435031.4757)
,p_db_column_name=>'PAGE'
,p_display_order=>31
,p_column_identifier=>'R'
,p_column_label=>unistr('\9801\9762')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(724233218323924811.4757)
,p_db_column_name=>'REGION_NAME'
,p_display_order=>41
,p_column_identifier=>'Z'
,p_column_label=>unistr('\5340\57DF')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(802127570505115533.4757)
,p_db_column_name=>'REPORT_TYPE'
,p_display_order=>51
,p_column_identifier=>'J'
,p_column_label=>unistr('\5831\8868\985E\578B')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(805149229047727280)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387694218150435032.4757)
,p_db_column_name=>'REPORT_NAME'
,p_display_order=>61
,p_column_identifier=>'S'
,p_column_label=>unistr('\5831\8868\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387694401535435034.4757)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>71
,p_column_identifier=>'U'
,p_column_label=>unistr('\5EFA\7ACB\6642\9593')
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387694308200435033.4757)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>81
,p_column_identifier=>'T'
,p_column_label=>unistr('\5EFA\7ACB\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387694633493435036.4757)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>91
,p_column_identifier=>'W'
,p_column_label=>unistr('\66F4\65B0\6642\9593')
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387694552472435035.4757)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>101
,p_column_identifier=>'V'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(385710174969581203.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(802126799972115514.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:RP:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(802126115693115511.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(802126799972115514.4757)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(802126337999115511.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(802126799972115514.4757)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\522A\9664\52FE\9078\7684\9805\76EE')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_worksheet_rpts_dev r, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where r.flow_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and r.security_group_id = :flow_security_group_id',
'and r.visibility in (''PUBLIC'', ''PRIVATE'')'))
,p_button_condition_type=>'EXISTS'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(802129063878115553.4757)
,p_branch_action=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(802128636115115543.4757)
,p_validation_name=>'must select report to delete'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow.g_f01.count = 0 then',
'  return false;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5FC5\9808\9078\53D6\8981\522A\9664\7684\5831\8868.')
,p_when_button_pressed=>wwv_flow_api.id(802126337999115511.4757)
,p_associated_item=>wwv_flow_api.id(.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1199176300631878439.4757)
,p_name=>'ADD CHECK ALL CHECKBOX'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(802126799972115514.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1199176486106878440.4757)
,p_event_id=>wwv_flow_api.id(1199176300631878439.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'PLUGIN_COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(802128701711115546.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete checked'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count',
'loop',
'    for c1 in (select id report_id, worksheet_id, is_default',
'               from wwv_flow_worksheet_rpts',
'               where id = wwv_flow.g_f01(i)',
'               and security_group_id=:flow_security_group_id)',
'    loop                ',
'        wwv_flow_worksheet_api.delete_saved_report (            ',
'            p_worksheet_id      => c1.worksheet_id,               ',
'            p_report_id         => c1.report_id,',
'            p_is_default        => c1.is_default);        ',
'    end loop;',
'end loop;'))
,p_process_error_message=>unistr('\7121\6CD5\79FB\9664\5831\8868.')
,p_process_when_button_id=>wwv_flow_api.id(802126337999115511.4757)
,p_process_success_message=>unistr('\5DF2\522A\9664\5831\8868.')
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_api.create_page(
 p_id=>17.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\7BA1\7406\8A02\95B1')
,p_step_title=>unistr('\7BA1\7406\8A02\95B1')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_ir_notifi.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805210210849829544.4757)
,p_plug_name=>unistr('\8A02\95B1')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805538978589340502.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'wwv_flow_item.checkbox(1, n.id, null,null,'':'',''f''||lpad(''''||1,2,''0'') || ''_'' || lpad(''''||rownum,4,''0'') ,',
'wwv_flow_lang.system_message(''IR_SUBSCRIPTION_LABEL'',a.app_name,r.page_id,n.created_by)) id,',
'm.installed_app_id application_id,',
'(select p.plug_name from wwv_flow_page_plugs p where p.id = r.region_id) region_name,',
'a.app_name application_name,',
'r.name report_name,',
'r.visibility report_type,',
'r.page_id  page_id,',
'to_timestamp(n.start_date) at time zone sessiontimezone start_date,',
'to_timestamp(n.end_date) at time zone sessiontimezone end_date,',
'case when nvl(n.end_date,systimestamp) >= systimestamp then',
'    n.offset_date',
'end offset_date,',
'n.notify_interval,',
'n.status,',
'n.notify_error,',
'n.email_from,',
'n.email_address email_to,',
'lower(n.created_by) created_by,',
'n.created_on',
'from wwv_flow_worksheet_notify n, wwv_flow_worksheet_rpts_dev r, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where n.worksheet_id = r.worksheet_id',
'and n.report_id = r.id',
'and r.flow_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and n.websheet_id is null',
'and n.security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(805210444454829545.4757)
,p_name=>'Interactive Reports with Notification'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\5957\88DD\61C9\7528\7A0B\5F0F\6C92\6709\4EFB\4F55\8A02\95B1\9805\76EE.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'CBCHO'
,p_internal_uid=>805210444454829545
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805210582423829548.4757)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'AA'
,p_column_label=>'#CHECK_ALL_CHECKBOX#'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805212071678829550.4757)
,p_db_column_name=>'NOTIFY_INTERVAL'
,p_display_order=>6
,p_column_identifier=>'H'
,p_column_label=>unistr('\983B\7387')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(805284490639012075)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805212408820829550.4757)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>8
,p_column_identifier=>'Z'
,p_column_label=>unistr('\5EFA\7ACB\6642\9593')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805212314470829550.4757)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>9
,p_column_identifier=>'Y'
,p_column_label=>unistr('\5EFA\7ACB\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805211088270829548.4757)
,p_db_column_name=>'STATUS'
,p_display_order=>14
,p_column_identifier=>'AI'
,p_column_label=>unistr('\72C0\614B')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(805215191044829557)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805211153537829548.4757)
,p_db_column_name=>'NOTIFY_ERROR'
,p_display_order=>15
,p_column_identifier=>'AJ'
,p_column_label=>unistr('\932F\8AA4\8A0A\606F')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805211294797829549.4757)
,p_db_column_name=>'START_DATE'
,p_display_order=>16
,p_column_identifier=>'AK'
,p_column_label=>unistr('\958B\59CB\65E5\671F')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805211388654829549.4757)
,p_db_column_name=>'END_DATE'
,p_display_order=>17
,p_column_identifier=>'AL'
,p_column_label=>unistr('\7D50\675F\65E5\671F')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805211491386829549.4757)
,p_db_column_name=>'OFFSET_DATE'
,p_display_order=>18
,p_column_identifier=>'AM'
,p_column_label=>unistr('\5DEE\7570\65E5\671F')
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805211932559829549.4757)
,p_db_column_name=>'EMAIL_FROM'
,p_display_order=>38
,p_column_identifier=>'AR'
,p_column_label=>unistr('\96FB\5B50\90F5\4EF6\5BC4\4EF6\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387695254687435042.4757)
,p_db_column_name=>'APPLICATION_NAME'
,p_display_order=>48
,p_column_identifier=>'AS'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387695333359435043.4757)
,p_db_column_name=>'PAGE_ID'
,p_display_order=>58
,p_column_identifier=>'AT'
,p_column_label=>unistr('\9801\9762')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387695483973435044.4757)
,p_db_column_name=>'EMAIL_TO'
,p_display_order=>68
,p_column_identifier=>'AU'
,p_column_label=>unistr('\96FB\5B50\90F5\4EF6\6536\4EF6\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805389236751702558.4757)
,p_db_column_name=>'REPORT_NAME'
,p_display_order=>69
,p_column_identifier=>'AV'
,p_column_label=>unistr('\5831\8868\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(387695591788435045.4757)
,p_db_column_name=>'REPORT_TYPE'
,p_display_order=>79
,p_column_identifier=>'AW'
,p_column_label=>unistr('\5831\8868\985E\578B')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_api.id(805395834107760451)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(724233368684924812.4757)
,p_db_column_name=>'APPLICATION_ID'
,p_display_order=>89
,p_column_identifier=>'AX'
,p_column_label=>unistr('\61C9\7528\7A0B\5F0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(724233437513924813.4757)
,p_db_column_name=>'REGION_NAME'
,p_display_order=>99
,p_column_identifier=>'AY'
,p_column_label=>unistr('\5340\57DF')
,p_column_type=>'STRING'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(385710381915581205.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805210210849829544.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:RP:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805213326731829552.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805210210849829544.4757)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805213568160829552.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(805210210849829544.4757)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\522A\9664\52FE\9078\7684\9805\76EE')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_worksheet_notify',
'where security_group_id = :flow_security_group_id'))
,p_button_condition_type=>'EXISTS'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805214665882829554.4757)
,p_branch_action=>'f?p=&FLOW_ID.:17:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(805213568160829552.4757)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805215001211829556.4757)
,p_branch_name=>'Go To Page 17'
,p_branch_action=>'f?p=&FLOW_ID.:17:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805214089654829552.4757)
,p_validation_name=>'must select notification to delete'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow.g_f01.count = 0 then',
'  return false;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5FC5\9808\9078\53D6\8981\522A\9664\7684\8A02\95B1.')
,p_when_button_pressed=>wwv_flow_api.id(805213568160829552.4757)
,p_associated_item=>wwv_flow_api.id(.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1199176517146878441.4757)
,p_name=>'ADD CHECK ALL CHECKBOX'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(805210210849829544.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1199176676147878442.4757)
,p_event_id=>wwv_flow_api.id(1199176517146878441.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'PLUGIN_COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805214187440829553.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete checked'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count',
'loop',
'    for c1 in (select id,',
'                      worksheet_id,',
'                      report_id,',
'                      created_by',
'               from wwv_flow_worksheet_notify',
'               where id = wwv_flow.g_f01(i)',
'               and security_group_id = :flow_security_group_id)           ',
'    loop',
'        wwv_flow_worksheet_api.delete_notify (',
'            p_worksheet_id    => c1.worksheet_id,',
'            p_app_user        => c1.created_by,',
'            p_report_id       => c1.report_id,',
'            p_notify_id       => c1.id);',
'    end loop;',
'end loop;'))
,p_process_error_message=>unistr('\7121\6CD5\79FB\9664\8A02\95B1.')
,p_process_when_button_id=>wwv_flow_api.id(805213568160829552.4757)
,p_process_success_message=>unistr('\5DF2\79FB\9664\8A02\95B1.')
);
end;
/
prompt --application/pages/page_00022
begin
wwv_flow_api.create_page(
 p_id=>22.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8A2D\5B9A\5DE5\4F5C\5340\504F\597D\8A2D\5B9A')
,p_step_title=>unistr('\8A2D\5B9A\5DE5\4F5C\5340\504F\597D\8A2D\5B9A')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_html_page_onload=>'onload="p17_checkdisable()"'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(215469304188572178)
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
'<!--',
'',
'function p17_checkdisable(){ ',
'var ltext_0 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_0''); ',
'var ltext_1 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_1''); ',
'var ltext; ',
'if(ltext_0.checked == true){ltext = ltext_0}else{ltext = ltext_1} ',
'html_DisableOnValue(ltext,''N'',''P17_ACCOUNT_LIFETIME_DAYS'',''P17_USER_MAX_LOGIN_FAILURES'') ',
'} ',
'',
'//-->',
'</script>'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/*apex.jQuery(''#P17_WORKSPACE_IMAGE ~ a'').each(function() {',
'    if (this.href.match(/apex_util.get_blob_file/)) {',
'        $x("public_workspace_img").src = this.href;',
'    }',
'});*/'))
,p_step_template=>wwv_flow_api.id(741369094170994311.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(404682514053862570)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_prefs.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805410076630857770.4757)
,p_plug_name=>unistr('\5E33\6236\767B\5165\63A7\5236')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805411797666857782.4757)
,p_plug_name=>unistr('\8A2D\5B9A\504F\597D\8A2D\5B9A')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('\5DE5\4F5C\5340\7684\504F\597D\8A2D\5B9A\63A7\5236\529F\80FD.')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805414676421857790.4757)
,p_plug_name=>unistr('\8A2D\5B9A\5DE5\4F5C\5340\504F\597D\8A2D\5B9A')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805415029302857791.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805414676421857790.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805414831280857790.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805414676421857790.4757)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_EDIT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805426374033857810.4757)
,p_branch_action=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(805414831280857790.4757)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805410207563857772.4757)
,p_name=>'P22_EXPIRE_FND_USER_ACCOUNTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(805410076630857770.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5E33\6236\5230\671F\8207\9396\5B9A\529F\80FD:')
,p_source=>'EXPIRE_FND_USER_ACCOUNTS'
,p_source_type=>'DB_COLUMN'
,p_source_post_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case',
'  when wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS'')=''Y'' then ''Y''',
'  else nvl(:P22_EXPIRE_FND_USER_ACCOUNTS,''N'')',
'end'))
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'EXPIRE USER ACCOUNTS'
,p_lov=>'.'||wwv_flow_api.id(805446669974928665.4757)||'.'
,p_tag_attributes=>'onchange="p17_checkdisable()"'
,p_read_only_when=>'nvl(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),''N'') = ''Y'''
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9078\64C7\4E00\500B\9078\9805, \6C7A\5B9A\662F\53EF\8B93 &PRODUCT_NAME. \4E00\822C\4F7F\7528\8005\5E33\6236\5931\6548, \6216\53EF\5C07\5B83\5011\9396\5B9A. \9019\9805\529F\80FD\53EA\9069\7528\65BC'),
unistr('\4F7F\7528 &PRODUCT_NAME. \4F7F\7528\8005\7BA1\7406\4ECB\9762\5EFA\7ACB\7684\4E00\822C\4F7F\7528\8005\5E33\6236.'),
unistr(' \53EF\4F9B\9078\53D6\7684\9078\9805\5305\62EC:'),
'<ul>',
unistr('<li>\555F\7528</li>'),
unistr('<li>\505C\7528</li>'),
'</ul>',
unistr('\9019\9805\529F\80FD\63D0\4F9B\984D\5916\7684\8A8D\8B49\5B89\5168\6027\7D66\61C9\7528\7A0B\5F0F.'),
unistr('\5982\679C\9078\53D6<b>\555F\7528</b>, \4F7F\7528\8005\5E33\6236\5BC6\78BC\5C07\5728\8A2D\5B9A\7684\671F\9593\5F8C\5931\6548,'),
unistr('\5E33\6236\5C07\5728\8D85\904E\8A2D\5B9A\7684\8A8D\8B49\5931\6557\6B21\6578\4E4B\5F8C\88AB\9396\5B9A, \800C\4E14\53EF\5C07\5E33\6236\5BC6\78BC\8A2D\6210\5728\7B2C\4E00\6B21\4F7F\7528\5F8C\5931\6548.'),
'<p>',
unistr('\5982\679C\6B64\5B89\88DD\7684 &PRODUCT_NAME. \7BA1\7406\54E1\5C07<b>\8981\6C42\8B93\4F7F\7528\8005\5E33\6236\5931\6548\8207\9396\5B9A\529F\80FD</b>\74B0\5883\8A2D\5B9A\8A2D\6210\300C\662F\300D, \8868\793A\5FC5\9808\70BA\6240\6709\5DE5\4F5C\5340\555F\7528\9019\9805\529F\80FD, \800C\8A72\9805\76EE\5C07\986F\793A<b>\555F\7528</b>, \4E26\4E14\7121\6CD5\7531\5DE5\4F5C\5340\7BA1\7406\54E1\52A0\4EE5\8B8A\66F4.')))
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805410744251857777.4757)
,p_name=>'P22_USER_MAX_LOGIN_FAILURES'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(805410076630857770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'nvl (',
'    wwv_flow_platform.get_preference(''MAX_LOGIN_FAILURES''),',
'    4 )'))
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('\5141\8A31\7684\767B\5165\5931\6557\6B21\6578\4E0A\9650:')
,p_source=>'FND_USER_MAX_LOGIN_FAILURES'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>3
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8F38\5165\4E00\500B\6B63\6574\6578, \4F5C\70BA\5C07\4E00\822C\4F7F\7528\8005\5E33\6236\9396\5B9A\524D, \5141\8A31\7684\9023\7E8C\5931\6557\8A8D\8B49\5617\8A66\6B21\6578\4E0A\9650. \5982\679C\5C07\6B64\6B04\4F4D\7559\767D, \5C07\4F7F\7528\7DB2\7AD9\5C64\6B21\7684<b>\5141\8A31\7684\767B\5165\5931\6557\6B21\6578\4E0A\9650</b>\74B0\5883\8A2D\5B9A.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805411205289857780.4757)
,p_name=>'P22_ACCOUNT_LIFETIME_DAYS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(805410076630857770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'nvl (',
'    wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS''),',
'    45 )'))
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('\4E00\822C\4F7F\7528\8005\5E33\6236\671F\9650 (\5929):')
,p_source=>'ACCOUNT_LIFETIME_DAYS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>3
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8F38\5165\4E00\500B\6B63\6574\6578, \4F5C\70BA\4E00\822C\4F7F\7528\8005\5E33\6236\5BC6\78BC\904E\671F\524D, \9084\80FD\5920\4F7F\7528\7684\5929\6578\4E0A\9650. \5982\679C\5C07\6B64\6B04\4F4D\7559\767D, \5C07\4F7F\7528\7DB2\7AD9\5C64\6B21\7684<b>\5E33\6236\5BC6\78BC\671F\9650</b>\74B0\5883\8A2D\5B9A.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805415233004857791.4757)
,p_name=>'P22_PROVISIONING_COMPANY_ID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(805414676421857790.4757)
,p_use_cache_before_default=>'NO'
,p_source=>'PROVISIONING_COMPANY_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(805420907136857796.4757)
,p_computation_sequence=>10
,p_computation_item=>'P22_EXPIRE_FND_USER_ACCOUNTS'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),''N'') = ''Y'' then',
'    return ''Y'';',
'else',
'    return :P22_EXPIRE_FND_USER_ACCOUNTS;',
'end if;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805421189091857798.4757)
,p_validation_name=>'Expire FND User Accounts in Y/N or null'
,p_validation_sequence=>10
,p_validation=>'nvl(:P22_EXPIRE_FND_USER_ACCOUNTS,''N'') in (''Y'',''N'')'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>unistr('\503C\8D85\51FA\7BC4\570D.')
,p_when_button_pressed=>wwv_flow_api.id(805414831280857790.4757)
,p_associated_item=>wwv_flow_api.id(805410207563857772.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805421383687857799.4757)
,p_validation_name=>'max login failures positive'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P22_USER_MAX_LOGIN_FAILURES );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\503C\5FC5\9808\662F\6B63\6574\6578.')
,p_validation_condition=>'P22_USER_MAX_LOGIN_FAILURES'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(805414831280857790.4757)
,p_associated_item=>wwv_flow_api.id(805410744251857777.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805421546119857799.4757)
,p_validation_name=>'account lifetime positive'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_number number;',
'begin',
'    l_number := to_number( :P22_ACCOUNT_LIFETIME_DAYS );',
'    if l_number = abs(trunc(l_number)) then',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'exception',
'    when others then',
'        return FALSE;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\503C\5FC5\9808\662F\6B63\6574\6578.')
,p_validation_condition=>'P22_ACCOUNT_LIFETIME_DAYS'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(805414831280857790.4757)
,p_associated_item=>wwv_flow_api.id(805411205289857780.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(805425657717857809.4757)
,p_name=>'App Builder Setting Updates Apps setting'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P22_ALLOW_APP_BUILDING_YN'
,p_condition_element=>'P22_ALLOW_APP_BUILDING_YN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'N'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805425947133857810.4757)
,p_event_id=>wwv_flow_api.id(805425657717857809.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P22_ALLOW_PACKAGED_APP_INS_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805426154712857810.4757)
,p_event_id=>wwv_flow_api.id(805425657717857809.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P22_ALLOW_PACKAGED_APP_INS_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805422042627857799.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'override with instance settings'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS'')=''Y'' then',
'    :P22_EXPIRE_FND_USER_ACCOUNTS := ''Y'';',
'end if;'))
,p_process_error_message=>unistr('\7121\6CD5\5957\7528\5DE5\4F5C\5340\504F\597D\8A2D\5B9A.')
,p_process_when_button_id=>wwv_flow_api.id(805414831280857790.4757)
,p_process_success_message=>unistr('\5DF2\5957\7528\5DE5\4F5C\5340\504F\597D\8A2D\5B9A.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805422297100857801.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Save WWV_FLOW_COMPANIES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_COMPANIES'
,p_attribute_03=>'P22_PROVISIONING_COMPANY_ID'
,p_attribute_04=>'PROVISIONING_COMPANY_ID'
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_attribute_14=>'N'
,p_attribute_15=>'D'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(805414831280857790.4757)
,p_process_when=>':P22_PROVISIONING_COMPANY_ID = wwv_flow_security.g_security_group_id'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805422669909857801.4757)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set provisioning_company_id'
,p_process_sql_clob=>':P22_PROVISIONING_COMPANY_ID := wwv_flow_security.g_security_group_id;'
,p_process_error_message=>'#SQLERRM#'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805422817459857801.4757)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'fetch wwv_flow_companies'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_COMPANIES'
,p_attribute_03=>'P22_PROVISIONING_COMPANY_ID'
,p_attribute_04=>'PROVISIONING_COMPANY_ID'
,p_attribute_14=>'N'
);
end;
/
prompt --application/pages/page_00024
begin
wwv_flow_api.create_page(
 p_id=>24.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8B8A\66F4\6211\7684\5BC6\78BC')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\8B8A\66F4\6211\7684\5BC6\78BC')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(805159035944749645)
,p_inline_css=>'#htmldbMessageHolder {position: inherit !important; margin: -10px auto 12px auto !important};'
,p_step_template=>wwv_flow_api.id(741365982136994250.4757)
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(808618444674696806.4757)
,p_plug_name=>unistr('\8B8A\66F4\5BC6\78BC')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--noBorder:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_row_template=>wwv_flow_api.id(1939532588110833.4757)
,p_plug_column_width=>'valign="top"'
,p_plug_display_condition_type=>'REQUEST_NOT_EQUAL_CONDITION'
,p_plug_display_when_condition=>'CONFIRM'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(808621063314696818.4757)
,p_plug_name=>'Close Window'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_plug_display_when_condition=>'CONFIRM'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(808621405592696819.4757)
,p_plug_name=>'reset'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4750_P24_PASSWORD := null;',
':F4750_P24_CONFIRM_PASSWORD := null;',
':P24_ENTER_CURRENT_PASSWORD := null;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(808630626294794185.4757)
,p_plug_name=>unistr('\6309\9215\5217')
,p_region_template_options=>'a-ButtonRegion--withItems:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>40
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(808618618409696808.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(808630626294794185.4757)
,p_button_name=>'Cancel'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(808618870920696809.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(808630626294794185.4757)
,p_button_name=>'Save'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(808623589132696826.4757)
,p_branch_action=>'f?p=&APP_ID.:24:&SESSION.:CONFIRM:&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(808619023600696810.4757)
,p_name=>'F4750_P24_USER_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(808618444674696806.4757)
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31:')
,p_source=>':flow_user'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8B8A\66F4\5BC6\78BC\4E4B\4F7F\7528\8005\7684\540D\7A31')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(808619567362696812.4757)
,p_name=>'P24_ENTER_CURRENT_PASSWORD'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(808618444674696806.4757)
,p_prompt=>unistr('\8F38\5165\76EE\524D\7684\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('\8F38\5165\60A8\76EE\524D\7684\5BC6\78BC.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(808620040744696814.4757)
,p_name=>'F4750_P24_PASSWORD'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(808618444674696806.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8F38\5165\65B0\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('\8F38\5165\65B0\5BC6\78BC')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(808620538452696818.4757)
,p_name=>'F4750_P24_CONFIRM_PASSWORD'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(808618444674696806.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\78BA\8A8D\65B0\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>2000
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('\91CD\65B0\8F38\5165\65B0\5BC6\78BC')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(808621979876696823.4757)
,p_validation_name=>':FLOW_USER is not null'
,p_validation_sequence=>10
,p_validation=>'FLOW_USER'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\672A\6B63\78BA\8A2D\5B9A\4F7F\7528\8005\540D\7A31. \8ACB\5B8C\5168\95DC\9589\60A8\7684\700F\89BD\5668, \7136\5F8C\5617\8A66\91CD\65B0\8B8A\66F4\60A8\7684\5BC6\78BC.')
,p_associated_item=>wwv_flow_api.id(808619023600696810.4757)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_validation_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Implemented on Display Only field due to issues with Username being null in some instances. Issue often reported on apex.oracle.com with users being unable to change their password until they have restarted their browser -- David Peake',
''))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(808622161695696823.4757)
,p_validation_name=>'P24_ENTER_CURRENT_PASSWORD'
,p_validation_sequence=>20
,p_validation=>'P24_ENTER_CURRENT_PASSWORD'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\5BC6\78BC.')
,p_associated_item=>wwv_flow_api.id(808619567362696812.4757)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(808622355996696823.4757)
,p_validation_name=>'F4750_P24_PASSWORD Not Null'
,p_validation_sequence=>30
,p_validation=>'F4750_P24_PASSWORD'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\5BC6\78BC.')
,p_associated_item=>wwv_flow_api.id(808620040744696814.4757)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_validation_comment=>'generated 07-AUG-2002 16:59'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(808622505908696824.4757)
,p_validation_name=>'F4750_P24_CONFIRM_PASSWORD Not Null'
,p_validation_sequence=>40
,p_validation=>'F4750_P24_CONFIRM_PASSWORD'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\78BA\8A8D\5BC6\78BC.')
,p_associated_item=>wwv_flow_api.id(808620538452696818.4757)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_validation_comment=>'generated 07-AUG-2002 16:59'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(808622767498696824.4757)
,p_validation_name=>'passwd = confirm passwd'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :F4750_P24_PASSWORD != :F4750_P24_CONFIRM_PASSWORD then',
'  :F4750_P24_PASSWORD := null;',
'  :F4750_P24_CONFIRM_PASSWORD := null;',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\78BA\8A8D\5BC6\78BC\8207\5BC6\78BC\4E0D\7B26.')
,p_validation_condition=>':F4750_P24_PASSWORD is not null and :F4750_P24_CONFIRM_PASSWORD is not null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(808620538452696818.4757)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(808622997499696824.4757)
,p_validation_name=>'Validate Current Password'
,p_validation_sequence=>60
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_api.is_login_password_valid(',
'  p_username=>:APP_USER,',
'  p_password=>:P24_ENTER_CURRENT_PASSWORD);'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7121\6548\7684\5BC6\78BC')
,p_validation_condition=>'P24_ENTER_CURRENT_PASSWORD'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(808619567362696812.4757)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(808621799286696820.4757)
,p_validation_name=>'strong password'
,p_validation_sequence=>70
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_security.strong_password_validation(',
'      p_username              => :F4750_P24_USER_NAME,',
'      p_password              => :F4750_P24_PASSWORD,',
'      p_old_password          => :P24_ENTER_CURRENT_PASSWORD,',
'      p_workspace_name        => ',
'              wwv_flow_security.find_company_name(:WORKSPACE_ID));'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\932F\8AA4')
,p_validation_condition=>':F4750_P24_PASSWORD is not null and :F4750_P24_CONFIRM_PASSWORD is not null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(808620040744696814.4757)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(808623048192696824.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'change password'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'  l_p varchar2(256) := v(''F4750_P24_PASSWORD'');',
'begin',
'  wwv_flow.update_cache_with_write(''F4750_P24_PASSWORD'',null);',
'  wwv_flow.update_cache_with_write(''F4750_P24_CONFIRM_PASSWORD'',null);',
'  wwv_flow.update_cache_with_write(''P24_ENTER_CURRENT_PASSWORD'',null);',
'  wwv_flow_api.g_fnd_user_password_action := true;',
'  update wwv_flow_fnd_user ',
'    set web_password = l_p',
'  where security_group_id = :flow_security_group_id ',
'    and user_id = (select user_id ',
'                    from wwv_flow_fnd_user ',
'                   where security_group_id = :flow_security_group_id ',
'                     and user_name = :flow_user);',
'  wwv_flow_api.g_fnd_user_password_action := false;',
'end;'))
,p_process_error_message=>unistr('\8B8A\66F4\5BC6\78BC\6642\767C\751F\932F\8AA4.')
,p_process_when=>':F4750_P24_PASSWORD = :F4750_P24_CONFIRM_PASSWORD'
,p_process_when_type=>'PLSQL_EXPRESSION'
,p_process_success_message=>unistr('\5DF2\8B8A\66F4\5BC6\78BC.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(808623229362696825.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'58'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(808644992112421974.4757)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog on Save'
,p_process_error_message=>unistr('\8B8A\66F4\5BC6\78BC\6642\767C\751F\932F\8AA4.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(808618870920696809.4757)
,p_process_success_message=>unistr('\5DF2\8B8A\66F4\5BC6\78BC.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(808626268357724569.4757)
,p_process_sequence=>15
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog on Cancel'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(808618618409696808.4757)
);
end;
/
prompt --application/pages/page_00027
begin
wwv_flow_api.create_page(
 p_id=>27.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\61C9\7528\7A0B\5F0F\6D3B\52D5')
,p_step_title=>unistr('\61C9\7528\7A0B\5F0F\6D3B\52D5')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(815824970388163832.4757)
,p_plug_name=>unistr('\61C9\7528\7A0B\5F0F\6D3B\52D5')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''PKG.APP.USER_ACTIVITY'', x.the_users, x.page_events) display_col,',
'       x.the_day',
'from',
'(select l.distinct_users the_users,',
'       trim(to_char(l.page_events,''999G999G999G990'')) page_events,',
'       l.log_day the_day',
'from wwv_flow_log_history l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.application_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.workspace_id',
'and l.workspace_id = :flow_security_group_id',
'union all',
'select count(distinct userid) the_users,',
'       trim(to_char(count(*),''999G999G999G990'')) page_events,',
'       trunc(l.time_stamp) the_day',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.flow_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''DB''',
'and l.userid is not null ',
'and l.time_stamp > trunc(sysdate)',
'group by trunc(l.time_stamp)',
'union all',
'select count(distinct userid) the_users,',
'       trim(to_char(count(*),''999G999G999G990'')) page_events,',
'       trunc(l.time_stamp) the_day',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.websheet_id = m.installed_ws_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''WS''',
'and l.userid is not null ',
'and l.time_stamp > trunc(sysdate)',
'group by trunc(l.time_stamp)) x'))
,p_plug_source_type=>'NATIVE_CSS_CALENDAR'
,p_attribute_01=>'THE_DAY'
,p_attribute_03=>'DISPLAY_COL'
,p_attribute_07=>'N'
,p_attribute_09=>'month:list:navigation'
,p_attribute_13=>'N'
,p_attribute_17=>'Y'
,p_attribute_19=>'N'
,p_attribute_22=>'Y'
);
end;
/
prompt --application/pages/page_00029
begin
wwv_flow_api.create_page(
 p_id=>29.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\9801\9762\6AA2\8996')
,p_step_title=>unistr('\9801\9762\6AA2\8996')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(387695745099435047.4757)
,p_plug_name=>'button bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(818291197123192122.4757)
,p_plug_name=>unistr('\9801\9762\6AA2\8996')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805538978589340502.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.user_id,',
'       x.ins_app_id,',
'       x.application,',
'       x.page,',
'       x.page_name,',
'       x.time_stamp,',
'       x.elapsed,',
'       x.num_rows,',
'       x.ir_search,',
'       x.error,',
'       x.page_mode,',
'       x.pgsize',
'from (',
'select lower(l.userid)      user_id,',
'       m.installed_app_id   ins_app_id,',
'       a.app_name           application,',
'       l.step_id            page,',
'       l.step_id||''. ''||(select name from wwv_flow_steps p where p.id = l.step_id and p.flow_id = m.installed_app_id) page_name,',
'       l.time_stamp,',
'       l.elap               elapsed,',
'       l.num_rows,',
'       l.ir_search,',
'       l.sqlerrm            error,',
'       decode(l.page_mode,''p'',''partial'',''d'',''full'',page_mode) page_mode,',
'       l.content_length pgsize',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.flow_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''DB''',
'and l.time_stamp > sysdate - (:P29_TIMEFRAME/86400)',
'and l.userid is not null',
'union all',
'select lower(l.userid)      user_id,',
'       m.installed_ws_id    ins_app_id,',
'       a.app_name           application,',
'       null                 page,',
'       (select name from wwv_flow_ws_webpages p where p.id = l.webpage_id and p.ws_app_id = m.installed_ws_id) page_name,',
'       l.time_stamp,',
'       l.elap               elapsed,',
'       l.num_rows,',
'       null                 ir_search,',
'       l.sqlerrm            error,',
'       null                 page_mode,',
'       l.content_length pgsize',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.websheet_id = m.installed_ws_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''WS''',
'and l.time_stamp > sysdate - (:P29_TIMEFRAME/86400)',
'and l.userid is not null) x',
'order by x.time_stamp desc'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(818291210293192122.4757)
,p_name=>'Page Views'
,p_max_row_count=>'1000000'
,p_max_row_count_message=>unistr('\6B64\5831\8868\7684\8CC7\6599\5217\6578\76EE\4E0A\9650\70BA #MAX_ROW_COUNT# \500B\8CC7\6599\5217.  \8ACB\5957\7528\7BE9\9078, \4EE5\6E1B\5C11\60A8\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'CBCHO'
,p_internal_uid=>818291210293192122
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(57831749317033950.4757)
,p_db_column_name=>'INS_APP_ID'
,p_display_order=>10
,p_column_identifier=>'N'
,p_column_label=>unistr('\61C9\7528\7A0B\5F0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818291543978192134.4757)
,p_db_column_name=>'APPLICATION'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818291708558192134.4757)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>30
,p_column_identifier=>'D'
,p_column_label=>unistr('\9801\9762')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818291411458192133.4757)
,p_db_column_name=>'USER_ID'
,p_display_order=>40
,p_column_identifier=>'A'
,p_column_label=>unistr('\4F7F\7528\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818291995338192134.4757)
,p_db_column_name=>'TIME_STAMP'
,p_display_order=>50
,p_column_identifier=>'F'
,p_column_label=>unistr('\6642\6233')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818292017980192135.4757)
,p_db_column_name=>'ELAPSED'
,p_display_order=>60
,p_column_identifier=>'G'
,p_column_label=>unistr('\7D93\6B77\6642\9593')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818292301932192135.4757)
,p_db_column_name=>'ERROR'
,p_display_order=>70
,p_column_identifier=>'J'
,p_column_label=>unistr('\932F\8AA4')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818292535119192135.4757)
,p_db_column_name=>'PGSIZE'
,p_display_order=>80
,p_column_identifier=>'L'
,p_column_label=>'PGSIZE'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818291679407192134.4757)
,p_db_column_name=>'PAGE'
,p_display_order=>90
,p_column_identifier=>'C'
,p_column_label=>'PAGE'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818292190505192135.4757)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>100
,p_column_identifier=>'H'
,p_column_label=>'NUM_ROWS'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818292229079192135.4757)
,p_db_column_name=>'IR_SEARCH'
,p_display_order=>110
,p_column_identifier=>'I'
,p_column_label=>'IR_SEARCH'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818292404284192135.4757)
,p_db_column_name=>'PAGE_MODE'
,p_display_order=>120
,p_column_identifier=>'K'
,p_column_label=>'PAGE_MODE'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(387695880936435048.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(818291197123192122.4757)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RP,RIR:::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(387695968139435049.4757)
,p_name=>'P29_TIMEFRAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(387695745099435047.4757)
,p_item_default=>'86400'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'86400'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, to_char(t) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5*60 t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15*60 t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 3600 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 2*3600  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3*3600  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4*3600  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6*3600 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8*3600 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12*3600 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 18*3600 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1*24*60*60 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2*24*60*60 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3*24*60*60 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4*24*60*60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5*24*60*60 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 6*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7*24*60*60 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14*24*60*60 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365*24*60*60 t from dual order by 2',
') q'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00030
begin
wwv_flow_api.create_page(
 p_id=>30.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_page_template_options=>'#DEFAULT#'
,p_help_text=>'No help is available for this page.'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(91864009451968916.4757)
,p_plug_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'NATIVE_JET_CHART'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P30_VIEW_AS'
,p_plug_display_when_cond2=>'CHART'
);
wwv_flow_api.create_jet_chart(
 p_id=>wwv_flow_api.id(91864112491968917.4757)
,p_region_id=>wwv_flow_api.id(91864009451968916.4757)
,p_chart_type=>'donut'
,p_height=>'420'
,p_animation_on_display=>'auto'
,p_animation_on_data_change=>'auto'
,p_data_cursor=>'auto'
,p_data_cursor_behavior=>'auto'
,p_hover_behavior=>'none'
,p_stack=>'off'
,p_stack_label=>'off'
,p_connect_nulls=>'Y'
,p_value_position=>'auto'
,p_value_format_scaling=>'auto'
,p_sorting=>'label-asc'
,p_fill_multi_series_gaps=>true
,p_tooltip_rendered=>'N'
,p_show_series_name=>true
,p_show_group_name=>true
,p_show_value=>true
,p_show_label=>true
,p_show_row=>true
,p_show_start=>true
,p_show_end=>true
,p_show_progress=>true
,p_show_baseline=>true
,p_legend_rendered=>'off'
,p_legend_position=>'auto'
,p_overview_rendered=>'off'
,p_pie_other_threshold=>.02
,p_pie_selection_effect=>'highlight'
,p_horizontal_grid=>'auto'
,p_vertical_grid=>'auto'
,p_gauge_orientation=>'circular'
,p_gauge_plot_area=>'on'
,p_show_gauge_value=>true
);
wwv_flow_api.create_jet_chart_series(
 p_id=>wwv_flow_api.id(91864201493968918.4757)
,p_chart_id=>wwv_flow_api.id(91864112491968917.4757)
,p_seq=>10
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_data_source_type=>'SQL'
,p_data_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.userid,',
'       x.page_views',
'from (',
'select lower(l.userid) as userid,',
'       count(*)        as page_views',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.flow_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''DB''',
'and l.time_stamp > sysdate - (:P30_TIMEFRAME/86400)',
'and l.userid     is not null',
'group by lower(l.userid)',
'union all',
'select lower(l.userid) as userid,',
'       count(*)        as page_views',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.websheet_id = m.installed_ws_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''WS''',
'and l.time_stamp > sysdate - (:P30_TIMEFRAME/86400)',
'and l.userid is not null',
'group by lower(l.userid)) x',
'order by x.page_views'))
,p_items_value_column_name=>'PAGE_VIEWS'
,p_items_label_column_name=>'USERID'
,p_items_label_rendered=>true
,p_items_label_position=>'auto'
,p_items_label_display_as=>'ALL'
,p_threshold_display=>'onIndicator'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(387696033127435050.4757)
,p_plug_name=>'button bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(818309753019781737.4757)
,p_plug_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_plug_template=>wwv_flow_api.id(805538978589340502.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'lower(l.userid)                   the_user,',
'count(*)                          page_events,',
'median(l.elap)                    median_elapsed,',
'sum(l.num_rows)                   rows_fetched,',
'sum(decode(l.ir_search,null,0,1)) ir_searches,',
'sum(decode(l.sqlerrm,null,0,1))   errors,',
'max(l.time_stamp)                 most_recent',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.flow_id = m.installed_app_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''DB''',
'and l.time_stamp > sysdate - (:P30_TIMEFRAME/86400)',
'and l.userid is not null',
'group by lower(l.userid)',
'union all',
'select',
'lower(l.userid)                   the_user,',
'count(*)                          page_events,',
'median(l.elap)                    median_elapsed,',
'sum(l.num_rows)                   rows_fetched,',
'sum(decode(l.ir_search,null,0,1)) ir_searches,',
'sum(decode(l.sqlerrm,null,0,1))   errors,',
'max(l.time_stamp)                 most_recent',
'from wwv_flow_activity_log l, wwv_flow_pkg_app_map m, wwv_flow_pkg_applications a',
'where l.websheet_id = m.installed_ws_id',
'and m.app_id = a.app_id',
'and m.security_group_id = l.security_group_id',
'and l.security_group_id = :flow_security_group_id',
'and a.app_type = ''WS''',
'and l.time_stamp > sysdate - (:P30_TIMEFRAME/86400)',
'and l.userid is not null',
'group by lower(l.userid)',
''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P30_VIEW_AS'
,p_plug_display_when_cond2=>'REPORT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(818309872448781737.4757)
,p_name=>'Top Users'
,p_max_row_count=>'1000000'
,p_max_row_count_message=>unistr('\6B64\5831\8868\7684\8CC7\6599\5217\6578\76EE\4E0A\9650\70BA #MAX_ROW_COUNT# \500B\8CC7\6599\5217.  \8ACB\5957\7528\7BE9\9078, \4EE5\6E1B\5C11\60A8\67E5\8A62\4E2D\7684\8A18\9304\6578\76EE.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_download_formats=>'CSV:HTML:EMAIL:XLS:PDF:RTF'
,p_owner=>'CBCHO'
,p_internal_uid=>818309872448781737
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818310029624781746.4757)
,p_db_column_name=>'THE_USER'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\4F7F\7528\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818310186167781749.4757)
,p_db_column_name=>'PAGE_EVENTS'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\9801\9762\6AA2\8996')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818310286211781749.4757)
,p_db_column_name=>'MEDIAN_ELAPSED'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\4E2D\9593\503C\6B77\6642')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G990D0000'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818310396450781749.4757)
,p_db_column_name=>'ROWS_FETCHED'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\64F7\53D6\7684\8CC7\6599\5217')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818310413109781754.4757)
,p_db_column_name=>'IR_SEARCHES'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\5831\8868\641C\5C0B')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818310564517781754.4757)
,p_db_column_name=>'ERRORS'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\932F\8AA4')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(818310695218781754.4757)
,p_db_column_name=>'MOST_RECENT'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\6700\8FD1\7684\6AA2\8996')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(818313423274802104.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(818309753019781737.4757)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:RP,RIR:::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(818313166460802101.4757)
,p_name=>'P30_TIMEFRAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(387696033127435050.4757)
,p_item_default=>'86400'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'86400'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, to_char(t) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5*60 t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15*60 t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 3600 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 2*3600  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3*3600  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4*3600  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6*3600 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8*3600 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12*3600 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 18*3600 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1*24*60*60 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2*24*60*60 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3*24*60*60 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4*24*60*60 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5*24*60*60 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 6*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7*24*60*60 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14*24*60*60 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28*24*60*60 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365*24*60*60 t from dual order by 2',
') q'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(818313213970802102.4757)
,p_name=>'P30_VIEW_AS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(387696033127435050.4757)
,p_item_default=>'REPORT'
,p_prompt=>unistr('\6AA2\8996\65B9\5F0F')
,p_source=>'REPORT'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P30_VIEW_AS'
,p_lov=>'.'||wwv_flow_api.id(818319918283815176.4757)||'.'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00046
begin
wwv_flow_api.create_page(
 p_id=>46.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8B8A\66F4\8A8D\8B49')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\8B8A\66F4\8A8D\8B49')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(806250634212071966)
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492892149649858120.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492893177518858121.4757)
,p_plug_name=>unistr('\8B8A\66F4\8A8D\8B49')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492893989100858123.4757)
,p_plug_name=>unistr('\8A8D\8B49\8A2D\5B9A\503C')
,p_region_name=>'PLUGIN'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="color:#FFFFFF;display:none;"'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid=>true
,p_plug_display_point=>'BODY'
,p_plug_footer=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
unistr('// \5728\5448\73FE\52D5\614B\5C6C\6027\5F8C\7ACB\5373\52A0\4EE5\96B1\85CF, '),
unistr('// jQuery.ready \53EF\80FD\6703\57F7\884C\5F88\4E45. '),
'apex.builder.dynamicAttributes.hide(''P46_'');',
'</script>'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492897358519858127.4757)
,p_plug_name=>'Add Javascript code for Plugins'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_new_grid=>true
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    -- create the onChange event for the P46_AUTH and',
'    -- also the initialization code for the dynamic attributes',
'    wwv_flow_plugin_dev.add_onload_code (',
'        p_plugin_type         => wwv_flow_plugin.c_plugin_type_authentication,',
'        p_type_page_item_name => ''P46_AUTH'',',
'        p_page_item_prefix    => ''P46_'' );',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492892379954858121.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(492892149649858120.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492892500116858121.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(492892149649858120.4757)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492893306622858121.4757)
,p_name=>'P46_APPLICATION_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(492893177518858121.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492893588321858122.4757)
,p_name=>'P46_APP_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(492893177518858121.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name ',
'from wwv_flows',
'where id = :P46_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492893708139858123.4757)
,p_name=>'P46_AUTH'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(492893177518858121.4757)
,p_item_default=>'APEX'
,p_prompt=>unistr('\8A8D\8B49')
,p_source=>'select scheme_type from wwv_flow_authentications where flow_id = :P46_APPLICATION_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PACKAGED_APP_AUTH_OPTION_PG46'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'       name_with_prefix      as r',
'  from wwv_flow_native_plugins',
' where plugin_type = ''AUTHENTICATION TYPE''',
'   and (          name_with_prefix = ''NATIVE_APEX_ACCOUNTS''',
'         or (     name_with_prefix = ''NATIVE_HTTP_HEADER_VARIABLE''',
'              and :P7_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_HHEAD'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_LDAP''',
'              and :P7_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_LDAP'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_IAS_SSO''',
'              and :P7_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_SSO'') = ''Y'' ))',
'union all',
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_CLOUD_IDM''),',
'       ''NATIVE_CLOUD_IDM''',
'  from sys.dual',
' where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492894385246858124.4757)
,p_name=>'P46_ATTRIBUTE_01'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492894584823858124.4757)
,p_name=>'P46_ATTRIBUTE_02'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492894732824858124.4757)
,p_name=>'P46_ATTRIBUTE_03'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492894983148858124.4757)
,p_name=>'P46_ATTRIBUTE_04'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492895134570858124.4757)
,p_name=>'P46_ATTRIBUTE_05'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492895339778858125.4757)
,p_name=>'P46_ATTRIBUTE_06'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492895583803858125.4757)
,p_name=>'P46_ATTRIBUTE_07'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492895792177858125.4757)
,p_name=>'P46_ATTRIBUTE_08'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492895989502858125.4757)
,p_name=>'P46_ATTRIBUTE_09'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492896147252858125.4757)
,p_name=>'P46_ATTRIBUTE_10'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492896380421858125.4757)
,p_name=>'P46_ATTRIBUTE_11'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492896565565858125.4757)
,p_name=>'P46_ATTRIBUTE_12'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492896749160858126.4757)
,p_name=>'P46_ATTRIBUTE_13'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492896913620858127.4757)
,p_name=>'P46_ATTRIBUTE_14'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492897191101858127.4757)
,p_name=>'P46_ATTRIBUTE_15'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(492893989100858123.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(740979344212387742.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(492892379954858121.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(740979698605387743.4757)
,p_event_id=>wwv_flow_api.id(740979344212387742.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(492897911531858127.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Application Authentication'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'        --',
'        -- configure authentication scheme',
'        --',
'        if :P46_AUTH = ''NATIVE_CLOUD_IDM'' then',
'            -- IDM authentication',
'            update wwv_flow_authentications',
'               set scheme_type          = :P46_AUTH,',
'                   name                 = wwv_flow_lang.system_message (',
'                                              ''AUTHENTICATION_NAME.''||:P46_AUTH ),',
'                   --''Oracle Cloud Identity Management'',',
'                   invalid_session_type = null,',
'                   invalid_session_url  = null,',
'                   logout_url           = null',
'            where flow_id = :P46_APPLICATION_ID;',
'        else',
'            -- configure plugin attributes',
'            update wwv_flow_authentications',
'               set scheme_type  = :P46_AUTH,',
'                   name         = wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''||:P46_AUTH),',
'                   attribute_01 = :P46_ATTRIBUTE_01,',
'                   attribute_02 = :P46_ATTRIBUTE_02,',
'                   attribute_03 = :P46_ATTRIBUTE_03,',
'                   attribute_04 = :P46_ATTRIBUTE_04,',
'                   attribute_05 = :P46_ATTRIBUTE_05,',
'                   attribute_06 = :P46_ATTRIBUTE_06,',
'                   attribute_07 = :P46_ATTRIBUTE_07,',
'                   attribute_08 = :P46_ATTRIBUTE_08,',
'                   attribute_09 = :P46_ATTRIBUTE_09,',
'                   attribute_10 = :P46_ATTRIBUTE_10,',
'                   attribute_11 = :P46_ATTRIBUTE_11,',
'                   attribute_12 = :P46_ATTRIBUTE_12,',
'                   attribute_13 = :P46_ATTRIBUTE_13,',
'                   attribute_14 = :P46_ATTRIBUTE_14,',
'                   attribute_15 = :P46_ATTRIBUTE_15',
'             where flow_id = :P46_APPLICATION_ID;',
'        end if;',
'        commit;',
' end;'))
,p_process_error_message=>unistr('\672A\9806\5229\66F4\65B0\61C9\7528\7A0B\5F0F.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(492892500116858121.4757)
,p_process_success_message=>unistr('\5DF2\9806\5229\66F4\65B0\61C9\7528\7A0B\5F0F\8A8D\8B49\914D\7F6E.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(740979821670390985.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(492892500116858121.4757)
,p_process_success_message=>unistr('\5DF2\8B8A\66F4\61C9\7528\7A0B\5F0F\8A8D\8B49.')
);
end;
/
prompt --application/pages/page_00050
begin
wwv_flow_api.create_page(
 p_id=>50.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\61C9\7528\7A0B\5F0F\5EAB')
,p_step_title=>unistr('\61C9\7528\7A0B\5F0F\5EAB')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_file_urls=>'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.stickyWidget#MIN#.js'
,p_javascript_code_onload=>'$("#pkgapp_filters").stickyWidget({toggleWidth: true});'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.app-installed { color: #008A00; vertical-align: top; display: inline-block; }',
'.app-not-installed { display: none; }',
'.a-AppCards { margin: 8px; }',
'.a-ButtonRegion--pkgApps .a-Form-inputContainer .radio_group label { padding: 12px 8px; }',
'div#P50_APP_GROUP { margin-left: 12px; }'))
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(806250634212071966)
,p_deep_linking=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(72206427080569501.4757)
,p_plug_name=>unistr('\6DF1\5165\77AD\89E3\5340\57DF')
,p_region_css_classes=>'a-ButtonRegion--banner apex-pkg-apps'
,p_region_template_options=>'a-ButtonRegion--withItems'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-MediaBlock">'');',
'sys.htp.p(''    <div class="a-MediaBlock-graphic">'');',
'sys.htp.p(''        <span class="icon-get-started" aria-hidden="true"></span>'');',
'sys.htp.p(''    </div>'');',
'sys.htp.p(''    <div class="a-MediaBlock-content">'');',
'sys.htp.p(''        <h2>''||wwv_flow_lang.system_message(''LEARN_MORE_PROD_APPS'')||''</h2>'');',
'sys.htp.p(''    </div>'');',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_platform.get_preference(''GETTING_STARTED_ENABLED'') = ''Y'''
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(563554108117454948.4757)
,p_plug_name=>unistr('\7BE9\9078\689D\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>35
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(714049707406570332.4757)
,p_name=>unistr('\5957\88DD\61C9\7528\7A0B\5F0F')
,p_template=>wwv_flow_api.id(404672496027804677.4757)
,p_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_sub_css_classes=>'a-AppCards--slim a-AppCards--grid'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with ',
'    msg as (',
'        select wwv_flow_lang.system_message(''SAMPLE_WEBSHEET'') sample_websheet,',
'               wwv_flow_lang.system_message(''DEMO.SAMPLE.APP'') sample_db_app',
'        from dual),',
'    category_t as (',
'        select id,',
'            case when category_name != ''Sample'' then',
'                wwv_flow_lang.system_message(''PA.CATEGORY.''||replace(upper(category_name),'' '',''.''))',
'            else',
'                category_name',
'            end category_name',
'        from wwv_flow_pkg_app_categories),',
'    category_name as (',
'        select app_id,',
'        case when app_category_id_1 is not null then',
'            (select case when ct.category_name = ''Sample'' then',
'                        case when pa.app_type = ''DB'' then',
'                            m.sample_db_app',
'                        when pa.app_type = ''WS'' then',
'                            m.sample_websheet',
'                        end',
'                    else',
'                        ct.category_name',
'                    end category_name ',
'            from category_t ct, msg m where ct.id = pa.app_category_id_1)',
'        end||',
'        case when app_category_id_2 is not null then',
'            '', ''||(select case when ct.category_name = ''Sample'' then',
'                        case when pa.app_type = ''DB'' then',
'                            m.sample_db_app',
'                        when pa.app_type = ''WS'' then',
'                            m.sample_websheet',
'                        end',
'                    else',
'                        ct.category_name',
'                    end category_name ',
'            from category_t ct, msg m where ct.id = pa.app_category_id_2)',
'        end||',
'        case when app_category_id_3 is not null then',
'            '', ''||(select case when ct.category_name = ''Sample'' then',
'                        case when pa.app_type = ''DB'' then',
'                            m.sample_db_app',
'                        when pa.app_type = ''WS'' then',
'                            m.sample_websheet',
'                        end',
'                    else',
'                        ct.category_name',
'                    end category_name ',
'            from category_t ct, msg m where ct.id = pa.app_category_id_3)',
'        end category_name',
'        from wwv_flow_pkg_applications pa)',
'select * from ',
'(select  p.app_name,',
'    p.id,',
'    p.app_id,',
'    p.image_identifier icon_class,',
'    p.app_status,',
'    p.app_group,',
'    decode(p.app_type,''WS'',''WEBSHEET'',''DB'',''DATABASE'') application_type,',
'    cn.category_name category,',
'    apex_util.prepare_url( ''f?p=''||:APP_ID||'':81:''||:APP_SESSION||'':::81:P81_ID,P81_APP_TYPE:''||p.app_id||'',''||decode(p.app_type,''WS'',''WEBSHEET'',''DB'',''DATABASE'') ) card_link,',
'    null app_info,',
'    nvl((select ''app-installed'' x ',
'       from WWV_FLOW_PKG_APP_MAP m ',
'      where m.app_id = p.app_id ',
'            and m.security_group_id = :flow_security_group_id),''app-not-installed'') installed_class,',
'    nvl((select wwv_flow_lang.system_message(''DEMO_APPLICATION.INSTALLED'') x ',
'           from WWV_FLOW_PKG_APP_MAP m ',
'          where m.app_id = p.app_id ',
'                and m.security_group_id = :flow_security_group_id),'' '') installed_text,',
'    -- simple search ranking',
'    case when :P50_SEARCH is null',
'         then p.app_name',
'         when instr(lower(p.app_name), lower(:P50_SEARCH)) > 0',
'         then ''1''',
'         when instr(lower(cn.category_name), lower(:P50_SEARCH)) > 0',
'         then ''2''',
'         when instr(lower(p.app_description), lower(:P50_SEARCH)) > 0',
'         then ''3''',
'    end search_rank',
'from wwv_flow_pkg_applications p, category_name cn, msg m',
'where p.app_status <> ''HIDDEN''',
'and (instr(tags,''DEPRECATED'') = 0 or tags is null or nvl(:P50_SHOW_DEPRECATED,''N'') = ''Y'')',
'and p.app_id = cn.app_id',
'and ((:APPS_ONLY_WORKSPACE = ''N'') or',
'     (:APPS_ONLY_WORKSPACE = ''Y'' and cn.category_name != ''Sample''))',
'and (nvl(:P50_SEARCH,''X'') = ''X'' or (',
'      instr(lower(p.app_name),       lower(:P50_SEARCH)) > 0 or',
'      instr(lower(cn.category_name), lower(:P50_SEARCH)) > 0 or',
'      instr(lower(p.app_description), lower(:P50_SEARCH)) > 0',
'      ) )',
' ) x',
' where :P50_APP_GROUP = ''ALL'' or x.app_group = :P50_APP_GROUP or (:P50_APP_GROUP = ''INSTALLED'' and x.installed_class = ''app-installed'')',
'order by x.search_rank, x.app_name'))
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P50_APP_GROUP,P50_SEARCH'
,p_query_row_template=>wwv_flow_api.id(932270054883616955.4757)
,p_query_num_rows=>1000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-IRR-noDataMsg">',
unistr('    <div class="a-IRR-noDataMsg-icon"><span class="a-Icon icon-irr-no-results" aria-hidden="true"></span></div><span class="a-IRR-noDataMsg-text">\627E\4E0D\5230\4EFB\4F55\61C9\7528\7A0B\5F0F. \8ACB\5617\8A66\5176\4ED6\641C\5C0B\8A5E.</span>'),
'</div>'))
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714049887820570333.4757)
,p_query_column_id=>1
,p_column_alias=>'APP_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714049927625570334.4757)
,p_query_column_id=>2
,p_column_alias=>'ID'
,p_column_display_sequence=>2
,p_column_heading=>'ID'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714050084630570335.4757)
,p_query_column_id=>3
,p_column_alias=>'APP_ID'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\61C9\7528\7A0B\5F0F ID')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714051157877570346.4757)
,p_query_column_id=>4
,p_column_alias=>'ICON_CLASS'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\5716\793A\985E\5225')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714050309571570338.4757)
,p_query_column_id=>5
,p_column_alias=>'APP_STATUS'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\61C9\7528\7A0B\5F0F\72C0\614B')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(732461054189763718.4757)
,p_query_column_id=>6
,p_column_alias=>'APP_GROUP'
,p_column_display_sequence=>13
,p_column_heading=>unistr('\61C9\7528\7A0B\5F0F\7FA4\7D44')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714050569402570340.4757)
,p_query_column_id=>7
,p_column_alias=>'APPLICATION_TYPE'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\61C9\7528\7A0B\5F0F\985E\578B')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714050679697570341.4757)
,p_query_column_id=>8
,p_column_alias=>'CATEGORY'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\985E\5225')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714051533099570350.4757)
,p_query_column_id=>9
,p_column_alias=>'CARD_LINK'
,p_column_display_sequence=>11
,p_column_heading=>unistr('\5361\9023\7D50')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714051233129570347.4757)
,p_query_column_id=>10
,p_column_alias=>'APP_INFO'
,p_column_display_sequence=>8
,p_column_heading=>unistr('\61C9\7528\7A0B\5F0F\8CC7\8A0A')
,p_use_as_row_header=>'N'
,p_column_html_expression=>'#CATEGORY# <span class="#INSTALLED_CLASS#"><span class="a-Icon icon-check"></span>#INSTALLED_TEXT#</span>'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714051323530570348.4757)
,p_query_column_id=>11
,p_column_alias=>'INSTALLED_CLASS'
,p_column_display_sequence=>9
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(714051456113570349.4757)
,p_query_column_id=>12
,p_column_alias=>'INSTALLED_TEXT'
,p_column_display_sequence=>10
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(732460003984763708.4757)
,p_query_column_id=>13
,p_column_alias=>'SEARCH_RANK'
,p_column_display_sequence=>12
,p_column_heading=>unistr('\641C\5C0B\7B49\7D1A')
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1212073696697771901.4757)
,p_plug_name=>'App Filters'
,p_region_name=>'pkgapp_filters'
,p_region_css_classes=>'a-ButtonRegion--pkgApps'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder:a-ButtonRegion--accessibleTitle:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1516083185840947672.4757)
,p_plug_name=>'Language'
,p_region_name=>'builder_home_lang_selector'
,p_region_template_options=>'#DEFAULT#:a-Region--noTopBorder:a-Region--paddedBody:a-Region--hideHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p( wwv_flow_lang.get_language_selector_list );'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_4000_ui.is_translation_installed( p_flow_id => 4750 )'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(72206598936569502.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(72206427080569501.4757)
,p_button_name=>'GET_STARTED'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\5165\9580')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.navigation.openInNewWindow(''https://apex.oracle.com/go/get_started_apps'');'
,p_button_css_classes=>'a-Button--dark'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(732460734927763715.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1212073696697771901.4757)
,p_button_name=>'ADMIN'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_image_alt=>unistr(' \7BA1\7406')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:RP,6::'
,p_button_css_classes=>'a-Button--simple'
,p_icon_css_classes=>'icon-tools'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(563554311979454950.4757)
,p_name=>'P50_SHOW_DEPRECATED'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(563554108117454948.4757)
,p_prompt=>unistr('\986F\793A\5DF2\88AB\53D6\4EE3\7684\9805\76EE')
,p_display_as=>'NATIVE_YES_NO'
,p_colspan=>4
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(714050802074570343.4757)
,p_name=>'P50_APP_GROUP'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1212073696697771901.4757)
,p_item_default=>'ALL'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\7FA4\7D44')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'PKG_APP_FILTERS'
,p_lov=>'.'||wwv_flow_api.id(732467706666833564.4757)||'.'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(1212080564184792020.4757)
,p_item_css_classes=>'apex-button-group'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'5'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1212073736306771902.4757)
,p_name=>'P50_SEARCH'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1212073696697771901.4757)
,p_prompt=>unistr('\641C\5C0B')
,p_placeholder=>unistr('\641C\5C0B\61C9\7528\7A0B\5F0F')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_tag_css_classes=>'a-Form-field--searchField'
,p_field_template=>wwv_flow_api.id(1212080564184792020.4757)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(714050997570570344.4757)
,p_name=>'Refresh Results'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P50_APP_GROUP'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(714051059562570345.4757)
,p_event_id=>wwv_flow_api.id(714050997570570344.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(714049707406570332.4757)
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(732459338726763701.4757)
,p_name=>'Search on Enter'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P50_SEARCH'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'this.browserEvent.keyCode === 13'
,p_bind_type=>'bind'
,p_bind_event_type=>'keypress'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(732459432253763702.4757)
,p_event_id=>wwv_flow_api.id(732459338726763701.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_api.id(714049707406570332.4757)
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(732459564476763703.4757)
,p_event_id=>wwv_flow_api.id(732459338726763701.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CANCEL_EVENT'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(916431938361196601.4757)
,p_name=>'show deprecated'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P50_SHOW_DEPRECATED'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(916432066418196602.4757)
,p_event_id=>wwv_flow_api.id(916431938361196601.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'Y'
);
end;
/
prompt --application/pages/page_00081
begin
wwv_flow_api.create_page(
 p_id=>81.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\61C9\7528\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_step_title=>unistr('\61C9\7528\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_icons.css" type="text/css" media="screen" charset="utf-8">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_frame.css" type="text/css" media="screen" charset="utf-8">',
'',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_details.css" type="text/css" media="screen" title="no title" charset="utf-8">',
'',
'<style>',
'span.ebaAppAvailable {',
'    display: inline-block;',
'    font: normal 14px/16px Arial, sans-serif;',
'    margin: 4px 5px 0 0;',
'    color: #f7941d;',
'    }',
'span.ebaAppInstalled {',
'    padding-left: 18px !important;',
'}',
'</style>'))
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// extend jQuery selectors with a non case sensitive version',
'apex.jQuery.extend($.expr[":"], {',
'  "containsNC": function(pElem, pIdx, pMatch, pArray) {',
'                  return (pElem.textContent || pElem.innerText || "").toLowerCase().indexOf((pMatch[3] || "").toLowerCase()) >= 0;',
'                }',
'});',
'',
'',
'function initInstantFilter(){',
'  var $apps    = apex.jQuery(''#applications''),',
'      $allApps = $apps.clone(),',
'      lTimer;',
'',
'  function filterApplications(){',
'    var $filteredApps = $allApps.find("li:has(h3:containsNC(''"+$v(''p50_SEARCH'')+"''))");',
'    $apps.quicksand($filteredApps, {',
'      adjustHeight: false,',
'      useScaling: false,',
'      duration: 400,',
'      easing: ''easeInOutQuad''',
'    });',
'  };',
'',
'  // set a fixed size for the containing DIV to avoid flickering',
'  $apps.parent().css(''height'', $apps.parent().height() + ''px'').css(''min-width'', $apps.parent().width() + ''px'');',
'',
'  // everytime something is entered in our search field we want to execute the filter,',
'  // but only after a short delay to avoid flickering animations',
'  apex.jQuery(''#p50_SEARCH'')',
'    .keyup(function(pEvent){',
'      if (lTimer != undefined) {',
'        clearTimeout(lTimer);',
'      };',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        filterApplications();',
'      } else {',
'        lTimer = setTimeout(filterApplications, 300);',
'      }',
'    })',
'    .keypress(function(pEvent){',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        pEvent.preventDefault();',
'        pEvent.stopImmediatePropagation();',
'      }',
'    });',
'',
'};',
''))
,p_javascript_code_onload=>'initInstantFilter();'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.ebaAppLocked {',
'  font: 12px/16px "Helvetica Neue",Helvetica,Arial,sans-serif;',
'  color: #080;',
'  display: inline-block;',
'  padding: 0 8px 0 8px;',
'}',
'',
'.ebaAppUnlocked {',
'  font: 12px/16px "Helvetica Neue",Helvetica,Arial,sans-serif;',
'  color: #080;',
'  display: inline-block;',
'  padding: 0 8px 0 8px;',
'}',
'',
'',
'#ebaAppFrameTable {',
'    display: table;',
'    width: 100%;',
'    table-layout: fixed;',
'}',
'div#ebaAppFrameLeft,',
'div#ebaAppFrameRight {',
'    display: table-cell;',
'    padding: 12px;',
'}',
'div#ebaAppFrameRight {',
'    width: 50%;',
'}',
'#ebaAppFrameRight img {',
'    max-width: 100%;',
'}'))
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_page_template_options=>'#DEFAULT#'
,p_deep_linking=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(806262870079109358.4757)
,p_plug_name=>'App Details'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_pkg_app_ui.p81_app_detail (',
'    p_app_id       => :app_id,',
'    p_app_session  => :app_session,',
'    p_pkg_app_id   => :P81_ID,',
'    p_app_type     => :P81_APP_TYPE',
'    );'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(777114631304055958.4757)
,p_branch_name=>'redirect to manage ws obj'
,p_branch_action=>'f?p=4350:2020:&SESSION.'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'MANAGE_WS_OBJ'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806263040716109358.4757)
,p_name=>'P81_APP_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(806262870079109358.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806264548412109366.4757)
,p_name=>'P81_APP_CAT'
,p_item_sequence=>20
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1494304242587239904.4757)
,p_name=>'P81_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(806262870079109358.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(740920159689190845.4757)
,p_name=>'RENDERING: App Detail Region - Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(806262870079109358.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(740920401661190846.4757)
,p_event_id=>wwv_flow_api.id(740920159689190845.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var lSuccessMsg = this.data.APEX_SUCCESS_MESSAGE,',
'      lUrl = ''f?p=&APP_ID.:81:&SESSION.::'',',
'      lVal = this.data[ ''REQUEST'' ]; ',
'',
'if ( lVal === "MANAGE_WS_OBJ") {',
'    lUrl = ''f?p=4350:2000:&SESSION.'';',
'}',
'',
'if ( lSuccessMsg ) {',
'   lUrl += ''&success_msg='' + lSuccessMsg;',
'}',
'setTimeout(function() {',
'    apex.navigation.redirect(lUrl);',
'}, 0);'))
);
end;
/
prompt --application/pages/page_00083
begin
wwv_flow_api.create_page(
 p_id=>83.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_icons.css" type="text/css" media="screen" charset="utf-8">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_frame.css" type="text/css" media="screen" charset="utf-8">',
'',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_details.css" type="text/css" media="screen" title="no title" charset="utf-8">',
'',
'<style>',
'span.ebaAppAvailable {',
'    display: inline-block;',
'    font: normal 14px/16px Arial, sans-serif;',
'    margin: 4px 5px 0 0;',
'    color: #f7941d;',
'    }',
'</style>'))
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// extend jQuery selectors with a non case sensitive version',
'apex.jQuery.extend($.expr[":"], {',
'  "containsNC": function(pElem, pIdx, pMatch, pArray) {',
'                  return (pElem.textContent || pElem.innerText || "").toLowerCase().indexOf((pMatch[3] || "").toLowerCase()) >= 0;',
'                }',
'});',
'',
'',
'function initInstantFilter(){',
'  var $apps    = apex.jQuery(''#applications''),',
'      $allApps = $apps.clone(),',
'      lTimer;',
'',
'  function filterApplications(){',
'    var $filteredApps = $allApps.find("li:has(h3:containsNC(''"+$v(''p50_SEARCH'')+"''))");',
'    $apps.quicksand($filteredApps, {',
'      adjustHeight: false,',
'      useScaling: false,',
'      duration: 400,',
'      easing: ''easeInOutQuad''',
'    });',
'  };',
'',
'  // set a fixed size for the containing DIV to avoid flickering',
'  $apps.parent().css(''height'', $apps.parent().height() + ''px'').css(''min-width'', $apps.parent().width() + ''px'');',
'',
'  // everytime something is entered in our search field we want to execute the filter,',
'  // but only after a short delay to avoid flickering animations',
'  apex.jQuery(''#p50_SEARCH'')',
'    .keyup(function(pEvent){',
'      if (lTimer != undefined) {',
'        clearTimeout(lTimer);',
'      };',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        filterApplications();',
'      } else {',
'        lTimer = setTimeout(filterApplications, 300);',
'      }',
'    })',
'    .keypress(function(pEvent){',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        pEvent.preventDefault();',
'        pEvent.stopImmediatePropagation();',
'      }',
'    });',
'',
'};',
''))
,p_javascript_code_onload=>'initInstantFilter();'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(806250634212071966)
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492806582211498053.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492807719360498054.4757)
,p_plug_name=>unistr('\7121\6548\7684 Web \8A66\7B97\8868\7269\4EF6')
,p_region_template_options=>'#DEFAULT#:a-Alert--defaultIcons:a-Alert--danger:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(746534672114889110.4757)
,p_plug_display_sequence=>60
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wiz_confirm.create_warning_page (',
'   -- p_title       => wwv_flow_lang.system_message(''INVALID_WS_OBJ''),',
'    p_warning_msg => wwv_flow_lang.system_message(''INVALID_WS_OBJ_WARNING_MSG''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>':P83_WS_OBJ_VALID = ''N'' and :P81_APP_TYPE = ''WEBSHEET'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492807966046498055.4757)
,p_plug_name=>'App Details Container'
,p_region_name=>'ebaAppFrameTable'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492809197937498056.4757)
,p_plug_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'(:P83_WS_OBJ_VALID = ''Y'' and :P81_APP_TYPE = ''WEBSHEET'' ) or (:P81_APP_TYPE = ''DATABASE'')'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(755605410130924611.4757)
,p_plug_name=>'navigation'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-WizardSteps--slim'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_01'
,p_list_id=>wwv_flow_api.id(755598782624864560.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_global.g_cloud'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492806784251498053.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(492806582211498053.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492806982934498053.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(492806582211498053.4757)
,p_button_name=>'INSTALL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'(:P83_WS_OBJ_VALID = ''Y'' and :P81_APP_TYPE = ''WEBSHEET'' ) or (:P81_APP_TYPE = ''DATABASE'')'
,p_button_condition_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492807171037498054.4757)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(492806582211498053.4757)
,p_button_name=>'MANAGE_WS_OBJ'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\7BA1\7406 Web \8A66\7B97\8868\8CC7\6599\5EAB\7269\4EF6')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_condition=>':P83_WS_OBJ_VALID = ''N'' and :P81_APP_TYPE = ''WEBSHEET'''
,p_button_condition_type=>'PLSQL_EXPRESSION'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
,p_security_scheme=>wwv_flow_api.id(404682514053862570)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(773648480184613772.4757)
,p_button_sequence=>5
,p_button_plug_id=>wwv_flow_api.id(492806582211498053.4757)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404711161197908978.4757)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:828:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'icon-left-chevron'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1164738054380456686.4757)
,p_branch_action=>'f?p=&APP_ID.:85:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492807558146498054.4757)
,p_name=>'P83_WS_OBJ_VALID'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(492806582211498053.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492808175757498055.4757)
,p_name=>'P83_APPLICATION_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(492807966046498055.4757)
,p_source=>'P828_APPLICATION_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492808368447498055.4757)
,p_name=>'P83_NEW_APP_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(492807966046498055.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492808536427498055.4757)
,p_name=>'P83_NEW_APP_URL'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(492807966046498055.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492808783233498056.4757)
,p_name=>'P83_INSTALLING_APP_MSG'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(492807966046498055.4757)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_lang.system_message(''WAITING.APP_DEFINITION'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'I'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492809321058498056.4757)
,p_name=>'P83_APP_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_name  varchar2(255);',
'begin',
'  if :P81_APP_TYPE = ''DATABASE'' then ',
'    select app_name into l_name from wwv_flow_pkg_applications',
'     where apex_application_id = :P828_APPLICATION_ID;',
'  else',
'      select app_name into l_name from wwv_flow_pkg_applications',
'       where apex_websheet_id = :P828_APPLICATION_ID;',
'  end if;',
'  return l_name;',
'end;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492809562160498057.4757)
,p_name=>'P83_AUTH'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'APEX'
,p_prompt=>unistr('\8A8D\8B49:')
,p_source=>'P828_AUTH'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'PACKAGED_APP_AUTH_OPTION'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'       name_with_prefix      as r',
'  from wwv_flow_native_plugins',
' where plugin_type = ''AUTHENTICATION TYPE''',
'   and (          name_with_prefix = ''NATIVE_APEX_ACCOUNTS''',
'         or (     name_with_prefix = ''NATIVE_HTTP_HEADER_VARIABLE''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_HHEAD'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_LDAP''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_LDAP'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_IAS_SSO''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_SSO'') = ''Y'' ))',
'union all',
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_CLOUD_IDM''),',
'       ''NATIVE_CLOUD_IDM''',
'  from sys.dual',
' where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''))
,p_tag_attributes=>'class="fieldtitlebold"'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492809777586498058.4757)
,p_name=>'P83_WORKSPACE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5DE5\4F5C\5340\540D\7A31:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select DISPLAY_NAME',
'from WWV_FLOW_COMPANIES',
'where PROVISIONING_COMPANY_ID = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492809901309498058.4757)
,p_name=>'P83_SCHEMA'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_prompt=>unistr('\7DB1\8981:')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cHeight=>1
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492810186398498058.4757)
,p_name=>'P83_PROVIDER_COMPANY'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\63D0\4F9B\8005:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select provider_company',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and provider_company is not null',
'  '))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492810398893498058.4757)
,p_name=>'P83_PROVIDER_EMAIL'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\63D0\4F9B\8005\96FB\5B50\90F5\4EF6:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select provider_email',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and provider_email is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492810514979498059.4757)
,p_name=>'P83_MIN_APEX_VERSION'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6700\5C0F\7248\672C:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select min_apex_version',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and min_apex_version is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492810758910498059.4757)
,p_name=>'P83_RELEASED'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\767C\884C\6642\9593:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select released',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and released is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492810994357498059.4757)
,p_name=>'P83_LANGUAGES'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(492809197937498056.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8A9E\8A00:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select languages',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and languages is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492811213703498060.4757)
,p_computation_sequence=>20
,p_computation_item=>'P83_WS_OBJ_VALID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_setup.all_object_valid2 then',
'  return ''Y'';',
'else',
'  return ''N'';',
'end if;'))
,p_compute_when=>'P81_APP_TYPE'
,p_compute_when_text=>'WEBSHEET'
,p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(755607951952004526.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(492806784251498053.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(755608227306004531.4757)
,p_event_id=>wwv_flow_api.id(755607951952004526.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(777115148935082355.4757)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog when Manage WS Obj clicked'
,p_attribute_01=>'REQUEST'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(492807171037498054.4757)
);
end;
/
prompt --application/pages/page_00085
begin
wwv_flow_api.create_page(
 p_id=>85.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'window.setTimeout(function() { apex.submit("INSTALL"); }, 100);'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1164691126616397394.4757)
,p_plug_name=>unistr('\6B63\5728\5B89\88DD\61C9\7528\7A0B\5F0F...')
,p_region_template_options=>'#DEFAULT#:a-ProcessingRegion--dialog'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1164683681838385745.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1164736841004441978.4757)
,p_branch_name=>'failure'
,p_branch_action=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
,p_branch_condition_type=>'EXISTS'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from htmldb_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P83_NEW_APP_ID',
'and c002 = ''FAIL'''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1164736076863434590.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Install Application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P83_NEW_APP_ID := wwv_flow_pkg_app_install.install (',
'                       p_app_type          => :P81_APP_TYPE,',
'                       p_app_id            => :P83_APPLICATION_ID,',
'                       p_schema            => :P83_SCHEMA,',
'                       p_auth_scheme       => (case when wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'' then ''NATIVE_CLOUD_IDM'' else :P83_AUTH end),',
'                       p_auth_attribute_01 => :P828_ATTRIBUTE_01,',
'                       p_auth_attribute_02 => :P828_ATTRIBUTE_02,',
'                       p_auth_attribute_03 => :P828_ATTRIBUTE_03,',
'                       p_auth_attribute_04 => :P828_ATTRIBUTE_04,',
'                       p_auth_attribute_05 => :P828_ATTRIBUTE_05,',
'                       p_auth_attribute_06 => :P828_ATTRIBUTE_06,',
'                       p_auth_attribute_07 => :P828_ATTRIBUTE_07,',
'                       p_auth_attribute_08 => :P828_ATTRIBUTE_08,',
'                       p_auth_attribute_09 => :P828_ATTRIBUTE_09,',
'                       p_auth_attribute_10 => :P828_ATTRIBUTE_10,',
'                       p_auth_attribute_11 => :P828_ATTRIBUTE_11,',
'                       p_auth_attribute_12 => :P828_ATTRIBUTE_12,',
'                       p_auth_attribute_13 => :P828_ATTRIBUTE_13,',
'                       p_auth_attribute_14 => :P828_ATTRIBUTE_14,',
'                       p_auth_attribute_15 => :P828_ATTRIBUTE_15 );'))
,p_process_error_message=>unistr('\672A\9806\5229\5B89\88DD\61C9\7528\7A0B\5F0F. #SQLERRM#')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\5B89\88DD\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(973961926573400229.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog if no error'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_error_cnt number := 0;',
'begin',
'    select count(*)',
'    into l_error_cnt',
'    from htmldb_collections',
'    where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P83_NEW_APP_ID',
'    and c002 = ''FAIL'';',
'',
'    if l_error_cnt = 0 then',
'        return true; -- all done close dialog',
'    else',
'        return false; -- go view error',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
,p_process_success_message=>unistr('\5DF2\5B89\88DD\61C9\7528\7A0B\5F0F.')
);
end;
/
prompt --application/pages/page_00100
begin
wwv_flow_api.create_page(
 p_id=>100.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8981\6C42\670D\52D9 - \6307\5B9A\8981\6C42')
,p_step_title=>unistr('\8981\6C42\670D\52D9 - \6307\5B9A\8981\6C42')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741371098457994312.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(404682514053862570)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_request.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801839146826764574.4757)
,p_plug_name=>'Train'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(805118624066572072.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801839541541764582.4757)
,p_plug_name=>unistr('\6307\5B9A\8981\6C42')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801839357425764582.4757)
,p_plug_name=>unistr('\8868\683C\7A7A\9593\4F7F\7528\72C0\6CC1')
,p_parent_plug_id=>wwv_flow_api.id(801839541541764582.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(805116320497552727.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(798348984564602568.4757)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801840419433764585.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801841243734764587.4757)
,p_plug_name=>unistr('\8981\6C42\670D\52D9')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801840618419764586.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(801840419433764585.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801840884780764586.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(801840419433764585.4757)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801842048706764595.4757)
,p_branch_name=>'Go To Page 101'
,p_branch_action=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.::::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P100_SERVICE'
,p_branch_condition_text=>'STORAGE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801842271287764596.4757)
,p_branch_name=>'Go To Page 102'
,p_branch_action=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P100_SERVICE'
,p_branch_condition_text=>'TERMINATION'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801842633404764597.4757)
,p_branch_name=>'Go To Page 104'
,p_branch_action=>'104'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>40
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801839703900764582.4757)
,p_name=>'P100_SERVICE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(801839541541764582.4757)
,p_item_default=>'STORAGE'
,p_prompt=>unistr('\6307\5B9A\60F3\8981\6C42\7684\670D\52D9\985E\578B:')
,p_source=>'STORAGE'
,p_source_type=>'STATIC'
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.WIZARD_SELECTION'
,p_named_lov=>'REQEUEST SERVICE'
,p_lov=>'.'||wwv_flow_api.id(801842749107764598.4757)||'.'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\4E00\500B\670D\52D9\8B8A\66F4\8981\6C42, \7136\5F8C\6309\4E00\4E0B<b>\4E0B\4E00\6B65</b>.')
,p_attribute_01=>'S'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801841802306764590.4757)
,p_validation_name=>'Validate storage request size'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from wwv_flow_workspace_req_size',
' where request_type = ''C''',
'   and display = ''Y''',
'   and req_size = :P100_STORAGE'))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('\8981\6C42\7684\5132\5B58\6578\91CF\7121\6548.')
,p_when_button_pressed=>wwv_flow_api.id(168276114972961093.4757)
,p_associated_item=>wwv_flow_api.id(.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00101
begin
wwv_flow_api.create_page(
 p_id=>101.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8981\6C42\66F4\591A\5132\5B58 - \5B9A\7FA9\8981\6C42')
,p_step_title=>unistr('\8981\6C42\66F4\591A\5132\5B58 - \5B9A\7FA9\8981\6C42')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741371098457994312.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(404682514053862570)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_request.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805258536099937778.4757)
,p_plug_name=>'Train'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805131422007607886.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(805118624066572072.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_translate_title=>'N'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(805258798079937778.4757)
,p_name=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_template=>wwv_flow_api.id(740771588500180474.4757)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select owner schemas, tablespace_name tablespaces',
'  from sys.dba_segments',
' where owner in (select schema',
'                   from wwv_flow_company_schemas',
'                  where security_group_id = wwv_flow.get_sgid)',
'group by owner, tablespace_name'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'1'
,p_query_row_count_max=>5000
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805258905056937779.4757)
,p_query_column_id=>1
,p_column_alias=>'SCHEMAS'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\7DB1\8981')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805259030210937779.4757)
,p_query_column_id=>2
,p_column_alias=>'TABLESPACES'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\8868\683C\7A7A\9593')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805258369325937778.4757)
,p_plug_name=>unistr('\8868\683C\7A7A\9593\4F7F\7528\72C0\6CC1')
,p_parent_plug_id=>wwv_flow_api.id(805258798079937778.4757)
,p_region_template_options=>'#DEFAULT#:a-Region--flush:is-collapsed:a-Region--noBorder'
,p_component_template_options=>'#DEFAULT#:a-LinksList--nowrap:a-LinksList--showArrow'
,p_plug_template=>wwv_flow_api.id(805699740467941340.4757)
,p_plug_display_sequence=>30
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(805116320497552727.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805259837740937783.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805260603804937785.4757)
,p_plug_name=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805260069728937783.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805259837740937783.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805260294188937784.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(805259837740937783.4757)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805260494925937785.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805259837740937783.4757)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404711161197908978.4757)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.::::'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805261149037937786.4757)
,p_branch_action=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(805260294188937784.4757)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805259164510937779.4757)
,p_name=>'P101_STORAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(805258798079937778.4757)
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_default number;',
'begin',
'    for c1 in (select req_size',
'                 from wwv_flow_workspace_req_size',
'                where request_type = ''C''',
'                  and default_size = ''Y'') loop',
'        l_default := c1.req_size;',
'        exit;',
'    end loop;',
'    return l_default;',
'end;'))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>unistr('\8981\65B0\589E\7684\5132\5B58\5927\5C0F (MB):')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select req_size d, req_size r',
'  from wwv_flow_workspace_req_size',
' where request_type = ''C''',
'   and display = ''Y''',
' order by to_number(d)'))
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\6307\5B9A\8981\65B0\589E\7684\7A7A\9593\5927\5C0F.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805260932553937785.4757)
,p_validation_name=>'Validate storage request size'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from wwv_flow_workspace_req_size',
' where request_type = ''C''',
'   and display = ''Y''',
'   and req_size = :P101_STORAGE'))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('\8981\6C42\7684\5132\5B58\6578\91CF\7121\6548.')
,p_when_button_pressed=>wwv_flow_api.id(805260294188937784.4757)
,p_associated_item=>wwv_flow_api.id(805259164510937779.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00102
begin
wwv_flow_api.create_page(
 p_id=>102.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8981\6C42\7D42\6B62\670D\52D9 - \5B9A\7FA9\8981\6C42')
,p_step_title=>unistr('\8981\6C42\7D42\6B62\670D\52D9 - \5B9A\7FA9\8981\6C42')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741371098457994312.4757)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_request.htm'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(805272606936000230.4757)
,p_name=>unistr('\751F\7522\529B\548C\7BC4\4F8B\61C9\7528\7A0B\5F0F')
,p_template=>wwv_flow_api.id(662132465401686364.4757)
,p_display_sequence=>80
,p_region_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.app_name as name',
'from wwv_flows f,',
'    wwv_flow_pkg_app_map m,',
'    wwv_flow_pkg_applications a',
'where f.id = m.installed_app_id',
'    and f.security_group_id = m.security_group_id',
'    and m.app_id = a.apex_application_id',
'    and f.security_group_id = :flow_security_group_id',
'order by upper(a.app_name)'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flows f,',
'    wwv_flow_pkg_app_map m,',
'    wwv_flow_pkg_applications a',
'where f.id = m.installed_app_id',
'    and f.security_group_id = m.security_group_id',
'    and m.app_id = a.apex_application_id',
'    and f.security_group_id = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>5
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805272814245000231.4757)
,p_query_column_id=>1
,p_column_alias=>'NAME'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(805272990153000231.4757)
,p_name=>unistr('\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F')
,p_template=>wwv_flow_api.id(662132465401686364.4757)
,p_display_sequence=>60
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id || ''. '' || f.name as name',
'from wwv_flow_visible_flows f',
'where f.build_status != ''RUN_AND_HIDDEN''',
'order by f.id',
''))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_visible_flows f',
'where f.build_status != ''RUN_AND_HIDDEN'''))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>5
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\4EFB\4F55\300C\8CC7\6599\5EAB\61C9\7528\7A0B\5F0F\300D.')
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805273143153000231.4757)
,p_query_column_id=>1
,p_column_alias=>'NAME'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(805273272750000232.4757)
,p_name=>unistr('Web \8A66\7B97\8868\61C9\7528\7A0B\5F0F')
,p_template=>wwv_flow_api.id(662132465401686364.4757)
,p_display_sequence=>70
,p_region_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ws.name',
'from wwv_flow_ws_applications ws',
'where ws.security_group_id = :flow_security_group_id',
'order by ws.name'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_ws_applications ws',
'where ws.security_group_id = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>5
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\4EFB\4F55\300CWeb \8A66\7B97\8868\61C9\7528\7A0B\5F0F\300D.')
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805273439749000232.4757)
,p_query_column_id=>1
,p_column_alias=>'NAME'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(805273581162000232.4757)
,p_name=>unistr('\7D42\6B62\5DE5\4F5C\5340\670D\52D9')
,p_template=>wwv_flow_api.id(740771588500180474.4757)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT ',
'   "WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" "PROVISIONING_COMPANY_ID", ',
'   "WWV_FLOW_COMPANIES"."SHORT_NAME" "SHORT_NAME", ',
'   "WWV_FLOW_COMPANIES"."FIRST_SCHEMA_PROVISIONED" "FIRST_SCHEMA_PROVISIONED"',
'FROM ',
'   "WWV_FLOW_COMPANIES"',
'WHERE (("WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" =wwv_flow.get_sgid))'))
,p_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table role="presentation"><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/wiz_terminate_service_140x90.png" border="0" width="140" height="90" alt="&PRODUCT_NAME." /></td><td valign="top">',
unistr('<p>\5DE5\4F5C\5340\7BA1\7406\54E1\53EF\4EE5\4F7F\7528\6B64\9801\9762\4F86\8981\6C42\7D42\6B62\670D\52D9.</p>')))
,p_footer=>'</td></tr></table><p />'
,p_fixed_header=>'NONE'
,p_query_row_template=>2
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805273769889000233.4757)
,p_query_column_id=>1
,p_column_alias=>'PROVISIONING_COMPANY_ID'
,p_column_display_sequence=>1
,p_column_heading=>'Workspace'
,p_column_alignment=>'RIGHT'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805273860118000233.4757)
,p_query_column_id=>2
,p_column_alias=>'SHORT_NAME'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\5DE5\4F5C\5340\540D\7A31')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805273906981000233.4757)
,p_query_column_id=>3
,p_column_alias=>'FIRST_SCHEMA_PROVISIONED'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\7B2C\4E00\500B\4F48\5EFA\7684\7DB1\8981')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(805274073022000233.4757)
,p_name=>unistr('\7DB1\8981')
,p_template=>wwv_flow_api.id(662132465401686364.4757)
,p_display_sequence=>30
,p_region_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.schema, u.default_tablespace name2',
'  from wwv_flow_company_schemas a, ',
'       sys.dba_users u',
' where a.schema = u.username',
'   and a.security_group_id = wwv_flow.get_sgid',
'order by 1'))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>5
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805274240952000233.4757)
,p_query_column_id=>1
,p_column_alias=>'SCHEMA'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\7DB1\8981')
,p_use_as_row_header=>'N'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805274359482000233.4757)
,p_query_column_id=>2
,p_column_alias=>'NAME2'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\9810\8A2D\8868\683C\7A7A\9593')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805274974032000236.4757)
,p_plug_name=>'Train'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805131422007607886.4757)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(805118624066572072.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805275199714000236.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>90
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805275910850000237.4757)
,p_plug_name=>unistr('\8981\6C42\7D42\6B62\670D\52D9')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(3997966695170997515.4757)
,p_name=>unistr('\61C9\7528\7A0B\5F0F\958B\767C\4EBA\54E1')
,p_template=>wwv_flow_api.id(662132465401686364.4757)
,p_display_sequence=>50
,p_region_template_options=>'#DEFAULT#'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select userid as the_name',
'from WWV_FLOW_DEVELOPERS',
'where SECURITY_GROUP_ID = :flow_security_group_id',
'order by userid'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from WWV_FLOW_DEVELOPERS',
'where SECURITY_GROUP_ID = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>5
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\8CC7\6599')
,p_query_num_rows_type=>'ROW_RANGES_WITH_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(3997966781041997516.4757)
,p_query_column_id=>1
,p_column_alias=>'THE_NAME'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805275772762000236.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805275199714000236.4757)
,p_button_name=>'PREVIOUS'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404711161197908978.4757)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805275386587000236.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805275199714000236.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805275530546000236.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(805275199714000236.4757)
,p_button_name=>'REQUEST_SERVICE_TERMINATION'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805276231252000237.4757)
,p_branch_name=>'Go To Page 105'
,p_branch_action=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.::::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(805275530546000236.4757)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805276412217000237.4757)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(805275772762000236.4757)
,p_branch_sequence=>20
);
end;
/
prompt --application/pages/page_00103
begin
wwv_flow_api.create_page(
 p_id=>103.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8A73\7D30\7684\8868\683C\7A7A\9593\4F7F\7528\72C0\6CC1\5831\8868')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\8A73\7D30\7684\8868\683C\7A7A\9593\4F7F\7528\72C0\6CC1\5831\8868')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741365982136994250.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'300'
,p_dialog_width=>'500'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_request.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(722741717956798645.4757)
,p_plug_name=>unistr('\6309\9215')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(805141851656673659.4757)
,p_name=>unistr('\8868\683C\7A7A\9593\4F7F\7528\72C0\6CC1')
,p_template=>wwv_flow_api.id(404667570222803088.4757)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--noBorders:a-Report--stretch'
,p_new_grid_row=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
' with workspace_tablespace as',
'    ( select distinct default_tablespace',
'        from sys.dba_users',
'       where username in ',
'             (select schema',
'                from wwv_flow_company_schemas',
'               where security_group_id = (select wwv_flow.get_sgid from sys.dual where rownum = 1))',
'    )',
'select tm.tablespace_name name,',
'       tm.tablespace_size * ts.block_size bytes,',
'       (tm.tablespace_size-tm.used_space) * ts.block_size free,',
'       tm.used_space * ts.block_size used,',
'       tm.used_percent pct_used',
'  from workspace_tablespace wt,',
'       sys.dba_tablespaces  ts,',
'       sys.dba_tablespace_usage_metrics tm',
' where wt.default_tablespace = ts.tablespace_name',
'   and ts.tablespace_name    = tm.tablespace_name',
''))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>15
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
,p_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4350P4651a */ name, bytes, bytes-free used, free, (bytes-free)/bytes*100 pct_used from',
'(select t.tablespace_name name,',
'       ( select sum(user_blocks * t.block_size)',
'             from sys.dba_data_files',
'            where tablespace_name = t.tablespace_name ) bytes,',
'       ( select sum(bytes)',
'             from sys.dba_free_space',
'            where tablespace_name = t.tablespace_name ) free ',
'   from sys.dba_tablespaces t',
'  where tablespace_name in (select default_tablespace',
'           from sys.dba_users where username in (select schema from wwv_flow_company_schemas',
'           where security_group_id= (select wwv_flow.get_sgid ',
'                                       from dual ',
'                                      where rownum = 1))))',
'  order by 1  '))
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805142091523673660.4757)
,p_query_column_id=>1
,p_column_alias=>'NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\8868\683C\7A7A\9593\540D\7A31')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805142126725673660.4757)
,p_query_column_id=>2
,p_column_alias=>'BYTES'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\4F4D\5143\7D44')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805142207100673660.4757)
,p_query_column_id=>3
,p_column_alias=>'FREE'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\53EF\7528\5927\5C0F')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805142365645673660.4757)
,p_query_column_id=>4
,p_column_alias=>'USED'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\5DF2\4F7F\7528\5927\5C0F')
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G990'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805142477549673660.4757)
,p_query_column_id=>5
,p_column_alias=>'PCT_USED'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\5DF2\4F7F\7528\767E\5206\6BD4')
,p_use_as_row_header=>'N'
,p_column_format=>'999D99'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_lov_show_nulls=>'NO'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(722741894574798646.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(722741717956798645.4757)
,p_button_name=>'Cancel'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(722741938879798647.4757)
,p_process_sequence=>10
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Modal'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00104
begin
wwv_flow_api.create_page(
 p_id=>104.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\8981\6C42\66F4\591A\5132\5B58 - \78BA\8A8D')
,p_step_title=>unistr('\8981\6C42\66F4\591A\5132\5B58 - \78BA\8A8D')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741371098457994312.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(404682514053862570)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_request.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805365003320561422.4757)
,p_plug_name=>'Train'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805131422007607886.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(805118624066572072.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805365463411561424.4757)
,p_plug_name=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_header=>unistr('<p>\8ACB\78BA\8A8D\60A8\7684\8981\6C42.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805365201908561424.4757)
,p_plug_name=>unistr('\8868\683C\7A7A\9593\4F7F\7528\72C0\6CC1')
,p_parent_plug_id=>wwv_flow_api.id(805365463411561424.4757)
,p_region_template_options=>'#DEFAULT#:a-Region--flush:is-collapsed:a-Region--noBorder'
,p_component_template_options=>'#DEFAULT#:a-LinksList--nowrap:a-LinksList--showArrow'
,p_plug_template=>wwv_flow_api.id(805699740467941340.4757)
,p_plug_display_sequence=>20
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(805116320497552727.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805366320719561427.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805367101650561428.4757)
,p_plug_name=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805366969714561428.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805366320719561427.4757)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404711161197908978.4757)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.::::'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805366500519561427.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805366320719561427.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805366770901561427.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(805366320719561427.4757)
,p_button_name=>'ADJUST_STORAGE_SIZE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\8981\6C42\66F4\591A\5132\5B58')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805367883498561432.4757)
,p_branch_action=>'6'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805365673184561424.4757)
,p_name=>'P104_STORAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(805365463411561424.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_default number;',
'begin',
'    for c1 in (select req_size',
'                 from wwv_flow_workspace_req_size',
'                where request_type = ''C''',
'                  and default_size = ''Y'') loop',
'        l_default := c1.req_size;',
'        exit;',
'    end loop;',
'    return l_default;',
'end;'))
,p_item_default_type=>'PLSQL_FUNCTION_BODY'
,p_prompt=>unistr('\8981\65B0\589E\7684\5132\5B58\5927\5C0F (MB):')
,p_source=>'&P101_STORAGE.'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\9700\8981\7684\7A7A\9593\5927\5C0F.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805367465527561428.4757)
,p_validation_name=>'Validate storage request size'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from wwv_flow_workspace_req_size',
' where request_type = ''C''',
'   and display = ''Y''',
'   and req_size = :P101_STORAGE'))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('\8981\6C42\7684\5132\5B58\6578\91CF\7121\6548.')
,p_when_button_pressed=>wwv_flow_api.id(805366770901561427.4757)
,p_associated_item=>wwv_flow_api.id(805365673184561424.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805367558322561428.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'request change of size'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_changesize  number := :P101_STORAGE;',
'begin',
'  wwv_flow_provisioning.make_modification_request (',
'      p_service_name        => ''CHANGE_DB_SIZE'',',
'      p_service_attribute_1 => l_changesize,',
'      p_service_attribute_2 => wwv_flow_user_api.get_email(p_username => upper(wwv_flow.g_user)));',
'end;'))
,p_process_error_message=>unistr('\8981\6C42\984D\5916\5132\5B58\6642\767C\751F\932F\8AA4.')
,p_process_when_button_id=>wwv_flow_api.id(805366770901561427.4757)
,p_process_success_message=>unistr('\60A8\8981\6C42 &P101_STORAGE. MB \7684\984D\5916\5132\5B58.')
,p_security_scheme=>wwv_flow_api.id(805427695742857816)
);
end;
/
prompt --application/pages/page_00105
begin
wwv_flow_api.create_page(
 p_id=>105.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\4F48\5EFA: \8981\6C42\670D\52D9\7D42\6B62')
,p_step_title=>unistr('\4F48\5EFA: \8981\6C42\670D\52D9\7D42\6B62')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(741371098457994312.4757)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_request.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805379747924646516.4757)
,p_plug_name=>unistr('\78BA\8A8D\7D42\6B62\670D\52D9')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5DE5\4F5C\5340\7BA1\7406\54E1\53EF\4EE5\4F7F\7528\6B64\9801\9762\4F86\8981\6C42\7D42\6B62\4ED6\5011\76EE\524D\9023\7DDA\7684\670D\52D9.<br/><br/>'),
'',
unistr('<b>\91CD\8981\4E8B\9805!</b>: \7576\60A8\7684\670D\52D9\7D42\6B62\5F8C, \6240\6709\7684\8CC7\6599\3001\8CC7\6599\5EAB\7269\4EF6\3001\8CC7\6599\5EAB\7DB1\8981\3001\8868\683C\7A7A\9593\3001\61C9\7528\7A0B\5F0F\3001\547D\4EE4\6A94\3001\6A94\6848\7B49\90FD\6703\88AB\79FB\9664.</p>'),
'',
unistr('<p>\8ACB\78BA\8A8D\8981\7D42\6B62\60A8\7684\670D\52D9.</p>')))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805380179815646516.4757)
,p_plug_name=>'Train'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805131422007607886.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(805118624066572072.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805380363605646517.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805380918641646517.4757)
,p_plug_name=>unistr('\8981\6C42\7D42\6B62\670D\52D9')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'DEFAULT'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805380532647646517.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805380363605646517.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805380789015646517.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805380363605646517.4757)
,p_button_name=>'TERMINATE_SERVICE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\7D42\6B62\670D\52D9')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805381622541646518.4757)
,p_branch_action=>'6'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_when_button_id=>wwv_flow_api.id(805380789015646517.4757)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805381240615646518.4757)
,p_validation_name=>'terminate service request exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from WWV_FLOW_PROVISION_SERICE_MOD',
' where request_status = ''REQUESTED''',
'   and service_name = ''REMOVE_EXISTING_SERVICE''',
'   and SECURITY_GROUP_ID = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('\6B64\5DE5\4F5C\5340\7684\670D\52D9\7D42\6B62\8981\6C42\5DF2\7D93\5B58\5728.')
,p_when_button_pressed=>wwv_flow_api.id(805380789015646517.4757)
,p_associated_item=>wwv_flow_api.id(.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805381315107646518.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'terminate service'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  wwv_flow_provisioning.make_modification_request(',
'    p_security_group_id    => :flow_security_group_id,',
'    p_service_name         => ''REMOVE_EXISTING_SERVICE'',',
'    p_service_attribute_2  => wwv_flow_user_api.get_email(p_username => upper(wwv_flow.g_user)));',
'end;'))
,p_process_error_message=>unistr('\9001\51FA\7D42\6B62\670D\52D9\8981\6C42\6642\767C\751F\932F\8AA4.')
,p_process_when_button_id=>wwv_flow_api.id(805380789015646517.4757)
,p_process_success_message=>unistr('\5DF2\9001\51FA\670D\52D9\7D42\6B62\8981\6C42.')
);
end;
/
prompt --application/pages/page_00210
begin
wwv_flow_api.create_page(
 p_id=>210.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'deploy_pa_install_obj.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(656909453831982642.4757)
,p_plug_name=>unistr('\652F\63F4\7684\7269\4EF6\5B89\88DD\932F\8AA4')
,p_region_template_options=>'#DEFAULT#:a-Alert--defaultIcons:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(746534672114889110.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from htmldb_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P83_NEW_APP_ID',
'and c001 = ''PREREQ_CHECK'''))
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('\61C9\7528\7A0B\5F0F\5DF2\5B89\88DD.  \4E0D\904E, \5B89\88DD\8CC7\6599\5EAB\7269\4EF6\548C\7A2E\7C7D\8CC7\6599\5931\6557.')
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(656998326917093004.4757)
,p_name=>unistr('\5B89\88DD\6458\8981')
,p_parent_plug_id=>wwv_flow_api.id(656909453831982642.4757)
,p_template=>wwv_flow_api.id(662132465401686364.4757)
,p_display_sequence=>15
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 script_name, ',
'       decode(c002, ''SUCCESS'', ',
'                    wwv_flow_lang.system_message(''INSTALLER.SCRIPT.SUCCESS''),',
'                    ''FAIL'',',
'                    wwv_flow_lang.system_message(''INSTALLER.SCRIPT.FAIL'')) status,        ',
'       to_number(nvl(c003,0)) fail_count,',
'       to_number(nvl(c004,0)) success_count,',
'       c003 + c004 total_count',
'  from htmldb_collections',
' where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P83_NEW_APP_ID',
' and c001 != ''PREREQ_CHECK'''))
,p_ajax_enabled=>'Y'
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>50
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\4EFB\4F55\5B89\88DD\7D50\679C')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(656998676759093019.4757)
,p_query_column_id=>1
,p_column_alias=>'SCRIPT_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\547D\4EE4\6A94\540D\7A31')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(656998741553093019.4757)
,p_query_column_id=>2
,p_column_alias=>'STATUS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\72C0\614B')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(656998866154093019.4757)
,p_query_column_id=>3
,p_column_alias=>'FAIL_COUNT'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\767C\751F\932F\8AA4\7684\6558\8FF0\53E5')
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(656998981674093019.4757)
,p_query_column_id=>4
,p_column_alias=>'SUCCESS_COUNT'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\6210\529F\7684\6558\8FF0\53E5')
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(656999010775093019.4757)
,p_query_column_id=>5
,p_column_alias=>'TOTAL_COUNT'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\6558\8FF0\53E5\7E3D\6578')
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(657004620656135228.4757)
,p_plug_name=>unistr('\932F\8AA4')
,p_parent_plug_id=>wwv_flow_api.id(656909453831982642.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(662132465401686364.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'for c1 in (select c001 script_name, clob001 errors ',
'           from htmldb_collections ',
'           where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P83_NEW_APP_ID',
'           and c001 != ''PREREQ_CHECK''',
'           and length(clob001) > 0)',
'loop',
'  sys.htp.p(''<b>''||wwv_flow_escape.html(c1.script_name)||''</b>'');',
'  sys.htp.p(''<pre>'');',
'  wwv_flow_sw_script.escape_sc_clob(c1.errors);',
'  sys.htp.p(''</pre>'');',
'end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>wwv_flow_api.id(539932723203132393.4757)
,p_plug_query_num_rows=>50
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(759862650080504786.4757)
,p_plug_name=>'wizard buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--wizard'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1136583887364333643.4757)
,p_plug_name=>unistr('\5148\6C7A\689D\4EF6\6AA2\67E5\5931\6557')
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_plug_template=>wwv_flow_api.id(746534672114889110.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from htmldb_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P83_NEW_APP_ID',
'and c001 = ''PREREQ_CHECK'''))
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1136583922609333644.4757)
,p_plug_name=>unistr('\932F\8AA4')
,p_parent_plug_id=>wwv_flow_api.id(1136583887364333643.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001 script_name, clob001 errors ',
'           from htmldb_collections ',
'           where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P83_NEW_APP_ID',
'           and c001 = ''PREREQ_CHECK''',
'           and length(clob001) > 0)',
'loop',
'    -- note: wwv_flow_pkg_app_install.prereq_check_bf_install populates formatted message with HTML tag if prerequisite check fails, don''t escape',
'    sys.htp.p( c1.errors );',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(662060974943577546.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(759862650080504786.4757)
,p_button_name=>'Close'
,p_button_action=>'SUBMIT'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\95DC\9589')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_alignment=>'LEFT'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(758898716821185198.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(662060974943577546.4757)
);
end;
/
prompt --application/pages/page_00234
begin
wwv_flow_api.create_page(
 p_id=>234.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_required_role=>wwv_flow_api.id(806250634212071966)
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492883013793780169.4757)
,p_plug_name=>'Unlock Application'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>35
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\82E5\89E3\9664\9396\5B9A\751F\7522\529B\61C9\7528\7A0B\5F0F, \61C9\7528\7A0B\5F0F<strong>\65E5\5F8C\5C07\7121\6CD5\5347\7D1A</strong>, \800C\4E14'),
unistr('Oracle \5BA2\6236\670D\52D9\90E8\5C07<strong>\4E0D\518D\63D0\4F9B\652F\63F4</strong>.')))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492885234587780173.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>60
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492885472506780173.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(492885234587780173.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492885651312780174.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(492885234587780173.4757)
,p_button_name=>'UNLOCK'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1190595122736251033.4757)
,p_branch_action=>'f?p=&APP_ID.:235:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(492885651312780174.4757)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492883614448780170.4757)
,p_name=>'P234_APPLICATION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492883837053780170.4757)
,p_name=>'P234_NEW_APP_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492884044255780171.4757)
,p_name=>'P234_NEW_APP_URL'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492884202411780171.4757)
,p_name=>'P234_APP_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492884477154780172.4757)
,p_name=>'P234_WORKSPACE_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_prompt=>unistr('\5DE5\4F5C\5340\540D\7A31:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492884636725780172.4757)
,p_name=>'P234_SCHEMA'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_prompt=>unistr('\7DB1\8981:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492884828429780172.4757)
,p_name=>'P234_CREATED'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_prompt=>unistr('\5DF2\5B89\88DD:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(932669103927561041.4757)
,p_name=>'P234_UNLOCKING_APP_MSG'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(492883013793780169.4757)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_lang.system_message(''WAITING.APP_UNLOCK'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492886401322780175.4757)
,p_computation_sequence=>10
,p_computation_item=>'P234_SCHEMA'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select owner',
'from WWV_FLOWS',
'where security_group_id = :flow_security_group_id',
'   and id = :P234_APPLICATION_ID'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492886688874780175.4757)
,p_computation_sequence=>10
,p_computation_item=>'P234_APP_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name from wwv_flows',
'where id = :P234_APPLICATION_ID',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492886815322780175.4757)
,p_computation_sequence=>10
,p_computation_item=>'P234_WORKSPACE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select DISPLAY_NAME',
'from WWV_FLOW_COMPANIES',
'where PROVISIONING_COMPANY_ID = :flow_security_group_id'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492887071230780175.4757)
,p_computation_sequence=>10
,p_computation_item=>'P234_CREATED'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>'select htmldb_util.get_since(created) from wwv_flow_pkg_app_map where installed_app_id = :P234_APPLICATION_ID'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(740842633515106022.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(492885472506780173.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(740842954579106026.4757)
,p_event_id=>wwv_flow_api.id(740842633515106022.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
end;
/
prompt --application/pages/page_00235
begin
wwv_flow_api.create_page(
 p_id=>235.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F')
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'window.setTimeout(function() { apex.submit("INSTALL"); }, 100);'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1187159732590219866.4757)
,p_plug_name=>unistr('\6B63\5728\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F...')
,p_region_template_options=>'#DEFAULT#:a-ProcessingRegion--dialog'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1164683681838385745.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1190594068400243089.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Unlock Application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  for c1 in (select 1',
'               from wwv_flows',
'              where id = :P234_APPLICATION_ID',
'                and security_group_id = :flow_security_group_id)',
'  loop',
'      wwv_flow_pkg_app_install.unlock_db_app(:P234_APPLICATION_ID); ',
'  end loop;',
'end;'))
,p_process_error_message=>unistr('\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F\6642\767C\751F\932F\8AA4')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1187159933159219866.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\89E3\9664\9396\5B9A\61C9\7528\7A0B\5F0F.')
);
end;
/
prompt --application/pages/page_00237
begin
wwv_flow_api.create_page(
 p_id=>237.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_required_role=>wwv_flow_api.id(806250634212071966)
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492863091096664851.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>60
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492863870465664855.4757)
,p_plug_name=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>35
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_header=>'&P237_DB_APP_REMOVE_MSG.'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492863262180664855.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(492863091096664851.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492863491038664855.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(492863091096664851.4757)
,p_button_name=>'REMOVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1187098855308175638.4757)
,p_branch_action=>'f?p=&APP_ID.:238:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(492863491038664855.4757)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492864092350664855.4757)
,p_name=>'P237_APPLICATION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492864260490664856.4757)
,p_name=>'P237_NEW_APP_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492864492253664856.4757)
,p_name=>'P237_NEW_APP_URL'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492864666800664857.4757)
,p_name=>'P237_APP_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492864876329664857.4757)
,p_name=>'P237_WORKSPACE_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_prompt=>unistr('\5DE5\4F5C\5340\540D\7A31:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492865088005664857.4757)
,p_name=>'P237_SCHEMA'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_prompt=>unistr('\7DB1\8981:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492865274523664857.4757)
,p_name=>'P237_CREATED'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_prompt=>unistr('\5DF2\5B89\88DD:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(590337159933680958.4757)
,p_name=>'P237_DB_APP_REMOVE_MSG'
,p_item_sequence=>35
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(932668312768561033.4757)
,p_name=>'P237_REMOVING_APP_MSG'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(492863870465664855.4757)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_lang.system_message(''WAITING.APP_REMOVAL'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'I'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492865791267664858.4757)
,p_computation_sequence=>2
,p_computation_item=>'P237_SCHEMA'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select owner',
'from WWV_FLOWS',
'where security_group_id = :flow_security_group_id',
'  and id = :P237_APPLICATION_ID'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492865948604664859.4757)
,p_computation_sequence=>4
,p_computation_item=>'P237_CREATED'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select htmldb_util.get_since(created) ',
'from wwv_flow_pkg_app_map ',
'where ( :P81_APP_TYPE = ''DATABASE'' and installed_app_id = :P237_APPLICATION_ID) or (:P81_APP_TYPE = ''WEBSHEET'' and installed_ws_id = :P237_APPLICATION_ID)'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492866108705664859.4757)
,p_computation_sequence=>6
,p_computation_item=>'P237_WORKSPACE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select DISPLAY_NAME',
'from WWV_FLOW_COMPANIES',
'where PROVISIONING_COMPANY_ID = :flow_security_group_id'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492866395909664859.4757)
,p_computation_sequence=>8
,p_computation_item=>'P237_APP_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name from wwv_flows',
'where id = :P237_APPLICATION_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when=>'P81_APP_TYPE'
,p_compute_when_text=>'DATABASE'
,p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492866593781664859.4757)
,p_computation_sequence=>9
,p_computation_item=>'P237_APP_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name from wwv_flow_ws_applications',
'where id = :P237_APPLICATION_ID',
'and security_group_id = :flow_security_group_id'))
,p_compute_when=>'P81_APP_TYPE'
,p_compute_when_text=>'WEBSHEET'
,p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(932668582987561035.4757)
,p_computation_sequence=>19
,p_computation_item=>'P237_DB_APP_REMOVE_MSG'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'wwv_flow_lang.custom_runtime_message(''REMOVE_DB_PKG_APP_WARNING'')'
,p_compute_when=>'P81_APP_TYPE'
,p_compute_when_text=>'DATABASE'
,p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(740955465169333218.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(492863262180664855.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(740955786852333218.4757)
,p_event_id=>wwv_flow_api.id(740955465169333218.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
end;
/
prompt --application/pages/page_00238
begin
wwv_flow_api.create_page(
 p_id=>238.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F')
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'window.setTimeout(function() { apex.submit("INSTALL"); }, 100);'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1187095215315160513.4757)
,p_plug_name=>unistr('\6B63\5728\79FB\9664\61C9\7528\7A0B\5F0F...')
,p_region_css_classes=>'a-ProcessingRegion--slim'
,p_region_template_options=>'#DEFAULT#:a-ProcessingRegion--dialog'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1164683681838385745.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1187096974954165245.4757)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Remove Application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
' ',
'  if :P81_APP_TYPE = ''DATABASE'' then',
'      --',
'      -- Remove Database Packaged Application',
'      --',
'      for c1 in (select 1',
'                   from wwv_flows',
'                  where id = :P237_APPLICATION_ID',
'                    and security_group_id = :flow_security_group_id)',
'      loop',
'          wwv_flow_pkg_app_install.deinstall_db_app(p_id              => :P237_APPLICATION_ID,',
'                                                    p_supporting_objs => ''Y''); ',
'      end loop;',
'  else',
'      --',
'      -- Remove Websheet Packaged Application',
'      --',
'      for c1 in (select 1',
'                   from wwv_flow_ws_applications',
'                   where id = :P237_APPLICATION_ID',
'                    and security_group_id = :flow_security_group_id)',
'      loop',
'          wwv_flow_pkg_app_install.deinstall_websheet(:P237_APPLICATION_ID); ',
'      end loop; ',
'  end if;',
'end;'))
,p_process_error_message=>unistr('\79FB\9664\61C9\7528\7A0B\5F0F\6642\767C\751F\932F\8AA4')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\79FB\9664\61C9\7528\7A0B\5F0F')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1187100022731182050.4757)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\79FB\9664\61C9\7528\7A0B\5F0F.')
);
end;
/
prompt --application/pages/page_00262
begin
wwv_flow_api.create_page(
 p_id=>262.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_icons.css" type="text/css" media="screen" charset="utf-8">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_frame.css" type="text/css" media="screen" charset="utf-8">',
'',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_details.css" type="text/css" media="screen" title="no title" charset="utf-8">',
'',
'<style>',
'span.ebaAppAvailable {',
'    display: inline-block;',
'    font: normal 14px/16px Arial, sans-serif;',
'    margin: 4px 5px 0 0;',
'    color: #f7941d;',
'    }',
'</style>'))
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// extend jQuery selectors with a non case sensitive version',
'apex.jQuery.extend($.expr[":"], {',
'  "containsNC": function(pElem, pIdx, pMatch, pArray) {',
'                  return (pElem.textContent || pElem.innerText || "").toLowerCase().indexOf((pMatch[3] || "").toLowerCase()) >= 0;',
'                }',
'});',
'',
'',
'function initInstantFilter(){',
'  var $apps    = apex.jQuery(''#applications''),',
'      $allApps = $apps.clone(),',
'      lTimer;',
'',
'  function filterApplications(){',
'    var $filteredApps = $allApps.find("li:has(h3:containsNC(''"+$v(''p50_SEARCH'')+"''))");',
'    $apps.quicksand($filteredApps, {',
'      adjustHeight: false,',
'      useScaling: false,',
'      duration: 400,',
'      easing: ''easeInOutQuad''',
'    });',
'  };',
'',
'  // set a fixed size for the containing DIV to avoid flickering',
'  $apps.parent().css(''height'', $apps.parent().height() + ''px'').css(''min-width'', $apps.parent().width() + ''px'');',
'',
'  // everytime something is entered in our search field we want to execute the filter,',
'  // but only after a short delay to avoid flickering animations',
'  apex.jQuery(''#p50_SEARCH'')',
'    .keyup(function(pEvent){',
'      if (lTimer != undefined) {',
'        clearTimeout(lTimer);',
'      };',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        filterApplications();',
'      } else {',
'        lTimer = setTimeout(filterApplications, 300);',
'      }',
'    })',
'    .keypress(function(pEvent){',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        pEvent.preventDefault();',
'        pEvent.stopImmediatePropagation();',
'      }',
'    });',
'',
'};',
''))
,p_javascript_code_onload=>'initInstantFilter();'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(806250634212071966)
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492904045512873121.4757)
,p_plug_name=>'App Details Container'
,p_region_name=>'ebaAppFrameTable'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492904827862873122.4757)
,p_plug_name=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492906875496873124.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492907011478873124.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(492906875496873124.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492907257055873125.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(492906875496873124.4757)
,p_button_name=>'UPDATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(1190595306937253254.4757)
,p_branch_action=>'f?p=&APP_ID.:265:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(492907257055873125.4757)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492904215920873122.4757)
,p_name=>'P262_APPLICATION_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(492904045512873121.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492904497797873122.4757)
,p_name=>'P262_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(492904045512873121.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492904627410873122.4757)
,p_name=>'P262_APP_URL'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(492904045512873121.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492905018856873122.4757)
,p_name=>'P262_APP_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select app_name from wwv_flow_pkg_applications',
' where app_id = :P262_APPLICATION_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492905214425873122.4757)
,p_name=>'P262_AUTH'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_prompt=>unistr('\8A8D\8B49:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'  l_auth    varchar2(255);',
'begin',
'    select scheme_type into l_auth ',
'      from wwv_flow_authentications',
'     where flow_id = :P262_ID',
'       and id = (select authentication_id ',
'                   from wwv_flows',
'                  where id = :P262_ID ',
'                    and security_group_id = wwv_flow_security.g_security_group_id)',
'       and security_group_id = wwv_flow_security.g_security_group_id;',
'end;'))
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,',
'       r',
'  from (',
'        select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'               name_with_prefix      as r',
'          from wwv_flow_native_plugins',
'         where plugin_type = ''AUTHENTICATION TYPE''',
'         union all',
'        select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX'') as d,',
'               ''PLUGIN_'' || name     as r',
'          from wwv_flow_plugins',
'         where flow_id           = to_number(:P262_ID)',
'           and security_group_id = to_number(:WORKSPACE_ID)',
'           and plugin_type       = ''AUTHENTICATION TYPE''',
'       )',
' order by 1'))
,p_tag_attributes=>'class="fieldtitlebold"'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'LOV'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492905487764873123.4757)
,p_name=>'P262_WORKSPACE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5DE5\4F5C\5340\540D\7A31:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select DISPLAY_NAME',
'from WWV_FLOW_COMPANIES',
'where PROVISIONING_COMPANY_ID = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492905638520873123.4757)
,p_name=>'P262_SCHEMA'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_prompt=>unistr('\7DB1\8981:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cHeight=>1
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492905867180873123.4757)
,p_name=>'P262_PROVIDER_COMPANY'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\63D0\4F9B\8005:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select provider_company',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)',
'and provider_company is not null',
'  '))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492906048652873123.4757)
,p_name=>'P262_PROVIDER_EMAIL'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\63D0\4F9B\8005\96FB\5B50\90F5\4EF6:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select provider_email',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)',
'and provider_email is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492906267218873123.4757)
,p_name=>'P262_MIN_APEX_VERSION'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6700\5C0F\7248\672C:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select min_apex_version',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)',
'and min_apex_version is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492906417529873124.4757)
,p_name=>'P262_RELEASED'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\767C\884C\6642\9593:')
,p_format_mask=>'DD-MON-YYYY'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select released',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)',
'and released is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492906682018873124.4757)
,p_name=>'P262_LANGUAGES'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(492904827862873122.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8A9E\8A00:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select languages',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P262_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P262_APPLICATION_ID)',
'and languages is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(932668445370561034.4757)
,p_name=>'P262_UPDATING_APP_MSG'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(492904045512873121.4757)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_lang.system_message(''WAITING.APP_UPDATE'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_protection_level=>'I'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(492908032782873126.4757)
,p_computation_sequence=>10
,p_computation_item=>'P262_AUTH'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    select scheme_type ',
'      from wwv_flow_authentications',
'     where flow_id = :P262_ID',
'       and id = (select authentication_id ',
'                   from wwv_flows',
'                  where id = :P262_ID ',
'                    and security_group_id = :flow_security_group_id)',
'       and security_group_id = :flow_security_group_id;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2203926432658252653.4757)
,p_computation_sequence=>10
,p_computation_item=>'P262_SCHEMA'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select owner',
'from WWV_FLOWS',
'where security_group_id = :flow_security_group_id',
'   and id = :P262_ID'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(777148331924163851.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(492907011478873124.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(777148641561163851.4757)
,p_event_id=>wwv_flow_api.id(777148331924163851.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
end;
/
prompt --application/pages/page_00265
begin
wwv_flow_api.create_page(
 p_id=>265.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_allow_duplicate_submissions=>'N'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'window.setTimeout(function() { apex.submit("INSTALL"); }, 100);'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1187116680194203401.4757)
,p_plug_name=>unistr('\6B63\5728\66F4\65B0\61C9\7528\7A0B\5F0F...')
,p_region_template_options=>'#DEFAULT#:a-ProcessingRegion--dialog'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1164683681838385745.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(7258715021772801.4757)
,p_branch_name=>'failure'
,p_branch_action=>'f?p=&APP_ID.:266:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'EXISTS'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from htmldb_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P262_ID',
'and c002 = ''FAIL'''))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1187160735875222266.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_pkg_app_install.update_db_app (',
'        p_app_id   => :P262_APPLICATION_ID,',
'        p_id       => :P262_ID );'))
,p_process_error_message=>unistr('\672A\9806\5229\66F4\65B0\61C9\7528\7A0B\5F0F.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>unistr('\5DF2\9806\5229\66F4\65B0\61C9\7528\7A0B\5F0F.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1187116845296203401.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_error_cnt number := 0;',
'begin',
'    select count(*)',
'    into l_error_cnt',
'    from htmldb_collections',
'    where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P262_ID',
'    and c002 = ''FAIL'';',
'',
'    if l_error_cnt = 0 then',
'        return true; -- all done close dialog',
'    else',
'        return false; -- go view error',
'    end if;',
'end;'))
,p_process_when_type=>'FUNCTION_BODY'
,p_process_success_message=>unistr('\5DF2\66F4\65B0\61C9\7528\7A0B\5F0F.')
);
end;
/
prompt --application/pages/page_00266
begin
wwv_flow_api.create_page(
 p_id=>266.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\66F4\65B0\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
,p_help_text=>'deploy_pa_install_obj.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(664161469615690520.4757)
,p_plug_name=>unistr('\652F\63F4\7684\7269\4EF6\5B89\88DD\932F\8AA4')
,p_region_template_options=>'#DEFAULT#:a-Alert--defaultIcons:a-Alert--warning:a-Alert--wizard'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(746534672114889110.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from htmldb_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P262_ID',
'and c001 = ''PREREQ_CHECK'''))
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('\61C9\7528\7A0B\5F0F\5DF2\66F4\65B0.  \4E0D\904E, \5B89\88DD\8CC7\6599\5EAB\7269\4EF6\548C\7A2E\7C7D\8CC7\6599\5931\6557.')
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(664250342700800882.4757)
,p_name=>unistr('\66F4\65B0\6458\8981')
,p_parent_plug_id=>wwv_flow_api.id(664161469615690520.4757)
,p_template=>wwv_flow_api.id(662132465401686364.4757)
,p_display_sequence=>15
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 script_name, ',
'       decode(c002, ''SUCCESS'', ',
'                    wwv_flow_lang.system_message(''INSTALLER.SCRIPT.SUCCESS''),',
'                    ''FAIL'',',
'                    wwv_flow_lang.system_message(''INSTALLER.SCRIPT.FAIL'')) status,        ',
'       to_number(nvl(c003,0)) fail_count,',
'       to_number(nvl(c004,0)) success_count,',
'       c003 + c004 total_count',
'  from htmldb_collections',
' where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P262_ID',
' and c001 != ''PREREQ_CHECK'''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>50
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\4EFB\4F55\5B89\88DD\7D50\679C')
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_query_row_count_max=>500
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(7252915921707913.4757)
,p_query_column_id=>1
,p_column_alias=>'SCRIPT_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\547D\4EE4\6A94\540D\7A31')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(7253351341707914.4757)
,p_query_column_id=>2
,p_column_alias=>'STATUS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\72C0\614B')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(7253793951707914.4757)
,p_query_column_id=>3
,p_column_alias=>'FAIL_COUNT'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\767C\751F\932F\8AA4\7684\6558\8FF0\53E5')
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(7254161720707914.4757)
,p_query_column_id=>4
,p_column_alias=>'SUCCESS_COUNT'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\6210\529F\7684\6558\8FF0\53E5')
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(7254561515707915.4757)
,p_query_column_id=>5
,p_column_alias=>'TOTAL_COUNT'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\6558\8FF0\53E5\7E3D\6578')
,p_use_as_row_header=>'N'
,p_column_alignment=>'RIGHT'
,p_sum_column=>'Y'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(664256636439843106.4757)
,p_plug_name=>unistr('\932F\8AA4')
,p_parent_plug_id=>wwv_flow_api.id(664161469615690520.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(662132465401686364.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'for c1 in (select c001 script_name, clob001 errors ',
'           from htmldb_collections ',
'           where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P262_ID',
'           and c001 != ''PREREQ_CHECK''',
'           and length(clob001) > 0)',
'loop',
'  sys.htp.p(''<b>''||wwv_flow_escape.html(c1.script_name)||''</b>'');',
'  sys.htp.p(''<pre>'');',
'  wwv_flow_sw_script.escape_sc_clob(c1.errors);',
'  sys.htp.p(''</pre>'');',
'end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>wwv_flow_api.id(539932723203132393.4757)
,p_plug_query_num_rows=>50
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(767114665864212664.4757)
,p_plug_name=>'wizard buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--wizard'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>30
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1143835903148041521.4757)
,p_plug_name=>unistr('\5148\6C7A\689D\4EF6\6AA2\67E5\5931\6557')
,p_region_template_options=>'#DEFAULT#:a-Alert--warning:a-Alert--wizard'
,p_plug_template=>wwv_flow_api.id(746534672114889110.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from htmldb_collections',
'where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P262_ID',
'and c001 = ''PREREQ_CHECK'''))
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1143835938393041522.4757)
,p_plug_name=>unistr('\932F\8AA4')
,p_parent_plug_id=>wwv_flow_api.id(1143835903148041521.4757)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001 script_name, clob001 errors ',
'           from htmldb_collections ',
'           where collection_name = ''APEX_DEPLOYMENT_LOG_''||:P262_ID',
'           and c001 = ''PREREQ_CHECK''',
'           and length(clob001) > 0)',
'loop',
'    -- note: wwv_flow_pkg_app_install.prereq_check_bf_install populates formatted message with HTML tag if prerequisite check fails, don''t escape',
'    sys.htp.p( c1.errors );',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(7255580499707919.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(767114665864212664.4757)
,p_button_name=>'Close'
,p_button_action=>'SUBMIT'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\95DC\9589')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_alignment=>'LEFT'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(7256573294707944.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(7255580499707919.4757)
);
end;
/
prompt --application/pages/page_00300
begin
wwv_flow_api.create_page(
 p_id=>300.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\7BA1\7406\4F7F\7528\8005')
,p_step_title=>unistr('\7BA1\7406\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(805159035944749645)
,p_step_template=>wwv_flow_api.id(741369094170994311.4757)
,p_required_role=>wwv_flow_api.id(1020614257688498212)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801856451819237118.4757)
,p_plug_name=>unistr('\5E33\6236')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805538978589340502.4757)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'    ''icon-apex-user'' as icon_view_class,',
'    alt,',
'    link,',
'    icon_view_name,',
'    user_id,',
'    "USER",',
'    "eMail",',
'    first_name,',
'    last_name,',
'    df, -- default schema',
'    developer,',
'    last_login,',
'    last_login2,',
'    builder_login_count,',
'    ul, -- is user locked?',
'    expiration,',
'    description,',
'    password_lifespan_days,',
'    password_lifespan_accesses,',
'    password_accesses_left,',
'    last_agent,',
'    last_ip,',
'    account_expiry,',
'    failed_access_attempts,',
'    change_password_on_first_use,',
'    first_password_use_occurred,',
'    dev_type,',
'    group_id,',
'    group_name,',
'    last_update_date,',
'    last_updated_by,',
'    creation_date,',
'    created_by,',
'    developer_type,',
'    allow_app_building,',
'    allow_sql_workshop,',
'    allow_websheet_dev,',
'    allow_team_devopment',
'from wwv_flow_workspace_users',
'where workspace_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(801856687341237121.4757)
,p_name=>'Internal Accounts'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_enabled_yn=>'Y'
,p_icon_view_use_custom=>'Y'
,p_icon_view_custom_link=>'<a href="#LINK#" class="a-IRR-icon"><span class="a-Icon #ICON_VIEW_CLASS#"></span><span class="a-IRR-iconName">#ICON_VIEW_NAME#</span></a>'
,p_icon_view_columns_per_row=>5
,p_owner=>'MIKE'
,p_internal_uid=>801856687341237121
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858314246237129.4757)
,p_db_column_name=>'USER_ID'
,p_display_order=>1
,p_column_identifier=>'E'
,p_column_label=>'USER_ID'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858480863237129.4757)
,p_db_column_name=>'USER'
,p_display_order=>2
,p_column_identifier=>'F'
,p_column_label=>unistr('\4F7F\7528\8005')
,p_column_link=>'f?p=&APP_ID.:306:&SESSION.::&DEBUG.:RP:F4750_P306_USER_ID:#USER_ID#:'
,p_column_linktext=>'#USER#'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858584337237129.4757)
,p_db_column_name=>'eMail'
,p_display_order=>3
,p_column_identifier=>'G'
,p_column_label=>unistr('\96FB\5B50\90F5\4EF6')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858623882237129.4757)
,p_db_column_name=>'FIRST_NAME'
,p_display_order=>4
,p_column_identifier=>'H'
,p_column_label=>unistr('\540D\5B57')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858773538237130.4757)
,p_db_column_name=>'LAST_NAME'
,p_display_order=>5
,p_column_identifier=>'I'
,p_column_label=>unistr('\59D3\6C0F')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858805735237130.4757)
,p_db_column_name=>'DF'
,p_display_order=>6
,p_column_identifier=>'J'
,p_column_label=>unistr('\9810\8A2D\7684\7DB1\8981')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859290708237130.4757)
,p_db_column_name=>'UL'
,p_display_order=>7
,p_column_identifier=>'N'
,p_column_label=>unistr('\9396\5B9A')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859438380237130.4757)
,p_db_column_name=>'DEV_TYPE'
,p_display_order=>8
,p_column_identifier=>'P'
,p_column_label=>unistr('\5E33\6236\985E\578B')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858993339237130.4757)
,p_db_column_name=>'DEVELOPER'
,p_display_order=>9
,p_column_identifier=>'K'
,p_column_label=>unistr('\5BC6\78BC\72C0\614B')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859325164237130.4757)
,p_db_column_name=>'EXPIRATION'
,p_display_order=>10
,p_column_identifier=>'O'
,p_column_label=>unistr('\4E00\822C\4F7F\7528\8005\5E33\6236')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859017236237130.4757)
,p_db_column_name=>'LAST_LOGIN'
,p_display_order=>11
,p_column_identifier=>'L'
,p_column_label=>unistr('\4E0A\6B21\767B\5165\7522\751F\5668\7684\65E5\671F')
,p_column_type=>'DATE'
,p_format_mask=>'&DATE_TIME_FORMAT.'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859175920237130.4757)
,p_db_column_name=>'BUILDER_LOGIN_COUNT'
,p_display_order=>12
,p_column_identifier=>'M'
,p_column_label=>unistr('\7522\751F\5668\767B\5165\8A08\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858094341237128.4757)
,p_db_column_name=>'ALT'
,p_display_order=>14
,p_column_identifier=>'B'
,p_column_label=>unistr('\66FF\4EE3\9805\76EE')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858105071237129.4757)
,p_db_column_name=>'LINK'
,p_display_order=>15
,p_column_identifier=>'C'
,p_column_label=>unistr('\9023\7D50')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801858247883237129.4757)
,p_db_column_name=>'ICON_VIEW_NAME'
,p_display_order=>16
,p_column_identifier=>'D'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859551162237130.4757)
,p_db_column_name=>'LAST_LOGIN2'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>unistr('\4E0A\6B21\767B\5165\7522\751F\5668\7684\6642\9593')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859699583237130.4757)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('\63CF\8FF0')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859796830237130.4757)
,p_db_column_name=>'PASSWORD_LIFESPAN_DAYS'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('\5BC6\78BC\9031\671F\5929\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859801192237130.4757)
,p_db_column_name=>'PASSWORD_LIFESPAN_ACCESSES'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('\5BC6\78BC\9031\671F\5B58\53D6\6B21\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801859966484237130.4757)
,p_db_column_name=>'PASSWORD_ACCESSES_LEFT'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5269\9918\5BC6\78BC\5B58\53D6\6B21\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801860021426237131.4757)
,p_db_column_name=>'LAST_AGENT'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>unistr('\6700\5F8C\4E00\500B\4EE3\7406\7A0B\5F0F')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801860146255237131.4757)
,p_db_column_name=>'LAST_IP'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>unistr('\6700\5F8C\4E00\500B IP \4F4D\5740')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801860247718237131.4757)
,p_db_column_name=>'ACCOUNT_EXPIRY'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('\5E33\6236\904E\671F')
,p_column_type=>'DATE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801860374733237131.4757)
,p_db_column_name=>'FAILED_ACCESS_ATTEMPTS'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('\5931\6557\7684\5B58\53D6\5617\8A66\6B21\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801860466821237131.4757)
,p_db_column_name=>'CHANGE_PASSWORD_ON_FIRST_USE'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\7B2C\4E00\6B21\4F7F\7528\6642\8B8A\66F4\5BC6\78BC')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801856890407237127.4757)
,p_db_column_name=>'FIRST_PASSWORD_USE_OCCURRED'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\7B2C\4E00\6B21\4F7F\7528\5BC6\78BC\7684\6642\9593')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801856948910237127.4757)
,p_db_column_name=>'GROUP_NAME'
,p_display_order=>29
,p_column_identifier=>'AC'
,p_column_label=>unistr('\7FA4\7D44\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857046187237127.4757)
,p_db_column_name=>'LAST_UPDATE_DATE'
,p_display_order=>30
,p_column_identifier=>'AD'
,p_column_label=>unistr('\66F4\65B0\6642\9593')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857162177237127.4757)
,p_db_column_name=>'LAST_UPDATED_BY'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857210064237127.4757)
,p_db_column_name=>'CREATION_DATE'
,p_display_order=>32
,p_column_identifier=>'AF'
,p_column_label=>unistr('\5EFA\7ACB\6642\9593')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857354053237128.4757)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>33
,p_column_identifier=>'AG'
,p_column_label=>unistr('\5EFA\7ACB\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857487590237128.4757)
,p_db_column_name=>'DEVELOPER_TYPE'
,p_display_order=>34
,p_column_identifier=>'AH'
,p_column_label=>unistr('\958B\767C\4EBA\54E1\985E\578B')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857508594237128.4757)
,p_db_column_name=>'ALLOW_APP_BUILDING'
,p_display_order=>35
,p_column_identifier=>'AI'
,p_column_label=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668')
,p_column_type=>'STRING'
,p_display_condition_type=>'FUNCTION_BODY'
,p_display_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    for c1 in (select 1 from WWV_FLOW_COMPANIES',
'                where provisioning_company_id = :flow_security_group_id',
'                  and NVL(allow_app_building_yn,''Y'') = ''Y'') ',
'    loop',
'        return not wwv_flow.apps_only_workspace;',
'    end loop;',
'    return false;',
'end;'))
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857610548237128.4757)
,p_db_column_name=>'ALLOW_SQL_WORKSHOP'
,p_display_order=>36
,p_column_identifier=>'AJ'
,p_column_label=>unistr('SQL \5DE5\4F5C\5BA4')
,p_column_type=>'STRING'
,p_display_condition_type=>'FUNCTION_BODY'
,p_display_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    for c1 in (select 1 from WWV_FLOW_COMPANIES',
'                where provisioning_company_id = :flow_security_group_id',
'                  and NVL(allow_sql_workshop_yn,''Y'') = ''Y'') ',
'    loop',
'        return not wwv_flow.apps_only_workspace;',
'    end loop;',
'    return false;',
'end;'))
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857742338237128.4757)
,p_db_column_name=>'ALLOW_WEBSHEET_DEV'
,p_display_order=>37
,p_column_identifier=>'AK'
,p_column_label=>unistr('Web \8A66\7B97\8868')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857877225237128.4757)
,p_db_column_name=>'ALLOW_TEAM_DEVOPMENT'
,p_display_order=>38
,p_column_identifier=>'AL'
,p_column_label=>unistr('\5718\968A\958B\767C')
,p_column_type=>'STRING'
,p_display_condition_type=>'FUNCTION_BODY'
,p_display_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    for c1 in (select 1 from WWV_FLOW_COMPANIES',
'                where provisioning_company_id = :flow_security_group_id',
'                  and NVL(allow_team_development_yn,''Y'') = ''Y'') ',
'    loop',
'        return not wwv_flow.apps_only_workspace;',
'    end loop;',
'    return false;',
'end;'))
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(801857970261237128.4757)
,p_db_column_name=>'GROUP_ID'
,p_display_order=>39
,p_column_identifier=>'AM'
,p_column_label=>unistr('\7FA4\7D44 ID')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(649535263416618335.4757)
,p_db_column_name=>'ICON_VIEW_CLASS'
,p_display_order=>49
,p_column_identifier=>'AN'
,p_column_label=>unistr('\5716\793A\6AA2\8996\985E\5225')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801860750329237143.4757)
,p_plug_name=>unistr('\5DE5\4F5C')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(805137189383669602.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(805146703039709510.4757)
,p_plug_column_width=>'valign="top"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801860911393237144.4757)
,p_plug_name=>unistr('\7BA1\7406\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'sys.htp.prn(wwv_flow_lang.system_message(''PKG_APP_USER_TYPE_DESCRIPTION''));'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801861189165237144.4757)
,p_plug_name=>unistr('\5100\8868\677F')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801861364718237144.4757)
,p_plug_name=>'users and groups APEX 4 0'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(802137241064353033.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(750892319717997379.4757)
,p_translate_title=>'N'
,p_plug_display_condition_type=>'NEVER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801861992108237145.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(801856451819237118.4757)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:55,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801862136232237145.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(801856451819237118.4757)
,p_button_name=>'create_multiple'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_image_alt=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:302:&SESSION.::&DEBUG.:RP,302:::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801862358775237145.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(801856451819237118.4757)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB\4F7F\7528\8005')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801863333147237147.4757)
,p_branch_name=>'Go To Page 301'
,p_branch_action=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:301:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(801862358775237145.4757)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801863591290237150.4757)
,p_branch_action=>'300'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>20
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(649535137779618334.4757)
,p_computation_sequence=>10
,p_computation_item=>'LAST_VIEW'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'300'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(801862919074237146.4757)
,p_computation_sequence=>10
,p_computation_item=>'F4350_P4802_USER_ID'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_compute_when=>'wwv_flow.g_request = ''CREATE_ROW'''
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(801863172071237147.4757)
,p_computation_sequence=>20
,p_computation_item=>'LAST_VIEW'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'300'
,p_compute_when=>'CREATE'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(808639900234328664.4757)
,p_name=>'RENDERING: Change Password - Dialog Closed'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(801860750329237143.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(808640200279328664.4757)
,p_event_id=>wwv_flow_api.id(808639900234328664.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var lSuccessMsg = this.data.APEX_SUCCESS_MESSAGE,',
'      lUrl = ''f?p=&APP_ID.:300:&SESSION.::''',
'',
'if ( lSuccessMsg ) {',
'   lUrl += ''&success_msg='' + lSuccessMsg;',
'}',
'setTimeout(function() {',
'    apex.navigation.redirect(lUrl);',
'}, 0);'))
);
end;
/
prompt --application/pages/page_00301
begin
wwv_flow_api.create_page(
 p_id=>301.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5EFA\7ACB\4F7F\7528\8005')
,p_step_title=>unistr('\5EFA\7ACB\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(805159035944749645)
,p_step_template=>wwv_flow_api.id(741366253443994295.4757)
,p_required_role=>wwv_flow_api.id(1020614257688498212)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_new_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801868755606261949.4757)
,p_plug_name=>unistr('\5E33\6236\6B0A\9650')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801875453309261960.4757)
,p_plug_name=>unistr('\4F7F\7528\8005\8B58\5225')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'Region generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801878522622261964.4757)
,p_plug_name=>unistr('\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'sys.htp.prn(wwv_flow_lang.system_message(''PKG_APP_USER_TYPE_DESCRIPTION''));'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801878793950261965.4757)
,p_plug_name=>unistr('\5EFA\7ACB\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801880245567261967.4757)
,p_plug_name=>unistr('\5BC6\78BC')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801882157461261968.4757)
,p_plug_name=>unistr('\5340\57DF\986F\793A\9078\53D6\5668')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801878944731261965.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(801878793950261965.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801879374181261966.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(801878793950261965.4757)
,p_button_name=>'CREATE_ANOTHER'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\5EFA\7ACB\591A\9805')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801879151247261965.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(801878793950261965.4757)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB\4F7F\7528\8005')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801893372555261985.4757)
,p_branch_action=>'300'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_when_button_id=>wwv_flow_api.id(801879151247261965.4757)
,p_branch_sequence=>10
,p_branch_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801893528145261985.4757)
,p_branch_action=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:301,EDIT_USER_PRIVS:P301_DEVELOPER,P301_ADMIN:&P301_DEVELOPER.,&P301_ADMIN.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(801879374181261966.4757)
,p_branch_sequence=>20
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801868993934261949.4757)
,p_name=>'F4750_P301_DEFAULT_SCHEMA'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9810\8A2D\7684\7DB1\8981')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\6307\5B9A\7528\65BC\700F\89BD\8CC7\6599, \5EFA\7ACB\61C9\7528\7A0B\5F0F, \4EE5\53CA\57F7\884C SQL \547D\4EE4\6A94\7684\9810\8A2D\7DB1\8981. \4F7F\7528\6709\4E00\500B\4EE5\4E0A\7DB1\8981\7684\5DE5\4F5C\5340\6642, \6B64\7DB1\8981\70BA\5EFA\7ACB\61C9\7528\7A0B\5F0F, \57F7\884C SQL \67E5\8A62\7B49\6642\6240\4F7F\7528\7684\9810\8A2D\7DB1\8981. \9019\9805\529F\80FD\4E0D\63A7\5236\5B89\5168\6027, \50C5\50C5\662F\4F7F\7528\8005\7684\504F\597D\8A2D\5B9A.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801869430459261953.4757)
,p_name=>'F4750_P301_ALLOW_SCHEMA_ACCESS'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_prompt=>unistr('\53EF\5B58\53D6\7684\7DB1\8981 (\7A7A\503C\8868\793A\53EF\5B58\53D6\5168\90E8)')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>4000
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\8F38\5165\6B64\958B\767C\4EBA\54E1\5728\4F7F\7528\300CSQL \5DE5\4F5C\5BA4\300D\6642, \6709\6B0A\5B58\53D6\7684\7DB1\8981\6E05\55AE (\4F7F\7528\5192\865F\5340\9694). \60A8\5728\6B64\8655\8F38\5165\7684\7DB1\8981\6E05\55AE\6C7A\5B9A\4E86\4F7F\7528\8005\6240\80FD\5B58\53D6\7684\7DB1\8981 (\4EA6\5373, \70BA\5DE5\4F5C\5340\4F48\5EFA\4E4B\4E00\7D44\5B8C\6574\7DB1\8981\7684\90E8\5206\7DB1\8981), \4E26\4E14\6C7A\5B9A\4F7F\7528\8005\5728\300CSQL \5DE5\4F5C\5BA4\300D\6240\898B\7684\7DB1\8981\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801869941199261953.4757)
,p_name=>'P301_ADMIN'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\4F7F\7528\8005\662F\5DE5\4F5C\5340\7BA1\7406\54E1:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P52_ADMIN_0.checked) document.forms[0].P52_DEVELOPER_0.checked = true;"'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6307\5B9A\6B64\4F7F\7528\8005\662F\5426\61C9\6709\5DE5\4F5C\5340\7BA1\7406\54E1\6B0A\9650. \7BA1\7406\54E1\53EF\4EE5\5B58\53D6\6240\6709\5143\4EF6. \6B64\5916, \4ED6\5011\9084\53EF\4EE5\7BA1\7406\4F7F\7528\8005\5E33\6236\3001\7FA4\7D44\4EE5\53CA\958B\767C\670D\52D9.'),
'',
unistr('\82E5\300C\57F7\884C\8655\7406\7BA1\7406\54E1\300D\5C07\5143\4EF6\95DC\9589, \5C31\7121\6CD5\4F7F\7528\9019\4E9B\5143\4EF6.')))
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801870426816261953.4757)
,p_name=>'P301_DEVELOPER'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\4F7F\7528\8005\662F\958B\767C\4EBA\54E1:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'DEVELOPER TYPE'
,p_lov=>'.'||wwv_flow_api.id(801895490296261989.4757)||'.'
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P52_ADMIN_0.checked) document.forms[0].P52_DEVELOPER_0.checked = true;"'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\6B64\4F7F\7528\8005\662F\5426\61C9\8A72\5177\5099\958B\767C\4EBA\54E1\6B0A\9650. \958B\767C\4EBA\54E1\53EF\4EE5\5B89\88DD\3001\79FB\9664\6216\5347\7D1A\751F\7522\529B\61C9\7528\7A0B\5F0F.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801870938775261953.4757)
,p_name=>'P301_ALLOW_APP_BUILDING_YN'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801871495706261955.4757)
,p_name=>'P301_DISALLOW_APP_BUILDING'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801871925528261956.4757)
,p_name=>'P301_ALLOW_WEBSHEET_DEV_YN'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('Web \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\5177\5099\300CWeb \8A66\7B97\8868\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300CWeb \8A66\7B97\8868\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300CWeb \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801872424483261956.4757)
,p_name=>'P301_DISALLOW_WEBSHEET_DEV'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('Web \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\5177\5099\300CWeb \8A66\7B97\8868\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300CWeb \8A66\7B97\8868\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300CWeb \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801872966474261956.4757)
,p_name=>'P301_ALLOW_SQL_WORKSHOP_YN'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('SQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300CSQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801873457406261957.4757)
,p_name=>'P301_DISALLOW_SQL_WORKSHOP'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('SQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300CSQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801873990693261957.4757)
,p_name=>'P301_ALLOW_TEAM_DEVELOPMENT_YN'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('\5718\968A\958B\767C\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\4F7F\7528\8005\662F\5426\5177\5099\300C\5718\968A\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300C\5718\968A\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300C\5718\968A\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801874465165261960.4757)
,p_name=>'P301_DISALLOW_TEAM_DEVELOPMENT'
,p_item_sequence=>340
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\5718\968A\958B\767C\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\4F7F\7528\8005\662F\5426\5177\5099\300C\5718\968A\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300C\5718\968A\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300C\5718\968A\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801874998664261960.4757)
,p_name=>'P301_ACCOUNT_LOCKED'
,p_item_sequence=>350
,p_item_plug_id=>wwv_flow_api.id(801868755606261949.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\8A2D\5B9A\5E33\6236\4F7F\7528\72C0\614B')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ACCOUNT_LOCK_STATUS'
,p_lov=>'.'||wwv_flow_api.id(805398623015787070.4757)||'.'
,p_lov_display_null=>'YES'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\9078\53D6<b>\9396\5B9A</b>\53EF\9632\6B62\5E33\6236\88AB\4F7F\7528. \9078\53D6<b>\89E3\9664\9396\5B9A</b>\4EE5\5141\8A31\4F7F\7528\5E33\6236.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801875696425261961.4757)
,p_name=>'F4750_P301_USER_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(801875453309261960.4757)
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6307\5B9A\767B\5165\7CFB\7D71\6240\4F7F\7528\7684\4F7F\7528\8005\540D\7A31. \4F7F\7528\8005\540D\7A31\6709\4E0B\5217\9650\5236: <ul><li>'),
unistr('\9577\5EA6\4E0A\9650\70BA 100 \500B\5B57\5143</li><li>'),
unistr('\4E0D\53EF\6709\7A7A\683C</li>'),
unistr('<li>\53EA\5141\8A31\4EE5\4E0B\7279\6B8A\5B57\5143: @ \548C\53E5\865F (.)</li></ul>'),
unistr('<p>\60A8\4E5F\53EF\4EE5\4F7F\7528\4F7F\7528\8005\540D\7A31\53C3\7167\4F7F\7528\76E3\7763\5668\61C9\7528\7A0B\5F0F\7684\4F7F\7528\8005\6D3B\52D5. \7D44\5EFA\61C9\7528\7A0B\5F0F\6642, \9023\7D50\8B8A\6578 <code>:app_user</code> \6703\50B3\56DE\76EE\524D\4F7F\7528\8005\7684\503C.</p>')))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
,p_item_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801876075598261962.4757)
,p_name=>'F4750_P301_EMAIL_ADDRESS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(801875453309261960.4757)
,p_prompt=>unistr('\96FB\5B50\90F5\4EF6\5730\5740')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>240
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\4E00\822C\9805\76EE, \91CD\8A2D\5BC6\78BC\901A\77E5\7B49\4F7F\7528\7684\96FB\5B50\90F5\4EF6\5730\5740.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
,p_item_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801876543353261962.4757)
,p_name=>'F4750_P301_FIRST_NAME'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(801875453309261960.4757)
,p_prompt=>unistr('\540D\5B57')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\4F7F\7528\8005\7684\540D\5B57\4EE5\9032\4E00\6B65\8B58\5225\4F7F\7528\8005. \6B64\9078\64C7\6027\6B04\4F4D\50C5\4F9B\8CC7\8A0A\76EE\7684\4E4B\7528.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
,p_item_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801877086687261963.4757)
,p_name=>'F4750_P301_LAST_NAME'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(801875453309261960.4757)
,p_prompt=>unistr('\59D3\6C0F')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\4F7F\7528\8005\7684\59D3\6C0F\4EE5\9032\4E00\6B65\8B58\5225\4F7F\7528\8005. \6B64\9078\64C7\6027\6B04\4F4D\50C5\4F9B\8CC7\8A0A\76EE\7684\4E4B\7528.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
,p_item_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801877570915261963.4757)
,p_name=>'F4750_P301_DESCRIPTION'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(801875453309261960.4757)
,p_prompt=>unistr('\63CF\8FF0')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>200
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8ACB\5728\6B64\6B04\4F4D\4E2D\8F38\5165\6709\95DC\4F7F\7528\8005\7684\8A3B\89E3 (\50C5\4F9B\8CC7\8A0A\76EE\7684\4E4B\7528).')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'Y'
,p_attribute_04=>'NONE'
,p_item_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801880464552261967.4757)
,p_name=>'F4750_P301_WEB_PASSWORD'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(801880245567261967.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5BC6\78BC')
,p_post_element_text=>unistr(' <span class="instructiontext">\5BC6\78BC\6709\5927\5C0F\5BEB\4E4B\5206</span>')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\5BC6\78BC. \5BC6\78BC\6709\5927\5C0F\5BEB\4E4B\5206. \958B\767C\4EBA\54E1\53EF\4EE5\8B8A\66F4\4ED6\5011\81EA\5DF1\7684\5BC6\78BC. \5177\6709\300C\7BA1\7406\54E1\300D\6B0A\9650\7684\958B\767C\4EBA\54E1\53EF\4EE5\8B8A\66F4\540C\4E00\5DE5\4F5C\5340\5167\4E4B\4F7F\7528\8005\7684\5BC6\78BC.')
,p_encrypt_session_state_yn=>'Y'
,p_attribute_01=>'N'
,p_item_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801880964846261967.4757)
,p_name=>'F4750_P301_PASSWD_CONFIRM'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(801880245567261967.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\78BA\8A8D\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\8ACB\518D\8F38\5165\4E00\6B21\5BC6\78BC.')
,p_encrypt_session_state_yn=>'Y'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801881438419261968.4757)
,p_name=>'P301_SP'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(801880245567261967.4757)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_begin_on_new_line=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801881692544261968.4757)
,p_name=>'P301_CHANGE_PWD_ON_FIRST_USE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(801880245567261967.4757)
,p_item_default=>'Y'
,p_prompt=>unistr('\7B2C\4E00\6B21\4F7F\7528\6642\9700\8981\8B8A\66F4\5BC6\78BC')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6<b>\662F</b>, \8981\6C42\6B64\5E33\6236\7684\4F7F\7528\8005\5728\7B2C\4E00\6B21\4F7F\7528\76EE\524D\7684\5BC6\78BC\767B\5165\4E4B\5F8C\7ACB\5373\8B8A\66F4\5BC6\78BC. \6B64\898F\5247\9069\7528\65BC\4F7F\7528\6B64\5E33\6236\9032\884C\5DE5\4F5C\5340\7BA1\7406\6216\958B\767C, \4EE5\53CA\4F7F\7528\6B64\5E33\6236\767B\5165\5DF2\958B\767C\4E4B\61C9\7528\7A0B\5F0F\7B49\60C5\6CC1.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801882703797261969.4757)
,p_validation_name=>'F4750_P301_USER_NAME Not Null'
,p_validation_sequence=>10
,p_validation=>'F4750_P301_USER_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\4F7F\7528\8005\540D\7A31.')
,p_validation_condition=>'SUBMIT,CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(801875696425261961.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'generated 10-JUN-2001 19:34'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801882963246261970.4757)
,p_validation_name=>'UserNameValid'
,p_validation_sequence=>20
,p_validation=>'F4750_P301_USER_NAME'
,p_validation2=>'< >'
,p_validation_type=>'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2'
,p_error_message=>unistr('\7121\6548\7684\300C\4F7F\7528\8005\540D\7A31\300D.')
,p_validation_condition=>'SUBMIT,CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(801875696425261961.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801883137525261970.4757)
,p_validation_name=>'user doesn''t already exist'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flow_fnd_user',
' where user_name = upper(:F4750_P301_USER_NAME)',
'   and security_group_id = (select wwv_flow.get_sgid from dual where rownum = 1)'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('\4F7F\7528\8005 &F4750_P301_USER_NAME. \5DF2\7D93\5B58\5728.')
,p_validation_condition=>'SUBMIT,CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(801875696425261961.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801883314260261970.4757)
,p_validation_name=>'F4750_P301_EMAIL_ADDRESS Not Null'
,p_validation_sequence=>40
,p_validation=>'F4750_P301_EMAIL_ADDRESS'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\96FB\5B50\90F5\4EF6\5730\5740.')
,p_validation_condition=>'SUBMIT,CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(801876075598261962.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'generated 10-JUN-2001 19:34'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801883545606261970.4757)
,p_validation_name=>'F4750_P301_EMAIL_ADDRESS valid format'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_at number;',
'  l_dot number;',
'begin',
'  l_at := instr(nvl(:F4750_P301_EMAIL_ADDRESS,''x''),''@'');',
'  l_dot := instr(nvl(:F4750_P301_EMAIL_ADDRESS,''x''),''.'',l_at);',
'  return l_at > 1 and l_dot > 1 and (l_dot - l_at) > 1;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7121\6548\7684\96FB\5B50\90F5\4EF6\5730\5740.')
,p_validation_condition=>'F4750_P301_EMAIL_ADDRESS'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(801876075598261962.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
begin
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801883708623261970.4757)
,p_validation_name=>'default schema in accessible schemas'
,p_validation_sequence=>60
,p_validation=>'instr(upper(:F4750_P301_ALLOW_SCHEMA_ACCESS),:F4750_P301_DEFAULT_SCHEMA) > 0'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>unistr('\300C\9810\8A2D\7DB1\8981\300D\5FC5\9808\5728\300C\53EF\5B58\53D6\7DB1\8981\300D\4E4B\5167.')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':REQUEST in (''SUBMIT'',''CREATE_ANOTHER'') and ',
':F4750_P301_ALLOW_SCHEMA_ACCESS is not null'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(801868993934261949.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801883982214261970.4757)
,p_validation_name=>'Developer must have Access'
,p_validation_sequence=>80
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'  IF :P301_DEVELOPER = ''Y'' THEN',
'    IF :P301_ALLOW_APP_BUILDING_YN = ''N''',
'    AND :P301_ALLOW_SQL_WORKSHOP_YN = ''N'' THEN',
'      RETURN FALSE;',
'    END IF;',
'  END IF;',
'',
'  RETURN TRUE;',
'END;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.')
,p_validation_condition=>'SUBMIT,CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(801870426816261953.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801884168491261971.4757)
,p_validation_name=>'Validate Password'
,p_validation_sequence=>120
,p_validation=>':F4750_P301_PASSWD_CONFIRM = :F4750_P301_WEB_PASSWORD'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>unistr('\5BC6\78BC\4E0D\76F8\7B26. ')
,p_validation_condition=>'SUBMIT,CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(801880964846261967.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801884344971261971.4757)
,p_validation_name=>'strong password verification'
,p_validation_sequence=>140
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_security.strong_password_validation(',
'      p_username       => :F4750_P301_USER_NAME,',
'      p_password       => :F4750_P301_WEB_PASSWORD,',
'      p_old_password   => null,',
'      p_workspace_name => wwv_flow_security.find_company_name(:WORKSPACE_ID));'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\932F\8AA4')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':request in (''SUBMIT'',''CREATE_ANOTHER'')',
'and wwv_flow_authentication_dev.is_builder_password_required (',
'        p_developer_yn => :P301_DEVELOPER )'))
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(801880464552261967.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801884586679261972.4757)
,p_validation_name=>'admin / dev username validate'
,p_validation_sequence=>150
,p_validation=>'return regexp_like(:F4750_P301_USER_NAME,wwv_flow_platform.get_preference(''USERNAME_VALIDATION''));'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\4F7F\7528\8005\540D\7A31\8207\66FF\57F7\884C\8655\7406\5B9A\7FA9\7684\8868\793A\5F0F\4E0D\7B26.')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    nvl(wwv_flow_platform.get_preference(''USERNAME_VALIDATION''),''*'') != ''*''',
'and (:P301_ADMIN = ''Y'' or :P301_DEVELOPER = ''Y'')'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(801875696425261961.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801885433402261975.4757)
,p_name=>'Set Admin Defaults'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P301_ADMIN'
,p_condition_element=>'P301_ADMIN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801885789481261977.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_DEVELOPER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801885919620261978.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>11
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_DEVELOPER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801886168011261978.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_DEVELOPER'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801886311345261978.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801886575632261979.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>31
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801886797381261979.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801886968124261979.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801887147410261979.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>51
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801887323756261979.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>60
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801887568584261979.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>70
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801887791712261980.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>71
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801887910599261980.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>80
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801888115061261980.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>90
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_TEAM_DEVELOPMENT_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801888309020261980.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>91
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_TEAM_DEVELOPMENT_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801888519244261980.4757)
,p_event_id=>wwv_flow_api.id(801885433402261975.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>100
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_TEAM_DEVELOPMENT_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801888635934261981.4757)
,p_name=>'Set Developer Defaults'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P301_DEVELOPER'
,p_condition_element=>'P301_DEVELOPER'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801888970591261981.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801889162513261981.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>11
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801889393982261981.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801889504152261981.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>21
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801889765539261982.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801889986362261982.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>31
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801890132279261982.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801890333861261982.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>41
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801890576092261983.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801890710396261983.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>51
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801890945503261983.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>60
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801891112507261983.4757)
,p_event_id=>wwv_flow_api.id(801888635934261981.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>61
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P301_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801892803110261984.4757)
,p_name=>'set email if user name contains @'
,p_event_sequence=>80
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'F4750_P301_USER_NAME'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'$v(''F4750_P301_USER_NAME'').match(/@/)!=null'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801893131306261985.4757)
,p_event_id=>wwv_flow_api.id(801892803110261984.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'F4750_P301_EMAIL_ADDRESS'
,p_attribute_01=>'JAVASCRIPT_EXPRESSION'
,p_attribute_05=>'$v(''F4750_P301_USER_NAME'')'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(801884616726261972.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create User PL/SQL API Call'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_user_id                      number        := wwv_flow_id.next_val;',
'  l_p                            varchar2(256) := :F4750_P301_WEB_PASSWORD;',
'  l_change_password_on_first_use varchar2(1)   := ''N'';',
'  l_developer_roles              varchar2(255) := NULL;',
'begin',
'  if :P301_CHANGE_PWD_ON_FIRST_USE = ''Y'' then',
'    l_change_password_on_first_use := ''Y'';',
'  end if;',
'  ',
'  wwv_flow.update_cache_with_write(''F4750_P301_WEB_PASSWORD'',null);',
'  wwv_flow.update_cache_with_write(''F4750_P301_PASSWD_CONFIRM'',null);',
'  ',
'  WWV_FLOW_FND_USER_API.CREATE_FND_USER(',
'      P_USER_ID                      => l_user_id,',
'      P_USER_NAME                    => :F4750_P301_USER_NAME,',
'      P_FIRST_NAME                   => :F4750_P301_FIRST_NAME,',
'      P_LAST_NAME                    => :F4750_P301_LAST_NAME,',
'      P_DESCRIPTION                  => :F4750_P301_DESCRIPTION,',
'      P_EMAIL_ADDRESS                => :F4750_P301_EMAIL_ADDRESS,',
'      P_WEB_PASSWORD                 => l_p,',
'      P_DEVELOPER_PRIVS              => null,',
'      P_DEFAULT_SCHEMA               => :F4750_P301_DEFAULT_SCHEMA,',
'      P_ALLOW_ACCESS_TO_SCHEMAS      => :F4750_P301_ALLOW_SCHEMA_ACCESS,',
'      P_ACCOUNT_EXPIRY               => trunc(sysdate),',
'      P_ACCOUNT_LOCKED               => nvl(:P301_ACCOUNT_LOCKED,''N''),',
'      p_failed_access_attempts       =>   0, ',
'      p_change_password_on_first_use => l_change_password_on_first_use,',
'      p_first_password_use_occurred  => ''N'' );',
'',
'  --',
'  -- Set User Component Privileges',
'  --',
'  if :P301_ADMIN = ''Y'' then',
'    wwv_flow_fnd_developer_api.set_component_privs (',
'        P_user_id                   => l_user_id,',
'        p_ALLOW_APP_BUILDING_YN     => ''Y'',',
'        p_ALLOW_WEBSHEET_DEV_YN     => ''Y'',',
'        p_ALLOW_SQL_WORKSHOP_YN     => ''Y'',',
'        p_ALLOW_TEAM_DEVELOPMENT_YN => ''Y'');',
'',
'  elsif :P301_DEVELOPER= ''Y'' then',
'    wwv_flow_fnd_developer_api.set_component_privs (',
'        P_user_id                   => l_user_id,',
'        p_ALLOW_APP_BUILDING_YN     => nvl(:P301_ALLOW_APP_BUILDING_YN,''Y''),',
'        p_ALLOW_WEBSHEET_DEV_YN     => nvl(:P301_ALLOW_WEBSHEET_DEV_YN,''Y''),',
'        p_ALLOW_SQL_WORKSHOP_YN     => nvl(:P301_ALLOW_SQL_WORKSHOP_YN,''Y''),',
'        p_ALLOW_TEAM_DEVELOPMENT_YN => nvl(:P301_ALLOW_TEAM_DEVELOPMENT_YN,''Y'') );',
'',
'  else',
'    wwv_flow_fnd_developer_api.set_component_privs (',
'        P_user_id                   => l_user_id,',
'        p_ALLOW_APP_BUILDING_YN     => ''N'',',
'        p_ALLOW_WEBSHEET_DEV_YN     => ''N'',',
'        p_ALLOW_SQL_WORKSHOP_YN     => ''N'',',
'        p_ALLOW_TEAM_DEVELOPMENT_YN => nvl(:P301_ALLOW_TEAM_DEVELOPMENT_YN,''Y''));',
'',
'  end if;',
'',
'  --',
'  -- Developer and Admin roles',
'  --',
'  if :P301_ADMIN = ''N'' and :P301_DEVELOPER= ''N'' then',
'    null;',
'  else',
'    -- {Trigger on WWV_FLOW_DEVELOPERS sets all developer roles for ADMINS ',
'    --  irrespective of what set here providing includes ''ADMIN''} ',
'    if :P301_ADMIN = ''Y'' then ',
'      l_developer_roles := ''ADMIN'';',
'    end if;',
'    if nvl(v(''P301_ALLOW_APP_BUILDING_YN''),''Y'') = ''Y'' then ',
'      if l_developer_roles is not null then',
'        l_developer_roles := l_developer_roles||'':'';',
'      end if;',
'      l_developer_roles := l_developer_roles||''CREATE:EDIT:HELP:MONITOR'';',
'    end if;',
'    if nvl(v(''P301_ALLOW_SQL_WORKSHOP_YN''),''Y'') = ''Y'' then',
'      if l_developer_roles is not null then',
'        l_developer_roles := l_developer_roles||'':'';',
'      end if;',
'      l_developer_roles := l_developer_roles||''SQL:MONITOR:DATA_LOADER'';',
'    end if;',
'    wwv_flow_fnd_developer_api.edit_developer_role(',
'      p_id => 1,',
'      p_user_id => l_user_id,',
'      p_user_name => :F4750_P301_USER_NAME,',
'      p_developer_roles => l_developer_roles);',
'  end if;',
'',
'end;',
'commit;'))
,p_process_error_message=>unistr('\932F\8AA4: #SQLERRM#')
,p_process_when=>'SUBMIT,CREATE_ANOTHER'
,p_process_when_type=>'REQUEST_IN_CONDITION'
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\4F7F\7528\8005.')
,p_process_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(801884849098261973.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear'
,p_attribute_01=>'CLEAR_CACHE_FOR_ITEMS'
,p_attribute_03=>'F4750_P301_WEB_PASSWORD,F4750_P301_PASSWD_CONFIRM'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(801885207571261975.4757)
,p_process_sequence=>10
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'always developer if admin'
,p_process_sql_clob=>':P301_DEVELOPER := ''Y'';'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P301_ADMIN'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(801885067563261975.4757)
,p_process_sequence=>30
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'generate random password for SSO accounts'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4750_P301_WEB_PASSWORD   := wwv_flow_authentication_dev.create_shadow_user_password;',
':F4750_P301_PASSWD_CONFIRM := :F4750_P301_WEB_PASSWORD;'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    :request in (''SUBMIT'',''CREATE_ANOTHER'')',
'and :F4750_P301_WEB_PASSWORD is null',
'and not wwv_flow_authentication_dev.is_builder_password_required (',
'            p_developer_yn => :P301_DEVELOPER )'))
,p_process_when_type=>'PLSQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00302
begin
wwv_flow_api.create_page(
 p_id=>302.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_step_title=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(805159035944749645)
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function clob_Submit(){',
'	var clob = new apex.ajax.clob(function (){',
'		if(p.readyState == 1){',
'				$x_Show(''AjaxLoading'');',
'		}else if(p.readyState == 2){',
'		}else if(p.readyState == 3){',
'		}else if(p.readyState == 4){',
'				$s(''P99_USERS'','''');',
'				doSubmit(''SUCCESS'');',
'				return;',
'		}else{return false;}',
'});',
'	clob._set($v(''P99_USERS''));',
'	return;',
'}'))
,p_step_template=>wwv_flow_api.id(741371098457994312.4757)
,p_required_role=>wwv_flow_api.id(1020614257688498212)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_new_users_multi.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801904748492279859.4757)
,p_plug_name=>unistr('\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>24
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8F38\5165\6216\8907\88FD\4E26\8CBC\4E0A\96FB\5B50\90F5\4EF6\5730\5740 (\4F7F\7528\9017\865F\3001\5206\865F\6216\65B0\884C\5340\9694). \8ACB\6CE8\610F, \5982\679C\60A8\5F9E\96FB\5B50\90F5\4EF6\8A0A\606F\8907\88FD\4E26\8CBC\4E0A\96FB\5B50\90F5\4EF6\5730\5740, \984D\5916\7684\6587\5B57\5C07\6703\88AB\7BE9\9664. \7CFB\7D71\5C07\4EE5\9078\53D6\7684\89D2\8272\589E\52A0\6240\6709\63D0\4F9B\7684\96FB\5B50\90F5\4EF6\4F7F\7528\8005. \5C07\5FFD\7565\73FE\6709\6216\91CD\8907\7684\96FB\5B50\90F5\4EF6\5730\5740.'),
'',
unistr('<p>\8ACB\6CE8\610F, \7CFB\7D71\6703\5C07\60A8\6307\5B9A\7684\5BC6\78BC\6307\5B9A\7D66\6BCF\4F4D\4F7F\7528\8005, \4F7F\7528\8005\5FC5\9808\5728\767B\5165\5F8C\8B8A\66F4\5176\5BC6\78BC.</p>')))
,p_plug_column_width=>'valign=top'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801912387791279871.4757)
,p_plug_name=>'top bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801914160780279872.4757)
,p_plug_name=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801912598970279871.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(801912387791279871.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801912771858279871.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(801912387791279871.4757)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801922947471279889.4757)
,p_branch_action=>'f?p=&APP_ID.:303:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801904987716279859.4757)
,p_name=>'P302_USERS'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(801904748492279859.4757)
,p_prompt=>unistr('\96FB\5B50\90F5\4EF6\5730\5740\6E05\55AE')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>32767
,p_cHeight=>10
,p_field_template=>wwv_flow_api.id(741376417814001773.4757)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\8F38\5165\6216\8907\88FD\4E26\8CBC\4E0A\96FB\5B50\90F5\4EF6\5730\5740 (\4F7F\7528\9017\865F\3001\5206\865F\6216\65B0\884C\5340\9694). \6CE8\610F, \5982\679C\60A8\5F9E\96FB\5B50\90F5\4EF6\8A0A\606F\8907\88FD\4E26\8CBC\4E0A\96FB\5B50\90F5\4EF6\5730\5740, \5C07\6703\7BE9\9078\6389\984D\5916\7684\6587\5B57.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801905448114279861.4757)
,p_name=>'P302_STRIP_DOMAIN'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(801904748492279859.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CREATE.MULT.USER.STRIP.DOMAIN'
,p_lov=>'.'||wwv_flow_api.id(805346280616446827.4757)||'.'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6307\5B9A\8981\5305\62EC\5B8C\6574\7684\96FB\5B50\90F5\4EF6\5730\5740, \6216\662F\8981\6392\9664\7DB2\57DF\540D\7A31. \9078\9805\5305\62EC:'),
'<ul>',
unistr('<li>\5C07\4F7F\7528\8005\540D\7A31\8A2D\70BA\5B8C\6574\7684\96FB\5B50\90F5\4EF6\5730\5740 - \5305\62EC\5B8C\6574\7684\96FB\5B50\90F5\4EF6\5730\5740.</li>'),
unistr('<li>\6392\9664\4F7F\7528\8005\540D\7A31\7684 @ \7DB2\57DF\90E8\5206 - \79FB\9664 @ \7B26\865F\5F8C\7684\6240\6709\6587\5B57 (\4F8B\5982, <code>user1@xyz.com</code> \5C07\8B8A\6210 <code>user1</code>).</li>'),
'</ul>'))
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801907160517279864.4757)
,p_name=>'P302_ADMIN'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(801904748492279859.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\4F7F\7528\8005\662F\5DE5\4F5C\5340\7BA1\7406\54E1:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P52_ADMIN_0.checked) document.forms[0].P52_DEVELOPER_0.checked = true;"'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\9019\4E9B\4F7F\7528\8005\662F\5426\61C9\6709\5DE5\4F5C\5340\7BA1\7406\54E1\6B0A\9650. \5C31\50CF\958B\767C\4EBA\54E1, \5DE5\4F5C\5340\7BA1\7406\54E1\53EF\4EE5\5EFA\7ACB\53CA\4FEE\6539\61C9\7528\7A0B\5F0F\548C\8CC7\6599\5EAB\7269\4EF6. \6B64\5916, \4ED6\5011\9084\53EF\4EE5\7BA1\7406\4F7F\7528\8005\5E33\6236\3001\7FA4\7D44\4EE5\53CA\958B\767C\670D\52D9.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801907691188279864.4757)
,p_name=>'P302_DEVELOPER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(801904748492279859.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\4F7F\7528\8005\662F\958B\767C\4EBA\54E1:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'DEVELOPER TYPE'
,p_lov=>'.'||wwv_flow_api.id(801895490296261989.4757)||'.'
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P52_ADMIN_0.checked) document.forms[0].P52_DEVELOPER_0.checked = true;"'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_input=>'Y'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\9019\4E9B\4F7F\7528\8005\662F\5426\61C9\6709\958B\767C\4EBA\54E1\6B0A\9650. \958B\767C\4EBA\54E1\53EF\4EE5\5EFA\7ACB\53CA\4FEE\6539\61C9\7528\7A0B\5F0F\548C\8CC7\6599\5EAB\7269\4EF6.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801913106059279872.4757)
,p_name=>'P302_WEB_PASSWORD'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(801904748492279859.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5BC6\78BC')
,p_post_element_text=>unistr(' <span class="instructiontext">\5BC6\78BC\6709\5927\5C0F\5BEB\4E4B\5206</span>')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\6307\5B9A\5BC6\78BC. \5BC6\78BC\6709\5927\5C0F\5BEB\4E4B\5206. \958B\767C\4EBA\54E1\53EF\4EE5\8B8A\66F4\4ED6\5011\81EA\5DF1\7684\5BC6\78BC. \5177\6709\300C\7BA1\7406\54E1\300D\6B0A\9650\7684\958B\767C\4EBA\54E1\53EF\4EE5\8B8A\66F4\540C\4E00\5DE5\4F5C\5340\5167\4E4B\4F7F\7528\8005\7684\5BC6\78BC.')
,p_encrypt_session_state_yn=>'Y'
,p_attribute_01=>'N'
,p_item_comment=>'Generated 24-MAY-2001 18:02:15'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(801913625101279872.4757)
,p_name=>'P302_PASSWD_CONFIRM'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(801904748492279859.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\78BA\8A8D\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_escape_on_http_input=>'Y'
,p_restricted_characters=>'WEB_SAFE'
,p_help_text=>unistr('\8ACB\518D\8F38\5165\4E00\6B21\5BC6\78BC.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(808601330697447699.4757)
,p_name=>'P302_DEFAULT_SCHEMA'
,p_item_sequence=>25
,p_item_plug_id=>wwv_flow_api.id(801904748492279859.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9810\8A2D\7684\7DB1\8981')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'LIST_AVAILABLE_SCHEMAS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(schema) d, schema r',
'',
'from   wwv_flow_company_schemas',
'',
'where  security_group_id = :flow_security_group_id',
'',
'order by 1'))
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_input=>'N'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\6307\5B9A\7528\65BC\700F\89BD\8CC7\6599, \5EFA\7ACB\61C9\7528\7A0B\5F0F, \4EE5\53CA\57F7\884C SQL \547D\4EE4\6A94\7684\9810\8A2D\7DB1\8981. \4F7F\7528\6709\4E00\500B\4EE5\4E0A\7DB1\8981\7684\5DE5\4F5C\5340\6642, \6B64\7DB1\8981\70BA\5EFA\7ACB\61C9\7528\7A0B\5F0F, \57F7\884C SQL \67E5\8A62\7B49\6642\6240\4F7F\7528\7684\9810\8A2D\7DB1\8981. \9019\9805\529F\80FD\4E0D\63A7\5236\5B89\5168\6027, \50C5\50C5\662F\4F7F\7528\8005\7684\504F\597D\8A2D\5B9A.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801914714646279875.4757)
,p_validation_name=>'Developer must have Access'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'  IF :P302_DEVELOPER = ''Y'' THEN',
'    IF :P302_ALLOW_APP_BUILDING_YN = ''N''',
'    AND :P302_ALLOW_SQL_WORKSHOP_YN = ''N'' THEN',
'      RETURN FALSE;',
'    END IF;',
'  END IF;',
'',
'  RETURN TRUE;',
'END;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.')
,p_when_button_pressed=>wwv_flow_api.id(801912771858279871.4757)
,p_associated_item=>wwv_flow_api.id(801907691188279864.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(801914902890279876.4757)
,p_validation_name=>'Passwords match'
,p_validation_sequence=>20
,p_validation=>'P302_WEB_PASSWORD'
,p_validation2=>'&P302_PASSWD_CONFIRM.'
,p_validation_type=>'ITEM_IN_VALIDATION_EQ_STRING2'
,p_error_message=>unistr('\5BC6\78BC\548C\78BA\8A8D\5BC6\78BC\4E0D\7B26.')
,p_validation_condition=>'P302_WEB_PASSWORD'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(801912771858279871.4757)
,p_associated_item=>wwv_flow_api.id(801913106059279872.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801915486481279876.4757)
,p_name=>'Set Admin Defaults'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P302_ADMIN'
,p_condition_element=>'P302_ADMIN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
,p_display_when_type=>'PLSQL_EXPRESSION'
,p_display_when_cond=>'not wwv_flow_authentication_dev.can_edit_builder_users'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801915701573279877.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_DEVELOPER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801915986681279879.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_DEVELOPER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801916102259279880.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801916378829279880.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_DEVELOPER'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801916595374279880.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801916737295279880.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801916994097279880.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801917182920279880.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801917349448279881.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801917582082279881.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>50
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_TEAM_DEVELOPMENT_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801917727153279884.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>60
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801917962850279885.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>70
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801918141703279885.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>80
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801918378301279885.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>90
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_TEAM_DEVELOPMENT_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801918598111279885.4757)
,p_event_id=>wwv_flow_api.id(801915486481279876.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>100
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_TEAM_DEVELOPMENT_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801918668813279885.4757)
,p_name=>'Set Developer Defaults'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P302_DEVELOPER'
,p_condition_element=>'P302_DEVELOPER'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801918942607279885.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801919147716279885.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801919338677279885.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801919508167279885.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801919709709279885.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801919971132279885.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801920110797279885.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801920308300279887.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>40
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801920581817279887.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801920762327279887.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>50
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801920905785279887.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>60
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801921137676279887.4757)
,p_event_id=>wwv_flow_api.id(801918668813279885.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>60
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801921287884279887.4757)
,p_name=>'Disable Disallow App Building'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P302_DISALLOW_APP_BUILDING'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801921535147279887.4757)
,p_event_id=>wwv_flow_api.id(801921287884279887.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_DISALLOW_APP_BUILDING'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801921630343279887.4757)
,p_name=>'Disable Disallow Websheet Development'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P302_DISALLOW_WEBSHEET_DEV'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801921983192279887.4757)
,p_event_id=>wwv_flow_api.id(801921630343279887.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_DISALLOW_WEBSHEET_DEV'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801922066430279887.4757)
,p_name=>'Disable Disallow SQL Workshop'
,p_event_sequence=>50
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P302_DISALLOW_SQL_WORKSHOP'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801922321050279889.4757)
,p_event_id=>wwv_flow_api.id(801922066430279887.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_DISALLOW_SQL_WORKSHOP'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(801922497921279889.4757)
,p_name=>'Disable Disallow Team Development'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P302_DISALLOW_TEAM_DEVELOPMENT'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(801922762904279889.4757)
,p_event_id=>wwv_flow_api.id(801922497921279889.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P302_DISALLOW_TEAM_DEVELOPMENT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(801915034587279876.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create collection of user names'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_line      varchar2(32767);',
'    l_emails    wwv_flow_global.vc_arr2;',
'    l_username  varchar2(4000);',
'    l_at        number;',
'    l_dot       number;',
'    l_valid     boolean := true;',
'    l_domain    varchar2(4000);',
'begin',
'    ---------------------',
'    -- create collections',
'    --',
'    apex_collection.CREATE_OR_TRUNCATE_COLLECTION (''BULK_USER_INVALID'');',
'    apex_collection.CREATE_OR_TRUNCATE_COLLECTION (''BULK_USER_VALID'');',
'    apex_collection.CREATE_OR_TRUNCATE_COLLECTION (''BULK_USER_CREATE'');',
'',
'    --------------------------------------------',
'    -- replace delimiting characters with commas',
'    --',
'    l_line := :P302_USERS;',
'    l_line := replace(l_line,chr(10),'' '');',
'    l_line := replace(l_line,chr(13),'' '');',
'    l_line := replace(l_line,chr(9),'' '');',
'    l_line := replace(l_line,''<'','' '');',
'    l_line := replace(l_line,''>'','' '');',
'    l_line := replace(l_line,'';'','' '');',
'    l_line := replace(l_line,'':'','' '');',
'    l_line := replace(l_line,'' '','','');',
'',
'    -----------------------------------------',
'    -- get one comma separated line of emails',
'    --',
'    for j in 1..1000 loop',
'        if instr(l_line,'',,'') > 0 then',
'           l_line := replace(l_line,'',,'','','');',
'        else',
'           exit;',
'        end if;',
'    end loop;',
'',
'    -------------------------',
'    -- get an array of emails',
'    --',
'    l_emails := wwv_flow_utilities.string_to_table(l_line,'','');',
'',
'    -----------------------------',
'    -- add emails to a collection',
'    --',
'    l_username := null;',
'    l_domain := null;',
'    l_at := 0;',
'    l_dot := 0;',
'    for j in 1..l_emails.count loop',
'        l_valid := true;',
'        l_username := trim(l_emails(j));',
'',
'        if l_username is not null then',
'            if :P302_STRIP_DOMAIN = ''N'' then',
'              -----------',
'              -- Validate',
'              --',
'              l_at := instr(nvl(l_username,''x''),''@'');',
'              l_domain := substr(l_username,l_at+1);',
'              l_dot := instr(l_domain,''.'');',
'              if l_at < 2 then',
'                  -- invalid email',
'                  apex_collection.add_member(',
'                      p_collection_name => ''BULK_USER_INVALID'',',
'                      p_c001            => l_username,',
'                      p_c002            => wwv_flow_lang.system_message(''MISSING_AT_SIGN''));',
'                  commit;',
'                  l_valid := false;',
'              end if;',
'',
'              if l_dot = 0 and l_valid then',
'                  apex_collection.add_member(',
'                      p_collection_name => ''BULK_USER_INVALID'',',
'                      p_c001            => l_username,',
'                      p_c002            => wwv_flow_lang.system_message(''MISSING_DOT''));',
'                  commit;',
'                  l_valid := false;',
'              end if;',
'            end if;',
'',
'            l_username := trim(l_username);',
'            l_username := replace(l_username,'' '',null);',
'            l_username := replace(l_username,chr(10),null);',
'            l_username := replace(l_username,chr(9),null);',
'            l_username := replace(l_username,chr(13),null);',
'',
'            if l_valid and length(l_username) > 255 then',
'                apex_collection.add_member(',
'                    p_collection_name => ''BULK_USER_INVALID'',',
'                    p_c001            => upper(l_username),',
'                    p_c002            => wwv_flow_lang.system_message(''WS_USERNAME_TOO_LONG''));',
'                commit;',
'                l_valid := false;',
'            end if;',
'',
'            if l_valid then',
'                for c1 in (select /* APEX76a66f */ user_name',
'                             from wwv_flow_fnd_user',
'                            where upper(user_name) = upper(l_username)',
'                            and security_group_id = :flow_security_group_id)',
'                loop',
'                    wwv_flow_collection.add_member(',
'                        p_collection_name => ''BULK_USER_INVALID'',',
'                        p_c001            => upper(l_username),',
'                        p_c002            => wwv_flow_lang.system_message(''ALREADY_IN_WS''));',
'                    commit;',
'                    l_valid := false;',
'                    exit;',
'                end loop;',
'            end if;',
'',
'            if l_valid then',
'                for c1 in (select /* APEXeaf772 */  c001',
'                             from wwv_flow_collections',
'                            where collection_name = ''BULK_USER_VALID''',
'                              and c001 = upper(l_username))',
'                loop',
'                    apex_collection.add_member(',
'                        p_collection_name => ''BULK_USER_INVALID'',',
'                        p_c001            => upper(l_username),',
'                        p_c002            => wwv_flow_lang.system_message(''DUPLICATE_USER''));',
'                        commit;',
'                    l_valid := false;',
'                    exit;',
'                end loop;',
'            end if;',
'',
'            if l_valid then',
'                apex_collection.add_member(',
'                    p_collection_name => ''BULK_USER_VALID'',',
'                    p_c001            => upper(l_username));',
'                    commit;',
'            end if;',
'',
'        end if;',
'        l_username := null;',
'    end loop;',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(801912771858279871.4757)
);
end;
/
begin
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(801915272354279876.4757)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'init collections'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_collection.CREATE_OR_TRUNCATE_COLLECTION (''BULK_USER_INVALID'');',
'wwv_flow_collection.CREATE_OR_TRUNCATE_COLLECTION (''BULK_USER_CREATE'');'))
);
null;
end;
/
prompt --application/pages/page_00303
begin
wwv_flow_api.create_page(
 p_id=>303.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_step_title=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(805159035944749645)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.uReportList {',
'    margin: 0;',
'    list-style: none;',
'}',
'.uReportList li {',
'    margin: 0 0 4px 0;',
'}',
'.check_icon {',
'    display: inline-block;',
'    width: 16px;',
'    height: 16px;',
'    line-height: 16px;',
'    background: #69B86B;',
'    color: #FFF;',
'    text-align: center;',
'    border-radius: 12px;',
'    font-size: 15px;',
'    border: 1px solid green;',
'    text-shadow: 0 -1px 0 rgba(0,0,0,.15);',
'    vertical-align: top;',
'    margin-right: 4px;',
'}',
'.valid_user {',
'    display: inline-block;',
'    padding: 4px 8px 4px 4px;',
'    border: 1px solid #D0D0D0;',
'    border-radius: 3px;',
'    line-height: 20px;',
'    background-color: #F8F8F8;',
'    color: #404040;',
'}'))
,p_step_template=>wwv_flow_api.id(741371098457994312.4757)
,p_required_role=>wwv_flow_api.id(1020614257688498212)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801930208766292145.4757)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(801931007075292146.4757)
,p_name=>unistr('\6709\6548\7684\4F7F\7528\8005')
,p_template=>wwv_flow_api.id(805699740467941340.4757)
,p_display_sequence=>20
,p_region_template_options=>'a-Region--flush:is-expanded:a-Region--noPadding:a-Region--noBorder'
,p_component_template_options=>'#DEFAULT#:a-Report--stretch'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    case when :P302_STRIP_DOMAIN = ''N'' then',
'        lower(c001)',
'    else',
'        lower(substr(c001,1,instr(c001,''@'') - 1))',
'    end as username',
'from',
'    apex_collections',
'where',
'    collection_name = ''BULK_USER_VALID''',
'order by',
'    1'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>5000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\6709\6548\7684\96FB\5B50\90F5\4EF6\5730\5740.')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>5000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(801931278586292147.4757)
,p_query_column_id=>1
,p_column_alias=>'USERNAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\4F7F\7528\8005\540D\7A31')
,p_use_as_row_header=>'N'
,p_column_html_expression=>'<div class="u-alignTop"><span class="a-Icon icon-check u-textSuccess"></span> #USERNAME#</div>'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_derived_column=>'N'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(801931409743292147.4757)
,p_name=>unistr('\7121\6548\7684\4F7F\7528\8005')
,p_template=>wwv_flow_api.id(805699740467941340.4757)
,p_display_sequence=>40
,p_region_template_options=>'a-Region--flush:is-expanded:a-Region--noBorder'
,p_component_template_options=>'#DEFAULT#'
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    case when :P302_STRIP_DOMAIN = ''N'' then',
'        lower(c001)',
'    else',
'        lower(substr(c001,1,instr(c001,''@'') - 1))',
'    end as username,',
'    c002 reason',
'from',
'    apex_collections',
'where',
'    collection_name = ''BULK_USER_INVALID''',
'order by',
'    1'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>5000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\4EFB\4F55\7121\6548\7684\65B0\4F7F\7528\8005')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>5000
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(801931653273292147.4757)
,p_query_column_id=>1
,p_column_alias=>'USERNAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\4F7F\7528\8005\540D\7A31')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(805572136806814040.4757)
,p_query_column_id=>2
,p_column_alias=>'REASON'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\70BA\4F55\7121\6548?')
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(801931985785292147.4757)
,p_plug_name=>unistr('\5EFA\7ACB\591A\4F4D\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805132117516607920.4757)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805565776704660721.4757)
,p_plug_name=>unistr('\96B1\85CF\7684\9805\76EE')
,p_region_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>15
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805570158936760911.4757)
,p_plug_name=>'Valid Users Exists'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>16
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<div class="a-Wizard-regionHeader">'');',
'sys.htp.p(wwv_flow_lang.system_message(''ABOUT_TO_CREATE_USERS'', :P303_VALID_COUNT));',
'if :P303_INVALID_COUNT > 0 then',
'    sys.htp.p(wwv_flow_lang.system_message(''INVALID_USERS_NOT_CREATED'', :P303_INVALID_COUNT));',
'end if;',
'sys.htp.p(''</div>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from apex_collections',
' where collection_name = ''BULK_USER_VALID'''))
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805570574949788758.4757)
,p_plug_name=>unistr('\6C92\6709\6709\6548\7684\4F7F\7528\8005\5B58\5728')
,p_region_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>17
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\4E0A\4E00\9801\7684\4F7F\7528\8005\540D\7A31\6E05\55AE\4E2D\6C92\6709\4EFB\4F55\6709\6548\7684\4F7F\7528\8005\540D\7A31, \5171\6709 &P303_INVALID_COUNT. \500B\7121\6548\7684\4F7F\7528\8005\540D\7A31. \8ACB\56DE\5230\8A72\9801\6AA2\67E5\60A8\6240\63D0\4F9B\7684\4F7F\7528\8005\540D\7A31\6E05\55AE.</p>')
,p_plug_query_num_rows=>15
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from apex_collections',
' where collection_name = ''BULK_USER_VALID'''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801930430813292145.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(801930208766292145.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801930665459292145.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(801930208766292145.4757)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--large'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB\6709\6548\7684\4F7F\7528\8005')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(801930872562292146.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(801930208766292145.4757)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404711161197908978.4757)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:302:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(801932483224292148.4757)
,p_branch_action=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805567015654677130.4757)
,p_name=>'P303_VALID_COUNT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(805565776704660721.4757)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*)',
'  from apex_collections',
' where collection_name = ''BULK_USER_VALID'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805567384283686280.4757)
,p_name=>'P303_INVALID_COUNT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(805565776704660721.4757)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*)',
'  from apex_collections',
' where collection_name = ''BULK_USER_INVALID'''))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(801932143563292147.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Users'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_collection.truncate_collection(''BULK_USER_CREATE'');',
'',
'for c in',
'(',
'    select ',
'        case when :P302_STRIP_DOMAIN = ''N'' then',
'            lower(c001)',
'        else',
'            lower(substr(c001,1,instr(c001,''@'') - 1))',
'        end as username',
'    from',
'        apex_collections',
'    where',
'        collection_name = ''BULK_USER_VALID''',
'    order by',
'        1',
')',
'loop',
'    apex_collection.add_member(',
'        p_collection_name => ''BULK_USER_CREATE'',',
'        p_c001            => upper(c.username),',
'        p_c002            => c.username);',
'        commit;',
'end loop;',
'',
'wwv_flow_fnd_user_api.create_user_from_collection (',
'    p_security_group_id         => :flow_security_group_id,',
'    p_web_password              => :P302_WEB_PASSWORD,',
'    p_allow_access_to_schemas   => null,',
'    p_default_schema            => :P302_DEFAULT_SCHEMA,',
'    p_developer                 => :P302_DEVELOPER,',
'    p_admin                     => :P302_ADMIN,',
'    p_allow_app_building_yn     => case when :P302_ADMIN = ''Y'' or :P302_DEVELOPER = ''Y'' then ''Y'' else ''N'' end,',
'    p_allow_sql_workshop_yn     => case when :P302_ADMIN = ''Y'' or :P302_DEVELOPER = ''Y'' then ''Y'' else ''N'' end,',
'    p_allow_websheet_dev_yn     => case when :P302_ADMIN = ''Y'' or :P302_DEVELOPER = ''Y'' then ''Y'' else ''N'' end,',
'    p_allow_team_development_yn => case when :P302_ADMIN = ''Y'' or :P302_DEVELOPER = ''Y'' then ''Y'' else ''N'' end);',
'',
'---------------------',
'-- delete collections',
'--',
'wwv_flow_collection.DELETE_COLLECTION(''BULK_USER_INVALID'');',
'wwv_flow_collection.DELETE_COLLECTION(''BULK_USER_VALID'');',
'wwv_flow_collection.DELETE_COLLECTION(''BULK_USER_CREATE'');',
'',
'commit;'))
,p_process_error_message=>unistr('\5EFA\7ACB\4F7F\7528\8005\6642\767C\751F\672A\9810\671F\7684\932F\8AA4')
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\4F7F\7528\8005')
);
end;
/
prompt --application/pages/page_00305
begin
wwv_flow_api.create_page(
 p_id=>305.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\522A\9664\591A\4F4D\4F7F\7528\8005')
,p_step_title=>unistr('\522A\9664\591A\4F4D\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(805159035944749645)
,p_step_template=>wwv_flow_api.id(741368521013994306.4757)
,p_required_role=>wwv_flow_api.id(1020614257688498212)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_del_multi_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805152858409739453.4757)
,p_plug_name=>unistr('\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(805538978589340502.4757)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select case',
'      when u."USER"=:APP_USER then null',
'      else wwv_flow_item.checkbox(1,wwv_flow_escape.html(user_id),''title="''||wwv_flow_lang.system_message(''SELECT_ROW_C'', wwv_flow_escape.html(u."USER"))||''"'')',
'    end c,',
'    alt,',
'    "USER",',
'    "eMail",',
'    first_name,',
'    last_name,',
'    df, -- default schema',
'    developer,',
'    last_login,',
'    last_login2,',
'    builder_login_count,',
'    ul, -- is user locked?',
'    expiration,',
'    description,',
'    password_lifespan_days,',
'    password_lifespan_accesses,',
'    password_accesses_left,',
'    last_agent,',
'    last_ip,',
'    account_expiry,',
'    failed_access_attempts,',
'    change_password_on_first_use,',
'    first_password_use_occurred,',
'    dev_type,',
'    group_id,',
'    group_name,',
'    last_update_date,',
'    last_updated_by,',
'    creation_date,',
'    created_by,',
'    allow_app_building,',
'    allow_sql_workshop,',
'    allow_websheet_dev,',
'    allow_team_devopment',
'from wwv_flow_workspace_users u',
'where workspace_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(805153049948739455.4757)
,p_name=>'Internal Accounts'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_link_column=>'LINK'
,p_icon_view_img_src_column=>'ICON_VIEW_ICON'
,p_icon_view_label_column=>'ICON_VIEW_NAME'
,p_icon_view_columns_per_row=>5
,p_owner=>'MIKE'
,p_internal_uid=>805153049948739455
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154452851739462.4757)
,p_db_column_name=>'USER'
,p_display_order=>2
,p_column_identifier=>'F'
,p_column_label=>unistr('\4F7F\7528\8005')
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154562844739462.4757)
,p_db_column_name=>'eMail'
,p_display_order=>3
,p_column_identifier=>'G'
,p_column_label=>unistr('\96FB\5B50\90F5\4EF6')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154697017739463.4757)
,p_db_column_name=>'FIRST_NAME'
,p_display_order=>4
,p_column_identifier=>'H'
,p_column_label=>unistr('\540D\5B57')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154775931739463.4757)
,p_db_column_name=>'LAST_NAME'
,p_display_order=>5
,p_column_identifier=>'I'
,p_column_label=>unistr('\59D3\6C0F')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154862480739463.4757)
,p_db_column_name=>'DF'
,p_display_order=>6
,p_column_identifier=>'J'
,p_column_label=>unistr('\9810\8A2D\7684\7DB1\8981')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155265465739463.4757)
,p_db_column_name=>'UL'
,p_display_order=>7
,p_column_identifier=>'N'
,p_column_label=>unistr('\9396\5B9A')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155449084739463.4757)
,p_db_column_name=>'DEV_TYPE'
,p_display_order=>8
,p_column_identifier=>'P'
,p_column_label=>unistr('\5E33\6236\985E\578B')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154900740739463.4757)
,p_db_column_name=>'DEVELOPER'
,p_display_order=>9
,p_column_identifier=>'K'
,p_column_label=>unistr('\5BC6\78BC\72C0\614B')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155326334739463.4757)
,p_db_column_name=>'EXPIRATION'
,p_display_order=>10
,p_column_identifier=>'O'
,p_column_label=>unistr('\4E00\822C\4F7F\7528\8005\5E33\6236')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155090045739463.4757)
,p_db_column_name=>'LAST_LOGIN'
,p_display_order=>11
,p_column_identifier=>'L'
,p_column_label=>unistr('\4E0A\6B21\767B\5165\7522\751F\5668\7684\65E5\671F')
,p_column_type=>'DATE'
,p_format_mask=>'&DATE_TIME_FORMAT.'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155103748739463.4757)
,p_db_column_name=>'BUILDER_LOGIN_COUNT'
,p_display_order=>12
,p_column_identifier=>'M'
,p_column_label=>unistr('\7522\751F\5668\767B\5165\8A08\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154392117739462.4757)
,p_db_column_name=>'ALT'
,p_display_order=>14
,p_column_identifier=>'B'
,p_column_label=>unistr('\66FF\4EE3\9805\76EE')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155508386739463.4757)
,p_db_column_name=>'LAST_LOGIN2'
,p_display_order=>17
,p_column_identifier=>'Q'
,p_column_label=>unistr('\4E0A\6B21\767B\5165\7522\751F\5668\7684\6642\9593')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155691776739463.4757)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('\63CF\8FF0')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155776415739463.4757)
,p_db_column_name=>'PASSWORD_LIFESPAN_DAYS'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('\5BC6\78BC\9031\671F\5929\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155852146739464.4757)
,p_db_column_name=>'PASSWORD_LIFESPAN_ACCESSES'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('\5BC6\78BC\9031\671F\5B58\53D6\6B21\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805155941815739464.4757)
,p_db_column_name=>'PASSWORD_ACCESSES_LEFT'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5269\9918\5BC6\78BC\5B58\53D6\6B21\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805156033975739464.4757)
,p_db_column_name=>'LAST_AGENT'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>unistr('\6700\5F8C\4E00\500B\4EE3\7406\7A0B\5F0F')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805156134721739464.4757)
,p_db_column_name=>'LAST_IP'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>unistr('\6700\5F8C\4E00\500B IP \4F4D\5740')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805156202268739464.4757)
,p_db_column_name=>'ACCOUNT_EXPIRY'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('\5E33\6236\904E\671F')
,p_column_type=>'DATE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805156382420739464.4757)
,p_db_column_name=>'FAILED_ACCESS_ATTEMPTS'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('\5931\6557\7684\5B58\53D6\5617\8A66\6B21\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805156438203739464.4757)
,p_db_column_name=>'CHANGE_PASSWORD_ON_FIRST_USE'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\7B2C\4E00\6B21\4F7F\7528\6642\8B8A\66F4\5BC6\78BC')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153178863739460.4757)
,p_db_column_name=>'FIRST_PASSWORD_USE_OCCURRED'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\7B2C\4E00\6B21\4F7F\7528\5BC6\78BC\7684\6642\9593')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153242925739461.4757)
,p_db_column_name=>'GROUP_ID'
,p_display_order=>28
,p_column_identifier=>'AB'
,p_column_label=>unistr('\7FA4\7D44 ID')
,p_column_type=>'STRING'
,p_column_alignment=>'RIGHT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153314834739461.4757)
,p_db_column_name=>'GROUP_NAME'
,p_display_order=>29
,p_column_identifier=>'AC'
,p_column_label=>unistr('\7FA4\7D44\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153423706739461.4757)
,p_db_column_name=>'LAST_UPDATE_DATE'
,p_display_order=>30
,p_column_identifier=>'AD'
,p_column_label=>unistr('\66F4\65B0\6642\9593')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153538236739461.4757)
,p_db_column_name=>'LAST_UPDATED_BY'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\66F4\65B0\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153645096739461.4757)
,p_db_column_name=>'CREATION_DATE'
,p_display_order=>32
,p_column_identifier=>'AF'
,p_column_label=>unistr('\5EFA\7ACB\6642\9593')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153737217739461.4757)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>33
,p_column_identifier=>'AG'
,p_column_label=>unistr('\5EFA\7ACB\8005')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153874089739461.4757)
,p_db_column_name=>'ALLOW_APP_BUILDING'
,p_display_order=>35
,p_column_identifier=>'AI'
,p_column_label=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805153976154739461.4757)
,p_db_column_name=>'ALLOW_SQL_WORKSHOP'
,p_display_order=>36
,p_column_identifier=>'AJ'
,p_column_label=>unistr('SQL \5DE5\4F5C\5BA4')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154030855739461.4757)
,p_db_column_name=>'ALLOW_WEBSHEET_DEV'
,p_display_order=>37
,p_column_identifier=>'AK'
,p_column_label=>unistr('Web \8A66\7B97\8868')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154126292739462.4757)
,p_db_column_name=>'ALLOW_TEAM_DEVOPMENT'
,p_display_order=>38
,p_column_identifier=>'AL'
,p_column_label=>unistr('\5718\968A\958B\767C')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(805154228669739462.4757)
,p_db_column_name=>'C'
,p_display_order=>39
,p_column_identifier=>'AM'
,p_column_label=>'#CHECK_ALL_CHECKBOX#'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805152413092739452.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805152858409739453.4757)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805152655703739453.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805152858409739453.4757)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\522A\9664\4F7F\7528\8005')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805157722129739476.4757)
,p_branch_action=>'305'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>20
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805157376626739474.4757)
,p_validation_name=>'AtLeastOneSelected'
,p_validation_sequence=>10
,p_validation=>'wwv_flow.g_f01.count > 0'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>unistr('\81F3\5C11\5FC5\9808\9078\53D6\4E00\4F4D\8981\522A\9664\7684\4F7F\7528\8005.')
,p_when_button_pressed=>wwv_flow_api.id(805152655703739453.4757)
,p_associated_item=>wwv_flow_api.id(.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1889782220188872433.4757)
,p_name=>'ADD CHECK ALL CHECKBOX'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(805152858409739453.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1889782368209872434.4757)
,p_event_id=>wwv_flow_api.id(1889782220188872433.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'PLUGIN_COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805157495139739475.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete users'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count loop',
'   wwv_flow_fnd_user_api.remove_fnd_user(',
'             p_user_id => to_number(wwv_flow.g_f01(i)));',
'end loop;'))
,p_process_error_message=>unistr('\7121\6CD5\522A\9664\4F7F\7528\8005.')
,p_process_when_button_id=>wwv_flow_api.id(805152655703739453.4757)
,p_process_success_message=>unistr('\5DF2\522A\9664\4F7F\7528\8005.')
);
end;
/
prompt --application/pages/page_00306
begin
wwv_flow_api.create_page(
 p_id=>306.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\7DE8\8F2F\4F7F\7528\8005')
,p_step_title=>unistr('\7DE8\8F2F\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="javascript">',
'<!--',
'function confirmaction(){',
'        if (document.wwv_flow.F4750_P306_EMAIL_ADDRESS.value != document.wwv_flow.F4750_P306_ORG_EMAIL_ADDRESS.value){',
'	if(confirm("Are you sure you want to change the email address?")){',
'		doSubmit(''ApplyChanges'') ;',
'          }',
'        }else{',
'            doSubmit(''ApplyChanges'') ;',
'        }',
' }',
'//-->',
'</script>'))
,p_step_template=>wwv_flow_api.id(741366253443994295.4757)
,p_required_role=>wwv_flow_api.id(1020614257688498212)
,p_nav_list_template_options=>'#DEFAULT#'
,p_help_text=>'AEADM/aadm_users.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805476722517047764.4757)
,p_plug_name=>unistr('\7DE8\8F2F\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_row_template=>wwv_flow_api.id(1939532588110833.4757)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'generated 19-FEB-2000 22:09:25'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805481624163047770.4757)
,p_plug_name=>unistr('&PRODUCT_NAME. \4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\4F7F\7528\8005\7BA1\7406\7A0B\5F0F\6703\7DAD\8B77\8A8D\8B49\914D\7F6E\6240\4F7F\7528\7684\5E33\6236, \9019\4E9B\8A8D\8B49\914D\7F6E\6703\8A8D\8B49\5132\5B58\5728\9019\4E9B\5E33\6236\4E2D\7684\4F7F\7528\8005\540D\7A31\548C\5BC6\78BC.</p>'),
unistr('<p>\5982\679C\60A8\60F3\8B8A\66F4\4F7F\7528\8005\7684\5BC6\78BC, \8ACB\8F38\5165\65B0\5BC6\78BC. \5426\5247, \8ACB\5C07\5BC6\78BC\6B04\4F4D\7559\767D, \4E0D\8B8A\66F4\76EE\524D\7684\5BC6\78BC.</p>')))
,p_plug_query_row_template=>wwv_flow_api.id(1939532588110833.4757)
,p_plug_query_num_rows=>1500
,p_plug_query_num_rows_type=>'ROWS_X_TO_Y_OF_Z'
,p_plug_column_width=>'valign="top"'
,p_plug_query_show_nulls_as=>'(null)'
,p_plug_query_col_allignments=>'L:L:R:L:L:L:L:L'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805481820598047770.4757)
,p_plug_name=>unistr('\5E33\6236\6B0A\9650')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805489136243047777.4757)
,p_plug_name=>'reset'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4750_P306_WEB_PASSWORD := null;',
':F4750_P306_USER_PASSWORD := null;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805489399242047777.4757)
,p_plug_name=>unistr('\7BA1\7406\4F7F\7528\8005')
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'sys.htp.prn(wwv_flow_lang.system_message(''PKG_APP_USER_TYPE_DESCRIPTION''));'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805489568429047778.4757)
,p_plug_name=>unistr('\5340\57DF\986F\793A\9078\53D6\5668')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404672496027804677.4757)
,p_plug_display_sequence=>30
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805490464350047780.4757)
,p_plug_name=>unistr('\4F7F\7528\8005: &F4750_P306_USER_NAME.')
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noUI:a-ButtonRegion--showTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_column_width=>'valign="top"'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(805491259930047781.4757)
,p_plug_name=>'&F4350_PASSWORD_REGION_TITLE.'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805490644256047780.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(805490464350047780.4757)
,p_button_name=>'Cancel'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:&LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805490871563047781.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(805490464350047780.4757)
,p_button_name=>'Delete'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\522A\9664\4F7F\7528\8005')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:confirmDelete(''&DELETE_MSG.'',''Delete'');'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from dual where :F4750_P306_USER_ID is null',
'union all',
'select 1 from wwv_flow_developers where user_id = nvl(:F4750_P306_USER_ID,-1) and upper(userid)=upper(:FLOW_USER) and security_group_id=:FLOW_SECURITY_GROUP_ID'))
,p_button_condition_type=>'NOT_EXISTS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(805491074986047781.4757)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(805490464350047780.4757)
,p_button_name=>'ApplyChanges'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:confirmaction();'
,p_button_condition=>'F4750_P306_USER_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805507274863047807.4757)
,p_branch_action=>'306'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'ADD_PRIV'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805507463953047808.4757)
,p_branch_action=>'306'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'BRANCH_TO_STEP'
,p_branch_when_button_id=>wwv_flow_api.id(2952830054296949.4757)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(805507663918047808.4757)
,p_branch_name=>'Go To Page &LAST_VIEW.'
,p_branch_action=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>30
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805476921966047766.4757)
,p_name=>'F4750_P306_USER_ID'
,p_data_type=>'NUMBER'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805477148150047766.4757)
,p_name=>'F4750_P306_COMPANY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_prompt=>unistr('\5DE5\4F5C\5340:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_attributes=>'class="fieldtitlebold"'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8B58\5225\6B64\4F7F\7528\8005\6240\5C6C\7684\5DE5\4F5C\5340.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805477651541047766.4757)
,p_name=>'F4750_P306_USER_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_read_only_when=>'F4750_P306_USER_NAME'
,p_read_only_when2=>'&APP_USER.'
,p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6307\5B9A\767B\5165\7CFB\7D71\6240\4F7F\7528\7684\4F7F\7528\8005\540D\7A31. \4F7F\7528\8005\540D\7A31\6709\4E0B\5217\9650\5236: <ul><li>'),
unistr('\9577\5EA6\4E0A\9650\70BA 100 \500B\5B57\5143</li><li>'),
unistr('\4E0D\53EF\6709\7A7A\683C</li>'),
unistr('<li>\53EA\5141\8A31\4EE5\4E0B\7279\6B8A\5B57\5143: @ \548C\53E5\865F (.)</li></ul>'),
unistr('<p>\60A8\4E5F\53EF\4EE5\4F7F\7528\4F7F\7528\8005\540D\7A31\53C3\7167\4F7F\7528\76E3\7763\5668\61C9\7528\7A0B\5F0F\7684\4F7F\7528\8005\6D3B\52D5. \7D44\5EFA\61C9\7528\7A0B\5F0F\6642, \9023\7D50\8B8A\6578 <code>:app_user</code> \6703\50B3\56DE\76EE\524D\4F7F\7528\8005\7684\503C.</p>')))
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805478117441047766.4757)
,p_name=>'F4750_P306_EMAIL_ADDRESS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_prompt=>unistr('\96FB\5B50\90F5\4EF6\5730\5740')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\4E00\822C\9805\76EE, \91CD\8A2D\5BC6\78BC\901A\77E5\7B49\4F7F\7528\7684\96FB\5B50\90F5\4EF6\5730\5740.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805478659870047767.4757)
,p_name=>'F4750_P306_ORG_EMAIL_ADDRESS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_source=>'&F4750_P306_ORG_EMAIL_ADDRESS.'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805478898050047767.4757)
,p_name=>'F4750_P306_START_DATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805479084861047768.4757)
,p_name=>'F4750_P306_END_DATE'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805479289917047768.4757)
,p_name=>'F4750_P306_EMPLOYEE_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805479420071047768.4757)
,p_name=>'F4750_P306_PERSON_TYPE'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_item_default=>'E'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805479626327047769.4757)
,p_name=>'F4750_P306_FIRST_NAME'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_prompt=>unistr('\540D\5B57')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\4F7F\7528\8005\7684\540D\5B57\4EE5\9032\4E00\6B65\8B58\5225\4F7F\7528\8005. \6B64\9078\64C7\6027\6B04\4F4D\50C5\4F9B\8CC7\8A0A\76EE\7684\4E4B\7528.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805480115055047769.4757)
,p_name=>'F4750_P306_LAST_NAME'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_prompt=>unistr('\59D3\6C0F')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\4F7F\7528\8005\7684\59D3\6C0F\4EE5\9032\4E00\6B65\8B58\5225\4F7F\7528\8005. \6B64\9078\64C7\6027\6B04\4F4D\50C5\4F9B\8CC7\8A0A\76EE\7684\4E4B\7528.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805480656568047770.4757)
,p_name=>'P306_DESCRIPTION'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_prompt=>unistr('\63CF\8FF0')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>200
,p_cHeight=>3
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_input=>'Y'
,p_help_text=>unistr('\8ACB\5728\6B64\6B04\4F4D\4E2D\8F38\5165\6709\95DC\4F7F\7528\8005\7684\8A3B\89E3 (\50C5\4F9B\8CC7\8A0A\76EE\7684\4E4B\7528).')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'Y'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805481193543047770.4757)
,p_name=>'P306_DEFAULT_DATE_FORMAT'
,p_item_sequence=>400
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_prompt=>'Default Date Format'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\4F7F\7528\8005\7684\9810\8A2D Oracle \65E5\671F\683C\5F0F.  \6B64\683C\5F0F\5C07\63A7\5236\300CSQL \5DE5\4F5C\5BA4\300D\5167\7684\9810\8A2D\65E5\671F\683C\5F0F.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805482085475047770.4757)
,p_name=>'F4750_P306_DEFAULT_SCHEMA'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_prompt=>unistr('\9810\8A2D\7684\7DB1\8981')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_named_lov=>'LIST_AVAILABLE_SCHEMAS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(schema) d, schema r',
'',
'from   wwv_flow_company_schemas',
'',
'where  security_group_id = :flow_security_group_id',
'',
'order by 1'))
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_input=>'N'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_help_text=>unistr('\6307\5B9A\7528\65BC\700F\89BD\8CC7\6599, \5EFA\7ACB\61C9\7528\7A0B\5F0F, \4EE5\53CA\57F7\884C SQL \547D\4EE4\6A94\7684\9810\8A2D\7DB1\8981. \4F7F\7528\6709\4E00\500B\4EE5\4E0A\7DB1\8981\7684\5DE5\4F5C\5340\6642, \6B64\7DB1\8981\70BA\5EFA\7ACB\61C9\7528\7A0B\5F0F, \57F7\884C SQL \67E5\8A62\7B49\6642\6240\4F7F\7528\7684\9810\8A2D\7DB1\8981. \9019\9805\529F\80FD\4E0D\63A7\5236\5B89\5168\6027, \50C5\50C5\662F\4F7F\7528\8005\7684\504F\597D\8A2D\5B9A.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805482577589047771.4757)
,p_name=>'F4750_P306_ACCESS_TO_SCHEMAS'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_prompt=>unistr('\53EF\5B58\53D6\7684\7DB1\8981 (\7A7A\503C\8868\793A\53EF\5B58\53D6\5168\90E8)')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_input=>'N'
,p_help_text=>unistr('\8F38\5165\6B64\958B\767C\4EBA\54E1\5728\4F7F\7528\300CSQL \5DE5\4F5C\5BA4\300D\6642, \6709\6B0A\5B58\53D6\7684\7DB1\8981\6E05\55AE (\4F7F\7528\5192\865F\5340\9694). \60A8\5728\6B64\8655\8F38\5165\7684\7DB1\8981\6E05\55AE\6C7A\5B9A\4E86\4F7F\7528\8005\6240\80FD\5B58\53D6\7684\7DB1\8981 (\4EA6\5373, \70BA\5DE5\4F5C\5340\4F48\5EFA\4E4B\4E00\7D44\5B8C\6574\7DB1\8981\7684\90E8\5206\7DB1\8981), \4E26\4E14\6C7A\5B9A\4F7F\7528\8005\5728\300CSQL \5DE5\4F5C\5BA4\300D\6240\898B\7684\7DB1\8981\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805483093454047772.4757)
,p_name=>'F4750_P306_DEVELOPER_ROLE'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805483273721047772.4757)
,p_name=>'P306_ADMIN'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\4F7F\7528\8005\662F\5DE5\4F5C\5340\7BA1\7406\54E1:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cSize=>30
,p_cHeight=>1
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P56_ADMIN_0.checked) document.forms[0].P56_DEVELOPER_0.checked = true;"'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6307\5B9A\6B64\4F7F\7528\8005\662F\5426\61C9\8A72\5177\5099\5DE5\4F5C\5340\7BA1\7406\54E1\6B0A\9650. \7BA1\7406\54E1\53EF\4EE5\5B58\53D6\6240\6709\5143\4EF6. \6B64\5916, \4ED6\5011\9084\53EF\4EE5\7BA1\7406\4F7F\7528\8005\5E33\6236\548C\958B\767C\670D\52D9.'),
'',
unistr('\5982\679C\300C\57F7\884C\8655\7406\7BA1\7406\54E1\300D\5C07\5143\4EF6\95DC\9589, \5C31\7121\6CD5\4F7F\7528\9019\4E9B\5143\4EF6.')))
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
,p_attribute_04=>'VERTICAL'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805483794897047773.4757)
,p_name=>'P306_DEVELOPER'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\4F7F\7528\8005\662F\958B\767C\4EBA\54E1:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'DEVELOPER TYPE'
,p_lov=>'.'||wwv_flow_api.id(801895490296261989.4757)||'.'
,p_tag_attributes=>'onClick="javascript:if (document.forms[0].P56_ADMIN_0.checked) document.forms[0].P56_DEVELOPER_0.checked = true;"'
,p_read_only_when=>'not wwv_flow_authentication_dev.can_edit_builder_users'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\6307\5B9A\6B64\4F7F\7528\8005\662F\5426\61C9\8A72\5177\5099\958B\767C\4EBA\54E1\6B0A\9650. \958B\767C\4EBA\54E1\53EF\4EE5\5B89\88DD\3001\79FB\9664\6216\5347\7D1A\751F\7522\529B\61C9\7528\7A0B\5F0F.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805484251562047773.4757)
,p_name=>'P306_ALLOW_APP_BUILDING_YN'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(ALLOW_APP_BUILDING_YN,''Y'')',
'from wwv_flow_fnd_user ',
'where user_id = :F4750_P306_USER_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805484726459047774.4757)
,p_name=>'P306_DISALLOW_APP_BUILDING'
,p_item_sequence=>201
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805485207898047774.4757)
,p_name=>'P306_ALLOW_WEBSHEET_DEV_YN'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('Web \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A')
,p_source=>'select ALLOW_WEBSHEET_DEV_YN from wwv_flow_fnd_user where user_id = :F4750_P306_USER_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\5177\5099\300CWeb \8A66\7B97\8868\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300CWeb \8A66\7B97\8868\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300CWeb \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805485738575047775.4757)
,p_name=>'P306_DISALLOW_WEBSHEET_DEV'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('Web \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\5177\5099\300CWeb \8A66\7B97\8868\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300CWeb \8A66\7B97\8868\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300CWeb \8A66\7B97\8868\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805486274035047775.4757)
,p_name=>'P306_ALLOW_SQL_WORKSHOP_YN'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('SQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A')
,p_source=>'select ALLOW_SQL_WORKSHOP_YN from wwv_flow_fnd_user where user_id = :F4750_P306_USER_ID'
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300CSQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805486791836047775.4757)
,p_name=>'P306_DISALLOW_SQL_WORKSHOP'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('SQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\958B\767C\4EBA\54E1\662F\5426\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\80FD\5920\5B58\53D6\300CSQL \5DE5\4F5C\5BA4\300D.<br>'),
unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\5982\679C\505C\7528\5DE5\4F5C\5340\7684\300CSQL \5DE5\4F5C\5BA4\5B58\53D6\6B0A\300D, \6B64\5C6C\6027\4E00\5F8B\6703\505C\7528.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805487282904047776.4757)
,p_name=>'P306_ALLOW_TEAM_DEVELOPMENT_YN'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'Y'
,p_prompt=>unistr('\5718\968A\958B\767C\5B58\53D6\6B0A')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_TEAM_DEVELOPMENT_YN ',
'from wwv_flow_fnd_user ',
'where user_id = :F4750_P306_USER_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\4F7F\7528\8005\662F\5426\5177\5099\300C\5718\968A\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300C\5718\968A\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300C\5718\968A\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805487734768047776.4757)
,p_name=>'P306_DISALLOW_TEAM_DEVELOPMENT'
,p_item_sequence=>370
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_use_cache_before_default=>'NO'
,p_item_default=>'N'
,p_prompt=>unistr('\5718\968A\958B\767C\5B58\53D6\6B0A')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6C7A\5B9A\4F7F\7528\8005\662F\5426\5177\5099\300C\5718\968A\958B\767C\300D\7684\5B58\53D6\6B0A.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\4E00\5F8B\53EF\4EE5\5B58\53D6\300C\5718\968A\958B\767C\300D.<br>'),
'<br>',
unistr('\300C\7BA1\7406\54E1\300D\505C\7528\5DE5\4F5C\5340\7684\300C\5718\968A\958B\767C\5B58\53D6\6B0A\300D\6642, \4E00\5F8B\6703\505C\7528\6B64\5C6C\6027.')))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805488281662047776.4757)
,p_name=>'P306_ACCOUNT_EXPIRY'
,p_item_sequence=>380
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805488437441047776.4757)
,p_name=>'P306_ACCOUNT_LOCKED'
,p_item_sequence=>390
,p_item_plug_id=>wwv_flow_api.id(805481820598047770.4757)
,p_item_default=>'N'
,p_prompt=>unistr('\5E33\6236\4F7F\7528\72C0\614B')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ACCOUNT_LOCK_STATUS'
,p_lov=>'.'||wwv_flow_api.id(805398623015787070.4757)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6<b>\9396\5B9A</b>\53EF\9632\6B62\5E33\6236\88AB\4F7F\7528. \9078\53D6<b>\89E3\9664\9396\5B9A</b>\4EE5\5141\8A31\4F7F\7528\5E33\6236.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805489966639047779.4757)
,p_name=>'F4750_P306_GROUPS'
,p_item_sequence=>310
,p_item_plug_id=>wwv_flow_api.id(805476722517047764.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6B64\4F7F\7528\8005\5C6C\65BC\6A19\793A\7684\7FA4\7D44. \82E5\8981\65B0\589E\4F7F\7528\8005\81F3\7FA4\7D44, \8ACB\6309\4E00\4E0B\540D\7A31\4F86\6A19\793A\540D\7A31. \82E5\8981\79FB\9664\67D0\500B\7FA4\7D44, \8ACB\518D\6309\4E00\4E0B\8A72\7FA4\7D44\4EE5\53D6\6D88\5176\6A19\793A. </p> '),
unistr('<p>\958B\767C\4EBA\54E1\53EF\4EE5\5229\7528\7FA4\7D44\6307\6D3E\529F\80FD, \4F9D\7FA4\7D44\63A7\5236\5C0D\7279\5B9A\7279\6027\548C\529F\80FD\7684\5B58\53D6. '),
unistr('\6B64\7FA4\7D44\529F\80FD\5167\5EFA\65BC\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D, \6700\9069\5408\8207\61C9\7528 Cookie \7684\8A8D\8B49\642D\914D\4F7F\7528 (\4E5F\6700\65B9\4FBF). '),
unistr('\4E0D\904E, \6B64\4F7F\7528\8005\7FA4\7D44\529F\80FD\4E0D\80FD\5728\4E0D\540C\7684\8A8D\8B49\7DB1\8981\4E4B\9593\904B\4F5C.</p>'),
''))
,p_attribute_01=>'Y'
,p_item_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'and user_id = :F4750_P306_USER_ID',
'',
''))
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805491451692047782.4757)
,p_name=>'F4750_P306_WEB_PASSWORD'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5BC6\78BC')
,p_post_element_text=>unistr(' <span class="instructiontext">\5BC6\78BC\6709\5927\5C0F\5BEB\4E4B\5206</span>')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('\767B\5165\7CFB\7D71\6240\4F7F\7528\7684\5BC6\78BC. \9664\975E\60A8\8981\8B8A\66F4\76EE\524D\7684\5BC6\78BC, \5426\5247\8ACB\52FF\8F38\5165\5BC6\78BC.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805491931409047782.4757)
,p_name=>'F4750_P306_USER_PASSWORD'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\78BA\8A8D\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>unistr('\518D\8F38\5165\4E00\6B21\5BC6\78BC. \9664\975E\60A8\60F3\8B8A\66F4\76EE\524D\7684\5BC6\78BC, \5426\5247\8ACB\52FF\8F38\5165\5BC6\78BC.')
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805492442998047783.4757)
,p_name=>'P306_UPDATE_PW'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805492653436047784.4757)
,p_name=>'P306_FIRST_PWD_USE_OCCURRED'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805492824699047784.4757)
,p_name=>'P306_CHANGE_PWD_ON_FIRST_USE'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_prompt=>unistr('\7B2C\4E00\6B21\4F7F\7528\6642\9700\8981\8B8A\66F4\5BC6\78BC')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'YES_NO_RETURNS_Y_OR_N'
,p_lov=>'.'||wwv_flow_api.id(801893675976261985.4757)||'.'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6<b>\662F</b>, \8981\6C42\6B64\5E33\6236\7684\4F7F\7528\8005\5728\7B2C\4E00\6B21\4F7F\7528\76EE\524D\7684\5BC6\78BC\767B\5165\4E4B\5F8C\7ACB\5373\8B8A\66F4\5BC6\78BC. \6B64\898F\5247\9069\7528\65BC\4F7F\7528\6B64\5E33\6236\9032\884C\5DE5\4F5C\5340\7BA1\7406\6216\958B\767C, \4EE5\53CA\4F7F\7528\6B64\5E33\6236\767B\5165\5DF2\958B\767C\4E4B\61C9\7528\7A0B\5F0F\7B49\60C5\6CC1.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805493322626047784.4757)
,p_name=>'P306_EXPIRATION_STATUS1'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_prompt=>unistr('\958B\767C\4EBA\54E1/\7BA1\7406\54E1\5BC6\78BC:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_display_when=>'P306_EXPIRATION_STATUS1'
,p_display_when2=>'NA'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\4EE3\8868\5BC6\78BC\5C0D\65BC\958B\767C\4EBA\54E1\6216\5DE5\4F5C\5340\7BA1\7406\54E1\767B\5165\662F\5426\6709\6548.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805493891524047785.4757)
,p_name=>'P306_EXPIRATION_STATUS2'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_prompt=>unistr('\4E00\822C\4F7F\7528\8005\5BC6\78BC:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_display_when=>'P306_EXPIRATION_STATUS2'
,p_display_when2=>'NA'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\793A\5BC6\78BC\5C0D\65BC\300C\4E00\822C\4F7F\7528\8005\300D\767B\5165\662F\5426\6709\6548.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805494323902047785.4757)
,p_name=>'P306_SHOW_EXPIRE_FLAG'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805494503718047785.4757)
,p_name=>'P306_EXPIRE'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8B93\5BC6\78BC\5931\6548')
,p_display_as=>'NATIVE_CHECKBOX'
,p_lov=>'select null d, ''Y'' r from dual'
,p_display_when=>'P306_SHOW_EXPIRE_FLAG'
,p_display_when2=>'Y'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\52FE\9078\6B64\65B9\584A\5373\53EF\8B93\4F7F\7528\8005\7684\5BC6\78BC\5931\6548.  \9019\6703\540C\6642\5F71\97FF\4F7F\7528\8005\7684\958B\767C\4EBA\54E1/\7BA1\7406\54E1\767B\5165, \4EE5\53CA\4EE5\4E00\822C\4F7F\7528\8005\8EAB\5206\6240\9032\884C\7684\5B58\53D6.  \5982\679C\5931\6548, \4F7F\7528\8005\5728\4E0B\6B21\5B58\53D6\6B64\5E33\6236\6642, \5C31\5FC5\9808\8F38\5165\5176\820A\5BC6\78BC\548C\65B0\5BC6\78BC\624D\80FD\767B\5165.')
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(805495014527047785.4757)
,p_name=>'P306_FAILED_ACCESS_ATTEMPTS'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(805491259930047781.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(805495644034047790.4757)
,p_computation_sequence=>10
,p_computation_item=>'P306_CHANGE_PWD_ON_FIRST_USE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(:P306_CHANGE_PWD_ON_FIRST_USE,''N'') <> ''Y'' then',
'  return ''N'';',
'else',
'  return ''Y'';',
'end if;',
'',
''))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(805495874977047790.4757)
,p_computation_sequence=>20
,p_computation_item=>'P306_EXPIRE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(:P306_EXPIRE,''N'') <> ''Y'' then',
'  return ''N'';',
'else',
'  return ''Y'';',
'end if;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(805496018421047790.4757)
,p_computation_sequence=>30
,p_computation_item=>'P306_ACCOUNT_LOCKED'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(:P306_ACCOUNT_LOCKED,''N'') <> ''Y'' then',
'  return ''N'';',
'else',
'  return ''Y'';',
'end if;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(805496297798047790.4757)
,p_computation_sequence=>40
,p_computation_item=>'P306_UPDATE_PW'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'length(:F4750_P306_USER_PASSWORD)'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805496468814047791.4757)
,p_validation_name=>'F4750_P306_USER_NAME not null'
,p_validation_sequence=>10
,p_validation=>'F4750_P306_USER_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\60A8\5FC5\9808\63D0\4F9B\4F7F\7528\8005\540D\7A31.')
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805477651541047766.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805496619153047791.4757)
,p_validation_name=>'F4750_P306_USER_NAME'
,p_validation_sequence=>20
,p_validation=>'F4750_P306_USER_NAME'
,p_validation2=>'< >'
,p_validation_type=>'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2'
,p_error_message=>unistr('\7121\6548\7684\300C\4F7F\7528\8005\540D\7A31\300D.')
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805477651541047766.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805496875140047791.4757)
,p_validation_name=>'validate email'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_at  number;',
'  l_dot number;',
'begin',
'  l_at  := instr(nvl(:F4750_P306_EMAIL_ADDRESS,''x''),''@'');',
'  l_dot := instr(nvl(:F4750_P306_EMAIL_ADDRESS,''x''),''.'',l_at);',
'  return l_at > 1 and l_dot > 1 and (l_dot - l_at) > 1;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7121\6548\7684\96FB\5B50\90F5\4EF6\5730\5740.')
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805478117441047766.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805497077259047791.4757)
,p_validation_name=>'default schema in accessible schemas'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'instr(upper(:F4750_P306_ACCESS_TO_SCHEMAS),:F4750_P306_DEFAULT_SCHEMA) > 0 or',
'v(''F4750_P306_ACCESS_TO_SCHEMAS'') is null'))
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>unistr('\300C\9810\8A2D\7DB1\8981\300D\5FC5\9808\5728\300C\53EF\5B58\53D6\7DB1\8981\300D\4E4B\5167.')
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805482085475047770.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805497271217047791.4757)
,p_validation_name=>'can''t remove admin from yourself'
,p_validation_sequence=>60
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :F4750_P306_USER_ID = wwv_flow_user_api.get_user_id(:FLOW_USER) and :P306_ADMIN = ''N'' then',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\60A8\7121\6CD5\79FB\9664\672C\8EAB\7684\7BA1\7406\54E1\6B0A\9650.')
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805483273721047772.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805497425906047791.4757)
,p_validation_name=>'Developer must have Access'
,p_validation_sequence=>70
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'  IF :P306_DEVELOPER = ''Y'' THEN',
'    IF :P306_ALLOW_APP_BUILDING_YN = ''N''',
'    AND :P306_ALLOW_SQL_WORKSHOP_YN = ''N'' THEN',
'      RETURN FALSE;',
'    END IF;',
'  END IF;',
'',
'  RETURN TRUE;',
'END;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\300C\958B\767C\4EBA\54E1\300D\5FC5\9808\8981\80FD\5920\5B58\53D6\300C\61C9\7528\7A0B\5F0F\7522\751F\5668\300D\3001\300CSQL \5DE5\4F5C\5BA4\300D\6216\4E8C\8005.')
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805483794897047773.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805497655221047792.4757)
,p_validation_name=>'if change username, must reset password'
,p_validation_sequence=>105
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'   select user_name',
'     from wwv_flow_fnd_user',
'    where user_id = :F4750_P306_USER_ID',
'      and security_group_id = :flow_security_group_id )',
'loop',
'   if c1.user_name != :F4750_P306_USER_NAME and',
'      :F4750_P306_WEB_PASSWORD is null then',
'   return false;',
'   else return true;',
'   end if;',
'end loop;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\82E5\60A8\66F4\65B0\300C\4F7F\7528\8005\540D\7A31\300D, \5247\5FC5\9808\63D0\4F9B\65B0\7684\5BC6\78BC.')
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805491451692047782.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805497847939047792.4757)
,p_validation_name=>'match password'
,p_validation_sequence=>120
,p_validation=>':F4750_P306_WEB_PASSWORD = :F4750_P306_USER_PASSWORD'
,p_validation_type=>'PLSQL_EXPRESSION'
,p_error_message=>unistr('\672A\6B63\78BA\78BA\8A8D\5BC6\78BC, \8ACB\8F38\5165\76F8\540C\7684\5BC6\78BC\5169\6B21.')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':F4750_P306_WEB_PASSWORD is not null or',
':F4750_P306_USER_PASSWORD is not null'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805491931409047782.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(805498076422047792.4757)
,p_validation_name=>'strong password verification'
,p_validation_sequence=>130
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_security.strong_password_validation(',
'      p_username       => :F4750_P306_USER_NAME,',
'      p_password       => :F4750_P306_WEB_PASSWORD,',
'      p_old_password   => null,',
'      p_workspace_name => wwv_flow_security.find_company_name(:WORKSPACE_ID));'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\932F\8AA4')
,p_validation_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_authentication_dev.is_builder_password_required (',
'    p_developer_yn => :P306_DEVELOPER )'))
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(805491074986047781.4757)
,p_associated_item=>wwv_flow_api.id(805491451692047782.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
,p_validation_comment=>'do not run for non-developers in SSO authentication mode'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(805499566708047800.4757)
,p_name=>'Set Admin Defaults'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P306_ADMIN'
,p_condition_element=>'P306_ADMIN'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805499875666047800.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_DEVELOPER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805500006013047800.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>11
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_DEVELOPER'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805500275196047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_DEVELOPER'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805500468814047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805500640817047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>31
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805500884027047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805501045220047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805501242572047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>51
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805501505931047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>60
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805501794074047801.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>70
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805501912622047802.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>71
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805502129196047802.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>80
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805502462365047802.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>90
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_TEAM_DEVELOPMENT_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805502631458047802.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>91
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_TEAM_DEVELOPMENT_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805502850860047803.4757)
,p_event_id=>wwv_flow_api.id(805499566708047800.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>100
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_TEAM_DEVELOPMENT_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(805502950507047803.4757)
,p_name=>'Set Developer Defaults'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P306_DEVELOPER'
,p_condition_element=>'P306_DEVELOPER'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805503219897047803.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805503412421047803.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>11
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_APP_BUILDING_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805503650313047803.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805503824002047803.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>21
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_APP_BUILDING_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805504009155047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805504248994047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>31
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_WEBSHEET_DEV_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805504406743047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805504677467047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>41
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_WEBSHEET_DEV_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805504861921047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805505099885047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>51
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_SQL_WORKSHOP_YN'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805505279268047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>60
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805505450596047804.4757)
,p_event_id=>wwv_flow_api.id(805502950507047803.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>61
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_ALLOW_SQL_WORKSHOP_YN'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_02=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(805505534332047804.4757)
,p_name=>'Disable Disallow Application Building'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P306_DISALLOW_APP_BUILDING'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805505883539047805.4757)
,p_event_id=>wwv_flow_api.id(805505534332047804.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_DISALLOW_APP_BUILDING'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(805505912684047805.4757)
,p_name=>'Disable Disallow Websheet Dev'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P306_DISALLOW_WEBSHEET_DEV'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805506290911047805.4757)
,p_event_id=>wwv_flow_api.id(805505912684047805.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_DISALLOW_WEBSHEET_DEV'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(805506399068047805.4757)
,p_name=>'Disable Disallow SQL Workshop'
,p_event_sequence=>50
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P306_DISALLOW_SQL_WORKSHOP'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805506668499047805.4757)
,p_event_id=>wwv_flow_api.id(805506399068047805.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_DISALLOW_SQL_WORKSHOP'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(805506769461047807.4757)
,p_name=>'Disable Disallow Team Development'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P306_DISALLOW_TEAM_DEVELOPMENT'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(805507034341047807.4757)
,p_event_id=>wwv_flow_api.id(805506769461047807.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_DISABLE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P306_DISALLOW_TEAM_DEVELOPMENT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805498147025047792.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch user'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_fnd_user_api.fetch_fnd_user (',
'     p_user_id       => :F4750_P306_USER_ID,',
'     p_company       => :F4750_P306_COMPANY,',
'     p_user_name     => :F4750_P306_USER_NAME,',
'     p_first_name    => :F4750_P306_FIRST_NAME,',
'     p_last_name     => :F4750_P306_LAST_NAME,',
'     p_web_password  => :F4750_P306_WEB_PASSWORD,',
'     p_email_address => :F4750_P306_EMAIL_ADDRESS,',
'     p_start_date    => :F4750_P306_START_DATE,',
'     p_end_date      => :F4750_P306_END_DATE,',
'     p_employee_id   => :F4750_P306_EMPLOYEE_ID,',
'     p_allow_access_to_schemas => :F4750_P306_ACCESS_TO_SCHEMAS,',
'     p_person_type     => :F4750_P306_PERSON_TYPE,',
'     p_default_schema  => :F4750_P306_DEFAULT_SCHEMA,',
'     p_groups          => :F4750_P306_GROUPS,',
'     p_developer_role  => :F4750_P306_DEVELOPER_ROLE,',
'     p_description     => :P306_DESCRIPTION,',
'     p_account_expiry  => :P306_ACCOUNT_EXPIRY,',
'     p_account_locked  => :P306_ACCOUNT_LOCKED,',
'     p_failed_access_attempts => :P306_FAILED_ACCESS_ATTEMPTS,',
'     p_change_password_on_first_use => :P306_CHANGE_PWD_ON_FIRST_USE,',
'     p_first_password_use_occurred => :P306_FIRST_PWD_USE_OCCURRED',
'     );',
'',
'for c1 in (select default_date_format',
'           from wwv_flow_fnd_user',
'           where user_id = :F4750_P306_USER_ID',
'           and security_group_id =  :flow_security_group_id)',
'loop',
'    :P306_DEFAULT_DATE_FORMAT := c1.default_date_format;',
'    exit;',
'end loop;'))
,p_process_error_message=>unistr('\64F7\53D6\4F7F\7528\8005\8CC7\8A0A\6642\767C\751F\932F\8AA4.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805498591751047793.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_site_account_lifetime number := ',
'    nvl(wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS''),45);',
'  l_workspace_account_lifetime number;',
'  l_account_last_updated date;',
'  l_dev_admin_expired boolean := false;',
'  l_end_user_expired boolean := false;',
'  l_found boolean := false;',
'begin',
':F4750_P306_ORG_EMAIL_ADDRESS := :F4750_P306_EMAIL_ADDRESS;',
'if :F4750_P306_DEVELOPER_ROLE is null then',
'  :P306_DEVELOPER := ''N'';',
'  :P306_ADMIN := ''N'';',
'elsif instr(:F4750_P306_DEVELOPER_ROLE,''ADMIN'') > 0 then',
'  :P306_DEVELOPER := ''Y'';',
'  :P306_ADMIN := ''Y'';',
'else',
'  :P306_DEVELOPER := ''Y'';',
'  :P306_ADMIN := ''N'';',
'end if;',
'--',
'-- account expiration notices',
'--',
'l_account_last_updated := nvl(:P306_ACCOUNT_EXPIRY, trunc(sysdate));',
'for c1 in (select ACCOUNT_LIFETIME_DAYS from WWV_FLOW_COMPANIES',
'           where provisioning_company_id = :flow_security_group_id) loop',
'  l_workspace_account_lifetime := nvl(c1.account_lifetime_days,l_site_account_lifetime);',
'end loop;',
'',
':P306_SHOW_EXPIRE_FLAG := ''N'';',
'if :P306_DEVELOPER = ''Y'' then',
'  if l_account_last_updated + l_site_account_lifetime < sysdate then',
'    l_dev_admin_expired := true;',
'    :P306_EXPIRATION_STATUS1 := wwv_flow_lang.system_message(''EXPIRED'');',
'  else',
'    :P306_EXPIRATION_STATUS1 := wwv_flow_lang.system_message(''VALID'');',
'    :P306_SHOW_EXPIRE_FLAG := ''Y'';',
'  end if;',
'else',
'  :P306_EXPIRATION_STATUS1 := ''NA'';',
'end if;',
'',
'for c1 in (select ACCOUNT_LIFETIME_DAYS from WWV_FLOW_COMPANIES',
'           where (',
'             EXPIRE_FND_USER_ACCOUNTS = ''Y'' or ',
'             wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS'') = ''Y'')',
'           and provisioning_company_id = :flow_security_group_id) loop',
'  l_found := true;',
'  if l_account_last_updated + l_workspace_account_lifetime < sysdate then',
'    l_end_user_expired := true;',
'    :P306_EXPIRATION_STATUS2 := wwv_flow_lang.system_message(''EXPIRED'');',
'  else',
'    :P306_EXPIRATION_STATUS2 := wwv_flow_lang.system_message(''VALID'');',
'    :P306_SHOW_EXPIRE_FLAG := ''Y'';',
'  end if;',
'end loop;',
'if not l_found then',
'  :P306_EXPIRATION_STATUS2 := ''NA'';',
'end if;',
'end;'))
);
end;
/
begin
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805498775565047799.4757)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'edit user'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'  l_p1                        varchar2(256) := v(''F4750_P306_WEB_PASSWORD'');',
'  l_p2                        varchar2(256) := v(''F4750_P306_USER_PASSWORD'');',
'  l_msg                       varchar2(4000);',
'  l_body_html                 varchar2(32767) := null;',
'  l_product_name              varchar2(500);',
'  l_developer_roles           varchar2(255) := null;',
'  l_ALLOW_APP_BUILDING_YN     varchar2(1);',
'  l_ALLOW_SQL_WORKSHOP_YN     varchar2(1);',
'  l_ALLOW_WEBSHEET_DEV_YN     varchar2(1);',
'  l_ALLOW_TEAM_DEVELOPMENT_YN varchar2(1);',
'begin',
'    if :F4750_P306_DEFAULT_SCHEMA is not null then',
'        wwv_flow_sw_api.check_priv(p_schema=>:F4750_P306_DEFAULT_SCHEMA);',
'    end if;',
'',
'    l_ALLOW_APP_BUILDING_YN     := case when :P306_ADMIN = ''Y'' or :P306_DEVELOPER = ''Y'' then ''Y'' else ''N'' end;',
'    l_ALLOW_SQL_WORKSHOP_YN     := case when :P306_ADMIN = ''Y'' or :P306_DEVELOPER = ''Y'' then ''Y'' else ''N'' end;',
'    l_ALLOW_WEBSHEET_DEV_YN     := case when :P306_ADMIN = ''Y'' or :P306_DEVELOPER = ''Y'' then ''Y'' else ''N'' end;',
'    l_ALLOW_TEAM_DEVELOPMENT_YN := case when :P306_ADMIN = ''Y'' or :P306_DEVELOPER = ''Y'' then ''Y'' else ''N'' end;',
'    ',
'    wwv_flow.update_cache_with_write(''F4750_P306_WEB_PASSWORD'',null);',
'    wwv_flow.update_cache_with_write(''F4750_P306_USER_PASSWORD'',null);',
'    ',
'    wwv_flow_fnd_developer_api.edit_fnd_user (',
'     p_user_id                      => :F4750_P306_USER_ID,           ',
'     p_user_name                    => :F4750_P306_USER_NAME,         ',
'     p_first_name                   => :F4750_P306_FIRST_NAME,          ',
'     p_last_name                    => :F4750_P306_LAST_NAME,',
'     p_web_password                 => l_p1,    ',
'     p_new_password                 => l_p2,                     ',
'     p_email_address                => :F4750_P306_EMAIL_ADDRESS,       ',
'     p_allow_access_to_schemas      => null,   ',
'     p_default_schema               => :F4750_P306_DEFAULT_SCHEMA, ',
'     p_default_date_format          => :P306_DEFAULT_DATE_FORMAT,',
'     p_group_ids                    => :null,',
'     P_DESCRIPTION                  => :P306_DESCRIPTION,',
'     --',
'     P_ACCOUNT_EXPIRY               => :P306_ACCOUNT_EXPIRY,',
'     P_ACCOUNT_LOCKED               => :P306_ACCOUNT_LOCKED,',
'     p_change_password_on_first_use => :P306_CHANGE_PWD_ON_FIRST_USE,',
'     p_first_password_use_occurred  => case when l_p1 is not null then ''N'' else :P306_FIRST_PWD_USE_OCCURRED end,',
'     --',
'     p_ALLOW_APP_BUILDING_YN        => l_ALLOW_APP_BUILDING_YN,',
'     p_ALLOW_SQL_WORKSHOP_YN        => l_ALLOW_SQL_WORKSHOP_YN,',
'     p_ALLOW_WEBSHEET_DEV_YN        => l_ALLOW_WEBSHEET_DEV_YN,',
'     p_ALLOW_TEAM_DEVELOPMENT_YN    => l_ALLOW_TEAM_DEVELOPMENT_YN',
'    );',
'',
'  --',
'  -- Mail the change of Email address',
'  --',
'  If :F4750_P306_ORG_EMAIL_ADDRESS <> :F4750_P306_EMAIL_ADDRESS then',
'    l_msg       := l_msg || wwv_flow_lang.system_message(''NEW_EMAIL_ADDRESS'') || chr(10) ',
'                      || :F4750_P306_EMAIL_ADDRESS || chr(10) || chr(10) || chr(10);',
'    l_msg       := l_msg || wwv_flow_utilities.host_url(''SCRIPT'') || chr(10);',
'   ',
'    l_body_html := wwv_flow_mail.convert_txt_to_html (',
'                       p_txt_message       => l_msg,',
'                       p_security_group_id => :flow_security_group_id );',
'    l_product_name := nvl(v(''PRODUCT_NAME''),''Oracle Application Express'');',
'',
'    wwv_flow_mail.send ( p_to        => :F4750_P306_ORG_EMAIL_ADDRESS,',
'                         p_from      => nvl(wwv_flow_platform.get_preference(''SMTP_FROM''),:F4750_P306_ORG_EMAIL_ADDRESS),',
'                         p_body      => l_msg,',
'                         p_body_html => l_body_html,',
'                         p_subj      => wwv_flow_lang.system_message(''CHANGE_PW_REQUEST'',l_product_name) );',
'  end if;',
'',
'  --',
'  -- Developer and Admin roles',
'  --',
'  if :P306_ADMIN = ''N'' and :P306_DEVELOPER = ''N'' then',
'    delete from wwv_flow_developers where user_id = :F4750_P306_USER_ID;',
'  else',
'    -- {Trigger on WWV_FLOW_DEVELOPERS sets all developer roles for ADMINS ',
'    --  irrespective of what set here providing includes ''ADMIN''} ',
'    if :P306_ADMIN = ''Y'' then ',
'      l_developer_roles := l_developer_roles||''ADMIN'';',
'    end if;',
'    if nvl(v(''P306_ALLOW_APP_BUILDING_YN''),''Y'') = ''Y'' then ',
'      if l_developer_roles is not null then',
'        l_developer_roles := l_developer_roles||'':'';',
'      end if;',
'      l_developer_roles := l_developer_roles||''CREATE:EDIT:HELP:MONITOR'';',
'    end if;',
'    if nvl(v(''P306_ALLOW_SQL_WORKSHOP_YN''),''Y'') = ''Y'' then',
'      if l_developer_roles is not null then',
'        l_developer_roles := l_developer_roles||'':'';',
'      end if;',
'      l_developer_roles := l_developer_roles||''SQL:MONITOR:DATA_LOADER'';',
'    end if;    ',
'    wwv_flow_fnd_developer_api.edit_developer_role(',
'             p_id              => 1,',
'             p_user_id         => :F4750_P306_USER_ID,',
'             p_user_name       => :F4750_P306_USER_NAME,',
'             p_developer_roles => l_developer_roles);',
'  end if;',
'end;'))
,p_process_error_message=>unistr('\66F4\65B0\4F7F\7528\8005\6642\767C\751F\932F\8AA4.')
,p_process_when_button_id=>wwv_flow_api.id(805491074986047781.4757)
,p_process_success_message=>unistr('\5DF2\66F4\65B0\4F7F\7528\8005 "&F4750_P306_USER_NAME.".')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805498998240047800.4757)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'remove user'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_fnd_user_api.remove_fnd_user(',
'             p_user_id => :F4750_P306_USER_ID);'))
,p_process_error_message=>unistr('\522A\9664 &F4750_P306_USER_NAME. \6642\767C\751F\932F\8AA4.')
,p_process_when_button_id=>wwv_flow_api.id(805490871563047781.4757)
,p_process_success_message=>unistr('\5DF2\522A\9664\4F7F\7528\8005 &F4750_P306_USER_NAME..')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805499103434047800.4757)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear'
,p_attribute_01=>'CLEAR_CACHE_FOR_ITEMS'
,p_attribute_03=>'F4750_P306_WEB_PASSWORD,F4750_P306_USER_PASSWORD'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805499398118047800.4757)
,p_process_sequence=>60
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'expire account'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_site_account_lifetime      number := nvl(wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS''),45);',
'  l_workspace_account_lifetime number;',
'  l_account_last_updated       date;',
'  l_account_next_updated       date;',
'begin',
'  l_account_last_updated := nvl(:P306_ACCOUNT_EXPIRY, trunc(sysdate));',
'  for c1 in (select ACCOUNT_LIFETIME_DAYS from WWV_FLOW_COMPANIES',
'              where provisioning_company_id = :flow_security_group_id)',
'  loop',
'      l_workspace_account_lifetime := nvl(c1.account_lifetime_days,l_site_account_lifetime);',
'  end loop;',
'  l_account_next_updated := trunc(sysdate) - greatest(l_workspace_account_lifetime,l_site_account_lifetime);',
'',
'  update wwv_flow_fnd_user ',
'     set account_expiry = l_account_next_updated ',
'   where :F4750_P306_USER_ID = user_id',
'     and security_group_id = :flow_security_group_id;',
'end;'))
,p_process_when_button_id=>wwv_flow_api.id(805491074986047781.4757)
,p_process_when=>':P306_EXPIRE = ''Y'' and nvl(:P306_UPDATE_PW,0) = 0'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(805498360362047793.4757)
,p_process_sequence=>10
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'always developer if admin'
,p_process_sql_clob=>':P306_DEVELOPER := ''Y'';'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P306_ADMIN'
,p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_process_when2=>'Y'
);
end;
/
prompt --application/pages/page_00828
begin
wwv_flow_api.create_page(
 p_id=>828.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_page_mode=>'MODAL'
,p_step_title=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_icons.css" type="text/css" media="screen" charset="utf-8">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_frame.css" type="text/css" media="screen" charset="utf-8">',
'',
'<link rel="stylesheet" href="#IMAGE_PREFIX#eba/css/cloud_app_details.css" type="text/css" media="screen" title="no title" charset="utf-8">',
'',
'<style>',
'span.ebaAppAvailable {',
'    display: inline-block;',
'    font: normal 14px/16px Arial, sans-serif;',
'    margin: 4px 5px 0 0;',
'    color: #f7941d;',
'    }',
'</style>'))
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// extend jQuery selectors with a non case sensitive version',
'apex.jQuery.extend($.expr[":"], {',
'  "containsNC": function(pElem, pIdx, pMatch, pArray) {',
'                  return (pElem.textContent || pElem.innerText || "").toLowerCase().indexOf((pMatch[3] || "").toLowerCase()) >= 0;',
'                }',
'});',
'',
'',
'function initInstantFilter(){',
'  var $apps    = apex.jQuery(''#applications''),',
'      $allApps = $apps.clone(),',
'      lTimer;',
'',
'  function filterApplications(){',
'    var $filteredApps = $allApps.find("li:has(h3:containsNC(''"+$v(''p50_SEARCH'')+"''))");',
'    $apps.quicksand($filteredApps, {',
'      adjustHeight: false,',
'      useScaling: false,',
'      duration: 400,',
'      easing: ''easeInOutQuad''',
'    });',
'  };',
'',
'  // set a fixed size for the containing DIV to avoid flickering',
'  $apps.parent().css(''height'', $apps.parent().height() + ''px'').css(''min-width'', $apps.parent().width() + ''px'');',
'',
'  // everytime something is entered in our search field we want to execute the filter,',
'  // but only after a short delay to avoid flickering animations',
'  apex.jQuery(''#p50_SEARCH'')',
'    .keyup(function(pEvent){',
'      if (lTimer != undefined) {',
'        clearTimeout(lTimer);',
'      };',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        filterApplications();',
'      } else {',
'        lTimer = setTimeout(filterApplications, 300);',
'      }',
'    })',
'    .keypress(function(pEvent){',
'      if (pEvent.keyCode === 13 || pEvent.keyCode === 10) {',
'        pEvent.preventDefault();',
'        pEvent.stopImmediatePropagation();',
'      }',
'    });',
'',
'};',
''))
,p_javascript_code_onload=>'initInstantFilter();'
,p_step_template=>wwv_flow_api.id(740687851443061408.4757)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_attributes=>'resizable:true,minWidth:500,minHeight:400'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(755599272547864571.4757)
,p_plug_name=>'navigation'
,p_component_template_options=>'#DEFAULT#:a-WizardSteps--slim'
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(755598782624864560.4757)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(755602131069880061.4757)
,p_translate_title=>'N'
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_global.g_cloud'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(806405890822441606.4757)
,p_plug_name=>'App Details Container'
,p_region_name=>'ebaAppFrameTable'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(806406219339441608.4757)
,p_plug_name=>unistr('\5B89\88DD\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>10
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_region_image_attr=>'style="margin:20px 40px 10px 10px" '
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(806407092769441610.4757)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>40
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(806408479589441614.4757)
,p_plug_name=>unistr('\8A8D\8B49\8A2D\5B9A\503C')
,p_region_name=>'PLUGIN'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="color:#FFFFFF;display:none;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_footer=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script type="text/javascript">',
unistr('// \5728\5448\73FE\52D5\614B\5C6C\6027\5F8C\7ACB\5373\52A0\4EE5\96B1\85CF, '),
unistr('// jQuery.ready \53EF\80FD\6703\57F7\884C\5F88\4E45. '),
'apex.builder.dynamicAttributes.hide(''P4651_'');',
'</script>'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(806411659565441620.4757)
,p_plug_name=>'Add Javascript code for Plugins'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    -- create the onChange event for the P828_AUTH and',
'    -- also the initialization code for the dynamic attributes',
'    wwv_flow_plugin_dev.add_onload_code (',
'        p_plugin_type         => wwv_flow_plugin.c_plugin_type_authentication,',
'        p_type_page_item_name => ''P828_AUTH'',',
'        p_page_item_prefix    => ''P828_'' );',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(806407286428441610.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(806407092769441610.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(806407687719441613.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(806407092769441610.4757)
,p_button_name=>'Next'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(758581488338548971.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'icon-right-chevron'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(806412441941441621.4757)
,p_branch_name=>'next step'
,p_branch_action=>'f?p=&APP_ID.:83:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492796407779370733.4757)
,p_name=>'P828_WORKSPACE_NAME'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5DE5\4F5C\5340\540D\7A31:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select DISPLAY_NAME',
'from WWV_FLOW_COMPANIES',
'where PROVISIONING_COMPANY_ID = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492796679721373814.4757)
,p_name=>'P828_SCHEMA'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_prompt=>unistr('\7DB1\8981:')
,p_source=>'wwv_flow_user_api.get_default_schema'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492796853019377000.4757)
,p_name=>'P828_PROVIDER_COMPANY'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\63D0\4F9B\8005:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select provider_company',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and provider_company is not null',
'  '))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492797065696379206.4757)
,p_name=>'P828_PROVIDER_EMAIL'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\63D0\4F9B\8005\96FB\5B50\90F5\4EF6:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select provider_email',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and provider_email is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492797281238381967.4757)
,p_name=>'P828_MIN_APEX_VERSION'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\6700\5C0F\7248\672C:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select min_apex_version',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and min_apex_version is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492797463567384055.4757)
,p_name=>'P828_RELEASED'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\767C\884C\6642\9593:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select released',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and released is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492797655776386305.4757)
,p_name=>'P828_LANGUAGES'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\8A9E\8A00:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select languages',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_pkg_applications',
'where ( :P81_APP_TYPE = ''DATABASE'' and apex_application_id = :P83_APPLICATION_ID)',
'or (:P81_APP_TYPE = ''WEBSHEET'' and apex_websheet_id = :P83_APPLICATION_ID)',
'and languages is not null'))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806406056561441608.4757)
,p_name=>'P828_APPLICATION_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(806405890822441606.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806406447905441608.4757)
,p_name=>'P828_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806406668729441608.4757)
,p_name=>'P828_APP_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31:')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_name  varchar2(255);',
'begin',
'  if :P81_APP_TYPE = ''DATABASE'' then ',
'    select app_name into l_name from wwv_flow_pkg_applications',
'     where apex_application_id = :P828_APPLICATION_ID;',
'  else',
'      select app_name into l_name from wwv_flow_pkg_applications',
'       where apex_websheet_id = :P828_APPLICATION_ID;',
'  end if;',
'  return l_name;',
'end;'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_cattributes_element=>'class="fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806406859586441609.4757)
,p_name=>'P828_AUTH'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(806406219339441608.4757)
,p_prompt=>unistr('\8A8D\8B49')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'case',
'  when wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'' then',
'    ''NATIVE_CLOUD_IDM''',
'  else',
'    ''NATIVE_APEX_ACCOUNTS''',
'end'))
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PACKAGED_APP_AUTH_OPTION'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'       name_with_prefix      as r',
'  from wwv_flow_native_plugins',
' where plugin_type = ''AUTHENTICATION TYPE''',
'   and (          name_with_prefix = ''NATIVE_APEX_ACCOUNTS''',
'         or (     name_with_prefix = ''NATIVE_HTTP_HEADER_VARIABLE''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_HHEAD'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_LDAP''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_LDAP'') = ''Y'' )',
'         or (     name_with_prefix = ''NATIVE_IAS_SSO''',
'              and :P81_APP_TYPE    = ''DATABASE'' /* not yet implemented for websheets */',
'              and wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_SSO'') = ''Y'' ))',
'union all',
'select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_CLOUD_IDM''),',
'       ''NATIVE_CLOUD_IDM''',
'  from sys.dual',
' where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''))
,p_cHeight=>1
,p_read_only_when=>'wwv_flow_global.g_cloud'
,p_read_only_when_type=>'PLSQL_EXPRESSION'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806408623610441617.4757)
,p_name=>'P828_ATTRIBUTE_01'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806408885234441617.4757)
,p_name=>'P828_ATTRIBUTE_02'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741012333966774170.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806409081064441618.4757)
,p_name=>'P828_ATTRIBUTE_03'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806409298246441618.4757)
,p_name=>'P828_ATTRIBUTE_04'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806409474555441618.4757)
,p_name=>'P828_ATTRIBUTE_05'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806409702516441618.4757)
,p_name=>'P828_ATTRIBUTE_06'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806409881446441618.4757)
,p_name=>'P828_ATTRIBUTE_07'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806410067095441618.4757)
,p_name=>'P828_ATTRIBUTE_08'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806410259550441618.4757)
,p_name=>'P828_ATTRIBUTE_09'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806410427249441618.4757)
,p_name=>'P828_ATTRIBUTE_10'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806410645254441619.4757)
,p_name=>'P828_ATTRIBUTE_11'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806410857047441619.4757)
,p_name=>'P828_ATTRIBUTE_12'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806411066113441619.4757)
,p_name=>'P828_ATTRIBUTE_13'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806411238449441619.4757)
,p_name=>'P828_ATTRIBUTE_14'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(806411434972441619.4757)
,p_name=>'P828_ATTRIBUTE_15'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(806408479589441614.4757)
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.PLUGIN_DYNAMIC_ATTRIBUTE'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(755608440143007972.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(806407286428441610.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(755608793776007973.4757)
,p_event_id=>wwv_flow_api.id(755608440143007972.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
end;
/
prompt --application/pages/page_11001
begin
wwv_flow_api.create_page(
 p_id=>11001.4757
,p_user_interface_id=>wwv_flow_api.id(539940534604132427.4757)
,p_name=>unistr('\610F\898B\56DE\994B')
,p_page_mode=>'NON_MODAL'
,p_step_title=>unistr('\610F\898B\56DE\994B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_dialog_height=>'600'
,p_dialog_width=>'950'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'td_fb.htm'
,p_page_comment=>'This page was generated by the feedback wizard'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(829721255038941612.4757)
,p_plug_name=>unistr('\610F\898B\56DE\994B')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740771588500180474.4757)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p><strong>\611F\8B1D\60A8\63D0\4F9B\610F\898B\56DE\994B\7D66\6211\5011, \4EE5\5229\6539\9032 &PRODUCT_NAME.!</strong></p>'),
unistr('<p>\9032\4E00\6B65\77AD\89E3 APEX 19.2 \6240\5305\542B\7684<a target="_blank" href="https://apex.oracle.com/pls/apex/f?p=192192:FEATURES:::NO:::">\529F\80FD</a>.</p>'),
unistr('<p>\8F38\5165\610F\898B\56DE\994B\4E4B\524D, \8ACB\5148\8907\67E5<a target="_blank" href="https://apex.oracle.com/pls/apex/f?p=192192:KNOWN-ISSUES:::NO:::">\5DF2\77E5\554F\984C</a>, \56E0\70BA\6211\5011\5B9A\671F\4EE5\6B64\300C\6436\9BAE\7248\300D\7684\6700\5E38\898B\554F\984C\548C\9650\5236\4F86\66F4\65B0\5DF2\77E5\554F\984C.<br>'),
unistr('\524D\5F80<a target="_blank" href="&P11001_FEEDBACK_URL.">\6436\9BAE\7248\516C\958B\610F\898B\56DE\994B</a>\4F86\8907\67E5\56DE\8986\548C\5F8C\7E8C\8FFD\8E64.</p>'),
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1831121893546426040.4757)
,p_plug_name=>unistr('\6B64\9801\9762\4E0A\7684\300C\73FE\6709\610F\898B\56DE\994B\300D')
,p_parent_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_api.id(404667570222803088.4757)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(1831121926658426041.4757)
,p_name=>unistr('\73FE\6709\610F\898B\56DE\994B')
,p_parent_plug_id=>wwv_flow_api.id(1831121893546426040.4757)
,p_template=>wwv_flow_api.id(404667570222803088.4757)
,p_display_sequence=>30
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--hideHeader'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_point=>'BODY'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
',      feedback_id',
',      (select the_name from WWV_FLOW_FEEDBACK_TYPES ',
'        where id = f.FEEDBACK_TYPE',
'       ) feedback_type',
',      decode(f.feedback_comment, null, null',
'                                ,decode(greatest(100,length(f.feedback_comment)), 100, f.feedback_comment, substr(f.feedback_comment,1,100)||''...'') ',
'             ) feedback',
',      (select the_name ',
'        from wwv_flow_feedback_status',
'        where id = nvl(f.feedback_status,0)',
'       ) feedback_status',
',      decode(f.public_response,null,null',
'                               ,decode(greatest(100,length(f.public_response)),100, f.public_response,substr(f.public_response,1,100)||''...'')',
'             ) public_response',
',     trunc(CREATED_ON) created_date',
'from wwv_flow_feedback f',
'where f.application_id = :P11001_APPLICATION_ID',
'and   f.page_id = :P11001_PAGE_ID',
'and   security_group_id = 10',
''))
,p_ajax_enabled=>'Y'
,p_query_row_template=>wwv_flow_api.id(741385154282007399.4757)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>unistr('\6C92\6709\4EFB\4F55\91DD\5C0D\6B64\9801\9762\8F38\5165\7684\610F\898B\56DE\994B.')
,p_query_num_rows_type=>'ROW_RANGES_IN_SELECT_LIST'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_plug_query_strip_html=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1831122013825426042.4757)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(784426461887840006.4757)
,p_query_column_id=>2
,p_column_alias=>'FEEDBACK_ID'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\610F\898B\56DE\994B\7DE8\865F')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1831122187593426043.4757)
,p_query_column_id=>3
,p_column_alias=>'FEEDBACK_TYPE'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\610F\898B\56DE\994B\985E\578B')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1831122292218426044.4757)
,p_query_column_id=>4
,p_column_alias=>'FEEDBACK'
,p_column_display_sequence=>4
,p_column_heading=>unistr('\610F\898B\56DE\994B')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1831122323939426045.4757)
,p_query_column_id=>5
,p_column_alias=>'FEEDBACK_STATUS'
,p_column_display_sequence=>5
,p_column_heading=>unistr('\610F\898B\56DE\994B\72C0\614B')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1831122493214426046.4757)
,p_query_column_id=>6
,p_column_alias=>'PUBLIC_RESPONSE'
,p_column_display_sequence=>6
,p_column_heading=>unistr('\516C\958B\56DE\8986')
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(1831122584819426047.4757)
,p_query_column_id=>7
,p_column_alias=>'CREATED_DATE'
,p_column_display_sequence=>7
,p_column_heading=>unistr('\5EFA\7ACB\6642\9593')
,p_use_as_row_header=>'N'
,p_default_sort_column_sequence=>1
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(829723948212941618.4757)
,p_plug_name=>'Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(740735067061086300.4757)
,p_plug_display_sequence=>110
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(829724329405941619.4757)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(829723948212941618.4757)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\9001\51FA\610F\898B\56DE\994B')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(829724171601941619.4757)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(829723948212941618.4757)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(404710483554908976.4757)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_execute_validations=>'N'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(784376114194752225.4757)
,p_name=>'P11001_ENHANCEMENTS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_prompt=>unistr('\589E\5F37\529F\80FD\6307\793A')
,p_source=>'Any enhancement requests <u>not</u> related to new features of Application Express 19.2 should be filed in the Application Express Feature Requests application: <a target=_blank" href="http://apex.oracle.com/vote">http://apex.oracle.com/vote</a>.'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(784426013151840002.4757)
,p_name=>'P11001_BUG_INSTRUCTIONS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_prompt=>unistr('\932F\8AA4\6307\793A')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'When entering a bug please include detailed step-by-step instructions to ensure the development team can reproduce the issue you are reporting.<br>',
'Also consider providing a screenshot, either through a screenshot sharing service on the web, or send via email to Oracle Application Express Support, citing the feedback number in the email title, which you will know after submitting your feedback.'))
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(784426501672840007.4757)
,p_name=>'P11001_FEEDBACK_URL'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(829721485791941614.4757)
,p_name=>'P11001_APPLICATION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\60A8\76EE\524D\6B63\91DD\5C0D\5176\63D0\4F9B\610F\898B\56DE\994B\7684\300C\61C9\7528\7A0B\5F0F\300D.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(829721931618941617.4757)
,p_name=>'P11001_PAGE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_prompt=>unistr('\9801\9762:')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_css_classes=>'fielddatabold'
,p_begin_on_new_line=>'N'
,p_begin_on_new_field=>'N'
,p_field_template=>wwv_flow_api.id(741376158824001765.4757)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\60A8\76EE\524D\6B63\91DD\5C0D\5176\63D0\4F9B\610F\898B\56DE\994B\7684\9801\9762.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(829722489187941618.4757)
,p_name=>'P11001_FEEDBACK'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\7522\751F\5668\548C APEX<br>\61C9\7528\7A0B\5F0F\958B\767C\610F\898B\56DE\994B')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>70
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(829722929232941618.4757)
,p_name=>'P11001_FEEDBACK_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_prompt=>unistr('\610F\898B\56DE\994B\985E\578B')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'select the_name, id from WWV_FLOW_FEEDBACK_TYPES order by id'
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8ACB\6307\5B9A\610F\898B\56DE\994B\7684\985E\578B.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(829723440981941618.4757)
,p_name=>'P11001_COMPONENT'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(829721255038941612.4757)
,p_item_default=>'Other'
,p_prompt=>unistr('\5143\4EF6:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'P11001_COMPONENT'
,p_lov=>'.'||wwv_flow_api.id(49858589128480256.4757)||'.'
,p_field_template=>wwv_flow_api.id(741376307162001773.4757)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\8ACB\6307\5B9A\4E3B\8981\91DD\5C0D\54EA\500B\5143\4EF6\6216\529F\80FD\63D0\4F9B\610F\898B.')
,p_attribute_01=>'3'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(829724676691941620.4757)
,p_validation_name=>'P11001_COMPONENT Not Null'
,p_validation_sequence=>10
,p_validation=>'P11001_COMPONENT'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\8F38\5165 #LABEL# \503C.')
,p_associated_item=>wwv_flow_api.id(829723440981941618.4757)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(784426180894840003.4757)
,p_name=>'Show Bug Instructions'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P11001_FEEDBACK_TYPE'
,p_condition_element=>'P11001_FEEDBACK_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'3'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784426293836840004.4757)
,p_event_id=>wwv_flow_api.id(784426180894840003.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P11001_BUG_INSTRUCTIONS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784426312937840005.4757)
,p_event_id=>wwv_flow_api.id(784426180894840003.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P11001_BUG_INSTRUCTIONS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(784376274049752226.4757)
,p_name=>'Show Enhancements'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P11001_FEEDBACK_TYPE'
,p_condition_element=>'P11001_FEEDBACK_TYPE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'2'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784376345892752227.4757)
,p_event_id=>wwv_flow_api.id(784376274049752226.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P11001_ENHANCEMENTS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(784376447650752228.4757)
,p_event_id=>wwv_flow_api.id(784376274049752226.4757)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P11001_ENHANCEMENTS'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(641954835025558602.4757)
,p_name=>'Cancel Dialog'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(829724171601941619.4757)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(641954956270558603.4757)
,p_event_id=>wwv_flow_api.id(641954835025558602.4757)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(784426606272840008.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Prepare Feedback URL'
,p_process_sql_clob=>':P11001_FEEDBACK_URL := :APP_DOMAIN||''f?p=4840:2:''||:APP_SESSION||''::NO:CIR,RIR:IR_APP_PAGE:''||:P11001_APPLICATION_ID||''.''||:P11001_PAGE_ID;'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(829724961027941621.4757)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Submit Feedback'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.submit_feedback (',
'    p_comment         => :P11001_FEEDBACK,',
'    p_type            => :P11001_FEEDBACK_TYPE,',
'    p_application_id  => :P11001_APPLICATION_ID,',
'    p_page_id         => :P11001_PAGE_ID,',
'    p_label_01       => ''Component'',',
'    p_attribute_01   => :P11001_COMPONENT);'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(829724329405941619.4757)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(829725190931941621.4757)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/end_environment
begin
wwv_flow_api.import_end(p_auto_install_sup_obj => nvl(wwv_flow_application_install.get_auto_install_sup_obj, false));
commit;
end;
/
set verify on feedback on define on
prompt  ...done
