prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.16'
,p_default_workspace_id=>10
,p_default_application_id=>4907
,p_default_id_offset=>0
,p_default_owner=>'APEX_190200'
);
end;
/
 
prompt APPLICATION 4907 - Oracle APEX Websheets
--
-- Application Export:
--   Application:     4907
--   Name:            Oracle APEX Websheets
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    112
--       Items:                  529
--       Computations:            62
--       Validations:            104
--       Processes:              132
--       Regions:                506
--       Buttons:                234
--       Dynamic Actions:         47
--     Shared Components:
--       Logic:
--         Items:                 29
--         Processes:             14
--         Computations:           5
--         Build Options:          1
--       Navigation:
--         Lists:                 23
--         Breadcrumbs:            1
--           Entries:             81
--         NavBar Entries:         5
--       Security:
--         Authentication:         1
--         Authorization:         11
--       User Interface:
--         Templates:
--           Page:                11
--           Region:              22
--           Label:                5
--           List:                14
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:              20
--           Report:               4
--         LOVs:                 118
--         Shortcuts:              8
--         Plug-ins:               6
--       Globalization:
--         Messages:              30
--       Reports:
--       E-Mail:
--     Supporting Objects:  Excluded
--   Version:         19.2.0.00.16
--   Instance ID:     199069890325274
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_190200')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Websheets')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'A286635012992940675')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20191024135403'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'zh-tw'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'DS'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(709672827800503408.4907)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'T'
,p_logo_text=>'Application Express'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 19.2.0.00.16'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'S'
,p_deep_linking=>'Y'
,p_vpd=>'wwv_flow_ws_auth.init_schema;'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_substitution_string_01=>'MSG_LANGUAGE'
,p_substitution_value_01=>unistr('\8A9E\8A00')
,p_substitution_string_02=>'MSG_USER'
,p_substitution_value_02=>unistr('\4F7F\7528\8005')
,p_substitution_string_03=>'DELETE_MSG'
,p_substitution_value_03=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
,p_substitution_string_04=>'PRODUCT_NAME'
,p_substitution_value_04=>'Application Express'
,p_substitution_string_05=>'VIEW'
,p_substitution_value_05=>unistr('\6AA2\8996')
,p_substitution_string_06=>'MSG_JSCRIPT'
,p_substitution_value_06=>unistr('\60A8\5FC5\9808\555F\7528 JavaScript, \624D\80FD\57F7\884C\672C\7522\54C1.')
,p_substitution_string_07=>'CLOSE_MESSAGE'
,p_substitution_value_07=>unistr('\95DC\9589\8A0A\606F')
,p_substitution_string_08=>'GO_TO_TOP'
,p_substitution_value_08=>unistr('\524D\5F80\6700\4E0A\65B9')
,p_substitution_string_09=>'COLLAPSE'
,p_substitution_value_09=>unistr('\96B1\85CF')
,p_substitution_string_10=>'EDIT'
,p_substitution_value_10=>unistr('\7DE8\8F2F')
,p_substitution_string_11=>'EXPANDED'
,p_substitution_value_11=>unistr('\5C55\958B')
,p_last_updated_by=>'APEX_190200'
,p_last_upd_yyyymmddhh24miss=>'20191024141444'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/edit_sections
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(15661014418081294.4907)
,p_name=>'Edit Sections'
,p_list_type=>'SQL_QUERY'
,p_list_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 as level_value',
'	, c001 label_value',
'	, ''f?p=''||:APP_ID||'':''||:APP_PAGE_ID||'':''||:APP_SESSION target',
'	, null is_current_list_entry',
'	, null image',
'	, null image_attribute',
'	, null image_alt_attribute',
'	, lower(c002)||''Icon'' attribute1',
'	, wwv_flow_item.text_from_lov(c002,''SECTION TYPES'') attribute2',
'	, lower(decode(c005,null,c004,c005)) attribute3',
'	, htmldb_util.get_since(decode(d001,null,d002,d001)) attribute4',
'	, case when c002 = ''TEXT'' and :APP_PAGE_ID = 930 and n003 = :P930_SECTION_ID then ''active''',
'	       when c002 = ''NAV_PAGE'' and :APP_PAGE_ID = 931 and n003 = :P931_SECTION_ID then ''active''',
'	       when c002 = ''NAV_SECTION'' and :APP_PAGE_ID = 932 and n003 = :P932_SECTION_ID then ''active''',
'	       when c002 = ''CHART'' and :APP_PAGE_ID = 760 and n003 = :P760_SECTION_ID then ''active''',
'	       when c002 = ''DATA'' and :APP_PAGE_ID = 934 and n003 = :P934_SECTION_ID then ''active''',
'	       when c002 = ''PLSQL'' and :APP_PAGE_ID = 23 and n003 = :P23_SECTION_ID then ''active''',
'	       when :APP_PAGE_ID = 991 and n003 = :SECTION_ID then ''active''',
'               when :APP_PAGE_ID = 990 and n003 = :SECTION_ID then ''active''	  ',
'	  end attribute5        ',
'    , c006 attribute6 -- next page id',
'    , c007 attribute7 -- next section page item name to hold section id',
'    , n003 attribute8 -- next section id',
'    , n002 display_sequence',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_PAGE_SECTIONS''',
'order by n002'))
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/sections_settings_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(17135113310000767.4907)
,p_name=>'Sections Settings Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18785810240539012.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C07\5340\6BB5\79FB\52D5\81F3\5176\4ED6\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:990:&SESSION.::&DEBUG.::P990_SECTION_ID,P990_PAGE_ID:&SECTION_ID.,&P900_ID.:'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18786123053542660.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5C07\5340\6BB5\79FB\52D5\81F3\65B0\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:991:&SESSION.::&DEBUG.:991:P991_SECTION_ID,P991_PAGE_ID:&SECTION_ID.,&P900_ID.:'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(17154020760040710.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7DE8\8F2F\591A\500B\5340\6BB5')
,p_list_item_link_target=>'f?p=&APP_ID.:940:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18786329979544670.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\986F\793A\5340\6BB5\6B77\53F2\8A18\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'NEVER'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_pages
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18529824151546479.4907)
,p_name=>'Edit Pages'
,p_list_type=>'FUNCTION_RETURNING_SQL_QUERY'
,p_list_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    q               varchar2(32767) := null;',
'    l_parent_page_id number := null;',
'begin      ',
'    for c1 in (select parent_page_id',
'               from wwv_flow_ws_webpages',
'               where ws_app_id = :ws_app_id',
'               and security_group_id = :flow_security_group_id',
'               and id =:P53_ID)',
'    loop',
'        l_parent_page_id := c1.parent_page_id;',
'    end loop;    ',
'    ',
'    q := ''select level ''||',
'         ''	, name label ''||',
'         ''  , ''''javascript:applyAndGoToNextPage(''''''''''''||id||'''''''''''')'''' target ''||         ',
'         ''	, null is_current_list_entry ''||',
'         ''	, null image ''||',
'         ''	, null image_attribute ''||',
'         ''	, null image_alt_attribute ''||',
'         ''	, lower(decode(updated_by,null,created_by,updated_by)) attribute1 ''||',
'         ''	, htmldb_util.get_since(decode(updated_on,null,created_on,updated_on)) attribute2 ''||',
'         ''	, case when id = :P53_ID then ''''active'''' end attribute3 ''||',
'         ''from wwv_flow_ws_webpages ''||',
'         ''where security_group_id = :FLOW_SECURITY_GROUP_ID ''||',
'         ''and ws_app_id = :WS_APP_ID '';',
'         --''and level    <= 2 '';',
'    ',
'    if l_parent_page_id is null then',
'        q:=q||''start with parent_page_id is null '';',
'    else',
'        q:=q||''start with id = ''||l_parent_page_id;        ',
'    end if; ',
'',
'    q:=q||''connect by prior id = parent_page_id '';',
'    q:=q||''order siblings by name'';        ',
'    ',
'    return q;',
'end;'))
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/pages_settings_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(18583325957802446.4907)
,p_name=>'Pages Settings Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18583829450802448.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\65B0\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:200:P200_PARENT_PAGE,WS_APP_ID:&P900_ID.,&WS_APP_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(18584127738802448.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\65B0\9801\9762\70BA\8907\672C')
,p_list_item_link_target=>'f?p=&APP_ID.:908:&SESSION.::&DEBUG.:908:WS_APP_ID,P908_COPY_PAGE_FROM,P900_ID:&WS_APP_ID.,&P900_ID.,&P900_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23689225706066046.4907)
,p_name=>'Monitor Activity Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23689400293066047.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\9801\9762\6AA2\8996')
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23689719692066048.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'24'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23690031914066048.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\8CC7\6599\65B9\683C')
,p_list_item_link_target=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.::::	'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'141'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23690308632066049.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23690603303066049.4907)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'146'
);
end;
/
prompt --application/shared_components/navigation/lists/admin_annotations_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(23775330395531080.4907)
,p_name=>'Admin Annotations Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23775513281531081.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\6A94\6848')
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'143'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23775818182531082.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\9644\8A3B')
,p_list_item_link_target=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'144'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(23776108748531082.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\6A19\8A18')
,p_list_item_link_target=>'f?p=&APP_ID.:145:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'145'
);
end;
/
prompt --application/shared_components/navigation/lists/create_page_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(29874807106517169.4907)
,p_name=>'create page progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(173227427841861244.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5143\4EF6\985E\578B')
,p_list_item_link_target=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29885520930644174.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5EFA\7ACB\65B9\6CD5')
,p_list_item_link_target=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'205'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(29885725086645395.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\7279\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.:201:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'201,206'
);
end;
/
prompt --application/shared_components/navigation/lists/create_section_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(174369523339947712.4907)
,p_name=>'create section progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(174370314120954487.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\9078\64C7\5340\6BB5\985E\578B')
,p_list_item_link_target=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'920'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178563610566182386.4907)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>unistr('\5C0E\89BD\985E\578B')
,p_list_item_link_target=>'f?p=&APP_ID.:926:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'921,926,927'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'926'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178522522266580262.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8CC7\6599\4F86\6E90')
,p_list_item_link_target=>'f?p=&APP_ID.:922:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'922,925'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'922'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(174370522431956915.4907)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5B9A\7FA9\5340\6BB5')
,p_list_item_link_target=>'f?p=&APP_ID.:910:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'910,921,927,925'
);
end;
/
prompt --application/shared_components/navigation/lists/annotation_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(178837028298310188.4907)
,p_name=>'annotation tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187173101861909018.4907)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>unistr('\5168\90E8')
,p_list_item_link_target=>'f?p=&APP_ID.:906:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'906'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178837317622310200.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6A94\6848')
,p_list_item_link_target=>'f?p=&APP_ID.:903:&SESSION.::&DEBUG.:APEX$_WS_FILES:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'903'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178838019750310282.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\9644\8A3B')
,p_list_item_link_target=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'905'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(473073917597603316.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\9023\7D50')
,p_list_item_link_target=>'f?p=&APP_ID.:915:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'915'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(178837724276310282.4907)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\6A19\8A18')
,p_list_item_link_target=>'f?p=&APP_ID.:904:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'904'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(458964205010652503.4907)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\6A19\7C64\96F2')
,p_list_item_link_target=>'f?p=&APP_ID.:928:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'928'
);
end;
/
prompt --application/shared_components/navigation/lists/create_report_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(181250307256073810.4907)
,p_name=>'create report progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181310223288910949.4907)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>unistr('\5143\4EF6\985E\578B')
,p_list_item_link_target=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181259832284137754.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5831\8868\5C6C\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1310'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(181272207059234540.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\78BA\8A8D')
,p_list_item_link_target=>'f?p=&APP_ID.:1320:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1320'
);
end;
/
prompt --application/shared_components/navigation/lists/p_902_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(187087619151586620.4907)
,p_name=>'p 902 tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187087931306586621.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5168\90E8')
,p_list_item_link_target=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.::P902_SHOW:ALL:'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'EXISTS'
,p_list_item_current_for_pages=>'select 1 from dual where nvl(:P902_SHOW,''ALL'') = ''ALL'''
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187088302932586621.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\8CC7\6599\65B9\683C')
,p_list_item_link_target=>'f?p=4900:902:&SESSION.::::P902_SHOW:DATAGRID'
,p_list_item_current_type=>'EXISTS'
,p_list_item_current_for_pages=>'select 1 from dual where :P902_SHOW = ''DATAGRID'''
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(187088713953586622.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.::P902_SHOW:REPORT:'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'EXISTS'
,p_list_item_current_for_pages=>'select 1 from dual where :P902_SHOW = ''REPORT'''
);
end;
/
prompt --application/shared_components/navigation/lists/admin_toolbar_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(202684424744514793.4907)
,p_name=>'Admin Toolbar Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202686125516514795.4907)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\7BA1\7406')
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(:APP_USER,''nobody'') not in (''APEX_PUBLIC_USER'',''HTMLDB_PUBLIC_USER'',''ANONYMOUS'',''nobody'',''PUBLIC_USER'') then',
'  if wwv_flow_ws_security.current_user_is_admin or wwv_flow_ws_api.show_reset_password(p_ws_app_id => :ws_app_id) then',
'      return true;',
'  else',
'      return false;',
'  end if;',
'else',
'  return false;',
'end if;'))
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202688803947514796.4907)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\5100\8868\677F')
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4907)
,p_list_text_01=>'ws-admin-dashboard'
,p_list_text_05=>'Alt+B'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202692116934514798.4907)
,p_list_item_display_sequence=>280
,p_list_item_link_text=>unistr('\76E3\7763\6D3B\52D5')
,p_list_item_link_target=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4907)
,p_list_text_01=>'ws-admin-monitor'
,p_list_text_05=>'Alt+M'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202692413363514798.4907)
,p_list_item_display_sequence=>290
,p_list_item_link_text=>unistr('Web \8A66\7B97\8868\7279\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:1250:P1250_ID:&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4907)
,p_list_text_01=>'ws-admin-properties'
,p_list_text_05=>'Alt+P'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202692709697514798.4907)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\5B58\53D6\63A7\5236')
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4907)
,p_list_text_01=>'ws-admin-acl'
,p_list_text_05=>'Alt+X'
,p_security_scheme=>wwv_flow_api.id(456220816180174638)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(212953623410993837.4907)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'--'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4907)
,p_list_text_01=>'wsMenuSep'
,p_security_scheme=>wwv_flow_api.id(506060600392166972)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(202693609322514799.4907)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>unistr('\8B8A\66F4\6211\7684\5BC6\78BC')
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:5:::'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_parent_list_item_id=>wwv_flow_api.id(202686125516514795.4907)
,p_security_scheme=>wwv_flow_api.id(506060600392166972)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_chart_section_progress_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(261469429368022853.4907)
,p_name=>'create chart section progress bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261470512876027512.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5340\6BB5\985E\578B')
,p_list_item_link_target=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'920'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261470821880030114.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5716\8868\985E\578B')
,p_list_item_link_target=>'f?p=&APP_ID.:710:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'710'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261471504481044080.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5716\8868\4F86\6E90')
,p_list_item_link_target=>'f?p=&APP_ID.:740:&SESSION.::&DEBUG.::::'
,p_list_item_disp_condition2=>'DATA_GRID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'740:745'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261471828030050875.4907)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\5716\8868\5B9A\7FA9')
,p_list_item_link_target=>'f?p=&APP_ID.:742:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'742'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(261472414655056417.4907)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\5EFA\7ACB')
,p_list_item_link_target=>'f?p=&APP_ID.:750:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'750'
);
end;
/
prompt --application/shared_components/navigation/lists/help_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(456471813385447055.4907)
,p_name=>'Help Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(472810017189623092.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\95DC\65BC')
,p_list_item_link_target=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'16'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(456472503328447058.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\7E3D\89BD')
,p_list_item_link_target=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'15'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(619280916964076011.4907)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>unistr('\5B58\53D6\63A7\5236')
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(456472932226447059.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6A19\8A18\8A9E\6CD5')
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'17'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(6247915223597961.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\8CC7\6599\65B9\683C')
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491253712635289676.4907)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>unistr('\61C9\7528\7A0B\5F0F\5167\5BB9')
,p_list_item_link_target=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'25,27,28,29,30,12'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(487175029602607075.4907)
,p_list_item_display_sequence=>999
,p_list_item_link_text=>unistr('\5E38\898B\554F\984C')
,p_list_item_link_target=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'19'
);
end;
/
prompt --application/shared_components/navigation/lists/administration_menu_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(457230629124432618.4907)
,p_name=>'administration menu options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457230905908432621.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5100\8868\677F')
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'ws/ws-dashboard.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457231305495432622.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\76E3\7763\6D3B\52D5')
,p_list_item_link_target=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'ws/ws-chart.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457232713110446916.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('Web \8A66\7B97\8868\7279\6027')
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:1250:P1250_ID:&WS_APP_ID.:'
,p_list_item_icon=>'ws/ws-properties.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457321625061188359.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5B58\53D6\63A7\5236')
,p_list_item_link_target=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'ws/ws-access-control.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_menu_options
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(457456818808085338.4907)
,p_name=>'Page Menu Options'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457458705480119260.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\9996\9801')
,p_list_item_link_target=>'ws?p=&WS_APP_ID.:home:&SESSION.'
,p_list_item_icon=>'apex/builder/menu-home-128.gif'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457457112971085339.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\9801\9762\76EE\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex/builder/menu-page-dir-128.gif'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457468208784233794.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6AA2\8996\6B77\53F2\8A18\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex/builder/menu-change-log-128.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(457482932080297318.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\5EFA\7ACB\65B0\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:200:::'
,p_list_item_icon=>'apex/builder/menu-add-page-128.png'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/monitor_activity
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(459634320543429042.4907)
,p_name=>'Monitor Activity'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(459634600866429048.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\9801\9762\6AA2\8996')
,p_list_item_link_target=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471679808716623953.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'18'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471680625685628854.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\8CC7\6599\65B9\683C')
,p_list_item_link_target=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.::::	'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'141'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471681413003634676.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471917315656277818.4907)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_list_item_link_target=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_icon_attributes=>'width="20" height="20" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
end;
/
prompt --application/shared_components/navigation/lists/annotations
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(461178801985335895.4907)
,p_name=>'Annotations'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461179122466335896.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\6A94\6848')
,p_list_item_link_target=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461179526172335897.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\9644\8A3B')
,p_list_item_link_target=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461179925451335897.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\6700\5E38\4F7F\7528\7684\6A19\8A18')
,p_list_item_link_target=>'f?p=&APP_ID.:145:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_build_options.png'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'140'
);
end;
/
prompt --application/shared_components/navigation/lists/page_directory
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(461346705230446581.4907)
,p_name=>'Page Directory'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461347024629446628.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\9801\9762\76EE\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.:'
,p_list_item_current_for_pages=>'1000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(461347428128446630.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('Web \8A66\7B97\8868\76EE\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/history_tab
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(471880222274882374.4907)
,p_name=>'History Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471880504499882381.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.:'
,p_list_item_current_for_pages=>'950'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(471880901168882390.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\884C\4E8B\66C6')
,p_list_item_link_target=>'f?p=&APP_ID.:951:&SESSION.:'
,p_list_item_current_for_pages=>'951'
);
end;
/
prompt --application/shared_components/navigation/lists/help_application_content_tabs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(491255024672312078.4907)
,p_name=>'Help application content tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491256117021312081.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'25'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(492152905074851834.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5340\6BB5')
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'28'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491256416740312081.4907)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\6A94\6848 / \5F71\50CF')
,p_list_item_link_target=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'27'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491257030941312082.4907)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\8CC7\6599\65B9\683C')
,p_list_item_link_target=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT 1',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      nvl(a.websheet_type,''DATA'') = ''DATA'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'29'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491257320723312082.4907)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT 1',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      nvl(a.websheet_type,''DATA'') = ''REPORT'''))
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'30'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491257610094312082.4907)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\5EFA\8B70\7684 SQL')
,p_list_item_link_target=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_ws_applications',
' where id = :WS_APP_ID',
'   and security_group_id = :flow_security_group_id',
'   and allow_sql_yn = ''Y''',
'   and exists (select 1 from wwv_flow_ws_app_sug_objects',
'                where ws_app_id = :WS_APP_ID',
'                and security_group_id = :flow_security_group_id)'))
,p_security_scheme=>wwv_flow_api.id(495860932509802714)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'12'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_report_view_mode
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(491741626522063565.4907)
,p_name=>'edit report view mode'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491742324922072587.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\5831\8868\5C6C\6027')
,p_list_item_link_target=>'javascript:doSubmit(''SAVE_REPORT_ATTR'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3010:3020'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(491761112810144768.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5831\8868\67E5\8A62')
,p_list_item_link_target=>'javascript:doSubmit(''SAVE_QUERY'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3030:3060'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_0_toolbar_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(929134615131186819.4907)
,p_name=>'APEX 5.0 - Toolbar Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>unistr('\6AA2\8996')
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929138403023186825.4907)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>unistr('\9996\9801')
,p_list_item_link_target=>'ws?p=&WS_APP_ID.:home:&APP_SESSION.'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_text_01=>'ws-view-home'
,p_list_text_05=>'Alt+H'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929138706106186825.4907)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>unistr('\5448\73FE\6A21\5F0F')
,p_list_item_link_target=>'f?p=&APP_ID.:901:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'900'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_text_01=>'ws-view-presentation-mode'
,p_list_text_05=>'Alt+Q'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139001784186826.4907)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>unistr('\9801\9762\76EE\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929140888830186828.4907)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>unistr('\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.::P902_SHOW:REPORT:'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_text_01=>'ws-view-reports'
,p_list_text_05=>'Alt+R'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929141179837186828.4907)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>unistr('\9801\9762\6B77\53F2\8A18\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929141414305186828.4907)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>unistr('Web \8A66\7B97\8868\76EE\9304')
,p_list_item_link_target=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_text_01=>'ws-view-ws-directory'
,p_list_text_05=>'Alt+Shift+D'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(930987028365270703.4907)
,p_list_item_display_sequence=>270
,p_list_item_link_text=>unistr('\8A3B\89E3')
,p_parent_list_item_id=>wwv_flow_api.id(929134801726186821.4907)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139607423186826.4907)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>unistr('\6A94\6848')
,p_list_item_link_target=>'f?p=&APP_ID.:903:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139919238186826.4907)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>unistr('\6A19\8A18')
,p_list_item_link_target=>'f?p=&APP_ID.:928:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929140243536186826.4907)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>unistr('\9644\8A3B')
,p_list_item_link_target=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929140500508186828.4907)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>unistr('\9023\7D50')
,p_list_item_link_target=>'f?p=&APP_ID.:915:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(931217661486553673.4907)
,p_list_item_display_sequence=>203
,p_list_item_link_text=>'--'
,p_list_item_link_target=>'separator'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'7,8,32'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929139371751186826.4907)
,p_list_item_display_sequence=>205
,p_list_item_link_text=>unistr('\5168\90E8\6AA2\8996')
,p_list_item_link_target=>'f?p=&APP_ID.:906:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(930987028365270703.4907)
,p_list_text_01=>'ws-view-all-annotations'
,p_list_text_05=>'Alt+A'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>unistr('\5EFA\7ACB')
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136360244186823.4907)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>unistr('\65B0\5EFA\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:200:P200_PARENT_PAGE,WS_APP_ID:&P900_ID.,&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_text_01=>'ws-create-page'
,p_list_text_05=>'Alt+N'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136628803186823.4907)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>unistr('\65B0\9801\9762\70BA\8907\672C')
,p_list_item_link_target=>'f?p=&APP_ID.:908:&SESSION.::&DEBUG.:908:WS_APP_ID,P908_COPY_PAGE_FROM,P900_ID:&WS_APP_ID.,&P900_ID.,&P900_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136959895186825.4907)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>unistr('\65B0\5EFA\5340\6BB5')
,p_list_item_link_target=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.:920,921:WS_APP_ID,P921_STARTING_PAGE:&WS_APP_ID.,&P900_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_text_01=>'ws-create-section'
,p_list_text_05=>'Alt+Shift+N'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929137293514186825.4907)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>unistr('\65B0\5EFA\8CC7\6599\65B9\683C')
,p_list_item_link_target=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:205,1310,1320:WS_APP_ID:&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_text_01=>'ws-create-datagrid'
,p_list_text_05=>'Alt+Shift+D'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929137547826186825.4907)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>unistr('\65B0\5831\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.:1310,1320:WS_APP_ID:&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_text_01=>'ws-create-report'
,p_list_text_05=>'Alt+Shift+R'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929137898140186825.4907)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'--'
,p_list_item_link_target=>'separator'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'7,8,32'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929138168832186825.4907)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>unistr('\65B0 Web \8A66\7B97\8868')
,p_list_item_link_target=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:7,8,32:::'
,p_parent_list_item_id=>wwv_flow_api.id(929135108865186823.4907)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929135423776186823.4907)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>unistr('\5EFA\7ACB')
,p_list_text_02=>'true'
,p_security_scheme=>'!'||wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929135709186186823.4907)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>unistr('\7DE8\8F2F')
,p_list_text_03=>'Ctrl+N'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929141723344186828.4907)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>unistr('\7DE8\8F2F\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:53:P53_ID,WS_APP_ID:&P900_ID.,&WS_APP_ID.:'
,p_parent_list_item_id=>wwv_flow_api.id(929135709186186823.4907)
,p_list_text_01=>'ws-edit-page'
,p_list_text_05=>'Alt+E'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929142003161186828.4907)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>unistr('\522A\9664\9801\9762')
,p_list_item_link_target=>'f?p=&APP_ID.:960:&SESSION.::&DEBUG.:53:P53_ID:&P900_ID.:'
,p_list_item_disp_cond_type=>'PLSQL_EXPRESSION'
,p_list_item_disp_condition=>'not wwv_flow_ws_api.is_app_home_page(p_ws_app_id => :ws_app_id, p_webpage_id => :p900_id)'
,p_parent_list_item_id=>wwv_flow_api.id(929135709186186823.4907)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929142397543186828.4907)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>unistr('\7DE8\8F2F\5340\6BB5')
,p_list_item_link_target=>'f?p=&APP_ID.:940:&SESSION.::&DEBUG.:940:::'
,p_parent_list_item_id=>wwv_flow_api.id(929135709186186823.4907)
,p_list_text_01=>'ws-edit-sections'
,p_list_text_05=>'Alt+Shift+E'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(929136059659186823.4907)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>unistr('\7DE8\8F2F')
,p_list_text_02=>'true'
,p_security_scheme=>'!'||wwv_flow_api.id(456220226828170850)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1081228229344684.4907)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(2015719452410064.4907)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(14849102226940934.4907)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(92009116035572450.4907)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765073485610712056.4907)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831723025707993879.4907)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917633175675939889.4907)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178942513630772437.4907)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786516029127697713.4907
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178942909534772438.4907)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>unistr('\60A8\6C92\6709\4F7F\7528\300CSQL \5DE5\4F5C\5BA4\300D\7684\6388\6B0A')
,p_reference_id=>786516265251697717.4907
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178943426646772439.4907)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\6B64\5DE5\4F5C\5340\672A\555F\7528\5718\968A\958B\767C')
,p_reference_id=>786516861027697723.4907
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_websheets_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(178943900647772439.4907)
,p_name=>'APEX 5.0 Websheets Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, wwv_flow_fnd_user u',
'where nvl(w.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_WEBSHEET_DEV_YN,''Y'') = ''Y'''))
,p_error_message=>unistr('\6C92\6709\57F7\884C\5617\8A66\4E4B\4F5C\696D\7684\6B0A\9650')
,p_reference_id=>786517166823697723.4907
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/current_user_is_at_least_contributor
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(456220226828170850.4907)
,p_name=>'Current user is at least contributor'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.current_user_is_not_reader;'
,p_error_message=>unistr('\672A\6388\6B0A\60A8\5B58\53D6\6B64\529F\80FD.')
,p_reference_id=>786952716254317846.4907
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/current_user_is_admin
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(456220816180174638.4907)
,p_name=>'Current user is admin'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.current_user_is_admin;'
,p_error_message=>unistr('\672A\6388\6B0A\60A8\5B58\53D6\6B64\529F\80FD.')
,p_reference_id=>786954200597322276.4907
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/user_is_apex_developer
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(487678607690660963.4907)
,p_name=>'User is APEX Developer'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'  for c1 in (select 1 ',
'             from wwv_flow_developer_workspaces ',
'             where workspace_id = :flow_security_group_id',
'             and developer_name= :app_user)',
'  loop',
'    -- if websheet logged in user is developer then, return true',
'    return true;',
'  end loop;  ',
'  return false;',
'end;'))
,p_error_message=>unistr('\60A8\5FC5\9808\662F\300CApplication Express \958B\767C\4EBA\54E1\300D, \624D\80FD\5920\5B58\53D6\6B64\529F\80FD.')
,p_reference_id=>786953667141317846.4907
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/sql_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(492214905335570870.4907)
,p_name=>'SQL_ENABLED'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and wwv_flow_ws_security.sql_enabled_inst;'
,p_error_message=>unistr('\672A\555F\7528 SQL \5B58\53D6.')
,p_reference_id=>786953304778317846.4907
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/current_user_is_at_least_contributor_and_sql_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(495860932509802714.4907)
,p_name=>'Current user is at least contributor and SQL enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_security.current_user_is_not_reader and wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and wwv_flow_ws_security.sql_enabled_inst;'
,p_error_message=>unistr('\672A\6388\6B0A\60A8\5B58\53D6\6B64\529F\80FD.')
,p_reference_id=>786953038199317846.4907
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/show_reset_password
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(506060600392166972.4907)
,p_name=>'show reset password'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_ws_api.show_reset_password(p_ws_app_id => :ws_app_id);'
,p_error_message=>unistr('\672A\555F\7528\91CD\8A2D\5BC6\78BC.')
,p_reference_id=>786953911558317846.4907
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_packaged_app_enabled
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(763730931852686354.4907)
,p_name=>'APEX 5.0 Packaged App Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'PKG_APPS'
,p_error_message=>unistr('\60A8\6C92\6709\5B89\88DD\300C\5957\88DD\61C9\7528\7A0B\5F0F\300D\7684\6388\6B0A')
,p_reference_id=>786517456817697723.4907
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(2221120362249577.4907)
,p_icon_sequence=>10
,p_icon_subtext=>unistr('&APP_USER., \6B61\8FCE\60A8')
,p_icon_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_icon_image_alt=>unistr('&APP_USER., \6B61\8FCE\60A8')
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(617028331038386115.4907)
,p_icon_sequence=>20
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">\767B\5165</span> )')
,p_icon_target=>'f?p=&APP_ID.:79:&SESSION.:LOGIN:&DEBUG.::WS_APP_ID:&WS_APP_ID.:'
,p_icon_image_alt=>unistr('\767B\5165')
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'USER_IS_PUBLIC_USER'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(620001721380496329.4907)
,p_icon_sequence=>30
,p_icon_subtext=>unistr('\8A9E\8A00')
,p_icon_target=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:::'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(2290404332055831.4907)
,p_icon_sequence=>40
,p_icon_subtext=>unistr('( <span style="text-decoration:underline;">\767B\51FA</span> )')
,p_icon_target=>'f?p=&APP_ID.:79:&SESSION.::&DEBUG.::::'
,p_icon_image_alt=>unistr('\767B\51FA')
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'USER_IS_NOT_PUBLIC_USER'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(203498613231050603.4907)
,p_icon_sequence=>50
,p_icon_subtext=>unistr('\610F\898B\56DE\994B')
,p_icon_target=>'javascript:popupURL(''f?p=4900:102:&SESSION.:::102:P102_APPLICATION_ID,P102_PAGE_ID:&APP_ID.,&APP_PAGE_ID.'');'
,p_nav_entry_is_feedback_yn=>'Y'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/set_ui_mode
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(111038982738267161.4907)
,p_process_sequence=>1
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set UI Mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.set_ui_mode;'
,p_process_when=>'SET_UI_MODE_LIGHT,SET_UI_MODE_DARK'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/set_websheet_application_date_format_for_session
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(467798605271386699.4907)
,p_process_sequence=>5
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Websheet Application Date Format for Session'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_worksheet_standard.set_ws_app_date_format( ',
'    p_ws_app_id => :WS_APP_ID );'))
,p_process_error_message=>unistr('\8A2D\5B9A Web \8A66\7B97\8868\61C9\7528\7A0B\5F0F\65E5\671F\683C\5F0F\6642\767C\751F\932F\8AA4')
,p_process_when=>'WS_APP_ID'
,p_process_when_type=>'ITEM_NOT_NULL_OR_ZERO'
);
end;
/
prompt --application/shared_components/logic/application_processes/maintain_g_running_worksheets_app
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(185099800820727550.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'maintain g_running_worksheets_app'
,p_process_sql_clob=>'wwv_flow_log.g_websheet_id := :WS_APP_ID;'
,p_process_error_message=>unistr('\7121\6CD5\8A2D\70BA\5168\57DF')
);
end;
/
prompt --application/shared_components/logic/application_processes/check_user_is_at_least_reader
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(456113631939841224.4907)
,p_process_sequence=>15
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check user is at least reader'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_ws_security.get_current_user_role,''0'') = ''0'' then',
'  sys.htp.init;',
'  wwv_flow.g_unrecoverable_error := true;',
'                 sys.owa_util.redirect_url(''f?p=&APP_ID.:99:&SESSION.'');',
'',
'end if;'))
,p_process_error_message=>unistr('\5224\65B7\6388\6B0A\6642\767C\751F\932F\8AA4.')
,p_process_when=>':APP_PAGE_ID not in (''79'',''99'',''101'') and nvl(wwv_flow_security.g_user,''nobody'') != ''nobody'''
,p_process_when_type=>'PLSQL_EXPRESSION'
);
end;
/
prompt --application/shared_components/logic/application_processes/user_is_at_least_a_contributor
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(456277312414876323.4907)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'User is at least a contributor'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_ws_security.get_current_user_role,''0'') not in (''C'',''A'') then',
'  sys.htp.init;',
'  wwv_flow.g_unrecoverable_error := true;',
'  sys.owa_util.redirect_url(''f?p=&APP_ID.:99:&SESSION.'');',
'end if;'))
,p_process_error_message=>unistr('\672A\6388\6B0A\60A8\5B58\53D6\6B64\529F\80FD.')
,p_process_when=>'20,53,90,131,200,201,205,206,710,760,908,910,920,921,922,926,927,930,931,932,934,1310,1320,4020,4030,4040,940,960,3010,3030'
,p_process_when_type=>'CURRENT_PAGE_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/check_user_is_admin
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(456253831789380446.4907)
,p_process_sequence=>25
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Check user is admin'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if not wwv_flow_ws_security.current_user_is_admin then',
'',
'  sys.htp.init;',
'  wwv_flow.g_unrecoverable_error := true;',
'                 sys.owa_util.redirect_url(''f?p=4900:99:''||:APP_SESSION);',
'',
'end if;'))
,p_process_error_message=>unistr('\672A\6388\6B0A\60A8\5B58\53D6\6B64\529F\80FD.')
,p_process_when=>'1,3,11,13,18,24,140,141,142,143,144,145,146,1250'
,p_process_when_type=>'CURRENT_PAGE_IN_CONDITION'
);
end;
/
prompt --application/shared_components/logic/application_processes/websheet
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(1367007177305239.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'websheet'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_widget_action     varchar2(32767) := wwv_flow.g_widget_action;',
'  l_validation_error  varchar2(32767) := null;',
'  l_opt               varchar2(4000) := null;',
'begin',
'  if l_widget_action = ''websheet_properties_save'' then',
'    wwv_flow_ws_api.save_websheet_properties (',
'        p_ws_app_id        => :WS_APP_ID,',
'        p_worksheet_id     => :P2_ID,        ',
'        p_name             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NAME''),',
'        p_alias            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ALIAS''),',
'        p_description      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DESCRIPTION''),        ',
'        p_row_pk1          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROW_PK1''),',
'        p_row_pk2          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROW_PK2''),',
'        p_row_pk3          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROW_PK3''),',
'        p_publish          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_PUBLISH''),',
'        p_validation_error => l_validation_error',
'        );',
'  elsif l_widget_action = ''column_properties_save'' then',
'     wwv_flow_ws_api.save_column_properties (',
'        p_worksheet_id      => :P2_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,',
'        p_app_user          => :APP_USER,',
'        p_db_column_name    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'        p_display_order     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'        p_group_id          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),       ',
'        p_display_as        => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),        ',
'        p_label             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_LABEL''),',
'        p_format_mask       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_FORMAT_MASK''),        ',
'        p_value_required    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),        ',
'        p_heading_alignment => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HEADING_ALIGNMENT''),',
'        p_column_alignment  => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_ALIGNMENT''),        ',
'        p_lov_id            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'        p_lov_name          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'        p_lov_entries       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),        ',
'        p_default_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'        p_default_text      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),        ',
'        p_width             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_WIDTH''),',
'        p_max_width         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_MAX_LENGTH''),',
'        p_height            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_HEIGHT''),',
'        p_help_text         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HELP_TEXT''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''column_add'' then',
'     wwv_flow_ws_api.add_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_report_id        => :RPT_ID,',
'         p_app_user         => :APP_USER,',
'         p_column_name      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_NAME''),',
'         p_column_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_TYPE''),',
'         p_display_as       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'         p_value_required   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),',
'         p_default_type     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'         p_default_text     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),',
'         p_validation_error => l_validation_error',
'         ); ',
'  elsif l_widget_action = ''column_remove'' then',
'',
'',
'',
'     wwv_flow_ws_api.remove_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),      ',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''lov_save'' then',
'     wwv_flow_ws_api.save_lov (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),  ',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''column_groups_save'' then',
'     wwv_flow_ws_api.save_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'         p_group_name       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NAME''),',
'         p_description      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DESCRIPTION''),         ',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_SHUTTLE_RIGHT''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''column_groups_delete'' then',
'     wwv_flow_ws_api.delete_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID'')',
'         );',
'  elsif l_widget_action = ''copy'' then',
'    wwv_flow_ws_api.copy_websheet (',
'         p_ws_app_id        => :WS_APP_ID,',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_new_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NEW_WORKSHEET_NAME''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''delete_websheet'' then    ',
'    wwv_flow_ws_api.delete_websheet (',
'        p_worksheet_id     => :P2_ID,',
'        p_websheet_id      => :P2_WEBSHEET_ID,               ',
'        p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),',
'        p_validation_error => l_validation_error);       ',
'  elsif l_widget_action = ''delete_rows'' then',
'    wwv_flow_ws_api.delete_rows (',
'        p_websheet_id      => :P2_WEBSHEET_ID,',
'        p_rows             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROWS''),',
'        p_selected_rows    => wwv_flow.g_x01,',
'        p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),',
'        p_validation_error => l_validation_error);',
'  elsif l_widget_action = ''set_column_value'' then',
'    wwv_flow_ws_api.set_column_value (',
'        p_websheet_id      => :P2_WEBSHEET_ID, ',
'        p_db_column_name   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'        p_new_value        => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NEW_COLUMN_VALUE''),',
'        p_rows             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROWS''),',
'        p_selected_rows    => wwv_flow.g_x01,',
'        p_validation_error => l_validation_error);',
'  elsif l_widget_action = ''replace_column_value'' then',
'    wwv_flow_ws_api.replace_column_value (',
'        p_websheet_id      => :P2_WEBSHEET_ID,',
'        p_rows              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ROWS''),',
'        p_db_column_names   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMS''),',
'        p_find_what         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REPLACE''),',
'        p_replace_with      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REPLACE_WITH''),',
'        p_selected_rows     => wwv_flow.g_x01,',
'        p_validation_error  => l_validation_error);',
'  elsif l_widget_action = ''fill_column_value'' then',
'    wwv_flow_ws_api.fill_column_value (',
'        p_websheet_id      => :P2_WEBSHEET_ID,',
'        p_db_column_name     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),    ',
'        p_validation_error   => l_validation_error);',
'  elsif l_widget_action = ''lov_delete'' then',
'    wwv_flow_ws_api.delete_lov (',
'        p_worksheet_id     => :P2_ID,',
'        p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),  ',
'        p_validation_error => l_validation_error',
'        );     ',
'  elsif l_widget_action = ''toggle_checkboxes'' then',
'        if nvl(v(''P2_SHOW_CHECKBOX''),''N'') = ''Y'' then',
'            wwv_flow.update_cache_with_write(p_name => ''P2_SHOW_CHECKBOX'', p_value => ''N'');            ',
'        elsif nvl(v(''P2_SHOW_CHECKBOX''),''N'') = ''N'' then',
'            wwv_flow.update_cache_with_write(p_name => ''P2_SHOW_CHECKBOX'', p_value => ''Y'');',
'        end if;',
'  elsif l_widget_action = ''export'' then',
'    if wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_EXPORT_FORMAT'') = ''DATABASE'' then',
'        sys.owa_util.redirect_url(''f?p=''||:APP_ID||'':2:''||:APP_SESSION||'':HTMLD'');',
'    end if;',
'  elsif l_widget_action = ''set_geocode'' then',
'    wwv_flow_ws_geocode.save_geocodes(',
'        p_worksheet_id => :P2_ID,',
'        p_columns      => wwv_flow.g_x01 );',
'  elsif l_widget_action = ''refresh_geocode'' then',
'    wwv_flow_ws_geocode.reset_geocodes(',
'        p_worksheet_id => :P2_ID);',
'  elsif l_widget_action = ''VALIDATION_SAVE'' then',
'     wwv_flow_ws_api.save_column_validation (',
'         p_ws_app_id        => :WS_APP_ID,',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID''),',
'         p_validation_level => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_LEVEL''),',
'         p_name             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_NAME''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_SEQUENCE''),',
'         p_type             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_TYPE''),',
'         p_expr1            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_expr2            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION''),',
'         p_error_message    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ERROR_MESSAGE''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''VALIDATION_DELETE'' then',
'     wwv_flow_ws_api.delete_column_validation (',
'         p_worksheet_id     => :P2_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID'')         ',
'         );       ',
'  end if;  ',
'',
'  if l_validation_error is null then',
'      sys.htp.prn(''true'');      ',
'  else',
'      sys.htp.prn(l_validation_error);      ',
'  end if;',
'exception when others then',
'  sys.htp.prn(''error ''||wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_process_error_message=>'websheet process error'
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_process_comment=>'WebSheet dialog saving.'
);
end;
/
prompt --application/shared_components/logic/application_processes/item_row
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(2693010773842087.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ITEM_ROW'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_goto_ws_row       varchar2(32767);',
'    l_validation_error	varchar2(32767) := null;',
'    l_validation_count  number          := 0;',
'    l_validation_title  varchar2(4000)  := null;',
'    l_action            varchar2(4000)  := wwv_flow.g_x01;',
'begin',
'    -- Don''t process the row, if we''re removing a column.',
'    if l_action != ''column_remove'' then ',
'        wwv_flow_ws_api.process_row (',
'            p_ws_app_id     => :WS_APP_ID,',
'            p_worksheet_id  => :P2_ID,',
'            p_websheet_id   => :P2_WEBSHEET_ID,',
'            p_row_id        => :CURRENT_WORKSHEET_ROW,',
'            f01             => wwv_flow.g_f01,',
'            f02             => wwv_flow.g_f02,       ',
'            p_validation_error => l_validation_error,',
'            p_validation_count => l_validation_count,',
'            p_ajax_mode => true );',
'    end if;',
'    ',
'    if l_validation_count = 0 then',
'        htmldb_util.set_session_state(''CURRENT_WORKSHEET_ROW'', v(''GOTO_WORKSHEET_ROW''));',
'        htmldb_util.set_session_state(''P20_ROW_ID'', v(''GOTO_WORKSHEET_ROW''));',
'        --htmldb_util.set_session_state(''P20_IR_ID'', :P2_ID);',
'        --htmldb_util.set_session_state(''P20_DATA_GRID_ID'', :P2_WEBSHEET_ID);',
'        --:CURRENT_WORKSHEET_ROW := :GOTO_WORKSHEET_ROW;',
'        --:P20_ROW_ID := :GOTO_WORKSHEET_ROW;',
'        --:P20_IR_ID := :P2_ID;',
'        --:P20_DATA_GRID_ID := :P2_WEBSHEET_ID; ',
'        -- Redraw the form, with the new row''s details.',
'        sys.htp.prn(''<div id="apexir_WORKSHEET_REGION" class="apex_worksheet">'');',
'        sys.htp.prn(''<div id="apexir_DETAIL" class="detail">'');        ',
'        wwv_flow_ws_form.show (',
'            p_ws_app_id            => :WS_APP_ID,',
'        	p_worksheet_id         => :P2_ID,',
'        	p_data_grid_id         => :P2_WEBSHEET_ID,',
'        	p_session              => :APP_SESSION,',
'        	p_app_user             => :APP_USER,',
'        	p_row_id               => v(''CURRENT_WORKSHEET_ROW''),         ',
'        	p_base_report_id       => :RPT_ID,',
'            p_partial_page_refresh => true,',
'            p_last_page_id         => :P20_LAST_PAGE_ID,',
'            p_last_section_id      => :P20_LAST_SECTION_ID);',
'        sys.htp.prn(''</div></div>'');',
'    else',
'        if l_validation_count = 1 then',
'            l_validation_title := wwv_flow_lang.system_message(''FLOW.SINGLE_VALIDATION_ERROR'');',
'        else',
'            l_validation_title := wwv_flow_lang.system_message(''FLOW.VALIDATION_ERROR'', l_validation_count);',
'        end if;',
'        l_validation_error := l_validation_title || ''<ul class="htmldbUlErr">'' || l_validation_error || ''</ul>'';',
'        sys.htp.prn(''error|'' || l_validation_error);',
'    end if;',
'      ',
'exception',
'    when others then',
'        sys.htp.prn(''error|'' || wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
,p_process_comment=>'This application process is used to re-load single row detail view data with validation message from page 20.'
);
end;
/
prompt --application/shared_components/logic/application_processes/websheet_detail
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(2776923488356345.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'websheet_detail'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_widget_action           varchar2(32767) := upper(wwv_flow.g_widget_action);',
'  l_widget_action_mod       varchar2(32767) := wwv_flow.g_widget_action_mod;',
'  l_validation_error        varchar2(32767) := null;',
'begin  ',
'  if l_widget_action = ''NOTE_SAVE'' then      ',
'      wwv_flow_ws_api.add_note (',
'        p_ws_app_id         => :WS_APP_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,',
'        p_row_id            => :CURRENT_WORKSHEET_ROW,',
'        p_note_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NOTE_ID''),',
'        p_component_level   => ''ROW'',',
'        p_content           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NOTES''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''NOTE_DELETE'' then',
'      wwv_flow_ws_api.delete_note ( ',
'        p_note_id   => l_widget_action_mod);',
'  elsif l_widget_action = ''COLUMN_PROPERTIES_SAVE'' then      ',
'      wwv_flow_ws_api.save_column_properties (',
'        p_worksheet_id      => :P2_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,',
'        p_app_user          => :APP_USER,',
'        p_db_column_name    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'        p_display_order     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'        p_group_id          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),       ',
'        p_display_as        => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),',
'        p_label             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_LABEL''),',
'        p_format_mask       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_FORMAT_MASK''),        ',
'        p_value_required    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),        ',
'        p_heading_alignment => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HEADING_ALIGNMENT''),',
'        p_column_alignment  => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_ALIGNMENT''),        ',
'        p_lov_id            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'        p_lov_name          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'        p_lov_entries       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),        ',
'        p_default_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'        p_default_text      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),        ',
'        p_width             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_WIDTH''),',
'        p_max_width         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_MAX_LENGTH''),',
'        p_height            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_HEIGHT''),',
'        p_help_text         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_HELP_TEXT''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''LINK_SAVE'' then',
'      wwv_flow_ws_api.add_link (',
'        p_ws_app_id         => :WS_APP_ID,',
'        p_websheet_id       => :P2_WEBSHEET_ID,          ',
'        p_row_id            => :CURRENT_WORKSHEET_ROW,',
'        p_component_level   => ''ROW'',',
'        p_link_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LINK_ID''),',
'        p_link_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LINK_NAME''), ',
'        p_url               => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_URL''),',
'        p_validation_error  => l_validation_error',
'        );',
'  elsif l_widget_action = ''LINK_DELETE'' then',
'        wwv_flow_ws_api.delete_link ( ',
'            p_link_id   => l_widget_action_mod);',
'',
'  elsif l_widget_action = ''TAG_SAVE'' then',
'    wwv_flow_ws_api.add_tags (    ',
'        p_ws_app_id       => :WS_APP_ID,            ',
'        p_websheet_id     => :P2_WEBSHEET_ID,',
'        p_row_id          => :CURRENT_WORKSHEET_ROW,',
'        p_component_level => ''ROW'',',
'        p_tag             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_TAGS'')); ',
'  elsif l_widget_action = ''TAG_DELETE'' then',
'        wwv_flow_ws_api.delete_tag (',
'            p_websheet_id  => :P2_WEBSHEET_ID,',
'            p_row_id       => :CURRENT_WORKSHEET_ROW,',
'            p_tag_id       => l_widget_action_mod);',
'  elsif l_widget_action = ''ATTACHMENT_DELETE'' then',
'        wwv_flow_ws_attachment.delete_doc ( ',
'            p_doc_id   => l_widget_action_mod);',
'  elsif l_widget_action = ''LOV_DELETE'' then',
'    wwv_flow_ws_api.delete_lov (',
'        p_worksheet_id     => :P2_ID,',
'        p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),  ',
'        p_validation_error => l_validation_error',
'        );',
'  elsif l_widget_action = ''LOV_SAVE'' then',
'     wwv_flow_ws_api.save_lov (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ID''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),  ',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''VALIDATION_SAVE'' then',
'     wwv_flow_ws_api.save_column_validation (',
'         p_ws_app_id        => :WS_APP_ID,',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID''),',
'         p_validation_level => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_LEVEL''),',
'         p_name             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_NAME''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_SEQUENCE''),',
'         p_type             => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_TYPE''),',
'         p_expr1            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_expr2            => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION''),',
'         p_error_message    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_ERROR_MESSAGE''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''VALIDATION_DELETE'' then',
'     wwv_flow_ws_api.delete_column_validation (',
'         p_worksheet_id     => :P2_ID,',
'         p_validation_id    => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_VALIDATION_ID'')         ',
'         );',
'  elsif l_widget_action = ''COLUMN_GROUPS_SAVE'' then',
'     wwv_flow_ws_api.save_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),',
'         p_seq              => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_SEQUENCE''),',
'         p_group_name       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_NAME''),',
'         p_description      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DESCRIPTION''),         ',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_SHUTTLE_RIGHT''),',
'         p_validation_error => l_validation_error',
'         );',
'  elsif l_widget_action = ''COLUMN_GROUPS_DELETE'' then',
'     wwv_flow_ws_api.delete_column_group (',
'         p_worksheet_id     => :P2_ID,',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID'')',
'         );',
'  -- cbcho',
'  elsif l_widget_action = ''COLUMN_ADD'' then',
'     wwv_flow_ws_api.add_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_websheet_id      => :P2_WEBSHEET_ID,',
'         p_report_id        => :RPT_ID,',
'         p_app_user         => :APP_USER,',
'         p_column_name      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_NAME''),',
'         p_group_id         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_GROUP_ID''),',
'         p_column_type      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN_TYPE''),',
'         p_display_as       => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DISPLAY_AS''),',
'         p_lov_id           => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV''),',
'         p_value_required   => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_REQUIRED''),',
'         p_default_type     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TYPE''),',
'         p_default_text     => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_DEFAULT_TEXT''),',
'         p_lov_name         => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_NAME''),',
'         p_lov_entries      => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_LOV_ENTRIES''),',
'         p_validation_error => l_validation_error',
'         ); ',
'  elsif l_widget_action = ''COLUMN_REMOVE'' then',
'     wwv_flow_ws_api.remove_column (',
'         p_worksheet_id     => :P2_ID,',
'         p_columns          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_COLUMN''),',
'         p_confirm          => wwv_flow_ws_api.get_item_value(p_item_name => ''apexir_CONFIRM''),      ',
'         p_validation_error => l_validation_error',
'         );',
'  end if;',
'',
'  if l_validation_error is null then',
'      sys.htp.prn(''true'');      ',
'  else',
'      sys.htp.prn(l_validation_error);      ',
'  end if;',
'exception when others then',
'  sys.htp.prn(''error ''||wwv_flow_escape.html(sqlerrm));',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/dialog
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(3291701954237236.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'DIALOG'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_dialog.ondemand_dialog (',
'    p_websheet_id    => :P2_WEBSHEET_IT,',
'    p_worksheet_id   => :P2_ID,',
'    p_base_report_id => :RPT_ID,',
'    p_row_id         => :CURRENT_WORKSHEET_ROW );'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/cell
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(37132405811210809.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'CELL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_ACTION			varchar2(32767);',
'    l_ROW				varchar2(32767);',
'    l_COLUMN			varchar2(32767);',
'    l_VALUE				varchar2(32767);',
'    l_CHANGE			varchar2(32767);',
'    l_validation_error	varchar2(32767) := null;',
'begin',
'    l_ROW       := wwv_flow_ws_api.get_item_value(p_item_name => ''ROW'');',
'    l_COLUMN    := wwv_flow_ws_api.get_item_value(p_item_name => ''COLUMN'');',
'    l_VALUE     := wwv_flow_ws_api.get_item_value(p_item_name => ''VALUE'');',
'    l_CHANGE    := wwv_flow_ws_api.get_item_value(p_item_name => ''CHANGE'');',
'    l_ACTION    := wwv_flow_ws_api.get_item_value(p_item_name => ''ACTION'');    ',
'    if l_ACTION = ''SAVE'' then                       ',
'    	wwv_flow_ws_api.update_cell( ',
'            p_worksheet_id     => :P2_ID,',
'    	   p_websheet_id      => :P2_WEBSHEET_ID, ',
'    	   p_row_id           => l_ROW , ',
'    	   p_column_name      => l_COLUMN, ',
'    	   p_new_value        => l_VALUE,',
'    	   p_change_count     => l_CHANGE,',
'    	   p_validation_error => l_validation_error);',
'     else ',
'    	null;',
'     end if;',
'    if l_validation_error is null then    ',
'        sys.htp.prn(''true'');',
'    else',
'        sys.htp.prn(l_validation_error);',
'    end if;',
'exception when others then',
'    sys.htp.prn(wwv_flow_escape.html(substr(sqlerrm,instr(sqlerrm,''ORA-'',-1))));',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/get_item_help
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(452245511492078992.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET_ITEM_HELP'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_form.show_column_popup (',
'    p_db_column_name => wwv_flow_ws_api.get_item_value(p_item_name => ''COLUMN_NAME''),',
'    p_workspace_id   => to_number(:WORKSPACE_ID),',
'    p_worksheet_id   => to_number(:P2_ID));'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/get_dtfmt
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(460600501716774062.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get_dtFmt'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_COLUMN			varchar2(32767);',
'    l_DATE                      varchar2(32767);',
'    l_app_date_format   varchar2(4000);',
'    l_format_mask       varchar2(4000);',
'    l_json_return           varchar2(32767);',
'begin',
'    l_COLUMN    := wwv_flow_ws_api.get_item_value(p_item_name => ''COLUMN'');',
'    l_DATE      := wwv_flow_ws_api.get_item_value(p_item_name => ''DATE'');',
'',
'    l_json_return := wwv_flow_ws_api.inline_date_picker_options(',
'        p_worksheet_id => :P2_ID,',
'        p_date         => l_DATE,',
'        p_column       => l_COLUMN );',
'',
'',
'    sys.htp.prn(l_json_return);',
'',
'end;'))
,p_security_scheme=>wwv_flow_api.id(456220226828170850)
);
end;
/
prompt --application/shared_components/logic/application_processes/get_lov_json
begin
wwv_flow_api.create_flow_process(
 p_id=>wwv_flow_api.id(615062144451949851.4907)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET_LOV_JSON'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_worksheet_id varchar2(32767) := wwv_flow.g_x01;  ',
'    l_single_id    varchar2(32767) := wwv_flow_worksheet_ajax.clean_column_name(wwv_flow.g_x02);',
'begin',
'    wwv_flow_ws_api.get_lov_json(',
'        p_worksheet_id   => l_worksheet_id,',
'        p_db_column_name => l_single_id );',
'end;        '))
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24477906500589587.4907)
,p_name=>'AJAX_WS_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'FILTER,SEARCH,SORT'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24506014409837883.4907)
,p_name=>'AJAX_WS_COLUMN'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24505231939833457.4907)
,p_name=>'AJAX_WS_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(24503818779829694.4907)
,p_name=>'AJAX_WS_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(25407924412215582.4907)
,p_name=>'AJAX_WS_NUM'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(187889401560281661.4907)
,p_name=>'APP_NAME'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(406291700131840546.4907)
,p_name=>'BUILDER_SESSION_ID'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(179652013865859868.4907)
,p_name=>'CURRENT_WORKSHEET_ROW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(161139305537061829.4907)
,p_name=>'F4900_LAST_VIEW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(617034601471718123.4907)
,p_name=>'F4900_LOGIN_URL'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(471216109613872357.4907)
,p_name=>'F4900_LOGO'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(154784210014091542.4907)
,p_name=>'FSP_AFTER_LOGIN_URL'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(461331700195331599.4907)
,p_name=>'GOTO_WORKSHEET_ROW'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(458560827333195349.4907)
,p_name=>'HOME_PAGE_ID'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185115316114835976.4907)
,p_name=>'IR_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'This application item is used to run Websheet reports and Data Grid on page 3010.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(7934826114498652.4907)
,p_name=>'ITEM_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(176645422859500226.4907)
,p_name=>'OWNER_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(179806310494315818.4907)
,p_name=>'RPT_ID'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185298032482647725.4907)
,p_name=>'RUN_LINK'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(20015114768535427.4907)
,p_name=>'SECTION_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(172130707665449025.4907)
,p_name=>'SHOWNAV'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(7965920927622901.4907)
,p_name=>'TEMPORARY_ACTION'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23088531657485941.4907)
,p_name=>'TEMPORARY_FILTER'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(7939330981651397.4907)
,p_name=>'TEMPORARY_ITEM'
,p_protection_level=>'N'
,p_item_comment=>'This is used to run a action using AJAX it should not be used on anything else and not be expected to save it''s value between requests.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(23801903782632819.4907)
,p_name=>'WORKSHEET_FILTER_TYPE'
,p_protection_level=>'N'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(78919021160643130.4907)
,p_name=>'WORKSHEET_NAME'
,p_protection_level=>'I'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185116129620839895.4907)
,p_name=>'WS_APP_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'Websheet application ID'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(185115622347837829.4907)
,p_name=>'WS_ID'
,p_data_type=>'NUMBER'
,p_protection_level=>'N'
,p_item_comment=>'This application item is used to run Websheet reports and Data Grid on page 3010.'
);
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(451945309573247981.4907)
,p_name=>'WS_SETUP_VALID'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(471216708359881476.4907)
,p_computation_sequence=>100
,p_computation_item=>'F4900_LOGO'
,p_computation_point=>'AFTER_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'return wwv_flow_ws_api.get_logo(p_ws_app_id=>:WS_APP_ID,p_security_group_id=>:flow_security_group_id);'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(458561209110199522.4907)
,p_computation_sequence=>10
,p_computation_item=>'HOME_PAGE_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select HOME_PAGE_ID',
'  from WWV_FLOW_WS_APPLICATIONS',
' where id = :WS_APP_ID',
'and security_group_id = :WORKSPACE_ID'))
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(617038105476908535.4907)
,p_computation_sequence=>10
,p_computation_item=>'F4900_LOGIN_URL'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'return wwv_flow_ws_webpage.get_login_url(:WS_APP_ID);'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(172131313205450686.4907)
,p_computation_sequence=>10
,p_computation_item=>'SHOWNAV'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'Y'
);
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(406460806842851924.4907)
,p_computation_sequence=>10
,p_computation_item=>'BUILDER_SESSION_ID'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'return wwv_flow_security.get_builder_session_id;'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/accessibility_mode
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(680996401756072029.4907)
,p_lov_name=>'ACCESSIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_api.id(680996401756072029.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(680996730973072031.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\87A2\5E55\52A9\8B80\7A0B\5F0F')
,p_lov_return_value=>'SCREEN_READER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(680996901097072032.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\9AD8\5C0D\6BD4')
,p_lov_return_value=>'HIGH_CONTRAST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/acl_priv
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4183515898494342.4907)
,p_lov_name=>'ACL_PRIV'
,p_lov_query=>'.'||wwv_flow_api.id(4183515898494342.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4183804118494346.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6AA2\8996\53CA\7DE8\8F2F')
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4184010247494348.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\50C5\6AA2\8996')
,p_lov_return_value=>'VIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/alignment_l_c_r
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187517603302080409.4907)
,p_lov_name=>'ALIGNMENT_L_C_R'
,p_lov_query=>'.'||wwv_flow_api.id(187517603302080409.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187517811651080411.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9760\5DE6')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187518005825080412.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\7F6E\4E2D')
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187518229295080412.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\9760\53F3')
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_or_selected_or_null_row_domain
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6200201590860952.4907)
,p_lov_name=>'ALL OR SELECTED OR NULL (ROW DOMAIN)'
,p_lov_query=>'.'||wwv_flow_api.id(6200201590860952.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6200409579860953.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\8CC7\6599\5217')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6200608372860954.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\9078\53D6\7684\8CC7\6599\5217')
,p_lov_return_value=>'SELECTED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(20082523608431635.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\7A7A\503C\8CC7\6599\5217')
,p_lov_return_value=>'NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/annotation_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(251379008493597083.4907)
,p_lov_name=>'ANNOTATION TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(251379008493597083.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251379209365597089.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6A94\6848')
,p_lov_return_value=>'ATTACHMENT'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:4020:&SESSION.:::4020:P4020_ANNOTATION_TYPE:ATTACHMENT"><img src="#IMAGE_PREFIX#menu/wiz_multiple_140x90.gif" height="90" widt'
||'h="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251379423628597095.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\9644\8A3B')
,p_lov_return_value=>'NOTE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:4020:&SESSION.:::4020:P4020_ANNOTATION_TYPE:NOTE"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" '
||'width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(251379620302597095.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\6A19\8A18')
,p_lov_return_value=>'TAG'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:4020:&SESSION.:::4020:P4020_ANNOTATION_TYPE"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width'
||'="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(631189019655476474.4907)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\9023\7D50')
,p_lov_return_value=>'LINK'
,p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_lov_disp_cond=>'906'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_name_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(172965416124494830.4907)
,p_lov_name=>'APPLICATION NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'from   wwv_flows f',
'where  ',
'       security_group_id = :flow_security_group_id and',
'       not exists (',
'       select null from wwv_flow_language_map',
'       where translation_flow_id = f.id and ',
'         security_group_id = :flow_security_group_id) and',
'       (',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id is null and ',
'             security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :app_user and ',
'             flow_id = f.id and ',
'             security_group_id = :flow_security_group_id ))'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/attachment_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177785329944899135.4907)
,p_lov_name=>'ATTACHMENT OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(177785329944899135.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177785525202899136.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5728\5831\8868\4E2D\986F\793A\4E14\542B\5716\793A\548C\540D\7A31')
,p_lov_return_value=>'BOTH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177785716327899136.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5728\5831\8868\4E2D\986F\793A\4E14\53EA\542B\540D\7A31')
,p_lov_return_value=>'NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177785901379899136.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\53EA\986F\793A\5716\793A')
,p_lov_return_value=>'ICON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_content_disposition
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(382939512009208407.4907)
,p_lov_name=>'BLOB_CONTENT_DISPOSITION'
,p_lov_query=>'.'||wwv_flow_api.id(382939512009208407.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382939815594208407.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5167\5D4C')
,p_lov_return_value=>'inline'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382940022425208407.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\9644\4EF6')
,p_lov_return_value=>'attachment'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_format_mask
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(382915819151201016.4907)
,p_lov_name=>'BLOB_FORMAT_MASK'
,p_lov_query=>'.'||wwv_flow_api.id(382915819151201016.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382916131553201016.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'DOWNLOAD'
,p_lov_return_value=>'DOWNLOAD'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(382916305818201016.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'IMAGE'
,p_lov_return_value=>'IMAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_on
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22967915270872919.4907)
,p_lov_name=>'BREAK ON'
,p_lov_query=>'.'||wwv_flow_api.id(22967915270872919.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24136313336017502.4907)
,p_lov_disp_sequence=>0
,p_lov_disp_value=>unistr('\6C92\6709\5206\9694')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22968117650872920.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8CC7\6599\6B04 1')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22968313303872920.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8CC7\6599\6B04 1 \548C 2')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22968508747872920.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\8CC7\6599\6B04 1\30012 \548C 3')
,p_lov_return_value=>'3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_functions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261396928274568408.4907)
,p_lov_name=>'CHART FUNCTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(261396928274568408.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397126573568409.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7E3D\548C')
,p_lov_return_value=>'SUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397325621568409.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5E73\5747\503C')
,p_lov_return_value=>'AVG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397511265568409.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6700\5C0F\503C')
,p_lov_return_value=>'MIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397717213568409.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6700\5927\503C')
,p_lov_return_value=>'MAX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261397932564568409.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\8A08\6578')
,p_lov_return_value=>'COUNT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_sort
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261446703779618102.4907)
,p_lov_name=>'CHART SORT'
,p_lov_query=>'.'||wwv_flow_api.id(261446703779618102.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261446917693618102.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9810\8A2D')
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447112282618103.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\503C - \905E\589E')
,p_lov_return_value=>'VALUE_ASC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447310262618103.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\503C - \905E\6E1B')
,p_lov_return_value=>'VALUE_DESC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447525538618103.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6A19\7C64 - \905E\589E')
,p_lov_return_value=>'LABEL_ASC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261447704881618103.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\6A19\7C64 - \905E\6E1B')
,p_lov_return_value=>'LABEL_DESC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_3d
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(430988702419464894.4907)
,p_lov_name=>'CHART_3D'
,p_lov_query=>'.'||wwv_flow_api.id(430988702419464894.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(430988921586464895.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\555F\7528 3D')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_orientation
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(107038275478210797.4907)
,p_lov_name=>'CHART_ORIENTATION'
,p_lov_query=>'.'||wwv_flow_api.id(107038275478210797.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(107038518670210798.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5782\76F4')
,p_lov_return_value=>'vertical'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(107038941666210804.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6C34\5E73')
,p_lov_return_value=>'horizontal'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(259453605523899856.4907)
,p_lov_name=>'CHART_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(259453605523899856.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259453813697899860.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9577\689D\5716')
,p_lov_return_value=>'bar'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:bar"><img src="#IMAGE_PREFIX#ws/ws-column-chart.png" alt="#DISPLAY_VALUE#" width="128" height='
||'"128" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259454024992899863.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6298\7DDA\5340\57DF\5716')
,p_lov_return_value=>'lineWithArea'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:lineWithArea"><img src="#IMAGE_PREFIX#ws/ws-line-area-chart.png" alt="#DISPLAY_VALUE#" width="'
||'128" height="128" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259454217060899863.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5713\9905\5716')
,p_lov_return_value=>'pie'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:pie"><img src="#IMAGE_PREFIX#ws/ws-pie-chart.png" alt="#DISPLAY_VALUE#" width="128" height="12'
||'8" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(259454601928899863.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\6298\7DDA\5716')
,p_lov_return_value=>'line'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=4900:740:&SESSION.:::740:P710_CHART_TYPE:line"><img src="#IMAGE_PREFIX#ws/ws-line-chart.png" alt="#DISPLAY_VALUE#" width="128" height="'
||'128" /></a></td><td>&nbsp;</td></tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(169740222151305876.4907)
,p_lov_name=>'COLUMN GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select NAME display_value, ID return_value ',
'from WWV_FLOW_WORKSHEET_COL_GROUPS',
'where worksheet_id = :p2_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_label_returning_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157556708734983770.4907)
,p_lov_name=>'COLUMN LABEL RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select COLUMN_LABEL display_value, ID return_value ',
'from WWV_FLOW_WORKSHEET_COLUMNS',
'where worksheet_id = :p2_id',
'order by DISPLAY_ORDER, upper(column_label)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_filter_operators
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(178773405987392681.4907)
,p_lov_name=>'COLUMN_FILTER_OPERATORS'
,p_lov_query=>'.'||wwv_flow_api.id(178773405987392681.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178773624786392683.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178773816619392689.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774029915392689.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774203147392689.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'>='
,p_lov_return_value=>'>='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774404844392689.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774611401392689.4907)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'<='
,p_lov_return_value=>'<='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178774803359392690.4907)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\662F\7A7A\503C')
,p_lov_return_value=>'is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775031923392690.4907)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\4E0D\662F\7A7A\503C')
,p_lov_return_value=>'is not null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775213763392690.4907)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\540C\65BC')
,p_lov_return_value=>'like'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775414742392690.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E0D\540C\65BC')
,p_lov_return_value=>'not like'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775626341392690.4907)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\5728')
,p_lov_return_value=>'in'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178775816853392690.4907)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\4E0D\5728')
,p_lov_return_value=>'not in'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178776030779392690.4907)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\5305\542B')
,p_lov_return_value=>'contains'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178776226760392690.4907)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\4E0D\5305\542B')
,p_lov_return_value=>'does not contain'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178776415143392690.4907)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'regexp_like'
,p_lov_return_value=>'regexp_like'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178778229882399595.4907)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\4ECB\65BC')
,p_lov_return_value=>'between'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178779911313403739.4907)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\5728\524D')
,p_lov_return_value=>'is in the last'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178780215815404960.4907)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\4E0D\5728\524D')
,p_lov_return_value=>'is not in the last'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178780518932405861.4907)
,p_lov_disp_sequence=>28
,p_lov_disp_value=>unistr('\5728\5F8C')
,p_lov_return_value=>'is in the next'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178780722741406996.4907)
,p_lov_disp_sequence=>38
,p_lov_disp_value=>unistr('\4E0D\5728\5F8C')
,p_lov_return_value=>'is not in the next'
);
end;
/
prompt --application/shared_components/user_interface/lovs/comparison_expressions
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157548605355963845.4907)
,p_lov_name=>'COMPARISON EXPRESSIONS'
,p_lov_query=>'.'||wwv_flow_api.id(157548605355963845.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157548815917963845.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549008133963845.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177923106066093754.4907)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'>='
,p_lov_return_value=>'>='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549227534963845.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177923812646095626.4907)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>'<='
,p_lov_return_value=>'<='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549604153963845.4907)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\540C\65BC')
,p_lov_return_value=>'LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(179793328389112795.4907)
,p_lov_disp_sequence=>51
,p_lov_disp_value=>unistr('\4E0D\540C\65BC')
,p_lov_return_value=>'not like '
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(157549823989963846.4907)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6035512141000243.4907)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\662F\7A7A\503C')
,p_lov_return_value=>'is null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6035915258001184.4907)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\4E0D\662F\7A7A\503C')
,p_lov_return_value=>'is not null'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24709324557666429.4907)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>unistr('\5728')
,p_lov_return_value=>'in'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24709626635667023.4907)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>unistr('\4E0D\5728')
,p_lov_return_value=>'not in'
);
end;
/
prompt --application/shared_components/user_interface/lovs/component_level
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(455012825948829772.4907)
,p_lov_name=>'COMPONENT_LEVEL'
,p_lov_query=>'.'||wwv_flow_api.id(455012825948829772.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(455013000682829776.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9801\9762')
,p_lov_return_value=>'WEBPAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(455013212503829779.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8CC7\6599\5217')
,p_lov_return_value=>'ROW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/control_break_groups
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(22978927746952171.4907)
,p_lov_name=>'CONTROL BREAK GROUPS'
,p_lov_query=>'.'||wwv_flow_api.id(22978927746952171.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22979110471952172.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709\63A7\5236\5206\6BB5\7FA4\7D44')
,p_lov_return_value=>'ALL_GROUPS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22979300855952172.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E00\500B\63A7\5236\5206\6BB5\7FA4\7D44')
,p_lov_return_value=>'ONE_GROUP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_data_or_report
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(173236520362944199.4907)
,p_lov_name=>'CREATE DATA OR REPORT'
,p_lov_query=>'.'||wwv_flow_api.id(173236520362944199.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(173236715134944199.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8CC7\6599\65B9\683C')
,p_lov_return_value=>'DATA'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:205:&SESSION.:::205"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VAL'
||'UE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181301630402676517.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5831\8868')
,p_lov_return_value=>'REPORT'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:1310:&SESSION.:::1310,1320"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width="140" alt="#DISP'
||'LAY_VALUE#" class="htmldbGreenIcons" /></a></td><td>&nbsp;</td></tr></table>'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_security.current_user_is_not_reader',
'and wwv_flow_ws_security.sql_enabled(:WS_APP_ID)',
'and wwv_flow_ws_security.sql_enabled_inst()'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_text_section_method
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(18725515716010637.4907)
,p_lov_name=>'CREATE TEXT SECTION METHOD'
,p_lov_query=>'.'||wwv_flow_api.id(18725515716010637.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(18725807766010639.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5EFA\7ACB\55AE\4E00\6587\5B57\5340\6BB5')
,p_lov_return_value=>'NORMAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(18726004246010640.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5F9E\300C\8A66\7B97\8868\300D\5EFA\7ACB\591A\91CD\6587\5B57\5340\6BB5')
,p_lov_return_value=>'SPREADSHEET'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_worksheet_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(2960208403984068.4907)
,p_lov_name=>'CREATE WORKSHEET OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(2960208403984068.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2960523083984070.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5F9E\982D\958B\59CB')
,p_lov_return_value=>'SCRATCH'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:201:&SESSION.:::201,WS_WIZ_COLUMNS"><img src="#IMAGE_PREFIX#ws/ws-from-scratch.png" height="128" width="128" alt="#DISPLAY_VAL'
||'UE#" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(2960708902984070.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8907\88FD\4E26\8CBC\4E0A')
,p_lov_return_value=>'CUTANDPASTE'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:206:&SESSION.:::206,CLOB_CONTENT,RP"><img src="#IMAGE_PREFIX#ws/ws-copy-paste.png" height="128" width="128" alt="#DISPLAY_VALU'
||'E#" /></a></td><td>&nbsp;</td></tr></table>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_ws_auth_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174618728240220381.4907)
,p_lov_name=>'CREATE_WS_AUTH_OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  :product_name||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/admin_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d ,''HTML DB'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/opendoor_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DATABASE'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/dbauth_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DBACCOUNT'' v from dual)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_grid
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(179694201378826303.4907)
,p_lov_name=>'DATA GRID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''DATA'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_section_style
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(746262913082105905.4907)
,p_lov_name=>'DATA SECTION STYLE'
,p_lov_query=>'.'||wwv_flow_api.id(746262913082105905.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(746263201593105907.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A23\5F0F 1')
,p_lov_return_value=>'1'
,p_lov_template=>'<img src="#IMAGE_PREFIX#ws/report_style_1.gif" height="48" width="128" alt="#DISPLAY_VALUE#" class="radioGroupImage"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(746263432526105909.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6A23\5F0F 2')
,p_lov_return_value=>'2'
,p_lov_template=>'<img src="#IMAGE_PREFIX#ws/report_style_2.gif" height="48" width="128" alt="#DISPLAY_VALUE#" class="radioGroupImage"/>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(746263605381105909.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6A23\5F0F 3')
,p_lov_return_value=>'3'
,p_lov_template=>'<img src="#IMAGE_PREFIX#ws/report_style_3.gif" height="48" width="128" alt="#DISPLAY_VALUE#" class="radioGroupImage"/>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_grid_returning_worksheet_id
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(745648018052041064.4907)
,p_lov_name=>'DATA_GRID_RETURNING_WORKSHEET_ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.websheet_name d, w.id r',
'from wwv_flow_ws_websheet_attr a, wwv_flow_worksheets w',
'where a.worksheet_id = w.id',
'and a.ws_app_id = :ws_app_id',
'and a.security_group_id = :flow_security_group_id',
'and a.websheet_type = ''DATA'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_with_user_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(497241820310060978.4907)
,p_lov_name=>'DATA_WITH_USER_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ws.websheet_name d, ws.websheet_name r',
'from wwv_flow_worksheets i,',
'wwv_flow_worksheet_rpts r,',
'wwv_flow_ws_applications a,',
'wwv_flow_ws_websheet_attr ws',
'where a.id = ws.ws_app_id',
'and ws.worksheet_id = i.id',
'and r.worksheet_id = i.id',
'and r.websheet_id is not null',
'and r.security_group_id = :flow_security_group_id',
'and a.id = :ws_app_id',
'and r.application_user = :app_user',
'and r.session_id is null',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/date_format_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(460140315153255042.4907)
,p_lov_name=>'DATE_FORMAT_LOV'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'  from wwv_flow_format_masks',
' where t=''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_rows
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161072331491917913.4907)
,p_lov_name=>'DISPLAY ROWS'
,p_lov_query=>'.'||wwv_flow_api.id(161072331491917913.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161075705996920049.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161076108073920614.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161072510215917914.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161072713820917914.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161072930490917914.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073118910917914.4907)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073314283917914.4907)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073520539917914.4907)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073726945917914.4907)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161073905737917914.4907)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'200'
,p_lov_return_value=>'200'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161074106700917914.4907)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161074329336917914.4907)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161074529716917914.4907)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177272802329654940.4907)
,p_lov_disp_sequence=>9999
,p_lov_disp_value=>unistr('\5168\90E8')
,p_lov_return_value=>'100000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/expression_types_column_value
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(175787711198660520.4907)
,p_lov_name=>'EXPRESSION TYPES (COLUMN/VALUE)'
,p_lov_query=>'.'||wwv_flow_api.id(175787711198660520.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175788023327660521.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\503C')
,p_lov_return_value=>'VALUE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(175788232491660521.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8CC7\6599\6B04')
,p_lov_return_value=>'COLUMN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_component
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(945870019196474793.4907)
,p_lov_name=>'FEEDBACK_COMPONENT'
,p_lov_query=>'.'||wwv_flow_api.id(945870019196474793.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870326932474795.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8CC7\6599\65B9\683C')
,p_lov_return_value=>'Datagrid'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870517003474796.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\9801\9762')
,p_lov_return_value=>'Page'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870730487474797.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5B58\53D6\63A7\5236')
,p_lov_return_value=>'Access Control'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945870930916474797.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5831\8868')
,p_lov_return_value=>'Report'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945871101913474797.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\6A19\8A18\8A9E\6CD5')
,p_lov_return_value=>'Markup Syntax'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(945871316354474797.4907)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\5176\4ED6')
,p_lov_return_value=>'Other'
);
end;
/
prompt --application/shared_components/user_interface/lovs/first_row_contains_column_headings
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(799517811838484369.4907)
,p_lov_name=>'FIRST_ROW_CONTAINS_COLUMN_HEADINGS'
,p_lov_query=>'.'||wwv_flow_api.id(799517811838484369.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(799518019833484371.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7B2C\4E00\500B\8CC7\6599\5217\542B\6709\8CC7\6599\6B04\6A19\984C')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187514328189059218.4907)
,p_lov_name=>'FORMAT MASK DYNAMIC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'from wwv_flow_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hr_column_names
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(162817307492916433.4907)
,p_lov_name=>'HR COLUMN NAMES'
,p_lov_query=>'.'||wwv_flow_api.id(162817307492916433.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162817620426916433.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\540D\5B57')
,p_lov_return_value=>'FIRST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162817815634916433.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\59D3\6C0F')
,p_lov_return_value=>'LAST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162818030292916433.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5168\540D')
,p_lov_return_value=>'FULL_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(162818210247916433.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\96FB\5B50\90F5\4EF6\5730\5740')
,p_lov_return_value=>'EMAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hr_column_names_for_seeding
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(166804518636616614.4907)
,p_lov_name=>'HR COLUMN NAMES (FOR SEEDING)'
,p_lov_query=>'.'||wwv_flow_api.id(166804518636616614.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166804814185616615.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\540D\5B57')
,p_lov_return_value=>'FIRST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166805014333616615.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\59D3\6C0F')
,p_lov_return_value=>'LAST_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166805200851616615.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\96FB\5B50\90F5\4EF6\5730\5740')
,p_lov_return_value=>'EMAIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166805429286616615.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6B63\89E3\540D\7A31')
,p_lov_return_value=>'FORWARD_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166807720152626504.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\53CD\89E3\540D\7A31')
,p_lov_return_value=>'REVERSE_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166808026385628340.4907)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'GUID'
,p_lov_return_value=>'USERID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166808400544630345.4907)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\9078\64C7\6027\6A19\984C')
,p_lov_return_value=>'TITLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166808808855632713.4907)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\6210\672C\4E2D\5FC3')
,p_lov_return_value=>'COST_CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166809111972633632.4907)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\7D44\7E54')
,p_lov_return_value=>'ORGANIZATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166809515781634745.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\516C\53F8\96FB\8A71\865F\78BC')
,p_lov_return_value=>'WORK_PHONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166809820629636090.4907)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\516C\53F8\6240\5728\5927\6A13')
,p_lov_return_value=>'WORK_BUILDING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166810125131637429.4907)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\516C\53F8\6240\5728\6A13\5C64')
,p_lov_return_value=>'WORK_FLOOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166810430672639004.4907)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>unistr('\516C\53F8\9580\724C\865F\78BC')
,p_lov_return_value=>'WORK_OFFICE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166810803099640515.4907)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>unistr('\516C\53F8\5730\5740')
,p_lov_return_value=>'WORK_ADDR1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166811408293641989.4907)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>unistr('\516C\53F8\6240\5728\57CE\5E02')
,p_lov_return_value=>'WORK_CITY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166812011410642946.4907)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>unistr('\516C\53F8\6240\5728\7701/\5E02')
,p_lov_return_value=>'WORK_STATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166812416605644416.4907)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>unistr('\516C\53F8\6240\5728\90F5\905E\5340\865F')
,p_lov_return_value=>'WORK_ZIP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166812722492646170.4907)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>unistr('\516C\53F8\6240\5728\570B\5BB6')
,p_lov_return_value=>'WORK_COUNTRY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166813328033647779.4907)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>unistr('\4E0B\5C6C')
,p_lov_return_value=>'DIRECTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166813732188648908.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E0B\5C6C\7E3D\6578')
,p_lov_return_value=>'TOTAL_REPORTS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(166814003230649994.4907)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>unistr('\662F\4E3B\7BA1?')
,p_lov_return_value=>'IS_MANAGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_languages_locales
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(502587106305037128.4907)
,p_lov_name=>'I18N_LANGUAGES_LOCALES'
,p_reference_id=>107899321117195063.4907
,p_lov_query=>'.'||wwv_flow_api.id(502587106305037128.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699077671048180068.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E9E\585E\62DC\7136\6587 (az)')
,p_lov_return_value=>'az'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699078037978180068.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5357\975E\8377\862D\6587 (af)')
,p_lov_return_value=>'af'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699078405074180068.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (ar)')
,p_lov_return_value=>'ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699078828289180068.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\963F\723E\53CA\5229\4E9E) (ar-dz)')
,p_lov_return_value=>'ar-dz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699079234537180069.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\5DF4\6797) (ar-bh)')
,p_lov_return_value=>'ar-bh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699079606258180069.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\57C3\53CA) (ar-eg)')
,p_lov_return_value=>'ar-eg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699080050912180069.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\4F0A\62C9\514B) (ar-iq)')
,p_lov_return_value=>'ar-iq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699080454215180069.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\7D04\65E6) (ar-jo)')
,p_lov_return_value=>'ar-jo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699080864791180070.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\79D1\5A01\7279) (ar-kw)')
,p_lov_return_value=>'ar-kw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699081255911180070.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\9ECE\5DF4\5AE9) (ar-lb)')
,p_lov_return_value=>'ar-lb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699081603517180070.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\5229\6BD4\4E9E) (ar-ly)')
,p_lov_return_value=>'ar-ly'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699082008415180070.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\6469\6D1B\54E5) (ar-ma)')
,p_lov_return_value=>'ar-ma'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699082459066180070.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\963F\66FC) (ar-om)')
,p_lov_return_value=>'ar-om'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699082811282180071.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\5361\9054) (ar-qa)')
,p_lov_return_value=>'ar-qa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699083231940180071.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\6C99\70CF\5730\963F\62C9\4F2F) (ar-sa)')
,p_lov_return_value=>'ar-sa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699083518057180071.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\6558\5229\4E9E) (ar-sy)')
,p_lov_return_value=>'ar-sy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699083935661180071.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\7A81\5C3C\897F\4E9E) (ar-tn)')
,p_lov_return_value=>'ar-tn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699084301028180072.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\963F\62C9\4F2F\806F\5408\5927\516C\570B) (ar-ae)')
,p_lov_return_value=>'ar-ae'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699084726592180072.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\6587 (\8449\9580) (ar-ye)')
,p_lov_return_value=>'ar-ye'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699085149541180072.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\85A9\59C6\6587 (as)')
,p_lov_return_value=>'as'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699085551541180073.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5DF4\65AF\514B\6587 (eu)')
,p_lov_return_value=>'eu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699085941439180073.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\767D\4FC4\7F85\65AF\6587 (be)')
,p_lov_return_value=>'be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699086317208180073.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5B5F\52A0\62C9\6587 (bn)')
,p_lov_return_value=>'bn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699086722772180073.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FDD\52A0\5229\4E9E\6587 (bg)')
,p_lov_return_value=>'bg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699087134419180073.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\52A0\6CF0\7F85\5C3C\4E9E\6587 (ca)')
,p_lov_return_value=>'ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699087520210180074.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (zh)')
,p_lov_return_value=>'zh'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699087954139180074.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\4E2D\570B) (zh-cn)')
,p_lov_return_value=>'zh-cn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699088321602180074.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\9999\6E2F\7279\5225\884C\653F\5340) (zh-hk)')
,p_lov_return_value=>'zh-hk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699088718989180074.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\6FB3\9580\7279\5225\884C\653F\5340) (zh-mo)')
,p_lov_return_value=>'zh-mo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699089197590180075.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\65B0\52A0\5761) (zh-sg)')
,p_lov_return_value=>'zh-sg'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699089584303180075.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\53F0\7063) (zh-tw)')
,p_lov_return_value=>'zh-tw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699089965064180075.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\514B\7F85\57C3\897F\4E9E\6587 (hr)')
,p_lov_return_value=>'hr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699090330404180075.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6377\514B\6587 (cs)')
,p_lov_return_value=>'cs'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699090719346180076.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E39\9EA5\6587 (da)')
,p_lov_return_value=>'da'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699091122669180076.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8377\862D\6587 (\6BD4\5229\6642) (nl-be)')
,p_lov_return_value=>'nl-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699091589403180076.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8377\862D\6587 (\8377\862D) (nl)')
,p_lov_return_value=>'nl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699091971660180076.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (en)')
,p_lov_return_value=>'en'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699092358936180076.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\6FB3\5927\5229\4E9E) (en-au)')
,p_lov_return_value=>'en-au'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699092773809180077.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\8C9D\91CC\65AF) (en-bz)')
,p_lov_return_value=>'en-bz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699093124993180077.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\52A0\62FF\5927) (en-ca)')
,p_lov_return_value=>'en-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699093521574180077.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\611B\723E\862D) (en-ie)')
,p_lov_return_value=>'en-ie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699093981695180077.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\7259\8CB7\52A0) (en-jm)')
,p_lov_return_value=>'en-jm'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699094398450180078.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\7D10\897F\862D) (en-nz)')
,p_lov_return_value=>'en-nz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699094718902180078.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\83F2\5F8B\8CD3) (en-ph)')
,p_lov_return_value=>'en-ph'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699095171931180078.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\5357\975E) (en-za)')
,p_lov_return_value=>'en-za'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699095556248180078.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\5343\91CC\9054) (en-tt)')
,p_lov_return_value=>'en-tt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699095900882180078.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\82F1\570B) (en-gb)')
,p_lov_return_value=>'en-gb'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699096397022180079.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\7F8E\570B) (en-us)')
,p_lov_return_value=>'en-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699096756533180079.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587 (\8F9B\5DF4\5A01) (en-zw)')
,p_lov_return_value=>'en-zw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699097111707180079.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\611B\6C99\5C3C\4E9E\6587 (et)')
,p_lov_return_value=>'et'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699097569130180079.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('FYRO \99AC\5176\9813\6587 (mk)')
,p_lov_return_value=>'mk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699097901194180080.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\7F85\6587 (fo)')
,p_lov_return_value=>'fo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699098392128180080.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CE2\65AF\6587 (fa)')
,p_lov_return_value=>'fa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699098761314180080.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\745E\58EB) (fr-ch)')
,p_lov_return_value=>'fr-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699099157140180080.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82AC\862D\6587 (fi)')
,p_lov_return_value=>'fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699099528056180081.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\6BD4\5229\6642) (fr-be)')
,p_lov_return_value=>'fr-be'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699099985670180081.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\52A0\62FF\5927) (fr-ca)')
,p_lov_return_value=>'fr-ca'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699100362011180081.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\6CD5\570B) (fr)')
,p_lov_return_value=>'fr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699100749619180081.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\76E7\68EE\5821) (fr-lu)')
,p_lov_return_value=>'fr-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699101188548180082.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587 (\6469\7D0D\54E5) (fr-mc)')
,p_lov_return_value=>'fr-mc'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699101509999180082.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\84CB\723E\6587 (gd)')
,p_lov_return_value=>'gd'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699101965546180082.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\52A0\91CC\65AF\4E9E\6587 (gl)')
,p_lov_return_value=>'gl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699102367955180082.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\5967\5730\5229) (de-at)')
,p_lov_return_value=>'de-at'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699102767340180083.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\5FB7\570B) (de)')
,p_lov_return_value=>'de'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699103114120180083.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\5217\652F\6566\65AF\767B) (de-li)')
,p_lov_return_value=>'de-li'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699103543063180083.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\76E7\68EE\5821) (de-lu)')
,p_lov_return_value=>'de-lu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699103949411180083.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587 (\745E\58EB) (de-ch)')
,p_lov_return_value=>'de-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699104368944180083.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5E0C\81D8\6587 (el)')
,p_lov_return_value=>'el'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699104710217180084.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\53E4\5409\62C9\7279\6587 (gu)')
,p_lov_return_value=>'gu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699105112508180084.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5E0C\4F2F\4F86\6587 (he)')
,p_lov_return_value=>'he'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699105550789180084.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5370\5EA6\6587 (hi)')
,p_lov_return_value=>'hi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699105901185180085.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5308\7259\5229\6587 (hu)')
,p_lov_return_value=>'hu'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699106301886180085.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\51B0\5CF6\6587 (is)')
,p_lov_return_value=>'is'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699106757512180085.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5370\5C3C\6587 (id)')
,p_lov_return_value=>'id'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699107115109180085.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7FA9\5927\5229\6587 (\7FA9\5927\5229) (it)')
,p_lov_return_value=>'it'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699107521210180086.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7FA9\5927\5229\6587 (\745E\58EB) (it-ch)')
,p_lov_return_value=>'it-ch'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699107936215180086.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65E5\6587 (ja)')
,p_lov_return_value=>'ja'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699108362538180086.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\574E\90A3\9054\6587 (kn)')
,p_lov_return_value=>'kn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699108709201180086.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\54C8\85A9\514B\6587 (kk)')
,p_lov_return_value=>'kk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699109156123180086.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\574E\52A0\5C3C\6587 (kok)')
,p_lov_return_value=>'kok'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699109579709180087.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\97D3\6587 (ko)')
,p_lov_return_value=>'ko'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699109999363180087.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5409\723E\5409\65AF\6587 (kz)')
,p_lov_return_value=>'kz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699110323574180087.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\62C9\812B\7DAD\4E9E\6587 (lv)')
,p_lov_return_value=>'lv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699110750109180087.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7ACB\9676\5B9B\6587 (lt)')
,p_lov_return_value=>'lt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699111197428180088.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\4F86\6587 (\99AC\4F86\897F\4E9E) (ms)')
,p_lov_return_value=>'ms'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699111558985180088.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\4F86\4E9E\62C9\59C6\6587 (ml)')
,p_lov_return_value=>'ml'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699111988302180088.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\8033\5B83\6587 (mt)')
,p_lov_return_value=>'mt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699112318794180088.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\62C9\5730\6587 (mr)')
,p_lov_return_value=>'mr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699112751141180088.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5C3C\5E15\91CC\6587 (\5370\5EA6) (ne)')
,p_lov_return_value=>'ne'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699113167827180089.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\632A\5A01\6587 (\5DF4\514B\6469) (nb-no)')
,p_lov_return_value=>'nb-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699113521452180089.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\632A\5A01\6587 (\5DF4\514B\6469) (no)')
,p_lov_return_value=>'no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699113935508180089.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\632A\5A01\6587 (\5C3C\6D1B\65AF\514B) (nn-no)')
,p_lov_return_value=>'nn-no'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699114353177180089.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6B50\91CC\4E9E\6587 (or)')
,p_lov_return_value=>'or'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699114731122180089.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CE2\862D\6587 (pl)')
,p_lov_return_value=>'pl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699115176842180090.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8461\8404\7259\6587 (\5DF4\897F) (pt-br)')
,p_lov_return_value=>'pt-br'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699115528210180090.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8461\8404\7259\6587 (\8461\8404\7259) (pt)')
,p_lov_return_value=>'pt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699115900344180090.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65C1\906E\666E\6587 (pa)')
,p_lov_return_value=>'pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699116347937180090.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7F85\99AC\5C3C\4E9E\6587 (ro)')
,p_lov_return_value=>'ro'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699116720955180091.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FC4\6587 (ru)')
,p_lov_return_value=>'ru'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699117177554180091.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FC4\6587 (\6469\723E\591A\74E6) (ru-md)')
,p_lov_return_value=>'ru-md'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699117577240180091.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\585E\723E\7DAD\4E9E\6587 (sr)')
,p_lov_return_value=>'sr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699117988910180091.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65AF\6D1B\4F10\514B\6587 (sk)')
,p_lov_return_value=>'sk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699118314040180091.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65AF\6D1B\7DAD\5C3C\4E9E\6587 (sl)')
,p_lov_return_value=>'sl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699118753922180092.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\963F\6839\5EF7) (es-ar)')
,p_lov_return_value=>'es-ar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699119188393180092.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\73BB\5229\7DAD\4E9E) (es-bo)')
,p_lov_return_value=>'es-bo'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699119581631180092.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\667A\5229) (es-cl)')
,p_lov_return_value=>'es-cl'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699119997191180092.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\54E5\502B\6BD4\4E9E) (es-co)')
,p_lov_return_value=>'es-co'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699120318838180092.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\54E5\65AF\5927\9ECE\52A0) (es-cr)')
,p_lov_return_value=>'es-cr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699120709109180093.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\591A\660E\5C3C\52A0) (es-do)')
,p_lov_return_value=>'es-do'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699121134727180093.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5384\74DC\591A) (es-ec)')
,p_lov_return_value=>'es-ec'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699121568485180093.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\85A9\723E\74E6\591A) (es-sv)')
,p_lov_return_value=>'es-sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699121921139180093.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\74DC\5730\99AC\62C9) (es-gt)')
,p_lov_return_value=>'es-gt'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699122338312180094.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5B8F\90FD\62C9\65AF) (es-hn)')
,p_lov_return_value=>'es-hn'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699122706175180094.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\58A8\897F\54E5) (es-mx)')
,p_lov_return_value=>'es-mx'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699123193173180094.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5C3C\52A0\62C9\74DC) (es-ni)')
,p_lov_return_value=>'es-ni'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699123576249180094.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5DF4\62FF\99AC) (es-pa)')
,p_lov_return_value=>'es-pa'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699123952759180094.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\5DF4\62C9\572D) (es-py)')
,p_lov_return_value=>'es-py'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699124377656180095.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\7955\9B6F) (es-pe)')
,p_lov_return_value=>'es-pe'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699124748226180095.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\6CE2\591A\9ECE\5404) (es-pr)')
,p_lov_return_value=>'es-pr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699125127369180095.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\50B3\7D71\6392\5E8F) (es)')
,p_lov_return_value=>'es'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699125511532180095.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\7F8E\570B) (es-us)')
,p_lov_return_value=>'es-us'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699125971306180096.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\70CF\62C9\572D) (es-uy)')
,p_lov_return_value=>'es-uy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699126309761180096.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587 (\59D4\5167\745E\62C9) (es-ve)')
,p_lov_return_value=>'es-ve'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699126741047180096.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\745E\5178\6587 (sv)')
,p_lov_return_value=>'sv'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699127176377180096.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\745E\5178\6587 (\82AC\862D) (sv-fi)')
,p_lov_return_value=>'sv-fi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699127597883180096.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5766\7C73\723E\6587 (ta)')
,p_lov_return_value=>'ta'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699127927061180097.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CF0\76E7\56FA\6587 (te)')
,p_lov_return_value=>'te'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699128382178180097.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CF0\6587 (th)')
,p_lov_return_value=>'th'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699128731024180097.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\571F\8033\5176\6587 (tr)')
,p_lov_return_value=>'tr'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699129157411180097.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\514B\862D\6587 (uk)')
,p_lov_return_value=>'uk'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699129585255180098.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\723E\90FD\6587 (ur)')
,p_lov_return_value=>'ur'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699129971575180098.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\8332\5225\514B\6587 (uz)')
,p_lov_return_value=>'uz'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699130356540180098.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8D8A\5357\6587 (vi)')
,p_lov_return_value=>'vi'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699130787098180098.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\611B\723E\862D\6587 (ga)')
,p_lov_return_value=>'ga'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699131129792180100.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5A01\723E\65AF\6587 (cy)')
,p_lov_return_value=>'cy'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699131522308180101.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\53F2\74E6\5E0C\91CC\6587 (sw)')
,p_lov_return_value=>'sw'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699131990424180101.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\723E\5DF4\5C3C\4E9E\6587')
,p_lov_return_value=>'sq'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(699132366271180101.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E9E\7F8E\5C3C\4E9E\6587')
,p_lov_return_value=>'hy'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_territories
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(634728210841234369.4907)
,p_lov_name=>'I18N_TERRITORIES'
,p_reference_id=>634612723768159258.4907
,p_lov_query=>'.'||wwv_flow_api.id(634728210841234369.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62768512046442477.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E9E\585E\62DC\7136')
,p_lov_return_value=>'AZERBAIJAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62768930505442477.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\723E\53CA\5229\4E9E')
,p_lov_return_value=>'ALGERIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62769309199442477.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7F8E\570B')
,p_lov_return_value=>'AMERICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62769770701442478.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\6839\5EF7')
,p_lov_return_value=>'ARGENTINA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62770125083442478.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6FB3\5927\5229\4E9E')
,p_lov_return_value=>'AUSTRALIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62770576591442478.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5967\5730\5229')
,p_lov_return_value=>'AUSTRIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62770950179442478.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5DF4\6797')
,p_lov_return_value=>'BAHRAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62771329653442479.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5B5F\52A0\62C9')
,p_lov_return_value=>'BANGLADESH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62771751169442479.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6BD4\5229\6642')
,p_lov_return_value=>'BELGIUM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62772126105442479.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5DF4\897F')
,p_lov_return_value=>'BRAZIL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62772555136442479.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FDD\52A0\5229\4E9E')
,p_lov_return_value=>'BULGARIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62772924789442480.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\52A0\62FF\5927')
,p_lov_return_value=>'CANADA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62773397498442480.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\52A0\6CF0\9686\5C3C\4E9E')
,p_lov_return_value=>'CATALONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62773715833442480.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\667A\5229')
,p_lov_return_value=>'CHILE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62774123927442480.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\570B')
,p_lov_return_value=>'CHINA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62774562332442481.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\54E5\502B\6BD4\4E9E')
,p_lov_return_value=>'COLOMBIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62774972634442481.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\54E5\65AF\5927\9ECE\52A0')
,p_lov_return_value=>'COSTA RICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62775351297442481.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\514B\7F85\57C3\897F\4E9E')
,p_lov_return_value=>'CROATIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62775747407442481.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6377\514B\5171\548C\570B')
,p_lov_return_value=>'CZECH REPUBLIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62776195701442481.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E39\9EA5')
,p_lov_return_value=>'DENMARK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62776502463442482.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5384\74DC\591A')
,p_lov_return_value=>'ECUADOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62776904673442482.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\57C3\53CA')
,p_lov_return_value=>'EGYPT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62777371218442482.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\85A9\723E\74E6\591A')
,p_lov_return_value=>'EL SALVADOR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62777721576442482.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\611B\6C99\5C3C\4E9E')
,p_lov_return_value=>'ESTONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62778182718442483.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82AC\862D')
,p_lov_return_value=>'FINLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62778552942442483.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\570B')
,p_lov_return_value=>'FRANCE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62778904538442483.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\5176\9813')
,p_lov_return_value=>'FYR MACEDONIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62779355380442483.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\570B')
,p_lov_return_value=>'GERMANY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62779707068442484.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5E0C\81D8')
,p_lov_return_value=>'GREECE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62780191281442484.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\74DC\5730\99AC\62C9')
,p_lov_return_value=>'GUATEMALA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62780570482442484.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9999\6E2F\7279\5225\884C\653F\5340')
,p_lov_return_value=>'HONG KONG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62780972409442484.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5308\7259\5229')
,p_lov_return_value=>'HUNGARY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62781310225442485.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\51B0\5CF6')
,p_lov_return_value=>'ICELAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62781759163442485.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5370\5EA6')
,p_lov_return_value=>'INDIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62782151355442485.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5370\5C3C')
,p_lov_return_value=>'INDONESIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62782519713442486.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4F0A\62C9\514B')
,p_lov_return_value=>'IRAQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62782982144442486.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\611B\723E\862D')
,p_lov_return_value=>'IRELAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62783350927442486.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4EE5\8272\5217')
,p_lov_return_value=>'ISRAEL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62783797822442486.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7FA9\5927\5229')
,p_lov_return_value=>'ITALY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62784141001442486.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65E5\672C')
,p_lov_return_value=>'JAPAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62784519265442487.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7D04\65E6')
,p_lov_return_value=>'JORDAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62784913226442487.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\54C8\85A9\514B')
,p_lov_return_value=>'KAZAKHSTAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62785308333442487.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\97D3\570B')
,p_lov_return_value=>'KOREA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62785717099442487.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\79D1\5A01\7279')
,p_lov_return_value=>'KUWAIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62786101932442488.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\62C9\812B\7DAD\4E9E')
,p_lov_return_value=>'LATVIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62786558628442488.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9ECE\5DF4\5AE9')
,p_lov_return_value=>'LEBANON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62786952129442488.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5229\6BD4\4E9E')
,p_lov_return_value=>'LIBYA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62787323890442488.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7ACB\9676\5B9B')
,p_lov_return_value=>'LITHUANIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62787782538442489.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\76E7\68EE\5821')
,p_lov_return_value=>'LUXEMBOURG'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62788182614442489.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\99AC\4F86\897F\4E9E')
,p_lov_return_value=>'MALAYSIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62788528479442489.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\58A8\897F\54E5')
,p_lov_return_value=>'MEXICO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62788997279442490.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6469\6D1B\54E5')
,p_lov_return_value=>'MOROCCO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62789325661442490.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7D10\897F\862D')
,p_lov_return_value=>'NEW ZEALAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62789782549442490.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5C3C\52A0\62C9\74DC')
,p_lov_return_value=>'NICARAGUA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62790133238442490.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\632A\5A01')
,p_lov_return_value=>'NORWAY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62790562008442491.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\66FC')
,p_lov_return_value=>'OMAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62790923765442491.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5DF4\62FF\99AC')
,p_lov_return_value=>'PANAMA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62791326115442491.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\79D8\9B6F')
,p_lov_return_value=>'PERU'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62791722352442491.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\83F2\5F8B\8CD3')
,p_lov_return_value=>'PHILIPPINES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62792127389442492.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CE2\862D')
,p_lov_return_value=>'POLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62792532827442492.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8461\8404\7259')
,p_lov_return_value=>'PORTUGAL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62792943133442492.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CE2\591A\9ECE\5404')
,p_lov_return_value=>'PUERTO RICO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62793345569442492.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5361\9054')
,p_lov_return_value=>'QATAR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62793726564442493.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7F85\99AC\5C3C\4E9E')
,p_lov_return_value=>'ROMANIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62794173620442493.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4FC4\7F85\65AF')
,p_lov_return_value=>'RUSSIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62794528506442493.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6C99\70CF\5730\963F\62C9\4F2F')
,p_lov_return_value=>'SAUDI ARABIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62794957133442493.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\585E\723E\7DAD\4E9E\548C\8292\7279\5C3C\683C\7F85')
,p_lov_return_value=>'SERBIA AND MONTENEGRO'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62795307781442494.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65B0\52A0\5761')
,p_lov_return_value=>'SINGAPORE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62795777034442494.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65AF\6D1B\4F10\514B')
,p_lov_return_value=>'SLOVAKIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62796162893442494.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65AF\6D1B\7DAD\5C3C\4E9E')
,p_lov_return_value=>'SLOVENIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62796548292442494.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5357\975E')
,p_lov_return_value=>'SOUTH AFRICA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62796908133442495.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259')
,p_lov_return_value=>'SPAIN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62797382995442495.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\745E\5178')
,p_lov_return_value=>'SWEDEN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62797757964442495.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\745E\58EB')
,p_lov_return_value=>'SWITZERLAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62798128335442495.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6558\5229\4E9E')
,p_lov_return_value=>'SYRIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62798526167442495.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\53F0\7063')
,p_lov_return_value=>'TAIWAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62798964210442496.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CF0\570B')
,p_lov_return_value=>'THAILAND'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62799338177442496.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8377\862D')
,p_lov_return_value=>'THE NETHERLANDS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62799783102442496.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7A81\5C3C\897F\4E9E')
,p_lov_return_value=>'TUNISIA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62800138392442496.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\571F\8033\5176')
,p_lov_return_value=>'TURKEY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62800521279442497.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\514B\862D')
,p_lov_return_value=>'UKRAINE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62800975328442497.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\963F\62C9\4F2F\806F\5408\5927\516C\570B')
,p_lov_return_value=>'UNITED ARAB EMIRATES'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62801343830442497.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\570B')
,p_lov_return_value=>'UNITED KINGDOM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62801707976442497.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\70CF\8332\5225\514B')
,p_lov_return_value=>'UZBEKISTAN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62802182931442498.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\59D4\5167\745E\62C9')
,p_lov_return_value=>'VENEZUELA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62802531981442498.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8D8A\5357')
,p_lov_return_value=>'VIETNAM'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(62802931670442498.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8449\9580')
,p_lov_return_value=>'YEMEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_clear_settings
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184141723318598286.4907)
,p_lov_name=>'IR_CLEAR_SETTINGS'
,p_lov_query=>'.'||wwv_flow_api.id(184141723318598286.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184141903129598286.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6E05\9664\5831\8868\8A2D\5B9A\503C')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_column_filter_lov
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187536631811296748.4907)
,p_lov_name=>'IR_COLUMN_FILTER_LOV'
,p_lov_query=>'.'||wwv_flow_api.id(187536631811296748.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187536803714296749.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7121')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187537027390296749.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6839\64DA\8CC7\6599\6B04\985E\578B\9810\8A2D')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187537221036296749.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\4F7F\7528\5B9A\7FA9\7684\503C\6E05\55AE\7BE9\9078\5B8C\5168\76F8\7B26\7684\9805\76EE')
,p_lov_return_value=>'S'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187537420494296749.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\4F7F\7528\5B9A\7FA9\7684\503C\6E05\55AE\7BE9\9078\5305\542B\7684\6587\5B57')
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_column_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187521603695108878.4907)
,p_lov_name=>'IR_COLUMN_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(187521603695108878.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(261252015294852290.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\96B1\85CF')
,p_lov_return_value=>'HIDE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187521815724108878.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6392\5E8F')
,p_lov_return_value=>'SORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522018417108878.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\7BE9\9078')
,p_lov_return_value=>'FILTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522228192108878.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\6A19\793A')
,p_lov_return_value=>'HIGHLIGHT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522424754108878.4907)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\63A7\5236\5206\6BB5')
,p_lov_return_value=>'BREAK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522603425108878.4907)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\805A\7E3D')
,p_lov_return_value=>'AGGREGATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187522808972108878.4907)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\904B\7B97')
,p_lov_return_value=>'COMPUTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187523010729108878.4907)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>unistr('\5716\8868')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187523228523108878.4907)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>unistr('\7FA4\7D44\4F9D\64DA')
,p_lov_return_value=>'GROUP_BY'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(3701401105670.4907)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>unistr('\6A1E\7D10\5206\6790\8868')
,p_lov_return_value=>'PIVOT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_detail_page_functionality
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184015632435758855.4907)
,p_lov_name=>'IR_DETAIL_PAGE_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_api.id(184015632435758855.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184015811357758856.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5141\8A31\6392\9664\7A7A\503C')
,p_lov_return_value=>'EXCLUDE_NULL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184016009426758856.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5141\8A31\986F\793A\7684\8CC7\6599\6B04')
,p_lov_return_value=>'HIDE_EXTR_COL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_display_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183810312847513834.4907)
,p_lov_name=>'IR_DISPLAY_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(183810312847513834.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183810509783513835.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6A19\6E96\5831\8868\8CC7\6599\6B04')
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183810717133513835.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\986F\793A\70BA\6587\5B57 (\9041\96E2\7279\6B8A\5B57\5143)')
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(450527627281054238.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\79FB\9664 HTML \4E26\9041\96E2\7279\6B8A\5B57\5143')
,p_lov_return_value=>'STRIP_HTML_ESCAPE_SC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183810915056513835.4907)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\96B1\85CF')
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_link_column
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184013026632738314.4907)
,p_lov_name=>'IR_LINK_COLUMN'
,p_lov_query=>'.'||wwv_flow_api.id(184013026632738314.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184013223015738314.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9023\7D50\81F3\55AE\4E00\8CC7\6599\5217\6AA2\8996')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184013402164738315.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\9023\7D50\81F3\81EA\8A02\76EE\6A19')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184013623895738315.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6392\9664\9023\7D50\8CC7\6599\6B04')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_link_operator
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184114411019556922.4907)
,p_lov_name=>'IR_LINK_OPERATOR'
,p_lov_query=>'.'||wwv_flow_api.id(184114411019556922.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184114626877556922.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7B49\65BC')
,p_lov_return_value=>'EQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184114812403556922.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\4E0D\7B49\65BC')
,p_lov_return_value=>'NEQ'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115009808556923.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5C0F\65BC')
,p_lov_return_value=>'LT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115216118556923.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5C0F\65BC\6216\7B49\65BC')
,p_lov_return_value=>'LTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115410372556923.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5927\65BC')
,p_lov_return_value=>'GT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115603175556923.4907)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\5927\65BC\6216\7B49\65BC')
,p_lov_return_value=>'GTE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184115811804556923.4907)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('SQL Like \904B\7B97\5B50')
,p_lov_return_value=>'LIKE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116014545556923.4907)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\7A7A\503C')
,p_lov_return_value=>'N'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116211240556923.4907)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\975E\7A7A\503C')
,p_lov_return_value=>'NN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116429729556923.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5305\542B')
,p_lov_return_value=>'C '
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116600682556923.4907)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>unistr('\4E0D\5305\542B')
,p_lov_return_value=>'NC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184116820056556923.4907)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>unistr('\8CC7\6599\5217\5305\542B')
,p_lov_return_value=>'IR_ROWFILTER '
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_interval
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(497258407132255912.4907)
,p_lov_name=>'IR_NOTIFY_INTERVAL'
,p_lov_query=>'.'||wwv_flow_api.id(497258407132255912.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(497258621830255914.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6BCF\65E5')
,p_lov_return_value=>'D'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(497258807889255918.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6BCF\9031')
,p_lov_return_value=>'W'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(497259008562255918.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6BCF\6708')
,p_lov_return_value=>'M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_pagination_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(183988226651539622.4907)
,p_lov_name=>'IR_PAGINATION_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(183988226651539622.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183988425548539651.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8CC7\6599\5217\7BC4\570D X \5230 Y, \5171 Z \500B')
,p_lov_return_value=>'ROWS_X_TO_Y_OF_Z'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(183988600836539651.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8CC7\6599\5217\7BC4\570D X \5230 Y')
,p_lov_return_value=>'ROWS_X_TO_Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_reports_in_current_app
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184030311010131156.4907)
,p_lov_name=>'IR_REPORTS_IN_CURRENT_APP'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :WS_APP_ID',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''REPORT''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_reset
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184090310224424164.4907)
,p_lov_name=>'IR_RESET'
,p_lov_query=>'.'||wwv_flow_api.id(184090310224424164.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184090518146424166.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\91CD\8A2D\5831\8868')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_rowid_or_cols
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184017715035772751.4907)
,p_lov_name=>'IR_ROWID_OR_COLS'
,p_lov_query=>'.'||wwv_flow_api.id(184017715035772751.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184017914148772751.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'ROWID'
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184018110509772751.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\552F\4E00\8CC7\6599\6B04')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_same_label_for_detail_view
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(187510818230037360.4907)
,p_lov_name=>'IR_SAME_LABEL_FOR_DETAIL_VIEW'
,p_lov_query=>'.'||wwv_flow_api.id(187510818230037360.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(187511006081037360.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5728\55AE\4E00\8CC7\6599\5217\6AA2\8996\4F7F\7528\76F8\540C\5167\5BB9')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/languages_installed
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(631691002719703351.4907)
,p_lov_name=>'LANGUAGES_INSTALLED'
,p_reference_id=>631619712812572565.4907
,p_lov_query=>'.'||wwv_flow_api.id(631691002719703351.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797110708703121637.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5FB7\6587')
,p_lov_return_value=>'de'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''de'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797110905024121637.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\82F1\6587')
,p_lov_return_value=>'en'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''zh-cn'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111115323121638.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\897F\73ED\7259\6587')
,p_lov_return_value=>'es'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''es'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111316804121638.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6CD5\6587')
,p_lov_return_value=>'fr'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''fr'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111505126121638.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7FA9\5927\5229\6587')
,p_lov_return_value=>'it'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''it'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111712120121638.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\65E5\6587')
,p_lov_return_value=>'ja'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''ja'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797111918483121638.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\97D3\6587')
,p_lov_return_value=>'ko'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''ko'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797112116588121638.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8461\8404\7259\6587 (\5DF4\897F)')
,p_lov_return_value=>'pt-br'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''pt-br'')         '))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797112313424121638.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\4E2D\570B)')
,p_lov_return_value=>'zh-cn'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''zh-cn'')'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(797112528313121640.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E2D\6587 (\53F0\7063)')
,p_lov_return_value=>'zh-tw'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = :APP_ID',
'       and translation_flow_language_code = ''zh-tw'')         '))
);
end;
/
prompt --application/shared_components/user_interface/lovs/language_derived_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(502656918406037207.4907)
,p_lov_name=>'LANGUAGE_DERIVED_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(502656918406037207.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(502657718966037208.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\61C9\7528\7A0B\5F0F\4E3B\8981\8A9E\8A00')
,p_lov_return_value=>'FLOW_PRIMARY_LANGUAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(502657317052037208.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\700F\89BD\5668 (\4F7F\7528\700F\89BD\5668\8A9E\8A00\504F\597D\8A2D\5B9A)')
,p_lov_return_value=>'BROWSER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_application_pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461381027000774471.4907)
,p_lov_name=>'LIST APPLICATION PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select substr(name,1,30) name , id',
'from wwv_flow_ws_webpages p',
'where  p.ws_app_id = :ws_app_id and security_group_id = :flow_security_group_id',
'order by name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/logo_attributes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461438607298231622.4907)
,p_lov_name=>'LOGO ATTRIBUTES'
,p_reference_id=>461376702019738964.4907
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLACK_TEXT'') d, ''style="font-family:Arial; color:#000000; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''BLUE_TEXT'') d, ''style="font-family:Arial; color:#004C66; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''WHITE_TEXT'') d, ''style="font-family:Arial; color:#FFFFFF; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual',
'union all',
'select wwv_flow_lang.system_message(''GRAY_TEXT'') d, ''style="font-family:Arial; color:#303030; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''image_attributes'') d, ''alt="Application" title="Application"'' r from dual '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(88891506202224413.4907)
,p_lov_name=>'LOV_FROM'
,p_lov_query=>'.'||wwv_flow_api.id(88891506202224413.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88892002310224415.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5171\7528\7684\503C\6E05\55AE')
,p_lov_return_value=>'SHARED'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88891803220224415.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4E0D\540C\7684\8CC7\6599\6B04\503C')
,p_lov_return_value=>'DISTINCT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(88938810600443285.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\65B0\5EFA')
,p_lov_return_value=>'CREATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/nav_section_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(178562403162170735.4907)
,p_lov_name=>'NAV_SECTION_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(178562403162170735.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178562620987170738.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9801\9762\5C0E\89BD')
,p_lov_return_value=>'NAV_PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(178562830738170741.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5340\6BB5\5C0E\89BD')
,p_lov_return_value=>'NAV_SECTION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/order_by_direction
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(606013026952235682.4907)
,p_lov_name=>'ORDER_BY_DIRECTION'
,p_lov_query=>'.'||wwv_flow_api.id(606013026952235682.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(606013300020235684.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\905E\589E')
,p_lov_return_value=>'ASC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(606013531554235685.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\905E\6E1B')
,p_lov_return_value=>'DESC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p740_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(429632313107701908.4907)
,p_lov_name=>'P740_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p742_data_grid_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261395425456539191.4907)
,p_lov_name=>'P742_DATA_GRID_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p742_data_grid_num_cols
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(261459220009944453.4907)
,p_lov_name=>'P742_DATA_GRID_NUM_COLS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and c.column_type = ''NUMBER''',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and column_type = ''NUMBER''',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p750_chart_source
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428899916079615170.4907)
,p_lov_name=>'P750_CHART_SOURCE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name||',
'       case when websheet_type=''DATA'' then '' (''||wwv_flow_lang.system_message(''DATA_GRID'')||'')''',
'            when websheet_type=''REPORT'' then '' (''||wwv_flow_lang.system_message(''REPORT'')||'')''',
'       end d,',
'       id r',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_chart_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(444797819996488091.4907)
,p_lov_name=>'P760_CHART_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(444797819996488091.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798026947488095.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9577\689D\5716')
,p_lov_return_value=>'bar'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798216267488096.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6298\7DDA\5340\57DF\5716')
,p_lov_return_value=>'lineWithArea'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798632016488096.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5713\9905\5716')
,p_lov_return_value=>'pie'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444798420560488096.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\6298\7DDA\5716')
,p_lov_return_value=>'line'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_data_grid_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(293396605682831178.4907)
,p_lov_name=>'P760_DATA_GRID_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P760_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P760_SAVED_REPORT_ID',
'and websheet_id = :P760_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_data_grid_num_cols
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(424623105999868608.4907)
,p_lov_name=>'P760_DATA_GRID_NUM_COLS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P760_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'and c.column_type = ''NUMBER''',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P760_SAVED_REPORT_ID',
'and websheet_id = :P760_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id',
'and column_type = ''NUMBER'')',
'where instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P760_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p760_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(429677014294033232.4907)
,p_lov_name=>'P760_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P760_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P760_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_datagrid_show_opt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244084119358061944.4907)
,p_lov_name=>'P922_DATAGRID_SHOW_OPT'
,p_lov_query=>'.'||wwv_flow_api.id(244084119358061944.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244084422806061944.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\65B0\589E\8CC7\6599\5217')
,p_lov_return_value=>'ADD_ROW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244084730829061948.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\7DE8\8F2F\8CC7\6599\5217')
,p_lov_return_value=>'EDIT_ROW'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244085024367061948.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\641C\5C0B\6B04\4F4D')
,p_lov_return_value=>'SEARCH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_data_grid_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(178772114682347881.4907)
,p_lov_name=>'P922_DATA_GRID_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P922_DATA_GRID_ID',
'and d.security_group_id = :flow_security_group_id',
'order by display_order'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_report_show_opt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244090113649098118.4907)
,p_lov_name=>'P922_REPORT_SHOW_OPT'
,p_lov_query=>'.'||wwv_flow_api.id(244090113649098118.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244091002759098119.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\641C\5C0B\6B04\4F4D')
,p_lov_return_value=>'SEARCH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p922_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(430293730079245893.4907)
,p_lov_name=>'P922_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P922_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') != ''NOTIFICATION''',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P922_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') != ''NOTIFICATION'') x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p925_data_section_style
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(244105603016227532.4907)
,p_lov_name=>'P925_DATA_SECTION_STYLE'
,p_lov_query=>'.'||wwv_flow_api.id(244105603016227532.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244105926056227533.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6A23\5F0F 1')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244106215253227534.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6A23\5F0F 2')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(244106500467227534.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\6A23\5F0F 3')
,p_lov_return_value=>'3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p934_data_section_show_opt
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(239269013341119720.4907)
,p_lov_name=>'P934_DATA_SECTION_SHOW_OPT'
,p_lov_query=>'.'||wwv_flow_api.id(239269013341119720.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(239269323845119720.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\65B0\589E\8CC7\6599\5217')
,p_lov_return_value=>'ADD_ROW'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P934_WEBSHEET_TYPE'
,p_lov_disp_cond2=>'DATA_GRID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(239269606033119720.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\7DE8\8F2F\8CC7\6599\5217')
,p_lov_return_value=>'EDIT_ROW'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P934_WEBSHEET_TYPE'
,p_lov_disp_cond2=>'DATA_GRID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(239269902232119720.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\641C\5C0B\6B04\4F4D')
,p_lov_return_value=>'SEARCH'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p934_saved_reports
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(431037130827466603.4907)
,p_lov_name=>'P934_SAVED_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P934_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P934_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_email_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(473383419441178851.4907)
,p_lov_name=>'PAGE EMAIL OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(473383419441178851.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(473383631984178859.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4F7F\7528\96FB\5B50\90F5\4EF6\50B3\9001\9801\9762\9023\7D50')
,p_lov_return_value=>'LINK'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(473383814758178865.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\4F7F\7528\96FB\5B50\90F5\4EF6\50B3\9001\9801\9762\5167\5BB9')
,p_lov_return_value=>'PAGE'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_navigation_order
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(381950720171699749.4907)
,p_lov_name=>'PAGE NAVIGATION ORDER'
,p_lov_query=>'.'||wwv_flow_api.id(381950720171699749.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(381951031098699751.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9801\9762\540D\7A31')
,p_lov_return_value=>'PAGE_NAME'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(381951211109699752.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5EFA\7ACB\65E5\671F')
,p_lov_return_value=>'CREATED_ON'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(381951400366699752.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\66F4\65B0\65E5\671F')
,p_lov_return_value=>'UPDATED_ON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/page_position
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174603521097074779.4907)
,p_lov_name=>'PAGE POSITION'
,p_lov_query=>'.'||wwv_flow_api.id(174603521097074779.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174603926494074780.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\9760\5DE6')
,p_lov_return_value=>'LEFT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174604103608074780.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\7F6E\4E2D')
,p_lov_return_value=>'CENTER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174604316948074780.4907)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\9760\53F3')
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(454994331134405615.4907)
,p_lov_name=>'PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from wwv_flow_ws_webpages',
'where ws_app_id = :WS_APP_ID',
'and security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/pick_parent_page_for_page_53
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177413911605744887.4907)
,p_lov_name=>'PICK PARENT PAGE (FOR PAGE 53)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID',
'minus',
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id ',
'   and ws_app_id = :WS_APP_ID ',
'connect by prior id = parent_page_id',
'start with id = :P53_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/popup_data_grid_view_options
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(6245305086538240.4907)
,p_lov_name=>'POPUP_DATA_GRID_VIEW_OPTIONS'
,p_lov_query=>'.'||wwv_flow_api.id(6245305086538240.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6245604034538241.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8CC7\6599\65B9\683C')
,p_lov_return_value=>'DATA_GRIDS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6245803688538242.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\9078\53D6\7684\8CC7\6599\65B9\683C\8CC7\6599\6B04')
,p_lov_return_value=>'COLUMNS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(6246002516538242.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\67E5\8A62\9078\53D6\7684\8CC7\6599\65B9\683C')
,p_lov_return_value=>'QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/remember_username
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(263997216503587205.4907)
,p_lov_name=>'REMEMBER_USERNAME'
,p_lov_query=>'.'||wwv_flow_api.id(263997216503587205.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(263997505048587206.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8A18\4F4F\4F7F\7528\8005\540D\7A31')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428697210472793191.4907)
,p_lov_name=>'REPORT'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''REPORT'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report_label_returning_column_alias
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(157608702042123701.4907)
,p_lov_name=>'REPORT LABEL RETURNING COLUMN ALIAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_label, db_column_name',
'from wwv_flow_worksheet_columns',
'where worksheet_id = :P2_ID',
'and security_group_id = :WORKSPACE_ID',
'order by display_order'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/report_source_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(181139517862367299.4907)
,p_lov_name=>'REPORT_SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(181139517862367299.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181139731760367303.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8868\683C')
,p_lov_return_value=>'TABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(181139914754367305.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('SQL \67E5\8A62')
,p_lov_return_value=>'QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/row_security_restrict_by
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4200913969354730.4907)
,p_lov_name=>'ROW_SECURITY_RESTRICT_BY'
,p_lov_query=>'.'||wwv_flow_api.id(4200913969354730.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4201216137354731.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8CC7\6599\6B04\8868\793A\5F0F')
,p_lov_return_value=>'COLUMN_EXPR'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4201401816354731.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\8CC7\6599\6B04\4E2D\7684\4F7F\7528\8005\540D\7A31')
,p_lov_return_value=>'USERNAME_IN_COLUMNS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4201616338354731.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\968E\5C64\4E2D\7684\4F7F\7528\8005\540D\7A31')
,p_lov_return_value=>'USERNAME_IN_HIERARCHY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/searchable_components
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(468375932547106712.4907)
,p_lov_name=>'SEARCHABLE COMPONENTS'
,p_lov_query=>'.'||wwv_flow_api.id(468375932547106712.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468388406715184404.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\9801\9762\540D\7A31')
,p_lov_return_value=>'Page name'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471083025269088996.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\9801\9762\5225\540D')
,p_lov_return_value=>'Page alias'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471083730810090673.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\9801\9762\63CF\8FF0')
,p_lov_return_value=>'Page description'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376931120106721.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\5340\6BB5\6A19\984C')
,p_lov_return_value=>'Section title'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376724828106721.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\5340\6BB5\5167\5BB9')
,p_lov_return_value=>'Section content'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376107670106719.4907)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\6A94\6848\540D\7A31\3001\5225\540D\3001\63CF\8FF0')
,p_lov_return_value=>'File'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468377117690106722.4907)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>unistr('\6A19\8A18')
,p_lov_return_value=>'Tags'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468376332154106721.4907)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>unistr('\9644\8A3B')
,p_lov_return_value=>'Notes'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(468763112243277596.4907)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>unistr('\8CC7\6599\65B9\683C\8CC7\6599')
,p_lov_return_value=>'Data grid'
);
end;
/
prompt --application/shared_components/user_interface/lovs/section_type_selector
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174363201295924966.4907)
,p_lov_name=>'SECTION TYPE SELECTOR'
,p_lov_query=>'.'||wwv_flow_api.id(174363201295924966.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174363729720924971.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6587\5B57')
,p_lov_return_value=>'TEXT'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:910:&SESSION.:::910,P910_CONTENT,P910_SPREADSHEET:P920_SECTION_TYPE:TEXT"><img src="#IMAGE_PREFIX#ws/ws-text.png" height="128"'
||' width="128" alt="#DISPLAY_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174366523901938416.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5C0E\89BD')
,p_lov_return_value=>'NAV'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:926:&SESSION.:::926:P920_SECTION_TYPE:NAV"><img src="#IMAGE_PREFIX#ws/ws-navigation.png" height="128" width="128" alt="#DISPLA'
||'Y_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174363503996924969.4907)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>unistr('\8CC7\6599')
,p_lov_return_value=>'DATA'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:922:&SESSION.:::922,925:P920_SECTION_TYPE:DATA"><img src="#IMAGE_PREFIX#ws/ws-from-scratch.png" height="128" width="128" alt="'
||'#DISPLAY_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id'))
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(257305806305291010.4907)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>unistr('\5716\8868')
,p_lov_return_value=>'CHART'
,p_lov_template=>'#DISPLAY_VALUE#<br /><table role="presentation" cellspacing="10" cellpadding="0"><tr><td valign="top"><a href="f?p=&APP_ID.:710:&SESSION.:::710,740,742,750:P920_SECTION_TYPE:CHART"><img src="#IMAGE_PREFIX#ws/ws-chart.png" height="128" width="128" alt'
||'="#DISPLAY_VALUE#" /></a></td><td>&nbsp;</td></tr></table>'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/section_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(492203630195322675.4907)
,p_lov_name=>'SECTION TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(492203630195322675.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492203816689322675.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6587\5B57')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204004458322675.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5716\8868')
,p_lov_return_value=>'CHART'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204222124322676.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\5340\6BB5\5C0E\89BD')
,p_lov_return_value=>'NAV_SECTION'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204407452322676.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\9801\9762\5C0E\89BD')
,p_lov_return_value=>'NAV_PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(492204623758322676.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\8CC7\6599')
,p_lov_return_value=>'DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(15734501398512875.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'PL/SQL'
,p_lov_return_value=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/section_source
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428681322228645128.4907)
,p_lov_name=>'SECTION_SOURCE'
,p_lov_query=>'.'||wwv_flow_api.id(428681322228645128.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(428681516422645131.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8CC7\6599\65B9\683C')
,p_lov_return_value=>'DATA_GRID'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(428681722703645131.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5831\8868 ')
,p_lov_return_value=>'REPORT'
,p_lov_disp_cond_type=>'FUNCTION_BODY'
,p_lov_disp_cond=>'return wwv_flow_ws_security.current_user_is_not_reader and wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and wwv_flow_ws_security.sql_enabled_inst;'
);
end;
/
prompt --application/shared_components/user_interface/lovs/sharing_standard_codes
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(161342315175360665.4907)
,p_lov_name=>'SHARING - STANDARD CODES'
,p_lov_query=>'.'||wwv_flow_api.id(161342315175360665.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161342511198360666.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\8207\6240\6709\4EBA\5171\7528')
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(22963820418845971.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8207\5B58\53D6\63A7\5236\6E05\55AE\5171\7528')
,p_lov_return_value=>'ACL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(161342929843360666.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\5C08\7528')
,p_lov_return_value=>'AVAILABLE_FOR_OWNER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/show_all_websheets_or_my_websheets
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(83901725439965785.4907)
,p_lov_name=>'SHOW ALL WEBSHEETS OR MY WEBSHEETS'
,p_lov_query=>'.'||wwv_flow_api.id(83901725439965785.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83901929137965786.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\6240\6709 Web \8A66\7B97\8868')
,p_lov_return_value=>'ALL'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83902128718965786.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6211\7684 Web \8A66\7B97\8868')
,p_lov_return_value=>'MINE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/suggested_sql_table_type_p90
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(17231024016826986.4907)
,p_lov_name=>'SUGGESTED SQL TABLE TYPE (P90)'
,p_lov_query=>'.'||wwv_flow_api.id(17231024016826986.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17231212381826990.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5EFA\8B70\7684\7269\4EF6')
,p_lov_return_value=>'S'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(17231413694826994.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\6240\6709\53EF\5B58\53D6\7684\7269\4EF6')
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/text_websheets
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174421329189713558.4907)
,p_lov_name=>'TEXT WEBSHEETS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_ws_webpages',
'where security_group_id = :flow_security_group_id and',
'      ws_app_id = :WS_APP_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/timeframe
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(185584826211920495.4907)
,p_lov_name=>'TIMEFRAME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/url_or_report
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(184024419940878266.4907)
,p_lov_name=>'URL_OR_REPORT'
,p_lov_query=>'.'||wwv_flow_api.id(184024419940878266.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184024616003878266.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\5831\8868')
,p_lov_return_value=>'REPORT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(184024823203878266.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/use_primary_default
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(428734704772905075.4907)
,p_lov_name=>'USE_PRIMARY_DEFAULT'
,p_lov_query=>'.'||wwv_flow_api.id(428734704772905075.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(428734912977905076.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4F7F\7528\4E3B\8981\9810\8A2D\5831\8868\8A2D\5B9A\503C')
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/validate_plsql
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(12497031296679964.4907)
,p_lov_name=>'VALIDATE_PLSQL'
,p_lov_query=>'.'||wwv_flow_api.id(12497031296679964.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(12497306721679972.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\4E0D\9A57\8B49 PL/SQL \7A0B\5F0F\78BC (\50C5\5728\7A0B\5F0F\5BE6\969B\57F7\884C\6642\5256\6790 PL/SQL \7A0B\5F0F\78BC).')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/view_as_icons_or_details
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(83845910791829052.4907)
,p_lov_name=>'VIEW AS ICONS OR DETAILS'
,p_lov_query=>'.'||wwv_flow_api.id(83845910791829052.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83846129033829055.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\5716\793A')
,p_lov_return_value=>'ICONS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(83846305343829058.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8A73\7D30\8CC7\8A0A')
,p_lov_return_value=>'DETAILS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_application_status
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(471867429070174759.4907)
,p_lov_name=>'WEBSHEET APPLICATION STATUS'
,p_lov_query=>'.'||wwv_flow_api.id(471867429070174759.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471867623399174772.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\53EF\7528')
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(471868003921176945.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\7121\6CD5\4F7F\7528')
,p_lov_return_value=>'UNAVAILABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_authentication
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(444727703759035884.4907)
,p_lov_name=>'WEBSHEET AUTHENTICATION'
,p_lov_query=>'.'||wwv_flow_api.id(444727703759035884.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728117740035894.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('Application Express \5E33\6236')
,p_lov_return_value=>'1'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728300760035894.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\55AE\4E00\767B\5165')
,p_lov_return_value=>'2'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728526805035894.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'LDAP'
,p_lov_return_value=>'3'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(1959643209188118620.4907)
,p_lov_disp_sequence=>4.5
,p_lov_disp_value=>'Oracle Cloud Identity Management'
,p_lov_return_value=>'5'
,p_lov_disp_cond_type=>'PLSQL_EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(444728724858035894.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\81EA\8A02')
,p_lov_return_value=>'4'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_home_page_selector_p_1250
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177463924416148776.4907)
,p_lov_name=>'WEBSHEET HOME PAGE SELECTOR (P 1250)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name, id ',
'from WWV_FLOW_WS_WEBPAGES ',
'where WS_APP_ID = :P1250_ID and',
'      security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_page_style
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(478186020350840371.4907)
,p_lov_name=>'WEBSHEET PAGE STYLE'
,p_lov_query=>'.'||wwv_flow_api.id(478186020350840371.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(478186224261840375.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9810\8A2D\6A23\5F0F')
,p_lov_return_value=>'0'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(478186402878840381.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\66FF\4EE3\6A23\5F0F 1')
,p_lov_return_value=>'1'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(478187212720840384.4907)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>unistr('\81EA\8A02\6A23\5F0F')
,p_lov_return_value=>'99'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(177459420645100351.4907)
,p_lov_name=>'WEBSHEET PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(177459420645100351.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177459613519100354.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9801\9762')
,p_lov_return_value=>'PAGE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(177459807231100356.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\8CC7\6599\65B9\683C')
,p_lov_return_value=>'DATA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheets_pick_parent_show_all_pages
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(477788102822094591.4907)
,p_lov_name=>'WEBSHEETS - PICK PARENT -- SHOW ALL PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_ws_webpages',
'where security_group_id = :flow_security_group_id and',
'      ws_app_id = :WS_APP_ID ',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_priv
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4272307523349785.4907)
,p_lov_name=>'WEBSHEET_PRIV'
,p_lov_query=>'.'||wwv_flow_api.id(4272307523349785.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4272616503349799.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\6AA2\8996\53CA\7DE8\8F2F')
,p_lov_return_value=>'EDIT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4272800274349801.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\50C5\6AA2\8996')
,p_lov_return_value=>'VIEW_ONLY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/websheet_share_with
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4270305567216064.4907)
,p_lov_name=>'WEBSHEET_SHARE_WITH'
,p_lov_query=>'.'||wwv_flow_api.id(4270305567216064.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4271211380216070.4907)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>unistr('\5C08\7528, \4E0D\5171\7528')
,p_lov_return_value=>'PRIVATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_lov_from
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(7088909602608513.4907)
,p_lov_name=>'WORKSHEET COLUMN LOV FROM'
,p_lov_query=>'.'||wwv_flow_api.id(7088909602608513.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7089115009608515.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\4E0D\540C\7684\8CC7\6599\6B04\503C')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(7089311442608516.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\975C\614B\6578\503C\7BC4\570D')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_lovs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(20284128708076403.4907)
,p_lov_name=>'WORKSHEET LOVS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select NAME display_value, ID return_value ',
'from WWV_FLOW_WORKSHEET_LOVS',
'where worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID',
'order by upper(name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_reports_with_worksheet
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(1097408377479572.4907)
,p_lov_name=>'WORKSHEET REPORTS WITH WORKSHEET'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(name, ''- Worksheet -'') name, id ',
'  from wwv_flow_worksheet_rpts',
' where worksheet_id = :P2_ID',
'   and application_user = :APP_USER',
'   and name is not null',
'   and security_group_id = :flow_security_group_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_columns
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4196722056290886.4907)
,p_lov_name=>'WORKSHEET_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select report_label, db_column_name',
'from wwv_flow_worksheet_columns',
'where worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID',
'order by display_order'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_types
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(159512305334979648.4907)
,p_lov_name=>'WORKSHEET_COLUMN_TYPES'
,p_lov_query=>'.'||wwv_flow_api.id(159512305334979648.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159512611310979649.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5B57\4E32')
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159512810815979649.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6578\5B57')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159513008482979649.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65E5\671F')
,p_lov_return_value=>'DATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159513210897979649.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6587\4EF6')
,p_lov_return_value=>'DOCUMENT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(11517807514880595.4907)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>unistr('\904B\7B97\6642\9593')
,p_lov_return_value=>'COMPUTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/worksheet_column_types2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(38353412581019585.4907)
,p_lov_name=>'WORKSHEET_COLUMN_TYPES2'
,p_lov_query=>'.'||wwv_flow_api.id(38353412581019585.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38353715513019587.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\5B57\4E32')
,p_lov_return_value=>'STRING'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38353907530019587.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6578\5B57')
,p_lov_return_value=>'NUMBER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(38354113803019587.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\65E5\671F')
,p_lov_return_value=>'DATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_acl_privs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(451333930142995878.4907)
,p_lov_name=>'WS_ACL_PRIVS'
,p_lov_query=>'.'||wwv_flow_api.id(451333930142995878.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(451334128711995879.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\95B1\8B80\8005')
,p_lov_return_value=>'R'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(451334314312995960.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\63D0\4F9B\8005')
,p_lov_return_value=>'C'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(451334509043995960.4907)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>unistr('\7BA1\7406\54E1')
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_app_acl_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(450940100671567605.4907)
,p_lov_name=>'WS_APP_ACL_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(450940100671567605.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(450940311282567606.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\9810\8A2D')
,p_lov_return_value=>'DEFAULT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(450940510709567608.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\81EA\8A02')
,p_lov_return_value=>'CUSTOM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_logo_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(461278502171499627.4907)
,p_lov_name=>'WS_LOGO_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(461278502171499627.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461278702764499627.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\7121')
,p_lov_return_value=>'NONE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461278910485499644.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6587\5B57')
,p_lov_return_value=>'TEXT'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461279109274499644.4907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>unistr('\4E0A\50B3\7684\5F71\50CF')
,p_lov_return_value=>'IMAGE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(461279326169499644.4907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>unistr('\6A94\6848\8DEF\5F91')
,p_lov_return_value=>'FILEPATH'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ws_page_type
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(174627223457398766.4907)
,p_lov_name=>'WS_PAGE_TYPE'
,p_lov_query=>'.'||wwv_flow_api.id(174627223457398766.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174627515804398767.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\8CC7\6599\65B9\683C')
,p_lov_return_value=>'DATA'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(174627719694398770.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\6587\5B57')
,p_lov_return_value=>'TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returning_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(159003224636178271.4907)
,p_lov_name=>'YES NO RETURNING Y N'
,p_lov_query=>'.'||wwv_flow_api.id(159003224636178271.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159003530237178272.4907)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(159003719271178272.4907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(4091010662546975.4907)
,p_lov_name=>'YES NO RETURNS Y N'
,p_lov_query=>'.'||wwv_flow_api.id(4091010662546975.4907)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4091213313546978.4907)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>unistr('\662F')
,p_lov_return_value=>'Y'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(4091420742546980.4907)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>unistr('\5426')
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/worksheet_standard
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(78897017520604216.4907)
,p_name=>'worksheet standard'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2670021526029217.4907)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4907)
,p_short_name=>unistr('\6AA2\8996\8B8A\66F4\6B77\53F2\8A18\9304')
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4230728579343205.4907)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4907)
,p_short_name=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B')
,p_link=>'f?p=&FLOW_ID.:89:&SESSION.'
,p_page_id=>89
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(4233729491405795.4907)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4907)
,p_short_name=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B')
,p_link=>'f?p=&FLOW_ID.:91:&SESSION.'
,p_page_id=>91
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(5510514461754522.4907)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4907)
,p_short_name=>unistr('\5100\8868\677F')
,p_link=>'f?p=&FLOW_ID.:400:&SESSION.'
,p_page_id=>400
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(78897520983605269.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\9801\9762\76EE\9304')
,p_link=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:::'
,p_page_id=>1000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(78901107456613285.4907)
,p_parent_id=>wwv_flow_api.id(78897520983605269.4907)
,p_short_name=>unistr('\5EFA\7ACB\9801\9762')
,p_link=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:::'
,p_page_id=>200
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(78917815626639965.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>'&WORKSHEET_NAME.'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::P2_ID:&P2_ID.'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(81681714437489706.4907)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4907)
,p_short_name=>unistr('\65B0\589E/\7DE8\8F2F\8CC7\6599\5217')
,p_link=>'f?p=&FLOW_ID.:20:&SESSION.'
,p_page_id=>20
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(81687303832540185.4907)
,p_parent_id=>wwv_flow_api.id(78917815626639965.4907)
,p_short_name=>unistr('\65B0\589E\9644\4EF6')
,p_link=>'f?p=&FLOW_ID.:50:&SESSION.'
,p_page_id=>50
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(85198520867592463.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_link=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:::'
,p_page_id=>205
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(85200708143598339.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_link=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.:::'
,p_page_id=>201
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(87067930193889011.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_link=>'f?p=&APP_ID.:206:&SESSION.::&DEBUG.:::'
,p_page_id=>206
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171300231813414293.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>'&P3000_REPORT_NAME!RAW.'
,p_link=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.:::'
,p_page_id=>3000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(171582602179856081.4907)
,p_parent_id=>wwv_flow_api.id(171300231813414293.4907)
,p_short_name=>unistr('\7DE8\8F2F\5831\8868')
,p_link=>'f?p=&APP_ID.:3010:&SESSION.::&DEBUG.:::'
,p_page_id=>3010
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(172959905219473555.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\641C\5C0B')
,p_link=>'f?p=&APP_ID.:8000:&SESSION.::&DEBUG.:::'
,p_page_id=>8000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(173221216721622592.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>unistr('\5EFA\7ACB')
,p_link=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:::'
,p_page_id=>131
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174460015452180827.4907)
,p_parent_id=>wwv_flow_api.id(.4907)
,p_short_name=>unistr('\9996\9801')
,p_link=>'ws?p=&WS_APP_ID.:home:&SESSION.'
,p_page_id=>900
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174536419956209170.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\65B0\5EFA\5340\6BB5')
,p_link=>'f?p=&APP_ID.:910:&SESSION.::&DEBUG.:::'
,p_page_id=>910
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174537325551221738.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\65B0\5EFA\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:920:&SESSION.'
,p_page_id=>920
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174562103281566299.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\7DE8\8F2F\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:930:&SESSION.'
,p_page_id=>930
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(174587421741748355.4907)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4907)
,p_short_name=>unistr('\5100\8868\677F')
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(176493330002233411.4907)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4907)
,p_short_name=>unistr('Web \8A66\7B97\8868\7279\6027')
,p_link=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:::'
,p_page_id=>1250
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177132319189562341.4907)
,p_parent_id=>wwv_flow_api.id(174587421741748355.4907)
,p_short_name=>unistr('\7BA1\7406\8A8D\8B49\914D\7F6E')
,p_link=>'f?p=&FLOW_ID.:51:&SESSION.'
,p_page_id=>51
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177425500872951637.4907)
,p_parent_id=>wwv_flow_api.id(.4907)
,p_short_name=>unistr('\7DE8\8F2F\9801\9762')
,p_link=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:::'
,p_page_id=>53
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177505624887294566.4907)
,p_parent_id=>wwv_flow_api.id(174587421741748355.4907)
,p_short_name=>unistr('\5EFA\7ACB\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:921:&SESSION.'
,p_page_id=>921
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(177969610547759155.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\522A\9664\9801\9762')
,p_link=>'f?p=&FLOW_ID.:960:&SESSION.'
,p_page_id=>960
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178435411977260701.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\7DE8\8F2F\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:931:&SESSION.'
,p_page_id=>931
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178515920668406977.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB\8CC7\6599\5340\6BB5')
,p_link=>'f?p=&APP_ID.:922:&SESSION.::&DEBUG.:::'
,p_page_id=>922
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178567213402219839.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:926:&SESSION.'
,p_page_id=>926
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178572623297245626.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:927:&SESSION.'
,p_page_id=>927
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178735000980446641.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\7DE8\8F2F\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:932:&SESSION.'
,p_page_id=>932
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178832411836267350.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\8CC7\6599')
,p_link=>'f?p=&APP_ID.:902:&SESSION.::&DEBUG.:::'
,p_page_id=>902
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178833326920275511.4907)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4907)
,p_short_name=>unistr('\6A94\6848')
,p_link=>'f?p=&APP_ID.:903:&SESSION.::&DEBUG.:::'
,p_page_id=>903
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178833723901276942.4907)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4907)
,p_short_name=>unistr('\6A19\8A18')
,p_link=>'f?p=&APP_ID.:904:&SESSION.::&DEBUG.:::'
,p_page_id=>904
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178834117647279840.4907)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4907)
,p_short_name=>unistr('\9644\8A3B')
,p_link=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.:::'
,p_page_id=>905
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(178856318730488076.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\8907\88FD\9801\9762')
,p_link=>'f?p=&FLOW_ID.:908:&SESSION.'
,p_page_id=>908
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(179692514107778690.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB\8CC7\6599\5340\6BB5')
,p_link=>'f?p=&APP_ID.:925:&SESSION.::&DEBUG.:::'
,p_page_id=>925
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(180470222886094847.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\7DE8\8F2F\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:934:&SESSION.'
,p_page_id=>934
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181263431536172556.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>unistr('\5EFA\7ACB\5831\8868')
,p_link=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.:::'
,p_page_id=>1310
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(181299229440629329.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>unistr('\5EFA\7ACB\5831\8868')
,p_link=>'f?p=&APP_ID.:1320:&SESSION.::&DEBUG.:::'
,p_page_id=>1320
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(184267525052006599.4907)
,p_parent_id=>wwv_flow_api.id(171582602179856081.4907)
,p_short_name=>unistr('\7DE8\8F2F\5831\8868\8CC7\6599\6B04')
,p_link=>'f?p=&APP_ID.:3020:&SESSION.::&DEBUG.:::'
,p_page_id=>3020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(185430107950682414.4907)
,p_parent_id=>wwv_flow_api.id(171300231813414293.4907)
,p_short_name=>unistr('\7DE8\8F2F\5831\8868')
,p_link=>'f?p=&APP_ID.:3030:&SESSION.::&DEBUG.:::'
,p_page_id=>3030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(187171813556872743.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\8A3B\89E3')
,p_link=>'f?p=&APP_ID.:906:&SESSION.::&DEBUG.:::'
,p_page_id=>906
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(187174620703946459.4907)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4907)
,p_short_name=>unistr('\76E3\7763\6D3B\52D5')
,p_link=>'f?p=&APP_ID.:140:&SESSION.::&DEBUG.:::'
,p_page_id=>140
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(188056521384504797.4907)
,p_parent_id=>wwv_flow_api.id(171300231813414293.4907)
,p_short_name=>unistr('\7DE8\8F2F\5831\8868')
,p_link=>'f?p=&APP_ID.:3060:&SESSION.::&DEBUG.:::'
,p_page_id=>3060
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(301532509548629032.4907)
,p_parent_id=>wwv_flow_api.id(176493330002233411.4907)
,p_short_name=>unistr('\522A\9664\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(318860608321904558.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(321423130089423576.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_link=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::'
,p_page_id=>8
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(322238812351579455.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_link=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::'
,p_page_id=>32
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(431020021350285368.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_link=>'f?p=&FLOW_ID.:710:&SESSION.'
,p_page_id=>710
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(451312903217376859.4907)
,p_parent_id=>wwv_flow_api.id(456716629226062947.4907)
,p_short_name=>unistr('\5B58\53D6\63A7\5236')
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(451316327052485988.4907)
,p_parent_id=>wwv_flow_api.id(451312903217376859.4907)
,p_short_name=>unistr('\9805\76EE\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:::'
,p_page_id=>13
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(454926007401991139.4907)
,p_parent_id=>wwv_flow_api.id(178833326920275511.4907)
,p_short_name=>unistr('\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:912:&SESSION.::&DEBUG.:::'
,p_page_id=>912
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(455078007098014547.4907)
,p_parent_id=>wwv_flow_api.id(178833723901276942.4907)
,p_short_name=>unistr('\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:913:&SESSION.::&DEBUG.:::'
,p_page_id=>913
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(455084307504044741.4907)
,p_parent_id=>wwv_flow_api.id(178834117647279840.4907)
,p_short_name=>unistr('\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&APP_ID.:914:&SESSION.::&DEBUG.:::'
,p_page_id=>914
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(455867027556226619.4907)
,p_parent_id=>wwv_flow_api.id(456715709817052851.4907)
,p_short_name=>unistr('Web \8A66\7B97\8868\7E3D\89BD')
,p_link=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:::'
,p_page_id=>15
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(456716629226062947.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\7BA1\7406')
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(456723414173263488.4907)
,p_parent_id=>wwv_flow_api.id(456715709817052851.4907)
,p_short_name=>unistr('\6A19\8A18\8A9E\6CD5')
,p_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::'
,p_page_id=>17
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457141423716390388.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\65B0\589E\6A94\6848')
,p_link=>'f?p=&APP_ID.:4020:&SESSION.::&DEBUG.:::'
,p_page_id=>4020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457151729837534039.4907)
,p_parent_id=>wwv_flow_api.id(.4907)
,p_short_name=>unistr('\65B0\589E\9644\8A3B')
,p_link=>'f?p=&APP_ID.:4030:&SESSION.::&DEBUG.:::'
,p_page_id=>4030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457152105511545952.4907)
,p_parent_id=>wwv_flow_api.id(.4907)
,p_short_name=>unistr('\65B0\589E\6A19\8A18')
,p_link=>'f?p=&APP_ID.:4040:&SESSION.::&DEBUG.:::'
,p_page_id=>4040
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(457468026650230855.4907)
,p_parent_id=>wwv_flow_api.id(.4907)
,p_short_name=>unistr('\9801\9762\5340\6BB5\6B77\53F2\8A18\9304')
,p_link=>'f?p=&APP_ID.:950:&SESSION.::&DEBUG.:::'
,p_page_id=>950
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(459182006892056281.4907)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4907)
,p_short_name=>unistr('\6A19\7C64\96F2')
,p_link=>'f?p=&FLOW_ID.:928:&SESSION.'
,p_page_id=>928
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(459633626075416367.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\9801\9762\6AA2\8996')
,p_link=>'f?p=&FLOW_ID.:18:&SESSION.'
,p_page_id=>18
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(459662412537763358.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\9801\9762')
,p_link=>'f?p=&FLOW_ID.:24:&SESSION.'
,p_page_id=>24
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(461238603047810834.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\8CC7\6599\65B9\683C')
,p_link=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.:::'
,p_page_id=>141
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(461331422787325871.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\5831\8868')
,p_link=>'f?p=&FLOW_ID.:142:&SESSION.'
,p_page_id=>142
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(461348622392450101.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('Web \8A66\7B97\8868\76EE\9304')
,p_link=>'f?p=&APP_ID.:1001:&SESSION.::&DEBUG.:::'
,p_page_id=>1001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471882914071890170.4907)
,p_parent_id=>wwv_flow_api.id(.4907)
,p_short_name=>unistr('\9801\9762\5EFA\7ACB\884C\4E8B\66C6')
,p_link=>'f?p=&FLOW_ID.:951:&SESSION.'
,p_page_id=>951
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471901627876065162.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\6A94\6848')
,p_link=>'f?p=&FLOW_ID.:143:&SESSION.'
,p_page_id=>143
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471903119311084491.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\9644\8A3B')
,p_link=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.:::'
,p_page_id=>144
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471904206990093888.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\6A19\8A18')
,p_link=>'f?p=&FLOW_ID.:145:&SESSION.'
,p_page_id=>145
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(471917025140272524.4907)
,p_parent_id=>wwv_flow_api.id(187174620703946459.4907)
,p_short_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_link=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.:::'
,p_page_id=>146
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(472197018359897527.4907)
,p_parent_id=>wwv_flow_api.id(174562103281566299.4907)
,p_short_name=>unistr('\5C07\5340\6BB5\79FB\52D5\81F3\73FE\6709\9801\9762')
,p_link=>'f?p=&APP_ID.:990:&SESSION.::&DEBUG.:::'
,p_page_id=>990
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(472200003119943726.4907)
,p_parent_id=>wwv_flow_api.id(174562103281566299.4907)
,p_short_name=>unistr('\5C07\5340\6BB5\79FB\52D5\81F3\65B0\9801\9762')
,p_link=>'f?p=&FLOW_ID.:991:&SESSION.'
,p_page_id=>991
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(472804624985588482.4907)
,p_parent_id=>wwv_flow_api.id(456715709817052851.4907)
,p_short_name=>unistr('\95DC\65BC\6B64\61C9\7528\7A0B\5F0F')
,p_link=>'f?p=&FLOW_ID.:16:&SESSION.'
,p_page_id=>16
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(473082318328043502.4907)
,p_parent_id=>wwv_flow_api.id(187171813556872743.4907)
,p_short_name=>unistr('\9023\7D50')
,p_link=>'f?p=&FLOW_ID.:915:&SESSION.'
,p_page_id=>915
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(497240808682988557.4907)
,p_parent_id=>wwv_flow_api.id(178832411836267350.4907)
,p_short_name=>unistr('\6211\7684\9810\5B58\5831\8868')
,p_link=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:::'
,p_page_id=>42
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(619997132010437333.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\9078\53D6\8A9E\8A00')
,p_link=>'f?p=&FLOW_ID.:37:&SESSION.'
,p_page_id=>37
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(626920713710448375.4907)
,p_parent_id=>wwv_flow_api.id(473082318328043502.4907)
,p_short_name=>unistr('\9023\7D50\8A73\7D30\8CC7\8A0A')
,p_link=>'f?p=&FLOW_ID.:916:&SESSION.'
,p_page_id=>916
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(733378208922655612.4907)
,p_parent_id=>wwv_flow_api.id(174460015452180827.4907)
,p_short_name=>unistr('\8B8A\66F4\5BC6\78BC')
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_three_columns
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3700422714748.4907)
,p_theme_id=>3
,p_name=>'[EBA] WS Three Columns.zh-tw'
,p_internal_name=>'[EBA]_WS_THREE_COLUMNS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'		',
'	<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'			<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="ebaMainCol">',
'#BODY#',
'		</div>',
'		<div class="ebaSideCol">',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/iframe_load_required_for_data_grid_file_upload
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(3152608674388513.4907)
,p_theme_id=>3
,p_name=>'iframe load - Required for Data Grid File Upload.zh-tw'
,p_internal_name=>'IFRAME_LOAD_REQUIRED_FOR_DATA_GRID_FILE_UPLOAD'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body #ONLOAD# style="margin:5px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#BODY#',
'</div>',
'<div style="text-align:middle;">#REGION_POSITION_08#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="htmldbSuccessMessage">#SUCCESS_MESSAGE#</div>',
''))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="htmldbNotification">#MESSAGE#</div>',
''))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_two_columns
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(9297021464956579.4907)
,p_theme_id=>3
,p_name=>'[EBA] WS Two Columns.zh-tw'
,p_internal_name=>'[EBA]_WS_TWO_COLUMNS'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="ebaMainCol">',
'#BODY#',
'		</div>',
'		<div class="ebaSideCol">',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_one_column
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(10606007362285088.4907)
,p_theme_id=>3
,p_name=>'[EBA] WS One Column.zh-tw'
,p_internal_name=>'[EBA]_WS_ONE_COLUMN'
,p_is_popup=>false
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/widget.stickyWidget.js',
'#IMAGE_PREFIX#libraries/apex/widget.stickyTableHeader.js'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// $(''.a-IRR-reportView'').setTableHeadersAsFixed();',
'//$(".js-stickyTableHeader").stickyWidget({',
'//   toggleWidth: true',
'//});'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/core/WizardSteps.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="wsPaddedContentContainer">',
'#BODY#',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_help_pop_up
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(11249921373943607.4907)
,p_theme_id=>3
,p_name=>'[EBA] Help Pop Up.zh-tw'
,p_internal_name=>'[EBA]_HELP_POP_UP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="wsPopup ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE." class="wsPopup"> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body #ONLOAD# class="wsPopup">',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="wsPopUpHeader">',
'#REGION_POSITION_02#',
'</div>',
'<div class="wsPopUpContent">',
'  <div class="wsSideCol">',
'#REGION_POSITION_03#',
'  </div>',
'  <div class="wsMainCol">',
'#BODY#',
'  </div>',
'<div class="clear"></div>',
'</div>',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_ws_two_panel_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(15627530893704526.4907)
,p_theme_id=>3
,p_name=>'[EBA] WS Two Panel Page.zh-tw'
,p_internal_name=>'[EBA]_WS_TWO_PANEL_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_03#',
'	<div class="ebaTwoColPane">',
'		<div class="ebaSideCol contentSection" id="wsSideCol">',
'					<h2 class="leftButtons">',
'			#REGION_POSITION_05#',
'					</h2>',
'			#REGION_POSITION_06#',
'		</div>',
'		<div class="ebaMainCol contentSection">',
'			#REGION_POSITION_04#',
'			<div class="ebaMainColContentContainer">',
'				<div class="ebaContent ebaOneCol">',
'					#BODY#',
'				</div> <!-- End .ebaContent .ebaOneCol -->',
'			</div> <!-- End .wsMainColContentContainer -->',
'		</div> <!-- End .ebaMainCol contentSection -->',
'	</div> <!-- End .ebaTwoColPane -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_login_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(53193408981633671.4907)
,p_theme_id=>3
,p_name=>'[EBA] Login Page.zh-tw'
,p_internal_name=>'[EBA]_LOGIN_PAGE'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame ebaWizardFrame ebaLoginWizard">',
'<div class="ebaFrameHeader">',
'		<h1 class="oracleLogo">',
'			#LOGO#',
'		</h1>',
'		<div class="ebaProgressBar">',
'#REGION_POSITION_02#',
'		</div>',
'</div> <!-- End .ebaFrameHeader -->',
'<div class="ebaContentContainer">',
'	<div class="ebaContent">',
'<div class="websheetsIcon">',
'#REGION_POSITION_03#',
'</div>',
'<div class="loginFormFields">',
'#BODY#',
'</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'	<div class="ebaFrameFooter">',
'#REGION_POSITION_04#',
'<span>',
'#REGION_POSITION_05#',
'</span>',
'	</div>',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>6
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_presentation_view
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(75962824844186301.4907)
,p_theme_id=>3
,p_name=>'[EBA] Presentation View.zh-tw'
,p_internal_name=>'[EBA]_PRESENTATION_VIEW'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_presentation.css" type="text/css" />',
'	<script src="#IMAGE_PREFIX#ws/js/ws_presentation.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div id="wspToolbar">',
'	#REGION_POSITION_01#',
'</div>',
'<div class="wspSectionContainer" aria-live="polite">',
'#BODY#',
'</div>',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/eba_pop_up
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(134255203486851095.4907)
,p_theme_id=>3
,p_name=>'[EBA] Pop Up.zh-tw'
,p_internal_name=>'[EBA]_POP_UP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="wsPopup ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="wsPopup ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE." class="wsPopup"> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body #ONLOAD# class="wsPopup">',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="wsPopUpHeader">',
'#REGION_POSITION_02#',
'</div>',
'<div class="wsPopUpContent simplePopUp paddedPopUp">',
'  <div class="wsMainCol">',
'#BODY#',
'  </div>',
'<div class="clear"></div>',
'</div>',
'#REGION_POSITION_04#',
'#REGION_POSITION_05#',
'#REGION_POSITION_06#',
'#REGION_POSITION_07#',
'#REGION_POSITION_08#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage is-success" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'#SUCCESS_MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="wsPageMessage" role="alert">',
'<h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'#MESSAGE#',
'<a href="javascript:void()" onclick="$x_Remove(''wsPageMessage'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#"/></a>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_0_websheets_printer_friendly
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(636311004626147097.4907)
,p_theme_id=>3
,p_name=>'APEX 4.0 - WEBSHEETS (printer friendly).zh-tw'
,p_internal_name=>'APEX_4.0_WEBSHEETS_PRINTER_FRIENDLY'
,p_is_popup=>false
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'div.wsSection h2 span,',
'div.wsFooter ul.wsViewModes,',
'span.wsBreadcrumbBarLinks,',
'div.wsSection h2 a.wsSectionControl,',
'.ebaHeader ul,',
'.ebaFrameHeader,',
'.wsSideSection {',
'    display: none !important;',
'}',
'body .ebaHeader h1 a {',
'    color: #000;',
'    text-shadow: none;',
'}',
'body .ebaHeader {',
'    background: none #F8FBFF;',
'}',
'body div.wsBreadcrumb>ul>li>a {',
'    border: none;',
'}'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html lang="&BROWSER_LANGUAGE." class="ie6 no-css3"> <![endif]-->',
'<!--[if IE 7 ]>    <html lang="&BROWSER_LANGUAGE." class="ie7 no-css3"> <![endif]-->',
'<!--[if IE 8 ]>    <html lang="&BROWSER_LANGUAGE." class="ie8 no-css3"> <![endif]-->',
'<!--[if IE 9 ]>    <html lang="&BROWSER_LANGUAGE." class="ie9"> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'	<title>#TITLE#</title>',
'	<link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'	',
'	#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#libraries/jquery-qtip2/2.0-6.26.2011/jquery.qtip.min.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'	<!--[if IE 7]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'	<![endif]-->',
'	<!--[if IE 8]>',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'	<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'	<![endif]-->',
'	<script src="#IMAGE_PREFIX#libraries/apex/actions.js" type="text/javascript" charset="utf-8"></script>',
'	<script src="#IMAGE_PREFIX#ws/js/ws.js" type="text/javascript" charset="utf-8"></script> ',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'	<!--[if lte IE 8]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'	#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_01#',
'<div class="ebaFrame">',
'<div class="ebaFrameHeader">',
'	<div class="wsToolbar">',
'		<div class="wsToolbarLeft">',
'#REGION_POSITION_02#',
'		</div>',
'		<div class="wsToolbarRight">',
'#REGION_POSITION_08#',
'		</div>',
'	</div>',
'	<div class="clear"></div>',
'</div> <!-- End .wsToolbar -->',
'<div class="ebaContentContainer">',
'#REGION_POSITION_04#',
'	<div class="ebaContent ebaOneCol">',
'#REGION_POSITION_03#',
'		<div class="wsPaddedContentContainer">',
'#BODY#',
'#REGION_POSITION_05#',
'		</div>',
'	</div> <!-- End .ebaContent -->',
'</div> <!-- End .ebaContentContainer -->',
'#REGION_POSITION_07#',
'</div> <!-- End .ebaFrame -->',
'#REGION_POSITION_06#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
''))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_websheets_sign_in_page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1418140425267007336.4907)
,p_theme_id=>3
,p_name=>'APEX 5.0 - Websheets Sign In Page.zh-tw'
,p_internal_name=>'APEX_5.0_WEBSHEETS_SIGN_IN_PAGE'
,p_is_popup=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$(function() {',
'  $(''a[href*="#"]:not([href="#"])'').click(function() {',
'    if (location.pathname.replace(/^\//,'''') == this.pathname.replace(/^\//,'''') && location.hostname == this.hostname) {',
'      var target = $(this.hash);',
'      target = target.length ? target : $(''[name="'' + this.hash.slice(1) +''"]'');',
'      if (target.length) {',
'        $(''html,body'').animate({',
'          scrollTop: target.offset().top',
'        }, 500);',
'        return false;',
'      }',
'    }',
'  });',
'});'))
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--[if HTML5]><![endif]-->',
'<!doctype html>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'',
'<!--[if lt IE 7 ]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 7 ]>    <html class="no-js lt-ie9 lt-ie8 ie7" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 8 ]>    <html class="no-js lt-ie9 ie8" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if IE 9 ]>    <html class="no-js ie9" lang="&BROWSER_LANGUAGE."> <![endif]-->',
'<!--[if (gt IE 9)|!(IE)]><!--> <html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE."> <!--<![endif]-->',
'<head>',
'  <meta charset="UTF-8" />',
'  <title>#TITLE#</title>',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#ws/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#ws/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#ws/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#ws/favicon-180x180.png">',
'  ',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--login #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'<div class="u-Layout u-Layout--centerVertically a-Login-slide" id="top">',
'  #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'  <div class="a-Login-container">',
'  #BODY#',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_image_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(3791820543327.4907)
,p_template_name=>'HTML image (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_IMAGE_LEGACY_APEX_5_MIGRATION'
,p_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_hot_template=>'<a href="#LINK#" id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#BUTTON_CSS_CLASSES#" alt="#LABEL!ATTR#" border="#" #BUTTON_ATTRIBUTES# /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_add_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(9301120013126533.4907)
,p_template_name=>'[EBA] Title - Add Button'
,p_internal_name=>'[EBA]_TITLE_ADD_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="addIcon" #BUTTON_ATTRIBUTES# id="#BUTTON_ID" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_view_all_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(9301209409132905.4907)
,p_template_name=>'[EBA] Title - View All Button'
,p_internal_name=>'[EBA]_TITLE_VIEW_ALL_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button"><img src="#IMAGE_PREFIX#f_spacer.gif" class="viewAllIcon" #BUTTON_ATTRIBUTES# id="#BUTTON_ID" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_hot_button_next
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(10604003722246228.4907)
,p_template_name=>'[EBA] Hot Button (Next)'
,p_internal_name=>'[EBA]_HOT_BUTTON_NEXT'
,p_template=>'<a href="#LINK#" class="ebaHotButton ebaNextButton" role="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15106902867837483.4907)
,p_template_name=>'[EBA] Button'
,p_internal_name=>'[EBA]_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaButton" id="#BUTTON_ID#" role="button" #BUTTON_ATTRIBUTES#>#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_hot_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15108012910840408.4907)
,p_template_name=>'[EBA] Hot Button'
,p_internal_name=>'[EBA]_HOT_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaHotButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_button_delete
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15160928947568323.4907)
,p_template_name=>'[EBA] Button (Delete)'
,p_internal_name=>'[EBA]_BUTTON_DELETE'
,p_template=>'<a href="#LINK#" class="ebaButton ebaDeleteButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_options_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15650119453846225.4907)
,p_template_name=>'[EBA] Title - Options Button'
,p_internal_name=>'[EBA]_TITLE_OPTIONS_BUTTON'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="addIcon" #BUTTON_ATTRIBUTES# id="#BUTTON_ID" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_back_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(15650219931855856.4907)
,p_template_name=>'[EBA] Title - Back Button '
,p_internal_name=>'[EBA]_TITLE_BACK_BUTTON_'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="backIcon"/></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_title_expand_collapse_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(16714408571357214.4907)
,p_template_name=>'[EBA] Title - Expand/Collapse Button '
,p_internal_name=>'[EBA]_TITLE_EXPAND/COLLAPSE_BUTTON_'
,p_template=>'<a href="#LINK#" class="ebaTitleButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#" title="#LABEL!ATTR#"><img src="#IMAGE_PREFIX#f_spacer.gif" class="hideIcon" alt="#LABEL!ATTR#" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>6
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20457218105321816.4907)
,p_template_name=>'[EBA] Small Button'
,p_internal_name=>'[EBA]_SMALL_BUTTON'
,p_template=>'<a href="#LINK#" class="wsSmallButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_hot_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20480423759330923.4907)
,p_template_name=>'[EBA] Small Hot Button'
,p_internal_name=>'[EBA]_SMALL_HOT_BUTTON'
,p_template=>'<a href="#LINK#" class="wsSmallButton wsHotButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>4
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_button_previous
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20890400835826116.4907)
,p_template_name=>'[EBA] Small Button (Previous)'
,p_internal_name=>'[EBA]_SMALL_BUTTON_PREVIOUS'
,p_template=>'<a href="#LINK#" class="wsSmallButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="smallPrevIcon" /> #LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_hot_button_next
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20890726723852448.4907)
,p_template_name=>'[EBA] Small Hot Button (Next) '
,p_internal_name=>'[EBA]_SMALL_HOT_BUTTON_NEXT_'
,p_template=>'<a href="#LINK#" class="wsSmallButton wsHotButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML# <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="smallNextIcon" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_small_button_next
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(20905523503069232.4907)
,p_template_name=>'[EBA] Small Button (Next) '
,p_internal_name=>'[EBA]_SMALL_BUTTON_NEXT_'
,p_template=>'<a href="#LINK#" class="wsSmallButton" role="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML# <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="smallNextIcon" /></a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/eba_button_previous
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(61282809984809202.4907)
,p_template_name=>'[EBA] Button (Previous)'
,p_internal_name=>'[EBA]_BUTTON_PREVIOUS'
,p_template=>'<a href="#LINK#" class="ebaButton ebaPrevButton" role="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />#LABEL!HTML#</a>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/html_button_legacy_apex_5_migration
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(629231036412957099.4907)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_internal_name=>'HTML_BUTTON_LEGACY_APEX_5_MIGRATION'
,p_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>'<input type="button" value="#LABEL!ATTR#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_template_comment=>'5.0 upgrade'
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(798473351219404350.4907)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475.4907
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(936712837989177653.4907)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615.4907
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(936746267011392790.4907)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301.4907
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>3
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3700433754276.4907)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Div with ID'
,p_internal_name=>'DIV_WITH_ID'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>7
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_ws_side_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(9299916504097072.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSideSection">',
'	<h3>#TITLE#',
'		<span>',
'		#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#',
'		</span>',
'	</h3>',
'	#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] WS Side Region'
,p_internal_name=>'[EBA]_WS_SIDE_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_button_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(10604720260269861.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsButtonBar">',
'#BODY##CLOSE##EDIT##DELETE##PREVIOUS##CREATE##CHANGE##CREATE2##EXPAND##HELP##COPY##NEXT#</div>'))
,p_page_plug_template_name=>'[EBA] Button Region'
,p_internal_name=>'[EBA]_BUTTON_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_collapsable_text_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(11269620137104105.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSection" id="#REGION_STATIC_ID#"> <!-- Begin .wsSection -->',
'	<h2><a href="javascript:void(0)" class="wsSectionControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&COLLAPSE." /></a>',
'		#TITLE#',
'		<span>',
'			<a href="#" class="wsSectionLink wsTopLink" title="&GO_TO_TOP."><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&GO_TO_TOP." class="topIcon" /></a>',
'		</span>',
'	</h2>',
'	<div class="wsSectionContent">',
'		<div class="wsTextSection #REGION_ATTRIBUTES#">',
'			#BODY#',
'		</div>',
'	</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Collapsable Text Region'
,p_internal_name=>'[EBA]_COLLAPSABLE_TEXT_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_two_col_pane_heading_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(15634208564734334.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 #REGION_ATTRIBUTES#>',
'	<span class="leftButtons">',
'		#PREVIOUS#',
'	</span>',
'	#TITLE#',
'	<span>',
'		#EDIT##CLOSE##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'	</span>',
'</h2>',
'#BODY#'))
,p_page_plug_template_name=>'[EBA] Two Col Pane Heading Region'
,p_internal_name=>'[EBA]_TWO_COL_PANE_HEADING_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_two_col_pane_heading_left_col_with_control_menu
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(17121518626936007.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="leftButtons" #REGION_ATTRIBUTES#>#PREVIOUS##EXPAND##EDIT##CLOSE##DELETE##CREATE##CREATE2##HELP##COPY##NEXT# </span>',
'#TITLE#<span class="rightButtons" #REGION_ATTRIBUTES#>#CHANGE#</span>'))
,p_page_plug_template_name=>'[EBA] Two Col Pane Heading (Left Col with Control Menu)'
,p_internal_name=>'[EBA]_TWO_COL_PANE_HEADING_LEFT_COL_WITH_CONTROL_MENU'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_form_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20185117556737935.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsFormRegion">',
'#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Form Region'
,p_internal_name=>'[EBA]_FORM_REGION'
,p_theme_id=>3
,p_theme_class_id=>8
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_action_bar_top
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20454830409304572.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsActionBar">',
'#PREVIOUS#',
'#BODY#',
'<span class="wsActionBarRight">',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</span>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Action Bar Top'
,p_internal_name=>'[EBA]_ACTION_BAR_TOP'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_action_bar_bottom
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20910304550120452.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsActionBar wsActionBarBottom">',
'<div class="wsActionBarInside">',
'#PREVIOUS#',
'#BODY#',
'<span class="wsActionBarRight">',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</span>',
'</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Action Bar Bottom'
,p_internal_name=>'[EBA]_ACTION_BAR_BOTTOM'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_interactive_report_with_no_action_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(20956911766368602.4907)
,p_layout=>'TABLE'
,p_template=>'<div class="wsInteractiveReportOnly" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'[EBA] Interactive Report with No Action Bar'
,p_internal_name=>'[EBA]_INTERACTIVE_REPORT_WITH_NO_ACTION_BAR'
,p_theme_id=>3
,p_theme_class_id=>9
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_action_bar_only
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(25109627701530900.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsActionBar wsActionBarOnly" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'#PREVIOUS#',
'#BODY#',
'<span class="wsActionBarRight">',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</span>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Action Bar Only'
,p_internal_name=>'[EBA]_ACTION_BAR_ONLY'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_collapsable_form_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(27071223638280295.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSection"> <!-- Begin .wsSection -->',
'	<h2><a href="javascript:void(0)" class="wsSectionControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&COLLAPSE." /></a>',
'		#TITLE#',
'		<span>',
'			<a href="#" class="wsSectionLink wsTopLink" title="&GO_TO_TOP."><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&GO_TO_TOP." class="topIcon" /></a>',
'		</span>',
'	</h2>',
'	<div class="wsSectionContent">',
'		<div class="wsFormRegion">',
'			#BODY#',
'		</div>',
'	</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Collapsable Form Region '
,p_internal_name=>'[EBA]_COLLAPSABLE_FORM_REGION_'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_collapsable_form_region_collapsed
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(47316730240795884.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSection"> <!-- Begin .wsSection -->',
'	<h2><a href="javascript:void(0)" class="wsSectionControl wsSectionCollapsed"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&COLLAPSE." /></a>',
'		#TITLE#',
'		<span>',
'			<a href="#" class="wsSectionLink wsTopLink" title="&GO_TO_TOP."><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&GO_TO_TOP." class="topIcon" /></a>',
'		</span>',
'	</h2>',
'	<div class="wsSectionContent" style="display: none">',
'		<div class="wsFormRegion">',
'			#BODY#',
'		</div>',
'	</div>',
'</div>'))
,p_page_plug_template_name=>'[EBA] Collapsable Form Region (Collapsed) '
,p_internal_name=>'[EBA]_COLLAPSABLE_FORM_REGION_COLLAPSED_'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_small_form_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(82536903857665765.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsFormRegion wsSmallFormRegion">',
'#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Small Form Region'
,p_internal_name=>'[EBA]_SMALL_FORM_REGION'
,p_theme_id=>3
,p_theme_class_id=>8
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_small_form_component_left
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(108051114664442909.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsSmallFormComponent wsSmallFormComponentLeft" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'#PREVIOUS#',
'#BODY#',
'#CLOSE##EDIT##DELETE##CREATE##CREATE2##EXPAND##HELP##COPY##NEXT#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Small Form Component Left'
,p_internal_name=>'[EBA]_SMALL_FORM_COMPONENT_LEFT'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/dhtml_hidden_with_id_required_for_data_grid_file_upload
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(173336062654423126.4907)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_ID#" style="display:none;">#BODY#</div>'
,p_page_plug_template_name=>'(DHTML) Hidden with ID (Required for Data Grid File Upload)'
,p_internal_name=>'DHTML_HIDDEN_WITH_ID_REQUIRED_FOR_DATA_GRID_FILE_UPLOAD'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_toolbar_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(202707431395573866.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsMenu" id="#REGION_STATIC_ID#">',
'#BODY#',
'</div>'))
,p_page_plug_template_name=>'[EBA] Toolbar Container'
,p_internal_name=>'[EBA]_TOOLBAR_CONTAINER'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/div_with_id_required_for_edit_report_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(400020739576925060.4907)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Div  with ID ( Required for Edit Report Attributes)'
,p_internal_name=>'DIV_WITH_ID_REQUIRED_FOR_EDIT_REPORT_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>7
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(931543191007401308.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Alert'
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764.4907
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/eba_no_template
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1071999318750156264.4907)
,p_layout=>'TABLE'
,p_template=>'#BODY#'
,p_page_plug_template_name=>'[EBA] No Template'
,p_internal_name=>'[EBA]_NO_TEMPLATE'
,p_theme_id=>3
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1332151043262185426.4907)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#><h2 class="u-VisuallyHidden">#TITLE#</h2>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>'APEX 5.0 - Interactive Report Region'
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>3
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695.4907
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_workspace_login_region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1418149362592020763.4907)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Login-body">',
'  #BODY#',
'</div>',
'<div class="a-Login-buttons">',
'  #NEXT#',
'</div>',
'<div class="a-Login-links">',
'  #EDIT##CREATE#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Workspace Login Region'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_REGION'
,p_theme_id=>3
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>781637364422290692.4907
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_toolbar_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(9301809587170761.4907)
,p_list_template_current=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a></li>'
,p_list_template_noncurrent=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a></li>'
,p_list_template_name=>'[EBA] Toolbar Menu '
,p_internal_name=>'[EBA]_TOOLBAR_MENU_'
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>' '
,p_list_template_after_rows=>' '
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_noncurrent=>'<li class="#A01#"><a href="#LINK#" class="wsMenuItem #A04#">#TEXT#<span>#A02#</span></a></li>'
,p_item_templ_curr_w_child=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="#A01#"><a href="javascript:void(0)" id="#A03#">#TEXT#<img src="#IMAGE_PREFIX#ws/img/spacer.gif" alt="" /></a>#SUB_LISTS#</li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_pop_up_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(11252405836967523.4907)
,p_list_template_current=>'--><li class="active"><a href="#LINK#">#TEXT#</a></li><!--'
,p_list_template_noncurrent=>'--><li><a href="#LINK#">#TEXT#</a></li><!--'
,p_list_template_name=>'[EBA] Pop Up Tabs'
,p_internal_name=>'[EBA]_POP_UP_TABS'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsTabs">',
'  <ul><!-- '))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'--><li class="searchBox">',
'    <div class="wsSearch" style="display: none;">',
'      <input type="text" id="wsSearchBar"/>',
'      <span></span>',
'    </div>',
'  </li>',
'</ul>',
'</div>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_pop_up_side_navigation
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(11270206893119252.4907)
,p_list_template_current=>'<li><a href="#LINK#" class="active">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'[EBA] Pop Up Side Navigation'
,p_internal_name=>'[EBA]_POP_UP_SIDE_NAVIGATION'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_left_pane_sections_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(15654631677982271.4907)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="javascript:applyAndGoToNextSection(''&APP_PAGE_ID.'',''#A06#'',''#A07#'',''#A08#'');" class="#A05#" title="#A02#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#A02#" /></span>',
'		<h3>#TEXT_ESC_SC#',
'			<em>#A03# &mdash; #A04#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#A02#" /></span>',
'		<h3>#TEXT_ESC_SC#',
'			<em>#A03# &mdash; #A04#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_name=>'[EBA] Left Pane Sections List'
,p_internal_name=>'[EBA]_LEFT_PANE_SECTIONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<ul class="sectionList">'
,p_list_template_after_rows=>' </ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_heading_control_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(17118702088912337.4907)
,p_list_template_current=>'<a href="#LINK#" class="ebaTitleButton"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#TEXT#" title="#TEXT#"/></a>'
,p_list_template_noncurrent=>'<a href="#LINK#" class="ebaTitleButton"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#"  alt="#TEXT#" title="#TEXT#"/></a>'
,p_list_template_name=>'[EBA] Heading Control Menu'
,p_internal_name=>'[EBA]_HEADING_CONTROL_MENU'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<span class="controlMenus">'
,p_list_template_after_rows=>' </span>'
,p_before_sub_list=>'<div class="panelMenuContainer"><div class="panelMenu"><ul>'
,p_after_sub_list=>'</ul></div></div>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<a href="#LINK#" class="ebaTitleButton controlMenu"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#TEXT#" title="#TEXT#"/></a>'
,p_item_templ_noncurr_w_child=>'<a href="#LINK#" class="ebaTitleButton controlMenu"><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" alt="#TEXT#" title="#TEXT#"/></a>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_horizontal_progress_bar_train
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(17197023652325418.4907)
,p_list_template_current=>'<li class="currentStep"><span></span></li>'
,p_list_template_noncurrent=>'<li><span></span></li>'
,p_list_template_name=>'[EBA] Horizontal Progress Bar Train'
,p_internal_name=>'[EBA]_HORIZONTAL_PROGRESS_BAR_TRAIN'
,p_theme_id=>3
,p_theme_class_id=>17
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="ebaProgressWizard">',
''))
,p_list_template_after_rows=>' </ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_left_pane_pages_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(18574125863745642.4907)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#" class="#A04#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" /></span>',
'		<h3>#TEXT#',
'			<em>#A02# &mdash; #A03#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">',
'		<span><img src="#IMAGE_PREFIX#f_spacer.gif" class="#A01#" /></span>',
'		<h3>#TEXT#',
'			<em>#A02# &mdash; #A03#</em></h3>',
'	</a>',
'</li>'))
,p_list_template_name=>'[EBA] Left Pane Pages List '
,p_internal_name=>'[EBA]_LEFT_PANE_PAGES_LIST_'
,p_theme_id=>3
,p_theme_class_id=>9
,p_list_template_before_rows=>'<ul class="sectionList">'
,p_list_template_after_rows=>' </ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_unformatted_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(20455926267312733.4907)
,p_list_template_current=>'<li><a href="#LINK#" class="active">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'[EBA] Unformatted List'
,p_internal_name=>'[EBA]_UNFORMATTED_LIST'
,p_theme_id=>3
,p_theme_class_id=>3
,p_list_template_before_rows=>' <ul>'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_large_icons_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(138239722779443444.4907)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="" alt="" /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
,p_list_template_name=>'[EBA] Large Icons List'
,p_internal_name=>'[EBA]_LARGE_ICONS_LIST'
,p_theme_id=>3
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table class="ebaLargeIcons" width="100%" cellspacing="0" cellpadding="0" border="0" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist_from_4999
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(156210646767386810.4907)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><img src="#IMAGE_PREFIX#ws/dropdown_32x24.gif" width="32" height="24" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#L'
||'IST_ITEM_ID#'',false)" alt=""/><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></a><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_list_template_name=>'DHTML List (Image) with Sublist from 4999'
,p_internal_name=>'DHTML_LIST_IMAGE_WITH_SUBLIST_FROM_4999'
,p_theme_id=>3
,p_theme_class_id=>4
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">',
'<li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'))
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" />#TEXT#</li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<div class="dhtmlMenuItem"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="dhtmlMenu" onclick="ws_Pd(this,''#LIST_ITEM_ID#'',false)" alt=""/><a href="#LINK#" class="dhtmlBottom" title="#TEXT_ESC_SC#">#TEXT#</a></div>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /><span>#TEXT#</span><img class="htmldbMIMG" alt="" s'
||'rc="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#" style="background-image:url(#IMAGE_PREFIX#menu_open_right2.gif);background-repeat:no-repeat;background-position:95% cente'
||'r;"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</a></li>'
,p_list_template_comment=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')" title="#TEXT_ESC_SC#"><span><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />#TEXT#</span><img class="htmldbMIMG" alt="" s'
||'rc="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/eba_left_pane_pages_list_new
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(158861503239501998.4907)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_list_template_name=>'[EBA] Left Pane Pages List [NEW]'
,p_internal_name=>'[EBA]_LEFT_PANE_PAGES_LIST_[NEW]'
,p_theme_id=>3
,p_theme_class_id=>19
,p_list_template_before_rows=>' <ul class="pageList" id="pageList">'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03#">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="-" /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="#A03# containsSubList">',
'	<div class="pageListOut"><div class="pageListIn">',
'		<a href="javascript:void(0)" class="listControl expanded"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="&EXPANDED." /></a>',
'		<a href="#LINK#">',
'			#TEXT_ESC_SC#',
'				<em>#A01# &mdash; #A02#</em>',
'		</a>',
'	</div></div>',
'</li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_websheets_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(929122129315135247.4907)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Websheets Menu'
,p_internal_name=>'APEX_5.0_WEBSHEETS_MENU'
,p_theme_id=>3
,p_theme_class_id=>7
,p_list_template_before_rows=>' '
,p_list_template_after_rows=>' '
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>926415475390827132.4907
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(936708315591140469.4907)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>3
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129.4907
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1338174060370978758.4907)
,p_list_template_current=>'<li class="a-WizardSteps-step is-active"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"><'
||'/span></span></div></li>'
,p_list_template_noncurrent=>'<li class="a-WizardSteps-step is-inactive"><div class="a-WizardSteps-wrap"><span class="a-WizardSteps-marker"><span class="a-Icon icon-wizard-step-complete"></span></span><span class="a-WizardSteps-label">#TEXT# <span class="a-WizardSteps-labelState"'
||'></span></span></div></li>'
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>3
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="a-WizardSteps #COMPONENT_CSS_CLASSES#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310.4907
);
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_report_sortable
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(46784125242633572.4907)
,p_row_template_name=>'[EBA] Report (Sortable)'
,p_internal_name=>'[EBA]_REPORT_SORTABLE'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>'<table class="wsStandardReport wsTable" summary="" cellspacing="0" cellpadding="0" id="r#REGION_ID#"><tbody>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>',
'<script>',
'var g_#REGION_ID#;',
'function f_#REGION_ID#(){',
'		g_#REGION_ID# =  new apex.tabular.sort(''r#REGION_ID#'');',
'		g_#REGION_ID#.row.after_move = function(){rpreview()}',
'}',
'addLoadEvent(f_#REGION_ID#)',
'</script>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#EEE'
,p_row_style_checked=>'#EEE'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(46784125242633572.4907)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(129228711620465473.4907)
,p_row_template_name=>'[EBA] Report'
,p_internal_name=>'[EBA]_REPORT'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>'<table class="wsStandardReport wsTable" summary="" cellspacing="0" cellpadding="0" id="r#REGION_ID#"><tbody>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#EEE'
,p_row_style_checked=>'#EEE'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(129228711620465473.4907)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_portlet_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(171646109232237656.4907)
,p_row_template_name=>'[EBA] Portlet Column'
,p_internal_name=>'[EBA]_PORTLET_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>0
,p_reference_id=>43020300221196425.4907
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/eba_portlet_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(171646521495237685.4907)
,p_row_template_name=>'[EBA] Portlet Row'
,p_internal_name=>'[EBA]_PORTLET_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'<th><label>#1#</label></th>',
'<td>#2#</td>',
'</tr>'))
,p_row_template_before_rows=>'<table class="wsTable wsPortlet" #REPORT_ATTRIBUTES# id="#REGION_ID#">'
,p_row_template_after_rows=>'</table>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>3
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(5556614497310460.4907)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>3
,p_theme_class_id=>13
,p_reference_id=>4903009179971452.4907
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/eba_optional_w_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(11461002620401386.4907)
,p_template_name=>'[EBA] Optional w/ Help'
,p_internal_name=>'[EBA]_OPTIONAL_W/_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="wsOptional">'
,p_template_body2=>'</label>'
,p_after_element=>'#HELP_TEMPLATE#'
,p_help_link=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button">',
'    <span class="a-Icon icon-help"></span>',
'    <span class="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span>',
'</button>'))
,p_on_error_after_label=>'<span class="wsLabelError">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/eba_required_w_help
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(11461206197401386.4907)
,p_template_name=>'[EBA] Required w/ Help'
,p_internal_name=>'[EBA]_REQUIRED_W/_HELP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="wsRequired">'
,p_template_body2=>' <img src="#IMAGE_PREFIX#f_spacer.gif" alt="#VALUE_REQUIRED#" class="wsAsterisk" /></label>'
,p_after_element=>'#HELP_TEMPLATE#'
,p_help_link=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button">',
'    <span class="a-Icon icon-help"></span>',
'    <span class="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span>',
'</button>'))
,p_on_error_after_label=>'<span class="wsLabelError">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_workspace_login_hidden_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(264000229814622656.4907)
,p_template_name=>'Login Hidden Label'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_HIDDEN_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Icon a-Login-iconLabel a-Login-hiddenLabel u-VisuallyHidden">'
,p_template_body2=>'</label>'
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--hiddenLabel #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#"><div class="a-Form-inputContainer">'
,p_after_item=>'#HELP_TEMPLATE#</div></div>'
,p_after_element=>'#ERROR_TEMPLATE#'
,p_help_link=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button">',
'    <span class="a-Icon icon-help"></span>',
'    <span class="u-VisuallyHidden">#CURRENT_ITEM_HELP_LABEL#</span>',
'</button>'))
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_workspace_login_label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1418153120551046350.4907)
,p_template_name=>'APEX 5.0 - Workspace Login Label'
,p_internal_name=>'APEX_5.0_WORKSPACE_LOGIN_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Icon a-Login-iconLabel">'
,p_template_body2=>'</label>'
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#"><div class="a-Form-inputContainer">'
,p_after_item=>'</div></div>'
,p_after_element=>'<span class="a-Login-iconValidation a-Icon icon-check"></span>#ERROR_TEMPLATE#'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help"></span><span class="u-VisuallyHidden">#CURRENT_ITE'
||'M_HELP_LABEL#</span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>3
,p_theme_class_id=>4
,p_reference_id=>781637020106265852.4907
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/eba_breadcrumbs
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(20175617163709368.4907)
,p_name=>'[EBA] Breadcrumbs'
,p_internal_name=>'[EBA]_BREADCRUMBS'
,p_before_first=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsBreadcrumb wsBreadcrumbSubPage" id="wsBreadcrumb">',
'<ul class="ws-Breadcrumb">',
''))
,p_current_page_option=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">#NAME# <span class="a-Icon icon-right-chevron"></span></a>',
'</li>',
''))
,p_non_current_page_option=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li>',
'	<a href="#LINK#">#NAME# <span class="a-Icon icon-right-chevron"></span></a>',
'</li>',
''))
,p_after_last=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'</div>'))
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(165003451930708292.4907)
,p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif'
,p_popup_icon_attr=>'width="18" height="18" alt="#LIST_OF_VALUES#" title="#LIST_OF_VALUES#"'
,p_page_name=>'winlov'
,p_page_title=>unistr('\641C\5C0B')
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#APEX_JAVASCRIPT#',
'<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=edge" /><![endif]-->',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe.css" type="text/css" />',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws.css" type="text/css" />',
'<!--[if IE 7]>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie7.css" type="text/css" />',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie7.css" type="text/css" />',
'<![endif]-->',
'<!--[if IE 8]>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/eba_uniframe_ie8.css" type="text/css" />',
'<link rel="stylesheet" href="#IMAGE_PREFIX#ws/css/ws_ie8.css" type="text/css" />',
'<![endif]-->',
'#THEME_CSS#',
'</head>'))
,p_page_body_attr=>'class="wsPopUpLOV"'
,p_before_field_text=>'<div class="wsActionBar wsActionBarOnly">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="searchField"'
,p_find_button_text=>unistr('\641C\5C0B')
,p_find_button_attr=>'class="smallButton"'
,p_close_button_text=>unistr('\95DC\9589')
,p_close_button_attr=>'class="smallButton hotButton"'
,p_next_button_text=>unistr('\4E0B\4E00\6B65 >')
,p_next_button_attr=>'class="smallButton"'
,p_prev_button_text=>unistr('< \4E0A\4E00\6B65')
,p_prev_button_attr=>'class="smallButton"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'500'
,p_result_row_x_of_y=>unistr('<div class="lovPagination">\8CC7\6599\5217  #FIRST_ROW# - #LAST_ROW#</div>')
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="lovLinks">'
,p_theme_id=>3
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/eba_calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(20940421004163137.4907)
,p_cal_template_name=>'[EBA] Calendar'
,p_internal_name=>'[EBA]_CALENDAR'
,p_day_of_week_format=>'<th scope="col" class="DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="CalendarHolder"> ',
' <tr>',
'   <td class="MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="Calendar">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="WeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th scope="col" class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th scope="row" class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" class="DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" role="presentation" class="DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL#" class="DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th scope="row" class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>3
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(931574038306409142.4907)
,p_theme_id=>3
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(931574723130409146.4907)
,p_theme_id=>3
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(936751341799414713.4907)
,p_theme_id=>3
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931573772023409139.4907)
,p_theme_id=>3
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931573860104409140.4907)
,p_theme_id=>3
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574184140409145.4907)
,p_theme_id=>3
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574386836409146.4907)
,p_theme_id=>3
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574519466409146.4907)
,p_theme_id=>3
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931574894275409146.4907)
,p_theme_id=>3
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(931574723130409146)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931575094854409146.4907)
,p_theme_id=>3
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_api.id(931574723130409146)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931575149476409146.4907)
,p_theme_id=>3
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(931575333122409146.4907)
,p_theme_id=>3
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(931543191007401308.4907)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_api.id(931574038306409142)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(936709001085140492.4907)
,p_theme_id=>3
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(936708315591140469.4907)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(936709194813140492.4907)
,p_theme_id=>3
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(936708315591140469.4907)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1338174721014978766.4907)
,p_theme_id=>3
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832103532526804.4907)
,p_theme_id=>3
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_api.id(1332151043262185426.4907)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832278061526804.4907)
,p_theme_id=>3
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1332151043262185426.4907)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1554832317693526804.4907)
,p_theme_id=>3
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1332151043262185426.4907)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(239986615251259134.4907)
,p_build_option_name=>'Do Not Include in APEX 4.2 EA1'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618373063883494)
,p_name=>'ADD'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616464420883493)
,p_name=>'ADD_COLUMN'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617668023883494)
,p_name=>'ADD_FILE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\6A94\6848')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617852078883494)
,p_name=>'ADD_LINK'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\9023\7D50')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617702809883494)
,p_name=>'ADD_NOTE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\9644\8A3B')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618588977883494)
,p_name=>'ADD_ROW'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\8CC7\6599\5217')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617922510883494)
,p_name=>'ADD_TAGS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\65B0\589E\6A19\8A18')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616162341883493)
,p_name=>'APPLY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5957\7528')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286615948183883492)
,p_name=>'CANCEL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\6D88')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618296743883494)
,p_name=>'COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616790985883493)
,p_name=>'COLUMN_GROUPS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\7FA4\7D44')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616558312883493)
,p_name=>'COLUMN_PROPERTIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\6B04\7279\6027')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616273096883493)
,p_name=>'COPY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617490305883493)
,p_name=>'COPY_DATA_GRID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8907\88FD\8CC7\6599\65B9\683C')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616351249883493)
,p_name=>'DATA_GRID_PROPERTIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\65B9\683C\7279\6027')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616087634883493)
,p_name=>'DELETE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616938926883493)
,p_name=>'DELETE_COLUMNS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8CC7\6599\6B04')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617559082883493)
,p_name=>'DELETE_DATA_GRID'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8CC7\6599\65B9\683C')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617380660883493)
,p_name=>'DELETE_ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\522A\9664\8CC7\6599\5217')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618782909883494)
,p_name=>'EDIT_ATTRIBUTES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\5C6C\6027')
,p_is_js_message=>true
);
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618845244883494)
,p_name=>'EDIT_QUERY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7DE8\8F2F\67E5\8A62')
,p_is_js_message=>true
);
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617213863883493)
,p_name=>'FILL'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\586B\5165')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618666427883494)
,p_name=>'HISTORY'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\6B77\53F2\8A18\9304')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616607757883493)
,p_name=>'LIST_OF_VALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\503C\6E05\55AE')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618062211883494)
,p_name=>'PROPERTIES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\7279\6027')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617197829883493)
,p_name=>'REPLACE'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\53D6\4EE3')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618460389883494)
,p_name=>'ROWS'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8CC7\6599\5217')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286617025262883493)
,p_name=>'SET_COLUMN_VALUES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\8A2D\5B9A\8CC7\6599\6B04\503C')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286618170135883494)
,p_name=>'TOGGLE_CHECKBOXES'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\5207\63DB\6838\53D6\65B9\584A')
,p_is_js_message=>true
);
null;
end;
/
begin
wwv_flow_api.create_message(
 p_id=>wwv_flow_api.id(286616810949883493)
,p_name=>'VALIDATION'
,p_message_language=>'zh-tw'
,p_message_text=>unistr('\9A57\8B49')
,p_is_js_message=>true
);
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(7176806101815144.4907)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\78BA\5B9A\8981\96E2\958B\6B64\9801\9762\4E14\4E0D\5132\5B58\55CE?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(155157613934985128.4907)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>unistr('\8981\57F7\884C\6B64\522A\9664\52D5\4F5C\55CE?')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/pick_ws_rpt_col_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(184021228934805221.4907)
,p_shortcut_name=>'PICK_WS_RPT_COL_NAME'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3050:&SESSION.::::P3050_CALLING_ITEM,P3050_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3010_LB_WS_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0" w'
||unistr('idth="18" height="18" alt="\624B\96FB\7B52" /></a>')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/pick_ws_rpt_col_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(185539627466561397.4907)
,p_shortcut_name=>'PICK_WS_RPT_COL_VALUE'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.::::P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3010_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0'
||unistr('" width="18" height="18" alt="\624B\96FB\7B52" /></a>')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/pick_curr_ws_rpt_col
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(185548307614697562.4907)
,p_shortcut_name=>'PICK_CURR_WS_RPT_COL'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.::::P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3010_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0'
||unistr('" width="18" height="18" alt="\624B\96FB\7B52" /></a>')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/p3020_pick_curr_ws_rpt_col
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(187888728094279874.4907)
,p_shortcut_name=>'P3020_PICK_CURR_WS_RPT_COL'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.::::P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3020_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0'
||unistr('" width="18" height="18" alt="\624B\96FB\7B52" /></a>')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/p3020_pick_ws_rpt_col_name
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(187889809179283856.4907)
,p_shortcut_name=>'P3020_PICK_WS_RPT_COL_NAME'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3050:&SESSION.::::P3050_CALLING_ITEM,P3050_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3020_LB_WS_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0" w'
||unistr('idth="18" height="18" alt="\624B\96FB\7B52" /></a>')
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/p3020_pick_ws_rpt_col_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(187890114027285273.4907)
,p_shortcut_name=>'P3020_PICK_WS_RPT_COL_VALUE'
,p_shortcut_type=>'HTML_TEXT'
,p_shortcut=>'<a href="javascript:popUp2(''f?p=&APP_ID.:3040:&SESSION.:::3040:P3040_CALLING_ITEM,P3040_WEBSHEET_ID:#CURRENT_ITEM_NAME#,''+$v(''P3020_WEBSHEET_ID''),320,400);" tabindex="999" title="" class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" borde'
||unistr('r="0" width="18" height="18" alt="\624B\96FB\7B52" /></a>')
);
end;
/
prompt --application/shared_components/security/authentications/internal_websheet_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(709672827800503408.4907)
,p_name=>'Internal Websheet Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.AUTHENTICATION.WEBSHEET'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=4900:101:&APP_SESSION.'
,p_cookie_name=>'-NO_COOKIE-'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(65218046382244660.4907)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>unistr('\641C\5C0B\65B9\584A')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442.4907
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513167447444230024.4907)
,p_plugin_id=>wwv_flow_api.id(65218046382244660.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513167803753230024.4907)
,p_plugin_id=>wwv_flow_api.id(65218046382244660.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_clob_textarea
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(377419101248577827.4907)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.CLOB_TEXTAREA'
,p_display_name=>unistr('CLOB \6587\5B57\5340')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.CLOB_TEXTAREA'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_clob_textarea'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_clob_textarea'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:ELEMENT:WIDTH:HEIGHT'
,p_substitute_attributes=>false
,p_reference_id=>200125518386793215.4907
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513356480445479112.4907)
,p_plugin_id=>wwv_flow_api.id(377419101248577827.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'SQL or PL/SQL to get CLOB value'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>false
,p_display_length=>80
,p_sql_min_column_count=>1
,p_sql_max_column_count=>1
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This item supports sql statements, like',
'<pre>',
'select big_data',
'from my_table',
'where id=:P4711_ID',
'</pre>',
'and function results, like',
'<pre>',
'return wwv_flow_xxx.get_big_data(p_id => :P4711_ID);',
'</pre>',
'to get a clob value for rendering.',
'',
'To write the data back, the CLOB Textarea makes an AJAX call before the actual page submit, which stores the clob value in wwv_flow_collections.clob001, with a collection name that equals the item name.',
'Developers can then define a page process that stores the clob value where it belongs, either directly',
'<pre>',
'update my_table',
'   set big_data = (select clob001',
'                     from wwv_flow_collections',
'                    where collection_name=''P4711_BIG_DATA'')',
' where id = :P4711_ID;',
'</pre>',
'or via the built-in function wwv_flow_f4000_plugins.get_clob_textarea_value:',
'',
'<pre>',
'update my_table',
'   set agreement_text = wwv_flow_f4000_plugins.get_clob_textarea_value(''P4711_BIG_DATA'')',
' where id = :P4711_ID;',
'</pre>',
''))
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1513356893048479113.4907)
,p_plugin_id=>wwv_flow_api.id(377419101248577827.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Textarea Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'HTML'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1513357286353479114.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1513356893048479113.4907)
,p_display_sequence=>10
,p_display_value=>'HTML Textarea'
,p_return_value=>'HTML'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1513357742751479114.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1513356893048479113.4907)
,p_display_sequence=>20
,p_display_value=>'Rich Text Editor'
,p_return_value=>'CKEDITOR-Full'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_data_grid
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(596503234954274806.4907)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.DATA_GRID'
,p_display_name=>unistr('\8CC7\6599\65B9\683C')
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.DATA_GRID'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_data_grid'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_data_grid'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_help_text=>unistr('\986F\793A\300C\8CC7\6599\65B9\683C\300DApplication Express \5C0F\5DE5\5177.')
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(615743690109519472.4907)
,p_plugin_id=>wwv_flow_api.id(596503234954274806.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Worksheet ID Item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>true
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(615744471837526561.4907)
,p_plugin_id=>wwv_flow_api.id(596503234954274806.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Show Checkbox Item'
,p_attribute_type=>'PAGE ITEM'
,p_is_required=>false
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(632128835511089827.4907)
,p_plugin_id=>wwv_flow_api.id(596503234954274806.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Checks SQL Enabled'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_authentication_websheet
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(709653022821492509.4907)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.AUTHENTICATION.WEBSHEET'
,p_display_name=>unistr('\5167\90E8 Web \8A66\7B97\8868\8A8D\8B49')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.AUTHENTICATION.WEBSHEET'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_f4900.callback'
,p_session_sentry_function=>'wwv_flow_authentication_f4900.session_sentry'
,p_invalid_session_function=>'wwv_flow_authentication_f4900.invalid_session'
,p_post_logout_function=>'wwv_flow_authentication_f4900.post_logout'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1129000224849873155.4907)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>unistr('\958B\767C\4EBA\54E1\6388\6B0A')
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in apex_plugin.t_authorization,',
'    p_plugin        in apex_plugin.t_plugin )',
'    return apex_plugin.t_authorization_exec_result',
'is',
'    l_result               apex_plugin.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12506617921221692.4907
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_plugin_id=>wwv_flow_api.id(1129000224849873155.4907)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129000814405873158.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129001313664873159.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129001807630873159.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129002315248873160.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129002821612873160.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129003318368873161.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129003820421873162.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129004309072873162.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129004805053873163.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(1129005309770873163.4907)
,p_plugin_attribute_id=>wwv_flow_api.id(1129000416631873157.4907)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(2564397076686507738.4907)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>unistr('\65B0\589E\5168\90E8\52FE\9078\6838\53D6\65B9\584A')
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512.4907
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\300C\65B0\589E\5168\90E8\52FE\9078\6838\53D6\65B9\584A\300D\52D5\614B\52D5\4F5C\6703\5C07\542B\6709 #CHECK_ALL_CHECKBOX# \5B57\4E32\7684\8CC7\6599\6B04\6A19\984C\5448\73FE\70BA\53EF\5B58\53D6\7684\5168\90E8\52FE\9078\6A23\5F0F\6838\53D6\65B9\584A, \800C\6B64\6838\53D6\65B9\584A\6703\52FE\9078\548C\53D6\6D88\52FE\9078\5176\5C0D\61C9\8CC7\6599\6B04\4E2D\7684\6240\6709\6838\53D6\65B9\584A.<p>'),
'<p>',
unistr('\82E5\8981\4F7F\7528\6B64 Plug-in, \8ACB\78BA\5B9A\5DF2\8A2D\5B9A\4E0B\5217\5C6C\6027:'),
'<ol>',
unistr('<li>\5728\5831\8868\8CC7\6599\6B04\4E2D, \5C07 ''#CHECK_ALL_CHECKBOX#'' \5B9A\7FA9\70BA\300C\6A19\984C\300D\503C.</li>'),
unistr('<li>\5728\300C\52D5\614B\52D5\4F5C - \6642\6A5F\300D\5C6C\6027\4E2D, \9078\53D6\542B\6709\8CC7\6599\6B04\7684\5831\8868\5340\57DF.</li>'),
unistr('<li>\5B9A\7FA9\300C\52D5\614B\52D5\4F5C\300D\4EE5\89F8\767C\300C\91CD\65B0\6574\7406\5F8C\300D, \4EE5\53CA\300C\8F09\5165\9801\9762\6642\89F8\767C\300D\7684\52D5\4F5C (\5982\679C\900F\904E\9078\53D6\300C\9801\9762\8A2D\8A08\5DE5\5177\300D\4E4B\300C\5448\73FE\300D\5340\6BB5\4E2D\7684\5340\57DF\4E26\5F9E\9019\88E1\5EFA\7ACB\300C\52D5\614B\52D5\4F5C\300D\4F86\5EFA\7ACB\300C\52D5\614B\52D5\4F5C\300D, \5247\5169\8005\9810\8A2D\90FD\9069\7528).</li>'),
unistr('<li>\9019\4E0D\6703\8655\7406\6BCF\500B\8CC7\6599\5217\4E0A\5448\73FE\7684\6838\53D6\65B9\584A\7684\8F14\52A9\529F\80FD, \800C\4E14\5FC5\9808\5206\5225\5728\5340\57DF\4F86\6E90\4E2D\9032\884C (\5982\9700\7BC4\4F8B, \8ACB\53C3\95B1 4000:656\300C\5340\57DF\300D\5340\57DF).</li>'),
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(4968616267302342.4907)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>unistr('\684C\9762')
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>3
,p_home_url=>'f?p=&APP_ID.:1000:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>.4907
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>'0'
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11470321135602393.4907)
,p_plug_name=>'Application Header [EBA]'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.page_header (',
'   p_app_id => :app_id,',
'   p_session => :app_session,',
'   p_app_user => :app_user,',
'   p_ws_app_id => :ws_app_id);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'90,102,605,3040,3050,92,101,888,999,6,12,15,16,17,19,22,25,27,28,29,30,901,50,33'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_comment=>'900,908,200,53,930,760,934,932,931,23,920,940,991,20,902,2,1000,9,950,906,903,904,905,915,928,1001,3,1,140,1250,11,951,910,990,31,960,205,201,206,4020,1310,1320,131,912,4040,4030,3000,21,926,921,927,922,923,925,710,740,745,742,750,37,13,18,24,141,800'
||'0,142,146,143,144,145,42,3010,3020,3030,3060,914,91,89'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22912720326182943.4907)
,p_plug_name=>'Search'
,p_region_css_classes=>'wsSearch'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4907)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'33,90,92,101,102,888,901,999,6,12,15,16,17,19,22,25,27,28,29,30,3040,3050,8000'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23000306359277138.4907)
,p_plug_name=>'widget for ws'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BEFORE_FOOTER'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="rollover" style="position:absolute;display:none;">',
'  <table cellpadding="1" cellspacing="0" border="0" width="100%">',
'    <tr>',
'      <td><input type="text" onkeyup="html_Find(''rollover_content'',this.value);" style="width:150px;" id="search" /><img onclick="ws_SearchApply()" src="#IMAGE_PREFIX#ws/find_20x.gif" /></td>',
'    </tr>',
'    <tr>',
'      <td>',
unistr('        <span id="sortup"><img src="#IMAGE_PREFIX#ws/dup.gif" alt="\905E\589E\6392\5E8F" title="\905E\589E\6392\5E8F" onclick="gReport.column.order(''ASC'')" /></span>'),
unistr('        <span id="sortdown"><img src="#IMAGE_PREFIX#ws/ddown.gif" alt="\905E\6E1B\6392\5E8F" title="\905E\6E1B\6392\5E8F" onclick="gReport.column.order(''DESC'')" /></span>'),
unistr('        <span id="removefilter"><img src="#IMAGE_PREFIX#ws/no_filter.gif" alt="\79FB\9664\7BE9\9078" title="\79FB\9664\7BE9\9078" onclick="gReport.column.filter_delete()" /></span>'),
unistr('        <span id="hide"><img src="#IMAGE_PREFIX#ws/trash.gif" alt="\96B1\85CF\8CC7\6599\6B04" title="\96B1\85CF\8CC7\6599\6B04" onclick="gReport.column.hide()" /></span>'),
unistr('        <span id="break"><img src="#IMAGE_PREFIX#ws/break_col.gif" alt="\5206\6BB5\8CC7\6599\6B04" title="\5206\6BB5\8CC7\6599\6B04" onclick="gReport.column.break_on()" /></span>'),
'      </td>',
'    </tr>',
'  </table>',
'  <div id="rollover_content"></div>',
'</div>',
''))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'2,16'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(202667427121487089.4907)
,p_plug_name=>'Toolbar Menu Container'
,p_region_name=>'wsMenu'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(202707431395573866.4907)
,p_plug_display_sequence=>70
,p_plug_display_point=>'REGION_POSITION_02'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'33,90,92,101,102,888,901,999,6,12,15,16,17,19,22,25,27,28,29,30,3040,3050'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_plug_comment=>'900,902,1,1000,906,903,904,928,905,915,2,3000,950,951,140,1250,11,3,18,24,141,8000,142,146,143,144,145,42'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(202668901410498676.4907)
,p_plug_name=>'Data Grid Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4907)
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_data_grid_menu (',
'    p_ws_app_id   => :WS_APP_ID,',
'    p_app_session => :APP_SESSION);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(202703416002531181.4907)
,p_plug_name=>'Admin Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4907)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(202684424744514793.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(929122129315135247.4907)
,p_translate_title=>'N'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_footer=>'</ul></div>'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(246646208489080880.4907)
,p_plug_name=>'Report Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4907)
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>50
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_report_menu (',
'    p_ws_app_id   => :WS_APP_ID,',
'    p_app_session => :APP_SESSION);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_security.sql_enabled(:WS_APP_ID) and',
'   wwv_flow_ws_security.sql_enabled_inst then',
'  return true;',
'end if;',
'return false;'))
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929118964340126057.4907)
,p_plug_name=>'APEX 5.0 - Toolbar Menu'
,p_parent_plug_id=>wwv_flow_api.id(202667427121487089.4907)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(929134615131186819.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(929122129315135247.4907)
,p_translate_title=>'N'
,p_plug_header=>'<div id="websheets_menubar" class=""><ul style="display: none">'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(353259602905391710.4907)
,p_plug_name=>'print app custom css'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.print_custom_css (',
'    p_ws_app_id  => :WS_APP_ID',
'    );'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_plug_display_when_condition=>'90,102,605,3040,3050,92,101,888,999,6,12,15,16,17,19,22,25,27,28,29,30,901,50,33'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(978301830711571982.4907)
,p_plug_name=>'high contrast mode CSS'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'AFTER_HEADER'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if htmldb_util.is_high_contrast_session then',
'  sys.htp.p(''<link rel="stylesheet" href="''||wwv_flow.g_image_prefix||''ws/css/ws_hc.css" type="text/css" />'');',
'end if;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(978405910887585124.4907)
,p_plug_name=>'high contrast mode .js'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BEFORE_FOOTER'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if htmldb_util.is_high_contrast_session then',
'  sys.htp.p(''<script type="text/javascript">'');',
'  sys.htp.p(''initHighContrastMode()'');',
'  sys.htp.p(''</script>'');',
'end if;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(29174927846182851.4907)
,p_name=>'P0_SEARCH'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(22912720326182943.4907)
,p_prompt=>unistr('\641C\5C0B Web \8A66\7B97\8868')
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.SEARCHBOX'
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(5556614497310460.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'f?p=&APP_ID.:8000:&SESSION.:::RIR:P8000_SEARCH:'
,p_attribute_02=>unistr('\641C\5C0B Web \8A66\7B97\8868')
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5100\8868\677F')
,p_step_title=>unistr('\5100\8868\677F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(174589600742777269.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4907)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\6B64\9801\9762\986F\793A\6B64\61C9\7528\7A0B\5F0F\7684\8CC7\8A0A.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(181148802605561554.4907)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(108117930940447534.4907)
,p_plug_name=>unistr('\6642\9593\7BC4\570D')
,p_parent_plug_id=>wwv_flow_api.id(181148802605561554.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(108051114664442909.4907)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185579501876856681.4907)
,p_name=>unistr('\61C9\7528\7A0B\5F0F\8A73\7D30\8CC7\8A0A')
,p_template=>wwv_flow_api.id(27071223638280295.4907)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:33%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'(',
'select name co',
'from wwv_flow_ws_applications',
'where id = :ws_app_id and',
'      security_group_id = :flow_security_group_id',
') application_name,',
'(',
'select apex_util.get_since(created_on) co',
'from wwv_flow_ws_applications',
'where id = :ws_app_id and',
'      security_group_id = :flow_security_group_id',
') application_created,',
'(',
'select created_by co',
'from wwv_flow_ws_applications',
'where id = :ws_app_id and',
'      security_group_id = :flow_security_group_id',
') created_by,',
'(',
'select count(*) websheet_pages',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a',
'where p.security_group_id = :flow_security_group_id ',
'and p.ws_app_id = :ws_app_id',
'and a.id = p.ws_app_id',
') websheet_pages,',
'(',
'select count(*) websheet_datagrids',
'from wwv_flow_worksheets w, ',
'                  wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id and',
'             w.security_group_id = :flow_security_group_id and             ',
'             a.ws_app_id = :ws_app_id and',
'             nvl(a.websheet_type,''DATA'') = ''DATA''',
') websheet_datagrids,',
'(',
'select count(*) websheet_reports',
'from wwv_flow_worksheets w, ',
'                  wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id and',
'             w.security_group_id = :flow_security_group_id and             ',
'             a.ws_app_id = :ws_app_id and',
'             nvl(a.websheet_type,''DATA'') = ''REPORT'' ',
') websheet_reports',
'from dual'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646109232237656.4907)
,p_query_num_rows=>1
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\627E\4E0D\5230\8CC7\6599')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>1
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_break_type_flag=>'DEFAULT_BREAK_FORMATTING'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185791324487395890.4907)
,p_query_column_id=>1
,p_column_alias=>'APPLICATION_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\540D\7A31')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185791420618395890.4907)
,p_query_column_id=>2
,p_column_alias=>'APPLICATION_CREATED'
,p_column_display_sequence=>3
,p_column_heading=>unistr('\5EFA\7ACB\6642\9593')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185793209343448296.4907)
,p_query_column_id=>3
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\5EFA\7ACB\8005')
,p_use_as_row_header=>'N'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185579730924856683.4907)
,p_query_column_id=>4
,p_column_alias=>'WEBSHEET_PAGES'
,p_column_display_sequence=>4
,p_column_heading=>unistr('Web \8A66\7B97\8868\9801\9762')
,p_column_format=>'999G999G999G999G999G999G990'
,p_heading_alignment=>'LEFT'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185582712789897769.4907)
,p_query_column_id=>5
,p_column_alias=>'WEBSHEET_DATAGRIDS'
,p_column_display_sequence=>5
,p_column_heading=>unistr('Web \8A66\7B97\8868\8CC7\6599\65B9\683C')
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185583313959907472.4907)
,p_query_column_id=>6
,p_column_alias=>'WEBSHEET_REPORTS'
,p_column_display_sequence=>6
,p_column_heading=>unistr('Web \8A66\7B97\8868\5831\8868')
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185592226389958372.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_template=>wwv_flow_api.id(27071223638280295.4907)
,p_display_sequence=>40
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:33%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select userid user_name, count(*) page_events',
'from wwv_flow_activity_log',
'where websheet_id = :ws_app_id and',
'      security_group_id = :flow_security_group_id and',
'      time_stamp >= (sysdate - nvl(:P1_TIMEFRAME,7))',
'group by userid',
'order by 2 desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646521495237685.4907)
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\5831\8868\672A\5305\542B\4EFB\4F55\8CC7\6599')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185597127736006112.4907)
,p_query_column_id=>1
,p_column_alias=>'USER_NAME'
,p_column_display_sequence=>1
,p_column_heading=>unistr('\4F7F\7528\8005\540D\7A31')
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185597203639006112.4907)
,p_query_column_id=>2
,p_column_alias=>'PAGE_EVENTS'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\9801\9762\4E8B\4EF6')
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185694921184931340.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\9801\9762')
,p_template=>wwv_flow_api.id(27071223638280295.4907)
,p_display_sequence=>50
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:66%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'          (select max(name)',
'          from wwv_flow_ws_webpages p',
'          where p.ws_app_id = :ws_app_id',
'            and p.id = v.webpage_id',
'            and p.security_group_id = :flow_security_group_id) page_name,',
'       page_events',
'from (',
'select webpage_id, count(*) page_events',
'from wwv_flow_activity_log',
'where websheet_id = :ws_app_id and',
'      security_group_id = :flow_security_group_id and',
'      time_stamp >= (sysdate - nvl(:P1_TIMEFRAME,7)) and',
'      webpage_id is not null and',
'      webpage_id in (select id from wwv_flow_ws_webpages where ws_app_id = :ws_app_id)',
'group by  webpage_id',
'order by count(*) desc',
') v',
'where rownum < 8',
'order by 2 desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646521495237685.4907)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\5831\8868\672A\5305\542B\4EFB\4F55\8CC7\6599')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(459664827478856710.4907)
,p_query_column_id=>1
,p_column_alias=>'PAGE_NAME'
,p_column_display_sequence=>2
,p_column_heading=>unistr('\9801\9762\540D\7A31')
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185695219132931341.4907)
,p_query_column_id=>2
,p_column_alias=>'PAGE_EVENTS'
,p_column_display_sequence=>1
,p_column_format=>'999G999G999G999G999G999G990'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_region(
 p_id=>wwv_flow_api.id(185788025254301476.4907)
,p_name=>unistr('\6700\8FD1\7684\8B8A\66F4')
,p_template=>wwv_flow_api.id(27071223638280295.4907)
,p_display_sequence=>30
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:66%; float:left;"'
,p_new_grid_row=>false
,p_new_grid_column=>false
,p_display_column=>1
,p_display_point=>'BODY'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(updated_by,created_by)||'' ''||wwv_flow_lang.system_message(''DATA_GRID'')||'': ''||websheet_name n,',
'       nvl(updated_on,created_on) the_date',
'from wwv_flow_ws_websheet_attr a',
'where a.ws_app_id = :ws_app_id and',
'      a.security_group_id = :workspace_id and',
'      nvl(a.websheet_type,''DATA'') = ''DATA''',
'union all',
'select nvl(updated_by,created_by)||'' ''||wwv_flow_lang.system_message(''F4000.PAGE'')||'': ''||name n,',
'       nvl(updated_on,created_on) the_date',
'from wwv_flow_ws_webpages p',
'where p.ws_app_id = :ws_app_id and',
'      p.security_group_id = :workspace_id',
'union all',
'select nvl(updated_by,created_by)||'' ''||wwv_flow_lang.system_message(''REPORT'')||'': ''||websheet_name n, nvl(updated_on,created_on) the_date',
'from  wwv_flow_ws_websheet_attr a',
'where  a.ws_app_id = :ws_app_id and',
'       a.security_group_id = :workspace_id and',
'       nvl(a.websheet_type,''DATA'') = ''REPORT'' ',
'order by 2 desc'))
,p_fixed_header=>'NONE'
,p_query_row_template=>wwv_flow_api.id(171646521495237685.4907)
,p_query_headings_type=>'NO_HEADINGS'
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>' - '
,p_query_break_cols=>'0'
,p_query_no_data_found=>unistr('\5831\8868\672A\5305\542B\4EFB\4F55\8CC7\6599')
,p_query_num_rows_type=>'0'
,p_query_row_count_max=>7
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_query_asc_image_attr=>'width="13" height="12" alt=""'
,p_query_desc_image_attr=>'width="13" height="12" alt=""'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185789009633344267.4907)
,p_query_column_id=>1
,p_column_alias=>'N'
,p_column_display_sequence=>1
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_report_columns(
 p_id=>wwv_flow_api.id(185789100826344267.4907)
,p_query_column_id=>2
,p_column_alias=>'THE_DATE'
,p_column_display_sequence=>2
,p_column_format=>'SINCE'
,p_lov_show_nulls=>'NO'
,p_lov_display_extra=>'YES'
,p_include_in_export=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(431071714612124037.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(185591206649952695.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(108117930940447534.4907)
,p_button_name=>'P1_SET'
,p_button_static_id=>'P1_SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\8A2D\5B9A')
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_button_condition_type=>'NEVER'
,p_request_source=>'refresh'
,p_request_source_type=>'STATIC'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(467407418236734151.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(181148802605561554.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:1,RIR::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(185586311236935113.4907)
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185585314221926524.4907)
,p_name=>'P1_TIMEFRAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(108117930940447534.4907)
,p_item_default=>'7'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\6B64\5831\8868\7684\671F\9593.')
,p_attribute_01=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(185297526463636542.4907)
,p_computation_sequence=>10
,p_computation_item=>'RUN_LINK'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''f?p=''||:app_id||'':900:''||:app_session||''::::WS_APP_ID,P900_ID:''||',
'          :WS_APP_ID||'',''||home_page_id',
'  from WWV_FLOW_WS_APPLICATIONS',
' where SECURITY_GROUP_ID = :flow_security_group_id ',
'   and id = :WS_APP_ID '))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(174635511046499211.4907)
,p_computation_sequence=>20
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\8CC7\6599\65B9\683C')
,p_step_title=>unistr('\8CC7\6599\65B9\683C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18847410435428482.4907)
,p_plug_name=>unistr('\5DE5\5177\5217\53F3\6309\9215')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20889528970815297.4907)
,p_plug_name=>'Hidden Region'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32890424941372009.4907)
,p_plug_name=>'Layout 1'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'<table border="0" cellpadding="0" cellspacing="0" width="100%" ><tr><td valign="top">'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32890625221372009.4907)
,p_plug_name=>'Layout 2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'</td><td width="100%" valign="top" style="padding:0 0 0 15px;">'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(32890824632372010.4907)
,p_plug_name=>'Layout 3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'</td></tr></table>'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(78917510079639965.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(155020820894822892.4907)
,p_plug_name=>'name'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(394039573177873943.4907)
,p_plug_name=>unistr('\8CC7\6599\65B9\683C')
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>70
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.DATA_GRID'
,p_attribute_01=>'P2_ID'
,p_attribute_02=>'P2_SHOW_CHECKBOX'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(460549006734687548.4907)
,p_plug_name=>'Ajax Notification Holder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wsPageMessage" id="ajaxMESSAGE" style="display:none;"><div id="theMESSAGE"></div>',
'<a href="javascript:void()" onclick="$x_Remove(''ajaxMESSAGE'')" class="wsCloseMessage"><img src="#IMAGE_PREFIX#f_spacer.gif" alt=""/></a>',
'</div>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(154946714578185788.4907)
,p_branch_action=>'f?p=&FLOW_ID.:2:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2631325119551194.4907)
,p_name=>'P2_SHOW_CHECKBOX'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(159405412148423457.4907)
,p_name=>'P2_SHOW_TOOLBAR'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185166302121096890.4907)
,p_name=>'P2_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4907)
,p_prompt=>'Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(185166510779099358.4907)
,p_name=>'P2_WEBSHEET_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(20889528970815297.4907)
,p_prompt=>'Websheet Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(161140617657065325.4907)
,p_computation_sequence=>10
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'2'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(5115909074633266.4907)
,p_computation_sequence=>20
,p_computation_item=>'RPT_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'null'
,p_compute_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_worksheet_rpts',
'where worksheet_id = :P2_ID',
'and id = :RPT_ID'))
,p_compute_when_type=>'NOT_EXISTS'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(471737810971362548.4907)
,p_computation_sequence=>30
,p_computation_item=>'WORKSHEET_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>'return wwv_flow_ws_api.get_websheet_name(p_worksheet_id => :p2_id);'
,p_computation_error_message=>unistr('\7121\6CD5\53D6\5F97\300C\8CC7\6599\65B9\683C\300D\540D\7A31.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(5886702465031774.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Collection'
,p_process_sql_clob=>'wwv_flow_ws_api.save_checked(p_worksheet_id => :P2_ID);'
,p_process_when_type=>'NEVER'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\7BA1\7406')
,p_step_title=>unistr('\7BA1\7406')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456716416117062946.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(457231706098432622.4907)
,p_plug_name=>'administration menu options'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(457230629124432618.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(138239722779443444.4907)
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(457236625109516658.4907)
,p_computation_sequence=>10
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'3'
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\522A\9664\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\522A\9664\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220816180174638)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(301529030296629019.4907)
,p_plug_name=>unistr('\78BA\8A8D\522A\9664')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(487678607690660963)
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\522A\9664\61C9\7528\7A0B\5F0F\6642, \5C07\6703\522A\9664\61C9\7528\7A0B\5F0F\53CA\5176\6240\6709\76F8\5C0D\61C9\7684\5143\4EF6.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(301532105496629025.4907)
,p_plug_name=>'Confirm Delete'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(301601412384641231.4907)
,p_plug_name=>'Toolbar Right Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="margin-bottom: 10px"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_footer=>'<div class="clear"></div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318042708957711067.4907)
,p_plug_name=>unistr('\7121\6CD5\522A\9664\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>41
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_required_role=>'!'||wwv_flow_api.id(487678607690660963)
,p_plug_header=>unistr('<div class="wsErrorMessageSQL">\60A8\5FC5\9808\662F\300C&PRODUCT_NAME. \958B\767C\4EBA\54E1\300D\624D\80FD\5920\5B58\53D6\6B64\529F\80FD.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(301529230900629020.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(301601412384641231.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(319787302199021438.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(301601412384641231.4907)
,p_button_name=>'BUILDER_LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\767B\5165\958B\767C')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_security_scheme=>'!'||wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(301529418920629020.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(301601412384641231.4907)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\7ACB\5373\6C38\4E45\522A\9664')
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(302848719197785179.4907)
,p_branch_action=>'f?p=4000:1500:&BUILDER_SESSION_ID.::NO:RP:P1500_SHOW:WEBSHEET'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from wwv_flow_ws_applications',
'where security_group_id = :flow_security_group_id'))
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301529629185629020.4907)
,p_name=>'P4_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4907)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\9078\53D6\7684\61C9\7528\7A0B\5F0F.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301530122954629023.4907)
,p_name=>'P4_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4907)
,p_prompt=>unistr('\540D\7A31')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name from wwv_flow_ws_applications ',
' where id = :P4_ID',
'   and security_group_id = :flow_security_group_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\9078\53D6\4E4B\61C9\7528\7A0B\5F0F\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301530606969629023.4907)
,p_name=>'P4_PAGES'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4907)
,p_prompt=>unistr('\9801\9762')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) ',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a',
'where p.security_group_id = :flow_security_group_id ',
'and p.ws_app_id = :P4_ID',
'and a.id = p.ws_app_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\61C9\7528\7A0B\5F0F\5167\7684\9801\9762\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301531114457629024.4907)
,p_name=>'P4_DATAGRIDS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4907)
,p_prompt=>unistr('\8CC7\6599\65B9\683C')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) ',
' from wwv_flow_worksheets w, ',
'       wwv_flow_ws_websheet_attr a',
' where w.id = a.worksheet_id and',
'       w.security_group_id = :flow_security_group_id and            ',
'       a.websheet_type = ''DATA'' and',
'       a.ws_app_id = :P4_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\61C9\7528\7A0B\5F0F\5167\7684\8CC7\6599\65B9\683C\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(301531601072629024.4907)
,p_name=>'P4_REPORTS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(301529030296629019.4907)
,p_prompt=>unistr('\5831\8868')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) ',
' from wwv_flow_worksheets w, ',
'       wwv_flow_ws_websheet_attr a',
' where w.id = a.worksheet_id and',
'       w.security_group_id = :flow_security_group_id and            ',
'       a.websheet_type = ''REPORT'' and',
'       a.ws_app_id = :P4_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\61C9\7528\7A0B\5F0F\5167\7684\5831\8868\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(317199623052582715.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete websheet application'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.delete_ws_app (',
'    p_ws_app_id   => :P4_ID);'))
,p_process_error_message=>unistr('\7121\6CD5\522A\9664\61C9\7528\7A0B\5F0F.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(301529418920629020.4907)
,p_process_success_message=>unistr('\5DF2\522A\9664\61C9\7528\7A0B\5F0F.')
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\8B8A\66F4\5BC6\78BC')
,p_step_title=>unistr('\8B8A\66F4\5BC6\78BC')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(506060600392166972)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(733375232512655603.4907)
,p_plug_name=>unistr('\8B8A\66F4\5BC6\78BC')
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_ws_applications ',
'where id = :WS_APP_ID',
'and security_group_id = :WORKSPACE_ID'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(733377515496655611.4907)
,p_plug_name=>'Toobar Right Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(733377932388655611.4907)
,p_plug_name=>'Change Password'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(733377104075655609.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(733377515496655611.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(733377316895655611.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(733377515496655611.4907)
,p_button_name=>'RESET_PASSWORD'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\8B8A\66F4\5BC6\78BC')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(733378822544655614.4907)
,p_branch_action=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(733375407229655605.4907)
,p_name=>'P5_CURRENT_PASSWORD'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4907)
,p_prompt=>unistr('\8F38\5165\76EE\524D\7684\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8F38\5165\60A8\76EE\524D\7684\5BC6\78BC.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(733376401898655607.4907)
,p_name=>'P5_USERNAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31')
,p_source=>'APP_USER'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8B8A\66F4\5BC6\78BC\4E4B\4F7F\7528\8005\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(739791012792509692.4907)
,p_name=>'P5_NEW_PASSWORD'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4907)
,p_prompt=>unistr('\8F38\5165\65B0\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8F38\5165\65B0\5BC6\78BC')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(739973506690517391.4907)
,p_name=>'P5_CONFIRM_PASSWORD'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(733375232512655603.4907)
,p_prompt=>unistr('\78BA\8A8D\65B0\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\91CD\65B0\8F38\5165\65B0\5BC6\78BC')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740169510284527901.4907)
,p_validation_name=>'APP_USER not null'
,p_validation_sequence=>10
,p_validation=>'APP_USER'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\672A\6B63\78BA\8A2D\5B9A\4F7F\7528\8005\540D\7A31. \8ACB\5B8C\5168\95DC\9589\60A8\7684\700F\89BD\5668, \7136\5F8C\5617\8A66\91CD\65B0\8B8A\66F4\60A8\7684\5BC6\78BC.')
,p_associated_item=>wwv_flow_api.id(733376401898655607.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740337923575541125.4907)
,p_validation_name=>'new passwd = confirm passwd'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P5_NEW_PASSWORD != :P5_CONFIRM_PASSWORD then',
'  :P5_NEW_PASSWORD := null;',
'  :P5_CONFIRM_PASSWORD := null;',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\78BA\8A8D\5BC6\78BC\8207\65B0\5BC6\78BC\4E0D\7B26.')
,p_validation_condition=>':P5_NEW_PASSWORD is not null and :P5_CONFIRM_PASSWORD is not null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740556219204549371.4907)
,p_validation_name=>'Validate Current Password'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_api.is_login_password_valid(',
'  p_username => :APP_USER,',
'  p_password => :P5_CURRENT_PASSWORD);'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7121\6548\7684\5BC6\78BC')
,p_validation_condition=>'P5_CURRENT_PASSWORD'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(740770724529560332.4907)
,p_validation_name=>'strong password'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_security.strong_password_validation(',
'      p_username              => :APP_USER,',
'      p_password              => :P5_NEW_PASSWORD,',
'      p_old_password          => :P5_CURRENT_PASSWORD,',
'      p_workspace_name        => wwv_flow_security.find_company_name(:flow_security_group_id));'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\932F\8AA4')
,p_validation_condition=>':P5_NEW_PASSWORD is not null and :P5_CONFIRM_PASSWORD is not null'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(733378319666655613.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'change password'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_api.g_fnd_user_password_action := true;',
'update wwv_flow_fnd_user ',
'  set web_password = :P5_NEW_PASSWORD',
'where security_group_id = :flow_security_group_id ',
'  and user_id = (select user_id ',
'                  from wwv_flow_fnd_user ',
'                 where security_group_id = :flow_security_group_id ',
'                   and user_name = :app_user);',
'wwv_flow_api.g_fnd_user_password_action := false;',
'',
':P5_NEW_PASSWORD := null;',
':P5_CONFIRM_PASSWORD := null;',
':P5_CURRENT_PASSWORD := null;'))
,p_process_error_message=>unistr('\8B8A\66F4\5BC6\78BC\6642\767C\751F\932F\8AA4.')
,p_process_when=>':P5_NEW_PASSWORD = :P5_CONFIRM_PASSWORD'
,p_process_when_type=>'PLSQL_EXPRESSION'
,p_process_success_message=>unistr('\5DF2\8B8A\66F4\5BC6\78BC.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(741456721937597439.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'clear'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'5'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5B58\53D6\63A7\5236')
,p_step_title=>unistr('\5B58\53D6\63A7\5236')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css" media="screen">',
'	/* Hide left col */',
'	div.wsSideCol {',
'		 display: none !important;',
'	}',
'	div.wsMainCol {',
'		 padding: 5px;',
'	}',
'</style>'))
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(619279823495072045.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(619385132669714338.4907)
,p_plug_name=>unistr('\5B58\53D6\63A7\5236')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(628484022950304722.4907)
,p_plug_name=>'intro text'
,p_parent_plug_id=>wwv_flow_api.id(619385132669714338.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(''<p>''||wwv_flow_lang.system_message(''ACL_TABLE.INTRO_TEXT'')||''</p>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(628484309576310290.4907)
,p_plug_name=>'acl table'
,p_parent_plug_id=>wwv_flow_api.id(619385132669714338.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p(wwv_flow_ws_api.get_acl_table);'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(619280212586072050.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Window'
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868 - \5B9A\7FA9 Web \8A66\7B97\8868')
,p_step_title=>unistr('\5EFA\7ACB Web \8A66\7B97\8868 - \5B9A\7FA9 Web \8A66\7B97\8868')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(487678607690660963)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318854823839904542.4907)
,p_plug_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(487678607690660963)
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P7_WS_OBJ_VALID'
,p_plug_display_when_cond2=>'Y'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318859432686904552.4907)
,p_plug_name=>unistr('Web \8A66\7B97\8868')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>5
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(487678607690660963)
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P7_WS_OBJ_VALID'
,p_plug_display_when_cond2=>'N'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<div class="wsErrorMessageSQL">\5EFA\7ACB\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F\6642\6240\9700\7684\8CC7\6599\5EAB\7269\4EF6\7121\6548\6216\4E0D\5B58\5728.  \8ACB\6D3D\8A62\60A8\7684\300C\5DE5\4F5C\5340\7BA1\7406\54E1\300D.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318860207517904554.4907)
,p_plug_name=>'Create Websheet - Define Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(318967230409915957.4907)
,p_plug_name=>'Topbar Right Side'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(320644524521264400.4907)
,p_plug_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868\767C\751F\932F\8AA4')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_required_role=>'!'||wwv_flow_api.id(487678607690660963)
,p_plug_header=>unistr('<div class="wsErrorMessageSQL">\60A8\5FC5\9808\662F\300C&PRODUCT_NAME. \958B\767C\4EBA\54E1\300D\624D\80FD\5920\5B58\53D6\6B64\529F\80FD.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(318855016053904543.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(318855428690904544.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4907)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(320757101234276586.4907)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4907)
,p_button_name=>'BUILDER_LOGIN'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\767B\5165\958B\767C')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=4500:1000:&BUILDER_SESSION_ID.'
,p_security_scheme=>'!'||wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(318860014037904553.4907)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(318967230409915957.4907)
,p_button_name=>'FIX_WS_OBJ'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\7BA1\7406 Web \8A66\7B97\8868\8CC7\6599\5EAB\7269\4EF6')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=4350:2000:&BUILDER_SESSION_ID.'
,p_button_execute_validations=>'N'
,p_button_condition=>'P7_WS_OBJ_VALID'
,p_button_condition2=>'N'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_security_scheme=>wwv_flow_api.id(487678607690660963)
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(318862427044904561.4907)
,p_branch_action=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(318855428690904544.4907)
,p_branch_sequence=>30
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318855611632904545.4907)
,p_name=>'P7_WEBSHEET_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4907)
,p_prompt=>unistr('\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>255
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\4F9B\958B\767C\4EBA\54E1\8B58\5225\61C9\7528\7A0B\5F0F\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318856114895904546.4907)
,p_name=>'P7_WS_APP_ID'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4907)
,p_prompt=>unistr('Web \8A66\7B97\8868')
,p_source=>'wwv_flow_utilities.minimum_free_flow'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>12
,p_cMaxlength=>120
,p_cAttributes=>'nowrap'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\6307\5B9A\4E00\500B\8B58\5225\61C9\7528\7A0B\5F0F\7684\6574\6578\503C.  \6B64\61C9\7528\7A0B\5F0F ID \5728\60A8\7684 &PRODUCT_NAME. \57F7\884C\8655\7406\5167\5FC5\9808\662F\552F\4E00\7684.<br /><br />'),
unistr('3000 \5230 9000 \4E4B\9593\7684\61C9\7528\7A0B\5F0F ID \70BA &PRODUCT_NAME. \5167\90E8\4F7F\7528\7684 ID.')))
,p_attribute_01=>'0'
,p_attribute_03=>'right'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318856522037904548.4907)
,p_name=>'P7_DESCRIPTION'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4907)
,p_prompt=>unistr('\63CF\8FF0')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_cAttributes=>'nowrap'
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\60A8\61C9\7528\7A0B\5F0F\7684\63CF\8FF0.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(318857629067904549.4907)
,p_name=>'P7_WS_OBJ_VALID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(318854823839904542.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(318860812527904558.4907)
,p_computation_sequence=>10
,p_computation_item=>'P7_WEBSHEET_NAME'
,p_computation=>'ltrim(rtrim(:P7_WEBSHEET_NAME))'
,p_compute_when=>'CREATE'
,p_compute_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(318861027774904559.4907)
,p_computation_sequence=>10
,p_computation_item=>'P7_WEBSHEET_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    r varchar2(255) := null;',
'    c pls_integer;',
'begin',
'    for i in 1..12 ',
'    loop',
'        select  count(*) into c',
'        from  wwv_flow_ws_applications',
'        where security_group_id = :flow_security_group_id',
'        and name = upper(:app_user)||'' 0''||i;',
'        if c = 0 then',
'           r := upper(:app_user)||'' 0''||i;',
'           exit;',
'        end if;',
'    end loop;',
'    return r;',
'end;'))
,p_compute_when=>'P7_WEBSHEET_NAME'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(318861220395904559.4907)
,p_computation_sequence=>10
,p_computation_item=>'P7_WS_OBJ_VALID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_setup.all_object_valid2 then',
'  return ''Y'';',
'else',
'  return ''N'';',
'end if;'))
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(318861410474904560.4907)
,p_validation_name=>'P7_WS_APP_ID not exists'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_models',
' where flow_id = :P7_WS_APP_ID ',
'   and model_complete = ''Y''',
'   and flow_id in (select id from wwv_flows)',
'union',
'select 1 from wwv_flows',
' where id = :P7_WS_APP_ID',
'union',
'select 1 from wwv_flow_ws_applications',
' where id = :P7_WS_APP'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('\300C\61C9\7528\7A0B\5F0F ID\300D\5DF2\7D93\5B58\5728, \6216\662F\4FDD\7559\7D66\5176\4ED6\61C9\7528\7A0B\5F0F\6A21\578B.')
,p_validation_condition=>'P7_WS_APP_ID'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(318856114895904546.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(318861624125904560.4907)
,p_validation_name=>'P7_WS_APP_ID not reserved'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_utilities.is_available_application_id(',
'    p_security_group_id => :flow_security_group_id,',
'    p_application_id    => :P7_WS_APP_ID,',
'    p_check_reserved    => FALSE ) = FALSE then',
'    --',
'    return FALSE;',
'else',
'    return TRUE;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\4FDD\7559\7684\300C\61C9\7528\7A0B\5F0F ID\300D.')
,p_validation_condition=>'P7_WS_APP_ID'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_associated_item=>wwv_flow_api.id(318856114895904546.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00008
begin
wwv_flow_api.create_page(
 p_id=>8.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_step_title=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(487678607690660963)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(321421909516423567.4907)
,p_plug_name=>unistr('\78BA\8A8D')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\60A8\8981\6C42\4F7F\7528\4E0B\5217\5C6C\6027\5EFA\7ACB\300CWeb \8A66\7B97\8868\300D. \8ACB\78BA\8A8D\60A8\7684\9078\64C7\9805\76EE.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(321422704576423569.4907)
,p_plug_name=>'Create Websheet'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(321563209349439790.4907)
,p_plug_name=>'Topbar Right Side'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(321422118221423568.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(321563209349439790.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(321422324783423569.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(321563209349439790.4907)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(321422507191423569.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(321563209349439790.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(321423518422423582.4907)
,p_branch_action=>'f?p=&APP_ID.:32:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(321422324783423569.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(321849905586467114.4907)
,p_name=>'P8_WEBSHEET_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(321421909516423567.4907)
,p_prompt=>unistr('\540D\7A31')
,p_source=>'P7_WEBSHEET_NAME'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>40
,p_cMaxlength=>255
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\4F9B\958B\767C\4EBA\54E1\8B58\5225\61C9\7528\7A0B\5F0F\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(321884016322470228.4907)
,p_name=>'P8_WS_APP_ID'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(321421909516423567.4907)
,p_prompt=>unistr('Web \8A66\7B97\8868')
,p_source=>'P7_WS_APP_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>12
,p_cMaxlength=>120
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8B58\5225\61C9\7528\7A0B\5F0F\7684\6574\6578\503C.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(321903521516471689.4907)
,p_name=>'P8_DESCRIPTION'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(321421909516423567.4907)
,p_prompt=>unistr('\63CF\8FF0')
,p_source=>'P7_DESCRIPTION'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\60A8\61C9\7528\7A0B\5F0F\7684\63CF\8FF0.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(321423206166423578.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create websheet'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_ws_app (',
'      p_ws_app_id      => :P7_WS_APP_ID,',
'      p_name           => :P7_WEBSHEET_NAME,',
'      p_description    => :P7_DESCRIPTION,      ',
'      --',
'      p_flow_id        => :APP_ID',
'      );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\61C9\7528\7A0B\5F0F.')
,p_process_when_button_id=>wwv_flow_api.id(321422324783423569.4907)
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5B58\53D6\63A7\5236')
,p_step_title=>unistr('\5B58\53D6\63A7\5236')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451311515410376846.4907)
,p_plug_name=>'Access Control List Entries'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select n001 id,',
'       c001 username,',
'       c002 priv,',
'       wwv_flow_lang.system_message(''EDIT_LINK_TEXT'', wwv_flow_escape.html(c001)) link_text',
'from wwv_flow_collections',
'where collection_name = ''APEX$_ACL'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(451311719920376851.4907)
,p_name=>'Change History'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\5B58\53D6\63A7\5236\6E05\55AE\4E2D\6C92\6709\9805\76EE.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="" />'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(451333131265977320.4907)
,p_db_column_name=>'ID'
,p_display_order=>2
,p_column_identifier=>'D'
,p_column_label=>' '
,p_column_link=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:13:P13_ID:#ID#'
,p_column_linktext=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="#LINK_TEXT#">'
,p_column_link_attr=>'Edit'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_hide=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(451314505039414398.4907)
,p_db_column_name=>'USERNAME'
,p_display_order=>3
,p_column_identifier=>'B'
,p_column_label=>unistr('\4F7F\7528\8005\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(451314610985414398.4907)
,p_db_column_name=>'PRIV'
,p_display_order=>4
,p_column_identifier=>'C'
,p_column_label=>unistr('\6B0A\9650')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(451333930142995878)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(247045499759377619.4907)
,p_db_column_name=>'LINK_TEXT'
,p_display_order=>14
,p_column_identifier=>'E'
,p_column_label=>unistr('\9023\7D50\6587\5B57')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451312628829376856.4907)
,p_plug_name=>'Manage Access Control List'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(458561726210213950.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4907)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\82E5\61C9\7528\7A0B\5F0F\4F7F\7528\81EA\8A02\6388\6B0A, \6B64\5B58\53D6\63A7\5236\6E05\55AE\7BA1\7406\6B64\61C9\7528\7A0B\5F0F\4E4B\4F7F\7528\8005\7684\6B0A\9650.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(458945107668445108.4907)
,p_plug_name=>unistr('\8A8D\8B49\914D\7F6E')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_auth_type varchar2(255);',
'begin',
'  l_auth_type := wwv_flow_item.text_from_lov(wwv_flow_ws_security.ws_auth_type(:WS_APP_ID),''WEBSHEET AUTHENTICATION'');',
'',
'  sys.htp.prn(''<p>''||',
'      wwv_flow_lang.system_message(''F4900_P11_AUTH_TYPE_MESSAGE'',l_auth_type)||''</p>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466701412926181295.4907)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(466702532319186899.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(466701412926181295.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:11,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451340528822175261.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(451311515410376846.4907)
,p_button_name=>'CREATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4907)
,p_button_image_alt=>unistr('\5EFA\7ACB\9805\76EE >')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:13::'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(451313319291376861.4907)
,p_branch_action=>'f?p=&FLOW_ID.:11:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451313108133376860.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create ACL collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_acl_collection (',
'    p_ws_app_id => :WS_APP_ID',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB ACL \96C6\5408.')
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\8B70\7684 SQL')
,p_step_title=>unistr('\5EFA\8B70\7684 SQL')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_required_role=>wwv_flow_api.id(495860932509802714)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488396212380125306.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4907)
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\53EF\4EE5\5728\300C\5831\8868\300D\548C\300CSQL \6A19\8A18\300D\4E2D\4F7F\7528 SQL.  \9019\662F\4E00\4EFD\60A8\61C9\7528\7A0B\5F0F\53EF\4EE5\4F7F\7528\7684\300C\5EFA\8B70\7684\7269\4EF6\300D\6E05\55AE.  \9078\53D6\4E00\500B\7269\4EF6, \5373\53EF\986F\793A\53EF\4F9B\4F7F\7528\7684\9069\7576 SQL SELECT \6558\8FF0\53E5.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488403717840125334.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488408215444168022.4907)
,p_plug_name=>unistr('\5EFA\8B70\7684\7269\4EF6')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>15
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name,',
'       object_comment',
'  from wwv_flow_ws_app_sug_objects',
' where ws_app_id = :WS_APP_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(488408303926168022.4907)
,p_name=>'Available Objects'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(488408529626168027.4907)
,p_db_column_name=>'OBJECT_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\7269\4EF6\540D\7A31')
,p_column_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12:P12_TABLE_NAME:#OBJECT_NAME#'
,p_column_linktext=>'#OBJECT_NAME#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492616214470258718.4907)
,p_db_column_name=>'OBJECT_COMMENT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\8A3B\89E3')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488409211280188810.4907)
,p_plug_name=>'&P12_TABLE_NAME.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(27071223638280295.4907)
,p_plug_display_sequence=>25
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare q varchar2(32767);',
'begin',
'q := ''select'';',
'for c1 in (',
'select column_name',
'  from sys.dba_tab_columns',
' where table_name = :P12_TABLE_NAME and',
'       owner = wwv_flow_security.g_apex$_schema',
' order by column_id) loop',
'q := q||''<br />'';',
'q := q||''&nbsp;&nbsp;&nbsp;&nbsp;''||wwv_flow_escape.html(c1.column_name)||'','';',
'end loop;',
'q := rtrim(q,'','')||''<br />from ''||wwv_flow_escape.html(:P12_TABLE_NAME);',
'sys.htp.p(q);',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P12_TABLE_NAME'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488415531993365037.4907)
,p_plug_name=>unistr('\7BC4\4F8B')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4907)
,p_plug_display_sequence=>35
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<pre>',
'[[SQL: select ename "Employee Name", sal "Salary" from emp order by sal desc | limit=10]]',
'[[SQLVALUE: select count(*)  from emp ]]',
'</pre>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491315127198795285.4907)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488411205618253386.4907)
,p_button_sequence=>5
,p_button_plug_id=>wwv_flow_api.id(488408215444168022.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:12,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(488409426171193110.4907)
,p_name=>'P12_TABLE_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(488396212380125306.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
end;
/
prompt --application/pages/page_00013
begin
wwv_flow_api.create_page(
 p_id=>13.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB/\7DE8\8F2F\5B58\53D6\63A7\5236\6E05\55AE\9805\76EE')
,p_step_title=>unistr('\5EFA\7ACB/\7DE8\8F2F\5B58\53D6\63A7\5236\6E05\55AE\9805\76EE')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22693023416256513.4907)
,p_plug_name=>'Top Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22695808618308969.4907)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451316114910485987.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(451316527354493693.4907)
,p_plug_name=>unistr('\9805\76EE')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455753022786260831.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4907)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\61C9\7528\7A0B\5F0F\4F7F\7528\81EA\8A02\6388\6B0A, \6B64\5B58\53D6\63A7\5236\6E05\55AE\7BA1\7406\6B64\61C9\7528\7A0B\5F0F\4E4B\4F7F\7528\8005\7684\6B0A\9650.</p>'),
'',
'<ul>',
unistr('<li><b>\95B1\8B80\8005</b> - \53EF\6AA2\8996, \4F46\4E0D\53EF\7DE8\8F2F\5167\5BB9</li>'),
unistr('<li><b>\63D0\4F9B\8005</b> - \53EF\6AA2\8996\53CA\7DE8\8F2F\5167\5BB9</li>'),
unistr('<li><b>\7BA1\7406\54E1</b> - \53EF\6AA2\8996\53CA\7DE8\8F2F\5167\5BB9, \4EE5\53CA\7DE8\8F2F\300C\61C9\7528\7A0B\5F0F\7279\6027\300D\53CA\7BA1\7406\300C\5B58\53D6\63A7\5236\6E05\55AE\300D</li>'),
'</ul>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'NEVER'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451317504937543969.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451317707492554199.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4907)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\5EFA\7ACB')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488046828362984858.4907)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4907)
,p_button_name=>'CREATE_AND_CREATE_ANOTHER'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\5EFA\7ACB\591A\9805')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451326723076908671.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4907)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(451334810665009173.4907)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(22693023416256513.4907)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15160928947568323.4907)
,p_button_image_alt=>unistr('\522A\9664')
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_redirect_url=>'javascript:confirmDelete(''&DELETE_MSG.'',''DELETE'');'
,p_button_condition=>'P13_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(488047325507002977.4907)
,p_branch_action=>'f?p=&APP_ID.:13:&SESSION.::&DEBUG.:13::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(488046828362984858.4907)
,p_branch_sequence=>2
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(451317931226554200.4907)
,p_branch_action=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(451316709130497825.4907)
,p_name=>'P13_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(22695808618308969.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(451316912509517726.4907)
,p_name=>'P13_USERNAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(451316527354493693.4907)
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\6307\5B9A\60F3\8981\63A7\5236\5176\5B58\53D6\6B0A\7684\4F7F\7528\8005\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(451317328917531994.4907)
,p_name=>'P13_PRIV'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(451316527354493693.4907)
,p_item_default=>'R'
,p_prompt=>unistr('\6B0A\9650')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'WS_ACL_PRIVS'
,p_lov=>'.'||wwv_flow_api.id(451333930142995878.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'LEFT-TOP'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\6307\5B9A\4F7F\7528\8005\7684\6B0A\9650\5C64\6B21. \5982\679C\61C9\7528\7A0B\5F0F\4F7F\7528\81EA\8A02\6388\6B0A, \5247\7531\5B58\53D6\63A7\5236\6E05\55AE\7BA1\7406\6B64\61C9\7528\7A0B\5F0F\4E4B\4F7F\7528\8005\7684\6B0A\9650.</p>'),
'',
'<ul>',
unistr('<li><b>\95B1\8B80\8005</b> - \53EF\4EE5\6AA2\8996, \4F46\4E0D\53EF\7DE8\8F2F\5167\5BB9.</li>'),
unistr('<li><b>\63D0\4F9B\8005</b> - \53EF\4EE5\6AA2\8996\53CA\7DE8\8F2F\5167\5BB9.</li>'),
unistr('<li><b>\7BA1\7406\54E1</b> - \53EF\4EE5\6AA2\8996\53CA\7DE8\8F2F\5167\5BB9, \4EE5\53CA\7DE8\8F2F\300C\61C9\7528\7A0B\5F0F\7279\6027\300D\53CA\7BA1\7406\300C\5B58\53D6\63A7\5236\6E05\55AE\300D.</li>'),
'</ul>'))
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(22573104501037740.4907)
,p_computation_sequence=>10
,p_computation_item=>'P13_USERNAME'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'trim(:P13_USERNAME)'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(456322608585423890.4907)
,p_validation_name=>'Cannot Delete or lesser privilege yourself'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001',
'             from wwv_flow_collections',
'            where collection_name = ''APEX$_ACL''',
'              and n001 = :P13_ID ) loop',
'  if :REQUEST = ''DELETE'' and c1.c001 = upper(:APP_USER) then',
'    return false;',
'  elsif :REQUEST = ''APPLY_CHANGES'' and c1.c001 = upper(:APP_USER) and :P13_PRIV != ''A'' then',
'    return false;',
'  else',
'    return true;',
'  end if;',
'end loop;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\60A8\7121\6CD5\79FB\9664\672C\8EAB\7684\7BA1\7406\54E1\8EAB\5206.')
,p_validation_condition=>':REQUEST in (''DELETE'',''APPLY_CHANGES'') and wwv_flow_ws_security.ws_acl_type(:WS_APP_ID) = ''CUSTOM'''
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(451316912509517726.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(799469025785845096.4907)
,p_validation_name=>'P13_USERNAME already exists'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flow_collections',
' where collection_name = ''APEX$_ACL''',
'   and c001 = upper(:P13_USERNAME)'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>unistr('\4F7F\7528\8005\5DF2\7D93\5728\5B58\53D6\63A7\5236\6E05\55AE\4E2D.')
,p_validation_condition=>'CREATE,CREATE_AND_CREATE_ANOTHER'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(451316912509517726.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(819882220390557560.4907)
,p_validation_name=>'P13_USERNAME not null'
,p_validation_sequence=>30
,p_validation=>'P13_USERNAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\63D0\4F9B\4F7F\7528\8005\540D\7A31.')
,p_validation_condition=>'CREATE,CREATE_AND_CREATE_ANOTHER,APPLY_CHANGES'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(451316912509517726.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451339402456139272.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'add/update ACL'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.add_acl_entry(',
'    p_ws_app_id  => :WS_APP_ID,',
'    p_acl_id          => :P13_ID,',
'    p_username   => :P13_USERNAME,',
'    p_priv             => :P13_PRIV );'))
,p_process_error_message=>unistr('\5EFA\7ACB\5B58\53D6\63A7\5236\6E05\55AE\9805\76EE\6642\767C\751F\932F\8AA4.')
,p_process_when=>'CREATE,APPLY_CHANGES,CREATE_AND_CREATE_ANOTHER'
,p_process_when_type=>'REQUEST_IN_CONDITION'
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\6216\4FEE\6539\5B58\53D6\63A7\5236\6E05\55AE\9805\76EE.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(833790620596523418.4907)
,p_process_sequence=>15
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create ACL collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_acl_collection (',
'    p_ws_app_id => :WS_APP_ID',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB ACL \96C6\5408.')
,p_process_when_button_id=>wwv_flow_api.id(488046828362984858.4907)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451340317956162700.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete acl entry'
,p_process_sql_clob=>'wwv_flow_ws_api.delete_acl_entry(:P13_ID);'
,p_process_error_message=>unistr('\522A\9664\5B58\53D6\63A7\5236\6E05\55AE\9805\76EE\6642\767C\751F\932F\8AA4.')
,p_process_when_button_id=>wwv_flow_api.id(451334810665009173.4907)
,p_process_success_message=>unistr('\5DF2\522A\9664\5B58\53D6\63A7\5236\6E05\55AE\9805\76EE.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(451338731714109921.4907)
,p_process_sequence=>30
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'pop items'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select c001 username, c002 priv',
'             from wwv_flow_collections',
'            where collection_name = ''APEX$_ACL''',
'              and n001 = :P13_ID ) loop',
'    :P13_USERNAME := c1.username;',
'    :P13_PRIV := c1.priv;',
'    exit;',
'end loop;'))
,p_process_when=>'P13_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_api.create_page(
 p_id=>14.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6AA2\8996\8B8A\66F4\6B77\53F2\8A18\9304')
,p_step_title=>unistr('\6AA2\8996\8B8A\66F4\6B77\53F2\8A18\9304')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2669725667029212.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29080824628705464.4907)
,p_plug_name=>unistr('\6AA2\8996\8B8A\66F4\6B77\53F2\8A18\9304')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select c001 row_key,',
'       c002 column_name,',
'       c003 old_value,',
'       c004 new_value,',
'       c005 application_user_id,',
'       d001 date_of_change,',
'       c006 history_rowid',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_HISTORY'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(29080913600705464.4907)
,p_name=>'Change History'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_base_pk1=>'ROW_KEY'
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_rows_per_page=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#ws/small_page.gif" alt="&VIEW." />'
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1524146599951611412.4907)
,p_db_column_name=>'ROW_KEY'
,p_display_order=>10
,p_column_identifier=>'G'
,p_column_label=>unistr('\8CC7\6599\5217\7D22\5F15\9375')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081219740705468.4907)
,p_db_column_name=>'COLUMN_NAME'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>unistr('\8CC7\6599\6B04\540D\7A31')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081302162705468.4907)
,p_db_column_name=>'OLD_VALUE'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>unistr('\820A\503C')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081429809705469.4907)
,p_db_column_name=>'NEW_VALUE'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>unistr('\65B0\503C')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29081503189705469.4907)
,p_db_column_name=>'APPLICATION_USER_ID'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>unistr('\61C9\7528\7A0B\5F0F\4F7F\7528\8005 ID')
,p_column_type=>'STRING'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(29085729935792011.4907)
,p_db_column_name=>'DATE_OF_CHANGE'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>unistr('\5DF2\8B8A\66F4')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(246124596661890750.4907)
,p_db_column_name=>'HISTORY_ROWID'
,p_display_order=>70
,p_column_identifier=>'I'
,p_column_label=>unistr('\6B77\53F2\8A18\9304 rowid')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(906866216721570277.4907)
,p_plug_name=>unistr('\5DE5\5177\5217\53F3\6309\9215')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(907020707979586718.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(29080824628705464.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(2647813413278526.4907)
,p_branch_action=>'f?p=&FLOW_ID.:14:&SESSION.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(29080030787678754.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create history collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_history_collection (',
'    p_worksheet_id => :p2_id,',
'    p_websheet_id  => :p2_websheet_id',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\6B77\53F2\8A18\9304\96C6\5408.')
);
end;
/
prompt --application/pages/page_00015
begin
wwv_flow_api.create_page(
 p_id=>15.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\7E3D\89BD')
,p_step_title=>unistr('\7E3D\89BD')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455867416484229688.4907)
,p_plug_name=>unistr('Web \8A66\7B97\8868\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4F7F\7528\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F\6642, \4E00\822C\4F7F\7528\8005\7121\9700\900F\904E\958B\767C\4EBA\54E1\5354\52A9\5373\53EF\7BA1\7406\7D50\69CB\5316\548C\975E\7D50\69CB\5316\8CC7\6599. \300CWeb \8A66\7B97\8868\300D\53EF\8B93\4F7F\7528\8005:</p> '),
'',
'<ul>',
unistr('<li>\53EA\8981\4F7F\7528 Web \700F\89BD\5668, \5373\53EF\5728\7DB2\8DEF\4E0A\5EFA\7ACB\53CA\5171\7528\5167\5BB9.</li>'),
unistr('<li>\4EE5\968E\5C64\5316\65B9\5F0F\7D44\7E54\9801\9762\53CA\4EA4\53C9\9023\7D50\9801\9762 (\4F7F\7528 [[ pagename ]] \8A9E\6CD5).</li>'),
unistr('<li>\4F7F\7528\7A31\70BA\8CC7\6599\65B9\683C\7684\5167\5D4C\529F\80FD, \5EFA\7ACB\53CA\7BA1\7406\5217\8868\5316\8CC7\6599.</li>'),
unistr('<li>\4F7F\7528 SQL \6839\64DA\8CC7\6599\5EAB\5167\7684\73FE\6709\8CC7\6599\7D50\69CB\5EFA\7ACB\4E92\52D5\5F0F\5831\8868.</li>'),
unistr('<li>\4EE5\5716\8868\6216\5831\8868\65B9\5F0F, \986F\793A\9801\9762\5167\7684\8CC7\6599\65B9\683C\548C\5831\8868\8CC7\6599.</li>'),
unistr('<li>\4F7F\7528\6A94\6848\3001\6A19\8A18\548C\9644\8A3B\52A0\8A3B\9801\9762.  \53EF\5728\9801\9762\5167\5BB9\4E2D\4EE5\5167\5D4C\65B9\5F0F\986F\793A\95DC\806F\7684\5F71\50CF (\4F7F\7528 [[image: filename]] \8A9E\6CD5).</li>'),
unistr('<li>\641C\5C0B\9801\9762\5167\5BB9 (\4F7F\7528\5167\5EFA\7684\641C\5C0B\529F\80FD).</li>'),
unistr('<li>\7BA1\7406\53EF\4EE5\767B\5165\7684\4EBA\54E1, \4EE5\53CA\767B\5165\5F8C\53EF\4EE5\8B80\53D6\3001\5BEB\5165\6216\7BA1\7406\61C9\7528\7A0B\5F0F\7684\4EBA\54E1 (\8A8D\8B49\548C\6388\6B0A).</li>'),
'</ul> '))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455869309520274904.4907)
,p_plug_name=>unistr('\9801\9762')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9801\9762\5167\5BB9\6703\5206\70BA\4E0D\540C\7684\5340\6BB5.\300CWeb \8A66\7B97\8868\300D\652F\63F4\4E0B\5217\5340\6BB5\985E\578B:</p>'),
'<ul>',
unistr('<li>\6587\5B57 - \986F\793A\8F38\5165\7684\6587\5B57\3001\5167\5D4C\5F71\50CF\548C\5167\5D4C\5831\8868, \4EE5\53CA\5831\8868\3001\8CC7\6599\65B9\683C\3001\5176\4ED6\9801\9762\3001\6A94\6848\3001\5916\90E8 URL \7B49\7684\9023\7D50. \60A8\53EF\4EE5\4F7F\7528\76F4\89BA\5F0F WYSIWIG \7DE8\8F2F\5668\7BA1\7406\6587\5B57\5340\6BB5.</li>'),
unistr('<li>\5C0E\89BD - \65B0\589E\52D5\614B\7522\751F\7684\5F9E\5C6C\9801\9762\6216\9801\9762\5340\6BB5\5C0E\89BD.</li>'),
unistr('<li>\8CC7\6599 - \6839\64DA\8CC7\6599\65B9\683C\6216\5831\8868\5EFA\7ACB\5167\5D4C\5831\8868.</li>'),
unistr('<li>\5716\8868 - \6839\64DA\8CC7\6599\65B9\683C\6216\5831\8868\5EFA\7ACB\5167\5D4C\5716\8868.</li>'),
'</ul>',
''))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455869514368276321.4907)
,p_plug_name=>unistr('\8A3B\89E3')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\5728\9801\9762\6216\8CC7\6599\65B9\683C\7684\8CC7\6599\5217\5167\5305\62EC\4E0B\5217\8A3B\89E3:</p>'),
'<ul>',
unistr('<li>\6A94\6848 - \4E0A\50B3\4F9B\4E0B\8F09\6216\5728\5340\6BB5\6587\5B57\5167\986F\793A\70BA\5167\5D4C\5F71\50CF\7684\6A94\6848.</li>'),
unistr('<li>\9644\8A3B - \5305\62EC\5167\5BB9\7279\5B9A\7684\9644\8A3B.'),
unistr('<li>\6A19\8A18 - \65B0\589E\6A19\8A18\4EE5\6539\5584\5167\5EFA\7684\641C\5C0B\529F\80FD.'),
'</ul>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455869719909277967.4907)
,p_plug_name=>unistr('\5B58\53D6\63A7\5236')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\7BA1\7406\54E1\53EF\6307\5B9A\4E0B\5217\5176\4E2D\4E00\7A2E\8A8D\8B49\6A5F\5236, \63A7\5236\80FD\5920\767B\5165\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F\7684\4EBA\54E1:</p>'),
'<ul>',
unistr('<li>\516C\7528\5B58\53D6 (\4E0D\9700\8A8D\8B49)</li>'),
unistr('<li>Oracle Application Express \5E33\6236</li>'),
'<li>Oracle Single Sign-On</li>',
unistr('<li>LDAP \8B49\660E\8CC7\6599\9A57\8B49</li>'),
unistr('<li>\81EA\8A02'),
'</ul>',
'',
unistr('<p>\767B\5165\61C9\7528\7A0B\5F0F\4E4B\5F8C, \5373\7531\6307\5B9A\7D66\4F7F\7528\8005\7684\89D2\8272\6C7A\5B9A\5B58\53D6\6B0A.  \652F\63F4\7684\89D2\8272\5305\62EC:</p>'),
'<ul>',
unistr('<li>\7BA1\7406\54E1</li>'),
unistr('<li>\63D0\4F9B\8005</li>'),
unistr('<li>\95B1\8B80\8005</li>'),
'</ul>',
'',
'',
''))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455870812899294887.4907)
,p_plug_name=>unistr('\8CC7\6599\65B9\683C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\8CC7\6599\65B9\683C\662F\63D0\4F9B\8005\5B9A\7FA9\7684\5217\8868\5316\8CC7\6599\96C6, \57FA\672C\4E0A\662F\4E00\500B Web \5F0F\7684\8A66\7B97\8868. \60A8\53EF\4EE5\4F7F\7528\8CC7\6599\6B04\540D\7A31\3001\8CC7\6599\985E\578B\4EE5\53CA\57FA\672C\9A57\8B49\4F86\5B9A\7FA9\8CC7\6599\65B9\683C\7684\7D50\69CB, \6216\8005\53EF\4EE5\8CBC\4E0A\8A66\7B97\8868\8CC7\6599\4F86\5EFA\7ACB\8CC7\6599\65B9\683C.  \5EFA\7ACB\4E4B\5F8C, \60A8\53EF\4EE5\96A8\6642\8996\9700\8981\4FEE\6539\7D50\69CB.</p>'),
'',
unistr('<p>\9664\4E86\5B9A\7FA9\7684\8CC7\6599\6B04\4E4B\5916, \6BCF\500B\8CC7\6599\65B9\683C\5167\4E5F\6703\4E00\5F8B\5305\62EC\4E00\7D44\6A19\6E96\8CC7\6599\6B04. \6A19\6E96\8CC7\6599\6B04\5305\62EC\64C1\6709\8005\3001\5EFA\7ACB\8005\3001\5EFA\7ACB\65E5\671F\3001\66F4\65B0\8005\3001\66F4\65B0\65E5\671F\3001\8CC7\6599\5217\9806\5E8F\4EE5\53CA\8A3B\89E3 (\6A94\6848\3001\9644\8A3B\3001\9023\7D50\4EE5\53CA\6A19\8A18).</p>'),
'',
unistr('<p>\8CC7\6599\65B9\683C\662F\53EF\9AD8\5EA6\81EA\8A02\7684\53EF\7DE8\8F2F\5831\8868. \4F7F\7528\8005\53EF\4EE5\9078\53D6\8CC7\6599\6B04\6216\8005\5957\7528\7BE9\9078\3001\6A19\793A\4EE5\53CA\6392\5E8F, \66F4\6539\5831\8868\8CC7\6599\7684\7248\9762\914D\7F6E. \4F7F\7528\8005\4E5F\53EF\4EE5\5B9A\7FA9\5206\9801\3001\805A\7E3D\3001\7FA4\7D44\4F9D\64DA\3001\904B\7B97\4EE5\53CA\4E0D\540C\7684\5716\8868. \6B64\5916, \4F7F\7528\8005\53EF\4EE5\5EFA\7ACB\591A\7A2E\4E0D\540C\7684\8CC7\6599\65B9\683C, \4E26\5C07\5B83\5011\5132\5B58\70BA\5177\540D\7684\5831\8868, \4F9B\516C\958B\6216\79C1\4EBA\6AA2\8996.</p>'),
'',
unistr('<p>\9664\4E86\53EF\5F9E\300C\6AA2\8996\300D\529F\80FD\8868\5B58\53D6\4E4B\5916, \4E5F\53EF\4EE5\5728\4EFB\4F55\9801\9762\5167\4EE5\5716\8868\6216\5831\8868\7684\65B9\5F0F\542B\62EC\8CC7\6599\65B9\683C\5167\7684\8CC7\6599.</p>')))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(455871123288297886.4907)
,p_plug_name=>unistr('\5831\8868')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'noTableFormatting'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\5831\8868\662F\91DD\5C0D\60A8\53EF\4EE5\5B58\53D6\4E4B\8CC7\6599\5EAB\7269\4EF6\6240\9032\884C\7684\67E5\8A62.  \82E5\8981\5B9A\7FA9\5831\8868, \60A8\53EF\4EE5\7C21\55AE\5730\9078\53D6\53EF\7528\7DB1\8981\5167\7684\8868\683C\6216\8996\89C0\8868, \6216\4F7F\7528\696D\754C\7684\6A19\6E96 SQL \5EFA\7ACB\66F4\8907\96DC\7684\5831\8868.</p>'),
'',
unistr('<p>\5C31\50CF\8CC7\6599\65B9\683C\4E00\6A23, \5831\8868\7684\81EA\8A02\5EA6\4E5F\5F88\9AD8.  \4F7F\7528\8005\53EF\4EE5\9078\64C7\5176\611F\8208\8DA3\7684\8CC7\6599\6B04\4E26\5957\7528\7BE9\9078\3001\6A19\793A\4EE5\53CA\9032\884C\6392\5E8F, \66F4\6539\5831\8868\8CC7\6599\7684\7248\9762\914D\7F6E.  \4E5F\53EF\4EE5\5B9A\7FA9\5206\9801\3001\805A\7E3D\3001\7FA4\7D44\4F9D\64DA\3001\904B\7B97\4EE5\53CA\4E0D\540C\7684\5716\8868.  \4E5F\53EF\4EE5\8A2D\5B9A\8A02\95B1, \6309\6307\5B9A\7684\9593\9694\4EE5\96FB\5B50\90F5\4EF6\5BC4\9001\5831\8868.  \4F7F\7528\8005\53EF\4EE5\5EFA\7ACB\591A\7A2E\4E0D\540C\7684\5831\8868, \4E26\5C07\5B83\5011\5132\5B58\70BA\5177\540D\7684\5831\8868, \4F9B\516C\958B\6216\79C1\4EBA\6AA2\8996.</p>'),
'',
unistr('<p>\9664\4E86\300C\8CC7\6599\300D\9801\7C64\4E0B\53EF\7528\7684\8CC7\6599\4E4B\5916, \4E5F\53EF\4EE5\5728\4EFB\4F55\9801\9762\4E2D\7684\5716\8868\6216\5831\8868\5305\62EC\5831\8868\5167\7684\8CC7\6599.</p>')))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_required_role=>wwv_flow_api.id(492214905335570870)
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466849110862832553.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(468686130956258389.4907)
,p_plug_name=>'anchors'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>5
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_list_template_id=>wwv_flow_api.id(171596314926127907.4907)
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
end;
/
prompt --application/pages/page_00016
begin
wwv_flow_api.create_page(
 p_id=>16.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\95DC\65BC\6B64\61C9\7528\7A0B\5F0F')
,p_step_title=>unistr('\95DC\65BC\6B64\61C9\7528\7A0B\5F0F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css" media="screen">',
'	/* Hide left col */',
'	div.wsSideCol {',
'		 display: none !important;',
'	}',
'	div.wsMainCol {',
'		 padding: 5px;',
'	}',
'</style>'))
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(472804823833588483.4907)
,p_plug_name=>unistr('\95DC\65BC\6B64\61C9\7528\7A0B\5F0F')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_plug_template=>wwv_flow_api.id(82536903857665765.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(472809806454619957.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472810527578626072.4907)
,p_name=>'P16_APPLICATION_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F\540D\7A31')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472817823619814197.4907)
,p_name=>'P16_CREATED_BY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\5EFA\7ACB\8005')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\5EFA\7ACB\61C9\7528\7A0B\5F0F\7684\4EBA\54E1.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472818029160815789.4907)
,p_name=>'P16_CREATED_ON'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\5EFA\7ACB\6642\9593')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\5EFA\7ACB\61C9\7528\7A0B\5F0F\7684\6642\9593.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472818901717826724.4907)
,p_name=>'P16_RUN_LINK'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\57F7\884C\9023\7D50')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\7528\4F86\57F7\884C\6B64\61C9\7528\7A0B\5F0F\7684 URL.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472819621719851449.4907)
,p_name=>'P16_WEB_PAGES'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\9801\9762')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\9801\9762\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472823322804880132.4907)
,p_name=>'P16_DATA_GRIDS'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\8CC7\6599\65B9\683C')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\8CC7\6599\65B9\683C\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472824025144899716.4907)
,p_name=>'P16_REPORTS'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\5831\8868')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_security_scheme=>wwv_flow_api.id(492214905335570870)
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\5831\8868\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472827429534042915.4907)
,p_name=>'P16_FILES'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\6A94\6848')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\6A94\6848\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472829909495065498.4907)
,p_name=>'P16_FILE_STORAGE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\6A94\6848\5132\5B58')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\6240\6709\6A94\6848\7684\7E3D\6A94\6848\5927\5C0F.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472835720408106552.4907)
,p_name=>'P16_PAGE_SECTIONS'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\9801\9762\5340\6BB5')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\5831\8868\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472849515269209062.4907)
,p_name=>'P16_NOTES'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\9644\8A3B')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\9644\8A3B\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472849720118210471.4907)
,p_name=>'P16_TAGS'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\6A19\8A18')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\4E2D\7684\6A19\8A18\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472850124966211939.4907)
,p_name=>'P16_DATAGRID_ROWS'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\8CC7\6599\65B9\683C\8CC7\6599\5217')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\6B64\61C9\7528\7A0B\5F0F\5167\6240\542B\4E4B\6240\6709\8CC7\6599\65B9\683C\4E2D\7684\8CC7\6599\5217\6578\76EE.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(484478622627455477.4907)
,p_name=>'P16_DESCRIPTION'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(472804823833588483.4907)
,p_prompt=>unistr('\63CF\8FF0')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P16_DESCRIPTION'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\61C9\7528\7A0B\5F0F\7684\63CF\8FF0.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(472810926324635162.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set item values'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'    select name, created_by, created_on, id, description',
'    from WWV_FLOW_WS_APPLICATIONS ',
'    where id = :WS_APP_ID and security_group_id = :flow_security_group_id) loop',
'  :P16_APPLICATION_NAME := c1.name;',
'  :P16_CREATED_BY := c1.created_by;',
'  :P16_CREATED_ON := htmldb_util.get_since(c1.created_on);',
'  :P16_RUN_LINK := wwv_flow_utilities.host_url(''SCRIPT'')||''ws?p=''||c1.id||'':home'';',
'  :P16_DESCRIPTION := c1.description;',
'   for c2 in (select count(*) c from WWV_FLOW_WS_WEBPAGES where ws_app_id = c1.id) loop',
'      :P16_WEB_PAGES := to_char(c2.c,''999G999G999G990'');',
'   end loop;',
'   for c2 in (',
'     select count(*) c',
'     from wwv_flow_worksheets w, ',
'             wwv_flow_ws_websheet_attr a',
'     where w.id = a.worksheet_id and',
'         w.security_group_id = :flow_security_group_id and                  ',
'         a.ws_app_id = :ws_app_id and',
'         nvl(a.websheet_type,''DATA'') = ''DATA'') loop',
'    :P16_DATA_GRIDS := to_char(c2.c,''999G999G999G990'');',
'    end loop;',
'    for c2 in (',
'       select count(*) c',
'       from wwv_flow_worksheets w, ',
'              wwv_flow_ws_websheet_attr a',
'       where w.id = a.worksheet_id and',
'                w.security_group_id = :flow_security_group_id and                  ',
'               a.ws_app_id = :ws_app_id and',
'               nvl(a.websheet_type,''DATA'') = ''REPORT'') loop',
'         :P16_REPORTS := c2.c;',
'     end loop;',
'     :P16_files := trim(to_char(wwv_flow_ws_api.get_file_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_FILE_STORAGE :=trim(htmldb_util.filesize_mask(wwv_flow_ws_api.get_file_size(p_ws_app_id=>:WS_APP_ID)));',
'     :P16_PAGE_SECTIONS := trim(to_char(wwv_flow_ws_api.get_section_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_TAGS := trim(to_char(wwv_flow_ws_api.get_tag_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_NOTES := trim(to_char(wwv_flow_ws_api.get_note_count(p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'     :P16_DATAGRID_ROWS := trim(to_char(wwv_flow_ws_api.get_datagrid_row_count(',
'         p_ws_app_id=>:WS_APP_ID),''999G999G999G990''));',
'',
'end loop;'))
);
end;
/
prompt --application/pages/page_00017
begin
wwv_flow_api.create_page(
 p_id=>17.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6A19\8A18\8A9E\6CD5')
,p_step_title=>unistr('\6A19\8A18\8A9E\6CD5')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456375908174931142.4907)
,p_plug_name=>unistr('\5916\90E8 URL')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5728\9801\9762\5340\6BB5\4E2D\5305\542B\5916\90E8 URL \7684\9023\7D50, \8ACB\4F7F\7528\4E0B\65B9\8A9E\6CD5. \8ACB\6CE8\610F, \60A8\53EF\4EE5\9078\64C7\662F\5426\4F7F\7528 <code>''url:''</code> ID. \82E5\8981\5728\65B0\7684\700F\89BD\5668\8996\7A97\4E2D\958B\555F\9023\7D50, \8ACB\4F7F\7528\5373\73FE\5F0F\8996\7A97\524D\7F6E\78BC.</p>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ url: &lt;url> | &lt;\9023\7D50\540D\7A31> ]]'),
unistr('[[ popupurl: &lt;url> | &lt;\9023\7D50\540D\7A31> ]]'),
unistr('[[ &lt;url> | &lt;\9023\7D50\540D\7A31> ]]'),
'</pre>',
'',
unistr('<p><b>\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[url: http://www.oracle.com/store | oraclestore]] ',
'[[popupurl: http://www.oracle.com/store | oraclestore]]',
'[[http://www.google.com | google]] ',
'[[http://www.google.com ]] ',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'You can buy Oracle software on the [[http://www.oracle.com/store | Oracle Store]] web site.',
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456378202762952007.4907)
,p_plug_name=>unistr('\5F71\50CF')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\4E0A\50B3\5F71\50CF\4E4B\5F8C, \60A8\53EF\4F7F\7528\4E0B\5217\8A9E\6CD5\5167\5D4C\4E0B\8F09\9023\7D50, \5728\61C9\7528\7A0B\5F0F\7684\4EFB\4F55\9801\9762\5340\6BB5\5167\986F\793A\8A72\5F71\50CF. \60A8\53EF\4EE5\4F7F\7528\5F71\50CF\540D\7A31\6216\5F71\50CF\5225\540D\53C3\7167\4E0A\50B3\7684\5F71\50CF. \66FF\76EE\524D\9801\9762\5B9A\7FA9\4E4B\5F71\50CF\7684\4F7F\7528\512A\5148\9806\5E8F\9AD8\65BC\8207\5176\4ED6\9801\9762\95DC\806F\7684\5F71\50CF. \5982\679C\5F71\50CF\540D\7A31\4E0D\660E\78BA, \5C07\6703\986F\793A\6700\8FD1\5EFA\7ACB\7684\5F71\50CF. \60A8\53EF\4EE5\91DD\5C0D\6A94\6848\5B9A\7FA9\5F71\50CF\7279\6027\6216\4EE5\5167\5D4C\65B9\5F0F\5B9A\7FA9. \82E5\4EE5\5167\5D4C\65B9\5F0F\5B9A\7FA9\5C6C\6027, \5167\5D4C\5C6C\6027\7684\512A\5148\9806\5E8F\5C07\9AD8\65BC\91DD\5C0D\6A94\6848\5B9A\7FA9\7684\5C6C\6027.</p>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ image: &lt; \6A94\6848\540D\7A31 > | &lt; \7279\6027 > ]]'),
unistr('[[ image: &lt; \6A94\6848\5225\540D > | &lt; \7279\6027 > ]]'),
'</pre>',
'',
unistr('<p><b>\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[image: myimage ]]',
'[[image: theimagename.jpg ]]',
'[[image: myimage | width="600" alt="my image" ]]',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'This diagram [[image: diagram1]] illustrates the work flow.',
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456378508650953757.4907)
,p_plug_name=>unistr('\9801\9762\9023\7D50\529F\80FD')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5C07\9801\9762\5340\6BB5\4E2D\7684\9023\7D50\5305\542B\81F3\300CWeb \8A66\7B97\8868\300D\4E2D\7684\5176\4ED6\9801\9762, \8ACB\4F7F\7528\4E0B\65B9\8A9E\6CD5.  \8ACB\6CE8\610F, \60A8\53EF\4EE5\9078\64C7\662F\5426\4F7F\7528 <code>''page:''</code> ID. \5982\679C\9801\9762\5B58\5728, \5C07\6703\986F\793A\9023\7D50. \5982\679C\9801\9762\4E0D\5B58\5728, \5247\986F\793A\5EFA\7ACB\8A72\9801\9762\7684\9023\7D50.</p>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ page: &lt;\9801\9762\5225\540D> | &lt;\9023\7D50\540D\7A31> ]]'),
unistr('[[ &lt;\9801\9762\5225\540D> | &lt;\9023\7D50\540D\7A31> ]]'),
'</pre>',
'',
unistr('<p><b>\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[page: home]] ',
'[[mypage | My Page]] ',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'One of the most colorful fish is the [[ clownfish | Clown fish]].',
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456378714883955473.4907)
,p_plug_name=>unistr('\8CC7\6599\65B9\683C\9023\7D50')
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5728\9801\9762\5340\6BB5\5167\5305\542B\8CC7\6599\65B9\683C\9023\7D50, \8ACB\4F7F\7528\4E0B\65B9\8A9E\6CD5. \60A8\53EF\4EE5\4F7F\7528\9019\4E9B\9023\7D50\4F86\6AA2\8996\8CC7\6599\65B9\683C\6216\5EFA\7ACB\65B0\8CC7\6599.  \8ACB\6CE8\610F, \8CC7\6599\65B9\683C\53EF\4EE5\662F\4E00\6216\5169\500B\5B57.</p>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ data grid: &lt;\8CC7\6599\65B9\683C\5225\540D> | &lt;\9023\7D50\540D\7A31> ]] '),
unistr('[[ datagrid: &lt;\8CC7\6599\65B9\683C\5225\540D> | &lt;\9023\7D50\540D\7A31> ]]'),
unistr('[[ datagrid: &lt;\8CC7\6599\65B9\683C\5225\540D> . &lt;\9810\5B58\5831\8868\540D\7A31 (\4E0D\53EF\4EE5\662F\5C08\7528\5831\8868)> | &lt;\9023\7D50\540D\7A31> ]]'),
'</pre>',
'',
unistr('<p><b>\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[ data grid: todo list | To Do List ]] ',
'[[ datagrid: todo list | To Do List ]] ',
'[[ data grid: todo list . open todo items | To Do List ]] ',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'Please review the [[ data grid: todo list | To Do List ]] and ensure ',
'your tasks can be accomplished by Friday.',
'</pre>'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456463415491324659.4907)
,p_plug_name=>unistr('\5340\6BB5\9023\7D50\529F\80FD')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5305\542B\9801\9762\4E4B\67D0\500B\5340\6BB5\7684\9023\7D50, \8ACB\4F7F\7528\4E0B\65B9\8A9E\6CD5. \5982\679C\5340\6BB5\5B58\5728, \5C31\6703\986F\793A\9023\7D50. \5982\679C\5340\6BB5\4E0D\5B58\5728, \5C31\6703\986F\793A\5EFA\7ACB\8A72\5340\6BB5\7684\9023\7D50. \8ACB\6CE8\610F, \5982\679C\67D0\500B\9801\9762\4E00\958B\59CB\6C92\6709\8A72\5340\6BB5, \5247\5047\8A2D\8A72\5340\6BB5\5728\76EE\524D\7684\9801\9762\4E2D.</p>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ section: &lt;\9801\9762\5225\540D> . &lt;\9801\9762\5340\6BB5> | &lt;\9023\7D50\540D\7A31> ]]'),
unistr('[[ section: &lt;\9801\9762\5340\6BB5> | &lt;\9023\7D50\540D\7A31> ]]'),
'</pre>',
'',
unistr('<p><b>\5728\76EE\524D\9801\9762\5167\9023\7D50\7684\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[section: clownfish | Clown Fish]] ',
'</pre>',
'',
unistr('<p><b>\9023\7D50\81F3\5176\4ED6\9801\9762\7684\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[section: fish.clownfish | Clown Fish]] ',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'One of the most colorful fish is the [[ section: clownfish | Clown fish]].',
'Visit or fish page to see the [[ section: fish . clownfish | Clown fish]], also known as Nemo.',
'</pre>',
'',
''))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456475006515549140.4907)
,p_plug_name=>'Anchors'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_list_template_id=>wwv_flow_api.id(171596314926127907.4907)
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456475623830554083.4907)
,p_plug_name=>'SQL'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506319619645513438.4907)
,p_plug_name=>'SQL Introduction'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4EE5\4F7F\7528 <code>SQL</code> \6216 <code>SQLVALUE</code> \8A9E\6CD5, \5728\9801\9762\5340\6BB5\5167\5305\542B\8CC7\6599\65B9\683C\6216\8868\683C\8207\6AA2\8996\67E5\8A62\7684\55AE\4E00\503C\6216\5217\8868\5316\7D50\679C. <code>SQLVALUE</code> \6A19\8A18\6703\986F\793A SQL \67E5\8A62\50B3\56DE\7684\7B2C\4E00\500B\8CC7\6599\5217\7684\7B2C\4E00\500B\8CC7\6599\6B04. \9019\53EF\8B93\60A8\5728\53E5\5B50\4E2D\5167\5D4C\8CC7\6599 (\4F8B\5982: There are currently 5 types of cats.). \5982\9700\5217\8868\5316\7D50\679C, \8ACB\4F7F\7528 <code>SQL</code> \6A19\8A18. <code>SQL</code> \6A19\8A18\7D50\679C')
||unistr('\6703\986F\793A\65BC\53EF\641C\5C0B\7684\5831\8868\4E2D. \7136\800C, \4F9D\7167\9810\8A2D, \53EF\4EE5\4F7F\7528 <code>NOSEARCH</code> \8A9E\6CD5\505C\7528\641C\5C0B\9078\9805.</p>'),
'',
unistr('<p>\4F7F\7528\8CC7\6599\65B9\683C\6642, \9084\6709\4E00\4E9B\9078\9805 (\986F\793A\65BC\300C\8A9E\6CD5\300D\5E95\4E0B) \548C\4E00\4E9B\898F\5247. \64B0\5BEB\8CC7\6599\65B9\683C\67E5\8A62\6642\7684\57FA\672C\898F\5247\5305\62EC:</p>'),
'<p>',
'<ul>',
unistr('<li>\8CC7\6599\65B9\683C\540D\7A31\6216\8CC7\6599\65B9\683C\5225\540D\5FC5\9808\4EE5\5927\62EC\5F27\62EC\4F4F. \4F8B\5982:'),
'<pre>{Cat Facts}</pre></li>',
unistr('<li>\300C\8CC7\6599\65B9\683C\300D\8CC7\6599\6B04\540D\7A31\5FC5\9808\4EE5\96D9\5F15\865F\62EC\4F4F. \4F8B\5982:'),
'<pre>"Type of Cat"</pre></li>',
'</ul>',
unistr('\9032\968E\898F\5247\8A73\8FF0\65BC\6700\5F8C\4E00\500B\6BB5\843D\4E2D.'),
'</p>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506320009733520103.4907)
,p_plug_name=>'SQL Syntax'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p><b>\67E5\8A62\8868\683C\8207\8996\89C0\8868\7684\8A9E\6CD5:</b></p>'),
'<pre>',
'[[sql: &lt;select statement> ]]',
'[[sql: &lt;select statement | limit="&lt;maximum rows>" nosearch style="&lt;style number>" ]]',
'[[sqlvalue: &lt;select statement> ]]',
'</pre>',
'',
unistr('<p><b>\8CC7\6599\65B9\683C\67E5\8A62\7684\8A9E\6CD5:</b></p>'),
'<pre>',
'[[sql: &lt;select statement> ]]',
'[[sql: &lt;select statement | limit="&lt;maximum rows>" nosearch style="&lt;style number>" edit_row add_row show_sql ]]',
'[[sqlvalue: &lt;select statement> ]]',
'[[sqlvalue: &lt;select statement> | show_sql ]]',
'</pre>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506320222200523729.4907)
,p_plug_name=>'SQL Examples'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684 SQL \6A19\8A18\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'Here is a report of at most 10 employees who work in department 10: ',
'[[sql: select ename "Employee Name", sal "Salary" from emp order by sal desc | limit="10" style="2"]].',
'[[sql: select "Type of Cat",',
'              "Estimated Population",',
'              "Largest Threats",',
'              "Top Speed",',
'              "Scientific Name",',
'              "IUCN Status",',
'              "Weight",',
'              "Study Date"',
'       from {Cat Facts} | add_row edit_row ]]',
'</pre>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(506321126618543925.4907)
,p_plug_name=>'SQLVALUE Tag Example'
,p_parent_plug_id=>wwv_flow_api.id(456475623830554083.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684 SQLVALUE \6A19\8A18\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'We have [[sqlvalue: select count(*) from emp]] employees in our database, ',
'[[sqlvalue: select count(*) from emp where deptno=10 ]] work in department 10.',
'We are currently tracking [[sqlvalue: select count(*) from {Cat Facts} ]] types of cats.',
'</pre>'))
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456684602920305675.4907)
,p_plug_name=>unistr('\5831\8868\9023\7D50')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5728\9801\9762\5340\6BB5\5167\5305\542B\5831\8868\9023\7D50, \8ACB\4F7F\7528\4E0B\5217\8A9E\6CD5.</p>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ report: &lt;\5831\8868\5225\540D> | &lt;\9023\7D50\540D\7A31> ]]'),
unistr('[[ report: &lt;\5831\8868\5225\540D> . &lt;\9810\5B58\5831\8868\540D\7A31 (\4E0D\53EF\4EE5\662F\5C08\7528\5831\8868)> | &lt;\9023\7D50\540D\7A31> ]] '),
'</pre>',
'',
unistr('<p><b>\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[ report: fish | marine fish ]]',
'[[ report: fish . my favorite | marine fish ]] ',
'',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'View the [[ report: fish | perfect temperature ]] for selected marine fish.',
'</pre>'))
,p_plug_required_role=>wwv_flow_api.id(492214905335570870)
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456722229827231075.4907)
,p_plug_name=>unistr('\6A94\6848')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\60A8\53EF\4F7F\7528\4E0B\5217\8A9E\6CD5, \5C07\9801\9762\5340\6BB5\5167\7684\4E0B\8F09\9023\7D50\5167\5D4C\81F3\4E0A\50B3\7684\6A94\6848.<p/>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ file: &lt; \6A94\6848\540D\7A31 > | &lt; \9023\7D50\540D\7A31 > ]]'),
unistr('[[ file: &lt; \6A94\6848\5225\540D > | &lt; \9023\7D50\540D\7A31 > ]]'),
'</pre>',
'',
unistr('<p><b>\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[file: myfile ]]',
'[[file: myfile.xls ]]',
'[[file: myfile | My File ]]',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'This [[file: parts01.xls | spreadsheet ]] documents our part numbers.',
'</pre>'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466849412509851927.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752825018135722319.4907)
,p_plug_name=>unistr('\9032\968E\8CC7\6599\65B9\683C\67E5\8A62')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>105
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\9032\968E\8CC7\6599\65B9\683C\67E5\8A62\898F\5247\5305\62EC:</p>'),
'<p>',
'<ul>',
unistr('<li>\67E5\8A62\5FC5\9808\53EA\80FD\53C3\7167\8CC7\6599\65B9\683C\4E00\6B21, \624D\80FD\5305\542B\7DE8\8F2F\6216\65B0\589E\8CC7\6599\5217\9023\7D50 (\4E5F\5C31\662F\8AAA, \60A8\4E0D\80FD\5C07\8CC7\6599\65B9\683C\52A0\5165\67E5\8A62\5167\7684\8CC7\6599\65B9\683C\672C\8EAB).</li>'),
unistr('<li>\7B2C\4E00\500B\8CC7\6599\6B04\5FC5\9808\662F\8981\5305\542B\7DE8\8F2F\8CC7\6599\5217\9023\7D50\4E4B\8CC7\6599\65B9\683C\7684\4E3B\7D22\5F15\9375 (\4EA6\5373, \53EF\552F\4E00\8B58\5225\8CC7\6599\4E4B\8CC7\6599\5217\7684\8CC7\6599\6B04). \82E5\5305\542B "edit_row" \9078\9805, \4E14\67E5\8A62\542B\6709\55AE\4E00 select \6558\8FF0\53E5, \5247\6703\81EA\52D5\5305\542B\4E3B\7D22\5F15\9375\8CC7\6599\6B04. \5982\679C\67E5\8A62\5305\542B\591A\500B select \6558\8FF0\53E5, \60A8\53EF\4EE5\4F7F\7528 <code>"APXWS_DATA_GRID_PK"</code> \66FF\4EE3\9805\76EE (\5FC5\9808\4EE5\96D9\5F15\865F\62EC\4F4F) \4F5C\70BA select \6558\8FF0\53E5\4E2D\5305\542B\4E3B\7D22\5F15\9375\7684\7B2C\4E00\500B\8CC7\6599\6B04, \4EE5\542B\62EC\7DE8\8F2F\8CC7\6599\5217\9023\7D50.</li>'),
unistr('<li>\5831\8868\8CC7\6599\6B04\540D\7A31\5C07\662F\8CC7\6599\65B9\683C\4E2D\7684\8CC7\6599\6B04\540D\7A31, \4F46\53EF\4F7F\7528\6A19\6E96 SQL \8CC7\6599\6B04\5225\540D\8A9E\6CD5\52A0\4EE5\4FEE\6539. \4F8B\5982, \4EE5\4E0B\986F\793A "Minimum Number" \8CC7\6599\6B04\4E2D\7684\8CC7\6599, \4F46\6A19\984C\5C07\986F\793A\70BA "Min":'),
'<pre>select "Minimum Number" "Min" from ...</pre></li>',
unistr('<li>\5982\679C\8CC7\6599\6B04\540D\7A31\8D85\904E 30 \500B\5B57\5143, \53EA\6703\4F7F\7528\524D 30 \500B\5B57\5143\4F5C\70BA\540D\7A31. \4F8B\5982, \4F7F\7528: '),
'<pre>"% of Estimated Lions per Regio"</pre> ',
unistr('\800C\975E:'),
'<pre>"% of Estimated Lions per Region"</pre>',
unistr('<li>\82E5\8981\986F\793A\5DF2\57F7\884C\7684\67E5\8A62, \8ACB\5305\542B "show_sql" \9078\9805, \5373\53EF\5728\5305\542B\7684\5831\8868\4E0A\65B9\986F\793A\67E5\8A62. \96D6\7136\9019\662F\9664\932F\7684\597D\65B9\6CD5, \4F46 Oracle \4E0D\5EFA\8B70\5728\751F\7522\74B0\5883\7684\61C9\7528\7A0B\5F0F\4F7F\7528 "show_sql" \9078\9805.</li>'),
'</ul>',
'</p>'))
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00018
begin
wwv_flow_api.create_page(
 p_id=>18.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\9801\9762\6AA2\8996')
,p_step_title=>unistr('\9801\9762\6AA2\8996')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23684126174999945.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23684522796999946.4907)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23684126174999945.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>200
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23691322028074401.4907)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23684126174999945.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459633427711416362.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459640000854444211.4907)
,p_plug_name=>'Page Views'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    time_stamp,',
'    (select name from wwv_flow_steps p where p.id = l.step_id and p.flow_id = 4900) component_name,',
'    webpage_id,',
'    decode(webpage_id,null,null,(',
'       select max(name)',
'       from wwv_flow_ws_webpages p',
'       where p.ws_app_id = :ws_app_id',
'       and p.security_group_id = :flow_security_group_id',
'       and p.id = l.webpage_id)) page_name,',
'    elap,',
'    num_rows,',
'    lower(userid) userid,',
'    session_id,',
'    substr(user_agent,1,100) user_agent,',
'    sqlerrm,',
'   websheet_id,',
'   worksheet_id,',
'   ir_search,',
'   CONTENT_LENGTH',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P18_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    webpage_id in (select id from wwv_flow_ws_webpages where ws_app_id = :ws_app_id and security_group_id = :flow_security_group_id)'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(459640129876444211.4907)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640328679444227.4907)
,p_db_column_name=>'TIME_STAMP'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\65E5\671F')
,p_column_type=>'DATE'
,p_heading_alignment=>'LEFT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640430971444230.4907)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\5448\73FE\6642\9593')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640528870444230.4907)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\8CC7\6599\5217')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459640631431444230.4907)
,p_db_column_name=>'USERID'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\4F7F\7528\8005')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459641100631444231.4907)
,p_db_column_name=>'SESSION_ID'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\968E\6BB5\4F5C\696D')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459641220629444231.4907)
,p_db_column_name=>'USER_AGENT'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\4F7F\7528\8005\4EE3\7406\7A0B\5F0F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459641414761444232.4907)
,p_db_column_name=>'SQLERRM'
,p_display_order=>12
,p_column_identifier=>'L'
,p_column_label=>unistr('\932F\8AA4\8A0A\606F')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642022665444233.4907)
,p_db_column_name=>'WEBSHEET_ID'
,p_display_order=>18
,p_column_identifier=>'R'
,p_column_label=>unistr('Web \8A66\7B97\8868')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642106997444233.4907)
,p_db_column_name=>'WORKSHEET_ID'
,p_display_order=>19
,p_column_identifier=>'S'
,p_column_label=>unistr('\5DE5\4F5C\8868')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642211221444233.4907)
,p_db_column_name=>'IR_SEARCH'
,p_display_order=>20
,p_column_identifier=>'T'
,p_column_label=>unistr('\641C\5C0B\6587\5B57')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459642314321444233.4907)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5167\5BB9\9577\5EA6')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459654731381564614.4907)
,p_db_column_name=>'WEBPAGE_ID'
,p_display_order=>23
,p_column_identifier=>'W'
,p_column_label=>unistr('\9801\9762 ID')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459654904510641947.4907)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('\9801\9762\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459656813953701510.4907)
,p_db_column_name=>'COMPONENT_NAME'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\5143\4EF6\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(459653504454537879.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(459640000854444211.4907)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:18,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459652428040497404.4907)
,p_name=>'P18_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23684522796999946.4907)
,p_item_default=>'1'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\986F\793A\6240\9078\5831\8868\6642\9593\7BC4\570D\5167\7684\5831\8868\8CC7\6599.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00019
begin
wwv_flow_api.create_page(
 p_id=>19.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5E38\898B\554F\984C')
,p_step_title=>unistr('\5E38\898B\554F\984C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style type="text/css" media="screen">',
'	/* Hide left col */',
'	div.wsSideCol {',
'		 display: none !important;',
'	}',
'	div.wsMainCol {',
'		 padding: 5px;',
'	}',
'</style>'))
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(487174720945604524.4907)
,p_plug_name=>unistr('\5E38\898B\554F\984C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''<p><ol>'');',
'for i in 1..6 loop',
'    sys.htp.p(''<li>'');',
'    sys.htp.p(''<b>''||wwv_flow_lang.system_message(''WEBSHEETS_FAQ_Q''||i)||''</b>'');',
'    sys.htp.p(''<p>''||wwv_flow_lang.system_message(''WEBSHEETS_FAQ_A''||i)||''</p>'');',
'    sys.htp.p(''</li>'');',
'end loop;',
'sys.htp.p(''</ol></p>'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(487175204107609089.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
end;
/
prompt --application/pages/page_00020
begin
wwv_flow_api.create_page(
 p_id=>20.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\65B0\589E/\7DE8\8F2F\8CC7\6599\5217')
,p_step_title=>unistr('\65B0\589E/\7DE8\8F2F\8CC7\6599\5217')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'.ie7 table.wsTable,',
'.ie9 table.wsTable { width: 100%;}',
'</style>'))
,p_step_template=>wwv_flow_api.id(9297021464956579.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_comment=>'onload="wsPageInit(); $x_Hide(''R177113009695013686'');"'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3156111248550044.4907)
,p_plug_name=>'HIDDEN FORM ELEMENTS'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(173336062654423126.4907)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18840420076327189.4907)
,p_plug_name=>'Toolbar Right Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(60003614641461883.4907)
,p_plug_name=>'edit row'
,p_region_name=>'row'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_validation_passed varchar2(1) := null;  ',
'begin',
'  if :P20_VALIDATION_CNT > 0 then',
'    l_validation_passed := ''N'';',
'  else',
'    l_validation_passed := ''Y'';',
'  end if;',
'',
'  wwv_flow_ws_form.show (',
'    p_ws_app_id            => :WS_APP_ID,',
'    p_worksheet_id         => :P2_ID,',
'    p_data_grid_id         => :P2_WEBSHEET_ID,',
'    p_session              => :APP_SESSION,',
'    p_app_user             => :APP_USER,',
'    p_row_id               => :CURRENT_WORKSHEET_ROW,         ',
'    p_base_report_id       => :RPT_ID,',
'    p_partial_page_refresh => false,    ',
'    p_validation_passed    => l_validation_passed,',
'    p_last_page_id         => :P20_LAST_PAGE_ID,',
'    p_last_section_id      => :P20_LAST_SECTION_ID',
'    );',
'',
'  sys.htp.prn(''<span id="apexir_LOADER" style="display:none;" role="alert">'');',
'  sys.htp.prn(''<img alt="''||wwv_flow_lang.system_message(''WAITING.GENERIC'')||''" src="''||wwv_flow.g_image_prefix||''ws/ajax-loader.gif" />'');',
'  sys.htp.prn(''</span>'');    ',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(81681415007489705.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(466744416033456525.4907)
,p_plug_name=>'Ajax Notification Holder'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'<div class="htmldbNotification" id="ajaxMESSAGE" style="display:none;"><img src="#IMAGE_PREFIX#delete.gif" onclick="apex.jQuery(''#ajaxMESSAGE'').hide();"  style="float:right;" class="pb" alt="" /><div id="theMESSAGE"></div></div>'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(617574631447733199.4907)
,p_plug_name=>unistr('\52D5\4F5C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_form.show_actions (',
'    p_ws_app_id       => :WS_APP_ID,',
'    p_ir_id           => :P2_ID,',
'    p_data_grid_id    => :P2_WEBSHEET_ID,',
'    p_row_id          => :CURRENT_WORKSHEET_ROW',
'    );'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'CURRENT_WORKSHEET_ROW'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(18840704623332140.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(18840420076327189.4907)
,p_button_name=>'BACK'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157417700068555483.4907)
,p_branch_action=>'&P20_RETURN_URL.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'PLSQL_EXPRESSION'
,p_branch_condition=>':REQUEST in (''CREATE'',''APPLY_CHANGES'',''DELETE'') and :P20_RETURN_URL is not null'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(3142429378139099.4907)
,p_branch_action=>'f?p=&APP_ID.:50:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>60
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'ATTACHMENT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157307002240912816.4907)
,p_branch_action=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>70
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3040322372230697.4907)
,p_name=>'P20_DESC'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_prompt=>unistr('\63CF\8FF0')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(3142702413159613.4907)
,p_name=>'P20_X'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_FILE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'WWV_FLOW_FILES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(10603912332220266.4907)
,p_name=>'P20_LAST_SECTION_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(253264503612911225.4907)
,p_name=>'P20_LAST_PAGE_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(254176711273952957.4907)
,p_name=>'P20_RETURN_URL'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(636400801424215275.4907)
,p_name=>'P20_VALIDATION_CNT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2495429001405484202.4907)
,p_name=>'P20_IR_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2495429311101487046.4907)
,p_name=>'P20_DATA_GRID_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2495988315189126716.4907)
,p_name=>'P20_ROW_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(3156111248550044.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2495429625300491103.4907)
,p_computation_sequence=>10
,p_computation_item=>'P2_ID'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P20_IR_ID'
,p_compute_when=>'P20_IR_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(2495430601190493614.4907)
,p_computation_sequence=>20
,p_computation_item=>'P2_WEBSHEET_ID'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P20_DATA_GRID_ID'
,p_compute_when=>'P20_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(254184217200086883.4907)
,p_computation_sequence=>40
,p_computation_item=>'P20_RETURN_URL'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_url             varchar2(4000);',
'    l_page_alias      varchar2(255);',
'    l_data_grid_alias varchar2(255);',
'begin               ',
'    if :P20_LAST_PAGE_ID is not null then',
'        l_page_alias := wwv_flow_ws_api.get_page_alias(p_ws_app_id => :WS_APP_ID,p_page_id=> :P20_LAST_PAGE_ID);',
'        l_url := wwv_flow_ws_webpage.get_url (',
'                    p_ws_app_id   => :WS_APP_ID,',
'                    p_session     => :APP_SESSION,',
'                    p_alias       => l_page_alias,',
'                    p_url_postfix => ''#SECTION_''||:P20_LAST_SECTION_ID);',
'    else',
'        l_data_grid_alias := wwv_flow_ws_api.get_data_grid_alias(p_ws_app_id => :WS_APP_ID,p_data_grid_id=> :P20_DATA_GRID_ID);',
'        l_url := wwv_flow_ws_webpage.get_url (',
'                    p_ws_app_id   => :WS_APP_ID,',
'                    p_session     => :APP_SESSION,',
'                    p_alias       => ''DG_''||l_data_grid_alias);',
'    end if;',
'    return l_url;',
'end;'))
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(471737310147352854.4907)
,p_computation_sequence=>20
,p_computation_item=>'WORKSHEET_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>'return wwv_flow_ws_api.get_websheet_name(p_worksheet_id => :p2_id);'
,p_computation_error_message=>unistr('\7121\6CD5\53D6\5F97\300C\8CC7\6599\65B9\683C\300D\540D\7A31.')
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(162010510295416465.4907)
,p_computation_sequence=>30
,p_computation_item=>'F4900_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'20'
,p_compute_when_type=>'%null%'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458952427548535993.4907)
,p_validation_name=>'process row'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_validation_error varchar2(32767);',
'  l_validation_count number;',
'begin',
'',
'wwv_flow_ws_api.process_row (',
'    p_ws_app_id     => :WS_APP_ID,',
'    p_worksheet_id  => :P2_ID,',
'    p_websheet_id   => :P2_WEBSHEET_ID,',
'    p_row_id        => :CURRENT_WORKSHEET_ROW,',
'    f01             => wwv_flow.g_f01,',
'    f02             => wwv_flow.g_f02,   ',
'    p_validation_error => l_validation_error,',
'    p_validation_count => l_validation_count,',
'    p_ajax_mode     => false );',
'',
'  :P20_VALIDATION_CNT :=  l_validation_count;',
'',
'  return '''';',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\767C\751F\9A57\8B49\932F\8AA4.')
,p_validation_condition=>'CREATE_AND_CREATE_ANOTHER,CREATE,APPLY_CHANGES'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(157440521988694296.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete Row'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.delete_row(',
'    p_websheet_id   => :P2_WEBSHEET_ID,',
'    p_row_id        => :CURRENT_WORKSHEET_ROW);'))
,p_process_error_message=>unistr('\7121\6CD5\8655\7406\8981\6C42.')
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00022
begin
wwv_flow_api.create_page(
 p_id=>22.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\8CC7\6599\65B9\683C SQL \8A9E\6CD5')
,p_step_title=>unistr('\8CC7\6599\65B9\683C SQL \8A9E\6CD5')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6247329636592604.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6498131507796437.4907)
,p_plug_name=>'Data Grids'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.p22_data_grid_list (',
'    p_app_id       => :app_id,',
'    p_app_session  => :app_session,',
'    p_ws_app_id    => :ws_app_id,',
'    p_data_grid_id => :P22_DATA_GRID_ID);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6674628032470220.4907)
,p_plug_name=>unistr('\542B\6709 &P22_DATA_GRID_NAME. \7684\8CC7\6599\6B04')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.p22_data_grid_columns (',
'    p_data_grid_id   => :P22_DATA_GRID_ID);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6707429061744964.4907)
,p_plug_name=>unistr('\6839\64DA &P22_DATA_GRID_NAME. \7684\67E5\8A62')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.p22_data_grid_query (',
'    p_data_grid_id   => :P22_DATA_GRID_ID);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\5F9E\5DE6\908A\9078\53D6\4E00\500B\8CC7\6599\65B9\683C, \4EE5\7522\751F\53EF\5728\61C9\7528\7A0B\5F0F\5167\4F7F\7528\7684 SQL \548C SQLVALUE \67E5\8A62.</p>')
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11359532303186287.4907)
,p_plug_name=>unistr('\6C92\6709\8CC7\6599\65B9\683C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(1071999318750156264.4907)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<div class="wsPageMessage">\61C9\7528\7A0B\5F0F\6C92\6709\4EFB\4F55\300C\8CC7\6599\65B9\683C\300D.</div>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(133788708672776881.4907)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(248081616517731203.4907)
,p_plug_name=>unistr('\8A2D\5B9A &P22_DATA_GRID_NAME. \7684\66F8\7C64\9023\7D50.')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>75
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'sys.htp.p(''ws?p=''||:WS_APP_ID||'':DG_''||:P22_DATA_GRID_ALIAS);',
'sys.htp.p(''<br />'');',
'sys.htp.p(''ws?p=''||:WS_APP_ID||'':DG_''||:P22_DATA_GRID_ALIAS||''::ROW_ID:[DATA_GRID_ROW_ID]'');',
'sys.htp.p(''<br /><br />'');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\82E5\8981\76F4\63A5\8A2D\5B9A\300C\8CC7\6599\65B9\683C\300D\6216\8CC7\6599\5217\66F8\7C64, \8ACB\4F7F\7528\4E0B\5217\8A9E\6CD5:</p>')
,p_plug_footer=>unistr('<p>\6CE8\610F: DATA_GRID_ROW_ID \662F APEX$_WS_ROWS \8868\683C\7684 ID \8CC7\6599\6B04\503C.  \60A8\53EF\4EE5\900F\904E\57F7\884C\300C\8CC7\6599\65B9\683C\300D, \6309\4E00\4E0B\7DE8\8F2F\8CC7\6599\5217\5716\793A\4E26\5F9E\700F\89BD\5668\53D6\5F97 URL, \5373\53EF\53D6\5F97\7279\5B9A\300C\8CC7\6599\65B9\683C\300D\8CC7\6599\5217\7684\9023\7D50.</p>')
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(268418006320837162.4907)
,p_plug_name=>unistr('\9023\7D50\81F3 &P22_DATA_GRID_NAME. (\6A19\8A18\8A9E\6CD5)')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>85
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('<p>\82E5\8981\5728\9801\9762\5340\6BB5\5167\5305\542B\8CC7\6599\65B9\683C\9023\7D50, \8ACB\4F7F\7528\4E0B\65B9\8A9E\6CD5. \60A8\53EF\4EE5\4F7F\7528\9019\4E9B\9023\7D50\4F86\6AA2\8996\8CC7\6599\65B9\683C\6216\5EFA\7ACB\65B0\8CC7\6599.  \8ACB\6CE8\610F, \8CC7\6599\65B9\683C\53EF\4EE5\662F\4E00\6216\5169\500B\5B57.</p>'),
'',
unistr('<p><b>\8A9E\6CD5:</b></p>'),
'<pre>',
unistr('[[ data grid: &lt;\8CC7\6599\65B9\683C\5225\540D | &lt;\9023\7D50\540D\7A31> ]] '),
unistr('[[ datagrid: &lt;\8CC7\6599\65B9\683C\5225\540D | &lt;\9023\7D50\540D\7A31> ]] '),
unistr('[[ datagrid: &lt;\8CC7\6599\65B9\683C\5225\540D . &lt;\9810\5B58\5831\8868\540D\7A31 (\4E0D\53EF\4EE5\662F\5C08\7528\5831\8868)> | &lt;\9023\7D50\540D\7A31> ]] '),
'</pre>',
'',
unistr('<p><b>\8A9E\6CD5\7BC4\4F8B:</b></p>'),
'<pre>',
'[[ data grid: todo list | To Do List ]] ',
'[[ data grid: todo list . open todo items | To Do List ]] ',
'[[ datagrid: todo list | To Do List ]] ',
'</pre>',
'',
unistr('<p><b>\9801\9762\5167\5BB9\4E2D\7684\7BC4\4F8B:</b></p>'),
'<pre>',
'Please review the [[ data grid: todo list | To Do List ]] and ensure ',
'your tasks can be accomplished by Friday.',
'</pre>',
''))
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P22_DATA_GRID_ID'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(6706611868673736.4907)
,p_name=>'P22_DATA_GRID_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(133788708672776881.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(248170113574405575.4907)
,p_name=>'P22_DATA_GRID_ALIAS'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(133788708672776881.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(605139824509083611.4907)
,p_name=>'P22_DATA_GRID_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(133788708672776881.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(8467419570074984.4907)
,p_computation_sequence=>10
,p_computation_item=>'P22_DATA_GRID_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'from wwv_flow_ws_websheet_attr',
'where security_group_id = :flow_security_group_id',
'and ws_app_id = :ws_app_id',
'and rownum = 1',
'order by websheet_name',
''))
,p_compute_when=>'P22_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(248170305595409210.4907)
,p_computation_sequence=>10
,p_computation_item=>'P22_DATA_GRID_ALIAS'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_alias',
'from wwv_flow_ws_websheet_attr',
'where security_group_id = :flow_security_group_id',
'and ws_app_id = :ws_app_id',
'and id = :P22_DATA_GRID_ID'))
,p_compute_when=>'P22_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(605211826718093751.4907)
,p_computation_sequence=>10
,p_computation_item=>'P22_DATA_GRID_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name',
'from wwv_flow_ws_websheet_attr',
'where security_group_id = :flow_security_group_id',
'and ws_app_id = :ws_app_id',
'and id = :P22_DATA_GRID_ID',
''))
,p_compute_when=>'P22_DATA_GRID_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00024
begin
wwv_flow_api.create_page(
 p_id=>24.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\9801\9762')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\9801\9762')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459659409774763317.4907)
,p_plug_name=>'Page Views'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    webpage_id,',
'    decode(webpage_id,null,null,(',
'       select max(name)',
'       from wwv_flow_ws_webpages p',
'       where p.ws_app_id = :ws_app_id',
'       and p.id = l.webpage_id)) page_name,',
'    count(*) page_views,',
'    avg(elap) elap,',
'    avg(num_rows) num_rows,',
'    count(distinct userid) userid,',
'    avg(content_length) CONTENT_LENGTH,',
'  sum(CONTENT_LENGTH) content_served,',
'   sum(elap) page_generation_time,',
'   max(time_stamp) last_view',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P24_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    webpage_id is not null  and',
'    webpage_id in (select id from wwv_flow_ws_webpages where ws_app_id = :ws_app_id and security_group_id = :flow_security_group_id)',
'group by     webpage_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(459659605981763318.4907)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459659820880763321.4907)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\5E73\5747\5448\73FE\6642\9593')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459659905607763326.4907)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\5E73\5747\8CC7\6599\5217\6578\76EE')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459660912570763334.4907)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5E73\5747\6587\5B57\5167\5BB9')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459661125550763335.4907)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>24
,p_column_identifier=>'X'
,p_column_label=>unistr('\9801\9762\540D\7A31')
,p_column_link=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.::WS_APP_ID,P900_ID:&WS_APP_ID.,#WEBPAGE_ID#'
,p_column_linktext=>'#PAGE_NAME#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459663826561790231.4907)
,p_db_column_name=>'USERID'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('\4E0D\540C\4F7F\7528\8005')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(459664004874793441.4907)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\9801\9762\6AA2\8996')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471969020072698244.4907)
,p_db_column_name=>'CONTENT_SERVED'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\63D0\4F9B\7684\5167\5BB9')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471969215286698247.4907)
,p_db_column_name=>'PAGE_GENERATION_TIME'
,p_display_order=>29
,p_column_identifier=>'AC'
,p_column_label=>unistr('\9801\9762\7522\751F\6642\9593')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(479550923423223017.4907)
,p_db_column_name=>'WEBPAGE_ID'
,p_display_order=>30
,p_column_identifier=>'AD'
,p_column_label=>unistr('\7DB2\9801')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(479557502570311662.4907)
,p_db_column_name=>'LAST_VIEW'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\4E0A\6B21\6AA2\8996')
,p_column_type=>'DATE'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459661531662763337.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23692317442092071.4907)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(459661531662763337.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23692521944093325.4907)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(459661531662763337.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459662911407766995.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(459661713093763338.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(459659409774763317.4907)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:24,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459661926271763339.4907)
,p_name=>'P24_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23692521944093325.4907)
,p_item_default=>'1'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\986F\793A\6240\9078\5831\8868\6642\9593\7BC4\570D\5167\7684\5831\8868\8CC7\6599.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00025
begin
wwv_flow_api.create_page(
 p_id=>25.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\9801\9762\548C\5340\6BB5\9023\7D50')
,p_step_title=>unistr('\9801\9762\548C\5340\6BB5\9023\7D50')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488510805876131179.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491313913908782031.4907)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491318015433867606.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4907)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\8907\88FD\9801\9762\6216\5340\6BB5\9023\7D50\4E26\5C07\5176\8CBC\5230\5340\6BB5\6587\5B57\4E2D, \5373\53EF\5728\9801\9762\4E2D\5EFA\7ACB\9023\7D50.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491577932536354374.4907)
,p_plug_name=>unistr('\9801\9762\9023\7D50')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select p.name page_name, ',
'       decode(a.home_page_id, p.id, ''[[ page: ''||p.name||'' ]]'', ',
'          ''[[ page: ''||p.page_alias||'' | ''||p.name||'' ]]'') page_link',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a',
'where p.security_group_id = :flow_security_group_id ',
'  and p.ws_app_id = :ws_app_id',
'  and p.ws_app_id = a.id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491578027851354374.4907)
,p_name=>'Page and Section Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491578208150354381.4907)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\9801\9762')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491578311606354385.4907)
,p_db_column_name=>'PAGE_LINK'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\9801\9762\9023\7D50')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488510218502131175.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(491577932536354374.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(491599426242893169.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create section collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_section_collection (',
'    p_security_group_id => :flow_security_group_id,',
'    p_ws_app_id         => :ws_app_id',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\96C6\5408.')
);
end;
/
prompt --application/pages/page_00026
begin
wwv_flow_api.create_page(
 p_id=>26.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\4E0A\50B3\8A66\7B97\8868 (Ajax \7AEF\9EDE)')
,p_step_title=>unistr('\4E0A\50B3\8A66\7B97\8868 (Ajax \7AEF\9EDE)')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(157592926751064610)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(157427219470636840.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'SPREADSHEET_SAVE'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_code clob := empty_clob;',
'begin',
'   sys.dbms_lob.createtemporary( l_code, false, sys.dbms_lob.SESSION );',
'   for i in 1..wwv_flow.g_f02.count loop',
'        sys.dbms_lob.writeappend(l_code,length(wwv_flow.g_f02(i)),wwv_flow.g_f02(i));',
'    end loop;',
'apex_collection.create_or_truncate_collection(p_collection_name=>''SPREADSHEET_CONTENT'');',
'apex_collection.add_member(p_collection_name=>''SPREADSHEET_CONTENT'',p_c001=>wwv_flow.g_f01(1),p_clob001=>l_code);',
'sys.htp.prn(''success'');',
'htmldb_application.g_unrecoverable_error := TRUE;',
'end;'))
);
end;
/
prompt --application/pages/page_00027
begin
wwv_flow_api.create_page(
 p_id=>27.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6A94\6848')
,p_step_title=>unistr('\6A94\6848')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488523103160992637.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491316430100805612.4907)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491454229828060959.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4907)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\4F7F\7528 [[FILE: ]] \8A9E\6CD5\5EFA\7ACB\4E0B\8F09\6A94\6848\7684\9023\7D50, \6216\8005\4F7F\7528 [[IMAGE: ]] \8A9E\6CD5\986F\793A\5167\5D4C\5F71\50CF.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491582707308395779.4907)
,p_plug_name=>unistr('\6A94\6848')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="clear: both"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select (select name from wwv_flow_ws_webpages ',
'         where id = n003 and ws_app_id = n002 ',
'           and security_group_id=:flow_security_group_id) page_name,',
'       (select w.id from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr ws ',
'         where w.id=ws.worksheet_id and ws.id = n004 ',
'           and w.security_group_id=:flow_security_group_id) worksheet_id,',
'       (select websheet_name from wwv_flow_ws_websheet_attr ',
'         where id = n004 and ws_app_id = n002 ',
'           and security_group_id=:flow_security_group_id) data_grid_name,',
'       c001 component_level,',
'       c002 file_name,',
'       c003 image_alias,',
'       c008 description,',
'       c009 created_by,',
'       to_number(c011) doc_size,',
'       ''[[ file: ''||c003||'' | ''||c002||'' ]]'' file_link,',
'       ''[[ image: ''||c003||'' | title="''||c002||''" ]]'' image_link,',
'       d001 created_on',
'  from wwv_flow_collections',
' where collection_name = ''APEX$_WS_FILES'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491582908789395824.4907)
,p_name=>'Attachments'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_link_column=>'ICON_LINK'
,p_icon_view_img_src_column=>'ICON_IMG'
,p_icon_view_label_column=>'ICON_NAME'
,p_icon_view_columns_per_row=>5
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584227347395830.4907)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\9801\9762')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584331848395830.4907)
,p_db_column_name=>'DATA_GRID_NAME'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\8CC7\6599\65B9\683C')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584421517395830.4907)
,p_db_column_name=>'COMPONENT_LEVEL'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\5C64\6B21')
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491584708827395830.4907)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>16
,p_column_identifier=>'P'
,p_column_label=>unistr('\63CF\8FF0')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491585006345395831.4907)
,p_db_column_name=>'WORKSHEET_ID'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5DE5\4F5C\8868 ID')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491585118316395831.4907)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>22
,p_column_identifier=>'V'
,p_column_label=>unistr('\6A94\6848\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491583420164395827.4907)
,p_db_column_name=>'IMAGE_ALIAS'
,p_display_order=>31
,p_column_identifier=>'AE'
,p_column_label=>unistr('\5225\540D')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491591904650603108.4907)
,p_db_column_name=>'FILE_LINK'
,p_display_order=>32
,p_column_identifier=>'AF'
,p_column_label=>unistr('\6A94\6848\9023\7D50')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491592915647625219.4907)
,p_db_column_name=>'IMAGE_LINK'
,p_display_order=>33
,p_column_identifier=>'AG'
,p_column_label=>unistr('\5F71\50CF\9023\7D50')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(495846530207735868.4907)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>34
,p_column_identifier=>'AH'
,p_column_label=>unistr('\5EFA\7ACB\6642\9593')
,p_column_type=>'DATE'
,p_heading_alignment=>'LEFT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(495848524451743667.4907)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>35
,p_column_identifier=>'AI'
,p_column_label=>unistr('\5EFA\7ACB\8005')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(495860525237800639.4907)
,p_db_column_name=>'DOC_SIZE'
,p_display_order=>36
,p_column_identifier=>'AJ'
,p_column_label=>unistr('\5927\5C0F')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'LEFT'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488522502529992636.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(491582707308395779.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(491585815273398010.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create file collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_attachment_collection (',
'    p_ws_app_id    => :ws_app_id',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\96C6\5408.')
);
end;
/
prompt --application/pages/page_00028
begin
wwv_flow_api.create_page(
 p_id=>28.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5340\6BB5\9023\7D50')
,p_step_title=>unistr('\5340\6BB5\9023\7D50')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492133721971626990.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492133918103626991.4907)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492134119027626992.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4907)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\8907\88FD\9801\9762\6216\5340\6BB5\9023\7D50\4E26\5C07\5176\8CBC\5230\5340\6BB5\6587\5B57\4E2D, \5373\53EF\5728\9801\9762\4E2D\5EFA\7ACB\9023\7D50.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492134510311626995.4907)
,p_plug_name=>unistr('\5340\6BB5\9023\7D50')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select p.name page_name, ',
'       s.c001 section_name,',
'       s.c002 section_type,',
'       decode(s.n001, NULL, NULL, ''[[ section: ''||p.page_alias||''.''||s.c001||',
'              '' |  ''||s.c001||'' ]]'') section_link,',
'       s.n003 section_seq',
'from wwv_flow_ws_webpages p,',
'     wwv_flow_ws_applications a,',
'     wwv_flow_collections s',
'where p.security_group_id = :flow_security_group_id ',
'  and p.ws_app_id = :ws_app_id',
'  and p.ws_app_id = a.id',
'  and p.id = s.n002 (+)',
'  and s.collection_name (+) = ''APEX$_WS_SECTIONS''',
'  and s.c002 != ''PLSQL'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(492134718217626996.4907)
,p_name=>'Page and Section Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492134831239626996.4907)
,p_db_column_name=>'PAGE_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\9801\9762')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135023564626998.4907)
,p_db_column_name=>'SECTION_NAME'
,p_display_order=>2
,p_column_identifier=>'C'
,p_column_label=>unistr('\5340\6BB5')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135204191626998.4907)
,p_db_column_name=>'SECTION_SEQ'
,p_display_order=>3
,p_column_identifier=>'E'
,p_column_label=>unistr('\9801\9762\4E0A\7684\9806\5E8F')
,p_column_type=>'NUMBER'
,p_heading_alignment=>'RIGHT'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135323582626998.4907)
,p_db_column_name=>'SECTION_TYPE'
,p_display_order=>4
,p_column_identifier=>'F'
,p_column_label=>unistr('\5340\6BB5\985E\578B')
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(492203630195322675)
,p_rpt_show_filter_lov=>'1'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492135114156626998.4907)
,p_db_column_name=>'SECTION_LINK'
,p_display_order=>5
,p_column_identifier=>'D'
,p_column_label=>unistr('\9023\7D50')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492134320826626994.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(492134510311626995.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(492135623803626999.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create section collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_section_collection (',
'    p_security_group_id => :flow_security_group_id,',
'    p_ws_app_id         => :ws_app_id',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\96C6\5408.')
);
end;
/
prompt --application/pages/page_00029
begin
wwv_flow_api.create_page(
 p_id=>29.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\8CC7\6599\65B9\683C\9023\7D50')
,p_step_title=>unistr('\8CC7\6599\65B9\683C\9023\7D50')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488528711832072509.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4907)
,p_plug_display_sequence=>300
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\8907\88FD\8CC7\6599\65B9\683C\9023\7D50\4E26\5C07\5176\8CBC\5230\5340\6BB5\6587\5B57\4E2D, \5373\53EF\5728\9801\9762\4E2D\5EFA\7ACB\9023\7D50.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488529907857072513.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491316014516801049.4907)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>25
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491746024610087200.4907)
,p_plug_name=>unistr('\8CC7\6599\65B9\683C\9023\7D50')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.name name, ',
'       ''[[ data grid: ''||lower(a.websheet_alias)||'' | ''|| w.name ||'' ]]'' data_grid_link',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      nvl(a.websheet_type,''DATA'') = ''DATA'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491746111378087200.4907)
,p_name=>'Data Grid Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491746317155087207.4907)
,p_db_column_name=>'NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491746428175087207.4907)
,p_db_column_name=>'DATA_GRID_LINK'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\8CC7\6599\65B9\683C\9023\7D50')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(488529313077072512.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(491746024610087200.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:RIR::'
);
end;
/
prompt --application/pages/page_00030
begin
wwv_flow_api.create_page(
 p_id=>30.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5831\8868\9023\7D50')
,p_step_title=>unistr('\5831\8868\9023\7D50')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(11249921373943607.4907)
,p_required_role=>wwv_flow_api.id(492214905335570870)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488531706310080311.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(47316730240795884.4907)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\8907\88FD\5831\8868\9023\7D50\4E26\5C07\5176\8CBC\5230\5340\6BB5\6587\5B57\4E2D, \5373\53EF\5728\9801\9762\4E2D\5EFA\7ACB\9023\7D50.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(488532919512080318.4907)
,p_plug_name=>'Help Tabs'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(456471813385447055.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11252405836967523.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491315807244799034.4907)
,p_plug_name=>'sub tab'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(491255024672312078.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(11270206893119252.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(491748021852099994.4907)
,p_plug_name=>unistr('\5831\8868\9023\7D50')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.name name, ',
'       ''[[ report: ''||lower(a.websheet_alias)||'' | ''|| w.name ||'' ]]'' report_link',
'from wwv_flow_worksheets w, ',
'     wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id and',
'      w.security_group_id = :flow_security_group_id and                  ',
'      a.ws_app_id = :ws_app_id and',
'      a.websheet_type = ''REPORT'''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(491748229774099997.4907)
,p_name=>'Data Grid Links'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491748324162100000.4907)
,p_db_column_name=>'NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(491751223153119333.4907)
,p_db_column_name=>'REPORT_LINK'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\5831\8868\9023\7D50')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(491750704452113945.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(491748021852099994.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:RIR::'
);
end;
/
prompt --application/pages/page_00031
begin
wwv_flow_api.create_page(
 p_id=>31.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\8907\88FD\9801\9762')
,p_step_title=>unistr('\8907\88FD\9801\9762')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20320615327276649.4907)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,    ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',   ',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_COPY_PAGE''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929190133057280555.4907)
,p_plug_name=>unistr('\6210\529F')
,p_region_template_options=>'#DEFAULT#:a-Alert--success:a-Alert--wizard'
,p_plug_template=>wwv_flow_api.id(931543191007401308.4907)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_header=>unistr('<p>\5DF2\9806\5229\8907\88FD\9801\9762.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929190488644282428.4907)
,p_plug_name=>unistr('\6309\9215\5217')
,p_region_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>50
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929190621583287226.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(929190488644282428.4907)
,p_button_name=>'VIEW_CURRENT_PAGE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\6AA2\8996\76EE\524D\7684\9801\9762')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:900:P900_ID:&P900_ID.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929190863882290386.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(929190488644282428.4907)
,p_button_name=>'VIEW_NEW_PAGE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\6AA2\8996\65B0\9801\9762')
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_redirect_url=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:900:P900_ID:&P908_NEW_PAGE_ID.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
end;
/
prompt --application/pages/page_00032
begin
wwv_flow_api.create_page(
 p_id=>32.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_step_title=>unistr('\5EFA\7ACB Web \8A66\7B97\8868')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(487678607690660963)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(322238423988579452.4907)
,p_plug_name=>'Create Application'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929133081486158181.4907)
,p_plug_name=>unistr('\6210\529F')
,p_region_css_classes=>'wsFormRegion'
,p_region_template_options=>'#DEFAULT#:a-Alert--defaultIcons:a-Alert--success:a-Alert--wizard'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(931543191007401308.4907)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_num_rows=>15
,p_plug_header=>unistr('<p>\5DF2\9806\5229\5EFA\7ACB Web \8A66\7B97\8868.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(929180946479219942.4907)
,p_plug_name=>'button bar'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929100843522099793.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(929180946479219942.4907)
,p_button_name=>'EDIT_PROPERTY'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\7DE8\8F2F\7279\6027')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:1250:P1250_ID,WS_APP_ID:&P7_WS_APP_ID.,&P7_WS_APP_ID.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(929133818885166572.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(929180946479219942.4907)
,p_button_name=>'RUN_WEBSHEET'
,p_button_action=>'REDIRECT_URL'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\57F7\884C Web \8A66\7B97\8868')
,p_button_position=>'REGION_TEMPLATE_CREATE2'
,p_button_redirect_url=>'ws?p=&P7_WS_APP_ID.:home:&SESSION.'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(322237424272579450.4907)
,p_name=>'P32_WS_APP_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(929133081486158181.4907)
,p_prompt=>unistr('Web \8A66\7B97\8868')
,p_source=>'P7_WS_APP_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\65B0\5EFA\7684\61C9\7528\7A0B\5F0F.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(322237920970579451.4907)
,p_name=>'P32_WS_APP_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(929133081486158181.4907)
,p_prompt=>unistr('\540D\7A31')
,p_source=>'P7_WEBSHEET_NAME'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\65B0\5EFA\4E4B\61C9\7528\7A0B\5F0F\7684\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
end;
/
prompt --application/pages/page_00033
begin
wwv_flow_api.create_page(
 p_id=>33.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('BLOB \683C\5F0F\906E\7F69')
,p_step_title=>unistr('BLOB \683C\5F0F\906E\7F69')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
'  function apex_p33_download_format_set(){',
'    var l_Array = [$v(''P33_TYPE''),$v(''P33_BLOB_TABLE''),$v(''P33_BLOB_COLUMN''),$v(''P33_PK1''),$v(''P33_PK2''),$v(''P33_MIMETYPE''),$v(''P33_FILENAME''),$v(''P33_UPDATED''),$v(''P33_CHARSET''),$v(''P33_CONTENT_DISPOSITION''),$v(''P33_LINK_TEXT'')];',
'    var lItem = ''P3020_FORMAT_MASK'';',
'    var l_Value = $u_ArrayToString(l_Array,'':'');',
'    opener.$s(lItem,l_Value);',
'    window.close();',
'    opener.$x(lItem).focus();',
'  }',
'',
'//-->',
'</script>  '))
,p_step_template=>wwv_flow_api.id(134255203486851095.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(456220226828170850)
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(382871122829192382.4907)
,p_plug_name=>unistr('BLOB \683C\5F0F\906E\7F69')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(82536903857665765.4907)
,p_plug_display_sequence=>20
,p_plug_new_grid=>true
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(383167816689247554.4907)
,p_plug_name=>'Top Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(383212323961249647.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(383167816689247554.4907)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4907)
,p_button_image_alt=>unistr('\5957\7528')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex_p33_download_format_set();'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(382974024476212019.4907)
,p_name=>'P33_TYPE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('\683C\5F0F\906E\7F69')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'BLOB_FORMAT_MASK'
,p_lov=>'.'||wwv_flow_api.id(382915819151201016.4907)||'.'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(383000402790215206.4907)
,p_name=>'P33_BLOB_TABLE'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('BLOB \8868\683C')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(383045518374219662.4907)
,p_name=>'P33_BLOB_COLUMN'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('BLOB \8CC7\6599\6B04')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(402663623371449753.4907)
,p_name=>'P33_PK1'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('\4E3B\7D22\5F15\9375\8CC7\6599\6B04 1')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(402992609350483622.4907)
,p_name=>'P33_PK2'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('\4E3B\7D22\5F15\9375\8CC7\6599\6B04 2')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403109000131490412.4907)
,p_name=>'P33_MIMETYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('MIME \985E\578B\8CC7\6599\6B04')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403280800609499987.4907)
,p_name=>'P33_FILENAME'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('\6A94\6848\540D\7A31\8CC7\6599\6B04')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403382322426506264.4907)
,p_name=>'P33_UPDATED'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('BLOB \4E0A\6B21\66F4\65B0\6642\9593\8CC7\6599\6B04')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403460500740509547.4907)
,p_name=>'P33_CHARSET'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('\5B57\5143\96C6\8CC7\6599\6B04')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403561421518515499.4907)
,p_name=>'P33_CONTENT_DISPOSITION'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('\5167\5BB9\914D\7F6E')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'BLOB_CONTENT_DISPOSITION'
,p_lov=>'.'||wwv_flow_api.id(382939512009208407.4907)||'.'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(403683725112525989.4907)
,p_name=>'P33_LINK_TEXT'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(382871122829192382.4907)
,p_prompt=>unistr('\4E0B\8F09\9023\7D50\6587\5B57')
,p_source=>'wwv_flow_lang.system_message(''DOWNLOAD'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(992326827720799292.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'fetch blob format mask info'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.p33_fetch_blob_format (',
'    p_format_mask         => :P3020_FORMAT_MASK,    ',
'    --',
'    p_type                => :P33_TYPE,',
'    p_blob_table          => :P33_BLOB_TABLE,',
'    p_blob_column         => :P33_BLOB_COLUMN,',
'    p_pk1_column          => :P33_PK1,',
'    p_pk2_column          => :P33_PK2,',
'    p_mimetype_column     => :P33_MIMETYPE,',
'    p_filename_column     => :P33_FILENAME,',
'    p_last_upd_column     => :P33_UPDATED,',
'    p_charset_column      => :P33_CHARSET,',
'    p_content_disposition => :P33_CONTENT_DISPOSITION,',
'    p_download_text       => :P33_LINK_TEXT',
'    );'))
);
end;
/
prompt --application/pages/page_00037
begin
wwv_flow_api.create_page(
 p_id=>37.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\9078\53D6\8A9E\8A00')
,p_step_title=>unistr('\9078\53D6\8A9E\8A00')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>'MUST_NOT_BE_PUBLIC_USER'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(22687832673202415.4907)
,p_plug_name=>'Top Button Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(619996914922437329.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(633817727195790601.4907)
,p_plug_name=>unistr('\9078\53D6\8A9E\8A00\548C\5730\5340')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(620002529476508161.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(22687832673202415.4907)
,p_button_name=>'RETURN'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(633832411704842867.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(22687832673202415.4907)
,p_button_name=>'SET'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\8A2D\5B9A')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(636473024858464198.4907)
,p_branch_action=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(633832411704842867.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(633818130920810528.4907)
,p_name=>'P37_LANGUAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(633817727195790601.4907)
,p_item_default=>'wwv_flow_lang.get_g_session_lang'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('\8A9E\8A00')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LANGUAGES_INSTALLED'
,p_lov=>'.'||wwv_flow_api.id(631691002719703351.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9078\53D6\57F7\884C\6B64\61C9\7528\7A0B\5F0F\6642\6240\8981\4F7F\7528\7684\8A9E\8A00. \5982\679C\60A8\7684 Web \700F\89BD\5668\555F\7528 Cookie, \5247\6703\5C07\6B64\8A9E\8A00\504F\597D\8A2D\5B9A\5BEB\5165 Cookie, \4E26\63A7\5236\6B64\57F7\884C\8655\7406\4E4B\6240\6709\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F\7684\8A9E\8A00\504F\597D\8A2D\5B9A. \9019\4EFD\8A9E\8A00\6E05\55AE\7531\5B89\88DD\4E4B\7FFB\8B6F\7684 &PRODUCT_NAME. \7248\672C\6C7A\5B9A.'),
'',
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(633818321354817301.4907)
,p_name=>'P37_TERRITORY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(633817727195790601.4907)
,p_use_cache_before_default=>'NO'
,p_item_default=>'wwv_flow_lang.get_g_session_territory'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_prompt=>unistr('\5730\5340')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'I18N_TERRITORIES'
,p_lov=>'.'||wwv_flow_api.id(634728210841234369.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
unistr('\9078\53D6\57F7\884C\6B64\61C9\7528\7A0B\5F0F\6642\6240\8981\4F7F\7528\7684\5730\5340\504F\597D\8A2D\5B9A. \9019\63A7\5236\9810\8A2D\986F\793A\65E5\671F\3001\6578\5B57\4EE5\53CA\884C\4E8B\66C6\7684\65B9\5F0F. \5982\679C\60A8\7684\700F\89BD\5668\555F\7528 Cookie, \5247\6703\5C07\6B64\5730\5340\504F\597D\8A2D\5B9A\5BEB\5165 Cookie, \4E26\63A7\5236\6B64\57F7\884C\8655\7406\4E4B\6240\6709\300CWeb \8A66\7B97\8868\300D\61C9\7528\7A0B\5F0F\7684\5730\5340\504F\597D\8A2D\5B9A.  '),
''))
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(636322931994230689.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set language and territory'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_lang.set_session_lang( p_lang => :P37_LANGUAGE );',
'wwv_flow.g_browser_language := :P37_LANGUAGE;',
'wwv_flow_lang.set_session_territory( p_territory => :P37_TERRITORY );',
'',
'commit;'))
,p_process_error_message=>unistr('\8655\7406\66F4\65B0\6642\767C\751F\932F\8AA4.')
,p_process_when_button_id=>wwv_flow_api.id(633832411704842867.4907)
,p_process_success_message=>unistr('\52D5\4F5C\5DF2\8655\7406.')
);
end;
/
prompt --application/pages/page_00042
begin
wwv_flow_api.create_page(
 p_id=>42.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6211\7684\9810\5B58\5831\8868')
,p_step_title=>unistr('\6211\7684\9810\5B58\5831\8868')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>'MUST_NOT_BE_PUBLIC_USER'
,p_nav_list_template_options=>'#DEFAULT#'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(496647113913986363.4907)
,p_plug_name=>unistr('\6211\7684\9810\5B58\5831\8868')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20956911766368602.4907)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'case when r.is_default!=''Y'' or r.application_user!=''APXWS_DEFAULT'' then',
'    wwv_flow_item.checkbox(',
'        1,',
'        r.id,null,null,'':'',',
'       ''f''||lpad(''''||1,2,''0'') || ''_'' || lpad(''''||rownum,4,''0'') ,',
'        wwv_flow_lang.system_message(''REPORT_LABEL'',',
'                            case',
'                              when r.is_default=''Y'' and r.application_user=''APXWS_DEFAULT'' then',
'                                wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'')',
'                              else',
'                                wwv_flow_escape.html(r.name)',
'                            end) )',
'end id,',
'a.id napp_id,',
'case when ws.websheet_type = ''DATA'' then',
'       ''<a href="f?p=''||:app_id||'':2:''||:app_session||''::::WS_APP_ID,P2_ID,P2_WEBSHEET_ID:''||:ws_app_id||'',''||i.id||'',''||ws.id||''">''||wwv_flow_escape.html(ws.websheet_name)||''</a>''',
'     when ws.websheet_type = ''REPORT'' then',
'       ''<a href="f?p=''||:app_id||'':3000:''||:app_session||''::::WS_APP_ID,IR_ID,WS_ID:''||:ws_app_id||'',''||i.id||'',''||ws.id||''">''||wwv_flow_escape.html(ws.websheet_name)||''</a>''',
'end websheet_name,',
'case when ws.websheet_type = ''DATA'' then',
'       sm.data_grid',
'     when ws.websheet_type = ''REPORT'' then',
'       sm.report',
'end websheet_type,',
'case when r.is_default = ''Y''then ',
'     decode(r.application_user,',
'            ''APXWS_DEFAULT'',sm.primary_def, ',
'            ''APXWS_ALTERNATIVE'',sm.alt_def)',
'     when r.is_default = ''N'' and r.status = ''PUBLIC'' then',
'         sm.spublic',
'     when r.is_default = ''N'' and r.status = ''PRIVATE'' then',
'         sm.private',
'end report_type, ',
'case when r.is_default=''Y'' and r.application_user=''APXWS_DEFAULT'' then',
'    wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'')',
'else',
'    r.name',
'end name,',
'decode(r.application_user,',
'       ''APXWS_DEFAULT'',null,',
'       ''APXWS_ALTERNATIVE'',null,',
'       lower(r.application_user)) owner,',
'substr(r.description,1,50) description,        ',
'r.report_alias report_alias,',
'r.created_on',
'from wwv_flow_worksheets i,',
'wwv_flow_worksheet_rpts r,',
'wwv_flow_ws_applications a,',
'wwv_flow_ws_websheet_attr ws,',
'(select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary_def,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alt_def,               ',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIVATE'') private,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') spublic,',
'      wwv_flow_lang.system_message(''DATA_GRID'') data_grid,',
'      wwv_flow_lang.system_message(''REPORT'') report',
' from dual) sm',
'where a.id = ws.ws_app_id',
'and ws.worksheet_id = i.id',
'and r.worksheet_id = i.id',
'and r.websheet_id is not null',
'and r.security_group_id = :flow_security_group_id',
'and a.id = :ws_app_id',
'and r.application_user = :app_user',
'and r.session_id is null'))
,p_plug_source_type=>'NATIVE_IR'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(496647211081986363.4907)
,p_name=>'Saved Reports'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'CBCHO'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647413912986368.4907)
,p_db_column_name=>'ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'#CHECK_ALL_CHECKBOX#'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647505239986368.4907)
,p_db_column_name=>'NAPP_ID'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\61C9\7528\7A0B\5F0F')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647610315986368.4907)
,p_db_column_name=>'WEBSHEET_NAME'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\8CC7\6599')
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
,p_rpt_named_lov=>wwv_flow_api.id(497241820310060978)
,p_rpt_show_filter_lov=>'2'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647729642986369.4907)
,p_db_column_name=>'WEBSHEET_TYPE'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\985E\578B')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647830164986369.4907)
,p_db_column_name=>'REPORT_TYPE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\5831\8868\985E\578B')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496647931210986369.4907)
,p_db_column_name=>'NAME'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\540D\7A31')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496648005718986369.4907)
,p_db_column_name=>'OWNER'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\64C1\6709\8005')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496648117100986369.4907)
,p_db_column_name=>'DESCRIPTION'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>unistr('\63CF\8FF0')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(496648221465986369.4907)
,p_db_column_name=>'REPORT_ALIAS'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>unistr('\5831\8868\5225\540D')
,p_column_type=>'STRING'
,p_heading_alignment=>'LEFT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(737065808338186629.4907)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>unistr('\5EFA\7ACB\6642\9593')
,p_column_type=>'DATE'
,p_heading_alignment=>'LEFT'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(497240631383988555.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(497261218307315877.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\60A8\53EF\4EE5\5728\6B64\9801\9762\4E2D\7BA1\7406\60A8\7684\9810\5B58\5831\8868.  \60A8\53EF\4EE5\5728\6AA2\8996\300C\5831\8868\300D\548C\300C\8CC7\6599\65B9\683C\300D\6642, \4F7F\7528\300C\52D5\4F5C\300D\529F\80FD\8868\4F86\5EFA\7ACB\9810\5B58\5831\8868.  \6839\64DA\300C\5831\8868\300D\6216\300C\8CC7\6599\65B9\683C\300D\5EFA\7ACB\5340\6BB5\6642, \6703\53C3\7167\9810\5B58\5831\8868\7684\5831\8868\8A2D\5B9A\503C.  \5B83\5011\53EF\7528\4F86\81EA\8A02\8A72\5340\6BB5\5167\986F\793A\7684\8CC7\6599.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(497767325222992406.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(496647113913986363.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:42,RIR::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(497233530597931570.4907)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(496647113913986363.4907)
,p_button_name=>'DELETE_CHECKED'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4907)
,p_button_image_alt=>unistr('\522A\9664\52FE\9078\7684\9805\76EE')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(497233703023933067.4907)
,p_branch_action=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(497241020778994879.4907)
,p_validation_name=>'must select report to delete'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow.g_f01.count = 0 then',
'  return false;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5FC5\9808\9078\53D6\8981\522A\9664\7684\5831\8868.')
,p_when_button_pressed=>wwv_flow_api.id(497233530597931570.4907)
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(2045581531252367912.4907)
,p_name=>'ADD CHECK ALL CHECKBOX'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(496647113913986363.4907)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(2045581649091367913.4907)
,p_event_id=>wwv_flow_api.id(2045581531252367912.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'PLUGIN_COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(497237425533939526.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'delete checked'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count',
'loop',
'    for c1 in (select id report_id, worksheet_id, application_user, is_default, report_type',
'               from wwv_flow_worksheet_rpts',
'               where id = wwv_flow.g_f01(i)',
'               and security_group_id=:flow_security_group_id',
'               and application_user = :app_user)',
'    loop                ',
'        wwv_flow_worksheet_api.delete_saved_report (            ',
'            p_worksheet_id      => c1.worksheet_id,               ',
'            p_report_id         => c1.report_id,',
'            p_is_default        => c1.is_default);        ',
'    end loop;',
'end loop;'))
,p_process_error_message=>unistr('\7121\6CD5\79FB\9664\5831\8868.')
,p_process_when_button_id=>wwv_flow_api.id(497233530597931570.4907)
,p_process_success_message=>unistr('\5DF2\79FB\9664\5831\8868.')
);
end;
/
prompt --application/pages/page_00050
begin
wwv_flow_api.create_page(
 p_id=>50.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\65B0\589E\9644\4EF6')
,p_step_title=>unistr('\65B0\589E\9644\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(3152608674388513.4907)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_page_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This page needed for Ajax in Data Grid Single Row View (page 20).',
'onload="window.parent.closeupload();"'))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3144901000282263.4907)
,p_plug_name=>'Upload'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_error_msg varchar2(4000);',
'begin',
'    wwv_flow_ws_attachment.add_doc (',
'        p_ws_app_id       => :WS_APP_ID,',
'        p_websheet_id     => :P2_WEBSHEET_ID,',
'        p_row_id          => :CURRENT_WORKSHEET_ROW,',
'        p_component_level => ''ROW'',',
'        p_file_name       => :P20_X,',
'        p_desc            => :P20_DESC',
'    );',
'    sys.htp.p(''<script type="text/javascript" charset="utf-8">'');',
'    sys.htp.p(''  window.parent.apex.websheet.closeUpload();'');',
'    sys.htp.p(''</script>'');',
'exception when others then',
'    if sqlcode = -1691 then',
'        l_error_msg := wwv_flow_lang.system_message(''WS_ADD_FILE_NOT_ENOUGH_SPACE_ERROR'');',
'    else',
'        l_error_msg := sqlerrm;',
'    end if;',
'    sys.htp.p(''<script type="text/javascript" charset="utf-8">'');',
'    sys.htp.p(''  window.parent.apex.websheet.spinner$.remove();'');',
'    sys.htp.p(''  $("#apexir_DIALOG_MESSAGE", window.parent.document).html("''||wwv_flow_escape.html(l_error_msg)||''");'');',
'    sys.htp.p(''</script>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(177392830105668569.4907)
,p_branch_name=>'Go To Page 20'
,p_branch_action=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
end;
/
prompt --application/pages/page_00051
begin
wwv_flow_api.create_page(
 p_id=>51.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\7BA1\7406\8A8D\8B49\914D\7F6E')
,p_step_title=>unistr('\7BA1\7406\8A8D\8B49\914D\7F6E')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177132113855562337.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
end;
/
prompt --application/pages/page_00053
begin
wwv_flow_api.create_page(
 p_id=>53.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\7DE8\8F2F\9801\9762')
,p_step_title=>unistr('\7DE8\8F2F\9801\9762')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript" type="text/javascript">',
'<!--',
'',
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';',
'',
'//-->',
'</script>',
'<style>',
'/* There is no collapse left col functionality on this page, so adding additional padding to Left Col heading */',
'div.ebaTwoColPane > div h2.leftButtons {padding-left: 10px !important;}',
'</style>'))
,p_step_template=>wwv_flow_api.id(15627530893704526.4907)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18534419096630219.4907)
,p_plug_name=>'List of Pages'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(18529824151546479.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(158861503239501998.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18534800527634294.4907)
,p_plug_name=>unistr('&P53_NAME. \8A73\7D30\8CC7\8A0A')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(15634208564734334.4907)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18557529579690008.4907)
,p_plug_name=>unistr('\9801\9762')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(17121518626936007.4907)
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(18585811889807838.4907)
,p_plug_name=>'Page Settings List'
,p_region_name=>'page_control'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(18583325957802446.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(936708315591140469.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(162991400186731236.4907)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>140
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177409809869723629.4907)
,p_plug_name=>unistr('\9801\9762')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:100%;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(177422928892872875.4907)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2061383146528710242.4907)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(18557529579690008.4907)
,p_button_name=>'CREATE_PAGE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(936712837989177653.4907)
,p_button_image_alt=>unistr('\5EFA\7ACB\9801\9762')
,p_button_position=>'REGION_TEMPLATE_CHANGE'
,p_icon_css_classes=>'icon-plus'
,p_button_cattributes=>'data-menu="page_control_menu"'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177410225400723635.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(177422928892872875.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(18562324993707537.4907)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(18557529579690008.4907)
,p_button_name=>'Hide/Show'
,p_button_static_id=>'sideColControl'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(16714408571357214.4907)
,p_button_image_alt=>unistr('\96B1\85CF / \986F\793A')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'javascript:void(0)'
,p_button_condition_type=>'NEVER'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177410026421723634.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(177422928892872875.4907)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P53_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(177410112058723634.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(177422928892872875.4907)
,p_button_name=>'DELETE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15160928947568323.4907)
,p_button_image_alt=>unistr('\522A\9664')
,p_button_position=>'REGION_TEMPLATE_DELETE'
,p_button_condition=>'(:P53_ID is not null) and (not wwv_flow_ws_api.is_app_home_page(p_ws_app_id => :ws_app_id, p_webpage_id => :p53_id))'
,p_button_condition_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(163262329454777553.4907)
,p_branch_action=>'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:53:P53_ID:&P53_NEXT_PAGE_ID.'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'GET_NEXT_PAGE'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(177410910657723644.4907)
,p_branch_action=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(467021002093988715.4907)
,p_branch_action=>'f?p=&APP_ID.:960:&SESSION.::&DEBUG.:::'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(177410112058723634.4907)
,p_branch_sequence=>20
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(163040114731735379.4907)
,p_name=>'P53_NEXT_PAGE_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(162991400186731236.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411102679723645.4907)
,p_name=>'P53_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(162991400186731236.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>'Id'
,p_source=>'ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411303356723657.4907)
,p_name=>'P53_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\540D\7A31')
,p_source=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\9801\9762\7684\540D\7A31. \6B64\9801\9762\540D\7A31\5C07\986F\793A\5728\8996\7A97\6A19\984C\4EE5\53CA\5C0E\89BD\8DEF\5F91\4E2D.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411518259723658.4907)
,p_name=>'P53_OWNER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\64C1\6709\8005')
,p_source=>'OWNER'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\9801\9762\7684\64C1\6709\8005.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411701386723658.4907)
,p_name=>'P53_STATUS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\72C0\614B')
,p_source=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>30
,p_cHeight=>1
,p_display_when_type=>'NEVER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\9801\9762\7684\72C0\614B.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177411912672723659.4907)
,p_name=>'P53_DESCRIPTION'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\9801\9762\63CF\8FF0')
,p_source=>'DESCRIPTION'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\63CF\8FF0\9801\9762\7684\63CF\8FF0\6027\6587\5B57.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(177412115882723659.4907)
,p_name=>'P53_PARENT_PAGE_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\7236\9805\9801\9762')
,p_source=>'PARENT_PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'PICK PARENT PAGE (FOR PAGE 53)'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID',
'minus',
'select name d, id r',
'  from wwv_flow_ws_webpages',
' where security_group_id = :flow_security_group_id ',
'   and ws_app_id = :WS_APP_ID ',
'connect by prior id = parent_page_id',
'start with id = :P53_ID',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \6C92\6709\7236\9805 -')
,p_lov_null_value=>'%null%'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\6307\5B9A\7236\9805\9801\9762. \5B9A\7FA9\7684\7236\9805\9801\9762\5C07\7528\4F86\5EFA\69CB\5C0E\89BD\8DEF\5F91\548C\9801\9762\4E4B\9593\7684\5C0E\89BD.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(457384308073732200.4907)
,p_name=>'P53_PAGE_ALIAS'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(177409809869723629.4907)
,p_use_cache_before_default=>'NO'
,p_prompt=>unistr('\5225\540D')
,p_source=>'PAGE_ALIAS'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>255
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8F38\5165\6B64\9801\9762\7684\6587\6578\5B57\5225\540D. \60A8\53EF\4EE5\5229\7528\9801\9762\5225\540D\5728\9801\9762\5340\6BB5\4E2D\5EFA\7ACB\5176\4ED6\9801\9762\7684\9023\7D50. \9801\9762\5225\540D\5728\61C9\7528\7A0B\5F0F\5167\5FC5\9808\662F\552F\4E00\7684.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(457472018265246008.4907)
,p_validation_name=>'P53_PAGE_ALIAS must be unique'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P53_PAGE_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists(',
'     p_ws_app_id=>:WS_APP_ID,',
'     p_alias=>:P53_PAGE_ALIAS,',
'     p_alias_type=>''PAGE'',',
'     p_page_id=>:P53_ID) then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\9801\9762\5225\540D\5DF2\7D93\5B58\5728.  \8ACB\8F38\5165\5176\4ED6\5225\540D.')
,p_validation_condition=>'SAVE,GET_NEXT_PAGE'
,p_validation_condition_type=>'REQUEST_IN_CONDITION'
,p_associated_item=>wwv_flow_api.id(457384308073732200.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(467021405256017928.4907)
,p_validation_name=>'cannot delete home page'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_home_page_id  number;',
'begin',
'   for c1 in (',
'      select home_page_id',
'        from wwv_flow_ws_applications',
'       where id = :WS_APP_ID',
'         and security_group_id = :flow_security_group_id )',
'   loop',
'      l_home_page_id := c1.home_page_id;',
'   end loop;',
'',
'   if :P53_ID = l_home_page_id then',
'      return false;',
'   else',
'      return true;',
'   end if;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\7121\6CD5\522A\9664\9996\9801.  \8ACB\7DE8\8F2F\61C9\7528\7A0B\5F0F\7279\6027\4E26\9078\53D6\65B0\7684\9996\9801.')
,p_when_button_pressed=>wwv_flow_api.id(177410112058723634.4907)
,p_associated_item=>wwv_flow_api.id(177411303356723657.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(467022317985040552.4907)
,p_validation_name=>'cannot delete only page'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   l_page_count  number;',
'begin',
'   for c1 in (',
'      select count(*) cnt',
'        from wwv_flow_ws_webpages',
'       where ws_app_id = :WS_APP_ID',
'         and security_group_id = :flow_security_group_id )',
'   loop',
'      l_page_count := c1.cnt;',
'   end loop;',
'',
'   if l_page_count = 1 then',
'      return false;',
'   else',
'      return true;',
'   end if;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\6BCF\500B\61C9\7528\7A0B\5F0F\81F3\5C11\5747\5FC5\9808\8981\6709\4E00\500B\9801\9762.  \60A8\4E0D\80FD\522A\9664\552F\4E00\7684\9801\9762.')
,p_when_button_pressed=>wwv_flow_api.id(177410112058723634.4907)
,p_associated_item=>wwv_flow_api.id(177411303356723657.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(6140313816861525.4907)
,p_validation_name=>'P53_PAGE_ALIAS is valid'
,p_validation_sequence=>40
,p_validation=>'P53_PAGE_ALIAS'
,p_validation_type=>'ITEM_IS_ALPHANUMERIC'
,p_error_message=>unistr('\5225\540D\5FC5\9808\662F\6587\6578\5B57.')
,p_validation_condition=>':P53_PAGE_ALIAS is not null and :REQUEST in (''SAVE'',''GET_NEXT_PAGE'')'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_associated_item=>wwv_flow_api.id(457384308073732200.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(177412315870723660.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_FORM_FETCH'
,p_process_name=>'Fetch Row from WWV_FLOW_WS_WEBPAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_WS_WEBPAGES'
,p_attribute_03=>'P53_ID'
,p_attribute_04=>'ID'
,p_attribute_08=>wwv_flow_string.join(wwv_flow_t_varchar2(
'security_group_id = :WORKSPACE_ID',
'and ws_app_id = :WS_APP_ID'))
,p_process_error_message=>unistr('\7121\6CD5\64F7\53D6\8CC7\6599\5217.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(177412503075723662.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_FORM_PROCESS'
,p_process_name=>'Process Row of WWV_FLOW_WS_WEBPAGES'
,p_attribute_01=>'#OWNER#'
,p_attribute_02=>'WWV_FLOW_WS_WEBPAGES'
,p_attribute_03=>'P53_ID'
,p_attribute_04=>'ID'
,p_attribute_08=>wwv_flow_string.join(wwv_flow_t_varchar2(
'security_group_id = :WORKSPACE_ID',
'and ws_app_id = :WS_APP_ID'))
,p_attribute_11=>'U'
,p_attribute_12=>'Y'
,p_process_error_message=>unistr('\7121\6CD5\8655\7406\8868\683C WWV_FLOW_WS_WEBPAGES \7684\8CC7\6599\5217.')
,p_process_when=>'SAVE,GET_NEXT_PAGE'
,p_process_when_type=>'REQUEST_IN_CONDITION'
,p_process_success_message=>unistr('\52D5\4F5C\5DF2\8655\7406.')
);
end;
/
prompt --application/pages/page_00079
begin
wwv_flow_api.create_page(
 p_id=>79.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\7BA1\7406')
,p_step_title=>unistr('\7BA1\7406')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(4881207741750467)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4098511924636618.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(198343320048239476.4907)
,p_plug_name=>'perform logout'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_ws_app_id number := v(''WS_APP_ID'');',
'begin',
'    for c1 in (select auth_id authentication ',
'              from wwv_flow_ws_applications',
'              where id = l_ws_app_id',
'              and security_group_id = :flow_security_group_id)',
'    loop',
'        if c1.authentication is null then',
'            null;',
'        else',
'            for c2 in (select page_sentry_function,logout_url from wwv_flow_ws_custom_auth_setups where id = c1.authentication) loop',
'                if c2.page_sentry_function = ''-DATABASE-'' then',
'                    null;',
'                else',
'                    sys.htp.init;',
'                    sys.owa_util.redirect_url(replace(replace(replace(c2.logout_url,''&''||''WS_APP_ID.'',l_ws_app_id),''&''||''APP_SESSION.'',''&''||''SESSION.''),''&''||''SESSION.'',v(''APP_SESSION'')));',
'                    wwv_flow.stop_apex_engine;',
'                end if;',
'            end loop;                    ',
'        end if;',
'    end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(811176724741077278.4907)
,p_process_sequence=>50
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'redirect if login'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_found boolean := false;',
'  l_territory      varchar2(255);',
'begin',
'for c1 in (select auth_id, language, territory, home_page_id',
'             from wwv_flow_ws_applications',
'            where id = :WS_APP_ID) loop',
'  for c2 in (select auth_function, invalid_session_url',
'               from wwv_flow_ws_custom_auth_setups',
'              where id = c1.auth_id ) loop',
'               if c1.territory is null then',
'                   for c3 in (select nls_territory from wwv_flow_languages where lang_id = c1.language) loop',
'                       l_territory := c3.nls_territory;',
'                       exit;',
'                   end loop;',
'               else',
'                   l_territory := c1.territory;',
'               end if;',
'    if c2.invalid_session_url = ''-PORTAL_SSO-'' then',
'            wwv_flow.g_user := ''nobody'';',
'            wwv_flow_security.g_user := wwv_flow.g_user;',
'            wwv_flow_custom_auth.remember_deep_link(',
'                p_url=>''f?p=''||:app_id||'':900:::::WS_APP_ID,P900_ID:''||:WS_APP_ID||'',''||c1.home_page_id);',
'            begin',
'            wwv_flow_security.g_context := ''WWV_FLOW_CUSTOM_AUTH_SSO'';',
'            wwv_flow_dynamic_exec.run_block (',
'                p_sql=>''begin wwv_flow_custom_auth_sso.portal_sso_redirect; end;'',',
'                p_user=>wwv_flow.g_flow_schema_owner);',
'            wwv_flow_security.g_context := ''NULL'';',
'            exception when others then',
'               wwv_flow_security.g_context := ''NULL'';',
'               l_found := false;',
'               for c1 in (select /* APEXad5ea5 */  1 from sys.dba_objects',
'                   where object_name=''WWSEC_SSO_ENABLER_PRIVATE'' and',
'                   object_type = ''PACKAGE''',
'                   and status = ''VALID'') loop',
'                   l_found := true;',
'               end loop;',
'               if not l_found then',
'                    wwv_flow_error.raise_internal_error (',
'                        p_error_message =>',
'                            wwv_flow_lang.system_message(',
'                                p_name=>''WWV_FLOW_SECURITY.SSO_PKG_MISSING1'')||',
'                                ''<br>&nbsp;''||',
'                            wwv_flow_lang.system_message(',
'                                p_name=>''WWV_FLOW_SECURITY.SSO_PKG_MISSING2'',',
'                                p0=>''&PRODUCT_NAME.'') );',
'               else',
'                   wwv_flow_error.raise_internal_error (',
'                       p_error_code => ''WWV_FLOW_SECURITY.SSO_PKG_ERR'' );',
'               end if;',
'               return;',
'            end;',
'    else',
'      sys.htp.init;',
'      sys.owa_util.redirect_url(wwv_flow_ws_webpage.get_login_url(:WS_APP_ID));',
'      wwv_flow.stop_apex_engine;',
'    end if;',
'  end loop;',
'end loop;',
'end;'))
,p_process_when=>'LOGIN'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
end;
/
prompt --application/pages/page_00089
begin
wwv_flow_api.create_page(
 p_id=>89.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B')
,p_step_title=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4230411616343203.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4231008955350266.4907)
,p_plug_name=>unistr('\78BA\8A8D\8CC7\6599\6B04\985E\578B\8B8A\66F4')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_header=>unistr('\60A8\8981\6C42\8B8A\66F4\300C\8CC7\6599\65B9\683C\300D\8CC7\6599\6B04\985E\578B. \8CC7\6599\6B04\985E\578B\5C07\505C\7528\53C3\7167\9019\4E9B\8CC7\6599\6B04\7684\73FE\6709\7BE9\9078\3001\6A19\793A\898F\5247, \4EE5\53CA\5176\4ED6\5831\8868\8A2D\5B9A\503C. \8ACB\78BA\8A8D\60A8\7684\8981\6C42.<p />')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(128720011527408660.4907)
,p_plug_name=>unistr('\5DE5\5177\5217\53F3\6309\9215')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4231507009359228.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(128720011527408660.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4231818090362334.4907)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(128720011527408660.4907)
,p_button_name=>'CONFIRM'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\78BA\8A8D')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4236313729446260.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(128720011527408660.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(4232110828362335.4907)
,p_branch_action=>'f?p=&FLOW_ID.:2:&SESSION.::&DEBUG.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(4231818090362334.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(4236626497446261.4907)
,p_branch_action=>'f?p=&APP_ID.:91:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(4236313729446260.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4239107514595863.4907)
,p_name=>'P89_COLUMN_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4907)
,p_prompt=>unistr('\8CC7\6599\6B04\540D\7A31')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_label',
'from wwv_flow_worksheet_columns',
'where db_column_name = :p91_db_column_name',
'and worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8981\8B8A\66F4\8CC7\6599\6B04\985E\578B\7684\6240\9078\8CC7\6599\6B04\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4239902235613223.4907)
,p_name=>'P89_OLD_COLUMN_TYPE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4907)
,p_prompt=>unistr('\820A\8CC7\6599\6B04\985E\578B')
,p_source=>'wwv_flow_item.text_from_lov (:p91_column_type,''WORKSHEET_COLUMN_TYPES2'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\820A\7684\8CC7\6599\6B04\985E\578B.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4240110892615736.4907)
,p_name=>'P89_NEW_COLUMN_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4907)
,p_prompt=>unistr('\65B0\8CC7\6599\6B04\985E\578B')
,p_source=>'wwv_flow_item.text_from_lov (:p91_new_column_type,''WORKSHEET_COLUMN_TYPES2'')'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\65B0\7684\8CC7\6599\6B04\985E\578B.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4242814626061519.4907)
,p_name=>'P89_FORMAT_MASK'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(4231008955350266.4907)
,p_prompt=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B\6642\4F7F\7528\7684\683C\5F0F\906E\7F69')
,p_source=>'P91_FORMAT_MASK'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9032\884C\8CC7\6599\6B04\985E\578B\8B8A\66F4\6642\6240\8981\4F7F\7528\7684\683C\5F0F\906E\7F69.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(4243626448093240.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'change column type'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.change_column_type (',
'    p_worksheet_id         => :p2_id,',
'    p_websheet_id          => :p2_websheet_id,',
'    p_old_db_column_name   => :p91_db_column_name,    ',
'    p_new_column_type      => :P91_NEW_COLUMN_TYPE,',
'    p_format_mask_to_use   => :P91_FORMAT_MASK);'))
,p_process_error_message=>unistr('\7121\6CD5\8B8A\66F4\8CC7\6599\6B04\985E\578B.')
,p_process_when_button_id=>wwv_flow_api.id(4231818090362334.4907)
,p_process_success_message=>unistr('\5DF2\8B8A\66F4\8CC7\6599\6B04\985E\578B.')
);
end;
/
prompt --application/pages/page_00090
begin
wwv_flow_api.create_page(
 p_id=>90.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\53EF\7528\7684\7269\4EF6')
,p_step_title=>unistr('\53EF\7528\7684\7269\4EF6')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="JavaScript">',
'   function passBack(passVal1)',
'   {',
'   opener.document.getElementById("P1310_TABLE_NAME").value = passVal1;',
'   opener.document.getElementById("P1310_TABLE_NAME").focus();',
'   close();',
'   }',
'</script>',
''))
,p_step_template=>wwv_flow_api.id(134255203486851095.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(134428823965885392.4907)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(492080122343937551.4907)
,p_plug_name=>'Objects'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name d, ',
'       null t,',
'       object_name v,',
'       object_comment c',
'  from wwv_flow_ws_app_sug_objects',
' where ws_app_id = :WS_APP_ID',
'   and security_group_id = :workspace_id',
'   and nvl(:P90_TABLE_TYPE,''S'') = ''S''',
'union all',
'select table_name d,',
'       wwv_flow_lang.system_message(''TABLE'') t, ',
'       table_name v,',
'       null c',
'  from sys.dba_tables',
' where owner = :P90_SCHEMA',
'   and table_name not like ''BIN$%''',
'   and table_name not like ''APEX$_%''',
'   and :P90_TABLE_TYPE = ''A''',
'union all',
'select view_name d,',
'       wwv_flow_lang.system_message(''VIEW'') t, ',
'       view_name v,',
'       null c',
'  from sys.dba_views',
' where owner = :P90_SCHEMA',
'   and :P90_TABLE_TYPE = ''A''',
'union all',
'select synonym_name d,',
'       wwv_flow_lang.system_message(''SYNONYM'') t, ',
'       synonym_name v,',
'       null c',
'  from sys.dba_synonyms',
' where owner = :P90_SCHEMA',
'   and :P90_TABLE_TYPE = ''A''',
' order by 1'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(492080213042937551.4907)
,p_name=>'Objects'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'SBKENNED'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492080416858937588.4907)
,p_db_column_name=>'D'
,p_display_order=>2
,p_column_identifier=>'A'
,p_column_label=>unistr('\7269\4EF6\540D\7A31')
,p_column_link=>'javascript:passBack(''#V#'');'
,p_column_linktext=>'#D#'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492103930374310439.4907)
,p_db_column_name=>'T'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\7269\4EF6\985E\578B')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_condition=>'P90_TABLE_TYPE'
,p_display_condition2=>'A'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492623505769353937.4907)
,p_db_column_name=>'C'
,p_display_order=>4
,p_column_identifier=>'E'
,p_column_label=>unistr('\8A3B\89E3')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_display_condition=>'P90_TABLE_TYPE'
,p_display_condition2=>'S'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(492080514008937588.4907)
,p_db_column_name=>'V'
,p_display_order=>5
,p_column_identifier=>'B'
,p_column_label=>'V'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492053301677732661.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(134428823965885392.4907)
,p_button_name=>'CLOSE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4907)
,p_button_image_alt=>unistr('\95DC\9589')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:window.close();'
,p_button_execute_validations=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(492102203653198613.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(492080122343937551.4907)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:90,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492067824637769509.4907)
,p_name=>'P90_TABLE_TYPE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(134428823965885392.4907)
,p_prompt=>unistr('\986F\793A')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'SUGGESTED SQL TABLE TYPE (P90)'
,p_lov=>'.'||wwv_flow_api.id(17231024016826986.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'2'
,p_attribute_02=>'SUBMIT'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(492697000185414926.4907)
,p_name=>'P90_SCHEMA'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(492080122343937551.4907)
,p_use_cache_before_default=>'NO'
,p_source=>'wwv_flow_ws_setup.get_apex$_schema (p_workspace_id=>:flow_security_group_id)'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_restricted_characters=>'WORKSPACE_SCHEMA'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(495865912227957737.4907)
,p_computation_sequence=>10
,p_computation_item=>'P90_TABLE_TYPE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (',
'select count(*) cnt ',
'  from wwv_flow_ws_app_sug_objects',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID )',
'loop',
'   if c1.cnt = 0 then',
'      return ''A'';',
'   else',
'      return ''S'';',
'   end if;',
'end loop;'))
,p_compute_when=>'P90_TABLE_TYPE'
,p_compute_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(495717104974056773.4907)
,p_name=>'when no sug obj'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'NOT_EXISTS'
,p_display_when_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from wwv_flow_ws_app_sug_objects',
' where security_group_id = :flow_security_group_id',
'   and ws_app_id = :WS_APP_ID'))
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(495717422657056775.4907)
,p_event_id=>wwv_flow_api.id(495717104974056773.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P90_TABLE_TYPE'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(432751509152951102.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'check priv'
,p_process_sql_clob=>'wwv_flow_sw_api.check_priv(p_schema => :P90_SCHEMA);'
,p_process_when=>'P90_SCHEMA'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00091
begin
wwv_flow_api.create_page(
 p_id=>91.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B')
,p_step_title=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4233421912405794.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4233920131410265.4907)
,p_plug_name=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>11
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(127798813633286291.4907)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>21
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(128015931556310368.4907)
,p_plug_name=>unistr('\5DE5\5177\5217\53F3\6309\9215')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>31
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4234716106418588.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(128015931556310368.4907)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\5957\7528\8B8A\66F4')
,p_button_position=>'REGION_TEMPLATE_CHANGE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(4234126710412218.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(128015931556310368.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(4235020699418588.4907)
,p_branch_action=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(4234716106418588.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235200653423582.4907)
,p_name=>'P91_COLUMN_NAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4907)
,p_prompt=>unistr('\8CC7\6599\6B04\540D\7A31')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_label',
'from wwv_flow_worksheet_columns',
'where db_column_name = :P91_DB_COLUMN_NAME',
'and worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8981\8B8A\66F4\8CC7\6599\6B04\985E\578B\7684\6240\9078\8CC7\6599\6B04\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235408965425946.4907)
,p_name=>'P91_COLUMN_TYPE_DISPLAY'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4907)
,p_prompt=>unistr('\8CC7\6599\6B04\985E\578B')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_item.text_from_lov (column_type,''WORKSHEET_COLUMN_TYPES2'')',
'from wwv_flow_worksheet_columns',
'where db_column_name = :P91_DB_COLUMN_NAME',
'and worksheet_id = :p2_id',
'and security_group_id = :WORKSPACE_ID'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\76EE\524D\7684\8CC7\6599\6B04\985E\578B.')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235631474432520.4907)
,p_name=>'P91_NEW_COLUMN_TYPE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4907)
,p_prompt=>unistr('\65B0\8CC7\6599\6B04\985E\578B')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'WORKSHEET_COLUMN_TYPES2'
,p_lov=>'.'||wwv_flow_api.id(38353412581019585.4907)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04\985E\578B -')
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\65B0\7684\8CC7\6599\6B04\985E\578B.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4235917061437778.4907)
,p_name=>'P91_DB_COLUMN_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(127798813633286291.4907)
,p_prompt=>'Db Column Name'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4238507121567312.4907)
,p_name=>'P91_COLUMN_TYPE'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(127798813633286291.4907)
,p_prompt=>'Column Type'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_type',
'from wwv_flow_worksheet_columns',
'where db_column_name = :P91_DB_COLUMN_NAME',
'and worksheet_id = :p2_id'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(4241105389916880.4907)
,p_name=>'P91_FORMAT_MASK'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(4233920131410265.4907)
,p_prompt=>unistr('\8B8A\66F4\8CC7\6599\6B04\985E\578B\6642\4F7F\7528\7684\683C\5F0F\906E\7F69')
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'FORMAT MASK DYNAMIC'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'from wwv_flow_format_masks'))
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8F38\5165\9032\884C\8CC7\6599\6B04\985E\578B\8B8A\66F4\6642\6240\8981\4F7F\7528\7684\683C\5F0F\906E\7F69. \5C07\8CC7\6599\6B04\985E\578B\8B8A\66F4\70BA\65E5\671F\6216\6578\5B57\6642, \8ACB\52D9\5FC5\8F38\5165\683C\5F0F\906E\7F69.  \5426\5247, \8CC7\6599\6B04\985E\578B\8B8A\66F4\5C07\6703\5931\6557.')
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(4237821488533664.4907)
,p_validation_name=>'P91_NEW_COLUMN_TYPE not null'
,p_validation_sequence=>10
,p_validation=>'P91_NEW_COLUMN_TYPE'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\65B0\8CC7\6599\6B04\985E\578B.')
,p_when_button_pressed=>wwv_flow_api.id(4234716106418588.4907)
,p_associated_item=>wwv_flow_api.id(4235631474432520.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(4238113438550220.4907)
,p_validation_name=>'old type not equal new type'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P91_COLUMN_TYPE = :P91_NEW_COLUMN_TYPE then',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\65B0\8CC7\6599\6B04\985E\578B\5FC5\9700\8207\820A\8CC7\6599\6B04\985E\578B\4E0D\540C.')
,p_validation_condition=>'P91_NEW_COLUMN_TYPE'
,p_validation_condition_type=>'ITEM_IS_NOT_NULL'
,p_when_button_pressed=>wwv_flow_api.id(4234716106418588.4907)
,p_associated_item=>wwv_flow_api.id(4235631474432520.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(186914619522722819.4907)
,p_validation_name=>'P91_NEW_COLUMN_TYPE max reached'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_api.max_col_limit_reached (',
'    p_worksheet_id   => :p2_id,',
'    p_column_type    => :P91_NEW_COLUMN_TYPE) then',
'  return false;',
'else',
'  return true;',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5DF2\9054\8CC7\6599\6B04\985E\578B\7684\8CC7\6599\6B04\6578\76EE\4E0A\9650. \8ACB\9078\64C7\4E0D\540C\7684\8CC7\6599\6B04\985E\578B.')
,p_validation_condition=>'replace(:P91_NEW_COLUMN_TYPE,''%''||''null%'') is not null and :P91_COLUMN_TYPE != :P91_NEW_COLUMN_TYPE'
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(4234716106418588.4907)
,p_associated_item=>wwv_flow_api.id(4235631474432520.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00092
begin
wwv_flow_api.create_page(
 p_id=>92.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\91CD\8A2D\5BC6\78BC')
,p_step_title=>unistr('\91CD\8A2D\5BC6\78BC')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-AppCards--slim .a-AppCards-icon {',
'    margin: 16px auto;',
'}',
'',
'h1.a-Login-title {',
'    font-size: 20px;',
'    margin: 24px 0;',
'}'))
,p_step_template=>wwv_flow_api.id(1418140425267007336.4907)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_api.id(506060600392166972)
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(8557512241276654.4907)
,p_plug_name=>'Reset password Container'
,p_region_css_classes=>'a-Login-region a-Form--stretchInputs a-Form--labelsAbove'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_ws_applications ',
'where id = :WS_APP_ID'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1284871394951082007.4907)
,p_plug_name=>'Reset assword Header'
,p_parent_plug_id=>wwv_flow_api.id(8557512241276654.4907)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (with pkg_app_image as (',
'               select m.installed_ws_id,',
'                      p.image_identifier image_class',
'               from wwv_flow_pkg_applications p, wwv_flow_pkg_app_map m',
'               where p.app_id = m.app_id',
'               and p.app_type = ''WS''',
'               and m.security_group_id = :flow_security_group_id',
'               )',
'           select ',
'               p.image_class,',
'               case when p.image_class is null then ',
'                   wwv_flow_4000_ui.get_app_initials( name, id )',
'               else',
'                   '' ''',
'               end as app_initials,',
'               case when p.image_class is null then ',
'                   ''u-ColorBG--'' || to_char( ora_hash( name, 29 ) + 1 )',
'               else',
'                   '' ''',
'               end as app_color,',
'               name ws_name',
'           from  wwv_flow_ws_applications a,',
'                 pkg_app_image p',
'           where a.security_group_id = :flow_security_group_id',
'           and a.id = p.installed_ws_id (+)',
'           and a.id = :ws_app_id)',
'loop',
'    sys.htp.p(''<div class="a-Login-header a-AppCards--slim">'');',
'    sys.htp.p(''  <span class="a-AppCards-icon a-AppCards-icon--initials ''||',
'              wwv_flow_escape.html(c1.image_class)||'' ''||',
'              wwv_flow_escape.html(c1.app_color)||',
'              ''" role="presentation" aria-hidden="true">''||',
'              wwv_flow_escape.html(c1.app_initials)||',
'              ''</span>'');',
'    sys.htp.p(''  <h1 class="a-Login-title">''||wwv_flow_escape.html(c1.ws_name)||''</h1>'');',
'    sys.htp.p(''</div>'');',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1418413115140401416.4907)
,p_plug_name=>'Reset password items'
,p_parent_plug_id=>wwv_flow_api.id(8557512241276654.4907)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1418149362592020763.4907)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(692442804709370101.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1418413115140401416.4907)
,p_button_name=>'RESET_PASSWORD'
,p_button_action=>'SUBMIT'
,p_button_template_id=>wwv_flow_api.id(798473351219404350.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\91CD\8A2D\5BC6\78BC')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>' a-Button--large'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(692442518084364512.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1418413115140401416.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(798473351219404350.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::'
,p_button_css_classes=>'a-Button--large'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(692443304148379348.4907)
,p_branch_action=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(692442804709370101.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(692437908116266949.4907)
,p_name=>'P92_EMAIL'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1418413115140401416.4907)
,p_prompt=>unistr('\60A8\5728\6211\5011\8CC7\6599\5EAB\4E2D\7684\96FB\5B50\90F5\4EF6\5730\5740')
,p_placeholder=>unistr('\96FB\5B50\90F5\4EF6\5730\5740')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(1418153120551046350.4907)
,p_item_css_classes=>'icon-login-email'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'EMAIL'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(692438611018277308.4907)
,p_name=>'P92_WORKSPACE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1418413115140401416.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_help_text=>unistr('\8F38\5165\60A8\7684\5DE5\4F5C\5340.')
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(693704031500021583.4907)
,p_name=>'P92_USERNAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1418413115140401416.4907)
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31')
,p_placeholder=>unistr('\4F7F\7528\8005\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_api.id(1418153120551046350.4907)
,p_item_css_classes=>'icon-login-username'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(7293128029885669.4907)
,p_validation_name=>'is valid email and username'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_fnd_user u, wwv_flow_ws_applications w',
'where upper(u.email_address) = upper(:P92_EMAIL) and',
'      upper(u.user_name) = upper(:P92_USERNAME) and',
'      u.security_group_id != 10 and',
'      u.security_group_id = w.security_group_id and',
'      w.id = :WS_APP_ID'))
,p_validation_type=>'EXISTS'
,p_error_message=>unistr('\60A8\8F38\5165\7684\4F7F\7528\8005\540D\7A31\6216\96FB\5B50\90F5\4EF6\5730\5740\4E0D\6B63\78BA.')
,p_when_button_pressed=>wwv_flow_api.id(692442804709370101.4907)
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(692443023410375451.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Reset Password'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_fnd_developer_api.f4900_reset_password (',
'  p_ws_app_id => :WS_APP_ID,',
'  p_user_name => :P92_USERNAME,',
'  p_email_address=> :P92_EMAIL,',
'  p_workspace_name=> null );'))
,p_process_error_message=>unistr('\7121\6CD5\91CD\8A2D\5BC6\78BC.')
,p_process_when_button_id=>wwv_flow_api.id(692442804709370101.4907)
,p_process_success_message=>unistr('\5DF2\50B3\9001\91CD\8A2D\5BC6\78BC\8981\6C42\9032\884C\8655\7406.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(693689731931002813.4907)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Determine Workspace'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select security_group_id from wwv_flow_ws_applications where id = :WS_APP_ID) loop',
'    :P92_WORKSPACE := c1.security_group_id;',
'end loop;'))
);
end;
/
prompt --application/pages/page_00099
begin
wwv_flow_api.create_page(
 p_id=>99.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\672A\6388\6B0A')
,p_step_title=>unistr('\672A\6388\6B0A')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(456110204457776640.4907)
,p_plug_name=>'Not Authorized'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>unistr('<p>\672A\6388\6B0A\60A8\5B58\53D6\6B64\61C9\7528\7A0B\5F0F\6216\529F\80FD.</p>')
,p_translate_title=>'N'
,p_region_image=>'#IMAGE_PREFIX#menu/alarm_bell_wbg_64x64.png'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00101
begin
wwv_flow_api.create_page(
 p_id=>101.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\767B\5165')
,p_alias=>'LOGIN'
,p_step_title=>unistr('Web \8A66\7B97\8868\767B\5165')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-AppCards--slim .a-AppCards-icon { margin: 16px auto; }',
'h1.a-Login-title { font-size: 20px; margin: 24px 0; }',
'.a-Login-wsMsg { font-size: 14px; margin: 16px 8px; color: #707070; }',
'.a-Form-fieldContainer--hiddenLabel .apex-item-option {height: 16px;}'))
,p_step_template=>wwv_flow_api.id(1418140425267007336.4907)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1410890655888668019.4907)
,p_plug_name=>unistr('\767B\5165\5340\57DF\5BB9\5668')
,p_region_css_classes=>'a-Login-region a-Form--stretchInputs a-Form--labelsAbove'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(154773620917091162.4907)
,p_plug_name=>'Sign In items'
,p_parent_plug_id=>wwv_flow_api.id(1410890655888668019.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="float:left; clear:both;"'
,p_plug_template=>wwv_flow_api.id(1418149362592020763.4907)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459631111530350735.4907)
,p_plug_name=>'Language Selector'
,p_parent_plug_id=>wwv_flow_api.id(1410890655888668019.4907)
,p_region_css_classes=>'a-Login-links a-Login-links--languages'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3700433754276.4907)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>'sys.htp.p( wwv_flow_lang.get_language_selector_list );'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'PLSQL_EXPRESSION'
,p_plug_display_when_condition=>'wwv_flow_4000_ui.is_translation_installed( p_flow_id => 4000 )'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1410890754992668020.4907)
,p_plug_name=>'Sign In Region Header'
,p_parent_plug_id=>wwv_flow_api.id(1410890655888668019.4907)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (with pkg_app_image as (',
'               select m.installed_ws_id,',
'                      p.image_identifier image_class',
'               from wwv_flow_pkg_applications p, wwv_flow_pkg_app_map m',
'               where p.app_id = m.app_id',
'               and p.app_type = ''WS''',
'               and m.security_group_id = :flow_security_group_id',
'               )',
'           select ',
'               p.image_class,',
'               case when p.image_class is null then ',
'                   wwv_flow_4000_ui.get_app_initials( name, id )',
'               else',
'                   '' ''',
'               end as app_initials,',
'               case when p.image_class is null then ',
'                   ''u-ColorBG--'' || to_char( ora_hash( name, 29 ) + 1 )',
'               else',
'                   '' ''',
'               end as app_color,',
'               name ws_name',
'           from  wwv_flow_ws_applications a,',
'                 pkg_app_image p',
'           where a.security_group_id = :flow_security_group_id',
'           and a.id = p.installed_ws_id (+)',
'           and a.id = :ws_app_id)',
'loop',
'    sys.htp.p(''<div class="a-Login-header a-AppCards--slim">'');',
'    sys.htp.p(''  <span class="a-AppCards-icon a-AppCards-icon--initials ''||',
'              wwv_flow_escape.html(c1.image_class)||'' ''||',
'              wwv_flow_escape.html(c1.app_color)||',
'              ''" role="presentation" aria-hidden="true">''||',
'              wwv_flow_escape.html(c1.app_initials)||',
'              ''</span>'');',
'    sys.htp.p(''  <h1 class="a-Login-title">''||wwv_flow_escape.html(c1.ws_name)||''</h1>'');',
'    for l_msg in (select login_page_message ',
'                  from WWV_FLOW_WS_APPLICATIONS ',
'                  where id = :WS_APP_ID',
'                  and login_page_message is not null )',
'    loop',
'        sys.htp.p(''<p class="a-Login-wsMsg">''||wwv_flow_escape.html(l_msg.login_page_message)||''</p>'');',
'    end loop;',
'    sys.htp.p(''</div>'');',
'end loop;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(61034832101787205.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(154773620917091162.4907)
,p_button_name=>'RESET_PASSWORD'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\91CD\8A2D\5BC6\78BC')
,p_button_position=>'REGION_TEMPLATE_EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:92:&SESSION.::&DEBUG.:::'
,p_button_condition=>'return wwv_flow_ws_api.show_reset_password (p_ws_app_id=>:WS_APP_ID);'
,p_button_condition_type=>'FUNCTION_BODY'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(5698501044727837.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(154773620917091162.4907)
,p_button_name=>'LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(798473351219404350.4907)
,p_button_is_hot=>'Y'
,p_button_image_alt=>unistr('\767B\5165')
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_css_classes=>'a-Button--large'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154773716538091162.4907)
,p_name=>'P101_USERNAME'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4907)
,p_prompt=>unistr('\4F7F\7528\8005\540D\7A31')
,p_placeholder=>unistr('\4F7F\7528\8005\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>128
,p_field_template=>wwv_flow_api.id(1418153120551046350.4907)
,p_item_css_classes=>'icon-login-username'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154773815685091162.4907)
,p_name=>'P101_PASSWORD'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4907)
,p_prompt=>unistr('\5BC6\78BC')
,p_placeholder=>unistr('\5BC6\78BC')
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>40
,p_cMaxlength=>100
,p_field_template=>wwv_flow_api.id(1418153120551046350.4907)
,p_item_css_classes=>'icon-login-password'
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(216990508511910211.4907)
,p_name=>'P101_REMEMBER'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4907)
,p_prompt=>unistr('\8A18\4F4F\4F7F\7528\8005\540D\7A31')
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'REMEMBER_USERNAME'
,p_lov=>'.'||wwv_flow_api.id(263997216503587205.4907)||'.'
,p_field_template=>wwv_flow_api.id(264000229814622656.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
unistr('\5982\679C\9078\53D6\6B64\6838\53D6\65B9\584A, Web \8A66\7B97\8868\6703\5C07\60A8\7684\4F7F\7528\8005\540D\7A31\5132\5B58\5728\540D\70BA "LOGIN_USERNAME_COOKIE" \7684\6C38\4E45\700F\89BD\5668 Cookie \4E2D.'),
unistr('\60A8\4E0B\6B21\524D\5F80\767B\5165\9801\9762\6642,'),
unistr('\4F7F\7528\8005\540D\7A31\6B04\4F4D\5C07\6703\81EA\52D5\586B\5165\6B64\503C.'),
'</p>',
'<p>',
unistr('\5982\679C\53D6\6D88\9078\53D6\6B64\6838\53D6\65B9\584A, \4E14\60A8\7684\4F7F\7528\8005\540D\7A31\5DF2\7D93\5132\5B58\5728 Cookie \4E2D,'),
unistr('\5247 Web \8A66\7B97\8868\5C07\6703\4EE5\7A7A\767D\503C\52A0\4EE5\8986\5BEB.'),
unistr('\60A8\4E5F\53EF\4EE5\4F7F\7528\700F\89BD\5668\7684\958B\767C\4EBA\54E1\5DE5\5177, \5C07\6B64 Cookie \5B8C\5168\79FB\9664.'),
'</p>'))
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(388700621118310671.4907)
,p_name=>'P101_BUILDER_SESSION_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(154773620917091162.4907)
,p_use_cache_before_default=>'NO'
,p_item_default=>'wwv_flow_security.get_builder_session_id'
,p_item_default_type=>'PLSQL_EXPRESSION'
,p_source=>'wwv_flow_security.get_builder_session_id'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(10356803620488362.4907)
,p_validation_name=>'P101_USERNAME Not Null'
,p_validation_sequence=>10
,p_validation=>'P101_USERNAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\503C.')
,p_associated_item=>wwv_flow_api.id(154773716538091162.4907)
,p_error_display_location=>'INLINE_WITH_FIELD'
,p_validation_comment=>'generated 09-OCT-2008 14:47'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(10357031948488372.4907)
,p_validation_name=>'P101_PASSWORD Not Null'
,p_validation_sequence=>20
,p_validation=>'P101_PASSWORD'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\503C.')
,p_associated_item=>wwv_flow_api.id(154773815685091162.4907)
,p_error_display_location=>'INLINE_WITH_FIELD'
,p_validation_comment=>'generated 09-OCT-2008 14:47'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774114072091162.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Username Cookie'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_authentication.send_login_username_cookie (',
'    p_username => :P101_USERNAME,',
'    p_consent  => :P101_REMEMBER = ''Y'' );'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774006644091162.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Login'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_custom_auth_std.ws_login(',
'    P_UNAME            => :P101_USERNAME,',
'    P_PASSWORD         => :P101_PASSWORD,',
'    P_SESSION_ID       => v(''APP_SESSION''),',
'    P_WEBSHEET_APP_ID  => :WS_APP_ID,',
'    p_websheet_page_id => :P900_ID );'))
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774302570091162.4907)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'Clear Page(s) Cache'
,p_attribute_01=>'CLEAR_CACHE_FOR_PAGES'
,p_attribute_04=>'101'
,p_process_when=>'P101_REGION'
,p_process_when_type=>'REQUEST_NOT_EQUAL_CONDITION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(154774210215091162.4907)
,p_process_sequence=>40
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Username Cookie'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P101_USERNAME := apex_authentication.get_login_username_cookie;',
':P101_REMEMBER := case when :P101_USERNAME is not null then ''Y'' end;'))
,p_process_when=>':P101_USERNAME is null'
,p_process_when_type=>'PLSQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00102
begin
wwv_flow_api.create_page(
 p_id=>102.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\610F\898B\56DE\994B')
,p_alias=>'FEEDBACK'
,p_step_title=>unistr('\610F\898B\56DE\994B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>wwv_flow_api.id(134255203486851095.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_page_comment=>'This page was generated by the feedback wizard'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(203493217304049113.4907)
,p_plug_name=>unistr('\610F\898B\56DE\994B')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(82536903857665765.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(752334827869677901.4907)
,p_plug_name=>unistr('\6309\9215\5340\57DF')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4907)
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(203497828051049124.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(752334827869677901.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(203497606057049122.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(752334827869677901.4907)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4907)
,p_button_image_alt=>unistr('\9001\51FA\610F\898B\56DE\994B')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203493400295049114.4907)
,p_name=>'P102_APPLICATION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_prompt=>unistr('\61C9\7528\7A0B\5F0F')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>60
,p_cMaxlength=>2000
,p_cHeight=>1
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\61C9\7528\7A0B\5F0F.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203494014853049116.4907)
,p_name=>'P102_PAGE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_prompt=>unistr('\9801\9762')
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>60
,p_cMaxlength=>2000
,p_cHeight=>1
,p_tag_attributes=>'class="display_bold"'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\61C9\7528\7A0B\5F0F\5167\7684\9801\9762.')
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203494614905049117.4907)
,p_name=>'P102_A'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203494830875049118.4907)
,p_name=>'P102_FEEDBACK'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_prompt=>unistr('\610F\898B\56DE\994B')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8F38\5165\60A8\7684\610F\898B\56DE\994B, \7136\5F8C\6309\300C\9001\51FA\610F\898B\56DE\994B\300D\6309\9215.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203495425757049118.4907)
,p_name=>'P102_X'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203495625923049119.4907)
,p_name=>'P102_FEEDBACK_TYPE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_prompt=>unistr('\610F\898B\56DE\994B\985E\578B')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>'select the_name, id from WWV_FLOW_FEEDBACK_TYPES order by id'
,p_cSize=>20
,p_cMaxlength=>100
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8ACB\6307\5B9A\60A8\63D0\4F9B\4E4B\610F\898B\56DE\994B\7684\985E\578B.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203496204433049120.4907)
,p_name=>'P102_Y'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_item_comment=>'workspace 10'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203496432737049121.4907)
,p_name=>'P102_ATTRIBUTE1'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_prompt=>unistr('\5143\4EF6:')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'FEEDBACK_COMPONENT'
,p_lov=>'.'||wwv_flow_api.id(945870019196474793.4907)||'.'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\8ACB\63D0\4F9B\8981\8A18\9304\5728\610F\898B\56DE\994B\4E2D\7684\8CC7\8A0A.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(203497005770049121.4907)
,p_name=>'P102_ATTRIBUTE2'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(203493217304049113.4907)
,p_prompt=>unistr('\5C6C\6027 2')
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_label_alignment=>'LEFT-TOP'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8ACB\63D0\4F9B\8981\8A18\9304\5728\610F\898B\56DE\994B\4E2D\7684\8CC7\8A0A.')
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(203498000886049124.4907)
,p_validation_name=>'Feedback not null'
,p_validation_sequence=>10
,p_validation=>'P102_FEEDBACK'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\503C')
,p_when_button_pressed=>wwv_flow_api.id(203497606057049122.4907)
,p_associated_item=>wwv_flow_api.id(203494830875049118.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(203498223414049125.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Submit Feedback'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.submit_feedback (',
'    p_comment         => :P102_FEEDBACK,',
'    p_type            => :P102_FEEDBACK_TYPE,',
'    p_application_id     => :P102_APPLICATION_ID,',
'    p_page_id         => :P102_PAGE_ID,',
'    p_label_01        => ''Component'',',
'    p_label_02        => ''Contact me via email'',',
'    p_attribute_01   => :P102_ATTRIBUTE1,',
'    p_attribute_02   => :P102_ATTRIBUTE2);'))
,p_process_when_button_id=>wwv_flow_api.id(203497606057049122.4907)
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(203498403008049126.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Window'
);
end;
/
prompt --application/pages/page_00131
begin
wwv_flow_api.create_page(
 p_id=>131.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\9801\9762')
,p_step_title=>unistr('\5EFA\7ACB\9801\9762')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20820515633073398.4907)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173220910407622558.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173221309115622593.4907)
,p_plug_name=>unistr('\5EFA\7ACB')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(173227111911856634.4907)
,p_plug_name=>'create page progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(173233928842908830.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20820515633073398.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(173234125942908830.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20820515633073398.4907)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4907)
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(173234507156912066.4907)
,p_branch_action=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:205::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P131_PAGE_TYPE'
,p_branch_condition_text=>'DATA'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(181302519582692237.4907)
,p_branch_action=>'f?p=&APP_ID.:1310:&SESSION.::&DEBUG.:1310,1320::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(173234125942908830.4907)
,p_branch_sequence=>30
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P131_PAGE_TYPE'
,p_branch_condition_text=>'REPORT'
,p_save_state_before_branch_yn=>'Y'
,p_security_scheme=>wwv_flow_api.id(495860932509802714)
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173236415514942802.4907)
,p_name=>'P131_PAGE_TYPE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(173221309115622593.4907)
,p_item_default=>'TEXT'
,p_prompt=>unistr('\60A8\60F3\5EFA\7ACB\54EA\7A2E\985E\578B\7684\8CC7\6599\5143\4EF6?')
,p_source=>'DATA'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CREATE DATA OR REPORT'
,p_lov=>'.'||wwv_flow_api.id(173236520362944199.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'ABOVE'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\9078\53D6\8981\5EFA\7ACB\7684\8CC7\6599\5143\4EF6\985E\578B.')
,p_attribute_01=>'3'
,p_attribute_02=>'NONE'
);
end;
/
prompt --application/pages/page_00140
begin
wwv_flow_api.create_page(
 p_id=>140.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\76E3\7763\6D3B\52D5')
,p_step_title=>unistr('\76E3\7763\6D3B\52D5')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(9297021464956579.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(187174414157946457.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(459635018791429050.4907)
,p_plug_name=>unistr('\6D3B\52D5')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:49%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(459634320543429042.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(460619812376871783.4907)
,p_plug_name=>unistr('\95DC\65BC')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(9299916504097072.4907)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_05'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>unistr('<p>\60A8\53EF\4EE5\4F7F\7528\9019\4E9B\9801\9762\4F86\5206\6790\4F7F\7528\72C0\6CC1\3001\6548\80FD\4EE5\53CA\9801\9762\548C\5167\5BB9\53D7\6B61\8FCE\7684\7A0B\5EA6.</p>')
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461180329066335897.4907)
,p_plug_name=>unistr('\8A3B\89E3')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="width:49%; float:left;"'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(11269620137104105.4907)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(461178801985335895.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
);
end;
/
prompt --application/pages/page_00141
begin
wwv_flow_api.create_page(
 p_id=>141.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\8CC7\6599\65B9\683C')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\8CC7\6599\65B9\683C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23764728224473605.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23764905998473606.4907)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23764728224473605.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23765115127473607.4907)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23764728224473605.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461236028506810793.4907)
,p_plug_name=>'Page Views'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'   (select max(WEBSHEET_NAME)',
'       from WWV_FLOW_WS_WEBSHEET_ATTR p',
'       where p.ws_app_id = :ws_app_id',
'       and p.id = l.DATAGRID_ID) data_grid_name,',
'    count(*) page_views,',
'    avg(elap) elap,',
'    avg(num_rows) num_rows,',
'    count(distinct userid) userid,',
'    avg(content_length) CONTENT_LENGTH',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P141_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    DATAGRID_ID is not null and',
'    datagrid_id in (select id from WWV_FLOW_WS_WEBSHEET_ATTR where ws_app_id = :ws_app_id and WEBSHEET_TYPE = ''DATA'')',
'group by     l.DATAGRID_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(461236228917810797.4907)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236316065810801.4907)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\5E73\5747\5448\73FE\6642\9593')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236430570810802.4907)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\5E73\5747\8CC7\6599\5217\6578\76EE')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236514063810802.4907)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5E73\5747\5167\5BB9\9577\5EA6')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236710411810802.4907)
,p_db_column_name=>'USERID'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('\4E0D\540C\4F7F\7528\8005')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461236829739810802.4907)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\9801\9762\6AA2\8996')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461242409753848980.4907)
,p_db_column_name=>'DATA_GRID_NAME'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\8CC7\6599\65B9\683C\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461330100756322323.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(461237306673810811.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(461236028506810793.4907)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:141:&SESSION.::&DEBUG.:141,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(461237501740810812.4907)
,p_name=>'P141_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23765115127473607.4907)
,p_item_default=>'1'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\986F\793A\6240\9078\5831\8868\6642\9593\7BC4\570D\5167\7684\5831\8868\8CC7\6599.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00142
begin
wwv_flow_api.create_page(
 p_id=>142.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\5831\8868')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\5831\8868')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23768425584482295.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23768620004482297.4907)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23768425584482295.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23768808968482297.4907)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23768425584482295.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461244005589858615.4907)
,p_plug_name=>'Page Views'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'   (select max(WEBSHEET_NAME)',
'       from WWV_FLOW_WS_WEBSHEET_ATTR p',
'       where p.ws_app_id = :ws_app_id',
'       and p.id = l.DATAGRID_ID) data_grid_name,',
'    count(*) page_views,',
'    avg(elap) elap,',
'    avg(num_rows) num_rows,',
'    count(distinct userid) userid,',
'    avg(content_length) CONTENT_LENGTH',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - nvl(:P142_TIME,1)) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id and',
'    DATAGRID_ID is not null and',
'    datagrid_id in (select id from WWV_FLOW_WS_WEBSHEET_ATTR where ws_app_id = :ws_app_id and WEBSHEET_TYPE = ''REPORT'')',
'group by     l.DATAGRID_ID'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(461244219249858616.4907)
,p_name=>'Page Views'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244423593858617.4907)
,p_db_column_name=>'ELAP'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\5E73\5747\5448\73FE\6642\9593')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G990D0000'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244509013858617.4907)
,p_db_column_name=>'NUM_ROWS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\5E73\5747\8CC7\6599\5217\6578\76EE')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244618067858617.4907)
,p_db_column_name=>'CONTENT_LENGTH'
,p_display_order=>21
,p_column_identifier=>'U'
,p_column_label=>unistr('\5E73\5747\5167\5BB9\9577\5EA6')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244716297858617.4907)
,p_db_column_name=>'USERID'
,p_display_order=>25
,p_column_identifier=>'Y'
,p_column_label=>unistr('\4E0D\540C\4F7F\7528\8005')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244806456858617.4907)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>26
,p_column_identifier=>'Z'
,p_column_label=>unistr('\9801\9762\6AA2\8996')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(461244320248858616.4907)
,p_db_column_name=>'DATA_GRID_NAME'
,p_display_order=>27
,p_column_identifier=>'AA'
,p_column_label=>unistr('\8CC7\6599\65B9\683C\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(461331213223325868.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(461245330336858618.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(461244005589858615.4907)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.:142,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(461245523336858619.4907)
,p_name=>'P142_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23768808968482297.4907)
,p_item_default=>'1'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\986F\793A\6240\9078\5831\8868\6642\9593\7BC4\570D\5167\7684\5831\8868\8CC7\6599.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00143
begin
wwv_flow_api.create_page(
 p_id=>143.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\6A94\6848')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\6A94\6848')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471901413752065160.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471907103870125733.4907)
,p_plug_name=>'Top Files by User'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'       c009 created_by,',
'       count(*) c,',
'       sum(decode(greatest(d002,sysdate-1),sysdate-1,0,1)) last_day,',
'       sum(decode(greatest(d002,sysdate-7),sysdate-7,0,1)) created_last_7_days,',
'       sum(decode(greatest(d002,add_months(sysdate,-1)),add_months(sysdate,-1),0,1)) last_month,',
'       apex_util.get_since(max(d002)) most_recent',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_FILES''',
'group by c009'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(471907203619125733.4907)
,p_name=>'Top Files by User'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471907430015125742.4907)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\4F7F\7528\8005\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471907510799125744.4907)
,p_db_column_name=>'C'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\6A94\6848\8A08\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471909222611156826.4907)
,p_db_column_name=>'CREATED_LAST_7_DAYS'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\4E0A\9031')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471909706596171166.4907)
,p_db_column_name=>'LAST_MONTH'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\4E0A\500B\6708')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471910003957179869.4907)
,p_db_column_name=>'LAST_DAY'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\524D 1 \5929')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914803012236331.4907)
,p_db_column_name=>'MOST_RECENT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\6700\65B0\9805\76EE')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(473412104980505809.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23795705639561731.4907)
,p_plug_name=>'Admin Annotation Tab'
,p_parent_plug_id=>wwv_flow_api.id(473412104980505809.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23775330395531080.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(473412314903505852.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(471907103870125733.4907)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:143:&SESSION.::&DEBUG.:143,RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(471901910350068155.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create collection'
,p_process_sql_clob=>'wwv_flow_ws_api.create_attachment_collection (p_ws_app_id    => :ws_app_id);'
);
end;
/
prompt --application/pages/page_00144
begin
wwv_flow_api.create_page(
 p_id=>144.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\9644\8A3B')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\9644\8A3B')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471902911012084490.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471912413500212406.4907)
,p_plug_name=>'Top Notes by Username'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'   c003 created_by,',
'   count(*) new_notes,',
'   sum(decode(greatest(d001,sysdate-1),sysdate-1,0,1)) last_day,',
'   sum(decode(greatest(d001,sysdate-7),sysdate-7,0,1)) created_last_7_days,',
'   sum(decode(greatest(d001,add_months(sysdate,-1)),add_months(sysdate,-1),0,1)) last_month,',
'   apex_util.get_since(max(d001)) most_recent',
'from wwv_flow_collections',
'where collection_name = ''APEX$_WS_NOTES''',
'group by c003'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(471912507778212406.4907)
,p_name=>'Top Notes by Username'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471912706310212408.4907)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\4F7F\7528\8005\540D\7A31')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471912829080212409.4907)
,p_db_column_name=>'NEW_NOTES'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\9644\8A3B\8A08\6578')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471913913139220374.4907)
,p_db_column_name=>'LAST_DAY'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\524D 1 \5929')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914029231220374.4907)
,p_db_column_name=>'CREATED_LAST_7_DAYS'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>unistr('\4E0A\9031')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914113108220376.4907)
,p_db_column_name=>'LAST_MONTH'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\4E0A\500B\6708')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471914307729228250.4907)
,p_db_column_name=>'MOST_RECENT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\6700\65B0\9805\76EE')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(473415025889521297.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>3
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23814902438579759.4907)
,p_plug_name=>'Admin Annotation Tab'
,p_parent_plug_id=>wwv_flow_api.id(473415025889521297.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23775330395531080.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(473416325674530692.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(471912413500212406.4907)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:144:&SESSION.::&DEBUG.:144,RIR::'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(471912009760200442.4907)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_note_collection (',
'    p_ws_app_id => :ws_app_id',
'    );'))
);
end;
/
prompt --application/pages/page_00145
begin
wwv_flow_api.create_page(
 p_id=>145.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\6A19\8A18')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\6A19\8A18')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23816101530588971.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(25109627701530900.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23816319486588973.4907)
,p_plug_name=>'Admin Annotation Tab'
,p_parent_plug_id=>wwv_flow_api.id(23816101530588971.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23775330395531080.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471904015280093887.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471905601524103473.4907)
,p_plug_name=>'Tag Cloud'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="clear: both"'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_webpage.show_tag_clouds (',
'    p_ws_app_id             => :ws_app_id,    ',
'    p_session_id            => :app_session);'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
end;
/
prompt --application/pages/page_00146
begin
wwv_flow_api.create_page(
 p_id=>146.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_step_title=>unistr('\6700\5E38\4F7F\7528\7684\4F7F\7528\8005')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23771705892505054.4907)
,p_plug_name=>'Action Bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20454830409304572.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23771903817505055.4907)
,p_plug_name=>'Monitor Activity Tab'
,p_parent_plug_id=>wwv_flow_api.id(23771705892505054.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(23689225706066046.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(20455926267312733.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(23772114743505056.4907)
,p_plug_name=>'Set Page'
,p_parent_plug_id=>wwv_flow_api.id(23771705892505054.4907)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_translate_title=>'N'
,p_plug_header=>'<div class="wsSmallFormComponent">'
,p_plug_footer=>'</div>'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471916808921272522.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(471919230020311098.4907)
,p_plug_name=>'Top Users'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'    userid,',
'    count(*) page_views,',
'    count(distinct webpage_id) distinct_pages,',
'   sum(CONTENT_LENGTH) content_served,',
'   sum(num_rows) rows_served,',
'   sum(elap) page_generation_time',
'from WWV_FLOW_ACTIVITY_LOG l',
'where security_group_id = :flow_security_group_id and',
'    (time_stamp > sysdate - :P146_TIME) and',
'    ( flow_id = 4900 ) and',
'    websheet_id = :ws_app_id',
'group by userid'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(471919303440311098.4907)
,p_name=>'Top Users'
,p_max_row_count=>'10000'
,p_max_row_count_message=>unistr('\6B64\67E5\8A62\50B3\56DE 10,000 \500B\4EE5\4E0A\7684\8CC7\6599\5217, \8ACB\7BE9\9078\8CC7\6599, \78BA\4FDD\53D6\5F97\5B8C\6574\7684\7D50\679C.')
,p_no_data_found_message=>unistr('\627E\4E0D\5230\8CC7\6599.')
,p_allow_save_rpt_public=>'Y'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_show_calendar=>'N'
,p_download_formats=>'CSV'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'MIKE'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919508010311100.4907)
,p_db_column_name=>'USERID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>unistr('\4F7F\7528\8005')
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919604537311100.4907)
,p_db_column_name=>'PAGE_VIEWS'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>unistr('\9801\9762\6AA2\8996')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919731265311100.4907)
,p_db_column_name=>'DISTINCT_PAGES'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>unistr('\4E0D\540C\7684\9801\9762')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471919900949311100.4907)
,p_db_column_name=>'CONTENT_SERVED'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>unistr('\63D0\4F9B\7684\5167\5BB9')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471920018399311101.4907)
,p_db_column_name=>'ROWS_SERVED'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>unistr('\63D0\4F9B\7684\8CC7\6599\5217')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(471920105353311101.4907)
,p_db_column_name=>'PAGE_GENERATION_TIME'
,p_display_order=>7
,p_column_identifier=>'G'
,p_column_label=>unistr('\9801\9762\7522\751F\6642\9593')
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G999G990D99'
,p_tz_dependent=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(472158913824081267.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(471919230020311098.4907)
,p_button_name=>'Reset'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20457218105321816.4907)
,p_button_image_alt=>unistr('\91CD\8A2D')
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:146:&SESSION.::&DEBUG.:146,RIR::'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(472159121381081270.4907)
,p_name=>'P146_TIME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(23772114743505056.4907)
,p_item_default=>'1'
,p_prompt=>unistr('\6642\9593\7BC4\570D')
,p_source=>'1'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TIMEFRAME'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,  trim(rtrim(to_char(t,''9999D999999'',''NLS_NUMERIC_CHARACTERS=''''.,''''''),''0.'')) t',
'from (',
'select ''10 ''||wwv_flow_lang.system_message(''SECONDS'') d, 10/(24*60*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''MINUTE'') d, 1/(24*60) t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''MINUTES'') d, 5/(24*60) t from dual union all',
'select ''15 ''||wwv_flow_lang.system_message(''MINUTES'') d, 15/(24*60) t from dual union all',
'select ''30 ''||wwv_flow_lang.system_message(''MINUTES'') d, 30/(24*60) t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''HOUR'') d, 1/24 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''HOURS'') d, 1/12  t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''HOURS'') d, 3/24  t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''HOURS'') d, 4/24  t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''HOURS'') d, 6/24 t from dual union all',
'select ''8 ''||wwv_flow_lang.system_message(''HOURS'') d, 8/24 t from dual union all',
'select ''12 ''||wwv_flow_lang.system_message(''HOURS'') d, 12/24 t from dual union all',
'select ''18 ''||wwv_flow_lang.system_message(''HOURS'') d, 18/24 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''DAY'') d, 1 t from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''DAYS'') d, 2 t from dual union all',
'select ''3 ''||wwv_flow_lang.system_message(''DAYS'') d, 3 t from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''DAYS'') d, 4 t from dual union all',
'select ''5 ''||wwv_flow_lang.system_message(''DAYS'') d, 5 t from dual union all',
'select ''6 ''||wwv_flow_lang.system_message(''DAYS'') d, 6 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''WEEK'') d, 7 t  from dual union all',
'select ''2 ''||wwv_flow_lang.system_message(''WEEKS'') d, 14 t  from dual union all',
'select ''4 ''||wwv_flow_lang.system_message(''WEEKS'') d, 28 t from dual union all',
'select ''1 ''||wwv_flow_lang.system_message(''YEAR'') d, 365 t from dual order by 2',
') q'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\986F\793A\6240\9078\5831\8868\6642\9593\7BC4\570D\5167\7684\5831\8868\8CC7\6599.')
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
end;
/
prompt --application/pages/page_00200
begin
wwv_flow_api.create_page(
 p_id=>200.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\9801\9762')
,p_step_title=>unistr('\5EFA\7ACB\9801\9762')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1198430386542478.4907)
,p_plug_name=>unistr('\5EFA\7ACB\9801\9762')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(11464130252463090.4907)
,p_plug_name=>unistr('\5DE5\5177\5217\6309\9215')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436570726052138706.4907)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,    ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',   ',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_PAGE''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154880404371674336.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(11464130252463090.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154880603784674338.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(11464130252463090.4907)
,p_button_name=>'create'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\5EFA\7ACB\9801\9762')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(155398607371684404.4907)
,p_branch_action=>'f?p=&APP_ID.:900:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(173712624517222880.4907)
,p_name=>'P200_NAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1198430386542478.4907)
,p_prompt=>unistr('\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8F38\5165\9801\9762\540D\7A31. \9801\9762\540D\7A31\986F\793A\5728\8996\7A97\6A19\984C\4EE5\53CA\5C0E\89BD\8DEF\5F91\4E2D.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(174369210872944115.4907)
,p_name=>'P200_PARENT_PAGE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1198430386542478.4907)
,p_prompt=>unistr('\7236\9805\9801\9762')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'TEXT WEBSHEETS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'from   wwv_flow_ws_webpages',
'where security_group_id = :flow_security_group_id and',
'      ws_app_id = :WS_APP_ID',
'order by 1'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\7236\9805\9801\9762 -')
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\5982\679C\6B64\9801\9762\5C6C\65BC\9801\9762\968E\5C64, \8ACB\9078\53D6\7236\9805\9801\9762.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(458468714942046990.4907)
,p_name=>'P200_PAGE_ALIAS'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(1198430386542478.4907)
,p_prompt=>unistr('\9801\9762\5225\540D')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\6307\5B9A\9801\9762\5225\540D. \60A8\53EF\4EE5\4F7F\7528\6B64\9801\9762\5225\540D\9023\7D50\81F3\6B64\9801\9762.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458480527802429176.4907)
,p_validation_name=>'P200_PAGE_ALIAS must be unique'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P200_PAGE_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_alias        => :P200_PAGE_ALIAS,',
'    p_alias_type   => ''PAGE'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\9801\9762\5225\540D\5DF2\7D93\5B58\5728.  \8ACB\8F38\5165\5176\4ED6\5225\540D.')
,p_when_button_pressed=>wwv_flow_api.id(154880603784674338.4907)
,p_associated_item=>wwv_flow_api.id(458468714942046990.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(513405225400857985.4907)
,p_validation_name=>'P200_PAGE_ALIAS is valid'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P200_PAGE_ALIAS is not null and not wwv_flow_ws_api.is_alphanumeric (p_str => :P200_PAGE_ALIAS) then',
'    return wwv_flow_lang.system_message(''WS_ALIAS_NOT_VALID'');',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\932F\8AA4')
,p_when_button_pressed=>wwv_flow_api.id(154880603784674338.4907)
,p_associated_item=>wwv_flow_api.id(458468714942046990.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(173742624666383777.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ceate page'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_webpage_id number := null;',
'begin',
'    l_webpage_id := wwv_flow_id.next_val;',
'    ',
'    wwv_flow_ws_api.create_webpage (',
'        p_webpage_id      => l_webpage_id,',
'        p_ws_app_id       => :WS_APP_ID,',
'        p_name            => :P200_NAME,',
'        p_page_alias      => :P200_PAGE_ALIAS,',
'        p_description     => null,',
'        p_parent_page_id  => replace(:P200_PARENT_PAGE,''%''||''null%'')',
'        );',
'        ',
'    :P900_ID := l_webpage_id;',
'end;'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\9801\9762.')
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\9801\9762.')
);
end;
/
prompt --application/pages/page_00201
begin
wwv_flow_api.create_page(
 p_id=>201.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_step_title=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function addTableRow2(pThis,pThat,pNum){',
'    //console.log(pThat);',
'    var tt = html_GetElement(pThat);',
'        tt = tt.getElementsByTagName("tbody")[0];',
'    var l_newRows = new Array();',
'    for(i=0;i<pNum;i++){',
'      var ogTR = tt.rows[tt.rows.length -1];',
'      var trClone = ogTR.cloneNode(true);',
'      if(document.all){',
'        myNewRow = tt.insertRow(tt.rows.length);',
'        oReplace = myNewRow.replaceNode(trClone);',
'      }else{',
'        tt.appendChild(trClone);',
'      }',
'      l_newRows[l_newRows.length] = trClone;',
'      ',
'      var tSelects = trClone.getElementsByTagName(''select'');',
'      for(var iSelects=0;iSelects<tSelects.length;iSelects++){',
'          tSelects[iSelects].selectedIndex = 0;',
'          tSelects[iSelects].disabled="";',
'       }',
'      var tInputs = trClone.getElementsByTagName(''input'');',
'      for(var iInputs=0;iInputs<tInputs.length;iInputs++){',
'        if(tInputs[iInputs].type=="text"){',
'        tInputs[iInputs].value="";',
'        tInputs[iInputs].disabled="";',
'        }',
'      }',
'    }',
'    return l_newRows;',
'}',
'',
'/*Add table row for add column*/',
'function ob_TableAddColumn(pThis,pThat,pNum){     ',
'  var newRows = addTableRow2(pThis,pThat,pNum);',
'  for (var i = 0;i<newRows.length;i++){',
'    var l_Inputs = newRows[i].getElementsByTagName(''input'');',
'    html_HiddenElement(l_Inputs[1]);',
'    html_HiddenElement(l_Inputs[2]);',
'  }',
'}',
'',
'var gLastRowMovedColor = ''#FFF'';'))
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20777514043457891.4907)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21434717060303392.4907)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29893532414751568.4907)
,p_plug_name=>'create page progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(85200421058598337.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(161567019228946315.4907)
,p_plug_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'wwv_flow_ws_ui.p201_define_data_grid_columns;'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_column_width=>'valign=top'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(161624313556285232.4907)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(161567019228946315.4907)
,p_button_name=>'ADD_COLUMN'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(20480423759330923.4907)
,p_button_image_alt=>unistr('\65B0\589E\8CC7\6599\6B04')
,p_button_position=>'BOTTOM'
,p_button_redirect_url=>'javascript:ob_TableAddColumn(this,''htmldbNewTable'',1);'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154889406934794672.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20777514043457891.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(154889228692794671.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(20777514043457891.4907)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_button_condition=>'P201_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3021502937237873.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20777514043457891.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(459284513339156315.4907)
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:201:WS_APP_ID,P2_ID,P2_WEBSHEET_ID:&WS_APP_ID.,&P201_WORKSHEET_ID.,&P201_WEBSHEET_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(154889228692794671.4907)
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2691129726790817.4907)
,p_name=>'P201_PAGE_ID'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4907)
,p_use_cache_before_default=>'NO'
,p_item_default=>'2'
,p_prompt=>'Page ID'
,p_source=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154889802826794677.4907)
,p_name=>'P201_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154890025030794679.4907)
,p_name=>'P201_FLOW_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4907)
,p_source=>'APP_ID'
,p_source_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(154890421381794680.4907)
,p_name=>'P201_NAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(161567019228946315.4907)
,p_prompt=>unistr('\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_cHeight=>1
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8F38\5165\8CC7\6599\65B9\683C\540D\7A31.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(161620030694252400.4907)
,p_name=>'P201_COL_ORDER'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(161745022194836488.4907)
,p_name=>'P201_NEW_WORKSHEET_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(458477720127322928.4907)
,p_name=>'P201_ALIAS'
,p_item_sequence=>35
,p_item_plug_id=>wwv_flow_api.id(161567019228946315.4907)
,p_prompt=>unistr('\5225\540D')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8F38\5165\8CC7\6599\65B9\683C\5225\540D. \60A8\53EF\4EE5\4F7F\7528\6B64\5225\540D\9023\7D50\81F3\9801\9762\5340\6BB5\5167\7684\9019\500B\8CC7\6599\65B9\683C. \8CC7\6599\65B9\683C\5225\540D\5728\61C9\7528\7A0B\5F0F\5167\5FC5\9808\662F\552F\4E00\7684.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459283706282144844.4907)
,p_name=>'P201_WORKSHEET_ID'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459283912425144845.4907)
,p_name=>'P201_WEBSHEET_ID'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(21434717060303392.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(154890305337794680.4907)
,p_validation_name=>'P201_FLOW_ID not null'
,p_validation_sequence=>10
,p_validation=>'P201_FLOW_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\8F38\5165\300C\6D41\7A0B ID\300D\503C.')
,p_associated_item=>wwv_flow_api.id(154890025030794679.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(154890725984794680.4907)
,p_validation_name=>'P201_NAME not null'
,p_validation_sequence=>20
,p_validation=>'P201_NAME'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\540D\7A31.')
,p_associated_item=>wwv_flow_api.id(154890421381794680.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(8647014897469438.4907)
,p_validation_name=>'column must be defined'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for i in 1..wwv_flow.g_f01.count',
'loop',
'  if wwv_flow.g_f01(i) is null then',
'    if i = 1 then',
'      return false;',
'    end if;',
'  end if;',
'end loop;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5FC5\9808\5B9A\7FA9 Web \8A66\7B97\8868\8CC7\6599\6B04.')
,p_when_button_pressed=>wwv_flow_api.id(154889228692794671.4907)
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458488820108521527.4907)
,p_validation_name=>'P201_ALIAS must be unique'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P201_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_alias        => :P201_ALIAS,',
'    p_alias_type   => ''DATA_GRID'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5225\540D\5DF2\7D93\5B58\5728.  \8ACB\8F38\5165\5176\4ED6\5225\540D.')
,p_associated_item=>wwv_flow_api.id(458477720127322928.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(660056428068767360.4907)
,p_validation_name=>'P201_NAME must be unique'
,p_validation_sequence=>60
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P201_NAME is not null then',
'  if wwv_flow_ws_api.websheet_name_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_name         => :P201_NAME,',
'    p_type         => ''DATA'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\300C\8CC7\6599\65B9\683C\300D\540D\7A31\5DF2\7D93\5B58\5728.  \8ACB\8F38\5165\5176\4ED6\540D\7A31.')
,p_associated_item=>wwv_flow_api.id(154890421381794680.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(865527713121965593.4907)
,p_validation_name=>'duplicate column name found'
,p_validation_sequence=>70
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_ws_api.duplicate_found_in_array (    ',
'    p_array => wwv_flow.g_f01) then',
'  return false;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\767C\73FE\91CD\8907\7684\8CC7\6599\6B04\540D\7A31.  \8CC7\6599\6B04\540D\7A31\5FC5\9808\662F\552F\4E00\7684.')
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(506158920514422820.4907)
,p_validation_name=>'P201_ALIAS is valid'
,p_validation_sequence=>80
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P201_ALIAS is not null and not wwv_flow_ws_api.is_alphanumeric (p_str => :P201_ALIAS) then',
'    return wwv_flow_lang.system_message(''WS_ALIAS_NOT_VALID'');',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\932F\8AA4')
,p_associated_item=>wwv_flow_api.id(458477720127322928.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(169327811698892928.4907)
,p_process_sequence=>20
,p_process_point=>'AFTER_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set name'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'  r varchar2(255) := null;',
'  c pls_integer;',
'begin',
'for i in 1..12 loop',
'select  count(*) into c',
'from  wwv_flow_ws_websheet_attr w',
'where security_group_id = :flow_security_group_id and',
'websheet_name = upper(:app_user)||'' 0''||i;',
'if c = 0 then',
'   r := upper(:app_user)||'' 0''||i;',
'   exit;',
'end if;',
'end loop;',
':P201_NAME := r;',
'end;'))
,p_process_when=>'P201_NAME'
,p_process_when_type=>'ITEM_IS_NULL'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(161740023102827299.4907)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Data Grid'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_data_grid_from_scratch (',
'    p_ws_app_id     => :WS_APP_ID,',
'    p_name          => :P201_NAME,',
'    p_alias         => :P201_ALIAS,',
'    p_column_order  => :P201_COL_ORDER,',
'    p_worksheet_id  => :P201_WORKSHEET_ID,',
'    p_websheet_id   => :P201_WEBSHEET_ID',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\300C\8CC7\6599\65B9\683C\300D.')
,p_process_when_button_id=>wwv_flow_api.id(154889228692794671.4907)
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\300C\8CC7\6599\65B9\683C\300D.')
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(23550931764462326.4907)
,p_process_sequence=>50
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'save user input in collection'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_collection.create_or_truncate_collection(p_collection_name => ''WS_WIZ_COLUMNS'');',
'    ',
'wwv_flow_collection.add_members (',
'   p_collection_name => ''WS_WIZ_COLUMNS'',',
'   p_c001            => wwv_flow.g_f01,',
'   p_c002            => wwv_flow.g_f02);'))
,p_process_error_message=>unistr('\7121\6CD5\5132\5B58\4F7F\7528\8005\8F38\5165.')
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_api.id(154889228692794671.4907)
);
end;
/
prompt --application/pages/page_00205
begin
wwv_flow_api.create_page(
 p_id=>205.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_step_title=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2981808413059759.4907)
,p_plug_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\300C\8CC7\6599\65B9\683C\300D\4E3B\8981\7BA1\7406\60A8\61C9\7528\7A0B\5F0F\6240\4F7F\7528\7684\8CC7\6599.  \8ACB\9078\64C7\5EFA\7ACB\8CC7\6599\65B9\683C\7684\65B9\5F0F.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20775629580434005.4907)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29886309287650228.4907)
,p_plug_name=>'create page progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(85198200626592456.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157356222063249657.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20775629580434005.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157356622290249657.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(20775629580434005.4907)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4907)
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157356416282249657.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20775629580434005.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:131:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157369302417300714.4907)
,p_branch_action=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.:201,WS_WIZ_COLUMNS::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P205_CREATE'
,p_branch_condition_text=>'SCRATCH'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(157374926444317137.4907)
,p_branch_action=>'f?p=&APP_ID.:206:&SESSION.::&DEBUG.:206,CLOB_CONTENT::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'P205_CREATE'
,p_branch_condition_text=>'CUTANDPASTE'
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2962827104989463.4907)
,p_name=>'P205_CREATE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2981808413059759.4907)
,p_item_default=>'SCRATCH'
,p_source=>'SCRATCH'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CREATE WORKSHEET OPTIONS'
,p_lov=>'.'||wwv_flow_api.id(2960208403984068.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'ABOVE'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'4'
,p_attribute_02=>'NONE'
);
end;
/
prompt --application/pages/page_00206
begin
wwv_flow_api.create_page(
 p_id=>206.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_step_title=>unistr('\5EFA\7ACB\8CC7\6599\65B9\683C')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(157592926751064610)
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(20782013444514508.4907)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21432216236293657.4907)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29895108135791796.4907)
,p_plug_name=>'create websheet progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(29874807106517169.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(87067600442889007.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(157402130664498141.4907)
,p_plug_name=>unistr('\4E0A\50B3\8A66\7B97\8868')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>unistr('<p>\5728\4E0B\65B9\8CBC\4E0A\8A66\7B97\8868\6216\5176\4ED6\4EE5 Tab \5340\9694\7684\8CC7\6599.</p>')
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157412930927517115.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(20782013444514508.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(157412021923514509.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(20782013444514508.4907)
,p_button_name=>'UPLOAD'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15108012910840408.4907)
,p_button_image_alt=>unistr('\4E0A\50B3')
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(3019823238234313.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(20782013444514508.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(188356618124649439.4907)
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::WS_APP_ID,P2_ID,P2_WEBSHEET_ID:&WS_APP_ID.,&P206_WORKSHEET_ID.,&P206_WEBSHEET_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_save_state_before_branch_yn=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(157415007986529400.4907)
,p_name=>'P206_WORKSHEET_NAME'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4907)
,p_prompt=>unistr('\540D\7A31')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_cattributes_element=>'width="100%"'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8F38\5165\8CC7\6599\65B9\683C\540D\7A31. ')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(161542600584694900.4907)
,p_name=>'P206_COLUMN_HEADINGS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4907)
,p_item_default=>'Y'
,p_source=>'Y'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_CHECKBOX'
,p_named_lov=>'FIRST_ROW_CONTAINS_COLUMN_HEADINGS'
,p_lov=>'.'||wwv_flow_api.id(799517811838484369.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'1'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(162619632484627537.4907)
,p_name=>'P206_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(21432216236293657.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(399301229989054252.4907)
,p_name=>'P206_SPREADSHEET'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4907)
,p_prompt=>unistr('\8CBC\4E0A\8A66\7B97\8868\8CC7\6599')
,p_display_as=>'PLUGIN_COM.ORACLE.APEX.CLOB_TEXTAREA'
,p_cSize=>70
,p_cMaxlength=>4000
,p_cHeight=>15
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'spellcheck="false"'
,p_label_alignment=>'LEFT-TOP'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8907\88FD\4E26\8CBC\4E0A\8981\5F9E\8A66\7B97\8868\7A0B\5F0F\8F09\5165\7684\8CC7\6599.')
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(458479616018350127.4907)
,p_name=>'P206_WORKSHEET_ALIAS'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(157402130664498141.4907)
,p_prompt=>unistr('\5225\540D')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_help_text=>unistr('\8F38\5165\8CC7\6599\65B9\683C\5225\540D. \60A8\53EF\4EE5\4F7F\7528\6B64\5225\540D\9023\7D50\81F3\9801\9762\5340\6BB5\5167\7684\9019\500B\8CC7\6599\65B9\683C. \8CC7\6599\65B9\683C\5225\540D\5728\61C9\7528\7A0B\5F0F\5167\5FC5\9808\662F\552F\4E00\7684.')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459294712047212712.4907)
,p_name=>'P206_WORKSHEET_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(21432216236293657.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(459294929831212712.4907)
,p_name=>'P206_WEBSHEET_ID'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(21432216236293657.4907)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(458491521409540890.4907)
,p_validation_name=>'P206_WORKSHEET_ALIAS must be unique'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P206_WORKSHEET_ALIAS is not null then',
'  if wwv_flow_ws_api.alias_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_alias        => :P206_WORKSHEET_ALIAS,',
'    p_alias_type   => ''DATA_GRID'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5225\540D\5DF2\7D93\5B58\5728.  \8ACB\8F38\5165\5176\4ED6\5225\540D.')
,p_associated_item=>wwv_flow_api.id(458479616018350127.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(459413421772442554.4907)
,p_validation_name=>'P206_SPREADSHEET not null'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_clob clob;',
'begin',
'  l_clob := wwv_flow_utilities.get_clob_textarea_value(p_item_name => ''P206_SPREADSHEET'');',
'',
'  if (nvl(sys.dbms_lob.getlength(l_clob),0) = 0) then',
'      return false;',
'  end if;',
'',
'  return true;',
'end;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\5FC5\9808\63D0\4F9B\8CC7\6599.')
,p_associated_item=>wwv_flow_api.id(399301229989054252.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(660376512709829107.4907)
,p_validation_name=>'P206_WORKSHEET_NAME must be unique'
,p_validation_sequence=>40
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P206_WORKSHEET_NAME is not null then',
'  if wwv_flow_ws_api.websheet_name_exists (',
'    p_ws_app_id    => :ws_app_id,',
'    p_name         => :P206_WORKSHEET_NAME,',
'    p_type         => ''DATA'') then',
'    return false;',
'  end if;',
'end if;',
'return true;'))
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>unistr('\300C\8CC7\6599\65B9\683C\300D\540D\7A31\5DF2\7D93\5B58\5728.  \8ACB\8F38\5165\5176\4ED6\540D\7A31.')
,p_associated_item=>wwv_flow_api.id(157415007986529400.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(506662505047599536.4907)
,p_validation_name=>'P206_WORKSHEET_ALIAS is valid'
,p_validation_sequence=>50
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P206_WORKSHEET_ALIAS is not null and not wwv_flow_ws_api.is_alphanumeric (p_str => :P206_WORKSHEET_ALIAS) then',
'    return wwv_flow_lang.system_message(''WS_ALIAS_NOT_VALID'');',
'end if;'))
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_error_message=>unistr('\932F\8AA4')
,p_associated_item=>wwv_flow_api.id(458479616018350127.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(159446328406626838.4907)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'create data grid'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_api.create_data_grid_from_cp_paste (',
'    p_app_id            => :APP_ID,',
'    p_ws_app_id         => :WS_APP_ID,',
'    p_name              => :P206_WORKSHEET_NAME,',
'    p_alias             => :P206_WORKSHEET_ALIAS,',
'    p_headings_included => :P206_COLUMN_HEADINGS,',
'    p_collection_name   => ''P206_SPREADSHEET'',',
'    p_worksheet_id      => :P206_WORKSHEET_ID,',
'    p_websheet_id       => :P206_WEBSHEET_ID',
'    );'))
,p_process_error_message=>unistr('\7121\6CD5\5EFA\7ACB\300C\8CC7\6599\65B9\683C\300D.')
,p_process_when_button_id=>wwv_flow_api.id(157412021923514509.4907)
,p_process_success_message=>unistr('\5DF2\5EFA\7ACB\300C\8CC7\6599\65B9\683C\300D.')
);
end;
/
prompt --application/pages/page_00400
begin
wwv_flow_api.create_page(
 p_id=>400.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5100\8868\677F')
,p_step_title=>unistr('\5100\8868\677F')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5510207856754518.4907)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>1
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_menu_id=>wwv_flow_api.id(78897017520604216.4907)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(20175617163709368.4907)
,p_translate_title=>'N'
);
end;
/
prompt --application/pages/page_00605
begin
wwv_flow_api.create_page(
 p_id=>605.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5373\73FE\5F0F\5730\5716')
,p_step_title=>unistr('\5373\73FE\5F0F\5730\5716')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_html_page_onload=>'onload= "javascript:showMap()"'
,p_autocomplete_on_off=>'ON'
,p_html_page_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<script language="Javascript" src="http://jstraub-winsvr:8888/mapviewer/fsmc/jslib/oraclemaps.js"></script>',
'<script language="Javascript">',
'  function showMap()',
'  {	',
'    //var baseURL  = "http://jstraub-winsvr:8888/mapviewer";',
'    var baseURL  = "http://"+document.location.host+"/mapviewer";',
'    var mapCenterLon = -122.45;',
'    var mapCenterLat =  37.6706;',
'    var mapZoom      =  4;  ',
'    var mpoint = MVSdoGeometry.createPoint(mapCenterLon,mapCenterLat,8307);',
'    var mapview = new MVMapView(document.getElementById("map"), baseURL);',
'    mapview.addBaseMapLayer(new MVBaseMap("mvdemo.demo_map")); ',
'    mapview.setCenter(mpoint); ',
'    mapview.setZoomLevel(mapZoom);    ',
'    mapview.display();  			',
'  }',
'</script>'))
,p_step_template=>wwv_flow_api.id(134255203486851095.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_page_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'onload="initMap()" onunload="GUnload()"',
'',
'<script src="http://maps.google.com/maps?file=api&v=2&key=ABQIAAAAwUYWsA4XETWrnH3406u68BSpcm9k_R_VEi8Lh6rUeHFlEJtsBBTWlDwn_t67tfUX-0Tp-Cp28ozM7Q" type="text/javascript"></script>    ',
'<script type="text/javascript">    ',
'//<![CDATA[  ',
'//globals',
'var bounds = new GLatLngBounds();',
'',
'function initMap() {',
'if (GBrowserIsCompatible()) {   ',
'var map = new GMap2(document.getElementById("map"));',
'var title = "&P605_TITLE.";',
'map.addControl(new GSmallMapControl());',
'map.addControl(new GMapTypeControl());',
'var point = new GLatLng(&P605_LAT.,&P605_LNG.);',
'bounds.extend(point);',
'map.setCenter(point);',
'map.setZoom(map.getBoundsZoomLevel(bounds)-4);',
'var marker = new GMarker(point);',
'map.addOverlay(marker);',
'marker.openInfoWindowHtml(''<div class="tiny">'' + title.replace(/~/g,"<br />") + ''</div>'');',
'}',
'}',
'//]]>    ',
'</script>',
'',
'',
'',
'',
'',
''))
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(176064014539794663.4907)
,p_plug_name=>'Map'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>'<div id="map" style="width: 600px; height: 400px"></div>'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176065119041796017.4907)
,p_name=>'P605_LAT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(176064014539794663.4907)
,p_item_default=>'39.961111'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176065923543797264.4907)
,p_name=>'P605_TITLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(176064014539794663.4907)
,p_item_default=>'Oracle Columbus, OH'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(176160602221652009.4907)
,p_name=>'P605_LNG'
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(176064014539794663.4907)
,p_item_default=>'-82.998889'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>2000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
);
end;
/
prompt --application/pages/page_00710
begin
wwv_flow_api.create_page(
 p_id=>710.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_step_title=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'bldapp_chrt_flash.htm'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21404623275153782.4907)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(259451015474899829.4907)
,p_plug_name=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261473724838144583.4907)
,p_plug_name=>'create chart section progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(261469429368022853.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436560332736922985.4907)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,   ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',',
'    p_parent_entry         => wwv_flow_lang.system_message(''WS_CREATE_SECTION''),',
'    p_parent_entry_page_id => 920,',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_CHART_SECTION''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(259451227871899835.4907)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(21404623275153782.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(259451615967899838.4907)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(21404623275153782.4907)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4907)
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(259451427400899837.4907)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(21404623275153782.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:920:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(259453009785899851.4907)
,p_branch_action=>'f?p=&APP_ID.:740:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(259451615967899838.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(259453212836899853.4907)
,p_branch_action=>'f?p=&APP_ID.:710:&SESSION.::&DEBUG.:::'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>99
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(259451800210899839.4907)
,p_name=>'P710_CHART_TYPE'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(259451015474899829.4907)
,p_item_default=>'COLUMN'
,p_prompt=>unistr('\9078\53D6\5716\8868\985E\578B')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'CHART_TYPE'
,p_lov=>'.'||wwv_flow_api.id(259453605523899856.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_label_alignment=>'ABOVE'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\9078\53D6\5716\8868\985E\578B.')
,p_attribute_01=>'4'
,p_attribute_02=>'NONE'
,p_attribute_04=>'VERTICAL'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(259452823947899849.4907)
,p_validation_name=>'P710_DEFAULT_CHART_TYPE'
,p_validation_sequence=>20
,p_validation=>'P710_CHART_TYPE'
,p_validation_type=>'ITEM_NOT_NULL_OR_ZERO'
,p_error_message=>unistr('\5FC5\9808\6307\5B9A\5716\8868\985E\578B.')
,p_validation_condition=>'wwv_flow_flash_chart5.g_chart_engine = ''ANYCHART'''
,p_validation_condition_type=>'PLSQL_EXPRESSION'
,p_when_button_pressed=>wwv_flow_api.id(259451615967899838.4907)
,p_associated_item=>wwv_flow_api.id(.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00740
begin
wwv_flow_api.create_page(
 p_id=>740.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_step_title=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21406523537172813.4907)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21407114664179699.4907)
,p_plug_name=>'hidden items'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261363204569258801.4907)
,p_plug_name=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261474625315154102.4907)
,p_plug_name=>'create chart section progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(261469429368022853.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436560900576942084.4907)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,   ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',',
'    p_parent_entry         => wwv_flow_lang.system_message(''WS_CREATE_SECTION''),',
'    p_parent_entry_page_id => 920,',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_CHART_SECTION''));',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261363407957258804.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(21406523537172813.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261363832524258807.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(21406523537172813.4907)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4907)
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261363630146258806.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(21406523537172813.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:710:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(261364204030258811.4907)
,p_branch_action=>'f?p=&APP_ID.:742:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(261363832524258807.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261364014478258808.4907)
,p_name=>'P740_DATA_GRID_ID'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4907)
,p_item_default=>'DATA_GRID'
,p_prompt=>unistr('\8CC7\6599\65B9\683C')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'DATA GRID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''DATA'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\65B9\683C -')
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\7528\4F86\7522\751F\5716\8868\7684\8CC7\6599\65B9\683C.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261376900027371013.4907)
,p_name=>'P740_DISPLAY_SEQ'
,p_is_required=>true
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4907)
,p_prompt=>unistr('\986F\793A\9806\5E8F')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_ws_api.get_next_webpg_section_seq (    ',
'    p_webpage_id  => :P900_ID);'))
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>6
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8F38\5165\5340\6BB5\986F\793A\9806\5E8F. ')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261377609293392684.4907)
,p_name=>'P740_TITLE'
,p_is_required=>true
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4907)
,p_prompt=>unistr('\5340\6BB5\6A19\984C')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\8F38\5165\5340\6BB5\6A19\984C. ')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(262124824705602180.4907)
,p_name=>'P740_CHART_TYPE'
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4907)
,p_prompt=>unistr('\5716\8868\985E\578B')
,p_source=>'return wwv_flow_item.text_from_lov(:p710_chart_type,''CHART_TYPE'');'
,p_source_type=>'FUNCTION_BODY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'class="display_bold"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\7684\5716\8868\985E\578B. ')
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428683227947684649.4907)
,p_name=>'P740_CHART_SOURCE'
,p_item_sequence=>35
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4907)
,p_item_default=>'DATA_GRID'
,p_prompt=>unistr('\5716\8868\4F86\6E90')
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'SECTION_SOURCE'
,p_lov=>'.'||wwv_flow_api.id(428681322228645128.4907)||'.'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_help_text=>unistr('\9078\53D6\5716\8868\4F86\6E90\985E\578B.')
,p_attribute_01=>'2'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428698306448801460.4907)
,p_name=>'P740_REPORT_ID'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4907)
,p_prompt=>unistr('\5831\8868')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'REPORT'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name, id',
'from wwv_flow_ws_websheet_attr',
'where ws_app_id = :ws_app_id',
'and security_group_id = :flow_security_group_id',
'and websheet_type = ''REPORT'''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\5831\8868 -')
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\5C07\7528\4F86\7522\751F\5716\8868\7684\5831\8868.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428737702957923433.4907)
,p_name=>'P740_WEBSHEET_ID'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(21407114664179699.4907)
,p_prompt=>'Websheet Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(428752405961066251.4907)
,p_name=>'P740_WORKSHEET_ID'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(21407114664179699.4907)
,p_prompt=>'Worksheet Id'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(769439022514908016.4907)
,p_name=>'P740_SAVED_REPORT_ID'
,p_is_required=>true
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(261363204569258801.4907)
,p_prompt=>unistr('\8981\4F7F\7528\7684\5831\8868\8A2D\5B9A\503C')
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id r',
'from wwv_flow_worksheet_rpts',
'where worksheet_id = :P740_WORKSHEET_ID',
'and application_user = ''APXWS_DEFAULT''',
'and is_default = ''Y''                    ',
'and (security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and session_id is null'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P740_SAVED_REPORTS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select x.d, x.r',
'from (select case when r.application_user = ''APXWS_DEFAULT'' then',
'            m.primary_rpt||'' (''||m.primary||'')''',
'        when r.application_user = ''APXWS_ALTERNATIVE'' then',
'            r.name||'' (''||m.alternative||'')''',
'        end d,',
'        r.id r,',
'        case when r.application_user = ''APXWS_DEFAULT'' then 1',
'            when r.application_user = ''APXWS_ALTERNATIVE'' then 2',
'        end seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY_REPORT'') primary_rpt,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.PRIMARY.DEFAULT'') primary,',
'      wwv_flow_lang.system_message(''SAVED_REPORTS.ALTERNATIVE.DEFAULT'') alternative',
'      from dual) m       ',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.application_user in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.is_default = ''Y''                    ',
'and (r.security_group_id = :flow_security_group_id or :flow_security_group_id = 10)',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')',
'union all',
'select r.name||'' (''||m.pub||'')'' d, r.id r, 3 seq',
'from wwv_flow_worksheet_rpts r,',
'     (select wwv_flow_lang.system_message(''SAVED_REPORTS.PUBLIC'') pub from dual) m',
'where r.worksheet_id = :P740_WORKSHEET_ID',
'and security_group_id = :WORKSPACE_ID',
'and r.status = ''PUBLIC''',
'and r.application_user not in (''APXWS_DEFAULT'',''APXWS_ALTERNATIVE'')',
'and r.security_group_id = :flow_security_group_id',
'and r.session_id is null',
'and nvl(r.report_type,''REPORT'') not in (''NOTIFICATION'',''APX_WS_DATA'')) x',
'order by x.seq, x.r'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\5831\8868 -')
,p_lov_cascade_parent_items=>'P740_WORKSHEET_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\66FF\6240\9078\7684\8CC7\6599\65B9\683C\6216\5831\8868\9078\53D6\8981\4F7F\7528\7684\5831\8868\8A2D\5B9A\503C. \9019\53EF\8B93\60A8\7BE9\9078\60F3\8981\986F\793A\7684\8CC7\6599\5217\8207\8CC7\6599\6B04. \5982\679C\60A8\6C92\6709\4F7F\7528\9700\8981\4E4B\8A2D\5B9A\503C\7684\9810\5B58\5831\8868, \8ACB\7ACB\5373\5EFA\7ACB, \7136\5F8C\518D\65B0\589E\5340\6BB5.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(770955330628071177.4907)
,p_name=>'P740_REPORT_COLUMNS'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(21407114664179699.4907)
,p_prompt=>'Report Columns'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>5
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(428745016378946272.4907)
,p_computation_sequence=>10
,p_computation_item=>'P740_WEBSHEET_ID'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P740_CHART_SOURCE = ''DATA_GRID'' then',
'  return :P740_DATA_GRID_ID;',
'elsif :P740_CHART_SOURCE = ''REPORT'' then',
'  return :P740_REPORT_ID;',
'end if;',
'  '))
,p_compute_when=>'replace(:P740_DATA_GRID_ID,''%''||''null%'') is not null or replace(:P740_REPORT_ID,''%''||''null%'') is not null'
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(428753515573087899.4907)
,p_computation_sequence=>20
,p_computation_item=>'P740_WORKSHEET_ID'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P740_CHART_SOURCE = ''DATA_GRID'' then',
'  for c1 in (select w.id',
'             from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id',
'             and w.security_group_id = :flow_security_group_id',
'             and a.id = :P740_DATA_GRID_ID)',
'  loop',
'    return c1.id;',
'  end loop;',
'elsif :P740_CHART_SOURCE = ''REPORT'' then',
'  for c1 in (select w.id',
'             from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'             where w.id = a.worksheet_id',
'             and w.security_group_id = :flow_security_group_id',
'             and a.id = :P740_REPORT_ID)',
'  loop',
'    return c1.id;',
'  end loop;',
'end if;'))
,p_compute_when=>'replace(:P740_DATA_GRID_ID,''%''||''null%'') is not null or replace(:P740_REPORT_ID,''%''||''null%'') is not null'
,p_compute_when_type=>'PLSQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(770974802016072332.4907)
,p_computation_sequence=>20
,p_computation_item=>'P740_REPORT_COLUMNS'
,p_computation_type=>'FUNCTION_BODY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select report_columns',
'           from wwv_flow_worksheet_rpts',
'           where worksheet_id = :p740_worksheet_id',
'           and security_group_id = :flow_security_group_id',
'           and id = :p740_saved_report_id',
'           and session_id is null)',
'loop',
'  return c1.report_columns;',
'end loop;'))
,p_compute_when=>'P740_SAVED_REPORT_ID'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(428748111839992173.4907)
,p_validation_name=>'P740_DATA_GRID_ID not null'
,p_validation_sequence=>10
,p_validation=>'P740_DATA_GRID_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\8F38\5165 #LABEL# \503C.')
,p_validation_condition=>'P740_CHART_SOURCE'
,p_validation_condition2=>'DATA_GRID'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_api.id(261363832524258807.4907)
,p_associated_item=>wwv_flow_api.id(261364014478258808.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(428748522574995338.4907)
,p_validation_name=>'P740_REPORT_ID not null'
,p_validation_sequence=>20
,p_validation=>'P740_REPORT_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>unistr('\5FC5\9808\8F38\5165 #LABEL# \503C.')
,p_validation_condition=>'P740_CHART_SOURCE'
,p_validation_condition2=>'REPORT'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_api.id(261363832524258807.4907)
,p_associated_item=>wwv_flow_api.id(428698306448801460.4907)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(261382623585453517.4907)
,p_name=>'get data grid title'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_DATA_GRID_ID'
,p_condition_element=>'P740_DATA_GRID_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
,p_display_when_cond=>'P740_DATA_GRID_ID'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(261382912222453521.4907)
,p_event_id=>wwv_flow_api.id(261382623585453517.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_TITLE'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name',
'from wwv_flow_ws_websheet_attr',
'where id = :P740_DATA_GRID_ID',
'and security_group_id = :flow_security_group_id'))
,p_attribute_07=>'P740_DATA_GRID_ID'
,p_attribute_08=>'N'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(428701929781817609.4907)
,p_name=>'show hide data grid'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_CHART_SOURCE'
,p_condition_element=>'P740_CHART_SOURCE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'DATA_GRID'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428702204856817609.4907)
,p_event_id=>wwv_flow_api.id(428701929781817609.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_DATA_GRID_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428702431656817610.4907)
,p_event_id=>wwv_flow_api.id(428701929781817609.4907)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_DATA_GRID_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(428711509527849597.4907)
,p_name=>'show hide report'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_CHART_SOURCE'
,p_condition_element=>'P740_CHART_SOURCE'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'REPORT'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428711801380849598.4907)
,p_event_id=>wwv_flow_api.id(428711509527849597.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_REPORT_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428712030847849598.4907)
,p_event_id=>wwv_flow_api.id(428711509527849597.4907)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_REPORT_ID'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(428715908189877604.4907)
,p_name=>'get report title'
,p_event_sequence=>40
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_REPORT_ID'
,p_condition_element=>'P740_REPORT_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(428716206531877605.4907)
,p_event_id=>wwv_flow_api.id(428715908189877604.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_TITLE'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select websheet_name',
'from wwv_flow_ws_websheet_attr',
'where id = :P740_REPORT_ID',
'and security_group_id = :flow_security_group_id'))
,p_attribute_07=>'P740_REPORT_ID'
,p_attribute_08=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(769744919097935359.4907)
,p_name=>'reset data grid, report id, saved report id to null if source changes'
,p_event_sequence=>50
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_CHART_SOURCE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(769745208133935360.4907)
,p_event_id=>wwv_flow_api.id(769744919097935359.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_REPORT_ID,P740_DATA_GRID_ID,P740_SAVED_REPORT_ID'
,p_attribute_01=>'STATIC_ASSIGNMENT'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(769836400313948837.4907)
,p_name=>'set data grid worksheet and websheet id'
,p_event_sequence=>60
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_DATA_GRID_ID'
,p_condition_element=>'P740_DATA_GRID_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(769836711787948837.4907)
,p_event_id=>wwv_flow_api.id(769836400313948837.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WORKSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_DATA_GRID_ID'))
,p_attribute_07=>'P740_DATA_GRID_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(770006016720963068.4907)
,p_event_id=>wwv_flow_api.id(769836400313948837.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WEBSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_DATA_GRID_ID'))
,p_attribute_07=>'P740_DATA_GRID_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(770182331742976872.4907)
,p_name=>'set report worksheet and websheet id'
,p_event_sequence=>70
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P740_REPORT_ID'
,p_condition_element=>'P740_REPORT_ID'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(770182616938976872.4907)
,p_event_id=>wwv_flow_api.id(770182331742976872.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WORKSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select w.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_REPORT_ID'))
,p_attribute_07=>'P740_REPORT_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(770266430488985958.4907)
,p_event_id=>wwv_flow_api.id(770182331742976872.4907)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P740_WEBSHEET_ID'
,p_attribute_01=>'SQL_STATEMENT'
,p_attribute_03=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.id',
'from wwv_flow_worksheets w, wwv_flow_ws_websheet_attr a',
'where w.id = a.worksheet_id',
'and w.security_group_id = :flow_security_group_id',
'and a.id = :P740_REPORT_ID'))
,p_attribute_07=>'P740_REPORT_ID'
,p_attribute_08=>'Y'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
end;
/
prompt --application/pages/page_00742
begin
wwv_flow_api.create_page(
 p_id=>742.4907
,p_user_interface_id=>wwv_flow_api.id(4968616267302342.4907)
,p_name=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_step_title=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(10606007362285088.4907)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(21413916573218059.4907)
,p_plug_name=>'Toolbar Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(10604720260269861.4907)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_translate_title=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261388504493521133.4907)
,p_plug_name=>unistr('\5EFA\7ACB\5716\8868\5340\6BB5')
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_template=>wwv_flow_api.id(20185117556737935.4907)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(261474829471155310.4907)
,p_plug_name=>'create chart section progress bar'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_api.id(261469429368022853.4907)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1338174060370978758.4907)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(436561331051950914.4907)
,p_plug_name=>'Custom Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_escape_on_http_output=>'Y'
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_ws_ui.show_breadcrumbs (',
'    p_ws_app_id            => :WS_APP_ID,   ',
'    p_app_session          => :APP_SESSION,',
'    p_page_id              => :P900_ID,',
'    p_image_prefix         => ''#IMAGE_PREFIX#'',',
'    p_parent_entry         => wwv_flow_lang.system_message(''WS_CREATE_SECTION''),',
'    p_parent_entry_page_id => 920,',
'    p_current_entry        => wwv_flow_lang.system_message(''WS_CREATE_CHART_SECTION''));'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261388704242521195.4907)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(21413916573218059.4907)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(15106902867837483.4907)
,p_button_image_alt=>unistr('\53D6\6D88')
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4900_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261389116845521196.4907)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(21413916573218059.4907)
,p_button_name=>'NEXT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(10604003722246228.4907)
,p_button_image_alt=>unistr('\4E0B\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(261388900323521196.4907)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(21413916573218059.4907)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(61282809984809202.4907)
,p_button_image_alt=>unistr('\4E0A\4E00\6B65')
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:740:&SESSION.::&DEBUG.:::'
);
wwv_flow_api.create_page_branch(
 p_id=>wwv_flow_api.id(261390303188521203.4907)
,p_branch_action=>'f?p=&APP_ID.:750:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_api.id(261389116845521196.4907)
,p_branch_sequence=>10
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261393406410533693.4907)
,p_name=>'P742_CHART_LABEL'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_prompt=>unistr('\5716\8868\6A19\7C64')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P742_DATA_GRID_COLUMNS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 -')
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461206197401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\8981\7576\4F5C\6A19\7C64\7684\8CC7\6599\6B04.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261396115891545900.4907)
,p_name=>'P742_LABEL_TITLE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_prompt=>unistr('\6A19\7C64\7684\5EA7\6A19\8EF8\6A19\984C')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8F38\5165\5EA7\6A19\8EF8\4E0A\6240\8981\986F\793A\7684\6A19\984C (\8207\9078\53D6\4F5C\70BA\300C\6A19\7C64\300D\7684\8CC7\6599\6B04\95DC\806F).')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261396329051549767.4907)
,p_name=>'P742_CHART_VALUE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_prompt=>unistr('\5716\8868\503C')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'P742_DATA_GRID_NUM_COLS'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'from (',
'select c.column_label d, c.db_column_name r',
'from wwv_flow_worksheet_columns c, wwv_flow_ws_websheet_attr d',
'where c.worksheet_id = d.worksheet_id',
'and d.ws_app_id = :WS_APP_ID',
'and d.id = :P740_WEBSHEET_ID',
'and c.column_type = ''NUMBER''',
'and d.security_group_id = :flow_security_group_id',
'union',
'select ''**''||column_label d, db_column_name r',
'from wwv_flow_worksheet_computation',
'where report_id = :P740_SAVED_REPORT_ID',
'and worksheet_id = :P740_WORKSHEET_ID',
'and websheet_id = :P740_WEBSHEET_ID',
'and column_type = ''NUMBER''',
'and security_group_id = :flow_security_group_id)',
'where instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'') > 0',
'order by instr('':''||:P740_REPORT_COLUMNS||'':'', '':''||r||'':'')'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\8CC7\6599\6B04 -')
,p_lov_null_value=>'%null%'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\8981\7576\4F5C\300C\503C\300D\7684\8CC7\6599\6B04. \82E5\51FD\6578\662F COUNT, \5247\4E0D\9700\8981\9078\53D6\300C\503C\300D.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261396504940552265.4907)
,p_name=>'P742_VALUE_TITLE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_prompt=>unistr('\503C\7684\5EA7\6A19\8EF8\6A19\984C')
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>unistr('\8F38\5165\5EA7\6A19\8EF8\4E0A\6240\8981\986F\793A\7684\6A19\984C (\8207\9078\53D6\4F5C\70BA\300C\503C\300D\7684\8CC7\6599\6B04\95DC\806F).')
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261398411089572910.4907)
,p_name=>'P742_CHART_FUNCTION'
,p_item_sequence=>65
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_prompt=>unistr('\51FD\6578')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART FUNCTIONS'
,p_lov=>'.'||wwv_flow_api.id(261396928274568408.4907)||'.'
,p_lov_display_null=>'YES'
,p_lov_null_text=>unistr('- \9078\53D6\51FD\6578 -')
,p_lov_null_value=>'%null%'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\8981\65BC\7576\4F5C\300C\503C\300D\4E4B\8CC7\6599\6B04\57F7\884C\7684\51FD\6578.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261398613860573732.4907)
,p_name=>'P742_X'
,p_item_sequence=>45
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_display_as=>'NATIVE_STOP_AND_START_HTML_TABLE'
,p_cSize=>30
,p_cMaxlength=>2000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(261448315339630888.4907)
,p_name=>'P742_CHART_SORT'
,p_item_sequence=>75
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_item_default=>'DEFAULT'
,p_prompt=>unistr('\6392\5E8F')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART SORT'
,p_lov=>'.'||wwv_flow_api.id(261446703779618102.4907)||'.'
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\5716\8868\6392\5E8F\65B9\5411.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(621666736107538434.4907)
,p_name=>'P742_CHART_ORIENTATION'
,p_item_sequence=>85
,p_item_plug_id=>wwv_flow_api.id(261388504493521133.4907)
,p_item_default=>'DEFAULT'
,p_prompt=>unistr('\65B9\5411')
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'CHART_ORIENTATION'
,p_lov=>'.'||wwv_flow_api.id(107038275478210797.4907)||'.'
,p_cHeight=>1
,p_label_alignment=>'RIGHT-CENTER'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when=>'P710_CHART_TYPE'
,p_display_when2=>'pie'
,p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_field_template=>wwv_flow_api.id(11461002620401386.4907)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_help_text=>unistr('\9078\53D6\5716\8868\6392\5E8F\65B9\5411.')
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_validation(
 p_id=>wwv_flow_api.id(622866606496034906.4907)
,p_validation_name=>'P742_CHART_VALUE not null'
,p_validatio