Rem  Copyright (c) Oracle Corporation 2006 - 2019. All Rights Reserved.
Rem
Rem    NAME
Rem      apex_install_data.sql
Rem
Rem    DESCRIPTION
Rem      Insert data into tables during APEX installation
Rem
Rem    MODIFIED     (MM/DD/YYYY)
Rem      jkallman    01/23/2007 - Created (moved insert statements from tab.sql)
Rem      mhichwa     01/29/2007 - 32 by 32 images were flagged as 64 in wwv_flow_standard_icons inserts
Rem      mhichwa     01/29/2007 - Added delete of rows in wwv_flow_standard_icons so this script can be re-run any number of times, also consistent with other loads
Rem      mhichwa     01/31/2007 - Added Additional Images 64 and 32
Rem      jkallman    02/02/2007 - Corrected file extensions for icons
Rem      jkallman    02/06/2007 - Added delete from wwv_flow_charsets
Rem      jkallman    02/09/2007 - Added values to wwv_flow_translatable_cols$ for region print (142 - 144)
Rem      jkallman    02/15/2007 - Remove STEP_SUB_TITLE from wwv_flow_translatable_cols$ (Bug 5885151)
Rem      sbkenned    02/15/2007 - Fixed creation of wwv_flow_standard_icons, change_storage was incorrect (bug 5886020)
Rem      mhichwa     03/02/2007 - Added delete from wwv_flow_standard_css to ensure we do not get duplicate rows bug 5886061
Rem      mhichwa     03/02/2007 - Added delete from wwv_flow_standard_js for consistency.  First delete, then insert. bug 5886061
Rem      jkallman    11/26/2007 - Added worksheet columns to wwv_flow_translatable_cols$
Rem      mhichwa     11/27/2007 - Added additional images developed by msewtz
Rem      mhichwa     12/05/2007 - Added 20x20 images for use with image reporting
Rem      mhichwa     12/06/2007 - Added alarm_bell_wbg_64x64.png
Rem      mhichwa     12/17/2007 - Added standard 140x90 icons
Rem      jkallman    12/18/2007 - Added wwv_flow_worksheets.search_button_label to wwv_flow_translatable_cols$
Rem      mhichwa     12/19/2007 - Added compass_64.gif
Rem      mhichwa     02/01/2008 - Added temperature_bx_128x128.png census_bx_128x128.png
Rem      msewtz      02/02/2008 - Added 9 additional 128x128 images
Rem      msewtz      02/04/2008 - Added 3 additional 128x128 images
Rem      mhichwa     02/20/2008 - Addeded missing users_bx_128x128.png image
Rem      mhichwa     02/20/2008 - Exposed additional artwork
Rem      mhichwa     02/22/2008 - Added 16x16 images in support of theme20 and general use
Rem      jkallman    09/04/2008 - Added translatable columns 156 through 172
Rem      jkallman    09/04/2008 - Added Western European ISO-8859-15 to list of character sets (Bug 7345137)
Rem      jkallman    09/30/2008 - Added UTF-16 LE and BE character sets to wwv_flow_charsets
Rem      jkallman    10/29/2008 - Added translable columns 173 through 223
Rem      jkallman    11/11/2008 - Added translatable columns 224 through 233
Rem      pawolf      03/25/2009 - Added apex essentials config data
Rem      pawolf      04/29/2009 - Added plugin views
Rem      pawolf      05/05/2009 - Added wwv_flow_standard_item_types
Rem      pawolf      05/06/2009 - Added apex_application_plugin_files
Rem      pawolf      05/13/2009 - Added new dictionary views
Rem      pawolf      06/04/2009 - Added columns which shouldnt be searched
Rem      arayner     06/05/2009 - Added standard dynamic action types in wwv_flow_standard_dyn_actions
Rem      arayner     06/10/2009 - Amended wwv_flow_standard_dyn_actions inserts
Rem      arayner     06/24/2009 - Added wwv_flow_standard_dyn_act_opp inserts
Rem      arayner     06/26/2009 - Added new dynamic action dictionary views
Rem      arayner     07/15/2009 - Amended procedures used for wwv_flow_standard_dyn_act_opp inserts
Rem      pawolf      07/24/2009 - Added new columns to wwv_flow_plugins and wwv_flow_plugin_attributes
Rem      pawolf      07/27/2009 - Added wwv_flow_plugin_events
Rem      cbcho       07/30/2009 - Added show_notify to p_lookup_or_lov_columns in apex_application_page_ir
Rem      cbcho       07/30/2009 - Added icon_view_alt_text,icon_view_title_text to translatable column
Rem      arayner     08/17/2009 - Added show_wait column to ignored columns to search for apex_application_page_buttons view in store_dictionary_view procedure
Rem      pawolf      08/18/2009 - Added columns for hierarchical regions
Rem      pawolf      08/26/2009 - Changed Advisor config data
Rem      pawolf      08/28/2009 - Renamed columns_ignored_by_search to lookup_or_lov_columns
Rem      pawolf      08/31/2009 - Added columns to be ignored
Rem      arayner     09/10/2009 - Fixed ID values specified for translatable columns inserts for icon_view_alt_text and icon_view_title_text
Rem      pawolf      09/16/2009 - Added translatable columns for plugin tables
Rem      pawolf      09/17/2009 - Added new apex_application_page_proc view columns
Rem      hfarrell    09/20/2009 - Added wwv_flow_flash_map_folders and wwv_flow_flash_map_files
Rem      arayner     09/22/2009 - Added wwv_flow_standard_events inserts for standard browser events
Rem      pawolf      09/24/2009 - Added view apex_appl_plugin_attr_values, renamed existing plugin views for consistency
Rem      pawolf      09/28/2009 - Added plug-in support for classic reports
Rem      pawolf      09/29/2009 - Removed old HTML editors
Rem      arayner     10/02/2009 - Added new standard action types in wwv_flow_standard_dyn_actions inserts
Rem      arayner     10/05/2009 - Removed new standard action types in wwv_flow_standard_dyn_actions inserts, not required
Rem      arayner     10/05/2009 - Temporarily added data displayed event to wwv_flow_standard_events inserts
Rem      hfarrell    10/06/2009 - Added wwv_flow_flash_map_regions inserts
Rem      pawolf      10/16/2009 - Added conditions to plugin attributes
Rem      pawolf      10/20/2009 - Replaced existing TEXTAREAs by new NATIVE_TEXTAREA
Rem      pawolf      10/23/2009 - Added is_required to wwv_flow_step_items and wwv_flow_region_report_column
Rem      pawolf      10/27/2009 - Added default_error_display_location to wwv_flows
Rem      hfarrell    10/29/2009 - Added additional wwv_flow_flash_map_regions inserts
Rem      hfarrell    11/03/2009 - Updated wwv_flow_flash_map_regions insert statements to resolve PK unique constraint violation
Rem      arayner     11/17/2009 - Removed data displayed event from wwv_flow_standard_events inserts
Rem      mhichwa     11/18/2009 - populate select_lang_name now called wwv_flow_languages.translated_lang_name
Rem      jkallman    11/20/2009 - Encoded translated_lang_name for wwv_flow_languages
Rem      cbcho       11/20/2009 - Added show_save_public,save_public_auth_scheme to p_lookup_or_lov_columns for apex_application_page_ir
Rem      arayner     11/20/2009 - Added default_irr_template to p_lookup_or_lov_columns parameter call for APEX_APPLICATION_THEMES view
Rem      arayner     11/23/2009 - Added event_type to wwv_flow_standard_event inserts
Rem      arayner     11/24/2009 - Renamed data displayed event in wwv_flow_standard_events to After Refresh, also added Before Refresh and both of these for Chart custom events
Rem      arayner     11/24/2009 - Changed refresh standard event names to be all lower case
Rem      pawolf      11/25/2009 -  Added link for IR columns, fixed constraint violation
Rem      hfarrell    12/02/2009 - Resolved unique constraint issue with wwv_flow_flash_map_regions table ID
Rem      hfarrell    12/08/2009 - Changed map centroid data for United States, to resolve inaccurate point position on maps
Rem      arayner     12/11/2009 - Removed inserts to old standard dynamic actions tables, no longer required as this is now handled by wwv_flow_plugins table
Rem      hfarrell    12/15/2009 - Added translatable columns for Flash Chart 5 tables
Rem      hfarrell    12/16/2009 - Change centroid coordinates for Spain in wwv_flow_flash_map_regions, to correct inaccurate positioning of data on world map
Rem      arayner     12/17/2009 - Removed beforeunload from inserts to standard events
Rem      arayner     12/17/2009 - Removed error from inserts to standard events
Rem      hfarrell    12/17/2009 - Added Flash5 views for Advisor
Rem      arayner     12/17/2009 - Commented out some custom events from inserts to standard events, just for EA release
Rem      hfarrell    12/17/2009 - Updated the FLASH_CH, FLASH_S, FLASH5 and FLASH5_S view references for store_dictionary_view to set the PK to REGION_ID and include parent_pk_value in the series url
Rem      hfarrell    12/18/2009 - Updated centroid x and y coordinates for Russia and Fiji in wwv_flow_flash_map_regions, due to inaccurate values from AnyChart data
Rem      pawolf      12/29/2009 - Added "standard_validations" to wwv_flow_step_items and wwv_flow_region_report_column
Rem      pawolf      12/29/2009 - Added new item type "Password"
Rem      pawolf      01/08/2010 - Added new columns to wwv_flow_plugins
Rem      hfarrell    01/13/2010 - Added map reference data for Africa maps to wwv_flow_flash_map_regions
Rem      jstraub     01/13/2010 - Added SOAP_VERSION to APEX_APPLICATION_WEB_SERVICES and REST_ENABLED for APEX_APPLICATION_PAGE_REGIONS
Rem      pawolf      01/13/2010 - Removed item type PICK_DATE
Rem      hfarrell    01/13/2010 - Added remaining Europe map reference data to wwv_flow_flash_map_regions
Rem      pawolf      01/14/2010 - Removed item type Stop and Start HTML Table
Rem      pawolf      01/14/2010 - Removed SHOW_AS_SL_WITH_POPUP
Rem      jkallman    01/14/2010 - Add dl_format and ds_format values to wwv_flow_languages
Rem      pawolf      01/15/2010 - Removed item type Select List
Rem      pawolf      01/18/2010 - Removed item type Popup and Popup Key Lov
Rem      pawolf      01/20/2010 - Added escape_on_http_output to wwv_flow_step_items
Rem      pawolf      01/21/2010 - Removed display as text item type
Rem      cbcho       01/24/2010 - Added show_rows_per_page to p_lookup_or_lov_columns in apex_application_page_ir
Rem      pawolf      01/26/2010 - Added named LOV support for IR columns
Rem      pawolf      01/28/2010 - Removed item type Shuttle
Rem      pawolf      02/02/2010 - Added cascading lov columns to wwv_flow_step_items
Rem      pawolf      02/08/2010 - Removed checkbox, radiogroup and multi selectlist
Rem      pawolf      02/09/2010 - Changed After Refresh and Before Refresh events
Rem      pawolf      02/11/2010 - Added columns button_execute_validations and always_execute
Rem      jkallman    02/16/2010 - Removed CHART_XML entries from wwv_flow_translatable_cols$ (134 and 252)
Rem      pawolf      02/19/2010 - Removed wwv_flow_plugin_attributes.is_stored_in_clob
Rem      hfarrell    02/23/2010 - Added parent_id to wwv_flow_flash_map_files and added folder insert statements for hierarchical map tree
Rem      hfarrell    02/23/2010 - Tidied up new wwv_flow_flash_map_files insert statement to specify required fields:folder_id and projection
Rem      jkallman    03/04/2010 - Added entry into wwv_flow_translatable_cols$ for WWV_FLOW_SECURITY_SCHEMES.ERROR_MESSAGE
Rem      pawolf      03/05/2010 - Removed item type file
Rem      arayner     03/12/2010 - Reworded display names of wwv_flow_standard_events to be more user friendly. Also remove mouseout and mouseover events.
Rem      arayner     03/12/2010 - Added before submit event to standard events
Rem      arayner     03/15/2010 - Modified before submit event text in standard events
Rem      arayner     03/15/2010 - Removed regular submit event from standard events
Rem      pawolf      03/16/2010 - Removed item type "List Manager"
Rem      arayner     03/19/2010 - Added ready event to standard events
Rem      arayner     03/19/2010 - Modified standard event LOAD display name to be RESOURCE LOAD
Rem      hfarrell    03/19/2010 - Added additional inserts for wwv_flow_flash_map_folders table
Rem      arayner     03/24/2010 - Modified standard events, BLUR to be FOCUSOUT and FOCUS to be FOCUSIN
Rem      hfarrell    03/25/2010 - Updated wwv_flow_flash_map_files insert data with icon value
Rem      pawolf      04/02/2010 - Added TABFORM_COLUMN_NOT_EXISTS and fixed associated_item_check
Rem      pawolf      04/06/2010 - Added category to wwv_flow_advisor_checks
Rem      pawolf      04/06/2010 - Added quick pick label columns for translation
Rem      pawolf      04/08/2010 - Updates category for some advisor checks
Rem      cbcho       04/08/2010 - Added show_group_by to p_lookup_or_lov_columns in apex_application_page_ir
Rem      mhichwa     04/09/2010 - added apex 4.0 128x128 images
Rem      pawolf      04/13/2010 - Added merged text, hidden and color picker item types
Rem      pawolf      04/14/2010 - Added stop_execution_on_error to wwv_flow_page_da_actions
Rem      pawolf      04/15/2010 - Changed Advisor check
Rem      arayner     04/16/2010 - Changed inserts into wwv_flow_dictionary_views to reflect column name changes in apex_application_page_da view
Rem      pawolf      04/18/2010 - Added category to wwv_flow_plugins
Rem      pawolf      04/21/2010 - Added attribute_xx fields for dynamic attributes of plug-ins
Rem      arayner     04/23/2010 - Removed SHOW_WAIT value from wwv_flow_dictionary_views insert for APEX_APPLICATION_PAGE_BUTTONS view
Rem      hfarrell    04/23/2010 - Added additional inserts for wwv_flow_flash_map_regions table
Rem      hfarrell    05/12/2010 - Added additional inserts for wwv_flow_flash_map_regions table for the World maps
Rem      mhichwa     05/12/2010 - added 3 12x12 images
Rem      hfarrell    05/12/2010 - Added APEX_APPLICATION_TREE_REGIONS via store_dictionary_view for ability to search for Tree information in application
Rem      pawolf      05/13/2010 - Removed TREE_SELECTED_NODE from lov lookup columns
Rem      mhichwa     05/13/2010 - added two new 128 images, added gif extension to two 128 images missing extension
Rem      hfarrell    05/13/2010 - Renamed apex_application_tree_regions references to apex_application_page_trees
Rem      hfarrell    05/17/2010 - Added additional inserts for wwv_flow_flash_map_regions table for USA sub-region maps
Rem      pawolf      05/17/2010 - Bug  9685192: Added configuration for APEX_APPLICATION_PAGE_IR_COL
Rem      mhichwa     05/17/2010 - added 3 12 by 12 icons in support of bug 9713962
Rem      hfarrell    05/18/2010 - Resolved typo in wwv_flow_flash_map_regions insert for row 5523, was incorrectly using id 5553
Rem      hfarrell    05/18/2010 - Added additional inserts for wwv_flow_flash_map_regions table for USA state maps
Rem      hfarrell    05/18/2010 - Added additional inserts for wwv_flow_flash_map_regions table for USA ZIP code maps
Rem      pawolf      05/27/2010 - Bug 9752940: plug-in global attributes and region plug-in attributes should be translated as well
Rem      mhichwa     05/27/2010 - Added bug_new_64.png image to complement the corresponding 128 image, bug 9758170
Rem      hfarrell    06/09/2010 - Replaced images folder /i/ references with #IMAGE_PREFIX# in map-related insert statements
Rem      hfarrell    06/09/2010 - Removed population of wwv_flow_flash_map_files.icon for map data
Rem      pawolf      06/10/2010 - Bug# 9794824: Use REGION_ID as primary key for APEX_APPLICATION_PAGE_IR
Rem      jkallman    06/23/2010 - Set and reset NLS characters
Rem      pawolf      12/14/2010 - Added attribute_11 - attribute_15 to all tables supporting plug-ins (feature# 572)
Rem      pawolf      01/14/2011 - Added tabular form support for processes and validations (feature# 542)
Rem      pawolf      01/20/2011 - Added column condition_type_code to several views to the Advisor configuration
Rem      pawolf      01/21/2011 - Added columns CURRENT_FOR_PAGES_TYPE_CODE and DISPLAY_CONDITION_TYPE_CODE for APEX_APPLICATION_LIST_ENTRIES and APEX_APPLICATION_PAGE_IR_COL
Rem      cneumuel    02/02/2011 - Added plugin support for authorization (feature #580)
Rem      hfarrell    02/14/2011 - Added list_type and list_type_code to store_dictionary_view call for apex_application_lists
Rem      hfarrell    02/23/2011 - Added list_item_icon_alt_attribute column from table wwv_flow_list_items to list of translatable columns
Rem      arayner     02/23/2011 - Added when_button column to p_lookup_or_lov_columns values in store_dictionary_view call for apex_application_page_da view
Rem      pawolf      03/08/2011 - Added new error display location column to wwv_flow_step_processing and wwv_flow_processing (feature# 544)
Rem      hfarrell    03/10/2011 - Updated map region data for US Country maps 197 and 198, switched the associated .amap files
Rem      msewtz      03/11/2011 - added mobile_page_template column to p_lookup_or_lov_columns values in store_dictionary_view call for apex_application_temp_page
Rem      arayner     03/14/2011 - Added button_action column to p_lookup_or_lov_columns values in store_dictionary_view call for apex_application_page_buttons view (feature #385)
Rem      arayner     03/23/2011 - Added new advisor checks for dynamic action compatible buttons (feature #385)
Rem      arayner     03/28/2011 - Added new advisor checks for dynamic action buttons (BUTTON_DA_INCONSISTENT_REFS) and re-organised previous checks (BUTTON_DA_COMPATIBLE) (feature #385)
Rem      arayner     03/28/2011 - Added button_action_code column to p_lookup_or_lov_columns values in store_dictionary_view call for apex_application_page_buttons view (feature #385)
Rem      arayner     03/31/2011 - Added button_action and button_action_code column to p_lookup_or_lov_columns values in store_dictionary_view call for apex_application_page_items view (feature 385)
Rem      arayner     03/31/2011 - Removed button_action and button_action_code columns in store_dictionary_view call for apex_application_page_items view, not required (feature 385)
Rem      pawolf      04/06/2011 - Added escape_on_http_output to p_lookup_or_lov_columns values for apex_application_page_regions (feature 649)
Rem      pawolf      04/08/2011 - Added "Substitute Attribute Values" (substitute_attributes) to plug-ins (feature 655)
Rem      msewtz      04/08/2011 - added render_form_items_in_table to p_lookup_or_lov_columns values in store_dictionary_view call for apex_application_temp_region (feature 586)
Rem      msewtz      04/08/2011 - added column_field_template and use_as_row_header to p_lookup_or_lov_columns values in store_dictionary_view call for apex_application_page_rpt_cols (feature 586)
Rem      pawolf      04/12/2011 - Added views APEX_APPLICATION_TRANS_DYNAMIC and APEX_APPLICATION_TRANS_REPOS to store_dictionary_view section
Rem      pawolf      04/12/2011 - Added Advisor error REPORT_COLUMN_NOT_EXIST (feature 663)
Rem      pmanirah    22/04/2011 - Added apex_appl_load_* to store_dictionary_view view (feature #545)
Rem      pawolf      05/10/2011 - Added "is hot button" (feature 702)
Rem      cneumuel    05/16/2011 - Added WWV_FLOW_AUTHENTICATIONS to translatable columns (feature #581)
Rem      pawolf      05/19/2011 - Updated apex_application_auth store_dictionary_view configuration (feature #581)
Rem      pmanirah    06/02/2011 - updated apex_appl_load_* to match the changes to the related views (feature #545)
Rem      cneumuel    06/17/2011 - Added browser_cache to p_lookup_or_lov_columns of apex_applications and apex_application_pages (feature #726)
Rem      jkallman    07/02/2011 - Added missing translatable attributes from WWV_FLOW_LIST_ITEMS
Rem      cneumuel    07/07/2011 - Added browser_frame to p_lookup_or_lov_columns of apex_applications (feature #731)
Rem      pawolf      08/05/2011 - Added new column compatibility_mode to wwv_flows (bug# 12835127)
Rem      pmanirah    01/23/2012 - Changed the prameter in one of the store_dictionary_view call (TABLE_ID to LOAD_TABLE_ID) to match the changes made to apex_appl_load_tables view (bug 13614028) and added LOAD_TABLE_ID to the lookups of apex_appl_load_table_rules
Rem      pawolf      02/29/2012 - Added placeholder to wwv_flow_step_items (feature# 837)
Rem      pawolf      03/02/2012 - Added data model changes for several 4.2 features (feature# 778, 826, 819, 817, 816, 815, 823, 767, 825, 828, 829)
Rem      arayner     03/05/2012 - Added insert into wwv_flow_standard_events table for custom event (feature #767)
Rem      pawolf      03/07/2012 - Added new table wwv_flow_theme_styles (feature# 821)
Rem      pawolf      03/08/2012 - Added data model changes for UI type feature (feature# 827)
Rem      arayner     03/12/2012 - Added new jQuery Mobile events to standard events and added UI Type categorisation for all events (feature #769)
Rem      arayner     03/12/2012 - Added missing swiperight to jQuery Mobile events (feature #769)
Rem      hfarrell    03/12/2012 - Updated APEX_APPLICATION_PAGE_FLASH5_S and APEX_APPLICATION_PAGE_FLASH5 to include data model changes for feature #494 and #543
Rem      sathikum    03/15/2012 - Added Agenda view related columns for wwv_flow_cal_templates (feature #812)
Rem      pawolf      03/19/2012 - Changed code to only use new columns in wwv_flow_user_interfaces instead of the old columns in wwv_flow (feature# 827)
Rem      hfarrell    03/20/2012 - Added insert statements to wwv_flow_flash_map_regions for Aria map codes found in Aria data but not in AnyChart map reference
Rem      pawolf      03/28/2012 - Added 10 more custom plug-in attributes to regions (feature# 890)
Rem      hfarrell    03/29/2012 - Added build_option to APEX_APPLICATION_PAGE_FLASH5_S (feature #494)
Rem      pawolf      03/30/2012 - Added new table wwv_flow_plugin_settings (feature# 895)
Rem      jkallman    04/02/2012 - Removed inserts into wwv_flow_alt_config, wwv_flow_standard_js and wwv_flow_standard_css (obsolete)
Rem      pawolf      04/06/2012 - Added read only attributes to wwv_flow_steps and wwv_flow_page_plugs (feature# 570)
Rem      cneumuel    04/10/2012 - Added apex_applications.authorize_public_pages (bug #13940433)
Rem      sathikum    04/13/2012 - Added additional columns to wwv_flow_cal_templates (feature #811)
Rem      arayner     04/20/2012 - Added wait_for_result to wwv_flow_page_da_actions (feature #599)
Rem      vuvarov     04/24/2012 - Added branch name to apex_application_page_branches dictionary view (feature #872)
Rem      pawolf      04/25/2012 - Added column_data_types to wwv_flow_plugin_attributes (feature #918)
Rem      cbcho       04/25/2012 - Added icon_view_use_custom to p_lookup_or_lov_columns in apex_application_page_ir (feature #915)
Rem      pawolf      04/27/2012 - Fixed bug in edit link of supporting objects files
Rem      cneumuel    05/08/2012 - Added advisor check MISSING_SYS_PREFIX (bug #13968025)
Rem      pawolf      05/11/2012 - Added wwv_flow_page_plugs.plug_item_display_point (feature #278)
Rem      pawolf      05/14/2012 - Added grid templates (feature #936)
Rem      arayner     05/15/2012 - Added include_legacy_javascript to wwv_flows (feature #927)
Rem      pawolf      05/21/2012 - More changes for grid templates (feature #936)
Rem      pawolf      05/21/2012 - Added wwv_flow_theme_display_points (feature #936)
Rem      pawolf      05/21/2012 - More changes for grid templates (feature #936)
Rem      pmanirah    05/24/2012 - Added column is_lov_active to the store_dictionary_view of the APEX_APPL_LOAD_TABLES view (feature #833)
Rem      pawolf      05/24/2012 - Moved grid template attributes into wwv_flow_templates and removed wwv_flow_grid_templates (feature #936)
Rem      cneumuel    05/24/2012 - Fixed typo with IS_LOV_ACTIVE (feature #833)
Rem      pmanirah    05/24/2012 - Removed is_lov_active and added column_names_lov_id column to the values of p_lookup_or_lov_columns (feature #833)
Rem      arayner     05/28/2012 - Added wwv_flow_page_da_actions.affected_button_id (feature #678)
Rem      pawolf      06/06/2012 - Commented out PHONEGAP ui types
Rem      msewtz      06/08/2012 - Commented out jqm tablet ui type
Rem      pawolf      06/15/2012 - Added has_edit_links to wwv_flow_templates
Rem      pawolf      06/15/2012 - Added table wwv_flow_plug_tmpl_disp_points (feature #936)
Rem      pawolf      06/26/2012 - Added table wwv_flow_page_tmpl_disp_points (feature #936)
Rem      cneumuel    06/27/2012 - set wwv_flow_ui_types.autodetect_plsql_function_body (feature #791)
Rem      pawolf      07/04/2012 - Added Builder Feature configuration tables (feature #827)
Rem      hfarrell    07/05/2012 - Added FLASH_CHART builder feature
Rem      jkallman    07/13/2012 - Added support for Irish and Welsh
Rem      cneumuel    07/31/2012 - Added AJAX_ITEMS_WITH_SSP advisor check (feature #514)
Rem      hfarrell    07/21/2012 - Updated AnyChart map region coordinates for Norway, Portugal, New Zealand and Chile (bug #14311203)
Rem      hfarrell    08/01/2012 - Added TABULAR_FORM Builder Feature (bug #14395210)
Rem      hfarrell    11/07/2012 - Changed wwv_flow_flash_map_files reference europe/israel.amap to asia/israel.amap (bug #15843962)
Rem      hfarrell    11/12/2012 - Added map reference information for world maps 154 and 155 missing countries (bug #15850830)
Rem      pawolf      11/13/2012 - Changed WHEN_BUTTON_PRESSED check to accept buttons on global pages (bug #14802217) 
Rem      sathikum    11/26/2012 - Added APEX_APPL_PAGE_CALENDARS to Data Dictionary bug #15890064
Rem      pawolf      11/30/2012 - Commented out apex_appl_page_calendars
Rem      sathikum    01/21/2013 - Added APEX_APPL_PAGE_CALENDARS to Data Dictionary bug #14833918
Rem      pawolf      04/11/2013 - Added new table wwv_flow_theme_files and new column files_version to wwv_flow_themes (feature #1162)
Rem      pawolf      04/18/2013 - Added wwv_flow_company_static_files and wwv_flow_static_files (feature #1169)
Rem      hfarrell    05/22/2013 - Added page_mode to p_lookup_or_lov_columns of apex_application_pages (feature #587)
Rem      msewtz      07/31/2013 - Added default_nav_list_template to p_lookup_or_lov_columns parameter call for APEX_APPLICATION_THEMES view (feature 1236)
Rem      msewtz      07/31/2013 - Added navigation_list to p_lookup_or_lov_columns parameter call for APEX_APPL_USER_INTERFACES view (feature 1236)
Rem      msewtz      07/31/2013 - Added navigation_list, navigation_list_template to p_lookup_or_lov_columns parameter call for apex_application_pages view (feature 1236)
Rem      msewtz      08/02/2013 - Added navigation_type to p_lookup_or_lov_columns parameter call for APEX_APPLICATION_THEMES view (feature 1236)
Rem      hfarrell    08/15/2013 - Added wwv_flow_standard_events insert for apexclosedialog dialog page framework event
Rem      pawolf      08/21/2013 - Added is_common and supported_ui_types to wwv_flow_plugin_attributes (features# 1270 and 1271)
Rem      msewtz      09/12/2013 - Added NATIVE_JQM_RESPONSIVE_TABLE to builder features (feature 1226)
Rem      cneumuel    09/30/2013 - Added wwv_flow_plugin_attributes.null_text to wwv_flow_translatable_cols$ (feature #1284)
Rem      cbcho       10/11/2013 - Added show_pivot, allow_pivot to p_lookup_or_lov_columns in apex_application_page_ir, apex_application_page_ir_col (feature #536)
Rem      hfarrell    11/15/2013 - Updated Close Dialog Page standard event to use apexafterclosedialog instead of apexclosedialog
Rem      pmanirah    12/05/2013 - Added skip_validation column to the values of p_lookup_or_lov_columns (feature #1327)
Rem      msewtz      12/31/2013 - Added reflow table and column toggle to builder features (feature 1226)
Rem      cneumuel    01/07/2014 - Added ID to ins() for translatable columns, to ensure that the ID does not change between APEX versions
Rem      jkallman    01/08/2014 - Changed Flow substitution string to Application substiution string in wwv_flow_translatable_cols$
Rem      pawolf      01/14/2014 - Added edit link for wwv_flow_theme_styles
Rem      pawolf      02/26/2014 - Added wwv_flow_plugin_attr_values.is_quick_pick
Rem                             - Added wwv_flow_plugin_attr_values.help_text
Rem                             - Added wwv_flow_plugin_attributes.examples
Rem      pawolf      02/28/2014 - Added wwv_flow_messages$.is_js_message 
Rem      pawolf      03/17/2014 - Added support for region columns (feature #1393)
Rem      msewtz      03/17/2014 - Added APEX_APPL_TEMPLATE_OPTIONS to Data Dictionary (feature 1394)
Rem      cneumuel    03/18/2014 - Added INSECURE_APPLICATION_DEFAULTS advisor checks
Rem      hfarrell    04/15/2014 - Removed wwv_flow_flash_chart from wwv_flow_translatable_cols$ (127-141) feature #1345)
Rem      pmanirah    04/21/2014 - Added glv_new_column to apex_appl_temp_page_dp and apex_appl_temp_region_dp views
Rem      msewtz      03/17/2014 - Added APEX_APPL_TEMPLATE_OPT_GROUPS to Data Dictionary (feature 1394)
Rem      pawolf      05/07/2014 - Added component type id to store_dictionary_view
Rem      pawolf      05/08/2014 - Moved store_dictionary_view and store_advisor_check into the dedicated files apex_install_dictionary_views_data.sql and apex_install_adivsor_data.sql
Rem      hfarrell    10/13/2014 - Added Font Awesome icons to wwv_flow_standard_icons table
Rem      hfarrell    11/04/2014 - Added added new a01_label to a20_label columns to wwv_flow_list_templates (feature #1567) 
Rem      pawolf      01/17/2015 - Fixed typo in language fr-ch (bug #15965051)
Rem      hfarrell    01/19/2015 - Removed a01_label to a20_label columns for wwv_flow_list_templates - unrequired
Rem      jkallman    03/07/2015 - Added support for Albania, Armenia in wwv_flow_languages (Bug 13458975)
Rem      jkallman    03/11/2015 - Updated territory and language for Belarus in wwv_flow_languages
Rem      msewtz      09/17/2015 - Removed duplicate creation of translation entry for wwv_flow_page_plugs.attribute_22 (bug 21574013)
Rem      cneumuel    09/17/2015 - Dropped wwv_flow_developer_roles, wwv_flow_sw_set_keywords, wwv_flow_sw_create_keywords (bug #20197863)
Rem      cbcho       02/08/2016 - Added additional region columns, wwv_flow_region_column_groups, wwv_flow_interactive_grids (feature #1215)
Rem      pawolf      03/09/2016 - Added Font APEX icon library support (feature #1851)
Rem      pawolf      03/11/2016 - Upgraded Font Awesome to 4.5.0 (feature #1967)
Rem      shrahman    04/04/2016 - Added Font APEX specific icons
Rem      shrahman    04/05/2016 - Removing missing Font APEX brand icons
Rem      shrahman    04/06/2016 - Adding user, database and cart Font APEX icons
Rem      cbcho       04/20/2016 - Added INTERACTIVE_GRID in wwv_flow_builder_features (feature #1989)
Rem      cczarski    05/02/2016 - added inline_help_text in wwv_flow_step_items
Rem      shrahman    05/06/2016 - Adding additional Font APEX icons
Rem      cczarski    05/11/2016 - added item_pre_text and item_post_text in wwv_flow_field_templates (feature #1998)
Rem      hfarrell    05/23/2016 - Added wwv_flow_jet_charts, wwv_flow_jet_chart_series and wwv_flow_jet_chart_axes columns
Rem      cczarski    06/15/2016 - add table wwv_flow_plugin_std_attributes (Feature #2018)
Rem      shrahman    06/22/2016 - added additional Font APEX icons
Rem      pawolf      06/22/2016 - In wwv_flow_standard_icons: added icon_filters
Rem      shrahman    07/30/2016 - added additional Font APEX icons
Rem      cneumuel    09/20/2016 - put insert statements in code blocks to reduce noise in log file
Rem      jkallman    02/24/2017 - Correct translated language names (Bug 25443697)
Rem      jkallman    03/01/2017 - Added support for Azerbaijani (Bug 25443697)
Rem      jkallman    03/02/2017 - Corrected values for Azerbaijani (Bug 25443697)
Rem      hfarrell    16/06/2017 - Added map reference information for world maps 154 and 155 missing countries: St Kitts and Nevis, St Vincent and the Grenadines (bug #25524569)
Rem      msewtz      01/23/2018 - Added JQM_LIST_VIEW as option for desktop apps
Rem      arayner     01/30/2018 - Added Hammer events to wwv_flow_standard_events (feature #2124)
Rem      xhu         02/23/2018 - Update Font APEX icons
Rem      pawolf      02/28/2018 - In wwv_flow_email_templates: added subject (feature #2261)
Rem      msewtz      03/13/2018 - Added REFLOW_TABLE and COLUMN_TOGGLE as option for desktop apps (bug 27687016)
Rem      arayner     11/13/2018 - In wwv_flow_list_of_values_cols: added heading (feature #2406)
Rem      cneumuel    12/07/2018 - Removed BOX_FOOTER_TEXT (bug #28812054)
Rem      jkallman    02/11/2019 - Added support for Swahili in languages

set define '^'
prompt ...Application Express installation data


prompt
prompt ...insert into ui types
prompt

begin
    wwv_flow_security.g_security_group_id := null;
    --
    delete from wwv_flow_ui_types;
    --
    insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (1, 'DESKTOP',                 null, '-BUILTIN-');
    insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (2, 'JQM_SMARTPHONE',          null, '-BUILTIN-');
    -- insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (3, 'JQM_TABLET',              2, '-BUILTIN-');
    -- insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (4, 'PHONEGAP_JQM_SMARTPHONE', 2, '-BUILTIN-');
    -- insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (5, 'PHONEGAP_JQM_TABLET',     3, '-BUILTIN-');
    wwv_flow_security.g_security_group_id := 10;
    commit;
end;
/


prompt
prompt ...insert into builder features and ui type features
prompt

declare
    l_ui_type_id number;
    --
    procedure add_builder_feature (
        p_id   in number,
        p_name in varchar2 )
    is
    begin
        insert into wwv_flow_builder_features (
            id,
            name )
        values (
            p_id,
            p_name );
    end add_builder_feature;
    --
    procedure add_assignment (
        p_builder_feature_name in varchar2 )
    is
        l_builder_feature_id number;
    begin
        select id
          into l_builder_feature_id
          from wwv_flow_builder_features
         where name = p_builder_feature_name;
        --
        insert into wwv_flow_ui_type_features (
            ui_type_id,
            builder_feature_id,
            security_group_id )
        values (
            l_ui_type_id,
            l_builder_feature_id,
            null );
    end add_assignment;
begin
    wwv_flow_security.g_security_group_id := null;
    --
    delete from wwv_flow_ui_type_features;
    delete from wwv_flow_builder_features;
    --
    -- Create "Features" which are used as conditions in the APEX Builder to show components/...
    -- depending on the selected UI.
    --
    -- Note: Don't change existing builder feature ids, because they are referenced in export files!
    --
    add_builder_feature( 1, 'CLASSIC_REPORT');
    add_builder_feature( 2, 'INTERACTIVE_REPORT');
    add_builder_feature( 3, 'CHART_MAP');
    add_builder_feature( 4, 'JSTREE');
    add_builder_feature( 5, 'DATA_LOADING');
    add_builder_feature( 6, 'JQM_LIST_VIEW');
    add_builder_feature( 7, 'TABS');
    add_builder_feature( 8, 'MASTER_DETAIL');
    add_builder_feature( 9, 'FLASH_CHART');
    add_builder_feature( 10, 'TABULAR_FORM');
    add_builder_feature( 11, 'JQM_REFLOW_TABLE');
    add_builder_feature( 12, 'JQM_COLUMN_TOGGLE');
    add_builder_feature( 13, 'INTERACTIVE_GRID');
    --
    -- Assign "Features" to the different UI types
    --
    l_ui_type_id := 1; -- DESKTOP
    add_assignment('CLASSIC_REPORT');
    add_assignment('INTERACTIVE_REPORT');
    add_assignment('CHART_MAP');
    add_assignment('JSTREE');
    add_assignment('DATA_LOADING');
    add_assignment('TABS');
    add_assignment('MASTER_DETAIL');
    add_assignment('FLASH_CHART');
    add_assignment('TABULAR_FORM');
    add_assignment('INTERACTIVE_GRID');
    add_assignment('JQM_LIST_VIEW'); -- added for Desktop apps
    add_assignment('JQM_REFLOW_TABLE');
    add_assignment('JQM_COLUMN_TOGGLE');    
    --
    l_ui_type_id := 2; -- JQM_SMARTPHONE
    add_assignment('JQM_LIST_VIEW');
    add_assignment('JQM_REFLOW_TABLE');
    add_assignment('JQM_COLUMN_TOGGLE');
    --
    wwv_flow_security.g_security_group_id := 10;
    commit;
end;
/


prompt
prompt ...insert into wwv_flow_translatable_cols$
prompt

delete from wwv_flow_translatable_cols$;

declare
    subtype t_rec is wwv_flow_translatable_cols$%rowtype;
    type    t_tab is table of t_rec index by pls_integer;
    l_tab   t_tab;
    procedure ins (
        p_id                    in number,
        p_table_name            in varchar2,
        p_column_name           in varchar2,
        p_table_pk              in varchar2,
        p_flow_id_column        in varchar2,
        p_page_id_column        in varchar2,
        p_datatype              in varchar2,
        p_template_translatable in varchar2,
        p_column_description    in varchar2 )
    is
        c_idx constant pls_integer := l_tab.count+1;
    begin
        l_tab(c_idx).id                    := p_id;
        l_tab(c_idx).table_name            := p_table_name;
        l_tab(c_idx).column_name           := p_column_name;
        l_tab(c_idx).table_pk              := p_table_pk;
        l_tab(c_idx).flow_id_column        := p_flow_id_column;
        l_tab(c_idx).page_id_column        := p_page_id_column;
        l_tab(c_idx).datatype              := p_datatype;
        l_tab(c_idx).template_translatable := p_template_translatable;
        l_tab(c_idx).column_description    := p_column_description;
    end ins;
    procedure flush
    is
    begin
        forall i in 1 .. l_tab.count
            insert into wwv_flow_translatable_cols$ (
                id,
                table_name,
                column_name,
                table_pk,
                flow_id_column,
                page_id_column,
                datatype,
                template_translatable,
                column_description )
            values (
                l_tab(i).id,
                l_tab(i).table_name,
                l_tab(i).column_name,
                l_tab(i).table_pk,
                l_tab(i).flow_id_column,
                l_tab(i).page_id_column,
                l_tab(i).datatype,
                l_tab(i).template_translatable,
                l_tab(i).column_description );
    end flush;
begin
    ins(1.1,'WWV_FLOW_TOPLEVEL_TABS','TAB_TEXT','ID','FLOW_ID','','VARCHAR2','N','Top Level Tab Name.');
    ins(2,'WWV_FLOW_ICON_BAR','ICON_IMAGE_ALT','ID','FLOW_ID','','VARCHAR2','N','Navigation Bar Icon Text.');
    ins(2.1,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look1.');
    ins(2.2,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT2','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look2.');
    ins(2.3,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT3','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look3.');
    ins(3,'WWV_FLOW_PROCESSING','PROCESS_ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Flow Process Error Message.');
    ins(4,'WWV_FLOW_TABS','TAB_TEXT','ID','FLOW_ID','','VARCHAR2','N','Tab Text.');
    ins(5,'WWV_FLOW_STEPS','NAME','ID','FLOW_ID','ID','VARCHAR2','N','Page Name.');
    ins(6,'WWV_FLOW_STEPS','STEP_TITLE','ID','FLOW_ID','ID','VARCHAR2','N','Page Title.');
    ins(8,'WWV_FLOW_STEPS','WELCOME_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Header Text.');
    ins(9,'WWV_FLOW_STEPS','BOX_WELCOME_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Body Header Text.');
    ins(11,'WWV_FLOW_STEPS','FOOTER_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Footer Text.');
    ins(12,'WWV_FLOW_STEPS','HELP_TEXT','ID','FLOW_ID','ID','CLOB','N','Page Help Text.');
    ins(13,'WWV_FLOW_STEP_BUTTONS','BUTTON_IMAGE_ALT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Button Text.');
    ins(14,'WWV_FLOW_STEP_ITEMS','PROMPT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Item Prompt.');
    ins(16,'WWV_FLOW_STEP_VALIDATIONS','ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Validation ErrMsg.');
    ins(17,'WWV_FLOW_STEP_PROCESSING','PROCESS_ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Process ErrMsg.');
    ins(18,'WWV_FLOW_STEP_PROCESSING','PROCESS_SUCCESS_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Process Success Message.');
    ins(19,'WWV_FLOW_PAGE_PLUG_TEMPLATES','TEMPLATE','ID','FLOW_ID','','CLOB','Y','Region template, typically does not include translatable text.');
    ins(20,'WWV_FLOW_PAGE_PLUGS','PLUG_NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2','Y','Region name');
    ins(21,'WWV_FLOW_PAGE_PLUGS','PLUG_SOURCE','ID','FLOW_ID','PAGE_ID','CLOB','N','Region source');
    ins(23,'WWV_FLOW_TEMPLATES','HEADER_TEMPLATE','ID','FLOW_ID','','CLOB','Y','Page Header Template');
    ins(24,'WWV_FLOW_TEMPLATES','FOOTER_TEMPLATE','ID','FLOW_ID','','CLOB','Y','Page Footer Template');
    ins(25,'WWV_FLOW_TEMPLATES','BOX','ID','FLOW_ID','','CLOB','Y','Page Body Template');
    ins(26,'WWV_FLOW_PAGE_PLUGS','PLUG_HEADER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region header');
    ins(27,'WWV_FLOW_PAGE_PLUGS','PLUG_FOOTER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region footer');
    ins(28,'WWV_FLOW_LIST_ITEMS','LIST_ITEM_LINK_TEXT','ID','FLOW_ID','','VARCHAR2','N','List Item Display Text');
    ins(29,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE1','ID','FLOW_ID','','CLOB','Y','Row Template 1');
    ins(30,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE2','ID','FLOW_ID','','CLOB','Y','Row Template 2');
    ins(31,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE3','ID','FLOW_ID','','CLOB','Y','Row Template 3');
    ins(32,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE4','ID','FLOW_ID','','CLOB','Y','Row Template 4');
    ins(34,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_BEFORE_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Report Template Before Rows');
    ins(35,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_AFTER_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Report Template After Rows');
    ins(36,'WWV_FLOW_PAGE_PLUGS','PLUG_QUERY_NO_DATA_FOUND','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','No Data Found Message For Regions');
    ins(37,'WWV_FLOW_FIELD_TEMPLATES','TEMPLATE_BODY1','ID','FLOW_ID','','VARCHAR2','Y','Before Label, typically does not include translatable text');
    ins(38,'WWV_FLOW_FIELD_TEMPLATES','TEMPLATE_BODY2','ID','FLOW_ID','','VARCHAR2','Y','After Label, typically does not include translatable text');
    ins(39,'WWV_FLOW_FIELD_TEMPLATES','ON_ERROR_BEFORE_LABEL','ID','FLOW_ID','','VARCHAR2','Y','On Error Before Label, typically does not include translatable text');
    ins(40,'WWV_FLOW_FIELD_TEMPLATES','ON_ERROR_AFTER_LABEL','ID','FLOW_ID','','VARCHAR2','Y','On Error After Label, typically does not include translatable text');
    ins(41,'WWV_FLOW_PAGE_PLUGS','CSV_OUTPUT_LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Link text the user will see when the report region is displayed in CSV format');
    ins(42,'WWV_FLOW_PAGE_PLUGS','REPORT_TOTAL_TEXT_FORMAT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text to display when printing report sums');
    ins(43,'WWV_FLOW_PAGE_PLUGS','BREAK_COLUMN_TEXT_FORMAT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Heading template for repeating headings');
    ins(44,'WWV_FLOW_ROW_TEMPLATES','COLUMN_HEADING_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Column Heading Template');
    ins(45,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_BEFORE_FIRST','ID','FLOW_ID','','VARCHAR2','Y','Report Template Before First Row');
    ins(46,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_AFTER_LAST','ID','FLOW_ID','','VARCHAR2','Y','Report Template After Last Row');
    ins(47,'WWV_FLOW_ROW_TEMPLATES','PAGINATION_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Pagination Template');
    ins(48,'WWV_FLOW_ROW_TEMPLATES','NEXT_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Next Page Template');
    ins(49,'WWV_FLOW_ROW_TEMPLATES','PREVIOUS_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Previous Page Template');
    ins(50,'WWV_FLOW_ROW_TEMPLATES','NEXT_SET_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Next Set Template');
    ins(51,'WWV_FLOW_ROW_TEMPLATES','PREVIOUS_SET_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Previous Set Template');
    ins(52,'WWV_FLOW_BUTTON_TEMPLATES','TEMPLATE','ID','FLOW_ID','','CLOB','Y','Button Template');
    ins(53,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_CURRENT','ID','FLOW_ID','','CLOB','Y','Template when list item is current');
    ins(54,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_NONCURRENT','ID','FLOW_ID','','CLOB','Y','Template when list item is not current');
    ins(55,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_BEFORE_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Appears before list template items');
    ins(56,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_AFTER_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Appears after list template items');
    ins(57,'WWV_FLOW_MENU_TEMPLATES','BEFORE_FIRST','ID','FLOW_ID','','VARCHAR2','Y','Appears before menu items');
    ins(58,'WWV_FLOW_MENU_TEMPLATES','CURRENT_PAGE_OPTION','ID','FLOW_ID','','VARCHAR2','Y','Template when menu item is current');
    ins(59,'WWV_FLOW_MENU_TEMPLATES','NON_CURRENT_PAGE_OPTION','ID','FLOW_ID','','VARCHAR2','Y','Template when menu item is not current');
    ins(60,'WWV_FLOW_MENU_TEMPLATES','MENU_LINK_ATTRIBUTES','ID','FLOW_ID','','VARCHAR2','Y','The attributes of the link, such as class or id');
    ins(61,'WWV_FLOW_MENU_TEMPLATES','BETWEEN_LEVELS','ID','FLOW_ID','','VARCHAR2','Y','Appears between menu items');
    ins(62,'WWV_FLOW_MENU_TEMPLATES','AFTER_LAST','ID','FLOW_ID','','VARCHAR2','Y','Appears after the last menu item');
    ins(63,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_TITLE','ID','FLOW_ID','','VARCHAR2','N','Title of page');
    ins(64,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_HTML_HEAD','ID','FLOW_ID','','VARCHAR2','Y','HTML <head> of the popup page');
    ins(65,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_BODY_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Attributes listed in the <body> tag');
    ins(66,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_FIELD_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears before the search field');
    ins(67,'WWV_FLOW_POPUP_LOV_TEMPLATE','AFTER_FIELD_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears after the search field');
    ins(68,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_HEADING_TEXT','ID','FLOW_ID','','VARCHAR2','Y','Text that appears at the top of the popup page');
    ins(69,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_FOOTER_TEXT','ID','FLOW_ID','','VARCHAR2','Y','Text that appears at the bottom of the popup page');
    ins(70,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_RESULT_SET','ID','FLOW_ID','','VARCHAR2','N','Text that appears before choices');
    ins(71,'WWV_FLOW_POPUP_LOV_TEMPLATE','AFTER_RESULT_SET','ID','FLOW_ID','','VARCHAR2','N','Text that appears after choices');
    ins(72,'WWV_FLOW_POPUP_LOV_TEMPLATE','FIND_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the search button');
    ins(73,'WWV_FLOW_POPUP_LOV_TEMPLATE','CLOSE_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the close button');
    ins(74,'WWV_FLOW_POPUP_LOV_TEMPLATE','NEXT_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the next button');
    ins(75,'WWV_FLOW_POPUP_LOV_TEMPLATE','PREV_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the previous button');
    ins(76,'WWV_FLOW_POPUP_LOV_TEMPLATE','WHEN_NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Text that appears when search returns 0 results');
    ins(77,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_FIRST_FETCH_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Text that appears before first time search button is pressed');
    ins(78,'WWV_FLOW_STEP_ITEMS','POST_ELEMENT_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Text that is displayed following the display of a form element');
    ins(79,'WWV_FLOW_SHORTCUTS','SHORTCUT','ID','FLOW_ID','','CLOB','N','Shortcut is shared static or dynamic HTML');
    ins(80,'WWV_FLOWS','SUBSTITUTION_VALUE_01','ID','ID','','VARCHAR2','N','Application substitution string 01');
    ins(81,'WWV_FLOWS','SUBSTITUTION_VALUE_02','ID','ID','','VARCHAR2','N','Application substitution string 02');
    ins(82,'WWV_FLOWS','SUBSTITUTION_VALUE_03','ID','ID','','VARCHAR2','N','Application substitution string 03');
    ins(83,'WWV_FLOWS','SUBSTITUTION_VALUE_04','ID','ID','','VARCHAR2','N','Application substitution string 04');
    ins(84,'WWV_FLOWS','SUBSTITUTION_VALUE_05','ID','ID','','VARCHAR2','N','Application substitution string 05');
    ins(85,'WWV_FLOWS','SUBSTITUTION_VALUE_06','ID','ID','','VARCHAR2','N','Application substitution string 06');
    ins(86,'WWV_FLOWS','SUBSTITUTION_VALUE_07','ID','ID','','VARCHAR2','N','Application substitution string 07');
    ins(87,'WWV_FLOWS','SUBSTITUTION_VALUE_08','ID','ID','','VARCHAR2','N','Application substitution string 08');
    ins(88,'WWV_FLOWS','SUBSTITUTION_VALUE_09','ID','ID','','VARCHAR2','N','Application substitution string 09');
    ins(89,'WWV_FLOWS','SUBSTITUTION_VALUE_10','ID','ID','','VARCHAR2','N','Application substitution string 10');
    ins(90,'WWV_FLOWS','SUBSTITUTION_VALUE_11','ID','ID','','VARCHAR2','N','Application substitution string 11');
    ins(91,'WWV_FLOWS','SUBSTITUTION_VALUE_12','ID','ID','','VARCHAR2','N','Application substitution string 12');
    ins(92,'WWV_FLOWS','SUBSTITUTION_VALUE_13','ID','ID','','VARCHAR2','N','Application substitution string 13');
    ins(93,'WWV_FLOWS','SUBSTITUTION_VALUE_14','ID','ID','','VARCHAR2','N','Application substitution string 14');
    ins(94,'WWV_FLOWS','SUBSTITUTION_VALUE_15','ID','ID','','VARCHAR2','N','Application substitution string 15');
    ins(95,'WWV_FLOWS','SUBSTITUTION_VALUE_16','ID','ID','','VARCHAR2','N','Application substitution string 16');
    ins(96,'WWV_FLOWS','SUBSTITUTION_VALUE_17','ID','ID','','VARCHAR2','N','Application substitution string 17');
    ins(97,'WWV_FLOWS','SUBSTITUTION_VALUE_18','ID','ID','','VARCHAR2','N','Application substitution string 18');
    ins(98,'WWV_FLOWS','SUBSTITUTION_VALUE_19','ID','ID','','VARCHAR2','N','Application substitution string 19');
    ins(99,'WWV_FLOWS','SUBSTITUTION_VALUE_20','ID','ID','','VARCHAR2','N','Application substitution string 20');
    ins(100,'WWV_FLOW_MENU_OPTIONS','SHORT_NAME','ID','FLOW_ID','','VARCHAR2','N','Shortcut short name');
    ins(101,'WWV_FLOW_MENU_OPTIONS','LONG_NAME','ID','FLOW_ID','','VARCHAR2','N','Shortcut long name');
    ins(102,'WWV_FLOW_PAGE_PLUGS','PLUG_QUERY_MORE_DATA','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','More Data found message');
    ins(103,'WWV_FLOW_LIST_OF_VALUES_DATA','LOV_DISP_VALUE','ID','FLOW_ID','','VARCHAR2','N','List of values display value');
    ins(104,'WWV_FLOW_AUTHENTICATIONS','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','Login help text for the built-in login page');
    ins(105,'WWV_FLOW_STEP_ITEMS','LOV_NULL_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Value displayed when null selected in LOV');
    ins(106,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2','N','Report column heading');
    ins(107,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_LINKTEXT','ID','FLOW_ID','','VARCHAR2','N','Text to display inside of HTML anchor in report');
    ins(108,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_HTML_EXPRESSION','ID','FLOW_ID','','VARCHAR2','N','HTML expression');
    ins(109,'WWV_FLOW_REGION_REPORT_COLUMN','LOV_NULL_TEXT','ID','FLOW_ID','','VARCHAR2','N','Value displayed when null selected from LOV');
    ins(110,'WWV_FLOW_PAGE_PLUGS','PLUG_CUSTOMIZED_NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Customizable region name');
    ins(111,'WWV_FLOW_STEP_ITEM_HELP','HELP_TEXT','FLOW_ITEM_ID','FLOW_ID','','VARCHAR2','N','Item level help text');
    ins(112,'WWV_FLOW_POPUP_LOV_TEMPLATE','RESULT_ROW_X_OF_Y','ID','FLOW_ID','','VARCHAR2','N','Set pagination text');
    ins(113,'WWV_FLOW_SHORTCUTS','ERROR_TEXT','ID','FLOW_ID','','VARCHAR2','N','Shortcut is shared static or dynamic HTML');
    ins(114,'WWV_FLOW_LIST_TEMPLATES','BETWEEN_ITEMS','ID','FLOW_ID','','VARCHAR2','Y','Appears between list template items');
    ins(115,'WWV_FLOW_LIST_TEMPLATES','BEFORE_SUB_LIST','ID','FLOW_ID','','VARCHAR2','Y','Appears before list template sub list items');
    ins(116,'WWV_FLOW_LIST_TEMPLATES','AFTER_SUB_LIST','ID','FLOW_ID','','VARCHAR2','Y','Appears after list template sub list items');
    ins(117,'WWV_FLOW_LIST_TEMPLATES','BETWEEN_SUB_LIST_ITEMS','ID','FLOW_ID','','VARCHAR2','Y','Appears between list template sub list items');
    ins(118,'WWV_FLOW_LIST_TEMPLATES','SUB_LIST_ITEM_CURRENT','ID','FLOW_ID','','CLOB','Y','Appears as current list template sub list item');
    ins(119,'WWV_FLOW_LIST_TEMPLATES','SUB_LIST_ITEM_NONCURRENT','ID','FLOW_ID','','CLOB','Y','Appears as noncurrent list template sub list item');
    ins(120,'WWV_FLOW_LIST_TEMPLATES','ITEM_TEMPLATE_CURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Template for current list item with child');
    ins(121,'WWV_FLOW_LIST_TEMPLATES','ITEM_TEMPLATE_NONCURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Template for non-current list item with child');
    ins(122,'WWV_FLOW_LIST_TEMPLATES','SUB_TEMPLATE_CURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Sub template for current list item with child');
    ins(123,'WWV_FLOW_LIST_TEMPLATES','SUB_TEMPLATE_NONCURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Sub template for non-current list item with child');
    ins(124,'WWV_FLOW_COMPUTATIONS','COMPUTATION_ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Application computation error message');
    ins(125,'WWV_FLOW_STEP_COMPUTATIONS','COMPUTATION_ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page computation error message');
    ins(126,'WWV_FLOW_STEP_ITEMS','PRE_ELEMENT_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Text that is displayed before the display of a form element');
    ins(142,'WWV_FLOW_PAGE_PLUGS','PRN_OUTPUT_LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Link label name for region printing');
    ins(143,'WWV_FLOW_PAGE_PLUGS','PRN_PAGE_HEADER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region printing report header');
    ins(144,'WWV_FLOW_PAGE_PLUGS','PRN_PAGE_FOOTER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region printing report footer');
    ins(145,'WWV_FLOW_WORKSHEETS','DESCRIPTION','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet description');
    ins(146,'WWV_FLOW_WORKSHEETS','MAX_ROW_COUNT_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when showing the maximum number of rows in a worksheet');
    ins(147,'WWV_FLOW_WORKSHEETS','NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when no data found in a worksheet');
    ins(147.1,'WWV_FLOW_WORKSHEETS','ICON_VIEW_ALT_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Icon view text for the image');
    ins(147.2,'WWV_FLOW_WORKSHEETS','ICON_VIEW_TITLE_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Icon view title text for the image');
    ins(148,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column label');
    ins(149,'WWV_FLOW_WORKSHEET_COLUMNS','REPORT_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet report label');
    ins(150,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_HTML_EXPRESSION','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column HTML expression');
    ins(151,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_LINKTEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column link text');
    ins(152,'WWV_FLOW_WORKSHEET_COLUMNS','HELP_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column help text');
    ins(153,'WWV_FLOW_WORKSHEET_COL_GROUPS','NAME','ID','FLOW_ID','','VARCHAR2','N','Worksheet column group name');
    ins(154,'WWV_FLOW_WORKSHEET_COL_GROUPS','DESCRIPTION','ID','FLOW_ID','','VARCHAR2','N','Worksheet column group description');
    ins(155,'WWV_FLOW_WORKSHEETS','SEARCH_BUTTON_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Label of search button in Interactive Report.');
    ins(156,'WWV_FLOW_TEMPLATES','BODY_TITLE','ID','FLOW_ID','','VARCHAR2','Y','Body Title');
    ins(157,'WWV_FLOW_TEMPLATES','CURRENT_IMAGE_TAB','ID','FLOW_ID','','VARCHAR2','Y','Current Image Tab');
    ins(158,'WWV_FLOW_TEMPLATES','CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Current Tab');
    ins(159,'WWV_FLOW_TEMPLATES','CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Current Tab Font Attributes');
    ins(160,'WWV_FLOW_TEMPLATES','ERROR_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Error Page Template');
    ins(161,'WWV_FLOW_TEMPLATES','MESSAGE','ID','FLOW_ID','','VARCHAR2','Y','Notification');
    ins(162,'WWV_FLOW_TEMPLATES','NAVBAR_ENTRY','ID','FLOW_ID','','VARCHAR2','Y','Navigation Bar Entry');
    ins(163,'WWV_FLOW_TEMPLATES','NAVIGATION_BAR','ID','FLOW_ID','','VARCHAR2','Y','Navigation Bar');
    ins(164,'WWV_FLOW_TEMPLATES','NON_CURRENT_IMAGE_TAB','ID','FLOW_ID','','VARCHAR2','Y','Non Current Image Tab');
    ins(165,'WWV_FLOW_TEMPLATES','NON_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Non Current Standard Tab');
    ins(166,'WWV_FLOW_TEMPLATES','NON_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Non Current Tab Font Attributes');
    ins(167,'WWV_FLOW_TEMPLATES','REGION_TABLE_CATTRIBUTES','ID','FLOW_ID','','VARCHAR2','Y','Region Table Attributes');
    ins(168,'WWV_FLOW_TEMPLATES','SUCCESS_MESSAGE','ID','FLOW_ID','','VARCHAR2','Y','Success Message');
    ins(169,'WWV_FLOW_TEMPLATES','TOP_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Current Parent Tab');
    ins(170,'WWV_FLOW_TEMPLATES','TOP_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Parent Current Tab Font Attributes');
    ins(171,'WWV_FLOW_TEMPLATES','TOP_NON_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Non Current Parent Tab');
    ins(172,'WWV_FLOW_TEMPLATES','TOP_NON_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Parent Non Current Tab Font Attributes');
    ins(173,'WWV_FLOW_CAL_TEMPLATES','DAILY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(174,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(175,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(176,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(177,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(178,'WWV_FLOW_CAL_TEMPLATES','DAILY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(179,'WWV_FLOW_CAL_TEMPLATES','DAILY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(180,'WWV_FLOW_CAL_TEMPLATES','DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(181,'WWV_FLOW_CAL_TEMPLATES','DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(182,'WWV_FLOW_CAL_TEMPLATES','DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(183,'WWV_FLOW_CAL_TEMPLATES','DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(184,'WWV_FLOW_CAL_TEMPLATES','MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(185,'WWV_FLOW_CAL_TEMPLATES','MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(186,'WWV_FLOW_CAL_TEMPLATES','MONTH_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(187,'WWV_FLOW_CAL_TEMPLATES','NONDAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(188,'WWV_FLOW_CAL_TEMPLATES','NONDAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(189,'WWV_FLOW_CAL_TEMPLATES','NONDAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(190,'WWV_FLOW_CAL_TEMPLATES','TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(191,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(192,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(193,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(194,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(195,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(196,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(197,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(198,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_HOUR_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(199,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_HOUR_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(200,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(201,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(202,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(203,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(204,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(205,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(206,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(207,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(208,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(209,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(210,'WWV_FLOW_CAL_TEMPLATES','WEEK_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(211,'WWV_FLOW_CAL_TEMPLATES','WEEK_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(212,'WWV_FLOW_PAGE_PLUG_TEMPLATES','TEMPLATE2','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(213,'WWV_FLOW_POPUP_LOV_TEMPLATE','CLOSE_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(214,'WWV_FLOW_POPUP_LOV_TEMPLATE','FILTER_TEXT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(215,'WWV_FLOW_POPUP_LOV_TEMPLATE','FIND_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(216,'WWV_FLOW_POPUP_LOV_TEMPLATE','NEXT_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(217,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(218,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON2','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(219,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(220,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON_ATTR2','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(221,'WWV_FLOW_POPUP_LOV_TEMPLATE','PREV_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(222,'WWV_FLOW_ROW_TEMPLATES','AFTER_COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(223,'WWV_FLOW_ROW_TEMPLATES','BEFORE_COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(224,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(225,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(226,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(227,'WWV_FLOW_CAL_TEMPLATES','DAILY_HOUR_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(228,'WWV_FLOW_CAL_TEMPLATES','DAILY_HOUR_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(229,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(230,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(231,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(232,'WWV_FLOW_CAL_TEMPLATES','DAILY_TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(233,'WWV_FLOW_CAL_TEMPLATES','WEEK_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(234,'WWV_FLOW_PAGE_PLUG_TEMPLATES','SUB_PLUG_HEADER_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(235,'WWV_FLOW_PAGE_PLUG_TEMPLATES','SUB_PLUG_HEADER_ENTRY_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(236,'WWV_FLOW_PAGE_PLUG_TEMPLATES','SUB_PLUG_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(237,'WWV_FLOW_PLUGINS','DISPLAY_NAME','ID','FLOW_ID','','VARCHAR2','N','');
    ins(238,'WWV_FLOW_PLUGINS','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(239,'WWV_FLOW_PLUGIN_ATTRIBUTES','PROMPT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(240,'WWV_FLOW_PLUGIN_ATTRIBUTES','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(241,'WWV_FLOW_PLUGIN_EVENTS','DISPLAY_NAME','ID','FLOW_ID','','VARCHAR2','N','');
    ins(242,'WWV_FLOW_PLUGIN_ATTR_VALUES','DISPLAY_VALUE','ID','FLOW_ID','','VARCHAR2','N','');
    ins(243,'WWV_FLOW_FLASH_CHARTS_5','CHART_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Flash chart 5 title');
    ins(244,'WWV_FLOW_FLASH_CHARTS_5','X_AXIS_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','X Axis title');
    ins(245,'WWV_FLOW_FLASH_CHARTS_5','X_AXIS_PREFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','X Axis prefix');
    ins(246,'WWV_FLOW_FLASH_CHARTS_5','X_AXIS_POSTFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','X Axis postfix');
    ins(247,'WWV_FLOW_FLASH_CHARTS_5','Y_AXIS_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Y Axis title');
    ins(248,'WWV_FLOW_FLASH_CHARTS_5','Y_AXIS_PREFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Y Axis prefix');
    ins(249,'WWV_FLOW_FLASH_CHARTS_5','Y_AXIS_POSTFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Y Axis postfix');
    ins(250,'WWV_FLOW_FLASH_CHARTS_5','VALUES_PREFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Values prefix');
    ins(251,'WWV_FLOW_FLASH_CHARTS_5','VALUES_POSTFIX','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Values postfix');
    ins(253,'WWV_FLOW_FLASH_CHARTS_5','LEGEND_TITLE','ID','FLOW_ID','PAGE_ID','CLOB','N','Legend Title');
    ins(254,'WWV_FLOW_FLASH_CHART5_SERIES','SERIES_NAME','ID','FLOW_ID','','VARCHAR2','N','Flash chart series name');
    ins(255,'WWV_FLOW_FLASH_CHART5_SERIES','SERIES_QUERY_NO_DATA_FOUND','ID','FLOW_ID','','VARCHAR2','N','Flash chart query no data found message');
    ins(256,'WWV_FLOW_PLUGINS','SQL_EXAMPLES','ID','FLOW_ID','','VARCHAR2','N','');
    ins(257,'WWV_FLOW_SECURITY_SCHEMES','ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Error message of an authorization scheme');
    ins(258,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_01','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 1.');
    ins(259,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_02','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 2.');
    ins(260,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_03','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 3.');
    ins(261,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_04','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 4.');
    ins(262,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_05','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 5.');
    ins(263,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_06','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 6.');
    ins(264,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_07','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 7.');
    ins(265,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_08','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 8.');
    ins(266,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_09','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 9.');
    ins(267,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_10','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 10.');
    ins(268,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_01','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 1.');
    ins(269,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_02','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 2.');
    ins(270,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_03','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 3.');
    ins(271,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_04','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 4.');
    ins(272,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_05','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 5.');
    ins(273,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_06','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 6.');
    ins(274,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_07','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 7.');
    ins(275,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_08','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 8.');
    ins(276,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_09','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 9.');
    ins(277,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_10','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 10.');
    ins(278,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_01','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 1.');
    ins(279,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_02','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 2.');
    ins(280,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_03','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 3.');
    ins(281,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_04','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 4.');
    ins(282,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_05','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 5.');
    ins(283,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_06','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 6.');
    ins(284,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_07','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 7.');
    ins(285,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_08','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 8.');
    ins(286,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_09','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 9.');
    ins(287,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_10','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 10.');
    ins(288,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_01','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 1.');
    ins(289,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_02','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 2.');
    ins(290,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_03','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 3.');
    ins(291,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_04','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 4.');
    ins(292,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_05','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 5.');
    ins(293,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_06','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 6.');
    ins(294,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_07','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 7.');
    ins(295,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_08','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 8.');
    ins(296,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_09','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 9.');
    ins(297,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_10','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 10.');
    ins(298,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(299,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(300,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(301,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(302,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(303,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(304,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(305,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(306,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(307,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(308,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_01','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 1.');
    ins(309,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_02','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 2.');
    ins(310,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_03','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 3.');
    ins(311,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_04','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 4.');
    ins(312,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_05','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 5.');
    ins(313,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_06','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 6.');
    ins(314,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_07','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 7.');
    ins(315,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_08','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 8.');
    ins(316,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_09','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 9.');
    ins(317,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_10','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 10.');
    ins(318,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_11','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 11.');
    ins(319,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_12','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 12.');
    ins(320,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_13','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 13.');
    ins(321,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_14','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 14.');
    ins(322,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_15','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 15.');
    ins(323,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_11','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 11.');
    ins(324,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_12','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 12.');
    ins(325,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_13','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 13.');
    ins(326,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_14','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 14.');
    ins(327,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_15','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 15.');
    ins(328,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_11','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 11.');
    ins(329,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_12','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 12.');
    ins(330,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_13','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 13.');
    ins(331,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_14','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 14.');
    ins(332,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_15','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 15.');
    ins(333,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(334,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(335,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(336,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(337,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(338,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_11','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 11.');
    ins(339,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_12','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 12.');
    ins(340,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_13','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 13.');
    ins(341,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_14','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 14.');
    ins(342,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_15','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 15.');
    ins(343,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(344,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(345,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(346,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(347,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(348,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(349,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(350,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(351,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(352,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(353,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(354,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(355,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(356,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(357,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(358,'WWV_FLOW_LIST_ITEMS','LIST_ITEM_ICON_ALT_ATTRIBUTE','ID','FLOW_ID','','VARCHAR2','N','List Item Icon Alt Tag Text');
    ins(359,'WWV_FLOW_LOAD_TABLE_LOOKUPS','ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Error Message');
    ins(360,'WWV_FLOW_LOAD_TABLE_RULES','ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Error Message');
    ins(361,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(362,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(363,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(364,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(365,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(366,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(367,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(368,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(369,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(370,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(371,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(372,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(373,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(374,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(375,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(376,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_01','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 1');
    ins(377,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_02','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 2');
    ins(378,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_03','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 3');
    ins(379,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_04','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 4');
    ins(380,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_05','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 5');
    ins(381,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_06','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 6');
    ins(382,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_07','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 7');
    ins(383,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_08','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 8');
    ins(384,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_09','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 9');
    ins(385,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_10','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 10');
    ins(386,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_11','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 11');
    ins(387,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_12','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 12');
    ins(388,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_13','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 13');
    ins(389,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_14','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 14');
    ins(390,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_15','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 15');
    ins(391,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_16','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 16');
    ins(392,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_17','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 17');
    ins(393,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_18','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 18');
    ins(394,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_19','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 19');
    ins(395,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_20','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 20');
    ins(396,'WWV_FLOW_STEP_ITEMS','PLACEHOLDER','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Item Placeholder.');
    ins(397,'WWV_FLOW_USER_INTERFACES','DISPLAY_NAME','ID','FLOW_ID','','VARCHAR2','N','User Interface Display Name.');
    ins(398,'WWV_FLOW_CAL_TEMPLATES','AGENDA_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(399,'WWV_FLOW_CAL_TEMPLATES','AGENDA_PAST_DAY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(400,'WWV_FLOW_CAL_TEMPLATES','AGENDA_TODAY_DAY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(401,'WWV_FLOW_CAL_TEMPLATES','AGENDA_FUTURE_DAY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(402,'WWV_FLOW_CAL_TEMPLATES','AGENDA_PAST_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(403,'WWV_FLOW_CAL_TEMPLATES','AGENDA_TODAY_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(404,'WWV_FLOW_CAL_TEMPLATES','AGENDA_FUTURE_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(405,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_16','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 16.');
    ins(406,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_17','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 17.');
    ins(407,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_18','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 18.');
    ins(408,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_19','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 19.');
    ins(409,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_20','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 20.');
    ins(410,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_21','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 21.');
    ins(411,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_22','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 22.');
    ins(413,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_23','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 23.');
    ins(414,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_24','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 24.');
    ins(415,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_25','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 25.');
    ins(416,'WWV_FLOW_PLUGIN_ATTRIBUTES','NULL_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(417,'WWV_FLOW_CAL_TEMPLATES','MONTH_DATA_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(418,'WWV_FLOW_CAL_TEMPLATES','MONTH_DATA_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(419,'WWV_FLOW_PLUGIN_ATTR_VALUES','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(420,'WWV_FLOW_PLUGIN_ATTRIBUTES','EXAMPLES','ID','FLOW_ID','','VARCHAR2','N','');
    ins(421,'WWV_FLOW_REGION_COLUMNS','HEADING','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Heading');
    ins(422,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_01','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 01.');
    ins(423,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_02','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 02.');
    ins(424,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_03','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 03.');
    ins(425,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_04','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 04.');
    ins(426,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_05','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 05.');
    ins(427,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_06','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 06.');
    ins(428,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_07','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 07.');
    ins(429,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_08','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 08.');
    ins(430,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_09','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 09.');
    ins(431,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_10','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 10.');
    ins(432,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_11','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 11.');
    ins(433,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_12','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 12.');
    ins(434,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_13','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 13.');
    ins(435,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_14','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 14.');
    ins(436,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_15','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 15.');
    ins(437,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_16','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 16.');
    ins(438,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_17','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 17.');
    ins(439,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_18','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 18.');
    ins(440,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_19','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 19.');
    ins(441,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_20','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 20.');
    ins(442,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_21','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 21.');
    ins(443,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_22','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 22.');
    ins(444,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_23','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 23.');
    ins(445,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_24','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 24.');
    ins(446,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_25','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 25.');
    ins(447,'WWV_FLOW_PLUGIN_ATTRIBUTES','UNIT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(448,'WWV_FLOW_REGION_COLUMNS','LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','An alternative column label');
    ins(449,'WWV_FLOW_REGION_COLUMNS','ITEM_PLACEHOLDER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','The hint text when no value for that item is entered');
    ins(450,'WWV_FLOW_REGION_COLUMNS','LOV_NULL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Value displayed when null selected from LOV');
    ins(451,'WWV_FLOW_REGION_COLUMNS','LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','The text to be shown as a link');
    ins(452,'WWV_FLOW_REGION_COLUMNS','HELP_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Help text for the column');
    ins(453,'WWV_FLOW_REGION_COLUMN_GROUPS','LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','An alternative group label');
    ins(454,'WWV_FLOW_REGION_COLUMN_GROUPS','HEADING','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Group heading text');
    ins(455,'WWV_FLOW_INTERACTIVE_GRIDS','NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when the query does not return any rows');
    ins(456,'WWV_FLOW_INTERACTIVE_GRIDS','MAX_ROW_COUNT_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when more rows are returned from the query than the maximum row count entered');
    ins(457,'WWV_FLOW_INTERACTIVE_GRIDS','ADD_BUTTON_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','An alternative label for the Add button');
    ins(458,'WWV_FLOW_STEP_ITEMS','INLINE_HELP_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Item Inline help text.');
    ins(459,'WWV_FLOW_FIELD_TEMPLATES','ITEM_PRE_TEXT','ID','FLOW_ID','','VARCHAR2','Y','HTML template to format "Item Pre Test", typically does not include translatable text');
    ins(460,'WWV_FLOW_FIELD_TEMPLATES','ITEM_POST_TEXT','ID','FLOW_ID','','VARCHAR2','Y','HTML template to format "Item Post Test", typically does not include translatable text');
    ins(461,'WWV_FLOW_JET_CHARTS','TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart title');
    ins(462,'WWV_FLOW_JET_CHARTS','LEGEND_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart legend title');
    ins(463,'WWV_FLOW_JET_CHARTS','NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart query no data found message');
    ins(464,'WWV_FLOW_JET_CHARTS','CUSTOM_TOOLTIP','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart custom tooltip');
    ins(465,'WWV_FLOW_JET_CHART_AXES','TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart axis title');
    ins(466,'WWV_FLOW_JET_CHART_SERIES','NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart series name');
    ins(467,'WWV_FLOW_PLUGIN_STD_ATTRIBUTES','EXAMPLES','ID','FLOW_ID','','VARCHAR2','N','');
    ins(468,'WWV_FLOW_PLUGIN_STD_ATTRIBUTES','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(469,'WWV_FLOW_EMAIL_TEMPLATES','SUBJECT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(470,'WWV_FLOW_EMAIL_TEMPLATES','HTML_BODY','ID','FLOW_ID','','VARCHAR2','N','');
    ins(471,'WWV_FLOW_EMAIL_TEMPLATES','HTML_HEADER','ID','FLOW_ID','','VARCHAR2','N','');
    ins(472,'WWV_FLOW_EMAIL_TEMPLATES','HTML_FOOTER','ID','FLOW_ID','','VARCHAR2','N','');
    ins(473,'WWV_FLOW_EMAIL_TEMPLATES','HTML_TEMPLATE','ID','FLOW_ID','','VARCHAR2','N','');
    ins(474,'WWV_FLOW_EMAIL_TEMPLATES','TEXT_TEMPLATE','ID','FLOW_ID','','VARCHAR2','N','');
    ins(475,'WWV_FLOW_LIST_OF_VALUES_COLS','HEADING','ID','FLOW_ID','','VARCHAR2','N','The heading used for the column in the dialog / popup');
    ins(476,'WWV_FLOWS','LOGO_TEXT','ID','ID','','VARCHAR2','N','Logo Text');
    ins(477,'WWV_FLOW_PAGE_PLUGS','SUPPLEMENTAL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text at the top of all download formats');
    ins(478,'WWV_FLOW_WORKSHEETS','SUPPLEMENTAL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text at the top of all download formats');
    ins(479,'WWV_FLOW_INTERACTIVE_GRIDS','SUPPLEMENTAL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text at the top of all download formats');
    --
    flush;
    commit;
end;
/

prompt
prompt ...insert into wwv_flow_sw_sqlplus_cmd
prompt

delete wwv_flow_sw_sqlplus_cmd
/

insert into wwv_flow_sw_sqlplus_cmd
values('PROMPT')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SET')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SPOOL')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SHOW')
/
insert into wwv_flow_sw_sqlplus_cmd
values('REM')
/
insert into wwv_flow_sw_sqlplus_cmd
values('/')
/
insert into wwv_flow_sw_sqlplus_cmd
values('@@')
/
insert into wwv_flow_sw_sqlplus_cmd
values('WHENEVER')
/
commit
/


prompt
prompt ...insert into wwv_flow_sw_main_keywords
prompt

declare
    procedure ins_kw (
        p_id         in wwv_flow_sw_main_keywords.id%type,
        p_keyword    in wwv_flow_sw_main_keywords.keyword%type,
        p_stmt_class in wwv_flow_sw_main_keywords.stmt_class%type,
        p_stmt_id    in wwv_flow_sw_main_keywords.stmt_id%type,
        p_isrunnable in wwv_flow_sw_main_keywords.isrunnable%type )
    is
    begin
        insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable )
        values (p_id, p_keyword, p_stmt_class, p_stmt_id, p_isrunnable );
    end ins_kw;
begin
    delete from wwv_flow_sw_main_keywords;
    ins_kw(1   , 'REM'          , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(2   , 'INSERT'       , 2 /* G_C_SQL */             , 48 /* G_S_INSERT */        , 'Y');
    ins_kw(3   , 'CREATE'       , 10 /* G_C_UNKNOWN_CREATE */ , 1 /* G_S_UNKNOWN */        , 'N');
    ins_kw(4   , 'DROP'         , 2 /* G_C_SQL */             , 35 /* G_S_DROP */          , 'Y');
    ins_kw(5   , 'GRANT'        , 2 /* G_C_SQL */             , 43 /* G_S_GRANT */         , 'Y');
    ins_kw(6   , 'ALTER'        , 2 /* G_C_SQL */             , 3 /* G_S_ALTER */          , 'Y');
    ins_kw(7   , 'SELECT'       , 2 /* G_C_SQL */             , 72 /* G_S_SELECT */        , 'Y');
    ins_kw(8   , 'UPDATE'       , 2 /* G_C_SQL */             , 88 /* G_S_UPDATE */        , 'Y');
    ins_kw(9   , 'BEGIN'        , 3 /* G_C_PLSQL */           , 12 /* G_S_BEGIN */         , 'Y');
    ins_kw(10  , 'DECLARE'      , 3 /* G_C_PLSQL */           , 28 /* G_S_DECLARE */       , 'Y');
    ins_kw(11  , 'DELETE'       , 2 /* G_C_SQL */             , 31 /* G_S_DELETE */        , 'Y');
    ins_kw(12  , 'COL'          , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(13  , 'COLU'         , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(14  , 'COLUM'        , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(15  , 'COLUMN'       , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(16  , 'SET'          , 9 /* G_C_UNKNOWN_SET */     , 1 /* G_S_UNKNOWN */        , 'N');
    ins_kw(17  , 'VAR'          , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(18  , 'VARI'         , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(19  , 'VARIA'        , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(20  , 'VARIAB'       , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(21  , 'VARIABL'      , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(22  , 'VARIABLE'     , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(23  , 'PRO'          , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(24  , 'PROM'         , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(25  , 'PROMP'        , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(26  , 'PROMPT'       , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(27  , 'EXEC'         , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(28  , 'EXECU'        , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(29  , 'EXECUT'       , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(30  , 'EXECUTE'      , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(31  , 'SHO'          , 4 /* G_C_SQLPLUS */         , 75 /* G_S_SHOW */          , 'N');
    ins_kw(32  , 'SHOW'         , 4 /* G_C_SQLPLUS */         , 75 /* G_S_SHOW */          , 'N');
    ins_kw(33  , 'WHENEVER'     , 4 /* G_C_SQLPLUS */         , 91 /* G_S_WHENEVER */      , 'N');
    ins_kw(34  , 'SPO'          , 4 /* G_C_SQLPLUS */         , 78 /* G_S_SPOOL */         , 'N');
    ins_kw(35  , 'SPOO'         , 4 /* G_C_SQLPLUS */         , 78 /* G_S_SPOOL */         , 'N');
    ins_kw(36  , 'SPOOL'        , 4 /* G_C_SQLPLUS */         , 78 /* G_S_SPOOL */         , 'N');
    ins_kw(37  , 'DEF'          , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(38  , 'DEFI'         , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(39  , 'DEFIN'        , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(40  , 'DEFINE'       , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(41  , 'STA'          , 4 /* G_C_SQLPLUS */         , 81 /* G_S_START */         , 'Y');
    ins_kw(42  , 'STAR'         , 4 /* G_C_SQLPLUS */         , 81 /* G_S_START */         , 'Y');
    ins_kw(43  , 'START'        , 4 /* G_C_SQLPLUS */         , 81 /* G_S_START */         , 'Y');
    ins_kw(44  , 'BRE'          , 4 /* G_C_SQLPLUS */         , 14 /* G_S_BREAK */         , 'N');
    ins_kw(45  , 'BREA'         , 4 /* G_C_SQLPLUS */         , 14 /* G_S_BREAK */         , 'N');
    ins_kw(46  , 'BREAK'        , 4 /* G_C_SQLPLUS */         , 14 /* G_S_BREAK */         , 'N');
    ins_kw(47  , 'COMP'         , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(48  , 'COMPU'        , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(49  , 'COMPUT'       , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(50  , 'COMPUTE'      , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(51  , 'CONN'         , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(52  , 'CONNE'        , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(53  , 'CONNEC'       , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(54  , 'CONNECT'      , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(55  , 'EXIT'         , 4 /* G_C_SQLPLUS */         , 39 /* G_S_EXIT */          , 'N');
    ins_kw(56  , 'QUIT'         , 4 /* G_C_SQLPLUS */         , 61 /* G_S_QUIT */          , 'N');
    ins_kw(57  , 'DESC'         , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(58  , 'DESCR'        , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(59  , 'DESCRI'       , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(60  , 'DESCRIB'      , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(61  , 'DESCRIBE'     , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(62  , 'FLASHBACK'    , 2 /* G_C_SQL */             , 41 /* G_S_FLASHBACK */     , 'N');
    ins_kw(63  , 'COMMIT'       , 2 /* G_C_SQL */             , 21 /* G_S_COMMIT */        , 'Y');
    ins_kw(64  , 'ROLLBACK'     , 2 /* G_C_SQL */             , 68 /* G_S_ROLLBACK_SQL */  , 'Y');
    ins_kw(65  , 'CALL'         , 2 /* G_C_SQL */             , 16 /* G_S_CALL */          , 'N');
    ins_kw(66  , 'LOCK'         , 2 /* G_C_SQL */             , 50 /* G_S_LOCK */          , 'N');
    ins_kw(67  , 'MERGE'        , 2 /* G_C_SQL */             , 51 /* G_S_MERGE */         , 'Y');
    ins_kw(68  , 'PURGE'        , 2 /* G_C_SQL */             , 60 /* G_S_PURGE */         , 'N');
    ins_kw(69  , 'EXPLAIN'      , 2 /* G_C_SQL */             , 40 /* G_S_EXPLAIN */       , 'N');
    ins_kw(70  , 'ANALYZE'      , 2 /* G_C_SQL */             , 4 /* G_S_ANALYZE */        , 'Y');
    ins_kw(71  , 'VALIDATE'     , 2 /* G_C_SQL */             , 89 /* G_S_VALIDATE */      , 'N');
    ins_kw(72  , 'TRUNCATE'     , 2 /* G_C_SQL */             , 85 /* G_S_TRUNCATE */      , 'Y');
    ins_kw(73  , 'WITH'         , 2 /* G_C_SQL */             , 92 /* G_S_WITH */          , 'Y');
    ins_kw(74  , 'REVOKE'       , 2 /* G_C_SQL */             , 66 /* G_S_REVOKE */        , 'Y');
    ins_kw(75  , 'RENAME'       , 2 /* G_C_SQL */             , 63 /* G_S_RENAME */        , 'N');
    ins_kw(76  , 'SAVEPOINT'    , 2 /* G_C_SQL */             , 71 /* G_S_SAVEPOINT */     , 'N');
    ins_kw(77  , 'AUDIT'        , 2 /* G_C_SQL */             , 11 /* G_S_AUDIT */         , 'N');
    ins_kw(78  , 'NOAUDIT'      , 2 /* G_C_SQL */             , 53 /* G_S_NOAUDIT */       , 'N');
    ins_kw(79  , 'ASSOCIATE'    , 2 /* G_C_SQL */             , 7 /* G_S_ASSOCIATE */      , 'N');
    ins_kw(80  , 'DISASSOCIATE' , 2 /* G_C_SQL */             , 33 /* G_S_DISASSOCIATE */  , 'N');
    ins_kw(81  , 'EXPAND'       , 2 /* G_C_SQL */             , 38 /* G_S_EXPAND */        , 'N');
    ins_kw(82  , 'COMMENT'      , 2 /* G_C_SQL */             , 20 /* G_S_COMMENT_SQL */   , 'Y');
    ins_kw(83  , 'XQUERY'       , 3 /* G_C_PLSQL */           , 93 /* G_S_XQUERY */        , 'N');
    ins_kw(84  , 'COPY'         , 4 /* G_C_SQLPLUS */         , 25 /* G_S_COPY */          , 'N');
    ins_kw(85  , 'DISC'         , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(86  , 'DISCO'        , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(87  , 'DISCON'       , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(88  , 'DISCONN'      , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(89  , 'DISCONNE'     , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(90  , 'DISCONNEC'    , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(91  , 'DISCONNECT'   , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(92  , 'TIMI'         , 4 /* G_C_SQLPLUS */         , 84 /* G_S_TIMING */        , 'N');
    ins_kw(93  , 'TIMIN'        , 4 /* G_C_SQLPLUS */         , 84 /* G_S_TIMING */        , 'N');
    ins_kw(94  , 'TIMING'       , 4 /* G_C_SQLPLUS */         , 84 /* G_S_TIMING */        , 'N');
    ins_kw(95  , 'GET'          , 4 /* G_C_SQLPLUS */         , 42 /* G_S_GET */           , 'N');
    ins_kw(96  , 'HELP'         , 4 /* G_C_SQLPLUS */         , 46 /* G_S_HELP */          , 'N');
    ins_kw(97  , 'PRINT'        , 4 /* G_C_SQLPLUS */         , 58 /* G_S_PRINT */         , 'N');
    ins_kw(98  , 'UNDEF'        , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(99  , 'UNDEFI'       , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(100 , 'UNDEFIN'      , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(101 , 'UNDEFINE'     , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(102 , 'TTI'          , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(103 , 'TTIT'         , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(104 , 'TTITL'        , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(105 , 'TTITLE'       , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(106 , 'BTI'          , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(107 , 'BTIT'         , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(108 , 'BTITL'        , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(109 , 'BTITLE'       , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(110 , 'REPF'         , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(111 , 'REPFO'        , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(112 , 'REPFOO'       , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(113 , 'REPFOOT'      , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(114 , 'REPFOOTE'     , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(115 , 'REPFOOTER'    , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(116 , 'REPH'         , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(117 , 'REPHE'        , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(118 , 'REPHEA'       , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(119 , 'REPHEAD'      , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(120 , 'REPHEADE'     , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(121 , 'REPHEADER'    , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(122 , 'ATTR'         , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(123 , 'ATTRI'        , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(124 , 'ATTRIB'       , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(125 , 'ATTRIBU'      , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(126 , 'ATTRIBUT'     , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(127 , 'ATTRIBUTE'    , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(128 , 'STORE'        , 4 /* G_C_SQLPLUS */         , 83 /* G_S_STORE */         , 'N');
    ins_kw(129 , 'R'            , 4 /* G_C_SQLPLUS */         , 69 /* G_S_RUN */           , 'N');
    ins_kw(130 , 'RU'           , 4 /* G_C_SQLPLUS */         , 69 /* G_S_RUN */           , 'N');
    ins_kw(131 , 'RUN'          , 4 /* G_C_SQLPLUS */         , 69 /* G_S_RUN */           , 'N');
    ins_kw(132 , 'SAV'          , 4 /* G_C_SQLPLUS */         , 70 /* G_S_SAVE */          , 'N');
    ins_kw(133 , 'SAVE'         , 4 /* G_C_SQLPLUS */         , 70 /* G_S_SAVE */          , 'N');
    ins_kw(134 , 'ORADEBUG'     , 4 /* G_C_SQLPLUS */         , 54 /* G_S_ORADEBUG */      , 'N');
    ins_kw(135 , 'PASSW'        , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(136 , 'PASSWO'       , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(137 , 'PASSWOR'      , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(138 , 'PASSWORD'     , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(139 , 'PAU'          , 4 /* G_C_SQLPLUS */         , 56 /* G_S_PAUSE */         , 'N');
    ins_kw(140 , 'PAUS'         , 4 /* G_C_SQLPLUS */         , 56 /* G_S_PAUSE */         , 'N');
    ins_kw(141 , 'PAUSE'        , 4 /* G_C_SQLPLUS */         , 56 /* G_S_PAUSE */         , 'N');
    ins_kw(142 , 'REMA'         , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(143 , 'REMAR'        , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(144 , 'REMARK'       , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(145 , 'HO'           , 4 /* G_C_SQLPLUS */         , 44 /* G_S_HOST */          , 'N');
    ins_kw(146 , 'HOS'          , 4 /* G_C_SQLPLUS */         , 44 /* G_S_HOST */          , 'N');
    ins_kw(147 , 'HOST'         , 4 /* G_C_SQLPLUS */         , 44 /* G_S_HOST */          , 'N');
    ins_kw(148 , 'ACC'          , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(149 , 'ACCE'         , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(150 , 'ACCEP'        , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(151 , 'ACCEPT'       , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(152 , 'ED'           , 4 /* G_C_SQLPLUS */         , 36 /* G_S_EDIT */          , 'N');
    ins_kw(153 , 'EDI'          , 4 /* G_C_SQLPLUS */         , 36 /* G_S_EDIT */          , 'N');
    ins_kw(154 , 'EDIT'         , 4 /* G_C_SQLPLUS */         , 36 /* G_S_EDIT */          , 'N');
    ins_kw(155 , 'A'            , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(156 , 'AP'           , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(157 , 'APP'          , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(158 , 'APPE'         , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(159 , 'APPEN'        , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(160 , 'APPEND'       , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(161 , 'C'            , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(162 , 'CH'           , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(163 , 'CHA'          , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(164 , 'CHAN'         , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(165 , 'CHANG'        , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(166 , 'CHANGE'       , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(167 , 'CL'           , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(168 , 'CLE'          , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(169 , 'CLEA'         , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(170 , 'CLEAR'        , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(171 , 'I'            , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(172 , 'IN'           , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(173 , 'INP'          , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(174 , 'INPU'         , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(175 , 'INPUT'        , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(176 , 'L'            , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(177 , 'LI'           , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(178 , 'LIS'          , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(179 , 'LIST'         , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(180 , 'DEL'          , 4 /* G_C_SQLPLUS */         , 30 /* G_S_DEL_PLUS */      , 'N');
    ins_kw(181 , 'ARCHIVE'      , 4 /* G_C_SQLPLUS */         , 6 /* G_S_ARCHIVE */        , 'N');
    ins_kw(182 , 'SHU'          , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(183 , 'SHUT'         , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(184 , 'SHUTD'        , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(185 , 'SHUTDOW'      , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(186 , 'SHUTDOWN'     , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(187 , 'STARTUP'      , 4 /* G_C_SQLPLUS */         , 82 /* G_S_STARTUP */       , 'N');
    ins_kw(188 , 'RECOVER'      , 4 /* G_C_SQLPLUS */         , 62 /* G_S_RECOVER */       , 'N');
    ins_kw(189 , 'DOC'          , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(190 , 'DOCU'         , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(191 , 'DOCUM'        , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(192 , 'DOCUME'       , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(193 , 'DOCUMEN'      , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(194 , 'DOCUMENT'     , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(195 , 'ROLL'         , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(196 , 'ROLLB'        , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(197 , 'ROLLBA'       , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(198 , 'ROLLBAC'      , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(199 , 'NEWPAGE'      , 4 /* G_C_SQLPLUS */         , 52 /* G_S_NEWPAGE */       , 'N');
    commit;
end;
/

prompt
prompt ...insert into wwv_flow_charsets
prompt

declare
    procedure ins_cs (
        p_id           in wwv_flow_charsets.id%type,
        p_display_name in wwv_flow_charsets.display_name%type,
        p_iana_charset in wwv_flow_charsets.iana_charset%type,
        p_db_charset   in wwv_flow_charsets.db_charset%type )
    is
    begin
        insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset )
        values (p_id, p_display_name, p_iana_charset, p_db_charset );
    end ins_cs;
begin
    delete from wwv_flow_charsets;
    ins_cs(1,'Arabic ISO-8859-6','iso-8859-6','AR8ISO8859P6');
    ins_cs(2, 'Arabic Windows 1256','windows-1256','AR8MSWIN1256');
    ins_cs(3, 'Chinese Big5','big5','ZHT16MSWIN950');
    ins_cs(4, 'Chinese GBK','gbk','ZHS16GBK');
    ins_cs(5, 'Cyrilic ISO-8859-5','iso-8859-5','CL8ISO8859P5');
    ins_cs(6, 'Cyrilic KOI8-R','koi8-r','CL8KOI8R');
    ins_cs(7, 'Cyrilic KOI8-U','koi8-u','CL8KOI8U');
    ins_cs(8, 'Cyrilic Windows 1251','windows-1251','CL8MSWIN1251');
    ins_cs(9, 'Eastern European ISO-8859-2','iso-8859-2','EE8ISO8859P2');
    ins_cs(10, 'Eastern European Windows 1250','windows-1250','EE8MSWIN1250');
    ins_cs(11, 'Greek ISO-8859-7','iso-8859-7','EL8ISO8859P7');
    ins_cs(12, 'Greek Windows 1253','windows-1253','EL8MSWIN1253');
    ins_cs(13, 'Hebrew ISO-8859-8-i','iso-8859-8-i','IW8ISO8859P8');
    ins_cs(14, 'Hebrew Windows 1255','windows-1255','IW8MSWIN1255');
    ins_cs(15, 'Japanese EUC','euc-jp','JA16EUC');
    ins_cs(16, 'Japanese Shift JIS','shift_jis','JA16SJIS');
    ins_cs(17, 'Korean EUC','euc-kr','KO16MSWIN949');
    ins_cs(18, 'Northern European ISO-8859-4','iso-8859-4','NEE8ISO8859P4');
    ins_cs(19, 'Northern European Windows 1257','windows-1257','BLT8MSWIN1257');
    ins_cs(20, 'Southern European ISO-8859-3','iso-8859-3','SE8ISO8859P3');
    ins_cs(21, 'Thai TIS-620','tis-620','TH8TISASCII');
    ins_cs(22, 'Turkish ISO-8859-9','iso-8859-9','WE8ISO8859P9');
    ins_cs(23, 'Turkish Windows 1254','windows-1254','TR8MSWIN1254');
    ins_cs(24, 'Unicode UTF-8','utf-8','AL32UTF8');
    ins_cs(25, 'Unicode UTF-16 Big Endian','utf-16be','AL16UTF16');
    ins_cs(26, 'Unicode UTF-16 Little Endian','utf-16le','AL16UTF16LE');
    ins_cs(27, 'Vietnamese Windows 1258','windows-1258','VN8MSWIN1258');
    ins_cs(28, 'Western European ISO-8859-1','iso-8859-1','WE8ISO8859P1');
    ins_cs(29, 'Western European ISO-8859-15','iso-8859-15','WE8ISO8859P15');
    ins_cs(30, 'Western European Windows 1252','windows-1252','WE8MSWIN1252');
    ins_cs(31, 'Chinese EUC','euc-tw','ZHT32EUC');
    ins_cs(32, 'US-ASCII','us-ascii','US7ASCII');
    commit;
end;
/

prompt
prompt ...insert into wwv_flow_standard_icons
prompt

declare
    procedure ins_icon (
        p_icon_name    in wwv_flow_standard_icons.icon_name%type,
        p_icon_size    in wwv_flow_standard_icons.icon_size%type,
        p_icon_library in wwv_flow_standard_icons.icon_library%type )
    is
    begin
        insert into wwv_flow_standard_icons(icon_name,icon_size,icon_library )
        values ( p_icon_name, p_icon_size, p_icon_library );
    end ins_icon;
begin
    delete from wwv_flow_standard_icons;
    --
    -- apex 3.1 16x16 images
    --
    ins_icon('blue_function_16x16.gif',16,'APEX');
    ins_icon('blue_folder_16x16.gif',16,'APEX');
    ins_icon('blue_info_16x16.gif',16,'APEX');
    ins_icon('edit_16x16.gif',16,'APEX');
    ins_icon('check2_16x16.gif',16,'APEX');
    ins_icon('attach_16x16.gif',16,'APEX');
    ins_icon('Fndtre_info_16x16.gif',16,'APEX');
    ins_icon('go_button_16x16.gif',16,'APEX');
    ins_icon('hs_infohidden_16x16.gif',16,'APEX');
    ins_icon('icon_button_16x16.gif',16,'APEX');
    ins_icon('icon_comp_16x16.gif',16,'APEX');
    ins_icon('icon_item_16x16.gif',16,'APEX');
    ins_icon('icon_page_16x16.gif',16,'APEX');
    ins_icon('icon_process_16x16.gif',16,'APEX');
    ins_icon('icon_region_16x16.gif',16,'APEX');
    ins_icon('icon_validation_16x16.gif',16,'APEX');
    ins_icon('idle_session_16x16.gif',16,'APEX');
    ins_icon('i_status_16x16.gif',16,'APEX');
    ins_icon('i_status_gray_16x16.gif',16,'APEX');
    ins_icon('inline_error_16x16.gif',16,'APEX');
    ins_icon('jtfuhide_16x16.gif',16,'APEX');
    ins_icon('jtfunexe_16x16.gif',16,'APEX');
    ins_icon('jtfupree_16x16.gif',16,'APEX');
    ins_icon('jtfushow_16x16.gif',16,'APEX');
    ins_icon('locks_16x16.gif',16,'APEX');
    ins_icon('long_trans_16x16.gif',16,'APEX');
    ins_icon('pkt_stats_16x16.gif',16,'APEX');
    ins_icon('pkt_studygu_16x16.gif',16,'APEX');
    ins_icon('pobcol_16x16.gif',16,'APEX');
    ins_icon('pobrow_16x16.gif',16,'APEX');
    ins_icon('icon_status_16x16.gif',16,'APEX');
    ins_icon('icon_status2_16x16.gif',16,'APEX');
    ins_icon('icon_status_red_16x16.gif',16,'APEX');
    ins_icon('rup_minus_dgray_16x16.gif',16,'APEX');
    ins_icon('rup_plus_dgray_16x16.gif',16,'APEX');
    ins_icon('small_chart_16x16.gif',16,'APEX');
    ins_icon('wwv_smprt_16x16.gif',16,'APEX');
    ins_icon('pencil16x16.gif',16,'APEX');
    --
    -- apex 3.1 140x90 images
    --
    ins_icon('wiz_blank_140x90.gif',140,'APEX');
    ins_icon('wiz_multiple_140x90.gif',140,'APEX');
    ins_icon('wiz_classic_report_140x90.gif',140,'APEX');
    ins_icon('wiz_flash_chart_140x90.gif',140,'APEX');
    ins_icon('wiz_calendar_140x90.gif',140,'APEX');
    ins_icon('wiz_access_ctrl_140x90.gif',140,'APEX');
    ins_icon('wiz_interactive_report_140x90.gif',140,'APEX');
    ins_icon('wiz_webservices_report_140x90.gif',140,'APEX');
    ins_icon('wiz_ez_report_140x90.gif',140,'APEX');
    ins_icon('wiz_tree_140x90.gif',140,'APEX');
    ins_icon('wiz_svg_chart_140x90.gif',140,'APEX');
    ins_icon('wiz_html_chart_140x90.gif',140,'APEX');
    ins_icon('wiz_help_140x90.gif',140,'APEX');
    ins_icon('wiz_plsql_140x90.gif',140,'APEX');
    ins_icon('wiz_ez_calendar_140x90.gif',140,'APEX');
    --
    -- apex 3.1 128x128 images
    --
    ins_icon('app_bx_128x128.png',128,'APEX');
    ins_icon('biz_users_bx_128x128.png',128,'APEX');
    ins_icon('bug_bx_128x128.png',128,'APEX');
    ins_icon('convert_bx_128x128.png',128,'APEX');
    ins_icon('doc_library_bx_128x128.png',128,'APEX');
    ins_icon('eba_tube_featured_bx_128x128.png',128,'APEX');
    ins_icon('issue_tracker_bx_128x128.png',128,'APEX');
    ins_icon('movie_bx_128x128.png',128,'APEX');
    ins_icon('page_bx_128x128.png',128,'APEX');
    ins_icon('ws_from_database.png',128,'APEX');
    ins_icon('ws_from_scratch.png',128,'APEX');
    ins_icon('ws_from_template.png',128,'APEX');
    ins_icon('blank_bx_128x128.png',128,'APEX');
    ins_icon('home_bx_128x128.png',128,'APEX');
    ins_icon('mail_bx_128x128.png',128,'APEX');
    ins_icon('globe_americas_bx_128x128.png',128,'APEX');
    ins_icon('recycle_bx_128x128.png',128,'APEX');
    ins_icon('bug_report_bx_128x128.png',128,'APEX');
    ins_icon('users_bx_128x128.png',128,'APEX');
    ins_icon('wizreport_bx_128x128.png',128,'APEX');
    ins_icon('paintbrush_bx_128x128.png',128,'APEX');
    ins_icon('report_w_globe_bx_128x128.png',128,'APEX');
    ins_icon('interactive_report_bx_128x128.png',128,'APEX');
    ins_icon('barchart_bx_128x128.png',128,'APEX');
    ins_icon('clusterchart_bx_128x128.png',128,'APEX');
    ins_icon('chart_bx_128x128.png',128,'APEX');
    ins_icon('monitor_bx_128x128.png',128,'APEX');
    ins_icon('db_grey_bx_128x128.png',128,'APEX');
    ins_icon('barchart2_bx_128x128.png',128,'APEX');
    ins_icon('clusterchart2_bx_128x128.png',128,'APEX');
    ins_icon('wizard_bx_128x128.png',128,'APEX');
    ins_icon('temperature_bx_128x128.png',128,'APEX');
    ins_icon('census_bx_128x128.png',128,'APEX');
    ins_icon('modern_printer_bx_128x128.png',128,'APEX');
    ins_icon('navigation_bx_128x128.png',128,'APEX');
    ins_icon('gear_bx_128x128.png',128,'APEX');
    ins_icon('law_bx_128x128.png',128,'APEX');
    ins_icon('buildings_bx_128x128.png',128,'APEX');
    ins_icon('address_book_bx_128x128.png',128,'APEX');
    ins_icon('addresses_bx_128x128.png',128,'APEX');
    ins_icon('biz_user_green_bx_128x128.png',128,'APEX');
    ins_icon('biz_user_red_bx_128x128.png',128,'APEX');
    ins_icon('biz_user_yellow_bx_128x128.png',128,'APEX');
    ins_icon('brush_bx_128x128.png',128,'APEX');
    ins_icon('calendar_bx_128x128.png',128,'APEX');
    ins_icon('camera_bx_128x128.png',128,'APEX');
    ins_icon('computer_bx_128x128.png',128,'APEX');
    ins_icon('dashboard_bx_128x128.png',128,'APEX');
    ins_icon('database_bx_128x128.png',128,'APEX');
    ins_icon('db_blue_bx_128x128.png',128,'APEX');
    ins_icon('discussion_bx_128x128.png',128,'APEX');
    ins_icon('display_bx_128x128.png',128,'APEX');
    ins_icon('download_bx_128x128.png',128,'APEX');
    ins_icon('eba_admin_bx_128x128.png',128,'APEX');
    ins_icon('eba_artwork_bx_128x128.png',128,'APEX');
    ins_icon('eba_checklist_bx_128x128.png',128,'APEX');
    ins_icon('eba_sales_products_bx_128x128.png',128,'APEX');
    ins_icon('eba_software_bx_128x128.png',128,'APEX');
    ins_icon('eba_timesheets_bx_128x128.png',128,'APEX');
    ins_icon('edit_bx_128x28.png',128,'APEX');
    ins_icon('filmroll_bx_128x128.png',128,'APEX');
    ins_icon('flashlight_bx_128x128.png',128,'APEX');
    ins_icon('folder_bx_128x128.png',128,'APEX');
    ins_icon('generate_bx_128x128.png',128,'APEX');
    ins_icon('globe_bx_128x128.png',128,'APEX');
    ins_icon('lightbulb_bx_128x128.png',128,'APEX');
    ins_icon('openbook_bx_128x128.png',128,'APEX');
    ins_icon('pencil_bx_128x128.png',128,'APEX');
    ins_icon('piechart_bx_128x128.png',128,'APEX');
    ins_icon('podcase_bx_128x128.png',128,'APEX');
    ins_icon('printer_bx_128x128.png',128,'APEX');
    ins_icon('report_bx_128x128.png',128,'APEX');
    ins_icon('shapes_bx_128x128.png',128,'APEX');
    ins_icon('shoppingcart_bx_128x128.png',128,'APEX');
    ins_icon('student_bx_128x128.png',128,'APEX');
    ins_icon('upload_bx_128x128.png',128,'APEX');
    ins_icon('faces128.png',128,'APEX');
    --
    -- apex 4.0 12x12 images
    --
    ins_icon('go-small.png',12,'APEX');
    ins_icon('edit-small.png',12,'APEX');
    ins_icon('add-small.png',12,'APEX');
    ins_icon('search-small.png',12,'APEX');
    ins_icon('minus-small.png',12,'APEX');
    ins_icon('edit-pencil-small.png',12,'APEX');
    --
    -- apex 4.0 128x128 images
    --
    ins_icon('menu-page-128.png',128,'APEX');
    ins_icon('menu-disk-128.png',128,'APEX');
    ins_icon('menu-add_hw-128.gif',128,'APEX');
    ins_icon('menu-add-page-128.png',128,'APEX');
    ins_icon('menu-admin-128.gif',128,'APEX');
    ins_icon('menu-app-128.png',128,'APEX');
    ins_icon('menu-appbuilder-128.gif',128,'APEX');
    ins_icon('menu-blank-128.gif',128,'APEX');
    ins_icon('menu-blank-128.png',128,'APEX');
    ins_icon('menu-bug-128.gif',128,'APEX');
    ins_icon('menu-camera-128.gif',128,'APEX');
    ins_icon('menu-calendar-128.png',128,'APEX');
    ins_icon('menu-change-log-128.png',128,'APEX');
    ins_icon('menu-chart-128.png',128,'APEX');
    ins_icon('menu-clipboard-128.gif',128,'APEX');
    ins_icon('menu-dashboard-128.gif',128,'APEX');
    ins_icon('menu-db-monitor-128.gif',128,'APEX');
    ins_icon('menu-dbmonitor-128.gif',128,'APEX');
    ins_icon('menu-discussion-128.gif',128,'APEX');
    ins_icon('menu-docs-128.gif',128,'APEX');
    ins_icon('menu-docsettings-128.gif',128,'APEX');
    ins_icon('menu-dynaction-128.png',128,'APEX');
    ins_icon('menu-expimp-128.gif',128,'APEX');
    ins_icon('menu-feedback-128.gif',128,'APEX');
    ins_icon('menu-globe-128.png',128,'APEX');
    ins_icon('menu-home-128.gif',128,'APEX');
    ins_icon('menu-instance-manage-128.gif',128,'APEX');
    ins_icon('menu-lightbulb-128.gif',128,'APEX');
    ins_icon('menu-mail-128.gif',128,'APEX');
    ins_icon('menu-megaphone-128.gif',128,'APEX');
    ins_icon('menu-nested-128.png',128,'APEX');
    ins_icon('menu-ob-128.gif',128,'APEX');
    ins_icon('menu-objects-128.png',128,'APEX');
    ins_icon('menu-page-dir-128.gif',128,'APEX');
    ins_icon('menu-pkg-128.gif',128,'APEX');
    ins_icon('menu-plugin-128.png',128,'APEX');
    ins_icon('menu-qb-128.gif',128,'APEX');
    ins_icon('menu-run-128.gif',128,'APEX');
    ins_icon('menu-shared-128.gif',128,'APEX');
    ins_icon('menu-sqlcmd-128.gif',128,'APEX');
    ins_icon('menu-sqlscripts-128.gif',128,'APEX');
    ins_icon('menu-sqlws-128.gif',128,'APEX');
    ins_icon('menu-supporting-obj-128.gif',128,'APEX');
    ins_icon('menu-tabform-128.png',128,'APEX');
    ins_icon('menu-tasks-128.gif',128,'APEX');
    ins_icon('menu-teamdev-128.gif',128,'APEX');
    ins_icon('menu-trash-128.gif',128,'APEX');
    ins_icon('menu-uidefaults-128.gif',128,'APEX');
    ins_icon('menu-users-128.gif',128,'APEX');
    ins_icon('menu-util-128.gif',128,'APEX');
    ins_icon('menu-webservice-128.png',128,'APEX');
    ins_icon('menu-websheets-128.gif',128,'APEX');
    ins_icon('menu-ws-add-128.gif',128,'APEX');
    ins_icon('menu-ws-info-128.png',128,'APEX');
    ins_icon('menu-ws-learn-128.png',128,'APEX');
    ins_icon('menu-ws-manage-128.gif',128,'APEX');
    --
    -- apex 4.0 64x64 images
    --
    ins_icon('bug_new_64.png',64,'APEX');
    --
    -- apex 3.1 64x64 images
    --
    ins_icon('address_book_wbg_64x64.png',64,'APEX');
    ins_icon('addresses_wbg_64x64.png',64,'APEX');
    ins_icon('flashlight_wbg_64x64.png',64,'APEX');
    ins_icon('pencil_wbg_64x64.png',64,'APEX');
    ins_icon('camera_wbg_64x64.png',64,'APEX');
    ins_icon('buildings_wbg_64x64.png',64,'APEX');
    ins_icon('eba_software_wbg_64x64.png',64,'APEX');
    ins_icon('eba_timesheets_wbg_64x64.png',64,'APEX');
    ins_icon('filmroll_wbg_64x64.png',64,'APEX');
    ins_icon('instructor_wbg_64x64.png',64,'APEX');
    ins_icon('generate_wbg_64x64.png',64,'APEX');
    ins_icon('law_wbg_64x64.png',64,'APEX');
    ins_icon('discussion_wbg_64x64.png',64,'APEX');
    ins_icon('trash_empty_64.gif',64,'APEX');
    ins_icon('shoppingcart_wbg_64x64.png',64,'APEX');
    ins_icon('alarm_bell_wbg_64x64.png',64,'APEX');
    ins_icon('compass_64.gif',64,'APEX');
    --
    -- apex 3.0 64x64 images
    --
    ins_icon('users_business_64.gif',64,'APEX');
    ins_icon('application_64.gif',64,'APEX');
    ins_icon('bug_64.gif',64,'APEX');
    ins_icon('calendar_64.gif',64,'APEX');
    ins_icon('client_64.gif',64,'APEX');
    ins_icon('db_64.gif',64,'APEX');
    ins_icon('key_64.gif',64,'APEX');
    ins_icon('disk_64.gif',64,'APEX');
    ins_icon('draw_64.gif',64,'APEX');
    ins_icon('edit_64.gif',64,'APEX');
    ins_icon('folder_64.gif',64,'APEX');
    ins_icon('globe_64.gif',64,'APEX');
    ins_icon('lightbulb_64.gif',64,'APEX');
    ins_icon('chart_line_64.gif',64,'APEX');
    ins_icon('lock_64.gif',64,'APEX');
    ins_icon('navigation_64.gif',64,'APEX');
    ins_icon('package_64.gif',64,'APEX');
    ins_icon('page_64.gif',64,'APEX');
    ins_icon('pdf_64.gif',64,'APEX');
    ins_icon('chart_pie_64.gif',64,'APEX');
    ins_icon('pin_64.gif',64,'APEX');
    ins_icon('search_64.gif',64,'APEX');
    ins_icon('server_64.gif',64,'APEX');
    ins_icon('shapes_64.gif',64,'APEX');
    ins_icon('spreadsheet_64.gif',64,'APEX');
    ins_icon('users_64.gif',64,'APEX');
    ins_icon('clipboard_64.gif',64,'APEX');
    ins_icon('info_64.gif',64,'APEX');
    ins_icon('prod_apex_64.gif',64,'APEX');
    ins_icon('download_64.gif',64,'APEX');
    ins_icon('memo_64.gif',64,'APEX');
    ins_icon('phone_64.gif',64,'APEX');
    ins_icon('todo_64.gif',64,'APEX');
    ins_icon('mail_64.gif',64,'APEX');
    ins_icon('prod_sqldev_64.gif',64,'APEX');
    ins_icon('news_64.gif',64,'APEX');
    ins_icon('bboard_64.gif',64,'APEX');
    ins_icon('books_64.gif',64,'APEX');
    ins_icon('chart_bar_64.gif',64,'APEX');
    ins_icon('trafficlight_64.gif',64,'APEX');
    ins_icon('folder_yellow_64.gif',64,'APEX');
    ins_icon('report_64.gif',64,'APEX');
    ins_icon('tabform_64.gif',64,'APEX');
    ins_icon('form_64.gif',64,'APEX');
    ins_icon('tree_64.gif',64,'APEX');
    ins_icon('dynamic_64.gif',64,'APEX');
    ins_icon('home_64.gif',64,'APEX');
    ins_icon('login_64.gif',64,'APEX');
    ins_icon('calendar_page_64.gif',64,'APEX');
    ins_icon('chart_page_64.gif',64,'APEX');
    ins_icon('global_64.gif',64,'APEX');
    ins_icon('navigation_page_64.gif',64,'APEX');
    ins_icon('form_proc_page_64.gif',64,'APEX');
    ins_icon('form_wiz_page_64.gif',64,'APEX');
    ins_icon('files_64.gif',64,'APEX');
    ins_icon('ui_64.gif',64,'APEX');
    ins_icon('printer_64.gif',64,'APEX');
    ins_icon('logic_64.gif',64,'APEX');
    ins_icon('trash_64.gif',64,'APEX');
    ins_icon('supporting_obj_64.gif',64,'APEX');
    ins_icon('blank_app_64.gif',64,'APEX');
    ins_icon('browse_db_64.gif',64,'APEX');
    ins_icon('manage_service_64.gif',64,'APEX');
    ins_icon('change_storage_64.gif',64,'APEX');
    ins_icon('dbshare_64.gif',64,'APEX');
    ins_icon('db_tools_64.gif',64,'APEX');
    ins_icon('user_red_64.gif',64,'APEX');
    ins_icon('user_yellow_64.gif',64,'APEX');
    ins_icon('user_green_64.gif',64,'APEX');
    --
    -- apex 3.1 32x32
    --
    ins_icon('trash_empty_32.gif',32,'APEX');
    --
    -- apex 3.0 32x32
    --
    ins_icon('users_business_32.gif',32,'APEX');
    ins_icon('application_32.gif',32,'APEX');
    ins_icon('bug_32.gif',32,'APEX');
    ins_icon('calendar_32.gif',32,'APEX');
    ins_icon('client_32.gif',32,'APEX');
    ins_icon('db_32.gif',32,'APEX');
    ins_icon('key_32.gif',32,'APEX');
    ins_icon('disk_32.gif',32,'APEX');
    ins_icon('draw_32.gif',32,'APEX');
    ins_icon('edit_32.gif',32,'APEX');
    ins_icon('folder_32.gif',32,'APEX');
    ins_icon('globe_32.gif',32,'APEX');
    ins_icon('lightbulb_32.gif',32,'APEX');
    ins_icon('chart_line_32.gif',32,'APEX');
    ins_icon('lock_32.gif',32,'APEX');
    ins_icon('navigation_32.gif',32,'APEX');
    ins_icon('package_32.gif',32,'APEX');
    ins_icon('page_32.gif',32,'APEX');
    ins_icon('pdf_32.gif',32,'APEX');
    ins_icon('chart_pie_32.gif',32,'APEX');
    ins_icon('pin_32.gif',32,'APEX');
    ins_icon('search_32.gif',32,'APEX');
    ins_icon('server_32.gif',32,'APEX');
    ins_icon('shapes_32.gif',32,'APEX');
    ins_icon('spreadsheet_32.gif',32,'APEX');
    ins_icon('users_32.gif',32,'APEX');
    ins_icon('clipboard_32.gif',32,'APEX');
    ins_icon('info_32.gif',32,'APEX');
    ins_icon('prod_apex_32.gif',32,'APEX');
    ins_icon('download_32.gif',32,'APEX');
    ins_icon('memo_32.gif',32,'APEX');
    ins_icon('phone_32.gif',32,'APEX');
    ins_icon('todo_32.gif',32,'APEX');
    ins_icon('mail_32.gif',32,'APEX');
    ins_icon('prod_sqldev_32.gif',32,'APEX');
    ins_icon('news_32.gif',32,'APEX');
    ins_icon('bboard_32.gif',32,'APEX');
    ins_icon('books_32.gif',32,'APEX');
    ins_icon('chart_bar_32.gif',32,'APEX');
    ins_icon('trafficlight_32.gif',32,'APEX');
    ins_icon('folder_yellow_32.gif',32,'APEX');
    ins_icon('report_32.gif',32,'APEX');
    ins_icon('tabform_32.gif',32,'APEX');
    ins_icon('form_32.gif',32,'APEX');
    ins_icon('tree_32.gif',32,'APEX');
    ins_icon('dynamic_32.gif',32,'APEX');
    ins_icon('home_32.gif',32,'APEX');
    ins_icon('login_32.gif',32,'APEX');
    ins_icon('calendar_page_32.gif',32,'APEX');
    ins_icon('chart_page_32.gif',32,'APEX');
    ins_icon('global_32.gif',32,'APEX');
    ins_icon('navigation_page_32.gif',32,'APEX');
    ins_icon('form_proc_page_32.gif',32,'APEX');
    ins_icon('form_wiz_page_32.gif',32,'APEX');
    ins_icon('files_32.gif',32,'APEX');
    ins_icon('ui_32.gif',32,'APEX');
    ins_icon('printer_32.gif',32,'APEX');
    ins_icon('logic_32.gif',32,'APEX');
    ins_icon('trash_32.gif',32,'APEX');
    ins_icon('supporting_obj_32.gif',32,'APEX');
    ins_icon('blank_app_32.gif',32,'APEX');
    ins_icon('browse_db_32.gif',32,'APEX');
    ins_icon('manage_service_32.gif',32,'APEX');
    ins_icon('change_storage_32.gif',32,'APEX');
    ins_icon('dbshare_32.gif',32,'APEX');
    ins_icon('db_tools_32.gif',32,'APEX');
    ins_icon('user_red_32.gif',32,'APEX');
    ins_icon('user_yellow_32.gif',32,'APEX');
    ins_icon('user_green_32.gif',32,'APEX');
    --
    -- apex 3.1 20x20
    --
    ins_icon('pt_all_20.png',20,'APEX');
    ins_icon('pt_arrows_20.png',20,'APEX');
    ins_icon('pt_boxes_20.png',20,'APEX');
    ins_icon('pt_branch_20.png',20,'APEX');
    ins_icon('pt_breadcrumb_20.png',20,'APEX');
    ins_icon('pt_build_options_20.png',20,'APEX');
    ins_icon('pt_button_20.png',20,'APEX');
    ins_icon('pt_computation_20.png',20,'APEX');
    ins_icon('pt_condition_20.png',20,'APEX');
    ins_icon('pt_css_20.png',20,'APEX');
    ins_icon('pt_door_20.png',20,'APEX');
    ins_icon('pt_files_20.png',20,'APEX');
    ins_icon('pt_globalization_20.png',20,'APEX');
    ins_icon('pt_images_20.png',20,'APEX');
    ins_icon('pt_item_20.png',20,'APEX');
    ins_icon('pt_list_20.png',20,'APEX');
    ins_icon('pt_lov_20.png',20,'APEX');
    ins_icon('pt_messages_20.png',20,'APEX');
    ins_icon('pt_nav_20.png',20,'APEX');
    ins_icon('pt_page_20.png',20,'APEX');
    ins_icon('pt_print_20.png',20,'APEX');
    ins_icon('pt_process_20.png',20,'APEX');
    ins_icon('pt_region_20.png',20,'APEX');
    ins_icon('pt_security_20.png',20,'APEX');
    ins_icon('pt_security_attr_20.png',20,'APEX');
    ins_icon('pt_session_20.png',20,'APEX');
    ins_icon('pt_shortcuts_20.png',20,'APEX');
    ins_icon('pt_tab_20.png',20,'APEX');
    ins_icon('pt_template_20.png',20,'APEX');
    ins_icon('pt_theme_20.png',20,'APEX');
    ins_icon('pt_translate_20.png',20,'APEX');
    ins_icon('pt_tree_20.png',20,'APEX');
    ins_icon('pt_validation_20.png',20,'APEX');
    commit;
end;
/

---------------------------
-- Font Awesome CSS Classes
---------------------------
/* Script to generate the add_icon calls for Font Awesome
var xhttp = new XMLHttpRequest(),
    i = 0,
    lines = [],
    icons = [],
    category,
    alias,
    filter,
    parseFilter = false,
    parseCategories = false,
    output = "";
xhttp.open( "GET", "https://raw.githubusercontent.com/FortAwesome/Font-Awesome/v4.5.0/src/icons.yml", false );
xhttp.send();
lines = xhttp.responseText.split( "\n" );
for ( i = 0; i < lines.length; i++ ) {
  pos = lines[ i ].indexOf( "name:" );
  if ( pos !== -1 ) {
    icons.push({
      icon: "",
      filters: [],
      categories: []
    });
    parseFilter = false;
    parseCategories = false;
  } else {
    if ( parseCategories ) {
      if ( lines[ i ].indexOf( "-" ) !== -1 ) {
          category = lines[ i ].replace( /-/g, "" ).replace( " Icons", "" ).toUpperCase().trim().replace( / /g, "_" );
          if ( category !== "" ) {
            icons[ icons.length - 1 ].categories.push( category );
          }
      } else {
          parseCategories = false;
      }
    } else if ( parseFilter ) {
      if ( lines[ i ].indexOf( "-" ) !== -1 ) {
          filter = lines[ i ].replace( /-/g, "" ).replace( /"/g, "" ).trim();
          if ( filter !== "" ) {
            icons[ icons.length - 1 ].filters.push( filter );
          }
      } else {
          parseFilter = false;
      }
    }
    if ( lines[ i ].indexOf( "filter:" ) !== -1 || lines[ i ].indexOf( "aliases:" ) !== -1 ) {
      parseFilter = true;
    } else if ( lines[ i ].indexOf( "categories:" ) !== -1 ) {
      parseCategories = true;
    } else if ( lines[ i ].indexOf( "id:" ) !== -1 ) {
      icons[ icons.length - 1 ].icon = lines[ i ].substr( lines[ i ].indexOf( "id:" ) + 3 ).trim();
    }
  }
}
for ( i = 0; i < icons.length; i++ ) {
  output += "\nadd_icon( '" + icons[ i ].icon + "', '" + icons[ i ].categories.join( ":" );
  if ( icons[ i ].filters.length > 0 ) {
    output += "', '" + icons[ i ].filters.join( "," );
  }
  output += "' );";
}
console.log( output );
*/

---------------------------
-- Font APEX CSS Classes
---------------------------
delete from wwv_flow_standard_icons
 where icon_library = 'FONTAPEX'
/
commit;

declare
    procedure add_icon (
        p_icon       in varchar2,
        p_categories in varchar2,
        p_filters    in varchar2 default null )
    is
    begin
        insert into wwv_flow_standard_icons ( icon_name ,icon_library, icon_category, icon_filters ) values ( 'fa-' || p_icon, 'FONTAPEX', p_categories, p_filters );
    end add_icon;
begin
-- Copied from trunk_apex/internal_utilities/ui/font-apex/src/2.0/output/_install-data.sql
-- which is generated by trunk_apex/internal_utilities/ui/font-apex/src/2.0/gulpfile.js
add_icon( 'address-book', 'WEB_APPLICATION', 'contacts' );
add_icon( 'address-book-o', 'WEB_APPLICATION', 'contacts' );
add_icon( 'address-card', 'WEB_APPLICATION', 'vcard' );
add_icon( 'address-card-o', 'WEB_APPLICATION', 'vcard-o' );
add_icon( 'adjust', 'WEB_APPLICATION', 'contrast' );
add_icon( 'alert', 'WEB_APPLICATION', 'message,comment' );
add_icon( 'align-center', 'TEXT_EDITOR', 'middle,text' );
add_icon( 'align-justify', 'TEXT_EDITOR', 'text' );
add_icon( 'align-left', 'TEXT_EDITOR', 'text' );
add_icon( 'align-right', 'TEXT_EDITOR', 'text' );
add_icon( 'ambulance', 'MEDICAL:TRANSPORTATION', 'support,help' );
add_icon( 'american-sign-language-interpreting', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'anchor', 'WEB_APPLICATION', 'link' );
add_icon( 'angle-double-down', 'DIRECTIONAL' );
add_icon( 'angle-double-left', 'DIRECTIONAL', 'laquo,quote,previous,back' );
add_icon( 'angle-double-right', 'DIRECTIONAL', 'raquo,quote,next,forward' );
add_icon( 'angle-double-up', 'DIRECTIONAL' );
add_icon( 'angle-down', 'DIRECTIONAL' );
add_icon( 'angle-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'angle-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'angle-up', 'DIRECTIONAL' );
add_icon( 'apex', 'WEB_APPLICATION', 'applicationexpress,htmldb,webdb' );
add_icon( 'apex-square', 'WEB_APPLICATION', 'applicationexpress,htmldb,webdb' );
add_icon( 'archive', 'WEB_APPLICATION', 'box,storage' );
add_icon( 'area-chart', 'WEB_APPLICATION:CHART', 'graph,analytics' );
add_icon( 'arrow-circle-down', 'DIRECTIONAL', 'download' );
add_icon( 'arrow-circle-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'arrow-circle-o-down', 'DIRECTIONAL', 'download' );
add_icon( 'arrow-circle-o-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'arrow-circle-o-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'arrow-circle-o-up', 'DIRECTIONAL' );
add_icon( 'arrow-circle-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'arrow-circle-up', 'DIRECTIONAL' );
add_icon( 'arrow-down', 'DIRECTIONAL', 'download' );
add_icon( 'arrow-down-alt', 'DIRECTIONAL' );
add_icon( 'arrow-down-left-alt', 'DIRECTIONAL' );
add_icon( 'arrow-down-right-alt', 'DIRECTIONAL' );
add_icon( 'arrow-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'arrow-left-alt', 'DIRECTIONAL' );
add_icon( 'arrow-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'arrow-right-alt', 'DIRECTIONAL' );
add_icon( 'arrow-up', 'DIRECTIONAL' );
add_icon( 'arrow-up-alt', 'DIRECTIONAL' );
add_icon( 'arrow-up-left-alt', 'DIRECTIONAL' );
add_icon( 'arrow-up-right-alt', 'DIRECTIONAL' );
add_icon( 'arrows', 'WEB_APPLICATION:DIRECTIONAL', 'move,reorder,resize' );
add_icon( 'arrows-alt', 'VIDEO_PLAYER:DIRECTIONAL', 'expand,enlarge,fullscreen,bigger,move,reorder,resize' );
add_icon( 'arrows-h', 'WEB_APPLICATION:DIRECTIONAL', 'resize' );
add_icon( 'arrows-v', 'WEB_APPLICATION:DIRECTIONAL', 'resize' );
add_icon( 'asl-interpreting', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'assistive-listening-systems', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'asterisk', 'WEB_APPLICATION', 'details' );
add_icon( 'at', 'WEB_APPLICATION' );
add_icon( 'audio-description', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'awesome-face', 'EMOJI' );
add_icon( 'backward', 'VIDEO_PLAYER', 'rewind,previous' );
add_icon( 'badge-list', 'WEB_APPLICATION' );
add_icon( 'badges', 'WEB_APPLICATION' );
add_icon( 'balance-scale', 'WEB_APPLICATION' );
add_icon( 'ban', 'WEB_APPLICATION', 'delete,remove,trash,hide,block,stop,abort,cancel' );
add_icon( 'bar-chart', 'WEB_APPLICATION:CHART', 'barcharto,graph,analytics' );
add_icon( 'bar-chart-horizontal', 'CHART' );
add_icon( 'barcode', 'WEB_APPLICATION', 'scan' );
add_icon( 'bars', 'WEB_APPLICATION', 'navicon,reorder,menu,drag,reorder,settings,list,ul,ol,checklist,todo,list,hamburger' );
add_icon( 'bath', 'WEB_APPLICATION', 'bathtub' );
add_icon( 'battery-0', 'WEB_APPLICATION', 'empty' );
add_icon( 'battery-1', 'WEB_APPLICATION', 'quarter' );
add_icon( 'battery-2', 'WEB_APPLICATION', 'half' );
add_icon( 'battery-3', 'WEB_APPLICATION', 'three quarters' );
add_icon( 'battery-4', 'WEB_APPLICATION', 'full' );
add_icon( 'battleship', 'WEB_APPLICATION' );
add_icon( 'bed', 'WEB_APPLICATION', 'travel,hotel' );
add_icon( 'beer', 'WEB_APPLICATION', 'alcohol,stein,drink,mug,bar,liquor' );
add_icon( 'bell', 'WEB_APPLICATION', 'alert,reminder,notification' );
add_icon( 'bell-o', 'WEB_APPLICATION', 'alert,reminder,notification' );
add_icon( 'bell-slash', 'WEB_APPLICATION' );
add_icon( 'bell-slash-o', 'WEB_APPLICATION' );
add_icon( 'bicycle', 'WEB_APPLICATION:TRANSPORTATION', 'vehicle,bike' );
add_icon( 'binoculars', 'WEB_APPLICATION' );
add_icon( 'birthday-cake', 'WEB_APPLICATION' );
add_icon( 'bitcoin', 'CURRENCY' );
add_icon( 'blind', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'bold', 'TEXT_EDITOR' );
add_icon( 'bolt', 'WEB_APPLICATION', 'lightning,weather,flash' );
add_icon( 'bomb', 'WEB_APPLICATION' );
add_icon( 'book', 'WEB_APPLICATION', 'read,documentation' );
add_icon( 'bookmark', 'WEB_APPLICATION', 'save' );
add_icon( 'bookmark-o', 'WEB_APPLICATION', 'save' );
add_icon( 'box-arrow-in-east', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-ne', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-north', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-nw', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-se', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-south', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-sw', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-west', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-east', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-ne', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-north', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-nw', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-se', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-south', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-sw', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-west', 'DIRECTIONAL' );
add_icon( 'box-plot-chart', 'CHART' );
add_icon( 'braille', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'breadcrumb', 'WEB_APPLICATION', 'navigation' );
add_icon( 'briefcase', 'WEB_APPLICATION', 'work,business,office,luggage,bag' );
add_icon( 'btc', 'CURRENCY' );
add_icon( 'bubble-chart', 'CHART' );
add_icon( 'bug', 'WEB_APPLICATION', 'report,insect' );
add_icon( 'building', 'WEB_APPLICATION', 'work,business,apartment,office,company' );
add_icon( 'building-o', 'WEB_APPLICATION', 'work,business,apartment,office,company' );
add_icon( 'bullhorn', 'WEB_APPLICATION', 'announcement,share,broadcast,louder' );
add_icon( 'bullseye', 'WEB_APPLICATION', 'target' );
add_icon( 'bus', 'WEB_APPLICATION:TRANSPORTATION', 'vehicle' );
add_icon( 'button', 'WEB_APPLICATION' );
add_icon( 'button-container', 'WEB_APPLICATION', 'region' );
add_icon( 'button-group', 'WEB_APPLICATION', 'pill' );
add_icon( 'calculator', 'WEB_APPLICATION' );
add_icon( 'calendar', 'WEB_APPLICATION', 'date,time,when' );
add_icon( 'calendar-alarm', 'CALENDAR' );
add_icon( 'calendar-arrow-down', 'CALENDAR' );
add_icon( 'calendar-arrow-up', 'CALENDAR' );
add_icon( 'calendar-ban', 'CALENDAR' );
add_icon( 'calendar-chart', 'CALENDAR' );
add_icon( 'calendar-check-o', 'WEB_APPLICATION' );
add_icon( 'calendar-clock', 'CALENDAR', 'history' );
add_icon( 'calendar-edit', 'CALENDAR', 'pencil' );
add_icon( 'calendar-heart', 'CALENDAR', 'like,favorite' );
add_icon( 'calendar-lock', 'CALENDAR' );
add_icon( 'calendar-minus-o', 'WEB_APPLICATION' );
add_icon( 'calendar-o', 'WEB_APPLICATION', 'date,time,when' );
add_icon( 'calendar-plus-o', 'WEB_APPLICATION' );
add_icon( 'calendar-pointer', 'CALENDAR' );
add_icon( 'calendar-search', 'CALENDAR' );
add_icon( 'calendar-times-o', 'WEB_APPLICATION' );
add_icon( 'calendar-user', 'CALENDAR' );
add_icon( 'calendar-wrench', 'CALENDAR' );
add_icon( 'camera', 'WEB_APPLICATION', 'photo,picture,record' );
add_icon( 'camera-retro', 'WEB_APPLICATION', 'photo,picture,record' );
add_icon( 'car', 'WEB_APPLICATION:TRANSPORTATION', 'automobile,vehicle' );
add_icon( 'cards', 'WEB_APPLICATION', 'blocks' );
add_icon( 'caret-down', 'DIRECTIONAL', 'more,dropdown,menu,triangledown' );
add_icon( 'caret-left', 'DIRECTIONAL', 'previous,back,triangleleft' );
add_icon( 'caret-right', 'DIRECTIONAL', 'next,forward,triangleright' );
add_icon( 'caret-square-o-down', 'WEB_APPLICATION:DIRECTIONAL', 'toggledown,more,dropdown,menu' );
add_icon( 'caret-square-o-left', 'WEB_APPLICATION:DIRECTIONAL', 'previous,back,toggleleft' );
add_icon( 'caret-square-o-right', 'WEB_APPLICATION:DIRECTIONAL', 'next,forward,toggleright' );
add_icon( 'caret-square-o-up', 'WEB_APPLICATION:DIRECTIONAL', 'toggleup' );
add_icon( 'caret-up', 'DIRECTIONAL', 'triangleup' );
add_icon( 'carousel', 'WEB_APPLICATION', 'slideshow' );
add_icon( 'cart-arrow-down', 'WEB_APPLICATION', 'shopping' );
add_icon( 'cart-arrow-up', 'WEB_APPLICATION' );
add_icon( 'cart-check', 'WEB_APPLICATION' );
add_icon( 'cart-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'cart-empty', 'WEB_APPLICATION' );
add_icon( 'cart-full', 'WEB_APPLICATION' );
add_icon( 'cart-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'cart-lock', 'WEB_APPLICATION' );
add_icon( 'cart-magnifying-glass', 'WEB_APPLICATION' );
add_icon( 'cart-plus', 'WEB_APPLICATION', 'add,shopping' );
add_icon( 'cart-times', 'WEB_APPLICATION' );
add_icon( 'cc', 'WEB_APPLICATION' );
add_icon( 'certificate', 'WEB_APPLICATION', 'badge,star' );
add_icon( 'change-case', 'WEB_APPLICATION', 'lowercase,uppercase' );
add_icon( 'check', 'WEB_APPLICATION', 'checkmark,done,todo,agree,accept,confirm,tick' );
add_icon( 'check-circle', 'WEB_APPLICATION', 'todo,done,agree,accept,confirm' );
add_icon( 'check-circle-o', 'WEB_APPLICATION', 'todo,done,agree,accept,confirm' );
add_icon( 'check-square', 'WEB_APPLICATION:FORM_CONTROL', 'checkmark,done,todo,agree,accept,confirm' );
add_icon( 'check-square-o', 'WEB_APPLICATION:FORM_CONTROL', 'todo,done,agree,accept,confirm' );
add_icon( 'chevron-circle-down', 'DIRECTIONAL', 'more,dropdown,menu' );
add_icon( 'chevron-circle-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'chevron-circle-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'chevron-circle-up', 'DIRECTIONAL' );
add_icon( 'chevron-down', 'DIRECTIONAL' );
add_icon( 'chevron-left', 'DIRECTIONAL', 'bracket,previous,back' );
add_icon( 'chevron-right', 'DIRECTIONAL', 'bracket,next,forward' );
add_icon( 'chevron-up', 'DIRECTIONAL' );
add_icon( 'child', 'WEB_APPLICATION' );
add_icon( 'circle', 'WEB_APPLICATION:FORM_CONTROL', 'dot,notification' );
add_icon( 'circle-0-8', 'WEB_APPLICATION' );
add_icon( 'circle-1-8', 'WEB_APPLICATION' );
add_icon( 'circle-2-8', 'WEB_APPLICATION' );
add_icon( 'circle-3-8', 'WEB_APPLICATION' );
add_icon( 'circle-4-8', 'WEB_APPLICATION' );
add_icon( 'circle-5-8', 'WEB_APPLICATION' );
add_icon( 'circle-6-8', 'WEB_APPLICATION' );
add_icon( 'circle-7-8', 'WEB_APPLICATION' );
add_icon( 'circle-8-8', 'WEB_APPLICATION' );
add_icon( 'circle-arrow-in-east', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-ne', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-north', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-nw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-se', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-south', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-sw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-west', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-east', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-ne', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-north', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-nw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-se', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-south', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-sw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-west', 'DIRECTIONAL' );
add_icon( 'circle-o', 'WEB_APPLICATION:FORM_CONTROL' );
add_icon( 'circle-o-notch', 'WEB_APPLICATION:SPINNER' );
add_icon( 'circle-thin', 'WEB_APPLICATION' );
add_icon( 'clipboard', 'TEXT_EDITOR', 'copy,paste' );
add_icon( 'clipboard-arrow-down', 'TEXT_EDITOR' );
add_icon( 'clipboard-arrow-up', 'TEXT_EDITOR' );
add_icon( 'clipboard-ban', 'TEXT_EDITOR' );
add_icon( 'clipboard-bookmark', 'TEXT_EDITOR' );
add_icon( 'clipboard-chart ', 'TEXT_EDITOR' );
add_icon( 'clipboard-check', 'TEXT_EDITOR' );
add_icon( 'clipboard-check-alt', 'TEXT_EDITOR' );
add_icon( 'clipboard-clock', 'TEXT_EDITOR' );
add_icon( 'clipboard-edit', 'TEXT_EDITOR' );
add_icon( 'clipboard-heart', 'TEXT_EDITOR' );
add_icon( 'clipboard-list', 'TEXT_EDITOR' );
add_icon( 'clipboard-lock', 'TEXT_EDITOR' );
add_icon( 'clipboard-new', 'TEXT_EDITOR' );
add_icon( 'clipboard-plus', 'TEXT_EDITOR' );
add_icon( 'clipboard-pointer', 'TEXT_EDITOR' );
add_icon( 'clipboard-search', 'TEXT_EDITOR' );
add_icon( 'clipboard-user', 'TEXT_EDITOR' );
add_icon( 'clipboard-wrench', 'TEXT_EDITOR' );
add_icon( 'clipboard-x', 'TEXT_EDITOR' );
add_icon( 'clock-o', 'WEB_APPLICATION', 'watch,timer,late,timestamp' );
add_icon( 'clone', 'WEB_APPLICATION', 'copy' );
add_icon( 'cloud', 'WEB_APPLICATION', 'save' );
add_icon( 'cloud-arrow-down', 'WEB_APPLICATION' );
add_icon( 'cloud-arrow-up', 'WEB_APPLICATION' );
add_icon( 'cloud-ban', 'WEB_APPLICATION' );
add_icon( 'cloud-bookmark', 'WEB_APPLICATION' );
add_icon( 'cloud-chart', 'WEB_APPLICATION' );
add_icon( 'cloud-check', 'WEB_APPLICATION' );
add_icon( 'cloud-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'cloud-cursor', 'WEB_APPLICATION' );
add_icon( 'cloud-download', 'WEB_APPLICATION', 'import' );
add_icon( 'cloud-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'cloud-file', 'WEB_APPLICATION' );
add_icon( 'cloud-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'cloud-lock', 'WEB_APPLICATION' );
add_icon( 'cloud-new', 'WEB_APPLICATION' );
add_icon( 'cloud-play', 'WEB_APPLICATION' );
add_icon( 'cloud-plus', 'WEB_APPLICATION' );
add_icon( 'cloud-pointer', 'WEB_APPLICATION' );
add_icon( 'cloud-search', 'WEB_APPLICATION' );
add_icon( 'cloud-upload', 'WEB_APPLICATION', 'import' );
add_icon( 'cloud-user', 'WEB_APPLICATION' );
add_icon( 'cloud-wrench', 'WEB_APPLICATION' );
add_icon( 'cloud-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'cny', 'CURRENCY', 'china,renminbi,yuan' );
add_icon( 'code', 'WEB_APPLICATION', 'html,brackets' );
add_icon( 'code-fork', 'WEB_APPLICATION', 'git,fork,vcs,svn,github,rebase,version,merge' );
add_icon( 'code-group', 'WEB_APPLICATION', 'group,overlap' );
add_icon( 'coffee', 'WEB_APPLICATION', 'morning,mug,breakfast,tea,drink,cafe' );
add_icon( 'collapsible', 'WEB_APPLICATION' );
add_icon( 'columns', 'TEXT_EDITOR', 'split,panes' );
add_icon( 'combo-chart', 'CHART' );
add_icon( 'comment', 'WEB_APPLICATION', 'speech,notification,note,chat,bubble,feedback' );
add_icon( 'comment-o', 'WEB_APPLICATION', 'notification,note' );
add_icon( 'commenting', 'WEB_APPLICATION' );
add_icon( 'commenting-o', 'WEB_APPLICATION' );
add_icon( 'comments', 'WEB_APPLICATION', 'conversation,notification,notes' );
add_icon( 'comments-o', 'WEB_APPLICATION', 'conversation,notification,notes' );
add_icon( 'compass', 'WEB_APPLICATION', 'safari,directory,menu,location' );
add_icon( 'compress', 'VIDEO_PLAYER', 'collapse,combine,contract,merge,smaller' );
add_icon( 'contacts', 'WEB_APPLICATION' );
add_icon( 'copy', 'TEXT_EDITOR', 'duplicate,copy' );
add_icon( 'copyright', 'WEB_APPLICATION' );
add_icon( 'creative-commons', 'WEB_APPLICATION' );
add_icon( 'credit-card', 'WEB_APPLICATION:PAYMENT', 'money,buy,debit,checkout,purchase,payment' );
add_icon( 'credit-card-alt', 'WEB_APPLICATION:PAYMENT' );
add_icon( 'credit-card-terminal', 'PAYMENT:WEB_APPLICATION' );
add_icon( 'crop', 'WEB_APPLICATION' );
add_icon( 'crosshairs', 'WEB_APPLICATION', 'picker' );
add_icon( 'cube', 'WEB_APPLICATION' );
add_icon( 'cubes', 'WEB_APPLICATION' );
add_icon( 'cut', 'TEXT_EDITOR', 'scissors' );
add_icon( 'cutlery', 'WEB_APPLICATION', 'food,restaurant,spoon,knife,dinner,eat' );
add_icon( 'dashboard', 'WEB_APPLICATION', 'tachometer' );
add_icon( 'database', 'WEB_APPLICATION' );
add_icon( 'database-arrow-down', 'WEB_APPLICATION' );
add_icon( 'database-arrow-up', 'WEB_APPLICATION' );
add_icon( 'database-ban', 'WEB_APPLICATION' );
add_icon( 'database-bookmark', 'WEB_APPLICATION' );
add_icon( 'database-chart', 'WEB_APPLICATION' );
add_icon( 'database-check', 'WEB_APPLICATION' );
add_icon( 'database-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'database-cursor', 'WEB_APPLICATION' );
add_icon( 'database-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'database-file', 'WEB_APPLICATION' );
add_icon( 'database-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'database-lock', 'WEB_APPLICATION' );
add_icon( 'database-new', 'WEB_APPLICATION' );
add_icon( 'database-play', 'WEB_APPLICATION' );
add_icon( 'database-plus', 'WEB_APPLICATION' );
add_icon( 'database-pointer', 'WEB_APPLICATION' );
add_icon( 'database-search', 'WEB_APPLICATION' );
add_icon( 'database-user', 'WEB_APPLICATION' );
add_icon( 'database-wrench', 'WEB_APPLICATION' );
add_icon( 'database-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'deaf', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'deafness', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'design', 'WEB_APPLICATION' );
add_icon( 'desktop', 'WEB_APPLICATION', 'monitor,screen,desktop,computer,demo,device' );
add_icon( 'dial-gauge-chart', 'CHART' );
add_icon( 'diamond', 'WEB_APPLICATION', 'gem,gemstone' );
add_icon( 'dollar', 'CURRENCY', 'usd' );
add_icon( 'donut-chart', 'CHART' );
add_icon( 'dot-circle-o', 'WEB_APPLICATION:FORM_CONTROL', 'target,bullseye,notification' );
add_icon( 'download', 'WEB_APPLICATION', 'import' );
add_icon( 'download-alt', 'WEB_APPLICATION' );
add_icon( 'dynamic-content', 'WEB_APPLICATION' );
add_icon( 'edit', 'WEB_APPLICATION', 'write,edit,update' );
add_icon( 'eject', 'VIDEO_PLAYER' );
add_icon( 'ellipsis-h', 'WEB_APPLICATION', 'dots' );
add_icon( 'ellipsis-h-o', 'WEB_APPLICATION' );
add_icon( 'ellipsis-v', 'WEB_APPLICATION', 'dots' );
add_icon( 'ellipsis-v-o', 'WEB_APPLICATION' );
add_icon( 'emoji-angry', 'EMOJI' );
add_icon( 'emoji-astonished', 'EMOJI' );
add_icon( 'emoji-big-eyes-smile', 'EMOJI' );
add_icon( 'emoji-big-frown', 'EMOJI' );
add_icon( 'emoji-cold-sweat', 'EMOJI' );
add_icon( 'emoji-confounded', 'EMOJI' );
add_icon( 'emoji-confused', 'EMOJI' );
add_icon( 'emoji-cool', 'EMOJI' );
add_icon( 'emoji-cringe', 'EMOJI' );
add_icon( 'emoji-cry', 'EMOJI' );
add_icon( 'emoji-delicious', 'EMOJI' );
add_icon( 'emoji-disappointed', 'EMOJI' );
add_icon( 'emoji-disappointed-relieved', 'EMOJI' );
add_icon( 'emoji-expressionless', 'EMOJI' );
add_icon( 'emoji-fearful', 'EMOJI' );
add_icon( 'emoji-frown', 'EMOJI' );
add_icon( 'emoji-grimace', 'EMOJI' );
add_icon( 'emoji-grin-sweat', 'EMOJI' );
add_icon( 'emoji-happy-smile', 'EMOJI' );
add_icon( 'emoji-hushed', 'EMOJI' );
add_icon( 'emoji-laughing', 'EMOJI' );
add_icon( 'emoji-lol', 'EMOJI' );
add_icon( 'emoji-love', 'EMOJI' );
add_icon( 'emoji-mean', 'EMOJI' );
add_icon( 'emoji-nerd', 'EMOJI' );
add_icon( 'emoji-neutral', 'EMOJI' );
add_icon( 'emoji-no-mouth', 'EMOJI' );
add_icon( 'emoji-open-mouth', 'EMOJI' );
add_icon( 'emoji-pensive', 'EMOJI' );
add_icon( 'emoji-persevere', 'EMOJI' );
add_icon( 'emoji-pleased', 'EMOJI' );
add_icon( 'emoji-relieved', 'EMOJI' );
add_icon( 'emoji-rotfl', 'EMOJI' );
add_icon( 'emoji-scream', 'EMOJI' );
add_icon( 'emoji-sleeping', 'EMOJI' );
add_icon( 'emoji-sleepy', 'EMOJI' );
add_icon( 'emoji-slight-frown', 'EMOJI' );
add_icon( 'emoji-slight-smile', 'EMOJI' );
add_icon( 'emoji-smile', 'EMOJI' );
add_icon( 'emoji-smirk', 'EMOJI' );
add_icon( 'emoji-stuck-out-tounge', 'EMOJI' );
add_icon( 'emoji-stuck-out-tounge-closed-eyes', 'EMOJI' );
add_icon( 'emoji-stuck-out-tounge-wink', 'EMOJI' );
add_icon( 'emoji-sweet-smile', 'EMOJI' );
add_icon( 'emoji-tired', 'EMOJI' );
add_icon( 'emoji-unamused', 'EMOJI' );
add_icon( 'emoji-upside-down', 'EMOJI' );
add_icon( 'emoji-weary', 'EMOJI' );
add_icon( 'emoji-wink', 'EMOJI' );
add_icon( 'emoji-worry', 'EMOJI' );
add_icon( 'emoji-zipper-mouth', 'EMOJI' );
add_icon( 'envelope', 'WEB_APPLICATION', 'email,email,letter,support,mail,notification' );
add_icon( 'envelope-arrow-down', 'WEB_APPLICATION' );
add_icon( 'envelope-arrow-up', 'WEB_APPLICATION' );
add_icon( 'envelope-ban', 'WEB_APPLICATION' );
add_icon( 'envelope-bookmark', 'WEB_APPLICATION' );
add_icon( 'envelope-chart', 'WEB_APPLICATION' );
add_icon( 'envelope-check', 'WEB_APPLICATION' );
add_icon( 'envelope-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'envelope-cursor', 'WEB_APPLICATION' );
add_icon( 'envelope-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'envelope-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'envelope-lock', 'WEB_APPLICATION' );
add_icon( 'envelope-o', 'WEB_APPLICATION', 'email,support,email,letter,mail,notification' );
add_icon( 'envelope-open', 'WEB_APPLICATION', 'mail' );
add_icon( 'envelope-open-o', 'WEB_APPLICATION' );
add_icon( 'envelope-play', 'WEB_APPLICATION' );
add_icon( 'envelope-plus', 'WEB_APPLICATION' );
add_icon( 'envelope-pointer', 'WEB_APPLICATION' );
add_icon( 'envelope-search', 'WEB_APPLICATION' );
add_icon( 'envelope-square', 'WEB_APPLICATION' );
add_icon( 'envelope-user', 'WEB_APPLICATION' );
add_icon( 'envelope-wrench', 'WEB_APPLICATION' );
add_icon( 'envelope-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'eraser', 'TEXT_EDITOR:WEB_APPLICATION' );
add_icon( 'eur', 'CURRENCY', 'euro' );
add_icon( 'euro', 'CURRENCY', 'euro' );
add_icon( 'exception', 'WEB_APPLICATION', 'warning,error' );
add_icon( 'exchange', 'WEB_APPLICATION:DIRECTIONAL', 'transfer,arrows' );
add_icon( 'exclamation', 'WEB_APPLICATION', 'warning,error,problem,notification,notify,alert' );
add_icon( 'exclamation-circle', 'WEB_APPLICATION', 'warning,error,problem,notification,alert' );
add_icon( 'exclamation-circle-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert' );
add_icon( 'exclamation-diamond', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-diamond-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-square', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-square-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-triangle', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-triangle-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'expand', 'VIDEO_PLAYER', 'enlarge,bigger,resize' );
add_icon( 'expand-collapse', 'WEB_APPLICATION', 'plus,minus' );
add_icon( 'external-link', 'WEB_APPLICATION', 'open,new' );
add_icon( 'external-link-square', 'WEB_APPLICATION', 'open,new' );
add_icon( 'eye', 'WEB_APPLICATION', 'show,visible,views' );
add_icon( 'eye-slash', 'WEB_APPLICATION', 'toggle,show,hide,visible,visiblity,views' );
add_icon( 'eyedropper', 'WEB_APPLICATION' );
add_icon( 'fast-backward', 'VIDEO_PLAYER', 'rewind,previous,beginning,start,first' );
add_icon( 'fast-forward', 'VIDEO_PLAYER', 'next,end,last' );
add_icon( 'fax', 'WEB_APPLICATION' );
add_icon( 'feed', 'WEB_APPLICATION', 'blog,rss' );
add_icon( 'female', 'WEB_APPLICATION', 'woman,user,person,profile' );
add_icon( 'fighter-jet', 'WEB_APPLICATION:TRANSPORTATION', 'fly,plane,airplane,quick,fast,travel' );
add_icon( 'fighter-jet-alt', 'WEB_APPLICATION', 'plane' );
add_icon( 'file', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-archive-o', 'WEB_APPLICATION:FILE_TYPE', 'zip' );
add_icon( 'file-arrow-down', 'WEB_APPLICATION' );
add_icon( 'file-arrow-up', 'WEB_APPLICATION' );
add_icon( 'file-audio-o', 'WEB_APPLICATION:FILE_TYPE', 'sound' );
add_icon( 'file-ban', 'WEB_APPLICATION' );
add_icon( 'file-bookmark', 'WEB_APPLICATION' );
add_icon( 'file-chart', 'WEB_APPLICATION' );
add_icon( 'file-check', 'WEB_APPLICATION' );
add_icon( 'file-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'file-code-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-cursor', 'WEB_APPLICATION' );
add_icon( 'file-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'file-excel-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'file-image-o', 'WEB_APPLICATION:FILE_TYPE', 'photo,picture' );
add_icon( 'file-lock', 'WEB_APPLICATION' );
add_icon( 'file-new', 'WEB_APPLICATION' );
add_icon( 'file-o', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-pdf-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-play', 'WEB_APPLICATION' );
add_icon( 'file-plus', 'WEB_APPLICATION' );
add_icon( 'file-pointer', 'WEB_APPLICATION' );
add_icon( 'file-powerpoint-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-search', 'WEB_APPLICATION' );
add_icon( 'file-sql', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-text', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-text-o', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-user', 'WEB_APPLICATION' );
add_icon( 'file-video-o', 'WEB_APPLICATION:FILE_TYPE', 'filemovieo' );
add_icon( 'file-word-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-wrench', 'WEB_APPLICATION' );
add_icon( 'file-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'files-o', 'TEXT_EDITOR', 'duplicate,copy' );
add_icon( 'film', 'WEB_APPLICATION', 'movie' );
add_icon( 'filter', 'WEB_APPLICATION', 'funnel,options' );
add_icon( 'fire', 'WEB_APPLICATION', 'flame,hot,popular' );
add_icon( 'fire-extinguisher', 'WEB_APPLICATION' );
add_icon( 'fit-to-height', 'WEB_APPLICATION' );
add_icon( 'fit-to-size', 'WEB_APPLICATION' );
add_icon( 'fit-to-width', 'WEB_APPLICATION' );
add_icon( 'flag', 'WEB_APPLICATION', 'report,notification,notify' );
add_icon( 'flag-checkered', 'WEB_APPLICATION', 'report,notification,notify' );
add_icon( 'flag-o', 'WEB_APPLICATION', 'report,notification' );
add_icon( 'flashlight', 'WEB_APPLICATION', 'find,search' );
add_icon( 'flask', 'WEB_APPLICATION', 'science,beaker,experimental,labs' );
add_icon( 'folder', 'WEB_APPLICATION' );
add_icon( 'folder-arrow-down', 'WEB_APPLICATION' );
add_icon( 'folder-arrow-up', 'WEB_APPLICATION' );
add_icon( 'folder-ban', 'WEB_APPLICATION' );
add_icon( 'folder-bookmark', 'WEB_APPLICATION' );
add_icon( 'folder-chart', 'WEB_APPLICATION' );
add_icon( 'folder-check', 'WEB_APPLICATION' );
add_icon( 'folder-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'folder-cloud', 'WEB_APPLICATION' );
add_icon( 'folder-cursor', 'WEB_APPLICATION' );
add_icon( 'folder-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'folder-file', 'WEB_APPLICATION' );
add_icon( 'folder-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'folder-lock', 'WEB_APPLICATION' );
add_icon( 'folder-network', 'WEB_APPLICATION' );
add_icon( 'folder-new', 'WEB_APPLICATION' );
add_icon( 'folder-o', 'WEB_APPLICATION' );
add_icon( 'folder-open', 'WEB_APPLICATION' );
add_icon( 'folder-open-o', 'WEB_APPLICATION' );
add_icon( 'folder-play', 'WEB_APPLICATION' );
add_icon( 'folder-plus', 'WEB_APPLICATION' );
add_icon( 'folder-pointer', 'WEB_APPLICATION' );
add_icon( 'folder-search', 'WEB_APPLICATION' );
add_icon( 'folder-user', 'WEB_APPLICATION' );
add_icon( 'folder-wrench', 'WEB_APPLICATION' );
add_icon( 'folder-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'folders', 'WEB_APPLICATION' );
add_icon( 'font', 'TEXT_EDITOR', 'text' );
add_icon( 'font-size', 'WEB_APPLICATION', 'text' );
add_icon( 'font-size-decrease', 'WEB_APPLICATION', 'text' );
add_icon( 'font-size-increase', 'WEB_APPLICATION', 'text' );
add_icon( 'format', 'WEB_APPLICATION', 'indentation,code' );
add_icon( 'forms', 'WEB_APPLICATION', 'input' );
add_icon( 'forward', 'VIDEO_PLAYER', 'forward,next' );
add_icon( 'frown-o', 'WEB_APPLICATION', 'emoticon,sad,disapprove,rating' );
add_icon( 'function', 'WEB_APPLICATION', 'computation,procedure,fx' );
add_icon( 'funnel-chart', 'CHART' );
add_icon( 'futbol-o', 'WEB_APPLICATION', 'soccer' );
add_icon( 'gamepad', 'WEB_APPLICATION', 'controller' );
add_icon( 'gantt-chart', 'CHART' );
add_icon( 'gavel', 'WEB_APPLICATION', 'legal' );
add_icon( 'gbp', 'CURRENCY' );
add_icon( 'gear', 'WEB_APPLICATION:SPINNER', 'settings,cog' );
add_icon( 'gears', 'WEB_APPLICATION', 'cogs,settings' );
add_icon( 'genderless', 'GENDER' );
add_icon( 'gift', 'WEB_APPLICATION', 'present' );
add_icon( 'glass', 'WEB_APPLICATION', 'martini,drink,bar,alcohol,liquor' );
add_icon( 'glasses', 'WEB_APPLICATION' );
add_icon( 'globe', 'WEB_APPLICATION', 'world,planet,map,place,travel,earth,global,translate,all,language,localize,location,coordinates,country' );
add_icon( 'graduation-cap', 'WEB_APPLICATION', 'mortar board,learning,school,student' );
add_icon( 'h-square', 'MEDICAL', 'hospital,hotel' );
add_icon( 'hand-grab-o', 'WEB_APPLICATION:HAND', 'hand rock' );
add_icon( 'hand-lizard-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-o-down', 'DIRECTIONAL:HAND', 'point' );
add_icon( 'hand-o-left', 'DIRECTIONAL:HAND', 'point,left,previous,back' );
add_icon( 'hand-o-right', 'DIRECTIONAL:HAND', 'point,right,next,forward' );
add_icon( 'hand-o-up', 'DIRECTIONAL:HAND', 'point' );
add_icon( 'hand-peace-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-pointer-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-scissors-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-spock-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-stop-o', 'WEB_APPLICATION:HAND', 'hand paper' );
add_icon( 'handshake-o', 'WEB_APPLICATION', 'agreement' );
add_icon( 'hard-of-hearing', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'hardware', 'WEB_APPLICATION', 'chip,computer' );
add_icon( 'hashtag', 'WEB_APPLICATION' );
add_icon( 'hdd-o', 'WEB_APPLICATION', 'harddrive,harddrive,storage,save' );
add_icon( 'header', 'TEXT_EDITOR', 'heading' );
add_icon( 'headphones', 'WEB_APPLICATION', 'sound,listen,music' );
add_icon( 'headset', 'WEB_APPLICATION', 'chat,support,help' );
add_icon( 'heart', 'WEB_APPLICATION:MEDICAL', 'love,like,favorite' );
add_icon( 'heart-o', 'WEB_APPLICATION:MEDICAL', 'love,like,favorite' );
add_icon( 'heartbeat', 'WEB_APPLICATION:MEDICAL', 'ekg' );
add_icon( 'helicopter', 'WEB_APPLICATION' );
add_icon( 'hero', 'WEB_APPLICATION' );
add_icon( 'hipster', 'EMOJI' );
add_icon( 'history', 'WEB_APPLICATION' );
add_icon( 'home', 'WEB_APPLICATION', 'main,house' );
add_icon( 'hospital-o', 'MEDICAL', 'building' );
add_icon( 'hourglass', 'WEB_APPLICATION' );
add_icon( 'hourglass-1', 'WEB_APPLICATION', 'hourglass-start' );
add_icon( 'hourglass-2', 'WEB_APPLICATION', 'hourglass-half' );
add_icon( 'hourglass-3', 'WEB_APPLICATION', 'hourglass-end' );
add_icon( 'hourglass-o', 'WEB_APPLICATION' );
add_icon( 'i-cursor', 'WEB_APPLICATION' );
add_icon( 'id-badge', 'WEB_APPLICATION', 'lanyard' );
add_icon( 'id-card', 'WEB_APPLICATION', 'drivers license, identification, identity' );
add_icon( 'id-card-o', 'WEB_APPLICATION', 'drivers license, identification, identity' );
add_icon( 'ils', 'CURRENCY', 'shekel,sheqel' );
add_icon( 'image', 'WEB_APPLICATION', 'photo,picture' );
add_icon( 'inbox', 'WEB_APPLICATION' );
add_icon( 'indent', 'TEXT_EDITOR' );
add_icon( 'index', 'WEB_APPLICATION' );
add_icon( 'industry', 'WEB_APPLICATION' );
add_icon( 'info', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-circle', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-circle-o', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-square', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-square-o', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'inr', 'CURRENCY', 'rupee' );
add_icon( 'italic', 'TEXT_EDITOR', 'italics' );
add_icon( 'jpy', 'CURRENCY', 'japan,yen' );
add_icon( 'key', 'WEB_APPLICATION', 'unlock,password' );
add_icon( 'key-alt', 'WEB_APPLICATION', 'lock,key' );
add_icon( 'keyboard-o', 'WEB_APPLICATION', 'type,input' );
add_icon( 'krw', 'CURRENCY', 'won' );
add_icon( 'language', 'WEB_APPLICATION' );
add_icon( 'laptop', 'WEB_APPLICATION', 'demo,computer,device' );
add_icon( 'layers', 'WEB_APPLICATION' );
add_icon( 'layout-1col-2col', 'WEB_APPLICATION' );
add_icon( 'layout-1col-3col', 'WEB_APPLICATION' );
add_icon( 'layout-1row-2row', 'WEB_APPLICATION' );
add_icon( 'layout-2col', 'WEB_APPLICATION' );
add_icon( 'layout-2col-1col', 'WEB_APPLICATION' );
add_icon( 'layout-2row', 'WEB_APPLICATION' );
add_icon( 'layout-2row-1row', 'WEB_APPLICATION' );
add_icon( 'layout-3col', 'WEB_APPLICATION' );
add_icon( 'layout-3col-1col', 'WEB_APPLICATION' );
add_icon( 'layout-3row', 'WEB_APPLICATION' );
add_icon( 'layout-blank', 'WEB_APPLICATION' );
add_icon( 'layout-footer', 'WEB_APPLICATION' );
add_icon( 'layout-grid-3x', 'WEB_APPLICATION' );
add_icon( 'layout-header', 'WEB_APPLICATION' );
add_icon( 'layout-header-1col-3col', 'WEB_APPLICATION' );
add_icon( 'layout-header-2row', 'WEB_APPLICATION' );
add_icon( 'layout-header-footer', 'WEB_APPLICATION' );
add_icon( 'layout-header-nav-left-cards', 'WEB_APPLICATION' );
add_icon( 'layout-header-nav-left-right-footer', 'WEB_APPLICATION' );
add_icon( 'layout-header-nav-right-cards', 'WEB_APPLICATION' );
add_icon( 'layout-header-sidebar-left', 'WEB_APPLICATION' );
add_icon( 'layout-header-sidebar-right', 'WEB_APPLICATION' );
add_icon( 'layout-list-left', 'WEB_APPLICATION' );
add_icon( 'layout-list-right', 'WEB_APPLICATION' );
add_icon( 'layout-modal-blank', 'WEB_APPLICATION' );
add_icon( 'layout-modal-columns', 'WEB_APPLICATION' );
add_icon( 'layout-modal-grid-2x', 'WEB_APPLICATION' );
add_icon( 'layout-modal-header', 'WEB_APPLICATION' );
add_icon( 'layout-modal-nav-left', 'WEB_APPLICATION' );
add_icon( 'layout-modal-nav-right', 'WEB_APPLICATION' );
add_icon( 'layout-modal-rows', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-cards', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-hamburger', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-hamburger-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-header-cards', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-header-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-right', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-right-header-footer', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-cards', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-hamburger', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-hamburger-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-header-cards', 'WEB_APPLICATION' );
add_icon( 'layout-sidebar-left', 'WEB_APPLICATION' );
add_icon( 'layout-sidebar-right', 'WEB_APPLICATION' );
add_icon( 'layouts-grid-2x', 'WEB_APPLICATION' );
add_icon( 'leaf', 'WEB_APPLICATION', 'eco,nature' );
add_icon( 'lemon-o', 'WEB_APPLICATION' );
add_icon( 'level-down', 'WEB_APPLICATION' );
add_icon( 'level-up', 'WEB_APPLICATION' );
add_icon( 'life-ring', 'WEB_APPLICATION', 'lifebuoy,lifesaver,support' );
add_icon( 'lightbulb-o', 'WEB_APPLICATION', 'idea,inspiration' );
add_icon( 'line-area-chart', 'CHART' );
add_icon( 'line-chart', 'WEB_APPLICATION:CHART', 'graph,analytics' );
add_icon( 'link', 'TEXT_EDITOR', 'chain' );
add_icon( 'list', 'TEXT_EDITOR', 'ul,ol,checklist,finished,completed,done,todo' );
add_icon( 'list-alt', 'TEXT_EDITOR', 'ul,ol,checklist,finished,completed,done,todo' );
add_icon( 'list-ol', 'TEXT_EDITOR', 'ul,ol,checklist,list,todo,list,numbers' );
add_icon( 'list-ul', 'TEXT_EDITOR', 'ul,ol,checklist,todo,list' );
add_icon( 'location-arrow', 'WEB_APPLICATION', 'map,coordinates,location,address,place,where' );
add_icon( 'lock', 'WEB_APPLICATION', 'protect,admin' );
add_icon( 'lock-check', 'WEB_APPLICATION' );
add_icon( 'lock-file', 'WEB_APPLICATION' );
add_icon( 'lock-new', 'WEB_APPLICATION' );
add_icon( 'lock-password', 'WEB_APPLICATION' );
add_icon( 'lock-plus', 'WEB_APPLICATION' );
add_icon( 'lock-user', 'WEB_APPLICATION' );
add_icon( 'lock-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'long-arrow-down', 'DIRECTIONAL' );
add_icon( 'long-arrow-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'long-arrow-right', 'DIRECTIONAL' );
add_icon( 'long-arrow-up', 'DIRECTIONAL' );
add_icon( 'low-vision', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'magic', 'WEB_APPLICATION', 'wizard,automatic,autocomplete' );
add_icon( 'magnet', 'WEB_APPLICATION' );
add_icon( 'mail-forward', 'WEB_APPLICATION', 'mail share' );
add_icon( 'male', 'WEB_APPLICATION', 'man,user,person,profile' );
add_icon( 'map', 'WEB_APPLICATION' );
add_icon( 'map-marker', 'WEB_APPLICATION', 'map,pin,location,coordinates,localize,address,travel,where,place' );
add_icon( 'map-o', 'WEB_APPLICATION' );
add_icon( 'map-pin', 'WEB_APPLICATION' );
add_icon( 'map-signs', 'WEB_APPLICATION' );
add_icon( 'mars', 'GENDER', 'male' );
add_icon( 'mars-double', 'GENDER' );
add_icon( 'mars-stroke', 'GENDER' );
add_icon( 'mars-stroke-h', 'GENDER' );
add_icon( 'mars-stroke-v', 'GENDER' );
add_icon( 'materialized-view', 'WEB_APPLICATION' );
add_icon( 'media-list', 'WEB_APPLICATION' );
add_icon( 'medkit', 'MEDICAL', 'firstaid,firstaid,help,support,health' );
add_icon( 'meh-o', 'WEB_APPLICATION', 'emoticon,rating,neutral' );
add_icon( 'mercury', 'GENDER', 'transgender' );
add_icon( 'microchip', 'WEB_APPLICATION', 'silicon,chip,cpu' );
add_icon( 'microphone', 'WEB_APPLICATION', 'record,voice,sound' );
add_icon( 'microphone-slash', 'WEB_APPLICATION', 'record,voice,sound,mute' );
add_icon( 'military-vehicle', 'WEB_APPLICATION', 'humvee,car,truck' );
add_icon( 'minus', 'WEB_APPLICATION', 'hide,minify,delete,remove,trash,hide,collapse' );
add_icon( 'minus-circle', 'WEB_APPLICATION', 'delete,remove,trash,hide' );
add_icon( 'minus-circle-o', 'WEB_APPLICATION', 'delete,remove,trash,hide' );
add_icon( 'minus-square', 'WEB_APPLICATION:FORM_CONTROL', 'hide,minify,delete,remove,trash,hide,collapse' );
add_icon( 'minus-square-o', 'WEB_APPLICATION:FORM_CONTROL', 'hide,minify,delete,remove,trash,hide,collapse' );
add_icon( 'missile', 'WEB_APPLICATION' );
add_icon( 'mobile', 'WEB_APPLICATION', 'cellphone,cellphone,text,call,iphone,number,phone' );
add_icon( 'money', 'WEB_APPLICATION:CURRENCY', 'cash,money,buy,checkout,purchase,payment' );
add_icon( 'moon-o', 'WEB_APPLICATION', 'night,darker,contrast' );
add_icon( 'motorcycle', 'WEB_APPLICATION:TRANSPORTATION', 'vehicle,bike' );
add_icon( 'mouse-pointer', 'WEB_APPLICATION' );
add_icon( 'music', 'WEB_APPLICATION', 'note,sound' );
add_icon( 'navicon', 'WEB_APPLICATION', 'reorder,menu,drag,reorder,settings,list,ul,ol,checklist,todo,list,hamburger' );
add_icon( 'network-hub', 'WEB_APPLICATION' );
add_icon( 'network-triangle', 'WEB_APPLICATION' );
add_icon( 'neuter', 'GENDER' );
add_icon( 'newspaper-o', 'WEB_APPLICATION', 'press' );
add_icon( 'number-0', 'NUMBERS' );
add_icon( 'notebook', 'WEB_APPLICATION' );
add_icon( 'number-0-o', 'NUMBERS' );
add_icon( 'number-1', 'NUMBERS' );
add_icon( 'number-1-o', 'NUMBERS' );
add_icon( 'number-2', 'NUMBERS' );
add_icon( 'number-2-o', 'NUMBERS' );
add_icon( 'number-3', 'NUMBERS' );
add_icon( 'number-3-o', 'NUMBERS' );
add_icon( 'number-4', 'NUMBERS' );
add_icon( 'number-4-o', 'NUMBERS' );
add_icon( 'number-5', 'NUMBERS' );
add_icon( 'number-5-o', 'NUMBERS' );
add_icon( 'number-6', 'NUMBERS' );
add_icon( 'number-6-o', 'NUMBERS' );
add_icon( 'number-7', 'NUMBERS' );
add_icon( 'number-7-o', 'NUMBERS' );
add_icon( 'number-8', 'NUMBERS' );
add_icon( 'number-8-o', 'NUMBERS' );
add_icon( 'number-9', 'NUMBERS' );
add_icon( 'number-9-o', 'NUMBERS' );
add_icon( 'object-group', 'WEB_APPLICATION' );
add_icon( 'object-ungroup', 'WEB_APPLICATION' );
add_icon( 'office-phone', 'WEB_APPLICATION', 'phone,fax' );
add_icon( 'outdent', 'TEXT_EDITOR', 'dedent' );
add_icon( 'package', 'WEB_APPLICATION', 'product' );
add_icon( 'padlock', 'WEB_APPLICATION' );
add_icon( 'padlock-unlock', 'WEB_APPLICATION' );
add_icon( 'page-bottom', 'DIRECTIONAL' );
add_icon( 'page-first', 'DIRECTIONAL' );
add_icon( 'page-last', 'DIRECTIONAL' );
add_icon( 'page-top', 'DIRECTIONAL' );
add_icon( 'paint-brush', 'WEB_APPLICATION' );
add_icon( 'paper-plane', 'WEB_APPLICATION', 'send' );
add_icon( 'paper-plane-o', 'WEB_APPLICATION', 'sendo' );
add_icon( 'paperclip', 'TEXT_EDITOR', 'attachment' );
add_icon( 'paragraph', 'TEXT_EDITOR' );
add_icon( 'paste', 'TEXT_EDITOR', 'clipboard' );
add_icon( 'pause', 'VIDEO_PLAYER', 'wait' );
add_icon( 'pause-circle', 'VIDEO_PLAYER' );
add_icon( 'pause-circle-o', 'VIDEO_PLAYER' );
add_icon( 'paw', 'WEB_APPLICATION', 'pet' );
add_icon( 'pencil', 'WEB_APPLICATION', 'write,edit,update' );
add_icon( 'pencil-square', 'WEB_APPLICATION', 'write,edit,update' );
add_icon( 'pencil-square-o', 'WEB_APPLICATION', 'write,edit,update,edit' );
add_icon( 'percent', 'WEB_APPLICATION' );
add_icon( 'phone', 'WEB_APPLICATION', 'call,voice,number,support,earphone' );
add_icon( 'phone-square', 'WEB_APPLICATION', 'call,voice,number,support' );
add_icon( 'photo', 'WEB_APPLICATION', 'image,picture' );
add_icon( 'pie-chart', 'WEB_APPLICATION:CHART', 'graph,analytics' );
add_icon( 'pie-chart-0', 'CHART' );
add_icon( 'pie-chart-10', 'CHART' );
add_icon( 'pie-chart-100', 'CHART' );
add_icon( 'pie-chart-15', 'CHART' );
add_icon( 'pie-chart-20', 'CHART' );
add_icon( 'pie-chart-25', 'CHART' );
add_icon( 'pie-chart-30', 'CHART' );
add_icon( 'pie-chart-35', 'CHART' );
add_icon( 'pie-chart-40', 'CHART' );
add_icon( 'pie-chart-45', 'CHART' );
add_icon( 'pie-chart-5', 'CHART' );
add_icon( 'pie-chart-50', 'CHART' );
add_icon( 'pie-chart-55', 'CHART' );
add_icon( 'pie-chart-60', 'CHART' );
add_icon( 'pie-chart-65', 'CHART' );
add_icon( 'pie-chart-70', 'CHART' );
add_icon( 'pie-chart-75', 'CHART' );
add_icon( 'pie-chart-80', 'CHART' );
add_icon( 'pie-chart-85', 'CHART' );
add_icon( 'pie-chart-90', 'CHART' );
add_icon( 'pie-chart-95', 'CHART' );
add_icon( 'plane', 'WEB_APPLICATION:TRANSPORTATION', 'travel,trip,location,destination,airplane,fly,mode' );
add_icon( 'play', 'VIDEO_PLAYER', 'start,playing,music,sound' );
add_icon( 'play-circle', 'VIDEO_PLAYER', 'start,playing' );
add_icon( 'play-circle-o', 'VIDEO_PLAYER' );
add_icon( 'plug', 'WEB_APPLICATION' );
add_icon( 'plus', 'WEB_APPLICATION', 'add,new,create,expand' );
add_icon( 'plus-circle', 'WEB_APPLICATION', 'add,new,create,expand' );
add_icon( 'plus-circle-o', 'WEB_APPLICATION', 'add,new,create,expand' );
add_icon( 'plus-square', 'MEDICAL:WEB_APPLICATION:FORM_CONTROL', 'add,new,create,expand' );
add_icon( 'plus-square-o', 'WEB_APPLICATION:FORM_CONTROL', 'add,new,create,expand' );
add_icon( 'podcast', 'WEB_APPLICATION' );
add_icon( 'polar-chart', 'CHART' );
add_icon( 'power-off', 'WEB_APPLICATION', 'on' );
add_icon( 'pragma', 'WEB_APPLICATION', 'number,sign,hash,sharp' );
add_icon( 'print', 'WEB_APPLICATION' );
add_icon( 'procedure', 'WEB_APPLICATION', 'computation,function' );
add_icon( 'puzzle-piece', 'WEB_APPLICATION', 'addon,addon,section' );
add_icon( 'pyramid-chart', 'CHART' );
add_icon( 'qrcode', 'WEB_APPLICATION', 'scan' );
add_icon( 'question', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-circle', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-circle-o', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-square', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-square-o', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'quote-left', 'WEB_APPLICATION' );
add_icon( 'quote-right', 'WEB_APPLICATION' );
add_icon( 'radar-chart', 'CHART' );
add_icon( 'random', 'WEB_APPLICATION:VIDEO_PLAYER', 'sort,shuffle' );
add_icon( 'range-chart-area', 'CHART' );
add_icon( 'range-chart-bar', 'CHART' );
add_icon( 'recycle', 'WEB_APPLICATION' );
add_icon( 'redo-alt', 'WEB_APPLICATION' );
add_icon( 'redo-arrow', 'WEB_APPLICATION' );
add_icon( 'refresh', 'WEB_APPLICATION:SPINNER', 'reload,sync' );
add_icon( 'registered', 'WEB_APPLICATION' );
add_icon( 'remove', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'repeat', 'TEXT_EDITOR', 'redo,forward,rotate' );
add_icon( 'reply', 'WEB_APPLICATION', 'mail' );
add_icon( 'reply-all', 'WEB_APPLICATION', 'mail' );
add_icon( 'retweet', 'WEB_APPLICATION', 'refresh,reload,share' );
add_icon( 'rmb', 'CURRENCY', 'china,renminbi,yuan' );
add_icon( 'road', 'WEB_APPLICATION', 'street' );
add_icon( 'rocket', 'WEB_APPLICATION:TRANSPORTATION', 'app' );
add_icon( 'rotate-left', 'TEXT_EDITOR', 'back,undo' );
add_icon( 'rotate-right', 'TEXT_EDITOR', 'redo,forward,repeat' );
add_icon( 'rss', 'WEB_APPLICATION', 'blog,feed' );
add_icon( 'rss-square', 'WEB_APPLICATION', 'feed,blog' );
add_icon( 'rub', 'CURRENCY', 'ruble,rouble' );
add_icon( 'save', 'TEXT_EDITOR', 'floppy' );
add_icon( 'save-as', 'WEB_APPLICATION' );
add_icon( 'scatter-chart', 'CHART' );
add_icon( 'scissors', 'TEXT_EDITOR', 'cut' );
add_icon( 'search', 'WEB_APPLICATION', 'magnify,zoom,enlarge,bigger' );
add_icon( 'search-minus', 'WEB_APPLICATION', 'magnify,minify,zoom,smaller' );
add_icon( 'search-plus', 'WEB_APPLICATION', 'magnify,zoom,enlarge,bigger' );
add_icon( 'send', 'WEB_APPLICATION', 'plane' );
add_icon( 'send-o', 'WEB_APPLICATION', 'plane' );
add_icon( 'sequence', 'WEB_APPLICATION' );
add_icon( 'server', 'WEB_APPLICATION' );
add_icon( 'server-arrow-down', 'WEB_APPLICATION' );
add_icon( 'server-arrow-up', 'WEB_APPLICATION' );
add_icon( 'server-ban', 'WEB_APPLICATION' );
add_icon( 'server-bookmark', 'WEB_APPLICATION' );
add_icon( 'server-chart', 'WEB_APPLICATION' );
add_icon( 'server-check', 'WEB_APPLICATION' );
add_icon( 'server-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'server-edit', 'WEB_APPLICATION' );
add_icon( 'server-file', 'WEB_APPLICATION' );
add_icon( 'server-heart', 'WEB_APPLICATION' );
add_icon( 'server-lock', 'WEB_APPLICATION' );
add_icon( 'server-new', 'WEB_APPLICATION' );
add_icon( 'server-play', 'WEB_APPLICATION' );
add_icon( 'server-plus', 'WEB_APPLICATION' );
add_icon( 'server-pointer', 'WEB_APPLICATION' );
add_icon( 'server-search', 'WEB_APPLICATION' );
add_icon( 'server-user', 'WEB_APPLICATION' );
add_icon( 'server-wrench', 'WEB_APPLICATION' );
add_icon( 'server-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'shapes', 'WEB_APPLICATION', 'shared,components' );
add_icon( 'share', 'WEB_APPLICATION', 'mail forward' );
add_icon( 'share-alt', 'WEB_APPLICATION' );
add_icon( 'share-alt-square', 'WEB_APPLICATION' );
add_icon( 'share-square', 'WEB_APPLICATION', 'social,send' );
add_icon( 'share-square-o', 'WEB_APPLICATION', 'social,send' );
add_icon( 'share2', 'WEB_APPLICATION' );
add_icon( 'shield', 'WEB_APPLICATION', 'award,achievement,winner' );
add_icon( 'ship', 'WEB_APPLICATION:TRANSPORTATION', 'boat,sea' );
add_icon( 'shopping-bag', 'WEB_APPLICATION' );
add_icon( 'shopping-basket', 'WEB_APPLICATION' );
add_icon( 'shopping-cart', 'WEB_APPLICATION', 'checkout,buy,purchase,payment' );
add_icon( 'shower', 'WEB_APPLICATION' );
add_icon( 'sign-in', 'WEB_APPLICATION', 'enter,join,login,login,signup,signin,signin,signup,arrow' );
add_icon( 'sign-language', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'sign-out', 'WEB_APPLICATION', 'logout,logout,leave,exit,arrow' );
add_icon( 'signal', 'WEB_APPLICATION' );
add_icon( 'signing', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'sitemap', 'WEB_APPLICATION', 'directory,hierarchy,organization' );
add_icon( 'sitemap-horizontal', 'WEB_APPLICATION' );
add_icon( 'sitemap-vertical', 'WEB_APPLICATION' );
add_icon( 'sliders', 'WEB_APPLICATION' );
add_icon( 'smile-o', 'WEB_APPLICATION', 'emoticon,happy,approve,satisfied,rating' );
add_icon( 'snowflake', 'WEB_APPLICATION', 'frozen' );
add_icon( 'soccer-ball-o', 'WEB_APPLICATION', 'football' );
add_icon( 'sort', 'WEB_APPLICATION', 'order,unsorted' );
add_icon( 'sort-alpha-asc', 'WEB_APPLICATION' );
add_icon( 'sort-alpha-desc', 'WEB_APPLICATION' );
add_icon( 'sort-amount-asc', 'WEB_APPLICATION' );
add_icon( 'sort-amount-desc', 'WEB_APPLICATION' );
add_icon( 'sort-asc', 'WEB_APPLICATION', 'up' );
add_icon( 'sort-desc', 'WEB_APPLICATION', 'dropdown,more,menu,down' );
add_icon( 'sort-numeric-asc', 'WEB_APPLICATION', 'numbers' );
add_icon( 'sort-numeric-desc', 'WEB_APPLICATION', 'numbers' );
add_icon( 'space-shuttle', 'WEB_APPLICATION:TRANSPORTATION' );
add_icon( 'spinner', 'WEB_APPLICATION:SPINNER', 'loading,progress' );
add_icon( 'spoon', 'WEB_APPLICATION' );
add_icon( 'square', 'WEB_APPLICATION:FORM_CONTROL', 'block,box' );
add_icon( 'square-o', 'WEB_APPLICATION:FORM_CONTROL', 'block,square,box' );
add_icon( 'square-selected-o', 'WEB_APPLICATION:FORM_CONTROL', 'block,square,box' );
add_icon( 'star', 'WEB_APPLICATION', 'award,achievement,night,rating,score' );
add_icon( 'star-half', 'WEB_APPLICATION', 'award,achievement,rating,score' );
add_icon( 'star-half-o', 'WEB_APPLICATION', 'award,achievement,rating,score,half' );
add_icon( 'star-o', 'WEB_APPLICATION', 'award,achievement,night,rating,score' );
add_icon( 'step-backward', 'VIDEO_PLAYER', 'rewind,previous,beginning,start,first' );
add_icon( 'step-forward', 'VIDEO_PLAYER', 'next,end,last' );
add_icon( 'stethoscope', 'MEDICAL' );
add_icon( 'sticky-note', 'WEB_APPLICATION' );
add_icon( 'sticky-note-o', 'WEB_APPLICATION' );
add_icon( 'stock-chart', 'CHART' );
add_icon( 'stop', 'VIDEO_PLAYER', 'block,box,square' );
add_icon( 'stop-circle', 'VIDEO_PLAYER' );
add_icon( 'stop-circle-o', 'VIDEO_PLAYER' );
add_icon( 'street-view', 'WEB_APPLICATION', 'map' );
add_icon( 'strikethrough', 'TEXT_EDITOR' );
add_icon( 'subscript', 'TEXT_EDITOR' );
add_icon( 'subway', 'TRANSPORTATION' );
add_icon( 'suitcase', 'WEB_APPLICATION', 'trip,luggage,travel,move,baggage' );
add_icon( 'sun-o', 'WEB_APPLICATION', 'weather,contrast,lighter,brighten,day' );
add_icon( 'superscript', 'TEXT_EDITOR', 'exponential' );
add_icon( 'support', 'WEB_APPLICATION', 'lifebuoy,lifesaver,lifering' );
add_icon( 'synonym', 'WEB_APPLICATION', 'copy,duplicate' );
add_icon( 'table', 'TEXT_EDITOR', 'data,excel,spreadsheet' );
add_icon( 'table-arrow-down', 'WEB_APPLICATION' );
add_icon( 'table-arrow-up', 'WEB_APPLICATION' );
add_icon( 'table-ban', 'WEB_APPLICATION' );
add_icon( 'table-bookmark', 'WEB_APPLICATION' );
add_icon( 'table-chart', 'WEB_APPLICATION' );
add_icon( 'table-check', 'WEB_APPLICATION' );
add_icon( 'table-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'table-cursor', 'WEB_APPLICATION' );
add_icon( 'table-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'table-file', 'WEB_APPLICATION' );
add_icon( 'table-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'table-lock', 'WEB_APPLICATION' );
add_icon( 'table-new', 'WEB_APPLICATION' );
add_icon( 'table-play', 'WEB_APPLICATION' );
add_icon( 'table-plus', 'WEB_APPLICATION' );
add_icon( 'table-pointer', 'WEB_APPLICATION' );
add_icon( 'table-search', 'WEB_APPLICATION' );
add_icon( 'table-user', 'WEB_APPLICATION' );
add_icon( 'table-wrench', 'WEB_APPLICATION' );
add_icon( 'table-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'tablet', 'WEB_APPLICATION', 'ipad,device' );
add_icon( 'tabs', 'WEB_APPLICATION' );
add_icon( 'tachometer', 'WEB_APPLICATION', 'dashboard' );
add_icon( 'tag', 'WEB_APPLICATION', 'label' );
add_icon( 'tags', 'WEB_APPLICATION', 'labels' );
add_icon( 'tank', 'WEB_APPLICATION' );
add_icon( 'tasks', 'WEB_APPLICATION', 'progress,loading,downloading,downloads,settings' );
add_icon( 'taxi', 'WEB_APPLICATION:TRANSPORTATION', 'cab,vehicle' );
add_icon( 'television', 'WEB_APPLICATION', 'tv' );
add_icon( 'terminal', 'WEB_APPLICATION', 'command,prompt,code' );
add_icon( 'text-height', 'TEXT_EDITOR' );
add_icon( 'text-width', 'TEXT_EDITOR' );
add_icon( 'th', 'TEXT_EDITOR', 'blocks,squares,boxes,grid' );
add_icon( 'th-large', 'TEXT_EDITOR', 'blocks,squares,boxes,grid' );
add_icon( 'th-list', 'TEXT_EDITOR', 'ul,ol,checklist,finished,completed,done,todo' );
add_icon( 'thermometer-0', 'WEB_APPLICATION', 'thermometer-empty' );
add_icon( 'thermometer-1', 'WEB_APPLICATION', 'thermometer-quarter' );
add_icon( 'thermometer-2', 'WEB_APPLICATION', 'thermometer-half' );
add_icon( 'thermometer-3', 'WEB_APPLICATION', 'thermometer-three-quarters' );
add_icon( 'thermometer-4', 'WEB_APPLICATION', 'thermometer-full,thermometer' );
add_icon( 'thumb-tack', 'WEB_APPLICATION', 'marker,pin,location,coordinates' );
add_icon( 'thumbs-down', 'WEB_APPLICATION:HAND', 'dislike,disapprove,disagree,hand' );
add_icon( 'thumbs-o-down', 'WEB_APPLICATION:HAND', 'dislike,disapprove,disagree,hand' );
add_icon( 'thumbs-o-up', 'WEB_APPLICATION:HAND', 'like,approve,favorite,agree,hand' );
add_icon( 'thumbs-up', 'WEB_APPLICATION:HAND', 'like,favorite,approve,agree,hand' );
add_icon( 'ticket', 'WEB_APPLICATION', 'movie,pass,support' );
add_icon( 'tiles-2x2', 'WEB_APPLICATION' );
add_icon( 'tiles-3x3', 'WEB_APPLICATION' );
add_icon( 'tiles-8', 'WEB_APPLICATION' );
add_icon( 'tiles-9', 'WEB_APPLICATION' );
add_icon( 'times', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'times-circle', 'WEB_APPLICATION', 'close,exit,x' );
add_icon( 'times-circle-o', 'WEB_APPLICATION', 'close,exit,x' );
add_icon( 'times-rectangle', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'times-rectangle-o', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'times-square', 'FORM_CONTROL', 'remove,close,close,exit,x,cross' );
add_icon( 'times-square-o', 'FORM_CONTROL', 'remove,close,close,exit,x,cross' );
add_icon( 'tint', 'WEB_APPLICATION', 'raindrop,waterdrop,drop,droplet' );
add_icon( 'toggle-off', 'WEB_APPLICATION' );
add_icon( 'toggle-on', 'WEB_APPLICATION' );
add_icon( 'tools', 'WEB_APPLICATION', 'screwdriver,wrench' );
add_icon( 'trademark', 'WEB_APPLICATION' );
add_icon( 'train', 'TRANSPORTATION' );
add_icon( 'transgender', 'GENDER', 'intersex' );
add_icon( 'transgender-alt', 'GENDER' );
add_icon( 'trash', 'WEB_APPLICATION', 'garbage,delete,remove,hide' );
add_icon( 'trash-o', 'WEB_APPLICATION', 'garbage,delete,remove,trash,hide' );
add_icon( 'tree', 'WEB_APPLICATION' );
add_icon( 'tree-org', 'WEB_APPLICATION' );
add_icon( 'trigger', 'WEB_APPLICATION' );
add_icon( 'trophy', 'WEB_APPLICATION', 'award,achievement,winner,game' );
add_icon( 'truck', 'WEB_APPLICATION:TRANSPORTATION', 'shipping' );
add_icon( 'try', 'CURRENCY', 'turkey, lira, turkish' );
add_icon( 'tty', 'WEB_APPLICATION' );
add_icon( 'umbrella', 'WEB_APPLICATION' );
add_icon( 'underline', 'TEXT_EDITOR' );
add_icon( 'undo', 'TEXT_EDITOR', 'back,rotate' );
add_icon( 'undo-alt', 'WEB_APPLICATION' );
add_icon( 'undo-arrow', 'WEB_APPLICATION' );
add_icon( 'universal-access', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'university', 'WEB_APPLICATION', 'institution,bank' );
add_icon( 'unlink', 'TEXT_EDITOR', 'remove,chain,broken' );
add_icon( 'unlock', 'WEB_APPLICATION', 'protect,admin,password,lock' );
add_icon( 'unlock-alt', 'WEB_APPLICATION', 'protect,admin,password,lock' );
add_icon( 'upload', 'WEB_APPLICATION', 'import' );
add_icon( 'upload-alt', 'WEB_APPLICATION' );
add_icon( 'usd', 'CURRENCY', 'dollar' );
add_icon( 'user', 'WEB_APPLICATION', 'person,man,head,profile' );
add_icon( 'user-arrow-down', 'WEB_APPLICATION' );
add_icon( 'user-arrow-up', 'WEB_APPLICATION' );
add_icon( 'user-ban', 'WEB_APPLICATION' );
add_icon( 'user-chart', 'WEB_APPLICATION' );
add_icon( 'user-check', 'WEB_APPLICATION' );
add_icon( 'user-circle', 'WEB_APPLICATION' );
add_icon( 'user-circle-o', 'WEB_APPLICATION' );
add_icon( 'user-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'user-cursor', 'WEB_APPLICATION' );
add_icon( 'user-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'user-graduate', 'WEB_APPLICATION' );
add_icon( 'user-headset', 'WEB_APPLICATION' );
add_icon( 'user-heart', 'WEB_APPLICATION', 'like,favorite,love' );
add_icon( 'user-lock', 'WEB_APPLICATION' );
add_icon( 'user-magnifying-glass', 'WEB_APPLICATION' );
add_icon( 'user-man', 'WEB_APPLICATION' );
add_icon( 'user-md', 'MEDICAL', 'doctor,profile,medical,nurse' );
add_icon( 'user-play', 'WEB_APPLICATION' );
add_icon( 'user-plus', 'WEB_APPLICATION', 'signup,signup' );
add_icon( 'user-pointer', 'WEB_APPLICATION' );
add_icon( 'user-secret', 'WEB_APPLICATION', 'whisper,spy,incognito' );
add_icon( 'user-woman', 'WEB_APPLICATION' );
add_icon( 'user-wrench', 'WEB_APPLICATION' );
add_icon( 'user-x', 'WEB_APPLICATION' );
add_icon( 'users', 'WEB_APPLICATION', 'people,profiles,persons,group' );
add_icon( 'users-chat', 'WEB_APPLICATION' );
add_icon( 'variable', 'WEB_APPLICATION' );
add_icon( 'venus', 'GENDER', 'female' );
add_icon( 'venus-double', 'GENDER' );
add_icon( 'venus-mars', 'GENDER' );
add_icon( 'video-camera', 'WEB_APPLICATION', 'film,movie,record' );
add_icon( 'volume-control-phone', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'volume-down', 'WEB_APPLICATION', 'lower,quieter,sound,music' );
add_icon( 'volume-off', 'WEB_APPLICATION', 'mute,sound,music' );
add_icon( 'volume-up', 'WEB_APPLICATION', 'higher,louder,sound,music' );
add_icon( 'warning', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'wheelchair', 'WEB_APPLICATION:MEDICAL:TRANSPORTATION', 'handicap,person,accessibility,accessible' );
add_icon( 'wheelchair-alt', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'wifi', 'WEB_APPLICATION' );
add_icon( 'window', 'WEB_APPLICATION' );
add_icon( 'window-alt', 'WEB_APPLICATION' );
add_icon( 'window-alt-2', 'WEB_APPLICATION' );
add_icon( 'window-arrow-down', 'WEB_APPLICATION' );
add_icon( 'window-arrow-up', 'WEB_APPLICATION' );
add_icon( 'window-ban', 'WEB_APPLICATION' );
add_icon( 'window-bookmark', 'WEB_APPLICATION' );
add_icon( 'window-chart', 'WEB_APPLICATION' );
add_icon( 'window-check', 'WEB_APPLICATION' );
add_icon( 'window-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'window-close', 'WEB_APPLICATION', 'times, rectangle' );
add_icon( 'window-close-o', 'WEB_APPLICATION', 'times, rectangle' );
add_icon( 'window-cursor', 'WEB_APPLICATION' );
add_icon( 'window-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'window-file', 'WEB_APPLICATION' );
add_icon( 'window-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'window-lock', 'WEB_APPLICATION' );
add_icon( 'window-maximize', 'WEB_APPLICATION' );
add_icon( 'window-minimize', 'WEB_APPLICATION' );
add_icon( 'window-new', 'WEB_APPLICATION' );
add_icon( 'window-play', 'WEB_APPLICATION' );
add_icon( 'window-plus', 'WEB_APPLICATION' );
add_icon( 'window-pointer', 'WEB_APPLICATION' );
add_icon( 'window-restore', 'WEB_APPLICATION' );
add_icon( 'window-search', 'WEB_APPLICATION' );
add_icon( 'window-terminal', 'WEB_APPLICATION', 'console' );
add_icon( 'window-user', 'WEB_APPLICATION' );
add_icon( 'window-wrench', 'WEB_APPLICATION' );
add_icon( 'window-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'wizard', 'WEB_APPLICATION', 'steps,progress' );
add_icon( 'wrench', 'WEB_APPLICATION', 'settings,fix,update' );
add_icon( 'x-axis', 'CHART' );
add_icon( 'y-axis', 'CHART' );
add_icon( 'y1-axis', 'CHART' );
add_icon( 'y2-axis', 'CHART' );
add_icon( 'yen', 'CURRENCY' );
end;
/
commit;

prompt
prompt ...insert into wwv_flow_standard_item_types
prompt

delete from wwv_flow_standard_item_types;
insert into wwv_flow_standard_item_types(name, display_name) values ('BUTTON', 'Button');



prompt
prompt ...wwv_flow_languages
prompt

declare
    procedure ins_lang (
        p_id                   in wwv_flow_languages.id%type,
        p_lang_id              in wwv_flow_languages.lang_id%type,
        p_lang_id_upper        in wwv_flow_languages.lang_id_upper%type,
        p_lang_name            in wwv_flow_languages.lang_name%type,
        p_nls_language         in wwv_flow_languages.nls_language%type,
        p_nls_territory        in wwv_flow_languages.nls_territory%type,
        p_nls_sort             in wwv_flow_languages.nls_sort%type,
        p_nls_windows_charset  in wwv_flow_languages.nls_windows_charset%type,
        p_translated_lang_name in wwv_flow_languages.translated_lang_name%type,
        p_dl_format            in wwv_flow_languages.dl_format%type,
        p_ds_format            in wwv_flow_languages.ds_format%type )
    is
    begin
        insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset,translated_lang_name,dl_format,ds_format)
        values (p_id,p_lang_id,p_lang_id_upper,p_lang_name,p_nls_language,p_nls_territory,p_nls_sort,p_nls_windows_charset,p_translated_lang_name,p_dl_format,p_ds_format);
    end ins_lang;
begin
    delete from wwv_flow_languages;
    ins_lang( 1, 'af', null, 'Afrikaans', 'ENGLISH', 'SOUTH AFRICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('RRRR/MM/DD'));
    ins_lang( 2, 'sq', null, 'Albania', 'ALBANIAN', 'ALBANIA', null, 'EE8MSWIN1250',unistr('Shqip\00EBria'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 3, 'ar', null, 'Arabic', 'ARABIC', 'UNITED ARAB EMIRATES', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 4, 'ar-ae', null, 'Arabic (U.A.E.)', 'ARABIC', 'UNITED ARAB EMIRATES', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 5, 'ar-bh', null, 'Arabic (Bahrain)', 'ARABIC', 'BAHRAIN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 6, 'ar-dz', null, 'Arabic (Algeria)', 'ARABIC', 'ALGERIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 7, 'hy', null, 'Armenia', 'ARMENIAN', 'ARMENIA', null, 'EE8MSWIN1250',unistr('\0540\0561\0575\0565\0580\0565\0576'),unistr('d fmMonth,yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 8, 'ar-eg', null, 'Arabic (Egypt)', 'EGYPTIAN', 'EGYPT', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 9, 'ar-iq', null, 'Arabic (Iraq)', 'ARABIC', 'IRAQ', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 10, 'ar-jo', null, 'Arabic (Jordan)', 'ARABIC', 'JORDAN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 11, 'ar-kw', null, 'Arabic (Kuwait)', 'ARABIC', 'KUWAIT', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 12, 'ar-lb', null, 'Arabic (Lebanon)', 'ARABIC', 'LEBANON', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 13, 'ar-ly', null, 'Arabic (Libya)', 'ARABIC', 'LIBYA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 14, 'ar-ma', null, 'Arabic (Morocco)', 'ARABIC', 'MOROCCO', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 15, 'ar-om', null, 'Arabic (Oman)', 'ARABIC', 'OMAN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 16, 'ar-qa', null, 'Arabic (Qatar)', 'ARABIC', 'QATAR', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 17, 'ar-sa', null, 'Arabic (Saudi Arabia)', 'ARABIC', 'SAUDI ARABIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 18, 'ar-sy', null, 'Arabic (Syria)', 'ARABIC', 'SYRIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 19, 'ar-tn', null, 'Arabic (Tunisia)', 'ARABIC', 'TUNISIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 20, 'ar-ye', null, 'Arabic (Yemen)', 'ARABIC', 'YEMEN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 21, 'as', null, 'Assamese', 'ASSAMESE', 'INDIA', null, 'AL32UTF8',unistr('Assamese'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 22, 'be', null, 'Belarusian', 'BELARUSIAN', 'BELARUS', null, 'CL8MSWIN1251',unistr('Belarusian'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'));
    ins_lang( 23, 'bg', null, 'Bulgarian', 'BULGARIAN', 'BULGARIA', null, 'CL8MSWIN1251',unistr('\0431\044A\043B\0433\0430\0440\0441\043A\0438'),unistr('fmDay, dd Month yyyy" \0433."'),unistr('DD.MM.RRRR'));
    ins_lang( 24, 'bn', null, 'Bengali', 'BANGLA', 'BANGLADESH', null, 'AL32UTF8',unistr('\09AC\09BE\0982\09B2\09BE'),unistr('fmday, fmdd fmmonth yyyy'),unistr('DD-MM-RRRR'));
    ins_lang( 25, 'ca', null, 'Catalan', 'CATALAN', 'CATALONIA', null, 'WE8MSWIN1252',unistr('Catal\00E0'),unistr('fmday, dd" / "month" / "yyyy'),unistr('DD-MM-RR'));
    ins_lang( 26, 'cs', null, 'Czech', 'CZECH', 'CZECH REPUBLIC', null, 'EE8MSWIN1250',unistr('\010De\0161tina'),unistr('fmday, dd. month yyyy'),unistr('fmDD.MM.RRRR'));
    ins_lang( 27, 'cy', null, 'Welsh', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252', unistr('Cymraeg'), unistr('DD/MM/RRRR'), unistr('DD/MM/RRRR'));
    ins_lang( 28, 'da', null, 'Danish', 'DANISH', 'DENMARK', null, 'WE8MSWIN1252',unistr('Dansk'),unistr('fmday dd. month yyyy'),unistr('DD-MM-RRRR'));
    ins_lang( 29, 'de', null, 'German (Germany)', 'GERMAN', 'GERMANY', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 30, 'de-at', null, 'German (Austria)', 'GERMAN', 'AUSTRIA', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, fmdd. fmMonth yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 31, 'de-ch', null, 'German (Switzerland)', 'GERMAN', 'SWITZERLAND', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 32, 'de-li', null, 'German (Liechtenstein)', 'GERMAN', 'GERMANY', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 33, 'de-lu', null, 'German (Luxemgourg)', 'GERMAN', 'LUXEMBOURG', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 34, 'el', null, 'Greek', 'GREEK', 'GREECE', null, 'EL8MSWIN1253',unistr('\0395\03BB\03BB\03B7\03BD\03B9\03BA\03AC'),unistr('fmDay dd Month yyyy'),unistr('fmDD/MM/RRRR'));
    ins_lang( 35, 'en', null, 'English', 'AMERICAN', 'AMERICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'));
    ins_lang( 36, 'en-au', null, 'English (Australia)', 'ENGLISH', 'AUSTRALIA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, dd Month yyyy'),unistr('fmDD/fmMM/RRRR'));
    ins_lang( 37, 'en-bz', null, 'English (Belize)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 38, 'en-ca', null, 'English (Canada)', 'ENGLISH', 'CANADA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month dd, yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 39, 'en-gb', null, 'English (United Kingdom)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 40, 'en-ie', null, 'English (Ireland)', 'ENGLISH', 'IRELAND', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 41, 'en-jm', null, 'English (Jamaica)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 42, 'en-nz', null, 'English (New Zealand)', 'ENGLISH', 'NEW ZEALAND', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, dd Month yyyy'),unistr('fmDD/fmMM/RRRR'));
    ins_lang( 43, 'en-ph', null, 'English (Philippines)', 'ENGLISH', 'PHILIPPINES', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'));
    ins_lang( 44, 'en-tt', null, 'English (Trinidad)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 45, 'en-us', null, 'English (United States)', 'AMERICAN', 'AMERICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'));
    ins_lang( 46, 'en-za', null, 'English (South Africa)', 'ENGLISH', 'SOUTH AFRICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('RRRR/MM/DD'));
    ins_lang( 47, 'en-zw', null, 'English (Zimbabwe)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 48, 'es', null, 'Spanish (Traditional Sort)', 'SPANISH', 'SPAIN', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 49, 'es-ar', null, 'Spanish (Argentina)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 50, 'es-bo', null, 'Spanish (Bolivia)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 51, 'es-cl', null, 'Spanish (Chile)', 'LATIN AMERICAN SPANISH', 'CHILE', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD-MM-RRRR'));
    ins_lang( 52, 'es-co', null, 'Spanish (Columbia)', 'LATIN AMERICAN SPANISH', 'COLOMBIA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 53, 'es-cr', null, 'Spanish (Costa Rica)', 'LATIN AMERICAN SPANISH', 'COSTA RICA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 54, 'es-do', null, 'Spanish (Dominican Republic)', 'LATIN AMERICAN SPANISH', 'PUERTO RICO', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 55, 'es-ec', null, 'Spanish (Ecudor)', 'LATIN AMERICAN SPANISH', 'ECUADOR', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 56, 'es-gt', null, 'Spanish (Guatemala)', 'LATIN AMERICAN SPANISH', 'GUATEMALA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 57, 'es-hn', null, 'Spanish (Honduras)', 'LATIN AMERICAN SPANISH', 'GUATEMALA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 58, 'es-mx', null, 'Spanish (Mexico)', 'MEXICAN SPANISH', 'MEXICO', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 59, 'es-ni', null, 'Spanish (Nicaragua)', 'LATIN AMERICAN SPANISH', 'NICARAGUA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 60, 'es-pa', null, 'Spanish (Panama)', 'LATIN AMERICAN SPANISH', 'PANAMA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('MM/DD/RRRR'));
    ins_lang( 61, 'es-pe', null, 'Spanish (Peru)', 'LATIN AMERICAN SPANISH', 'PERU', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 62, 'es-pr', null, 'Spanish (Peurto Rico)', 'LATIN AMERICAN SPANISH', 'PUERTO RICO', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 63, 'es-py', null, 'Spanish (Paraguay)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 64, 'es-sv', null, 'Spanish (El Salvador)', 'LATIN AMERICAN SPANISH', 'EL SALVADOR', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 65, 'es-us', null, 'Spanish (United States)', 'LATIN AMERICAN SPANISH', 'AMERICA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'));
    ins_lang( 66, 'es-uy', null, 'Spanish (Uruguay)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 67, 'es-ve', null, 'Spanish (Venezuela)', 'LATIN AMERICAN SPANISH', 'VENEZUELA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 68, 'et', null, 'Estonian', 'ESTONIAN', 'ESTONIA', null, 'BLT8MSWIN1257',unistr('Estonian'),unistr('fmDay, fmdd.mm.yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 69, 'eu', null, 'Basque', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252',unistr('Basque'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 70, 'fa', null, 'Farsi', 'ENGLISH', 'UNITED KINGDOM', null, 'AR8MSWIN1256',unistr('\0641\0627\0631\0633\06CC'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 71, 'fi', null, 'Finnish', 'FINNISH', 'FINLAND', null, 'WE8MSWIN1252',unistr('suomi'),unistr('fmday dd. month"ta "yyyy'),unistr('fmDD.MM.RRRR'));
    ins_lang( 72, 'fo', null, 'Faeroese', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Faeroese'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 73, 'fr', null, 'French (France)', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 74, 'fr-be', null, 'French (Belgium)', 'FRENCH', 'BELGIUM', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 75, 'fr-ca', null, 'French (Canada)', 'CANADIAN FRENCH', 'CANADA', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday dd month yyyy'),unistr('RRRR-MM-DD'));
    ins_lang( 76, 'fr-ch', null, 'French (Switzerland)', 'FRENCH', 'SWITZERLAND', null, 'WE8MSWIN1252',unistr('French (Switzerland)'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 77, 'fr-lu', null, 'French (Luxembourg)', 'FRENCH', 'LUXEMBOURG', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 78, 'fr-mc', null, 'French (Monaco)', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 79, 'ga', null, 'Irish', 'IRISH', 'IRELAND', null, 'WE8MSWIN1252', unistr('Gaeilge'), unistr('fmDay fmdd fmMonth yyyy'), unistr('DD/MM/RRRR'));
    ins_lang( 80, 'gd', null, 'Gaelic', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Gaelic'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 81, 'gl', null, 'Galician', 'SPANISH', 'SPAIN', null, 'WE8MSWIN1252',unistr('Galician'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 82, 'gu', null, 'Gujarati', 'GUJARATI', 'INDIA', null, 'AL32UTF8',unistr('\0A97\0AC1\0A9C\0AB0\0ABE\0AA4\0AC0'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 83, 'he', null, 'Hebrew', 'HEBREW', 'ISRAEL', null, 'IW8MSWIN1255',unistr('\05E2\05D1\05E8\05D9\05EA'),unistr('fmDay dd Month yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 84, 'hi', null, 'Hindi', 'HINDI', 'INDIA', null, 'AL32UTF8',unistr('\0939\093F\0928\094D\0926\0940'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 85, 'hr', null, 'Croatian', 'CROATIAN', 'CROATIA', null, 'EE8MSWIN1250',unistr('Hrvatski'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RR'));
    ins_lang( 86, 'hu', null, 'Hungarian', 'HUNGARIAN', 'HUNGARY', null, 'EE8MSWIN1250',unistr('magyar'),unistr('fmyyyy. month dd., day'),unistr('RRRR.MM.DD.'));
    ins_lang( 87, 'id', null, 'Indonesian', 'INDONESIAN', 'INDONESIA', null, 'WE8MSWIN1252',unistr('Bahasa Indonesia'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD-MM-RRRR'));
    ins_lang( 88, 'is', null, 'Icelandic', 'ICELANDIC', 'ICELAND', null, 'WE8MSWIN1252',unistr('\00EDslenska'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 89, 'it', null, 'Italian (Italy)', 'ITALIAN', 'ITALY', null, 'WE8MSWIN1252',unistr('Italiano'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 90, 'it-ch', null, 'Italian (Switzerland)', 'ITALIAN', 'SWITZERLAND', null, 'WE8MSWIN1252',unistr('Italiano'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 91, 'ja', null, 'Japanese', 'JAPANESE', 'JAPAN', null, 'JA16SJIS',unistr('\65E5\672C\8A9E'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" Day'),unistr('RRRR/MM/DD'));
    ins_lang( 92, 'kk', null, 'Kazakh', 'CYRILLIC KAZAKH', 'KAZAKHSTAN', null, 'CL8MSWIN1251',unistr('Kazakh'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 93, 'kn', null, 'Kannada', 'KANNADA', 'INDIA', null, 'AL32UTF8',unistr('\0C95\0CA8\0CCD\0CA8\0CA1'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 94, 'ko', null, 'Korean', 'KOREAN', 'KOREA', null, 'KO16MSWIN949',unistr('\D55C\AD6D\C5B4'),unistr('fmyyyy"\B144" mm"\C6D4" dd"\C77C" day'),unistr('RRRR/MM/DD'));
    ins_lang( 95, 'kok', null, 'Konkani', 'KOREAN', 'KOREA', null, 'KO16MSWIN949',unistr('Konkani'),unistr('fmyyyy"\B144" mm"\C6D4" dd"\C77C" day'),unistr('RRRR/MM/DD'));
    ins_lang( 96, 'kz', null, 'Kyrgyz', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251',unistr('Kyrgyz'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'));
    ins_lang( 97, 'lt', null, 'Lithuanian', 'LITHUANIAN', 'LITHUANIA', null, 'BLT8MSWIN1257',unistr('Lietuvi\0173'),unistr('fmday yyyy"m." month dd "d."'),unistr('RRRR-MM-DD'));
    ins_lang( 98, 'lv', null, 'Latvian', 'LATVIAN', 'LATVIA', null, 'BLT8MSWIN1257',unistr('Latvie\0161u valoda'),unistr('fmDay, yyyy". gada "dd. Month'),unistr('RRRR.MM.DD'));
    ins_lang( 99, 'mk', null, 'FYRO Macedonian', 'MACEDONIAN', 'FYR MACEDONIA', null, 'CL8MSWIN1251',unistr('\041C\0430\043A\0435\0434\043E\043D\0441\043A\0438'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 100, 'ml', null, 'Malayalam', 'MALAYALAM', 'INDIA', null, 'AL32UTF8',unistr('\0D2E\0D32\0D2F\0D3E\0D33\0D02'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 101, 'mr', null, 'Marathi', 'MARATHI', 'INDIA', null, 'AL32UTF8',unistr('\092E\0930\093E\0920\0940'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 102, 'ms', null, 'Malay (Malaysia)', 'MALAY', 'MALAYSIA', null, 'WE8MSWIN1252',unistr('Bahasa Malaysia'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 103, 'mt', null, 'Maltese', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Maltese'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 104, 'nb-no', null, 'Norwegian (Bokmal)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252',unistr('Norsk'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 105, 'ne', null, 'Nepali (India)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Nepali (India)'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 106, 'nl', null, 'Dutch (Netherlands)', 'DUTCH', 'THE NETHERLANDS', null, 'WE8MSWIN1252',unistr('Nederlands'),unistr('fmday dd month yyyy'),unistr('fmDD-MM-RRRR'));
    ins_lang( 107, 'nl-be', null, 'Dutch (Belgium)', 'DUTCH', 'BELGIUM', null, 'WE8MSWIN1252',unistr('Nederlands'),unistr('fmday dd month yyyy'),unistr('fmDD/fmMM/RRRR'));
    ins_lang( 108, 'nn-no', null, 'Norwegian (Nynorsk)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252',unistr('Norsk'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 109, 'no', null, 'Norwegian (Bokmal)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252',unistr('Norsk'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 110, 'or', null, 'Oriya', 'ORIYA', 'INDIA', null, 'AL32UTF8',unistr('\0B13\0B21\0B3F\0B06'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 111, 'pa', null, 'Punjabi', 'PUNJABI', 'INDIA', null, 'AL32UTF8',unistr('Punjabi'),unistr('dd fmmonth yyyy day'),unistr('DD-MM-RR'));
    ins_lang( 112, 'pl', null, 'Polish', 'POLISH', 'POLAND', null, 'EE8MSWIN1250',unistr('polski'),unistr('fmday, dd month yyyy'),unistr('RRRR-MM-DD'));
    ins_lang( 113, 'pt', null, 'Portuguese (Portugal)', 'PORTUGUESE', 'PORTUGAL', null, 'WE8MSWIN1252',unistr('Portugu\00EAs (Portugal)'),unistr('fmday, dd" de "Month" de "yyyy'),unistr('DD-MM-RRRR'));
    ins_lang( 114, 'pt-br', null, 'Portuguese (Brazil)', 'BRAZILIAN PORTUGUESE', 'BRAZIL', null, 'WE8MSWIN1252',unistr('Portugu\00EAs (Brasil)'),unistr('fmday, dd" de "month" de "yyyy'),unistr('fmDD/MM/RRRR'));
    ins_lang( 115, 'ro', null, 'Romanian', 'ROMANIAN', 'ROMANIA', null, 'EE8MSWIN1250',unistr('Rom\00E2n\0103'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 116, 'ru', null, 'Russian', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251',unistr('\0420\0443\0441\0441\043A\0438\0439'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'));
    ins_lang( 117, 'ru-md', null, 'Russian (Moldova)', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251',unistr('\0420\0443\0441\0441\043A\0438\0439'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'));
    ins_lang( 118, 'sk', null, 'Slovak', 'SLOVAK', 'SLOVAKIA', null, 'EE8MSWIN1250',unistr('Sloven\010Dina'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RR'));
    ins_lang( 119, 'sl', null, 'Slovenian', 'SLOVENIAN', 'SLOVENIA', null, 'EE8MSWIN1250',unistr('Sloven\0161\010Dina'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RR'));
    ins_lang( 120, 'sr', null, 'Serbian', 'CYRILLIC SERBIAN', 'SERBIA AND MONTENEGRO', null, 'CL8MSWIN1251',unistr('\0441\0440\043F\0441\043A\0438'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RRRR'));
    ins_lang( 121, 'sv', null, 'Swedish', 'SWEDISH', 'SWEDEN', null, 'WE8MSWIN1252',unistr('Svenska'),unistr('fmday "den "dd month yyyy'),unistr('RRRR-MM-DD'));
    ins_lang( 122, 'sv-fi', null, 'Swedish (Finland)', 'SWEDISH', 'FINLAND', null, 'WE8MSWIN1252',unistr('Svenska'),unistr('fmday "den "dd month yyyy'),unistr('fmDD.MM.RRRR'));
    ins_lang( 123, 'ta', null, 'Tamil', 'TAMIL', 'INDIA', null, 'AL32UTF8',unistr('\0BA4\0BAE\0BBF\0BB4\0BCD'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 124, 'te', null, 'Telugu', 'TELUGU', 'INDIA', null, 'AL32UTF8',unistr('\0C24\0C46\0C32\0C41\0C17\0C41'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'));
    ins_lang( 125, 'th', null, 'Thai', 'THAI', 'THAILAND', null, 'TH8TISASCII',unistr('\0E44\0E17\0E22'),unistr('fmday dd month E yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 126, 'tr', null, 'Turkish', 'TURKISH', 'TURKEY', null, 'TR8MSWIN1254',unistr('T\00FCrk\00E7e'),unistr('dd fmMonth yyyy Day'),unistr('DD.MM.RRRR'));
    ins_lang( 127, 'uk', null, 'Ukrainian', 'UKRAINIAN', 'UKRAINE', null, 'CL8MSWIN1251',unistr('\0423\043A\0440\0430\0457\043D\0441\044C\043A\0430'),unistr('fmday dd month yyyy" \0440\043E\043A\0443"'),unistr('DD.MM.RRRR'));
    ins_lang( 128, 'ur', null, 'Urdu', 'ENGLISH', 'UNITED KINGDOM', null, 'AR8MSWIN1256',unistr('Urdu'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'));
    ins_lang( 129, 'uz', null, 'Uzbek', 'LATIN UZBEK', 'UZBEKISTAN', null, 'AL32UTF8',unistr('Uzbek'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD/MON/RR'));
    ins_lang( 130, 'vi', null, 'Vietnamese', 'VIETNAMESE', 'VIETNAM', null, 'VN8MSWIN1258',unistr('Ti\1EBFng Vi\1EC7t'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RRRR'));
    ins_lang( 131, 'zh', null, 'Chinese', 'SIMPLIFIED CHINESE', 'CHINA', null, 'ZHS16GBK',unistr('\4E2D\6587\FF08\7B80\4F53\FF09'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('RRRR-MM-DD'));
    ins_lang( 132, 'zh-cn', null, 'Chinese (China)', 'SIMPLIFIED CHINESE', 'CHINA', null, 'ZHS16GBK',unistr('\4E2D\6587\FF08\7B80\4F53\FF09'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('RRRR-MM-DD'));
    ins_lang( 133, 'zh-hk', null, 'Chinese (Hong Kong SAR)', 'TRADITIONAL CHINESE', 'HONG KONG', null, 'ZHT16MSWIN950',unistr('Chinese (Hong Kong SAR)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmDD/MM/RRRR'));
    ins_lang( 134, 'zh-mo', null, 'Chinese (Macau SAR)', 'TRADITIONAL CHINESE', 'HONG KONG', null, 'ZHT16MSWIN950',unistr('Chinese (Macau SAR)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmDD/MM/RRRR'));
    ins_lang( 135, 'zh-sg', null, 'Chinese (Singapore)', 'SIMPLIFIED CHINESE', 'SINGAPORE', null, 'ZHS16GBK',unistr('Chinese (Singapore)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmDD/MM/RRRR'));
    ins_lang( 136, 'zh-tw', null, 'Chinese (Taiwan)', 'TRADITIONAL CHINESE', 'TAIWAN', null, 'ZHT16MSWIN950',unistr('\4E2D\6587 (\7E41\9AD4)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmRRRR/MM/DD'));
    ins_lang( 137, 'az', null, 'Azerbaijani', 'AZERBAIJANI', 'AZERBAIJAN', null, 'AL32UTF8',unistr('Az\0259rbaycan'),unistr('fmdd Month yyyy, Day'),unistr('DD.MM.RRRR'));    
    ins_lang( 138, 'sw', null, 'Swahili', 'SWAHILI', 'KENYA', null, 'AL32UTF8', 'Swahili', unistr('Day, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'));    

    update wwv_flow_languages set translated_lang_name = lang_name where translated_lang_name is null;
    commit;
end;
/

prompt
prompt ...insert into wwv_flow_flash_map_folders
prompt

begin
delete from wwv_flow_flash_map_folders;
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (1,'europe',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (2,'africa',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (3,'asia',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (4,'north_america',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (5,'south_america',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (6,'world',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (7,'oceania',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (8,'custom',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (9,'usa',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (10,'regions',9);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (11,'sub_regions',9);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (12,'country',9);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (13,'states',9);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (14,'states_r',10);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (15,'zip_r',10);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (16,'zip_sr',11);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (17,'states_sr',11);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (18,'counties_sr',11);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (19,'counties_s',13);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (20,'zip_s',13);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (21,'counties',null);
insert into wwv_flow_flash_map_folders(id,folder_name,parent_id) values (22,'zip3',null);
commit;
end;
/

prompt
prompt ...insert into wwv_flow_flash_map_files
prompt

delete from wwv_flow_flash_map_files;

prompt -- Europe
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (301,1,'Europe','europe','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (1,1,'Albania','europe/albania.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (2,1,'Austria (Second Level)','europe/austria_second_level.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (3,1,'Austria','europe/austria.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (4,1,'Belgium','europe/belgium.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (5,1,'Belgium (Second Level)','europe/belgium_second_level.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (6,1,'Bulgaria','europe/bulgaria.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (7,1,'Byelarus','europe/byelarus.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (8,1,'Czech Republic','europe/czech_republic.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (9,1,'Denmark','europe/denmark.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (10,1,'Finland','europe/finland.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (11,1,'France','europe/france.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (12,1,'France (Second Level)','europe/france_second_level.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (13,1,'Germany','europe/germany.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (14,1,'Germany (Second Level)','europe/germany_second_level.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (15,1,'Greece','europe/greece.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (16,1,'Hungary','europe/hungary.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (17,1,'Iceland','europe/iceland.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (18,1,'Ireland','europe/ireland.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (19,1,'Italy','europe/italy.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (20,1,'Italy (Second Level)','europe/italy_second_level.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (21,1,'Netherlands','europe/netherlands.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (22,1,'Norway','europe/norway.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (23,1,'Norway (Second Level)','europe/norway_second_level.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (24,1,'Poland','europe/poland.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (25,1,'Portugal','europe/portugal.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (26,1,'Romania','europe/romania.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (27,1,'Spain','europe/spain.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (28,1,'Sweden','europe/sweden.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (29,1,'Sweden (Second Level)','europe/sweden_second_level.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (30,1,'Switzerland','europe/switzerland.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (31,1,'UK - England','europe/uk_england.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (32,1,'UK - Northern Ireland','europe/uk_northern_ireland.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (33,1,'UK - Scotland','europe/uk_scotland.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (34,1,'UK - Wales','europe/uk_wales.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (35,1,'Ukraine','europe/ukraine.amap','Orthographic',301);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (36,1,'United Kingdom','europe/united_kingdom.amap','Orthographic',301);
end;
/

prompt -- Africa
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (302,2,'Africa','africa','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (37,2,'Algeria','africa/algeria.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (38,2,'Angola','africa/angola.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (39,2,'Benin','africa/benin.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (40,2,'Botswana','africa/botswana.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (41,2,'Burkina Faso','africa/burkina_faso.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (42,2,'Burundi','africa/burundi.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (43,2,'Cameroon','africa/cameroon.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (44,2,'Central African Republic','africa/central_african_republic.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (45,2,'Chad','africa/chad.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (46,2,'Congo','africa/congo.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (47,2,'Djibouti','africa/djibouti.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (48,2,'Egypt','africa/egypt.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (49,2,'Equatorial Guinea','africa/equatorial_guinea.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (50,2,'Eritrea','africa/eritrea.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (51,2,'Ethiopia','africa/ethiopia.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (52,2,'Gabon','africa/gabon.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (53,2,'Gambia','africa/gambia.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (54,2,'Ghana','africa/ghana.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (55,2,'Guinea','africa/guinea.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (56,2,'Guinea Bissau','africa/guinea_bissau.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (57,2,'Ivory Coast','africa/ivory_coast.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (58,2,'Kenya','africa/kenya.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (59,2,'Lesotho','africa/lesotho.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (60,2,'Liberia','africa/liberia.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (61,2,'Madagascar','africa/madagascar.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (62,2,'Malawi','africa/malawi.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (63,2,'Mali','africa/mali.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (64,2,'Mauritania','africa/mauritania.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (65,2,'Morocco','africa/morocco.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (66,2,'Mozambique','africa/mozambique.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (67,2,'Namibia','africa/namibia.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (68,2,'Niger','africa/niger.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (69,2,'Nigeria','africa/nigeria.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (70,2,'Rwanda','africa/rwanda.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (71,2,'Senegal','africa/senegal.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (72,2,'Sierra Leone','africa/sierra_leone.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (73,2,'Somalia','africa/somalia.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (74,2,'South Africa','africa/south_africa.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (75,2,'Sudan','africa/sudan.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (76,2,'Swaziland','africa/swaziland.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (77,2,'Tanzania','africa/tanzania.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (78,2,'Togo','africa/togo.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (79,2,'Tunisia','africa/tunisia.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (80,2,'Uganda','africa/uganda.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (81,2,'Zaire','africa/zaire.amap','Orthographic',302);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (82,2,'Zambia','africa/zambia.amap','Orthographic',302);
end;
/

prompt -- Asia
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (303,3,'Asia','asia','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (83,3,'Afghanistan','asia/afghanistan.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (84,3,'Bahrain','asia/bahrain.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (85,3,'Bangladesh','asia/bangladesh.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (86,3,'Bhutan','asia/bhutan.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (87,3,'Cambodia','asia/cambodia.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (88,3,'China','asia/china.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (89,3,'Cyprus','europe/cyprus.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (90,3,'India','asia/india.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (91,3,'Indonesia','asia/indonesia.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (92,3,'Iran','asia/iran.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (93,3,'Iraq','asia/iraq.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (94,3,'Israel','asia/israel.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (95,3,'Japan','asia/japan.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (96,3,'Japan (Second Level)','asia/japan_second_level.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (97,3,'Jordan','asia/jordan.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (98,3,'Kazakhstan','asia/kazakhstan.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (99,3,'Kuwait','asia/kuwait.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (100,3,'Laos','asia/laos.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (101,3,'Lebanon','asia/lebanon.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (102,3,'Malaysia','asia/malaysia.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (103,3,'Maldives','asia/maldives.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (104,3,'Mongolia','asia/mongolia.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (105,3,'Myanmar','asia/myanmar.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (106,3,'Nepal','asia/nepal.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (107,3,'North Korea','asia/north_korea.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (108,3,'Pakistan','asia/pakistan.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (109,3,'Philippines','asia/philippines.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (110,3,'Russia','asia/russia.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (111,3,'Saudi Arabia','asia/saudi_arabia.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (112,3,'South Korea','asia/south_korea.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (113,3,'Syria','asia/syria.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (114,3,'Taiwan','asia/taiwan.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (115,3,'Thailand','asia/thailand.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (116,3,'Turkey','asia/turkey.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (117,3,'United Arab Emirates','asia/united_arab_emirates.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (118,3,'Vietnam','asia/vietnam.amap','Orthographic',303);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (119,3,'Yemen','asia/yemen.amap','Orthographic',303);
end;
/

prompt -- North America
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (304,4,'North America','north_america','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (120,4,'Belize','north_america/belize.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (121,4,'Canada','north_america/canada.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (122,4,'Costa Rica','north_america/costa_rica.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (123,4,'Cuba','north_america/cuba.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (124,4,'El Salvador','north_america/el_salvador.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (125,4,'Greenland','north_america/greenland.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (126,4,'Guatemala','north_america/guatemala.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (127,4,'Haiti','north_america/haiti.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (128,4,'Honduras','north_america/honduras.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (129,4,'Jamaica','north_america/jamaica.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (130,4,'Mexico','north_america/mexico.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (131,4,'Nicaragua','north_america/nicaragua.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (132,4,'Panama','north_america/panama.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (133,4,'USA and Canada','north_america/usa_and_canada.amap','Orthographic',304);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (134,4,'USA, Canada and Mexico','north_america/usa_canada_and_mexico.amap','Orthographic',304);
end;
/

prompt -- South America
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (305,5,'South America','south_america','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (135,5,'Argentina','south_america/argentina.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (136,5,'Bolivia','south_america/bolivia.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (137,5,'Brazil','south_america/brazil.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (138,5,'Chile','south_america/chile.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (139,5,'Colombia','south_america/colombia.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (140,5,'Ecuador','south_america/ecuador.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (141,5,'French Guiana','south_america/french_guiana.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (142,5,'Guyana','south_america/guyana.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (143,5,'Paraguay','south_america/paraguay.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (144,5,'Peru','south_america/peru.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (145,5,'Suriname','south_america/suriname.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (146,5,'Uruguay','south_america/uruguay.amap','Orthographic',305);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (147,5,'Venezuela','south_america/venezuela.amap','Orthographic',305);
end;
/

prompt -- World Maps
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (306,6,'World and Continent Maps','world','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (148,6,'Africa','world/africa.amap','Orthographic',306);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (149,6,'Americas','world/americas.amap','Orthographic',306);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (150,6,'Europe','world/europe.amap','Orthographic',306);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (151,6,'Europe (without Russia)','world/europe_without_russia.amap','Orthographic',306);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (152,6,'North America','world/north_america.amap','Orthographic',306);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (153,6,'South America','world/south_america.amap','Orthographic',306);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (154,6,'World','world/world.amap','Orthographic',306);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (155,6,'World (without Greenland)','world/world_wo_gr.amap','Orthographic',306);
end;
/

prompt -- Oceania
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values(307,7,'Oceania','oceania','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (156,7,'Australia','oceania/australia.amap','Orthographic',307);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (157,7,'New Zealand','oceania/new_zealand.amap','Orthographic',307);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (158,7,'Papua New Guinea','oceania/papua_new_guinea.amap','Orthographic',307);
end;
/

prompt -- Custom Maps
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (308,8,'Custom Maps','custom','Orthographic');
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (159,8,'Sydney','custom/sydney.amap','Orthographic',308);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (160,8,'USA States','custom/usa_states.amap','Orthographic',308);
end;
/

prompt -- USA Maps
begin
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection) values (309,9,'United States of America','usa','Orthographic');
-- Regions
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (310,9,'Regions','regions','Orthographic',309);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (311,14,'State Maps for All Regions','states','Orthographic',310);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (161,14,'Midwest','usa/regions/states/midwest.amap','Orthographic',311);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (162,14,'Northeast','usa/regions/states/northeast.amap','Orthographic',311);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (163,14,'South','usa/regions/states/south.amap','Orthographic',311);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (164,14,'West','usa/regions/states/west.amap','Orthographic',311);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (312,15,'3-digit ZIP Code Maps for All Regions','zip3','Orthographic',310);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (165,15,'Midwest','usa/regions/zip3/midwest.amap','Orthographic',312);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (166,15,'Northeast','usa/regions/zip3/northeast.amap','Orthographic',312);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (167,15,'South','usa/regions/zip3/south.amap','Orthographic',312);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (168,15,'West','usa/regions/zip3/west.amap','Orthographic',312);
-- Sub-Regions
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (313,9,'Sub-Regions','sub_regions','Orthographic',309);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (314,16,'3-digit ZIP Code Maps for All Sub-Regions','zip3','Orthographic',313);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (169,16,'East North Central','usa/sub_regions/zip3/east_north_central.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (170,16,'East South Central','usa/sub_regions/zip3/east_south_central.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (171,16,'Middle Atlantic','usa/sub_regions/zip3/middle_atlantic.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (172,16,'Mountain','usa/sub_regions/zip3/mountain.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (173,16,'New England','usa/sub_regions/zip3/new_england.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (174,16,'Pacific','usa/sub_regions/zip3/pacific.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (175,16,'South Atlantic','usa/sub_regions/zip3/south_atlantic.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (176,16,'West North Central','usa/sub_regions/zip3/west_north_central.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (177,16,'West South Central','usa/sub_regions/zip3/west_south_central.amap','Orthographic',314);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (315,17,'State Maps for All Sub-Regions','states','Orthographic',313);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (178,17,'East North Central','usa/sub_regions/states/east_north_central.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (179,17,'East South Central','usa/sub_regions/states/east_south_central.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (180,17,'Middle Atlantic','usa/sub_regions/states/middle_atlantic.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (181,17,'Mountain','usa/sub_regions/states/mountain.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (182,17,'New England','usa/sub_regions/states/new_england.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (183,17,'Pacific','usa/sub_regions/states/pacific.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (184,17,'South Atlantic','usa/sub_regions/states/south_atlantic.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (185,17,'West North Central','usa/sub_regions/states/west_north_central.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (186,17,'West South Central','usa/sub_regions/states/west_south_central.amap','Orthographic',315);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (316,18,'County Maps for All Sub-Regions','counties','Orthographic',313);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (187,18,'East North Central','usa/sub_regions/counties/east_north_central.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (188,18,'East South Central','usa/sub_regions/counties/east_south_central.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (189,18,'Middle Atlantic','usa/sub_regions/counties/middle_atlantic.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (190,18,'Mountain','usa/sub_regions/counties/mountain.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (191,18,'New England','usa/sub_regions/counties/new_england.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (192,18,'Pacific','usa/sub_regions/counties/pacific.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (193,18,'South Atlantic','usa/sub_regions/counties/south_atlantic.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (194,18,'West North Central','usa/sub_regions/counties/west_north_central.amap','Orthographic',316);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (195,18,'West South Central','usa/sub_regions/counties/west_south_central.amap','Orthographic',316);
-- Country
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (317,9,'Country Maps','country','Orthographic',309);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (196,12,'States','usa/country/states.amap','Orthographic',317);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (197,12,'Sub-Regions','usa/country/sub_regions.amap','Orthographic',317);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (198,12,'States without Alaska and Hawaii','usa/country/states_48.amap','Orthographic',317);
-- States
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (318,9,'States','states','Orthographic',309);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (319,19,'County Maps for All 50 States','counties','Orthographic',318);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (199,19,'Alaska','usa/states/counties/ak.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (200,19,'Alabama','usa/states/counties/al.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (201,19,'Arkansas','usa/states/counties/ar.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (202,19,'Arizona','usa/states/counties/az.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (203,19,'California','usa/states/counties/ca.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (204,19,'Colorado','usa/states/counties/co.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (205,19,'Connecticut','usa/states/counties/ct.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (206,19,'Delaware','usa/states/counties/de.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (207,19,'Florida','usa/states/counties/fl.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (208,19,'Georgia','usa/states/counties/ga.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (209,19,'Hawaii','usa/states/counties/hi.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (210,19,'Iowa','usa/states/counties/ia.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (211,19,'Idaho','usa/states/counties/id.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (212,19,'Illinois','usa/states/counties/il.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (213,19,'Indiania','usa/states/counties/in.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (214,19,'Kansas','usa/states/counties/ks.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (215,19,'Kentucky','usa/states/counties/ky.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (216,19,'Louisiana','usa/states/counties/la.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (217,19,'Massachusetts','usa/states/counties/ma.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (218,19,'Maryland','usa/states/counties/md.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (219,19,'Maine','usa/states/counties/me.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (220,19,'Michigan','usa/states/counties/mi.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (221,19,'Minnesota','usa/states/counties/mn.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (222,19,'Missouri','usa/states/counties/mo.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (223,19,'Mississippi','usa/states/counties/ms.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (224,19,'Montana','usa/states/counties/mt.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (225,19,'North Carolina','usa/states/counties/nc.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (226,19,'North Dakota','usa/states/counties/nd.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (227,19,'Nebraska','usa/states/counties/ne.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (228,19,'New Hampshire','usa/states/counties/nh.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (229,19,'New Jersey','usa/states/counties/nj.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (230,19,'New Mexico','usa/states/counties/nm.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (231,19,'Nevada','usa/states/counties/nv.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (232,19,'New York','usa/states/counties/ny.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (233,19,'Ohio','usa/states/counties/oh.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (234,19,'Oklahoma','usa/states/counties/ok.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (235,19,'Oregan','usa/states/counties/or.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (236,19,'Pennsylvania','usa/states/counties/pa.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (237,19,'Rhode Island','usa/states/counties/ri.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (238,19,'South Carolina','usa/states/counties/sc.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (239,19,'South Dakota','usa/states/counties/sd.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (240,19,'Tennessee','usa/states/counties/tn.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (241,19,'Texas','usa/states/counties/tx.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (242,19,'Utah','usa/states/counties/ut.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (243,19,'Virginia','usa/states/counties/va.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (244,19,'Vermont','usa/states/counties/vt.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (245,19,'Washington','usa/states/counties/wa.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (246,19,'Wisconsin','usa/states/counties/wi.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (247,19,'West Virginia','usa/states/counties/wv.amap','Orthographic',319);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (248,19,'Wyoming','usa/states/counties/wy.amap','Orthographic',319);

insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (320,20,'3-digit ZIP Code Maps for All 50 States','zip3','Orthographic',318);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (249,20,'Alaska','usa/states/zip3/ak.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (250,20,'Alabama','usa/states/zip3/al.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (251,20,'Arkansas','usa/states/zip3/ar.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (252,20,'Arizona','usa/states/zip3/az.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (253,20,'California','usa/states/zip3/ca.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (254,20,'Colorado','usa/states/zip3/co.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (255,20,'Connecticut','usa/states/zip3/ct.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (256,20,'District of Columbia','usa/states/zip3/dc.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (257,20,'Delaware','usa/states/zip3/de.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (258,20,'Florida','usa/states/zip3/fl.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (259,20,'Georgia','usa/states/zip3/ga.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (260,20,'Hawaii','usa/states/zip3/hi.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (261,20,'Iowa','usa/states/zip3/ia.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (262,20,'Idaho','usa/states/zip3/id.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (263,20,'Illinois','usa/states/zip3/il.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (264,20,'Indiania','usa/states/zip3/in.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (265,20,'Kansas','usa/states/zip3/ks.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (266,20,'Kentucky','usa/states/zip3/ky.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (267,20,'Louisiana','usa/states/zip3/la.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (268,20,'Massachusetts','usa/states/zip3/ma.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (269,20,'Maryland','usa/states/zip3/md.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (270,20,'Maine','usa/states/zip3/me.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (271,20,'Michigan','usa/states/zip3/mi.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (272,20,'Minnesota','usa/states/zip3/mn.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (273,20,'Missouri','usa/states/zip3/mo.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (274,20,'Mississippi','usa/states/zip3/ms.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (275,20,'Montana','usa/states/zip3/mt.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (276,20,'North Carolina','usa/states/zip3/nc.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (277,20,'North Dakota','usa/states/zip3/nd.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (278,20,'Nebraska','usa/states/zip3/ne.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (279,20,'New Hampshire','usa/states/zip3/nh.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (280,20,'New Jersey','usa/states/zip3/nj.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (281,20,'New Mexico','usa/states/zip3/nm.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (282,20,'Nevada','usa/states/zip3/nv.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (283,20,'New York','usa/states/zip3/ny.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (284,20,'Ohio','usa/states/zip3/oh.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (285,20,'Oklahoma','usa/states/zip3/ok.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (286,20,'Oregan','usa/states/zip3/or.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (287,20,'Pennsylvania','usa/states/zip3/pa.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (288,20,'Puerto Rico','usa/states/zip3/pr.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (289,20,'Rhode Island','usa/states/zip3/ri.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (290,20,'South Carolina','usa/states/zip3/sc.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (291,20,'South Dakota','usa/states/zip3/sd.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (292,20,'Tennessee','usa/states/zip3/tn.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (293,20,'Texas','usa/states/zip3/tx.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (294,20,'Utah','usa/states/zip3/ut.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (295,20,'Virginia','usa/states/zip3/va.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (296,20,'Vermont','usa/states/zip3/vt.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (297,20,'Washington','usa/states/zip3/wa.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (298,20,'Wisconsin','usa/states/zip3/wi.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (299,20,'West Virginia','usa/states/zip3/wv.amap','Orthographic',320);
insert into wwv_flow_flash_map_files(id,folder_id,map_name,map_file_path,projection,parent_id) values (300,20,'Wyoming','usa/states/zip3/wy.amap','Orthographic',320);
commit;
end;
/
prompt
prompt ...insert into wwv_flow_flash_map_regions
prompt

begin
select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';
end;
/

begin execute immediate 'alter session set nls_numeric_characters=''.,'''; end;
/

delete from wwv_flow_flash_map_regions;
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1,1,'ALB-BER','Berat','19.9663867950439','40.6855506896973');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2,1,'ALB-DIB','Dibre','20.331974029541','41.5942993164063');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3,1,'ALB-DRR','Durres','19.5917167663574','41.3030319213867');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4,1,'ALB-ELB','Elbasan','20.0143032073975','41.0798568725586');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(5,1,'ALB-FIE','Fier','19.6067981719971','40.6549644470215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(6,1,'ALB-GJR','Gjirokaster','20.1722202301025','40.0276336669922');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(7,1,'ALB-GRM','Gramsh','20.2434692382813','40.8405532836914');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(8,1,'ALB-KLN','Kolonje','20.6222114562988','40.2918014526367');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(9,1,'ALB-KOR','Korce','20.6688861846924','40.6835479736328');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(10,1,'ALB-KRU','Kruje','19.7402763366699','41.5620803833008');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(11,1,'ALB-KUK','Kukes','20.3890247344971','42.0886993408203');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(12,1,'ALB-LBR','Librazhd','20.3610000610352','41.1593017578125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(13,1,'ALB-LEZ','Lezhe','19.6890449523926','41.8155727386475');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(14,1,'ALB-LSH','Lushnje','19.6568565368652','40.942497253418');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(15,1,'ALB-MAT','Mat','20.0458316802979','41.5676345825195');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(16,1,'ALB-MRD','Mirdite','19.9808311462402','41.8712463378906');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(17,1,'ALB-PGR','Pogradec','20.6129150390625','40.9513130187988');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(18,1,'ALB-PRM','Permet','20.3455543518066','40.2854118347168');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(19,1,'ALB-PUK','Puke','19.9624862670898','42.0815086364746');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(20,1,'ALB-SHK','Shkoder','19.5876121520996','42.248592376709');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(21,1,'ALB-SKR','Skrapar','20.2668037414551','40.5615234375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(22,1,'ALB-SRN','Sarande','20.079719543457','39.906665802002');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(23,1,'ALB-TIR','Tirane','19.9215259552002','41.3312454223633');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(24,1,'ALB-TPL','Tepelene','19.9540576934814','40.3584671020508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(25,1,'ALB-TRP','Tropoje','20.0720024108887','42.382080078125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(26,1,'ALB-VLO','Vlore','19.5851364135742','40.3569450378418');
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(27,2,'AUT001001','Eisenstadt','AUT001','16.533597','47.8384105');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(28,2,'AUT001002','Eisenstadt-Umgebung','AUT001','16.533597','47.8384105');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(29,2,'AUT001003','Guessing','AUT001','16.3031664533081','47.11598377771');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(30,2,'AUT001004','Jennersdorf','AUT001','16.1422420346212','46.9835957609863');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(31,2,'AUT001005','Mattersburg','AUT001','16.410092427063','47.7276925');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(32,2,'AUT001006','Neusiedl am See','AUT001','16.9289309096069','47.9018367273321');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(33,2,'AUT001007','Oberpullendorf','AUT001','16.4964322214356','47.5041305');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(34,2,'AUT001008','Oberwart','AUT001','16.2540493714599','47.286981');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(35,2,'AUT001009','Rust','AUT001','16.685799','47.803464');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(36,2,'AUT002001','Feldkirchen','AUT002','14.0246375','46.7956855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(37,2,'AUT002002','Hermagor','AUT002','13.129907','46.6564210137939');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(38,2,'AUT002003','Klagenfurt','AUT002','14.3123735','46.641342');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(39,2,'AUT002004','Klagenfurt Land','AUT002','14.295029','46.5840742872314');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(40,2,'AUT002005','Sankt Veit an der Glan','AUT002','14.312786','46.8816965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(41,2,'AUT002006','Spittal an der Drau','AUT002','13.250282','46.8925635');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(42,2,'AUT002007','Villach','AUT002','13.835052','46.6130805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(43,2,'AUT002008','Villach Land','AUT002','13.7655795','46.6380971329109');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(44,2,'AUT002009','Voelkermarkt','AUT002','14.7001850381347','46.6020151568603');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(45,2,'AUT002010','Wolfsberg','AUT002','14.8385609672344','46.8251745854492');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(46,2,'AUT003001','Amstetten','AUT003','14.7331035','47.981732');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(47,2,'AUT003002','Baden','AUT003','16.212477','48.0100635');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(48,2,'AUT003003','Bruck an der Leitha','AUT003','16.7870190130502','48.030582');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(49,2,'AUT003004','Gaenserndorf','AUT003','16.7469230471802','48.3795755');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(50,2,'AUT003005','Gmuend','AUT003','14.938584','48.7841580704346');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(51,2,'AUT003006','Hollabrunn','AUT003','16.017857','48.6686199344482');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(52,2,'AUT003007','Horn','AUT003','15.681686','48.7292072131348');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(53,2,'AUT003008','Korneuburg','AUT003','16.2228875','48.440261');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(54,2,'AUT003009','Krems an der Donau (Stadt)','AUT003','15.6260345','48.409547');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(55,2,'AUT003010','Krems (Land)','AUT003','15.527142','48.4505725');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(56,2,'AUT003011','Lilienfeld','AUT003','15.5544405','47.917576');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(57,2,'AUT003012','Melk','AUT003','15.2367505','48.191962');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(58,2,'AUT003013','Mistelbach','AUT003','16.563027805664','48.5605500841065');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(59,2,'AUT003014','Moedling','AUT003','16.2275725','48.0869075');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(60,2,'AUT003015','Neunkirchen','AUT003','15.9093295','47.663662');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(61,2,'AUT003016','Sankt Poelten (Land)','AUT003','15.637533','48.1381515');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(62,2,'AUT003017','Sankt Poelten (Stadt)','AUT003','15.6472575','48.19302');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(63,2,'AUT003018','Scheibbs','AUT003','15.0894755','47.9273935');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(64,2,'AUT003019','Tulln','AUT003','15.991036','48.347771');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(65,2,'AUT003020','Waidhofen an der Thaya','AUT003','15.362615','48.8475262646485');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(66,2,'AUT003021','Waidhofen an der Ybbs','AUT003','14.79015','47.9509755');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(67,2,'AUT003022','Wiener Neustadt (Land)','AUT003','16.006307','47.69096');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(68,2,'AUT003023','Wiener Neustadt (Stadt)','AUT003','16.2156905','47.808328');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(69,2,'AUT003024','Wien-Umgebung','AUT003','16.3259675','48.1732235');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(70,2,'AUT003025','Zwettl','AUT003','15.161567','48.5530705');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(71,2,'AUT004001','Braunau am Inn','AUT004','13.0529472712402','48.1331946517334');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(72,2,'AUT004002','Eferding','AUT004','14.0065225','48.3441745');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(73,2,'AUT004003','Freistadt','AUT004','14.651337','48.473306770874');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(74,2,'AUT004004','Gmunden','AUT004','13.766225','47.758092');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(75,2,'AUT004005','Grieskirchen','AUT004','13.782684','48.279354');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(76,2,'AUT004006','Kirchdorf an der Krems','AUT004','14.2207185','47.8533185');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(77,2,'AUT004007','Linz','AUT004','14.326559','48.2946285');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(78,2,'AUT004008','Linz-Land','AUT004','14.3052995','48.20003');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(79,2,'AUT004009','Perg','AUT004','14.6941515','48.290365');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(80,2,'AUT004010','Ried im Innkreis','AUT004','13.4106469948205','48.2125165547902');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(81,2,'AUT004011','Rohrbach','AUT004','13.9732216884923','48.5727827915039');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(82,2,'AUT004012','Schaerding','AUT004','13.6354382070348','48.4204377877197');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(83,2,'AUT004013','Steyr','AUT004','14.4220505','48.0557465');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(84,2,'AUT004014','Steyr-Land','AUT004','14.4604815','47.9071405');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(85,2,'AUT004015','Urfahr-Umgebung','AUT004','14.252395','48.422572712523');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(86,2,'AUT004016','Voecklabruck','AUT004','13.5521655','47.9472075');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(87,2,'AUT004017','Wels','AUT004','14.0260975','48.168123');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(88,2,'AUT004018','Wels-Land','AUT004','13.961144','48.128692');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(89,2,'AUT005001','Hallein','AUT005','13.2794580117188','47.612877');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(90,2,'AUT005002','Salzburg','AUT005','13.055632','47.7987225');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(91,2,'AUT005003','Salzburg-Umgebung','AUT005','13.2067331372229','47.8325225');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(92,2,'AUT005004','Sankt Johann im Pongau','AUT005','13.303444','47.2841435');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(93,2,'AUT005005','Tamsweg','AUT005','13.6559355','47.119419');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(94,2,'AUT005006','Zell am See','AUT005','12.575308','47.3606239104004');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(95,2,'AUT006001','Bruck an der Mur','AUT006','15.2337775','47.567612');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(96,2,'AUT006002','Deutschlandsberg','AUT006','15.2025485','46.806860022461');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(97,2,'AUT006003','Feldbach','AUT006','15.846238','46.93112');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(98,2,'AUT006004','Fuerstenfeld','AUT006','15.996623','47.072449');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(99,2,'AUT006005','Graz','AUT006','15.440895','47.0728525');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(100,2,'AUT006006','Graz-Umgebung','AUT006','15.3885585','47.112739');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(101,2,'AUT006007','Hartberg','AUT006','15.9400475','47.325408');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(102,2,'AUT006008','Judenburg','AUT006','14.5714995','47.2326505');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(103,2,'AUT006009','Knittelfeld','AUT006','14.794313','47.2337075');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(104,2,'AUT006010','Leibnitz','AUT006','15.498268','46.816493906128');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(105,2,'AUT006011','Leoben','AUT006','14.9158415','47.4297995');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(106,2,'AUT006012','Liezen','AUT006','14.350595','47.506637');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(107,2,'AUT006013','Muerzzuschlag','AUT006','15.6187705','47.58478');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(108,2,'AUT006014','Murau','AUT006','14.186253','47.1193285');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(109,2,'AUT006015','Radkersburg','AUT006','15.8445993267822','46.7569835579834');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(110,2,'AUT006016','Voitsberg','AUT006','15.0763805','47.0612855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(111,2,'AUT006017','Weiz','AUT006','15.665763','47.294763');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(112,2,'AUT007001','Imst','AUT007','10.8480965325851','47.0859622955323');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(113,2,'AUT007002','Innsbruck-Land','AUT007','11.378076','47.2847525');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(114,2,'AUT007003','Innsbruck-Stadt','AUT007','11.378076','47.2847525');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(115,2,'AUT007004','Kitzbuehel','AUT007','12.3508105','47.4841272200927');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(116,2,'AUT007005','Kufstein','AUT007','12.053561','47.5325157198486');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(117,2,'AUT007006','Landeck','AUT007','10.458943','47.036586');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(118,2,'AUT007007','Lienz','AUT007','12.5433006817627','46.9067601884765');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(119,2,'AUT007008','Reutte','AUT007','10.583380922501','47.370538374878');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(120,2,'AUT007009','Schwaz','AUT007','11.7590038484528','47.286376953125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(121,2,'AUT008001','Bludenz','AUT008','9.91228283807373','47.0707475562744');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(122,2,'AUT008002','Bregenz','AUT008','9.89934134573365','47.409725338623');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(123,2,'AUT008003','Dornbirn','AUT008','9.73614245843506','47.373476');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(124,2,'AUT008004','Feldkirch','AUT008','9.69258571054077','47.2643013000488');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(125,2,'AUT009000','Wien','AUT009','16.3798295','48.220092');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(126,3,'AUT-BRG','Burgenland','16.5878467559814','47.4853763580322');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(127,3,'AUT-KRN','Karnten','13.8723087310791','46.762601852417');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(128,3,'AUT-NDR','Niederosterreich','15.7590174674988','48.2224559783936');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(129,3,'AUT-OBR','Oberosterreich','13.8731861114502','48.1201820373535');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(130,3,'AUT-SLZ','Salzburg','13.0157299041748','47.487190246582');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(131,3,'AUT-STR','Steiermark','14.8765997886658','47.2413005828857');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(132,3,'AUT-TIR','Tirol','11.5516200065613','47.1633262634277');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(133,3,'AUT-VRR','Vorarlberg','9.8831729888916','47.2222175598145');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(134,3,'AUT-WIE','Wien','16.3909950256348','48.2337093353271');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(135,4,'BEL-ANT','Antwerpen','4.71944379806519','51.2479133605957');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(136,4,'BEL-BRB','Brabant','4.52861094474792','50.8677749633789');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(137,4,'BEL-BRS','Bruxelles-Brussel','4.36471962928772','50.8411045074463');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(138,4,'BEL-HAI','Hainaut','3.72611093521118','50.3773612976074');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(139,4,'BEL-LIE','Liege','5.69271278381348','50.4683303833008');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(140,4,'BEL-LMB','Limburg','5.44749975204468','51.0012435913086');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(141,4,'BEL-LXM','Luxembourg','5.493332862854','49.9638862609863');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(142,4,'BEL-NAM','Namur','4.84416627883911','50.215690612793');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(143,4,'BEL-NVL','Nivelles','4.55819344520569','50.6687450408936');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(144,4,'BEL-OVL','Oost-Vlaanderen','3.86263394355774','51.0407676696777');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(145,4,'BEL-WVL','West-Vlaanderen','3.03083324432373','51.0436172485352');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(146,5,'BEL-ANT-ANT','Antwerpen','4.51465606689453','51.2811050415039');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(147,5,'BEL-ANT-MCH','Mechelen','4.49583315849304','51.0873603820801');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(148,5,'BEL-ANT-TRN','Turnhout','4.96853804588318','51.2568016052246');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(149,5,'BEL-BRB-HVL','Halle-Vilvoorde','4.25652742385864','50.8677749633789');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(150,5,'BEL-BRB-LVN','Leuven','4.82083249092102','50.8755550384521');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(151,5,'BEL-BRB-NVL','Nivelles','4.55819344520569','50.6687450408936');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(152,5,'BEL-BRS-BRS','Bruxelles-Brusse','4.36472153663635','50.8411045074463');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(153,5,'BEL-HAI-ATH','Ath','3.70277750492096','50.6124954223633');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(154,5,'BEL-HAI-CHR','Charleroi','4.40333247184753','50.4596462249756');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(155,5,'BEL-HAI-MNS','Mons','3.86872446537018','50.4606895446777');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(156,5,'BEL-HAI-MSC','Mouscron','3.08805549144745','50.7534999847412');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(157,5,'BEL-HAI-SGN','Soignies','4.00315546989441','50.5927753448486');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(158,5,'BEL-HAI-THN','Thuin','4.25686645507813','50.2093105316162');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(159,5,'BEL-HAI-TRN','Tournai','3.47976553440094','50.628490447998');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(160,5,'BEL-LIE-HUY','Huy','5.37342214584351','50.5021648406982');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(161,5,'BEL-LIE-LIE','Liege','5.58805513381958','50.6028785705566');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(162,5,'BEL-LIE-VRV','Verviers','6.03565001487732','50.4451751708984');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(163,5,'BEL-LIE-WRM','Waremme','5.21402764320374','50.6559658050537');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(164,5,'BEL-LMB-HSL','Hasselt','5.31180500984192','50.9234600067139');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(165,5,'BEL-LMB-MSK','Maaseik','5.53686094284058','51.1440200805664');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(166,5,'BEL-LMB-TNG','Tongeren','5.57583236694336','50.8591594696045');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(167,5,'BEL-LXM-ARL','Arlon','5.79013800621033','49.6940650939941');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(168,5,'BEL-LXM-BST','Bastogne','5.72916603088379','50.0829105377197');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(169,5,'BEL-LXM-MNF','Marche-en-Famenn','5.48055505752563','50.2393035888672');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(170,5,'BEL-LXM-NFC','Neufchateau','5.33041644096375','49.9155540466309');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(171,5,'BEL-LXM-VRT','Virton','5.44486093521118','49.6459808349609');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(172,5,'BEL-NAM-DNN','Dinant','5.0626380443573','50.1036052703857');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(173,5,'BEL-NAM-NAM','Namur','4.89888858795166','50.4561042785645');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(174,5,'BEL-NAM-PHL','Philippeville','4.54472208023071','50.1340255737305');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(175,5,'BEL-OVL-ALS','Aalst','3.95749950408936','50.8638896942139');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(176,5,'BEL-OVL-DND','Dendermonde','4.03750395774841','51.0495796203613');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(177,5,'BEL-OVL-EKL','Eeklo','3.60906851291656','51.2273559570313');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(178,5,'BEL-OVL-GNT','Gent','3.66787445545197','51.0629959106445');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(179,5,'BEL-OVL-ODN','Oudenaarde','3.67222201824188','50.836389541626');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(180,5,'BEL-OVL-SNK','Sint-Niklaas','4.11874949932098','51.2134094238281');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(181,5,'BEL-WVL-BRG','Brugge','3.22652757167816','51.1963691711426');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(182,5,'BEL-WVL-DKS','Diksmuide','2.88958299160004','51.0209712982178');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(183,5,'BEL-WVL-IPR','Ieper','2.85666644573212','50.8389091491699');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(184,5,'BEL-WVL-KRT','Kortrijk','3.30250000953674','50.814769744873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(185,5,'BEL-WVL-OST','Oostende','2.9334055185318','51.1888847351074');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(186,5,'BEL-WVL-RSL','Roeselare','3.13013851642609','50.9530487060547');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(187,5,'BEL-WVL-TLT','Tielt','3.31236052513123','50.992639541626');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(188,5,'BEL-WVL-VRN','Veurne','2.68347203731537','51.0411109924316');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(189,6,'BGR-BRG','Burgas','26.9169425964355','42.4537391662598');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(190,6,'BGR-GSO','Grad Sofiya','23.3559703826904','42.6509857177734');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(191,6,'BGR-KHS','Khaskovo','25.7795906066895','42.0204086303711');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(192,6,'BGR-LVC','Lovech','25.0570812225342','43.2497177124023');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(193,6,'BGR-MKH','Mikhaylovgrad','23.3434638977051','43.6151351928711');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(194,6,'BGR-PLD','Plovdiv','24.5580501556396','42.0539207458496');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(195,6,'BGR-RZG','Razgrad','26.5759792327881','43.5515823364258');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(196,6,'BGR-SOF','Sofiya','23.4331932067871','42.2566604614258');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(197,6,'BGR-VAR','Varna','27.568883895874','43.4233245849609');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(198,7,'BLR-BRS','Brest','25.384087562561','52.4574928283691');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(199,7,'BLR-GML','Gomel''','29.5294322967529','52.3038368225098');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(200,7,'BLR-GRD','Grodno','25.1011085510254','53.8576278686523');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(201,7,'BLR-MGL','Mogilev','30.4120769500732','53.5704650878906');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(202,7,'BLR-MNS','Minsk','27.7786064147949','53.6795883178711');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(203,7,'BLR-VTB','Vitebsk','28.6797142028809','55.1954078674316');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(204,8,'CZE-JHC','Jihocesky','14.5646324157715','49.0925350189209');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(205,8,'CZE-JHM','Jihomoravsky','16.7195782661438','49.1539726257324');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(206,8,'CZE-STR','Stredocesky','14.4460997581482','50.036205291748');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(207,8,'CZE-SVC','Severocesky','14.1826386451721','50.57470703125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(208,8,'CZE-SVM','Severomoravsky','17.7632694244385','49.7926387786865');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(209,8,'CZE-VYC','Vychodocesky','15.9453248977661','50.1155738830566');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(210,8,'CZE-ZPD','Zapadocesky','12.9548273086548','49.7134666442871');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(211,9,'DNK-ARH','Arhus','10.4710168838501','56.2404136657715');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(212,9,'DNK-BRN','Bornholm','14.9138879776001','55.1501350402832');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(213,9,'DNK-FRD','Frederiksborg','12.2259016036987','55.9179496765137');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(214,9,'DNK-FYN','Fyn','10.3176374435425','55.1720809936523');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(215,9,'DNK-KBN','Kobenhavn','12.3953747749329','55.7083377838135');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(216,9,'DNK-NRD','Nordjylland','10.1070823669434','57.1392383575439');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(217,9,'DNK-RIB','Ribe','8.68682289123535','55.533935546875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(218,9,'DNK-RNG','Ringkobing','8.75794315338135','56.221923828125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(219,9,'DNK-RSK','Roskilde','12.066948890686','55.5320854187012');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(220,9,'DNK-SKB','Staden Kobenhavn','12.545196056366','55.6673698425293');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(221,9,'DNK-SND','Sonderjylland','9.26499938964844','55.1175098419189');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(222,9,'DNK-STR','Storstrom','11.7736949920654','54.9823570251465');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(223,9,'DNK-VBR','Viborg','9.06804513931274','56.6578197479248');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(224,9,'DNK-VEJ','Vejle','9.55886554718018','55.7071399688721');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(225,9,'DNK-VST','Vestsjalland','11.4612445831299','55.590274810791');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(226,10,'FIN-AHR','Ahvenanmaa','20.181526184082','60.1902770996094');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(227,10,'FIN-HAM','Hame','24.6531925201416','61.4759674072266');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(228,10,'FIN-KSU','Keski-Suomi','25.3587989807129','62.5261154174805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(229,10,'FIN-KUO','Kuopio','27.5708312988281','63.1504135131836');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(230,10,'FIN-KYM','Kymi','28.0923366546631','61.1406936645508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(231,10,'FIN-LAP','Lappi','25.3047695159912','67.8403778076172');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(232,10,'FIN-MKK','Mikkeli','27.5663928985596','61.8569374084473');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(233,10,'FIN-OUL','Oulu','27.1630516052246','64.9491653442383');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(234,10,'FIN-PKR','Pohjois-Karjala','29.9711303710938','62.7955513000488');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(235,10,'FIN-TJP','Turku Ja Pori','22.4998588562012','61.15673828125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(236,10,'FIN-UUS','Uusimaa','24.6741542816162','60.3665237426758');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(237,10,'FIN-VAA','Vaasa','23.0434703826904','63.0523643493652');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(238,11,'FRA-ALS','Alsace','7.54581642150879','48.2374954223633');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(239,11,'FRA-AQT','Aquitaine','-0.1611328125','44.244441986084');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(240,11,'FRA-AVR','Auvergne','3.2686619758606','45.7109680175781');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(241,11,'FRA-BNR','Basse-Normandie','-0.479722321033478','48.9530487060547');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(242,11,'FRA-BOR','Bourgogne','4.19430541992188','47.2912673950195');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(243,11,'FRA-BRT','Bretagne','-3.0841668844223','48.0791625976563');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(244,11,'FRA-CEN','Centre','1.59263876080513','47.645133972168');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(245,11,'FRA-CHA','Champagne-Ardenne','4.6431941986084','48.8766632080078');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(246,11,'FRA-COR','Corse','9.06638813018799','42.1873588562012');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(247,11,'FRA-FRC','Franche-Comte','6.20097160339355','47.137077331543');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(248,11,'FRA-HNR','Haute-Normandie','0.917777709662914','49.3653869628906');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(249,11,'FRA-IDF','Ile-del-France','2.51111090183258','48.6754150390625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(250,11,'FRA-LIM','Limousin','1.61819434165955','45.6829109191895');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(251,11,'FRA-LNR','Languedoc-Roussillon','3.27166640758514','43.646800994873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(252,11,'FRA-LOR','Lorraine','6.27618312835693','48.7207183837891');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(253,11,'FRA-MPY','Midi-Pyrenees','1.56694427132607','43.8088684082031');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(254,11,'FRA-NPC','Nord-Pas-de-Calais','2.87624955177307','50.5297203063965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(255,11,'FRA-PAC','Provence-Alpes-Cote d''Azur','5.97523927688599','44.0888862609863');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(256,11,'FRA-PCH','Poitou-Charentes','-0.174444556236267','46.132625579834');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(257,11,'FRA-PDL','Pays de la Loire','-0.847361207008362','47.4174957275391');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(258,11,'FRA-PIC','Picardie','2.81343698501587','49.6080513000488');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(259,11,'FRA-RHA','Rhone-Alpes','5.42555499076843','45.3165245056152');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(260,12,'FRA-ALS-BRH','Bas-Rhin','7.60095548629761','48.5911560058594');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(261,12,'FRA-ALS-HRH','Haut-Rhin','7.24555492401123','47.8626346588135');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(262,12,'FRA-AQT-DRD','Dordogne','0.712517006322742','45.1477699279785');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(263,12,'FRA-AQT-GRN','Gironde','-0.477349013090134','44.8991603851318');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(264,12,'FRA-AQT-LEG','Lot-et-Garonne','0.474310018122196','44.3650703430176');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(265,12,'FRA-AQT-LND','Landes','-0.69115999341011','44.0033302307129');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(266,12,'FRA-AQT-PAT','Pyrenees-Atlanti','-0.878756497055292','43.1865234375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(267,12,'FRA-AVR-ALL','Allier','3.12791657447815','46.3779106140137');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(268,12,'FRA-AVR-CNT','Cantal','2.70991194248199','45.0502643585205');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(269,12,'FRA-AVR-HLO','Haute-Loire','3.78069400787354','45.0859699249268');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(270,12,'FRA-AVR-PDD','Puy-de-Dome','3.18416595458984','45.7647151947021');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(271,12,'FRA-BNR-CLV','Calvados','-0.36999998986721','49.0942001342773');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(272,12,'FRA-BNR-MNC','Manche','-1.34958353638649','49.0927696228027');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(273,12,'FRA-BNR-ORN','Orne','0.0619840025901794','48.5718002319336');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(274,12,'FRA-BOR-CDO','Cote-d''Or','4.79583358764648','47.4729099273682');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(275,12,'FRA-BOR-NIE','Nievre','3.5352098941803','47.1163845062256');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(276,12,'FRA-BOR-SEL','Saone-et-Loire','4.5472594499588','46.6634654998779');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(277,12,'FRA-BOR-YON','Yonne','3.58402752876282','47.8620986938477');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(278,12,'FRA-BRT-CDN','Cotes-du-Nord','-2.80472248792648','48.4530487060547');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(279,12,'FRA-BRT-FNS','Finistere','-4.27652859687805','48.2609691619873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(280,12,'FRA-BRT-IEV','Ille-et-Vilaine','-1.66250002384186','48.1794052124023');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(281,12,'FRA-BRT-MRB','Morbihan','-2.90166699886322','47.7409648895264');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(282,12,'FRA-CEN-CHE','Cher','2.4186110496521','47.0217990875244');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(283,12,'FRA-CEN-EEL','Eure-et-Loir','1.38777795433998','48.4473609924316');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(284,12,'FRA-CEN-IEL','Indre-et-Loire','0.706805486232042','47.2269401550293');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(285,12,'FRA-CEN-IND','Indre','1.53319454193115','46.8097190856934');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(286,12,'FRA-CEN-LEC','Loir-et-Cher','1.42138853669167','47.6574954986572');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(287,12,'FRA-CEN-LOR','Loiret','2.30781948566437','47.9111099243164');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(288,12,'FRA-CHA-ARN','Ardennes','4.71556091308594','49.7002754211426');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(289,12,'FRA-CHA-AUB','Aube','4.1254163980484','48.319019317627');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(290,12,'FRA-CHA-HMA','Haute-Marne','5.27333354949951','48.138744354248');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(291,12,'FRA-CHA-MAR','Marne','4.21597194671631','48.9658050537109');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(292,12,'FRA-COR-CDS','Corse-du-Sud','8.97499942779541','41.8754005432129');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(293,12,'FRA-COR-HCO','Haute-Corse','9.07898426055908','42.42458152771');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(294,12,'FRA-FRC-DOU','Doubs','6.38791608810425','47.0687408447266');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(295,12,'FRA-FRC-HSA','Haute-Saone','6.10941529273987','47.6294403076172');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(296,12,'FRA-FRC-JUR','Jura','5.72819399833679','46.7735710144043');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(297,12,'FRA-FRC-TDB','Territoire de Be','6.96583318710327','47.6569404602051');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(298,12,'FRA-HNR-EUR','Eure','1.04067599773407','49.0765190124512');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(299,12,'FRA-HNR-SMR','Seine-Maritime','0.925277519971132','49.6788597106934');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(300,12,'FRA-IDF-ESS','Essonne','2.24041652679443','48.5266609191895');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(301,12,'FRA-IDF-HDS','Hauts-de-Seine','2.22346389293671','48.8408203125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(302,12,'FRA-IDF-SEM','Seine-et-Marne','2.96864902973175','48.6123600006104');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(303,12,'FRA-IDF-SSD','Seine-Saint-Deni','2.43248105049133','48.9080543518066');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(304,12,'FRA-IDF-VDM','Valle-de-Marne','2.45430552959442','48.7729091644287');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(305,12,'FRA-IDF-VDO','Val-d''Oise','2.10486096143723','49.0743103027344');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(306,12,'FRA-IDF-VDP','Ville de Paris','2.32277858257294','48.851900100708');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(307,12,'FRA-IDF-YVL','Yvelines','1.8240305185318','48.7619400024414');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(308,12,'FRA-LIM-CRE','Creuse','1.98444443941116','46.0605506896973');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(309,12,'FRA-LIM-CRR','Correze','1.88097196817398','45.3438854217529');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(310,12,'FRA-LIM-HVI','Haute-Vienne','1.26805549860001','45.9224891662598');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(311,12,'FRA-LNR-AUD','Aude','2.46709245443344','43.0440254211426');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(312,12,'FRA-LNR-GAR','Gard','4.06458294391632','43.9573554992676');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(313,12,'FRA-LNR-HRL','Herault','3.36222195625305','43.5964756011963');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(314,12,'FRA-LNR-LOZ','Lozere','3.48694455623627','44.5395793914795');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(315,12,'FRA-LNR-POR','Pyrenees-Orienta','2.45063298940659','42.6199951171875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(316,12,'FRA-LOR-MEM','Meurthe-et-Mosel','6.27820897102356','48.9499950408936');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(317,12,'FRA-LOR-MEU','Meuse','5.37861061096191','49.0164108276367');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(318,12,'FRA-LOR-MSL','Moselle','6.78548860549927','49.0175457000732');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(319,12,'FRA-LOR-VSG','Vosges','6.31083297729492','48.1711101531982');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(320,12,'FRA-MPY-ARI','Ariege','1.49972203373909','42.9424896240234');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(321,12,'FRA-MPY-AVY','Aveyron','2.6419620513916','44.3170757293701');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(322,12,'FRA-MPY-GER','Gers','0.464582994580269','43.6911106109619');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(323,12,'FRA-MPY-HGR','Haute-Garonne','1.24749952554703','43.3028507232666');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(324,12,'FRA-MPY-HPY','Hautes-Pyrenees','0.161944508552551','43.1376285552979');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(325,12,'FRA-MPY-LOT','Lot','1.60052552819252','44.6287498474121');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(326,12,'FRA-MPY-TAR','Tarn','2.23679149150848','43.7890243530273');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(327,12,'FRA-MPY-TEG','Tarn-et-Garonne','1.35444849729538','44.0716552734375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(328,12,'FRA-NPC-NOR','Nord','3.15381145477295','50.5297203063965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(329,12,'FRA-NPC-PDC','Pas-de-Calais','2.35972207784653','50.5126037597656');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(330,12,'FRA-PAC-ADH','Alpes-de-Haute-P','6.23444366455078','44.1640453338623');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(331,12,'FRA-PAC-AMR','Alpes-Maritimes','7.17438340187073','43.955394744873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(332,12,'FRA-PAC-BDR','Bouches-du-Rhone','5.02891063690186','43.5554161071777');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(333,12,'FRA-PAC-HAL','Hautes-Alpes','6.24625015258789','44.6605548858643');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(334,12,'FRA-PAC-VAR','Var','6.31931591033936','43.4012432098389');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(335,12,'FRA-PAC-VCL','Vaucluse','5.2092809677124','44.0473556518555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(336,12,'FRA-PCH-CHR','Charente','0.227221995592117','45.6648006439209');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(337,12,'FRA-PCH-CMR','Charente-Maritim','-0.773184500867501','45.7334651947021');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(338,12,'FRA-PCH-DSV','Deux-Sevres','-0.368333511054516','46.5358200073242');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(339,12,'FRA-PCH-VIE','Vienne','0.542917005717754','46.6055450439453');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(340,12,'FRA-PDL-LAT','Loire-Atlantique','-1.74888902902603','47.3449954986572');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(341,12,'FRA-PDL-MEL','Maine-et-Loire','-0.558042004704475','47.3980503082275');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(342,12,'FRA-PDL-MYN','Mayenne','-0.64625003002584','48.1508293151855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(343,12,'FRA-PDL-SRT','Sarthe','0.237360998988152','48.024845123291');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(344,12,'FRA-PDL-VEN','Vendee','-1.46819448471069','46.6779098510742');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(345,12,'FRA-PIC-AIS','Aisne','3.60347211360931','49.4541606903076');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(346,12,'FRA-PIC-OIS','Oise','2.40319454669952','49.4149951934814');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(347,12,'FRA-PIC-SOM','Somme','2.28440946340561','49.97194480896');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(348,12,'FRA-RHA-AIN','Ain','5.45263838768005','46.0631904602051');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(349,12,'FRA-RHA-ARD','Ardeche','4.37905395030975','44.8213844299316');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(350,12,'FRA-RHA-DRO','Drome','5.24666547775269','44.7319450378418');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(351,12,'FRA-RHA-HSV','Haute-Savoie','6.42555499076843','46.0522193908691');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(352,12,'FRA-RHA-ISE','Isere','5.5631308555603','45.2891654968262');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(353,12,'FRA-RHA-LOI','Loire','4.22190308570862','45.7509708404541');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(354,12,'FRA-RHA-RHO','Rhone','4.67291665077209','45.8668155670166');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(355,12,'FRA-RHA-SAV','Savoie','6.40804934501648','45.4891662597656');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(356,13,'DEU-BER','Berlin','13.4226341247559','52.4895858764648');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(357,13,'DEU-BRM','Bremen','8.74049282073975','53.3208274841309');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(358,13,'DEU-BRN','Brandenburg','13.1682844161987','52.3808498382568');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(359,13,'DEU-BWR','Baden-Wurttemberg','8.99152708053589','48.6616230010986');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(360,13,'DEU-BYR','Bayern','11.4036102294922','48.9163856506348');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(361,13,'DEU-HMB','Hamburg','10.0337324142456','53.5658264160156');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(362,13,'DEU-HSS','Hessen','8.98283863067627','50.521556854248');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(363,13,'DEU-MKV','Mecklenburg-Vorpommern','12.5071859359741','53.8599052429199');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(364,13,'DEU-NDR','Niedersachsen','9.12032222747803','52.6277732849121');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(365,13,'DEU-NWS','Nordrhein-Westfalen','7.66013813018799','51.4246406555176');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(366,13,'DEU-RPF','Rheinland-Pfalz','7.30694389343262','49.9495658874512');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(367,13,'DEU-SCA','Sachsen-Anhalt','11.849428653717','51.9843006134033');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(368,13,'DEU-SCH','Sachsen','13.4676384925842','50.9324989318848');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(369,13,'DEU-SHL','Schleswig-Holstein','9.79666519165039','54.209300994873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(370,13,'DEU-SRL','Saarland','6.87365961074829','49.3711051940918');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(371,13,'DEU-THR','Thuringen','11.2386860847473','50.9209136962891');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(372,14,'DEU001001','Freiburg','DEU001','8.36378073692322','48.1328904813528');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(373,14,'DEU001002','Karlsruhe','DEU001','8.77510216757773','48.9831924438477');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(374,14,'DEU001003','Stuttgart','DEU001','9.61362552642822','49.1445217132568');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(375,14,'DEU001004','Tuebingen','DEU001','9.44029331207275','48.0925636291504');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(376,14,'DEU002001','Mittelfranken','DEU002','10.8272643089294','49.324333190918');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(377,14,'DEU002002','Niederbayern','DEU002','12.7175302505493','48.690242767334');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(378,14,'DEU002003','Oberbayern','DEU002','11.9083333015442','48.2487945556641');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(379,14,'DEU002004','Oberfranken','DEU002','11.3549160957336','50.0571060180664');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(380,14,'DEU002005','Oberpfalz','DEU002','12.1662921905518','49.4147815704346');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(381,14,'DEU002006','Schwaben','DEU002','10.4300546646118','48.1575565338135');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(382,14,'DEU002007','Unterfranken','DEU002','9.91844701766968','50.0248413085938');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(383,14,'DEU003XXX','Area without administration at 2nd level','DEU003','13.4094104766846','52.5102367401123');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(384,14,'DEU004XXX','Area without administration at 2nd level','DEU004','13.4094104766846','52.5102367401123');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(385,14,'DEU005XXX','Area without administration at 2nd level','DEU005','8.73865604400635','53.3011360168457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(386,14,'DEU006XXX','Area without administration at 2nd level','DEU006','10.011751312271','53.5618228912354');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(387,14,'DEU007001','Darmstadt','DEU007','8.75333571434021','49.949878692627');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(388,14,'DEU007002','Giessen','DEU007','8.80293107032776','50.6277351379395');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(389,14,'DEU007003','Kassel','DEU007','9.35069131851196','51.0041923522949');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(390,14,'DEU008XXX','Area without administration at 2nd level','DEU008','12.5024876594543','53.8581523895264');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(391,14,'DEU009XXX','Area without administration at 2nd level','DEU009','9.12597060203552','52.6308746337891');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(392,14,'DEU010001','Arnsberg','DEU010','8.02438831329346','51.211669921875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(393,14,'DEU010002','Detmold','DEU010','8.75986814498901','51.9852294921875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(394,14,'DEU010003','Duesseldorf','DEU010','6.63076829910278','51.4552192687988');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(395,14,'DEU010004','Koeln','DEU010','6.82462286949158','50.7840442657471');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(396,14,'DEU010005','Muenster','DEU010','7.35251188278198','51.9682102203369');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(397,14,'DEU011XXX','Area without administration at 2nd level','DEU011','7.30684447288513','49.9544086456299');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(398,14,'DEU012XXX','Area without administration at 2nd level','DEU012','6.88109421730042','49.3764705657959');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(399,14,'DEU013001','Chemnitz','DEU013','12.7529711723328','50.660961151123');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(400,14,'DEU013002','Dresden','DEU013','14.0967674255371','51.1578273773193');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(401,14,'DEU013003','Leipzig','DEU013','12.6768560409546','51.3052425384521');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(402,14,'DEU014XXX','Area without administration at 2nd level','DEU014','11.8712697029114','51.9969711303711');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(403,14,'DEU015XXX','Area without administration at 2nd level','DEU015','9.59366941452026','54.2105083465576');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,centroid_x,centroid_y) values(404,14,'DEU016XXX','Area without administration at 2nd level','DEU016','11.2654895782471','50.9382419586182');

insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(405,15,'GRC-AIS','Aegean Islands','26.2536067962646','37.6886024475098');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(406,15,'GRC-CGE','Central Greece and Evvoia','22.707914352417','37.5655517578125');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(407,15,'GRC-CRT','Crete','24.9105529785156','35.2483291625977');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(408,15,'GRC-IIS','Ionian Islands','20.1873588562012','38.7587471008301');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(409,15,'GRC-IPR','Ipiros','20.755859375','39.631742477417');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(410,15,'GRC-MCD','Macedonia','22.7840270996094','40.7412452697754');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(411,15,'GRC-PLP','Peloponnisos','22.3158321380615','37.363468170166');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(412,15,'GRC-THR','Thraki','25.6134672164917','41.0730476379395');
insert into wwv_flow_flash_map_regions(id,file_id,gmi_admin,region_name,centroid_x,centroid_y) values(413,15,'GRC-THS','Thessalia','22.4572811126709','39.6201305389404');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(414,16,'HUN-BAZ','Borsod-Abauj-Zemplen','21.1155223846436','48.1208305358887');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(415,16,'HUN-BDP','Budapest','19.1334705352783','47.4763870239258');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(416,16,'HUN-BEK','Bekes','21.053747177124','46.730411529541');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(417,16,'HUN-BKS','Bacs-Kiskun','19.4698581695557','46.5255546569824');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(418,16,'HUN-BRN','Baranya','18.2441654205322','46.0736083984375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(419,16,'HUN-CSN','Csongrad','20.2258644104004','46.4622840881348');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(420,16,'HUN-FEJ','Fejer','18.4984798431396','47.1559677124023');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(421,16,'HUN-GSP','Gyor-Moson-Sopron','17.1844425201416','47.7188873291016');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(422,16,'HUN-HBI','Hajdu-Bihar','21.4687252044678','47.4387283325195');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(423,16,'HUN-HEV','Heves','20.17138671875','47.7849006652832');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(424,16,'HUN-KMR','Komarom-Esztergom','18.4124965667725','47.5756912231445');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(425,16,'HUN-NGR','Nograd','19.5221424102783','47.9787483215332');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(426,16,'HUN-PES','Pest','19.4143028259277','47.4993438720703');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(427,16,'HUN-SMG','Somogy','17.5428447723389','46.4164276123047');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(428,16,'HUN-SSZ','Szabolcs-Szatmar-Bereg','21.9885129928589','47.9983558654785');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(429,16,'HUN-SZL','Jasz-Nagykun-Szolnok','20.3323593139648','47.2119407653809');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(430,16,'HUN-TOL','Tolna','18.533748626709','46.4782066345215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(431,16,'HUN-VAS','Vas','16.6674289703369','47.0885200500488');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(432,16,'HUN-VSZ','Veszprem','17.6586093902588','47.1252746582031');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(433,16,'HUN-ZAL','Zala','16.9059963226318','46.67041015625');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(434,17,'ISL-AST','Austurland','-15.397762298584','64.9794845581055');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(435,17,'ISL-NVS','Nordhurland Vestra','-19.7200546264648','65.4024505615234');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(436,17,'ISL-NYS','Nordhurland Eystra','-16.9008355140686','65.4941215515137');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(437,17,'ISL-RYK','Reykjavik','-21.9304161071777','64.0945510864258');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(438,17,'ISL-SDH','Sudhurland','-19.4501504898071','64.1029243469238');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(439,17,'ISL-VSL','Vesturland','-21.9688758850098','64.8931694030762');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(440,17,'ISL-VST','Vestfirdhir','-22.7868576049805','65.6959457397461');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(441,18,'IRL-CNN','Connacht','-8.92111158370972','53.7191619873047');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(442,18,'IRL-LEN','Leinster','-7.0430269241333','53.1393051147461');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(443,18,'IRL-MUN','Munster','-8.72264003753662','52.3064804077148');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(444,18,'IRL-ULT','Ulster','-7.67513990402222','54.5744400024414');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(445,19,'ITA-ABR','Abruzzi','13.887638092041','42.2920799255371');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(446,19,'ITA-BSL','Basilicata','16.1088418960571','40.5204544067383');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(447,19,'ITA-CLB','Calabria','16.3979158401489','39.0262451171875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(448,19,'ITA-CMP','Campania','14.7642436027527','40.7437438964844');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(449,19,'ITA-ERM','Emilia-Romagna','10.9765090942383','44.4453163146973');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(450,19,'ITA-FVG','Friuli-Venezia Giulia','13.1272220611572','46.1177749633789');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(451,19,'ITA-LAZ','Lazio','12.7319078445435','41.8662986755371');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(452,19,'ITA-LIG','Liguria','8.77472114562988','44.2322158813477');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(453,19,'ITA-LMB','Lombardia','9.95972156524658','45.6574974060059');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(454,19,'ITA-MOL','Molise','14.5437536239624','41.7219734191895');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(455,19,'ITA-MRC','Marche','13.0031929016113','43.3291931152344');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(456,19,'ITA-PMN','Piemonte','7.91404581069946','45.2773208618164');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(457,19,'ITA-PUG','Puglia','16.7231941223145','40.8695793151855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(458,19,'ITA-SIC','Sicilia','13.7877769470215','37.730411529541');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(459,19,'ITA-SRD','Sardegna','8.98458194732666','40.0658264160156');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(460,19,'ITA-TAA','Trentino-Alto Adige','11.466835975647','46.3877754211426');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(461,19,'ITA-TSC','Toscana','11.0267467498779','43.4001312255859');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(462,19,'ITA-UMB','Umbria','12.5730257034302','42.9911041259766');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(463,19,'ITA-VDA','Valle d''Aosta','7.35948467254639','45.7292633056641');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(464,19,'ITA-VEN','Veneto','11.8638877868652','45.736873626709');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(465,20,'ITA-ABR-CHT','Chieti','14.4186100959778','42.1028099060059');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(466,20,'ITA-ABR-LAQ','L''Aquila','13.6205902099609','42.1361045837402');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(467,20,'ITA-ABR-PSC','Pescara','14.0048503875732','42.3109683990479');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(468,20,'ITA-ABR-TRM','Teramo','13.744354724884','42.6614646911621');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(469,20,'ITA-BSL-MTR','Matera','16.4580097198486','40.4483699798584');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(470,20,'ITA-BSL-PTN','Potenza','15.8718252182007','40.516845703125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(471,20,'ITA-CLB-CSN','Cosenza','16.3843350410461','39.5937442779541');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(472,20,'ITA-CLB-CTN','Catanzaro','16.5163898468018','38.9531898498535');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(473,20,'ITA-CLB-RCL','Reggio di Calabr','16.1009702682495','38.2486095428467');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(474,20,'ITA-CMP-AVL','Avellino','15.0677552223206','40.9977741241455');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(475,20,'ITA-CMP-BNV','Benevento','14.746919631958','41.2448596954346');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(476,20,'ITA-CMP-CSR','Caserta','14.1382150650024','41.2183246612549');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(477,20,'ITA-CMP-NPL','Napoli','14.2637453079224','40.7734298706055');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(478,20,'ITA-CMP-SLR','Salerno','15.116030216217','40.4143199920654');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(479,20,'ITA-ERM-BLG','Bologna','11.3070850372314','44.4325008392334');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(480,20,'ITA-ERM-FER','Ferrara','11.816385269165','44.7659511566162');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(481,20,'ITA-ERM-FRL','Forli','12.2016448974609','44.0408363342285');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(482,20,'ITA-ERM-MDN','Modena','10.9133148193359','44.5406837463379');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(483,20,'ITA-ERM-PCZ','Piacenza','9.63183689117432','44.8463497161865');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(484,20,'ITA-ERM-PRM','Parma','9.96862030029297','44.6930503845215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(485,20,'ITA-ERM-RGE','Reggio nell'' Emi','10.5052452087402','44.6083660125732');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(486,20,'ITA-ERM-RVN','Ravenna','11.9486103057861','44.3697643280029');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(487,20,'ITA-FVG-GRZ','Gorizia','13.5066699981689','45.864444732666');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(488,20,'ITA-FVG-PRD','Pordenone','12.6629152297974','46.0981903076172');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(489,20,'ITA-FVG-TRS','Trieste','13.7493200302124','45.6965255737305');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(490,20,'ITA-FVG-UDN','Udine','13.108115196228','46.1513862609863');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(491,20,'ITA-LAZ-FRS','Frosinone','13.4994449615479','41.6277694702148');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(492,20,'ITA-LAZ-LTN','Latina','13.2063903808594','41.2955551147461');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(493,20,'ITA-LAZ-RIT','Rieti','12.9204149246216','42.4218044281006');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(494,20,'ITA-LAZ-ROM','Roma','12.5084447860718','41.8509101867676');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(495,20,'ITA-LAZ-VTR','Viterbo','11.9792647361755','42.4968547821045');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(496,20,'ITA-LIG-GNV','Genova','9.06297159194946','44.447940826416');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(497,20,'ITA-LIG-IMP','Imperia','7.8109974861145','43.961799621582');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(498,20,'ITA-LIG-LSP','La Spezia','9.75527954101563','44.2337398529053');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(499,20,'ITA-LIG-SVN','Savona','8.31805491447449','44.2372646331787');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(500,20,'ITA-LMB-BRG','Bergamo','9.83400249481201','45.7651309967041');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(501,20,'ITA-LMB-BRS','Brescia','10.327919960022','45.7749500274658');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(502,20,'ITA-LMB-COM','Como','9.21666622161865','45.9358501434326');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(503,20,'ITA-LMB-CRM','Cremona','10.0268135070801','45.2144603729248');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(504,20,'ITA-LMB-MLN','Milano','9.30235862731934','45.3943004608154');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(505,20,'ITA-LMB-MNT','Mantova','10.8696146011353','45.1672191619873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(506,20,'ITA-LMB-PAV','Pavia','9.02345657348633','45.0415096282959');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(507,20,'ITA-LMB-SND','Sondrio','9.94197988510132','46.3236103057861');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(508,20,'ITA-LMB-VRS','Varese','8.81569337844849','45.8375453948975');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(509,20,'ITA-MOL-CPB','Campobasso','14.7658748626709','41.7222499847412');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(510,20,'ITA-MOL-ISR','Isernia','14.2266850471497','41.6492500305176');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(511,20,'ITA-MRC-ANC','Ancona','13.2037501335144','43.4812889099121');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(512,20,'ITA-MRC-ASP','Ascoli Picento','13.5483298301697','42.9940795898438');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(513,20,'ITA-MRC-MCR','Macerata','13.2843651771545','43.1369400024414');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(514,20,'ITA-MRC-PSU','Pesaro e Urbino','12.6366500854492','43.6979999542236');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(515,20,'ITA-PMN-ALS','Alessandria','8.65333223342896','44.8394412994385');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(516,20,'ITA-PMN-AST','Asti','8.18402743339539','44.8311195373535');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(517,20,'ITA-PMN-CUN','Cuneo','7.55458235740662','44.4739894866943');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(518,20,'ITA-PMN-NVR','Novara','8.34385514259338','45.8827743530273');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(519,20,'ITA-PMN-TOR','Torino','7.37821269035339','45.162260055542');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(520,20,'ITA-PMN-VRC','Vercelli','8.20416593551636','45.5536060333252');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(521,20,'ITA-PUG-BAR','Bari','16.6297602653503','41.0322494506836');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(522,20,'ITA-PUG-BRN','Brindisi','17.6912508010864','40.6386909484863');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(523,20,'ITA-PUG-FGG','Foggia','15.5669455528259','41.5918102264404');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(524,20,'ITA-PUG-LEC','Lecce','18.138334274292','40.1615238189697');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(525,20,'ITA-PUG-TRN','Taranto','17.2521743774414','40.5499954223633');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(526,20,'ITA-SIC-AGR','Agrigento','13.4660201072693','37.4183235168457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(527,20,'ITA-SIC-CLT','Caltanissetta','14.0663900375366','37.3624801635742');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(528,20,'ITA-SIC-CTN','Catania','14.8119697570801','37.5008296966553');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(529,20,'ITA-SIC-ENN','Enna','14.4440250396729','37.5916652679443');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(530,20,'ITA-SIC-MSS','Messina','14.9203147888184','38.305965423584');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(531,20,'ITA-SIC-PLR','Palermo','13.6134700775146','38.1319408416748');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(532,20,'ITA-SIC-RGS','Ragusa','14.6791501045227','36.9138851165771');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(533,20,'ITA-SIC-SRC','Siracusa','15.0605497360229','37.0300006866455');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(534,20,'ITA-SIC-TRP','Trapani','12.5115299224854','37.4619445800781');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(535,20,'ITA-SRD-CGL','Cagliari','8.93708229064941','39.313606262207');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(536,20,'ITA-SRD-NUR','Nuoro','9.10166549682617','40.2367992401123');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(537,20,'ITA-SRD-ORS','Oristano','8.71944332122803','39.9528007507324');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(538,20,'ITA-SRD-SAS','Sardegna','8.89888381958008','40.8077735900879');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(539,20,'ITA-TAA-BLZ','Bolzano','11.4355850219727','46.6562442779541');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(540,20,'ITA-TAA-TRE','Trento','11.2152752876282','46.1020793914795');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(541,20,'ITA-TSC-ARZ','Arezzo','11.8843050003052','43.526195526123');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(542,20,'ITA-TSC-FRN','Firenze','11.2286100387573','43.8460006713867');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(543,20,'ITA-TSC-GRO','Grosseto','11.2647199630737','42.7099952697754');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(544,20,'ITA-TSC-LUC','Lucca','10.4408149719238','44.0161056518555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(545,20,'ITA-TSC-LVR','Livorno','10.2874984741211','42.9751358032227');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(546,20,'ITA-TSC-MSC','Massa-Carrara','9.96743488311768','44.223819732666');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(547,20,'ITA-TSC-PIS','Pisa','10.632740020752','43.4766941070557');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(548,20,'ITA-TSC-PST','Pistoia','10.8329849243164','43.9813842773438');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(549,20,'ITA-TSC-SIE','Siena','11.4423952102661','43.1691646575928');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(550,20,'ITA-UMB-PRG','Perugia','12.5879149436951','43.1122741699219');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(551,20,'ITA-UMB-TER','Terni','12.3953499794006','42.6529159545898');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(552,20,'ITA-VDA-AOS','Aosta','7.35948467254639','45.733980178833');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(553,20,'ITA-VEN-BLN','Belluno','12.2220802307129','46.2842388153076');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(554,20,'ITA-VEN-PDV','Padova','11.797914981842','45.3984661102295');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(555,20,'ITA-VEN-RVG','Rovigo','11.864444732666','44.9772663116455');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(556,20,'ITA-VEN-TRV','Treviso','12.2208352088928','45.8118057250977');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(557,20,'ITA-VEN-VCN','Vicenza','11.4819898605347','45.6376342773438');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(558,20,'ITA-VEN-VNZ','Venezia','12.5347199440002','45.4595756530762');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(559,20,'ITA-VEN-VRN','Verona','11.064169883728','45.4414749145508');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(560,21,'NLD-DRN','Drenthe','6.61029624938965','52.9149971008301');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(561,21,'NLD-FLV','Flevoland','5.55745935440063','52.5527725219727');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(562,21,'NLD-FRS','Friesland','5.65902709960938','53.1578712463379');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(563,21,'NLD-GLD','Gelderland','5.92046546936035','52.1282348632813');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(564,21,'NLD-GRN','Groningen','6.68861055374146','53.1513671875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(565,21,'NLD-LMB','Limburg','5.89555549621582','51.2662467956543');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(566,21,'NLD-NBR','Noord-Brabant','5.11747455596924','51.5253524780273');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(567,21,'NLD-NHL','Noord-Holland','4.99030256271362','52.6820793151855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(568,21,'NLD-OVR','Overijssel','6.42745685577393','52.4839210510254');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(569,21,'NLD-UTR','Utrecht','5.19444417953491','52.1103515625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(570,21,'NLD-ZHL','Zuid-Holland','4.52374625205994','51.9887466430664');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(571,21,'NLD-ZLN','Zeeland','3.82526969909668','51.4759712219238');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(572,22,'NOR-AAG','Aust-Agder','8.0781044960022','58.8942451477051');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(573,22,'NOR-AKR','Akershus','11.116229057312','60.0306930541992');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(574,22,'NOR-BSK','Buskerud','9.0381932258606','60.2543029785156');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(575,22,'NOR-FNN','Finnmark','26.1616344451904','69.8677597045898');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(576,22,'NOR-HDM','Hedmark','11.2297210693359','61.264575958252');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(577,22,'NOR-HRD','Hordaland','6.27097129821777','60.2474975585938');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(578,22,'NOR-MOR','More Og Romsdal','7.43597173690796','62.713191986084');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(579,22,'NOR-NRD','Nordland','14.9569435119629','67.1301345825195');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(580,22,'NOR-NTR','Nord-Trondelag','12.2237215042114','64.1565208435059');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(581,22,'NOR-OPP','Oppland','9.23979473114014','61.2583923339844');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(582,22,'NOR-OSL','Oslo','10.7055540084839','59.9773445129395');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(583,22,'NOR-OST','Ostfold','11.2780542373657','59.3292999267578');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(584,22,'NOR-RGL','Rogaland','6.14904594421387','59.0501098632813');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(585,22,'NOR-SOF','Sogn Og Fjordane','6.46374940872192','61.4405517578125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(586,22,'NOR-STR','Sor-Trondelag','10.2576713562012','63.3384323120117');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(587,22,'NOR-TLM','Telemark','8.47875118255615','59.469482421875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(588,22,'NOR-TRM','Troms','19.2322196960449','69.3122100830078');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(589,22,'NOR-VAG','Vest-Agder','7.25518178939819','58.5805244445801');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(590,22,'NOR-VST','Vestfold','10.125693321228','59.318603515625');
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(591,23,'NOR001001','Aas','NOR001','Akershus','10.7708333333333','59.6787506103516');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(592,23,'NOR001002','Asker','NOR001','Akershus','10.437920665741','59.8414505004883');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(593,23,'NOR001003','Aurskog-Hoeland','NOR001','Akershus','11.5965564092','59.8103373209636');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(594,23,'NOR001004','Baerum','NOR001','Akershus','10.4907023111979','59.9466211954753');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(595,23,'NOR001005','Eidsvoll','NOR001','Akershus','11.2291666666667','60.4083333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(596,23,'NOR001006','Enebakk','NOR001','Akershus','11.0708333333333','59.7625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(597,23,'NOR001007','Fet','NOR001','Akershus','11.2023307800293','59.8666666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(598,23,'NOR001008','Frogn','NOR001','Akershus','10.6523385047913','59.6990489959717');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(599,23,'NOR001009','Gjerdrum','NOR001','Akershus','10.9957392374674','60.080930074056');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(600,23,'NOR001010','Hurdal','NOR001','Akershus','10.8938041687012','60.4208333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(601,23,'NOR001011','Loerenskog','NOR001','Akershus','10.9556488037109','59.8934977213542');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(602,23,'NOR001012','Nannestad','NOR001','Akershus','10.9350336710612','60.2281616210938');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(603,23,'NOR001013','Nes','NOR001','Akershus','11.5316360473633','60.1708333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(604,23,'NOR001014','Nesodden','NOR001','Akershus','10.6544842720032','59.7970022837321');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(605,23,'NOR001015','Nittedal','NOR001','Akershus','10.8190478006999','60.074343363444');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(606,23,'NOR001016','Oppegaard','NOR001','Akershus','10.7858935991923','59.794038772583');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(607,23,'NOR001017','Raelingen','NOR001','Akershus','11.0802917480469','59.8770431518555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(608,23,'NOR001018','Skedsmo','NOR001','Akershus','11.0416666666667','59.9833333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(609,23,'NOR001019','Ski','NOR001','Akershus','10.8811642964681','59.725');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(610,23,'NOR001020','Soerum','NOR001','Akershus','11.2375','59.9834157307943');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(611,23,'NOR001021','Ullensaker','NOR001','Akershus','11.1752265930176','60.1555318196615');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(612,23,'NOR001022','Vestby','NOR001','Akershus','10.7530634880066','59.5578440348307');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(613,23,'NOR002001','Aamli','NOR002','Aust-Agder','8.35644276936849','58.7995727539063');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(614,23,'NOR002002','Arendal','NOR002','Aust-Agder','8.74484484990438','58.4953227996826');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(615,23,'NOR002003','Birkenes','NOR002','Aust-Agder','8.17734680175781','58.4375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(616,23,'NOR002004','Bygland','NOR002','Aust-Agder','7.52263259887695','58.8681874593099');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(617,23,'NOR002005','Bykle','NOR002','Aust-Agder','7.21741154988607','59.4291666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(618,23,'NOR002006','Evje og Hornnes','NOR002','Aust-Agder','7.75945332845052','58.5875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(619,23,'NOR002007','Froland','NOR002','Aust-Agder','8.34417470296224','58.5843556722005');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(620,23,'NOR002008','Gjerstad','NOR002','Aust-Agder','8.95463155110677','58.8728500366211');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(621,23,'NOR002009','Grimstad','NOR002','Aust-Agder','8.51734638214111','58.3690232594808');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(622,23,'NOR002010','Iveland','NOR002','Aust-Agder','7.9270133972168','58.439116414388');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(623,23,'NOR002011','Lillesand','NOR002','Aust-Agder','8.28797076543172','58.2215127309163');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(624,23,'NOR002012','Risoer','NOR002','Aust-Agder','9.16267935434977','58.7356515248617');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(625,23,'NOR002013','Tvedestrand','NOR002','Aust-Agder','8.94035835266113','58.6230717976888');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(626,23,'NOR002014','Valle','NOR002','Aust-Agder','7.4','59.1693379720052');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(627,23,'NOR002015','Vegaarshei','NOR002','Aust-Agder','8.81079813639323','58.7524271647136');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(628,23,'NOR003001','Aal','NOR003','Buskerud','8.29583333333333','60.694780476888');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(629,23,'NOR003002','Drammen','NOR003','Buskerud','10.1646599769592','59.7275151570638');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(630,23,'NOR003003','Flaa','NOR003','Buskerud','9.45751368204752','60.4291666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(631,23,'NOR003004','Flesberg','NOR003','Buskerud','9.43061701456705','59.8583333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(632,23,'NOR003005','Gol','NOR003','Buskerud','9.01343587239583','60.7507019042969');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(633,23,'NOR003006','Hemsedal','NOR003','Buskerud','8.4625','60.923893737793');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(634,23,'NOR003007','Hol','NOR003','Buskerud','8.03109512329101','60.6039515177409');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(635,23,'NOR003008','Hole','NOR003','Buskerud','10.275','60.0358800252279');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(636,23,'NOR003009','Hurum','NOR003','Buskerud','10.5226564407349','59.6015186309814');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(637,23,'NOR003010','Kongsberg','NOR003','Buskerud','9.67723821004232','59.5958333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(638,23,'NOR003011','Kroedsherad','NOR003','Buskerud','9.65818710327148','60.1916666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(639,23,'NOR003012','Lier','NOR003','Buskerud','10.2049969991048','59.8493621826172');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(640,23,'NOR003013','Modum','NOR003','Buskerud','9.98936182657877','60.0083333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(641,23,'NOR003014','Nedre Eiker','NOR003','Buskerud','10.0246388753255','59.75');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(642,23,'NOR003015','Nes','NOR003','Buskerud','9.04198379516601','60.5458333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(643,23,'NOR003016','Nore og Uvdal','NOR003','Buskerud','8.34166666666667','60.2890818277995');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(644,23,'NOR003017','Oevre Eiker','NOR003','Buskerud','9.83333333333333','59.744249979655');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(645,23,'NOR003018','Ringerike','NOR003','Buskerud','10.1333333333333','60.328136698405');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(646,23,'NOR003019','Roeyken','NOR003','Buskerud','10.4245116551717','59.7304719289144');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(647,23,'NOR003020','Rollag','NOR003','Buskerud','9.2','60.0166666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(648,23,'NOR003021','Sigdal','NOR003','Buskerud','9.48139139811198','60.1323094685873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(649,23,'NOR004001','Alta','NOR004','Finnmark','23.2068756103516','70.0587881088257');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(650,23,'NOR004002','Baatsfjord','NOR004','Finnmark','29.9883298238118','70.5189737955729');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(651,23,'NOR004003','Berlevaag','NOR004','Finnmark','29.1289615631104','70.6827944437663');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(652,23,'NOR004004','Deatnu-Tana','NOR004','Finnmark','27.4791666666667','70.2688369750977');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(653,23,'NOR004005','Gamvik','NOR004','Finnmark','27.961648050944','70.7706759134929');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(654,23,'NOR004006','Guovdageaidnu-Kautokeino','NOR004','Finnmark','23.6761194383639','69.1444072723389');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(655,23,'NOR004007','Hammerfest','NOR004','Finnmark','23.3905732150877','70.6588658909425');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(656,23,'NOR004008','Hasvik','NOR004','Finnmark','22.4086477279663','70.5303043365479');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(657,23,'NOR004009','Karasjohka-Karasjok','NOR004','Finnmark','25.2208771387736','69.3963396708171');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(658,23,'NOR004010','Kvalsund','NOR004','Finnmark','24.125','70.4038561503093');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(659,23,'NOR004011','Lebesby','NOR004','Finnmark','26.8377482096354','70.5581219257498');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(660,23,'NOR004012','Loppa','NOR004','Finnmark','21.8793979008992','70.2229637145996');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(661,23,'NOR004013','Maasoey','NOR004','Finnmark','24.6732754389445','70.8707427978516');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(662,23,'NOR004014','Nordkapp','NOR004','Finnmark','25.9619083404541','70.9273885091146');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(663,23,'NOR004015','Porsanger','NOR004','Finnmark','25.0351053873698','70.2546852111817');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(664,23,'NOR004016','Soer-Varanger','NOR004','Finnmark','29.6497354234819','69.5190238952637');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(665,23,'NOR004017','Unjarga-Nesseby','NOR004','Finnmark','28.8488580067952','70.1345681340654');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(666,23,'NOR004018','Vadsoe','NOR004','Finnmark','29.7340421040853','70.2715471903483');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(667,23,'NOR004019','Vardoe','NOR004','Finnmark','30.6232651392619','70.3376884460449');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(668,23,'NOR005001','Aamot','NOR005','Hedmark','11.4310948689779','61.2708333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(669,23,'NOR005002','Aasnes','NOR005','Hedmark','12.1253939946493','60.6774520874024');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(670,23,'NOR005003','Alvdal','NOR005','Hedmark','10.5157409667969','62.0969696044922');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(671,23,'NOR005004','Eidskog','NOR005','Hedmark','12.0676369444989','59.992631149292');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(672,23,'NOR005005','Elverum','NOR005','Hedmark','11.7125','60.9723444620768');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(673,23,'NOR005006','Engerdal','NOR005','Hedmark','11.9052786827087','61.9736368815104');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(674,23,'NOR005007','Folldal','NOR005','Hedmark','9.97115681966146','62.1583333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(675,23,'NOR005008','Grue','NOR005','Hedmark','12.1937019348145','60.4155666351318');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(676,23,'NOR005009','Hamar','NOR005','Hedmark','11.118329111735','60.9875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(677,23,'NOR005010','Kongsvinger','NOR005','Hedmark','12.1818281173706','60.1860505891828');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(678,23,'NOR005011','Loeten','NOR005','Hedmark','11.4198885599772','60.8666666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(679,23,'NOR005012','Nord-Odal','NOR005','Hedmark','11.5737970987956','60.4408554077149');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(680,23,'NOR005013','Os','NOR005','Hedmark','11.2583333333333','62.4198786417643');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(681,23,'NOR005014','Rendalen','NOR005','Hedmark','11.1291666666667','61.8134531656901');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(682,23,'NOR005015','Ringsaker','NOR005','Hedmark','10.7673149108887','60.9904312133789');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(683,23,'NOR005016','Soer-Odal','NOR005','Hedmark','11.7167536417643','60.2143152872721');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(684,23,'NOR005017','Stange','NOR005','Hedmark','11.3291666666667','60.626628112793');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(685,23,'NOR005018','Stor-Elvdal','NOR005','Hedmark','10.70365041097','61.5836420694987');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(686,23,'NOR005019','Tolga','NOR005','Hedmark','11.081404876709','62.3708333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(687,23,'NOR005020','Trysil','NOR005','Hedmark','12.2995203018188','61.3559833526611');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(688,23,'NOR005021','Tynset','NOR005','Hedmark','10.5916666666667','62.3541666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(689,23,'NOR005022','Vaaler','NOR005','Hedmark','11.9661195755005','60.8105717976888');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(690,23,'NOR006001','Askoey','NOR006','Hordaland','5.10082268714905','60.4868679046631');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(691,23,'NOR006002','Austevoll','NOR006','Hordaland','5.17062759399414','60.070333480835');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(692,23,'NOR006003','Austrheim','NOR006','Hordaland','4.93602525393168','60.7838668823242');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(693,23,'NOR006004','Bergen','NOR006','Hordaland','5.43319490750631','60.365966796875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(694,23,'NOR006005','Boemlo','NOR006','Hordaland','5.23362255096436','59.7448482513428');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(695,23,'NOR006006','Eidfjord','NOR006','Hordaland','7.26807180795485','60.3477615356445');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(696,23,'NOR006007','Etne','NOR006','Hordaland','6.14734686215719','59.7888666788737');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(697,23,'NOR006008','Fedje','NOR006','Hordaland','4.72356915473938','60.7669696807861');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(698,23,'NOR006009','Fitjar','NOR006','Hordaland','5.32126927375793','59.9006443023682');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(699,23,'NOR006010','Fjell','NOR006','Hordaland','5.05329346656799','60.3574752807617');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(700,23,'NOR006011','Fusa','NOR006','Hordaland','5.76223340034485','60.1949361165365');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(701,23,'NOR006012','Granvin','NOR006','Hordaland','6.65152130126953','60.5403852128788');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(702,23,'NOR006013','Jondal','NOR006','Hordaland','6.29934554100037','60.2743534088135');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(703,23,'NOR006014','Kvam','NOR006','Hordaland','6.18254521687825','60.3186330159505');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(704,23,'NOR006015','Kvinnherad','NOR006','Hordaland','6.04259978930155','59.956688563029');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(705,23,'NOR006016','Lindaas','NOR006','Hordaland','5.35517595609029','60.6962097167969');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(706,23,'NOR006017','Masfjorden','NOR006','Hordaland','5.49307750066121','60.847532526652');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(707,23,'NOR006018','Meland','NOR006','Hordaland','5.10958361625671','60.5596656799316');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(708,23,'NOR006019','Modalen','NOR006','Hordaland','5.92329813639323','60.88316599528');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(709,23,'NOR006020','Odda','NOR006','Hordaland','6.82916666666666','59.9541666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(710,23,'NOR006021','Oelen','NOR006','Hordaland','5.72087389628092','59.6073455810547');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(711,23,'NOR006022','Oeygarden','NOR006','Hordaland','4.84718418121338','60.5863609313965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(712,23,'NOR006023','Os','NOR006','Hordaland','5.46088600158691','60.2332102457682');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(713,23,'NOR006024','Osteroey','NOR006','Hordaland','5.53162431716919','60.5675582885742');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(714,23,'NOR006025','Radoey','NOR006','Hordaland','5.05151414871216','60.6535186767578');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(715,23,'NOR006026','Samnanger','NOR006','Hordaland','5.775','60.4090226491292');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(716,23,'NOR006027','Stord','NOR006','Hordaland','5.46806144714355','59.8366680145264');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(717,23,'NOR006028','Sund','NOR006','Hordaland','5.0846962928772','60.233190536499');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(718,23,'NOR006029','Sveio','NOR006','Hordaland','5.37771129608154','59.6112895965576');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(719,23,'NOR006030','Tysnes','NOR006','Hordaland','5.53244495391846','59.9835739135742');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(720,23,'NOR006031','Ullensvang','NOR006','Hordaland','6.9266065900963','60.2458333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(721,23,'NOR006032','Ulvik','NOR006','Hordaland','7.20833333333333','60.6072339375814');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(722,23,'NOR006033','Vaksdal','NOR006','Hordaland','5.94387334187825','60.6708333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(723,23,'NOR006034','Voss','NOR006','Hordaland','6.39621721903483','60.7205713907878');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(724,23,'NOR007001','Aalesund','NOR007','Moere og Romsdal','6.32080187661841','62.4715538024902');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(725,23,'NOR007002','Aukra','NOR007','Moere og Romsdal','6.90603919273522','62.8060092926025');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(726,23,'NOR007003','Aure','NOR007','Moere og Romsdal','8.56415141423543','63.2958335876465');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(727,23,'NOR007004','Averoey','NOR007','Moere og Romsdal','7.54470348358154','63.0315704345703');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(728,23,'NOR007005','Eide','NOR007','Moere og Romsdal','7.41329383850097','62.9334114074707');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(729,23,'NOR007006','Fraena','NOR007','Moere og Romsdal','7.11177970568339','62.8852369433017');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(730,23,'NOR007007','Frei','NOR007','Moere og Romsdal','7.80149149894714','63.066499710083');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(731,23,'NOR007008','Giske','NOR007','Moere og Romsdal','6.05889105796814','62.5274982452393');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(732,23,'NOR007009','Gjemnes','NOR007','Moere og Romsdal','7.7544823328654','62.9152000427246');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(733,23,'NOR007010','Halsa','NOR007','Moere og Romsdal','8.49029108683268','63.1094290979117');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(734,23,'NOR007011','Haram','NOR007','Moere og Romsdal','6.46184500058492','62.6184397860012');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(735,23,'NOR007012','Hareid','NOR007','Moere og Romsdal','6.00486028989156','62.3518123626709');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(736,23,'NOR007013','Heroey','NOR007','Moere og Romsdal','5.65877914428711','62.3145605410845');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(737,23,'NOR007014','Kristiansund','NOR007','Moere og Romsdal','7.78177905082703','63.1220016479492');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(738,23,'NOR007015','Midsund','NOR007','Moere og Romsdal','6.73524856567383','62.6957015991211');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(739,23,'NOR007016','Molde','NOR007','Moere og Romsdal','7.38941653569539','62.7596455891927');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(740,23,'NOR007017','Nesset','NOR007','Moere og Romsdal','8.17515233357747','62.5953742400871');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(741,23,'NOR007018','Norddal','NOR007','Moere og Romsdal','7.41273512840271','62.2412139892578');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(742,23,'NOR007019','Oerskog','NOR007','Moere og Romsdal','6.90778028170268','62.4851328531901');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(743,23,'NOR007020','Oersta','NOR007','Moere og Romsdal','6.38008885383606','62.2069380442301');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(744,23,'NOR007021','Rauma','NOR007','Moere og Romsdal','7.68949921492169','62.4441960931853');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(745,23,'NOR007022','Rindal','NOR007','Moere og Romsdal','9.26253763834635','63.0083333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(746,23,'NOR007023','Sande','NOR007','Moere og Romsdal','5.56864651442229','62.2049842749684');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(747,23,'NOR007024','Sandoey','NOR007','Moere og Romsdal','6.51723027229309','62.7756309509277');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(748,23,'NOR007025','Skodje','NOR007','Moere og Romsdal','6.62572483653719','62.4984747145588');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(749,23,'NOR007026','Smoela','NOR007','Moere og Romsdal','8.01312732696533','63.381420135498');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(750,23,'NOR007027','Stordal','NOR007','Moere og Romsdal','7.07497800191243','62.4030700683594');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(751,23,'NOR007028','Stranda','NOR007','Moere og Romsdal','7.00258305867513','62.1681625366211');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(752,23,'NOR007029','Sula','NOR007','Moere og Romsdal','6.21847343444824','62.4272727966309');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(753,23,'NOR007030','Sunndal','NOR007','Moere og Romsdal','8.70444920857747','62.6358519236247');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(754,23,'NOR007031','Surnadal','NOR007','Moere og Romsdal','8.78489065170288','62.9333333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(755,23,'NOR007032','Sykkylven','NOR007','Moere og Romsdal','6.63342428207397','62.3445891062419');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(756,23,'NOR007033','Tingvoll','NOR007','Moere og Romsdal','8.15210631688436','62.9570377349854');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(757,23,'NOR007034','Tustna','NOR007','Moere og Romsdal','8.09582591056824','63.2036647796631');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(758,23,'NOR007035','Ulstein','NOR007','Moere og Romsdal','5.8587127049764','62.3268099472699');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(759,23,'NOR007036','Vanylven','NOR007','Moere og Romsdal','5.63562436103821','62.08238474528');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(760,23,'NOR007037','Vestnes','NOR007','Moere og Romsdal','6.98047965327254','62.5578295389811');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(761,23,'NOR007038','Volda','NOR007','Moere og Romsdal','6.10833333333333','62.0932421366374');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(762,23,'NOR008001','Alstahaug','NOR008','Nordland','12.5597930590312','65.8780258178711');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(763,23,'NOR008002','Andoey','NOR008','Nordland','15.7984399795532','69.0476476033529');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(764,23,'NOR008003','Ballangen','NOR008','Nordland','16.6615867614746','68.2430555917894');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(765,23,'NOR008004','Beiarn','NOR008','Nordland','14.6591852823893','66.8935717264811');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(766,23,'NOR008005','Bindal','NOR008','Nordland','12.515847269694','65.1291666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(767,23,'NOR008006','Bodoe','NOR008','Nordland','14.5172094398112','67.3409123738607');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(768,23,'NOR008007','Boe','NOR008','Nordland','14.5691071192423','68.7183418273926');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(769,23,'NOR008008','Broennoey','NOR008','Nordland','12.5834748268127','65.4168601693743');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(770,23,'NOR008009','Doenna','NOR008','Nordland','12.5280742645264','66.1398887634277');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(771,23,'NOR008010','Evenes','NOR008','Nordland','16.9213231404622','68.5159074147542');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(772,23,'NOR008011','Fauske','NOR008','Nordland','15.7193813323975','67.2402455782623');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(773,23,'NOR008012','Flakstad','NOR008','Nordland','13.226836681366','68.0772196935528');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(774,23,'NOR008013','Gildeskaal','NOR008','Nordland','13.9996594746908','66.9875122070312');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(775,23,'NOR008014','Grane','NOR008','Nordland','13.4164794921875','65.4448176066081');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(776,23,'NOR008015','Hadsel','NOR008','Nordland','14.9814233462016','68.505978902181');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(777,23,'NOR008016','Hamaroey','NOR008','Nordland','15.9100410667409','67.8819580078125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(778,23,'NOR008017','Hattfjelldal','NOR008','Nordland','14.1242122650146','65.4993292659516');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(779,23,'NOR008018','Hemnes','NOR008','Nordland','13.970245118528','66.0072186787923');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(780,23,'NOR008019','Heroey','NOR008','Nordland','12.2107176780701','65.9935569763184');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(781,23,'NOR008020','Leirfjord','NOR008','Nordland','13.0736201436988','66.0954013894021');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(782,23,'NOR008021','Loedingen','NOR008','Nordland','15.6269592920939','68.4646246592204');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(783,23,'NOR008022','Luroey','NOR008','Nordland','12.7815466562907','66.442608767384');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(784,23,'NOR008023','Meloey','NOR008','Nordland','13.624082215627','66.7971939086914');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(785,23,'NOR008024','Moskenes','NOR008','Nordland','12.9835456386395','67.9381713867188');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(786,23,'NOR008025','Narvik','NOR008','Nordland','17.5991134643555','68.2969360351563');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(787,23,'NOR008026','Nesna','NOR008','Nordland','13.0076804161072','66.2341079711914');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(788,23,'NOR008027','Oeksnes','NOR008','Nordland','15.0262503623962','68.8803118387858');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(789,23,'NOR008028','Rana','NOR008','Nordland','14.3607066319607','66.4450867543341');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(790,23,'NOR008029','Roedoey','NOR008','Nordland','13.2277120272318','66.5828582763672');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(791,23,'NOR008030','Roest','NOR008','Nordland','12.0221672058105','67.4951972961426');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(792,23,'NOR008031','Saltdal','NOR008','Nordland','15.6544059964263','66.8791688083158');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(793,23,'NOR008032','Skjerstad','NOR008','Nordland','15.0438169749559','67.0867444356283');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(794,23,'NOR008033','Soemna','NOR008','Nordland','12.2113571166992','65.3217475891113');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(795,23,'NOR008034','Soerfold','NOR008','Nordland','15.7376705169678','67.52316309611');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(796,23,'NOR008035','Sortland','NOR008','Nordland','15.2869546254476','68.7080815633138');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(797,23,'NOR008036','Steigen','NOR008','Nordland','15.2317447662353','67.8383140563965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(798,23,'NOR008037','Tjeldsund','NOR008','Nordland','16.2861740748088','68.5149251302083');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(799,23,'NOR008038','Traena','NOR008','Nordland','12.0479116439819','66.51513671875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(800,23,'NOR008039','Tysfjord','NOR008','Nordland','16.5221415013922','67.9653730142462');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(801,23,'NOR008040','Vaagan','NOR008','Nordland','14.6501323853379','68.2843055725098');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(802,23,'NOR008041','Vaeroey','NOR008','Nordland','12.6643624305725','67.6985626220703');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(803,23,'NOR008042','Vefsn','NOR008','Nordland','13.2693705240885','65.8283088684082');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(804,23,'NOR008043','Vega','NOR008','Nordland','11.9499316215515','65.7097244262695');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(805,23,'NOR008044','Vestvaagoey','NOR008','Nordland','13.8089284896851','68.206974029541');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(806,23,'NOR008045','Vevelstad','NOR008','Nordland','12.6592514673869','65.6509717305501');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(807,23,'NOR009001','Flatanger','NOR009','Nord-Troendelag','10.7953598658244','64.4496653238932');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(808,23,'NOR009002','Fosnes','NOR009','Nord-Troendelag','11.6772107760111','64.708699798584');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(809,23,'NOR009003','Frosta','NOR009','Nord-Troendelag','10.7560783068339','63.6093377174041');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(810,23,'NOR009004','Grong','NOR009','Nord-Troendelag','12.5691314697266','64.5375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(811,23,'NOR009005','Hoeylandet','NOR009','Nord-Troendelag','12.3708333333333','64.75');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(812,23,'NOR009006','Inderoey','NOR009','Nord-Troendelag','11.2903423945109','63.9060363769531');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(813,23,'NOR009007','Leka','NOR009','Nord-Troendelag','11.7368429942575','65.0947102736647');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(814,23,'NOR009008','Leksvik','NOR009','Nord-Troendelag','10.4755760934007','63.6624988555908');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(815,23,'NOR009009','Levanger','NOR009','Nord-Troendelag','11.2884929656982','63.6921310424805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(816,23,'NOR009010','Lierne','NOR009','Nord-Troendelag','13.5953635851542','64.4193035771317');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(817,23,'NOR009011','Meraaker','NOR009','Nord-Troendelag','11.8283143361409','63.4100569542069');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(818,23,'NOR009012','Mosvik','NOR009','Nord-Troendelag','10.8514608783462','63.8161368320141');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(819,23,'NOR009013','Naeroey','NOR009','Nord-Troendelag','11.8331970850627','64.9013827006022');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(820,23,'NOR009014','Namdalseid','NOR009','Nord-Troendelag','11.1291666666667','64.3313082377116');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(821,23,'NOR009015','Namsos','NOR009','Nord-Troendelag','11.4591268539429','64.4446543375651');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(822,23,'NOR009016','Namsskogan','NOR009','Nord-Troendelag','13.0767751057943','64.8152234395345');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(823,23,'NOR009017','Overhalla','NOR009','Nord-Troendelag','11.9059310913086','64.4833333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(824,23,'NOR009018','Roeyrvik','NOR009','Nord-Troendelag','13.6790638023681','64.8272880554199');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(825,23,'NOR009019','Snaasa','NOR009','Nord-Troendelag','12.5912801106771','64.2');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(826,23,'NOR009020','Steinkjer','NOR009','Nord-Troendelag','11.7541666666667','64.1018529256185');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(827,23,'NOR009021','Stjoerdal','NOR009','Nord-Troendelag','11.2356135686239','63.4666666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(828,23,'NOR009022','Verdal','NOR009','Nord-Troendelag','12.0440731048584','63.7878144582113');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(829,23,'NOR009023','Verran','NOR009','Nord-Troendelag','10.880308119456','63.9523089090983');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(830,23,'NOR009024','Vikna','NOR009','Nord-Troendelag','11.0179433822632','64.9185523986816');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(831,23,'NOR010001','Aremark','NOR010','Oestfold','11.6909798622131','59.1678310360378');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(832,23,'NOR010002','Askim','NOR010','Oestfold','11.159873453776','59.5916666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(833,23,'NOR010003','Eidsberg','NOR010','Oestfold','11.3541666666667','59.5188293457031');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(834,23,'NOR010004','Fredrikstad','NOR010','Oestfold','10.9038235028585','59.2202573140462');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(835,23,'NOR010005','Halden','NOR010','Oestfold','11.4518017689823','59.0665971120199');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(836,23,'NOR010006','Hoboel','NOR010','Oestfold','10.9014027913411','59.6048838297526');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(837,23,'NOR010007','Hvaler','NOR010','Oestfold','10.9541735649109','59.049201965332');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(838,23,'NOR010008','Marker','NOR010','Oestfold','11.6620807011922','59.4803936043868');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(839,23,'NOR010009','Moss','NOR010','Oestfold','10.6810661633809','59.4543315887451');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(840,23,'NOR010010','Raade','NOR010','Oestfold','10.8477394421895','59.3405080159505');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(841,23,'NOR010011','Rakkestad','NOR010','Oestfold','11.3837163289388','59.3555567423503');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(842,23,'NOR010012','Roemskog','NOR010','Oestfold','11.7981369018555','59.7043874434584');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(843,23,'NOR010013','Rygge','NOR010','Oestfold','10.7238872845968','59.369429397583');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(844,23,'NOR010014','Sarpsborg','NOR010','Oestfold','11.1385058085124','59.2678674062093');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(845,23,'NOR010015','Skiptvet','NOR010','Oestfold','11.1321840922038','59.4675231933594');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(846,23,'NOR010016','Spydeberg','NOR010','Oestfold','11.0984769185384','59.601296488444');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(847,23,'NOR010017','Troegstad','NOR010','Oestfold','11.3365147908529','59.6679809570313');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(848,23,'NOR010018','Vaaler','NOR010','Oestfold','10.9316866556803','59.4590469360352');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(849,23,'NOR011001','Dovre','NOR011','Oppland','9.44708582560221','62.1175618489583');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(850,23,'NOR011002','Etnedal','NOR011','Oppland','9.58140487670898','60.9708333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(851,23,'NOR011003','Gausdal','NOR011','Oppland','9.82916666666666','61.2634099324544');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(852,23,'NOR011004','Gjoevik','NOR011','Oppland','10.4440183003743','60.8785598754883');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(853,23,'NOR011005','Gran','NOR011','Oppland','10.510658009847','60.4375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(854,23,'NOR011006','Jevnaker','NOR011','Oppland','10.3726483662923','60.2839477539063');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(855,23,'NOR011007','Lesja','NOR011','Oppland','8.64002634684245','62.1958333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(856,23,'NOR011008','Lillehammer','NOR011','Oppland','10.3708333333333','61.1333333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(857,23,'NOR011009','Lom','NOR011','Oppland','8.42557983398437','61.7140202840169');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(858,23,'NOR011010','Lunner','NOR011','Oppland','10.6458333333333','60.2316314697266');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(859,23,'NOR011011','Nord-Aurdal','NOR011','Oppland','9.26666666666666','61.0041666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(860,23,'NOR011012','Nord-Fron','NOR011','Oppland','9.45','61.607905069987');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(861,23,'NOR011013','Nordre Land','NOR011','Oppland','9.93333333333333','60.9456843058268');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(862,23,'NOR011014','Oestre Toten','NOR011','Oppland','10.9107981363932','60.6148137410482');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(863,23,'NOR011015','Oeyer','NOR011','Oppland','10.4958333333333','61.3276774088542');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(864,23,'NOR011016','Oeystre Slidre','NOR011','Oppland','9.07916666666666','61.255403137207');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(865,23,'NOR011017','Ringebu','NOR011','Oppland','10.29935353597','61.5583333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(866,23,'NOR011018','Sel','NOR011','Oppland','9.55129114786784','61.7573837280273');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(867,23,'NOR011019','Skjaak','NOR011','Oppland','7.94583333333333','61.9372568766276');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(868,23,'NOR011020','Soendre Land','NOR011','Oppland','10.2404146830241','60.6992258707682');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(869,23,'NOR011021','Soer-Aurdal','NOR011','Oppland','9.64005432128906','60.6657165527344');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(870,23,'NOR011022','Soer-Fron','NOR011','Oppland','9.65250396728515','61.6109095255534');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(871,23,'NOR011023','Vaagaa','NOR011','Oppland','8.94876759847005','61.7048060099284');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(872,23,'NOR011024','Vang','NOR011','Oppland','8.44532063802083','61.1958333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(873,23,'NOR011025','Vestre Slidre','NOR011','Oppland','8.90700861612956','61.0541666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(874,23,'NOR011026','Vestre Toten','NOR011','Oppland','10.6071492513021','60.6344584147135');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(875,23,'NOR012000','Oslo','NOR012','Oslo','10.7083333333333','59.9708333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(876,23,'NOR013001','Bjerkreim','NOR013','Rogaland','6.23530642191569','58.6542953491211');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(877,23,'NOR013002','Bokn','NOR013','Rogaland','5.43947720527649','59.216968536377');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(878,23,'NOR013003','Eigersund','NOR013','Rogaland','6.16945508321126','58.5082209269206');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(879,23,'NOR013004','Finnoey','NOR013','Rogaland','5.92163590863804','59.1995964050293');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(880,23,'NOR013005','Forsand','NOR013','Rogaland','6.46181448300679','59.0161107381185');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(881,23,'NOR013006','Gjesdal','NOR013','Rogaland','6.21813977559407','58.8294611612956');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(882,23,'NOR013007','Haa','NOR013','Rogaland','5.74371174176534','58.586946105957');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(883,23,'NOR013008','Haugesund','NOR013','Rogaland','5.23195732434591','59.4480075836182');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(884,23,'NOR013009','Hjelmeland','NOR013','Rogaland','6.41094919840495','59.2049118041992');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(885,23,'NOR013010','Karmoey','NOR013','Rogaland','5.28265261650085','59.2788632710775');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(886,23,'NOR013011','Klepp','NOR013','Rogaland','5.61110865275065','58.763412165554');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(887,23,'NOR013012','Kvitsoey','NOR013','Rogaland','5.40972208976746','59.0687103271484');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(888,23,'NOR013013','Lund','NOR013','Rogaland','6.44112663269043','58.4625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(889,23,'NOR013014','Randaberg','NOR013','Rogaland','5.61267614364624','59.0037570953369');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(890,23,'NOR013015','Rennesoey','NOR013','Rogaland','5.69394421577454','59.0884056091309');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(891,23,'NOR013016','Sandnes','NOR013','Rogaland','5.85416666666667','58.8738147735596');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(892,23,'NOR013017','Sauda','NOR013','Rogaland','6.41903394063314','59.7001427730262');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(893,23,'NOR013018','Sokndal','NOR013','Rogaland','6.30281009674072','58.3788495701872');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(894,23,'NOR013019','Sola','NOR013','Rogaland','5.59633329709371','58.8916202545166');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(895,23,'NOR013020','Stavanger','NOR013','Rogaland','5.7169930934906','58.9505095163981');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(896,23,'NOR013021','Strand','NOR013','Rogaland','6.01516292889913','59.051574198405');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(897,23,'NOR013022','Suldal','NOR013','Rogaland','6.53921135266622','59.5475733439128');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(898,23,'NOR013023','Time','NOR013','Rogaland','5.76508801778157','58.7053502400716');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(899,23,'NOR013024','Tysvaer','NOR013','Rogaland','5.61659800211589','59.3871669769287');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(900,23,'NOR013025','Utsira','NOR013','Rogaland','4.88606214523315','59.3071975708008');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(901,23,'NOR013026','Vindafjord','NOR013','Rogaland','5.82146479423541','59.5091376962748');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(902,23,'NOR014001','Aafjord','NOR014','Soer-Troendelag','10.3513778368632','63.9396685282389');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(903,23,'NOR014002','Agdenes','NOR014','Soer-Troendelag','9.61634826660156','63.5199972788493');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(904,23,'NOR014003','Bjugn','NOR014','Soer-Troendelag','9.62448838551839','63.8607692718506');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(905,23,'NOR014004','Froeya','NOR014','Soer-Troendelag','8.60397529602051','63.770809173584');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(906,23,'NOR014005','Hemne','NOR014','Soer-Troendelag','9.08771717169553','63.2953333536784');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(907,23,'NOR014006','Hitra','NOR014','Soer-Troendelag','8.73023891448975','63.5586624145508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(908,23,'NOR014007','Holtaalen','NOR014','Soer-Troendelag','11.2875','62.8625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(909,23,'NOR014008','Klaebu','NOR014','Soer-Troendelag','10.5188672383626','63.2514032999675');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(910,23,'NOR014009','Malvik','NOR014','Soer-Troendelag','10.7566238840168','63.3753929138184');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(911,23,'NOR014010','Meldal','NOR014','Soer-Troendelag','9.69803390502929','63.0238423665365');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(912,23,'NOR014011','Melhus','NOR014','Soer-Troendelag','10.2875','63.1838275909424');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(913,23,'NOR014012','Midtre Gauldal','NOR014','Soer-Troendelag','10.4875','62.8958333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(914,23,'NOR014013','Oerland','NOR014','Soer-Troendelag','9.56839370727539','63.6945443758781');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(915,23,'NOR014014','Oppdal','NOR014','Soer-Troendelag','9.48532307942708','62.5339630126953');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(916,23,'NOR014015','Orkdal','NOR014','Soer-Troendelag','9.65513677597046','63.3025361378988');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(917,23,'NOR014016','Osen','NOR014','Soer-Troendelag','10.5907777150472','64.3011784871419');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(918,23,'NOR014017','Rennebu','NOR014','Soer-Troendelag','9.85','62.7676940917969');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(919,23,'NOR014018','Rissa','NOR014','Soer-Troendelag','10.1173657417297','63.6803148905436');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(920,23,'NOR014019','Roan','NOR014','Soer-Troendelag','10.3839556058248','64.1697303771973');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(921,23,'NOR014020','Roeros','NOR014','Soer-Troendelag','11.697038054506','62.5731847127279');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(922,23,'NOR014021','Selbu','NOR014','Soer-Troendelag','11.1135210673014','63.1816914876302');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(923,23,'NOR014022','Skaun','NOR014','Soer-Troendelag','10.0483739217122','63.2666695912679');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(924,23,'NOR014023','Snillfjord','NOR014','Soer-Troendelag','9.40311018625895','63.4318335215251');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(925,23,'NOR014024','Trondheim','NOR014','Soer-Troendelag','10.3744654337565','63.3804058074951');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(926,23,'NOR014025','Tydal','NOR014','Soer-Troendelag','11.7457248051961','62.9755619049072');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(927,23,'NOR015001','Aardal','NOR015','Sogn og Fjordane','7.80783082644145','61.2865605672201');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(928,23,'NOR015002','Askvoll','NOR015','Sogn og Fjordane','5.10837807655334','61.381908416748');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(929,23,'NOR015003','Aurland','NOR015','Sogn og Fjordane','7.21480496724446','60.8723765055339');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(930,23,'NOR015004','Balestrand','NOR015','Sogn og Fjordane','6.51291135152181','61.3343424479167');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(931,23,'NOR015005','Bremanger','NOR015','Sogn og Fjordane','5.3339034875234','61.7923131306966');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(932,23,'NOR015006','Eid','NOR015','Sogn og Fjordane','5.95367768890284','61.934196472168');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(933,23,'NOR015007','Fjaler','NOR015','Sogn og Fjordane','5.33587603569031','61.2793219248454');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(934,23,'NOR015008','Flora','NOR015','Sogn og Fjordane','5.2198327700297','61.6094117482503');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(935,23,'NOR015009','Foerde','NOR015','Sogn og Fjordane','6.075','61.4583333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(936,23,'NOR015010','Gaular','NOR015','Sogn og Fjordane','5.89779675801595','61.3312942504883');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(937,23,'NOR015011','Gloppen','NOR015','Sogn og Fjordane','6.17633997599284','61.725631459554');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(938,23,'NOR015012','Gulen','NOR015','Sogn og Fjordane','5.206547498703','60.9592590332031');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(939,23,'NOR015013','Hoeyanger','NOR015','Sogn og Fjordane','5.89987716674805','61.125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(940,23,'NOR015014','Hornindal','NOR015','Sogn og Fjordane','6.58333333333333','62.0024307250977');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(941,23,'NOR015015','Hyllestad','NOR015','Sogn og Fjordane','5.20681770642598','61.176127243042');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(942,23,'NOR015016','Joelster','NOR015','Sogn og Fjordane','6.3982603708903','61.5653752644857');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(943,23,'NOR015017','Laerdal','NOR015','Sogn og Fjordane','7.64096878369649','61.0419108072917');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(944,23,'NOR015018','Leikanger','NOR015','Sogn og Fjordane','6.7560106754303','61.2461654663086');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(945,23,'NOR015019','Luster','NOR015','Sogn og Fjordane','7.5625','61.5172031402588');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(946,23,'NOR015020','Naustdal','NOR015','Sogn og Fjordane','5.76611328125','61.5458333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(947,23,'NOR015021','Selje','NOR015','Sogn og Fjordane','5.30007706935269','62.075466410319');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(948,23,'NOR015022','Sogndal','NOR015','Sogn og Fjordane','7.0847575823466','61.2628682454427');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(949,23,'NOR015023','Solund','NOR015','Sogn og Fjordane','4.8761944770813','61.1055736541748');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(950,23,'NOR015024','Stryn','NOR015','Sogn og Fjordane','6.83395881652832','61.8227238972982');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(951,23,'NOR015025','Vaagsoey','NOR015','Sogn og Fjordane','5.25948627789815','61.9578952789307');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(952,23,'NOR015026','Vik','NOR015','Sogn og Fjordane','6.57215985754529','61.0274448394775');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(953,23,'NOR016001','Bamble','NOR016','Telemark','9.5589298248291','59.0243072509766');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(954,23,'NOR016002','Boe','NOR016','Telemark','8.98534901936849','59.4431650797526');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(955,23,'NOR016003','Drangedal','NOR016','Telemark','8.96481374104818','59.0881403605143');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(956,23,'NOR016004','Fyresdal','NOR016','Telemark','8.03514836629232','59.1397598266602');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(957,23,'NOR016005','Hjartdal','NOR016','Telemark','8.67056452433268','59.6916666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(958,23,'NOR016006','Krageroe','NOR016','Telemark','9.40105307896932','58.8849258422852');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(959,23,'NOR016007','Kviteseid','NOR016','Telemark','8.49736048380534','59.4102615356445');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(960,23,'NOR016008','Nissedal','NOR016','Telemark','8.54405873616536','59.0481557210287');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(961,23,'NOR016009','Nome','NOR016','Telemark','9.11084696451823','59.2625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(962,23,'NOR016010','Notodden','NOR016','Telemark','9.10416666666666','59.6947128295899');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(963,23,'NOR016011','Porsgrunn','NOR016','Telemark','9.73176834344761','59.1087773640951');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(964,23,'NOR016012','Sauherad','NOR016','Telemark','9.29754562377929','59.4400782267253');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(965,23,'NOR016013','Seljord','NOR016','Telemark','8.54138031005859','59.5666666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(966,23,'NOR016014','Siljan','NOR016','Telemark','9.71064707438151','59.3083333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(967,23,'NOR016015','Skien','NOR016','Telemark','9.47916666666666','59.2623728434245');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(968,23,'NOR016016','Tinn','NOR016','Telemark','8.5125','59.9794977823893');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(969,23,'NOR016017','Tokke','NOR016','Telemark','7.90633773803711','59.4588180541992');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(970,23,'NOR016018','Vinje','NOR016','Telemark','7.69023793538411','59.8062306722005');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(971,23,'NOR017001','Balsfjord','NOR017','Troms','19.2093538920085','69.2827164064892');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(972,23,'NOR017002','Bardu','NOR017','Troms','19.1289193471273','68.7067267100016');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(973,23,'NOR017003','Berg','NOR017','Troms','17.3902222338314','69.4573302175407');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(974,23,'NOR017004','Bjarkoey','NOR017','Troms','16.5454252606363','68.995475769043');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(975,23,'NOR017005','Dyroey','NOR017','Troms','17.6923974990845','69.0247982286932');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(976,23,'NOR017006','Gaivuotna-Kaafjord','NOR017','Troms','20.7788305282593','69.4930641174316');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(977,23,'NOR017007','Gratangen','NOR017','Troms','17.5008076985677','68.713279629621');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(978,23,'NOR017008','Harstad','NOR017','Troms','16.4725896835327','68.7780926477147');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(979,23,'NOR017009','Ibestad','NOR017','Troms','17.1575689315796','68.8304443359375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(980,23,'NOR017010','Karlsoey','NOR017','Troms','19.3839797973633','70.0706558227539');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(981,23,'NOR017011','Kvaefjord','NOR017','Troms','16.003444925944','68.7060759639927');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(982,23,'NOR017012','Kvaenangen','NOR017','Troms','22.0340599695841','69.8543122609456');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(983,23,'NOR017013','Lavangen','NOR017','Troms','17.7391072591146','68.7268905639649');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(984,23,'NOR017014','Lenvik','NOR017','Troms','17.9911749299559','69.3839569091797');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(985,23,'NOR017015','Lyngen','NOR017','Troms','20.0877494812012','69.6966908772787');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(986,23,'NOR017016','Maalselv','NOR017','Troms','19.2671195348104','68.9611549377441');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(987,23,'NOR017017','Nordreisa','NOR017','Troms','21.4892412185669','69.5334974130718');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(988,23,'NOR017018','Salangen','NOR017','Troms','17.8210941314697','68.8768905639648');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(989,23,'NOR017019','Skaanland','NOR017','Troms','17.0409156799316','68.6169374965867');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(990,23,'NOR017020','Skjervoey','NOR017','Troms','20.8168964385986','70.0339186714113');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(991,23,'NOR017021','Soerreisa','NOR017','Troms','18.1675064086914','69.1113131205241');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(992,23,'NOR017022','Storfjord','NOR017','Troms','20.3848620732625','69.2562353125932');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(993,23,'NOR017023','Torsken','NOR017','Troms','17.1161794662476','69.2974433898926');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(994,23,'NOR017024','Tranoey','NOR017','Troms','17.2980890274048','69.1839655558268');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(995,23,'NOR017025','Tromsoe','NOR017','Troms','18.9653650148727','69.6874336242676');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(996,23,'NOR018001','Aaseral','NOR018','Vest-Agder','7.39047203063965','58.6771942138672');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(997,23,'NOR018002','Audnedal','NOR018','Vest-Agder','7.36666666666666','58.375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(998,23,'NOR018003','Farsund','NOR018','Vest-Agder','6.78153080641687','58.1423534393311');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(999,23,'NOR018004','Flekkefjord','NOR018','Vest-Agder','6.65329894112815','58.4139673868815');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1000,23,'NOR018005','Haegebostad','NOR018','Vest-Agder','7.20349998474121','58.4791666666667');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1001,23,'NOR018006','Kristiansand','NOR018','Vest-Agder','8.01622374852498','58.1758378346761');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1002,23,'NOR018007','Kvinesdal','NOR018','Vest-Agder','6.94249572753906','58.5213988163508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1003,23,'NOR018008','Lindesnes','NOR018','Vest-Agder','7.24676219622294','58.1162000020345');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1004,23,'NOR018009','Lyngdal','NOR018','Vest-Agder','7.0722162882487','58.1661802927653');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1005,23,'NOR018010','Mandal','NOR018','Vest-Agder','7.50307250022888','58.0624563852946');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1006,23,'NOR018011','Marnardal','NOR018','Vest-Agder','7.54718170166015','58.3083333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1007,23,'NOR018012','Sirdal','NOR018','Vest-Agder','6.80642941792806','58.8473637898763');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1008,23,'NOR018013','Soegne','NOR018','Vest-Agder','7.74591480088367','58.087163289388');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1009,23,'NOR018014','Songdalen','NOR018','Vest-Agder','7.70997873942057','58.2333333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1010,23,'NOR018015','Vennesla','NOR018','Vest-Agder','7.83149998982747','58.3401713053386');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1011,23,'NOR019001','Andebu','NOR019','Vestfold','10.0916666666667','59.2833333333333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1012,23,'NOR019002','Borre','NOR019','Vestfold','10.426278368632','59.397772906007');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1013,23,'NOR019003','Hof','NOR019','Vestfold','10.0237571716309','59.5502863566081');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1014,23,'NOR019004','Holmestrand','NOR019','Vestfold','10.2261149406433','59.5116271972656');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1015,23,'NOR019005','Lardal','NOR019','Vestfold','9.89472986857096','59.3625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1016,23,'NOR019006','Larvik','NOR019','Vestfold','10.0255707422892','59.1435688018799');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1017,23,'NOR019007','Noetteroey','NOR019','Vestfold','10.4590826034546','59.1985378265381');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1018,23,'NOR019008','Ramnes','NOR019','Vestfold','10.1808352152506','59.3875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1019,23,'NOR019009','Sande','NOR019','Vestfold','10.208197727456','59.5896237691244');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1020,23,'NOR019010','Sandefjord','NOR019','Vestfold','10.2225454330444','59.1230107625326');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1021,23,'NOR019011','Stokke','NOR019','Vestfold','10.2476291656494','59.2449928283691');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1022,23,'NOR019012','Svelvik','NOR019','Vestfold','10.3564546902974','59.6129753788859');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1023,23,'NOR019013','Tjoeme','NOR019','Vestfold','10.4427752494812','59.1083793640137');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1024,23,'NOR019014','Toensberg','NOR019','Vestfold','10.3937178293864','59.2972917782199');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1025,23,'NOR019015','Vaale','NOR019','Vestfold','10.2799918810527','59.4209954579671');
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1026,24,'POL-BLS','Bielsko','19.194450378418','49.7638816833496');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1027,24,'POL-BLY','Bialystok','23.2244396209717','52.998607635498');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1028,24,'POL-BPD','Biala Podlaska','23.0191631317139','51.9535140991211');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1029,24,'POL-BYD','Bydgoszcz','18.0476322174072','53.259578704834');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1030,24,'POL-CCH','Ciechanow','20.4113883972168','52.9400291442871');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1031,24,'POL-CHL','Chelm','23.4394426345825','51.2806930541992');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1032,24,'POL-CZS','Czestochowa','19.2216663360596','50.848747253418');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1033,24,'POL-ELB','Elblag','19.5643043518066','53.9916343688965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1034,24,'POL-GDN','Gdansk','18.3181629180908','54.2606887817383');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1035,24,'POL-GRZ','Gorzow','15.2866640090942','52.7952728271484');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1036,24,'POL-JGO','Jelenia Gora','15.523193359375','51.0798568725586');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1037,24,'POL-KIE','Kielce','20.723331451416','50.695140838623');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1038,24,'POL-KLS','Kalisz','17.8625564575195','51.6223564147949');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1039,24,'POL-KON','Konin','18.3947353363037','52.1905517578125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1040,24,'POL-KRK','Krakow','20.0065250396729','50.0529403686523');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1041,24,'POL-KRS','Krosno','22.0027046203613','49.4232978820801');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1042,24,'POL-KSZ','Koszalin','16.1579284667969','53.866138458252');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1043,24,'POL-KTW','Katowice','19.0115795135498','50.2101516723633');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1044,24,'POL-LBL','Lublin','22.3525619506836','51.3382453918457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1045,24,'POL-LGN','Legnica','16.1009302139282','51.3724975585938');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1046,24,'POL-LOD','Lodz','19.4866237640381','51.8148574829102');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1047,24,'POL-LOM','Lomza','22.2578659057617','53.138858795166');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1048,24,'POL-LSZ','Leszno','16.7558307647705','51.8290252685547');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1049,24,'POL-NSA','Nowy Sacz','20.4706287384033','49.5099945068359');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1050,24,'POL-OLS','Olsztyn','20.4776363372803','53.8057899475098');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1051,24,'POL-OPO','Opole','17.7611179351807','50.5795822143555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1052,24,'POL-OST','Ostroleka','21.4205532073975','52.9562492370605');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1053,24,'POL-PIL','Pila','16.7173595428467','53.1548538208008');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1054,24,'POL-PLC','Plock','19.7813606262207','52.4827880859375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1055,24,'POL-PRZ','Przemysl','22.8212013244629','49.9922943115234');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1056,24,'POL-PTR','Piotrkow','19.7437477111816','51.3444404602051');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1057,24,'POL-PZN','Poznan','16.8629140853882','52.364860534668');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1058,24,'POL-RAD','Radom','21.125057220459','51.4818000793457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1059,24,'POL-RZS','Rzeszow','21.9356021881104','50.1133308410645');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1060,24,'POL-SDL','Siedlce','21.9787445068359','52.15478515625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1061,24,'POL-SKR','Skierniewice','20.1702766418457','52.0077667236328');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1062,24,'POL-SLP','Slupsk','17.1921253204346','54.1417655944824');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1063,24,'POL-SRD','Sieradz','18.8414306640625','51.5333290100098');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1064,24,'POL-SWL','Suwalki','22.5164699554443','53.935131072998');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1065,24,'POL-SZC','Szczecin','14.9777770042419','53.4179534912109');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1066,24,'POL-TOR','Torun','19.0866661071777','53.2398567199707');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1067,24,'POL-TRN','Tarnobrzeg','21.8523578643799','50.6965217590332');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1068,24,'POL-TRW','Tarnow','20.920955657959','50.047046661377');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1069,24,'POL-WLB','Walbrzych','16.6849994659424','50.5605506896973');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1070,24,'POL-WLC','Wloclawek','19.042781829834','52.7306728363037');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1071,24,'POL-WRC','Wroclaw','17.037353515625','51.1674957275391');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1072,24,'POL-WRS','Warszawa','20.8554172515869','52.2248592376709');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1073,24,'POL-ZGO','Zielona Gora','15.4480543136597','51.8876342773438');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1074,24,'POL-ZMS','Zamosc','23.2738857269287','50.6248607635498');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1075,25,'PRT-AVE','Aveiro','-8.44404411315918','40.694580078125');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1076,25,'PRT-AZR','Azores','-28.1511116027832','38.2255516052246');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1077,25,'PRT-BEJ','Beja','-7.86979007720947','37.8305511474609');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1078,25,'PRT-BRA','Braga','-8.31309986114502','41.5694808959961');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1079,25,'PRT-BRG','Braganca','-6.80805587768555','41.5118026733398');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1080,25,'PRT-CBR','Castelo Branco','-7.57486152648926','39.9777717590332');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1081,25,'PRT-CMB','Coimbra','-8.31552791595459','40.2209053039551');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1082,25,'PRT-EVO','Evora','-7.8815279006958','38.5993003845215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1083,25,'PRT-FAR','Faro','-8.20291757583618','37.268440246582');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1084,25,'PRT-GUA','Guarda','-7.32069492340088','40.6856918334961');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1085,25,'PRT-LEI','Leiria','-8.74180698394775','39.6898193359375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1086,25,'PRT-LIS','Lisboa','-9.15472316741943','38.9981918334961');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1087,25,'PRT-POR','Porto','-8.33263921737671','41.2416648864746');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1088,25,'PRT-PRT','Portalegre','-7.64836931228638','39.209342956543');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1089,25,'PRT-SNT','Santarem','-8.40875053405762','39.2851333618164');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1090,25,'PRT-STB','Setubal','-8.70361232757568','38.2902717590332');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1091,25,'PRT-VDC','Viana do Castelo','-8.4806957244873','41.8817863464355');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1092,25,'PRT-VIS','Viseu','-7.82986164093018','40.775691986084');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1093,25,'PRT-VRE','Vila Real','-7.63763999938965','41.5137481689453');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1094,26,'ROM-ALB','Alba','23.4952754974365','46.080135345459');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1095,26,'ROM-ARA','Arad','21.7593040466309','46.303050994873');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1096,26,'ROM-ARG','Arges','24.8940258026123','45.0368003845215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1097,26,'ROM-BAC','Bacau','26.7470779418945','46.4294281005859');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1098,26,'ROM-BIH','Bihor','22.1822204589844','46.9957275390625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1099,26,'ROM-BNA','Bistrita-Nasaud','24.5122184753418','47.1822204589844');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1100,26,'ROM-BRA','Braila','27.592357635498','45.1327476501465');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1101,26,'ROM-BRS','Brasov','25.3993034362793','45.8166618347168');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1102,26,'ROM-BTS','Botosani','26.7319507598877','47.8754081726074');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1103,26,'ROM-BUC','Bucuresti','26.1754131317139','44.5451316833496');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1104,26,'ROM-BUZ','Buzau','26.7363834381104','45.3051300048828');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1105,26,'ROM-CLR','Calarasi','27.1463222503662','44.3078689575195');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1106,26,'ROM-CLU','Cluj','23.5066661834717','46.9084701538086');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1107,26,'ROM-CNS','Constanta','28.1339931488037','44.270133972168');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1108,26,'ROM-CSV','Caras-Severin','22.0735454559326','45.1418037414551');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1109,26,'ROM-CVS','Covasna','25.9231910705566','45.9472122192383');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1110,26,'ROM-DMB','Dimbovita','25.5434684753418','44.9965171813965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1111,26,'ROM-DOL','Dolj','23.5474262237549','44.226203918457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1112,26,'ROM-GAL','Galati','27.7156524658203','45.7667045593262');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1113,26,'ROM-GIU','Giurgiu','25.9694442749023','44.1461868286133');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1114,26,'ROM-GOR','Gorj','23.2880535125732','44.9993019104004');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1115,26,'ROM-HND','Hunedoara','23.0401382446289','45.8201370239258');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1116,26,'ROM-HRG','Harghita','25.5731906890869','46.6608276367188');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1117,26,'ROM-IAS','Iasi','27.3381900787354','47.2158451080322');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1118,26,'ROM-ILM','Ialomita','27.1832408905029','44.6046867370605');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1119,26,'ROM-MHD','Mehedinti','22.7549362182617','44.6268424987793');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1120,26,'ROM-MRM','Maramures','24.0258293151855','47.6686058044434');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1121,26,'ROM-MUR','Mures','24.6681900024414','46.6452751159668');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1122,26,'ROM-NEA','Neamt','26.4390258789063','46.9827766418457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1123,26,'ROM-OLT','Olt','24.4123592376709','44.3184700012207');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1124,26,'ROM-PRH','Prahova','26.0520820617676','45.1427917480469');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1125,26,'ROM-SAL','Salaj','23.2449989318848','47.171802520752');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1126,26,'ROM-SIB','Sibiu','24.3340263366699','45.9138870239258');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1127,26,'ROM-SMA','Satu Mare','22.9243621826172','47.7195777893066');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1128,26,'ROM-SUC','Suceava','25.8463878631592','47.5434646606445');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1129,26,'ROM-TIM','Timis','21.4239826202393','45.6842765808105');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1130,26,'ROM-TLR','Teleorman','25.1558322906494','44.0916290283203');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1131,26,'ROM-TUL','Tulcea','28.829439163208','45.043384552002');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1132,26,'ROM-VAS','Vaslui','27.7098579406738','46.4951286315918');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1133,26,'ROM-VIL','Vilcea','24.1224994659424','45.0808296203613');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1134,26,'ROM-VRN','Vrancea','26.9701347351074','45.8002700805664');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1135,27,'ESP-AND','Andalucia','-4.57892990112305','37.318042755127');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1136,27,'ESP-ARG','Aragon','-0.71152800321579','41.3862457275391');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1137,27,'ESP-AST','Asturias','-5.84435939788818','43.2813835144043');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1138,27,'ESP-BLR','Isles Baleares','2.764444231987','39.3511047363281');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1139,27,'ESP-CLM','Castilla-La Mancha','-3.14291673898697','39.6616630554199');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1140,27,'ESP-CNT','Cantabria','-3.99263906478882','43.1345825195313');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1141,27,'ESP-CTL','Cataluna','1.74611109495163','41.6939506530762');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1142,27,'ESP-CYL','Castilla y Leon','-4.42625033855438','41.6731910705566');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1143,27,'ESP-EXT','Extremadura','-6.10278034210205','39.211109161377');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1144,27,'ESP-GLC','Galicia','-8.01291751861572','42.7906913757324');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1145,27,'ESP-LJR','La Rioja','-2.40319454669952','42.2805519104004');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1146,27,'ESP-MDR','Madrid','-3.81583380699158','40.5540237426758');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1147,27,'ESP-MUR','Murcia','-1.51763892173767','38.0670394897461');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1148,27,'ESP-NVR','Navarra','-1.60972237586975','42.6095809936523');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1149,27,'ESP-PSV','Pais Vasco','-2.5897718667984','42.9606895446777');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1150,27,'ESP-VLN','Valenciana','-0.496363699436188','39.2994384765625');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1151,28,'SWE-ALV','Alvsborgs','12.6602153778076','58.1817436218262');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1152,28,'SWE-BLK','Blekinge','15.2168045043945','56.2448577880859');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1153,28,'SWE-GOB','Goteborgs Och Bohus','11.8293046951294','58.3074989318848');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1154,28,'SWE-GTL','Gotlands','18.7227745056152','57.650691986084');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1155,28,'SWE-GVL','Gavleborgs','15.9810647964478','61.2510452270508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1156,28,'SWE-HLL','Hallands','12.7848110198975','56.9495811462402');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1157,28,'SWE-JMT','Jamtlands','14.4705533981323','63.3260612487793');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1158,28,'SWE-JNK','Jonkopings','14.3343787193298','57.4977722167969');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1159,28,'SWE-KLM','Kalmar','16.2391653060913','57.1631889343262');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1160,28,'SWE-KPP','Kopparbergs','14.4048957824707','61.0467147827148');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1161,28,'SWE-KRN','Kronobergs','14.5576372146606','56.7959671020508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1162,28,'SWE-KRS','Kristianstads','13.5983324050903','55.9494590759277');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1163,28,'SWE-MLM','Malmohus','13.322606086731','55.8187484741211');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1164,28,'SWE-NRR','Norrbottens','19.7656936645508','67.0583419799805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1165,28,'SWE-ORB','Orebro','15.0116987228394','59.3734664916992');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1166,28,'SWE-OST','Ostergotlands','15.6219434738159','58.3424949645996');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1167,28,'SWE-SDR','Sodermanlands','16.6129150390625','59.0537452697754');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1168,28,'SWE-SKR','Skaraborgs','13.6138210296631','58.4227714538574');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1169,28,'SWE-STC','Stockholms','18.1622219085693','59.5059700012207');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1170,28,'SWE-UPP','Uppsala','17.6648597717285','60.0562438964844');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1171,28,'SWE-VRM','Varmlands','13.0682621002197','59.8786277770996');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1172,28,'SWE-VSM','Vastmanlands','16.3759984970093','59.7448272705078');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1173,28,'SWE-VSR','Vasternorrlands','17.0468139648438','63.054515838623');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1174,28,'SWE-VST','Vasterbottens','17.9407186508179','64.8755493164063');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1175,197,'E N Cen','E N Cen','-86.7026968008198','42.5803087929104');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1176,197,'E S Cen','E S Cen','-86.6479773034049','34.6684995433633');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1177,197,'Mid Atl','Mid Atl','-76.1980159558062','41.9814105961027');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1178,197,'Mtn','Mtn','-111.016766131323','40.1678303810381');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1179,197,'N Eng','N Eng','-70.3472543463496','44.2258634742769');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1180,197,'Pacific','Pacific','-146.171414434995','45.1655085762938');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1181,197,'S Atl','S Atl','-81.3356673019525','32.7967897888575');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1182,197,'W N Cen','W N Cen','-96.5840124834501','42.6806932851855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(1183,197,'W S Cen','W S Cen','-97.8359324224339','31.4235177443248');
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1184,196,'AK','Alaska',02,'Pacific','-151.777777777778','65.676268861454');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1185,196,'AL','Alabama',01,'E S Cen','-86.683483899971','32.6248189553488');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1186,196,'AR','Arkansas',05,'W S Cen','-92.1313681482295','34.751481339065');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1187,196,'AZ','Arizona',04,'Mtn','-111.788751714678','34.2030178326475');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1188,196,'CA','California',06,'Pacific','-119.821673525377','35.8710562414266');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1189,196,'CO','Colorado',08,'Mtn','-105.546534361717','38.9961845178978');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1190,196,'CT','Connecticut',09,'N Eng','-72.5459533607682','41.6652949245542');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1191,196,'DC','District of Columbia',11,'S Atl','-77.0166164971011','38.8908875514914');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1192,196,'DE','Delaware',10,'S Atl','-75.4183587944153','39.1448606012954');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1193,196,'FL','Florida',12,'S Atl','-81.5884773662551','28.0137174211248');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1194,196,'GA','Georgia',13,'S Atl','-83.2518568978828','32.6808292711285');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1195,196,'HI','Hawaii',15,'Pacific','-157.023319615912','20.39780521262');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1196,196,'IA','Iowa',19,'W N Cen','-93.7037037037037','42.1920438957476');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1197,196,'ID','Idaho',16,'Mtn','-114.159122085048','43.3772290809328');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1198,196,'IL','Illinois',17,'E N Cen','-89.5336076817558','40.1289437585734');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1199,196,'IN','Indiana',18,'E N Cen','-86.4444680326911','39.7708822940655');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1200,196,'KS','Kansas',20,'W N Cen','-98.3263799529049','38.4959318052315');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1201,196,'KY','Kentucky',21,'E S Cen','-85.363511659808','37.2757201646091');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1202,196,'LA','Louisiana',22,'W S Cen','-91.9917695473251','30.4279835390946');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1203,196,'MA','Massachusetts',25,'N Eng','-71.7997256515775','42.3676268861454');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1204,196,'MD','Maryland',24,'S Atl','-76.8477366255144','39.2949245541838');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1205,196,'ME','Maine',23,'N Eng','-69.0283901416762','45.2721925321905');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1206,196,'MI','Michigan',26,'E N Cen','-84.5733882030178','42.9821673525377');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1207,196,'MN','Minnesota',27,'W N Cen','-94.4938271604938','47.0644718792867');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1208,196,'MO','Missouri',29,'W N Cen','-92.4362567253026','38.2997203970396');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1209,196,'MS','Mississippi',28,'E S Cen','-89.8670755505678','32.5999884243719');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1210,196,'MT','Montana',30,'Mtn','-109.550068587106','47.0205761316872');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1211,196,'NC','North Carolina',37,'S Atl','-79.8326474622771','35.7393689986283');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1212,196,'ND','North Dakota',38,'W N Cen','-100.307461048358','47.4654244503963');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1213,196,'NE','Nebraska',31,'W N Cen','-99.6824582951075','41.4978286942191');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1214,196,'NH','New Hampshire',33,'N Eng','-71.5363511659808','43.3772290809328');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1215,196,'NJ','New Jersey',34,'Mid Atl','-74.3456790123457','40.0411522633745');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1216,196,'NM','New Mexico',35,'Mtn','-106.082304526749','34.5980795610425');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1217,196,'NV','Nevada',32,'Mtn','-116.968449931413','39.5144032921811');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1218,196,'NY','New York',36,'Mid Atl','-75.8166108434143','42.7560710425768');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1219,196,'OH','Ohio',39,'E N Cen','-82.6660333841682','40.1936915441621');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1220,196,'OK','Oklahoma',40,'W S Cen','-97.2153635116598','35.4759945130316');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1221,196,'OR','Oregon',41,'Pacific','-120.831275720165','43.9917695473251');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1222,196,'PA','Pennsylvania',42,'Mid Atl','-77.9012345679012','40.9190672153635');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1223,196,'RI','Rhode Island',44,'N Eng','-71.4919055791828','41.6682414823939');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1224,196,'SC','South Carolina',45,'S Atl','-80.96506932337','33.6382651711786');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1225,196,'SD','South Dakota',46,'W N Cen','-100.250215445865','44.2160032678824');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1226,196,'TN','Tennessee',47,'E S Cen','-86.7681755829904','35.8271604938272');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1227,196,'TX','Texas',48,'W S Cen','-99.3662551440329','31.3936899862826');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1228,196,'UT','Utah',49,'Mtn','-111.545239703911','39.4970234444281');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1229,196,'VA','Virginia',51,'S Atl','-78.9986282578875','37.2318244170096');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1230,196,'VT','Vermont',50,'N Eng','-72.4706865059539','43.869602122704');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1231,196,'WA','Washington',53,'Pacific','-120.041152263374','47.4595336076818');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1232,196,'WI','Wisconsin',55,'E N Cen','-89.9265548152997','44.7208161864179');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1233,196,'WV','West Virginia',54,'S Atl','-80.798353909465','38.5486968449931');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1234,196,'WY','Wyoming',56,'Mtn','-107.552567082851','42.9985410346349');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1235,198,'AL','Alabama',01,'E S Cen','-86.6835060119629','32.6246747970581');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1236,198,'AR','Arkansas',05,'W S Cen','-92.131217956543','34.7513885498047');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1237,198,'AZ','Arizona',04,'Mtn','-111.932987213135','34.169732093811');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1238,198,'CA','California',06,'Pacific','-118.127572016461','35.4334705075446');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1239,198,'CO','Colorado',08,'Mtn','-105.545978546143','38.9961910247803');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1240,198,'CT','Connecticut',09,'N Eng','-72.6721536351166','41.6707818930041');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1241,198,'DC','District of Columbia',11,'S Atl','-77.0007620789514','38.9029111415943');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1242,198,'DE','Delaware',10,'S Atl','-75.2620027434842','38.8175582990398');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1243,198,'FL','Florida',12,'S Atl','-83.838436126709','27.979471206665');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1244,198,'GA','Georgia',13,'S Atl','-83.2519569396973','32.6806678771973');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1245,198,'IA','Iowa',19,'W N Cen','-93.3915328979492','41.9366989135742');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1246,198,'ID','Idaho',16,'Mtn','-114.593964334705','43.9272976680384');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1247,198,'IL','Illinois',17,'E N Cen','-89.244170096022','40.3497942386831');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1248,198,'IN','Indiana',18,'E N Cen','-86.4444770812988','39.7708377838135');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1249,198,'KS','Kansas',20,'W N Cen','-98.3260307312012','38.4959163665771');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1250,198,'KY','Kentucky',21,'E S Cen','-85.2496570644719','37.4526748971193');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1251,198,'LA','Louisiana',22,'W S Cen','-92.0096021947874','30.4293552812071');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1252,198,'MA','Massachusetts',25,'N Eng','-71.9259259259259','42.3292181069959');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1253,198,'MD','Maryland',24,'S Atl','-76.6227709190672','39.3004115226337');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1254,198,'ME','Maine',23,'N Eng','-69.3593964334705','45.1783264746228');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1255,198,'MI','Michigan',26,'E N Cen','-84.5473251028807','42.9396433470508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1256,198,'MN','Minnesota',27,'W N Cen','-94.5116598079561','46.2318244170096');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1257,198,'MO','Missouri',29,'W N Cen','-92.4360847473145','38.2996673583984');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1258,198,'MS','Mississippi',28,'E S Cen','-89.8669967651367','32.5998468399048');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1259,198,'MT','Montana',30,'Mtn','-110.052539825439','46.6768646240234');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1260,198,'NC','North Carolina',37,'S Atl','-79.1920438957476','35.6529492455418');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1261,198,'ND','North Dakota',38,'W N Cen','-100.307041168213','47.4654293060303');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1262,198,'NE','Nebraska',31,'W N Cen','-99.6820831298828','41.4978446960449');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1263,198,'NH','New Hampshire',33,'N Eng','-71.7297668038409','43.2030178326475');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1264,198,'NJ','New Jersey',34,'Mid Atl','-74.6474622770919','39.6515775034294');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1265,198,'NM','New Mexico',35,'Mtn','-106.023822784424','34.1715440750122');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1266,198,'NV','Nevada',32,'Mtn','-116.854595336077','39.8230452674897');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1267,198,'NY','New York',36,'Mid Atl','-75.8169708251953','42.7559986114502');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1268,198,'OH','Ohio',39,'E N Cen','-82.6661605834961','40.1936225891113');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1269,198,'OK','Oklahoma',40,'W S Cen','-97.1893004115227','35.5651577503429');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1270,198,'OR','Oregon',41,'Pacific','-120.739368998628','43.6639231824417');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1271,198,'PA','Pennsylvania',42,'Mid Atl','-77.613353729248','40.9932518005371');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1272,198,'RI','Rhode Island',44,'N Eng','-71.4869684499314','41.7146776406036');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1273,198,'SC','South Carolina',45,'S Atl','-80.965259552002','33.6381015777588');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1274,198,'SD','South Dakota',46,'W N Cen','-100.249816894531','44.2160129547119');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1275,198,'TN','Tennessee',47,'E S Cen','-85.9788932800293','35.834156036377');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1276,198,'TX','Texas',48,'W S Cen','-99.0109739368999','31.2853223593964');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1277,198,'UT','Utah',49,'Mtn','-111.544502258301','39.4970626831055');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1278,198,'VA','Virginia',51,'S Atl','-78.7091906721537','37.2331961591221');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1279,198,'VT','Vermont',50,'N Eng','-72.6721536351166','44.3923182441701');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1280,198,'WA','Washington',53,'Pacific','-120.058984910837','47.2853223593964');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1281,198,'WI','Wisconsin',55,'E N Cen','-90.2537722908094','44.9588477366255');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1282,198,'WV','West Virginia',54,'S Atl','-80.9039780521262','38.5939643347051');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1283,198,'WY','Wyoming',56,'Mtn','-107.55192565918','42.9985790252686');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1284,161,'IA','Iowa',19,'W N Cen','-93.3915328979492','41.9366989135742');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1285,161,'IL','Illinois',17,'E N Cen','-89.5120086669922','39.7480659484863');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1286,161,'IN','Indiana',18,'E N Cen','-86.4444770812988','39.7708377838135');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1287,161,'KS','Kansas',20,'W N Cen','-98.3260307312012','38.4959163665771');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1288,161,'MI','Michigan',26,'E N Cen','-86.4139709472656','44.9356842041016');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1289,161,'MN','Minnesota',27,'W N Cen','-93.3798408508301','46.4349403381348');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1290,161,'MO','Missouri',29,'W N Cen','-92.4360847473145','38.2996673583984');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1291,161,'ND','North Dakota',38,'W N Cen','-100.307041168213','47.4654293060303');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1292,161,'NE','Nebraska',31,'W N Cen','-99.6820831298828','41.4978446960449');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1293,161,'OH','Ohio',39,'E N Cen','-82.6661605834961','40.1936225891113');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1294,161,'SD','South Dakota',46,'W N Cen','-100.249816894531','44.2160129547119');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1295,161,'WI','Wisconsin',55,'E N Cen','-89.9263916015625','44.7208404541016');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1296,162,'CT','Connecticut',09,'N Eng','-72.7571983337402','41.5228157043457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1297,162,'MA','Massachusetts',25,'N Eng','-71.708797454834','42.0624713897705');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1298,162,'ME','Maine',23,'N Eng','-69.0289192199707','45.2721290588379');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1299,162,'NH','New Hampshire',33,'N Eng','-71.6442680358887','43.9999675750732');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1300,162,'NJ','New Jersey',34,'Mid Atl','-74.7335777282715','40.1535243988037');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1301,162,'NY','New York',36,'Mid Atl','-75.8169708251953','42.7559986114502');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1302,162,'PA','Pennsylvania',42,'Mid Atl','-77.613353729248','40.9932518005371');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1303,162,'RI','Rhode Island',44,'N Eng','-71.4924049377441','41.6681423187256');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1304,162,'VT','Vermont',50,'N Eng','-72.4711380004883','43.8695373535156');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1305,163,'AL','Alabama',01,'E S Cen','-86.6835060119629','32.6246747970581');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1306,163,'AR','Arkansas',05,'W S Cen','-92.131217956543','34.7513885498047');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1307,163,'DC','District of Columbia',11,'S Atl','-77.016918182373','38.890775680542');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1308,163,'DE','Delaware',10,'S Atl','-75.4187164306641','39.1447486877441');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1309,163,'FL','Florida',12,'S Atl','-83.838436126709','27.979471206665');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1310,163,'GA','Georgia',13,'S Atl','-83.2519569396973','32.6806678771973');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1311,163,'KY','Kentucky',21,'E S Cen','-85.7639427185059','37.8192615509033');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1312,163,'LA','Louisiana',22,'W S Cen','-91.531681060791','30.9813537597656');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1313,163,'MD','Maryland',24,'S Atl','-77.2680435180664','38.847749710083');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1314,163,'MS','Mississippi',28,'E S Cen','-89.8669967651367','32.5998468399048');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1315,163,'NC','North Carolina',37,'S Atl','-79.8904151916504','35.2358207702637');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1316,163,'OK','Oklahoma',40,'W S Cen','-98.7127799987793','35.3112144470215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1317,163,'SC','South Carolina',45,'S Atl','-80.965259552002','33.6381015777588');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1318,163,'TN','Tennessee',47,'E S Cen','-85.9788932800293','35.834156036377');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1319,163,'TX','Texas',48,'W S Cen','-100.078365325928','31.1695375442505');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1320,163,'VA','Virginia',51,'S Atl','-79.4589233398438','37.9991912841797');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1321,163,'WV','West Virginia',54,'S Atl','-80.1875152587891','38.9209671020508');

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1322,164,'AK','Alaska',02,'Pacific','-113.662534152788','24.5736421265078');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1323,164,'AZ','Arizona',04,'Mtn','-111.932987213135','34.169732093811');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1324,164,'CA','California',06,'Pacific','-119.257961273193','37.2690353393555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1325,164,'CO','Colorado',08,'Mtn','-105.545978546143','38.9961910247803');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1326,164,'HI','Hawaii',15,'Pacific','-97.5770105686923','21.602968765127');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1327,164,'ID','Idaho',16,'Mtn','-114.140953063965','45.4973487854004');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1328,164,'MT','Montana',30,'Mtn','-110.052539825439','46.6768646240234');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1329,164,'NM','New Mexico',35,'Mtn','-106.023822784424','34.1715440750122');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1330,164,'NV','Nevada',32,'Mtn','-117.015937805176','38.4978275299072');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1331,164,'OR','Oregon',41,'Pacific','-120.513919830322','44.112024307251');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1332,164,'UT','Utah',49,'Mtn','-111.544502258301','39.4970626831055');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1333,164,'WA','Washington',53,'Pacific','-120.824787139893','47.2716274261475');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,centroid_x,centroid_y) values(1334,164,'WY','Wyoming',56,'Mtn','-107.55192565918','42.9985790252686');
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1335,165,'430','-83.060501','40.186497');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1336,165,'431','-82.9199325','39.6807025');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1337,165,'432','-83.0003545','39.9795505');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1338,165,'433','-83.334611','40.611472');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1339,165,'434','-83.2422555','41.4640605');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1340,165,'435','-84.1106285','41.4386153748757');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1341,165,'436','-83.5233461167659','41.6529485');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1342,165,'437','-81.6361585','39.824566');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1343,165,'438','-81.825038','40.2522065');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1344,165,'439','-80.9720345','40.1431561316309');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1345,165,'440','-81.4938802268055','41.5209955');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1346,165,'441','-81.681298','41.4420015');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1347,165,'442','-81.6114275','41.1385005');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1348,165,'443','-81.5463975','41.0646555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1349,165,'444','-80.8210065','41.08166');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1350,165,'445','-80.680498','41.070546');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1351,165,'446','-81.572713','40.6183625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1352,165,'447','-81.341267','40.827258');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1353,165,'448','-82.8599475','40.982462276838');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1354,165,'449','-82.5484955','40.751925');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1355,165,'450','-84.3867605','39.3658795');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1356,165,'451','-83.829033','39.125683');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1357,165,'452','-84.481261','39.1644825');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1358,165,'453','-84.1609511006198','40.021972');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1359,165,'454','-84.181539','39.7364325');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1360,165,'455','-83.8100045','39.924507');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1361,165,'456','-82.931453','38.965981');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1362,165,'457','-81.684544','39.2945175');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1363,165,'458','-84.1035055','40.772242');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1364,165,'460','-86.151823','40.154646');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1365,165,'461','-86.137085','39.6550735');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1366,165,'462','-86.1546555','39.775802');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1367,165,'463','-87.0065915','41.3961395');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1368,165,'464','-87.3132635','41.5388895');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1369,165,'465','-86.11887','41.4093565');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1370,165,'466','-86.297752','41.6548145');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1371,165,'467','-85.263147','41.163629');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1372,165,'468','-85.1433615','41.0833975');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1373,165,'469','-86.1067025','40.7910045');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1374,165,'470','-85.1222995','39.1418295');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1375,165,'471','-86.047847','38.394915');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1376,165,'472','-85.768531','39.0306185');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1377,165,'473','-85.2038071271045','40.0709355');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1378,165,'474','-86.674496','38.939736');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1379,165,'475','-87.0872637290241','38.404731');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1380,165,'476','-87.4424132310496','38.1526305');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1381,165,'477','-87.592526','37.9967345');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1382,165,'478','-87.2247052811929','39.427416');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1383,165,'479','-87.0291191830531','40.4990225');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1384,165,'480','-82.8665485','42.8236515');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1385,165,'481','-83.632485','42.181428');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1386,165,'482','-83.1248615','42.3403835');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1387,165,'483','-83.3647745','42.6714805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1388,165,'484','-83.3376516118382','43.3628915');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1389,165,'485','-83.7120065','43.0114585');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1390,165,'486','-84.4435975','43.9957575');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1391,165,'487','-83.557944','44.0412305');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1392,165,'488','-84.5762355','43.0785395');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1393,165,'489','-84.5816295','42.7323345');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1394,165,'490','-85.6657588053375','42.2572675');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1395,165,'491','-86.3174395','41.924406216719');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1396,165,'492','-84.2901195','42.125362');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1397,165,'493','-85.472377','43.292623');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1398,165,'494','-86.1255735','43.3253155');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1399,165,'495','-85.6701355','42.9572265');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1400,165,'496','-85.6334820393135','44.476991');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1401,165,'497','-84.447956','45.6419005');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1402,165,'498','-86.851994','46.253062104453');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1403,165,'499','-89.0643035','47.0558625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1404,165,'500','-93.7835315','41.6607735');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1405,165,'501','-93.607769','41.637476505079');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1406,165,'502','-93.587869','41.692867');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1407,165,'503','-93.6576515','41.5879805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1408,165,'504','-93.291813','43.0648488964235');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1409,165,'505','-94.448132','42.840315');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1410,165,'506','-92.4101375','42.6842425');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1411,165,'507','-92.269078','42.484464');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1412,165,'508','-94.6257975','41.001171');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1413,165,'510','-95.908141','42.535746');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1414,165,'511','-96.3754855','42.5074215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1415,165,'512','-96.0637725','43.2488245');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1416,165,'513','-95.122129','43.1978475');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1417,165,'514','-95.0451015','42.0924405');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1418,165,'515','-95.557839','41.460411');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1419,165,'516','-95.3419885','40.7335662161271');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1420,165,'520','-90.8859315','42.455492');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1421,165,'521','-91.777172626258','43.1014035');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1422,165,'522','-91.6329225','41.84481');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1423,165,'523','-91.7769645','41.802372');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1424,165,'524','-91.667941','41.9743565');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1425,165,'525','-92.473649','41.0029796525439');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1426,165,'526','-91.4361985','40.8295635');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1427,165,'527','-90.828086','41.6012325');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1428,165,'528','-90.5979875','41.5564815');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1429,165,'530','-88.2935673710615','43.5439865');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1430,165,'531','-88.328967','42.7862375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1431,165,'532','-87.960184','43.054512');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1432,165,'534','-87.8402810522813','42.747530140677');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1433,165,'535','-89.6600235','43.006366');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1434,165,'537','-89.3872825','43.0809555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1435,165,'538','-90.7399285','42.890417');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1436,165,'539','-89.5256005','43.679347');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1437,165,'540','-92.3898995','45.0986260693366');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1438,165,'541','-88.2361565','45.0312025');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1439,165,'542','-87.4245895','44.696341');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1440,165,'543','-88.0082775','44.5423685');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1441,165,'544','-89.785864','44.919769');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1442,165,'545','-89.7280875','45.9595545');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1443,165,'546','-90.8805815','43.804965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1444,165,'547','-91.532929','44.864639');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1445,165,'548','-91.6405745','46.1877675');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1446,165,'549','-89.008888','44.2235575');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1447,165,'550','-92.8241855','45.1043377232657');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1448,165,'551','-93.060314','44.9396625');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1449,165,'553','-94.0588105','45.035715');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1450,165,'554','-93.334477','45.002851');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1451,165,'556','-90.8024495','47.5927297190896');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1452,165,'557','-92.4157665','47.1807545');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1453,165,'558','-92.079357','46.9359915');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1454,165,'559','-92.302088','43.9569950352116');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1455,165,'560','-94.129403','44.0785035');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1456,165,'561','-95.4728335','44.0609975');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1457,165,'562','-95.7470525','45.166519426315');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1458,165,'563','-94.5364565','45.836512');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1459,165,'564','-94.285395','46.7432095');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1460,165,'565','-96.0674882781396','46.8323275');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1461,165,'566','-94.4193985','48.0936255');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1462,165,'567','-95.96073','48.477292');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1463,165,'570','-97.2997095','43.4970555');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1464,165,'571','-96.752944','43.5530695');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1465,165,'572','-97.2171285','45.065442');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1466,165,'573','-98.5113545','43.867108');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1467,165,'574','-98.9522305','45.2807969964931');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1468,165,'575','-100.580804','43.9472665');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1469,165,'576','-101.612128','45.38919');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1470,165,'577','-102.757811','44.4723454993615');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1471,165,'580','-97.391238','46.7165495');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1472,165,'581','-96.874610136009','46.8807496293984');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1473,165,'582','-97.8710878857723','48.176776');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1474,165,'583','-99.423335','48.2793222643228');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1475,165,'584','-99.316025','46.84812');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1476,165,'585','-100.850297','46.8655745');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1477,165,'586','-102.830672','46.809607');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1478,165,'587','-101.7246105','48.245627');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1479,165,'588','-103.3939405','48.238718');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1480,165,'592','-103.999374','47.899732');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1481,165,'600','-88.2130289339696','42.2308925');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1482,165,'601','-88.413155','42.075077');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1483,165,'602','-87.6996103314222','42.0455336325347');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1484,165,'603','-87.8043085','41.8870835');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1485,165,'604','-88.1233005','41.391877');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1486,165,'605','-88.461569','41.659698');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1487,165,'606','-87.6954035','41.8255814828643');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1488,165,'607','-87.7833615','41.9852295');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1489,165,'608','-87.6786005','41.7479825');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1490,165,'609','-88.02128','40.8059645');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1491,165,'610','-89.656883','42.0567635');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1492,165,'611','-89.0812875','42.2743955');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1493,165,'612','-90.3634495','41.578103');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1494,165,'613','-89.198957','41.371783');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1495,165,'614','-90.3320178350803','40.7631395');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1496,165,'615','-89.748625','40.7089345');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1497,165,'616','-89.6139635','40.6936375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1498,165,'617','-89.0034225','40.47933');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1499,165,'618','-88.1785972750806','40.1184805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1500,165,'619','-88.227652','39.618324');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1501,165,'620','-89.8844405','39.1073399965967');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1502,165,'622','-89.756167','38.383207');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1503,165,'623','-91.011778','39.9811425');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1504,165,'624','-88.372701','38.9465645');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1505,165,'625','-89.2318305','39.7132805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1506,165,'626','-89.9646425','39.72924');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1507,165,'627','-89.6393805','39.7850925');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1508,165,'628','-88.5646745','38.3818525');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1509,165,'629','-88.8576015','37.4827345');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1510,165,'630','-90.836177','38.4022835');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1511,165,'631','-90.327864','38.614201');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1512,165,'633','-90.9623405','39.0486325');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1513,165,'634','-91.7653005261522','39.9690365');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1514,165,'635','-92.625048','40.0877875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1515,165,'636','-90.640575','37.5939');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1516,165,'637','-89.8080175','37.3970955');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1517,165,'638','-89.7383665','36.575296');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1518,165,'639','-90.640358','36.8815461264312');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1519,165,'640','-94.22389','39.04876');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1520,165,'641','-94.6103455','39.101924');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1521,165,'644','-94.7689405','39.991558');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1522,165,'645','-94.839456','39.7609965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1523,165,'646','-93.5654585','39.8947981323493');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1524,165,'647','-94.0244165','37.9919875');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1525,165,'648','-94.256296','36.966793');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1526,165,'650','-92.201504','38.392382');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1527,165,'651','-92.1481345','38.5230695');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1528,165,'652','-92.4486695','39.1892735');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1529,165,'653','-93.275231','38.712412');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1530,165,'654','-91.942832','37.507264');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1531,165,'655','-91.998575','37.5337265');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1532,165,'656','-92.636015','37.2859275');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1533,165,'657','-92.722024','37.3302735');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1534,165,'658','-93.310791','37.2394395');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1535,165,'660','-95.0998584910985','38.988447196206');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1536,165,'661','-94.7456375','39.134897');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1537,165,'662','-94.7584967495173','38.9437099683642');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1538,165,'664','-96.170196','39.2540612145904');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1539,165,'665','-96.0991225','39.2178385464197');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1540,165,'666','-95.802994','39.0656795');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1541,165,'667','-95.3605195','37.5612565');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1542,165,'668','-96.376745','38.429338');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1543,165,'669','-97.963639','39.691047');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1544,165,'670','-97.720233','37.730988');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1545,165,'671','-97.874999','37.6365983656498');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1546,165,'672','-97.3425465','37.695391');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1547,165,'673','-95.7257055','37.3026785');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1548,165,'674','-97.8224065','38.9722155');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1549,165,'675','-98.9833735','38.272986');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1550,165,'676','-99.5381035','39.327261');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1551,165,'677','-101.0983805','39.3503645');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1552,165,'678','-100.7920955','37.891399');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1553,165,'679','-101.33762','37.1911364911484');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1554,165,'680','-96.435506','41.6185255');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1555,165,'681','-96.0485155','41.251748');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1556,165,'683','-96.6661875','40.5670573669547');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1557,165,'684','-96.6043705','40.5233335');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1558,165,'685','-96.6967475','40.842225');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1559,165,'686','-97.726787','41.5533865');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1560,165,'687','-98.2774335','42.319908');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1561,165,'688','-99.056679','41.3933525');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1562,165,'689','-98.934254','40.374801');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1563,165,'690','-100.976814','40.4662995');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1564,165,'691','-101.9392005','41.5326935');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1565,165,'692','-100.872968','42.5424205');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1566,165,'693','-102.6652685','42.2763245');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1567,165,'726','-92.9813145','36.5070718102201');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,centroid_x,centroid_y) values(1568,165,'820','-103.992291','41.160633');
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1569,154,'AC','Antigua and Barbuda','AC','-61.7878494262695','17.3570108413696');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1570,154,'AD','Andorra','AN','1.61377644538879','42.5240955352783');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1571,154,'AE','United Arab Emirates','TC','53.9800300598145','24.3826389312744');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1572,154,'AF','Afghanistan','AF','67.710090637207','33.9390411376953');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1573,154,'AI','Anguilla','AV','-63.0944480895996','18.2166652679443');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1574,154,'AL','Albania','AL','20.1653099060059','41.1352729797363');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1575,154,'AM','Armenia','AM','45.0406532287598','40.0690994262695');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1576,154,'AN','Netherlands Antilles','NT','-68.6718788146973','12.2022213935852');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1577,154,'AO','Angola','AO','17.8909702301025','-11.2051405906677');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1578,154,'AR','Argentina','AR','-63.6161518096924','-38.4160976409912');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1579,154,'AS','American Samoa','AQ','-170.688545227051','-14.3149309158325');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1580,154,'AT','Austria','AU','13.3499774932861','47.7131195068359');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1581,154,'AU','Australia','AS','135.940254211426','-32.4554181098938');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1582,154,'AW','Aruba','AA','-69.9672622680664','12.5194430351257');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1583,154,'AZ','Azerbaijan','AJ','47.5769271850586','40.1467800140381');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1584,154,'BA','Bosnia and Herzegovina','BK','17.6795768737793','43.915885925293');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1585,154,'BB','Barbados','BB','-59.5301399230957','13.1927766799927');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1586,154,'BD','Bangladesh','BG','90.3566055297852','23.6854801177979');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1587,154,'BE','Belgium','BE','4.46993517875671','50.4979133605957');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1588,154,'BG','Bulgaria','BU','25.4742603302002','42.7338752746582');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1589,154,'BH','Bahrain','BA','50.6276359558105','25.9304141998291');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1590,154,'BI','Burundi','BY','29.9340515136719','-3.37847256660461');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1591,154,'BJ','Benin','BN','2.31583309173584','9.30768966674805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1592,154,'BM','Bermuda','BD','-64.7587547302246','32.3168697357178');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1593,154,'BN','Brunei','BX','114.723575592041','4.53284621238709');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1594,154,'BO','Bolivia','BL','-63.5700073242188','-16.2865633964539');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1595,154,'BR','Brazil','BR','-54.4032001495361','-14.2474875450134');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1596,154,'BS','Bahamas, The','BF','-75.8736190795898','23.9065265655518');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1597,154,'BT','Bhutan','BT','90.4205474853516','27.5194816589355');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1598,154,'BV','Bouvet Island','BV','3.41999983787537','-54.4266719818115');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1599,154,'BW','Botswana','BC','24.6851444244385','-22.3329658508301');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1600,154,'BY','Byelarus','BO','27.9527292251587','53.701000213623');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1601,154,'BZ','Belize','BH','-88.5130882263184','17.1863899230957');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1602,154,'CA','Canada','CA','-96.8101768493652','62.3988761901855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1603,154,'CC','Cocos (Keeling) Islands','CK','96.8359603881836','-12.1649298667908');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1604,154,'CD','Zaire','CG','21.7586641311646','-4.03451466560364');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1605,154,'CF','Central African Republic','CT','20.9370822906494','6.61104607582092');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1606,154,'CG','Congo','CF','14.8828096389771','-0.651943206787109');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1607,154,'CH','Switzerland','SZ','8.21912431716919','46.8222198486328');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1608,154,'CK','Cook Islands','CW','-161.778495788574','-16.4110765457153');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1609,154,'CL','Chile','CI','-71.9648666381836','-30.7037544250488');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1610,154,'CM','Cameroon','CM','12.3577032089233','7.36958277225494');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1611,154,'CN','China','CH','104.208251953125','35.8706893920898');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1612,154,'CO','Colombia','CO','-74.2921752929688','4.17444467544556');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1613,154,'CR','Costa Rica','CS','-84.2374801635742','9.61769485473633');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1614,154,'CU','Cuba','CU','-79.5475769042969','21.4990243911743');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1615,154,'CV','Cape Verde','CV','-23.9992380142212','15.9598941802979');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1616,154,'CX','Christmas Island','KT','105.682800292969','-10.4475250244141');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1617,154,'CY','Cyprus','CY','33.4279479980469','35.1954116821289');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1618,154,'CZ','Czech Republic','EZ','15.4724750518799','49.8169364929199');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1619,154,'DE','Germany','GM','10.4494087696075','51.1656227111816');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1620,154,'DJ','Djibouti','DJ','42.5970802307129','11.8553848266602');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1621,154,'DK','Denmark','DA','11.6152763366699','56.1491031646729');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1622,154,'DM','Dominica','DO','-61.3527793884277','15.4149990081787');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1623,154,'DO','Dominican Republic','DR','-70.1643142700195','18.7674293518066');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1624,154,'DQ','Jarvis Island','DQ','-160.026473999023','-0.386180534958839');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1625,154,'DZ','Algeria','AG','1.65962600708008','28.0313873291016');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1626,154,'EC','Ecuador','EC','-83.4403686523438','-1.77888906002045');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1627,154,'EE','Estonia','EN','25.000825881958','58.5920734405518');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1628,154,'EG','Egypt','EG','30.7976350784302','26.8225679397583');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1629,154,'EH','Western Sahara','WI','-12.8840980529785','24.2155265808105');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1630,154,'ER','Eritrea','ER','39.7823333740234','15.1793842315674');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1631,154,'ES','Spain','SP','-3.69096946716309','40.4422187805176');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1632,154,'ET','Ethiopia','ET','40.4900207519531','9.14645755290985');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1633,154,'FI','Finland','FI','25.5601472854614','64.9477043151855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1634,154,'FJ','Fiji','FJ','178.2532185059','-18.8589416504');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1635,154,'FK','Falkland Islands (Islas Malvinas)','FK','-59.4361820220947','-51.7962532043457');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1636,154,'FM','Federated States of Micronesia','FM','160.612609863281','6.11965203285217');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1637,154,'FO','Faroe Islands','FO','-6.9100353717804','61.8729133605957');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1638,154,'FQ','Baker Island','FQ','-176.461753845215','0.218923553824425');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1639,154,'FR','France','FR','2.38795065879822','46.2291984558105');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1640,154,'GA','Gabon','GB','11.6147904396057','-0.803689479827881');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1641,154,'GD','Grenada','GJ','-61.6673622131348','12.1309714317322');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1642,154,'GE','Georgia','GG','43.3463020324707','42.3152809143066');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1643,154,'GF','French Guiana','FG','-53.1439247131348','3.93444418907166');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1644,154,'GH','Ghana','GH','-1.02499914169312','7.9346866607666');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1645,154,'GI','Gibraltar','GI','-5.34515357017517','36.1380214691162');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1646,154,'GK','Guernsey','GK','-2.60256969928741','49.4653434753418');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1647,154,'GL','Greenland','GL','-42.6097192764282','71.6962394714355');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1648,154,'GM','Gambia, The','GA','-15.2747430801392','13.4431819915771');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1649,154,'GN','Guinea','GV','-11.3351089954376','9.93557405471802');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1650,154,'GO','Glorioso Islands','GO','47.291072845459','-11.5659379959106');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1651,154,'GP','Guadeloupe','GP','-61.4945869445801','16.1914567947388');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1652,154,'GQ','Equatorial Guinea','EK','9.89999866485596','2.37180531024933');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1653,154,'GR','Greece','GR','23.9409017562866','38.3225650787354');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1654,154,'GS','South Georgia and the South Sandwich Is','SX','-32.1363220214844','-56.253023147583');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1655,154,'GT','Guatemala','GT','-90.2307586669922','15.783242225647');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1656,154,'GU','Guam','GQ','144.765647888184','13.4436435699463');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1657,154,'GW','Guinea-Bissau','PU','-15.1935377120972','11.8205862045288');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1658,154,'GY','Guyana','GY','-58.9301795959473','4.86107563972473');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1659,154,'GZ','Gaza Strip','GZ','34.3536033630371','31.4063186645508');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1660,154,'HM','Heard Island & McDonald Islands','HM','73.5042953491211','-53.0933361053467');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1661,154,'HN','Honduras','HO','-86.2400817871094','14.7092704772949');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1662,154,'HQ','Howland Island','HQ','-176.637084960938','0.799444377422333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1663,154,'HR','Croatia','HR','16.5083684921265','44.465404510498');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1664,154,'HT','Haiti','HA','-73.0707015991211','19.0549983978271');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1665,154,'HU','Hungary','HU','19.5033044815063','47.1549968719482');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1666,154,'ID','Indonesia','ID','118.108982086182','-2.51309084892273');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1667,154,'IE','Ireland','EI','-8.23819541931152','53.4119396209717');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1668,154,'IL','Israel','IS','34.9582328796387','31.3662166595459');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1669,154,'IM','Man, Isle of','IM','-4.56562566757202','54.2327728271484');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1670,154,'IN','India','IN','82.7526626586914','21.1235797405243');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1671,154,'IO','British Indian Ocean Territory','IO','72.4560928344727','-7.37431335449219');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1672,154,'IQ','Iraq','IZ','43.6701278686523','33.2439365386963');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1673,154,'IR','Iran','IR','53.6826133728027','32.4299926757813');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1674,154,'IS','Iceland','IC','-19.0189247131348','64.9636039733887');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1675,154,'IT','Italy','IT','12.5682320594788','41.8718719482422');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1676,154,'IV','Ivory Coast','IV','-5.54708123207092','7.54403114318848');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1677,154,'JE','Jersey','JE','-2.12736141681671','49.2133960723877');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1678,154,'JM','Jamaica','JM','-77.2965354919434','18.1088886260986');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1679,154,'JN','Jan Mayen','JN','-8.58087158203125','70.9623336791992');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1680,154,'JO','Jordan','JO','37.1312484741211','31.2832412719727');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1681,154,'JP','Japan','JA','134.745635986328','34.8701343536377');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1682,154,'JQ','Johnston Atoll','JQ','-169.531433105469','16.7272157669067');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1683,154,'JU','Juan De Nova Island','JU','42.7423572540283','-17.0670509338379');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1684,154,'KE','Kenya','KE','37.906192779541','-0.0235590934753418');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1685,154,'KG','Kyrgyzstan','KG','74.7650604248047','41.2061862945557');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1686,154,'KH','Cambodia','CB','105.003223419189','12.5656785964966');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1687,154,'KI','Kiribati','KR','-157.401329040527','1.86687457561493');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1688,154,'KM','Comoros','CN','43.8668727874756','-11.8806953430176');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1689,154,'KN','St. Kitts and Nevis','SC','-62.7394485473633','17.2973575592041');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1690,154,'KP','North Korea','KN','127.510684967041','40.3379745483398');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1691,154,'KR','South Korea','KS','127.844257354736','35.9520606994629');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1692,154,'KW','Kuwait','KU','47.4817657470703','29.2782192230225');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1693,154,'KY','Cayman Islands','CJ','-81.2464637756348','19.3215951919556');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1694,154,'KZ','Kazakhstan','KZ','66.9236831665039','48.0201988220215');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1695,154,'LA','Laos','LA','103.893310546875','18.213885307312');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1696,154,'LB','Lebanon','LE','35.8622856140137','33.8579139709473');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1697,154,'LC','St. Lucia','ST','-61.006462097168','13.9093742370605');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1698,154,'LI','Liechtenstein','LS','9.55426263809204','47.1660003662109');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1699,154,'LK','Sri Lanka','CE','80.7846336364746','7.87152624130249');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1700,154,'LR','Liberia','LI','-9.45901274681091','6.42059135437012');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1701,154,'LS','Lesotho','LT','28.2347621917725','-29.6106119155884');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1702,154,'LT','Lithuania','LH','23.8748178482056','55.1700954437256');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1703,154,'LU','Luxembourg','LU','6.13590216636658','49.7936172485352');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1704,154,'LV','Latvia','LG','24.5708084106445','56.8790454864502');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1705,154,'LY','Libya','LY','17.2315263748169','26.3351001739502');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1706,154,'MA','Morocco','MO','-7.09338337182999','31.7906723022461');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1707,154,'MC','Monaco','MN','7.41545104980469','43.7479209899902');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1708,154,'MD','Moldova','MD','28.3818531036377','46.9491119384766');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1709,154,'MG','Madagascar','MA','46.8668022155762','-18.7763910293579');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1710,154,'MH','Marshall Islands','RM','166.148292541504','10.0971512794495');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1711,154,'MK','Macedonia','MK','21.764199256897','41.5898857116699');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1712,154,'ML','Mali','ML','-3.99977779388428','17.5738868713379');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1713,154,'MM','Myanmar (Burma)','BM','96.7045288085938','19.203052520752');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1714,154,'MN','Mongolia','MG','103.829570770264','46.8647155761719');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1715,154,'MO','Macau','MC','113.543045043945','22.1998701095581');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1716,154,'MP','Northern Mariana Islands','CQ','145.691917419434','15.0742340087891');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1717,154,'MQ','Martinique','MB','-61.0338935852051','14.6247215270996');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1718,154,'MR','Mauritania','MR','-10.9292206764221','21.0274219512939');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1719,154,'MS','Montserrat','MH','-62.1920871734619','16.7102756500244');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1720,154,'MT','Malta','MT','14.4512491226196','35.8801345825195');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1721,154,'MU','Mauritius','MP','60.3925666809082','-20.0973625183105');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1722,154,'MV','Maldives','MV','73.2503318786621','3.19305500388145');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1723,154,'MW','Malawi','MI','34.3014183044434','-13.2696714401245');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1724,154,'MX','Mexico','MX','-102.561813354492','23.6345014572144');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1725,154,'MY','Malaysia','MY','109.454986572266','4.09888827800751');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1726,154,'MZ','Mozambique','MZ','35.52956199646','-18.6689500808716');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1727,154,'NA','Namibia','WA','18.5086069107056','-22.9545860290527');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1728,154,'NC','New Caledonia','NC','166.045379638672','-21.3809032440186');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1729,154,'NE','Niger','NG','8.0816663056612','17.6077890396118');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1730,154,'NF','Norfolk Island','NF','167.957473754883','-29.0408344268799');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1731,154,'NG','Nigeria','NI','8.6824414730072','9.08217263221741');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1732,154,'NI','Nicaragua','NU','-85.4108390808105','12.8513331413269');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1733,154,'NL','Netherlands','NL','5.28961515426636','52.1115493774414');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1734,154,'NO','Norway','NO','9.32098765432099','62.5712432861328');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1735,154,'NP','Nepal','NP','84.1265754699707','28.3766803741455');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1736,154,'NR','Nauru','NR','166.92115020752','-0.522777795791626');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1737,154,'NU','Niue','NE','-169.838150024414','-19.057918548584');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1738,154,'NZ','New Zealand','NZ','174.999275207519531','-41.5062522888184');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1739,154,'OM','Oman','MU','55.9158935546875','21.5057458877563');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1740,154,'PA','Panama','PM','-80.1229248046875','8.40013837814331');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1741,154,'PE','Peru','PE','-75.0145263671875','-9.22753269970417');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1742,154,'PF','French Polynesia','FP','-145.155143737793','-13.3273630142212');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1743,154,'PG','Papua New Guinea','PP','148.386810302734','-6.50638890266418');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1744,154,'PH','Philippines','RP','121.765930175781','12.2197198867798');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1745,154,'PK','Pakistan','PK','69.3451156616211','30.3753976821899');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1746,154,'PL','Poland','PL','19.1463174819946','51.9147872924805');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1747,154,'PM','St. Pierre and Miquelon','SB','-56.3158340454102','46.9758262634277');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1748,154,'PN','Pitcairn Islands','PC','-129.19465637207','-24.7047462463379');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1749,154,'PR','Puerto Rico','RQ','-66.3311195373535','18.2259712219238');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1750,154,'PT','Portugal','PO','-8.7368936538696','39.3940849304199');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1751,154,'PW','Pacific Islands (Palau)','PS','134.595123291016','7.53916573524475');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1752,154,'PY','Paraguay','PA','-58.4438323974609','-23.4406270980835');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1753,154,'QA','Qatar','QA','51.1747150421143','25.3542699813843');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1754,154,'RE','Reunion','RE','55.5368003845215','-21.1152105331421');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1755,154,'RO','Romania','RO','24.9626779556274','45.950382232666');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1756,154,'RU','Russia','RS','44.5802469135802','57.9135802469136');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1757,154,'RW','Rwanda','RW','29.8803443908691','-1.94440984725952');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1758,154,'SA','Saudi Arabia','SA','45.1191272735596','23.8859424591064');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1759,154,'SB','Solomon Islands','BP','161.294403076172','-9.24284720420837');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1760,154,'SC','Seychelles','SE','50.9040241241455','-7.0073618888855');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1761,154,'SD','Sudan','SU','30.2148971557617','12.8628070354462');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1762,154,'SE','Sweden','SW','17.6401700973511','62.2232246398926');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1763,154,'SG','Singapore','SN','103.818729400635','1.36704808473587');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1764,154,'SH','St. Helena','SH','-5.720139503479','-15.952917098999');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1765,154,'SI','Slovenia','SI','14.995671749115','46.1477699279785');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1766,154,'SJ','Svalbard','SV','22.0627055168152','77.5521469116211');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1767,154,'SK','Slovakia','LO','19.7013864517212','48.6732139587402');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1768,154,'SL','Sierra Leone','SL','-11.7811307907104','8.4622950553894');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1769,154,'SM','San Marino','SM','12.463454246521','43.928316116333');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1770,154,'SN','Senegal','SG','-14.4529190063477','14.4689292907715');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1771,154,'SO','Somalia','SO','46.2013339996338','5.15214896202087');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1772,154,'SR','Suriname','NS','-56.0224342346191','3.95142316818237');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1773,154,'ST','Sao Tome and Principe','TP','6.95916652679443','0.855694361031055');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1774,154,'SV','El Salvador','ES','-88.92333984375','13.7941846847534');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1775,154,'SY','Syria','SY','38.9896240234375','34.802074432373');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1776,154,'SZ','Swaziland','WZ','31.4770803451538','-26.5348634719849');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1777,154,'TC','Turks and Caicos Islands','TK','-71.8375396728516','21.8463859558105');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1778,154,'TD','Chad','CD','18.7338728904724','15.4759364128113');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1779,154,'TF','French Southern & Antarctic Lands','FS','61.1091613769531','-48.0305595397949');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1780,154,'TG','Togo','TO','0.82401867210865','8.61954307556152');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1781,154,'TH','Thailand','TH','101.491199493408','13.0124971866608');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1782,154,'TJ','Tajikistan','TI','71.2816848754883','38.8618698120117');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1783,154,'TK','Tokelau','TL','-171.853454589844','-9.19989681243896');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1784,154,'TM','Turkmenistan','TX','59.5457229614258','38.9710807800293');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1785,154,'TN','Tunisia','TS','9.52999925613403','33.7874011993408');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1786,154,'TO','Tonga','TN','-174.640167236328','-19.918478012085');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1787,154,'TR','Turkey','TU','35.2526321411133','38.9548530578613');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1788,154,'TT','Trinidad and Tobago','TD','-61.2756633758545','10.6708669662476');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1789,154,'TV','Tuvalu','TV','177.763374328613','-7.33036804199219');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1790,154,'TW','Taiwan','TW','120.143768310547','23.6056909561157');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1791,154,'TZ','Tanzania, United Republic of','TZ','34.8923635482788','-6.35935401916504');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1792,154,'UA','Ukraine','UP','31.1595373153687','48.3721446990967');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1793,154,'UG','Uganda','UG','32.3033313751221','1.3802775144577');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1794,154,'UK','United Kingdom','UK','-3.24138927459717','55.3979148864746');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1795,154,'US','United States','US','-92.167366027832','34.7554626464844');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1796,154,'UV','Burkina Faso','UV','-1.56096220016479','12.2822971343994');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1797,154,'UY','Uruguay','UY','-55.7510261535645','-32.5244445800781');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1798,154,'UZ','Uzbekistan','UZ','64.5831508636475','41.3777923583984');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1799,154,'VA','Vatican','VT','12.5977742197725','41.6925181829414');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1800,154,'VC','St. Vincent and the Grenadines','VC','-61.1929206848145','13.2188882827759');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1801,154,'VE','Venezuela','VE','-66.6054592132568','6.42333248257637');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1802,154,'VG','British Virgin Islands','VI','-64.4926834106445','18.4437828063965');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1803,154,'VI','Virgin Islands','VQ','-64.7554931640625','17.7245121002197');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1804,154,'VN','Vietnam','VM','105.802795410156','15.9584693908691');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1805,154,'VU','Vanuatu','NH','168.220779418945','-16.982084274292');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1806,154,'WE','West Bank','WE','35.2226295471191','31.9260025024414');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1807,154,'WF','Wallis and Futuna','WF','-177.17431640625','-13.7693762779236');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1808,154,'WQ','Wake Island','WQ','166.636360168457','19.3037109375');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1809,154,'WS','Western Samoa','WS','-172.11100769043','-13.7708339691162');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1810,154,'YE','Yemen','YM','48.5209693908691','15.5720329284668');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1811,154,'YT','Mayotte','MF','45.1543025970459','-12.8275003433228');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1812,154,'YU','Yugoslavia','YI','20.7302761077881','44.0108871459961');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1813,154,'ZA','South Africa','SF','26.1338882446289','-34.5810680389404');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1814,154,'ZM','Zambia','ZA','27.8512134552002','-13.1335849761963');
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,fips,centroid_x,centroid_y) values(1815,154,'ZW','Zimbabwe','ZI','29.1680126190186','-19.0233182907104');
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1816,29,'SWE021001','Aamaal','SWE021','Vaestra Goetalands laen',58.9566411137997,12.6475743505751);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1817,29,'SWE019007','Aange','SWE019','Vaesternorrlands laen',62.470850338431,15.6733614376744);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1818,29,'SWE006001','Aare','SWE006','Jaemtlands laen',63.5005779266357,13.1939375471322);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1819,29,'SWE018002','Aasele','SWE018','Vaesterbottens laen',64.1987988381924,17.7133847245989);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1820,29,'SWE013001','Aastorp','SWE013','Skaane laen',56.1249999915,12.9674340447302);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1821,29,'SWE012001','Aatvidaberg','SWE012','Oestergoetlands laen',58.2065938145538,16.1259383910236);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1822,29,'SWE009001','Aelmhult','SWE009','Kronobergs laen',56.583333323,14.1586565487137);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1823,29,'SWE002001','Aelvdalen','SWE002','Dalarnas laen',61.6455051281619,13.2387819839031);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1824,29,'SWE010001','Aelvsbyn','SWE010','Norrbottens laen',65.7623944129927,20.733150184932);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1825,29,'SWE021002','Ale','SWE021','Vaestra Goetalands laen',57.9555811405904,12.2171579908058);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1826,29,'SWE021003','Alingsaas','SWE021','Vaestra Goetalands laen',57.9738474369041,12.5232225952945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1827,29,'SWE009002','Alvesta','SWE009','Kronobergs laen',56.8393152759149,14.4758234480798);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1828,29,'SWE007001','Aneby','SWE007','Joenkoepings laen',57.85416665125,14.7990323192642);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1829,29,'SWE023001','Arboga','SWE023','Vaestmanlands laen',59.3608820382895,15.79583331015);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1830,29,'SWE010002','Arjeplog','SWE010','Norrbottens laen',66.3667870937617,17.2047474362587);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1831,29,'SWE010003','Arvidsjaur','SWE010','Norrbottens laen',65.6583332867,19.1965407957334);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1832,29,'SWE017002','Arvika','SWE017','Vaermlands laen',59.7523221226285,12.6799222203187);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1833,29,'SWE011001','Askersund','SWE011','Oerebro laen',58.8310948496535,14.9885714013511);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1834,29,'SWE002002','Avesta','SWE002','Dalarnas laen',60.2208373774604,16.3583333079);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1835,29,'SWE021004','Bengtsfors','SWE021','Vaestra Goetalands laen',58.9994409996962,12.1459031337097);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1836,29,'SWE006004','Haerjedalen','SWE006','Jaemtlands laen',62.1604704387814,13.7410392652652);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1837,29,'SWE018003','Bjurholm','SWE018','Vaesterbottens laen',63.9583332935,18.9709403632862);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1838,29,'SWE013004','Bjuv','SWE013','Skaane laen',56.03644560953,12.9699766676041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1839,29,'SWE010004','Boden','SWE010','Norrbottens laen',66.0482017035162,21.2583332883);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1840,29,'SWE021005','Bollebygd','SWE021','Vaestra Goetalands laen',57.7327762679768,12.5973052527337);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1841,29,'SWE003001','Bollnaes','SWE003','Gaevleborgs laen',61.3131657625768,16.3376701101474);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1842,29,'SWE021006','Boraas','SWE021','Vaestra Goetalands laen',57.7397893120265,12.9648137291889);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1843,29,'SWE002003','Borlaenge','SWE002','Dalarnas laen',60.4606094101927,15.39583331175);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1844,29,'SWE015001','Botkyrka','SWE015','Stockholms laen',59.157092147483,17.8341558932537);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1845,29,'SWE012002','Boxholm','SWE012','Oestergoetlands laen',58.1234090004334,15.1223085834333);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1846,29,'SWE006003','Braecke','SWE006','Jaemtlands laen',62.8499244335944,15.6362123899714);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1847,29,'SWE013005','Bromoella','SWE013','Skaane laen',56.1229207271854,14.4847272057753);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1848,29,'SWE013006','Burloev','SWE013','Skaane laen',55.6209045682596,13.0967470106234);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1849,29,'SWE015002','Danderyd','SWE015','Stockholms laen',59.4067263176652,18.0560607910156);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1850,29,'SWE011002','Degerfors','SWE011','Oerebro laen',59.1416666461,14.4513778508468);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1851,29,'SWE018004','Dorotea','SWE018','Vaesterbottens laen',64.46249995815,15.8226862356611);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1852,29,'SWE015003','Ekeroe','SWE015','Stockholms laen',59.3458261911818,17.6894284258666);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1853,29,'SWE007002','Eksjoe','SWE007','Joenkoepings laen',57.6135452125966,15.2230715224834);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1854,29,'SWE008002','Emmaboda','SWE008','Kalmar laen',56.62916665615,15.55763496719);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1855,29,'SWE022002','Enkoeping','SWE022','Uppsala laen',59.6249999775,17.13749997145);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1856,29,'SWE014001','Eskilstuna','SWE014','Soedermanlands laen',59.3141163931316,16.3578676605223);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1857,29,'SWE013007','Esloev','SWE013','Skaane laen',55.833333326,13.3766413235703);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1858,29,'SWE021008','Essunga','SWE021','Vaestra Goetalands laen',58.178687015349,12.72916665575);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1859,29,'SWE021009','Faergelanda','SWE021','Vaestra Goetalands laen',58.6083333149,12.0236452657498);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1860,29,'SWE023002','Fagersta','SWE023','Vaestmanlands laen',59.9423049689066,15.8971847298292);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1861,29,'SWE021033','Skoevde','SWE021','Vaestra Goetalands laen',58.4108398261066,13.8833333178);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1862,29,'SWE002004','Falun','SWE002','Dalarnas laen',60.7501128880386,15.8213406647843);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1863,29,'SWE017004','Filipstad','SWE017','Vaermlands laen',59.8949854297078,14.12083331685);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1864,29,'SWE012003','Finspaang','SWE012','Oestergoetlands laen',58.7998489187889,15.7999999768);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1865,29,'SWE014002','Flen','SWE014','Soedermanlands laen',59.049715149072,16.7271626521278);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1866,29,'SWE017005','Forshaga','SWE017','Vaermlands laen',59.63920184105,13.5083333193);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1867,29,'SWE010005','Gaellivare','SWE010','Norrbottens laen',67.2017633828227,19.4650580250686);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1868,29,'SWE002005','Gagnef','SWE002','Dalarnas laen',60.4520039618222,14.91249998035);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1869,29,'SWE007003','Gislaved','SWE007','Joenkoepings laen',57.2833333202,13.49320664598);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1870,29,'SWE014003','Gnesta','SWE014','Soedermanlands laen',59.0551299846623,17.1445169798855);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1871,29,'SWE007004','Gnosjoe','SWE007','Joenkoepings laen',57.3474838122937,13.81072424318);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1872,29,'SWE021012','Goetene','SWE021','Vaestra Goetalands laen',58.584979229707,13.4417313755967);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1873,29,'SWE021013','Graestorp','SWE021','Vaestra Goetalands laen',58.3101074046346,12.6400780890084);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1874,29,'SWE017006','Grums','SWE017','Vaermlands laen',59.3967788480418,12.997092044286);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1875,29,'SWE021014','Gullspaang','SWE021','Vaestra Goetalands laen',58.916666647,13.999999984);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1876,29,'SWE022003','Haabo','SWE022','Uppsala laen',59.6174534890862,17.5047362981061);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1877,29,'SWE007005','Habo','SWE007','Joenkoepings laen',57.9648137251889,14.0835381662423);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1878,29,'SWE011003','Haellefors','SWE011','Oerebro laen',59.7384521254837,14.6355338864872);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1879,29,'SWE006002','Berg','SWE006','Jaemtlands laen',62.6875594745271,14.7231849481483);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1880,29,'SWE021015','Haerryda','SWE021','Vaestra Goetalands laen',57.6584050350083,12.31249999075);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1881,29,'SWE013008','Haessleholm','SWE013','Skaane laen',56.17083332465,13.7181130578408);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1882,29,'SWE017007','Hagfors','SWE017','Vaermlands laen',60.0814707194892,13.5868994251462);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1883,29,'SWE011004','Hallsberg','SWE011','Oerebro laen',58.9833333134,15.1253649188703);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1884,29,'SWE023003','Hallstahammar','SWE023','Vaestmanlands laen',59.56249997775,16.2008450577975);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1885,29,'SWE017008','Hammaroe','SWE017','Vaermlands laen',59.2041524043136,13.5477616486101);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1886,29,'SWE022004','Heby','SWE022','Uppsala laen',60.0565180218351,17.0413032250086);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1887,29,'SWE002006','Hedemora','SWE002','Dalarnas laen',60.3779779814868,16.0166666426);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1888,29,'SWE013009','Helsingborg','SWE013','Skaane laen',56.0620491624944,12.7827371219732);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1889,29,'SWE021016','Herrljunga','SWE021','Vaestra Goetalands laen',57.9976104576424,13.0997329587925);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1890,29,'SWE021017','Hjo','SWE021','Vaestra Goetalands laen',58.2601221549973,14.26249998295);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1891,29,'SWE008003','Hoegsby','SWE008','Kalmar laen',57.1065180336351,15.8993585986356);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1892,29,'SWE013011','Hoeoer','SWE013','Skaane laen',55.9212966842093,13.5168412385775);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1893,29,'SWE013012','Hoerby','SWE013','Skaane laen',55.825805148133,13.7512411603287);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1894,29,'SWE003003','Hofors','SWE003','Gaevleborgs laen',60.47916664075,16.3983105721444);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1895,29,'SWE015005','Huddinge','SWE015','Stockholms laen',59.2061960647872,18.02083330125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1896,29,'SWE008004','Hultsfred','SWE008','Kalmar laen',57.38749998645,15.8271626557278);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1897,29,'SWE005003','Hylte','SWE005','Hallands laen',56.9610493859423,13.2538697430473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1898,29,'SWE015006','Jaerfaella','SWE015','Stockholms laen',59.4373234849239,17.8166666354);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1899,29,'SWE007007','Mullsjoe','SWE007','Joenkoepings laen',57.9340779465033,13.8194455311903);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1900,29,'SWE010007','Jokkmokk','SWE010','Norrbottens laen',66.9083363592776,18.6795425825655);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1901,29,'SWE021018','Karlsborg','SWE021','Vaestra Goetalands laen',58.57916664835,14.5105716524899);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1902,29,'SWE011005','Karlskoga','SWE011','Oerebro laen',59.37770536179,14.5550610677986);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1903,29,'SWE017009','Karlstad','SWE017','Vaermlands laen',59.4749999781,13.5842703358013);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1904,29,'SWE014004','Katrineholm','SWE014','Soedermanlands laen',59.0046269534515,16.190200272277);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1905,29,'SWE017010','Kil','SWE017','Vaermlands laen',59.56249997775,13.1768151474083);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1906,29,'SWE012004','Kinda','SWE012','Oestergoetlands laen',57.9916666507,15.7226862360611);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1907,29,'SWE013014','Klippan','SWE013','Skaane laen',56.10416665825,13.2481848268917);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1908,29,'SWE023004','Koeping','SWE023','Vaestmanlands laen',59.5690180237851,15.8717668934237);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1909,29,'SWE017011','Kristinehamn','SWE017','Vaermlands laen',59.24583331235,13.9641621748986);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1910,29,'SWE006005','Krokom','SWE006','Jaemtlands laen',63.8022168085288,14.1898993752858);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1911,29,'SWE011012','Oerebro','SWE011','Oerebro laen',59.2323231805681,15.277888467658);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1912,29,'SWE023005','Kungsoer','SWE023','Vaestmanlands laen',59.4072255236185,16.0840377564256);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1913,29,'SWE005005','Laholm','SWE005','Hallands laen',56.49583332335,13.1856395094208);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1914,29,'SWE011007','Laxaa','SWE011','Oerebro laen',58.8916290087538,14.5299026308062);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1915,29,'SWE011008','Lekeberg','SWE011','Oerebro laen',59.1696070146406,14.7983761913371);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1916,29,'SWE002012','Raettvik','SWE002','Dalarnas laen',61.1993006100374,15.3084777619692);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1917,29,'SWE021020','Lerum','SWE021','Vaestra Goetalands laen',57.8416666513,12.3166666574);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1918,29,'SWE009003','Lessebo','SWE009','Kronobergs laen',56.7416666557,15.3075396007588);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1919,29,'SWE015007','Lidingoe','SWE015','Stockholms laen',59.3675231933594,18.1903667449951);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1920,29,'SWE021021','Lidkoeping','SWE021','Vaestra Goetalands laen',58.5589777446222,13.0333333212);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1921,29,'SWE021022','Lilla Edet','SWE021','Vaestra Goetalands laen',58.1499999834,12.17916665795);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1922,29,'SWE011009','Lindesberg','SWE011','Oerebro laen',59.6643579892241,15.3189488516083);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1923,29,'SWE012005','Linkoeping','SWE012','Oestergoetlands laen',58.3464685901988,15.6524271421038);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1924,29,'SWE009004','Ljungby','SWE009','Kronobergs laen',56.8161366667953,13.795736679153);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1925,29,'SWE003005','Ljusdal','SWE003','Gaevleborgs laen',61.9069879851364,15.5249999779);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1926,29,'SWE011010','Ljusnarsberg','SWE011','Oerebro laen',59.9310948452535,14.9832951664275);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1927,29,'SWE013017','Lomma','SWE013','Skaane laen',55.6908030124425,13.0659709549862);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1928,29,'SWE002008','Ludvika','SWE002','Dalarnas laen',60.1999999752,14.6932049881445);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1929,29,'SWE013018','Lund','SWE013','Skaane laen',55.6440658503573,13.3685949826601);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1930,29,'SWE018005','Lycksele','SWE018','Vaesterbottens laen',64.6499999574,18.4029093088363);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1931,29,'SWE018006','Malaa','SWE018','Vaesterbottens laen',65.25416662165,18.78749996485);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1932,29,'SWE002009','Malung','SWE002','Dalarnas laen',60.8411516551712,13.3493420838458);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1933,29,'SWE021024','Mariestad','SWE021','Vaestra Goetalands laen',58.781824728594,13.7343145856894);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1934,29,'SWE021025','Mark','SWE021','Vaestra Goetalands laen',57.4471710067191,12.61249998955);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1935,29,'SWE009005','Markaryd','SWE009','Kronobergs laen',56.5311213074211,13.6122929746459);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1936,29,'SWE021026','Mellerud','SWE021','Vaestra Goetalands laen',58.6718424292293,12.52083332325);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1937,29,'SWE012006','Mjoelby','SWE012','Oestergoetlands laen',58.294223005284,15.1017394815462);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1938,29,'SWE021027','Moelndal','SWE021','Vaestra Goetalands laen',57.6015645200989,12.1142883851993);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1939,29,'SWE002007','Leksand','SWE002','Dalarnas laen',60.7344965347482,14.99999998);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1940,29,'SWE012007','Motala','SWE012','Oestergoetlands laen',58.6338449928578,15.0945032551754);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1941,29,'SWE007006','Joenkoeping','SWE007','Joenkoepings laen',57.8543151701296,14.15246478645);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1942,29,'SWE021028','Munkedal','SWE021','Vaestra Goetalands laen',58.6058783117131,11.6686517648708);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1943,29,'SWE017012','Munkfors','SWE017','Vaermlands laen',59.8039860811135,13.4938771426);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1944,29,'SWE007008','Naessjoe','SWE007','Joenkoepings laen',57.5976862445611,14.6422350379903);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1945,29,'SWE011011','Nora','SWE011','Oerebro laen',59.5357589500249,14.8925666613379);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1946,29,'SWE023006','Norberg','SWE023','Vaestmanlands laen',60.0499999758,15.9383531968683);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1947,29,'SWE018008','Norsjoe','SWE018','Vaesterbottens laen',64.9271626353278,19.4861510851023);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1948,29,'SWE008008','Nybro','SWE008','Kalmar laen',56.8278549081222,15.8749999765);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1949,29,'SWE015010','Nykvarn','SWE015','Stockholms laen',59.1927330887065,17.3813024505004);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1950,29,'SWE003007','Ockelbo','SWE003','Gaevleborgs laen',60.9180424731416,16.5433685041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1951,29,'SWE012009','Oedeshoeg','SWE012','Oestergoetlands laen',58.2105717808465,14.6656608394917);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1952,29,'SWE011006','Kumla','SWE011','Oerebro laen',59.108490987053,15.13749997945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1953,29,'SWE013020','Oerkelljunga','SWE013','Skaane laen',56.2991399037266,13.3491678739731);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1954,29,'SWE006006','Oestersund','SWE006','Jaemtlands laen',63.12916663015,14.9042134406696);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1955,29,'SWE013021','Oestra Goeinge','SWE013','Skaane laen',56.2789779571927,14.148597319221);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1956,29,'SWE010011','Oeverkalix','SWE010','Norrbottens laen',66.4881325540107,22.6024733992971);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1957,29,'SWE001003','Olofstroem','SWE001','Blekinge laen',56.3166666574,14.5650487081395);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1958,29,'SWE002011','Orsa','SWE002','Dalarnas laen',61.317756623561,14.6968162348748);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1959,29,'SWE013022','Osby','SWE013','Skaane laen',56.3977615260535,14.10416665025);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1960,29,'SWE003008','Ovanaaker','SWE003','Gaevleborgs laen',61.3125348116516,15.7283480097201);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1961,29,'SWE014006','Oxeloesund','SWE014','Soedermanlands laen',58.6783358284373,17.0848779678345);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1962,29,'SWE021031','Partille','SWE021','Vaestra Goetalands laen',57.72083331845,12.1263098949575);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1963,29,'SWE013023','Perstorp','SWE013','Skaane laen',56.1716684890347,13.3679646675177);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1964,29,'SWE002010','Mora','SWE002','Dalarnas laen',61.13749997145,14.2749999829);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1965,29,'SWE006007','Ragunda','SWE006','Jaemtlands laen',63.1583332967,16.1023137166389);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1966,29,'SWE017013','Saeffle','SWE017','Vaermlands laen',59.0773167724967,12.9961481610297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1967,29,'SWE002013','Saeter','SWE002','Dalarnas laen',60.40416664105,15.67083331065);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1968,29,'SWE007009','Saevsjoe','SWE007','Joenkoepings laen',57.3095799631614,14.5913047606875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1969,29,'SWE023007','Sala','SWE023','Vaestmanlands laen',59.9714024622798,16.4585596462035);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1970,29,'SWE015013','Salem','SWE015','Stockholms laen',59.2327976120948,17.6772857358924);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1971,29,'SWE003009','Sandviken','SWE003','Gaevleborgs laen',60.483567275498,16.5811327353128);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1972,29,'SWE015014','Sigtuna','SWE015','Stockholms laen',59.6437845640134,17.8606155081083);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1973,29,'SWE013025','Sjoebo','SWE013','Skaane laen',55.6270370418317,13.7559062807527);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1974,29,'SWE021032','Skara','SWE021','Vaestra Goetalands laen',58.37083331585,13.4630616367418);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1975,29,'SWE023008','Skinnskatteberg','SWE023','Vaestmanlands laen',59.7866210706035,15.7083333105);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1976,29,'SWE021010','Falkoeping','SWE021','Vaestra Goetalands laen',58.1667307369138,13.5248476523231);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1977,29,'SWE013026','Skurup','SWE013','Skaane laen',55.4753060627439,13.5566938893784);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1978,29,'SWE002014','Smedjebacken','SWE002','Dalarnas laen',60.0652236695868,15.45416664485);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1979,29,'SWE019003','Oernskoeldsvik','SWE019','Vaesternorrlands laen',63.4830578922074,18.2508804813332);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1980,29,'SWE015016','Sollentuna','SWE015','Stockholms laen',59.4363820176425,17.9222546738843);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1981,29,'SWE015017','Solna','SWE015','Stockholms laen',59.3632154993901,18.0100714206475);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1982,29,'SWE018011','Sorsele','SWE018','Vaesterbottens laen',65.6949526248179,16.6586217396447);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1983,29,'SWE013027','Staffanstorp','SWE013','Skaane laen',55.63749999345,13.2335377881726);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1984,29,'SWE015019','Sundbyberg','SWE015','Stockholms laen',59.37083331185,17.9569638251871);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1985,29,'SWE017014','Storfors','SWE017','Vaermlands laen',59.455995665025,14.238017001684);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1986,29,'SWE018012','Storuman','SWE018','Vaesterbottens laen',65.4394091073582,16.2311579227227);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1987,29,'SWE014007','Straengnaes','SWE014','Soedermanlands laen',59.3471379384096,17.062235486074);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1988,29,'SWE006008','Stroemsund','SWE006','Jaemtlands laen',64.2318893245714,15.1769897644496);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1989,29,'SWE015018','Stockholm','SWE015','Stockholms laen',59.3306065664054,17.98749996805);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1990,29,'SWE017015','Sunne','SWE017','Vaermlands laen',59.87916664315,12.98472072679);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1991,29,'SWE023009','Surahammar','SWE023','Vaestmanlands laen',59.77083331025,16.1236976378587);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1992,29,'SWE013028','Svaloev','SWE013','Skaane laen',55.94583332555,13.1385628892605);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1993,29,'SWE013029','Svedala','SWE013','Skaane laen',55.5284500060932,13.2833333202);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1994,29,'SWE021037','Svenljunga','SWE021','Vaestra Goetalands laen',57.4004023098033,13.04583332115);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1995,29,'SWE015020','Taeby','SWE015','Stockholms laen',59.4575413803508,18.064503017996);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1996,29,'SWE021039','Tibro','SWE021','Vaestra Goetalands laen',58.4467101872913,14.2183949619676);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1997,29,'SWE021040','Tidaholm','SWE021','Vaestra Goetalands laen',58.1333333168,13.9336598556846);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1998,29,'SWE009006','Tingsryd','SWE009','Kronobergs laen',56.529690541639,14.9820177514749);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(1999,29,'SWE021042','Toereboda','SWE021','Vaestra Goetalands laen',58.66420184495,14.1627879929924);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2000,29,'SWE013030','Tomelilla','SWE013','Skaane laen',55.6147633805852,14.0143151440583);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2001,29,'SWE007010','Tranaas','SWE007','Joenkoepings laen',58.0271082399137,14.8349972849406);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2002,29,'SWE021043','Tranemo','SWE021','Vaestra Goetalands laen',57.4894119123119,13.4277644973973);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2003,29,'SWE021044','Trollhaettan','SWE021','Vaestra Goetalands laen',58.2088460118104,12.3567666277393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2004,29,'SWE015024','Vaermdoe','SWE015','Stockholms laen',59.2763500213623,18.6685934066772);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2005,29,'SWE021046','Ulricehamn','SWE021','Vaestra Goetalands laen',57.8034189707889,13.4492086908337);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2006,29,'SWE015022','Upplands-Bro','SWE015','Stockholms laen',59.52916664455,17.6471847228292);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2007,29,'SWE015023','Upplands-Vaesby','SWE015','Stockholms laen',59.5083333113,17.9083333017);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2008,29,'SWE009007','Uppvidinge','SWE009','Kronobergs laen',57.0258646526101,15.4519284348166);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2009,29,'SWE021047','Vaargaarda','SWE021','Vaestra Goetalands laen',57.9789586225933,12.7537846772987);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2010,29,'SWE012011','Vadstena','SWE012','Oestergoetlands laen',58.4206207098566,14.7669217236895);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2011,29,'SWE021048','Vaenersborg','SWE021','Vaestra Goetalands laen',58.4374414902255,12.4024229589369);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2012,29,'SWE018014','Vaennaes','SWE018','Vaesterbottens laen',63.9314048369834,19.7060948301535);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2013,29,'SWE007011','Vaernamo','SWE007','Joenkoepings laen',57.12083332085,14.0428310232574);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2014,29,'SWE023010','Vaesteraas','SWE023','Vaestmanlands laen',59.6410384906194,16.5983011617578);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2015,29,'SWE009008','Vaexjoe','SWE009','Kronobergs laen',56.9093251429851,14.8497883920592);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2016,29,'SWE007012','Vaggeryd','SWE007','Joenkoepings laen',57.4653467675514,14.1333333168);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2017,29,'SWE015025','Vallentuna','SWE015','Stockholms laen',59.5749999777,18.2050223975998);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2018,29,'SWE002015','Vansbro','SWE002','Dalarnas laen',60.453071568426,14.2672983634647);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2019,29,'SWE021049','Vara','SWE021','Vaestra Goetalands laen',58.2399708896156,13.0938672259872);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2020,29,'SWE007013','Vetlanda','SWE007','Joenkoepings laen',57.3523513659851,15.2121556391449);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2021,29,'SWE018015','Vilhelmina','SWE018','Vaesterbottens laen',64.8950146653061,16.0202914083976);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2022,29,'SWE008012','Vimmerby','SWE008','Kalmar laen',57.6675231786893,15.8659169280337);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2023,29,'SWE018016','Vindeln','SWE018','Vaesterbottens laen',64.39583329175,19.5552728906526);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2024,29,'SWE014009','Vingaaker','SWE014','Soedermanlands laen',59.0565180258351,15.8919143441081);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2025,29,'SWE012013','Ydre','SWE012','Oestergoetlands laen',57.8573521777672,15.2691896863614);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2026,29,'SWE010009','Kiruna','SWE010','Norrbottens laen',68.21041663995,20.5367136001587);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2027,29,'SWE017016','Torsby','SWE017','Vaermlands laen',60.5453547039313,12.9143961516375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2028,29,'SWE017003','Eda','SWE017','Vaermlands laen',59.8060362818078,12.171916416264);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2029,29,'SWE017001','Aarjaeng','SWE017','Vaermlands laen',59.4428874866122,12.0997319171497);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2030,29,'SWE021007','Dals-Ed','SWE021','Vaestra Goetalands laen',58.9919003709691,11.8945015618125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2031,29,'SWE021038','Tanum','SWE021','Vaestra Goetalands laen',58.6944500956537,11.421981394822);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2032,29,'SWE021036','Stroemstad','SWE021','Vaestra Goetalands laen',58.9657001495361,11.2292680740356);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2033,29,'SWE021034','Sotenaes','SWE021','Vaestra Goetalands laen',58.4069718588959,11.3400213530135);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2034,29,'SWE021045','Uddevalla','SWE021','Vaestra Goetalands laen',58.2911300487534,11.835702033508);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2035,29,'SWE021030','Orust','SWE021','Vaestra Goetalands laen',58.1789531707764,11.6026268005371);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2036,29,'SWE021035','Stenungsund','SWE021','Vaestra Goetalands laen',58.0475105206711,11.9214881220356);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2037,29,'SWE021023','Lysekil','SWE021','Vaestra Goetalands laen',58.3395726432066,11.481858253479);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2038,29,'SWE021019','Kungaelv','SWE021','Vaestra Goetalands laen',57.9029285350408,11.8432679133831);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2039,29,'SWE005006','Varberg','SWE005','Hallands laen',57.1635569128015,12.4244928304985);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2040,29,'SWE005004','Kungsbacka','SWE005','Hallands laen',57.4396626652778,12.1616447400473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2041,29,'SWE005001','Falkenberg','SWE005','Hallands laen',57.0372994674971,12.7210743206498);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2042,29,'SWE005002','Halmstad','SWE005','Hallands laen',56.7350779106092,12.9680697374673);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2043,29,'SWE013003','Baastad','SWE013','Skaane laen',56.3904451959777,12.7527039150739);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2044,29,'SWE013002','Aengelholm','SWE013','Skaane laen',56.23749999105,12.977682854131);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2045,29,'SWE013010','Hoeganaes','SWE013','Skaane laen',56.2145500183105,12.6099028587341);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2046,29,'SWE013016','Landskrona','SWE013','Skaane laen',55.8948112451595,12.8641514399079);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2047,29,'SWE013013','Kaevlinge','SWE013','Skaane laen',55.7849140167236,13.0601284280658);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2048,29,'SWE013019','Malmoe','SWE013','Skaane laen',55.5683601349484,13.0214111900933);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2049,29,'SWE013032','Vellinge','SWE013','Skaane laen',55.4457854729194,12.9938968594947);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2050,29,'SWE013031','Trelleborg','SWE013','Skaane laen',55.4143952657748,13.2456407546997);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2051,29,'SWE013033','Ystad','SWE013','Skaane laen',55.4669457722363,13.9205576900713);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2052,29,'SWE013024','Simrishamn','SWE013','Skaane laen',55.5760821725977,14.2128264345924);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2053,29,'SWE013015','Kristianstad','SWE013','Skaane laen',56.0166666586,14.113407159309);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2054,29,'SWE001005','Soelvesborg','SWE001','Blekinge laen',56.0952354387152,14.7035293579102);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2055,29,'SWE001001','Karlshamn','SWE001','Blekinge laen',56.2406959486191,14.8569554452532);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2056,29,'SWE001002','Karlskrona','SWE001','Blekinge laen',56.2518560995506,15.685494857368);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2057,29,'SWE001004','Ronneby','SWE001','Blekinge laen',56.3007261862259,15.2264294207771);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2058,29,'SWE008010','Torsaas','SWE008','Kalmar laen',56.4020802719672,15.911438358401);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2059,29,'SWE008005','Kalmar','SWE008','Kalmar laen',56.6918271324316,16.1155766054371);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2060,29,'SWE008009','Oskarshamn','SWE008','Kalmar laen',57.3482447244059,16.3594963589775);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2061,29,'SWE008001','Borgholm','SWE008','Kalmar laen',57.0146026611328,16.8433475494385);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2062,29,'SWE012012','Valdemarsvik','SWE012','Oestergoetlands laen',58.1806779138044,16.6415619407179);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2063,29,'SWE014005','Nykoeping','SWE014','Soedermanlands laen',58.8131905773283,16.8954936855701);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2064,29,'SWE010013','Pajala','SWE010','Norrbottens laen',67.4057009125904,22.8720036587534);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2065,29,'SWE010012','Oevertorneaa','SWE010','Norrbottens laen',66.5120500699876,23.5327705122301);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2066,29,'SWE010008','Kalix','SWE010','Norrbottens laen',65.9383128875077,22.9580647539625);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2067,29,'SWE010010','Luleaa','SWE010','Norrbottens laen',65.8218729409281,22.0808760734063);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2068,29,'SWE010006','Haparanda','SWE010','Norrbottens laen',65.866455078125,23.7542389284895);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2069,29,'SWE018010','Skellefteaa','SWE018','Vaesterbottens laen',64.8306360652867,20.486973616639);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2070,29,'SWE010014','Piteaa','SWE010','Norrbottens laen',65.3679076915437,20.796081587277);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2071,29,'SWE018009','Robertsfors','SWE018','Vaesterbottens laen',64.1515472203363,20.7603058290944);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2072,29,'SWE018013','Umeaa','SWE018','Vaesterbottens laen',63.9304113816178,20.3416666473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2073,29,'SWE018007','Nordmaling','SWE018','Vaesterbottens laen',63.6409119726576,19.2906297507716);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2074,29,'SWE019002','Kramfors','SWE019','Vaesternorrlands laen',62.9686140512541,17.8909193531138);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2075,29,'SWE019004','Sollefteaa','SWE019','Vaesternorrlands laen',63.43749996225,16.9190760017833);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2076,29,'SWE019006','Timraa','SWE019','Vaesternorrlands laen',62.6233118515867,17.3559875985126);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2077,29,'SWE019005','Sundsvall','SWE019','Vaesternorrlands laen',62.5417256494344,17.0109683229362);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2078,29,'SWE019001','Haernoesand','SWE019','Vaesternorrlands laen',62.6897842229227,17.6791510120412);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2079,29,'SWE003004','Hudiksvall','SWE003','Gaevleborgs laen',61.8164081409117,16.818694611156);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2080,29,'SWE003010','Soederhamn','SWE003','Gaevleborgs laen',61.282090730149,16.9503702668313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2081,29,'SWE003006','Nordanstig','SWE003','Gaevleborgs laen',62.0360503828949,16.7951187012789);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2082,29,'SWE003002','Gaevle','SWE003','Gaevleborgs laen',60.6534863664732,17.1163421495438);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2083,29,'SWE022001','Aelvkarleby','SWE022','Uppsala laen',60.5525937269441,17.4836219005981);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2084,29,'SWE022007','Tierp','SWE022','Uppsala laen',60.3438744741161,17.6498035287239);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2085,29,'SWE022006','Oesthammar','SWE022','Uppsala laen',60.2726281363716,18.2072450483579);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2086,29,'SWE015012','Oesteraaker','SWE015','Stockholms laen',59.5097160339355,18.5090581095305);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2087,29,'SWE015009','Norrtaelje','SWE015','Stockholms laen',59.8899778890705,18.6494919932975);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2088,29,'SWE015021','Tyresoe','SWE015','Stockholms laen',59.2102273202264,18.302210600712);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2089,29,'SWE015008','Nacka','SWE015','Stockholms laen',59.3021249030502,18.2466288086321);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2090,29,'SWE015026','Vaxholm','SWE015','Stockholms laen',59.4049453735352,18.3078241348267);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2091,29,'SWE015004','Haninge','SWE015','Stockholms laen',59.03290060909,18.2585410277606);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2092,29,'SWE015011','Nynaeshamn','SWE015','Stockholms laen',58.9241827544725,17.8993711471558);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2093,29,'SWE015015','Soedertaelje','SWE015','Stockholms laen',59.0905129643736,17.5222902787537);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2094,29,'SWE014008','Trosa','SWE014','Soedermanlands laen',58.8895667930171,17.5364777735804);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2095,29,'SWE012008','Norrkoeping','SWE012','Oestergoetlands laen',58.6249999815,16.3114055521248);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2096,29,'SWE008006','Moensteraas','SWE008','Kalmar laen',57.0559692260574,16.3863588846482);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2097,29,'SWE012010','Soederkoeping','SWE012','Oestergoetlands laen',58.3861338207261,16.4963837185538);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2098,29,'SWE008011','Vaestervik','SWE008','Kalmar laen',57.8176320241175,16.4053305824197);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2099,29,'SWE008007','Moerbylaanga','SWE008','Kalmar laen',56.4759941101074,16.5528402328491);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2100,29,'SWE004000','Gotland','SWE004','Gotlands laen',57.6474933624268,18.6623430252075);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2101,29,'SWE021041','Tjoern','SWE021','Vaestra Goetalands laen',58.0118942260742,11.6378211975098);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2102,29,'SWE021011','Goeteborg','SWE021','Vaestra Goetalands laen',57.7083333185,11.9765939031954);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2103,29,'SWE021029','Oeckeroe','SWE021','Vaestra Goetalands laen',57.7371387481689,11.6571040153503);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2104,29,'SWE022005','Knivsta','SWE022','Uppsala laen',59.7405053000541,17.8797836700496);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,adm1_code,adm1_name,centroid_x,centroid_y) values(2105,29,'SWE022008','Uppsala','SWE022','Uppsala laen',59.949634799501,17.7776041355563);
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,object_id,centroid_x,centroid_y) values(2106,159,26653,151.0109409,-33.88055);
insert into wwv_flow_flash_map_regions(id,file_id,object_id,centroid_x,centroid_y) values(2107,159,26666,151.2169037,-33.5482636);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2108,160,'AK','Alaska',02,'Pacific',550043,1,415492,25601,20280,-151.777777777778,65.676268861454);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2109,160,'AL','Alabama',01,'E S Cen',4040587,78,2975797,138220,224307,-86.683483899971,32.6248189553488);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2110,160,'AR','Arkansas',05,'W S Cen',2350725,44,1944744,80266,131542,-92.1313681482295,34.751481339065);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2111,160,'AZ','Arizona',04,'Mtn',3665228,32,2963186,148181,250597,-111.788751714678,34.2030178326475);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2112,160,'CA','California',06,'Pacific',29760021,189,20524327,1070030,555307,-119.821673525377,35.8710562414266);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2113,160,'CO','Colorado',08,'Mtn',3294394,32,2905474,154874,88683,-105.546534361717,38.9961845178978);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2114,160,'CT','Connecticut',09,'N Eng',3287116,661,2859353,117261,12118,-72.5459533607682,41.6652949245542);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2115,160,'DC','District of Columbia',11,'S Atl',606900,9187,179667,43471,82,-77.0166164971011,38.8908875514914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2116,160,'DE','Delaware',10,'S Atl',666168,324,535094,23575,34944,-75.4183587944153,39.1448606012954);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2117,160,'FL','Florida',12,'S Atl',12937926,232,10749285,518400,762855,-81.5884773662551,28.0137174211248);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2118,160,'GA','Georgia',13,'S Atl',6478216,110,4600148,220086,305055,-83.2518568978828,32.6808292711285);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2119,160,'HI','Hawaii',15,'Pacific',1108229,174,369616,34537,389,-157.023319615912,20.39780521262);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2120,160,'IA','Iowa',19,'W N Cen',2776755,49,2683090,102744,56857,-93.7037037037037,42.1920438957476);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2121,160,'ID','Idaho',16,'Mtn',1006749,12,950451,35197,56529,-114.159122085048,43.3772290809328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2122,160,'IL','Illinois',17,'E N Cen',11430602,203,8952978,436138,150733,-89.5336076817558,40.1289437585734);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2123,160,'IN','Indiana',18,'E N Cen',5544159,152,5020700,193625,156821,-86.4444680326911,39.7708822940655);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2124,160,'KS','Kansas',20,'W N Cen',2477574,30,2231986,97991,71195,-98.3263799529049,38.4959318052315);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2125,160,'KY','Kentucky',21,'E S Cen',3685296,91,3391832,121536,185336,-85.363511659808,37.2757201646091);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2126,160,'LA','Louisiana',22,'W S Cen',4219973,92,2839138,150145,196236,-91.9917695473251,30.4279835390946);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2127,160,'MA','Massachusetts',25,'N Eng',6016425,736,5405374,219467,23928,-71.7997256515775,42.3676268861454);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2128,160,'MD','Maryland',24,'S Atl',4781468,491,3393964,160842,42729,-76.8477366255144,39.2949245541838);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2129,160,'ME','Maine',23,'N Eng',1227928,38,1208360,42075,54532,-69.0283901416762,45.2721925321905);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2130,160,'MI','Michigan',26,'E N Cen',9295297,161,7756086,332611,246365,-84.5733882030178,42.9821673525377);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2131,160,'MN','Minnesota',27,'W N Cen',4375099,52,4130395,167013,90864,-94.4938271604938,47.0644718792867);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2132,160,'MO','Missouri',29,'W N Cen',5117073,73,4486228,195654,164021,-92.4362567253026,38.2997203970396);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2133,160,'MS','Mississippi',28,'E S Cen',2573216,54,1633461,83768,136948,-89.8670755505678,32.5999884243719);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2134,160,'MT','Montana',30,'Mtn',799065,5,741111,36000,54021,-109.550068587106,47.0205761316872);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2135,160,'NC','North Carolina',37,'S Atl',6628637,135,5008491,237768,430440,-79.8326474622771,35.7393689986283);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2136,160,'ND','North Dakota',38,'W N Cen',638800,9,604142,27313,27055,-100.307461048358,47.4654244503963);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2137,160,'NE','Nebraska',31,'W N Cen',1578385,20,1480558,63686,37046,-99.6824582951075,41.4978286942191);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2138,160,'NH','New Hampshire',33,'N Eng',1109252,120,1087433,38035,35334,-71.5363511659808,43.3772290809328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2139,160,'NJ','New Jersey',34,'Mid Atl',7730188,1030,6130465,251072,33551,-74.3456790123457,40.0411522633745);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2140,160,'NM','New Mexico',35,'Mtn',1515069,12,1146028,56559,102948,-106.082304526749,34.5980795610425);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2141,160,'NV','Nevada',32,'Mtn',1201833,11,1012695,64273,69655,-116.968449931413,39.5144032921811);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2142,160,'NY','New York',36,'Mid Atl',17990455,370,13385255,708225,194934,-75.8166108434143,42.7560710425768);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2143,160,'OH','Ohio',39,'E N Cen',10847115,263,9521756,399701,205595,-82.6660333841682,40.1936915441621);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2144,160,'OK','Oklahoma',40,'W S Cen',3145585,45,2583512,121776,129850,-97.2153635116598,35.4759945130316);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2145,160,'OR','Oregon',41,'Pacific',2842321,29,2636787,116232,134325,-120.831275720165,43.9917695473251);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2146,160,'PA','Pennsylvania',42,'Mid Atl',11881643,262,10520201,429925,254920,-77.9012345679012,40.9190672153635);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2147,160,'RI','Rhode Island',44,'N Eng',1003464,960,917375,37509,4689,-71.4919055791828,41.6682414823939);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2148,160,'SC','South Carolina',45,'S Atl',3486703,113,2406974,115632,240525,-80.96506932337,33.6382651711786);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2149,160,'SD','South Dakota',46,'W N Cen',696004,9,637515,27680,31357,-100.250215445865,44.2160032678824);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2150,160,'TN','Tennessee',47,'E S Cen',4877185,116,4048068,170671,188517,-86.7681755829904,35.8271604938272);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2151,160,'TX','Texas',48,'W S Cen',16986510,64,12774762,643106,547911,-99.3662551440329,31.3936899862826);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2152,160,'UT','Utah',49,'Mtn',1722850,20,1615845,43134,34986,-111.545239703911,39.4970234444281);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2153,160,'VA','Virginia',51,'S Atl',6187358,155,4791739,215763,159352,-78.9986282578875,37.2318244170096);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2154,160,'VT','Vermont',50,'N Eng',562758,59,555088,20009,22702,-72.4706865059539,43.869602122704);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2155,160,'WA','Washington',53,'Pacific',4866692,72,4308937,212023,187533,-120.041152263374,47.4595336076818);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2156,160,'WI','Wisconsin',55,'E N Cen',4891769,87,4512523,177750,101149,-89.9265548152997,44.7208161864179);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2157,160,'WV','West Virginia',54,'S Atl',1793477,74,1725523,59990,118733,-80.798353909465,38.5486968449931);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,state_fips,sub_region,pop1990,pop90_sqmi,white,hshold_1_m,mobilehome,centroid_x,centroid_y) values(2158,160,'WY','Wyoming',56,'Mtn',453588,5,427061,19671,33474,-107.552567082851,42.9985410346349);
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2159,156,'AS01','Australian Capital Territory','AUS-ACT',149.087066650391,-35.5412521362305);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2160,156,'AS02','New South Wales','AUS-NSW',150.049880981445,-32.831392288208);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2161,156,'AS03','Northern Territory','AUS-NTR',133.500396728516,-18.5113401412964);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2162,156,'AS04','Queensland','AUS-QNS',145.77165222168,-19.61097240448);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2163,156,'AS05','South Australia','AUS-SAS',135.001327514648,-32.0366668701172);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2164,156,'AS06','Tasmania','AUS-TSM',151.398986816406,-47.0929183959961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2165,156,'AS07','Victoria','AUS-VCT',145.472198486328,-36.5675048828125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2166,156,'AS08','Western Australia','AUS-WAS',120.956550598145,-24.4325141906738);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2167,157,'NZ','Canterbury','NZL-CNT',0.234832763671875,-39.4745807647705);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2168,157,'NZ31','Hawke''s Bay','NZL-HBA',177.046745300293,-39.4534187316895);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2169,157,'NZ72','Southland','NZL-STH',167.563034057617,-48.4147300720215);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2170,157,'NZ76','Taranaki','NZL-TRN',174.386375427246,-39.2722206115723);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2171,157,'NZ85','Waikato','NZL-WAK',175.516960144043,-37.8598155975342);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2172,157,'NZB3','Westland','NZL-WST',170.46549987793,-42.6150550842285);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2173,158,'PP','West Sepik','PNG-WSE',142.037826538086,-3.9470841884613);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2174,158,'PP01','Central','PNG-CNT',148.021583557129,-9.03687739372253);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2175,158,'PP02','Gulf','PNG-GUL',144.848045349121,7.63071966171265);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2176,158,'PP03','Milne Bay','PNG-MBA',151.635879516602,-10.03125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2177,158,'PP04','Northern','PNG-NRT',148.237808227539,-8.95560193061829);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2178,158,'PP05','Southern Highlands','PNG-SHG',143.387046813965,-5.84377837181091);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2179,158,'PP06','Western','PNG-WST',142.408432006836,-7.12013864517212);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2180,158,'PP07','Northern Solomons','PNG-NSL',156.824829101563,-5.15416669845581);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2181,158,'PP08','Chimbu','PNG-CHM',144.891845703125,-6.26719546318054);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2182,158,'PP09','Eastern Highlands','PNG-EHG',145.56615447998,-6.4885950088501);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2183,158,'PP10','East New Britain','PNG-ENB',151.495964050293,-5.14291715621948);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2184,158,'PP11','East Sepik','PNG-ESE',142.986228942871,-4.23099303245544);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2185,158,'PP12','Madang','PNG-MDN',145.60082244873,-5.00688791275024);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2186,158,'PP13','Manus','PNG-MAN',145.345657348633,-1.72541666030884);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2187,158,'PP14','Morobe','PNG-MOR',146.975120544434,-6.64208221435547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2188,158,'PP15','New Ireland','PNG-NIR',151.599990844727,-3.08930575847626);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2189,158,'PP16','Western Highlands','PNG-WHG',144.405052185059,-5.766033411026);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2190,158,'PP17','West New Britain','PNG-WNB',150.027435302734,-5.48527812957764);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2191,158,'PP19','Enga','PNG-ENG',143.50830078125,-5.43811392784119);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2192,158,'PP20','National Capital','PNG-NCP',147.187103271484,-9.424889087677);
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2193,37,'DZA-ADF','Ain Defla',2.13920199871063,36.1502742767334);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2194,37,'DZA-ADR','Adrar',-0.866284966468811,25.2780389785767);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2195,37,'DZA-ALG','Alger',3.02638792991638,36.7707176208496);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2196,37,'DZA-ANN','Annaba',7.52152347564697,36.8531246185303);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2197,37,'DZA-ATM','Ain Temouchent',-0.99148091673851,35.3606376647949);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2198,37,'DZA-BAT','Batna',5.74919152259827,35.4644947052002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2199,37,'DZA-BBA','Bourdj Bou Arrer',4.68342971801758,36.0866718292236);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2200,37,'DZA-BCH','Bechar',-2.69815728068352,30.2385597229004);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2201,37,'DZA-BEJ','Bejaia',4.93695497512817,36.5575160980225);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2202,37,'DZA-BLI','Blida',3.01770377159119,36.5332851409912);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2203,37,'DZA-BMR','Boumerdes',3.59099102020264,36.7275009155273);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2204,37,'DZA-BOU','Bouira',3.83458137512207,36.272439956665);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2205,37,'DZA-BSK','Biskra',5.39415407180786,34.3430099487305);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2206,37,'DZA-CHL','Chlef',1.2236670255661,36.199577331543);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2207,37,'DZA-CNS','Constantine',6.66516304016113,36.3408050537109);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2208,37,'DZA-DJL','Djelfa',3.64698660373688,34.3101043701172);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2209,37,'DZA-EBY','El Bayadh',0.968424096703529,32.4250297546387);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2210,37,'DZA-EOD','El Oued',7.06661534309387,33.2496204376221);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2211,37,'DZA-ETR','El Tarf',8.11402487754822,36.6773986816406);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2212,37,'DZA-GHD','Ghardaia',3.37607640028,31.0033950805664);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2213,37,'DZA-GUE','Guelma',7.44608998298645,36.3749046325684);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2214,37,'DZA-ILL','Illizi',8.79995059967041,27.0019445419312);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2215,37,'DZA-JIJ','Jijel',5.93356037139893,36.7359867095947);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2216,37,'DZA-KHN','Khenchela',6.9155375957489,34.9091644287109);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2217,37,'DZA-LGH','Laghouat',2.71588939428329,33.6251544952393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2218,37,'DZA-MED','Medea',2.91188013553619,35.9583034515381);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2219,37,'DZA-MIL','Mila',6.04451584815979,36.2668704986572);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2220,37,'DZA-MSC','Mascara',0.168814837932587,35.3751373291016);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2221,37,'DZA-MSL','M''Sila',4.21488177776337,35.274772644043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2222,37,'DZA-MST','Mostaganem',0.307843200862408,35.9592170715332);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2223,37,'DZA-NAM','Naama',-0.851527886465192,33.2790260314941);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2224,37,'DZA-OEB','Oum el Bouaghi',6.98499894142151,35.8155784606934);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2225,37,'DZA-ORA','Oran',-0.566387355327606,35.6170406341553);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2226,37,'DZA-ORG','Ouargla',6.27699363231659,30.9353446960449);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2227,37,'DZA-RLZ','Relizane',0.874077305197716,35.8213844299316);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2228,37,'DZA-SAH','Souk Ahras',7.85041570663452,36.1740283966064);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2229,37,'DZA-SAI','Saida',0.249444395303726,34.605354309082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2230,37,'DZA-SBA','Sidi bel Abbes',-0.5722761657089,34.8218460083008);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2231,37,'DZA-SET','Setif',5.40244841575623,36.1110420227051);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2232,37,'DZA-SKK','Skikda',6.77729082107544,36.7833728790283);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2233,37,'DZA-TBS','Tebessa',7.69809150695801,35.0298538208008);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2234,37,'DZA-TIA','Tiaret',1.52419686317444,34.905834197998);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2235,37,'DZA-TLM','Tlemcen',-1.48263627290726,34.7088928222656);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2236,37,'DZA-TMN','Tamanghasset',6.20198699831963,24.1792917251587);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2237,37,'DZA-TND','Tindouf',-5.9232759475708,27.6857280731201);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2238,37,'DZA-TOU','Tizi Ouzou',4.18478202819824,36.6685962677002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2239,37,'DZA-TPZ','Tipaza',2.44094705581665,36.5976848602295);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2240,37,'DZA-TSS','Tissemsilt',1.75993371009827,35.7905502319336);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2241,38,'AGO-BEN','Bengo',13.9122953414917,-9.02972269058228);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2242,38,'AGO-BIE','Bie',17.4969429969788,-12.4418315887451);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2243,38,'AGO-BNG','Benguela',13.809103012085,-12.8116006851196);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2244,38,'AGO-CBN','Cabinda',12.5549993515015,-5.07877349853516);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2245,38,'AGO-CCB','Cuando Cubango',19.9747123718262,-15.7944459915161);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2246,38,'AGO-CNO','Cuanza Norte',14.940972328186,-8.85836124420166);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2247,38,'AGO-CSU','Cuanza Sul',15.0459089279175,-10.9534730911255);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2248,38,'AGO-CUN','Cunene',15.2769432067871,-16.2876396179199);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2249,38,'AGO-HUA','Huambo',15.6876468658447,-12.605278968811);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2250,38,'AGO-HUI','Huila',14.9764623641968,-14.8520860671997);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2251,38,'AGO-LNO','Lunda Norte',19.6179580688477,-8.6705527305603);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2252,38,'AGO-LSU','Lunda Sul',20.3924541473389,-9.90632152557373);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2253,38,'AGO-LUA','Luand',13.3140268325806,-8.95956516265869);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2254,38,'AGO-MLN','Malanj',16.974365234375,-9.5211124420166);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2255,38,'AGO-MOX','Moxico',21.0093040466309,-13.3791465759277);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2256,38,'AGO-NAM','Namibe',12.6724987030029,-15.3920841217041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2257,38,'AGO-UIG','Uige',15.4463195800781,-7.13208389282227);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2258,38,'AGO-ZAI','Zaire',13.6135129928589,-6.81392002105713);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2259,39,'BEN-ATK','Atakora',1.52638864517212,9.96763801574707);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2260,39,'BEN-ATL','Atlantique',2.22347187995911,6.60633039474487);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2261,39,'BEN-BOR','Borgou',2.91236078739166,10.5837106704712);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2262,39,'BEN-MON','Mono',1.8224561214447,6.87424564361572);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2263,39,'BEN-OUE','Oueme',2.57830309867859,7.00006055831909);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2264,39,'BEN-ZOU','Zou',2.18991684913635,7.84293508529663);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2265,40,'BWA-CHO','Chobe',24.9351367950439,-18.391529083252);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2266,40,'BWA-CNT','Central',26.6241722106934,-21.4733104705811);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2267,40,'BWA-GHN','Ghanzi',22.7176342010498,-22.1543617248535);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2268,40,'BWA-KGL','Kgalagadi',22.2501220703125,-25.0921268463135);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2269,40,'BWA-KGT','Kgatleng',26.4181842803955,-24.1152114868164);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2270,40,'BWA-KWN','Kweneng',24.4874401092529,-23.8611221313477);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2271,40,'BWA-NEA','North-East',27.6098594665527,-21.0131950378418);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2272,40,'BWA-NGM','Ngamiland',23.08154296875,-19.4982528686523);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2273,40,'BWA-SEA','South-East',25.8514137268066,-24.9888973236084);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2274,40,'BWA-STH','Southern',24.3688869476318,-24.9156665802002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2275,41,'BFA-BAM','Bam',-1.60375010967255,13.4390201568604);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2276,41,'BFA-BGR','Bougouriba',-3.26417875289917,11.0599994659424);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2277,41,'BFA-BLG','Boulgou',-0.330833375453949,11.4644403457642);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2278,41,'BFA-BLK','Boulkiemde',-2.13771486282349,12.3253679275513);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2279,41,'BFA-BZG','Bazega',-1.44968694448471,11.9709148406982);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2280,41,'BFA-COM','Comoe',-4.60652804374695,10.2610969543457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2281,41,'BFA-GNG','Gnagna',0.102405667304993,12.8995809555054);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2282,41,'BFA-GNZ','Ganzourgou',-0.768103152513504,12.2730550765991);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2283,41,'BFA-GRM','Gourma',0.643328756093979,12.0137548446655);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2284,41,'BFA-HUT','Houet',-4.08319497108459,11.3870820999146);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2285,41,'BFA-KDG','Kadiogo',-1.53692424297333,12.3034734725952);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2286,41,'BFA-KND','Kenedougou',-5.02486133575439,11.3887958526611);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2287,41,'BFA-KRT','Kouritenga',-0.279693447053432,12.0706930160522);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2288,41,'BFA-KSS','Kossi',-4.02790403366089,12.5964975357056);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2289,41,'BFA-MHN','Mouhoun',-3.35041785240173,12.1106939315796);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2290,41,'BFA-NHR','Nahouri',-1.16611117124557,11.2622318267822);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2291,41,'BFA-NMT','Namentenga',-0.51421757042408,13.1206903457642);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2292,41,'BFA-OBR','Oubritenga',-1.41375011205673,12.5598182678223);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2293,41,'BFA-ODL','Oudalan',-0.380817249417305,14.6212491989136);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2294,41,'BFA-PON','Poni',-3.3163914680481,10.0781936645508);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2295,41,'BFA-PSS','Passore',-2.12055563926697,12.8852767944336);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2296,41,'BFA-SEN','Seno',0.33112508058548,13.6939649581909);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2297,41,'BFA-SNG','Sanguie',-2.57846260070801,12.1993045806885);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2298,41,'BFA-SNM','Sanmatenga',-1.1080556511879,13.2406930923462);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2299,41,'BFA-SOM','Soum',-1.3243579864502,14.2924098968506);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2300,41,'BFA-SOR','Sourou',-2.96430563926697,13.0347199440002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2301,41,'BFA-SSS','Sissili',-2.0622650384903,11.51194190979);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2302,41,'BFA-TAP','Tapoa',1.78368484973907,12.1154260635376);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2303,41,'BFA-YTN','Yatenga',-2.34860408306122,13.6223602294922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2304,41,'BFA-ZND','Zoundweogo',-1.08594900369644,11.5787000656128);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2305,42,'BDI-BBN','Bubanza',29.3868408203125,-3.11823153495789);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2306,42,'BDI-BJM','Bujumbura',29.4034814834595,-3.47552895545959);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2307,42,'BDI-BUR','Bururi',29.6033496856689,-3.87391555309296);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2308,42,'BDI-CBT','Cibitoke',29.2379131317139,-2.85347235202789);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2309,42,'BDI-CNK','Cankuzo',30.5502777099609,-3.13874745368958);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2310,42,'BDI-GIT','Gitega',29.9134950637817,-3.44893097877502);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2311,42,'BDI-KRN','Kirundo',30.1628332138062,-2.54986047744751);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2312,42,'BDI-KRZ','Karuzi',30.1090250015259,-3.14367842674255);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2313,42,'BDI-KYN','Kayanza',29.6509656906128,-2.98734188079834);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2314,42,'BDI-MKM','Makamba',29.8088874816895,-4.20541107654572);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2315,42,'BDI-MRM','Muramvya',29.6821899414063,-3.4053590297699);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2316,42,'BDI-MYN','Muyinga',30.3253402709961,-2.72680735588074);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2317,42,'BDI-NGO','Ngozi',29.8891305923462,-2.8674989938736);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2318,42,'BDI-RTN','Rutana',30.1649141311646,-3.8145010471344);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2319,42,'BDI-RUY','Ruyigi',30.3470802307129,-3.46462202072144);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2320,43,'CMR-ADM','Adamoua',13.2221164703369,7.08274555206299);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2321,43,'CMR-CNT','Centre',11.7356939315796,4.67999982833862);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2322,43,'CMR-ENO','Extreme-Nord',14.5387687683105,11.5031938552856);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2323,43,'CMR-EST','Est',14.3541660308838,3.87569391727448);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2324,43,'CMR-LTT','Littoral',10.2267532348633,4.31277298927307);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2325,43,'CMR-NOR','Nord',13.9106941223145,8.62555551528931);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2326,43,'CMR-NOU','Nord-Ouest',10.3993053436279,6.39847135543823);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2327,43,'CMR-OUE','Ouest',10.5861101150513,5.59222173690796);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2328,43,'CMR-SOU','Sud-Ouest',9.31027698516846,5.22395968437195);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2329,43,'CMR-SUD','Sud',11.7367925643921,2.91525888442993);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2330,44,'CAF-BBN','Bamingui-Bangoran',20.6308307647705,8.39624977111816);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2331,44,'CAF-BKO','Basse-Kotto',21.3020858764648,4.9783296585083);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2332,44,'CAF-GRB','Gribingui',19.4244899749756,7.50151634216309);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2333,44,'CAF-HKO','Haute-Kotto',22.8427772521973,7.35972166061401);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2334,44,'CAF-HMB','Haut-Mbomou',25.8566646575928,6.59458208084106);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2335,44,'CAF-HSN','Haute-Sangha',15.8975887298584,4.52868819236755);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2336,44,'CAF-KGR','Kemo-Gribingui',19.312915802002,5.743332862854);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2337,44,'CAF-LOB','Lobaye',17.6811809539795,4.25986051559448);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2338,44,'CAF-MBO','Mbomou',23.4634704589844,5.44028329849243);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2339,44,'CAF-NMM','Nana-Mambere',15.4713878631592,5.84861087799072);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2340,44,'CAF-OMP','Ombella-Mpoko',17.7994422912598,4.8872218132019);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2341,44,'CAF-OPE','Ouham-Pende',16.0199375152588,6.72070837020874);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2342,44,'CAF-OUA','Ouaka',20.705135345459,6.11356067657471);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2343,44,'CAF-OUH','Ouham',17.8756790161133,7.06905174255371);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2344,44,'CAF-SNG','Sangha',16.3415660858154,3.24104619026184);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2345,44,'CAF-VAK','Vakaga',22.2557811737061,9.79152679443359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2346,45,'TCD-BAT','Batha',18.6218032836914,14.1354084014893);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2347,45,'TCD-BET','Borkou-Ennedi-Tibesti',19.5003175735474,19.4168043136597);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2348,45,'TCD-BLT','Biltine',21.5583820343018,14.9580535888672);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2349,45,'TCD-CBG','Chari-Baguirmi',16.063214302063,11.5916080474854);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2350,45,'TCD-GUE','Guera',18.6041660308838,11.3195819854736);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2351,45,'TCD-KAN','Kanem',15.8039779663086,14.9718227386475);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2352,45,'TCD-LAC','Lac',14.6813879013062,13.7581934928894);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2353,45,'TCD-LOC','Logone Occidental',15.9327774047852,8.74972152709961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2354,45,'TCD-LOR','Logone Oriental',16.2403779029846,8.2993049621582);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2355,45,'TCD-MCH','Moyen-Chari',18.4802074432373,9.21072816848755);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2356,45,'TCD-MKE','Mayo Kebi',15.1020817756653,9.81129360198975);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2357,45,'TCD-OUA','Ouaddai',21.3947200775146,12.6969175338745);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2358,45,'TCD-SLM','Salamat',20.6049709320068,10.6082038879395);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2359,45,'TCD-TND','Tandjile',16.500497341156,9.62319374084473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2360,46,'COG-BOU','Bouenza',13.4949989318848,-4.12361121177673);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2361,46,'COG-CVT','Cuvette',15.7033176422119,-0.317500233650208);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2362,46,'COG-KOU','Kouilou',11.9598541259766,-4.26291680335999);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2363,46,'COG-LEK','Lekoumou',13.4722213745117,-3.07152795791626);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2364,46,'COG-LIK','Likouala',17.5424633026123,1.47462218999863);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2365,46,'COG-NIA','Niari',12.5609016418457,-3.35277795791626);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2366,46,'COG-PLT','Plateaux',15.3910980224609,-2.01097238063812);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2367,46,'COG-POO','Pool',15.0441598892212,-3.81236171722412);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2368,46,'COG-SNG','Sangha',15.0911102294922,1.38903196156025);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2369,47,'DJI-ASA','''Ali Sabih',42.9068565368652,11.2835474014282);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2370,47,'DJI-DJI','Djibouti',43.1365928649902,11.4895367622375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2371,47,'DJI-DKH','Dikhil',42.3132629394531,11.4341535568237);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2372,47,'DJI-OBC','Obock',42.9528198242188,12.2505540847778);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2373,47,'DJI-TDJ','Tadjoura',42.5039253234863,12.0368041992188);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2374,48,'EGY-ABA','Al Bahr al Ahmar',33.8561096191406,25.6471004486084);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2375,48,'EGY-ABH','Al Buhayrah',30.238187789917,30.6731910705566);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2376,48,'EGY-ADQ','Ad Daqahliyah',31.7091636657715,31.0515880584717);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2377,48,'EGY-AFY','Al Fayyum',30.4580535888672,29.3488864898682);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2378,48,'EGY-AGH','Al Gharbiyah',31.0095863342285,30.8465347290039);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2379,48,'EGY-AIM','Al Isma''iliyah',32.2791175842285,30.6579151153564);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2380,48,'EGY-AIS','Al Iskandariyah',29.8470306396484,30.8286075592041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2381,48,'EGY-AJI','Al Jizah',29.6310176849365,29.0043106079102);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2382,48,'EGY-AMI','Al Minya',29.8074264526367,28.194580078125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2383,48,'EGY-AMN','Al Minufiyah',31.0255489349365,30.445276260376);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2384,48,'EGY-AQH','Al Qahirah',31.5812492370605,30.0408306121826);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2385,48,'EGY-AQL','Al Qalyubiyah',31.3380260467529,30.3492069244385);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2386,48,'EGY-ASH','Ash Sharqiyah',31.7780513763428,30.7392749786377);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2387,48,'EGY-ASN','Aswan',32.2805519104004,23.6339244842529);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2388,48,'EGY-ASW','As Suways',32.3619422912598,29.6076374053955);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2389,48,'EGY-ASY','Asyut',31.1420822143555,27.2297210693359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2390,48,'EGY-AWA','Al Wadi al Jadid',28.9626369476318,24.8309955596924);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2391,48,'EGY-BSA','Bur Sa''id',32.4291114807129,31.1276626586914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2392,48,'EGY-BSW','Bani Suwayf',30.5048599243164,29.0606918334961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2393,48,'EGY-DMY','Dumyat',31.8040046691895,31.3630275726318);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2394,48,'EGY-JSI','Janub Sina''',33.7764129638672,28.8274993896484);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2395,48,'EGY-KAS','Kafr ash Shaykh',30.8491249084473,31.2937450408936);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2396,48,'EGY-MNT','Marsa Matruh',27.5176372528076,29.6566333770752);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2397,48,'EGY-QIN','Qina',32.4418067932129,25.7043056488037);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2398,48,'EGY-SSI','Shamal Sina''',33.7515716552734,30.4050178527832);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2399,48,'EGY-SUH','Suhaj',31.8037395477295,26.5351371765137);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2400,49,'GNQ-BKN','Bioko Norte',8.79363203048706,3.64027619361877);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2401,49,'GNQ-BKS','Bioko Sur',8.64513683319092,3.42319488525391);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2402,49,'GNQ-CNS','Centro Sur',10.4815945625305,1.58487075567245);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2403,49,'GNQ-KNT','Kie-Ntem',10.8758726119995,1.94785553216934);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2404,49,'GNQ-LTR','Litoral',7.93960857391357,0.432126760482788);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2405,49,'GNQ-WLN','Wele-Nzas',10.938973903656,1.50138461589813);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2406,50,'ERI-AGZ','Akale Guzay',39.6017265319824,14.8044457435608);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2407,50,'ERI-BRK','Baraka',37.4296760559082,15.7804307937622);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2408,50,'ERI-DNK','Denakil',41.4445819854736,13.9266653060913);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2409,50,'ERI-HMS','Hamasen',38.7320899963379,15.3301100730896);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2410,50,'ERI-SHL','Sahil',38.5633277893066,17.0630054473877);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2411,50,'ERI-SMH','Samhar',39.6382656097412,15.7637705802917);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2412,50,'ERI-SNH','Senhit',38.5165901184082,15.8367247581482);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2413,50,'ERI-SRY','Seraye',38.5016632080078,14.7727837562561);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2414,51,'ETH-ARS','Arsi',39.6993141174316,7.89631605148315);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2415,51,'ETH-BAL','Bale',41.8830833435059,6.1659893989563);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2416,51,'ETH-GGO','Gamo Gofa',36.8363876342773,5.62580490112305);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2417,51,'ETH-GND','Gonder',37.1016044616699,12.7038717269897);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2418,51,'ETH-GOJ','Gojam',36.741382598877,10.9530363082886);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2419,51,'ETH-HRR','Harerge',44.0338401794434,8.03031158447266);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2420,51,'ETH-ILB','Ilubabor',34.9474945068359,7.85041618347168);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2421,51,'ETH-KEF','Kefa',35.9141654968262,7.1280722618103);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2422,51,'ETH-SHE','Shewa',38.8141632080078,9.00137376785278);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2423,51,'ETH-SID','Sidamo',39.3930168151855,5.29638838768005);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2424,51,'ETH-TGR','Tigray',39.7080497741699,13.6474990844727);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2425,51,'ETH-WEL','Welega',35.8733940124512,9.70388793945313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2426,51,'ETH-WEO','Welo',40.4077758789063,11.7434706687927);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2427,52,'GAB-EST','Estuaire',10.1390266418457,0.239999890327454);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2428,52,'GAB-HOG','Haut-Ogooue',13.6316065788269,-1.22777792066336);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2429,52,'GAB-MOG','Moyen-Ogooue',10.5697212219238,-0.509861156344414);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2430,52,'GAB-NGO','Ngounie',11.1830549240112,-1.69356173276901);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2431,52,'GAB-NYN','Nyanga',10.9839630126953,-3.08847212791443);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2432,52,'GAB-OIV','Ogooue-Ivindo',12.8824987411499,0.343749940395355);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2433,52,'GAB-OLO','Ogooue-Lolo',12.531943321228,-0.819583356380463);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2434,52,'GAB-OMR','Ogooue-Maritime',9.65263748168945,-1.50406903028488);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2435,52,'GAB-WNT','Woleu-Ntem',11.8302774429321,1.27228246629238);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2436,53,'GMB-BNJ','Banjul',-16.597056388855,13.4519734382629);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2437,53,'GMB-KSM','Kombo Saint Mary',-16.6707029342651,13.4371948242188);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2438,53,'GMB-LRI','Lower River',-15.6998910903931,13.4061107635498);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2439,53,'GMB-MIS','MacCarthy Island',-14.9652376174927,13.5811634063721);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2440,53,'GMB-NBA','North Bank',-15.9314231872559,13.4856729507446);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2441,53,'GMB-URI','Upper River',-14.1731948852539,13.406804561615);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2442,53,'GMB-WST','Western',-16.3155565261841,13.2548484802246);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2443,54,'GHA-ASH','Ashanti',-1.33041681349277,6.75444364547729);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2444,54,'GHA-BAH','Brong-Ahafo',-1.42734415829182,7.58395528793335);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2445,54,'GHA-CNT','Central',-1.26504030823708,5.65874147415161);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2446,54,'GHA-EST','Eastern',-0.458923786878586,6.45924472808838);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2447,54,'GHA-GAC','Greater Accra',0.1061110496521,5.74684762954712);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2448,54,'GHA-NRT','Northern',-1.10902786254883,9.33213424682617);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2449,54,'GHA-UPE','Upper East',-0.773055579513311,10.7294435501099);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2450,54,'GHA-UPW','Upper West',-2.14167928695679,10.3406858444214);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2451,54,'GHA-VOL','Volta',0.403942108154297,7.26361036300659);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2452,54,'GHA-WST','Western',-2.333611369133,5.88850498199463);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2453,55,'GIN-BEY','Beyla',-8.31792068481445,8.71865749359131);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2454,55,'GIN-BOF','Boffa',-14.0805583000183,10.3006935119629);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2455,55,'GIN-BOK','Boke',-14.4193067550659,11.0741662979126);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2456,55,'GIN-CNK','Conakry',-13.5826787948608,9.61680364608765);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2457,55,'GIN-COY','Coyah',-13.5097227096558,9.98934268951416);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2458,55,'GIN-DAB','Dabola',-11.1047534942627,10.5729160308838);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2459,55,'GIN-DAL','Dalaba',-12.231255531311,10.9099206924438);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2460,55,'GIN-DNG','Dinguiraye',-10.6378965377808,11.5947198867798);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2461,55,'GIN-FRC','Forecariah',-13.0544061660767,9.38120937347412);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2462,55,'GIN-FRI','Fria',13.5295844078064,10.4825382232666);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2463,55,'GIN-FRN','Faranah',-10.7996244430542,9.8651819229126);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2464,55,'GIN-GAO','Gaoual',-13.3877239227295,11.7201910018921);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2465,55,'GIN-GCK','Gueckedou',-10.1764011383057,8.70305442810059);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2466,55,'GIN-KER','Kerouane',-8.91486740112305,9.30805397033691);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2467,55,'GIN-KIN','Kindia',-12.6998443603516,10.1016664505005);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2468,55,'GIN-KND','Koundara',-13.1518077850342,12.3554153442383);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2469,55,'GIN-KNK','Kankan',-9.00989627838135,10.0299243927002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2470,55,'GIN-KOB','Koubia',-11.8363904953003,11.7169857025146);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2471,55,'GIN-KRS','Kouroussa',-10.0934190750122,10.5340270996094);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2472,55,'GIN-KSS','Kissidougou',-9.85737323760986,9.2822208404541);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2473,55,'GIN-LAB','Labe',-12.3147230148315,11.4483966827393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2474,55,'GIN-LLM','Lelouma',-12.749885559082,11.4260382652283);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2475,55,'GIN-LOL','Lola',-8.32458400726318,7.89041662216187);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2476,55,'GIN-MAM','Mamou',-11.8365287780762,10.5985250473022);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2477,55,'GIN-MCN','Macenta',-9.39375114440918,8.37521076202393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2478,55,'GIN-MLI','Mali',-12.1054191589355,12.0551376342773);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2479,55,'GIN-MND','Mandiana',-8.64361143112183,10.7061676979065);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2480,55,'GIN-NZR','Nzerekore',-8.77123165130615,7.96456956863403);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2481,55,'GIN-PIT','Pita',-12.5593385696411,10.9042730331421);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2482,55,'GIN-SIG','Siguiri',-9.42901515960693,11.677903175354);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2483,55,'GIN-TLM','Telimele',-13.4764032363892,10.9029159545898);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2484,55,'GIN-TOU','Tougue',-11.5998468399048,11.5177974700928);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2485,55,'GIN-YOM','Yomou',-9.09777927398682,7.61228799819946);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2486,56,'GNB-BAF','Bafata',-14.7078590393066,12.1366662979126);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2487,56,'GNB-BIS','Bissau',-15.6103587150574,11.8785176277161);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2488,56,'GNB-BMB','Biombo',-15.7943072319031,11.8822259902954);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2489,56,'GNB-BOL','Bolama',-15.8807678222656,11.3587493896484);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2490,56,'GNB-CAC','Cacheu',-16.0573577880859,12.1525087356567);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2491,56,'GNB-GAB','Gabu',-14.0889868736267,12.1190032958984);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2492,56,'GNB-OIO','Oio',-15.3015623092651,12.2908000946045);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2493,56,'GNB-QNR','Quinara',-15.1932153701782,11.6104154586792);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2494,56,'GNB-TMB','Tombali',-14.9292697906494,11.3105325698853);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2495,57,'CIV-ABD','Abidjan',-4.11611151695251,5.52472162246704);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2496,57,'CIV-ABN','Abengourou',-3.47406911849976,6.4438169002533);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2497,57,'CIV-ABS','Aboisso',-3.13961744308472,5.67066717147827);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2498,57,'CIV-ADZ','Adzope',-3.76833367347717,6.19280242919922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2499,57,'CIV-AGB','Agboville',-4.28791952133179,5.94111061096191);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2500,57,'CIV-AGN','Agnibilekrou',-3.36847257614136,7.08375215530396);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2501,57,'CIV-BEM','Beoumi',-5.56264972686768,7.77936553955078);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2502,57,'CIV-BGA','Bongouanou',-4.26944494247437,6.590416431427);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2503,57,'CIV-BND','Bondoukou',-3.26750063896179,8.26306009292603);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2504,57,'CIV-BNG','Bangolo',-7.51292085647583,7.02735829353333);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2505,57,'CIV-BNK','Biankouma',-7.59472274780273,7.77623414993286);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2506,57,'CIV-BNL','Boundiali',-6.51236152648926,9.66152667999268);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2507,57,'CIV-BOA','Bouake',-4.96360158920288,7.74791574478149);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2508,57,'CIV-BON','Bouna',-3.45400595664978,9.14402675628662);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2509,57,'CIV-BOU','Bouafle',-5.82271862030029,7.08559131622314);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2510,57,'CIV-DAL','Daloa',-6.49832582473755,6.934166431427);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2511,57,'CIV-DAN','Danane',-8.16098594665527,7.2008957862854);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2512,57,'CIV-DBK','Dabakala',-4.44138145446777,8.35249900817871);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2513,57,'CIV-DIV','Divo',-5.40659475326538,5.64337301254272);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2514,57,'CIV-DKR','Daoukro',-4.0073778629303,7.23261499404907);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2515,57,'CIV-DMB','Dimbokro',-4.49311971664429,7.00041627883911);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2516,57,'CIV-DUK','Duekoue',-7.29586601257324,6.64597177505493);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2517,57,'CIV-FRK','Ferkessedougou',-4.79875016212463,9.53567790985107);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2518,57,'CIV-GAG','Gagnoa',-6.06446170806885,6.09893274307251);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2519,57,'CIV-GRL','Grand-Lahou',-5.07986164093018,5.44667148590088);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2520,57,'CIV-GUI','Guiglo',-7.84166479110718,6.29987764358521);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2521,57,'CIV-ISS','Issia',-6.52706527709961,6.46694374084473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2522,57,'CIV-KAT','Katiola',-5.23166036605835,8.67888784408569);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2523,57,'CIV-KRH','Korhogo',-5.80440425872803,9.47783279418945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2524,57,'CIV-LKT','Lakota',-5.76522779464722,5.85687780380249);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2525,57,'CIV-MAN','Man',-7.47879695892334,7.35707950592041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2526,57,'CIV-MBH','Mbahiakro',-4.11638903617859,7.67602396011353);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2527,57,'CIV-MNK','Mankono',-6.02930593490601,8.41454315185547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2528,57,'CIV-ODN','Odienne',-7.37013959884644,9.48253154754639);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2529,57,'CIV-OUM','Oume',-5.48125028610229,6.40347146987915);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2530,57,'CIV-SEG','Seguela',-6.7383337020874,8.4158673286438);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2531,57,'CIV-SKS','Sakassou',-5.41694498062134,7.43416595458984);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2532,57,'CIV-SNF','Sinfra',-5.76584625244141,6.63472175598145);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2533,57,'CIV-SNP','San-Pedro',-6.75210046768188,5.00806522369385);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2534,57,'CIV-SOB','Soubre',-6.66097259521484,5.94079804420471);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2535,57,'CIV-SSS','Sassandra',-6.09291744232178,5.33320474624634);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2536,57,'CIV-TAB','Tabou',-7.29027795791626,5.01767635345459);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2537,57,'CIV-TMD','Toumodi',-5.01027822494507,6.4917254447937);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2538,57,'CIV-TND','Tanda',-3.36707735061646,7.53114366531372);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2539,57,'CIV-TNG','Tengrela',-6.43250036239624,10.4748601913452);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2540,57,'CIV-TOU','Touba',-7.66358757019043,8.45664167404175);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2541,57,'CIV-TSS','Tiassale',-4.85380411148071,5.96416616439819);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2542,57,'CIV-VAV','Vavoua',-6.59435939788818,7.41688299179077);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2543,57,'CIV-YMS','Yamoussoukro',-5.15554285049438,7.04485988616943);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2544,57,'CIV-ZNL','Zuenoula',-6.08083343505859,7.45476055145264);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2545,58,'KEN-CNT','Central',36.8486061096191,-0.588014949113131);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2546,58,'KEN-COA','Coast',39.578800201416,-2.34397549368441);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2547,58,'KEN-EST','Eastern',37.7497177124023,0.701777219772339);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2548,58,'KEN-NAR','Nairobi Area',36.9037208557129,-1.29486119747162);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2549,58,'KEN-NES','North-Eastern',40.2986907958984,1.11196899414063);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2550,58,'KEN-NYN','Nyanza',34.6224975585938,-0.545138984918594);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2551,58,'KEN-RVL','Rift Valley',36.0272178649902,0.717499732971191);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2552,58,'KEN-WST','Western',34.5393028259277,0.532877456396818);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2553,59,'LSO-BBU','Butha-Buthe',28.5064449310303,-28.8172779083252);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2554,59,'LSO-BER','Berea',27.8861541748047,-29.1729001998901);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2555,59,'LSO-LER','Leribe',28.2237615585327,-29.0167684555054);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2556,59,'LSO-MAS','Maseru',27.7770156860352,-29.5938377380371);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2557,59,'LSO-MFT','Mafeteng',27.4369440078735,-29.747709274292);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2558,59,'LSO-MHO','Mohale''s Hoek',27.8573532104492,-30.0987701416016);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2559,59,'LSO-MKH','Mokhotlong',29.0546789169312,-29.183650970459);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2560,59,'LSO-QNE','Qacha''s Nek',28.7091131210327,-29.965950012207);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2561,59,'LSO-QTH','Quthing',27.9704132080078,-30.3222093582153);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2562,59,'LSO-THT','Thaba Tseka',28.6854104995728,-29.527774810791);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2563,60,'LBR-BOM','Bomi',-10.7755250930786,6.69983291625977);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2564,60,'LBR-BON','Bong',-9.80183124542236,6.93041610717773);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2565,60,'LBR-GBA','Grand Bassa',-9.74402904510498,6.11291646957397);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2566,60,'LBR-GCM','Grand Cape Mount',-11.0017366409302,7.06457948684692);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2567,60,'LBR-GJI','Grand Jide',-8.13250064849854,5.65824317932129);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2568,60,'LBR-GKR','Grand Kru',-8.25902891159058,4.81138801574707);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2569,60,'LBR-LOF','Lofa',-10.1508188247681,7.66208267211914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2570,60,'LBR-MNT','Montserrado',-10.5843067169189,6.52526617050171);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2571,60,'LBR-MRG','Margibi',-10.178729057312,6.47243976593018);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2572,60,'LBR-MRY','Maryland',-7.81311798095703,4.7281174659729);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2573,60,'LBR-NIM','Nimba',-8.73493576049805,6.76208305358887);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2574,60,'LBR-RVR','Rivercess',-9.39597320556641,5.81434535980225);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2575,60,'LBR-SIN','Sino',-8.86353778839111,5.34411668777466);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2576,61,'MDG-ANN','Antananarivo',46.7661056518555,-18.9998626708984);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2577,61,'MDG-ANT','Antsiranana',49.1869430541992,-13.9626398086548);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2578,61,'MDG-FNR','Fianarantsoa',46.8061141967773,-22.0868148803711);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2579,61,'MDG-MHJ','Mahajanga',46.7538833618164,-16.5865297317505);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2580,61,'MDG-TMS','Toamasina',48.9078521728516,-17.6961131095886);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2581,61,'MDG-TOL','Toliara',45.3315010070801,-21.8847255706787);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2582,62,'MWI-CNT','Central',33.8368034362793,-13.7590284347534);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2583,62,'MWI-NRT','Northern',33.9530830383301,-11.0447235107422);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2584,62,'MWI-STH','Southern',35.0876350402832,-15.3207969665527);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2585,63,'MLI-BAM','Bamako',-7.57511281967163,13.4881935119629);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2586,63,'MLI-GAO','Gao',-1.16236162185669,19.9576711654663);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2587,63,'MLI-KAY','Kayes',-10.1838054656982,13.7986650466919);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2588,63,'MLI-MOP','Mopti',-3.21698850393295,14.6810255050659);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2589,63,'MLI-SEG','Segou',-5.54434895515442,14.0862455368042);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2590,63,'MLI-SKS','Sikasso',-6.52416753768921,11.6862487792969);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2591,64,'MRT-ADR','Adrar',-10.5671539306641,20.2717533111572);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2592,64,'MRT-ASB','Assaba',-11.8227787017822,16.4274168014526);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2593,64,'MRT-BRK','Brakna',-13.6821670532227,17.3603267669678);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2594,64,'MRT-DND','Dakhlet Nouadhibou',-16.2955570220947,20.2975616455078);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2595,64,'MRT-GDM','Guidimaka',-12.1016006469727,15.3794641494751);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2596,64,'MRT-GRG','Gorgol',-13.120662689209,15.9671564102173);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2597,64,'MRT-HEC','Hodh ech Chargui',-7.22412633895874,19.2443161010742);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2598,64,'MRT-HEG','Hodh el Gharbi',-9.7111120223999,16.5594425201416);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2599,64,'MRT-INC','Inchiri',-15.2604207992554,20.1719436645508);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2600,64,'MRT-TGN','Tagant',-10.2674341201782,18.3716640472412);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2601,64,'MRT-TRR','Trarza',-14.7219457626343,17.5317897796631);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2602,64,'MRT-TZM','Tiris Zemmour',-8.97819471359253,24.6595344543457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2603,65,'MAR-CEN','Centre',-7.26922369003296,32.5818042755127);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2604,65,'MAR-CNR','Centre-North',-4.1820250749588,33.9180526733398);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2605,65,'MAR-CSO','Centre-South',-4.84096431732178,32.2316246032715);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2606,65,'MAR-EST','Eastern',-2.48888909816742,33.5720796585083);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2607,65,'MAR-NWT','North-West',-5.79736018180847,34.5422210693359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2608,65,'MAR-SOU','South',-9.1635479927063,29.8497543334961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2609,65,'MAR-TNF','Tensift',-8.43548250198364,31.772668838501);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2610,66,'MOZ-CDL','Cabo Delgado',39.3086090087891,-12.3145837783813);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2611,66,'MOZ-GAZ','Gaza',32.8900547027588,-23.3441867828369);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2612,66,'MOZ-INH','Inhambane',34.3779144287109,-22.9060840606689);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2613,66,'MOZ-MAN','Manica',33.4740715026855,-19.0009746551514);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2614,66,'MOZ-MAP','Maputo',32.529857635498,-25.5355567932129);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2615,66,'MOZ-NIA','Niassa',36.4297409057617,-13.3762211799622);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2616,66,'MOZ-NMP','Nampula',38.7803421020508,-15.1570167541504);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2617,66,'MOZ-SOF','Sofala',34.8015213012695,-19.0744152069092);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2618,66,'MOZ-TET','Tete',32.7794246673584,-15.8732509613037);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2619,66,'MOZ-ZMB','Zambezia',37.1322326660156,-16.9542675018311);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2620,67,'NAM-BSM','Boesmanland',19.9966678619385,-19.585973739624);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2621,67,'NAM-BTH','Bethanien',17.1018028259277,-26.7386894226074);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2622,67,'NAM-COO','Caprivi Oos',24.2744369506836,-17.9790153503418);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2623,67,'NAM-DMR','Damaraland',14.4340286254883,-20.737361907959);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2624,67,'NAM-GBB','Gobabis',18.9804153442383,-22.3784732818604);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2625,67,'NAM-GRT','Grootfontein',17.9674835205078,-19.5812511444092);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2626,67,'NAM-HOO','Hereroland Oos',19.7509078979492,-21.9339733123779);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2627,67,'NAM-HWE','Hereroland Wes',18.5156917572021,-20.3093547821045);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2628,67,'NAM-KKL','Kaokoland',13.2151384353638,-18.2459354400635);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2629,67,'NAM-KRB','Karibib',15.6981935501099,-22.416410446167);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2630,67,'NAM-KRS','Karasburg',18.5831317901611,-28.0468063354492);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2631,67,'NAM-KTM','Keetmanshoop',18.8303546905518,-26.5709753036499);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2632,67,'NAM-KVN','Kavango',20.6414699554443,-18.2876682281494);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2633,67,'NAM-LDR','Luderitz',16.1495752334595,-26.8083362579346);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2634,67,'NAM-MLT','Maltahohe',16.4889497756958,-24.8633346557617);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2635,67,'NAM-MRN','Mariental',18.5626373291016,-24.5659770965576);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2636,67,'NAM-NML','Namaland',17.8476247787476,-25.8096694946289);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2637,67,'NAM-OKH','Okahandja',17.4026355743408,-21.6699829101563);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2638,67,'NAM-OMR','Omaruru',16.0336141586304,-21.2124042510986);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2639,67,'NAM-OTJ','Otjiwarongo',16.8540191650391,-20.6348552703857);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2640,67,'NAM-OUT','Outjo',15.5579147338867,-19.5481967926025);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2641,67,'NAM-OWM','Owambo',15.9970254898071,-18.0776691436768);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2642,67,'NAM-RHB','Rehoboth',17.0052757263184,-23.6016693115234);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2643,67,'NAM-SWK','Swakopmund',14.3134737014771,-22.180362701416);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2644,67,'NAM-TSM','Tsumeb',17.2144775390625,-19.0255565643311);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2645,67,'NAM-WND','Windhoek',17.1206865310669,-22.8650722503662);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2646,68,'NER-AGD','Agadez',10.1208329200745,19.4284038543701);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2647,68,'NER-DIF','Diffa',13.0803217887878,15.5344438552856);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2648,68,'NER-DOS','Dosso',3.54993367195129,13.1755456924438);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2649,68,'NER-MAR','Maradi',7.4119439125061,14.2220830917358);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2650,68,'NER-NIA','Niamey',2.2101858407259,13.801408290863);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2651,68,'NER-TAH','Tahoua',5.27779936790466,16.1533317565918);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2652,68,'NER-ZND','Zinder',9.66219663619995,15.1512861251831);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2653,69,'NI05','Lagos','NGA-LAG',3.52258038520813,6.52775239944458);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2654,69,'NI06','Bauchi','NGA-BAU',10.3226289749146,10.9775629043579);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2655,69,'NI10','Rivers','NGA-RVR',6.4679160118103,5.01596021652222);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2656,69,'NI11','Abuja Capital Territory (Abuja)','NGA-FCT',7.20606899261475,8.91708183288574);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2657,69,'NI16','Ogun','NGA-OGU',3.65993499755859,7.12941217422485);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2658,69,'NI17','Ondo','NGA-OND',5.21019077301025,6.96208119392395);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2659,69,'NI19','Plateau','NGA-PLA',8.82180452346802,9.15307903289795);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2660,69,'NI21','Akwa Ibom','NGA-AKI',7.84805488586426,5.11972141265869);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2661,69,'NI22','Cross River','NGA-CRI',8.72166585922241,5.81222152709961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2662,69,'NI23','Kaduna','NGA-KAD',7.44854259490967,10.2738876342773);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2663,69,'NI24','Katsina','NGA-KAT',7.94160223007202,12.2437491416931);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2664,69,'NI25','Anambra','NGA-ANM',7.15986061096191,6.18472528457642);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2665,69,'NI26','Benue','NGA-BEN',8.75482630729675,7.46816301345825);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2666,69,'NI27','Borno','NGA-BOR',13.1008319854736,11.8362493515015);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2667,69,'NI28','Imo','NGA-IMO',7.0985095500946,5.60263800621033);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2668,69,'NI29','Kano','NGA-KAN',8.54011678695679,11.6981935501099);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2669,69,'NI30','Kwara','NGA-KWA',4.47411727905273,8.82471942901611);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2670,69,'NI31','Niger','NGA-NIG',5.36696076393127,9.77499866485596);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2671,69,'NI32','Oyo','NGA-OYO',3.61656641960144,8.09722185134888);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2672,69,'NI33','Sokoto','NGA-SOK',5.67655944824219,12.3722171783447);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2673,69,'NI34','Abia','NGA-ABI',7.60043144226074,5.53445291519165);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2674,69,'NI35','Adamawa','NGA-ADM',12.4906449317932,9.09610891342163);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2675,69,'NI36','Delta','NGA-DEL',5.88069272041321,5.67692518234253);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2676,69,'NI37','Edo','NGA-EDO',5.87682199478149,6.59490466117859);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2677,69,'NI38','Enugu','NGA-ENU',7.59648942947388,6.51070928573608);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2678,69,'NI39','Jigawa','NGA-JIG',9.6907377243042,11.9847211837769);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2679,69,'NI40','Kebbi','NGA-KEB',4.73750901222229,11.6884598731995);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2680,69,'NI41','Kogi','NGA-KOG',6.62188506126404,7.64376544952393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2681,69,'NI42','Osun','NGA-OSU',4.60399842262268,7.51222133636475);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2682,69,'NI43','Taraba','NGA-TAR',10.5123434066772,7.99972105026245);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,gmi_admin,centroid_x,centroid_y) values(2683,69,'NI44','Yobe','NGA-YOB',11.0535707473755,11.929443359375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2684,70,'RWA-BUT','Butare',29.7614555358887,-2.55295670032501);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2685,70,'RWA-BYM','Byumba',30.3596878051758,-1.46911001205444);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2686,70,'RWA-CYN','Cyangugu',29.1084566116333,-2.478835105896);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2687,70,'RWA-GKN','Gikongoro',29.5048751831055,-2.51652789115906);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2688,70,'RWA-GSN','Gisenyi',29.3987483978271,-1.76196372509003);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2689,70,'RWA-GTR','Gitarama',29.802544593811,-2.0393785238266);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2690,70,'RWA-KBN','Kibungo',30.5740270614624,-2.02786666154861);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2691,70,'RWA-KIB','Kibuye',29.3806600570679,-2.09205251932144);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2692,70,'RWA-KIG','Kigali',30.079195022583,-2.04369938373566);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2693,70,'RWA-RHN','Ruhengeri',29.6956748962402,-1.53847193717957);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2694,71,'SEN-DKR','Dakar',-17.3326396942139,14.7547373771667);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2695,71,'SEN-DRB','Diourbel',-16.190279006958,14.7709712982178);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2696,71,'SEN-FTC','Fatick',-16.1145849227905,14.2241649627686);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2697,71,'SEN-KLC','Kaolack',-15.4802713394165,14.1544437408447);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2698,71,'SEN-KLD','Kolda',-14.6906929016113,13.0129156112671);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2699,71,'SEN-LOU','Louga',-15.5077791213989,15.3496260643005);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2700,71,'SEN-STL','Saint-Louis',-14.559308052063,15.5434713363647);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2701,71,'SEN-THI','Thies',-16.6559734344482,14.798544883728);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2702,71,'SEN-TMB','Tambacounda',-13.1119174957275,13.7037906646729);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2703,71,'SEN-ZGN','Ziguinchor',-16.3456249237061,12.7437124252319);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2704,72,'SLE-EST','Eastern',-10.9222230911255,8.20705842971802);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2705,72,'SLE-NRT','Northern',-11.9335680007935,9.13592433929443);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2706,72,'SLE-STH','Southern',-12.0623617172241,7.71583271026611);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2707,72,'SLE-WAR','Western Area',-13.0943183898926,8.34708309173584);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2708,73,'SOM-AWD','Awdal',43.4356899261475,10.5521283149719);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2709,73,'SOM-BAK','Bakool',43.6751098632813,4.22889983654022);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2710,73,'SOM-BAR','Bari',50.1452732086182,10.1586074829102);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2711,73,'SOM-BAY','Bay',43.4784336090088,2.5647229552269);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2712,73,'SOM-BND','Banaadir',45.3552722930908,2.04972720146179);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2713,73,'SOM-GED','Gedo',41.9956283569336,3.26010811328888);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2714,73,'SOM-GLG','Galguduud',46.7068729400635,4.87742507457733);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2715,73,'SOM-HII','Hiiraan',45.4067611694336,4.39066469669342);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2716,73,'SOM-JDH','Jubbada Dhexe',42.2386093139648,1.34419248998165);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2717,73,'SOM-JHO','Jubbada Hoose',42.1181888580322,-0.157188057899475);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2718,73,'SOM-MUD','Mudug',47.8726959228516,6.09238481521606);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2719,73,'SOM-NUG','Nugaal',48.9700832366943,8.17607092857361);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2720,73,'SOM-SAN','Sanaag',47.4131927490234,10.2845430374146);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2721,73,'SOM-SDH','Shabeellaha Dhexe',46.079080581665,3.07913196086884);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2722,73,'SOM-SHO','Shabeellaha Hoose',44.1155090332031,1.97178584337234);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2723,73,'SOM-SOL','Sool',47.4779262542725,8.90113115310669);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2724,73,'SOM-TGD','Togdheer',45.826000213623,9.0596752166748);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2725,73,'SOM-WGL','Woqooyi Galbeed',44.612735748291,9.83605670928955);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2726,74,'ZAF-ECP','Eastern Cape',26.4599199295044,-32.0823640823364);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2727,74,'ZAF-GAT','Gauteng',28.2126350402832,-26.0064277648926);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2728,74,'ZAF-KNT','KwaZulu/Natal',30.8203506469727,-28.9395065307617);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2729,74,'ZAF-MPM','Mpumalanga',30.1535720825195,-25.7311573028564);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2730,74,'ZAF-NCP','Northern Cape',21.0040245056152,-28.8511791229248);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2731,74,'ZAF-NRT','Northern',29.1375951766968,-23.7331953048706);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2732,74,'ZAF-NWS','North West',25.4592094421387,-26.3593416213989);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2733,74,'ZAF-OFS','Free State',27.0558490753174,-28.7026424407959);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2734,74,'ZAF-PS1','Walvis Bay',14.5605545043945,-22.9209728240967);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2735,74,'ZAF-WCP','Western Cape',20.9858541488647,-32.6254463195801);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2736,75,'SDN-AAN','A''ali an Nil',31.8437175750732,8.99624061584473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2737,75,'SDN-AIS','Al Istiwa''iyah',31.1193027496338,5.1548912525177);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2738,75,'SDN-AKH','Al Khartum',33.0004787445068,15.9580545425415);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2739,75,'SDN-ASH','Ash Shamaliyah',29.8997459411621,19.1130542755127);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2740,75,'SDN-ASR','Ash Sharqiyah',35.9374961853027,17.3336124420166);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2741,75,'SDN-AWU','Al Wusta',33.6088733673096,12.4698600769043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2742,75,'SDN-BAG','Bahr al Ghazal',27.9061088562012,8.10597229003906);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2743,75,'SDN-DRF','Darfur',24.8611755371094,14.3434705734253);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2744,75,'SDN-KRD','Kurdufan',29.6795825958252,13.0029144287109);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2745,76,'SWZ-HHH','Hhohho',31.3359994888306,-26.0948934555054);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2746,76,'SWZ-LBM','Lubombo',31.816650390625,-26.5379810333252);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2747,76,'SWZ-MNZ','Manzini',31.2488708496094,-26.5000057220459);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2748,76,'SWZ-SHS','Shiselweni',31.443470954895,-27.0282297134399);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2749,77,'TZA-ARS','Arusha',36.3837966918945,-3.83938992023468);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2750,77,'TZA-DES','Dar es Salaam',39.2721328735352,-6.79023218154907);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2751,77,'TZA-DOD','Dodoma',36.0408744812012,-5.81295347213745);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2752,77,'TZA-IRN','Iringa',35.3900375366211,-8.71041774749756);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2753,77,'TZA-KIG','Kigoma',30.4148597717285,-4.8363893032074);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2754,77,'TZA-KLM','Kilimanjaro',37.7137451171875,-3.69542145729065);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2755,77,'TZA-LIN','Lindi',38.4148559570313,-9.37696075439453);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2756,77,'TZA-MAR','Mara',34.0051345825195,-1.74970453977585);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2757,77,'TZA-MBE','Mbeya',33.4961090087891,-8.30563497543335);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2758,77,'TZA-MRG','Morogoro',36.9249954223633,-7.90680599212646);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2759,77,'TZA-MTW','Mtwara',39.2623748779297,-10.7701559066772);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2760,77,'TZA-MWN','Mwanza',32.8990230560303,-2.43305575847626);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2761,77,'TZA-PNR','Pemba North',39.773609161377,-5.03025889396667);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2762,77,'TZA-PSO','Pemba South',39.7483329772949,-5.3116672039032);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2763,77,'TZA-PWA','Pwani',38.8481903076172,-7.15513944625854);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2764,77,'TZA-RUK','Rukwa',31.3448600769043,-7.11500072479248);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2765,77,'TZA-RUV','Ruvuma',36.3676109313965,-10.4787511825562);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2766,77,'TZA-SHN','Shinyanga',33.1837520599365,-3.3158757686615);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2767,77,'TZA-SNG','Singida',34.4089317321777,-5.66616821289063);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2768,77,'TZA-TAB','Tabora',32.6241645812988,-5.44986128807068);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2769,77,'TZA-TAN','Tanga',38.1089553833008,-5.0938892364502);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2770,77,'TZA-ZCN','Zanzibar Central/South',39.4204139709473,-6.24506664276123);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2771,77,'TZA-ZMG','Ziwa Magharibi',31.5785675048828,-2.15864700078964);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2772,77,'TZA-ZNR','Zanzibar North',39.2907829284668,-5.87347269058228);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2773,77,'TZA-ZUR','Zanzibar Urban/West',39.2408294677734,-6.17175960540771);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2774,78,'TGO-AMO','Amou',0.965833246707916,7.56157112121582);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2775,78,'TGO-ASL','Assoli',1.19317376613617,9.33247852325439);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2776,78,'TGO-BNH','Binah',1.2905524969101,9.69803428649902);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2777,78,'TGO-BSS','Bassar',0.625277742743492,9.43749332427979);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2778,78,'TGO-DFL','Doufelgou',1.10263884067535,9.87374496459961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2779,78,'TGO-GLF','Golfe',1.25176346302032,6.19332838058472);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2780,78,'TGO-HAH','Haho',1.26749992370605,7.06569862365723);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2781,78,'TGO-KLT','Kloto',0.759305536746979,6.96859502792358);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2782,78,'TGO-KRN','Keran',0.920833289623261,10.0325345993042);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2783,78,'TGO-KZH','Kozah',1.15663230419159,9.58832263946533);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2784,78,'TGO-LAC','Lacs',1.59744107723236,6.37211656570435);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2785,78,'TGO-NYL','Nyala',1.42569434642792,8.82376098632813);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2786,78,'TGO-OGO','Ogou',1.31979370117188,7.72763633728027);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2787,78,'TGO-OTI','Oti',0.559985987842083,10.2924709320068);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2788,78,'TGO-SOT','Sotouboua',0.823867470026016,8.46600341796875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2789,78,'TGO-TCD','Tchaoudjo',1.1630927324295,8.99133014678955);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2790,78,'TGO-TON','Tone',0.38410396873951,10.8301048278809);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2791,78,'TGO-VOO','Vo',1.4908332824707,6.3801155090332);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2792,78,'TGO-WAW','Wawa',0.779741406440735,7.67509841918945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2794,78,'TGO-YOT','Yoto',1.44815599918365,6.66588640213013);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2795,78,'TGO-ZIO','Zio',1.06407815217972,6.49294805526733);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2796,79,'TUN-AKA','Al Kaf',8.70541572570801,36.030689239502);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2797,79,'TUN-AMH','Al Mahdiyah',10.6509704589844,35.3344078063965);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2798,79,'TUN-AMN','Al Munastir',10.7562828063965,35.6221313476563);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2799,79,'TUN-AQS','Al Qasrayn',8.79854965209961,35.2273559570313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2800,79,'TUN-AQY','Al Qayrawan',9.78844261169434,35.5734329223633);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2801,79,'TUN-ARY','Aryanah',9.94285297393799,36.8491706848145);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2802,79,'TUN-BAJ','Bajah',9.37619686126709,36.7557411193848);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2803,79,'TUN-BNR','Bin ''Arus',10.1933498382568,36.6167259216309);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2804,79,'TUN-BNZ','Banzart',9.57610988616943,37.1415252685547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2805,79,'TUN-JND','Jundubah',8.62958240509033,36.6844482421875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2806,79,'TUN-MDN','Madaniyin',10.6619434356689,33.0788879394531);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2807,79,'TUN-NAB','Nabul',10.7188873291016,36.7465629577637);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2808,79,'TUN-QAB','Qabis',9.85637950897217,33.7908325195313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2809,79,'TUN-QBL','Quibili',8.8559718132019,33.3679695129395);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2810,79,'TUN-QFS','Qafsah',8.79291534423828,34.4206886291504);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2811,79,'TUN-SBZ','Sidi Bu Zayd',9.43402671813965,34.8658294677734);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2812,79,'TUN-SFQ','Safaqis',10.5079507827759,34.6986045837402);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2813,79,'TUN-SLY','Silyanah',9.33819198608398,35.9674949645996);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2814,79,'TUN-SUS','Susah',10.4234132766724,35.9512557983398);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2815,79,'TUN-TTW','Tatawin',9.85243511199951,31.7488594055176);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2816,79,'TUN-TUN','Tunis',10.1899995803833,36.7871627807617);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2817,79,'TUN-TWZ','Tawzar',8.08041620254517,33.9760627746582);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2818,79,'TUN-ZGH','Zaghwan',9.96833229064941,36.329158782959);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2819,80,'UGA-BUS','Busoga',33.4103469848633,0.259860992431641);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2820,80,'UGA-CNT','Central',32.0036087036133,0.223851606249809);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2821,80,'UGA-EST','Eastern',33.9073104858398,1.31823278963566);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2822,80,'UGA-KRM','Karamoja',34.2604789733887,2.8106644153595);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2823,80,'UGA-NIL','Nile',31.3997192382813,2.99003624916077);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2824,80,'UGA-NRB','North Buganda',32.2434730529785,0.340333580970764);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2825,80,'UGA-NRT','Northern',32.5409736633301,2.67027759552002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2826,80,'UGA-STB','South Buganda',31.9606952667236,-0.388888999819756);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2827,80,'UGA-STH','Southern',30.4216651916504,-0.631110727787018);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2828,80,'UGA-WST','Western',31.018461227417,1.0790276825428);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2829,81,'ZAR-BAN','Bandundu',18.4486837387085,-4.42166745662689);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2830,81,'ZAR-BZA','Bas-Zaire',14.2459077835083,-5.14708375930786);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2831,81,'ZAR-EQT','Equateur',20.4749183654785,1.3108081817627);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2832,81,'ZAR-HZA','Haut-Zaire',26.7945823669434,1.63499975204468);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2833,81,'ZAR-KIV','Kivu',27.2185745239258,-2.01880121231079);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2834,81,'ZAR-KNS','Kinshasa',15.8497180938721,-4.48831033706665);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2835,81,'ZAR-KOC','Kasai-Occidental',21.7145118713379,-5.13763904571533);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2836,81,'ZAR-KOR','Kasai-Oriental',24.0841159820557,-4.83638918399811);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2837,81,'ZAR-SHA','Shaba',26.2599239349365,-9.22902870178223);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2838,82,'ZMB-CNT','Central',28.378776550293,-13.8722267150879);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2839,82,'ZMB-CPP','Copperbelt',27.9273586273193,-13.0777950286865);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2840,82,'ZMB-EST','Eastern',31.8473873138428,-12.6458587646484);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2841,82,'ZMB-LUA','Luapula',29.4072208404541,-10.4170198440552);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2842,82,'ZMB-LUS','Lusaka',29.0917682647705,-15.3063097000122);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2843,82,'ZMB-NRT','Northern',31.3914165496826,-10.8132476806641);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2844,82,'ZMB-NWS','North-Western',24.798225402832,-12.7947225570679);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2845,82,'ZMB-STH','Southern',26.9566097259521,-16.6825075149536);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2846,82,'ZMB-WST','Western',23.7730579376221,-15.6533346176147);
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2847,30,'CHE-AAR','Aargau',8.06652784347534,47.3777732849121);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2848,30,'CHE-AIR','Appenzell Inner-Rhoden',9.44957208633423,47.3379802703857);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2849,30,'CHE-ASR','Appenzell Ausser-Rhoden',9.40218877792358,47.3508758544922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2850,30,'CHE-BER','Bern',7.64508104324341,46.8981342315674);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2851,30,'CHE-BLN','Basel-Landschaft',7.71489691734314,47.4479808807373);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2852,30,'CHE-BST','Basel-Stadt',7.61180448532104,47.5622463226318);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2853,30,'CHE-FRB','Fribourg',7.05912446975708,46.708122253418);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2854,30,'CHE-GEN','Geneve',6.11902713775635,46.2666568756104);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2855,30,'CHE-GLR','Glarus',9.05834102630615,46.9859657287598);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2856,30,'CHE-GRB','Graubunden',9.5714898109436,46.6190242767334);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2857,30,'CHE-JUR','Jura',7.17942023277283,47.3337440490723);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2858,30,'CHE-LZR','Luzern',8.16353559494019,47.0287494659424);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2859,30,'CHE-NCH','Neuchatel',6.76555466651917,47.0008449554443);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2860,30,'CHE-NDW','Nidwalden',8.38851881027222,46.893440246582);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2861,30,'CHE-OBW','Obwalden',8.26431751251221,46.8609142303467);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2862,30,'CHE-SCH','Schaffhausen',8.64498233795166,47.6829090118408);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2863,30,'CHE-SCW','Schwyz',8.68734550476074,47.0505218505859);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2864,30,'CHE-SGL','Sankt Gallen',9.21930599212646,47.2319660186768);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2865,30,'CHE-SLT','Solothurn',7.67323637008667,47.2854347229004);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2866,30,'CHE-THR','Thurgau',9.07845830917358,47.5379638671875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2867,30,'CHE-TIC','Ticino',8.75485754013062,46.2282390594482);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2868,30,'CHE-URI','Uri',8.6767749786377,46.7543411254883);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2869,30,'CHE-VAL','Valais',7.6173677444458,46.2655735015869);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2870,30,'CHE-VAU','Vaud',6.65876841545105,46.5983505249023);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2871,30,'CHE-ZRC','Zurich',8.66058206558228,47.4263591766357);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2872,30,'CHE-ZUG','Zug',8.53069877624512,47.1544284820557);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2873,31,'GBR-ENG-AVO','Avon',-2.61736142635345,51.4724788665771);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2874,31,'GBR-ENG-BCK','Buckinghamshire',-0.806551486253738,51.8341655731201);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2875,31,'GBR-ENG-BDF','Bedfordshire',-0.40930599719286,52.0552444458008);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2876,31,'GBR-ENG-BRK','Berkshire',-1.04862299561501,51.4465198516846);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2877,31,'GBR-ENG-CHS','Cheshire',-2.53772854804993,53.20485496521);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2878,31,'GBR-ENG-CLV','Cleveland',-1.10694450139999,54.593189239502);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2879,31,'GBR-ENG-CMB','Cambridgeshire',0.0132599920034409,52.3638801574707);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2880,31,'GBR-ENG-CMR','Cumbria',-2.89222252368927,54.6199703216553);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2881,31,'GBR-ENG-CRN','Cornwall',-5.27083396911621,50.4069404602051);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2882,31,'GBR-ENG-DEV','Devonshire',-3.7783340215683,50.7248592376709);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2883,31,'GBR-ENG-DRB','Derbyshire',-1.58944445848465,53.1083297729492);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2884,31,'GBR-ENG-DRH','Durham',-1.8016664981842,54.6731948852539);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2885,31,'GBR-ENG-DRS','Dorsetshire',-2.31076401472092,50.8033294677734);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2886,31,'GBR-ENG-ESS','East Sussex',0.321111001074314,50.9413890838623);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2887,31,'GBR-ENG-ESX','Essex',0.64124997658655,51.7641639709473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2888,31,'GBR-ENG-GLC','Gloucestershire',-2.15041697025299,51.8415260314941);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2889,31,'GBR-ENG-GLN','Greater London',-0.0805389881134033,51.4858245849609);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2890,31,'GBR-ENG-GMN','Greater Manchest',-2.3246054649353,53.5089683532715);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2891,31,'GBR-ENG-HAW','Hereford and Wor',-2.44375056028366,52.1297492980957);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2892,31,'GBR-ENG-HMB','Humbersidev',-0.477777510881424,53.798469543457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2893,31,'GBR-ENG-HMP','Hampshire',-1.3376390337944,51.0432243347168);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2894,31,'GBR-ENG-HRT','Hertfordshire',-0.265416510403156,51.8303546905518);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2895,31,'GBR-ENG-IOW','Isle of Wight',-1.3148609995842,50.6750011444092);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2896,31,'GBR-ENG-KEN','Kent',0.746851997449994,51.2002735137939);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2897,31,'GBR-ENG-LCS','Leicestershire',-0.99916698038578,52.6697750091553);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2898,31,'GBR-ENG-LNC','Lancashire',-2.54611647129059,53.8647155761719);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2899,31,'GBR-ENG-LNL','Lincolnshire',-0.226666480302811,53.1222896575928);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2900,31,'GBR-ENG-MRS','Merseyside',-2.87931406497955,53.4933986663818);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2901,31,'GBR-ENG-NRF','Norfolkshire',0.953029975295067,52.6680507659912);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2902,31,'GBR-ENG-NRH','Northumberland',-2.06851094961166,55.2923603057861);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2903,31,'GBR-ENG-NRT','Northamptonshire',-0.82837401330471,52.3064556121826);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2904,31,'GBR-ENG-NTT','Nottinghamshire',-0.983194530010223,53.1298942565918);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2905,31,'GBR-ENG-NYR','North Yorkshire',-1.37595898658037,54.0883293151855);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2906,31,'GBR-ENG-OXF','Oxfordshire',-1.28874999284744,51.8048210144043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2907,31,'GBR-ENG-SAL','Salop',-2.72055554389954,52.6466045379639);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2908,31,'GBR-ENG-SFF','Suffolk',1.06041650474072,52.2352752685547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2909,31,'GBR-ENG-SMR','Somersetshire',-3.03166651725769,51.0750255584717);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2910,31,'GBR-ENG-SRR','Surrey',-0.388055488467216,51.2743511199951);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2911,31,'GBR-ENG-STF','Staffordshire',-2.01513904333115,52.8177700042725);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2912,31,'GBR-ENG-SYR','South Yorkshire',-1.33569449186325,53.4748592376709);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2913,31,'GBR-ENG-TAW','Tyne and Wear',-1.59805601835251,54.9346103668213);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2914,31,'GBR-ENG-WLT','Wiltshire',-1.91888850927353,51.324161529541);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2915,31,'GBR-ENG-WMD','West Midlands',-1.81611150503159,52.5012493133545);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2916,31,'GBR-ENG-WRW','Warwickshire',-1.5548614859581,52.3159656524658);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2917,31,'GBR-ENG-WSS','West Sussex',-0.457916492596269,50.9433250427246);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2918,31,'GBR-ENG-WYR','West Yorkshire',-1.68541651964188,53.7393989562988);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2919,32,'GBR-NIR-ANT','Antrim',-6.24958348274231,54.6994400024414);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2920,32,'GBR-NIR-ARD','Ards',-5.62694501876831,54.5011043548584);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2921,32,'GBR-NIR-ARM','Armagh',-6.62000060081482,54.322774887085);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2922,32,'GBR-NIR-BLF','Belfast',-5.93680596351624,54.6016693115234);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2923,32,'GBR-NIR-BLL','Ballymena',-6.22750115394592,54.9024963378906);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2924,32,'GBR-NIR-BLY','Ballymoney',-6.40317249298096,55.0299949645996);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2925,32,'GBR-NIR-BNB','Banbridge',-6.17152810096741,54.3431911468506);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2926,32,'GBR-NIR-CKS','Cookstown',-6.75347256660461,54.6448554992676);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2927,32,'GBR-NIR-CLR','Coleraine',-6.68875050544739,55.0658302307129);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2928,32,'GBR-NIR-CRG','Craigavon',-6.39704155921936,54.4731903076172);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2929,32,'GBR-NIR-CRR','Carrickfergus',-5.79618120193481,54.7295799255371);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2930,32,'GBR-NIR-CST','Castlereagh',-5.85402798652649,54.5492992401123);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2931,32,'GBR-NIR-DNG','Dungannon',-6.95956158638,54.4493007659912);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2932,32,'GBR-NIR-DOW','Down',-5.80611181259155,54.3306903839111);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2933,32,'GBR-NIR-FRM','Fermanagh',-7.65652799606323,54.3590793609619);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2934,32,'GBR-NIR-LAR','Larne',-5.89423656463623,54.9036102294922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2935,32,'GBR-NIR-LMV','Limavady',-6.97138953208923,55.0026359558105);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2936,32,'GBR-NIR-LND','Londonderry',-7.21250414848328,54.9382095336914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2937,32,'GBR-NIR-LSB','Lisburn',-6.0822229385376,54.4995784759521);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2938,32,'GBR-NIR-MGH','Magherafelt',-6.71987199783325,54.8205013275146);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2939,32,'GBR-NIR-MOY','Moyle',-6.2622230052948,55.1456890106201);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2940,32,'GBR-NIR-NAM','Newry and Mourne',-6.26764011383057,54.1522197723389);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2941,32,'GBR-NIR-NDO','North Down',-5.71829509735107,54.6469402313232);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2942,32,'GBR-NIR-NWT','Newtownabbey',-5.98111152648926,54.7223606109619);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2943,32,'GBR-NIR-OMG','Omagh',-7.31152844429016,54.5911102294922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2944,32,'GBR-NIR-STR','Strabane',-7.41138958930969,54.7723045349121);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2945,33,'GBR-SCT-BRD','Borders',-2.77819454669952,55.530345916748);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2946,33,'GBR-SCT-CNT','Central',-4.17338299751282,56.2180500030518);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2947,33,'GBR-SCT-DAG','Dumfries and Gal',-4.01812505722046,55.0448551177979);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2948,33,'GBR-SCT-FYF','Fyfe',-3.16012358665466,56.2312488555908);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2949,33,'GBR-SCT-GRM','Grampian',-2.77944457530975,57.2326354980469);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2950,33,'GBR-SCT-HGH','Highland',-4.8991664648056,57.5933284759521);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2951,33,'GBR-SCT-LTH','Lothian',-3.09161591529846,55.8866653442383);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2952,33,'GBR-SCT-ORK','Orkney',-2.89875054359436,59.0629138946533);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2953,33,'GBR-SCT-SHT','Shetland Islands',-1.41847252845764,60.1762447357178);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2954,33,'GBR-SCT-STT','Strathclyde',-5.19263911247253,55.8406887054443);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2955,33,'GBR-SCT-TYS','Tayside',-3.57138895988464,56.5564842224121);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2956,33,'GBR-SCT-WIS','Western Isles',-7.38416719436646,57.646800994873);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2957,34,'GBR-WLS-CLW','Clwyd',-3.24208343029022,53.0631904602051);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2958,34,'GBR-WLS-DYF','Dyfed',-4.49125051498413,52.0751342773438);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2959,34,'GBR-WLS-GWN','Gwent',-2.97013902664185,51.7436046600342);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2960,34,'GBR-WLS-GWY','Gwynedd',-4.09209835529327,52.9827747344971);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2961,34,'GBR-WLS-MGL','Mid Glamorgan',-3.4186840057373,51.6244659423828);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2962,34,'GBR-WLS-PWY','Powys',-3.43995904922485,52.3108062744141);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2963,34,'GBR-WLS-SGL','South Glamorgan',-3.31922352313995,51.4658298492432);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2964,34,'GBR-WLS-WGL','West Glamorgan',-3.92041754722595,51.6630554199219);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2965,35,'UKR-CHH','Chernigov',31.9974937438965,51.3648147583008);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2966,35,'UKR-CHK','Cherkassy',31.2102718353271,49.351936340332);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2967,35,'UKR-CHV','Chernovtsy',26.2230930328369,48.1943359375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2968,35,'UKR-DNP','Dnepropetrovsk',34.9540176391602,48.3280410766602);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2969,35,'UKR-DNT','Donetsk',37.8134651184082,48.053394317627);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2970,35,'UKR-IVF','Ivano-Frankovsk',24.5925979614258,48.6181869506836);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2971,35,'UKR-KKV','Khar''kov',36.4479064941406,49.4990196228027);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2972,35,'UKR-KML','Khmel''nitskiy',27.0184688568115,49.5049934387207);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2973,35,'UKR-KRM','Crimean',34.5588760375977,45.307487487793);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2974,35,'UKR-KRN','Kherson',33.3905982971191,46.6613616943359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2975,35,'UKR-KVG','Kirovograd',31.839391708374,48.5047912597656);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2976,35,'UKR-KYV','Kiev',30.7030277252197,50.3349952697754);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2977,35,'UKR-LHN','Lugansk',39.013484954834,48.9461059570313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2978,35,'UKR-LVV','L''viv',24.0447177886963,49.6760787963867);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2979,35,'UKR-MKL','Nikolayev',31.6713886260986,47.3477668762207);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2980,35,'UKR-ODS','Odessa',29.7626361846924,46.7169380187988);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2981,35,'UKR-PLT','Poltava',33.7701454162598,49.6440238952637);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2982,35,'UKR-RVN','Rovno',26.3962345123291,50.9760513305664);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2983,35,'UKR-SUM','Sumy',34.3143196105957,51.2416610717773);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2984,35,'UKR-TRN','Ternopl''',25.5466690063477,49.3851318359375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2985,35,'UKR-VLY','Volyn',24.8509254455566,51.127513885498);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2986,35,'UKR-VNT','Vinnitsa',28.7227745056152,48.9459648132324);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2987,35,'UKR-ZKP','Zakarpats''ka',23.3836355209351,48.4980506896973);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2988,35,'UKR-ZPR','Zaporozh''ye',35.713680267334,47.1927299499512);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2989,35,'UKR-ZTM','Zhitomir',28.4671020507813,50.6213836669922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2990,36,'GBR-ENG','England',-0.827719351724839,52.2296397906823);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2991,36,'GBR-NIR','Northern Ireland',-6.95361479449271,54.6617893613778);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2992,36,'GBR-SCT','Scotland',-4.23532998018595,56.8858405730834);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2993,36,'GBR-WLS','Wales',-3.5460041660316,52.0475537265661);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2994,37,'DZA-ADF','Ain Defla',2.13920199871063,36.1502742767334);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2995,37,'DZA-ADR','Adrar',-0.866284966468811,25.2780389785767);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2996,37,'DZA-ALG','Alger',3.02638792991638,36.7707176208496);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2997,37,'DZA-ANN','Annaba',7.52152347564697,36.8531246185303);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2998,37,'DZA-ATM','Ain Temouchent',-0.99148091673851,35.3606376647949);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(2999,37,'DZA-BAT','Batna',5.74919152259827,35.4644947052002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3000,37,'DZA-BBA','Bourdj Bou Arrer',4.68342971801758,36.0866718292236);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3001,37,'DZA-BCH','Bechar',-2.69815728068352,30.2385597229004);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3002,37,'DZA-BEJ','Bejaia',4.93695497512817,36.5575160980225);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3003,37,'DZA-BLI','Blida',3.01770377159119,36.5332851409912);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3004,37,'DZA-BMR','Boumerdes',3.59099102020264,36.7275009155273);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3005,37,'DZA-BOU','Bouira',3.83458137512207,36.272439956665);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3006,37,'DZA-BSK','Biskra',5.39415407180786,34.3430099487305);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3007,37,'DZA-CHL','Chlef',1.2236670255661,36.199577331543);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3008,37,'DZA-CNS','Constantine',6.66516304016113,36.3408050537109);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3009,37,'DZA-DJL','Djelfa',3.64698660373688,34.3101043701172);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3010,37,'DZA-EBY','El Bayadh',0.968424096703529,32.4250297546387);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3011,37,'DZA-EOD','El Oued',7.06661534309387,33.2496204376221);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3012,37,'DZA-ETR','El Tarf',8.11402487754822,36.6773986816406);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3013,37,'DZA-GHD','Ghardaia',3.37607640028,31.0033950805664);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3014,37,'DZA-GUE','Guelma',7.44608998298645,36.3749046325684);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3015,37,'DZA-ILL','Illizi',8.79995059967041,27.0019445419312);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3016,37,'DZA-JIJ','Jijel',5.93356037139893,36.7359867095947);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3017,37,'DZA-KHN','Khenchela',6.9155375957489,34.9091644287109);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3018,37,'DZA-LGH','Laghouat',2.71588939428329,33.6251544952393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3019,37,'DZA-MED','Medea',2.91188013553619,35.9583034515381);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3020,37,'DZA-MIL','Mila',6.04451584815979,36.2668704986572);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3021,37,'DZA-MSC','Mascara',0.168814837932587,35.3751373291016);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3022,37,'DZA-MSL','M''Sila',4.21488177776337,35.274772644043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3023,37,'DZA-MST','Mostaganem',0.307843200862408,35.9592170715332);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3024,37,'DZA-NAM','Naama',-0.851527886465192,33.2790260314941);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3025,37,'DZA-OEB','Oum el Bouaghi',6.98499894142151,35.8155784606934);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3026,37,'DZA-ORA','Oran',-0.566387355327606,35.6170406341553);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3027,37,'DZA-ORG','Ouargla',6.27699363231659,30.9353446960449);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3028,37,'DZA-RLZ','Relizane',0.874077305197716,35.8213844299316);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3029,37,'DZA-SAH','Souk Ahras',7.85041570663452,36.1740283966064);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3030,37,'DZA-SAI','Saida',0.249444395303726,34.605354309082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3031,37,'DZA-SBA','Sidi bel Abbes',-0.5722761657089,34.8218460083008);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3032,37,'DZA-SET','Setif',5.40244841575623,36.1110420227051);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3033,37,'DZA-SKK','Skikda',6.77729082107544,36.7833728790283);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3034,37,'DZA-TBS','Tebessa',7.69809150695801,35.0298538208008);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3035,37,'DZA-TIA','Tiaret',1.52419686317444,34.905834197998);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3036,37,'DZA-TLM','Tlemcen',-1.48263627290726,34.7088928222656);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3037,37,'DZA-TMN','Tamanghasset',6.20198699831963,24.1792917251587);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3038,37,'DZA-TND','Tindouf',-5.9232759475708,27.6857280731201);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3039,37,'DZA-TOU','Tizi Ouzou',4.18478202819824,36.6685962677002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3040,37,'DZA-TPZ','Tipaza',2.44094705581665,36.5976848602295);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3041,37,'DZA-TSS','Tissemsilt',1.75993371009827,35.7905502319336);
end;
/
prompt -- Asia
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3042,83,'AFG-BAM','Bamian',67.2981796264648,34.6849899291992);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3043,83,'AFG-BDG','Badghis',63.500545501709,35.2613639831543);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3044,83,'AFG-BDK','Badakhshan',72.4241104125977,36.9558372497559);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3045,83,'AFG-BGH','Baghlan',68.9049224853516,35.7662734985352);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3046,83,'AFG-BLK','Balkh',66.9244232177734,36.4216079711914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3047,83,'AFG-FAR','Farah',62.6205444335938,32.9369163513184);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3048,83,'AFG-FRY','Faryab',64.8151702880859,36.1251335144043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3049,83,'AFG-GHW','Ghowr',64.971809387207,34.2393341064453);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3050,83,'AFG-GHZ','Ghazni',67.8411712646484,33.1616554260254);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3051,83,'AFG-HER','Herat',62.4774932861328,34.5420761108398);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3052,83,'AFG-HLM','Helmand',64.1509590148926,31.4665203094482);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3053,83,'AFG-JWZ','Jowzjan',66.2056427001953,36.1981887817383);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3054,83,'AFG-KAB','Kabol',69.360954284668,34.5436058044434);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3055,83,'AFG-KAP','Kapisa',69.7909469604492,35.2698554992676);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3056,83,'AFG-KNR','Konarha',71.0620651245117,35.2954139709473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3057,83,'AFG-KNZ','Konduz',68.6587219238281,36.8426284790039);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3058,83,'AFG-LGH','Laghman',70.2216491699219,35.056526184082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3059,83,'AFG-LWG','Lowgar',69.2645645141602,34.0171699523926);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3060,83,'AFG-NMR','Nimruz',62.1516380310059,30.70166015625);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3061,83,'AFG-NNG','Nangarhar',70.3245697021484,34.3924903869629);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3062,83,'AFG-ORZ','Oruzgan',66.2827606201172,33.3280487060547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3063,83,'AFG-PAK','Paktia',69.5653991699219,33.5949249267578);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3064,83,'AFG-PKT','Paktika',68.7444305419922,32.51735496521);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3065,83,'AFG-PRV','Parvan',68.8600997924805,34.9894409179688);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3066,83,'AFG-QND','Quandahar',66.0422286987305,31.0330505371094);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3067,83,'AFG-SMN','Samangan',67.6523742675781,36.3040161132813);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3068,83,'AFG-TKH','Takhar',69.7184448242188,36.6545753479004);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3069,83,'AFG-VRD','Vardak',68.3049850463867,34.2388305664063);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3070,83,'AFG-ZAB','Zabol',67.1752624511719,32.061882019043);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3071,84,'BHR-AMG','Al Mintaqah al Gharbiyah',50.513988494873,26.003927230835);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3072,84,'BHR-AMH','Al Muharraq',50.629581451416,26.2668037414551);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3073,84,'BHR-AMN','Al Manamah',50.5786380767822,26.2149963378906);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3074,84,'BHR-AMS','Al Mintaqah ash Shamaliyah',50.4781684875488,26.2043924331665);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3075,84,'BHR-AMW','Al Mintaqah al Wusta',50.5400638580322,26.1676149368286);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3076,84,'BHR-ARM','Ar Rifa wa al Mintaqah al Janubiyah',50.5650100708008,25.9831161499023);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3077,84,'BHR-JHF','Jidd Hafs',50.5203628540039,26.2179975509644);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3078,84,'BHR-JHW','Juzur Hawar',50.7820777893066,25.663330078125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3079,84,'BHR-MHM','Madinat Hamad',50.5130405426025,26.1052598953247);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3080,84,'BHR-MIS','Madinat Isa',50.558614730835,26.1656055450439);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3081,84,'BHR-STR','Sitrah',50.6004867553711,26.1207237243652);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3082,85,'BGD-BRS','Barisal',90.4633178710938,22.4291715621948);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3083,85,'BGD-CHT','Chittagong',91.5646667480469,22.9729099273682);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3084,85,'BGD-DAK','Dhaka',90.3287086486816,24.0997333526611);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3085,85,'BGD-KHL','Khulna',89.2919235229492,22.903395652771);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3086,85,'BGD-RJS','Rajshahi',88.9538726806641,25.2270240783691);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3087,86,'BTN-BMT','Bumthang',90.7874946594238,27.7246551513672);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3088,86,'BTN-CHH','Chhukha',89.5700874328613,27.013689994812);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3089,86,'BTN-CHR','Chirang',90.060977935791,26.9882249832153);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3090,86,'BTN-DAG','Daga',89.8672256469727,27.1068897247314);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3091,86,'BTN-GYL','Geylegphug',90.2924728393555,26.9254493713379);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3092,86,'BTN-HA_','Ha',89.1755447387695,27.3223743438721);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3093,86,'BTN-LHN','Lhuntshi',91.1427993774414,27.7304592132568);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3094,86,'BTN-MNG','Mongar',91.2297134399414,27.2203855514526);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3095,86,'BTN-PAR','Paro',89.3552436828613,27.5195207595825);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3096,86,'BTN-PMG','Pemagatsel',91.3511428833008,27.0254755020142);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3097,86,'BTN-PNK','Punakha',89.9584045410156,27.9279775619507);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3098,86,'BTN-SDJ','Samdrup Jongkhar',91.5354614257813,26.9730529785156);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3099,86,'BTN-SHM','Shemgang',90.8508834838867,27.0928201675415);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3100,86,'BTN-SMC','Samchi',89.0667572021484,27.0995788574219);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3101,86,'BTN-THM','Thimphu',89.6286964416504,27.5787525177002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3102,86,'BTN-TNG','Tongsa',90.5186004638672,27.419189453125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3103,86,'BTN-TSH','Tashigang',91.6984481811523,27.4614362716675);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3104,86,'BTN-WNP','Wangdi Phodrang',90.0981674194336,27.5952253341675);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3105,87,'KHM-BTD','Batdambang',103.109676361084,13.3064365386963);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3106,87,'KHM-KCH','Kampong Cham',105.653408050537,12.0582141876221);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3107,87,'KHM-KCN','Kampong Chhnang',104.54455947876,12.167914390564);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3108,87,'KHM-KKO','Kaoh Kong',103.521606445313,11.3904142379761);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3109,87,'KHM-KMP','Kampot',104.115673065186,10.7917594909668);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3110,87,'KHM-KND','Kandal',104.959548950195,11.4129104614258);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3111,87,'KHM-KRC','Kracheh',106.19068145752,12.6666650772095);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3112,87,'KHM-KSP','Kampong Spoe',104.29052734375,11.5719423294067);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3113,87,'KHM-KTH','Kampong Thum',104.967926025391,12.8301372528076);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3114,87,'KHM-MKI','Mondol Kiri',106.976837158203,12.7344427108765);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3115,87,'KHM-PPE','Phnum Penh',104.913856506348,11.556526184082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3116,87,'KHM-PTH','Pouthisat',103.573162078857,12.3863434791565);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3117,87,'KHM-PVE','Prey Veng',105.464694976807,11.364164352417);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3118,87,'KHM-PVI','Preah Vihear',105.146377563477,13.7740259170532);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3119,87,'KHM-RTN','Rotanokiri',107.108882904053,13.9359750747681);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3120,87,'KHM-SOM','Siemreab-Otdar Meanchey',103.863712310791,13.5839228630066);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3121,87,'KHM-SRI','Svay Rieng',105.897338867188,11.1822834014893);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3122,87,'KHM-STR','Stoeng Treng',106.180541992188,13.849730014801);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3123,87,'KHM-TAK','Takev',104.807193756104,10.9389181137085);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3124,88,'CHN-ANH','Anhui',117.252754211426,32.0263843536377);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3125,88,'CHN-BJN','Beijing',116.467346191406,40.2090187072754);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3126,88,'CHN-FUJ','Fujian',118.130546569824,25.9433288574219);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3127,88,'CHN-GAN','Gansu',101.10082244873,37.6949920654297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3128,88,'CHN-GND','Guangdong',113.418083190918,22.876106262207);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3129,88,'CHN-GNG','Guangxi',108.266510009766,23.6970806121826);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3130,88,'CHN-GUI','Guizhou',106.559432983398,26.9395790100098);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3131,88,'CHN-HAI','Hainan',109.824012756348,19.1512451171875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3132,88,'CHN-HEB','Hebei',116.64387512207,39.3372116088867);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3133,88,'CHN-HEN','Henan',113.475933074951,33.8741626739502);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3134,88,'CHN-HKG','Hong Kong',114.106517791748,22.3749961853027);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3135,88,'CHN-HLN','Heilongjiang',127.969291687012,48.491382598877);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3136,88,'CHN-HUB','Hubei',112.255096435547,31.1606311798096);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3137,88,'CHN-HUN','Hunan',111.510681152344,27.3818016052246);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3138,88,'CHN-JIL','Jilin',126.479431152344,43.5759544372559);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3139,88,'CHN-JNG','Jiangxi',116.016094207764,27.2859668731689);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3140,88,'CHN-JNS','Jiangsu',119.137393951416,32.9370784759521);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3141,88,'CHN-LNN','Liaoning',122.31067276001,41.0955467224121);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3142,88,'CHN-NMN','Nei Mongol',111.693176269531,45.3698539733887);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3143,88,'CHN-NNG','Ningxia',105.977195739746,37.3305130004883);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3144,88,'CHN-QNG','Qinghai',96.2525863647461,35.4833278656006);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3145,88,'CHN-SCH','Sichuan',103.782600402832,30.1420803070068);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3146,88,'CHN-SHA','Shaanxi',108.472206115723,35.6424942016602);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3147,88,'CHN-SHD','Shandong<',118.718322753906,36.3275032043457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3148,88,'CHN-SHN','Shanghai',121.375129699707,31.2540283203125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3149,88,'CHN-SHX','Shanxi',112.389976501465,37.6679916381836);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3150,88,'CHN-TNJ','Tianjin',117.346794128418,39.4074325561523);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3151,88,'CHN-XNJ','Xinjiang',85.0078353881836,41.7616691589355);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3152,88,'CHN-XZN','Xizang',88.7494812011719,31.926383972168);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3153,88,'CHN-YNN','Yunnan',101.86400604248,25.1811561584473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3154,88,'CHN-ZHJ','Zhejiang',120.209289550781,29.1756896972656);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3155,89,'CYP-FMG','Farmagusta',34.0693092346191,35.3248596191406);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3156,89,'CYP-KYR','Kyrenia',33.286958694458,35.3144969940186);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3157,89,'CYP-LMS','Limassol',32.9569396972656,34.7616901397705);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3158,89,'CYP-LRN','Larnaca',33.5124969482422,34.9092178344727);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3159,89,'CYP-NIC','Nicosia',33.0783309936523,35.0847549438477);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3160,89,'CYP-PPH','Paphos',32.5206909179688,34.915412902832);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3161,90,'IND-AAN','Andaman and Nicobar Islands',93.2545700073242,10.212776184082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3162,90,'IND-APD','Arunachal Pradesh',94.4877624511719,28.056661605835);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3163,90,'IND-APR','Andhra Pradesh',80.7636032104492,16.2270951271057);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3164,90,'IND-ASS','Assam',92.8517684936523,26.0530996322632);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3165,90,'IND-BIH','Bihar',85.7970428466797,24.7426385879517);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3166,90,'IND-CHN','Chandigarh',76.7640190124512,30.7243099212646);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3167,90,'IND-DAD','Daman & Diu',72.8620758056641,20.3993492126465);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3168,90,'IND-DAN','Dadra and Nagar Haveli',73.1125793457031,20.1805505752563);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3169,90,'IND-DEL','Delhi',77.0991325378418,28.6400098800659);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3170,90,'IND-GJR','Gujarat',71.3092842102051,22.3927154541016);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3171,90,'IND-GOA','Goa',74.0295562744141,15.3331670761108);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3172,90,'IND-HPR','Himachal Pradesh',77.324779510498,31.7789354324341);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3173,90,'IND-HRY','Haryana',76.0145721435547,29.2851505279541);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3174,90,'IND-JAK','Jammu & Kashmir',76.6633224487305,33.8840026855469);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3175,90,'IND-KER','Kerala',76.1282844543457,10.5454745292664);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3176,90,'IND-KRN','Karnataka',76.3390121459961,15.00825548172);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3177,90,'IND-LKS','Lakshadweep',72.8938751220703,9.97333145141602);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3178,90,'IND-MGH','Meghalaya',91.3117980957031,25.5461750030518);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3179,90,'IND-MHR','Maharashtra',76.8220863342285,18.8147296905518);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3180,90,'IND-MNP','Manipur',93.860481262207,24.756103515625);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3181,90,'IND-MPR','Madhya Pradesh',79.2299995422363,22.3095550537109);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3182,90,'IND-MZR','Mizoram',92.8470687866211,23.2430429458618);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3183,90,'IND-NGL','Nagaland',94.2891502380371,26.0844602584839);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3184,90,'IND-ORS','Orissa',84.5037841796875,20.1857051849365);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3185,90,'IND-PND','Pondicherry',78.9173164367676,13.7997393608093);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3186,90,'IND-PNJ','Punjab',75.382022857666,31.0395002365112);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3187,90,'IND-RJS','Rajasthan',73.8735809326172,26.6030111312866);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3188,90,'IND-SKK','Sikkim',88.4638595581055,27.5909013748169);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3189,90,'IND-TNA','Tamil Nadu',78.2966842651367,10.7926516532898);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3190,90,'IND-TRP','Tripura',91.7422828674316,23.7348566055298);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3191,90,'IND-UPR','Uttar Pradesh',80.8586730957031,27.6626014709473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3192,90,'IND-WBN','West Bengal',87.8276672363281,24.3456630706787);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3193,91,'IDN-ACE','Aceh',96.6469116210938,3.96249938011169);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3194,91,'IDN-BAL','Bali',115.08012008667,-8.4556941986084);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3195,91,'IDN-BNG','Bengkulu',102.385879516602,-3.86852085590363);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3196,91,'IDN-IJA','Irian Jaya',135.361404418945,-4.56856997124851);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3197,91,'IDN-JAM','Jambi',102.793491363525,-1.72352927923203);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3198,91,'IDN-JBA','Jawa Barat',106.949569702148,-6.84472179412842);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3199,91,'IDN-JRA','Jakarta Raya',106.83544921875,-6.20999097824097);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3200,91,'IDN-JTI','Jawa Timur',113.202217102051,-7.25625085830688);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3201,91,'IDN-JTN','Jawa Tengah',110.176708221436,-7.305832862854);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3202,91,'IDN-KBA','Kalimantan Barat',111.392200469971,-0.504267930984497);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3203,91,'IDN-KSL','Kalimantan Selatan',115.486103057861,-3.15353775024414);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3204,91,'IDN-KTI','Kalimantan Timur',116.363315582275,1.04902720451355);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3205,91,'IDN-KTN','Kalimantan Tengah',113.25426864624,-1.40655612945557);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3206,91,'IDN-LMP','Lampung',104.758018493652,-4.82555174827576);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3207,91,'IDN-MAL','Maluku',129.593456268311,-2.86111116409302);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3208,91,'IDN-NTB','Nusa Tenggara Barat',117.51432800293,-8.59680557250977);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3209,91,'IDN-NTT','Nusa Tenggara Timur',122.048496246338,-9.5);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3210,91,'IDN-RIA','Riau',104.556930541992,1.79173278808594);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3211,91,'IDN-SBA','Sumatera Barat',100.207618713379,-1.20027050375938);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3212,91,'IDN-SSL','Sulawesi Selatan',120.234630584717,-4.12943270802498);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3213,91,'IDN-SST','Sumatera Selatan',105.173210144043,-3.22601103782654);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3214,91,'IDN-STG','Sulawesi Tenggara',122.490810394287,-5.15012109279633);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3215,91,'IDN-STN','Sulawesi Tengah',121.684906005859,-0.946666717529297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3216,91,'IDN-SUA','Sumatera Utara',98.7394943237305,1.83777660131454);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3217,91,'IDN-SUT','Sulawesi Utara',123.925594329834,2.51333251595497);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3218,91,'IDN-TTI','Timor Timur',125.677345275879,-8.79973030090332);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3219,91,'IDN-YGY','Yogyakarta',110.417499542236,-7.8742356300354);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3220,92,'IRN-AEB','Azarbayjan-e Bakhtari',45.6852645874023,37.885684967041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3221,92,'IRN-AEK','Azarbayjan-e Khavari',46.9994316101074,38.2293281555176);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3222,92,'IRN-BAV','Kohkiluyeh va buyer Ahmadi',50.8048515319824,30.8425769805908);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3223,92,'IRN-BKH','Bakhtaran',46.7234420776367,34.4673728942871);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3224,92,'IRN-BUS','Bushehr',51.5112419128418,28.8095207214355);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3225,92,'IRN-BVS','Sistan va Baluchestan',61.0676307678223,28.2691631317139);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3226,92,'IRN-CMV','Chahar Mahall va Bakhtiari',50.5562438964844,31.9061031341553);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3227,92,'IRN-ESF','Esfahan',52.477352142334,32.687219619751);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3228,92,'IRN-FAR','Fars',53.0998573303223,29.457218170166);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3229,92,'IRN-GIL','Gilan',49.567756652832,37.5138740539551);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3230,92,'IRN-HMD','Hamadan',48.6047134399414,34.9198570251465);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3231,92,'IRN-HRM','Hormozgan',55.9664459228516,27.1959686279297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3232,92,'IRN-ILA','Ilam',46.8461036682129,33.0934867858887);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3233,92,'IRN-KHR','Khorasan',58.2973518371582,34.3386840820313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3234,92,'IRN-KHZ','Khuzestan',49.0184211730957,31.5216598510742);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3235,92,'IRN-KRD','Kordestan',46.8705863952637,35.634578704834);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3236,92,'IRN-KRM','Kerman',56.9680480957031,29.0457954406738);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3237,92,'IRN-LRS','Lorestan',48.4533271789551,33.5273513793945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3238,92,'IRN-MRK','Markazi',50.4215202331543,34.6245765686035);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3239,92,'IRN-MZN','Mazandaran',53.2856864929199,36.9494361877441);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3240,92,'IRN-SMN','Semnan',54.4922142028809,35.8415184020996);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3241,92,'IRN-TER','Tehran',51.7256851196289,35.6373519897461);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3242,92,'IRN-YAZ','Yazd',54.7615165710449,31.6422157287598);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3243,92,'IRN-ZNJ','Zanjan',49.0073204040527,36.351375579834);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3244,93,'IRQ-AAN','Al Anbar',41.4527626037598,33.6032409667969);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3245,93,'IRQ-ABS','Al Basrah',47.5556182861328,30.1932926177979);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3246,93,'IRQ-AMT','Al Muthanna',45.2747688293457,30.4015216827393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3247,93,'IRQ-ANA','An Najaf',43.8509540557861,31.093692779541);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3248,93,'IRQ-AQD','Al Qadisiyah',45.1083297729492,31.8433246612549);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3249,93,'IRQ-ASL','As Sulaymaniyah',45.4616584777832,35.570592880249);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3250,93,'IRQ-ATA','At Ta''min',44.1112442016602,35.3476333618164);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3251,93,'IRQ-BAB','Babil',44.5091934204102,32.6331825256348);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3252,93,'IRQ-BGH','Baghdad',44.4175567626953,33.3191566467285);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3253,93,'IRQ-DAH','Dahuk',43.3307228088379,36.865650177002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3254,93,'IRQ-DIY','Diyala<',45.1496162414551,34.1184616088867);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3255,93,'IRQ-DQA','Dhi Qar',46.3776245117188,31.2506542205811);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3256,93,'IRQ-IRB','Arbil<',44.1847152709961,36.3837432861328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3257,93,'IRQ-KRB','Karbala''',42.15744972229,31.8380737304688);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3258,93,'IRQ-MYS','Maysan',47.106273651123,31.991153717041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3259,93,'IRQ-NIN','Ninawa',42.5359573364258,35.8835258483887);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3260,93,'IRQ-SAD','Salah ad Din',44.1307640075684,34.5643157958984);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3261,93,'IRQ-WAS','Wasit',45.5250091552734,32.7227325439453);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3262,94,'ISR-HDR','Hadarom',34.8730926513672,30.6814079284668);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3263,94,'ISR-HEF','Hefa',35.0381927490234,32.6379547119141);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3264,94,'ISR-HMR','Hamerkaz',34.8591651916504,32.087495803833);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3265,94,'ISR-HZF','Hazafon',35.353328704834,32.8322334289551);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3266,94,'ISR-TAV','Tel Aviv',34.8087463378906,32.0948581695557);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3267,94,'ISR-YRS','Yerushalayim',35.0451374053955,31.7182140350342);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3268,95,'JPN-CGK','Chugoku',132.696350097656,35.0397186279297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3269,95,'JPN-CHB','Chubu',144.699829101563,30.9073543548584);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3270,95,'JPN-HKK','Hokkaido',142.614974975586,43.4406890869141);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3271,95,'JPN-KIN','Kinki',135.585952758789,34.6086044311523);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3272,95,'JPN-KNT','Kanto',139.605651855469,36.0169372558594);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3273,95,'JPN-KYS','Kyushu',130.255950927734,31.0184669494629);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3274,95,'JPN-OKN','Okinawa',127.105812072754,25.5529136657715);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3275,95,'JPN-SHK','Shikoku',133.384429931641,33.6434669494629);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3276,95,'JPN-THO','Tohoku',139.843139648438,39.1304168701172);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3277,96,'JPN-AIC','Aichi',137.223999023438,34.9766597747803);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3278,96,'JPN-AKI','Akita',140.331398010254,39.687219619751);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3279,96,'JPN-AOM','Aomori',140.76350402832,40.8693008422852);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3280,96,'JPN-CHI','Chiba',140.316749572754,35.4863796234131);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3281,96,'JPN-EHI','Ehime',132.843444824219,33.5913848876953);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3282,96,'JPN-FKS','Fukushima',140.094451904297,37.3715362548828);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3283,96,'JPN-FUK','Fukui',136.121948242188,35.7981853485107);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3284,96,'JPN-FUU','Fukuoka',130.615600585938,33.4651851654053);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3285,96,'JPN-GIF','Gifu',136.942497253418,35.787239074707);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3286,96,'JPN-GUM','Gumma',139.013847351074,36.5072784423828);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3287,96,'JPN-HKK','Hokkaido',142.579002380371,43.4544410705566);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3288,96,'JPN-HRS','Hiroshima',132.747596740723,34.5738754272461);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3289,96,'JPN-HYO','Hyogo',134.850151062012,34.9187450408936);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3290,96,'JPN-IBR','Ibaraki',140.258346557617,36.3301906585693);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3291,96,'JPN-ISH','Ishikawa',136.801651000977,36.7898502349854);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3292,96,'JPN-IWA','Iwate',141.359550476074,39.59547996521);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3293,96,'JPN-KAG','Kagawa',134.010551452637,34.2740001678467);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3294,96,'JPN-KGS','Kagoshima',129.796249389648,29.6627759933472);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3295,96,'JPN-KMM','Kumamoto',130.639503479004,32.6378345489502);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3296,96,'JPN-KNG','Kanagawa',139.342399597168,35.3829097747803);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3297,96,'JPN-KOC','Kochi',133.420753479004,33.2726345062256);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3298,96,'JPN-KYO','Kyoto',135.450706481934,35.225959777832);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3299,96,'JPN-MIE','Mie',136.38330078125,34.4619560241699);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3300,96,'JPN-MIY','Miyagi',140.972450256348,38.3781909942627);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3301,96,'JPN-MYZ','Miyazaki',131.284103393555,32.0974950790405);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3302,96,'JPN-NAG','Nagano',138.012397766113,36.1015186309814);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3303,96,'JPN-NAR','Nara',135.875793457031,34.2988586425781);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3304,96,'JPN-NGS','Nagasaki',129.483551025391,33.6256847381592);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3305,96,'JPN-NII','Niigata',138.747444152832,37.6377201080322);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3306,96,'JPN-OIT','Oita',131.457054138184,33.2267951965332);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3307,96,'JPN-OKN','Okinawa',129.527503967285,23.71875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3308,96,'JPN-OKY','Okayama',133.835205078125,34.8454151153564);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3309,96,'JPN-OSA','Osaka',135.40210723877,34.624755859375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3310,96,'JPN-SAG','Saga',130.137351989746,33.2559299468994);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3311,96,'JPN-SAI','Saitama',139.289398193359,36.0105495452881);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3312,96,'JPN-SHI','Shiga',136.093856811523,35.2297306060791);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3313,96,'JPN-SHM','Shimane',132.522651672363,35.3181858062744);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3314,96,'JPN-SHZ','Shizuoka',145.714851379395,29.9604396820068);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3315,96,'JPN-TCH','Tochigi',139.78784942627,36.6715202331543);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3316,96,'JPN-TKS','Tokushima',134.238899230957,33.8811435699463);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3317,96,'JPN-TOK','Tokyo',139.40975189209,35.6843910217285);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3318,96,'JPN-TOY','Toyama',137.245552062988,36.6161651611328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3319,96,'JPN-TTT','Tottori',133.820449829102,35.323766708374);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3320,96,'JPN-WKY','Wakayama',135.528999328613,33.9011001586914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3321,96,'JPN-YMC','Yamaguchi',131.619003295898,34.2455501556396);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3322,96,'JPN-YMG','Yamagata',140.085945129395,38.416820526123);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3323,96,'JPN-YMN','Yamanashi',138.641250610352,35.5572147369385);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3324,97,'JOR-ABA','Al Balqa''',35.7087478637695,31.9561061859131);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3325,97,'JOR-AKA','Al Karak',35.7852210998535,31.137809753418);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3326,97,'JOR-AMF','Al Mafraq',37.6227760314941,32.5629634857178);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3327,97,'JOR-AMM','''Amman',36.7174415588379,31.6736335754395);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3328,97,'JOR-ATF','At Tafilah',35.6738014221191,30.8141860961914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3329,97,'JOR-AZR','Az Zarqa',36.2219390869141,32.0959777832031);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3330,97,'JOR-IRB','Irbid',35.856273651123,32.4302597045898);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3331,97,'JOR-MAA','Ma''an',36.4806938171387,30.2081279754639);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3332,98,'KAZ-AKB','Aktyubinsk',58.9490013122559,48.2403678894043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3333,98,'KAZ-ALA','Alma-Ata',77.3701248168945,44.4556083679199);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3334,98,'KAZ-CHM','Chimkent',68.4999847412109,43.2972183227539);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3335,98,'KAZ-DZK','Dzhezkazgan',70.1039886474609,48.0056419372559);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3336,98,'KAZ-DZM','Dzhambul',72.4300994873047,44.1616516113281);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3337,98,'KAZ-GRV','Gur''yev',51.7918357849121,47.6332778930664);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3338,98,'KAZ-KKC','Kokchetav',70.0302658081055,53.3145713806152);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3339,98,'KAZ-KRG','Karaganda',74.009147644043,49.9033298492432);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3340,98,'KAZ-KST','Kustanay',63.208324432373,52.6101036071777);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3341,98,'KAZ-KZO','Kzyl-Orda',63.3241386413574,45.1247177124023);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3342,98,'KAZ-MGY','Mangyshlak',53.3645706176758,43.8816604614258);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3343,98,'KAZ-NKZ','North Kazakhstan',68.6459655761719,54.3527679443359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3344,98,'KAZ-PVL','Pavlodar',76.3718452453613,52.2299919128418);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3345,98,'KAZ-SMP','Semipalatinsk',80.1923446655273,48.6062355041504);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3346,98,'KAZ-TKG','Taldy Kurgan',79.4019317626953,45.5194206237793);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3347,98,'KAZ-TRG','Turgay',65.1502647399902,50.3049926757813);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3348,98,'KAZ-TSL','Tselinograd',70.8215179443359,50.8115234375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3349,98,'KAZ-URL','Ural''sk',50.5370788574219,49.8805389404297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3350,98,'KAZ-VKZ','East Kazakhstan',84.2318725585938,48.9145812988281);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3351,99,'KWT-AFR','Al Farwaniyah',47.9381294250488,29.2576951980591);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3352,99,'KWT-AHM','Al Ahmadi',47.9399909973145,28.90256690979);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3353,99,'KWT-AJH','Al Jahrah',47.3574981689453,29.5344514846802);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3354,99,'KWT-AKW','Al Kuwayt',48.1247005462646,29.6680335998535);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3355,99,'KWT-HWL','Hawalli',48.0385494232178,29.2882785797119);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3356,100,'LAO-ATT','Attapeu',106.920967102051,14.7179112434387);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3357,100,'LAO-BOK','Bokeo',100.518733978271,20.4923076629639);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3358,100,'LAO-BRK','Borikhamxai',104.12219619751,18.5004825592041);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3359,100,'LAO-CHM','Champasak',106.013813018799,14.6944422721863);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3360,100,'LAO-HPH','Houaphan',104.00220489502,20.2909679412842);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3361,100,'LAO-KHM','Khammouan',105.345596313477,17.5536155700684);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3362,100,'LAO-LNG','Louangphrabang',102.589965820313,19.9424953460693);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3363,100,'LAO-LNM','Louang Namtha',101.122940063477,20.9540939331055);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3364,100,'LAO-ODM','Oudomxai',101.511421203613,20.5225448608398);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3365,100,'LAO-PHN','Phongsali',102.282619476318,21.7431907653809);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3366,100,'LAO-SRV','Saravan',106.246379852295,15.8316850662231);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3367,100,'LAO-SVN','Savannakhet',105.864700317383,16.5052771568298);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3368,100,'LAO-VNG','Viangchan',102.580528259277,18.0962333679199);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3369,100,'LAO-VNT','Vientiane',102.409545898438,18.6184349060059);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3370,100,'LAO-XGN','Xaignabouri',101.135406494141,18.8087425231934);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3371,100,'LAO-XKN','Xekong',107.018474578857,15.6495785713196);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3372,100,'LAO-XNG','Xiangkhoang',103.340984344482,19.4360551834106);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3373,101,'LBN-ABI','Al Biqa''',36.1185340881348,33.9596138000488);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3374,101,'LBN-ANB','An Nabatiyah',35.5832195281982,33.3041591644287);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3375,101,'LBN-ASH','Ash Shamal',36.0531349182129,34.3998603820801);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3376,101,'LBN-BYR','Bayrut',35.5082092285156,33.8847160339355);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3377,101,'LBN-JLB','Jabal Lubnan',35.6968612670898,33.8635101318359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3378,101,'LBN-SAY','Sayda',35.3679084777832,33.3316497802734);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3379,102,'MYS-JOH','Johor',103.390407562256,2.08226382732391);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3380,102,'MYS-KED','Kedah',100.658020019531,5.81038284301758);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3381,102,'MYS-KLL','Kuala Lumpur',101.6735496521,3.14348101615906);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3382,102,'MYS-KLN','Kelantan',102.013442993164,5.39709615707397);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3383,102,'MYS-MEL','Melaka',102.292663574219,2.29099893569946);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3384,102,'MYS-NSM','Negeri Sembilan',102.212471008301,2.83765649795532);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3385,102,'MYS-PER','Perak',101.057193756104,4.79527711868286);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3386,102,'MYS-PHN','Pahang',102.488773345947,3.60735988616943);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3387,102,'MYS-PPN','Pulau Pinang',100.369689941406,5.34513807296753);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3388,102,'MYS-PRL','Perlis',100.00993347168,6.43388795852661);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3389,102,'MYS-SAB','Sabah',117.2170753479,5.73110318183899);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3390,102,'MYS-SLN','Selangor',101.384414672852,3.22684931755066);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3391,102,'MYS-SRW','Sarawak',112.604572296143,2.93777638673782);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3392,102,'MYS-TRN','Terengganu',102.940254211426,4.86241674423218);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3393,103,'MDV-ALF','Aliff',72.8331756591797,3.88888812065125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3394,103,'MDV-BAA','Baa',72.973876953125,4.88833236694336);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3395,103,'MDV-DAA','Daalu',72.9499893188477,2.81805515289307);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3396,103,'MDV-FAA','Faafu',72.978874206543,3.10624980926514);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3397,103,'MDV-GAL','Gaafu Aliff',73.5002670288086,0.442916572093964);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3398,103,'MDV-GDA','Gaafu Daalu',73.1583099365234,0.355416610836983);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3399,103,'MDV-HAL','Haa Aliff',72.9448471069336,7.05333280563354);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3400,103,'MDV-HDA','Haa Daalu',73.1374893188477,6.81735992431641);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3401,103,'MDV-KAA','Kaafu',73.4923477172852,4.06374907493591);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3402,103,'MDV-LAA','Laamu',73.4160995483398,1.94694423675537);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3403,103,'MDV-LVY','Laviyani',73.4767913818359,5.34638833999634);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3404,103,'MDV-MEE','Meemu',73.4672088623047,2.86805486679077);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3405,103,'MDV-NOO','Noonu',73.4145660400391,5.83999919891357);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3406,103,'MDV-NVY','Naviyani',73.4380340576172,-0.295694440603256);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3407,103,'MDV-RAA','Raa',72.9577560424805,5.86569356918335);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3408,103,'MDV-SEE','Seenu',73.1690139770508,-0.633472204208374);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3409,103,'MDV-SHV','Shaviyani',73.1552658081055,6.3102765083313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3410,103,'MDV-THA','Thaa',73.1444244384766,2.34749960899353);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3411,103,'MDV-WAA','Waavu',73.6674880981445,3.40944385528564);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3412,104,'MNG-ARH','Arhangay',100.852115631104,48.0097541809082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3413,104,'MNG-BLG','Bulgan',103.222949981689,48.9463291168213);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3414,104,'MNG-BOL','Bayan-Olgiy',89.8886489868164,48.2514820098877);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3415,104,'MNG-BYN','Bayanhongor',99.571605682373,45.1611995697021);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3416,104,'MNG-DND','Dundgovi',106.240352630615,45.416654586792);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3417,104,'MNG-DRG','Dornogovi',109.925498962402,44.7454967498779);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3418,104,'MNG-DRH','Darhan',106.182403564453,49.904275894165);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3419,104,'MNG-DRN','Dornod',116.155941009521,48.3058395385742);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3420,104,'MNG-DZV','Dzavhan',96.2213668823242,48.2956352233887);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3421,104,'MNG-GAL','Govi-Altay',95.8064804077148,45.2274932861328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3422,104,'MNG-HNT','Hentiy',110.566352844238,47.824800491333);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3423,104,'MNG-HOV','Hovd',92.4738311767578,46.9502105712891);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3424,104,'MNG-HVS','Hovsgol',99.8642539978027,50.2208595275879);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3425,104,'MNG-OMN','Omnogovi',103.74490737915,43.2874660491943);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3426,104,'MNG-OVR','Ovorhangay',102.825248718262,45.7837753295898);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3427,104,'MNG-SHB','Suhbaatar',114.016250610352,46.2781352996826);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3428,104,'MNG-SLN','Selenge',106.579349517822,49.5032920837402);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3429,104,'MNG-TOV','Tov',106.525398254395,47.7299995422363);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3430,104,'MNG-ULN','Ulaanbaatar',106.867000579834,47.9379348754883);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3431,104,'MNG-UVS','Uvs',92.762134552002,49.6044979095459);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3432,105,'MMR-AST','Arakan State',93.5570678710938,19.4269409179688);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3433,105,'MMR-CST','Chin State',93.3845672607422,22.3685550689697);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3434,105,'MMR-IRR','Irrawaddy',95.1377639770508,17.0687456130981);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3435,105,'MMR-KSA','Karen State',97.6637268066406,17.3583154678345);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3436,105,'MMR-KSE','Kayah State',97.3517532348633,19.2422161102295);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3437,105,'MMR-KST','Kachin State',97.30859375,26.1036071777344);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3438,105,'MMR-MAG','Magwe',94.8787307739258,20.7513866424561);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3439,105,'MMR-MND','Mandalay',95.8608245849609,21.5256195068359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3440,105,'MMR-MST','Mon State',97.5470962524414,16.2919502258301);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3441,105,'MMR-PEG','Pegu',95.9840087890625,18.1890563964844);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3442,105,'MMR-RNG','Rangoon',95.1099853515625,15.9133319854736);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3443,105,'MMR-SGN','Sagaing',95.5247116088867,24.4813003540039);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3444,105,'MMR-SST','Shan State',98.6641540527344,21.7250785827637);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3445,105,'MMR-TNS','Tenasserim',98.5497055053711,12.4443035125732);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3446,106,'NPL-BGM','Bagmati',85.3541946411133,27.7999496459961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3447,106,'NPL-BHE','Bheri',81.7612571716309,28.4869832992554);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3448,106,'NPL-DHW','Dhawalagiri',83.5424690246582,28.6396045684814);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3449,106,'NPL-GND','Gandaki',84.3785934448242,28.3276319503784);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3450,106,'NPL-JNK','Janakpur',85.9476928710938,27.3670787811279);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3451,106,'NPL-KOS','Kosi',87.327262878418,27.170690536499);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3452,106,'NPL-KRN','Karnali',82.4417915344238,29.5759172439575);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3453,106,'NPL-LMB','Lumbini',83.5616493225098,27.7859964370728);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3454,106,'NPL-MEC','Mechi',87.817813873291,27.1418018341064);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3455,106,'NPL-MHK','Mahakali',80.5858154296875,29.3971748352051);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3456,106,'NPL-NRY','Narayani',84.711009979248,27.2785482406616);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3457,106,'NPL-RAP','Rapti',82.5337562561035,28.3329610824585);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3458,106,'NPL-SET','Seti',81.1519432067871,29.2115240097046);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3459,106,'NPL-SGR','Sagarmatha',86.6672821044922,27.2663841247559);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3460,107,'PRK-CDO','Chagang-do',126.459815979004,40.8941612243652);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3461,107,'PRK-HBK','Hwanghae-bukto',126.297428131104,38.5962409973145);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3462,107,'PRK-HBU','Hamgyong-bukto',129.752029418945,41.7869720458984);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3463,107,'PRK-HNA','Hamgyong-namdo',127.920669555664,40.191333770752);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3464,107,'PRK-HNM','Hwanghae-namdo',125.551517486572,38.185962677002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3465,107,'PRK-KDO','Kangwon-do',127.521774291992,38.783748626709);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3466,107,'PRK-KSI','Kaesong-si',126.672653198242,37.9986572265625);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3467,107,'PRK-PBU','P''yongan-bukto',125.34693145752,40.0746726989746);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3468,107,'PRK-PNA','P''yongan-namdo',126.158740997314,39.4972152709961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3469,107,'PRK-PSI','P''yongyang-si',125.954845428467,38.9940223693848);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3470,107,'PRK-YDO','Yanggang-do',127.984558105469,41.254035949707);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3471,108,'PAK-AKP','Azad Kashmir Province',74.3332061767578,33.9776649475098);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3472,108,'PAK-BLC','Baluchistan',65.5509185791016,28.4836082458496);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3473,108,'PAK-FAT','Federally Administered Tribal Areas',70.5490112304688,33.018310546875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3474,108,'PAK-NOR','Northern Areas',75.1683502197266,35.7817115783691);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3475,108,'PAK-NWF','North-west Frontier',72.0951156616211,34.0603580474854);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3476,108,'PAK-PNJ','Punjab',72.3600845336914,30.8630466461182);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3477,108,'PAK-SIN','Sind',68.8765106201172,26.1087455749512);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3478,109,'PHL-BCL','Bicol',123.362071990967,13.0304145812988);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3479,109,'PHL-CAR','Cordillera Administrative Region',121.066799163818,17.3324956893921);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3480,109,'PHL-CGV','Cagayan Valley',121.64306640625,18.4479675292969);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3481,109,'PHL-CLZ','Central Luzon',120.631702423096,15.2795810699463);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3482,109,'PHL-CMN','Central Mindanao',124.458599090576,7.24527597427368);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3483,109,'PHL-CVS','Central Visayas',123.598991394043,10.1672210693359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3484,109,'PHL-EVS','Eastern Visayas',125.040550231934,11.2433309555054);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3485,109,'PHL-ILC','Ilocos',120.368057250977,17.1136074066162);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3486,109,'PHL-NCR','National Capital Region',121.020790100098,14.5774793624878);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3487,109,'PHL-NMN','Northern Mindanao',124.920272827148,8.93597078323364);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3488,109,'PHL-SMN','Southern Mindanao',125.423595428467,7.42404651641846);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3489,109,'PHL-STG','Southern Tagalog',119.883018493652,11.7380418777466);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3490,109,'PHL-WMN','Western Mindanao',121.577342987061,6.68624877929688);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3491,109,'PHL-WVS','Western Visayas',122.705955505371,10.6812610626221);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3492,111,'SAU-ABA','Al Bahah',41.4172172546387,20.0641651153564);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3493,111,'SAU-AHA','Al Hudud ash Shamaliyah',41.9913501739502,29.8037185668945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3494,111,'SAU-AJA','Al Jawf',39.879020690918,29.5477752685547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3495,111,'SAU-AMD','Al Madinah',39.4355506896973,24.9440269470215);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3496,111,'SAU-AQA','Al Qasim',43.1281852722168,25.9708271026611);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3497,111,'SAU-AQR','Al Qurayyat',36.8172378540039,29.9881362915039);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3498,111,'SAU-ARI','Ar Riyad',45.1418037414551,23.3930816650391);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3499,111,'SAU-ASH','Ash Sharqiyah',50.3011054992676,22.9278964996338);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3500,111,'SAU-ASI','''Asir',42.952220916748,19.2228488922119);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3501,111,'SAU-HAI','Ha''il',41.8993263244629,27.0963840484619);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3502,111,'SAU-JIZ','Jizan',42.4705543518066,17.3527774810791);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3503,111,'SAU-MKK','Makkah',41.1710243225098,21.0466499328613);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3504,111,'SAU-NJR','Najran',45.6900024414063,17.5740375518799);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3505,111,'SAU-TAB','Tabuk',37.3330459594727,26.7639455795288);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3506,112,'KOR-CBK','Ch''ungch''ong-bukto',127.965560913086,36.6358871459961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3507,112,'KOR-CBU','Cholla-bukto',127.177062988281,35.7273559570313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3508,112,'KOR-CDO','Cheju-do',126.548175811768,33.3711013793945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3509,112,'KOR-CNA','Cholla-namdo',126.850540161133,34.8765182495117);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3510,112,'KOR-CNM','Ch''ungch''ong-namdo',126.895244598389,36.5144348144531);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3511,112,'KOR-ICH','Inch''on-jikhalsi',126.699005126953,37.4781913757324);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3512,112,'KOR-KBU','Kyongsang-bukto',128.717041015625,36.3577842712402);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3513,112,'KOR-KDO','Kangwon-do',128.964965820313,37.8272018432617);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3514,112,'KOR-KGD','Kyonggi-do',126.230819702148,37.5587158203125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3515,112,'KOR-KNA','Kyongsang-namdo',128.52653503418,35.3034515380859);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3516,112,'KOR-KWN','Kwangju-jikhalsi',126.859752655029,35.1246700286865);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3517,112,'KOR-PSN','Pusan-jikhalsi',129.102340698242,35.1829071044922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3518,112,'KOR-SJK','Seoul-jikhalsi',126.998321533203,37.568962097168);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3519,112,'KOR-TGN','Taegu-jikhalsi',128.62678527832,35.8916168212891);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3520,113,'SYR-AHS','Al Hasakah',40.9091606140137,36.4205513000488);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3521,113,'SYR-ALD','Al Ladhiqiyah',36.0115242004395,35.5718269348145);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3522,113,'SYR-AQN','Al Qunaytirah',35.7919540405273,33.0162467956543);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3523,113,'SYR-ARQ','Ar Raqqah',38.9123039245605,36.0086669921875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3524,113,'SYR-ASW','As Suwayda''',36.915885925293,32.7706909179688);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3525,113,'SYR-DAR','Dar''a',36.1670379638672,32.829719543457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3526,113,'SYR-DAZ','Dayr az Zawr',40.2822227478027,35.2521781921387);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3527,113,'SYR-DMS','Dimashq',37.052791595459,33.4594383239746);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3528,113,'SYR-HAL','Halab',37.610408782959,36.1720809936523);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3529,113,'SYR-HAM','Hamah',37.2456893920898,35.3014068603516);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3530,113,'SYR-HIM','Hims',38.1561050415039,34.2599220275879);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3531,113,'SYR-IDL','Idlib',36.682445526123,35.8256874084473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3532,113,'SYR-TRT','Tartus',36.0939064025879,34.9471397399902);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3533,114,'TWN-CHH','Chang-hua',120.453201293945,23.9809675216675);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3534,114,'TWN-CHI','Chia-i',120.524883270264,23.4300594329834);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3535,114,'TWN-CLS','Chi-lung Shih',121.70539855957,25.1148586273193);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3536,114,'TWN-HSN','Hsin-chu',121.133949279785,24.6858253479004);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3537,114,'TWN-HUL','Hua-lien',121.393947601318,23.734055519104);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3538,114,'TWN-ILN','I-lan',121.639907836914,24.6476955413818);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3539,114,'TWN-KAH','Kao-hsiung',120.603839874268,22.9727745056152);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3540,114,'TWN-KAS','Kao-hsiung Shih',120.276988983154,22.6796751022339);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3541,114,'TWN-MIL','Miao-li',120.925319671631,24.5133857727051);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3542,114,'TWN-NNT','Nan-t''ou',120.972351074219,23.8341903686523);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3543,114,'TWN-PNG','P''eng-hu',119.106243133545,24.8701362609863);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3544,114,'TWN-PNT','P''ing-tung',121.00025177002,22.4076862335205);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3545,114,'TWN-TCH','T''ai-chung',120.958053588867,24.2211847305298);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3546,114,'TWN-TCS','T''ai-chung Shih',120.671348571777,24.159255027771);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3547,114,'TWN-TNN','T''ai-nan',120.342971801758,23.1542501449585);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3548,114,'TWN-TNS','T''ai-nan Shih',120.1413230896,23.0000219345093);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3549,114,'TWN-TPE','T''ai-pei',121.639041900635,24.978217124939);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3550,114,'TWN-TPS','T''ai-pei Shih',121.538803100586,25.075044631958);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3551,114,'TWN-TTN','T''ai-tung',121.097263336182,22.8382863998413);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3552,114,'TWN-TYN','T''ao-yuan',121.212200164795,24.8541784286499);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3553,114,'TWN-YNL','Yun-lin',120.414398193359,23.6676502227783);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3554,115,'THA-ATH','Ang Thong',100.355262756348,14.6183309555054);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3555,115,'THA-BRR','Buriram',102.96826171875,14.9604144096375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3556,115,'THA-CBU','Chon Buri',101.19359588623,13.0941648483276);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3557,115,'THA-CHC','Chachoengsao',101.41711807251,13.5736989974976);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3558,115,'THA-CHM','Chumphon',99.0690383911133,10.3156900405884);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3559,115,'THA-CHN','Chanthaburi',102.109985351563,12.8097658157349);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3560,115,'THA-CHY','Chaiyaphum',101.880786895752,15.9591627120972);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3561,115,'THA-CMA','Chiang Mai',98.8372116088867,18.6969738006592);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3562,115,'THA-CNA','Chai Nat',100.012619018555,15.1637487411499);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3563,115,'THA-CRA','Chiang Rai',99.9282760620117,19.7268085479736);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3564,115,'THA-KKA','Khon Kaen',102.473022460938,16.3484687805176);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3565,115,'THA-KLS','Kalasin',103.679538726807,16.6438846588135);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3566,115,'THA-KNC','Kanchanaburi',99.0466537475586,14.6948304176331);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3567,115,'THA-KPH','Kamphaeng Phet',99.5079040527344,16.3356924057007);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3568,115,'THA-KRA','Krabi',98.9833221435547,8.06902694702148);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3569,115,'THA-KTH','Krung Thep',100.615550994873,13.7187347412109);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3570,115,'THA-LBU','Lop Buri',100.949005126953,15.0766649246216);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3571,115,'THA-LMN','Lampang',99.5661010742188,18.3554134368896);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3572,115,'THA-LMP','Lamphun',98.9948425292969,18.0947170257568);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3573,115,'THA-LOE','Loei',101.517761230469,17.4863786697388);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3574,115,'THA-MHS','Mae Hong Son',98.0002593994141,18.6894817352295);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3575,115,'THA-MSR','Maha Sarakham',103.179733276367,16.0214338302612);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3576,115,'THA-NAN','Nan',100.850273132324,18.8161067962646);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3577,115,'THA-NKH','Nong Khai',103.126941680908,18.0129127502441);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3578,115,'THA-NNA','Nakhon Nayok',101.210403442383,14.2306923866272);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3579,115,'THA-NNT','Nonthaburi',100.411796569824,13.9663877487183);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3580,115,'THA-NPH','Nakhon Phanom',104.482608795166,17.1023597717285);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3581,115,'THA-NPT','Nakhon Pathom',100.071235656738,13.9168043136597);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3582,115,'THA-NRH','Narathiwat',101.738983154297,6.1852765083313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3583,115,'THA-NRT','Nakhon Ratchasima',102.102272033691,14.9692897796631);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3584,115,'THA-NSA','Nakhon Sawan',99.9567947387695,15.6991634368896);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3585,115,'THA-NST','Nakhon Si Thammarat',99.7887344360352,8.79924011230469);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3586,115,'THA-PBU','Prachin Buri',102.036327362061,13.7980537414551);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3587,115,'THA-PHA','Phayao',100.160678863525,19.2750968933105);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3588,115,'THA-PHB','Phetchaburi',99.6081809997559,12.9520816802979);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3589,115,'THA-PHC','Phichit',100.374565124512,16.2522192001343);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3590,115,'THA-PHH','Phetchabun',101.210361480713,16.1995944976807);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3591,115,'THA-PHK','Phuket',98.3565063476563,7.97138786315918);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3592,115,'THA-PHL','Phatthalung',100.060440063477,7.49859809875488);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3593,115,'THA-PHN','Phangnga',98.4533157348633,8.62777614593506);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3594,115,'THA-PHR','Phrae',99.9262351989746,18.254301071167);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3595,115,'THA-PHT','Phitsanulok',100.492767333984,17.0486068725586);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3596,115,'THA-PKK','Prachuap Khiri Khan',99.5831756591797,11.7948150634766);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3597,115,'THA-PNS','Phra Nakhon Si Ayutthaya',100.521892547607,14.3976364135742);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3598,115,'THA-PTH','Pathum Thani',100.626789093018,14.0894002914429);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3599,115,'THA-PTT','Pattani',101.378330230713,6.73986005783081);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3600,115,'THA-RET','Roi Et',103.825592041016,15.93625831604);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3601,115,'THA-RNN','Ranong',98.4056854248047,10.0414371490479);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3602,115,'THA-RTC','Ratchaburi',99.6239166259766,13.5615086555481);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3603,115,'THA-RYN','Rayong',101.401794433594,12.8801364898682);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3604,115,'THA-SAT','Satun',99.6901206970215,6.77761459350586);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3605,115,'THA-SBR','Suphan Buri',99.7815093994141,14.567081451416);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3606,115,'THA-SBU','Sing Buri',100.344421386719,14.9461393356323);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3607,115,'THA-SKH','Sukhothai',99.6995697021484,17.2526340484619);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3608,115,'THA-SNG','Songkhla',100.569839477539,7.11355495452881);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3609,115,'THA-SNK','Sakon Nakhon',103.838871002197,17.4276371002197);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3610,115,'THA-SPR','Samut Prakan',100.702629089355,13.5942535400391);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3611,115,'THA-SRB','Saraburi',100.906955718994,14.534836769104);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3612,115,'THA-SSH','Samut Sakhon',100.223320007324,13.5775098800659);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3613,115,'THA-SSK','Sisaket',104.416641235352,14.9594831466675);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3614,115,'THA-SSN','Samut Songkhram',99.9716720581055,13.3705539703369);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3615,115,'THA-STH','Surat Thani',99.1229019165039,9.04993057250977);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3616,115,'THA-SUR','Surin',103.590660095215,14.9087810516357);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3617,115,'THA-TAK','Tak',98.6348495483398,16.4884252548218);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3618,115,'THA-TRA','Trat',102.587760925293,12.1569242477417);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3619,115,'THA-TRN','Trang',99.6530838012695,7.52833223342896);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3620,115,'THA-URT','Ubon Ratchathani',105.011669158936,15.2525453567505);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3621,115,'THA-UTA','Udon Thani',102.801788330078,17.4239597320557);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3622,115,'THA-UTH','Uthai Thani',99.5262870788574,15.3559093475342);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3623,115,'THA-UTT','Uttaradit',100.536521911621,17.7766036987305);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3624,115,'THA-YAL','Yala',101.231922149658,6.13444375991821);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3625,115,'THA-YST','Yasothon',104.406421661377,15.81498670578);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3626,116,'TUR-ADA','Adana',35.7537422180176,37.5070762634277);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3627,116,'TUR-ADY','Adiyaman',38.3349876403809,37.8267974853516);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3628,116,'TUR-AFY','Afyon',30.6830520629883,38.5208168029785);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3629,116,'TUR-AGR','Agri',3.3610229492188,39.5077705383301);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3630,116,'TUR-AMS','Amasya',35.7492980957031,40.6378326416016);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3631,116,'TUR-ANK','Ankara',32.4840202331543,39.6767921447754);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3632,116,'TUR-ANT','Antalya',30.9554023742676,36.7597198486328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3633,116,'TUR-ART','Artvin',41.8544387817383,41.0499935150146);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3634,116,'TUR-AYD','Aydin',28.037914276123,37.7210426330566);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3635,116,'TUR-BLC','Bilecik',30.2003326416016,40.0679092407227);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3636,116,'TUR-BLK','Balikesir',27.8059482574463,39.8509635925293);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3637,116,'TUR-BNG','Bingol',40.6456832885742,39.028736114502);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3638,116,'TUR-BOL','Bolu',31.5595779418945,40.641414642334);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3639,116,'TUR-BRD','Burdur',30.1627044677734,37.3816261291504);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3640,116,'TUR-BTL','Bitlis',42.3662872314453,38.5194320678711);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3641,116,'TUR-BUR','Bursa',29.0266609191895,40.0813827514648);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3642,116,'TUR-CNK','Canakkale',26.6236057281494,40.1279792785645);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3643,116,'TUR-CNR','Cankiri',33.2201347351074,40.7092971801758);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3644,116,'TUR-COR','Corum',34.7116584777832,40.6092681884766);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3645,116,'TUR-DNZ','Denizli',29.3023586273193,37.6790008544922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3646,116,'TUR-DYR','Diyarbakir',40.2751312255859,38.1477966308594);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3647,116,'TUR-EDR','Edirne',26.5230646133423,41.2995758056641);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3648,116,'TUR-ELZ','Elazig',39.3711051940918,38.7773513793945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3649,116,'TUR-ERR','Erzurum',41.4009590148926,40.0727844238281);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3650,116,'TUR-ERZ','Erzincan',39.5165214538574,39.5477523803711);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3651,116,'TUR-ESK','Eskisehir',31.0709667205811,39.623462677002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3652,116,'TUR-GMS','Gumshane',39.8262481689453,40.328197479248);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3653,116,'TUR-GRS','Giresun',38.618049621582,40.5639190673828);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3654,116,'TUR-GZN','Gaziantep',37.2470359802246,37.0998573303223);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3655,116,'TUR-HAT','Hatay',36.2379112243652,36.419303894043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3656,116,'TUR-HKK','Hakkari',43.7815132141113,37.4474868774414);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3657,116,'TUR-ICE','Icel',33.8185844421387,36.7144393920898);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3658,116,'TUR-ISP','Isparta',30.8209705352783,37.9299926757813);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3659,116,'TUR-IST','Istanbul',28.973274230957,41.0274238586426);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3660,116,'TUR-IZM','Izmir',27.4186706542969,38.6781845092773);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3661,116,'TUR-KAR','Kars',43.4747085571289,40.6127662658691);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3662,116,'TUR-KMA','Kahraman Maras',36.9994316101074,37.9248542785645);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3663,116,'TUR-KOC','Kocaeli',29.8754119873047,40.8791656494141);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3664,116,'TUR-KON','Konya',32.87721824646,37.8291549682617);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3665,116,'TUR-KRK','Kirklareli',27.5707979202271,41.6637706756592);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3666,116,'TUR-KRS','Kirsehir',34.128288269043,39.332145690918);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3667,116,'TUR-KST','Kastamonu',33.6431884765625,41.4404067993164);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3668,116,'TUR-KTH','Kutahya',29.5490245819092,39.3159523010254);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3669,116,'TUR-KYS','Kayseri',35.9286041259766,38.6302680969238);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3670,116,'TUR-MAN','Manisa',28.1343021392822,38.7576332092285);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3671,116,'TUR-MLT','Malatya',38.1645774841309,38.4835662841797);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3672,116,'TUR-MRD','Mardin',41.3245735168457,37.351131439209);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3673,116,'TUR-MUG','Mugla',28.4573593139648,36.937629699707);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3674,116,'TUR-MUS','Mus',41.9198532104492,39.011360168457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3675,116,'TUR-NIG','Nigde',34.2486000061035,38.1765747070313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3676,116,'TUR-NVS','Nevsehir',34.6362457275391,38.8760986328125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3677,116,'TUR-ORD','Ordu',37.4208221435547,40.7366218566895);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3678,116,'TUR-RIZ','Rize',40.8928489685059,40.9248924255371);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3679,116,'TUR-SII','Siirt',42.0392951965332,37.979850769043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3680,116,'TUR-SIN','Sinop',34.8209648132324,41.6460990905762);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3681,116,'TUR-SIV','Sivas',37.2907867431641,39.5555458068848);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3682,116,'TUR-SKR','Sakarya',30.4405498504639,40.7482528686523);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3683,116,'TUR-SMS','Samsun',36.0194511413574,41.2899932861328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3684,116,'TUR-TKR','Tekirdag',27.454044342041,41.0484485626221);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3685,116,'TUR-TNC','Tunceli',39.6338996887207,39.1640205383301);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3686,116,'TUR-TOK','Tokat',36.5723457336426,40.415355682373);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3687,116,'TUR-TRB','Trabzon',39.8022308349609,40.8098602294922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3688,116,'TUR-URF','Urfa',39.0506858825684,37.3531875610352);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3689,116,'TUR-USA','Usak',29.3632373809814,38.5467262268066);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3690,116,'TUR-VAN','Van',43.5859642028809,38.5702667236328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3691,116,'TUR-YZG','Yozgat',35.1329116821289,39.6175880432129);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3692,116,'TUR-ZNG','Zonguldak',32.1898517608643,41.4188270568848);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3693,117,'ARE-AFJ','Al Fujayrah',56.1730499267578,25.2836103439331);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3694,117,'ARE-AJM','''Ajman',55.7652015686035,25.0987453460693);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3695,117,'ARE-ASH','Ash Shariqah',55.8541870117188,25.0991268157959);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3696,117,'ARE-AZ','Abu Zaby',53.8040237426758,23.8046865463257);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3697,117,'ARE-DBY','Dubayy',55.5975685119629,24.9496021270752);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3698,117,'ARE-RAK','Ra''s al Khaymah',56.013786315918,25.4522171020508);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3699,117,'ARE-UAQ','Umm al Qaywayn',55.7230644226074,25.468334197998);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3700,118,'VNM-AGI','An Giang',105.138969421387,10.524169921875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3701,118,'VNM-BDN','Binh Dinh',108.992210388184,14.0738615989685);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3702,118,'VNM-BRV','Ba Ria-Vung Tau',107.070945739746,9.71885538101196);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3703,118,'VNM-BTH','Bac Thai',105.853458404541,21.9040575027466);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3704,118,'VNM-BTN','Binh Thuan',108.194000244141,11.0347661972046);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3705,118,'VNM-BTR','Ben Tre',106.371395111084,10.0686092376709);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3706,118,'VNM-CBA','Cao Bang',106.04443359375,22.7037477493286);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3707,118,'VNM-CTH','Can Tho',105.62813949585,9.92639303207397);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3708,118,'VNM-DLA','Dac Lac',108.243034362793,12.5842576026917);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3709,118,'VNM-DNA','Dong Nai',107.166091918945,11.041109085083);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3710,118,'VNM-DTH','Dong Thap',105.555992126465,10.5533313751221);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3711,118,'VNM-GLA','Gia Lai',108.191352844238,13.8126330375671);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3712,118,'VNM-HBA','Ha Bac',106.439376831055,21.3051357269287);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3713,118,'VNM-HBN','Hoa Binh',105.339588165283,20.7123584747314);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3714,118,'VNM-HCM','Ho Chi Minh',106.68176651001,10.7557153701782);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3715,118,'VNM-HGN','Ha Giang',104.962341308594,22.7519416809082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3716,118,'VNM-HHU','Hai Hung',106.233722686768,20.9226341247559);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3717,118,'VNM-HNO','Ha Noi',105.835308074951,21.1810913085938);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3718,118,'VNM-HPH','Hai Phong',107.078590393066,20.5722122192383);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3719,118,'VNM-HTN','Ha Tinh',105.806617736816,18.2874965667725);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3720,118,'VNM-HTY','Ha Tay',105.643039703369,20.9654150009155);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3721,118,'VNM-KGI','Kien Giang',104.520866394043,9.90791511535645);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3722,118,'VNM-KHO','Khanh Hoa',109.051097869873,12.3552951812744);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3723,118,'VNM-KTM','Kon Tum',107.968879699707,14.5790934562683);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3724,118,'VNM-LAN','Long An',106.147552490234,10.7099981307983);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3725,118,'VNM-LCA','Lao Cai',104.065910339355,22.2681903839111);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3726,118,'VNM-LCH','Lai Chau',102.950927734375,21.8194408416748);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3727,118,'VNM-LDO','Lam Dong',108.009986877441,11.8924989700317);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3728,118,'VNM-LSO','Lang Son',106.747047424316,21.8672180175781);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3729,118,'VNM-MHA','Minh Hai',105.293060302734,9.04819297790527);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3730,118,'VNM-NAN','Nghe An',104.840702056885,19.2779531478882);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3731,118,'VNM-NBN','Ninh Binh',105.883434295654,20.2137441635132);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3732,118,'VNM-NHA','Nam Ha',106.182865142822,20.3302726745605);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3733,118,'VNM-NTN','Ninh Thuan',108.89457321167,11.7345819473267);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3734,118,'VNM-PYN','Phu Yen',109.076236724854,13.2279682159424);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3735,118,'VNM-QBN','Quang Binh',106.353103637695,17.5110006332397);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3736,118,'VNM-QND','Quang Nam-Da Nang',107.966945648193,15.6490597724915);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3737,118,'VNM-QNG','Quang Ngai',108.698589324951,14.9940328598022);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3738,118,'VNM-QNI','Quang Ninh',107.256233215332,21.2322177886963);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3739,118,'VNM-QTR','Quang Tri',107.012481689453,16.70387840271);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3740,118,'VNM-SBE','Song Be',106.902484893799,11.6036081314087);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3741,118,'VNM-SLA','Son La',104.094398498535,21.3392953872681);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3742,118,'VNM-STR','Soc Trang',105.905391693115,9.58250570297241);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3743,118,'VNM-TBI','Thai Binh',106.371479034424,20.5026226043701);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3744,118,'VNM-TGI','Tien Giang',106.308746337891,10.3862476348877);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3745,118,'VNM-THO','Thanh Hoa',105.229156494141,19.9521160125732);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3746,118,'VNM-TNI','Tay Ninh',106.154022216797,11.3730545043945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3747,118,'VNM-TQN','Tuyen Quang',105.211715698242,22.0844612121582);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3748,118,'VNM-TTH','Thua Thien Hue',107.641235351563,16.339165687561);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3749,118,'VNM-TVN','Tra Vinh',106.267826080322,9.77600622177124);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3750,118,'VNM-VLN','Vinh Long',105.974300384521,10.109375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3751,118,'VNM-VPH','Vinh Phu',105.277153015137,21.3405494689941);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3752,118,'VNM-YBA','Yen Bai',104.507034301758,21.8152751922607);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3753,119,'YEM-ABD','Al Bayda''',45.3126945495605,14.356433391571);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3754,119,'YEM-ABY','Abyan',46.1384716033936,13.6580533981323);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3755,119,'YEM-ADN','Aden',49.57763671875,12.5464148521423);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3756,119,'YEM-AHD','Al Hudaydah',43.1344413757324,14.717499256134);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3757,119,'YEM-AJW','Al Jawf',45.2564239501953,16.4107451438904);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3758,119,'YEM-AMR','Al Mahrah',51.6277503967285,17.0325880050659);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3759,119,'YEM-AMW','Al Mahwit',43.6079597473145,15.2588047981262);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3760,119,'YEM-ATQ','''Ataq',47.0426387786865,15.5373873710632);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3761,119,'YEM-DHM','Dhamar',44.1398143768311,14.5522499084473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3762,119,'YEM-HDH','Hadhramaut',49.4347171783447,16.4295315742493);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3763,119,'YEM-HJJ','Hajjah',43.2844829559326,16.0806965827942);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3764,119,'YEM-IBB','Ibb',44.1850891113281,14.0478901863098);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3765,119,'YEM-LHJ','Lahij',44.4061107635498,13.2447214126587);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3766,119,'YEM-MRB','Ma''rib',45.4104232788086,15.1331100463867);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3767,119,'YEM-SAN','San''a''',44.1634559631348,15.7474846839905);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3768,119,'YEM-SDH','Sa''dah',44.2994918823242,17.0277976989746);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3769,119,'YEM-TAZ','Ta''izz',43.8834686279297,13.2452735900879);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3770,110,'RUS-YMN','Yamalo-Nenetskiy avtonomnyy okrug',67.8734931945801,74.0209846496582);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3771,110,'RUS-NEN','Nenetskiy avtonomnyy okrug',73.829704284668,56.1005401611328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3772,110,'RUS-CHU','Chukotskiy avtonomnyy okrug',66.7016525268555,56.1005401611328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3773,110,'RUS-MRM','Murmanskaya oblast''',68.0076217651367,34.9131898880005);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3774,110,'RUS-MAG','Magadanskaya oblast''',62.599250793457,154.08869934082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3775,110,'RUS-EVE','Evenkiyskiy avtonomnyy okrug',64.268871307373,98.4673500061035);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3776,110,'RUS-KOM','Respublika Komi',63.819637298584,55.8052444458008);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3777,110,'RUS-KEM','Kemerovskaya oblast''',54.5005798339844,86.9298095703125);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3778,110,'RUS-YAK','Respublika Sakha(Yakutiya)',66.304988861084,134.185596466064);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3779,110,'RUS-ARK','Arkhangel''skaya oblast''',63.7177658081055,42.9951248168945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3780,110,'RUS-KRL','Respublika Kareliya',63.6647071838379,33.6134357452393);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3781,110,'RUS-KHM','Khanty-Mansiyskiy avtonomnyy okrug',62.1501159667969,72.6001968383789);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3782,110,'RUS-KOR','Koryakskiy avtonomnyy okrug',60.3013172149658,165.055801391602);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3783,110,'RUS-UOB','Ust''-Ordynskiy Buryatskiy avt.okrug',53.2217960357666,104.182624816895);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3784,110,'RUS-SVD','Sverdlovskaya oblast''',59.0227699279785,61.7132015228271);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3785,110,'RUS-PER','Permskaya oblast''',58.8908233642578,56.5847434997559);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3786,110,'RUS-VLG','Vologodskaya oblast''',60.0437850952148,40.9357357025146);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3787,110,'RUS-SPT','Leningradskaya oblast''',59.8737869262695,31.7042465209961);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3788,110,'RUS-KMP','Komi-Permyatskiy avton. okrug',59.8508262634277,54.006555557251);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3789,110,'RUS-KRV','Kirovskaya oblast''',58.5837440490723,50.1202030181885);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3790,110,'RUS-TOM','Tomskaya oblast''',58.3708267211914,82.2290115356445);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3791,110,'RUS-TYU','Tyumenskaya oblast''',57.5658264160156,70.0007553100586);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3792,110,'RUS-KST','Kostromskaya oblast''',58.4553680419922,43.99464416503916);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3793,110,'RUS-NVG','Novgorodskaya oblast''',58.1842269897461,32.9233264923096);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3794,110,'RUS-TAY','Taymyrskiy(Dolgano-Nenetskiy) avt.okrug',74.2537384033203,94.9672088623047);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3795,110,'RUS-PSK','Pskovskaya oblast''',57.294017791748,29.4279069900513);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3796,110,'RUS-YRS','Yaroslavskaya oblast''',57.7482929229736,39.2545738220215);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3797,110,'RUS-TVR','Tverskaya oblast''',57.2557544708252,34.5431184768677);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3798,110,'RUS-OMS','Omskaya oblast''',56.0086059570313,73.3672370910645);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3799,110,'RUS-UDM','Udmurtskaya Respublika',57.1994552612305,52.7564868927002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3800,110,'RUS-AGB','Aginskiy Buryatskiy avtonomnyy okrug',57.1994552612305,114.15308380127);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3801,110,'RUS-NZN','Nizhegorodskaya oblast''',56.281795501709,44.7741947174072);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3802,110,'RUS-IVN','Ivanovskaya oblast''',57.061107635498,41.3041706085205);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3803,110,'RUS-MRL','Respublika Mariy-El',56.5720901489258,47.9193000793457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3804,110,'RUS-NOV','Novosibirskaya oblast''',55.2981109619141,80.0809097290039);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3805,110,'RUS-CHI','Chitinskaya oblast''',53.7738838195801,114.945854187012);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3806,110,'RUS-AMU','Amurskaya oblast''',52.9442310333252,127.313625335693);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3807,110,'RUS-MSC','Moskovskaya oblast''',55.5963878631592,37.6879940032959);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3808,110,'RUS-KUR','Kurganskaya oblast''',55.5065879821777,65.3436660766602);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3809,110,'RUS-KRA','Krasnoyarskiy kray',60.0974197387695,92.1701507568359);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3810,110,'RUS-VLD','Vladimirskaya oblast''',55.9722290039063,40.6321811676025);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3811,110,'RUS-TRT','Respublika Tatarstan',55.3302688598633,50.7660846710205);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3812,110,'RUS-BSK','Respublika Bashkortostan',54.0536060333252,56.5679779052734);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3813,110,'RUS-CHL','Chelyabinskaya oblast''',54.1874923706055,60.2397842407227);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3814,110,'RUS-CHV','Chuvashskaya Respublika',55.4831867218018,47.1641960144043);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3815,110,'RUS-KHK','Respublika Khakasiya',53.3906936645508,89.8997039794922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3816,110,'RUS-RYZ','Ryazanskaya oblast''',54.336727142334,40.6867618560791);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3817,110,'RUS-KLG','Kaluzhskaya oblast''',54.2962646484375,35.3738441467285);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3818,110,'RUS-MRD','Respublika Mordoviya',54.4185657501221,44.4646472930908);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3819,110,'RUS-ULY','Ul''yanovskaya oblast''',53.7270755767822,48.0327739715576);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3820,110,'RUS-KAM','Kamchatskaya oblast''',54.2478713989258,161.82836151123);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3821,110,'RUS-TUL','Tul''skaya oblast''',53.9091567993164,37.4372138977051);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3822,110,'RUS-SAM','Samarskaya oblast''',53.2108688354492,50.2399673461914);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3823,110,'RUS-KNG','Kaliningradskaya oblast''',54.8063774108887,21.2470645904541);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3824,110,'RUS-YEV','Yevreyskaya avtonomnaya oblast''',48.576587677002,132.759628295898);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3825,110,'RUS-ALT','Altayskiy kray',52.565746307373,82.4930229187012);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3826,110,'RUS-ORB','Orenburgskaya oblast''',52.4277000427246,56.2295608520508);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3827,110,'RUS-IRK','Irkutskaya oblast''',57.7159042358398,107.393665313721);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3828,110,'RUS-BRY','Bryanskaya oblast''',52.9382209777832,33.290078163147);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3829,110,'RUS-PNZ','Penzenskaya oblast''',53.1627044677734,44.5395774841309);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3830,110,'RUS-TMB','Tambovskaya oblast''',52.715747833252,41.5931491851807);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3831,110,'RUS-TUV','Respublika Tyva',51.7303371429443,93.9929122924805);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3832,110,'RUS-ORL','Orlovskaya oblast''',52.7796802520752,36.425687789917);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3833,110,'RUS-LPT','Lipetskaya oblast''',52.7359619140625,39.206033706665);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3834,110,'RUS-SRT','Saratovskaya oblast''',51.3140888214111,46.6504096984863);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3835,110,'RUS-GAL','Respublika Altay',50.8730449676514,86.9342880249023);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3836,110,'RUS-KRS','Kurskaya oblast''',51.6688175201416,36.3038139343262);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3837,110,'RUS-VRN','Voronezhskaya oblast''',50.8290920257568,40.5140342712402);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3838,110,'RUS-BUR','Respublika Buryatiya',53.612268447876,107.783321380615);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3839,110,'RUS-BLG','Belgorodskaya oblast''',50.6140174865723,37.2721862792969);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3840,110,'RUS-VGG','Volgogradskaya oblast''',49.3463096618652,44.3061809539795);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3841,110,'RUS-RSV','Rostovskaya oblast''',48.086612701416,41.2754001617432);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3842,110,'RUS-KHA','Khabarovskiy kray',54.6086578369141,138.778305053711);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3843,110,'RUS-PRM','Primorskiy kray',45.3692226409912,134.718101501465);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3844,110,'RUS-SAK','Sakhalinskaya oblast''',49.0372848510742,149.067329406738);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3845,110,'RUS-ADY','Respublika Adygeya',44.4713802337646,39.7133293151855);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3846,110,'RUS-STV','Stavropol''skiy kray',44.9451446533203,43.2786674499512);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3847,110,'RUS-KSN','Krasnodarskiy kray',45.1202278137207,39.155143737793);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3848,110,'RUS-KCH','Karachayevo-Cherkesskaya Resp.',43.8412418365479,41.6881561279297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3849,110,'RUS-KBK','Kabardino-Balkarskaya Resp.',43.4470710754395,43.3990859985352);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3850,110,'RUS-NOS','Respublika Severnaya Osetiya',43.205680847168,44.1682434082031);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3851,110,'RUS-ING','Ingushskaya Respublika',43.1348171234131,44.8754730224609);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3852,110,'RUS-AST','Astrakhanskaya oblast''',46.8121662139893,47.5092811584473);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3853,110,'RUS-KLM','Kalmykiya-Khal''mg Tangch',46.2738380432129,45.3070526123047);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3854,110,'RUS-DGS','Respublika Dagestan',43.09912109375,47.4336414337158);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3855,110,'RUS-CHG','Chechenskaya Respublika',43.2465476989746,45.7560787200928);
end;
/

prompt -- North America
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3856,120,'BLZ-BLZ','Belize',-88.2130661010742,17.5334701538086);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3857,120,'BLZ-CAY','Cayo',-88.8713989257813,16.9581928253174);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3858,120,'BLZ-CRZ','Corozal',-88.22265625,18.1932830810547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3859,120,'BLZ-OWA','Orange Walk',-88.7154312133789,17.7888164520264);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3860,120,'BLZ-SCR','Stann Creek',-88.4957046508789,16.8109703063965);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3861,120,'BLZ-TOL','Toledo',-88.800422668457,16.2940902709961);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3862,121,'CAN-ALB','Alberta',-115.00053024292,54.4997177124023);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3863,121,'CAN-BCL','British Columbia',-126.54097366333,54.1524848937988);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3864,121,'CAN-MNT','Manitoba',-95.567325592041,54.4995307922363);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3865,121,'CAN-NBR','New Brunswick',-66.4123497009277,46.3433265686035);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3866,121,'CAN-NSC','Nova Scotia',-63.0245819091797,45.2256927490234);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3867,121,'CAN-NTR','Northwest Territories',-98.7612495422363,67.5141563415527);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3868,121,'CAN-NWF','Newfoundland',-60.1988868713379,53.4928512573242);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3869,121,'CAN-ONT','Ontario',-84.7397232055664,49.2702026367188);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3870,121,'CAN-PEI','Prince Edward Island',-63.1908302307129,46.4963836669922);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3871,121,'CAN-QUE','Quebec',-68.4323654174805,53.7769393920898);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3872,121,'CAN-SSK','Saskatchewan',-105.684310913086,54.4993934631348);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3873,121,'CAN-YTR','Yukon Territory',-132.409938812256,64.8223533630371);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3874,122,'CRI-ALJ','Alajuela',-84.8001403808594,10.4512519836426);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3875,122,'CRI-CRT','Cartago',-83.6777191162109,9.80178213119507);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3876,122,'CRI-GNC','Guanacaste',-85.3375091552734,10.4704790115356);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3877,122,'CRI-HER','Heredia',-83.9550399780273,10.3705787658691);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3878,122,'CRI-LIM','Limon',-83.2521362304688,9.99398517608643);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3879,122,'CRI-PNT','Puntarenas',-83.9688186645508,9.17894554138184);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3880,122,'CRI-SJO','San Jose',-84.0107040405273,9.63235950469971);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3881,123,'CUB-CDA','Ciego de Avila',-78.7605667114258,21.6981925964355);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3882,123,'CUB-CHB','Ciudad de la Habana',-82.3155975341797,23.0658302307129);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3883,123,'CUB-CMG','Camaguey',-77.9559555053711,21.4744434356689);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3884,123,'CUB-CNF','Cienfuegos',-80.4782562255859,22.2060623168945);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3885,123,'CUB-GNT','Guantanamo',-74.8107070922852,20.2147006988525);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3886,123,'CUB-GRN','Granma',-76.9611206054688,20.2958316802979);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3887,123,'CUB-HLG','Holguin',-75.7210693359375,20.8260364532471);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3888,123,'CUB-IDL','Isla de la Juventud',-82.2797317504883,21.6877765655518);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3889,123,'CUB-LHB','La Habana',-82.2711181640625,22.8859195709229);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3890,123,'CUB-LTU','Las Tunas',-77.0732879638672,21.0672168731689);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3891,123,'CUB-MTN','Matanzas',-81.3254318237305,22.6219425201416);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3892,123,'CUB-PDR','Pinar del Rio',-83.8883361816406,22.3919410705566);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3893,123,'CUB-SDC','Santiago de Cuba',-76.2047119140625,20.2259712219238);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3894,123,'CUB-SSP','Sancti Spiritus',-79.5159683227539,22.1048583984375);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3895,123,'CUB-VCL','Villa Clara',-80.0372314453125,22.5287494659424);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3896,124,'SLV-AHC','Ahuachapan',-89.9013977050781,13.8657388687134);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3897,124,'SLV-CBN','Cabanas',-88.7329254150391,13.8787217140198);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3898,124,'SLV-CHL','Chalatenango',-89.045051574707,14.1721839904785);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3899,124,'SLV-CSC','Cuscatlan',-89.0059051513672,13.860276222229);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3900,124,'SLV-LLB','La Libertad',-89.3711471557617,13.7385034561157);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3901,124,'SLV-LPA','La Paz',-88.9629211425781,13.4663100242615);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3902,124,'SLV-LUN','La Union',-87.888298034668,13.5277376174927);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3903,124,'SLV-MRZ','Morazan',-88.0988922119141,13.764720916748);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3904,124,'SLV-SAN','Santa Ana',-89.4957046508789,14.1034917831421);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3905,124,'SLV-SMI','San Miguel',-88.2688522338867,13.5360069274902);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3906,124,'SLV-SNS','Sonsonate',-89.6951446533203,13.7120261192322);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3907,124,'SLV-SSL','San Salvador',-89.1465950012207,13.7773470878601);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3908,124,'SLV-SVC','San Vicente',-88.6923675537109,13.5323042869568);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3909,124,'SLV-USL','Usulutan',-88.4612808227539,13.4269437789917);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3910,125,'GRL-NRD','Nordgronland',-42.8070254325867,79.4045639038086);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3911,125,'GRL-OST','Ostgronland',-28.2441644668579,71.0552062988281);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3912,125,'GRL-VST','Vestgronland',-50.6206893920898,68.8951377868652);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3913,126,'GTM-AVR','Alta Verapaz',-90.1065292358398,15.6179161071777);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3914,126,'GTM-BVR','Baja Verapaz',-90.3933410644531,15.0836091041565);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3915,126,'GTM-CHM','Chimaltenango',-90.8871383666992,14.6669435501099);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3916,126,'GTM-CHQ','Chiquimula',-89.4337310791016,14.6827764511108);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3917,126,'GTM-EPR','El Progreso',-90.1016693115234,14.9169435501099);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3918,126,'GTM-ESC','Escuintla',-91.0278854370117,14.2010469436646);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3919,126,'GTM-GTM','Guatemala',-90.4872283935547,14.5884714126587);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3920,126,'GTM-HHT','Huehuetenango',-91.5493927001953,15.6145820617676);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3921,126,'GTM-IZB','Izabal',-88.9409866333008,15.5071563720703);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3922,126,'GTM-JAL','Jalapa',-89.9727783203125,14.6549987792969);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3923,126,'GTM-JUT','Jutiapa',-89.8944549560547,14.1623601913452);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3924,126,'GTM-PET','Peten',-90.2900085449219,16.8311100006104);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3925,126,'GTM-QUI','Quiche',-90.8798675537109,15.4427537918091);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3926,126,'GTM-QZL','Quezaltenango',-91.7837982177734,14.8608322143555);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3927,126,'GTM-RTL','Retalhuleu',-91.8374481201172,14.4313335418701);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3928,126,'GTM-SCH','Suchitepequez',-91.3806991577148,14.3914365768433);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3929,126,'GTM-SCT','Sacatepequez',-90.7538986206055,14.5906934738159);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3930,126,'GTM-SMR','San Marcos',-91.915901184082,14.9607439041138);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3931,126,'GTM-SOL','Solola',-91.2692947387695,14.7203950881958);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3932,126,'GTM-SRO','Santa Rosa',-90.3390426635742,14.160083770752);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3933,126,'GTM-TTN','Totonicapan',-91.3898696899414,15.041202545166);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3934,126,'GTM-ZAC','Zacapa',-89.5142211914063,15.0420827865601);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3935,127,'HTI-ART','Artibonite',-72.6312866210938,19.3166399002075);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3936,127,'HTI-CNT','Centre',-72.004467010498,19.0200929641724);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3937,127,'HTI-GAN','Grand Anse',-73.7521133422852,18.4954404830933);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3938,127,'HTI-NES','Nord-Est',-71.9036140441895,19.468355178833);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3939,127,'HTI-NOR','Nord',-72.3301124572754,19.5842504501343);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3940,127,'HTI-NOU','Nord-Ouest',-73.0223655700684,19.8530540466309);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3941,127,'HTI-OUE','Ouest',-72.4973678588867,18.6312646865845);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3942,127,'HTI-SES','Sud-Est',-72.3817710876465,18.2323760986328);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3943,127,'HTI-SUD','Sud',-73.7152786254883,18.2249784469604);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3944,129,'JAM-CLR','Clarendon',-77.3088912963867,17.9463558197021);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3945,129,'JAM-HNV','Hanover',-78.1335144042969,18.3705539703369);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3946,129,'JAM-KNG','Kingston',-76.7612113952637,17.9658632278442);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3947,129,'JAM-MNC','Manchester',-77.5000076293945,18.0373592376709);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3948,129,'JAM-PRT','Portland',-76.504753112793,18.1262969970703);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3949,129,'JAM-SAN','Saint Ann',-77.2438583374023,18.3255805969238);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3950,129,'JAM-SCT','Saint Catherine',-77.0292816162109,18.0381927490234);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3951,129,'JAM-SEL','Saint Elizabeth',-77.7638549804688,18.0408325195313);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3952,129,'JAM-SJA','Saint James',-77.8679275512695,18.3590259552002);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3953,129,'JAM-SMA','Saint Mary',-76.8856658935547,18.2755794525146);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3954,129,'JAM-SND','Saint Andrew',-76.7451858520508,18.0493469238281);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3955,129,'JAM-STH','Saint Thomas',-76.4394073486328,17.9647197723389);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3956,129,'JAM-TRL','Trelawny',-77.6152877807617,18.3505325317383);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3957,129,'JAM-WST','Westmoreland',-78.1287612915039,18.1966781616211);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3958,130,'MEX-AGS','Aguascalientes',-102.353797912598,22.0584697723389);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3959,130,'MEX-BCN','Baja California',-115.563724517822,30.3586711883545);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3960,130,'MEX-BCS','Baja California Sur',-112.222373962402,23.1599979400635);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3961,130,'MEX-CDZ','Coahuila',-101.880714416504,27.2263221740723);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3962,130,'MEX-CHH','Chihuahua',-106.218631744385,28.6949863433838);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3963,130,'MEX-CHP','Chiapas',-92.2545852661133,16.2709665298462);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3964,130,'MEX-CMP','Campeche',-90.9498672485352,19.3414764404297);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3965,130,'MEX-COL','Colima',-104.036727905273,19.103199005127);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3966,130,'MEX-DRN','Durango',-104.814865112305,24.5789089202881);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3967,130,'MEX-DTD','Distrito Federal',-99.1426467895508,19.2819423675537);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3968,130,'MEX-GNJ','Guanajuato',-100.91529083252,20.8818035125732);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3969,130,'MEX-GRR','Guerrero',-100.092922210693,17.5897674560547);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3970,130,'MEX-HDL','Hidalgo',-98.9292755126953,20.4929790496826);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3971,130,'MEX-JLS','Jalisco',-103.603404998779,20.8598594665527);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3972,130,'MEX-MDO','Michoacan',-101.901218414307,19.1574974060059);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3973,130,'MEX-MEX','Mexico',-99.5837554931641,19.3302764892578);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3974,130,'MEX-MRL','Morelos',-99.0710525512695,18.7583122253418);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3975,130,'MEX-NLE','Nuevo Leon',-99.8312530517578,25.4943046569824);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3976,130,'MEX-NYR','Nayarit',-105.318481445313,21.8832492828369);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3977,130,'MEX-OAX','Oaxaca',-96.2109603881836,17.1623601913452);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3978,130,'MEX-PUE','Puebla',-97.8884429931641,19.3412475585938);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3979,130,'MEX-QDA','Queretaro',-99.8207092285156,20.7912425994873);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3980,130,'MEX-QRO','Quintana Roo',-88.06591796875,19.712776184082);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3981,130,'MEX-SIN','Sinaloa',-107.422706604004,24.7648735046387);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3982,130,'MEX-SLP','San Luis Potosi',-100.312232971191,22.8740997314453);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3983,130,'MEX-SON','Sonora',-111.754512786865,29.3850212097168);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3984,130,'MEX-TBS','Tabasco',-92.5600128173828,17.95654296875);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3985,130,'MEX-TLX','Tlaxcala',-98.1629257202148,19.4016647338867);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3986,130,'MEX-TML','Tamaulipas',-98.6130599975586,24.9414119720459);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3987,130,'MEX-VLL','Veracruz',-96.1158142089844,19.798469543457);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3988,130,'MEX-YCT','Yucatan',-88.9724502563477,20.6309700012207);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3989,130,'MEX-ZCT','Zacatecas',-102.576103210449,23.1049976348877);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3990,131,'NIC-BOA','Boaco',-85.4626388549805,12.3774719238281);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3991,131,'NIC-CAR','Carazo',-86.2885437011719,11.7340269088745);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3992,131,'NIC-CHN','Chinandega',-87.1680679321289,12.8782691955566);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3993,131,'NIC-CHT','Chontales',-85.2322044372559,11.883828163147);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3994,131,'NIC-EST','Esteli',-86.4170989990234,13.1738882064819);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3995,131,'NIC-GRN','Granada',-85.9384307861328,11.9613962173462);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3996,131,'NIC-JNT','Jinotega',-85.5338821411133,13.7828674316406);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3997,131,'NIC-LEO','Leon',-86.6978302001953,12.5415272712708);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3998,131,'NIC-MAN','Managua',-86.2792358398438,12.2009029388428);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(3999,131,'NIC-MAS','Masaya',-86.1205673217773,12.0042772293091);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4000,131,'NIC-MDR','Madriz',-86.3944549560547,13.4167041778564);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4001,131,'NIC-MTG','Matagalpa',-85.701789855957,12.9451379776001);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4002,131,'NIC-NSE','Nueva Segovia',-86.2502975463867,13.7593040466309);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4003,131,'NIC-RIV','Rivas',-85.6698455810547,11.4715285301208);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4004,131,'NIC-RSJ','Rio San Juan',-84.4089889526367,11.2884712219238);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4005,131,'NIC-ZEL','Zelaya',-84.1182022094727,12.9826374053955);

insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4006,132,'PAN-BDT','Bocas del Toro',-82.0500030517578,9.06416511535645);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4007,132,'PAN-CHR','Chiriqui',-82.253547668457,8.44041156768799);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4008,132,'PAN-COC','Cocle',-80.4276962280273,8.53583240509033);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4009,132,'PAN-COL','Colon',-79.9711151123047,9.1208324432373);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4010,132,'PAN-DAR','Darien',-77.8454208374023,8.1579155921936);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4011,132,'PAN-HRR','Herrera',-80.6599426269531,7.83116722106934);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4012,132,'PAN-LSN','Los Santos',-80.3505020141602,7.61694717407227);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4013,132,'PAN-PAN','Panama',-79.1034851074219,8.83999919891357);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4014,132,'PAN-SBL','San Blas',-78.3134765625,9.04874897003174);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,centroid_x,centroid_y) values(4015,132,'PAN-VRG','Veraguas',-81.2555541992188,8.04263830184937);
end;
/
begin
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,cntry_name,centroid_x,centroid_y) values(4016,133,'CAN-ALB','Alberta','Canada',-115.00053024292,54.4997177124023);
insert into wwv_flow_flash_map_regions(id,file_id,region_id,region_name,cntry_name,centroid_x,centroid_y) values(4017,133,'CAN-BCL','British Columbia','Canada',-126.54125213623,54.1524848937988);
insert 