set define '^' verify off
prompt ...apex_mig_projects_update_int
create or replace package apex_mig_projects_update_int as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2008 - 2018. All Rights Reserved.
--
--    NAME
--      apex_mig_projects_update.sql
--
--    DESCRIPTION
--      API to allow update to select attributes via mechanism other than APEX.
--
--    MODIFIED   (MM/DD/YYYY)
--    hfarrell   01/11/2008 - Created
--    hfarrell   01/23/2008 - Updated upd_mig_rev_forms to default p_source_name to null, and remove p_mig_type and p_source
--                            Updated upd_mig_rev_reports to default p_source_name to null, and remove p_status
--                            Renamed p_security_group_id to p_workspace_id to correspond with reference in APEX_MIGRATION views
--    jkallman   07/08/2008 - Changed FLOWS_030100 references to FLOWS_040000
--    jkallman   10/02/2008 - Changed FLOWS_040000 references to APEX_040000
--    cneumuel   01/31/2017 - Make package invoker rights (bug #25310408)
--    cneumuel   11/07/2018 - Moved implementation to apex_mig_projects_update_int (bug #27722884)
--
--------------------------------------------------------------------------------

--==============================================================================
-- see apex_mig_projects_update
--==============================================================================
procedure upd_mig_rev_forms (
    p_project_id            in number,
    p_dbid                  in number,
    p_formid                in number,
    p_workspace_id          in number,
    p_source_name           in varchar2 default null,
    p_source_syntax         in varchar2,
    p_source_status         in varchar2,
    p_current_user          in varchar2 );

--==============================================================================
-- see apex_mig_projects_update
--==============================================================================
procedure upd_mig_rev_reports (
    p_project_id            in number,
    p_dbid                  in number,
    p_reportid              in number,
    p_workspace_id          in number,
    p_source_name           in varchar2 default null,
    p_source_syntax         in varchar2,
    p_source_status         in varchar2,
    p_current_user          in varchar2 );

end apex_mig_projects_update_int;
/
show errors
