set define '^'
prompt Creating APEX dictionary views

Rem  Copyright (c) Oracle Corporation 2006 - 2019. All Rights Reserved.
Rem
Rem    NAME
Rem      apex_views.sql
Rem
Rem    DESCRIPTION
Rem      data dictionary views of Oracle APEX meta data
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem    mhichwa     06/22/2006 - Created
Rem    mhichwa     06/26/2006 - Improved
Rem    mhichwa     06/26/2006 - Added public synonyms and improved where clause
Rem    mhichwa     06/27/2006 - Added views
Rem    mhichwa     06/28/2006 - decoded internal data representations into readable values
Rem    mhichwa     06/29/2006 - Added dictionary comments
Rem    mhichwa     06/29/2006 - Added template dictionary views
Rem    mhichwa     06/30/2006 - Added workspace views
Rem    mhichwa     06/30/2006 - Improved definition of regions and buttons added apex_workspace_files and branches
Rem    mhichwa     07/01/2006 - Added dictionary comments and apex_workspace_sql_scripts view
Rem    mhichwa     07/02/2006 - Added and improved dictionary comments
Rem    mhichwa     07/03/2006 - Added list entries view and improved apex_dictionary
Rem    mhichwa     07/03/2006 - Added supporting object views
Rem    mhichwa     07/04/2006 - Added additional comments
Rem    mhichwa     07/05/2006 - Added additional comments
Rem    mhichwa     07/06/2006 - Added comments, refined queries
Rem    mhichwa     07/07/2006 - Added comments, refined queries
Rem    mhichwa     07/09/2006 - Added comments, refined queries
Rem    jkallman    07/10/2006 - Add proper define character
Rem    msewtz      07/13/2006 - Added missing comments
Rem    jstraub     08/11/2006 - Added views for clickthru logs, bug 5439502
Rem    sspadafo    08/26/2006 - Fixed decode for named_list_of_values in apex_application_page_rpt_cols (Bug 5494575)
Rem    madelfio    08/29/2006 - Fixed spelling errors (Bug 5499606)
Rem    jstraub     08/30/2006 - Removed apex_clicks and augmented apex_workspace_clicks to constrain by SGID
Rem    madelfio    08/30/2006 - Fixed spelling errors (Bug 5499606)
Rem    jkallman    09/29/2006 - Updated schema references to FLOWS_030100
Rem    mhichwa     12/04/2006 - Added signature column
Rem    mhichwa     12/04/2006 - Validations view now returns associated item name and not item id
Rem    mhichwa     12/05/2006 - Fix bug in page_regions view that does not properly report FUNCTION_RETURNING_SQL_QUERY
Rem    mhichwa     12/06/2006 - Added view apex_component_signatures
Rem    jkallman    12/12/2006 - Change apex_component_signatures so it compiles
Rem    mhichwa     12/13/2006 - Added additional component signature columns
Rem    mhichwa     12/13/2006 - removed trailing space from hidden
Rem    mhichwa     12/28/2006 - Added apex_developer_audit_log
Rem    mhichwa     01/02/2007 - Added support for pre_element_text
Rem    mhichwa     01/02/2007 - Added region_id foreign key in apex_application_page_items view per otn forum request
Rem    mhichwa     01/02/2007 - Added region_id foreign key in apex_application_page_buttons view per otn forum request
Rem    mhichwa     01/02/2007 - Added support for regions from cache
Rem    mhichwa     01/02/2007 - apex_application_computations exposed build_option, fixed authorization scheme column
Rem    mhichwa     01/02/2007 - apex_application_processes fixed lookup on build_option
Rem    mhichwa     01/02/2007 - added apex_application_page_items.ITEM_LABEL_TEMPLATE_ID
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_items, apex_application_pages, apex_applications
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_regions
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_rpt_cols, apex_application_page_proc, apex_application_page_comp,
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_page_branches, apex_application_page_val, apex_application_page_buttons,
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to view apex_application_tabs, apex_application_parent_tabs, apex_application_processes
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_computations, apex_application_nav_bar, apex_application_bc_entries
Rem    mhichwa     01/02/2007 - added AUTHORIZATION_SCHEME_ID to apex_application_list_entries
Rem    mhichwa     01/02/2007 - added build_option_id to apex_application_page_regions
Rem    mhichwa     01/02/2007 - added support for region_caching, timeout_cache_after, cache_when, cache_when_expression_1, cache_when_expression_2
Rem    mhichwa     01/02/2007 - added item_help_text to apex_application_page_items, fixed decode of checkbox display_as column as well
Rem    mhichwa     01/02/2007 - added page_group and page_group_id to apex_application_pages view
Rem    mhichwa     01/05/2007 - improved description of template tables
Rem    jkallman    01/11/2007 - Remove extraneous lines from apex_component_signatures
Rem    cbcho       01/18/2007 - Added POPUP_ICON2,POPUP_ICON_ATTR2 in apex_application_temp_popuplov
Rem    cbcho       01/23/2007 - Added apex_application_page_flash_ch and apex_application_page_flash_s
Rem    mhichwa     01/24/2007 - Added view apex_workspace_access_log, none public
Rem    mhichwa     01/26/2007 - Added view apex_developer_activity_log
Rem    mhichwa     01/29/2007 - Added missing grant select on apex_developer_activity_log to public
Rem    cbcho       02/02/2007 - Added new columns for apex_application_page_flash_ch
Rem    mhichwa     02/02/2007 - Added think time to activity log as well as seconds ago
Rem    cbcho       02/02/2007 - Added new columns to apex_application_page_flash_ch
Rem    mhichwa     02/05/2007 - Added view apex_application_page_groups
Rem    jstraub     02/05/2007 - Added daily_month_title_format to apex_application_temp_calendar
Rem    jstraub     02/06/2007 - Added the rest of new columns to apex_application_temp_calendar
Rem    mhichwa     02/06/2007 - Added apex_application_page_rpt to expose new region printing attributes
Rem    mhichwa     02/07/2007 - Modified apex_dictionary to accomidate new views
Rem    mhichwa     02/07/2007 - Added report column comment attribute to view per user request
Rem    mhichwa     02/09/2007 - Added report header and footer to region view
Rem    jstraub     02/15/2007 - Added region_position_code to apex_application_page_regions (Bug 5879351)
Rem    sspadafo    02/18/2007 - Change views to recognize negative form of build options
Rem    sspadafo    02/18/2007 - Changed a couple references to REQUIRED_PATCH to SECURITY_SCHEME
Rem    sspadafo    02/18/2007 - Changed 3 occurrences of "chucksum" to "checksum"
Rem    mhichwa     02/19/2007 - Added comments on component signature columns
Rem    mhichwa     02/20/2007 - Added cached pages and cached regions counts to apex_applictions view
Rem    mhichwa     02/20/2007 - Added missing columns to apex_application_pages
Rem    mhichwa     02/20/2007 - Added referenced owner, table and column to APEX_APPLICATION_PAGE_RPT_COLS view
Rem    mhichwa     02/23/2007 - Added view apex_application_caching view
Rem    mhichwa     02/23/2007 - Added comment for apex_application_caching.page_id column
Rem    mhichwa     02/23/2007 - Improved reporting of page zero region caching in apex_application_caching view
Rem    mhichwa     02/26/2007 - Improved apex_application_auth, added apex_application_substitutions
Rem    mhichwa     02/26/2007 - Improved apex_application_authorization, apex_application_lovs, apex_application_nav_bar
Rem    mhichwa     02/26/2007 - Improved apex_application_page_buttons
Rem    mhichwa     02/28/2007 - Added component_signature column apex_application_page_comp
Rem    mhichwa     02/28/2007 - Added 30 display types to apex_application_page_items
Rem    mhichwa     02/28/2007 - Added when_button_pressed_id column to facilitate joins to buttons table in APEX_APPLICATION_PAGE_PROC
Rem    mhichwa     02/28/2007 - APEX_APPLICATION_PAGE_REGIONS added customization, customization_name, list_template_override_id, HTML_table_cell_attributes
Rem    mhichwa     02/28/2007 - Unioned apex_application_page_comp into component_signatures view
Rem    mhichwa     03/02/2007 - Added last_purged_session column to apex_workspaces view to report last session information bug 5912733
Rem    mhichwa     03/09/2007 - Exposed MultiColumn_Region_Table_Attr column in APEX_APPLICATION_TEMP_PAGE view, bug 5920988
Rem    mhichwa     03/09/2007 - Fixed bug in apex_application_computations with null of c.SECURITY_SCHEME not required patch.  Bug 5920988
Rem    mhichwa     03/15/2007 - Exposed static_id column in apex_application_page_regions, this is wwv_flow_page_plugs.region_name, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed max_dynamic_report_cols in apex_application_page_regions, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed report_column_source_type in apex_application_page_regions, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed PLUG_QUERY_HEADINGS_TYPE in apex_application_page_regions, bug 5936078
Rem    mhichwa     03/15/2007 - Exposed break_display_text in apex_application_page_regions, bug 5936078
Rem    mhichwa     05/01/2007 - 5936078 Added apex_application_page_regions.breadcrumb_template and apex_application_page_regions.breadcrumb_template_id
Rem    mhichwa     05/01/2007 - 5936078 Added  report_template_id
Rem    mhichwa     05/02/2007 - 5936078 Added page function to apex_application_pages view
Rem    mhichwa     05/02/2007 - 5936078 Properly compute number of items and buttons in apex_application_pages view
Rem    mhichwa     05/02/2007 - 5936078 Added list entries column to apex_application_lists view
Rem    mhichwa     05/02/2007 - 5936078 Properly report authentication scheme in the apex_applictions view
Rem    mhichwa     05/02/2007 - 5936078 Added workspace id to apex applications view to facilitate joins with workspace view
Rem    mhichwa     05/02/2007 - 5936078 Added workspace id to apex_workspace_activity_log
Rem    jstraub     05/04/2007 - 6034426 Added apex_release
Rem    jstraub     05/08/2007 - Added api_compatibility and patch_applied to apex_release
Rem    mhichwa     05/09/2007 - Reworked view apex_workspace_files to have it properly return file names and work from SQL Developer
Rem    mhichwa     05/09/2007 - Removed extra sub query from apex_workspace_files
Rem    mhichwa     05/18/2007 - Extended where clause on most views
Rem    mhichwa     05/25/2007 - Changed application_comment_id to application_computation_id (bug 6075191)
Rem    mhichwa     05/31/2007 - Changed apex_workspace_schemas view to use nvl 0, and not nvl _ to avoid an invalid number error from sql dev (bug 6085543)
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_applications
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_workspace_schemas
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_workspace_sessions
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_workspace_apex_users
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_pages
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_groups
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_items
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_get_pg_tname
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_db_items
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_regions
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_rpt
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_rpt_cols
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_proc
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_comp
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_branches
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_page_buttons
Rem    mhichwa     05/31/2007 - bug 6085543 Use 0 not _ in nvl call in apex_application_build_options
Rem    madelfio    06/05/2007 - Added columns for upgrade scripts to apex_application_supp_objects and apex_application_supp_obj_scr (Bug 6114786)
Rem    mhichwa     06/13/2007 - bug 6130280 Use 0 not '_' in nvl calls in apex_workspaces and other views to prevent invalid number oracle error
Rem    sspadafo    06/29/2007 - Fixed transposed column names of last_updated_by/last_updated_on in apex_application_translations and apex_application_trees
Rem    sspadafo    06/30/2007 - Revised comment on table apex_workspace_files
Rem    jkallman    08/02/2007 - Change FLOWS_030000 references to FLOWS_030100
Rem    madelfio    08/16/2007 - Added views for apex worksheets
Rem    jstraub     08/23/2007 - Added apex_appliation_page_wsrcat
Rem    jstraub     08/24/2007 - Fixed apex_appliation_page_wsrcat
Rem    jstraub     08/27/2007 - Added parent_category_id to apex_appliation_page_wsrcat, removed parent_category
Rem    jstraub     08/28/2007 - Added category_id to apex_application_page_wsrpts
Rem    madelfio    09/05/2007 - Removed bad filter in apex_appliation_page_wsrpts definition
Rem    jstraub     10/09/2007 - Added description to apex_application_page_wsrpts
Rem    mhichwa     10/16/2007 - Added support for item_is_not_numeric condition type
Rem    jkallman    10/16/2007 - Added media_type to apex_applications and apex_application_pages
Rem    mhichwa     10/24/2007 - Added application_group and application_group_id columns to apex_applications view
Rem    mhichwa     10/24/2007 - Added apex_application_groups view
Rem    madelfio    11/01/2007 - Added apex_application_page_wsrpts.display_sequence
Rem    jkallman    11/19/2007 - Added date_format to apex_applications
Rem    mhichwa     11/20/2007 - Removed where clause on apex_applications to show run only applications
Rem    jkallman    11/20/2007 - Added PICK_DATE_USING_APP_DATE_FORMAT to apex_application_page_items
Rem    mhichwa     11/28/2007 - Added runtime_where_clause to page_proc view, and theme_description to theme view
Rem    mhichwa     11/29/2007 - fixed bug in apex_applications view
Rem    mhichwa     11/30/2007 - Added 'P','Partial Page' to activity log decode
Rem    sspadafo    12/01/2007 - Added 'HIDDEN_PROTECTED' to item type decodes
Rem    jstraub     12/03/2007 - Added ajax_enabled to apex_application_page_regions
Rem    jstraub     12/03/2007 - Added before_column_heading and after_column_heading to apex_application_temp_report
Rem    mhichwa     12/05/2007 - Added support for logging of page processing
Rem    jstraub     12/10/2007 - Added prn_print_server_overwrite to apex_application_page_rpt
Rem    mhichwa     12/10/2007 - Removed box_footer_text body_footer page attribute from apex_appliation_pages view
Rem    mhichwa     12/11/2007 - Added support for the region attributes substitution string
Rem    jstraub     12/12/2007 - Added prn_content_disposition, prn_document_header, prn_units to apex_application_page_rpt
Rem    mhichwa     01/04/2008 - Rename apex_worksheet_columns to apex_appliation_page_wsrptc
Rem    mhichwa     01/04/2008 - Rename apex_worksheet_rpts to apex_appliation_page_wsrpts
Rem    mhichwa     01/04/2008 - Rename apex_worksheet_categories to apex_appliation_page_wsrcat
Rem    mhichwa     01/04/2008 - Renamed IR column worksheet_id to interactive_report_id
Rem    mhichwa     01/07/2008 - Added INCLUDE_APEX_CSS_JS_YN column bug 6706084
Rem    hfarrell    01/11/2008 - Added Migration Project views from mig_views.sql with naming convention APEX_MIGRATION_object
Rem    jkallman    01/11/2008 - Corrected typos in views APEX_APPLICATION_PAGE_WSRPTC and APEX_APPLICATION_PAGE_WSRCAT
Rem    jkallman    01/11/2008 - Remove migration views
Rem    sbkenned    01/16/2008 - added APEX_UI_DEFAULTS_TABLES, APEX_UI_DEFAULTS_COLUMNS, and APEX_UI_DEFAULTS_LOV_DATA
Rem    sbkenned    01/16/2008 - fixed APEX_APPLICATION_GROUPS (bug 6752552)
Rem    madelfio    01/18/2008 - Added page_id to apex_application_page_wsrpts
Rem    madelfio    01/24/2008 - Added/updated interactive report views
Rem    madelfio    01/25/2008 - Added/updated interactive report views
Rem    mhichwa     02/15/2008 - Changed apex_application_pages to lookup page auth scheme name
Rem    madelfio    02/15/2008 - Added component signatures for _IR views (bug 6792835)
Rem    jkallman    02/21/2008 - Moved interactive reports views before component signature views
Rem    madelfio    02/21/2008 - Fixed issues with interactive reports in APEX views (bug 6835427)
Rem    cbcho       04/09/2008 - Added apex_themes (bug 6934007)
Rem    mhichwa     04/10/2008 - Added apex_application_temp_report.template_id column (bug 6952089)
Rem    jkallman    05/16/2008 - Change apex_ui views to create or replace, to make apex_views rereunnable
Rem    cbcho       05/21/2008 - Added inclusion of apex_themes in apex_dictionary (bug 7111415)
Rem    jkallman    07/08/2008 - Changed FLOWS_030100 references to FLOWS_040000
Rem    sspadafo    08/06/2008 - Added check_id to apex_application_supp_obj_chck. Added column comment also. (Bug 7120472)
Rem    sspadafo    08/06/2008 - Changed apex_application_supp_obj_scr to return i.id as supporting_object_script_id (Bug 7120472)
Rem    sspadafo    08/06/2008 - Adjustments to apex_dictionary to correct child-parent associations (Bug 7043109)
Rem    sspadafo    08/13/2008 - Adjustment to apex_dictionary to add missing trailing slashes and to make apex_application_page_regions the parent of apex_application_page_ir (Bug 7043109)
Rem    mhichwa     08/28/2008 - Expanded definition of apex_application_page_ir view adding report_view and icon_view columns
Rem    mhichwa     09/02/2008 - Extended apex_application_page_regions to include flash charts
Rem    mhichwa     09/03/2008 - Added view apex_components for use by the application builder
Rem    mhichwa     09/08/2008 - Added support for dynamic actions and enhanced the view apex_components
Rem    mhichwa     09/09/2008 - Added report columns to apex_components view
Rem    mhichwa     09/10/2008 - improved apex_components view
Rem    mhichwa     09/12/2008 - replace nv calls to use wwv_flow calls to improve performance
Rem    jkallman    10/02/2008 - Changed FLOWS_040000 references to APEX_040000
Rem    jstraub     12/23/2008 - Added form_autocomplete to apex_application_pages
Rem    mhichwa     12/23/2008 - Added support for encryption in apex_application_page_items
Rem    mhichwa     12/23/2008 - Changed definition of password fields
Rem    jstraub     12/29/2008 - Changed apex_components to include PASSWORD DNSS
Rem    sspadafo    01/03/2009 - Added use_secure_cookie_yn to apex_application_auth
Rem    mhichwa     01/06/2009 - corrected decode for item types _DNSS
Rem    mhichwa     01/06/2009 - fixed  page_requires_Authentication column
Rem    sspadafo    01/11/2009 - Added save_state_before_branch_yn to apex_application_page_branches
Rem    sspadafo    01/11/2009 - Fixed component_signature for page_is_public_y_n in apex_application_pages
Rem    sspadafo    01/11/2009 - Added session timeout columns to apex_applications
Rem    sspadafo    01/12/2009 - Added comments on session timeout columns in apex_applications and fixed comment on save_state_before_branch in apex_application_page_branches
Rem    pawolf      02/27/2009 - Added new item type 'TEXTAREA_RESIZABLE'
Rem    sbkenned    03/12/2009 - Added apex_ui_defaults_groups and revised apex_ui_defaults_columns to include group_name
Rem    mhichwa     03/19/2009 - removed and (user in ('SYS','SYSTEM', 'APEX_040000') or w.PROVISIONING_COMPANY_ID != 10)
Rem    pawolf      03/26/2009 - Added runtime_where_clause to APEX_APPLICATION_PAGE_PROC and REGION_NAME to APEX_APPLICATION_PAGE_IR required by the Advisor
Rem    pawolf      04/23/2009 - Added plugin views
Rem    pawolf      05/05/2009 - Used wwv_flow_standard_item_types instead of hardcoded values
Rem    pawolf      05/06/2009 - Added apex_application_plugin_files
Rem    jkallman    05/06/2009 - Added column column_expr to apex_application_page_ir_col (Bug 8494970)
Rem    pawolf      05/07/2009 - Added file_charset to wwv_flow_plugin_files
Rem    mhichwa     05/09/2009 - Added view apex_application_trans_map
Rem    mhichwa     05/11/2009 - remove restriction on viewing components within translated applications
Rem    mhichwa     05/11/2009 - removed view apex_components as it is no longer needed with power search
Rem    sspadafo    05/12/2009 - Changed several views to correct build option error (Bug 8512898)
Rem    pawolf      05/14/2009 - Added dynamic attributes to plugins
Rem    pawolf      05/15/2009 - Added dynamic attributes to regions
Rem    pawolf      06/03/2009 - Renamed wwv_flow_plugin_attributes.attribute_level to attribute_scope
Rem    pawolf      06/04/2009 - Modified subscription columns for plugin view
Rem    arayner     06/05/2009 - Added dynamic action tables to apex_developer_activity_log view
Rem    arayner     06/25/2009 - Added 2 new dynamic action view definitions and added references to new views in apex_dictionary view
Rem    pawolf      07/15/2009 - Added help_text to apex_application_plugins
Rem    cbcho       07/20/2009 - Added allow_highlighting to apex_application_page_ir_col
Rem    cbcho       07/21/2009 - Added show_notify to apex_application_page_ir
Rem    mhichwa     07/22/2009 - added primary_application_id and TRANSLATED_APP_LANGUAGE to lov and list entry views
Rem    pawolf      07/23/2009 - Added additional apex_application_plugin_attrs.attribute_type
Rem    pawolf      07/24/2009 - Added new columns to wwv_flow_plugins and wwv_flow_plugin_attributes
Rem    pawolf      07/27/2009 - Added new view apex_application_plugin_events
Rem    jkallman    07/28/2009 - Added timestamp_format and timestamp_tz_format to apex_applications
Rem    cbcho       07/31/2009 - Added apex_application_page_ir_ntfy, apex_application_page_ir_grpby
Rem    cbcho       08/03/2009 - Added allow_delete, expr_type to apex_application_page_ir_cond (bug 8758819)
Rem    cbcho       08/03/2009 - Added apex_application_page_ir_comp (bug 8758810)
Rem    jkallman    08/05/2009 - Added support for ITEM_IS_TIMESTAMP in view apex_application_page_val
Rem    mhichwa     08/05/2009 - Added display_region_selector
Rem    cbcho       08/07/2009 - Added base_table_or_view in apex_application_page_ir
Rem    arayner     08/14/2009 - Added new long operation processing columns to apex_application_page_buttons view
Rem    pawolf      08/18/2009 - Added columns for hierarchical regions
Rem    pawolf      08/26/2009 - Fixed install errors
Rem    pawolf      08/31/2009 - Added columns display_as_code and source_type_code
Rem    jkallman    08/31/2009 - Added apex_applications.auto_time_zone
Rem    pawolf      09/02/2009 - Modified apex_application_substitutions
Rem    msewtz      09/14/2009 - Added associated column to apex_application_page_val
Rem    pawolf      09/15/2009 - Added NATIVE plug-ins
Rem    msewtz      09/16/2009 - Aded TABULAR_FORM_REGION_ID to apex_application_page_val
Rem    pawolf      09/17/2009 - Added page level on-demand processes
Rem    pawolf      09/18/2009 - Added comment column for apex_application_page_ir_col
Rem    arayner     09/22/2009 - Fixed typo on comment on apex_application_page_da view
Rem    pawolf      09/24/2009 - Added view apex_appl_plugin_attr_values, renamed existing plugin views for consistency
Rem    pawolf      09/28/2009 - Added plug-in support for classic reports
Rem    pawolf      10/16/2009 - Added conditions to plugin attributes
Rem    pawolf      10/21/2009 - Added dynamic attributes to wwv_flow_hnt_column_info
Rem    pawolf      10/23/2009 - Added is_required to wwv_flow_step_items and wwv_flow_region_report_column
Rem    pawolf      10/27/2009 - Added default_error_display_location to apex_applications
Rem    pawolf      10/28/2009 - Removed error_display_location from wwv_flow_plugins
Rem    jkallman    11/03/2009 - Add condition_expression3 to apex_application_page_ir_cond
Rem    sbkenned    11/04/2009 - Added object_name to apex_developer_audit_log & apex_developer_activity_log
Rem                           - Added WWV_FLOW_SHARED_WEB_SERVICES and WWV_FLOW_SECURITY_SCHEMES to apex_developer_audit_log & apex_developer_activity_log
Rem    sbkenned    11/05/2009 - Added WWV_FLOW_TREES to apex_developer_audit_log & apex_developer_activity_log
Rem    jkallman    11/05/2009 - Added tz_dependent to apex_application_page_ir_col
Rem    sbkenned    11/05/2009 - Added WWV_FLOW_SHARED_QUERIES & WWV_FLOW_REPORT_LAYOUTS to apex_developer_audit_log & apex_developer_activity_log
Rem    cbcho       11/06/2009 - Removed number_of_saved_reports, show_reports_as_tabs from apex_application_page_ir
Rem    cbcho       11/06/2009 - Added number_of_alt_default_reports,number_of_public_reports,number_of_private_reports,show_reports_select_list to apex_application_page_ir
Rem    cbcho       11/06/2009 - Added report_alias, report_link_example, more values in report_type to apex_application_page_ir_rpt
Rem    cbcho       11/11/2009 - Changed v('APP_SESSION') to &APP_SESSION. in apex_application_page_ir_rpt
Rem    jkallman    11/17/2009 - Change expr3 to time_zone in apex_application_page_ir_cond
Rem    cbcho       11/20/2009 - Added count_distnt_col_on_break to apex_application_page_ir_rpt
Rem    cbcho       11/20/2009 - Added allow_save_rpt_public,save_rpt_public_auth_scheme to apex_application_page_ir
Rem    arayner     11/20/2009 - Added default_irr_template column to apex_application_themes
Rem    cbcho       11/23/2009 - Added Interactive Report log columns to apex_workspace_activity_log
Rem    mhichwa     11/24/2009 - added 4 columns to view apex_application_temp_list
Rem    cbcho       11/25/2009 - Added allow_group_by,allow_hide to apex_application_page_ir_col
Rem    mhichwa     11/30/2009 - added team dev views todos, milestones, bugs and feedback
Rem    mhichwa     11/30/2009 - moved team dev views to team_tab.sql as team dev view are not needed for runtime only operation
Rem    jstraub     12/03/2009 - Added apex_team_feedback
Rem    sbkenned    12/11/2009 - Added new columns to apex_team_feedback; tags, public_response, label_01-08
Rem    pawolf      12/14/2009 - Added new columns for javascript to wwv_flow_steps
Rem    hfarrell    12/15/2009 - Added FLASH_CHART5 and FLASH_MAP to apex_application_page_regions. Added views apex_application_page_flash5 and apex_application_page_flash5_s.
Rem    hfarrell    12/15/2009 - Added comment on apex_application_page_flash5.map_attr column
Rem    sbkenned    12/15/2009 - Added apex_ui_defaults_attr_dict to support new UI Defaults Attribute Dictionary
Rem                           - Updated apex_dictionary to include APEX_UI_DEFAULTS%
Rem    jkallman    12/15/2009 - Commented out apex_team_feedback.tags
Rem    mhichwa     12/20/2009 - Added apex_team views to apex_dictionary
Rem    mhichwa     12/20/2009 - uncomment feedback tags, verified tags column exists in tab.sql
Rem    pawolf      12/29/2009 - Added "standard_validations" to wwv_flow_step_items and wwv_flow_region_report_column
Rem    pawolf      01/08/2010 - Added new columns to wwv_flow_plugins
Rem    jstraub     01/12/2010 - Added soap_version to apex_application_web_services and rest_enabled to apex_application_page_regions
Rem    cbcho       01/14/2010 - Added email_address to apex_application_page_ir_ntfy
Rem    pawolf      01/20/2010 - Added escape_on_http_output to wwv_flow_step_items
Rem    pawolf      01/22/2010 - Removed PLSQL_ANONYMOUS_BLOCK source type of wwv_flow_step_items
Rem    cbcho       01/22/2010 - Renamed apex_application_page_ir_ntfy to apex_application_page_ir_sub and added owner to the view
Rem    cbcho       01/22/2010 - Added show_rows_per_page to apex_application_page_ir view
Rem    pawolf      01/23/2010 - Added support for IR columns based on LOV
Rem    mhichwa     01/26/2010 - added apex_debug_messages
Rem    pawolf      01/27/2010 - Added Display Sequence to plug-in attributes
Rem    pawolf      02/02/2010 - Added cascading lov columns to wwv_flow_step_items
Rem    pawolf      02/05/2010 - Renamed wwv_flow_plugins callout procedure columns
Rem    pawolf      02/08/2010 - Removed apex_application_page_items.lov_columns
Rem    pawolf      02/08/2010 - Added QUERY_COLON as item source type and computation type
Rem    pawolf      02/11/2010 - Added columns button_execute_validations and always_execute
Rem    jkallman    02/12/2010 - Add missing columns and comments to apex_debug_messages, change 'Apex' to 'APEX' in all comments
Rem    sbkenned    02/16/2010 - Removed form_display_as from apex_ui_defaults
Rem    pawolf      02/19/2010 - Removed wwv_flow_plugin_attributes.is_stored_in_clob
Rem    pawolf      02/20/2010 - Added support for process plugins
Rem    pawolf      02/23/2010 - Fixed misspelled always_execute
Rem    pawolf      02/24/2010 - Added deployment_system to apex_team_feedback
Rem    mhichwa     03/10/2010 - corrected APEX_DEBUG_MESSAGES to include a union all
Rem    sbkenned    03/11/2010 - added created_on,created_by to APEX_APPLICATION_PAGES
Rem    mhichwa     03/13/2010 - added extra columns and reworked last login query on apex_workspaces view
Rem    mhichwa     03/15/2010 - improved comments on apex_workspaces
Rem    jkallman    03/20/2010 - Change all_ references to sys.dba_ references
Rem    jkallman    03/24/2010 - Reverted sys.dba_ references to all_ references in apex_dictionary, apex_workspace_schemas
Rem    pawolf      03/31/2010 - Added execution_time to apex_debug_messages
Rem    arayner     04/06/2010 - Improved comments on dynamic action related views (apex_application_page_da and apex_application_page_da_acts)
Rem    pawolf      04/06/2010 - Added comments for quick pick columns
Rem    cbcho       04/08/2010 - Added show_group_by to apex_application_page_ir
Rem    pawolf      04/14/2010 - Added stop_execution_on_error to wwv_flow_page_da_actions
Rem    cbcho       04/15/2010 - Added status,error_message to apex_application_page_ir_sub
Rem    arayner     04/16/2010 - Renamed columns in apex_application_page_da to be consistent with UI
Rem    sbkenned    04/16/2010 - Updated apex_team_feedback to include all columns and comments for all
Rem    pawolf      04/17/2010 - Renamed lov_items_to_submit and lov_optimize_refresh to ajax_item_to_submit and ajax_optimize_refresh
Rem    pawolf      04/18/2010 - Added category to wwv_flow_plugins
Rem    pawolf      04/22/2010 - Added flow_id and page_id to wwv_flow_page_da_actions
Rem    arayner     04/23/2010 - Removed show_wait related columns from apex_application_page_buttons
Rem    jkallman    04/26/2010 - Correct missing quote from column comment on apex_team_feedback.server_name
Rem    pawolf      04/28/2010 - Bug# 9660072: apex_application_page_da_acts.action_name didnt return the display value of the action
Rem    sbkenned    04/29/2010 - Updated 2 feedback comments
Rem    sbkenned    05/03/2010 - Added view for feedback followup
Rem    mhichwa     05/04/2010 - added apex_workspace_log_archive
Rem    jkallman    05/04/2010 - Reverted SYS.DBA references to SYS.ALL references in apex_dictionary
Rem    hfarrell    05/12/2010 - Updated view apex_application_page_flash5 to include missing columns: x & y axis major interval, minor interval, gantt_start_date, gantt_end_date
Rem                             Added view apex_application_tree_regions for jstree
Rem    hfarrell    05/12/2010 - Updated apex_application_tree_regions to include region_id and region_name
Rem    hfarrell    05/14/2010 - Renamed view apex_application_tree_regions to apex_application_page_trees, and added apex_application_page_trees to apex_dictionary
Rem    jkallman    05/18/2010 - Remove blank line in the definition of apex_application_page_trees
Rem    sbkenned    05/20/2010 - Updated apex_application_page_regions to fix source type for new region types and added list_id
Rem    sbkenned    05/26/2010 - Added content_length to apex_workspace_activity_log (bug 9751911), added team dev view paths to apex_dictionary
Rem    pawolf      06/14/2010 - Bug# 9815546 - added region_id to apex_application_page_ir_col
Rem    arayner     09/07/2010 - Added partition by clause to execution_time calculation in apex_debug_messages (bug #10092894)
Rem    jkallman    11/08/2010 - Added report_column_width to view apex_application_page_rpt_cols (Bug 10270281)
Rem    jkallman    11/22/2010 - Change APEX_040000 references to APEX_040100
Rem    pawolf      12/14/2010 - Added attribute_11 - attribute_15 to all tables supporting plug-ins (feature# 572)
Rem    pawolf      01/17/2011 - Added columns to apex_application_page_val and apex_application_page_proc (feature# 542)
Rem    pawolf      01/20/2011 - Added column condition_type_code to several views to get the internal language neural code for the Advisor
Rem    pawolf      01/21/2011 - Added columns CURRENT_FOR_PAGES_TYPE_CODE and DISPLAY_CONDITION_TYPE_CODE for APEX_APPLICATION_LIST_ENTRIES and APEX_APPLICATION_PAGE_IR_COL
Rem    pawolf      01/27/2011 - Replaced "Item\Column" with "Item / Column" in view apex_standard_conditions
Rem    cneumuel    02/02/2011 - Added plugin support for authorization (feature #580)
Rem    hfarrell    02/07/2011 - Added list_type and list_query to apex_application_lists view (feature #602)
Rem    jkallman    02/10/2011 - Added apex_applications.csv_encoding
Rem    hfarrell    02/14/2011 - Added LIST_TYPE_CODE to apex_application_lists to hold internal code for list type
Rem    cneumuel    02/15/2011 - Added APEX_WORKSPACE_GROUPS and APEX_WORKSPACE_GROUP_USERS
Rem    hfarrell    02/21/2011 - Added LIST_ITEM_ICON_ALT_ATTRIBUTE to apex_application_list_entries
Rem    arayner     02/23/2011 - Added triggering_button_id column and button logic to apex_application_page_da
Rem    sathikum    02/24/2011 - Modified all the conditions of APEX_ prefixed views (feature #608)
Rem    pawolf      02/28/2011 - Added new error handling columns (feature# 544)
Rem    jkallman    02/28/2011 - Added apex_workspaces.workspace_announcement
Rem    arayner     03/01/2011 - Added apex_application_page_buttons.button_static_id (feature #385)
Rem    pawolf      03/08/2011 - Added new error display location column to wwv_flow_step_processing and wwv_flow_processing (feature# 544)
Rem    arayner     03/09/2011 - Added apex_application_page_buttons.button_action (feature #385)
Rem    msewtz      03/10/2011 - Added mobile_page_templates to apex_application_temp_page, added comment (feature 586)
Rem    arayner     03/17/2011 - Converted tabs to spaces in recent apex_application_page_buttons additions (feature #385)
Rem    arayner     03/22/2011 - Added apex_application_page_buttons.button_action_code and apex_application_page_buttons.button_template_id (feature #385)
Rem    cneumuel    03/22/2011 - Changed apex_debug_messages to order execution_time by id (bug #11733252)
Rem    pawolf      03/28/2011 - Removed PLUG_DISPLAY_ERROR_MESSAGE (feature# 544)
Rem    arayner     03/30/2011 - Added values for apex_application_page_buttons.button_action, button_action_code and button_redirect_url for item based buttons (feature 385)
Rem    jkallman    03/30/2011 - Added friendly_name, workspace_service_id to apex_workspaces, session_time_zone, session_lang, session_territory to apex_workspace_sessions
Rem    jkallman    03/31/2011 - Renamed apex_workspaces.friendly_name to apex_workspaces.display_name
Rem    jkallman    03/31/2011 - Add workspace_display_name to most views
Rem    arayner     04/01/2011 - Removed REPORT value in decode for button_action in apex_application_page_buttons view (feature 385)
Rem    jkallman    04/06/2011 - Added view apex_application_trans_message and apex_translation_dyn_messages
Rem    pawolf      04/06/2011 - Added ajax_items_to_submit and escape_on_http_output to wwv_flow_page_plugs (feature 505 and 649)
Rem    pawolf      04/06/2011 - Removed wwv_flow_worksheets.page_items_to_submit, it has been replaced by wwv_flow_page_plugs.ajax_items_to_submit (feature 505)
Rem    jkallman    04/07/2011 - Rename translation views to apex_application_trans_message and apex_application_trans_dynamic
Rem    sathikum    04/08/2011 - Modified view conditions (feature #608)
Rem    pawolf      04/08/2011 - Added "Substitute Attribute Values" (substitute_attributes) to plug-ins (feature 655)
Rem    msewtz      04/08/2011 - Added render_form_items_in_table to apex_application_temp_region (feature 586)
Rem    msewtz      04/08/2011 - Added before_item and after_item to wwv_flow_field_templates (feature 586)
Rem    msewtz      04/08/2011 - Added column_field_template and use_as_row_header to apex_application_page_rpt_cols (feature 586)
Rem    jkallman    04/11/2011 - Removed view apex_application_trans_message, corrected view apex_application_trans_dynamic
Rem    jkallman    04/11/2011 - Added view apex_application_trans_repos
Rem    cneumuel    04/11/2011 - Added id to apex_debug_messages
Rem    sbkenned    04/14/2011 - Added websheet views to apex_dictionary
Rem    jkallman    04/20/2011 - Added comments to apex_application_trans_dynamic and apex_application_trans_repos
Rem    hfarrell    04/21/2011 - Fix for bug 10323250: added APEX_APPLICATION_PAGE_FLASH5_S and APEX_APPLICATION_PAGE_FLASH5 to apex_dictionary
Rem    pawolf      04/22/2011 - Added apex_appl_plugin_* views to apex_dictionary view
Rem    pmanirah    04/22/2011 - Added apex_appl_load_tables, apex_appl_load_table_lookups, apex_appl_load_table_rules
Rem    pmanirah    04/22/2011 - Added apex_appl_load_* views to apex_dictionary view
Rem    msewtz      05/09/2011 - Added default mobile template columns to view on wwv_flow_themes
Rem    pawolf      05/10/2011 - Added "is hot button" (feature 702)
Rem    pawolf      05/13/2011 - Added plug-ins for authentication schemes (feature 581)
Rem    cneumuel    05/13/2011 - Added apex_workspaces.{workspace_description,created_on,assigned_on}
Rem    cneumuel    05/13/2011 - Modified apex_application_auth.{is_current_authentication,scheme_type,scheme_type_code,attribute_01-15,created_by,created_on. removed apex_application_auth ldap columns (feature 581)
Rem    cneumuel    05/16/2011 - Exchanged WWV_FLOW_CUSTOM_AUTH_SETUPS with WWV_FLOW_AUTHENTICATIONS in apex_developer_audit_log and apex_developer_activity_Log (feature 581)
Rem    cbcho       05/15/2011 - Changed apex_application_page_ir_col to get page_id from wwv_flow_worksheets table
Rem    cneumuel    05/17/2011 - Added apex_appl_plugins.invalid_session_function, apex_application_auth.{invalid_session_type,verification_function}, removed apex_application_auth.invalid_session_url (feature 581)
Rem    cneumuel    05/26/2011 - Added apex_application_auth.plsql_code (feature 581)
Rem    jkallman    06/01/2011 - Added apex_applications.date_time_format (feature 715)
Rem    pmanirah    06/01/2011 - Added owner, data_load_definition_name to the apex_appl_load_tables (feature 545)
Rem    pmanirah    06/01/2011 - Added owner, alternative_key_column1, alternative_display_column1, alternative_key_column2, alternative_display_column2 to the apex_appl_load_table_lookups (feature 545)
Rem    pmanirah    06/02/2011 - Added where_clause and lookup_owner to the wwv_flow_load_table_lookups (feature #545)
Rem    jstraub     06/03/2011 - Added nvl(f.BUILD_STATUS,'x')  != 'RUN_AND_HIDDEN' predicate to apex_applications
Rem    jstraub     06/03/2011 - Replaced != 'RUN_ONLY' with not in ('RUN_ONLY','RUN_AND_HIDDEN')
Rem    arayner     06/08/2011 - Corrected logic in apex_application_page_buttons where union on item and region buttons was out of sync, also added button_template_id and button_template values for item buttons (bug 12630658)
Rem    cneumuel    06/17/2011 - Added apex_applications.browser_cache and apex_application_pages.browser_cache (feature #726)
Rem    cneumuel    06/20/2011 - Added apex_applications.{db_session_init_code,db_session_cleanup_code}, deprecated apex_applications.vpd (feature #616)
Rem    jkallman    07/05/2011 - Added apex_application_list_entries.translate_attributes
Rem    cneumuel    07/07/2011 - Added apex_applications.browser_frame (feature #731)
Rem    jstraub     07/12/2011 - Added apex_application_nav_bar.is_feedback_link
Rem    jstraub     08/04/2011 - Removed RUN_AND_HIDDEN filter from apex_applications
Rem    pawolf      08/05/2011 - Added new column compatibility_mode to wwv_flows (bug# 12835127)
Rem    pawolf      08/08/2011 - Synchronized browser_cache return values with values defined on the UI and added authentication_scheme_id to apex_applications
Rem    hfarrell    09/13/2011 - Added RESTful Services views: apex_rest_resource_handlers, apex_rest_resource_parameters, apex_rest_resource_modules, apex_rest_resource_templates andapex_rest_workspace_prefs
Rem    hfarrell    09/14/2011 - Removed view wwv_flow_rt$workspace_prefs
Rem    hfarrell    09/16/2011 - Updated RESTful Service views to reflect modifications to underlying tables
Rem    hfarrell    09/21/2011 - Updated RESTful Service views - modified apex_rest_resource_handlers view to replace security_constraint with require_https
Rem    sathikum    12/06/2011 - Fixed #13426740 modified APEX_ and wwv_flow_authorized views conditions
Rem    jkallman    12/09/2011 - Decode additional file types in apex_workspace_files (Bug 13481763)
Rem    pawolf      01/10/2011 - Fixed browser_cache in apex_application_pages (bug 13577507)
Rem    pmanirah    01/23/2012 - Renamed TABLE_ID to LOAD_TABLE_ID in apex_appl_load_tables view (bug 13614028)
Rem    pawolf      02/21/2012 - Changed APEX_040100 references to APEX_040200
Rem    pawolf      02/29/2012 - Added placeholder to wwv_flow_step_items (feature# 837)
Rem    pawolf      03/02/2012 - Added data model changes for several 4.2 features (feature# 778, 826, 819, 817, 816, 815, 823, 767, 825, 828, 829, 844)
Rem    hfarrell    02/05/2012 - Added data model changes for charts-related features #543 and #494
Rem    pawolf      03/06/2012 - Renamed new css_classes to region_css_classes and tag_css_classes to be consistent with existing columns (feature# 815)
Rem    pawolf      03/07/2012 - Added new table wwv_flow_theme_styles (feature# 821)
Rem    pawolf      03/08/2012 - Added data model changes for UI type feature (feature# 827)
Rem    arayner     03/14/2012 - Added apex_application_page_da.when_event_delegate_to column (feature# 836)
Rem    pawolf      03/14/2012 - Removed display_row_template_id from wwv_flow_lists (feature# 873)
Rem    sathikum    03/15/2012 - Added columns to wwv_flow_cal_templates related View (feature #812)
Rem    arayner     03/15/2012 - Changed newly added apex_application_page_da.when_event_delegate_to column to be apex_application_page_da.when_event_static_container (feature# 836)
Rem    pawolf      03/19/2012 - Changed views to only use new columns in wwv_flow_user_interfaces instead of the old columns in wwv_flow (feature# 827)
Rem    pawolf      03/28/2012 - Added 10 more custom plug-in attributes to regions (feature# 890)
Rem    cbcho       03/28/2012 - Added email_from in apex_application_page_ir (feature# 695)
Rem    hfarrell    03/29/2012 - Added build_option and build_option_id to apex_application_page_flash5_s (feature #494)
Rem    cbcho       03/29/2012 - Added email_from in apex_applications (feature# 695)
Rem    pawolf      03/30/2012 - Added new table wwv_flow_plugin_settings (feature# 895)
Rem    vuvarov     04/03/2012 - Added wwv_flow_step_branches.branch_name to relevant views (feature #872)
Rem    pawolf      04/06/2012 - Added read only attributes to wwv_flow_steps and wwv_flow_page_plugs (feature# 570)
Rem    jkallman    04/09/2012 - Added apex_workspaces.rm_consumer_group (feature# 757)
Rem    cneumuel    04/10/2012 - Added apex_applications.authorize_public_pages_yn (bug #13940433)
Rem    pawolf      04/10/2012 - Added new read only conditions (feature# 570)
Rem    sathikum    04/13/2012 - Added new columns to wwv_flow_cal_templates (feature #811)
Rem    cbcho       04/13/2012 - Added language, email_from in wwv_flow_worksheet_notify (feature #881)
Rem    cneumuel    04/16/2012 - Added first_name, last_name, description, account_locked to apex_workspace_apex_users (bug #13934444)
Rem    cneumuel    04/17/2012 - Prefix sys objects with schema (bug #12338050)
Rem    arayner     04/20/2012 - Added wait_for_result to apex_application_page_da_acts (feature #599)
Rem    arayner     04/23/2012 - Updated wait_for_result in apex_application_page_da_acts to show nulls (feature #599)
Rem    arayner     04/24/2012 - Changed wait_for_result handling in apex_application_page_da_acts to use case instead of decode (feature #599)
Rem    pawolf      04/25/2012 - Added column_data_types to wwv_flow_plugin_attributes (feature #918)
Rem    cbcho       04/25/2012 - Added icon_view_use_custom, icon_view_custom_link to wwv_flow_worksheets (feature #915)
Rem    pawolf      04/30/2012 - Added series_ajax_items_to_submit to wwv_flow_flash_chart5_series (feature #741)
Rem    vuvarov     05/01/2012 - Added Text Messages, Web Services, Plug-ins to apex_component_signatures view (bug 13836432)
Rem    cneumuel    05/02/2012 - Added apex_applications.deep_linking, apex_application_pages.deep_linking (feature #878)
Rem    pawolf      05/09/2012 - Renamed #JAVASCRIPT_COD# placeholder to #PAGE_JAVASCRIPT#
Rem    pawolf      05/11/2012 - Added wwv_flow_page_plugs.plug_item_display_point (feature #278)
Rem    pawolf      05/11/2012 - Renamed display point BEFORE_BOX_BODY, BEFORE_SHOW_ITEMS and AFTER_SHOW_ITEMS to BODY_1-3 (feature #278)
Rem    pawolf      05/14/2012 - Added grid templates (feature #936)
Rem    arayner     05/15/2012 - Added include_legacy_javascript to wwv_flows (feature #927)
Rem    cbcho       05/15/2012 - Changed apex_application_page_ir_rpt to remove obsolete private notification and websheet data section report type
Rem    pawolf      05/21/2012 - More changes for grid templates (feature #936)
Rem    pawolf      05/21/2012 - Added wwv_flow_theme_display_points (feature #936)
Rem    pawolf      05/21/2012 - More changes for grid templates (feature #936)
Rem    pmanirah    05/24/2012 - Added the two new columns of wwv_flow_load_tables on its view (feature #833)
Rem    pawolf      05/24/2012 - Moved grid template attributes into wwv_flow_templates and removed wwv_flow_grid_templates (feature #936)
Rem    pmanirah    05/24/2012 - Added new column column_names_lov_id and removed is_lov_active. column_names_lov of wwv_flow_load_tables (feature #833)
Rem    arayner     05/28/2012 - Added wwv_flow_page_da_actions.affected_button_id (feature #678) and fixed component signature in APEX_APPLICATION_PAGE_DA_ACTS (bug #13965748)
Rem    cneumuel    05/31/2012 - Added apex_application_items.scope (feature #897)
Rem    pmanirah    05/31/2012 - Added two columns on wwv_flow_load_tables is_use_version_col_on and version_column_name (feature #903)
Rem    cbcho       06/04/2012 - Added internal_uid in apex_application_page_ir (feature #268)
Rem    pmanirah    06/08/2012 - Removed the use of column is_use_version_col_on from wwv_flow_load_tables (feature 903)
Rem    msewtz      06/12/2012 - Added default header and footer template to apex_application_themes
Rem    jkallman    06/12/2012 - Correct syntax errors in creation of apex_application_themes
Rem    pawolf      06/15/2012 - Added has_edit_links to wwv_flow_templates
Rem    pawolf      06/15/2012 - Added table wwv_flow_plug_tmpl_disp_points (feature #936)
Rem    pawolf      06/20/2012 - Added global_page_id to wwv_flow_user_interfaces (feature #987)
Rem    pawolf      06/21/2012 - Added global page support (feature #987)
Rem    cneumuel    06/26/2012 - Fixed typo in wwv_flow_ui_types.autodetect_js_function_body (feature #791)
Rem    pawolf      06/26/2012 - Added table wwv_flow_page_tmpl_disp_points (feature #936)
Rem    cbcho       07/03/2012 - Added column_html_expression to apex_application_page_ir_col (feature #894)
Rem    hfarrell    07/09/2012 - Added handler_id to apex_rest_resource_handlers (EA feedback #EA1-179)
Rem    cneumuel    07/13/2012 - Added apex_applications.ui_detection_css_urls (feature #791)
Rem                           - Added apex_applications.html_escaping_mode (bug #14047702)
Rem    jkallman    07/13/2012 - Replace all occurrences of htf.escape_sc with wwv_flow_escape.html (Bug 14047702)
Rem    hfarrell    07/17/2012 - Added allow_restful_services_yn to apex_workspaces view for RESTful Services (feature #863)
Rem    vuvarov     07/17/2012 - Added nls_sort and nls_comp columns to apex_applications (feature #978)
Rem    pawolf      08/23/2012 - For compatibility with SQL Developer, added theme_number and home_link to apex_applications and template to apex_application_lists (bug# 14526535)
Rem    pawolf      08/28/2012 - For compatibility with existing applications added logic to get data for theme_number, home_link and login_url to apex_applications (bug# 14545162)
Rem    pawolf      08/28/2012 - Restored missing columns in views apex_applications, apex_application_page_regions and apex_appl_plugins (bug# 14545162)
Rem    cbcho       10/17/2012 - Changed apex_application_page_ir_rpt to include report_type value conditionally for report_view_mode value (bug 14768361)
Rem    sathikum    11/22/2012 - Added apex_application_calendar (bug 14833918)
Rem    sathikum    11/26/2012 - Renamed view apex_application_calendar to apex_appl_page_calendars
Rem    pawolf      11/30/2012 - Commented out apex_appl_page_calendars
Rem    hfarrell    12/11/2012 - Updated apex_workspaces to include path_prefix (bug #15984817)
Rem    jkallman    12/17/2012 - Change APEX_040200 references to APEX_050000
Rem    sathikum    01/21/2013 - Added apex_appl_page_calendars (bug 14833918)
Rem    pawolf      04/11/2013 - Added new table wwv_flow_theme_files and new columns file_prefix and files_version to wwv_flow_themes (feature #1162)
Rem    pawolf      04/16/2013 - Added files_version to wwv_flow_companies and wwv_flow_files (feature #1165)
Rem    pawolf      04/16/2013 - Added file_prefix to wwv_flow_files (feature #1165)
Rem    pawolf      04/18/2013 - Added wwv_flow_company_static_files and wwv_flow_static_files (feature #1169)
Rem    pawolf      04/23/2013 - Changed apex_workspace_files to not include CSS, image and static files anymore, they are now returned by apex_application_static_files and apex_workspace_static_files (feature #1169)
Rem    hfarrell    05/22/2013 - Added new columns page_mode, dialog_attributes, dialog_width, dialog_maxwidth, dialog_title from wwv_flow_steps to apex_application_pages view (feature #587)
Rem    hfarrell    05/23/2013 - Added new column javascript_dialog_code to apex_application_temp_page (feature #587)
Rem    jkallman    05/22/2013 - Added apex_application_trans_repos.translatable (Bug 16849144)
Rem    jkallman    05/29/2013 - Added apex_application_trans_repos.internal_attribute_name (Bug 16849144)
Rem    cneumuel    05/31/2013 - Renamed process point AFTER_AUTHENTICATION to ON_NEW_INSTANCE, added app-level process point AFTER_LOGIN (feature #861)
Rem    hfarrell    06/07/2013 - Added dialog_width and dialog_maxwidth to apex_application_temp_page (feature #587)
Rem    hfarrell    06/07/2013 - Renamed dialog_maxwidth to dialog_max_width in apex_application_pages and apex_application_temp_page, javascript_dialog_code to dialog_js_init_code in wwv_flow_templates
Rem    hfarrell    06/07/2013 - Renamed NONMODAL to NON_MODAL in apex_application_pages
Rem    cneumuel    06/14/2013 - In apex_workspace_sessions: added session_idle_timeout_on, session_life_timeout_on, session_max_idle_sec (feature #1149)
Rem    hfarrell    06/19/2013 - In apex_application_pages and apex_application_temp_page: added dialog_height (feature #587)
Rem    cbcho       07/01/2013 - Added additional group by and sort columns in apex_application_page_ir_grpby (feature #548)
Rem    jkallman    07/01/2013 - Added apex_applications.feedback
Rem    cneumuel    07/03/2013 - In apex_application_auth: added ras_mode, ras_dynamic_roles, ras_namespaces (feature #1152)
Rem    cneumuel    07/04/2013 - Added apex_workspace_session_groups, apex_workspace_group_groups (feature #1233)
Rem    cneumuel    07/10/2013 - Changed comments for group views
Rem    hfarrell    07/31/2013 - Added extra_y_axis_min, extra_y_axis, max to apex_application_page_flash5 (feature #742)
Rem    msewtz      07/31/2013 - Added navigation list related columns to apex_application_temp_list, apex_application_themes, apex_appl_user_interfaces, apex_application_pages (feature 1236)
Rem    msewtz      08/02/2013 - Added navigation_type to apex_application_themes to identify whether tabs or navigation lists are used by theme (feature 1236)
Rem    msewtz      08/05/2013 - Removed comment on apex_application_temp_list.always_include_files (feature 1236)
Rem    pawolf      08/20/2013 - Changed constraint of wwv_flow_step_items.begin_on_new_line and begin_on_new_field to Y and N
Rem    msewtz      08/20/2013 - Added navigation_list_id to user interfaces, pages and theme views in addition to navigation list name (feature 1236)
Rem    pawolf      08/21/2013 - Added is_common and supported_ui_types to wwv_flow_plugin_attributes (features# 1270 and 1271)
Rem    hfarrell    09/17/2013 - Added dialog_css_classes to apex_application_pages, dialog_js_close_code and dialog_css_classes to apex_application_temp_page (feature #1201 and #1204)
Rem    cneumuel    10/08/2013 - Removed apex_application_get_pg_tname and replaced it with query in apex_application_page_db_items
Rem                           - In apex_application_page_proc: process type migration changes
Rem    cbcho       10/11/2013 - Added show_pivot to apex_application_page_ir, allow_pivot to apex_application_page_ir_col (feature #536)
Rem    cbcho       10/23/2013 - Added views for pivot (feature #536)
Rem    hfarrell    10/24/2013 - Added dialog_js_cancel_code to apex_application_temp_page (feature #1201 and #1204)
Rem    cbcho       10/25/2013 - Added new pivot views in apex_dictionary (feature #536)
Rem    pawolf      10/30/2013 - Added BODY to wwv_flow_page_plugs.plug_display_point (feature #1300)
Rem    cbcho       11/06/2013 - Removed sort attributes from apex_application_page_ir (feature #1303)
Rem    cneumuel    11/18/2013 - In apex_application_page_regions: migration of list/breadcrumb to native plugins (feature #1312)
Rem    cneumuel    11/20/2013 - In apex_applications, apex_application_translations, apex_developer_activity_log, apex_application_trans_dynamic, apex_application_trans_repos: change translation subquery to not shadow normal apps (bug #17825560)
Rem    cneumuel    11/22/2013 - In apex_application_page_regions: REGION_DISPLAY_SELECTOR, URL, HELP_TEXT migrated to native plugins (feature #1312)
Rem    cbcho       11/26/2013 - Changed apex_application_page_ir get sql_query from region source
Rem    cneumuel    12/05/2013 - classic reports and tabular forms migration to native plugins (feature #1312)
Rem    pmanirah    12/05/2013 - Added a new column skip_validation to wwv_flow_load_tables (feature #1327)
Rem    cneumuel    12/06/2013 - interactive reports migration to native plugins (feature #1312)
Rem    cneumuel    12/16/2013 - html and plsql region migration to native plugins (feature #1312)
Rem    cneumuel    12/20/2013 - Region type migration to native plugins: charts, calendars, trees (feature #1312)
Rem    cneumuel    01/10/2014 - In apex_application_page_trees: JSTREE has been fully migrated, do not use obsolete wwv_flow_tree_regions anymore (feature #1312)
Rem    cneumuel    01/15/2014 - In apex_application_page_buttons: html and image based page buttons are now template based (feature #1281)
Rem    msewtz      01/24/2014 - Added wwv_flow_companies.allow_packaged_app_ins_yn to apex_workspaces view (feature 1348)
Rem    cneumuel    02/06/2014 - In apex_workspace_sessions: added remote_addr
Rem    cneumuel    02/10/2014 - Changed NATIVE_HTML region to NATIVE_STATIC
Rem    msewtz      02/11/2014 - Added before and after element attributes and help link attribute to wwv_flow_field_templates (feature 1377)
Rem    msewtz      02/17/2014 - Added region_sub_css_classes to view on wwv_flow_page_plugs
Rem    msewtz      02/17/2014 - Added error_template to view wwv_flow_field_templates
Rem    pawolf      02/26/2014 - Added wwv_flow_plugin_attr_values.is_quick_pick
Rem                           - Added wwv_flow_plugin_attr_values.help_text
Rem                           - Added wwv_flow_plugin_attributes.examples
Rem    pawolf      02/28/2014 - Added wwv_flow_messages$.is_js_message
Rem    cneumuel    03/04/2014 - In apex_application_page_regions: added source_type_plugin_name, mapped source_type_code back to 4.x values (feature #1312)
Rem                           - In apex_application_processes: mapped process_type_code back to 4.x values. added process_type_plugin_name (feature #1281)
Rem                           - In apex_application_page_proc: mapped process_type_code and process_source back to 4.x values. added process_type_plugin_name (feature #1281)
Rem                           - In apex_applications: qualify max_session_length_sec and max_session_idle_sec with table alias (feature #1323)
Rem    msewtz      03/12/2014 - added icon_css_classes to apex_application_page_buttons
Rem    msewtz      03/13/2014 - Added apex_appl_template_options (feature 1394)
Rem    msewtz      03/14/2014 - Added display_name to apex_appl_template_options (feature 1394)
Rem    msewtz      03/17/2014 - Added apex_appl_template_options to apex_dictionary (feature 1394)
Rem    msewtz      03/17/2014 - Updated apex_appl_template_options to include reference_id (feature 1394)
Rem    cneumuel    03/17/2014 - In apex_applications: added runtime_api_usage (feature #1277)
Rem                           - In apex_application_page_proc: keep old name AFTER_AUTHENTICATION for process point ON_NEW_INSTANCE
Rem    cneumuel    03/18/2014 - In apex_applications: added rejoin_existing_sessions, http_response_headers, bookmark_checksum_function
Rem                           - In apex_application_pages: added rejoin_existing_sessions
Rem    pawolf      02/17/2013 - Added support for region columns (feature #1393)
Rem    msewtz      03/18/2014 - Added template options to views on pages, regions, items and buttons (feature 1394)
Rem    cneumuel    03/19/2014 - In apex_workspace_apex_users: added password_hash_function
Rem    msewtz      03/20/2014 - Added default template options to views on page-, region-, report-, list-, rbeadcrumb-, item- and button-templates (feature 1394)
Rem    msewtz      03/24/2014 - Added nav_list_template_options to views on wwv_flow_steps and wwv_flow_user_interfaces (feature #1394)
Rem    hfarrell    03/24/2014 - Added new column dialog_chained from wwv_flow_steps to apex_application_pages view (feature #587)
Rem    msewtz      03/27/2014 - Added template options for pages and nav lists to view on themes (feature 1394)
Rem    msewtz      04/01/2014 - Added preset_template_options to views on page-, region-, report-, list-, breadcrumb-, item- and button tempates (feature 1394)
Rem    msewtz      04/01/2014 - Added CSS icon attributes to view on  themes (feature 1394)
Rem    msewtz      04/01/2014 - Added preset_template_options to views on page-, region-, report-, list-, breadcrumb-, item- and button tempates (feature 1394)
Rem    msewtz      04/01/2014 - Added CSS icon attributes to themes (feature 1394)
Rem    cbcho       04/01/2014 - Changed report_link_example in apex_application_page_ir_rpt with new syntax and added region_id in the view (feature 1402)
Rem    cneumuel    04/04/2014 - In apex_application_page_buttons, apex_application_templates, apex_application_pages, apex_application_page_items, apex_application_page_regions: item based buttons migrated to page buttons (feature #1314)
Rem    hfarrell    04/15/2014 - Removed Flash Chart 3-related views: apex_application_page_flash_ch and apex_application_page_flash_s; removed reference to Flash 3 tables from views apex_component_signatures and apex_dictionary
Rem    cneumuel    04/15/2014 - page and region caching allows to cache by current session (feature #1401)
Rem    hfarrell    04/17/2014 - Removed references to legacy Flash 3 chart 'NATIVE_FLASH_CHART' from apex_application_page_regions (feature #1345)
rem    pmanirah    04/21/2014 - Added glv_new_column to apex_appl_temp_page_dp and apex_appl_temp_plug_dp
Rem    msewtz      04/23/2014 - Added view on template option groups (feature 1394)
Rem    cneumuel    04/24/2014 - In apex_application_page_regions: added cache_depends_on_items (feature #1401)
Rem    msewtz      05/05/2014 - Renamed apex_appl_template_opt_grp to apex_appl_template_opt_groups (feature 1394)
Rem    cneumuel    05/21/2014 - In apex_workspace_files: added temp_file_session_id for session where temp file was uploaded (bug #15844363)
Rem    pawolf      05/23/2014 - Deprecated apex_application_temp_page.has_edit_links
Rem                           - Added apex_application_temp_page.grid_always_emit (feature 1433)
Rem    cneumuel    05/26/2014 - In apex_application_page_buttons: added pre_element_text, post_element_text, request_source_type because they are required for deprecated attributes check (feature #1432)
Rem    pmanirah    06/02/2014 - Renamed glv_new_column to glv_new_row (feature #1210)
Rem    jkallman    06/12/2014 - Added email_maximum to apex_workspaces (feature #1037)
Rem    cbcho       06/17/2014 - Added region_name in APEX_APPLICATION_PAGE_IR_COL and added IR column authorization_scheme in APEX_APPLICATION_ALL_AUTH
Rem    asitters    06/17/2014 - Added team_dev_fs_limit and allow_team_dev_files_yn in the create view statement for the apex_workspaces view (for feature 1415)
Rem    asitters    06/17/2014 - Added team_dev_fs_limit and allow_team_dev_files_yn to group by clause of the create view statement for the apex_workspaces view (for feature 1415)
Rem    pawolf      07/04/2014 - Added JAVASCRIPT_EXPRESSION to dynamic action and dynamic action event (feature #1450)
Rem    pawolf      07/08/2014 - Added WHEN_SELECTION_TYPE_CODE and AFFECTED_ELEMENTS_TYPE_CODE to support Advisor deprecation warning (feature #1448)
Rem    msewtz      07/10/2014 - Added theme roller columns to view on wwv_flow_theme_styles
Rem    msewtz      07/10/2014 - Removed template option defaults from view on wwv_flow_themes
Rem    msewtz      07/10/2014 - Added icon class colums to view on wwv_flow_themes
Rem    cneumuel    07/11/2014 - In apex_application_themes: removed icon_css_file_urls, icon_css_classes, icon_css_classes_html, default_page_template_opt and default_nav_list_template_opt, since the columns were dropped
Rem    hfarrell    07/14/2014 - In apex_application_temp_page: added dialog_browser_frame
Rem    pawolf      07/22/2014 - Added wwv_flow_plugin_attributes.show_in_wizard
Rem    pmanirah    07/23/2014 - Added default_dialog_btr_template to apex_application_themes view
Rem    pawolf      07/25/2014 - Moved content_delivery_network, javascript_file_urls and include_legacy_javascript from wwv_flows into wwv_flow_user_interfaces (feature #1464)
Rem    cneumuel    08/04/2014 - In apex_workspace_sql_scripts, apex_application_page_map, apex_release, apex_ui_defaults_tables, apex_ui_defaults_groups, apex_ui_defaults_columns, apex_ui_defaults_lov_data,
Rem                           - apex_team_feedback, apex_team_feedback_followup, apex_debug_messages: use wwv_flow_current_sgid (bug #19306482)
Rem    cneumuel    08/05/2014 - Removed grant statements (bug #19306482)
Rem    jstraub     08/05/2014 - Removed IDs of auth schemes in component_signature of APEX_APPLICATION_PAGES, apex_application_page_branches, apex_application_page_comp,
Rem                             apex_application_page_proc, apex_application_page_regions, apex_application_page_items, apex_application_page_buttons, apex_application_processes, apex_application_computations,
Rem                             apex_application_nav_bar, apex_application_tabs, apex_application_parent_tabs, apex_application_list_entries, apex_application_bc_entries,
Rem                             apex_applications, apex_application_page_ir, apex_application_page_ir_col, apex_application_page_rpt_cols (bug 18345336)
Rem    davgale     08/06/2014 - Added navigation list position fields to apex_application_themes, apex_application_pages, and apex_appl_user_interfaces (feature 1472)
Rem    pawolf      08/13/2014 - Added APEX_APPL_CONCATENATED_FILES (feature #1340)
Rem    pawolf      08/14/2014 - Added include_jquery_migrate to wwv_flow_user_interfaces (feature #1475)
Rem    pawolf      09/01/2014 - For concistency with other views added page_template_id to apex_application_temp_page (needed by application search)
Rem    pawolf      10/01/2014 - Added javascript_file_urls and css_file_urls to wwv_flow_themes (feature #1484)
Rem    hfarrell    10/14/2014 - Added navigation bar-related columns to apex_appl_user_interfaces: nav_bar_type, nav_bar_list_id, nav_bar_list_template_id, nav_bar_template_options (feature #1536)
Rem    pawolf      10/17/2014 - Added apex_appl_developer_comments (bug# 16731390)
Rem    hfarrell    10/20/2014 - In apex_application_themes: added default_nav_bar_list_template (feature #1536)
Rem    hfarrell    10/21/2014 - Added nav_bar_type to apex_application_themes; nav_bar_list, nav_bar_list_template to apex_appl_user_interfaces (feature #1536)
Rem    arayner     10/28/2014 - Obsolete wwv_flow_worksheet columns button_template, actions_menu_icon and finder_icon (feature #577)
Rem    hfarrell    11/04/2014 - In apex_application_temp_list: added new a01_label to a20_label columns to wwv_flow_list_templates (feature #1567)
Rem    hfarrell    11/04/2014 - In apex_application_pages and apex_application_temp_page: updated Modal to Modal Dialog, Non-Modal to Non-Modal Dialog, to reflect Mikes recent name changes in Page Designer
Rem    pawolf      11/11/2014 - Added wwv_flow_themes.custom_icon_prefix_class (feature #1574)
Rem    hfarrell    11/12/2014 - Applied component name change, from navigation list to navigation menu list
Rem    pawolf      11/12/2014 - Added wwv_flow_plugin_attributes.reference_scope (feature #1596)
Rem    cneumuel    11/25/2014 - In apex_application_all_auth: added APEX_APPLICATION_PAGE_DA, APEX_APPLICATION_PAGE_FLASH5_S (bug #17155574)
Rem    pawolf      11/27/2014 - Added wwv_flow_step_items.grid_label_column_span and wwv_flow_templates.grid_default_label_col_span (feature #1615)
Rem                           - Added static_id and css_classes to wwv_flow_worksheet_columns (feature #1457)
Rem    arayner     11/28/2014 - Added fixed_header to apex_application_page_ir and apex_application_page_regions (feature #1534)
Rem    cneumuel    12/02/2014 - In apex_workspace_activity_log: added page_view_type, request_value, debug_page_view_id (feature #1599)
Rem    arayner     12/03/2014 - Added fixed_header_max_height to wwv_flow_worksheet and wwv_flow_page_plugs (feature #1534)
Rem    pawolf      12/04/2014 - Added grid_column_css_classes to wwv_flow_page_plugs, wwv_flow_step_items and wwv_flow_step_buttons (feature #1466)
Rem    hfarrell    12/10/2014 - In apex_application_themes: added default_dialogr_template and default_dialogbtnr_template
Rem    hfarrell    12/11/2014 - In apex_application_themes: removed default_dialog_btr_template (verified by pmanirah that it is not required)
Rem    cneumuel    12/18/2014 - In apex_workspaces: added missing columns file_storage_max, maximum_session_life_seconds, maximum_session_idle_seconds, max_workspace_requests, max_session_requests, max_session_kill_timeout
Rem    pawolf      12/19/2014 - Added virtual* columns to apex_appl_template_options
Rem    cneumuel    01/13/2015 - In apex_application_page_buttons, apex_application_page_trees, apex_application_lists, apex_application_page_ir: replace null columns with cast(null as varchar2(10)) (bug #20302401)
Rem    pawolf      01/19/2015 - Added apex_application_locked_pages (bug #16228756)
Rem    pawolf      01/23/2015 - Added wwv_flow_authorized_and_4411 and changed all apex_appl_plugin* views to make use of it (bug #20408983)
Rem    cneumuel    02/09/2015 - In apex_workspace_apex_users dropped password_hash_function (bug #20462973)
Rem    cneumuel    03/09/2015 - In apex_workspace_group_users,apex_workspace_group_groups,apex_workspace_groups,apex_workspace_ui_types: fixed duplicate rows (bug #20671788)
Rem    cneumuel    03/11/2015 - In apex_application_page_trees: use tree id from attribute_06 (bug #20636599)
Rem    cbcho       03/11/2015 - Replaced not in ('RUN_ONLY','RUN_AND_HIDDEN') with != 'RUN_AND_HIDDEN' (bug #19931623)
Rem    msewtz      07/07/2015 - Change APEX_050000 references to APEX_050100
Rem    hfarrell    07/14/2015 - Changed references in display values and help text: AJAX to Ajax, On-Demand to Ajax Callback (bug #20200008)
Rem    msewtz      08/20/2015 - Added direction_right_to_left to wwv_flows and wwv_flow_language_map (feature 1046)
Rem    hfarrell    09/01/2015 - Added views on JET Chart tables: apex_application_page_charts, apex_application_page_chart_s, apex_application_page_chart_a (feature #1837)
Rem                             Added NATIVE_JET_CHART to apex_application_page_regions, and updated apex_dictionary
Rem    hfarrell    09/22/2015 - Added REST-related views to APEX_DICTIONARY (bug #21882756)
Rem    hfarrell    09/24/2015 - Added value_min to apex_application_page_charts
Rem    hfarrell    09/24/2015 - Added dial_background to apex_application_page_charts
Rem    pawolf      10/13/2015 - Added item type plug-in enhancements for Interactive Grid Columns (feature #1876)
Rem    hfarrell    11/11/2015 - Updated apex_application_page_charts to add legend_title, and modify some decodes to use on/off instead of y/n
Rem    hfarrell    11/25/2015 - Updated apex_application_page_charts to add range_chart
Rem    hfarrell    12/04/2015 - Added pie_inner_radius to apex_application_page_charts
Rem    hfarrell    12/11/2015 - Added pie_slice_explode to apex_application_page_chart_s
Rem    hfarrell    12/21/2015 - Updated apex_application_page_charts and apex_application_page_chart_s
Rem    cneumuel    02/04/2016 - In apex_workspace_sessions: added session_debug_level, session_trace_mode (feature #1756)
Rem    cbcho       02/04/2016 - Added interactive grid views (feature #1215)
Rem    hfarrell    02/05/2016 - Removed newline from apex_appl_page_ig_columns (Hudson build issue)
Rem    hfarrell    02/08/2016 - Added min_value to apex_application_page_chart_s
Rem    hfarrell    02/11/2016 - Updated apex_application_page_charts: removed value_prefix, value_postfix, added value_text_type
Rem                             Updated apex_application_page_chart_a: removed prefix,postfix
Rem    hfarrell    02/12/2016 - Added format_scaling to wwv_flow_jet_chart_axes - to support more granular formatting of axis labels
Rem    cbcho       02/12/2016 - Added code columns in interactive grid views
Rem    pawolf      02/22/2016 - Added RELOAD_ON_SUBMIT to wwv_flow_steps
Rem    pawolf      03/22/2016 - Added wwv_flow_plugin_attributes.depending_on_has_to_exist (feature #1974)
Rem    cbcho       03/28/2016 - Added apex_application_page_ir_col.column_identifier (bug #23010490)
Rem    pawolf      04/04/2016 - In wwv_flow_ig_report_aggregates: renamed label to tooltip
Rem    hfarrell    04/06/2016 - In apex_application_page_chart_s: updated column descriptions for the columns items_short_desc_column_name, group_name_column_name, group_short_desc_column_name
Rem    pawolf      04/08/2016 - In wwv_flow_ig_reports: added current_view, in wwv_flow_ig_report_views: removed is_current
Rem    pawolf      04/11/2016 - In wwv_flow_steps: added warn_on_unsaved_changes (feature #1652)
Rem    pawolf      04/13/2016 - In wwv_flow_step_items and wwv_flow_step_buttons: added warn_on_unsaved_changes (feature #1652)
Rem    cczarski    04/14/2016 - In apex_workspace_log_archive: added public_page_events and workspace_login_events
Rem    hfarrell    04/18/2016 - In apex_inst_restadm_clients and apex_inst_restadm_client_roles - prefix references to xmltype (breaking Hudson build)
Rem    cneumuel    04/18/2016 - Use wwv_flow_security.has_apex_admin_read_role_yn instead of has_apex_administrator_role_yn (feature #1993)
Rem    hfarrell    04/20/2016 - In apex_application_page_charts: added zoom_direction
Rem    cneumuel    04/20/2016 - Added apex_instance_parameters. Added apex_debug_messages.call_stack.
Rem    hfarrell    04/29/2016 - Updated apex_application_page_charts: removed join on axes table, resulting in multiple rows returned
Rem    cczarski    05/02/2016 - added item_icon_css_classes for wwv_flow_step_items and wwv_flow_region_columns
Rem    cczarski    05/02/2016 - added inline_help_text for wwv_flow_step_items and wwv_flow_field_templates
Rem    cczarski    05/11/2016 - added item_pre_text and item_post_text to apex_application_temp_label (feature #1998)
Rem    hfarrell    05/20/2016 - Updated apex_application_page_charts: added wwv_flow_jet_charts.no_data_found_message
Rem    arayner     06/09/2016 - Added wwv_flow_page_da_events.condition_based_on, set alias for condition_page_item to when_condition_item (feature #825)
Rem    cczarski    06/09/2016 - Add PLUGIN_INIT_JAVASCRIPT_CODE column to WWV_FLOW_STEP_ITEM, WWV_FLOW_PAGE_PLUG and WWV_FLOW_PAGE_DA_ACTION (Feature #2018)
Rem    cczarski    06/09/2016 - Add table wwv_flow_plugin_std_attributes to store meta data for plug-in standard attributes  (Feature #2018)
Rem    arayner     06/13/2016 - Removed condition_based_on, renamed condition_page_item to be condition_element, added condition_element_type to wwv_flow_page_da_events (feature #825)
Rem    hfarrell    06/14/2016 - Renamed references APEX_APPL_PLUGIN_STD_ATTRIBUTES to APEX_APPL_PLUGIN_STD_ATTRS (resolve install issue)
Rem    cczarski    06/15/2016 - Changes to wwv_flow_plugin_std_attribute as per discussion with Patrick
Rem    hfarrell    06/21/2016 - Updates to apex_workspace_apex_users (bug #187 in team dev)
Rem    cneumuel    06/21/2016 - In apex_application_page_map, apex_ui_defaults_tables, apex_ui_defaults_groups, apex_ui_defaults_columns, apex_ui_defaults_lov_data: fix security checks (bug #23625653)
Rem    cczarski    06/23/2016 - In apex_workspace_log_archive: Add APPLICATION_NAME and WORKSPACE_NAME columns
Rem    hfarrell    06/23/2016 - In apex_application_page_charts: added initial_zooming
Rem    pawolf      06/24/2016 - In wwv_flow_patches: added on_upgrade_keep_status (feature #2026)
Rem    cneumuel    06/29/2016 - In apex_workspace_clicks: current_user instead of user (bug #23625653)
Rem    cczarski    07/06/2016 - In apex_applications: added favicons column (feature #1702)
Rem    cczarski    07/06/2016 - In apex_applications: added app_builder_icon_name column (feature #1978)
Rem    cczarski    07/07/2016 - Add support for end-user customization of Theme Styles (feature #1992)
Rem    cczarski    07/19/2016 - add build options to classic report, ir and ig columns (feature #1955)
Rem    hfarrell    07/19/2016 - Updated apex_appl_page_ig_rpt_views and apex_appl_page_ig_rpt_cht_cols with IG chart-related changes
Rem    cbcho       07/19/2016 - Changed apex_appl_page_ig_rpt_filters, apex_appl_page_ig_rpt_computes not to equijoin wwv_flow_ig_report_views
Rem    hfarrell    07/20/2016 - Updated apex_appl_page_ig_rpt_views: revised axes columns; apex_appl_page_ig_rpt_cht_cols: reinstated sort_nulls
Rem    msewtz      07/21/2016 - Added internal_name column to theme and template views (feature 2040)
Rem    pawolf      08/02/2016 - In wwv_flow_interactive_grids: added oracle_text_index_column
Rem    cczarski    08/05/2016 - In wwv_flow_row_templates and _plug_templates: Added columns for CSS Files, JS Files and Onload JS (Feature #2042)
Rem    hfarrell    08/11/2016 - In apex_application_page_da: resolved incorrect column references in setting of authorization_scheme and component_signature (EA1-231 feedback)
Rem    hfarrell    08/23/2016 - Replaced references to Application Builder with App Builder in view comments
Rem    pawolf      09/08/2016 - In wwv_flow_plugins: renamed sql_function to meta_data_function
Rem    cneumuel    09/19/2016 - In apex_workspace_files: do not hide files for RUN_AND_HIDDEN apps if current user has admin read role (bug #24386249)
Rem    cneumuel    10/20/2016 - In apex_inst_restadm_clients,apex_inst_restadm_client_roles: added current_user check, because views have to be granted to public (bug #24834200)
Rem    cneumuel    11/14/2016 - In apex_workspace_activity_log: remove restriction to last 14 days
Rem    hfarrell    01/05/2017 - Changed APEX_050100 references to APEX_050200
Rem    hfarrell    01/23/2017 - Updated REST view apex_rest_resource_modules to restrict by first_schema_provisioned (bug #25217197)
Rem    msewtz      02/24/2016 - Added static_id wwv_flow_region_report_column (bug #20756299)
Rem    cneumuel    03/02/2017 - In apex_release: use APEX_PATCH_STATUS in patch_applied column
Rem    hfarrell    03/20/2017 - In apex_application_page_charts: added pyramid chart type
Rem    cneumuel    05/05/2017 - Unify workspace isolation checks (bug #25951335)
Rem    cczarski    05/16/2017 - added dictionary views for remote SQL data access and REST consumption (features #2109, #2092)
Rem    cczarski    06/01/2017 - smaller data model adjustments for REST consumption (feature #2092)
Rem    cczarski    07/06/2017 - added restricted_characters and restricted_characters_code to apex_application_page_items
Rem    cczarski    07/18/2017 - added apex_appl_data_profile_cols.is_hidden and apex_appl_web_src_operations.legacy_ords_fixed_page_size (feature #2092)
Rem    hfarrell    07/19/2017 - In apex_application_page_charts: added connect_nulls
Rem    cneumuel    07/26/2017 - added apex_workspace_sessions.session_authentication_{id,name} (feature #561)
Rem                           - added apex_application_auth.switch_in_session (feature #1975)
Rem    pawolf      07/28/2017 - Added wwv_flow_page_plugs.optimizer_hint (feature #1107)
Rem    hfarrell    08/10/2017 - In apex_application_page_chart_s: added q2_color, q3_color (5.2 feature #1245)
Rem    pawolf      08/16/2017 - In apex_application_page_regions and apex_application_page_rpt: removed FNC_REPORT
Rem    pawolf      08/25/2017 - Added wwv_flow_page_plugs.include_rowid_column (feature #2109)
Rem    cczarski    09/04/2017 - Added columns for "fetch all rows" support in wwv_flow_web_src_modules (feature #2092)
Rem                             Added sql_expression column to wwv_flow_data_profile_cols
Rem    cczarski    09/14/2017 - Added data profiles to apex_developer_activity_log
Rem    cczarski    10/05/2017 - in apex_appl_web_src_comp_params: changed "STATIC_TEXT_WITH_SUBSTITUTIONS" to "STATIC"
Rem    cczarski    10/06/2017 - in apex_appl_remote_sql: Added ords_time_zone column.
Rem    cneumuel    10/19/2017 - In apex_workspace_activity_log: think_time always returns null, the computation was too expensive (bug #26869045)
Rem    cczarski    11/14/2017 - change wwv_flow_credentials to store credentials at workspace level (feature #2109, #2092)
Rem    cczarski    11/15/2017 - change wwv_flow_remote_servers to store remote servers at workspace level (feature #2109, #2092)
Rem    hfarrell    11/15/2017 - In apex_application_page_chart_s: added boxPlot to decode for series_type (5.2 feature #1245) and Remote SQL columns (feature #2109)
Rem                             Removed duplicate column comment on apex_application_page_regions.order_by_clause
Rem    hfarrell    11/16/2017 - Resolved typo in view apex_application_page_chart_s
Rem    hfarrell    11/17/2017 - In apex_application_page_chart: added chart_sort_order
Rem    hfarrell    11/22/2017 - Added support for gantt charts in apex_application_page_chart, apex_application_page_chart_s, and apex_application_page_chart_a (5.2 feature #2126)
Rem    hfarrell    11/23/2017 - In apex_application_page_chart_a: added major and minor axes for gantt chart support
Rem    cczarski    11/27/2017 - change _CREDENTIALS, _REMOTE_SERVERS and _RESTENABLED_SQL views to use APEX_WORKSPACE prefix
Rem    cczarski    11/28/2017 - added apex_applications.no_proxy_domains (feature #2249)
Rem    cczarski    12/04/2017 - added apex_application_page_chart_s.aggregate_function and .include_rowid_column (feature #2235)
Rem    cczarski    12/06/2017 - In apex_appl_web_src_comp_params: Added references to wwv_flow_jet_chart_series (feature #2235)
Rem    jstraub     12/08/2017 - Added apex_webservice_log (feature #2233)
Rem    hfarrell    12/14/2017 - apex_application_page_chart_s: added viewport page item handling for gantt charts; removed start_date_value and end_date_value unused columns
Rem    jstraub     12/14/2017 - Added apex_webservice_log.status_code, elapsed_sec
Rem    cneumuel    12/19/2017 - In apex_workspace_activity_log: added view_timestamp, ecid (feature #1878)
Rem    cczarski    12/18/2017 - Added pass_ecid and static_id to apex_appl_web_src_modules
Rem                             Added source_post_processing, external_filter_expr and external_order_by_expr to apex_application_page_regions and apex_application_page_chart_s
Rem    cbcho       01/05/2018 - Added apex_application_settings (feature #2257)
Rem    hfarrell    01/05/2018 - Updated apex_application_page_chart_s: added gantt chart css class name support for task, baseline and progress bars
Rem    cneumuel    01/08/2018 - Fixed column names in comments on apex_application_settings and apex_application_page_chart_s
Rem    cczarski    01/08/2018 - Updated apex_appl_web_src_modules: changes "ORACLE_SAAS" to "ADFBC"
Rem    hfarrell    01/11/2018 - In apex_application_page_ir_rpt: added chart_orientation (feature #1840)
Rem    pawolf      01/16/2018 - In wwv_flow_user_interfaces: changed include_legacy_javascript from a flag to checkbox values (feature #2223)
Rem    hfarrell    01/16/2018 - In apex_application_page_chart_s: add items_label_display_as for flexibility with pie/donut charts
Rem    sbkenned    01/16/2018 - added apex_team_feedback.feedback_rating
Rem    cbcho       01/17/2018 - Added apex_application_acl_roles, apex_application_acl_users (feature #2268)
Rem    cneumuel    01/17/2018 - avoid hard-coded APEX schema name
Rem    cneumuel    01/17/2018 - Moved apex_application_acl_roles, apex_application_acl_users up, because apex_component_signatures depends on them
Rem    jstraub     01/18/2018 - Added apex_webservice_log.resp_content_length
Rem    cbcho       01/24/2018 - In wwv_flow_app_settings: added on_upgrade_keep_value, build_option, build_option_id (feature #2257)
Rem    cneumuel    01/26/2018 - In apex_application_build_options: added feature_identifier
Rem    cneumuel    01/26/2018 - In apex_workspace_group_groups, apex_workspace_groups: expose application. Added apex_workspace_acl_user_roles. Removed apex_application_acl_users (feature #2268)
Rem    cbcho       01/31/2018 - In apex_application_acl_roles: added role_static_id, workspace_id.  Removed apex_workspace_acl_user_roles and added apex_application_acl_users (feature #2268)
Rem    mhichwa     01/31/2018 - Added additional_attributes column to apex_workspace_log_archive view (feature )
Rem    pawolf      01/30/2018 - In wwv_flow_fnd_user_groups: added static_id (feature #2268)
Rem    pawolf      02/01/2018 - Added stretch to wwv_flow_region_columns and wwv_flow_ig_report_views (feature #2147)
Rem    hfarrell    02/01/2018 - Added fill_multi_series_gaps to apex_application_page_charts (feature #2246)
Rem    pawolf      02/02/2018 - In wwv_flow_user_interfaces: added built_with_love (feature #2191)
Rem    pawolf      02/05/2018 - Worked on ACL feature
Rem    cneumuel    02/06/2018 - In apex_component_signatures: replace apex_application_acl_roles with apex_appl_acl_roles
Rem    cneumuel    02/08/2018 - In apex_appl_acl_user_roles: added audit columns. In wwv_flow_authorized: sync with wwv_flow_current_sgid in view.sql
Rem    mhichwa     02/08/2018 - enhanced component_signature in apex_appl_acl_roles view
Rem    jstraub     03/06/2018 - Fixed comments for apex_webservice_log
Rem    cczarski    03/15/2018 - use wwv_flow_current_workspaces in apex_workspace_restenabled_sql, _remote_servers and _credentials (EA2-37)
Rem    cneumuel    03/19/2018 - case sensitive comparison (bug #27716666)
Rem    cneumuel    04/05/2018 - In wwv_flow_authorized, wwv_flow_authorized_and_4411: join d-flows-companies, subquery for schemas, admin role in final "or" branch (bug #27566551)
Rem    cczarski    04/27/2018 - Replace union subqueries on wwv_flow_step_buttons / wwv_flow_step_items with coalesce (bug #27938413)
Rem    cneumuel    04/27/2018 - In wwv_flow_authorized, wwv_flow_authorized_and_4411: use dual. Added wwv_flow_authorized_for_dml for views that should support DML (bug #27566551)
Rem    cczarski    07/16/2018 - fix apex_appl_web_src_parameters and apex_appl_web_src_comp_params views not returning values (bug #28349551)
Rem    cczarski    09/17/2018 - Data Model Changes for REST/REST Enabled SQL support for Forms (feature #2374,#2376)
Rem    hfarrell    10/15/2018 - Added support for Status Meter Gauge chart to apex_application_page_charts (19.1 feature #2385)
Rem    hfarrell    10/16/2018 - Added threshold support for Status Meter Gauge
Rem    hfarrell    10/17/2018 - In apex_application_page_charts: added value_position for Status Meter Gauge value positioning
Rem    hfarrell    10/18/2018 - Resolved typo in comment on column value_position for apex_application_page_charts
Rem    cneumuel    10/30/2018 - In apex_workspace_files: avoid duplicates when multiple schemas are assigned to a workspace (bug #28539197)
Rem    arayner     11/01/2018 - In apex_application_lovs: Added location columns (feature #2406)
Rem    arayner     11/09/2018 - Added wwv_flow_lists_of_values_cols to wwv_flow_builder_audit_trail and apex_developer_activity_log (feature #2406)
Rem    arayner     11/12/2018 - Added apex_application_lov_cols (feature #2406)
Rem    arayner     11/13/2018 - Renamed columns heading, display_role and display_sequence in wwv_flow_list_of_values_cols (feature #2406)
Rem    cczarski    11/29/2018 - added Read/Write support for REST and REST Enabled SQL and Form support (feature #2374,#2376)
Rem    cneumuel    12/05/2018 - Removed dropped columns (bug #28812054)
Rem    hfarrell    12/05/2018 - In apex_application_page_charts: added gantt tooltip columns
Rem    cczarski    12/07/2018 - support "scope" attribute in wwv_credentials for OAuth2 Authentication (bug #29028213)
Rem    hfarrell    12/07/2018 - Added reference line support for Status Meter Gauge
Rem    cczarski    12/09/2018 - Add wwv_flow_web_src_parans.omit_when_null
Rem    pawolf      12/10/2018 - In apex_application_page_rpt: added component_template_options
Rem    hfarrell    12/11/2018 - In apex_application_page_charts: added stack_label (19.1 feature #2423)
Rem    hfarrell    12/12/2018 - In apex_application_page_chart_s: added stack_category (19.1 feature #2423)
Rem    jstraub     12/12/2018 - Add APEX_WEBSERVICE_LOG to apex_dictionary (bug 27708285)
Rem    hfarrell    12/14/2018 - In apex_application_page_chart_a: added styling support for axes labels (19.1 feature #2379)
Rem    jstraub     01/31/2019 - Add max_webservice_requests to apex_workspaces (bug 28528184)
Rem    jkallman    02/06/2019 - Added trailing semicolon at end of comment line for apex_appl_data_profile_cols.remote_attribute_name (bug #29319220)

col APPUN noprint new_val APPUN
select sys_context('USERENV','CURRENT_SCHEMA') APPUN from sys.dual;

--------------------------------------------
-- B A S E   V I E W S
--

--==============================================================================
prompt ...wwv_flow_authorized
create or replace view wwv_flow_authorized
as
select w.short_name              as workspace,
       w.display_name            as workspace_display_name,
       w.provisioning_company_id as workspace_id,
       f.id                      as application_id,
       f.name                    as application_name,
       f.rejoin_existing_sessions,
       f.authentication_id,
       f.flow_language
  from ( select /*+ no_merge cardinality(t 1) */
                nvl(wwv_flow.get_sgid,0)              sgid,
                sys_context('USERENV','CURRENT_USER') cu,
                sys_context('USERENV','NLS_SORT')     nls_sort
           from sys.dual t ) d,
       wwv_flow_companies w,
       wwv_flows f
where (   f.security_group_id = d.sgid
       or (    f.owner  = d.cu
           and (   d.nls_sort = 'BINARY'
                or nlssort(f.owner,'NLS_SORT=BINARY')=nlssort(d.cu,'NLS_SORT=BINARY')))
       or (select wwv_flow_security.has_apex_admin_read_role_yn(d.cu) from sys.dual)='Y' )
  and exists ( select null
                 from wwv_flow_company_schemas s
                where f.security_group_id = s.security_group_id
                  and f.owner             = s.schema
                  and (   d.nls_sort = 'BINARY'
                       or nlssort(f.owner,'NLS_SORT=BINARY')=nlssort(s.schema,'NLS_SORT=BINARY')))
  and w.provisioning_company_id != 0
  and f.security_group_id       =  w.provisioning_company_id
  and (  d.sgid != 0
      or nvl(f.build_status, 'x') != 'RUN_AND_HIDDEN')
/

--==============================================================================
-- Alternative version that allows DML on the main view. Note that predicate
-- pushdown does not automatically work on this view. The outer query can use
-- the push_pred hint, though.
--==============================================================================
prompt ...wwv_flow_authorized_for_dml
create or replace view wwv_flow_authorized_for_dml
as
select w.short_name              as workspace,
       w.display_name            as workspace_display_name,
       w.provisioning_company_id as workspace_id,
       f.id                      as application_id,
       f.name                    as application_name,
       f.rejoin_existing_sessions,
       f.authentication_id,
       f.flow_language
  from ( select /*+ no_merge cardinality(t 1) */
                nvl(wwv_flow.get_sgid,0)              sgid,
                sys_context('USERENV','CURRENT_USER') cu,
                sys_context('USERENV','NLS_SORT')     nls_sort
           from table(^APPUN..wwv_flow_t_varchar2('X')) t ) d,
       wwv_flow_companies w,
       wwv_flows f
where (   f.security_group_id = d.sgid
       or (    f.owner  = d.cu
           and (   d.nls_sort = 'BINARY'
                or nlssort(f.owner,'NLS_SORT=BINARY')=nlssort(d.cu,'NLS_SORT=BINARY')))
       or (select wwv_flow_security.has_apex_admin_read_role_yn(d.cu) from sys.dual)='Y' )
  and exists ( select null
                 from wwv_flow_company_schemas s
                where f.security_group_id = s.security_group_id
                  and f.owner             = s.schema
                  and (   d.nls_sort = 'BINARY'
                       or nlssort(f.owner,'NLS_SORT=BINARY')=nlssort(s.schema,'NLS_SORT=BINARY')))
  and w.provisioning_company_id != 0
  and f.security_group_id       =  w.provisioning_company_id
  and (  d.sgid != 0
      or nvl(f.build_status, 'x') != 'RUN_AND_HIDDEN')
/

--==============================================================================
prompt ...wwv_flow_authorized_and_4411
create or replace view wwv_flow_authorized_and_4411
as
select w.short_name              as workspace,
       w.display_name            as workspace_display_name,
       w.provisioning_company_id as workspace_id,
       f.id                      as application_id,
       f.name                    as application_name
  from ( select /*+ no_merge cardinality(t 1) */
                nvl(wwv_flow.get_sgid,0)              sgid,
                sys_context('USERENV','CURRENT_USER') cu,
                sys_context('USERENV','NLS_SORT')     nls_sort
           from sys.dual t ) d,
       wwv_flow_companies w,
       wwv_flows f
where (   f.security_group_id = d.sgid
      or ( f.security_group_id = 10 and f.id = 4411 )
      or (    f.owner  = d.cu
          and (   d.nls_sort = 'BINARY'
               or nlssort(f.owner,'NLS_SORT=BINARY')=nlssort(d.cu,'NLS_SORT=BINARY')))
      or (select wwv_flow_security.has_apex_admin_read_role_yn(d.cu) from sys.dual)='Y' )
  and exists ( select null
                 from wwv_flow_company_schemas s
                where f.security_group_id = s.security_group_id
                  and f.owner             = s.schema
                  and (   d.nls_sort = 'BINARY'
                       or nlssort(f.owner,'NLS_SORT=BINARY')=nlssort(s.schema,'NLS_SORT=BINARY')))
  and w.provisioning_company_id != 0
  and f.security_group_id       =  w.provisioning_company_id
  and (  d.sgid != 0
      or nvl(f.build_status, 'x') not in ('RUN_ONLY', 'RUN_AND_HIDDEN'))
/

--==============================================================================
prompt ...apex_instance_parameters
create or replace view apex_instance_parameters (
    name,
    value,
    created_on,
    last_updated_on )
as
select name,
       case
       when name in ('WALLET_PWD','SMTP_PASSWORD') and value is not null then '***'
       else value
       end,
       created_on,
       last_updated_on
  from wwv_flow_platform_prefs,
       wwv_flow_current_sgid sgid
 where sgid.has_apex_admin_read_role_yn = 'Y'
/

--------------------------------------------
-- W O R K S P A C E S
--
prompt ...apex_workspace views
prompt ...apex_workspaces
create or replace view apex_workspaces as
select
    w.short_name                                        workspace,
    w.display_name                                      workspace_display_name,
    w.workspace_description                             workspace_description,
    w.workspace_service_id                              workspace_service_id,
    w.source_identifier                                 source_identifier,
    w.path_prefix                                       path_prefix,
    w.team_dev_fs_limit                                 team_dev_fs_limit,
    w.issue_fs_limit                                    issue_fs_limit,
    --w.FIRST_SCHEMA_PROVISIONED                          first_schema_provisioned,
    --
    count(distinct s.schema)                            schemas,
    max(w.LAST_LOGIN)                                   last_purged_session,
    w.builder_notification_message                      workspace_announcement,
    w.rm_consumer_group                                 rm_consumer_group,
    --
    nvl(w.allow_app_building_yn,'Y')                    allow_app_building_yn,
    nvl(w.allow_packaged_app_ins_yn,'Y')                allow_packaged_app_ins_yn,
    nvl(w.allow_sql_workshop_yn,'Y')                    allow_sql_workshop_yn,
    nvl(w.allow_websheet_dev_yn,'Y')                    allow_websheet_dev_yn,
    nvl(w.allow_team_development_yn,'Y')                allow_team_development_yn,
    nvl(w.allow_team_dev_files_yn,'Y')                  allow_team_dev_files_yn,
    nvl(w.allow_issue_files_yn,'Y')                     allow_issue_files_yn,
    nvl(w.allow_to_be_purged_yn,'Y')                    allow_to_be_purged_yn,
    nvl(w.allow_restful_services_yn,'Y')                allow_restful_services_yn,
    --
    (select count(*)
     from wwv_flow_sessions$
     where security_group_id =
           w.PROVISIONING_COMPANY_ID)                   sessions,
    --
    (select count(*)
     from   wwv_flows
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  applications,
    --
    (select count(*)
     from   wwv_flow_steps
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  application_pages,
    --
    (select count(*)
     from   wwv_flow_fnd_user
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  apex_users,
    --
    (select count(*)
     from wwv_flow_developers d, wwv_flow_fnd_user u
     where (instr(nvl(d.developer_role,'x'),'EDIT') > 0 or
            instr(nvl(d.developer_role,'x'),'ADMIN') > 0 ) and
           d.security_group_id = w.PROVISIONING_COMPANY_ID and
           u.security_group_id = w.PROVISIONING_COMPANY_ID and
           d.userid = u.user_name)
                                                        apex_developers,
    --
    (select count(*)
     from   wwv_flow_developers d, wwv_flow_fnd_user u
     where  instr(nvl(d.developer_role,'x'),'ADMIN') > 0  and
           d.security_group_id = w.PROVISIONING_COMPANY_ID and
           u.security_group_id = w.PROVISIONING_COMPANY_ID and
           d.userid = u.user_name)
                                                        apex_workspace_administrators,
    --
    (select count(*)
     from   wwv_flow_company_filestats
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  files,
    --
    (select count(*)
     from    WWV_FLOW_FILE_OBJECTS$
     where   security_group_id =
            w.PROVISIONING_COMPANY_ID and
            FILE_TYPE = 'SCRIPT' and
            to_char(deleted_as_of,
            'MM.DD.YYYY') = '01.01.0001')               sql_scripts,
    --
    (select count(*)
     from   WWV_FLOW_MESSAGES$
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  translation_messages,
    --
    (select sum(file_bytes)
     from   wwv_flow_company_filestats
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID)                  file_storage,
     w.max_file_bytes                                   file_storage_max,
    --
    nvl(
        (select max(time_stamp) d
        from wwv_flow_activity_log l
        where l.security_group_id = w.PROVISIONING_COMPANY_ID and l.time_stamp > sysdate - 1),
        (select max(log_day) d
        from wwv_flow_log_history h
        where h.workspace_id = w.PROVISIONING_COMPANY_ID)
        ) last_logged_page_view,
    --
     (select count(*)
     from   wwv_flow_activity_log l
     where  security_group_id =
            w.PROVISIONING_COMPANY_ID and
            l.TIME_STAMP > sysdate - 14)                page_views,
     --
     w.files_version,
     w.max_email_messages                               email_maximum,
     w.max_webservice_requests                          webservice_request_maximum,
     --
     max_session_length_sec                             maximum_session_life_seconds,
     max_session_idle_sec                               maximum_session_idle_seconds,
     qos_max_workspace_requests                         max_workspace_requests,
     qos_max_session_requests                           max_session_requests,
     qos_max_session_kill_timeout                       max_session_kill_timeout,
     --
     w.PROVISIONING_COMPANY_ID                          workspace_id,
     w.created_on                                       created_on,
     nvl(w.assigned_on,w.created_on)                    assigned_on
from
     wwv_flow_companies       w,
     wwv_flow_company_schemas s,
     wwv_flow_current_sgid    sgid
where (   sgid.has_apex_admin_read_role_yn = 'Y'
       or sgid.security_group_id           = w.provisioning_company_id
       or (    s.schema = sgid.cu
           and (   sgid.nls_sort='BINARY'
                or nlssort(s.schema,'NLS_SORT=BINARY')=nlssort(sgid.cu,'NLS_SORT=BINARY'))))
  and s.security_group_id = w.provisioning_company_id
  and w.provisioning_company_id != 0
group by  w.provisioning_company_id,
          w.short_name,
          w.source_identifier,
          w.path_prefix,
          w.team_dev_fs_limit,
          w.issue_fs_limit,
          w.first_schema_provisioned,
          w.allow_app_building_yn,
          w.allow_packaged_app_ins_yn,
          w.allow_sql_workshop_yn,
          w.allow_websheet_dev_yn,
          w.allow_team_development_yn,
          w.allow_team_dev_files_yn,
          w.allow_issue_files_yn,
          w.allow_to_be_purged_yn,
          w.allow_restful_services_yn,
          w.builder_notification_message,
          w.rm_consumer_group,
          w.display_name,
          w.workspace_service_id,
          w.workspace_description,
          w.files_version,
          w.max_email_messages,
          w.max_webservice_requests,
          w.max_file_bytes,
          w.max_session_length_sec,
          w.max_session_idle_sec,
          w.qos_max_workspace_requests,
          w.qos_max_session_requests,
          w.qos_max_session_kill_timeout,
          w.created_on,
          w.assigned_on
/

comment on table  apex_workspaces                                is 'Available Application Express (APEX) workspaces';
comment on column apex_workspaces.workspace_id                   is 'Primary key that identifies the workspace';
comment on column apex_workspaces.workspace                      is 'A work area mapped to one or more database schemas';
comment on column apex_workspaces.workspace_display_name         is 'Display name for the workspace';
comment on column apex_workspaces.workspace_description          is 'Optional workspace administrator managed description of the workspace';
comment on column apex_workspaces.workspace_service_id           is 'Common identifier which associates workspaces belonging to the same service';
comment on column apex_workspaces.rm_consumer_group              is 'Resource Manager consumer group';
comment on column apex_workspaces.team_dev_fs_limit              is 'Specifies the maximum size for any file upload to the team development file repository';
comment on column apex_workspaces.issue_fs_limit                 is 'Specifies the maximum size for any file upload to the issues file repository';
comment on column apex_workspaces.allow_app_building_yn          is 'Controls availability of identified component';
comment on column apex_workspaces.allow_packaged_app_ins_yn      is 'Controls availability of identified component';
comment on column apex_workspaces.allow_sql_workshop_yn          is 'Controls availability of identified component';
comment on column apex_workspaces.allow_websheet_dev_yn          is 'Controls availability of identified component';
comment on column apex_workspaces.allow_team_development_yn      is 'Controls availability of identified component';
comment on column apex_workspaces.allow_team_dev_files_yn        is 'Controls availability of identified component';
comment on column apex_workspaces.allow_issue_files_yn           is 'Controls availability of identified component';
comment on column apex_workspaces.allow_to_be_purged_yn          is 'Controls availability of identified component';
comment on column apex_workspaces.allow_restful_services_yn      is 'Controls availability of identified component';
comment on column apex_workspaces.source_identifier              is 'Identifies the workspace when data is synchronized to other systems.';
comment on column apex_workspaces.path_prefix                    is 'Identifies the workspace path_prefix, used in RESTful Services URL to identify the source of a RESTful Service request.';
comment on column apex_workspaces.schemas                        is 'Number of database schemas currently mapped to this workspace';
comment on column apex_workspaces.last_purged_session            is 'Creation date of the most recently purged session.  Used to track last login for workspaces who no longer have entries in the activity log.';
comment on column apex_workspaces.workspace_announcement         is 'Workspace announcement message set from within Workspace Administration';
comment on column apex_workspaces.sessions                       is 'Number of non-purged APEX sessions';
comment on column apex_workspaces.applications                   is 'Number of applications created in this workspace';
comment on column apex_workspaces.application_pages              is 'Number of application pages created in this workspace';
comment on column apex_workspaces.apex_users                     is 'Number of APEX users created in this workspace';
comment on column apex_workspaces.apex_developers                is 'Number of APEX users with developer privilege';
comment on column apex_workspaces.apex_workspace_administrators  is 'Number of APEX users with workspace administrator privilege';
comment on column apex_workspaces.files                          is 'Number of APEX files associated with the workspace';
comment on column apex_workspaces.sql_scripts                    is 'Number of APEX SQL Scripts associated with the workspace';
comment on column apex_workspaces.translation_messages           is 'Number of translatable and translated messages within the workspace';
comment on column apex_workspaces.file_storage                   is 'Size in bytes of all files associated with the workspace';
comment on column apex_workspaces.file_storage_max               is 'Maximum size in bytes of all files associated with the workspace';
comment on column apex_workspaces.last_logged_page_view          is 'Date of most recent page view from the APEX activity log.  The archived activity log is used when no activity is recorded in the standard activity log for the last day.';
comment on column apex_workspaces.page_views                     is 'Count of page views recorded for this workspace in the APEX activity log for the last 2 weeks';
comment on column apex_workspaces.files_version                  is 'Version counter of the attached workspace files.';
comment on column apex_workspaces.maximum_session_life_seconds   is 'Maximum lifetime of session in seconds';
comment on column apex_workspaces.maximum_session_idle_seconds   is 'Maximum session idle time in seconds';
comment on column apex_workspaces.max_workspace_requests         is 'Maximum number of concurrent requests for a workspace';
comment on column apex_workspaces.max_session_requests           is 'Maximum number of concurrent requests for a session';
comment on column apex_workspaces.max_session_kill_timeout       is 'Number of seconds a database session has to be active, before it can be killed if MAX_SESSION_REQUESTS is exceeded';
comment on column apex_workspaces.email_maximum                  is 'Maximum number of email messages over any 24 hour period';
comment on column apex_workspaces.webservice_request_maximum     is 'Maximum number of webservice requests over any 24 hour period';
comment on column apex_workspaces.created_on                     is 'The date the workspace was created';
comment on column apex_workspaces.assigned_on                    is 'The date the workspace was assigned to the customer';

prompt ...apex_workspace_files
create or replace view apex_workspace_files as
select
    w.workspace_id,
    w.workspace                                         workspace_name,
    w.workspace_display_name,
    files.id                                            file_id,
    files.flow_id                                       application_id,
    f.name                                              application_name,
    nvl(files.title,files.filename)                     file_name,
    files.mime_type                                     mime_type,
    files.doc_size                                      file_size,
    files.created_by                                    created_by,
    (select max(email_address)
    from wwv_flow_fnd_user
    where security_group_id = w.workspace_id
    and user_name=files.created_by)                     email,
    files.created_on                                    created_on,
    decode(files.file_type,
      'FLOW_EXPORT','Application Export',
      'IMAGE_EXPORT','Text Image Export',
      'PAGE_EXPORT','Application Page Export',
      'SCRIPT','SQL Script',
      'THEME','User Interface Theme Export',
      'XLIFF','XLIFF Application Translation Export',
      files.file_type)                                  file_type,
    files.blob_content                                  document,
    files.session_id                                    temp_file_session_id
from wwv_flow_file_objects$      files,
     wwv_flows                   f,
     wwv_flow_current_workspaces w
where files.security_group_id = w.workspace_id
  and files.flow_id                       =  f.id(+)
  and to_char(deleted_as_of,'MM.DD.YYYY') =  '01.01.0001'
  and nvl(files.file_type, 'x') not       in ( 'CSS_FILE', 'STATIC_FILE', 'IMAGE_FILE' )
/

comment on table  apex_workspace_files                        is 'Identifies uploaded files belonging to the workspace in the modplsql or EPG documents table';
comment on column apex_workspace_files.workspace_id           is 'Primary key that identifies the workspace';
comment on column apex_workspace_files.workspace_name         is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_files.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_files.file_id                is 'Primary key that identifies the file';
comment on column apex_workspace_files.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_workspace_files.application_name       is 'Identifies the application';
comment on column apex_workspace_files.created_by             is 'Name of the APEX user who created the file';
comment on column apex_workspace_files.email                  is 'Email address that corresponds to the APEX user name';
comment on column apex_workspace_files.created_on             is 'Date the file was created';
comment on column apex_workspace_files.file_name              is 'Name of the file stored in a database BLOB';
comment on column apex_workspace_files.mime_type              is 'Mime type of the file used when fetching the file over the web';
comment on column apex_workspace_files.DOCUMENT               is 'The file';
comment on column apex_workspace_files.FILE_SIZE              is 'Size of the file';
comment on column apex_workspace_files.CREATED_BY             is 'Identifies the APEX User Name who created the file';
comment on column apex_workspace_files.CREATED_ON             is 'Identifies the date the file was loaded into the database BLOB';
comment on column apex_workspace_files.FILE_TYPE              is 'Identifies the APEX file type if available';
comment on column apex_workspace_files.temp_file_session_id   is 'Null for persistent files. For temporary files, the session id where the file was uploaded.';

prompt ...apex_workspace_static_files
create or replace view apex_workspace_static_files as
select f.id                      as workspace_file_id,
       w.workspace,
       w.workspace_display_name,
       w.workspace_id,
       f.file_name,
       f.mime_type,
       f.file_charset,
       f.file_content,
       f.created_by,
       f.created_on,
       f.last_updated_by,
       f.last_updated_on
  from wwv_flow_current_workspaces   w,
       wwv_flow_company_static_files f
 where f.security_group_id = w.workspace_id
/


comment on table apex_workspace_static_files is
    'Stores the files like CSS, images, javascript files, ... of a workspace.';
-- Add comments to the columns
comment on column apex_workspace_static_files.workspace_file_id is
    'Identifies the primary key of this file';
comment on column apex_workspace_static_files.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_workspace_static_files.workspace_display_name is
    'Display name for the workspace';
comment on column apex_workspace_static_files.file_name is
    'Name of the file.';
comment on column apex_workspace_static_files.mime_type is
    'Mime type of the file.';
comment on column apex_workspace_static_files.file_charset is
    'IANA charset used for text files.';
comment on column apex_workspace_static_files.file_content is
    'Blob content of the file.';
comment on column apex_workspace_static_files.created_by is
    'APEX developer who created the file';
comment on column apex_workspace_static_files.created_on is
    'Date of creation';
comment on column apex_workspace_static_files.last_updated_by is
    'APEX developer who made last update';
comment on column apex_workspace_static_files.last_updated_on is
    'Date of last update';

prompt ...apex_workspace_sql_scripts
create or replace view apex_workspace_sql_scripts
as
select
    w.workspace_id,
    w.workspace_name,
    w.workspace_display_name,
    f.filename                  sql_script_name,
    (select max(email_address)
    from wwv_flow_fnd_user
    where security_group_id = w.workspace_id
    and user_name           = f.created_by) email,
    --
    --f.title                     file_name,
    f.mime_type                 mime_type,
    f.doc_size                  file_size,
    f.created_by                owner,
    f.blob_content              sql_script
from wwv_flow_current_workspaces w,
     wwv_flow_file_objects$      f
where f.security_group_id                   = w.workspace_id
  and to_char(f.deleted_as_of,'MM.DD.YYYY') = '01.01.0001'
  and f.file_type                           = 'SCRIPT'
/


comment on table  apex_workspace_sql_scripts                     is 'Identifies SQL Scripts used to execute SQL and PL/SQL commands';
comment on column apex_workspace_sql_scripts.workspace_id        is 'Primary key that identifies the workspace';
comment on column apex_workspace_sql_scripts.workspace_name      is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_sql_scripts.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_sql_scripts.sql_script_name     is 'Identifies name of the SQL Script';
comment on column apex_workspace_sql_scripts.EMAIL               is 'Identifies email address that corresponds to the APEX User Name who owns the SQL Script';
comment on column apex_workspace_sql_scripts.MIME_TYPE           is 'Mime type associated with the file';
comment on column apex_workspace_sql_scripts.FILE_SIZE           is 'Size of the file in the BLOB';
comment on column apex_workspace_sql_scripts.OWNER               is 'Identifies the APEX User Name who crated and owns the SQL Script';
comment on column apex_workspace_sql_scripts.SQL_SCRIPT          is 'The SQL Script file';

prompt ...apex_workspace_sessions
create or replace view apex_workspace_sessions as
select
    w.workspace_id,
    w.workspace_name,
    w.workspace_display_name,
    s.id                                                apex_session_id,
    s.username                                          user_name,
    s.remote_addr                                       remote_addr,
    s.created_on                                        session_created,
    s.idle_timeout_on                                   session_idle_timeout_on,
    s.life_timeout_on                                   session_life_timeout_on,
    s.max_idle_sec                                      session_max_idle_sec,
    s.session_time_zone                                 session_time_zone,
    s.session_lang                                      session_lang,
    s.session_territory                                 session_territory,
    s.debug_level                                       session_debug_level,
    case s.trace_mode
    when 1 then 'SQL'
    when 2 then 'HPROF'
    end                                                 session_trace_mode,
    s.authentication_id                                 session_authentication_id,
    s.tenant_id                                         session_tenant_id,
    a.name                                              session_authentication_name
from wwv_flow_sessions$          s,
     wwv_flow_current_workspaces w,
     wwv_flow_authentications    a
where s.security_group_id = w.workspace_id
  and s.authentication_id = a.id (+)
/

comment on table  apex_workspace_sessions                    is 'Application Express (APEX) sessions by workspace and APEX user';
comment on column apex_workspace_sessions.workspace_id       is 'Primary key that identifies the workspace';
comment on column apex_workspace_sessions.workspace_name     is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_sessions.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_sessions.apex_session_id    is 'Primary key of the apex session';
comment on column apex_workspace_sessions.user_name          is 'Name of the authenticated or public user';
comment on column apex_workspace_sessions.remote_addr        is 'Remote client IP address';
comment on column apex_workspace_sessions.session_created    is 'Date the APEX session was created';
comment on column apex_workspace_sessions.session_idle_timeout_on is 'Date when the APEX session times out because of inactivity';
comment on column apex_workspace_sessions.session_life_timeout_on is 'Date when the APEX session times out because of the maximum session length has been reached';
comment on column apex_workspace_sessions.session_max_idle_sec is 'Maximum idle time in seconds of the APEX session';
comment on column apex_workspace_sessions.session_time_zone  is 'Time zone offset of the APEX session';
comment on column apex_workspace_sessions.session_lang       is 'Language preference of the APEX session';
comment on column apex_workspace_sessions.session_territory  is 'NLS territory preference of the APEX session';
comment on column apex_workspace_sessions.session_debug_level is 'Debug level of the APEX session';
comment on column apex_workspace_sessions.session_trace_mode is 'Trace mode of the APEX session';
comment on column apex_workspace_sessions.session_authentication_id is 'ID of the authentication scheme, if switched at runtime';
comment on column apex_workspace_sessions.session_authentication_name is 'Name of the authentication scheme, if switched at runtime';

prompt ...apex_workspace_session_groups
create or replace view apex_workspace_session_groups as
select
    w.workspace_id,
    w.workspace_name,
    w.workspace_display_name,
    s.id                                                apex_session_id,
    s.username                                          user_name,
    sg.group_name                                       group_name
from wwv_flow_sessions$          s,
     wwv_flow_session_groups$    sg,
     wwv_flow_current_workspaces w
where s.id                 = sg.session_id
  and s.security_group_id  = w.workspace_id
/


comment on table  apex_workspace_session_groups                    is 'Application Express (APEX) groups that are dynamically assigned to sessions';
comment on column apex_workspace_session_groups.workspace_id       is 'Primary key that identifies the workspace';
comment on column apex_workspace_session_groups.workspace_name     is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_session_groups.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_session_groups.apex_session_id    is 'Primary key of the apex session';
comment on column apex_workspace_session_groups.user_name          is 'Name of the authenticated or public user';
comment on column apex_workspace_session_groups.group_name         is 'Name of the dynamically assigned group';

prompt ...apex_workspace_apex_users
create or replace view apex_workspace_apex_users as
select
    workspace_id,
    workspace_name,
    workspace_display_name,
    first_schema_provisioned,
    user_name,
    first_name,
    last_name,
    email,
    date_created,
    date_last_updated,
    available_schemas,
    substr(decode(instr(nvl(role_privs,'x'),'ADMIN'),0,'No','Yes'),1,3)  is_admin,
    substr(decode(instr(nvl(role_privs,'x'),'EDIT'),0,'No','Yes'),1,3)   is_application_developer,
    decode(account_locked,'Y','Yes','No')                                account_locked,
    description,
    password_version,
    account_expiry,
    failed_access_attempts,
    profile_image_name,
    profile_mimetype,
    profile_filename,
    profile_charset
from (
select
    w.workspace_id,
    w.workspace                                                       workspace_name,
    w.workspace_display_name,
    w.first_schema_provisioned,
    u.user_name                                                       user_name,
    u.first_name                                                      first_name,
    u.last_name                                                       last_name,
    u.EMAIL_address                                                   email,
    u.CREATION_DATE                                                   date_created,
    u.LAST_UPDATE_DATE                                                date_last_updated,
    ( select count(*)
        from wwv_flow_company_schemas s
       where s.security_group_id = w.workspace_id )                   available_schemas,
    (select developer_role
       from wwv_flow_developers
      where userid            = u.user_name
        and security_group_id = w.workspace_id)                       role_privs,
    u.account_locked                                                  account_locked,
    u.description                                                     description,
    u.web_password_version                                            password_version,
    u.account_expiry                                                  account_expiry,
    u.failed_access_attempts                                          failed_access_attempts,
    u.profile_image_name                                              profile_image_name,
    u.profile_mimetype                                                profile_mimetype,
    u.profile_filename                                                profile_filename,
    u.profile_charset                                                 profile_charset
from
     wwv_flow_fnd_user           u,
     wwv_flow_current_workspaces w
where u.security_group_id = w.workspace_id
group by  w.workspace_id,
          w.workspace,
          w.workspace_display_name,
          w.first_schema_provisioned,
          u.user_name,
          u.first_name,
          u.last_name,
          u.EMAIL_address,
          u.CREATION_DATE,
          u.LAST_UPDATE_DATE,
          u.account_locked,
          u.description,
          u.web_password_version,
          u.account_expiry,
          u.failed_access_attempts,
          u.profile_image_name,
          u.profile_mimetype,
          u.profile_filename,
          u.profile_charset
) ilv
/

comment on table  apex_workspace_apex_users                          is 'Application Express (APEX) workspace users';
comment on column apex_workspace_apex_users.workspace_id             is 'Primary key that identifies the workspace';
comment on column apex_workspace_apex_users.workspace_name           is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_apex_users.workspace_display_name   is 'Display name for the workspace';
comment on column apex_workspace_apex_users.first_schema_provisioned is 'The associated database schema identified when this workspace was created';
comment on column apex_workspace_apex_users.user_name                is 'The APEX user name used to authenticate to an APEX web page or APEX application';
comment on column apex_workspace_apex_users.first_name               is 'The APEX user''s first name';
comment on column apex_workspace_apex_users.last_name                is 'The APEX user''s last name';
comment on column apex_workspace_apex_users.email                    is 'The email associated with this APEX user';
comment on column apex_workspace_apex_users.date_created             is 'The date the APEX user was created';
comment on column apex_workspace_apex_users.date_last_updated        is 'The date the APEX user definition was last updated';
comment on column apex_workspace_apex_users.available_schemas        is 'The number of database schemas available to the workspace developer';
comment on column apex_workspace_apex_users.is_admin                 is 'Identifies if the APEX user has APEX workspace administration privilege';
comment on column apex_workspace_apex_users.is_application_developer is 'Identifies if the APEX user has APEX application development privilege';
comment on column apex_workspace_apex_users.account_locked           is 'Identifies if the APEX user account is locked';
comment on column apex_workspace_apex_users.description              is 'Description of the APEX user';
comment on column apex_workspace_apex_users.password_version         is 'Version of the algorithm that is used for this user''s password';
comment on column apex_workspace_apex_users.account_expiry           is 'The date of the account expiry';
comment on column apex_workspace_apex_users.failed_access_attempts   is 'The number of failed attempts to access the account';
comment on column apex_workspace_apex_users.profile_image_name       is 'The name of the account profile image';
comment on column apex_workspace_apex_users.profile_mimetype         is 'The mimetype of the account profile image';
comment on column apex_workspace_apex_users.profile_filename         is 'The file name of the account profile image';
comment on column apex_workspace_apex_users.profile_charset          is 'The character set of the account profile image';

prompt ...apex_workspace_developers
create or replace view apex_workspace_developers as
select *
from apex_workspace_apex_users
where is_application_developer = 'Yes'
/

comment on table  apex_workspace_developers                          is 'Application Express (APEX) workspace developers, APEX users with privilege to develop applications';
comment on column apex_workspace_developers.workspace_id             is 'Primary key that identifies the workspace';
comment on column apex_workspace_developers.workspace_name           is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_developers.first_schema_provisioned is 'The associated database schema identified when this workspace was created';
comment on column apex_workspace_developers.user_name                is 'The APEX user name used to authenticate to an APEX web page or APEX application';
comment on column apex_workspace_developers.email                    is 'The email associated with this APEX user';
comment on column apex_workspace_developers.date_created             is 'The date the APEX user was created';
comment on column apex_workspace_developers.date_last_updated        is 'The date the APEX user definition was last updated';
comment on column apex_workspace_developers.available_schemas        is 'The number of database schemas available to the workspace developer';
comment on column apex_workspace_developers.is_admin                 is 'Identifies if the APEX user has APEX workspace administration privilege';
comment on column apex_workspace_developers.is_application_developer is 'Identifies if the APEX user has APEX application development privilege';

prompt ...apex_workspace_group_users
create or replace view apex_workspace_group_users (
    workspace_id,
    workspace_name,
    workspace_display_name,
    user_name,
    group_name ) as
select
    w.workspace_id,
    w.workspace_name,
    w.workspace_display_name,
    u.user_name,
    g.group_name
from
     wwv_flow_fnd_user           u,
     wwv_flow_fnd_group_users    ug,
     wwv_flow_fnd_user_groups    g,
     wwv_flow_current_workspaces w
where u.security_group_id         = w.workspace_id
  and u.user_id                   = ug.user_id
  and u.security_group_id         = ug.security_group_id
  and ug.group_id                 = g.id
  and ug.security_group_id        = g.security_group_id
/
comment on table  apex_workspace_group_users                is 'Application Express (APEX) workspace users and groups relationship';
comment on column apex_workspace_group_users.workspace_id   is 'Primary key that identifies the workspace';
comment on column apex_workspace_group_users.workspace_name is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_group_users.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_group_users.user_name      is 'The APEX user name used to authenticate to an APEX web page or APEX application';
comment on column apex_workspace_group_users.group_name     is 'A workspace group the user_name is associated with';

prompt ...apex_workspace_group_groups
create or replace view apex_workspace_group_groups (
    workspace_id,
    workspace_name,
    workspace_display_name,
    grantee_name,
    group_name,
    grantee_application_id,
    group_application_id ) as
select
    w.workspace_id,
    w.workspace_name,
    w.workspace_display_name,
    ge.group_name,
    gt.group_name,
    ge.flow_id,
    gt.flow_id
from
     wwv_flow_fnd_user_groups  ge,
     wwv_flow_fnd_group_groups gg,
     wwv_flow_fnd_user_groups  gt,
     wwv_flow_current_workspaces w
where gg.security_group_id        = w.workspace_id
  and ge.id                       = gg.grantee_group_id
  and ge.security_group_id        = gg.security_group_id
  and gg.granted_group_id         = gt.id
  and gg.security_group_id        = gt.security_group_id
/
comment on table  apex_workspace_group_groups                is 'Application Express (APEX) workspace group/application role to group/role relationship';
comment on column apex_workspace_group_groups.workspace_id   is 'Primary key that identifies the workspace';
comment on column apex_workspace_group_groups.workspace_name is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_group_groups.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_group_groups.grantee_name   is 'The workspace group/application ACL role that another group/role has been granted to';
comment on column apex_workspace_group_groups.group_name     is 'A workspace group/application ACL role the grantee_name is associated with';
comment on column apex_workspace_group_groups.grantee_application_id is 'The grantee''s application ID if it is an application ACL role';
comment on column apex_workspace_group_groups.group_application_id is 'The group''s application ID if it is an application ACL role';

prompt ...apex_workspace_groups
create or replace view apex_workspace_groups (
    workspace_id,
    workspace_name,
    workspace_display_name,
    group_name,
    group_desc,
    application_id,
    application_name ) as
select
    w.workspace_id,
    w.workspace_name,
    w.workspace_display_name,
    g.group_name,
    g.group_desc,
    g.flow_id,
    f.name
from
     wwv_flow_fnd_user_groups    g,
     wwv_flows                   f,
     wwv_flow_current_workspaces w
where g.security_group_id = w.workspace_id
  and g.flow_id           = f.id (+)
  and g.security_group_id = f.security_group_id (+)
/
comment on table  apex_workspace_groups                is 'Application Express (APEX) workspace groups/application roles';
comment on column apex_workspace_groups.workspace_id   is 'Primary key that identifies the workspace';
comment on column apex_workspace_groups.workspace_name is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_groups.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_groups.group_name     is 'A workspace group';
comment on column apex_workspace_groups.group_desc     is 'The workspace group''s description';
comment on column apex_workspace_groups.application_id is 'The application ID if the group is an application ACL role';
comment on column apex_workspace_groups.application_name is 'Identifies the application';

prompt ...apex_appl_acl_roles
create or replace view apex_appl_acl_roles
as
select
    f.workspace_id,
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    g.id                             role_id,
    g.group_name                     role_name,
    g.static_id                      role_static_id,
    g.group_desc                     role_desc,
    --
    g.group_name||'.'||g.static_id    component_signature
from wwv_flow_fnd_user_groups g,
     wwv_flow_authorized      f
where f.workspace_id      = g.security_group_id
  and f.application_id    = g.flow_id
/

comment on table  apex_appl_acl_roles                        is 'Identifies Application Roles, which are workspace groups that are tied to a specific application';
comment on column apex_appl_acl_roles.workspace_id           is 'Primary key that identifies the workspace';
comment on column apex_appl_acl_roles.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_appl_acl_roles.workspace_display_name is 'Display name for the workspace';
comment on column apex_appl_acl_roles.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_acl_roles.application_name       is 'Identifies the application';
comment on column apex_appl_acl_roles.role_id                is 'Primary key that identifies the role';
comment on column apex_appl_acl_roles.role_name              is 'Role name';
comment on column apex_appl_acl_roles.role_static_id         is 'Static identifier for a role';
comment on column apex_appl_acl_roles.role_desc              is 'The role''s description';
comment on column apex_appl_acl_roles.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';

prompt ...apex_appl_acl_user_roles
create or replace view apex_appl_acl_user_roles
as
select
    u.id                             user_role_id,
    --
    f.workspace_id,
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    u.user_name                      user_name,
    g.id                             role_id,
    g.group_name                     role_name,
    g.static_id                      role_static_id,
    g.group_desc                     role_desc,
    --
    u.created_on                     created_on,
    u.created_by                     created_by,
    u.last_updated_on                last_updated_on,
    u.last_updated_by                last_updated_by,
    --
    u.user_name||
    '.'||g.static_id||
    '.'||g.flow_id                   component_signature
from
     wwv_flow_fnd_user_groups    g,
     wwv_flow_authorized         f,
     wwv_flow_acl_group_users    u
where f.workspace_id      = g.security_group_id
  and f.application_id    = g.flow_id
  and u.security_group_id = f.workspace_id
  and u.group_id          = g.id
/

comment on table  apex_appl_acl_user_roles                        is 'Identifies Application Users used to map application users to application roles';
comment on column apex_appl_acl_user_roles.user_role_id           is 'Primary key that identifies the user role assignment';
comment on column apex_appl_acl_user_roles.workspace_id           is 'Primary key that identifies the workspace';
comment on column apex_appl_acl_user_roles.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_appl_acl_user_roles.workspace_display_name is 'Display name for the workspace';
comment on column apex_appl_acl_user_roles.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_acl_user_roles.application_name       is 'Identifies the application';
comment on column apex_appl_acl_user_roles.user_name              is 'Name of the application user';
comment on column apex_appl_acl_user_roles.role_id                is 'Primary key that identifies the role';
comment on column apex_appl_acl_user_roles.role_name              is 'Name of the assigned application role';
comment on column apex_appl_acl_user_roles.role_static_id         is 'Static identifier of the assigned role';
comment on column apex_appl_acl_user_roles.role_desc              is 'Description of the assigned application role';
comment on column apex_appl_acl_user_roles.created_on             is 'Date of creation';
comment on column apex_appl_acl_user_roles.created_by             is 'APEX developer who created the assignment';
comment on column apex_appl_acl_user_roles.last_updated_on        is 'Date of last_update';
comment on column apex_appl_acl_user_roles.created_by             is 'APEX developer who last updated the assignment';
comment on column apex_appl_acl_user_roles.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';


prompt ...apex_appl_acl_users
create or replace view apex_appl_acl_users
as
select
    min( u.id ) id,
    --
    f.workspace_id,
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    u.user_name,
    lower(u.user_name) user_name_lc,
    listagg( u.group_id, ':' )    within group ( order by u.group_id )   as role_ids,
    listagg( g.group_name, ', ' ) within group ( order by g.group_name ) as role_names
from wwv_flow_authorized_for_dml  f,
     wwv_flow_fnd_user_groups     g,
     wwv_flow_acl_group_users     u
where g.flow_id           = f.application_id
  and u.group_id          = g.id
  and u.security_group_id = g.security_group_id
group by f.workspace_id,
         f.workspace,
         f.workspace_display_name,
         f.application_id,
         f.application_name,
         u.user_name
/

comment on table  apex_appl_acl_users                        is 'Identifies Application Users used to map application users to application roles';
comment on column apex_appl_acl_users.id                     is 'Virtual Primary key that identifies the user';
comment on column apex_appl_acl_users.workspace_id           is 'Primary key that identifies the workspace';
comment on column apex_appl_acl_users.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_appl_acl_users.workspace_display_name is 'Display name for the workspace';
comment on column apex_appl_acl_users.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_acl_users.application_name       is 'Identifies the application';
comment on column apex_appl_acl_users.user_name              is 'Name of the application user';
comment on column apex_appl_acl_users.user_name_lc           is 'Name of the application user, in lower case';
comment on column apex_appl_acl_users.role_ids               is 'Colon delimited list of application role ids which are assigned to the user';
comment on column apex_appl_acl_users.role_names             is 'Comma delimited list of application role names which are assigned to the user';

create or replace trigger apex_appl_acl_users_iot
instead of insert or update or delete
on apex_appl_acl_users
for each row
begin
    if inserting or updating then
        wwv_flow_acl_api.replace_user_roles (
            p_application_id => coalesce( :old.application_id, :new.application_id ), -- don't support updates
            p_user_name      => coalesce( :old.user_name, :new.user_name ),           -- don't support updates
            p_role_ids       => wwv_flow_string.split_numbers( :new.role_ids, ':' ) );
    elsif deleting then
        wwv_flow_acl_api.remove_all_user_roles (
            p_application_id => :old.application_id, -- don't support updates
            p_user_name      => :old.user_name );    -- don't support updates
    end if;
end;
/

prompt ...apex_workspace_schemas
create or replace view apex_workspace_schemas as
select
    w.PROVISIONING_COMPANY_ID                           workspace_id,
    w.short_name                                        workspace_name,
    w.display_name                                      workspace_display_name,
    w.FIRST_SCHEMA_PROVISIONED                          first_schema_provisioned,
    s.schema                                            schema,
    (select created
     from   sys.all_users
     where  username = s.schema)                        schema_created,
    (select count(*)
     from wwv_flows
     where security_group_id=w.PROVISIONING_COMPANY_ID
      and s.schema = owner)                             applications
from wwv_flow_companies       w,
     wwv_flow_company_schemas s,
     wwv_flow_current_sgid    sgid
where s.security_group_id = w.provisioning_company_id
  and (   sgid.security_group_id          = w.provisioning_company_id
       or sgid.has_apex_admin_read_role_yn = 'Y'
       or (    s.schema = sgid.cu
           and (   sgid.nls_sort='BINARY'
                or nlssort(s.schema,'NLS_SORT=BINARY')=nlssort(sgid.cu,'NLS_SORT=BINARY'))))
/

comment on table  apex_workspace_schemas                          is 'Database Schemas mapped to APEX workspaces';
comment on column apex_workspace_schemas.workspace_id             is 'Primary key that identifies the workspace';
comment on column apex_workspace_schemas.workspace_name           is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_schemas.workspace_display_name   is 'Display name for the workspace';
comment on column apex_workspace_schemas.first_schema_provisioned is 'The associated database schema identified when this workspace was created';
comment on column apex_workspace_schemas.schema                   is 'Database schema name mapped to workspace';
comment on column apex_workspace_schemas.schema_created           is 'Identifies the date that the database schema was created';
comment on column apex_workspace_schemas.applications             is 'Number of applications within the current workspace and schema';

prompt ...apex_workspace_ui_types
create or replace view apex_workspace_ui_types
as
select u.id                      as ui_type_id,
       w.workspace,
       w.workspace_display_name,
       w.workspace_id,
       u.name,
       u.based_on_ui_type_id,
       u.autodetect_js_file_urls,
       u.autodetect_js_function_body,
       u.autodetect_plsql_function_body,
       u.created_by,
       u.created_on,
       u.last_updated_by,
       u.last_updated_on
  from wwv_flow_ui_types           u,
       wwv_flow_current_workspaces w
 where w.workspace_id = u.security_group_id
union all
select u.id                      as ui_type_id,
       to_char(null),
       to_char(null),
       to_number(null),
       u.name,
       u.based_on_ui_type_id,
       u.autodetect_js_file_urls,
       u.autodetect_js_function_body,
       u.autodetect_plsql_function_body,
       u.created_by,
       u.created_on,
       u.last_updated_by,
       u.last_updated_on
  from wwv_flow_ui_types u
 where u.security_group_id is null
/


comment on table apex_workspace_ui_types is
    'The UI Types identify the available user interface types of a workspace';
-- Add comments to the columns
comment on column apex_workspace_ui_types.ui_type_id is
    'Identifies the primary key of this component';
comment on column apex_workspace_ui_types.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_workspace_ui_types.workspace_display_name is
    'Display name for the workspace';
comment on column apex_workspace_ui_types.name is
    'Contains the name of the UI type.';
comment on column apex_workspace_ui_types.based_on_ui_type_id is
    'Foreign key to inherit the components of the specified base UI type.';
comment on column apex_workspace_ui_types.autodetect_js_file_urls is
    'List of JavaScript URLs which should be loaded for the auto detection of the UI type.';
comment on column apex_workspace_ui_types.autodetect_js_function_body is
    'JavaScript function which returns true if the current device supports the UI type.';
comment on column apex_workspace_ui_types.autodetect_plsql_function_body is
    'PL/SQL function which returns true if the current device supports the UI type.';
comment on column apex_workspace_ui_types.created_by is
    'APEX developer who created the theme style';
comment on column apex_workspace_ui_types.created_on is
    'Date of creation';
comment on column apex_workspace_ui_types.last_updated_by is
    'APEX developer who made last update';
comment on column apex_workspace_ui_types.last_updated_on is
    'Date of last update';

--------------------------------------------
-- A P P L I C A T I O N S
-- 4001

prompt ...apex_applications
create or replace view apex_applications as
select
    w.workspace,
    w.workspace_display_name,
    f.ID                             application_id,
    f.NAME                           application_name,
    f.ALIAS                          alias,
    f.OWNER                          owner,
    (select group_name from wwv_flow_application_groups where id = f.group_id) application_group,
    group_id                         application_group_id,
    decode(upper(f.WEBDB_LOGGING),
        'YES','Yes',
        'NO','No',f.WEBDB_LOGGING)   logging,
    f.FLOW_LANGUAGE                  application_primary_language,
    f.FLOW_LANGUAGE_DERIVED_FROM     language_derived_from,
    decode(upper(f.csv_encoding),
        'Y','Yes',
        'N','No', f.csv_encoding)    csv_encoding,
    f.date_format                    date_format,
    f.date_time_format               date_time_format,
    f.timestamp_format               timestamp_format,
    f.timestamp_tz_format            timestamp_tz_format,
    f.nls_sort                       nls_sort,
    f.nls_comp                       nls_comp,
    f.direction_right_to_left        direction_right_to_left,
    f.auto_time_zone                 auto_time_zone,
    f.ui_detection_css_urls          ui_detection_css_urls,
    f.error_handling_function        error_handling_function,
    f.default_error_display_location default_error_display_location,
    f.FLOW_IMAGE_PREFIX              image_prefix,
    case substr(authentication.scheme_type,1,7)
      when 'NATIVE_' then
        ( select display_name
            from wwv_flow_plugins
           where flow_id     = 4411
             and plugin_type = 'AUTHENTICATION TYPE'
             and name        = substr(authentication.scheme_type, 8) )
      when 'PLUGIN_' then
        ( select display_name
            from wwv_flow_plugins
           where flow_id     = f.id
             and plugin_type = 'AUTHENTICATION TYPE'
             and name        = substr(authentication.scheme_type, 8) )
      else
        decode(f.AUTHENTICATION,
            'CUSTOM2','Authentication Scheme',
            'COOKIE', 'APEX Authentication',
            f.AUTHENTICATION)
    end                              authentication_scheme_type,
    authentication.name              authentication_scheme,
    f.authentication_id              authentication_scheme_id,
    authentication.LOGOUT_URL        logout_url,
    case f.logo_type
      when 'T'  then 'Text Logo'
      when 'I'  then 'Image Logo'
      when 'IT' then 'Image and Text Logo'
      when 'C'  then 'Custom Logo'
    end                              logo_type,
    f.LOGO                           logo,
    f.LOGO_TEXT                      logo_text,
    f.app_builder_icon_name          app_builder_icon_name,
    f.favicons                       favicons,
    --f.PUBLIC_URL_PREFIX              public_url_prefix,
    f.PUBLIC_USER                    public_user,
    --f.DBAUTH_URL_PREFIX              db_auth_url_prefix,
    f.PROXY_SERVER                   proxy_server,
    f.no_proxy_domains               no_proxy_domains,
    f.media_type                     media_type,
    --
    --f.CUSTOM_AUTHENTICATION_PAGE     custom_auth_page,
    --f.CUSTOM_AUTH_LOGIN_URL          custom_auth_login_url,
    f.FLOW_VERSION                     version,
    decode(f.FLOW_STATUS,
        'AVAILABLE','Available',
        'AVAILABLE_W_EDIT_LINK','Available with Edit Links',
        'DEVELOPERS_ONLY','Available to Developers Only',
        'RESTRICTED_ACCESS','Restricted Access',
        'UNAVAILABLE','Unavailable',
        'UNAVAILABLE_PLSQL','Unavailable (Status Shown with PL/SQL)',
        'UNAVAILABLE_URL','Unavailable (Redirect to URL)',
        f.flow_status)               availability_status,
    f.FLOW_UNAVAILABLE_TEXT          unavailable_text,
    f.RESTRICT_TO_USER_LIST          restrict_to_user,
    decode(f.APPLICATION_TAB_SET,
        1,'Allowed',0,'Not Allowed',
        'Allowed')                   debugging,
    decode(f.EXACT_SUBSTITUTIONS_ONLY,
       'N','No','Y','Yes',
       f.EXACT_SUBSTITUTIONS_ONLY)   exact_substitutions,
    decode(f.BUILD_STATUS,
       'RUN_ONLY','Run Only',
       'RUN_AND_BUILD','Run and Develop',
       'RUN_AND_HIDDEN','Run and Hidden',
       f.BUILD_STATUS)               build_status,
    decode(f.publish_yn,'Y','Yes','N','No','No') publish,
    f.VPD                            vpd, /* for compatibility reasons */
    f.VPD                            db_session_init_code,
    f.vpd_teardown_code              db_session_cleanup_code,
    --
    decode(substr(f.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(f.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     f.SECURITY_SCHEME)              authorization_scheme,
    f.security_scheme                authorization_scheme_id,
    decode(f.authorize_public_pages_yn,'Y','Yes','No') authorize_public_pages,
    f.LAST_UPDATED_BY                last_updated_by,
    f.LAST_UPDATED_ON                last_updated_on,
    f.GLOBAL_NOTIFICATION            global_notification,
    decode(f.PAGE_PROTECTION_ENABLED_Y_N,
      'Y','Enabled',
      'N','Disabled',
      'Disabled')                    Session_State_Protection,
    f.MAX_SESSION_LENGTH_SEC         Maximum_Session_Life_Seconds,
    ON_MAX_SESSION_TIMEOUT_URL       Session_Lifetime_Exceeded_URL,
    f.MAX_SESSION_IDLE_SEC           Maximum_Session_Idle_Seconds,
    ON_MAX_IDLE_TIMEOUT_URL          Session_Idle_Time_Exceeded_URL,
    case f.browser_cache
      when 'Y' then 'Enabled'
      else          'Disabled'
    end                              browser_cache,
    case f.browser_frame
      when 'D' then 'Deny'
      when 'S' then 'Allow from same origin'
      else          'Allow'
    end                              browser_frame,
    case f.deep_linking
      when 'Y' then 'Enabled'
      else          'Disabled'
    end                              deep_linking,
    compatibility_mode,
    case html_escaping_mode
      when 'B' then 'Basic'
      when 'E' then 'Extended'
    end html_escaping_mode,
    case allow_feedback_yn
      when 'Y' then 'Enabled'
      else          'Disabled'
    end                              feedback,
    email_from,
    f.file_prefix,
    f.files_version,
    f.runtime_api_usage,
    case f.rejoin_existing_sessions
    when 'Y' then 'All Sessions'
    when 'P' then 'Public Sessions'
    when 'N' then 'Disabled'
    end                              rejoin_existing_sessions,
    f.http_response_headers          http_response_headers,
    f.bookmark_checksum_function     bookmark_checksum_function,
    -- sub components
    (select count(*) from wwv_flow_steps where flow_id = f.id)               pages,
    (select count(*) from wwv_flow_tabs where flow_id = f.id)                tabs,
    (select count(*) from wwv_flow_toplevel_tabs where flow_id = f.id)       parent_tabs,
    (select count(*) from wwv_flow_items where flow_id = f.id)               application_items,
    (select count(*) from wwv_flow_processing where flow_id = f.id)          application_processes,
    (select count(*) from wwv_flow_computations where flow_id = f.id)        application_computations,
    (select count(*) from wwv_flow_app_settings where flow_id = f.id)        application_settings,
    (select count(*) from wwv_flow_shortcuts where flow_id = f.id)           shortcuts,
    (select count(*) from wwv_flow_shared_web_services where flow_id = f.id) web_services,
    (select count(*) from wwv_flow_trees where flow_id = f.id)               trees,
    (select count(*) from wwv_flow_patches where flow_id = f.id)             build_options,
    (select count(*) from wwv_flow_menus where flow_id = f.id)               breadcrumbs,
    (select count(*) from wwv_flow_icon_bar where flow_id = f.id)            nav_bar_entries,
    (select count(*) from wwv_flow_lists where flow_id = f.id)               lists,
    (select count(*) from wwv_flow_lists_of_values$ where flow_id = f.id)    lists_of_values,
    (select count(*) from wwv_flow_themes where flow_id = f.id)              themes,
    (select count(*) from wwv_flow_authentications where flow_id = f.id)     authentication_schemes,
    (select count(*) from WWV_FLOW_SECURITY_SCHEMES where flow_id = f.id)    authorization_schemes,
    (select count(*) from wwv_flow_fnd_user_groups where flow_id = f.id)     application_acl_roles,
    (select count(*) from WWV_FLOW_MESSAGES$ where flow_id = f.id)           translation_messages,
    (select count(*) from wwv_flow_install_scripts where flow_id = f.id)     installation_scripts,
    (select count(*) from WWV_FLOW_STEPS where flow_id = f.id and CACHE_MODE <> 'NOCACHE') cached_pages,
    (select count(*) from WWV_FLOW_PAGE_PLUGS where flow_id = f.id and PLUG_CACHING <> 'NOCACHE') cached_regions,
    --
    'a='||f.ALIAS
    ||' o='||f.OWNER
    ||' l='||decode(upper(f.WEBDB_LOGGING),'YES','Yes','NO','No',f.WEBDB_LOGGING)
    ||' l='||f.FLOW_LANGUAGE||' '||f.FLOW_LANGUAGE_DERIVED_FROM
    ||' i='||substr(f.FLOW_IMAGE_PREFIX,1,20)||length(f.FLOW_IMAGE_PREFIX)
    ||' a='||substr(f.AUTHENTICATION,1,20)||length(f.AUTHENTICATION)
    ||' l='||f.logo_type
    ||','||substr(f.LOGO,1,20)||length(f.LOGO)
    ||','||substr(f.LOGO_TEXT,1,20)||length(f.LOGO_TEXT)
    ||' p='||f.PUBLIC_USER
    ||' p='||substr(f.PROXY_SERVER,1,20)||length(f.PROXY_SERVER)
    ||' v='||f.FLOW_VERSION
    ||' s='||decode(f.FLOW_STATUS,
        'AVAILABLE','Available',
        'AVAILABLE_W_EDIT_LINK','AvailwEL',
        'DEVELOPERS_ONLY','DevOnly',
        'RESTRICTED_ACCESS','Rests',
        'UNAVAILABLE','Unavail',
        'UNAVAILABLE_PLSQL','UnavailPL/SQL)',
        'UNAVAILABLE_URL','UnavailableRedir',
        f.flow_status)
    ||' u='||substr(f.FLOW_UNAVAILABLE_TEXT,1,20)||length(f.FLOW_UNAVAILABLE_TEXT)
    ||' r='||substr(f.RESTRICT_TO_USER_LIST,1,20)||length(f.RESTRICT_TO_USER_LIST)
    ||' d='||decode(f.APPLICATION_TAB_SET,
        1,'Allowed',0,'!Allowed',
        'Allowed')
    ||' s='||decode(f.EXACT_SUBSTITUTIONS_ONLY,
       'N','No','Y','Yes',
       f.EXACT_SUBSTITUTIONS_ONLY)
    ||' s='||decode(f.BUILD_STATUS,
       'RUN_ONLY','Run Only',
       'RUN_AND_BUILD','Run+Dev',
       f.BUILD_STATUS)
    ||' v='||substr(f.VPD,1,20)||length(f.vpd)
    ||' v2='||substr(f.vpd_teardown_code,1,20)||length(f.vpd_teardown_code)
    ||' a='||decode(substr(f.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(f.SECURITY_SCHEME,'!')
     and    flow_id = f.id),
     'Not found')
    ||' gn='||substr(f.GLOBAL_NOTIFICATION,1,20)||length(f.GLOBAL_NOTIFICATION)
    ||' pp='||decode(f.PAGE_PROTECTION_ENABLED_Y_N,'Y','Enabled','N','Disabled','Disabled')
    ||' timeout='||f.MAX_SESSION_LENGTH_SEC||'.'||ON_MAX_SESSION_TIMEOUT_URL||'.'||f.MAX_SESSION_IDLE_SEC||'.'||ON_MAX_IDLE_TIMEOUT_URL
    component_signature,
    f.security_group_id workspace_id,
    --
    -- For compatibility with SQL Developer and existing applications (bug# 14545162)
    -- Get the values from the user interfaces table, but only if the app has only one user interface
    ( select case when count(*) = 1 then min(theme_id) end
        from wwv_flow_user_interfaces
       where flow_id = f.id ) as theme_number,
    ( select case when count(*) = 1 then min(home_url) end
        from wwv_flow_user_interfaces
       where flow_id = f.id ) as home_link,
    ( select case when count(*) = 1 then min(login_url) end
        from wwv_flow_user_interfaces
       where flow_id = f.id ) as login_url,
    ( select case when count(*) = 1 then min(pt.name) end
        from wwv_flow_user_interfaces ui,
             wwv_flow_themes t,
             wwv_flow_templates pt
       where ui.flow_id = f.id
         and t.flow_id  = ui.flow_id
         and t.theme_id = ui.theme_id
         and pt.id      = t.default_page_template ) as page_template,
    ( select case when count(*) = 1 then min(pt.name) end
        from wwv_flow_user_interfaces ui,
             wwv_flow_themes t,
             wwv_flow_templates pt
       where ui.flow_id = f.id
         and t.flow_id  = ui.flow_id
         and t.theme_id = ui.theme_id
         and pt.id      = t.error_template ) as error_page_template,
    ( select case when count(*) = 1 then min(content_delivery_network) end
        from wwv_flow_user_interfaces
       where flow_id = f.id ) as content_delivery_network,
    ( select case when count(*) = 1 then min(javascript_file_urls) end
        from wwv_flow_user_interfaces
       where flow_id = f.id ) as javascript_file_urls,
    ( select case when count(*) = 1 then min(include_legacy_javascript) end
        from wwv_flow_user_interfaces
       where flow_id = f.id ) as include_legacy_javascript
from wwv_flows                   f,
     wwv_flow_authentications    authentication,
     wwv_flow_current_workspaces w
where f.security_group_id       =  w.workspace_id
  and f.authentication_id       =  authentication.id (+)
  /* keep this not exists */
  and not exists ( select 1
                     from wwv_flow_language_map m
                    where m.translation_flow_id = f.id
                      and m.security_group_id   = f.security_group_id
                      and f.authentication_id   <> trunc(f.authentication_id) )
/



comment on table  apex_applications                              is 'Applications defined in the current workspace or database user.';
comment on column apex_applications.workspace                    is 'A work area mapped to one or more database schemas';
comment on column apex_applications.workspace_display_name       is 'Display name for the workspace';
comment on column apex_applications.application_id               is 'Application Primary Key, Unique over all workspaces';
comment on column apex_applications.application_name             is 'Identifies the application';
comment on column apex_applications.application_group            is 'Identifies the name of the application group this application is associated with';
comment on column apex_applications.application_group_id         is 'Identifies the ID of the application group this application is associated with';
comment on column apex_applications.alias                        is 'Assigns an alternate alphanumeric application identifier';
comment on column apex_applications.owner                        is 'Identifies the database schema that this application will parse SQL and PL/SQL statements as';
comment on column apex_applications.logging                      is 'Determines whether or not user activity is recorded in the activity log';
comment on column apex_applications.application_primary_language is 'Identifies the language in which an application is developed';
comment on column apex_applications.language_derived_from        is 'For use when translating an application; specifies how APEX determines or derives the application language';
comment on column apex_applications.csv_encoding                 is 'Automatic CSV Encoding.  If Automatic CSV Encoding is enabled, CSV report output will be properly converted to a character set compatible with localized desktop applications. The character set for CSV Encoding will be determined by the the specific application language setting.';
comment on column apex_applications.date_format                  is 'Application default date format.  Will set NLS_DATE_FORMAT prior to showing or posting a page';
comment on column apex_applications.date_time_format             is 'Application date time format.  Can be referenced via APP_DATE_TIME_FORMAT';
comment on column apex_applications.timestamp_format             is 'Application default timestamp format.  Will set NLS_TIMESTAMP_FORMAT prior to showing or posting a page';
comment on column apex_applications.timestamp_tz_format          is 'Application default timestamp time zone format.  Will set NLS_TIMESTAMP_TZ_FORMAT prior to showing or posting a page';
comment on column apex_applications.nls_sort                     is 'Collating sequence for character value comparison in SQL operations and clauses.  Will set NLS_SORT prior to rendering individual components';
comment on column apex_applications.nls_comp                     is 'Collation behavior of SQL operations.  Will set NLS_COMP prior to rendering individual components';
comment on column apex_applications.direction_right_to_left      is 'Indicates whether page is rendered left to right or right to left ';
comment on column apex_applications.auto_time_zone               is 'Automatic time zone.  Will derive the client time zone from the browser and set the database session imezone automatically at the beginning of each APEX session';
comment on column apex_applications.ui_detection_css_urls        is 'Specifies CSS file URLs that will be loaded on the User Interface detection page';
comment on column apex_applications.error_handling_function      is 'Function which is called if an error occurs. It can be used to modify or log the error.';
comment on column apex_applications.default_error_display_location is 'The default error display location identifies where validation error message will display. Messages can be displayed on an error page, or inline with the existing page. Inline validations are displayed in the "notification" area (defined as part of the page template), and/or within the item label.';
comment on column apex_applications.image_prefix                 is 'Determines the virtual path the Web server uses to point to the images directory distributed with APEX';
comment on column apex_applications.authentication_scheme        is 'Identifies the current authentication method used by this application. The purpose of authentication is to determine the application users identity';
comment on column apex_applications.authentication_scheme_id     is 'Identifies the current authentication method foreign key';
comment on column apex_applications.authentication_scheme_type   is 'Identifies the type of authentication scheme';
comment on column apex_applications.publish                      is 'Display this application in a list of available applications';
comment on column apex_applications.logout_url                   is 'Used as the LOGOUT_URL substitution string and identifies a URL to redirect to when the user wishes to logout of the application';
comment on column apex_applications.logo_type                    is 'Identifies the logo as text, an image or custom';
comment on column apex_applications.logo                         is 'Used as the LOGO substitution string, declarative image name or custom markup which can be referenced from page templates';
comment on column apex_applications.logo_text                    is 'Used as the LOGO substitution string, declarative name of the application which can be referenced from page templates';
comment on column apex_applications.app_builder_icon_name        is 'URL to an image to be used as the application item in App Builder.';
comment on column apex_applications.favicons                     is 'Used as the FAVICONS substitution string, contains HTML code for to display the application "favicons"';
comment on column apex_applications.public_user                  is 'If the APP_USER equals this database schema name then the user is considered a public or unauthenticated user.  Based on this declarative IS_PUBLIC_USER conditions are determined.';
comment on column apex_applications.proxy_server                 is 'Use this proxy server when a proxy server is needed';
comment on column apex_applications.no_proxy_domains             is 'Domains not to use the proxy server for';
comment on column apex_applications.media_type                   is 'Application-level Internet media type, used in the Content-Type HTTP header';
comment on column apex_applications.VERSION                      is 'Includes the application''s version number on a page';
comment on column apex_applications.AVAILABILITY_STATUS          is 'Specifies whether or not the application is available or unavailable for use';
comment on column apex_applications.UNAVAILABLE_TEXT             is 'This attribute in conjunction with the Availability Status.  Identifies the text to display when the application is not available';
comment on column apex_applications.RESTRICT_TO_USER             is 'Use this attribute in conjunction with the Availability Status "Restricted Access". Only the users listed in this attribute can run the application.';
comment on column apex_applications.DEBUGGING                    is 'Determines whether pages may be display in debug mode.  Debugging is typically on for development and turned off for production.';
comment on column apex_applications.EXACT_SUBSTITUTIONS          is 'Determines if text substitutions require a trailing dot.  This values should always be Yes.  Provided for compatibility with preproduction releases.';
comment on column apex_applications.BUILD_STATUS                 is 'Determines if the application is available for development.  Production applications can be set to "Run Only" which will cause the application to appear in the APEX App Builder.';
comment on column apex_applications.VPD                          is 'Deprecated. Use column DB_SESSION_INIT_CODE';
comment on column apex_applications.DB_SESSION_INIT_CODE         is 'Identifies PL/SQL that is dynamically executed immediately after the user is authenticated and before any application logic is processed. This attribute can assign security policies to restrict access to database tables and views.';
comment on column apex_applications.DB_SESSION_CLEANUP_CODE      is 'Identifies PL/SQL that is dynamically executed after any application logic is processed. This attribute can free resources like database links or application contexts.';
comment on column apex_applications.runtime_api_usage            is 'A colon separated list that identifies what metadata the application is allowed to change: (T)his application, (O)ther applications, (W)orkspace repository';
comment on column apex_applications.rejoin_existing_sessions     is 'Determines whether sessions for this application can be joined without session id in the URL';
comment on column apex_applications.http_response_headers        is 'This attribute contains http response headers that APEX should send each time for this application';
comment on column apex_applications.bookmark_checksum_function   is 'The algorithm which is used to produce URL checksums';
comment on column apex_applications.AUTHORIZATION_SCHEME         is 'Identifies an Authorization Scheme that will be applied to all pages of the application';
comment on column apex_applications.AUTHORIZATION_SCHEME_ID      is 'Identifies an Authorization Scheme foreign key';
comment on column apex_applications.AUTHORIZE_PUBLIC_PAGES       is 'Determines if the application-level authorization scheme should be checked on public pages';
comment on column apex_applications.GLOBAL_NOTIFICATION          is 'This text is displayed on every page of the application that uses a page template with the #GLOBAL_NOTIFICATION# substitution string';
comment on column apex_applications.Session_State_Protection     is 'Enabling Session State Protection can prevent hackers from tampering with URLs within your application.  When enabled pages and items can be set to require checksums to validate inputs.';
comment on column apex_applications.last_updated_by              is 'APEX developer who made last update';
comment on column apex_applications.last_updated_on              is 'Date of last update';
comment on column apex_applications.pages                        is 'Count of subordinate objects';
comment on column apex_applications.tabs                         is 'Count of subordinate objects';
comment on column apex_applications.parent_tabs                  is 'Count of subordinate objects';
comment on column apex_applications.application_items            is 'Count of subordinate objects';
comment on column apex_applications.application_processes        is 'Count of subordinate objects';
comment on column apex_applications.application_computations     is 'Count of subordinate objects';
comment on column apex_applications.application_settings         is 'Count of subordinate objects';
comment on column apex_applications.shortcuts                    is 'Count of subordinate objects';
comment on column apex_applications.web_services                 is 'Count of subordinate objects';
comment on column apex_applications.trees                        is 'Count of subordinate objects';
comment on column apex_applications.build_options                is 'Count of subordinate objects';
comment on column apex_applications.breadcrumbs                  is 'Count of subordinate objects';
comment on column apex_applications.nav_bar_entries              is 'Count of subordinate objects';
comment on column apex_applications.lists                        is 'Count of subordinate objects';
comment on column apex_applications.lists_of_values              is 'Count of subordinate objects';
comment on column apex_applications.themes                       is 'Count of subordinate objects';
comment on column apex_applications.authentication_schemes       is 'Count of subordinate objects';
comment on column apex_applications.authorization_schemes        is 'Count of subordinate objects';
comment on column apex_applications.application_acl_roles        is 'Count of subordinate objects';
comment on column apex_applications.translation_messages         is 'Count of subordinate objects';
comment on column apex_applications.installation_scripts         is 'Count of subordinate objects';
comment on column apex_applications.cached_pages                 is 'Count of pages in this application that are defined as cachable';
comment on column apex_applications.cached_regions               is 'Count of page regions in this application that are defined as cachable';
comment on column apex_applications.component_signature          is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_applications.workspace_id                 is 'Primary Key of the Workspace';
comment on column apex_applications.Maximum_Session_Life_Seconds is 'Maximum lifetime of session in seconds';
comment on column apex_applications.Session_Lifetime_Exceeded_URL is 'Go to URL when session lifetime exceeded';
comment on column apex_applications.Maximum_Session_Idle_Seconds is 'Maximum session idle time in seconds';
comment on column apex_applications.Session_Idle_Time_Exceeded_URL is 'Go to URL when session idle time exceeded';
comment on column apex_applications.browser_cache                is 'Determines if the browser should cache pages';
comment on column apex_applications.browser_frame                is 'Determines if the browser should allow to display pages in a frame';
comment on column apex_applications.deep_linking                 is 'Determines if deep linking into the application is allowed';
comment on column apex_applications.compatibility_mode           is 'Compatibility Mode is used to determine how the runtime engine should behave when the application is executed';
comment on column apex_applications.html_escaping_mode           is 'HTML Escaping Mode is used to determine if the Basic or an Extended algorithm for html escaping should be used';
comment on column apex_applications.feedback                     is 'Determines if feedback can be accepted for the application.';
comment on column apex_applications.email_from                   is 'Identifies email address to use as from address when sending email from Interactive report email download or subscription';
comment on column apex_applications.file_prefix                  is 'File prefix which is used by the application to load additional files like CSS, Javascript and images.';
comment on column apex_applications.files_version                is 'Version counter of the attached application files.';
comment on column apex_applications.THEME_NUMBER                 is 'Identifies the applications current user interface theme (obsolete)';
comment on column apex_applications.home_link                    is 'URL used to navigate to the home page of the application (obsolete)';
comment on column apex_applications.login_url                    is 'When running this application redirect to this URL (obsolete)';
comment on column apex_applications.page_template                is 'The default page template for displaying pages, may be overridden at the page level (obsolete)';
comment on column apex_applications.error_page_template          is 'Display unexpected errors on an error page using this page template. (obsolete)';
comment on column apex_applications.content_delivery_network     is 'Specifies the Content Delivery Network which is used to load the 3rd party libraries jQuery and jQuery Mobile. (obsolete)';
comment on column apex_applications.javascript_file_urls         is 'Allows definition of JavaScript file URLs that will be loaded on every page in the application. (obsolete)';
comment on column apex_applications.include_legacy_javascript    is 'Specified whether the legacy JavaScript functions are included in the application. (obsolete)';




create or replace view apex_application_trans_map
as
select f.workspace                      workspace,
       f.workspace_display_name,
       m.ID                             map_id,
       m.primary_language_flow_id       primary_application_id,
       f.application_name               primary_application_name,
       m.translation_flow_id            translated_application_id,
       m.translation_flow_language_code translated_app_language,
       m.translation_image_directory    translated_appl_img_dir,
       m.translation_comments           translation_comments,
       m.direction_right_to_left        direction_right_to_left,
       m.map_comments                   translation_map_comments,
       m.last_updated_by,
       m.last_updated_on,
       m.created_by,
       m.created_on
  from wwv_flow_authorized f,
       wwv_flow_language_map m
 where m.primary_language_flow_id = f.application_id
/
comment on table  apex_application_trans_map                           is 'Application Groups defined per workspace.  Applications can be associated with an application group.';
comment on column apex_application_trans_map.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_trans_map.workspace_display_name    is 'Display name for the workspace';
comment on column apex_application_trans_map.map_id                    is 'Unique ID that identifies this translation mapping';
comment on column apex_application_trans_map.primary_application_id    is 'Unique ID of the application that is the target of the translation';
comment on column apex_application_trans_map.primary_application_name  is 'Name of the application that is the target of the translation';
comment on column apex_application_trans_map.translated_application_id is 'Unique ID of the translated application';
comment on column apex_application_trans_map.translated_app_language   is 'Language code, for example "fr" or "pt-br"';
comment on column apex_application_trans_map.translated_appl_img_dir   is 'Optional directory of translated images';
comment on column apex_application_trans_map.translation_comments      is 'Comments associated with this translation';
comment on column apex_application_trans_map.direction_right_to_left   is 'Indicates whether page is rendered left to right or right to left ';
comment on column apex_application_trans_map.translation_map_comments  is 'Comments associated with this mapping';
comment on column apex_application_trans_map.LAST_UPDATED_BY           is 'Last user to update this translation mapping';
comment on column apex_application_trans_map.LAST_UPDATED_ON           is 'Date of last update to this translation mapping';
comment on column apex_application_trans_map.CREATED_BY                is 'User that created this translation mapping';
comment on column apex_application_trans_map.CREATED_ON                is 'Date this translation mapping was created';







create or replace view apex_application_groups as
select
    w.workspace,
    w.workspace_display_name,
    g.ID                         application_group_id,
    g.group_name                 group_name,
    g.group_comment              group_comment,
    w.workspace_id
from
     wwv_flow_application_groups g,
     wwv_flow_current_workspaces w
where w.workspace_id = g.security_group_id
/

comment on table  apex_application_groups                        is 'Application Groups defined per workspace.  Applications can be associated with an application group.';
comment on column apex_application_groups.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_groups.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_groups.application_group_id   is 'Unique ID that identifies this application group';
comment on column apex_application_groups.group_name             is 'Identifies the application group';
comment on column apex_application_groups.group_comment          is 'Identifies comments for a given application group';
comment on column apex_application_groups.application_group_id   is 'Identifies the ID of the application group this application is associated with';




create or replace view apex_application_substitutions as
with substitution as (
    select auth.workspace,
           auth.workspace_display_name,
           f.id                     as application_id,
           f.name                   as application_name,
           f.substitution_string_01,
           f.substitution_value_01,
           f.substitution_string_02,
           f.substitution_value_02,
           f.substitution_string_03,
           f.substitution_value_03,
           f.substitution_string_04,
           f.substitution_value_04,
           f.substitution_string_05,
           f.substitution_value_05,
           f.substitution_string_06,
           f.substitution_value_06,
           f.substitution_string_07,
           f.substitution_value_07,
           f.substitution_string_08,
           f.substitution_value_08,
           f.substitution_string_09,
           f.substitution_value_09,
           f.substitution_string_10,
           f.substitution_value_10,
           f.substitution_string_11,
           f.substitution_value_11,
           f.substitution_string_12,
           f.substitution_value_12,
           f.substitution_string_13,
           f.substitution_value_13,
           f.substitution_string_14,
           f.substitution_value_14,
           f.substitution_string_15,
           f.substitution_value_15,
           f.substitution_string_16,
           f.substitution_value_16,
           f.substitution_string_17,
           f.substitution_value_17,
           f.substitution_string_18,
           f.substitution_value_18,
           f.substitution_string_19,
           f.substitution_value_19,
           f.substitution_string_20,
           f.substitution_value_20
      from wwv_flow_authorized auth,
           wwv_flows f
     where f.id = auth.application_id )
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_01 as substitution_string,
       substitution_value_01  as substitution_value
  from substitution
 where substitution_string_01 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_02 as substitution_string,
       substitution_value_02  as substitution_value
  from substitution
 where substitution_string_02 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_03 as substitution_string,
       substitution_value_03  as substitution_value
  from substitution
 where substitution_string_03 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_04 as substitution_string,
       substitution_value_04  as substitution_value
  from substitution
 where substitution_string_04 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_05 as substitution_string,
       substitution_value_05  as substitution_value
  from substitution
 where substitution_string_05 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_06 as substitution_string,
       substitution_value_06  as substitution_value
  from substitution
 where substitution_string_06 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_07 as substitution_string,
       substitution_value_07  as substitution_value
  from substitution
 where substitution_string_07 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_08 as substitution_string,
       substitution_value_08  as substitution_value
  from substitution
 where substitution_string_08 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_09 as substitution_string,
       substitution_value_09  as substitution_value
  from substitution
 where substitution_string_09 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_10 as substitution_string,
       substitution_value_10  as substitution_value
  from substitution
 where substitution_string_10 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_11 as substitution_string,
       substitution_value_11  as substitution_value
  from substitution
 where substitution_string_11 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_12 as substitution_string,
       substitution_value_12  as substitution_value
  from substitution
 where substitution_string_12 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_13 as substitution_string,
       substitution_value_13  as substitution_value
  from substitution
 where substitution_string_13 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_14 as substitution_string,
       substitution_value_14  as substitution_value
  from substitution
 where substitution_string_14 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_15 as substitution_string,
       substitution_value_15  as substitution_value
  from substitution
 where substitution_string_15 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_16 as substitution_string,
       substitution_value_16  as substitution_value
  from substitution
 where substitution_string_16 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_17 as substitution_string,
       substitution_value_17  as substitution_value
  from substitution
 where substitution_string_17 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_18 as substitution_string,
       substitution_value_18  as substitution_value
  from substitution
 where substitution_string_18 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_19 as substitution_string,
       substitution_value_19  as substitution_value
  from substitution
 where substitution_string_19 is not null
union all
select workspace,
       workspace_display_name,
       application_id,
       application_name,
       substitution_string_20 as substitution_string,
       substitution_value_20  as substitution_value
  from substitution
 where substitution_string_20 is not null
;

comment on table  apex_application_substitutions                     is 'Application level definitions of substitution strings.';
comment on column apex_application_substitutions.workspace           is 'A work area mapped to one or more database schemas';
comment on column apex_application_substitutions.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_substitutions.application_id      is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_substitutions.application_name    is 'Identifies the application';
comment on column apex_application_substitutions.substitution_string is 'Name of substitution string';
comment on column apex_application_substitutions.substitution_value  is 'Value of substitution string';


prompt ...apex_application_caching
create or replace view apex_application_caching as
select
    a.workspace,
    a.workspace_display_name,
    a.application_id,
    a.application_name,
    c.page_id                                           page_id,
    (select name
     from wwv_flow_steps s
     where s.security_group_id = c.security_group_id
       and s.flow_id           = c.flow_id
       and s.id                = c.page_id)             page_name,
    case
    when c.region_id is null then 'Page Cache'
    when p.plug_source_type like 'NATIVE%CHART%' then 'Chart Region Cache'
    else 'Region Cache'
    end                                                 cache_type,
    c.language                                          language,
    c.user_name                                         caching_user,
    sys.dbms_lob.getlength(c.page_text)                 cache_size,
    p.plug_name                                         region_name,
    c.cached_on                                         cached_on,
    case
    when c.region_id is null then ( select cache_timeout_seconds
                                      from wwv_flow_steps s
                                     where s.security_group_id = c.security_group_id
                                       and s.flow_id           = c.flow_id
                                       and s.id                = c.page_id )
    else p.plug_caching_max_age_in_sec
    end                                                 cached_for_seconds,
    --
    round((sysdate - c.cached_on) * 3600 * 24,0)        age_in_seconds,
    --
    case
    when c.region_id is null then ( select cache_timeout_seconds
                                      from wwv_flow_steps s
                                     where s.security_group_id = c.security_group_id
                                       and s.flow_id           = c.flow_id
                                       and s.id                = c.page_id )
    else p.plug_caching_max_age_in_sec
    end - round((sysdate - c.cached_on) * 3600 * 24, 0) timeout_in_seconds,
    c.REGION_ID                                         region_id,
    c.SECURITY_GROUP_ID                                 workspace_id
from
     wwv_flow_page_cache c,
     wwv_flow_page_plugs p,
     wwv_flow_authorized a
where c.flow_id           = a.application_id
  and c.security_group_id = a.workspace_id
  and c.flow_id           = p.flow_id(+)
  and c.region_id         = p.id(+)
  and c.security_group_id = p.security_group_id(+)
/

comment on table  apex_application_caching                     is 'Applications defined in the current workspace or database user.';
comment on column apex_application_caching.workspace           is 'A work area mapped to one or more database schemas';
comment on column apex_application_caching.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_caching.application_id      is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_caching.application_name    is 'Identifies the application';
comment on column apex_application_caching.page_name           is 'Identifies page name';
comment on column apex_application_caching.page_id             is 'Identifies page number';
comment on column apex_application_caching.cache_type          is 'Cache type, Page, Region, or Chart Region';
comment on column apex_application_caching.language            is 'Language of Cache';
comment on column apex_application_caching.caching_user        is 'User who caused the page or region to be cached';
comment on column apex_application_caching.cache_size          is 'Size of the cache, sum this column to see full cache size';
comment on column apex_application_caching.region_name         is 'Identifies region name, null for page caches';
comment on column apex_application_caching.cached_on           is 'Date cache was created';
comment on column apex_application_caching.cached_for_seconds  is 'Iimeout in seconds identified in page or region caching meta data';
comment on column apex_application_caching.age_in_seconds      is 'Seconds elapsed since cache was created';
comment on column apex_application_caching.timeout_in_seconds  is 'Seconds until cache will expire.  Negitive values indicate an expired cache';
comment on column apex_application_caching.region_id           is 'Corresponding primary key of region';
comment on column apex_application_caching.workspace_id        is 'Corresponding primary key of workspace';


create or replace view apex_standard_conditions
as
          select 'EXISTS' d,'Exists (SQL query returns at least one row)'r from sys.dual
union all select 'NOT_EXISTS' d,'NOT Exists (SQL query returns no rows)'r from sys.dual
union all select 'SQL_EXPRESSION' d,'SQL Expression'r from sys.dual
union all select 'PLSQL_EXPRESSION' d,'PL/SQL Expression'r from sys.dual
union all select 'FUNCTION_BODY' d,'PL/SQL Function Body Returning a Boolean'r from sys.dual
union all select 'REQUEST_EQUALS_CONDITION' d,'Request = Expression 1'r from sys.dual
union all select 'REQUEST_NOT_EQUAL_CONDITION' d,'Request != Expression 1'r from sys.dual
union all select 'REQUEST_IN_CONDITION' d,'Request Is Contained within Expression 1'r from sys.dual
union all select 'REQUEST_NOT_IN_CONDITION' d,'Request Is NOT Contained within Expression 1'r from sys.dual
union all select 'VAL_OF_ITEM_IN_COND_EQ_COND2' d,'Value of Item in Expression 1 = Expression 2'r from sys.dual
union all select 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2' d,'Value of Item in Expression 1 != Expression 2'r from sys.dual
union all select 'ITEM_IS_NULL' d,'Value of Item / Column in Expression 1 Is NULL'r from sys.dual
union all select 'ITEM_IS_NOT_NULL' d,'Value of Item / Column in Expression 1 Is NOT NULL'r from sys.dual
union all select 'ITEM_IS_ZERO' d,'Value of Item / Column in Expression 1 = Zero'r from sys.dual
union all select 'ITEM_IS_NOT_ZERO' d,'Value of Item / Column in Expression 1 != Zero'r from sys.dual
union all select 'ITEM_IS_NULL_OR_ZERO' d,'Value of Item / Column in Expression 1 Is NULL or Zero'r from sys.dual
union all select 'ITEM_NOT_NULL_OR_ZERO' d,'Value of Item / Column in Expression 1 Is NOT null and the Item / Column Is NOT Zero'r from sys.dual
union all select 'ITEM_CONTAINS_NO_SPACES' d,'Value of Item / Column in Expression 1 Contains No Spaces'r from sys.dual
union all select 'ITEM_IS_NUMERIC' d,'Value of Item / Column in Expression 1 Is Numeric' r from sys.dual
union all select 'ITEM_IS_NOT_NUMERIC' d,'Value of Item / Column in Expression 1 Is Not Numeric' r from sys.dual
union all select 'ITEM_IS_ALPHANUMERIC' d,'Value of Item / Column in Expression 1 Is Alphanumeric'r from sys.dual
union all select 'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST' d,'Value of Item / Column in Expression 1 Is Contained within Colon Delimited List in Expression 2'r from sys.dual
union all select 'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST' d,'Value of Item / Column in Expression 1 Is NOT Contained within Colon Delimited List in Expression 2'r from sys.dual
union all select 'USER_PREF_IN_COND_EQ_COND2' d,'Value of User Preference in Expression 1 = Expression 2'r from sys.dual
union all select 'USER_PREF_IN_COND_NOT_EQ_COND2' d,'Value of User Preference in Expression 1 != Expression 2'r from sys.dual
union all select 'CURRENT_PAGE_EQUALS_CONDITION' d,'Current page = Expression 1'r from sys.dual
union all select 'CURRENT_PAGE_NOT_EQUAL_CONDITION' d,'Current page != Expression 1'r from sys.dual
union all select 'CURRENT_PAGE_IN_CONDITION' d,'Current Page Is Contained Within Expression 1 (comma delimited list of pages)'r from sys.dual
union all select 'CURRENT_PAGE_NOT_IN_CONDITION' d,'Current Page Is NOT in Expression 1 (comma delimited list of pages)'r from sys.dual
union all select 'WHEN_THIS_PAGE_SUBMITTED' d,'Current Page = Page Submitted (this page was posted)'r from sys.dual
union all select 'WHEN_THIS_PAGE_NOT_SUBMITTED' d,'Current Page != Page Submitted (this page was not the page posted)'r from sys.dual
union all select 'PAGE_IS_IN_PRINTER_FRIENDLY_MODE' d,'Current Page Is in Printer Friendly Mode'r from sys.dual
union all select 'PAGE_IS_NOT_IN_PRINTER_FRIENDLY_MODE' d,'Current page is NOT in Printer Friendly Mode'r from sys.dual
union all select 'CONDITION1_IN_VALUE_OF_ITEM_IN_CONDITION2' d,'Text in Expression 1 Is Contained in Value of Item in Expression 2'r from sys.dual
union all select 'DISPLAY_COND_IN_COND_TEXT' d,'Text in Expression 1 Is Contained within the Text in Expression 2'r from sys.dual
union all select 'DISPLAY_COND_NOT_IN_COND_TEXT' d,'Text in Expression 1 Is NOT Contained within the Text in Expression 2'r from sys.dual
union all select 'DISPLAY_COND_EQUAL_COND_TEXT' d,'Text in Expression 1 = Expression 2 (includes &ITEM. substitutions)'r from sys.dual
union all select 'DISP_COND_NOT_EQUAL_COND_TEXT' d,'Text in Expression 1 != Expression 2 (includes &ITEM. substitutions)'r from sys.dual
union all select 'IS_READ_ONLY' d,'Page/Region is Read Only' r from sys.dual
union all select 'IS_NOT_READ_ONLY' d,'Page/Region is NOT Read Only' r from sys.dual
union all select 'USER_IS_NOT_PUBLIC_USER' d,'User is Authenticated  (not public)'r from sys.dual
union all select 'USER_IS_PUBLIC_USER' d,'User is the Public User (user has not authenticated)'r from sys.dual
union all select 'DISPLAYING_INLINE_VALIDATION_ERRORS' d,'Inline Validation Errors Displayed'r from sys.dual
union all select 'NOT_DISPLAYING_INLINE_VALIDATION_ERRORS' d,'No Inline Validation Errors Displayed'r from sys.dual
union all select 'MAX_ROWS_LT_ROWS_FETCHED' d,'SQL Reports (OK to show the forward button)'r from sys.dual
union all select 'MIN_ROW_GT_THAN_ONE' d,'SQL Reports (OK to show the back button)'r from sys.dual
union all select 'BROWSER_IS_NSCP' d,'Client Browser: Mozilla, Netscape 6.x/7x or higher'r from sys.dual
union all select 'BROWSER_IS_MSIE' d,'Client Browser: Microsoft Internet Explorer 5.5, 6.0 or higher'r from sys.dual
union all select 'BROWSER_IS_MSIE_OR_NSCP' d,'Client Browser: XHTML / CSS capable browser (NS 6.x,7x, Mozilla, IE 5.5, 6.0 or higher)'r from sys.dual
union all select 'BROWSER_IS_OTHER' d,'Client Browser: Other browsers (or older version)'r from sys.dual
union all select 'CURRENT_LANG_IN_COND1' d,'Current Language Is Contained within Expression 1'r from sys.dual
union all select 'CURRENT_LANG_NOT_IN_COND1' d,'Current Language Is NOT Contained within Expression 1'r from sys.dual
union all select 'CURRENT_LANG_NOT_EQ_COND1' d,'Current Language != Expression 1'r from sys.dual
union all select 'CURRENT_LANG_EQ_COND1' d,'Current Language = Expression 1'r from sys.dual
union all select 'DAD_NAME_EQ_CONDITION' d,'When CGI_ENV DAD_NAME = Expression 1'r from sys.dual
union all select 'DAD_NAME_NOT_EQ_CONDITION' d,'When CGI_ENV DAD_NAME != Expression 1'r from sys.dual
union all select 'SERVER_NAME_EQ_CONDITION' d,'When CGI_ENV SERVER_NAME = Expression 1'r from sys.dual
union all select 'SERVER_NAME_NOT_EQ_CONDITION' d,'When CGI_ENV SERVER_NAME != Expression 1'r from sys.dual
union all select 'HTTP_HOST_EQ_CONDITION' d,'When CGI_ENV HTTP_HOST = Expression 1'r from sys.dual
union all select 'HTTP_HOST_NOT_EQ_CONDITION' d,'When CGI_ENV HTTP_HOST != Expression 1'r from sys.dual
union all select 'NEVER' d,'Never'r from sys.dual
union all select 'ALWAYS' d,'Always'r from sys.dual ;

comment on table apex_standard_conditions is 'Internal condition names and their descriptions';

prompt ...apex_appl_user_interfaces

create or replace view apex_appl_user_interfaces
as
select ui.id                     as user_interface_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       ui.ui_type_id,
       uit.name                  as ui_type_name,
       ui.display_name,
       ui.display_seq,
       case ui.use_auto_detect
         when 'Y' then 'Yes'
         else 'No'
       end as use_auto_detect,
       case ui.is_default
         when 'Y' then 'Yes'
         else 'No'
       end as is_default,
       case ui.theme_style_by_user_pref
         when 'Y' then 'Yes'
         else 'No'
       end                       as theme_style_by_user_pref,
       case ui.built_with_love
         when 'Y' then 'Yes'
         else 'No'
       end                       as built_with_love,
       ui.theme_id               as theme_number,
       ui.home_url,
       ui.login_url,
       ui.global_page_id,
       (select name from wwv_flow_lists where id = ui.navigation_list_id) as navigation_list,
       ui.navigation_list_id,
       ui.navigation_list_position,
       (select list_template_name from wwv_flow_list_templates where id = ui.navigation_list_template_id) navigation_list_template,
       ui.navigation_list_template_id,
       ui.nav_list_template_options,
       --
       ui.nav_bar_type,
       (select name from wwv_flow_lists where id = ui.nav_bar_list_id) as nav_bar_list,
       ui.nav_bar_list_id,
       (select list_template_name from wwv_flow_list_templates where id = ui.nav_bar_list_template_id) nav_bar_list_template,
       ui.nav_bar_list_template_id,
       ui.nav_bar_template_options,
       --
       ui.content_delivery_network,
       ui.javascript_file_urls,
       ui.css_file_urls,
       case
         when ui.include_legacy_javascript is not null then 'Yes'
         else 'No'
       end                       as include_legacy_javascript,
       case ui.include_jquery_migrate
         when 'Y' then 'Yes'
         else 'No'
       end                       as include_jquery_migrate,
       ui.required_patch         as build_option_id,
       ( select case
                  when ui.required_patch > 0 then patch_name
                  else '{Not ' || patch_name || '}'
                end
           from wwv_flow_patches
          where id = abs(ui.required_patch)
       )                         as build_option,
       ui.created_by,
       ui.created_on,
       ui.last_updated_by,
       ui.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_user_interfaces ui,
       wwv_flow_ui_types uit
 where ui.flow_id = f.application_id
   and uit.id     = ui.ui_type_id
/

comment on table apex_appl_user_interfaces                              is 'User interfaces of an application';
comment on column apex_appl_user_interfaces.content_delivery_network    is 'Specifies the Content Delivery Network which is used to load the 3rd party libraries jQuery and jQuery Mobile.';
comment on column apex_appl_user_interfaces.javascript_file_urls        is 'Allows definition of JavaScript file URLs that will be loaded on every page in the application.';
comment on column apex_appl_user_interfaces.include_legacy_javascript   is 'Specified whether the legacy JavaScript functions are included in the application.';
comment on column apex_appl_user_interfaces.include_jquery_migrate      is 'Specified whether the jQuery Migrate plug-in is included in the application.';
comment on column apex_appl_user_interfaces.navigation_list_position    is 'Default position used for navigation menu lists';
comment on column apex_appl_user_interfaces.navigation_list_template    is 'Template used for navigation mune lists';
comment on column apex_appl_user_interfaces.navigation_list_template_id is 'Template used for navigation menu lists';
comment on column apex_appl_user_interfaces.nav_list_template_options   is 'Template options used for navigation menu lists';
comment on column apex_appl_user_interfaces.nav_bar_type                is 'Default display type used for navigation bar entries';
comment on column apex_appl_user_interfaces.nav_bar_list                is 'Identifies navigation bar list';
comment on column apex_appl_user_interfaces.nav_bar_list_id             is 'List used for navigation bar entries rendered as a traditional list';
comment on column apex_appl_user_interfaces.nav_bar_list_template       is 'Identifies navigation bar list template';
comment on column apex_appl_user_interfaces.nav_bar_list_template_id    is 'List template used for navigation bar entries rendered as a traditional list';
comment on column apex_appl_user_interfaces.nav_bar_template_options    is 'Template options used for navigation menu lists';
comment on column apex_appl_user_interfaces.css_file_urls               is 'Allows definition of CSS file URLs that will be loaded on every page in the application.';
comment on column apex_appl_user_interfaces.theme_style_by_user_pref    is 'Identifies whether end users can change session theme styles with a customization dialog';
comment on column apex_appl_user_interfaces.built_with_love             is 'Identifies if Build with Love using Oracle APEX gets displayed in the footer.';


prompt ...apex_appl_concatenated_files

create or replace view apex_appl_concatenated_files
as
select cf.id                     as concatenated_file_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       cf.user_interface_id,
       cf.page_id,
       cf.combined_file_url,
       cf.single_file_urls,
       cf.required_patch         as build_option_id,
       ( select case
                  when cf.required_patch > 0 then patch_name
                  else '{Not ' || patch_name || '}'
                end
           from wwv_flow_patches
          where id = abs(cf.required_patch)
       )                         as build_option,
       cf.created_by,
       cf.created_on,
       cf.last_updated_by,
       cf.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_combined_files cf
 where cf.flow_id = f.application_id
/

comment on table apex_appl_concatenated_files is 'Concatenated files of a user interface';
comment on column apex_appl_concatenated_files.concatenated_file_id   is 'Identifies the primary key of this concatenated file';
comment on column apex_appl_concatenated_files.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_appl_concatenated_files.workspace_display_name is 'Display name for the workspace';
comment on column apex_appl_concatenated_files.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_concatenated_files.application_name       is 'Identifies the application';
comment on column apex_appl_concatenated_files.user_interface_id      is 'Identifies the user interface';
comment on column apex_appl_concatenated_files.page_id                is 'Concatenated file is only used for specified page id';
comment on column apex_appl_concatenated_files.combined_file_url      is 'File URL of the concatenated file to be loaded, instead of multiple single JavaScript or CSS files.';
comment on column apex_appl_concatenated_files.single_file_urls       is 'Multiple file URLs for which a concatenated file should be loaded instead.';
comment on column apex_appl_concatenated_files.build_option           is 'Concatenated file will be used if the build option is enabled';
comment on column apex_appl_concatenated_files.created_by             is 'APEX developer who created the concatenated file';
comment on column apex_appl_concatenated_files.created_on             is 'Date of creation';
comment on column apex_appl_concatenated_files.last_updated_by        is 'APEX developer who made last update';
comment on column apex_appl_concatenated_files.last_updated_on        is 'Date of last update';



create or replace view apex_application_static_files
as
select a.id                     as application_file_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       a.file_name,
       a.mime_type,
       a.file_charset,
       a.file_content,
       a.created_by,
       a.created_on,
       a.last_updated_by,
       a.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_static_files a
 where a.flow_id = f.application_id
/


comment on table apex_application_static_files is
    'Stores the files like CSS, images, javascript files, ... of an application.';
-- Add comments to the columns
comment on column apex_application_static_files.application_file_id is
    'Identifies the primary key of this file';
comment on column apex_application_static_files.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_application_static_files.workspace_display_name is
    'Display name for the workspace';
comment on column apex_application_static_files.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_application_static_files.application_name is
    'Identifies the application';
comment on column apex_application_static_files.file_name is
    'Name of the file.';
comment on column apex_application_static_files.mime_type is
    'Mime type of the file.';
comment on column apex_application_static_files.file_charset is
    'IANA charset used for text files.';
comment on column apex_application_static_files.file_content is
    'Blob content of the file.';
comment on column apex_application_static_files.created_by is
    'APEX developer who created the file';
comment on column apex_application_static_files.created_on is
    'Date of creation';
comment on column apex_application_static_files.last_updated_by is
    'APEX developer who made last update';
comment on column apex_application_static_files.last_updated_on is
    'Date of last update';


prompt ...apex_appl_developer_comments

create or replace view apex_appl_developer_comments
as
select c.id                     as comment_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       c.pages,
       c.app_comment as developer_comment,
       c.created_by,
       c.created_on,
       c.updated_by as last_updated_by,
       c.updated_on as last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_app_comments c
 where c.flow_id = f.application_id
/

comment on table apex_appl_developer_comments is 'Developer comments of an application';
comment on column apex_appl_developer_comments.comment_id             is 'Identifies the primary key of this developer comment';
comment on column apex_appl_developer_comments.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_appl_developer_comments.workspace_display_name is 'Display name for the workspace';
comment on column apex_appl_developer_comments.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_developer_comments.application_name       is 'Identifies the application';
comment on column apex_appl_developer_comments.pages                  is 'Relevant Page(s) for this developer comment';
comment on column apex_appl_developer_comments.developer_comment      is 'Developer comment';
comment on column apex_appl_developer_comments.created_by             is 'APEX developer who created the developer comment';
comment on column apex_appl_developer_comments.created_on             is 'Date of creation';
comment on column apex_appl_developer_comments.last_updated_by        is 'APEX developer who made last update';
comment on column apex_appl_developer_comments.last_updated_on        is 'Date of last update';




prompt ...apex_application_locked_pages

create or replace view apex_application_locked_pages
as
select l.id                     as lock_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       p.id   as page_id,
       p.name as page_name,
       l.lock_comment,
       l.locked_by,
       l.locked_on
  from wwv_flow_authorized f,
       wwv_flow_lock_page l,
       wwv_flow_steps p
 where l.flow_id           = f.application_id
   and l.security_group_id = f.workspace_id
   and p.id                = l.object_id
   and p.flow_id           = l.flow_id
   and p.security_group_id = l.security_group_id
/

comment on table apex_application_locked_pages is 'Locked pages of an application';
comment on column apex_application_locked_pages.lock_id                is 'Identifies the primary key of this page lock';
comment on column apex_application_locked_pages.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_locked_pages.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_locked_pages.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_locked_pages.application_name       is 'Identifies the application';
comment on column apex_application_locked_pages.page_id                is 'Page id which is locked';
comment on column apex_application_locked_pages.page_name              is 'Identifies the page';
comment on column apex_application_locked_pages.lock_comment           is 'Lock comment';
comment on column apex_application_locked_pages.locked_by              is 'APEX developer who locked the page';
comment on column apex_application_locked_pages.locked_on              is 'Date of lock';


--------------------------------------------
-- A P P L I C A T I O N   P A G E S
-- 4301

prompt ...apex_application_pages

create or replace view apex_application_pages
as
select
    f.workspace,
    f.workspace_display_name,
    p.flow_id                             application_id,
    f.application_name,
    --
    p.id                                  page_id,
    p.name                                page_name,
    p.STEP_TITLE                          page_title,
    --
    decode(nvl(p.page_mode,'NORMAL'),
       'NORMAL','Normal',
       'MODAL','Modal Dialog',
       'NON_MODAL','Non-Modal Dialog')            page_mode,
    --
    p.user_interface_id,
    p.media_type                          media_type,
    p.TAB_SET                             tab_set,
    p.ALIAS                               page_alias,
    decode(substr(p.PAGE_COMPONENT_MAP,1,2),
         '01','Tabular Form',
         '02','Form',
         '03','Report',
         '04','Chart',
         '05','Web Service',
         '06','Navigation Page',
         '07','Tree',
         '08','Calendar',
         '09','URL',
         '10','Dynamic HTML',
         '11','Static HTML',
         '12','Login',
         '13','Home',
         '14','Global Page',
         '15','Empty Page',
         '16','Dynamic Form',
         '17','Wizard Form',
         'Unknown')                       page_function,
    decode(
      p.ALLOW_DUPLICATE_SUBMISSIONS,
      'N','No','Y','Yes',null,'Yes',
      p.ALLOW_DUPLICATE_SUBMISSIONS)      allow_duplicate_submissions,
    --
    decode(INCLUDE_APEX_CSS_JS_YN,null,'Yes','Y','Yes','N','No','Unknown') INCLUDE_APEX_CSS_JS_YN,
    --
    decode(p.FIRST_ITEM,
      'AUTO_FIRST_ITEM','First Item on Page',
      'NO_FIRST_ITEM','Do not focus cursor',
      p.FIRST_ITEM)                       focus_cursor,
    p.WELCOME_TEXT                        Header_Text,
    p.BOX_WELCOME_TEXT                    Body_Header,
    --p.BOX_FOOTER_TEXT                     Body_footer,
    p.FOOTER_TEXT                         Footer_Text,
    p.HELP_TEXT                           help_text,
    (select name
     from wwv_flow_templates
     where id = p.STEP_TEMPLATE)          page_template,
    p.page_css_classes                    page_css_classes,
    p.page_template_options               page_template_options,
     --
    decode(substr(p.REQUIRED_ROLE,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(p.REQUIRED_ROLE,'!')
     and    flow_id = f.application_id),
     p.REQUIRED_ROLE)                     authorization_scheme,
    p.required_role                       authorization_scheme_id,
     --
    (select case when p.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(p.REQUIRED_PATCH))         build_option,
    p.HTML_PAGE_HEADER                    page_html_header,
    p.HTML_PAGE_ONLOAD                    page_html_onload,
    p.javascript_file_urls,
    p.javascript_code,
    p.javascript_code_onload,
    p.css_file_urls,
    p.inline_css,
    --sec
    decode(p.PAGE_IS_PUBLIC_Y_N,
      'N','Yes','Y','No','Yes')            page_requires_Authentication,
    decode(nvl(p.PROTECTION_LEVEL,'N'),
       'N','Unrestricted',
       'C','Arguments Must Have Checksum',
       'U','No Arguments Allowed',
       'D','No URL Access',
       p.PROTECTION_LEVEL )               page_access_protection,
    --
    p.dialog_title                        dialog_title,
    p.dialog_height                       dialog_height,
    p.dialog_width                        dialog_width,
    p.dialog_max_width                    dialog_max_width,
    p.dialog_attributes                   dialog_attributes,
    p.dialog_css_classes                  dialog_css_classes,
    p.dialog_chained                      dialog_chained,
    --
    p.overwrite_navigation_list           overwrite_navigation_list,
    (select name from wwv_flow_lists where id = p.navigation_list_id)                                   navigation_list,
    p.navigation_list_id,
    (select list_template_name from wwv_flow_list_templates where id = p.navigation_list_template_id)   navigation_list_template,
    p.navigation_list_template_id,
    p.nav_list_template_options,
    p.navigation_list_position,
    --
    (select count(*) from wwv_flow_page_plugs where flow_id = f.application_id and page_id = p.id) regions,
    (select count(*) from wwv_flow_step_items ii where flow_id = f.application_id and flow_step_id = p.id) items,
    (select count(*) from wwv_flow_step_buttons where flow_id = f.application_id and flow_step_id = p.id) buttons,
    (select count(*) from wwv_flow_step_computations where flow_id = f.application_id and flow_step_id = p.id) computations,
    (select count(*) from wwv_flow_step_validations where flow_id = f.application_id and flow_step_id = p.id) validations,
    (select count(*) from wwv_flow_step_processing where flow_id = f.application_id and flow_step_id = p.id) processes,
    (select count(*) from wwv_flow_step_branches where flow_id = f.application_id and flow_step_id = p.id) branches,
    (select count(*) from wwv_flow_region_report_column where flow_id = f.application_id and region_id in (select id from wwv_flow_page_plugs where flow_id = f.application_id and page_id = p.id)) report_columns,
    --
    (select     GROUP_NAME
     from     wwv_flow_page_groups
     where    id = p.group_id and
              flow_id = p.flow_id)        page_group,
    p.group_id                            page_group_id,
    --
    ON_DUP_SUBMISSION_GOTO_URL            ,
    p.error_handling_function,
    ERROR_NOTIFICATION_TEXT               ,
    decode(autocomplete_on_off,null,'On','ON','On','OFF','Off') form_autocomplete,
    p.page_transition,
    p.popup_transition,
    -- read only condition
    coalesce (
        ( select r
            from apex_standard_conditions
           where p.read_only_when_type is not null
             and d = p.read_only_when_type
        ),
        p.read_only_when_type )           read_only_condition_type,
    p.read_only_when_type                 read_only_condition_type_code,
    p.read_only_when                      read_only_condition_exp1,
    p.read_only_when2                     read_only_condition_exp2,
    --
    decode(cache_mode,
        'CACHE'   , 'Cached'            ,
        'USER'    , 'Cached by User'    ,
        'SESSION' , 'Cached by Session' ,
        'NOCACHE' , 'Not Cached'        ,
        cache_mode)                       cache_mode,
    decode(CACHE_MODE,
        'NOCACHE', 'No',
        'Yes')                            cached,
    CACHE_TIMEOUT_SECONDS                 cache_timeout_seconds,
    decode(CACHE_MODE,
        'USER', 'Yes',
        'No')                             cached_by_user,
    CACHE_WHEN_CONDITION_TYPE             cache_condition_type,
    CACHE_WHEN_CONDITION_E1               cache_condition_exp_1,
    CACHE_WHEN_CONDITION_E2               cache_condition_exp_2,
    page_comment                          page_comment,
    (select count(*) from wwv_flow_page_plugs where flow_id =  f.application_id and page_id =  p.id and PLUG_CACHING <> 'NOCACHE' ) cached_regions,
    --
    p.created_by,
    p.created_on,
    p.LAST_UPDATED_BY                     last_updated_by,
    p.LAST_UPDATED_ON                     last_updated_on,
    --
    lpad(p.id,5,'00000')
    ||p.step_title||
    ',tabset='||p.tab_set
    ||' help='||sys.dbms_lob.getlength(p.HELP_TEXT)||
    decode(p.BOX_WELCOME_TEXT,null,null,'bodyhead='||length(p.BOX_WELCOME_TEXT))||
    decode(p.ALIAS,null,null,' alias='||p.ALIAS)||
    (select name from wwv_flow_templates where id = p.STEP_TEMPLATE)||
    nvl((select name from wwv_flow_security_schemes where to_char(id) = ltrim(p.REQUIRED_ROLE,'!') and flow_id = f.application_id),
    decode(substr(p.REQUIRED_ROLE,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(p.REQUIRED_ROLE,'!')
     and    flow_id = f.application_id),
     'Not found')
    )||
    --
    (select PATCH_NAME from wwv_flow_patches where id =abs(p.REQUIRED_PATCH))||
    decode(p.FIRST_ITEM,'AUTO_FIRST_ITEM','First Item on Page','NO_FIRST_ITEM','Do not focus cursor',p.FIRST_ITEM)||
    decode(p.WELCOME_TEXT,null,null,'head='||length(p.WELCOME_TEXT))||
    decode(p.FOOTER_TEXT,null,null,',foot='||length(FOOTER_TEXT))||
    ',PgAuth='||decode(p.PAGE_IS_PUBLIC_Y_N,'N','Yes','Y','No','Yes')||
    ','||decode(nvl(p.PROTECTION_LEVEL,'N'),
       'N','Unrestricted',
       'C','Arguments Must Have Checksum',
       'U','No Arguments Allowed',
       'D','No URL Access',
       p.PROTECTION_LEVEL )||
     ',onload='||length(p.HTML_PAGE_ONLOAD)||
     ',hh='||nvl(length(p.HTML_PAGE_HEADER),0)
     component_signature,
    case p.browser_cache
      when 'Y' then 'Enabled'
      when 'N' then 'Disabled'
      else 'Application Default'
    end browser_cache,
    case p.deep_linking
      when 'Y' then 'Enabled'
      when 'N' then 'Disabled'
      else 'Application Default'
    end deep_linking,
    case nvl(p.rejoin_existing_sessions, f.rejoin_existing_sessions)
    when 'Y' then 'All Sessions'
    when 'P' then 'Public Sessions'
    when 'N' then 'Disabled'
    end rejoin_existing_sessions,
    case p.reload_on_submit
      when 'A' then 'Always'
      when 'S' then 'Only for Success'
    end                as reload_on_submit,
    p.reload_on_submit as reload_on_submit_code,
    case p.warn_on_unsaved_changes
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end as warn_on_unsaved_changes
from wwv_flow_steps      p,
     wwv_flow_authorized f
where f.workspace_id   = p.security_group_id
  and f.application_id = p.flow_id
/


comment on table apex_application_pages                               is 'A Page definition is the basic building block of page. Page components including regions, items, buttons, computations, branches, validations, and processes further define the definition of a page.';
comment on column apex_application_pages.workspace                    is 'A work area mapped to one or more database schemas';
comment on column apex_application_pages.workspace_display_name       is 'Display name for the workspace';
comment on column apex_application_pages.application_id               is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_pages.application_name             is 'Identifies the application';
comment on column apex_application_pages.page_id                      is 'Identifies the page.  The primary key of a page is the combination of the Application ID and the Page ID.';
comment on column apex_application_pages.page_name                    is 'Identifies a page within an application';
comment on column apex_application_pages.page_title                   is 'Used by page templates to display the HTML title tag';
comment on column apex_application_pages.page_mode                    is 'Identifies whether the page type has been defined as Normal, Modal Dialog, or Non-Modal Dialog.';
comment on column apex_application_pages.media_type                   is 'Page-level Internet media type, used in the Content-Type HTTP header';
comment on column apex_application_pages.TAB_SET                      is 'Identifies the standard Tab Set to be used for this page. A Tab Set is a collection of tabs, the current tab is a property of the tab and is identified by page ID.';

comment on column apex_application_pages.INCLUDE_APEX_CSS_JS_YN       is 'Determines if Oracle APEX will automatically include APEX standard CSS and JS in the page hearder.  Typical value is Yes';

comment on column apex_application_pages.PAGE_ALIAS                   is 'An alphanumeric identifier which can be used as a more readable identifier then the page ID.';
comment on column apex_application_pages.ALLOW_DUPLICATE_SUBMISSIONS  is 'Determines if a rendered page may be posted more then once, for example by pressing reload.  Defaults to Yes.';
comment on column apex_application_pages.focus_cursor                 is 'Specifies if APEX should automatically focus the cursor in the first field on page load';
comment on column apex_application_pages.HEADER_TEXT                  is 'Text or HTML that will appear immediately following the Page Template Header and before the Page Template Body content.';
comment on column apex_application_pages.BODY_HEADER                  is 'Text or HTML that will appear before the Page Template #BOX_BODY# substitution string';

comment on column apex_application_pages.FOOTER_TEXT                  is 'Text or HTML that will appear before the Page Template Footer and after the Page Template Body content.';
comment on column apex_application_pages.HELP_TEXT                    is 'Page help text';
comment on column apex_application_pages.PAGE_TEMPLATE                is 'Identifies the page template, if no page template is specified the application default page template will be used';
comment on column apex_application_pages.PAGE_CSS_CLASSES             is 'Identifies CSS classes to be applied to the page';
comment on column apex_application_pages.PAGE_TEMPLATE_OPTIONS        is 'Identifies template options to be applied to the page template';
comment on column apex_application_pages.AUTHORIZATION_SCHEME         is 'An authorization scheme must evaluate to TRUE in order for this page to be displayed';
comment on column apex_application_pages.AUTHORIZATION_SCHEME_ID      is 'Foreign Key';
comment on column apex_application_pages.BUILD_OPTION                 is 'Page will only be displayed if no Build Option is specified or if the Build Options is enabled';
comment on column apex_application_pages.PAGE_HTML_HEADER             is 'Identifies text that replaces the #HEAD# substitution string in the Page Template';
comment on column apex_application_pages.PAGE_HTML_ONLOAD             is 'Identifies JavaScript or text to be substituted in for the Page Template #ONLOAD# substitution string';
comment on column apex_application_pages.javascript_code              is 'Identifies Javascript code that replaces the #PAGE_JAVASCRIPT# substitution string in the Page Template';
comment on column apex_application_pages.javascript_code_onload       is 'Identifies JavaScript code which is executed after page load';
comment on column apex_application_pages.PAGE_REQUIRES_AUTHENTICATION is 'Specifies whether this page has been defined as "Public" or requires authentication';
comment on column apex_application_pages.PAGE_ACCESS_PROTECTION       is 'Identifies the Page Access Protection level which is used to restrict the setting of session state or to require checksums to pass session state';

comment on column apex_application_pages.DIALOG_TITLE                 is 'Identifies the dialog title';
comment on column apex_application_pages.DIALOG_HEIGHT                is 'Identifies the height of the dialog';
comment on column apex_application_pages.DIALOG_WIDTH                 is 'Identifies the width of the dialog';
comment on column apex_application_pages.DIALOG_MAX_WIDTH             is 'Identifies the maximum width of the dialog';
comment on column apex_application_pages.DIALOG_ATTRIBUTES            is 'Identifies custom attributes to be applied to the dialog';
comment on column apex_application_pages.DIALOG_CSS_CLASSES           is 'Identifies CSS classes to be applied to the dialog';
comment on column apex_application_pages.DIALOG_CHAINED               is 'Identifies whether the dialog page is opened by another dialog page, and should reuse the same window, or whether it should be opened in a new window';

comment on column apex_application_pages.OVERWRITE_NAVIGATION_LIST    is 'Defines whether to overwrite application level navigation menu list settings';
comment on column apex_application_pages.NAVIGATION_LIST              is 'Identifies navigation menu list';
comment on column apex_application_pages.NAVIGATION_LIST_ID           is 'Identifies navigation menu list ID';
comment on column apex_application_pages.NAVIGATION_LIST_TEMPLATE     is 'Identifies navigation menu list template';
comment on column apex_application_pages.NAVIGATION_LIST_TEMPLATE_ID  is 'Identifies navigation menu list template ID';
comment on column apex_application_pages.NAVIGATION_list_position     is 'Identifies the position of the navigation menu list (if overwritten)';
comment on column apex_application_pages.NAV_LIST_TEMPLATE_OPTIONS    is 'Identifies template options to be applied to the navigation menu list template';

comment on column apex_application_pages.REGIONS                      is 'Number of regions defined for this page';
comment on column apex_application_pages.ITEMS                        is 'Number of items defined for this page';
comment on column apex_application_pages.BUTTONS                      is 'Number of buttons defined for this page';
comment on column apex_application_pages.COMPUTATIONS                 is 'Number of computations defined for this page';
comment on column apex_application_pages.VALIDATIONS                  is 'Number of validations defined for this page';
comment on column apex_application_pages.PROCESSES                    is 'Number of processes defined for this page';
comment on column apex_application_pages.BRANCHES                     is 'Number of branches defined for this page';
comment on column apex_application_pages.report_columns               is 'Number of report columns defined for this page';
comment on column apex_application_pages.page_group                   is 'Identifies assigned page group';
comment on column apex_application_pages.page_group_id                is 'Foreign Key';
comment on column apex_application_pages.created_by                   is 'APEX developer who created the page.';
comment on column apex_application_pages.created_on                   is 'Date the page was created.';
comment on column apex_application_pages.last_updated_by              is 'APEX developer who made last update';
comment on column apex_application_pages.last_updated_on              is 'Date of last update';

comment on column apex_application_pages.component_signature          is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_pages.ON_DUP_SUBMISSION_GOTO_URL   is 'Application Express displays an error message and a link to this URL to continue with the application';
comment on column apex_application_pages.error_handling_function      is 'Function which is called if an error occurs. It can be used to modify or log the error.';
comment on column apex_application_pages.ERROR_NOTIFICATION_TEXT      is 'Enter the error message displayed when an error occurs on this page. The error message will be substituted for #NOTIFICATION_MESSAGE# in the page template.';
comment on column apex_application_pages.form_autocomplete            is 'Whether or not to enable autocomplete for forms';
comment on column apex_application_pages.read_only_condition_type     is 'Identifies the condition type when all items of the page will be rendered read only';
comment on column apex_application_pages.read_only_condition_type_code is 'Identifies the internal code of read_only_condition_type';
comment on column apex_application_pages.read_only_condition_exp1     is 'Identifies the condition that determines if all items of the page will be rendered read only';
comment on column apex_application_pages.read_only_condition_exp2     is 'Identifies the condition that determines if all items of the page will be rendered read only';
comment on column apex_application_pages.cache_mode                   is 'Identifies the caching method';
comment on column apex_application_pages.cached                       is 'Whether or not to enable page caching';
comment on column apex_application_pages.cache_timeout_seconds        is 'Amount of time for which a cached page is valid.';
comment on column apex_application_pages.cached_by_user               is 'Cached by user yes or no';
comment on column apex_application_pages.cache_condition_type         is 'If the condition returns true, the page is displayed from cache.';
comment on column apex_application_pages.cache_condition_exp_1        is 'Cache condition expression 1';
comment on column apex_application_pages.cache_condition_exp_2        is 'Cache condition expression 2';
comment on column apex_application_pages.page_comment                 is 'Page comment';
comment on column apex_application_pages.page_function                is 'Primary function of the page based using a best guess method.';
comment on column apex_application_pages.browser_cache                is 'Determines if the browser should cache pages';
comment on column apex_application_pages.deep_linking                 is 'Determines if deep linking is allowed to this page';
comment on column apex_application_pages.rejoin_existing_sessions     is 'Determines whether sessions for this application can be joined without session id in the URL';
comment on column apex_application_pages.reload_on_submit             is 'Determines when the page should be reloaded on submit.';
comment on column apex_application_pages.reload_on_submit_code        is 'Internal code of RELOAD_ON_SUBMIT';
comment on column apex_application_pages.warn_on_unsaved_changes      is 'Determines if a warning should be displayed in case of unsaved changes.';



create or replace view apex_application_page_groups
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    g.group_name                          page_group_name,
    g.group_desc                          page_group_description,
    g.id                                  group_id
from wwv_flow_page_groups g,
     wwv_flow_authorized f
where f.workspace_id   = g.security_group_id
  and f.application_id = g.flow_id
/

comment on table apex_application_page_groups                          is 'Identifies page groups';
comment on column apex_application_page_groups.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_groups.workspace_display_name  is 'Display name for the workspace';
comment on column apex_application_page_groups.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_groups.application_name        is 'Identifies the application';
comment on column apex_application_page_groups.page_group_name         is 'page group name';
comment on column apex_application_page_groups.page_group_description  is 'Page group description';
comment on column apex_application_page_groups.group_id                is 'Unique numeric identifier';

-----------------------------------------------
-- A P P L I C A T I O N   P A G E   I T E M S
-- 4311
prompt ...apex_application_page_items


create or replace view apex_application_page_items
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                            page_id,
    p.name                          page_name,
    --
    i.name                          item_name,
    case substr(i.display_as, 1, 7)
      when 'NATIVE_' then
          ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = 'ITEM TYPE' and name = substr(i.display_as, 8) )
      when 'PLUGIN_' then
          ( select display_name from wwv_flow_plugins where flow_id = p.flow_id and plugin_type = 'ITEM TYPE' and name = substr(i.display_as, 8) )
      else
          nvl((select display_name from wwv_flow_standard_item_types where name = i.display_as), i.display_as)
    end                             display_as,
    i.display_as                    display_as_code,
    decode(i.DATA_TYPE,
       'NUMBER','Numbers Only',
       'VARCHAR','Varchar',
       i.DATA_TYPE)                 item_data_type,
    case
      when i.is_required = 'Y' then 'Yes'
      else 'No'
    end                             is_required,
    case
      when i.is_query_only = 'Y' then 'Yes'
      else 'No'
    end                             is_query_only,
    case
      when i.is_primary_key = 'Y' then 'Yes'
      else 'No'
    end                             is_primary_key,
    nvl(i.standard_validations, 'Application Level Setting') standard_validations,
    --
    i.ITEM_SEQUENCE                 display_sequence,
    (select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_PLUG_ID)     region,
    i.item_plug_id                  region_id,
    (select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_SOURCE_PLUG_ID)     data_source_region,
    i.item_source_plug_id                  data_source_region_id,
    --
    case when i.item_source_plug_id is null then
        decode(
          i.USE_CACHE_BEFORE_DEFAULT,
          'NO','Always, replacing any existing value in session state',
          'YES','Only when current value in session state is null',
          i.USE_CACHE_BEFORE_DEFAULT)
         else null end   source_used,
    i.ITEM_DEFAULT                  item_default,
    i.ITEM_DEFAULT_TYPE             item_default_type,
    --
    i.PROMPT                        label,
    i.placeholder                   placeholder,
    i.PRE_ELEMENT_TEXT              pre_element_text,
    i.POST_ELEMENT_TEXT             post_element_text,
    i.FORMAT_MASK                   format_mask,
    (select template_name
     from   wwv_flow_field_templates
     where  id = to_char(i.ITEM_FIELD_TEMPLATE)
     and    flow_id = f.application_id)         item_label_template,
    i.ITEM_FIELD_TEMPLATE           item_label_template_id,
    i.item_css_classes              item_css_classes,
    i.item_icon_css_classes         item_icon_css_classes,
    i.item_template_options         item_template_options,
    i.SOURCE                        item_source,
    case when i.ITEM_SOURCE_PLUG_ID is not null
        then 'Region Source Column'
        else
            decode(i.SOURCE_TYPE,
              'ALWAYS_NULL','Always Null',
              'STATIC','Static Assignment (value equals source attribute)',
              'QUERY','SQL Query (return single value)',
              'QUERY_COLON','SQL Query (return colon separated value)',
              'ITEM','Item (application or page item name)',
              'FUNCTION','PL/SQL Expression or Function',
              'FUNCTION_BODY','PL/SQL Function Body',
              'DB_COLUMN','Database Column',
              'PREFERENCE','Preference',
              'FACET_COLUMN','Facet Column',
              i.SOURCE_TYPE)
        end                         item_source_type,
    i.source_data_type              item_source_data_type,
    decode(i.encrypt_session_state_yn,'Y','Yes','No') encrypt_session_state,
    i.SOURCE_POST_COMPUTATION       source_post_computation,
    -- read only conditionality
    nvl((select r from apex_standard_conditions where d = i.READ_ONLY_WHEN_TYPE),i.READ_ONLY_WHEN_TYPE)
                                    read_only_condition_type,
    i.read_only_when_type           read_only_condition_type_code,
    i.READ_ONLY_WHEN                read_only_condition_exp1,
    i.READ_ONLY_WHEN2               read_only_condition_exp2,
    i.READ_ONLY_DISP_ATTR           read_only_display_attr,
    --
    i.NAMED_LOV                     lov_named_lov,
    i.LOV                           lov_definition,
    decode(i.LOV_DISPLAY_EXTRA,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_EXTRA)          lov_display_extra,
    decode(i.LOV_DISPLAY_NULL,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_NULL)           lov_display_null,
    i.LOV_NULL_TEXT                 lov_null_text,
    i.LOV_NULL_VALUE                lov_null_value,
    decode(i.LOV_TRANSLATED,
      'N','No','Y','Yes',
      i.LOV_TRANSLATED)             lov_query_result_translated,
    lov_cascade_parent_items,
    ajax_items_to_submit,
    case nvl(i.ajax_optimize_refresh, 'Y')
      when 'Y' then 'Yes'
      when 'N' then 'No'
      else i.ajax_optimize_refresh
    end                             ajax_optimize_refresh,
    --
    i.csize                         item_element_width,
    i.cmaxlength                    item_element_max_length,
    i.cheight                       item_element_height,
    --
    i.cattributes                   html_table_cell_attr_label,
    i.cattributes_element           html_table_cell_attr_element, /* for backwards compatibility, replaced by grid_column_attributes */
    i.tag_css_classes               html_form_element_css_classes,
    i.tag_attributes                html_form_element_attributes,
    i.tag_attributes2               form_element_option_attributes,
    --
    i.button_image                  item_button_image,
    i.button_image_attr             item_button_image_attributes,
    --
    case i.new_grid
      when 'Y' then 'Yes'
      else 'No'
    end                             new_grid,
    case i.begin_on_new_line
      when 'Y' then 'Yes'
      else 'No'
    end                             new_grid_row,
    case i.begin_on_new_field
      when 'Y' then 'Yes'
      else 'No'
    end                             new_grid_column,
    i.grid_column                   grid_column,
    i.colspan                       grid_column_span,
    i.grid_label_column_span,
    i.grid_column_css_classes,
    i.cattributes_element           grid_column_attributes,
    --
    decode(i.BEGIN_ON_NEW_LINE,
      'N','No','Y','Yes',
      i.BEGIN_ON_NEW_LINE)          begins_on_new_row,  /* for backward compatibility */
    decode(i.BEGIN_ON_NEW_FIELD,
      'N','No','Y','Yes',
      i.BEGIN_ON_NEW_FIELD)         begins_on_new_cell, /* for backward compatibility */
    i.COLSPAN                       column_span,        /* for backward compatibility */
    --
    i.ROWSPAN                       row_span,
    --
    decode(i.LABEL_ALIGNMENT,
      'ABOVE',         'Above',
      'BELOW',         'Below',
      'CENTER',        'Center',
      'CENTER-BOTTOM', 'Bottom center',
      'CENTER-CENTER', 'Center center',
      'CENTER-TOP',    'Top center',
      'LEFT',          'Left',
      'LEFT-BOTTOM',   'Bottom left',
      'LEFT-CENTER',   'Center left',
      'LEFT-TOP',      'Top left',
      'RIGHT',         'Right',
      'RIGHT-BOTTOM',  'Bottom right',
      'RIGHT-CENTER',  'Center right',
      'RIGHT-TOP',     'Top right',
      i.LABEL_ALIGNMENT)            label_alignment,
    decode(i.FIELD_ALIGNMENT,
      'CENTER',       'Center',
      'CENTER-BOTTOM','Center bottom',
      'CENTER-CENTER','Center center',
      'CENTER-TOP',   'Center top',
      'LEFT',         'Left',
      'LEFT-BOTTOM',  'Left bottom',
      'LEFT-CENTER',  'Left center',
      'LEFT-TOP',     'Left top',
      'RIGHT',        'Right',
      'RIGHT-BOTTOM', 'Right bottom',
      'RIGHT-CENTER', 'Right center',
      'RIGHT-TOP',    'Right top',
      i.FIELD_ALIGNMENT)            item_alignment,
    inline_help_text,
    --
    --i.FIELD_TEMPLATE,
    --
    decode(i.show_quick_picks,
      'NO','No','YES','Yes',
      i.show_quick_picks)           show_quick_picks,
    i.quick_pick_link_attr,
    i.quick_pick_label_01,
    i.quick_pick_value_01,
    i.quick_pick_label_02,
    i.quick_pick_value_02,
    i.quick_pick_label_03,
    i.quick_pick_value_03,
    i.quick_pick_label_04,
    i.quick_pick_value_04,
    i.quick_pick_label_05,
    i.quick_pick_value_05,
    i.quick_pick_label_06,
    i.quick_pick_value_06,
    i.quick_pick_label_07,
    i.quick_pick_value_07,
    i.quick_pick_label_08,
    i.quick_pick_value_08,
    i.quick_pick_label_09,
    i.quick_pick_value_09,
    i.quick_pick_label_10,
    i.quick_pick_value_10,
    --
    i.plugin_init_javascript_code   init_javascript_code,
    --
    i.attribute_01,
    i.attribute_02,
    i.attribute_03,
    i.attribute_04,
    i.attribute_05,
    i.attribute_06,
    i.attribute_07,
    i.attribute_08,
    i.attribute_09,
    i.attribute_10,
    i.attribute_11,
    i.attribute_12,
    i.attribute_13,
    i.attribute_14,
    i.attribute_15,
    --
    nvl((select r from apex_standard_conditions where d = i.DISPLAY_WHEN_TYPE),i.DISPLAY_WHEN_TYPE)
                                    condition_type,
    i.display_when_type             condition_type_code,
    i.DISPLAY_WHEN                  condition_expression1,
    i.DISPLAY_WHEN2                 condition_expression2,
    --
    case
      when i.warn_on_unsaved_changes = 'I' then 'Ignore'
      else 'Page Default'
    end                             warn_on_unsaved_changes,
    i.warn_on_unsaved_changes       warn_on_unsaved_changes_code,
    --
    case i.restricted_characters
        when 'US_ONLY' then 'Whitelist for a-Z, 0-9 and space'
        when 'WEB_SAFE' then 'Blacklist HTML command characters (<>")'
        when 'NO_SPECIAL_CHAR' then 'Blacklist &<>"/;,*|=% and --'
        when 'NO_SPECIAL_CHAR_NL' then 'Blacklist &<>"/;,*|=% or -- and new line'
        when 'WORKSPACE_SCHEMA' then 'Workspace Schema'
    end as restricted_characters,
    i.restricted_characters restricted_characters_code,
    --
    decode(i.IS_PERSISTENT,
       'Y','Per Session',
       'U','Per User',
       'N','Do Not Save Session State',
       i.IS_PERSISTENT)             maintain_session_state,
    decode(nvl(i.PROTECTION_LEVEL,'N'),
       'N','Unrestricted',
       'C','Arguments Must Have Checksum',
       'U','No Arguments Allowed',
       'D','No URL Access',
       'S','Checksum Required - Session Level',
       'I','Restricted - May not be set from browser',
       'B','Checksum Required - Application Level',
       'P','Checksum Required - User Level',
       i.PROTECTION_LEVEL)          item_protection_level,
    case i.escape_on_http_output
      when 'Y' then 'Yes'
      when 'N' then 'No'
      else i.escape_on_http_output
    end                             escape_on_http_output,
    --i.ESCAPE_ON_HTTP_INPUT
    --
    decode(substr(i.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(i.SECURITY_SCHEME,'!')
     and    flow_id = f.application_id),
     i.SECURITY_SCHEME)             authorization_scheme,
    i.security_scheme               authorization_scheme_id,
    (select case when i.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))   build_option,
    i.REQUIRED_PATCH                build_option_id,
    --
    (select max(help_text) h
    from wwv_flow_step_item_help
    where FLOW_ITEM_ID = i.id)      item_help_text,
    --
    i.LAST_UPDATED_BY               last_updated_by,
    i.LAST_UPDATED_ON               last_updated_on,
    i.ITEM_COMMENT                  component_comment,
    i.id                            item_id,
    --
    i.name
    ||' da='||i.display_as
    ||decode(i.DATA_TYPE,'NUMBER','NOnly','VARCHAR','V',i.DATA_TYPE)
    ||',seq='||lpad(i.ITEM_SEQUENCE,5,'00000')
    ||',r='||(select plug_name from wwv_flow_page_plugs where id=i.ITEM_PLUG_ID)
    ||',c='||decode(i.USE_CACHE_BEFORE_DEFAULT,'NO','Always','YES','Only null',i.USE_CACHE_BEFORE_DEFAULT)
    ||',d='||substr(i.ITEM_DEFAULT,1,20)||length(i.ITEM_DEFAULT)||i.ITEM_DEFAULT_TYPE
    ||',l='||substr(i.PROMPT,1,20)||length(i.prompt)
    ||substr(i.PRE_ELEMENT_TEXT,1,10)||length(i.PRE_ELEMENT_TEXT)
    ||substr(i.POST_ELEMENT_TEXT,1,10)||length(i.POST_ELEMENT_TEXT)
    ||',m='||i.FORMAT_MASK
    ||'t='||(select template_name from   wwv_flow_field_templates where  id = to_char(i.ITEM_FIELD_TEMPLATE) and flow_id = f.application_id)
    ||'s='||substr(i.SOURCE,1,30)||length(i.source)
    ||decode(i.SOURCE_TYPE,
      'ALWAYS_NULL','Always Null',
      'STATIC','StaticAs',
      'QUERY','SQLQuery',
      'QUERY_COLON','SQLQueryColon',
      'ITEM','Item ',
      'FUNCTION','PL/SQL',
      'FUNCTION_BODY','PL/SQLFunctionBody',
      'DB_COLUMN','DBColumn',
      'PREFERENCE','Pref',
      i.SOURCE_TYPE)
    ||length(i.SOURCE_POST_COMPUTATION)
    ||' ro='||nvl((select r from apex_standard_conditions where d = i.READ_ONLY_WHEN_TYPE),i.READ_ONLY_WHEN_TYPE)
    ||length(i.READ_ONLY_WHEN)
    ||length(i.READ_ONLY_WHEN2)
    ||length(i.READ_ONLY_DISP_ATTR)
    ||',lov='||i.NAMED_LOV
    ||decode(i.named_lov,null,null,length(i.LOV))
    ||decode(i.LOV_DISPLAY_EXTRA,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_EXTRA)
    ||decode(i.LOV_DISPLAY_NULL,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_NULL)
    ||substr(LOV_NULL_TEXT,1,20)||length(LOV_NULL_TEXT)
    ||i.LOV_NULL_VALUE
    ||',t='||decode(i.LOV_TRANSLATED,'N','No','Y','Yes',i.LOV_TRANSLATED)
    ||',s='||i.csize||i.cmaxlength||i.cheight
    ||',a='||substr(i.cattributes,1,10)||length(i.cattributes)
    ||length(i.cattributes_element)
    ||length(i.tag_attributes)
    ||length(i.tag_attributes2)
    ||',b='||length(i.button_image)||length(i.button_image_attr)
    ||',disp='||decode(i.BEGIN_ON_NEW_LINE,
      'N','No','Y','Yes',
      i.BEGIN_ON_NEW_LINE)||decode(i.BEGIN_ON_NEW_FIELD,
      'N','No','Y','Yes',
      i.BEGIN_ON_NEW_FIELD)||i.COLSPAN||i.ROWSPAN
    ||' l='||decode(i.LABEL_ALIGNMENT,
      'ABOVE',         'Above',
      'BELOW',         'Below',
      'CENTER',        'Center',
      'CENTER-BOTTOM', 'Bottom center',
      'CENTER-CENTER', 'Center center',
      'CENTER-TOP',    'Top center',
      'LEFT',          'Left',
      'LEFT-BOTTOM',   'Bottom left',
      'LEFT-CENTER',   'Center left',
      'LEFT-TOP',      'Top left',
      'RIGHT',         'Right',
      'RIGHT-BOTTOM',  'Bottom right',
      'RIGHT-CENTER',  'Center right',
      'RIGHT-TOP',     'Top right',
      i.LABEL_ALIGNMENT)||decode(i.FIELD_ALIGNMENT,
      'CENTER',       'Center',
      'CENTER-BOTTOM','Center bottom',
      'CENTER-CENTER','Center center',
      'CENTER-TOP',   'Center top',
      'LEFT',         'Left',
      'LEFT-BOTTOM',  'Left bottom',
      'LEFT-CENTER',  'Left center',
      'LEFT-TOP',     'Left top',
      'RIGHT',        'Right',
      'RIGHT-BOTTOM', 'Right bottom',
      'RIGHT-CENTER', 'Right center',
      'RIGHT-TOP',    'Right top',
      i.FIELD_ALIGNMENT)
    ||',c='||i.DISPLAY_WHEN_TYPE||substr(i.DISPLAY_WHEN,1,20)||length(i.DISPLAY_WHEN)||length(i.DISPLAY_WHEN2)
    ||decode(i.IS_PERSISTENT,
       'Y','PerSes',
       'U','PerU',
       'N','Do Not Save SesSt',
       i.IS_PERSISTENT)||
    decode(nvl(i.PROTECTION_LEVEL,'N'),
       'N','Unrest',
       'C','Arg Must Have Cs',
       'U','No Arguments Allowed',
       'D','No URL Access',
       'S','Cs Required - Session Level',
       'I','Restricted - May not be set from browser',
       'B','Cs Req-AL',
       'P','Cs Req-UL',
       i.PROTECTION_LEVEL)
    ||decode(substr(i.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(i.SECURITY_SCHEME,'!')
     and    flow_id = f.application_id),
     'Not found')
     ||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))
    component_signature
from wwv_flow_step_items i,
     wwv_flow_steps      p,
     wwv_flow_authorized f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and f.workspace_id      = i.security_group_id
  and f.application_id    = i.flow_id
  and p.security_group_id = i.security_group_id
  and p.flow_id           = i.flow_id
  and p.id                = i.flow_step_id
  and ( i.source_type    <> 'FACET_COLUMN' or i.source_type is null )
/


comment on table  apex_application_page_items                   is 'Identifies Page Items which are used to render HTML form content.  Items automatically maintain session state which can be accessed using bind variables or substitution stings.';
comment on column apex_application_page_items.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_items.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_page_items.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_items.application_name  is 'Identifies the application';
comment on column apex_application_page_items.page_id           is 'Identifies the application';
comment on column apex_application_page_items.page_name         is 'Identifies a page within an application';
comment on column apex_application_page_items.item_name         is 'Identifies a page item and is used to maintain session state.  Value may be referenced as a SQL bind variable or using APEX substitution string syntax.';
comment on column apex_application_page_items.display_as        is 'Identifies how the item will be displayed in the HTML page';
comment on column apex_application_page_items.display_as_code   is 'Internal code of DISPLAY_AS';
comment on column apex_application_page_items.item_data_type    is 'Typically VARCHAR but may be set to NUMBER to restrict values to only numbers';
comment on column apex_application_page_items.is_required       is 'If set to Yes, APEX will automatically perform a not null validation during page submit.';
comment on column apex_application_page_items.is_primary_key    is 'Determines whether this item is used as the Primary Key in DML operations.';
comment on column apex_application_page_items.is_query_only     is 'Determines whether this is a "Query Only" item, i.e. changes are not written for DML operations.';
comment on column apex_application_page_items.standard_validations is 'Identifies where APEX will perform the built-in standard validations for the item type.';
comment on column apex_application_page_items.DISPLAY_SEQUENCE  is 'Identifies the sequence the page item will be displayed within a region';
comment on column apex_application_page_items.REGION            is 'Identifies the region in which the item will be displayed';
comment on column apex_application_page_items.REGION_ID         is 'Identifies the foreign key to the apex_application_page_regions view';
comment on column apex_application_page_items.DATA_SOURCE_REGION    is 'Identifies the data source region this item is assigned to.';
comment on column apex_application_page_items.DATA_SOURCE_REGION_ID is 'Identifies the foreign key to the apex_application_page_regions view';
comment on column apex_application_page_items.SOURCE_USED       is 'Identifies how the source of the item value is determined.  The item can be set by the source value on each view only when the session state for the item is null.';
comment on column apex_application_page_items.ITEM_DEFAULT      is 'When the item has no source or session state, use this default value';
comment on column apex_application_page_items.ITEM_DEFAULT_TYPE is 'Identifies how the Item Default is set, based on a dynamic computation or a static assignment';
comment on column apex_application_page_items.LABEL             is 'Identifies the item label';
comment on column apex_application_page_items.placeholder       is 'Identifies the placeholder used for the element of the item';
comment on column apex_application_page_items.PRE_ELEMENT_TEXT is 'Identifies text placed before the item.';
comment on column apex_application_page_items.POST_ELEMENT_TEXT is 'Identifies text placed after the item.';
comment on column apex_application_page_items.FORMAT_MASK       is 'Identifies a format mask which can be used to format numeric or date values';
comment on column apex_application_page_items.ITEM_LABEL_TEMPLATE is 'Identifies the template used to display the item label';
comment on column apex_application_page_items.ITEM_LABEL_TEMPLATE_ID is 'Identifies the template ID foreign key';
comment on column apex_application_page_items.item_css_classes       is 'Identifies additional CSS classes to be applied to the item';
comment on column apex_application_page_items.item_icon_css_classes  is 'Identifies CSS classes to display an icon for the item';
comment on column apex_application_page_items.item_template_options  is 'Identifies template options to be applied to the item template';
comment on column apex_application_page_items.ITEM_SOURCE       is 'Identifies the items value.  Reference the Source Used and Item Source Type attributes.';
comment on column apex_application_page_items.ITEM_SOURCE_TYPE  is 'Identifies how the item source is determined, for example from a Database Column, Static assignment, or a Query or PL/SQL expression.';
comment on column apex_application_page_items.item_source_data_type  is 'Identifies the column data type if the item source type is "Region Source Column"';
comment on column apex_application_page_items.SOURCE_POST_COMPUTATION  is 'After determining the Item Source value apply this computation';
comment on column apex_application_page_items.READ_ONLY_CONDITION_TYPE is 'Identifies the condition type when the item will be rendered read only';
comment on column apex_application_page_items.READ_ONLY_CONDITION_TYPE_CODE is 'Identifies the internal code of READ_ONLY_CONDITION_TYPE';
comment on column apex_application_page_items.READ_ONLY_CONDITION_EXP1 is 'Identifies the condition that determines if the item will be rendered read only';
comment on column apex_application_page_items.READ_ONLY_CONDITION_EXP2 is 'Identifies the condition that determines if the item will be rendered read only';
comment on column apex_application_page_items.READ_ONLY_DISPLAY_ATTR is 'Identifies the HTML SPAN tag attributes when rendering the item read only';
comment on column apex_application_page_items.LOV_NAMED_LOV is 'Identifies the List of Values to be used to render this domain of values for this item';
comment on column apex_application_page_items.LOV_DEFINITION is 'Identifies the List of Values used as the domain of values for this item';
comment on column apex_application_page_items.LOV_DISPLAY_EXTRA is 'When an items values is not included in the domain of the List of Values, display the value of the item';
comment on column apex_application_page_items.LOV_DISPLAY_NULL is 'Yes or No, identifies if a null value option is to be provided';
comment on column apex_application_page_items.LOV_NULL_TEXT is 'Identifies the text to be displayed to the end user for a null value';
comment on column apex_application_page_items.LOV_NULL_VALUE is 'Identifies the value to be used to identify a null value for the item';
comment on column apex_application_page_items.LOV_QUERY_RESULT_TRANSLATED is 'Yes or No identifies if List of Values elements will be checked for dynamic translation';
comment on column apex_application_page_items.lov_cascade_parent_items is 'Identifies the cascading LOV parent item(s) for the item.';
comment on column apex_application_page_items.ajax_items_to_submit is 'Identifies the page items which should be submitted when an Ajax call is performed for the page item.';
comment on column apex_application_page_items.ajax_optimize_refresh is 'Yes or No, identifies if the Ajax call should be optimized.';

comment on column apex_application_page_items.ITEM_ELEMENT_WIDTH is 'Identifies the width of the item element';
comment on column apex_application_page_items.ITEM_ELEMENT_MAX_LENGTH is 'Identifies the maximum length of the item element';
comment on column apex_application_page_items.ITEM_ELEMENT_HEIGHT is 'Identifies the height of the item element for item display types that use a height';

comment on column apex_application_page_items.HTML_TABLE_CELL_ATTR_LABEL     is 'Identifies HTML table cell label attributes';
comment on column apex_application_page_items.HTML_TABLE_CELL_ATTR_ELEMENT   is 'Identifies HTML table cell element attributes';
comment on column apex_application_page_items.HTML_FORM_ELEMENT_ATTRIBUTES   is 'Identifies HTML table form element attributes';
comment on column apex_application_page_items.FORM_ELEMENT_OPTION_ATTRIBUTES is 'Identifies HTML table form element option attributes';

comment on column apex_application_page_items.ITEM_BUTTON_IMAGE              is 'For buttons displayed among items, the name of a button image';
comment on column apex_application_page_items.ITEM_BUTTON_IMAGE_ATTRIBUTES   is 'For buttons displayed among items, the name of a button HTML IMG tag attributes';

comment on column apex_application_page_items.new_grid                      is 'Identifies if the rendering of the item begins on a new grid';
comment on column apex_application_page_items.new_grid_row                  is 'Identifies if the rendering of the item begins on a new grid row';
comment on column apex_application_page_items.new_grid_column               is 'Identifies if the rendering of the item begins on a new grid column';
comment on column apex_application_page_items.grid_column                   is 'Identifies the grid column used to display the item';
comment on column apex_application_page_items.grid_column_span              is 'Identifies over how many grid columns the item spans';
comment on column apex_application_page_items.ROW_SPAN                      is 'Identifies the HTML table TD tag ROWSPAN value';
comment on column apex_application_page_items.grid_label_column_span        is 'Identifies over how many grid columns the label spans';
comment on column apex_application_page_items.grid_column_css_classes       is 'Additional CSS classes which are substituted if the grid column template contains the substitution string #CSS_CLASSES#';
comment on column apex_application_page_items.grid_column_attributes        is 'Additional attributes which are substituted if the grid column template contains the substitution string #ATTRIBUTES#';

comment on column apex_application_page_items.LABEL_ALIGNMENT is 'Identifies the alignment of the Item Label';
comment on column apex_application_page_items.ITEM_ALIGNMENT  is 'Identifies the alignment of the Item Form Element';

comment on column apex_application_page_items.inline_help_text      is 'Help text to be displayed inline with the page item.';
comment on column apex_application_page_items.show_quick_picks      is 'If set to Yes, the entered quick picks will be displayed below the page item.';
comment on column apex_application_page_items.quick_pick_link_attr  is 'Link attribute which is added to each quick pick link.';
comment on column apex_application_page_items.quick_pick_label_01   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_01   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_02   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_02   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_03   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_03   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_04   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_04   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_05   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_05   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_06   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_06   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_07   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_07   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_08   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_08   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_09   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_09   is 'The value defines the value which is used when the quick pick is clicked.';
comment on column apex_application_page_items.quick_pick_label_10   is 'The label is the the text the end user of the application will see for the quick pick.';
comment on column apex_application_page_items.quick_pick_value_10   is 'The value defines the value which is used when the quick pick is clicked.';

comment on column apex_application_page_items.init_javascript_code  is 'JavaScript code for item initialization';

comment on column apex_application_page_items.attribute_01          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_02          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_03          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_04          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_05          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_06          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_07          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_08          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_09          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_10          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_11          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_12          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_13          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_14          is 'Dynamic attribute to store additional data';
comment on column apex_application_page_items.attribute_15          is 'Dynamic attribute to store additional data';

comment on column apex_application_page_items.CONDITION_TYPE        is 'Identifies a condition that must be met in order for this item to be displayed';
comment on column apex_application_page_items.CONDITION_TYPE_CODE   is 'Identifies the internal code CONDITION_TYPE';
comment on column apex_application_page_items.CONDITION_EXPRESSION1 is 'Identifies the item display condition';
comment on column apex_application_page_items.CONDITION_EXPRESSION2 is 'Identifies the item display condition';

comment on column apex_application_page_items.warn_on_unsaved_changes      is 'Determines if a warning should be displayed in case of unsaved changes.';
comment on column apex_application_page_items.warn_on_unsaved_changes_code is 'Identifies the internal code WARN_ON_UNSAVED_CHANGES';
comment on column apex_application_page_items.restricted_characters is 'Identifies how to restrict the characters that can be saved in session state';
comment on column apex_application_page_items.restricted_characters_code is 'Identifies the internal code of RESTRICTED_CHARACTERS';
comment on column apex_application_page_items.MAINTAIN_SESSION_STATE is 'Identifies the method used to maintain session state, per session, per user, or not maintained';
comment on column apex_application_page_items.ITEM_PROTECTION_LEVEL is 'If Session State Protection is enabled, identifies if a checksum will be required to change an items session state via the URL or POSTDATA.';
comment on column apex_application_page_items.AUTHORIZATION_SCHEME  is 'Identifies the authorization scheme which must evaluate to TRUE in order for this component to be rendered';
comment on column apex_application_page_items.AUTHORIZATION_SCHEME_ID      is 'Foreign Key';
comment on column apex_application_page_items.encrypt_session_state is 'If Yes values of session state written to APEX session state tables is encrypted.  Decryption is automatic.';
comment on column apex_application_page_items.escape_on_http_output is 'If Yes values will be escaped when they are written to the HTTP output.';
comment on column apex_application_page_items.BUILD_OPTION          is 'Item will be displayed if the Build Option is enabled';
comment on column apex_application_page_items.COMPONENT_COMMENT     is 'Identifies a developer comment for this item';
comment on column apex_application_page_items.ITEM_ID               is 'Primary key of this component';
comment on column apex_application_page_items.last_updated_by   is 'APEX developer who made last update';
comment on column apex_application_page_items.last_updated_on   is 'Date of last update';
comment on column apex_application_page_items.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

create or replace view apex_application_page_db_items
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                            page_id,
    p.name                          page_name,
    (select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_PLUG_ID)     region,
    --
    i.name                          item_name,
    i.display_as                    display_as,
    i.ITEM_SEQUENCE                 display_sequence,
    --
    i.PROMPT                        item_label,
    i.SOURCE                        db_column_name,
    ( select attribute_02
        from wwv_flow_step_processing proc
       where proc.security_group_id = p.security_group_id
         and proc.flow_id           = p.flow_id
         and proc.flow_step_id      = p.id
         and proc.process_type      = 'NATIVE_FORM_FETCH' )
                                    db_table_name,
    h.help_text                     help_text,
    i.inline_help_text              inline_help_text,
    i.id                            item_id
from wwv_flow_step_items     i,
     wwv_flow_step_item_help h,
     wwv_flow_steps          p,
     wwv_flow_authorized     f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and f.workspace_id      = i.security_group_id
  and f.application_id    = i.flow_id
  and p.security_group_id = i.security_group_id
  and p.flow_id           = i.flow_id
  and p.id                = i.flow_step_id
  and i.id                = h.flow_item_id (+)
  and i.source_type       = 'DB_COLUMN'
/

comment on table  apex_application_page_db_items                   is 'Identifies Page Items which are associated with Database Table Columns.  This view represents a subset of the items in the APEX_APPLICATION_PAGE_ITEMS view.';
comment on column apex_application_page_db_items.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_db_items.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_page_db_items.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_db_items.application_name  is 'Identifies the application';
comment on column apex_application_page_db_items.page_id           is 'Identifies the application';
comment on column apex_application_page_db_items.page_name         is 'Identifies a page within an application';
comment on column apex_application_page_db_items.item_name         is 'APEX page item name';
comment on column apex_application_page_db_items.DISPLAY_AS        is 'Identifies how the item will be displayed in the HTML page';
comment on column apex_application_page_db_items.DISPLAY_SEQUENCE  is 'Identifies the sequence the page item will be displayed within a region';
comment on column apex_application_page_db_items.REGION            is 'Identifies the region in which the item will be displayed';
comment on column apex_application_page_db_items.ITEM_LABEL        is 'Identifies the item label';
comment on column apex_application_page_db_items.DB_COLUMN_NAME    is 'Identifies the item source database column name';
comment on column apex_application_page_db_items.DB_TABLE_NAME     is 'Identifies the item source database table name';
comment on column apex_application_page_db_items.INLINE_HELP_TEXT  is 'Identifies the help text to be displayed inline with the page item';
comment on column apex_application_page_db_items.HELP_TEXT         is 'Identifies the help text for the page item';
comment on column apex_application_page_db_items.ITEM_ID           is 'Primary key of this component';



create or replace view apex_appl_page_facets
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                            page_id,
    p.name                          page_name,
    --
    (select plug_name
     from wwv_flow_page_plugs
     where id = i.ITEM_PLUG_ID)     region,
    i.item_plug_id                  region_id,
    --
    i.name                          item_name,
    case substr(i.display_as, 1, 7)
      when 'NATIVE_' then
          ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = 'ITEM TYPE' and name = substr(i.display_as, 8) )
      when 'PLUGIN_' then
          ( select display_name from wwv_flow_plugins where flow_id = p.flow_id and plugin_type = 'ITEM TYPE' and name = substr(i.display_as, 8) )
    end                             item_type,
    i.display_as                    item_type_code,
    --
    i.PROMPT                        label,
    --
    i.attribute_01,
    i.attribute_02,
    i.attribute_03,
    i.attribute_04,
    i.attribute_05,
    i.attribute_06,
    i.attribute_07,
    i.attribute_08,
    i.attribute_09,
    i.attribute_10,
    i.attribute_11,
    i.attribute_12,
    i.attribute_13,
    i.attribute_14,
    i.attribute_15,
    --
    i.ITEM_SEQUENCE                 display_sequence,
    i.fc_max_height                 max_height,
    --
    i.NAMED_LOV                     lov_named_lov,
    i.LOV                           lov_definition,
    decode(i.LOV_DISPLAY_NULL,
      'NO','No',
      'YES','Yes',
      i.LOV_DISPLAY_NULL)           lov_display_null,
    i.LOV_NULL_TEXT                 lov_null_text,
    --
    decode(i.fc_compute_counts,
       'Y','Yes',
       'N','No',
       i.fc_compute_counts)         compute_counts,
    decode(i.fc_show_counts,
       'Y','Yes',
       'N','No',
       i.fc_show_counts)            show_counts,
    case i.fc_zero_count_entries
      when 'H' then 'Hide'
      when 'D' then 'Disable'
      when 'L' then 'Show Last'
    end                             zero_count_entries,
    decode(i.fc_show_selected_first,
       'Y','Yes',
       'N','No',
       i.fc_show_selected_first)    show_selected_first,
    fc_show_more_count              max_displayed_entries,
    decode(i.fc_filter_values,
       'Y','Yes',
       'N','No',
       i.fc_filter_values)          has_client_side_filtering,
    --
    i.placeholder                   placeholder,
    i.PRE_ELEMENT_TEXT              pre_element_text,
    i.POST_ELEMENT_TEXT             post_element_text,
    --
    decode(i.fc_collapsible,
       'Y','Yes',
       'N','No',
       i.fc_collapsible)            is_collapsible,
    decode(i.fc_initial_collapsed,
       'Y','Yes',
       'N','No',
       i.fc_initial_collapsed)      is_initial_collapsed,
    i.item_css_classes              item_css_classes,
    --
    i.SOURCE                        item_source,
    i.source_data_type              item_source_data_type,
    --
    i.ITEM_DEFAULT_TYPE             item_default_type,
    i.ITEM_DEFAULT                  item_default,
    --
    nvl((select r from apex_standard_conditions where d = i.DISPLAY_WHEN_TYPE),i.DISPLAY_WHEN_TYPE)
                                    condition_type,
    i.display_when_type             condition_type_code,
    i.DISPLAY_WHEN                  condition_expression1,
    i.DISPLAY_WHEN2                 condition_expression2,
    --
    decode(substr(i.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(i.SECURITY_SCHEME,'!')
     and    flow_id = f.application_id),
     i.SECURITY_SCHEME)             authorization_scheme,
    i.security_scheme               authorization_scheme_id,
    decode(i.encrypt_session_state_yn,'Y','Yes','No') encrypt_session_state,
    case i.escape_on_http_output
      when 'Y' then 'Yes'
      when 'N' then 'No'
      else i.escape_on_http_output
    end                             escape_on_http_output,
    --
    (select case when i.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(i.REQUIRED_PATCH))   build_option,
    i.REQUIRED_PATCH                build_option_id,
    --
    i.LAST_UPDATED_BY               last_updated_by,
    i.LAST_UPDATED_ON               last_updated_on,
    i.ITEM_COMMENT                  component_comment,
    i.id                            item_id,
    --
    to_char(null)                   component_signature
from wwv_flow_step_items i,
     wwv_flow_steps      p,
     wwv_flow_authorized f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and f.workspace_id      = i.security_group_id
  and f.application_id    = i.flow_id
  and p.security_group_id = i.security_group_id
  and p.flow_id           = i.flow_id
  and p.id                = i.flow_step_id
  and i.source_type       = 'FACET_COLUMN'
/


comment on table  apex_appl_page_facets                         is 'Identifies Facets which are used within a Faceted Search region.';
comment on column apex_appl_page_facets.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_appl_page_facets.workspace_display_name is 'Display name for the workspace';
comment on column apex_appl_page_facets.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_page_facets.application_name  is 'Identifies the application';
comment on column apex_appl_page_facets.page_id           is 'Identifies the application';
comment on column apex_appl_page_facets.page_name         is 'Identifies a page within an application';
comment on column apex_appl_page_facets.REGION            is 'Identifies the region in which the item will be displayed';
comment on column apex_appl_page_facets.REGION_ID         is 'Identifies the foreign key to the apex_application_page_regions view';
comment on column apex_appl_page_facets.item_name         is 'Identifies a facet and is used to maintain session state.  Value may be referenced as a SQL bind variable or using APEX substitution string syntax.';
comment on column apex_appl_page_facets.item_type         is 'Identifies how the facet will be displayed in the HTML page';
comment on column apex_appl_page_facets.item_type_code    is 'Internal code of ITEM_TYPE';
--
comment on column apex_appl_page_facets.LABEL             is 'Identifies the facet label';
--
comment on column apex_appl_page_facets.attribute_01          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_02          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_03          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_04          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_05          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_06          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_07          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_08          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_09          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_10          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_11          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_12          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_13          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_14          is 'Dynamic attribute to store additional data';
comment on column apex_appl_page_facets.attribute_15          is 'Dynamic attribute to store additional data';
--
comment on column apex_appl_page_facets.DISPLAY_SEQUENCE  is 'Identifies the sequence the facet will be displayed within a region';
comment on column apex_appl_page_facets.max_height is 'Identifies the height of the facet';
--
comment on column apex_appl_page_facets.LOV_NAMED_LOV is 'Identifies the List of Values to be used to render this domain of values for this facet';
comment on column apex_appl_page_facets.LOV_DEFINITION is 'Identifies the List of Values used as the domain of values for this facet';
comment on column apex_appl_page_facets.LOV_DISPLAY_NULL is 'Yes or No, identifies if a null value option is to be provided';
comment on column apex_appl_page_facets.LOV_NULL_TEXT is 'Identifies the text to be displayed to the end user for a null value';
--
comment on column apex_appl_page_facets.compute_counts             is 'Identifies whether the facet will compute counts.';
comment on column apex_appl_page_facets.show_counts                is 'Identifies whether the facet will show counts.';
comment on column apex_appl_page_facets.zero_count_entries         is 'Identifies how facet values with a count of zero should get displayed.';
comment on column apex_appl_page_facets.show_selected_first        is 'Identifies whether the selected facet values are displayed first in the list of available values.';
comment on column apex_appl_page_facets.max_displayed_entries      is 'Show only up to this amount of values for the facet.';
comment on column apex_appl_page_facets.has_client_side_filtering  is 'Identifies whether the facet values can be filtered.';
--
comment on column apex_appl_page_facets.placeholder       is 'Identifies the placeholder used for the facet';
comment on column apex_appl_page_facets.PRE_ELEMENT_TEXT is 'Identifies text placed before the facet.';
comment on column apex_appl_page_facets.POST_ELEMENT_TEXT is 'Identifies text placed after the facet.';
--
comment on column apex_appl_page_facets.is_collapsible          is 'Identifies whether the facet is collapsible';
comment on column apex_appl_page_facets.is_initial_collapsed    is 'Identifies whether the facet is initially collapsed';
comment on column apex_appl_page_facets.item_css_classes       is 'Identifies additional CSS classes to be applied to the facet';
--
comment on column apex_appl_page_facets.ITEM_SOURCE       is 'Identifies the facet column.';
comment on column apex_appl_page_facets.item_source_data_type  is 'Identifies the column data type if the item source type is "Region Source Column"';
--
comment on column apex_appl_page_facets.ITEM_DEFAULT_TYPE is 'Identifies how the Item Default is set, based on a dynamic computation or a static assignment';
comment on column apex_appl_page_facets.ITEM_DEFAULT      is 'When the facet has no session state, use this default value';
--
comment on column apex_appl_page_facets.CONDITION_TYPE        is 'Identifies a condition that must be met in order for this facet to be displayed';
comment on column apex_appl_page_facets.CONDITION_TYPE_CODE   is 'Identifies the internal code CONDITION_TYPE';
comment on column apex_appl_page_facets.CONDITION_EXPRESSION1 is 'Identifies the facet display condition';
comment on column apex_appl_page_facets.CONDITION_EXPRESSION2 is 'Identifies the facet display condition';
--
comment on column apex_appl_page_facets.AUTHORIZATION_SCHEME  is 'Identifies the authorization scheme which must evaluate to TRUE in order for this component to be rendered';
comment on column apex_appl_page_facets.AUTHORIZATION_SCHEME_ID      is 'Foreign Key';
comment on column apex_appl_page_facets.encrypt_session_state is 'If Yes values of session state written to APEX session state tables is encrypted.  Decryption is automatic.';
comment on column apex_appl_page_facets.escape_on_http_output is 'If Yes values will be escaped when they are written to the HTTP output.';
--
comment on column apex_appl_page_facets.BUILD_OPTION          is 'Item will be displayed if the Build Option is enabled';
comment on column apex_appl_page_facets.COMPONENT_COMMENT     is 'Identifies a developer comment for this item';
--
comment on column apex_appl_page_facets.ITEM_ID               is 'Primary key of this component';
comment on column apex_appl_page_facets.last_updated_by       is 'APEX developer who made last update';
comment on column apex_appl_page_facets.last_updated_on       is 'Date of last update';


---------------------------------------------------
-- A P P L I C A T I O N   P A G E   R E G I O N S
-- 4651

prompt ...apex_application_page_regions

create or replace view apex_application_page_regions
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                                 page_id,
    p.name                               page_name,
    --
    r.plug_name                          region_name,
    r.parent_plug_id                     parent_region_id,
    case
      when r.parent_plug_id is not null then
          ( select region_name
              from wwv_flow_page_plugs
             where id = r.parent_plug_id )
    end                                  parent_region_name,
    r.filtered_region_id                 filtered_region_id,
    nvl(decode(nvl(r.PLUG_TEMPLATE,0),0,
     'No Template',
     (select PAGE_PLUG_TEMPLATE_NAME
     from wwv_flow_page_plug_templates
     where id = r.PLUG_TEMPLATE)),'No Template') template,
    r.PLUG_TEMPLATE                      template_id,
    r.region_name                        static_id,
    decode(nvl(r.rest_enabled,'N'),'Y','Yes','No') rest_enabled,
    r.PLUG_DISPLAY_SEQUENCE              display_sequence,
    case r.plug_new_grid
      when 'Y' then 'Yes'
      else 'No'
    end                                  new_grid,
    case r.plug_new_grid_row
      when 'Y' then 'Yes'
      else 'No'
    end                                  new_grid_row,
    case r.plug_new_grid_column
      when 'Y' then 'Yes'
      else 'No'
    end                                  new_grid_column,
    r.PLUG_DISPLAY_COLUMN                grid_column,
    r.plug_grid_column_span              grid_column_span,
    r.plug_grid_column_css_classes       grid_column_css_classes,
    r.plug_column_width                  grid_column_attributes,
    decode(nvl(r.INCLUDE_IN_REG_DISP_SEL_YN,'N'),
        'Y','Yes','N','No',r.INCLUDE_IN_REG_DISP_SEL_YN)
                                         display_region_selector,
    r.region_css_classes,
    r.icon_css_classes,
    r.region_sub_css_classes,
    r.region_template_options            region_template_options,
    r.component_template_options         component_template_options,
    r.REGION_ATTRIBUTES_SUBSTITUTION     REGION_ATTRIBUTES_SUBSTITUTION,
    case r.escape_on_http_output
      when 'Y' then 'Yes'
      when 'N' then 'No'
      else r.escape_on_http_output
    end                                  escape_on_http_output,
    r.PLUG_DISPLAY_COLUMN                display_column, /* for backward compatibility, replaced by grid_column */
    decode(r.PLUG_DISPLAY_POINT,
       'AFTER_HEADER',       'After Header',
       'BODY',               'Page Template Body',
       'BODY_1',             'Page Template Body (1)',
       'BODY_2',             'Page Template Body (2)',
       'BODY_3',             'Page Template Body (3)',
       'BEFORE_FOOTER',      'Before Footer',
       'REGION_POSITION_01', 'Page Template Region Position 1',
       'REGION_POSITION_02', 'Page Template Region Position 2',
       'REGION_POSITION_03', 'Page Template Region Position 3',
       'REGION_POSITION_04', 'Page Template Region Position 4',
       'REGION_POSITION_05', 'Page Template Region Position 5',
       'REGION_POSITION_06', 'Page Template Region Position 6',
       'REGION_POSITION_07', 'Page Template Region Position 7',
       'REGION_POSITION_08', 'Page Template Region Position 8',
       r.PLUG_DISPLAY_POINT)
                                         display_position,
    r.plug_display_point                 display_position_code,
    case plug_item_display_point
    when 'ABOVE' then 'Above Content'
    when 'BELOW' then 'Below Content'
    end                                  display_item_position,
    r.plug_item_display_point            display_item_position_code,
    --
    r.location                           location_code,
    decode( r.location,
       'LOCAL',       'Local Database',
       'REMOTE',      'Remote Database',
       'WEB_SOURCE',  'Web Source' )     location,
    r.query_type                         query_type_code,
    decode( r.query_type,
       'TABLE',       'Table',
       'SQL',         'SQL Query',
       'FUNC_BODY_RETURNING_SQL', 'PL/SQL Function Body returning SQL Query' ) query_type,
    r.query_owner                          table_owner,
    r.query_table                          table_name,
    r.query_where                          where_clause,
    r.query_order_by                       order_by_clause,
    decode( r.source_post_processing,
       'SQL', 'SQL Query',
       'WHERE_ORDER_BY_CLAUSE', 'Where/Order By Clause',
       'FUNC_BODY_RETURNING_SQL', 'PL/SQL Function Body returning SQL Query' ) source_post_processing,
    case r.include_rowid_column
      when 'Y' then 'Yes'
      else 'No'
    end                                    include_rowid_column,
    r.plug_source                          region_source,
    r.optimizer_hint,
    --
    (select name
       from wwv_remote_servers
      where id = r.remote_server_id)       remote_database_name,
    r.remote_server_id                     remote_database_id,
    (select name
       from wwv_flow_web_src_modules
      where id = r.web_src_module_id)      web_source_module_name,
    r.web_src_module_id                    web_source_module_id,
    --
    external_filter_expr,
    external_order_by_expr,
    --
    case r.is_editable
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end as is_editable,
    r.edit_operations,
    r.edit_row_operations_column,
    --
    case when substr( r.add_authorization_scheme, 1, 1) = '!' then 'Not ' end ||
    coalesce (
        ( select name
            from wwv_flow_security_schemes
           where to_char( id ) = ltrim( r.add_authorization_scheme, '!' )
             and flow_id       = r.flow_id
        ),
        r.add_authorization_scheme ) as add_authorization_scheme,
    r.add_authorization_scheme       as add_authorization_scheme_id,
    --
    case when substr( r.update_authorization_scheme, 1, 1) = '!' then 'Not ' end ||
    coalesce (
        ( select name
            from wwv_flow_security_schemes
           where to_char( id ) = ltrim( r.update_authorization_scheme, '!' )
             and flow_id       = r.flow_id
        ),
        r.update_authorization_scheme ) as update_authorization_scheme,
    r.update_authorization_scheme       as update_authorization_scheme_id,
    --
    case when substr( r.delete_authorization_scheme, 1, 1) = '!' then 'Not ' end ||
    coalesce (
        ( select name
            from wwv_flow_security_schemes
           where to_char( id ) = ltrim( r.delete_authorization_scheme, '!' )
             and flow_id       = r.flow_id
        ),
        r.delete_authorization_scheme ) as delete_authorization_scheme,
    r.delete_authorization_scheme       as delete_authorization_scheme_id,
    --
    case r.lost_update_check_type
      when 'VALUES' then 'Row Values'
      when 'COLUMN' then 'Row Version Column'
    end as lost_update_check_type,
    r.lost_update_check_type lost_update_check_type_code,
    r.row_version_column,
    case r.add_row_if_empty
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end as add_row_if_empty,
    case r.lazy_loading
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end as lazy_loading,
    --
    (select name
    from   wwv_flow_menu_templates
    where  id = to_char(r.MENU_TEMPLATE_ID)
    and    flow_id = f.application_id)                 breadcrumb_template,
    r.MENU_TEMPLATE_ID                     breadcrumb_template_id,
    --
    (select list_template_name
    from wwv_flow_list_templates
    where id = r.LIST_TEMPLATE_ID)         list_template_override,
    r.LIST_TEMPLATE_ID                     list_template_override_id,
    --
    case r.plug_source_type
      when 'NATIVE_PLSQL'                 then 'PL/SQL'
      when 'NATIVE_SIMPLE_CHART'          then 'HTML Chart'
      when 'NATIVE_SVG_CHART'             then 'SVG Chart'
      when 'NATIVE_FLASH_CHART5'          then 'Flash Chart'
      when 'NATIVE_FLASH_MAP'             then 'Map'
      when 'NATIVE_JET_CHART'             then 'Chart'
      when 'NATIVE_SQL_REPORT'            then 'Report'
      when 'NATIVE_IR'                    then 'Interactive Report'
      when 'NATIVE_STATIC'                then 'HTML/Text'||
                                               case when attribute_02='TEXT' then ' (escape special characters)' end||
                                               case when attribute_01='Y' then ' (with shortcuts)' end
      when 'NATIVE_TREE'                  then 'Tree'
      when 'NATIVE_TABFORM'               then 'Tabular Form'
      when 'NATIVE_URL'                   then 'URL'
      when 'NATIVE_DISPLAY_SELECTOR'      then 'Region Display Selector'
      when 'NATIVE_CALENDAR'              then 'Calendar'
      when 'NATIVE_JSTREE'                then 'JavaScript Tree'
      when 'NATIVE_HELP_TEXT'             then 'Help Text'
      when 'NATIVE_FACETED_SEARCH'        then 'Faceted Search'
      else
          case
            when r.plug_source_type like 'NATIVE\_%' escape '\' then
                ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = 'REGION TYPE' and name = substr(r.plug_source_type, 8) )
            when r.plug_source_type like 'PLUGIN\_%' escape '\' then
                ( select display_name from wwv_flow_plugins where flow_id = r.flow_id and plugin_type = 'REGION TYPE' and name = substr(r.plug_source_type, 8) )
          end
      end                                source_type,
    case -- compute mapping to pre 5.0 source type
      when r.plug_source_type in ('NATIVE_HELP_TEXT', 'NATIVE_URL', 'NATIVE_TREE', 'NATIVE_JSTREE',
                                  'NATIVE_SVG_CHART', 'NATIVE_FLASH_CHART5',
                                  'NATIVE_FLASH_MAP', 'NATIVE_SIMPLE_CHART')
      then substr(r.plug_source_type, 8)
      when r.plug_source_type = 'NATIVE_PLSQL'                            then 'PLSQL_PROCEDURE'
      when r.plug_source_type = 'NATIVE_IR'                               then 'DYNAMIC_QUERY'
      when r.plug_source_type = 'NATIVE_SQL_REPORT' and r.query_type = 'FUNC_BODY_RETURNING_SQL' then 'FUNCTION_RETURNING_SQL_QUERY'
      when r.plug_source_type = 'NATIVE_SQL_REPORT'                       then 'SQL_QUERY'
      when r.plug_source_type = 'NATIVE_TABFORM'                          then 'UPDATABLE_SQL_QUERY'
      when r.plug_source_type = 'NATIVE_STATIC' and r.attribute_02='TEXT' then 'STATIC_TEXT_ESCAPE_SC'
      when r.plug_source_type = 'NATIVE_STATIC' and r.attribute_01='Y'    then 'STATIC_TEXT_WITH_SHORTCUTS'
      when r.plug_source_type = 'NATIVE_STATIC'                           then 'STATIC_TEXT'
      when r.plug_source_type = 'NATIVE_DISPLAY_SELECTOR'                 then 'REGION_DISPLAY_SELECTOR'
      when r.plug_source_type = 'NATIVE_CALENDAR'                         then 'CALENDAR'
      when r.plug_source_type = 'NATIVE_BREADCRUMB'                       then 'M'||trunc(r.menu_id)
      when r.plug_source_type = 'NATIVE_LIST'                             then to_char(trunc(r.list_id))
      else r.plug_source_type
      end                                source_type_code,
    r.plug_source_type                   source_type_plugin_name,
    --
    --
    decode(substr(r.PLUG_REQUIRED_ROLE,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(r.PLUG_REQUIRED_ROLE,'!')
     and    flow_id = f.application_id),
     r.PLUG_REQUIRED_ROLE)               authorization_scheme,
    r.PLUG_REQUIRED_ROLE                 authorization_scheme_id,
    nvl((select r from apex_standard_conditions where d = r.PLUG_DISPLAY_CONDITION_TYPE),r.PLUG_DISPLAY_CONDITION_TYPE)
                                         condition_type,
    r.plug_display_condition_type        condition_type_code,
    r.PLUG_DISPLAY_WHEN_CONDITION        condition_expression1,
    r.PLUG_DISPLAY_WHEN_COND2            condition_expression2,
    -- read only condition
    coalesce (
        ( select r
            from apex_standard_conditions
           where r.plug_read_only_when_type is not null
             and d = r.plug_read_only_when_type
        ),
        r.plug_read_only_when_type )     read_only_condition_type,
    r.plug_read_only_when_type           read_only_condition_type_code,
    r.plug_read_only_when                read_only_condition_exp1,
    r.plug_read_only_when2               read_only_condition_exp2,
    --
    r.PLUG_HEADER                        region_header_text,
    r.PLUG_FOOTER                        region_footer_text,
    (select row_template_name from wwv_flow_row_templates where id = r.PLUG_QUERY_ROW_TEMPLATE)
                                         report_template,
    r.PLUG_QUERY_ROW_TEMPLATE            report_template_id,
    r.PLUG_QUERY_HEADINGS                report_column_headings,
    r.PLUG_QUERY_HEADINGS_TYPE           headings_type,
    r.PLUG_QUERY_NUM_ROWS                maximum_rows_to_query,
    decode(r.PLUG_QUERY_NUM_ROWS_TYPE,
       'ROWS_X_TO_Y_OF_Z','Row Ranges X to Y of Z (no pagination)',
       'ROWS_X_TO_Y','Row Ranges X to Y (no pagination)',
       'SEARCH_ENGINE','Search Engine 1,2,3,4 (set based pagination)',
       'COMPUTED_BUT_NOT_DISPLAYED','Use Externally Created Pagination Buttons',
       'ROW_RANGES','Row Ranges 1-15 16-30 (with set pagination)',
       'ROW_RANGES_IN_SELECT_LIST','Row Ranges 1-15 16-30 in select list (with pagination)',
       'ROW_RANGES_WITH_LINKS','Row Ranges X to Y of Z (with pagination)',
       'NEXT_PREVIOUS_LINKS','Row Ranges X to Y (with next and previous links)',
       r.PLUG_QUERY_NUM_ROWS_TYPE)       pagination_scheme,
    decode(r.PAGINATION_DISPLAY_POSITION,
      'BOTTOM_LEFT','Bottom - Left',
      'BOTTOM_RIGHT','Bottom - Right',
      'TOP_LEFT','Top - Left',
      'TOP_RIGHT','Top - Right',
      'TOP_AND_BOTTOM_LEFT','Top and Bottom - Left',
      'TOP_AND_BOTTOM_RIGHT','Top and Bottom - Right',
      r.PAGINATION_DISPLAY_POSITION)     pagination_display_position,
    decode(r.ajax_enabled,'Y','Yes','N','No',r.ajax_enabled) ajax_enabled,
    r.ajax_items_to_submit,
    r.PLUG_QUERY_NUM_ROWS_ITEM           number_of_rows_item,
    r.PLUG_QUERY_NO_DATA_FOUND           no_data_found_message,
    r.PLUG_QUERY_MORE_DATA               more_data_found_message,
    r.PLUG_QUERY_ROW_COUNT_MAX           maximum_row_count,
    --r.PLUG_QUERY_FORMAT_OUT              query_format_out,
    r.PLUG_QUERY_SHOW_NULLS_AS           report_null_values_as,
    --r.PLUG_QUERY_COL_ALLIGNMENTS         ,
    r.PLUG_QUERY_BREAK_COLS              breaks,
    --r.PLUG_QUERY_SUM_COLS                ,
    --r.PLUG_QUERY_NUMBER_FORMATS          ,
    --r.PLUG_QUERY_TABLE_BORDER            ,
    --r.PLUG_QUERY_HIT_HIGHLIGHTING        ,
    r.PLUG_QUERY_ASC_IMAGE               ascending_image,
    r.PLUG_QUERY_ASC_IMAGE_ATTR          ascending_image_attributes,
    r.PLUG_QUERY_DESC_IMAGE              descending_image,
    r.PLUG_QUERY_DESC_IMAGE_ATTR         descending_image_attributes,
    r.PLUG_QUERY_EXP_FILENAME            filename,
    r.PLUG_QUERY_EXP_SEPARATOR           separator,
    r.PLUG_QUERY_EXP_ENCLOSED_BY         enclosed_by,
    decode(r.PLUG_QUERY_STRIP_HTML,
      'Y','Yes',
      'N','No',
      r.PLUG_QUERY_STRIP_HTML)           strip_html,
    r.PLUG_QUERY_OPTIONS                 report_column_source_type,
    r.PLUG_QUERY_MAX_COLUMNS             max_dynamic_report_cols,
    r.PLUG_COLUMN_WIDTH                  HTML_table_cell_attributes, /* for backward compatibility, replaced by grid_column_attributes */
    decode(r.fixed_header,
        'NONE',     'None',
        'PAGE',     'Page',
        'REGION',   'Region',
        r.fixed_header) fixed_header,
    r.fixed_header_max_height,
    decode(r.PLUG_CUSTOMIZED,
       null,'None',
       '2','Customizable and Not Shown By Default',
       '1','Customizable and Shown By Default',
       '0','Not Customizable By End Users',
       r.PLUG_CUSTOMIZED)                customization,
    r.PLUG_CUSTOMIZED_NAME               customization_name,
    --r.PLUG_OVERRIDE_REG_POS              ,
    (select case when r.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id=abs(r.REQUIRED_PATCH) )    build_option,
    r.required_patch                     build_option_id,
    --
    --r.PLUG_URL_TEXT_BEGIN                ,
    --r.PLUG_URL_TEXT_END                  ,
    --
    -- region caching
    --
    decode(r.PLUG_CACHING,
        'CACHE'   , 'Cached'            ,
        'USER'    , 'Cached by User'    ,
        'SESSION' , 'Cached by Session' ,
        'NOCACHE' , 'Not Cached'        ,
        r.plug_caching)                  region_caching,
    --r.plug_caching_session_state         ,
    r.plug_caching_max_age_in_sec        timeout_cache_after,
    r.plug_cache_when                    cache_when,
    r.plug_cache_expression1             cache_when_expression_1,
    r.plug_cache_expression2             cache_when_expression_2,
    r.plug_cache_depends_on_items        cache_depends_on_items,
    --r.PLUG_IGNORE_PAGINATION             ,
    --r.PLUG_CHART_FONT_SIZE               ,
    --r.PLUG_CHART_MAX_ROWS                ,
    --r.PLUG_CHART_NUM_MASK                ,
    --r.PLUG_CHART_SCALE                   ,
    --r.PLUG_CHART_AXIS                    ,
    --r.PLUG_CHART_SHOW_SUMMARY            ,
    r.REPORT_TOTAL_TEXT_FORMAT           sum_display_text,
    r.BREAK_COLUMN_TEXT_FORMAT           break_display_text,
    r.BREAK_BEFORE_ROW                   before_break_display_text,
    r.BREAK_GENERIC_COLUMN               break_column_display_text,
    r.BREAK_AFTER_ROW                    after_break_display_text,
    decode(
       r.BREAK_TYPE_FLAG,
       'REPEAT_HEADINGS_ON_BREAK_1','Repeat Headings on Break',
       'DEFAULT_BREAK_FORMATTING','Default Break Formatting',
       r.BREAK_TYPE_FLAG)                break_display_flag,
    r.BREAK_REPEAT_HEADING_FORMAT        repeat_heading_break_format,
    decode(r.CSV_OUTPUT,
    'Y','Yes','N','No',r.CSV_OUTPUT)     enable_csv_output,
    r.CSV_OUTPUT_LINK_TEXT               csv_link_label,
    r.PRINT_URL                          URL,
    r.PRINT_URL_LABEL                    link_label,
    decode(r.TRANSLATE_TITLE,
    'Y','Yes','N','No','Yes')            translate_region_title,
    --
    r.plugin_init_javascript_code        init_javascript_code,
    --
    r.attribute_01,
    r.attribute_02,
    r.attribute_03,
    r.attribute_04,
    r.attribute_05,
    r.attribute_06,
    r.attribute_07,
    r.attribute_08,
    r.attribute_09,
    r.attribute_10,
    r.attribute_11,
    r.attribute_12,
    r.attribute_13,
    r.attribute_14,
    r.attribute_15,
    r.attribute_16,
    r.attribute_17,
    r.attribute_18,
    r.attribute_19,
    r.attribute_20,
    r.attribute_21,
    r.attribute_22,
    r.attribute_23,
    r.attribute_24,
    r.attribute_25,
    --
    r.LAST_UPDATED_BY                    last_updated_by,
    r.LAST_UPDATED_ON                    last_updated_on,
    r.PLUG_COMMENT                       component_comment,
    r.id                                 region_id,
    r.master_region_id,
    --
    (select count(*) from wwv_flow_step_items where r.id = ITEM_PLUG_ID and r.flow_id = flow_id) items,
    (select count(*) from wwv_flow_step_buttons where r.id = button_plug_id and r.flow_id = flow_id) buttons,
     --
     region_name||'.'||
     lpad(r.plug_display_sequence,5,'00000')
     ||',c='||r.PLUG_DISPLAY_column
     ||',temp='||nvl(decode(nvl(r.PLUG_TEMPLATE,0),0,'No Template',(select PAGE_PLUG_TEMPLATE_NAME from wwv_flow_page_plug_templates where id = r.PLUG_TEMPLATE)),'No Template')
     ||',pos='||decode(r.PLUG_DISPLAY_POINT,
       'AFTER_HEADER',       'After Header',
       'BODY',               'Page Template Body',
       'BODY_1',             'Page Template Body (1)',
       'BODY_2',             'Page Template Body (2)',
       'BODY_3',             'Page Template Body (3)',
       'BEFORE_FOOTER',      'Before Footer',
       'REGION_POSITION_01', 'Page Template Region Position 1',
       'REGION_POSITION_02', 'Page Template Region Position 2',
       'REGION_POSITION_03', 'Page Template Region Position 3',
       'REGION_POSITION_04', 'Page Template Region Position 4',
       'REGION_POSITION_05', 'Page Template Region Position 5',
       'REGION_POSITION_06', 'Page Template Region Position 6',
       'REGION_POSITION_07', 'Page Template Region Position 7',
       'REGION_POSITION_08', 'Page Template Region Position 8',
       r.PLUG_DISPLAY_POINT)
     ||',type='||r.plug_source_type
     ||',src='||sys.dbms_lob.substr(r.PLUG_SOURCE,30,1)||'.'||sys.dbms_lob.getlength(r.PLUG_SOURCE)
     ||(select ',bo='||PATCH_NAME b from wwv_flow_patches where id=abs(r.REQUIRED_PATCH))
     ||nvl((select ',auth='||name n from wwv_flow_security_schemes where to_char(id) = ltrim(r.PLUG_REQUIRED_ROLE,'!') and flow_id = f.application_id),'Not found')
     ||decode(r.PAGINATION_DISPLAY_POSITION,
      'BOTTOM_LEFT','Bottom-L',
      'BOTTOM_RIGHT','Bottom-R',
      'TOP_LEFT','Top-L',
      'TOP_RIGHT','Top-R',
      'TOP_AND_BOTTOM_LEFT','Top+Bottom-L',
      'TOP_AND_BOTTOM_RIGHT','Top+Bottom-R',
      r.PAGINATION_DISPLAY_POSITION)
      ||r.PLUG_QUERY_NUM_ROWS_TYPE
      ||r.PLUG_DISPLAY_CONDITION_TYPE
      ||substr(r.PLUG_DISPLAY_WHEN_CONDITION,1,20)||'.'||length(r.PLUG_DISPLAY_WHEN_CONDITION)
      ||substr(r.PLUG_DISPLAY_WHEN_COND2,1,20)||'.'||length(r.PLUG_DISPLAY_WHEN_COND2)
      ||decode(
       r.BREAK_TYPE_FLAG,
       'REPEAT_HEADINGS_ON_BREAK_1','RepHead on Br',
       'DEFAULT_BREAK_FORMATTING','DefBreakFor',
       r.BREAK_TYPE_FLAG)
      ||decode(r.CSV_OUTPUT,'Y','Yes','N','No',r.CSV_OUTPUT)
      ||(select ',rtmp='||row_template_name t from wwv_flow_row_templates where id = r.PLUG_QUERY_ROW_TEMPLATE)
      ||decode(r.PLUG_QUERY_NUM_ROWS,null,null,'mr='||r.PLUG_QUERY_NUM_ROWS)
      ||r.BREAK_REPEAT_HEADING_FORMAT
      ||r.CSV_OUTPUT_LINK_TEXT
      ||substr(r.PRINT_URL,1,10)||length(r.PRINT_URL)
      ||length(PRINT_URL_LABEL)
      ||decode(r.TRANSLATE_TITLE,'Y','Yes','N','No','Yes')||
      length(PLUG_HEADER)||length(PLUG_FOOTER)
      ||r.PLUG_CUSTOMIZED
      ||length(r.PLUG_COLUMN_WIDTH)
      ||substr(r.region_name,1,15)
      ||length(REGION_ATTRIBUTES_SUBSTITUTION)
     component_signature,
     list_id,
     menu_id breadcrumb_id
from wwv_flow_page_plugs r,
     wwv_flow_steps      p,
     wwv_flow_authorized f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and f.workspace_id      = r.security_group_id
  and f.application_id    = r.flow_id
  and p.security_group_id = r.security_group_id
  and p.flow_id           = r.flow_id
  and p.id                = r.page_id
/



comment on table  apex_application_page_regions                               is 'Identifies a content container associated with a Page and displayed within a position defined by the Page Template';
comment on column apex_application_page_regions.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_regions.workspace_display_name        is 'Display name for the workspace';
comment on column apex_application_page_regions.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_regions.application_name              is 'Identifies the application';
comment on column apex_application_page_regions.page_id                       is 'Identifies the application';
comment on column apex_application_page_regions.page_name                     is 'Identifies a page within an application';
comment on column apex_application_page_regions.REGION_NAME                   is 'Identifies the Region Name.  The display of the region name is controlled by the Region Template substitution string TITLE.';
comment on column apex_application_page_regions.parent_region_id              is 'Identifies the region id of the parent region';
comment on column apex_application_page_regions.parent_region_name            is 'Identifies the parent region';
comment on column apex_application_page_regions.filtered_region_id            is 'Identifies the id of the region filtered by this faceted search region';
comment on column apex_application_page_regions.TEMPLATE                      is 'Identifies the template used to display the region';
comment on column apex_application_page_regions.TEMPLATE_ID                   is 'Foreign Key';
comment on column apex_application_page_regions.DISPLAY_SEQUENCE              is 'Identifies the Display Sequence of the Region within each Display Position';
comment on column apex_application_page_regions.region_css_classes            is 'Additional CSS classes which are substituted if the region template contains the substitution string #REGION_CSS_CLASSES#';
comment on column apex_application_page_regions.region_css_classes            is 'Additional CSS classes which are used to display a region icon';
comment on column apex_application_page_regions.region_sub_css_classes        is 'Additional CSS classes which are substituted if the report, list or meny template contains the substitution string #[REPORT/LIST/MENU]_CSS_CLASSES#';
comment on column apex_application_page_regions.region_template_options       is 'Identifies template options to be applied to the region template';
comment on column apex_application_page_regions.component_template_options    is 'Identifies template options to be applied to the component template';
comment on column apex_application_page_regions.REGION_ATTRIBUTES_SUBSTITUTION is 'Identifies text to be substituted by the region template #REGION_ATTRIBUTES# substituion string';
comment on column apex_application_page_regions.ESCAPE_ON_HTTP_OUTPUT         is 'If Yes values will be escaped when they are written to the HTTP output.';
comment on column apex_application_page_regions.new_grid                      is 'Identifies if the rendering of region begins on a new grid';
comment on column apex_application_page_regions.new_grid_row                  is 'Identifies if the rendering of region begins on a new grid row';
comment on column apex_application_page_regions.new_grid_column               is 'Identifies if the rendering of region begins on a new grid column';
comment on column apex_application_page_regions.grid_column                   is 'Identifies the grid column used to display the region';
comment on column apex_application_page_regions.grid_column_span              is 'Identifies over how many grid columns the item spans';
comment on column apex_application_page_regions.grid_column_css_classes       is 'Additional CSS classes which are substituted if the grid column template contains the substitution string #CSS_CLASSES#';
comment on column apex_application_page_regions.grid_column_attributes        is 'Additional attributes which are substituted if the grid column template contains the substitution string #ATTRIBUTES#';
comment on column apex_application_page_regions.DISPLAY_POSITION              is 'Identifies the position within the Page Template that the Region will be displayed';
comment on column apex_application_page_regions.DISPLAY_POSITION_CODE         is 'Identifies the coded value of the position within the Page Template that the Region will be displayed';
comment on column apex_application_page_regions.DISPLAY_ITEM_POSITION         is 'Identifies if page items should be rendered before or after the region content';
comment on column apex_application_page_regions.DISPLAY_ITEM_POSITION_CODE    is 'Identifies the internal code of DISPLAY_ITEM_POSITION';
comment on column apex_application_page_regions.REGION_SOURCE                 is 'Identifies the source of the region, reference Region Source Type';
comment on column apex_application_page_regions.location_code                 is 'Identifies the internal code of LOCATION';
comment on column apex_application_page_regions.location                      is 'Identifies whether the data source of the region is the local database, a remote database or a web source module';
comment on column apex_application_page_regions.query_type_code               is 'Identifies the internal code of QUERY_TYPE';
comment on column apex_application_page_regions.query_type                    is 'Identifies whether the region data comes from a table, a SQL query or a PL/SQL function returning a SQL query';
comment on column apex_application_page_regions.table_owner                   is 'Denotes the table owner for TABLE query types';
comment on column apex_application_page_regions.table_name                    is 'Denotes the table name for TABLE query types';
comment on column apex_application_page_regions.where_clause                  is 'Identifies the WHERE clause provided by the developer and to be applied to TABLE or WEB SOURCE data sources.';
comment on column apex_application_page_regions.order_by_clause               is 'Identifies the ORDER BY clause provided by the developer and to be applied to TABLE or WEB SOURCE data sources';
comment on column apex_application_page_regions.source_post_processing        is 'Identifies type of SQL post processing for data from external data sources';
comment on column apex_application_page_regions.include_rowid_column          is 'Identifies if the pseudo column ROWID should be selected';
comment on column apex_application_page_regions.optimizer_hint                is 'Optimizer hint which is added to the region source SQL statement when it is executed';
comment on column apex_application_page_regions.remote_database_id            is 'Identifies the primary key of the remote database definition';
comment on column apex_application_page_regions.remote_database_name          is 'Identifies the name of the remote database';
comment on column apex_application_page_regions.web_source_module_id          is 'Identifies the primary key of the web source module';
comment on column apex_application_page_regions.web_source_module_name        is 'Identifies the web source module name';
comment on column apex_application_page_regions.external_filter_expr          is 'Filter expression to send to the external data source';
comment on column apex_application_page_regions.external_order_by_expr        is 'Order By expression to send to the external data source';
comment on column apex_application_page_regions.is_editable                    is  'Identifies if end users can edit this region';
comment on column apex_application_page_regions.edit_operations                is  'Identifies if data can be updated, inserted, or deleted';
comment on column apex_application_page_regions.edit_row_operations_column     is  'A column where the column value can contain U (update) and or D (delete) to indicate if the row can be updated or deleted';
comment on column apex_application_page_regions.add_authorization_scheme       is  'Authorization scheme to restrict who can add rows';
comment on column apex_application_page_regions.add_authorization_scheme_id    is  'Identifies the internal code of ADD_AUTHORIZATION_SCHEME';
comment on column apex_application_page_regions.update_authorization_scheme    is  'Authorization scheme to restrict who can update rows';
comment on column apex_application_page_regions.update_authorization_scheme_id is  'Identifies the internal code of UPDATE_AUTHORIZATION_SCHEME';
comment on column apex_application_page_regions.delete_authorization_scheme    is  'Authorization scheme to restrict who can delete rows';
comment on column apex_application_page_regions.delete_authorization_scheme_id is  'Identifies the internal code of DELETE_AUTHORIZATION_SCHEME';
comment on column apex_application_page_regions.lost_update_check_type         is  'Identifies how to protect data against lost updates';
comment on column apex_application_page_regions.lost_update_check_type_code    is  'Identifies the internal code of LOST_UPDATE_CHECK_TYPE';
comment on column apex_application_page_regions.row_version_column             is  'A column to use as lost update check';
comment on column apex_application_page_regions.add_row_if_empty               is  'Identifies whether to add a new row if the region is empty';
comment on column apex_application_page_regions.lazy_loading                   is  'Identifies whether to defer getting initial set of data from the server until needed';
comment on column apex_application_page_regions.LIST_TEMPLATE_OVERRIDE        is 'Identifies the List Template to be used to display regions of type List.  By default the List Template is defined in the List definition, if a value is specified in this attribute, this template will be used to render the List.';
comment on column apex_application_page_regions.SOURCE_TYPE                   is 'Identifies how APEX will interpret the Region Source';
comment on column apex_application_page_regions.SOURCE_TYPE_CODE              is 'Deprecated internal code of SOURCE_TYPE. Use SOURCE_TYPE_PLUGIN_NAME instead.';
comment on column apex_application_page_regions.source_type_plugin_name       is 'Name of the plugin that implements the region. Names of built-in plugins start with "NATIVE_", application specific plugin names start with "PLUGIN_"';
comment on column apex_application_page_regions.AUTHORIZATION_SCHEME          is 'An authorization scheme must evaluate to TRUE in order for this component to be displayed';
comment on column apex_application_page_regions.AUTHORIZATION_SCHEME_ID       is 'Foreign Key';
comment on column apex_application_page_regions.CONDITION_TYPE                is 'Identifies the condition type used to conditionally display the region';
comment on column apex_application_page_regions.CONDITION_TYPE_CODE           is 'Identifies the internal code of CONDITION_TYPE';
comment on column apex_application_page_regions.CONDITION_EXPRESSION1         is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_regions.CONDITION_EXPRESSION2         is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_regions.read_only_condition_type      is 'Identifies the condition type when all items of the region will be rendered read only';
comment on column apex_application_page_regions.read_only_condition_type_code is 'Identifies the internal code of read_only_condition_type';
comment on column apex_application_page_regions.read_only_condition_exp1      is 'Identifies the condition that determines if all items of the region will be rendered read only';
comment on column apex_application_page_regions.read_only_condition_exp2      is 'Identifies the condition that determines if all items of the region will be rendered read only';
comment on column apex_application_page_regions.REPORT_TEMPLATE               is 'Report templates provide control over the results of a row from your SQL query';
comment on column apex_application_page_regions.MAXIMUM_ROWS_TO_QUERY         is 'Specifies the maximum rows that can be retuned by a given query.  Avoids attempting to send millions of rows to a web browser.';
comment on column apex_application_page_regions.PAGINATION_SCHEME             is 'Pagination provides the user with information about the number of rows and the current position within the result set. Pagination also defines the style of links or buttons that are used to navigate to the next or previous page.';
comment on column apex_application_page_regions.PAGINATION_DISPLAY_POSITION   is 'Pagination can be displayed on the left side, right side, at the bottom, or above the report.';
comment on column apex_application_page_regions.AJAX_ENABLED                  is 'Specifies if the region is ajax enabled.';
comment on column apex_application_page_regions.AJAX_ITEMS_TO_SUBMIT          is 'Identifies the page items which should be submitted when an Ajax call is performed for the region.';
comment on column apex_application_page_regions.NUMBER_OF_ROWS_ITEM           is 'Defines the maximum number of rows to display per page.';
comment on column apex_application_page_regions.NO_DATA_FOUND_MESSAGE         is 'Defines the text message that displays when the query does not return any rows.';
comment on column apex_application_page_regions.MORE_DATA_FOUND_MESSAGE       is 'Defines the text message that displays when more rows exist.';
comment on column apex_application_page_regions.MAXIMUM_ROW_COUNT             is 'Defines the maximum number of rows to query, relevant for pagination schemes which display "Rows X - Y of Z".  Counting fewer rows can improve performance and counting thousands of rows can degrade performance.';
comment on column apex_application_page_regions.REPORT_NULL_VALUES_AS         is 'Identifies the text to display for null columns. The default value is "(null)".';
comment on column apex_application_page_regions.BREAKS                        is 'Identifies how breaks should be formatted.';
comment on column apex_application_page_regions.ASCENDING_IMAGE               is 'Defines the image shown in report headings to sort column values in ascending order.';
comment on column apex_application_page_regions.ASCENDING_IMAGE_ATTRIBUTES    is 'Image attributes for sort images used to define attributes such width and height of image.';
comment on column apex_application_page_regions.DESCENDING_IMAGE              is 'Defines the image shown in report headings to sort column values in descending order.';
comment on column apex_application_page_regions.DESCENDING_IMAGE_ATTRIBUTES   is 'Image attributes for sort images used to define attributes such width and height of image.';
comment on column apex_application_page_regions.FILENAME                      is 'Specify a name for the export file. If no name is specified, the region name is used followed by the extension .csv.';
comment on column apex_application_page_regions.SEPARATOR                     is 'Identifies a column separator. If no value is entered, a comma or semicolon is used depending on your current NLS settings.';
comment on column apex_application_page_regions.ENCLOSED_BY                   is 'Identifies a delimiter character. This character is used to delineate the starting and ending boundary of a data value. Default delimiter is double quotes.';

comment on column apex_application_page_regions.static_id                     is 'Reference this value using the substitution string #REGION_STATIC_ID#';
comment on column apex_application_page_regions.rest_enabled                  is 'Identifies whether the region can be accessed via a RESTful call';
comment on column apex_application_page_regions.headings_type                 is 'Identifies the how report column headings are computed';
comment on column apex_application_page_regions.report_column_headings        is 'Report column heading override, can be used to define dynamic report column headings';
comment on column apex_application_page_regions.customization                 is 'Identifies level of customization support for this page region';
comment on column apex_application_page_regions.customization_name            is 'Name of region to show in popup customization window';
comment on column apex_application_page_regions.list_template_override_id     is 'Foreign key of list template override';
comment on column apex_application_page_regions.HTML_table_cell_attributes    is 'When generating HTML to display items use these HTML table cell attributes';

comment on column apex_application_page_regions.max_dynamic_report_cols       is 'Maximum number of dynamic report columns';
comment on column apex_application_page_regions.report_column_source_type     is 'Determines how report columns will be computed, values include DERIVED_REPORT_COLUMNS and GENERIC_REPORT_COLUMNS';
comment on column apex_application_page_regions.break_display_text            is 'Text displayed on control breaks';
comment on column apex_application_page_regions.STRIP_HTML                    is 'Specifies whether or not to remove HTML tags from the original column values for HTML expressions, column links and report data exported as CSV files.';
comment on column apex_application_page_regions.BUILD_OPTION                  is 'Region will be displayed if the Build Option is enabled';
comment on column apex_application_page_regions.BUILD_OPTION_ID               is 'Foreign Key';
comment on column apex_application_page_regions.SUM_DISPLAY_TEXT              is 'Display this text when printing report sums';
comment on column apex_application_page_regions.BEFORE_BREAK_DISPLAY_TEXT     is 'Defines the text that displays before break columns when displaying a break row.';
comment on column apex_application_page_regions.BREAK_COLUMN_DISPLAY_TEXT     is 'Defines the column template to use when displaying a column break. Use #COLUMN_VALUE# substitutions.';
comment on column apex_application_page_regions.AFTER_BREAK_DISPLAY_TEXT      is 'Defines the text that displays after break columns when displaying a break row.';
comment on column apex_application_page_regions.REPEAT_HEADING_BREAK_FORMAT   is 'Defines the heading template for repeating headings on column 1. Use #COLUMN_VALUE# substitutions.';
comment on column apex_application_page_regions.ENABLE_CSV_OUTPUT             is 'Enables the query results to be spooled to a CSV file. To enable this option, you must use a report template with a #CSV_LINK# substitution string and set this option to YES.';
comment on column apex_application_page_regions.CSV_LINK_LABEL                is 'Specifies the text for the link which will invoke the CSV download.';
comment on column apex_application_page_regions.URL                           is 'Specifies the URL to a server for post processing of a report. See documentation for instructions.';
comment on column apex_application_page_regions.LINK_LABEL                    is 'Specifies the text for the link which will invoke the external processing engine.';
comment on column apex_application_page_regions.TRANSLATE_REGION_TITLE        is 'Identifies if this region title should be a candidate for translation or not (Yes or No)';
comment on column apex_application_page_regions.break_display_flag            is 'Identify how you would like your breaks to be displayed';
comment on column apex_application_page_regions.COMPONENT_COMMENT             is 'Developer comment';
comment on column apex_application_page_regions.REGION_ID                     is 'Primary Key of this Region';
comment on column apex_application_page_regions.master_region_id              is 'Associated master region to identify master detail relationship';
comment on column apex_application_page_regions.ITEMS                         is 'Count of Items corresponding to this region';
comment on column apex_application_page_regions.BUTTONS                       is 'Count of Buttons corresponding to this region';
comment on column apex_application_page_regions.last_updated_by               is 'APEX developer who made last update';
comment on column apex_application_page_regions.last_updated_on               is 'Date of last update';
comment on column apex_application_page_regions.region_caching                is 'Identifies caching method';
comment on column apex_application_page_regions.timeout_cache_after           is 'Identify how long a cached region will remain valid in seconds';
comment on column apex_application_page_regions.cache_when                    is 'Identifies a condition must be true for the region to be cached or to render from cache';
comment on column apex_application_page_regions.cache_when_expression_1       is 'Identifies expression corresponding to Cache When condition';
comment on column apex_application_page_regions.cache_when_expression_2       is 'Identifies expression corresponding to Cache When condition';
comment on column apex_application_page_regions.cache_depends_on_items        is 'Identifies items that the cached content depends on';
comment on column apex_application_page_regions.component_signature           is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_page_regions.breadcrumb_template           is 'Identifies breadcrumb template';
comment on column apex_application_page_regions.breadcrumb_template_id        is 'Identifies breadcrumb template ID';
comment on column apex_application_page_regions.report_template_id            is 'Identifies report template ID';

comment on column apex_application_page_regions.init_javascript_code          is 'JavaScript code for region initialization';

comment on column apex_application_page_regions.attribute_01                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_02                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_03                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_04                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_05                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_06                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_07                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_08                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_09                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_10                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_11                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_12                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_13                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_14                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_15                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_16                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_17                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_18                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_19                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_20                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_21                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_22                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_23                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_24                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.attribute_25                  is 'Dynamic attribute to store additional data';
comment on column apex_application_page_regions.list_id                       is 'Associated list, if region is of type list.  Can be joined to APEX_APPLICATION_LISTS.';
comment on column apex_application_page_regions.breadcrumb_id                 is 'Associated breadcrumb, if region is of type breadcrumb.  Can be joined to APEX_APPLICATION_BREADCRUMBS.';
comment on column apex_application_page_regions.fixed_header                  is 'Identifies if the report has a fixed header, and if so where it is fixed to (Page or Region)';
comment on column apex_application_page_regions.fixed_header_max_height       is 'For reports with a header fixed to Region, this identifies the maximum height';



create or replace view apex_application_page_rpt
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                                 page_id,
    p.name                               page_name,
    --
    r.plug_name                          region_name,
    decode(r.PLUG_SOURCE_TYPE,
        'NATIVE_SQL_REPORT','Report',
        'NATIVE_TABFORM','Tabular Form',
        'NATIVE_IR','Interactive Report') source_type,
    r.supplemental_text                       supplemental_text,
    PRN_BODY_BG_COLOR                         body_background_color,
    PRN_BODY_FONT_COLOR                       body_font_color,
    PRN_BODY_FONT_FAMILY                      body_font_family,
    PRN_BODY_FONT_SIZE                        body_font_size,
    PRN_BODY_FONT_WEIGHT                      body_font_weight,
    PRN_BORDER_COLOR                          border_color,
    PRN_BORDER_WIDTH                          border_width,
    PRN_FORMAT                                format,
    PRN_FORMAT_ITEM                           format_item,
    PRN_PAGE_HEADER                           page_header,
    PRN_PAGE_HEADER_ALIGNMENT                 page_header_alignment,
    PRN_PAGE_HEADER_FONT_COLOR                page_header_font_color,
    PRN_PAGE_HEADER_FONT_FAMILY               page_header_font_family,
    PRN_PAGE_HEADER_FONT_SIZE                 page_header_font_size,
    PRN_PAGE_HEADER_FONT_WEIGHT               page_header_font_weight,
    PRN_HEADER_BG_COLOR                       header_background_color,
    PRN_HEADER_FONT_COLOR                     header_font_color,
    PRN_HEADER_FONT_FAMILY                    header_font_family,
    PRN_HEADER_FONT_SIZE                      header_font_size,
    PRN_HEADER_FONT_WEIGHT                    header_font_weight,
    PRN_HEIGHT                                height,
    PRN_ORIENTATION                           orientation,
    PRN_OUTPUT                                output,
    prn_print_server_overwrite                print_server_override,
    PRN_OUTPUT_FILE_NAME                      output_file_name,
    prn_content_disposition                   content_disposition,
    prn_document_header                       document_header,
    PRN_OUTPUT_LINK_TEXT                      output_link_text,
    PRN_OUTPUT_SHOW_LINK                      show_output_link,
    PRN_PAGE_FOOTER                           footer,
    PRN_PAGE_FOOTER_ALIGNMENT                 footer_alignment,
    PRN_PAGE_FOOTER_FONT_COLOR                footer_font_color,
    PRN_PAGE_FOOTER_FONT_FAMILY               footer_font_family,
    PRN_PAGE_FOOTER_FONT_SIZE                 footer_font_size,
    PRN_PAGE_FOOTER_FONT_WEIGHT               footer_font_weight,
    --
    PRN_PAPER_SIZE                            paper_size,
    PRN_TEMPLATE_ID                           template_id,
    component_template_options                component_template_options,
    PRN_UNITS                                 paper_size_units,
    prn_width_units                           paper_size_width_units,
    PRN_WIDTH                                 paper_size_width,
    --
    r.LAST_UPDATED_BY                    last_updated_by,
    r.LAST_UPDATED_ON                    last_updated_on,
    r.PLUG_COMMENT                       component_comment,
    r.id                                 region_id,
    --
     region_name||'.'
     ||PRN_BODY_BG_COLOR
     ||PRN_BODY_FONT_COLOR
     ||PRN_BODY_FONT_FAMILY
     ||PRN_BODY_FONT_SIZE
     ||PRN_BODY_FONT_WEIGHT
     ||PRN_BORDER_COLOR
     ||PRN_BORDER_WIDTH
     ||length(PRN_FORMAT)
     ||PRN_FORMAT_ITEM
     ||length(PRN_PAGE_HEADER)
     ||PRN_PAGE_HEADER_ALIGNMENT
     ||PRN_PAGE_HEADER_FONT_COLOR
     ||PRN_PAGE_HEADER_FONT_FAMILY
     ||PRN_PAGE_HEADER_FONT_SIZE
     ||PRN_PAGE_HEADER_FONT_WEIGHT
     ||PRN_HEADER_BG_COLOR
     ||PRN_HEADER_FONT_COLOR
     ||PRN_HEADER_FONT_FAMILY
     ||PRN_HEADER_FONT_SIZE
     ||PRN_HEADER_FONT_WEIGHT
     ||PRN_HEIGHT
     ||PRN_ORIENTATION
     ||PRN_OUTPUT
     ||PRN_OUTPUT_FILE_NAME
     ||PRN_CONTENT_DISPOSITION
     ||PRN_DOCUMENT_HEADER
     ||PRN_UNITS
     ||PRN_OUTPUT_LINK_TEXT
     ||PRN_OUTPUT_SHOW_LINK
     ||length(PRN_PAGE_FOOTER)
     ||PRN_PAGE_FOOTER_ALIGNMENT
     ||PRN_PAGE_FOOTER_FONT_COLOR
     ||PRN_PAGE_FOOTER_FONT_FAMILY
     ||PRN_PAGE_FOOTER_FONT_SIZE
     ||PRN_PAGE_FOOTER_FONT_WEIGHT
     ||PRN_PAPER_SIZE
     ||PRN_TEMPLATE_ID
     ||PRN_UNITS
     ||PRN_WIDTH
     component_signature
from wwv_flow_page_plugs r,
     wwv_flow_steps      p,
     wwv_flow_authorized f
where f.workspace_id      =  p.security_group_id
  and f.application_id    =  p.flow_id
  and p.security_group_id =  r.security_group_id
  and p.flow_id           =  r.flow_id
  and p.id                =  r.page_id
  and r.PLUG_SOURCE_TYPE  in ('NATIVE_SQL_REPORT', 'NATIVE_TABFORM', 'NATIVE_IR')
/
comment on table  apex_application_page_rpt                  is 'Printing attributes for regions that are reports';
comment on column apex_application_page_rpt.workspace        is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_rpt.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_page_rpt.application_id   is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_rpt.application_name is 'Identifies the application';
comment on column apex_application_page_rpt.page_id          is 'Identifies the application';
comment on column apex_application_page_rpt.page_name        is 'Identifies a page within an application';
comment on column apex_application_page_rpt.REGION_NAME      is 'Identifies the Region Name.  The display of the region name is controlled by the Region Template substitution string TITLE.';
comment on column apex_application_page_rpt.supplemental_text          is 'Identifies text at the top of all download formats.';
comment on column apex_application_page_rpt.component_template_options is 'Identifies template options to be applied to the component template';
comment on column apex_application_page_rpt.component_signature        is 'Identifies attributes defined at a given component level to facilitate application comparisons';




create or replace view apex_application_page_rpt_cols
as
select
     f.workspace,
     f.workspace_display_name,
     f.application_id,
     f.application_name,
     p.id                                  page_id,
     p.name                                page_name,
     region.plug_Name                      region_name,
     --
     --r.QUERY_COLUMN_ID                     ,
     --r.FORM_ELEMENT_ID                     ,
     r.COLUMN_ALIAS                        column_alias,
     r.static_id                           static_id,
     case substr(r.display_as, 1, 7)
       when 'NATIVE_' then
           ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = 'REPORT COLUMN TYPE' and name = substr(r.display_as, 8) )
       when 'PLUGIN_' then
           ( select display_name from wwv_flow_plugins where flow_id = p.flow_id and plugin_type = 'REPORT COLUMN TYPE' and name = substr(r.display_as, 8) )
       else
           case r.display_as
             when 'WITHOUT_MODIFICATION'   then 'Standard Report Column'
             when 'TEXT_FROM_LOV'          then 'Display as Text (based on LOV, does not save state)'
             when 'DISPLAY_AND_SAVE'       then 'Display as Text (saves state)'
             when 'ESCAPE_SC'              then 'Display as Text (escape special characters, does not save state)'
             when 'DATE_POPUP'             then 'Date Picker'
             when 'TEXT'                   then 'Text Field'
             when 'TEXTAREA'               then 'Text Area'
             when 'SELECT_LIST'            then 'Select List (static LOV)'
             when 'SELECT_LIST_FROM_LOV'   then 'Select List (named LOV)'
             when 'SELECT_LIST_FROM_QUERY' then 'Select List (query based LOV)'
             when 'HIDDEN'                 then 'Hidden'
             when 'POPUP'                  then 'Popup LOV (named LOV)'
             when 'POPUP_QUERY'            then 'Popup LOV (query based LOV)'
             else r.display_as
         end
     end                                   display_as,
     r.display_as                          display_as_code,
     r.COLUMN_DISPLAY_SEQUENCE             display_sequence,
     r.COLUMN_HEADING                      heading,
     r.USE_AS_ROW_HEADER                   use_as_row_header,
     r.COLUMN_FORMAT                       format_mask,
     r.COLUMN_HTML_EXPRESSION              html_expression,
     r.COLUMN_CSS_CLASS                    css_class,
     r.COLUMN_CSS_STYLE                    css_style,
     r.COLUMN_HIT_HIGHLIGHT                highlight_words,
     --
     r.COLUMN_LINK                         column_link_url,
     r.COLUMN_LINKTEXT                     column_link_text,
     r.COLUMN_LINK_ATTR                    column_link_attributes,
     --
     r.COLUMN_LINK_CHECKSUM_TYPE           page_checksum,
     --
     r.COLUMN_ALIGNMENT                    column_alignment,
     r.HEADING_ALIGNMENT                   heading_alignment,
     --
     r.DEFAULT_SORT_COLUMN_SEQUENCE        default_sort_sequence,
     r.DEFAULT_SORT_DIR                    default_sort_direction,
     decode(r.DISABLE_SORT_COLUMN,
       'Y','Yes','N','No',
       r.DISABLE_SORT_COLUMN)              sortable_column,
     decode(r.SUM_COLUMN,
       'Y','Yes','N','No',
       r.SUM_COLUMN)                       sum_column,
     decode(r.HIDDEN_COLUMN ,
       'Y','Yes','N','No',
       r.HIDDEN_COLUMN )                   column_is_hidden,
     --
     r.DISPLAY_WHEN_COND_TYPE              condition_type,
     r.display_when_cond_type              condition_type_code,
     r.DISPLAY_WHEN_CONDITION              condition_expression1,
     r.DISPLAY_WHEN_CONDITION2             condition_expression2,
     --
     decode((select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV),null,null,
      (select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV))             named_list_of_values,
     r.INLINE_LOV                          inline_list_of_values,
     decode(r.LOV_SHOW_NULLS,
       'YES','Yes','NO','No',
       r.LOV_SHOW_NULLS)                   LOV_SHOW_NULLS,
     decode(r.LOV_DISPLAY_EXTRA,
       'YES','Yes','NO','No',
       r.LOV_DISPLAY_EXTRA)                LOV_DISPLAY_EXTRA_VALUES,
     r.LOV_NULL_TEXT                       lov_null_text,
     r.LOV_NULL_VALUE                      lov_null_value,
     --
     r.COLUMN_WIDTH                        form_element_width,
     r.COLUMN_HEIGHT                       form_element_height,
     r.css_classes                         form_element_css_classes,
     r.CATTRIBUTES                         form_Element_Attributes,
     r.CATTRIBUTES_ELEMENT                 form_Element_Option_Attributes,
     (select template_name
      from   wwv_flow_field_templates
      where  id = to_char(r.COLUMN_FIELD_TEMPLATE)
      and    flow_id = f.application_id)               column_field_template,
     r.COLUMN_FIELD_TEMPLATE               column_field_template_id,
     case
       when r.is_required = 'Y' then 'Yes'
       else 'No'
     end                                   is_required,
     nvl(r.standard_validations, 'Application Level Setting') standard_validations,
     --
     r.attribute_01,
     r.attribute_02,
     r.attribute_03,
     r.attribute_04,
     r.attribute_05,
     r.attribute_06,
     r.attribute_07,
     r.attribute_08,
     r.attribute_09,
     r.attribute_10,
     r.attribute_11,
     r.attribute_12,
     r.attribute_13,
     r.attribute_14,
     r.attribute_15,
     --
     --r.COLUMN_COMMENT                      ,
     r.PK_COL_SOURCE_TYPE                  primary_key_column_source_type,
     r.PK_COL_SOURCE                       primary_key_column_source,
     decode(r.DERIVED_COLUMN,
       'Y','Yes',
        r.DERIVED_COLUMN)                  derived_column,
     --
     r.COLUMN_DEFAULT                      column_default,
     r.COLUMN_DEFAULT_TYPE                 column_default_type,
     --
     r.REF_SCHEMA                          reference_schema,
     r.REF_TABLE_NAME                      reference_table_name,
     r.REF_COLUMN_NAME                     reference_column_name,
     --
     decode(substr(r.REPORT_COLUMN_REQUIRED_ROLE,1,1),'!','Not ')||
     nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(r.REPORT_COLUMN_REQUIRED_ROLE,'!')
     and    flow_id = f.application_id),
            r.REPORT_COLUMN_REQUIRED_ROLE)
                                           authorization_scheme,
     r.REPORT_COLUMN_REQUIRED_ROLE         authorization_scheme_id,
     --
     decode(include_in_export,'Y','Yes','N','No') include_in_export,
     print_col_width                       print_column_width,
     print_col_align                       print_column_alignment,
     report_column_width                   report_column_width,
     --
     (select case when r.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
      from wwv_flow_patches
      where id=abs(r.REQUIRED_PATCH) )     build_option,
     r.required_patch                      build_option_id,
     COLUMN_COMMENT                        column_comment,
     --
     r.LAST_UPDATED_BY                     last_updated_by,
     r.LAST_UPDATED_ON                     last_updated_on,
     --
     region.id                             region_id,
     r.id                                  region_report_column_id,
     --
     substr(r.COLUMN_ALIAS,1,30)
     ||' s='||r.COLUMN_DISPLAY_SEQUENCE
     ||' h='||substr(r.COLUMN_HEADING,1,15)||length(r.COLUMN_HEADING)
     ||substr(r.COLUMN_FORMAT,1,15)||length(r.COLUMN_FORMAT)
     ||' e='||substr(r.COLUMN_HTML_EXPRESSION,1,15)||length(r.COLUMN_HTML_EXPRESSION)
     ||substr(r.COLUMN_CSS_CLASS,1,20)
     ||substr(r.COLUMN_CSS_STYLE,1,20)
     ||substr(r.COLUMN_HIT_HIGHLIGHT,1,15)||length(r.COLUMN_HIT_HIGHLIGHT)
     ||' l='||substr(r.COLUMN_LINK,1,20)||length(r.COLUMN_LINK)
     ||substr(r.COLUMN_LINKTEXT,1,15)||length(r.COLUMN_LINKTEXT)
     ||substr(r.COLUMN_LINK_ATTR,1,15)||length(r.COLUMN_LINK_ATTR)
     ||substr(r.COLUMN_LINK_CHECKSUM_TYPE,1,15)
     ||' a='||substr(r.COLUMN_ALIGNMENT,1,6)||substr(r.HEADING_ALIGNMENT,1,6)
     ||' s='||DEFAULT_SORT_COLUMN_SEQUENCE
     ||substr(DEFAULT_SORT_DIR,1,6)
     ||substr(r.DISABLE_SORT_COLUMN,1,10)
     ||substr(r.SUM_COLUMN,1,10)
     ||substr(r.HIDDEN_COLUMN,1,15)
     ||' c='||substr(r.DISPLAY_WHEN_COND_TYPE,1,20)
      ||substr(r.DISPLAY_WHEN_CONDITION,1,15)||length(r.DISPLAY_WHEN_CONDITION)
     ||substr(r.DISPLAY_WHEN_CONDITION2,1,15)||length(r.DISPLAY_WHEN_CONDITION2)
     ||' a='||substr(decode(substr(r.REPORT_COLUMN_REQUIRED_ROLE,1,1),'!','Not ')||
     nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(r.REPORT_COLUMN_REQUIRED_ROLE,'!')
     and    flow_id = f.application_id),
            'Not found'),1,30)
     ||' d='||substr(r.DISPLAY_AS,1,20)
     ||' l='||substr(decode((select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV),null,null,
      (select lov_name
      from wwv_flow_lists_of_values$
      where id = r.NAMED_LOV)),1,30)
     ||substr(r.INLINE_LOV,1,30)||substr(r.LOV_SHOW_NULLS,1,20)||substr(r.LOV_DISPLAY_EXTRA,1,6)||substr(r.LOV_NULL_VALUE,1,20)||r.COLUMN_WIDTH||r.COLUMN_HEIGHT
     ||' c='||substr(r.CATTRIBUTES,1,20)||length(r.CATTRIBUTES)
     ||' c='||substr(r.CATTRIBUTES_ELEMENT,1,20)||length(r.CATTRIBUTES_ELEMENT)
     ||' pk='||r.PK_COL_SOURCE_TYPE||sys.dbms_lob.substr(r.PK_COL_SOURCE,20,1)||sys.dbms_lob.getlength(r.PK_COL_SOURCE)
     ||' d='||substr(r.DERIVED_COLUMN,1,6)
     ||' d='||substr(r.COLUMN_DEFAULT,1,20)||length(r.COLUMN_DEFAULT)
     ||' t='||r.COLUMN_DEFAULT_TYPE||include_in_export||print_col_width||print_col_align
     ||' bo='||(select PATCH_NAME from wwv_flow_patches where id = abs(r.REQUIRED_PATCH))
     component_signature
from wwv_flow_region_report_column r,
     wwv_flow_page_plugs           region,
     wwv_flow_steps                p,
     wwv_flow_authorized           f
where f.workspace_id           =  p.security_group_id
  and f.application_id         =  p.flow_id
  and p.security_group_id      =  region.security_group_id
  and p.flow_id                =  region.flow_id
  and p.id                     =  region.page_id
  and region.security_group_id =  r.security_group_id
  and region.id                =  r.region_id
  and region.plug_source_type  != 'NATIVE_IG'
/

comment on table  apex_application_page_rpt_cols is 'Report column definitions used for report regions';
comment on column apex_application_page_rpt_cols.workspace                        is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_rpt_cols.workspace_display_name           is 'Display name for the workspace';
comment on column apex_application_page_rpt_cols.application_id                   is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_rpt_cols.application_name                 is 'Identifies the application';
comment on column apex_application_page_rpt_cols.page_id                          is 'Identifies the application';
comment on column apex_application_page_rpt_cols.page_name                        is 'Identifies a page within an application';
comment on column apex_application_page_rpt_cols.REGION_NAME                      is 'Report region name';
comment on column apex_application_page_rpt_cols.COLUMN_ALIAS                     is 'SQL query column alias';
comment on column apex_application_page_rpt_cols.STATIC_ID                        is 'Identifies the Static ID of the column';
comment on column apex_application_page_rpt_cols.DISPLAY_SEQUENCE                 is 'Identifies the sequence in the report that this column is to be displayed';
comment on column apex_application_page_rpt_cols.HEADING                          is 'Report column heading';
comment on column apex_application_page_rpt_cols.USE_AS_ROW_HEADER                is 'Identifies if the current column value should be used as row header in label';
comment on column apex_application_page_rpt_cols.FORMAT_MASK                      is 'Number or Date format mask';
comment on column apex_application_page_rpt_cols.HTML_EXPRESSION                  is 'HTML column template used to display this column';
comment on column apex_application_page_rpt_cols.CSS_CLASS                        is 'Use this CSS class in the HTML TD tag when displaying this report column';
comment on column apex_application_page_rpt_cols.CSS_STYLE                        is 'Use this CSS style in the HTML TD tag when displaying this report column';
comment on column apex_application_page_rpt_cols.HIGHLIGHT_WORDS                  is 'Identify keywords to highlight, for example "&P1_SEARCH."';
comment on column apex_application_page_rpt_cols.COLUMN_LINK_URL                  is 'URL target of report column';
comment on column apex_application_page_rpt_cols.COLUMN_LINK_TEXT                 is 'Text displayed for linked columns';
comment on column apex_application_page_rpt_cols.COLUMN_LINK_ATTRIBUTES           is 'HTML "A" tag attributes';
comment on column apex_application_page_rpt_cols.PAGE_CHECKSUM                    is 'An appropriate checksum when linking to protected pages';
comment on column apex_application_page_rpt_cols.COLUMN_ALIGNMENT                 is 'Report column alignment';
comment on column apex_application_page_rpt_cols.HEADING_ALIGNMENT                is 'Report heading alignment';
comment on column apex_application_page_rpt_cols.DEFAULT_SORT_SEQUENCE            is 'For reports with column heading sorting, identifies the default sort order';
comment on column apex_application_page_rpt_cols.DEFAULT_SORT_DIRECTION           is 'Default sort direction, ascending or descending';
comment on column apex_application_page_rpt_cols.SORTABLE_COLUMN                  is 'Identifies if the column is column heading sortable';
comment on column apex_application_page_rpt_cols.SUM_COLUMN                       is 'Identifies if this column is to be summed';
comment on column apex_application_page_rpt_cols.COLUMN_IS_HIDDEN                 is 'Identifies the column as hidden, the values will be returned to the browser but they will not be displayed.';
comment on column apex_application_page_rpt_cols.CONDITION_TYPE                   is 'Identifies the condition type used to conditionally display this Report Column';
comment on column apex_application_page_rpt_cols.CONDITION_TYPE_CODE              is 'Identifies the internal code of CONDITION_TYPE';
comment on column apex_application_page_rpt_cols.CONDITION_EXPRESSION1            is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_rpt_cols.CONDITION_EXPRESSION2            is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_rpt_cols.AUTHORIZATION_SCHEME             is 'An authorization scheme must evaluate to TRUE in order for this component to be displayed';
comment on column apex_application_page_rpt_cols.AUTHORIZATION_SCHEME_ID          is 'Foreign Key';
comment on column apex_application_page_rpt_cols.LAST_UPDATED_BY                  is 'APEX User Name that last updated this report column';
comment on column apex_application_page_rpt_cols.LAST_UPDATED_ON                  is 'Date of last update';
comment on column apex_application_page_rpt_cols.DISPLAY_AS                       is 'Identifies how the report column is to be displayed';
comment on column apex_application_page_rpt_cols.display_as_code                  is 'Internal code of DISPLAY_AS';
comment on column apex_application_page_rpt_cols.report_column_width              is 'Width of a report column in pixels (px).  Requires #COLUMN_WIDTH# substitution in report template.';
comment on column apex_application_page_rpt_cols.NAMEd_LIST_OF_VALUES             is 'Identifies the Shared List of Values to be used to display this report column';
comment on column apex_application_page_rpt_cols.INLINE_LIST_OF_VALUES            is 'Identifies an inline List of Values to display this column value';
comment on column apex_application_page_rpt_cols.LOV_SHOW_NULLS                   is 'For column "Display As" ';
comment on column apex_application_page_rpt_cols.LOV_DISPLAY_EXTRA_VALUES         is 'Identifies if the column value is to be displayed if the List of Values domain does not include the column value.';
comment on column apex_application_page_rpt_cols.LOV_NULL_TEXT                    is 'Identifies the text to be displayed for a null value';
comment on column apex_application_page_rpt_cols.LOV_NULL_VALUE                   is 'Identifies the text to be returned for a null value';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_WIDTH               is 'For form elements, identifies the element width';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_HEIGHT              is 'For form elements, identifies the element height';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_ATTRIBUTES          is 'Identifies HTML attributes for the HTML form element';
comment on column apex_application_page_rpt_cols.FORM_ELEMENT_OPTION_ATTRIBUTES   is 'Identifies HTML attributes for the HTML form element options';
comment on column apex_application_page_rpt_cols.COLUMN_FIELD_TEMPLATE            is 'Identifies the template used to display the column label';
comment on column apex_application_page_rpt_cols.COLUMN_FIELD_TEMPLATE_ID         is 'Identifies the template ID foreign key';
comment on column apex_application_page_rpt_cols.is_required                      is 'If set to Yes, APEX will automatically perform a not null validation during page submit.';
comment on column apex_application_page_rpt_cols.standard_validations             is 'Identifies where APEX will perform the built-in standard validations for the report column type.';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_01                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_02                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_03                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_04                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_05                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_06                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_07                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_08                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_09                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_10                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_11                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_12                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_13                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_14                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.ATTRIBUTE_15                     is 'Dynamic attribute to store additional data';
comment on column apex_application_page_rpt_cols.PRIMARY_KEY_COLUMN_SOURCE_TYPE   is 'Identifies the datatype of an updatable reports primary key.';
comment on column apex_application_page_rpt_cols.PRIMARY_KEY_COLUMN_SOURCE        is 'Identifies the source value for an updatable reports primary key.';
comment on column apex_application_page_rpt_cols.DERIVED_COLUMN                   is 'Column is generated by the reporting engine and is not derived from the SQL query';
comment on column apex_application_page_rpt_cols.COLUMN_DEFAULT                   is 'Identifies the default value source for this updatable report column';
comment on column apex_application_page_rpt_cols.COLUMN_DEFAULT_TYPE              is 'Identifies the default value source type for an updatable report column';
comment on column apex_application_page_rpt_cols.REGION_ID                        is 'Identifies the Primary Key of the report Region';
comment on column apex_application_page_rpt_cols.REGION_REPORT_COLUMN_ID          is 'Identifies the Primary Key of the Report Column Entry';
comment on column apex_application_page_rpt_cols.include_in_export                is 'Include column in download';
comment on column apex_application_page_rpt_cols.print_column_width               is 'Print column width for exact control';
comment on column apex_application_page_rpt_cols.print_column_alignment           is 'Print column alignment';
comment on column apex_application_page_rpt_cols.COLUMN_COMMENT                   is 'Comment on Report Column';
comment on column apex_application_page_rpt_cols.reference_schema                 is 'Referenced column';
comment on column apex_application_page_rpt_cols.reference_table_name             is 'Referenced column';
comment on column apex_application_page_rpt_cols.reference_column_name            is 'Referenced column';
comment on column apex_application_page_rpt_cols.build_option                     is 'Column will be displayed if the Build Option is enabled';
comment on column apex_application_page_rpt_cols.build_option_id                  is 'Foreign Key';
comment on column apex_application_page_rpt_cols.component_signature              is 'Identifies attributes defined at a given component level to facilitate application comparisons';


create or replace view apex_application_page_reg_cols
as
select c.id                        as region_column_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       c.page_id,
       p.name                      as page_name,
       c.region_id,
       r.plug_name                 as region_name,
       c.name,
       c.data_type,
       case c.is_visible
         when 'Y' then 'Yes'
         else          'No'
       end as is_visible,
       c.display_sequence,
       c.heading,
       c.heading_alignment,
       c.value_alignment,
       c.value_css_classes,
       c.value_attributes,
       c.format_mask,
       c.attribute_01,
       c.attribute_02,
       c.attribute_03,
       c.attribute_04,
       c.attribute_05,
       c.attribute_06,
       c.attribute_07,
       c.attribute_08,
       c.attribute_09,
       c.attribute_10,
       c.attribute_11,
       c.attribute_12,
       c.attribute_13,
       c.attribute_14,
       c.attribute_15,
       c.attribute_16,
       c.attribute_17,
       c.attribute_18,
       c.attribute_19,
       c.attribute_20,
       c.attribute_21,
       c.attribute_22,
       c.attribute_23,
       c.attribute_24,
       c.attribute_25,
       case c.escape_on_http_output
         when 'Y' then 'Yes'
         when 'N' then 'No'
         else c.escape_on_http_output
       end as escape_on_http_output,
       coalesce (
           ( select r
               from apex_standard_conditions
              where c.display_condition_type is not null
                and d = c.display_condition_type
           ),
           c.display_condition_type ) as condition_type,
       c.display_condition_type       as condition_type_code,
       c.display_condition            as condition_expression1,
       c.display_condition2           as condition_expression2,
       case when substr( c.security_scheme, 1, 1) = '!' then 'Not ' end ||
       coalesce (
           ( select name
               from wwv_flow_security_schemes
              where to_char( id ) = ltrim( c.security_scheme, '!' )
                and flow_id       = c.flow_id
           ),
           c.security_scheme ) as authorization_scheme,
       c.security_scheme       as authorization_scheme_id,
       c.column_comment        as component_comment,
       c.last_updated_by,
       c.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_region_columns c,
       wwv_flow_page_plugs r,
       wwv_flow_steps p
 where c.flow_id           = f.application_id
   and c.security_group_id = f.workspace_id
   and r.id                = c.region_id
   and r.security_group_id = c.security_group_id
   and p.flow_id           = c.flow_id
   and p.id                = c.page_id
   and p.security_group_id = c.security_group_id
/

comment on table  apex_application_page_reg_cols is 'Region column definitions used for regions';
comment on column apex_application_page_reg_cols.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_application_page_reg_cols.workspace_display_name is
    'Display name for the workspace';
comment on column apex_application_page_reg_cols.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_reg_cols.application_name is
    'Identifies the application';
comment on column apex_application_page_reg_cols.page_id is
    'Identifies the application';
comment on column apex_application_page_reg_cols.page_name is
    'Identifies a page within an application';
comment on column apex_application_page_reg_cols.region_name is
    'Region name';
comment on column apex_application_page_reg_cols.name is
    'SQL query column name';
comment on column apex_application_page_reg_cols.data_type is
    'Data type of the SQL query column';
comment on column apex_application_page_reg_cols.is_visible is
    'Identifies the column as visible';
comment on column apex_application_page_reg_cols.display_sequence is
    'Identifies the sequence in the region that this column is to be displayed';
comment on column apex_application_page_reg_cols.heading is
    'Region column heading';
comment on column apex_application_page_reg_cols.heading_alignment is
    'Region heading alignment';
comment on column apex_application_page_reg_cols.value_alignment is
    'Region column alignment';
comment on column apex_application_page_reg_cols.value_css_classes is
    'CSS classes that are applied for the region column';
comment on column apex_application_page_reg_cols.value_attributes is
    'HTML attributes that are applied for the region column';
comment on column apex_application_page_reg_cols.format_mask is
    'Number or Date format mask';
comment on column apex_application_page_reg_cols.attribute_01 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_02 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_03 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_04 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_05 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_06 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_07 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_08 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_09 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_10 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_11 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_12 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_13 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_14 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_15 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_16 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_17 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_18 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_19 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_20 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_21 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_22 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_23 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_24 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.attribute_25 is
    'Dynamic attribute to store additional data';
comment on column apex_application_page_reg_cols.escape_on_http_output is
    'If Yes values will be escaped when they are written to the HTTP output.';
comment on column apex_application_page_reg_cols.condition_type is
    'Identifies the condition type used to conditionally display this Region Column';
comment on column apex_application_page_reg_cols.condition_type_code is
    'Identifies the internal code of CONDITION_TYPE';
comment on column apex_application_page_reg_cols.condition_expression1 is
    'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_reg_cols.condition_expression2 is
    'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_reg_cols.authorization_scheme is
    'An authorization scheme must evaluate to TRUE in order for this Region Column to be displayed';
comment on column apex_application_page_reg_cols.authorization_scheme_id is
    'Foreign Key';
comment on column apex_application_page_reg_cols.last_updated_by is
    'APEX developer who made last update';
comment on column apex_application_page_reg_cols.last_updated_on is
    'Date of last update';
comment on column apex_application_page_reg_cols.component_comment is
    'Developer comment';



-------------------------------------------------------
-- A P P L I C A T I O N   P A G E   P R O C E S S E S
-- 4312

prompt ...apex_application_page_proc

create or replace view apex_application_page_proc
as
select
     f.workspace,
     f.workspace_display_name,
     f.application_id,
     f.application_name,
     p.id                           page_id,
     p.name                         page_name,
     --
     pr.process_name                process_name,
     pr.process_sequence            execution_sequence,
     --
     decode(pr.process_point,
       'RETURN_VALUE','DISPLAY_VALUE',
       'ON_NEW_INSTANCE','On New Instance After Authentication',
       'BEFORE_HEADER','On Load - Before Header',
       'AFTER_HEADER','On Load - After Header',
       'BEFORE_BOX_BODY','On Load - Before Regions',
       'AFTER_BOX_BODY','On Load - After Regions',
       'BEFORE_FOOTER','On Load - Before Footer',
       'AFTER_FOOTER','On Load - After Footer',
       'ON_SUBMIT_BEFORE_COMPUTATION','On Submit - Before Computations and Validations ',
       'AFTER_SUBMIT','On Submit - After Computations and Validations',
       'ON_DEMAND','Ajax Callback - Run this process when requested by Ajax',
       'AFTER_ERROR_HEADER','On Error - After Header',
       'BEFORE_ERROR_FOOTER','On Error - Before Footer',
       pr.process_point)            process_point,
     case pr.process_point
       when 'ON_NEW_INSTANCE' then 'AFTER_AUTHENTICATION' /*backwards compatibility*/
       else pr.process_point
     end process_point_code,
     pr.region_id,
     ( select plug_name
         from wwv_flow_page_plugs
        where id = pr.region_id )   region_name,
     --
     decode( pr.location,
        'LOCAL',         'Local Database',
        'REMOTE',        'Remote Database',
        'REGION_SOURCE', 'Region Source',
        'WEB_SOURCE',    'Web Source' )     location,
     --
     (select name
        from wwv_remote_servers
       where id = pr.remote_server_id)    remote_database_name,
     pr.remote_server_id                  remote_database_id,
     (select name
        from wwv_flow_web_src_modules
       where id = pr.web_src_module_id)   web_source_module_name,
     pr.web_src_module_id                 web_source_module_id,
     pr.web_src_operation_id              web_source_operation_id,
     --
     case pr.process_type
     when 'NATIVE_PLSQL'               then 'PL/SQL anonymous block'
     when 'NATIVE_CLOSE_WINDOW'        then 'Close popup window'
     when 'NATIVE_SESSION_STATE'       then case pr.attribute_01
                                            when 'CLEAR_CACHE_FOR_FLOWS' then 'Clear Cache For Applications (removes all session state for listed applications)'
                                            when 'CLEAR_CACHE_CURRENT_FLOW' then 'Clear Cache For Current Application (removes all session state for current application)'
                                            when 'RESET_SESSION_STATE'      then 'Clear Cache For Current Session (removes all state for current session)'
                                            when 'CLEAR_CACHE_FOR_ITEMS'    then 'Clear Cache for Items (ITEM,ITEM,ITEM)'
                                            when 'CLEAR_CACHE_FOR_PAGES'    then 'Clear Cache for all Items on Pages (PageID,PageID,PageID)'
                                            when 'CLEAR_CACHE_CURRENT_PAGE' then 'Clear Cache for all Items on Pages (PageID,PageID,PageID)'
                                            else pr.process_type||'-'||pr.attribute_01 /*fallback*/
                                            end
     when 'NATIVE_USER_PREFERENCES'    then case pr.attribute_01
                                            when 'RESET_USER_PREFERENCES' then 'Reset Preferences (remove all preferences for current user)'
                                            when 'SET_PREFERENCE_TO_ITEM_VALUE' then 'Set Preference to value of Item'
                                            when 'SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL' then 'Set Preference to value of Item if item is not null (PreferenceName:ITEM)'
                                            else pr.process_type||'-'||pr.attribute_01 /*fallback*/
                                            end
     when 'NATIVE_RESET_PAGINATION'    then case pr.attribute_01
                                            when 'ALL_PAGES' then 'Reset Pagination For All Pages'
                                            when 'PAGES'     then 'Reset Pagination For Page(s) (PageID,PageID,PageID)'
                                            when 'THIS_PAGE' then 'Reset Pagination'
                                            else pr.process_type||'-'||pr.attribute_01 /*fallback*/
                                            end
     when 'NATIVE_TABFORM_ADD_ROWS'    then 'Add rows to tabular form'
     when 'NATIVE_TABFORM_UPDATE'      then 'Multi Row Update'
     when 'NATIVE_TABFORM_DELETE'      then 'Multi Row Delete'
     when 'NATIVE_FORM_FETCH'          then 'Automated Row Fetch'
     when 'NATIVE_FORM_PROCESS'        then 'Automatic Row Processing (DML)'
     when 'NATIVE_FORM_PAGINATION'     then 'Get Next or Previous Primary Key Value'
     when 'NATIVE_WEB_SERVICE'         then 'Web Service'
     when 'NATIVE_WEB_SERVICE_LEGACY'  then 'Web Service'
     else case substr(pr.process_type, 1, 7)
          when 'NATIVE_' then
          ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = 'PROCESS TYPE' and name = substr(pr.process_type, 8) )
          when 'PLUGIN_' then
          ( select display_name from wwv_flow_plugins where flow_id = p.flow_id and plugin_type = 'PROCESS TYPE' and name = substr(pr.process_type, 8) )
          end
     end                            process_type,
     case pr.process_type
     when 'NATIVE_PLSQL'               then 'PLSQL'
     when 'NATIVE_CLOSE_WINDOW'        then 'CLOSE_WINDOW'
     when 'NATIVE_SESSION_STATE'       then case pr.attribute_01
                                            when 'CLEAR_CACHE_CURRENT_PAGE' then 'CLEAR_CACHE_FOR_PAGES'
                                            else pr.attribute_01
                                            end
     when 'NATIVE_USER_PREFERENCES'    then pr.attribute_01
     when 'NATIVE_RESET_PAGINATION'    then case pr.attribute_01
                                            when 'ALL_PAGES' then 'INITIALIZE_PAGINATION_FOR_ALL_PAGES'
                                            when 'PAGES'     then 'INITIALIZE_PAGE_PAGINATION'
                                            when 'THIS_PAGE' then 'RESET_PAGINATION'
                                            else pr.process_type||'-'||pr.attribute_01 /*fallback*/
                                            end
     when 'NATIVE_TABFORM_ADD_ROWS'    then 'ADD_ROWS_TO_TABULAR_FORM'
     when 'NATIVE_TABFORM_UPDATE'      then 'MULTI_ROW_UPDATE'
     when 'NATIVE_TABFORM_DELETE'      then 'MULTI_ROW_DELETE'
     when 'NATIVE_FORM_PROCESS_LEGACY' then 'DML_PROCESS_'||pr.attribute_01||'_ROW'
     when 'NATIVE_FORM_FETCH'          then 'DML_FETCH_ROW'
     when 'NATIVE_FORM_PROCESS'        then 'DML_PROCESS_ROW'
     when 'NATIVE_FORM_PAGINATION'     then 'GET_NEXT_OR_PREV_PK'
     when 'NATIVE_WEB_SERVICE'         then 'WEB_SERVICE'
     when 'NATIVE_WEB_SERVICE_LEGACY'  then 'WEB_SERVICE'
     else pr.process_type
     end                            process_type_code,
     pr.process_type                process_type_plugin_name,
     --pr.ITEM_NAME,
     case
       when pr.process_type in ('NATIVE_TABFORM_UPDATE', 'NATIVE_TABFORM_DELETE') then attribute_05
       when pr.process_type in ('NATIVE_FORM_FETCH', 'NATIVE_FORM_PROCESS')       then attribute_08
       when pr.process_type =   'NATIVE_FORM_PROCESS_LEGACY'                      then attribute_06
       when pr.process_type =   'NATIVE_FORM_PAGINATION'                          then attribute_14
     end                            runtime_where_clause,
     case
     when pr.process_type = 'NATIVE_CLOSE_WINDOW' then to_clob('CLOSE_WINDOW')
     when pr.process_type = 'NATIVE_SESSION_STATE' and pr.attribute_01 = 'CLEAR_CACHE_FOR_FLOWS' then to_clob(pr.attribute_02)
     when pr.process_type = 'NATIVE_SESSION_STATE' and pr.attribute_01 in ('CLEAR_CACHE_CURRENT_FLOW','RESET_SESSION_STATE') then to_clob(pr.attribute_01)
     when pr.process_type = 'NATIVE_SESSION_STATE' and pr.attribute_01 = 'CLEAR_CACHE_FOR_ITEMS' then to_clob(pr.attribute_03)
     when pr.process_type = 'NATIVE_SESSION_STATE' and pr.attribute_01 = 'CLEAR_CACHE_FOR_PAGES' then to_clob(pr.attribute_04)
     when pr.process_type = 'NATIVE_SESSION_STATE' and pr.attribute_01 = 'CLEAR_CACHE_CURRENT_PAGE' then to_clob(pr.flow_step_id)
     when pr.process_type = 'NATIVE_USER_PREFERENCES' and pr.attribute_01 = 'RESET_USER_PREFERENCES' then to_clob(pr.attribute_01)
     when pr.process_type = 'NATIVE_USER_PREFERENCES' then to_clob(pr.attribute_02||':'||pr.attribute_03)
     when pr.process_type = 'NATIVE_RESET_PAGINATION' and pr.attribute_01 = 'PAGES' then to_clob(pr.attribute_02)
     when pr.process_type = 'NATIVE_RESET_PAGINATION' and pr.attribute_01 = 'THIS_PAGE' then to_clob('reset_pagination')
     when pr.process_type = 'NATIVE_TABFORM_ADD_ROWS' then to_clob(pr.attribute_01)
     when pr.process_type like 'NATIVE_TABFORM%' then
          to_clob(rtrim(nvl(pr.attribute_01,'#OWNER#')||':'||pr.attribute_02||':'||pr.attribute_03||':'||pr.attribute_04,':'))
     when pr.process_type = 'NATIVE_FORM_FETCH' then
          to_clob(case when pr.attribute_15='D' then null else 'F|' end||
                  rtrim(nvl(pr.attribute_01,'#OWNER#')||':'||pr.attribute_02||':'||pr.attribute_03||':'||pr.attribute_04||
                        ':'||pr.attribute_05||':'||pr.attribute_06||':'||pr.attribute_07,':'))
     when pr.process_type = 'NATIVE_FORM_PROCESS' then
          to_clob(rtrim(nvl(pr.attribute_01,'#OWNER#')||':'||pr.attribute_02||':'||pr.attribute_03||':'||pr.attribute_04||
                        ':'||pr.attribute_05||':'||pr.attribute_06||':'||pr.attribute_07,':')||
                  '|'||replace(pr.attribute_11,':',null))
     when pr.process_type = 'NATIVE_FORM_PAGINATION' then
          to_clob(nvl(pr.attribute_01,'#OWNER#')||':'||pr.attribute_02||':'||pr.attribute_04||':'||pr.attribute_06||
                  ':'||pr.attribute_07||':'||pr.attribute_08||':'||pr.attribute_03||
                  ':'||pr.attribute_09||':'||pr.attribute_10||':'||pr.attribute_05||
                  ':'||pr.attribute_11||':'||pr.attribute_12||':'||pr.attribute_13||
                  ':'||replace(pr.attribute_14, ':', '<cbchoesc>'))
     when pr.process_type = 'NATIVE_WEB_SERVICE' then to_clob(nvl((select ws_id||':'||id
                                                                     from wwv_flow_ws_operations o
                                                                    where o.security_group_id = pr.security_group_id
                                                                      and to_char(o.id)       = pr.attribute_01),
                                                                  pr.attribute_01))
     when pr.process_type = 'NATIVE_WEB_SERVICE_LEGACY' then to_clob(pr.attribute_01)
     else pr.process_sql_clob
     end                            process_source,
     pr.attribute_01,
     pr.attribute_02,
     pr.attribute_03,
     pr.attribute_04,
     pr.attribute_05,
     pr.attribute_06,
     pr.attribute_07,
     pr.attribute_08,
     pr.attribute_09,
     pr.attribute_10,
     pr.attribute_11,
     pr.attribute_12,
     pr.attribute_13,
     pr.attribute_14,
     pr.attribute_15,
     pr.process_error_message       process_error_message,
     pr.error_display_location      error_display_location,
     --
     coalesce(
         (select button_name
          from wwv_flow_step_buttons
          where id = pr.process_when_button_id),
         (select name
          from wwv_flow_step_items
          where id = pr.process_when_button_id) )
                                    when_button_pressed,
     pr.process_when_button_id      when_button_pressed_id,
     case nvl(pr.only_for_changed_rows, 'Y')
       when 'Y' then 'Yes'
       when 'N' then 'No'
     end                            only_for_changed_rows,
     --
     nvl((select r from apex_standard_conditions where d = pr.process_when_type),pr.process_when_type)
                                    condition_type,
     pr.process_when_type           condition_type_code,
     pr.process_when                condition_expression1,
     pr.process_when2               condition_expression2,
     case nvl(pr.exec_cond_for_each_row, 'N')
       when 'Y' then 'Yes'
       when 'N' then 'No'
     end                            exec_cond_for_each_row,
     --pr.PROCESS_WHEN_TYPE2,
     --
     decode(pr.process_is_stateful_y_n,
       'Y','Once Per Session or When Reset',
       'N','Once Per Page Visit (default)',
       pr.PROCESS_IS_STATEFUL_Y_N)  run_process,
     --
     case pr.process_type
       when 'NATIVE_FORM_PROCESS' then attribute_09
     end                            return_key_into_item_1,
     case pr.process_type
       when 'NATIVE_FORM_PROCESS' then attribute_10
     end                            return_key_into_item_2,
     pr.process_success_message     success_message,
     --
     (select case when pr.required_patch > 0 then patch_name else '{Not '||patch_name||'}' end patch_name
     from wwv_flow_patches
     where id=abs(pr.required_patch))    build_option,
     --
     decode(substr(pr.security_scheme,1,1),'!','Not ')||
     nvl((select name
      from   wwv_flow_security_schemes
      where  to_char(id) = ltrim(pr.security_scheme,'!')
      and    flow_id = f.application_id),
      pr.security_scheme)           authorization_scheme,
     pr.security_scheme             authorization_scheme_id,
     --
     pr.last_updated_by             last_updated_by,
     pr.last_updated_on             last_updated_on,
     pr.process_comment             component_comment,
     pr.id                          process_id,
     --
     lpad(pr.PROCESS_SEQUENCE,5,'00000')
     ||',point='||decode(pr.PROCESS_POINT,
       'RETURN_VALUE','DISPLAY_VALUE',
       'ON_NEW_INSTANCE','On New Instance After Authentication',
       'BEFORE_HEADER','On Load - Before Header',
       'AFTER_HEADER','On Load - After Header',
       'BEFORE_BOX_BODY','On Load - Before Regions',
       'AFTER_BOX_BODY','On Load - After Regions',
       'BEFORE_FOOTER','On Load - Before Footer',
       'AFTER_FOOTER','On Load - After Footer',
       'ON_SUBMIT_BEFORE_COMPUTATION','On Submit - Before Computations and Validations ',
       'AFTER_SUBMIT','On Submit - After Computations and Validations',
       'ON_DEMAND','Ajax Callback - Run this process when requested by Ajax',
       'AFTER_ERROR_HEADER','On Error - After Header',
       'BEFORE_ERROR_FOOTER','On Error - Before Footer',
       pr.PROCESS_POINT)
       ||',type='||pr.PROCESS_TYPE
       ||',src='||sys.dbms_lob.substr(pr.PROCESS_SQL_CLOB,30,1)||'.'||
       sys.dbms_lob.getlength(pr.PROCESS_SQL_CLOB)
       ||coalesce(
              (select ',wbp='||button_name n from wwv_flow_step_buttons where id = pr.PROCESS_WHEN_BUTTON_ID),
              (select ',wbp='||name n from wwv_flow_step_items where id = pr.PROCESS_WHEN_BUTTON_ID))
       ||decode(pr.PROCESS_ERROR_MESSAGE,null,null,',errm='||
       substr(pr.PROCESS_ERROR_MESSAGE,1,20)||length(pr.PROCESS_ERROR_MESSAGE))
       ||decode(pr.PROCESS_SUCCESS_MESSAGE,null,null,',succm='||
       substr(pr.PROCESS_SUCCESS_MESSAGE,1,20)||length(pr.PROCESS_SUCCESS_MESSAGE))
       ||nvl((select name from wwv_flow_security_schemes where to_char(id) = ltrim(pr.SECURITY_SCHEME,'!') and flow_id = f.application_id),'Not found')
       ||',cond='||pr.PROCESS_WHEN_TYPE
       ||substr(pr.PROCESS_WHEN,1,20)||length(pr.PROCESS_WHEN)||'.'
       ||substr(pr.PROCESS_WHEN2,1,20)||length(pr.PROCESS_WHEN2)
       ||(select PATCH_NAME from wwv_flow_patches where id=abs(pr.REQUIRED_PATCH))
       ||decode(pr.PROCESS_IS_STATEFUL_Y_N,'Y','Once Per Session or When Reset','N','Once Per Page Visit (default)',pr.PROCESS_IS_STATEFUL_Y_N)
     ||',key='||pr.RETURN_KEY_INTO_ITEM1||pr.RETURN_KEY_INTO_ITEM1
     component_signature
from wwv_flow_step_processing pr,
     wwv_flow_steps           p,
     wwv_flow_authorized      f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = pr.security_group_id
  and p.flow_id           = pr.flow_id
  and p.id                = pr.flow_step_id
/

comment on table  apex_application_page_proc                          is 'Identifies SQL or PL/SQL processing associated with a page';
comment on column apex_application_page_proc.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_proc.workspace_display_name   is 'Display name for the workspace';
comment on column apex_application_page_proc.application_id           is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_proc.application_name         is 'Identifies the application';
comment on column apex_application_page_proc.page_id                  is 'Identifies the application';
comment on column apex_application_page_proc.page_name                is 'Identifies a page within an application';
comment on column apex_application_page_proc.process_name             is 'Identifies Page Process Name';
comment on column apex_application_page_proc.execution_sequence       is 'Identifies order of execution within each Process Point';
comment on column apex_application_page_proc.process_point            is 'Specifies the point at which the process is executed';
comment on column apex_application_page_proc.process_point_code       is 'Internal code of PROCESS_POINT';
comment on column apex_application_page_proc.region_id                is 'Identifies the region ID of the tabular form region for process';
comment on column apex_application_page_proc.region_name              is 'Identifies the region name of the tabular form region for process';
comment on column apex_application_page_proc.location                 is 'Identifies whether the data source of the region is the local database, a remote database or a web source module';
comment on column apex_application_page_proc.remote_database_id       is 'Identifies the primary key of the remote database definition';
comment on column apex_application_page_proc.remote_database_name     is 'Identifies the name of the remote database';
comment on column apex_application_page_proc.web_source_module_id     is 'Identifies the primary key of the web source module';
comment on column apex_application_page_proc.web_source_operation_id  is 'Identifies the primary key of the web source operation';
comment on column apex_application_page_proc.web_source_module_name   is 'Identifies the web source module name';
comment on column apex_application_page_proc.process_type             is 'Identifies process type';
comment on column apex_application_page_proc.process_type_code        is 'Deprecated internal code of PROCESS_TYPE. Use PROCESS_TYPE_PLUGIN_NAME instead.';
comment on column apex_application_page_proc.process_type_plugin_name is 'Name of the plugin that implements the process. Names of built-in plugins start with "NATIVE_", application specific plugin names start with "PLUGIN_"';
comment on column apex_application_page_proc.runtime_where_clause     is 'Appended to Oracle APEX generated SELECT, UPDATE, and DELETE statements';
comment on column apex_application_page_proc.process_source           is 'Identifies the corresponding process text for the process type';
comment on column apex_application_page_proc.attribute_01             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_02             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_03             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_04             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_05             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_06             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_07             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_08             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_09             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_10             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_11             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_12             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_13             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_14             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.attribute_15             is 'Dynamic attribute to store additional data';
comment on column apex_application_page_proc.process_error_message    is 'Error message to be displayed when this process raises an exception';
comment on column apex_application_page_proc.error_display_location   is 'The Error display location identifies where the process error message will display. Messages can be displayed on an error page, or inline with the existing page. Inline errors are displayed in the "notification" area (defined as part of the page template).';
comment on column apex_application_page_proc.success_message          is 'Identifies the message to be displayed upon successful execution of this Page Process';
comment on column apex_application_page_proc.when_button_pressed      is 'This process will only be executed if a user clicks the button identified';
comment on column apex_application_page_proc.when_button_pressed_id   is 'Foreign key to button';
comment on column apex_application_page_proc.only_for_changed_rows    is 'If set to Yes this process will only be evaluated if the tabular form row has been created or modified.';
comment on column apex_application_page_proc.condition_type           is 'Identifies the condition type used to conditionally execute the Page Process';
comment on column apex_application_page_proc.condition_type_code      is 'Internal code of CONDITION_TYPE';
comment on column apex_application_page_proc.condition_expression1    is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_proc.condition_expression2    is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_proc.exec_cond_for_each_row   is 'If set to Yes the condition of this process will be executed for each row because it references tabular form columns.';
comment on column apex_application_page_proc.run_process              is 'Specifies when the process should run; Once Per Session or When Reset, or Once Per Page Visit';
comment on column apex_application_page_proc.return_key_into_item_1   is 'After performing a SQL INSERT statement, take the first (or only) column of the primary key and return it into this item. Use this feature to get back ID fields populated from sequences within database triggers.';
comment on column apex_application_page_proc.return_key_into_item_2   is 'After performing a SQL INSERT statement, take the second column of the primary key and return it into this item. Use this feature to get back ID fields populated from sequences within database triggers.';
comment on column apex_application_page_proc.build_option             is 'Page Process will be considered for execution if the Build Option is enabled';
comment on column apex_application_page_proc.authorization_scheme     is 'An authorization scheme must evaluate to TRUE in order for this Page Process to be considered for execution';
comment on column apex_application_page_proc.authorization_scheme_id  is 'Foreign Key';
comment on column apex_application_page_proc.component_comment        is 'Developer comment';
comment on column apex_application_page_proc.process_id               is 'Primary Key of this Page Process';
comment on column apex_application_page_proc.last_updated_by          is 'APEX developer who made last update';
comment on column apex_application_page_proc.last_updated_on          is 'Date of last update';
comment on column apex_application_page_proc.component_signature      is 'Identifies attributes defined at a given component level to facilitate application comparisons';



------------------------------------------------------------
-- A P P L I C A T I O N   P A G E   C O M P U T A T I O N S
-- 4315

prompt ...apex_application_page_comp


create or replace view apex_application_page_comp
as
select
     f.workspace,
     f.workspace_display_name,
     f.application_id,
     f.application_name,
     p.id                           page_id,
     p.name                         page_name,
     --
     c.COMPUTATION_ITEM             item_name,
     c.COMPUTATION_SEQUENCE         execution_sequence,
     --
     decode(c.COMPUTATION_POINT,
       'ON_NEW_INSTANCE','On New Instance (e.g. On Login)',
       'BEFORE_HEADER','Before Header',
       'AFTER_HEADER','After Header',
       'BEFORE_BOX_BODY','Before Region(s)',
       'AFTER_BOX_BODY','After Region(s)',
       'BEFORE_FOOTER','Before Footer',
       'AFTER_FOOTER','After Footer',
       'AFTER_SUBMIT','After Submit',
       c.COMPUTATION_POINT)         computation_point,
     --
     decode(c.COMPUTATION_TYPE,
        'STATIC_ASSIGNMENT','Static Assignment',
        'FUNCTION_BODY','PL/SQL Function Body',
        'QUERY','SQL Query (return single value)',
        'QUERY_COLON','SQL Query (return colon separated value)',
        'SQL_EXPRESSION','SQL Expression',
        'PLSQL_EXPRESSION','PL/SQL Expression',
        'ITEM_VALUE','Item Value',
        c.COMPUTATION_TYPE)         computation_type,
     --c.COMPUTATION_PROCESSED        computation_processed,
     c.COMPUTATION                  computation,
     --
     decode(c.COMPUTE_WHEN_TYPE,'%'||'null%',null,
     nvl((select r from apex_standard_conditions where d = c.COMPUTE_WHEN_TYPE),c.COMPUTE_WHEN_TYPE))
                                    condition_type,
     c.compute_when_type            condition_type_code,
     c.COMPUTE_WHEN                 condition_expression1,
     c.COMPUTE_WHEN_TEXT            condition_expression2,
     c.COMPUTATION_ERROR_MESSAGE    error_message,
     (select case when c.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(c.REQUIRED_PATCH))    build_option,
     --
     decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     c.SECURITY_SCHEME)             authorization_scheme,
     c.SECURITY_SCHEME              authorization_scheme_id,
     c.LAST_UPDATED_BY              last_updated_by,
     c.LAST_UPDATED_ON              last_updated_on,
     c.COMPUTATION_COMMENT          component_comment,
     --
     c.COMPUTATION_ITEM
     ||c.COMPUTATION_SEQUENCE
     ||c.COMPUTATION_POINT
     ||c.COMPUTATION_TYPE
     ||length(c.COMPUTATION)
     ||c.COMPUTE_WHEN_TYPE
     ||length(c.COMPUTE_WHEN)||length(c.COMPUTE_WHEN_TEXT)
     ||length(c.COMPUTATION_ERROR_MESSAGE)
     ||(select case when c.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(c.REQUIRED_PATCH))
     ||decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     'Not found')             component_signature,
     --
     c.id                           computation_id
from wwv_flow_step_computations c,
     wwv_flow_steps             p,
     wwv_flow_authorized        f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = c.security_group_id
  and p.flow_id           = c.flow_id
  and p.id                = c.flow_step_id
/

comment on table  apex_application_page_comp                       is 'Identifies the computation of Item Session State';
comment on column apex_application_page_comp.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_comp.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_page_comp.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_comp.application_name      is 'Identifies the application';
comment on column apex_application_page_comp.page_id               is 'Identifies the application';
comment on column apex_application_page_comp.page_name             is 'Identifies a page within an application';
comment on column apex_application_page_comp.item_name             is 'Item name to compute the value of';
comment on column apex_application_page_comp.EXECUTION_SEQUENCE    is 'Identifies the execution order of the computations within each computation point';
comment on column apex_application_page_comp.COMPUTATION_POINT     is 'Identifies the computation point that the computation will be considered for execution';
comment on column apex_application_page_comp.COMPUTATION_TYPE      is 'Identifies the type of computation, reference the Computation attribute.';
comment on column apex_application_page_comp.COMPUTATION           is 'Identifies the Computation which corresponds to the Computation Type';
comment on column apex_application_page_comp.CONDITION_TYPE        is 'Identifies the condition type used to conditionally execute the Page Computation';
comment on column apex_application_page_comp.CONDITION_TYPE_CODE   is 'Internal code of CONDITION_TYPE';
comment on column apex_application_page_comp.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_comp.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_comp.ERROR_MESSAGE         is 'Identifies the error message to display if the Page Computation raises an error';
comment on column apex_application_page_comp.BUILD_OPTION          is 'Page Computation will be considered for execution if the Build Option is enabled';
comment on column apex_application_page_comp.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this computation to be considered for execution';
comment on column apex_application_page_comp.AUTHORIZATION_SCHEME_ID  is 'Foriegn Key';
comment on column apex_application_page_comp.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_page_comp.COMPUTATION_ID        is 'Primary key of this page computation';
comment on column apex_application_page_comp.last_updated_by       is 'APEX developer who made last update';
comment on column apex_application_page_comp.last_updated_on       is 'Date of last update';
comment on column apex_application_page_comp.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';


------------------------------------------------------------
-- A P P L I C A T I O N   P A G E   B R A N C H E S
-- 4315

prompt ...apex_application_page_branches


create or replace view apex_application_page_branches
as
select
     f.workspace,
     f.workspace_display_name,
     f.application_id,
     f.application_name,
     p.id                           page_id,
     p.name                         page_name,
     --
     b.branch_name                  branch_name,
     b.BRANCH_ACTION                branch_action,
     b.BRANCH_POINT                 branch_point,
     decode(b.BRANCH_WHEN_BUTTON_ID,
     null,null,coalesce(
         (select button_name from wwv_flow_step_buttons where id = b.BRANCH_WHEN_BUTTON_ID),
         (select name from wwv_flow_step_items where id = b.BRANCH_WHEN_BUTTON_ID)))
                                    when_button_pressed,
     decode(b.BRANCH_TYPE,
       'BRANCH_TO_FUNCTION_RETURNING_PAGE','Branch to Function Returning a Page',
       'BRANCH_TO_FUNCTION_RETURNING_URL', 'Branch to Function Returning a URL',
       'BRANCH_TO_PAGE_IDENT_BY_ITEM',     'Branch to Page Identified by Item (Use Item Name)',
       'BRANCH_TO_PAGE_ACCEPT',            'Branch to Page Accept Processing (not common)',
       'BRANCH_TO_STEP',                   'Branch to Page',
       'BRANCH_TO_URL_IDENT_BY_ITEM',      'Branch to URL Identified by Item (Use Item Name)',
       'PLSQL',                            'Branch to PL/SQL Procedure',
       'REDIRECT_URL',                     'Branch to Page or URL',
       b.BRANCH_TYPE)               branch_type,
     b.BRANCH_SEQUENCE              process_sequence,
     --b.CLEAR_PAGE_CACHE,
     nvl((select r from apex_standard_conditions where d = b.BRANCH_CONDITION_TYPE),b.BRANCH_CONDITION_TYPE)
                                    condition_type,
     b.branch_condition_type        condition_type_code,
     b.BRANCH_CONDITION             condition_expression1,
     b.BRANCH_CONDITION_TEXT        condition_expression2,
     decode(nvl(b.save_state_before_branch_yn,'N'),'N','No','Yes')  save_state_before_branch,
     (select case when b.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id=  abs(b.REQUIRED_PATCH))   build_option,
     --
     decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(b.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     b.SECURITY_SCHEME)             authorization_scheme,
     b.SECURITY_SCHEME              authorization_scheme_id,
     b.LAST_UPDATED_BY              last_updated_by,
     b.LAST_UPDATED_ON              last_updated_on,
     b.BRANCH_COMMENT               component_comment,
     b.id                           branch_id,
     b.BRANCH_WHEN_BUTTON_ID        branch_when_button_id,
     --
     'Point='||BRANCH_POINT
     ||',seq='||lpad(b.BRANCH_SEQUENCE,5,'00000')
     ||',act='||substr(b.BRANCH_ACTION,1,30)||'.'||length(b.BRANCH_ACTION)
     ||',type='||decode(b.BRANCH_TYPE,
       'BRANCH_TO_FUNCTION_RETURNING_PAGE','Branch to Function Returning a Page',
       'BRANCH_TO_FUNCTION_RETURNING_URL', 'Branch to Function Returning a URL',
       'BRANCH_TO_PAGE_IDENT_BY_ITEM',     'Branch to Page Identified by Item (Use Item Name)',
       'BRANCH_TO_PAGE_ACCEPT',            'Branch to Page Accept Processing (not common)',
       'BRANCH_TO_STEP',                   'Branch to Page',
       'BRANCH_TO_URL_IDENT_BY_ITEM',      'Branch to URL Identified by Item (Use Item Name)',
       'PLSQL',                            'Branch to PL/SQL Procedure',
       'REDIRECT_URL',                     'Branch to Page or URL',
       b.BRANCH_TYPE)||'.'
     ||decode(b.BRANCH_WHEN_BUTTON_ID,null,null,coalesce((select button_name from wwv_flow_step_buttons where id = b.BRANCH_WHEN_BUTTON_ID), (select name from wwv_flow_step_items where id = b.BRANCH_WHEN_BUTTON_ID)))||
     decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name from wwv_flow_security_schemes where to_char(id) = ltrim(b.SECURITY_SCHEME,'!') and flow_id = f.application_id),'Not found')||
     'cond='||nvl((select r from apex_standard_conditions where d = b.BRANCH_CONDITION_TYPE),b.BRANCH_CONDITION_TYPE)||
        '.'||substr(b.BRANCH_CONDITION,1,20)||'.'||length(b.BRANCH_CONDITION)||'.'||length(b.BRANCH_CONDITION_TEXT)||
     'save='||decode(nvl(b.save_state_before_branch_yn,'N'),'N','No','Yes')||
     'build='||(select PATCH_NAME from wwv_flow_patches where id=  abs(b.REQUIRED_PATCH))
     component_signature
from wwv_flow_step_branches b,
     wwv_flow_steps         p,
     wwv_flow_authorized    f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = b.security_group_id
  and p.flow_id           = b.flow_id
  and p.id                = b.flow_step_id
/

comment on table  apex_application_page_branches                       is 'Identifies branch processing associated with a page.  A branch is a directive to navigate to a page or URL which is run at the conclusion of page accept processing.';
comment on column apex_application_page_branches.workspace             is 'A branch fires on page submit and direct a posted page to the next page to view';
comment on column apex_application_page_branches.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_page_branches.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_branches.application_name      is 'Identifies the application';
comment on column apex_application_page_branches.page_id               is 'Identifies the application';
comment on column apex_application_page_branches.page_name             is 'Identifies a page within an application';
comment on column apex_application_page_branches.branch_name           is 'Identifies branch name';
comment on column apex_application_page_branches.BRANCH_ACTION         is 'Identifies the branch target, typically a page';
comment on column apex_application_page_branches.BRANCH_POINT          is 'Identifies the point at which the branch will be evaluated for execution';
comment on column apex_application_page_branches.WHEN_BUTTON_PRESSED   is 'Identifies a button that must be pressed to consider the branch for execution';
comment on column apex_application_page_branches.BRANCH_TYPE           is 'Identifies how the branch action will be processed, typically identifies a page ID or URL';
comment on column apex_application_page_branches.PROCESS_SEQUENCE      is 'Identifies the order in which the branch will be evaluated for execution for each branch point';
comment on column apex_application_page_branches.CONDITION_TYPE        is 'Identifies a condition that must be met in order for this branch to be processed';
comment on column apex_application_page_branches.CONDITION_TYPE_CODE   is 'Internal code of CONDITION_TYPE';
comment on column apex_application_page_branches.CONDITION_EXPRESSION1 is 'Identifies a condition which is specific to the selected condition type';
comment on column apex_application_page_branches.CONDITION_EXPRESSION2 is 'Identifies a condition which is specific to the selected condition type';
comment on column apex_application_page_branches.BUILD_OPTION          is 'Build options enable or disable components';
comment on column apex_application_page_branches.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this component to be processed';
comment on column apex_application_page_branches.AUTHORIZATION_SCHEME_ID  is 'Foreign Key';
comment on column apex_application_page_branches.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_page_branches.BRANCH_ID             is 'Primary key for this component';
comment on column apex_application_page_branches.branch_when_button_id is 'Foreign Key to Branch When Button ID';
comment on column apex_application_page_branches.save_state_before_branch   is 'Yes - Save session state and clear cache before branch. No - Redirect to URL with clear-cache and session state settings';
comment on column apex_application_page_branches.last_updated_by       is 'APEX developer who made last update';
comment on column apex_application_page_branches.last_updated_on       is 'Date of last update';
comment on column apex_application_page_branches.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';



----------------------------------------------------------
-- A P P L I C A T I O N   P A G E   V A L I D A T I O N S
-- 4316

prompt ...apex_application_page_val

create or replace view apex_application_page_val
as
select
     f.workspace,
     f.workspace_display_name,
     f.application_id,
     f.application_name,
     p.id                          page_id,
     p.name                        page_name,
     --
     v.VALIDATION_NAME             validation_name,
     v.VALIDATION_SEQUENCE         validation_sequence,
     v.TABULAR_FORM_REGION_ID      region_id,
     ( select plug_name
         from wwv_flow_page_plugs
        where id = v.tabular_form_region_id ) region_name,
     --
     decode(v.VALIDATION_TYPE,
        'EXISTS','Exists',
        'FUNC_BODY_RETURNING_BOOLEAN','Function Returning Boolean',
        'FUNC_BODY_RETURNING_ERR_TEXT','Function Returning Error Text',
        'ITEM_NOT_NULL','Item\Column specified is NOT NULL',
        'ITEM_IN_VALIDATION_CONTAINS_AT_LEAST_ONE_CHAR_IN_STRING2','Item\Column in Expression 1 contains at least one of the characters in Expression 2',
        'ITEM_IN_VALIDATION_CONTAINS_ONLY_CHAR_IN_STRING2','Item\Column in Expression 1 contains only characters in Expression 2',
        'ITEM_IN_VALIDATION_NOT_EQ_STRING2','Item\Column in Expression 1 does NOT equal string literal in Expression2',
        'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2','Item\Column in Expression 1 does not contain any of the characters in Expression 2',
        'ITEM_IN_VALIDATION_EQ_STRING2','Item\Column in Expression 1 equals string literal in Expression 2',
        'ITEM_IN_VALIDATION_NOT_IN_STRING2','Item\Column in Expression 1 is NOT contained in Expression 2',
        'ITEM_IN_VALIDATION_IN_STRING2','Item\Column in Expression 1 is contained in Expression 2',
        'ITEM_NOT_ZERO','Item\Column specified is NOT zero',
        'ITEM_CONTAINS_NO_SPACES','Item\Column specified contains no spaces',
        'ITEM_NOT_NULL_OR_ZERO','Item\Column specified is NOT NULL or zero',
        'ITEM_IS_ALPHANUMERIC','Item\Column specified is alphanumeric',
        'ITEM_IS_NUMERIC','Item\Column specified is numeric',
        'ITEM_IS_DATE','Item\Column specified is a valid date',
        'ITEM_IS_TIMESTAMP','Item\Column specified is a valid timestamp',
        'REGULAR_EXPRESSION','Item\Column in Expression 1 matches Regular Expression in Expression 2',
        'NOT_EXISTS','NOT Exists',
        'PLSQL_ERROR','PL/SQL Error',
        'PLSQL_EXPRESSION','PL/SQL Expression',
        'SQL_EXPRESION','SQL Expression',
         v.VALIDATION_TYPE)        validation_type,
     v.validation_type             validation_type_code,
     v.VALIDATION                  validation_expression1,
     v.VALIDATION2                 validation_expression2,
     --
     case nvl(v.always_execute, 'N')
       when 'Y' then 'Yes'
       when 'N' then 'No'
     end                           always_execute,
     nvl((select r from apex_standard_conditions where d = v.VALIDATION_CONDITION_TYPE),v.VALIDATION_CONDITION_TYPE)
                                   condition_type,
     v.validation_condition_type   condition_type_code,
     v.VALIDATION_CONDITION        condition_expression1,
     v.VALIDATION_CONDITION2       condition_expression2,
     case nvl(v.exec_cond_for_each_row, 'N')
       when 'Y' then 'Yes'
       when 'N' then 'No'
     end                           exec_cond_for_each_row,
     --
     coalesce(
        (select button_name from wwv_flow_step_buttons where id = v.WHEN_BUTTON_PRESSED),
        (select name from wwv_flow_step_items where id = v.WHEN_BUTTON_PRESSED) )
                                   when_button_pressed,
     v.WHEN_BUTTON_PRESSED         when_button_pressed_id,
     case nvl(v.only_for_changed_rows, 'Y')
       when 'Y' then 'Yes'
       when 'N' then 'No'
     end                           only_for_changed_rows,
     --
     v.ERROR_MESSAGE               validation_failure_text,
     (select name from wwv_flow_step_items
      where id = v.ASSOCIATED_ITEM and
            flow_id = f.application_id)        associated_item,
     v.associated_column           associated_column,
     v.ERROR_DISPLAY_LOCATION      error_display_location,
     (select case when v.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(v.REQUIRED_PATCH))   build_option,
     --
     decode(substr(v.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id) = ltrim(v.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     v.SECURITY_SCHEME)            authorization_scheme,
     v.SECURITY_SCHEME             authorization_scheme_id,
     --
     v.LAST_UPDATED_BY             last_updated_by,
     v.LAST_UPDATED_ON             last_updated_on,
     v.VALIDATION_COMMENT          component_comment,
     v.id                          validation_id,
     'seq='||v.VALIDATION_SEQUENCE
     ||',item='||(select name from wwv_flow_step_items where id=v.ASSOCIATED_ITEM)
     ||',type='||v.VALIDATION_TYPE
     ||',val='||substr(v.VALIDATION,1,40)||'.'||length(v.VALIDATION)||'.'
      ||substr(v.VALIDATION2,1,40)||'.'||length(v.VALIDATION2)||'.'
     ||decode(v.VALIDATION_CONDITION_TYPE,null,null,',cond='||v.VALIDATION_CONDITION_TYPE||'.'||
         substr(v.VALIDATION_CONDITION,1,30)||length(v.VALIDATION_CONDITION)||'.'||
         substr(v.VALIDATION_CONDITION2,1,30)||length(v.VALIDATION_CONDITION2))
     component_signature
from wwv_flow_step_validations v,
     wwv_flow_steps            p,
     wwv_flow_authorized       f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = v.security_group_id
  and p.flow_id           = v.flow_id
  and p.id                = v.flow_step_id
/

comment on table  apex_application_page_val                         is 'Identifies Validations associated with an Application Page';
comment on column apex_application_page_val.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_val.workspace_display_name  is 'Display name for the workspace';
comment on column apex_application_page_val.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_val.application_name        is 'Identifies the application';
comment on column apex_application_page_val.page_id                 is 'Identifies the application';
comment on column apex_application_page_val.page_name               is 'Identifies a page within an application';
comment on column apex_application_page_val.VALIDATION_NAME         is 'Identifies the name of the validation';
comment on column apex_application_page_val.VALIDATION_SEQUENCE     is 'Identifies the sequence in which this validation will be considered for execution';
comment on column apex_application_page_val.region_id               is 'Identifies the region ID of the tabular form region for column validations';
comment on column apex_application_page_val.region_name             is 'Identifies the region name of the tabular form region for column validations';
comment on column apex_application_page_val.VALIDATION_TYPE         is 'Specifies predefined validation type with the corresponding appropriate values in the Expression 1 and Expression 2 fields.';
comment on column apex_application_page_val.validation_type_code    is 'Internal code of VALIDATION_TYPE.';
comment on column apex_application_page_val.VALIDATION_EXPRESSION1  is 'Identifies the validation which corresponds to the specified Validation Type';
comment on column apex_application_page_val.VALIDATION_EXPRESSION2  is 'Identifies the validation which corresponds to the specified Validation Type';
comment on column apex_application_page_val.always_execute          is 'If set to Yes this flag will overwrites the "Execute Validations" flag for buttons and always execute the validation.';
comment on column apex_application_page_val.CONDITION_TYPE          is 'Identifies the condition type used to conditionally execute the Page Validation';
comment on column apex_application_page_val.condition_type_code     is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_page_val.CONDITION_EXPRESSION1   is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_val.CONDITION_EXPRESSION2   is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_val.exec_cond_for_each_row  is 'If set to Yes the condition of this validation will be executed for each row because it references tabular form columns.';
comment on column apex_application_page_val.WHEN_BUTTON_PRESSED     is 'This validation will only be evaluated if the identified button is pressed';
comment on column apex_application_page_val.WHEN_BUTTON_PRESSED_ID  is 'Foreign key to button';
comment on column apex_application_page_val.only_for_changed_rows   is 'If set to Yes this validation will only be evaluated if the tabular form row has been created or modified.';
comment on column apex_application_page_val.VALIDATION_FAILURE_TEXT is 'Specifies the text that will be displayed in the event the validation raises an error';
comment on column apex_application_page_val.ASSOCIATED_ITEM         is 'If applicable, select the item associated with this validation error message.';
comment on column apex_application_page_val.ASSOCIATED_COLUMN       is 'If applicable, select the column associated with this validation error message.';
comment on column apex_application_page_val.ERROR_DISPLAY_LOCATION  is 'The Error display location identifies where the validation error message will display. Messages can be displayed on an error page, or inline with the existing page. Inline validations are displayed in the "notification" area (defined as part of the page template), and/or within the item label.';
comment on column apex_application_page_val.BUILD_OPTION            is 'Page Computation will be considered for execution if the Build Option is enabled';
comment on column apex_application_page_val.AUTHORIZATION_SCHEME    is 'An authorization scheme must evaluate to TRUE in order for this validation to be considered for execution';
comment on column apex_application_page_val.AUTHORIZATION_SCHEME_id is 'Foreign Key';
comment on column apex_application_page_val.COMPONENT_COMMENT       is 'Developer comment';
comment on column apex_application_page_val.VALIDATION_ID           is 'Primary key of this page validation';
comment on column apex_application_page_val.last_updated_by         is 'APEX developer who made last update';
comment on column apex_application_page_val.last_updated_on         is 'Date of last update';
comment on column apex_application_page_val.component_signature     is 'Identifies attributes defined at a given component level to facilitate application comparisons';





--------------------------------------------------
-- A P P L I C A T I O N   P A G E   B U T T O N S
--
prompt ...apex_application_page_buttons

create or replace view apex_application_page_buttons
as
select
     f.workspace,
     f.workspace_display_name,
     f.application_id,
     f.application_name,
     p.id                          page_id,
     p.name                        page_name,
     --
     b.BUTTON_SEQUENCE             button_sequence,
     (select plug_name
      from wwv_flow_page_plugs
      where id=b.BUTTON_PLUG_ID)   region,
     b.button_plug_id              region_id,
     b.BUTTON_NAME                 button_name,
     b.button_static_id            button_static_id,
     (select template_name
      from wwv_flow_button_templates
      where id = b.button_template_id
      and flow_id = f.application_id)          button_template,
     to_char(b.button_template_id) button_template_id,
     b.button_template_options     button_template_options,
     case b.button_is_hot
       when 'Y' then 'Yes'
       when 'N' then 'No'
     end                           button_is_hot,
     cast(null as varchar2(10))    image_name,
     b.BUTTON_IMAGE_ALT            label,
     nullif(b.BUTTON_POSITION,'BODY') display_position,
    case b.grid_new_grid
      when 'Y' then 'Yes'
      else 'No'
    end                            new_grid,
    case b.grid_new_row
      when 'Y' then 'Yes'
      else 'No'
    end                            new_grid_row,
    case b.grid_new_column
      when 'Y' then 'Yes'
      else 'No'
    end                            new_grid_column,
     grid_column,
     grid_column_span,
     grid_column_css_classes,
     grid_column_attributes,
     b.BUTTON_ALIGNMENT            alignment,
     --
     decode(b.button_action,
                'SUBMIT',           'Submit Page',
                'REDIRECT_PAGE',    'Redirect to Page in this Application',
                'REDIRECT_URL',     'Redirect to URL',
                'DEFINED_BY_DA',    'Defined by Dynamic Action',
                                    b.button_action)        button_action,
     b.button_action               button_action_code,
     b.BUTTON_REDIRECT_URL         redirect_url,
     case nvl(b.button_execute_validations, 'Y')
       when 'Y' then 'Yes'
       when 'N' then 'No'
     end                           execute_validations,
     --
     case
       when b.warn_on_unsaved_changes = 'I' then 'Do Not Check'
       else 'Page Default'
     end                           warn_on_unsaved_changes,
     b.warn_on_unsaved_changes     warn_on_unsaved_changes_code,
     --
     nvl((select r from apex_standard_conditions where d = b.BUTTON_CONDITION_TYPE),b.BUTTON_CONDITION_TYPE)
                                   condition_type,
     b.button_condition_type       condition_type_code,
     b.BUTTON_CONDITION            condition_expression1,
     b.BUTTON_CONDITION2           condition_expression2,
     cast(null as varchar2(10))    image_attributes,
     b.button_css_classes          button_css_classes,
     b.icon_css_classes            icon_css_classes,
     b.BUTTON_CATTRIBUTES          button_attributes,
     decode(
        b.DATABASE_ACTION,
        'DELETE','SQL DELETE action',
        'INSERT','SQL INSERT action',
        'UPDATE','SQL UPDATE action',
        b.DATABASE_ACTION)         database_action,
     --
     (select case when b.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from wwv_flow_patches
     where id= abs(b.REQUIRED_PATCH))   build_option,
     --
     decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(b.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     b.SECURITY_SCHEME)            authorization_scheme,
     b.SECURITY_SCHEME             authorization_scheme_id,
     --
     b.LAST_UPDATED_BY             last_updated_by,
     b.LAST_UPDATED_ON             last_updated_on,
     b.BUTTON_COMMENT              component_comment,
     case button_position
     when 'BODY' then 'Among region items'
     else 'Region Position'
     end                           button_position,
     b.id                          button_id,
     --
     b.BUTTON_NAME
     ||',s='||rpad(b.BUTTON_SEQUENCE,5,'00000')
     ||',r='||(select plug_name from wwv_flow_page_plugs where id=b.BUTTON_PLUG_ID)
     ||',bs='||b.button_static_id
     ||' t='||(select template_name from wwv_flow_button_templates t where b.button_template_id = t.id and t.flow_id = f.application_id)
     ||' label='||b.BUTTON_IMAGE_ALT
     ||' p='||b.BUTTON_POSITION
     ||' a='||b.BUTTON_ALIGNMENT
     ||' ba='||b.button_action
     ||' u='||substr(b.BUTTON_REDIRECT_URL,1,30)||length(b.BUTTON_REDIRECT_URL)
     ||' c='||b.BUTTON_CONDITION_TYPE
     ||substr(b.BUTTON_CONDITION,1,20)||length(b.BUTTON_CONDITION)||'.'
     ||substr(b.BUTTON_CONDITION2,1,20)||length(b.BUTTON_CONDITION2)
     ||' ca='||substr(b.BUTTON_CATTRIBUTES,1,20)||length(b.BUTTON_CATTRIBUTES)
     ||' b='||decode(
        b.DATABASE_ACTION,
        'DELETE','SQLDELETE',
        'INSERT','SQLINSERT',
        'UPDATE','SQLUPDATE',
        b.DATABASE_ACTION)
     ||' b='||(select PATCH_NAME
     from wwv_flow_patches
     where id= abs(b.REQUIRED_PATCH))
     ||' s='||decode(substr(b.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(b.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     'Not found')
     component_signature,
    b.PRE_ELEMENT_TEXT              pre_element_text,
    b.POST_ELEMENT_TEXT             post_element_text,
    b.request_source_type           request_source_type
from wwv_flow_step_buttons b,
     wwv_flow_steps        p,
     wwv_flow_authorized   f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = b.security_group_id
  and p.flow_id           = b.flow_id
  and p.id                = b.flow_step_id
/

comment on table  apex_application_page_buttons                       is 'Identifies buttons associated with a Page and Region';
comment on column apex_application_page_buttons.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_buttons.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_page_buttons.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_buttons.application_name      is 'Identifies the application';
comment on column apex_application_page_buttons.page_id               is 'Identifies the application';
comment on column apex_application_page_buttons.page_name             is 'Identifies a page within an application';
comment on column apex_application_page_buttons.BUTTON_SEQUENCE       is 'Identifies the display sequence of the button within the region and display position';
comment on column apex_application_page_buttons.REGION                is 'Identifies the Page Region in which this Button is displayed';
comment on column apex_application_page_buttons.REGION_ID             is 'Identifies the Page Region foreign key to the apex_application_page_regions view';
comment on column apex_application_page_buttons.BUTTON_NAME           is 'Identifies the name of the button, which when submitted becomes the REQUEST value';
comment on column apex_application_page_buttons.BUTTON_STATIC_ID      is 'Identifies the Static ID of the button';
comment on column apex_application_page_buttons.BUTTON_TEMPLATE       is 'Identifies the template used to display this button';
comment on column apex_application_page_buttons.BUTTON_TEMPLATE_ID    is 'Identifies the ID of the template used to display the button';
comment on column apex_application_page_buttons.BUTTON_TEMPLATE_OPTIONS is 'Identifies template options to be applied to the component template';
comment on column apex_application_page_buttons.button_is_hot         is 'Identifies if it''s a hot button and the hot button template should be used.';
comment on column apex_application_page_buttons.LABEL                 is 'Identifies the Button Label';
comment on column apex_application_page_buttons.image_name            is 'obsolete - always null';
comment on column apex_application_page_buttons.DISPLAY_POSITION      is 'Identifies the Display Position with the Region';
comment on column apex_application_page_buttons.new_grid              is 'Identifies if the rendering of the button begins on a new grid';
comment on column apex_application_page_buttons.new_grid_row          is 'Identifies if the rendering of the button begins on a new grid row';
comment on column apex_application_page_buttons.new_grid_column       is 'Identifies if the rendering of the button begins on a new grid column';
comment on column apex_application_page_buttons.grid_column           is 'Identifies the grid column used to display the button';
comment on column apex_application_page_buttons.grid_column_span      is 'Identifies over how many grid columns the button spans';
comment on column apex_application_page_buttons.grid_column_css_classes is 'Additional CSS classes which are substituted if the grid column template contains the substitution string #CSS_CLASSES#';
comment on column apex_application_page_buttons.grid_column_attributes  is 'Additional attributes which are substituted if the grid column template contains the substitution string #ATTRIBUTES#';
comment on column apex_application_page_buttons.ALIGNMENT             is 'Identifies the button alignment used for selected display positions';
comment on column apex_application_page_buttons.BUTTON_ACTION         is 'Identifies the Button Action';
comment on column apex_application_page_buttons.BUTTON_ACTION_CODE    is 'Internal code of Button Action';
comment on column apex_application_page_buttons.REDIRECT_URL          is 'Identifies an optional Page or URL to redirect to when this button is pressed.';
comment on column apex_application_page_buttons.execute_validations   is 'Identifies if built-in validations and page validations should be executed when the page is submitted.';
comment on column apex_application_page_buttons.warn_on_unsaved_changes      is 'Determines if a warning should be displayed in case of unsaved changes.';
comment on column apex_application_page_buttons.warn_on_unsaved_changes_code is 'Identifies the internal code WARN_ON_UNSAVED_CHANGES';
comment on column apex_application_page_buttons.CONDITION_TYPE        is 'Identifies the condition type used to conditionally display the Page Button';
comment on column apex_application_page_buttons.CONDITION_TYPE_CODE   is 'Internal code of CONDITION_TYPE';
comment on column apex_application_page_buttons.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_buttons.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_buttons.IMAGE_ATTRIBUTES      is 'obsolete - always null';
comment on column apex_application_page_buttons.button_css_classes    is 'CSS classes that are used to substitute #BUTTON_CSS_CLASSES# in button template';
comment on column apex_application_page_buttons.icon_css_classes      is 'CSS classes that are used to substitute #ICON_CSS_CLASSES# in button template';
comment on column apex_application_page_buttons.BUTTON_ATTRIBUTES     is 'Identifies the HTML INPUT tag attributes';
comment on column apex_application_page_buttons.DATABASE_ACTION       is 'A button can be used to trigger table row processing (insert, update, and delete). This attribute determines the type of DML action to be performed.';
comment on column apex_application_page_buttons.BUILD_OPTION          is 'Button will be displayed if the Build Option is enabled';
comment on column apex_application_page_buttons.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this button to be displayed';
comment on column apex_application_page_buttons.AUTHORIZATION_SCHEME_ID  is 'Foreign Key';
comment on column apex_application_page_buttons.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_page_buttons.BUTTON_POSITION       is 'Identifies where the button displays';
comment on column apex_application_page_buttons.BUTTON_ID             is 'Primary key of this page button';
comment on column apex_application_page_buttons.last_updated_by       is 'APEX developer who made last update';
comment on column apex_application_page_buttons.last_updated_on       is 'Date of last update';
comment on column apex_application_page_buttons.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_page_buttons.pre_element_text is 'Identifies text placed before the item.';
comment on column apex_application_page_buttons.post_element_text is 'Identifies text placed after the item.';
comment on column apex_application_page_buttons.request_source_type  is 'Identifies how the button request source is determined, for example from a Database Column, Static assignment, or a Query or PL/SQL expression.';




---------------------------------------------------
-- A P P L I C A T I O N   P A G E  D Y N A M I C   A C T I O N S
--
prompt ...apex_application_page_da

create or replace view apex_application_page_da
as
select  f.workspace,
        f.workspace_display_name,
        f.application_id,
        f.application_name,
        e.page_id                                               page_id,
        p.name                                                  page_name,
        --
        e.name                                                  dynamic_action_name,
        e.event_sequence                                        dynamic_action_sequence,
        e.triggering_element                                    when_element,
        decode(e.triggering_element_type,
            'ITEM',                  'Item',
            'BUTTON',                'Button',
            'REGION',                'Region',
            'COLUMN',                'Column',
            'DOM_OBJECT',            'DOM Object',
            'JQUERY_SELECTOR',       'jQuery Selector',
            'JAVASCRIPT_EXPRESSION', 'JavaScript Expression',
                                     e.triggering_element_type) when_selection_type,
        e.triggering_element_type                               when_selection_type_code,
        nvl((select plug_name
               from wwv_flow_page_plugs
              where id = e.triggering_region_id),
            e.triggering_region_id)                             when_region,
        e.triggering_region_id                                  when_region_id,
        --
        decode(e.triggering_button_id,
            null,   null,   coalesce(
                    (select button_name from wwv_flow_step_buttons where id = e.triggering_button_id),
                    (select name from wwv_flow_step_items where id = e.triggering_button_id)))
                                                                when_button,
        e.triggering_button_id                                  when_button_id,
        decode(e.condition_element_type,
            'ITEM',                  'Item',
            'COLUMN',                'Column',
                                     e.condition_element_type) 	when_condition_element_type,
        e.condition_element 									when_condition_element,
        --
        decode(e.triggering_condition_type,
            'EQUALS',               'equal to',
            'NOT_EQUALS',           'not equal to',
            'GREATER_THAN',         'greater than',
            'GREATER_THAN_OR_EQUAL','greater than or equal to',
            'LESS_THAN',            'less than',
            'LESS_THAN_OR_EQUAL',   'less than or equal to',
            'NULL',                 'is null',
            'NOT_NULL',             'is not null',
            'IN_LIST',              'in list',
            'NOT_IN_LIST',          'not in list',
            'JAVASCRIPT_EXPRESSION','JavaScript expression',
                                    e.triggering_condition_type)when_condition,
        e.triggering_expression                                 when_expression,
        --
        e.bind_type                                             when_event_scope,
        e.bind_delegate_to_selector                             when_event_static_container,
        e.bind_event_type                                       when_event_internal_name,
        (select d
          from wwv_flow_javascript_events
         where r = e.bind_event_type)                           when_event_name,
        e.bind_event_type_custom                                when_event_custom_name,
        --
        nvl((select r
               from apex_standard_conditions
              where d = e.display_when_type),
            e.display_when_type)                                condition_type,
        e.display_when_type                                     condition_type_code,
        e.display_when_cond                                     condition_expression1,
        e.display_when_cond2                                    condition_expression2,
        --
        (select case when e.required_patch > 0 then
                    patch_name
                else
                    '{Not '||patch_name||'}'
                end patch_name
           from wwv_flow_patches
          where id = abs(e.required_patch))                     build_option,
        e.required_patch                                        build_option_id,
        --
        decode(substr(e.security_scheme,1,1),'!','Not ')||
        nvl((select name
               from wwv_flow_security_schemes
              where to_char(id) = ltrim(e.security_scheme,'!')
                and flow_id = e.flow_id),
            e.security_scheme)                                  authorization_scheme,
        e.security_scheme                                       authorization_scheme_id,
        --
        e.last_updated_on                                       last_updated_on,
        e.last_updated_by                                       last_updated_by,
        e.da_event_comment                                      component_comment,
        e.id                                                    dynamic_action_id,
        --
        (select count(*)
           from wwv_flow_page_da_actions
          where event_id = e.id)                                number_of_actions,
        --
        'name='     || e.name ||
        ',seq='     || lpad(e.event_sequence,5,'00000') ||
        ',tee='     || substr(e.triggering_element,1,30) ||
        ',teet='    || e.triggering_element_type ||
        ',ter='     || nvl( (select plug_name
                              from wwv_flow_page_plugs
                             where id=e.triggering_region_id),
                            e.triggering_region_id) ||
        ',teb='     || decode(e.triggering_button_id,
                                null,   null,   coalesce(
                                                    (select button_name from wwv_flow_step_buttons where id = e.triggering_button_id),
                                                    (select name from wwv_flow_step_items where id = e.triggering_button_id))) ||
        ',tec='     || e.triggering_condition_type ||
        ',teexp='   || substr(e.triggering_expression,1,30) ||
        ',tebt='    || e.bind_type ||
        ',tebdts='  || e.bind_delegate_to_selector ||
        ',tebe='    || e.bind_event_type ||
        ',cond='    || e.display_when_type ||
                       substr(e.display_when_cond,1,20) ||
                       length(e.display_when_cond) ||
                       length(e.display_when_cond2) ||
        ',build='   || nvl( (select patch_name
                               from wwv_flow_patches
                              where id = abs(e.required_patch)),
                            e.required_patch) ||
        ' auth='    || decode(substr(e.security_scheme,1,1),'!','Not ')||
                       nvl( (select name
                              from wwv_flow_security_schemes
                             where to_char(id)= ltrim(e.security_scheme,'!')
                               and flow_id = e.flow_id),
                            e.security_scheme)                  component_signature
  from  wwv_flow_page_da_events e,
        wwv_flow_steps          p,
        wwv_flow_authorized     f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = e.security_group_id
  and p.flow_id           = e.flow_id
  and p.id                = e.page_id
/

--comments for apex_application_page_da view
comment on table apex_application_page_da is
    'Identifies Dynamic Actions associated with a Page';
comment on column apex_application_page_da.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_application_page_da.workspace_display_name is
    'Display name for the workspace';
comment on column apex_application_page_da.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_da.application_name is
    'Identifies the application';
comment on column apex_application_page_da.page_id is
    'Identifies page number';
comment on column apex_application_page_da.page_name is
    'Identifies a page within an application';
comment on column apex_application_page_da.dynamic_action_name is
    'Identifies the name of the Dynamic Action';
comment on column apex_application_page_da.dynamic_action_sequence is
    'Identifies the sequence the Dynamic Action is executed';
comment on column apex_application_page_da.when_element is
    'Identifies the element(s) that will be the trigger for the Dynamic Action';
comment on column apex_application_page_da.when_selection_type is
    'Identifies the type of selector used for the When Element';
comment on column apex_application_page_da.when_selection_type_code is
    'Internal code of WHEN_SELECTION_TYPE';
comment on column apex_application_page_da.when_region is
    'Identifies the name of the region containing the When Element(s)';
comment on column apex_application_page_da.when_region_id is
    'Identifies the ID of the region containing the When Element(s)';
comment on column apex_application_page_da.when_button is
    'Identifies the name of the button that will be the trigger for the Dynamic Action';
comment on column apex_application_page_da.when_button_id is
    'Identifies the ID of the button that will be the trigger for the Dynamic Action';
comment on column apex_application_page_da.when_condition_element_type is
	'Conditions can be based on a different element to the When Element(s). Identifies the type of element used for the When Condition';
comment on column apex_application_page_da.when_condition_element is
	'Conditions can be based on a different element to the When Element(s). Identifies the element(s) that will be used for the When Condition';
comment on column apex_application_page_da.when_condition is
    'Identifies the optional condition that can be used to control when the Action''s fire';
comment on column apex_application_page_da.when_expression is
    'Identifies the condition expression used to control when the Action''s fire';
comment on column apex_application_page_da.when_event_scope is
    'Identifies the scope of the event, can be either ''bind'', ''live'' or ''once''';
comment on column apex_application_page_da.when_event_static_container is
    'Identifies a jQuery selector to select the Static Container element, that can be used to delegate the event handling to';
comment on column apex_application_page_da.when_event_internal_name is
    'Identifies the internal name of the event that is used to define when the dynamic action fires';
comment on column apex_application_page_da.when_event_name is
    'Identifies the display name of the event that is used to define when the dynamic action fires';
comment on column apex_application_page_da.condition_type is
    'Identifies a condition that must be met in order for this Dynamic Action to be processed';
comment on column apex_application_page_da.condition_type_code is
    'Internal code of CONDITION_TYPE';
comment on column apex_application_page_da.condition_expression1 is
    'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_da.condition_expression2 is
    'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_page_da.build_option is
    'Dynamic Action will be processed if the Build Option is enabled';
comment on column apex_application_page_da.build_option_id is
    'Foreign Key';
comment on column apex_application_page_da.authorization_scheme is
    'An authorization scheme must evaluate to TRUE in order for this Dynamic Action to be processed';
comment on column apex_application_page_da.authorization_scheme_id is
    'Foreign Key';
comment on column apex_application_page_da.last_updated_on is
    'Date of last update';
comment on column apex_application_page_da.last_updated_by is
    'APEX developer who made last update';
comment on column apex_application_page_da.component_comment is
    'Developer comment';
comment on column apex_application_page_da.dynamic_action_id is
    'Primary Key of this Dynamic Action';
comment on column apex_application_page_da.number_of_actions is
    'Number of Actions defined for this Dynamic Action';
comment on column apex_application_page_da.component_signature is
    'Identifies attributes defined at a given component level to facilitate application comparisons';



prompt ...apex_application_page_da_acts

create or replace view apex_application_page_da_acts
as
select  fa.workspace                                        workspace,
        fa.workspace_display_name                           workspace_display_name,
        fa.application_id                                   application_id,
        fa.application_name                                 application_name,
        a.page_id                                           page_id,
        p.name                                              page_name,
        a.event_id                                          dynamic_action_id,
        e.name                                              dynamic_action_name,
        case substr(a.action, 1, 7)
          when 'NATIVE_' then
              ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = 'DYNAMIC ACTION' and name = substr(a.action, 8) )
          when 'PLUGIN_' then
              ( select display_name from wwv_flow_plugins where flow_id = a.flow_id and plugin_type = 'DYNAMIC ACTION' and name = substr(a.action, 8) )
          else a.action
        end                                                 action_name,
        a.action                                            action_code,
        a.name                                              action_pd_name,
        a.action_sequence                                   action_sequence,
        decode(a.event_result,  'TRUE',     'True',
                                'FALSE',    'False',
                                            a.event_result )                dynamic_action_event_result,
        decode(a.execute_on_page_init,  'Y',    'Yes',
                                        'N',    'No',
                                                a.execute_on_page_init )    execute_on_page_init,
        a.affected_elements                                 affected_elements,
        decode(a.affected_elements_type,
            'ITEM',                  'Item',
            'REGION',                'Region',
            'COLUMN',                'Column',
            'DOM_OBJECT',            'DOM Object',
            'JQUERY_SELECTOR',       'jQuery Selector',
            'JAVASCRIPT_EXPRESSION', 'JavaScript Expression',
            'TRIGGERING_ELEMENT',    'Triggering Element',
            'EVENT_SOURCE',          'Event Source',
                                     a.affected_elements_type) affected_elements_type,
        a.affected_elements_type                            affected_elements_type_code,
        nvl((select plug_name
               from wwv_flow_page_plugs
              where id = a.affected_region_id),
            a.affected_region_id)                           affected_region,
        a.affected_region_id                                affected_region_id,
        decode(a.affected_button_id,
            null,   null,   coalesce(
                    (select button_name from wwv_flow_step_buttons where id = a.affected_button_id),
                    (select name from wwv_flow_step_items where id = a.affected_button_id)))
                                                            affected_button,
        a.affected_button_id                                affected_button_id,
        --
        a.plugin_init_javascript_code                       init_javascript_code,
        --
        a.attribute_01                                      attribute_01,
        a.attribute_02                                      attribute_02,
        a.attribute_03                                      attribute_03,
        a.attribute_04                                      attribute_04,
        a.attribute_05                                      attribute_05,
        a.attribute_06                                      attribute_06,
        a.attribute_07                                      attribute_07,
        a.attribute_08                                      attribute_08,
        a.attribute_09                                      attribute_09,
        a.attribute_10                                      attribute_10,
        a.attribute_11                                      attribute_11,
        a.attribute_12                                      attribute_12,
        a.attribute_13                                      attribute_13,
        a.attribute_14                                      attribute_14,
        a.attribute_15                                      attribute_15,
        case when a.stop_execution_on_error = 'Y' then 'Yes' else 'No' end as
                                                            stop_execution_on_error,
        case a.wait_for_result
            when 'Y' then 'Yes'
            when 'N' then 'No'
        end                                                 wait_for_result,
        a.last_updated_by                                   last_updated_by,
        a.last_updated_on                                   last_updated_on,
        a.da_action_comment                                 component_comment,
        a.id                                                action_id,
        --
        'action='   || a.action ||
        ',seq='     || lpad(a.action_sequence,5,'00000') ||
        ',er='      || a.event_result ||
        ',eopi='    || a.execute_on_page_init ||
        ',ae='      || substr(a.affected_elements,1,30) ||
        ',aet='     || a.affected_elements_type ||
        ',aer='     || nvl( (select plug_name
                               from wwv_flow_page_plugs
                              where id=a.affected_region_id),
                            a.affected_region_id) ||
        ',aeb='     || decode(a.affected_button_id,
                                null,   null,   coalesce(
                                                   (select button_name from wwv_flow_step_buttons where id = a.affected_button_id),
                                                   (select name from wwv_flow_step_items where id = a.affected_button_id))) ||
        ',seoe='    || a.stop_execution_on_error ||
        ',wfr='     || a.wait_for_result
        component_signature
  from  wwv_flow_page_da_actions a,
        wwv_flow_page_da_events e,
        wwv_flow_authorized fa,
        wwv_flow_steps p
 where  a.flow_id = fa.application_id
   and  e.id      = a.event_id
   and  p.flow_id = a.flow_id
   and  p.id      = a.page_id;

--comments
comment on table apex_application_page_da_acts is
    'Identifies the Actions of a Dynamic Action associated with a Page';
comment on column apex_application_page_da_acts.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_application_page_da_acts.workspace_display_name is
    'Display name for the workspace';
comment on column apex_application_page_da_acts.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_da_acts.application_name is
    'Identifies the application';
comment on column apex_application_page_da_acts.page_id is
    'Identifies page number';
comment on column apex_application_page_da_acts.page_name is
    'Identifies a page within an application';
comment on column apex_application_page_da_acts.dynamic_action_id is
    'Primary Key of the associated Dynamic Action';
comment on column apex_application_page_da_acts.dynamic_action_name is
    'Identifies the name of the Dynamic Action that these Actions are associated with';
comment on column apex_application_page_da_acts.action_name is
    'Identifies the name of the Action (eg Show, Hide, Execute JavaScript Code etc.)';
comment on column apex_application_page_da_acts.action_code is
    'Internal code of ACTION_NAME';
comment on column apex_application_page_da_acts.action_pd_name is
    'Identified the name defined in Page Designer for the Action';
comment on column apex_application_page_da_acts.action_sequence is
    'Identifies the sequence the Action is executed';
comment on column apex_application_page_da_acts.dynamic_action_event_result is
    'Defines when the Action will execute as a result of whether the Dynamic Action When Condition has passed or failed';
comment on column apex_application_page_da_acts.execute_on_page_init is
    'Defines whether the Action will also execute when the page initially loads';
comment on column apex_application_page_da_acts.affected_elements is
    'Identifies the element(s) that will be affected by the Action';
comment on column apex_application_page_da_acts.affected_elements_type is
    'Identifies the type of selector used for the Affected Element(s)';
comment on column apex_application_page_da_acts.affected_elements_type_code is
    'Internal code of AFFECTED_ELEMENTS_TYPE';
comment on column apex_application_page_da_acts.affected_region is
    'Identifies the name of the region containing the Affected Element(s)';
comment on column apex_application_page_da_acts.affected_region_id is
    'Identifies the ID of the region containing the Affected Element(s)';
comment on column apex_application_page_da_acts.affected_button is
    'Identifies the button that will be affected by the Action';
comment on column apex_application_page_da_acts.affected_button_id is
    'Identifies the ID of the button that will be affected by the Action';
comment on column apex_application_page_da_acts.init_javascript_code is
    'JavaScript code for dynamic action initialization';
comment on column apex_application_page_da_acts.attribute_01 is
    'Identifies attribute 01 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_02 is
    'Identifies attribute 02 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_03 is
    'Identifies attribute 03 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_04 is
    'Identifies attribute 04 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_05 is
    'Identifies attribute 05 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_06 is
    'Identifies attribute 06 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_07 is
    'Identifies attribute 07 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_08 is
    'Identifies attribute 08 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_09 is
    'Identifies attribute 09 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_10 is
    'Identifies attribute 10 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_11 is
    'Identifies attribute 11 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_12 is
    'Identifies attribute 12 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_13 is
    'Identifies attribute 13 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_14 is
    'Identifies attribute 14 for Plug-In Actions';
comment on column apex_application_page_da_acts.attribute_15 is
    'Identifies attribute 15 for Plug-In Actions';
comment on column apex_application_page_da_acts.stop_execution_on_error is
    'Defines whether the following Actions are executed in case of an error';
comment on column apex_application_page_da_acts.wait_for_result is
    'Defines whether the following Actions wait for the result of the current action, before executing';
comment on column apex_application_page_da_acts.last_updated_by is
    'APEX Developer who made the last update';
comment on column apex_application_page_da_acts.last_updated_on is
    'Date of last update';
comment on column apex_application_page_da_acts.component_comment is
    'Developer comment';
comment on column apex_application_page_da_acts.action_id is
    'Primary Key of the Action';
comment on column apex_application_page_da_acts.component_signature is
    'Identifies attributes defined at a given component level to facilitate application comparisons';




---------------------------------------------------
-- A P P L I C A T I O N   B U I L D  O P T I O N S
--
prompt ...apex_application_build_options

create or replace view apex_application_build_options
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    b.PATCH_NAME                     build_option_name,
    decode(b.PATCH_STATUS,
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.patch_status)              build_option_status,
    decode(nvl(b.DEFAULT_ON_EXPORT,
        b.patch_status),
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.DEFAULT_ON_EXPORT)         status_on_export,
    case b.on_upgrade_keep_status
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end                              on_upgrade_keep_status,
    b.feature_identifier,
    --b.ATTRIBUTE1                   attribute1,
    --b.ATTRIBUTE2                   attribute2,
    --b.ATTRIBUTE3                   attribute3,
    --b.ATTRIBUTE4                   attribute4,
    b.LAST_UPDATED_BY                last_updated_by,
    b.LAST_UPDATED_ON                last_updated_on,
    b.PATCH_COMMENT                  component_comment,
    b.id                             build_option_id,
    --
    b.PATCH_NAME
    ||' s='||decode(b.PATCH_STATUS,
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.patch_status)
    ||' e='||decode(nvl(b.DEFAULT_ON_EXPORT,
        b.patch_status),
        'INCLUDE','Include',
        'EXCLUDE','Exclude',
        b.DEFAULT_ON_EXPORT)
    component_signature
from wwv_flow_patches    b,
     wwv_flow_authorized f
where f.workspace_id      = b.security_group_id
  and f.application_id    = b.flow_id
/

comment on table  apex_application_build_options                      is 'Identifies Build Options available to an application';
comment on column apex_application_build_options.workspace            is 'A work area mapped to one or more database schemas';
comment on column apex_application_build_options.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_build_options.application_id       is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_build_options.application_name     is 'Identifies the application';
comment on column apex_application_build_options.BUILD_OPTION_NAME    is 'Identifies the build option';
comment on column apex_application_build_options.BUILD_OPTION_STATUS  is 'Identifies the current status of the Build option; Include or Exclude.';
comment on column apex_application_build_options.STATUS_ON_EXPORT     is 'Identifies the status (Include or Exclude) of this Build Option when the build option is exported.';
comment on column apex_application_build_options.on_upgrade_keep_status is 'Should the current status be kept or set to the specified status when the application is upgraded?';
comment on column apex_application_build_options.feature_identifier   is 'Feature identifier';
comment on column apex_application_build_options.COMPONENT_COMMENT    is 'Developer Comment';
comment on column apex_application_build_options.BUILD_OPTION_ID      is 'Identifies the primary key of this component';
comment on column apex_application_build_options.last_updated_by      is 'APEX developer who made last update';
comment on column apex_application_build_options.last_updated_on      is 'Date of last update';
comment on column apex_application_build_options.component_signature  is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------
-- A P P L I C A T I O N   T A B S
--
prompt ...apex_application_tabs

create or replace view apex_application_tabs
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.TAB_SET                        tab_set,
    t.TAB_SEQUENCE                   display_sequence,
    t.TAB_NAME                       tab_name,
    t.TAB_IMAGE                      when_current_tab_image,
    t.TAB_NON_CURRENT_IMAGE          when_not_current_tab_image,
    t.TAB_IMAGE_ATTRIBUTES           tab_image_attributes,
    t.TAB_TEXT                       tab_label,
    t.TAB_STEP                       tab_page,
    t.TAB_ALSO_CURRENT_FOR_PAGES     tab_also_current_for_pages,
    t.TAB_PARENT_TABSET              parent_tabset,
    --
    nvl((select r from apex_standard_conditions where d = t.DISPLAY_CONDITION_TYPE),t.DISPLAY_CONDITION_TYPE)
                                     condition_type,
    t.display_condition_type         condition_type_code,
    t.TAB_PLSQL_CONDITION            condition_expression1,
    t.TAB_DISP_COND_TEXT             condition_expression2,
    --
    (select case when t.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))    build_option,
     --
    decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     t.SECURITY_SCHEME)              authorization_scheme,
    t.SECURITY_SCHEME                authorization_scheme_id,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    t.TAB_COMMENT                    component_comment,
    t.id                             tab_id,
    --
    t.TAB_SET
    ||' '||lpad(t.TAB_SEQUENCE,5,'00000')
    ||' '||t.TAB_NAME
    ||substr(t.TAB_IMAGE,1,30)||length(t.TAB_IMAGE)
    ||substr(t.TAB_NON_CURRENT_IMAGE,1,30)||length(t.TAB_NON_CURRENT_IMAGE)
    ||substr(t.TAB_IMAGE_ATTRIBUTES,1,30)||length(t.TAB_IMAGE_ATTRIBUTES)
    ||' text='||substr(t.TAB_TEXT,1,30)||length(t.TAB_TEXT)
    ||' p='||t.TAB_STEP
    ||' a='||substr(t.TAB_ALSO_CURRENT_FOR_PAGES,1,30)||length(t.TAB_ALSO_CURRENT_FOR_PAGES)
    ||substr(t.TAB_PARENT_TABSET,1,30)||length(t.TAB_PARENT_TABSET)
    ||' c='||t.DISPLAY_CONDITION_TYPE
    ||substr(t.TAB_PLSQL_CONDITION,1,30)||length(t.TAB_PLSQL_CONDITION)
    ||substr(t.TAB_DISP_COND_TEXT,1,30)||length(t.TAB_DISP_COND_TEXT)
    ||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))
    ||decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     'Not found')
    component_signature
from wwv_flow_tabs       t,
     wwv_flow_authorized f
where f.workspace_id      = t.security_group_id
  and f.application_id    = t.flow_id
/

comment on table  apex_application_tabs                            is 'Identifies a set of tabs collected into tab sets which are associated with a Standard Tab Entry';
comment on column apex_application_tabs.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_tabs.workspace_display_name     is 'Display name for the workspace';
comment on column apex_application_tabs.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_tabs.application_name           is 'Identifies the application';
comment on column apex_application_tabs.TAB_SET                    is 'Identifies a collection of tabs that will be displayed together.  If an application uses tabs each page identifies the Tab Set to be displayed with the page.';
comment on column apex_application_tabs.DISPLAY_SEQUENCE           is 'Identifies the display sequence of the Tab within the Tab Set';
comment on column apex_application_tabs.TAB_NAME                   is 'Identifies the name of the tab; which will be the value of the REQUEST when the tab is pressed';
comment on column apex_application_tabs.WHEN_CURRENT_TAB_IMAGE     is 'For tabs displayed using images and not a Tab Label, identifies the current tab image';
comment on column apex_application_tabs.WHEN_NOT_CURRENT_TAB_IMAGE is 'For tabs displayed using images and not a Tab Label, identifies the non current tab image';
comment on column apex_application_tabs.TAB_IMAGE_ATTRIBUTES       is 'Identifies the HTML IMG tag image attributes';
comment on column apex_application_tabs.TAB_LABEL                  is 'Identifies the display Tab Label for tabs that are not based on image';
comment on column apex_application_tabs.TAB_PAGE                   is 'Identifies the page which is current and associated with this tab.';
comment on column apex_application_tabs.TAB_ALSO_CURRENT_FOR_PAGES is 'Identifies one or more other page ID''s which are also current for this tab';
comment on column apex_application_tabs.PARENT_TABSET              is 'Identifies the Parent Tab Tab-Set to be displayed when this tab is current.  Used only when using two levels of tabs.';
comment on column apex_application_tabs.CONDITION_TYPE             is 'Identifies the condition type used to conditionally display the tab.';
comment on column apex_application_tabs.CONDITION_TYPE_CODE        is 'Internal code of CONDITION_TYPE';
comment on column apex_application_tabs.CONDITION_EXPRESSION1      is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_tabs.CONDITION_EXPRESSION2      is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_tabs.BUILD_OPTION               is 'Tab will be displayed if the Build Option is enabled';
comment on column apex_application_tabs.AUTHORIZATION_SCHEME       is 'An authorization scheme must evaluate to TRUE in order for this tab to be displayed';
comment on column apex_application_tabs.AUTHORIZATION_SCHEME_ID    is 'Foreign Key';
comment on column apex_application_tabs.COMPONENT_COMMENT          is 'Developer comment';
comment on column apex_application_tabs.TAB_ID                     is 'Primary key of this tab';
comment on column apex_application_tabs.last_updated_by            is 'APEX developer who made last update';
comment on column apex_application_tabs.last_updated_on            is 'Date of last update';
comment on column apex_application_tabs.component_signature        is 'Identifies attributes defined at a given component level to facilitate application comparisons';



---------------------------------------------------
-- A P P L I C A T I O N   P A R E N T   T A B S
--
prompt ...apex_application_parent_tabs

create or replace view apex_application_parent_tabs
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.TAB_SET                        tab_set,
    t.TAB_SEQUENCE                   display_sequence,
    t.TAB_NAME                       tab_name,
    t.TAB_IMAGE                      when_current_image,
    t.TAB_NON_CURRENT_IMAGE          when_non_current_image,
    t.TAB_IMAGE_ATTRIBUTES           image_attributes,
    t.TAB_TEXT                       tab_label,
    t.TAB_TARGET                     tab_target,
    --
    nvl((select r from apex_standard_conditions where d = t.DISPLAY_CONDITION_TYPE),t.DISPLAY_CONDITION_TYPE)
                                     condition_type,
    t.display_condition_type         condition_type_code,
    t.DISPLAY_CONDITION              condition_expression1,
    t.DISPLAY_CONDITION2             condition_expression2,
    --
    t.CURRENT_ON_TABSET              current_for_tabset,
    --
    (select case when t.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))    build_option,
    --
    decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     t.SECURITY_SCHEME)              authorization_scheme,
    t.SECURITY_SCHEME                authorization_scheme_id,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    t.TAB_COMMENT                    component_comment,
    t.id                             parent_tab_id,
    --
    t.TAB_SET
    ||' '||lpad(t.TAB_SEQUENCE,5,'00000')
    ||' '||substr(t.TAB_NAME              ,1,30)||length(t.TAB_NAME             )
    ||' '||substr(t.TAB_IMAGE             ,1,30)||length(t.TAB_IMAGE            )
    ||' '||substr(t.TAB_NON_CURRENT_IMAGE ,1,30)||length(t.TAB_NON_CURRENT_IMAGE)
    ||' '||substr(t.TAB_IMAGE_ATTRIBUTES  ,1,30)||length(t.TAB_IMAGE_ATTRIBUTES )
    ||' '||substr(t.TAB_TEXT              ,1,30)||length(t.TAB_TEXT             )
    ||' '||substr(t.TAB_TARGET            ,1,30)||length(t.TAB_TARGET           )
    ||' cond='||t.DISPLAY_CONDITION_TYPE
    ||substr(t.DISPLAY_CONDITION,1,30)||length(t.DISPLAY_CONDITION)
    ||substr(t.DISPLAY_CONDITION2,1,30)||length(t.DISPLAY_CONDITION2)
    ||' ct='||t.CURRENT_ON_TABSET
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(t.REQUIRED_PATCH))
    ||' sec='||decode(substr(t.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(t.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     'Not found')
    component_signature
from wwv_flow_toplevel_tabs t,
     wwv_flow_authorized    f
where f.workspace_id      = t.security_group_id
  and f.application_id    = t.flow_id
/

comment on table  apex_application_parent_tabs                        is 'Identifies a collection of tabs called a Tab Set.  Each tab is part of a tab set and can be current for one or more pages.  Each tab can also have a corresponding Parent Tab if two levels of Tabs are defined.';
comment on column apex_application_parent_tabs.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_parent_tabs.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_parent_tabs.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_parent_tabs.application_name       is 'Identifies the application';
comment on column apex_application_parent_tabs.TAB_SET                is 'Identifies a collection of Parent Tabs that are displayed together.';
comment on column apex_application_parent_tabs.DISPLAY_SEQUENCE       is 'Identifies the display sequence within the Tab Set';
comment on column apex_application_parent_tabs.TAB_NAME               is 'Identifies the Tab Name';
comment on column apex_application_parent_tabs.WHEN_CURRENT_IMAGE     is 'For tabs displayed using images and not a Tab Label, identifies the current tab image';
comment on column apex_application_parent_tabs.WHEN_NON_CURRENT_IMAGE is 'For tabs displayed using images and not a Tab Label, identifies the non current tab image';
comment on column apex_application_parent_tabs.IMAGE_ATTRIBUTES       is 'Identifies the HTML IMG tag image attributes';
comment on column apex_application_parent_tabs.TAB_LABEL              is 'Identifies the display Tab Label for tabs that are not based on image';
comment on column apex_application_parent_tabs.TAB_TARGET             is 'Identifies the Page or URL to branch to when this Parent Tab is pressed';
comment on column apex_application_parent_tabs.CONDITION_TYPE         is 'Identifies the condition type used to conditionally display the tab.';
comment on column apex_application_parent_tabs.CONDITION_TYPE_CODE    is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_parent_tabs.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_parent_tabs.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_parent_tabs.CURRENT_FOR_TABSET     is 'Identifies the child (corresponding standard tab) of this parent tab.';
comment on column apex_application_parent_tabs.BUILD_OPTION           is 'Tab will be displayed if the Build Option is enabled';
comment on column apex_application_parent_tabs.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this tab to be displayed';
comment on column apex_application_parent_tabs.AUTHORIZATION_SCHEME_id is 'Foreign Key';
comment on column apex_application_parent_tabs.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_parent_tabs.PARENT_TAB_ID          is 'Primary key of the Parent Tab component';
comment on column apex_application_parent_tabs.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_parent_tabs.last_updated_on        is 'Date of last update';
comment on column apex_application_parent_tabs.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- S U P P OR T I N G    O B J E C T S
--
prompt ...apex_application_supp_objects

create or replace view apex_application_supp_objects
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    (select count(*)
    from wwv_flow_install_build_opt
    where install_id = i.id)         build_options,
    --
    decode(i.INCLUDE_IN_EXPORT_YN,
      'Y','Yes',
      'N','No',
      i.INCLUDE_IN_EXPORT_YN)        include_in_application_export,
    i.WELCOME_MESSAGE                ,
    i.LICENSE_MESSAGE                ,
    i.VALIDATION_MESSAGE             ,
    --
    i.INSTALL_MESSAGE                installation_message,
    i.INSTALL_SUCCESS_MESSAGE        installation_success_message,
    i.INSTALL_FAILURE_MESSAGE        installation_failure_message,
    (select count(*)
     from wwv_flow_install_scripts
     where i.id = install_id
       and nvl(script_type,'INSTALL') = 'INSTALL')
                                     installation_scripts,
    --
    i.get_version_sql_query          upgrade_when_query,
    i.upgrade_message                upgrade_message,
    i.upgrade_confirm_message        upgrade_confirm_message,
    i.upgrade_success_message        upgrade_success_message,
    i.upgrade_failure_message        upgrade_failure_message,
    (select count(*)
     from wwv_flow_install_scripts
     where i.id = install_id
       and nvl(script_type,'INSTALL') = 'UPGRADE')
                                     upgrade_scripts,
    --
    --
    i.DEINSTALL_MESSAGE              ,
    i.DEINSTALL_SUCCESS_MESSAGE      ,
    --i.DEINSTALL_FAILURE_MESSAGE      ,
    i.DEINSTALL_SCRIPT               deinstallation_script,
    --
    --i.PROMPT_SUBSTITUTION_01_YN      ,
    --i.PROMPT_SUBSTITUTION_02_YN      ,
    --i.PROMPT_SUBSTITUTION_03_YN      ,
    --i.PROMPT_SUBSTITUTION_04_YN      ,
    --i.PROMPT_SUBSTITUTION_05_YN      ,
    --i.PROMPT_SUBSTITUTION_06_YN      ,
    --i.PROMPT_SUBSTITUTION_07_YN      ,
    --i.PROMPT_SUBSTITUTION_08_YN      ,
    --i.PROMPT_SUBSTITUTION_09_YN      ,
    --i.PROMPT_SUBSTITUTION_10_YN      ,
    --i.PROMPT_SUBSTITUTION_11_YN      ,
    --i.PROMPT_SUBSTITUTION_12_YN      ,
    --i.PROMPT_SUBSTITUTION_13_YN      ,
    --i.PROMPT_SUBSTITUTION_14_YN      ,
    --i.PROMPT_SUBSTITUTION_15_YN      ,
    --i.PROMPT_SUBSTITUTION_16_YN      ,
    --i.PROMPT_SUBSTITUTION_17_YN      ,
    --i.PROMPT_SUBSTITUTION_18_YN      ,
    --i.PROMPT_SUBSTITUTION_19_YN      ,
    --i.PROMPT_SUBSTITUTION_20_YN      ,
    ----
    --i.PROMPT_IF_MULT_AUTH_YN         ,
    --i.PROMPT_BUILD_OPTIONS           ,
    --
    i.LAST_UPDATED_BY                ,
    i.LAST_UPDATED_ON                ,
    i.CREATED_BY                     ,
    i.CREATED_ON                     ,
    --
    --i.INSTALL_PROMPT_01              ,
    --i.INSTALL_PROMPT_02              ,
    --i.INSTALL_PROMPT_03              ,
    --i.INSTALL_PROMPT_04              ,
    --i.INSTALL_PROMPT_05              ,
    --i.INSTALL_PROMPT_06              ,
    --i.INSTALL_PROMPT_07              ,
    --i.INSTALL_PROMPT_08              ,
    --i.INSTALL_PROMPT_09              ,
    --i.INSTALL_PROMPT_10              ,
    --i.INSTALL_PROMPT_11              ,
    --i.INSTALL_PROMPT_12              ,
    --i.INSTALL_PROMPT_13              ,
    --i.INSTALL_PROMPT_14              ,
    --i.INSTALL_PROMPT_15              ,
    --i.INSTALL_PROMPT_16              ,
    --i.INSTALL_PROMPT_17              ,
    --i.INSTALL_PROMPT_18              ,
    --i.INSTALL_PROMPT_19              ,
    --i.INSTALL_PROMPT_20              ,
    i.CONFIGURATION_MESSAGE          ,
    -- obsolete i.TRIGGER_INSTALL_WHEN_COND      ,
    -- obsolete i.TRIGGER_INSTALL_WHEN_EXP1      ,
    -- obsolete i.TRIGGER_INSTALL_WHEN_EXP2      ,
    -- obsolete i.TRIGGER_FAILURE_MESSAGE        ,
    i.BUILD_OPTIONS_MESSAGE          ,
    i.REQUIRED_FREE_KB               ,
    i.REQUIRED_SYS_PRIVS             required_system_privileges,
    i.REQUIRED_NAMES_AVAILABLE       ,
    --
    i.id                             supporting_object_id
from wwv_flow_install    i,
     wwv_flow_authorized f
where f.workspace_id   = i.security_group_id
  and f.application_id = i.flow_id
/

comment on table  apex_application_supp_objects                               is 'Identifies the Supporting Object installation messages';
comment on column apex_application_supp_objects.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_objects.workspace_display_name        is 'Display name for the workspace';
comment on column apex_application_supp_objects.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_objects.application_name              is 'Identifies the application';
comment on column apex_application_supp_objects.BUILD_OPTIONS                 is 'Count of Build Options referenced in this applications supporting object installation wizard';
comment on column apex_application_supp_objects.INCLUDE_IN_APPLICATION_EXPORT is 'Flag that specifies if the application export will include the supporting object definitions and scripts';
comment on column apex_application_supp_objects.WELCOME_MESSAGE               is 'After successfully importing and installing an application definition, the installation wizard prompts the user to install supporting objects for the application.';
comment on column apex_application_supp_objects.LICENSE_MESSAGE               is 'If the use of this application requires the user to accept a license, enter it here. The user will be prompted to accept the message before installing database objects.';
comment on column apex_application_supp_objects.VALIDATION_MESSAGE            is 'Message to display above the list of installation validations when this application installs.';
comment on column apex_application_supp_objects.INSTALLATION_MESSAGE          is 'Message to display during installation confirmation before the installation scripts are run and configuration options are applied.';
comment on column apex_application_supp_objects.INSTALLATION_SUCCESS_MESSAGE  is 'Enter a message to display after all installation scripts have run without errors.';
comment on column apex_application_supp_objects.INSTALLATION_FAILURE_MESSAGE  is 'Enter a message to display after installation scripts have been run with errors.';
comment on column apex_application_supp_objects.INSTALLATION_SCRIPTS          is 'Count of installation SQL scripts';
comment on column apex_application_supp_objects.upgrade_when_query            is 'SQL query that returns at least one row if supporting objects exist, which means an upgrade should be performed';
comment on column apex_application_supp_objects.upgrade_message               is 'Message to display before this application''s supporting objects are upgraded';
comment on column apex_application_supp_objects.upgrade_confirm_message       is 'Message to display during upgrade confirmation before the upgrade scripts are run and configuration options are applied';
comment on column apex_application_supp_objects.upgrade_success_message       is 'Message to display after all upgrade scripts have run without errors';
comment on column apex_application_supp_objects.upgrade_failure_message       is 'Message to display after upgrade scripts have been run with errors';
comment on column apex_application_supp_objects.upgrade_scripts               is 'Count of upgrade SQL scripts';
comment on column apex_application_supp_objects.DEINSTALL_MESSAGE             is 'Enter a message to display during deinstallation confirmation when this application is deinstalled.';
comment on column apex_application_supp_objects.DEINSTALL_SUCCESS_MESSAGE     is 'Enter a message to display after all deinstallation scripts have run.';
comment on column apex_application_supp_objects.DEINSTALLATION_SCRIPT         is 'The deinstallation SQL script, uses SQL*plus like script syntax';
comment on column apex_application_supp_objects.CREATED_BY                    is 'APEX developer who created the component';
comment on column apex_application_supp_objects.CREATED_ON                    is 'Date created';
comment on column apex_application_supp_objects.CONFIGURATION_MESSAGE         is 'Message to display above the application substitution prompts when this application installs.';
comment on column apex_application_supp_objects.BUILD_OPTIONS_MESSAGE         is 'Message to display above the build option prompts when this application installs.';
comment on column apex_application_supp_objects.REQUIRED_FREE_KB              is 'Freespace required to install this application.';
comment on column apex_application_supp_objects.required_system_privileges    is 'Identifies the system privileges required to install this application.';
comment on column apex_application_supp_objects.REQUIRED_NAMES_AVAILABLE      is 'Installation is prevented if these objects already exist in the parsing schema.';
comment on column apex_application_supp_objects.SUPPORTING_OBJECT_ID          is 'Primary Key of this component';
comment on column apex_application_supp_objects.last_updated_by               is 'APEX developer who made last update';
comment on column apex_application_supp_objects.last_updated_on               is 'Date of last update';



create or replace view apex_application_supp_obj_bopt
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    (select patch_name
     from   wwv_flow_patches
     where  id=i.BUILD_OPT_ID)       build_option,
    --
    decode(
    (select patch_status
     from   wwv_flow_patches
     where  id=i.BUILD_OPT_ID),
     'INCLUDE','Include',
     'EXCLUDE','Exclude',
     i.BUILD_OPT_ID)                 default_status,
    --
    (select patch_comment
     from   wwv_flow_patches
     where  id=i.BUILD_OPT_ID)       developer_comment,
     i.id                            install_build_option_id
from wwv_flow_install_build_opt i,
     wwv_flow_authorized        f
where f.workspace_id   = i.security_group_id
  and f.application_id = i.flow_id
/


comment on table  apex_application_supp_obj_bopt                         is 'Identifies the Application Build Options that will be exposed to the Supporting Object installation';
comment on column apex_application_supp_obj_bopt.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_obj_bopt.workspace_display_name  is 'Display name for the workspace';
comment on column apex_application_supp_obj_bopt.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_obj_bopt.application_name        is 'Identifies the application';
comment on column apex_application_supp_obj_bopt.build_option            is 'Identifies the Application Build Option that will be prompted for during the installation of the Supporting Objects';
comment on column apex_application_supp_obj_bopt.default_status          is 'Identifies the default Status (Excluded, Included) of the Build Option';
comment on column apex_application_supp_obj_bopt.developer_comment       is 'Identifies the developer comment applied to the Build Option definition';
comment on column apex_application_supp_obj_bopt.install_build_option_id is 'Primary Key of this Supporting Object Build Option';


create or replace view apex_application_supp_obj_scr
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    i.NAME                           script_name,
    i.SEQUENCE                       execution_sequence,
    decode(i.SCRIPT_TYPE,
           'UPGRADE','Upgrade',
           'INSTALL','Install',
           i.SCRIPT_TYPE)            script_type,
    --
    i.SCRIPT                         sql_script,
    --
    nvl((select r from apex_standard_conditions where d = i.condition_type), i.condition_type) condition_type,
    i.CONDITION_TYPE                 condition_type_code,
    i.CONDITION                      condition_expression1,
    i.CONDITION2                     condition_expression2,
    --
    i.LAST_UPDATED_BY                last_updated_by,
    i.LAST_UPDATED_ON                last_updated_on,
    i.CREATED_BY                     created_by,
    i.CREATED_ON                     created_on,
    --
    i.ID                             supporting_object_script_id
from wwv_flow_install_scripts i,
     wwv_flow_authorized      f
where f.workspace_id   = i.security_group_id
  and f.application_id = i.flow_id
/

comment on table  apex_application_supp_obj_scr                             is 'Identifies the Supporting Object installation SQL Scripts';
comment on column apex_application_supp_obj_scr.workspace                   is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_obj_scr.workspace_display_name      is 'Display name for the workspace';
comment on column apex_application_supp_obj_scr.application_id              is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_obj_scr.application_name            is 'Identifies the application';
comment on column apex_application_supp_obj_scr.SCRIPT_NAME                 is 'Identifies the name of the installation SQL Script';
comment on column apex_application_supp_obj_scr.EXECUTION_SEQUENCE          is 'Identifies the execution of the installation SQL Script';
comment on column apex_application_supp_obj_scr.SCRIPT_TYPE                 is 'Identifies whether this is an install or upgrade SQL Script';
comment on column apex_application_supp_obj_scr.SQL_SCRIPT                  is 'Identifies the SQL Script.  Most basic SQL*plus syntax can be used to create database objects and load sample data.';
comment on column apex_application_supp_obj_scr.CONDITION_TYPE              is 'Identifies the condition type used to conditionally execute the Installation SQL Script';
comment on column apex_application_supp_obj_scr.CONDITION_TYPE_CODE         is 'Internal code of CODE_TYPE.';
comment on column apex_application_supp_obj_scr.CONDITION_EXPRESSION1       is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_scr.CONDITION_EXPRESSION2       is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_scr.CREATED_BY                  is 'APEX User Name of the developer who created this SQL Script';
comment on column apex_application_supp_obj_scr.CREATED_ON                  is 'Date that this SQL Script was created';
comment on column apex_application_supp_obj_scr.SUPPORTING_OBJECT_SCRIPT_ID is 'Primary Key of this SQL Script component';
comment on column apex_application_supp_obj_scr.last_updated_by             is 'APEX developer who made last update';
comment on column apex_application_supp_obj_scr.last_updated_on             is 'Date of last update';




create or replace view apex_application_supp_obj_chck
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    c.ID                             check_id,
    c.NAME                           check_name,
    c.SEQUENCE                       check_sequence,
    --
    c.CHECK_TYPE                     check_type,
    c.CHECK_CONDITION                check_expression1,
    c.CHECK_CONDITION2               check_expression2,
    --
    --c.SUCCESS_MESSAGE                ,
    c.FAILURE_MESSAGE                error_message,
    --
    nvl((select r from apex_standard_conditions where d = c.condition_type), c.condition_type) condition_type,
    c.CONDITION_TYPE                 condition_type_code,
    c.CONDITION                      condition_expression1,
    c.CONDITION2                     condition_expression2,
    --
    c.LAST_UPDATED_BY                last_updated_by,
    c.LAST_UPDATED_ON                last_updated_on,
    c.CREATED_BY                     created_by,
    c.CREATED_ON                     created_on
from wwv_flow_install_checks c,
     wwv_flow_authorized     f
where f.workspace_id   = c.security_group_id
  and f.application_id = c.flow_id
/

comment on table  apex_application_supp_obj_chck                       is 'Identifies the Supporting Object pre-installation checks to ensure the database is compatible with the objects to be installed';
comment on column apex_application_supp_obj_chck.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_supp_obj_chck.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_supp_obj_chck.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_supp_obj_chck.application_name      is 'Identifies the application';
comment on column apex_application_supp_obj_chck.CHECK_ID              is 'Specifies the ID for this validation.';
comment on column apex_application_supp_obj_chck.CHECK_NAME            is 'Specifies the name for this validation.';
comment on column apex_application_supp_obj_chck.CHECK_SEQUENCE        is 'Specifies the sequence for this validation. The sequence number determines the order of evaluation.';
comment on column apex_application_supp_obj_chck.CHECK_TYPE            is 'Specifies the condition type that must be met during installation before installation scripts are run.';
comment on column apex_application_supp_obj_chck.CHECK_EXPRESSION1     is 'Use this attribute to conditionally control whether installation can continue. Values correspond to the specific condition type selected.';
comment on column apex_application_supp_obj_chck.CHECK_EXPRESSION2     is 'Use this attribute to conditionally control whether installation can continue. Values correspond to the specific condition type selected.';
comment on column apex_application_supp_obj_chck.error_MESSAGE         is 'Enter a message to be displayed when the conditions of this validation are not met.';
comment on column apex_application_supp_obj_chck.CONDITION_TYPE        is 'Specifies a condition type from the list that conditionally controls whether this validation is performed.';
comment on column apex_application_supp_obj_chck.CONDITION_TYPE_CODE   is 'Internal code of CODE_TYPE.';
comment on column apex_application_supp_obj_chck.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_chck.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_supp_obj_chck.CREATED_BY            is 'Identifies the User Name of the APEX developer who created this check condition';
comment on column apex_application_supp_obj_chck.CREATED_ON            is 'Identifies the date that this component was created';
comment on column apex_application_supp_obj_chck.last_updated_by       is 'APEX developer who made last update';
comment on column apex_application_supp_obj_chck.last_updated_on       is 'Date of last update';




---------------------------------------------------------
-- A P P L I C A T I O N   T R A N S L A T I O N S
--
prompt ...apex_application_translations

create or replace view apex_application_translations
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.NAME                           translatable_message,
    t.MESSAGE_LANGUAGE               language_code,
    --
    t.MESSAGE_TEXT                   message_text,
    t.is_js_message,
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    t.MESSAGE_COMMENT                developer_comment,
    t.id                             translation_entry_id,
    t.name || ' l=' || t.message_language || ' m=' || substr(t.message_text, 1, 30) || length(t.message_text)
        as component_signature
from wwv_flow_messages$  t,
     wwv_flow_authorized f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
  /* keep this not exists */
  and not exists ( select 1
                     from wwv_flow_language_map m
                    where m.translation_flow_id = f.application_id
                      and m.security_group_id   = f.workspace_id
                      and f.authentication_id   <> trunc(f.authentication_id) )
/

comment on table  apex_application_translations                       is 'Identifies message primary language text and translated text';
comment on column apex_application_translations.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_translations.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_translations.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_translations.application_name      is 'Identifies the application';
comment on column apex_application_translations.TRANSLATABLE_MESSAGE  is 'Identifies the Message Name';
comment on column apex_application_translations.LANGUAGE_CODE         is 'Identifies the Language Code';
comment on column apex_application_translations.MESSAGE_TEXT          is 'Identifies the message text in the Language Code language';
comment on column apex_application_translations.is_js_message         is 'Identifies if the message is used in JavaScript code';
comment on column apex_application_translations.DEVELOPER_COMMENT     is 'Developer Comment';
comment on column apex_application_translations.last_updated_by       is 'APEX developer who made last update';
comment on column apex_application_translations.last_updated_on       is 'Date of last update';
comment on column apex_application_translations.translation_entry_id  is 'Primary Key of this Translation Entry';
comment on column apex_application_translations.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N   I T E M S
--
prompt ...apex_application_items

create or replace view apex_application_items
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    i.name                           item_name,
    i.scope                          scope,
    --i.name_length
    i.data_type                      data_type,
    --i.is_persistent                  ,
    i.protection_level               session_state_protection,
    (select case when i.required_patch > 0 then patch_name else '{Not '||patch_name||'}' end patch_name
     from   wwv_flow_patches
     where  id =abs(i.required_patch))    build_option,
    i.last_updated_by                ,
    i.last_updated_on                ,
    i.item_comment                   component_comment,
    i.id                             application_item_id,
    --
    i.name
    ||' dt='||i.data_type
    ||' prot='||i.protection_level
    ||' bo='||(select patch_name
     from   wwv_flow_patches
     where  id =i.required_patch)
    component_signature
from wwv_flow_items      i,
     wwv_flow_authorized f
where f.workspace_id   = i.security_group_id
  and f.application_id = i.flow_id
/

comment on table  apex_application_items                           is 'Identifies Application Items used to maintain session state that are not associated with a page';
comment on column apex_application_items.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_items.workspace_display_name    is 'Display name for the workspace';
comment on column apex_application_items.application_id            is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_items.application_name          is 'Identifies the application';
comment on column apex_application_items.ITEM_NAME                 is 'Name of the Application Item used to maintain session state';
comment on column apex_application_items.scope                     is 'Scope of Application: GLOBAL (across all sessions) or APP (the item''s application only)';
comment on column apex_application_items.DATA_TYPE                 is 'Datatype (Varchar or Number) of the Application Item.  Use a numeric data type to limit exposure to URL hackers for management of numeric session state';
comment on column apex_application_items.Session_State_Protection  is 'Identifies the Session State Protection for this item.  If the item is "Unrestricted" the item may be set by passing the item name/value in a URL or in a form.  Other protection levels provide enhanced protection of session state.';
comment on column apex_application_items.BUILD_OPTION              is 'Application Item will be available if the Build Option is enabled';
comment on column apex_application_items.COMPONENT_COMMENT         is 'Developer comment';
comment on column apex_application_items.APPLICATION_ITEM_ID       is 'Primary key of this Application Item';
comment on column apex_application_items.last_updated_by           is 'APEX developer who made last update';
comment on column apex_application_items.last_updated_on           is 'Date of last update';
comment on column apex_application_items.component_signature       is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N   P R O C E S S E S
--
prompt ...apex_application_processes

create or replace view apex_application_processes
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    p.PROCESS_SEQUENCE               process_sequence,
    --
    decode(p.PROCESS_POINT,
      'BEFORE_HEADER','On Load: Before Header (page template header)',
      'AFTER_HEADER','On Load: After Header (page template header)',
      'BEFORE_BOX_BODY','On Load: Before Body Region(s)',
      'AFTER_BOX_BODY','On Load: After Body Region(s)',
      'BEFORE_FOOTER','On Load: Before Footer (page template footer)',
      'AFTER_FOOTER','On Load: After Footer (page template footer)',
      'ON_SUBMIT_BEFORE_COMPUTATION','On Submit: After Page Submission - Before Computations and Validations',
      'AFTER_SUBMIT','On Submit: After Page Submission - After Computations and Validations',
      'ON_NEW_INSTANCE','On New Session: After Authentication',
      'AFTER_LOGIN','After Login',
      'ON_DEMAND','Ajax Callback: Run this application process when requested by a page process',
      p.process_point)               process_point,
    --
    decode(p.PROCESS_TYPE,
      'NATIVE_PLSQL','PL/SQL Anonymous Block',
      p.PROCESS_TYPE)                process_type,
    decode(p.PROCESS_TYPE,
      'NATIVE_PLSQL', 'PLSQL',
      p.PROCESS_TYPE)                process_type_code,
    p.process_type                   process_type_plugin_name,
    --
    p.PROCESS_NAME                   process_name,
    p.PROCESS_SQL_CLOB               process,
    p.attribute_01,
    p.attribute_02,
    p.attribute_03,
    p.attribute_04,
    p.attribute_05,
    p.attribute_06,
    p.attribute_07,
    p.attribute_08,
    p.attribute_09,
    p.attribute_10,
    p.attribute_11,
    p.attribute_12,
    p.attribute_13,
    p.attribute_14,
    p.attribute_15,
    p.PROCESS_ERROR_MESSAGE          error_message,
    p.error_display_location         error_display_location,
    --
    nvl((select r
    from apex_standard_conditions
    where d = p.PROCESS_WHEN_TYPE ),
    p.PROCESS_WHEN_TYPE)
                                     condition_type,
    p.process_when_type              condition_type_code,
    p.PROCESS_WHEN                   condition_expression1,
    p.PROCESS_WHEN2                  condition_expression2,
    --p.PROCESS_WHEN_TYPE2             ,
    --p.ITEM_NAME                      ,
    nvl((select case when p.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(p.REQUIRED_PATCH)),
     p.REQUIRED_PATCH)               build_option,
     --
     decode(substr(p.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(p.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     p.SECURITY_SCHEME)              authorization_scheme,
    p.SECURITY_SCHEME                authorization_scheme_id,
    p.LAST_UPDATED_BY                last_updated_by,
    p.LAST_UPDATED_ON                last_updated_on,
    p.PROCESS_COMMENT                component_comment,
    p.id                             application_process_id,
    --
    p.PROCESS_NAME
    ||' seq='||lpad(p.PROCESS_SEQUENCE,5,'00000')
    ||' '||p.PROCESS_POINT
    ||' '||decode(p.PROCESS_TYPE,'PLSQL','PL/SQL Anonymous Block',p.PROCESS_TYPE)
    ||' txt='||sys.dbms_lob.substr(p.PROCESS_SQL_CLOB,50,1)||sys.dbms_lob.getlength(p.PROCESS_SQL_CLOB)
    ||' m='||substr(p.PROCESS_ERROR_MESSAGE,1,30)||length(p.PROCESS_ERROR_MESSAGE)
    ||' cond='||p.PROCESS_WHEN_TYPE
    ||substr(p.PROCESS_WHEN,1,20)||length(p.PROCESS_WHEN)
    ||substr(p.PROCESS_WHEN2,1,20)||length(p.PROCESS_WHEN2)
    ||' b='||nvl((select name from    wwv_flow_security_schemes where   to_char(id)= abs(p.REQUIRED_PATCH) and flow_id = f.application_id),p.REQUIRED_PATCH)
    ||' s='||decode(substr(p.SECURITY_SCHEME,1,1),'!','Not ')||
     nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(p.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     'Not found')
    component_signature
from wwv_flow_processing p,
     wwv_flow_authorized f
where f.workspace_id   = p.security_group_id
  and f.application_id = p.flow_id
/

comment on table  apex_application_processes                        is 'Identifies Application Processes which can run for every page, on login or upon demand';
comment on column apex_application_processes.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_processes.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_processes.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_processes.application_name       is 'Identifies the application';
comment on column apex_application_processes.PROCESS_SEQUENCE       is 'Identifies the sequence that processes will be considered for execution within each process point';
comment on column apex_application_processes.PROCESS_POINT          is 'Identifies the point of execution of this process';
comment on column apex_application_processes.PROCESS_TYPE           is 'Identifies the type of process this is';
comment on column apex_application_processes.process_type_code      is 'Deprecated internal code of PROCESS_TYPE. Use PROCESS_TYPE_PLUGIN_NAME instead.';
comment on column apex_application_processes.process_type_plugin_name is 'Name of the plugin that implements the process. Names of built-in plugins start with "NATIVE_", application specific plugin names start with "PLUGIN_"';
comment on column apex_application_processes.PROCESS_NAME           is 'Identifies this process';
comment on column apex_application_processes.PROCESS                is 'Text of the Application Process';
comment on column apex_application_processes.ATTRIBUTE_01           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_02           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_03           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_04           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_05           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_06           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_07           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_08           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_09           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_10           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_11           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_12           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_13           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_14           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ATTRIBUTE_15           is 'Dynamic attribute to store additional data';
comment on column apex_application_processes.ERROR_MESSAGE          is 'Identifies the error message to be displayed if this processes raises an exception';
comment on column apex_application_processes.error_display_location is 'The Error display location identifies where the process error message will display. Messages can be displayed on an error page, or inline with the existing page. Inline errors are displayed in the "notification" area (defined as part of the page template).';
comment on column apex_application_processes.CONDITION_type         is 'Specifies a condition type from the Application Process that conditionally controls whether this Application Process is performed.';
comment on column apex_application_processes.CONDITION_TYPE_CODE    is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_processes.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_processes.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_processes.BUILD_OPTION           is 'Application Process will be available for execution if the Build Option is enabled';
comment on column apex_application_processes.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this process to be executed';
comment on column apex_application_processes.AUTHORIZATION_SCHEME_ID is 'Foreign Key';
comment on column apex_application_processes.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_processes.APPLICATION_PROCESS_ID is 'Primary key of this Application Process';
comment on column apex_application_processes.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_processes.last_updated_on        is 'Date of last update';
comment on column apex_application_processes.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N   C O M P U T A T I O N S
--
prompt ...apex_application_computations

create or replace view apex_application_computations
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    c.COMPUTATION_SEQUENCE           computation_sequence,
    c.COMPUTATION_ITEM               computation_item,
    c.COMPUTATION_POINT              computation_point,
    --c.COMPUTATION_ITEM_TYPE
    c.COMPUTATION_TYPE               computation_type,
    --c.COMPUTATION_PROCESSED          computation_processed,
    c.COMPUTATION                    computation,
    --
    decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     c.SECURITY_SCHEME)              authorization_scheme,
    c.SECURITY_SCHEME                authorization_scheme_id,
    --
    nvl((select case when c.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(c.REQUIRED_PATCH)),
     c.REQUIRED_PATCH)               build_option,
    --
    nvl((select r from apex_standard_conditions where d = c.COMPUTE_WHEN_TYPE),c.COMPUTE_WHEN_TYPE)
                                     condition_type,
    c.compute_when_type              condition_type_code,
    c.COMPUTE_WHEN                   condition_expression1,
    c.COMPUTE_WHEN_TEXT              condition_expression2,
    --
    c.COMPUTATION_ERROR_MESSAGE      error_message,
    c.LAST_UPDATED_BY                last_updated_by,
    c.LAST_UPDATED_ON                last_updated_on,
    c.COMPUTATION_COMMENT            component_comment,
    c.id                             application_computation_id,
    --
    c.COMPUTATION_ITEM
    ||' seq='||lpad(c.COMPUTATION_SEQUENCE,5,'00000')
    ||' p='||c.COMPUTATION_POINT
    ||' t='||c.COMPUTATION_TYPE
    ||' c='||substr(c.COMPUTATION,1,50)||length(c.COMPUTATION)
    ||' s='||decode(substr(c.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(c.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     'Not found')
    ||' c='||c.COMPUTE_WHEN_TYPE
    ||substr(c.COMPUTE_WHEN,1,30)||length(c.COMPUTE_WHEN)
    ||substr(c.COMPUTE_WHEN_TEXT,1,30)||length(c.COMPUTE_WHEN_TEXT)
    ||' m='||substr(c.COMPUTATION_ERROR_MESSAGE,1,30)||length(c.COMPUTATION_ERROR_MESSAGE)
    component_signature
from wwv_flow_computations c,
     wwv_flow_authorized   f
where f.workspace_id   = c.security_group_id
  and f.application_id = c.flow_id
/

comment on table  apex_application_computations                        is 'Identifies Application Computations which can run for every page or on login';
comment on column apex_application_computations.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_computations.workspace_display_name  is 'Display name for the workspace';
comment on column apex_application_computations.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_computations.application_name       is 'Identifies the application';
comment on column apex_application_computations.COMPUTATION_SEQUENCE   is 'Identifies the sequence within the Display Point that this computation will be considered for execution';
comment on column apex_application_computations.COMPUTATION_ITEM       is 'Compute this item value; the purpose of this computation is to set this item''s value.';
comment on column apex_application_computations.COMPUTATION_POINT      is 'Identifies a pre-defined point at which this computation will be performed';
comment on column apex_application_computations.COMPUTATION_TYPE       is 'Identifies the manner in which this computation will be performed';
comment on column apex_application_computations.COMPUTATION            is 'Identifies the computation logic that corresponds to the computation type';
comment on column apex_application_computations.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this computation to be executed';
comment on column apex_application_computations.AUTHORIZATION_SCHEME_ID  is 'Foreign Key';
comment on column apex_application_computations.CONDITION_TYPE         is 'Specifies a condition type from the application computation that conditionally controls whether this computation is performed.';
comment on column apex_application_computations.CONDITION_TYPE_CODE    is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_computations.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_computations.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_computations.ERROR_MESSAGE          is 'Identifies the error text that is displayed if this computation raises an error';
comment on column apex_application_computations.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_computations.APPLICATION_COMPUTATION_ID is 'Identifies the primary key of this Application Computation';
comment on column apex_application_computations.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_computations.last_updated_on        is 'Date of last update';
comment on column apex_application_computations.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';

---------------------------------------------------------
-- A P P L I C A T I O N   S E T T I N G S
--
prompt ...apex_application_settings

create or replace view apex_application_settings
as
select
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       s.id application_setting_id,
       s.name,
       s.is_required,
       s.valid_values,
       s.value,
       case s.on_upgrade_keep_value
       when 'Y' then 'Yes'
       when 'N' then 'No'
       end on_upgrade_keep_value,
       s.comments,
       (select case when s.required_patch > 0 then patch_name else '{Not '||patch_name||'}' end patch_name
       from wwv_flow_patches
       where id =abs(s.required_patch)) build_option,
       s.required_patch build_option_id,
       s.created_on,
       s.created_by,
       s.last_updated_by,
       s.last_updated_on,
       s.name
       ||'.'||s.is_required
       ||'.'||s.valid_values
       ||'.'||s.value
       component_signature
from wwv_flow_app_settings s,
     wwv_flow_authorized f
where f.workspace_id   = s.security_group_id
  and f.application_id = s.flow_id;

comment on table apex_application_settings is 'Identifies application settings typically used by applications to manage configuration parameter names and values';
comment on column apex_application_settings.workspace is 'A work area mapped to one or more database schemas';
comment on column apex_application_settings.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_settings.application_id is 'Application primary key, unique over all workspaces';
comment on column apex_application_settings.application_name is 'Identifies the application';
comment on column apex_application_settings.application_setting_id is 'Identifies the primary key of this Application Setting';
comment on column apex_application_settings.name is 'Identifies the name of the setting used to get and set values';
comment on column apex_application_settings.is_required is 'Identifies if the value is required';
comment on column apex_application_settings.valid_values is 'Identifies comma separated valid values';
comment on column apex_application_settings.value is 'Current value of the setting';
comment on column apex_application_settings.on_upgrade_keep_value is 'Should the current value be kept or set to the specified value when the application is upgraded?';
comment on column apex_application_settings.comments is 'Developer comment';
comment on column apex_application_settings.build_option is 'Application Setting value will be used if the Build Option is enabled';
comment on column apex_application_settings.build_option_id is 'Identifies the primary key of this component';
comment on column apex_application_settings.created_by is 'APEX developer who created the application setting';
comment on column apex_application_settings.created_on is 'Date of application setting was created';
comment on column apex_application_settings.last_updated_by is 'APEX developer who made last update';
comment on column apex_application_settings.last_updated_on is 'Date of last update';
comment on column apex_application_settings.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

---------------------------------------------------------
-- A P P L I C A T I O N   S H O R T C U T S
--
prompt ...apex_application_shortcuts

create or replace view apex_application_shortcuts
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    s.SHORTCUT_NAME                  shortcut_name,
    --s.SHORTCUT_CONSIDERATION_SEQ     consideration_sequence,
    s.SHORTCUT_TYPE                  shortcut_type,
    nvl((select r from apex_standard_conditions where d = s.SHORTCUT_CONDITION_TYPE1),s.SHORTCUT_CONDITION_TYPE1)
                                     condition_type,
    s.shortcut_condition_type1       condition_type_code,
    s.SHORTCUT_CONDITION1            condition_expression1,
    --s.SHORTCUT_CONDITION_TYPE2       ,
    s.SHORTCUT_CONDITION2            condition_expression2,
    s.ERROR_TEXT                     error_text,
    (select case when s.build_option > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(s.BUILD_OPTION))      build_option,
    s.SHORTCUT                       shortcut,
    --
    decode(s.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||shortcut_name n
     from wwv_flow_shortcuts
     where id = s.reference_id)      subscribed_from,
    --
    s.LAST_UPDATED_BY                last_updated_by,
    s.LAST_UPDATED_ON                last_updated_on,
    s.COMMENTS                       component_comments,
    s.id                             shortcut_id,
    --
    s.SHORTCUT_NAME
    ||' '||s.SHORTCUT_TYPE
    ||' cond='||s.SHORTCUT_CONDITION_TYPE1
    ||substr(s.SHORTCUT_CONDITION1,1,30)||length(s.shortcut_condition1)||'.'
    ||substr(s.SHORTCUT_CONDITION2,1,30)||length(s.shortcut_condition2)
    ||' e='||substr(s.ERROR_TEXT,1,30)||length(s.ERROR_TEXT)
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(s.BUILD_OPTION))
    ||' s='||sys.dbms_lob.substr(s.SHORTCUT,50,1)||sys.dbms_lob.getlength(s.SHORTCUT)
    ||' r='||decode(s.REFERENCE_ID,null,'No','Yes')
    component_signature
from wwv_flow_shortcuts  s,
     wwv_flow_authorized f
where f.workspace_id   = s.security_group_id
  and f.application_id = s.flow_id
/

comment on table  apex_application_shortcuts                        is 'Identifies Application Shortcuts which can be referenced "MY_SHORTCUT" syntax';
comment on column apex_application_shortcuts.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_shortcuts.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_shortcuts.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_shortcuts.application_name       is 'Identifies the application';
comment on column apex_application_shortcuts.SHORTCUT_NAME          is 'Identifies the Shortcut Name, which can be referenced using "SHORTCUT_NAME" syntax';
comment on column apex_application_shortcuts.SHORTCUT_TYPE          is 'The shortcut type identifies how the Shortcut text is to be interpreted; for example it could by PL/SQL or HTML.';
comment on column apex_application_shortcuts.CONDITION_TYPE         is 'Identifies the condition type used to conditionally execute the shortcut';
comment on column apex_application_shortcuts.CONDITION_TYPE_CODE    is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_shortcuts.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_shortcuts.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_shortcuts.ERROR_TEXT             is 'Text to be displayed if this shortcut raises an exception';
comment on column apex_application_shortcuts.BUILD_OPTION           is 'Shortcut will be available if the Build Option is enabled';
comment on column apex_application_shortcuts.SHORTCUT               is 'Text and definition of this Shortcut';
comment on column apex_application_shortcuts.IS_SUBSCRIBED          is 'Identifies if this Shortcut is subscribed from another Shortcut';
comment on column apex_application_shortcuts.SUBSCRIBED_FROM        is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_shortcuts.COMPONENT_COMMENTS     is 'Developer comments';
comment on column apex_application_shortcuts.SHORTCUT_ID            is 'Primary Key of this Shortcut';
comment on column apex_application_shortcuts.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_shortcuts.last_updated_on        is 'Date of last update';
comment on column apex_application_shortcuts.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N   T R E E S
--
prompt ...apex_application_trees

create or replace view apex_application_trees
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.TREE_NAME                      tree_name,
    t.TREE_TYPE                      tree_type,
    t.TREE_QUERY                     tree_query,
    t.FLOW_ITEM                      ,
    t.MAX_LEVELS                     maximum_levels,
    t.UNEXPANDED_PARENT              ,
    t.UNEXPANDED_PARENT_LAST         ,
    t.EXPANDED_PARENT                ,
    t.EXPANDED_PARENT_LAST           ,
    t.LEAF_NODE                      ,
    t.LEAF_NODE_LAST                 ,
    t.DRILL_UP                       ,
    t.NAME_LINK_ANCHOR_TAG           ,
    t.NAME_LINK_NOT_ANCHOR_TAG       ,
    t.INDENT_VERTICAL_LINE           ,
    t.INDENT_VERTICAL_LINE_LAST      ,
    t.BEFORE_TREE                    ,
    t.AFTER_TREE                     ,
    t.LEVEL_1_TEMPLATE               ,
    t.LEVEL_2_TEMPLATE               ,
    t.LEVEL_3_TEMPLATE               ,
    t.LEVEL_4_TEMPLATE               ,
    t.LEVEL_5_TEMPLATE               ,
    t.LEVEL_6_TEMPLATE               ,
    t.LEVEL_7_TEMPLATE               ,
    t.LEVEL_8_TEMPLATE               ,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    --
    t.TREE_COMMENT                   component_comment,
    t.id                             application_tree_id,
    --
    t.TREE_NAME
    ||' t='||t.TREE_TYPE
    ||substr(t.TREE_QUERY,1,50)||length(t.tree_query)
    ||' i='||t.FLOW_ITEM
    ||' l='||t.MAX_LEVELS
    ||'.'||length(t.UNEXPANDED_PARENT        )
    ||'.'||length(t.UNEXPANDED_PARENT_LAST   )
    ||'.'||length(t.EXPANDED_PARENT          )
    ||'.'||length(t.EXPANDED_PARENT_LAST     )
    ||'.'||length(t.LEAF_NODE                )
    ||'.'||length(t.LEAF_NODE_LAST           )
    ||'.'||length(t.DRILL_UP                 )
    ||'.'||length(t.NAME_LINK_ANCHOR_TAG     )
    ||'.'||length(t.NAME_LINK_NOT_ANCHOR_TAG )
    ||'.'||length(t.INDENT_VERTICAL_LINE     )
    ||'.'||length(t.INDENT_VERTICAL_LINE_LAST)
    ||'.'||length(t.BEFORE_TREE              )
    ||'.'||length(t.AFTER_TREE               )
    ||'.'||length(t.LEVEL_1_TEMPLATE         )
    ||'.'||length(t.LEVEL_2_TEMPLATE         )
    ||'.'||length(t.LEVEL_3_TEMPLATE         )
    ||'.'||length(t.LEVEL_4_TEMPLATE         )
    ||'.'||length(t.LEVEL_5_TEMPLATE         )
    ||'.'||length(t.LEVEL_6_TEMPLATE         )
    ||'.'||length(t.LEVEL_7_TEMPLATE         )
    ||'.'||length(t.LEVEL_8_TEMPLATE         )
    component_signature
from wwv_flow_trees      t,
     wwv_flow_authorized f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_trees                            is 'Identifies a tree control which can be referenced and displayed by creating a region with a source of this tree';
comment on column apex_application_trees.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_trees.workspace_display_name     is 'Display name for the workspace';
comment on column apex_application_trees.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_trees.application_name           is 'Identifies the application';
comment on column apex_application_trees.tree_name                  is 'Component name';
comment on column apex_application_trees.tree_type                  is 'Tree component type';
comment on column apex_application_trees.tree_query                 is 'Query which will be used to generate this tree';
comment on column apex_application_trees.flow_item                  is 'Identifies an application or page item which specifies the starting point of the tree';
comment on column apex_application_trees.maximum_levels             is 'This attribute specifies how many levels will appear when a tree first displays';
comment on column apex_application_trees.unexpanded_parent          is 'HTML template for unexpanded parent nodes';
comment on column apex_application_trees.unexpanded_parent_last     is 'HTML template for the last unexpanded parent node';
comment on column apex_application_trees.expanded_parent            is 'HTML template for the expanded parent node';
comment on column apex_application_trees.expanded_parent_last       is 'HTML template for the last expanded parent node';
comment on column apex_application_trees.leaf_node                  is 'Controls the text that is painted before showing the text of the leaf node';
comment on column apex_application_trees.leaf_node_last             is 'Controls the text that is painted before showing the text of the last leaf node.';
comment on column apex_application_trees.drill_up                   is 'Identifies the link text shown when drilling up is possible in the tree';
comment on column apex_application_trees.name_link_anchor_tag       is 'Identifies the manner in which a Name will render if the name has a link';
comment on column apex_application_trees.name_link_not_anchor_tag   is 'Tag for node names which are not links';
comment on column apex_application_trees.indent_vertical_line       is 'Controls vertical line or spacing between peers';
comment on column apex_application_trees.indent_vertical_line_last  is 'Indent Vertical Line Last, controls a blank space';
comment on column apex_application_trees.before_tree                is 'Text before displaying any nodes of the tree';
comment on column apex_application_trees.after_tree                 is 'Text after displaying nodes of the tree';
comment on column apex_application_trees.level_1_template           is 'Parent Node Template';
comment on column apex_application_trees.level_2_template           is 'Node Text Template';
comment on column apex_application_trees.level_3_template           is '';
comment on column apex_application_trees.level_4_template           is '';
comment on column apex_application_trees.level_5_template           is '';
comment on column apex_application_trees.level_6_template           is '';
comment on column apex_application_trees.level_7_template           is '';
comment on column apex_application_trees.level_8_template           is '';
comment on column apex_application_trees.COMPONENT_COMMENT          is 'Developer comment';
comment on column apex_application_trees.APPLICATION_TREE_ID        is 'Primary Key of this Application Tree shared component';
comment on column apex_application_trees.last_updated_by            is 'APEX developer who made last update';
comment on column apex_application_trees.last_updated_on            is 'Date of last update';
comment on column apex_application_trees.component_signature        is 'Identifies attributes defined at a given component level to facilitate application comparisons';


prompt ...apex_application_page_trees
set define off

create or replace view apex_application_page_trees
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                             page_id,
    p.name                           page_name,
    t.id                             region_id,
    t.plug_name                      region_name,
    --
    case
    when regexp_like(t.attribute_06, '^tree\d+$') then to_number(regexp_substr(t.attribute_06, '\d+'))
    else t.id
    end                              tree_id,
    t.plug_source                    tree_query,
    regexp_substr (
        t.plug_source,
        'from[:space:]*"?([^"[:space:]]+)',
        1,
        1,
        'i',
        1 )                          tree_source,
    t.attribute_01                   tree_template,
    t.attribute_02                   tree_click_action,
    cast(null as varchar2(10))       tree_start_value,
    cast(null as varchar2(10))       tree_start_item,
    t.attribute_03                   tree_selected_node,
    t.attribute_04                   show_hints,
    t.attribute_05                   tree_hint_text,
    cast(null as varchar2(10))       tree_has_focus,
    cast(null as varchar2(10))       tree_button_option,
    --
    t.last_updated_by                last_updated_by,
    t.last_updated_on                last_updated_on,
    --
    t.plug_comment                   component_comment,
    --
    p.name
    ||' t='||sys.dbms_lob.substr(t.plug_source,50)||sys.dbms_lob.getlength(t.plug_source)
    ||' template='||t.attribute_01
    ||' links='||t.attribute_02
    ||' sel='||t.attribute_03
    ||' hints='||t.attribute_04||':'||t.attribute_05
    component_signature
from wwv_flow_page_plugs t,
     wwv_flow_steps      p,
     wwv_flow_authorized f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = t.security_group_id
  and p.flow_id           = t.flow_id
  and p.id                = t.page_id
  and t.plug_source_type  = 'NATIVE_JSTREE'
/

set define '^'

comment on table  apex_application_page_trees                            is 'Identifies a tree control which can be referenced and displayed by creating a region with a source of this tree';
comment on column apex_application_page_trees.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_trees.workspace_display_name     is 'Display name for the workspace';
comment on column apex_application_page_trees.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_trees.application_name           is 'Identifies the application';
comment on column apex_application_page_trees.page_name                  is 'Page name';
comment on column apex_application_page_trees.page_id                    is 'Primary Key of this Application page';
comment on column apex_application_page_trees.region_id                  is 'Identifies the Page Region foreign key to the apex_application_page_regions view';
comment on column apex_application_page_trees.region_name                is 'Identifies the region name in which this Tree is displayed';
comment on column apex_application_page_trees.tree_id                    is 'Primary Key of this Tree region';
comment on column apex_application_page_trees.tree_query                 is 'Query which will be used to generate this tree';
comment on column apex_application_page_trees.tree_source                is 'Identifies the database table name used as the tree source';
comment on column apex_application_page_trees.tree_template              is 'The template used to display the tree';
comment on column apex_application_page_trees.tree_click_action          is 'Identifies whether node links should be activated on a single or double click action';
comment on column apex_application_page_trees.tree_start_value           is 'obsolete';
comment on column apex_application_page_trees.tree_start_item            is 'obsolete';
comment on column apex_application_page_trees.tree_selected_node         is 'To save tree state, identifies the last selected node of the tree';
comment on column apex_application_page_trees.show_hints                 is 'Identifes whether to display no tooltip or a tooltip based on a database column or static text';
comment on column apex_application_page_trees.tree_hint_text             is 'The static text to be used as the tooltip for each node of the tree';
comment on column apex_application_page_trees.tree_has_focus             is 'obsolete';
comment on column apex_application_page_trees.tree_button_option         is 'obsolete';
comment on column apex_application_page_trees.component_comment          is 'Developer comment';
comment on column apex_application_page_trees.last_updated_by            is 'APEX developer who made last update';
comment on column apex_application_page_trees.last_updated_on            is 'Date of last update';
comment on column apex_application_page_trees.component_signature        is 'Identifies attributes defined at a given component level to facilitate application comparisons';



---------------------------------------------------------
-- A P P L I C A T I O N   N A V I G A T I O N   B A R
--
prompt ...apex_application_nav_bar

create or replace view apex_application_nav_bar
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    n.ICON_SEQUENCE                  display_sequence,
    decode(n.BEGINS_ON_NEW_LINE,
       'YES','Yes',
       'NO','No',
       n.BEGINS_ON_NEW_LINE)         begins_on_new_line,
    n.CELL_COLSPAN                   cell_column_span,
    --
    n.ICON_IMAGE                     ,
    --n.ICON_IMAGE2                    ,
    --n.ICON_IMAGE3                    ,
    n.ICON_SUBTEXT                   ,
    --n.ICON_SUBTEXT2                  ,
    --n.ICON_SUBTEXT3                  ,
    n.ICON_TARGET                    ,
    n.ICON_IMAGE_ALT                 ,
    n.ICON_HEIGHT                    ,
    n.ICON_WIDTH                     ,
    --n.ICON_HEIGHT2                   ,
    --n.ICON_WIDTH2                    ,
    --n.ICON_HEIGHT3                   ,
    --n.ICON_WIDTH3                    ,
    --
    nvl((select r from apex_standard_conditions where d = n.ICON_BAR_DISP_COND_TYPE),n.ICON_BAR_DISP_COND_TYPE)
                                     condition_type,
    n.icon_bar_disp_cond_type        condition_type_code,
    n.ICON_BAR_DISP_COND             condition_expression1,
    n.ICON_BAR_FLOW_COND_INSTR       condition_expression2,
    --
    n.ONCLICK                        onclick_javascript,
    --
    (select case when n.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(n.REQUIRED_PATCH))    build_option,
     --
    decode(substr(n.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(n.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     n.SECURITY_SCHEME)              authorization_scheme,
    n.SECURITY_SCHEME                authorization_scheme_id,
    --
    decode(n.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||icon_subtext n
     from wwv_flow_icon_bar
     where id = n.reference_id)      subscribed_from,
    --
    n.LAST_UPDATED_BY                last_updated_by,
    n.LAST_UPDATED_ON                last_updated_on,
    n.ICON_BAR_COMMENT               component_comment,
    n.id                             nav_bar_id,
    decode(n.nav_entry_is_feedback_yn,'Y','Yes','No') is_feedback_link,
    n.REFERENCE_ID                   referenced_nav_bar_id,
    --
    lpad(n.ICON_SEQUENCE,5,'00000')
    ||decode(n.BEGINS_ON_NEW_LINE,
       'YES','Yes',
       'NO','No',
       n.BEGINS_ON_NEW_LINE)
    ||n.CELL_COLSPAN
    ||' img='||n.ICON_IMAGE
    ||' '||substr(n.ICON_SUBTEXT,1,30)||length(n.ICON_SUBTEXT)
    ||' t='||substr(n.ICON_TARGET,1,30)||length(n.ICON_TARGET)
    ||' a='||substr(n.ICON_IMAGE_ALT,1,20)||length(n.ICON_IMAGE_ALT)
    ||n.ICON_HEIGHT
    ||n.ICON_WIDTH
    ||' c='||n.ICON_BAR_DISP_COND_TYPE
    ||substr(n.ICON_BAR_DISP_COND,1,30)||length(n.ICON_BAR_DISP_COND)
    ||substr(n.ICON_BAR_FLOW_COND_INSTR,1,30)||length(n.ICON_BAR_FLOW_COND_INSTR)
    ||' ck='||substr(n.ONCLICK,1,20)||length(n.onclick)
    ||' bo='||
    (select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(n.REQUIRED_PATCH))
    ||' a='||decode(substr(n.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(n.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     'Not found')
    ||' s='||decode(n.REFERENCE_ID,
    null,'No','Yes')
    component_signature
from wwv_flow_icon_bar   n,
     wwv_flow_authorized f
where f.workspace_id   = n.security_group_id
  and f.application_id = n.flow_id
/

comment on table  apex_application_nav_bar                        is 'Identifies navigation bar entries displayed on pages that use a Page Template that include a #NAVIGATION_BAR# substitution string';
comment on column apex_application_nav_bar.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_nav_bar.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_nav_bar.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_nav_bar.application_name       is 'Identifies the application';
comment on column apex_application_nav_bar.DISPLAY_SEQUENCE       is 'Identifies the order in which each Navigation Bar Entry will be displayed';
comment on column apex_application_nav_bar.ICON_IMAGE             is 'Identifies image to be displayed in the Navigation Bar Entry';
comment on column apex_application_nav_bar.ICON_SUBTEXT           is 'Identifies text to be displayed in the Navigation Bar Entry';
comment on column apex_application_nav_bar.ICON_TARGET            is 'Identifies the URL that this Navigation Bar Entry will link to';
comment on column apex_application_nav_bar.ICON_IMAGE_ALT         is 'Identifies the HTML IMG tag ALT value';
comment on column apex_application_nav_bar.ICON_HEIGHT            is 'Identifies the HTML IMG tag HEIGHT value';
comment on column apex_application_nav_bar.ICON_WIDTH             is 'Identifies the HTML IMG tag WIDTH value';
comment on column apex_application_nav_bar.CONDITION_TYPE         is 'Identifies the condition type used to conditionally display the Navigation Bar Entry';
comment on column apex_application_nav_bar.CONDITION_TYPE_CODE    is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_nav_bar.CONDITION_EXPRESSION1  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_nav_bar.CONDITION_EXPRESSION2  is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_nav_bar.BEGINS_ON_NEW_LINE     is 'Navigation icons are displayed in table cells, if you set begins-on-new-line to YES then a new table row will be created.';
comment on column apex_application_nav_bar.CELL_COLumn_SPAN       is 'By default each navigation bar entry spans one cell (i.e. the HTML table data colspan=1).  If your HTML requires a different COLSPAN you can set it using this control.';
comment on column apex_application_nav_bar.ONCLICK_javascript     is 'The link generated for this icon include the following onClick javascript.';
comment on column apex_application_nav_bar.BUILD_OPTION           is 'Navigation Bar Entry will be displayed if the Build Option is enabled';
comment on column apex_application_nav_bar.AUTHORIZATION_SCHEME   is 'An authorization scheme must evaluate to TRUE in order for this Navigation Bar Entry to be displayed';
comment on column apex_application_nav_bar.AUTHORIZATION_SCHEME_ID is 'Foreign Key';
comment on column apex_application_nav_bar.IS_SUBSCRIBED          is 'Identifies if this Navigation Bar Entry is subscribed from another Navigation Bar Entry';
comment on column apex_application_nav_bar.SUBSCRIBED_FROM        is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_nav_bar.COMPONENT_COMMENT      is 'Developer comment';
comment on column apex_application_nav_bar.NAV_BAR_ID             is 'Primary Key of this Navigation Bar component';
comment on column apex_application_nav_bar.referenced_nav_bar_id  is 'Primary Key of this Navigation Bar component';
comment on column apex_application_nav_bar.is_feedback_link       is 'Specifies whether navigation bar entry is feedback link';
comment on column apex_application_nav_bar.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_nav_bar.last_updated_on        is 'Date of last update';
comment on column apex_application_nav_bar.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';




----------------------------------------------------------
-- A P P L I C A T I O N   L I S T S    O F    V A L U E S
--

prompt ...apex_application_lovs

create or replace view apex_application_lovs
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    l.LOV_NAME                              list_of_values_name,
    --
    decode(substr(l.lov_query,1,1),
    '.','Static','Dynamic')                 lov_type,
    decode(substr(l.lov_query,1,1),
    '.',null,l.LOV_QUERY)                   list_of_values_query,
    l.source_type                           source_type_code,
    decode( l.source_type,
       'TABLE',                     'Table',
       'SQL',                       'SQL Query',
       'FUNC_BODY_RETURNING_SQL',   'PL/SQL Function Body returning SQL Query',
       'LEGACY_SQL',                'Legacy SQL Query' )
                                            source_type,
    (select count(*)
    from wwv_flow_list_of_values_data
    where flow_id = f.application_id and
          lov_id = l.id)                    lov_entries,
    --
    decode(l.REFERENCE_ID,null,'No','Yes')
                                            is_subscribed,
    (select flow_id||'. '||lov_name n
     from wwv_flow_lists_of_values$
     where id = l.reference_id)             subscribed_from,
    --
    l.location                              location_code,
    decode( l.location,
       'LOCAL',       'Local Database',
       'REMOTE',      'Remote Database',
       'WEB_SOURCE',  'Web Source',
       'STATIC',      'Static' )            location,
    (select name
       from wwv_remote_servers
      where id = l.remote_server_id)        remote_database_name,
    l.remote_server_id                      remote_database_id,
    (select name
       from wwv_flow_web_src_modules
      where id = l.web_src_module_id)       web_source_module_name,
    l.web_src_module_id                     web_source_module_id,
    l.query_owner                           table_owner,
    l.query_table                           table_name,
    l.query_where                           where_clause,
    decode( l.source_post_processing,
       'SQL',                       'SQL Query',
       'WHERE_ORDER_BY_CLAUSE',     'Where Clause',
       'FUNC_BODY_RETURNING_SQL',   'PL/SQL Function Body returning SQL Query' )
                                            source_post_processing,
    l.optimizer_hint,
    decode( l.remote_sql_caching,
        'ALL_USERS' , 'Cached'            ,
        'USER'      , 'Cached by User'    ,
        'SESSION'   , 'Cached by Session' ) cache_mode,
    l.remote_sql_invalidate_when            cache_invalidation_expr,
    l.external_filter_expr,
    l.external_order_by_expr,
    --
    l.return_column_name,
    l.display_column_name,
    l.icon_column_name,
    l.group_column_name,
    l.group_sort_direction                  group_sort_direction_code,
    decode( l.group_sort_direction,
        'ASC',              'Ascending (Nulls Last)',
        'ASC_NULLS_FIRST',  'Ascending (Nulls First)',
        'DESC',             'Descending (Nulls Last)',
        'DESC_NULLS_FIRST', 'Descending (Nulls First)' )
                                            group_sort_direction,
    l.default_sort_column_name,
    l.default_sort_direction                default_sort_direction_code,
    decode( l.default_sort_direction,
        'ASC',              'Ascending (Nulls Last)',
        'ASC_NULLS_FIRST',  'Ascending (Nulls First)',
        'DESC',             'Descending (Nulls Last)',
        'DESC_NULLS_FIRST', 'Descending (Nulls First)' )
                                            default_sort_direction,
    l.oracle_text_column_name,
    --
    l.LAST_UPDATED_BY                       last_updated_by,
    l.LAST_UPDATED_ON                       last_updated_on,
    l.LOV_COMMENT                           component_comment,
    --
    l.ID                                    lov_id,
    l.REFERENCE_ID                          referenced_lov_id,
    --
    l.LOV_NAME
    ||' t='||decode(substr(l.lov_query,1,1),'.','Static','Dynamic')
    ||' q='||decode(substr(l.lov_query,1,1),'.',null,substr(l.LOV_QUERY,1,30)||length(l.LOV_QUERY))
    ||' ref='||decode(l.REFERENCE_ID,null,'No','Yes')
    component_signature
from wwv_flow_lists_of_values$ l,
     wwv_flow_authorized       f
where f.workspace_id   = l.security_group_id
  and f.application_id = l.flow_id
/

comment on table  apex_application_lovs                                 is 'Identifies a shared list of values that can be referenced by a Page Item or Report Column';
comment on column apex_application_lovs.workspace                       is 'A work area mapped to one or more database schemas';
comment on column apex_application_lovs.workspace_display_name          is 'Display name for the workspace';
comment on column apex_application_lovs.application_id                  is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_lovs.application_name                is 'Identifies the application';
comment on column apex_application_lovs.LIST_OF_VALUES_NAME             is 'Identifies the name of the List of Values';
comment on column apex_application_lovs.LIST_OF_VALUES_QUERY            is 'SQL SELECT statement used to identify dynamic Lists of Values.  Static Lists of Values are defined in a child List of Values Entries table.';
comment on column apex_application_lovs.LOV_TYPE                        is 'List of Values type, Static or Dynamic.';
comment on column apex_application_lovs.source_type_code                is 'Identifies the internal code of the source type';
comment on column apex_application_lovs.source_type                     is 'Identifies the source type the List of Values is based on, can be Table, SQL Query, PL/SQL Function Body returning SQL Query or Legacy SQL Query';
comment on column apex_application_lovs.LOV_ENTRIES                     is 'Count of List of Values static entries';
comment on column apex_application_lovs.IS_SUBSCRIBED                   is 'Identifies if this List of Values is subscribed from another List of Values';
comment on column apex_application_lovs.SUBSCRIBED_FROM                 is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_lovs.location_code                   is 'Identifies the internal code of LOCATION';
comment on column apex_application_lovs.location                        is 'Identifies whether the List of Values location is static, the local database, a remote database or a web source module';
comment on column apex_application_lovs.remote_database_name            is 'Identifies the name of the remote database';
comment on column apex_application_lovs.remote_database_id              is 'Identifies the primary key of the remote database definition';
comment on column apex_application_lovs.web_source_module_name          is 'Identifies the web source module name';
comment on column apex_application_lovs.web_source_module_id            is 'Identifies the primary key of the web source module';
comment on column apex_application_lovs.table_owner                     is 'Denotes the table owner for TABLE query types';
comment on column apex_application_lovs.table_name                      is 'Denotes the table name for TABLE query types';
comment on column apex_application_lovs.where_clause                    is 'Identifies the WHERE clause provided by the developer and to be applied to TABLE or WEB SOURCE data sources';
comment on column apex_application_lovs.source_post_processing          is 'Identifies type of SQL post processing for data from external data sources';
comment on column apex_application_lovs.optimizer_hint                  is 'Optimizer hint which is added to the region source SQL statement when it is executed';
comment on column apex_application_lovs.cache_mode                      is 'Identifies the caching method';
comment on column apex_application_lovs.cache_invalidation_expr         is 'DBMS_SCHEDULER calendaring expression to determine cache invalidation';
comment on column apex_application_lovs.external_filter_expr            is 'Filter expression to be sent to the external data source';
comment on column apex_application_lovs.external_order_by_expr          is 'Order By expression to be sent to the external data source';
comment on column apex_application_lovs.return_column_name              is 'Identify the column used as the return value';
comment on column apex_application_lovs.display_column_name             is 'Identify the column used as the display value';
comment on column apex_application_lovs.icon_column_name                is 'Identify the column used for an icon';
comment on column apex_application_lovs.group_column_name               is 'Identify the column used for grouping';
comment on column apex_application_lovs.group_sort_direction_code       is 'Identify the internal code that defines the group sort direction';
comment on column apex_application_lovs.group_sort_direction            is 'Identify the group sort direction';
comment on column apex_application_lovs.default_sort_column_name        is 'Identify the column used as the default sort';
comment on column apex_application_lovs.default_sort_direction_code     is 'Identify the internal code that defines the default sort direction';
comment on column apex_application_lovs.default_sort_direction          is 'Identify the default sort direction';
comment on column apex_application_lovs.oracle_text_column_name         is 'A column which is indexed by an Oracle Text index';
comment on column apex_application_lovs.component_comment               is 'Developer comment';
comment on column apex_application_lovs.lov_id                          is 'Primary Key of the Shared List of Values';
comment on column apex_application_lovs.referenced_lov_id               is 'Foreign Key of referenced Shared List of Values';
comment on column apex_application_lovs.last_updated_by                 is 'APEX developer who made last update';
comment on column apex_application_lovs.last_updated_on                 is 'Date of last update';
comment on column apex_application_lovs.component_signature             is 'Identifies attributes defined at a given component level to facilitate application comparisons';



prompt ...apex_application_lov_cols

create or replace view apex_application_lov_cols
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    (select lov_name
       from wwv_flow_lists_of_values$
      where id = c.lov_id)                  list_of_values_name,
    --
    c.query_column_name                     query_column_name,
    c.heading                               heading,
    c.display_sequence                      display_sequence,
    c.format_mask                           format_mask,
    c.data_type                             data_type,
    c.is_searchable                         is_searchable_code,
    decode( c.is_searchable,
        'Y',    'Yes',
        'N',    'No')                       is_searchable,
    c.is_visible                            is_visible_code,
    decode( c.is_visible,
        'Y',    'Yes',
        'N',    'No')                       is_visible,
    --
    c.last_updated_by                       last_updated_by,
    c.last_updated_on                       last_updated_on,
    c.column_comment                        component_comment,
    --
    c.id                                    lov_column_id,
    c.lov_id                                lov_id,
    --
    (select lov_name from wwv_flow_lists_of_values$ where id = c.lov_id)
    ||' col='||c.query_column_name
    ||' seq='||lpad(c.display_sequence,5,'00000')
    component_signature
  from wwv_flow_list_of_values_cols c,
       wwv_flow_authorized f
 where f.workspace_id   = c.security_group_id
   and f.application_id = c.flow_id
/

comment on table apex_application_lov_cols                              is 'Identifies column metadata for a shared list of values.';
comment on column apex_application_lov_cols.workspace                   is 'A work area mapped to one or more database schemas';
comment on column apex_application_lov_cols.workspace_display_name      is 'Display name for the workspace';
comment on column apex_application_lov_cols.application_id              is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_lov_cols.application_name            is 'Identifies the application';
comment on column apex_application_lov_cols.list_of_values_name         is 'Identifies the name of the List of Values';
comment on column apex_application_lov_cols.query_column_name           is 'The name of the column from the shared list of values source definition';
comment on column apex_application_lov_cols.heading                     is 'The label used for the column in the dialog / popup';
comment on column apex_application_lov_cols.display_sequence            is 'Identifies the display sequence used by the column';
comment on column apex_application_lov_cols.format_mask                 is 'Format mask for this column';
comment on column apex_application_lov_cols.data_type                   is 'Used as the data type for the column';
comment on column apex_application_lov_cols.is_searchable_code          is 'Identifies the internal code for the searchable flag';
comment on column apex_application_lov_cols.is_searchable               is 'Identifies if the column is searchable';
comment on column apex_application_lov_cols.is_visible_code             is 'Identifies the internal code for whether the column is visible';
comment on column apex_application_lov_cols.is_visible                  is 'Identifies if the column is visible';
comment on column apex_application_lov_cols.last_updated_by             is 'APEX developer who made last update';
comment on column apex_application_lov_cols.last_updated_on             is 'Date of last update';
comment on column apex_application_lov_cols.component_comment           is 'Developer comment';
comment on column apex_application_lov_cols.lov_column_id               is 'Primary Key of the List of Values Column';
comment on column apex_application_lov_cols.lov_id                      is 'Foreign Key of the List of Values';
comment on column apex_application_lov_cols.component_signature         is 'Identifies attributes defined at a given component level to facilitate application comparisons';


prompt ...apex_application_lov_entires

create or replace view apex_application_lov_entries
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    (select lov_name from wwv_flow_lists_of_values$ where id = l.lov_id) list_of_values_name,
    l.LOV_DISP_SEQUENCE              display_sequence,
    l.LOV_DISP_VALUE                 display_value,
    l.LOV_RETURN_VALUE               return_value,
    --
    l.LOV_TEMPLATE                   lov_entry_template,
    -- conditionality
    nvl((select r from apex_standard_conditions where d = l.LOV_DISP_COND_TYPE),l.LOV_DISP_COND_TYPE)
                                     condition_type,
    l.lov_disp_cond_type             condition_type_code,
    l.LOV_DISP_COND                  condition_expression1,
    l.LOV_DISP_COND2                 condition_expression2,
    (select case when l.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))    build_option,
    --
    -- translation columns
    nvl((select PRIMARY_APPLICATION_ID
     from   APEX_APPLICATION_TRANS_MAP
     where  f.application_id = TRANSLATED_APPLICATION_ID),f.application_id) primary_application_id,
    lower(substr(nvl((select TRANSLATED_APP_LANGUAGE
     from   APEX_APPLICATION_TRANS_MAP
     where  f.application_id = TRANSLATED_APPLICATION_ID),f.FLOW_LANGUAGE),1,2)) TRANSLATED_APP_LANGUAGE,
    --
    l.LAST_UPDATED_BY                last_updated_by,
    l.LAST_UPDATED_ON                last_updated_on,
    l.LOV_DATA_COMMENT               component_comment,
    --
    l.LOV_ID                         lov_id,
    l.id                             lov_entry_id,
    --
    (select lov_name from wwv_flow_lists_of_values$ where id = l.lov_id)
    ||' seq='||lpad(l.LOV_DISP_SEQUENCE,5,'00000')
    ||' v='||substr(l.LOV_DISP_VALUE,1,30)||length(l.LOV_DISP_VALUE)
    ||' r='||substr(l.LOV_RETURN_VALUE,1,30)||length(l.LOV_RETURN_VALUE)
    ||' t='||l.LOV_TEMPLATE
    ||' cond='||l.LOV_DISP_COND_TYPE
    ||substr(l.LOV_DISP_COND,1,30)||length(l.LOV_DISP_COND)
    ||substr(l.LOV_DISP_COND2,1,30)||length(l.LOV_DISP_COND2)
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))
    component_signature
from wwv_flow_list_of_values_data l,
     wwv_flow_authorized          f
where f.workspace_id   = l.security_group_id
  and f.application_id = l.flow_id
/

comment on table  apex_application_lov_entries                       is 'Identifies the List of Values Entries which comprise a shared List of Values';
comment on column apex_application_lov_entries.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_lov_entries.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_lov_entries.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_lov_entries.application_name      is 'Identifies the application';
comment on column apex_application_lov_entries.LIST_OF_VALUES_NAME   is 'Identifies the name of the List of Values';
comment on column apex_application_lov_entries.DISPLAY_SEQUENCE      is 'List of Values display sequence';
comment on column apex_application_lov_entries.DISPLAY_VALUE         is 'Value displayed to end users';
comment on column apex_application_lov_entries.RETURN_VALUE          is 'Value returned and stored in session state';
comment on column apex_application_lov_entries.LOV_ENTRY_TEMPLATE    is 'Identifies a template used to display a List of Values Entry';
comment on column apex_application_lov_entries.CONDITION_TYPE        is 'Identifies the condition type used to conditionally execute the List of Values Entry';
comment on column apex_application_lov_entries.CONDITION_TYPE_CODE   is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_lov_entries.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_lov_entries.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_lov_entries.BUILD_OPTION          is 'List of Values Entry will be displayed if the Build Option is enabled';
comment on column apex_application_lov_entries.COMPONENT_COMMENT     is 'Developer Comment';
comment on column apex_application_lov_entries.LOV_ID                is 'Foreign Key of the List of Values';
comment on column apex_application_lov_entries.LOV_ENTRY_ID          is 'Primary Key of the List of Values Entry';
comment on column apex_application_lov_entries.last_updated_by       is 'APEX developer who made last update';
comment on column apex_application_lov_entries.last_updated_on       is 'Date of last update';
comment on column apex_application_lov_entries.component_signature   is 'Identifies attributes defined at a given component level to facilitate application comparisons';




----------------------------------------------------------------------
-- A P P L I C A T I O N   A U T H E N T I C A T I O N   S C H E M E S
--

prompt ...apex_application_auth

create or replace view apex_application_auth
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    case
      when f.authentication_id = a.id then 'Y'
      else 'N'
    end                              is_current_authentication,
    decode(a.reference_id,
      null,'No','Yes')               is_subscribed,
    case substr(a.scheme_type, 1, 7)
      when 'NATIVE_' then
          ( select display_name
              from wwv_flow_plugins
             where flow_id = 4411
               and plugin_type = 'AUTHENTICATION TYPE'
               and name = substr(a.scheme_type, 8) )
      when 'PLUGIN_' then
          ( select display_name
              from wwv_flow_plugins
             where flow_id = a.flow_id
               and plugin_type = 'AUTHENTICATION TYPE'
               and name = substr(a.scheme_type, 8) )
      else a.scheme_type
    end                              scheme_type,
    a.scheme_type                    scheme_type_code,
    a.name                           authentication_scheme_name,
    --
    a.invalid_session_type           invalid_session_type,
    a.invalid_session_url            invalid_session_url,
    --
    a.plsql_code                     plsql_code,
    a.verification_function          verification_function,
    a.pre_auth_process               pre_authentication_process,
    a.post_auth_process              post_authentication_process,
    --
    decode(a.switch_in_session_yn,'Y','Enabled','Disabled') switch_in_session,
    --
    a.cookie_name                    cookie_name,
    a.cookie_path                    cookie_path,
    a.cookie_domain                  cookie_domain,
    decode(a.use_secure_cookie_yn,'Y','Yes','N','No','No') cookie_secure,
    --
    a.logout_url                     logout_url,
    --
    a.attribute_01                   attribute_01,
    a.attribute_02                   attribute_02,
    a.attribute_03                   attribute_03,
    a.attribute_04                   attribute_04,
    a.attribute_05                   attribute_05,
    a.attribute_06                   attribute_06,
    a.attribute_07                   attribute_07,
    a.attribute_08                   attribute_08,
    a.attribute_09                   attribute_09,
    a.attribute_10                   attribute_10,
    a.attribute_11                   attribute_11,
    a.attribute_12                   attribute_12,
    a.attribute_13                   attribute_13,
    a.attribute_14                   attribute_14,
    a.attribute_15                   attribute_15,
    --
    case a.ras_mode
      when 0 then 'Disabled'
      when 1 then 'External Users'
      when 2 then 'Internal Users'
    end                              ras_mode,
    a.ras_dynamic_roles              ras_dynamic_roles,
    a.ras_namespaces                 ras_namespaces,
    --
    a.help_text                      help_text,
    a.comments                       comments,
    --
    a.id                             authentication_scheme_id,
    a.reference_id                   referenced_schema_id,
    --
    a.last_updated_by                last_updated_by,
    a.last_updated_on                last_updated_on,
    a.created_by                     created_by,
    a.created_on                     created_on,
    --
    a.name
    || ' '                                       || a.scheme_type
    || ' '                                       || decode(a.reference_id,null,'No','Yes')
    || substr(a.invalid_session_type ,1,20)      || length(a.invalid_session_type )         || '.'
    || substr(a.invalid_session_url ,1,20)       || length(a.invalid_session_url )          || '.'
    || sys.dbms_lob.substr(a.pre_auth_process,20,1)  || sys.dbms_lob.getlength(a.pre_auth_process)  || '.'
    || sys.dbms_lob.substr(a.post_auth_process,20,1) || sys.dbms_lob.getlength(a.post_auth_process) || '.'
    || substr(a.cookie_name         ,1,20)       || length(a.cookie_name         )          || '.'
    || substr(a.cookie_path         ,1,20)       || length(a.cookie_path         )          || '.'
    || substr(a.cookie_domain       ,1,20)       || length(a.cookie_domain       )          || '.'
    || substr(a.use_secure_cookie_yn,1,1)        || length(a.use_secure_cookie_yn)          || '.'
    || substr(a.attribute_01        ,1,20)       || length(a.attribute_01        )          || '.'
    || substr(a.attribute_02        ,1,20)       || length(a.attribute_02        )          || '.'
    || substr(a.attribute_03        ,1,20)       || length(a.attribute_03        )          || '.'
    || substr(a.attribute_04        ,1,20)       || length(a.attribute_04        )          || '.'
    || substr(a.attribute_05        ,1,20)       || length(a.attribute_05        )          || '.'
    || substr(a.attribute_06        ,1,20)       || length(a.attribute_06        )          || '.'
    || substr(a.attribute_07        ,1,20)       || length(a.attribute_07        )          || '.'
    || substr(a.attribute_08        ,1,20)       || length(a.attribute_08        )          || '.'
    || substr(a.attribute_09        ,1,20)       || length(a.attribute_09        )          || '.'
    || substr(a.attribute_10        ,1,20)       || length(a.attribute_10        )          || '.'
    || substr(a.attribute_11        ,1,20)       || length(a.attribute_11        )          || '.'
    || substr(a.attribute_12        ,1,20)       || length(a.attribute_12        )          || '.'
    || substr(a.attribute_13        ,1,20)       || length(a.attribute_13        )          || '.'
    || substr(a.attribute_14        ,1,20)       || length(a.attribute_14        )          || '.'
    || substr(a.attribute_15        ,1,20)       || length(a.attribute_15        )
    component_signature
from wwv_flow_authentications a,
     wwv_flow_authorized      f
where f.workspace_id   = a.security_group_id
  and f.application_id = a.flow_id
/

comment on table  apex_application_auth                             is 'Identifies the available Authentication Schemes defined for an Application';
comment on column apex_application_auth.workspace                   is 'A work area mapped to one or more database schemas';
comment on column apex_application_auth.workspace_display_name      is 'Display name for the workspace';
comment on column apex_application_auth.application_id              is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_auth.application_name            is 'Identifies the application';
comment on column apex_application_auth.is_current_authentication   is '"Y" if this is the application''s current authentication scheme, "N" otherwise';
comment on column apex_application_auth.is_subscribed               is 'Identifies if this Authentication Scheme is subscribed from another Authentication Scheme.';
comment on column apex_application_auth.scheme_type                 is 'Type of Authentication Scheme which defines how the Authentication Scheme Source will be interpreted';
comment on column apex_application_auth.SCHEME_TYPE_CODE            is 'Internal code of SCHEME_TYPE';
comment on column apex_application_auth.authentication_scheme_name  is 'Identifies this Authentication Scheme';
comment on column apex_application_auth.invalid_session_type        is 'Specifies a URL Application Express should redirect to if the authentication function returns false: LOGIN - the login page, BUILTIN_LOGIN - the built-in login page, URL - the invalid_session_url';
comment on column apex_application_auth.invalid_session_url         is 'Specifies a URL Application Express should redirect to if the authentication function returns false. This would normally be a URL to a login page or single signon portal.';
comment on column apex_application_auth.plsql_code                 is 'Contains custom authentication code.';
comment on column apex_application_auth.verification_function       is 'The name of the function (within plsql_code, stand-alone or in a package) that will be executed if the session sentry function succeeds. It should return true or false.';
comment on column apex_application_auth.pre_authentication_process  is 'The name of the procedure (within plsql_code, stand-alone or in a package) that will be executed after the login page is submitted and just before credentials verification is performed.';
comment on column apex_application_auth.post_authentication_process is 'The name of the procedure (within plsql_code, stand-alone or in a package) that will be executed after the authentication step (login credentials verification).';
comment on column apex_application_auth.switch_in_session           is 'Specifies whether the authentication scheme can be enabled at runtime';
comment on column apex_application_auth.cookie_name                 is 'Name for the session cookie to be set by the post-login procedure and checked by the Verify Session function.';
comment on column apex_application_auth.cookie_path                 is 'Path attribute for the session cookie to be set by the post-login procedure and checked by the Verify Session function.';
comment on column apex_application_auth.cookie_domain               is 'Domain attribute for the session cookie to be set by the post-login procedure and checked by the Verify Session function. Defaults to null.';
comment on column apex_application_auth.cookie_secure               is 'Specifies whether to set the secure attribute of the session management cookie when sending cookie to browser. Secure cookies can be used only with HTTPS. Defaults to No.';
comment on column apex_application_auth.logout_url                  is 'Specify a URL to become the LOGOUT_URL substitution string.';
comment on column apex_application_auth.attribute_01                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_02                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_03                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_04                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_05                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_06                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_07                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_08                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_09                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_10                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_11                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_12                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_13                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_14                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.attribute_15                is 'Dynamic attribute to store additional data';
comment on column apex_application_auth.ras_mode                    is 'Real Application Security: Disabled, External Users, Internal users';
comment on column apex_application_auth.ras_dynamic_roles           is 'Real Application Security: Colon-separated list of dynamic roles that are enabled on assign_user';
comment on column apex_application_auth.ras_namespaces              is 'Real Application Security: Colon-separated list of namespaces that are enabled on create_session';
comment on column apex_application_auth.help_text                   is 'Text to be displayed in login help popup window off login page. This should offer guidance and links to resources to assist users of the Application Express built-in login page, specific to the type of authentication your application is using (Open Door, Application Express account, or LDAP).';
comment on column apex_application_auth.comments                    is 'Developer comments';
comment on column apex_application_auth.authentication_scheme_id    is 'Primary Key of this component';
comment on column apex_application_auth.referenced_schema_id        is 'Foreign Key to referenced Authentication Scheme';
comment on column apex_application_auth.last_updated_by             is 'APEX developer who made last update';
comment on column apex_application_auth.last_updated_on             is 'Date of last update';
comment on column apex_application_auth.created_by                  is 'APEX developer who created the authentication scheme';
comment on column apex_application_auth.created_on                  is 'Date when the authentication scheme was created';
comment on column apex_application_auth.component_signature         is 'Identifies attributes defined at a given component level to facilitate application comparisons';


----------------------------------------------------------------------
-- A P P L I C A T I O N   A U T H O R I Z A T I O N   S C H E M E S
-- 4008

prompt ...apex_application_authorization

create or replace view apex_application_authorization
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    a.NAME                           authorization_scheme_name,
    case substr(a.scheme_type, 1, 7)
      when 'NATIVE_' then
          ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = 'AUTHORIZATION TYPE' and name = substr(a.scheme_type, 8) )
      when 'PLUGIN_' then
          ( select display_name from wwv_flow_plugins where flow_id = a.flow_id and plugin_type = 'AUTHORIZATION TYPE' and name = substr(a.scheme_type, 8) )
      else a.scheme_type
    end                              scheme_type,
    a.SCHEME_TYPE                    scheme_type_code,
    a.attribute_01,
    a.attribute_02,
    a.attribute_03,
    a.attribute_04,
    a.attribute_05,
    a.attribute_06,
    a.attribute_07,
    a.attribute_08,
    a.attribute_09,
    a.attribute_10,
    a.attribute_11,
    a.attribute_12,
    a.attribute_13,
    a.attribute_14,
    a.attribute_15,
    --
    a.ERROR_MESSAGE                  error_message,
    --
    decode(a.CACHING,
      'BY_USER_BY_PAGE_VIEW','Once per page view',
      'BY_USER_BY_SESSION','Once per session',
      a.CACHING)                     caching,
    decode(a.REFERENCE_ID,null,'No','Yes') is_subscribed,
    a.LAST_UPDATED_BY                last_updated_by,
    a.LAST_UPDATED_ON                last_updated_on,
    a.COMMENTS                       component_comment,
    --
    a.id                             authorization_scheme_id,
    a.REFERENCE_ID                   referenced_scheme_id,
    --
    substr(a.NAME,1,30)||length(a.NAME         )
    ||' t='||substr(a.SCHEME_TYPE  ,1,30)||length(a.SCHEME_TYPE  )
    ||' e='||substr(a.ERROR_MESSAGE,1,30)||length(a.ERROR_MESSAGE)
    ||' s='||decode(a.CACHING,'BY_USER_BY_PAGE_VIEW','Once per page view','BY_USER_BY_SESSION','Once per session',substr(a.CACHING,1,20))
    ||' r='||decode(a.REFERENCE_ID,null,'No','Yes')
    component_signature
from wwv_flow_security_schemes a,
     wwv_flow_authorized       f
where f.workspace_id   = a.security_group_id
  and f.application_id = a.flow_id
/

comment on table  apex_application_authorization                           is 'Identifies Authorization Schemes which can be applied at the application, page or component level';
comment on column apex_application_authorization.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_authorization.workspace_display_name    is 'Display name for the workspace';
comment on column apex_application_authorization.application_id            is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_authorization.application_name          is 'Identifies the application';
comment on column apex_application_authorization.AUTHORIZATION_SCHEME_NAME is 'Name of the Authorization Scheme';
comment on column apex_application_authorization.SCHEME_TYPE               is 'Type of Authorization Scheme which defines how the Authorization Scheme Source will be interpreted';
comment on column apex_application_authorization.SCHEME_TYPE_CODE          is 'Internal code of SCHEME_TYPE';
comment on column apex_application_authorization.attribute_01              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_02              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_03              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_04              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_05              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_06              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_07              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_08              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_09              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_10              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_11              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_12              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_13              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_14              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.attribute_15              is 'Dynamic attribute to store additional data';
comment on column apex_application_authorization.ERROR_MESSAGE             is 'Identifies the Error Message end users will see when this Authentication Scheme fails';
comment on column apex_application_authorization.CACHING                   is 'Identifies the level of Caching used for this Authentication Scheme; typically by Session or Page View.';
comment on column apex_application_authorization.IS_SUBSCRIBED             is 'Identifies if this Authorization Scheme is subscribed from another Authorization Scheme.';
comment on column apex_application_authorization.LAST_UPDATED_BY           is 'APEX Developer User Name who last updated this component';
comment on column apex_application_authorization.LAST_UPDATED_ON           is 'Date this component was last updated';
comment on column apex_application_authorization.COMPONENT_COMMENT         is 'Developer comment';
comment on column apex_application_authorization.AUTHORIZATION_SCHEME_ID   is 'Primary Key of this Authorization Scheme';
comment on column apex_application_authorization.referenced_scheme_id      is 'Foreign Key of referenced Authorization Scheme';
comment on column apex_application_authorization.last_updated_by           is 'APEX developer who made last update';
comment on column apex_application_authorization.last_updated_on           is 'Date of last update';
comment on column apex_application_authorization.component_signature         is 'Identifies attributes defined at a given component level to facilitate application comparisons';


----------------------------------------------------------
-- A P P L I C A T I O N   W E B  S E R V I C E S
--

prompt ...apex_application_web_services

create or replace view apex_application_web_services
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    w.NAME                                 web_service_name,
    w.URL                                  ,
    w.ACTION                               ,
    w.PROXY_OVERRIDE                       ,
    w.soap_version                         ,
    w.SOAP_ENVELOPE                        ,
    w.FLOW_ITEMS_COMMA_DELIMITED           ,
    w.STATIC_PARM_01                       ,
    w.STATIC_PARM_02                       ,
    w.STATIC_PARM_03                       ,
    w.STATIC_PARM_04                       ,
    w.STATIC_PARM_05                       ,
    w.STATIC_PARM_06                       ,
    w.STATIC_PARM_07                       ,
    w.STATIC_PARM_08                       ,
    w.STATIC_PARM_09                       ,
    w.STATIC_PARM_10                       ,
    w.STYLESHEET                           ,
    --
    decode(w.REFERENCE_ID,
        null,'No','Yes')                   is_subscribed,
    (select flow_id||'. '||name n
     from wwv_flow_shared_web_services
     where id = w.id)                      subscribed_from,
    --
    w.LAST_UPDATED_BY                      last_updated_by,
    w.LAST_UPDATED_ON                      last_updated_on,
    --
    w.id                                   web_service_id,
    --
    substr(w.name, 1, 30) || length(w.name) ||
    ' u=' || substr(w.url, 1, 30) || length(w.url) ||
    ' a=' || substr(w.action, 1, 30) || ' sv=' || w.soap_version ||
    ' p1=' || substr(w.static_parm_01, 1, 30) || length(w.static_parm_01) ||
    ' p2=' || substr(w.static_parm_02, 1, 30) || length(w.static_parm_02) ||
    ' p3=' || substr(w.static_parm_03, 1, 30) || length(w.static_parm_03)
    as component_signature
from wwv_flow_shared_web_services w,
     wwv_flow_authorized          f
where f.workspace_id   = w.security_group_id
  and f.application_id = w.flow_id
/

comment on table  apex_application_web_services                             is 'Web Services referenceable from this Application';
comment on column apex_application_web_services.workspace                   is 'A work area mapped to one or more database schemas';
comment on column apex_application_web_services.workspace_display_name      is 'Display name for the workspace';
comment on column apex_application_web_services.application_id              is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_web_services.application_name            is 'Identifies the application';
comment on column apex_application_web_services.WEB_SERVICE_NAME            is 'Identifies the name of the Web Service';
comment on column apex_application_web_services.URL                         is 'Specifies the URL used to post the SOAP request over HTTP';
comment on column apex_application_web_services.ACTION                      is 'Indicates the intent of the SOAP HTTP request';
comment on column apex_application_web_services.PROXY_OVERRIDE              is 'Overrides the system defined HTTP proxy for request';
comment on column apex_application_web_services.soap_version                is 'Identifies the SOAP version of the service, 1.1 or 1.2';
comment on column apex_application_web_services.SOAP_ENVELOPE               is 'Specifies the SOAP envelope to be used for the SOAP request to the Web service';
comment on column apex_application_web_services.FLOW_ITEMS_COMMA_DELIMITED  is 'Comma delimited list of application items';
comment on column apex_application_web_services.STATIC_PARM_01              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_02              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_03              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_04              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_05              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_06              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_07              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_08              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_09              is 'Identifies static parameters';
comment on column apex_application_web_services.STATIC_PARM_10              is 'Identifies static parameters';
comment on column apex_application_web_services.STYLESHEET                  is 'Stylesheet will be used to apply an XML transformation against the result of the SOAP Request';
comment on column apex_application_web_services.IS_SUBSCRIBED               is 'Identifies if this Web Service is subscribed from another Web Service';
comment on column apex_application_web_services.SUBSCRIBED_FROM             is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_web_services.web_service_id              is 'Identifies the primary key of the Web Service';
comment on column apex_application_web_services.last_updated_by             is 'APEX developer who made last update';
comment on column apex_application_web_services.last_updated_on             is 'Date of last update';
comment on column apex_application_web_services.component_signature         is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N    B R E A D C R U M B S
--

prompt ...apex_application_breadcrumbs

create or replace view apex_application_breadcrumbs
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    m.NAME                           breadcrumb_name,
    --
    (select count(*) from wwv_flow_menu_options where menu_id = m.id) breadcrumb_entries,
    --
    m.LAST_UPDATED_BY                last_updated_by,
    m.LAST_UPDATED_ON                last_updated_on,
    m.MENU_COMMENT                   component_comment,
    m.id                             breadcrumb_id,
    --
    m.NAME
    component_signature
from wwv_flow_menus      m,
     wwv_flow_authorized f
where f.workspace_id   = m.security_group_id
  and f.application_id = m.flow_id
/

comment on table  apex_application_breadcrumbs                    is 'Identifies the definition of a collection of Breadcrumb Entries which are used to identify a page Hierarchy';
comment on column apex_application_breadcrumbs.workspace          is 'A work area mapped to one or more database schemas';
comment on column apex_application_breadcrumbs.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_breadcrumbs.application_id     is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_breadcrumbs.application_name   is 'Identifies the application';
comment on column apex_application_breadcrumbs.BREADCRUMB_name    is 'Identifies the Breadcrumb Name, a breadcrumb is a collection of Breadcrumb Entries used to show page context.';
comment on column apex_application_breadcrumbs.BREADCRUMB_ENTRIES is 'Count of Entries defined for this Breadcrumb';
comment on column apex_application_breadcrumbs.COMPONENT_COMMENT  is 'Developer Comment';
comment on column apex_application_breadcrumbs.BREADCRUMB_ID      is 'Primary key of this Breadcrumb';
comment on column apex_application_breadcrumbs.last_updated_by    is 'APEX developer who made last update';
comment on column apex_application_breadcrumbs.last_updated_on    is 'Date of last update';
comment on column apex_application_breadcrumbs.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';



prompt ...apex_application_bc_entries

create or replace view apex_application_bc_entries
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    m.PARENT_ID                      parent_breadcrumb_id,
    m.MENU_ID                        breadcrumb_id,
    --m.OPTION_SEQUENCE                display_sequence,
    m.SHORT_NAME                     entry_label,
    m.LONG_NAME                      entry_long_label,
    m.LINK                           url,
    m.PAGE_ID                        defined_for_page,
    m.ALSO_CURRENT_FOR_PAGES         current_for_pages,
    --
    nvl((select r from apex_standard_conditions where d = m.DISPLAY_WHEN_COND_TYPE),m.DISPLAY_WHEN_COND_TYPE)
                                     condition_type,
    m.display_when_cond_type         condition_type_code,
    m.DISPLAY_WHEN_CONDITION         condition_expression1,
    m.DISPLAY_WHEN_CONDITION2        condition_expression2,
    --
    decode(substr(m.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from    wwv_flow_security_schemes
     where   to_char(id)= ltrim(m.SECURITY_SCHEME,'!')
     and     flow_id = f.application_id),
     m.SECURITY_SCHEME)              authorization_scheme,
    m.SECURITY_SCHEME                authorization_scheme_id,
     --
    (select case when m.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(m.REQUIRED_PATCH) )   build_option,
    m.LAST_UPDATED_BY                last_updated_by,
    m.LAST_UPDATED_ON                last_updated_on,
    m.MENU_OPTION_COMMENT            component_comment,
    m.id                             breadcrumb_entry_id,
    --
    substr(m.SHORT_NAME,1,30)||length(m.SHORT_NAME)
    ||substr(m.LONG_NAME,1,30)||length(m.LONG_NAME)
    ||' l='||substr(m.LINK,1,30)||length(m.LINK)
    ||' p='||PAGE_ID
    ||' c='||substr(m.ALSO_CURRENT_FOR_PAGES,1,30)||length(m.ALSO_CURRENT_FOR_PAGES)
    ||' cond='||m.DISPLAY_WHEN_COND_TYPE
    ||substr(m.DISPLAY_WHEN_CONDITION,1,30)||length(m.DISPLAY_WHEN_CONDITION)
    ||substr(m.DISPLAY_WHEN_CONDITION2,1,30)||length(m.DISPLAY_WHEN_CONDITION2)
    ||' sec='||decode(substr(m.SECURITY_SCHEME,1,1),'!','Not ')||
      nvl((select name from wwv_flow_security_schemes where   to_char(id)= ltrim(m.SECURITY_SCHEME,'!') and flow_id = f.application_id), 'Not found')
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(m.REQUIRED_PATCH) )
    component_signature
from wwv_flow_menu_options m,
     wwv_flow_authorized   f
where f.workspace_id   = m.security_group_id
  and f.application_id = m.flow_id
/

comment on table  apex_application_bc_entries                       is 'Identifies Breadcrumb Entries which map to a Page and identify a pages parent';
comment on column apex_application_bc_entries.workspace             is 'A work area mapped to one or more database schemas';
comment on column apex_application_bc_entries.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_bc_entries.application_id        is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_bc_entries.application_name      is 'Identifies the application';
comment on column apex_application_bc_entries.PARENT_BREADCRUMB_ID  is 'Identifies the Parent Breadcrumb ID.';
comment on column apex_application_bc_entries.BREADCRUMB_ID         is 'Identifies the Primary Key of this Breadcrumb Entry';
comment on column apex_application_bc_entries.ENTRY_LABEL           is 'Identifies the label which will be displayed for this Breadcrumb Entry';
comment on column apex_application_bc_entries.ENTRY_LONG_LABEL      is 'Identifies an optional longer version of the Breadcrumb Entry';
comment on column apex_application_bc_entries.URL                   is 'The URL corresponding to a breadcrumb entry.  When a user clicks the breadcrumb they will navigate to this URL.';
comment on column apex_application_bc_entries.DEFINED_FOR_PAGE      is 'Identifies the pages for which this Breadcrumb Entry is defined';
comment on column apex_application_bc_entries.CURRENT_FOR_PAGES     is 'Identifies a page or pages for which this breadcrumb is current.  Current and non current breadcrumbs have different templates and may be rendered differently.';
comment on column apex_application_bc_entries.CONDITION_TYPE        is 'For breadcrumbs that are displayed conditionally identifies the condition type';
comment on column apex_application_bc_entries.CONDITION_TYPE_CODE   is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_bc_entries.CONDITION_EXPRESSION1 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_bc_entries.CONDITION_EXPRESSION2 is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_bc_entries.AUTHORIZATION_SCHEME  is 'An authorization scheme must evaluate to TRUE in order for this page to be displayed';
comment on column apex_application_bc_entries.AUTHORIZATION_SCHEME_ID is 'Foreign Key';
comment on column apex_application_bc_entries.BUILD_OPTION          is 'Breadcrumb Entry will be displayed if the Build Option is enabled';
comment on column apex_application_bc_entries.COMPONENT_COMMENT     is 'Developer comment';
comment on column apex_application_bc_entries.BREADCRUMB_ENTRY_ID   is 'Foreign key identifying the Breadcrumb definition';
comment on column apex_application_bc_entries.last_updated_by       is 'APEX developer who made last update';
comment on column apex_application_bc_entries.last_updated_on       is 'Date of last update';
comment on column apex_application_bc_entries.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';



---------------------------------------------------------
-- A P P L I C A T I O N   L I S T S
--

prompt ...apex_application_lists

create or replace view apex_application_lists
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    l.NAME                           list_name,
    decode(l.list_type,null,'Static',
                      'STATIC','Static',
                      'SQL_QUERY','SQL Query',
                      'FUNCTION_RETURNING_SQL_QUERY','Function Returning SQL Query') list_type,
    decode(l.list_type,null,'STATIC',l.list_type) list_type_code,
    l.list_query                     list_query,
    --l.LIST_STATUS                    list_status,
    --l.LIST_DISPLAYED,
    (select case when l.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))    build_option,
    (select count(*) from wwv_flow_list_items where list_id = l.id) list_entries,
    --
    l.LAST_UPDATED_BY                last_updated_by,
    l.LAST_UPDATED_ON                last_updated_on,
    l.LIST_COMMENT                   component_comment,
    l.ID                             list_id,
    --
    l.NAME
    ||' s='||l.LIST_STATUS
    ||' bo='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(l.REQUIRED_PATCH))
    component_signature,
    --
    -- For compatibility with SQL Developer
    cast(null as varchar2(255)) template
from wwv_flow_lists      l,
     wwv_flow_authorized f
where f.workspace_id   = l.security_group_id
  and f.application_id = l.flow_id
/

comment on table  apex_application_lists                   is 'Identifies a named collection of Application List Entries which can be included on any page using a region of type List.  Display attributes are controlled using a List Template.';
comment on column apex_application_lists.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_lists.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_lists.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_lists.application_name  is 'Identifies the application';
comment on column apex_application_lists.LIST_NAME         is 'Identifies the name of the Application List';
comment on column apex_application_lists.LIST_TYPE         is 'Identifies the type of the Application List';
comment on column apex_application_lists.LIST_TYPE_CODE    is 'Internal code of LIST_TYPE';
comment on column apex_application_lists.LIST_QUERY        is 'Identifies the query of a Dynamic Application List';
comment on column apex_application_lists.BUILD_OPTION      is 'List will be displayed if the Build Option is enabled';
comment on column apex_application_lists.COMPONENT_COMMENT is 'Developer Comment';
comment on column apex_application_lists.LIST_ID           is 'Identifies the primary key of this component';
comment on column apex_application_lists.last_updated_by   is 'APEX developer who made last update';
comment on column apex_application_lists.last_updated_on   is 'Date of last update';
comment on column apex_application_lists.list_entries      is 'Number of list entries defined for list';
comment on column apex_application_lists.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_lists.TEMPLATE          is 'Identifies the List Template to use by default when rendering this List within a Region.  Regions may override this default template. (obsolete)';



create or replace view apex_application_list_entries
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    l.NAME                           list_name,
    --
    --e.SUB_ITEM_COUNT                 ,
    --e.PARENT_LIST_ITEM_ID            ,
    (select list_item_link_text
     from   wwv_flow_list_items
     where  id = e.PARENT_LIST_ITEM_ID and
            flow_id = e.flow_id)     parent_entry_text,
    --e.LIST_ITEM_TYPE                 ,
    --e.LIST_ITEM_STATUS               ,
    --e.ITEM_DISPLAYED                 ,
    e.LIST_ITEM_DISPLAY_SEQUENCE     display_sequence,
    e.LIST_ITEM_LINK_TEXT            entry_text,
    e.LIST_ITEM_LINK_TARGET          entry_target,
    --
    e.LIST_ITEM_ICON                 entry_image,
    e.LIST_ITEM_ICON_ATTRIBUTES      entry_image_attributes,
    e.LIST_ITEM_ICON_ALT_ATTRIBUTE   entry_image_alt_attribute,
    --e.LIST_ITEM_ICON_EXP             ,
    --e.LIST_ITEM_ICON_EXP_ATTR        ,
    --e.LIST_ITEM_OWNER                ,
    --
    decode(e.LIST_ITEM_CURRENT_TYPE,
      'ALWAYS',                      'Always',
      'COLON_DELIMITED_PAGE_LIST',   'Colon Delimited Page List',
      'EXISTS',                      'Exists SQL Query',
      'NEVER',                       'Never',
      'NOT_EXISTS',                  'Not Exists SQL Query',
      'PLSQL_EXPRESSION',            'PL/SQL Expression',
      'PAGE_RANGE',                  'Page Range (X-Y)',
      e.LIST_ITEM_CURRENT_TYPE)      current_for_pages_type,
    e.list_item_current_type         current_for_pages_type_code,
    e.LIST_ITEM_CURRENT_FOR_PAGES    current_for_pages_expression,
    --
    nvl((select r from apex_standard_conditions where d = e.LIST_ITEM_DISP_COND_TYPE),e.LIST_ITEM_DISP_COND_TYPE)
                                     condition_type,
    e.list_item_disp_cond_type       condition_type_code,
    e.LIST_ITEM_DISP_CONDITION       condition_expression1,
    --e.LIST_ITEM_DISP_COND_TYPE2      ,
    e.LIST_ITEM_DISP_CONDITION2      condition_expression2,
    --
    decode(e.LIST_COUNTCLICKS_Y_N,
      'Y','Yes','N','No',
      e.LIST_COUNTCLICKS_Y_N)        count_clicks,
    e.LIST_COUNTCLICKS_CAT           click_count_category,
    --
    e.LIST_TEXT_01                   entry_attribute_01,
    e.LIST_TEXT_02                   entry_attribute_02,
    e.LIST_TEXT_03                   entry_attribute_03,
    e.LIST_TEXT_04                   entry_attribute_04,
    e.LIST_TEXT_05                   entry_attribute_05,
    e.LIST_TEXT_06                   entry_attribute_06,
    e.LIST_TEXT_07                   entry_attribute_07,
    e.LIST_TEXT_08                   entry_attribute_08,
    e.LIST_TEXT_09                   entry_attribute_09,
    e.LIST_TEXT_10                   entry_attribute_10,
    e.translate_list_text_y_n        translate_attributes,
    --e.LIST_TEXT_11                   entry_attribute_11,
    --e.LIST_TEXT_12                   entry_attribute_12,
    --e.LIST_TEXT_13                   entry_attribute_13,
    --e.LIST_TEXT_14                   entry_attribute_14,
    --e.LIST_TEXT_15                   entry_attribute_15,
    --e.LIST_TEXT_16                   entry_attribute_16,
    --e.LIST_TEXT_17                   entry_attribute_17,
    --e.LIST_TEXT_18                   entry_attribute_18,
    --e.LIST_TEXT_19                   entry_attribute_19,
    --e.LIST_TEXT_20                   entry_attribute_20,
    --
    (select case when e.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(e.REQUIRED_PATCH))    build_option,
    --
    decode(substr(e.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(e.SECURITY_SCHEME,'!')
     and    flow_id = f.application_id),
     e.SECURITY_SCHEME)              authorization_scheme,
    e.SECURITY_SCHEME                authorization_scheme_id,
    --
    -- translation columns
    nvl((select PRIMARY_APPLICATION_ID
     from   APEX_APPLICATION_TRANS_MAP
     where  f.application_id = TRANSLATED_APPLICATION_ID),f.application_id) primary_application_id,
    lower(substr(nvl((select TRANSLATED_APP_LANGUAGE
     from   APEX_APPLICATION_TRANS_MAP
     where  f.application_id = TRANSLATED_APPLICATION_ID),f.FLOW_LANGUAGE),1,2)) TRANSLATED_APP_LANGUAGE,
    --
    e.LAST_UPDATED_BY                last_updated_by,
    e.LAST_UPDATED_ON                last_updated_on,
    e.LIST_ITEM_COMMENT              component_comment,
    e.list_id                        list_id,
    e.PARENT_LIST_ITEM_ID            list_entry_parent_id,
    e.id                             list_entry_id,
    --
    l.NAME
    ||' p='||(select list_item_link_text from wwv_flow_list_items where  id = e.PARENT_LIST_ITEM_ID and flow_id = e.flow_id)
    ||' '||lpad(e.LIST_ITEM_DISPLAY_SEQUENCE,5,'00000')
    ||' '||substr(e.LIST_ITEM_LINK_TEXT      ,1,30)
    ||' '||substr(e.LIST_ITEM_LINK_TARGET    ,1,30)||length(e.LIST_ITEM_LINK_TARGET)
    ||' '||substr(e.LIST_ITEM_ICON           ,1,30)
    ||' '||substr(e.LIST_ITEM_ICON_ATTRIBUTES,1,30)||length(e.LIST_ITEM_ICON_ATTRIBUTES)
    ||' '||decode(e.LIST_ITEM_CURRENT_TYPE,
      'ALWAYS',                      'Always',
      'COLON_DELIMITED_PAGE_LIST',   'Colon Delimited Page List',
      'EXISTS',                      'Exists SQL Query',
      'NEVER',                       'Never',
      'NOT_EXISTS',                  'Not Exists SQL Query',
      'PLSQL_EXPRESSION',            'PL/SQL Expression',
      e.LIST_ITEM_CURRENT_TYPE)
    ||' '||substr(e.LIST_ITEM_CURRENT_FOR_PAGES,1,30)||length(e.LIST_ITEM_CURRENT_FOR_PAGES)
    ||' c='||e.LIST_ITEM_DISP_COND_TYPE
    ||substr(e.LIST_ITEM_DISP_CONDITION,1,30)||length(e.LIST_ITEM_DISP_CONDITION)
    ||substr(e.LIST_ITEM_DISP_CONDITION2,1,30)||length(e.LIST_ITEM_DISP_CONDITION2)
    ||' c='||decode(e.LIST_COUNTCLICKS_Y_N,
      'Y','Yes','N','No',
      e.LIST_COUNTCLICKS_Y_N)
    ||' c='||e.LIST_COUNTCLICKS_CAT
    ||' t='
    ||length(e.LIST_TEXT_01)
    ||length(e.LIST_TEXT_02)
    ||length(e.LIST_TEXT_03)
    ||length(e.LIST_TEXT_04)
    ||length(e.LIST_TEXT_05)
    ||length(e.LIST_TEXT_06)
    ||length(e.LIST_TEXT_07)
    ||length(e.LIST_TEXT_08)
    ||length(e.LIST_TEXT_09)
    ||length(e.LIST_TEXT_10)
    ||translate_list_text_y_n
    ||' b='||(select PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(e.REQUIRED_PATCH))
    ||' s='||decode(substr(e.SECURITY_SCHEME,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(e.SECURITY_SCHEME,'!')
     and    flow_id = f.application_id),
     'Not found')
    component_signature
from wwv_flow_list_items e,
     wwv_flow_lists      l,
     wwv_flow_authorized f
where f.workspace_id      = l.security_group_id
  and f.application_id    = l.flow_id
  and l.security_group_id = e.security_group_id
  and l.id                = e.list_id
/

comment on table  apex_application_list_entries                   is 'Identifies the List Entries which define a List.  List Entries can be hierarchical or flat.';
comment on column apex_application_list_entries.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_list_entries.workspace_display_name       is 'Display name for the workspace';
comment on column apex_application_list_entries.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_list_entries.application_name  is 'Identifies the application';
comment on column apex_application_list_entries.LIST_NAME                    is 'Name of the Application List this List Entry is part of';
comment on column apex_application_list_entries.PARENT_entry_TEXT            is 'Identifies the Parent of this List Entry';
comment on column apex_application_list_entries.DISPLAY_SEQUENCE             is 'Identifies the display sequence';
comment on column apex_application_list_entries.entry_TEXT                   is 'Identifies the Link Text which will be displayed to the end user of the application';
comment on column apex_application_list_entries.entry_TARGET                 is 'Identifies the URL target of this List Entry';
comment on column apex_application_list_entries.entry_IMAGE                  is 'Identifies an optional image associated with this List Entry';
comment on column apex_application_list_entries.entry_IMAGE_ATTRIBUTES       is 'Identifies image attributes that will be rendered within the HTML IMG tag for list entries that include Link Images';
comment on column apex_application_list_entries.entry_IMAGE_ALT_ATTRIBUTE    is 'Identifies an optional image alt attribute associated with this List Entry image';
comment on column apex_application_list_entries.CURRENT_FOR_PAGES_TYPE       is 'Identifies a Condition Type used to determine if this List Entry is current; reference Current For Pages Expression attribute';
comment on column apex_application_list_entries.CURRENT_FOR_PAGES_TYPE_CODE  is 'Internal code of CURRENT_FOR_PAGES_TYPE';
comment on column apex_application_list_entries.CURRENT_FOR_PAGES_EXPRESSION is 'Identifies a page or pages (or other condition) used to determine if this List Entry is to be rendered as a Current List Entry';
comment on column apex_application_list_entries.CONDITION_TYPE               is 'For conditionally displayed list entries; identifies the condition type.  The condition is specified in the Expression 1 and Expression 2 attributes.';
comment on column apex_application_list_entries.CONDITION_TYPE_CODE          is 'Internal code of CONDITION_TYPE.';
comment on column apex_application_list_entries.CONDITION_EXPRESSION1        is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_list_entries.CONDITION_EXPRESSION2        is 'Specifies an expression based on the specific condition type selected.';
comment on column apex_application_list_entries.COUNT_CLICKS                 is 'Determines if the APEX click counter log should record a click entry when this list entry is clicked';
comment on column apex_application_list_entries.CLICK_COUNT_CATEGORY         is 'Determines the APEX click counter category used to provide greater context to the click count log';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_01           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_02           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_03           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_04           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_05           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_06           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_07           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_08           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_09           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.ENTRY_ATTRIBUTE_10           is 'Identifies attributes which may be referenced in the corresponding List Template';
comment on column apex_application_list_entries.translate_attributes         is 'Include attributes 1 through 10 in a generated XLIFF translation file';
comment on column apex_application_list_entries.BUILD_OPTION                 is 'List Entry will be displayed if the Build Option is enabled';
comment on column apex_application_list_entries.AUTHORIZATION_SCHEME         is 'An authorization scheme must evaluate to TRUE in order for this page to be displayed';
comment on column apex_application_list_entries.AUTHORIZATION_SCHEME_ID      is 'Foreign Key';
comment on column apex_application_list_entries.LAST_UPDATED_BY              is 'APEX User who last updated this component';
comment on column apex_application_list_entries.LAST_UPDATED_ON              is 'Date on which this component was last updated last';
comment on column apex_application_list_entries.COMPONENT_COMMENT            is 'Developer Comment';
comment on column apex_application_list_entries.last_updated_by              is 'APEX developer who made last update';
comment on column apex_application_list_entries.last_updated_on              is 'Date of last update';
comment on column apex_application_list_entries.list_id                      is 'Foreign key of the List';
comment on column apex_application_list_entries.list_entry_parent_id         is 'Foreign key of the Parent List Entry';
comment on column apex_application_list_entries.list_entry_id                is 'Primary Key of this List Entry';
comment on column apex_application_list_entries.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N   R E P O R T  Q U E R I E S
--

prompt ...apex_application_rpt_queries

create or replace view apex_application_rpt_queries
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    q.name                           report_query_name,
    q.query_text                     query_text,
    q.xml_structure                  xml_structure,
    (select report_layout_name from wwv_flow_report_layouts where id = q.report_layout_id) report_layout_name,
    q.format                         output_format,
    q.format_item                    output_format_item,
    q.output_file_name               output_file_name,
    q.content_disposition            content_disposition,
    q.document_header                document_header,
    q.xml_items                      xml_items,
    --
    q.last_updated_by                last_updated_by,
    q.last_updated_on                last_updated_on,
    --
    q.id                             report_query_id,
    --
    q.name
    ||' xs='||q.xml_structure
    ||' l=' ||report_layout_id
    ||' f=' ||q.format
    ||' fi='||q.format_item
    ||' o=' ||q.output_file_name
    ||' c=' ||q.content_disposition
    ||' d=' ||q.document_header
    ||' xi='||substr(q.xml_items,1,30)||length(q.xml_items)
    component_signature
from wwv_flow_shared_queries q,
     wwv_flow_authorized f
where f.workspace_id   = q.security_group_id
  and f.application_id = q.flow_id
/

comment on table  apex_application_rpt_queries                        is 'Identifies report queries, which are printable documents that can be integrated with an application using buttons, list items, branches';
comment on column apex_application_rpt_queries.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_rpt_queries.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_rpt_queries.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_rpt_queries.application_name       is 'Identifies the application';
comment on column apex_application_rpt_queries.report_query_name      is 'Identifies the name of the report query';
comment on column apex_application_rpt_queries.query_text             is 'Identifies SQL query of the report query';
comment on column apex_application_rpt_queries.xml_structure          is 'Identifies XML structure of report data: standard or apex';
comment on column apex_application_rpt_queries.report_layout_name     is 'Identifies the name of the repory layout';
comment on column apex_application_rpt_queries.output_format          is 'Identifies the output format of the report';
comment on column apex_application_rpt_queries.output_format_item     is 'Identifies the page item that can be used to define the output format string';
comment on column apex_application_rpt_queries.output_file_name       is 'Identifies the output file name of the report';
comment on column apex_application_rpt_queries.content_disposition    is 'Identifies the content disposition of the download file';
comment on column apex_application_rpt_queries.document_header        is 'Identifies the document header of the download file';
comment on column apex_application_rpt_queries.xml_items              is 'Identifies the item session state to be included in the XML data';
comment on column apex_application_rpt_queries.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_rpt_queries.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_rpt_queries.last_updated_on        is 'Date of last update';
comment on column apex_application_rpt_queries.report_query_id        is 'Identified the prinmary key of this component';
comment on column apex_application_rpt_queries.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N   R E P O R T  Q U E R Y  S Q L  S T A T E M E N T S
--

prompt ...apex_application_rpt_qry_stmts

create or replace view apex_application_rpt_qry_stmts
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    (select name from wwv_flow_shared_queries where id = q.shared_query_id) report_query_name,
    sql_statement                    sql_statement,
    --
    q.last_updated_by                last_updated_by,
    q.last_updated_on                last_updated_on,
    --
    q.id                             report_query_stmt_id,
    --
    (select name from wwv_flow_shared_queries where id = q.shared_query_id)
    ||' q=' ||substr(q.sql_statement,1,30)||length(q.sql_statement)
    component_signature
from wwv_flow_shared_qry_sql_stmts q,
     wwv_flow_authorized f
where f.workspace_id   = q.security_group_id
  and f.application_id = q.flow_id
/

comment on table  apex_application_rpt_qry_stmts                        is 'Identifies inidividual SQL statements, which are part of a report quert';
comment on column apex_application_rpt_qry_stmts.workspace              is 'A work area mapped to one or more database schemas';
comment on column apex_application_rpt_qry_stmts.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_rpt_qry_stmts.application_id         is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_rpt_qry_stmts.application_name       is 'Identifies the application';
comment on column apex_application_rpt_qry_stmts.report_query_name      is 'Identifies the name of the report query';
comment on column apex_application_rpt_qry_stmts.sql_statement          is 'Inidividual SQL statements';
comment on column apex_application_rpt_qry_stmts.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_rpt_qry_stmts.last_updated_by        is 'APEX developer who made last update';
comment on column apex_application_rpt_qry_stmts.last_updated_on        is 'Date of last update';
comment on column apex_application_rpt_qry_stmts.report_query_stmt_id   is 'Identified the prinmary key of this component';
comment on column apex_application_rpt_qry_stmts.component_signature    is 'Identifies attributes defined at a given component level to facilitate application comparisons';


---------------------------------------------------------
-- A P P L I C A T I O N   R E P O R T  L A Y O U T S
--

prompt ...apex_application_rpt_layouts

create or replace view apex_application_rpt_layouts
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    l.report_layout_name                report_layout_name,
    l.report_layout_type                report_layout_type,
    l.page_template                     page_template,
    l.xslfo_column_heading_template     xslfo_column_heading_template,
    l.xslfo_column_template             xslfo_column_template,
    l.xslfo_column_template_width       xslfo_column_template_width,
    l.report_layout_comment             report_layout_comment,
    --
    l.last_updated_by                   last_updated_by,
    l.last_updated_on                   last_updated_on,
    --
    l.id                                report_layout_id,
    --
    l.report_layout_name
    ||' t=' ||l.report_layout_type
    ||' ht='||substr(l.xslfo_column_heading_template,1,30)||length(l.xslfo_column_heading_template)
    ||' ct='||substr(l.xslfo_column_template,1,30)||length(l.xslfo_column_template)
    ||' w=' ||substr(l.xslfo_column_template_width,1,30)||length(l.xslfo_column_template_width)
    ||' c=' ||substr(l.report_layout_comment,1,30)||length(l.report_layout_comment)
    component_signature
from wwv_flow_report_layouts l,
     wwv_flow_authorized f
where f.workspace_id   = l.security_group_id
  and f.application_id = l.flow_id
/

comment on table  apex_application_rpt_layouts                                is 'Identifies report layout which can be referenced by report queries and classic reports';
comment on column apex_application_rpt_layouts.workspace                      is 'A work area mapped to one or more database schemas';
comment on column apex_application_rpt_layouts.workspace_display_name         is 'Display name for the workspace';
comment on column apex_application_rpt_layouts.application_id                 is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_rpt_layouts.application_name               is 'Identifies the application';
comment on column apex_application_rpt_layouts.report_layout_name             is 'Identifies the name of the report layout';
comment on column apex_application_rpt_layouts.report_layout_type             is 'Identifies the type of the report layout';
comment on column apex_application_rpt_layouts.page_template                  is 'Identifies the page template';
comment on column apex_application_rpt_layouts.xslfo_column_heading_template  is 'Identifies the column heading template';
comment on column apex_application_rpt_layouts.xslfo_column_template          is 'Identifies the column template';
comment on column apex_application_rpt_layouts.xslfo_column_template_width    is 'Identifies the width of the column template';
comment on column apex_application_rpt_layouts.report_layout_comment          is 'Identifies a commnet for the report layout';
comment on column apex_application_rpt_layouts.last_updated_by                is 'APEX developer who made last update';
comment on column apex_application_rpt_layouts.last_updated_by                is 'APEX developer who made last update';
comment on column apex_application_rpt_layouts.last_updated_on                is 'Date of last update';
comment on column apex_application_rpt_layouts.report_layout_id               is 'Identified the prinmary key of this component';
comment on column apex_application_rpt_layouts.component_signature            is 'Identifies attributes defined at a given component level to facilitate application comparisons';

---------------------------------------------------------
-- A P P L I C A T I O N   T H E M E S
--
prompt ...apex_application_themes

create or replace view apex_application_themes
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.theme_id                                                                                               theme_number,
    t.theme_name                                                                                             theme_name,
    t.theme_internal_name                                                                                    theme_internal_name,
    t.ui_type_id,
    uit.name                                                                                                 ui_type_name,
    t.reference_id,
    case t.navigation_type
      when 'T'    then 'Tabs'
      when 'L'    then 'Navigation Menu List'
    end as navigation_type,
    t.navigation_type as navigation_type_code,
    t.default_nav_list_position,
    case t.nav_bar_type
      when 'NAVBAR'    then 'Navigation Bar'
      when 'LIST'      then 'List'
    end as nav_bar_type,
    t.nav_bar_type as nav_bar_type_code,
    t.is_locked,
    case
      when exists ( select 1
                      from wwv_flow_user_interfaces ui
                     where ui.flow_id  = t.flow_id
                       and ui.theme_id = t.theme_id ) then 'Yes'
      else 'No'
    end as is_current,
    (select name from wwv_flow_templates where id = t.default_page_template)                                 default_page_template,
    --t.error_template                   ,
    --t.printer_friendly_template        ,
    --t.breadcrumb_display_point         ,
    --t.sidebar_display_point,
    --t.login_template                   ,
    (select template_name from wwv_flow_button_templates where id = t.default_button_template )                 default_button_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_region_template)     default_region_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_chart_template)      default_chart_rg_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_form_template)       default_form_rg_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_reportr_template)    default_report_region_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_tabform_template)    default_tabular_form_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_wizard_template)     default_wizard_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_menur_template)      default_breadcrumb_rg_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_listr_template)      default_list_region_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_irr_template)        default_irr_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_header_template)     default_header_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_footer_template)     default_footer_template,
    (select row_template_name from wwv_flow_row_templates where id = t.default_report_template)                 default_report_row_template,
    (select template_Name from wwv_flow_field_templates where id = t.default_label_template)                    default_item_label_template,
    (select name from wwv_flow_menu_templates where id = t.default_menu_template)                               default_breadcrumb_template,
    (select name from wwv_flow_cal_templates where id = t.default_calendar_template)                            default_calendar_template,
    (select list_template_name from wwv_flow_list_templates where id = t.default_list_template)                 default_list_template,
    (select list_template_name from wwv_flow_list_templates where id = t.default_nav_list_template)             default_nav_list_template,
    (select list_template_name from wwv_flow_list_templates where id = t.default_top_nav_list_template)         default_top_nav_list_template,
    (select list_template_name from wwv_flow_list_templates where id = t.default_side_nav_list_template)        default_side_nav_list_template,
    (select template_name from wwv_flow_field_templates where id = t.default_option_label)                      default_option_label,
    (select template_name from wwv_flow_field_templates where id = t.default_required_label)                    default_required_label,
    (select list_template_name from wwv_flow_list_templates where id = t.default_nav_bar_list_template)         default_nav_bar_list_template,
    --
    (select name from wwv_flow_templates where id = t.default_dialog_template)                                  default_dialog_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_dialogr_template)    default_dialogr_template,
    (select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_dialogbtnr_template) default_dialogbtnr_template,
    --
    t.default_page_transition,
    t.default_popup_transition,
    --
    t.last_updated_on                                                                                        last_updated_on,
    t.last_updated_by                                                                                        last_updated_by,
    t.calendar_icon                                                                                          calendar_icon_image_name,
    t.calendar_icon_attr                                                                                     calendar_icon_attributes,
    t.custom_icon_classes,
    t.custom_icon_prefix_class,
    t.custom_library_file_urls,
    t.icon_library,
    t.javascript_file_urls,
    t.css_file_urls,
    t.id                                                                                                     theme_id,
    t.theme_description                                                                                      theme_description,
    t.file_prefix,
    t.files_version,
    --
    t.theme_id
    ||' n='||substr(t.theme_name                                                                                             ,1,30)
    ||' p='||substr((select name from wwv_flow_templates where id = t.default_page_template)                                 ,1,30)
    ||' e='||substr((select name from wwv_flow_templates where id = t.error_template),1,30)
    ||' b='||substr((select template_name from wwv_flow_button_templates where id = t.default_button_template )              ,1,30)
    ||' r='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_region_template)  ,1,30)
    ||' c='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_chart_template)   ,1,30)
    ||' f='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_form_template)    ,1,30)
    ||' r='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_reportr_template) ,1,30)
    ||' t='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_tabform_template) ,1,30)
    ||' w='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_wizard_template)  ,1,30)
    ||' b='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_menur_template)   ,1,30)
    ||' l='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_listr_template)   ,1,30)
    ||' i='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_irr_template)     ,1,30)
    ||' h='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_header_template)  ,1,30)
    ||' f='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_footer_template)  ,1,30)
    ||' r='||substr((select row_template_name from wwv_flow_row_templates where id = t.default_report_template)              ,1,30)
    ||' i='||substr((select template_Name from wwv_flow_field_templates where id = t.default_label_template)                 ,1,30)
    ||' b='||substr((select name from wwv_flow_menu_templates where id = t.default_menu_template)                            ,1,30)
    ||' c='||substr((select name from wwv_flow_cal_templates where id = t.default_calendar_template)                         ,1,30)
    ||' l='||substr((select list_template_name from wwv_flow_list_templates where id = t.default_list_template)              ,1,30)
    ||' l='||substr((select list_template_name from wwv_flow_list_templates where id = t.default_nav_list_template)          ,1,30)
    ||' l='||substr((select list_template_name from wwv_flow_list_templates where id = t.default_top_nav_list_template)      ,1,30)
    ||' l='||substr((select list_template_name from wwv_flow_list_templates where id = t.default_side_nav_list_template)     ,1,30)
    ||' l='||substr((select template_Name from wwv_flow_field_templates where id = t.default_option_label)                   ,1,30)
    ||' l='||substr((select template_Name from wwv_flow_field_templates where id = t.default_required_label)                 ,1,30)
    ||' l='||substr((select list_template_name from wwv_flow_list_templates where id = t.default_nav_bar_list_template)      ,1,30)
    ||' c='||substr(t.calendar_icon,1,30)
    ||' c='||substr(t.calendar_icon_attr,1,30)
    ||' dbr='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_dialogbtnr_template)   ,1,30)
    ||' dr='||substr((select page_plug_template_name from wwv_flow_page_plug_templates where id = t.default_dialogr_template)   ,1,30)
    component_signature
from wwv_flow_themes     t,
     wwv_flow_ui_types   uit,
     wwv_flow_authorized f
where f.workspace_id      = t.security_group_id
  and f.application_id    = t.flow_id
  and t.ui_type_id        = uit.id
/

comment on table  apex_application_themes                                  is 'Identifies a named collection of Templates';
comment on column apex_application_themes.workspace                        is 'A work area mapped to one or more database schemas';
comment on column apex_application_themes.workspace_display_name           is 'Display name for the workspace';
comment on column apex_application_themes.application_id                   is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_themes.application_name                 is 'Identifies the application';
comment on column apex_application_themes.THEME_NUMBER                     is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_themes.THEME_NAME                       is 'Identifies the name of the theme';
comment on column apex_application_themes.THEME_INTERNAL_NAME              is 'Identifies the internal name of the theme';
comment on column apex_application_themes.NAVIGATION_TYPE                  is 'Identifies whether theme uses tabs or navigation menu lists';
comment on column apex_application_themes.NAVIGATION_TYPE_CODE             is 'Identifies whether theme uses tabs or navigation menu lists';
comment on column apex_application_themes.default_nav_list_position        is 'Identifies whether theme uses top or side navigation menu lists';
comment on column apex_application_themes.NAV_BAR_TYPE                     is 'Identifies whether theme uses navigation bar or lists';
comment on column apex_application_themes.NAV_BAR_TYPE_CODE                is 'Identifies whether theme uses navigation bar or lists';
comment on column apex_application_themes.is_current                       is 'Identifies whether the theme is the current one for the user interface in the application';
comment on column apex_application_themes.DEFAULT_PAGE_TEMPLATE            is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_DIALOG_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_BUTTON_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REGION_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_CHART_RG_TEMPLATE        is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_FORM_RG_TEMPLATE         is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REPORT_REGION_TEMPLATE   is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_TABULAR_FORM_TEMPLATE    is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_WIZARD_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_BREADCRUMB_RG_TEMPLATE   is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_LIST_REGION_TEMPLATE     is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_IRR_TEMPLATE             is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_HEADER_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_FOOTER_TEMPLATE          is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REPORT_ROW_TEMPLATE      is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_ITEM_LABEL_TEMPLATE      is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_BREADCRUMB_TEMPLATE      is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_CALENDAR_TEMPLATE        is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_LIST_TEMPLATE            is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_NAV_LIST_TEMPLATE        is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_TOP_NAV_LIST_TEMPLATE    is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_SIDE_NAV_LIST_TEMPLATE   is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_OPTION_LABEL             is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_REQUIRED_LABEL           is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.DEFAULT_DIALOGBTNR_TEMPLATE      is 'Identifies the default template when creating new button region on a dialog';
comment on column apex_application_themes.DEFAULT_DIALOGR_TEMPLATE         is 'Identifies the default template when creating new component region on a dialog';
comment on column apex_application_themes.DEFAULT_NAV_BAR_LIST_TEMPLATE    is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.CALENDAR_ICON_IMAGE_NAME         is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.CALENDAR_ICON_ATTRIBUTES         is 'Identifies the default template when creating new components of a corresponding type';
comment on column apex_application_themes.custom_icon_classes              is 'List of custom icon CSS classes available with this theme';
comment on column apex_application_themes.custom_icon_prefix_class         is 'CSS class which is automatically added during runtime if a custom icon CSS class is used';
comment on column apex_application_themes.custom_library_file_urls         is 'List of URLs which should be loaded to support the custom icon css classes. ';
comment on column apex_application_themes.icon_library                     is 'Current icon library used with theme';
comment on column apex_application_themes.javascript_file_urls             is 'Allows definition of JavaScript file URLs that will be loaded on every page in the application.';
comment on column apex_application_themes.css_file_urls                    is 'Allows definition of CSS file URLs that will be loaded on every page in the application.';
comment on column apex_application_themes.THEME_ID                         is 'Primary Key of the Theme';
comment on column apex_application_themes.theme_description                is 'Comment field';
comment on column apex_application_themes.file_prefix                      is 'File prefix which is used by the theme to load additional files like CSS, Javascript and images.';
comment on column apex_application_themes.files_version                    is 'Version counter of the attached theme files.';
comment on column apex_application_themes.last_updated_by                  is 'APEX developer who made last update';
comment on column apex_application_themes.last_updated_on                  is 'Date of last update';
comment on column apex_application_themes.component_signature              is 'Identifies attributes defined at a given component level to facilitate application comparisons';

/

prompt ...apex_application_theme_styles

create or replace view apex_application_theme_styles
as
select s.id                              as theme_style_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       s.theme_id                        as theme_number,
       s.name,
       s.css_file_urls,
       case s.is_current
         when 'Y' then 'Yes'
         else 'No'
       end as is_current,
       case s.is_public
           when 'Y' then 'Yes'
           else 'No'
       end as is_public,
       case s.is_accessible
           when 'Y' then 'Yes'
           else 'No'
       end as is_accessible,
       s.theme_roller_input_file_urls,
       s.theme_roller_config,
       s.theme_roller_output_file_url,
       s.theme_roller_read_only,
       nvl2(s.reference_id, 'Yes', 'No') as is_subscribed,
       ( select s2.flow_id||'. '||s2.name
           from wwv_flow_theme_styles s2
          where s2.id = s.reference_id ) as subscribed_from,
       s.reference_id                    as subscribed_from_id,
       s.component_comment,
       s.created_by,
       s.created_on,
       s.last_updated_by,
       s.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_theme_styles s
 where s.flow_id = f.application_id
/

comment on table apex_application_theme_styles is
    'The Theme Style identifies the CSS file URLs which should be used for a theme';
-- Add comments to the columns
comment on column apex_application_theme_styles.theme_style_id is
    'Identifies the primary key of this component';
comment on column apex_application_theme_styles.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_application_theme_styles.workspace_display_name is
    'Display name for the workspace';
comment on column apex_application_theme_styles.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_application_theme_styles.application_name is
    'Identifies the application';
comment on column apex_application_theme_styles.theme_number is
    'Identifies the theme number associated with this theme style';
comment on column apex_application_theme_styles.name is
    'Contains the name of the theme style.';
comment on column apex_application_theme_styles.css_file_urls is
    'List of URLs which should be loaded for the theme style.';
comment on column apex_application_theme_styles.is_current is
    'Identifies if this theme style is the current one for the theme.';
comment on column apex_application_theme_styles.is_public is
    'Identifies if this theme style can be chosen by end users in the customization dialog.';
comment on column apex_application_theme_styles.is_accessible is
    'Identifies if this theme style is suited for accessible user interfaces.';
comment on column apex_application_theme_styles.theme_roller_input_file_urls is
    'List of URLs that are loaded as input files for the Thene Roller';
comment on column apex_application_theme_styles.theme_roller_config is
    'Theme Roller configuartion key value pairs in JSON format';
comment on column apex_application_theme_styles.theme_roller_output_file_url is
    'Theme Roller generated CSS output file';
comment on column apex_application_theme_styles.theme_roller_read_only is
    'Identified whether Theme Roller allows saving back / overwriting of theme styles';
comment on column apex_application_theme_styles.is_subscribed is
    'Identifies if this theme style is subscribed from another theme style';
comment on column apex_application_theme_styles.subscribed_from is
    'Identifies the master component from which this component is subscribed';
comment on column apex_application_theme_styles.subscribed_from_id is
    'Id the master component from which this component is subscribed';
comment on column apex_application_theme_styles.component_comment is
    'Developer Comment';
comment on column apex_application_theme_styles.created_by is
    'APEX developer who created the theme style';
comment on column apex_application_theme_styles.created_on is
    'Date of creation';
comment on column apex_application_theme_styles.last_updated_by is
    'APEX developer who made last update';
comment on column apex_application_theme_styles.last_updated_on is
    'Date of last update';



prompt ...apex_appl_theme_display_points

create or replace view apex_appl_theme_display_points
as
select d.id                              as theme_display_point_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       d.theme_id                        as theme_number,
       d.name,
       d.placeholder,
       case d.has_grid_support
         when 'Y' then 'Yes'
         else 'No'
       end as has_grid_support,
       d.max_fixed_grid_columns,
       nvl2(d.reference_id, 'Yes', 'No') as is_subscribed,
       ( select d2.flow_id||'. '||d2.name
           from wwv_flow_theme_display_points d2
          where d2.id = d.reference_id ) as subscribed_from,
       d.reference_id                    as subscribed_from_id,
       d.component_comment,
       d.created_by,
       d.created_on,
       d.last_updated_by,
       d.last_updated_on
  from wwv_flow_authorized f,
       WWV_FLOW_THEME_DISPLAY_POINTS d
 where d.flow_id = f.application_id
/

comment on table apex_appl_theme_display_points is
    'The Theme Display Points identify the available display points in page and region templates';
-- Add comments to the columns
comment on column apex_appl_theme_display_points.theme_display_point_id is
    'Identifies the primary key of this component';
comment on column apex_appl_theme_display_points.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_theme_display_points.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_theme_display_points.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_theme_display_points.application_name is
    'Identifies the application';
comment on column apex_appl_theme_display_points.theme_number is
    'Identifies the theme number associated with this display point';
comment on column apex_appl_theme_display_points.name is
    'Contains the name of the display point.';
comment on column apex_appl_theme_display_points.placeholder is
    'Contains the placeholder of the display point in the templates.';
comment on column apex_appl_theme_display_points.has_grid_support is
    'Identifies if grids are supported for this display point.';
comment on column apex_appl_theme_display_points.max_fixed_grid_columns is
    'For a fixed grid it identifies the maximum number of columns which are supported for this display point.';
comment on column apex_appl_theme_display_points.is_subscribed is
    'Identifies if this display point is subscribed from another display point';
comment on column apex_appl_theme_display_points.subscribed_from is
    'Identifies the master component from which this component is subscribed';
comment on column apex_appl_theme_display_points.subscribed_from_id is
    'Id the master component from which this component is subscribed';
comment on column apex_appl_theme_display_points.component_comment is
    'Developer Comment';
comment on column apex_appl_theme_display_points.created_by is
    'APEX developer who created the display point';
comment on column apex_appl_theme_display_points.created_on is
    'Date of creation';
comment on column apex_appl_theme_display_points.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_theme_display_points.last_updated_on is
    'Date of last update';




prompt ...apex_appl_template_opt_groups

create or replace view apex_appl_template_opt_groups
as
select o.id                              as template_opt_group_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       o.theme_id                        as theme_number,
       o.name                            as name,
       o.display_name                    as display_name,
       o.display_sequence                as display_sequence,
       o.template_types                  as template_types,
       o.help_text                       as help_text,
       o.null_text                       as null_text,
       o.is_advanced                     as is_advanced,
       nvl2(o.reference_id, 'Yes', 'No') as is_subscribed,
       ( select o2.flow_id||'. '||o2.name
           from wwv_flow_template_options o2
          where o2.id = o.reference_id ) as subscribed_from,
       o.reference_id                    as subscribed_from_id,
       o.created_by,
       o.created_on,
       o.last_updated_by,
       o.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_template_opt_groups o
 where o.flow_id = f.application_id
/

comment on table apex_appl_template_opt_groups is
    'The Template Option Groups identify groups associated with tempalte options';
-- Add comments to the columns
comment on column apex_appl_template_opt_groups.template_opt_group_id is
    'Identifies the primary key of this component';
comment on column apex_appl_template_opt_groups.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_template_opt_groups.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_template_opt_groups.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_template_opt_groups.application_name is
    'Identifies the application';
comment on column apex_appl_template_opt_groups.theme_number is
    'Identifies the theme number associated with this template option group';
comment on column apex_appl_template_opt_groups.name is
    'Identifies the interal name of with this template option group';
comment on column apex_appl_template_opt_groups.display_name is
    'Identifies the display name of with this template option group';
comment on column apex_appl_template_opt_groups.display_sequence is
    'Identifies the display sequence of with this template option group';
comment on column apex_appl_template_opt_groups.template_types is
    'Identifies the template types associated with this template option group';
comment on column apex_appl_template_opt_groups.help_text is
    'Identifies the help text associated with this template option group';
comment on column apex_appl_template_opt_groups.null_text is
    'Identifies the NULL text associated with this template option group';
comment on column apex_appl_template_opt_groups.is_advanced is
    'Identifies whether this is an advanced template option group';
comment on column apex_appl_template_opt_groups.is_subscribed is
    'Identifies if this template option groupis subscribed from another template option group';
comment on column apex_appl_template_opt_groups.subscribed_from is
    'Identifies the master component from which this component is subscribed';
comment on column apex_appl_template_opt_groups.subscribed_from_id is
    'Id the master component from which this component is subscribed';
comment on column apex_appl_template_opt_groups.created_by is
    'APEX developer who created the template option group';
comment on column apex_appl_template_opt_groups.created_on is
    'Date of creation';
comment on column apex_appl_template_opt_groups.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_template_opt_groups.last_updated_on is
    'Date of last update';



prompt ...apex_appl_template_options

create or replace view apex_appl_template_options
as
select o.id                              as template_option_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       o.theme_id                        as theme_number,
       o.name                            as name,
       o.display_name                    as display_name,
       o.display_sequence                    as display_sequence,
       (select name
          from wwv_flow_templates
         where id = o.page_template_id
           and flow_id = o.flow_id)     as page_template,
       o.page_template_id               as page_template_id,
       (select page_plug_template_name
          from wwv_flow_page_plug_templates
         where id = o.region_template_id
           and flow_id = o.flow_id)      as region_template,
       o.region_template_id              as region_template_id,
       (select row_template_name
          from wwv_flow_row_templates
         where id = o.report_template_id
           and flow_id = o.flow_id)      as report_template,
       o.report_template_id              as report_template_id,
       (select name
          from wwv_flow_menu_templates
         where id = o.breadcrumb_template_id
           and flow_id = o.flow_id)      as breadcrumb_template,
       o.breadcrumb_template_id          as breadcrumb_template_id,
       (select list_template_name
          from wwv_flow_list_templates
         where id = o.list_template_id
           and flow_id = o.flow_id)      as list_template,
       o.list_template_id                as list_template_id,
       (select template_name
          from wwv_flow_field_templates
         where id = o.field_template_id
           and flow_id = o.flow_id)      as field_template,
       o.field_template_id               as field_template_id,
       (select template_name
          from wwv_flow_button_templates
         where id = o.button_template_id
           and flow_id = o.flow_id)      as button_template,
       o.button_template_id              as button_template_id,
       o.virtual_template_type,
       o.virtual_template_id,
       o.css_classes                     as css_classes,
       o.group_id                        as group_id,
       o.help_text                       as help_text,
       o.is_advanced                     as is_advanced,
       o.template_types                  as template_types,
       nvl2(o.reference_id, 'Yes', 'No') as is_subscribed,
       ( select o2.flow_id||'. '||o2.name
           from wwv_flow_template_options o2
          where o2.id = o.reference_id ) as subscribed_from,
       o.reference_id                    as subscribed_from_id,
       o.created_by,
       o.created_on,
       o.last_updated_by,
       o.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_template_options o
 where o.flow_id = f.application_id
/

comment on table apex_appl_template_options is
    'The Template Options identify available CSS classes for pages, regions, report, breadcrumbs, lists, items and buttons';
-- Add comments to the columns
comment on column apex_appl_template_options.template_option_id is
    'Identifies the primary key of this component';
comment on column apex_appl_template_options.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_template_options.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_template_options.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_template_options.application_name is
    'Identifies the application';
comment on column apex_appl_template_options.theme_number is
    'Identifies the theme number associated with this template option';
comment on column apex_appl_template_options.name is
    'Identifies the interal name of with this template option';
comment on column apex_appl_template_options.display_name is
    'Identifies the display name of with this template option';
comment on column apex_appl_template_options.display_sequence is
    'Identifies the display sequece of with this template option';
comment on column apex_appl_template_options.page_template is
    'Identifies the page template associated with this template option';
comment on column apex_appl_template_options.page_template_id is
    'Identifies the page template ID associated with this template option';
comment on column apex_appl_template_options.region_template is
    'Identifies the region template associated with this template option';
comment on column apex_appl_template_options.region_template_id is
    'Identifies the region template ID associated with this template option';
comment on column apex_appl_template_options.report_template is
    'Identifies the report template associated with this template option';
comment on column apex_appl_template_options.report_template_id is
    'Identifies the report template ID associated with this template option';
comment on column apex_appl_template_options.breadcrumb_template is
    'Identifies the breadcrumb template associated with this template option';
comment on column apex_appl_template_options.breadcrumb_template_id is
    'Identifies the breadcrumb template ID associated with this template option';
comment on column apex_appl_template_options.list_template is
    'Identifies the list template associated with this template option';
comment on column apex_appl_template_options.list_template_id is
    'Identifies the list template ID associated with this template option';
comment on column apex_appl_template_options.field_template is
    'Identifies the field template associated with this template option';
comment on column apex_appl_template_options.field_template_id is
    'Identifies the field template ID associated with this template option';
comment on column apex_appl_template_options.button_template is
    'Identifies the button template associated with this template option';
comment on column apex_appl_template_options.button_template_id is
    'Identifies the button template ID associated with this template option';
comment on column apex_appl_template_options.virtual_template_type is
    'Identifies the template type associated with this template option';
comment on column apex_appl_template_options.virtual_template_id is
    'Identifies the template ID associated with this template option';
comment on column apex_appl_template_options.css_classes is
    'Identifies the CSS classes associated with this template option';
comment on column apex_appl_template_options.group_id is
    'Identifies the template option group associated with this template option';
comment on column apex_appl_template_options.template_types is
    'Identifies the template types associated with this template option';
comment on column apex_appl_template_options.help_text is
    'Identifies the help text associated with this template option';
comment on column apex_appl_template_options.is_advanced is
    'Identifies whether this is an advanced template option';
comment on column apex_appl_template_options.is_subscribed is
    'Identifies if this template option is subscribed from another template option';
comment on column apex_appl_template_options.subscribed_from is
    'Identifies the master component from which this component is subscribed';
comment on column apex_appl_template_options.subscribed_from_id is
    'Id the master component from which this component is subscribed';
comment on column apex_appl_template_options.created_by is
    'APEX developer who created the template option';
comment on column apex_appl_template_options.created_on is
    'Date of creation';
comment on column apex_appl_template_options.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_template_options.last_updated_on is
    'Date of last update';



create or replace view apex_application_theme_files
as
select a.id                              as theme_file_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       a.theme_id                        as theme_number,
       a.file_name,
       a.mime_type,
       a.file_charset,
       a.file_content,
       nvl2(a.reference_id, 'Yes', 'No') as is_subscribed,
       ( select a2.flow_id||'. '||a2.file_name
           from wwv_flow_theme_files a2
          where a2.id = a.reference_id ) as subscribed_from,
       a.reference_id                    as subscribed_from_id,
       a.created_by,
       a.created_on,
       a.last_updated_by,
       a.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_theme_files a
 where a.flow_id = f.application_id
/


comment on table apex_application_theme_files is
    'Stores the files like CSS, images, javascript files, ... of a theme.';
-- Add comments to the columns
comment on column apex_application_theme_files.theme_file_id is
    'Identifies the primary key of this component';
comment on column apex_application_theme_files.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_application_theme_files.workspace_display_name is
    'Display name for the workspace';
comment on column apex_application_theme_files.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_application_theme_files.application_name is
    'Identifies the application';
comment on column apex_application_theme_files.theme_number is
    'Identifies the theme number associated with this theme style';
comment on column apex_application_theme_files.file_name is
    'Name of the file.';
comment on column apex_application_theme_files.mime_type is
    'Mime type of the file.';
comment on column apex_application_theme_files.file_charset is
    'IANA charset used for text files.';
comment on column apex_application_theme_files.file_content is
    'Blob content of the file.';
comment on column apex_application_theme_files.is_subscribed is
    'Identifies if this theme style is subscribed from another theme style';
comment on column apex_application_theme_files.subscribed_from is
    'Identifies the master component from which this component is subscribed';
comment on column apex_application_theme_files.subscribed_from_id is
    'Id the master component from which this component is subscribed';
comment on column apex_application_theme_files.created_by is
    'APEX developer who created the file';
comment on column apex_application_theme_files.created_on is
    'Date of creation';
comment on column apex_application_theme_files.last_updated_by is
    'APEX developer who made last update';
comment on column apex_application_theme_files.last_updated_on is
    'Date of last update';


---------------------------------------------------------
-- A P P L I C A T I O N   T E M P L A T E S
--
prompt ...apex_application_templates

create or replace view apex_application_temp_page
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.NAME                           template_name,
    t.INTERNAL_NAME                  internal_name,
    --t.LOOK
    --
    t.is_popup,
    t.javascript_file_urls,
    t.javascript_code,
    t.javascript_code_onload,
    t.dialog_js_init_code,
    t.dialog_js_close_code,
    t.dialog_js_cancel_code,
    t.css_file_urls,
    t.inline_css,
    t.HEADER_TEMPLATE                ,
    t.BOX                            page_body,
    t.FOOTER_TEMPLATE                ,
    --
    t.SUCCESS_MESSAGE                ,
    t.CURRENT_TAB                    ,
    t.CURRENT_TAB_FONT_ATTR          ,
    t.NON_CURRENT_TAB                ,
    t.NON_CURRENT_TAB_FONT_ATTR      ,
    t.CURRENT_IMAGE_TAB              ,
    t.NON_CURRENT_IMAGE_TAB          ,
    t.TOP_CURRENT_TAB                Current_Parent_Tab,
    t.TOP_CURRENT_TAB_FONT_ATTR      Current_Parent_Tab_attr,
    t.TOP_NON_CURRENT_TAB            NonCurrent_Parent_Tab,
    t.TOP_NON_CURRENT_TAB_FONT_ATTR  NonCurrent_Parent_Tab_attr,
    --
    t.NAVIGATION_BAR                 ,
    t.NAVBAR_ENTRY                   ,
    --t.BODY_TITLE                     ,
    t.MESSAGE                        ,
    --t.ATTRIBUTE1                     ,
    --t.ATTRIBUTE2                     ,
    --t.ATTRIBUTE3                     ,
    --t.ATTRIBUTE4                     ,
    --t.ATTRIBUTE5                     ,
    --t.ATTRIBUTE6                     ,
    --t.DEFAULT_BUTTON_POSITION        ,
    --t.TABLE_BGCOLOR                  ,
    --t.HEADING_BGCOLOR                ,
    --t.TABLE_CATTRIBUTES              ,
    --t.FONT_SIZE                      ,
    --t.FONT_FACE                      ,
    case t.grid_type
      when 'TABLE'    then 'Table'
      when 'FIXED'    then 'Fixed'
      when 'VARIABLE' then 'Variable'
    end                               as grid_type,
    t.grid_type                       as grid_type_code,
    t.grid_max_columns,
    case t.grid_always_use_max_columns
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end                               as grid_always_use_max_columns,
    case t.grid_has_column_span
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end                               as grid_has_column_span,
    case t.grid_always_emit
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end                               as grid_always_emit,
    case t.grid_emit_empty_leading_cols
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end                               as grid_emit_empty_leading_cols,
    case t.grid_emit_empty_trailing_cols
      when 'Y' then 'Yes'
      when 'N' then 'No'
    end                               as grid_emit_empty_trailing_cols,
    t.grid_default_label_col_span,
    t.grid_template,
    t.grid_row_template,
    t.grid_column_template,
    t.grid_first_column_attributes,
    t.grid_last_column_attributes,
    t.grid_javascript_debug_code,
    t.dialog_height,
    t.dialog_width,
    t.dialog_max_width,
    t.dialog_css_classes,
    t.dialog_browser_frame,
    t.REGION_TABLE_CATTRIBUTES        as grid_table_attributes,
    t.REGION_TABLE_CATTRIBUTES        as MultiColumn_Region_Table_Attr, /* for backward compatibility */
    --
    --t.APP_TAB_BEFORE_TABS            ,
    --t.APP_TAB_CURRENT_TAB            ,
    --t.APP_TAB_NON_CURRENT_TAB        ,
    --t.APP_TAB_AFTER_TABS             ,
    --
    'Y'                              as has_edit_links,
    --
    t.ERROR_PAGE_TEMPLATE            ,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from wwv_flow_templates
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    --t.BREADCRUMB_DEF_REG_POS         ,
    --t.SIDEBAR_DEF_REG_POS            ,
    --t.REQUIRED_PATCH                 ,
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
      '1', 'One Level Tabs',
      '2', 'Two Level Tabs',
      '3', 'No Tabs',
      '4', 'Popup',
      '5', 'Printer Friendly',
      '6', 'Login',
      '7', 'Unknown',
      '8',  'Custom 1',
      '9',  'Custom 2',
      '10', 'Custom 3',
      '11', 'Custom 4',
      '12', 'Custom 5',
      '13', 'Custom 6',
      '14', 'Custom 7',
      '15', 'Custom 8',
      '16', 'One Level Tabs with Sidebar',
      '17', 'No Tabs with Sidebar',
      '18', 'Two Level Tabs with Sidebar',
      t.THEME_CLASS_ID)              theme_class,
    t.default_template_options       default_template_options,
    t.preset_template_options        preset_template_options,
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    decode(
       t.TRANSLATE_THIS_TEMPLATE,
       'N','No','Y','Yes','Yes')     translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             template_id,
    t.id                             page_template_id,
    --
    substr(t.NAME,1,40)||'.'||length(t.NAME)
    ||' h='||sys.dbms_lob.substr(t.HEADER_TEMPLATE                  ,40,1)||'.'||sys.dbms_lob.getlength(t.HEADER_TEMPLATE                )
    ||' b='||sys.dbms_lob.substr(t.BOX                              ,40,1)||'.'||sys.dbms_lob.getlength(t.BOX                            )
    ||' f='||sys.dbms_lob.substr(t.FOOTER_TEMPLATE                  ,40,1)||'.'||sys.dbms_lob.getlength(t.FOOTER_TEMPLATE                )
    ||' s='||substr(t.SUCCESS_MESSAGE                  ,1,40)||'.'||length(t.SUCCESS_MESSAGE                )
    ||' t='||substr(t.CURRENT_TAB                      ,1,40)||'.'||length(t.CURRENT_TAB                    )
    ||' t='||substr(t.CURRENT_TAB_FONT_ATTR            ,1,40)||'.'||length(t.CURRENT_TAB_FONT_ATTR          )
    ||' n='||substr(t.NON_CURRENT_TAB                  ,1,40)||'.'||length(t.NON_CURRENT_TAB                )
    ||' n='||substr(t.NON_CURRENT_TAB_FONT_ATTR        ,1,40)||'.'||length(t.NON_CURRENT_TAB_FONT_ATTR      )
    ||' i='||substr(t.CURRENT_IMAGE_TAB                ,1,40)||'.'||length(t.CURRENT_IMAGE_TAB              )
    ||' i='||substr(t.NON_CURRENT_IMAGE_TAB            ,1,40)||'.'||length(t.NON_CURRENT_IMAGE_TAB          )
    ||' t='||substr(t.TOP_CURRENT_TAB                  ,1,40)||'.'||length(t.TOP_CURRENT_TAB                )
    ||' t='||substr(t.TOP_CURRENT_TAB_FONT_ATTR        ,1,40)||'.'||length(t.TOP_CURRENT_TAB_FONT_ATTR      )
    ||' t='||substr(t.TOP_NON_CURRENT_TAB              ,1,40)||'.'||length(t.TOP_NON_CURRENT_TAB            )
    ||' t='||substr(t.TOP_NON_CURRENT_TAB_FONT_ATTR    ,1,40)||'.'||length(t.TOP_NON_CURRENT_TAB_FONT_ATTR  )
    ||' n='||substr(t.NAVIGATION_BAR                   ,1,40)||'.'||length(t.NAVIGATION_BAR                 )
    ||' n='||substr(t.NAVBAR_ENTRY                     ,1,40)||'.'||length(t.NAVBAR_ENTRY                   )
    ||' m='||substr(t.MESSAGE                          ,1,40)||'.'||length(t.MESSAGE                        )
    ||' e='||substr(t.ERROR_PAGE_TEMPLATE              ,1,40)||'.'||length(t.ERROR_PAGE_TEMPLATE            )
    --
    ||' s='||decode(t.REFERENCE_ID,null,'No','Yes')
    ||' t='||t.THEME_ID
    ||' c='||decode(t.THEME_CLASS_ID,
      '1', 'One Level Tabs',
      '2', 'Two Level Tabs',
      '3', 'No Tabs',
      '4', 'Popup',
      '5', 'Printer Friendly',
      '6', 'Login',
      '7', 'Unknown',
      '8',  'Custom 1',
      '9',  'Custom 2',
      '10', 'Custom 3',
      '11', 'Custom 4',
      '12', 'Custom 5',
      '13', 'Custom 6',
      '14', 'Custom 7',
      '15', 'Custom 8',
      '16', 'One Level Tabs with Sidebar',
      '17', 'No Tabs with Sidebar',
      '18', 'Two Level Tabs with Sidebar',
      t.THEME_CLASS_ID)
    ||' t='||t.TRANSLATE_THIS_TEMPLATE
    component_signature
from wwv_flow_templates  t,
     wwv_flow_authorized f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_page                                is 'The Page Template which identifies the HTML used to organized and render a page content';
comment on column apex_application_temp_page.workspace                      is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_page.workspace_display_name         is 'Display name for the workspace';
comment on column apex_application_temp_page.application_id                 is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_page.application_name               is 'Identifies the application';
comment on column apex_application_temp_page.THEME_number                   is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_page.TEMPLATE_NAME                  is 'Name of the Page Template';
comment on column apex_application_temp_page.INTERNAL_NAME                  is 'Internal name of the Page Template';
comment on column apex_application_temp_page.javascript_code                is 'Identifies JavaScript code that replaces the #TEMPLATE_JAVASCRIPT# substitution string in the Page Template';
comment on column apex_application_temp_page.javascript_code_onload         is 'Identifies JavaScript code which is executed after page load';
comment on column apex_application_temp_page.HEADER_TEMPLATE                is 'In the Header is the first of 3 parts of the page template.  Enter the HTML that makes up the HEAD section of the HTML document.  That is, all the required HTML tags before the BODY of the HTML document.';
comment on column apex_application_temp_page.page_body                      is 'The Body is the second of 3 parts of the page template.  Enter HTML that makes up the BODY of the HTML document.';
comment on column apex_application_temp_page.FOOTER_TEMPLATE                is 'The Footer is the third template and displays after the body.';
comment on column apex_application_temp_page.SUCCESS_MESSAGE                is 'Enter HTML that will substitute the string #SUCCESS_MESSAGE# in the template body';
comment on column apex_application_temp_page.CURRENT_TAB                    is 'Enter HTML or text that will be substituted for the currently selected standard tab, use #TAB_LINK#" and #TAB_LABEL# substitutions.';
comment on column apex_application_temp_page.CURRENT_TAB_FONT_ATTR          is 'This attribute is part of the Standard Tab subtemplate.  This value replaces the #TAB_FONT_ATTRIBUTES# substitution string.';
comment on column apex_application_temp_page.NON_CURRENT_TAB                is 'HTML or text that will be substituted for the unselected standard tabs, use #TAB_LINK#" and #TAB_LABEL# substitutions';
comment on column apex_application_temp_page.NON_CURRENT_TAB_FONT_ATTR      is 'This attribute is part of the Parent Tab subtemplate and expands the #PARENT_TAB_CELLS# substitution string.';
comment on column apex_application_temp_page.CURRENT_IMAGE_TAB              is 'HTML to be used to indicate that an image-based tab is currently selected';
comment on column apex_application_temp_page.NON_CURRENT_IMAGE_TAB          is 'HTML to be used to indicate that an image-based tab is not currently selected';
comment on column apex_application_temp_page.Current_Parent_Tab             is 'HTML or text that will be substituted for the selected parent tabs';
comment on column apex_application_temp_page.Current_Parent_Tab_ATTR        is 'This value replaces the #TAB_FONT_ATTRIBUTES# substitution string';
comment on column apex_application_temp_page.NonCurrent_Parent_Tab          is 'HTML or text that will be substituted for the unselected standard tabs, use #TAB_LINK# and #TAB_LABEL# substitutions';
comment on column apex_application_temp_page.NonCurrent_Parent_Tab_ATTR     is 'This value replaces the #TAB_FONT_ATTRIBUTES# substitution string';
comment on column apex_application_temp_page.NAVIGATION_BAR                 is 'HTML or text that will be substituted when the string #NAVIGATION_BAR# is referenced in the template header, body or footer';
comment on column apex_application_temp_page.NAVBAR_ENTRY                   is 'HTML or text that will be substituted into the navigation bar #BAR_BODY# for each navigation bar entry';
comment on column apex_application_temp_page.MESSAGE                        is 'HTML or text that will be substituted when the string #NOTIFICATION_MESSAGE# is referenced in the template header, body or footer';
comment on column apex_application_temp_page.ERROR_PAGE_TEMPLATE            is 'Used only when this page template will be designated as an error template.  Use #MESSAGE# to place the error message and #BACK_LINK# to display a link back to the previous page.';
comment on column apex_application_temp_page.grid_type is
    'Identifies the type of grid template';
comment on column apex_application_temp_page.grid_type_code is
    'Internal code of TYPE.';
comment on column apex_application_temp_page.grid_max_columns is
    'Identifies the maximum number of columns the grid can have.';
comment on column apex_application_temp_page.grid_always_use_max_columns is
    'Identifies if the maximum number of columns should always be used from the template definition.';
comment on column apex_application_temp_page.grid_has_column_span is
    'Identifies if the grid supports specifying a column span.';
comment on column apex_application_temp_page.grid_always_emit is
    'Identifies if the grid should always be rendered, even if only the first column of the grid is used.';
comment on column apex_application_temp_page.grid_emit_empty_leading_cols is
    'Identifies if the grid should emit empty leading grid column before a fixed positioned grid column.';
comment on column apex_application_temp_page.grid_emit_empty_trailing_cols is
    'Identifies if the grid should emit empty trailing grid column to fill up the maximum available grid columns.';
comment on column apex_application_temp_page.grid_default_label_col_span is
    'Identifies over how many grid columns the label spans if not specified on item level.';
comment on column apex_application_temp_page.grid_template is
    'HTML that will be used for the grid.';
comment on column apex_application_temp_page.grid_row_template is
    'HTML that will be used for a grid row.';
comment on column apex_application_temp_page.grid_column_template is
    'HTML that will be used for a grid column.';
comment on column apex_application_temp_page.grid_first_column_attributes is
    'Identifies the attributes which should be substituted for #FIRST_LAST_COLUMN_ATTRIBUTES# if it''s the first grid column.';
comment on column apex_application_temp_page.grid_last_column_attributes is
    'Identifies the attributes which should be substituted for #FIRST_LAST_COLUMN_ATTRIBUTES# if it''s the last grid column.';
comment on column apex_application_temp_page.grid_javascript_debug_code is
    'JavaScript code that can be used to toggle on/off a debug mode for grid layouts.';
comment on column apex_application_temp_page.grid_table_attributes is
    'This attribute controls the attributes of the HTML table tag used to display regions in multiple columns.';
comment on column apex_application_temp_page.dialog_js_init_code            is 'Identifies JavaScript code which is executed to initialize a dialog page';
comment on column apex_application_temp_page.dialog_js_close_code           is 'Identifies JavaScript code which is executed to close a dialog page';
comment on column apex_application_temp_page.dialog_js_cancel_code          is 'Identifies JavaScript code which is executed to cancel a dialog page';
comment on column apex_application_temp_page.dialog_height                  is 'The template level default height setting for a dialog';
comment on column apex_application_temp_page.dialog_width                   is 'The template level default width setting for a dialog';
comment on column apex_application_temp_page.dialog_max_width               is 'The template level default maximum width setting for a dialog';
comment on column apex_application_temp_page.dialog_css_classes             is 'The template level default CSS classes setting for a dialog';
comment on column apex_application_temp_page.dialog_browser_frame           is 'The template level setting to control if the browser is allowed to display the application Modal and Non-Modal dialog with a frame';
comment on column apex_application_temp_page.has_edit_links is
    'Deprecated';
comment on column apex_application_temp_page.THEME_NUMBER                   is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_page.THEME_CLASS                    is 'Identifies a specific usage for this template';
comment on column apex_application_temp_page.default_template_options       is 'Identifies the default template options selected for this template';
comment on column apex_application_temp_page.preset_template_options        is 'Identifies the preset template options selected for this template';
comment on column apex_application_temp_page.TRANSLATABLE                   is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_page.COMPONENT_COMMENT              is 'Developer comment';
comment on column apex_application_temp_page.IS_SUBSCRIBED                  is 'Identifies if this template is subscribed from another template';
comment on column apex_application_temp_page.SUBSCRIBED_FROM                is 'Identifies the Application ID and Template Name this template is subscribed from';
comment on column apex_application_temp_page.TEMPLATE_ID                    is 'Primary Key of this Page Template (deprecated column)';
comment on column apex_application_temp_page.PAGE_TEMPLATE_ID               is 'Primary Key of this Page Template';
comment on column apex_application_temp_page.last_updated_by                is 'APEX developer who made last update';
comment on column apex_application_temp_page.last_updated_on                is 'Date of last update';
comment on column apex_application_temp_page.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_temp_page.MultiColumn_Region_Table_Attr  is 'This attribute controls the attributes of the HTML table tag used to display regions in multiple columns.';




prompt ...apex_appl_temp_page_dp

create or replace view apex_appl_temp_page_dp
as
select d.id                      as page_tmpl_display_point_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       d.page_template_id        as page_template_id,
       d.name,
       d.placeholder,
       case d.has_grid_support
         when 'Y' then 'Yes'
         else 'No'
       end as has_grid_support,
       case d.glv_new_row
         when 'Y' then 'Yes'
         else 'No'
       end as glv_new_row,
       d.max_fixed_grid_columns,
       d.component_comment,
       d.created_by,
       d.created_on,
       d.last_updated_by,
       d.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_page_tmpl_disp_points d
 where d.flow_id = f.application_id
/

comment on table apex_appl_temp_page_dp is
    'The Page Template Display Points identify the available display points in a page template';
-- Add comments to the columns
comment on column apex_appl_temp_page_dp.page_tmpl_display_point_id is
    'Identifies the primary key of this component';
comment on column apex_appl_temp_page_dp.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_temp_page_dp.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_temp_page_dp.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_temp_page_dp.application_name is
    'Identifies the application';
comment on column apex_appl_temp_page_dp.name is
    'Contains the name of the display point.';
comment on column apex_appl_temp_page_dp.placeholder is
    'Contains the placeholder of the display point in the templates.';
comment on column apex_appl_temp_page_dp.has_grid_support is
    'Identifies if grids are supported for this display point.';
comment on column apex_appl_temp_page_dp.glv_new_row is
    'Identifies the position for this display point.';
comment on column apex_appl_temp_page_dp.max_fixed_grid_columns is
    'For a fixed grid it identifies the maximum number of columns which are supported for this display point.';
comment on column apex_appl_temp_page_dp.component_comment is
    'Developer Comment';
comment on column apex_appl_temp_page_dp.created_by is
    'APEX developer who created the display point';
comment on column apex_appl_temp_page_dp.created_on is
    'Date of creation';
comment on column apex_appl_temp_page_dp.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_temp_page_dp.last_updated_on is
    'Date of last update';




create or replace view apex_application_temp_region
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.PAGE_PLUG_TEMPLATE_NAME        template_name,
    t.INTERNAL_NAME                  internal_name,
    --
    t.JAVASCRIPT_FILE_URLS           javascript_file_urls,
    t.JAVASCRIPT_CODE_ONLOAD         javascript_code_onload,
    t.CSS_FILE_URLS                  css_file_urls,
    --
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
        'RETURN_VALUE','DISPLAY_VALUE',
        '1','Hide and Show Region',
        '2','Sidebar Region',
        '3','Sidebar Region, Alternative 1',
        '4','Button Region with Title',
        '5','Navigation Region',
        '6','Breadcrumb Region',
        '7','Borderless Region',
        '8','Form Region',
        '9','Reports Region',
        '10','Reports Region, Alternative 1',
        '11','Region without Title',
        '12','Wizard Region',
        '13','Reports Region 100% Width',
        '16','Navigation Region, Alternative 1',
        '17','Button Region without Title',
        '18','Bracketed Region',
        '19','Region without Buttons and Title',
        '20','Wizard Region with Icon',
        '21','Custom 1',
        '22','Custom 2',
        '23','Custom 3',
        '24','Custom 4',
        '25','Custom 5',
        '26','Custom 6',
        '27','Custom 7',
        '28','Custom 8',
        '29','List Region with Icon',
        '30','Chart Region',
        t.theme_class_id)            theme_class,
    t.default_template_options       default_template_options,
    t.preset_template_options        preset_template_options,
    --
    t.layout,
    t.template,
    t.template2,
    t.template3,
    t.sub_plug_header_template       as sub_region_header_template,
    t.sub_plug_header_entry_template as sub_region_header_entry_templ,
    t.sub_plug_template              as sub_region_template,
    t.plug_table_bgcolor,
    t.plug_heading_bgcolor,
    t.plug_font_size,
    t.default_field_template_id,
    t.default_req_field_template_id,
    t.default_label_alignment,
    t.default_field_alignment,
    t.default_button_template_id,
    t.default_button_position,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||internal_name
     from WWV_FLOW_PAGE_PLUG_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'N','No','Y','Yes','Yes')      translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             region_template_id,
    --
    t.PAGE_PLUG_TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||THEME_CLASS_ID
    ||' 1='||sys.dbms_lob.substr(t.TEMPLATE,40,1)||'.'||sys.dbms_lob.getlength(t.TEMPLATE)
    ||' 2='||sys.dbms_lob.substr(t.TEMPLATE2,40,1)||'.'||sys.dbms_lob.getlength(t.TEMPLATE2)
    ||' 3='||sys.dbms_lob.substr(t.TEMPLATE3,40,1)||'.'||sys.dbms_lob.getlength(t.TEMPLATE3)
    ||' b='||substr(t.PLUG_TABLE_BGCOLOR,1,20)
    ||' b='||substr(t.PLUG_HEADING_BGCOLOR,1,20)
    ||' f='||substr(t.PLUG_FONT_SIZE,1,20)
    ||' t='||TRANSLATE_THIS_TEMPLATE
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    component_signature
from WWV_FLOW_PAGE_PLUG_TEMPLATES t,
     wwv_flow_authorized          f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_region                               is 'Identifies a regions HTML template display attributes';
comment on column apex_application_temp_region.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_region.workspace_display_name        is 'Display name for the workspace';
comment on column apex_application_temp_region.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_region.application_name              is 'Identifies the application';
comment on column apex_application_temp_region.TEMPLATE_NAME                 is 'Identifies the region template';
comment on column apex_application_temp_region.INTERNAL_NAME                 is 'Internal name of the region template';
comment on column apex_application_temp_region.javascript_file_urls          is 'Allows definition of JavaScript file URLs that will be loaded on every page in the application.';
comment on column apex_application_temp_region.javascript_code_onload        is 'Identifies JavaScript code which is executed after page load';
comment on column apex_application_temp_region.css_file_urls                 is 'List of URLs which should be loaded for the list style.';
comment on column apex_application_temp_region.THEME_NUMBER                  is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_region.THEME_CLASS                   is 'Identifies a specific usage for this template';
comment on column apex_application_temp_region.default_template_options      is 'Identifies the default template option selected for this template';
comment on column apex_application_temp_region.preset_template_options       is 'Identifies the preset template option selected for this template';
comment on column apex_application_temp_region.TEMPLATE                      is 'HTML that defined the appearance for a page region';
comment on column apex_application_temp_region.sub_region_header_template    is 'HTML that defined the appearance of a sub region header';
comment on column apex_application_temp_region.sub_region_header_entry_templ is 'HTML that defined the appearance of a single sub region header entry';
comment on column apex_application_temp_region.sub_region_template           is 'HTML that defined the appearance of a sub region';
comment on column apex_application_temp_region.TEMPLATE2                     is '';
comment on column apex_application_temp_region.TEMPLATE3                     is '';
comment on column apex_application_temp_region.PLUG_TABLE_BGCOLOR            is '';
comment on column apex_application_temp_region.PLUG_HEADING_BGCOLOR          is '';
comment on column apex_application_temp_region.PLUG_FONT_SIZE                is '';
comment on column apex_application_temp_region.is_subscribed                 is 'Identifies if this Region Template is subscribed from another Region Template';
comment on column apex_application_temp_region.subscribed_from               is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_region.LAST_UPDATED_BY               is 'APEX Developer User Name who last updated this component';
comment on column apex_application_temp_region.LAST_UPDATED_ON               is 'Date this component was last updated';
comment on column apex_application_temp_region.TRANSLATABLE                  is 'Identifies if this component is to be included in the list of translatable components';
comment on column apex_application_temp_region.COMPONENT_COMMENT             is 'Developer comment';
comment on column apex_application_temp_region.last_updated_by               is 'APEX developer who made last update';
comment on column apex_application_temp_region.last_updated_on               is 'Date of last update';
comment on column apex_application_temp_region.region_template_id            is 'Primary Key of this Region Template';
comment on column apex_application_temp_region.component_signature           is 'Identifies attributes defined at a given component level to facilitate application comparisons';



prompt ...apex_appl_temp_region_dp

create or replace view apex_appl_temp_region_dp
as
select d.id                      as region_tmpl_display_point_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       d.plug_template_id        as region_template_id,
       d.name,
       d.placeholder,
       case d.has_grid_support
         when 'Y' then 'Yes'
         else 'No'
       end as has_grid_support,
       case d.glv_new_row
         when 'Y' then 'Yes'
         else 'No'
       end as glv_new_row,
       d.max_fixed_grid_columns,
       d.component_comment,
       d.created_by,
       d.created_on,
       d.last_updated_by,
       d.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_plug_tmpl_disp_points d
 where d.flow_id = f.application_id
/

comment on table apex_appl_temp_region_dp is
    'The Region Template Display Points identify the available display points in a region template';
-- Add comments to the columns
comment on column apex_appl_temp_region_dp.region_tmpl_display_point_id is
    'Identifies the primary key of this component';
comment on column apex_appl_temp_region_dp.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_temp_region_dp.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_temp_region_dp.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_temp_region_dp.application_name is
    'Identifies the application';
comment on column apex_appl_temp_region_dp.name is
    'Contains the name of the display point.';
comment on column apex_appl_temp_region_dp.placeholder is
    'Contains the placeholder of the display point in the templates.';
comment on column apex_appl_temp_region_dp.has_grid_support is
    'Identifies if grids are supported for this display point.';
comment on column apex_appl_temp_region_dp.glv_new_row is
    'Identifies the position for this display point.';
comment on column apex_appl_temp_region_dp.max_fixed_grid_columns is
    'For a fixed grid it identifies the maximum number of columns which are supported for this display point.';
comment on column apex_appl_temp_region_dp.component_comment is
    'Developer Comment';
comment on column apex_appl_temp_region_dp.created_by is
    'APEX developer who created the display point';
comment on column apex_appl_temp_region_dp.created_on is
    'Date of creation';
comment on column apex_appl_temp_region_dp.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_temp_region_dp.last_updated_on is
    'Date of last update';




create or replace view apex_application_temp_label
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
      '1','Optional Label with Help',
      '2','Required Label with Help',
      '3','Optional Label',
      '4','Required Label',
      '5','Custom 1',
      '6','Custom 2',
      '7','Custom 3',
      '8','Custom 4',
      '9','Custom 5',
      '10','Custom 6',
      '11','Custom 7',
      '12','Custom 8',
      '13','No Label',
      t.THEME_CLASS_ID)              theme_class,
    t.default_template_options       default_template_options,
    t.preset_template_options        preset_template_options,
    --
    t.TEMPLATE_NAME                  template_name,
    t.INTERNAL_NAME                  internal_name,
    t.TEMPLATE_BODY1                 before_label,
    t.TEMPLATE_BODY2                 after_label,
    --
    t.BEFORE_ITEM                    before_item,
    t.AFTER_ITEM                     after_item,
    --
    t.item_pre_text                  item_pre_text,
    t.item_post_text                 item_post_text,
    --
    t.BEFORE_ELEMENT                 before_element,
    t.AFTER_ELEMENT                  after_element,
    t.HELP_LINK                      help_link,
    t.INLINE_HELP_TEXT               inline_help_text,
    t.ERROR_TEMPLATE                 error_template,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||internal_name
     from WWV_FLOW_FIELD_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.ON_ERROR_BEFORE_LABEL,
    t.ON_ERROR_AFTER_LABEL,
    t.LAST_UPDATED_ON                last_updated_on,
    t.LAST_UPDATED_BY                last_updated_by,
    t.TRANSLATE_THIS_TEMPLATE        ,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             label_template_id,
    --
    t.TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' 1='||substr(t.TEMPLATE_BODY1,1,40)||length(t.TEMPLATE_BODY1)
    ||' 2='||substr(t.TEMPLATE_BODY2,1,40)||length(t.TEMPLATE_BODY2)
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    ||' e='||substr(t.ON_ERROR_BEFORE_LABEL,1,40)||length(t.ON_ERROR_BEFORE_LABEL)
    ||' e='||substr(t.ON_ERROR_AFTER_LABEL,1,40)||length(t.ON_ERROR_AFTER_LABEL)
    ||' t='||t.TRANSLATE_THIS_TEMPLATE
    component_signature
from WWV_FLOW_FIELD_TEMPLATES t,
     wwv_flow_authorized      f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_label                         is 'Identifies a Page Item Label HTML template display attributes';
comment on column apex_application_temp_label.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_label.workspace_display_name  is 'Display name for the workspace';
comment on column apex_application_temp_label.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_label.application_name        is 'Identifies the application';
comment on column apex_application_temp_label.THEME_NUMBER            is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_label.THEME_CLASS             is 'Identifies a specific usage for this template';
comment on column apex_application_temp_label.default_template_options is 'Identifies the default template option selected for this template';
comment on column apex_application_temp_label.preset_template_options  is 'Identifies the preset template option selected for this template';
comment on column apex_application_temp_label.TEMPLATE_NAME           is 'Identifies the name of this item label template';
comment on column apex_application_temp_label.INTERNAL_NAME           is 'Internal name of the item label template';
comment on column apex_application_temp_label.before_label            is 'HTML to be displayed before an item label';
comment on column apex_application_temp_label.after_label             is 'HTML to be displayed after an item label';
comment on column apex_application_temp_label.before_item             is 'HTML field container to be displayed before label and item ';
comment on column apex_application_temp_label.after_item              is 'HTML field container to be displayed after label and item ';
comment on column apex_application_temp_label.item_pre_text           is 'HTML subtemplate to format "Item Pre Text" display ';
comment on column apex_application_temp_label.item_post_text          is 'HTML subtemplate to format "Item Post Text" display ';
comment on column apex_application_temp_label.before_element          is 'HTML to be displayed before item ';
comment on column apex_application_temp_label.after_element           is 'HTML to be displayed after item ';
comment on column apex_application_temp_label.help_link               is 'HTML to be displayed where #HELP_LINK# substitution string is defined ';
comment on column apex_application_temp_label.inline_help_text        is 'HTML to be displayed where #INLINE_HELP_TEXT# substitution string is defined ';
comment on column apex_application_temp_label.error_template          is 'HTML to be displayed where #ERROR_MESSAGE# substitution string is defined and error has occured';
comment on column apex_application_temp_label.is_subscribed           is 'Identifies if this Item Label Template is subscribed from another Item Label Template';
comment on column apex_application_temp_label.subscribed_from         is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_label.ON_ERROR_BEFORE_LABEL   is 'HTML to precede the item label when a application displays an inline validation error message for the item';
comment on column apex_application_temp_label.ON_ERROR_AFTER_LABEL    is 'HTML to be appended to the item label when a application  displays an inline validation error message for the item';
comment on column apex_application_temp_label.TRANSLATE_THIS_TEMPLATE is 'Identifies if this template should be translated';
comment on column apex_application_temp_label.COMPONENT_COMMENT       is 'Developer comment';
comment on column apex_application_temp_label.label_template_id       is 'Primary Key of this Item Label Template';
comment on column apex_application_temp_label.last_updated_by         is 'APEX developer who made last update';
comment on column apex_application_temp_label.last_updated_on         is 'Date of last update';
comment on column apex_application_temp_label.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';



create or replace view apex_application_temp_list
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.LIST_TEMPLATE_NAME             template_name,
    t.INTERNAL_NAME                  internal_name,
    --
    t.JAVASCRIPT_FILE_URLS           javascript_file_urls,
    t.JAVASCRIPT_CODE_ONLOAD         javascript_code_onload,
    t.CSS_FILE_URLS                  css_file_urls,
    t.INLINE_CSS                     inline_css,
    --
    t.LIST_TEMPLATE_CURRENT,
    t.LIST_TEMPLATE_NONCURRENT,
    t.LIST_TEMPLATE_BEFORE_ROWS,
    t.LIST_TEMPLATE_AFTER_ROWS,
    t.BETWEEN_ITEMS,
    t.BEFORE_SUB_LIST,
    t.AFTER_SUB_LIST,
    t.BETWEEN_SUB_LIST_ITEMS,
    t.SUB_LIST_ITEM_CURRENT,
    t.SUB_LIST_ITEM_NONCURRENT,
    t.ITEM_TEMPLATE_CURR_W_CHILD,
    t.ITEM_TEMPLATE_NONCURR_W_CHILD,
    t.SUB_TEMPLATE_CURR_W_CHILD,
    t.SUB_TEMPLATE_NONCURR_W_CHILD,
    --
    t.FIRST_LIST_TEMPLATE_NONCURRENT,
    t.FIRST_LIST_TEMPLATE_CURRENT,
    t.F_ITEM_TEMPLATE_CURR_W_CHILD,
    t.FITEM_TEMPLATE_NONCURR_W_CHILD,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||internal_name
     from WWV_FLOW_LIST_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                ,
    t.LAST_UPDATED_ON                ,
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
       '1','Vertical Unordered List with Bullets',
       '2','Vertical Ordered List',
       '3','Horizontal Links List',
       '4','Horizontal Images with Label List',
       '5','Vertical Images List',
       '6','Button List',
       '7','Tabbed Navigation List',
       '9','Custom 1',
       '10','Custom 2',
       '11','Custom 3',
       '12','Custom 4',
       '13','Custom 5',
       '14','Custom 6',
       '15','Custom 7',
       '16','Custom 8',
       '17','Wizard Progress List',
       '18','Vertical Unordered List without Bullets',
       '19','Vertical Sidebar List',
       '20','Pull Down Menu',
       '21','Pull Down Menu with Image',
       '22','Hierarchical Expanding',
       '23','Hierarchical Expanded',
       t.THEME_CLASS_ID)             theme_class,
    t.default_template_options       default_template_options,
    t.preset_template_options        preset_template_options,
    t.TRANSLATE_THIS_TEMPLATE,
    t.LIST_TEMPLATE_COMMENT          component_comment,
    t.id                             list_template_id,
    --
    t.a01_label,
    t.a02_label,
    t.a03_label,
    t.a04_label,
    t.a05_label,
    t.a06_label,
    t.a07_label,
    t.a08_label,
    t.a09_label,
    t.a10_label,
    t.a11_label,
    t.a12_label,
    t.a13_label,
    t.a14_label,
    t.a15_label,
    t.a16_label,
    t.a17_label,
    t.a18_label,
    t.a19_label,
    t.a20_label,
    --
    t.LIST_TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' 1='||sys.dbms_lob.substr(t.LIST_TEMPLATE_CURRENT,40,1)||'.'||sys.dbms_lob.getlength(t.LIST_TEMPLATE_CURRENT)
    ||' 2='||sys.dbms_lob.substr(t.LIST_TEMPLATE_NONCURRENT,40,1)||'.'||sys.dbms_lob.getlength(t.LIST_TEMPLATE_NONCURRENT)
    ||' 3='||sys.dbms_lob.substr(t.SUB_LIST_ITEM_CURRENT,40,1)||'.'||sys.dbms_lob.getlength(t.SUB_LIST_ITEM_CURRENT)
    ||' 4='||sys.dbms_lob.substr(t.SUB_LIST_ITEM_NONCURRENT,40,1)||'.'||sys.dbms_lob.getlength(t.SUB_LIST_ITEM_NONCURRENT)
    ||' 5='||sys.dbms_lob.substr(t.ITEM_TEMPLATE_CURR_W_CHILD,40,1)||'.'||sys.dbms_lob.getlength(t.ITEM_TEMPLATE_CURR_W_CHILD)
    ||' 6='||sys.dbms_lob.substr(t.ITEM_TEMPLATE_NONCURR_W_CHILD,40,1)||'.'||sys.dbms_lob.getlength(t.ITEM_TEMPLATE_NONCURR_W_CHILD)
    ||' 7='||sys.dbms_lob.substr(t.SUB_TEMPLATE_CURR_W_CHILD,40,1)||'.'||sys.dbms_lob.getlength(t.SUB_TEMPLATE_CURR_W_CHILD)
    ||' 8='||sys.dbms_lob.substr(t.SUB_TEMPLATE_NONCURR_W_CHILD,40,1)||'.'||sys.dbms_lob.getlength(t.SUB_TEMPLATE_NONCURR_W_CHILD)
    ||' t='||t.TRANSLATE_THIS_TEMPLATE
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    ||' b='||substr(t.LIST_TEMPLATE_BEFORE_ROWS,1,20)||length(t.LIST_TEMPLATE_BEFORE_ROWS)
    ||' a='||substr(t.LIST_TEMPLATE_AFTER_ROWS,1,20)||length(t.LIST_TEMPLATE_AFTER_ROWS)
    ||' b='||substr(t.BETWEEN_ITEMS,1,20)||length(t.BETWEEN_ITEMS)
    ||' b='||substr(t.BEFORE_SUB_LIST,1,20)||length(t.BEFORE_SUB_LIST)
    ||' a='||substr(t.AFTER_SUB_LIST,1,20)||length(t.AFTER_SUB_LIST)
    ||' b='||substr(t.BETWEEN_SUB_LIST_ITEMS,1,20)||length(t.BETWEEN_SUB_LIST_ITEMS)
    component_signature
from WWV_FLOW_LIST_TEMPLATES t,
     wwv_flow_authorized     f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_list                               is 'Identifies HTML template markup used to render a List with List Elements';
comment on column apex_application_temp_list.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_list.workspace_display_name        is 'Display name for the workspace';
comment on column apex_application_temp_list.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_list.application_name              is 'Identifies the application';
comment on column apex_application_temp_list.TEMPLATE_NAME                 is 'Identifies the list template name';
comment on column apex_application_temp_list.INTERNAL_NAME                 is 'Internal name of the list template';
comment on column apex_application_temp_list.javascript_file_urls          is 'Allows definition of JavaScript file URLs that will be loaded on every page in the application.';
comment on column apex_application_temp_list.javascript_code_onload        is 'Identifies JavaScript code which is executed after page load';
comment on column apex_application_temp_list.css_file_urls                 is 'List of URLs which should be loaded for the list style.';
comment on column apex_application_temp_list.inline_css                    is 'Inline CSS to be included on the page for styling of list.';
comment on column apex_application_temp_list.LIST_TEMPLATE_CURRENT         is 'HTML or text to be substituted for the selected (or current) list entry';
comment on column apex_application_temp_list.LIST_TEMPLATE_NONCURRENT      is 'HTML or text to be substituted for the non selected (or non-current) list entry';
comment on column apex_application_temp_list.LIST_TEMPLATE_BEFORE_ROWS     is 'HTML that displays before any list elements. You can use this attribute to open an HTML table or HTML table row';
comment on column apex_application_temp_list.LIST_TEMPLATE_AFTER_ROWS      is 'HTML that displays after list elements. You can use this attribute to close an HTML table or HTML table row';
comment on column apex_application_temp_list.BETWEEN_ITEMS                 is 'HTML that displays between list elements';
comment on column apex_application_temp_list.BEFORE_SUB_LIST               is 'HTML that displays before any sub list elements. ';
comment on column apex_application_temp_list.AFTER_SUB_LIST                is 'HTML that displays after any sub list elements.';
comment on column apex_application_temp_list.BETWEEN_SUB_LIST_ITEMS        is 'HTML that displays between sub list elements';
comment on column apex_application_temp_list.SUB_LIST_ITEM_CURRENT         is 'HTML or text to be substituted for the selected (or current) sub list entry';
comment on column apex_application_temp_list.SUB_LIST_ITEM_NONCURRENT      is 'HTML or text to be substituted for the unselected (or noncurrent) sub list entry';
comment on column apex_application_temp_list.ITEM_TEMPLATE_CURR_W_CHILD    is 'HTML or text to be substituted for the selected (or current) sub list template used when an item has sub list entries';
comment on column apex_application_temp_list.ITEM_TEMPLATE_NONCURR_W_CHILD is 'HTML or text to be substituted for the unselected (or noncurrent) list template used when item has sub list items';
comment on column apex_application_temp_list.SUB_TEMPLATE_CURR_W_CHILD     is 'HTML or text to be substituted for the selected (or current) sub list template used when an item has sub list entries';
comment on column apex_application_temp_list.SUB_TEMPLATE_NONCURR_W_CHILD  is 'HTML or text to be substituted for the unselected (or noncurrent) list template used when item has sub list items';
comment on column apex_application_temp_list.is_subscribed                 is 'Identifies if this List Template is subscribed from another List Template';
comment on column apex_application_temp_list.subscribed_from               is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_list.THEME_number                  is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_temp_list.THEME_CLASS                   is 'Identifies a specific usage for this template';
comment on column apex_application_temp_list.default_template_options      is 'Identifies the default template options selected for this template';
comment on column apex_application_temp_list.preset_template_options       is 'Identifies the preset template options selected for this template';
comment on column apex_application_temp_list.TRANSLATE_THIS_TEMPLATE       is 'Identifies if this template should be translated';
comment on column apex_application_temp_list.COMPONENT_COMMENT             is 'Developer comment';
comment on column apex_application_temp_list.list_template_id              is 'Primary Key of this template';
comment on column apex_application_temp_list.last_updated_by               is 'APEX developer who made last update';
comment on column apex_application_temp_list.last_updated_on               is 'Date of last update';
comment on column apex_application_temp_list.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';

comment on column apex_application_temp_list.FIRST_LIST_TEMPLATE_NONCURRENT is 'First list template for non current entry template.  Defaults to list template non current.';
comment on column apex_application_temp_list.FIRST_LIST_TEMPLATE_CURRENT is 'First list template for current entry template.  Defaults to list template current.';
comment on column apex_application_temp_list.F_ITEM_TEMPLATE_CURR_W_CHILD is 'First item template for current entry with child';
comment on column apex_application_temp_list.FITEM_TEMPLATE_NONCURR_W_CHILD is 'First item template for non current entry with child';
comment on column apex_application_temp_list.a01_label                     is 'Identifies the definition of the substition string A01 for this template';
comment on column apex_application_temp_list.a02_label                     is 'Identifies the definition of the substition string A02 for this template';
comment on column apex_application_temp_list.a03_label                     is 'Identifies the definition of the substition string A03 for this template';
comment on column apex_application_temp_list.a04_label                     is 'Identifies the definition of the substition string A04 for this template';
comment on column apex_application_temp_list.a05_label                     is 'Identifies the definition of the substition string A05 for this template';
comment on column apex_application_temp_list.a06_label                     is 'Identifies the definition of the substition string A06 for this template';
comment on column apex_application_temp_list.a07_label                     is 'Identifies the definition of the substition string A07 for this template';
comment on column apex_application_temp_list.a08_label                     is 'Identifies the definition of the substition string A08 for this template';
comment on column apex_application_temp_list.a09_label                     is 'Identifies the definition of the substition string A09 for this template';
comment on column apex_application_temp_list.a10_label                     is 'Identifies the definition of the substition string A10 for this template';
comment on column apex_application_temp_list.a11_label                     is 'Identifies the definition of the substition string A11 for this template';
comment on column apex_application_temp_list.a12_label                     is 'Identifies the definition of the substition string A12 for this template';
comment on column apex_application_temp_list.a13_label                     is 'Identifies the definition of the substition string A13 for this template';
comment on column apex_application_temp_list.a14_label                     is 'Identifies the definition of the substition string A14 for this template';
comment on column apex_application_temp_list.a15_label                     is 'Identifies the definition of the substition string A15 for this template';
comment on column apex_application_temp_list.a16_label                     is 'Identifies the definition of the substition string A16 for this template';
comment on column apex_application_temp_list.a17_label                     is 'Identifies the definition of the substition string A17 for this template';
comment on column apex_application_temp_list.a18_label                     is 'Identifies the definition of the substition string A18 for this template';
comment on column apex_application_temp_list.a19_label                     is 'Identifies the definition of the substition string A19 for this template';
comment on column apex_application_temp_list.a20_label                     is 'Identifies the definition of the substition string A20 for this template';

create or replace view apex_application_temp_bc
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
      '1','Breadcrumb',
      '2','Hierarchical',
      '3','Custom 1',
      '4','Custom 2',
      '5','Custom 3',
      '6','Custom 4',
      '7','Custom 5',
      '8','Custom 6',
      '9','Custom 7',
      '10','Custom 10',
      t.THEME_CLASS_ID)              theme_class,
    t.default_template_options       default_template_options,
    t.preset_template_options        preset_template_options,
    --
    t.NAME                           template_name,
    t.INTERNAL_NAME                  internal_name,
    t.BEFORE_FIRST                   ,
    t.CURRENT_PAGE_OPTION            ,
    t.NON_CURRENT_PAGE_OPTION        ,
    t.MENU_LINK_ATTRIBUTES           breadcrumb_link_attributes,
    t.BETWEEN_LEVELS                 ,
    t.AFTER_LAST                     ,
    t.MAX_LEVELS                     ,
    decode(t.START_WITH_NODE,
       'CHILD_MENU','Child Breadcrumb Entries',
       'CURRENT_MENU','Current Breadcrumb',
       'PARENT_MENU','Parent Breadcrumb Entries',
       'PARENT_TO_LEAF','Parent to Leaf (breadcrumb style)',
       t.START_WITH_NODE)            start_with,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||internal_name
     from WWV_FLOW_MENU_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'Y','Yes','N','No','Yes')      translatable,
    t.TEMPLATE_COMMENTS              component_comments,
    t.id                             breadcrumb_template_id,
    --
    t.NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' 1='||substr(t.BEFORE_FIRST           ,1,30)||length(t.BEFORE_FIRST           )
    ||' 2='||substr(t.CURRENT_PAGE_OPTION    ,1,30)||length(t.CURRENT_PAGE_OPTION    )
    ||' 3='||substr(t.NON_CURRENT_PAGE_OPTION,1,30)||length(t.NON_CURRENT_PAGE_OPTION)
    ||' 4='||substr(t.MENU_LINK_ATTRIBUTES   ,1,30)||length(t.MENU_LINK_ATTRIBUTES   )
    ||' 5='||substr(t.BETWEEN_LEVELS         ,1,30)||length(t.BETWEEN_LEVELS         )
    ||' 6='||substr(t.AFTER_LAST             ,1,30)||length(t.AFTER_LAST             )
    ||' l='||t.MAX_LEVELS
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    ||' n='||t.START_WITH_NODE
    component_signature
from WWV_FLOW_MENU_TEMPLATES t,
     wwv_flow_authorized     f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_bc                            is 'Identifies the HTML template markup used to render a Breadcrumb';
comment on column apex_application_temp_bc.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_bc.workspace_display_name     is 'Display name for the workspace';
comment on column apex_application_temp_bc.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_bc.application_name           is 'Identifies the application';
comment on column apex_application_temp_bc.THEME_NUMBER               is 'Identifies the theme number associated with all templates within the theme';
comment on column apex_application_temp_bc.THEME_CLASS                is 'Identifies a specific usage for this template';
comment on column apex_application_temp_bc.default_template_options   is 'Identifies the default template options selected for this template';
comment on column apex_application_temp_bc.preset_template_options    is 'Identifies the preset template options selected for this template';
comment on column apex_application_temp_bc.TEMPLATE_NAME              is 'Identifies the name of this template';
comment on column apex_application_temp_bc.INTERNAL_NAME              is 'Internal name of this menu template';
comment on column apex_application_temp_bc.BEFORE_FIRST               is 'Defines text that displays before the first breadcrumb entry.';
comment on column apex_application_temp_bc.CURRENT_PAGE_OPTION        is 'Defines current entry, use #LINK#, #NAME#, #NAME_ESC_SC#, #LONG_NAME# substitution strings';
comment on column apex_application_temp_bc.NON_CURRENT_PAGE_OPTION    is 'Defines non current entry, use #LINK#, #NAME#, #NAME_ESC_SC#, #LONG_NAME# substitution strings';
comment on column apex_application_temp_bc.breadcrumb_LINK_ATTRIBUTES is 'Displayed within the HTML "A" tag';
comment on column apex_application_temp_bc.BETWEEN_LEVELS             is 'Defines text that displays between levels of breadcrumb entries';
comment on column apex_application_temp_bc.AFTER_LAST                 is 'Defines text that displays after the last breadcrumb entry.';
comment on column apex_application_temp_bc.MAX_LEVELS                 is 'Specifies the number of levels that appear when displaying breadcrumbs in a breadcrumb style.';
comment on column apex_application_temp_bc.START_WITH                 is 'Defines the breadcrumb display style';
comment on column apex_application_temp_bc.is_subscribed              is 'Identifies if this Breadcrumb Template is subscribed from another Breadcrumb Template';
comment on column apex_application_temp_bc.subscribed_from            is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_bc.TRANSLATABLE               is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_bc.COMPONENT_COMMENTS         is 'Developer Comments';
comment on column apex_application_temp_bc.breadcrumb_template_id     is 'Primary Key of this Breadcrumb Template';
comment on column apex_application_temp_bc.last_updated_by            is 'APEX developer who made last update';
comment on column apex_application_temp_bc.last_updated_on            is 'Date of last update';
comment on column apex_application_temp_bc.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';




create or replace view apex_application_temp_report
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.ROW_TEMPLATE_NAME              template_name,
    t.INTERNAL_NAME                  internal_name,
    --
    t.JAVASCRIPT_FILE_URLS           javascript_file_urls,
    t.JAVASCRIPT_CODE_ONLOAD         javascript_code_onload,
    t.CSS_FILE_URLS                  css_file_urls,
    --
    decode(t.ROW_TEMPLATE_TYPE,
      'GENERIC_COLUMNS','Generic Columns (column template)',
      'NAMED_COLUMNS','Named Column (row template)',
      t.ROW_TEMPLATE_TYPE)           template_type,
      --
    t.before_column_heading          ,
    t.COLUMN_HEADING_TEMPLATE        ,
    t.column_heading_sort_asc_temp,
    t.column_heading_sort_desc_temp,
    t.column_heading_sort_temp,
    t.after_column_heading           ,
    t.ROW_TEMPLATE1                  col_TEMPLATE1                ,
    t.ROW_TEMPLATE_CONDITION1        col_TEMPLATE_CONDITION1      ,
    t.ROW_TEMPLATE_DISPLAY_COND1     col_TEMPLATE_DISPLAY_COND1   ,
    t.ROW_TEMPLATE2                  col_TEMPLATE2                ,
    t.ROW_TEMPLATE_CONDITION2        col_TEMPLATE_CONDITION2      ,
    t.ROW_TEMPLATE_DISPLAY_COND2     col_TEMPLATE_DISPLAY_COND2   ,
    t.ROW_TEMPLATE3                  col_TEMPLATE3                ,
    t.ROW_TEMPLATE_CONDITION3        col_TEMPLATE_CONDITION3      ,
    t.ROW_TEMPLATE_DISPLAY_COND3     col_TEMPLATE_DISPLAY_COND3   ,
    t.ROW_TEMPLATE4                  col_TEMPLATE4                ,
    t.ROW_TEMPLATE_CONDITION4        col_TEMPLATE_CONDITION4      ,
    t.ROW_TEMPLATE_DISPLAY_COND4     col_TEMPLATE_DISPLAY_COND4   ,
    t.ROW_TEMPLATE_BEFORE_ROWS       col_TEMPLATE_BEFORE_ROWS     ,
    t.ROW_TEMPLATE_AFTER_ROWS        col_TEMPLATE_AFTER_ROWS      ,
    t.ROW_TEMPLATE_BEFORE_FIRST      col_TEMPLATE_BEFORE_FIRST    ,
    t.ROW_TEMPLATE_AFTER_LAST        col_TEMPLATE_AFTER_LAST      ,
    --t.ROW_TEMPLATE_TABLE_ATTRIBUTES  col_TEMPLATE_TABLE_ATTRIBUTES,
    t.PAGINATION_TEMPLATE            ,
    t.NEXT_PAGE_TEMPLATE             ,
    t.PREVIOUS_PAGE_TEMPLATE         ,
    t.NEXT_SET_TEMPLATE              ,
    t.PREVIOUS_SET_TEMPLATE          ,
    t.ROW_STYLE_MOUSE_OVER           ,
    --t.ROW_STYLE_MOUSE_OUT            ,
    t.ROW_STYLE_CHECKED              ,
    --t.ROW_STYLE_UNCHECKED            ,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||internal_name
     from WWV_FLOW_ROW_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                ,
    t.LAST_UPDATED_ON                ,
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
      '1','Borderless',
      '2','Horizontal Border',
      '3','One Column Unordered List',
      '4','Standard',
      '5','Standard, Alternating Row Colors',
      '6','Value Attribute Pairs',
      '7','Custom 1',
      '8','Custom 2',
      '9','Custom 3',
      '10','Custom 4',
      '11','Custom 5',
      '12','Custom 6',
      '13','Custom 7',
      '14','Custom 8',
      t.THEME_CLASS_ID)              theme_class,
    t.default_template_options       default_template_options,
    t.preset_template_options        preset_template_options,
    decode(t.TRANSLATE_THIS_TEMPLATE,
       'Y','Yes','N','No','Yes')     translate_this_template,
    t.ROW_TEMPLATE_COMMENT           component_comment,
    --
    t.ROW_TEMPLATE_NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    ||' t='||t.ROW_TEMPLATE_TYPE
    ||' 1='||sys.dbms_lob.substr(t.ROW_TEMPLATE1,1,40)||sys.dbms_lob.getlength(t.ROW_TEMPLATE1)
    ||' c='||substr(t.ROW_TEMPLATE_CONDITION1   ,1,20)||length(t.ROW_TEMPLATE_CONDITION1)
    ||' c='||substr(t.ROW_TEMPLATE_DISPLAY_COND1,1,20)||length(t.ROW_TEMPLATE_DISPLAY_COND1)
    ||' 2='||sys.dbms_lob.substr(t.ROW_TEMPLATE2,1,40)||sys.dbms_lob.getlength(t.ROW_TEMPLATE2)
    ||' c='||substr(t.ROW_TEMPLATE_CONDITION2   ,1,20)||length(t.ROW_TEMPLATE_CONDITION2)
    ||' c='||substr(t.ROW_TEMPLATE_DISPLAY_COND2,1,20)||length(t.ROW_TEMPLATE_DISPLAY_COND2)
    ||' 3='||sys.dbms_lob.substr(t.ROW_TEMPLATE3,1,40)||sys.dbms_lob.getlength(t.ROW_TEMPLATE3)
    ||' c='||substr(t.ROW_TEMPLATE_CONDITION3   ,1,20)||length(t.ROW_TEMPLATE_CONDITION3)
    ||' c='||substr(t.ROW_TEMPLATE_DISPLAY_COND3,1,20)||length(t.ROW_TEMPLATE_DISPLAY_COND3)
    ||' 4='||sys.dbms_lob.substr(t.ROW_TEMPLATE4,1,40)||sys.dbms_lob.getlength(t.ROW_TEMPLATE4)
    ||decode(t.REFERENCE_ID,null,'N','Y')
    component_signature,
    t.id template_id
from WWV_FLOW_ROW_TEMPLATES t,
     wwv_flow_authorized    f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_report                               is 'Identifies the HTML template markup used to render a Report Headings and Rows';
comment on column apex_application_temp_report.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_report.workspace_display_name        is 'Display name for the workspace';
comment on column apex_application_temp_report.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_report.application_name              is 'Identifies the application';
comment on column apex_application_temp_report.TEMPLATE_NAME                 is 'Identifies a name for this template';
comment on column apex_application_temp_report.INTERNAL_NAME                 is 'Internal name for this report template';
comment on column apex_application_temp_report.javascript_file_urls          is 'Allows definition of JavaScript file URLs that will be loaded on every page in the application.';
comment on column apex_application_temp_report.javascript_code_onload        is 'Identifies JavaScript code which is executed after page load';
comment on column apex_application_temp_report.css_file_urls                 is 'List of URLs which should be loaded for the list style.';
comment on column apex_application_temp_report.TEMPLATE_TYPE                 is 'Displays the type of the template - either Named columns or Generic Columns';
comment on column apex_application_temp_report.before_column_heading         is 'Emit this before the column header cell.';
comment on column apex_application_temp_report.COLUMN_HEADING_TEMPLATE       is 'This attribute is only applicable to generic column templates. Use this template to colorize each column header cell.';
comment on column apex_application_temp_report.after_column_heading          is 'Emit this after the column header cell.';
comment on column apex_application_temp_report.col_TEMPLATE1                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION1       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND1    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE2                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION2       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND2    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE3                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION3       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND3    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE4                 is 'Defines the column template, use #COLUMN_VALUE#, #ALIGNMENT#, #COLNUM#, #COLUMN_HEADER#, #COLCOUNT#, #ROW_NUM# substitutions';
comment on column apex_application_temp_report.col_TEMPLATE_CONDITION4       is 'Optionally select a condition type that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_DISPLAY_COND4    is 'A condition that must be met in order to apply this column template';
comment on column apex_application_temp_report.col_TEMPLATE_BEFORE_ROWS      is 'HTML which will be displayed one time at the beginning of a report template';
comment on column apex_application_temp_report.col_TEMPLATE_AFTER_ROWS       is 'HTML which will be displayed one time at the beginning of a report template';
comment on column apex_application_temp_report.col_TEMPLATE_BEFORE_FIRST     is 'Display this text before displaying all columns for the report. Use this attribute to open a new HTML row';
comment on column apex_application_temp_report.col_TEMPLATE_AFTER_LAST       is 'Display this HTML after all columns for the report display. Typically used to close an HTML table row';
--comment on column apex_application_temp_report.col_TEMPLATE_TABLE_ATTRIBUTES is '';
comment on column apex_application_temp_report.PAGINATION_TEMPLATE           is 'This attribute will be applied to the entire pagination subtemplate.';
comment on column apex_application_temp_report.NEXT_PAGE_TEMPLATE            is 'HTML that will modify how the "Next Page" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.PREVIOUS_PAGE_TEMPLATE        is 'HTML that will modify how the "Previous Page" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.NEXT_SET_TEMPLATE             is 'HTML that will modify how the "Next Set" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.PREVIOUS_SET_TEMPLATE         is 'HTML that will modify how the "Previous Set" portion of the pagination subtemplate will appear';
comment on column apex_application_temp_report.ROW_STYLE_MOUSE_OVER          is 'This attribute controls the background color of a report row when the user moves the mouse over the row';
--comment on column apex_application_temp_report.ROW_STYLE_MOUSE_OUT           is '';
comment on column apex_application_temp_report.ROW_STYLE_CHECKED             is 'This attribute controls the background color of a report row when the row selector is checked';
--comment on column apex_application_temp_report.ROW_STYLE_UNCHECKED           is '';
comment on column apex_application_temp_report.is_subscribed                 is 'Identifies if this Report Template is subscribed from another Report Template';
comment on column apex_application_temp_report.subscribed_from               is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_report.THEME_number                  is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_temp_report.THEME_CLASS                   is 'Identifies a specific usage for this template';
comment on column apex_application_temp_report.default_template_options      is 'Identifies the default template options selected for this template';
comment on column apex_application_temp_report.preset_template_options       is 'Identifies the preset template options selected for this template';
comment on column apex_application_temp_report.TRANSLATE_THIS_TEMPLATE       is 'Identifies if this template should be translated';
comment on column apex_application_temp_report.COMPONENT_COMMENT             is 'Developer Comment';
comment on column apex_application_temp_report.last_updated_by               is 'APEX developer who made last update';
comment on column apex_application_temp_report.last_updated_on               is 'Date of last update';
comment on column apex_application_temp_report.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_application_temp_report.template_id                   is 'Unique ID of report template';



create or replace view apex_appl_page_calendars
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    cal.id                          calendar_id,
    p.page_id ,
    p.plug_name                     region_name,
    cal.plug_id                     region_id,
    cal.template_id                 calendar_template_id,
    cal.easy_sql_owner              calendar_source_owner,
    cal.easy_sql_table              calendar_source,
    cal.date_column               ,
    case when nvl(cal.include_time_with_date,'Y') = 'Y' then 'Date and Time' else'Date Only' end date_format,
    cal.date_item                 ,
    cal.end_date_item             ,
    cal.date_type_column            calendar_type_column,
    case cal.display_type when 'COL' then 'Column'
                          when 'CUS' then 'Custom'
                          else 'No Display Value' end display_type,
    cal.display_column            ,
    cal.primary_key_column        ,
    cal.item_format                 column_format,
    case when nvl(cal.begin_at_start_of_interval,'N') = 'Y' then 'Yes' else 'No' end  begin_at_start_of_interval,
    cal.start_of_week               start_day_of_monthly,
    cal.week_start_day              start_day_of_weekly,
    cal.week_end_day                end_day_of_weekly,
    case when cal.time_format = '12HOUR' then '12 Hour' else '24 Hour' end time_format,
    cal.start_time                ,
    cal.end_time                  ,
    cal.data_background_color     ,
    cal.data_text_color           ,
    case cal.agenda_cal_days_type when 'MONTH' then 'Current Month'
                                  when 'YEAR' then 'Current Year'
                                  else 'Custom' end list_view_days_display,
    cal.agenda_cal_days             list_view_no_of_days,
    cal.item_link                 ,
    cal.item_link_primary_key_item,
    cal.item_link_date_item       ,
    case when cal.item_link_open_in = 'S' then 'Same Window' else 'Popup Window' end open_link_in,
    cal.day_link                  ,
    cal.drag_drop_process_id      ,
    decode(substr(cal.drag_drop_required_role,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(cal.drag_drop_required_role,'!')
     and    flow_id = f.application_id),
    cal.drag_drop_required_role)    drag_drop_authorization_scheme,
    cal.drag_drop_required_role     drag_drop_authorization_id,
    cal.last_updated_by           ,
    cal.last_updated_on
from wwv_flow_cals       cal,
     wwv_flow_page_plugs p,
     wwv_flow_authorized f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = cal.security_group_id
  and p.flow_id           = cal.flow_id
  and p.id                = cal.plug_id
/


comment on table  apex_appl_page_calendars                            is 'Identifies Application Calendars';
comment on column apex_appl_page_calendars.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_appl_page_calendars.workspace_display_name     is 'Display name for the workspace';
comment on column apex_appl_page_calendars.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_page_calendars.application_name           is 'Identifies the application';
comment on column apex_appl_page_calendars.calendar_id                is 'Unique ID for the Calendar';
comment on column apex_appl_page_calendars.page_id                    is 'Identifies page number';
comment on column apex_appl_page_calendars.region_id                  is 'The Region ID of the Calendar';
comment on column apex_appl_page_calendars.region_name                is 'Identifies the region name in which this Calendar is displayed';
comment on column apex_appl_page_calendars.calendar_template_id       is 'The Template used to display the Calendar Region.';
comment on column apex_appl_page_calendars.calendar_source_owner      is 'Name of the User who have access to Calendar Source';
comment on column apex_appl_page_calendars.calendar_source            is 'Calendar Source Table or Select statement.';
comment on column apex_appl_page_calendars.date_column                is 'The Date column of the Calendar Source which will be used to display Calendar data.';
comment on column apex_appl_page_calendars.date_format                is 'Identifies whether to include Time part with the Date, will be used in Week/Day and List View.';
comment on column apex_appl_page_calendars.date_item                  is 'The Page Item used to store the Calendar Date';
comment on column apex_appl_page_calendars.end_date_item              is 'The Page Item used to store the end date of the Calendar when in Custom View';
comment on column apex_appl_page_calendars.calendar_type_column       is 'The Page Item used to store the Calendar Type';
comment on column apex_appl_page_calendars.display_type               is 'Identifies how the data will be displayed';
comment on column apex_appl_page_calendars.display_column             is 'The Column which will be used to diaplay in the Calendar based on Calendar date.';
comment on column apex_appl_page_calendars.primary_key_column         is 'The Column of the Calendar Source which should be used as Primary key, used for Drag & Drop and Data manipulation.';
comment on column apex_appl_page_calendars.column_format              is 'The Display Columns and HTML formatted Text';
comment on column apex_appl_page_calendars.begin_at_start_of_interval is 'Identifies whether the Calendar should be rendered at the beginining of the Interval';
comment on column apex_appl_page_calendars.start_day_of_monthly       is 'The Start day of the Week, which should be used to display for the Month view of Calendar.';
comment on column apex_appl_page_calendars.start_day_of_weekly        is 'The Start Day of Week View.';
comment on column apex_appl_page_calendars.end_day_of_weekly          is 'The End Day of the Week View.';
comment on column apex_appl_page_calendars.time_format                is 'The format like 12 or 24 Hour which should be used for Displaying the Calendar Time.';
comment on column apex_appl_page_calendars.start_time                 is 'The Start Time of Week/Day View of Calendar';
comment on column apex_appl_page_calendars.end_time                   is 'The End Time of the Week/Day view of Calendar.';
comment on column apex_appl_page_calendars.data_background_color      is 'The Color which should be used for Calendar Data Background.';
comment on column apex_appl_page_calendars.data_text_color            is 'The Color which should be used to display Calendar Data.';
comment on column apex_appl_page_calendars.list_view_days_display     is 'Identifies whether to display Current Month, Year or Custom Days in List View.';
comment on column apex_appl_page_calendars.list_view_no_of_days       is 'Number of Days to display in List View.';
comment on column apex_appl_page_calendars.open_link_in               is 'Identifies where the URL should be opened either in Same window or Popup.';
comment on column apex_appl_page_calendars.item_link                  is 'The Page/URL link which should be used to navigate when clicking on Calendar data.';
comment on column apex_appl_page_calendars.day_link                   is 'The Page/URL link which should be used to navigate when clicking on the Date.';
comment on column apex_appl_page_calendars.drag_drop_process_id       is 'The Page process which should be used for Drag & Drop.';
comment on column apex_appl_page_calendars.drag_drop_authorization_scheme   is 'The Authorization scheme name should be used for Drag & Drop.';
comment on column apex_appl_page_calendars.drag_drop_authorization_id is 'The Authorization id should be used for Drag & Drop.';
comment on column apex_appl_page_calendars.item_link_primary_key_item is 'The Page Item which should be used for passing primary key value when editing Data.';
comment on column apex_appl_page_calendars.item_link_date_item        is 'The Page Item which should be used for passing date value when adding Calendar Data.';
comment on column apex_appl_page_calendars.last_updated_by            is 'The Developer who last updated the Calendar region.';
comment on column apex_appl_page_calendars.last_updated_on            is 'The last updated date and time of Calendar region.';


create or replace view apex_application_temp_calendar
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.NAME                           template_name,
    t.INTERNAL_NAME                  internal_name,
    t.LAST_UPDATED_BY                ,
    t.LAST_UPDATED_ON                ,
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
       '1','Calendar',
       '2','Calendar, Alternative 1',
       '3','Small Calendar',
       '4','Custom 1',
       '5','Custom 2',
       '6','Custom 3',
       '7','Custom 4',
       '8','Custom 5',
       '9','Custom 6',
       '10','Custom 7',
       '11','Custom 8',
       t.THEME_CLASS_ID)             theme_class,
    --
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'Y','Yes','N','No','Yes')      translatable,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||name
     from WWV_FLOW_CAL_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.MONTH_TITLE_FORMAT             ,
    t.DAY_OF_WEEK_FORMAT             ,
    t.MONTH_OPEN_FORMAT              ,
    t.MONTH_CLOSE_FORMAT             ,
    t.DAY_TITLE_FORMAT               ,
    t.DAY_OPEN_FORMAT                ,
    t.DAY_CLOSE_FORMAT               ,
    t.TODAY_OPEN_FORMAT              ,
    t.WEEKEND_TITLE_FORMAT           ,
    t.WEEKEND_OPEN_FORMAT            ,
    t.WEEKEND_CLOSE_FORMAT           ,
    t.NONDAY_TITLE_FORMAT            ,
    t.NONDAY_OPEN_FORMAT             ,
    t.NONDAY_CLOSE_FORMAT            ,
    t.WEEK_TITLE_FORMAT              ,
    t.WEEK_OPEN_FORMAT               ,
    t.WEEK_CLOSE_FORMAT              ,
    t.DAILY_TITLE_FORMAT             ,
    t.DAILY_OPEN_FORMAT              ,
    t.DAILY_CLOSE_FORMAT             ,
    t.weekly_title_format            ,
    t.weekly_day_of_week_format      ,
    t.weekly_month_open_format       ,
    t.weekly_month_close_format      ,
    t.weekly_day_title_format        ,
    t.weekly_day_open_format         ,
    t.weekly_day_close_format        ,
    t.weekly_today_open_format       ,
    t.weekly_weekend_title_format    ,
    t.weekly_weekend_open_format     ,
    t.weekly_weekend_close_format    ,
    t.weekly_time_open_format        ,
    t.weekly_time_close_format       ,
    t.weekly_time_title_format       ,
    t.weekly_hour_open_format        ,
    t.weekly_hour_close_format       ,
    t.daily_day_of_week_format       ,
    t.daily_month_title_format       ,
    t.daily_month_open_format        ,
    t.daily_month_close_format       ,
    t.daily_day_title_format         ,
    t.daily_day_open_format          ,
    t.daily_day_close_format         ,
    t.daily_today_open_format        ,
    t.daily_time_open_format         ,
    t.daily_time_close_format        ,
    t.daily_time_title_format        ,
    t.daily_hour_open_format         ,
    t.daily_hour_close_format        ,
    t.agenda_format                  ,
    t.agenda_past_day_format         ,
    t.agenda_today_day_format        ,
    t.agenda_future_day_format       ,
    t.agenda_past_entry_format       ,
    t.agenda_today_entry_format      ,
    t.agenda_future_entry_format     ,
    t.month_data_format              ,
    t.month_data_entry_format        ,
    t.TEMPLATE_COMMENTS              component_comment,
    t.id                             calendar_template_id,
    --
    t.NAME
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    component_signature
from WWV_FLOW_CAL_TEMPLATES t,
     wwv_flow_authorized    f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_calendar                         is 'Identifies the HTML template markup used to display a Calendar';
comment on column apex_application_temp_calendar.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_calendar.workspace_display_name  is 'Display name for the workspace';
comment on column apex_application_temp_calendar.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_calendar.application_name        is 'Identifies the application';
comment on column apex_application_temp_calendar.TEMPLATE_NAME           is 'Identifies the template name';
comment on column apex_application_temp_calendar.INTERNAL_NAME           is 'Internal name of the calendar template ';
comment on column apex_application_temp_calendar.THEME_number            is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_temp_calendar.THEME_CLASS             is 'Identifies a specific usage for this template';
comment on column apex_application_temp_calendar.translatable            is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_calendar.IS_SUBSCRIBED           is 'Identifies if this Calendar Template is subscribed from another Calendar Template';
comment on column apex_application_temp_calendar.SUBSCRIBED_FROM         is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_calendar.MONTH_TITLE_FORMAT      is 'Format for the monthly title that appears at the top of each month';
comment on column apex_application_temp_calendar.DAY_OF_WEEK_FORMAT      is 'Format for the week day names which display as the column header for that day of the week';
comment on column apex_application_temp_calendar.MONTH_OPEN_FORMAT       is 'Printed immediately after the "Month Title Format". Usually this would be an HTML tag which is a container such as a table. Include substitution strings to include dynamic content.';
comment on column apex_application_temp_calendar.MONTH_CLOSE_FORMAT      is 'HTML to be used to close a month';
comment on column apex_application_temp_calendar.DAY_TITLE_FORMAT        is 'HTML to be used for the day''s title which the first thing printed after the "Day Open Format';
comment on column apex_application_temp_calendar.DAY_OPEN_FORMAT         is 'HTML to be used to opening a day. This is printed for each day. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.DAY_CLOSE_FORMAT        is 'HTML to be used to close a day';
comment on column apex_application_temp_calendar.TODAY_OPEN_FORMAT       is 'HTML to be used to open today. Usually this would be an HTML tag which is a container such as a td and would be different somehow from the "Day Open".';
comment on column apex_application_temp_calendar.WEEKEND_TITLE_FORMAT    is 'HTML be used to for a day occurring on a weekend';
comment on column apex_application_temp_calendar.WEEKEND_OPEN_FORMAT     is 'HTML used to open a day which is on a weekend';
comment on column apex_application_temp_calendar.WEEKEND_CLOSE_FORMAT    is 'HTML used to close a day which is on a weekend';
comment on column apex_application_temp_calendar.NONDAY_TITLE_FORMAT     is 'HTML used to format a non-day title. For example, suppose the first of a month is a Monday, but the week starts on a Sunday. Since Sunday is not be part of the current month, Sunday would be a non-day.';
comment on column apex_application_temp_calendar.NONDAY_OPEN_FORMAT      is 'HTML to open a non-day';
comment on column apex_application_temp_calendar.NONDAY_CLOSE_FORMAT     is 'HTML which will close a non-day';
comment on column apex_application_temp_calendar.WEEK_TITLE_FORMAT       is 'HTML be used to for a day occurring on a weekend';
comment on column apex_application_temp_calendar.WEEK_OPEN_FORMAT        is 'HTML to be used to open a week. This is printed for each week. Usually this would be an HTML tag which is a container such as a TR.';
comment on column apex_application_temp_calendar.WEEK_CLOSE_FORMAT       is 'HTML to be used to close a week.';
comment on column apex_application_temp_calendar.weekly_title_format            is 'Format for the weekly title that appears at the top of each week';
comment on column apex_application_temp_calendar.weekly_day_of_week_format      is 'Format for the week day names which display as the column header for that day of the Week';
comment on column apex_application_temp_calendar.weekly_month_open_format       is 'Printed immediately after the "Week Title Format". Usually this would be an HTML tag which is a container such as a table. Include substitution strings to include dynamic content.';
comment on column apex_application_temp_calendar.weekly_month_close_format      is 'HTML to be used to close a Week';
comment on column apex_application_temp_calendar.weekly_day_title_format        is 'HTML to be used for the day''s title which the first thing printed after the "Day Open Format';
comment on column apex_application_temp_calendar.weekly_day_open_format         is 'HTML to be used to opening a day. This is printed for each day. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.weekly_day_close_format        is 'HTML to be used to close a day';
comment on column apex_application_temp_calendar.weekly_today_open_format       is 'HTML to be used to open today. Usually this would be an HTML tag which is a container such as a td and would be different somehow from the "Day Open".';
comment on column apex_application_temp_calendar.weekly_weekend_title_format    is 'HTML be used to for a day occurring on a weekend';
comment on column apex_application_temp_calendar.weekly_weekend_open_format     is 'HTML used to open a day which is on a weekend';
comment on column apex_application_temp_calendar.weekly_weekend_close_format    is 'HTML used to close a day which is on a weekend';
comment on column apex_application_temp_calendar.weekly_time_open_format        is 'HTML to be used to display the Time. This is printed for each Hour for a week. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.weekly_time_close_format       is 'HTML to be used to close the Time display column';
comment on column apex_application_temp_calendar.weekly_time_title_format       is 'HTML be used for displaying the Time';
comment on column apex_application_temp_calendar.weekly_hour_open_format        is 'HTML to be used to opening the Hour for the week. This is printed for each Hour. Usually this would be an HTML tag which is a container such as a TR.';
comment on column apex_application_temp_calendar.weekly_hour_close_format       is 'HTML to be used to close the Hour';
comment on column apex_application_temp_calendar.daily_day_of_week_format       is 'Format for the week day names which display as the column header for that day of the Week';
comment on column apex_application_temp_calendar.daily_month_title_format       is 'Title format for the Daily Calendar.';
comment on column apex_application_temp_calendar.daily_month_open_format        is 'Printed immediately after the "Day Title Format". Usually this would be an HTML tag which is a container such as a table. Include substitution strings to include dynamic content.';
comment on column apex_application_temp_calendar.daily_month_close_format       is 'HTML to be used to close a Day';
comment on column apex_application_temp_calendar.daily_day_title_format         is 'HTML to be used for the day''s title which the first thing printed after the "Day Open Format';
comment on column apex_application_temp_calendar.daily_day_open_format          is 'HTML to be used to opening a day. This is printed for each day. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.daily_day_close_format         is 'HTML to be used to close a day';
comment on column apex_application_temp_calendar.daily_today_open_format        is 'HTML to be used to open today. Usually this would be an HTML tag which is a container such as a td and would be different somehow from the "Day Open".';
comment on column apex_application_temp_calendar.daily_time_open_format         is 'HTML to be used to display the Time. This is printed for each Hour. Usually this would be an HTML tag which is a container such as a TD.';
comment on column apex_application_temp_calendar.daily_time_close_format        is 'HTML to be used to close the Time display column';
comment on column apex_application_temp_calendar.daily_time_title_format        is 'HTML be used for displaying the Time';
comment on column apex_application_temp_calendar.daily_hour_open_format         is 'HTML to be used to opening the Hour for the Day. This is printed for each Hour. Usually this would be an HTML tag which is a container such as a TR.';
comment on column apex_application_temp_calendar.daily_hour_close_format        is 'HTML to be used to close the Hour';
comment on column apex_application_temp_calendar.agenda_format                  is 'HTML to be used for Open the Agenda View';
comment on column apex_application_temp_calendar.agenda_past_day_format         is 'HTML to be used to display agenda entry title where Calendar Date are lesser than today''s date.';
comment on column apex_application_temp_calendar.agenda_today_day_format        is 'HTML to be used to display agenda entry title where Calendar Date are equual to today''s date.';
comment on column apex_application_temp_calendar.agenda_future_day_format       is 'HTML to be used to display agenda entry title where Calendar Date are greater than today''s date.';
comment on column apex_application_temp_calendar.agenda_past_entry_format       is 'HTML to be used to display agenda Data where Calendar Date are lesser than today''s date.';
comment on column apex_application_temp_calendar.agenda_today_entry_format      is 'HTML to be used to display agenda Data where Calendar Date are equual to today''s date.';
comment on column apex_application_temp_calendar.agenda_future_entry_format     is 'HTML to be used to display agenda Data where Calendar Date are greater than today''s date.';
comment on column apex_application_temp_calendar.month_data_format              is 'HTML to be used for Open and close the Month data view independent of Calendar';
comment on column apex_application_temp_calendar.month_data_entry_format        is 'HTML to be used to display Month Data independent of Calendar';
comment on column apex_application_temp_calendar.COMPONENT_COMMENT       is 'Developer comment';
comment on column apex_application_temp_calendar.last_updated_by         is 'APEX developer who made last update';
comment on column apex_application_temp_calendar.last_updated_on         is 'Date of last update';
comment on column apex_application_temp_calendar.calendar_template_id    is 'Identifies the Primary Key of this Calendar Template';
comment on column apex_application_temp_calendar.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';



create or replace view apex_application_temp_button
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.THEME_ID                       theme_number,
    decode(t.THEME_CLASS_ID,
       '1','Button',
       '2','Button, Alternative 3',
       '4','Button, Alternative 1',
       '5','Button, Alternative 2',
       '6','Custom 1',
       '7','Custom 2',
       '8','Custom 3',
       '9','Custom 4',
       '10','Custom 5',
       '11','Custom 6',
       '12','Custom 7',
       '13','Custom 8',
       t.THEME_CLASS_ID)             theme_class,
    t.default_template_options       default_template_options,
    t.preset_template_options        preset_template_options,
    --
    t.TEMPLATE_NAME                  template_name,
    t.INTERNAL_NAME                  internal_name,
    t.TEMPLATE,
    t.hot_template,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||internal_name
     from WWV_FLOW_button_TEMPLATES
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_BY                last_updated_by,
    t.LAST_UPDATED_ON                last_updated_on,
    --
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'Y','Yes','N','No','Yes')      translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             button_template_id,
    --
    t.template_name
    ||' t='||t.THEME_ID
    ||' c='||t.THEME_CLASS_ID
    component_signature
from wwv_flow_button_templates t,
     wwv_flow_authorized       f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_button                           is 'Identifies the HTML template markup used to display a Button';
comment on column apex_application_temp_button.workspace                 is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_button.workspace_display_name    is 'Display name for the workspace';
comment on column apex_application_temp_button.application_id            is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_button.application_name          is 'Identifies the application';
comment on column apex_application_temp_button.THEME_NUMBER              is 'Identifies the templates corresponding theme';
comment on column apex_application_temp_button.THEME_CLASS               is 'Identifies a specific usage for this template';
comment on column apex_application_temp_button.default_template_options  is 'Identifies the default template option selected for this template';
comment on column apex_application_temp_button.preset_template_options   is 'Identifies the preset template option selected for this template';
comment on column apex_application_temp_button.TEMPLATE_NAME             is 'Identifies the button template';
comment on column apex_application_temp_button.INTERNAL_NAME             is 'Internal name of the button template';
comment on column apex_application_temp_button.TEMPLATE                  is 'HTML Template of a normal button';
comment on column apex_application_temp_button.hot_template              is 'HTML Template of a hot button';
comment on column apex_application_temp_button.is_subscribed             is 'Identifies if this Button Template is subscribed from another Button Template';
comment on column apex_application_temp_button.SUBSCRIBED_FROM           is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_button.TRANSLATable              is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_button.COMPONENT_COMMENT         is 'Developer comment';
comment on column apex_application_temp_button.last_updated_by           is 'APEX developer who made last update';
comment on column apex_application_temp_button.last_updated_on           is 'Date of last update';
comment on column apex_application_temp_button.button_template_id        is 'Primary Key of this Button Template';
comment on column apex_application_temp_button.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';



create or replace view apex_application_temp_popuplov
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    --
    t.POPUP_ICON                     ,
    t.POPUP_ICON_ATTR                ,
    t.POPUP_ICON2                    ,
    t.POPUP_ICON_ATTR2               ,
    --t.PAGE_NAME                      ,
    t.PAGE_TITLE                     ,
    t.PAGE_HTML_HEAD                 ,
    t.PAGE_BODY_ATTR                 ,
    t.BEFORE_FIELD_TEXT              ,
    t.AFTER_FIELD_TEXT               ,
    t.PAGE_HEADING_TEXT              ,
    t.PAGE_FOOTER_TEXT               ,
    t.BEFORE_RESULT_SET              ,
    t.AFTER_RESULT_SET               ,
    t.FILTER_WIDTH                   ,
    t.FILTER_MAX_WIDTH               ,
    t.FILTER_TEXT_ATTR               ,
    t.FIND_BUTTON_TEXT               ,
    t.FIND_BUTTON_IMAGE              ,
    t.FIND_BUTTON_ATTR               ,
    t.CLOSE_BUTTON_TEXT              ,
    t.CLOSE_BUTTON_IMAGE             ,
    t.CLOSE_BUTTON_ATTR              ,
    t.NEXT_BUTTON_TEXT               ,
    t.NEXT_BUTTON_IMAGE              ,
    t.NEXT_BUTTON_ATTR               ,
    t.PREV_BUTTON_TEXT               ,
    t.PREV_BUTTON_IMAGE              ,
    t.PREV_BUTTON_ATTR               ,
    t.SCROLLBARS                     ,
    t.RESIZABLE                      ,
    t.WIDTH                          ,
    t.HEIGHT                         ,
    t.RESULT_ROW_X_OF_Y              ,
    t.RESULT_ROWS_PER_PG             ,
    t.WHEN_NO_DATA_FOUND_MESSAGE     ,
    t.BEFORE_FIRST_FETCH_MESSAGE     ,
    t.MINIMUM_CHARACTERS_REQUIRED    ,
    t.THEME_ID                       theme_number,
    --
    decode(t.THEME_CLASS_ID,
     '1','Standard',
     t.THEME_CLASS_ID)               theme_class,
    --
    decode(t.REFERENCE_ID,
    null,'No','Yes')                 is_subscribed,
    (select flow_id||'. '||page_title
     from WWV_FLOW_POPUP_LOV_TEMPLATE
     where id = t.REFERENCE_ID)      subscribed_from,
    --
    t.LAST_UPDATED_ON                last_updated_on,
    t.LAST_UPDATED_BY                last_updated_by,
    decode(t.TRANSLATE_THIS_TEMPLATE,
      'N','No','Y','Yes','Yes')      translatable,
    t.TEMPLATE_COMMENT               component_comment,
    t.id                             template_id,
    --
    'pop'
    ||' ='||substr(POPUP_ICON                 ,1,20)||length(POPUP_ICON                 )
    ||' ='||substr(POPUP_ICON_ATTR            ,1,20)||length(POPUP_ICON_ATTR            )
    ||' ='||substr(POPUP_ICON2                ,1,20)||length(POPUP_ICON2                )
    ||' ='||substr(POPUP_ICON_ATTR2           ,1,20)||length(POPUP_ICON_ATTR2           )
    ||' ='||substr(PAGE_TITLE                 ,1,20)||length(PAGE_TITLE                 )
    ||' ='||substr(PAGE_HTML_HEAD             ,1,20)||length(PAGE_HTML_HEAD             )
    ||' ='||substr(PAGE_BODY_ATTR             ,1,20)||length(PAGE_BODY_ATTR             )
    ||' ='||substr(BEFORE_FIELD_TEXT          ,1,20)||length(BEFORE_FIELD_TEXT          )
    ||' ='||substr(AFTER_FIELD_TEXT           ,1,20)||length(AFTER_FIELD_TEXT           )
    ||' ='||substr(PAGE_HEADING_TEXT          ,1,20)||length(PAGE_HEADING_TEXT          )
    ||' ='||substr(PAGE_FOOTER_TEXT           ,1,20)||length(PAGE_FOOTER_TEXT           )
    ||' ='||substr(BEFORE_RESULT_SET          ,1,20)||length(BEFORE_RESULT_SET          )
    ||' ='||substr(AFTER_RESULT_SET           ,1,20)||length(AFTER_RESULT_SET           )
    ||' ='||substr(FILTER_WIDTH               ,1,20)||length(FILTER_WIDTH               )
    ||' ='||substr(FILTER_MAX_WIDTH           ,1,20)||length(FILTER_MAX_WIDTH           )
    ||' ='||substr(FILTER_TEXT_ATTR           ,1,20)||length(FILTER_TEXT_ATTR           )
    ||' ='||substr(FIND_BUTTON_TEXT           ,1,20)||length(FIND_BUTTON_TEXT           )
    ||' ='||substr(FIND_BUTTON_IMAGE          ,1,20)||length(FIND_BUTTON_IMAGE          )
    ||' ='||substr(FIND_BUTTON_ATTR           ,1,20)||length(FIND_BUTTON_ATTR           )
    ||' ='||substr(CLOSE_BUTTON_TEXT          ,1,20)||length(CLOSE_BUTTON_TEXT          )
    ||' ='||substr(CLOSE_BUTTON_IMAGE         ,1,20)||length(CLOSE_BUTTON_IMAGE         )
    ||' ='||substr(CLOSE_BUTTON_ATTR          ,1,20)||length(CLOSE_BUTTON_ATTR          )
    ||' ='||substr(NEXT_BUTTON_TEXT           ,1,20)||length(NEXT_BUTTON_TEXT           )
    ||' ='||substr(NEXT_BUTTON_IMAGE          ,1,20)||length(NEXT_BUTTON_IMAGE          )
    ||' ='||substr(NEXT_BUTTON_ATTR           ,1,20)||length(NEXT_BUTTON_ATTR           )
    ||' ='||substr(PREV_BUTTON_TEXT           ,1,20)||length(PREV_BUTTON_TEXT           )
    ||' ='||substr(PREV_BUTTON_IMAGE          ,1,20)||length(PREV_BUTTON_IMAGE          )
    ||' ='||substr(PREV_BUTTON_ATTR           ,1,20)||length(PREV_BUTTON_ATTR           )
    ||' ='||substr(SCROLLBARS                 ,1,20)||length(SCROLLBARS                 )
    ||' ='||substr(RESIZABLE                  ,1,20)||length(RESIZABLE                  )
    ||' ='||substr(WIDTH                      ,1,20)||length(WIDTH                      )
    ||' ='||substr(HEIGHT                     ,1,20)||length(HEIGHT                     )
    ||' ='||substr(RESULT_ROW_X_OF_Y          ,1,20)||length(RESULT_ROW_X_OF_Y          )
    ||' ='||RESULT_ROWS_PER_PG
    ||' ='||substr(WHEN_NO_DATA_FOUND_MESSAGE ,1,20)||length(WHEN_NO_DATA_FOUND_MESSAGE )
    ||' ='||substr(BEFORE_FIRST_FETCH_MESSAGE ,1,20)||length(BEFORE_FIRST_FETCH_MESSAGE )
    ||' ='||substr(MINIMUM_CHARACTERS_REQUIRED,1,20)||length(MINIMUM_CHARACTERS_REQUIRED)
    ||' r='||decode(t.REFERENCE_ID,null,'N','Y')
    component_signature
from WWV_FLOW_POPUP_LOV_TEMPLATE t,
     wwv_flow_authorized         f
where f.workspace_id   = t.security_group_id
  and f.application_id = t.flow_id
/

comment on table  apex_application_temp_popuplov                               is 'Identifies the HTML template markup and some functionality of all Popup List of Values controls for this application';
comment on column apex_application_temp_popuplov.workspace                     is 'A work area mapped to one or more database schemas';
comment on column apex_application_temp_popuplov.workspace_display_name        is 'Display name for the workspace';
comment on column apex_application_temp_popuplov.application_id                is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_temp_popuplov.application_name              is 'Identifies the application';
comment on column apex_application_temp_popuplov.POPUP_ICON                    is 'Name of the image used for all Popup List of Values Icons within this application';
comment on column apex_application_temp_popuplov.POPUP_ICON_ATTR               is 'HTML IMG attributes used to render the Popup List of Values Image';
comment on column apex_application_temp_popuplov.POPUP_ICON2                   is 'Name of the image used for Color Picker Popup List of Values Icon within this application';
comment on column apex_application_temp_popuplov.POPUP_ICON_ATTR2              is 'HTML IMG attributes used to render the Color Picker Popup List of Values Image';
comment on column apex_application_temp_popuplov.PAGE_TITLE                    is 'Page title of the popup list of values page';
comment on column apex_application_temp_popuplov.PAGE_HTML_HEAD                is 'HTML Page Heading';
comment on column apex_application_temp_popuplov.PAGE_BODY_ATTR                is 'Defines text that is added into the popup list of values HTML BODY';
comment on column apex_application_temp_popuplov.BEFORE_FIELD_TEXT             is 'Defines text to display before the popup list of values search field displays';
comment on column apex_application_temp_popuplov.AFTER_FIELD_TEXT              is 'Defines text to display after displaying the search field, the search button, and the close button';
comment on column apex_application_temp_popuplov.PAGE_HEADING_TEXT             is 'Defines text to display after opening the form, but before displaying any text';
comment on column apex_application_temp_popuplov.PAGE_FOOTER_TEXT              is 'Defines text to display after displaying the popup page including the search list results';
comment on column apex_application_temp_popuplov.BEFORE_RESULT_SET             is 'Display this text before displaying the result set. The result set is the result of the list of values query';
comment on column apex_application_temp_popuplov.AFTER_RESULT_SET              is 'Display this text after displaying the result set. The result set is the result of the list of values query';
comment on column apex_application_temp_popuplov.FILTER_WIDTH                  is 'Display the HTML INPUT TYPE = TEXT widget using this width';
comment on column apex_application_temp_popuplov.FILTER_MAX_WIDTH              is 'Display the HTML INPUT TYPE = TEXT widget using this maximum width';
comment on column apex_application_temp_popuplov.FILTER_TEXT_ATTR              is 'Display the HTML INPUT TYPE = TEXT widget using these attributes';
comment on column apex_application_temp_popuplov.FIND_BUTTON_TEXT              is 'Defines text that displays on the name of the button used to search on the popup page';
comment on column apex_application_temp_popuplov.FIND_BUTTON_IMAGE             is 'Defines button image of the button used to search on the popup page';
comment on column apex_application_temp_popuplov.FIND_BUTTON_ATTR              is 'Defines additional attributes for the Find button';
comment on column apex_application_temp_popuplov.CLOSE_BUTTON_TEXT             is 'Defines the name of the close button. The close button dismisses the popup list of values page';
comment on column apex_application_temp_popuplov.CLOSE_BUTTON_IMAGE            is 'Defines close button image. The close button dismisses the popup list of values page';
comment on column apex_application_temp_popuplov.CLOSE_BUTTON_ATTR             is 'Defines additional attributes of the Close button';
comment on column apex_application_temp_popuplov.NEXT_BUTTON_TEXT              is 'Defines the name of the Next button used when paginating result sets';
comment on column apex_application_temp_popuplov.NEXT_BUTTON_IMAGE             is 'Defines the button image of the Next button used when paginating result sets';
comment on column apex_application_temp_popuplov.NEXT_BUTTON_ATTR              is 'Defines additional attributes for the Next button';
comment on column apex_application_temp_popuplov.PREV_BUTTON_TEXT              is 'Defines the name of Previous page button. This button is used to paginate result sets';
comment on column apex_application_temp_popuplov.PREV_BUTTON_IMAGE             is 'Defines the button image of Previous page button. This button is used to paginate result sets.';
comment on column apex_application_temp_popuplov.PREV_BUTTON_ATTR              is 'Defines additional attributes of the Previous button';
comment on column apex_application_temp_popuplov.SCROLLBARS                    is 'Popup lists of values are executed using JavaScript. Use this attribute to control the values of scrollbars';
comment on column apex_application_temp_popuplov.RESIZABLE                     is 'Popup lists of values are executed using JavaScript. Use this attribute to control the value of resizable';
comment on column apex_application_temp_popuplov.WIDTH                         is 'Popup lists of values are executed using JavaScript. Use this attribute to control the values of width';
comment on column apex_application_temp_popuplov.HEIGHT                        is 'Popup lists of values are executed using JavaScript. Use this attribute to control the values of height';
comment on column apex_application_temp_popuplov.RESULT_ROW_X_OF_Y             is 'Defines how row count results display';
comment on column apex_application_temp_popuplov.RESULT_ROWS_PER_PG            is 'Defines the number of rows per page';
comment on column apex_application_temp_popuplov.WHEN_NO_DATA_FOUND_MESSAGE    is '';
comment on column apex_application_temp_popuplov.BEFORE_FIRST_FETCH_MESSAGE    is '';
comment on column apex_application_temp_popuplov.MINIMUM_CHARACTERS_REQUIRED   is '';
comment on column apex_application_temp_popuplov.THEME_NUMBER                  is 'Identifies the templates corresponding theme';
comment on column apex_application_temp_popuplov.THEME_CLASS                   is 'Identifies a specific usage for this template';
comment on column apex_application_temp_popuplov.is_subscribed                 is 'Identifies if this Popup List of Values Template is subscribed from another Popup List of Values Template';
comment on column apex_application_temp_popuplov.subscribed_from               is 'Identifies the master component from which this component is subscribed';
comment on column apex_application_temp_popuplov.TRANSLATable                  is 'Identifies if this component is to be identified as translatable (yes or no)';
comment on column apex_application_temp_popuplov.COMPONENT_COMMENT             is 'Developer comment';
comment on column apex_application_temp_popuplov.template_id                   is 'Primary Key of this Popup List of Values Template';
comment on column apex_application_temp_popuplov.last_updated_by               is 'APEX developer who made last update';
comment on column apex_application_temp_popuplov.last_updated_on               is 'Date of last update';
comment on column apex_application_temp_popuplov.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';




create or replace view apex_application_templates
as
select
  ff.workspace,
  ff.workspace_display_name,
  ff.application_id,
  ff.application_name,
  x.theme_id                            theme_number,
  decode(x.template_type,
  'PAGE','Page',
  'REGION','Region',
  'LABEL','Item Label',
  'LIST','List',
  'POPUP_LOV','Popup List of Values',
  'CALENDAR','Calendar',
  'MENU','Breadcrumb',
  'BUTTON','Button',
  'REPORT','Report',
  'GRID', 'Grid',
  x.template_type)                      template_type,
  x.template_name                       template_name,
  x.internal_name                       internal_name,
  x.reference_count                     reference_count,
  x.last_updated_on                     last_updated_on,
  x.last_updated_by                     last_updated_by,
  decode(x.reference_id,null,
      'No',0,'No','Yes')                is_subscribed,
  decode(x.is_default,0,'No','Yes')     is_default,
  tid                                   template_id
from wwv_flow_authorized ff,
(
select
    flow_id,
    security_group_id,
    'POPUP_LOV' template_type,
    'Popup LOV' template_name,
    'POPUP_LOV' internal_name,
    1 reference_count,
    last_updated_on,
    last_updated_by,
    null reference_id,
    1 is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_popup_lov_template plt
union all
select
    flow_id,
    security_group_id,
    'CALENDAR' template_type,
    NAME template_name,
    internal_name,
    (select count(*) from WWV_FLOW_CALS where template_id = c.id and flow_id = c.flow_id )+
    (select count(*) from wwv_flow_themes where flow_id = c.flow_id and theme_id = c.theme_id and default_calendar_template = c.id) reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flow_themes where flow_id = c.flow_id and theme_id = c.theme_id and default_calendar_template = c.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_cal_templates c
union all
select
    flow_id,
    security_group_id,
    'MENU'   template_type,
    NAME     template_name,
    internal_name internal_name,
    (select count(*) from wwv_flow_page_plugs r where r.flow_id = m.flow_id and r.menu_template_id = m.id)+
    (select count(*) from wwv_flow_themes where flow_id = m.flow_id and theme_id = m.theme_id and default_menu_template = m.id)
    reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flow_themes where flow_id = m.flow_id and theme_id = m.theme_id and default_menu_template = m.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_menu_templates m
union all
select
    flow_id,
    security_group_id,
    'BUTTON'             template_type,
    TEMPLATE_NAME        template_name,
    internal_name        internal_name,
    (select count(*)
       from wwv_flow_step_buttons sb
      where sb.flow_id = b.flow_id
        and sb.button_template_id = b.id)+
    (select count(*) from wwv_flow_themes where flow_id = b.flow_id and theme_id = b.theme_id and default_button_template = b.id) reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flow_themes where flow_id = b.flow_id and theme_id = b.theme_id and default_button_template = b.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_button_templates b
union all
select
    flow_id,
    security_group_id,
    'LABEL' template_type,
    TEMPLATE_NAME template_name,
    internal_name internal_name,
    (select count(*) from wwv_flow_step_items i where i.flow_id = f.flow_id and i.ITEM_FIELD_TEMPLATE = f.id)+
    (select count(*) from wwv_flow_themes where flow_id = f.flow_id and theme_id = f.theme_id and default_label_template = f.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flow_themes where flow_id = f.flow_id and theme_id = f.theme_id and default_label_template = f.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_field_templates f
union all
select
    flow_id,
    security_group_id,
    'LIST' template_type,
    l.LIST_TEMPLATE_NAME template_name,
    internal_name        internal_name,
    (select count(*) from wwv_flow_page_plugs p where p.flow_id = l.flow_id and p.list_template_id = l.id) +
    (select count(*) from wwv_flow_themes where flow_id = l.flow_id and theme_id = l.theme_id and default_list_template = l.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flow_themes where flow_id = l.flow_id and theme_id = l.theme_id and default_list_template = l.id) is_default,
    0 preview,
    theme_id,
    id tid
from wwv_flow_list_templates l
union all
select
    flow_id,
    security_group_id,
    'REPORT'                 template_type,
    ROW_TEMPLATE_NAME        template_name,
    internal_name            internal_name,
    (select count(*) from wwv_flow_page_plugs p where flow_id = ro.flow_id and p.PLUG_QUERY_ROW_TEMPLATE = ro.id) +
    (select count(*) from wwv_flow_themes where flow_id = ro.flow_id and theme_id = ro.theme_id and default_report_template = ro.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flow_themes where flow_id = ro.flow_id and theme_id = ro.theme_id and default_report_template = ro.id) is_default,
    ro.id preview,
    theme_id,
    id tid
from wwv_flow_row_templates ro
union all
select
    flow_id,
    security_group_id,
    'PAGE'        template_type,
    name          template_name,
    internal_name internal_name,
    (select count(*) from wwv_flow_steps s where flow_id = p.flow_id and s.step_template = p.id) +
    (select count(*) from wwv_flow_themes where flow_id = p.flow_id and theme_id = p.theme_id and DEFAULT_PAGE_TEMPLATE = p.id) +
    (select count(*) from wwv_flow_themes where flow_id = p.flow_id and theme_id = p.theme_id and error_template=p.id) +
    (select count(*) from wwv_flow_themes where flow_id = p.flow_id and theme_id = p.theme_id and printer_friendly_template=p.id) reference_count,
    last_updated_on, last_updated_by, reference_id,
    (select count(*) from wwv_flow_themes where flow_id = p.flow_id and theme_id = p.theme_id and DEFAULT_PAGE_TEMPLATE=p.id) is_default,
    p.id preview,
    theme_id,
    id tid
from wwv_flow_templates p
union all
select
    flow_id,
    security_group_id,
    'REGION' template_type,
    PAGE_PLUG_TEMPLATE_NAME template_name,
    internal_name           internal_name,
    (select count(*) from wwv_flow_page_plugs p where flow_id = r.flow_id and p.PLUG_TEMPLATE = r.id) +
    (select count(*) from wwv_flow_themes where flow_id = r.flow_id and theme_id = r.theme_id and default_region_template = r.id) reference_count,
    last_updated_on,
    last_updated_by,
    reference_id,
    (select count(*) from wwv_flow_themes where flow_id = r.flow_id and theme_id = r.theme_id and default_region_template = r.id)  is_default,
    r.id preview,
    theme_id,
    id tid
from wwv_flow_page_plug_templates r
) x
where ff.workspace_id   = x.security_group_id
  and ff.application_id = x.flow_id
/

comment on table  apex_application_templates is 'Identifies reference counts for templates of all types';

comment on column apex_application_templates.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_templates.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_templates.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_templates.application_name  is 'Identifies the application';
comment on column apex_application_templates.THEME_number      is 'Identifies the numeric identifier of this theme to which this template is associated';
comment on column apex_application_templates.TEMPLATE_TYPE     is 'Identifies the Template Type';
comment on column apex_application_templates.TEMPLATE_NAME     is 'Name of the template';
comment on column apex_application_templates.INTERNAL_NAME     is 'Internal name of the template';
comment on column apex_application_templates.REFERENCE_COUNT   is 'Number of references to this template';
comment on column apex_application_templates.LAST_UPDATED_ON   is 'Date of last update';
comment on column apex_application_templates.LAST_UPDATED_BY   is 'APEX User Name who made the last update';
comment on column apex_application_templates.IS_SUBSCRIBED     is 'Identifies if this template is subscribed from another template';
comment on column apex_application_templates.IS_DEFAULT        is 'Identifies this template as the default template for new components created with a corresponding type';
comment on column apex_application_templates.TEMPLATE_ID       is 'Primary key of this component';






--------------------------------------------
-- S I T E   M A P
--
prompt ...apex_application_page_map

create or replace view apex_application_page_map as
select a.workspace,
       a.workspace_display_name,
       a.application_id,
       a.application_name,
       p.id                         page_id,
       p.name                       page_name,
       p.step_title                 page_title,
       --
       o1.short_name                breadcrumb,
       ltrim (
           o8.short_name||' > '||
           o7.short_name||' > '||
           o6.short_name||' > '||
           o5.short_name||' > '||
           o4.short_name||' > '||
           o3.short_name||' > '||
           o2.short_name||' > '||
           o1.short_name,
           ' >' )                   full_breadcrumb,
       help_text
from wwv_flow_authorized a,
     wwv_flow_steps p,
     ( select row_number() over (partition by p.security_group_id,
                                              p.flow_id,
                                              p.page_id
                                 order by p.id) rn,
              p.security_group_id,
              p.flow_id,
              p.page_id,
              o.short_name,
              o.menu_id,
              o.parent_id
         from wwv_flow_page_plugs p,
              wwv_flow_menu_options o
        where p.menu_id = o.menu_id
          and p.page_id = o.page_id ) o1,
     wwv_flow_menu_options o2,
     wwv_flow_menu_options o3,
     wwv_flow_menu_options o4,
     wwv_flow_menu_options o5,
     wwv_flow_menu_options o6,
     wwv_flow_menu_options o7,
     wwv_flow_menu_options o8
where a.workspace_id          = p.security_group_id
  and a.application_id        = p.flow_id
  and p.security_group_id     = o1.security_group_id(+)
  and p.flow_id               = o1.flow_id(+)
  and p.id                    = o1.page_id(+)
  and (o1.rn is null or o1.rn = 1)
  and o1.parent_id            = o2.id(+)
  and o1.flow_id              = o2.flow_id(+)
  and o2.parent_id            = o3.id(+)
  and o2.flow_id              = o3.flow_id(+)
  and o3.parent_id            = o4.id(+)
  and o3.flow_id              = o4.flow_id(+)
  and o4.parent_id            = o5.id(+)
  and o4.flow_id              = o5.flow_id(+)
  and o5.parent_id            = o6.id(+)
  and o5.flow_id              = o6.flow_id(+)
  and o6.parent_id            = o7.id(+)
  and o6.flow_id              = o7.flow_id(+)
  and o7.parent_id            = o8.id(+)
  and o7.flow_id              = o8.flow_id(+)
/

comment on table  apex_application_page_map                   is 'Identifies the full breadcrumb path for each page with a breadcrumb entry';
comment on column apex_application_page_map.workspace         is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_map.workspace_display_name is 'Display name for the workspace';
comment on column apex_application_page_map.application_id    is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_map.application_name  is 'Identifies the application';
comment on column apex_application_page_map.page_id           is 'Identifies the application';
comment on column apex_application_page_map.page_name         is 'Identifies a page within an application';

comment on column apex_application_page_map.PAGE_TITLE        is 'Identifies the Page Title';
comment on column apex_application_page_map.BREADCRUMB        is 'Identifies the corresponding Page Breadcrumb Entry Text';
comment on column apex_application_page_map.FULL_BREADCRUMB   is 'Identifies the full breadcrumb hierarchy';
comment on column apex_application_page_map.HELP_TEXT         is 'Identifies the help text associated with the page';


---------------------------------------------------
-- A P E X    D I C T I O N A R Y   C O M M E N T S
-- includes column and view names, view names have column id of zero
-- parent view name is used to display views in hierarchy

create or replace view apex_dictionary as
select apex_view_name,
       column_id,
       column_name,
       comments,
       comment_type,
       parent_view
from
(
select t.table_name   apex_view_name,
       t.column_id    column_id,
       t.column_name  column_name,
       c.comments     comments,
       'Column'       comment_type,
       case
         when        t.table_name      ='APEX_APPL_WEB_SRC_OPERATIONS'   then 'APEX_APPL_WEB_SRC_MODULES'
         when        t.table_name      ='APEX_APPL_WEB_SRC_PARAMETERS'   then 'APEX_APPL_WEB_SRC_OPERATIONS'
         when        t.table_name      ='APEX_APPL_WEB_SRC_COMP_PARAMS'  then 'APEX_APPL_WEB_SRC_PARAMETERS'
         when        t.table_name      ='APEX_APPLICATIONS'              then 'APEX_WORKSPACES'
         when        t.table_name      ='APEX_APPLICATION_LOV_ENTRIES'   then 'APEX_APPLICATION_LOVS'
         when        t.table_name      ='APEX_APPLICATION_LOV_COLS'      then 'APEX_APPLICATION_LOVS'
         when        t.table_name      ='APEX_APPLICATION_PAGE_ITEMS'    then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPLICATION_PAGE_BUTTONS'  then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPL_PAGE_FACETS'          then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPL_PLUGIN_ATTRIBUTES'    then 'APEX_APPL_PLUGINS'
         when        t.table_name      ='APEX_APPL_PLUGIN_STD_ATTRS'     then 'APEX_APPL_PLUGINS'
         when        t.table_name      ='APEX_APPL_PLUGIN_ATTR_VALUES'   then 'APEX_APPL_PLUGIN_ATTRIBUTES'
         when        t.table_name      ='APEX_APPL_PLUGIN_FILES'         then 'APEX_APPL_PLUGINS'
         when        t.table_name      ='APEX_APPL_PLUGIN_EVENTS'        then 'APEX_APPL_PLUGINS'
         when        t.table_name      ='APEX_APPL_PLUGIN_ITEM_FILTERS'  then 'APEX_APPL_PLUGINS'
         when        t.table_name      ='APEX_APPL_ACL_USER_ROLES'       then 'APEX_APPL_ACL_USERS'
         when        t.table_name      ='APEX_APPLICATION_LIST_ENTRIES'  then 'APEX_APPLICATION_LISTS'
         when        t.table_name      ='APEX_APPLICATION_RPT_QRY_STMTS' then 'APEX_APPLICATION_RPT_QUERIES'
         when        t.table_name      ='APEX_APPLICATION_TEMPLATES'     then 'APEX_APPLICATION_THEMES'
         when        t.table_name      ='APEX_APPLICATION_THEME_STYLES'  then 'APEX_APPLICATION_THEMES'
         when        t.table_name      ='APEX_APPLICATION_THEME_FILES'   then 'APEX_APPLICATION_THEMES'
         when        t.table_name      ='APEX_APPL_THEME_DISPLAY_POINTS' then 'APEX_APPLICATION_THEMES'
         when        t.table_name      ='APEX_APPL_TEMPLATE_OPTIONS'     then 'APEX_APPLICATION_THEMES'
         when        t.table_name      ='APEX_APPL_TEMPLATE_OPT_GROUPS'  then 'APEX_APPLICATION_THEMES'
         when        t.table_name      ='APEX_APPL_TEMP_PAGE_DP'         then 'APEX_APPLICATION_TEMP_PAGE'
         when        t.table_name      ='APEX_APPL_TEMP_REGION_DP'       then 'APEX_APPLICATION_TEMP_REGION'
         when substr(t.table_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'     then 'APEX_APPLICATION_SUPP_OBJECTS'
         when substr(t.table_name,1,18)='APEX_WORKSPACE_LOG'             then 'APEX_WORKSPACE_ACTIVITY_LOG'
         when substr(t.table_name,1,21)='APEX_APPLICATION_TEMP'          then 'APEX_APPLICATION_THEMES'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_APPLICATION_PAGE_RPT'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_RPT'      then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPLICATION_PAGE_REG_COLS' then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_FLASH5_S' then 'APEX_APPLICATION_PAGE_FLASH5'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_CHART_S'  then 'APEX_APPLICATION_PAGE_CHARTS'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_CHART_A'  then 'APEX_APPLICATION_PAGE_CHARTS'
         when substr(t.table_name,1,27)='APEX_APPLICATION_PAGE_TREES'    then 'APEX_APPLICATION_PAGE_TREES'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_COMP'  then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_COND'  then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_SUB'   then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_GRPBY' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_PIVOT' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_PVAGG' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_PVSRT' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_IR_'      then 'APEX_APPLICATION_PAGE_IR'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR'       then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_COLUMNS'      then 'APEX_APPL_PAGE_IGS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_COL_GROUPS'   then 'APEX_APPL_PAGE_IGS'
         when        t.table_name      = 'APEX_APPL_PAGE_IGS'             then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPTS'         then 'APEX_APPL_PAGE_IGS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_VIEWS'    then 'APEX_APPL_PAGE_IG_RPTS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_COMPUTES' then 'APEX_APPL_PAGE_IG_RPTS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_FILTERS'  then 'APEX_APPL_PAGE_IG_RPTS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_COLUMNS'  then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_HIGHLTS'  then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_AGGS'     then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_CHT_COLS' then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when substr(t.table_name,1,28)='APEX_APPLICATION_PAGE_FLASH5'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.table_name,1,27)='APEX_APPLICATION_PAGE_FLASH'    then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPLICATION_PAGE_CHARTS'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.table_name      ='APEX_APPLICATION_PAGE_DA_ACTS'  then 'APEX_APPLICATION_PAGE_DA'
         when substr(t.table_name,1,22)='APEX_APPLICATION_PAGE_'         then 'APEX_APPLICATION_PAGES'
         when substr(t.table_name,1,15)='APEX_WORKSPACE_'                then 'APEX_WORKSPACES'
         when substr(t.table_name,1,15)='APEX_APPL_PAGE_'                then 'APEX_APPLICATION_PAGES' --#14833918
         when substr(t.table_name,1,17)='APEX_APPLICATION_' or
              substr(t.table_name,1,10)='APEX_APPL_'                     then 'APEX_APPLICATIONS'
         when        t.table_name      ='APEX_TEAM_FEEDBACK_FOLLOWUP'    then 'APEX_TEAM_FEEDBACK'
         when substr(t.table_name,1,10)='APEX_TEAM_'                     then 'APEX_WORKSPACES'
         when substr(t.table_name,1,10)='APEX_REST_'                     then 'APEX_WORKSPACES'
         when        t.table_name      ='APEX_WS_APPLICATIONS'           then 'APEX_WORKSPACES'
         when        t.table_name      ='APEX_WS_APP_PAGES'              then 'APEX_WS_APPLICATIONS'
         when        t.table_name      ='APEX_WS_DATA_GRID'              then 'APEX_WS_APPLICATIONS'
         when        t.table_name      ='APEX_WS_DATA_GRID_COL'          then 'APEX_WS_DATA_GRID'
         when        t.table_name      ='APEX_APPL_LOAD_TABLE_LOOKUPS'   then 'APEX_APPL_LOAD_TABLES'
         when        t.table_name      ='APEX_APPL_LOAD_TABLE_RULES'     then 'APEX_APPL_LOAD_TABLES'
         when        t.table_name      ='APEX_APPL_CONCATENATED_FILES'   then 'APEX_APPL_USER_INTERFACES'
         end         parent_view,
       case
         when        t.table_name      ='APEX_WORKSPACES'                then null
         when        t.table_name      ='APEX_APPLICATIONS'              then 'APEX_WORKSPACES/'
         when        t.table_name      ='APEX_APPL_WEB_SRC_OPERATIONS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_WEB_SRC_MODULES/'
         when        t.table_name      ='APEX_APPL_WEB_SRC_PARAMETERS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_WEB_SRC_MODULES/APEX_APPL_WEB_SRC_OPERATIONS'
         when        t.table_name      ='APEX_APPL_WEB_SRC_COMP_PARAMS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_WEB_SRC_MODULES/APEX_APPL_WEB_SRC_OPERATIONS/APEX_APPL_WEB_SRC_PARAMETERS'
         when        t.table_name      ='APEX_APPLICATION_LOV_ENTRIES'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LOVS/'
         when        t.table_name      ='APEX_APPLICATION_LOV_COLS'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LOVS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_ITEMS'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_BUTTONS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPL_PAGE_FACETS'          then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPL_PLUGIN_ATTRIBUTES'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.table_name      ='APEX_APPL_PLUGIN_STD_ATTRS'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.table_name      ='APEX_APPL_PLUGIN_ATTR_VALUES'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/APEX_APPL_PLUGIN_ATTRIBUTES/'
         when        t.table_name      ='APEX_APPL_PLUGIN_FILES'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.table_name      ='APEX_APPL_PLUGIN_EVENTS'        then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.table_name      ='APEX_APPL_PLUGIN_ITEM_FILTERS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.table_name      ='APEX_APPL_ACL_USER_ROLES'       then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_ACL_USERS/'
         when        t.table_name      ='APEX_APPLICATION_LIST_ENTRIES'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LISTS/'
         when        t.table_name      ='APEX_APPLICATION_RPT_QRY_STMTS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_RPT_QUERIES'
         when        t.table_name      ='APEX_APPLICATION_TEMPLATES'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.table_name      ='APEX_APPLICATION_THEME_STYLES'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.table_name      ='APEX_APPLICATION_THEME_FILES'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.table_name      ='APEX_APPL_THEME_DISPLAY_POINTS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.table_name      ='APEX_APPL_TEMPLATE_OPTIONS'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.table_name      ='APEX_APPL_TEMPLATE_OPT_GROUPS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.table_name      ='APEX_APPL_TEMP_PAGE_DP'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/APEX_APPLICATION_TEMP_PAGE/'
         when        t.table_name      ='APEX_APPL_TEMP_REGION_DP'       then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/APEX_APPLICATION_TEMP_REGION/'
         when substr(t.table_name,1,18)='APEX_WORKSPACE_LOG'             then 'APEX_WORKSPACES/APEX_WORKSPACE_ACTIVITY_LOG/'
         when substr(t.table_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_SUPP_OBJECTS/'
         when substr(t.table_name,1,21)='APEX_APPLICATION_TEMP'          then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_RPT/'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_RPT'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_REG_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_FLASH5_S' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_FLASH5/'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_CHART_S'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_CHARTS/'
         when substr(t.table_name,1,30)='APEX_APPLICATION_PAGE_CHART_A'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_CHARTS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_COMP'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_COND'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_SUB'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_GRPBY' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_PIVOT' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_PVAGG' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR_PVSRT' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when substr(t.table_name,1,25)='APEX_APPLICATION_PAGE_IR_'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_IR'       then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_COLUMNS'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_COL_GROUPS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS'
         when        t.table_name      = 'APEX_APPL_PAGE_IGS'             then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPTS'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_VIEWS'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_COMPUTES' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_FILTERS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_COLUMNS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_HIGHLTS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_AGGS'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.table_name      = 'APEX_APPL_PAGE_IG_RPT_CHT_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when substr(t.table_name,1,28)='APEX_APPLICATION_PAGE_FLASH5'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.table_name,1,27)='APEX_APPLICATION_PAGE_FLASH'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_CHARTS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.table_name,1,27)='APEX_APPLICATION_PAGE_TREES'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.table_name      ='APEX_APPLICATION_PAGE_DA_ACTS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_DA/'
         when substr(t.table_name,1,22)='APEX_APPLICATION_PAGE_'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/'
         when substr(t.table_name,1,15)='APEX_APPL_PAGE_'                then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/'    --#14833918
         when substr(t.table_name,1,15)='APEX_WORKSPACE_'                then 'APEX_WORKSPACES/'
         when substr(t.table_name,1,17)='APEX_APPLICATION_'              then 'APEX_WORKSPACES/APEX_APPLICATIONS/'
         when        t.table_name      ='APEX_TEAM_FEEDBACK_FOLLOWUP'    then 'APEX_WORKSPACES/APEX_TEAM_FEEDBACK/'
         when substr(t.table_name,1,10)='APEX_TEAM_'                     then 'APEX_WORKSPACES/'
         when substr(t.table_name,1,10)='APEX_REST_'                     then 'APEX_WORKSPACES/'
         when        t.table_name      ='APEX_WS_APPLICATIONS'           then 'APEX_WORKSPACES/'
         when        t.table_name      ='APEX_WS_APP_PAGES'              then 'APEX_WORKSPACES/APEX_WS_APPLICATIONS/'
         when        t.table_name      ='APEX_WS_DATA_GRID'              then 'APEX_WORKSPACES/APEX_WS_APPLICATIONS/'
         when        t.table_name      ='APEX_WS_DATA_GRID_COL'          then 'APEX_WORKSPACES/APEX_WS_APPLICATIONS/APEX_WS_DATA_GRID/'
         when        t.table_name      ='APEX_APPL_LOAD_TABLE_LOOKUPS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_LOAD_TABLES/'
         when        t.table_name      ='APEX_APPL_LOAD_TABLE_RULES'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_LOAD_TABLES/'
         when        t.table_name      ='APEX_APPL_CONCATENATED_FILES'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_USER_INTERFACES/'
         when substr(t.table_name,1,10)='APEX_APPL_'                     then 'APEX_WORKSPACES/APEX_APPLICATIONS/'
         end ||t.table_name        path
from  sys.all_tab_columns t, sys.all_col_comments c
where t.owner = '^APPUN.' and
      t.owner = c.owner and
      t.table_name = c.table_name and
      t.column_Name = c.column_name and
      (t.table_name like 'APEX\_APPL\_%' escape '\'
      or t.table_name like 'APEX_APPLICATION%'
      or t.table_name like 'APEX_TEAM%'
      or t.table_name like 'APEX_REST%'
      or t.table_name like 'APEX_WORKSPACE%'
      or t.table_name like 'APEX_UI_DEFAULTS%'
      or t.table_name like 'APEX_WS%'
      or t.table_name like 'APEX_ISSUE%'
      or t.table_name in ('APEX_THEMES', 'APEX_WEBSERVICE_LOG', 'APEX_DEBUG_MESSAGES') ) and
      t.table_name != 'apex_dictionary'
union all
select t.view_name   apex_view_name,
       0             column_id,
       null          column_name,
       c.comments    apex_view_comments,
       'View'        comment_type,
       case
         when        t.view_name      ='APEX_APPLICATIONS'              then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_APPL_WEB_SRC_OPERATIONS'   then 'APEX_APPL_WEB_SRC_MODULES'
         when        t.view_name      ='APEX_APPL_WEB_SRC_PARAMETERS'   then 'APEX_APPL_WEB_SRC_OPERATIONS'
         when        t.view_name      ='APEX_APPL_WEB_SRC_COMP_PARAMS'  then 'APEX_APPL_WEB_SRC_PARAMETERS'
         when        t.view_name      ='APEX_APPLICATION_LOV_ENTRIES'   then 'APEX_APPLICATION_LOVS'
         when        t.view_name      ='APEX_APPLICATION_LOV_COLS'      then 'APEX_APPLICATION_LOVS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_ITEMS'    then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_BUTTONS'  then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPL_PAGE_FACETS'          then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPL_PLUGIN_ATTRIBUTES'    then 'APEX_APPL_PLUGINS'
         when        t.view_name      ='APEX_APPL_PLUGIN_STD_ATTRS'     then 'APEX_APPL_PLUGINS'
         when        t.view_name      ='APEX_APPL_PLUGIN_ATTR_VALUES'   then 'APEX_APPL_PLUGIN_ATTRIBUTES'
         when        t.view_name      ='APEX_APPL_PLUGIN_FILES'         then 'APEX_APPL_PLUGINS'
         when        t.view_name      ='APEX_APPL_PLUGIN_EVENTS'        then 'APEX_APPL_PLUGINS'
         when        t.view_name      ='APEX_APPL_PLUGIN_ITEM_FILTERS'  then 'APEX_APPL_PLUGINS'
         when        t.view_name      ='APEX_APPL_ACL_USER_ROLES'       then 'APEX_APPL_ACL_USERS'
         when        t.view_name      ='APEX_APPLICATION_LIST_ENTRIES'  then 'APEX_APPLICATION_LISTS'
         when        t.view_name      ='APEX_APPLICATION_RPT_QRY_STMTS' then 'APEX_APPLICATION_RPT_QUERIES'
         when        t.view_name      ='APEX_APPLICATION_TEMPLATES'     then 'APEX_APPLICATION_THEMES'
         when        t.view_name      ='APEX_APPLICATION_THEME_STYLES'  then 'APEX_APPLICATION_THEMES'
         when        t.view_name      ='APEX_APPLICATION_THEME_FILES'   then 'APEX_APPLICATION_THEMES'
         when        t.view_name      ='APEX_APPL_THEME_DISPLAY_POINTS' then 'APEX_APPLICATION_THEMES'
         when        t.view_name      ='APEX_APPL_TEMPLATE_OPTIONS'     then 'APEX_APPLICATION_THEMES'
         when        t.view_name      ='APEX_APPL_TEMPLATE_OPT_GROUPS'  then 'APEX_APPLICATION_THEMES'
         when        t.view_name      ='APEX_APPL_TEMP_PAGE_DP'         then 'APEX_APPLICATION_TEMP_PAGE'
         when        t.view_name      ='APEX_APPL_TEMP_REGION_DP'       then 'APEX_APPLICATION_TEMP_REGION'
         when substr(t.view_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'     then 'APEX_APPLICATION_SUPP_OBJECTS'
         when substr(t.view_name,1,18)='APEX_WORKSPACE_LOG'             then 'APEX_WORKSPACE_ACTIVITY_LOG'
         when substr(t.view_name,1,21)='APEX_APPLICATION_TEMP'          then 'APEX_APPLICATION_THEMES'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_APPLICATION_PAGE_RPT'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_RPT'      then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_REG_COLS' then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_FLASH5_S' then 'APEX_APPLICATION_PAGE_FLASH5'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_CHART_S'  then 'APEX_APPLICATION_PAGE_CHARTS'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_CHART_A'  then 'APEX_APPLICATION_PAGE_CHARTS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_COMP'  then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_COND'  then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_SUB'   then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_GRPBY' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_PIVOT' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_PVAGG' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_PVSRT' then 'APEX_APPLICATION_PAGE_IR_RPT'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_IR_'      then 'APEX_APPLICATION_PAGE_IR'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR'       then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_COLUMNS'      then 'APEX_APPL_PAGE_IGS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_COL_GROUPS'   then 'APEX_APPL_PAGE_IGS'
         when        t.view_name      = 'APEX_APPL_PAGE_IGS'             then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPTS'         then 'APEX_APPL_PAGE_IGS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_VIEWS'    then 'APEX_APPL_PAGE_IG_RPTS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_COMPUTES' then 'APEX_APPL_PAGE_IG_RPTS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_FILTERS'  then 'APEX_APPL_PAGE_IG_RPTS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_COLUMNS'  then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_HIGHLTS'  then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_AGGS'     then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_CHT_COLS' then 'APEX_APPL_PAGE_IG_RPT_VIEWS'
         when substr(t.view_name,1,28)='APEX_APPLICATION_PAGE_FLASH5'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.view_name,1,27)='APEX_APPLICATION_PAGE_FLASH'    then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_CHARTS'   then 'APEX_APPLICATION_PAGE_REGIONS'
         when substr(t.view_name,1,27)='APEX_APPLICATION_PAGE_TREES'    then 'APEX_APPLICATION_PAGE_REGIONS'
         when        t.view_name      ='APEX_APPLICATION_PAGE_DA_ACTS'  then 'APEX_APPLICATION_PAGE_DA'
         when substr(t.view_name,1,22)='APEX_APPLICATION_PAGE_'         then 'APEX_APPLICATION_PAGES'
         when substr(t.view_name,1,15)='APEX_WORKSPACE_'                then 'APEX_WORKSPACES'
         when substr(t.view_name,1,15)='APEX_APPL_PAGE_'                then 'APEX_APPLICATION_PAGES'       --#14833918
         when substr(t.view_name,1,17)='APEX_APPLICATION_' or
              substr(t.view_name,1,10)='APEX_APPL_'                     then 'APEX_APPLICATIONS'
         when        t.view_name      ='APEX_TEAM_FEEDBACK_FOLLOWUP'    then 'APEX_TEAM_FEEDBACK'
         when substr(t.view_name,1,10)='APEX_TEAM_'                     then 'APEX_WORKSPACES'
         when substr(t.view_name,1,10)='APEX_REST_'                     then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_WS_APPLICATIONS'           then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_WS_APP_PAGES'              then 'APEX_WS_APPLICATIONS'
         when        t.view_name      ='APEX_WS_DATA_GRID'              then 'APEX_WS_APPLICATIONS'
         when        t.view_name      ='APEX_WS_DATA_GRID_COL'          then 'APEX_WS_DATA_GRID'
         when        t.view_name      ='APEX_APPL_LOAD_TABLE_LOOKUPS'   then 'APEX_APPL_LOAD_TABLES'
         when        t.view_name      ='APEX_APPL_LOAD_TABLE_RULES'     then 'APEX_APPL_LOAD_TABLES'
         when        t.view_name      ='APEX_APPL_CONCATENATED_FILES'   then 'APEX_APPL_USER_INTERFACES'
         when        t.view_name      ='APEX_ISSUES'                    then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_ISSUE_EVENTS'              then 'APEX_ISSUES'
         when        t.view_name      ='APEX_ISSUE_COMMENTS'            then 'APEX_ISSUES'
         when        t.view_name      ='APEX_ISSUE_ATTACHMENTS'         then 'APEX_ISSUES'
         when        t.view_name      ='APEX_ISSUE_STAKEHOLDERS'        then 'APEX_ISSUES'
         when        t.view_name      ='APEX_ISSUE_MILESTONES'          then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_ISSUE_LABEL_GROUPS'        then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_ISSUE_LABELS'              then 'APEX_ISSUE_LABEL_GROUPS'
         when        t.view_name      ='APEX_ISSUE_LABEL_RELATION'      then 'APEX_ISSUES'
         when        t.view_name      ='APEX_ISSUE_MILESTONE_RELATION'  then 'APEX_ISSUES'
         when        t.view_name      ='APEX_ISSUE_EMAIL_PREFS'         then 'APEX_WORKSPACES'
         when        t.view_name      ='APEX_ISSUE_NOTIFICATIONS'       then 'APEX_ISSUES'
         end         parent_view,
       case
         when        t.view_name      ='APEX_WORKSPACES'                then null
         when        t.view_name      ='APEX_APPLICATIONS'              then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_APPL_WEB_SRC_OPERATIONS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_WEB_SRC_MODULES/'
         when        t.view_name      ='APEX_APPL_WEB_SRC_PARAMETERS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_WEB_SRC_MODULES/APEX_APPL_WEB_SRC_OPERATIONS'
         when        t.view_name      ='APEX_APPL_WEB_SRC_COMP_PARAMS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_WEB_SRC_MODULES/APEX_APPL_WEB_SRC_OPERATIONS/APEX_APPL_WEB_SRC_PARAMETERS'
         when        t.view_name      ='APEX_APPLICATION_LOV_ENTRIES'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LOVS/'
         when        t.view_name      ='APEX_APPLICATION_LOV_COLS'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LOVS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_ITEMS'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_BUTTONS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPL_PAGE_FACETS'          then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPL_PLUGIN_ATTRIBUTES'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.view_name      ='APEX_APPL_PLUGIN_STD_ATTRS'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.view_name      ='APEX_APPL_PLUGIN_ATTR_VALUES'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/APEX_APPL_PLUGIN_ATTRIBUTES/'
         when        t.view_name      ='APEX_APPL_PLUGIN_FILES'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.view_name      ='APEX_APPL_PLUGIN_EVENTS'        then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.view_name      ='APEX_APPL_PLUGIN_ITEM_FILTERS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_PLUGINS/'
         when        t.view_name      ='APEX_APPL_ACL_USER_ROLES'       then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_ACL_USERS/'
         when        t.view_name      ='APEX_APPLICATION_LIST_ENTRIES'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_LISTS/'
         when        t.view_name      ='APEX_APPLICATION_RPT_QRY_STMTS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_RPT_QUERIES/'
         when        t.view_name      ='APEX_APPLICATION_TEMPLATES'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.view_name      ='APEX_APPLICATION_THEME_STYLES'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.view_name      ='APEX_APPLICATION_THEME_FILESS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.view_name      ='APEX_APPL_THEME_DISPLAY_POINTS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.view_name      ='APEX_APPL_TEMPLATE_OPTIONS'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.view_name      ='APEX_APPL_TEMPLATE_OPT_GROUPS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when        t.view_name      ='APEX_APPL_TEMP_PAGE_DP'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/APEX_APPLICATION_TEMP_PAGE/'
         when        t.view_name      ='APEX_APPL_TEMP_REGION_DP'       then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/APEX_APPLICATION_TEMP_REGION/'
         when substr(t.view_name,1,18)='APEX_WORKSPACE_LOG'             then 'APEX_WORKSPACES/APEX_WORKSPACE_ACTIVITY_LOG/'
         when substr(t.view_name,1,26)='APEX_APPLICATION_SUPP_OBJ_'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_SUPP_OBJECTS/'
         when substr(t.view_name,1,21)='APEX_APPLICATION_TEMP'          then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_THEMES/'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_RPT_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_RPT/'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_RPT'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_REG_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_FLASH5_S' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_FLASH5/'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_CHART_S'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_CHARTS/'
         when substr(t.view_name,1,30)='APEX_APPLICATION_PAGE_CHART_A'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_CHARTS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_COMP'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_COND'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_SUB'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_GRPBY' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_PIVOT' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_PVAGG' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR_PVSRT' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/APEX_APPLICATION_PAGE_IR_RPT'
         when substr(t.view_name,1,25)='APEX_APPLICATION_PAGE_IR_'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPLICATION_PAGE_IR/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_IR'       then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_COLUMNS'      then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_COL_GROUPS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS'
         when        t.view_name      = 'APEX_APPL_PAGE_IGS'             then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPTS'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_VIEWS'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_COMPUTES' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_FILTERS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_COLUMNS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_HIGHLTS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_AGGS'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when        t.view_name      = 'APEX_APPL_PAGE_IG_RPT_CHT_COLS' then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/APEX_APPL_PAGE_IGS/APEX_APPL_PAGE_IG_RPTS/APEX_APPL_PAGE_IG_RPT_VIEWS'
         when substr(t.view_name,1,28)='APEX_APPLICATION_PAGE_FLASH5'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.view_name,1,27)='APEX_APPLICATION_PAGE_FLASH'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_CHARTS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when substr(t.view_name,1,27)='APEX_APPLICATION_PAGE_TREES'    then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_REGIONS/'
         when        t.view_name      ='APEX_APPLICATION_PAGE_DA_ACTS'  then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/APEX_APPLICATION_PAGE_DA/'
         when substr(t.view_name,1,22)='APEX_APPLICATION_PAGE_'         then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/'
         when substr(t.view_name,1,15)='APEX_WORKSPACE_'                then 'APEX_WORKSPACES/'
         when substr(t.view_name,1,17)='APEX_APPLICATION_'              then 'APEX_WORKSPACES/APEX_APPLICATIONS/'
         when substr(t.view_name,1,15)='APEX_APPL_PAGE_'                then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPLICATION_PAGES/'     --#14833918
         when substr(t.view_name,1,10)='APEX_APPL_'                     then 'APEX_WORKSPACES/APEX_APPLICATIONS/'
         when        t.view_name      ='APEX_TEAM_FEEDBACK_FOLLOWUP'    then 'APEX_WORKSPACES/APEX_TEAM_FEEDBACK/'
         when substr(t.view_name,1,10)='APEX_TEAM_'                     then 'APEX_WORKSPACES/'
         when substr(t.view_name,1,10)='APEX_REST_'                     then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_WS_APPLICATIONS'           then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_WS_APP_PAGES'              then 'APEX_WORKSPACES/APEX_WS_APPLICATIONS/'
         when        t.view_name      ='APEX_WS_DATA_GRID'              then 'APEX_WORKSPACES/APEX_WS_APPLICATIONS/'
         when        t.view_name      ='APEX_WS_DATA_GRID_COL'          then 'APEX_WORKSPACES/APEX_WS_APPLICATIONS/APEX_WS_DATA_GRID/'
         when        t.view_name      ='APEX_APPL_LOAD_TABLE_LOOKUPS'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_LOAD_TABLES/'
         when        t.view_name      ='APEX_APPL_LOAD_TABLE_RULES'     then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_LOAD_TABLES/'
         when        t.view_name      ='APEX_APPL_CONCATENATED_FILES'   then 'APEX_WORKSPACES/APEX_APPLICATIONS/APEX_APPL_USER_INTERFACES/'
         when substr(t.view_name,1,10)='APEX_APPL_'                     then 'APEX_WORKSPACES/APEX_APPLICATIONS/'
         when        t.view_name      ='APEX_ISSUES'                    then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_ISSUE_EVENTS'              then 'APEX_WORKSPACES/APEX_ISSUES/'
         when        t.view_name      ='APEX_ISSUE_COMMENTS'            then 'APEX_WORKSPACES/APEX_ISSUES/'
         when        t.view_name      ='APEX_ISSUE_ATTACHMENTS'         then 'APEX_WORKSPACES/APEX_ISSUES/'
         when        t.view_name      ='APEX_ISSUE_STAKEHOLDERS'        then 'APEX_WORKSPACES/APEX_ISSUES/'
         when        t.view_name      ='APEX_ISSUE_MILESTONES'          then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_ISSUE_LABEL_GROUPS'        then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_ISSUE_LABELS'              then 'APEX_WORKSPACES/APEX_ISSUE_LABEL_GROUPS/'
         when        t.view_name      ='APEX_ISSUE_LABEL_RELATION'      then 'APEX_WORKSPACES/APEX_ISSUES/'
         when        t.view_name      ='APEX_ISSUE_MILESTONE_RELATION'  then 'APEX_WORKSPACES/APEX_ISSUES/'
         when        t.view_name      ='APEX_ISSUE_EMAIL_PREFS'         then 'APEX_WORKSPACES/'
         when        t.view_name      ='APEX_ISSUE_NOTIFICATIONS'       then 'APEX_WORKSPACES/APEX_ISSUES/'
         end ||t.view_name        path
from  sys.all_views t, sys.all_tab_comments c
where t.owner = '^APPUN.' and
      t.owner = c.owner and
      t.view_name = c.table_name and
      (t.view_name like 'APEX\_APPL\_%' escape '\'
      or t.view_name like 'APEX_APPLICATION%'
      or t.view_name like 'APEX_WORKSPACE%'
      or t.view_name like 'APEX_TEAM%'
      or t.view_name like 'APEX_REST%'
      or t.view_name like 'APEX_UI_DEFAULTS%'
      or t.view_name like 'APEX_WS%'
      or t.view_name like 'APEX_ISSUE%'
      or t.view_name in ('APEX_THEMES', 'APEX_WEBSERVICE_LOG', 'APEX_DEBUG_MESSAGES') )
order by 7,2
) x
/

comment on table apex_dictionary is 'Identifies the comment associated with each APEX view and view column';
comment on column apex_dictionary.APEX_VIEW_NAME is 'Name of the APEX dictionary view';
comment on column apex_dictionary.COLUMN_ID      is 'Display order of the APEX dictionary column within the dictionary view';
comment on column apex_dictionary.COLUMN_NAME    is 'Identifies the column name for column dictionary comments, null for view dictionary comments';
comment on column apex_dictionary.COMMENTS       is 'Description of the APEX view name or column name';
comment on column apex_dictionary.COMMENT_TYPE   is 'Type of dictionary comment, View or Column';
comment on column apex_dictionary.parent_view    is 'Identifies the component parent';


----------------------------------------------
-- A C T I V I T Y    V I E W S
--
prompt ...activity views

create or replace view apex_workspace_access_log as
select
    w.workspace,
    w.workspace_display_name,
    l.APPLICATION            application_id,
    f.name                   application_name,
    upper(l.LOGIN_NAME)      user_name,
    l.AUTHENTICATION_METHOD  authentication_method,
    l.OWNER                  application_schema_owner,
    l.ACCESS_DATE,
    86400 * (sysdate - l.access_date) seconds_ago,
    l.IP_ADDRESS,
    --l.REMOTE_USER,
    decode(nvl(l.authentication_result,0),
        0,'AUTH_SUCCESS',
        1,'AUTH_UNKNOWN_USER',
        2,'AUTH_ACCOUNT_LOCKED',
        3,'AUTH_ACCOUNT_EXPIRED',
        4,'AUTH_PASSWORD_INCORRECT',
        5,'AUTH_PASSWORD_FIRST_USE',
        6,'AUTH_ATTEMPTS_EXCEEDED',
        7,'AUTH_INTERNAL_ERROR',
        authentication_result) authentication_result,
    l.CUSTOM_STATUS_TEXT       custom_status_text,
    l.SECURITY_GROUP_ID        workspace_id
from wwv_flow_user_access_log_v  l,
     wwv_flows                   f,
     wwv_flow_current_workspaces w
where l.security_group_id = w.workspace_id
  and l.application       = f.id(+)
  and l.security_group_id = f.security_group_id(+)
/

comment on table  apex_workspace_access_log                          is 'One row is logged for each login attempt.';
comment on column apex_workspace_access_log.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_access_log.workspace_display_name   is 'Display name for the workspace';
comment on column apex_workspace_access_log.application_id           is 'Application Primary Key, Unique over all workspaces';
comment on column apex_workspace_access_log.application_name         is 'Name of Application';
comment on column apex_workspace_access_log.user_name                is 'Identifies the Application Express username';
comment on column apex_workspace_access_log.authentication_method    is 'Identifies the authentication method';
comment on column apex_workspace_access_log.application_schema_owner is 'Identifies the parse as schema owner for the application';
comment on column apex_workspace_access_log.custom_status_text       is 'Identifies the status of the authentication attempt';
comment on column apex_workspace_access_log.access_date              is 'Date of login attempt';
comment on column apex_workspace_access_log.ip_address               is 'IP Address of user';
comment on column apex_workspace_access_log.AUTHENTICATION_RESULT    is 'Status of authentication attempt';
comment on column apex_workspace_access_log.workspace_id             is 'Workspace numeric identifier';
comment on column apex_workspace_access_log.seconds_ago              is 'Elapsed seconds since event occured';


create or replace view apex_workspace_activity_log as
    select
           w.workspace,
           w.workspace_display_name,
           l.userid                  apex_user,
           l.flow_id                 application_id,
           f.name                    application_name,
           f.owner                   application_schema_owner,
           l.step_id                 page_id,
           (select name
            from wwv_flow_steps
            where id = l.step_id and
                  flow_id = f.id)    page_name,
           l.time_stamp              view_date,
           to_number(null)           think_time,
           round(86400 * (sysdate - l.time_stamp))     seconds_ago,
           --l.component_type          component_type,
           --l.component_name          component_name,
           (select upper(name)
            from wwv_flow_steps
            where id = l.step_id and
                  flow_id = f.id)    log_context,
           --l.information             page_view_information,
           l.elap                    elapsed_time,
           l.num_rows                rows_queried,
           l.ip_address              ip_address,
           l.USER_AGENT              agent,
           l.session_id              apex_session_id,
           l.tenant_id               application_tenant_id,
           l.sqlerrm                 error_message,
           l.sqlerrm_component_type  error_on_component_type,
           l.sqlerrm_component_name  error_on_component_name,
           decode(l.page_mode,
             'D','Dynamic',
             'C','Cache Created',
             'R','Cached',
             'P','Partial Page',
             'A','Page Processing',
             l.page_mode)            page_view_mode,
           null application_info,
           -- ir log
           l.worksheet_id            interactive_report_id,
           l.ir_report_id            ir_saved_report_id,
           l.ir_search               ir_search,
           -- websheet log
           l.websheet_id             ws_application_id,
           l.webpage_id              ws_page_id,
           l.datagrid_id             ws_datagrid_id,
           --
           l.content_length,
           --
           nvl(l.cached_regions,0)   regions_from_cache,
           l.security_group_id       workspace_id,
           --
           case l.page_view_type
           when 0 then 'Other'
           when 1 then 'Processing'
           when 2 then 'Rendering'
           when 3 then 'Ajax'
           when 4 then 'Logout'
           when 5 then 'Authentication Callback'
           end                       page_view_type,
           l.request_value,
           l.debug_page_view_id,
           l.time_stamp_tz           view_timestamp,
           l.ecid
from wwv_flow_activity_log       l,
     wwv_flow_current_workspaces w,
     wwv_flows                   f
where l.security_group_id = w.workspace_id
  and l.security_group_id = f.security_group_id(+)
  and l.flow_id           = f.id(+)
/

comment on table  apex_workspace_activity_log                          is 'Page view activity log detail.  One row is logged for each page view for application with logging enabled.';
comment on column apex_workspace_activity_log.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_activity_log.workspace_display_name   is 'Display name for the workspace';
comment on column apex_workspace_activity_log.application_id           is 'Application Primary Key, Unique over all workspaces';
comment on column apex_workspace_activity_log.application_name         is 'Identifies the application';
comment on column apex_workspace_activity_log.page_id                  is 'ID of the application page';
comment on column apex_workspace_activity_log.page_name                is 'Name of the application page';
comment on column apex_workspace_activity_log.view_date                is 'Date of page view with precision to the second (indexed)';
comment on column apex_workspace_activity_log.log_context              is 'Context of Page View';
comment on column apex_workspace_activity_log.ELAPSED_TIME             is 'Elapsed time to generate page source';
comment on column apex_workspace_activity_log.ROWS_QUERIED             is 'Number of rows fetched by the APEX reporting engine';
comment on column apex_workspace_activity_log.IP_ADDRESS               is 'IP Address for this page view';
comment on column apex_workspace_activity_log.AGENT                    is 'HTTP User Agent for this page view';
comment on column apex_workspace_activity_log.APEX_SESSION_ID          is 'APEX Session ID for this page view';
comment on column apex_workspace_activity_log.application_tenant_id    is 'Application Tenant ID for this page view';
comment on column apex_workspace_activity_log.ERROR_MESSAGE            is 'Error message raised for this page view';
comment on column apex_workspace_activity_log.ERROR_ON_COMPONENT_TYPE  is 'The component type that caused an error to be raised';
comment on column apex_workspace_activity_log.ERROR_ON_COMPONENT_NAME  is 'The component name which caused the error to be raised';
comment on column apex_workspace_activity_log.PAGE_VIEW_MODE           is 'The page view mode, typically Static or Dynamic';
comment on column apex_workspace_activity_log.apex_user                is 'Name of the end user of the application';
comment on column apex_workspace_activity_log.application_schema_owner is 'Parsing Schema of the Application';
comment on column apex_workspace_activity_log.regions_from_cache       is 'Count of regions on this page that are rendered from cache';
comment on column apex_workspace_activity_log.think_time               is 'Always NULL - see APEX 5.2 Release Notes, Changed Behavior';
comment on column apex_workspace_activity_log.application_info         is 'Information provided by the application to provide additional application context';
comment on column apex_workspace_activity_log.interactive_report_id    is 'Identifies the Interactive Report ID foreign key to the APEX_APPLICATION_PAGE_IR view';
comment on column apex_workspace_activity_log.ir_saved_report_id       is 'Identifies the Saved Interactive Report ID foreign key to the APEX_APPLICATION_PAGE_IR_RPT view';
comment on column apex_workspace_activity_log.ir_search                is 'The search text entered from Interactive Report search bar';
comment on column apex_workspace_activity_log.ws_application_id        is 'Websheet application primary key, unique over all workspaces';
comment on column apex_workspace_activity_log.ws_page_id               is 'ID of the Websheet application page';
comment on column apex_workspace_activity_log.ws_datagrid_id           is 'ID of the Websheet application Data Grid';
comment on column apex_workspace_activity_log.workspace_id             is 'Primary Key of the Workspace';
comment on column apex_workspace_activity_log.content_length           is 'The size of the web page served.';
comment on column apex_workspace_activity_log.page_view_type           is 'The type of page view (Rendering, Processing, Ajax, Logout, Authentication callback, Other)';
comment on column apex_workspace_activity_log.request_value            is 'The value of the request parameter for this page view';
comment on column apex_workspace_activity_log.debug_page_view_id       is 'The ID for debug messages stored for this page view';
comment on column apex_workspace_activity_log.view_timestamp           is 'The timestamp with time zone of the page view (not indexed)';
comment on column apex_workspace_activity_log.ecid                     is 'The web server''s Execution Context ID of the page view';


create or replace view apex_workspace_log_summary as
    select
           w.workspace,
           w.workspace_display_name,
           l.flow_id                              application_id,
           f.name                                 application_name,
           count(*)                               page_views,
           count(distinct l.step_id)              distinct_pages,
           sum(l.elap)                            total_elapsed_time,
           avg(l.elap)                            average_elapsed_time,
           min(l.elap)                            minimum_elapsed_time,
           max(l.elap)                            maximum_elapsed_time,
           sum(l.num_rows)                        total_rows_queried,
           count(distinct l.ip_address)           ip_addresses,
           count(distinct l.USER_AGENT)           agents,
           count(distinct l.session_id)           apex_sessions,
           sum(decode(l.sqlerrm,null,0,1))        page_views_with_errors,
           sum(decode(l.page_mode,'D',1,'C',1,0)) dynamic_page_views,
           sum(decode(l.page_mode,'R',1,0))       cached_page_views,
           min(l.time_stamp)                      first_view,
           max(l.time_stamp)                      last_view,
           max(l.time_stamp)-min(l.time_stamp)    period_in_days
from wwv_flow_activity_log       l,
     wwv_flows                   f,
     wwv_flow_current_workspaces w
where l.security_group_id = w.workspace_id
  and l.security_group_id = f.security_group_id(+)
  and l.flow_id           = f.id(+)
  and l.time_stamp        > sysdate - 14
group by w.workspace_name, w.workspace_display_name, l.flow_id, f.name
/


comment on table  apex_workspace_log_summary is 'Page view activity log summarized by application for the last 14 days';
comment on column apex_workspace_log_summary.WORKSPACE                is 'Workspace for which this page view log was recorded';
comment on column apex_workspace_log_summary.workspace_display_name   is 'Display name for the workspace';
comment on column apex_workspace_log_summary.APPLICATION_ID           is 'Application ID for which this page view log was recorded';
comment on column apex_workspace_log_summary.APPLICATION_NAME         is 'Application Name for which this page view log was recorded';
comment on column apex_workspace_log_summary.PAGE_VIEWS               is 'Page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.DISTINCT_PAGES           is 'Distinct page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.TOTAL_ELAPSED_TIME       is 'Total elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.AVERAGE_ELAPSED_TIME     is 'Average elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.MINIMUM_ELAPSED_TIME     is 'Minimum elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.MAXIMUM_ELAPSED_TIME     is 'Maximum elapsed time generating page source aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.TOTAL_ROWS_QUERIED       is 'Total rows queried by the APEX reporting engine aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.IP_ADDRESSES             is 'Distinct IP addresses aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.AGENTS                   is 'Distinct User Agents aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.APEX_SESSIONS            is 'Count of sessions aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.PAGE_VIEWS_WITH_ERRORS   is 'Count of page views generating error text aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.DYNAMIC_PAGE_VIEWS       is 'Count of dynamic page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.CACHED_PAGE_VIEWS        is 'Count of static page views aggregated by Workspace and Application';
comment on column apex_workspace_log_summary.FIRST_VIEW               is 'First logged page by Workspace and Application';
comment on column apex_workspace_log_summary.LAST_VIEW                is 'Most recently logged page by Workspace and Application';
comment on column apex_workspace_log_summary.PERIOD_IN_DAYS           is 'Period in days between first logged page view and most recent page view';


create or replace view apex_workspace_log_summary_usr as
    select
           w.workspace,
           w.workspace_display_name,
           nvl(l.userid,'PUBLIC')                 apex_user,
           count(distinct l.flow_id)              applications,
           count(*)                               page_views,
           count(distinct l.flow_id||'.'||l.step_id) distinct_pages,
           sum(l.elap)                            total_elapsed_time,
           avg(l.elap)                            average_elapsed_time,
           min(l.elap)                            minimum_elapsed_time,
           max(l.elap)                            maximum_elapsed_time,
           sum(l.num_rows)                        total_rows_queried,
           count(distinct l.ip_address)           distinct_ip_addresses,
           count(distinct l.USER_AGENT)           distinct_agents,
           count(distinct l.session_id)           distinct_apex_sessions,
           sum(decode(l.sqlerrm,null,0,1))        page_views_with_errors,
           sum(decode(l.page_mode,'D',1,'C',1,0)) dynamic_page_views,
           sum(decode(l.page_mode,'R',1,0))       cached_page_views,
           min(l.time_stamp)                      first_view,
           max(l.time_stamp)                      last_view,
           max(l.time_stamp)-min(l.time_stamp)    period_in_days,
           --
           sum(decode(greatest(s.the_date - (1/1440),l.time_stamp),l.time_stamp,1,0) )  last_1_minute,
           sum(decode(greatest(s.the_date - (5/1440),l.time_stamp),l.time_stamp,1,0) )  last_5_minutes,
           sum(decode(greatest(s.the_date - (10/1440),l.time_stamp),l.time_stamp,1,0) ) last_10_minutes,
           sum(decode(greatest(s.the_date - (15/1440),l.time_stamp),l.time_stamp,1,0) ) last_15_minutes,
           sum(decode(greatest(s.the_date - (30/1440),l.time_stamp),l.time_stamp,1,0) ) last_30_minutes,
           sum(decode(greatest(s.the_date - (1/24),l.time_stamp),l.time_stamp,1,0) )    last_1_hour,
           sum(decode(greatest(s.the_date - (2/24),l.time_stamp),l.time_stamp,1,0) )    last_2_hours,
           sum(decode(greatest(s.the_date - (6/24),l.time_stamp),l.time_stamp,1,0) )    last_6_hours,
           sum(decode(greatest(s.the_date - (2/24),l.time_stamp),l.time_stamp,1,0) )    last_12_hours,
           sum(decode(greatest(s.the_date - 1,l.time_stamp),l.time_stamp,1,0)      )    last_24_hours,
           sum(decode(greatest(s.the_date - 2,l.time_stamp),l.time_stamp,1,0)      )    last_48_hours,
           sum(decode(greatest(s.the_date - 7,l.time_stamp),l.time_stamp,1,0)      )    last_7_days,
           sum(decode(greatest(s.the_date - 14,l.time_stamp),l.time_stamp,1,0)     )    last_14_days,
           --
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'01',1,0),0))  today_HH01,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'02',1,0),0))  today_HH02,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'03',1,0),0))  today_HH03,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'04',1,0),0))  today_HH04,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'05',1,0),0))  today_HH05,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'06',1,0),0))  today_HH06,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'07',1,0),0))  today_HH07,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'08',1,0),0))  today_HH08,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'09',1,0),0))  today_HH09,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'10',1,0),0))  today_HH10,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'11',1,0),0))  today_HH11,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'12',1,0),0))  today_HH12,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'13',1,0),0))  today_HH13,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'14',1,0),0))  today_HH14,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'15',1,0),0))  today_HH15,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'16',1,0),0))  today_HH16,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'17',1,0),0))  today_HH17,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'18',1,0),0))  today_HH18,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'19',1,0),0))  today_HH19,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'20',1,0),0))  today_HH20,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'21',1,0),0))  today_HH21,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'22',1,0),0))  today_HH22,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'23',1,0),0))  today_HH23,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,decode(to_char(l.time_stamp,'HH24'),'24',1,0),0))  today_HH24,
           sum(decode(greatest(trunc(s.the_date),l.time_stamp),l.time_stamp,1,0))                                              today
from wwv_flow_activity_log       l,
     wwv_flow_current_workspaces w,
     wwv_flows                   f,
     (select sysdate the_date from sys.dual) s
where l.security_group_id = w.workspace_id
  and l.security_group_id = f.security_group_id (+)
  and l.flow_id           = f.id (+)
  and l.time_stamp        > sysdate - 14
group by w.workspace_name, w.workspace_display_name, nvl(l.userid,'PUBLIC')
/

comment on table apex_workspace_log_summary_usr is 'Page view activity log summarized by user for the last two weeks';
comment on column apex_workspace_log_summary_usr.WORKSPACE                      is 'Name of Workspace that generated the page view log entry';
comment on column apex_workspace_log_summary_usr.workspace_display_name         is 'Display name for the workspace';
comment on column apex_workspace_log_summary_usr.APEX_USER                      is 'Name of the APEX User name associated with the page view log entry';
comment on column apex_workspace_log_summary_usr.APPLICATIONS                   is 'Number of applications contained in the aggregation by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.PAGE_VIEWS                     is 'Page views aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_PAGES                 is 'Distinct page views aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.TOTAL_ELAPSED_TIME             is 'Total elapsed time logged aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.AVERAGE_ELAPSED_TIME           is 'Average elapsed time logged aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.MINIMUM_ELAPSED_TIME           is 'Minimum elapsed time logged aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.MAXIMUM_ELAPSED_TIME           is 'Maximum elapsed time aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.TOTAL_ROWS_QUERIED             is 'Total rows queried by the APEX reporting engine aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_IP_ADDRESSES          is 'Distinct IP addresses aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_AGENTS                is 'Distinct User Agents aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DISTINCT_APEX_SESSIONS         is 'Distinct APEX Sessions aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.PAGE_VIEWS_WITH_ERRORS         is 'Count of page views with recorded errors aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.DYNAMIC_PAGE_VIEWS             is 'Count of dynamic page views aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.CACHED_PAGE_VIEWS              is 'Count of cached page views aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.FIRST_VIEW                     is 'Date of first page view by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_VIEW                      is 'Date of most recent page view by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.PERIOD_IN_DAYS                 is 'Period in days between the first recorded page view an the most recent page view';
comment on column apex_workspace_log_summary_usr.LAST_1_MINUTE                  is 'Page views recorded in the last 1 minute aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_5_MINUTES                 is 'Page views recorded in the last 5 minutes aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_10_MINUTES                is 'Page views recorded in the last 10 minutes aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_15_MINUTES                is 'Page views recorded in the last 15 minutes aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_30_MINUTES                is 'Page views recorded in the last 30 minutes aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_1_HOUR                    is 'Page views recorded in the last 1 hour aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_2_HOURS                   is 'Page views recorded in the last 2 hours aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_6_HOURS                   is 'Page views recorded in the last 6 hours aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_12_HOURS                  is 'Page views recorded in the last 12 hours aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_24_HOURS                  is 'Page views recorded in the last 24 hours aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_48_HOURS                  is 'Page views recorded in the last 48 hours aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_7_DAYS                    is 'Page views recorded in the last 7 days aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.LAST_14_DAYS                   is 'Page views recorded in the last 14 days aggregated by APEX User Name and Workspace';
comment on column apex_workspace_log_summary_usr.TODAY_HH01                     is 'Page views recorded today for the hour 00-01';
comment on column apex_workspace_log_summary_usr.TODAY_HH02                     is 'Page views recorded today for the hour 01-02';
comment on column apex_workspace_log_summary_usr.TODAY_HH03                     is 'Page views recorded today for the hour 02-03';
comment on column apex_workspace_log_summary_usr.TODAY_HH04                     is 'Page views recorded today for the hour 03-04';
comment on column apex_workspace_log_summary_usr.TODAY_HH05                     is 'Page views recorded today for the hour 04-05';
comment on column apex_workspace_log_summary_usr.TODAY_HH06                     is 'Page views recorded today for the hour 05-06';
comment on column apex_workspace_log_summary_usr.TODAY_HH07                     is 'Page views recorded today for the hour 06-07';
comment on column apex_workspace_log_summary_usr.TODAY_HH08                     is 'Page views recorded today for the hour 07-08';
comment on column apex_workspace_log_summary_usr.TODAY_HH09                     is 'Page views recorded today for the hour 08-09';
comment on column apex_workspace_log_summary_usr.TODAY_HH10                     is 'Page views recorded today for the hour 09-10';
comment on column apex_workspace_log_summary_usr.TODAY_HH11                     is 'Page views recorded today for the hour 10-11';
comment on column apex_workspace_log_summary_usr.TODAY_HH12                     is 'Page views recorded today for the hour 11-12';
comment on column apex_workspace_log_summary_usr.TODAY_HH13                     is 'Page views recorded today for the hour 12-13';
comment on column apex_workspace_log_summary_usr.TODAY_HH14                     is 'Page views recorded today for the hour 13-14';
comment on column apex_workspace_log_summary_usr.TODAY_HH15                     is 'Page views recorded today for the hour 14-15';
comment on column apex_workspace_log_summary_usr.TODAY_HH16                     is 'Page views recorded today for the hour 15-16';
comment on column apex_workspace_log_summary_usr.TODAY_HH17                     is 'Page views recorded today for the hour 16-17';
comment on column apex_workspace_log_summary_usr.TODAY_HH18                     is 'Page views recorded today for the hour 17-18';
comment on column apex_workspace_log_summary_usr.TODAY_HH19                     is 'Page views recorded today for the hour 18-19';
comment on column apex_workspace_log_summary_usr.TODAY_HH20                     is 'Page views recorded today for the hour 19-20';
comment on column apex_workspace_log_summary_usr.TODAY_HH21                     is 'Page views recorded today for the hour 20-21';
comment on column apex_workspace_log_summary_usr.TODAY_HH22                     is 'Page views recorded today for the hour 21-22';
comment on column apex_workspace_log_summary_usr.TODAY_HH23                     is 'Page views recorded today for the hour 22-23';
comment on column apex_workspace_log_summary_usr.TODAY_HH24                     is 'Page views recorded today for the hour 23-24';
comment on column apex_workspace_log_summary_usr.TODAY                          is 'Todays date on the server to provide greater context for people in different timezones';


create or replace view apex_workspace_log_archive as
select
    l.workspace_name                       workspace,
    w.display_name                         workspace_display_name,
    l.log_day,
    l.workspace_id,
    l.application_id,
    l.application_name,
    l.page_events,
    l.page_views,
    l.page_accepts,
    l.partial_page_views,
    l.websheet_views,
    l.rows_fetched,
    l.ir_searches,
    l.distinct_pages,
    l.distinct_users,
    l.distinct_sessions,
    l.average_render_time,
    l.median_render_time,
    l.maximum_render_time,
    l.total_render_time,
    l.error_count,
    l.content_length,
    l.public_page_events,
    l.workspace_login_events,
    l.additional_attributes
from wwv_flow_log_history  l,
     wwv_flow_companies    w,
     wwv_flow_current_sgid sgid
where (   l.workspace_id in (select security_group_id
                               from wwv_flow_company_schemas s
                              where s.schema = sgid.cu
                                and (   sgid.nls_sort='BINARY'
                                     or nlssort(s.schema,'NLS_SORT=BINARY')=nlssort(sgid.cu,'NLS_SORT=BINARY')))
       or sgid.has_apex_admin_read_role_yn = 'Y'
       or sgid.security_group_id           = l.workspace_id )
and l.workspace_id = w.provisioning_company_id (+)
and (w.provisioning_company_id != 0 or w.provisioning_company_id is null)
/

comment on table apex_workspace_log_archive is 'Page view activity is a daily summary of workspace acitivity that is retained until physically purged';
comment on column apex_workspace_log_archive.WORKSPACE             is 'Name of Workspace that generated the page view log entry';
comment on column apex_workspace_log_archive.workspace_display_name is 'Display name for the workspace';
comment on column apex_workspace_log_archive.LOG_DAY               is 'Day that all workspace statistics are summarized for';
comment on column apex_workspace_log_archive.WORKSPACE_ID          is 'Identifies workspace';
comment on column apex_workspace_log_archive.APPLICATION_ID        is 'Identifies the application';
comment on column apex_workspace_log_archive.APPLICATION_NAME      is 'Name of the application';
comment on column apex_workspace_log_archive.PAGE_EVENTS           is 'Total number of page events logged for a given day, application and workspace';
comment on column apex_workspace_log_archive.PAGE_VIEWS            is 'Total page views for a given day and workspace';
comment on column apex_workspace_log_archive.PAGE_ACCEPTS          is 'Total page accepts for a given day, application and workspace';

comment on column apex_workspace_log_archive.PARTIAL_PAGE_VIEWS    is 'Total partial page views for a given day, application and workspace';
comment on column apex_workspace_log_archive.WEBSHEET_VIEWS        is 'Total websheet application page views for a given day, application and workspace';
comment on column apex_workspace_log_archive.ROWS_FETCHED          is 'Total rows fetched by apex reporting engines for a given day, application and workspace';
comment on column apex_workspace_log_archive.IR_SEARCHES           is 'Total not null interactive report search values logged to the activity log';
comment on column apex_workspace_log_archive.DISTINCT_PAGES        is 'Summarized information by day, application and workspace';
comment on column apex_workspace_log_archive.DISTINCT_USERS        is 'Summarized information by day, application and workspace';
comment on column apex_workspace_log_archive.DISTINCT_SESSIONS     is 'Summarized information by day, application and workspace';
comment on column apex_workspace_log_archive.AVERAGE_RENDER_TIME   is 'Summarized information by day, application  and workspace';
comment on column apex_workspace_log_archive.MEDIAN_RENDER_TIME    is 'Summarized information by day, application and workspace';
comment on column apex_workspace_log_archive.MAXIMUM_RENDER_TIME   is 'Summarized information by day, application and workspace';
comment on column apex_workspace_log_archive.TOTAL_RENDER_TIME     is 'Summarized information by day, application and workspace';
comment on column apex_workspace_log_archive.ERROR_COUNT           is 'Summarized information by day, application and workspace';
comment on column apex_workspace_log_archive.content_length        is 'Summarized information by day, applicatio  and workspace';
comment on column apex_workspace_log_archive.public_page_events    is 'Total public page events for a given day, application and workspace';
comment on column apex_workspace_log_archive.workspace_login_events is 'Total workspace login events by day, application and workspace';
comment on column apex_workspace_log_archive.additional_attributes is 'Additional information about the application in JSON format';


---------------------------------------------------------
-- C L I C K  T H R U S
--
create or replace view apex_workspace_clicks as
select w.workspace,
       w.workspace_display_name,
       a.category                     category,
       a.flow_user                    apex_user,
       a.clickdate                    clickdate,
       a.id                           click_id,
       a.ip                           clicker_ip,
       w.workspace_id
  from (select clickdate, category, id, flow_user, ip, security_group_id
          from wwv_flow_clickthru_log$ l
        union all
        select clickdate, category, id, flow_user, ip, security_group_id
          from wwv_flow_clickthru_log2$ l
        ) a,
        wwv_flow_current_workspaces w
 where a.security_group_id = w.workspace_id
/

comment on table  apex_workspace_clicks                          is 'Clicks in Application Express that are tracked by using APEX_UTIL.COUNT_CLICKS';
comment on column apex_workspace_clicks.workspace                is 'A work area mapped to one or more database schemas';
comment on column apex_workspace_clicks.workspace_display_name   is 'Display name for the workspace';
comment on column apex_workspace_clicks.category                 is 'Optional category used to track the click';
comment on column apex_workspace_clicks.apex_user                is 'Name of Application Express user that clicked';
comment on column apex_workspace_clicks.clickdate                is 'Date of the recorded click';
comment on column apex_workspace_clicks.click_id                 is 'Optional secondary ID to further track the click';
comment on column apex_workspace_clicks.clicker_ip               is 'The IP address of the clicker';
comment on column apex_workspace_clicks.workspace_id             is 'Primary key that identifies the workspace';


--------------------------------------------------------------------------------
-- Plugins
--------------------------------------------------------------------------------

create or replace view apex_appl_plugins
as
select p.id                        as plugin_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       case p.plugin_type
         when 'ITEM TYPE'           then 'Item Type'
         when 'DYNAMIC ACTION'      then 'Dynamic Action'
         when 'REGION TYPE'         then 'Region Type'
         when 'REPORT COLUMN TYPE'  then 'Report Column Type'
         when 'VALIDATION TYPE'     then 'Validation Type'
         when 'PROCESS TYPE'        then 'Process Type'
         when 'AUTHENTICATION TYPE' then 'Authentication Type'
         when 'AUTHORIZATION TYPE'  then 'Authorization Type'
         else                       p.plugin_type
       end                         as plugin_type,
       p.name,
       p.display_name,
       p.category,
       p.supported_ui_types,
       p.supported_component_types,
       p.supported_data_types,
       p.image_prefix              as file_prefix,
       p.javascript_file_urls,
       p.css_file_urls,
       p.plsql_code,
       p.api_version,
       p.render_function,
       p.meta_data_function,
       -- p.emit_value_function,
       p.ajax_function,
       p.validation_function,
       p.execution_function,
       p.session_sentry_function,
       p.invalid_session_function,
       p.authentication_function,
       p.post_logout_function,
       p.builder_validation_function,
       p.migration_function,
       p.standard_attributes,
       p.substitute_attributes,
       nvl2(p.reference_id, 'Yes', 'No') as is_subscribed,
       ( select s.flow_id||'. '||s.display_name
           from wwv_flow_plugins s
          where s.id = p.reference_id )  as subscribed_from,
       p.reference_id                    as subscribed_from_id,
       case p.subscribe_plugin_settings
         when 'Y' then 'Yes'
         else          'No'
       end                               as subscribe_plugin_settings,
       p.help_text,
       p.version_identifier,
       p.about_url,
       p.plugin_comment                  as component_comment,
       p.files_version,
       p.created_by,
       p.created_on,
       p.last_updated_by,
       p.last_updated_on,
       p.name || ' ' || substr(p.display_name, 1, 30) || length(p.display_name) ||
       ' t=' || p.plugin_type || ' c=' || p.category || ' v=' || p.version_identifier ||
       ' u=' || substr(p.about_url, 1, 30) || length(p.about_url)
       as component_signature,
       -- For compatibility with existing applications (bug# 14545162)
       -- Obsolete columns because they are accessible with view apex_appl_plugin_settings
       s.attribute_01,
       s.attribute_02,
       s.attribute_03,
       s.attribute_04,
       s.attribute_05,
       s.attribute_06,
       s.attribute_07,
       s.attribute_08,
       s.attribute_09,
       s.attribute_10,
       s.attribute_11,
       s.attribute_12,
       s.attribute_13,
       s.attribute_14,
       s.attribute_15,
       p.sql_min_column_count,
       p.sql_max_column_count,
       p.sql_examples
  from wwv_flow_authorized_and_4411 f,
       wwv_flow_plugins p,
       wwv_flow_plugin_settings s
 where p.flow_id         = f.application_id
   and s.flow_id (+)     = p.flow_id
   and s.plugin_type (+) = p.plugin_type
   and s.plugin (+)      = 'PLUGIN_' || p.name
/

comment on table apex_appl_plugins is
    'Stores the meta data for the plug-ins of an application.';
-- Add comments to the columns
comment on column apex_appl_plugins.plugin_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugins.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugins.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugins.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugins.application_name is
    'Identifies the application';
comment on column apex_appl_plugins.plugin_type is
    'Type of the plug-in.';
comment on column apex_appl_plugins.name is
    'Internal name of the plug-in which is used to reference it for example in apex_application_page_items.';
comment on column apex_appl_plugins.display_name is
    'Contains the name of the plug-in which is displayed on the UI.';
comment on column apex_appl_plugins.category is
    'Category under which the plug-in should displayed on the UI.';
comment on column apex_appl_plugins.supported_ui_types is
    'User Interface types for which the plug-in should be displayed on the UI.';
comment on column apex_appl_plugins.supported_component_types is
    'Component types for which the plug-in should be displayed on the UI.';
comment on column apex_appl_plugins.supported_data_types is
    'Data types for which the plug-in should be displayed on the UI.';
comment on column apex_appl_plugins.file_prefix is
    'File prefix which is used by the plug-in to load additional files like CSS, Javascript and images.';
comment on column apex_appl_plugins.javascript_file_urls is
    'List of JavaScript file URLs which should be loaded for the plug-in.';
comment on column apex_appl_plugins.css_file_urls is
    'List of URLs which should be loaded for the plug-in style.';
comment on column apex_appl_plugins.plsql_code is
    'PL/SQL code which contains the logic of the plug-in.';
comment on column apex_appl_plugins.api_version is
    'Callback API version used by the plug-in.';
comment on column apex_appl_plugins.render_function is
    'Procedure/Function which is called for a plug-in during rendering of the page.';
comment on column wwv_flow_plugins.meta_data_function is
    'Procedure/Function which is called for a plug-in to get dynamic meta data about the plug-in.';
/*
comment on column apex_appl_plugins.emit_value_function is
    'Procedure/Function which is called for a plug-in to emit a value.';
*/
comment on column apex_appl_plugins.ajax_function is
    'Procedure/Function which is called for a plug-in when there is an incoming Ajax call from the browser.';
comment on column apex_appl_plugins.validation_function is
    'Procedure/Function which is called to validate the plug-ins data before the defined validations are fired.';
comment on column apex_appl_plugins.execution_function is
    'Function which is called for plug-ins that are just used on the server side.';
comment on column apex_appl_plugins.session_sentry_function is
    'Function which is called by an authentication plug-in each time a request is made to Application Express.';
comment on column apex_appl_plugins.invalid_session_function is
    'Function which is called by an authentication plug-in if the session sentry function or the authentication session verification return false.';
comment on column apex_appl_plugins.authentication_function is
    'Function which is called by an authentication plug-in to verify login credentials.';
comment on column apex_appl_plugins.post_logout_function is
    'Function which is called by an authentication plug-in after a session has been marked as terminated.';
comment on column apex_appl_plugins.builder_validation_function is
    'Function which is called to validate the entered attribute values in the builder.';
comment on column apex_appl_plugins.migration_function is
    'Function which is called when a new version of a plug-in is installed to migrate existing attribute values.';
comment on column apex_appl_plugins.standard_attributes is
    'Contains the APEX provided standard attributes which should be displayed for the plug-in.';
comment on column wwv_flow_plugins.substitute_attributes is
    'Are the attribute values automatically substituted when the plug-in is called?';
comment on column apex_appl_plugins.is_subscribed is
    'Identifies if this plug-in is subscribed from another plug-in';
comment on column apex_appl_plugins.subscribed_from is
    'Identifies the master component from which this component is subscribed';
comment on column apex_appl_plugins.subscribed_from_id is
    'Id the master component from which this component is subscribed';
comment on column apex_appl_plugins.subscribe_plugin_settings is
    'Are the defaults of the subscribed component copied?';
comment on column apex_appl_plugins.help_text is
    'Help text which is displayed for the plug-in in the Builder.';
comment on column apex_appl_plugins.version_identifier is
    'Version identifier of the plug-in.';
comment on column apex_appl_plugins.about_url is
    'URL to get additional information about the plug-in.';
comment on column apex_appl_plugins.component_comment is
    'Developer Comment';
comment on column apex_appl_plugins.files_version is
    'Version counter of the attached plug-in files.';
comment on column apex_appl_plugins.created_by is
    'APEX developer who created the plug-in';
comment on column apex_appl_plugins.created_on is
    'Date of creation';
comment on column apex_appl_plugins.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugins.last_updated_on is
    'Date of last update';
comment on column apex_appl_plugins.component_signature is
    'Identifies attributes defined at a given component level to facilitate application comparisons';
comment on column apex_appl_plugins.attribute_01 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_02 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_03 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_04 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_05 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_06 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_07 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_08 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_09 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_10 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_11 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_12 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_13 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_14 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.attribute_15 is
    'Dynamic attribute to store additional data (obsolete)';
comment on column apex_appl_plugins.sql_min_column_count is
    'Minimum number of columns the SQL query of the LOV or region source has to have (obsolete)';
comment on column apex_appl_plugins.sql_max_column_count is
    'Maximum number of columns the SQL query of the LOV or region source can have (obsolete)';
comment on column apex_appl_plugins.sql_examples is
    'LOV or region source SQL examples which are displayed for the plug-in in the Builder (obsolete)';




create or replace view apex_appl_plugin_std_attrs
as
select a.id                 as plugin_std_attribute_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       a.plugin_id,
       p.name               as plugin_name,
       a.name               as name,
       case a.is_required
         when 'Y' then 'Yes'
         else          'No'
       end                  as is_required,
       a.default_value,
       a.sql_min_column_count,
       a.sql_max_column_count,
       a.supported_ui_types,
       a.supported_component_types,
       a.depending_on_attribute_id,
       case a.depending_on_has_to_exist
         when 'Y' then 'Yes'
         when 'N' then 'No'
       end as depending_on_always_eval,
       case a.depending_on_condition_type
         when 'EQUALS'       then 'equal to'
         when 'NOT_EQUALS'   then 'not equal to'
         when 'NULL'         then 'is null'
         when 'NOT_NULL'     then 'is not null'
         when 'IN_LIST'      then 'in list'
         when 'NOT_IN_LIST'  then 'not in list'
         else a.depending_on_condition_type
       end depending_on_condition_type,
       a.depending_on_expression,
       a.examples,
       a.help_text,
       a.attribute_comment as component_comment,
       a.created_by,
       a.created_on,
       a.last_updated_by,
       a.last_updated_on
  from wwv_flow_authorized_and_4411 f,
       wwv_flow_plugins p,
       wwv_flow_plugin_std_attributes a
 where p.flow_id   = f.application_id
   and a.plugin_id = p.id
/


comment on table apex_appl_plugin_std_attrs is
    'Stores additional meta data for plug-in standard attributes.';
-- Add comments to the columns
comment on column apex_appl_plugin_std_attrs.plugin_std_attribute_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugin_std_attrs.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugin_std_attrs.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugin_std_attrs.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugin_std_attrs.application_name is
    'Identifies the application';
comment on column apex_appl_plugin_std_attrs.plugin_id is
    'Id of the plug-in this plugin attribute is part of';
comment on column apex_appl_plugin_std_attrs.plugin_name is
    'Name of the plug-in this plugin attribute is part of';
comment on column apex_appl_plugin_std_attrs.name is
    'Name of the plug-in standard attribute';
comment on column apex_appl_plugin_std_attrs.is_required is
    'Should the Builder enforce this attribute to be filled out?';
comment on column apex_appl_plugin_std_attrs.sql_min_column_count is
    'Minimum number of columns the SQL query of the attribute has to have.';
comment on column apex_appl_plugin_std_attrs.sql_max_column_count is
    'Maximum number of columns the SQL query of the attribute can have.';
comment on column apex_appl_plugin_std_attrs.supported_ui_types is
    'User Interface types for which the attribute should be displayed on the UI.';
comment on column apex_appl_plugin_std_attrs.supported_component_types is
    'Component types for which the attribute should be displayed on the UI.';
comment on column apex_appl_plugin_std_attrs.depending_on_attribute_id is
    'Attribute which defines if the current attribute is displayed or not.';
comment on column apex_appl_plugin_std_attrs.depending_on_always_eval is
    'Is the dependency check only evaluated if the depending attribute is displayed?';
comment on column apex_appl_plugin_std_attrs.depending_on_condition_type is
    'Identifies the type of condition used to define when the attribute gets displayed.';
comment on column apex_appl_plugin_std_attrs.depending_on_expression is
    'Identifies the condition expression used to define when the attribute gets displayed.';
comment on column apex_appl_plugin_std_attrs.examples is
    'Examples displayed in APEX Builder for this attribute.';
comment on column apex_appl_plugin_std_attrs.help_text is
    'Help text displayed in APEX Builder for this attribute.';
comment on column apex_appl_plugin_std_attrs.component_comment is
    'Developer comment';
comment on column apex_appl_plugin_std_attrs.created_by is
    'APEX developer who created the plugin attribute';
comment on column apex_appl_plugin_std_attrs.created_on is
    'Date of creation';
comment on column apex_appl_plugin_std_attrs.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugin_std_attrs.last_updated_on is
    'Date of last update';


create or replace view apex_appl_plugin_attributes
as
select a.id                 as plugin_attribute_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       a.plugin_id,
       p.name               as plugin_name,
       case a.attribute_scope
         when 'APPLICATION' then 'Application'
         when 'COMPONENT'   then 'Component'
         else a.attribute_scope
       end                  as attribute_scope,
       a.attribute_sequence,
       a.display_sequence,
       a.prompt,
       case a.attribute_type
         when 'CHECKBOX'         then 'Checkbox'
         when 'SELECT LIST'      then 'Select List'
         when 'TEXT'             then 'Text'
         when 'TEXTAREA'         then 'Textarea'
         when 'NUMBER'           then 'Number'
         when 'INTEGER'          then 'Integer'
         when 'PAGE ITEM'        then 'Page Item'
         when 'PAGE ITEMS'       then 'Page Items'
         when 'PAGE NUMBER'      then 'Page Number'
         when 'SQL'              then 'SQL Query'
         when 'PLSQL'            then 'PL/SQL Code'
         when 'PLSQL EXPRESSION' then 'PL/SQL Expression'
         else a.attribute_type
       end                  as attribute_type,
       case a.is_required
         when 'Y' then 'Yes'
         else          'No'
       end                  as is_required,
       case a.is_common
         when 'Y' then 'Yes'
         else          'No'
       end                  as is_common,
       case a.show_in_wizard
         when 'Y' then 'Yes'
         else          'No'
       end                  as show_in_wizard,
       a.default_value,
       a.display_length,
       a.max_length,
       a.min_value,
       a.max_value,
       a.unit,
       a.sql_min_column_count,
       a.sql_max_column_count,
       a.column_data_types,
       a.supported_ui_types,
       a.supported_component_types,
       a.is_translatable,
       a.depending_on_attribute_id,
       a.depending_on_comp_prop_id,
       case a.depending_on_has_to_exist
         when 'Y' then 'Yes'
         when 'N' then 'No'
       end as depending_on_always_eval,
       case a.depending_on_condition_type
         when 'EQUALS'       then 'equal to'
         when 'NOT_EQUALS'   then 'not equal to'
         when 'NULL'         then 'is null'
         when 'NOT_NULL'     then 'is not null'
         when 'IN_LIST'      then 'in list'
         when 'NOT_IN_LIST'  then 'not in list'
         else a.depending_on_condition_type
       end depending_on_condition_type,
       a.depending_on_expression,
       a.reference_scope,
       a.examples,
       a.help_text,
       a.attribute_comment  as component_comment,
       a.created_by,
       a.created_on,
       a.last_updated_by,
       a.last_updated_on
  from wwv_flow_authorized_and_4411 f,
       wwv_flow_plugins p,
       wwv_flow_plugin_attributes a
 where p.flow_id   = f.application_id
   and a.plugin_id = p.id
/


comment on table apex_appl_plugin_attributes is
    'Stores the meta data for the dynamic attributes of a plug-in.';
-- Add comments to the columns
comment on column apex_appl_plugin_attributes.plugin_attribute_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugin_attributes.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugin_attributes.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugin_attributes.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugin_attributes.application_name is
    'Identifies the application';
comment on column apex_appl_plugin_attributes.plugin_id is
    'Id of the plug-in this plugin attribute is part of';
comment on column apex_appl_plugin_attributes.plugin_name is
    'Name of the plug-in this plugin attribute is part of';
comment on column apex_appl_plugin_attributes.attribute_scope is
    'Is the attribute set for an application or a component.';
comment on column apex_appl_plugin_attributes.attribute_sequence is
    'Sequence which correlates with the attribute_xx columns for example in apex_application_page_items.';
comment on column apex_appl_plugin_attributes.display_sequence is
    'Sequence in which the attributes are displayed in the Builder.';
comment on column apex_appl_plugin_attributes.prompt is
    'Prompt which is displayed for that attribute in the Builder.';
comment on column apex_appl_plugin_attributes.help_text is
    'Help text which is displayed for that attribute in the Builder.';
comment on column apex_appl_plugin_attributes.attribute_type is
    'Type of control which is used to render the attribute field in the Builder.';
comment on column apex_appl_plugin_attributes.is_required is
    'Should the Builder enforce this attribute to be filled out?';
comment on column apex_appl_plugin_attributes.is_common is
    'Should the Builder always show that attribute?';
comment on column apex_appl_plugin_attributes.show_in_wizard is
    'Should the Builder show that attribute in a Create Wizard?';
comment on column apex_appl_plugin_attributes.default_value is
    'Default value which is used in the Builder when the item type is selected.';
comment on column apex_appl_plugin_attributes.display_length is
    'Display length of the attribute used when displayed in the Builder.';
comment on column apex_appl_plugin_attributes.max_length is
    'Maximum length of the attribute used when displayed in the Builder.';
comment on column apex_appl_plugin_attributes.min_value is
    'Minimum allowed value of the attribute.';
comment on column apex_appl_plugin_attributes.max_value is
    'Maximum allowed value of the attribute.';
comment on column apex_appl_plugin_attributes.unit is
    'Unit of the attribute used when displayed in the Builder.';
comment on column apex_appl_plugin_attributes.sql_min_column_count is
    'Minimum number of columns the SQL query of the attribute has to have.';
comment on column apex_appl_plugin_attributes.sql_max_column_count is
    'Maximum number of columns the SQL query of the attribute can have.';
comment on column wwv_flow_plugin_attributes.column_data_types is
    'Data types which are supported by the attribute of type "Region SQL Statement Column".';
comment on column wwv_flow_plugin_attributes.supported_ui_types is
    'User Interface types for which the attribute should be displayed on the UI.';
comment on column wwv_flow_plugin_attributes.supported_component_types is
    'Component types for which the attribute should be displayed on the UI.';
comment on column apex_appl_plugin_attributes.is_translatable is
    'Is the attribute value exported into the XLIFF file for translation.';
comment on column apex_appl_plugin_attributes.depending_on_attribute_id is
    'Attribute which defines if the current attribute is displayed or not.';
comment on column apex_appl_plugin_attributes.depending_on_comp_prop_id is
    'Property which defines if the current attribute is displayed or not.';
comment on column apex_appl_plugin_attributes.depending_on_always_eval is
    'Is the dependency check only evaluated if the depending attribute is displayed?';
comment on column apex_appl_plugin_attributes.depending_on_condition_type is
    'Identifies the type of condition used to define when the attribute gets displayed.';
comment on column apex_appl_plugin_attributes.depending_on_expression is
    'Identifies the condition expression used to define when the attribute gets displayed.';
comment on column apex_appl_plugin_attributes.reference_scope is
    'Can the attribute reference region columns?';
comment on column apex_appl_plugin_attributes.examples is
    'Examples displayed in APEX Builder for this attribute.';
comment on column apex_appl_plugin_attributes.help_text is
    'Help text displayed in APEX Builder for this attribute.';
comment on column apex_appl_plugin_attributes.component_comment is
    'Developer Comment';
comment on column apex_appl_plugin_attributes.created_by is
    'APEX developer who created the plugin attribute';
comment on column apex_appl_plugin_attributes.created_on is
    'Date of creation';
comment on column apex_appl_plugin_attributes.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugin_attributes.last_updated_on is
    'Date of last update';


create or replace view apex_appl_plugin_attr_values
as
select v.id                 as plugin_attribute_value_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       v.plugin_attribute_id,
       a.prompt             as plugin_attribute_prompt,
       v.display_sequence,
       v.display_value,
       v.return_value,
       v.is_quick_pick,
       v.help_text,
       v.created_by,
       v.created_on,
       v.last_updated_by,
       v.last_updated_on
  from wwv_flow_authorized_and_4411 f,
       wwv_flow_plugin_attr_values v,
       wwv_flow_plugin_attributes a
 where v.flow_id = f.application_id
   and a.id      = v.plugin_attribute_id
/


comment on table apex_appl_plugin_attr_values is
    'Stores the possible values of a plug-in attribute if it''s of type selectlist.';
-- Add comments to the columns
comment on column apex_appl_plugin_attr_values.plugin_attribute_value_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugin_attr_values.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugin_attr_values.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugin_attr_values.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugin_attr_values.application_name is
    'Identifies the application';
comment on column apex_appl_plugin_attr_values.plugin_attribute_id is
    'Id of the attribute this value is part of';
comment on column apex_appl_plugin_attr_values.plugin_attribute_prompt is
    'Label of the attribute this value is part of';
comment on column apex_appl_plugin_attr_values.display_sequence is
    'Order sequence in which the values are displayed.';
comment on column apex_appl_plugin_attr_values.display_value is
    'Value displayed to end users';
comment on column apex_appl_plugin_attr_values.return_value is
    'Value stored in attribute_xx column.';
comment on column apex_appl_plugin_attr_values.is_quick_pick is
    'Should the Builder show the value as a quick pick option?';
comment on column apex_appl_plugin_attr_values.help_text is
    'Help text displayed in APEX Builder for this value.';
comment on column apex_appl_plugin_attr_values.created_by is
    'APEX developer who created the plugin attribute value';
comment on column apex_appl_plugin_attr_values.created_on is
    'Date of creation';
comment on column apex_appl_plugin_attr_values.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugin_attr_values.last_updated_on is
    'Date of last update';



create or replace view apex_appl_plugin_files
as
select a.id                 as plugin_file_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       a.plugin_id,
       p.name               as plugin_name,
       a.file_name,
       a.mime_type,
       a.file_charset,
       a.file_content,
       a.created_by,
       a.created_on,
       a.last_updated_by,
       a.last_updated_on
  from wwv_flow_authorized_and_4411 f,
       wwv_flow_plugins p,
       wwv_flow_plugin_files a
 where p.flow_id   = f.application_id
   and a.plugin_id = p.id
/


comment on table apex_appl_plugin_files is
    'Stores the files like CSS, images, javascript files, ... of a plug-in.';
-- Add comments to the columns
comment on column apex_appl_plugin_files.plugin_file_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugin_files.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugin_files.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugin_files.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugin_files.application_name is
    'Identifies the application';
comment on column apex_appl_plugin_files.plugin_id is
    'Id of the plug-in this plug-in file is part of';
comment on column apex_appl_plugin_files.plugin_name is
    'Name of the plug-in this plug-in file is part of';
comment on column apex_appl_plugin_files.file_name is
    'Name of the file.';
comment on column apex_appl_plugin_files.mime_type is
    'Mime type of the file.';
comment on column apex_appl_plugin_files.file_charset is
    'IANA charset used for text files.';
comment on column apex_appl_plugin_files.file_content is
    'Blob content of the file.';
comment on column apex_appl_plugin_files.created_by is
    'APEX developer who created the plug-in file';
comment on column apex_appl_plugin_files.created_on is
    'Date of creation';
comment on column apex_appl_plugin_files.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugin_files.last_updated_on is
    'Date of last update';



create or replace view apex_appl_plugin_events
as
select e.id                 as plugin_event_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       e.plugin_id,
       p.name               as plugin_name,
       e.name,
       e.display_name,
       e.created_by,
       e.created_on,
       e.last_updated_by,
       e.last_updated_on
  from wwv_flow_authorized_and_4411 f,
       wwv_flow_plugins p,
       wwv_flow_plugin_events e
 where p.flow_id   = f.application_id
   and e.plugin_id = p.id
/


comment on table apex_appl_plugin_events is
    'Stores which events can be triggered by this plug-in. This events are used for binding dynamic actions.';
-- Add comments to the columns
comment on column apex_appl_plugin_events.plugin_event_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugin_events.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugin_events.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugin_events.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugin_events.application_name is
    'Identifies the application';
comment on column apex_appl_plugin_events.plugin_id is
    'Id of the plug-in this plug-in event is part of';
comment on column apex_appl_plugin_events.plugin_name is
    'Name of the plug-in this plug-in event is part of';
comment on column apex_appl_plugin_events.name is
    'Internal name of the event which is used to reference it from apex_application_page_da and to bind the Javascript event.';
comment on column apex_appl_plugin_events.display_name is
    'Contains the name of the event which is displayed on the UI.';
comment on column apex_appl_plugin_events.created_by is
    'APEX developer who created the plug-in event';
comment on column apex_appl_plugin_events.created_on is
    'Date of creation';
comment on column apex_appl_plugin_events.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugin_events.last_updated_on is
    'Date of last update';

/* $$$ pawolf09082016: didn't make it into 5.1
create or replace view apex_appl_plugin_item_filters
as
select f.id                 as plugin_filter_id,
       a.workspace,
       a.workspace_display_name,
       a.application_id,
       a.application_name,
       f.plugin_id,
       p.name               as plugin_name,
       f.name,
       f.display_name,
       f.created_by,
       f.created_on,
       f.last_updated_by,
       f.last_updated_on
  from wwv_flow_authorized_and_4411 a,
       wwv_flow_plugins p,
       wwv_flow_plugin_item_filters f
 where p.flow_id   = a.application_id
   and f.plugin_id = p.id
/


comment on table apex_appl_plugin_item_filters is
    'Stores which filter operators can be used by this plug-in.';
-- Add comments to the columns
comment on column apex_appl_plugin_item_filters.plugin_filter_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugin_item_filters.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugin_item_filters.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugin_item_filters.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugin_item_filters.application_name is
    'Identifies the application';
comment on column apex_appl_plugin_item_filters.plugin_id is
    'Id of the plug-in this plug-in event is part of';
comment on column apex_appl_plugin_item_filters.plugin_name is
    'Name of the plug-in this plug-in event is part of';
comment on column apex_appl_plugin_item_filters.name is
    'Internal name of the filter which is used to reference it in the plug-in and in Page Designer.';
comment on column apex_appl_plugin_item_filters.display_name is
    'Contains the name of the filter operator which is displayed in Page Designer.';
comment on column apex_appl_plugin_item_filters.created_by is
    'APEX developer who created the plug-in event';
comment on column apex_appl_plugin_item_filters.created_on is
    'Date of creation';
comment on column apex_appl_plugin_item_filters.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugin_item_filters.last_updated_on is
    'Date of last update';
*/

create or replace view apex_appl_plugin_settings
as
select p.id                        as plugin_setting_id,
       f.workspace,
       f.workspace_display_name,
       f.application_id,
       f.application_name,
       p.plugin_type,
       case substr(p.plugin, 1, 7)
         when 'NATIVE_' then
             ( select display_name from wwv_flow_plugins where flow_id = 4411 and plugin_type = p.plugin_type and name = substr(p.plugin, 8) )
         when 'PLUGIN_' then
             ( select display_name from wwv_flow_plugins where flow_id = p.flow_id and plugin_type = p.plugin_type and name = substr(p.plugin, 8) )
         else p.plugin
       end            as plugin,
       p.plugin       as plugin_code,
       p.attribute_01,
       p.attribute_02,
       p.attribute_03,
       p.attribute_04,
       p.attribute_05,
       p.attribute_06,
       p.attribute_07,
       p.attribute_08,
       p.attribute_09,
       p.attribute_10,
       p.attribute_11,
       p.attribute_12,
       p.attribute_13,
       p.attribute_14,
       p.attribute_15,
       p.created_by,
       p.created_on,
       p.last_updated_by,
       p.last_updated_on
  from wwv_flow_authorized f,
       wwv_flow_plugin_settings p
 where p.flow_id = f.application_id
/

comment on table apex_appl_plugin_settings is
    'Stores the values of custom attribute of scope "application" of a plug-in.';
-- Add comments to the columns
comment on column apex_appl_plugin_settings.plugin_setting_id is
    'Identifies the primary key of this component';
comment on column apex_appl_plugin_settings.workspace is
    'A work area mapped to one or more database schemas';
comment on column apex_appl_plugin_settings.workspace_display_name is
    'Display name for the workspace';
comment on column apex_appl_plugin_settings.application_id is
    'Application Primary Key, Unique over all workspaces';
comment on column apex_appl_plugin_settings.application_name is
    'Identifies the application';
comment on column apex_appl_plugin_settings.plugin_type is
    'Type of the plug-in.';
comment on column apex_appl_plugin_settings.plugin is
    'Identifies the referenced plug-in';
comment on column apex_appl_plugin_settings.plugin_code is
    'Internal code of PLUGIN';
comment on column apex_appl_plugin_settings.attribute_01 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_02 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_03 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_04 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_05 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_06 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_07 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_08 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_09 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_10 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_11 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_12 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_13 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_14 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.attribute_15 is
    'Dynamic attribute to store additional data';
comment on column apex_appl_plugin_settings.created_by is
    'APEX developer who created the plug-in setting';
comment on column apex_appl_plugin_settings.created_on is
    'Date of creation';
comment on column apex_appl_plugin_settings.last_updated_by is
    'APEX developer who made last update';
comment on column apex_appl_plugin_settings.last_updated_on is
    'Date of last update';



----------------------------------------------------------
-- A P P L I C A T I O N   F L A S H   C H A R T S
--
prompt ...apex_application_page_flash5

create or replace view apex_application_page_flash5
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                             page_id,
    p.name                           page_name,
    c.region_id                      region_id,
    (select plug_name
     from wwv_flow_page_plugs
     where id = c.region_id)         region_name,
    c.id                             chart_id,
    decode(c.chart_type,
    '2DColumn', '2D Column',
    '2DColumn_Line', '2D Column Line',
    '2DDoughnut', '2D Doughnut',
    '2DLine', '2D Line',
    '2DPie', '2D Pie',
    '3DColumn', '3D Column',
    '3DPie', '3D Pie',
    'Candlestick', 'Candlestick',
    'GaugeChart', 'Dial',
    'DIALSWEEP', 'Dial (Sweep)',
    'Horizontal2DColumn', 'Horizontal 2D Column',
    'Horizontal3DColumn', 'Horizontal 3D Column',
    'HorizontalRange3DColumn', 'Horizontal Range 3D Column',
    'HorizontalRange2DColumn', 'HorizontalRange 2D Column',
    'Inverse2DLine', 'Inverse 2D Line',
    'Range2DColumn', 'Range 2D Column',
    'Range3DColumn', 'Range 3D Column',
    'dot', 'Scatter',
    'ScatterMarker','Scatter',
    'Stacked2DColumn', 'Stacked 2D Column',
    '2DSTACKED_PCT', 'Stacked 2D Column (Percent)',
    'Stacked3DColumn', 'Stacked 3D Column',
    '3DSTACKED_PCT', 'Stacked 3D Column (Percent)',
    'StackedHorizontal2DColumn', 'Stacked Horizontal 2D Column',
    '2DHSTACKED_PCT', 'Stacked Horizontal 2D Column (Percent)',
    'StackedHorizontal3DColumn', 'Stacked Horizontal 3D Column',
    '3DHSTACKED_PCT', 'Stacked Horizontal 3D Column (Percent)',
    'ProjectGantt','Project Gantt',
    'ResourceGantt','Resource Gantt',
    'Map','Map',
    c.chart_type)                    chart_type,
    decode(c.chart_rendering,
    'FLASH_PREFERRED','Flash Chart',
    'SVG_ONLY','HTML5 Chart')        chart_rendering,
    c.chart_title                    chart_title,
    c.chart_name                     chart_name,
    c.chart_width                    chart_width,
    c.chart_height                   chart_height,
    c.chart_animation                chart_animation,
    c.pie_attr                       pie_attr,
    c.display_attr                   display_attr,
    c.dial_tick_attr                 dial_tick_attr,
    c.gantt_attr                     gantt_attr,
    c.gantt_date_format              gantt_date_format,
    c.gantt_start_date               gantt_start_date,
    c.gantt_end_date                 gantt_end_date,
    c.map_attr                       map_attr,
    c.map_source                     map_source,
    c.margins                        margins,
    c.color_scheme                   color_scheme,
    c.custom_colors                  custom_colors,
    c.map_undef_color_scheme         map_undef_color_scheme,
    c.map_undef_custom_colors        map_undef_custom_colors,
    c.chart_bgtype                   chart_bgtype,
    c.chart_bgcolor                  chart_bgcolor,
    c.chart_bgcolor2                 chart_bgcolor2,
    c.chart_bgcorners                chart_bgcorners,
    c.chart_gradient_angle           chart_gradient_angle,
    c.grid_bgtype                    grid_bgtype,
    c.grid_bgcolor                   grid_bgcolor,
    c.grid_bgcolor2                  grid_bgcolor2,
    c.grid_gradient_angle            grid_gradient_angle,
    c.x_axis_title                   x_axis_title,
    c.x_axis_title_font              x_axis_title_font,
    c.x_axis_title_rotation          x_axis_title_rotation,
    c.x_axis_min                     x_axis_min,
    c.x_axis_max                     x_axis_max,
    c.x_axis_scroll_start            x_axis_scroll_start,
    c.x_axis_scroll_end              x_axis_scroll_end,
    c.x_axis_scroll_range            x_axis_scroll_range,
    c.x_axis_scroll_range_unit       x_axis_scroll_range_unit,
    c.x_axis_label_rotation          x_axis_label_rotation,
    c.x_axis_label_font              x_axis_label_font,
    c.x_axis_prefix                  x_axis_prefix,
    c.x_axis_postfix                 x_axis_postfix,
    c.x_axis_decimal_place           x_axis_decimal_place,
    c.x_axis_major_interval          x_axis_major_interval,
    c.x_axis_minor_interval          x_axis_minor_interval,
    c.y_axis_title                   y_axis_title,
    c.y_axis_title_font              y_axis_title_font,
    c.y_axis_title_rotation          y_axis_title_rotation,
    c.y_axis_min                     y_axis_min,
    c.y_axis_max                     y_axis_max,
    c.y_axis_scroll_start            y_axis_scroll_start,
    c.y_axis_scroll_end              y_axis_scroll_end,
    c.y_axis_scroll_range            y_axis_scroll_range,
    c.y_axis_scroll_range_unit       y_axis_scroll_range_unit,
    c.y_axis_label_rotation          y_axis_label_rotation,
    c.y_axis_label_font              y_axis_label_font,
    c.y_axis_prefix                  y_axis_prefix,
    c.y_axis_postfix                 y_axis_postfix,
    c.y_axis_decimal_place           y_axis_decimal_place,
    c.y_axis_major_interval          y_axis_major_interval,
    c.y_axis_minor_interval          y_axis_minor_interval,
    c.extra_y_axis_min               extra_y_axis_min,
    c.extra_y_axis_max               extra_y_axis_max,
    c.values_prefix                  values_prefix,
    c.values_postfix                 values_postfix,
    c.async_update                   async_update,
    c.async_time                     async_time,
    c.values_font                    values_font,
    c.values_rotation                values_rotation,
    c.tooltip_font                   tooltip_font,
    c.legend_title                   legend_title,
    c.legend_font                    legend_font,
    c.legend_title_font              legend_title_font,
    c.grid_labels_font               grid_labels_font,
    c.chart_title_font               chart_title_font,
    c.gauge_labels_font              gauge_labels_font,
    c.use_chart_xml                  use_chart_xml,
    c.chart_xml                      chart_xml,
    --
    c.updated_by                     last_updated_by,
    c.updated_on                     last_updated_on,
    --
    decode(c.chart_type,
    '2DColumn', '2D Column',
    '2DColumn_Line', '2D Column Line',
    '2DDoughnut', '2D Doughnut',
    '2DLine', '2D Line',
    '2DPie', '2D Pie',
    '3DColumn', '3D Column',
    '3DPie', '3D Pie',
    'Candlestick', 'Candlestick',
    'GaugeChart', 'Dial',
    'DIALSWEEP', 'Dial (Sweep)',
    'Horizontal2DColumn', 'Horizontal 2D Column',
    'Horizontal3DColumn', 'Horizontal 3D Column',
    'HorizontalRange3DColumn', 'Horizontal Range 3D Column',
    'HorizontalRange2DColumn', 'HorizontalRange 2D Column',
    'Inverse2DLine', 'Inverse 2D Line',
    'Range2DColumn', 'Range 2D Column',
    'Range3DColumn', 'Range 3D Column',
    'dot', 'Scatter',
    'ScatterMarker','Scatter',
    'Stacked2DColumn', 'Stacked 2D Column',
    '2DSTACKED_PCT', 'Stacked 2D Column (Percent)',
    'Stacked3DColumn', 'Stacked 3D Column',
    '3DSTACKED_PCT', 'Stacked 3D Column (Percent)',
    'StackedHorizontal2DColumn', 'Stacked Horizontal 2D Column',
    '2DHSTACKED_PCT', 'Stacked Horizontal 2D Column (Percent)',
    'StackedHorizontal3DColumn', 'Stacked Horizontal 3D Column',
    '3DHSTACKED_PCT', 'Stacked Horizontal 3D Column (Percent)',
    'ProjectGantt','Project Gantt',
    'ResourceGantt','Resource Gantt',
    'Map','Map',
    c.chart_type)
    ||' attr='||c.chart_width||c.chart_height||c.chart_animation||c.display_attr||c.dial_tick_attr||c.gantt_attr||c.map_attr||c.pie_attr||c.margins
    ||' rendering='||decode(c.chart_rendering,'FLASH_PREFERRED','Flash Chart','SVG_ONLY','HTML5 Chart')
    ||' color='||c.color_scheme||substr(c.custom_colors,1,20)||'.'||length(c.custom_colors)
               ||c.map_undef_color_scheme||substr(c.map_undef_custom_colors,1,20)||'.'||length(c.map_undef_custom_colors)
               ||c.chart_bgtype||substr(c.chart_bgcolor,1,20)||'.'||length(c.chart_bgcolor)||substr(c.chart_bgcolor2,1,20)||'.'||length(c.chart_bgcolor2)
               ||c.grid_bgtype||substr(c.grid_bgcolor,1,20)||'.'||length(c.grid_bgcolor)||substr(c.grid_bgcolor2,1,20)||'.'||length(c.grid_bgcolor2)
    ||' rotation='||c.chart_gradient_angle||':'||c.grid_gradient_angle||':'||c.x_axis_title_rotation||':'||c.x_axis_label_rotation||':'||c.y_axis_title_rotation||':'||c.y_axis_label_rotation||':'||c.values_rotation
    ||' title='||substr(c.chart_title,1,20)||'.'||length(c.chart_title)
    ||substr(c.x_axis_title,1,20)||'.'||length(c.x_axis_title)
    ||substr(c.y_axis_title,1,20)||'.'||length(c.y_axis_title)
    ||' name='||substr(c.chart_name,1,20)||'.'||length(c.chart_name)
    ||' axis='||c.x_axis_min||':'||c.x_axis_max||':'||substr(c.x_axis_prefix,1,20)||':'||substr(c.x_axis_postfix,1,20)||':'||c.x_axis_decimal_place
              ||':'||c.x_axis_major_interval||':'||c.x_axis_minor_interval||':'
              ||c.y_axis_min||':'||c.y_axis_max||':'||substr(c.y_axis_prefix,1,20)||':'||substr(c.y_axis_postfix,1,20)||':'||c.y_axis_decimal_place
              ||':'||c.y_axis_major_interval||':'||c.y_axis_minor_interval||':'||substr(c.values_prefix,1,20)||':'||substr(c.values_postfix,1,20)
              ||':'||c.extra_y_axis_min||':'||c.extra_y_axis_max
    ||' font='||c.x_axis_label_font||c.y_axis_label_font||c.values_font||c.tooltip_font||c.legend_title_font||c.legend_font||c.grid_labels_font||c.gauge_labels_font||c.chart_title_font||c.x_axis_title_font||c.y_axis_title_font
    ||' xml='||decode(c.use_chart_xml,'Y',
                      sys.dbms_lob.substr(c.chart_xml,30,1)||'.'||sys.dbms_lob.getlength(c.chart_xml),
                      null)
    ||' refresh='||c.async_update||c.async_time
    component_signature
from wwv_flow_flash_charts_5 c,
     wwv_flow_steps          p,
     wwv_flow_authorized     f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = c.security_group_id
  and p.flow_id           = c.flow_id
  and p.id                = c.page_id
/

comment on table  apex_application_page_flash5                         is 'Identifies a Flash chart 5 chart associated with a Page and Region';
comment on column apex_application_page_flash5.workspace               is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_flash5.workspace_display_name  is 'Display name for the workspace';
comment on column apex_application_page_flash5.application_id          is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_flash5.application_name        is 'Identifies the application';
comment on column apex_application_page_flash5.page_id                 is 'ID of the application page';
comment on column apex_application_page_flash5.page_name               is 'Name of the application page';
comment on column apex_application_page_flash5.region_name             is 'Identifies the region name in which this Flash chart is displayed';
comment on column apex_application_page_flash5.region_id               is 'Identifies the Page Region foreign key to the apex_application_page_regions view';
comment on column apex_application_page_flash5.chart_id                is 'Primary Key of the Flash chart';
comment on column apex_application_page_flash5.chart_type              is 'Chart type to indicate the style in which the Flash chart will render';
comment on column apex_application_page_flash5.chart_title             is 'A title to display at the top of the chart';
comment on column apex_application_page_flash5.chart_rendering         is 'Identifies the chart rendering: Flash Chart or HTML5 Chart';
comment on column apex_application_page_flash5.chart_name              is 'Identifes the name of the chart, to be used for dashboards';
comment on column apex_application_page_flash5.chart_width             is 'Width of the chart';
comment on column apex_application_page_flash5.chart_height            is 'Height of the chart';
comment on column apex_application_page_flash5.chart_animation         is 'An animation to control the initial appearance of the chart';
comment on column apex_application_page_flash5.pie_attr                is 'Pie chart attribute';
comment on column apex_application_page_flash5.display_attr            is 'Display attribute to show legend, grid, hints, labels and values';
comment on column apex_application_page_flash5.dial_tick_attr          is 'Dial chart attribute to show ticks, show tick labels, and tick spacing';
comment on column apex_application_page_flash5.gantt_attr              is 'Gantt chart attribute to show datagrid, show navigation bar, and the attributes of the actual,progress and baseline bars';
comment on column apex_application_page_flash5.map_attr                is 'Map chart attribute to show projection, label positioning, map center, legend item display angle';
comment on column apex_application_page_flash5.gantt_date_format       is 'The date format used for a Gantt chart';
comment on column apex_application_page_flash5.gantt_start_date        is 'The start date for the Gantt chart timeline diplayed';
comment on column apex_application_page_flash5.gantt_end_date          is 'The end date for the Gantt chart timeline displayed';
comment on column apex_application_page_flash5.margins                 is 'Chart attribute for top, bottom, left, right margins';
comment on column apex_application_page_flash5.color_scheme            is 'Pre-built color scheme for the chart';
comment on column apex_application_page_flash5.custom_colors           is 'Set of custom colors defined by a user';
comment on column apex_application_page_flash5.map_undef_color_scheme  is 'Pre-built color scheme for the undefined map regions';
comment on column apex_application_page_flash5.map_undef_custom_colors is 'Set of custom colors defined by a user for the undefined map regions';
comment on column apex_application_page_flash5.chart_bgtype            is 'Background type for the chart';
comment on column apex_application_page_flash5.chart_bgcolor           is 'Background Color 1 for the chart.  If the background type is set to Gradient, the chart background fades from Background Color 1 to Background Color 2.';
comment on column apex_application_page_flash5.chart_bgcolor2          is 'Background Color 2 for the chart.  If the background type is set to Gradient, the chart background fades from Background Color 1 to Background Color 2.';
comment on column apex_application_page_flash5.chart_gradient_angle    is 'The angle for the chart background gradient';
comment on column apex_application_page_flash5.grid_bgtype             is 'Background type for the map grid.';
comment on column apex_application_page_flash5.grid_bgcolor            is 'Background Color 1 for the map grid.  If the background type is set to Gradient, the map grid background fades from Background Color 1 to Background Color 2.';
comment on column apex_application_page_flash5.grid_bgcolor2           is 'Background Color 2 for the map grid.  If the background type is set to Gradient, the map grid background fades from Background Color 1 to Background Color 2.';
comment on column apex_application_page_flash5.grid_gradient_angle     is 'The angle for the map grid background gradient';
comment on column apex_application_page_flash5.x_axis_title            is 'Title for the X Axis';
comment on column apex_application_page_flash5.x_axis_min              is 'The smallest data value to appear on the X Axis';
comment on column apex_application_page_flash5.x_axis_max              is 'The highest data value to appear on the X Axis';
comment on column apex_application_page_flash5.x_axis_prefix           is 'Text to display before X Axis values';
comment on column apex_application_page_flash5.x_axis_postfix          is 'Text to display after X Axis values';
comment on column apex_application_page_flash5.x_axis_decimal_place    is 'Number of decimal places to use in X Axis values';
comment on column apex_application_page_flash5.x_axis_major_interval   is 'The major scale step, used for the X axis labels, major tickmarks and minor grid on your chart';
comment on column apex_application_page_flash5.x_axis_minor_interval   is 'The minor scale step, used for the X axis labels, minor tickmarks and minor grid on your chart';
comment on column apex_application_page_flash5.y_axis_title            is 'Title for the Y Axis';
comment on column apex_application_page_flash5.y_axis_min              is 'The smallest data value to appear on the Y Axis';
comment on column apex_application_page_flash5.y_axis_max              is 'The highest data value to appear on the Y Axis';
comment on column apex_application_page_flash5.y_axis_prefix           is 'Text to display before Y Axis values';
comment on column apex_application_page_flash5.y_axis_postfix          is 'Text to display after Y Axis values';
comment on column apex_application_page_flash5.y_axis_decimal_place    is 'Number of decimal places to use in Y Axis values';
comment on column apex_application_page_flash5.y_axis_major_interval   is 'The major scale step, used for the Y axis labels, major tickmarks and minor grid on your chart';
comment on column apex_application_page_flash5.y_axis_minor_interval   is 'The minor scale step, used for the Y axis labels, minor tickmarks and minor grid on your chart';
comment on column apex_application_page_flash5.extra_y_axis_min        is 'The smallest data value to appear on the extra Y Axis';
comment on column apex_application_page_flash5.extra_y_axis_max        is 'The highest data value to appear on the extra Y Axis';
comment on column apex_application_page_flash5.values_prefix           is 'Text to display before values on a Pie chart';
comment on column apex_application_page_flash5.values_postfix          is 'Text to display after values on a Pie chart';
comment on column apex_application_page_flash5.async_update            is 'A flag to enable an asynchronous graph update';
comment on column apex_application_page_flash5.async_time              is 'The interval in seconds between chart updates';
comment on column apex_application_page_flash5.values_font             is 'Chart value text font settings';
comment on column apex_application_page_flash5.values_rotation         is 'The amount of rotation for the values';
comment on column apex_application_page_flash5.tooltip_font            is 'Chart hint text font settings';
comment on column apex_application_page_flash5.legend_font             is 'Chart legend text font settings';
comment on column apex_application_page_flash5.legend_title_font       is 'Chart legend title text font settings';
comment on column apex_application_page_flash5.grid_labels_font        is 'Chart grid label font settings';
comment on column apex_application_page_flash5.chart_title_font        is 'Chart title font settings';
comment on column apex_application_page_flash5.x_axis_title_font       is 'X Axis title font settings';
comment on column apex_application_page_flash5.y_axis_title_font       is 'Y Axis title font settings';
comment on column apex_application_page_flash5.use_chart_xml           is 'A flag to override generated XML and use a custom chart XML';
comment on column apex_application_page_flash5.chart_xml               is 'User defined custom Chart XML for the Flash chart';
comment on column apex_application_page_flash5.last_updated_by         is 'APEX developer who made last update';
comment on column apex_application_page_flash5.last_updated_on         is 'Date of last update';
comment on column apex_application_page_flash5.component_signature     is 'Identifies attributes defined at a given component level to facilitate application comparisons';


prompt ...apex_application_page_flash5_s

create or replace view apex_application_page_flash5_s
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    c.page_id                        page_id,
    (select name
     from wwv_flow_steps
     where id = c.page_id
     and flow_id = c.flow_id)        page_name,
    c.region_id                      region_id,
    (select plug_name
     from wwv_flow_page_plugs
     where id = c.region_id
     and flow_id = c.flow_id)        region_name,
    --
    cs.chart_id                      chart_id,
    cs.id                            series_id,
    cs.series_seq                    series_seq,
    cs.series_name                   series_name,
    cs.series_type                   series_type,
    decode(substr(cs.series_required_role,1,1),'!','Not ')||
    nvl((select name
     from   wwv_flow_security_schemes
     where  to_char(id) = ltrim(cs.series_required_role,'!')
     and    flow_id = f.application_id),
     cs.series_required_role)        authorization_scheme,
    cs.series_required_role          authorization_scheme_id,
    (select case when cs.required_patch > 0 then PATCH_NAME else '{Not '||PATCH_NAME||'}' end PATCH_NAME
     from   wwv_flow_patches
     where  id =abs(cs.REQUIRED_PATCH))   build_option,
    cs.required_patch                build_option_id,
    cs.series_query_type             series_query_type,
    cs.series_query                  series_query,
    cs.series_ajax_items_to_submit   series_ajax_items_to_submit,
    cs.series_query_parse_opt        series_query_parse_opt,
    cs.series_query_no_data_found    series_query_no_data_found,
    cs.series_query_row_count_max    series_query_row_count_max,
    cs.action_link                   action_link,
    cs.show_action_link              show_action_link,
    cs.action_link_checksum_type     action_link_checksum_type,
    nvl((select r from apex_standard_conditions where d = cs.DISPLAY_WHEN_COND_TYPE),cs.DISPLAY_WHEN_COND_TYPE)
                                     condition_type,
    cs.display_when_cond_type        condition_type_code,
    cs.DISPLAY_WHEN_CONDITION        condition_expression1,
    cs.DISPLAY_WHEN_CONDITION2       condition_expression2,
    cs.updated_on                    last_updated_on,
    cs.updated_by                    last_updated_by,
    --
    cs.series_name
    ||' seq='||lpad(cs.series_seq,5,'00000')
    ||' q='||sys.dbms_lob.substr(cs.series_query,20,1)||'.'||sys.dbms_lob.getlength(cs.series_query)
    ||' max='||cs.series_query_row_count_max
    ||' nd_msg='|| substr(cs.series_query_no_data_found ,1,20)||length(cs.series_query_no_data_found)
    ||' link='||substr(cs.action_link,1,20)||':'||cs.show_action_link
    component_signature
from wwv_flow_flash_chart5_series cs,
     wwv_flow_flash_charts_5      c,
     wwv_flow_authorized          f
where f.workspace_id      = c.security_group_id
  and f.application_id    = c.flow_id
  and c.security_group_id = cs.security_group_id
  and c.flow_id           = cs.flow_id
  and c.id                = cs.chart_id
/

comment on table  apex_application_page_flash5_s                            is 'Identifies the Flash chart series which comprise a Flash chart';
comment on column apex_application_page_flash5_s.workspace                  is 'A work area mapped to one or more database schemas';
comment on column apex_application_page_flash5_s.workspace_display_name     is 'Display name for the workspace';
comment on column apex_application_page_flash5_s.application_id             is 'Application Primary Key, Unique over all workspaces';
comment on column apex_application_page_flash5_s.application_name           is 'Identifies the application';
comment on column apex_application_page_flash5_s.page_id                    is 'ID of the application page';
comment on column apex_application_page_flash5_s.page_name                  is 'Name of the application page';
comment on column apex_application_page_flash5_s.region_name                is 'Identifies the region name in which this Flash chart series is displayed';
comment on column apex_application_page_flash5_s.region_id                  is 'Identifies the Page Region foreign key to the apex_application_page_regions view';
comment on column apex_application_page_flash5_s.chart_id                   is 'Foreign key of the Flash chart';
comment on column apex_application_page_flash5_s.series_id                  is 'Primary Key of the Flash chart series';
comment on column apex_application_page_flash5_s.series_seq                 is 'Identifies the series sequence to determine the order of evaluation';
comment on column apex_application_page_flash5_s.series_name                is 'Flash chart series name';
comment on column apex_application_page_flash5_s.series_type                is 'Flash chart series type: Bar, Line or Marker for charts. Bubble,Line,Marker or Map for Maps';
comment on column apex_application_page_flash5_s.authorization_scheme       is 'Identifies an Authorization Scheme that will be applied to the chart series query';
comment on column apex_application_page_flash5_s.authorization_scheme_id    is 'Identifies an Authorization Scheme foreign key';
comment on column apex_application_page_flash5_s.build_option               is 'Chart Series query will be processed if the Build Option is enabled';
comment on column apex_application_page_flash5_s.build_option_id            is 'Identifies the primary key of this component';
comment on column apex_application_page_flash5_s.series_query               is 'SQL statement that will return the data to display the chart series';
comment on column apex_application_page_flash5_s.series_query_type          is 'The query source type';
comment on column apex_application_page_flash5_s.series_ajax_items_to_submit is 'Identifies the page items which should be submitted when an Ajax call is performed for the chart series.';
comment on column apex_application_page_flash5_s.series_query_parse_opt     is 'A flag to perform query validation  when saving chart query';
comment on column apex_application_page_flash5_s.series_query_no_data_found is 'Defines the text message that displays when the query does not return any rows.';
comment on column apex_application_page_flash5_s.series_query_row_count_max is 'Defines the maximum number of rows to query.';
comment on column apex_application_page_flash5_s.condition_type             is 'Identifies the condition type that must be met in order for the chart series to be rendered or processed.';
comment on column apex_application_page_flash5_s.condition_type_code        is 'Identifies the condition type code that must be met in order for the chart series to be rendered or processed.';
comment on column apex_application_page_flash5_s.condition_expression1      is 'Identifies the attribute that allows you to conditionally control whether or not a component is rendered or processed.';
comment on column apex_application_page_flash5_s.condition_expression2      is 'Identifies the second attribute that allows you to conditionally control whether or not a component is rendered or processed.';
comment on column apex_application_page_flash5_s.action_link                is 'Action link for the Flash chart series, used when chart item selected.';
comment on column apex_application_page_flash5_s.show_action_link           is 'Defines whether Action link for the Flash chart series is to be used.';
comment on column apex_application_page_flash5_s.action_link_checksum_type  is 'An appropriate checksum when linking to protected pages';
comment on column apex_application_page_flash5_s.last_updated_by            is 'APEX developer who made last update';
comment on column apex_application_page_flash5_s.last_updated_on            is 'Date of last update';
comment on column apex_application_page_flash5_s.component_signature is 'Identifies attributes defined at a given component level to facilitate application comparisons';


--------------------------------------------------------------------------------
-- A P P L I C A T I O N   J E T   C H A R T S
--
prompt ...apex_application_page_charts

create or replace view apex_application_page_charts
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    p.id                             page_id,
    p.name                           page_name,
    c.region_id                      region_id,
    (select plug_name
     from wwv_flow_page_plugs
     where id = c.region_id)         region_name,
    c.id                             chart_id,
    --
    decode(c.chart_type,
    'area', 'Area',
    'bar', 'Bar',
    'bubble', 'Bubble',
    'combo', 'Combination',
    'dial', 'Status Meter Gauge',
    'funnel', 'Funnel',
    'line', 'Line',
    'lineWithArea', 'Line with Area',
    'pie', 'Pie',
    'scatter', 'Scatter',
    'spark', 'Spark',
    'donut','Donut',
    'range','Range',
    'polar','Polar',
    'pyramid','Pyramid',
    'radar','Radar',
    'stock','Stock',
    'gantt','Gantt',
    c.chart_type)                    chart_type,
    c.title                          chart_title,
    c.width                          chart_width,
    c.height                         chart_height,
    --
    decode(c.animation_on_display,
    'alphaFade', 'Alpha Fade',
    'auto', 'Automatic',
    'none','None',
    'zoom','Zoom',
    c.animation_on_display)          animation_on_display,
    decode(c.animation_on_data_change,
    'auto', 'Automatic',
    'slideToLeft','Slide to Left',
    'slideToRight','Slide to Right',
    'none','None',
    animation_on_data_change)        animation_on_data_change,
    decode(c.orientation,
    'vertical','Vertical',
    'horizontal','Horizontal',
    c.orientation)                   orientation,
    decode(c.data_cursor,
    'auto','Automatic',
    'on','On',
    'off','Off',
    c.data_cursor)                   data_cursor,
    decode(c.data_cursor_behavior,
    'auto','Automatic',
    'smooth','Smooth',
    'snap','Snap',
    c.data_cursor_behavior)          data_cursor_behavior,
    decode(c.hide_and_show_behavior,
    'none','None',
    'withRescale','With Rescale',
    'withoutRescale', 'Without Rescale',
    c.hide_and_show_behavior)        hide_and_show_behavior,
    decode(c.hover_behavior,
    'dim','Dim',
    'none','None',
    c.hover_behavior)                hover_behavior,
    decode(c.stack,
    'on','On',
    'off','Off',
    c.stack)                         stack,
    decode(c.stack_label,
    'on','On',
    'off','Off',
    c.stack_label)                   stack_label,
    decode(c.spark_chart,
    'Y','Yes',
    'N','No',
    c.spark_chart)                   spark_chart,
    decode(c.connect_nulls,
    'Y','Yes',
    'N','No',
    c.connect_nulls)                 connect_nulls,
    decode(c.stock_render_as,
    'area', 'Area',
    'bar', 'Bar',
    'candlestick','Candlestick',
    'line', 'Line',
    'lineWithArea', 'Line with Area',
    c.stock_render_as)               stock_render_as,
    --
    c.value_min                      value_min,
    decode(c.value_text_type,
    'number','Number',
    'percent','Percent',
    c.value_text_type)               value_text_type,
    decode(c.value_position,
      'auto', 'Automatic',
      'center','Center',
      'insideIndicatorEdge', 'Inside Indicator Edge',
      'outsideIndicatorEdge', 'Outside Indicator Edge',
      'outsidePlotArea','Outside Plot Area',
      'withLabel','With Label',
    c.value_position)                value_position,
    c.value_format_type              value_format_type,
    c.value_decimal_places           value_decimal_places,
    c.value_currency                 value_currency,
    c.value_numeric_pattern          value_numeric_pattern,
    decode(c.value_format_scaling,
    'auto','Automatic',
    'none','None',
    'thousand','Thousand',
    'million','Million',
    'billion','Billion',
    'trillion','Trillion',
    'quadrillion','Quadrillion',
    c.value_format_scaling)          value_format_scaling,
    --
    decode(c.sorting,
       'value-asc','Value - Ascending',
       'value-desc','Value - Descending',
       'label-asc','Label - Ascending',
       'label-asc','Label - Descending',
       c.sorting)                    chart_sort_order,
    decode(c.fill_multi_series_gaps,
    'Y','Yes',
    'N','No',
    c.fill_multi_series_gaps)        fill_multi_series_gaps,
    --
    decode(c.zoom_and_scroll,
    'delayed','Delayed',
    'delayedScrollOnly','Delayed Scroll Only',
    'live','Live',
    'liveScrollOnly','Live Scroll Only',
    'off','Off',
    c.zoom_and_scroll)               zoom_and_scroll,
    --
    decode(c.zoom_direction,
    'auto','Both X and Y axes',
    'x','X-Axis',
    'y','Y-Axis',
    c.zoom_direction)                zoom_direction,
    --
    decode(c.initial_zooming,
    'none','None',
    'first','First',
    'last','Last',
    c.initial_zooming)               initial_zooming,
    --
    decode(c.tooltip_rendered,
    'Y','Yes',
    'N','No',
    c.tooltip_rendered)              tooltip_rendered,
    decode(c.show_series_name,
    'Y','Yes',
    'N','No',
    c.show_series_name)              show_series_name,
    decode(c.show_group_name,
    'Y','Yes',
    'N','No',
    c.show_group_name)               show_group_name,
    decode(c.show_value,
    'Y','Yes',
    'N','No',
    c.show_value)                    show_value,
    decode(c.show_label,
    'Y','Yes',
    'N','No',
    c.show_label)                    show_label,
    decode(c.show_row,
    'Y','Yes',
    'N','No',
    c.show_row)                      show_row,
    decode(c.show_start,
    'Y','Yes',
    'N','No',
    c.show_start)                    show_start,
    decode(c.show_end,
    'Y','Yes',
    'N','No',
    c.show_end)                      show_end,
    decode(c.show_progress,
    'Y','Yes',
    'N','No',
    c.show_progress)                 show_progress,
    decode(c.show_baseline,
    'Y','Yes',
    'N','No',
    c.show_baseline)                 show_baseline,
    c.custom_tooltip                 custom_tooltip,
    --
    decode(c.legend_rendered,
    'on','On',
    'off','Off',
    c.legend_rendered)               legend_rendered,
    c.legend_title                   legend_title,
    decode(c.legend_position,
    'start','Start',
    'end','End',
    'bottom','Bottom',
    'top','Top',
    'auto','Automatic',
    c.legend_position)               legend_position,
    c.legend_font_family             legend_font_family,
    decode (c.legend_font_style,
    'normal','Normal',
    'italic','Italic',
    'oblique','Oblique',
    c.legend_font_style)             legend_font_style,
    c.legend_font_size               legend_font_size,
    c.legend_font_color              legend_font_color,
    --
    decode(c.overview_rendered,
    'on','On',
    'off','Off',
    c.overview_rendered)             overview_rendered,
    c.overview_height                overview_height,
    c.pie_other_threshold            pie_other_threshold,
    decode(c.pie_selection_effect,
    'explode','Explode',
    'highlightAndExplode','Highlight and Explode',
    'highlight','Highlight',
    c.pie_selection_effect)          pie_selection_effect,
    decode(c.time_axis_type,
    'enabled','Enabled',
    'mixedFrequency','Mixed Frequency',
    'disabled','Disabled',
    'auto','Automatic',
    c.time_axis_type)                time_axis_type,
    --
    decode(c.horizontal_grid,
      'auto','Automatic',
      'hidden','Hidden',
      'visible','Visible',
      c.horizontal_grid)             horizontal_grid,
    decode(c.vertical_grid,
      'auto','Automatic',
      'hidden','Hidden',
      'visible','Visible',
      c.vertical_grid)               vertical_grid,
    decode(c.row_axis_rendered,
      'on','On',
      'off','Off',
      c.row_axis_rendered )          row_axis_rendered,
    decode (c.gantt_axis_position,
       'top','Top',
       'bottom','Bottom',
       c.gantt_axis_position )       gantt_axis_position,
    --
    decode(c.gauge_orientation,
      'circular','Circular',
      'horizontal','Horizontal',
      'vertical','Vertical',
      c.gauge_orientation)           gauge_orientation,
    c.gauge_indicator_size           gauge_indicator_size,
    c.gauge_inner_radius             gauge_inner_radius,
    decode(c.gauge_plot_area,
      'on','On',
      'off','Off',
      c.gauge_plot_area)             gauge_plot_area,
    c.gauge_start_angle              gauge_start_angle,
    c.gauge_angle_extent             gauge_angle_extent,
    decode(c.show_gauge_value,
      'Y','Yes',
      'N','No',
      c.show_gauge_value)            show_gauge_value,
    --
    c.no_data_found_message,
    c.javascript_code                javascript_code,
    --
    (select count(*) from wwv_flow_jet_chart_axes where chart_id = c.id) number_of_axes,
    (select count(*) from wwv_flow_jet_chart_series where chart_id = c.id) number_of_series,
    --
    c.updated_by                     last_updated_by,
    c.updated_on                     last_updated_on,
    --
    decode(c.chart_type,
    'area', 'Area',
    'bar', 'Bar',
    'bubble', 'Bubble',
    'combo', 'Combination',
    'dial', 'Status Meter Gauge',
    'funnel', 'Funnel',
    'line', 'Line',
    'lineWithArea', 'Line with Area',
    'pie', 'Pie',
    'scatter', 'Scatter',
    'spark', 'Spark',
    'donut','Donut',
    'range','Range',
    'polar','Polar',
    'pyramid','Pyramid',
    'radar','Radar',
    'stock','Stock',
    'gantt','Gantt',
    c.chart_type)
    ||' title='||substr(c.title,1,20)||'.'||length(c.title)
    ||' javascript='||sys.dbms_lob.substr(c.javascript_code,30,1)||'.'||sys.dbms_lob.getlength(c.javascript_code)  component_signature
from wwv_flow_jet_charts c,
     wwv_flow_steps      p,
     wwv_flow_authorized f
where f.workspace_id      = p.security_group_id
  and f.application_id    = p.flow_id
  and p.security_group_id = c.security_group_id
  and p.flow_id           = c.flow_id
  and p.id                = c.page_id
/

comment on table  apex_application_page_charts                          is 'Identifies a chart associated with a Page and Region.';
comment on column apex_application_page_charts.workspace                is 'A work area mapped to one or more database schemas.';
comment on column apex_application_page_charts.workspace_display_name   is 'Display name for the workspace.';
comment on column apex_application_page_charts.application_id           is 'Application Primary Key, Unique over all workspaces.';
comment on column apex_application_page_charts.application_name         is 'Identifies the application.';
comment on column apex_application_page_charts.page_id                  is 'ID of the application page.';
comment on column apex_application_page_charts.page_name                is 'Name of the application page.';
comment on column apex_application_page_charts.region_name              is 'Identifies the region name in which this chart is displayed.';
comment on column apex_application_page_charts.region_id                is 'Identifies the Page Region foreign key to the apex_application_page_regions view.';
comment on column apex_application_page_charts.chart_id                 is 'Primary Key of the chart.';
comment on column apex_application_page_charts.chart_type               is 'Chart type to indicate the style in which the chart will render.';
comment on column apex_application_page_charts.chart_title              is 'A title to display at the top of the chart.';
comment on column apex_application_page_charts.chart_width              is 'Width of the chart.';
comment on column apex_application_page_charts.chart_height             is 'Height of the chart.';
comment on column apex_application_page_charts.animation_on_display     is 'An animation to control the initial appearance of the chart.';
comment on column apex_application_page_charts.animation_on_data_change is 'An animation to control the appearance of the chart following a data change.';
comment on column apex_application_page_charts.orientation              is 'Identifies the orientation of the chart.  Only applies to bar, line, area, combo, and funnel charts.';
comment on column apex_application_page_charts.data_cursor              is 'Identifies whether a cursor will be rendered on the chart.';
comment on column apex_application_page_charts.data_cursor_behavior     is 'Identifies the behavior of the cursor when moving between data items on the chart.';
comment on column apex_application_page_charts.hide_and_show_behavior   is 'Defines the hide and show behavior that is performed when clicking on a legend item.';
comment on column apex_application_page_charts.hover_behavior           is 'Defines the behavior applied when hovering over data items.';
comment on column apex_application_page_charts.stack                    is 'Defines whether the data items are stacked. Only applies to bar, line, area, and combo charts. Does not apply to range series.';
comment on column apex_application_page_charts.stack_label              is 'Defines whether the total values of stacked data items should be displayed. Only applies to bar charts.';
comment on column apex_application_page_charts.spark_chart              is 'Identifies whether the chart is to be rendered as a spark chart.';
comment on column apex_application_page_charts.connect_nulls            is 'Specifies the handling of connecting null data points on a multi-series line chart.';
comment on column apex_application_page_charts.stock_render_as          is 'Identifies the type of series to be used to render the stock chart.';
comment on column apex_application_page_charts.value_min                is 'The minimum value of the gauge chart.';
comment on column apex_application_page_charts.value_text_type          is 'Specifies whether the tick labels on a dial gauge chart label are displayed as a number or as a percentage of the total value.';
comment on column apex_application_page_charts.value_position           is 'Specifies the position of the value on a Status Meter Gauge chart.';
comment on column apex_application_page_charts.value_format_type        is 'The format type to be used to represent the values.';
comment on column apex_application_page_charts.value_decimal_places     is 'Number of decimal places to use in values.';
comment on column apex_application_page_charts.value_currency           is 'The ISO 4217 alphabetic currency code used to represent monetary values.';
comment on column apex_application_page_charts.value_numeric_pattern    is 'The numeric pattern used to represent numeric values.';
comment on column apex_application_page_charts.value_format_scaling     is 'The scaling behavior of the values.';
comment on column apex_application_page_charts.chart_sort_order         is 'Identifies the current chart sorting method to be applied to a multi-series chart.';
comment on column apex_application_page_charts.fill_multi_series_gaps   is 'Identifies whether gaps in a multi-series chart should be automatically filled.';
comment on column apex_application_page_charts.zoom_and_scroll          is 'Specifies the zoom and scroll behavior of the chart.';
comment on column apex_application_page_charts.zoom_direction           is 'Specifies the zoom direction on a bubble or scatter chart.';
comment on column apex_application_page_charts.initial_zooming          is 'Specifies the initial zooming position on the chart.';
comment on column apex_application_page_charts.tooltip_rendered         is 'Specifies whether a tooltip is rendered on the chart.';
comment on column apex_application_page_charts.show_series_name         is 'Specifies whether the series name should be included in the tooltip.';
comment on column apex_application_page_charts.show_group_name          is 'Specifies whether the group name should be included in the tooltip.';
comment on column apex_application_page_charts.show_value               is 'Specifies whether the value should be included in the tooltip.';
comment on column apex_application_page_charts.show_label               is 'Specifies whether the label should be included in the tooltip.';
comment on column apex_application_page_charts.show_row                 is 'Specifies whether the row information should be included in the tooltip.';
comment on column apex_application_page_charts.show_start               is 'Specifies whether the start date should be included in the tooltip.';
comment on column apex_application_page_charts.show_end                 is 'Specifies whether the end date should be included in the tooltip.';
comment on column apex_application_page_charts.show_progress            is 'Specifies whether the progress information should be included in the tooltip.';
comment on column apex_application_page_charts.show_baseline            is 'Specifies whether the baseline information should be included in the tooltip.';
comment on column apex_application_page_charts.custom_tooltip           is 'Specifies the custom tooltip to be used on the chart.';
comment on column apex_application_page_charts.legend_rendered          is 'Specifies whether a legend is rendered on the chart.';
comment on column apex_application_page_charts.legend_title             is 'A title to display at the top of the legend.';
comment on column apex_application_page_charts.legend_position          is 'Specifies the position of the legend.';
comment on column apex_application_page_charts.legend_font_family       is 'Defines the font family of the legend entry.';
comment on column apex_application_page_charts.legend_font_style        is 'Defines the font style of the legend entry.';
comment on column apex_application_page_charts.legend_font_size         is 'Defines the font size of the legend entry.';
comment on column apex_application_page_charts.legend_font_color        is 'Defines the color of the legend entry.';
comment on column apex_application_page_charts.overview_rendered        is 'Specifies whether an overview scrollbar is visible on the chart. Only applies if "Zoom and Scroll" is not off. Currently only supported for vertical bar, line, area, stock, and combo charts.';
comment on column apex_application_page_charts.overview_height          is 'Specifies the height of the overview scrollbar in pixels (e.g. "50px") or percent (e.g. "15%").';
comment on column apex_application_page_charts.pie_other_threshold      is 'Specifies the fraction of the whole pie under which a slice would be aggregated into an "Other" slice. Valid values range from 0 (default) to 1.';
comment on column apex_application_page_charts.time_axis_type           is 'The type of time axis to display in the chart.';
comment on column apex_application_page_charts.no_data_found_message    is 'Message to display when no rows are returned by the chart';
comment on column apex_application_page_charts.horizontal_grid          is 'Specifies the visibility of the gantt chart horizontal grid';
comment on column apex_application_page_charts.vertical_grid            is 'Specifies the visibility of the gantt chart vertical grid';
comment on column apex_application_page_charts.row_axis_rendered        is 'Specifies whether the gantt chart row axis is rendered';
comment on column apex_application_page_charts.gantt_axis_position      is 'Specifies the position of the gantt chart axis';
comment on column apex_application_page_charts.gauge_orientation        is 'Identifies the orientation of the Status Meter Gauge chart.';
comment on column apex_application_page_charts.gauge_indicator_size     is 'Identifies the indicator size, which defines the ratio of relative thickness of the indicator to the plot area of a Status Meter Gauge chart.';
comment on column apex_application_page_charts.gauge_inner_radius       is 'Specifies the inner radius of a Status Meter gauge with circular orientation, defined by the distance from the center of the gauge to the innermost edge of the indicator and plot area. Valid values are a percent or ratio from 0 to 1.';
comment on column apex_application_page_charts.gauge_plot_area          is 'Defines if the plot area of a Status Meter Gauge chart is to be rendered.';
comment on column apex_application_page_charts.gauge_start_angle        is 'Specifies the start angle of a Status Meter Gauge chart with circular orientation. The value is provided in degrees.';
comment on column apex_application_page_charts.gauge_angle_extent       is 'Specifies the angle extent of a Status Meter Gauge chart with circular orientation. The value is provided in degrees.';
comment on column apex_application_page_charts.show_gauge_value         is 'Specifies whether the value is rendered on the Status Meter Gauge chart.';
comment on column apex_application_page_charts.javascript_code          is 'User defined custom JavaScript code for the chart.';
comment on column apex_application_page_charts.number_of_axes           is 'Specifies the number of axes associated with the chart.';
comment on column apex_application_page_charts.number_of_series         is 'Specifies the number of series associated with the chart.';
comment on column apex_application_page_charts.last_updated_by          is 'APEX developer who made last update.';
comment on column apex_application_page_charts.last_updated_on          is 'Date of last update.';
comment on column apex_application_page_charts.component_signature      is 'Identifies attributes defined at a given component level to facilitate application comparisons.';

prompt ...apex_application_page_chart_s

create or replace view apex_application_page_chart_s
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    c.page_id                            page_id ,
    (select name
     from wwv_flow_steps
     where id = c.page_id
     and flow_id = c.flow_id)            page_name,
    c.region_id                          region_id,
    (select plug_name
     from wwv_flow_page_plugs
     where id = c.region_id
     and flow_id = c.flow_id)            region_name,
    --
    cs.chart_id                          chart_id,
    cs.id                                series_id,
    cs.seq                               series_seq,
    cs.name                              series_name,
    --
    decode(cs.data_source_type,
      'SQL_QUERY','SQL Query',
      'FUNCTION_RETURNING_SQL_QUERY','PL/SQL Function Body returning SQL Query',
      'REGION_SOURCE', 'Region Source',
      'TABLE',       'Table',
    cs.data_source_type)                 data_source_type,
    cs.data_source                       data_source,
    cs.max_row_count                     max_row_count,
    cs.ajax_items_to_submit              items_to_submit,
    --
    cs.location                          location_code,
    decode( cs.location,
       'LOCAL',       'Local Database',
       'REMOTE',      'Remote Database',
       'WEB_SOURCE',  'Web Source' )     location,
    cs.query_owner                       table_owner,
    cs.query_table                       table_name,
    cs.query_where                       where_clause,
    cs.query_order_by                    order_by_clause,
    decode( cs.source_post_processing,
       'SQL', 'SQL Query',
       'WHERE_ORDER_BY_CLAUSE', 'Where/Order By Clause',
       'FUNC_BODY_RETURNING_SQL', 'PL/SQL Function Body returning SQL Query' ) source_post_processing,
    decode(cs.include_rowid_column,
    'Y','Yes',
    'N','No',
    cs.include_rowid_column)             include_rowid_column,
    cs.optimizer_hint,
    --
    (select name
       from wwv_remote_servers
      where id = cs.remote_server_id)    remote_database_name,
    cs.remote_server_id                  remote_database_id,
    (select name
       from wwv_flow_web_src_modules
      where id = cs.web_src_module_id)   web_source_module_name,
    cs.web_src_module_id                 web_source_module_id,
    --
    cs.external_filter_expr,
    cs.external_order_by_expr,
    --
    decode(cs.series_type,
      'area','Area',
      'auto','Automatic',
      'areaRange','Area Range',
      'bar','Bar',
      'barRange','Bar Range',
      'line','Line',
      'lineWithArea','Line with Area',
      'candlestick','Candlestick',
      'boxPlot', 'Box Plot',
      'gantt','Gantt',
    cs.series_type)                       series_type,
    cs.series_name_column_name            series_name_column_name,
    cs.items_value_column_name            items_value_column_name,
    cs.items_label_column_name            items_label_column_name,
    cs.items_short_desc_column_name       items_short_desc_column_name,
    cs.items_low_column_name              items_low_column_name,
    cs.items_high_column_name             items_high_column_name,
    cs.items_open_column_name             items_open_column_name,
    cs.items_close_column_name            items_close_column_name,
    cs.items_volume_column_name           items_volume_column_name,
    cs.items_x_column_name                items_x_column_name,
    cs.items_y_column_name                items_y_column_name,
    cs.items_z_column_name                items_z_column_name,
    cs.items_target_value                 items_target_value,
    cs.items_min_value                    items_min_value,
    cs.items_max_value                    items_max_value,
    cs.group_name_column_name             group_name_column_name,
    cs.group_short_desc_column_name       group_short_desc_column_name,
    cs.custom_column_name                 custom_column_name,
    --
    cs.aggregate_function                 aggregate_function,
    --
    cs.color                              color,
    cs.q2_color                           q2_color,
    cs.q3_color                           q3_color,
    decode(cs.line_style,
      'dashed','Dashed',
      'dotted','Dotted',
      'solid','Solid',
    cs.line_style)                        line_style,
    cs.line_width                         line_width,
    decode(cs.line_type,
      'auto','Automatic',
      'centeredStepped','Centered Stepped',
      'centeredSegmented','Centered Segmented',
      'curved','Curved',
      'segmented','Segmented',
      'stepped','Stepped',
      'straight','Straight',
      'none','None',
    cs.line_type)                         line_type,
    --
    decode(cs.marker_rendered,
    'auto','Automatic',
    'on','On',
    'off','Off',
    cs.marker_rendered)                   marker_rendered,
    decode(cs.marker_shape,
      'auto','Automatic',
      'circle','Circle',
      'diamond','Diamond',
      'plus','Plus',
      'triangleDown','Triangle Down',
      'triangleUp','Triangle Up',
      'human','Human',
      'square','Square',
    cs.marker_shape)                      marker_shape,
    cs.assigned_to_y2                     assigned_to_y2,
    cs.stack_category                     stack_category,
    --
    decode(cs.items_label_rendered,
    'Y','Yes',
    'N','No',
    cs.items_label_rendered)              items_label_rendered,
    decode(cs.items_label_position,
      'center','Center',
      'aboveMarker','Above Marker',
      'belowMarker','Below Marker',
      'beforeMarker','Before Marker',
      'afterMarker','After Marker',
      'insideBarEdge','Inside Bar Edge',
      'outsideBarEdge','Outside Bar Edge',
      'auto','Automatic',
    cs.items_label_position)              items_label_position,
    decode(cs.items_label_display_as,
           'LABEL', 'Label',
           'VALUE', 'Value',
           'PERCENT','Percentage Value',
           'ALL','All',
           'COMBO', 'Combination',
           'LBL_VAL','Label - Value',
           cs.items_label_display_as)     items_label_display_as,
    cs.items_label_css_classes            items_label_css_classes,
    cs.items_label_font_family            items_label_font_family,
    decode (cs.items_label_font_style,
    'normal','Normal',
    'italic','Italic',
    'oblique','Oblique',
    cs.items_label_font_style)            items_label_font_style,
    cs.items_label_font_size              items_label_font_size,
    cs.items_label_font_color             items_label_font_color,
    --
    cs.gantt_start_date_source,
    cs.gantt_start_date_column,
    cs.gantt_start_date_item,
    cs.gantt_end_date_source,
    cs.gantt_end_date_column,
    cs.gantt_end_date_item,
    cs.gantt_row_id,
    cs.gantt_row_name,
    cs.gantt_task_id,
    cs.gantt_task_name,
    cs.gantt_task_start_date,
    cs.gantt_task_end_date,
    cs.gantt_task_css_style,
    cs.gantt_task_css_class,
    cs.gantt_predecessor_task_id,
    cs.gantt_successor_task_id,
    cs.gantt_baseline_start_column,
    cs.gantt_baseline_end_column,
    cs.gantt_baseline_css_class,
    cs.gantt_progress_column,
    cs.gantt_progress_css_class,
    cs.gantt_viewport_start_source,
    cs.gantt_viewport_start_column,
    cs.gantt_viewport_start_item,
    cs.gantt_viewport_end_source,
    cs.gantt_viewport_end_column,
    cs.gantt_viewport_end_item,
    decode (cs.task_label_position,
       'end','End',
       'innerCenter', 'Inner Center',
       'innerEnd','Inner End',
       'innerStart','Inner Start',
       'none','None',
       'start','Start',
       cs.task_label_position)            task_label_position,
    --
    cs.gauge_plot_area_color              gauge_plot_area_color,
    cs.threshold_values                   threshold_values,
    cs.threshold_colors                   threshold_colors,
    decode (cs.threshold_display,
      'all', 'All thresholds displayed in plot area',
      'currentOnly', 'Current threshold displayed in plot area',
      'onIndicator','Current threshold displayed on gauge indicator',
    cs.threshold_display)                 threshold_display,
    cs.reference_line_values              reference_line_values,
    cs.reference_line_colors              reference_line_colors,
    --
    cs.link_target                        link_target,
    decode(cs.link_target_type,
      'REDIRECT_URL','URL',
      'REDIRECT_PAGE','Page in this application',
      'REDIRECT_APP','Page in a different application',
      'DEFINED_BY_DA','Defined by a Dynamic Action',
    cs.link_target_type)                  link_target_type,
    --
    decode(substr(cs.security_scheme,1,1),'!','Not ')||
      nvl((select name
             from wwv_flow_security_schemes
            where to_char(id) = ltrim(cs.security_scheme,'!')
              and flow_id = f.application_id),
    cs.security_scheme)                   authorization_scheme,
    cs.security_scheme                    authorization_scheme_id,
    (select case
              when cs.required_patch > 0
                then PATCH_NAME
              else '{Not '||PATCH_NAME||'}'
            end PATCH_NAME
       from wwv_flow_patches
      where id =abs(cs.REQUIRED_PATCH))   build_option,
    cs.required_patch                     build_option_id,
    --
    cs.series_comment                     series_comment,
    nvl((select r
           from apex_standard_conditions
          where d = cs.DISPLAY_WHEN_COND_TYPE),
    cs.DISPLAY_WHEN_COND_TYPE)            condition_type,
    cs.display_when_cond_type             condition_type_code,
    cs.DISPLAY_WHEN_CONDITION             condition_expression1,
    cs.DISPLAY_WHEN_CONDITION2            condition_expression2,
    cs.updated_on                         last_updated_on,
    cs.updated_by                         last_updated_by,
    --
    cs.name
    ||' seq='||lpad(cs.seq,5,'00000')
    ||' q='||sys.dbms_lob.substr(cs.data_source,20,1)||'.'||sys.dbms_lob.getlength(cs.data_source)
    ||' max='||cs.max_row_count
    ||' link='||substr(cs.link_target,1,20) component_signature
from wwv_flow_jet_chart_series cs,
     wwv_flow_jet_charts       c,
     wwv_flow_authorized       f
where f.workspace_id      = c.security_group_id
  and f.application_id    = c.flow_id
  and c.security_group_id = cs.security_group_id
  and c.flow_id           = cs.flow_id
  and c.id                = cs.chart_id
/

comment on table  apex_application_page_chart_s                               is 'Identifies a chart series associated with a chart on a Page and Region.';
comment on column apex_application_page_chart_s.workspace                     is 'A work area mapped to one or more database schemas.';
comment on column apex_application_page_chart_s.workspace_display_name        is 'Display name for the workspace.';
comment on column apex_application_page_chart_s.application_id                is 'Application Primary Key, Unique over all workspaces.';
comment on column apex_application_page_chart_s.application_name              is 'Identifies the application.';
comment on column apex_application_page_chart_s.page_id                       is 'ID of the application page.';
comment on column apex_application_page_chart_s.page_name                     is 'Name of the application page.';
comment on column apex_application_page_chart_s.region_id                     is 'Identifies the Page Region foreign key to the apex_application_page_regions view.';
comment on column apex_application_page_chart_s.region_name                   is 'Identifies the region name in which this chart series is displayed.';
comment on column apex_application_page_chart_s.chart_id                      is 'Foreign Key of the chart.';
comment on column apex_application_page_chart_s.series_id                     is 'Primary Key of the chart series';
comment on column apex_application_page_chart_s.series_seq                    is 'Identifies the series sequence to determine the order of evaluation';
comment on column apex_application_page_chart_s.series_name                   is 'Chart series name';
comment on column apex_application_page_chart_s.data_source                   is 'The data source that will return the data to display the chart series';
comment on column apex_application_page_chart_s.data_source_type              is 'The data source type';
comment on column apex_application_page_chart_s.max_row_count                 is 'Defines the maximum number of rows to query.';
comment on column apex_application_page_chart_s.items_to_submit               is 'Identifies the page items which should be submitted when an Ajax call is performed for the chart series.';
comment on column apex_application_page_chart_s.location_code                 is 'Identifies the internal code of LOCATION';
comment on column apex_application_page_chart_s.location                      is 'Identifies whether the data source of the region is the local database, a remote database or a web source module';
comment on column apex_application_page_chart_s.table_owner                   is 'Denotes the table owner for TABLE query types';
comment on column apex_application_page_chart_s.table_name                    is 'Denotes the table name for TABLE query types';
comment on column apex_application_page_chart_s.where_clause                  is 'Identifies the WHERE clause provided by the developer and to be applied to TABLE or WEB SOURCE data sources.';
comment on column apex_application_page_chart_s.order_by_clause               is 'Identifies the ORDER BY clause provided by the developer and to be applied to TABLE or WEB SOURCE data sources';
comment on column apex_application_page_chart_s.source_post_processing        is 'Identifies type of SQL post processing for data from external data sources';
comment on column apex_application_page_chart_s.include_rowid_column          is 'Identifies if the pseudo column ROWID should be selected';
comment on column apex_application_page_chart_s.optimizer_hint                is 'Optimizer hint which is added to the region source SQL statement when it is executed';
comment on column apex_application_page_chart_s.remote_database_id            is 'Identifies the primary key of the remote database definition';
comment on column apex_application_page_chart_s.remote_database_name          is 'Identifies the name of the remote database';
comment on column apex_application_page_chart_s.web_source_module_id          is 'Identifies the primary key of the web source module';
comment on column apex_application_page_chart_s.web_source_module_name        is 'Identifies the web source module name';
comment on column apex_application_page_chart_s.external_filter_expr          is 'Filter expression to be sent to the external data source.';
comment on column apex_application_page_chart_s.external_order_by_expr        is 'Order By expression to be sent to the external data source.';
comment on column apex_application_page_chart_s.series_type                   is 'Chart series type: Bar, Area, Line, Line with Area, Candlestick, Bar Range, Area Range, or Automatic, which will automatically set the series type based upon the chosen chart type';
comment on column apex_application_page_chart_s.series_name_column_name       is 'Identifies the "Series Name" column from a multi-series query';
comment on column apex_application_page_chart_s.items_value_column_name       is 'Depending on the chosen chart type, identifies the "Value" column for the chart.  Only for Bar, Line, Area, Combination, Pie, Funnel,Pyramid, and Dial Gauge charts.';
comment on column apex_application_page_chart_s.items_label_column_name       is 'Identifies the "Label" column for the chart, for those chart types that do not use the "Groups" attribute in Oracle JET Charts.';
comment on column apex_application_page_chart_s.items_short_desc_column_name  is 'Identifies the column used to display a custom tooltip on the data point(s) of the chart.';
comment on column apex_application_page_chart_s.items_low_column_name         is 'Identifies the column used to display the low value on a Bar Range, Area Range, or Candlestick chart.';
comment on column apex_application_page_chart_s.items_high_column_name        is 'Identifies the column used to display the high value on a Bar Range, Area Range, or Candlestick chart.';
comment on column apex_application_page_chart_s.items_open_column_name        is 'Identifies the column used to display the opening value on a Stock chart.';
comment on column apex_application_page_chart_s.items_close_column_name       is 'Identifies the column used to display the closing value on a Stock chart.';
comment on column apex_application_page_chart_s.items_volume_column_name      is 'Identifies the column used to display the volume value on a Stock chart.';
comment on column apex_application_page_chart_s.items_x_column_name           is 'Identifies the column used to display the X value on a Bubble or Scatter chart.';
comment on column apex_application_page_chart_s.items_y_column_name           is 'Identifies the column used to display the Y value on a Bubble or Scatter chart.';
comment on column apex_application_page_chart_s.items_z_column_name           is 'Identifies the column used to display the Z value on a Bubble or Scatter chart.';
comment on column apex_application_page_chart_s.items_target_value            is 'Identifies the column used to display the target value on a Funnel chart.';
comment on column apex_application_page_chart_s.items_min_value               is 'Identifies the column used to display the minimum value on a Dial Gauge chart.';
comment on column apex_application_page_chart_s.items_max_value               is 'Identifies the column used to display the maximum value on a Dial Gauge chart.';
comment on column apex_application_page_chart_s.group_name_column_name        is 'Identifies the column used to display a tooltip on the series name(s) displayed on the chart legend.';
comment on column apex_application_page_chart_s.group_short_desc_column_name  is 'Identifies the column used to display a tooltip on the x-axis label(s) of the chart, for accessibility purposes.';
comment on column apex_application_page_chart_s.custom_column_name            is 'Identifies the custom column used to display a more detailed tooltip on the chart or custom colors based on a database value.';
comment on column apex_application_page_chart_s.aggregate_function            is 'Identifies the aggregate function to apply to the value column before rendering the chart.';
comment on column apex_application_page_chart_s.color                         is 'Identifies the color to be used to represent the items of the chart series.';
comment on column apex_application_page_chart_s.q2_color                      is 'Identifies the color to be used to represent the q2 segment of a Box Plot chart series.';
comment on column apex_application_page_chart_s.q3_color                      is 'Identifies the color to be used to represent the q3 segment of a Box Plot chart series.';
comment on column apex_application_page_chart_s.line_style                    is 'Identifies the style of the line to be rendered on the chart.';
comment on column apex_application_page_chart_s.line_width                    is 'Identifies the width of the line to be rendered on the chart.';
comment on column apex_application_page_chart_s.line_type                     is 'Identifies the type of line to be rendered on the chart.';
comment on column apex_application_page_chart_s.marker_rendered               is 'Identifies whether the marker is to be rendered on the chart.';
comment on column apex_application_page_chart_s.marker_shape                  is 'Identifies the shape of the marker displayed on the chart.';
comment on column apex_application_page_chart_s.assigned_to_y2                is 'Identifies whether the series is assigned to the extra Y axis on the chart.';
comment on column apex_application_page_chart_s.stack_category                is 'Identifies the stack category of the series, used to group stacked elements of the chart.';
comment on column apex_application_page_chart_s.items_label_rendered          is 'Identifies whether the label is rendered on a chart item.';
comment on column apex_application_page_chart_s.items_label_position          is 'Identifies the position of the label on a chart item.';
comment on column apex_application_page_chart_s.items_label_display_as        is 'Identifies the format of the label on the pie chart item';
comment on column apex_application_page_chart_s.items_label_css_classes       is 'Identifies the CSS classes used to display the label on a chart item.';
comment on column apex_application_page_chart_s.items_label_font_family       is 'Defines the font family of the label on a chart item.';
comment on column apex_application_page_chart_s.items_label_font_style        is 'Defines the font style of the label on a chart item.';
comment on column apex_application_page_chart_s.items_label_font_size         is 'Defines the font size of the label on a chart item.';
comment on column apex_application_page_chart_s.items_label_font_color        is 'Defines the color of the label on a chart item.';
comment on column apex_application_page_chart_s.gantt_start_date_source       is 'Identifies the data source for the Gantt chart start date.';
comment on column apex_application_page_chart_s.gantt_start_date_column       is 'Identifies the column used to display the Gantt chart start date.';
comment on column apex_application_page_chart_s.gantt_start_date_item         is 'Identifies the page item used to define the Gantt chart start date.';
comment on column apex_application_page_chart_s.gantt_end_date_source         is 'Identifies the data source for the Gantt chart end date.';
comment on column apex_application_page_chart_s.gantt_end_date_column         is 'Identifies the column used to display the Gantt chart end date.';
comment on column apex_application_page_chart_s.gantt_end_date_item           is 'Identifies the page item used to define the Gantt chart end date.';
comment on column apex_application_page_chart_s.gantt_row_id                  is 'Identifies the column used to display the row ID on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_row_name                is 'Identifies the column used to display the row name on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_task_id                 is 'Identifies the column used to display the task ID on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_task_name               is 'Identifies the column used to display the task name on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_task_start_date         is 'Identifies the column used to display the task start date on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_task_end_date           is 'Identifies the column used to display the task end date on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_task_css_style          is 'Identifies the column used to display the task css style on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_task_css_class          is 'Identifies the CSS class used to style the task bar on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_predecessor_task_id     is 'Identifies the column used to display the predecessor task ID on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_successor_task_id       is 'Identifies the column used to display the successor task ID on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_baseline_start_column   is 'Identifies the column used to display the baseline start date on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_baseline_end_column     is 'Identifies the column used to display the baseline end date on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_baseline_css_class      is 'Identifies the CSS class used to style the baseline bar on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_progress_column         is 'Identifies the column used to display the progress value on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_progress_css_class      is 'Identifies the CSS class used to style the progress bar on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_viewport_start_source   is 'Identifies the data source for the Gantt chart viewport start date.';
comment on column apex_application_page_chart_s.gantt_viewport_start_column   is 'Identifies the column used to display the viewport start date on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_viewport_start_item     is 'Identifies the page item used to define the Gantt chart viewport start date.';
comment on column apex_application_page_chart_s.gantt_viewport_end_source     is 'Identifies the data source for the Gantt chart viewport end date.';
comment on column apex_application_page_chart_s.gantt_viewport_end_column     is 'Identifies the column used to display the viewport end date on the gantt chart.';
comment on column apex_application_page_chart_s.gantt_viewport_end_item       is 'Identifies the page item used to define the Gantt chart viewport end date.';
comment on column apex_application_page_chart_s.task_label_position           is 'Specifies the position of the task label on the gantt chart.';
comment on column apex_application_page_chart_s.gauge_plot_area_color         is 'Identifies the color to be used to represent the plot area of a Status Meter Gauge chart.';
comment on column apex_application_page_chart_s.threshold_values              is 'Identifies the values to be used to define thresholds on a Status Meter Gauge chart.';
comment on column apex_application_page_chart_s.threshold_colors              is 'Identifies the colors to be used to represent thresholds on a Status Meter Gauge chart.';
comment on column apex_application_page_chart_s.threshold_display             is 'Identifies the location on a Status Meter Gauge chart where threshold colors are to be rendered.';
comment on column apex_application_page_chart_s.reference_line_values         is 'Identifies the values to be used to define reference lines on a Status Meter Gauge chart.';
comment on column apex_application_page_chart_s.reference_line_colors         is 'Identifies the colors to be used to represent reference lines on a Status Meter Gauge chart.';
comment on column apex_application_page_chart_s.link_target                   is 'Action link for the chart series, used when chart item selected.';
comment on column apex_application_page_chart_s.link_target_type              is 'Defines the type of Action link for the chart series is to be used.';
comment on column apex_application_page_chart_s.authorization_scheme          is 'Identifies an Authorization Scheme that will be applied to the chart series query';
comment on column apex_application_page_chart_s.authorization_scheme_id       is 'Identifies an Authorization Scheme foreign key';
comment on column apex_application_page_chart_s.build_option                  is 'Chart Series query will be processed if the Build Option is enabled';
comment on column apex_application_page_chart_s.build_option_id               is 'Identifies the primary key of this component';
comment on column apex_application_page_chart_s.series_comment                is 'Identifies the series comment.';
comment on column apex_application_page_chart_s.condition_type                is 'Identifies the condition type that must be met in order for the chart series to be rendered or processed.';
comment on column apex_application_page_chart_s.condition_type_code           is 'Identifies the condition type code that must be met in order for the chart series to be rendered or processed.';
comment on column apex_application_page_chart_s.condition_expression1         is 'Identifies the attribute that allows you to conditionally control whether or not a component is rendered or processed.';
comment on column apex_application_page_chart_s.condition_expression2         is 'Identifies the second attribute that allows you to conditionally control whether or not a component is rendered or processed.';
comment on column apex_application_page_chart_s.last_updated_by               is 'APEX developer who made last update.';
comment on column apex_application_page_chart_s.last_updated_on               is 'Date of last update.';
comment on column apex_application_page_chart_s.component_signature           is 'Identifies attributes defined at a given component level to facilitate application comparisons.';

prompt ...apex_application_page_chart_a

create or replace view apex_application_page_chart_a
as
select
    f.workspace,
    f.workspace_display_name,
    f.application_id,
    f.application_name,
    c.page_id                            page_id,
    (select name
       from wwv_flow_steps
      where id = c.page_id
        and flow_id = c.flow_id)         page_name,
    --
    ca.chart_id                          chart_id,
    ca.static_id                         static_id,
    ca.id                                axis_id,
    decode(ca.axis,
    'x','X Axis',
    'y','Y Axis',
    'y2','Extra Y Axis',
    'major','Major Axis',
    'minor','Minor Axis',
    ca.axis)                             axis,
    ca.title                             axis_title,
    ca.title_font_family                 axis_title_font_family,
    decode (ca.title_font_style,
    'normal','Normal',
    'italic','Italic',
    'oblique','Oblique',
    ca.title_font_style)                 axis_title_font_style,
    ca.title_font_size                   axis_title_font_size,
    ca.title_font_color                  axis_title_font_color,
    decode(ca.is_rendered,
    'on','On',
    'off','Off',
    ca.is_rendered)                      is_rendered,
    --
    ca.min                               axis_minimum,
    ca.max                               axis_maximum,
    decode(ca.format_type,
    'date-short', 'Short Date format',
    'date-medium', 'Medium Date format',
    'date-long', 'Long Date format',
    'date-full', 'Full Date format',
    'time-short', 'Short Time format',
    'time-medium', 'Medium Time format',
    'time-long', 'Long Time format',
    'time-full', 'Full Time format',
    'datetime-short', 'Short Datetime format',
    'datetime-medium', 'Medium Datetime format',
    'datetime-long','Long Datetime format',
    'datetime-full','Full Datetime format',
    'decimal','Decimal',
    'currency','Currency',
    'percent','Percent',
    ca.format_type)                     axis_format_type,
    ca.decimal_places                   axis_decimal_places,
    ca.currency                         axis_currency,
    ca.numeric_pattern                  axis_numeric_pattern,
    decode(ca.format_scaling,
    'auto','Automatic',
    'none','None',
    'thousand','Thousand',
 