-- Insert table-level hint information for OE Schema
-- Replace all dates with sysdate JSTRAUB 09/16/2003
--
-- Updated for 1.6 schema changes, SBKenned 06/03/2004
--    SBKenned  08/03/2004 - Fixed error on DISPLAY_AS_TABULAR_FORM
--

insert into wwv_flow_hnt_table_info
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)
values 
   ('OE',
    'PRODUCTS',
    'Create/Edit Product',
    'Products',
    'SBKENNED',
    sysdate,
    '',
    '');                                                               


insert into wwv_flow_hnt_table_info                                        
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)                                                       
values 
   ('OE',
    'INVENTORIES',
    'Create/Edit Inventory Item',
    'Inventories',
    'SBKENNED',
    sysdate,
    '',
    '');


insert into wwv_flow_hnt_table_info
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)
values 
   ('OE',
    'PRODUCT_DESCRIPTIONS',
    'Create/Edit Product Description',
    'Product Descriptions',
    'SBKENNED',
    sysdate,
    '',
    '');


insert into wwv_flow_hnt_table_info
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)                                                       
values 
   ('OE',
    'ORDER_ITEMS',
    'Create/Edit Order Item',
    'Order Items',
    'SBKENNED',
    sysdate,
    '',
    '');


insert into wwv_flow_hnt_table_info
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)
values 
   ('OE',
    'CUSTOMERS',
    'Create/Edit Customer',
    'Customers',
    'SBKENNED',
    sysdate,                                               
    '',
    '');


insert into wwv_flow_hnt_table_info
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)
values 
   ('OE',
    'ORDERS',
    'Create/Edit Order',
    'Orders',
    'SBKENNED',
    sysdate,                                                  
    '',
    '');

                                                                 
insert into wwv_flow_hnt_table_info
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)
values 
   ('OE',
    'PRODUCT_INFORMATION',
    'Create/Edit Product Information',
    'Product Information',
    'SBKENNED',
    sysdate,                                                    
    '',
    '');

 
insert into wwv_flow_hnt_table_info
   (schema,
    table_name,
    form_region_title,
    report_region_title,
    created_by,
    created_on,
    last_updated_by,
    last_updated_on)
values 
   ('OE',
    'WAREHOUSES',
    'Create/Edit Warehouse',
    'Warehouses',
    'SBKENNED',
    sysdate,                                                  
    '',
    '');

commit;



-- Insert column-level hint information for OE Schema


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'CUSTOMER_ID',
   'Customer ID',
   'Primary key column.',
   '',
   null,
   'N',
   '',
   null,
   'N',
   '',
   '',
   'Y',
   null,
   null,
   null,
   null,
   null,
   null,
   'N',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   '' 
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)  
select
   TABLE_ID,
   'CUST_FIRST_NAME',
   'Customer First Name',
   'Last Name of the Customer.',
   '',
   null,
   'Y',
   'TEXT',
   2,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   'Y',
   2,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   'L',
   '',                                                                
   ''
  from wwv_flow_hnt_table_info                                            
   where table_name = 'CUSTOMERS'
     and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)    
select
   TABLE_ID,
   'CUST_LAST_NAME',
   'Customer Last Name',
   'First Name of the Customer.',
   '',
   null,
   'Y',
   'TEXT',
   1,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   'Y',
   1,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info                                             
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CUST_ADDRESS',
   'Customer Address',
   'Address of the Customer.',
   '',
   null,
   'Y',
   '',
   3,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   3,
   'A',
   'N',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PHONE_NUMBERS',
   'Phone Numbers',
   'Phone numbers for the Customer.',
   '',
   null,
   'Y',
   '',
   4,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   4,
   'A',
   'N',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'NLS_LANGUAGE',
   '',
   '',
   '',
   null,
   'N',
   '',
   null,
   'N',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
  TABLE_ID,
   'NLS_TERRITORY',
   '',
   '',
   '',
   null,
   'N',
   '',
   null,
   'N',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CREDIT_LIMIT',
   'Credit Limit',
   'Must be less than $5,000.',
   '$999,999.00',
   null,
   'Y',
   'TEXT',
   6,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'Y',
   6,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   'R',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CUST_EMAIL',
   'Customer Email Address',
   'Email Address for the Customer.',
   '',
   null,
   'Y',
   '',
   5,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   5,
   'A',
   'N',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';

                                                    
insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)  
select
   TABLE_ID,
   'ACCOUNT_MGR_ID',
   '',
   '',
   '',
   null,
   'N',
   '',
   null,
   'N',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'CUSTOMERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM) 
select
   TABLE_ID,
   'CUST_GEO_LOCATION',
   '',
   '',
   '',
   null,
   'N',
   '',
   null,
   'N',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
   from wwv_flow_hnt_table_info
   where table_name = 'CUSTOMERS'
     and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_ID',
   'Product ID',
   'Primary key column.',
   '',
   null,
   'N',
   '',
   null,
   'N',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
   from wwv_flow_hnt_table_info
   where table_name = 'PRODUCT_INFORMATION'
     and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_NAME',
   'Product Name',
   'Name of the Product.',
   '',
   1,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   1,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_DESCRIPTION',
   'Product Description',
   'Description of the Product.',
   '',
   2,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CATEGORY_ID',
   'Category',
   'Category that the Product fits into.',
   '',
   3,
   'Y',
   'COMBOBOX',
   null,
   'N',
   'select CATEGORY_NAME, CATEGORY_ID
from CATEGORIES_TAB',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'SBKENNED',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'WEIGHT_CLASS',
   'Weight Class',
   'Weight Class for the Product.',
   '',
   4,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',                                                                
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'WARRANTY_PERIOD',
   'Warranty Period',
   'Warranty Period, in months to years.',
   '',
   5,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'SUPPLIER_ID',
   'Supplier',
   'Supplier of the Product.',
   '',
   6,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'Y',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
   from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)                    
select
   TABLE_ID,
   'PRODUCT_STATUS',
   'Product Status',
   'Status of the Product.',
   '',
   9,
   'Y',
   'RADIOGROUP',
   null,
   'Y',
   'select distinct product_status
from product_information',
   'orderable',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'LIST_PRICE',
   'List Price',
   'List Price of the the Product.',
   '$999,999.00',
   8,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   2,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   'R',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'MIN_PRICE',
   'Minimum Price',
   'Minimum Price of the Product.',
   '$999,999.00',
   10,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   'R',
   '',
   ''
   from wwv_flow_hnt_table_info
   where table_name = 'PRODUCT_INFORMATION'
     and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CATALOG_URL',
   'Catalog URL',
   'URL where the Product can be viewed.',
   '',
   7,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_INFORMATION'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_ID',
   'Product Id',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'LANGUAGE_ID',
   'Language Id',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_NAME',
   'Product Name',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   1,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CATEGORY_ID',
   'Category Id',
   '',
   '',
   null,
   'Y',
   'COMBOBOX',
   null,
   'Y',
   'select CATEGORY_NAME, CATEGORY_ID
from CATEGORIES_TAB',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'SBKENNED',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_DESCRIPTION',
   'Product Description',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
   from wwv_flow_hnt_table_info
   where table_name = 'PRODUCTS'
     and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'WEIGHT_CLASS',
   'Weight Class',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'WARRANTY_PERIOD',
   'Warranty Period',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'SUPPLIER_ID',
   'Supplier Id',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   'Y',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_STATUS',
   'Product Status',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'LIST_PRICE',
   'List Price',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   2,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'MIN_PRICE',
   'Minimum Price',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CATALOG_URL',
   'Catalog URL',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCTS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'ORDER_TOTAL',
   'Order Total',
   '',
   '999,999,999,999,990.00',
   null,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'MIKE',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'ORDER_ID',
   'Order Id',
   'Part of concatenated primary key, references orders.order_id.',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDER_ITEMS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'LINE_ITEM_ID',
   'Line Item Id',
   'Part of concatenated primary key.',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDER_ITEMS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
  TABLE_ID,
   'PRODUCT_ID',
   'Product Id',
   'References product_information.product_id.',
   '',
   null,                                                                        
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDER_ITEMS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'UNIT_PRICE',
   'Unit Price',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   '' 
  from wwv_flow_hnt_table_info
 where table_name = 'ORDER_ITEMS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'QUANTITY',
   'Quantity',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDER_ITEMS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_ID',
   'Product Id',
   'Part of concatenated primary key, references product_information.product_id.',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'INVENTORIES'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'WAREHOUSE_ID',
   'Warehouse Id',
   'Part of concatenated primary key, references warehouses.warehouse_id.',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'INVENTORIES'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'QUANTITY_ON_HAND',
   'Quantity On Hand',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'INVENTORIES'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'PRODUCT_ID',
   'Product Id',
   'Primary key column.',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   '' 
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_DESCRIPTIONS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'LANGUAGE_ID',
   'Language Id',
   'Primary key column.',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_DESCRIPTIONS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'TRANSLATED_NAME',
   'Translated Name',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_DESCRIPTIONS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'TRANSLATED_DESCRIPTION',
   'Translated Description',
   '',
   '',
   null,
   '',
   '',
   null,
   '',
   '',
   '',
   '',
   null,
   null,
   null,
   '',
   null,
   '',
   '',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'PRODUCT_DESCRIPTIONS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'ORDER_STATUS',
   'Order Status',
   '',
   '',
   null,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'MIKE',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'ORDER_MODE',
   'Order Mode',
   '',
   '',
   null,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'MIKE',       
   sysdate, 
   '',
   '',
   'L',
   '',
   '' 
  from wwv_flow_hnt_table_info
 where table_name = 'ORDERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'ORDER_ID',
   'Order ID',
   '',
   '',
   null,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'MIKE',
   sysdate,
   '',
   '',
   'L',
   '',
   '' 
  from wwv_flow_hnt_table_info
 where table_name = 'ORDERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'PROMOTION_ID',
   'Promotion',
   '',
   '',
   null,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'MIKE',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDERS'
   and schema = 'OE';

insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'CUSTOMER_ID',
   'Customer ID',
   '',
   '',
   null,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'MIKE',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'ORDER_DATE',
   'Order Date',
   '',
   '',
   null,
   'Y',
   'TEXT',
   null,
   'Y',
   '',
   '',
   'N',
   null,
   null,
   null,
   'N',
   null,
   'A',
   'N',
   'MIKE',
   sysdate,
   '',
   '',
   'L',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'ORDERS'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'WAREHOUSE_ID',
   'Warehouse ID',
   'Primary key column.',
   '',
   null,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   null,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'WAREHOUSES'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'WAREHOUSE_SPEC',
   'Warehouse Spec',
   '',
   '',
   null,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   null,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   '' 
  from wwv_flow_hnt_table_info
 where table_name = 'WAREHOUSES'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'WAREHOUSE_NAME',
   'Warehouse Name',
   '',
   '',
   null,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   null,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'WAREHOUSES'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select 
   TABLE_ID,
   'LOCATION_ID',
   'Location ID',
   'Primary key column, references hr.locations.location_id.',
   '',
   null,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   null,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   ''
  from wwv_flow_hnt_table_info
 where table_name = 'WAREHOUSES'
   and schema = 'OE';


insert into wwv_flow_hnt_column_info
   (TABLE_ID,
    COLUMN_NAME,
    LABEL,
    HELP_TEXT,
    MASK_REPORT,
    DISPLAY_SEQ_FORM,
    DISPLAY_IN_FORM,
    DISPLAY_AS_FORM,
    DISPLAY_SEQ_REPORT,
    DISPLAY_IN_REPORT,
    LOV_QUERY,
    DEFAULT_VALUE,
    REQUIRED,
    DISPLAY_WIDTH,
    MAX_WIDTH,
    HEIGHT,
    GROUP_BY,
    ORDER_BY_SEQ,
    ORDER_BY_ASC_DESC,
    SEARCHABLE,
    CREATED_BY,
    CREATED_ON,
    LAST_UPDATED_BY,
    LAST_UPDATED_ON,
    ALIGNMENT,
    DISPLAY_AS_REPORT,
    DISPLAY_AS_TAB_FORM)
select
   TABLE_ID,
   'WH_GEO_LOCATION',
   'Geo Location',
   'SDO (spatial) column.',
   '',
   null,
   'Y',
   '',
   null,
   'Y',
   '',
   '',
   'Y',
   null,
   null,
   null,
   '',
   null,
   'A',
   'Y',
   'SBKENNED',
   sysdate,
   '',
   '',
   '',
   '',
   '' 
  from wwv_flow_hnt_table_info
 where table_name = 'WAREHOUSES'
   and schema = 'OE';

commit;

