set define '^' verify off

prompt ... Create APEX ISSUE views

prompt ... apex_issues

create or replace  view apex_issues (
    workspace_id,
    workspace_name,
    issue_id,
    friendly_issue_number,
    issue_title,
    issue_slug,
    issue_text,
    issue_status,
    marked_as_deleted,
    duplicate_of_issue_id,
    duplicate_identified_on,
    duplicate_identified_by,
    related_application_id,
    related_page_id,
    created_on,
    created_by,
    updated_on,
    updated_by
) as
    select w.workspace_id,
           w.workspace        workspace_name,
       --
           i.id               issue_id,
           i.issue_number     friendly_issue_number,
           i.title            issue_title,
           i.slug             issue_slug,
           i.issue_text       issue_text,
           i.status           issue_status,
           i.deleted          marked_as_deleted,
           i.duplicate_of     duplicate_of_issue_id,
           i.duplicate_identified_on,
           i.duplicate_identified_by,
           i.application_id   related_application_id,
           i.page_id          related_page_id,
           i.created_on,
           i.created_by,
           i.updated_on,
           i.updated_by
      from wwv_flow_current_workspaces   w,
           wwv_flow_issues               i
     where i.security_group_id = w.workspace_id;
     
     comment on column apex_issues.workspace_id is 'Primary key that identifies the workspace.';
     comment on column apex_issues.workspace_name is 'Name of the workspace.';
     comment on column apex_issues.issue_id is 'Primary key of the issue.';
     comment on column apex_issues.friendly_issue_number is 'User friendly system assigned issue number.';
     comment on column apex_issues.issue_title is 'Title of the issue.';
     comment on column apex_issues.issue_slug is 'Normalized unique text identifier for the issue.';
     comment on column apex_issues.issue_text is 'Detailed description of the issue. Uses Markdown formatting.';
     comment on column apex_issues.issue_status is 'Status of the issue (OPEN or CLOSED).';
     comment on column apex_issues.marked_as_deleted is 'Marks the issue as deleted. If so marked, it will not show in the main issues report.';
     comment on column apex_issues.duplicate_of_issue_id is 'If the issue is a duplicate of an existing issue, the unique id of the other issue.';
     comment on column apex_issues.duplicate_identified_on is 'Date the duplicate was identified.';
     comment on column apex_issues.duplicate_identified_by is 'User who identified the duplicate.';
     comment on column apex_issues.related_application_id is 'If the issue is related to a specific application, the id of the related application.';
     comment on column apex_issues.related_page_id is 'If the issue is related to a specific page in an application, the id of the related page.';
     COMMENT ON COLUMN apex_issues.CREATED_BY IS 'Developer who created this issue.';
     COMMENT ON COLUMN apex_issues.CREATED_ON IS 'Date on which this issue was created.';
     COMMENT ON COLUMN apex_issues.UPDATED_BY IS 'Developer who last updated this issue.';
     COMMENT ON COLUMN apex_issues.UPDATED_ON IS 'Date on which this issue was last updated.';
     COMMENT ON TABLE apex_issues  IS 'All Issues logged within the APEX ISSUE system.';
     
prompt ... apex_issue_events

create or replace  view apex_issue_events (
    workspace_id,
    workdspace_name,
    issue_id,
    issue_title,
    issue_status,
    issue_makred_as_deleted,
    comment_id,
    event_id,
    event_date,
    event_json,
    created_on,
    created_by,
    updated_on,
    updated_by
)AS
select w.workspace_id   workspace_id,
       w.workspace      workspace_name,
       --
       i.id             issue_id,
       i.title          issue_title,
       i.status 		issue_status,
       i.deleted 		issue_makred_as_deleted,
       c.id             comment_id,
       e.id             event_id,
       e.event_date     event_date,
       e.event_text     event_json,
       e.created_on     created_on,
       e.created_by     created_by,
       e.updated_on     updated_on,
       e.updated_by     update_by
  from wwv_flow_current_workspaces   w,
       wwv_flow_issues               i, 
       wwv_flow_issue_events e,
       wwv_flow_issue_comments c
 where e.security_group_id = w.workspace_id
   and e.security_group_id = i.security_group_id (+)
   and e.issue_id = i.id (+)
   and e.security_group_id = c.security_group_id (+)
   and e.comment_id = c.id (+);
   
comment on column apex_issue_events.workspace_id is 'Primary key that identifies a workspace.';
comment on column apex_issue_events.workdspace_name is 'Name of the workspace.';
comment on column apex_issue_events.issue_id is 'Primary key of the related Issue.';
comment on column apex_issue_events.issue_title is 'Title of the related Issue.';
comment on column apex_issue_events.issue_status is 'Status of the related issue (OPEN or CLOSED).';
comment on column apex_issue_events.issue_makred_as_deleted is 'Has the issue been marked as deleted within the system (Y or N)';
comment on column apex_issue_events.comment_id is 'Primary Key of the related Comment';
comment on column apex_issue_events.event_id is 'Primary Key of the Event.';
comment on column apex_issue_events.event_date is 'Date the Event Occurred.';
comment on column apex_issue_events.event_json is 'Event JSON containting details of the event.';
comment on column apex_issue_events.created_on is 'Date the event record was created.';
comment on column apex_issue_events.created_by is 'Developer that created the event record.';
comment on column apex_issue_events.updated_on is 'Date the event record was last updated.';
comment on column apex_issue_events.updated_by is 'Developer that last updated the event recored.'; 
comment on table  apex_issue_events is 'All events linked to either an ISSUE_ID or COMMENT_ID.'; 

prompt ... apex_issue_comments

create or replace  view apex_issue_comments (
    workspace_id,
    workspace_name,
    issue_id,
    issue_title,
    issue_status,
    issue_makred_as_deleted,
    comment_id,
    comment_text,
    row_version,
    hidden,
    created_on,
    created_by,
    updated_on,
    updated_by
) as
    select w.workspace_id   workspace_id,
           w.workspace      workspace_name,
       --
           i.id             issue_id,
           i.title          issue_title,
           i.status 		issue_status,
           i.deleted 		issue_makred_as_deleted,
           c.id             comment_id,
           c.comment_text   comment_text,
           c.row_version    row_version,
           c.public_yn      hidden,
           c.created_on     created_on,
           c.created_by     created_by,
       c.updated_on     updated_on,
           c.updated_by     updated_by
      from wwv_flow_current_workspaces   w,
           wwv_flow_issues               i,
           wwv_flow_issue_comments       c
     where c.security_group_id = w.workspace_id
       and c.security_group_id = i.security_group_id 
       and c.issue_id = i.id;
    
comment on column apex_issue_comments.workspace_id is 'Primary key that identifies a workspace.';
comment on column apex_issue_comments.workspace_name is 'Name of the workspace.';
comment on column apex_issue_comments.issue_id is 'Primary key of the related Issue.';
comment on column apex_issue_comments.issue_title is 'Title of the related Issue.';
comment on column apex_issue_comments.issue_status is 'Status of the related issue (OPEN or CLOSED).';
comment on column apex_issue_comments.issue_makred_as_deleted is 'Has the issue been marked as deleted within the system (Y or N)';
comment on column apex_issue_comments.comment_id is 'Primary Key of the related comment ';
comment on column apex_issue_comments.comment_text is 'Text of the comment.';
comment on column apex_issue_comments.row_version is 'Row version of the comment.';
comment on column apex_issue_comments.hidden is 'Has the comment been hidden from view by an admin or the comment owner.';
comment on column apex_issue_comments.created_on is 'Date the comment was created.';
comment on column apex_issue_comments.created_by is 'Developer that created the comment.';
comment on column apex_issue_comments.updated_on is 'Date the comment was laste updated.';
comment on column apex_issue_comments.updated_by is 'Developer that last updated the comment';
comment on table apex_issue_comments is 'Lists all comments for a spcific issue.';

prompt apex_issue_attachments

create or replace  view apex_issue_attachments (
    workspace_id,
    workspace_name,
    issue_id,
    issue_title,
    issue_status,
    issue_makred_as_deleted,
    attachment_id,
    file_name,
    file_name_slug,
    file_blob,
    mime_type,
    charset,
    created_on,
    created_by,
    updated_on,
    updated_by
) as
    select w.workspace_id     workspace_id,
           w.workspace        workspace_name,
       --
           i.id               issue_id,
           i.title            issue_title,
           i.status 		  issue_status,
           i.deleted 		  issue_makred_as_deleted,
           a.id               attachment_id,
           a.file_name        file_name,
           a.file_name_slug   file_name_slug,
           a.file_blob        file_blob,
           a.mime_type        mime_type,
           a.charset          charset,
           a.created_on       created_on,
           a.created_by       created_by,
           a.updated_on       updated_on,
           a.updated_by     updated_by
      from wwv_flow_current_workspaces   w,
           wwv_flow_issues               i,
           wwv_flow_issue_attachments    a
     where a.security_group_id = w.workspace_id
       and a.security_group_id = i.security_group_id
       and a.issue_id = i.id;
       
comment on column apex_issue_attachments.workspace_id is 'Primary key that identifies a workspace.';
comment on column apex_issue_attachments.workspace_name is 'Name of the workspace.';
comment on column apex_issue_attachments.issue_id is 'Primary key of the related Issue.';
comment on column apex_issue_attachments.issue_title is 'Title of the related Issue.';
comment on column apex_issue_attachments.issue_status is 'Status of the related issue (OPEN or CLOSED).';
comment on column apex_issue_attachments.issue_makred_as_deleted is 'Has the issue been marked as deleted within the system (Y or N)';
comment on column apex_issue_attachments.attachment_id is 'Primary key of the attachment';
comment on column apex_issue_attachments.file_name is 'Attachment File Name';
comment on column apex_issue_attachments.file_name_slug is 'Normalized unique text identifier for the attachment';
comment on column apex_issue_attachments.file_blob is 'BLOB column holding the file attachment';
comment on column apex_issue_attachments.mime_type is 'Mime type of the file attachment';
comment on column apex_issue_attachments.charset is 'Character set of the file attachment';
comment on column apex_issue_attachments.created_on is 'Developer who created this attachment.';
comment on column apex_issue_attachments.created_by is 'Date on which this attachment was created.';
comment on column apex_issue_attachments.updated_on is 'Developer who last updated this attachment.';
comment on column apex_issue_attachments.updated_by is 'Date on which this attachment was last updated.';
comment on table apex_issue_attachments is 'Attachments associated with a given issue.';

prompt ... apex_issue_stakeholders

create or replace  view apex_issue_stakeholders (
    workspace_id,
    workspace_name,
    issue_id,
    issue_title,
    issue_status,
    issue_makred_as_deleted,
    stakeholder,
    stakeholder_type,
    created_on,
    created_by,
    updated_on,
    updated_by
) as
    select w.workspace_id       workspace_id,
           w.workspace          workspace_name,
       --
           i.id                 issue_id,
           i.title              issue_title,
           i.status 			issue_status,
           i.deleted 			issue_makred_as_deleted,
           s.stakeholder        stakeholder,
           s.stakeholder_type   stakeholder_type,
           s.created_on         created_on,
           s.created_by         created_by,
           s.updated_on         updated_on,
           s.updated_by         updated_by
      from wwv_flow_current_workspaces   w,
           wwv_flow_issues               i,
           wwv_flow_issue_stakeholders   s
     where s.security_group_id = w.workspace_id
       and s.security_group_id = i.security_group_id
       and s.issue_id = i.id;
     
comment on column apex_issue_stakeholders.workspace_id is 'Primary key that identifies a workspace.';
comment on column apex_issue_stakeholders.workspace_name is 'Name of the workspace.';
comment on column apex_issue_stakeholders.issue_id is 'Primary key that identifies the realted Issue.';
comment on column apex_issue_stakeholders.issue_title is 'Title of the related issue.';
comment on column apex_issue_stakeholders.issue_status is 'Status of the related issue (OPEN or CLOSED).';
comment on column apex_issue_stakeholders.issue_makred_as_deleted is 'Has the issue been marked as deleted within the system (Y or N)';
comment on column apex_issue_stakeholders.stakeholder is 'Developer that is a stakeholder for the issue.';
comment on column apex_issue_stakeholders.stakeholder_type is 'Type of stakeholder (ASSIGNEE or SUBSCRIBER).';
comment on column apex_issue_stakeholders.created_on is 'Developer who created this attachment.';
comment on column apex_issue_stakeholders.created_by is 'Date on which this attachment was created.';
comment on column apex_issue_stakeholders.updated_on is 'Developer who last updated this attachment.';
comment on column apex_issue_stakeholders.updated_by is 'Date on which this attachment was last updated.';
comment on table apex_issue_stakeholders is 'Stakeholders (ASSIGNEES or SUBSCRIBERS) for a given issue';  

prompt ... apex_issue_milestones

create or replace  view apex_issue_milestones (
    workspace_id,
    workspace_name,
    milestone_id,
    friendly_milestone_id,
    milestone_name,
    milestone_slug,
    milestone_date,
    milestone_desc,
    milestone_status,
    milestone_owner,
    created_on,
    updated_by,
    updated_on
) as
    select w.workspace_id   workspace_id,
           w.workspace      workspace_name,
       --
           id               milestone_id,
           milestone_id     friendly_milestone_id,
           milestone_name,
           milestone_slug,
           milestone_date,
           milestone_desc,
           milestone_status,
           created_by       milestone_owner,
           created_on,
           updated_by,
           updated_on
      from wwv_flow_milestones           m,
           wwv_flow_current_workspaces   w
     where m.security_group_id = w.workspace_id;
     
comment on column apex_issue_milestones.workspace_id is 'Primary Key that identifies the workspace.';
comment on column apex_issue_milestones.workspace_name is 'Name of the Workspace.';
comment on column apex_issue_milestones.milestone_id is 'Primary Key that identifies the Milestone.';
comment on column apex_issue_milestones.friendly_milestone_id is 'User friendly system assigned Milestone Number.';
comment on column apex_issue_milestones.milestone_name is 'Name of the milestone.';
comment on column apex_issue_milestones.milestone_slug is 'Normalized unique text identifier for the milestone.';
comment on column apex_issue_milestones.milestone_date is 'Date for the milestone.';
comment on column apex_issue_milestones.milestone_desc is 'Description of the milestone.';
comment on column apex_issue_milestones.milestone_status is 'Status of the milestone (OPEN or CLOSED).';
comment on column apex_issue_milestones.milestone_owner is 'Developer that created the milestone.';
comment on column apex_issue_milestones.created_on is 'Date the milestone was created';
comment on column apex_issue_milestones.updated_by is 'Developer that last updated the milestone.';
comment on column apex_issue_milestones.updated_on is 'Date the milestone was last updated.';
comment on table apex_issue_milestones is 'All milestones available to the issues system.';

prompt ... apex_issue_label_groups

create or replace  view apex_issue_label_groups (
    workspace_id,
    workspace_name,
    label_group_id,
    label_group_name,
    label_group_color_class,
    label_group_desc,
    values_are_exclusive,
    created_by,
    created_on,
    updated_by,
    updated_on
) as
    select w.workspace_id           workspace_id,
           w.workspace              workspace_name,
       --
           g.id                     label_group_id,
           g.group_name             label_group_name,
           g.group_color            label_group_color_class,
           g.group_description      label_group_desc,
           g.values_are_exclusive   values_are_exclusive,
           created_by,
           created_on,
           updated_by,
           updated_on
      from wwv_flow_label_groups         g,
           wwv_flow_current_workspaces   w
     where g.security_group_id = w.workspace_id;
 
comment on column apex_issue_label_groups.workspace_id is 'Primary Key that identifies the workspace.';
comment on column apex_issue_label_groups.workspace_name is 'Name of the Workspace.';
comment on column apex_issue_label_groups.label_group_id is 'Primary Key for the Label Group';
comment on column apex_issue_label_groups.label_group_name is 'Label Group Name';
comment on column apex_issue_label_groups.label_group_color_class is 'CSS Class used to style the color of labels in the group.';
comment on column apex_issue_label_groups.label_group_desc is 'Description of the Label Group.';
comment on column apex_issue_label_groups.values_are_exclusive is 'Designates if the values within the group are exclusively assigned to issues (Y or N).';
comment on column apex_issue_label_groups.created_by is 'Developer that created the milestone.';
comment on column apex_issue_label_groups.created_on is 'Date the milestone was created';
comment on column apex_issue_label_groups.updated_by is 'Developer that last updated the milestone.';
comment on column apex_issue_label_groups.updated_on is 'Date the milestone was last updated.';
comment on table apex_issue_label_groups is 'All Label Groups available to the issues system.';

prompt ... apex_issue_labels

create or replace  view apex_issue_labels (
    workspace_id,
    workspace_name,
    label_id,
    label_group_id,
    label_group_name,
    label_group_color_class,
    label_name,
    label_desc,
    label_slug,
    display_sequence,
    created_by,
    created_on,
    updated_by,
    updated_on
) as
    select w.workspace_id   workspace_id,
           w.workspace      workspace_name,
       --
           l.id             label_id,
           l.label_group_id,
           g.group_name     label_group_name,
           g.group_color    label_group_color_class,
           l.label_name,
           l.label_desc,
           l.label_slug,
           l.display_sequence,
           l.created_by,
           l.created_on,
           l.updated_by,
           l.updated_on
      from wwv_flow_labels               l,
           wwv_flow_label_groups         g,
           wwv_flow_current_workspaces   w
     where l.security_group_id = w.workspace_id
       and g.security_group_id = l.security_group_id
       and l.label_group_id = g.id;
       
comment on column apex_issue_labels.workspace_id is 'Primary Key that identifies the workspace.';
comment on column apex_issue_labels.workspace_name is 'Name of the Workspace.';
comment on column apex_issue_labels.label_id is 'Primary key of the label.';
comment on column apex_issue_labels.label_group_id is 'Primary key of the parent Label Group';
comment on column apex_issue_labels.label_group_name is 'Name of the Parent label Group';
comment on column apex_issue_labels.label_group_color_class is 'CSS Class used to style the labels within the parent group.';
comment on column apex_issue_labels.label_name is 'Name of the label.';
comment on column apex_issue_labels.label_desc is 'Description of the label.';
comment on column apex_issue_labels.label_slug is 'Normalized unique text identifier for the label.';
comment on column apex_issue_labels.display_sequence is 'Display sequence used to order labels in the UI.';
comment on column apex_issue_labels.created_by is 'Developer that created the milestone.';
comment on column apex_issue_labels.created_on is 'Date the milestone was created';
comment on column apex_issue_labels.updated_by is 'Developer that last updated the milestone.';
comment on column apex_issue_labels.updated_on is 'Date the milestone was last updated.';
comment on table apex_issue_labels is 'All Labels available to the issues system.';

prompt ... apex_issue_label_relation

create or replace  view apex_issue_label_relation (
    workspace_id,
    workspace_name,
    issue_id,
    issue_title,
    issue_slug,
    issue_status,
    issue_makred_as_deleted,
    label_group_id,
    label_group_name,
    label_group_color_class,
    label_id,
    label_name,
    label_slug,
    created_by,
    created_on,
    updated_by,
    updated_on
) as
    select w.workspace_id   workspace_id,
           w.workspace      workspace_name,
       --
           i.id             issue_id,
           i.title          issue_title,
           i.slug           issue_slug,
           i.status         issue_status,
           i.deleted        issue_marked_as_deleted,
           g.id             label_group_id,
           g.group_name     label_group_name,
           g.group_color    label_group_color_class,
           l.id             label_id,
           l.label_name     label_name,
           l.label_slug     label_slug,
           il.created_by,
           il.created_on,
           il.updated_by,
           il.updated_on
      from wwv_flow_issues               i,
           wwv_flow_labels               l,
           wwv_flow_label_groups         g,
           wwv_flow_issue_labels         il,
           wwv_flow_current_workspaces   w
     where i.security_group_id = w.workspace_id
       and g.security_group_id = i.security_group_id
       and l.security_group_id = i.security_group_id
       and il.security_group_id = i.security_group_id
       and il.issue_id = i.id
       and il.label_id = l.id
       and l.label_group_id = g.id;
       
comment on column apex_issue_label_relation.workspace_id is 'Primary Key that identifies the workspace.';
comment on column apex_issue_label_relation.workspace_name is 'Name of the Workspace.';
comment on column apex_issue_label_relation.issue_id is 'Primary Key of the related issue.';
comment on column apex_issue_label_relation.issue_title is 'Title of the related issue.';
comment on column apex_issue_label_relation.issue_slug is 'Normalized unique text identifier for the related issue.';
comment on column apex_issue_label_relation.issue_status is 'Status of the related issue (OPEN or CLOSED).';
comment on column apex_issue_label_relation.issue_makred_as_deleted is 'Has the issue been marked as deleted within the system (Y or N)';
comment on column apex_issue_label_relation.label_group_id is 'Primary key for the related Label Group.';
comment on column apex_issue_label_relation.label_group_name is 'Name of the related Label Group.';
comment on column apex_issue_label_relation.label_group_color_class is 'CSS Class used to style members of the Label Group.';
comment on column apex_issue_label_relation.label_id is 'Primary Key for the related Label.';
comment on column apex_issue_label_relation.label_name is 'Name of the related Label.';
comment on column apex_issue_label_relation.label_slug is 'Normalized unique text identifier for the related label.';
comment on column apex_issue_label_relation.created_by is 'Developer that created the milestone.';
comment on column apex_issue_label_relation.created_on is 'Date the milestone was created';
comment on column apex_issue_label_relation.updated_by is 'Developer that last updated the milestone.';
comment on column apex_issue_label_relation.updated_on is 'Date the milestone was last updated.';
comment on table apex_issue_label_relation is 'A list of Issues and associated labels.';

prompt ... apex_issue_milestone_relation

create or replace  view apex_issue_milestone_relation (
    workspace_id,
    workspace_name,
    issue_id,
    issue_title,
    issue_status,
    issue_makred_as_deleted,
    issue_slug,
    milestone_id,
    milestone_name,
    milestone_date,
    friendly_milestone_id,
    milestone_slug,
    milestone_status,
    created_by,
    created_on,
    updated_by,
    updated_on
) as
    select w.workspace_id       workspace_id,
           w.workspace          workspace_name,
       --
           i.id                 issue_id,
           i.title              issue_title,
           i.status             issue_status,
           i.deleted            issue_marked_as_deleted,
           i.slug               issue_slug,
           m.id                 milestone_id,
       m.milestone_name     milestone_name,
           m.milestone_date     milestone_date,
           m.milestone_id       friendly_milestone_id,
           m.milestone_slug     milestone_slug,
           m.milestone_status   milestone_status,
           im.created_by,
           im.created_on,
           im.updated_by,
           im.updated_on
      from wwv_flow_issues               i,
           wwv_flow_milestones           m,
           wwv_flow_issue_milestones     im,
           wwv_flow_current_workspaces   w
     where i.security_group_id = w.workspace_id
       and m.security_group_id = i.security_group_id
       and im.security_group_id = i.security_group_id
       and im.issue_id = i.id
       and im.milestone_id = m.id;
       
       
comment on column apex_issue_milestone_relation.workspace_id is 'Primary Key that identifies the workspace.';
comment on column apex_issue_milestone_relation.workspace_name is 'Name of the Workspace.';
comment on column apex_issue_milestone_relation.issue_id is 'Primary key of the related issue.';
comment on column apex_issue_milestone_relation.issue_title is 'Title of the related issue.';
comment on column apex_issue_milestone_relation.issue_status is 'Status of the related issue (OPEN or CLOSED).';
comment on column apex_issue_milestone_relation.issue_makred_as_deleted is 'Has the issue been marked as deleted within the system (Y or N)';
comment on column apex_issue_milestone_relation.issue_slug is 'Normalized unique text identifier for the related issue.';
comment on column apex_issue_milestone_relation.milestone_id is 'Primary Key for the related milestone.';
comment on column apex_issue_milestone_relation.milestone_name is 'Name of the related milestone.';
comment on column apex_issue_milestone_relation.milestone_date is 'Date of the related milestone.';
comment on column apex_issue_milestone_relation.friendly_milestone_id is 'User friendly system assigned Milestone Number.';
comment on column apex_issue_milestone_relation.milestone_slug is 'Normalized unique text identifier for the related milestone.';
comment on column apex_issue_milestone_relation.milestone_status is 'Status of the related milestone (OPEN or CLOSED).';
comment on column apex_issue_milestone_relation.created_by is 'Developer that created the milestone.';
comment on column apex_issue_milestone_relation.created_on is 'Date the milestone was created';
comment on column apex_issue_milestone_relation.updated_by is 'Developer that last updated the milestone.';
comment on column apex_issue_milestone_relation.updated_on is 'Date the milestone was last updated.';
comment on table apex_issue_milestone_relation is 'A list of Issues and associated Milestones.';

prompt ... apex_issue_email_prefs

create or replace  view apex_issue_email_prefs (
    workspace_id,
    workspace_name,
    user_name,
    receive_emails_yn,
    notification_types,
    email_frequency,
    created_by,
    created_on,
    updated_by,
    updated_on
) as
    select w.workspace_id         workspace_id,
           w.workspace            workspace_name,
       --
           p.user_id              user_name,
           p.receive_emails_yn    receive_emails_yn,
           p.notification_types   notification_types,
           p.frequency            email_frequency,
           p.created_by,
           p.created_on,
           p.updated_by,
           p.updated_on
      from wwv_flow_issue_email_prefs    p,
           wwv_flow_current_workspaces   w
     where p.security_group_id = w.workspace_id;

comment on column apex_issue_email_prefs.workspace_id is 'Primary Key that identifies the workspace.';
comment on column apex_issue_email_prefs.workspace_name is 'Name of the Workspace.';
comment on column apex_issue_email_prefs.user_name is 'Workspace user whos preferences are defined by this record';
comment on column apex_issue_email_prefs.receive_emails_yn is 'Should the user recieve email notifications (Y or N)';
comment on column apex_issue_email_prefs.notification_types is 'Colon separated list of notifications requested (ISSUE_EDIT COMMENT_ADD COMMENT_EDIT STATUS ASSIGNEE SUBSCRIBER MILESTONE LABEL DUPLICATE ASSOCIATION ATTACHMENT)';
comment on column apex_issue_email_prefs.email_frequency is 'Frequency to send emails (IMMEDIATELY HOURLY DAILY)';
comment on column apex_issue_email_prefs.created_by is 'Developer that created the milestone.';
comment on column apex_issue_email_prefs.created_on is 'Date the milestone was created';
comment on column apex_issue_email_prefs.updated_by is 'Developer that last updated the milestone.';
comment on column apex_issue_email_prefs.updated_on is 'Date the milestone was last updated.';
comment on table  apex_issue_email_prefs is 'A list of Issues and associated Milestones.';

prompt ... apex_issue_notifications

create or replace  view apex_issue_notifications (
    workspace_id,
    workspace_name,
    user_name,
    issue_id,
    issue_title,
    issue_status,
    issue_marked_as_deleted,
    comment_id,
    notification_read_yn,
    notification_email_sent_yn,
    notification_email_sent_on,
    notification_created_on,
    notification_type,
    event_id
) as
    select w.workspace_id    workspace_id,
           w.workspace       workspace_name,
       --
           n.user_id         user_name,
           i.id              issue_id,
           i.title           issue_title,
           i.status          issue_status,
           i.deleted         issue_marked_as_deleted,
           n.comment_id      comment_id,
           n.read_yn         notification_read_yn,
           n.email_sent_yn   notification_email_sent_yn,
           n.email_sent_on   notification_email_sent_on,
           n.created_on      notification_created_on,
           n.type            notification_type,
           n.event_id        event_id
      from wwv_flow_issue_notifications   n,
           wwv_flow_issues                i,
           wwv_flow_current_workspaces    w
     where n.security_group_id = w.workspace_id
       and n.issue_id is not null
       and n.issue_id = i.id
       and i.security_group_id = n.security_group_id
    union
    select w.workspace_id    workspace_id,
           w.workspace       workspace_name,
       --
           n.user_id         user_name,
           i.id              issue_id,
           i.title           issue_title,
           i.status          issue_status,
           i.deleted         issue_marked_as_deleted,
           n.comment_id      comment_id,
           n.read_yn         notification_read_yn,
           n.email_sent_yn   notification_email_sent_yn,
           n.email_sent_on   notification_email_sent_on,
           n.created_on      notification_created_on,
           n.type            notification_type,
           n.event_id        event_id
      from wwv_flow_issue_notifications   n,
           wwv_flow_issues                i,
           wwv_flow_issue_comments        c,
           wwv_flow_current_workspaces    w
     where n.security_group_id = w.workspace_id
       and n.comment_id is not null
       and c.id = n.comment_id
       and c.security_group_id = n.security_group_id
       and i.id = c.issue_id;
       
comment on column apex_issue_notifications.workspace_id is 'Primary Key that identifies the workspace.';
comment on column apex_issue_notifications.workspace_name is 'Name of the Workspace.';
comment on column apex_issue_notifications.user_name is 'Workspace user whos preferences are defined by this record';
comment on column apex_issue_notifications.user_name is 'Developer user for which this notification exists.';
comment on column apex_issue_notifications.issue_id is 'Primary key of the related issue.';
comment on column apex_issue_notifications.issue_status is 'Status of the related issue.';
comment on column apex_issue_notifications.issue_marked_as_deleted is 'Whether the related issue has been marked as deleted.';
comment on column apex_issue_notifications.comment_id is 'Primary key of the related comment.';
comment on column apex_issue_notifications.notification_read_yn is 'Has the notification seen ready by the user via the UI (Y or N).';
comment on column apex_issue_notifications.notification_email_sent_yn is 'Has an email been sent to the user (Y or N)';
comment on column apex_issue_notifications.notification_email_sent_on is 'Date an email was sent to the user.';
comment on column apex_issue_notifications.notification_created_on is 'Date the notification was created by the system.';
comment on column apex_issue_notifications.notification_type is 'Type of notification (ISSUE_EDIT COMMENT_ADD COMMENT_EDIT STATUS ASSIGNEE SUBSCRIBER MILESTONE LABEL DUPLICATE ASSOCIATION ATTACHMENT)';
comment on column apex_issue_notifications.event_id is 'Primary key of the related event.';
comment on table  apex_issue_notifications is 'Issue system notifications for a given user.';

prompt ...done creating APEX ISSUE VIEWS
set define '^'
