set define off verify off
prompt ...create flow objects

Rem  Copyright (c) Oracle Corporation 1999 - 2019. All Rights Reserved.
Rem
Rem    NAME
Rem      tab.sql
Rem
Rem    DESCRIPTION
Rem      Flow object creation script.  Create tables, views,
Rem      sequences, Indexes
Rem
Rem    NOTES
Rem      Tables that describe a given flow.  Every attribute relates
Rem      back to the ID column of the WWV_FLOWS table.
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem       mhichwa  08/04/1999 - Created
Rem       mhichwa  09/29/1999 - Removed flow_logging column from wwv flows
Rem       mhichwa  09/30/1999 - Added constraint names
Rem       mhichwa  09/30/1999 - Removed show_reset column from wwv flow steps table
Rem       mhichwa  09/30/1999 - Removed columns tab_*_gif* columns from wwv_flow_tabs
Rem       mhichwa  09/30/1999 - Removed column onload_javascript from wwv_flow_tabs
Rem       mhichwa  10/08/1999 - Removed step_sub_title_font_color column from wwv flow_steps
Rem       mhichwa  10/13/1999 - Added Banner Table
Rem       mhichwa  10/13/1999 - Added unique index on flow template name
Rem       mhichwa  10/14/1999 - Added flow_language column to wwv flows table
Rem       mhichwa  10/14/1999 - Added wwv_flow_languages table
Rem       mhichwa  10/14/1999 - Added wwv_flow_language_map table
Rem       mhichwa  10/17/1999 - Removed success_procedure and success_url from wwv flow_steps
Rem       mhichwa  10/17/1999 - Added not null constraint to wwv flows name
Rem       mhichwa  10/18/1999 - Added flow preferences table
Rem       mhichwa  10/18/1999 - Added wwv_flow_dependancies table
Rem       mhichwa  10/20/1999 - Added success_message, current_tab, and non_current_tab to template
Rem       mhichwa  10/21/1999 - Added Comments to template, proc, item, page, icons etc.
Rem       mhichwa  10/22/1999 - Changed wwv_flow_languages and wwv_flow_language_map columns
Rem       mhichwa  10/23/1999 - Added flow_image_prefix column to wwv flows table
Rem       mhichwa  10/26/1999 - Added translatable text tables
Rem       mhichwa  11/02/1999 - Added BEFORE_SHOW_ITEMS, AFTER_SHOW_ITEMS processing points
Rem       mhichwa  11/02/1999 - Added button_image_attributes column
Rem       mhichwa  11/03/1999 - Added branch types: REQUEST_IN_CONDITION, REQUEST_EQUALS_CONDITION
Rem       mhichwa  11/08/1999 - Changed wwv_flow trigger to default home link if null on insert
Rem       mhichwa  11/08/1999 - Added current_tab_font_attr, non_current_tab_font_attr, box cols to wwv_flow_templates
Rem       mhichwa  11/10/1999 - Added table wwv_flow_dynamic_translations$
Rem       mhichwa  11/13/1999 - Check that button position is not null
Rem       mhichwa  11/15/1999 - Added table wwv_flow_lists_of_values$
Rem       mhichwa  11/15/1999 - Added named_lov to wwv flow step_items table, adjusted triggers
Rem       mhichwa  11/16/1999 - Modified trigger on wwv_flow lists_of_values$ to cascade updates to wwv_flow step_items
Rem       mhichwa  11/16/1999 - Added not null constraints to wwv flow_steps table
Rem       mhichwa  11/23/1999 - Added tab_non_current_image, tab_image_attributes columns
Rem       mhichwa  12/01/1999 - Added body_title column
Rem       mhichwa  12/02/1999 - Added current_image_tab, non_current_image_tab, look columns to template
Rem       mhichwa  12/02/1999 - Added icon_image2, 3, icon_height2,3 icon_width2, 3
Rem       mhichwa  12/03/1999 - Added icon_sub_text1,2,3
Rem       mhichwa  12/07/1999 - Added patch concept, required_patch, wwv_flow_patches table, tab_parent_page...
Rem       mhichwa  12/08/1999 - Added STOP_AND_START_HTML_TABLE check option
Rem       mhichwa  12/08/1999 - Increased size of prompt from 255 to 4000 bytes
Rem       mhichwa  12/09/1999 - Change parent tab from number to varchar2 change name to tab_parent_tabset
Rem       mhichwa  12/12/1999 - Added wwv_flow_template_preferences table
Rem       mhichwa  12/13/1999 - Added default_button_position to template
Rem       mhichwa  12/14/1999 - Added TEMPLATE_DEFAULT to wwv_flow step buttons
Rem       mhichwa  12/15/1999 - Added attribute5,6
Rem       mhichwa  12/19/1999 - Added BEFORE_HEADER branch point
Rem       mhichwa  12/19/1999 - Added tab_also_current_for_pages column
Rem       mhichwa  01/02/2000 - Added table wwv_flow_purged_sessions$ to track purges generated by flowc.plb
Rem       mhichwa  01/07/2000 - Modified trigger wwv_biu_step_items to include flow_id in select statement
Rem       mhichwa  01/09/2000 - Depricated initial_occurs and max_occurances columns
Rem       mhichwa  01/09/2000 - Added translation_specific_to_item and text_substr_1_255 columns
Rem       mhichwa  01/11/2000 - Removed on delete cascade from translated_flow_id
Rem       mhichwa  01/12/2000 - Added plug tables and triggers
Rem       mhichwa  01/15/2000 - Added indexes and constraint names to page_plug tables
Rem       mhichwa  01/15/2000 - Added indexes to step buttons, branches, validations, processes, and computations
Rem       mhichwa  01/20/2000 - Added AFTER_ERROR_HEADER, BEFORE_ERROR_FOOTER
Rem       mhichwa  01/20/2000 - Added error_template, authentication, login_url
Rem       mhichwa  01/21/2000 - Added cookie to  table wwv_flow_sessions$
Rem       mhichwa  01/22/2000 - Removed page on delete cascade from wwv flow page plugs
Rem       mhichwa  01/23/2000 - Added logout_url
Rem       mhichwa  01/24/2000 - Added public_url_prefix
Rem       mhichwa  01/26/2000 - Depricated icon_bar (navbar) lov fields (3)
Rem       mhichwa  01/26/2000 - Added button_plug_id, item_plug_id
Rem       mhichwa  01/28/2000 - Changed index on plug_name to append flow_id
Rem       mhichwa  01/31/2000 - Added table_bgcolor,table_cattributes,heading_bgcolor,font_size,font_face
Rem       mhichwa  01/31/2000 - Added plug_header,footer,font_size,table_bgcolor,heading_bgcolor
Rem       mhichwa  01/31/2000 - Added on delete cascade to plug page to flow page foreign key.
Rem       mhichwa  02/02/2000 - Changed box from varchar2(4000) to clob.
Rem       mhichwa  02/03/2000 - Added SQL_QUERY to plug_source_type
Rem       mhichwa  02/03/2000 - Added wwv_flow_row_template table
Rem       mhichwa  02/11/2000 - Enhanced dynamic translations table
Rem       mhichwa  02/11/2000 - Added wwv_flow_bugs and wwv_flow_developers table
Rem       mhichwa  02/12/2000 - Added additional translatable text tables
Rem       mhichwa  02/14/2000 - Added wwv_flow_dual100 table to facilitate the building of lists of values
Rem       mhichwa  02/17/2000 - Added tables wwv_flow_lists and wwv_flow_list_items
Rem       jkallman 02/18/2000 - Added index wwv_flow_step_item_idx2
Rem       mhichwa  02/19/2000 - Changed implementation of bugs, added wwv_flow_developer_roles table
Rem       mhichwa  02/20/2000 - Added navigation condition types
Rem       mhichwa  02/20/2000 - Added FILE and BUTTON to item types
Rem       mhichwa  02/22/2000 - Change wwv_id to wwv_flow_id
Rem       mhichwa  02/22/2000 - Added button_image and button_image_attr to wwv_flow step_items
Rem       mhichwa  02/23/2000 - Added label_cell_attr, field_cell_attr, added index to ensure unique page,sequence (items)
Rem       mhichwa  02/24/2000 - Added alt_lov (alternative lists of values tables)
Rem       mhichwa  03/02/2000 - Added tab_condition, translation_image_directory
Rem       mhichwa  03/16/2000 - Added button_redirect_url, clear_page_cache for branches
Rem       mhichwa  04/08/2000 - Added display_only_lov
Rem       mhichwa  04/08/2000 - Prefixed some constraints with wwv_
Rem       mhichwa  04/16/2000 - flow_step_item name not null constraint added
Rem       mhichwa  04/16/2000 - changed syntax for create index statements for table wwv flow step_items
Rem       mhichwa  04/16/2000 - removed commented out check constraints for table wwv flow step_items
Rem       mhichwa  04/18/2000 - Added COMBOBOX_WITH_SUBMIT
Rem       mhichwa  04/18/2000 - Force item name to upper case in wwv_biu_step_items trigger
Rem       mhichwa  04/21/2000 - Changed trigger on button table to prevent creating buttons the same name as tabs.
Rem       mhichwa  04/21/2000 - flow_items.name set to upper in trigger
Rem       mhichwa  04/25/2000 - Added condition in reqest and request is numeric branch condition types
Rem       mhichwa  04/27/2000 - Added display_and_save_lov
Rem       mhichwa  05/02/2000 - Added list_item_current_for_pages column
Rem       mhichwa  05/03/2000 - Added wwv_bd_flowpageplugs to set page item plug ids to null on delete of plugs
Rem       mhichwa  05/03/2000 - Added REQUEST_IN_CONDITION type to wwv_flow_step_processing
Rem       mhichwa  05/14/2000 - Added extra cell positioning, added TEXTAREA-AUTO-HEIGHT
Rem       mhichwa  05/15/2000 - Added request equals condition to wwv_flow_step_computations
Rem       mhichwa  05/16/2000 - Added rtrim of process_sql for page processes
Rem       mhichwa  05/16/2000 - Modified plug delete trigger to only null plug id of deleted plug. fixes bug.
Rem       mhichwa  05/16/2000 - Added process_when_button_id
Rem       mhichwa  05/19/2000 - Added constraints to wwv_flow_patches, added wwv_flow_messages table
Rem       mhichwa  05/19/2000 - Removed alt_lov tables and table wwv_flow_translations
Rem       mhichwa  05/19/2000 - Added two display_as types: 'COMBOBOX_WITH_JS_POST', 'COMBOBOX_WITH_JS_REDIRECT'
Rem       mhichwa  05/24/2000 - Added validation_condition, validation_condition_type
Rem       mhichwa  05/26/2000 - Modify wwv_biu_flowrowtemplates
Rem       mhichwa  05/30/2000 - Added dbauth_url_prefix, proxy_server to wwv flows
Rem       mhichwa  05/31/2000 - Added plug_query_format_out _show_nulls_as _col_allignments _break_cols _sum_cols
Rem       mhichwa  06/02/2000 - Added first_item, changed references from Plug to region
Rem       mhichwa  06/03/2000 - Added lov_null_text, and lov_null_value
Rem       mhichwa  06/04/2000 - Added to wwv flow page plugs plug_query_number_formats
Rem       mhichwa  06/05/2000 - Added custom_authentication_process, custom_authentication_page
Rem       mhichwa  06/05/2000 - Changed WWV_FLOW_STEP_ITEM_IDX3 to be non unique
Rem       mhichwa  06/06/2000 - Changed trigger on wwv flow step_items to ignore errors on missing LOV
Rem       mhichwa  06/07/2000 - Added list_item_disp_condition
Rem       mhichwa  06/08/2000 - Added after authentication processing point
Rem       mhichwa  06/09/2000 - Added lov_translated
Rem       mhichwa  06/11/2000 - Added plug_display_condition_type
Rem       mhichwa  06/11/2000 - Added flow public_user
Rem       mhichwa  06/12/2000 - Added 'ITEM_IS_NULL', 'ITEM_IS_NOT_NULL' page validation types
Rem       mhichwa  06/13/2000 - Added wwv_flow_list_of_values_data, plug cond display types, button disp cond types
Rem       mhichwa  06/15/2000 - Added FUNC_BODY_RETURNING_ERR_TEXT
Rem       mhichwa  06/15/2000 - Modified trigger wwv_biu_step_validations
Rem       mhichwa  06/15/2000 - Added tab display condition types
Rem       mhichwa  06/16/2000 - Added CONDITION_IN_REQUEST to check constraint for page processes
Rem       mhichwa  06/17/2000 - Added button condition type MIN_ROW_GT_THAN_ONE ... to check const.
Rem       mhichwa  06/18/2000 - Added branch_when_button_id
Rem       mhichwa  06/18/2000 - added 'PAGE_IS_IN_PRINTER_FRIENDLY_MODE', 'PAGE_IS_NOT_IN_PRINTER_FRIENDLY_MODE'
Rem       mhichwa  06/19/2000 - Fixed error in branch_when_button_id column on create branch table
Rem       mhichwa  06/21/2000 - Added display_as options PICK_DATE_DD_MON_YYYY PICK_DATE_DD_MM_YYYY PICK_DATE_MM_DD_YYYY
Rem       mhichwa  06/21/2000 - flow_page_range_minimum, flow_page_range_maximum
Rem       jkallman 06/21/2000 - Added wwv_flow_months_mon, wwv_flow_months_month, wwv_flow_years
Rem       mhichwa  06/21/2000 - Added pick_date_dd_mon_yy
Rem       mhichwa  06/23/2000 - Expanded condition types for many tables (starting to fix expresion misspelling issue)
Rem       mhichwa  06/23/2000 - Modified trigger on flow_steps to check for valid page ranges
Rem       mhichwa  06/26/2000 - Added additional button positions
Rem       mhichwa  06/26/2000 - Added additional validation condition types
Rem       mhichwa  06/28/2000 - Adjusted  wwv_valid_fsval_valtype constraint
Rem       mhichwa  07/03/2000 - Added plug_column_width
Rem       mhichwa  07/05/2000 - Added not_exists to page validation types
Rem       mhichwa  07/07/2000 - Fixed check constraint on step_validations EXISTS was mission comma
Rem       mhichwa  07/07/2000 - Added trigger to set branch condition type to null if = %null%
Rem       mhichwa  07/10/2000 - Added region_table_cattributes column.
Rem       mhichwa  07/10/2000 - Modified constraint wwv_valid_plug_disppoint
Rem       mhichwa  07/12/2000 - Added text_with_calculator to check constraint
Rem       mhichwa  07/13/2000 - Added CURRENT_PAGE_IN_CONDITION and not in condition to region display types
Rem       mhichwa  07/13/2000 - Changed all foreign keys to wwv_flow_step items to reference page flow_id, id
Rem       mhichwa  08/15/2000 - Adjusted constraint wwv_valid_fsval_valtype added item not zero
Rem       mhichwa  08/19/2000 - Add page item help text table
Rem       mhichwa  08/22/2000 - Added image repository table
Rem       mhichwa  08/24/2000 - Expanded constraint wwv_valid_plug_disppoint to include 20 display regions
Rem       mhichwa  08/30/2000 - Added effective USER ID Capabilities.
Rem       mhichwa  09/03/2000 - Added prompt comments
Rem       mhichwa  09/04/2000 - Added shortcut table
Rem       mhichwa  09/07/2000 - Extended tab condition type to varchar2 255
Rem       mhichwa  09/19/2000 - Added flow status column
Rem       mhichwa  09/20/2000 - Added restrict_to_user_list
Rem       mhichwa  09/21/2000 - Added RADIOGROUP_WITH_JS_SUBMIT check cons
Rem       mhichwa  09/24/2000 - Added CURRENT_LOOK_IS_1 .. 3 for icon bar
Rem       mhichwa  09/28/2000 - Added java_entry_point
Rem       mhichwa  10/02/2000 - Added trigger for tab also current
Rem       mhichwa  10/16/2000 - Modified column name page plug query border
Rem       mhichwa  10/18/2000 - Added text area with controls
Rem       mhichwa  10/19/2000 - Added plug_query_headings_type
Rem       mhichwa  10/25/2000 - Added wwv_flow_temp_table
Rem       mhichwa  10/31/2000 - Added plug caching to wwv flow page plugs
Rem       jkallman 11/01/2000 - Added wwv_flow_mail_log, wwv_flow_mail_queue
Rem       mhichwa  11/01/2000 - Added item is null and item is not null to wwv_val_fscomp_compwhentype
Rem       mhichwa  11/02/2000 - Added preference to wwv_valid_fsitem_sourcetype
Rem       mhichwa  11/02/2000 - Added set preference to item value to wwv_valid_fsproc_type
Rem       mhichwa  11/02/2000 - Added SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL
Rem       mhichwa  11/07/2000 - Added list_item_disp_cond_type2, list_item_disp_condition2
Rem       mhichwa  11/08/2000 - Added substitution strings and values to wwv flows
Rem       mhichwa  11/17/2000 - Added region types url returning xml and query returning xml
Rem       mhichwa  11/21/2000 - Added computation_error_message
Rem       mhichwa  11/29/2000 - Added list_item_current_type column
Rem       mhichwa  12/01/2000 - Added always and never list item current types
Rem       mhichwa  12/07/2000 - Added vpd attribute to wwv flows table
Rem       mhichwa  12/08/2000 - Added security group ID to wwv flows table
Rem       mhichwa  12/08/2000 - Added computation_error_message to flow_computations
Rem       mhichwa  12/09/2000 - Added wwv_flow_security_schemes table
Rem       mhichwa  12/11/2000 - Added SET_ITEM_EQUAL_THIS_PREFERENCE
Rem       mhichwa  12/14/2000 - Added WWV_FLOW_LIST_ITEMS to translatable columns
Rem       mhichwa  12/15/2000 - Added flow_id to flow_list_items to make translations possable
Rem       mhichwa  12/15/2000 - Added when text to tabs and flow computations
Rem       mhichwa  12/18/2000 - Added branch_condition_text column
Rem       mhichwa  12/19/2000 - Added condition text
Rem       mhichwa  12/20/2000 - Removed javascript column from wwv flow step_items
Rem       mhichwa  12/20/2000 - Added security_scheme column to wwv flow step_items
Rem       mhichwa  12/20/2000 - added upper owner to trigger on flows table
Rem       jkallman 12/20/2000 - Added wwv_flow_file_objects$ table, trigger and comments
Rem       mhichwa  12/20/2000 - Added security_scheme column to tabs, parent tabs, nav bar items, and buttons
Rem       mhichwa  12/21/2000 - Added security group ID to a large number of tables
Rem       mhichwa  12/22/2000 - Expanded flow privileges to include new monitor, sql, and browse privs
Rem       mhichwa  12/22/2000 - Added caching and comments to security schemes table
Rem       mhichwa  12/22/2000 - Added security scheme column to wwv flows table
Rem       mhichwa  12/26/2000 - Added failed_sec_checks to sessions table
Rem       mhichwa  01/11/2001 - Added pipe and backslash delimited region report heading types
Rem       mhichwa  01/12/2001 - Added user manager role
Rem       mhichwa  01/12/2001 - Added tag_attributes to flow step items
Rem       mhichwa  01/12/2001 - Added cookie_session_id
Rem       mhichwa  01/12/2001 - Removed think time and page view columns from sessions table
Rem       mhichwa  01/15/2001 - Changed trigger on sessions table
Rem       mhichwa  01/15/2001 - Added support for FUNCTION_BODY_RETURNING_PIPE_DELIMITED_LIST
Rem       mhichwa  01/16/2001 - Added application tabs and application tab sets
Rem       mhichwa  01/16/2001 - Added app tab attributes to page templates
Rem       mhichwa  01/16/2001 - Added application tab set to wwv flows
Rem       mhichwa  01/17/2001 - Added process sql clob to two tables
Rem       mhichwa  01/20/2001 - Added on_new_instance_fired_for
Rem       mhichwa  01/21/2001 - Added zero button display and region display conditions
Rem       mhichwa  01/23/2001 - Added wwv_flow_alternate_config tables
Rem       mhichwa  01/24/2001 - Added build options to configuration
Rem       mhichwa  01/25/2001 - Added added two additional branch condition types
Rem       jkallman 01/26/2001 - Added 15 additional columns to wwv_flow_temp_table
Rem       mhichwa  01/26/2001 - Added two cond types to page computatations
Rem       mhichwa  01/26/2001 - Added item is not null or zero constraint to page plugs and buttons
Rem       mhichwa  01/27/2001 - Added orcl and demo companies
Rem       mhichwa  01/28/2001 - Added indexes to company table
Rem       mhichwa  01/31/2001 - Extended wwv_flow_app_cond_types
Rem       mhichwa  02/02/2001 - Extended trigger to file upload
Rem       mhichwa  02/02/2001 - Added wwv_flow_dynamic_pages table
Rem       mhichwa  02/06/2001 - Updated flow trigger
Rem       mhichwa  02/10/2001 - Added expand and parent id to list items
Rem       mhichwa  02/10/2001 - Added COMBOBOX_WITH_URL_REDIRECT, COMBOBOX_WITH_BRANCH_TO_PAGE
Rem       mhichwa  02/11/2001 - Added not null or zero constraint for page items
Rem       mhichwa  02/12/2001 - Added not null constraint to flow developers table
Rem       mhichwa  02/14/2001 - Added list of values temp table (sdillon)
Rem       mhichwa  02/16/2001 - Added set sec group id to most triggers and some tables
Rem       mhichwa  02/21/2001 - Changed wwv_flow_lov_values inserts to specify column values
Rem       mhichwa  02/21/2001 - Added item not null constraint for validations
Rem       mhichwa  02/22/2001 - Added insert order to lov temp table
Rem       mhichwa  02/23/2001 - Changed indexes on companies table
Rem       mhichwa  02/24/2001 - Changed security group id 10 to FLOWS from ORCL
Rem       mhichwa  02/25/2001 - Added company schemas
Rem       mhichwa  02/27/2001 - Added cbcho sql workshop create table statements
Rem       cbcho    02/27/2001 - Added comma to wwv_flow_sw_parameters create table stmt.
Rem       jstraub  02/28/2001 - Moved triggers to trigger.sql
Rem       tmuth    02/28/2001 - Added coulmns to mail_queue for html mail
Rem       mhichwa  03/01/2001 - Added not null constraint to branch type
Rem       mhichwa  03/01/2001 - FUNCTION_BODY_RETURNING_BOOLEAN added to buttons
Rem       mhichwa  03/01/2001 - Added PLSQL_DBMS_JOB
Rem       mhichwa  03/01/2001 - Added button alignment
Rem       cbcho    03/01/2001 - Added indexes to SQL Workshop table foreign keys
Rem       mhichwa  03/03/2001 - Addded custom auth login url
Rem       mhichwa  03/04/2001 - Depricated page range min and max values
Rem       sdillon  03/05/2001 - Removed unneeded mail queue alter scripts
Rem       sdillon  03/05/2001 - Fixed ...insert call to prompt ...insert
Rem       mhichwa  03/05/2001 - Added security group ID columns to _sw_ sql workshop tables
Rem       mhichwa  03/08/2001 - Added extra columns to support row template translations
Rem       mhichwa  03/13/2001 - Added tree
Rem       cbcho    03/13/2001 - Added SQL Workshop - Control File create table statements
Rem       cbcho    03/13/2001 - Added ctrlfile_stats_id, wwv_flow_sw_stat_fk2, and wwv_flow_sw_stats_idx2
Rem                             on wwv_flow_sw_statistics table
Rem       cbcho    03/13/2001 - Added more wwv_flow_sw_valid_file table insert stmts.
Rem       sdillon  03/14/2001 - Added tables,indexes,etc for wwv_flow_plsql_job,wwv_flow_job
Rem       mhichwa  03/14/2001 - added flow item to tree table
Rem       mhichwa  03/15/2001 - Added plug query no data found
Rem       mhichwa  03/16/2001 - Added wwv_flow_file_objects$part
Rem       mhichwa  03/17/2001 - Added wwv_flow_sw_ctrlfile_stats
Rem       cbcho    03/22/2001 - Changed wwv_flow_sw_cf_idx index creation on wwv_flow_sw_ctrl_files table
Rem       cbcho    03/22/2001 - Changed command column data type to clob on wwv_flow_sw_sql_cmds table
Rem       sdillon  03/22/2001 - Added user_id to wwv_flow_developers for referential integrity to wwv_flow_fnd_user
Rem       mhichwa  03/26/2001 - Added platform imp exp tables
Rem       mhichwa  03/26/2001 - Added file type column flow file objects
Rem       sleuniss 03/28/2001 - Added security group id to wwv_flow_import_export
Rem       sleuniss 03/29/2001 - created by id, schema_name and created by
Rem                             to wwv_flow_import_export
Rem       sdillon  03/30/2001 - Added demo_id to wwv_flow_companies
Rem       mhichwa  03/30/2001 - Made wwv flow owner not null
Rem       sdillon  04/03/2001 - Added first_schema_provisioned to wwv_flow_companies
Rem       sleuniss 04/03/2001 - set FIRST SCHEMA PROVISIONED to FLOWS for default companies.
Rem       mhichwa  04/05/2001 - Added not null constraints to flow_id foreign keys
Rem       mhichwa  04/09/2001 - Added wwv_flow_sw_archives
Rem       cbcho    04/10/2001 - Added parsed_schema column to wwv_flow_sw_sql_cmds
Rem       cbcho    04/10/2001 - Added wwv_flow_sw_archives
Rem       mhichwa  04/10/2001 - Added button c attributes column to flow step buttons
Rem       cbcho    04/10/2001 - Changed wwv_flow_sw_archives columns
Rem       sdillon  04/11/2001 - Added file_object_id to image repository table
Rem       cbcho    04/11/2001 - Added insert stmt to wwv_flow_sw_sqlplus_cmd table
Rem       mhichwa  04/11/2001 - Removed flow tree state table
Rem       cbcho    04/16/2001 - Added ctrl_file_id to wwv_flow_sw_parameters table
Rem       sdillon  04/17/2001 - Added function-based index to wwv flow image repository
Rem       sdillon  04/17/2001 - Added is_on_filesystem col to wwv flow image repository w/ index
Rem       mhichwa  04/17/2001 - Added ignore pagination column
Rem       mhichwa  04/17/2001 - Added text disabled and save to check constraint
Rem       sdillon  04/18/2001 - Removed function-based index due to rqmt to add init.ora params
Rem                             Added shadow column for upper(image_name) index w/ trigger
Rem       cbcho    04/18/2001 - Changed order of sw tables
Rem       mhichwa  04/18/2001 - changed pres to prefs for platform prefs
Rem       mhichwa  04/20/2001 - Added display flow_ID to tab.sql
Rem       mhichwa  04/23/2001 - Added rejoin existing session column to flows table
Rem       sdillon  05/04/2001 - Added image tag column to image repository table
Rem       cbcho    05/07/2001 - Added security_group_id to wwv_flow_sw_statistics table
Rem       cbcho    05/14/2001 - Changed username column lengths to varchar2(255) for all SQL Workshop tables
Rem       sdillon  05/15/2001 - Changed enduser column lengths to varchar2(255) for wwv_flow_job
Rem       sdillon  05/15/2001 - Added wwv_flow_css_repository table for cascading style sheet support
Rem       sdillon  05/24/2001 - Added wwv_flow_html_repository table for static html support
Rem       mhichwa  05/30/2001 - dropped index WWV_FLOWS_DISPLAY_ID_IDX due to dup row issues with translations
Rem       mhichwa  06/05/2001 - added check constraint to page plugs table for sort enabled column headings
Rem       mhichwa  06/07/2001 - added sgid to preferences
Rem       mhichwa  06/08/2001 - added vbs charting objects
Rem       mhichwa  06/17/2001 - added last updated by and on columns to a large number of tables.
Rem       mhichwa  06/18/2001 - Added flow step items
Rem       mhichwa  06/18/2001 - Added allow duplicate submissions table and page attribute
Rem       mhichwa  07/06/2001 - Added plug_query_num_rows_item and plug_query_num_rows_type
Rem       mhichwa  07/17/2001 - Added plug_query_row_count_max, changed meaning of plug_query_num_rows_type
Rem       mhichwa  07/18/2001 - Extended check constraint on region pagination type
Rem       mhichwa  07/18/2001 - Extended security scheme caching check constraint
Rem       mhichwa  07/20/2001 - Added flow_language_derived_from
Rem       tmuth    07/20/2001 - Fixed error in wwv_flow_security_schemes
Rem       mhichwa  07/20/2001 - Added sgid to platform prefs
Rem       mhichwa  07/22/2001 - Added 0 to flow_language_derived_from check constraint
Rem       mhichwa  07/23/2001 - Extended flow_language derived from check contraint with language codes
Rem       mhichwa  07/31/2001 - Added error_page_template
Rem       mhichwa  08/06/2001 - Extended row templates
Rem       mhichwa  08/08/2001 - Fixed bug in row templates create table statement
Rem       mhichwa  08/13/2001 - Added comments for wwv_flow_session_seq trigger
Rem       mhichwa  08/16/2001 - Added wwv flows reserved
Rem       mhichwa  05/09/2000 - apps_tab: Added Copyright
Rem       mhichwa  01/15/2001 - apps_tab: Added trigger computation of end date
Rem       mhichwa  01/15/2001 - apps_tab: Changed datatypes of created by and last updated by to varchars
Rem       mhichwa  01/15/2001 - apps_tab: Removed columns provided in fnd_user that do not make sense for web applications
Rem       mhichwa  01/15/2001 - apps_tab: Added security group ID, person id, and last and first name columns
Rem       mhichwa  02/23/2001 - apps_tab: Changed trigger on fnd user table
Rem       mhichwa  02/26/2001 - apps_tab: Changed trigger on fnd user table
Rem       mhichwa  02/26/2001 - apps_tab: Removed unused tables
Rem       mhichwa  02/26/2001 - apps_tab: Added index on fnd user table
Rem       sdillon  05/03/2001 - apps_tab: Changed ins/upd trigger to md5 hash web_password
Rem       sdillon  05/15/2001 - apps_tab: Changed md5 hash to one_way_hash to encapsulate db dependencies on MD5
Rem       mhichwa  05/17/2001 - apps_tab: Added fnd user groups table
Rem       mhichwa  05/21/2001 - apps_tab: Fixed wwv_flow_fnd_user trigger for updating web_password
Rem       mhichwa  06/28/2001 - apps_tab: Added two new user columns (def schema and allow access to schema)
Rem       mhichwa  07/05/2001 - apps_tab: Added 10 fnd user attributes for generic extensions for users
Rem       mhichwa  08/09/2001 - apps_tab: Added wwv_flow_fnd_user_pw_pref.web_password_format
Rem       mhichwa  08/21/2001 - apps_tab: Added on delete cascade references to group users intersection table
Rem       mhichwa  08/21/2001 - apps_tab: Added comments
Rem       tmuth    08/21/2001 - Added referential integrity constraints
Rem       tmuth    08/22/2001 - Commented referential integrity constraint out of wwv_flow_company_schemas
Rem       mhichwa  08/22/2001 - Removed tmuth commented out integrity constraint
Rem       mhichwa  08/22/2001 - Added global notification column to flows table
Rem       mhichwa  09/25/2001 - Extened check constraint for page validations to include func body returning boolean
Rem       mhichwa  09/28/2001 - Added message text translatable column, and report templates before and after rows
Rem       mhichwa  09/28/2001 - Removed message text translatable column
Rem       mhichwa  10/04/2001 - Added extra range of values for button positions
Rem       mhichwa  10/04/2001 - Added field templates table
Rem       mhichwa  10/04/2001 - Added field templates item_field_template number column to flow page items table
Rem       mhichwa  10/05/2001 - Added COPY button placement condition
Rem       mhichwa  10/05/2001 - Added field template page item column
Rem       tmuth    10/05/2001 - Removed wwv_flow_file_objects$ and moved to file flows_files_new.sql
Rem       mhichwa  10/09/2001 - Added collections tables
Rem       mhichwa  10/09/2001 - Extened constraint wwv_valid_flow_lang_from to include flow lang derived from item preference
Rem       mhichwa  10/09/2001 - Added create 2 button position (VALID_FSTEPB_POSITION)
Rem       mhichwa  10/15/2001 - Added never display condition type for wwv_plug_disp_when_ctype constraint
Rem       mhichwa  10/15/2001 - Added multi row update page processing type
Rem       mhichwa  10/16/2001 - Added updatable report attributes table
Rem       mhichwa  10/17/2001 - Changed index on upd rpt columns table
Rem       mhichwa  10/18/2001 - Added never condition types
Rem       mhichwa  10/24/2001 - Added alias column to flows table
Rem       mhichwa  10/24/2001 - Added alias column to flows page table (wwv flow steps)
Rem       mhichwa  10/24/2001 - Added process_when2 process_when_type2 to wwv flow step processing
Rem       tmuth    10/24/2001 - Added wwv_flow_templates$
Rem       tmuth    10/24/2001 - Added inserts for wwv_flow_templates$
Rem       tmuth    10/24/2001 - Added 3 columns to wwv_flow_templates$
Rem       mhichwa  10/25/2001 - Added additional validation types and validation 2 column
Rem       jstraub  10/29/2001 - Added tables, indexes and sequences for runtime distribution
Rem       tmuth    10/29/2001 - Added column to wwv_flow_templates$
Rem       jstraub  10/29/2001 - Added column download date to wwv_flow_rt_downloads$
Rem       mhichwa  10/30/2001 - Added when_button_pressed column to page validations table
Rem       tmuth    10/30/2001 - Added inserts for new default templates
Rem       mhichwa  10/30/2001 - Added display and save condition for updatable report types
Rem       jstraub  10/31/2001 - Added security group id to runtime distribution tables
Rem       tmuth    11/05/2001 - Removed inserts for default templates and moved to template_gallery.sql
Rem       tmuth    11/05/2001 - Added wwv_flow_template_themes$
Rem       mhichwa  11/12/2001 - Added html page header.
Rem       mhichwa  11/13/2001 - Added button comment.
Rem       mhichwa  11/13/2001 - Added BRANCH_TO_PAGE_IDENT_BY_ITEM, BRANCH_TO_URL_IDENT_BY_ITEM branch types
Rem       jstraub  11/15/2001 - Added wwv_flow_clickthru_log$
Rem       jstraub  11/16/2001 - Added list_countclicks_y_n and list_countclicks_cat to wwv_flow_lists
Rem       mhichwa  11/20/2001 - Added PLUG_QUERY_NO_DATA_FOUND per dbliss instruction.
Rem       mhichwa  11/20/2001 - Added proper spelling of branch conditions for sql and plsql expressions
Rem       tmuth    11/27/2001 - Added XML import/export tables
Rem       mhichwa  12/02/2001 - Added page_is_public_y_n
Rem       tmuth    12/07/2001 - Added 'flows_files.' for constraints that referernce wwv_flow_file_objects$ since a contraint can not reference a synonym.
Rem       mhichwa  12/11/2001 - Added security_scheme column to flow and page processing, validations, comp, and branching.
Rem       jstraub  12/13/2001 - Added wwv_flow_pages_reserved
Rem                           - Added index wwv_flows_reserved_idx, wwv_flow_pages_reserved_idx, wwv_flow_pages_reserved_idx2
Rem       mhichwa  12/14/2001 - Added flow_session column to wwv_flow_pages_reserved
Rem       mhichwa  12/17/2001 - Added charset column to wwv flows table
Rem       jkallman 01/16/2002 - Added views wwv_flow_hours_24, wwv_flow_hours_12, wwv_flow_minutes_5, wwv_flow_minutes
Rem       jkallman 01/17/2002 - Added PICK_DATE_DD_MON_YY_HH24_MI,PICK_DATE_DD_MON_YYYY_HH24_MI,PICK_DATE_DD_MM_YYYY_HH24_MI,
Rem                             PICK_DATE_MM_DD_YYYY_HH24_MI,PICK_DATE_DD_MON_YY_HH_MI,PICK_DATE_DD_MON_YYYY_HH_MI,PICK_DATE_DD_MM_YYYY_HH_MI
Rem                             PICK_DATE_MM_DD_YYYY_HH_MI to constraint of wwv_flow_step_items.display_as
Rem       mhichwa  01/21/2002 - Added reference_id to template tables
Rem       mhichwa  01/24/2002 - Added reference_id to security schemes
Rem       mhichwa  02/03/2002 - Added new process conditions
Rem       cbcho    02/05/2002 - Removed process_sql column from wwv_flow_processing and wwv_flow_step_processing
Rem       jkallman 02/06/2002 - Add 20 additional attributes to wwv_flow_collection_members$, collection_changed column to wwv_flow_collections$
Rem       mhichwa  02/11/2002 - Removed processing conditions added on 2-03
Rem       mhichwa  02/12/2002 - Added session state status to wwv flow data table
Rem       mhichwa  02/12/2002 - Added process condition types for page processes
Rem       mhichwa  02/13/2002 - Added reset session state to page process types
Rem       mhichwa  02/13/2002 - Added columns to many tables to support inline validation display
Rem       mhichwa  02/19/2002 - Added check constrants to valid_fproc_whentype
Rem       mhichwa  02/19/2002 - Added second process condition to flow processing
Rem       mhichwa  02/19/2002 - Added post_element_text column
Rem       cbcho    02/25/2002 - Added 'RESET_USER_PREFERENCES' type for wwv_valid_fsproc_type constraint on wwv_flow_step_processing table
Rem       jkallman 02/28/2002 - Added RADIOGROUP_WITH_SUBMIT to constraint WWV_VALID_FSITEM_DISPLAYAS
Rem       cbcho    03/01/2002 - Added reference_id to wwv_flow_shortcuts table
Rem       mhichwa  03/05/2002 - Added branch to function returning url to valid_fsbranch_branchtype
Rem       mhichwa  03/07/2002 - Added id2 column to wwv_flow_steps to make a single column primary key to facilitate xauth
Rem       msewtz   03/14/2002 - Added stage_table column to wwv_flow_xml_structure
Rem       msewtz   03/14/2002 - Added wwv_flow_xml_upload table for XML import
Rem       mhichwa  03/18/2002 - Added WHEN_THIS_PAGE_SUBMITTED region condition type
Rem       mhichwa  03/19/2002 - Added INITIALIZE_ALL_PAGE_ITEMS check constraint
Rem       cbcho    03/19/2002 - Added process_type column to wwv_flow_processing table
Rem       mhichwa  03/20/2002 - Added on_demand flow process condition type
Rem       mhichwa  03/21/2002 - Added on demand flow page processing to wwv_valid_fsproc_type
Rem       mhichwa  03/22/2002 - Removed stage_table
Rem       tmuth    03/26/2002 - Removed wwv_flow_company_u_schema constraint from wwv_flow_company_schemas so more than one company can use a schema.
Rem       mhichwa  04/01/2002 - removed unique index (changed to non unique index) on company schemas table.
Rem       cbcho    04/04/2002 - Added reference_id to wwv_flow_icon_bar table
Rem       cbcho    04/08/2002 - Added WHEN_THIS_PAGE_NOT_SUBMITTED display condition check constraint type to wwv_flow_page_plugs
Rem       cbcho    04/10/2002 - Added reference_id to WWV_FLOW_LISTS_OF_VALUES$ table
Rem       mhichwa  04/16/2002 - Made wwv_flow_company_schemas_idx index unique
Rem       jkallman 04/22/2002 - Rewrote view wwv_flow_years to accomodate 150 year range
Rem       jkallman 04/29/2002 - Added flow_id component to wwv_flow_collections (so collections are unique across flows)
Rem       mhichwa  04/29/2002 - Added flow table to hold popup lov template
Rem       mhichwa  04/30/2002 - Added sql_expression constraint domains
Rem       mhichwa  04/30/2002 - Added 3 menu tables
Rem       mhichwa  04/30/2002 - Added menu menu_template_id column
Rem       mhichwa  05/01/2002 - Added reference_id to 2 new template tables
Rem       mhichwa  05/02/2002 - Added before and after result set.
Rem       mhichwa  05/02/2002 - Added unique index for menu options table.
Rem       mhichwa  05/07/2002 - Removed condition type check constraints in preperation to moving toward standard condition types
Rem       cbcho    05/08/2002 - Modified icon_bar_disp_cond_type column length to be varchar2(255)

Rem       mhichwa  05/08/2002 - Added wwv_flow_lov_groups table
Rem       mhichwa  05/08/2002 - Added plug_display_when_cond2 column
Rem       mhichwa  05/08/2002 - Added button display condition 2
Rem       mhichwa  05/09/2002 - Added display_condition2 to toplevel tabs (parent tabs)
Rem       mhichwa  05/09/2002 - Added lov_disp_cond2
Rem       mhichwa  05/09/2002 - Added validation_condition2
Rem       mhichwa  05/09/2002 - Added display condition 2 to page items
Rem       mhichwa  05/10/2002 - Fixed on delete cascade on wwv_flow_fk_poplov_temp table
Rem       mhichwa  05/21/2002 - Added POPUP_FILTER to check constraint
Rem       mhichwa  05/29/2002 - Added before first and after last
Rem       jstraub  07/08/2002 - Added wwv_flow_version$ ddl from flows_version_tab.sql
Rem       sspadafo 07/09/2002 - Changed inserts into wwv_flow_companies to use '^FLOW_OWNER' parameter for column value
Rem       cbcho    07/12/2002 - Added timestamp column in wwv_flow_mail_queue table
Rem       cbcho    07/12/2002 - Added 'PLSQL_ANONYMOUS_BLOCK' as item source type
Rem       mhichwa  07/17/2002 - Added wwv_flow_button_templates table
Rem       tmuth    07/19/2002 - Changed check constraint on wwv_flow_templates$
Rem       mhichwa  07/19/2002 - Added PICK_DATE_DD_MON_RR and two others
Rem       mhichwa  07/31/2002 - Changed wwv_flows_alias_idx from a unique index on alias to alias and security_group_id
Rem       mhichwa  07/31/2002 - Ensure wwv_flow alias column is not null, added not null constraint
Rem       mhichwa  08/04/2002 - Added web services to wwv_valid_fsproc_type page processing check constraint
Rem       mhichwa  08/09/2002 - Added plug_query_more_data
Rem       mhichwa  08/10/2002 - Added COMPUTED_BUT_NOT_DISPLAYED
Rem       mhichwa  08/11/2002 - Added exact_substitutions_only
Rem       mhichwa  08/14/2002 - Added ROW_RANGES_WITH_LINKS_RIGHT
Rem       mhichwa  08/15/2002 - Added when_no_data_found_message before_first_fetch_message minimum_characters_required
Rem       mhichwa  05/15/2002 - Added default_on_export attribute1 attribute2 attribute3 attribute4
Rem       mhichwa  05/15/2002 - Removed not null constraints on wwv_flow_field_templates body1 and body2 columns
Rem       mhichwa  08/15/2002 - Added field types POPUP3, POPUP4, POPUP5, POPUP6
Rem       mhichwa  08/16/2002 - Added DISPLAY_ONLY_PLSQL item type
Rem       mhichwa  08/29/2002 - Removed not null from template2 and template3 columns in page region template table
Rem       mhichwa  09/13/2002 - Added TEXTAREA_CHAR_COUNT and TEXTAREA_CHAR_COUNT_SPELL to check constraint list
Rem       mhichwa  09/19/2002 - Added default_label_template default_report_template default_list_template default_menu_template
Rem       mhichwa  09/19/2002 - Added html_page_onload
Rem       mhichwa  09/21/2002 - Added more check constraints for region positions and new dynamic region positions
Rem       mhichwa  09/24/2002 - Added customized column page plugs, removed
Rem       sspadafo 09/24/2002 - Added custom_auth_setups table
Rem       mhichwa  09/25/2002 - Added plug_override_reg_pos
Rem       mhichwa  09/25/2002 - Added cattributes_element and extended cattributes to 4000 in wwv_flow_step_items
Rem       mhichwa  09/26/2002 - Added page_is_protected_y_n, prevents url tampering thus session state alt via a url
Rem       mhichwa  09/26/2002 - Added pagination template attributes
Rem       mhichwa  09/26/2002 - Altered wwv_plug_head_type_check
Rem       sspadafo 09/27/2002 - Added wwv_flow_entry_points, wwv_flow_entry_point_args, wwv_flow_step_branch_args
Rem       mhichwa  09/27/2002 - Added pagination_display_position
Rem       mhichwa  10/09/2002 - Added break column attributes
Rem       mhichwa  10/10/2002 - Added region customize attribute
Rem       mhichwa  10/10/2002 - Added wwv_flow_group_users view
Rem       mhichwa  10/11/2002 - Added wwv_flow_page_generic_attr table
Rem       mhichwa  10/20/2002 - Added item_name, name_length to wwv_flow_data
Rem       mhichwa  10/20/2002 - Added second index to wwv_flow_data
Rem       mhichwa  10/21/2002 - Added sgid to  wwv_flow_page_generic_attr
Rem       tmuth    10/24/2002 - Added cattributes_element to wwv_flow_step_items
Rem       mhichwa  10/25/2002 - Added 3 read only attributes to items table
Rem       mhichwa  10/25/2002 - Commented application tab attributes as obsolete
Rem       mhichwa  10/30/2002 - Added page_component_map
Rem       mhichwa  10/31/2002 - Added ON_SUBMIT_BEFORE_COMPUTATION process to check constraint
Rem       tmuth    11/01/2002 - Removed reference to ^FLOW_OWNER, now using select user... technique
Rem       mhichwa  11/04/2002 - Added SHOW_AS_SL_WITH_POPUP
Rem       mhichwa  11/07/2002 - Added index wwv_flow_session_idx1
Rem       tmuth    12/02/2002 - Moved wwv_flow_users and wwv_flow_group_users to view.sql
Rem       msewtz   12/04/2002 - Added NO_HEADINGS to constraint wwv_plug_head_type_check
Rem       cbcho    12/06/2002 - Changed unique index wwv_flow_developers_id to normal index. To allow saving more than 1 developer roles per user.
Rem       mhichwa  12/18/2002 - Added company_schema_comments column on wwv_flow_company_schemas to get around db bug
Rem       mhichwa  12/22/2002 - Added BRANCH_TO_PAGE_ACCEPT
Rem       mhichwa  01/02/2003 - bug 2733051, added branch type check constraint
Rem       mhichwa  01/02/2003 - bug 2733061, removed table and column comments
Rem       jkallman 01/16/2003 - bug 2753723, added view wwv_flow_user_activity_log
Rem       mhichwa  01/17/2003 - bug 2756289, adjust column create orders
Rem       mhichwa  01/26/2003 - bug 2769756, add additional process types and new process column
Rem       mhichwa  01/26/2003 - bug 2769756, added after submit before validation process point
Rem       mhichwa  01/27/2003 - bug 2769756, additional process types
Rem       mhichwa  01/27/2003 - bug 2770759, add capability to initialize session
Rem       mhichwa  01/27/2003 - bug 2770772, added capability to reset pagination from a process
Rem       tmuth    02/03/2003 - bug 2776149, added wwv_flow_tabset_view2 to union in parent tabs with no std tabs
Rem       mhichwa  02/04/2003 - bug 2785527, extend length of plug_query_number_formats column from 255 to 4000
Rem       mhichwa  02/19/2003 - bug 2811199, changed /i/ references to use image prefix
Rem       mhichwa  02/20/2003 - bug 2811609, added simple pagination lov item
Rem       sspadafo 02/23/2003 - Changes for template column name changes from varchar2 to number (Bug 2748399)
Rem       mhichwa  02/24/2003 - bug 2819037, added BRANCH_TO_FUNCTION_RETURNING_PAGE
Rem       jstraub  02/26/2003 - bug 2823889, removed insert of company 20 into wwv_flow_companies
Rem       msewtz   03/06/2003 - bug 2492409, added sequence column to wwv_flow_xml_structure
Rem       sspadafo 03/06/2003 - Add session_id hashed to wwv_flow_sessions$, with indexes (Bug 2837566)
Rem       msewtz   03/07/2003 - Added security_group_id to wwv_flow_xml_upload
Rem       jkallman 03/07/2003 - Bug 2748410, add wwv_flow_field_templates, other reporting attributes to wwv_flow_translatable_cols$,
Rem                             added index wwv_flow_translatable_key2
Rem       jstraub  03/10/2003 - Replaced select user with select sys_context( 'userenv', 'current_schema') for FLOW_OWNER
Rem       jstraub  03/11/2003 - Added nls_language, nls_territory and lang_id_upper to wwv_flow_languages
Rem       jstraub  03/12/2003 - Addded 'AVAILABLE_W_INLINE_EDIT' to wwv_flow_valid_status check (Bug 2845535)
Rem       jstraub  03/13/2003 - added translate_this_template to all template tables with Y,N check constraint
Rem       jstraub  03/14/2003 - added composite index on wwv_flow_languages
Rem       tmuth    03/17/2003 - Added to new types to wwv_valid_fsitem_displayas check constraint, TEXT_WITH_ENTER_SUBMIT & PASSWORD_WITH_ENTER_SUBMIT
Rem       jstraub  03/17/2003 - Added trans_flow_lang_code_root varchar2(30) to wwv_flow_language_map
Rem       jstraub  03/18/2003 - Changed where clause in wwv_flow_user_activity_log from wwv_flow.get_sgid to selecting it from sys.dual per tkyte
Rem       mhichwa  03/19/2003 - Added plug_query_hit_highlighting bug (2860378)
Rem       jstraub  03/25/2003 - Added tree and web service ddl
Rem       jstraub  03/25/2003 - Removed the first wwv_flow_years view statement
Rem       jstraub  03/25/2003 - Removed obsolete table wwv_flow_dynamic_pages
Rem       mhichwa  03/30/2003 - Added to page process type check constraint domain (bug 2878963)
Rem       sspadafo 03/30/2003 - Added to CLEAR_CACHE_FOR_FLOWS page process type check constraint domain (bug 2878963)
Rem       sspadafo 04/01/2003 - Remove check constraints on condition column in shortcuts table (Bug 2860487)
Rem       sspadafo 04/02/2003 - Add wwv_flow_compound_conditions table (Bug 2860487)
Rem       sspadafo 04/02/2003 - Add new computation type 'ITEM_VALUE' (Bug 2885807)
Rem       sspadafo 04/03/2003 - Remove not null constraint from shortcuts consideration_seq column (Bug 2887077)
Rem       jkallman 04/04/2003 - Corrected view wwv_flow_years to include year 2020 (bug 2888902)
Rem       tmuth    04/07/2003 - Added Sharon's new tables (wwv_flow_upg_tab_obsolete,wwv_flow_upg_col_obsolete,wwv_flow_upg_tab_name_changes,wwv_flow_upg_col_name_changes)
Rem       jstraub  04/08/2003 - Added REGULAR_EXPRESSION to check constraint wwv_valid_fsval_valtype
Rem       jstraub  04/09/2003 - Added missing indexes on flow_id where defined as foreign key
Rem       jstraub  04/10/2003 - Added column template_translatable to wwv_flow_tranlsatable_cols$ and wwv_flow_translatable_text$
Rem       jstraub  04/10/2003 - Altered inserts into wwv_flow_translatable_cols$ to inlcude new template_translatable column
Rem       jstraub  04/10/2003 - Added inserts into wwv_flow_translatable_cols$, id's 52 - 77
Rem       cbcho    04/14/2003 - Added Sharon's hint tables (wwv_flow_hnt_table_info, wwv_flow_hnt_column_info)
Rem       cbcho    04/15/2003 - Added wwv_flow_region_chart_ser_attr DDL (bug 2722911)
Rem       cbcho    04/15/2003 - Added Sharon's wwv_flow_hnt_column_info DDL change
Rem       jstraub  04/16/2003 - Fixed insert into wwv_flow_translatable_cols$
Rem       msewtz   04/18/2003 - Added asc and desc image info columns to wwv_flow_page_plugs
Rem       jkallman 04/23/2003 - Add support for flow attributes, shortcuts, post_element_text in translatable columns
Rem       jkallman 04/24/2003 - Added column flow_id to wwv_flow_menu_options
Rem       jkallman 04/24/2003 - Add support for wwv_flow_menu_options in translatable columns
Rem       sspadafo 04/26/2003 - Added display type POPUP_KEY_LOV_NOFETCH to wwv_valid_fsitem_displayas
Rem       msewtz   04/28/2003 - Added wwv_flow_region_report_filter
Rem       msewtz   04/28/2003 - Added wwv_flow_region_report_column
Rem       msewtz   04/28/2003 - Added wwv_flow_query_condition
Rem       msewtz   04/28/2003 - Added wwv_flow_query_column
Rem       msewtz   04/28/2003 - Added wwv_flow_query_object
Rem       msewtz   04/28/2003 - Added wwv_flow_query_definition
Rem       cbcho    04/29/2003 - Added Sharon's PK of WWV_FLOW_HNT_COLUMN_INFO for fix an error
Rem       cbcho    04/29/2003 - Added Sharon's wwv_flow_hnt_procedure_info and wwv_flow_hnt_argument_info DDL
Rem       jkallman 05/01/2003 - Reorder indexed columns in index wwv_flow_messages_idx1, added wwv_flow_messages_idx2
Rem       jstraub  05/02/2003 - Added cond_column to wwv_flow_query_condition, and made condition nullable
Rem       jkallman 05/02/2003 - Removed extra blank line in definition of wwv_flow_page_plugs (would not compile)
Rem       jstraub  05/02/2003 - Added 'JOIN' to valid_compound_operator check condition on wwv_flow_query_condition
Rem       jkallman 05/02/2003 - Convert datatypes in wwv_flow_translatable_text$ to NCLOB and NVARCHAR2
Rem       cbcho    05/02/2003 - Added reference_id in wwv_flow_step_item_help
Rem       msewtz   05/05/2003 - Added indexes to wwv_flow_region_report_column, ...region_report_filter, .query_definition, ...query_object, ...query_condition and .query_column tables
Rem       msewtz   05/06/2003 - Added query_column_id to wwv_flow_report_column
Rem       jstraub  05/07/2003 - Added 'NONE' to valid_compound_operator check condition on wwv_flow_query_condition, made operator col not null
Rem       jstraub  05/07/2003 - Added cond_root to wwv_flow_query_condition
Rem       jstraub  05/07/2003 - Added 'NJOIN' to valid_compound_operator
Rem       jkallman 05/08/2003 - Added WWV_FLOW_PAGE_PLUGS.PLUG_QUERY_MORE_DATA to translatable columns
Rem       jkallman 05/08/2003 - Added flow_id to wwv_flow_list_of_values_data, add same table to translatable columns
Rem       jkallman 05/09/2003 - Add auth_setups columns to translatable columns, added wwv_flow_lov_data_idx2, wwv_flow_menu_opt_idx1
Rem       jkallman 05/09/2003 - Add wwv_flow_step_items.lov_null_text to translatable columns
Rem       jkallman 05/09/2003 - Remove 2 columns from auth_setups in translatable columns
Rem       cbcho    05/12/2003 - Removed DDL for WWV_FLOW_VBSCHART_SEQ and wwv_flow_vbschart_sql since Excel chart deprecated.
Rem       mhichwa  05/12/2003 - Added columns to region report columns to support upd reports, bug 2861658
Rem       mhichwa  05/12/2003 - Made column heading nullable, bug 2861658
Rem       jstraub  05/13/2003 - Removed query_name from wwv_flow_query_definition and added region_id
Rem       jkallman 05/13/2003 - Added 4 columns from table WWV_FLOW_REGION_REPORT_COLUMN to translatable columns
Rem       jstraub  05/14/2003 - Added index on region_id for wwv_flow_query_definition
Rem       jstraub  05/14/2003 - Removed query_source from wwv_flow_query_definition
Rem       msewtz   05/14/2003 - Added form_element_id to wwv_flow_region_report_column
Rem       mhichwa  05/16/2003 - Added two new columns to page plugs for dml returning feature, bug 2965281
Rem       cbcho    05/20/2003 - Added insert statement to add 'WHENEVER' as value of WWV_FLOW_SW_SQLPLUS_CMD table
Rem       mhichwa  05/22/2003 - moved RETURN_KEY_INTO_ITEM1 and 2 from page plugs to step processing, bug 2965281
Rem       jstraub  05/29/2003 - Removed wwv_flow_xml_mapping, wwv_flow_xml_structure and wwv_flow_xml_upload bug 2972214
Rem       mhichwa  05/29/2003 - added format mask to step items, bug 2983469
Rem       sbkenned 06/02/2003 - wwv_flow_hnt_column_info: Renamed mask to mask_report, added mask_form
Rem       jkallman 06/02/2003 - Rewrite view wwv_flow_collections to use sys.dual for optimzation
Rem       msewtz   06/25/2003 - Changed column_alias to varchar(4000) in create_region_report_column
Rem       klrice   07/02/2003 - added wwv_flow_activity_log_mv for log reporting. and changed wwv_flow_user_activity_log to use the mat view
Rem       sspadafo 07/02/2003 - removed activity log mv ddl, added indexes to log tables, added initrans/maxtrans
Rem       sspadafo 07/02/2003 - made time_stamp col in activity log tables not null, created index on that col
Rem       msewtz   07/22/2003 - added POPUP_QUERY to WWV_REGREPCOL_DISPLAY_AS constraint
Rem       jkallman 07/22/2003 - Add additional columns to index wwv_flow_translatable_from_id (Bug 3048414)
Rem       jkallman 07/23/2003 - Added plug_customized_name to translatable columns
Rem       mhichwa  07/23/2003 - Removed bug tables, feature obsolete, bug 3037774
Rem       jkallman 08/04/2003 - Add nls_sort values to wwv_flow_languages (Bug 3032142)
Rem       jkallman 08/04/2003 - Added wwv_flow_charsets (Bug 3033761)
Rem       msewtz   08/05/2003 - Added text_from_lov to wwv_regrepcol_display_as
Rem       jkallman 08/05/2003 - Added wwv_flow_step_item_help to translatable columns (Bug 3086786)
Rem       sspadafo 08/18/2003 - Remove unique index wwv_flow_page_alias_idx, replace with unique constraint (Bug 3039513)
Rem       jkallman 08/19/2003 - Set template_translatable to 'N' for certain Popup LOV template attributes (Bug 3104790)
Rem       sspadafo 08/19/2003 - Add non_unique index on wwv_flow_steps (flow_id,alias), remove unique constraint (Bug 3039513)
Rem       mhichwa  08/25/2003 - Added PICK_DATE_USING_APP_FORMAT_MASK (bug 3113258)
Rem       jstraub  09/02/2003 - Added file_charset to wwv_flow_files
Rem       jkallman 09/05/2003 - Use FLOW_ITEM_ID as table pk in translatable columns for WWV_FLOW_STEP_ITEM_HELP
Rem       jkallman 09/16/2003 - Remove wwv_flow_page_plugs.plug_query_headings from translatable columns
Rem       msewtz   09/18/2003 - Added constraint wwv_flow_urc_to_plug_fk to wwv_flow_region_upd_rpt_cols (bug 3147935)
Rem       jkallman 09/23/2003 - Modified entries in wwv_flow_charsets, added Chinese EUC (per SGT)
Rem       jkallman 09/23/2003 - Updated IANA name for Korean EUC
Rem       sspadafo 11/02/2003 - new indexes for wwv_flow_language_map (Bug 3231672)
Rem       sspadafo 11/19/2003 - Expanded audit columns in wwv_flow_hnt* tables (Bug 3243851)
Rem       jkallman 12/16/2003 - Added view wwv_flow_format_masks (Bug 3246079)
Rem       jkallman 04/01/2004 - Added clob001 to wwv_flow_collection_members$ and to wwv_flow_collections
Rem       cbcho    04/07/2004 - Added GET_NEXT_OR_PREV_PK type to wwv_flow_step_processing
Rem       jkallman 04/16/2004 - Modified constraint wwv_flow_valid_shortcut_type to include MESSAGE, MESSAGE_ESCAPE_JS, and TEXT_ESCAPE_JS
Rem       mhichwa  04/22/2004 - Add lov_template column bug 3588925
Rem       mhichwa  04/29/2004 - Add kris.rice calendar tables bug 360246
Rem       mhichwa  04/29/2004 - Added reference_id to calendar template table bug 360246
Rem       jstraub  05/03/2004 - Added tables for improved web services feature
Rem       msewtz   05/03/2004 - modified WWV_REGREPCOL_DISPLAY_AS check constraint for support of date popups in tabular forms
Rem       jkallman 05/04/2004 - Corrected wwv_Flow_Cals, wwv_flow_cal_templates
Rem       jstraub  05/13/2004 - Added output_message_style to wwv_flow_ws_operations
Rem       jstraub  05/13/2004 - Added on delete cascade to parameter_id on wwv_flow_ws_process_parms_map
Rem       jstraub  05/14/2004 - Removed parent_type, array_name from wwv_flow_ws_parameters and added parent_id
Rem       jstraub  05/17/2004 - Add input_message_style column to wwv_flow_ws_opertaions
Rem       mhichwa  05/17/2004 - Add columns to wwv_flows to support default region templates by component type (bug 3633463)
Rem       mhichwa  05/17/2004 - Add default menu region template to wwv_flows (bug 3633463)
Rem       jkallman 05/18/2004 - Corrected spelling of last_updated_by in wwv_flow_cal_templates, moved calendar creation after wwv_flow_page_plugs (Bug 3622018)
Rem       msewtz   05/18/2004 - added form_region_title and report_region_title to wwv_flow_hnt_table_info table, removed comments
Rem       msewtz   05/18/2004 - updated wwv_flow_hnt_column_info table, removed comments
Rem       msewtz   05/18/2004 - added wwv_flow_hnt_lov_data
Rem       msewtz   05/18/2004 - added pk_col_source_type, pk_col_source, derived_column, ref_schema, ref_table_name, ref_column_name to wwv_flow_region_report_column table
Rem       msewtz   05/18/2004 - added CHECKBOX, RADIOGROUP to wwv_regrepcol_display_as constraint
Rem       msewtz   05/18/2004 - added 'MULTI_ROW_DELETE','ADD_ROWS_TO_TABULAR_FORM','RESET_PAGINATION_FOR_REGION','RESET_SORTING_FOR_REGION' to wwv_valid_fsproc_type
Rem       msewtz   05/18/2004 - added row_style_mouse_over, row_style_mouse_out, row_style_checked, row_style_unchecked columns to wwv_flow_row_template table
Rem       mhichwa  05/19/2004 - Added item_link and day_link to wwv_flow_cals table to support required calendar feature function
Rem       mhichwa  05/19/2004 - Added breadcrumb_def_reg_pos and sidebar_def_reg_pos to wwv_flow_templates
Rem       klrice   05/21/2004 - removed not null from wwv_flow_Cals
Rem       mhichwa  05/24/2004 - Added default_listr_template column to wwv_flows table
Rem       mhichwa  05/24/2004 - Added wwv_flow_lock_page and wwv_flow_lock_page_log tables
Rem       mhichwa  05/26/2004 - Added navbar_entry template to wwv_flow_templates to facilitate improved navbar HTML coding
Rem       jkallman 05/27/2004 - Remove references to ^FLOW_OWNER
Rem       jkallman 06/01/2004 - Added ITEM_IS_DATE to constraint on wwv_flow_step_validations.validation_type
Rem       mhichwa  06/01/2004 - Added theme_id and theme_class_id columns to template tables
Rem       mhichwa  06/01/2004 - Added theme_id to wwv_flows table to identify the theme used for a specific application
Rem       mhichwa  06/01/2004 - Added default_calendar_template to wwv_flows
Rem       jstraub  06/02/2004 - Added header_message_name and header_message_style to wwv_flow_ws_operations, and 'H' in chk for parm_type
Rem       klrice   06/03/2004 - Renamed and ez_ to easy_
Rem       klrice   06/04/2004 - Add display_type to wwv_flow_Cals
Rem       sspadafo 06/06/2004 - Add tables wwv_flow_roles, wwv_flow_local_users, wwv_flow_user_roles
Rem       sspadafo 06/06/2004 - Add column to wwv_flow_step_processing for dml_fetch_mode option
Rem       sspadafo 06/07/2004 - Remove column from wwv_flow_step_processing for dml_fetch_mode option
Rem       sspadafo 06/07/2004 - Revise tables wwv_flow_roles, wwv_flow_local_users, wwv_flow_user_roles
Rem       sspadafo 06/07/2004 - Remove tables wwv_flow_roles, wwv_flow_local_users, wwv_flow_user_roles
Rem       jkallman 06/08/2004 - Rename columns in wwv_flow_mail_queue, add new columns to wwv_flow_mail_log
Rem       jkallman 06/08/2004 - Added views wwv_flow_user_mail_queue and wwv_flow_user_mail_log
Rem       cbcho    06/09/2004 - Added aggregate_by to wwv_flow_hnt_column_info
Rem       jkallman 06/10/2004 - Add wwv_flow_shortcuts.error_text to translatable_columns
Rem       jkallman 06/10/2004 - Renamed index wwv_flow_step_item_help to wwv_flow_step_item_help_idx (Bug 3256811)
Rem       mhichwa  06/10/2004 - Added theme_id and theme_class_id columns to popup lov template table
Rem       mhichwa  06/10/2004 - Added wwv_flow_themes table and index
Rem       sspadafo 06/11/2004 - Add table wwv_flow_customized_tasks
Rem       jkallman 06/11/2004 - Modify values of check constraint for displayed in wwv_flow_customized_tasks, name check constraints
Rem       mhichwa  06/11/2004 - Refined datatypes in wwv_flow_themes table
Rem       msewtz   06/11/2004 - added new report attributes to wwv_flow_page_plugs and wwv_flow_region_report_column
Rem       skutz    06/11/2004 - added wwv_flow_templates_all and wwv_flow_templates_used views
Rem       skutz    06/11/2004 - modified view wwv_flow_templates_used views and corrected case issues
Rem       skutz    06/14/2004 - added or corrected unique indexes on tempalte tables to include theme_id
Rem       skutz    06/14/2004 - added theme_id to unique index on wwv_flow_popup_lov_template
Rem       sspadafo 06/18/2004 - Add database_action to wwv_flow_step_buttons
Rem       sspadafo 06/18/2004 - Add web_password_raw to wwv_flow_fnd_user
Rem       klrice   06/21/2004 - added start_of_week and print_url
Rem       klrice   06/22/2004 - changed display_as to varchar2(100) and removed contraint
Rem       klrice   06/24/2004 - added display_item to wwv_flow_cals
Rem       msewtz   06/25/2004 - added 'T' as type code to wwv_flow_regrepcol_src_type
Rem       mhichwa  07/08/2004 - Added wwv_flow_page_groups
Rem       mhichwa  07/08/2004 - Added group_id column to wwv_flow_page_steps
Rem       mhichwa  07/09/2004 - Enlarge TAB_ALSO_CURRENT_FOR_PAGES column from 255 to 4000
Rem       mhichwa  07/09/2004 - Added column_link_attr to report columns table
Rem       jkallman 07/12/2004 - Added missing comma to column_link_attr
Rem       jkallman 07/14/2004 - Add wwv_flow_online_help and wwv_flow_online_help_ja
Rem       mhichwa  07/15/2004 - Add template_comments column to wwv_flow_cal_templates table
Rem       jkallman 07/16/2004 - Add plaintext columns to wwv_flow_online_help and wwv_flow_online_help_ja
Rem       sbkenned 07/27/2004 - Added TEXT_FROM_LOV as a valid value for wwv_flow_hnt_column_info.display_as_tab_form and display_as_report
Rem       sspadafo 07/29/2004 - Add wwv_flow_restrict_admin (Bug 3781714)
Rem       mhichwa  08/02/2004 - Added list template id column to page plugs table
Rem       mhichwa  08/02/2004 - Added 2 column to wwv_flows table (logo_image and logo_image_attributes)
Rem       jstraub  08/09/2004 - Changed WWV_DICTIONARY$ to WWV_FLOW_DICTIONARY$
Rem       jkallman 08/13/2004 - Add cset column to wwv_flow_online_help_ja
Rem       skutz    08/30/2004 - Modified wwv_flow_tempaltes_used to support new list template defaults at page level (bug 3857356)
Rem       sbkenned 09/09/2004 - Modified check constraints on wwv_flow_hnt_column_info for display_as form, tab_form & report to include PICK_DATE_YYYY_MM_DD & PICK_DATE_RR_MON_DD
Rem       jkallman 09/22/2004 - Added one additional format mask to view wwv_flow_format_masks
Rem       jstraub  10/27/2004 - Added indexes on foreign keys for wwv_flow_hnt_lov_data and wwv_flow_page_groups
Rem       sspadafo 12/13/2004 - Changed last_updated_by/created_by to vc2(255) in couple of wwv_flow_hnt_* tables (Bug 4064128)
Rem       msewtz   01/07/2004 - Added columns parent_list_item_id, sub_item_count to table wwv_flow_list_items
Rem       msewtz   01/07/2004 - Added columns between_items, before_sub_list, after_sub_list, between_sub_list_items, sub_list_item_current, sub_list_item_noncurrent to table wwv_flow_list_templates
Rem       msewtz   01/07/2004 - Added index parent_list_item_id_idx
Rem       msewtz   01/07/2004 - Added columns item_template_curr_w_child, item_template_noncurr_w_child clob, sub_template_curr_w_child, sub_template_noncurr_w_child to wwv_flow_list_templates
Rem       sspadafo 01/14/2005 - Added wwv_flow_qb_saved_query
Rem       sspadafo 01/17/2005 - Added translatable columns dml for sub list columns in wwv_flow_list_templates
Rem       sspadafo 01/17/2005 - Remove unused column list_item_parent_id from wwv_flow_list_items
Rem       sspadafo 01/17/2005 - Adjusted column sizes, constraints, renamed owner column name for wwv_flow_qb_saved_query
Rem       cbcho    01/27/2005 - Removed tables wwv_flow_sw_ctrl_files,wwv_flow_sw_parameters,wwv_flow_sw_ctrlfile_stats,wwv_flow_sw_statistics,wwv_flow_sw_detail_statistics,wwv_flow_sw_valid_file,wwv_flow_sw_ctrl_file_details,wwv_flow_sw_archives
Rem       cbcho    01/27/2005 - Removed insert to wwv_flow_sw_valid_file
Rem       cbcho    01/27/2005 - Removed insert of '@' to wwv_flow_sw_sqlplus_cmd
Rem       cbcho    01/27/2005 - Added tables wwv_flow_sw_binds,wwv_flow_sw_results,wwv_flow_sw_detail_results
Rem       msewtz   01/27/2005 - Added parent_list_item_fk constraint to wwv_flow_list_items
Rem       sspadafo 01/28/2005 - Added wwv_flow_qb_saved_cond, wwv_flow_qb_saved_join, wwv_flow_qb_saved_tabs
Rem       cbcho    01/31/2005 - Changed DDL for wwv_flow_sw_results,wwv_flow_sw_detail_results
Rem       cbcho    02/01/2005 - Removed extra ',' in parent_list_item_fk constraint for msewtz
Rem       cbcho    02/01/2005 - Removed qb_js column from wwv_flow_qb_saved_query for sspadafo
Rem       msewtz   02/03/2005 - Added print_url_label to wwv_flow_page_plugs
Rem       cbcho    02/04/2005 - Removed retain_result, kill_job, run_complete from wwv_flow_sw_results, and added status column
Rem       sspadafo 02/06/2005 - Added escape_on_http_input and protection level columns to wwv_flow_step_items, protection_level to wwv_flow_items
Rem       sspadafo 02/06/2005 - Added protection level column to wwv_flow_steps, checksum_salt, checksum_salt_last_reset to wwv_flows
Rem       sspadafo 02/06/2005 - Removed page_is_protected_y_n from wwv_flow_steps
Rem       sspadafo 02/06/2005 - Added translate_title to wwv_flow_page_plugs
Rem       sspadafo 02/06/2005 - Added wwv_flow_computations.computation_error_message,wwv_flow_step_computations.computation_error_message to translatable cols
Rem       sspadafo 02/08/2005 - Added wwv_flow.page_protection_enabled_y_n for URL tampering feature
Rem       sspadafo 02/08/2005 - Added check constraint on wwv_flow.page_protection_enabled_y_n
Rem       cbcho    02/11/2005 - Added start_time, end_time to wwv_flow_sw_results
Rem       cbcho    02/11/2005 - Added start_time, end_time, seq_id, file_id to wwv_flow_sw_detail_results
Rem       jkallman 02/14/2005 - Add additional PICK_DATE values to constraint wwv_valid_fsitem_displayas on wwv_flow_step_items
Rem       jkallman 02/16/2005 - Add additional PICK_DATE values to constraints on  wwv_flow_hnt_column_info
Rem       jkallman 02/17/2005 - Correct typo in check constraint for DD_MM_YYYY_HH24_MI_DASH
Rem       cbcho    02/18/2005 - Removed DDL for wwv_flow_sw_statements table (by sspadafo)
Rem       sspadafo 02/19/2005 - Change wwv_flow_page_plugs.translate_title column to template_translatable
Rem       jkallman 02/21/2005 - Add wwv_flow_sw_stmts, wwv_flow_sw_main_keywords, wwv_flow_sw_set_keywords, wwv_flow_sw_create_keywords
Rem       jkallman 02/21/2005 - Set template_translatable = 'Y' for wwv_flow_page_plugs.plug_name in translatable columns
Rem       jkallman 02/22/2005 - Change wwv_flow_page_plugs.template_translatable back to translate_title
Rem       jkallman 02/22/2005 - Add additional date picker types to constraint wwv_flow_region_report_column.wwv_regrepcol_display_as
Rem       msewtz   02/23/2005 - Added column_link_checksum_type to wwv_flow_region_report_column
Rem       sspadafo 02/24/2005 - Added CLOSE_WINDOW to wwv_flow_step_processing check constraint
Rem       cjones   02/25/2005 - Add isrunnable column for script parsing
Rem       sspadafo 02/27/2005 - Remove template_translatable column from wwv_flow_page_plugs
Rem       sspadafo 03/05/2005 - Add 'CANCELING' to check constraint on wwv_flow_sw_results (cbcho)
Rem       sspadafo 03/05/2005 - Added wwv_flow_models, wwv_flow_model_pages, wwv_flow_model_page_cols (msewtz)
Rem       sspadafo 03/05/2005 - Added allow_plsql_editing column to wwv_flow_companies
Rem       sspadafo 03/08/2005 - Add item_filter column to wwv_flow_data
Rem       sspadafo 03/18/2005 - Added '999G999G999G999G990D0000' to view wwv_flow_format_masks
Rem       skutz    03/23/2005 - Added table wwv_flow_sc_trans
Rem       cjones   04/01/2005 - Allow COMMIT and ROLLBACK in scripts
Rem       sspadafo 04/05/2005 - Revised wwv_flow_models, wwv_flow_model_pages, wwv_flow_model_page_cols (msewtz)
Rem       jkallman 04/20/2005 - Modify view wwv_flow_collections to remove user_id from the predicate (Bug 4316237)
Rem       jkallman 04/20/2005 - Modify model pages for MSewtz
Rem       msewtz   04/27/2004 - modified model_page_cols, constraint wwv_flow_mpc_alignment: alignment in 'LEFT','CENTER','RIGHT'
Rem       cbcho    05/03/2005 - Added result_size to wwv_flow_sw_detail_results
Rem       cbcho    05/05/2005 - Added wwv_flow_sw_d_result_idx3 index to wwv_flow_sw_detail_results
Rem       cbcho    05/05/2005 - Added wwv_flow_sw_stmts_idx3 index to wwv_flow_sw_stmts
Rem       cbcho    05/05/2005 - Added wwv_flow_sw_result_idx3 to wwv_flow_sw_results
Rem       msewtz   05/06/2005 - added plug_query_max_columns to wwv_flow_page_plugs
Rem       sspadafo 05/06/2005 - Added check constraints to wwv_flow_qb_saved_cond out,st,grp columns for SKutz
Rem       cbcho    05/11/2005 - Changed wwv_flow_sw_stmts_idx3 to include stmt_id in the index
Rem       jkallman 05/12/2005 - Add wwv_flow_languages.nls_windows_charset
Rem       jkallman 05/12/2005 - Add wwv_flows.csv_encoding
Rem       sspadafo 05/17/2005 - Added SINCE to view wwv_flow_format_masks
Rem       msewtz   05/19/2005 - Modified create wwv_flow_models, made security group ID FK instead of session, replaces session index with security group id index
Rem       jkallman 05/31/2005 - Added index wwv_flow_list_items_idx1
Rem       jkallman 06/05/2005 - Added index wwv_flow_list_items_idx2
Rem       jkallman 06/22/2005 - Added index wwv_flow_qb_saved_query_uk
Rem       sspadafo 07/10/2005 - Removed table wwv_flow_restrict_admin, add tables wwv_flow_restricted_schemas, wwv_flow_rschema_exceptions (Bug 4296276)
Rem       sspadafo 07/19/2005 - Changed datatype of wwv_flow_page_plugs.required_patch from varchar2(255) to number (Bug 4499768)
Rem       jkallman 08/19/2005 - Add index wwv_flow_template_idx3
Rem       jkallman 12/03/2005 - Remove tables wwv_flow_rt_distributions$, wwv_flow_rt_requests$, wwv_flow_rt_downloads$
Rem       jkallman 12/09/2005 - Implement rotating logs for clickthru_log (Bug 4861215)
Rem       madelfio 01/23/2006 - Added tables associated with install wizard (wwv_flow_install_*)
Rem       jkallman 01/26/2006 - Add mail_reply to wwv_flow_mail_queue
Rem       madelfio 01/26/2006 - Modified wwv_flow_install for config message, install trigger conditions, and build options change.
Rem       madelfio 01/30/2006 - Combined indexes on wwv_flow_install_scripts and wwv_flow_install_checks
Rem       madelfio 02/06/2006 - Added build_options_message to wwv_flow_install
Rem       madelfio 02/09/2006 - Added required_free_kb, required_sys_privs, and required_names_available to wwv_flow_install
Rem       jkallman 02/15/2006 - Change mail_reply to varchar2 in wwv_flow_mail tables and views, add mail_send_error and mail_send_count
Rem       jkallman 02/22/2006 - Add US-ASCII to wwv_flow_charsets (Bug 4922076)
Rem       mhichwa  03/07/2006 - add LAST_LOGIN, BUILDER_LOGIN_COUNT, LAST_AGENT, LAST_IP columns to WWV_FLOW_FND_USER
Rem       mhichwa  03/07/2006 - add LAST_LOGIN column to WWV_FLOW_COMPANIES
Rem       mhichwa  04/06/2006 - Added wwv_flow_debug table and index
Rem       mhichwa  04/14/2006 - Added wwv_flow_app_comments table and index
Rem       jkallman 04/25/2006 - Add wwv_flow_builder_audit_trail and triggers from original audit.sql (Bug 5070914)
Rem       cbcho    05/18/2006 - Changed wwv_flow_templates_used to include default_page_template from wwv_flows (Bug 5192856)
Rem       mhichwa  06/01/2006 - Added sqlerrm column to wwv_flow_activity_log1$ and 2 and view.
Rem       mhichwa  06/05/2006 - Added calendar_icon and calendar_icon_attr columns to wwv_flow_themes table
Rem       mhichwa  06/06/2006 - Added sqlerrm_component_type and sqlerrm_component_name column
Rem       jkallman 06/09/2006 - Added sqlerrm_component_type and sqlerrm_component_name to wwv_flow_user_activity_log
Rem       mhichwa  06/12/2006 - Added page caching columns to wwv_flow_steps table, added wwv_flow_page_cache table
Rem       mhichwa  06/12/2006 - Added created_on and created_by to wwv_flow_steps to track page creation date
Rem       mhichwa  06/13/2006 - Added foreign key to delete cascade application page cache on removal of application
Rem       mhichwa  06/14/2006 - Added page_mode column to wwv_flow_activity_log1$ and 2$ tables, added column to activity log view
Rem       sbkenned 06/19/2006 - Added wwv_flow_site_map view to facilitate the creation of site maps for applications
Rem       msewtz   06/20/2006 - removed wwv_flow_application_tab and wwv_flow_application_tab_set (bug 5231754)
Rem       sbkenned 06/21/2006 - modified wwv_flow_site_map to include flow_id
Rem       sbkenned 06/21/2006 - added new views to expose application attributes outside of tool, but only within FLOWS user
Rem                           - wwv_flow_applications, wwv_flow_application_pages, wwv_flow_app_page_items, wwv_flow_app_page_regions, wwv_flow_app_page_processes
Rem       mhichwa  06/22/2006 - Added use_custom_item_layout, custom_item_layout columns to wwv_flow_page_plugs
Rem       mhichwa  06/22/2006 - Moved apex views added by sharon on 6/21 and 6/22 to new apex_views file
Rem       msewtz   06/29/2006 - added wwv_flow_model_page_cols.column_sequence (bug 5363758)
Rem       jkallman 08/23/2006 - Corrected page_id column of wwv_flow_translatable_columns for post element text (Bug 5485723)
Rem       jkallman 08/23/2006 - Added grant of delete on wwv_flow_user_mail_queue (Bug 5485866)
Rem       jkallman 08/23/2006 - Added indexes on wwv_flow_mail_queue and wwv_flow_mail_log (Bug 5453208)
Rem       mhichwa  11/03/2006 - added tables to store images, css, and js examples
Rem       mhichwa  11/06/2006 - Added wwv_flow_app_build_pref table
Rem       mhichwa  11/06/2006 - Added language columns to wwv_flow_app_build_pref
Rem       mhichwa  11/08/2006 - Changed csv_output_link_text from a varchar2(255) to a varchar2(4000)
Rem       mhichwa  11/08/2006 - added region_name varchar2(255) to wwv_flow_page plugs
Rem       msewtz   11/28/2006 - added PDF attributes to wwv_flow_page_plugs
Rem       sspadafo 11/30/2006 - Added views wwv_flow_list_of_values_data_v,wwv_flow_lists_of_values$_v (Bug 5597257)
Rem       sspadafo 11/30/2006 - Added access log tables, views
Rem       sspadafo 11/30/2006 - Added new columns to wwv_flow_fnd_user and wwv_flow_companies for new security features
Rem       cbcho    12/04/2006 - Added POPUP_COLOR as wwv_valid_fsitem_displayas check constraint value
Rem       cbcho    12/04/2006 - Added popup_icon2, popup_icon_attr2 to wwv_flow_popup_lov_template
Rem       cbcho    12/05/2006 - Added wwv_flow_flash_charts, wwv_flow_flash_chart_series tables
Rem       sathikum 12/06/2006 - Added fields to wwv_flow_cal_templates for Daily & Weekly Calendar
Rem       msewtz   12/08/2006 - Added wwv_flow_print_templates
Rem       msewtz   12/11/2006 - Changed wwv_flow_print_templates, removed one column, changed one column name
Rem       mhichwa  12/11/2006 - Added shared_query_id column to wwv_flow_page plugs to support shared queries shared component
Rem       mhichwa  12/12/2006 - added wwv_flow_print_templates and wwv_flow_shared_queries tables
Rem       jkallman 12/12/2006 - Correct syntax errors in plug_prn_format check constraint
Rem       mhichwa  12/12/2006 - Changed lob storage for wwv_flow_page_cache, per tkyte recommendation, doc says it works in 9.2
Rem       mhichwa  12/13/2006 - Enabled additional inline lob storage to avoid phyical reads per each access
Rem       jstraub  12/13/2006 - Added 'A' to check constraint on wwv_flow_ws_parameters
Rem       msewtz   12/13/2006 - Renamed wwv_flow_print_templates to wwv_flow_report_layouts
Rem       jstraub  12/13/2006 - Added wallet_path and wallet_pwd to wwv_flows for SSL (HTTPS) support
Rem       msewtz   12/13/2006 - Added new standard icons
Rem       mhichwa  12/14/2006 - added get_version_sql_query column to support wwv_flow_install table to determine if upgrade needed
Rem       mhichwa  12/14/2006 - added script_type to wwv_flow_install_scripts to track if script type
Rem       mhichwa  12/14/2006 - Added index wwv_flow_page_cache_idx2
Rem       mhichwa  12/14/2006 - Added lob (page_text) store as (cache enable storage in row) to page cache table
Rem       mhichwa  12/14/2006 - Changed page cache table to not have unique indexes to support caching by user
Rem       mhichwa  12/21/2006 - Added plug_cache_when, plug_cache_expression1, plug_cache_expression2 columns
Rem       mhichwa  12/22/2006 - Indexed unindexed foreign keys for flash charts and sc trans table
Rem       mhichwa  12/29/2006 - added run_process_by_mode column to wwv_flow_page_processing in support of paetec
Rem       mhichwa  12/29/2006 - removed run_process_by_mode
Rem       mhichwa  01/02/2007 - Added pre_element_text column to wwv_flow_step_items table
Rem       mhichwa  01/02/2007 - Added cached_regions column to activity logs to track regions rendered from cache by page view
Rem       msewtz   01/02/2007 - Added include_in_export, print width and print align to wwv_flow_region_report_column
Rem       msewtz   01/03/2007 - Added prn_output_file_name to wwv_flow_page_plugs
Rem       cbcho    01/03/2007 - Changed wwv_flow_flash_charts ddl
Rem       mhichwa  01/03/2007 - Added remote_addr column to sessions table
Rem       jstraub  01/03/2007 - Removed wallet columns from wwv_flows, moved to platform preference
Rem       cbcho    01/04/2007 - Added gradient_rotation,names_rotation,values_rotation cols to wwv_flow_flash_charts
Rem       mhichwa  01/05/2007 - Added pre element text as a translatable text column (126)
Rem       cbcho    01/05/2007 - Changed wwv_flow_flash_chart_series.series_query varchar2(4000) to clob
Rem       mhichwa  01/05/2007 - Changed index: create index wwv_flow_page_cache_idx2 to put region id on leading edge
Rem       nagkrish 01/08/2007 - Added two new tables wwv_flow_random_images and wwv_flow_request_verifications
Rem       rvallam  01/08/2007 - Added a new value 'SHUTTLE' to constraint wwv_valid_fsitem_displayas in wwv_flow_step_items
Rem       ashiverm 01/09/2007 - Added new values 'TEXTAREA_WITH_HTML_EDITOR_BASIC' and 'TEXTAREA_WITH_HTML_EDITOR_STANDARD' to constraints
Rem                           - wwv_valid_fsitem_displayas in wwv_flow_step_items, wwv_fhc_display_as_form in wwv_flow_hnt_column_info,
Rem                           - wwv_flow_hnt_display_as_form in wwv_flow_hnt_argument_info, and wwv_mpc_display_as_form in wwv_flow_model_page_cols
Rem       cbcho    01/09/2007 - Added attribute_01 - 05 to wwv_flow_flash_charts
Rem       msewtz   01/10/2007 - Added 32x32 standard icons
Rem       cbcho    01/10/2007 - Added prefix,postfix,decimal_sep,group_sep,decimal_place for x and y axis to wwv_flow_flash_charts
Rem       mhichwa  01/11/2007 - Added chart_region_id
Rem       jkallman 01/11/2007 - Remove extraneous newline in wwv_flow_request_verifications
Rem       sathikum 01/12/2007 - Added fields to wwv_flow_cals to support weekly & Daily Calendar
Rem       cbcho    01/16/2007 - Removed series_color,series_chart_type,display_attr from wwv_flow_flash_chart_series
Rem       msewtz   01/16/2007 - Added columns to wwv_flow_shared_queries
Rem       jkallman 01/17/2007 - Correct formatting errors, correct issues with wwv_flow_standard_css, wwv_flow_standard_icons, and wwv_flow_standard_js
Rem       madelfio 01/17/2007 - Added columns to wwv_flow_install for upgrade messages
Rem       cbcho    01/18/2007 - Added wwv_flow_flash_chart,wwv_flow_flash_chart_series to translatable columns
Rem       cbcho    01/18/2007 - Added flow_id to wwv_flow_flash_chart_series
Rem       cbcho    01/18/2007 - Added wwv_flow_fl_ch_idx and wwv_flow_fl_ch_sr_idx in wwv_flow_flash_charts and wwv_flow_flash_chart_series
Rem       jstraub  01/22/2007 - Added date_type_column to wwv_flow_cals
Rem       jkallman 01/23/2007 - Move insert statements to apex_install_data.sql
Rem       cbcho    01/23/2007 - Added wwv_flow_flash_charts_fk2 to wwv_flow_flash_charts and removed x_axis_decimal_sep, y_axis_decimal_sep
Rem       cbcho    01/25/2007 - Changed wwv_flow_flash_chart_series to make series_query_parse_opt nullable
Rem       msewtz   01/25/2007 - Added xml_structure to wwv_flow_shared_queries
Rem       madelfio 01/25/2007 - Added script_type column to the unique index on wwv_flow_install_scripts
Rem       jkallman 01/26/2007 - Added PICK_DATE_USING_FORMAT_MASK
Rem       sspadafo 01/27/2007 - Fixed views wwv_flow_list_of_values_data_v,wwv_flow_lists_of_values$_v (Bug 5597257)
Rem       jkallman 01/28/2007 - Correct views wwv_flow_list_of_values_data_v,wwv_flow_lists_of_values$_v
Rem       sspadafo 01/28/2007 - Fix bug in view wwv_flow_lists_of_values$_v
Rem       msewtz   02/01/2007 - Added columns for print header and footer alignment and border color to page_plugs
Rem       cbcho    02/02/2007 - Added columns dial_tick_attr,margins,grid_spacing,grid_labels_font,chart_title_font to wwv_flow_flash_charts
Rem       cbcho    02/02/2007 - Added columns x_axis_grid_spacing,y_axis_grid_spacing,omit_label_interval to wwv_flow_flash_charts
Rem       mhichwa  02/02/2007 - Added sort_null column
Rem       jstraub  02/05/2007 - Added daily_month_title_format to wwv_flow_cal_templates
Rem       sspadafo 02/09/2007 - Added and security_group_id <> 0 to wwv_flow_files view
Rem       jkallman 02/20/2007 - Reduce size of index wwv_flow_mail_log_idx1 (to avoid ORA-01450 on small db block size dbs)
Rem       sspadafo 02/23/2007 - Added web_password2 to wwv_flow_fnd_user (Bugs 5613085,5597269)
Rem       jstraub  03/07/2007 - Added wwv_flow_upgrade_progress
Rem       sspadafo 04/27/2007 - Fixed view wwv_flow_templates_used (Bug 5979712)
Rem       jstraub  05/03/2007 - Replaced stand-alone flow_id indexes for wwv_flow_*_templates with index on security_group_id, reference_id (Bug 6031972)
Rem       jstraub  05/03/2007 - Fixed index on wwv_flow_popup_lov_template
Rem       jkallman 05/29/2007 - Reduce size of indexes wwv_flow_mail_log_idx1 and wwv_flow_report_layouts_idx2 (Bug 6066919)
Rem       sspadafo 06/01/2007 - Fixed view wwv_flow_templates_used to work around optimizer bug (base bugs 4533352 and 5979712, new bug filed:6087758)
Rem       madelfio 08/13/2007 - Merged all create table statements from worksheet_tab.sql
Rem       jstraub  08/23/2007 - Added wwv_flow_worksheet_categories and category_id to wwv_flow_worksheet_rpts
Rem       jstraub  08/23/2007 - Added display_sequence to wwv_flow_worksheet_categories
Rem       jstraub  08/24/2007 - Removed session_id from wwv_flow_worksheet_categories
Rem       madelfio 09/05/2007 - Added search_string to wwv_flow_worksheet_rpts
Rem       madelfio 09/05/2007 - Added detail_link to wwv_flow_worksheets
Rem       madelfio 09/07/2007 - Updated wwv_flow_worksheet_conditions to support text search conditions
Rem       madelfio 09/12/2007 - Added autosave column and increased length of break_on in wwv_flow_worksheet_rpts
Rem       madelfio 09/12/2007 - Added alias column to wwv_flow_worksheets
Rem       madelfio 09/17/2007 - Added report_list_mode to wwv_flow_worksheets
Rem       madelfio 09/18/2007 - Changed condition_text to condition_sql in wwv_flow_worksheets
Rem       madelfio 09/24/2007 - Added flashback columns to worksheet_rpts and configuration option columns to wwv_flow_worksheets
Rem       madelfio 09/27/2007 - Updated worksheet tables to support SQL queries and disabling breaks
Rem       madelfio 10/02/2007 - Added preference columns to wwv_flow_worksheets
Rem       jkallman 10/02/2007 - Convert LONG columns to CLOB in wwv_flow_data and wwv_flow_banner
Rem       madelfio 10/02/2007 - Added report_type, additional aggregation columns to wwv_flow_worksheet_rpts
Rem       madelfio 10/03/2007 - Added new worksheet columns, wwv_flow_worksheet_computation table for computed columns
Rem       madelfio 10/04/2007 - Added flow_id, page_id, and region_id to relevant worksheet tables
Rem       jkallman 10/04/2007 - Added table wwv_flow_mail_attachments, view wwv_flow_user_mail_attachments
Rem       jkallman 10/08/2007 - Add column inline to wwv_flow_mail_attachments
Rem       jstraub  10/09/2007 - Added foreign key constraint on wwv_flow_worksheets(region_id) to wwv_flow_page_plugs
Rem       madelfio 10/09/2007 - Added description column to wwv_flow_worksheet_rpts
Rem       madelfio 10/09/2007 - Added download_formats column to wwv_flow_worksheets
Rem       madelfio 10/09/2007 - Added repeat_control_break_headers column to wwv_flow_worksheets
Rem       madelfio 10/11/2007 - Added columns to support worksheet column links
Rem       madelfio 10/11/2007 - Fixed bad column reference in constraint on wwv_flow_worksheets.pagination_type
Rem       madelfio 10/11/2007 - Fixed creation of wwv_flow_worksheets
Rem       madelfio 10/11/2007 - Added flow_id to wwv_flow_worksheet_columns and wwv_flow_worksheet_col_groups
Rem       jstraub  10/11/2007 - Added wwv_flow_worksheet_lov_entries
Rem       madelfio 10/15/2007 - Added page_id, display_by_default columns to wwv_flow_worksheet_columns
Rem       jkallman 10/15/2007 - Added media_type column to wwv_flows and wwv_flow_steps
Rem       mhichwa  10/15/2007 - Added builder_notification_message column to wwv_flow_companies table
Rem       cbcho    10/15/2007 - Added wwv_flow_ws_exclude_null_ck,wwv_flow_ws_hide_extra_ck to wwv_flow_worksheets
Rem       mhichwa  10/16/2007 - Added ITEM_IS_NOT_NUMERIC validation type
Rem       mhichwa  10/24/2007 - Added table wwv_flow_application_groups to manage application groups
Rem       madelfio 10/26/2007 - Added columns for report sequence, permanent filters, and star schema support (for Audit Vault)
Rem       madelfio 10/26/2007 - Removed display_by_default
Rem       cbcho    10/26/2007 - Removed show_detail_link,detail_link,display_detail_location from wwv_flow_worksheets
Rem       madelfio 10/26/2007 - Changed tabs to spaces.  Added report_id_item to wwv_flow_worksheets
Rem       madelfio 10/26/2007 - Added max_row_count, max_row_count_message to wwv_flow_worksheets
Rem       cbcho    10/29/2007 - Added display_condition_type,display_condition,display_condition2,security_scheme to wwv_flow_worksheet_columns
Rem       madelfio 10/30/2007 - Removed repeat_control_break_headers from wwv_flow_worksheets
Rem       madelfio 10/30/2007 - Removed compute_sum, etc from wwv_flow_worksheet_columns
Rem       msewtz   10/31/2007 - Added report_implementation to wwv_flow_model_pages
Rem       madelfio 11/01/2007 - Made worksheet alias nullable
Rem       madelfio 11/01/2007 - Removed obsolete download_link_display_position column from wwv_flow_worksheets
Rem       madelfio 11/02/2007 - Added show_detail_link, detail_link back into wwv_flow_worksheets
Rem       madelfio 11/02/2007 - Added sql_hint to wwv_flow_worksheets
Rem       madelfio 11/02/2007 - Added no_data_found_message to wwv_flow_worksheets
Rem       madelfio 11/05/2007 - Added worksheet rpt lov columns, removed distinct_value_filter
Rem       sathikum 11/06/2007 - Added calendar_type column to wwv_flow_cals
Rem       mhichwa  11/07/2007 - Added not null sgid for wwv_flow_templates, wwv_flow_cal_templates, wwv_flow_jobs, wwv_flow_page_submissions
Rem       mhichwa  11/07/2007 - Added not null sgid for wwv_flow_shared_queries, wwv_flow_shortcuts, wwv_flow_mail_log, wwv_flow_mail_queue_pk
Rem       mhichwa  11/07/2007 - Added not null sgid for wwv_flow_clickthru_log$, wwv_flow_clickthru_log2$, wwv_flow_popup_lov_template, wwv_flow_app_build_pref
Rem       mhichwa  11/07/2007 - Changed view wwv_flow_plsql_jobs to select sgid from sys.dual, and to use a nv, numeric value, and not a v varchar value.
Rem       mhichwa  11/07/2007 - Changed view wwv_flow_collections to reference flow_id session state using the nv function and not v function
Rem       mhichwa  11/07/2007 - Changed view wwv_flow_clickthru_log to select sgid from sys.dual and not directly reference plsql function
Rem       jkallman 11/19/2007 - Added date_format to wwv_flows
Rem       jkallman 11/20/2007 - Added PICK_DATE_USING_APP_DATE_FORMAT to all display_as check constraints
Rem       msewtz   11/21/2007 - Added table wwv_flow_shared_qry_sql_stmts
Rem       mhichwa  11/26/2007 - Added include_apex_css_js_yn column to wwv_flow_steps table
Rem       jstraub  11/28/2007 - Added heading_alignment, column_alignment, display_text_as, rpt_show_filter_lov, rpt_filter_date_ranges, is_sortable to wwv_flow_worksheet_columns
Rem       jstraub  11/28/2007 - Added is_default to wwv_flow_worksheet_rpts
Rem       mhichwa  11/28/2007 - Added theme_description, theme_image, theme_security_group_id
Rem       hfarrell 11/28/2007 - Updated constraint wwv_flow_mp_page_type on wwv_flow_model_pages to include MASTERDETAIL page_type
Rem       mhichwa  11/28/2007 - Added runtime_where_clause column
Rem       jkallman 11/28/2007 - Added ISO number masks to wwv_flow_format_masks (Bug 5142796)
Rem       jkallman 11/28/2007 - Added date_format column to wwv_flow_app_build_pref
Rem       madelfio 11/28/2007 - Updated wwv_flow_worksheet_col_grps_fk to set null on delete
Rem       mhichwa  11/29/2007 - Added runtime_where_clause column to wwv_flow_processing table
Rem       sspadafo 11/30/2007 - Added ajax_pagination column to wwv_flow_page_plugs
Rem       sspadafo 11/30/2007 - Changed ajax_pagination column in wwv_flow_page_plugs to ajax_enabled
Rem       sspadafo 12/01/2007 - Added 'HIDDEN_PROTECTED' wherever 'HIDDEN' occurred, except for check constraint on wwv_flow_region_upd_rpt_cols
Rem       sspadafo 12/01/2007 - Removed extra occurrence of 'HIDDEN' from several check constraints where it was listed twice
Rem       mhichwa  12/03/2007 - Added before_column_heading and after_column_heading columns to support scrollable fixed header templates
Rem       mhichwa  12/04/2007 - Added insert into wwv_flow_companies 3,11,REPOSITORY
Rem       mhichwa  12/04/2007 - Added theme_image_mime_type and  custom_image column to wwv_flow_themes table
Rem       msewtz   12/06/2007 - Added XML as option to constraint on wwv_flow_page_plugs.plug_prn_format
Rem       cbcho    12/07/2007 - Changed wwv_flow_ws_col_disp_txt_as_ck in wwv_flow_worksheet_columns table
Rem       msewtz   12/09/2007 - Added prn_print_server_overwrite to wwv_flow_page_plugs
Rem       hfarrell 12/10/2007 - Added wwv_flow_model_page_regions table and modified wwv_flow_model_pages and wwv_flow_model_page_cols tables
Rem       hfarrell 12/10/2007 - Removed check constraint wwv_flow_mpr_source from wwv_flow_model_page_regions.region_source column
Rem       madelfio 12/10/2007 - Updated check constraints on wwv_flow_worksheet.show_detail_link and wwv_flow_worksheet_columns.display_text_as
Rem       madelfio 12/10/2007 - Added columns in wwv_flow_worksheets, wwv_flow_worksheet_columns, and wwv_flow_worksheet_rpts
Rem       madelfio 12/11/2007 - Added region_attributes_substitution to wwv_flow_page_plugs for mhichwa
Rem       madelfio 12/11/2007 - Added show_help to wwv_flow_worksheets
Rem       mhichwa  12/11/2007 - Added std_rpt_max_query_cost to wwv_flow_page_plugs
Rem       madelfio 12/11/2007 - Added chart_value_column, chart_value_label to wwv_flow_worksheet_rpts
Rem       msewtz   12/12/2007 - Added prn_content_disposition, prn_document_header, prn_width_units to wwv_flow_page_plugs
Rem       msewtz   12/12/2007 - Added content_disposition, document_header to wwv_flow_shared_queries
Rem       hfarrell 12/13/2007 - Removed extra line from wwv_flow_model_page_regions table ddl
Rem       mhichwa  12/13/2007 - Added check constraint RIGHT_OF_IR_SEARCH_BAR
Rem       mhichwa  12/13/2007 - Added report_attributes_substitution
Rem       madelfio 12/14/2007 - Added show_control_break to wwv_flow_worksheets
Rem       msewtz   12/17/2007 - Added XML as option to constraint wwv_flow_shared_qry_format
Rem       madelfio 12/17/2007 - Added columns to wwv_flow_worksheets, modified flow_id in worksheet_rpts to be not null
Rem       madelfio 12/18/2007 - Updated wwv_flow_wscol_showfil_lov_ck constraint
Rem       madelfio 12/18/2007 - Added to wwv_flow_worksheets: show_nulls_as, download_filename
Rem       madelfio 12/18/2007 - Added to wwv_flow_worksheet_columns: column_comment
Rem       madelfio 12/20/2007 - Changed wwv_flow_worksheet_computation.format_mask to varchar2
Rem       madelfio 12/20/2007 - Added flow_id, page_id to worksheet_conditions, worksheet_computations
Rem       hfarrell 01/02/2008 - Added 'HIDDEN_PROTECTED' wherever 'HIDDEN' occurred in the wwv_flow_model_page_cols model table
Rem       madelfio 01/08/2008 - Added count_columns_on_break to wwv_flow_worksheet_rpts
Rem       madelfio 01/10/2008 - Changed length of column_identifier for standard and computed IR columns
Rem       madelfio 01/13/2008 - Added missing foreign key indexes for worksheet tables
Rem       hfarrell 01/16/2008 - Updated DATATYPE check constraint on wwv_flow_model_page_cols to include BLOB
Rem       jstraub  01/18/2008 - Updated wwv_flow_worksheet_categories, added flow_id, changed foreign key reference to security_group_id not worksheet_id
Rem       sspadafo 01/22/2008 - Fixed view wwv_flow_user_access_log to check for zero security_group_id (Bug 6454065)
Rem       madelfio 01/23/2008 - Added chart_sorting to wwv_flow_worksheet_rpts
Rem       madelfio 01/24/2008 - Added pagination_min_row to wwv_flow_worksheet_rpts
Rem       madelfio 01/24/2008 - Added 'CLOB', 'OTHER' to interactive report column_type check
Rem       madelfio 01/26/2008 - Altered unique constraint on wwv_flow_worksheet_conditions to support translating filter names
Rem       madelfio 01/26/2008 - Added page_id to worksheets index, to speed up reset pagination query.
Rem       hfarrell 01/31/2008 - Updated DATATYPE check constraint on wwv_flow_model_page_cols to include CLOB
Rem       jkallman 01/31/2008 - Corrected index wwv_flow_worksheet_cond_uk2
Rem       jkallman 02/11/2008 - Rename workspace name for SGID=11 to COM.ORACLE.APEX.REPOSITORY
Rem       madelfio 02/12/2008 - Added to wwv_flow_worksheet_computation: column_type
Rem       madelfio 02/18/2008 - Updated unique index wwv_flow_worksheet_cond_uk2 to fix bug 6827883
Rem       madelfio 02/21/2008 - Updated unique index wwv_flow_worksheet_cond_uk2 to avoid key length error
Rem       jkallman 02/25/2008 - Corrected wwv_flow_worksheet_cond_uk2
Rem       madelfio 02/26/2008 - Added not null constraint on wwv_flow_worksheet_rpts.page_id
Rem       madelfio 05/21/2008 - Added foreign key on wwv_flow_worksheet_rpts.security_group_id (bug 7115813)
Rem       madelfio 05/28/2008 - Added columns for websheets
Rem       msewtz   06/17/2008 - Updated FK definition for wwv_flow_worksheet_tags, corrected typo in foreign_key
Rem       cbcho    06/24/2008 - Added project_id to wwv_flow_worksheets
Rem       jstraub  07/01/2008 - Added workgroup and websheet tables
Rem       jstraub  07/09/2008 - Moved Websheet tables after worksheet tables due to references from websheets to worksheets
Rem       jkallman 07/09/2008 - Move creation of wwv_flow_ws_projects before wwv_flow_worksheets
Rem       cbcho    07/10/2008 - Removed project_id from wwv_flow_worksheets.  It is saved in wwv_flow_ws_websheet_attr.
Rem       mhichwa  07/23/2008 - Added workgroup level docs, stickies, and links tables
Rem       mhichwa  07/23/2008 - Changed names of tables to use proper ws_proj prefix
Rem       mhichwa  07/23/2008 - Removed ws_proj tables and created wwv_flow_ws_notes, wwv_flow_ws_files, and wwv_flow_ws_links
Rem       mhichwa  07/25/2008 - Added websheet_owner column to WWV_FLOW_WS_WEBSHEET_ATTR
Rem       cbcho    07/25/2008 - Corrected mis-spelled display_sequnece to display_sequence in wwv_flow_ws_links
Rem       cbcho    07/28/2008 - Added wwv_flow_ws_tags
Rem       cbcho    07/29/2008 - Changed wwv_flow_ws_col_validations to save error_message
Rem       cbcho    08/04/2008 - Removed tags from wwv_flow_worksheet_rows
Rem       cbcho    08/04/2008 - Removed wwv_flow_worksheet_stick,wwv_flow_worksheet_links,wwv_flow_worksheet_docs,wwv_flow_worksheet_tags
Rem       cbcho    08/04/2008 - Removed document column from wwv_flow_worksheet_rows, moved last 9 column up before c001 for more efficient block management
Rem       cbcho    08/05/2008 - Added websheet_id to wwv_flow_worksheet_columns,wwv_flow_worksheet_col_groups,wwv_flow_worksheet_rpts,wwv_flow_worksheet_conditions,wwv_flow_worksheet_computation
Rem       jstraub  08/05/2008 - Removed wwv_flow_worksheet_privs
Rem       cbcho    08/06/2008 - Added FK to wwv_flow_worksheet_history on worksheet_id column
Rem       jstraub  08/06/2008 - Removed security_group_id columns from wwv_flow_worksheet_history, wwv_flow_worksheet_lov, wwv_flow_worksheet_lov_entries, and wwv_flow_worksheet_rows
Rem       cbcho    08/08/2008 - Added back tags column to wwv_flow_worksheet_rows
Rem       cbcho    08/08/2008 - Added is_template column to wwv_flow_ws_websheet_attr
Rem       mhichwa  08/11/2008 - Added icon_view_ columns to wwv_flow_worksheets
Rem       jstraub  08/13/2008 - Added geo coding columns to wwv_flow_ws_websheet_attr
Rem       mhichwa  08/13/2008 - Added view_mode column to WWV_FLOW_WORKSHEET_RPTS table to store IR view preference, icon or report
Rem       mhichwa  08/13/2008 - Removed column icon_view_div_attr and replaced with icon_view_columns_per_row in WWV_FLOW_WORKSHEETS table
Rem       mhichwa  08/15/2008 - Added detail_view_enabled_yn, detail_view_before_rows, detail_view_for_each_row, detail_view_after_rows cols to worksheet table
Rem       mhichwa  08/15/2008 - Changed check constraint wwv_flow_ws_rpt_vm_ck to 'REPORT','ICON','DETAIL'
Rem       cbcho    08/18/2008 - Added wwv_flow_ws_notify, wwv_flow_ws_notify_todo
Rem       mhichwa  08/25/2008 - Added created_on and created_by columns to a large number of tables for consistency, issued alter commands
Rem       cbcho    08/28/2008 - Added start_date,end_date to wwv_flow_ws_notify.  Added next_date to wwv_flow_ws_notify_todo.
Rem       mhichwa  09/09/2008 - Added dynamic actions table
Rem       mhichwa  09/12/2008 - Added 'IN_LIST','NOT_IN_LIST'
Rem       jkallman 09/15/2008 - Remove extra blank line from wwv_flow_worksheets, introduced by detail_view* columns above, failed to compile.
Rem                             Move wwv_flow_ws_websheet_attr earlier in file (referenced in foreign key constraints)
Rem       cbcho    09/16/2008 - Removed wwv_flow_ws_notify_todo, changed date columns in wwv_flow_ws_notify to timestamp with local time zone
Rem       cbcho    09/16/2008 - Changed wwv_flow_ws_notify offset_date to timestamp with time zone
Rem       cbcho    09/17/2008 - Added websheet_name and wwv_flow_ws_attr_unq_idx to wwv_flow_ws_websheet_attr, Removed wwv_flow_worksheets_unq_idx from wwv_flow_worksheets
Rem       cbcho    09/19/2008 - Changed wwv_flow_ws_notify check contraint
Rem       jkallman 10/03/2008 - Remove column report_display_mode from wwv_flow_worksheet_rpts
Rem       cbcho    10/06/2008 - Added show_group_by to wwv_flow_worksheets, added allow_group_by to wwv_flow_worksheet_columns, added group by columns to wwv_flow_worksheet_rpts
Rem       cbcho    10/09/2008 - Added is_group_by_computation to wwv_flow_worksheet_computation, added is_group_by_report to wwv_flow_worksheet_rpts
Rem       mhichwa  10/10/2008 - Added quick pick label and value columns
Rem       mhichwa  10/10/2008 - Added 'SELECT_LIST_WITH_POPUP','TEXT_WITH_SELECT_LIST','TEXTAREA_WITH_POPUP'
Rem       jkallman 10/11/2008 - Added additional indexes on wwv_flow_activity_log1$ and wwv_flow_activity_log2$
Rem       mhichwa  10/13/2008 - Added additional columns to dynamic actions table ACTION_02 .. 08
Rem       cbcho    10/17/2008 - Added wwv_flow_worksheet_group_by
Rem       cbcho    10/17/2008 - Removed group by columns from wwv_flow_worksheet_rpts,wwv_flow_worksheet_computation
Rem       mhichwa  11/14/2008 - Added application_info to log tables
Rem       mhichwa  12/05/2008 - Added MAX_SESSION_LENGTH_MIN, ON_MAX_SESSION_TIMEOUT_URL, MAX_SESSION_IDLE_MIN, ON_MAX_IDLE_TIMEOUT_URL columns
Rem       mhichwa  12/16/2008 - Added autocomplete_on_off, now with proper spelling
Rem       mhichwa  12/18/2008 - Added publish_yn column to wwv_flows to allow an application to be published to the my applications page
Rem       mhichwa  12/22/2008 - changed column name to MAX_SESSION_LENGTH_SEC from _MIN same with IDLE
Rem       mhichwa  12/23/2008 - Added encrypt_session_state_yn column to wwv_flow_step_items
Rem       mhichwa  12/23/2008 - Added is_encrypted to wwv_flow_data table
Rem       mhichwa  12/23/2008 - Extended domain of item display as types to include PASSWORD_DNSS and PASSWORD_WITH_SUBMIT_DNSS
Rem       jstraub  12/29/2008 - Added PASSWORD_DNSS and PASSWORD_WITH_SUBMIT_DNSS to check constraints wwv_fhc_display_as_form and wwv_mpc_display_as_form
Rem       sspadafo 01/03/2009 - Added use_secure_cookie_yn and check constraint in wwv_flow_custom_auth_setups
Rem       sspadafo 01/11/2009 - Added save_state_before_branch_yn to wwv_flow_step_branches
Rem       sspadafo 01/24/2009 - Added table wwv_flow_password_history to record passwords that cannot be re-used for an account for a certain period (ported all accumulated changed from 3.2)
Rem       sspadafo 01/24/2009 - Added column last_failed_login to wwv_flow_fnd_user
Rem       sspadafo 01/28/2009 - Added column disable_browser_caching_yn to wwv_flow_steps
Rem       hfarrell 02/09/2009 - Added block_id and mig_comments to WWV_FLOW_MODEL_PAGES table for Forms Conversions 3.2 release, and report_id to WWV_FLOW_MODEL_PAGES table for Oracle Reports Conversion
Rem       pawolf   02/27/2009 - Added constraints for new item type 'TEXTAREA_RESIZABLE'
Rem       sbkenned 03/12/2009 - Modified wwv_flow_hnt_column_info check constraints to reference revised display_as_form, display_as_report, and display_as_tab_form values
Rem                             Added wwv_flow_hnt_groups table and group_id fk to wwv_flow_hnt_column_info
Rem       pawolf   03/25/2009 - Added tables for APEX Advisor
Rem       pawolf   04/03/2009 - Added tables for custom item type
Rem       arayner  04/06/2009 - Amended check constraint WWV_FLOW_PAGE_DYNACT_COND_CK, corrected spelling of GREATER_THAN and LESS_THAN check conditions
Rem       arayner  04/07/2009 - Added HIDE_AND_CLEAR as a valid value for check constraint WWV_FLOW_PAGE_DYNACT_ACT_CK
Rem       cbcho    04/08/2009 - Added is_teamspace_schema to wwv_flow_company_schemas
Rem       jstraub  04/15/2009 - Added composite index on wwv_flow_region_report_column, security_group_id,flow_id (Bug 8371342)
Rem       jkallman 04/16/2009 - Added n001 through n005, blob001 and xmltype001 to wwv_flow_collection_members$
Rem       pawolf   04/21/2009 - Modified custom item type tables
Rem       cbcho    04/23/2009 - Removed WWV_FLOW_WS_PROJECTS and all the FK to the table
Rem       cbcho    04/23/2009 - Added publish_yn to wwv_flow_ws_websheet_attr
Rem       pawolf   04/24/2009 - Added view wwv_multi_component_export
Rem       pawolf   04/28/2009 - Renamed custom item type tables to wwv_flow_plugins
Rem       pawolf   05/05/2009 - Added wwv_flow_standard_item_types
Rem       pawolf   05/06/2009 - Added wwv_flow_plugin_files
Rem       pawolf   05/07/2009 - Added file_charset to wwv_flow_plugin_files
Rem       sathikum 05/11/2009 - Added end_date_item to wwv_flow_cals
Rem       mhichwa  05/12/2009 - Added websheet_id, worksheet_id, ir_search columns to log tables
Rem       cbcho    05/12/2009 - Added websheet_id, worksheet_id, ir_search to wwv_flow_user_activity_log
Rem       pawolf   05/14/2009 - Added subscription to plugins
Rem       pawolf   05/15/2009 - Added dynamic attributes to regions
Rem       hfarrell 05/20/2009 - Added AnyChart 5 tables: wwv_flow_flash_charts_5, wwv_flow_flash_charts_5_dash, wwv_flow_flash_chart5_series
Rem       hfarrell 05/20/2009 - Updated wwv_flow_flash_charts_5, removed unrequired column y_axis_grid_spacing
Rem       pawolf   05/22/2009 - Added new columns to wwv_flow_dictionary_views
Rem       pawolf   05/25/2009 - Fixed error in wwv_flow_company_schemas
Rem       sathikum 05/28/2009 - added columns to wwv_flow_cal_templates for Custom Calendar
Rem       cbcho    05/28/2009 - Removed wwv_flow_worksheet_rows,wwv_flow_ws_notes,wwv_flow_ws_links,wwv_flow_ws_tags,wwv_flow_ws_files,wwv_flow_ws_notify,wwv_flow_worksheet_history
Rem       cbcho    05/28/2009 - Added websheet_id,security_group_id to wwv_flow_worksheet_lovs,wwv_flow_worksheet_lov_entries,wwv_flow_ws_col_validations,wwv_flow_ws_row_security
Rem       cbcho    05/28/2009 - Added wwv_flow_worksheet_notify
Rem       jkallman 06/01/2009 - Add logic to store wwv_flow_collection_members$.xmltype001 as binary if db version >= 11
Rem       pawolf   06/03/2009 - Renamed wwv_flow_plugin_attributes.attribute_level to attribute_scope
Rem       arayner  06/05/2009 - Added 3 new dynamic_action tables (wwv_flow_standard_dyn_actions, wwv_flow_page_da_events and wwv_flow_page_da_actions)
Rem       cbcho    06/08/2009 - Renamed is_teamspace_schema to is_apex$_schema
Rem       pwolf    06/08/2009 - Added action_sequence for wwv_flow_page_da_actions
Rem       jkallman 06/08/2009 - Correct evaluation of DB version for XMLType in wwv_flow_collection_members$
Rem       arayner  06/10/2009 - Added execute_on_page_init to wwv_flow_page_da_actions table
Rem       hfarrell 06/15/2009 - Added prefix and postfix columns for both axes to wwv_flow_flash_charts_5 table
Rem       hfarrell 06/15/2009 - Added values_prefix and values_postfix columns to wwv_flow_flash_charts_5 table
Rem       hfarrell 06/23/2009 - Added gauge_labels_font attribute to wwv_flow_flash_charts_5 table
Rem       arayner  06/24/2009 - Added wwv_flow_standard_dyn_act_opp table to store standard dynamic action opposite relationships
Rem       cbcho    07/10/2009 - Added show_notify to wwv_flow_worksheets, added session_id to wwv_flow_worksheet_notify
Rem       jstraub  07/14/2009 - Added path to wwv_flow_ws_parameters and FUNCTION to map_type check in wwv_flow_ws_process_parms_map
Rem       arayner  07/15/2009 - Changed wwv_flow_page_da_events.triggering_element column to be 4000 bytes
Rem       pawolf   07/15/2009 - Added help_text to wwv_flow_plugins
Rem       cbcho    07/15/2009 - Added allow_highlighting to wwv_flow_worksheet_columns
Rem       arayner  07/17/2009 - Changed some check constraints on dynamic actions tables
Rem       hfarrell 07/17/2009 - Added series_type to wwv_flow_flash_chart5_series for combination charts
Rem       pawolf   07/23/2009 - Modified constraint of wwv_flow_plugin_attributes.attribute_type
Rem       pawolf   07/24/2009 - Added new columns to wwv_flow_plugins and wwv_flow_plugin_attributes
Rem       pawolf   07/27/2009 - Added new table wwv_flow_plugin_events
Rem       cbcho    07/27/2009 - Added end_day,end_day_unit to wwv_flow_worksheet_notify
Rem       cbcho    07/27/2009 - Removed session_id from wwv_flow_worksheet_notify
Rem       jkallman 07/28/2009 - Added timestamp_format and timestamp_tz_format to wwv_flows
Rem       jkallman 07/29/2009 - Added timestamp formats to view wwv_flow_format_masks
Rem       arayner  07/30/2009 - Changed wwv_flow_page_da_events.bind_event_type constraint
Rem       mhichwa  07/31/2009 - Added create table wwv_flow_log_history
Rem       mhichwa  07/31/2009 - Added create table wwv_flow_workspace_summary
Rem       mhichwa  07/31/2009 - Added wwv_flow_developer_log
Rem       hfarrell 08/02/2009 - Added gantt_attr to wwv_flow_flash_charts_5 table for Gantt chart information
Rem       mhichwa  08/03/2009 - Added include_in_reg_disp_sel_yn
Rem       jkallman 08/04/2009 - Added ITEM_IS_TIMESTAMP to wwv_valid_fsval_valtyp constraint in wwv_flow_step_validations
Rem       pawolf   08/05/2009 - Added support for "dynamic" bind event types
Rem       jkallman 08/07/2009 - Updated DATATYPE check constraint on wwv_flow_model_page_cols to include TIMESTAMP
Rem       arayner  08/14/2009 - Added show_wait and wait_message to wwv_flow_step_buttons
Rem       arayner  08/14/2009 - Added button_show_wait and button_wait_message to wwv_flow_step_items
Rem       arayner  08/14/2009 - Changed name of wwv_flow_valid_fstepb_showwait constraint to be consistent
Rem       jkallman 08/17/2009 - Added timestamp_format, timestamp_tz_format to wwv_flow_app_build_pref
Rem       pawolf   08/18/2009 - Added columns for hierarchical regions
Rem       pawolf   08/19/2009 - Added FK constraint for item_plug_id and button_plug_id
Rem       pawolf   08/20/2009 - Changed region FK for dynamic actions
Rem       mhichwa  08/21/2009 - Extended wwv_flow_lst_curr_type_val to include page_range, so list items can be current for a page range
Rem       mhichwa  08/21/2009 - Added support for news.
Rem       mhichwa  08/24/2009 - Added support for tasks
Rem       jkallman 08/24/2009 - Added column session_time_zone to wwv_flow_sessions$
Rem       mhichwa  08/24/2009 - Added wwv_flow_tasks_idx3
Rem       mhichwa  08/25/2009 - Added events, improved tasks
Rem       mhichwa  09/26/2009 - Add links and documents for team development
Rem       mhichwa  08/26/2009 - added features
Rem       pawolf   08/26/2009 - Fixed installation issues
Rem       mhichwa  08/27/2009 - added support for bugs
Rem       mhichwa  08/27/2009 - added support for feedback
Rem       mhichwa  08/27/2009 - added allow feedback yn column
Rem       pawolf   08/28/2009 - Renamed columns_ignored_by_search to lookup_or_lov_columns
Rem       mhichwa  08/28/2009 - added impact column for bugs
Rem       jkallman 08/28/2009 - Added auto_time_zone to wwv_flows
Rem       mhichwa  08/28/2009 - added allow_app_building_yn, allow_sql_workshop_yn,  allow_websheet_dev_yn, allow_team_devopment_yn
Rem       mhichwa  08/31/2009 - added region image, region image attr to plugs, product version to tasks, app and page id to feedback
Rem       hfarrell 08/31/2009 - Added map_attr to wwv_flow_flash_charts_5 table
Rem       mhichwa  08/31/2009 - Added wwv_flow_feature_desirability view and feature_desirability column to features
Rem       mhichwa  08/31/2009 - Added parent_feature_id column
Rem       mhichwa  08/31/2009 - Added allow_app_building_yn allow_sql_workshop_yn allow_websheet_dev_yn allow_team_devopment_yn to fnd_user                varchar2(1),
Rem       mhichwa  09/01/2009 - added nav_entry_is_feedback_yn, used in conjunction with
Rem       mhichwa  09/01/2009 - added sub_image_open, sub_image_close
Rem       mhichwa  09/01/2009 - added due_date to wwv_flow_features
Rem       cbcho    09/01/2009 - added wwv_flow_ws_webpages
Rem       mhichwa  09/01/2009 - added feature progress table wwv_flow_feature_progress
Rem       pawolf   09/02/2009 - Changed wwv_flow_search_result and wwv_flow_advisor_result views
Rem       mhichwa  09/02/2009 - Added feature_id, bug_id, and task_id to feedback to track disposition of feedback.
Rem       mhichwa  09/02/2009 - Added email so feedback can be tracked from remote systems
Rem       mhichwa  09/02/2009 - Adeed table wwv_flow_feature_history
Rem       pawolf   09/03/2009 - Fixed ALLOW_FEEDBACK_YN in WWV_FLOWS
Rem       mhichwa  09/03/2009 - removed page_range condition type
Rem       mhichwa  09/03/2009 - extended view wwv_flow_feature_priorities
Rem       cbcho    09/03/2009 - Added wwv_flow_ws_applications, added ws_app_id column to wwv_flow_ws_webpages
Rem       mhichwa  09/03/2009 - Added event_id to table wwv_flow_features
Rem       cbcho    09/03/2009 - Added description to wwv_flow_ws_applications
Rem       mhichwa  09/03/2009 - Improved  wwv_flow_task_def_status_codes
Rem       cbcho    09/03/2009 - Added ws_app_id to wwv_flow_ws_websheet_attr, added parent_page_id to wwv_flow_ws_webpages
Rem       cbcho    09/04/2009 - Changed wwv_flow_ws_applications status column check constraint
Rem       mhichwa  09/05/2009 - feature enhancments
Rem       mhichwa  09/08/2009 - added support for justification column
rem       mhichwa  09/08/2009 - added tag cloud table
Rem       mhichwa  09/08/2009 - added wwv_flow_teamdev_tag_cloud, added assignee columns
Rem       cbcho    09/09/2009 - added webpage_id, datagrid_id to wwv_flow_activity_log1$ and wwv_flow_activity_log2$
Rem       mhichwa  09/09/2009 - Added home_page_id and type to wwv_flow_ws_applications
Rem       arayner  09/10/2009 - Fixed data type of home_page_type in wwv_flow_ws_applications
Rem       arayner  09/11/2009 - Fixed nav_entry_is_feedback_yn by moving it from wwv_flow_icon_bar_attributes to wwv_flow_icon_bar
Rem       mhichwa  09/11/2009 - added support for tags
Rem       pawolf   09/14/2009 - Added NATIVE plug-ins, modifications to wwv_flow_team_tags
Rem       msewtz   09/14/2009 - Added additional validation types to wwv_flow_step_validations
Rem       pawolf   09/15/2009 - Modified view wwv_flow_native_plugins
Rem       hfarrell 09/15/2009 - Added wwv_flow_flash_map_folders and wwv_flow_flash_map_files
Rem       msewtz   09/16/2009 - Added tabular_form_region_id to wwv_flow_step_validations
Rem       pawolf   09/16/2009 - Added flow_id to plugin tables
Rem       hfarrell 09/17/2009 - Updated wwv_flow_flash_map_folders and wwv_flow_flash_map_files removing change and SGID columns, not required.
Rem       pawolf   09/17/2009 - Added page level on-demand processes
Rem       jkallman 09/17/2009 - Added INITRANS & MAXTRANS to wwv_flow_data, wwv_flow_preferences$ and wwv_flow_collection_members$
Rem       mhichwa  09/17/2009 - added status columns, removed qa columns, added effort and module to features
Rem       mhichwa  09/21/2009 - Fixed team dev index create issues, also fixed ALLOW_TEAM_DEVELOPMENT_YN spelling issue
Rem       jstraub  09/21/2009 - Moved team development objects to team_tab.sql
Rem       arayner  09/22/2009 - Added wwv_flow_standard_events
Rem       msewtz   09/23/2009 - Added popupkey_lov and popupkey_query to constraint wwv_flow_region_report_column.wwv_regrepcol_display_as
Rem       pawolf   09/24/2009 - Added table wwv_flow_plugin_attr_values
Rem       mhichwa  09/25/2009 - added comments
Rem       pawolf   09/28/2009 - Added plug-in support for classic reports
Rem       msewtz   09/28/2009 - Added radiogroup_from_lov and radiogroup_from_query to constraint wwv_flow_region_report_column.wwv_regrepcol_display_as
Rem       mhichwa  09/28/2009 - Added create index idx3 to apex log
Rem       cbcho    09/28/2009 - Added websheet_type and check constraint to wwv_flow_ws_websheet_attr
Rem       cbcho    09/28/2009 - Changed home_page_type check constraint in wwv_flow_ws_applications
Rem       cbcho    09/28/2009 - Changed wwv_flow_ws_attr_unq_idx to be unique within websheet application in a workspace
Rem       cbcho    09/29/2009 - Added ws_report_owner to wwv_flow_ws_websheet_attr
Rem       cbcho    09/30/2009 - Changed wwv_flow_ws_attr_unq_idx to wwv_flow_ws_attr_unq_idx1 and made unique within security_group_id,websheet_type,ws_app_id,websheet_name
Rem       cbcho    09/30/2009 - Removed is_template from wwv_flow_ws_websheet_attr and added TEMPLATE as websheet_type check constraint
Rem       arayner  10/02/2009 - Added more action types to check contraint in wwv_flow_page_da_actions
Rem       hfarrell 10/04/2009 - Added wwv_flow_flash_map_regions for AnyChart Map region information
Rem       cbcho    10/06/2009 - Added back is_template in wwv_flow_ws_websheet_attr
Rem       hfarrell 10/06/2009 - Changed wwv_flow_flash_map_regions.fips from NUMBER to VARCHAR2 column
Rem       pawolf   10/16/2009 - Added conditions to plugin attributes
Rem       pawolf   10/20/2009 - Changed constraint for wwv_flow_hnt_column_info.display_as_form
Rem       pawolf   10/20/2009 - Added dynamic attributes to wwv_flow_hnt_column_info and wwv_flow_model_page_cols
Rem       pawolf   10/23/2009 - Added is_required to wwv_flow_step_items and wwv_flow_region_report_column
Rem       pawolf   10/27/2009 - Added default_error_display_location to wwv_flows
Rem       mhichwa  10/27/2009 - added accessibility_mode_yn column to sessions table
Rem       pawolf   10/28/2009 - Removed error_display_location from wwv_flow_plugins
Rem       jkallman 10/29/2009 - Add expr3 to wwv_flow_worksheet_conditions
Rem       jstraub  11/02/2009 - Removed wwv_flow_dictionary$
Rem       sspadafo 11/02/2009 - Removed check constraint from authentication column in wwv_flow_ws_applications table
Rem       sspadafo 11/02/2009 - Added wwv_flow_ws_custom_auth_setups table
Rem       pawolf   11/03/2009 - Fixed constraint error in wwv_flow_hnt_column_info
Rem       sspadafo 11/03/2009 - Moved create table ddl for wwv_flow_ws_custom_auth_setups
Rem       sbkenned 11/04/2009 - Added object_name to wwv_flow_builder_audit_trail
Rem       cbcho    11/05/2009 - Added report_alias to wwv_flow_worksheet_rpts
Rem       jkallman 11/05/2009 - Added tz_dependent to wwv_flow_worksheet_columns
Rem       jkallman 11/05/2009 - Added TIMESTAMP_LTZ to wwv_flow_model_page_cols.datatype check constraint
Rem       hfarrell 11/09/2009 - Added column to wwv_flow_flash_chart5_series for declarative action links
Rem       mhichwa  11/10/2009 - Added create table wwv_flow_validations
Rem       mhichwa  11/11/2009 - added reference_id and binds 01 to 06 to wwv_flow_step_validations table
Rem       hfarrell 11/16/2009 - Added gantt_date_format column to wwv_flow_flash_charts_5 for Gantt charts
Rem       cbcho    11/16/2009 - Added save_rpt_public_auth_scheme to wwv_flow_worksheets
Rem       cbcho    11/17/2009 - Added ir_report_id to wwv_flow_activity_log*$, wwv_flow_user_activity_log
Rem       jkallman 11/17/2009 - Change expr3 to time_zone in wwv_flow_worksheet_conditions
Rem       hfarrell 11/17/2009 - Added wwv_flow_chart_format_mask view for Gantt chart date formatting
Rem       mhichwa  11/17/2009 - added content_length to log 1 and 2 and the view
Rem       cbcho    11/18/2009 - Added allow_save_rpt_public to wwv_flow_worksheets
Rem       cbcho    11/18/2009 - Added count_distnt_col_on_break to wwv_flow_worksheet_rpts
Rem       mhichwa  11/19/2009 - added  select_lang_name to support language selector functionality, changed to translated_lang_name
Rem       mhichwa  11/20/2009 - added first list entry templates to enhance creation of modern lists
Rem       arayner  11/20/2009 - Added default_irr_template column to wwv_flows and wwv_flow_themes
Rem       mhichwa  11/20/2009 - new list temlate attributes changed from clob to varchar2(4000)
Rem       mhichwa  11/23/2009 - added content length to WWV_FLOW_LOG_HISTORY
Rem       arayner  11/23/2009 - Added event_type column to wwv_flow_standard_events
Rem       cbcho    11/25/2009 - Added allow_hide to wwv_flow_worksheet_columns
Rem       jstraub  12/01/2009 - Added rest_enabled to wwv_flow_page_plugs
Rem       jstraub  12/02/2009 - Added rest_key to wwv_flow_developers
Rem       jstraub  12/03/2009 - Moved wwv_flow_feedback objects into tab.sql
Rem       jkallman 12/03/2009 - Added 'SESSION' to wwv_valid_flow_lang_from check constraint, removed other unnecessary values
Rem       hfarrell 12/04/2009 - Added undefined map region color columns to wwv_flow_flash_charts_5
Rem       hfarrell 12/07/2009 - Added grid background items for maps to wwv_flow_flash_charts_5: grid_bgtype, grid_bgcolor, grid_bgcolor2, grid_gradient_angle
Rem       jkallman 12/07/2009 - Added column session_lang to wwv_flow_sessions$
Rem       jstraub  12/10/2009 - Removed rest_key from wwv_flow_developers
Rem       arayner  12/10/2009 - Added new triggering element columns to wwv_flow_page_da_events and affected element columns to wwv_flow_page_da_actions
Rem       arayner  12/10/2009 - Removed not null constraint from wwv_flow_page_da_actions.affected_elements_type, should be nullable
Rem       arayner  12/11/2009 - Removed wwv_flow_standard_dyn_act_opp and wwv_flow_standard_dyn_actions tables, no longer needed
Rem       pawolf   12/11/2009 - Added index WWV_FLOW_LOV_DATA_IDX3
Rem       sbkenned 12/11/2009 - Added new columns to wwv_flow_feedback; tags, public_response, label_01-08
Rem       pawolf   12/14/2009 - Added new columns for javascript to wwv_flow_steps
Rem       arayner  12/15/2009 - Removed triggering element columns to wwv_flow_page_da_events and affected element columns to wwv_flow_page_da_actions
Rem       sbkenned 12/15/2009 - Added wwv_flow_hnt_column_dict & wwv_flow_hnt_col_dict_syn to support new UI Defaults Attribute Dictionary
Rem       jkallman 12/15/2009 - Remove blank line from CREATE TABLE statement for wwv_flow_hnt_column_info
Rem       arayner  12/16/2009 - Fixed wwv_flow_page_da_e_btype_ck constraint to support BUILTIN event types
Rem       pawolf   12/16/2009 - Increased size of wwv_flow_plugin_attributes.attribute_type
Rem       arayner  12/17/2009 - Removed beforeunload from wwv_flow_page_da_e_btype_ck dynamic action event constraint
Rem       pawolf   12/17/2009 - Added PLSQL FUNCTION BODY to plug-in attribute types
Rem       arayner  12/17/2009 - Removed error from wwv_flow_page_da_e_btype_ck dynamic action event constraint
Rem       mhichwa  12/17/2009 - added tags column to wwv_flow_feedback table
Rem       mhichwa  12/20/2009 - added feedback_id
Rem       cbcho    12/21/2009 - Added missing FK index on IR and Websheet tables
Rem       arayner  12/21/2009 - Added missing indexes on dynamic action tables
Rem       pawolf   12/21/2009 - Added missing indexes for buttons, items and plugin attributes
Rem       msewtz   12/21/2009 - Added missing indexes for validations
Rem       arayner  12/21/2009 - Renamed dynamic action index names to follow convention
Rem       cbcho    12/21/2009 - Removed user_id from wwv_flow_worksheet_notify
Rem       jstraub  12/21/2009 - Added indexes on wwv_flow_hnt_column_info(group_id) and wwv_flow_hnt_col_dict_syn(column_id)
Rem       mhichwa  12/27/2009 - added create index wwv_flow_feedback_i6 on wwv_flow_feedback (feedback_id)
Rem       pawolf   12/29/2009 - Added "standard_validations" to wwv_flow_step_items and wwv_flow_region_report_column
Rem       mhichwa  12/30/2009 - added table wwv_flow_feedback_followup, also added screen_width and screen_height to wwv_flow_feedback
Rem       mhichwa  12/30/2009 - added email to followup table
Rem       mhichwa  12/30/2009 - added a row to wwv_flow_feedback_status
Rem       mhichwa  01/04/2010 - added report_column_width to report region columns table to support scrolling headers
Rem       jstraub  01/07/2010 - added soap_version to wwv_flow_shared_web_services
Rem       pawolf   01/08/2010 - Added new columns to wwv_flow_plugins
Rem       pawolf   01/11/2010 - Added new columns to view wwv_flow_native_plugins
Rem       hfarrell 01/12/2010 - Added object_id column to wwv_flow_flash_map_regions
Rem       jkallman 01/12/2010 - Add date columns to wwv_flow_collection_members$
Rem       cbcho    01/12/2010 - Added email_subject, made email_address not null on wwv_flow_worksheet_notify
Rem       jkallman 01/14/2010 - Added dl_format, ds_format to wwv_flow_languages
Rem       jkallman 01/14/2010 - Added index on wwv_flow_lists_of_values$, wwv_flow_region_report_column
Rem       sbkenned 01/15/2010 - Added form_attribute_01-10 to wwv_flow_hnt_column_dict to support standard plug-in item types
Rem       cbcho    01/15/2010 - Changed wwv_flow_ws_col_disp_txt_as_ck to add STRIP_HTML_ESCAPE_SC
Rem       pawolf   01/20/2010 - Added escape_on_http_output to wwv_flow_step_items
Rem       jstraub  01/20/2010 - Added indexes wwv_flow_menu_opt_idx2, wwv_flow_step_item_idx5, wwv_flow_items_idx4
Rem       hfarrell 01/20/2010 - Added table wwv_flow_tree_regions for jstree region
Rem       cbcho    01/21/2010 - Added show_rows_per_page to wwv_flow_worksheets
Rem       hfarrell 01/22/2010 - Updated wwv_flow_tree_regions to include column tree_template
Rem       cbcho    01/22/2010 - Added owner to wwv_flow_worksheet_notify
Rem       hfarrell 01/20/2010 - Added hints to wwv_flow_tree_regions
Rem       sbkenned 01/22/2010 - To remove form_display_as from wwv_flow_hnt_column_dict
Rem       pawolf   01/23/2010 - Added support for IR columns based on LOV
Rem       jstraub  01/25/2010 - Added auth_id, auth_type, acl_type to wwv_flow_ws_applications and wwv_flow_ws_app_idx2
Rem       jstraub  01/25/2010 - Removed auth_type from wwv_flow_ws_applications since it can be derived
Rem       cbcho    01/26/2010 - Added ws_app_id to wwv_flow_ws_col_validations
Rem       mhichwa  01/26/2010 - added wwv_flow_debug_messages
Rem       mhichwa  01/27/2010 - added elap and apex_user columns to wwv_flow_debug_messages
Rem       pawolf   01/27/2010 - Added Display Sequence to plug-in attributes
Rem       mhichwa  01/27/2010 - added page_view_id, added wwv_flow_debug_messages2
Rem       mhichwa  01/27/2010 - index page_view_id
Rem       cbcho    01/29/2010 - Added websheet APEX$ lookup tables
Rem       pawolf   02/02/2010 - Added cascading lov columns to wwv_flow_step_items
Rem       jkallman 02/04/2010 - Added has_constraints, has_trigger to wwv_flow_ws_tables, added wwv_flow_ws_ind_columns, added upper_name to wwv_flow_ws_webpages
Rem       arayner  02/05/2010 - Removed wwv_flow_page_da_e_uk constraint on wwv_flow_page_da_events table
Rem       pawolf   02/05/2010 - Renamed wwv_flow_plugins callout procedure columns
Rem       jkallman 02/05/2010 - Remove all workgroup related DDL
Rem       cbcho    02/05/2010 - Added page_number to wwv_flow_ws_webpages
Rem       jkallman 02/08/2010 - Removed table wwv_flow_folders, wwv_flow_web_pages, wwv_flow_web_pg_regions, wwv_flow_web_pg_list_entries, wwv_flow_ws_row_security
Rem       cbcho    02/08/2010 - Added page_alias to wwv_flow_ws_webpages, websheet_alias to wwv_flow_ws_websheet_attr and added unique alias for those columns
Rem       pawolf   02/09/2010 - Changed constraints wwv_flow_std_evnt_type_ck and wwv_flow_page_da_e_btype_ck
Rem       pawolf   02/09/2010 - Added QUERY_COLON as item source type and computation type
Rem       jstraub  02/10/2010 - Added date_format to wwv_flow_ws_applications
Rem       jkallman 02/11/2010 - Move creation of tree regions after wwv_flow_page_plugs, wwv_flow_ws_custom_auth_setups before wwv_flow_ws_applications
Rem       pawolf   02/11/2010 - Added columns button_execute_validations and always_execute
Rem       jstraub  02/11/2010 - Removed fk from wwv_flow_ws_applications.auth_id to wwv_flow_ws_custom_auth_setups and moved creation of setups after applications
Rem       sbkened  02/12/2010 - Removed home_link and home_page_type from wwv_flow_ws_applications and added logo support
Rem       jstraub  02/17/2010 - Added index wwv_flow_shortcut_idx2
Rem       pawolf   02/19/2010 - Removed wwv_flow_plugin_attributes.is_stored_in_clob
Rem       pawolf   02/20/2010 - Added support for process plugins
Rem       mhichwa  02/21/2010 - WWV_FLOW_WS_APPLICATIONS add columns show_peer_navigation_yn, show_child_navigation_yn
Rem       mhichwa  02/21/2010 - Added page_style to ws applications
Rem       mhichwa  02/22/2010 - added source_identifier column to feedback and wwv_flow_companies table to faciliate feedback consolidation
Rem       pawolf   02/22/2010 - Modified wwv_flow_feedback
Rem       jkallman 02/22/2010 - Correct columns of type "timezone" to "time zone" in wwv_flow_feedback
Rem       hfarrell 02/23/2010 - Extend wwv_flow_flash_map_files to include column parent_id
Rem       pawolf   02/24/2010 - Renamed source_identifier to deployment_system in wwv_flow_feedback
Rem       hfarrell 02/26/2010 - Updated wwv_flow_tree_regions to remove unrequired columns
Rem       hfarrell 02/26/2010 - Updated wwv_flow_tree_regions with new tree attribute columns: tree_has_focus,tree_click_action,show_hints,tree_hint_text
Rem       mhichwa  02/01/2010 - Added custom_css to ws_applications table
Rem       jstraub  03/01/2010 - Added form_qualified to wwv_flow_ws_parameters
Rem       mhichwa  03/01/2010 - added show_annotations_control_yn
Rem       cbcho    03/03/2010 - Changed wwv_flow_ws_applications to modify owner column to varchar2(255)
Rem       jkallman 03/04/2010 - Added indexes wwv_flow_page_da_e_region_idx2 and wwv_flow_ws_col_val_idx3, adjust initrans and maxtrans of debug messages tables
Rem       hfarrell 03/05/2010 - Added x and y axis major_interval and minor_interval columns to wwv_flow_flash_charts_5 to hold grid spacing values: fix for bug 5905923
Rem       sspadafo 03/07/2010 - Added fk constraint on wwv_flow_page_submissions(session_id) to wwv_flow_sessions$ and create index on session_id column (Bug 7327162)
Rem       cbcho    03/08/2010 - Added wwv_flow_company_schemas_idx2 to have only 1 apex$_schema per workspace
Rem       jkallman 03/11/2010 - Correct index names on tables wwv_flow_debug_messages, wwv_flow_debug_messages2
Rem       jkallman 03/11/2010 - Add allow_public_access_yn to wwv_flow_ws_applications
Rem       jkallman 03/11/2010 - Add allow_to_be_purged_yn to wwv_flow_companies
Rem       arayner  03/12/2010 - Removed mouseover and mouseout values from wwv_flow_page_da_e_btype_ck constraint.
Rem       arayner  03/12/2010 - Added additional check values to wwv_flow_page_da_e_cond_ck constraint in wwv_flow_page_da_events
Rem       arayner  03/12/2010 - Added before submit check value to wwv_flow_page_da_e_btype_ck constraint on wwv_flow_page_da_events
Rem       mhichwa  03/15/2010 - Added table wwv_flow_ws_app_whitelist
Rem       arayner  03/15/2010 - Modified constraint wwv_flow_page_da_e_btype_ck check value for before page submit and added not null to wwv_flow_ws_app_whitelist.object name column
Rem       arayner  03/15/2010 - Removed submit value from wwv_flow_page_da_e_btype_ck constraint
Rem       arayner  03/16/2010 - Added values for event target and triggering element to check constraint wwv_flow_page_da_a_ae_type_ck on wwv_flow_page_da_actions
Rem       arayner  03/16/2010 - Modified constraint wwv_flow_page_da_a_ae_type_ck check value from EVENT_TARGET to EVENT_SOURCE
Rem       cbcho    03/16/2010 - Added app_whitelist_last_changed to wwv_flow_ws_applications, added wwv_flow_ws_sql_val_cache
Rem       mhichwa  03/17/2010 - added index wwv_flow_build_audit_trail_i6 to improve performance of page 4350:71 many X
Rem       arayner  03/17/2010 - Modified constraint wwv_flow_page_da_e_type_ck check value from ONE to ONCE
Rem       pawolf   03/18/2010 - Fixed ORA-1450 error for index wwv_flow_lov_data_idx3
Rem       arayner  03/18/2010 - Added view wwv_flow_javascript_events that returns standard apex events, browser events and component events
Rem       jkallman 03/18/2010 - Added wwv_flow_page_plugs.plug_query_parse_override
Rem       arayner  03/18/2010 - Modified view wwv_flow_javascript_events, changed order and system message reference
Rem       arayner  03/18/2010 - Removed not null constraint from wwv_flow_page_da_events.triggering_element_type
Rem       mhichwa  03/18/2010 - added login_page_message
Rem       arayner  03/19/2010 - Modified constraint wwv_flow_page_da_e_type_ck check value back from once to one
Rem       arayner  03/19/2010 - Removed ALWAYS check value from constraint wwv_flow_page_da_e_cond_ck
Rem       arayner  03/19/2010 - Added ready value to check constraint wwv_flow_page_da_e_btype_ck
Rem       arayner  03/19/2010 - Modified view wwv_flow_javascript_events to use system message for browser events
Rem       sspadafo 03/19/2010 - Added ldap_use_ssl to wwv_flow_ws_custom_auth_setups
Rem       mhichwa  03/22/2010 - added allow_sql_YN to ws applications
Rem       sbkenned 03/22/2010 - removed optional_named_schema from wwv_flow_ws_app_whitelist
Rem       arayner  03/24/2010 - Modified constraint wwv_flow_page_da_e_btype_ck check values, BLUR is now FOCUSOUT, FOCUS is now FOCUSIN
Rem       cbcho    03/24/2010 - Removed app_whitelist_last_changed from wwv_flow_ws_applications, removed wwv_flow_ws_sql_val_cache
Rem       sbkenned 03/24/2010 - Added wwv_flow_ws_app_sug_objects (will be replacing wwv_flow_ws_app_whitelist)
Rem       hfarrell 03/25/2010 - Added icon column to wwv_flow_flash_map_files
Rem       sbkenned 03/25/2010 - Added object_comment and removed object_owner from wwv_flow_ws_app_sug_objects
Rem       jstraub  03/29/2010 - Added ldap_use_exact_dn and ldap_search_filter to wwv_flow_ws_custom_auth_setups
Rem       sathikum 03/30/2010 - Added include_custom_cal to wwv_flow_cals
Rem       sbkenned 03/30/2010 - Removed wwv_flow_ws_app_whitelist (no longer used)
Rem       jkallman 04/01/2010 - Added wwv_flow_team_tags (moved from team_tab.sql)
Rem       jkallman 04/05/2010 - Added purge tables
Rem       jstraub  04/05/2010 - Added language and language_derived_from to wwv_flow_ws_applications
Rem       msewtz   04/05/2010 - Updated constraint wwv_regrepcol_display_as
Rem       pawolf   04/06/2010 - Added category column to wwv_flow_advisor_checks
Rem       pawolf   04/08/2010 - Removed category_id from wwv_flow_advisor_check_msgs
Rem       pawolf   04/09/2010 - Removed wwv_flow_feedback.tag
Rem       hfarrell 04/13/2010 - Updated constraint wwv_flow_mp_page_type on wwv_flow_model_pages to include CHART and remove unrequired BAR_CHART and PIE_CHART
Rem       jkallman 04/13/2010 - Correct index wwv_purge_datafiles_idx1
Rem       hfarrell 04/14/2010 - Added chart columns to wwv_flow_model_page_regions table: chart_title, chart_type, chart_color_scheme
Rem       hfarrell 04/14/2010 - Added addditional chart columns to wwv_flow_model_page_regions, and support for more chart types
Rem       pawolf   04/14/2010 - Added stop_execution_on_error to wwv_flow_page_da_actions
Rem       hfarrell 04/14/2010 - Removed constraint WWV_FLOW_MPR_CHART_TYPE on wwv_flow_model_page_regions.chart_type, increased size of column to varchar2(30)
Rem       pawolf   04/15/2010 - Removed not used index for wwv_flow_advisor_check_msgs
Rem       pawolf   04/15/2010 - Fixed index name wwv_flow_adv_chk_msg_chk_idx1
Rem       cbcho    04/15/2010 - Added status,notify_error to wwv_flow_worksheet_notify
Rem       msewtz   04/15/2010 - Added additional tabular form display as attributes
Rem       arayner  04/17/2010 - Changed accessibility_mode_yn column in sessions table to screen_reader_mode_yn
Rem       arayner  04/17/2010 - Changed screen_reader_mode_yn column in sessions table back to to accessibility_mode_yn.
Rem       pawolf   04/17/2010 - Renamed lov_items_to_submit and lov_optimize_refresh to ajax_item_to_submit and ajax_optimize_refresh
Rem       arayner  04/17/2010 - Changed accessibility_mode_yn column in sessions table to screen_reader_mode_yn
Rem       pawolf   04/18/2010 - Added category to wwv_flow_plugins
Rem       hfarrell 04/19/2010 - Added gantt_start_date and gantt_end_date to wwv_flow_flash_charts_5
Rem       pawolf   04/22/2010 - Added flow_id and page_id to wwv_flow_page_da_actions
Rem       jkallman 04/22/2010 - Change language_derived_from to territory in wwv_flow_ws_applications
Rem       jkallman 04/22/2010 - Add session_territory to wwv_flow_sessions$
Rem       arayner  04/23/2010 - Removed show_wait and wait_message columns from wwv_flow_step_buttons and button_show_wait and button_wait_message to wwv_flow_step_items
Rem       hfarrell 04/26/2010 - Added cntry_name to wwv_flow_flash_map_regions
Rem       cbcho    04/30/2010 - Added data_grid_form_seq to wwv_flow_worksheet_columns to use only for Websheet Data Grid
Rem       pawolf   05/04/2010 - Bug# 9679620: Added new index to wwv_flow_steps to get public and secure pages
Rem       hfarrell 05/10/2010 - Updated table wwv_flow_tree_regions to include tree_selected_node column
Rem       jkallman 05/13/2010 - Added table wwv_flow_authorized_urls (Bug 9708920)
Rem       pawolf   05/18/2010 - Bug# 9602440: Added wwv_flow_page_code_cache
Rem       jkallman 06/01/2010 - Modify length of mime_type from 48 to 255 in wwv_flow_mail_attachments and wwv_flow_plugin_files
Rem       jkallman 06/05/2010 - Added missing index wwv_flow_ws_rpts_idx3
Rem       hfarrell 06/29/2010 - Fix for bug 9861439: updated return value of wwv_flow_chart_format_masks view to escape AnyChart date prefix
Rem       jkallman 07/22/2010 - Use '.' as radix character in timestamp values in view wwv_flow_format_masks (Bug 9927128)
Rem       hfarrell 07/22/2010 - Back out fix for bug 9861439, as related bug 9931875 resolves character escape issue in wwv_flow_javascript.plb
Rem       cbcho    10/01/2010 - Added check constraints to wwv_flow_worksheet_group_by on function_xx, sort_direction_xx columns (bug 10071156)
Rem       cbcho    10/05/2010 - Added check constraint to wwv_flow_worksheet_rpt on chart_aggregate column (bug 10074067)
Rem       jkallman 11/02/2010 - Correct session_time_zone regular expression in wwv_flow_sessions$ (Bug 10254660)
Rem       pawolf   11/23/2010 - Removed wwv_flow_lov_temp
Rem       pawolf   11/24/2010 - Removed wwv_flow_temp_table
Rem       pawolf   11/24/2010 - Removed wwv_flow_temp_trees
Rem       pawolf   12/14/2010 - Added attribute_11 - attribute_15 to all tables supporting plug-ins (feature# 572)
Rem       pawolf   12/17/2010 - Added attribute type CHECKBOXES to wwv_flow_plugin_attributes (feature# 575)
Rem       mhichwa  12/26/2010 - Added 3 wwv_flow_rt tables to support database web services (feature 584 )
Rem       mhichwa  12/26/2010 - Added not null constraint, changed version column to varchar2 (feature 584)
Rem       mhichwa  12/27/2010 - Added run as schema and description (feature 584)
Rem       mhichwa  12/27/2010 - added wwv_flow_rt$workspace_prefs table to store hostname for database services (feature 584)
Rem       sathikum 01/03/2011 - added column enable_drag_drop and enable_ajax_data_add to wwv_flow_cals (feature #520)
Rem       jkallman 01/03/2011 - Added unique constraint wwv_flow_fnd_user_groups_uk1
Rem       jkallman 01/03/2011 - Correct bad formatting in all wwv_flow_rt$ tables
Rem       jkallman 01/03/2011 - Renamed index wwv_flow_rt$resource_i1 to the correct wwv_flow_rt$resource_idx1
Rem       sathikum 01/14/2011 - added data_background_color and data_text_color(feature #520)
Rem       pawolf   01/14/2011 - Added columns to wwv_flow_step_validations and wwv_flow_step_processing (feature# 542)
Rem       sathikum 01/21/2011 - Added column enable_ajax_data_edit (feature #520)
Rem       hfarrell 01/31/2011 - Fix for bug 11699690: updated Hour segment of AnyChart equivalent of date format DD-MON-YYYY HH:MIPM in wwv_flow_chart_format_masks
Rem       cneumuel 02/02/2011 - Added plugin support for authorization (feature #580)
Rem       hfarrell 02/07/2011 - Added list_type and list_query to wwv_flow_lists table for Dynamic List support (feature #602)
Rem       cneumuel 02/08/2011 - Added index wwv_flow_trans_cols$_idx1
Rem       jkallman 02/08/2011 - Adjust initrans to 8 for wwv_flow_collection_members_pk
Rem       cneumuel 02/11/2011 - Moved index on wwv_flow_developers to tab.sql (feature 580)
Rem       hfarrell 02/14/2011 - Added check constraint on list_type in wwv_flow_lists table
Rem       sathikum 02/15/2011 - Added enable_ajax_data_delete to wwv_flow_cals
Rem       hfarrell 02/21/2011 - Added list_item_icon_alt_attribute column to wwv_flow_list_items
Rem       hfarrell 02/21/2011 - Added TARGET_PAGE to check constraint wwv_flow_lst_curr_type_val on column wwv_flow_list_items.list_item_current_type
Rem       arayner  02/23/2011 - Added BUTTON to wwv_flow_page_da_e_te_type_ck check constraint on column wwv_flow_page_da_events.triggering_element_type (feature #385)
Rem       arayner  02/23/2011 - Added wwv_flow_page_da_events.triggering_button_id column and associated index (feature #385)
Rem       jkallman 02/23/2011 - Added friendly_name and workspace_group_id to wwv_flow_companies
Rem       jkallman 02/26/2011 - Added account_status to wwv_flow_companies
Rem       pawolf   02/28/2011 - Added new error handling columns (feature# 544)
Rem       arayner  03/01/2011 - Added wwv_flow_step_buttons.button_static_id column (feature #385)
Rem       pawolf   03/08/2011 - Added new error display location column to wwv_flow_step_processing and wwv_flow_processing (feature# 544)
Rem       arayner  03/09/2011 - Increased size of wwv_flow_step_buttons.button_static_id column to be equal to button name (feature #385)
Rem       arayner  03/09/2011 - Added wwv_flow_step_buttons.button_action column with check constraint wwv_flow_valid_fbutton_action (feature #385)
Rem       msewtz   03/10/2011 - Added mobile_page_template to wwv_flow_templates, used to trigger mobile page mode (feature 586)
Rem       jkallman 03/16/2011 - Change data type of message_timestamp to timestamp with time zone in wwv_flow_debug_messages, wwv_flow_debug_messages2
Rem       arayner  03/17/2011 - Added not null constraint for wwv_flow_step_buttons.button_action (feature #385)
Rem       jkallman 03/18/2011 - Correct data type of message_timestamp in wwv_flow_debug_messages2
Rem       cneumuel 03/22/2011 - Added unique id and call_stack to debug tables (bug #11733252)
Rem       cneumuel 03/29/2011 - Added workspace image to wwv_flow_companies (feature #632)
Rem       pawolf   03/29/2011 - Marked PLUG_DISPLAY_ERROR_MESSAGE as obsolete (feature# 544)
Rem       arayner  03/30/2011 - Added button_action and button_redirect_url columns to wwv_flow_step_items (feature 385)
Rem       msewtz   03/30/2011 - Added before_item and after_item to wwv_flow_field_templates to allow for custom HTML when form not rendered as table (feature 586)
Rem       msewtz   03/30/2011 - Added render_form_as_table to wwv_flow_steps, used while rendering form items to determine whether to put them in table grid  (feature 586)
Rem       jkallman 03/30/2011 - Change wwv_flow_companies.workspace_group_id to workspace_service_id
Rem       jkallman 03/31/2011 - Renamed wwv_flow_companies.friendly_name to display_name
Rem       msewtz   03/31/2011 - Added use_as_row_header and column_field_template to wwv_flow_region_report_column (feature 586)
Rem       arayner  04/01/2011 - Removed REPORT value from button action check constraints wwv_flow_valid_fbutton_action and wwv_valid_fsitem_b_action (feature 385)
Rem       pawolf   04/04/2011 - Removed wwv_flow_platform_pref
Rem       jkallman 04/05/2011 - Added index wwv_flow_platform_prefs_idx1
Rem       pawolf   04/06/2011 - Added ajax_items_to_submit and escape_on_http_output to wwv_flow_page_plugs (feature 505 and 649)
Rem       pawolf   04/06/2011 - Use wwv_flow_page_plugs.ajax_items_to_submit instead of wwv_flow_worksheets.page_items_to_submit (feature 505)
Rem       pawolf   04/08/2011 - Added "Substitute Attribute Values" (substitute_attributes) to plug-ins (feature 655)
Rem       msewtz   04/08/2011 - Removed render_form_as_table from wwv_flow_steps (feature 586)
Rem       msewtz   04/08/2011 - Added render_form_items_in_table to wwv_flow_page_plug_templates (feature 586)
Rem       sathikum 04/11/2011 - Modified wwv_flow_cals added primary_key_column, drag_drop_required_role, drag_drop_process_id removed enable_drag_drop and enable_ajax_data_add [modify | delete] to wwv_flow_cals (feature #520)
Rem       jkallman 04/11/2011 - Add missing audit columns to wwv_flow_dynamic_translations$
Rem       pawolf   04/11/2011 - Added plug-in attribute type "REGION SOURCE COLUMN" (feature 663)
Rem       jkallman 04/12/2011 - Removed wwv_flow_rt$_ tables (already in db_webservices_tab.sql)
Rem       sathikum 04/14/2011 - Added item_link_primary_key_item, item_link_date_item (feature #520)
Rem       sathikum 04/18/2011 - Added item_link_open_in to wwv_flow_cals (feature #520)
Rem       pmanirah 04/19/2011 - Added wwv_flow_load_tables table to store tables information for data loading (feature #545)
Rem       pmanirah 04/19/2011 - Added wwv_flow_load_tables_idx1 index
Rem       pmanirah 04/19/2011 - Added wwv_flow_load_table_lookups table to store tables lookups for data loading (feature #545)
Rem       pmanirah 04/19/2011 - Added wwv_flow_load_table_lookups_idx1 index
Rem       pmanirah 04/19/2011 - Added wwv_flow_load_table_rules table to hold data transformation rules for data loading (feature #545)
Rem       pmanirah 04/19/2011 - Added wwv_flow_load_table_rules_idx1, wwv_flow_load_table_rules_idx2, wwv_flow_load_table_rules_idx3 indexes
Rem       pmanirah 04/23/2011 - Added 'data loading' component to the wwv_multi_component_export procedure
Rem       jkallman 04/25/2011 - Moved data loading tables before wwv_multi_componet_export view
Rem       pawolf   04/27/2011 - Added object types t_temp_lov_data and t_temp_lov_value
Rem       jkallman 04/28/2011 - Added table wwv_flow_file_purge_log
Rem       hfarrell 04/29/2011 - Added application_type and application_description to wwv_flows (feature #661)
Rem       pawolf   05/02/2011 - Moved object types into its own file types.sql
Rem       jkallman 05/02/2011 - Changed table name from wwv_flow_file_purge_log to wwv_flow_auto_file_delete_log
Rem       sathikum 05/03/2011 - Added default value for item_link_open_in to 'W' in wwv_flow_cals table
Rem       arayner  05/05/2011 - Removed not null constraint on wwv_flow_step_buttons.button_action which was causing an upgrade error
Rem       msewtz   05/09/2011 - Added default mobile template columns to wwv_flow_themes
Rem       pawolf   05/10/2011 - Added "is hot button" (feature 702)
Rem       jkallman 05/11/2011 - Removed table wwv_flow_db_auth
Rem       cbcho    05/12/2011 - Added show_reset_passwd_yn to wwv_flow_ws_applications (feature 620)
Rem       pawolf   05/13/2011 - Added plug-ins for authentication schemes (feature 581)
Rem       cneumuel 05/13/2011 - Added wwv_flow_companies.{created_on,assigned_on,workspace_description} for mike
Rem       cneumuel 05/13/2011 - Added wwv_flow_authentications (feature 581)
Rem       jkallman 05/13/2011 - Adjusted check constraint for wwv_flow_companies.account_status
Rem       cneumuel 05/17/2011 - Added wwv_flow_authentications.verification_function and wwv_flow_plugins.invalid_session_function (feature 581)
Rem       jkallman 05/18/2011 - Removed blank lines from table wwv_flow_custom_auth_setups, converted upper case text in wwv_flow_custom_auth_setups
Rem       cbcho    05/20/2011 - Added wwv_flow_ws_data_grid_q (feature 611)
Rem       jstraub  05/24/2011 - Removed wwv_flow_compound_conditions
Rem       cbcho    05/24/2011 - Added sql_tag_id to wwv_flow_ws_data_grid_q table (feature 611)
Rem       cneumuel 05/26/2011 - Added plsql_code to wwv_flow_authentications, verification_function, pre- and post_auth_process changed to varchar2(255) (feature 581)
Rem       arayner  05/26/2011 - Added high_contrast_mode_yn to wwv_flow_sessions$ (feature 637)
Rem       jkallman 06/01/2011 - Added date_time_format to wwv_flows (feature 715)
Rem       pmanirah 06/01/2011 - Added owner, name and where_clause to the wwv_flow_load_tables (feature #545)
Rem       pmanirah 06/01/2011 - Changed the wwv_flow_load_table_uk1 definition (feature #545)
Rem       pmanirah 06/01/2011 - Added owner to the wwv_flow_load_table_lookups table (feature #545)
Rem       sathikum 06/02/2011 - Added include_time_with_date to wwv_flow_cals (feature #520)
Rem       pmanirah 06/02/2011 - Added name, owner to the wwv_flow_load_tables and where_clause, lookup_owner to the wwv_flow_load_table_lookups
Rem       jstraub  06/03/2011 - Added RUN_AND_HIDDEN to check constraint wwv_flow_valid_build_status
Rem       jkallman 06/06/2011 - Added value TERMINATE to check constraint wwv_flow_companies_ck2
Rem       cbcho    06/06/2011 - Added unique constraint for wwv_flow_ws_websheet_attr.websheet_name (bug 12628617)
Rem       pawolf   06/07/2011 - Added DATA LOAD TABLE ID as new plugin attribute type (feature #545)
Rem       hfarrell 06/09/2011 - Added TEMPLATE_HIDDEN to check constraint wwv_flow_app_type on wwv_flows.application_type
Rem       hfarrell 06/10/2011 - Added date_time_format to WWV_FLOW_APP_BUILD_PREF (feature 715)
Rem       hfarrell 06/14/2011 - Added application_type to wwv_flow_ws_applications and associated check constraint wwv_flow_ws_app_type (feature #661)
Rem       cneumuel 06/17/2011 - Added wwv_flow.browser_cache and wwv_flow_steps.browser_cache (feature #726)
Rem       cneumuel 06/17/2011 - Added wwv_flows.vpd_teardown_code (feature #616)
Rem       sbkenned 06/17/2011 - updated wwv_flow_load_tab_rule_ck1, added missing types that were in lov in UI
Rem       jkallman 06/19/2011 - Correct the definition of wwv_fsteps_ck_browser_cache
Rem       cneumuel 06/20/2011 - Correct column default of wwv_flows.browser_cache (feature #726)
Rem       jkallman 06/21/2011 - Added last_updated_on to index wwv_flow_mail_log_idx3
Rem       jkallman 07/05/2011 - Added translate_list_text_y_n to wwv_flow_list_items
Rem       arayner  07/06/2011 - Bug# 12707552: Fixed issue with untranslated framework event names in wwv_flow_javascript_events view
Rem       cneumuel 07/07/2011 - Added wwv_flow.browser_frame (feature #731)
Rem       pawolf   07/11/2011 - Added not null and default for wwv_flow_authentications.use_secure_cookie_yn
Rem       jkallman 08/03/2011 - Added missing indexes on foreign keys
Rem       pawolf   08/05/2011 - Added new column compatibility_mode to wwv_flows (bug# 12835127)
Rem       jkallman 08/09/2011 - Change wwv_flow_page_da_a_ar_fk to be deferrable and initially deferred (bug 12850780)
Rem       pawolf   09/08/2011 - Added column rm_consumer_group to wwv_flow_companies (Bug 12944223)
Rem       cneumuel 10/21/2011 - In wwv_flow_companies: added group_name, host_prefix (bug #13101596)
Rem       cneumuel 11/09/2011 - In wwv_flow_companies: renamed group_name to cloud_group_name, added cloud_service_name
Rem       jkallman 11/09/2011 - Increased size of wwv_flow_sessions$.session_time_zone to 255, removed check constraint (Bug 13364970)
Rem       cneumuel 11/11/2011 - In wwv_flow_companies: fixed typo
Rem       jstraub  12/01/2011 - Removed obsolete wwv_flow_purged_sessions$ (bug 13452726)
Rem       pawolf   12/23/2011 - Added restricted_characters to wwv_flow_step_items (bug 13344998)
Rem       mhichwa  01/03/2012 - Added auto_archive_yn to wwv_flow_companies
Rem       cneumuel 01/04/2012 - Added wwv_flow_companies_host_chk (bug 13101596)
Rem       arayner  01/05/2012 - Changed wwv_flow_page_da_a_ar_fk to no longer be deferrable (bug 12850780)
Rem       pawolf   01/25/2012 - Added constraint to wwv_flow_step_items.restricted_characters
Rem       pawolf   02/29/2012 - Added placeholder to wwv_flow_step_items (feature# 837)
Rem       arayner  02/29/2012 - Changed wwv_flow_step_items.display_as and wwv_flow_page_da_actions.action to be 255 characters in length (bug 13571459)
Rem       pawolf   03/02/2012 - Added data model changes for several 4.2 features (feature# 778, 826, 819, 817, 816, 815, 823, 767, 825, 828, 829, 844)
Rem       hfarrell 05/02/2012 - Added data model changes for charts-related 4.2 features #543 and #494
Rem       arayner  03/05/2012 - Added "custom" to the wwv_flow_page_da_e_btype_ck check constraint (feature #767)
Rem       arayner  03/05/2012 - Added "CUSTOM" to wwv_flow_std_evnt_type_ck check constraint and additional union in wwv_flow_javascript_events view for custom event (feature #767)
Rem       hfarrell 03/05/2012 - Updated check constraints on chart_rendering columns to resolve typo.
Rem       pawolf   03/06/2012 - Renamed new css_classes to region_css_classes and tag_css_classes to be consistent with existing columns (feature# 815)
Rem       pawolf   03/07/2012 - Added new table wwv_flow_theme_styles (feature# 821)
Rem       pawolf   03/08/2012 - Added data model changes for UI type feature (feature# 827)
Rem       arayner  03/13/2012 - Added JQM events to wwv_flow_page_da_e_btype_ck dynamic action event constraint (feature #769)
Rem       arayner  03/14/2012 - Added wwv_flow_page_da_events.bind_delegate_to_selector column (feature #836)
Rem       pawolf   03/14/2012 - Removed display_row_template_id from wwv_flow_lists (feature# 873)
Rem       pawolf   03/15/2012 - Moved wwv_flow_search_result and wwv_flow_advisor_result to dev_views.sql
Rem       sathikum 03/15/2012 - Added columns to wwv_flow_cal_templates (feature #812)
Rem       pawolf   03/19/2012 - Changed view wwv_flow_templates_used to use only theme columns instead of the old columns in wwv_flow (feature# 827)
Rem       cneumuel 03/27/2012 - Added wwv_flow_user_access_log1$_ix1,wwv_flow_user_access_log2$_ix1 (bug #13713222)
Rem       cneumuel 03/28/2012 - When creating internal workspaces: set expire_fnd_user_accounts='Y' (bug #13713222)
Rem       pawolf   03/28/2012 - Added 10 more custom plug-in attributes to regions (feature# 890)
Rem       cbcho    03/28/2012 - Added email_from in wwv_flow_worksheets (feature# 695)
Rem       cneumuel 03/29/2012 - When creating internal workspaces: fixed VALUE_ERROR because of wrong parameter type to p_short_name
Rem       hfarrell 03/29/2012 - Added required_patch to wwv_flow_flash_chart5_series (feature #494)
Rem       cbcho    03/29/2012 - Added email_from in wwv_flows (feature# 695)
Rem       sathikum 03/30/2012 - Added additional columns to wwv_flow_cals feature (#812)
Rem       pawolf   03/30/2012 - Added new table wwv_flow_plugin_settings (feature# 895)
Rem       jkallman 04/02/2012 - Removed obsolete tables wwv_flow_alt_config_pick, wwv_flow_standard_js, wwv_flow_standard_css,
Rem                             wwv_flow_upg_tab_name_changes, wwv_flow_upg_col_name_changes, wwv_flow_upg_tab_obsolete
Rem       vuvarov  04/03/2012 - Added branch_name to wwv_flow_step_branches (feature #872)
Rem       pawolf   04/05/2012 - Added new page and popup transitions (feature #826)
Rem       pawolf   04/06/2012 - Added read only attributes to wwv_flow_steps and wwv_flow_page_plugs (feature# 570)
Rem       cneumuel 04/10/2012 - Added wwv_flows.authorize_public_pages_yn (bug #13940433)
Rem                           - In wwv_flow_data: removed obsolete columns item_element_id, name_length. Made pk in (flow_instance,item_id) instead of unique key
Rem       cneumuel 04/11/2012 - In wwv_flow_data: wwv_flow_data_pk in a syntax that supports 10g XE
Rem       pawolf   04/11/2012 - Increased wwv_flow_plugin_attr_seq_ck to support up to 25 attributes.
Rem       cneumuel 04/12/2012 - Removed obsolete table wwv_flow_debug
Rem       sathikum 04/13/2012 - Added month_data_display_type to wwv_flow_cals and month_data_format,month_data_entry_format (feature #811)
Rem       cbcho    04/13/3012 - Added language, email_from in wwv_flow_worksheet_notify (feature #881)
Rem       cneumuel 04/17/2012 - Prefix sys objects with schema (bug #12338050)
Rem       arayner  04/20/2012 - Added wwv_flow_page_da_actions.wait_for_result (feature #599)
Rem       pawolf   04/25/2012 - Added column_data_types to wwv_flow_plugin_attributes (feature #918)
Rem       cbcho    04/25/2012 - Added icon_view_use_custom, icon_view_custom_link to wwv_flow_worksheets (feature #915)
Rem       cbcho    04/26/2012 - Added not null and default to icon_view_use_custom, icon_view_enabled_yn, detail_view_enabled_yn in wwv_flow_worksheets
Rem       cbcho    04/27/2012 - Added email_from in wwv_flow_ws_applications (feature #695)
Rem       pawolf   04/30/2012 - Added series_ajax_items_to_submit to wwv_flow_flash_chart5_series (feature #741)
Rem       cneumuel 04/30/2012 - Added wwv_flows_reserved.permanent_security_group_id (bug #14008101)
Rem       vuvarov  05/01/2012 - Added Plug-in and Text Message to wwv_multi_component_export; fixed Authentication (bug 13836432)
Rem       cneumuel 05/02/2012 - Added wwv_flow.deep_linking and wwv_flow_steps.deep_linking (feature #878)
Rem       cneumuel 05/10/2012 - Added wwv_flow_ws_custom_auth_setups.ldap_username_escaping (bug #14047270)
Rem       pawolf   05/11/2012 - Added wwv_flow_page_plugs.plug_item_display_point (feature #278)
Rem       pawolf   05/11/2012 - Renamed display point BEFORE_BOX_BODY, BEFORE_SHOW_ITEMS and AFTER_SHOW_ITEMS to BODY_1-3 (feature #278)
Rem       pawolf   05/14/2012 - Added grid templates (feature #936)
Rem       arayner  05/15/2012 - Added include_legacy_javascript to wwv_flows (feature #927)
Rem       arayner  05/15/2012 - Added temporary default to Y for include_legacy_javascript in wwv_flows (feature #927)
Rem       arayner  05/16/2012 - Made include_legacy_javascript in wwv_flows not null (feature #927)
Rem       msewtz   05/18/2012 - Modified constraint wwv_flow_app_type, added 'THEME' as valid value for wwv_flows.application_type
Rem       pawolf   05/21/2012 - More changes for grid templates (feature #936)
Rem       pawolf   05/21/2012 - Added wwv_flow_theme_display_points (feature #936)
Rem       pawolf   05/21/2012 - More changes for grid templates (feature #936)
Rem       cneumuel 05/23/2012 - In wwv_flow_data: removed item_value, added item_value_vc2, item_value_clob (feature #940)
Rem       pmanirah 05/24/2012 - Added two columns on wwv_flow_load_tables is_lov_active and column_names_lov (feature #833)
Rem       pawolf   05/24/2012 - Moved grid template attributes into wwv_flow_templates and removed wwv_flow_grid_templates (feature #936)
Rem       pmanirah 05/24/2012 - Added column_names_lov_id and removed is_lov_active and column_names_lov columns of wwv_flow_load_tables (feature #833)
Rem       vuvarov  05/24/2012 - Removed application attributes from wwv_multi_component_export view (bug 13836432)
Rem       arayner  05/28/2012 - Added wwv_flow_page_da_actions.affected_button_id (feature #678)
Rem       arayner  05/28/2012 - Added index wwv_flow_page_da_a_button_idx1 for new column wwv_flow_page_da_actions.affected_button_id (feature #678)
Rem       arayner  05/28/2012 - Added BUTTON to wwv_flow_page_da_a_ae_type_ck (feature #678)
Rem       pawolf   05/29/2012 - Added 4.2 to flow compatibility mode
Rem       cneumuel 05/30/2012 - Added comment before wwv_flow_data and wwv_flow_activity_log[12]$ to synchronize ../utilities/apxpart.sql
Rem       cneumuel 05/31/2012 - Added wwv_flow_items.scope (feature #897)
Rem       pmanirah 05/31/2012 - Added two columns on wwv_flow_load_tables is_use_version_col_on and version_column_name (feature #903)
Rem       jkallman 06/04/2012 - Added table wwv_flow_log_numbers, dropped table wwv_flow_clickthru_log_number$, wwv_flow_user_access_log_num, wwv_flow_activity_log_number$ (Feature 966)
Rem       cbcho    06/04/2012 - Added internal_uid in wwv_flow_worksheets (feature #268)
Rem       msewtz   06/05/2012 - Added default_header_template and default_footer_template to wwv_flow_themes
Rem       jkallman 06/06/2012 - Changed wwv_flow_log_numbers to organization index, added pk constraint
Rem       jkallman 06/06/2012 - Added check constraint wwv_flow_log_numbers_ck4
Rem       cbcho    06/07/2012 - Added data_default in wwv_flow_ws_tab_columns (feature #900)
Rem       msewtz   06/08/2012 - Added LISTVIEW and LISTVIEWANDFORM to constraint wwv_flow_mp_page_type
Rem       pmanirah 06/08/2012 - Removed the column is_use_version_col_on
Rem       msewtz   06/08/2012 - Added display_column, supp_info_column to wwv_flow_model_page_regions
Rem       pmanirah 06/13/2012 - Added PLSQL_FUNCTION_BODY, SQL_QUERY_SINGLE_VALUE, SQL_QUERY_SEMI_COLON to the wwv_flow_load_tab_rule_ck1 check within wwv_flow_load_table_rules table
Rem       cneumuel 06/14/2012 - Changed wwv_flow_user_access_log indexes (feature #899)
Rem       pawolf   06/15/2012 - Added has_edit_links to wwv_flow_templates
Rem       pawolf   06/15/2012 - Added table wwv_flow_plug_tmpl_disp_points (feature #936)
Rem       pmanirah 06/18/2012 - Added new index wwv_flow_load_tab_idx1 on wwv_flow_load_tables
Rem       sathikum 06/19/2012 - Added end_date_column to wwv_flow_cals (feature #814)
Rem       pawolf   06/20/2012 - Added global_page_id to wwv_flow_user_interfaces (feature #987)
Rem       pawolf   06/22/2012 - Changed constraint for wwv_flow_user_interfaces.global_page_id
Rem       pawolf   06/26/2012 - Changed constraint for wwv_flow_user_interfaces.global_page_id
Rem       cneumuel 06/26/2012 - Fixed typo in wwv_flow_ui_types.autodetect_js_function_body (feature #791)
Rem       pawolf   06/15/2012 - Added table wwv_flow_page_tmpl_disp_points (feature #936)
Rem       pawolf   06/27/2012 - Changed column order of unique template indexes
Rem       cneumuel 07/04/2012 - Added index on wwv_flow_authentications.reference_id
Rem       pawolf   07/04/2012 - Added Builder Feature configuration tables (feature #827)
Rem       cneumuel 07/12/2012 - Added wwv_flows.ui_detection_css_urls (feature #791)
Rem       mhichwa  07/12/2012 - Added allow_team_dev_files_yn (feature #1007)
Rem       pawolf   07/12/2012 - Added constraint to allow_team_dev_files_yn (feature #1007)
Rem       cneumuel 07/13/2012 - Added wwv_flows.html_escaping_mode (bug #14047702)
Rem       hfarrell 07/16/2012 - Added path_prefix and allow_restful_services_yn to wwv_flow_companies (feature #863)
Rem       hfarrell 07/17/2012 - Added unique index wwv_flow_companies_idx3 on wwv_flow_companies.path_prefix (feature #863)
Rem       vuvarov  07/17/2012 - Added nls_sort and nls_comp columns to wwv_flows (feature #978)
Rem       hfarrell 07/18/2012 - Updated wwv_flow_companies.allow_restful_services_yn to set default 'Y' not null
Rem       pmanirah 07/24/2012 - Added BLOB format to the wwv_flow_format_masks view (feature 131 / 132)
Rem       cbcho    07/26/2012 - Removed wwv_flow_worksheet_notify_fk constraint from wwv_flow_worksheet_notify (feature #1004)
Rem       jkallman 08/01/2012 - Added index wwv_flow_session_idx3
Rem       jkallman 08/03/2012 - Added default_date_format to wwv_flow_fnd_user
Rem       jstraub  08/09/2012 - Added alter package wwv_flow_security compile prior to setting g_security_group_id (bug 14477658)
Rem       jkallman 08/09/2012 - Add fk constraint and index on table wwv_flow_dynamic_translations$ (Bug 13801751)
Rem       cneumuel 08/13/2012 - Add wwv_flow_steps.wwv_flow_step_autocomplete_ck (bug #13742676)
Rem       jstraub  08/16/2012 - Added alter package wwv_flow compile prior to inserting default companies (bug 14502368)
Rem       cbcho    08/17/2012 - Added fk constraint and index on table wwv_flow_worksheet_categories flow_id column (bug 14509942)
Rem       jkallman 08/20/2012 - Added index wwv_flow_ws_rpts_idx4, augmented index wwv_flow_ws_conditions_idx
Rem       pawolf   08/21/2012 - Restored constraint wwv_valid_fsitem_displayas to as it was in 4.1
Rem       jstraub  08/23/2012 - Removed the alter package compiles, issues were caused by running apxremov and not exiting
Rem       cbcho    08/23/2012 - Added fk constraint and index on table wwv_flow_worksheet_notify security_group_id column
Rem       cneumuel 08/29/2012 - In wwv_flow_step_items.restricted_characters: extend check constraint to allow WORKSPACE_SCHEMA (bug #14525335)
Rem       cneumuel 09/01/2012 - Made sure there is white space between table name and open brace in create trigger statements, because of WMSYS.NO_VM_CREATE_PROC
Rem       cneumuel 09/07/2012 - In wwv_flow_templates_all, wwv_flow_templates_used: check security_group_id in where clause
Rem       pawolf   10/15/2012 - Changed default of wwv_flow_popup_lov_template.result_row_x_of_y (bug# 14664649)
Rem       hfarrell 11/05/2012 - Removed table wwv_flow_flash_charts_5_dash (bug #15830211)
Rem       pawolf   01/15/2013 - Added 5.0 as compatibility_mode value
Rem       cneumuel 02/15/2013 - In wwv_flow_companies: added qos_max_workspace_requests, qos_max_session_requests, qos_max_session_kill_timeout (bug #15893138)
Rem       cneumuel 02/20/2013 - In wwv_flows: added import_orig_app_id, import_orig_security_group_id, import_id_offset (feature #985)
Rem       pawolf   04/09/2013 - Moved wwv_flow_biw_appbldpref from tab.sql to trigger.sql and moved create index statements to tab.sql
Rem       pawolf   04/09/2013 - Moved several views from tab.sql to view.sql
Rem       pawolf   04/09/2013 - Added files_version to wwv_flow_plugins (feature #478)
Rem       pawolf   04/11/2013 - Added new table wwv_flow_theme_files and new columns file_prefix and files_version to wwv_flow_themes (feature #1162)
Rem       pawolf   04/16/2013 - Added files_version to wwv_flow_companies and wwv_flow_files (feature #1165)
Rem       cneumuel 04/17/2013 - In wwv_flows: added import_orig_owner (feature #985)
Rem       pawolf   04/18/2013 - Added file_prefix to wwv_flow_files (feature #1165)
Rem       pawolf   04/18/2013 - Added wwv_flow_company_static_files and wwv_flow_static_files (feature #1169)
Rem       hfarrell 04/18/2013 - Added FK constraint wwv_flow_dev_fk2 on wwv_flow_developers to prevent orphaned entries being added
Rem       hfarrell 04/22/2013 - Moved wwv_flow_fnd_user before wwv_flow_developer, due to new FK constraint wwv_flow_dev_fk2 on wwv_flow_developers
Rem       pawolf   04/23/2013 - Removed wwv_flow_image/css/html_repository tables (feature #1169)
Rem       arayner  04/25/2013 - Added property editor tables wwv_pe_* (feature #1129), also corrected alter index statement on wwv_flow_plugin_set_uk (previously altered wwv_flow_plugin_uk mistakingly)
Rem       arayner  04/25/2013 - Added wwv_pe_component_prop_uk constraint, and changed the check constraint wwv_pe_property_max_l_ck to support a larger value (feature #1129)
Rem       arayner  04/29/2013 - Added comments to wwv_pe_property_lov_values (feature #1129)
Rem       arayner  04/29/2013 - Added display condition columns to wwv_pe_property_lov_values (feature #1129)
Rem       arayner  05/02/2013 - Changed one wwv_pe_property_prop_type_ck check constraint value, from INPUT_AID to COMBO_BOX (feature #1129)
Rem       arayner  05/03/2013 - A number of refinements to the Property Editor (wwv_pe_*) data model (feature #1129)
Rem       arayner  05/09/2013 - Added wwv_pe_properties.lov_component_type_on_delete column, defining what happens when a property referenced in the LOV is deleted (feature #1129)
Rem       hfarrell 05/22/2013 - Added page_mode, dialog_title, dialog_width, dialog_maxwidth, dialog_attributes to wwv_flow_steps (feature #587)
Rem       arayner  05/23/2013 - Added wwv_pe_prop_lov_val_uk unique constraint (feature #1129)
Rem       hfarrell 05/23/2013 - Added javascript_dialog_code to wwv_flow_templates (feature #587)
Rem       hfarrell 05/27/2013 - Added dialog_template to wwv_flow_themes (feature #587)
Rem       cneumuel 05/31/2013 - Renamed process point AFTER_AUTHENTICATION to ON_NEW_INSTANCE, added app-level process point and computation point AFTER_LOGIN (feature #861)
Rem       arayner  06/03/2013 - Added columns parent_component_type_id, parent_fk_column, is_page_component to wwv_pe_component_types (feature #1129)
Rem       arayner  06/05/2013 - Added 'SUBSCRIPTION' property_type in wwv_pe_properties, removed all wwv_pe_* comments columns, added wwv_pe_properties.is_translatable column (feature #1129)
Rem       hfarrell 06/05/2013 - Updated wwv_flow_templates to change javascript_dialog_code from clob to varchar2
Rem       hfarrell 06/07/2013 - Added dialog_width and dialog_maxwidth to wwv_flow_templates, to hold default values at template level (feature #587)
Rem       hfarrell 06/07/2013 - Renamed dialog_maxwidth to dialog_max_width in wwv_flow_templates and wwv_flow_steps, dialog_attributes reduced to varchar2(255), javascript_dialog_code to dialog_js_init_code in wwv_flow_templates
Rem       hfarrell 06/07/2013 - Renamed NONMODAL to NON_MODAL in wwv_flow_steps_page_mode check constraint on wwv_flow_steps.page_mode
Rem       hfarrell 06/10/2013 - Added dialog_height to wwv_flow_templates and wwv_flow_steps (feature #587)
Rem       arayner  06/14/2013 - Numerous updates to wwv_pe_* tables (feature #1129)
Rem       cneumuel 06/14/2013 - session data model changes (feature #1149)
Rem       arayner  06/17/2013 - Added validation column to wwv_pe_component_types, and case handling and legacy value columns to wwv_pe_properties (feature #1129)
Rem       arayner  06/18/2013 - Added BUTTON_POSITIONS to lov_type check constraint on wwv_pe_properties table (feature #1129)
Rem       cneumuel 06/19/2013 - compress index wwv_flow_sessions$_idx_timeout (feature #1149)
Rem                           - simplify ddl statements for wwv_flow_collections$ and wwv_flow_collection_members$ (e.g. no conditional code for xmltype column since we require 11g)
Rem       arayner  06/20/2013 - Added LINK_EXTENDED property type to check constraint in wwv_pe_properties, and depending_on_cond_type_check column to wwv_pe_component_props (feature #1129)
Rem       arayner  06/20/2013 - wwv_pe_* changes; added TEXT_RESTRICTED property type, REGION_POSITIONS added to lov_type check constraint, added is_read_only column to comp props (feature #1129)
Rem       hfarrell 06/26/2013 - Renamed dialog_template to default_dialog_template in wwv_flow_themes (feature #587)
Rem       cneumuel 06/26/2013 - Extended wwv_flow_companies.account_status to allow ASSIGN_LCK (bug #17016650)
Rem       cneumuel 07/01/2013 - Added wwv_flow_sessions$.ras_sessionid and wwv_flow_authentications.{ras_mode,ras_dynamic_roles,ras_namespaces} (feature #1152)
Rem       cneumuel 07/04/2013 - Added wwv_flow_session_groups$, wwv_flow_fnd_group_groups (feature #1233)
Rem                           - Moved create index statements to tab.sql
Rem       pawolf   07/18/2013 - Updated property_type to be in sync with attribute type of plug-ins
Rem       cneumuel 07/26/2013 - In wwv_flow_authentications: added virtual column LOGOUT_TYPE, for property editor
Rem                           - In wwv_pe_properties: added is_query_only (for virtual columns)
Rem       pawolf   07/29/2013 - Renamed legacy_value to legacy_values in wwv_pe_properties
Rem       pawolf   07/30/2013 - Removed wwv_pe_component_props.depending_on_cond_type_check, added virtual column button_style for wwv_flow_step_buttons
Rem       hfarrell 07/30/2013 - Added extra_y_axis_min, extra_y_axis_max to wwv_flow_flash_charts_5 ( feature #742)
Rem       msewtz   07/31/2013 - Added javascript_file_urls, javascript_code_onload, css_file_urls, inline_css to wwv_flow_list_templates (feature 1236)
Rem       msewtz   07/31/2013 - Added default_nav_list_template to wwv_flow_themes (feature 1236)
Rem       msewtz   07/31/2013 - Added navigation_list_id to wwv_flow_user_interfaces(feature 1236)
Rem       msewtz   07/31/2013 - Added overwrite_navigation_list, navigation_list_id, navigation_list_template_id to wwv_flow_steps (feature 1236)
Rem       msewtz   08/01/2013 - Added added foreign keys for new list and list template references (feature 1236)
Rem       cneumuel 08/02/2013 - Re-ordered because of dependency issues
Rem       msewtz   08/02/2013 - Added navigation_type to wwv_flow_themes to identify whether tabs or navigation lists are used by theme (feature 1236)
Rem       hfarrell 08/15/2013 - Changed wwv_flow_page_da_events.bind_event_type constraint to include apexclosedialog (feature #1201)
Rem       pawolf   08/16/2013 - Added supported_ui_types to wwv_pe_properties
Rem       cbcho    08/16/2013 - Added stmt_vc2 to wwv_flow_sw_stmts (feature #1257)
Rem       pawolf   08/19/2013 - Changed check constraints of wwv_pe_properties
Rem       pawolf   08/20/2013 - Changed constraint of wwv_flow_step_items.begin_on_new_line and begin_on_new_field to Y and N
Rem       pawolf   08/20/2013 - Added is_internal to wwv_pe_properties
Rem       pawolf   08/20/2013 - Added is_common and supported_ui_types to wwv_flow_plugin_attributes (features# 1270 and 1271)
Rem       cbcho    08/22/2013 - Removed wwv_flow_sw_stmts_idx2 on wwv_flow_sw_stmts (security_group_id) as it not needed with cneumuel recommendation
Rem       cbcho    08/23/2013 - Changed index name wwv_flow_sw_stmts_idx3 to wwv_flow_sw_stmts_idx2 not to have gap
Rem       cneumuel 08/29/2013 - In wwv_flow_sessions$: avoid character ranges in regexp for valid_session_lang (bug #17375236)
Rem       pawolf   09/11/2013 - Added plugin_attributes_seq_offset to wwv_pe_component_types
Rem       arayner  09/12/2013 - Added lov_null_text to wwv_pe_properties (feature #1129)
Rem       hfarrell 09/12/2013 - Added dialog_js_close_code to wwv_flow_templates (feature #1201)
Rem       cneumuel 09/13/2013 - Added component_type, component_id to wwv_flow_session_authz$. Added 'BY_COMPONENT', 'NOCACHE' to wwv_flow_security_schemes.caching (feature #1058)
Rem       cbcho    09/13/2013 - Added wwv_flow_worksheet_pivot and its detail tables (feature #536)
Rem       hfarrell 09/16/2013 - Added dialog_css_classes to wwv_flow_templates and wwv_flow_steps (feature #1204)
Rem       pawolf   09/16/2013 - Added virtual column uniquely_identify_rows_by to wwv_flow_worksheets
Rem       cbcho    09/16/2013 - Added unique index and sequence column in wwv_flow_worksheet_pivot_agg, wwv_flow_worksheet_pivot_sort (feature #536)
Rem       pawolf   09/17/2013 - Added visibility and link_example to wwv_flow_worksheet_rpts
Rem       pawolf   09/17/2013 - Added where_clause to wwv_pe_component_types
Rem                             Added renamed is_unique to check_uniqueness and added nullText in wwv_pe_component_props
Rem                             Added lov_component_type_scope and removed lov_null_text from wwv_pe_properties
Rem       cneumuel 09/18/2013 - In wwv_flow_processing, wwv_flow_step_processing: remove built-in process types PLSQL, PLSQL_JOB, CLOSE_WINDOW (feature #1281)
Rem                           - removed built-in session state page process types
Rem       pawolf   09/18/2013 - Set a default value of 'N' for always_execute in wwv_flow_step_validations
Rem       pawolf   09/23/2013 - Added virtual column lov_type to wwv_flow_step_items
Rem       pawolf   09/25/2013 - Added reference_scope and supports_substitution to wwv_pe_component_props
Rem       pawolf   09/25/2013 - Added singular_title and plural_title to wwv_pe_component_types
Rem       pawolf   09/27/2013 - Added plugin_type and plugin_column to wwv_pe_component_types
Rem       cneumuel 09/30/2013 - In wwv_flow_step_processing: migrated SET_ITEM_USING_STATIC_ASSIGNMENT, SET_ITEM_USING_PLSQL_FUNCTION_BODY, SET_ITEM_USING_PLSQL_EXPRESSION, SET_ITEM_USING_SQL_QUERY, SET_ITEM_USING_SQL_EXPRESSION,
Rem                           - ON_DEMAND, RESET_PAGINATION, MULTI_ROW_UPDATE, MULTI_ROW_DELETE, ADD_ROWS_TO_TABULAR_FORM, RESET_PAGINATION_FOR_REGION, RESET_SORTING_FOR_REGION, DML_FETCH_ROW, DML_PROCESS_ROW, INITIALIZE_SESSION,
Rem                           - INITIALIZE_PAGE_PAGINATION, INITIALIZE_PAGINATION_FOR_ALL_PAGES (feature #1281)
Rem       pawolf   09/30/2013 - Added lov*, set_text_case, null_text and legacy_values to wwv_flow_plugin_attributes
Rem                           - Added display_sequence to wwv_pe_component_types
Rem                           - Added is_searchable to wwv_pe_properties
Rem                           - Added new property type PAGE NUMBERS to wwv_pe_properties and wwv_flow_plugin_attributes
Rem       cneumuel 10/01/2013 - Moved property editor tables up, because of dependency wwv_flow_plugin_attributes -> wwv_pe_component_types
Rem       cbcho    10/01/2013 - Added db_column_name, column_label in wwv_flow_worksheet_pivot_agg and changed wwv_flow_ws_pivot_agg_idx2 to include db_column_name (feature #536)
Rem       cneumuel 10/04/2013 - wwv_flow_plugins: moved obsolete attributes down, wwv_flow_step_processing: removed obsolete builtin process types and moved obsolete attributes down (feature #1281)
Rem       pawolf   10/08/2013 - Added parent_attribute_id and new attribute types to wwv_flow_plugin_attributes and renamed set_text_case to text_case
Rem                           - Added restricted_chars, column_data_types and new property types to wwv_pe_properties
Rem                           - Added parent_comp_prop_id to wwv_pe_component_props
Rem       cneumuel 10/11/2013 - Added wwv_flow_plugin_attr_compon_fx
Rem       cbcho    10/11/2013 - Added show_pivot to wwv_flow_worksheets, added allow_pivot to wwv_flow_worksheet_columns (feature #536)
Rem       cneumuel 10/15/2013 - In wwv_flow_password_history: made wwv_flow_pwhist_uid_fk deferred, added password_hash_function (bug #17214728)
Rem                           - dropped wwv_flow_fnd_user_pw_pref
Rem                           - In wwv_flow_fnd_user: added web_password_hash_function
Rem       pawolf   10/15/2013 - Added plugin_std_attributes to wwv_pe_component_props
Rem                           - Removed not null constraint from wwv_pe_component_props.is_required
Rem       pawolf   10/16/2013 - Added is_legacy to wwv_pe_property_lov_values, wwv_flow_plugins and wwv_flow_plugin_attr_values
Rem                           - Added builder_js_function to wwv_flow_plugins
Rem       cbcho    10/16/2013 - Added default 'N' on show_pivot, allow_pivot (feature #536)
Rem       arayner  10/16/2013 - Added 'RADIOS' to wwv_pe_property_prop_type_ck
Rem       pawolf   10/17/2013 - Added display_column to wwv_pe_component_types
Rem       cneumuel 10/23/2013 - Added wwv_flows.bookmark_checksum_function (feature #1290)
Rem       hfarrell 10/24/2013 - Added dialog_js_cancel_code to wwv_flow_templates (feature #1201)
Rem       pawolf   10/30/2013 - Added BODY to wwv_flow_page_plugs.plug_display_point contraint (feature #1300)
Rem       cneumuel 11/13/2013 - In wwv_flow_page_plugs: added menu_id, list_id. cleaned up indexes (feature #1312)
Rem       hfarrell 11/15/2013 - Changed wwv_flow_page_da_events.bind_event_type constraint to change apexclosedialog to apexafterclosedialog (feature #1201)
Rem       cneumuel 11/20/2013 - In wwv_flow_ui_nav_list_fk: make initially deferred to avoid FK errors during translation publish
Rem       cneumuel 11/22/2013 - In wwv_flow_page_plugs: moved plug_url_text_begin, plug_url_text_end down because they are obsolete (feature #1312)
Rem       pawolf   11/22/2013 - Data model changes in wwv_pe_properties and wwv_pe_component_props
Rem       pawolf   11/25/2013 - Renamed multiple_values to multi_value_delimiter
Rem       cneumuel 11/25/2013 - In wwv_flow_step_buttons: added button_template_id (feature #1314)
Rem       cneumuel 11/28/2013 - (for arayner): added 'TEXTAREA ENHANCED' to wwv_pe_property_prop_type_ck (feature #1129)
Rem       arayner  11/28/2013 - Removed 'TEXTAREA ENHANCED' and added 'TEXT EDITOR' and 'SQL EXPRESSION' to wwv_pe_property_prop_type_ck (feature #1129)
Rem       cneumuel 11/29/2013 - page button migration makes image attributes obsolete, cleaned up indexes (feature #1314)
Rem       pawolf   12/04/2013 - Added missing not null constraints
Rem       pawolf   12/04/2013 - Removed not null constraints of conditional columns
Rem       cneumuel 12/05/2013 - classic reports and tabular forms migration to native plugins (feature #1312)
Rem       pmanirah 12/05/2013 - Added a new column skip_validation to wwv_flow_load_tables (feature #1327)
Rem       cneumuel 12/09/2013 - In wwv_flow_page_plugs: removed plug_source_type DYNAMIC_QUERY
Rem                           - In wwv_flow_step_items: cleaned up indexes
Rem       pawolf   12/09/2013 - Added comment_text to wwv_pe_properties, wwv_pe_property_lov_values and wwv_pe_component_props
Rem       pawolf   12/12/2013 - Added COLOR as property/attribute type to wwv_pe_properties and wwv_flow_plugin_attributes
Rem       pawolf   12/13/2013 - Added LINK as attribute type to wwv_flow_plugin_attributes
Rem       pawolf   12/16/2013 - Changed unique keys of wwv_flow_worksheet_columns and wwv_flow_step_items to deferrable
Rem       pawolf   12/17/2013 - Added HIDDEN as property type to wwv_pe_properties
Rem       cneumuel 12/18/2013 - In wwv_flow_page_plugs: removed plug_source_types STATIC_TEXT, STATIC_TEXT_ESCAPE_SC, STATIC_TEXT_WITH_SHORTCUTS, HTML_TEXT_WITH_SHORTCUTS, PLSQL_PROCEDURE (feature #1327)
Rem       hfarrell 12/19/2013 - Added page_mode to wwv_flow_model_pages
Rem       cneumuel 12/20/2013 - Region type migration to native plugins: charts, calendars, trees (feature #1312)
Rem       msewtz   12/31/2013 - Added column toggle and reflow table to wwv_flow_mp_page_type constraint
Rem       pawolf   01/08/2014 - Changed wwv_flow_plugin_attributes.lov_component_type_id to use a deferrable constraint
Rem       pawolf   01/10/2014 - Added min_value, max_value, unit and examples to wwv_pe_properties
Rem                           - Added XML as property type to wwv_pe_properties
Rem                           - Added CHART_FORMAT_MASKS as lov_type to wwv_pe_properties
Rem                           - Added XML, HTML and JAVASCRIPT as attribute type to wwv_flow_plugin_attributes
Rem       arayner  01/13/2014 - Removd 'REGION SOURCE COLUMN' from wwv_pe_property_prop_type_ck constraint
Rem       pmanirah 01/13/2014 - Updated wwv_flow_load_tables skip_validation column to default 'N' and not null
Rem       cbcho    01/13/2014 - Changed wwv_install_in_export check constraint to include 'I' for 'export and install from command line' option (feature #1248)
Rem       arayner  01/13/2014 - Added 'REDIRECT_APP' to wwv_flow_valid_fbutton_action constraint
Rem       pawolf   01/14/2014 - Added table wwv_flow_combined_files (feature #1340)
Rem       pawolf   01/15/2014 - Added page_id to wwv_flow_combined_files (feature #1340)
Rem       arayner  01/20/2014 - Added MAPS to wwv_pe_property_lov_type_ck
Rem       arayner  01/21/2014 - Removed MAPS from wwv_pe_property_lov_type_ck, no longer needed
Rem       cneumuel 01/22/2014 - Added wwv_flows.http_response_headers (feature #1065)
Rem       msewtz   01/24/2014 - Added wwv_flow_companies.allow_packaged_app_ins_yn (feature 1348)
Rem       cneumuel 01/27/2014 - Added defaults for columns of wwv_flow_steps that were set to not null on 12/04/2013
Rem       arayner  01/28/2014 - Added MAP_REGIONS to wwv_pe_property_lov_type_ck check constraint
Rem       arayner  01/28/2014 - Added POPUP LOV to wwv_pe_property_prop_type_ck check constraint
Rem       pawolf   02/03/2014 - Added EDIT_URL to wwv_pe_component_types
Rem       cneumuel 02/07/2014 - Added wwv_flow_sessiosn$_idx_sgid
Rem       pawolf   02/10/2014 - Added is_quick_pick to wwv_pe_property_lov_values
Rem       msewtz   02/11/2014 - Added before and after element attributes and help link attribute to wwv_flow_field_templates (feature 1377)
Rem       cneumuel 02/13/2014 - In wwv_flows: moved obsolete columns down. changed rejoin_existing_sessions to support session joining (feature #1047)
Rem                           - In wwv_flow_steps: added rejoin_existing_sessions
Rem       pawolf   02/14/2014 - Changed bind_event_type_custom to 130 char
Rem       hfarrell 02/17/2014 - Added profile_image to wwv_flow_fnd_user (feature #1376)
Rem       msewtz   02/17/2014 - Added region_sub_css_classes to wwv_flow_page_plugs
Rem       msewtz   02/17/2014 - Added error_template to wwv_flow_field_templates
Rem       cneumuel 02/20/2014 - In wwv_flows, wwv_flow_steps: added value P to rejoin_existing_sessions (feature #1047)
Rem       pawolf   02/24/2014 - Added help_text to wwv_pe_property_lov_values
Rem       pawolf   02/26/2014 - Removed wwv_flow_plugins.builder_js_function
Rem                           - Added wwv_flow_plugins.is_quick_pick and wwv_flow_plugin_attr_values.is_quick_pick
Rem                           - Added wwv_flow_plugin_attr_values.help_text
Rem                           - Added wwv_flow_plugin_attributes.examples
Rem       pawolf   02/28/2014 - Added wwv_flow_messages$.is_js_message (feature #1279)
Rem       cneumuel 03/05/2014 - Added wwv_flow_sessions$.{max_session_length_sec,max_session_idle_sec} (feature #1323)
Rem       hfarrell 03/05/2014 - Added profile_image columns to wwv_flow_fnd_user (feature #1379)
Rem       pawolf   03/07/2014 - Added pk_column and copy_url to wwv_pe_component_types
Rem       jkallman 03/11/2014 - Removed wwv_flow_developer_log
Rem       msewtz   03/11/2014 - Added wwv_flow_theme_css_classes (feature 1289)
Rem       msewtz   03/12/2014 - Added icon_css_classes to buttons (wwv_flow_step_buttons and wwv_flow_step_items)
Rem       jstraub  03/12/2014 - Added object_owner, object_type, object_name to wwv_flow_install_scripts
Rem       msewtz   03/13/2014 - Replaced wwv_flow_theme_css_classes with wwv_flow_template_options (feature 1394)
Rem       msewtz   03/13/2014 - Added page css classes and template options to wwv_flow_steps (feature 1394)
Rem       msewtz   03/13/2014 - Added region template options and component template options to wvv_flow_page_plugs (feature 1394)
Rem       msewtz   03/13/2014 - Added item_css_classes and template options to wwv_flow_step_items (feature 1394)
Rem       msewtz   03/13/2014 - Added button template options to wwv_flow_step_buttons (feature 1394)
Rem       msewtz   03/13/2014 - Updated wwv_flow_template_options to include virtual columns (feature 1394)
Rem       msewtz   03/13/2014 - Moved wwv_flow_template_options to be created after all template tables (feature 1394)
Rem       cneumuel 03/14/2014 - Added wwv_flows.runtime_api_usage (feature #1277)
Rem       pawolf   02/17/2013 - Added support for region columns (feature #1393)
Rem                           - Added javascript_file_urls and css_file_urls to wwv_flow_plugins (feature #1262)
Rem       msewtz   03/13/2014 - Added reference_id to wwv_flow_template_options
Rem       msewtz   03/20/2014 - Added default_template_options to the page-, region-, report-, list-, breadcrumb-, item- and button tempates (feature 1394)
Rem       pawolf   03/24/2014 - Added TEMPLATE_OPTIONS to wwv_pe_properties (feature #1394)
Rem       jstraub  03/24/2014 - Added wwv_flow_install_objects
Rem       msewtz   03/24/2014 - Added nav_list_template_options to wwv_flow_steps and wwv_flow_user_interfaces (feature #1394)
Rem       hfarrell 03/24/2014 - Added dialog_chained to wwv_flow_steps (feature #1199)
Rem       cbcho    03/24/2014 - Removed visibility, link_example virtual columns from wwv_flow_worksheet_rpts
Rem       cneumuel 03/25/2014 - Renamed FK constraint on wwv_flow_user_interfaces.navigation_list_template_id and added index
Rem       hfarrell 03/26/2014 - Updated dialog_chained column on wwv_flow_steps to allow it to be nullable
Rem       msewtz   03/26/2014 - Added is_default to template_options (feature 1394)
Rem       msewtz   03/27/2014 - Added template options for pages and nav lists to themes (feature 1394)
Rem       cneumuel 03/28/2014 - Removed wwv_flow_user_int_idx6 on wwv_flow_user_interfaces (navigation_list_template_id), since column was removed
Rem       msewtz   03/28/2014 - Added UK constraint to template_options to include CSS_CLASSES
Rem       cneumuel 03/31/2014 - In wwv_flow_step_buttons: added request_source, request_source_type, pre_element_text, post_element_text, cattributes_element, new_grid, begin_on_new_line, begin_on_new_field, colspan, rowspan, grid_column (feature #1314)
Rem       msewtz   04/01/2014 - Added icon CSS classes to regions (feature 1394)
Rem       msewtz   04/01/2014 - Added CSS icon attributes to themes (feature 1394)
Rem       msewtz   03/20/2014 - Added preset_template_options to the page-, region-, report-, list-, breadcrumb-, item- and button tempates (feature 1394)
Rem       cbcho    04/04/2014 - Added wwv_flow_ws_sequences (feature 614)
Rem       msewtz   04/09/2014 - Updated wwv_flow_template_opt_uk2 to include template type and id (feature 1394)
Rem       pawolf   04/11/2014 - Added null_help_text to wwv_pe_component_props
Rem       pawolf   04/11/2014 - Added additional depending_on* to wwv_pe_component_props
Rem       msewtz   04/14/2014 - Updated virtual_template_type in template_options (feature 1394)
Rem       cneumuel 04/17/2014 - In wwv_flow_steps: added cache_mode, made cache_page_yn and cache_by_user_yn obsolete (feature #1401)
Rem                           - In wwv_flow_page_plugs: changed constraint for plug_caching
Rem                           - In wwv_flow_page_cache: simplify data model
Rem       pmanirah 04/21/2014 - Added a new columns glv_new_column to both wwv_flow_plug_tmpl_disp_points and wwv_flow_page_tmpl_disp_points tables
Rem       msewtz   04/23/2014 - Added wwv_flow_template_opt_groups (feature 1394)
Rem       jstraub  04/23/2014 - Added script_option to wwv_flow_install_scripts
Rem       cneumuel 04/24/2014 - Added wwv_flow_page_cache.item_hash and wwv_flow_page_plugs.plug_cache_depends_on_items (feature #1401)
Rem       msewtz   04/23/2014 - Updated wwv_flow_template_opt_groups (feature 1394)
Rem       cneumuel 04/28/2014 - In wwv_flow_messages$: reversed flow_id and name in unique constraint
Rem       asitters 04/29/2014 - Added team_dev_fs_limit (feature 1415)
Rem       pawolf   05/07/2014 - Added wwv_flow_dictionary_views.component_type_id
Rem       pawolf   05/12/2014 - Increased size of wwv_flow_plugin_attributes.lov_component_type_on_delete
Rem       cneumuel 05/12/2014 - In wwv_flow_sessions$: added workspace_user_id, which references the logged in workspace user (bug #18693823)
Rem                           - No FK, because we do not want an additional index
Rem       pawolf   05/21/2014 - Added missing indexes
Rem       pawolf   05/22/2014 - Changed unique constraints on wwv_flow_region_upd_rpt_cols, wwv_flow_region_columns and wwv_flow_worksheet_col_groups to be deferrable
Rem       pawolf   05/23/2014 - Deprecated wwv_flow_templates.has_edit_links
Rem                           - Added wwv_flow_templates.grid_always_emit (feature #1433)
Rem       cneumuel 05/23/2014 - Added wwv_pe_component_props.view_column (feature #1432)
Rem       cneumuel 05/30/2014 - Added wwv_flow_page_cache.{item_sequence_before, item_sequence_after} (feature #1401)
Rem       pmanirah 06/02/2014 - Renamed glv_new_column to glv_new_row (feature #1210)
Rem       jkallman 06/03/2014 - Add instrumentation columns to wwv_flow_mail_log, add mail_message_created to wwv_flow_mail_queue
Rem       cneumuel 06/06/2014 - Added wwv_flow_companies.{max_file_bytes,max_file_count} (feature #1198)
Rem       cneumuel 06/10/2014 - Added index on wwv_flow_plugin_files(security_group_id) (feature #1198)
Rem       cneumuel 06/11/2014 - Removed wwv_flow_companies.max_file_count (feature #1198)
Rem       jkallman 06/12/2014 - Added wwv_flow_companies.max_email_messages (feature #1037)
Rem       pawolf   06/13/2014 - Added COMPONENT as property_type/attribute_type to wwv_pe_properties and wwv_flow_plugin_attributes
Rem       pawolf   07/04/2014 - Added JAVASCRIPT_EXPRESSION to dynamic action and dynamic action event (feature #1450)
Rem       pawolf   07/07/2014 - Increased size of wwv_pe_component_props.default_value to 4000 to match with wwv_flow_plugin_attributes.default_value
Rem       msewtz   07/10/2014 - Added theme roller columns to wwv_flow_theme_styles
Rem       msewtz   07/10/2014 - Removed template option defaults from wwv_flow_themes
Rem       msewtz   07/10/2014 - Added icon class colums to wwv_flow_themes
Rem       cbcho    07/11/2014 - Added wwv_flow_lock_script, wwv_flow_lock_script_log (feature #1449)
Rem       hfarrell 07/14/2014 - Added dialog_browser_frame to wwv_flow_templates
Rem       hfarrell 07/18/2014 - Added constraint on dialog_browser_frame to wwv_flow_templates
Rem       cbcho    07/18/2014 - Added script_id in wwv_flow_lock_script_log (feature #1449)
Rem       pawolf   07/22/2014 - Added wwv_flow_plugin_attributes.show_in_wizard
Rem                           - Renamed legacy column in plug-in and property tables to deprecated
Rem       pmanirah 07/23/2014 - Added default_dialog_btr_template to wwv_flow_themes
Rem       pawolf   07/25/2014 - Moved content_delivery_network, javascript_file_urls and include_legacy_javascript from wwv_flows into wwv_flow_user_interfaces (feature #1464)
Rem       cneumuel 07/31/2014 - Removed wwv_flow_dual100
Rem       davgale  08/06/2014 - Added navigation list position columns to wwv_flow_user_interfaces, wwv_flow_themes, and wwv_flow_steps (feature 1472)
Rem       cneumuel 08/07/2014 - Corrected invalid column name in wwv_flow_user_int_idx6
Rem       pawolf   08/14/2014 - Added include_jquery_migrate to wwv_flow_user_interfaces (feature #1475)
Rem       vuvarov  08/21/2014 - Deferred wwv_flow_ui_list_template_fk constraint
Rem       pawolf   09/29/2014 - Added ICON as valid property type for wwv_flow_properties.property_type (feature #1485)
Rem       pawolf   10/01/2014 - Added javascript_file_urls and css_file_urls to wwv_flow_themes (feature #1484)
Rem       pawolf   10/10/2014 - Added create_url to wwv_pe_component_types
Rem       hfarrell 10/13/2014 - Updated wwv_flow_standard_icons: added support for Font Awesome css classes - added icon_library,icon_category, removed not null setting on icon_size
Rem       hfarrell 10/14/2014 - Added navigation bar-related columns to wwv_flow_user_interfaces: nav_bar_type, nav_bar_list_id, nav_bar_list_template_id, nav_bar_template_options (feature #1536)
Rem       hfarrell 10/16/2014 - Updated wwv_flow_user_interfaces.nav_bar_type - set to not null
Rem       hfarrell 10/20/2014 - Added default_nav_bar_list_template to wwv_flow_themes (feature #1536)
Rem       cneumuel 10/22/2014 - Added wwv_flows.import_orig_release (feature #1539)
Rem       hfarrell 10/22/2014 - Added nav_bar_type to wwv_flow_themes (feature #1536)
Rem       arayner  10/28/2014 - Commented wwv_flow_worksheets columns button_template, actions_menu_icon and finder_icon as obsolete (feature #577)
Rem       pawolf   11/03/2014 - Added new attribute types to wwv_flow_plugin_attributes (feature #1284)
Rem       msewtz   11/03/2014 - Added new a01_label to a20_label columns to wwv_flow_list_tempates (feature #1567)
Rem       cneumuel 11/06/2014 - Added wwv_flow_platform_prefs.{created_on,last_updated_on} (feature #1153)
Rem       pawolf   11/11/2014 - Added wwv_flow_themes.custom_icon_prefix_class (feature #1574)
Rem       pawolf   11/12/2014 - Added wwv_flow_plugin_attributes.reference_scope (feature #1596)
Rem       cneumuel 11/17/2014 - In wwv_flow_log_numbers: removed accidentally added log_name
Rem       pawolf   11/27/2014 - Added wwv_flow_step_items.grid_label_column_span and wwv_flow_templates.grid_default_label_col_span (feature #1615)
Rem                           - Added static_id and css_classes to wwv_flow_worksheet_columns (feature #1457)
Rem       arayner  11/28/2014 - Added fixed_header to wwv_flow_worksheet and wwv_flow_page_plugs (feature #1534)
Rem       cneumuel 12/01/2014 - In wwv_flow_plugin_attributes: add type AUTHORIZATION GROUP
Rem       cneumuel 12/01/2014 - In wwv_flow_activity_log[12]$: add page_view_type, request_value, debug_page_view_id (feature #1599)
Rem       arayner  12/02/2014 - Resized fixed_header columns and added NONE to check constraints in wwv_flow_worksheets and wwv_flow_page_plugs. In wwv_flow_worksheets, made the column not null (feature #1534)
Rem       arayner  12/03/2014 - Added fixed_header_region_height to wwv_flow_worksheet and wwv_flow_page_plugs (feature #1534)
Rem       arayner  12/03/2014 - Renamed fixed_header_region_height to fixed_header_max_height (feature #1534)
Rem       pawolf   12/04/2014 - Added grid_column_css_classes to wwv_flow_page_plugs, wwv_flow_step_items and wwv_flow_step_buttons (feature #1466)
Rem       pawolf   12/08/2014 - Added wwv_flows.shared_components_scn and wwv_flow_steps.page_components_scn (feature #1623 and #1624)
Rem       pawolf   12/09/2014 - Removed a number of NN constraint from created_on and created_by from different tables (feature #1624)
Rem       hfarrell 12/10/2014 - In wwv_flow_themes: added default_dialogr_template, default_dialogbtnr_template for setting dialog content region template
Rem       hfarrell 12/11/2014 - In wwv_flow_themes: removed default_dialog_btr_template (verified by pmanirah that it is not required)
Rem       hfarrell 12/12/2014 - In wwv_flow_themes: reinstated default_dialog_template
Rem       msewtz   01/09/2015 - Removed not null constraint from wwv_flow_theme_styles.css_file_urls
Rem       jstraub  01/09/2015 - Removed wwv_flow_query_definition, wwv_flow_query_object, wwv_flow_query_column, wwv_flow_query_condition
Rem       cneumuel 02/04/2015 - In wwv_flow_fnd_user, wwv_flow_password_history: added password version column; added name for hash function constraint (bug #20462973)
Rem       cneumuel 02/09/2015 - In wwv_flow_fnd_user, wwv_flow_password_history: removed password hash function column, value is in password version (bug #20462973)
Rem       pawolf   02/12/2015 - In wwv_pe_properties: added US_ONLY_UNDERSCORE_NO_SPACE to restricted_characters (bug #20530199)
Rem       cneumuel 03/04/2015 - In wwv_flow_icon_bar: defaulted nav_entry_is_feedback_yn to N (bug #20637190)
Rem       cneumuel 03/05/2015 - In wwv_flow_steps.dialog_chained: changed column default to 'Y' (bug #20637237)
Rem       pawolf   03/15/2015 - In wwv_flow_step_items: Changed WWV_FSITEM_LABEL_COLSPAN_CK to allow 0 (bug #20707986)
Rem       msewtz   04/01/2015 - Updated wwv_flow_template_options.virtual_template_type to return the proper type for global options (bug 20815322)
Rem       msewtz   05/08/2015 - Added index wwv_flow_template_options_idx9 to wwv_flow_template_options (bug 21026665)
Rem       hfarrell 07/14/2015 - Updated comment on wwv_flow_plugins.ajax_function: changed AJAX to Ajax in display values and help text (bug #20200008)
Rem       cneumuel 07/21/2015 - In wwv_flow_page_plugs: added name for FK constraints to wwv_flow_menus and wwv_flow_lists (bug #21464312)
Rem       msewtz   08/20/2015 - Added direction_right_to_left to wwv_flows and wwv_flow_language_map (feature 1046)
Rem       hfarrell 09/01/2015 - Added wwv_flow_jet_charts, wwv_flow_jet_chart_series, wwv_flow_jet_chart_axes (feature 1837)
Rem       cneumuel 09/17/2015 - Dropped wwv_flow_entry_points, wwv_flow_entry_point_args, wwv_flow_file_objects$part, wwv_flow_hnt_argument_info, wwv_flow_hnt_procedure_info, wwv_flow_icon_bar_attributes,
Rem                           - wwv_flow_import_export, wwv_flow_online_help, wwv_flow_online_help_ja, wwv_flow_region_report_filter, wwv_flow_shortcut_usage_map, wwv_flow_standard_css, wwv_flow_standard_js,
Rem                           - wwv_flow_sw_binds, wwv_flow_template_themes$, wwv_flow_upg_col_name_changes, wwv_flow_upg_tab_name_changes, wwv_flow_upg_tab_obsolete, wwv_flow_version$,
Rem                           - wwv_flow_workspace_summary, wwv_flow_effective_userid_map, wwv_flow_developer_roles, wwv_flow_sw_set_keywords, wwv_flow_sw_create_keywords,
Rem                           - wwv_flow_lov_values, wwv_flow_templates$, wwv_flow_template_preferences, wwv_flow_required_roles (bug #20197863)
Rem       cneumuel 09/18/2015 - Drop redundant indexes wwv_flow_adv_chk_msg_chk_idx1, wwv_flow_fl_ch_fid_fk2, wwv_flow_flch5_fid_fk2, wwv_flow_hnt_groups_idx1, wwv_flow_items_idx2, jet_series_idx,
Rem                           - wwv_flow_load_tab_lk_idx1, wwv_flow_load_tab_rule_idx1, wwv_flow_lock_script_idx3, wwv_flow_page_id_idx1, wwv_flow_step_branches_idx1, wwv_flow_step_branches_idx2,
Rem                           - wwv_flow_step_comp_idx1, wwv_flow_step_comp_idx2, wwv_flow_step_processing_idx1, wwv_flow_step_processing_idx2, wwv_flow_step_validations_idx1, wwv_flow_step_validations_idx2,
Rem                           - wwv_flow_sw_d_result_idx2, wwv_flow_sw_result_idx2, wwv_flow_translatable_key, wwv_flow_builder_features_idx1, wwv_flow_ws_pivot_agg_idx1,
Rem                           - wwv_pe_comp_prop_comp_type_fx, wwv_pe_prop_lov_val_prop_fx, wwv_flow_ws_pivot_sort_idx1 (bug #20263242)
Rem       hfarrell 09/24/2015 - Added value_min to wwv_flow_jet_charts
Rem       hfarrell 09/25/2015 - Added dial_background to wwv_flow_jet_charts, and modified check constraints for stack,legend_rendered,overview_rendered,
Rem       pawolf   10/13/2015 - Added item type plug-in enhancements for Interactive Grid Columns (feature #1876)
Rem       pawolf   10/16/2015 - Added wwv_flow_interactive_grid (feature #1215)
Rem       pawolf   10/19/2015 - Added new columns to wwv_flow_region_columns (feature #1215)
Rem       pawolf   10/23/2015 - Moved wwv_flow_interactive_grids.parent_grid_region_id to wwv_flow_page_plugs.master_region_id (feature #1215)
Rem       cbcho    10/27/2015 - Changed wwv_flow_region_columns to rename lov_query to lov_source and added item_css_classes, item_attributes (feature #1215)
Rem                           - Changed wwv_flow_interactive_grid to rename icon_view_link_column to icon_view_link_target (feature #1215)
Rem       cbcho    11/04/2015 - Changed wwv_flow_interactive_grids, pagination_type not null and added NONE in the check constraint list (feature #1215)
Rem       hfarrell 11/11/2015 - Added legend_title to wwv_flow_jet_charts (feature #1837)
Rem       hfarrell 11/12/2015 - Set define off at top of file, to resolve install issues with check constraint ig_edit_operations_ck. Moved original set define to bottom of file.
Rem       hfarrell 11/12/2015 - Set define reinstated at top of file - required for wwv_flow_job_bind_values. Introduced define caret, for use in check constraint ig_edit_operations_ck
Rem       pawolf   11/13/2015 - Removed NN constraint from new wwv_flow_region_columns columns
Rem       vuvarov  11/22/2015 - Disabled 'set define' at the top, enabled for wwv_flow_job_bind_values
Rem       hfarrell 11/25/2015 - Added range_chart to wwv_flow_jet_charts
Rem       pawolf   11/27/2015 - Added wwv_flow_ig_report* tables (feature #1215)
Rem       pawolf   11/30/2015 - Redefined wwv_flow_ig_report* tables
Rem       hfarrell 12/04/2015 - Updated wwv_flow_jet_charts: overview_rendered, legend_rendered to remove not null; added pie_inner_radius (for donut chart)
Rem       pawolf   12/11/2015 - wwv_pe_component_props: added depending_on_has_to_exist* (feature #1927)
Rem       hfarrell 12/11/2015 - Updated wwv_flow_jet_chart_series: added pie_slice_explode; added constraints jet_charts_pie_radius, and jet_charts_pie_other
Rem       hfarrell 12/15/2015 - JET Chart-related changes: new chart type support; removal of unrequired attributes
Rem       jkallman 01/14/2016 - Added wwv_flow_log_history_idx2 (in support of statistics REST services)
Rem       hfarrell 01/14/2016 - Updated wwv_flow_jet_charts: removed 'not null' from show_value and show_label - not required if using custom tooltip
Rem       hfarrell 01/20/2016 - Updated JET chart constraints to support JET 1.2.0: jet_series_line_type,jet_series_marker,jet_series_label_position,jet_charts_axis
Rem       hfarrell 01/21/2016 - Updated constraint wwv_pe_property_prop_type_ck on wwv_pe_properties to include PLSQL FUNCTION BODY SQL (for Patrick)
Rem       hfarrell 01/21/2016 - Updated wwv_flow_jet_charts - allow tooltip_rendered be null, for dial charts
Rem       cneumuel 01/26/2016 - Added wwv_flow_sessions$.{debug_level,trace_mode (feature #1756)
Rem       pawolf   01/28/2016 - Added wwv_flow_region_columns.filter_date_ranges
Rem       pawolf   01/29/2016 - Fixed constraint of wwv_flow_interactive_grids.fixed_header
Rem       cbcho    01/29/2016 - Added missing fk index on wwv_flow_ig_report_computes
Rem       hfarrell 02/01/2016 - Extended format_type columns for JET charts
Rem       hfarrell 02/08/2016 - Added items_min_value to wwv_flow_jet_chart_series
Rem       hfarrell 02/11/2016 - Added value_text_type to wwv_flow_jet_charts for dial chart support; removed value_prefix,value_postfix; Removed prefix,postfix from wwv_flow_jet_chart_axes
Rem       hfarrell 02/12/2016 - Added format_scaling to wwv_flow_jet_chart_axes - to support more granular formatting of axis labels
Rem       cbcho    02/12/2016 - Added static_id in wwv_flow_ig_reports
Rem       pawolf   02/22/2016 - Added RELOAD_ON_SUBMIT to wwv_flow_steps
Rem       pawolf   03/09/2016 - Added Font APEX icon library support (feature #1851)
Rem       jkallman 03/15/2016 - Added flow_id to wwv_flow_mail_queue, wwv_flow_mail_log
Rem       hfarrell 03/21/2016 - Added JET Chart-related columns to wwv_flow_model_page_regions
Rem       pawolf   03/22/2016 - Added wwv_flow_plugin_attributes.depending_on_has_to_exist (feature #1974)
Rem       cneumuel 04/01/2016 - Added wwv_flow_companies.clone_session_yn. In wwv_flow_sessions$: cookie_value not unique but indexed (feature #1154)
Rem       pawolf   04/04/2016 - In wwv_flow_ig_report_aggregates: renamed label to tooltip
Rem       pawolf   04/08/2016 - In wwv_flow_ig_reports: added current_view, in wwv_flow_ig_report_views: removed is_current
Rem       pawolf   04/11/2016 - In wwv_flow_steps: added warn_on_unsaved_changes (feature #1652)
Rem       cbcho    04/11/2016 - In wwv_flow_model_page_regions: added IG in wwv_flow_mpr_rpt_impl_type check constraint
Rem       pawolf   04/13/2016 - In wwv_flow_plugins: added is_legacy
Rem       pawolf   04/13/2016 - In wwv_flow_step_items and wwv_flow_step_buttons: added warn_on_unsaved_changes (feature #1652)
Rem       cczarski 04/14/2016 - In wwv_flow_log_history: added public_page_events and workspace_login_events
Rem       pawolf   04/17/2016 - In wwv_flows: added compatibility_mode 5.1
Rem       hfarrell 04/20/2016 - Added zoom direction support for JET charts (direct upgrade option for AnyChart Scrollbar attribute)
Rem       pawolf   04/25/2016 - In wwv_flow_region_columns: added LOV as valid entry for column filter_lov_type
Rem       cczarski 05/02/2016 - added item_icon_css_classes for wwv_flow_step_items and wwv_flow_region_columns
Rem       cczarski 05/02/2016 - added inline_help_text for wwv_flow_step_items and wwv_flow_field_templates
Rem       pawolf   05/04/2016 - In wwv_pe_component_props: added examples
Rem       cczarski 05/11/2016 - In wwv_flow_field_templates: Add ITEM_PRE_TEXT and ITEM_POST_TEXT (Feature #1998)
Rem       hfarrell 05/20/2016 - In wwv_flow_jet_charts: added no_data_found_message
Rem       pawolf   05/21/2016 - In wwv_flow_page_code_cache: increased type to varchar2(20) (bug #23272227)
Rem       arayner  06/09/2016 - Added wwv_flow_page_da_events.condition_based_on (feature #825)
Rem       cczarski 06/09/2016 - Add PLUGIN_INIT_JAVASCRIPT_CODE column to WWV_FLOW_STEP_ITEM, wwv_flow_region_columns, WWV_FLOW_PAGE_PLUG and WWV_FLOW_PAGE_DA_ACTION (Feature #2018)
Rem       cczarski 06/10/2016 - Add table wwv_flow_plugin_std_attributes to store addional metadata for standard attributes (Feature #2018)
Rem       cneumuel 06/13/2016 - Moved wwv_flow_plugin_std_attributes down because of dependencies on wwv_flow_plugin_attributes
Rem       arayner  06/13/2016 - Removed condition_based_on, renamed condition_page_item to be condition_element, added condition_element_type to wwv_flow_page_da_events (feature #825)
Rem       cneumuel 06/14/2016 - Backed out local, untested changes to wwv_flow_activity_log% that were committed with previous checkin
Rem       arayner  06/14/2016 - Change string size of wwv_flow_page_da_events.condition_element_type to 6 bytes (feature #825)
Rem       cczarski 06/15/2016 - Changes to wwv_flow_plugin_std_attribute as per discussion with Patrick
Rem       cczarski 06/16/2016 - marked sql_min_columns, max_columns and examples in wwv_flow_plugins as deprected.
Rem       pawolf   06/22/2016 - In wwv_flow_standard_icons: added icon_filters
Rem       cczarski 06/23/2016 - In wwv_flow_log_history: added application_name and workspace_name
Rem       hfarrell 06/23/2016 - In wwv_flow_jet_charts: added initial_zooming (request from Marc)
Rem       pawolf   06/24/2016 - In wwv_flow_patches: added on_upgrade_keep_status (feature #2026)
Rem       cczarski 07/06/2016 - In wwv_flows: added favicons (feature #1702)
Rem       cczarski 07/06/2016 - In wwv_flows: added app_builder_icon_name (feature #1978)
Rem       cneumuel 07/06/2016 - Removed wwv_flow_companies.clone_session_yn
Rem       cczarski 07/07/2016 - Add support for end-user customization of Theme Styles (feature #1992)
Rem       cczarski 07/08/2016 - move style_by_user_preference from wwv_flow_themes to wwv_flow_user_interfaces
Rem       hfarrell 07/19/2016 - In wwv_flow_ig_report_chart_cols: updated column_type constraint, removed sort_nulls
Rem                             In wwv_flow_ig_report_views: updated chart_type constraint, removed chart_series_type, renamed axis columns
Rem       cczarski 07/19/2016 - add build options to classic report, ir and ig columns (feature #1955)
Rem       hfarrell 07/20/2016 - In wwv_flow_ig_report_chart_cols: reinstated sort_nulls; In wwv_flow_ig_report_views: renamed axes columns
Rem       msewtz   07/21/2016 - Added internal_name column to theme and template tables (feature 2040)
Rem       pawolf   08/02/2016 - In wwv_flow_interactive_grids: added oracle_text_index_column
Rem       cczarski 08/05/2016 - In wwv_flow_row_templates and _plug_templates: Added columns for CSS Files, JS Files and Onload JS (Feature #2042)
Rem       cneumuel 08/12/2016 - Removed wwv_flow_jobs, wwv_flow_job_bind_values (feature #2046)
Rem       cneumuel 08/17/2016 - Added set define '^' at end (feature #2046)
Rem       pawolf   08/25/2016 - In wwv_pe_properties: added COLUMN to lov_component_type_scope constraint
Rem       pawolf   09/08/2016 - In wwv_flow_plugins: renamed sql_function to meta_data_function
Rem       pawolf   10/06/2016 - In wwv_flow_ig_report_aggregates: removed APPROX_COUNT_DISTINCT (bug #349)
Rem       jkallman 10/14/2016 - Adjust varchar2(2000) columns to varchar2(4000) in wwv_flow_mail_queue & wwv_flow_mail_log
Rem       jkallman 10/28/2016 - Added mail_id to wwv_flow_mail_log (Bug 15966408)
Rem       cneumuel 11/25/2016 - Index compression for wwv_flow_builder_audit_trail,wwv_flow_log_history,wwv_flow_templates,wwv_flow_preferences$
Rem       cneumuel 02/06/2017 - Added mail_message_id to wwv_flow_mail_log (bug #25311325)
Rem       msewtz   02/24/2017 - Added static ID to classic report columns (bug #20756299)
Rem       pawolf   03/07/2017 - Added wwv_flow_credentials, wwv_flow_credential_instances and wwv_flow_remote_servers (feature #2109)
Rem       pawolf   03/13/2017 - In wwv_flow_page_plugs: added columns for remote sql (feature #2109)
Rem       pawolf   03/16/2017 - In wwv_flow_plugin_std_attributes: added SOURCE_LOCATION to constraint (feature #2109)
Rem       hfarrell 03/20/2017 - Added pyramid JET chart to jet_series_type and jet_chart_type constraints
Rem       msewtz   04/13/2017 - Removed on delete set null from user interface foreig key constraints (bug 22090477)
Rem       cczarski 05/05/2017 - Added tables for web source consumption (feature #2092)
Rem       cczarski 05/05/2017 - Added columns for different authentication server to wwv_flow_web_src_modules (feature #2092)
Rem       hfarrell 05/22/2017 - Added Box Plot JET chart to jet_series_type and jet_chart_type constraints (5.2 feature #2145)
Rem       cczarski 06/01/2017 - smaller data model adjustments for REST consumption (feature #2092)
Rem       hfarrell 06/14/2017 - Added Box Plot column mappings to wwv_flow_jet_chart_series table (5.2 feature #2145)
Rem       pawolf   06/16/2017 - Added 'WHERE CLAUSE' and 'ORDER BY CLAUSE' to wwv_pe_property_prop_type_ck
Rem       pawolf   06/16/2017 - Added 'REGION COLUMN' to wwv_pe_property_prop_type_ck
Rem       cbcho    06/27/2017 - Added on delete set null in wwv_flow_region_columns lov_id, filter_lov_id FK (bug #26352078)
Rem       cneumuel 06/29/2017 - In wwv_flow_plugin_attributes: attribute type CREDENTIAL_ID (feature #561)
Rem                           - In wwv_flow_authentications: credential_id for social login (feature #561)
Rem       cneumuel 07/04/2017 - In wwv_flow_credential_instances: value v2(4000) to support longer id tokens (feature #561)
Rem       cczarski 07/18/2017 - Added wwv_flow_web_src_operations.legacy_ords_fixed_page_size and wwv_flow_data_profile_cols.is_hidden (feature #2092)
Rem       hfarrell 07/19/2017 - In wwv_flow_jet_chart_series: removed box plot quartile columns - not required;in wwv_flow_jet_charts: added connect_nulls
Rem       cneumuel 07/26/2017 - Added wwv_flow_sessions$.authentication_id (feature #561)
Rem                           - Added wwv_flow_authentications.switch_in_session_yn (feature #1975)
Rem       pawolf   07/28/2017 - Added wwv_flow_page_plugs.optimizer_hint (feature #1107)
Rem       cbcho    08/04/2017 - Removed delete set null from wwv_flow_region_columns lov_id, filter_lov_id FK (bug #26352078)
Rem       hfarrell 08/10/2017 - In wwv_flow_jet_chart_series: added q2_color, q3_color (5.2 feature #1245)
Rem       jstraub  08/16/2017 - Change storage option of xmltype in wwv_flow_collection_members$ based on whether XDB installed
Rem       pawolf   08/25/2017 - Added wwv_flow_page_plugs.include_rowid_column (feature #2109)
Rem       cczarski 08/28/2017 - Added missing FK indexes on web source tables (feature #2092, #2109)
Rem       cczarski 09/04/2017 - Added columns for "fetch all rows" support in wwv_flow_web_src_modules (feature #2092)
Rem                             Added sql_expression column to wwv_flow_data_profile_cols
Rem       pawolf   09/13/2017 - Added DEPRECATED_LINK_COLUMN to wwv_flow_jet_chart_series.link_target_type to support migration of HTML/SVG charts
Rem       cczarski 09/13/2017 - Enabled CLOB data type for data profile columns
Rem       hfarrell 10/02/2017 - Added Gantt JET chart support (5.2 feature #2126)
Rem       cczarski 10/04/2017 - In wwv_flow_web_src_comp_params: Added 'COLLECTION' to list of parameter value types
Rem       cczarski 10/05/2017 - In wwv_flow_web_src_comp_params: Added page_id; changes STATIC_WITH_SUBSTITUTION TO STATIC
Rem       cczarski 10/06/2017 - In wwv_flow_remote_servers: Added column to store the ORDS time zone (feature #2109).
Rem       cczarski 10/11/2017 - In wwv_flow_web_src_params: Added type 'COOKIE'
Rem       cneumuel 10/17/2017 - In log tables, remove obsolete maxtrans. set pctfree 0 for insert-only tables.
Rem       pawolf   10/24/2017 - In wwv_flow_step_computations.computation_type: added SET_ITEM_EQUAL_THIS_PREFERENCE to constraint (bug# 26401658)
Rem       cczarski 11/14/2017 - change wwv_flow_credentials to store credentials at workspace level (feature #2109, #2092)
Rem       cczarski 11/15/2017 - change wwv_flow_remote_servers to store remote servers at workspace level (feature #2109, #2092)
Rem       hfarrell 11/15/2017 - In wwv_flow_jet_chart_series: add support for Remote SQL columns (feature #2109)
Rem       hfarrell 11/16/2017 - Added missing comma after jet column remote_sql_invalidate_when
Rem       hfarrell 11/17/2017 - In wwv_flow_jet_charts: revised constraint jet_chart_sorting for handling value and label sorting
Rem       cbcho    11/21/2017 - Added wwv_flow_cons_sync$ (feature #2228)
Rem       jstraub  11/21/2017 - Added wwv_flow_webservice_log[12]$ (feature #2233)
Rem       hfarrell 11/22/2017 - Updated wwv_flow_jet_chart_series.gantt_progress_column from number to varchar2
Rem       cczarski 11/27/2017 - added ON DELETE CASCADE to Workspace Foreign keys of WWV_CREDENTIAL, WWV_REMOTE_SERVERS and WWV_CREDENTIAL_INSTANCES
Rem       hfarrell 11/27/2017 - Updated wwv_flow_jet_chart_axes.axis - increased size to support additional constraint options (feature #2126)
Rem       cczarski 11/28/2017 - Added wwv_flows.no_proxy_domains (feature #2249)
Rem       cneumuel 11/28/2017 - In wwv_flow_page_cache: FK to steps, not flows; removed obsolete item_sequence_before/item_sequence_after/cached_by; changed indexes (bug #27098205)
Rem       cczarski 12/04/2017 - Added wwv_flow_jet_chart_series.aggregate_function and wwv_flow_jet_chart_series.include_rowid_column (feature #2235)
Rem       jstraub  12/05/2017 - Added wwv_flow_companies.webservice_logging_yn and max_webservice_requests (feature #2233)
Rem       cczarski 12/06/2017 - Added wwv_flow_web_src_comp_params.jet_chart_series_id (feature #2235)
Rem       cneumuel 12/11/2017 - In wwv_flow_activity_logN$: added ecid and time_stamp_tz, removed component_type, component_name, component_attribute, information, application_info (feature #1878)
Rem       hfarrell 12/14/2017 - wwv_flow_jet_chart_series: added viewport page item handling for gantt charts; removed start_date_value and end_date_value unused columns
Rem       jstraub  12/14/2017 - Added wwv_flow_webservice_log[12]$.status_code, elapsed_sec
Rem       cczarski 12/18/2017 - Added wwv_flow_companies.content_cache_size_target and wwv_flow_companies.content_cache_max_file_size (feature #2092, #2109)
Rem                           - Added table wwv_flow_content_cache1$ for web source and remote SQL caching
Rem       cczarski 12/19/2017 - Added pass_ecid and static_id to wwv_flow_web_src_modules
Rem                             Added source_post_processing, external_filter_expr and external_order_by_expr to wwv_flow_page_plugs and wwv_flow_jet_chart_series
Rem       cbcho    12/21/2017 - Added wwv_flow_app_settings (feature #2257)
Rem       hfarrell 01/04/2018 - Resolve unindexed foreign key errors in Hudson: WWV_FLOW_CONTENT_CACHE1$.FLOW_ID and WWV_FLOW_WEB_SRC_COMP_PARAMS.JET_CHART_SERIES_ID
Rem       cbcho    01/04/2018 - Added is_required, valid_values in wwv_flow_app_settings (feature #2257)
Rem       cbcho    01/04/2018 - Added wwv_flow_email_templates (feature #2261)
Rem       hfarrell 01/05/2018 - Updated wwv_flow_email_templates: renamed constraint name from wwv_flow_email_templates_sgid_fk to wwv_flow_email_temp_sgid_fk; removed newline before column html_template
Rem       hfarrell 01/05/2018 - Updated wwv_flow_jet_chart_series: added gantt chart css class name support for task, baseline and progress bars
Rem       cczarski 01/08/2018 - Updated wwv_flow_web_src_modules: Changed ORACLE_SAAS web service type to ADFBC
Rem       hfarrell 01/11/2018 - In wwv_flow_worksheet_rpts: added chart_orientation (feature #1840)
Rem       pawolf   01/16/2018 - In wwv_flow_user_interfaces: changed include_legacy_javascript from a flag to checkbox values (feature #2223)
Rem       hfarrell 01/16/2018 - In wwv_flow_jet_chart_series: add items_label_display_as for flexibility with pie/donut charts
Rem       mhichwa  01/16/2018 - added wwv_flow_app_acl_users and wwv_flow_app_acl_roles tables with on delete cascade of flow id
Rem       sbkenned 01/16/2018 - added wwv_flow_feedback.feedback_rating
Rem       hfarrell 01/17/2018 - In wwv_flow_jet_chart_series: extended constraint jet_series_label_display_as
Rem       cczarski 01/19/2018 - Increased VARCHAR2 limit of wwv_remote_servers.server_type to 14 (as required)
Rem       mhichwa  01/19/2018 - changed wwv_flow_app_acl_usr_name_uk to include role_id to allow one user to have more then one role
Rem       cneumuel 01/22/2018 - In wwv_flow_plugin_attributes: attribute_type 'AUTHORIZATION GROUP' changed to 'AUTHORIZATION GROUPS'
Rem       cbcho    01/22/2018 - In wwv_flow_app_settings: added on_upgrade_keep_value (feature #2257)
Rem       sbkenned 01/22/2018 - updated wwv_flow_email_templates to reflect revised feature
Rem       cneumuel 01/23/2018 - In wwv_flow_companies: added cookie_name. In wwv_flow_authentications: added cookie_type (feature #1609)
Rem       pawolf   01/24/2018 - In wwv_pe_properties*: added PILL BUTTONS type and icon column
Rem       cbcho    01/24/2018 - In wwv_flow_app_settings: added required_patch (feature #2257)
Rem       cneumuel 01/26/2018 - In wwv_flow_patches: added feature_identifier
Rem       cneumuel 01/26/2018 - Added wwv_flows.populate_roles, wwv_flow_fnd_user_groups.flow_id, wwv_flow_acl_group_users. Removed wwv_flow_app_acl_roles, wwv_flow_app_acl_users (feature #2268)
Rem       pawolf   01/30/2018 - In wwv_flow_fnd_user_groups: added static_id (feature #2268)
Rem       arayner  01/30/2018 - In wwv_flow_page_da_events: added Hammer events to wwv_flow_page_da_e_btype_ck check constraint (feature #2124)
Rem       mhichwa  01/30/2018 - Added additional_attributes column to wwv_flow_log_history (feature #2286)
Rem       mhichwa  01/30/2018 - Added javascript_inline column to WWV_FLOW_USER_INTERFACES (feature #2287)
Rem       pawolf   02/01/2018 - Added stretch to wwv_flow_region_columns and wwv_flow_ig_report_views (feature #2147)
Rem       hfarrell 02/01/2018 - Added fill_multi_series_gaps to wwv_flow_jet_charts (feature #2246)
Rem       pawolf   02/02/2018 - In wwv_flow_user_interfaces: added built_with_love (feature #2191)
Rem       cneumuel 02/08/2018 - In wwv_flow_acl_group_users: added audit columns
Rem       cczarski 02/09/2018 - In wwv_flow_data_profile_cols: extended constraint to allow "DOCUMENT_FRAGMENT" type
Rem       pawolf   02/28/2018 - In wwv_flow_email_templates: added subject (feature #2261)
Rem       pawolf   03/05/2018 - Added SQL EXPRESSION BOOLEAN to distinquish from a SQL EXPRESSION which returns a value (bug #26904608)
Rem       cbcho    03/08/2018 - Added ig_rpt_name_uix unique index on wwv_flow_ig_reports (bug #27024669)
Rem                           - Changed wwv_flow_ig_report_computes.comp_column_id FK constraint as deferrable (bug #27024669)
Rem       cbcho    03/09/2018 - Changed wwv_flow_ig_reports unique index to ig_rpt_name_uk and included base_report_id (bug #27024669)
Rem       cneumuel 04/05/2018 - Changed indexes wwv_flow_companies_name_uk,wwv_flow_page_plugs_fk_sgid (bug #27566551)
Rem       cneumuel 04/12/2018 - Revert wwv_flow_page_plugs_fk_sgid to old version (bug #27566551)
Rem       cbcho    06/07/2018 - Made wwv_flow_feedback.feedback_comment nullable (bug #28134223)
Rem       shrahman 07/20/2018 - Updating check constraints wwv_flow_standard_icon_lib_ck and wwv_flow_theme_icon_lib_ck to support fontapex_latest
Rem       cneumuel 07/23/2018 - Made wwv_flow_upgrade_progress a view (feature #2344)
Rem       jkallman 08/09/2018 - Remove store as clause from wwv_flow_collection_members$ (bug #28482170)
Rem       cczarski 09/17/2018 - Data Model Changes for REST/REST Enabled SQL support for Forms (feature #2374,#2376)
Rem       hfarrell 10/11/2018 - In wwv_flow_jet_charts: added support for Status Meter Gauge (19.1 feature #2385)
Rem       hfarrell 10/16/2018 - In wwv_flow_jet_chart_series: added support for thresholds on Status Meter Gauge
Rem       hfarrell 10/17/2018 - In wwv_flow_jet_charts:added value_position for Status Meter Gauge value positioning
Rem       cneumuel 10/18/2018 - In wwv_flow_data: add flow_id as 3rd column to PK, to reduce IO in fetch_into_substitution_cache (bug #28581425)
Rem       arayner  11/01/2018 - In wwv_flow_lists_of_values$: Added location columns (feature #2406)
Rem       arayner  11/07/2018 - Added table wwv_flow_lists_of_values_cols (feature #2406)
Rem       pawolf   11/08/2018 - In wwv_flow_step_items: added new values to item_default_type (feature #2374)
Rem       arayner  11/12/2018 - Renamed table wwv_flow_lists_of_values_cols to wwv_flow_list_of_values_cols (feature #2406)
Rem       arayner  11/13/2018 - Renamed columns heading, display_role and display_sequence in wwv_flow_list_of_values_cols (feature #2406)
Rem       cneumuel 11/26/2018 - In wwv_flow_collections$: removed user_id (bug #28918286)
Rem       cczarski 11/29/2018 - added Read/Write support for REST and REST Enabled SQL and Form support (feature #2374,#2376)
Rem       cneumuel 12/04/2018 - In wwv_flow_companies: removed dropped workspace_image% (bug #28812054)
Rem                           - In wwv_flows: removed global_id,display_id,box_width,public_url_prefix,dbauth_url_prefix,custom_authentication_page,custom_auth_login_url,logout_url,application_description
Rem                           - In wwv_flow_steps: remved step_sub_title, step_sub_title_type,box_image,disable_browser_caching_yn,box_footer_text,id2
Rem                           - In wwv_flow_page_plugs: java_entry_point, plug_create_link_text, plug_create_link_target,
Rem                           -    plug_create_image, plug_create_image_attributes, plug_edit_link_text,
Rem                           -    plug_edit_link_target, plug_edit_image, plug_edit_image_attributes,
Rem                           -    plug_expand_link_text, plug_expand_link_target, plug_expand_image,
Rem                           -    plug_expand_image_attributes, plug_close_link_text, plug_close_link_target,
Rem                           -    plug_close_image, plug_close_image_attributes, plug_url_text_begin,
Rem                           -    plug_url_text_end, plug_caching_session_state,plug_display_error_message
Rem                           - Dropped wwv_flow_validations.
Rem       hfarrell 12/05/2018 - In wwv_flow_jet_charts: added gantt tooltip columns
Rem       cczarski 12/07/2018 - support "scope" attribute in wwv_credentials for OAuth2 Authentication (bug #29028213)
Rem       hfarrell 12/07/2018 - In wwv_flow_jet_chart_series: added support for reference lines on Status Meter Gauge
Rem       cczarski 12/07/2018 - in wwv_credential_instances: change value type to CLOB to allow larger token values (bug #28590645)
Rem       cczarski 12/09/2018 - Add wwv_flow_web_src_parans.omit_when_null
Rem       cneumuel 12/11/2018 - In wwv_flow_collections$: re-introduce user_id column because of query plan regressions (bug #28918286)
Rem       hfarrell 12/11/2018 - In wwv_flow_jet_charts: added stack_label to support rendering label on stacked chart elements (19.1 feature #2423)
Rem       hfarrell 12/12/2018 - In wwv_flow_jet_chart_series: added stack_category to support grouping of stack chart elements (19.1 feature #2423)
Rem       hfarrell 12/14/2018 - In wwv_flow_jet_chart_axes: added styling support for axes labels and title (19.1 feature #2379)
Rem       msewtz   04/15/2019 - Updated wwv_flow_user_int_page_fk, added on delete set null (bug 28220810)

--##############################################################################
--#
--# GENERIC OBJECTS
--#
--##############################################################################
prompt GENERIC OBJECTS

--==============================================================================
-- SEQUENCES:
--   - wwv_flow_session_seq: Previously used for sessions, now only for debug page view IDs.
--   - wwv_seq:              Component IDs (see package wwv_id).
--
create sequence wwv_flow_session_seq cache 1000
/
create sequence wwv_seq cache 1000
/


--==============================================================================
create table wwv_flow_charsets (
    id                         number
                               constraint wwv_flow_charsets_pk
                               primary key,
    display_name               varchar2(4000) not null,
    iana_charset               varchar2(255)  not null,
    db_charset                 varchar2(255)  not null
    )
/

--==============================================================================
-- Install tables for random image generator
create table wwv_flow_random_images (
         id                   number
                              constraint wwv_flow_random_images_pk
                              primary key,
         image_name           varchar2(4000) not null,
         image_code           varchar2(10) not null,
         blob_content         blob not null
   )
/

--==============================================================================
create table wwv_flow_standard_icons(
    id            number        not null,
    icon_name     varchar2(255) not null,
    icon_size     number,
    icon_library  varchar2(20)  not null
                  constraint wwv_flow_standard_icon_lib_ck
                  check ( icon_library in ( 'APEX','FONTAPEX','FONTAPEX_LATEST')),
    icon_category varchar2(200),
    icon_filters  varchar2(4000),
    constraint wwv_flow_standard_icons_pk primary key (id))
/

create unique index wwv_flow_std_icons_idx1 on wwv_flow_standard_icons (icon_name,icon_library)
/

--==============================================================================
-- Standard Item Types for page items
create table wwv_flow_standard_item_types (
    id           number
                 constraint wwv_flow_std_item_type_pk
                 primary key,
    name         varchar2(45)  not null
                               constraint wwv_flow_std_item_type_name_ck
                               check (upper(name)=name),
    display_name varchar2(100) not null
  );

alter table wwv_flow_standard_item_types
  add constraint wwv_flow_std_item_type_uk unique (name);


--==============================================================================
create table wwv_flow_customized_tasks (
    id                          number primary key,
    task_name                   varchar2(4000),
    task_link                   varchar2(4000) null,
    display_sequence            number,
    display_location            varchar2(30)
                                constraint wwv_flow_ctasks_location
                                check (display_location in ('WORKSPACE_HOME','WORKSPACE_LOGIN')),
    displayed                   varchar2(1)
                                constraint wwv_flow_ctasks_displayed
                                check (displayed in ('Y','N')),
    security_group_id number    null)
/

--==============================================================================
create table wwv_flow_restricted_schemas(
    id                number
                      constraint wwv_flow_restrict_schema_pk primary key,
    schema            varchar2(128)      not null,
    created_by        varchar2(255)      not null,
    created_on        date               not null,
    last_updated_by   varchar2(255),
    last_updated_on   date)
/

create unique index wwv_flow_restricted_schemas_uk on wwv_flow_restricted_schemas (schema)
/

--==============================================================================
create table wwv_flow_rschema_exceptions (
    id                number
                      constraint wwv_flow_rschema_exceptions_pk primary key,
    schema_id         number             not null
                      constraint wwv_flow_rschema_exceptions_fk
                      references wwv_flow_restricted_schemas(id)
                      on delete cascade,
    workspace_name    varchar2(255)      not null,
    created_by        varchar2(255)      not null,
    created_on        date               not null,
    last_updated_by   varchar2(255),
    last_updated_on   date)
/

create index wwv_flow_rs_exp_fk1 on wwv_flow_rschema_exceptions (schema_id)
/

--##############################################################################
--#
--# WORKSPACE
--#
--##############################################################################
prompt WORKSPACE

--==============================================================================
-- id                      = internal ID number
-- provisioning_company_id = security_group_id (workspace id)
-- short_name              = the company name / workspace name
-- schema_name             = name used to login into the service
--
create table wwv_flow_companies (
    id                            number
                                  constraint wwv_flow_companies_pk
                                  primary key,
    provisioning_company_id       number        not null,
    short_name                    varchar2(255) not null,
    display_name                  varchar2(4000),
    source_identifier             varchar2(8),
    workspace_service_id          number,
    first_schema_provisioned      varchar2(128) not null,
    cookie_name                   varchar2(40)  not null,
    allow_plsql_editing           varchar2(1),
    --
    allow_app_building_yn         varchar2(1),
    allow_packaged_app_ins_yn     varchar2(1)
                                  constraint allow_packaged_app_ins_ck
                                  check (allow_packaged_app_ins_yn in ('Y','N')),
    allow_sql_workshop_yn         varchar2(1),
    allow_websheet_dev_yn         varchar2(1),
    allow_team_development_yn     varchar2(1),
    allow_team_dev_files_yn       varchar2(1)
                                  constraint wwv_flow_companies_files_ck
                                  check (allow_team_dev_files_yn in ('Y','N')),
    team_dev_fs_limit             number,
    allow_issue_files_yn          varchar2(1)
                                  constraint wwv_flow_comp_issue_files_ck
                                  check (allow_issue_files_yn in ('Y','N')),
    issue_fs_limit                number,
    allow_to_be_purged_yn         varchar2(1)
                                  constraint wwv_flow_companies_purge_ck
                                  check (allow_to_be_purged_yn in ('Y','N')),
    allow_restful_services_yn     varchar2(1) default 'Y' not null
                                  constraint wwv_flow_companies_restful_ck
                                  check (allow_restful_services_yn in ('Y','N')),
    auto_archive_yn               varchar2(1)
                                  constraint wwv_flow_companies_a_arch_ck
                                  check (auto_archive_yn in ('Y','N')),
    webservice_logging_yn         varchar2(1)
                                  constraint wwv_flow_companies_ws_log_ck
                                  check (webservice_logging_yn in ('Y','N')),
    --
    last_login                    date,
    expire_fnd_user_accounts      varchar2(1)
                                  constraint wwv_flow_companies_expire
                                  check (expire_fnd_user_accounts in ('Y','N')),
    account_lifetime_days         number,
    fnd_user_max_login_failures   number,
    account_status                varchar2(10)
                                  constraint wwv_flow_companies_ck2
                                  check (account_status in ('AVAILABLE','ASSIGNED','SUSPENDED','TERMINATE','ASSIGN_LCK')),
    builder_notification_message  varchar2(4000),
    --
    rm_consumer_group             varchar2(255),
    --
    created_on                    date,
    assigned_on                   date,
    --
    files_version                 number default 1 not null,
    --
    host_prefix                   varchar2(255)
                                  constraint wwv_flow_companies_host_chk
                                  check (host_prefix=upper(host_prefix)),
    path_prefix                   varchar2(255)
                                  constraint wwv_flow_companies_path_chk
                                  check (path_prefix=upper(path_prefix)),
    cloud_group_name              varchar2(255)
                                  constraint wwv_flow_companies_group_chk
                                  check (cloud_group_name=upper(cloud_group_name)),
    cloud_service_name            varchar2(255)
                                  constraint wwv_flow_companies_service_chk
                                  check (cloud_service_name=upper(cloud_service_name)),
    qos_max_workspace_requests    number,
    qos_max_session_requests      number,
    qos_max_session_kill_timeout  number,
    max_session_length_sec        number,
    max_session_idle_sec          number,
    max_file_bytes                number,
    max_email_messages            number,
    max_webservice_requests       number,
    --
    content_cache_size_target     number,
    content_cache_max_file_size   number,
    workspace_description         varchar2(4000),
    --
    -- constraints
    --
    constraint wwv_flow_companies_name_uk
        unique (short_name)
        using index (
            create index wwv_flow_companies_name_uk
            on wwv_flow_companies(short_name, provisioning_company_id) ),
    constraint wwv_flow_companies_prov_uk
        unique (provisioning_company_id),
    constraint wwv_flow_companies_path_uk
        unique (path_prefix),
    constraint wwv_flow_companies_cloud_uk
        unique (cloud_group_name,cloud_service_name)
        using index compress 1
    )
/

--==============================================================================
create table wwv_flow_company_schemas (
    id                      number
                            constraint wwv_flow_company_schemas_pk
                            primary key,
    security_group_id       number not null
                            constraint wwv_flow_comp_schemas_fk
                            references wwv_flow_companies(provisioning_company_id)
                            on delete cascade,
    schema                  varchar(128),
    is_apex$_schema         varchar2(1)
                            constraint wwv_flow_comp_schemas_apex$_ck
                            check (is_apex$_schema in ('Y','N')),
    company_schema_comments varchar2(4000)
    )
/

create unique index wwv_flow_company_schemas_idx on wwv_flow_company_schemas (security_group_id, schema);

create unique index wwv_flow_company_schemas_idx2 on wwv_flow_company_schemas
    (case when nvl(is_apex$_schema,'N') = 'Y' then security_group_id end,
     case when nvl(is_apex$_schema,'N') = 'Y' then is_apex$_schema end);

--==============================================================================
create table wwv_flow_authorized_urls(
    id                 number primary key,
    security_group_id  number         not null,
    url                varchar2(4000) not null,
    url_md5            varchar2(255)  not null,
    description        varchar2(4000),
    created_on         date,
    created_by         varchar2(255),
    last_updated_on    date,
    last_updated_by    varchar2(255) )
/

create unique index wwv_flow_authorized_urls_idx1 on wwv_flow_authorized_urls ( security_group_id, url_md5 )
/

--==============================================================================
create table wwv_flow_company_static_files (
    id                        number         not null
                                             constraint wwv_flow_comp_stat_file_pk
                                             primary key,
    security_group_id         number         not null
                                             constraint wwv_flow_comp_stat_file_sg_fk
                                             references wwv_flow_companies(provisioning_company_id) on delete cascade,
    file_name                 varchar2(255)  not null,
    mime_type                 varchar2(255)  not null,
    file_charset              varchar2(128),
    file_content              blob,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  );

alter table wwv_flow_company_static_files
  add constraint wwv_flow_comp_stat_file_uk unique (security_group_id, file_name);

--==============================================================================
create table wwv_flow_app_build_pref (
  id                                  number not null,
  security_group_id                   number not null
                                      constraint wwv_flow_app_bldprf_fk
                                      references wwv_flow_companies(provisioning_company_id)
                                      on delete cascade,
  default_parsing_schema              varchar2(255),
  default_authentication_scheme       varchar2(255),
  default_application_theme           number,
  default_tabs                        varchar2(255),
  default_proxy_server                varchar2(500),
  default_language                    varchar2(255),
  default_language_derived            varchar2(255),
  date_format                         varchar2(255),
  date_time_format                    varchar2(255),
  timestamp_format                    varchar2(255),
  timestamp_tz_format                 varchar2(255),
  --
  created_on                          date,
  created_by                          varchar2(255),
  updated_on                          date,
  updated_by                          varchar2(255),
  constraint wwv_flow_app_bldprf_pk   primary key (id)
  );

create unique index wwv_flow_app_build_pref_idx1 on
    wwv_flow_app_build_pref (security_group_id);

--==============================================================================
create table wwv_flow_platform_prefs (
    id                number
                      constraint wwv_flow_platform_prefs_pk
                      primary key,
    name              varchar2(255) not null,
    value             varchar2(4000) not null,
    created_on        date,
    last_updated_on   date,
    pref_desc         varchar2(4000),
    security_group_id number not null
                      constraint wwv_flow_platform_prefs_fk
                      references wwv_flow_companies(provisioning_company_id)
                      on delete cascade)
/

create index wwv_flow_platform_prefs_idx1 on wwv_flow_platform_prefs (name)
/

create index wwv_flow_platform_prefs_fkidx on wwv_flow_platform_prefs (security_group_id,name)
/

--==============================================================================
create table wwv_flow_ui_types (
    id                             number         not null
                                                  constraint wwv_flow_ui_type_pk
                                                  primary key,
    name                           varchar2(30)   not null /* eg. DESKTOP, SMARTPHONE, TABLET, PHONEGAP_SMARTPHONE, PHONEGAP_TABLET, EXTJS */
                                                  constraint wwv_flow_ui_type_name_ck
                                                       check ( name = upper(name) and instr(name, ':') = 0 ),
    based_on_ui_type_id            number,         /* Foreign key to inherit the components of that base ui type. Eg. PHONEGAP_SMARTPHONE inherits everything from SMARTPHONE */
    autodetect_js_file_urls        varchar2(4000),
    autodetect_js_function_body    varchar2(4000), /* used to automatically determine the UI in an automatically generated page. Similar to our automatic timezone detection */
    autodetect_plsql_function_body varchar2(4000), /* used to automatically determine the UI on the server side. Eg. by sniffing the USER_AGENT (for iPhone, iPad, ...) */
    security_group_id              number,         /* nullable! All our standard UI types (see above) are configured with security group id NULL, all
                                                               custom ui types defined by customers or plug-in developers will use the current workspace */
    created_by                     varchar2(255),
    created_on                     date,
    last_updated_by                varchar2(255),
    last_updated_on                date
  );

alter table wwv_flow_ui_types add constraint wwv_flow_ui_type_name_uk unique (name, security_group_id)
/

alter table wwv_flow_ui_types add constraint wwv_flow_ui_type_based_on_fk
                                             foreign key (based_on_ui_type_id)
                                             references wwv_flow_ui_types(id)
/

create index wwv_flow_ui_type_idx1 on wwv_flow_ui_types (based_on_ui_type_id)
/

--==============================================================================
create table wwv_flow_builder_features (
    id                             number         not null
                                                  constraint wwv_flow_bld_feature_pk
                                                  primary key,
    name                           varchar2(30)   not null
                                                  constraint wwv_flow_bld_feature_name_ck
                                                       check ( name = upper(name) )
  );

alter table wwv_flow_builder_features add constraint wwv_flow_bld_feature_name_uk unique (name)
/

--==============================================================================
create table wwv_flow_ui_type_features (
    id                             number         not null
                                                  constraint wwv_flow_ui_type_feature_pk
                                                  primary key,
    ui_type_id                     number         not null
                                                  constraint wwv_flow_ui_type_feature_fk1
                                                  references wwv_flow_ui_types,
    builder_feature_id             number         not null
                                                  constraint wwv_flow_ui_type_feature_fk2
                                                  references wwv_flow_builder_features,
    security_group_id              number,         /* nullable! All our standard UI types (see above) are configured with security group id NULL, all
                                                               custom ui types defined by customers or plug-in developers will use the current workspace */
    created_by                     varchar2(255),
    created_on                     date,
    last_updated_by                varchar2(255),
    last_updated_on                date
  );

alter table wwv_flow_ui_type_features add constraint wwv_flow_ui_type_feature_uk unique (ui_type_id, builder_feature_id)
/

create index wwv_flow_builder_features_idx2 on wwv_flow_ui_type_features (builder_feature_id) compress
/

--##############################################################################
--#
--# SESSION STATE MANAGEMENT
--#
--##############################################################################
prompt SESSION STATE MANAGEMENT

--==============================================================================
-- master session table
--
-- IF YOU CHANGE THIS TABLE OR IT'S INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--
create table wwv_flow_sessions$ (
    id                        number
                              constraint wwv_flow_sessions_pk
                              primary key,
    cookie_value              varchar2(32)  not null,
    security_group_id         number        not null,
    crypto_salt               raw(32)       not null,
    --
    created_on                date          not null,
    max_idle_sec              number(5,0)   not null,
    idle_timeout_on           date          not null,
    life_timeout_on           date          not null,
    --
    remote_addr               varchar2(255),
    on_new_instance_fired_for varchar2(4000),
    --
    username                  varchar2(255),
    authentication_result     number,
    --
    screen_reader_mode_yn     varchar2(1),
    high_contrast_mode_yn     varchar2(1),
    --
    session_time_zone         varchar2(255),
    session_lang              varchar2(5)
                              constraint wwv_flow_sessions_ck_lang
                              check(regexp_instr(trim(lower(session_lang)), '^[abcdefghijklmnopqrstuvwxyz]{2}(-[abcdefghijklmnopqrstuvwxyz]{2})?$') = 1),
    session_territory         varchar2(255),
    ras_sessionid             raw(16),
    workspace_user_id         number,
    authentication_id         number,
    tenant_id                 varchar2(32),
    --
    debug_level               number(1)
                              constraint wwv_flow_sessions_ck_debug
                              check(debug_level between 1 and 9),
    trace_mode                number(1)
                              constraint wwv_flow_sessions_ck_trace
                              check(trace_mode between 1 and 2)
    )
    storage (initial 100K next 1M freelists 20)
/

alter table wwv_flow_sessions$ add (
    timeout_computation as ( to_number(to_char (
                                 least(idle_timeout_on, life_timeout_on),
                                 'YYDDDHH24' )) )
)
/

create index wwv_flow_sessions$_idx_cookie on
    wwv_flow_sessions$(cookie_value)
/
create index wwv_flow_sessions$_idx_timeout on
    wwv_flow_sessions$(timeout_computation)
    compress
/
create index wwv_flow_sessions$_idx_sgid on
    wwv_flow_sessions$(security_group_id)
    compress
/

--==============================================================================
--
-- passed/failed authorizations for a session
--
-- the fk from authorization_id to wwv_flow_security_schemes is intentionally
-- missing, to save space
--
-- IF YOU CHANGE THIS TABLE OR IT'S INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--
create table wwv_flow_session_authz$ (
    session_id           number        not null
                                       constraint wwv_flow_session_authz$_fk1
                                       references wwv_flow_sessions$
                                       on delete cascade,
    component_type       varchar2(30)  not null,
    component_id         number        not null,
    authorization_id     number        not null,
    is_successful        varchar2(1)   not null
                                       constraint wwv_flow_session_authz$_ck1
                                       check (is_successful in ('Y','N')),
    constraint wwv_flow_session_authz$_pk
        primary key(session_id, component_type, component_id, authorization_id)
) organization index compress 3
/

--==============================================================================
--
-- session assigned groups
--
-- IF YOU CHANGE THIS TABLE OR IT'S INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--
create table wwv_flow_session_groups$ (
    session_id           number        not null
                                       constraint wwv_flow_session_groups$_fk1
                                       references wwv_flow_sessions$
                                       on delete cascade,
    group_name           varchar2(255) not null,
    constraint wwv_flow_session_groups$_pk
        primary key(session_id, group_name)
) organization index compress 1
/

--==============================================================================
--
-- session state
--
-- IF YOU CHANGE THIS TABLE OR IT'S INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--
create table wwv_flow_data (
    flow_instance        number        constraint wwv_flow_data_session_fk
                                       references wwv_flow_sessions$
                                       on delete cascade,
    item_id              number,
    item_filter          varchar2(1)   constraint valid_item_filter
                                       check (item_filter in ('Y','N')),
    session_state_status varchar2(1)   constraint valid_session_state_status
                                       check (session_state_status in ('I','U','R')),
    flow_id              number,
    item_name            varchar2(255),
    is_encrypted         varchar2(1),
    item_value_vc2       varchar2(4000),
    item_value_clob      clob,
    constraint wwv_flow_data_pk primary key (flow_instance, item_id)
                         using index (
                             create index wwv_flow_data_pk on wwv_flow_data (
                                 flow_instance, item_id, flow_id )
                             compress 1) )
    storage (initial 1M next 1M freelists 20)
    initrans 8
    lob (item_value_clob) store as (cache reads disable storage in row)
/

create index WWV_FLOW_DATA_IDX1 on wwv_flow_data (flow_id) compress 1
/

--==============================================================================
-- C O L L E C T I O N S
--
-- IF YOU CHANGE THIS TABLE OR IT'S INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--
create table wwv_flow_collections$ (
    id                 number        not null,
    session_id         number        not null,
    user_id            varchar2(255) not null,
    flow_id            number        not null,
    collection_name    varchar2(255) not null,
    collection_changed varchar2(10)  not null,
    created_on         date          not null,
    security_group_id  number        not null,
    constraint wwv_flow_collections_pk primary key(id),
    constraint wwv_flow_collections_fk foreign key(session_id)
        references wwv_flow_sessions$(id)
        on delete cascade,
    constraint wwv_flow_collections_uk unique (
        session_id, user_id, flow_id, collection_name, security_group_id )
)
/
--==============================================================================
--
-- IF YOU CHANGE THIS TABLE OR IT'S INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--

create table wwv_flow_collection_members$ (
    collection_id     number        not null,
    seq_id            number        not null,
    security_group_id number        not null,
    c001              varchar2(4000),
    c002              varchar2(4000),
    c003              varchar2(4000),
    c004              varchar2(4000),
    c005              varchar2(4000),
    c006              varchar2(4000),
    c007              varchar2(4000),
    c008              varchar2(4000),
    c009              varchar2(4000),
    c010              varchar2(4000),
    c011              varchar2(4000),
    c012              varchar2(4000),
    c013              varchar2(4000),
    c014              varchar2(4000),
    c015              varchar2(4000),
    c016              varchar2(4000),
    c017              varchar2(4000),
    c018              varchar2(4000),
    c019              varchar2(4000),
    c020              varchar2(4000),
    c021              varchar2(4000),
    c022              varchar2(4000),
    c023              varchar2(4000),
    c024              varchar2(4000),
    c025              varchar2(4000),
    c026              varchar2(4000),
    c027              varchar2(4000),
    c028              varchar2(4000),
    c029              varchar2(4000),
    c030              varchar2(4000),
    c031              varchar2(4000),
    c032              varchar2(4000),
    c033              varchar2(4000),
    c034              varchar2(4000),
    c035              varchar2(4000),
    c036              varchar2(4000),
    c037              varchar2(4000),
    c038              varchar2(4000),
    c039              varchar2(4000),
    c040              varchar2(4000),
    c041              varchar2(4000),
    c042              varchar2(4000),
    c043              varchar2(4000),
    c044              varchar2(4000),
    c045              varchar2(4000),
    c046              varchar2(4000),
    c047              varchar2(4000),
    c048              varchar2(4000),
    c049              varchar2(4000),
    c050              varchar2(4000),
    n001              number,
    n002              number,
    n003              number,
    n004              number,
    n005              number,
    d001              date,
    d002              date,
    d003              date,
    d004              date,
    d005              date,
    clob001           clob default empty_clob(),
    blob001           blob default empty_blob(),
    md5_original      varchar2(4000),
    xmltype001        sys.xmltype,
    constraint wwv_flow_collection_members_pk primary key (
        collection_id, seq_id )
        using index compress 1 initrans 8,
    constraint wwv_flow_collection_members_fk foreign key (collection_id)
        references wwv_flow_collections$(id)
        on delete cascade
) initrans 8
    lob (clob001) store as (cache reads enable storage in row),
    lob (blob001) store as (cache reads enable storage in row)
/

--==============================================================================
create table wwv_flow_request_verifications (
         session_id            number
                               constraint wwv_flow_request_verif_pk
                               primary key,
         verification_string   varchar2(100) not null,
         constraint wwv_flow_request_verif_fk
         foreign key (session_id) references wwv_flow_sessions$ (id) on delete cascade
   )
/

--##############################################################################
--#
--# PROPERTY EDITOR
--#
--##############################################################################
prompt PROPERTY EDITOR

--==============================================================================
create table wwv_pe_component_types (
    id                              number          not null
                                                    constraint wwv_pe_component_type_pk
                                                    primary key,
    name                            varchar2(45)    not null
                                                    constraint wwv_pe_component_type_name_ck
                                                    check (upper(name)=name),
    plural_title                    varchar2(80)    not null,
    singular_title                  varchar2(80)    not null,
    table_name                      varchar2(30)    not null,
    view_name                       varchar2(30),
    display_sequence                number          not null,
    pk_column                       varchar2(30)    not null
                                                    constraint wwv_pe_comp_type_pk_col_ck
                                                    check (upper(pk_column)=pk_column),
    parent_component_type_id        number          constraint wwv_pe_comp_type_parent_fk
                                                    references wwv_pe_component_types on delete cascade,
    parent_fk_column                varchar2(30)    constraint wwv_pe_comp_type_par_fk_col_ck
                                                    check (upper(parent_fk_column)=parent_fk_column),
    page_id_column                  varchar2(30)    constraint wwv_pe_comp_type_pageid_col_ck
                                                    check (upper(page_id_column)=page_id_column),
    display_column                  varchar2(30)    constraint wwv_pe_comp_type_displ_col_ck
                                                    check (upper(display_column)=display_column),
    where_clause                    varchar2(4000),
    validation_plsql_ret_error      varchar2(4000),
    plugin_type                     varchar2(30)    constraint wwv_pe_comp_plugin_type_ck
                                                    check (plugin_type in ( 'ITEM TYPE',
                                                                            'DYNAMIC ACTION',
                                                                            'REGION TYPE',
                                                                            'PROCESS TYPE',
                                                                            'AUTHORIZATION TYPE',
                                                                            'AUTHENTICATION TYPE' )),
    plugin_column                   varchar2(30)    constraint wwv_pe_comp_type_plugin_col_ck
                                                    check (upper(plugin_column)=plugin_column),
    plugin_attributes_seq_offset    number,
    create_url                      varchar2(255),
    edit_url                        varchar2(255),
    copy_url                        varchar2(255)
    );
alter table wwv_pe_component_types add constraint wwv_pe_component_type_uk unique (name);
create index wwv_pe_comp_type_parent_fx on wwv_pe_component_types (parent_component_type_id);

--==============================================================================
create table wwv_pe_display_groups (
    id                              number          not null
                                                    constraint wwv_pe_display_group_pk
                                                    primary key,
    name                            varchar2(45)    not null
                                                    constraint wwv_pe_display_group_name_ck
                                                    check (upper(name)=name),
    title                           varchar2(80)    not null
    );
alter table wwv_pe_display_groups add constraint wwv_pe_display_group_uk unique (name);

--==============================================================================
create table wwv_pe_properties (
    id                              number          not null
                                                    constraint wwv_pe_property_pk
                                                    primary key,
    name                            varchar2(45)    not null
                                                    constraint wwv_pe_property_name_ck
                                                    check (upper(name)=name),
    prompt                          varchar2(80)    not null,
    property_type                   varchar2(30)    not null
                                                    constraint wwv_pe_property_prop_type_ck
                                                    check (property_type in (
                                                        'COMBOBOX',
                                                        'CHECKBOXES',
                                                        'COLOR',
                                                        'COLUMN',
                                                        'COMPONENT',
                                                        'CSS',
                                                        'JAVASCRIPT',
                                                        'HIDDEN',
                                                        'HTML',
                                                        'ICON',
                                                        'INTEGER',
                                                        'LINK',
                                                        'NUMBER',
                                                        'OWNER',
                                                        'ORDER BY CLAUSE',
                                                        'ITEM',
                                                        'PAGE',
                                                        'PLSQL',
                                                        'PLSQL EXPRESSION VARCHAR2',
                                                        'PLSQL EXPRESSION BOOLEAN',
                                                        'PLSQL FUNCTION BODY VARCHAR2',
                                                        'PLSQL FUNCTION BODY BOOLEAN',
                                                        'PLSQL FUNCTION BODY SQL',
                                                        'REGION COLUMN',
                                                        'POPUP LOV',
                                                        'RADIOS',
                                                        'SELECT LIST',
                                                        'SQL',
                                                        'SQL EXPRESSION',
                                                        'SQL EXPRESSION BOOLEAN',
                                                        'SUBSCRIPTION',
                                                        'TABLE',
                                                        'TEXT',
                                                        'TEXTAREA',
                                                        'TEXT EDITOR',
                                                        'TEMPLATE OPTIONS',
                                                        'SUPPORTED UI',
                                                        'STATIC LOV',
                                                        'WHERE CLAUSE',
                                                        'XML',
                                                        'HTML',
                                                        'YES NO',
                                                        'PILL BUTTONS' )),
    prop_type_yesno_override_y      varchar2(30),
    prop_type_yesno_override_n      varchar2(30),
    multi_value_delimiter           varchar2(1)     constraint wwv_pe_property_multi_del_ck
                                                    check (multi_value_delimiter in ( ',', ':', ' ' )),
    db_column                       varchar2(30)    not null,
    is_query_only                   varchar2(1)     not null
                                                    constraint wwv_pe_property_query_only_ck
                                                    check (is_query_only in ('Y','N')),
    display_length                  number          constraint wwv_pe_property_disp_l_ck
                                                    check (display_length between 1 and 4000),
    max_length                      number          constraint wwv_pe_property_max_l_ck
                                                    check (max_length between 1 and 32767),
    min_value                       number,
    max_value                       number,
    unit                            varchar2(80),
    validation_plsql_ret_error      varchar2(4000),
    text_case                       varchar2(10)    constraint wwv_pe_property_value_case_ck
                                                    check ( text_case in (
                                                        'LOWER',
                                                        'UPPER' )),
    restricted_characters           varchar2(30)    constraint wwv_pe_property_value_restr_ck
                                                    check ( restricted_characters in ('US_ONLY', 'WEB_SAFE', 'NO_SPECIAL_CHAR', 'NO_SPECIAL_CHAR_NL', 'SAFE_COMPONENT_NAME', 'US_ONLY_NO_SPACE', 'US_ONLY_NO_SPACE', 'US_ONLY_UNDERSCORE_NO_SPACE' )),
    sql_min_column_count            number(3)       constraint wwv_pe_property_mincol_ck
                                                    check (sql_min_column_count > 0),
    sql_max_column_count            number(3)       constraint wwv_pe_property_maxcol_ck
                                                    check (sql_max_column_count > 0),
    column_data_types               varchar2(255),
    examples                        varchar2(80),
    supported_ui_types              varchar2(255)   not null,
    display_group_id                number          not null
                                                    constraint wwv_pe_property_disp_grp_fk
                                                    references wwv_pe_display_groups,
    lov_type                        varchar2(30)    constraint wwv_pe_property_lov_type_ck
                                                    check (lov_type in (
                                                        'ALL_FORMAT_MASKS',
                                                        'BUTTON_POSITIONS',
                                                        'COMPONENT',
                                                        'DATE_FORMAT_MASKS',
                                                        'NUMBER_FORMAT_MASKS',
                                                        'CHART_FORMAT_MASKS',
                                                        'DISTINCT',
                                                        'PLUGINS',
                                                        'EVENTS',
                                                        'GRID_COLUMNS',
                                                        'REGION_POSITIONS',
                                                        'STATIC',
                                                        'MAP_REGIONS',
                                                        'TEMPLATE_OPTIONS' )),
    lov_component_type_id           number          constraint wwv_pe_property_lov_comp_t_fk
                                                    references wwv_pe_component_types,
    lov_component_type_scope        varchar2(15)    constraint wwv_pe_property_lov_scope_ck
                                                    check (lov_component_type_scope in ( 'COLUMN', 'PARENT', 'PAGE', 'PAGE_AND_GLOBAL', 'THEME', 'APPLICATION' )),
    is_translatable                 varchar2(1)     not null
                                                    constraint wwv_pe_property_is_trans_ck
                                                    check (is_translatable in ('Y', 'N')),
    deprecated_values               varchar2(30),
    is_searchable                   varchar2(1)     not null
                                                    constraint wwv_pe_property_is_search_ck
                                                    check (is_searchable in ('Y', 'N')),
    is_internal                     varchar2(1)     not null
                                                    constraint wwv_pe_property_is_int_ck
                                                    check (is_internal in ('Y', 'N')),
    help_text                       varchar2(80),
    comment_text                    varchar2(4000)
    );
alter table wwv_pe_properties add constraint wwv_pe_property_uk unique (name);
create index wwv_pe_property_disp_group_fx on wwv_pe_properties (display_group_id);
create index wwv_pe_property_lov_comp_t_fx on wwv_pe_properties (lov_component_type_id);

--==============================================================================
create table wwv_pe_property_lov_values (
    id                              number          not null
                                                    constraint wwv_pe_prop_lov_val_pk
                                                    primary key,
    property_id                     number          not null
                                                    constraint wwv_pe_prop_lov_val_prop_fk
                                                    references wwv_pe_properties on delete cascade,
    display_sequence                number          not null,
    display_value                   varchar2(255)   not null,
    return_value                    varchar2(255)   not null,
    icon                            varchar2(255),
    is_quick_pick                   varchar2(1)     not null
                                                    constraint wwv_pe_prop_lov_val_is_qp_ck
                                                    check (is_quick_pick in ('Y', 'N')),
    is_internal                     varchar2(1)     not null
                                                    constraint wwv_pe_prop_lov_val_is_int_ck
                                                    check (is_internal in ('Y', 'N')),
    is_deprecated                   varchar2(1)     not null
                                                    constraint wwv_pe_prop_lov_val_is_dep_ck
                                                    check (is_deprecated in ('Y', 'N')),
    help_text                       varchar2(255),
    comment_text                    varchar2(4000)
    );
alter table wwv_pe_property_lov_values add constraint wwv_pe_prop_lov_val_uk unique (property_id, return_value);

--==============================================================================
create table wwv_pe_component_props (
    id                              number          not null
                                                    constraint wwv_pe_comp_prop_pk
                                                    primary key,
    component_type_id               number          not null
                                                    constraint wwv_pe_comp_prop_comp_fk
                                                    references wwv_pe_component_types on delete cascade,
    property_id                     number          not null
                                                    constraint wwv_pe_comp_prop_prop_fk
                                                    references wwv_pe_properties on delete cascade,
    db_column                       varchar2(30),
    view_column                     varchar2(30),
    display_sequence                number          not null,
    is_required                     varchar2(1)     constraint wwv_pe_comp_prop_req_ck /* if NULL the value is derived from plug-in config */
                                                    check (is_required in ('Y', 'N')),
    check_uniqueness                varchar2(15)    constraint wwv_pe_comp_prop_unique_ck
                                                    check (check_uniqueness in ( 'PARENT', 'PAGE', 'APPLICATION', 'WORKSPACE', 'INSTANCE' )),
    is_common                       varchar2(1)     not null
                                                    constraint wwv_pe_comp_prop_common_ck
                                                    check (is_common in ('Y', 'N')),
    is_read_only                    varchar2(1)     not null
                                                    constraint wwv_pe_comp_prop_readonly_ck
                                                    check (is_read_only in ('Y', 'N')),
    reference_on_delete             varchar2(12)    constraint wwv_pe_comp_prop_ref_delete_ck
                                                    check (reference_on_delete in (
                                                        'WEAK_CASCADE',
                                                        'WEAK_NULL',
                                                        'DB_CASCADE',
                                                        'DB_NULL' )),
    reference_scope                 varchar2(10)    constraint wwv_pe_comp_prop_ref_ck
                                                    check (reference_scope in ('COMPONENT', 'ROW', 'DEPENDS')),
    supports_substitution           varchar2(1)     not null
                                                    constraint wwv_pe_comp_prop_subst_ck
                                                    check (supports_substitution  in ('Y', 'N')),
    null_text                       varchar2(255),
    null_help_text                  varchar2(255),
    default_value                   varchar2(4000),
    plugin_std_attributes           varchar2(255),
    depending_on_comp_prop_id       number          constraint wwv_pe_comp_prop_depend_fk
                                                    references wwv_pe_component_props on delete set null deferrable initially deferred,
    depending_on_has_to_exist       varchar2(1)     constraint wwv_pe_comp_prop_depend_ex_ck
                                                    check (depending_on_has_to_exist in ('Y', 'N')),
    depending_on_condition_type     varchar2(30)    constraint wwv_pe_comp_prop_cond_ck
                                                    check (depending_on_condition_type in (
                                                        'EQUALS',
                                                        'NOT_EQUALS',
                                                        'LIKE',
                                                        'NOT_LIKE',
                                                        'NULL',
                                                        'NOT_NULL',
                                                        'IN_LIST',
                                                        'NOT_IN_LIST',
                                                        'IN_LIST_LIKE',
                                                        'NOT_IN_LIST_LIKE' )),
    depending_on_expression         varchar2(4000),
    depending_on_comp_prop_id2      number          constraint wwv_pe_comp_prop_depend2_fk
                                                    references wwv_pe_component_props on delete set null deferrable initially deferred,
    depending_on_has_to_exist2      varchar2(1)     constraint wwv_pe_comp_prop_depend_ex2_ck
                                                    check (depending_on_has_to_exist2 in ('Y', 'N')),
    depending_on_condition_type2    varchar2(30)    constraint wwv_pe_comp_prop_cond2_ck
                                                    check (depending_on_condition_type2 in (
                                                        'EQUALS',
                                                        'NOT_EQUALS',
                                                        'LIKE',
                                                        'NOT_LIKE',
                                                        'NULL',
                                                        'NOT_NULL',
                                                        'IN_LIST',
                                                        'NOT_IN_LIST',
                                                        'IN_LIST_LIKE',
                                                        'NOT_IN_LIST_LIKE' )),
    depending_on_expression2        varchar2(4000),
    parent_comp_prop_id             number          constraint wwv_pe_comp_prop_parent_fk
                                                    references wwv_pe_component_props on delete set null deferrable initially deferred,
    examples                        varchar2(255),
    help_text                       varchar2(255),
    comment_text                    varchar2(4000)
    );
alter table wwv_pe_component_props add constraint wwv_pe_component_prop_uk unique (component_type_id, property_id);

create index wwv_pe_comp_prop_prop_type_fx on wwv_pe_component_props (property_id);
create index wwv_pe_comp_prop_depend_fx  on wwv_pe_component_props (depending_on_comp_prop_id);
create index wwv_pe_comp_prop_depend2_fx on wwv_pe_component_props (depending_on_comp_prop_id2);
create index wwv_pe_comp_prop_parent_fx  on wwv_pe_component_props (parent_comp_prop_id);

--##############################################################################
--#
--# APPLICATION
--#
--##############################################################################
prompt APPLICATION
--==============================================================================
-- id                = flow number
-- security_group_id = identifies company
-- owner             = identifies who the flow is parsed as
-- name              = identifies the logical name of the flow
create table wwv_flows (
    id                            number
                                  constraint wwv_flow_flow_PK
                                  primary key,
    security_group_id             number not null
                                  constraint wwv_flows_fk
                                  references wwv_flow_companies(provisioning_company_id)
                                  on delete cascade,
    alias                         varchar2(255) not null,
    owner                         varchar2(128) not null,
    name                          varchar2(255) not null,
    default_page_template         number,
    allow_feedback_yn             varchar2(1) constraint wwv_flow_allow_feedback_yn_ck
                                  check (allow_feedback_yn in (
                                  'Y',
                                  'N')),
    webdb_logging                 varchar2(30)
                                  constraint wwv_valid_flow_loggingyesno
                                  check (webdb_logging in (
                                  'YES',
                                  'NO')),
    printer_friendly_template     number,
    default_region_template       number,
    default_label_template        number,
    default_report_template       number,
    default_list_template         number,
    default_menu_template         number,
    default_button_template       number,
    default_calendar_template     number,
    error_template                number,
    flow_language                 varchar2(255),
    flow_language_derived_from    varchar2(30)
                                  constraint wwv_valid_flow_lang_from
                                  check (flow_language_derived_from in (
                                  'FLOW_PRIMARY_LANGUAGE',
                                  'BROWSER',
                                  'ITEM_PREFERENCE',
                                  'FLOW_PREFERENCE',
                                  'SESSION',
                                  '0')),
    charset                       varchar2(255),
    media_type                    varchar2(255),
    date_format                   varchar2(255),
    date_time_format              varchar2(255),
    timestamp_format              varchar2(255),
    timestamp_tz_format           varchar2(255),
    nls_sort                      varchar2(255),
    nls_comp                      varchar2(255)
                                  constraint wwv_flow_nls_comp_ck
                                  check (nls_comp in (
                                  'BINARY',
                                  'LINGUISTIC'
                                  )),
    direction_right_to_left       varchar2(1) default 'N' not null
                                  constraint wwv_flow_direction_ck
                                  check (direction_right_to_left in ('Y','N')),
    flow_image_prefix             varchar2(255),
    --
    max_session_length_sec        number,
    on_max_session_timeout_url    varchar2(4000),
    max_session_idle_sec          number,
    on_max_idle_timeout_url       varchar2(4000),
    --
    logo_type                     varchar2(2)
                                  constraint wwv_flows_logo_types_ck
                                  check (logo_type in ('T','I','IT', 'C')),
    logo                          varchar2(4000),
    logo_text                     varchar2(4000),
    --
    favicons                      varchar2(4000),
    app_builder_icon_name         varchar2(255)
                                  constraint wwv_flow_valid_appbuildericon
                                  check (not regexp_like(app_builder_icon_name, '\.\.|\/|\\')),
    public_user                   varchar2(255),
    proxy_server                  varchar2(255),
    no_proxy_domains              varchar2(500),
    authentication_id             number,         -- fk to wwv_flow_authentications follows after creation of wwv_flow_authentications
    populate_roles                varchar2(1) default 'R' not null
                                  constraint wwv_flows_populate_roles_ck
                                  check (populate_roles in ('R','A','C')),
    flow_version                  varchar2(255),
    flow_status                   varchar2(30)
                                  constraint wwv_flow_valid_status
                                  check (flow_status in (
                                  'AVAILABLE',
                                  'AVAILABLE_W_EDIT_LINK',
                                  'AVAILABLE_W_INLINE_EDIT',
                                  'DEVELOPERS_ONLY',
                                  'UNAVAILABLE_URL',
                                  'UNAVAILABLE_PLSQL',
                                  'RESTRICTED_ACCESS',
                                  'UNAVAILABLE')),
    flow_unavailable_text         varchar2(4000),
    restrict_to_user_list         varchar2(4000),
    application_tab_set           number,
    exact_substitutions_only      varchar2(1)
                                  constraint wwv_flow_exact_subs_flag
                                  check (exact_substitutions_only in ('Y','N')),
    csv_encoding                  varchar2(1) constraint wwv_flow_csv_encoding
                                  check (csv_encoding in (
                                  'Y',
                                  'N')),
    auto_time_zone                varchar2(1) constraint wwv_flow_auto_time_zone
                                  check (auto_time_zone in (
                                  'Y',
                                  'N')),
    content_delivery_network      varchar2(20),   /* obsolete, has been moved to wwv_flow_user_interfaces */
    javascript_file_urls          varchar2(4000), /* obsolete, has been moved to wwv_flow_user_interfaces */
    include_legacy_javascript     varchar2(1),    /* obsolete, has been moved to wwv_flow_user_interfaces */
    ui_detection_css_urls         varchar2(4000),
    --
    build_status                  varchar2(30)
                                  constraint wwv_flow_valid_build_status
                                  check (build_status in (
                                  'RUN_AND_BUILD',
                                  'RUN_ONLY',
                                  'RUN_AND_HIDDEN')),
    publish_yn                    varchar2(1),
    --
    vpd                           varchar2(4000),
    vpd_teardown_code             varchar2(4000),
    runtime_api_usage             varchar2(5)
                                  constraint wwv_flow_runtime_api_usage_ck
                                       check ( regexp_like(runtime_api_usage, '^[TOW:]+$')),
    security_scheme               varchar2(255),
    authorize_public_pages_yn     varchar2(1) default 'Y' not null
                                  constraint wwv_flow_authz_public_pages_ck
                                  check (authorize_public_pages_yn in ('Y', 'N')),
    rejoin_existing_sessions      varchar2(1) default 'N' not null
                                  constraint wwv_flow_rejoin_es_ck
                                  check (rejoin_existing_sessions in ('Y', 'P', 'N')),
    --
    checksum_salt                 raw(255),
    checksum_salt_last_reset      date,
    bookmark_checksum_function    varchar2(5) not null
                                  constraint wwv_flow_bookmark_cs_fnc_ck
                                  check (bookmark_checksum_function in ('MD5','SH1','SH256','SH384','SH512')),
    --
    substitution_string_01        varchar2(255),
    substitution_value_01         varchar2(4000),
    substitution_string_02        varchar2(255),
    substitution_value_02         varchar2(4000),
    substitution_string_03        varchar2(255),
    substitution_value_03         varchar2(4000),
    substitution_string_04        varchar2(255),
    substitution_value_04         varchar2(4000),
    substitution_string_05        varchar2(255),
    substitution_value_05         varchar2(4000),
    substitution_string_06        varchar2(255),
    substitution_value_06         varchar2(4000),
    substitution_string_07        varchar2(255),
    substitution_value_07         varchar2(4000),
    substitution_string_08        varchar2(255),
    substitution_value_08         varchar2(4000),
    substitution_string_09        varchar2(255),
    substitution_value_09         varchar2(4000),
    substitution_string_10        varchar2(255),
    substitution_value_10         varchar2(4000),
    substitution_string_11        varchar2(255),
    substitution_value_11         varchar2(4000),
    substitution_string_12        varchar2(255),
    substitution_value_12         varchar2(4000),
    substitution_string_13        varchar2(255),
    substitution_value_13         varchar2(4000),
    substitution_string_14        varchar2(255),
    substitution_value_14         varchar2(4000),
    substitution_string_15        varchar2(255),
    substitution_value_15         varchar2(4000),
    substitution_string_16        varchar2(255),
    substitution_value_16         varchar2(4000),
    substitution_string_17        varchar2(255),
    substitution_value_17         varchar2(4000),
    substitution_string_18        varchar2(255),
    substitution_value_18         varchar2(4000),
    substitution_string_19        varchar2(255),
    substitution_value_19         varchar2(4000),
    substitution_string_20        varchar2(255),
    substitution_value_20         varchar2(4000),
    --
    last_updated_by               varchar2(255),
    last_updated_on               date,
    -- 4.0
    created_by                    varchar2(255),
    created_on                    date,
    --
    default_chart_template        number,
    default_reportr_template      number,
    default_form_template         number,
    default_wizard_template       number,
    default_tabform_template      number,
    default_menur_template        number,
    default_listr_template        number,
    default_irr_template          number,
    theme_id                      number,
    group_id                      number,
    error_handling_function       varchar2(255),
    default_error_display_location varchar2(40)
                                   constraint wwv_flow_default_edl
                                   check ( default_error_display_location in (
                                               'INLINE_WITH_FIELD',
                                               'INLINE_WITH_FIELD_AND_NOTIFICATION',
                                               'INLINE_IN_NOTIFICATION') ),
    global_notification           varchar2(4000),
    page_protection_enabled_y_n   varchar2(1)
                                    constraint wwv_flow_page_prot_enable_flag
                                    check (page_protection_enabled_y_n in ('Y','N')),
    application_type              varchar2(30) default 'STANDARD'
                                  constraint wwv_flow_app_type
                                  check (application_type in ('STANDARD','TEMPLATE','SAMPLE','TEMPLATE_HIDDEN','THEME')),
    browser_cache                 varchar2(1) default 'Y'
                                  not null
                                  constraint wwv_flows_ck_browser_cache
                                  check (browser_cache in ('Y','N')),
    browser_frame                 varchar2(1) default 'A'
                                  not null
                                  constraint wwv_flows_ck_browser_frame
                                  check (browser_frame in ('D','A','S')),
    deep_linking                  varchar2(1) default 'Y'
                                  not null
                                  constraint wwv_flows_ck_deep_linking
                                  check (deep_linking in ('Y','N')),
    compatibility_mode            varchar2(4) default '4.0'
                                  not null
                                  constraint wwv_flows_ck_comp_mode
                                  check (compatibility_mode in ('4.0', '4.1', '4.2', '5.0', '5.1', '19.1', '19.2')),
    html_escaping_mode            varchar2(1) default 'E'
                                  not null
                                  constraint wwv_flow_ck_esc_mode
                                  check (html_escaping_mode in ('B', 'E')),
    http_response_headers         varchar2(4000),
    email_from                    varchar2(255),
    oracle_text_function          varchar2(500),
    import_orig_app_id            number,
    import_orig_security_group_id number,
    import_orig_owner             varchar2(128),
    import_id_offset              number,
    import_orig_release           varchar2(30),
    file_prefix                   varchar2(255),
    files_version                 number default 1 not null,
    --
    shared_components_scn         number default 1 not null,
    --
    -- obsolete, but needed for wwv_flow_upgrade
    --
    authentication                varchar2(255),
    custom_authentication_process varchar2(4000),
    home_link                     varchar2(2000),
    login_url                     varchar2(2000),
    --
    -- constraints
    --
    constraint wwv_flows_pk_idx    unique(security_group_id, id),
    constraint wwv_flows_alias_idx unique(alias, security_group_id)
    )
/

alter index wwv_flows_pk_idx rebuild compress
/

alter index wwv_flows_alias_idx rebuild compress
/
create index wwv_flows_idx_authentication on wwv_flows (authentication_id)
/

--==============================================================================
prompt ...wwv_flow_application_groups
create table wwv_flow_application_groups (
   id                         number
                              constraint wwv_flow_app_group_pk
                              primary key,
   group_name                 varchar2(255) not null,
   group_comment              varchar2(4000),
   created_on                 date,
   created_by                 varchar2(255),
   updated_on                 date,
   updated_by                 varchar2(255),
   security_group_id          number not null
                              constraint wwv_flow_app_groups_fk
                              references wwv_flow_companies(provisioning_company_id)
                              on delete cascade)
/

create index wwv_flow_app_grp_idx1 on wwv_flow_application_groups (security_group_id);

--==============================================================================
-- This table allows flows developers to reserve an ID and then choose
-- to create a flow or not to create a flow.  This prevents two developers
-- from being able to create the same flow id using the create flow wizard.
--
prompt ...wwv_flows_reserved
create table wwv_flows_reserved (
   id                          number
                               constraint wwv_flow_reserved_pk
                               primary key,
   created_on                  date,
   created_by                  varchar2(255),
   permanent_security_group_id number
   )
/

create index wwv_flows_reserved_idx on wwv_flows_reserved (created_on)
/

--==============================================================================
-- This table allows flows developers to reserve an ID and then choose
-- to create a page or not to create a page.  This prevents two developers
-- from being able to create the same flow page using the create page wizard.
--
prompt ...wwv_flow_pages_reserved

create table wwv_flow_pages_reserved (
   id                number,
   flow_id           number
                     constraint wwv_flow_pages_reserved_fk
                     references wwv_flows
                     on delete cascade,
   flow_session      number,
   created_on        date,
   created_by        varchar2(255)
   )
/

alter table wwv_flow_pages_reserved add constraint wwv_flow_pages_reserved_pk primary key (id, flow_id)
/

create index wwv_flow_pages_reserved_idx on wwv_flow_pages_reserved (created_on)
/

create index wwv_flow_pages_reserved_idx2 on wwv_flow_pages_reserved (flow_id)
/

--==============================================================================
-- Comments
--
create table  wwv_flow_app_comments (
   id                         number constraint wwv_flow_app_comments_pk
                              primary key,
   flow_id                    number not null
                              constraint wwv_flow_app_comments_fk
                              references wwv_flows
                              on delete cascade,
   pages                      varchar2(4000),
   app_comment                varchar2(4000) not null,
   created_on                 date,
   created_by                 varchar2(255),
   updated_on                 date,
   updated_by                 varchar2(255),
   comment_owner              varchar2(255),
   comment_flag               varchar2(4000),
   app_version                varchar2(255),
   security_group_id          number not null)
/

create index wwv_flow_commments_idx1 on wwv_flow_app_comments (flow_id);


--==============================================================================
-- Application Static Files
--
create table wwv_flow_static_files (
    id                        number         not null
                                             constraint wwv_flow_static_files_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_static_files_flow_fk
                                             references wwv_flows on delete cascade,
    file_name                 varchar2(255)  not null,
    mime_type                 varchar2(255)  not null,
    file_charset              varchar2(128),
    file_content              blob,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  );

alter table wwv_flow_static_files
  add constraint wwv_flow_static_files_uk unique (flow_id, file_name);

create index wwv_flow_static_files_idx1 on wwv_flow_static_files (security_group_id);

--==============================================================================
create table wwv_flow_banner (
    id                           number
                                 constraint wwv_flow_banner_fk
                                 references wwv_flows
                                 on delete cascade,
    banner                       clob,
    security_group_id            number not null)
    lob (banner) store as (cache reads enable storage in row)
/
create unique index wwv_flow_banner_u_idx on wwv_flow_banner (id)
/

--##############################################################################
--#
--# WORKSPACE USERS AND GROUPS
--#
--##############################################################################
prompt WORKSPACE USERS AND GROUPS
--==============================================================================
prompt ...wwv_flow_fnd_user
create table wwv_flow_fnd_user (
    user_id                                  number
                                             constraint wwv_flow_fnd_user_pk
                                             primary key,
    security_group_id                        number not null
                                             constraint wwv_flow_fnd_user_fk
                                             references wwv_flow_companies(provisioning_company_id)
                                             on delete cascade,
    user_name                                varchar2(100) not null,
    first_name                               varchar2(255),
    last_name                                varchar2(255),
    --
    creation_date                            date not null,
    created_by                               varchar2(255),
    last_update_date                         date not null,
    last_updated_by                          varchar2(255),
    --
    start_date                               date,
    end_date                                 date,
    person_type                              varchar2(1),
    email_address                            varchar2(240),
    --
    web_password2                            raw(255),
    web_password_version                     varchar2(20) not null
                                             constraint wwv_flow_fnd_user_ck_pwd_ver
                                             check (regexp_like (
                                                        web_password_version,
                                                        '^[135];[12345];' )),
    last_login                               date,
    builder_login_count                      number,
    last_agent                               varchar2(4000),
    last_ip                                  varchar2(4000),
    account_locked                           varchar2(1)
                                             constraint fnd_user_account_locked
                                             check (account_locked in ('Y','N')),
    account_expiry                           date,
    failed_access_attempts                   number,
    last_failed_login                        date,
    first_password_use_occurred              varchar2(1)
                                             constraint fnd_user_first_pw_use
                                             check (first_password_use_occurred in ('Y','N')),
    change_password_on_first_use             varchar2(1)
                                             constraint fnd_user_change_pw_on_first
                                             check (change_password_on_first_use in ('Y','N')),
    --
    allow_app_building_yn                    varchar2(1),
    allow_sql_workshop_yn                    varchar2(1),
    allow_websheet_dev_yn                    varchar2(1),
    allow_team_development_yn                varchar2(1),
    --
    default_schema                           varchar2(128),
    allow_access_to_schemas                  varchar2(4000),
    --
    -- mostly empty and legacy columns go to the end
    --
    description                              varchar2(240),
    -- old password fields (still needed for on the fly migration on password change)
    web_password                             varchar2(255),
    web_password_raw                         raw(255),
    -- unused password information
    password_date                            date,
    password_accesses_left                   number(15),
    password_lifespan_accesses               number(15),
    password_lifespan_days                   number(15),
    --
    default_date_format                      varchar2(255),
    known_as                                 varchar2(255),
    employee_id                              number(15),
    person_id                                number,
    --
    profile_image                            blob,
    profile_image_name                       varchar2(100),
    profile_mimetype                         varchar2(255),
    profile_filename                         varchar2(255),
    profile_last_update                      date,
    profile_charset                          varchar2(128),
    --
    attribute_01                             varchar2(4000),
    attribute_02                             varchar2(4000),
    attribute_03                             varchar2(4000),
    attribute_04                             varchar2(4000),
    attribute_05                             varchar2(4000),
    attribute_06                             varchar2(4000),
    attribute_07                             varchar2(4000),
    attribute_08                             varchar2(4000),
    attribute_09                             varchar2(4000),
    attribute_10                             varchar2(4000),
    --
    constraint wwv_flow_fnd_user_uq1         unique (security_group_id, user_name)
                                             using index compress 1
)
/

--==============================================================================
-- FLOW DEVELOPERS
--
-- EDIT        edit one or more flows and page builder
-- ADMIN       root priv on flows
-- BROWSE      priv to run the flow that allows database browsing
-- USER_MANAGERpriv to run the cookie based user manager
-- CREATE      create a new flow
-- MONITOR     monitor flow application information
-- DB_MONITOR  monitor database parameters and state
-- SQL         sql workshop
--
prompt ...wwv_flow_developers
create table wwv_flow_developers (
    id                 number
                       constraint wwv_flow_developers_pk
                       primary key,
    user_id            number
                       constraint wwv_flow_dev_fk2
                       references wwv_flow_fnd_user(user_id)
                       on delete cascade,
    userid             varchar2(255) not null,
    flow_id            number,
    email              varchar2(255),
    developer_role     varchar2(4000) not null,
    developer_comments varchar2(4000),
    security_group_id  number not null
                       constraint wwv_flow_dev_fk
                       references wwv_flow_companies(provisioning_company_id)
                       on delete cascade
    )
/
create unique index wwv_flow_developers_pk2 on wwv_flow_developers (userid,flow_id, security_group_id);
create index wwv_flow_developers_id on wwv_flow_developers (user_id);
create index wwv_flow_developers_fkidx on wwv_flow_developers (security_group_id,userid);

--==============================================================================
prompt ...wwv_flow_password_history
create table wwv_flow_password_history (
    id                                       number primary key,
    user_id                                  number
                                             constraint wwv_flow_pwhist_uid_fk
                                             references wwv_flow_fnd_user(user_id)
                                             on delete cascade
                                             initially deferred,
    password                                 raw(255),
    password_version                         varchar2(20),
    created                                  date,
    security_group_id                        number not null
                                             constraint wwv_flow_pwhist_sgid_fk
                                             references wwv_flow_companies(provisioning_company_id)
                                             on delete cascade
    )
/

create index wwv_flow_passwd_history_fkidx1 on wwv_flow_password_history (security_group_id) compress
/
create index wwv_flow_passwd_history_fkidx2 on wwv_flow_password_history (user_id) compress
/

--==============================================================================
prompt ...wwv_flow_fnd_user_groups
create table wwv_flow_fnd_user_groups (
    id                  number
                        constraint fnd_flow_user_group_pk
                        primary key,
    group_name          varchar2(255) not null,
    static_id           varchar2(255) not null,
    flow_id             number
                        constraint wwv_flow_fnd_user_grps_fk_flow
                        references wwv_flows(id)
                        on delete cascade,
    flow_group_name     varchar2(300) generated always as (
                                          case
                                          when flow_id is null then group_name
                                          else 'f'||flow_id||'-'||group_name
                                          end ) virtual,
    flow_static_id      varchar2(300) generated always as (
                                          case
                                          when flow_id is null then static_id
                                          else 'f'||flow_id||'-'||static_id
                                          end ) virtual,
    security_group_id   number not null
                        constraint wwv_flow_fnd_user_grps_fk
                        references wwv_flow_companies(provisioning_company_id)
                        on delete cascade,
    group_desc          varchar2(4000),
    constraint wwv_flow_fnd_user_groups_uk1
        unique (security_group_id, group_name, flow_id)
        using index compress 1,
    constraint wwv_flow_fnd_user_groups_uk2
        unique (security_group_id, static_id, flow_id)
        using index compress 1
)
/

create index wwv_flow_fnd_user_group_ix1 on wwv_flow_fnd_user_groups(flow_id) compress;

--==============================================================================
prompt ...wwv_flow_fnd_group_users
create table wwv_flow_fnd_group_users (
    group_id            number not null
                        constraint wwv_flow_fnd_gu_int_g_fk
                        references wwv_flow_fnd_user_groups (id)
                        on delete cascade,
    user_id             number not null
                        constraint wwv_flow_fnd_gu_int_u_fk
                        references wwv_flow_fnd_user (user_id)
                        on delete cascade,
    security_group_id   number not null,
    constraint wwv_flow_fnd_group_users_pk primary key(group_id, user_id)
) organization index compress 1
/

create index wwv_flow_fnd_group_users_ix1 on wwv_flow_fnd_group_users(user_id) compress;
create index wwv_flow_fnd_group_users_ix2 on wwv_flow_fnd_group_users(security_group_id) compress;

--==============================================================================
prompt ...wwv_flow_fnd_group_groups
create table wwv_flow_fnd_group_groups (
    grantee_group_id    number not null
                        constraint wwv_flow_fnd_group_groups_fk1
                        references wwv_flow_fnd_user_groups(id)
                        on delete cascade,
    granted_group_id    number not null
                        constraint wwv_flow_fnd_group_groups_fk2
                        references wwv_flow_fnd_user_groups(id)
                        on delete cascade,
    security_group_id   number not null,
    constraint wwv_flow_fnd_group_groups_pk primary key(grantee_group_id, granted_group_id)
) organization index compress 1
/
create index wwv_flow_fnd_group_groups_ix1 on wwv_flow_fnd_group_groups(granted_group_id) compress;
create index wwv_flow_fnd_group_groups_ix2 on wwv_flow_fnd_group_groups(security_group_id) compress;

--==============================================================================
prompt ...wwv_flow_acl_group_users
create table wwv_flow_acl_group_users (
    id                             number not null
                                   constraint wwv_flow_acl_group_users_pk
                                   primary key,
    security_group_id              number not null
                                   constraint wwv_flow_acl_group_users_fk1
                                   references wwv_flow_companies(provisioning_company_id)
                                   on delete cascade,
    user_name                      varchar2(255) not null,
    group_id                       number not null
                                   constraint wwv_flow_acl_group_users_fk2
                                   references wwv_flow_fnd_user_groups(id)
                                   on delete cascade,
    --
    created_by          varchar2(255),
    created_on          date,
    last_updated_by     varchar2(255),
    last_updated_on     date,
    --
    constraint wwv_flow_acl_group_users_uk
        unique (security_group_id, user_name, group_id)
)
/
create index wwv_flow_acl_group_users_ix1 on wwv_flow_acl_group_users(group_id) compress;

--==============================================================================
prompt ...wwv_flow_preferences$
create table wwv_flow_preferences$ (
    id                     number
                           constraint wwv_flow_prefs_pk
                           primary key,
    user_id                varchar2(255) not null,
    preference_name        varchar2(255) not null,
    attribute_value        varchar2(4000),
    tenant_id              varchar2(32),
    security_group_id      number not null
                           constraint wwv_flow_prefs_fk
                           references wwv_flow_companies(provisioning_company_id)
                           on delete cascade
    )
/

create index wwv_flow_pref_user_pref_idx on wwv_flow_preferences$ (user_id, preference_name) compress 1;
create index wwv_flow_preferences$_fkidx on wwv_flow_preferences$(security_group_id,user_id,preference_name) compress 2;

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > CREDENTIALS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > CREDENTIALS

--==============================================================================
create table wwv_credentials (
    id                  number
                        constraint wwv_credential_pk
                        primary key,
    security_group_id   number not null
                        constraint wwv_credential_wsid_fk
                        references wwv_flow_companies( provisioning_company_id )
                        on delete cascade,
    --
    name                varchar2(255) not null,
    static_id           varchar2(255) not null,
    scope               varchar2(255),
    authentication_type varchar2(25) not null
                        constraint wwv_credential_auth_type_ck check (
                            authentication_type in ( 'BASIC',
                                                     'OAUTH2_CLIENT_CREDENTIALS',
                                                     'JWT',
                                                     'OCI',
                                                     'CERTIFICATE_PAIR' )),
    client_id           varchar2(4000),
    client_secret       varchar2(4000),
    namespace           varchar2(4000),
    fingerprint         varchar2(4000),
    --
    prompt_on_install   varchar2(1) not null
                        constraint wwv_credential_prompt_inst_ck
                        check ( prompt_on_install in ('Y', 'N' )),
    --
    credential_comment  varchar2(4000),
    --
    created_by          varchar2(255),
    created_on          date,
    last_updated_by     varchar2(255),
    last_updated_on     date )
/

alter table wwv_credentials add constraint wwv_credential_ws_name_uk unique ( security_group_id, name );
alter table wwv_credentials add constraint wwv_credential_ws_staticid_uk unique ( security_group_id, static_id );

create index wwv_credential_sgid_fx on wwv_credentials ( security_group_id ) compress;

--==============================================================================

create table wwv_credential_instances (
    id                number
                      constraint wwv_cred_instance_pk
                      primary key,
    security_group_id number not null
                      constraint wwv_cred_instance_sgid_fk
                      references wwv_flow_companies( provisioning_company_id )
                      on delete cascade,
    credential_id     number not null
                      constraint wwv_cred_instance_cred_fk
                      references wwv_credentials
                      on delete cascade,
    session_id        number
                      constraint wwv_cred_instance_sess_fk
                      references wwv_flow_sessions$
                      on delete cascade,
    value_type        varchar2(13) not null
                      constraint wwv_cred_instance_type_ck check (
                          value_type in ( 'CLIENT_ID',
                                          'CLIENT_SECRET',
                                          'ACCESS_TOKEN',
                                          'REFRESH_TOKEN',
                                          'ID_TOKEN',
                                          'NAMESPACE',
                                          'FINGERPRINT' )),
    value             clob not null,
    expiry_date       date
)
/

create index wwv_cred_instance_val_ix  on wwv_credential_instances( credential_id, value_type, session_id );
create index wwv_cred_instance_sgid_fx on wwv_credential_instances( security_group_id ) compress;
create index wwv_cred_instance_cred_fx on wwv_credential_instances( credential_id );
create index wwv_cred_instance_sess_fx on wwv_credential_instances( session_id );


--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > REMOTE SERVERS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > REMOTE SERVERS

--==============================================================================
create table wwv_remote_servers (
    id                number
                      constraint wwv_remote_srvr_pk
                      primary key,
    security_group_id number not null
                      constraint wwv_remote_srvr_sgid_fk
                      references wwv_flow_companies( provisioning_company_id )
                      on delete cascade,
    --
    name              varchar2(255) not null,
    static_id         varchar2(255) not null,
    base_url          varchar2(500) not null,
    server_type       varchar2(14) not null
                      constraint wwv_remote_srvr_type_ck
                      check ( server_type in ( 'WEB_SERVICE', 'PROXY', 'REMOTE_SQL', 'AUTHENTICATION' )),
    credential_id     number
                      constraint wwv_remote_srvr_cred_fk
                      references wwv_credentials ( id )
                      on delete set null,
    --
    https_host        varchar2(500),
    --
    prompt_on_install varchar2(1) not null
                      constraint wwv_remote_srvr_prmpt_inst_ck
                      check ( prompt_on_install in ('Y', 'N' )),
    --
    ords_timezone     varchar2(255),
    ords_init_code    varchar2(4000),
    ords_cleanup_code varchar2(4000),
    --
    server_comment    varchar2(4000),
    created_by        varchar2(255),
    created_on        date,
    last_updated_by   varchar2(255),
    last_updated_on   date )
/

alter table wwv_remote_servers add constraint wwv_remote_srvr_ws_name_uk unique ( security_group_id, name );
alter table wwv_remote_servers add constraint wwv_remote_srvr_ws_stid_uk unique ( security_group_id, static_id );

create index wwv_remote_srvr_sgid_fx       on wwv_remote_servers ( security_group_id ) compress;
create index wwv_remote_srvr_credential_fx on wwv_remote_servers ( credential_id )     compress;

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > DATA PROFILES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > DATA PROFILES

--==============================================================================
create table wwv_flow_data_profiles (
    id                             number
                                   constraint wwv_flow_data_profiles_pk
                                   primary key,
    security_group_id              number not null
                                   constraint wwv_data_profiles_sgid_fk
                                   references wwv_flow_companies( provisioning_company_id ),
    flow_id                        number not null
                                   constraint wwv_data_profiles_flow_fk
                                   references wwv_flows
                                   on delete cascade,
    --
    name                           varchar2(255) not null,
    format                         varchar2(4)   not null
                                   constraint wwv_data_profile_format_ck
                                   check ( format in ( 'XML', 'JSON' )),
    encoding                       varchar2(255),
    --
    decimal_characters             varchar2(2),
    --
    row_selector                   varchar2(255),
    is_single_row                  varchar2(1)
                                   constraint wwv_data_profile_single_row
                                   check (is_single_row in ('Y', 'N')),
    single_row_selector            varchar2(255),
    xml_namespaces                 varchar2(4000),
    --
    profile_comment                varchar2(4000),
    last_updated_by                varchar2(255),
    last_updated_on                date,
    created_by                     varchar2(255),
    created_on                     date )
/

alter table wwv_flow_data_profiles add constraint wwv_data_profiles_name_uk unique (flow_id, name)
/

create index wwv_data_profiles_flow_fx on wwv_flow_data_profiles (flow_id)           compress
/
create index wwv_data_profiles_sgid_fx on wwv_flow_data_profiles (security_group_id) compress
/

--==============================================================================
create table wwv_flow_data_profile_cols (
    id                             number
                                   constraint wwv_flow_data_prof_cols_pk
                                   primary key,
    security_group_id              number not null
                                   constraint wwv_dataprof_cols_sgid_fk
                                   references wwv_flow_companies(provisioning_company_id),
    flow_id                        number not null
                                   constraint wwv_dataprof_cols_flow_fk
                                   references wwv_flows
                                   on delete cascade,
    --
    data_profile_id                number not null
                                   constraint wwv_dataprof_cols_prof_fk
                                   references wwv_flow_data_profiles
                                   on delete cascade,
    --
    name                           varchar2(128) not null,
    --
    sequence                       number not null,
    is_primary_key                 varchar2(1) not null
                                   constraint wwv_dataprof_cols_is_pk_ck
                                   check (is_primary_key in ('Y', 'N')),
    --
    data_type                      varchar2(30) not null
                                   constraint wwv_data_prof_cols_type_ck
                                   check ( data_type in ( 'NUMBER',
                                                          'VARCHAR2',
                                                          'CLOB',
                                                          -- 'BLOB',
                                                          'DATE',
                                                          'TIMESTAMP',
                                                          'TIMESTAMP WITH TIME ZONE',
                                                          'TIMESTAMP WITH LOCAL TIME ZONE',
                                                          'DOCUMENT_FRAGMENT') ),
    max_length                     number(5),
                                   constraint wwv_dataprof_cols_maxlen_ck
                                   check ( max_length > 0 ),
    format_mask                    varchar2(255),
    has_time_zone                  varchar2(1)
                                   constraint wwv_dataprof_cols_has_tz_ck
                                   check (has_time_zone in ('Y', 'N')),
    --
    is_hidden                      varchar2(1) not null
                                   constraint wwv_dataprof_col_hidden_ck
                                   check (is_hidden in ('Y', 'N')),
    --
    selector                       varchar2(255),
    sql_expression                 varchar2(4000),
    remote_attribute_name          varchar2(255),
    --
    column_comment                 varchar2(4000),
    last_updated_by                varchar2(255),
    last_updated_on                date,
    created_by                     varchar2(255),
    created_on                     date )
/

alter table wwv_flow_data_profile_cols add constraint wwv_dataprof_cols_name_uk unique (data_profile_id, name)
/

alter table wwv_flow_data_profile_cols add constraint wwv_dataprof_cols_type_ck check (
    selector is not null or sql_expression is not null )
/

create index wwv_dataprof_cols_sgid_fx      on wwv_flow_data_profile_cols (security_group_id)         compress
/
create index wwv_dataprof_cols_flow_prof_ix on wwv_flow_data_profile_cols (flow_id, data_profile_id)  compress 1
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > WEB SOURCES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > WEB SOURCES

--==============================================================================
create table wwv_flow_web_src_modules (
    id                             number
                                   constraint wwv_flow_web_src_modules_pk
                                   primary key,
    security_group_id              number not null
                                   constraint wwv_websrc_module_sgid_fk
                                   references wwv_flow_companies(provisioning_company_id),
    flow_id                        number not null
                                   constraint wwv_websrc_module_flow_fk
                                   references wwv_flows
                                   on delete cascade,
    name                           varchar2(255) not null,
    static_id                      varchar2(255) not null,
    --
    web_source_type                varchar2(11) not null
                                   constraint wwv_websrc_module_type_ck
                                   check ( web_source_type in ( 'SOAP', 'ORDS_2', 'ORDS_3', 'HTTP_FEED', 'ADFBC', 'CUSTOM', 'OCI' )),
    data_profile_id                number not null
                                   constraint wwv_websrc_module_dataprof_fk
                                   references wwv_flow_data_profiles
                                   on delete cascade,
    --
    remote_server_id               number not null
                                   constraint wwv_websrc_module_rserver_fk
                                   references wwv_remote_servers,
    url_path_prefix                varchar2(500) not null,
    --
    auth_remote_server_id          number
                                   constraint wwv_websrc_mod_auth_rserver_fk
                                   references wwv_remote_servers,
    auth_url_path_prefix           varchar2(500),
    credential_id                  number
                                   constraint wwv_websrc_mod_credential_fk
                                   references wwv_credentials (id)
                                   on delete set null,
    --
    timeout                        number,
    pass_ecid                      varchar2(1) not null
                                   constraint wwv_websrc_module_passecid_ck
                                   check( pass_ecid in ( 'Y', 'N' ) ),
    --
    reference_id                   number,
    --
    module_comment                 varchar2(4000),
    --
    last_updated_by                varchar2(255),
    last_updated_on                date,
    created_by                     varchar2(255),
    created_on                     date )
/

alter table wwv_flow_web_src_modules add constraint wwv_websrc_module_name_uk unique (flow_id, name) using index compress 1
/
alter table wwv_flow_web_src_modules add constraint wwv_websrc_module_staticid_uk unique (flow_id, static_id) using index compress 1
/

create index wwv_websrc_module_sgid_fx      on wwv_flow_web_src_modules (security_group_id)     compress
/
create index wwv_websrc_module_dataprof_fx  on wwv_flow_web_src_modules (data_profile_id)       compress
/
create index wwv_websrc_module_rserver_fx   on wwv_flow_web_src_modules (remote_server_id)      compress
/
create index wwv_websrc_module_ref_ix       on wwv_flow_web_src_modules (reference_id)          compress
/
create index wwv_websrc_mod_credential_fx   on wwv_flow_web_src_modules (credential_id)         compress
/
create index wwv_websrc_mod_auth_rserver_fx on wwv_flow_web_src_modules (auth_remote_server_id) compress
/

--==============================================================================
create table wwv_flow_web_src_operations (
    id                             number
                                   constraint wwv_flow_web_src_opers_pk
                                   primary key,
    security_group_id              number not null
                                   constraint wwv_websrc_opers_sgid_fk
                                   references wwv_flow_companies(provisioning_company_id),
    flow_id                        number not null
                                   constraint wwv_websrc_opers_flow_fk
                                   references wwv_flows
                                   on delete cascade,
    --
    web_src_module_id              number not null
                                   constraint wwv_websrc_opers_module_fk
                                   references wwv_flow_web_src_modules
                                   on delete cascade,
    data_profile_id                number
                                   constraint wwv_websrc_opers_dataprof_fk
                                   references wwv_flow_data_profiles
                                   on delete cascade,
    --
    operation                      varchar2(255) not null,
    database_operation             varchar2(16)
                                   constraint wwv_websrc_opers_dboper_ck
                                   check (database_operation in ('INSERT', 'UPDATE', 'DELETE', 'FETCH_COLLECTION', 'FETCH_SINGLE_ROW')),
    --
    url_pattern                    varchar2(500) not null,
    -- legacy SOAP Envelope to be stored as Request Body Template
    -- can also be used for custom REST services where we cannot map items to JSON - will use a template / replace mechanism
    -- like in previous versions with SOAP
    request_body_template          clob,
    --
    legacy_ords_fixed_page_size    number,
    allow_fetch_all_rows           varchar2(1),
                                   constraint wwv_websrc_opers_allrows_ck
                                   check (allow_fetch_all_rows in ('Y', 'N')),
    fetch_all_rows_timeout         number,
    --
    caching                        varchar2(9)
                                   constraint wwv_websrc_opers_cache_ck
                                   check (caching in ( 'ALL_USERS', 'USER', 'SESSION')),
    invalidate_when                varchar2(4000),
    --
    security_scheme                varchar2(255),
    --
    operation_comment              varchar2(4000),
    --
    last_updated_by                varchar2(255),
    last_updated_on                date,
    created_by                     varchar2(255),
    created_on                     date )
/

alter table wwv_flow_web_src_operations add constraint wwv_websrc_opers_oper_uk   unique (flow_id, web_src_module_id, url_pattern, operation)
/

-- for the unique index, map database operations of NULL to the operation ID. That will allow to have non-NULL database
-- operations only once, but multiple NULL database operations.
create unique index wwv_websrc_opers_dboper_uk on wwv_flow_web_src_operations( flow_id, web_src_module_id, coalesce( database_operation, to_char( id ) ) )
/

create index wwv_websrc_opers_sgid_fx     on wwv_flow_web_src_operations (security_group_id) compress
/
create index wwv_websrc_opers_flow_fx     on wwv_flow_web_src_operations (flow_id)           compress
/
create index wwv_websrc_opers_module_fx   on wwv_flow_web_src_operations (web_src_module_id) compress
/
create index wwv_websrc_opers_dataprof_fx on wwv_flow_web_src_operations (data_profile_id)   compress
/

--==============================================================================
create table wwv_flow_web_src_params (
    id                             number
                                   constraint wwv_flow_web_src_params_pk
                                   primary key,
    security_group_id              number not null
                                   constraint wwv_websrc_param_sgid_fk
                                   references wwv_flow_companies(provisioning_company_id),
    flow_id                        number not null
                                   constraint wwv_websrc_param_flow_fk
                                   references wwv_flows
                                   on delete cascade,
    --
    web_src_module_id              number
                                   constraint wwv_websrc_param_module_fk
                                   references wwv_flow_web_src_modules
                                   on delete cascade,
    web_src_operation_id           number
                                   constraint wwv_websrc_param_opers_fk
                                   references wwv_flow_web_src_operations
                                   on delete cascade,
    --
    name                           varchar2(255) not null,
    param_type                     varchar2(12)  not null,
                                   constraint wwv_websrc_param_type_ck
                                   check (param_type in ('HEADER', 'QUERY_STRING', 'URL_PATTERN', 'BODY', 'COOKIE' )),
    is_required                    varchar2(1)   not null,
                                   constraint wwv_websrc_param_isreq_ck
                                   check (is_required in ('Y', 'N')),
    direction                      varchar2(6)   not null,
                                   constraint wwv_websrc_param_direction_ck
                                   check (direction in ('IN', 'OUT', 'IN_OUT')),
    --
    value                          varchar2(4000),
    is_static                      varchar2(1) not null,
                                   constraint wwv_websrc_param_isstatic_ck
                                   check (is_static in ('Y', 'N')),
    is_array                       varchar2(1) not null,
                                   constraint wwv_websrc_param_isarray_ck
                                   check (is_array in ('Y', 'N')),
    omit_when_null                 varchar2(1) default 'N' not null
                                   constraint wwv_websrc_param_omitnull_ck
                                   check (omit_when_null in ('Y', 'N')),
    is_query_param                 varchar2(1) default 'N' not null
                                   constraint wwv_websrc_param_isquery_ck
                                   check (is_query_param in ('Y', 'N')),
    --
    param_comment                  varchar2(4000),
    --
    last_updated_by                varchar2(255),
    last_updated_on                date,
    created_by                     varchar2(255),
    created_on                     date )
/

alter table wwv_flow_web_src_params add constraint wwv_websrc_parameter_uk unique (flow_id, web_src_module_id, web_src_operation_id, direction, name)
/

create index wwv_websrc_param_sgid_fx     on wwv_flow_web_src_params (security_group_id)    compress
/
create index wwv_websrc_param_flow_fx     on wwv_flow_web_src_params (flow_id)              compress
/
create index wwv_websrc_param_module_fx   on wwv_flow_web_src_params (web_src_module_id)    compress
/
create index wwv_websrc_param_opers_fx    on wwv_flow_web_src_params (web_src_operation_id) compress
/

--==============================================================================
create table wwv_flow_content_cache1$(
    id                   number not null
                         constraint wwv_content_cache1_pk
                         primary key,
    security_group_id    number not null,
    flow_id              number not null
                         constraint wwv_content_cache1_flow_fk
                         references wwv_flows
                         on delete cascade,
    session_id           number
                         constraint wwv_content_cache1_session_fk
                         references wwv_flow_sessions$
                         on delete cascade,
    user_name            varchar2(255),
    --
    component_type       number not null,
    component_id         number not null,
    --
    priority             number,
    --
    key                  varchar2(255) not null,
    --
    content_clob         clob,
    content_length       number,
    --
    cached_on            date,
    valid_until          date )
    --
    pctfree 0
    lob (content_clob) store as (
        pctversion 0
        cache
        disable storage in row )
;

alter table wwv_flow_content_cache1$ add constraint wwv_content_cache_record_un unique(
    security_group_id, flow_id, component_id, user_name, session_id, key, valid_until );

create index wwv_contentcache1_flowkey_ix  on wwv_flow_content_cache1$ ( security_group_id, flow_id, key ) compress;

create index wwv_contentcache1_flowcomp_ix on wwv_flow_content_cache1$ ( security_group_id, flow_id, component_id ) compress;

create index wwv_contentcache1_sess_ix     on wwv_flow_content_cache1$ ( session_id );

create index wwv_contentcache1_flow_ix     on wwv_flow_content_cache1$ ( flow_id );

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > AUTHORIZATION
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > AUTHORIZATION

--==============================================================================
prompt ...create wwv_flow_security_schemes
create table wwv_flow_security_schemes (
   id                         number
                              constraint wwv_flow_sec_scheme_pk
                              primary key,
   security_group_id          number not null,
   flow_id                    number not null
                              constraint wwv_flow_sec_schemes_fk
                              references wwv_flows
                              on delete cascade,
   name                       varchar2(255) not null,
   scheme_type                varchar2(255) not null
                              constraint wwv_flow_sec_schemes_type_ck
                              check (
                                  scheme_type in (
                                    'EXISTS',
                                    'NOT_EXISTS',
                                    'ITEM_IS_NULL',
                                    'ITEM_IS_NOT_NULL',
                                    'FUNCTION_RETURNING_BOOLEAN',
                                    'PREFERENCE_EQ_COND_TEXT',
                                    'PREFERENCE_NOT_EQ_COND_TEXT',
                                    'VAL_OF_ITEM_IN_COND_EQ_COND_TEXT',
                                    'VAL_OF_ITEM_IN_COND_NOT_EQ_COND_TEXT')
                                  or scheme_type like 'NATIVE\_%' escape '\'
                                  or scheme_type like 'PLUGIN\_%' escape '\'),
   --
   attribute_01               varchar2(4000),
   attribute_02               varchar2(4000),
   attribute_03               varchar2(4000),
   attribute_04               varchar2(4000),
   attribute_05               varchar2(4000),
   attribute_06               varchar2(4000),
   attribute_07               varchar2(4000),
   attribute_08               varchar2(4000),
   attribute_09               varchar2(4000),
   attribute_10               varchar2(4000),
   attribute_11               varchar2(4000),
   attribute_12               varchar2(4000),
   attribute_13               varchar2(4000),
   attribute_14               varchar2(4000),
   attribute_15               varchar2(4000),
   --
   -- $$$ scheme+scheme_text are obsolete (replaced by plugin attributes but required for migration)
   scheme                     varchar2(4000),
   scheme_text                varchar2(4000),
   --
   error_message              varchar2(4000) not null,
   caching                    varchar2(20)   not null
                              constraint wwv_flow_sec_scheme_cache check (caching in (
                              'BY_USER_BY_SESSION',
                              'BY_USER_BY_PAGE_VIEW',
                              'BY_COMPONENT',
                              'NOCACHE' )),
   reference_id               number,
   last_updated_by            varchar2(255),
   last_updated_on            date,
   created_by                 varchar2(255),
   created_on                 date,
   comments                   varchar2(4000)
   )
/

create index wwv_flow_security_schem_fkidx on wwv_flow_security_schemes (flow_id,name)
compress 1
/
create index wwv_flow_security_schem_idx1 on wwv_flow_security_schemes (reference_id)
compress
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > BUILD OPTIONS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > BUILD OPTIONS

--==============================================================================
create table wwv_flow_patches (
    id                           number
                                 constraint wwv_flow_patches_pk
                                 primary  key,
    flow_id                      number  not null
                                 constraint wwv_flow_patches_fk
                                 references wwv_flows
                                 on delete cascade,
    patch_name                   varchar2(255) not null,
    patch_status                 varchar2(30)  not null
                                 constraint wwv_flow_patch_valid_status check (patch_status in ('INCLUDE','EXCLUDE')),
    security_group_id            number not null,
    --
    default_on_export            varchar2(30),
    on_upgrade_keep_status       varchar2(1) default 'N' not null
                                 constraint wwv_flow_patch_keep_status_ck check (on_upgrade_keep_status in ('Y', 'N')),
    --
    feature_identifier           varchar2(4000),
    attribute1                   varchar2(255),
    attribute2                   varchar2(255),
    attribute3                   varchar2(255),
    attribute4                   varchar2(255),
    --
    last_updated_by              varchar2(255),
    last_updated_on              date,
     -- 4.0
    created_by                   varchar2(255),
    created_on                   date,
    patch_comment                varchar2(4000)
    )
/

create unique index wwv_flow_patches_fkidx on wwv_flow_patches(flow_id,id)
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > THEMES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > THEMES

--==============================================================================
prompt themes
create table wwv_flow_themes (
     id                          number
                                 constraint wwv_flow_themes_PK
                                 primary key,
     flow_id                     number not null
                                 constraint wwv_flow_themes_2f_fk
                                 references wwv_flows
                                 on delete cascade,
     theme_id                    number not null,
     ui_type_id                  number default 1 not null /* defaults to DESKTOP */
                                 constraint wwv_flow_theme_ui_type_fk
                                 references wwv_flow_ui_types,
     navigation_type             varchar2(1) default 'T' not null
                                 constraint wwv_flow_theme_nav_type
                                      check ( navigation_type in ('T', 'L' ) ),
     nav_bar_type                varchar2(20) default 'NAVBAR' not null
                                 constraint wwv_flow_theme_navbar_type
                                      check ( nav_bar_type in ('NAVBAR', 'LIST' ) ),
     security_group_id           number not null,
     theme_name                  varchar2(255) not null,
     theme_internal_name         varchar2(255)
                                 constraint wwv_flow_theme_int_name_ck
                                      check (upper(theme_internal_name)=theme_internal_name),
     reference_id                number,
     is_locked                   varchar2(1) default 'N' not null
                                 constraint wwv_flow_theme_is_locked_ck
                                      check ( is_locked in ('Y', 'N' ) ),
     default_page_template       number,
     default_dialog_template     number,
     error_template              number,
     printer_friendly_template   number,
     login_template              number,
     default_button_template     number,
     default_region_template     number,
     default_chart_template      number,
     default_form_template       number,
     default_reportr_template    number,
     default_tabform_template    number,
     default_wizard_template     number,
     default_menur_template      number,
     default_listr_template      number,
     default_irr_template        number,
     default_report_template     number,
     default_label_template      number,
     default_menu_template       number,
     default_calendar_template   number,
     default_list_template       number,
     default_nav_list_position   varchar2(20) constraint wwv_flow_themes_nav_pos_ck
                                     check ( default_nav_list_position in ('TOP','SIDE') ),
     default_nav_list_template   number,
     default_top_nav_list_template  number,
     default_side_nav_list_template number,
     default_option_label        number,
     default_required_label      number,
     default_header_template     number,
     default_footer_template     number,
     default_dialogr_template    number,
     default_dialogbtnr_template number,
     breadcrumb_display_point    varchar2(2000),
     sidebar_display_point       varchar2(2000),
     default_page_transition     varchar2(20) default 'NONE' not null
                                 constraint wwv_flow_theme_page_trans_ck
                                      check ( default_page_transition in ('NONE', 'FADE', 'POP', 'FLIP', 'TURN', 'FLOW', 'SLIDEFADE', 'SLIDE', 'SLIDEUP', 'SLIDEDOWN') ),
     default_popup_transition    varchar2(20) default 'NONE' not null
                                 constraint wwv_flow_theme_popup_trans_ck
                                      check ( default_popup_transition in ('NONE', 'FADE', 'POP', 'FLIP', 'TURN', 'FLOW', 'SLIDEFADE', 'SLIDE', 'SLIDEUP', 'SLIDEDOWN') ),
     default_nav_bar_list_template number,
     --
     /* $$$ mobile_* to be removed */
     mobile_login_template       number,
     mobile_page_template        number,
     mobile_region_template      number,
     mobile_list_template        number,
     mobile_report_template      number,
     mobile_calendar_template    number,
     mobile_button_template      number,
     mobile_required_label       number,
     mobile_optional_label       number,
     --
     theme_description           varchar2(4000),
     theme_image                 blob,
     theme_image_mime_type       varchar2(255),
     custom_image                varchar2(1),
     theme_security_group_id     number,
     file_prefix                 varchar2(255),
     files_version               number default 1 not null,
     --
     calendar_icon               varchar2(255),
     calendar_icon_attr          varchar2(4000),
     --
     custom_icon_classes         varchar2(4000),
     custom_library_file_urls    varchar2(4000),
     custom_icon_prefix_class    varchar2(30),
     icon_library                varchar2(255)
                                 constraint wwv_flow_theme_icon_lib_ck
                                 check ( icon_library in ( 'FONTAPEX', 'FONTAPEX_LATEST' ) ),
     javascript_file_urls        varchar2(4000),
     css_file_urls               varchar2(4000),
     --
     last_updated_on             date,
     last_updated_by             varchar2(255),
     -- 4.0
     created_by                  varchar2(255),
     created_on                  date
     )
/

create unique index wwv_flow_themes_idx1 on wwv_flow_themes (flow_id, theme_id)
/

create index wwv_flow_themes_idx2 on wwv_flow_themes (security_group_id, reference_id)
/

create index wwv_flow_themes_idx3 on wwv_flow_themes (ui_type_id)
/

--==============================================================================
create table wwv_flow_theme_styles (
    id                             number         not null
                                                  constraint wwv_flow_theme_style_pk
                                                  primary key,
    flow_id                        number         not null
                                                  constraint wwv_flow_theme_style_flow_fk
                                                  references wwv_flows on delete cascade,
    theme_id                       number         not null, /* no FK, because that's the theme no and not the internal id */
    name                           varchar2(30)   not null,
    css_file_urls                  varchar2(4000),
    is_current                     varchar2(1)    not null
                                                  constraint wwv_flow_theme_style_curr_ck
                                                       check ( is_current in ( 'Y', 'N') ),
    --
    theme_roller_input_file_urls   varchar2(4000),
    theme_roller_config            clob,
    theme_roller_output_file_url   varchar2(4000),
    theme_roller_read_only         varchar2(1)    constraint wwv_flow_theme_style_ro_ck
                                                       check ( theme_roller_read_only in ( 'Y', 'N') ),
    --
    is_public                      varchar2(1)    default 'N' not null
                                                  constraint wwv_flow_theme_style_pu_ck
                                                       check ( is_public in ( 'Y', 'N') ),
    is_accessible                  varchar2(1)    default 'N' not null
                                                  constraint wwv_flow_theme_style_acc_ck
                                                       check ( is_accessible in ( 'Y', 'N') ),
    --
    reference_id                   number,
    component_comment              varchar2(4000),
    security_group_id              number         not null,
    created_by                     varchar2(255),
    created_on                     date,
    last_updated_by                varchar2(255),
    last_updated_on                date
  )
/

alter table wwv_flow_theme_styles add constraint wwv_flow_theme_style_uk unique (flow_id, theme_id, name)
/

create index wwv_flow_theme_style_idx1 on wwv_flow_theme_styles (security_group_id, reference_id)
/

--==============================================================================
create table wwv_flow_theme_display_points (
    id                        number         not null
                                             constraint wwv_theme_disp_point_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_theme_disp_point_fk
                                             references wwv_flows on delete cascade,
    theme_id                  number         not null, /* no FK, because that's the theme no and not the internal id */
    name                      varchar2(30)   not null,
    placeholder               varchar2(30)   not null
                                             constraint wwv_theme_disp_point_upper_ck
                                                  check ( placeholder = upper(placeholder) ),
    has_grid_support          varchar2(1)    not null
                                             constraint wwv_theme_disp_point_grid_ck
                                                  check ( has_grid_support in ( 'Y', 'N') ),
    max_fixed_grid_columns    number,
    reference_id              number,
    component_comment         varchar2(4000),
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  )
/

alter table wwv_flow_theme_display_points add constraint wwv_theme_disp_point_uk1 unique (flow_id, theme_id, placeholder)
/

alter table wwv_flow_theme_display_points add constraint wwv_theme_disp_point_uk2 unique (flow_id, theme_id, name)
/

create index wwv_theme_disp_point_idx1 on wwv_flow_theme_display_points (security_group_id, reference_id)
/

--==============================================================================
create table wwv_flow_theme_files (
    id                        number         not null
                                             constraint wwv_flow_theme_file_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_theme_file_flow_fk
                                             references wwv_flows on delete cascade,
    theme_id                  number         not null, /* no FK, because that's the theme no and not the internal id */
    file_name                 varchar2(255)  not null,
    mime_type                 varchar2(255)  not null,
    file_charset              varchar2(128),
    file_content              blob,
    reference_id              number,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  );

alter table wwv_flow_theme_files
  add constraint wwv_flow_theme_files_uk unique (flow_id, theme_id, file_name);

create index wwv_flow_theme_files_idx1 on wwv_flow_theme_files (security_group_id, reference_id);



--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > TEMPLATES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > TEMPLATES

--==============================================================================
-- P A G E   T E M P L A T E S
--
create table wwv_flow_templates (
    id                            number
                                  constraint wwv_flow_templates_pk
                                  primary key,
    flow_id                       number not null
                                  constraint wwv_flow_templates_fk
                                  references wwv_flows
                                  on delete cascade,
    name                          varchar2(255) not null,
    internal_name                 varchar2(255)
                                              constraint wwv_flow_page_tmpl_int_name_ck
                                                   check (upper(internal_name)=internal_name),
    look                          number,
    is_popup                      varchar2(1) default 'N' not null
                                              constraint wwv_flow_templates_is_popup_ck
                                                   check ( is_popup in ('Y', 'N' ) ),
    javascript_file_urls          varchar2(4000),
    javascript_code               clob,
    javascript_code_onload        clob,
    dialog_js_init_code           varchar2(255),
    dialog_js_close_code          varchar2(255),
    dialog_js_cancel_code         varchar2(255),
    css_file_urls                 varchar2(4000),
    inline_css                    clob,
    header_template               clob,
    footer_template               clob,
    success_message               varchar2(4000),
    --
    current_tab                   varchar2(4000),
    current_tab_font_attr         varchar2(255),
    non_current_tab               varchar2(4000),
    non_current_tab_font_attr     varchar2(255),
    --
    current_image_tab             varchar2(4000),
    non_current_image_tab         varchar2(4000),
    --
    top_current_tab               varchar2(4000),
    top_current_tab_font_attr     varchar2(255),
    top_non_current_tab           varchar2(4000),
    top_non_current_tab_font_attr varchar2(255),
    --
    box                           clob,
    navigation_bar                varchar2(4000),
    navbar_entry                  varchar2(4000),
    body_title                    varchar2(4000),
    message                       varchar2(4000),
    attribute1                    varchar2(4000),
    attribute2                    varchar2(4000),
    attribute3                    varchar2(4000),
    attribute4                    varchar2(4000),
    attribute5                    varchar2(4000),
    attribute6                    varchar2(4000),
    default_button_position       varchar2(30),
    --
    table_bgcolor                 varchar2(255),
    heading_bgcolor               varchar2(255),
    table_cattributes             varchar2(255),
    font_size                     varchar2(255),
    font_face                     varchar2(255),
    --
    region_table_cattributes      varchar2(255),
    --
    error_page_template           varchar2(4000),
    reference_id                  number,
    --
    breadcrumb_def_reg_pos        varchar2(255),
    sidebar_def_reg_pos           varchar2(255),
    --
    grid_type                     varchar2(8)    default 'TABLE' not null
                                                 constraint wwv_tmpl_grid_type_ck
                                                 check (grid_type in ('TABLE', 'FIXED', 'VARIABLE')),
    grid_max_columns              number(2)
                                                 constraint wwv_tmpl_grid_max_col_ck
                                                 check (grid_max_columns between 1 and 99),
    grid_always_use_max_columns   varchar2(1)
                                                 constraint wwv_tmpl_grid_always_max_ck
                                                 check ( grid_always_use_max_columns in ( 'Y', 'N') ),
    grid_has_column_span          varchar2(1)
                                                 constraint wwv_tmpl_grid_colspan_ck
                                                 check ( grid_has_column_span in ( 'Y', 'N') ),
    grid_always_emit              varchar2(1)
                                                 constraint wwv_tmpl_grid_always_emit_ck
                                                 check ( grid_always_emit in ( 'Y', 'N') ),
    grid_emit_empty_leading_cols  varchar2(1)
                                                 constraint wwv_tmpl_grid_leading_cols_ck
                                                 check ( grid_emit_empty_leading_cols in ( 'Y', 'N') ),
    grid_emit_empty_trailing_cols varchar2(1)
                                                 constraint wwv_tmpl_grid_trail_cols_ck
                                                 check ( grid_emit_empty_trailing_cols in ( 'Y', 'N') ),
    grid_default_label_col_span   number
                                                 constraint wwv_tmpl_grid_label_colspan_ck
                                                 check (grid_default_label_col_span between 1 and 99),
    grid_template                 varchar2(4000),
    grid_row_template             varchar2(4000),
    grid_column_template          varchar2(4000),
    grid_first_column_attributes  varchar2(255),
    grid_last_column_attributes   varchar2(255),
    grid_javascript_debug_code    varchar2(4000),
    --
    dialog_width                  varchar2(20),
    dialog_max_width              varchar2(20),
    dialog_height                 varchar2(20),
    dialog_css_classes            varchar2(255),
    dialog_browser_frame          varchar2(20)
                                                 constraint wwv_tmpl_dialog_frame_ck
                                                 check ( regexp_like( dialog_browser_frame, '^((^|:)(MODAL|NON_MODAL))*$' )),
    --
    required_patch                number,
    security_group_id             number not null,
    --
    theme_id                      number,
    theme_class_id                number,
    default_template_options      varchar2(255),
    preset_template_options       varchar2(255),
    --
    last_updated_by               varchar2(255),
    last_updated_on               date,
    -- 4.0
    created_by                    varchar2(255),
    created_on                    date,
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_trans_temp
                                    check (translate_this_template in ('Y','N')),
    template_comment              varchar2(4000),
    -- $$$ remove
    mobile_page_template          varchar2(1)
                                    constraint wwv_flow_mobile_temp
                                    check (mobile_page_template in ('Y','N')),
    --
    app_tab_before_tabs           varchar2(4000), -- obsolete
    app_tab_current_tab           varchar2(4000), -- obsolete
    app_tab_non_current_tab       varchar2(4000), -- obsolete
    app_tab_after_tabs            varchar2(4000), -- obsolete
    --
    has_edit_links                varchar2(1) /* Deprecated */
)   lob (header_template, footer_template, box) store as (cache reads enable storage in row)
/

create index wwv_flow_template_idx1 on wwv_flow_templates (security_group_id, reference_id) compress
/
create unique index wwv_flow_template_idx2 on wwv_flow_templates (flow_id, theme_id, name) compress
/


--==============================================================================
create table wwv_flow_page_tmpl_disp_points (
    id                        number         not null
                                             constraint wwv_page_tmpl_dp_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_page_tmpl_dp_fk
                                             references wwv_flows on delete cascade,
    page_template_id          number         not null
                                             constraint wwv_page_tmpl_dp_parent_fk
                                             references wwv_flow_templates on delete cascade,
    name                      varchar2(30)   not null,
    placeholder               varchar2(30)   not null
                                             constraint wwv_page_tmpl_dp_upper_ck
                                                  check ( placeholder = upper(placeholder) ),
    has_grid_support          varchar2(1)    not null
                                             constraint wwv_page_tmpl_dp_grid_ck
                                                  check ( has_grid_support in ( 'Y', 'N') ),
    glv_new_row               varchar2(1)    default 'Y' not null
                                             constraint wwv_page_tmpl_dp_glv_nr_ck
                                                  check ( glv_new_row in ( 'Y', 'N' )),
    max_fixed_grid_columns    number,
    component_comment         varchar2(4000),
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  )
/

alter table wwv_flow_page_tmpl_disp_points
  add constraint wwv_page_tmpl_dp_uk1 unique (page_template_id, placeholder);

alter table wwv_flow_page_tmpl_disp_points
  add constraint wwv_page_tmpl_dp_uk2 unique (page_template_id, name);

create index wwv_page_tmpl_dp_flow_fx on wwv_flow_page_tmpl_disp_points (flow_id);

--==============================================================================
-- F I E L D   T E M P L A T E S
create table wwv_flow_field_templates (
    id                            number
                                    constraint wwv_flow_field_template_pk
                                        primary key,
    flow_id                       number not null
                                    constraint wwv_flow_field_temp_f_fk
                                        references wwv_flows on delete cascade,
    security_group_id             number not null,
    --
    theme_id                      number,
    theme_class_id                number,
    default_template_options      varchar2(255),
    preset_template_options       varchar2(255),
    --
    template_name                 varchar2(255) not null,
    internal_name                 varchar2(255)
                                        constraint wwv_flow_fld_tmpl_int_name_ck
                                            check (upper(internal_name)=internal_name),
    template_body1                varchar2(4000),
    template_body2                varchar2(4000),
    before_item                   varchar2(4000),
    after_item                    varchar2(4000),
    item_pre_text                 varchar2(4000),
    item_post_text                varchar2(4000),
    before_element                varchar2(4000),
    after_element                 varchar2(4000),
    help_link                     varchar2(4000),
    inline_help_text              varchar2(4000),
    reference_id                  number,
    on_error_before_label         varchar2(4000),
    on_error_after_label          varchar2(4000),
    error_template                varchar2(4000),
    last_updated_on               date,
    last_updated_by               varchar2(255),
    -- 4.0
    created_by                    varchar2(255),
    created_on                    date,
    translate_this_template       varchar2(1)
                                        constraint wwv_flow_field_trans_temp
                                            check (translate_this_template in ('Y','N')),
    template_comment              varchar2(4000)
    )
/

create index wwv_flow_field_temp_idx1 on wwv_flow_field_templates (security_group_id, reference_id)
/
create unique index wwv_flow_field_temp_idx2 on wwv_flow_field_templates (flow_id, theme_id, template_name)
/

--==============================================================================
-- P A G E   B U T T O N    T E M P L A T E S
create table wwv_flow_button_templates (
    id                        number
                                constraint wwv_flow_button_temp_pk
                                    primary key,
    flow_id                   number not null
                                constraint wwv_flow_buttont_fk
                                    references wwv_flows
                                    on delete cascade,
    template_name             varchar2(255) not null,
    internal_name             varchar2(255)
                                constraint wwv_flow_bt_tmpl_int_name_ck
                                    check (upper(internal_name)=internal_name),
    template                  clob not null,
    hot_template              clob,
    security_group_id         number not null,
    reference_id              number,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    -- 4.0
    created_by                varchar2(255),
    created_on                date,
    --
    theme_id                  number,
    theme_class_id            number,
    default_template_options  varchar2(255),
    preset_template_options   varchar2(255),
    --
    translate_this_template   varchar2(1)
                                constraint wwv_flow_button_trans_temp
                                    check (translate_this_template in ('Y','N')),
    template_comment          varchar2(4000)
    ) lob (template) store as (cache reads enable storage in row)
/

create index wwv_flow_button_temp_idx1 on wwv_flow_button_templates (security_group_id, reference_id)
/
create unique index wwv_flow_button_temp_idx2 on wwv_flow_button_templates (flow_id, theme_id, template_name)
/

--==============================================================================
-- P A G E   R E G I O N    T E M P L A T E S   (PLUG TEMPLATES)
create table wwv_flow_page_plug_templates (
    id                             number
                                        constraint wwv_flow_plug_temp_pk
                                            primary key,
    flow_id                        number not null
                                        constraint wwv_flow_plug_temp_fk
                                            references wwv_flows
                                            on delete cascade,
    page_plug_template_name        varchar2(255) not null,
    internal_name                  varchar2(255)
                                        constraint wwv_flow_reg_tmpl_int_name_ck
                                            check (upper(internal_name)=internal_name),
    javascript_file_urls           varchar2(4000),
    javascript_code_onload         varchar2(4000),
    css_file_urls                  varchar2(4000),
    layout                         varchar2(10) default 'TABLE' not null
                                        constraint wwv_flow_plug_temp_layout_ck
                                            check ( layout in ('TABLE', 'FIELD_TEMPLATE', 'FLEXIBLE' ) ),
/* $$$ render_form_items_in_table should be removed */
    render_form_items_in_table     varchar2(1) default 'Y'
                                     constraint page_plug_templ_form_as_table
                                     check (render_form_items_in_table in ('Y','N')),
    template                       clob not null,
    template2                      clob,
    template3                      clob,
    sub_plug_header_template       varchar2(4000),
    sub_plug_header_entry_template varchar2(4000),
    sub_plug_template              varchar2(4000),
    plug_table_bgcolor             varchar2(255),
    plug_heading_bgcolor           varchar2(255),
    plug_font_size                 varchar2(255),
    sub_image_open                 varchar2(4000), -- mike 4.0
    sub_image_close                varchar2(4000), -- mike 4.0
    default_field_template_id      number
                                        constraint wwv_flow_plug_temp_field_fk
                                            references wwv_flow_field_templates (id),
    default_req_field_template_id  number
                                        constraint wwv_flow_plug_temp_req_fld_fk
                                            references wwv_flow_field_templates (id),
    default_label_alignment        varchar2(30) default 'RIGHT'
                                        constraint wwv_flow_plug_temp_label_a_ck
                                                check (default_label_alignment in ( 'LEFT',
                                                                                    'RIGHT',
                                                                                    'CENTER',
                                                                                    'ABOVE',
                                                                                    'BELOW',
                                                                                    'LEFT-TOP',
                                                                                    'RIGHT-TOP',
                                                                                    'CENTER-TOP',
                                                                                    'LEFT-BOTTOM',
                                                                                    'RIGHT-BOTTOM',
                                                                                    'CENTER-BOTTOM',
                                                                                    'LEFT-CENTER',
                                                                                    'RIGHT-CENTER',
                                                                                    'CENTER-CENTER'
                                                                            )),
    default_field_alignment        varchar2(30) default 'LEFT'
                                        constraint wwv_flow_plug_temp_field_a_ck
                                            check (default_field_alignment in ( 'LEFT',
                                                                                'RIGHT',
                                                                                'CENTER',
                                                                                'LEFT-TOP',
                                                                                'RIGHT-TOP',
                                                                                'CENTER-TOP',
                                                                                'LEFT-BOTTOM',
                                                                                'RIGHT-BOTTOM',
                                                                                'CENTER-BOTTOM',
                                                                                'LEFT-CENTER',
                                                                                'RIGHT-CENTER',
                                                                                'CENTER-CENTER'
                                                                            )),
    default_button_template_id     number
                                        constraint wwv_flow_plug_temp_button_fk
                                            references wwv_flow_button_templates (id),
    default_button_position        varchar2(30),
    security_group_id              number not null,
    reference_id                   number,
    last_updated_by                varchar2(255),
    last_updated_on                date,
    -- 4.0
    created_by                     varchar2(255),
    created_on                     date,
    --
    theme_id                       number,
    theme_class_id                 number,
    default_template_options       varchar2(255),
    preset_template_options        varchar2(255),
    --
    translate_this_template        varchar2(1)
                                        constraint wwv_flow_region_trans_temp
                                            check (translate_this_template in ('Y','N')),
    template_comment               varchar2(4000)
    ) lob (template,template2,template3) store as (cache reads enable storage in row)
/

create index wwv_flow_page_plug_idx1 on wwv_flow_page_plug_templates (security_group_id, reference_id)
/
create unique index wwv_flow_page_plug_idx2 on wwv_flow_page_plug_templates (flow_id, theme_id, page_plug_template_name)
/
create unique index wwv_flow_page_plug_idx3 on wwv_flow_page_plug_templates (default_field_template_id)
/
create unique index wwv_flow_page_plug_idx4 on wwv_flow_page_plug_templates (default_req_field_template_id)
/
create unique index wwv_flow_page_plug_idx5 on wwv_flow_page_plug_templates (default_button_template_id)
/

--==============================================================================
create table wwv_flow_plug_tmpl_disp_points (
    id                        number         not null
                                             constraint wwv_plug_tmpl_dp_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_plug_tmpl_dp_fk
                                             references wwv_flows on delete cascade,
    plug_template_id          number         not null
                                             constraint wwv_plug_tmpl_dp_parent_fk
                                             references wwv_flow_page_plug_templates on delete cascade,
    name                      varchar2(30)   not null,
    placeholder               varchar2(30)   not null
                                             constraint wwv_plug_tmpl_dp_upper_ck
                                                  check ( placeholder = upper(placeholder) ),
    has_grid_support          varchar2(1)    not null
                                             constraint wwv_plug_tmpl_dp_grid_ck
                                                  check ( has_grid_support in ( 'Y', 'N') ),
    glv_new_row               varchar2(1)    default 'Y' not null
                                             constraint wwv_plug_tmpl_dp_glv_nr_ck
                                                  check ( glv_new_row in ( 'Y', 'N' )),
    max_fixed_grid_columns    number,
    component_comment         varchar2(4000),
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  )
/

alter table wwv_flow_plug_tmpl_disp_points
  add constraint wwv_plug_tmpl_dp_uk1 unique (plug_template_id, placeholder);

alter table wwv_flow_plug_tmpl_disp_points
  add constraint wwv_plug_tmpl_dp_uk2 unique (plug_template_id, name);

create index wwv_plug_tmpl_dp_flow_fx on wwv_flow_plug_tmpl_disp_points (flow_id);

--==============================================================================
-- R E P O R T   T E M P L A T E S
create table wwv_flow_row_templates (
    id                            number
                                    constraint wwv_flow_row_template_pk
                                        primary key,
    flow_id                       number not null
                                    constraint wwv_flow_row_template_fk
                                        references wwv_flows
                                        on delete cascade,
    row_template_name             varchar2(255) not null,
    internal_name                 varchar2(255)
                                    constraint wwv_flow_row_tmpl_int_name_ck
                                        check (upper(internal_name)=internal_name),
    row_template_type             varchar2(30)
                                    constraint wwv_flow_row_template_ty
                                        check (row_template_type in (
                                        'GENERIC_COLUMNS',
                                        'NAMED_COLUMNS')),
    javascript_file_urls          varchar2(4000),
    javascript_code_onload        varchar2(4000),
    css_file_urls                 varchar2(4000),
    before_column_heading         varchar2(4000),
    column_heading_template       varchar2(4000),
    column_heading_sort_asc_temp  varchar2(4000),
    column_heading_sort_desc_temp varchar2(4000),
    column_heading_sort_temp      varchar2(4000),
    after_column_heading          varchar2(4000),
    row_template1                 clob,
    row_template_condition1       varchar2(4000),
    row_template_display_cond1    varchar2(30),
    row_template2                 clob,
    row_template_condition2       varchar2(4000),
    row_template_display_cond2    varchar2(30),
    row_template3                 clob,
    row_template_condition3       varchar2(4000),
    row_template_display_cond3    varchar2(30),
    row_template4                 clob,
    row_template_condition4       varchar2(4000),
    row_template_display_cond4    varchar2(30),
    row_template_before_rows      varchar2(4000),
    row_template_after_rows       varchar2(4000),
    ROW_TEMPLATE_BEFORE_FIRST     VARCHAR2 (4000),
    ROW_TEMPLATE_AFTER_LAST       VARCHAR2 (4000),
    row_template_table_attributes varchar2(4000),
    --
    pagination_template           varchar2(4000),
    next_page_template            varchar2(4000),
    previous_page_template        varchar2(4000),
    next_set_template             varchar2(4000),
    previous_set_template         varchar2(4000),
    --
    row_style_mouse_over          varchar2(255),
    row_style_mouse_out           varchar2(255),
    row_style_checked             varchar2(255),
    row_style_unchecked           varchar2(255),
    --
    reference_id                  number,
    security_group_id             number not null,
    last_updated_by               varchar2(255),
    last_updated_on               date,
    -- 4.0
    created_by                   varchar2(255),
    created_on                   date,
    --
    theme_id                      number,
    theme_class_id                number,
    default_template_options      varchar2(255),
    preset_template_options       varchar2(255),
    --
    translate_this_template       varchar2(1)
                                        constraint wwv_flow_report_trans_temp
                                            check (translate_this_template in ('Y','N')),
    row_template_comment          varchar2(4000)
    ) lob (row_template1,row_template2,row_template3,row_template4) store as (cache reads enable storage in row)
/



create index wwv_flow_row_templates_idx1 on wwv_flow_row_templates (security_group_id, reference_id)
/
create unique index wwv_flow_row_templates_idx2 on wwv_flow_row_templates (flow_id, theme_id, row_template_name)
/

--==============================================================================
prompt ...wwv_flow_list_templates
create table wwv_flow_list_templates (
    id                            number
                                    constraint wwv_flow_list_template_pk
                                        primary key,
    flow_id                       number not null
                                    constraint wwv_flow_list_template_fk
                                        references wwv_flows
                                        on delete cascade,
    list_template_name            varchar2(255) not null,
    internal_name                 varchar2(255)
                                    constraint wwv_flow_lst_tmpl_int_name_ck
                                        check (upper(internal_name)=internal_name),
    --
    javascript_file_urls          varchar2(4000),
    javascript_code_onload        varchar2(4000),
    css_file_urls                 varchar2(4000),
    inline_css                    varchar2(4000),
    --
    list_template_current         clob,
    list_template_noncurrent      clob,
    first_list_template_noncurrent      varchar2(4000), -- apex 4.0
    first_list_template_current         varchar2(4000), -- apex 4.0
    --
    list_template_before_rows     varchar2(4000),
    list_template_after_rows      varchar2(4000),
    --
    between_items                 varchar2(4000),
    before_sub_list               varchar2(4000),
    after_sub_list                varchar2(4000),
    between_sub_list_items        varchar2(4000),
    sub_list_item_current         clob,
    sub_list_item_noncurrent      clob,
    --
    item_template_curr_w_child     clob,
    item_template_noncurr_w_child  clob,
    f_item_template_curr_w_child   varchar2(4000), -- apex 4.0
    fitem_template_noncurr_w_child varchar2(4000), -- apex 4.0
    --
    sub_template_curr_w_child     clob,
    sub_template_noncurr_w_child  clob,
    --
    a01_label                     varchar2(4000),
    a02_label                     varchar2(4000),
    a03_label                     varchar2(4000),
    a04_label                     varchar2(4000),
    a05_label                     varchar2(4000),
    a06_label                     varchar2(4000),
    a07_label                     varchar2(4000),
    a08_label                     varchar2(4000),
    a09_label                     varchar2(4000),
    a10_label                     varchar2(4000),
    a11_label                     varchar2(4000),
    a12_label                     varchar2(4000),
    a13_label                     varchar2(4000),
    a14_label                     varchar2(4000),
    a15_label                     varchar2(4000),
    a16_label                     varchar2(4000),
    a17_label                     varchar2(4000),
    a18_label                     varchar2(4000),
    a19_label                     varchar2(4000),
    a20_label                     varchar2(4000),
    --
    reference_id                  number,
    security_group_id             number not null,
    last_updated_by               varchar2(255),
    last_updated_on               date,
    -- 4.0
    created_by                    varchar2(255),
    created_on                    date,
    --
    theme_id                      number,
    theme_class_id                number,
    default_template_options      varchar2(255),
    preset_template_options       varchar2(255),
    --
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_list_trans_temp
                                        check (translate_this_template in ('Y','N')),
    list_template_comment         varchar2(4000)
    ) lob (list_template_current,
           list_template_noncurrent,
           sub_list_item_current,
           sub_list_item_noncurrent,
           item_template_curr_w_child,
           item_template_noncurr_w_child,
           sub_template_curr_w_child,
           sub_template_noncurr_w_child) store as (cache reads enable storage in row)
/

create index wwv_flow_list_templates_idx1 on wwv_flow_list_templates (security_group_id, reference_id)
/
create unique index wwv_flow_list_templates_idx2 on wwv_flow_list_templates (flow_id ,list_template_name, theme_id)
/

--==============================================================================
prompt calendar templates
create table wwv_flow_cal_templates (
   id                      number
                            constraint wwv_flow_cal_templates_pk
                                primary key,
   name                    varchar2(512) not null,
   internal_name           varchar2(255)
                            constraint wwv_flow_cal_tmpl_int_name_ck
                                check (upper(internal_name)=internal_name),
   flow_id                 number
                            constraint wwv_flow_cal_templ_to_flow_fk
                                references wwv_flows
                                on delete cascade,
   security_group_id       number not null,
   last_updated_by         varchar2(255),
   last_updated_on         date,
   -- 4.0
   created_by              varchar2(255),
   created_on              date,
   --
   theme_id                number,
   theme_class_id          number,
   --
   translate_this_template varchar2(1),
   reference_id            number,
   --
   month_title_format      varchar2(4000),
   day_of_week_format      varchar2(4000),
   month_open_format       varchar2(4000),
   month_close_format      varchar2(4000),
   day_title_format        varchar2(4000),
   day_open_format         varchar2(4000),
   day_close_format        varchar2(4000),
   today_open_format       varchar2(4000),
   weekend_title_format    varchar2(4000),
   weekend_open_format     varchar2(4000),
   weekend_close_format    varchar2(4000),
   nonday_title_format     varchar2(4000),
   nonday_open_format      varchar2(4000),
   nonday_close_format     varchar2(4000),
   week_title_format       varchar2(4000), -- used for week headers
   week_open_format        varchar2(4000), -- used for week headers
   week_close_format       varchar2(4000), -- used for week headers
   daily_title_format      varchar2(4000), -- used for daily view header
   daily_open_format       varchar2(4000), -- used for daily view header
   daily_close_format      varchar2(4000), -- used for daily view header
   weekly_title_format     varchar2(4000),
   weekly_day_of_week_format   varchar2(4000),
   weekly_month_open_format    varchar2(4000),
   weekly_month_close_format   varchar2(4000),
   weekly_day_title_format     varchar2(4000),
   weekly_day_open_format      varchar2(4000),
   weekly_day_close_format     varchar2(4000),
   weekly_today_open_format    varchar2(4000),
   weekly_weekend_title_format varchar2(4000),
   weekly_weekend_open_format  varchar2(4000),
   weekly_weekend_close_format varchar2(4000),
   weekly_time_open_format     varchar2(4000),
   weekly_time_close_format    varchar2(4000),
   weekly_time_title_format    varchar2(4000),
   weekly_hour_open_format     varchar2(4000),
   weekly_hour_close_format    varchar2(4000),
   daily_day_of_week_format    varchar2(4000),
   daily_month_title_format    varchar2(4000),
   daily_month_open_format     varchar2(4000),
   daily_month_close_format    varchar2(4000),
   daily_day_title_format      varchar2(4000),
   daily_day_open_format       varchar2(4000),
   daily_day_close_format      varchar2(4000),
   daily_today_open_format     varchar2(4000),
   daily_time_open_format      varchar2(4000),
   daily_time_close_format     varchar2(4000),
   daily_time_title_format     varchar2(4000),
   daily_hour_open_format      varchar2(4000),
   daily_hour_close_format     varchar2(4000),
   custom_month_title_format   varchar2(4000),
   custom_day_of_week_format   varchar2(4000),
   custom_month_open_format    varchar2(4000),
   custom_month_close_format   varchar2(4000),
   custom_week_title_format    varchar2(4000),
   custom_week_open_format     varchar2(4000),
   custom_week_close_format    varchar2(4000),
   custom_day_title_format     varchar2(4000),
   custom_day_open_format      varchar2(4000),
   custom_day_close_format     varchar2(4000),
   custom_today_open_format    varchar2(4000),
   custom_daily_title_format   varchar2(4000),
   custom_daily_open_format    varchar2(4000),
   custom_daily_close_format   varchar2(4000),
   custom_nonday_title_format  varchar2(4000),
   custom_nonday_open_format   varchar2(4000),
   custom_nonday_close_format  varchar2(4000),
   custom_weekend_title_format varchar2(4000),
   custom_weekend_open_format  varchar2(4000),
   custom_weekend_close_format varchar2(4000),
   custom_wk_month_title_format varchar2(4000),
   custom_wk_day_of_week_format varchar2(4000),
   custom_wk_month_open_format  varchar2(4000),
   custom_wk_month_close_format varchar2(4000),
   custom_wk_week_title_format  varchar2(4000),
   custom_wk_week_open_format   varchar2(4000),
   custom_wk_week_close_format  varchar2(4000),
   custom_wk_day_title_format   varchar2(4000),
   custom_wk_day_open_format    varchar2(4000),
   custom_wk_day_close_format   varchar2(4000),
   custom_wk_today_open_format    varchar2(4000),
   custom_wk_weekend_title_format varchar2(4000),
   custom_wk_weekend_open_format  varchar2(4000),
   custom_wk_weekend_close_format varchar2(4000),
   custom_hour_open_format     varchar2(4000),
   custom_hour_close_format    varchar2(4000),
   custom_time_title_format    varchar2(4000),
   custom_time_open_format     varchar2(4000),
   custom_time_close_format    varchar2(4000),
   custom_month_day_height_pix varchar2(20),
   custom_month_day_height_per varchar2(20),
   custom_week_day_width_pix   varchar2(20),
   custom_week_day_width_per   varchar2(20),
   agenda_format               varchar2(4000),
   agenda_past_day_format      varchar2(4000),
   agenda_today_day_format     varchar2(4000),
   agenda_future_day_format    varchar2(4000),
   agenda_past_entry_format    varchar2(4000),
   agenda_today_entry_format   varchar2(4000),
   agenda_future_entry_format  varchar2(4000),
   month_data_format           varchar2(4000),
   month_data_entry_format     varchar2(4000),
   template_comments           varchar2(4000)
   )
/

create index wwv_flow_cal_temp_idx1 on wwv_flow_cal_templates (security_group_id, reference_id)
/
create unique index wwv_flow_cal_temp_idx2 on wwv_flow_cal_templates (flow_id, theme_id, name)
/

--==============================================================================
create table wwv_flow_popup_lov_template (
    id                 number
                       constraint wwv_flow_pk_poplov_temp
                       primary key,
    security_group_id  number not null,
    flow_id            number
                       constraint wwv_flow_fk_poplov_temp
                       references wwv_flows
                       on delete cascade,
    --
    popup_icon         varchar2(4000) default '#IMAGE_PREFIX#list.gif',
    popup_icon_attr    varchar2(4000) default 'width=13 height=13',
    popup_icon2        varchar2(4000) default null,
    popup_icon_attr2   varchar2(4000) default null,
    --
    page_name          varchar2(255)  default 'winlov',
    page_title         varchar2(255)  default 'Search Dialog',
    page_html_head     varchar2(4000) default '<link rel=stylesheet href=#IMAGE_PREFIX#platform2.css type=text/css>',
    page_body_attr     varchar2(255)  default 'bgcolor=white OnLoad=first_field()',
    before_field_text  varchar2(4000) default ' ',
    after_field_text   varchar2(4000) default '</div><br />',
    page_heading_text  varchar2(4000) default '<link rel=stylesheet href=#IMAGE_PREFIX#platform2.css type=text/css><style>a:link { color:#336699; text-decoration:none; padding:2px;} a:visited { color:#336699; text-decoration:none;} a:hover { color:red; text-decoration:underline;} body { font-family:arial; background-color:#ffffff;} </style>',
    page_footer_text   varchar2(4000) default '</center></td></tr></table>',
    --
    before_result_set  varchar2(4000) default '',
    after_result_set   varchar2(4000) default '',
    --
    filter_width       varchar2(255)  default '20',
    filter_max_width   varchar2(255)  default '100',
    filter_text_attr   varchar2(4000) default null,
    --
    find_button_text   varchar2(255)  default 'Search',
    find_button_image  varchar2(255)  default null,
    find_button_attr   varchar2(4000) default '',
    --
    close_button_text  varchar2(255)  default 'Close',
    close_button_image varchar2(255)  default null,
    close_button_attr  varchar2(4000) default '',
    --
    next_button_text   varchar2(255)  default 'Next',
    next_button_image  varchar2(255)  default null,
    next_button_attr   varchar2(4000) default '',
    --
    prev_button_text   varchar2(255)  default 'Previous',
    prev_button_image  varchar2(255)  default null,
    prev_button_attr   varchar2(4000) default '',
    --
    --
    scrollbars         varchar2(255)  default '1',
    resizable          varchar2(255)  default '1',
    width              varchar2(255)  default '400',
    height             varchar2(255)  default '450',
    --
    result_row_x_of_y  varchar2(255)  default 'Row(s) #FIRST_ROW# - #LAST_ROW#',
    result_rows_per_pg number         default 10,
    --
    when_no_data_found_message   varchar2(4000),
    before_first_fetch_message   varchar2(4000),
    minimum_characters_required  number,
    --
    theme_id                      number,
    theme_class_id                number,
    reference_id                  number,
    --
    last_updated_on               date,
    last_updated_by               varchar2(255),
    -- 4.0
    created_by                    varchar2(255),
    created_on                    date,
    translate_this_template       varchar2(1)
                                    constraint wwv_flow_popup_trans_temp
                                    check (translate_this_template in ('Y','N')),
    template_comment   varchar2(4000)
    )
/

create index wwv_flow_poplov_temp_idx1 on wwv_flow_popup_lov_template (security_group_id, reference_id)
/
create unique index wwv_flow_lovt_u_flow_id on wwv_flow_popup_lov_template (flow_id,theme_id)
/

--==============================================================================
create table wwv_flow_menu_templates (
     id                       number
                                constraint wwv_flow_menu_templs_pk
                                    primary key,
     flow_id                  number not null
                                constraint wwv_flow_menus_t_flow_fk
                                    references wwv_flows
                                    on delete cascade,
     name                     varchar2(255) not null,
     internal_name            varchar2(255)
                                constraint wwv_flow_menu_tmpl_int_name_ck
                                        check (upper(internal_name)=internal_name),
     --
     before_first             varchar2(4000),
     current_page_option      varchar2(4000),
     non_current_page_option  varchar2(4000),
     menu_link_attributes     varchar2(4000),
     between_levels           varchar2(4000),
     after_last               varchar2(4000),
     max_levels               number,
     start_with_node          varchar2(255),
     reference_id             number,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     -- 4.0
     created_by                 varchar2(255),
     created_on                 date,
     --
     theme_id                 number,
     theme_class_id           number,
     default_template_options varchar2(255),
     preset_template_options  varchar2(255),
     --
     translate_this_template  varchar2(1)
                                constraint wwv_flow_menu_trans_temp
                                    check (translate_this_template in ('Y','N')),
     template_comments        varchar2(4000)
     )
/

create index wwv_flow_menu_temp_idx1 on wwv_flow_menu_templates (security_group_id, reference_id)
/
create unique index wwv_flow_menu_temp_idx2 on wwv_flow_menu_templates (flow_id, name, theme_id)
/


create table wwv_flow_template_opt_groups (
    id                        number         not null
                                             constraint wwv_flow_temp_opt_grp_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_temp_opt_grp_fk
                                             references wwv_flows on delete cascade,
    theme_id                  number         not null, /* no FK, because that's the theme no and not the internal id */
    name                      varchar2(30)   not null
                                             constraint wwv_flow_temp_opt_grp_name_ck
                                             check (name = upper(name)),
    display_name              varchar2(30)   not null,
    display_sequence          number         not null,
    template_types            varchar2(255)  not null,
    help_text                 varchar2(4000) ,
    null_text                 varchar2(30)   ,
    is_advanced               varchar2(1)    not null
                                             constraint wwv_flow_temp_opt_grp_adv_ck
                                                  check ( is_advanced in ( 'Y', 'N') ),
    reference_id              number,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
)
/

alter table wwv_flow_template_opt_groups add constraint wwv_flow_template_opt_grp_uk unique (flow_id, theme_id, template_types, name)
/

create table wwv_flow_template_options (
    id                        number         not null
                                             constraint wwv_flow_temp_opt_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_temp_opt_fk
                                             references wwv_flows on delete cascade,
    theme_id                  number         not null, /* no FK, because that's the theme no and not the internal id */
    name                      varchar2(30)   not null
                                             constraint wwv_flow_temp_opt_name_ck
                                             check (name = upper(name) and name <> 'DEFAULT' and regexp_like(name, '^[[:alnum:]_-]+$')),
    display_name              varchar2(30)   not null,
    display_sequence          number         not null,
    page_template_id          number         constraint wwv_flow_temp_opt_page_fk
                                             references wwv_flow_templates
                                             on delete cascade,
    region_template_id        number         constraint wwv_flow_temp_opt_region_fk
                                             references wwv_flow_page_plug_templates
                                             on delete cascade,
    report_template_id        number         constraint wwv_flow_temp_opt_report_fk
                                             references wwv_flow_row_templates
                                             on delete cascade,
    breadcrumb_template_id    number         constraint wwv_flow_temp_opt_bc_fk
                                             references wwv_flow_menu_templates
                                             on delete cascade,
    list_template_id          number         constraint wwv_flow_temp_opt_list_fk
                                             references wwv_flow_list_templates
                                             on delete cascade,
    field_template_id         number         constraint wwv_flow_temp_opt_label_fk
                                             references wwv_flow_field_templates
                                             on delete cascade,
    button_template_id        number         constraint wwv_flow_temp_opt_but_fk
                                             references wwv_flow_button_templates
                                             on delete cascade,
    virtual_template_type     varchar2(255)  generated always as (
                                                 case
                                                   when page_template_id       is not null then 'PAGE'
                                                   when region_template_id     is not null then 'REGION'
                                                   when report_template_id     is not null then 'REPORT'
                                                   when breadcrumb_template_id is not null then 'BREADCRUMB'
                                                   when list_template_id       is not null then 'LIST'
                                                   when field_template_id      is not null then 'FIELD'
                                                   when button_template_id     is not null then 'BUTTON'
                                                   else template_types
                                                 end ) virtual,
    virtual_template_id       number         generated always as (
                                                 coalesce(
                                                     page_template_id, region_template_id, report_template_id,
                                                     breadcrumb_template_id, list_template_id,
                                                     field_template_id, button_template_id )) virtual,
    css_classes               varchar2(255)  not null,
    group_id                  number         constraint wwv_flow_temp_opt_opt_grp_fk
                                             references wwv_flow_template_opt_groups on delete set null,
    template_types            varchar2(255)  ,
    help_text                 varchar2(4000) ,
    is_advanced               varchar2(1)    constraint wwv_flow_temp_opt_adv_ck
                                                  check ( is_advanced in ( 'Y', 'N') ),
    reference_id              number,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  )
/

alter table wwv_flow_template_options add constraint wwv_flow_template_opt_uk unique (flow_id, theme_id, name, virtual_template_type, virtual_template_id)
/

alter table wwv_flow_template_options add constraint wwv_flow_template_opt_uk2 unique (flow_id, theme_id, css_classes, virtual_template_type, virtual_template_id)
/

create index wwv_flow_template_options_idx1 on wwv_flow_template_options (page_template_id)
/

create index wwv_flow_template_options_idx2 on wwv_flow_template_options (region_template_id)
/

create index wwv_flow_template_options_idx3 on wwv_flow_template_options (report_template_id)
/

create index wwv_flow_template_options_idx4 on wwv_flow_template_options (breadcrumb_template_id)
/

create index wwv_flow_template_options_idx5 on wwv_flow_template_options (list_template_id)
/

create index wwv_flow_template_options_idx6 on wwv_flow_template_options (field_template_id)
/

create index wwv_flow_template_options_idx7 on wwv_flow_template_options (button_template_id)
/

create index wwv_flow_template_options_idx8 on wwv_flow_template_options (group_id)
/

create index wwv_flow_template_options_idx9 on wwv_flow_template_options(security_group_id, virtual_template_id)
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > SHORTCUTS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > SHORTCUTS
--==============================================================================
create table wwv_flow_shortcuts (
    id                       number
                             constraint wwv_flow_shortcuts_pk
                             primary key,
    flow_id                  number not null
                             constraint wwv_flow_shortcuts_to_flow_fk
                             references wwv_flows
                             on delete cascade,
    security_group_id        number not null,
    shortcut_name            varchar2(255) not null,
    shortcut_consideration_seq number,
    shortcut_type            varchar2(30)
                             constraint wwv_flow_valid_shortcut_type
                             check (shortcut_type in (
                             'HTML_TEXT',
                             'HTML_TEXT_ESCAPE_SC',
                             'FUNCTION_BODY',
                             'IMAGE',
                             'MESSAGE',
                             'MESSAGE_ESCAPE_JS',
                             'TEXT_ESCAPE_JS')),
    shortcut_condition_type1 varchar2(255),
    shortcut_condition1      varchar2(4000),
    shortcut_condition_type2 varchar2(255),
    shortcut_condition2      varchar2(4000),
    build_option             number,
    error_text               varchar2(4000),
    shortcut                 clob,
    reference_id             number,
    last_updated_by          varchar2(255),
    last_updated_on          date,
    -- 4.0
    created_by               varchar2(255),
    created_on               date,
    comments                 varchar2(4000),
    --
    constraint wwv_flow_shortcut_idx1 unique (
        flow_id, shortcut_name, shortcut_consideration_seq )
        using index compress 1
    ) lob (shortcut) store as (cache reads enable storage in row)
/

create index wwv_flow_shortcut_idx2 on wwv_flow_shortcuts(security_group_id)
    compress
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > PLUGINS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > PLUGINS

--==============================================================================
create table wwv_flow_plugins (
    id                           number
                                 constraint wwv_flow_plugin_pk
                                 primary key,
    flow_id                      number not null
                                 constraint wwv_flow_plugin_flow_fk
                                 references wwv_flows on delete cascade,
    plugin_type                  varchar2(30)  not null
                                               constraint wwv_flow_plugin_type_ck
                                               check (plugin_type in ( 'ITEM TYPE',
                                                                       'DYNAMIC ACTION',
                                                                       'REGION TYPE',
                                                                       'PROCESS TYPE',
                                                                       'AUTHORIZATION TYPE',
                                                                       'AUTHENTICATION TYPE' )),
    name                         varchar2(45)  not null
                                               constraint wwv_flow_plugin_name_ck
                                               check (upper(name)=name),
    display_name                 varchar2(100) not null,
    category                     varchar2(30),
    supported_ui_types           varchar2(255) default 'DESKTOP' not null,
    supported_component_types    varchar2(255) default 'APEX_APPLICATION_PAGE_ITEMS',
    supported_data_types         varchar2(255),
    image_prefix                 varchar2(255),
    javascript_file_urls         varchar2(4000),
    css_file_urls                varchar2(4000),
    --
    plsql_code                   clob,
    api_version                  number        default 1 not null,
    render_function              varchar2(255),
    meta_data_function           varchar2(255),
    emit_value_function          varchar2(255),
    ajax_function                varchar2(255),
    validation_function          varchar2(255),
    execution_function           varchar2(255),
    session_sentry_function      varchar2(255),
    invalid_session_function     varchar2(255),
    authentication_function      varchar2(255),
    post_logout_function         varchar2(255),
    builder_validation_function  varchar2(255),
    migration_function           varchar2(255),
    standard_attributes          varchar2(255),
    substitute_attributes        varchar2(1) default 'Y' not null,
                                 constraint wwv_flow_plugin_subst_attr_ck
                                 check (substitute_attributes in ('Y', 'N')),
    reference_id                 number,
    subscribe_plugin_settings    varchar2(1) default 'Y' not null,
                                 constraint wwv_flow_plugin_settings_ck
                                 check (subscribe_plugin_settings in ('Y', 'N')),
    is_quick_pick                varchar2(1) default 'N' not null
                                             constraint wwv_flow_plugin_is_quickp_ck
                                             check (is_quick_pick in ('Y', 'N')),
    is_deprecated                varchar2(1) default 'N' not null
                                             constraint wwv_flow_plugin_is_deprecat_ck
                                             check (is_deprecated in ('Y', 'N')),
    is_legacy                    varchar2(1) default 'N' not null
                                             constraint wwv_flow_plugin_is_legacy_ck
                                             check (is_legacy in ('Y', 'N')),
    help_text                    varchar2(4000),
    version_identifier           varchar2(30),
    about_url                    varchar2(512),
    plugin_comment               varchar2(4000),
    files_version                number default 1 not null,
    security_group_id            number not null,
    created_by                   varchar2(255),
    created_on                   date,
    last_updated_by              varchar2(255),
    last_updated_on              date,
    --
    -- obsolete columns:
    -- * attribute_XX now stored in wwv_flow_plugin_settings
    --
    attribute_01                 varchar2(4000),
    attribute_02                 varchar2(4000),
    attribute_03                 varchar2(4000),
    attribute_04                 varchar2(4000),
    attribute_05                 varchar2(4000),
    attribute_06                 varchar2(4000),
    attribute_07                 varchar2(4000),
    attribute_08                 varchar2(4000),
    attribute_09                 varchar2(4000),
    attribute_10                 varchar2(4000),
    attribute_11                 varchar2(4000),
    attribute_12                 varchar2(4000),
    attribute_13                 varchar2(4000),
    attribute_14                 varchar2(4000),
    attribute_15                 varchar2(4000),
    -- * these columns are now stored in wwv_flow_plugin_std_attributes
    sql_min_column_count         number(3)      constraint wwv_flow_plugin_mincol_ck
                                                check (sql_min_column_count > 0),
    sql_max_column_count         number(3)      constraint wwv_flow_plugin_maxcol_ck
                                                check (sql_max_column_count > 0),
    sql_examples                 varchar2(4000)
  ) lob (plsql_code) store as (cache reads enable storage in row);

alter  table wwv_flow_plugins add constraint wwv_flow_plugin_uk unique (flow_id, plugin_type, name);
alter  index wwv_flow_plugin_uk rebuild compress 2;
create index wwv_flow_plugins_idx1 on wwv_flow_plugins (reference_id) compress;
comment on table wwv_flow_plugins is
    'Stores the meta data for the plug-ins of an application.';
-- Add comments to the columns
comment on column wwv_flow_plugins.plugin_type is
    'Type of the plugin.';
comment on column wwv_flow_plugins.name is
    'Internal name of the plug-in which is used to reference it for example in wwv_flow_step_items.';
comment on column wwv_flow_plugins.display_name is
    'Contains the name of the plug-in which is displayed on the UI.';
comment on column wwv_flow_plugins.category is
    'Category under which the plug-in should displayed on the UI.';
comment on column wwv_flow_plugins.image_prefix is
    'File prefix which is used by the plug-in to load additional files like CSS, Javascript and images.';
comment on column wwv_flow_plugins.plsql_code is
    'PL/SQL code which contains the logic of the plugin.';
comment on column wwv_flow_plugins.render_function is
    'During rendering of the page this function is called to render the plug-in.';
comment on column wwv_flow_plugins.meta_data_function is
    'Function which is called for plug-in to get dynamic meta data about plug-in.';
comment on column wwv_flow_plugins.ajax_function is
    'Function which is called for plug-in when there is an incoming Ajax call from the browser.';
comment on column wwv_flow_plugins.validation_function is
    'Function which is called to validate the plug-ins data before the defined validations are fired.';
comment on column wwv_flow_plugins.execution_function is
    'Function which is called for plug-ins that are just used on the server side.';
comment on column wwv_flow_plugins.session_sentry_function is
    'Function which is called by an authorization plug-in each time a request is made to Application Express.';
comment on column wwv_flow_plugins.authentication_function is
    'Function which is called by an authentication plug-in to verify login credentials.';
comment on column wwv_flow_plugins.post_logout_function is
    'Function which is called by an authorization plug-in after a session has been marked as terminated.';
comment on column wwv_flow_plugins.builder_validation_function is
    'Function which is called to validate the entered attribute values in the builder.';
comment on column wwv_flow_plugins.migration_function is
    'Function which is called when a new version of a plug-in is installed to migrate existing attribute values.';
comment on column wwv_flow_plugins.standard_attributes is
    'Contains the APEX provided standard attributes which should be displayed for the plug-in.';
comment on column wwv_flow_plugins.sql_min_column_count is
    'Minimum number of columns the SQL query of the LOV or region source has to have.';
comment on column wwv_flow_plugins.sql_max_column_count is
    'Maximum number of columns the SQL query of the LOV or region source can have.';
comment on column wwv_flow_plugins.sql_examples is
    'LOV or region source SQL examples which are displayed for the plug-in in the Builder.';
comment on column wwv_flow_plugins.substitute_attributes is
    'Are the attribute values automatically substituted when the plug-in is called?';
comment on column wwv_flow_plugins.attribute_01 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_02 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_03 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_04 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_05 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_06 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_07 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_08 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_09 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_10 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_11 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_12 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_13 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_14 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.attribute_15 is
    'Dynamic attribute to store additional data';
comment on column wwv_flow_plugins.reference_id is
    'Identifies the master component from which this component is subscribed';
comment on column wwv_flow_plugins.help_text is
    'Help text which is displayed for the plug-in in the Builder.';
comment on column wwv_flow_plugins.version_identifier is
    'Version identifier of the plug-in.';
comment on column wwv_flow_plugins.about_url is
    'URL to get additional information about the plug-in.';

--==============================================================================
create table wwv_flow_plugin_attributes (
    id                          number         not null
                                               constraint wwv_flow_plugin_attr_pk
                                               primary key,
    flow_id                     number         not null
                                               constraint wwv_flow_plugin_attr_flow_fk
                                               references wwv_flows on delete cascade,
    plugin_id                   number         not null
                                               constraint wwv_flow_plugin_attr_plugin_fk
                                               references wwv_flow_plugins on delete cascade,
    attribute_scope             varchar2(15)   not null
                                               constraint wwv_flow_plugin_attr_scope_ck
                                               check (attribute_scope in ('APPLICATION', 'COMPONENT', 'COLUMN')),
    attribute_sequence          number(2)      not null
                                               constraint wwv_flow_plugin_attr_seq_ck
                                               check (attribute_sequence between 1 and 25),
    display_sequence            number         not null,
    prompt                      varchar2(255)  not null,
    attribute_type              varchar2(30)   not null
                                               constraint wwv_flow_plugin_attr_type_ck
                                               check (attribute_type in (
                                                        'CHECKBOX',
                                                        'CHECKBOXES',
                                                        'COLOR',
                                                        'ICON',
                                                        'COMPONENT',
                                                        'LINK',
                                                        'SELECT LIST',
                                                        'TEXT',
                                                        'TEXTAREA',
                                                        'NUMBER',
                                                        'INTEGER',
                                                        'PAGE ITEM',
                                                        'PAGE ITEMS',
                                                        'PAGE NUMBER',
                                                        'PAGE NUMBERS',
                                                        'AUTHORIZATION GROUPS',
                                                        'CREDENTIAL ID',
                                                        'SQL',
                                                        'PLSQL',
                                                        'PLSQL EXPRESSION',
                                                        'PLSQL EXPRESSION BOOLEAN',
                                                        'PLSQL FUNCTION BODY',
                                                        'PLSQL FUNCTION BODY BOOLEAN',
                                                        'REGION SOURCE COLUMN',
                                                        'DATA LOAD TABLE ID',
                                                        'OWNER',
                                                        'TABLE',
                                                        'COLUMN',
                                                        'HTML',
                                                        'JAVASCRIPT',
                                                        'XML' )),
    is_required                  varchar2(1)    not null
                                                constraint wwv_flow_plugin_attr_req_ck
                                                check (is_required in ('Y', 'N')),
    is_common                    varchar2(1)    default 'Y'
                                                not null
                                                constraint wwv_flow_plugin_attr_common_ck
                                                check (is_common in ('Y', 'N')),
    show_in_wizard               varchar2(1)    default 'Y'
                                                not null
                                                constraint wwv_flow_plugin_attr_wizard_ck
                                                check (show_in_wizard in ('Y', 'N')),
    default_value                varchar2(4000),
    display_length               number         constraint wwv_flow_plugin_attr_disp_l_ck
                                                check (display_length between 1 and 4000),
    max_length                   number         constraint wwv_flow_plugin_attr_max_l_ck
                                                check (max_length between 1 and 4000),
    min_value                    number,
    max_value                    number,
    unit                         varchar2(30),
    sql_min_column_count         number(3)      constraint wwv_flow_plugin_attr_mincol_ck
                                                check (sql_min_column_count > 0),
    sql_max_column_count         number(3)      constraint wwv_flow_plugin_attr_maxcol_ck
                                                check (sql_max_column_count > 0),
    column_data_types            varchar2(255),
    parent_attribute_id          number         constraint wwv_flow_plugin_attr_parent_fk
                                                references wwv_flow_plugin_attributes on delete set null
                                                deferrable initially deferred,
    lov_type                     varchar2(10)   constraint wwv_flow_plugin_attr_ltype_ck
                                                check (lov_type in (
                                                    'COMPONENT',
                                                    'DISTINCT',
                                                    'STATIC' )),
    lov_component_type_id        number         constraint wwv_flow_plugin_attr_lcompt_fk
                                                /* needed for apex_install_pe_data.sql which deletes all entries */
                                                references wwv_pe_component_types deferrable initially deferred,
    lov_component_type_scope     varchar2(15)   constraint wwv_flow_plugin_attr_lscope_ck
                                                check (lov_component_type_scope in ( 'PARENT', 'PAGE', 'PAGE_AND_GLOBAL', 'THEME' )),
    lov_component_type_on_delete varchar2(15)   constraint wwv_flow_plugin_attr_ldel_ck
                                                check (lov_component_type_on_delete in (
                                                    'WEAK_CASCADE',
                                                    'WEAK_NULL' )),
    text_case                    varchar2(5)    constraint wwv_flow_plugin_attr_case_ck
                                                check ( text_case in (
                                                    'LOWER',
                                                    'UPPER' )),
    null_text                    varchar2(255),
    deprecated_values            varchar2(30),
    supported_ui_types           varchar2(255),
    supported_component_types    varchar2(255),
    is_translatable              varchar2(1)    not null
                                                constraint wwv_flow_plugin_attr_transl_ck
                                                check (is_translatable in ('Y', 'N')),
    depending_on_attribute_id    number         constraint wwv_flow_plugin_attr_depend_fk
                                                references wwv_flow_plugin_attributes on delete set null
                                                deferrable initially deferred,
    depending_on_has_to_exist    varchar2(1)    constraint wwv_flow_plugin_attr_dep_ex_ck
                                                check (depending_on_has_to_exist in ('Y', 'N')),
    depending_on_comp_prop_id    number         constraint wwv_flow_plugin_attr_depen2_fk
                                                references wwv_pe_component_props on delete set null deferrable initially deferred,
    depending_on_condition_type  varchar2(30)   constraint wwv_flow_plugin_attr_cond_ck
                                                check (depending_on_condition_type in (
                                                       'EQUALS',
                                                       'NOT_EQUALS',
                                                       'NULL',
                                                       'NOT_NULL',
                                                       'IN_LIST',
                                                       'NOT_IN_LIST' )),
    depending_on_expression      varchar2(4000),
    reference_scope              varchar2(10)   default 'COMPONENT'
                                                not null
                                                constraint wwv_flow_plugin_attr_refscp_ck
                                                check (reference_scope in ('COMPONENT', 'ROW')),
    examples                     varchar2(4000),
    help_text                    varchar2(4000),
    attribute_comment            varchar2(4000),
    security_group_id            number not null,
    created_by                   varchar2(255),
    created_on                   date,
    last_updated_by              varchar2(255),
    last_updated_on              date
  );

alter table wwv_flow_plugin_attributes
  add constraint wwv_flow_plugin_attr_uk unique (plugin_id, attribute_scope, attribute_sequence);

create index wwv_flow_plugin_attr_flow_fx on wwv_flow_plugin_attributes (flow_id) compress;
create index wwv_flow_plugin_attr_depend_fx on wwv_flow_plugin_attributes (depending_on_attribute_id);
create index wwv_flow_plugin_attr_depen2_fx on wwv_flow_plugin_attributes (depending_on_comp_prop_id);
create index wwv_flow_plugin_attr_parent_fx on wwv_flow_plugin_attributes (parent_attribute_id);
create index wwv_flow_plugin_attr_compon_fx on wwv_flow_plugin_attributes (lov_component_Type_id) compress;


comment on table wwv_flow_plugin_attributes is
    'Stores the meta data for the dynamic attributes of a plug-in.';
-- Add comments to the columns
comment on column wwv_flow_plugin_attributes.attribute_scope is
    'Is the attribute set for an application or a component.';
comment on column wwv_flow_plugin_attributes.attribute_sequence is
    'Sequence which correlates with the attribute_xx columns for example in wwv_flow_step_items.';
comment on column wwv_flow_plugin_attributes.display_sequence is
    'Sequence in which the attributes are displayed in the Builder.';
comment on column wwv_flow_plugin_attributes.prompt is
    'Prompt which is displayed for that attribute in the Builder.';
comment on column wwv_flow_plugin_attributes.help_text is
    'Help text which is displayed for that attribute in the Builder.';
comment on column wwv_flow_plugin_attributes.attribute_type is
    'Type of control which is used to render the attribute field in the Builder.';
comment on column wwv_flow_plugin_attributes.is_required is
    'Should the Builder enforce this attribute to be filled out?';
comment on column wwv_flow_plugin_attributes.default_value is
    'Default value which is used in the Builder when the item type is selected.';
comment on column wwv_flow_plugin_attributes.display_length is
    'Display length of the attribute used when displayed in the Builder.';
comment on column wwv_flow_plugin_attributes.max_length is
    'Maximum length of the attribute used when displayed in the Builder.';
comment on column wwv_flow_plugin_attributes.sql_min_column_count is
    'Minimum number of columns the SQL query of the attribute has to have.';
comment on column wwv_flow_plugin_attributes.sql_max_column_count is
    'Maximum number of columns the SQL query of the attribute can have.';
comment on column wwv_flow_plugin_attributes.column_data_types is
    'Data types which are supported by the attribute of type "Region SQL Statement Column".';
comment on column wwv_flow_plugin_attributes.is_translatable is
    'Is the attribute value exported into the XLIFF file for translation.';
comment on column wwv_flow_plugin_attributes.depending_on_attribute_id is
    'Attribute which defines if the current attribute is displayed or not.';
comment on column wwv_flow_plugin_attributes.depending_on_condition_type is
    'Identifies the type of condition used to define when the attribute gets displayed.';
comment on column wwv_flow_plugin_attributes.depending_on_expression is
    'Identifies the condition expression used to define when the attribute gets displayed.';
comment on column wwv_flow_plugin_attributes.examples is
    'Examples displayed in APEX Builder for this attribute.';


--==============================================================================
create table wwv_flow_plugin_attr_values (
    id                        number         not null
                                             constraint wwv_flow_plugin_attrv_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_plugin_attrv_flow_fk
                                             references wwv_flows on delete cascade,
    plugin_attribute_id       number         not null
                                             constraint wwv_flow_plugin_attrv_attr_fk
                                             references wwv_flow_plugin_attributes on delete cascade,
    display_sequence          number         not null,
    display_value             varchar2(255)  not null,
    return_value              varchar2(255)  not null,
    is_quick_pick             varchar2(1)    default 'N' not null
                                             constraint wwv_flow_plugin_attrv_is_qp_ck
                                             check (is_quick_pick in ('Y', 'N')),
    is_deprecated             varchar2(1)    default 'N' not null
                                             constraint wwv_flow_plugin_attrv_isdep_ck
                                             check (is_deprecated in ('Y', 'N')),
    help_text                 varchar2(4000),
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
    );

create index wwv_flow_plugin_attrv_flow_fx on wwv_flow_plugin_attr_values (flow_id);

create index wwv_flow_plugin_attrv_attr_fx on wwv_flow_plugin_attr_values (plugin_attribute_id);

comment on table wwv_flow_plugin_attr_values is
    'Stores the possible values of a plug-in attribute if it''s of type select list.';
-- Add comments to the columns
comment on column wwv_flow_plugin_attr_values.display_sequence is
    'Order sequence in which the values are displayed.';
comment on column wwv_flow_plugin_attr_values.display_value is
    'Value displayed to end users';
comment on column wwv_flow_plugin_attr_values.return_value is
    'Value stored in attribute_xx column.';
comment on column wwv_flow_plugin_attr_values.help_text is
    'Help text which is displayed for the value in the Builder.';

--==============================================================================
create table wwv_flow_plugin_std_attributes (
    id                           number         not null
                                                constraint plugin_std_attr_pk
                                                primary key,
    flow_id                      number         not null
                                                constraint plugin_std_attr_flow_fk
                                                references wwv_flows on delete cascade,
    plugin_id                    number         not null
                                                constraint plugin_std_attr_plugin_fk
                                                references wwv_flow_plugins on delete cascade,
    name                         varchar2(30)   not null
                                                constraint plugin_std_attr_name_ck
                                                check (name in ('SOURCE_LOCATION',
                                                                'SOURCE_SQL',
                                                                'SOURCE_PLSQL',
                                                                'SOURCE_PLSQL_FUNCTION',
                                                                'SOURCE_HTML',
                                                                'SOURCE_PLAIN',
                                                                'LOV',
                                                                'INIT_JAVASCRIPT_CODE')),
    is_required                  varchar2(1)    not null
                                                constraint plugin_std_attr_required_ck
                                                check (is_required in ('Y', 'N')),
    default_value                varchar2(4000),
    sql_min_column_count         number(3)      constraint plugin_std_attr_mincol_ck
                                                check (sql_min_column_count > 0),
    sql_max_column_count         number(3)      constraint plugin_std_attr_maxcol_ck
                                                check (sql_max_column_count > 0),
    supported_ui_types           varchar2(255),
    supported_component_types    varchar2(255),
    depending_on_attribute_id    number         constraint plugin_std_attr_customattr_fk
                                                references wwv_flow_plugin_attributes on delete set null
                                                deferrable initially deferred,
    depending_on_has_to_exist    varchar2(1)    constraint plugin_std_attr_hastoexist_ck
                                                check (depending_on_has_to_exist in ('Y', 'N')),
    depending_on_condition_type  varchar2(30)   constraint plugin_std_attr_condition_ck
                                                check (depending_on_condition_type in (
                                                       'EQUALS',
                                                       'NOT_EQUALS',
                                                       'NULL',
                                                       'NOT_NULL',
                                                       'IN_LIST',
                                                       'NOT_IN_LIST' )),
    depending_on_expression      varchar2(4000),
    examples                     varchar2(4000),
    help_text                    varchar2(4000),
    security_group_id            number not null,
    attribute_comment            varchar2(4000),
    created_by                   varchar2(255),
    created_on                   date,
    last_updated_by              varchar2(255),
    last_updated_on              date
  );

alter table wwv_flow_plugin_std_attributes
  add constraint plugin_std_attribute_uk unique (plugin_id, name);

create index plugin_std_attribute_flow_fx   on wwv_flow_plugin_std_attributes (flow_id) compress;
create index plugin_std_attribute_depend_fx on wwv_flow_plugin_std_attributes (depending_on_attribute_id);


comment on table wwv_flow_plugin_std_attributes is
    'Stores additional meta data for standard attributes of a plug-in.';

comment on column wwv_flow_plugin_std_attributes.name  is
    'Name of the plug-in standard attribute';
comment on column wwv_flow_plugin_std_attributes.is_required is
    'Should the Builder enforce this attribute to be filled out?';
comment on column wwv_flow_plugin_std_attributes.default_value  is
    'Default value which is used in the Builder when the item type is selected.';
comment on column wwv_flow_plugin_std_attributes.sql_min_column_count  is
    'Minimum number of columns the SQL query of the attribute has to have.';
comment on column wwv_flow_plugin_std_attributes.sql_max_column_count  is
    'Maximum number of columns the SQL query of the attribute has to have.';
comment on column wwv_flow_plugin_std_attributes.supported_ui_types  is
    'User Interface types that this standard attribute supports';
comment on column wwv_flow_plugin_std_attributes.supported_component_types  is
    'Component types for which the attribute should be displayed on the UI';
comment on column wwv_flow_plugin_std_attributes.depending_on_attribute_id  is
    'Attribute which defines if the current attribute is displayed or not';
comment on column wwv_flow_plugin_std_attributes.depending_on_condition_type  is
    'Identifies the type of condition used to define when the attribute gets displayed.';
comment on column wwv_flow_plugin_std_attributes.depending_on_expression  is
    'Identifies the condition expression used to define when the attribute gets displayed.';
comment on column wwv_flow_plugin_std_attributes.examples  is
    'Examples displayed in APEX Builder for this attribute';
comment on column wwv_flow_plugin_std_attributes.help_text  is
    'Help text to be displayed in APEX Builder for this attribute';
comment on column wwv_flow_plugin_std_attributes.attribute_comment  is
    'Developer comment for this attribute';


--==============================================================================
create table wwv_flow_plugin_files (
    id                        number         not null
                                             constraint wwv_flow_plugin_file_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_plugin_file_flow_fk
                                             references wwv_flows on delete cascade,
    plugin_id                 number         not null
                                             constraint wwv_flow_plugin_file_parent_fk
                                             references wwv_flow_plugins on delete cascade,
    file_name                 varchar2(255)  not null,
    mime_type                 varchar2(255)  not null,
    file_charset              varchar2(128),
    file_content              blob,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  );

alter table wwv_flow_plugin_files
  add constraint wwv_flow_plugin_file_uk unique (plugin_id, file_name);

create index wwv_flow_plugin_file_flow_fx on wwv_flow_plugin_files (flow_id) compress;

create index wwv_flow_plugin_file_sgid_fx on wwv_flow_plugin_files(security_group_id) compress;

comment on table wwv_flow_plugin_files is
    'Stores the files like CSS, images, javascript files, ... of a plug-in.';
-- Add comments to the columns
comment on column wwv_flow_plugin_files.file_name is
    'Name of the file.';
comment on column wwv_flow_plugin_files.mime_type is
    'Mime type of the file.';
comment on column wwv_flow_plugin_files.file_charset is
    'IANA charset used for text files.';
comment on column wwv_flow_plugin_files.file_content is
    'Blob content of the file.';

--==============================================================================
create table wwv_flow_plugin_events (
    id                        number         not null
                                             constraint wwv_flow_plugin_evnt_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_plugin_evnt_flow_fk
                                             references wwv_flows on delete cascade,
    plugin_id                 number         not null
                                             constraint wwv_flow_plugin_evnt_parent_fk
                                             references wwv_flow_plugins on delete cascade,
    name                      varchar2(45)   not null
                                             constraint wwv_flow_plugin_evnt_name_ck
                                             check (lower(name)=name),
    display_name              varchar2(100)  not null,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  );

alter table wwv_flow_plugin_events
  add constraint wwv_flow_plugin_evnt_uk unique (plugin_id, name);

create index wwv_flow_plugin_evnt_flow_fx on wwv_flow_plugin_events (flow_id);

comment on table wwv_flow_plugin_events is
    'Stores which events can be triggered by this plug-in. This events are used for binding dynamic actions.';
-- Add comments to the columns
comment on column wwv_flow_plugins.name is
    'Internal name of the event which is used to reference it from wwv_flow_page_da_events and to bind the Javascript event.';
comment on column wwv_flow_plugins.display_name is
    'Contains the name of the event which is displayed on the UI.';

--==============================================================================
create table wwv_flow_plugin_item_filters (
    id                        number         not null
                                             constraint wwv_flow_plugin_iflt_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_plugin_iflt_flow_fk
                                             references wwv_flows on delete cascade,
    plugin_id                 number         not null
                                             constraint wwv_flow_plugin_iflt_parent_fk
                                             references wwv_flow_plugins on delete cascade,
    name                      varchar2(40)   not null
                                             constraint wwv_flow_plugin_iflt_name_ck
                                             check (upper(name)=name),
    display_name              varchar2(40)   not null,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  );

alter table wwv_flow_plugin_item_filters
  add constraint wwv_flow_plugin_iflt_uk unique (plugin_id, name);

create index wwv_flow_plugin_iflt_flow_fx on wwv_flow_plugin_item_filters (flow_id);

comment on table wwv_flow_plugin_item_filters is
    'Stores which filter operators can be used by this plug-in.';
-- Add comments to the columns
comment on column wwv_flow_plugin_item_filters.name is
    'Internal name of the filter which is used to reference it in the plug-in and in Page Designer.';
comment on column wwv_flow_plugin_item_filters.display_name is
    'Contains the name of the filter operator which is displayed in Page Designer.';

--==============================================================================
create table wwv_flow_plugin_settings (
    id                           number
                                 constraint wwv_flow_plugin_set_pk
                                 primary key,
    flow_id                      number not null
                                 constraint wwv_flow_plugin_set_flow_fk
                                 references wwv_flows on delete cascade,
    plugin_type                  varchar2(30)  not null
                                               constraint wwv_flow_plugin_set_type_ck
                                               check (plugin_type in ( 'ITEM TYPE',
                                                                       'DYNAMIC ACTION',
                                                                       'REGION TYPE',
                                                                       'VALIDATION TYPE',
                                                                       'PROCESS TYPE',
                                                                       'REPORT COLUMN TYPE',
                                                                       'AUTHORIZATION TYPE',
                                                                       'AUTHENTICATION TYPE' )),
    plugin                       varchar2(255) not null
                                               constraint wwv_flow_plugin_set_plugin_ck
                                               check (  plugin like 'NATIVE\_%' escape '\'
                                                     or plugin like 'PLUGIN\_%' escape '\' ),
    attribute_01                 varchar2(4000),
    attribute_02                 varchar2(4000),
    attribute_03                 varchar2(4000),
    attribute_04                 varchar2(4000),
    attribute_05                 varchar2(4000),
    attribute_06                 varchar2(4000),
    attribute_07                 varchar2(4000),
    attribute_08                 varchar2(4000),
    attribute_09                 varchar2(4000),
    attribute_10                 varchar2(4000),
    attribute_11                 varchar2(4000),
    attribute_12                 varchar2(4000),
    attribute_13                 varchar2(4000),
    attribute_14                 varchar2(4000),
    attribute_15                 varchar2(4000),
    security_group_id            number not null,
    created_by                   varchar2(255),
    created_on                   date,
    last_updated_by              varchar2(255),
    last_updated_on              date
  );

alter table wwv_flow_plugin_settings add constraint wwv_flow_plugin_set_uk unique (flow_id, plugin_type, plugin);
alter index wwv_flow_plugin_set_uk rebuild compress 2;

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > REPORTS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > REPORTS

--==============================================================================
create table wwv_flow_report_layouts (
    id                             number
                                       constraint wwv_flow_report_layouts_pk
                                       primary key,
    flow_id                        number not null
                                       constraint wwv_flow_report_layoutse_fk
                                       references wwv_flows
                                       on delete cascade,
    report_layout_name             varchar2(4000) not null,
    report_layout_type             varchar2(255) constraint wwv_flow_report_layout_type
                                     check (report_layout_type in (
                                          'RTF_FILE',
                                          'XSL_FILE',
                                          'XSL_GENERIC'
                                      )),
    --
    page_template                  clob not null,
    xslfo_column_heading_template  varchar2(4000),
    xslfo_column_template          varchar2(4000),
    xslfo_column_template_width    varchar2(4000),
    --
    reference_id                   number,
    security_group_id              number not null,
    --
    created_on                     date,
    created_by                     varchar2(255),
    last_updated_by                varchar2(255),
    last_updated_on                date,
    --
    report_layout_comment          varchar2(4000)
    ) lob (page_template) store as (cache reads enable storage in row)
/

create index wwv_flow_report_layouts_idx1 on wwv_flow_report_layouts (flow_id,security_group_id)
/
create unique index wwv_flow_report_layouts_idx2 on wwv_flow_report_layouts (flow_id,substr(report_layout_name,1,500))
/

--==============================================================================
create table  wwv_flow_shared_queries (
    id                    number
                             constraint wwv_flow_shared_qry_pk
                             primary key,
    flow_id               number not null
                             constraint wwv_flow_shdqry_flow_fk
                             references wwv_flows
                             on delete cascade,
    name                  varchar2(255) not null enable,
    security_group_id     number not null,
     --
    query_text            clob   not null,
    xml_structure         varchar2(255) constraint wwv_flow_shared_qry_xml_strc
                             check (xml_structure in (
                                 'STANDARD',
                                 'APEX'
                             )),
    report_layout_id      number,
    format                varchar2(255) constraint wwv_flow_shared_qry_format
                             check (format in (
                                 'PDF',
                                 'RTF',
                                 'XLS',
                                 'HTM',
                                 'XML'
                             )),
    format_item           varchar2(4000),
    output_file_name      varchar2(4000),
    content_disposition   varchar2(255) constraint shared_qry_content_disp
                              check (content_disposition in (
                                  'INLINE',
                                  'ATTACHMENT'
                              )),
    document_header       varchar2(255) constraint shared_qry_header
                             check (document_header in (
                                 'SERVER',
                                 'APEX'
                             )),
    xml_items             varchar2(4000),
    --
    created_on            date,
    created_by            varchar2(255),
    last_updated_on       date,
    last_updated_by       varchar2(255)
    ) lob (query_text) store as (cache reads enable storage in row)
/

create unique index wwv_flow_stored_queries_uk1 on wwv_flow_shared_queries (name, flow_id)
/

create index wwv_flow_stored_qry_fid_fk on wwv_flow_shared_queries (flow_id)
/

--==============================================================================
-- shared query SQL Statements
create table  wwv_flow_shared_qry_sql_stmts (
    id                    number
                             constraint wwv_flow_sqry_sql_pk
                             primary key,
    flow_id               number not null
                             constraint wwv_flow_sqry_sql_flow_fk
                             references wwv_flows
                             on delete cascade,
    shared_query_id       number not null
                             constraint wwv_flow_sqry_sql_sqry_fk
                             references wwv_flow_shared_queries
                             on delete cascade,
    security_group_id     number not null,
     --
    sql_statement         clob   not null,
    --
    created_on            date,
    created_by            varchar2(255),
    last_updated_on       date,
    last_updated_by       varchar2(255)
) lob (sql_statement) store as (cache reads enable storage in row)
/

create index wwv_flow_sqry_sql_fk1 on wwv_flow_shared_qry_sql_stmts (flow_id)
/

create index wwv_flow_sqry_sql_fk2 on wwv_flow_shared_qry_sql_stmts (shared_query_id)
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > GLOBALIZATION
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > GLOBALIZATION

--==============================================================================
create table wwv_flow_languages (
    id                  number
                        constraint wwv_flow_languages_pk
                        primary key,
    lang_id             varchar2(255) not null,
    lang_id_upper       varchar2(255) not null,
    lang_name           varchar2(255) not null,
    nls_language        varchar2(255) not null,
    nls_territory       varchar2(255),
    nls_sort            varchar2(255),
    nls_windows_charset varchar2(255),
    translated_lang_name nvarchar2(255),
    dl_format            nvarchar2(255),
    ds_format            nvarchar2(255)
    )
/

create unique index wwv_flow_language_idx1 on wwv_flow_languages (lang_id)
/

create index wwv_flow_lang_comp_idx1 on wwv_flow_languages (lang_id_upper, nls_language, nls_territory)
/

--==============================================================================
create table wwv_flow_language_map (
     id                             number
                                    constraint wwv_flow_lang_map_pk
                                    primary key,
     primary_language_flow_id       number
                                    constraint   wwv_flow_lang_flow_id_fk
                                    references   wwv_flows on delete cascade,
     translation_flow_id            number       not null,
     translation_flow_language_code varchar2(30) not null,
     trans_flow_lang_code_root      varchar2(30),
     translation_image_directory    varchar2(255),
     translation_comments           varchar2(4000),
     direction_right_to_left        varchar2(1) default 'N' not null
                                    constraint wwv_flow_language_map_dir_ck
                                    check (direction_right_to_left in ('Y','N')),
     security_group_id              number not null,
     last_updated_by                varchar2(255),
     last_updated_on                date,
     -- 4.0
     created_by                     varchar2(255),
     created_on                     date,
     map_comments                   varchar2(4000)
     )
/

create unique index wwv_flow_language_map_idx1 on wwv_flow_language_map
    (primary_language_flow_id, translation_flow_language_code)
/
create unique index wwv_flow_language_map_idx2 on wwv_flow_language_map
    (translation_flow_id)
/

--==============================================================================
create table wwv_flow_translatable_cols$ (
    id                         number
                               constraint wwv_flow_trans_cols_pk
                               primary key,
    table_name                 varchar2(30),
    column_name                varchar2(30),
    table_pk                   varchar2(30),
    flow_id_column             varchar2(30),
    page_id_column             varchar2(30),
    datatype                   varchar2(30),
    template_translatable      varchar2(1)
                               constraint wwv_flow_trans_cols_chk
                               check (template_translatable in ('Y','N')),
    column_description         varchar2(4000)
    )
/
create index wwv_flow_trans_cols$_idx1 on wwv_flow_translatable_cols$
    (table_name,column_name)
    compress 1
/

--==============================================================================
-- text_substr_1_255 column may be obsolete
create table wwv_flow_translatable_text$ (
    id                            number
                                  constraint wwv_flow_trans_text_pk
                                  primary key,
    translated_flow_id            number,
    flow_id                       number  not null
                                  constraint wwv_flow_trans_text_fk
                                  references wwv_flows
                                  on delete cascade,
    page_id                       number,
    translate_from_id             number,
    translate_to_id               number,
    translate_from_flow_table     varchar2(61),
    translate_from_flow_column    varchar2(30),
    translate_to_lang_code        varchar2(30),
    translation_specific_to_item  varchar2(3)
                                  constraint wwv_flow_trans_specific_check
                                  check (translation_specific_to_item in ('YES','NO')),
    translate_to_text             nclob,
    translate_from_text           nclob,
    template_translatable         varchar2(1)
                                  constraint wwv_flow_trans_temp_trans_chk
                                  check (template_translatable in ('Y','N')),
    security_group_id             number not null,
    last_updated_by               varchar2(255),
    last_updated_on               date,
    -- 4.0
    created_by                    varchar2(255),
    created_on                    date,
    text_substr_1_255             nvarchar2(255)
    )
/


create unique index wwv_flow_translatable_text_pk on wwv_flow_translatable_text$ (
     flow_id, page_id, translate_from_id, translate_from_flow_table, translate_from_flow_column,
     translate_to_lang_code) compress;


create index wwv_flow_translatable_substr  on wwv_flow_translatable_text$ (text_substr_1_255) ;
create index wwv_flow_translatable_from_id on wwv_flow_translatable_text$ (translate_from_id, translated_flow_id, translate_from_flow_table, translate_from_flow_column);
create index wwv_flow_translatable_key2    on wwv_flow_translatable_text$ (flow_id, translate_from_flow_table, translate_from_flow_column);

--==============================================================================
create table wwv_flow_dynamic_translations$ (
    id                         number
                               constraint wwv_flow_dyn_trans_pk
                               primary key,
    flow_id                    number  not null
                               constraint wwv_flow_dynamic_trans_fk1
                               references wwv_flows
                               on delete cascade,
    translate_to_lang_code     varchar2(30),
    translate_from_text        varchar2(4000),
    translate_to_text          varchar2(4000),
    created_by                 varchar2(255),
    created_on                 date,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    security_group_id          number not null
                               constraint wwv_flow_dynamic_trans_fk2
                               references wwv_flow_companies(provisioning_company_id)
                               on delete cascade)
/

create index wwv_flow_dynamic_trans_idx1 on wwv_flow_dynamic_translations$ ( flow_id )
/

create index WWV_FLOW_DYNAMIC_TRANSL_FKIDX ON WWV_FLOW_DYNAMIC_TRANSLATIONS$
    (SECURITY_GROUP_ID,flow_id,TRANSLATE_TO_LANG_CODE)
/

--==============================================================================
-- MESSAGES
create table wwv_flow_messages$ (
    id                           number
                                 constraint wwv_flow_messages_pk
                                 primary  key,
    flow_id                      number not null
                                 constraint wwv_flow_messages_fk
                                 references wwv_flows
                                 on delete cascade,
    name                         varchar2(255) not null,
    message_language             varchar2(50)  not null,
    message_text                 varchar2(4000) not null,
    is_js_message                varchar2(1) default 'N' not null
                                             constraint wwv_flow_messages_is_js_msg_ck
                                             check (is_js_message in ('Y', 'N')),
    security_group_id            number not null,
    last_updated_by              varchar2(255),
    last_updated_on              date,
    -- 4.0
    created_by                   varchar2(255),
    created_on                   date,
    message_comment              varchar2(4000),
    constraint wwv_flow_messages$_uq unique (name, flow_id, message_language) using index compress 1
    )
/
create index wwv_flow_messages$_ix1 on wwv_flow_messages$ (flow_id, message_language, is_js_message)
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > APPLICATION PROCESSES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > APPLICATION PROCESSES

--==============================================================================
create table wwv_flow_processing (
    id                number
                      constraint wwv_flow_processing_pk
                      primary key,
    flow_id           number not null
                      constraint wwv_flow_processing_fk
                      references wwv_flows
                      on delete cascade,
    --
    process_sequence  number not null,
    process_point     varchar2(255) not null
                      constraint valid_fproc_procpoint
                      check (process_point in (
                      'ON_DEMAND',
                      'ON_SUBMIT_BEFORE_COMPUTATION',
                      'ON_NEW_INSTANCE',      -- after a new session has been created
                      'AFTER_LOGIN',          -- after a successful authentication
                      'BEFORE_HEADER',
                      'AFTER_HEADER',
                      'AFTER_ERROR_HEADER',
                      'BEFORE_ERROR_FOOTER',
                      'BEFORE_BOX_BODY',
                      'BEFORE_SHOW_ITEMS', -- obsolete
                      'AFTER_SHOW_ITEMS', -- obsolete
                      'AFTER_BOX_BODY',
                      'BEFORE_FOOTER',
                      'AFTER_FOOTER',
                      'AFTER_SUBMIT_BEFORE_VALIDATION',
                      'AFTER_SUBMIT')),
    --
    process_type           varchar2(255) not null
                           constraint wwv_valid_proc_type
                           check (process_type in (
                           'SET_ITEM_USING_STATIC_ASSIGNMENT',
                           'SET_ITEM_USING_PLSQL_FUNCTION_BODY',
                           'SET_ITEM_USING_PLSQL_EXPRESSION',
                           'SET_ITEM_USING_SQL_EXPRESSION',
                           'SET_ITEM_USING_SQL_QUERY',
                           'INITIALIZE_ALL_PAGE_ITEMS'
                           ) or
                           process_type like 'NATIVE\_%' ESCAPE '\' or
                           process_type like 'PLUGIN\_%' ESCAPE '\'),
    --
    process_name           varchar2(255)  not null,
    process_sql_clob       clob,
    location               varchar2(10)
                           constraint wwv_app_proc_location_ck
                           check (location in ('LOCAL', 'REMOTE', 'WEB_SOURCE' )),
    remote_server_id       number
                           constraint wwv_app_proc_remote_server_fk
                           references wwv_remote_servers,
    web_src_operation_id   number
                           constraint wwv_app_proc_websrc_opers_fk
                           references wwv_flow_web_src_operations,
    --
    attribute_01           varchar2(4000),
    attribute_02           varchar2(4000),
    attribute_03           varchar2(4000),
    attribute_04           varchar2(4000),
    attribute_05           varchar2(4000),
    attribute_06           varchar2(4000),
    attribute_07           varchar2(4000),
    attribute_08           varchar2(4000),
    attribute_09           varchar2(4000),
    attribute_10           varchar2(4000),
    attribute_11           varchar2(4000),
    attribute_12           varchar2(4000),
    attribute_13           varchar2(4000),
    attribute_14           varchar2(4000),
    attribute_15           varchar2(4000),
    --
    process_error_message  varchar2(4000),
    error_display_location varchar2(40) default 'ON_ERROR_PAGE' not null
                                        constraint wwv_flow_proc_edl
                                        check (error_display_location in ('INLINE_IN_NOTIFICATION', 'ON_ERROR_PAGE')),
    process_when           varchar2(4000),
    process_when_type      varchar2(255),
    process_when2          varchar2(4000),
    process_when_type2     varchar2(255),
    item_name              varchar2(255),
    required_patch         number,
    security_scheme        varchar2(255),
    runtime_where_clause   varchar2(4000),
    --
    security_group_id      number not null,
    last_updated_by        varchar2(255),
    last_updated_on        date,
    -- 4.0
    created_by             varchar2(255),
    created_on             date,
    process_comment        varchar2(4000)
    )    lob (process_sql_clob) store as (cache reads enable storage in row)
/

create unique index wwv_flow_processing_fkidx on wwv_flow_processing(flow_id,id);

create index wwv_app_proc_remote_server_fx on wwv_flow_processing( remote_server_id );
create index wwv_app_proc_websrc_opers_fx  on wwv_flow_processing( web_src_operation_id );

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > APPLICATION ITEMS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > APPLICATION ITEMS

--==============================================================================
create table wwv_flow_items (
    id                         number
                               constraint wwv_flow_items_pk
                               primary key,
    flow_id                    number not null
                               constraint wwv_flow_items_fk
                               references wwv_flows
                               on delete cascade,
    name                       varchar2(255) not null,
    name_length                number,
    scope                      varchar2(6)
                               default 'APP'
                               not null
                               constraint wwv_flow_items_ck_scope
                               check(scope in ('APP','GLOBAL')),
    data_type                  varchar2(30)
                               constraint valid_fitems_datatype
                               check (data_type in (
                               'VARCHAR',
                               'NUMBER',
                               'DATE')),
    is_Persistent              varchar2(1)
                               constraint valid_fitems_ispers
                               check (is_Persistent in ('Y','N','U','A')),
    protection_level           varchar2(1)
                               constraint valid_fitems_protection_level
                               check (protection_level in ('N','B','P','S','I')),
    required_patch             number,
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    item_comment               varchar2(4000)
    )
/

create index wwv_flow_items_u_name on wwv_flow_items (flow_id,name);
create unique index wwv_flow_items_idx3 on wwv_flow_items (flow_id,security_group_id,name);
create index wwv_flow_items_idx4 on wwv_flow_items (flow_id, protection_level);

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > APPLICATION COMPUTATIONS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > APPLICATION COMPUTATIONS

--==============================================================================
create table wwv_flow_computations (
    id                    number
                          constraint wwv_flow_computations_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_computations_fk
                          references wwv_flows
                          on delete cascade,
    --
    computation_sequence  number        not null,
    computation_item      varchar2(255) not null,
    computation_point     varchar2(255) not null,
                          constraint valid_fcomp_point
                          check (computation_point in (
                          'ON_NEW_INSTANCE',
                          'AFTER_LOGIN',
                          'BEFORE_HEADER',
                          'AFTER_ERROR_HEADER',
                          'BEFORE_ERROR_FOOTER',
                          'AFTER_HEADER',
                          'BEFORE_BOX_BODY',
                          'AFTER_BOX_BODY',
                          'BEFORE_FOOTER',
                          'AFTER_FOOTER',
                          'AFTER_SUBMIT')),
    -- computation_item_type to be obsoleted (SSpadafore)
    computation_item_type varchar2(30)
                          constraint valid_fcomp_itemtype
                          check (computation_item_type in (
                          'VARCHAR',
                          'VC_ARR',
                          'NUMBER')),
    computation_type      varchar2(30) not null
                          constraint valid_fcomp_comptype
                          check (computation_type in (
                          'SET_ITEM_EQUAL_THIS_PREFERENCE',
                          'STATIC_ASSIGNMENT',
                          'FUNCTION_BODY',
                          'QUERY',
                          'QUERY_COLON',
                          'PLSQL_EXPRESSION',
                          'SQL_EXPRESSION',
                          'SQL_EXPRESION',
                          'ITEM_VALUE')),
    computation_processed varchar2(30)
                          constraint valid_fcomp_compproc
                          check (computation_processed in (
                          'ON_NEW_INSTANCE',
                          'REPLACE_EXISTING',
                          'ADD_TO_EXISTING',
                          'RAISE_ERROR_ON_REPLACE',
                          'REPLACE_NULL_VALUES')),
    computation                varchar2(4000),
    required_patch             number,
    compute_when               varchar2(4000),
    compute_when_type          varchar2(255),
    compute_when_text          varchar2(4000),
    computation_error_message  varchar2(4000),
    security_scheme            varchar2(255),
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    computation_comment        varchar2(4000)
    )
/
create index wwv_flow_computations_fkidx on wwv_flow_computations(flow_id,id);

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > AUTHENTICATIONS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > AUTHENTICATIONS

--==============================================================================
-- legacy authentication table (pre 4.1), still needed for upgrades
--
create table wwv_flow_custom_auth_setups(
    id                                                 number
        constraint wwv_flow_auth_setups_pk
        primary key,
    flow_id                                            number not null
        constraint wwv_flow_auth_setups_fk
        references wwv_flows on delete cascade,
    reference_id                                       number,
    name                                               varchar2(255) not null,
    description                                        varchar2(4000),
    page_sentry_function                               clob,
    sess_verify_function                               clob,
    invalid_session_page                               number,
    invalid_session_url                                varchar2(4000),
    pre_auth_process                                   clob,
    auth_function                                      clob,
    post_auth_process                                  clob,
    cookie_name                                        varchar2(4000),
    cookie_path                                        varchar2(4000),
    cookie_domain                                      varchar2(4000),
    use_secure_cookie_yn                               varchar2(1)
                                                       constraint wwv_flow_custom_auth_chk1
                                                       check (use_secure_cookie_yn in ('Y','N')),
    ldap_host                                          varchar(255),
    ldap_port                                          varchar(255),
    ldap_string                                        varchar(255),
    attribute_01                                       varchar(4000),
    attribute_02                                       varchar(4000),
    attribute_03                                       varchar(4000),
    attribute_04                                       varchar(4000),
    attribute_05                                       varchar(4000),
    attribute_06                                       varchar(4000),
    attribute_07                                       varchar(4000),
    attribute_08                                       varchar(4000),
    required_patch                                     number,
    security_group_id                                  number not null,
    last_updated_by                                    varchar2(255),
    last_updated_on                                    date,
    created_by                                         varchar2(255),
    created_on                                         date)
    lob (page_sentry_function, sess_verify_function, pre_auth_process, auth_function, post_auth_process) store as (cache reads enable storage in row)
/
create index wwv_flow_auth_setups_idx1 on wwv_flow_custom_auth_setups (flow_id);

--==============================================================================
create table wwv_flow_authentications (
    id                                                  number,
    security_group_id                                   number         not null,
    flow_id                                             number         not null,
    reference_id                                        number,
    name                                                varchar2(255)  not null,
    scheme_type                                         varchar2(255)  not null,
    --
    invalid_session_type                                varchar2(13),
    invalid_session_url                                 varchar2(4000),
    --
    switch_in_session_yn                                varchar2(1)    default 'N' not null,
    --
    cookie_type                                         varchar2(1) generated always as (
                                                                        case
                                                                        when use_secure_cookie_yn<>'N'
                                                                             or cookie_domain is not null
                                                                             or cookie_path   is not null
                                                                             or cookie_name   is not null
                                                                        then 'C'
                                                                        when cookie_name is null
                                                                        then 'A'
                                                                        when cookie_name='&WORKSPACE_COOKIE.'
                                                                        then 'W'
                                                                        else 'C'
                                                                        end ) virtual,
    cookie_name                                         varchar2(4000),
    cookie_path                                         varchar2(4000),
    cookie_domain                                       varchar2(4000),
    use_secure_cookie_yn                                varchar2(1)    default 'N' not null,
    logout_url                                          varchar2(4000),
    logout_type                                         varchar2(4) generated always as (
                                                                        case
                                                                        when logout_url is null then 'HOME'
                                                                        else 'URL'
                                                                        end ) virtual,
    --
    plsql_code                                          clob,
    verification_function                               varchar2(255),
    pre_auth_process                                    varchar2(255),
    post_auth_process                                   varchar2(255),
    --
    ras_mode                                            number(1,0)    default 0 not null,
    ras_dynamic_roles                                   varchar2(4000),
    ras_namespaces                                      varchar2(4000),
    --
    attribute_01                                        varchar2(4000),
    attribute_02                                        varchar2(4000),
    attribute_03                                        varchar2(4000),
    attribute_04                                        varchar2(4000),
    attribute_05                                        varchar2(4000),
    attribute_06                                        varchar2(4000),
    attribute_07                                        varchar2(4000),
    attribute_08                                        varchar2(4000),
    attribute_09                                        varchar2(4000),
    attribute_10                                        varchar2(4000),
    attribute_11                                        varchar2(4000),
    attribute_12                                        varchar2(4000),
    attribute_13                                        varchar2(4000),
    attribute_14                                        varchar2(4000),
    attribute_15                                        varchar2(4000),
    --
    help_text                                           varchar2(4000),
    comments                                            varchar2(4000),
    --
    last_updated_by                                     varchar2(255),
    last_updated_on                                     date,
    created_by                                          varchar2(255),
    created_on                                          date,
    --
    credential_id                                       number generated always as (
                                                                   case
                                                                   when scheme_type in ( 'NATIVE_SOCIAL',
                                                                                         'NATIVE_SAML' )
                                                                   then to_number(attribute_01)
                                                                   end ) virtual,
    --
    constraint wwv_flow_authentications_pk              primary key(id),
    constraint wwv_flow_authentications_fk              foreign key(flow_id)
                                                        references wwv_flows
                                                        on delete cascade,
    constraint wwv_flow_authn_fk_cred                   foreign key(credential_id)
                                                        references wwv_credentials(id),
    constraint wwv_flow_authentications_uk              unique(flow_id,name),
    constraint wwv_flow_authentications_ck1             check (use_secure_cookie_yn in ('Y','N')),
    constraint wwv_flow_authentications_ck2             check (
                                                             scheme_type like 'NATIVE\_%' escape '\'
                                                          or scheme_type like 'PLUGIN\_%' escape '\' ),
    constraint wwv_flow_authentications_ck3             check (invalid_session_type in ('LOGIN','BUILTIN_LOGIN','URL')),
    constraint wwv_flow_authentications_ck4             check (ras_mode in (0,1,2)),
    constraint wwv_flow_authentications_ck5             check (switch_in_session_yn in ('Y','N'))
) lob (plsql_code) store as (cache reads enable storage in row)
/

alter table wwv_flows add (
    constraint wwv_flows_fk_authentication              foreign key (authentication_id)
                                                        references wwv_flow_authentications(id)
                                                        initially deferred
)
/

alter index wwv_flow_authentications_uk rebuild compress 1
/
create index wwv_flow_authentications_idx1 on wwv_flow_authentications (reference_id) compress
/
create index wwv_flow_authentications_idx2 on wwv_flow_authentications (credential_id)
/

comment on column wwv_flow_authentications.ras_mode is
'12c Real Application Security: 0 - Disabled, 1 - External Users, 2 - Internal users'
/
comment on column wwv_flow_authentications.ras_dynamic_roles is
'12c Real Application Security: Colon-separated list of dynamic roles that are enabled on assign_user'
/
comment on column wwv_flow_authentications.ras_namespaces is
'12c Real Application Security: Colon-separated list of namespaces that are enabled on create_session'
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > WEB SERVICE REFERENCES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > WEB SERVICE REFERENCES

--==============================================================================
create table wwv_flow_shared_web_services (
   id                            number
                                 constraint wwv_flow_web_services_pk
                                 primary key,
   --
   -- columns that identifies who owns the service description
   --
   security_group_id             number not null,
   flow_id                       number
                                 constraint wwv_flow_ws_fk
                                 references wwv_flows
                                 on delete cascade,
   name                          varchar2(255) not null,
   --
   -- columns that describe the service
   --
   url                           varchar2(4000),
   action                        varchar2(4000),
   proxy_override                varchar2(4000),
   soap_version                  varchar2(30),
   --
   -- can be generated, but can also be edited after generation
   --
   soap_envelope                 clob,
   --
   -- body / envelope substitution strings
   --
   flow_items_comma_delimited    clob,
   static_parm_01                varchar2(4000),
   static_parm_02                varchar2(4000),
   static_parm_03                varchar2(4000),
   static_parm_04                varchar2(4000),
   static_parm_05                varchar2(4000),
   static_parm_06                varchar2(4000),
   static_parm_07                varchar2(4000),
   static_parm_08                varchar2(4000),
   static_parm_09                varchar2(4000),
   static_parm_10                varchar2(4000),
   --
   -- columns that deal with soap responce
   --
   stylesheet                    clob,
   --
   -- administrative columns
   --
   reference_id                  number,
   last_updated_by               varchar2(255),
   last_updated_on               date,
   -- 4.0
   created_by                 varchar2(255),
   created_on                 date
   ) lob (soap_envelope, stylesheet) store as (cache reads enable storage in row)
/

comment on column wwv_flow_shared_web_services.url is 'SOAP Service URL';
comment on column wwv_flow_shared_web_services.action is 'SOAP Action';
comment on column wwv_flow_shared_web_services.proxy_override is 'HTTP proxy for SOAP request';
comment on column wwv_flow_shared_web_services.soap_envelope is 'May contain #ITEM_NAME# substitutions';
comment on column wwv_flow_shared_web_services.flow_items_comma_delimited is 'A comma delmited list of flow items contained in the body for example: ITEM1,ITEM2,ITEM3';

create index wwv_flow_shared_web_serv_idx1 on wwv_flow_shared_web_services (flow_id)
/

--==============================================================================
create table wwv_flow_ws_operations (
    id                      number
                            constraint wwv_flow_ws_opers_pk
                            primary key,
    ws_id                   number
                            constraint wwv_flow_ws_opers_fk
                            references wwv_flow_shared_web_services
                            on delete cascade,
    name                    varchar2(255),
    input_message_name      varchar2(255),
    input_message_ns        varchar2(4000),
    input_message_style     varchar2(255),
    output_message_name     varchar2(255),
    output_message_ns       varchar2(4000),
    output_message_style    varchar2(255),
    header_message_name     varchar2(4000),
    header_message_style    varchar2(255),
    soap_action             varchar2(4000),
    --
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date,
    -- 4.0
    created_by              varchar2(255),
    created_on              date
    )
/

create index wwv_flow_ws_opers_idx1 on wwv_flow_ws_operations (ws_id)
/

--==============================================================================
create table wwv_flow_ws_parameters (
    id                      number
                            constraint wwv_flow_ws_parms_pk
                            primary key,
    ws_opers_id             number
                            constraint wwv_flow_ws_parms_fk
                            references wwv_flow_ws_operations
                            on delete cascade,
    name                    varchar2(255),
    input_or_output         varchar2(1)
                            constraint wwv_flow_ws_parms_chk1
                            check (input_or_output in ('I','O','H','A')),
    parm_type               varchar2(255),
    path                    varchar2(4000),
    type_is_xsd             varchar2(1)
                            constraint wwv_flow_ws_parms_chk2
                            check (type_is_xsd in ('Y','N')),
    form_qualified          varchar2(1)
                            constraint wwv_flow_ws_parms_chk3
                            check (form_qualified in ('Y','N')),
    parent_id               number,
    --
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date
    )
/

create index wwv_flow_ws_parms_idx1 on wwv_flow_ws_parameters (ws_opers_id)
/


--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > TABS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > TABS

--==============================================================================
create table wwv_flow_tabs (
    id                         number
                               constraint wwv_flow_tabs_pk
                               primary key,
    flow_id                    number not null
                               constraint wwv_flow_tabs_fk
                               references wwv_flows
                               on delete cascade,
    tab_set                    varchar2(255)  not null,
    tab_sequence               number         not null,
    tab_name                   varchar2(255)  not null,
    tab_image                  varchar2(255),
    tab_non_current_image      varchar2(255),
    tab_image_attributes       varchar2(255),
    tab_text                   varchar2(2000) not null,
    tab_step                   number not null,
    tab_also_current_for_pages varchar2(4000),
    tab_parent_tabset          varchar2(255),
    tab_plsql_condition        varchar2(4000),
    display_condition_type     varchar2(255),
    tab_disp_cond_text         varchar2(4000),
    required_patch             number,
    security_scheme            varchar2(255),
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    tab_comment                varchar2(4000)
    )
/

create unique index wwv_flow_tabs_unique on wwv_flow_tabs (flow_id, tab_set, tab_name)
/

create unique index wwv_flow_tabs_unique2 on wwv_flow_tabs (flow_id, security_group_id, tab_set, tab_name)
/

--==============================================================================
create table wwv_flow_toplevel_tabs (
    id                         number
                               constraint wwv_flow_toplev_tab_pk
                               primary key,
    flow_id                    number not null
                               constraint wwv_flow_toplev_tab_fk
                               references wwv_flows
                               on delete cascade,
    tab_set                    varchar2(255)  not null,
    tab_sequence               number         not null,
    tab_name                   varchar2(255)  not null,
    tab_image                  varchar2(255),
    tab_non_current_image      varchar2(255),
    tab_image_attributes       varchar2(255),
    tab_text                   varchar2(2000) not null,
    tab_target                 varchar2(4000) not null,
    display_condition          varchar2(4000),
    display_condition2         varchar2(4000),
    display_condition_type     varchar2(255),
    current_on_tabset          varchar2(255),
    required_patch             number,
    security_scheme            varchar2(255),
    security_group_id          number not null,
    last_updated_by            varchar2(255),
    last_updated_on            date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    tab_comment                varchar2(4000)
    )
/

create unique index wwv_flow_tl_tabs_unique on wwv_flow_toplevel_tabs (flow_id, tab_set, tab_name)
/
create unique index wwv_flow_tl_tabs_unique2 on wwv_flow_toplevel_tabs (flow_id, security_group_id, tab_set, tab_name)
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > LISTS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > LISTS

--==============================================================================
create table wwv_flow_lists (
     id                       number
                              constraint wwv_flow_lists_pk
                              primary key,
     flow_id                  number not null
                              constraint wwv_flow_lists_flow_fk
                              references wwv_flows
                              on delete cascade,
     name                     varchar2(255) not null,
     list_type                varchar2(30) default 'STATIC' not null
                              constraint wwv_flow_val_list_type
                              check (list_type in ('STATIC','SQL_QUERY','FUNCTION_RETURNING_SQL_QUERY')),
     list_query               varchar2(4000),
     list_status              varchar2(255),
                              constraint wwv_flows_val_list_status
                              check (list_status in ('PERSONAL','PUBLIC')),
     list_displayed           varchar2(255)
                              constraint wwv_flow_val_listdisplayed1
                              check (list_displayed in ('ON_DEMAND','ALWAYS','NEVER','BY_DEFAULT')),
     display_row_template_id  number, /* $$$ obsolete */
     required_patch           number,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     -- 4.0
     created_by               varchar2(255),
     created_on               date,
     list_comment             varchar2(4000)
     )
/

create unique index wwv_flow_lists_fkidx on wwv_flow_lists(flow_id,id)
/

--==============================================================================
create table wwv_flow_list_items (
     id                           number
                                  constraint wwv_flow_list_items_pk
                                  primary key,
     list_id                      number
                                  constraint wwv_flow_list_items_fk
                                  references wwv_flow_lists
                                  on delete cascade,
     flow_id                      number,
     --
     sub_item_count               number,
     parent_list_item_id          number
                                  constraint parent_list_item_fk
                                  references wwv_flow_list_items
                                  on delete cascade,
     --
     list_item_type               varchar2(255)
                                  constraint wwv_flows_val_listitemtype
                                  check (list_item_type in ('LINK','FILE','TABLE')),
     list_item_status             varchar2(255),
                                  constraint wwv_flows_val_listitemstatus
                                  check (list_item_status in ('PERSONAL','PUBLIC')),
     item_displayed               varchar2(255)
                                  constraint wwv_flow_val_listdisplayed
                                  check (item_displayed in ('ON_DEMAND','ALWAYS','NEVER','BY_DEFAULT')),
     list_item_display_sequence   number,
     list_item_link_text          varchar2(4000),
     list_item_link_target        varchar2(4000),
     list_item_icon               varchar2(4000),
     list_item_icon_attributes    varchar2(4000),
     list_item_icon_alt_attribute varchar2(4000),
     --
     list_item_icon_exp           varchar2(4000),
     list_item_icon_exp_attr      varchar2(4000),
     --
     list_item_owner              varchar2(255),
     list_item_current_for_pages  varchar2(4000),
     list_item_current_type       varchar2(30)
                                  constraint wwv_flow_lst_curr_type_val
                                  check (list_item_current_type in (
                                  'COLON_DELIMITED_PAGE_LIST',
                                  'PLSQL_EXPRESSION',
                                  'ALWAYS',
                                  'NEVER',
                                  'EXISTS',
                                  'NOT_EXISTS',
                                  'TARGET_PAGE')),
     list_item_disp_cond_type     varchar2(255),
     list_item_disp_condition     varchar2(4000),
     list_item_disp_cond_type2    varchar2(255),
     list_item_disp_condition2    varchar2(4000),
     list_countclicks_y_n         varchar2(1)
                                  constraint wwv_flow_list_count_chk
                                  check (list_countclicks_y_n in ('Y','N')),
     list_countclicks_cat         varchar2(255),
     list_text_01                 varchar2(4000),
     list_text_02                 varchar2(4000),
     list_text_03                 varchar2(4000),
     list_text_04                 varchar2(4000),
     list_text_05                 varchar2(4000),
     list_text_06                 varchar2(4000),
     list_text_07                 varchar2(4000),
     list_text_08                 varchar2(4000),
     list_text_09                 varchar2(4000),
     list_text_10                 varchar2(4000),
     list_text_11                 varchar2(4000),
     list_text_12                 varchar2(4000),
     list_text_13                 varchar2(4000),
     list_text_14                 varchar2(4000),
     list_text_15                 varchar2(4000),
     list_text_16                 varchar2(4000),
     list_text_17                 varchar2(4000),
     list_text_18                 varchar2(4000),
     list_text_19                 varchar2(4000),
     list_text_20                 varchar2(4000),
     translate_list_text_y_n     varchar2(1)
                                  constraint wwv_flow_list_items_ck1
                                  check (translate_list_text_y_n in ('Y','N')),
     required_patch               number,
     security_scheme              varchar2(255),
     security_group_id            number not null,
     last_updated_by              varchar2(255),
     last_updated_on              date,
     -- 4.0
     created_by                   varchar2(255),
     created_on                   date,
     list_item_comment            varchar2(4000)
     )
/


create index parent_list_item_id_idx on wwv_flow_list_items ( parent_list_item_id )
/

create index wwv_flow_list_items_idx1 on wwv_flow_list_items ( security_group_id, flow_id, list_id )
/

create unique index wwv_flow_list_items_idx2 on wwv_flow_list_items (list_id,id,item_displayed,required_patch)
/

create index wwv_flow_list_items_fkidx on wwv_flow_list_items(list_id,flow_id,list_item_display_sequence)
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > BREADCRUMBS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > BREADCRUMBS

--==============================================================================
create table wwv_flow_menus (
     id                       number
                              constraint wwv_flow_menus_pk
                              primary key,
     flow_id                  number not null
                              constraint wwv_flow_menus_flow_fk
                              references wwv_flows
                              on delete cascade,
     name                     varchar2(255) not null,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     -- 4.0
     created_by                 varchar2(255),
     created_on                 date,
     menu_comment             varchar2(4000)
     )
/
create index wwv_flow_menus_idx1 on wwv_flow_menus (flow_id)
/

--==============================================================================
create table wwv_flow_menu_options (
     id                       number
                              constraint wwv_flow_menu_opts_pk
                              primary key,
     parent_id                number,
     menu_id                  number not null
                              constraint wwv_flow_opt_menus_fk
                              references wwv_flow_menus
                              on delete cascade,
     flow_id                  number,
     option_sequence          number,
     short_name               varchar2(255) not null,
     long_name                varchar2(4000),
     link                     varchar2(4000),
     page_id                  number,
     also_current_for_pages   varchar2(4000),
     display_when_cond_type   varchar2(255),
     display_when_condition   varchar2(4000),
     display_when_condition2  varchar2(4000),
     security_scheme          varchar2(255),
     required_patch           number,
     security_group_id        number not null,
     last_updated_by          varchar2(255),
     last_updated_on          date,
     -- 4.0
     created_by                 varchar2(255),
     created_on                 date,
     menu_option_comment      varchar2(4000)
     )
/

create unique index wwv_flow_unique_menu_opt on wwv_flow_menu_options (menu_id, page_id);

create index wwv_flow_menu_opt_idx1 on wwv_flow_menu_options (flow_id, id);

create index wwv_flow_menu_opt_idx2 on wwv_flow_menu_options (page_id,flow_id);


--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > TREES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > TREES

--==============================================================================
create table wwv_flow_trees  (
    id                        number
                              constraint wwv_flow_tree_pk
                              primary key,
    flow_id                   number not null
                              constraint wwv_flow_tree_fk
                              references wwv_flows
                              on delete cascade,
    tree_name                 varchar2(255)  not null,
    tree_type                 varchar2(30)
                              constraint wwv_flow_tree_type
                              check (tree_type in ('DYNAMIC','STATIC')),
    tree_query                varchar2(4000),
    flow_item                 varchar2(255),
    security_group_id         number not null,
    max_levels                number not null
                              constraint wwv_flow_valid_level
                              check (max_levels between 1 and 100),
    unexpanded_parent         varchar2(4000),
    unexpanded_parent_last    varchar2(4000),
    expanded_parent           varchar2(4000),
    expanded_parent_last      varchar2(4000),
    leaf_node                 varchar2(4000),
    leaf_node_last            varchar2(4000),
    drill_up                  varchar2(4000),
    name_link_anchor_tag      varchar2(4000),
    name_link_not_anchor_tag  varchar2(4000),
    indent_vertical_line      varchar2(4000),
    indent_vertical_line_last varchar2(4000),
    --
    before_tree               varchar2(4000),
    after_tree                varchar2(4000),
    --
    level_1_template          varchar2(4000),
    level_2_template          varchar2(4000),
    level_3_template          varchar2(4000),
    level_4_template          varchar2(4000),
    level_5_template          varchar2(4000),
    level_6_template          varchar2(4000),
    level_7_template          varchar2(4000),
    level_8_template          varchar2(4000),
    last_updated_by           varchar2(255),
    last_updated_on           date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    tree_comment              varchar2(4000)
    )
/
create unique index wwv_flow_trees_fkidx on wwv_flow_trees(flow_id,id);

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > NAVIGATION BAR ENTRIES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > NAVIGATION BAR ENTRIES

--==============================================================================
create table wwv_flow_icon_bar (
    id                          number
                                constraint wwv_flow_icon_bar_pk
                                primary key,
    flow_id                     number not null
                                constraint wwv_flow_icon_bar_fk
                                references wwv_flows
                                on delete cascade,
    icon_sequence               number not null,
    --
    icon_image                  varchar2(255),
    icon_image2                 varchar2(255),
    icon_image3                 varchar2(255),
    icon_subtext                varchar2(255),
    icon_subtext2               varchar2(255),
    icon_subtext3               varchar2(255),
    icon_target                 varchar2(4000),
    icon_image_alt              varchar2(4000),
    icon_height                 number,
    icon_width                  number,
    icon_height2                number,
    icon_width2                 number,
    icon_height3                number,
    icon_width3                 number,
    --
    icon_bar_disp_cond          varchar2(4000),
    icon_bar_disp_cond_type     varchar2(255),
    icon_bar_flow_cond_instr    varchar2(4000),
    begins_on_new_line          varchar2(30)
                                constraint valid_ficon_beginonnewline
                                check (begins_on_new_line in ('NO','YES')),
    cell_colspan                number,
    onclick                     varchar2(4000),
    required_patch              number,
    security_scheme             varchar2(255),
    reference_id                number,
    nav_entry_is_feedback_yn    varchar2(1) default 'N'
                                constraint valid_ficon_navisfeedback
                                check (nav_entry_is_feedback_yn in ('Y','N')),
    security_group_id           number not null,
    last_updated_by             varchar2(255),
    last_updated_on             date,
    -- 4.0
    created_by                  varchar2(255),
    created_on                  date,
    icon_bar_comment            varchar2(4000)
    )
/

create index wwv_flow_icon_bar_idx2 on wwv_flow_icon_bar (flow_id, security_group_id)
/


--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > LISTS OF VALUES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > LISTS OF VALUES

--==============================================================================
create table wwv_flow_lists_of_values$ (
    id                          number
                                constraint wwv_flow_lov_pk
                                primary key,
    flow_id                     number not null
                                constraint wwv_flow_lov_fk
                                references wwv_flows
                                on delete cascade,
    lov_name                    varchar2(255) not null,
    lov_query                   varchar2(4000),
    source_type                 varchar2(23)
                                constraint wwv_flow_lov_source_type_ck
                                check ( source_type in ( 'TABLE', 'SQL','FUNC_BODY_RETURNING_SQL', 'LEGACY_SQL' )),
    security_group_id           number         not null,
    reference_id                number,
    --
    location                    varchar2(13)
                                constraint wwv_flow_lov_location_ck
                                check ( location in ( 'STATIC', 'LOCAL', 'REMOTE', 'WEB_SOURCE' )),
    remote_server_id            number
                                constraint wwv_flow_lov_remote_server_fk
                                references wwv_remote_servers,
    web_src_module_id           number
                                constraint wwv_flow_lov_web_src_module_fk
                                references wwv_flow_web_src_modules,
    query_owner                 varchar2(128),
    query_table                 varchar2(128),
    query_where                 varchar2(4000),
    source_post_processing      varchar2(23),
                                constraint wwv_flow_lov_post_proc_ck
                                check ( source_post_processing in ( 'WHERE_ORDER_BY_CLAUSE', 'SQL', 'FUNC_BODY_RETURNING_SQL' )),
    optimizer_hint              varchar2(255),
    --
    remote_sql_caching          varchar2(9)
                                constraint wwv_flow_lov_rem_sql_cache_ck
                                check (remote_sql_caching in ( 'ALL_USERS', 'USER', 'SESSION' )),
    remote_sql_invalidate_when  varchar2(255),
    --
    external_filter_expr        varchar2(4000),
    external_order_by_expr      varchar2(255),
    --
    return_column_name          varchar2(128),
    display_column_name         varchar2(128),
    icon_column_name            varchar2(128),
    group_column_name           varchar2(128),
    group_sort_direction        varchar2(16)
                                constraint wwv_flow_lov_group_sort_dir_ck
                                check (group_sort_direction in ( 'ASC', 'ASC_NULLS_FIRST', 'DESC', 'DESC_NULLS_FIRST' )),
    default_sort_column_name    varchar2(128),
    default_sort_direction      varchar2(16)
                                constraint wwv_flow_lov_def_sort_dir_ck
                                check (default_sort_direction in ( 'ASC', 'ASC_NULLS_FIRST', 'DESC', 'DESC_NULLS_FIRST' ) ),
    oracle_text_column_name     varchar2(128),
    --
    last_updated_by             varchar2(255),
    last_updated_on             date,
    -- 4.0
    created_by                  varchar2(255),
    created_on                  date,
    lov_comment                 varchar2(4000)
    )
/

create index wwv_flow_lov_idx1 on wwv_flow_lists_of_values$ (flow_id, lov_name)
/
create unique index wwv_flow_lov_unique2 on wwv_flow_lists_of_values$ (flow_id, security_group_id, lov_name)
/
create index wwv_flow_lov_idx2 on wwv_flow_lists_of_values$ ( security_group_id, reference_id, id )
/
create index wwv_flow_lov_idx3 on wwv_flow_lists_of_values$ ( remote_server_id )
/
create index wwv_flow_lov_idx4 on wwv_flow_lists_of_values$ ( web_src_module_id )
/

--==============================================================================
create table wwv_flow_list_of_values_cols (
    id                            number
                                  constraint wwv_flow_lov_cols_pk
                                  primary key,
    lov_id                        number not null
                                  constraint wwv_flow_lov_cols_lov_fk
                                  references wwv_flow_lists_of_values$ on delete cascade,
    flow_id                       number not null,
    security_group_id             number not null,
    --
    query_column_name             varchar2(255) not null,
    heading                       varchar2(255),
    display_sequence              number not null,
    format_mask                   varchar2(255),
    data_type                     varchar2(30) not null
                                  constraint wwv_flow_lov_cols_data_type_ck
                                  check (data_type in ( 'VARCHAR2', 'NUMBER', 'DATE',
                                                        'TIMESTAMP', 'TIMESTAMP_TZ', 'TIMESTAMP_LTZ',
                                                        'INTERVAL_D2S', 'INTERVAL_Y2M',
                                                        'CLOB', 'ROWID' )),
    is_visible                    varchar2(1) not null
                                  constraint wwv_flow_lov_cols_is_vis_ck
                                  check (is_visible in ('Y', 'N')),
    is_searchable                 varchar2(1) not null
                                  constraint wwv_flow_lov_cols_search_ck
                                  check (is_searchable in ('Y', 'N')),
    --
    column_comment                varchar2(4000),
    last_updated_by               varchar2(255),
    last_updated_on               date,
    created_by                    varchar2(255),
    created_on                    date
    )
/

create index wwv_flow_lovc_idx1 on wwv_flow_list_of_values_cols ( lov_id )
/

alter table wwv_flow_list_of_values_cols add constraint wwv_flow_lovc_uk1 unique (lov_id, query_column_name)
/


--==============================================================================
create table wwv_flow_list_of_values_data (
    id                        number
                              constraint wwv_flow_lov_data_pk
                              primary key,
    lov_id                    number
                              constraint wwv_flow_lov_data_fk
                              references wwv_flow_lists_of_values$
                              on delete cascade,
    flow_id                   number,
    lov_disp_sequence         number not null,
    lov_disp_value            varchar2(4000) not null,
    lov_return_value          varchar2(4000) not null,
    lov_template              varchar2(4000),
    lov_disp_cond_type        varchar2(255),
    lov_disp_cond             varchar2(4000),
    lov_disp_cond2            varchar2(4000),
    required_patch            number,
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    lov_data_comment          varchar2(4000)
    )
/

create unique index wwv_flow_lov_data_idx1 on wwv_flow_list_of_values_data (
    lov_id, security_group_id, lov_disp_sequence, id)
/

create index wwv_flow_lov_data_idx2 on wwv_flow_list_of_values_data (
    flow_id, id)
/

create index wwv_flow_lov_data_idx3 on wwv_flow_list_of_values_data (
    lov_id, substr(lov_return_value, 1, 500))
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > DATA LOADING
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > DATA LOADING

--==============================================================================
create table wwv_flow_load_tables (
    id                              number
                                       constraint wwv_flow_load_tab_pk
                                       primary key,
    flow_id                         number not null
                                        constraint wwv_flow_load_tab_fk1
                                        references wwv_flows
                                        on delete cascade,
    name                            varchar2 (255) not null,
    owner                           varchar2 (255) not null,
    table_name                      varchar2 (255) not null,
    unique_column_1                 varchar2 (30) not null,
    is_uk1_case_sensitive           varchar2(1)
                                        constraint wwv_flow_load_tab_ck1
                                        check (is_uk1_case_sensitive in ('Y','N')) not null,
    unique_column_2                 varchar2 (30) ,
    is_uk2_case_sensitive           varchar2(1)
                                        constraint wwv_flow_load_tab_ck2
                                        check (is_uk2_case_sensitive in ('Y','N')),
    unique_column_3                 varchar2 (30) ,
    is_uk3_case_sensitive           varchar2(1)
                                    constraint wwv_flow_load_tab_ck3
                                        check (is_uk3_case_sensitive in ('Y','N')),
    wizard_page_ids                 varchar2 (4000) ,
    comments                        varchar2 (4000) ,
    security_group_id               number  not null ,
    created_on                      date ,
    created_by                      varchar2 (255) ,
    last_updated_on                 date ,
    last_updated_by                 varchar2 (255),
    version_column_name             varchar2 (30),
    skip_validation                 varchar2(1) default 'N' not null
                                    constraint wwv_flow_load_tab_ck4
                                        check (skip_validation in ('Y','N')),
    column_names_lov_id             number
                                        constraint wwv_flow_load_tab_fk2
                                        references wwv_flow_lists_of_values$
                                        on delete set null )

/

alter table wwv_flow_load_tables
    add constraint wwv_flow_load_tab_uk1 unique (flow_id, name)
/
create index wwv_flow_load_tab_idx1 on wwv_flow_load_tables (column_names_lov_id)
/

--==============================================================================
create table wwv_flow_load_table_lookups (
    id                              number
                                        constraint wwv_flow_load_tab_lk_pk
                                        primary key,
    flow_id                         number not null
                                    constraint wwv_flow_load_tab_lk_fk1
                                    references wwv_flows
                                    on delete cascade,
    load_table_id                   number  not null
                                    constraint wwv_flow_load_tab_lk_fk2
                                    references wwv_flow_load_tables
                                    on delete cascade,
    load_column_name                varchar2 (255) not null,
    lookup_owner                    varchar2 (255) not null,
    lookup_table_name               varchar2 (255) not null,
    key_column                      varchar2 (255) not null,
    display_column                  varchar2 (255) not null,
    alternative_key_column1         varchar2 (255) ,
    alternative_display_column1     varchar2 (255) ,
    alternative_key_column2         varchar2 (255) ,
    alternative_display_column2     varchar2 (255) ,
    where_clause                    varchar2 (4000),
    insert_new_value                varchar2 (1)
                                        constraint wwv_flow_load_tab_lk_ck1
                                        check (insert_new_value in ('Y','N')) not null,
    error_message                   varchar2(4000) ,
    security_group_id               number  not null ,
    created_on                      date ,
    created_by                      varchar2 (255) ,
    last_updated_on                 date ,
    last_updated_by                 varchar2 (255) )
/
alter table wwv_flow_load_table_lookups
    add constraint wwv_flow_load_tab_lk_uk1 unique ( load_table_id , load_column_name )
/
create index wwv_flow_load_tab_lk_idx2 on wwv_flow_load_table_lookups (flow_id) compress
/

--==============================================================================
create table wwv_flow_load_table_rules (
    id                              number    not null
                                        constraint wwv_flow_load_tab_rule_pk
                                        primary key,
    flow_id                         number    not null
                                        constraint wwv_flow_load_tab_rule_fk1
                                        references wwv_flows on delete cascade,
    load_table_id                   number    not null
                                        constraint wwv_flow_load_tab_rule_fk2
                                        references wwv_flow_load_tables on delete cascade,
    load_column_name                varchar2(255)   not null,
    rule_name                       varchar2(255)   not null,
    rule_type                       varchar2(255)
                                        constraint wwv_flow_load_tab_rule_ck1
                                        check (rule_type in (
                                                'TO_UPPER_CASE',
                                                'TO_LOWER_CASE',
                                                'REPLACE',
                                                'TRIM','LTRIM','RTRIM',
                                                'SINGLE_WHITESPACES',
                                                'PLSQL_EXPRESSION',
                                                'REGULAR_EXPRESSION',
                                                'PLSQL_FUNCTION_BODY',
                                                'SQL_QUERY_SINGLE_VALUE',
                                                'SQL_QUERY_SEMI_COLON' )) not null,
    rule_sequence                   number   not null,
    rule_expression1                varchar2(4000),
    rule_expression2                varchar2(4000),
    error_message                   varchar2(4000),
    security_group_id               number          not null,
    created_by                      varchar2(255),
    created_on                      date,
    last_updated_by                 varchar2(255),
    last_updated_on                 date )
/

alter table wwv_flow_load_table_rules
    add constraint wwv_flow_load_tab_rule_uk1 unique (load_table_id, load_column_name, rule_name)
/
create index wwv_flow_load_tab_rule_idx2 on wwv_flow_load_table_rules (flow_id) compress
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > USER INTERFACE
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > USER INTERFACE

--==============================================================================
create table wwv_flow_user_interfaces (
    id                           number         not null
                                                constraint wwv_flow_ui_pk
                                                primary key,
    flow_id                      number         not null
                                                constraint wwv_flow_ui_flow_fk
                                                references wwv_flows on delete cascade,
    ui_type_id                   number         not null
                                                constraint wwv_flow_ui_type_fk
                                                references wwv_flow_ui_types,
    display_name                 varchar2(30)   not null, /* used for our switch placeholder -> #APEX_SWITCH_UI_[SMARTPHONE]# and on the auto detection page */
    display_seq                  number         not null,
    use_auto_detect              varchar2(1)    not null
                                                constraint wwv_flow_ui_use_auto_detect_ck
                                                   check ( use_auto_detect in ('Y', 'N' ) ),
    is_default                   varchar2(1)    not null  /* Default user interface if not other UI is detected by the auto detect */
                                                constraint wwv_flow_ui_is_default_ck
                                                   check ( is_default in ('Y', 'N' ) ),
    theme_id                     number         not null, /* No FK to be consistent with other tables which are referencing a theme */
    home_url                     varchar2(2000) not null,
    login_url                    varchar2(2000),
    global_page_id               number,        /* FK is created after wwv_flow_steps has been created */
    navigation_list_id           number         constraint wwv_flow_ui_nav_list_fk
                                                references wwv_flow_lists
                                                deferrable initially deferred,
    navigation_list_position     varchar2(20)   constraint wwv_flow_ui_list_position_ck
                                                    check ( navigation_list_position in ('TOP','SIDE') ),
    navigation_list_template_id  number         constraint wwv_flow_ui_list_template_fk
                                                    references wwv_flow_list_templates
                                                    deferrable initially deferred,
    nav_list_template_options    varchar2(255)  default '#DEFAULT#',
    content_delivery_network     varchar2(20)   constraint wwv_flow_ui_cdn_ck
                                                   check ( content_delivery_network in ('GOOGLE', 'MICROSOFT', 'JQUERY') ),
    javascript_file_urls         varchar2(4000),
    css_file_urls                varchar2(4000),
    include_legacy_javascript    varchar2(255),
    include_jquery_migrate       varchar2(1)    default 'Y' not null -- Set default to Y so that during migration of schema existing apps include jQuery migrate
                                                constraint wwv_flow_ui_inc_jq_migr_ck
                                                   check (include_jquery_migrate in ( 'Y', 'N' )),
    required_patch               number,
    --
    nav_bar_type                 varchar2(20)   default 'NAVBAR' not null
                                                constraint wwv_flow_ui_nav_position_ck
                                                    check (nav_bar_type in ('NAVBAR','LIST')),
    nav_bar_list_id              number         constraint wwv_flow_ui_navbar_list_fk
                                                    references wwv_flow_lists
                                                    deferrable initially deferred,
    nav_bar_list_template_id     number         constraint wwv_flow_ui_navbar_temp_fk
                                                    references wwv_flow_list_templates
                                                    deferrable initially deferred,
    nav_bar_template_options     varchar2(255)  default '#DEFAULT#',
    --
    theme_style_by_user_pref     varchar2(1)    default 'N' not null
                                                constraint wwv_flow_ui_thesty_usrpref_ck
                                                    check ( theme_style_by_user_pref in ('Y', 'N') ),
    built_with_love              varchar2(1)    default 'Y' not null
                                                constraint wwv_flow_ui_built_with_love_ck
                                                    check ( built_with_love in ('Y', 'N') ),
    --
    security_group_id            number         not null,
    created_by                   varchar2(255),
    created_on                   date,
    last_updated_by              varchar2(255),
    last_updated_on              date
    );

alter table wwv_flow_user_interfaces add constraint wwv_flow_user_int_type_uk unique (flow_id, ui_type_id)
/

create unique index wwv_flow_user_int_idx1 on wwv_flow_user_interfaces (flow_id, display_name)
/

create index wwv_flow_user_int_idx2 on wwv_flow_user_interfaces (ui_type_id)
/

create index wwv_flow_user_int_idx3 on wwv_flow_user_interfaces (required_patch)
/

create index wwv_flow_user_int_idx4 on wwv_flow_user_interfaces (flow_id, global_page_id)
/

create index wwv_flow_user_int_idx5 on wwv_flow_user_interfaces (navigation_list_id)
/

create index wwv_flow_user_int_idx6 on wwv_flow_user_interfaces( navigation_list_template_id )
/

create index wwv_flow_user_int_idx7 on wwv_flow_user_interfaces (nav_bar_list_id)
/

create index wwv_flow_user_int_idx8 on wwv_flow_user_interfaces( nav_bar_list_template_id )
/

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > USER INTERFACE > COMBINED FILES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > USER INTERFACE > COMBINED FILES

--==============================================================================
create table wwv_flow_combined_files (
    id                        number         not null
                                             constraint wwv_flow_combined_files_pk
                                             primary key,
    flow_id                   number         not null
                                             constraint wwv_flow_comb_files_flow_fk
                                             references wwv_flows on delete cascade,
    user_interface_id         number         not null
                                             constraint wwv_flow_comb_files_ui_fk
                                             references wwv_flow_user_interfaces on delete cascade,
    page_id                   number,        /* FK is created after wwv_flow_steps has been created */
    combined_file_url         varchar2(255)  not null,
    single_file_urls          varchar2(4000) not null,
    required_patch            number,
    security_group_id         number         not null,
    created_by                varchar2(255),
    created_on                date,
    last_updated_by           varchar2(255),
    last_updated_on           date
  );

alter table wwv_flow_combined_files
  add constraint wwv_flow_combined_files_uk unique (user_interface_id, combined_file_url, page_id);

create index wwv_flow_combined_files_idx1 on wwv_flow_combined_files (flow_id, user_interface_id, page_id);
create index wwv_flow_combined_files_idx2 on wwv_flow_combined_files (security_group_id);
create index wwv_flow_combined_files_idx3 on wwv_flow_combined_files (required_patch);
create index wwv_flow_combined_files_idx4 on wwv_flow_combined_files (flow_id, page_id);


--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > APPLICATION SETTINGS
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > APPLICATION SETTINGS

--==============================================================================
create table wwv_flow_app_settings (
    id                             number not null
                                   constraint wwv_flow_appset_pk primary key,
    security_group_id              number not null
                                   constraint wwv_flow_appset_sgid_fk
                                   references wwv_flow_companies( provisioning_company_id )
                                   on delete cascade,
    flow_id                        number not null
                                   constraint wwv_flow_appset_app_fk
                                   references wwv_flows
                                   on delete cascade,
    required_patch                 number,
    name                           varchar2(255) not null,
    value                          varchar2(4000),
    is_required                    varchar2(1) default 'N' not null
                                   constraint wwv_flow_appset_req_ck
                                   check (is_required in ('Y', 'N')),
    valid_values                   varchar2(4000),
    on_upgrade_keep_value          varchar2(1) default 'N' not null
                                   constraint wwv_flow_appset_keep_value_ck check (on_upgrade_keep_value in ('Y', 'N')),
    comments                       varchar2(4000),
    --
    created_on                     date,
    created_by                     varchar2(255),
    last_updated_on                date,
    last_updated_by                varchar2(255)
    )
/

alter table wwv_flow_app_settings add constraint wwv_flow_appset_name_uk unique ( security_group_id, flow_id, name );

create index wwv_flow_app_settings_sgid_fx on wwv_flow_app_settings( security_group_id ) compress;
create index wwv_flow_app_settings_app_fx  on wwv_flow_app_settings( flow_id );

--##############################################################################
--#
--# APPLICATION > SHARED COMPONENTS > EMAIL TEMPLATES
--#
--##############################################################################
prompt APPLICATION > SHARED COMPONENTS > EMAIL TEMPLATES

--==============================================================================
create table wwv_flow_email_templates (
    id                             number not null
                                   constraint wwv_flow_email_templates_pk primary key,
    security_group_id              number not null
                                   constraint wwv_flow_email_temp_sgid_fk
                                   references wwv_flow_companies( provisioning_company_id )
                                   on delete cascade,
    flow_id                        number not null
                                   constraint wwv_flow_email_templates_fk
                                   references wwv_flows
                                   on delete cascade,
    name                           varchar2(255) not null,
    static_id                      varchar2(255) not null,
    comments                       varchar2(4000),
    --
    subject                        varchar2(255) not null,
    --
    text_template                  clob,
    html_template                  clob,
    html_body                      clob  not null,
    html_header                    clob,
    html_footer                    clob,
    --
    created_on                     date,
    created_by                     varchar2(255),
    last_updated_on                date,
    last_updated_by                varchar2(255)
    )
/

alter table wwv_flow_email_templates add constraint wwv_flow_app_eml_temp_name_uk unique ( security_group_id, flow_id, static_id );

create index wwv_flow_app_eml_temp_sgid_fx on wwv_flow_email_templates( security_group_id ) compress;
create index wwv_flow_app_eml_temp_app_fx  on wwv_flow_email_templates( flow_id );

--##############################################################################
--#
--# APPLICATION > PAGE
--#
--##############################################################################
prompt APPLICATION > PAGE

--==============================================================================
create table wwv_flow_steps (
    id                  number,
    flow_id             number not null
                        constraint wwv_flow_step_flow_fk
                        references wwv_flows on delete cascade,
    user_interface_id   number /* $$$ should be not null */
                        constraint wwv_flow_step_ui_fk
                        references wwv_flow_user_interfaces on delete cascade,
    tab_set             varchar2(255),
    name                varchar2(255) not null,
    alias               varchar2(255),
    page_component_map  varchar2(255),
    page_mode           varchar2(20) default 'NORMAL' not null
                        constraint wwv_flow_steps_page_mode
                        check (page_mode in ('NORMAL','MODAL','NON_MODAL')),
    --
    step_title          varchar2(255),
    first_item                varchar2(255)
                              constraint wwv_fsteps_first_item_ck
                              check (first_item in ('NO_FIRST_ITEM', 'AUTO_FIRST_ITEM')),
    include_apex_css_js_yn    varchar2(1),
    welcome_text              varchar2(4000),
    box_welcome_text          varchar2(4000),
    footer_text               varchar2(4000),
    help_text                 clob,
    step_template             number,
    page_css_classes          varchar2(255),
    page_template_options     varchar2(255) default '#DEFAULT#',
    required_role             varchar2(255),
    required_patch            number,
    html_page_header          clob,
    html_page_onload          varchar2(4000),
    javascript_file_urls      varchar2(4000),
    javascript_code           clob,
    javascript_code_onload    clob,
    css_file_urls             varchar2(4000),
    inline_css                clob,
    allow_duplicate_submissions varchar2(1) default 'Y' not null
                              constraint valid_all_dup_page_sub
                              check (allow_duplicate_submissions in (
                              'Y',
                              'N')),
    on_dup_submission_goto_url  varchar2(4000),
    reload_on_submit          varchar2(1) default 'A'
                              constraint wwv_flow_step_reload_submit_ck
                                  check (reload_on_submit in ('A', 'S')), /* A=Always, S=Only for Success, D=On Demand (Future) */
    warn_on_unsaved_changes   varchar2(1) default 'N'
                              constraint wwv_flow_step_warn_unsaved_ck
                              check (warn_on_unsaved_changes in ('Y','N')),
    page_is_public_y_n        varchar2(1) default 'N' not null
                              constraint wwv_flow_pages_pgpub_flag
                              check (page_is_public_y_n in ('Y','N')),
    protection_level          varchar2(1) default 'N' not null
                              constraint valid_fsteps_protection_level
                              check (protection_level in ('N','C','U','D')),
    browser_cache             varchar2(1)
                              constraint wwv_fsteps_ck_browser_cache
                              check (browser_cache in ('Y','N')),
    deep_linking              varchar2(1)
                              constraint wwv_fsteps_ck_deep_linking
                              check (deep_linking in ('Y','N')),
    rejoin_existing_sessions  varchar2(1)
                              constraint wwv_flow_step_rejoin_es_ck
                              check (rejoin_existing_sessions in ('Y', 'P', 'N')),
    security_group_id         number not null,
    error_handling_function   varchar2(255),
    error_notification_text   varchar2(4000),
    autocomplete_on_off       varchar2(3) default 'ON' not null
                              constraint wwv_flow_step_autocomplete_ck
                                  check (autocomplete_on_off in ('ON', 'OFF')),
    page_transition           varchar2(20)
                              constraint wwv_flow_step_page_trans_ck
                                   check ( page_transition in ('NONE', 'FADE', 'POP', 'FLIP', 'TURN', 'FLOW', 'SLIDEFADE', 'SLIDE', 'SLIDEUP', 'SLIDEDOWN') ),
    popup_transition          varchar2(20)
                              constraint wwv_flow_step_popup_trans_ck
                                   check ( popup_transition in ('NONE', 'FADE', 'POP', 'FLIP', 'TURN', 'FLOW', 'SLIDEFADE', 'SLIDE', 'SLIDEUP', 'SLIDEDOWN') ),
    read_only_when_type       varchar2(255),
    read_only_when            varchar2(4000),
    read_only_when2           varchar2(4000),
    --
    cache_mode                varchar2(7) default 'NOCACHE' not null
                              constraint wwv_fsteps_ck_cache_mode
                              check (cache_mode in ('NOCACHE',
                                                    'CACHE',
                                                    'USER',
                                                    'SESSION')),
    cache_timeout_seconds     number,
    cache_when_condition_type varchar2(255),
    cache_when_condition_e1   varchar2(4000),
    cache_when_condition_e2   varchar2(4000),
    --
    dialog_width              varchar2(20),
    dialog_max_width          varchar2(20),
    dialog_height             varchar2(20),
    dialog_title              varchar2(255),
    dialog_attributes         varchar2(255),
    dialog_css_classes        varchar2(255),
    dialog_chained            varchar2(1) default 'Y'
                              constraint wwv_flow_step_chained
                              check (dialog_chained in ('Y','N')),
    --
    overwrite_navigation_list   varchar2(1) default 'N' not null
                                    constraint wwv_flow_step_lst_overwrite
                                    check (overwrite_navigation_list in ('Y','N')),
    navigation_list_id          number
                                     constraint wwv_flow_step_nav_list_fk
                                     references wwv_flow_lists on delete set null,
    navigation_list_template_id number
                                     constraint wwv_flow_step_nav_list_tmpl_fk
                                     references wwv_flow_list_templates on delete set null,
    navigation_list_position    varchar2(20)
                                    constraint wwv_flow_steps_nav_pos_ck
                                    check ( navigation_list_position in ('TOP','SIDE') ),
    nav_list_template_options   varchar2(255 )default '#DEFAULT#',
    --
    created_on                date,
    created_by                varchar2(255),
    --
    last_updated_by           varchar2(255),
    last_updated_on           date,
    --
    page_components_scn       number default 1 not null,
    --
    group_id                  number,
    media_type                varchar2(255),
    page_comment              varchar2(4000),
    --
    -- obsolete, but needed for upgrade
    --
    cache_page_yn             varchar2(1),
    cache_by_user_yn          varchar2(1),
    -- constraints
    constraint wwv_flow_steps_pk primary key (flow_id, id)
    )    lob (html_page_header, javascript_code, javascript_code_onload) store as (cache reads enable storage in row)
/

prompt ...create indexes on wwv_flow_steps table
create unique index wwv_flow_page_id_idx2  on wwv_flow_steps (id, flow_id, security_group_id) compress
/
create index wwv_flow_page_alias_idx1  on wwv_flow_steps (flow_id, alias) compress
/
create index wwv_flow_page_public_idx3  on wwv_flow_steps (flow_id, page_is_public_y_n, id) compress
/
create index wwv_flow_page_protection_idx4  on wwv_flow_steps (flow_id, protection_level, id) compress
/
create index wwv_flow_page_ui_idx5  on wwv_flow_steps (user_interface_id) compress
/
create index wwv_flow_page_nv_lst_idx6  on wwv_flow_steps (navigation_list_id) compress
/
create index wwv_flow_page_nv_lst_tmpl_idx7  on wwv_flow_steps (navigation_list_template_id) compress
/

--==============================================================================
alter table wwv_flow_user_interfaces
  add constraint wwv_flow_user_int_page_fk
      foreign key ( flow_id, global_page_id )
      references wwv_flow_steps (flow_id, id)
      on delete set null
      -- deferrable is necessary for importing an app because user interface rows will be created before pages
      deferrable initially deferred;

alter table wwv_flow_combined_files
  add constraint wwv_flow_comb_file_page_fk
      foreign key ( flow_id, page_id )
      references wwv_flow_steps (flow_id, id)
      -- deferrable is necessary for importing an app because combined files will be created before pages
      on delete cascade deferrable initially deferred;

--==============================================================================
create table wwv_flow_page_groups (
    id                number
                      constraint wwv_flow_page_grp_pk
                      primary key,
    flow_id           number
                      references wwv_flows
                      on delete cascade,
    group_name        varchar2(255) not null,
    group_desc        varchar2(4000),
    security_group_id number not null)
/

create index wwv_flow_page_groups_idx on wwv_flow_page_groups (flow_id)
/

--##############################################################################
--#
--# APPLICATION > PAGE > REGION (GENERIC)
--#
--##############################################################################
prompt APPLICATION > PAGE > REGION (GENERIC)

--==============================================================================
create table wwv_flow_page_plugs (
    id                           number
                                 constraint wwv_flow_page_plugs_pk
                                 primary key,
    flow_id                      number not null
                                 constraint wwv_flow_plug_to_flow_fk
                                 references wwv_flows
                                 on delete cascade,
    page_id                      number,
    plug_name                    varchar2(255) not null,
    region_name                  varchar2(255),
    parent_plug_id               number
                                 constraint wwv_flow_plug_parent_fk
                                 references wwv_flow_page_plugs
                                 on delete cascade deferrable initially deferred,
                                 -- deferrable is necessary for page copy, because the order of the regions is undefined
    filtered_region_id           number
                                 constraint wwv_flow_filter_plug_fk
                                 references wwv_flow_page_plugs
                                 on delete cascade deferrable initially deferred,
    --
    plug_template                number,
    plug_display_sequence        number not null,
    plug_new_grid                varchar2(1) default 'N',
                                 constraint wwv_plug_new_grid
                                 check (plug_new_grid in ('Y', 'N')),
    plug_new_grid_row            varchar2(1) default 'N',
                                 constraint wwv_plug_new_grid_row
                                 check (plug_new_grid_row in ('Y', 'N')),
    plug_new_grid_column         varchar2(1) default 'N',
                                 constraint wwv_plug_new_grid_column
                                 check (plug_new_grid_column in ('Y', 'N')),
    plug_display_column          number
                                 constraint wwv_valid_plug_disp_column
                                 check (plug_display_column between 1 and 99),
    plug_grid_column_span        number
                                 constraint wwv_plug_grid_col_span
                                 check (plug_grid_column_span between 1 and 99),
    plug_grid_column_css_classes varchar2(255),
    plug_display_point           varchar2(255)
                                 constraint wwv_valid_plug_disppoint
                                 check (plug_display_point in (
                                 'REGION_POSITION_01',
                                 'REGION_POSITION_02',
                                 'REGION_POSITION_03',
                                 'REGION_POSITION_04',
                                 'REGION_POSITION_05',
                                 'REGION_POSITION_06',
                                 'REGION_POSITION_07',
                                 'REGION_POSITION_08',
                                 'REGION_POSITION_09',
                                 'REGION_POSITION_10',
                                 'REGION_POSITION_11',
                                 'REGION_POSITION_12',
                                 'REGION_POSITION_13',
                                 'REGION_POSITION_14',
                                 'REGION_POSITION_15',
                                 'REGION_POSITION_16',
                                 'REGION_POSITION_17',
                                 'REGION_POSITION_18',
                                 'REGION_POSITION_19',
                                 'REGION_POSITION_20',
                                 'REGION_POSITION_21',
                                 'REGION_POSITION_22',
                                 'REGION_POSITION_23',
                                 'REGION_POSITION_24',
                                 'REGION_POSITION_25',
                                 'REGION_POSITION_26',
                                 'REGION_POSITION_27',
                                 'REGION_POSITION_28',
                                 'REGION_POSITION_29',
                                 'REGION_POSITION_30',
                                 'AFTER_HEADER',
                                 'BODY',
                                 'BODY_1',
                                 'BODY_2',
                                 'BODY_3',
                                 'BEFORE_FOOTER',
                                 -- obsolete but required for migration
                                 'BEFORE_BOX_BODY',
                                 'BEFORE_SHOW_ITEMS',
                                 'AFTER_SHOW_ITEMS')),
    plug_item_display_point      varchar2(5) default 'ABOVE' not null
                                 constraint wwv_plug_item_disp_point
                                 check (plug_item_display_point in ('ABOVE', 'BELOW')),
    --
    plug_source_type             varchar2(255) not null
                                 constraint wwv_flow_page_plugs_ck_srctype
                                 check (substr(plug_source_type,1,7) in ('NATIVE_','PLUGIN_')),
    --
    location                     varchar2(10)
                                 constraint wwv_plug_location_ck
                                 check (location in ('LOCAL', 'REMOTE', 'WEB_SOURCE' )),
    remote_server_id             number
                                 constraint wwv_plug_remote_server_fk
                                 references wwv_remote_servers,
    web_src_module_id            number
                                 constraint wwv_plug_web_src_module_fk
                                 references wwv_flow_web_src_modules,
    query_type                   varchar2(23)
                                 constraint wwv_plug_query_type_ck
                                 check (query_type in ('TABLE', 'SQL', 'FUNC_BODY_RETURNING_SQL' )),
    plug_source                  clob,
    query_owner                  varchar2(128),
    query_table                  varchar2(128),
    query_where                  varchar2(4000),
    query_order_by               varchar2(255),
    source_post_processing       varchar2(23)
                                 constraint wwv_plug_src_post_proc_ck
                                 check ( source_post_processing in ( 'WHERE_ORDER_BY_CLAUSE', 'SQL', 'FUNC_BODY_RETURNING_SQL' )),
    --
    include_rowid_column         varchar2(1)
                                 constraint wwv_plug_incl_rowid_ck
                                 check (include_rowid_column in ('Y','N')),
    optimizer_hint               varchar2(255),
    --
    remote_sql_caching           varchar2(9)
                                 constraint wwv_plug_remote_sql_caching_ck
                                 check (remote_sql_caching in ('ALL_USERS', 'USER', 'SESSION')),
    remote_sql_invalidate_when   varchar2(255),
    --
    external_filter_expr         varchar2(4000),
    external_order_by_expr       varchar2(255),
    -- Standard Attributes for editable regions
    is_editable                  varchar2(1),
                                 constraint wwv_plug_is_editable_ck
                                 check ( is_editable in ( 'Y', 'N' )),
    edit_operations              varchar2(5)
                                 constraint wwv_plug_edit_operations_ck
                                 check ( regexp_instr( edit_operations, '[^iud:]+') = 0 ), /* only allow i, u, d, : */
    edit_row_operations_column   varchar2(128),
    add_authorization_scheme     varchar2(40),
    update_authorization_scheme  varchar2(40),
    delete_authorization_scheme  varchar2(40),
    lost_update_check_type       varchar2(6)
                                 constraint wwv_plug_lost_update_type_ck
                                 check ( lost_update_check_type in ( 'VALUES', 'COLUMN' )),
    row_version_column           varchar2(128),
    add_row_if_empty             varchar2(1)
                                 constraint wwv_plug_add_row_if_empty_ck
                                 check ( add_row_if_empty in ( 'Y', 'N' )),
    lazy_loading                 varchar2(1),
                                 constraint wwv_plug_lazy_loading_ck
                                 check ( lazy_loading in ( 'Y', 'N' )),
    --
    menu_id                      number
                                 constraint wwv_flow_plug_menu_fk
                                 references wwv_flow_menus(id)
                                 deferrable initially deferred,
    list_id                      number
                                 constraint wwv_flow_plug_list_fk
                                 references wwv_flow_lists(id)
                                 deferrable initially deferred,
    menu_template_id             number,
    list_template_id             number,
    -- Master - Detail Relationship
    master_region_id             number
                                 constraint wwv_flow_page_plugs_master_fk
                                 references wwv_flow_page_plugs
                                 deferrable initially deferred,
    --
    include_in_reg_disp_sel_yn   varchar2(1) not null
                                 constraint wwv_plug_incl_reg_disp_sel_ck
                                 check (include_in_reg_disp_sel_yn in ('Y','N')),
    --
    plug_required_role           varchar2(255),
    plug_display_condition_type  varchar2(255),
    plug_display_when_condition  varchar2(4000),
    plug_display_when_cond2      varchar2(4000),
    --
    plug_read_only_when_type     varchar2(255),
    plug_read_only_when          varchar2(4000),
    plug_read_only_when2         varchar2(4000),
    --
    plug_header                  varchar2(4000),
    plug_footer                  varchar2(4000),
    region_image                 varchar2(255),
    region_image_attr            varchar2(255),
    escape_on_http_output        varchar2(1) default 'Y'
                                 constraint wwv_plug_escape_on_http_outp
                                 check (escape_on_http_output in ('Y','N')),
    --
    plug_query_parse_override    varchar2(255),
    plug_query_row_template      number,
    plug_query_headings          varchar2(4000),
    plug_query_headings_type     varchar2(255)
                                 constraint wwv_plug_head_type_check
                                 check (plug_query_headings_type in (
                                 'NO_HEADINGS',
                                 'SORT_ENABLED_COLON_DELMITED_LIST',
                                 'SORT_ENABLED_QUERY_COLUMNS',
                                 'SORT_ENABLED_QUERY_COLUMNS_INITCAP',
                                 'COLON_DELMITED_LIST',
                                 'COLON_DELIMITED_LIST',
                                 'PIPE_DELMITED_LIST',
                                 'BACKSLASH_DELMITED_LIST',
                                 'QUERY_COLUMNS',
                                 'QUERY_COLUMNS_INITCAP',
                                 'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
                                 'FUNCTION_BODY_RETURNING_PIPE_DELIMITED_LIST')),
    plug_query_num_rows          number,
    plug_query_num_rows_type     varchar2(255)
                                 constraint wwv_plug_query_num_rows_type
                                 check (plug_query_num_rows_type in (
                                 'NEXT_PREVIOUS_LINKS',
                                 'COMPUTED_BUT_NOT_DISPLAYED',
                                 'ROW_RANGES',
                                 'ROW_RANGES_RIGHT',
                                 'ROW_RANGES_WITH_LINKS_RIGHT',
                                 'ROW_RANGES_WITH_LINKS',
                                 'ROW_RANGES_IN_SELECT_LIST',
                                 'ROW_RANGES_IN_SELECT_LIST_RIGHT',
                                 'ROWS_PER_PAGE_FROM_ITEM',
                                 'ROWS_X_TO_Y_OF_Z',
                                 'ROWS_X_TO_Y',
                                 'SEARCH_ENGINE',
                                 'SEARCH_ENGINE_RIGHT',
                                 '0'
                                 )),
    pagination_display_position  varchar2(255),
    ajax_enabled                 varchar2(1),
    ajax_items_to_submit         varchar2(4000),
    rest_enabled                 varchar2(1)
                                 constraint wwv_plug_rest_chk
                                 check(rest_enabled in ('Y','N')),
    plug_query_num_rows_item     varchar2(255),
    plug_query_no_data_found     varchar2(4000),
    plug_query_more_data         varchar2(4000),
    plug_query_row_count_max     number,
    --
    plug_query_format_out        varchar2(255),
    plug_query_show_nulls_as     varchar2(255),
    plug_query_col_allignments   varchar2(255),
    plug_query_break_cols        varchar2(255),
    plug_query_sum_cols          varchar2(255),
    plug_query_number_formats    varchar2(4000),
    plug_query_table_border      varchar2(255),
    plug_query_hit_highlighting  varchar2(4000),
    plug_query_asc_image         varchar2(4000),
    plug_query_asc_image_attr    varchar2(4000),
    plug_query_desc_image        varchar2(4000),
    plug_query_desc_image_attr   varchar2(4000),
    --
    plug_query_exp_filename      varchar2(255),
    plug_query_exp_separator     varchar2(1),
    plug_query_exp_enclosed_by   varchar2(1),
    plug_query_strip_html        varchar2(1)
                                 constraint wwv_plug_strip_html
                                 check(plug_query_strip_html in ('Y','N')),
    --
    plug_query_options           varchar2(4000),
    plug_query_max_columns       number,
    plug_column_width            varchar2(255),
    plug_customized              varchar2(255) not null
                                 constraint wwv_plug_plug_customized_ck
                                 check(plug_customized in ('0', '1', '2')),
    plug_customized_name         varchar2(4000),
    plug_override_reg_pos        varchar2(255),
    --
    required_patch               number,
    --
    plug_caching                 varchar2(30) not null
                                 constraint wwv_page_plugs_ck_plug_caching
                                 check (plug_caching in (
                                 'NOCACHE',
                                 'CACHE',
                                 'USER',
                                 'SESSION')),
    plug_cache_when              varchar2(255),
    plug_cache_expression1       varchar2(4000),
    plug_cache_expression2       varchar2(4000),
    plug_caching_max_age_in_sec  number,
    plug_cache_depends_on_items  varchar2(4000),
    plug_ignore_pagination       number,
    --
    plug_chart_font_size         varchar2(255),
    plug_chart_max_rows          number,
    plug_chart_num_mask          varchar2(255),
    plug_chart_scale             varchar2(255),
    plug_chart_axis              varchar2(255),
    plug_chart_show_summary      varchar2(255),
    --
    report_total_text_format    varchar2(4000),
    break_column_text_format    varchar2(4000),
    break_before_row            varchar2(4000),
    break_generic_column        varchar2(4000),
    break_after_row             varchar2(4000),
    break_type_flag             varchar2(255)
                                constraint wwv_break_flag_cc
                                check(break_type_flag in (
                                'REPEAT_HEADINGS_ON_BREAK_1',
                                'DEFAULT_BREAK_FORMATTING')),
    break_repeat_heading_format varchar2(4000),
    csv_output                   varchar2(1)
                                 constraint wwv_csv_output_flag_ck
                                 check(csv_output in ('Y','N')),
    csv_output_link_text         varchar2(4000),
    supplemental_text            varchar2(4000),
    print_url                    varchar2(4000),
    print_url_label              varchar2(4000),
    --
    prn_output                   varchar2(1) constraint plug_prn_output
                                     check (prn_output in ('Y','N')),
    prn_print_server_overwrite   varchar2(4000),
    prn_template_id              number,
    prn_format                   varchar2(255) constraint plug_prn_format
                                     check (prn_format in (
                                          'PDF',
                                          'RTF',
                                          'XLS',
                                          'HTM',
                                          'XML'
                                      )),
    prn_format_item              varchar2(4000),
    prn_output_show_link         varchar2(1)
                                     constraint plug_prn_show_link
                                         check(prn_output_show_link in ('Y','N')),
    prn_output_link_text         varchar2(4000),
    prn_output_file_name         varchar2(4000),
    prn_content_disposition      varchar2(255) constraint plug_prn_content_disp
                                     check (prn_content_disposition in (
                                         'INLINE',
                                         'ATTACHMENT'
                                     )),
    prn_document_header          varchar2(255) constraint plug_prn_doc_header
                                     check (prn_document_header in (
                                         'SERVER',
                                         'APEX'
                                     )),
    prn_units                    varchar2(4000) constraint plug_prn_units
                                     check (prn_units in (
                                         'POINTS',
                                         'INCHES',
                                         'MILLIMETERS',
                                         'CENTIMETERS'
                                     )),
    prn_paper_size               varchar2(4000) constraint plug_prn_paper_size
                                     check (prn_paper_size in (
                                        'CUSTOM',
                                        'LETTER',
                                        'LEGAL',
                                        'TABLOID',
                                        'A4',
                                        'A3'
                                     )),
    prn_width_units              varchar2(255) constraint plug_prn_width_units
                                     check (prn_width_units in (
                                         'PERCENTAGE',
                                         'POINTS'
                                     )),
    prn_width                    number,
    prn_height                   number,
    prn_orientation              varchar2(4000) constraint plug_prn_orientation
                                     check (prn_orientation in (
                                         'HORIZONTAL',
                                         'VERTICAL'
                                     )),
    prn_page_header              varchar2(4000),
    prn_page_header_alignment    varchar2(255) constraint plug_prn_header_align
                                     check (prn_page_header_alignment in ('LEFT','CENTER','RIGHT')),
    prn_page_header_font_color   varchar2(4000),
    prn_page_header_font_family  varchar2(4000),
    prn_page_header_font_weight  varchar2(4000),
    prn_page_header_font_size    varchar2(4000),
    prn_page_footer              varchar2(4000),
    prn_page_footer_alignment    varchar2(255) constraint plug_prn_footer_align
                                     check (prn_page_footer_alignment in ('LEFT','CENTER','RIGHT')),
    prn_page_footer_font_color   varchar2(4000),
    prn_page_footer_font_family  varchar2(4000),
    prn_page_footer_font_weight  varchar2(4000),
    prn_page_footer_font_size    varchar2(4000),
    prn_header_bg_color          varchar2(4000),
    prn_header_font_color        varchar2(4000),
    prn_header_font_family       varchar2(4000),
    prn_header_font_weight       varchar2(4000),
    prn_header_font_size         varchar2(4000),
    prn_body_bg_color            varchar2(4000),
    prn_body_font_color          varchar2(4000),
    prn_body_font_family         varchar2(4000),
    prn_body_font_weight         varchar2(4000),
    prn_body_font_size           varchar2(4000),
    prn_border_color             varchar2(4000),
    prn_border_width             number,
    --
    shared_query_id              number,
    --
    translate_title              varchar2(1) not null
                                 constraint wwv_translate_title_ck
                                 check(translate_title in ('Y','N')),
    --
    security_group_id            number not null,
    last_updated_by              varchar2(255),
    last_updated_on              date,
    --
    created_by                   varchar2(255),
    created_on                   date,
    plug_comment                 varchar2(4000),
    --
    use_custom_item_layout       varchar2(1),
    custom_item_layout           clob,
    sort_null                    varchar2(1)
                                 constraint wwv_pp_sort_null_ck
                                 check (sort_null in (null,'F','L')),
    region_css_classes           varchar2(255),
    icon_css_classes             varchar2(255),
    region_sub_css_classes       varchar2(255),
    region_template_options      varchar2(255) default '#DEFAULT#',
    component_template_options   varchar2(255) default '#DEFAULT#',
    region_attributes_substitution varchar2(4000),
    report_attributes_substitution varchar2(4000),
    std_rpt_max_query_cost       number,
    fixed_header                 varchar2(6)
                                 constraint wwv_flow_pp_fixed_header_ck
                                 check (fixed_header in (
                                 'NONE',
                                 'PAGE',
                                 'REGION')),
    fixed_header_max_height      number,
    --
    plugin_init_javascript_code  varchar2(4000),
    --
    attribute_01                 varchar2(4000),
    attribute_02                 varchar2(4000),
    attribute_03                 varchar2(4000),
    attribute_04                 varchar2(4000),
    attribute_05                 varchar2(4000),
    attribute_06                 varchar2(4000),
    attribute_07                 varchar2(4000),
    attribute_08                 varchar2(4000),
    attribute_09                 varchar2(4000),
    attribute_10                 varchar2(4000),
    attribute_11                 varchar2(4000),
    attribute_12                 varchar2(4000),
    attribute_13                 varchar2(4000),
    attribute_14                 varchar2(4000),
    attribute_15                 varchar2(4000),
    attribute_16                 varchar2(4000),
    attribute_17                 varchar2(4000),
    attribute_18                 varchar2(4000),
    attribute_19                 varchar2(4000),
    attribute_20                 varchar2(4000),
    attribute_21                 varchar2(4000),
    attribute_22                 varchar2(4000),
    attribute_23                 varchar2(4000),
    attribute_24                 varchar2(4000),
    attribute_25                 varchar2(4000),
    -- obsolete, but needed for upgrade
    plug_url_text_begin          varchar2(4000),
    plug_url_text_end            varchar2(4000),
    -- constraints
    constraint                   wwv_flow_plug_to_page_fk
    foreign key                  (flow_id, page_id) references wwv_flow_steps (flow_id, id) on delete cascade )
    -- storage
    lob (plug_source,custom_item_layout) store as (cache reads enable storage in row)
/

create index wwv_flow_page_plugs_fk_page   on wwv_flow_page_plugs (flow_id, page_id) compress 1;
create index wwv_flow_page_plugs_fk_parent on wwv_flow_page_plugs (parent_plug_id);
create index wwv_flow_page_plugs_fk_remote on wwv_flow_page_plugs (remote_server_id);
create index wwv_flow_page_plugs_fk_menu   on wwv_flow_page_plugs (menu_id);
create index wwv_flow_page_plugs_fk_list   on wwv_flow_page_plugs (list_id);
create index wwv_flow_page_plugs_fk_master on wwv_flow_page_plugs (master_region_id);
create index wwv_flow_page_plugs_fk_sgid   on wwv_flow_page_plugs (security_group_id) compress;

create index wwv_plug_web_src_module_fx    on wwv_flow_page_plugs (web_src_module_id);
create index wwv_flow_page_plugs_fk_filter on wwv_flow_page_plugs (filtered_region_id);

--==============================================================================
create table wwv_flow_page_generic_attr (
    id                           number
                                 constraint wwv_flow_page_generic_pk
                                 primary key,
    region_id                    number not null
                                 constraint wwv_flow_genattr_to_region_fk
                                 references wwv_flow_page_plugs
                                 on delete cascade,
    attribute_id                 number not null,
    security_group_id            number not null,
    attribute_value              clob)
    lob (attribute_value) store as (cache reads enable storage in row)
/

create unique index wwv_flow_page_genattr_idx on wwv_flow_page_generic_attr (region_id,attribute_id)
/
--##############################################################################
--#
--# APPLICATION > PAGE > BUTTON
--#
--##############################################################################
prompt APPLICATION > PAGE > BUTTON

--==============================================================================
create table wwv_flow_step_buttons (
    id                        number
                              constraint wwv_flow_step_buttons_pk
                              primary key,
    flow_id                   number  not null
                              constraint wwv_flow_step_buttons_fk1
                              references wwv_flows
                              on delete cascade,
    flow_step_id              number,
    button_sequence           number not null,
    button_plug_id            number
                              constraint wwv_flow_step_buttons_plug_fk
                              references wwv_flow_page_plugs
                              on delete set null,
    button_name               varchar2(2000) not null,
    button_static_id          varchar2(2000),
    button_template_id        number
                              constraint wwv_flow_step_buttons_templ_fk
                              references wwv_flow_button_templates (id)
                              deferrable initially deferred,
    button_template_options   varchar2(255) default '#DEFAULT#',
    button_is_hot             varchar2(1) default 'N'
                              not null
                              constraint wwv_flow_valid_fbutton_hot
                              check (button_is_hot in ('Y', 'N')),
    button_image_alt          varchar2(2000),
    button_position           varchar2(30) not null
                              constraint wwv_flow_step_buttons_ck_bp
                              check (button_position in (
                              'LEFT_OF_TITLE',
                              'RIGHT_OF_TITLE',
                              'ABOVE_BOX',
                              'TOP',
                              'BOTTOM',
                              'TOP_AND_BOTTOM',
                              'TEMPLATE_DEFAULT',
                              'BELOW_BOX',
                              'REGION_TEMPLATE_CREATE',
                              'REGION_TEMPLATE_CREATE2',
                              'REGION_TEMPLATE_CLOSE',
                              'REGION_TEMPLATE_EXPAND',
                              'REGION_TEMPLATE_EDIT',
                              'REGION_TEMPLATE_NEXT',
                              'REGION_TEMPLATE_PREVIOUS',
                              'REGION_TEMPLATE_CHANGE',
                              'REGION_TEMPLATE_DELETE',
                              'REGION_TEMPLATE_COPY',
                              'REGION_TEMPLATE_HELP',
                              'RIGHT_OF_IR_SEARCH_BAR',
                              'BODY'
                              )),
    button_alignment          varchar2(30)
                              constraint wwv_flow_step_buttons_ck_ba
                              check (button_alignment in (
                              'LEFT',
                              'RIGHT',
                              'CENTER',
                              'LEFT-TOP',
                              'RIGHT-TOP',
                              'CENTER-TOP',
                              'LEFT-BOTTOM',
                              'RIGHT-BOTTOM',
                              'CENTER-BOTTOM',
                              'LEFT-CENTER',
                              'RIGHT-CENTER',
                              'CENTER-CENTER' )),
    button_redirect_url       varchar2(4000),
    button_action             varchar2(13) not null
                              constraint wwv_flow_valid_fbutton_action
                              check (button_action in (
                              'SUBMIT',
                              'REDIRECT_URL',
                              'REDIRECT_PAGE',
                              'REDIRECT_APP',
                              'DEFINED_BY_DA',
                              'RESET',
                              'NEXT_PAGE',
                              'PREVIOUS_PAGE' )),
    button_execute_validations varchar2(1)
                              constraint wwv_flow_valid_fbutton_execval
                              check (button_execute_validations in ('Y', 'N')),
    warn_on_unsaved_changes   varchar2(1) default 'I'
                              constraint step_buttons_warn_unsaved_ck
                              check (warn_on_unsaved_changes = 'I'),
    button_condition          varchar2(4000),
    button_condition2         varchar2(4000),
    button_condition_type     varchar2(255),
    button_css_classes        varchar2(255),
    icon_css_classes          varchar2(255),
    button_cattributes        varchar2(2000),
    database_action           varchar2(30),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    created_by                varchar2(255),
    created_on                date,
    button_comment            varchar2(4000),
    request_source            varchar2(4000),
    request_source_type       varchar2(30)
                              constraint wwv_step_buttons_ck_rst
                              check (request_source_type in (
                              'PREFERENCE',
                              'ALWAYS_NULL',
                              'STATIC',
                              'QUERY',
                              'QUERY_COLON',
                              'ITEM',
                              'FUNCTION',
                              'FUNCTION_BODY',
                              'DB_COLUMN',
                              'PLSQL_ANONYMOUS_BLOCK')),
    pre_element_text          varchar2(4000),
    post_element_text         varchar2(4000),
    grid_new_grid             varchar2(1) default 'N',
                              constraint wwv_flow_step_buttons_ck_ng
                              check (grid_new_grid in ('Y', 'N')),
    grid_new_row              varchar2(1)
                              constraint wwv_flow_step_buttons_ck_bonl
                              check (grid_new_row in (
                              'Y',
                              'N')),
    grid_new_column           varchar2(1)
                              constraint wwv_flow_step_buttons_ck_bonf
                              check (grid_new_column in (
                              'Y',
                              'N')),
    grid_column_span          number,
    grid_row_span             number,
    grid_column               number
                              constraint wwv_step_buttons_grid_ck_gc
                              check (grid_column between 1 and 99),
    grid_column_css_classes   varchar2(255),
    grid_column_attributes    varchar2(4000),
    -- obsolete columns
    button_image              varchar2(2000),
    button_image_attributes   varchar2(500),
    -- constraints
    constraint wwv_flow_step_buttons_fk2
    foreign key (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/

create index wwv_flow_step_buttons_idx1 on wwv_flow_step_buttons (flow_id, flow_step_id) compress;
create index wwv_flow_step_buttons_idx2 on wwv_flow_step_buttons (button_plug_id) compress;
create index wwv_flow_step_buttons_idx3 on wwv_flow_step_buttons (button_template_id) compress;
create index wwv_flow_step_buttons_idx4 on wwv_flow_step_buttons (flow_step_id, flow_id, security_group_id) compress;

--##############################################################################
--#
--# APPLICATION > PAGE > ITEM
--#
--##############################################################################
prompt APPLICATION > PAGE > ITEM

--==============================================================================
create table wwv_flow_step_items (
    id                          number
                                constraint wwv_flow_step_items_pk
                                primary key,
    flow_id                     number  not null
                                constraint wwv_flow_step_items_fk
                                references wwv_flows on
                                delete cascade,
    flow_step_id                number,
    name                        varchar2(255) not null,
    name_length                 number,
    data_type                   varchar2(30)
                                constraint valid_fsitem_datatype
                                check (data_type in ( 'VARCHAR', 'NUMBER', 'DATE')),
    source_data_type            varchar2(30)
                                constraint valid_fsitem_source_datatype
                                check (source_data_type in ( 'VARCHAR2', 'NUMBER', 'DATE',
                                                             'TIMESTAMP', 'TIMESTAMP_TZ', 'TIMESTAMP_LTZ',
                                                             'INTERVAL_D2S', 'INTERVAL_Y2M',
                                                             'CLOB', 'BLOB', 'BFILE', 'ROWID' )),
    is_required                 varchar2(1)
                                constraint wwv_valid_fsitem_is_required
                                check (is_required in ('Y', 'N')),
    is_query_only               varchar2(1) default 'N' not null
                                constraint wwv_valid_fsitem_queryonly
                                check (is_query_only in ('Y', 'N')),
    is_primary_key              varchar2(1) default 'N' not null
                                constraint wwv_valid_fsitem_primarykey
                                check (is_primary_key in ('Y', 'N')),
    standard_validations        varchar2(1)
                                constraint wwv_valid_fsitem_std_val
                                check (standard_validations in ('BROWSER', 'SERVER', 'BROWSER_AND_SERVER', 'NONE')),
    accept_processing           varchar2(30)
                                constraint wwv_valid_fsitem_accpproc
                                check (accept_processing in (
                                'REPLACE_EXISTING',
                                'REPLACE_NULL_VALUES',
                                'RAISE_ERROR_ON_REPLACE',
                                'ADD_TO_EXISTING')),
    item_sequence               number not null,
    item_plug_id                number
                                constraint wwv_flow_step_items_plug_fk
                                references wwv_flow_page_plugs
                                on delete set null,
    item_source_plug_id         number
                                constraint wwv_flow_step_items_srcplug_fk
                                references wwv_flow_page_plugs
                                on delete set null,
    use_cache_before_default    varchar2(30)
                                constraint wwv_valid_fsitem_usecache
                                check (use_cache_before_default in (
                                'YES',
                                'NO')),
    item_default                varchar2(4000),
    item_default_type           varchar2(255)
                                constraint wwv_valid_fsitem_idt
                                check (item_default_type in (
                                'STATIC_TEXT_WITH_SUBSTITUTIONS',
                                'ITEM',
                                'PLSQL_FUNCTION_BODY',
                                'PLSQL_EXPRESSION',
                                'SQL_QUERY',
                                'SQL_QUERY_COLON',
                                'SEQUENCE')),
    prompt                      varchar2(4000),
    placeholder                 varchar2(255),
    pre_element_text            varchar2(4000),
    post_element_text           varchar2(4000),
    format_mask                 varchar2(255),
    item_field_template         number,
    item_css_classes            varchar2(255),
    item_template_options       varchar2(255) default '#DEFAULT#',
    item_icon_css_classes       varchar2(255),
    source                      varchar2(4000),
    source_type                 varchar2(30)
                                constraint wwv_valid_fsitem_sourcetype
                                check (source_type in (
                                    'PREFERENCE',
                                    'ALWAYS_NULL',
                                    'STATIC',
                                    'QUERY',
                                    'QUERY_COLON',
                                    'ITEM',
                                    'FUNCTION',
                                    'FUNCTION_BODY',
                                    'DB_COLUMN',
                                    'REGION_SOURCE_COLUMN',
                                    'PLSQL_ANONYMOUS_BLOCK',
                                    'FACET_COLUMN')),
    source_post_computation     varchar2(4000),
    display_as                  varchar2(255) not null
                                constraint wwv_valid_fsitem_displayas
                                check (display_as in (
                                    'DISPLAY_ONLY_PLSQL',
                                    'FILE',
                                    'BUTTON',
                                    'HIDDEN',
                                    'HIDDEN_PROTECTED',
                                    'DISPLAY_ONLY_HTML',
                                    'STOP_AND_START_HTML_TABLE',
                                    'DISPLAY_ONLY_ESCAPE_SC',
                                    'IMAGE',
                                    'DISPLAY_AND_SAVE',
                                    'DISPLAY_AND_SAVE_LOV',
                                    'CHECKBOX',
                                    'POPUP',
                                    'POPUP_FILTER',
                                    'POPUP2',
                                    'POPUP3',
                                    'POPUP4',
                                    'POPUP5',
                                    'POPUP6',
                                    'POPUP_KEY_LOV',
                                    'POPUP_KEY_LOV_NOFETCH',
                                    'POPUP_COLOR',
                                    'PICK_DATE_USING_FLOW_FORMAT_MASK',
                                    'PICK_DATE_USING_APP_FORMAT_MASK',
                                    'PICK_DATE_USING_APP_DATE_FORMAT',
                                    'PICK_DATE_USING_FORMAT_MASK',
                                    'PICK_DATE_DD_MON_RR',
                                    'PICK_DATE_DD_MON_RR_HH_MI',
                                    'PICK_DATE_DD_MON_RR_HH24_MI',
                                    'PICK_DATE_DD_MON_YYYY',
                                    'PICK_DATE_DD_MON_YYYY_HH_MI',
                                    'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                    'PICK_DATE_DD_MM_YYYY',
                                    'PICK_DATE_DD_MM_YYYY_HH_MI',
                                    'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                    'PICK_DATE_MM_DD_YYYY',
                                    'PICK_DATE_MM_DD_YYYY_HH_MI',
                                    'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                    'PICK_DATE_DD_MON_YY',
                                    'PICK_DATE_DD_MON_YY_HH_MI',
                                    'PICK_DATE_DD_MON_YY_HH24_MI',
                                    'PICK_DATE_YYYY_MM_DD',
                                    'PICK_DATE_YYYY_MM_DD_HH_MI',
                                    'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                    'PICK_DATE_RR_MON_DD',
                                    'PICK_DATE_RR_MON_DD_HH_MI',
                                    'PICK_DATE_RR_MON_DD_HH24_MI',
                                    'PICK_DATE_DD_MM_YYYY_DASH',
                                    'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                    'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                    'PICK_DATE_DD_MM_YYYY_DOT',
                                    'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                    'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                    'PICK_DATE_YYYY_DD_MM_DOT',
                                    'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                    'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                    'PICK_DATE_YYYY_MM_DD_SLASH',
                                    'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                    'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                    'DISPLAY_ONLY_LOV',
                                    'COMBOBOX',
                                    'SHOW_AS_SL_WITH_POPUP',
                                    'COMBOBOX_WITH_URL_REDIRECT',
                                    'COMBOBOX_WITH_BRANCH_TO_PAGE',
                                    'COMBOBOX_WITH_SUBMIT',
                                    'COMBOBOX_WITH_JS_POST',
                                    'COMBOBOX_WITH_JS_REDIRECT',
                                    'MULTIPLESELECT',
                                    'SHUTTLE',
                                    'RADIOGROUP',
                                    'RADIOGROUP2',
                                    'RADIOGROUP_WITH_REDIRECT',
                                    'RADIOGROUP_WITH_SUBMIT',
                                    'RADIOGROUP_WITH_JS_SUBMIT',
                                    'TEXTAREA',
                                    'TEXTAREA_WITH_SPELL_CHECK',
                                    'TEXTAREA-AUTO-HEIGHT',
                                    'TEXTAREA_WITH_CONTROLS',
                                    'TEXTAREA_WITH_HTML_EDITOR_BASIC',
                                    'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
                                    'TEXTAREA_CHAR_COUNT',
                                    'TEXTAREA_CHAR_COUNT_SPELL',
                                    'TEXT',
                                    'TEXT_WITH_ENTER_SUBMIT',
                                    'TEXT_DISABLED',
                                    'TEXT_DISABLED_AND_SAVE',
                                    'TEXT_WITH_CALCULATOR',
                                    'PASSWORD',
                                    'PASSWORD_WITH_ENTER_SUBMIT',
                                    'PASSWORD_DNSS',
                                    'PASSWORD_WITH_SUBMIT_DNSS',
                                    'LIST_MGR',
                                    'LIST_MGR2',
                                    'LIST_MGR3',
                                    'LIST_MGR_VIEW',
                                    'LIST_MGR_VIEW2',
                                    -- 4.0
                                    'SELECT_LIST_WITH_POPUP',
                                    'TEXT_WITH_SELECT_LIST',
                                    'TEXTAREA_WITH_POPUP',
                                    'TEXTAREA_RESIZABLE'
                                    ) or
                                    display_as like 'NATIVE\_%' ESCAPE '\' or
                                    display_as like 'PLUGIN\_%' ESCAPE '\'),
    read_only_when_type         varchar2(255),
    read_only_when              varchar2(4000),
    read_only_when2             varchar2(4000),
    read_only_disp_attr         varchar2(4000),
    named_lov                   varchar2(255),
    lov                         varchar2(4000),
    lov_columns                 number, /* deprecated */
    lov_display_extra           varchar2(30)
                                constraint valid_fsitem_lovextra
                                check (lov_display_extra in (
                                    'YES',
                                    'NO')),
    lov_display_null            varchar2(30)
                                constraint valid_fsitem_lovdispnull
                                check (lov_display_null in (
                                    'YES',
                                    'NO')),
    lov_null_text               varchar2(255),
    lov_null_value              varchar2(255),
    lov_translated              varchar2(1)
                                constraint wwv_valid_lov_trans
                                check (lov_translated in ('Y','N',null)),
    lov_cascade_parent_items    varchar2(255),
    ajax_items_to_submit        varchar2(4000),
    ajax_optimize_refresh       varchar2(1)
                                constraint valid_fsitem_ajax_opt_refresh
                                check (ajax_optimize_refresh in ('Y','N')),
    cSize                       number,
    cMaxlength                  number,
    cHeight                     number,
    cAttributes                 varchar2(2000),
    cattributes_element         varchar2(4000),
    tag_css_classes             varchar2(255),
    icon_css_classes            varchar2(255),
    tag_attributes              varchar2(2000),
    tag_attributes2             varchar2(4000),
    --
    button_image                varchar2(255),
    button_image_attr           varchar2(255),
    --
    new_grid                    varchar2(1) default 'N',
                                constraint wwv_step_items_new_grid_ck
                                check (new_grid in ('Y', 'N')),
    begin_on_new_line           varchar2(3) -- keep length of 3 because of migration
                                constraint valid_fsitem_beginonnewline
                                check (begin_on_new_line in (
                                'Y',
                                'N')),
    begin_on_new_field          varchar2(3) -- keep length of 3 because of migration
                                constraint valid_fsitem_beginonnewfield
                                check (begin_on_new_field in (
                                'Y',
                                'N')),
    colspan                     number,
    rowspan                     number,
    grid_column                 number
                                constraint wwv_step_items_grid_col_ck
                                check (grid_column between 1 and 99),
    grid_label_column_span      number
                                constraint wwv_fsitem_label_colspan_ck
                                check (grid_label_column_span between 0 and 99),
    grid_column_css_classes     varchar2(255),
    label_alignment             varchar2(30)
                                constraint valid_fsitem_labelalign
                                check (label_alignment in (
                                    'LEFT',
                                    'RIGHT',
                                    'CENTER',
                                    'ABOVE',
                                    'BELOW',
                                    'LEFT-TOP',
                                    'RIGHT-TOP',
                                    'CENTER-TOP',
                                    'LEFT-BOTTOM',
                                    'RIGHT-BOTTOM',
                                    'CENTER-BOTTOM',
                                    'LEFT-CENTER',
                                    'RIGHT-CENTER',
                                    'CENTER-CENTER'
                                    )),
    field_alignment             varchar2(30)
                                constraint valid_fsitem_fieldalign
                                check (field_alignment in (
                                    'LEFT',
                                    'RIGHT',
                                    'CENTER',
                                    'LEFT-TOP',
                                    'RIGHT-TOP',
                                    'CENTER-TOP',
                                    'LEFT-BOTTOM',
                                    'RIGHT-BOTTOM',
                                    'CENTER-BOTTOM',
                                    'LEFT-CENTER',
                                    'RIGHT-CENTER',
                                    'CENTER-CENTER'
                                    )),
    field_template              number,
    label_cell_attr             varchar2(4000),
    field_cell_attr             varchar2(4000),
    display_when                varchar2(4000),
    display_when2               varchar2(4000),
    display_when_type           varchar2(255),
    --
    warn_on_unsaved_changes     varchar2(1)
                                constraint step_items_warn_unsaved_ck
                                check (warn_on_unsaved_changes = 'I'),
    --
    is_Persistent               varchar2(1)
                                constraint valid_fsitem_ispersistent
                                check (is_Persistent in ('Y','N','U')),
    protection_level            varchar2(1) not null
                                constraint valid_fsitem_protection_level
                                check (protection_level in ('N','B','P','S','I')),
    escape_on_http_input        varchar2(1),
                                constraint valfsitem_escape_on_http_input
                                check (escape_on_http_input in ('Y','N')),
    escape_on_http_output       varchar2(1),
                                constraint valfsitem_escape_on_http_outp
                                check (escape_on_http_output in ('Y','N')),
    restricted_characters       varchar2(20)
                                constraint valfsitem_restricted_chars
                                check (restricted_characters in ('US_ONLY', 'WEB_SAFE', 'NO_SPECIAL_CHAR', 'NO_SPECIAL_CHAR_NL', 'WORKSPACE_SCHEMA')),
    security_scheme             varchar2(255),
    required_patch              number,
    encrypt_session_state_yn    varchar2(1),
    inline_help_text            varchar2(4000),
    show_quick_picks            varchar2(30),
    quick_pick_label_01         varchar2(255),
    quick_pick_value_01         varchar2(255),
    quick_pick_label_02         varchar2(255),
    quick_pick_value_02         varchar2(255),
    quick_pick_label_03         varchar2(255),
    quick_pick_value_03         varchar2(255),
    quick_pick_label_04         varchar2(255),
    quick_pick_value_04         varchar2(255),
    quick_pick_label_05         varchar2(255),
    quick_pick_value_05         varchar2(255),
    quick_pick_label_06         varchar2(255),
    quick_pick_value_06         varchar2(255),
    quick_pick_label_07         varchar2(255),
    quick_pick_value_07         varchar2(255),
    quick_pick_label_08         varchar2(255),
    quick_pick_value_08         varchar2(255),
    quick_pick_label_09         varchar2(255),
    quick_pick_value_09         varchar2(255),
    quick_pick_label_10         varchar2(255),
    quick_pick_value_10         varchar2(255),
    quick_pick_link_attr        varchar2(255),
    --
    plugin_init_javascript_code varchar2(4000),
    --
    attribute_01                varchar2(4000),
    attribute_02                varchar2(4000),
    attribute_03                varchar2(4000),
    attribute_04                varchar2(4000),
    attribute_05                varchar2(4000),
    attribute_06                varchar2(4000),
    attribute_07                varchar2(4000),
    attribute_08                varchar2(4000),
    attribute_09                varchar2(4000),
    attribute_10                varchar2(4000),
    attribute_11                varchar2(4000),
    attribute_12                varchar2(4000),
    attribute_13                varchar2(4000),
    attribute_14                varchar2(4000),
    attribute_15                varchar2(4000),
    -- filter control columns
    fc_max_height               number,
    fc_collapsible              varchar2(1)
                                constraint wwv_valid_fc_collapse
                                check ( fc_collapsible in ('Y', 'N') ),
    fc_initial_collapsed        varchar2(1)
                                constraint wwv_valid_fc_init_collapse
                                check ( fc_initial_collapsed in ('Y', 'N') ),
    fc_compute_counts           varchar2(1)
                                constraint wwv_valid_fc_comp_counts
                                check ( fc_compute_counts in ('Y', 'N') ),
    fc_zero_count_entries       varchar2(1)
                                constraint wwv_valid_fc_zero_count_entr
                                check ( fc_zero_count_entries in ('H', 'D', 'L') ),
    fc_show_selected_first      varchar2(1)
                                constraint wwv_valid_fc_select_first
                                check ( fc_show_selected_first in ('Y', 'N') ),
    fc_show_counts              varchar2(1)
                                constraint wwv_valid_fc_show_counts
                                check ( fc_show_counts in ('Y', 'N') ),
    fc_show_more_count          number,
    fc_filter_values            varchar2(1)
                                constraint wwv_valid_fc_filter_vals
                                check ( fc_filter_values in ('Y', 'N') ),
    --
    -- button columns are obsolete
    --
    button_execute_validations  varchar2(1)
                                constraint wwv_valid_fsitem_b_exec_val
                                check (button_execute_validations in ('Y', 'N')),
    button_redirect_url         varchar2(4000),
    button_action               varchar2(30)
                                constraint wwv_valid_fsitem_b_action
                                check (button_action in (
                                    'SUBMIT',
                                    'REDIRECT_URL',
                                    'REDIRECT_PAGE',
                                    'DEFINED_BY_DA')),
    button_is_hot               varchar2(1)
                                constraint wwv_valid_fsitem_b_hot
                                check (button_is_hot in ('Y', 'N')),
    --
    security_group_id           number not null,
    created_by                  varchar2(255),
    created_on                  date,
    last_updated_by             varchar2(255),
    last_updated_on             date,
    item_comment                varchar2(4000),
    constraint                  wwv_flow_step_items_fk2
    foreign key                 (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade,
    constraint                  wwv_flow_step_items_u_name
                                unique (name, flow_id) deferrable initially deferred using index compress 1
)
/

create index wwv_flow_step_item_idx1 on wwv_flow_step_items (flow_id, flow_step_id, item_sequence) compress 2;
create index wwv_flow_step_item_idx2 on wwv_flow_step_items (item_plug_id) compress;
create unique index wwv_flow_step_item_idx3 on wwv_flow_step_items (flow_id, protection_level, id) compress 2;
create index wwv_flow_step_item_idx4 on wwv_flow_step_items (item_source_plug_id) compress;

--==============================================================================
create table wwv_flow_step_item_help (
    id                        number
                              constraint wwv_flow_page_helptext_pk
                              primary key,
    flow_id                   number  not null
                              constraint wwv_flow_page_helptext_fk
                              references wwv_flows
                              on delete cascade,
    flow_item_id              number
                              constraint wwv_flow_item_helptext_fk
                              references wwv_flow_step_items
                              on delete cascade,
    help_text                 varchar2(4000),
    reference_id              number,
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    item_help_text_comment    varchar2(4000)
    )
/

create unique index wwv_flow_step_item_help_idx on wwv_flow_step_item_help (flow_id, flow_item_id, security_group_id);
create index WWV_FLOW_STEP_ITEM_HELP_FKIDX ON WWV_FLOW_STEP_ITEM_HELP(FLOW_ITEM_ID);

--##############################################################################
--#
--# APPLICATION > PAGE > DYNAMIC ACTIONS
--#
--##############################################################################
prompt APPLICATION > PAGE > DYNAMIC ACTIONS

--==============================================================================
-- table wwv_flow_standard_events to store standard browser events
create table wwv_flow_standard_events (
    id                          number          not null
                                                constraint wwv_flow_std_evnt_pk
                                                primary key,
    name                        varchar2(45)    not null
                                                constraint wwv_flow_std_evnt_name_ck
                                                check (lower(name)=name),
    display_name                varchar2(100)   not null,
    event_type                  varchar2(30)    not null
                                                constraint wwv_flow_std_evnt_type_ck
                                                check (event_type in (
                                                    'BROWSER',
                                                    'APEX',
                                                    'CUSTOM' )),
    supported_ui_types           varchar2(255)  default 'DESKTOP' not null
    );

--unique constraint on name and event type
alter table wwv_flow_standard_events
    add constraint wwv_flow_std_evnt_uk unique (name,event_type);


--==============================================================================
-- table wwv_flow_page_da_events to store triggering events defined on pages in applications.
create table wwv_flow_page_da_events (
    id                          number          not null
                                                constraint wwv_flow_page_da_e_pk
                                                primary key,
    flow_id                     number          not null
                                                constraint wwv_flow_page_da_e_flow_fk
                                                references wwv_flows on delete cascade,
    page_id                     number          not null,
    security_group_id           number          not null,
    name                        varchar2(255)   not null,
    event_sequence              number          not null,
    triggering_element          varchar2(4000),
    triggering_element_type     varchar2(30)    constraint wwv_flow_page_da_e_te_type_ck
                                                check (triggering_element_type in (
                                                    'ITEM',
                                                    'REGION',
                                                    'COLUMN',
                                                    'DOM_OBJECT', -- deprecated
                                                    'JQUERY_SELECTOR',
                                                    'JAVASCRIPT_EXPRESSION',
                                                    'BUTTON' )),
    triggering_region_id        number          constraint wwv_flow_page_da_e_tr_fk
                                                references wwv_flow_page_plugs on delete set null,
    triggering_button_id        number,
    condition_element_type 		varchar2(6)	    constraint wwv_flow_page_da_e_cond_t_ck
    											check (condition_element_type in (
    												'ITEM',
    												'COLUMN')),
    condition_element         	varchar2(4000),
    triggering_condition_type   varchar2(30)    constraint wwv_flow_page_da_e_cond_ck
                                                check (triggering_condition_type in (
                                                    'EQUALS',
                                                    'NOT_EQUALS',
                                                    'GREATER_THAN',
                                                    'GREATER_THAN_OR_EQUAL',
                                                    'LESS_THAN',
                                                    'LESS_THAN_OR_EQUAL',
                                                    'NULL',
                                                    'NOT_NULL',
                                                    'IN_LIST',
                                                    'NOT_IN_LIST',
                                                    'JAVASCRIPT_EXPRESSION')),
    triggering_expression       varchar2(4000),
    bind_type                   varchar2(4)     not null
                                                constraint wwv_flow_page_da_e_type_ck
                                                check (bind_type in (
                                                    'bind',
                                                    'live',
                                                    'one')),
    bind_delegate_to_selector   varchar2(255),
    bind_event_type             varchar2(130)   not null
                                                constraint wwv_flow_page_da_e_btype_ck
                                                check (bind_event_type in (
                                                    'focusout',
                                                    'focusin',
                                                    'load',
                                                    'resize',
                                                    'scroll',
                                                    'unload',
                                                    'click',
                                                    'dblclick',
                                                    'mousedown',
                                                    'mouseup',
                                                    'mousemove',
                                                    'mouseenter',
                                                    'mouseleave',
                                                    'change',
                                                    'select',
                                                    'keydown',
                                                    'keypress',
                                                    'keyup',
                                                    'ready',
                                                    'apexbeforerefresh',
                                                    'apexafterrefresh',
                                                    'apexbeforepagesubmit',
                                                    'apexafterclosedialog',
                                                    'custom',
                                                    'tap',
                                                    'taphold',
                                                    'swipe',
                                                    'swipeleft',
                                                    'swiperight',
                                                    'vmousedown',
                                                    'vmousemove',
                                                    'vmouseup',
                                                    'vclick',
                                                    'vmousecancel',
                                                    'orientationchange',
                                                    'scrollstart',
                                                    'scrollstop',
                                                    'apextap',
                                                    'apexdoubletap',
                                                    'apexpress',
                                                    'apexpan',
                                                    'apexswipe') or
                                                    bind_event_type like 'NATIVE\_%' escape '\' or
                                                    bind_event_type like 'PLUGIN\_%' escape '\'),
    bind_event_type_custom      varchar2(130),
    bind_event_data             varchar2(4000),
    display_when_type           varchar2(255),
    display_when_cond           varchar2(4000),
    display_when_cond2          varchar2(4000),
    required_patch              number,
    security_scheme             varchar2(255),
    da_event_comment            varchar2(4000),
    created_on                  date,
    created_by                  varchar2(255),
    last_updated_on             date,
    last_updated_by             varchar2(255) )
/
-- foreign key constraint for wwv_flow_page_da_events on page and app id to wwv_flow_steps
alter table wwv_flow_page_da_events
      add constraint wwv_flow_page_da_e_page_fk
      foreign key
      (flow_id, page_id) references wwv_flow_steps(flow_id, id)
      on delete cascade
      enable;

create index wwv_flow_page_da_e_region_idx1 on wwv_flow_page_da_events (triggering_region_id);

create index wwv_flow_page_da_e_region_idx2 on wwv_flow_page_da_events (flow_id,page_id);

create index wwv_flow_page_da_e_button_idx1 on wwv_flow_page_da_events (triggering_button_id);


--==============================================================================
-- table wwv_flow_page_da_actions to store actions defined in applications on pages.
create table wwv_flow_page_da_actions (
    id                      number          not null
                                            constraint wwv_flow_page_da_a_pk
                                            primary key,
    event_id                number          not null
                                            constraint wwv_flow_page_da_a_evnt_fk
                                            references wwv_flow_page_da_events on delete cascade,
    flow_id                 number          not null,
    page_id                 number          not null,
    security_group_id       number          not null,
    event_result            varchar2(5)     not null
                                            constraint wwv_flow_page_da_a_er_ck
                                            check (event_result in (
                                                'TRUE',
                                                'FALSE')),
    action_sequence         number          not null,
    execute_on_page_init    varchar2(1)     not null
                                            constraint wwv_flow_page_da_a_on_init_ck
                                            check (execute_on_page_init in (
                                                'Y',
                                                'N' )),
    wait_for_result         varchar2(1)     constraint wwv_flow_page_da_a_wfr_ck
                                            check (wait_for_result in (
                                                'Y',
                                                'N' )),
    name                    varchar2(255),
    action                  varchar2(255)   not null
                                            constraint wwv_flow_page_da_a_action_ck
                                            check (
                                                action like 'NATIVE\_%' escape '\' or
                                                action like 'PLUGIN\_%' escape '\'),
    affected_elements_type  varchar2(30)   constraint wwv_flow_page_da_a_ae_type_ck
                                           check (affected_elements_type in (
                                               'ITEM',
                                               'BUTTON',
                                               'REGION',
                                               'COLUMN',
                                               'DOM_OBJECT', -- deprecated
                                               'JQUERY_SELECTOR',
                                               'JAVASCRIPT_EXPRESSION',
                                               'TRIGGERING_ELEMENT',
                                               'EVENT_SOURCE' )),
    affected_region_id      number         constraint wwv_flow_page_da_a_ar_fk
                                           references wwv_flow_page_plugs on delete set null,
    affected_button_id      number,
    affected_elements       varchar2(4000),
    --
    plugin_init_javascript_code varchar2(4000),
    --additional optional attributes used to store up to 10 additional parameters
    attribute_01            varchar2(4000),
    attribute_02            varchar2(4000),
    attribute_03            varchar2(4000),
    attribute_04            varchar2(4000),
    attribute_05            varchar2(4000),
    attribute_06            varchar2(4000),
    attribute_07            varchar2(4000),
    attribute_08            varchar2(4000),
    attribute_09            varchar2(4000),
    attribute_10            varchar2(4000),
    attribute_11            varchar2(4000),
    attribute_12            varchar2(4000),
    attribute_13            varchar2(4000),
    attribute_14            varchar2(4000),
    attribute_15            varchar2(4000),
    --
    stop_execution_on_error varchar2(1)     constraint wwv_flow_page_da_a_on_err_ck
                                            check (stop_execution_on_error in (
                                                'Y',
                                                'N' )),
    --
    da_action_comment       varchar2(4000),
    --audit
    created_by              varchar2(255),
    created_on              date,
    last_updated_by         varchar2(255),
    last_updated_on         date)
/

-- foreign key constraint for wwv_flow_page_da_actions on page and app id to wwv_flow_steps
alter table wwv_flow_page_da_actions
      add constraint wwv_flow_page_da_a_page_fk
      foreign key
      (flow_id, page_id) references wwv_flow_steps(flow_id, id)
      on delete cascade
      enable;

create index wwv_flow_page_da_a_event_idx1  on wwv_flow_page_da_actions (event_id);
create index wwv_flow_page_da_a_region_idx2 on wwv_flow_page_da_actions (affected_region_id);
create index wwv_flow_page_da_a_page_idx3   on wwv_flow_page_da_actions (flow_id,page_id);
create index wwv_flow_page_da_a_button_idx1 on wwv_flow_page_da_actions (affected_button_id);

--##############################################################################
--#
--# APPLICATION > PAGE > COMPUTATION
--#
--##############################################################################

--==============================================================================
create table wwv_flow_step_computations (
    id                    number
                          constraint wwv_flow_step_comp_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_step_comp_fk
                          references wwv_flows
                          on delete cascade,
    flow_step_id          number ,
    --
    computation_sequence  number        not null,
    computation_item      varchar2(255) not null,
    computation_point     varchar2(255) not null
                          constraint valid_fstepcomp_point
                          check (computation_point in (
                          'ON_NEW_INSTANCE',
                          'BEFORE_HEADER',
                          'AFTER_HEADER',
                          'BEFORE_BOX_BODY',
                          'AFTER_BOX_BODY',
                          'BEFORE_FOOTER',
                          'AFTER_FOOTER',
                          'AFTER_SUBMIT')),
    -- computation_item_type to be obsoleted (SSpadafore)
    computation_item_type varchar2(30)
                          constraint valid_fstepcomp_itemtype
                          check (computation_item_type in (
                          'VARCHAR',
                          'VC_ARR',
                          'NUMBER')),
    computation_type      varchar2(30) not null
                          constraint valid_fstepcomp_comptype
                          check (computation_type in (
                          'SET_ITEM_EQUAL_THIS_PREFERENCE',
                          'STATIC_ASSIGNMENT',
                          'FUNCTION_BODY',
                          'QUERY',
                          'QUERY_COLON',
                          'PLSQL_EXPRESSION',
                          'SQL_EXPRESSION',
                          'SQL_EXPRESION',
                          'ITEM_VALUE')),
    computation_processed varchar2(30)
                          constraint valid_fstepcomp_compproc
                          check (computation_processed in (
                          'ON_NEW_INSTANCE',
                          'REPLACE_EXISTING',
                          'ADD_TO_EXISTING',
                          'RAISE_ERROR_ON_REPLACE',
                          'REPLACE_NULL_VALUES')),
    computation               varchar2(4000),
    compute_when              varchar2(4000),
    compute_when_type         varchar2(255),
    compute_when_text         varchar2(4000),
    computation_error_message varchar2(4000),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    computation_comment       varchar2(4000),
    constraint                wwv_flow_step_comp_fk2
    foreign key               (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/

create unique index WWV_FLOW_STEP_COMPUTATI_FKIDX ON WWV_FLOW_STEP_COMPUTATIONS(FLOW_ID,FLOW_STEP_ID,ID) compress;

--##############################################################################
--#
--# APPLICATION > PAGE > VALIDATION
--#
--##############################################################################

--==============================================================================
-- Validation Types:
--
-- SQL_EXPRESION    &FIELD1 = &FIELD2
--                  &FIELD1 in ('A','B','C')
--                  success if select 1 from sys.dual where SQL_EXPRESION returns a row
-- PLSQL_EXPRESION  1 = my_func(&FIELD1)
--                  since some operations may use impure calls
-- PLSQL_ERROR      declare x number; begin x := &FIELD1; end;
--                  success if plsql does not raise an error
-- EXISTS           select 1 from sys.dual where &FIELD > 1
--                  success if query returns at least one value
--
create table wwv_flow_step_validations (
    id                        number
                              constraint wwv_flow_step_val_pk
                              primary key,
    flow_id                   number not null
                              constraint wwv_flow_step_val_fk
                              references wwv_flows
                              on delete cascade,
    flow_step_id              number,
    reference_id              number,
    tabular_form_region_id    number
                              constraint wwv_flow_step_val_to_reg_fk
                              references wwv_flow_page_plugs
                              on delete cascade,
    validation_name           varchar2(255) not null,
    validation_sequence       number not null,
    validation                varchar2(4000),
    validation2               varchar2(4000),
    validation_type           varchar2(255) not null,
                              constraint wwv_valid_fsval_valtype
                              check (validation_type in (
                              'ITEM_NOT_NULL',
                              'ITEM_NOT_NULL_OR_ZERO',
                              'ITEM_NOT_ZERO',
                              'ITEM_IS_ALPHANUMERIC',
                              'ITEM_IS_NUMERIC',
                              'ITEM_IS_NOT_NUMERIC',
                              'ITEM_IS_DATE',
                              'ITEM_IS_TIMESTAMP',
                              'ITEM_CONTAINS_NO_SPACES',
                              'SQL_EXPRESION',
                              'SQL_EXPRESSION',
                              'PLSQL_EXPRESION',
                              'PLSQL_EXPRESSION',
                              'REGULAR_EXPRESSION',
                              'FUNC_BODY_RETURNING_ERR_TEXT',
                              'FUNC_BODY_RETURNING_BOOLEAN',
                              'PLSQL_ERROR',
                              'NOT_EXISTS',
                              'EXISTS',
                              'ITEM_IN_VALIDATION_IN_STRING2',
                              'ITEM_IN_VALIDATION_NOT_IN_STRING2',
                              'ITEM_IN_VALIDATION_EQ_STRING2',
                              'ITEM_IN_VALIDATION_NOT_EQ_STRING2',
                              'ITEM_IN_VALIDATION_CONTAINS_AT_LEAST_ONE_CHAR_IN_STRING2',
                              'ITEM_IN_VALIDATION_CONTAINS_ONLY_CHAR_IN_STRING2',
                              'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2',
                              'COL_NOT_NULL',
                              'COL_NOT_NULL_OR_ZERO',
                              'COL_NOT_ZERO',
                              'COL_IS_ALPHANUMERIC',
                              'COL_IS_NUMERIC',
                              'COL_IS_NOT_NUMERIC',
                              'COL_IS_DATE',
                              'COL_IS_TIMESTAMP',
                              'COL_CONTAINS_NO_SPACES',
                              'COL_IN_VALIDATION_IN_STRING2',
                              'COL_IN_VALIDATION_NOT_IN_STRING2',
                              'COL_IN_VALIDATION_EQ_STRING2',
                              'COL_IN_VALIDATION_NOT_EQ_STRING2',
                              'COL_IN_VALIDATION_CONTAINS_AT_LEAST_ONE_CHAR_IN_STRING2',
                              'COL_IN_VALIDATION_CONTAINS_ONLY_CHAR_IN_STRING2',
                              'COL_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2'
                              )),
    always_execute            varchar2(1) default 'N' not null
                              constraint wwv_valid_val_exec_val
                              check (always_execute in ('Y', 'N')),
    validation_condition      varchar2(4000),
    validation_condition2     varchar2(4000),
    validation_condition_type varchar2(255),
    exec_cond_for_each_row    varchar2(1)
                              constraint wwv_valid_val_cond_each_row
                              check (exec_cond_for_each_row in ('Y', 'N')),
    when_button_pressed       number,
    only_for_changed_rows     varchar2(1)
                              constraint wwv_valid_val_changed_rows
                              check (only_for_changed_rows in ('Y', 'N')),
    error_message             varchar2(4000),
    associated_item           number,
    associated_column         varchar2(255),
    error_display_location    varchar2(255) not null
                              constraint wwv_valid_val_edl
                              check (error_display_location in (
                              'INLINE_WITH_FIELD',
                              'INLINE_WITH_FIELD_AND_NOTIFICATION',
                              'INLINE_IN_NOTIFICATION',
                              'ON_ERROR_PAGE')),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    -- 4.0
    created_by                varchar2(255),
    created_on                date,
    validation_comment        varchar2(4000),
    bind_01                   varchar2(255),
    bind_02                   varchar2(255),
    bind_03                   varchar2(255),
    bind_04                   varchar2(255),
    bind_05                   varchar2(255),
    bind_06                   varchar2(255),
    constraint                wwv_flow_step_val_fk2
    foreign key               (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/

create index wwv_flow_step_validations_idx3 on wwv_flow_step_validations (tabular_form_region_id);

create unique index wwv_flow_step_validatio_fkidx on wwv_flow_step_validations(flow_id,flow_step_id,id) compress
/

--##############################################################################
--#
--# APPLICATION > PAGE > PROCESS
--#
--##############################################################################

--==============================================================================
create table wwv_flow_step_processing (
    id                      number
                            constraint wwv_flow_step_proc_pk
                            primary key,
    flow_id                 number not null
                            constraint wwv_flow_step_proc_fk
                            references wwv_flows
                            on delete cascade,
    flow_step_id            number,
    --
    process_sequence        number not null,
    process_point           varchar2(255) not null
                            constraint valid_fsproc_point
                            check (process_point in (
                            'ON_NEW_INSTANCE',
                            'ON_SUBMIT_BEFORE_COMPUTATION',
                            'BEFORE_HEADER',
                            'AFTER_HEADER',
                            'BEFORE_BOX_BODY',
                            'BEFORE_SHOW_ITEMS', -- obsolete
                            'AFTER_SHOW_ITEMS', -- obsolete
                            'AFTER_BOX_BODY',
                            'BEFORE_FOOTER',
                            'AFTER_FOOTER',
                            'AFTER_SUBMIT',
                            'AFTER_SUBMIT_BEFORE_VALIDATION',
                            'ON_DEMAND',
                            'AFTER_ERROR_HEADER',
                            'BEFORE_ERROR_FOOTER')),
    region_id               number
                            constraint wwv_flow_step_proc_reg_fk
                            references wwv_flow_page_plugs
                            on delete cascade,
    --
    process_type            varchar2(255) not null
                            constraint wwv_valid_fsproc_type
                            check (   process_type like 'NATIVE\_%' ESCAPE '\'
                                   or process_type like 'PLUGIN\_%' ESCAPE '\'),
    --
    process_name            varchar2(255)  not null,
    process_sql_clob        clob,
    --
    location                varchar2(13)
                            constraint wwv_process_location_ck
                            check (location in ('LOCAL', 'REMOTE', 'WEB_SOURCE', 'REGION_SOURCE' )),
    remote_server_id        number
                            constraint wwv_process_remote_server_fk
                            references wwv_remote_servers,
    web_src_module_id       number
                            constraint wwv_process_websrc_module_fk
                            references wwv_flow_web_src_modules,
    web_src_operation_id    number
                            constraint wwv_process_websrc_opers_fk
                            references wwv_flow_web_src_operations,
    --
    attribute_01            varchar2(4000),
    attribute_02            varchar2(4000),
    attribute_03            varchar2(4000),
    attribute_04            varchar2(4000),
    attribute_05            varchar2(4000),
    attribute_06            varchar2(4000),
    attribute_07            varchar2(4000),
    attribute_08            varchar2(4000),
    attribute_09            varchar2(4000),
    attribute_10            varchar2(4000),
    attribute_11            varchar2(4000),
    attribute_12            varchar2(4000),
    attribute_13            varchar2(4000),
    attribute_14            varchar2(4000),
    attribute_15            varchar2(4000),
    --
    process_error_message   varchar2(4000),
    error_display_location  varchar2(40) default 'ON_ERROR_PAGE' not null
                                        constraint wwv_flow_step_proc_edl
                                        check (error_display_location in ('INLINE_IN_NOTIFICATION', 'ON_ERROR_PAGE')),
    process_when_button_id  number,
    process_when            varchar2(4000),
    process_when_type       varchar2(255),
    process_when2           varchar2(4000),
    exec_cond_for_each_row  varchar2(1)
                            constraint wwv_valid_fsproc_cond_each_row
                            check (exec_cond_for_each_row in ('Y', 'N')),
    only_for_changed_rows   varchar2(1)
                            constraint wwv_valid_fsproc_changed_rows
                            check (only_for_changed_rows in ('Y', 'N')),
    process_when_type2      varchar2(255)
                            constraint valid_fsproc_whentype2
                            check (process_when_type2 in (
                            'CURRENT_PAGE_NOT_IN_CONDITION',
                            'CURRENT_PAGE_IN_CONDITION',
                            'NEVER',
                            'CONDITION_IN_REQUEST',
                            'CONDITION_NOT_IN_REQUEST',
                            'REQUEST_EQUALS_CONDITION',
                            'REQUEST_IN_CONDITION',
                            'REQUEST_NOT_IN_CONDITION',
                            'ITEM_IS_NULL',
                            'ITEM_IS_NOT_NULL',
                            'ITEM_IS_NOT_NULL_OR_ZERO')),
    process_is_stateful_y_n VARCHAR2(1) not null
                            constraint valid_fsproc_stateful
                            check(process_is_stateful_y_n in ('Y','N')),
    --
    process_success_message varchar2(4000),
    required_patch          number,
    security_scheme         varchar2(255),
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date,
    -- 4.0
    created_by              varchar2(255),
    created_on              date,
    process_comment         varchar2(4000),
    --
    -- obsolete columns:
    -- * runtime_where_clause, return_key_into_itemX, item_name were used by
    --   builtin process types before 5.0
    --
    runtime_where_clause    varchar2(4000),
    return_key_into_item1   varchar2(255),
    return_key_into_item2   varchar2(255),
    item_name               varchar2(255),
    --
    -- constraints
    --
    constraint              wwv_flow_step_proc_fk2
    foreign key             (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
    lob (process_sql_clob) store as (cache reads enable storage in row)
/

alter table         wwv_flow_step_processing add constraint wwv_proc_websrc_mod_or_oper_ck
    check ( web_src_module_id is null or web_src_operation_id is null )
/


create index        wwv_flow_step_processing_idx3  on wwv_flow_step_processing (region_id)
/
create unique index wwv_flow_step_processin_fkidx  on wwv_flow_step_processing (flow_id,flow_step_id,id) compress
/
create index        wwv_step_proc_websrc_module_fx on wwv_flow_step_processing (web_src_module_id)       compress
/
create index        wwv_step_proc_websrc_opers_fx  on wwv_flow_step_processing (web_src_operation_id)    compress
/
create index        wwv_step_proc_remote_server_fx on wwv_flow_step_processing (remote_server_id)        compress
/

--==============================================================================
-- web service parameters
create table wwv_flow_ws_process_parms_map (
    id                      number
                            constraint wwv_flow_ws_map_pk
                            primary key,
    parameter_id            number
                            constraint wwv_flows_ws_map_fk1
                            references wwv_flow_ws_parameters
                            on delete cascade,
    process_id              number
                            constraint wwv_flow_ws_map_fk2
                            references wwv_flow_step_processing
                            on delete cascade,
    map_type                varchar2(10)
                            constraint wwv_flow_ws_map_chk
                            check (map_type in ('ITEM','STATIC','FUNCTION','COLLECTION')),
    parm_value              varchar2(4000),
    --
    security_group_id       number not null,
    last_updated_by         varchar2(255),
    last_updated_on         date
    )
/

create index wwv_flow_ws_map_idx1 on wwv_flow_ws_process_parms_map (parameter_id)
/
create index wwv_flow_ws_map_idx2 on wwv_flow_ws_process_parms_map (process_id)
/

--##############################################################################
--#
--# APPLICATION > PAGE > BRANCH
--#
--##############################################################################

--==============================================================================
create table wwv_flow_step_branches (
    id                number
                      constraint wwv_flow_step_branches_pk
                      primary key,
    flow_id           number  not null
                      constraint wwv_flow_step_branches_fk
                      references wwv_flows on delete cascade,
    flow_step_id      number,
    branch_name       varchar2(255),
    branch_action     varchar2(4000),
    branch_point      varchar2(30) not null
                      constraint valid_fsbranch_point
                      check (branch_point in (
                      'BEFORE_HEADER',
                      'BEFORE_COMPUTATION',
                      'BEFORE_VALIDATION',
                      'BEFORE_PROCESSING',
                      'AFTER_PROCESSING')),
    branch_when_button_id number,
    branch_type       varchar2(255) not null
                      constraint valid_fsbranch_branchtype
                      check (branch_type in (
                      'BRANCH_TO_FUNCTION_RETURNING_PAGE',
                      'BRANCH_TO_FUNCTION_RETURNING_URL',
                      'BRANCH_TO_PAGE_IDENT_BY_ITEM',
                      'BRANCH_TO_URL_IDENT_BY_ITEM',
                      'BRANCH_TO_STEP',
                      'BRANCH_TO_PAGE_ACCEPT',
                      'PLSQL',
                      'REDIRECT_URL',
                      'BRANCH_TO_ENTRY_POINT',
                      'BRANCH_TO_ENTRY_POINT_IDENT_BY_ITEM')),
    branch_sequence           number not null,
    clear_page_cache          varchar2(4000),
    save_state_before_branch_yn varchar2(1)
                                constraint wwv_flow_step_branches_svstate
                                check (save_state_before_branch_yn in ('Y','N')),
    branch_condition_type     varchar2(255),
    branch_condition          varchar2(4000),
    branch_condition_text     varchar2(4000),
    required_patch            number,
    security_scheme           varchar2(255),
    security_group_id         number not null,
    last_updated_by           varchar2(255),
    last_updated_on           date,
    -- 4.0
    created_by                 varchar2(255),
    created_on                 date,
    branch_comment            varchar2(4000),
    constraint wwv_flow_step_branches_fk2
    foreign key (flow_id, flow_step_id) references wwv_flow_steps (flow_id, id) on delete cascade)
/

create unique index wwv_flow_step_branches_fkidx on wwv_flow_step_branches(flow_id,flow_step_id,id) compress;

--##############################################################################
--#
--# APPLICATION > PAGE > REGION (TREE)
--#
--##############################################################################
prompt APPLICATION > PAGE > REGION (TREE)

--==============================================================================
create table wwv_flow_tree_regions  (
    id                           number
                                  constraint wwv_flow_treeregion_pk
                                  primary key,
    flow_id                      number not null
                                  constraint wwv_flow_treeregion_fk
                                   references wwv_flows
                                   on delete cascade,
    page_id                      number,
    region_id                    number not null
                                  constraint wwv_flow_treeregion_fk2
                                  references wwv_flow_page_plugs
                                  on delete cascade,
    tree_template                varchar2(255) constraint wwv_tree_templates_con
                                  check (tree_template in (
                                        'classic',
                                        'apple',
                                        'default',
                                        'themeroller'
                                 )),
    tree_source                  varchar2(255),
    tree_query                   varchar2(4000),
    tree_node_title              varchar2(255),
    tree_node_value              varchar2(4000),
    tree_node_icon               varchar2(4000),
    tree_node_link               varchar2(4000),
    tree_node_hints              varchar2(4000),
    tree_start_item              varchar2(255),
    tree_start_value             varchar2(1000),
    tree_button_option           varchar2(1000),
    tree_comment                 varchar2(4000),
    --
    show_hints                   varchar2(20),
    tree_hint_text               varchar2(4000),
    tree_has_focus               varchar2(1),
    tree_click_action            varchar2(1) constraint wwv_tree_click_act
                                  check (tree_click_action in ('S','D')),
    show_node_link               varchar2(1),
    node_link_checksum_type      varchar2(255) constraint wwv_node_link_checksum_type
                                  check (node_link_checksum_type in (
                                    '1', -- workspace
                                    '2', -- user
                                    '3'  -- session
                                 )),
    tree_selected_node           varchar2(255),
    --
    security_group_id            number not null,
    last_updated_by              varchar2(255),
    last_updated_on              date,
    created_by                   varchar2(255),
    created_on                   date
    )
/

create index wwv_flow_treereg_fk1 on wwv_flow_tree_regions (region_id)
/

create index wwv_flow_treereg_fk2 on wwv_flow_tree_regions (flow_id)
/

--==============================================================================
create table wwv_flow_tree_state(
  id         number not null,
  tree_id    number not null,
  expand     clob default empty_clob(),
  contract   clob default empty_clob(),
  constraint wwv_flow_tree_state$pk primary key(id,tree_id),
  constraint wwv_flow_tree_state$fk foreign key(id) references wwv_flow_sessions$(id) on delete cascade)
  lob (expand,contract) store as (cache reads enable storage in row)
/

--##############################################################################
--#
--# APPLICATION > PAGE > REGION (CALENDAR)
--#
--##############################################################################
prompt APPLICATION > PAGE > REGION (CALENDAR)

--==============================================================================
create table wwv_flow_cals (
  id                          number
                              constraint      wwv_flow_cals_pk
                              primary key,
  flow_id                     number          not null
                              constraint      wwv_flow_cal_to_flow_fk
                              references      wwv_flows
                              on delete       cascade,
  plug_id                     number          not null
                              constraint      wwv_flow_plug_calendar_fk
                              references      wwv_flow_page_plugs
                              on delete       cascade,
  start_date                  varchar2(255),
  end_date                    varchar2(255),
  begin_at_start_of_interval  varchar2(1)
                              constraint      wwv_flow_val_calendar_si
                              check           (begin_at_start_of_interval in ('Y','N')),
  date_item                   varchar2(255)   default null,
  end_date_item               varchar2(255)   default null,
  display_as                  varchar2(100),
  display_item                varchar2(255),
  display_type                varchar2(10)
                               constraint      wwv_flow_dis_calendar_typ
                               check           (display_type in ('NONE','COL','CUS')),
  item_format                 varchar2(4000),
  easy_sql_owner              varchar2(255),
  easy_sql_table              varchar2(255),
  date_column                 varchar2(255),
  end_date_column             varchar2(255),
  display_column              varchar2(255),
  start_of_week               number,
  template_id                 number,
  item_link                   varchar2(4000),
  day_link                    varchar2(4000),
  start_time                  number,
  end_time                    number,
  time_format                 varchar2(6)
                              constraint wwv_flow_dis_time_format
                              check(time_format in ('12HOUR','24HOUR') ),
  week_start_day              number,
  week_end_day                number,
  date_type_column            varchar2(255),
  security_group_id           number not null,
  last_updated_by             varchar2(255),
  last_updated_on             date,
  calendar_type               varchar2(1),
  include_custom_cal          varchar2(1),
  custom_cal_days             number default 3,
  primary_key_column          varchar2(255),
  drag_drop_required_role     varchar2(255),
  drag_drop_process_id        number
                              constraint wwv_flow_step_process_fk
                              references wwv_flow_step_processing
                              on delete cascade deferrable initially deferred,
  item_link_open_in           varchar2(1)   default 'W'
                              constraint wwv_flow_item_link_in_ck
                              check (  item_link_open_in in ('W','P')) ,
  data_background_color       varchar2(255),
  data_text_color             varchar2(255),
  item_link_primary_key_item  varchar2(255)    default null,
  item_link_date_item         varchar2(255)    default null,
  include_time_with_date      varchar2(1)      default 'N',
  agenda_cal_days_type        varchar2(10)     default 'MONTH'
                              constraint wwv_flow_agenda_type_in_ck
                              check (  agenda_cal_days_type in ('MONTH','YEAR','CUSTOM')) ,
  agenda_cal_days             number default 30,
  calendar_comments           varchar2(4000)
  )
/

create index wwv_flow_cal_fk_idx1 on wwv_flow_cals (flow_id, security_group_id)
/
create index wwv_flow_cal_fk_idx2 on wwv_flow_cals (plug_id, security_group_id)
/
create index wwv_flow_cal_fk_idx3 on wwv_flow_cals (drag_drop_process_id)
/

create table wwv_flow_region_report_column (
  id                            number          not null
                                constraint report_column_pk
                                primary key,
  region_id                     number          not null
                                constraint report_column_to_region_fk
                                references wwv_flow_page_plugs
                                on delete cascade,
  flow_id                       number,
  query_column_id               number,
  form_element_id               number,
  column_alias                  varchar2(4000)   not null,
  static_id                     varchar2(255),
  column_display_sequence       number           not null,
  column_heading                varchar2(4000),
  use_as_row_header             varchar2(1)
                                constraint wwv_flow_regrepcol_row_hdr
                                check (use_as_row_header in ('Y', 'N')),
  column_format                 varchar2(4000),
  column_html_expression        varchar2(4000),
  column_css_class              varchar2(4000),
  column_css_style              varchar2(4000),
  column_hit_highlight          varchar2(4000),
  column_link                   varchar2(4000),
  column_linktext               varchar2(4000),
  column_link_attr              varchar2(4000),
  column_link_checksum_type     varchar2(255) constraint wwv_regrepcol_checksum_type
                                check (column_link_checksum_type in (
                                '1', -- workspace
                                '2', -- user
                                '3'  -- session
                                )),
  column_alignment              varchar2(4000),
  heading_alignment             varchar2(4000),
  default_sort_column_sequence  number,
  default_sort_dir              varchar2(255),
  disable_sort_column           varchar2(1),
  sum_column                    varchar2(1),
  hidden_column                 varchar2(1),
  display_when_cond_type        varchar2(255),
  display_when_condition        varchar2(4000),
  display_when_condition2       varchar2(4000),
  report_column_required_role   varchar2(255),
  --
  display_as                   varchar2(255)
                               constraint wwv_regrepcol_display_as
                               check ( display_as in (
                               'READONLY',
                               'DISPLAY_AND_SAVE',
                               'WITHOUT_MODIFICATION',
                               'ESCAPE_SC',
                               'TEXT',
                               'TEXT_FROM_LOV',
                               'TEXT_FROM_LOV_ESC',
                               'TEXTAREA',
                               'SELECT_LIST',
                               'SELECT_LIST_FROM_LOV',
                               'SELECT_LIST_FROM_QUERY',
                               'CHECKBOX',
                               'SIMPLE_CHECKBOX',
                               'CHECKBOX_FROM_LOV',
                               'SIMPLE_CHECKBOX',
                               'RADIOGROUP',
                               'RADIOGROUP_FROM_LOV',
                               'RADIOGROUP_FROM_QUERY',
                               'HIDDEN',
                               'HIDDEN_PROTECTED',
                               'POPUP',
                               'POPUP_QUERY',
                               'POPUPKEY',
                               'POPUPKEY_QUERY',
                               'DATE_POPUP',
                               'DATE_PICKER',
                               'PICK_DATE_USING_APP_FORMAT_MASK',
                               'PICK_DATE_USING_APP_DATE_FORMAT',
                               'PICK_DATE_USING_FORMAT_MASK',
                               'PICK_DATE_DD_MON_RR',
                               'PICK_DATE_DD_MON_RR_HH_MI',
                               'PICK_DATE_DD_MON_RR_HH24_MI',
                               'PICK_DATE_DD_MON_YYYY',
                               'PICK_DATE_DD_MON_YYYY_HH_MI',
                               'PICK_DATE_DD_MON_YYYY_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY',
                               'PICK_DATE_DD_MM_YYYY_HH_MI',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI',
                               'PICK_DATE_MM_DD_YYYY',
                               'PICK_DATE_MM_DD_YYYY_HH_MI',
                               'PICK_DATE_MM_DD_YYYY_HH24_MI',
                               'PICK_DATE_DD_MON_YY',
                               'PICK_DATE_DD_MON_YY_HH_MI',
                               'PICK_DATE_DD_MON_YY_HH24_MI',
                               'PICK_DATE_YYYY_MM_DD',
                               'PICK_DATE_YYYY_MM_DD_HH_MI',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI',
                               'PICK_DATE_RR_MON_DD',
                               'PICK_DATE_RR_MON_DD_HH_MI',
                               'PICK_DATE_RR_MON_DD_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                               'PICK_DATE_YYYY_MM_DD_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH'
                               ) or
                               display_as like 'NATIVE\_%' escape '\' or
                               display_as like 'PLUGIN\_%' Escape '\'),
  named_lov                    number,
  inline_lov                   varchar2(4000),
  lov_show_nulls               varchar2(3)
                               constraint wwv_flow_regrepcol_lovn
                               check (lov_show_nulls in (
                               'YES',
                               'NO')),
  lov_null_text                varchar2(255),
  lov_null_value               varchar2(255),
  column_width                 number,
  report_column_width          number,
  column_height                number,
  css_classes                  varchar2(255),
  cattributes                  varchar2(4000),
  cattributes_element          varchar2(4000),
  column_field_template        number,
  --
  attribute_01                 varchar2(4000),
  attribute_02                 varchar2(4000),
  attribute_03                 varchar2(4000),
  attribute_04                 varchar2(4000),
  attribute_05                 varchar2(4000),
  attribute_06                 varchar2(4000),
  attribute_07                 varchar2(4000),
  attribute_08                 varchar2(4000),
  attribute_09                 varchar2(4000),
  attribute_10                 varchar2(4000),
  attribute_11                 varchar2(4000),
  attribute_12                 varchar2(4000),
  attribute_13                 varchar2(4000),
  attribute_14                 varchar2(4000),
  attribute_15                 varchar2(4000),
  --
  is_required                  varchar2(1)
                               constraint wwv_flow_regrepcol_is_required
                               check (is_required in ('Y', 'N')),
  standard_validations         varchar2(1)
                               constraint wwv_flow_regrepcol_std_val
                               check (standard_validations in ('BROWSER', 'SERVER', 'BROWSER_AND_SERVER', 'NONE')),
  --
  pk_col_source_type           varchar2(1)
                                   constraint wwv_flow_regrepcol_src_type
                                   check (pk_col_source_type in (
                                   'S',
                                   'F',
                                   'T')),
  pk_col_source                clob,
  derived_column               varchar2(1)
                                   constraint wwv_flow_regrepcol_derv_col
                                   check (derived_column in (
                                   'Y',
                                   'N')),
  --
  column_default               varchar2(4000),
  column_default_type          varchar2(255),
  lov_display_extra            varchar2(30),
  --
  include_in_export            varchar2(1)
                                   constraint wwv_flow_regrepcol_incl_exp
                                   check (include_in_export in (
                                   'Y',
                                   'N')),
  print_col_width              varchar2(4000),
  print_col_align              varchar2(4000),
  --
  ref_schema                   varchar2(255),
  ref_table_name               varchar2(255),
  ref_column_name              varchar2(255),
  --
  column_comment               varchar2(4000),
  --
  required_patch               number,
  --
  security_group_id            number           not null,
  last_updated_by              varchar2(255),
  last_updated_on              date
) lob (pk_col_source) store as (cache reads enable storage in row)
/

create index wwv_flow_region_report_col_idx on wwv_flow_region_report_column (region_id)
/

create index wwv_flow_region_rpt_col_idx2 on wwv_flow_region_report_column (security_group_id,flow_id)
/

create index wwv_flow_region_rpt_col_idx3 on wwv_flow_region_report_column (named_lov,flow_id)
/

--==============================================================================
-- UPDATEABLE report attributes
create table wwv_flow_region_upd_rpt_cols (
    id                           number
                                 constraint wwv_flow_upd_rpt_col
                                 primary key,
    flow_id                      number not null
                                 constraint wwv_flow_urc_to_flow_fk
                                 references wwv_flows
                                 on delete cascade,
    security_group_id            number not null,
    plug_id                      number not null,
    column_sequence              number not null,
    query_column_name            varchar2(255),
    display_as                   varchar2(255)
                                 constraint wwv_flow_upc_display_as
                                 check ( display_as in (
                                 'DISPLAY_AND_SAVE',
                                 'WITHOUT_MODIFICATION',
                                 'ESCAPE_SC',
                                 'TEXT',
                                 'TEXTAREA',
                                 'SELECT_LIST',
                                 'SELECT_LIST_FROM_LOV',
                                 'SELECT_LIST_FROM_QUERY',
                                 'HIDDEN',
                                 'POPUP',
                                 'DATE_POPUP'
                                 )),
    named_lov                    number,
    inline_lov                   varchar2(4000),
    lov_show_nulls               varchar2(3)
                                 constraint wwv_flow_upd_rpt_cols_lovn
                                 check (lov_show_nulls in (
                                 'YES',
                                 'NO')),
    lov_null_text                varchar2(255),
    lov_null_value               varchar2(255),
    column_width                 number,
    column_height                number,
    cattributes                  varchar2(4000),
    cattributes_element          varchar2(4000),
    column_comment               varchar2(4000),
    constraint                   wwv_flow_region_upd_rpt_u_name
                                 unique (query_column_name, plug_id) deferrable initially deferred using index compress 1
    )
/

create index wwv_flow_region_upd_rpt_ci2 on wwv_flow_region_upd_rpt_cols (plug_id,column_sequence);
create index wwv_flow_region_upd_rpt_ci3 on wwv_flow_region_upd_rpt_cols (flow_id)
/

alter table wwv_flow_region_upd_rpt_cols
    add constraint wwv_flow_urc_to_plug_fk
        foreign key (plug_id)
        references wwv_flow_page_plugs (id)
        on delete cascade
/

--##############################################################################
--#
--# APPLICATION > PAGE > REGION > COLUMNS
--#
--##############################################################################
prompt APPLICATION > PAGE > REGION > COLUMN GROUPS
--==============================================================================
create table wwv_flow_region_column_groups (
  id                     number not null
                             constraint region_col_group_pk primary key,
  flow_id                number not null,
  page_id                number not null,
  region_id              number not null
                             constraint region_col_group_region_fk
                             references wwv_flow_page_plugs on delete cascade,
  security_group_id      number not null,
  --
  heading                varchar2(255) not null,
  label                  varchar2(255),
  --
  last_updated_by        varchar2(255),
  last_updated_on        date
  )
/
alter table wwv_flow_region_column_groups
    add constraint region_col_group_page_fk foreign key ( flow_id, page_id ) references wwv_flow_steps( flow_id, id ) on delete cascade
/
create index region_col_group_page_fx on wwv_flow_region_column_groups ( flow_id, page_id ) compress
/
create index region_col_group_region_fx on wwv_flow_region_column_groups ( region_id ) compress
/


prompt APPLICATION > PAGE > REGION > COLUMNS
--==============================================================================
create table wwv_flow_region_columns (
  id                     number not null
                             constraint region_col_pk primary key,
  flow_id                number not null,
  page_id                number not null,
  region_id              number not null
                             constraint region_col_region_fk
                             references wwv_flow_page_plugs on delete cascade,
  security_group_id      number not null,
  -- Source
  name                   varchar2(128) not null,
  source_type            varchar2(14)
                             constraint region_col_source_type_ck
                             check ( source_type in (
                                         'DB_COLUMN',
                                         'SQL_EXPRESSION',
                                         'NONE' )),
  source_expression      varchar2(4000),
  data_type              varchar2(128),
  is_query_only          varchar2(1)
                             constraint region_col_is_query_only_ck
                             check ( is_query_only in ( 'Y', 'N' )),
  --
  item_type              varchar2(255)
                             constraint region_col_item_type_fk
                             check ( item_type like 'NATIVE\_%' ESCAPE '\' or
                                     item_type like 'PLUGIN\_%' ESCAPE '\' ),
  --
  is_visible             varchar2(1)
                             constraint region_col_is_visible_ck
                             check ( is_visible in ( 'Y', 'N' )),
  -- Heading
  heading                varchar2(255),
  label                  varchar2(255),
  heading_alignment      varchar2(6)
                             constraint region_col_heading_align_ck
                             check ( heading_alignment in (
                                         'LEFT',
                                         'RIGHT',
                                         'CENTER' )),
  -- Layout
  display_sequence       number not null,
  value_alignment        varchar2(6)
                             constraint region_col_value_align_ck
                             check ( value_alignment in (
                                         'LEFT',
                                         'RIGHT',
                                         'CENTER' )),
  value_css_classes      varchar2(255),
  value_attributes       varchar2(255),
  --
  group_id               number
                             constraint region_col_group_fk
                             references wwv_flow_region_column_groups on delete set null,
  use_group_for          varchar2(7)
                             constraint region_col_use_group_for_ck
                             check ( use_group_for in ( 'BOTH', 'SRV', 'HEADING' )),
  stretch                varchar2(1)
                             constraint region_col_stretch_ck
                             check ( stretch in ( 'N', 'A' )),
  -- Plug-in Settings
  plugin_init_javascript_code varchar2(4000),
  --
  attribute_01           varchar2(4000),
  attribute_02           varchar2(4000),
  attribute_03           varchar2(4000),
  attribute_04           varchar2(4000),
  attribute_05           varchar2(4000),
  attribute_06           varchar2(4000),
  attribute_07           varchar2(4000),
  attribute_08           varchar2(4000),
  attribute_09           varchar2(4000),
  attribute_10           varchar2(4000),
  attribute_11           varchar2(4000),
  attribute_12           varchar2(4000),
  attribute_13           varchar2(4000),
  attribute_14           varchar2(4000),
  attribute_15           varchar2(4000),
  attribute_16           varchar2(4000),
  attribute_17           varchar2(4000),
  attribute_18           varchar2(4000),
  attribute_19           varchar2(4000),
  attribute_20           varchar2(4000),
  attribute_21           varchar2(4000),
  attribute_22           varchar2(4000),
  attribute_23           varchar2(4000),
  attribute_24           varchar2(4000),
  attribute_25           varchar2(4000),
  -- Appearance
  format_mask            varchar2(255),
  item_width             number,
  item_height            number,
  item_placeholder       varchar2(255),
  item_css_classes       varchar2(255),
  item_icon_css_classes  varchar2(255),
  item_attributes        varchar2(255),
  -- Validation
  is_required            varchar2(1)
                             constraint region_col_required_ck
                             check ( is_required in ( 'Y', 'N' )),
  max_length             number,
  -- List of Values
  lov_type                 varchar2(19)
                               constraint region_col_lov_type_ck
                               check ( lov_type in ( 'SHARED', 'SQL_QUERY', 'STATIC', 'PLSQL_FUNCTION_BODY' )),
  lov_id                   number
                               constraint region_col_lov_fk
                               references wwv_flow_lists_of_values$,
  lov_source               varchar2(4000),
  lov_display_extra        varchar2(1)
                               constraint region_col_lov_displ_extra_ck
                               check ( lov_display_extra in ( 'Y', 'N' )),
  lov_display_null         varchar2(1)
                               constraint region_col_lov_displ_null_ck
                               check ( lov_display_null in ( 'Y', 'N' )),
  lov_null_text            varchar2(255),
  lov_null_value           varchar2(255),
  lov_cascade_parent_items varchar2(255),
  ajax_items_to_submit     varchar2(4000),
  ajax_optimize_refresh    varchar2(1)
                               constraint region_col_lov_ajax_refresh_ck
                               check ( ajax_optimize_refresh in ( 'Y', 'N' )),
  -- Link
  link_target              varchar2(4000),
  link_text                varchar2(255),
  link_attributes          varchar2(255),
  -- Filter
  enable_filter            varchar2(1)
                               constraint region_col_enable_filter_ck
                               check ( enable_filter in ( 'Y', 'N' )),
  filter_operators         varchar2(255),
  filter_is_required       varchar2(1)
                               constraint region_col_filter_is_req_ck
                               check ( filter_is_required in ( 'Y', 'N' )),
  filter_text_case         varchar2(5)
                               constraint region_col_filter_text_case_ck
                               check ( filter_text_case in ( 'UPPER', 'LOWER', 'MIXED' )),
  filter_exact_match       varchar2(1)
                               constraint region_col_filt_exact_match_ck
                               check ( filter_exact_match in ( 'Y', 'N' )),
  filter_date_ranges       varchar2(6)
                               constraint region_col_filt_date_ranges_ck
                               check ( filter_date_ranges in ( 'ALL', 'PAST', 'FUTURE' )),
  filter_lov_type          varchar2(19)
                               constraint region_col_filter_lov_type_ck
                               check ( filter_lov_type in ( 'NONE', 'DISTINCT', 'SHARED', 'SQL_QUERY', 'STATIC', 'PLSQL_FUNCTION_BODY', 'LOV' )),
  filter_lov_id            number
                               constraint region_col_filter_lov_fk
                               references wwv_flow_lists_of_values$,
  filter_lov_query         varchar2(4000),
  -- Advanced
  static_id                varchar2(255),
  use_as_row_header        varchar2(1)
                               constraint region_col_use_as_row_head_ck
                               check ( use_as_row_header in ( 'Y', 'N' )),
  javascript_code          varchar2(4000),
  -- Enable Users To
  enable_sort_group        varchar2(1)
                               constraint region_col_enable_sort_grp_ck
                               check ( enable_sort_group in ( 'Y', 'N' )),
  enable_control_break     varchar2(1)
                               constraint region_col_enable_ctrl_brk_ck
                               check ( enable_control_break in ( 'Y', 'N' )),
  enable_hide              varchar2(1)
                               constraint region_col_enable_hide_ck
                               check ( enable_hide in ( 'Y', 'N' )),
  enable_pivot             varchar2(1)
                               constraint region_col_enable_pivot_ck
                               check ( enable_pivot in ( 'Y', 'N' )),
  -- Primary Key
  is_primary_key           varchar2(1)
                               constraint region_col_is_primary_key_ck
                               check ( is_primary_key in ( 'Y', 'N' )),
  -- Parent - Child
  parent_column_id         number
                               constraint region_col_parent_column_fk
                               references wwv_flow_region_columns
                               deferrable initially deferred, -- deferrable is necessary for import
  -- Default
  default_type             varchar2(20)
                               constraint region_col_default_type_ck
                               check ( default_type in ( 'STATIC',
                                                         'ITEM',
                                                         'SQL_QUERY',
                                                         'SQL_QUERY_COLON',
                                                         'PLSQL_EXPRESSION',
                                                         'PLSQL_FUNCTION_BODY',
                                                         'SEQUENCE' )),
  default_expression       varchar2(4000),
  duplicate_value          varchar2(1)
                               constraint region_col_duplicate_value_ck
                               check ( duplicate_value in ( 'Y', 'N' )),
  -- Export / Printing
  include_in_export        varchar2(1)
                               constraint region_col_incl_in_export_ck
                               check ( include_in_export in ( 'Y', 'N' )),
  -- Condition
  display_condition_type   varchar2(255),
  display_condition        varchar2(4000),
  display_condition2       varchar2(4000),
  -- Read Only Condition
  readonly_condition_type  varchar2(255),
  readonly_condition       varchar2(4000),
  readonly_condition2      varchar2(4000),
  readonly_for_each_row    varchar2(1)
                               constraint region_col_readonly_for_row_ck
                               check ( readonly_for_each_row in ( 'Y', 'N' )),
  -- Security
  escape_on_http_output    varchar2(1)
                               constraint region_col_escape_ck
                               check ( escape_on_http_output in ( 'Y', 'N' )),
  security_scheme          varchar2(255),
  restricted_characters    varchar2(20)
                               constraint region_col_restricted_char_ck
                               check ( restricted_characters in ( 'US_ONLY', 'WEB_SAFE', 'NO_SPECIAL_CHAR', 'NO_SPECIAL_CHAR_NL', 'WORKSPACE_SCHEMA' )),
  -- Help Text
  help_text                varchar2(4000),
  --
  required_patch           number,
  -- Comment
  column_comment           varchar2(4000),
  -- Audit
  last_updated_by          varchar2(255),
  last_updated_on          date
)
/

-- foreign key constraint for wwv_flow_region_columns on page and app id to wwv_flow_steps
alter table wwv_flow_region_columns
    add constraint region_col_page_fk foreign key ( flow_id, page_id ) references wwv_flow_steps( flow_id, id ) on delete cascade
/
create index region_col_page_fx on wwv_flow_region_columns ( flow_id, page_id ) compress
/
alter table wwv_flow_region_columns
    add constraint region_col_name_uk unique ( region_id, name ) deferrable initially deferred using index compress 1
/
create index region_col_group_fx on wwv_flow_region_columns ( group_id ) compress
/
create index region_col_lov_fx on wwv_flow_region_columns ( lov_id ) compress
/
create index region_col_filter_lov_fx on wwv_flow_region_columns ( filter_lov_id ) compress
/
create index region_col_parent_column_fx on wwv_flow_region_columns ( parent_column_id ) compress
/

--##############################################################################
--#
--# APPLICATION > PAGE > REGION (INTERACTIVE REPORTS - GENERIC)
--#
--##############################################################################
prompt APPLICATION > PAGE > REGION (INTERACTIVE REPORTS - GENERIC)
--==============================================================================
create table wwv_flow_worksheets (
    id                        number not null,
    flow_id                   number not null
                              constraint wwv_flow_worksheets_flow_fk
                              references wwv_flows
                              on delete cascade,
    page_id                   number,
    region_id                 number
                              constraint wwv_flow_worksheets_reg_fk
                              references wwv_flow_page_plugs
                              on delete cascade,
    name                      varchar2(255),
    folder_id                 number,
    alias                     varchar2(255),
    -- view settings
    report_id_item            varchar2(255),
    max_row_count             varchar2(255),
    max_row_count_message     varchar2(4000),
    no_data_found_message     varchar2(4000),
    max_rows_per_page         varchar2(4000),
    search_button_label       varchar2(4000),
    page_items_to_submit      varchar2(4000), /* obsolete, is stored in wwv_flow_page_plugs.ajax_items_to_submit now */
    sort_asc_image            varchar2(4000),
    sort_asc_image_attr       varchar2(4000),
    sort_desc_image           varchar2(4000),
    sort_desc_image_attr      varchar2(4000),
    -- base table
    sql_query                 clob,
    base_table_or_view        varchar2(4000),
    base_pk1                  varchar2(128),
    base_pk2                  varchar2(128),
    base_pk3                  varchar2(128),
    uniquely_identify_rows_by varchar2(6) generated always as (
                                            case
                                              when base_pk1 is not null then 'COLUMN'
                                              else 'ROWID'
                                            end ) virtual,
    sql_hint                  varchar2(4000),
    oracle_text_index_column  varchar2(128),
    -- status
    status                    varchar2(30)
                              constraint wwv_flow_ws_status_ck
                              check (status in (
                              'AVAILABLE_FOR_OWNER',
                              'NOT_AVAILABLE',
                              'AVAILABLE',
                              'ACL')),
    --
    allow_report_saving       varchar2(1)
                              constraint wwv_flow_ws_allow_save_ck
                              check (allow_report_saving in (
                              'Y',
                              'N')),
    allow_save_rpt_public     varchar2(1)
                              constraint wwv_flow_ws_allow_save_pub_ck
                              check (allow_save_rpt_public in (
                              'Y',
                              'N')),
    save_rpt_public_auth_scheme    varchar2(255),
    allow_report_categories   varchar2(1)
                              constraint wwv_flow_ws_allow_cat_ck
                              check (allow_report_categories in (
                              'Y',
                              'N')),
    --
    show_nulls_as             varchar2(255),
    pagination_type           varchar2(255)
                              constraint wwv_flow_ws_pag_type
                              check (pagination_type in (
                              'ROWS_X_TO_Y_OF_Z',
                              'ROWS_X_TO_Y'
                              )),
    pagination_display_position    varchar2(255),
    button_template           number,   -- obsolete
    --
    show_finder_drop_down     varchar2(1) not null
                              constraint wwv_flow_show_fnd_drop_ck
                              check (show_finder_drop_down in (
                              'Y',
                              'N')),
    show_display_row_count    varchar2(1) not null
                              constraint wwv_flow_show_row_cnt_ck
                              check (show_display_row_count in (
                              'Y',
                              'N')),
    show_search_bar           varchar2(1) not null
                              constraint wwv_flow_show_search_bar_ck
                              check (show_search_bar in (
                              'Y',
                              'N')),
    show_search_textbox       varchar2(1) not null
                              constraint wwv_flow_show_search_box_ck
                              check (show_search_textbox in (
                              'Y',
                              'N')),
    show_actions_menu         varchar2(1) not null
                              constraint wwv_flow_show_actions_ck
                              check (show_actions_menu in (
                              'Y',
                              'N')),
    actions_menu_icon         varchar2(4000),      -- obsolete
    finder_icon               varchar2(4000),      -- obsolete
    report_list_mode          varchar2(255)
                              constraint wwv_flow_list_reps_ck
                              check (report_list_mode in (
                              'TABS',
                              'NONE')),
    show_select_columns       varchar2(1) not null
                              constraint wwv_flow_ws_show_col_ck
                              check (show_select_columns in (
                              'Y',
                              'N')),
    show_rows_per_page        varchar2(1) not null
                              constraint wwv_flow_ws_show_rows_ck
                              check (show_rows_per_page in (
                              'Y',
                              'N')),
    show_filter               varchar2(1) not null
                              constraint wwv_flow_ws_show_filter_ck
                              check (show_filter in (
                              'Y',
                              'N')),
    show_sort                 varchar2(1) not null
                              constraint wwv_flow_ws_show_sort_ck
                              check (show_sort in (
                              'Y',
                              'N')),
    show_control_break        varchar2(1) not null
                              constraint wwv_flow_ws_show_break_ck
                              check (show_control_break in (
                              'Y',
                              'N')),
    show_highlight            varchar2(1) not null
                              constraint wwv_flow_ws_show_hl_ck
                              check (show_highlight in (
                              'Y',
                              'N')),
    show_computation          varchar2(1) not null
                              constraint wwv_flow_ws_show_comp_ck
                              check (show_computation in (
                              'Y',
                              'N')),
    show_aggregate            varchar2(1) not null
                              constraint wwv_flow_ws_show_agg_ck
                              check (show_aggregate in (
                              'Y',
                              'N')),
    show_chart                varchar2(1) not null
                              constraint wwv_flow_ws_show_chart_ck
                              check (show_chart in (
                              'Y',
                              'N')),
    show_notify               varchar2(1) not null
                              constraint wwv_flow_ws_show_notify_ck
                              check (show_notify in (
                              'Y',
                              'N')),
    show_group_by             varchar2(1) not null
                              constraint wwv_flow_ws_show_group_by_ck
                              check (show_group_by in (
                              'Y',
                              'N')),
    show_pivot                varchar2(1) default 'N' not null
                              constraint wwv_flow_ws_show_pivot_ck
                              check (show_pivot in (
                              'Y',
                              'N')),
    show_calendar             varchar2(1) not null
                              constraint wwv_flow_ws_show_cal_ck
                              check (show_calendar in (
                              'Y',
                              'N')),
    show_flashback            varchar2(1) not null
                              constraint wwv_flow_ws_show_fb_ck
                              check (show_flashback in (
                              'Y',
                              'N')),
    show_reset                varchar2(1) not null
                              constraint wwv_flow_ws_show_reset_ck
                              check (show_reset in (
                              'Y',
                              'N')),
    show_download             varchar2(1) not null
                              constraint wwv_flow_ws_show_dl_ck
                              check (show_download in (
                              'Y',
                              'N')),
    show_help                 varchar2(1) not null
                              constraint wwv_flow_ws_show_help_ck
                              check (show_help in (
                              'Y',
                              'N')),
    show_detail_link          varchar2(1) not null
                              constraint wwv_flow_ws_detail_link_ck
                              check (show_detail_link in (
                              'Y',
                              'N',
                              'C')),
    download_formats          varchar2(30),
    download_filename         varchar2(255),
    csv_output_separator      varchar2(1),
    csv_output_enclosed_by    varchar2(1),
    supplemental_text         varchar2(4000),
    --
    email_from                varchar2(255),
    --
    detail_link               varchar2(4000),
    detail_link_text          varchar2(4000),
    detail_link_attr          varchar2(4000),
    detail_link_checksum_type varchar2(255) constraint wwv_ir_link_checksum_type
                                check (detail_link_checksum_type in (
                                '1', -- workspace
                                '2', -- user
                                '3'  -- session
                                )),
    detail_link_condition_type varchar2(255),
    detail_link_cond          varchar2(4000),
    detail_link_cond2         varchar2(4000),
    detail_link_auth_scheme   varchar2(4000),
    allow_exclude_null_values varchar2(1) not null
                              constraint wwv_flow_ws_exclude_null_ck
                              check (allow_exclude_null_values in (
                              'Y',
                              'N')),
    allow_hide_extra_columns  varchar2(1) not null
                              constraint wwv_flow_ws_hide_extra_ck
                              check (allow_hide_extra_columns in (
                              'Y',
                              'N')),
    --
    max_query_cost            varchar2(4000),
    max_flashback             varchar2(4000),
    --
    worksheet_flags           varchar2(4000),
    --
    fixed_header              varchar2(6) default 'NONE' not null
                              constraint wwv_flow_ws_fixed_header_ck
                              check (fixed_header in (
                              'NONE',
                              'PAGE',
                              'REGION')),
    fixed_header_max_height   number,
    --
    description               varchar2(4000),
    owner                     varchar2(255),
    --
    icon_view_enabled_yn      varchar2(1) default 'N' not null
                              constraint wwv_flow_ws_iv_enab_ck
                              check (icon_view_enabled_yn in (
                              'Y','N')),
    icon_view_columns_per_row number,
    icon_view_use_custom      varchar2(1) default 'N'
                              constraint wwv_flow_ws_iv_cus_ck
                              check (icon_view_use_custom in (
                              'Y','N')),
    icon_view_custom_link     varchar2(4000),
    icon_view_link_column     varchar2(255),
    icon_view_img_src_column  varchar2(255),
    icon_view_label_column    varchar2(255),
    icon_view_img_attr_text   varchar2(512),
    icon_view_alt_text        varchar2(512),
    icon_view_title_text      varchar2(512),
    --
    detail_view_enabled_yn    varchar2(1) default 'N' not null
                              constraint wwv_flow_ws_enab_dv_ck
                              check (detail_view_enabled_yn in (
                              'Y','N')),
    detail_view_before_rows   varchar2(4000),
    detail_view_for_each_row  varchar2(4000),
    detail_view_after_rows    varchar2(4000),
    --
    internal_uid              number,
    --
    created_on                date,
    created_by                varchar2(255),
    updated_on                date,
    updated_by                varchar2(255),
    security_group_id         number        not null
    )
/

alter table wwv_flow_worksheets
    add constraint wwv_flow_worksheets_pk
    primary key(id)
/

create index wwv_flow_ws_idx1 on wwv_flow_worksheets (flow_id, page_id);
create index wwv_flow_ws_idx2 on wwv_flow_worksheets (region_id);

create unique index wwv_flow_ws_unq_alias_idx on wwv_flow_worksheets
    (case when alias is not null then flow_id end,
     alias)
/


--==============================================================================
--##############################################################################
--#
--# APPLICATION > PAGE > REGION (CHART)
--#
--##############################################################################
prompt APPLICATION > PAGE > REGION (CHART)

--==============================================================================
create table wwv_flow_flash_charts (
      id                            number
                                    constraint wwv_flow_flash_charts_pk
                                    primary key,
      flow_id                       number not null
                                    constraint wwv_flow_flash_charts_fk
                                    references wwv_flows
                                    on delete cascade,
      page_id                       number,
      region_id                     number not null
                                    constraint wwv_flow_flash_charts_fk2
                                    references wwv_flow_page_plugs
                                    on delete cascade,
      default_chart_type            varchar2(255) not null,
      chart_title                   varchar2(255),
      chart_width                   number,
      chart_height                  number,
      chart_animation               varchar2(255),
      display_attr                  varchar2(4000),
      dial_tick_attr                varchar2(4000),
      margins                       varchar2(4000),
      omit_label_interval           number,
      --
      color_scheme                  varchar2(255),
      custom_colors                 varchar2(4000),
      bgtype                        varchar2(255),
      bgcolor1                      varchar2(30),
      bgcolor2                      varchar2(30),
      gradient_rotation             number,
      --
      x_axis_title                  varchar2(4000),
      x_axis_min                    number,
      x_axis_max                    number,
      x_axis_grid_spacing           number,
      x_axis_prefix                 varchar2(4000),
      x_axis_postfix                varchar2(4000),
      x_axis_group_sep              varchar2(1)
                                    constraint wwv_flow_flash_charts_xgroup
                                      check (x_axis_group_sep in ('Y','N')),
      x_axis_decimal_place          number,
      y_axis_title                  varchar2(4000),
      y_axis_min                    number,
      y_axis_max                    number,
      y_axis_grid_spacing           number,
      y_axis_prefix                 varchar2(4000),
      y_axis_postfix                varchar2(4000),
      y_axis_group_sep              varchar2(1)
                                    constraint wwv_flow_flash_charts_ygroup
                                      check (y_axis_group_sep in ('Y','N')),
      y_axis_decimal_place          number,
      async_update                  varchar2(1)
                                    constraint wwv_flow_flash_charts_update
                                      check (async_update in ('Y','N')),
      async_time                    number,
      --
      names_font                    varchar2(4000),
      names_rotation                number,
      values_font                   varchar2(4000),
      values_rotation               number,
      hints_font                    varchar2(4000),
      legend_font                   varchar2(4000),
      grid_labels_font              varchar2(4000),
      chart_title_font              varchar2(4000),
      x_axis_title_font             varchar2(4000),
      y_axis_title_font             varchar2(4000),
      --
      use_chart_xml                 varchar2(1)
                                    constraint wwv_flow_flash_charts_xml
                                      check (use_chart_xml in ('Y','N')),
      chart_xml                     clob,
      attribute_01                  varchar2(4000),
      attribute_02                  varchar2(4000),
      attribute_03                  varchar2(4000),
      attribute_04                  varchar2(4000),
      attribute_05                  varchar2(4000),
      created_on                    date,
      created_by                    varchar2(255),
      updated_on                    date,
      updated_by                    varchar2(255),
      security_group_id             number not null
  ) lob (chart_xml) store as (cache enable storage in row)
/

create index wwv_flow_fl_ch_fid_fk on wwv_flow_flash_charts (flow_id)
/

create index wwv_flow_fl_ch_idx on wwv_flow_flash_charts (region_id, flow_id, security_group_id)
/

--==============================================================================
create table wwv_flow_flash_chart_series (
       id                           number
                                    constraint wwv_flow_flash_chart_series_pk
                                    primary key,
       chart_id                     number not null
                                    constraint wwv_flow_flash_chart_series_fk
                                    references wwv_flow_flash_charts
                                    on delete cascade,
       flow_id                      number,
       series_seq                   number not null,
       series_name                  varchar2(255) not null,
       series_query                 clob not null,
       series_query_type            varchar2(255) not null
                                    constraint wwv_flow_flash_query_type
                                       check (series_query_type in ('SQL_QUERY','FUNCTION_RETURNING_SQL_QUERY')),
       series_query_parse_opt       varchar2(255),
       series_query_no_data_found   varchar2(4000),
       series_query_row_count_max   number,
       created_on                   date,
       created_by                   varchar2(255),
       updated_on                   date,
       updated_by                   varchar2(255),
       security_group_id            number not null
   )
/

create index wwv_flow_fl_ch_sr_idx on wwv_flow_flash_chart_series (chart_id, flow_id, security_group_id)
/

--==============================================================================
create table wwv_flow_flash_charts_5 (
      id                            number
                                    constraint wwv_flow_flash_charts_5_pk
                                    primary key,
      flow_id                       number not null
                                    constraint wwv_flow_flash_charts_5_fk
                                    references wwv_flows
                                    on delete cascade,
      page_id                       number,
      region_id                     number not null
                                    constraint wwv_flow_flash_charts_5_fk2
                                    references wwv_flow_page_plugs
                                    on delete cascade,
      chart_type                    varchar2(255) not null,
      chart_rendering               varchar2(20) default 'FLASH_PREFERRED' not null
                                    constraint wwv_flow_flash_5_rendering
                                     check (chart_rendering in ('FLASH_PREFERRED', 'SVG_ONLY')),
      chart_title                   varchar2(4000),
      chart_name                    varchar2(255),
      chart_width                   number,
      chart_height                  number,
      chart_animation               varchar2(255),
      --
      display_attr                  varchar2(4000),
      dial_tick_attr                varchar2(4000),
      margins                       varchar2(4000),
      bar_shape_type                varchar2(10),
      pie_attr                      varchar2(4000),
      map_source                    varchar2(4000),
      gantt_attr                    varchar2(4000),
      map_attr                      varchar2(4000),
      gantt_date_format             varchar2(255),
      gantt_start_date              date,
      gantt_end_date                date,
      --
      chart_bgtype                  varchar2(255),
      chart_bgimage_mode            varchar2(10),
      chart_bgimage_url             varchar2(4000),
      chart_bgcolor                 varchar2(4000),
      chart_bgcolor2                varchar2(4000),
      chart_bgcorners               varchar2(15),
      chart_gradient_angle          number,
      grid_bgtype                   varchar2(255),
      grid_bgcolor                  varchar2(4000),
      grid_bgcolor2                 varchar2(4000),
      grid_gradient_angle           number,
      data_plot_bgtype              varchar2(10),
      data_plot_bgimage_mode        varchar2(10),
      data_plot_bgimage_url         varchar2(4000),
      data_plot_bgcorners           varchar2(15),
      color_scheme                  varchar2(255),
      custom_colors                 varchar2(4000),
      map_undef_color_scheme        varchar2(255),
      map_undef_custom_colors       varchar2(4000),
      --
      x_axis_title                  varchar2(4000),
      x_axis_title_font             varchar2(4000),
      x_axis_title_rotation         number,
      x_axis_min                    number,
      x_axis_max                    number,
      x_axis_decimal_place          number,
      x_axis_scroll_start           varchar2(4000),
      x_axis_scroll_end             varchar2(4000),
      x_axis_scroll_range           varchar2(4000),
      x_axis_scroll_range_unit      varchar2(255),
      x_axis_label_rotation         number,
      x_axis_label_font             varchar2(4000),
      x_axis_prefix                 varchar2(4000),
      x_axis_postfix                varchar2(4000),
      x_axis_major_interval         number,
      x_axis_minor_interval         number,
      --
      y_axis_title                  varchar2(4000),
      y_axis_title_font             varchar2(4000),
      y_axis_title_rotation         number,
      y_axis_min                    number,
      y_axis_max                    number,
      extra_y_axis_min              number,
      extra_y_axis_max              number,
      y_axis_scroll_start           varchar2(4000),
      y_axis_scroll_end             varchar2(4000),
      y_axis_scroll_range           varchar2(4000),
      y_axis_scroll_range_unit      varchar2(255),
      y_axis_decimal_place          number,
      y_axis_label_rotation         number,
      y_axis_label_font             varchar2(4000),
      y_axis_prefix                 varchar2(4000),
      y_axis_postfix                varchar2(4000),
      y_axis_major_interval         number,
      y_axis_minor_interval         number,
      values_prefix                 varchar2(4000),
      values_postfix                varchar2(4000),
      --
      chart_title_font              varchar2(4000),
      values_font                   varchar2(4000),
      values_rotation               number,
      tooltip_font                  varchar2(4000),
      legend_font                   varchar2(4000),
      legend_title                  varchar2(4000),
      legend_title_font             varchar2(4000),
      grid_labels_font              varchar2(4000),
      gauge_labels_font             varchar2(4000),
      --
      async_update                  varchar2(1)
                                    constraint wwv_flow_flash_5_update
                                      check (async_update in ('Y','N')),
      async_time                    number,
      use_chart_xml                 varchar2(1)
                                    constraint wwv_flow_flash_5_xml
                                      check (use_chart_xml in ('Y','N')),
      chart_xml                     clob,
      created_on                    date,
      created_by                    varchar2(255),
      updated_on                    date,
      updated_by                    varchar2(255),
      security_group_id             number not null
  ) lob (chart_xml) store as (cache enable storage in row)
/

create index wwv_flow_flch5_fid_fk on wwv_flow_flash_charts_5 (flow_id)
/

create index wwv_flow_flch5_idx on wwv_flow_flash_charts_5 (region_id, flow_id, security_group_id)
/

--==============================================================================
create table wwv_flow_flash_chart5_series (
       id                           number
                                    constraint wwv_flow_flash_5_series_pk
                                    primary key,
       chart_id                     number not null
                                    constraint wwv_flow_flash_5_series_fk
                                    references wwv_flow_flash_charts_5
                                    on delete cascade,
       flow_id                      number,
       series_seq                   number not null,
       series_name                  varchar2(255) not null,
       series_type                  varchar2(255),
       series_query_type            varchar2(255) not null
                                    constraint wwv_flow_flash5_qry_type
                                       check (series_query_type in ('SQL_QUERY','FUNCTION_RETURNING_SQL_QUERY')),
       series_query                 clob not null,
       series_ajax_items_to_submit  varchar2(255),
       series_query_parse_opt       varchar2(255),
       series_query_no_data_found   varchar2(4000),
       series_query_row_count_max   number,
       action_link                  varchar2(4000),
       show_action_link             varchar2(1),
       action_link_checksum_type    varchar2(255) constraint wwv_chart_link_checksum_type
                                    check (action_link_checksum_type in (
                                    '1', -- workspace
                                    '2', -- user
                                    '3'  -- session
                                )),
       series_required_role         varchar2(255),
       required_patch               number,
       display_when_cond_type       varchar2(255),
       display_when_condition       varchar2(4000),
       display_when_condition2      varchar2(4000),
       created_on                   date,
       created_by                   varchar2(255),
       updated_on                   date,
       updated_by                   varchar2(255),
       security_group_id            number not null
   )
/

create index wwv_flow_flch5sr_idx on wwv_flow_flash_chart5_series (chart_id, flow_id, security_group_id)
/

--==============================================================================
create table wwv_flow_flash_map_folders (
      id                            number
                                    constraint wwv_flow_flash_map_folders_pk
                                    primary key,
      folder_name                   varchar2(255),
      parent_id                     number
  )
/

create index wwv_flow_mapfolder_pid_idx on wwv_flow_flash_map_folders (parent_id)
/

create index wwv_flow_mapfolder_name_idx on wwv_flow_flash_map_folders (folder_name)
/

--==============================================================================
create table wwv_flow_flash_map_files (
      id                            number
                                    constraint wwv_flow_flash_map_files_pk
                                    primary key,
      folder_id                     number not null constraint wwv_flow_flash_map_files_fk
                                    references wwv_flow_flash_map_folders(id)
                                    on delete cascade,
      parent_id                     number,
      map_name                      varchar2(255),
      map_file_path                 varchar2(4000),
      projection                    varchar2(30) not null
                                    constraint wwv_flow_flash_map_project
                                    check (projection in ('Bonne',
                                                          'Eckert1',
                                                          'Eckert3',
                                                          'Equirectangular',
                                                          'Fahey',
                                                          'HammerAitoff',
                                                          'Mercator',
                                                          'Orthographic',
                                                          'Robinson',
                                                          'Wagner3')),
      icon                          varchar2(4000)
  )
/

create index wwv_flow_mapfiles_idx on wwv_flow_flash_map_files (folder_id)
/

create index wwv_flow_mapfilesnme_idx on wwv_flow_flash_map_files (map_name)
/

create index wwv_flow_mapfilespid_idx on wwv_flow_flash_map_files (parent_id)
/

--==============================================================================
create table wwv_flow_flash_map_regions (
      id                            number
                                    constraint wwv_flow_flash_map_reg_pk
                                    primary key,
      file_id                       number not null constraint wwv_flow_flash_map_reg_fk
                                    references wwv_flow_flash_map_files(id)
                                    on delete cascade,
      region_id                     varchar2(255),
      region_name                   varchar2(255),
      fips                          varchar2(255),
      state_fips                    number,
      sub_region                    varchar2(255),
      adm1_code                     varchar2(255),
      adm1_name                     varchar2(255),
      cntry_name                    varchar2(255),
      object_id                     number,
      pop1990                       number,
      pop90_sqmi                    number,
      white                         number,
      hshold_1_m                    number,
      mobilehome                    number,
      centroid_x                    number,
      centroid_y                    number,
      gmi_admin                     varchar2(255)
  )
/

create index wwv_flow_mapreg_idx on wwv_flow_flash_map_regions (file_id)
/

create index wwv_flow_mapregid_idx on wwv_flow_flash_map_regions (region_id)
/

create index wwv_flow_mapregnme_idx on wwv_flow_flash_map_regions (region_name)
/

create index wwv_flow_map_x_idx on wwv_flow_flash_map_regions (centroid_x)
/

create index wwv_flow_map_y_idx on wwv_flow_flash_map_regions (centroid_y)
/

--==============================================================================
-- JET Charts
--==============================================================================
create table wwv_flow_jet_charts (
      id                          number
                                  constraint jet_charts_pk
                                  primary key,
      flow_id                     number not null
                                  constraint jet_charts_flow_fk
                                  references wwv_flows
                                  on delete cascade,
      page_id                     number,
      region_id                   number not null
                                  constraint jet_charts_region_fk
                                  references wwv_flow_page_plugs
                                  on delete cascade,
      security_group_id           number not null,
      chart_type                  varchar2(15) not null
                                  constraint jet_charts_type
                                  check (chart_type in ('area', 'bar', 'boxPlot', 'bubble', 'combo','funnel', 'gantt', 'line', 'lineWithArea','pie' ,'scatter', 'stock', 'dial', 'donut', 'range', 'polar', 'radar', 'pyramid')),
      title                       varchar2(255),
      width                       varchar2(10),
      height                      varchar2(10),
      animation_on_display        varchar2(10) not null
                                  constraint jet_charts_animation_disp
                                  check (animation_on_display in ('alphaFade', 'auto', 'none', 'zoom' )),
      animation_on_data_change    varchar2(15) not null
                                  constraint jet_charts_animation_data
                                  check (animation_on_data_change in ('auto', 'slideToLeft', 'slideToRight', 'none')),
      orientation                 varchar2(10)
                                  constraint jet_charts_orientation
                                  check (orientation in ('horizontal','vertical')),
      data_cursor                 varchar2(5)
                                  constraint jet_charts_datacursor
                                  check (data_cursor in ('auto','on','off')),
      data_cursor_behavior        varchar2(10)
                                  constraint jet_charts_data_cb
                                  check (data_cursor_behavior in ('auto','smooth','snap')),
      hide_and_show_behavior      varchar2(15)
                                  constraint jet_charts_hideshow
                                  check (hide_and_show_behavior in ('none','withRescale','withoutRescale')),
      hover_behavior              varchar2(5)
                                  constraint jet_charts_hover
                                  check (hover_behavior in ('dim','none')),
      stack                       varchar2(3)
                                  constraint jet_charts_stack
                                  check (stack in ('on','off')),
      stack_label                 varchar2(3)
                                  constraint jet_charts_stack_label
                                  check (stack_label in ('on','off')),
      spark_chart                 varchar2(1)
                                  constraint jet_charts_spark
                                  check (spark_chart in ('Y','N')),
      connect_nulls               varchar2(1)
                                  constraint jet_series_connect_nulls
                                  check (connect_nulls in ('Y','N')),
      stock_render_as             varchar2(15)
                                  constraint jet_charts_stock
                                  check (stock_render_as in ('area','bar','candlestick','line','lineWithArea')),
      dial_indicator              varchar2(15)
                                  constraint jet_charts_dial_indicator
                                  check (dial_indicator in ('needleAlta', 'needleLight','needleDark','needleAntique')),
      dial_background             varchar2(30)
                                  constraint jet_charts_dial_background
                                  check (dial_background in ('circleAlta','domeAlta','rectangleAlta','circleLight','domeLight','rectangleLight',
                                                             'circleDark','domeDark','rectangleDark','circleAntique','domeAntique','rectangleAntique')),
      value_min                   number,
      value_text_type             varchar2(10)
                                  constraint jet_charts_text_type
                                  check (value_text_type in ('number','percent')),
      value_position              varchar2(20)
                                  constraint jet_charts_value_position
                                  check (value_position in ('auto','center','insideIndicatorEdge','outsideIndicatorEdge','outsidePlotArea','withLabel')),
      value_format_type           varchar2(20)
                                  constraint jet_charts_format_type
                                  check (value_format_type in ('date-short','date-medium','date-long','date-full','time-short','time-medium', 'time-long','time-full',
                                                               'datetime-short','datetime-medium','datetime-long','datetime-full','decimal','currency','percent')),
      value_decimal_places        number,
      value_currency              varchar2(128),
      value_numeric_pattern       varchar2(30),
      value_format_scaling        varchar2(12)
                                  constraint jet_charts_scaling
                                  check (value_format_scaling in ('auto','none','thousand','million','billion','trillion','quadrillion')),
      sorting                     varchar2(10)
                                  constraint jet_chart_sorting
                                  check (sorting in ('value-asc','value-desc','label-desc','label-asc')),
      fill_multi_series_gaps      varchar2(1)
                                  constraint jet_charts_fill_gaps
                                  check (fill_multi_series_gaps in ('Y','N')),
      zoom_and_scroll             varchar2(20)
                                  constraint jet_charts_zoom
                                  check (zoom_and_scroll in ('delayed','delayedScrollOnly','live','liveScrollOnly','off')),
      zoom_direction              varchar2(4)
                                  constraint jet_charts_zoom_direction
                                  check (zoom_direction in ('auto','x','y')),
      initial_zooming             varchar2(5)
                                  constraint jet_charts_init_zoom
                                  check (initial_zooming in ('none','first','last')),
      tooltip_rendered            varchar2(1)
                                  constraint jet_charts_tooltip
                                  check (tooltip_rendered in ('Y','N','C')),
      show_series_name            varchar2(1)
                                  constraint jet_charts_series
                                  check (show_series_name in ('Y','N')),
      show_group_name             varchar2(1)
                                  constraint jet_charts_group
                                  check (show_group_name in ('Y','N')),
      show_value                  varchar2(1)
                                  constraint jet_charts_value
                                  check (show_value in ('Y','N')),
      show_label                  varchar2(1)
                                  constraint jet_charts_label
                                  check (show_label in ('Y','N')),
      -- Gantt Tooltip columns
      show_row                    varchar2(1)
                                  constraint jet_charts_gantt_row
                                  check (show_row in ('Y','N')),
      show_start                  varchar2(1)
                                  constraint jet_charts_gantt_start
                                  check (show_start in ('Y','N')),
      show_end                    varchar2(1)
                                  constraint jet_charts_gantt_end
                                  check (show_end in ('Y','N')),
      show_progress               varchar2(1)
                                  constraint jet_charts_gantt_progress
                                  check (show_progress in ('Y','N')),
      show_baseline               varchar2(1)
                                  constraint jet_charts_gantt_baseline
                                  check (show_baseline in ('Y','N')),
      --
      custom_tooltip              varchar2(255),
      legend_rendered             varchar2(3)
                                  constraint jet_charts_legend
                                  check (legend_rendered in ('on','off')),
      legend_title                varchar2(255),
      legend_position             varchar2(10)
                                  constraint jet_charts_legend_pos
                                  check (legend_position in ('auto','bottom','end','start','top')),
      legend_font_family          varchar2(20)
                                  constraint jet_legend_font_family
                                  check (legend_font_family in ('Arial','Arial Black','Bookman','Comic Sans MS','Courier','Courier New','Garamond','Georgia','Helvetica','Impact','Palatino','Times','Times New Roman','Trebuchet MS','Verdana')),
      legend_font_style           varchar2(10)
                                  constraint jet_legend_font_style
                                  check (legend_font_style in ('normal','italic','oblique')),
      legend_font_size            varchar2(2)
                                  constraint jet_legend_font_size
                                  check (legend_font_size in ('8','10','12','14','16','18','20','22')),
      legend_font_color           varchar2(128),
      overview_rendered           varchar2(3)
                                  constraint jet_charts_overview
                                  check (overview_rendered in ('on','off')),
      overview_height             varchar2(5),
      pie_other_threshold         number
                                  constraint jet_charts_pie_other
                                  check (pie_other_threshold between 0 and 1),
      pie_selection_effect        varchar2(20)
                                  constraint jet_charts_pie_effect
                                  check (pie_selection_effect in ('explode','highlightAndExplode','highlight')),
      time_axis_type              varchar2(15)
                                  constraint jet_charts_axis
                                  check (time_axis_type in ('enabled','mixedFrequency','disabled','auto', 'skipGaps')),
      -- Gantt Chart columns
      horizontal_grid             varchar2(10)
                                  constraint jet_charts_horizontal_grid
                                  check (horizontal_grid in ('auto','hidden','visible')),
      vertical_grid               varchar2(10)
                                  constraint jet_charts_vertical_grid
                                  check (vertical_grid in ('auto','hidden','visible')),
      row_axis_rendered           varchar2(3)
                                  constraint jet_row_axis
                                  check (row_axis_rendered in ('on','off')),
      gantt_axis_position         varchar2(6)
                                  constraint jet_charts_axis_position
                                  check (gantt_axis_position in ('top','bottom')),
      -- Status Meter Gauge columns
      gauge_orientation           varchar2(10)
                                  constraint jet_charts_gauge_orient
                                  check (gauge_orientation in ('horizontal','vertical','circular')),
      gauge_indicator_size        number,
      gauge_inner_radius          number,
      gauge_plot_area             varchar2(3)
                                  constraint jet_charts_gauge_plot
                                  check (gauge_plot_area in ('on','off')),
      gauge_start_angle           number,
      gauge_angle_extent          number,
      show_gauge_value            varchar2(1)
                                  constraint jet_charts_gauge_value
                                  check (show_gauge_value in ('Y','N')),
      no_data_found_message       varchar2(4000),
      javascript_code             varchar2(4000),
      automatic_refresh_interval  number,
      created_on                  date,
      created_by                  varchar2(255),
      updated_on                  date,
      updated_by                  varchar2(255)
  )
/

create index wwv_flow_jet_ch_fid_fk on wwv_flow_jet_charts (flow_id,page_id)
/

create index wwv_flow_jet_ch_fid_fk2 on wwv_flow_jet_charts (region_id)
/

--==============================================================================
create table wwv_flow_jet_chart_series (
       id                           number
                                    constraint jet_series_pk
                                    primary key,
       chart_id                     number not null
                                    constraint jet_series_fk
                                    references wwv_flow_jet_charts
                                    on delete cascade,
       static_id                    varchar2(128),
       flow_id                      number not null
                                    constraint jet_series_flow_fk references wwv_flows
                                    on delete cascade,
       page_id                      number,
       security_group_id            number not null,
       seq                          number not null,
       name                         varchar2(255) not null,
       data_source_type             varchar2(30)
                                    constraint jet_series_data_src_type
                                    check (data_source_type in ('SQL','FUNC_BODY_RETURNING_SQL','TABLE')),
       data_source                  clob,
       max_row_count                number,
       ajax_items_to_submit         varchar2(4000),
       --
       location                     varchar2(13) not null
                                    constraint jet_series_location_ck
                                    check (location in ('LOCAL', 'REMOTE', 'WEB_SOURCE', 'REGION_SOURCE' )),
       remote_server_id             number
                                    constraint jet_series_remote_server_fk
                                    references wwv_remote_servers,
       web_src_module_id            number
                                    constraint jet_series_web_src_module_fk
                                    references wwv_flow_web_src_modules,
       query_owner                  varchar2(128),
       query_table                  varchar2(128),
       query_where                  varchar2(4000),
       query_order_by               varchar2(255),
       source_post_processing       varchar2(23)
                                    constraint jet_series_post_proc_ck
                                    check ( source_post_processing in ( 'WHERE_ORDER_BY_CLAUSE', 'SQL', 'FUNC_BODY_RETURNING_SQL' )),
       include_rowid_column         varchar2(1)
                                    constraint jet_include_rowid_columnn_ck
                                    check (include_rowid_column in ('Y', 'N')),
       optimizer_hint               varchar2(255),
       --
       remote_sql_caching           varchar2(9)
                                    constraint jet_remote_sql_caching_ck
                                    check (remote_sql_caching in ('ALL_USERS', 'USER', 'SESSION')),
       remote_sql_invalidate_when   varchar2(255),
       --
       external_filter_expr         varchar2(4000),
       external_order_by_expr       varchar2(255),
       --
       series_type                  varchar2(15)
                                    constraint jet_series_type
                                    check (series_type in ('area','areaRange','bar','barRange','boxPlot','bubble','stock','dial','donut','funnel','line','lineWithArea','pie','scatter','pyramid','gantt')),
       series_name_column_name      varchar2(128),
       items_value_column_name      varchar2(128),
       items_low_column_name        varchar2(128),
       items_high_column_name       varchar2(128),
       items_open_column_name       varchar2(128),
       items_close_column_name      varchar2(128),
       items_volume_column_name     varchar2(128),
       items_x_column_name          varchar2(128),
       items_y_column_name          varchar2(128),
       items_z_column_name          varchar2(128),
       items_target_value           varchar2(128),
       items_min_value              varchar2(128),
       items_max_value              varchar2(128),
       --
       aggregate_function           varchar2(21)
                                    constraint jet_aggregate_func
                                    check (aggregate_function in ( 'SUM',
                                                                   'AVG', 'MEDIAN',
                                                                   'COUNT', 'COUNT_DISTINCT', 'APPROX_COUNT_DISTINCT',
                                                                   'MIN', 'MAX' )),
       -- Gantt Chart Attributes
       gantt_start_date_source      varchar2(30)
                                    constraint jet_gantt_start_src
                                    check (gantt_start_date_source in ('ITEM','DB_COLUMN')),
       gantt_start_date_column      varchar2(128),
       gantt_start_date_item        varchar2(128),
       gantt_end_date_source        varchar2(30)
                                    constraint jet_gantt_end_src
                                    check (gantt_end_date_source in ('ITEM','DB_COLUMN')),
       gantt_end_date_column        varchar2(128),
       gantt_end_date_item          varchar2(128),
       -- Row
       gantt_row_id                 varchar2(128),
       gantt_row_name               varchar2(128),
       -- Tasks
       gantt_task_id                varchar2(128),
       gantt_task_name              varchar2(128),
       gantt_task_start_date        varchar2(128),
       gantt_task_end_date          varchar2(128),
       gantt_task_css_style         varchar2(128),
       gantt_task_css_class         varchar2(128),
       -- Dependencies
       gantt_predecessor_task_id    varchar2(128),
       gantt_successor_task_id      varchar2(128),
       --  Baseline Settings
       gantt_baseline_start_column  varchar2(128),
       gantt_baseline_end_column    varchar2(128),
       gantt_baseline_css_class     varchar2(128),
       -- Progress
       gantt_progress_column        varchar2(128),
       gantt_progress_css_class     varchar2(128),
       -- Viewport
       gantt_viewport_start_source  varchar2(30)
                                    constraint jet_gantt_view_start_src
                                    check (gantt_viewport_start_source in ('ITEM','DB_COLUMN')),
       gantt_viewport_start_column  varchar2(128),
       gantt_viewport_start_item    varchar2(128),
       gantt_viewport_end_source    varchar2(30)
                                    constraint jet_gantt_view_end_src
                                    check (gantt_viewport_end_source in ('ITEM','DB_COLUMN')),
       gantt_viewport_end_column    varchar2(128),
       gantt_viewport_end_item      varchar2(128),
       task_label_position          varchar2(15)
                                    constraint jet_task_label_position
                                    check (task_label_position in ('end','innerCenter','innerEnd','innerStart','none','start')),
       --
       group_name_column_name       varchar2(128),
       group_short_desc_column_name varchar2(128),
       items_label_column_name      varchar2(128),
       items_short_desc_column_name varchar2(128),
       custom_column_name           varchar2(128),
       color                        varchar2(128),
       q2_color                     varchar2(128),
       q3_color                     varchar2(128),
       line_style                   varchar2(6)
                                    constraint jet_series_line_style
                                    check (line_style in ('dashed','dotted','solid')),
       line_width                   number
                                    constraint jet_series_line_width
                                    check (line_width between 0 and 20),
       line_type                    varchar2(20)
                                    constraint jet_series_line_type
                                    check (line_type in ('centeredStepped','centeredSegmented','curved','segmented','stepped','straight','auto','none')),
       marker_rendered              varchar2(5)
                                    constraint jet_series_show_marker
                                    check (marker_rendered in ('auto','on','off')),
       marker_shape                 varchar2(15)
                                    constraint jet_series_marker
                                    check (marker_shape in ('auto','circle','diamond','plus','triangleDown','triangleUp','human','square','star')),
       assigned_to_y2               varchar2(3)
                                    constraint jet_series_assign_to_y2
                                    check (assigned_to_y2 in ('on','off')),
       stack_category               varchar2(100),
       items_label_rendered         varchar2(1) not null
                                    constraint jet_series_show_label
                                    check (items_label_rendered in ('Y','N')),
       items_label_position         varchar2(15)
                                    constraint jet_series_label_position
                                    check (items_label_position in ('center','outsideSlice','aboveMarker','belowMarker','beforeMarker','afterMarker','insideBarEdge','outsideBarEdge','auto','none','start')),
       items_label_display_as       varchar2(7)
                                    constraint jet_series_label_display_as
                                    check (items_label_display_as in ('LABEL','VALUE','PERCENT','ALL','COMBO','LBL_VAL')),
       items_label_css_classes      varchar2(255),
       items_label_font_family      varchar2(20)
                                    constraint jet_label_font_family
                                    check (items_label_font_family in ('Arial','Arial Black','Bookman','Comic Sans MS','Courier','Courier New','Garamond','Georgia','Helvetica','Impact','Palatino','Times','Times New Roman','Trebuchet MS','Verdana')),
       items_label_font_style       varchar2(10)
                                    constraint jet_label_font_style
                                    check (items_label_font_style in ('normal','italic','oblique')),
       items_label_font_size        varchar2(2)
                                    constraint jet_label_font_size
                                    check (items_label_font_size in ('8','10','12','14','16','18','20','22')),
       items_label_font_color       varchar2(128),
       --
       gauge_plot_area_color        varchar2(128),
       threshold_values             varchar2(4000),
       threshold_colors             varchar2(4000),
       threshold_display            varchar2(11)
                                    constraint jet_series_threshold_display
                                    check (threshold_display in ('all','currentOnly','onIndicator')),
       reference_line_values        varchar2(4000),
       reference_line_colors        varchar2(4000),
       --
       link_target                  varchar2(4000),
       link_target_type             varchar2(22)
                                    constraint jet_series_link_type
                                    check (link_target_type in ('REDIRECT_URL','REDIRECT_PAGE','REDIRECT_APP','DEFINED_BY_DA', 'DEPRECATED_LINK_COLUMN' )),
       security_scheme              varchar2(255),
       required_patch               number,
       series_comment               varchar2(4000),
       display_when_cond_type       varchar2(255),
       display_when_condition       varchar2(4000),
       display_when_condition2      varchar2(4000),
       created_on                   date,
       created_by                   varchar2(255),
       updated_on                   date,
       updated_by                   varchar2(255)
   ) lob (data_source) store as (cache enable storage in row)
/

create index jet_series_idx2 on wwv_flow_jet_chart_series (chart_id)
/

create index jet_series_idx3 on wwv_flow_jet_chart_series (flow_id,page_id) compress
/

create index jet_series_idx4 on wwv_flow_jet_chart_series ( remote_server_id )
/

create index jet_series_idx5  on wwv_flow_jet_chart_series ( web_src_module_id )
/

--==============================================================================
create table wwv_flow_jet_chart_axes (
      id                          number
                                  constraint jet_axes_pk
                                  primary key,
      chart_id                    number not null
                                  constraint jet_axes_fk
                                  references wwv_flow_jet_charts
                                  on delete cascade,
      static_id                   varchar2(128),
      flow_id                     number not null
                                  constraint jet_axes_flow_fk references wwv_flows
                                  on delete cascade,
      page_id                     number,
      security_group_id           number not null,
      axis                        varchar2(5)
                                  constraint jet_axes_axis
                                  check (axis in ('x','y','y2','major','minor')),
      is_rendered                 varchar2(5)
                                  constraint jet_axes_rendered
                                  check (is_rendered in ('on','off')),
      title                       varchar2(255),
      title_font_family           varchar2(20)
                                  constraint jet_title_font_family
                                  check (title_font_family in ('Arial','Arial Black','Bookman','Comic Sans MS','Courier','Courier New','Garamond','Georgia','Helvetica','Impact','Palatino','Times','Times New Roman','Trebuchet MS','Verdana')),
      title_font_style            varchar2(10)
                                  constraint jet_title_font_style
                                  check (title_font_style in ('normal','italic','oblique')),
      title_font_size             varchar2(2)
                                  constraint jet_title_font_size
                                  check (title_font_size in ('8','10','12','14','16','18','20','22')),
      title_font_color            varchar2(128),
      min                         number,
      max                         number,
      format_type                 varchar2(20)
                                  constraint jet_axes_format_type
                                  check (format_type in ('date-short','date-medium','date-long','date-full',
                                                         'time-short','time-medium', 'time-long','time-full',
                                                         'datetime-short','datetime-medium','datetime-long','datetime-full',
                                                         'decimal','currency','percent')),
      decimal_places              number,
      currency                    varchar2(128),
      numeric_pattern             varchar2(30),
      format_scaling              varchar2(12)
                                  constraint jet_axes_format_scaling
                                  check (format_scaling in ('auto','none','thousand','million','billion','trillion','quadrillion')),
      scaling                     varchar2(10)
                                  constraint jet_axes_scaling
                                  check (scaling in ('linear','log')),
      baseline_scaling            varchar2(5)
                                  constraint jet_axes_baseline_scale
                                  check (baseline_scaling in ('min','zero')),
      step                        number
                                  constraint jet_axes_step
                                  check (step >= 0),
      position                    varchar2(10)
                                  constraint jet_axes_position
                                  check (position in ('start','end','top','bottom','auto')),
      major_tick_rendered         varchar2(5)
                                  constraint jet_axes_major_tick
                                  check (major_tick_rendered in ('auto','on','off')),
      min_step                    number
                                  constraint jet_axes_min_step
                                  check (min_step >= 0),
      minor_tick_rendered         varchar2(5)
                                  constraint jet_axes_minor_tick
                                  check (minor_tick_rendered in ('auto','on','off')),
      minor_step                  number
                                  constraint jet_axes_minor_step
                                  check (minor_step >= 0),
      tick_label_rendered         varchar2(5)
                                  constraint jet_axes_tick_label
                                  check (tick_label_rendered in ('on','off')),
      tick_label_rotation         varchar2(5)
                                  constraint jet_axes_label_rotation
                                  check (tick_label_rotation in ('auto','none')),
      tick_label_position         varchar2(10)
                                  constraint jet_axes_label_position
                                  check (tick_label_position in ('inside','outside')),
      tick_label_font_family      varchar2(20)
                                  constraint jet_tick_font_family
                                  check (tick_label_font_family in ('Arial','Arial Black','Bookman','Comic Sans MS','Courier','Courier New','Garamond','Georgia','Helvetica','Impact','Palatino','Times','Times New Roman','Trebuchet MS','Verdana')),
      tick_label_font_style       varchar2(10)
                                  constraint jet_tick_font_style
                                  check (tick_label_font_style in ('normal','italic','oblique')),
      tick_label_font_size        varchar2(2)
                                  constraint jet_tick_font_size
                                  check (tick_label_font_size in ('8','10','12','14','16','18','20','22')),
      tick_label_font_color       varchar2(128),
      split_dual_y                varchar2(5)
                                  constraint jet_axes_split_dual_y
                                  check (split_dual_y in ('auto','on','off')),
      splitter_position           number,
      -- Gantt Chart Attributes
      axis_scale                  varchar2(10)
                                  constraint jet_axes_scale
                                  check (axis_scale in ('seconds','minutes','hours','days','weeks','months','quarters','years')),
      zoom_order_seconds          varchar2(1)
                                  constraint jet_zoom_order_secs
                                  check (zoom_order_seconds in ('Y','N')),
      zoom_order_minutes          varchar2(1)
                                  constraint jet_zoom_order_mins
                                  check (zoom_order_minutes in ('Y','N')),
      zoom_order_hours            varchar2(1)
                                  constraint jet_zoom_order_hrs
                                  check (zoom_order_hours in ('Y','N')),
      zoom_order_days             varchar2(1)
                                  constraint jet_zoom_order_days
                                  check (zoom_order_days in ('Y','N')),
      zoom_order_weeks            varchar2(1)
                                  constraint jet_zoom_order_wks
                                  check (zoom_order_weeks in ('Y','N')),
      zoom_order_months           varchar2(1)
                                  constraint jet_zoom_order_mths
                                  check (zoom_order_months in ('Y','N')),
      zoom_order_quarters         varchar2(1)
                                  constraint jet_zoom_order_qtrs
                                  check (zoom_order_quarters in ('Y','N')),
      zoom_order_years            varchar2(1)
                                  constraint jet_zoom_order_yrs
                                  check (zoom_order_years in ('Y','N')),
      created_on                  date,
      created_by                  varchar2(255),
      updated_on                  date,
      updated_by                  varchar2(255)
  )
/

create index wwv_flow_jet_ax_fid_fk on wwv_flow_jet_chart_axes (flow_id, page_id)
/

create index wwv_flow_jet_ax_fid_fk2 on wwv_flow_jet_chart_axes (chart_id)
/

--##############################################################################
--#
--# APPLICATION > PAGE > CACHING
--#
--##############################################################################
prompt APPLICATION > PAGE > CACHING

--==============================================================================
create table wwv_flow_page_cache (
    id                   number
                         constraint wwv_flow_page_cache_pk
                         primary key,
    flow_id              number not null, -- app
    page_id              number not null, -- page
    region_id            number           -- support caching regions as well
                         constraint wwv_flow_page_cache_fk_region
                         references wwv_flow_page_plugs
                         on delete cascade,
    security_group_id    number not null, -- workspace
    language             varchar2(255),   -- all cached pages are by language
    user_name            varchar2(255),   -- the user at the time of caching
    owning_session_id    number           -- reference to the owning session if caching is session based
                         constraint wwv_flow_page_cache_fk_session
                         references wwv_flow_sessions$
                         on delete cascade,
    session_id           number,          -- the session at the time of caching
    builder_session_id   number,          -- the builder session at the time of caching
    item_hash            varchar2(255),   -- hash for item values that the cached component depends on
    page_text            clob,            -- HTML cache of page
    valid_until          date   not null, -- cached value is valid until this time
    cached_on            date   not null, -- create date
    constraint wwv_flow_page_cache_fk_page
        foreign key(flow_id, page_id)
        references wwv_flow_steps(flow_id, id)
        on delete cascade
    )
    pctfree 0
    lob (page_text) store as (
        pctversion 0
        cache
        disable storage in row )
/
create index wwv_flow_page_cache_idx1 on wwv_flow_page_cache (flow_id, page_id, user_name) compress
/
create index wwv_flow_page_cache_idx2 on wwv_flow_page_cache (owning_session_id, flow_id, page_id) compress
/
create index wwv_flow_page_cache_idx3 on wwv_flow_page_cache (region_id)
/

create table wwv_flow_page_code_cache (
    id            number
                  constraint wwv_flow_page_code_cache_pk
                  primary key,
    page_cache_id number
                  constraint wwv_flow_page_code_cache_fk
                  references wwv_flow_page_cache
                  on delete cascade,
    code_type     varchar2(10),
    type          varchar2(20),
    key           varchar2(4000),
    code          clob
    )
    pctfree 0
    lob (code) store as (
        pctversion 0
        cache
        enable storage in row)
/

create index wwv_flow_page_code_cache_fkidx on wwv_flow_page_code_cache (page_cache_id)
/

--##############################################################################
--#
--# APPLICATION > DEVELOPER LOCKING
--#
--##############################################################################
prompt APPLICATION > DEVELOPER LOCKING

--==============================================================================
create table wwv_flow_lock_page (
  id                  number
                      constraint wwv_flow_lock_page_pk
                      primary key,
  flow_id             number
                      references wwv_flows (id)
                      on delete cascade,
  object_id           number,
  locked_by           varchar2(255),
  locked_on           date,
  lock_comment        varchar2(4000),
  security_group_id   number not null
  )
/

create index wwv_flow_lock_page_fk on wwv_flow_lock_page (flow_id)
/

create index wwv_flow_lock_page_by on wwv_flow_lock_page (locked_by)
/

create unique index wwv_flow_lock_page_pg on wwv_flow_lock_page (object_id,flow_id)
/

--==============================================================================
create table wwv_flow_lock_page_log (
    id             number
                   constraint wwv_flow_lock_pg_log_pk
                   primary key,
    lock_id        number not null,
    lock_flow      number,
    lock_page      number,
    action         varchar2(30) not null
                   constraint dev_file_lock_log_action
                   check ( action in ('LOCK','UNLOCK','UPDATE')),
    action_date    date,
    developer      varchar2(255),
    lock_comment   varchar2(4000)
    )
/


create index wwv_flow_lock_page_log_idx1 on wwv_flow_lock_page_log (lock_flow)
/

create index wwv_flow_lock_page_log_idx2 on wwv_flow_lock_page_log (lock_id)
/

--##############################################################################
--#
--# APPLICATION > SUPPORTING OBJECTS
--#
--##############################################################################
prompt APPLICATION > SUPPORTING OBJECTS

--==============================================================================
create table wwv_flow_install (
     id                        number
                               constraint wwv_flow_install_pk
                               primary key,
     flow_id                   number  not null
                               constraint wwv_flow_install_fk
                               references wwv_flows
                               on delete cascade,
     security_group_id         number not null
                               constraint wwv_flow_install_fk2
                               references wwv_flow_companies(provisioning_company_id),
     --
     include_in_export_yn      varchar2(1)
                               constraint wwv_install_in_export
                               check (include_in_export_yn in ('Y','N','I')),
     --
     welcome_message           varchar2(4000),
     license_message           varchar2(4000),
     configuration_message     varchar2(4000),
     build_options_message     varchar2(4000),
     validation_message        varchar2(4000),
     install_message           varchar2(4000),
     install_success_message   varchar2(4000),
     install_failure_message   varchar2(4000),
     --
     get_version_sql_query     varchar2(4000),
     upgrade_message           varchar2(4000),
     upgrade_confirm_message   varchar2(4000),
     upgrade_success_message   varchar2(4000),
     upgrade_failure_message   varchar2(4000),
     --
     deinstall_message         varchar2(4000),
     deinstall_success_message varchar2(4000),
     deinstall_failure_message varchar2(4000),
     deinstall_script          clob,
     --
     prompt_substitution_01_yn varchar2(1)
                               constraint wwv_install_sub_01
                               check (prompt_substitution_01_yn in ('Y','N')),
     prompt_substitution_02_yn varchar2(1)
                               constraint wwv_install_sub_02
                               check (prompt_substitution_02_yn in ('Y','N')),
     prompt_substitution_03_yn varchar2(1)
                               constraint wwv_install_sub_03
                               check (prompt_substitution_03_yn in ('Y','N')),
     prompt_substitution_04_yn varchar2(1)
                               constraint wwv_install_sub_04
                               check (prompt_substitution_04_yn in ('Y','N')),
     prompt_substitution_05_yn varchar2(1)
                               constraint wwv_install_sub_05
                               check (prompt_substitution_05_yn in ('Y','N')),
     prompt_substitution_06_yn varchar2(1)
                               constraint wwv_install_sub_06
                               check (prompt_substitution_06_yn in ('Y','N')),
     prompt_substitution_07_yn varchar2(1)
                               constraint wwv_install_sub_07
                               check (prompt_substitution_07_yn in ('Y','N')),
     prompt_substitution_08_yn varchar2(1)
                               constraint wwv_install_sub_08
                               check (prompt_substitution_08_yn in ('Y','N')),
     prompt_substitution_09_yn varchar2(1)
                               constraint wwv_install_sub_09
                               check (prompt_substitution_09_yn in ('Y','N')),
     prompt_substitution_10_yn varchar2(1)
                               constraint wwv_install_sub_10
                               check (prompt_substitution_10_yn in ('Y','N')),
     prompt_substitution_11_yn varchar2(1)
                               constraint wwv_install_sub_11
                               check (prompt_substitution_11_yn in ('Y','N')),
     prompt_substitution_12_yn varchar2(1)
                               constraint wwv_install_sub_12
                               check (prompt_substitution_12_yn in ('Y','N')),
     prompt_substitution_13_yn varchar2(1)
                               constraint wwv_install_sub_13
                               check (prompt_substitution_13_yn in ('Y','N')),
     prompt_substitution_14_yn varchar2(1)
                               constraint wwv_install_sub_14
                               check (prompt_substitution_14_yn in ('Y','N')),
     prompt_substitution_15_yn varchar2(1)
                               constraint wwv_install_sub_15
                               check (prompt_substitution_15_yn in ('Y','N')),
     prompt_substitution_16_yn varchar2(1)
                               constraint wwv_install_sub_16
                               check (prompt_substitution_16_yn in ('Y','N')),
     prompt_substitution_17_yn varchar2(1)
                               constraint wwv_install_sub_17
                               check (prompt_substitution_17_yn in ('Y','N')),
     prompt_substitution_18_yn varchar2(1)
                               constraint wwv_install_sub_18
                               check (prompt_substitution_18_yn in ('Y','N')),
     prompt_substitution_19_yn varchar2(1)
                               constraint wwv_install_sub_19
                               check (prompt_substitution_19_yn in ('Y','N')),
     prompt_substitution_20_yn varchar2(1)
                               constraint wwv_install_sub_20
                               check (prompt_substitution_20_yn in ('Y','N')),
     install_prompt_01         varchar2(255),
     install_prompt_02         varchar2(255),
     install_prompt_03         varchar2(255),
     install_prompt_04         varchar2(255),
     install_prompt_05         varchar2(255),
     install_prompt_06         varchar2(255),
     install_prompt_07         varchar2(255),
     install_prompt_08         varchar2(255),
     install_prompt_09         varchar2(255),
     install_prompt_10         varchar2(255),
     install_prompt_11         varchar2(255),
     install_prompt_12         varchar2(255),
     install_prompt_13         varchar2(255),
     install_prompt_14         varchar2(255),
     install_prompt_15         varchar2(255),
     install_prompt_16         varchar2(255),
     install_prompt_17         varchar2(255),
     install_prompt_18         varchar2(255),
     install_prompt_19         varchar2(255),
     install_prompt_20         varchar2(255),
     --
     prompt_if_mult_auth_yn    varchar2(1)
                               constraint wwv_auth_prompt
                               check (prompt_if_mult_auth_yn in ('Y','N')),
     --
     trigger_install_when_cond varchar2(255),
     trigger_install_when_exp1 varchar2(4000),
     trigger_install_when_exp2 varchar2(4000),
     trigger_failure_message   varchar2(4000),
     required_free_kb          number,
     required_sys_privs        varchar2(4000),
     required_names_available  varchar2(4000),
     --
     last_updated_by           varchar2(255),
     last_updated_on           date,
     created_by                varchar2(255),
     created_on                date
)
/

create unique index wwv_flow_install_idx1 on wwv_flow_install (flow_id)
/
create index wwv_flow_install_idx2 on wwv_flow_install (security_group_id)
/

--==============================================================================
create table wwv_flow_install_scripts (
    id                    number
                          constraint wwv_flow_install_scripts_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_install_scripts_fk
                          references wwv_flows,
    security_group_id     number not null
                          constraint wwv_flow_install_scripts_fk2
                          references wwv_flow_companies(provisioning_company_id),
    install_id            number  not null
                          constraint wwv_flow_install_scripts_fk3
                          references wwv_flow_install
                          on delete cascade,
    name                  varchar2(255) not null,
    sequence              number not null,
    script                clob not null,
    script_type           varchar2(30)
                          constraint wwv_flow_install_st_ck
                          check (script_type in ('INSTALL','UPGRADE','DEINSTALL')),
    script_option         varchar2(30)
                          constraint wwv_flow_install_so_ck
                          check (script_option in ('PACKAGE_SPEC','PACKAGE_BODY','TABLE')),
    ---
    condition_type        varchar2(255),
    condition             varchar2(4000),
    condition2            varchar2(4000),
    ---
    last_updated_by       varchar2(255),
    last_updated_on       date,
    created_by            varchar2(255),
    created_on            date
)
/
create unique index wwv_flow_install_scripts_idx1 on wwv_flow_install_scripts (flow_id, name, script_type)
/
create index wwv_flow_install_scripts_idx2 on wwv_flow_install_scripts (security_group_id)
/
create index wwv_flow_install_scripts_idx3 on wwv_flow_install_scripts (install_id)
/

--==============================================================================
create table wwv_flow_install_objects (
    id                    number
                          constraint wwv_flow_install_objects_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_install_objects_fk
                          references wwv_flows,
    security_group_id     number not null
                          constraint wwv_flow_install_objects_fk2
                          references wwv_flow_companies(provisioning_company_id),
    script_id             number  not null
                          constraint wwv_flow_install_objects_fk3
                          references wwv_flow_install_scripts
                          on delete cascade,
    object_owner          varchar2(128),
    object_type           varchar2(30),
    object_name           varchar2(128),
    ---
    last_updated_by       varchar2(255),
    last_updated_on       date,
    created_by            varchar2(255),
    created_on            date
)
/

create index wwv_flow_install_objects_idx1 on wwv_flow_install_objects (flow_id)
/
create index wwv_flow_install_objects_idx2 on wwv_flow_install_objects (security_group_id)
/
create index wwv_flow_install_objects_idx3 on wwv_flow_install_objects (script_id)
/

--==============================================================================
create table wwv_flow_install_checks (
    id                    number
                          constraint wwv_flow_install_checks_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_install_checks_fk
                          references wwv_flows,
    security_group_id     number not null
                          constraint wwv_flow_install_checks_fk2
                          references wwv_flow_companies(provisioning_company_id),
    install_id            number  not null
                          constraint wwv_flow_install_checks_fk3
                          references wwv_flow_install
                          on delete cascade,
    name                  varchar2(255) not null,
    sequence              number not null,
    check_type            varchar2(255),
    check_condition       varchar2(4000),
    check_condition2      varchar2(4000),
    failure_message       varchar2(4000),
    ---
    condition_type        varchar2(255),
    condition             varchar2(4000),
    condition2            varchar2(4000),
    ---
    last_updated_by       varchar2(255),
    last_updated_on       date,
    created_by            varchar2(255),
    created_on            date
)
/

create unique index wwv_flow_install_checks_idx1 on wwv_flow_install_checks (flow_id, name)
/
create index wwv_flow_install_checks_idx2 on wwv_flow_install_checks (security_group_id)
/
create index wwv_flow_install_checks_idx3 on wwv_flow_install_checks (install_id)
/

--==============================================================================
create table wwv_flow_install_build_opt (
    id                    number
                          constraint wwv_flow_install_build_opt_pk
                          primary key,
    flow_id               number not null
                          constraint wwv_flow_install_build_opt_fk
                          references wwv_flows,
    security_group_id     number not null
                          constraint wwv_flow_install_build_opt_fk2
                          references wwv_flow_companies(provisioning_company_id),
    install_id            number  not null
                          constraint wwv_flow_install_build_opt_fk3
                          references wwv_flow_install
                          on delete cascade,
    build_opt_id          number  not null
                          constraint wwv_flow_install_build_opt_fk4
                          references wwv_flow_patches
                          on delete cascade
)
/

create index wwv_flow_install_build_idx1 on wwv_flow_install_build_opt (flow_id)
/
create index wwv_flow_install_build_idx2 on wwv_flow_install_build_opt (security_group_id)
/
create index wwv_flow_install_build_idx3 on wwv_flow_install_build_opt (install_id)
/
create index wwv_flow_install_build_idx4 on wwv_flow_install_build_opt (build_opt_id)
/

--==============================================================================
-- 5.0 feature #1449: supporting objects script lock
--==============================================================================
create table wwv_flow_lock_script (
  id                  number
                      constraint wwv_flow_lock_script_pk
                      primary key,
  flow_id             number not null
                      constraint wwv_flow_lock_script_fk1
                      references wwv_flows,
  security_group_id   number not null
                      constraint wwv_flow_lock_script_fk2
                      references wwv_flow_companies(provisioning_company_id),
  script_id           number  not null
                      constraint wwv_flow_lock_script_fk3
                      references wwv_flow_install_scripts
                      on delete cascade,
  locked_by           varchar2(255),
  locked_on           date,
  lock_comment        varchar2(4000)
  )
/

create index wwv_flow_lock_script_idx1 on wwv_flow_lock_script (flow_id) compress
/
create index wwv_flow_lock_script_idx2 on wwv_flow_lock_script (security_group_id) compress
/
create unique index wwv_flow_lock_script_idx4 on wwv_flow_lock_script (script_id, flow_id) compress
/
create index wwv_flow_lock_script_idx5 on wwv_flow_lock_script (locked_by) compress
/


create table wwv_flow_lock_script_log (
    id                number
                      constraint wwv_flow_lock_script_log_pk
                      primary key,
    flow_id           number not null,
    security_group_id number not null,
    lock_id           number not null,
    script_id         number not null,
    action            varchar2(30) not null
                      constraint wwv_flow_lcksr_log_action_ck
                      check ( action in ('LOCK','UNLOCK','UPDATE','STEAL_LOCK')),
    action_date       date,
    locked_by         varchar2(255),
    lock_comment      varchar2(4000)
    )
/

create index wwv_flow_lock_script_log_idx1 on wwv_flow_lock_script_log (flow_id)
/
create index wwv_flow_lock_script_log_idx2 on wwv_flow_lock_script_log (security_group_id)
/
create index wwv_flow_lock_script_log_idx3 on wwv_flow_lock_script_log (lock_id)
/
create index wwv_flow_lock_script_log_idx4 on wwv_flow_lock_script_log (script_id)
/


--##############################################################################
--#
--# APPLICATION > APPLICATION MODELS
--#
--##############################################################################
prompt APPLICATION > APPLICATION MODELS

--==============================================================================
create table  wwv_flow_models  (
   id                number         not null
                        constraint wwv_flow_models_pk primary key,
   security_group_id number not null
                        constraint wwv_flow_models_fk
                            references wwv_flow_companies(provisioning_company_id)
                            on delete cascade,
   session_id        number not null,
   flow_id           number,
   owner             varchar2(4000),
   name              varchar2(4000),
   model_complete    varchar2(1)
                         constraint wwv_flow_model_complete
                              check (model_complete in (
                                 'Y',
                                 'N')),
   created_by        varchar2(255)  not null,
   created_on        date           not null,
   last_updated_by   varchar2(255),
   last_updated_on   date
)
/

create index wwv_flow_models_sec_group_idx on wwv_flow_models (security_group_id)
/

--==============================================================================
create table  wwv_flow_model_pages (
   id                       number        not null
                                constraint wwv_flow_model_pages_pk primary key,
   model_id                 number        not null
                                constraint wwv_flow_model_pages_fk
                                references wwv_flow_models (id)
                                    on delete cascade,
   page_id                  number,
   parent_page_id           number
                                constraint wwv_flow_model_pages_fk2
                                references wwv_flow_model_pages (id)
                                    on delete cascade,
   display_sequence         number,
   page_type                varchar2(255)
                                constraint wwv_flow_mp_page_type
                                check (page_type in (
                                    'BLANK',
                                    'REPORT',
                                    'LISTVIEW',
                                    'FORM',
                                    'TABULARFORM',
                                    'REPORTANDFORM',
                                    'LISTVIEWANDFORM',
                                    'COLUMNTOGGLE',
                                    'REFLOWTABLE',
                                    'CHART',
                                    'MASTERDETAIL')),
   page_source              varchar2(255)
                                constraint wwv_flow_mp_page_source
                                check (page_source in (
                                    'TABLE',
                                    'QUERY',
                                    'SPREADSHEET')),
   page_name                varchar2(255),
   page_mode                varchar2(20),
   source                   clob,
   block_id                 number,
   report_id                number,
   mig_comments             varchar2(4000),
   security_group_id        number         not null,
   created_by               varchar2(255)  not null,
   created_on               date           not null,
   last_updated_by          varchar2(255),
   last_updated_on          date
)
/

create index wwv_flow_model_pages_model_idx on wwv_flow_model_pages (model_id)
/

create index wwv_flow_mp_parent_page_idx on wwv_flow_model_pages (parent_page_id)
/

create index wwv_flow_mp_block_id_idx on wwv_flow_model_pages (block_id)
/

create index wwv_flow_mp_rep_id_idx on wwv_flow_model_pages (report_id)
/

--==============================================================================
create table wwv_flow_model_page_regions (
   id                       number not null
                                constraint wwv_flow_mpr_pk primary key,
   model_page_id            number not null
                                constraint wwv_flow_mpr_fk
                                references wwv_flow_model_pages (id)
                                on delete cascade,
   region_id                number,
   region_name              varchar2(4000),
   region_source            varchar2(255),
   source                   clob,
   display_sequence         number,
   report_implementation    varchar(30)
                                constraint wwv_flow_mpr_rpt_impl_type
                                check (report_implementation in ( 'CLASSIC','INTERACTIVE','IG')),
   search_enabled           varchar2(1)
                                constraint wwv_flow_mpr_search_enables
                                check (search_enabled in ('Y','N')),
   link_column              varchar2(255),
   link_text                varchar2(255),
   parent_link_from_column1 varchar2(255),
   parent_link_from_column2 varchar2(255),
   link_to_column1          varchar2(255),
   link_to_column2          varchar2(255),
   display_column           varchar2(255),
   supp_info_column         varchar2(255),
   report_filter            varchar2(255),
   column_heading_sorting   varchar2(255),
   download_link            varchar2(255),
   chart_title              varchar2(255),
   chart_type               varchar2(30),
   x_axis_title             varchar2(255),
   y_axis_title             varchar2(255),
   chart_orientation        varchar2(10),
   chart_value_column       varchar2(128),
   chart_label_column       varchar2(128),
   chart_low_column         varchar2(128),
   chart_high_column        varchar2(128),
   chart_open_column        varchar2(128),
   chart_close_column       varchar2(128),
   chart_volume_column      varchar2(128),
   chart_x_column           varchar2(128),
   chart_y_column           varchar2(128),
   chart_z_column           varchar2(128),
   chart_target_column      varchar2(128),
   chart_min_column         varchar2(128),
   chart_max_column         varchar2(128),
   security_group_id        number         not null,
   created_by               varchar2(255)  not null,
   created_on               date           not null,
   last_updated_by          varchar2(255),
   last_updated_on          date
)
/

create index wwv_flow_mpr_model_idx on wwv_flow_model_page_regions (model_page_id)
/

--==============================================================================
create table  wwv_flow_model_page_cols  (
   id                   number         not null
                           constraint wwv_flow_model_page_cols_pk primary key,
   model_region_id        number         not null
                           constraint wwv_flow_model_page_cols_fk
                           references wwv_flow_model_page_regions (id)
                             on delete cascade,
   column_name          varchar2(4000),
   column_display_name  varchar2(4000),
   column_sequence      number,
   help_text            varchar2(4000),
   display_as_form      varchar2(50)
                            constraint wwv_mpc_display_as_form
                            check (display_as_form in (
                                'DISPLAY_ONLY_PLSQL',
                                'FILE',
                                'BUTTON',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'DISPLAY_ONLY_HTML',
                                'STOP_AND_START_HTML_TABLE',
                                'DISPLAY_ONLY_ESCAPE_SC',
                                'IMAGE',
                                'DISPLAY_AND_SAVE',
                                'DISPLAY_AND_SAVE_LOV',
                                'CHECKBOX',
                                'POPUP',
                                'POPUP_FILTER',
                                'POPUP2',
                                'POPUP3',
                                'POPUP4',
                                'POPUP5',
                                'POPUP6',
                                'POPUP_KEY_LOV',
                                'POPUP_KEY_LOV_NOFETCH',
                                'PICK_DATE_USING_FLOW_FORMAT_MASK',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'DISPLAY_ONLY_LOV',
                                'COMBOBOX',
                                'SHOW_AS_SL_WITH_POPUP',
                                'COMBOBOX_WITH_URL_REDIRECT',
                                'COMBOBOX_WITH_BRANCH_TO_PAGE',
                                'COMBOBOX_WITH_SUBMIT',
                                'COMBOBOX_WITH_JS_POST',
                                'COMBOBOX_WITH_JS_REDIRECT',
                                'MULTIPLESELECT',
                                'RADIOGROUP',
                                'RADIOGROUP2',
                                'RADIOGROUP_WITH_REDIRECT',
                                'RADIOGROUP_WITH_SUBMIT',
                                'RADIOGROUP_WITH_JS_SUBMIT',
                                'TEXTAREA',
                                'TEXTAREA_WITH_SPELL_CHECK',
                                'TEXTAREA-AUTO-HEIGHT',
                                'TEXTAREA_WITH_CONTROLS',
                                'TEXTAREA_WITH_HTML_EDITOR_BASIC',
                                'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
                                'TEXTAREA_CHAR_COUNT',
                                'TEXTAREA_CHAR_COUNT_SPELL',
                                'TEXT',
                                'TEXT_WITH_ENTER_SUBMIT',
                                'TEXT_DISABLED',
                                'TEXT_DISABLED_AND_SAVE',
                                'TEXT_WITH_CALCULATOR',
                                'PASSWORD',
                                'PASSWORD_WITH_ENTER_SUBMIT',
                                'PASSWORD_DNSS',
                                'PASSWORD_WITH_SUBMIT_DNSS',
                                'LIST_MGR',
                                'LIST_MGR2',
                                'LIST_MGR3',
                                'LIST_MGR_VIEW',
                                'LIST_MGR_VIEW2',
                                -- 4.0
                                'SELECT_LIST_WITH_POPUP',
                                'TEXT_WITH_SELECT_LIST',
                                'TEXTAREA_WITH_POPUP'
                                ) or
                                display_as_form like 'NATIVE\_%' escape '\'),
   --
   form_attribute_01   varchar2(4000),
   form_attribute_02   varchar2(4000),
   form_attribute_03   varchar2(4000),
   form_attribute_04   varchar2(4000),
   form_attribute_05   varchar2(4000),
   form_attribute_06   varchar2(4000),
   form_attribute_07   varchar2(4000),
   form_attribute_08   varchar2(4000),
   form_attribute_09   varchar2(4000),
   form_attribute_10   varchar2(4000),
   form_attribute_11   varchar2(4000),
   form_attribute_12   varchar2(4000),
   form_attribute_13   varchar2(4000),
   form_attribute_14   varchar2(4000),
   form_attribute_15   varchar2(4000),
   --
   display_as_tab_form varchar2(255)
                            constraint wwv_mpc_display_as_tab_form
                            check (display_as_tab_form in (
                                'READONLY',
                                'DISPLAY_AND_SAVE',
                                'WITHOUT_MODIFICATION',
                                'ESCAPE_SC',
                                'TEXT',
                                'TEXTAREA',
                                'TEXT_FROM_LOV',
                                'SELECT_LIST',
                                'SELECT_LIST_FROM_LOV',
                                'SELECT_LIST_FROM_QUERY',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'POPUP',
                                'POPUP_QUERY',
                                'DATE_POPUP',
                                'DATE_PICKER',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'CHECKBOX',
                                'SIMPLE_CHECKBOX',
                                'RADIOGROUP')),
   datatype             varchar2(4000)
                            constraint datatype
                            check (datatype in ('DATE','NUMBER','TIMESTAMP','TIMESTAMP_LTZ','VARCHAR2','BLOB','CLOB')),
   alignment            varchar2(4000)
                            constraint wwv_flow_mpc_alignment
                            check (alignment in ('LEFT','CENTER','RIGHT')),
   display_width        number,
   max_width            number,
   height               number,
   format_mask          varchar2(4000),
   hidden_column        varchar2(1),
   sort_sequence        number,
   sort_dir             number,        -- new 03/28, values ASC or DESC
   security_group_id    number         not null,
   created_by           varchar2(255)  not null,
   created_on           date           not null,
   last_updated_by      varchar2(255),
   last_updated_on      date
)
/

create index wwv_flow_mpc_mp_idx on wwv_flow_model_page_cols (model_region_id)
/

--##############################################################################
--#
--# WEBSHEET
--#
--##############################################################################
prompt WEBSHEET

--==============================================================================
-- lookup tables
create table wwv_flow_ws_sequences (
    id               number
                     constraint wwv_flow_ws_sequences_pk
                     primary key,
    sequence_name    varchar2(30) not null,
	ddl              varchar2(4000) not null)
/
--==============================================================================

create table wwv_flow_ws_tables (
   id                number
                     constraint wwv_flow_ws_tables_pk
                     primary key,
   table_name        varchar2(30) not null,
   install_seq       number not null,
   drop_seq          number not null,
   has_constraints   varchar2(1) not null
                     constraint wwv_flow_ws_tables_ck1
                     check (has_constraints in ('Y','N')),
   has_triggers      varchar2(1) not null
                     constraint wwv_flow_ws_tables_ck2
                     check (has_triggers in ('Y','N')),
   ddl               clob not null)
/

--==============================================================================
create table wwv_flow_ws_tab_columns (
   id                number
                     constraint wwv_flow_ws_tab_columns_pk
                     primary key,
   table_name        varchar2(30) not null,
   column_name       varchar2(30) not null,
   data_type         varchar2(255),
   data_length       number,
   nullable          varchar2(1)
                     constraint wwv_flow_ws_tab_cols_null_ck
                     check (nullable in ('Y','N')),
   data_default      varchar2(255))
/

--==============================================================================
create table wwv_flow_ws_indexes (
   id                number
                     constraint wwv_flow_ws_indexes_pk
                     primary key,
   table_name        varchar2(30) not null,
   index_name        varchar2(30) not null,
   ddl               varchar2(4000) not null)
/

--==============================================================================
create table wwv_flow_ws_ind_columns (
   id                number
                     constraint wwv_flow_ws_ind_columns_pk
                     primary key,
   index_name        varchar2(30) not null,
   table_name        varchar2(30) not null,
   column_name       varchar2(4000) not null,
   column_position   number not null)
/


create table wwv_flow_ws_constraints (
   id                number
                     constraint wwv_flow_ws_constraints_pk
                     primary key,
   table_name        varchar2(30) not null,
   constraint_name   varchar2(30) not null,
   constraint_type   varchar2(1),
   column_name       varchar2(4000),
   search_condition  clob,
   r_table_name      varchar2(30),
   r_column_name     varchar2(30),
   delete_rule       varchar2(9))
/

--==============================================================================
create table wwv_flow_ws_triggers (
   id                number
                     constraint wwv_flow_ws_triggers_pk
                     primary key,
   trigger_name      varchar2(30),
   trigger_type      varchar2(16),
   triggering_event  varchar2(227),
   table_name        varchar2(30),
   trigger_body      clob)
/

--==============================================================================
create table wwv_flow_ws_applications (
    id                            number
                                  constraint wwv_flow_ws_applications_pk
                                  primary key,
    name                          varchar2(255) not null,
    owner                         varchar2(255)  not null,
    description                   varchar2(4000),
    status                        varchar2(30)
                                  constraint wwv_flow_ws_app_status_ck
                                  check (status in (
                                  'AVAILABLE',
                                  'DEVELOPERS_ONLY',
                                  'UNAVAILABLE')),
    date_format                   varchar2(255),
    language                      varchar2(255),
    territory                     varchar2(255),
    home_page_id                  number,
    --
    page_style                    number,
    custom_css                    varchar2(4000),
    --
    auth_id                       number,
    acl_type                      varchar2(30)
                                  constraint wwv_flow_ws_app_acl_typ_ck
                                  check (acl_type in (
                                  'DEFAULT',
                                  'CUSTOM')),
    login_url                     varchar2(2000),
    logout_url                    varchar2(2000),
    allow_sql_YN                  varchar2(1),
    --
    show_reset_passwd_yn          varchar2(1)
                                  constraint wwv_flow_ws_app_rpwd_ck
                                  check(show_reset_passwd_yn in ('Y','N')),
    --
    show_peer_navigation_yn       varchar2(1),
    show_child_navigation_yn      varchar2(1),
    show_annotations_control_yn   varchar2(1),
    allow_public_access_yn        varchar2(1)
                                  constraint wwv_flow_ws_app_allow_pub_ck
                                  check(allow_public_access_yn in ('Y','N')),
    --
    login_page_message            varchar2(4000),
    --
    logo_type                     varchar2(30)
                                     constraint wwv_flow_ws_app_logo_ck
                                     check (logo_type in (
                                     'NONE','TEXT','IMAGE','FILEPATH')),
    logo_text                     varchar2(500),
    logo_text_attributes          varchar2(4000),
    logo_image                    blob,
    logo_image_filename           varchar2(255),
    logo_image_mimetype           varchar2(255),
    logo_image_charset            varchar2(255),
    logo_image_last_update        date,
    logo_image_attributes         varchar2(4000),
    logo_filepath                 varchar2(4000),
    logo_filepath_attributes      varchar2(4000),
    --
    application_type              varchar2(30) default 'STANDARD'
                                  constraint wwv_flow_ws_app_type
                                  check (application_type in ('STANDARD','TEMPLATE','SAMPLE','TEMPLATE_HIDDEN')),
    --
    email_from                    varchar2(255),
    --
    created_by                    varchar2(255) not null,
    created_on                    date not null,
    updated_by                    varchar2(255),
    updated_on                    date,
    --
    security_group_id             number not null
                                  constraint wwv_flow_ws_applications_fk
                                  references wwv_flow_companies(provisioning_company_id)
                                  on delete cascade
    )
/

create index wwv_flow_ws_app_idx on wwv_flow_ws_applications (security_group_id)
/

create index wwv_flow_ws_app_idx2 on wwv_flow_ws_applications (auth_id)
/

--==============================================================================
-- Websheet attributes
create table wwv_flow_ws_websheet_attr (
     id                     number
                            constraint wwv_flow_ws_websheet_attr_pk
                            primary key,
     ws_app_id              number not null
                            constraint wwv_flow_ws_websheet_attr_fk2
                            references wwv_flow_ws_applications(id)
                            on delete cascade,
     worksheet_id           number not null
                            constraint wwwv_flow_ws_websheet_attr_fk
                            references wwv_flow_worksheets(id)
                            on delete cascade,
     status                 varchar2(255)
                            constraint wwv_flow_ws_attr_status_ck
                            check (status in (
                            'PRIVATE',
                            'PROJECT')),
     --
     publish_yn            varchar2(1)
                           constraint wwv_flow_ws_attr_publish_ck
                           check (publish_yn in ('Y','N')),
     --
     websheet_name          varchar2(255) not null,
     websheet_alias         varchar2(255) not null,
     websheet_type          varchar2(255) not null
                            constraint wwv_flow_ws_attr_ws_type_ck
                            check (websheet_type in (
                            'DATA',
                            'REPORT',
                            'TEMPLATE')),
     is_template            varchar2(1),  -- cbcho: remove, obsolete
     --
     ws_report_owner        varchar2(255), -- schema for websheet report query defined in wwv_flow_worksheets.sql_query
     -- column security
     websheet_owner         varchar2(255),
     view_only_columns      varchar2(4000),
     username_in_columns    varchar2(4000),
     parent_column          varchar2(4000),
     child_column           varchar2(4000),
     -- columns identify the row (PK)
     row_pk1                varchar2(128),
     row_pk2                varchar2(128),
     row_pk3                varchar2(128),
     -- geocoding columns, rest URL style
     geo_url                varchar2(4000),
     geo_proxy              varchar2(4000),
     geo_addr_sep           varchar2(30),
     geo_resp_type          varchar2(30)
                            constraint wwv_flow_ws_attr_resp_ck
                            check (geo_resp_type in ('XML','TEXT')),
     geo_resp_ns            varchar2(4000),
     geo_path_to_lat        varchar2(4000),
     geo_path_to_long       varchar2(4000),
     geo_resp_sep           varchar2(30),
     --
     created_on             date not null,
     created_by             varchar2(255) not null,
     updated_on             date,
     updated_by             varchar2(255),
     security_group_id      number not null
)
/

create unique index  wwv_flow_ws_attr_unq_idx1 on wwv_flow_ws_websheet_attr
    (security_group_id, websheet_type,ws_app_id,websheet_alias)
/

create unique index  wwv_flow_ws_attr_unq_idx2 on wwv_flow_ws_websheet_attr
    (security_group_id, websheet_type,ws_app_id,websheet_name)
/

create index wwv_flow_ws_attr_idx1 on wwv_flow_ws_websheet_attr (worksheet_id)
/

create index wwv_flow_ws_attr_idx2 on wwv_flow_ws_websheet_attr (ws_app_id)
/

--==============================================================================
create table wwv_flow_ws_app_sug_objects (
    id                     number
                           constraint wwwv_flow_ws_app_so_pk
                           primary key,
    ws_app_id              number not null
                           constraint wwv_flow_ws_app_so_fk1
                           references wwv_flow_ws_applications(id)
                           on delete cascade,
    object_name            varchar2(128)  not null,
    object_comment         varchar2(255),
     --
    security_group_id      number not null,
    last_updated_by        varchar2(255),
    last_updated_on        date,
    created_by             varchar2(255),
    created_on             date)
/

create index wwv_flow_ws_app_so_idx1 on wwv_flow_ws_app_sug_objects (security_group_id);
create index wwv_flow_ws_app_so_idx2 on wwv_flow_ws_app_sug_objects (ws_app_id);

--==============================================================================
-- websheet authentication
create table wwv_flow_ws_custom_auth_setups(
    id                                                 number
        constraint wwv_flow_ws_auth_setups_pk
        primary key,
    websheet_application_id                            number not null
        constraint wwv_flow_ws_auth_setups_fk
        references wwv_flow_ws_applications on delete cascade,
    reference_id                                       number,
    name                                               varchar2(255) not null,
    description                                        varchar2(4000),
    page_sentry_function                               clob,
    sess_verify_function                               clob,
    invalid_session_page                               number,
    invalid_session_url                                varchar2(4000),
    pre_auth_process                                   clob,
    auth_function                                      clob,
    post_auth_process                                  clob,
    cookie_name                                        varchar2(4000),
    cookie_path                                        varchar2(4000),
    cookie_domain                                      varchar2(4000),
    use_secure_cookie_yn                               varchar2(1)
                                                       constraint wwv_flow_ws_custom_auth_chk1
                                                       check (use_secure_cookie_yn in ('Y','N')),
    --
    ldap_host                                          varchar(255),
    ldap_port                                          varchar(255),
    ldap_string                                        varchar(255),
    ldap_search_filter                                 varchar2(255),
    ldap_edit_function                                 varchar2(4000),
    ldap_username_escaping                             varchar2(4)
                                                       constraint wwv_flow_ws_ldap_useresc_chk1
                                                       check (ldap_username_escaping in ('STD','ONLY','NO')),
    ldap_use_ssl                                       varchar2(1)
                                                       constraint wwv_flow_ws_ldap_use_ssl_chk1
                                                       check (ldap_use_ssl in ('Y','N','A')),
    ldap_use_exact_dn                                  varchar2(1)
                                                       constraint wwv_flow_ws_ldap_use_exdn_chk1
                                                       check (ldap_use_exact_dn in ('Y','N')),
    logout_url                                         varchar2(4000),
    --
    required_patch                                     number,
    security_group_id                                  number not null,
    last_updated_by                                    varchar2(255),
    last_updated_on                                    date,
    created_by                                         varchar2(255),
    created_on                                         date)
    lob (page_sentry_function, sess_verify_function, pre_auth_process, auth_function, post_auth_process) store as (cache reads enable storage in row)
/
create index wwv_flow_ws_auth_setups_idx1 on wwv_flow_ws_custom_auth_setups (WEBSHEET_APPLICATION_ID);

--##############################################################################
--#
--# WORKSHEETS (INTERACTIVE REPORTS)
--#
--##############################################################################
prompt WORKSHEETS (INTERACTIVE REPORTS)
--==============================================================================
create table wwv_flow_worksheet_categories (
    id                     number
                           constraint wwv_flow_worksheet_cat_pk
                           primary key,
    worksheet_id           number not null,
    flow_id                number not null,
    base_cat_id            number,
    application_user       varchar2(255),
    name                   varchar2(255),
    display_sequence       number,
    --
    created_on             date,
    created_by             varchar2(255),
    updated_on             date,
    updated_by             varchar2(255),
    security_group_id      number        not null
    )
/

alter table wwv_flow_worksheet_categories
    add constraint wwv_flow_worksheet_cat_fk
    foreign key( security_group_id ) references wwv_flow_companies(provisioning_company_id)
    on delete cascade
/

alter table wwv_flow_worksheet_categories
   add constraint wwv_flow_worksheet_cat_fk2
    foreign key( flow_id ) references wwv_flows(id)
    on delete cascade
/

create index wwv_flow_worksheet_cat_idx1 on wwv_flow_worksheet_categories (security_group_id)
/

create index wwv_flow_worksheet_cat_idx2 on wwv_flow_worksheet_categories (flow_id)
/

--==============================================================================
create table wwv_flow_worksheet_col_groups (
    id                  number        not null,
    flow_id             number        not null
                        constraint wwv_flow_worksheet_col_grp_fk
                        references wwv_flows
                        on delete cascade,
    worksheet_id        number        not null,
    websheet_id         number
                        constraint wwv_flow_worksheet_col_grp_fk2
                        references wwv_flow_ws_websheet_attr(id)
                        on delete cascade,
    name                varchar2(255) not null,
    description         varchar2(4000),
    display_sequence    number not null,
    --
    created_on          date,
    created_by          varchar2(255),
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_col_groups
    add constraint wwv_flow_worksheet_col_grps_pk
    primary key(id)
/

alter table wwv_flow_worksheet_col_groups
    add constraint wwv_flow_worksheet_col_grws_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_col_groups
    add constraint wwv_flow_worksheet_col_grps_uk
    unique(worksheet_id, name) deferrable initially deferred
/

create index wwv_flow_ws_col_grps_idx1 on wwv_flow_worksheet_col_groups (flow_id)
/

create index wwv_flow_ws_col_grps_idx2 on wwv_flow_worksheet_col_groups (websheet_id)
/

--==============================================================================
create table wwv_flow_worksheet_lovs (
    id                  number        not null,
    worksheet_id        number        not null,
    websheet_id         number
                        constraint wwv_flow_worksheet_lovs_fk2
                        references wwv_flow_ws_websheet_attr(id)
                        on delete cascade,
    name                varchar2(255) not null,
    security_group_id   number        not null,
    --
    created_on          date,
    created_by          varchar2(255),
    updated_on          date,
    updated_by          varchar2(255)
    )
/

alter table wwv_flow_worksheet_lovs
    add constraint wwv_flow_worksheet_lovs_pk
    primary key(id)
/

alter table wwv_flow_worksheet_lovs
    add constraint wwv_flow_worksheet_lovs_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_lovs
    add constraint wwv_flow_worksheet_lovs_uk
    unique(worksheet_id, name)
/

create index wwv_flow_worksheet_lov_idx on wwv_flow_worksheet_lovs (websheet_id)
/

--==============================================================================
create table wwv_flow_worksheet_lov_entries (
    id                  number        not null,
    worksheet_id        number        not null,
    websheet_id         number
                        constraint wwv_flow_worksheet_lov_ent_fk3
                        references wwv_flow_ws_websheet_attr(id)
                        on delete cascade,
    lov_id              number        not null,
    display_sequence    number        not null,
    entry_text          varchar2(255) not null,
    security_group_id   number        not null,
    --
    created_on          date,
    created_by          varchar2(255),
    updated_on          date,
    updated_by          varchar2(255)
    )
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_worksheet_lov_ent_pk
    primary key(id)
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_worksheet_lov_ent_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_worksheet_lov_ent_fk2
    foreign key( lov_id ) references wwv_flow_worksheet_lovs(id)
    on delete cascade
/

alter table wwv_flow_worksheet_lov_entries
    add constraint wwv_flow_ws_lov_ents_uk
    unique(lov_id, entry_text)
/

create index wwv_flow_ws_lov_ent_idx1 on wwv_flow_worksheet_lov_entries (worksheet_id);

create index wwv_flow_ws_lov_ent_idx2 on wwv_flow_worksheet_lov_entries (websheet_id);

--==============================================================================
create table wwv_flow_worksheet_columns (
    id                  number    not null,
    flow_id             number    not null
                        constraint wwv_flow_worksheet_col_fk
                        references wwv_flows
                        on delete cascade,
    page_id             number,
    worksheet_id        number    not null,
    websheet_id         number
                        constraint wwv_flow_worksheet_col_fk2
                        references wwv_flow_ws_websheet_attr(id)
                        on delete cascade,
    db_column_name      varchar2(128) not null,
    display_order       number    not null,
    data_grid_form_seq  number,
    group_id            number,
    column_identifier   varchar2(10) not null,
    column_expr         varchar2(4000),
    -- label
    column_label        varchar2(4000),
    report_label        varchar2(4000) not null,
    sync_form_label     varchar2(1) not null
                        constraint wwv_flow_val_wscol_sync_lab
                        check (sync_form_label in ('Y','N')),
    -- display
    display_in_default_rpt varchar2(1)
                           constraint wwv_flow_ws_display_col
                           check (display_in_default_rpt in ('Y','N')),
    column_html_expression varchar2(4000),
    column_link            varchar2(4000),
    column_linktext        varchar2(4000),
    column_link_attr       varchar2(4000),
    column_link_checksum_type varchar2(255)
                              constraint wwv_flow_ws_checksum_type
                              check (column_link_checksum_type in (
                              '1', -- workspace
                              '2', -- user
                              '3'  -- session
                              )),
    is_sortable         varchar2(1)
                        constraint wwv_flow_ws_col_sort_ck
                        check (is_sortable in ('Y','N')),
    allow_sorting       varchar2(1) not null
                        constraint wwv_flow_ws_col_sorting_ck
                        check (allow_sorting in ('Y','N')),
    allow_filtering     varchar2(1) not null
                        constraint wwv_flow_ws_col_filter_ck
                        check (allow_filtering in ('Y','N')),
    allow_highlighting  varchar2(1) not null
                        constraint wwv_flow_ws_col_highlight_ck
                        check (allow_highlighting in ('Y','N')),
    allow_ctrl_breaks   varchar2(1) not null
                        constraint wwv_flow_ws_col_ctrl_ck
                        check (allow_ctrl_breaks in ('Y','N')),
    allow_aggregations  varchar2(1) not null
                        constraint wwv_flow_ws_col_agg_ck
                        check (allow_aggregations in ('Y','N')),
    allow_computations  varchar2(1) not null
                        constraint wwv_flow_ws_col_comp_ck
                        check (allow_computations in ('Y','N')),
    allow_charting      varchar2(1) not null
                        constraint wwv_flow_ws_col_chart_ck
                        check (allow_charting in ('Y','N')),
    allow_group_by      varchar2(1) not null
                        constraint wwv_flow_ws_col_group_by_ck
                        check (allow_group_by in ('Y','N')),
    allow_pivot         varchar2(1) default 'N' not null
                        constraint wwv_flow_ws_col_pivot_ck
                        check (allow_pivot in ('Y','N')),
    allow_hide          varchar2(1) not null
                        constraint wwv_flow_ws_col_hide_ck
                        check (allow_hide in ('Y','N')),
    -- column filters
    use_custom          varchar2(1),
    custom_filter       varchar2(4000),
    base_column         varchar2(128),
    allow_filters       varchar2(1),
    -- security
    others_may_edit     varchar2(1),
    others_may_view     varchar2(1),
    -- display controls
    column_type         varchar2(255) not null
                        constraint wwv_flow_valid_ws_col_type
                        check (column_type in (
                        'STRING',
                        'DATE',
                        'NUMBER',
                        'CLOB',
                        'FILE',
                        'COMPUTED',
                        'DETAIL_LINK',
                        'OTHER')),
    display_as          varchar2(255)
                        constraint wwv_flow_ws_col_disp_as_ck
                        check (display_as in (
                        'READONLY',
                        'TEXT',
                        'TEXTAREA',
                        'SELECTLIST',
                        'CHECKBOX',
                        'RADIOGROUP',
                        'POPUP_LOV',
                        'DATE_PICKER')),
    display_text_as     varchar2(255) not null
                        constraint wwv_flow_ws_col_disp_txt_as_ck
                        check (display_text_as in (
                        'WITHOUT_MODIFICATION',
                        'ESCAPE_SC',
                        'STRIP_HTML_ESCAPE_SC',
                        'LOV_ESCAPE_SC',
                        'HIDDEN')),
    heading_alignment   varchar2(255) not null
                        constraint wwv_flow_ws_col_head_al_ck
                        check (heading_alignment in (
                        'LEFT',
                        'RIGHT',
                        'CENTER')),
    column_alignment    varchar2(255) not null
                        constraint wwv_flow_ws_col_col_al_ck
                        check (column_alignment in (
                        'LEFT',
                        'RIGHT',
                        'CENTER')),
    max_length          number,
    display_width       integer,
    display_height      integer,
    allow_null          varchar2(1)
                        constraint wwv_flow_wscol_allow_null
                        check (allow_null in ('Y','N')),
    format_mask         varchar2(255),
    tz_dependent        varchar2(1)
                        constraint wwv_flow_ws_col_tz_dep_ck
                        check (tz_dependent in ('Y','N')),
    static_id           varchar2(255),
    css_classes         varchar2(255),
    -- warehouse
    fact_table_key        varchar2(255),
    dimension_table       varchar2(255),
    dimension_table_id    varchar2(255),
    dimension_table_value varchar2(255),
    -- report list of values
    rpt_distinct_lov    varchar2(1)
                        constraint wwv_flow_wscol_lov
                        check (rpt_distinct_lov in ('Y','N')),
    rpt_lov             varchar2(4000),
    rpt_named_lov       number,
    rpt_show_filter_lov varchar2(1)
                        constraint wwv_flow_wscol_showfil_lov_ck
                        check (rpt_show_filter_lov in ('D','S','N','C','1','2')),
    rpt_filter_date_ranges varchar2(255)
                        constraint wwv_flow_wscol_fil_dtrng_ck
                        check (rpt_filter_date_ranges in ('ALL','PAST','FUTURE')),
    -- form list of values
    static_lov          varchar2(4000),
    lov_null_text       varchar2(255),
    lov_allow_new_values varchar2(1)
                        constraint wwv_flow_ws_lov_allow_new
                        check (lov_allow_new_values in ('Y','N')),
    lov_is_distinct_values varchar2(1)
                        constraint wwv_flow_ws_lov_distinct_vals
                        check (lov_is_distinct_values in ('Y','N')),
    lov_num_columns     number,
    lov_id              number,
    --
    computation_type    varchar2(255),
    computation_expr_1  varchar2(4000),
    computation_expr_2  varchar2(4000),
    --
    validation_type     varchar2(255),
    validation_expr_1   varchar2(4000),
    validation_expr_2   varchar2(4000),
    --
    display_condition_type    varchar2(255),
    display_condition         varchar2(4000),
    display_condition2        varchar2(4000),
    -- default values
    default_value       varchar2(4000),
    default_when        varchar2(30),
    --
    help_text           varchar2(4000),
    --
    security_scheme     varchar2(255),
    --
    column_flags        varchar2(4000),
    column_comment      varchar2(4000),
    --
    required_patch      number,--
    --
    created_on          date,
    created_by          varchar2(255),
    updated_on          date,
    updated_by          varchar2(255),
    security_group_id   number        not null
    )
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_columns_pk
    primary key(id)
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_columns_fk
    foreign key( worksheet_id ) references wwv_flow_worksheets(id)
    on delete cascade
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_col_grps_fk
    foreign key( group_id ) references wwv_flow_worksheet_col_groups(id)
    on delete set null
/

alter table wwv_flow_worksheet_columns
    add constraint wwv_flow_worksheet_columns_uk2
    unique(worksheet_id, db_column_name) deferrable initially deferred
/

create index wwv_flow_worksheet_cols_idx1 on wwv_flow_worksheet_columns (worksheet_id, column_identifier);
create index wwv_flow_worksheet_cols_idx2 on wwv_flow_worksheet_columns (flow_id);
create index wwv_flow_worksheet_cols_idx3 on wwv_flow_worksheet_columns (group_id);
create index wwv_flow_worksheet_cols_idx4 on wwv_flow_worksheet_columns (websheet_id);
create index wwv_flow_worksheet_cols_idx5 on wwv_flow_worksheet_columns (rpt_named_lov,flow_id);

--==============================================================================
-- Reports
create table wwv_flow_worksheet_rpts (
    id                     number not null,
    worksheet_id           number not null,
    websheet_id            number
                           constraint wwv_flow_ws_rpt_fk
                           references wwv_flow_ws_websheet_attr(id)
                           on delete cascade,
    flow_id                number not null,
    page_id                number not null,
    session_id             number,
    tenant_id              varchar2(32),
    base_report_id         number,
    application_user       varchar2(255),
    name                   varchar2(255),
    description            varchar2(4000),
    report_seq             number not null,
    report_type            varchar2(255),
    report_alias           varchar2(255),
    status                 varchar2(30)
                           constraint wwv_flow_ws_rpt_status_ck
                           check (status in (
                           'PRIVATE',
                           'PUBLIC')),
    view_mode              varchar2(30)
                           constraint wwv_flow_ws_rpt_vm_ck
                           check (view_mode in ('REPORT','ICON','DETAIL')),
    category_id            number,
    autosave               varchar2(1),
    is_default             varchar2(1) not null
                           constraint wwv_flow_ws_rpt_def_ck
                           check (is_default in (
                           'Y',
                           'N')),
    -- column display
    display_rows           number,
    pagination_min_row     number,
    report_columns         varchar2(4000),
    -- sorting
    sort_column_1          varchar2(255),
    sort_direction_1       varchar2(255),
    sort_column_2          varchar2(255),
    sort_direction_2       varchar2(255),
    sort_column_3          varchar2(255),
    sort_direction_3       varchar2(255),
    sort_column_4          varchar2(255),
    sort_direction_4       varchar2(255),
    sort_column_5          varchar2(255),
    sort_direction_5       varchar2(255),
    sort_column_6          varchar2(255),
    sort_direction_6       varchar2(255),
    -- control break
    break_on               varchar2(4000),
    break_enabled_on       varchar2(4000),
    control_break_options  varchar2(255),
    -- aggregation
    sum_columns_on_break   varchar2(4000),
    avg_columns_on_break   varchar2(4000),
    max_columns_on_break   varchar2(4000),
    min_columns_on_break   varchar2(4000),
    median_columns_on_break varchar2(4000),
    mode_columns_on_break  varchar2(4000),
    count_columns_on_break varchar2(4000),
    count_distnt_col_on_break varchar2(4000),
    -- flashback
    flashback_mins_ago     varchar2(255),
    flashback_enabled      varchar2(1) not null
                           constraint wwv_flow_ws_rpt_fb_ck
                           check (flashback_enabled in (
                           'Y',
                           'N')),
    -- chart
    chart_type             varchar2(255),
    chart_3d               varchar2(1),
    chart_label_column     varchar2(255),
    chart_label_title      varchar2(255),
    chart_value_column     varchar2(255),
    chart_aggregate        varchar2(255)
                           constraint wwv_flow_ws_rpt_chart_agg_ck
                           check (chart_aggregate in (
                           'SUM',
                           'AVG',
                           'MIN',
                           'MAX',
                           'COUNT')),
    chart_value_title      varchar2(255),
    chart_sorting          varchar2(30)
                           constraint wwv_flow_ws_rpt_chrt_ck
                           check (chart_sorting in (
                           'DEFAULT',
                           'VALUE_DESC',
                           'VALUE_ASC',
                           'LABEL_DESC',
                           'LABEL_ASC')),
    chart_orientation      varchar2(10)
                           constraint wwv_flow_ws_rpt_chrt_or_ck
                           check (chart_orientation in (
                           'vertical',
                           'horizontal')),
    -- calendar
    calendar_date_column    varchar2(255),
    calendar_display_column varchar2(255),
    -- audit
    created_on             date,
    created_by             varchar2(255),
    updated_on             date,
    updated_by             varchar2(255),
    security_group_id      number        not null
    )
/


alter table wwv_flow_worksheet_rpts
    add constraint wwv_flow_worksheet_rpts_pk
    primary key(id)
/

alter table wwv_flow_worksheet_rpts
    add constraint wwv_flow_worksheet_rpts_fk
    foreign key ( category_id ) references wwv_flow_worksheet_categories(id)
/

alter table wwv_flow_worksheet_rpts
    add constraint wwv_flow_worksheet_rpts_fk2
    foreign key( security_group_id ) references wwv_flow_companies(provisioning_company_id)
    on delete cascade
/

create index wwv_flow_ws_rpts_idx on wwv_flow_worksheet_rpts (worksheet_id, is_default);
create index wwv_flow_ws_rpts_idx2 on wwv_flow_worksheet_rpts (websheet_id);
create index wwv_flow_ws_rpts_idx3 on wwv_flow_worksheet_rpts (session_id,websheet_id);
create index wwv_flow_ws_rpts_idx4 on wwv_flow_worksheet_rpts ( session_id, worksheet_id, application_user );
create index wwv_flow_ws_base_rpt_idx on wwv_flow_worksheet_rpts (base_report_id, application_user);
create index wwv_flow_ws_cat_rpt_idx on wwv_flow_worksheet_rpts (category_id);
create index wwv_flow_ws_rpts_sgid_idx on wwv_flow_worksheet_rpts (security_group_id);


create unique index  wwv_flow_worksheet_rpts_uk on wwv_flow_worksheet_rpts
    (case when session_id is null then worksheet_id end,
     case when session_id is null then application_user end,
     case when session_id is null then category_id end,
     case when session_id is null then name end)
/

--==============================================================================
create table wwv_flow_worksheet_conditions (
     id                  number not null,
     flow_id             number not null,
     page_id             number,
     worksheet_id        number not null,
     websheet_id         number
                         constraint wwv_flow_ws_condition_fk
                         references wwv_flow_ws_websheet_attr(id)
                         on delete cascade,
     report_id           number not null,
     name                varchar2(255),
     condition_type      varchar2(255)
                         constraint wwv_flow_ws_c_type_ck
                         check (condition_type in ('FILTER','HIGHLIGHT','SEARCH')),
     allow_delete        varchar2(1) not null
                         constraint wwv_flow_ws_c_del_ck
                         check (allow_delete in ('Y','N','R')), -- R = Filter can be replaced by another on the same column
     -- filter expression
     column_name         varchar2(4000),
     operator            varchar2(30),
     expr_type           varchar2(255),
     expr                varchar2(4000),
     expr2               varchar2(4000),
     time_zone           varchar2(100),
     condition_sql       varchar2(4000),
     condition_display   varchar2(4000),
     -- enabled?
     enabled             varchar2(1) not null
                         constraint wwv_flow_ws_c_enabled_ck
                         check (enabled in ('Y','N')),
     -- highlighting settings
     highlight_sequence  number,
     row_bg_color        varchar2(255),
     row_font_color      varchar2(255),
     row_format          varchar2(3),
     column_bg_color     varchar2(255),
     column_font_color   varchar2(255),
     column_format       varchar2(3),
     -- audit
     created_on          date,
     created_by          varchar2(255),
     updated_on          date,
     updated_by          varchar2(255),
     security_group_id   number not null
     )
/

alter table wwv_flow_worksheet_conditions
    add constraint wwv_flow_worksheet_cond_pk
    primary key(id)
/

alter table wwv_flow_worksheet_conditions
    add constraint wwv_flow_worksheet_cond_fk
    foreign key ( report_id ) references wwv_flow_worksheet_rpts(id)
    on delete cascade
/

create unique index wwv_flow_worksheet_cond_uk2 on wwv_flow_worksheet_conditions
    (report_id,
     substr(condition_type,1,30),
     substr(column_name,1,30),
     operator,
     substr(expr,1,250),
     substr(expr2,1,100))
/

create index wwv_flow_ws_conditions_idx on wwv_flow_worksheet_conditions (worksheet_id, report_id, security_group_id, condition_type )
/

create index wwv_flow_ws_conditions_idx2 on wwv_flow_worksheet_conditions (websheet_id)
/

--==============================================================================
create table wwv_flow_worksheet_computation (
     id                  number not null,
     flow_id             number not null,
     page_id             number,
     worksheet_id        number not null,
     websheet_id         number
                         constraint wwv_flow_ws_computation_fk
                         references wwv_flow_ws_websheet_attr(id)
                         on delete cascade,
     report_id           number not null,
     --
     db_column_name      varchar2(128) not null,
     column_identifier   varchar2(10) not null,
     computation_expr    varchar2(4000),
     format_mask         varchar2(255),
     column_type         varchar2(255)
                         constraint wwv_flow_valid_ws_comp_type
                         check (column_type in (
                         'STRING',
                         'DATE',
                         'NUMBER',
                         'CLOB',
                         'OTHER')),
     -- label
     column_label        varchar2(4000) not null,
     report_label        varchar2(4000) not null,
     -- audit
     created_on          date,
     created_by          varchar2(255),
     updated_on          date,
     updated_by          varchar2(255),
     security_group_id   number not null
     )
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_pk
    primary key(id)
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_fk
    foreign key ( report_id ) references wwv_flow_worksheet_rpts(id)
    on delete cascade
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_uk
    unique(report_id, db_column_name)
/

alter table wwv_flow_worksheet_computation
    add constraint wwv_flow_ws_comp_cols_uk2
    unique(report_id, column_identifier)
/

create index wwv_flow_ws_comp_cols_idx on wwv_flow_worksheet_computation (worksheet_id)
/

create index wwv_flow_ws_com_cols_idx2 on wwv_flow_worksheet_computation (websheet_id)
/

--==============================================================================
create table wwv_flow_worksheet_group_by (
     id                         number not null
                                constraint wwv_flow_ws_groupby_pk
                                primary key,
     flow_id                    number not null,
     page_id                    number,
     worksheet_id               number not null,
     websheet_id                number
                                constraint wwv_flow_ws_groupby_fk
                                references wwv_flow_ws_websheet_attr(id)
                                on delete cascade,
     report_id                  number not null
                                constraint wwv_flow_ws_groupby_fk2
                                references wwv_flow_worksheet_rpts(id)
                                on delete cascade,
     --
     group_by_columns           varchar2(4000),
     -- audit
     created_on                 date,
     created_by                 varchar2(255),
     updated_on                 date,
     updated_by                 varchar2(255),
     security_group_id          number not null,
     --
     function_01                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn1_ck
                                check (function_01 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_01         varchar2(255),
     function_db_column_name_01 varchar2(128),
     function_label_01          varchar2(4000),
     function_format_mask_01    varchar2(255),
     function_sum_01            varchar2(1),
     --
     function_02                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn2_ck
                                check (function_02 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_02         varchar2(255),
     function_db_column_name_02 varchar2(128),
     function_label_02          varchar2(4000),
     function_format_mask_02    varchar2(255),
     function_sum_02            varchar2(1),
     --
     function_03                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn3_ck
                                check (function_03 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_03         varchar2(255),
     function_db_column_name_03 varchar2(128),
     function_label_03          varchar2(4000),
     function_format_mask_03    varchar2(255),
     function_sum_03            varchar2(1),
     --
     function_04                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn4_ck
                                check (function_04 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_04         varchar2(255),
     function_db_column_name_04 varchar2(128),
     function_label_04          varchar2(4000),
     function_format_mask_04    varchar2(255),
     function_sum_04            varchar2(1),
     --
     function_05                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn5_ck
                                check (function_05 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_05         varchar2(255),
     function_db_column_name_05 varchar2(128),
     function_label_05          varchar2(4000),
     function_format_mask_05    varchar2(255),
     function_sum_05            varchar2(1),
     --
     function_06                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn6_ck
                                check (function_06 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_06         varchar2(255),
     function_db_column_name_06 varchar2(128),
     function_label_06          varchar2(4000),
     function_format_mask_06    varchar2(255),
     function_sum_06            varchar2(1),
     --
     function_07                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn7_ck
                                check (function_07 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_07         varchar2(255),
     function_db_column_name_07 varchar2(128),
     function_label_07          varchar2(4000),
     function_format_mask_07    varchar2(255),
     function_sum_07            varchar2(1),
     --
     function_08                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn8_ck
                                check (function_08 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_08         varchar2(255),
     function_db_column_name_08 varchar2(128),
     function_label_08          varchar2(4000),
     function_format_mask_08    varchar2(255),
     function_sum_08            varchar2(1),
     --
     function_09                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn9_ck
                                check (function_09 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_09         varchar2(255),
     function_db_column_name_09 varchar2(128),
     function_label_09          varchar2(4000),
     function_format_mask_09    varchar2(255),
     function_sum_09            varchar2(1),
     --
     function_10                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn10_ck
                                check (function_10 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_10         varchar2(255),
     function_db_column_name_10 varchar2(128),
     function_label_10          varchar2(4000),
     function_format_mask_10    varchar2(255),
     function_sum_10            varchar2(1),
     --
     function_11                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn11_ck
                                check (function_11 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_11         varchar2(255),
     function_db_column_name_11 varchar2(128),
     function_label_11          varchar2(4000),
     function_format_mask_11    varchar2(255),
     function_sum_11            varchar2(1),
     --
     function_12                varchar2(255)
                                constraint wwv_flow_ws_grpby_funtn12_ck
                                check (function_12 in (
                                'SUM',
                                'AVG',
                                'MAX',
                                'MIN',
                                'MEDIAN',
                                'COUNT',
                                'COUNT_DISTINCT',
                                'RATIO_TO_REPORT_SUM',
                                'RATIO_TO_REPORT_COUNT')),
     function_column_12         varchar2(255),
     function_db_column_name_12 varchar2(128),
     function_label_12          varchar2(4000),
     function_format_mask_12    varchar2(255),
     function_sum_12            varchar2(1),
     --
     sort_column_01             varchar2(255),
     sort_direction_01          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir1_ck
                                check (sort_direction_01 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_02             varchar2(255),
     sort_direction_02          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir2_ck
                                check (sort_direction_02 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_03             varchar2(255),
     sort_direction_03          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir3_ck
                                check (sort_direction_03 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_04             varchar2(255),
     sort_direction_04          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir4_ck
                                check (sort_direction_04 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_05             varchar2(255),
     sort_direction_05          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir5_ck
                                check (sort_direction_05 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_06             varchar2(255),
     sort_direction_06          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir6_ck
                                check (sort_direction_06 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_07             varchar2(255),
     sort_direction_07          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir7_ck
                                check (sort_direction_07 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_08             varchar2(255),
     sort_direction_08          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir8_ck
                                check (sort_direction_08 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_09             varchar2(255),
     sort_direction_09          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir9_ck
                                check (sort_direction_09 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_10             varchar2(255),
     sort_direction_10          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir10_ck
                                check (sort_direction_10 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_11             varchar2(255),
     sort_direction_11          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir11_ck
                                check (sort_direction_11 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST')),
     --
     sort_column_12             varchar2(255),
     sort_direction_12          varchar2(255)
                                constraint wwv_flow_ws_grpby_sortdir12_ck
                                check (sort_direction_12 in (
                                'ASC',
                                'ASC NULLS LAST',
                                'ASC NULLS FIRST',
                                'DESC',
                                'DESC NULLS LAST',
                                'DESC NULLS FIRST'))
     )
/

create index wwv_flow_ws_groupby_idx on wwv_flow_worksheet_group_by (worksheet_id)
/

create index wwv_flow_ws_groupby_idx2 on wwv_flow_worksheet_group_by (websheet_id)
/

create index wwv_flow_ws_groupby_idx3 on wwv_flow_worksheet_group_by (report_id)
/

--==============================================================================
create table wwv_flow_worksheet_notify (
    id                          number
                                constraint wwv_flow_worksheet_notify_pk
                                primary key,
    worksheet_id                number,
    websheet_id                 number
                                constraint wwv_flow_worksheet_notify_fk4
                                references wwv_flow_ws_websheet_attr(id)
                                on delete cascade,
    report_id                   number
                                constraint wwv_flow_worksheet_notify_fk2
                                references wwv_flow_worksheet_rpts(id)
                                on delete cascade,
    owner                       varchar2(255) not null,
    language                    varchar2(255),
    email_from                  varchar2(255),
    email_address               varchar2(255) not null,
    email_subject               varchar2(4000),
    start_date                  timestamp with local time zone not null,
    end_date                    timestamp with local time zone,
    end_day                     number,
    end_day_unit                varchar2(255),
    offset_date                 timestamp with time zone,
    notify_interval             varchar2(1)
                                constraint wwv_flow_worksheet_notify_ck check
                                (notify_interval in ('H','D','BW','W','M')),
    status                      varchar2(255)
                                constraint wwv_flow_worksheet_nstatus_ck check
                                (status in ('SUBMITTED','SENT','ERROR')),
    notify_error                varchar2(4000),
    security_group_id           number not null,
    created_by                  varchar2(255),
    created_on                  date,
    updated_by                  varchar2(255),
    updated_on                  date
    )
/

alter table wwv_flow_worksheet_notify
    add constraint wwv_flow_worksheet_notify_fk5
    foreign key( security_group_id ) references wwv_flow_companies(provisioning_company_id)
    on delete cascade
/

create index wwv_flow_worksheet_ntfy_idx1 on wwv_flow_worksheet_notify (worksheet_id)
/
create index wwv_flow_worksheet_ntfy_idx2 on wwv_flow_worksheet_notify (websheet_id)
/
create index wwv_flow_worksheet_ntfy_idx3 on wwv_flow_worksheet_notify (report_id)
/
create index wwv_flow_worksheet_ntfy_idx4 on wwv_flow_worksheet_notify (security_group_id)
/

--==============================================================================
create table wwv_flow_worksheet_pivot (
    id                         number not null
                               constraint wwv_flow_ws_pivot_pk
                               primary key,
    flow_id                    number not null,
    page_id                    number,
    worksheet_id               number not null,
    websheet_id                number
                               constraint wwv_flow_ws_pivot_fk1
                               references wwv_flow_ws_websheet_attr(id)
                               on delete cascade,
    report_id                  number not null
                               constraint wwv_flow_ws_pivot_fk2
                               references wwv_flow_worksheet_rpts(id)
                               on delete cascade,
    --
    pivot_columns              varchar2(4000) not null, -- colone separated columns to pivot on, vertical columns
    row_columns                varchar2(4000) not null, -- colone separated columns to display in pivot view, horizontal columns
    -- audit
    created_on                 date,
    created_by                 varchar2(255),
    updated_on                 date,
    updated_by                 varchar2(255),
    security_group_id          number not null
    )
/

create index wwv_flow_ws_pivot_idx1 on wwv_flow_worksheet_pivot (websheet_id)
/

create index wwv_flow_ws_pivot_idx2 on wwv_flow_worksheet_pivot (report_id)
/

-- pivot can occur once per IR saved report or websheet report
create unique index wwv_flow_ws_pivot_idx3 on wwv_flow_worksheet_pivot (worksheet_id, websheet_id, report_id) compress 1
/

--
-- pivot detail table to store aggregate information
--
create table wwv_flow_worksheet_pivot_agg (
    id                         number not null
                               constraint wwv_flow_ws_pivot_agg_pk
                               primary key,
    pivot_id                   number not null
                               constraint wwv_flow_ws_pivot_agg_fk1
                               references wwv_flow_worksheet_pivot(id)
                               on delete cascade,
    display_seq                number not null,
    function_name              varchar2(255) not null
                               constraint wwv_flow_ws_pivot_agg_funtn_ck
                               check (function_name in (
                               'SUM',
                               'AVG',
                               'MAX',
                               'MIN',
                               'MEDIAN',
                               'COUNT',
                               'COUNT_DISTINCT',
                               'RATIO_TO_REPORT_SUM',
                               'RATIO_TO_REPORT_COUNT')),
    column_name                varchar2(255) not null,
    db_column_name             varchar2(128) not null,
    column_label               varchar2(4000),
    format_mask                varchar2(255),
    display_sum                varchar2(1) default 'N'
                               constraint wwv_flow_ws_pivot_agg_sum_ck
                               check (display_sum in (
                               'Y',
                               'N')),
    -- audit
    created_on                 date,
    created_by                 varchar2(255),
    updated_on                 date,
    updated_by                 varchar2(255),
    security_group_id          number not null
    )
/

create unique index wwv_flow_ws_pivot_agg_idx2 on wwv_flow_worksheet_pivot_agg (pivot_id, function_name, column_name, db_column_name) compress
/

--
-- pivot detail table to store sorting
--
create table wwv_flow_worksheet_pivot_sort (
    id                         number not null
                               constraint wwv_flow_ws_pivot_sort_pk
                               primary key,
    pivot_id                   number not null
                               constraint wwv_flow_ws_pivot_sort_fk1
                               references wwv_flow_worksheet_pivot(id)
                               on delete cascade,
    sort_seq                   number not null,
    sort_column_name           varchar2(255) not null,
    sort_direction             varchar2(255) not null
                               constraint wwv_flow_ws_pivot_sortdir_ck
                               check (sort_direction in (
                               'ASC',
                               'ASC NULLS LAST',
                               'ASC NULLS FIRST',
                               'DESC',
                               'DESC NULLS LAST',
                               'DESC NULLS FIRST')),
    -- audit
    created_on                 date,
    created_by                 varchar2(255),
    updated_on                 date,
    updated_by                 varchar2(255),
    security_group_id          number not null
    )
/

create unique index wwv_flow_ws_pivot_sor_idx2 on wwv_flow_worksheet_pivot_sort (pivot_id, sort_column_name) compress
/

--==============================================================================
create table wwv_flow_worksheet_geocache (
    address varchar2(4000),
    geocode varchar2(512)
    )
/

--##############################################################################
--#
--# REGION > INTERACTIVE GRID
--#
--##############################################################################
prompt REGION > INTERACTIVE GRID

--==============================================================================
create table wwv_flow_interactive_grids (
    id                          number
                                constraint ig_pk
                                primary key,
    flow_id                     number not null
                                constraint ig_flow_fk
                                references wwv_flows
                                on delete cascade,
    page_id                     number not null,
    region_id                   number not null
                                constraint ig_region_fk
                                references wwv_flow_page_plugs
                                on delete cascade,
    security_group_id           number not null,
    --
    internal_uid                number not null,
    -- Edit
    is_editable                 varchar2(1) not null
                                constraint ig_is_editable_ck
                                check ( is_editable in ( 'Y', 'N' )),
    edit_operations             varchar2(5)
                                constraint ig_edit_operations_ck
                                check ( regexp_instr( edit_operations, '[^iud:]+') = 0 ), /* only allow i, u, d, : */
    edit_row_operations_column  varchar2(128),
    add_authorization_scheme    varchar2(40),
    update_authorization_scheme varchar2(40),
    delete_authorization_scheme varchar2(40),
    lost_update_check_type      varchar2(6)
                                constraint ig_lost_update_check_type_ck
                                check ( lost_update_check_type in ( 'VALUES', 'COLUMN' )),
    row_version_column          varchar2(128),
    add_row_if_empty            varchar2(1)
                                constraint ig_add_row_if_empty_ck
                                check ( add_row_if_empty in ( 'Y', 'N' )),
    submit_checked_rows         varchar2(1)
                                constraint ig_submit_checked_rows_ck
                                check ( submit_checked_rows in ( 'Y', 'N' )),
    -- Performance
    lazy_loading                varchar2(1) not null
                                constraint ig_lazy_loading_ck
                                check ( lazy_loading in ( 'Y', 'N' )),
    requires_filter             varchar2(1) not null
                                constraint ig_requires_filter_ck
                                check ( requires_filter in ( 'Y', 'N' )),
    max_row_count               number,
    -- Appearance
    show_nulls_as               varchar2(30),
    fixed_row_height            varchar2(1)
                                constraint ig_fixed_row_height
                                check ( fixed_row_height in ( 'Y', 'N' )),
    select_first_row            varchar2(1) default 'Y' not null
                                constraint ig_select_first_row_ck
                                check ( select_first_row in ( 'Y', 'N' )),
    -- Pagination
    pagination_type             varchar2(6) not null
                                constraint ig_pagination_type_ck
                                check ( pagination_type in ( 'NONE', 'SET', 'SCROLL' )),
    show_total_row_count        varchar2(1)
                                constraint ig_show_total_row_count_ck
                                check ( show_total_row_count in ( 'Y', 'N' )),
    -- Messages
    no_data_found_message       varchar2(4000),
    max_row_count_message       varchar2(4000),
    -- Toolbar
    show_toolbar                varchar2(1) not null
                                constraint ig_show_toolbar_ck
                                check ( show_toolbar in ( 'Y', 'N' )),
    toolbar_buttons             varchar2(255),
    add_button_label            varchar2(255),
    -- Enable End Users to
    enable_save_public_report   varchar2(1) not null
                                constraint ig_enable_save_public_rpt_ck
                                check ( enable_save_public_report in ( 'Y', 'N' )),
    public_report_auth_scheme   varchar2(40),
    enable_subscriptions        varchar2(1) not null
                                constraint ig_enable_subscriptions_ck
                                check ( enable_subscriptions in ( 'Y', 'N' )),
    enable_flashback            varchar2(1) default 'Y' not null
                                constraint ig_enable_flashback_ck
                                check ( enable_flashback in ( 'Y', 'N' )),
    define_chart_view           varchar2(1) default 'Y' not null
                                constraint ig_def_chart_view_ck
                                check ( define_chart_view in ( 'Y', 'N' )),
    enable_download             varchar2(1) not null
                                constraint ig_enable_download
                                check ( enable_download in ( 'Y', 'N' )),
    download_formats            varchar2(20)
                                constraint ig_download_formats_ck
                                check ( regexp_instr( download_formats, '[^(CSV)|(HTML)|(XLS)|(PDF)|(RTF)|:]+') = 0 ), /* only allow CSV, HTML, ... and : */
    download_filename           varchar2(255),
    enable_mail_download        varchar2(1)
                                constraint ig_enable_mail_download_ck
                                check ( enable_mail_download in ( 'Y', 'N' )),
    csv_separator               varchar2(1),
    csv_enclosed_by             varchar2(1),
    supplemental_text           varchar2(4000),
    -- Heading
    fixed_header                varchar2(6) not null
                                constraint ig_fixed_header_ck
                                check ( fixed_header in ( 'PAGE', 'REGION', 'NONE' )),
    fixed_header_max_height     number,
    -- Icon View
    show_icon_view              varchar2(1) not null
                                constraint ig_show_icon_view_ck
                                check ( show_icon_view in ( 'Y', 'N' )),
    icon_view_use_custom        varchar2(1)
                                constraint ig_icon_view_use_custom_ck
                                check ( icon_view_use_custom in ( 'Y', 'N' )),
    icon_view_custom            varchar2(4000),
    icon_view_icon_type         varchar2(11)
                                constraint ig_icon_view_icon_type_ck
                                check ( icon_view_icon_type in ( 'BLOB', 'URL', 'CSS_CLASSES' )),
    icon_view_icon_column       varchar2(128),
    icon_view_icon_attributes   varchar2(255),
    icon_view_link_target       varchar2(4000),
    icon_view_link_attributes   varchar2(255),
    icon_view_label_column      varchar2(128),
    -- Detail View
    show_detail_view            varchar2(1) not null
                                constraint ig_show_detail_view_ck
                                check ( show_detail_view in ( 'Y', 'N' )),
    detail_view_before_rows     varchar2(4000),
    detail_view_for_each_row    varchar2(4000),
    detail_view_after_rows      varchar2(4000),
    -- Advanced
    oracle_text_index_column    varchar2(128),
    email_from                  varchar2(255),
    javascript_code             varchar2(4000),
    -- Help Text
    help_text                   varchar2(4000),
    -- Audit
    last_updated_by             varchar2(255),
    last_updated_on             date
  )
/
alter table wwv_flow_interactive_grids add constraint ig_region_uk unique ( region_id )
/
create index ig_page_ix on wwv_flow_interactive_grids ( flow_id, page_id )
/


--##############################################################################
--#
--# REGION > INTERACTIVE GRID > SAVED REPORTS
--#
--##############################################################################
prompt REGION > INTERACTIVE GRID > REPORTS

--==============================================================================
create table wwv_flow_ig_reports (
    id                          number
                                constraint ig_rpt_pk
                                primary key,
    flow_id                     number not null
                                constraint ig_rpt_flow_fk
                                references wwv_flows
                                on delete cascade,
    page_id                     number not null,
    interactive_grid_id         number not null
                                constraint ig_rpt_grid_fk
                                references wwv_flow_interactive_grids
                                on delete cascade,
    tenant_id                   varchar2(32),
    security_group_id           number not null,
    --
    name                        varchar2(255),
    static_id                   varchar2(255),
    description                 varchar2(4000),
    type                        varchar2(11) not null
                                constraint ig_rpt_type_ck
                                check ( type in ( 'PRIMARY', 'ALTERNATIVE', 'PRIVATE', 'PUBLIC' )),
    default_view                varchar2(7) not null
                                constraint ig_rpt_default_view_ck
                                check ( default_view in ( 'ICON', 'GRID', 'DETAIL', 'GROUPBY', 'PIVOT', 'CHART' )),
    -- Information for alternative or private reports
    authorization_scheme        varchar2(40),
    application_user            varchar2(255),
    -- Information for temporary reports
    session_id                  number
                                constraint ig_session_fk
                                references wwv_flow_sessions$ on delete cascade,
    base_report_id              number
                                constraint ig_base_report_fk
                                references wwv_flow_ig_reports
                                on delete set null,
    -- global settings
    rows_per_page               number,
    show_row_number             varchar2(1) not null
                                constraint ig_rpt_show_row_number_ck
                                check ( show_row_number in ( 'Y', 'N' )),
    settings_area_expanded      varchar2(1) not null
                                constraint ig_rpt_settings_area_exp_ck
                                check ( settings_area_expanded in ( 'Y', 'N' )),
    --
    flashback_mins_ago          number,
    flashback_is_enabled        varchar2(1)
                                constraint ig_rpt_flashback_is_enabled_ck
                                check ( flashback_is_enabled in ( 'Y', 'N' )),
    -- Audit
    version_number              number default 1 not null,
    last_updated_by             varchar2(255),
    last_updated_on             date
)
/
create index ig_rpt_page_ix    on wwv_flow_ig_reports ( flow_id, page_id )
/
create index ig_rpt_access_ix  on wwv_flow_ig_reports ( interactive_grid_id, type, application_user, session_id )
/
create index ig_rpt_sessopm_fx on wwv_flow_ig_reports ( session_id )
/
create index ig_rpt_base_report_fx on wwv_flow_ig_reports ( base_report_id )
/
create unique index ig_rpt_name_uk on wwv_flow_ig_reports ( interactive_grid_id, type, name, application_user, session_id, base_report_id )
/

--==============================================================================
create table wwv_flow_ig_report_views (
    id                          number
                                constraint ig_rpt_view_pk
                                primary key,
    report_id                   number not null
                                constraint ig_rpt_view_report_fk
                                references wwv_flow_ig_reports
                                on delete cascade,
    security_group_id           number not null,
    --
    view_type                   varchar2(7) not null
                                constraint ig_rpt_view_type_ck
                                check ( view_type in ( 'ICON', 'GRID', 'DETAIL', 'GROUPBY', 'PIVOT', 'CHART' )),
    -- Control Break
    breaks_expanded             varchar2(1)
                                constraint ig_rpt_view_breaks_exp_ck
                                check ( breaks_expanded in ( 'Y', 'N' )),
    stretch_columns             varchar2(1)
                                constraint ig_rpt_view_stretch_cols_ck
                                check ( stretch_columns in ( 'Y', 'N' )),
    -- Single Row View
    srv_exclude_null_values     varchar2(1)
                                constraint ig_rpt_view_excl_null_ck
                                check ( srv_exclude_null_values in ( 'Y', 'N' )),
    srv_only_display_columns    varchar2(1)
                                constraint ig_rpt_view_displ_cols_ck
                                check ( srv_only_display_columns in ( 'Y', 'N' )),
    -- Grid View specific attributes
    edit_mode                   varchar2(1)
                                constraint ig_rpt_view_edit_mode_ck
                                check ( edit_mode in ( 'Y', 'N' )),
    -- Chart View specific attributes
    chart_type                  varchar2(12)
                                constraint ig_rpt_view_chart_type_ck
                                check ( chart_type in ( 'area', 'bar', 'bubble', 'donut',
                                                        'funnel', 'line', 'lineWithArea',
                                                        'pie', 'polar', 'radar', 'range',
                                                        'scatter', 'stock' )),
    chart_orientation           varchar2(10)
                                constraint ig_rpt_view_chart_orient_ck
                                check ( chart_orientation in ( 'horizontal', 'vertical' )),
    chart_stack                 varchar2(3)
                                constraint ig_rpt_view_chart_stack_ck
                                check ( chart_stack in ( 'on', 'off' )),
    axis_label                  varchar2(255),
    axis_value                  varchar2(255),
    axis_value_decimal_places   number
)
/
alter table wwv_flow_ig_report_views
  add constraint ig_rpt_view_uk unique ( report_id, view_type )
/


--==============================================================================
create table wwv_flow_ig_report_computes (
    id                          number
                                constraint ig_rpt_comp_pk
                                primary key,
    report_id                   number not null
                                constraint ig_rpt_comp_report_fk
                                references wwv_flow_ig_reports
                                on delete cascade,
    view_id                     number
                                constraint ig_rpt_comp_view_fk
                                references wwv_flow_ig_report_views
                                on delete cascade,
    security_group_id           number not null,
    -- Computation
    function                    varchar2(21) not null
                                constraint ig_rpt_comp_function_ck
                                check ( function in ( 'SUM', 'AVG', 'COUNT', 'COUNT_DISTINCT', 'APPROX_COUNT_DISTINCT', 'MIN', 'MAX', 'MEDIAN', 'LISTAGG', 'SQL_EXPRESSION' )),
    column_id                   number
                                constraint ig_rpt_comp_column_fk
                                references wwv_flow_region_columns
                                on delete cascade,
    /* ??? when would this be used? For example in a Group By/Pivot when doing this on a computed column */
    comp_column_id              number
                                constraint ig_rpt_comp_comp_column_fk
                                references wwv_flow_ig_report_computes
                                on delete cascade deferrable initially deferred,
                                -- deferrable is necessary for ig report import, because the order of compute is undefined
    partition_by_clause         varchar2(4000),
    order_by_clause             varchar2(4000),
    sql_expression              varchar2(4000),
    data_type                   varchar2(128),
    -- Display
    heading                     varchar2(255),
    label                       varchar2(255),
    heading_alignment           varchar2(6)
                                constraint ig_rpt_comp_heading_align_ck
                                check ( heading_alignment in (
                                            'LEFT',
                                            'RIGHT',
                                            'CENTER' )),
    column_alignment            varchar2(6)
                                constraint ig_rpt_comp_column_align_ck
                                check ( column_alignment in (
                                            'LEFT',
                                            'RIGHT',
                                            'CENTER' )),
    group_id                    number
                                constraint ig_rpt_comp_group_fk
                                references wwv_flow_region_column_groups on delete set null,
    use_group_for               varchar2(7)
                                constraint ig_rpt_comp_use_group_for_ck
                                check ( use_group_for in ( 'BOTH', 'SRV', 'HEADING' )),
    format_mask                 varchar2(50),
    --
    is_enabled                  varchar2(1) not null
                                constraint ig_rpt_comp_is_enabled_ck
                                check ( is_enabled in ( 'Y', 'N' ))
)
/
create index  ig_rpt_comp_report_fx on wwv_flow_ig_report_computes ( report_id )
/
create index  ig_rpt_comp_view_fx on wwv_flow_ig_report_computes ( view_id )
/
create index  ig_rpt_comp_column_fx on wwv_flow_ig_report_computes ( column_id )
/
create index  ig_rpt_comp_comp_column_fx on wwv_flow_ig_report_computes ( comp_column_id )
/
create index  ig_rpt_comp_group_fx on wwv_flow_ig_report_computes ( group_id )
/


--==============================================================================
create table wwv_flow_ig_report_filters (
    id                          number
                                constraint ig_rpt_filter_pk
                                primary key,
    report_id                   number not null
                                constraint ig_rpt_filter_report_fk
                                references wwv_flow_ig_reports
                                on delete cascade,
    view_id                     number
                                constraint ig_rpt_filter_view_fk
                                references wwv_flow_ig_report_views
                                on delete cascade,
    security_group_id           number not null,
    --
    type                        varchar2(7) not null
                                constraint ig_rpt_filter_type_ck
                                check ( type in ( 'ROW', 'COLUMN', 'COMPLEX' )),
    --
    name                        varchar2(40),
    --
    column_id                   number
                                constraint ig_rpt_filter_column_fk
                                references wwv_flow_region_columns
                                on delete cascade,
    comp_column_id              number
                                constraint ig_rpt_filter_comp_column_fk
                                references wwv_flow_ig_report_computes
                                on delete cascade,
    --
    operator                    varchar2(40),
    is_case_sensitive           varchar2(1)
                                constraint ig_rpt_filter_case_ck
                                check ( is_case_sensitive in ( 'Y', 'N' )),
    expression                  varchar2(4000),
    --
    is_enabled                  varchar2(1) not null
                                constraint ig_rpt_filter_is_enabled_ck
                                check ( is_enabled in ( 'Y', 'N' ))
    --
)
/
create index  ig_rpt_filter_report_fx on wwv_flow_ig_report_filters ( report_id )
/
create index  ig_rpt_filter_view_fx on wwv_flow_ig_report_filters ( view_id )
/
create index  ig_rpt_filter_column_fx on wwv_flow_ig_report_filters ( column_id )
/
create index  ig_rpt_filter_comp_column_fx on wwv_flow_ig_report_filters ( comp_column_id )
/


--==============================================================================
create table wwv_flow_ig_report_columns (
    id                          number
                                constraint ig_rpt_col_pk
                                primary key,
    view_id                     number not null
                                constraint ig_rpt_col_view_fk
                                references wwv_flow_ig_report_views
                                on delete cascade,
    security_group_id           number not null,
    --
    display_seq                 number not null,
    --
    column_id                   number
                                constraint ig_rpt_col_column_fk
                                references wwv_flow_region_columns
                                on delete cascade,
    comp_column_id              number
                                constraint ig_rpt_col_comp_column_fk
                                references wwv_flow_ig_report_computes
                                on delete cascade,
    --
    is_visible                  varchar2(1) not null
                                constraint ig_rpt_col_is_visible_ck
                                check ( is_visible in ( 'Y', 'N' )),
    is_frozen                   varchar2(1) not null
                                constraint ig_rpt_col_is_frozen_ck
                                check ( is_frozen in ( 'Y', 'N' )),
    width                       number,
    priority                    number,
    --
    break_order                 number,
    break_is_enabled            varchar2(1)
                                constraint ig_rpt_col_break_is_enabled_ck
                                check ( break_is_enabled in ( 'Y', 'N' )),
    break_sort_direction        varchar2(4)
                                constraint ig_rpt_col_break_sort_dir_ck
                                check ( break_sort_direction in ( 'ASC', 'DESC' )),
    break_sort_nulls            varchar2(5)
                                constraint ig_rpt_col_break_sort_nulls_ck
                                check ( break_sort_nulls in ( 'FIRST', 'LAST' )),
    --
    sort_order                  number,
    sort_direction              varchar2(4)
                                constraint ig_rpt_col_sort_direction_ck
                                check ( sort_direction in ( 'ASC', 'DESC' )),
    sort_nulls                  varchar2(5)
                                constraint ig_rpt_col_sort_nulls_ck
                                check ( sort_nulls in ( 'FIRST', 'LAST' ))
)
/
create index  ig_rpt_col_view_fx on wwv_flow_ig_report_columns ( view_id )
/
create index  ig_rpt_col_column_fx on wwv_flow_ig_report_columns ( column_id )
/
create index  ig_rpt_col_comp_column_fx on wwv_flow_ig_report_columns ( comp_column_id )
/


--==============================================================================
create table wwv_flow_ig_report_highlights (
    id                          number
                                constraint ig_rpt_highlight_pk
                                primary key,
    view_id                     number not null
                                constraint ig_rpt_highlight_view_fk
                                references wwv_flow_ig_report_views
                                on delete cascade,
    security_group_id           number not null,
    --
    execution_seq               number not null,
    name                        varchar2(40) not null,
    -- Highlight row/column
    column_id                   number
                                constraint ig_rpt_high_column_fk
                                references wwv_flow_region_columns
                                on delete cascade,
    comp_column_id              number
                                constraint ig_rpt_high_comp_column_fk
                                references wwv_flow_ig_report_computes
                                on delete cascade,
    --
    background_color            varchar2(15),
    text_color                  varchar2(15),
    -- Highlight condition
    condition_type              varchar2(7) not null
                                constraint ig_rpt_high_cond_type_ck
                                check ( condition_type in ( 'ROW', 'COLUMN', 'COMPLEX' )),
    condition_column_id         number
                                constraint ig_rpt_high_cond_column_fk
                                references wwv_flow_region_columns
                                on delete cascade,
    condition_comp_column_id    number
                                constraint ig_rpt_high_cond_comp_col_fk
                                references wwv_flow_ig_report_computes
                                on delete cascade,
    --
    condition_operator          varchar2(40),
    condition_is_case_sensitive varchar2(1)
                                constraint ig_rpt_highlight_case_ck
                                check ( condition_is_case_sensitive in ( 'Y', 'N' )),
    condition_expression        varchar2(4000),
    --
    is_enabled                  varchar2(1) not null
                                constraint ig_rpt_highlight_is_enabled_ck
                                check ( is_enabled in ( 'Y', 'N' ))
    --
)
/
create index  ig_rpt_highlight_view_fx on wwv_flow_ig_report_highlights ( view_id )
/
create index  ig_rpt_high_column_fx on wwv_flow_ig_report_highlights ( column_id )
/
create index  ig_rpt_high_comp_column_fx on wwv_flow_ig_report_highlights ( comp_column_id )
/
create index  ig_rpt_high_cond_column_fx on wwv_flow_ig_report_highlights ( condition_column_id )
/
create index  ig_rpt_high_cond_comp_col_fx on wwv_flow_ig_report_highlights ( condition_comp_column_id )
/


--==============================================================================
create table wwv_flow_ig_report_aggregates (
    id                          number
                                constraint ig_rpt_agg_pk
                                primary key,
    view_id                     number not null
                                constraint ig_rpt_agg_view_fk
                                references wwv_flow_ig_report_views
                                on delete cascade,
    security_group_id           number not null,
    --
    tooltip                     varchar2(255),
    function                    varchar2(21) not null
                                constraint ig_rpt_agg_function_ck
                                check ( function in ( 'SUM', 'AVG', 'COUNT', 'COUNT_DISTINCT', 'MIN', 'MAX', 'MEDIAN' )),
    --
    column_id                   number
                                constraint ig_rpt_agg_column_fk
                                references wwv_flow_region_columns
                                on delete cascade,
    comp_column_id              number
                                constraint ig_rpt_agg_comp_column_fk
                                references wwv_flow_ig_report_computes
                                on delete cascade,
    --
    show_grand_total            varchar2(1) not null
                                constraint ig_rpt_agg_grand_total_ck
                                check ( show_grand_total in ( 'Y', 'N' )),
    --
    is_enabled                  varchar2(1) not null
                                constraint ig_rpt_agg_is_enabled_ck
                                check ( is_enabled in ( 'Y', 'N' ))
)
/
create index  ig_rpt_agg_view_fx on wwv_flow_ig_report_aggregates ( view_id )
/
create index  ig_rpt_agg_column_fx on wwv_flow_ig_report_aggregates ( column_id )
/
create index  ig_rpt_agg_comp_column_fx on wwv_flow_ig_report_aggregates ( comp_column_id )
/


--==============================================================================
create table wwv_flow_ig_report_chart_cols (
    id                          number
                                constraint ig_rpt_chart_col_pk
                                primary key,
    view_id                     number not null
                                constraint ig_rpt_chart_col_view_fk
                                references wwv_flow_ig_report_views
                                on delete cascade,
    security_group_id           number not null,
    --
    column_type                 varchar2(11) not null
                                constraint ig_rpt_chart_col_type_ck
                                check ( column_type in ( 'SERIES_NAME', 'LABEL', 'VALUE', 'OPEN', 'LOW', 'HIGH', 'CLOSE', 'VOLUME', 'X', 'Y', 'Z', 'TARGET' )),
    column_id                   number
                                constraint ig_rpt_chart_col_column_fk
                                references wwv_flow_region_columns
                                on delete cascade,
    comp_column_id              number
                                constraint ig_rpt_chart_col_comp_col_fk
                                references wwv_flow_ig_report_computes
                                on delete cascade,
    function                    varchar2(21)
                                constraint ig_rpt_chart_col_function_ck
                                check ( function in ( 'SUM', 'AVG', 'COUNT', 'COUNT_DISTINCT', 'APPROX_COUNT_DISTINCT', 'MIN', 'MAX', 'MEDIAN' )),
    --
    sort_order                  number,
    sort_direction              varchar2(4)
                                constraint ig_rpt_chart_col_sort_dir_ck
                                check ( sort_direction in ( 'ASC', 'DESC' )),
    sort_nulls                  varchar2(5)
                                constraint ig_rpt_chart_col_sort_nulls_ck
                                check ( sort_nulls in ( 'FIRST', 'LAST' ))
)
/
alter table wwv_flow_ig_report_chart_cols
  add constraint ig_rpt_chart_col_uk unique ( view_id, column_type )
/
create index  ig_rpt_chart_col_column_fx on wwv_flow_ig_report_chart_cols ( column_id )
/
create index  ig_rpt_chart_col_comp_col_fx on wwv_flow_ig_report_chart_cols ( comp_column_id )
/


--##############################################################################
--#
--# REGION > WEB SOURCE > COMPONENT PARAMETERS
--#
--##############################################################################
prompt REGION > WEB SOURCE > COMPONENT PARAMETERS

--==============================================================================
create table wwv_flow_web_src_comp_params (
    id                             number
                                   constraint wwv_flow_web_src_comp_par_pk
                                   primary key,
    security_group_id              number not null
                                   constraint wwv_websrc_cparam_sgid_fk
                                   references wwv_flow_companies(provisioning_company_id),
    flow_id                        number not null
                                   constraint wwv_websrc_cparam_flow_fk
                                   references wwv_flows
                                   on delete cascade,
    page_id                        number,
    --
    web_src_param_id               number not null
                                   constraint wwv_websrc_cparam_param_fk
                                   references wwv_flow_web_src_params
                                   on delete cascade,
    page_plug_id                   number
                                   constraint wwv_websrc_cparam_plug_fk
                                   references wwv_flow_page_plugs
                                   on delete cascade,
    page_process_id                number
                                   constraint wwv_websrc_cparam_pageproc_fk
                                   references wwv_flow_step_processing
                                   on delete cascade,
    app_process_id                 number
                                   constraint wwv_websrc_cparam_appproc_fk
                                   references wwv_flow_processing
                                   on delete cascade,
    jet_chart_series_id            number
                                   constraint wwv_websrc_cparam_jetseries_fk
                                   references wwv_flow_jet_chart_series
                                   on delete cascade,
    shared_lov_id                  number
                                   constraint wwv_websrc_cparam_sharedlov_fk
                                   references wwv_flow_lists_of_values$
                                   on delete cascade,
    --
    value_type                     varchar2(30) not null
                                   constraint wwv_websrc_cparam_valtype_ck
                                   check (value_type in (
                                       'PREFERENCE',
                                       'NULL',
                                       'STATIC',
                                       'SQL_QUERY',
                                       'COLLECTION',
                                       'ITEM',
                                       'PLSQL_EXPRESSION',
                                       'PLSQL_FUNCTION_BODY')),
    value                          varchar2(4000),
    --
    last_updated_by                varchar2(255),
    last_updated_on                date,
    created_by                     varchar2(255),
    created_on                     date )
/

create index wwv_websrc_cparam_flowpage_ix      on wwv_flow_web_src_comp_params (flow_id, page_id)      compress 1
/
create index wwv_websrc_cparam_sgid_fx          on wwv_flow_web_src_comp_params (security_group_id)     compress
/
create index wwv_websrc_cparam_param_fx         on wwv_flow_web_src_comp_params (web_src_param_id)      compress
/
create index wwv_websrc_cparam_plug_fx          on wwv_flow_web_src_comp_params (page_plug_id)          compress
/
create index wwv_websrc_cparam_page_proc_fx     on wwv_flow_web_src_comp_params (page_process_id)       compress
/
create index wwv_websrc_cparam_app_proc_fx      on wwv_flow_web_src_comp_params (app_process_id)        compress
/
create index wwv_websrc_cparam_chart_fx         on wwv_flow_web_src_comp_params (jet_chart_series_id)   compress
/
create index wwv_websrc_cparam_shd_lov_fx       on wwv_flow_web_src_comp_params (shared_lov_id)         compress
/

--##############################################################################
--#
--# WEBSHEET > PAGES
--#
--##############################################################################
prompt WEBSHEET > PAGES

--==============================================================================
create table wwv_flow_ws_webpages (
id                  number not null
                    constraint wwv_flow_ws_webpages_pk
                    primary key,
page_number         number,
ws_app_id           number not null
                    constraint wwv_flow_ws_webpages_fk
                    references wwv_flow_ws_applications(id)
                    on delete cascade,
parent_page_id      number
                    constraint wwv_flow_ws_webpages_fk2
                    references wwv_flow_ws_webpages(id)
                    on delete cascade,
name                varchar2(255),
upper_name          varchar2(255),
page_alias          varchar2(255) not null,
owner               varchar2(255),
status              varchar2(30)
                    constraint wwv_flow_ws_webpg_status_ck
                    check (status in (
                    'AVAILABLE_FOR_OWNER',
                    'NOT_AVAILABLE',
                    'AVAILABLE')),
description         varchar2(4000),
--
created_on          date          not null,
created_by          varchar2(255) not null,
updated_on          date,
updated_by          varchar2(255),
security_group_id   number        not null
)
/

create unique index wwv_flow_ws_webpage_unq_idx1 on wwv_flow_ws_webpages
    (security_group_id,ws_app_id,page_alias)
/

create index wwv_flow_ws_webpage_idx1 on wwv_flow_ws_webpages (ws_app_id,upper_name)
/

create index wwv_flow_ws_webpage_idx2 on wwv_flow_ws_webpages (parent_page_id)
/

--==============================================================================
create table wwv_flow_ws_col_validations (
     id                  number
                         constraint wwv_flow_ws_col_val_pk
                         primary key,
     ws_app_id           number not null
                         constraint wwv_flow_ws_col_val_fk3
                         references wwv_flow_ws_applications(id)
                         on delete cascade,
     worksheet_id        number not null
                         constraint wwv_flow_ws_col_val_fk
                         references wwv_flow_worksheets(id)
                         on delete cascade,
     websheet_id         number
                         constraint wwv_flow_ws_col_val_fk2
                         references wwv_flow_ws_websheet_attr(id)
                         on delete cascade,
     --
     validation_level    varchar2(255)
                         constraint wwv_flow_ws_val_level_ck
                         check (validation_level in (
                         'REPORT',
                         'FORM',
                         'BOTH')),
     validation_seq      number,
     validation_name     varchar2(255),
     validation_type     varchar2(255),
     validation_expr1    varchar2(4000),
     validation_expr2    varchar2(4000),
     error_message       varchar2(4000),
     security_group_id   number not null,
     --
     created_on          date not null,
     created_by          varchar2(255) not null,
     updated_on          date,
     updated_by          varchar2(255)
)
/

create index wwv_flow_ws_col_val_idx1 on wwv_flow_ws_col_validations (worksheet_id)
/
create index wwv_flow_ws_col_val_idx2 on wwv_flow_ws_col_validations (websheet_id)
/
create index wwv_flow_ws_col_val_idx3 on wwv_flow_ws_col_validations (ws_app_id,security_group_id)
/

--==============================================================================
create table wwv_flow_ws_data_grid_q (
id                  number not null
                    constraint wwv_flow_ws_data_grid_q_pk
                    primary key,
ws_app_id           number not null
                    constraint wwv_flow_ws_data_grid_q_fk
                    references wwv_flow_ws_applications(id)
                    on delete cascade,
page_id             number
                    constraint wwv_flow_ws_data_grid_q_fk2
                    references wwv_flow_ws_webpages(id)
                    on delete cascade,
section_id          number,
sql_tag_id          varchar2(4000),
entered_query       clob,
rewritten_query     clob,
--
data_grid_ids       varchar2(4000),
bind_values         varchar2(4000),
db_obj_found        varchar2(1) not null
                    constraint wwv_flow_ws_dgq_db_obj_ck
                    check (db_obj_found in ('Y','N')),
security_group_id   number not null,
--
created_on          date not null,
created_by          varchar2(255) not null,
updated_on          date,
updated_by          varchar2(255)
)
/

create index wwv_flow_ws_dgq_idx1 on wwv_flow_ws_data_grid_q (ws_app_id,security_group_id)
/
create index wwv_flow_ws_dgq_idx2 on wwv_flow_ws_data_grid_q (page_id)
/

--##############################################################################
--#
--# ADVISOR
--#
--##############################################################################
prompt ADVISOR

--==============================================================================
create table wwv_flow_dictionary_views (
    id                        number
                              constraint wwv_flow_dict_views_pk
                              primary key,
    view_name                 varchar2(30)   not null
                                             constraint wwv_flow_dict_views_name_ck
                                             check (upper(view_name)=view_name),
    parent_view_id            number,
    component_type_id         number         constraint wwv_flow_dict_views_compt_fk
                                             /* needed for apex_install_pe_data.sql which deletes all entries */
                                             references wwv_pe_component_types deferrable initially deferred,
    pk_column_name            varchar2(30)   not null
                                             constraint wwv_flow_dict_views_pk_col_ck
                                             check (upper(pk_column_name)=pk_column_name),
    display_expression        varchar2(255)  not null,
    order_expression          varchar2(255)  not null,
    order_seq                 number(2)      not null,
    lookup_or_lov_columns     varchar2(4000) constraint wwv_flow_dict_views_lookup_ck
                                             check (upper(lookup_or_lov_columns)=lookup_or_lov_columns),
    link_url                  varchar2(255)
  );

alter table wwv_flow_dictionary_views
  add constraint wwv_flow_dict_view_name_uk unique (view_name);

alter table wwv_flow_dictionary_views
  add constraint wwv_flow_dict_view_parent_fk foreign key (parent_view_id)
  references wwv_flow_dictionary_views (id);

create index wwv_flow_dict_view_parent_fx on wwv_flow_dictionary_views (parent_view_id);

create index wwv_flow_dict_view_compt_fx on wwv_flow_dictionary_views (component_type_id);

comment on table wwv_flow_dictionary_views is
    'Adding some additional data to the meta data of the APEX Dictionary views.';
-- Add comments to the columns
comment on column wwv_flow_dictionary_views.view_name is
    'Name of the APEX dictionary view.';
comment on column wwv_flow_dictionary_views.parent_view_id is
    'Reference to the parent dictionary view.';
comment on column wwv_flow_dictionary_views.component_type_id is
    'Reference to Page Designer component type.';
comment on column wwv_flow_dictionary_views.pk_column_name is
    'Primary key column in the APEX dictionary view.';
comment on column wwv_flow_dictionary_views.display_expression is
    'Column/Expression which is used to display an entry of that dictionary view.';
comment on column wwv_flow_dictionary_views.order_expression is
    'Column/Expression which is used to order the entries on the same level.';
comment on column wwv_flow_dictionary_views.order_seq is
    'Order sequence within the same hierarchy level.';
comment on column wwv_flow_dictionary_views.link_url is
    'APEX Builder URL to maintain this object. Valid placeholders are %application_id%, %page_id% and %pk_value%';
comment on column wwv_flow_dictionary_views.link_url is
    'Comma delimited list of columns which are ignored by application search.';

--==============================================================================
create table wwv_flow_advisor_categories (
    id                number
                      constraint wwv_flow_adv_cat_pk
                      primary key,
    code              varchar2(30)  not null
                      constraint wwv_flow_adv_cat_code_ck
                      check (upper(code)=code),
    order_seq         number(2)     not null
    );

alter table wwv_flow_advisor_categories
  add constraint wwv_flow_adv_cat_code_uk unique (code);

comment on table wwv_flow_advisor_categories is
    'Contains the different categories of an Advisor Check (e.g. Security, Error, ...).';
comment on column wwv_flow_advisor_categories.code is
    'Code used in program code to reference the record.';
comment on column wwv_flow_advisor_categories.order_seq is
    'Order sequence to display the categories based on there priority.';

--==============================================================================
create table wwv_flow_advisor_checks (
    id                number
                      constraint wwv_flow_adv_chk_pk
                      primary key,
    code              varchar2(30)   not null
                      constraint wwv_flow_adv_chk_code_ck
                      check (upper(code)=code),
    description       varchar2(80),
    help_text         varchar2(2000),
    category_id       number
                      constraint wwv_flow_adv_chk_cat_fk
                      references wwv_flow_advisor_categories(id)
                      on delete cascade,
    is_default        varchar2(1)    not null
                      constraint wwv_flow_adv_chk_is_default_ck
                      check (is_default in ('Y', 'N')),
    is_custom         varchar2(1)    not null
                      constraint wwv_flow_adv_chk_is_custom_ck
                      check (is_custom in ('Y', 'N')),
    order_seq         number(4)      not null,
    check_statement   clob,
    flow_id           number /* no foreign key by intension -> would be dropped if application gets reinstalled */
    );

alter table wwv_flow_advisor_checks
  add constraint wwv_flow_adv_chk_code_uk unique (code);

create index wwv_flow_adv_chk_cat_idx1 on wwv_flow_advisor_checks (category_id);

comment on table wwv_flow_advisor_checks is
    'Contains the meta data of the checks performed by the APEX Advisory module.';
comment on column wwv_flow_advisor_checks.code is
    'Code used in program code to reference the record.';
comment on column wwv_flow_advisor_checks.description is
    'A description for the check.';
comment on column wwv_flow_advisor_checks.help_text is
    'More information what the check does.';
comment on column wwv_flow_advisor_checks.category_id is
    'References a category for the check.';
comment on column wwv_flow_advisor_checks.is_default is
    'If set to true (Y=True, N=False) the check will be checked by default.';
comment on column wwv_flow_advisor_checks.is_custom is
    'If set to true (Y=True, N=False) it indicates that it''s a custom check added to the advisor.';
comment on column wwv_flow_advisor_checks.order_seq is
    'Order sequence to display the categories based on there priority.';
comment on column wwv_flow_advisor_checks.check_statement is
    'SQL Statement to check something. Has to return the following columns
      VIEW_NAME, PK_VALUE, COLUMN_NAME, MESSAGE_CODE, PARAMETER1, PARAMETER2
      The PK_VALUE is used for looking up the record in VIEW_NAME and COLUMN_NAME
      is the column which shows up as having an error. MESSAGE_CODE is an entry in
      WWV_FLOW_ADVISOR_CHECK_MSGS. PARAMETER1 and 2 are placeholders (%1, %2) in
      the defined message.
      The Statement also has to have two bind variables called :p_application_id and
      :p_page_id where the last one is used with NVL(:p_page_id, PAGE_ID)';
comment on column wwv_flow_advisor_checks.flow_id IS
     'References an application id to make the check only available for a specific application. Eg. for QA checks.';

--==============================================================================
create table wwv_flow_advisor_check_msgs (
    id           number
                 constraint wwv_flow_adv_chk_msg_pk
                 primary key,
    check_id     number         not null
                 constraint wwv_flow_adv_chk_msg_check_fk
                 references wwv_flow_advisor_checks(id)
                 on delete cascade,
    code         varchar2(30)   not null
                 constraint wwv_flow_adv_chk_msg_code_ck
                 check (upper(code)=code),
    message_text varchar2(2000),
    help_text    varchar2(2000)
    );

alter table wwv_flow_advisor_check_msgs
  add constraint wwv_flow_adv_chk_msg_code_uk unique (check_id, code);

comment on table wwv_flow_advisor_check_msgs is
    'Contains the possible messages for an advisor check.';
comment on column wwv_flow_advisor_check_msgs.code is
    'Code used in program code to reference the record.';
comment on column wwv_flow_advisor_check_msgs.message_text is
    'Message which is displayed when the check fails. Can contain the placeholders %1 and %2.';
comment on column wwv_flow_advisor_check_msgs.help_text is
    'More information why the check is performed and what should be fixed.';

--##############################################################################
--#
--# USER INTERFACE DEFAULTS
--#
--##############################################################################
prompt USER INTERFACE DEFAULTS

--==============================================================================
create table wwv_flow_hnt_table_info (
    table_id             number        not null
                             constraint wwv_flow_hnt_table_info_pk
                             primary key,
    schema               varchar2(128)  not null,
    table_name           varchar2(128)  not null,
    --
    form_region_title    varchar2(255),
    report_region_title  varchar2(255),
    --
    created_by           varchar2(255)  not null,
    created_on           date          not null,
    last_updated_by      varchar2(255),
    last_updated_on      date,
    --
    title                varchar2(255)
 )
/

alter table wwv_flow_hnt_table_info
    add constraint wwv_flow_hnt_table_info_uk
        unique (schema, table_name)
/

--==============================================================================
create table wwv_flow_hnt_groups (
    group_id            number        not null
                            constraint wwv_flow_hnt_groups_pk
                            primary key,
    table_id            number        not null
                            constraint wwv_flow_hnt_groups_tab_fk
                            references wwv_flow_hnt_table_info
                            on delete cascade,
    group_name          varchar2(255) not null,
    description         varchar2(4000),
    display_sequence    number,
    --
    created_by           varchar2(255)  not null,
    created_on           date          not null,
    last_updated_by      varchar2(255),
    last_updated_on      date
    )
/

alter table wwv_flow_hnt_groups
    add constraint wwv_flow_hnt_groups_uk
        unique (table_id, group_name)
/

--==============================================================================
create table wwv_flow_hnt_column_info (
    column_id           number        not null
                            constraint wwv_flow_hnt_column_info_pk
                            primary key,
    table_id            number        not null
                            constraint wwv_flow_hnt_col_info_tab_fk
                            references wwv_flow_hnt_table_info
                            on delete cascade,
    column_name         varchar2(128)  not null,
    --
    group_id            number
                            constraint wwv_flow_hnt_col_info_grp_fk
                            references wwv_flow_hnt_groups
                            on delete set null,
    label               varchar2(255),
    help_text           varchar2(4000),
    mask_form           varchar2(255),
    display_seq_form    number,
    display_in_form     varchar2(1)
                            constraint wwv_fhc_display_in_form
                            check (display_in_form in ('Y','N')),
    display_as_form     varchar2(50)
                            constraint wwv_fhc_display_as_form
                            check (display_as_form in (
                                'DISPLAY_ONLY_PLSQL',
                                'FILE',
                                'BUTTON',
                                'HIDDEN',
                                'HIDDEN_PROTECTED',
                                'DISPLAY_ONLY_HTML',
                                'STOP_AND_START_HTML_TABLE',
                                'DISPLAY_ONLY_ESCAPE_SC',
                                'IMAGE',
                                'DISPLAY_AND_SAVE',
                                'DISPLAY_AND_SAVE_LOV',
                                'CHECKBOX',
                                'POPUP',
                                'POPUP_FILTER',
                                'POPUP2',
                                'POPUP3',
                                'POPUP4',
                                'POPUP5',
                                'POPUP6',
                                'POPUP_KEY_LOV',
                                'POPUP_KEY_LOV_NOFETCH',
                                'POPUP_COLOR',
                                'PICK_DATE_USING_FLOW_FORMAT_MASK',
                                'PICK_DATE_USING_APP_FORMAT_MASK',
                                'PICK_DATE_USING_APP_DATE_FORMAT',
                                'PICK_DATE_USING_FORMAT_MASK',
                                'PICK_DATE_DD_MON_RR',
                                'PICK_DATE_DD_MON_RR_HH_MI',
                                'PICK_DATE_DD_MON_RR_HH24_MI',
                                'PICK_DATE_DD_MON_YYYY',
                                'PICK_DATE_DD_MON_YYYY_HH_MI',
                                'PICK_DATE_DD_MON_YYYY_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY',
                                'PICK_DATE_DD_MM_YYYY_HH_MI',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI',
                                'PICK_DATE_MM_DD_YYYY',
                                'PICK_DATE_MM_DD_YYYY_HH_MI',
                                'PICK_DATE_MM_DD_YYYY_HH24_MI',
                                'PICK_DATE_DD_MON_YY',
                                'PICK_DATE_DD_MON_YY_HH_MI',
                                'PICK_DATE_DD_MON_YY_HH24_MI',
                                'PICK_DATE_YYYY_MM_DD',
                                'PICK_DATE_YYYY_MM_DD_HH_MI',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI',
                                'PICK_DATE_RR_MON_DD',
                                'PICK_DATE_RR_MON_DD_HH_MI',
                                'PICK_DATE_RR_MON_DD_HH24_MI',
                                'PICK_DATE_DD_MM_YYYY_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                                'PICK_DATE_DD_MM_YYYY_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                                'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                                'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                                'PICK_DATE_YYYY_MM_DD_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                                'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
                                'DISPLAY_ONLY_LOV',
                                'COMBOBOX',
                                'SHOW_AS_SL_WITH_POPUP',
                                'COMBOBOX_WITH_URL_REDIRECT',
                                'COMBOBOX_WITH_BRANCH_TO_PAGE',
                                'COMBOBOX_WITH_SUBMIT',
                                'COMBOBOX_WITH_JS_POST',
                                'COMBOBOX_WITH_JS_REDIRECT',
                                'MULTIPLESELECT',
                                'SHUTTLE',
                                'RADIOGROUP',
                                'RADIOGROUP2',
                                'RADIOGROUP_WITH_REDIRECT',
                                'RADIOGROUP_WITH_SUBMIT',
                                'RADIOGROUP_WITH_JS_SUBMIT',
                                'TEXTAREA',
                                'TEXTAREA_WITH_SPELL_CHECK',
                                'TEXTAREA-AUTO-HEIGHT',
                                'TEXTAREA_WITH_CONTROLS',
                                'TEXTAREA_WITH_HTML_EDITOR_BASIC',
                                'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
                                'TEXTAREA_CHAR_COUNT',
                                'TEXTAREA_CHAR_COUNT_SPELL',
                                'TEXT',
                                'TEXT_WITH_ENTER_SUBMIT',
                                'TEXT_DISABLED',
                                'TEXT_DISABLED_AND_SAVE',
                                'TEXT_WITH_CALCULATOR',
                                'PASSWORD',
                                'PASSWORD_WITH_ENTER_SUBMIT',
                                'PASSWORD_DNSS',
                                'PASSWORD_WITH_SUBMIT_DNSS',
                                'LIST_MGR',
                                'LIST_MGR2',
                                'LIST_MGR3',
                                'LIST_MGR_VIEW',
                                'LIST_MGR_VIEW2',
                                -- 4.0
                                'SELECT_LIST_WITH_POPUP',
                                'TEXT_WITH_SELECT_LIST',
                                'TEXTAREA_WITH_POPUP'
                                ) or
                                display_as_form like 'NATIVE\_%' escape '\'),
    --
    form_attribute_01   varchar2(4000),
    form_attribute_02   varchar2(4000),
    form_attribute_03   varchar2(4000),
    form_attribute_04   varchar2(4000),
    form_attribute_05   varchar2(4000),
    form_attribute_06   varchar2(4000),
    form_attribute_07   varchar2(4000),
    form_attribute_08   varchar2(4000),
    form_attribute_09   varchar2(4000),
    form_attribute_10   varchar2(4000),
    form_attribute_11   varchar2(4000),
    form_attribute_12   varchar2(4000),
    form_attribute_13   varchar2(4000),
    form_attribute_14   varchar2(4000),
    form_attribute_15   varchar2(4000),
    --
    display_as_tab_form varchar2(255)
                            constraint wwv_fhc_display_as_tab_form
                            check (display_as_tab_form in (
                               'READONLY',
                               'DISPLAY_AND_SAVE',
                               'WITHOUT_MODIFICATION',
                               'ESCAPE_SC',
                               'TEXT',
                               'TEXT_FROM_LOV',
                               'TEXTAREA',
                               'SELECT_LIST',
                               'SELECT_LIST_FROM_LOV',
                               'SELECT_LIST_FROM_QUERY',
                               'CHECKBOX',
                               'SIMPLE_CHECKBOX',
                               'RADIOGROUP',
                               'HIDDEN',
                               'HIDDEN_PROTECTED',
                               'POPUP',
                               'POPUP_QUERY',
                               'DATE_POPUP',
                               'DATE_PICKER',
                               'PICK_DATE_USING_APP_FORMAT_MASK',
                               'PICK_DATE_USING_APP_DATE_FORMAT',
                               'PICK_DATE_USING_FORMAT_MASK',
                               'PICK_DATE_DD_MON_RR',
                               'PICK_DATE_DD_MON_RR_HH_MI',
                               'PICK_DATE_DD_MON_RR_HH24_MI',
                               'PICK_DATE_DD_MON_YYYY',
                               'PICK_DATE_DD_MON_YYYY_HH_MI',
                               'PICK_DATE_DD_MON_YYYY_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY',
                               'PICK_DATE_DD_MM_YYYY_HH_MI',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI',
                               'PICK_DATE_MM_DD_YYYY',
                               'PICK_DATE_MM_DD_YYYY_HH_MI',
                               'PICK_DATE_MM_DD_YYYY_HH24_MI',
                               'PICK_DATE_DD_MON_YY',
                               'PICK_DATE_DD_MON_YY_HH_MI',
                               'PICK_DATE_DD_MON_YY_HH24_MI',
                               'PICK_DATE_YYYY_MM_DD',
                               'PICK_DATE_YYYY_MM_DD_HH_MI',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI',
                               'PICK_DATE_RR_MON_DD',
                               'PICK_DATE_RR_MON_DD_HH_MI',
                               'PICK_DATE_RR_MON_DD_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                               'PICK_DATE_YYYY_MM_DD_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH')),
    display_seq_report  number,
    display_in_report   varchar2(1)
                            constraint wwv_fhc_display_in_report
                            check (display_in_report in ('Y','N')),
    display_as_report   varchar2(255)
                            constraint wwv_fhc_display_as_report
                            check (display_as_report in (
                               'READONLY',
                               'DISPLAY_AND_SAVE',
                               'WITHOUT_MODIFICATION',
                               'ESCAPE_SC',
                               'TEXT',
                               'TEXT_FROM_LOV',
                               'TEXTAREA',
                               'SELECT_LIST',
                               'SELECT_LIST_FROM_LOV',
                               'SELECT_LIST_FROM_QUERY',
                               'CHECKBOX',
                               'SIMPLE_CHECKBOX',
                               'RADIOGROUP',
                               'HIDDEN',
                               'HIDDEN_PROTECTED',
                               'POPUP',
                               'POPUP_QUERY',
                               'DATE_POPUP',
                               'DATE_PICKER',
                               'PICK_DATE_USING_APP_FORMAT_MASK',
                               'PICK_DATE_USING_APP_DATE_FORMAT',
                               'PICK_DATE_USING_FORMAT_MASK',
                               'PICK_DATE_DD_MON_RR',
                               'PICK_DATE_DD_MON_RR_HH_MI',
                               'PICK_DATE_DD_MON_RR_HH24_MI',
                               'PICK_DATE_DD_MON_YYYY',
                               'PICK_DATE_DD_MON_YYYY_HH_MI',
                               'PICK_DATE_DD_MON_YYYY_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY',
                               'PICK_DATE_DD_MM_YYYY_HH_MI',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI',
                               'PICK_DATE_MM_DD_YYYY',
                               'PICK_DATE_MM_DD_YYYY_HH_MI',
                               'PICK_DATE_MM_DD_YYYY_HH24_MI',
                               'PICK_DATE_DD_MON_YY',
                               'PICK_DATE_DD_MON_YY_HH_MI',
                               'PICK_DATE_DD_MON_YY_HH24_MI',
                               'PICK_DATE_YYYY_MM_DD',
                               'PICK_DATE_YYYY_MM_DD_HH_MI',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI',
                               'PICK_DATE_RR_MON_DD',
                               'PICK_DATE_RR_MON_DD_HH_MI',
                               'PICK_DATE_RR_MON_DD_HH24_MI',
                               'PICK_DATE_DD_MM_YYYY_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
                               'PICK_DATE_DD_MM_YYYY_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
                               'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
                               'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
                               'PICK_DATE_YYYY_MM_DD_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
                               'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH')),
    mask_report         varchar2(255),
    aggregate_by        varchar2(1)
                            constraint wwv_fhc_aggregate_by
                            check (aggregate_by in ('Y','N')),
    lov_query           varchar2(4000),
    default_value       varchar2(255),
    required            varchar2(1)
                            constraint wwv_fhc_required
                            check (required in ('Y','N')),
    alignment           varchar2(1)
                            constraint wwv_fhc_alignment
                            check (alignment in ('L','C','R')),
    display_width       number,
    max_width           number,
    height              number,
    group_by            varchar2(1)
                            constraint wwv_fhc_group_by
                            check (group_by in ('Y','N')),
    order_by_seq        number,
    order_by_asc_desc   varchar2(1)
                            constraint wwv_fhc_order_by
                            check (order_by_asc_desc in ('A','D')),
    searchable          varchar2(1)
                            constraint wwv_fhc_searchable
                            check (searchable in ('Y','N')),
    created_by          varchar2(255)  not null,
    created_on          date          not null,
    last_updated_by     varchar2(255),
    last_updated_on     date)
/

alter table wwv_flow_hnt_column_info
    add constraint wwv_flow_hnt_column_info_uk
        unique (table_id, column_name)
/

create index wwv_flow_hnt_column_info_idx on wwv_flow_hnt_column_info (group_id)
/

--==============================================================================
create table wwv_flow_hnt_lov_data (
    id                 number         not null
                           constraint wwv_flow_hnt_lov_data_pk
                           primary key,
    --
    column_id          number         not null
                           constraint wwv_flow_hnt_lov_data_col_fk
                           references wwv_flow_hnt_column_info
                           on delete cascade,
    lov_disp_sequence  number         not null,
    lov_disp_value     varchar2(4000) not null,
    lov_return_value   varchar2(4000) not null,
    last_updated_by    varchar2(255)   not null,
    last_updated_on    date           not null,
    -- 4.0
    created_by         varchar2(255),
    created_on         date)
/

create index wwv_flow_hnt_lov_data_idx on wwv_flow_hnt_lov_data (column_id)
/

--==============================================================================
create table wwv_flow_hnt_column_dict (
    column_id           number        not null
                            constraint wwv_fhcd_pk
                            primary key,
    security_group_id   number not null
                            constraint wwv_fhcd_sgid_fk
                            references wwv_flow_companies(provisioning_company_id)
                            on delete cascade,
    column_name         varchar2(128)  not null,
    --
    label               varchar2(4000),
    help_text           varchar2(4000),
    format_mask         varchar2(255),
    default_value       varchar2(255),
    --
    form_format_mask    varchar2(255),
    form_display_width  number,
    form_display_height number,
    form_data_type      varchar2(30)
                            constraint wwv_fhcd_form_data_type
                            check (form_data_type in (
                            'VARCHAR',
                            'NUMBER',
                            'DATE')),
    --
    report_format_mask    varchar2(4000),
    report_col_alignment  varchar2(10)
                            constraint wwv_fhcd_col_alignment
                            check (report_col_alignment in ('LEFT','CENTER','RIGHT')),
    --
    created_by          varchar2(255)  not null,
    created_on          date           not null,
    last_updated_by     varchar2(255),
    last_updated_on     date)
/
alter table wwv_flow_hnt_column_dict
    add constraint wwv_fhcd_uk
        unique (security_group_id, column_name)
/

--==============================================================================
create table wwv_flow_hnt_col_dict_syn (
    syn_id              number        not null
                            constraint wwv_flow_hnt_col_dict_syn_pk
                            primary key,
    column_id           number        not null
                            constraint wwv_flow_hnt_col_dict_syn_fk
                            references wwv_flow_hnt_column_dict
                            on delete cascade,
    security_group_id   number        not null,
    syn_name            varchar2(128)  not null,
    --
    created_by          varchar2(255) not null,
    created_on          date          not null,
    last_updated_by     varchar2(255),
    last_updated_on     date)
/
alter table wwv_flow_hnt_col_dict_syn
    add constraint wwv_flow_hnt_col_dict_syn_uk
        unique (security_group_id, syn_name)
/

create index wwv_flow_hnt_col_dict_syn_idx1 on wwv_flow_hnt_col_dict_syn (column_id)
/

--==============================================================================
create table wwv_flow_region_chart_ser_attr (
    id                           number
                                 constraint wwv_flow_chart_series_pk
                                 primary key,
    region_id                    number not null
                                 constraint wwv_flow_seattr_to_region_fk
                                 references wwv_flow_page_plugs
                                 on delete cascade,
    series_id                    number not null,
    security_group_id            number not null,
    a001                         clob,
    a002                         varchar2(4000),
    a003                         varchar2(4000),
    a004                         varchar2(4000),
    a005                         varchar2(4000),
    a006                         varchar2(4000),
    a007                         varchar2(4000),
    a008                         varchar2(4000),
    a009                         varchar2(4000),
    a010                         varchar2(4000),
    a011                         varchar2(4000),
    a012                         varchar2(4000),
    a013                         varchar2(4000),
    a014                         varchar2(4000),
    a015                         varchar2(4000),
    a016                         varchar2(4000),
    a017                         varchar2(4000),
    a018                         varchar2(4000),
    a019                         varchar2(4000),
    a020                         varchar2(4000),
    a021                         varchar2(4000),
    a022                         varchar2(4000),
    a023                         varchar2(4000),
    a024                         varchar2(4000),
    a025                         varchar2(4000),
    a026                         varchar2(4000),
    a027                         varchar2(4000),
    a028                         varchar2(4000),
    a029                         varchar2(4000),
    a030                         varchar2(4000),
    a031                         varchar2(4000),
    a032                         varchar2(4000),
    a033                         varchar2(4000),
    a034                         varchar2(4000),
    a035                         varchar2(4000),
    a036                         varchar2(4000),
    a037                         varchar2(4000),
    a038                         varchar2(4000),
    a039                         varchar2(4000),
    a040                         varchar2(4000),
    a041                         varchar2(4000),
    a042                         varchar2(4000),
    a043                         varchar2(4000),
    a044                         varchar2(4000),
    a045                         varchar2(4000),
    a046                         varchar2(4000),
    a047                         varchar2(4000),
    a048                         varchar2(4000),
    a049                         varchar2(4000),
    a050                         varchar2(4000))
/

create unique index wwv_flow_chart_seattr_idx on wwv_flow_region_chart_ser_attr (region_id,series_id)
/

--##############################################################################
--#
--# FEEDBACK
--#
--##############################################################################
prompt FEEDBACK

--==============================================================================
create table  wwv_flow_feedback (
    id                                number,
    feedback_id                       number,
    feedback_comment                  varchar2(4000),
    feedback_type                     number,
    feedback_rating                   number,
    --
    feedback_status                   number,
    developer_comment                 varchar2(4000),
    public_response                   varchar2(4000),
    --
    application_id                    number,
    application_name                  varchar2(255),
    page_id                           number,
    page_name                         varchar2(255),
    page_last_updated_by              varchar2(255),
    page_last_updated_on              date,
    session_id                        varchar2(255),
    apex_user                         varchar2(255),
    user_email                        varchar2(255),
    application_version               varchar2(255),
    session_info                      varchar2(4000),
    session_state                     varchar2(4000),
    parsing_schema                    varchar2(255),
    --
    screen_width                      varchar2(30),
    screen_height                     varchar2(30),
    http_user_agent                   varchar2(4000),
    remote_addr                       varchar2(4000),
    remote_user                       varchar2(4000),
    http_host                         varchar2(4000),
    server_name                       varchar2(4000),
    server_port                       varchar2(4000),
    tags                              varchar2(4000),
    --
    label_01                          varchar2(4000),
    label_02                          varchar2(4000),
    label_03                          varchar2(4000),
    label_04                          varchar2(4000),
    label_05                          varchar2(4000),
    label_06                          varchar2(4000),
    label_07                          varchar2(4000),
    label_08                          varchar2(4000),
        --
    attribute_01                      varchar2(4000),
    attribute_02                      varchar2(4000),
    attribute_03                      varchar2(4000),
    attribute_04                      varchar2(4000),
    attribute_05                      varchar2(4000),
    attribute_06                      varchar2(4000),
    attribute_07                      varchar2(4000),
    attribute_08                      varchar2(4000),
    --
    bug_id                            number,
    feature_id                        number,
    task_id                           number,
    issue_id  						  number,
    --
    logging_email                     varchar2(255),
    logging_security_group_id         number,
    logged_by_workspace_name          varchar2(255),
    deployment_system                 varchar2(8),
    security_group_id                 number not null
                                      constraint wwv_flow_feedback_fk
                                      references wwv_flow_companies(provisioning_company_id)
                                      on delete cascade,
    created_by                        varchar2(255) not null enable,
    created_on                        timestamp with time zone not null,
    updated_by                        varchar2(255),
    updated_on                        timestamp with time zone,
    constraint wwv_flow_feedback_pk   primary key (id) enable
)
/

create index wwv_flow_feedback_idx1 on wwv_flow_feedback (security_group_id);
create index wwv_flow_feedback_idx2 on wwv_flow_feedback (application_id, page_id);
create index wwv_flow_feedback_idx3 on wwv_flow_feedback (bug_id);
create index wwv_flow_feedback_idx4 on wwv_flow_feedback (feature_id);
create index wwv_flow_feedback_idx5 on wwv_flow_feedback (task_id);
create index wwv_flow_feedback_idx6 on wwv_flow_feedback (feedback_id);
create index wwv_flow_feedback_idx7 on wwv_flow_feedback (issue_id);

--==============================================================================
create table wwv_flow_feedback_followup (
    id                               number,
    feedback_id                      constraint wwv_flow_feedback_fup_fk
                                     references wwv_flow_feedback(id)
                                     on delete cascade,
    follow_up                        varchar2(4000) not null,
    email                            varchar2(255),
    created_by                       varchar2(255) not null enable,
    created_on                       timestamp with time zone not null,
  updated_by                       varchar2(255),
  updated_on                       timestamp with time zone,
    constraint wwv_flow_feedback_fup_pk primary key (id) enable
)
/

create index wwv_flow_feedback_fup_idx1 on wwv_flow_feedback_followup (feedback_id);

--##############################################################################
--#
--# MAIL QUEUE
--#
--##############################################################################
prompt MAIL QUEUE

--==============================================================================
create table wwv_flow_mail_queue
(
  id number constraint wwv_flow_mail_queue_pk
                       primary key,
  mail_to              varchar2(4000),
  mail_from            varchar2(4000),
  mail_replyto         varchar2(4000),
  mail_subj            varchar2(4000),
  mail_cc              varchar2(4000),
  mail_bcc             varchar2(4000),
  mail_body            clob,
  mail_body_html       clob,
  mail_send_count      number(2),
  mail_send_error      varchar2(4000),
  mail_message_created date,
  includes_html        number(1) default 0,
  last_updated_by      varchar2(255),
  last_updated_on      date,
  flow_id              number,
  security_group_id    number not null
)
/

create index wwv_flow_mail_queue_idx1 on wwv_flow_mail_queue ( security_group_id )
/

--==============================================================================
create table wwv_flow_mail_attachments
(
  id number constraint wwv_flow_mail_attachments_pk
                       primary key,
  mail_id              number not null
                           constraint wwv_flow_mail_attachments_fk1
                           references wwv_flow_mail_queue(id)
                           on delete cascade,
  filename             varchar2(4000) not null,
  mime_type            varchar2(255)   not null,
  inline               varchar2(1)    not null
                           constraint wwv_flow_mail_attachments_ck1
                           check (inline in ('Y','N')),
  attachment           blob,
  last_updated_by      varchar2(255),
  last_updated_on      date,
  security_group_id    number not null
)
/

create index wwv_flow_mail_attachments_idx1 on wwv_flow_mail_attachments ( mail_id, security_group_id )
/

--==============================================================================
create table wwv_flow_mail_log(
    mail_id                 number,
    mail_to                 varchar2(4000),
    mail_from               varchar2(4000),
    mail_replyto            varchar2(4000),
    mail_subj               varchar2(4000),
    mail_cc                 varchar2(4000),
    mail_bcc                varchar2(4000),
    mail_send_error         varchar2(4000),
    mail_message_id         varchar2(4000),
    mail_message_created    date,
    mail_message_send_begin date,
    mail_message_send_end   date,
    mail_body_size          number,
    mail_body_html_size     number,
    mail_attachment_count   number,
    mail_attachment_size    number,
    last_updated_by         varchar2(255),
    last_updated_on         date,
    flow_id                 number,
    security_group_id       number not null
    )
    pctfree 0
/


create index wwv_flow_mail_log_idx1 on wwv_flow_mail_log ( substr(mail_to,1,500) )
/

create index wwv_flow_mail_log_idx2 on wwv_flow_mail_log ( last_updated_by )
/

create index wwv_flow_mail_log_idx3 on wwv_flow_mail_log ( security_group_id, last_updated_on )
/


--##############################################################################
--#
--# LOGS
--#
--##############################################################################
prompt LOGS

--==============================================================================
create table wwv_flow_log_numbers (
    current_log_number     number not null
                           constraint wwv_flow_log_number_ck1
                           check (current_log_number in (1,2)),
    log_switched_date      date   not null,
    log_switch_after_days  number not null
                           constraint wwv_flow_log_numbers_ck2
                           check (log_switch_after_days between 1 and 180),
    log_name               varchar2(255) not null
                           constraint wwv_flow_log_numbers_ck3
                           check (log_name in ('ACCESS','ACTIVITY','CLICKTHRU','DEBUG','WEBSERVICE')),
    constraint wwv_flow_log_numbers_pk primary key( log_name )
    )
    organization index
/

alter table wwv_flow_log_numbers add constraint wwv_flow_log_numbers_ck4
    check (trunc(abs(log_switch_after_days)) = log_switch_after_days)
/

--==============================================================================
create table wwv_flow_auto_file_delete_log(
    id                     number
                           constraint wwv_flow_auto_file_del_log_pk
                           primary key,
    security_group_id      number             not null,
    workspace_name         varchar2(4000)     not null,
    workspace_display_name varchar2(4000),
    file_name              varchar2(4000)     not null,
    file_id                number             not null,
    file_type              varchar2(4000),
    file_size              number,
    deleted_on             date )
/

--==============================================================================
-- Duplicate Page Submision Prevension
create table wwv_flow_page_submissions (
    submit_id          number
                       constraint wwv_flow_page_submissions_pk
                       primary key,
    security_group_id  number not null,
    flow_id            number not null
                       constraint wwv_flow_page_sub_fk
                       references wwv_flows on delete cascade,
    page_id            number,
    session_id         number
                       constraint wwv_flow_page_sub_sess_fk
                       references wwv_flow_sessions$ on delete cascade
    )
    pctfree 0
/

create index wwv_flow_page_sub_idx1 on wwv_flow_page_submissions (flow_id)
/
create index wwv_flow_page_sub_idx2 on wwv_flow_page_submissions (session_id)
/

--==============================================================================
create table wwv_flow_clickthru_log$ (
    clickdate           date,
    category            varchar2(255),
    id                  number,
    flow_user           varchar2(255),
    ip                  varchar2(30),
    security_group_id   number not null
    )
    pctfree 0
/

--==============================================================================
create table wwv_flow_clickthru_log2$ (
    clickdate           date,
    category            varchar2(255),
    id                  number,
    flow_user           varchar2(255),
    ip                  varchar2(30),
    security_group_id   number not null
    )
    pctfree 0
/

--==============================================================================
create table wwv_flow_builder_audit_trail (
   id                        number
                             constraint wwv_flow_bld_audit_pk
                             primary key,
   audit_date                date,
   audit_action              varchar2(1)
                             constraint wwv_flow_bld_audit_ck_a
                             check (audit_action in ('I','U','D')),
   flow_table                varchar2(30),
   flow_table_pk             number,
   flow_user                 varchar2(255),
   flow_id                   number,
   page_id                   number,
   security_group_id         number not null,
   scn                       number,
   audit_comment             varchar2(255),
   object_name               varchar2(4000))
   pctfree 0
/

create index wwv_flow_build_audit_trail_i3 on wwv_flow_builder_audit_trail (flow_id, security_group_id) compress
/

create index wwv_flow_build_audit_trail_i5 on wwv_flow_builder_audit_trail (security_group_id,flow_user,flow_id,audit_date) compress 3
/

create index wwv_flow_build_audit_trail_i6 on wwv_flow_builder_audit_trail (audit_date)
/


--==============================================================================
-- F L O W   A C T I V I T Y   L O G G I N G
--
-- logging can be disabled
-- you may not wish to maintain indexes on log tables for active applications
--

--==============================================================================
-- IF YOU CHANGE THIS TABLE OR ITS INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--
-- security group id for logs is not set via a trigger for performance reasons
--==============================================================================
create table wwv_flow_activity_log1$ (
    time_stamp_tz          timestamp with time zone not null,
    time_stamp             date generated always as (
                             cast(time_stamp_tz as date)
                           ) virtual not null,
    elap                   number,
    num_rows               number,
    userid                 varchar2(255),
    flow_id                number,
    step_id                number,
    session_id             number,
    security_group_id      number not null,
    ecid                   varchar2(64),
    tenant_id              varchar2(32),
    page_mode              varchar2(1),
    page_view_type         number
                           constraint wwv_flow_activity_log1$ck1 check(page_view_type between 0 and 5),
    cached_regions         number,
    content_length         number,
    request_value          varchar2(4000),
    sqlerrm                varchar2(4000),
    sqlerrm_component_type varchar2(255),
    sqlerrm_component_name varchar2(255),
    debug_page_view_id     number,
    --
    ip_address             varchar2(4000),
    user_agent             varchar2(4000),
    worksheet_id           number,         -- IR logging set for interactive report regions
    ir_search              varchar2(4000), -- IR logging set for interactive report regions
    ir_report_id           number,         -- IR logging set for interactive report regions
    websheet_id            number,         -- Websheet logging wwv_flow_ws_applications.id
    webpage_id             number,         -- Websheet logging wwv_flow_ws_webpages.id
    datagrid_id            number          -- Websheet logging wwv_flow_ws_websheet_attr.id
    )
    initrans 8
    pctfree  0
/

create index wwv_flow_activity_log1$_idx1 on wwv_flow_activity_log1$ (
    time_stamp )
    initrans 8
    compress
/

create index wwv_flow_activity_log1$_idx2 on wwv_flow_activity_log1$ (
    security_group_id,
    flow_id )
    initrans 8
    compress 2
/

create index wwv_flow_activity_log1$_idx3
    on wwv_flow_activity_log1$(websheet_id)
    initrans 8
    compress
/


--==============================================================================
-- IF YOU CHANGE THIS TABLE OR IT'S INDEXES
-- do not forget to synchronize ../utilities/apxpart.sql
--==============================================================================
create table wwv_flow_activity_log2$ (
    time_stamp_tz          timestamp with time zone not null,
    time_stamp             date generated always as (
                             cast(time_stamp_tz as date)
                           ) virtual not null,
    elap                   number,
    num_rows               number,
    userid                 varchar2(255),
    flow_id                number,
    step_id                number,
    session_id             number,
    security_group_id      number not null,
    ecid                   varchar2(64),
    tenant_id              varchar2(32),
    page_mode              varchar2(1),
    page_view_type         number
                           constraint wwv_flow_activity_log2$ck1 check(page_view_type between 0 and 5),
    cached_regions         number,
    content_length         number,
    request_value          varchar2(4000),
    sqlerrm                varchar2(4000),
    sqlerrm_component_type varchar2(255),
    sqlerrm_component_name varchar2(255),
    debug_page_view_id     number,
    --
    ip_address             varchar2(4000),
    user_agent             varchar2(4000),
    worksheet_id           number,         -- IR logging set for interactive report regions
    ir_search              varchar2(4000), -- IR logging set for interactive report regions
    ir_report_id           number,         -- IR logging set for interactive report regions
    websheet_id            number,         -- Websheet logging wwv_flow_ws_applications.id
    webpage_id             number,         -- Websheet logging wwv_flow_ws_webpages.id
    datagrid_id            number          -- Websheet logging wwv_flow_ws_websheet_attr.id
    )
    initrans 8
    pctfree 0
/

create index wwv_flow_activity_log2$_idx1 on wwv_flow_activity_log2$ (
    time_stamp )
    initrans 8
    compress
/

create index wwv_flow_activity_log2$_idx2 on wwv_flow_activity_log2$ (
    security_group_id,
    flow_id )
    initrans 8
    compress 2
/

create index wwv_flow_activity_log2$_idx3
    on wwv_flow_activity_log2$(websheet_id)
    initrans 8
    compress
/

--==============================================================================
-- Access Log
--
create table wwv_flow_user_access_log1$ (
    login_name             varchar2(255) not null,
    authentication_method  varchar2(255),
    application            number,
    owner                  varchar2(255),
    access_date            date,
    ip_address             varchar2(255),
    remote_user            varchar2(255),
    authentication_result  number, -- 0:okay,1:invalid user,2:account locked,3:account expired,4:password mismatch,5:pw first use,6:attempts exceeded
    custom_status_text     varchar2(4000),
    security_group_id      number not null
    )
    pctfree 0
/
create index wwv_flow_user_access_log1$_ix1 on  wwv_flow_user_access_log1$ (
    security_group_id,
    application,
    access_date )
    compress 2
/

--==============================================================================
create table wwv_flow_user_access_log2$ (
    login_name             varchar2(255) not null,
    authentication_method  varchar2(255),
    application            number,
    owner                  varchar2(255),
    access_date            date,
    ip_address             varchar2(255),
    remote_user            varchar2(255),
    authentication_result  number, -- 0:okay,1:invalid user,2:account locked,3:account expired,4:password mismatch,5:pw first use,6:attempts exceeded
    custom_status_text     varchar2(4000),
    security_group_id      number not null
    )
    pctfree 0
/
create index wwv_flow_user_access_log2$_ix1 on  wwv_flow_user_access_log2$ (
    security_group_id,
    application,
    access_date )
    compress 2
/

--==============================================================================
create table wwv_flow_debug_messages (
    id                            number,
    page_view_id                  number,
    message_timestamp             timestamp with time zone not null,
    message                       varchar2(4000),
    flow_id                       number,
    page_id                       number,
    session_id                    number not null,
    apex_user                     varchar2(255),
    elap                          number,
    message_level                 number,
    security_group_id             number not null,
    call_stack                    varchar2(4000),
    constraint wwv_flow_debug_messages_pk primary key (
        id )
    )
    initrans 8
    pctfree  0
/
alter  index wwv_flow_debug_messages_pk rebuild initrans 8;
create index wwv_flow_debug_messages_idx1 on wwv_flow_debug_messages (session_id)        compress initrans 8;
create index wwv_flow_debug_messages_idx2 on wwv_flow_debug_messages (security_group_id) compress initrans 8;
create index wwv_flow_debug_messages_idx3 on wwv_flow_debug_messages (page_view_id)      compress initrans 8;

create table wwv_flow_debug_messages2 (
    id                            number,
    page_view_id                  number,
    message_timestamp             timestamp with time zone not null,
    message                       varchar2(4000),
    flow_id                       number,
    page_id                       number,
    session_id                    number not null,
    apex_user                     varchar2(255),
    elap                          number,
    message_level                 number,
    security_group_id             number not null,
    call_stack                    varchar2(4000),
    constraint wwv_flow_debug_messages2_pk primary key (
        id )
    )
    initrans 8
    pctfree  0
/

alter  index wwv_flow_debug_messages2_pk rebuild initrans 8;
create index wwv_flow_debug_messages2_idx1 on wwv_flow_debug_messages2 (session_id)        compress initrans 8;
create index wwv_flow_debug_messages2_idx2 on wwv_flow_debug_messages2 (security_group_id) compress initrans 8;
create index wwv_flow_debug_messages2_idx3 on wwv_flow_debug_messages2 (page_view_id)      compress initrans 8;

--==============================================================================
create table wwv_flow_webservice_log1$ (
    url                 varchar2(4000),
    http_method         varchar2(30),
    content_length      number,
    status_code         number,
    resp_content_length number,
    elapsed_sec         number,
    request_date        date,
    flow_user           varchar2(255),
    security_group_id   number not null
)
/

create index wwv_flow_webservice_log1$_idx1 on wwv_flow_webservice_log1$ (request_date)
    initrans 8
    compress
/

create index wwv_flow_webservice_log1$_idx2 on wwv_flow_webservice_log1$ (security_group_id)
    initrans 8
    compress
/

create table wwv_flow_webservice_log2$ (
    url                 varchar2(4000),
    http_method         varchar2(30),
    content_length      number,
    status_code         number,
    resp_content_length number,
    elapsed_sec         number,
    request_date        date,
    flow_user           varchar2(255),
    security_group_id   number not null
)
/

create index wwv_flow_webservice_log2$_idx1 on wwv_flow_webservice_log2$ (request_date)
    initrans 8
    compress
/

create index wwv_flow_webservice_log2$_idx2 on wwv_flow_webservice_log2$ (security_group_id)
    initrans 8
    compress
/

--==============================================================================
create table wwv_flow_log_history (
    log_day               date,            -- identifies day
    workspace_id          number,          -- identifies workspace
    workspace_name        varchar2(255),   -- workspace name
    application_id        number,          -- identifies application
    application_name      varchar2(255),   -- application name
    --
    page_events           number,          -- total page events of all type
    page_views            number,          -- count of page gets
    page_accepts          number,          -- count of page posts
    partial_page_views    number,          -- count of partial page requests
    websheet_views        number,          -- count of views of websheet applications
    rows_fetched          number,          -- sum of rows fetched
    ir_searches           number,          -- count of events that are interactive report filtered executions
    --
    distinct_pages        number,          -- count of distinct pages viewed
    distinct_users        number,          -- count of distinct usernames
    distinct_sessions     number,          -- count of distinct sessions
    --
    average_render_time   number,          -- averge elapsed page generation time
    median_render_time    number,          -- median  elapsed page generation time
    maximum_render_time   number,          -- maximum elapsed page generation time
    total_render_time     number,          -- total elapsed page generation time
    content_length        number,          -- total content size in bytes
    error_count           number,          -- number of page events that raised errors
    --
    public_page_events     number,         -- total page events for public pages
    workspace_login_events number,         -- total page events for APEX Workspace Login (4550:1)
    additional_attributes  varchar2(4000)  -- additional attributes in JSON format
    )
    pctfree 0
/

create unique index wwv_flow_log_history_idx1 on wwv_flow_log_history (workspace_id, application_id, log_day) compress;

create index wwv_flow_log_history_idx2 on wwv_flow_log_history (log_day, workspace_id) compress;

--##############################################################################
--#
--# PURGE
--#
--##############################################################################
prompt PURGE

--==============================================================================
create table wwv_purge_workspaces(
    id                 number not null,
    security_group_id  number not null,
    workspace_name     varchar2(255) not null,
    admin_email        varchar2(255),
    status             varchar2(50)
                       constraint wwv_purge_workspaces_ck1
                       check (status in ('NEW', 'STAGE1', 'STAGE2', 'RETAIN', 'PURGING', 'PURGED')),
    created_ts         timestamp,
    updated_ts         timestamp,
    date_to_purge      date,
    purged_ts          timestamp )
/

alter table wwv_purge_workspaces add constraint wwv_purge_workspaces_pk
    primary key( id, security_group_id )
/


create unique index wwv_purge_workspaces_idx1 on wwv_purge_workspaces ( security_group_id )
/
create index wwv_purge_workspaces_idx2 on wwv_purge_workspaces ( status )
/
create index wwv_purge_workspaces_idx3 on wwv_purge_workspaces ( date_to_purge )
/
create index wwv_purge_workspaces_idx4 on wwv_purge_workspaces ( created_ts )
/

--==============================================================================
create table wwv_purge_log(
    id                 number primary key,
    workspace_name     varchar2(255) not null,
    purge_workspace_id number not null,
    security_group_id  number not null,
    created_ts         timestamp,
    log_code           varchar2(100)
                       constraint wwv_purge_log_ck1 check(log_code in ('NEW','DELETE','EMAIL','RESPONSE_RETAIN',
                           'RESPONSE_PURGE','MOVED_TO_NEW','EMAIL_COMPLETE','REMINDER_EMAIL_COMPLETE','BEGIN_PURGE','PURGE_SCHEMA_EVAL',
                           'PURGE_TABLESPACE_EVAL','PURGE_COMPLETE', 'ERROR_DROP_USER', 'ERROR_DROP_TABLESPACE', 'BEGIN_DROP_USER',
                           'END_DROP_USER', 'BEGIN_DROP_TABLESPACE', 'END_DROP_TABLESPACE', 'BEGIN_DELETE_WORKSPACE',
                           'END_DELETE_WORKSPACE', 'ERROR_DELETE_WORKSPACE')),
    log_action         varchar2(4000),
    log_statement      varchar2(4000),
    log_error          varchar2(4000) )
/

create index wwv_purge_log_idx1 on wwv_purge_log ( security_group_id, log_code, purge_workspace_id )
/

create index wwv_purge_log_idx2 on wwv_purge_log ( log_code, created_ts )
/

--==============================================================================
create table wwv_purge_emails(
    id                 number primary key,
    purge_workspace_id number not null,
    security_group_id  number not null,
    email              varchar2(255) not null,
    created_ts         timestamp )
/

alter table wwv_purge_emails
    add constraint wwv_purge_emails_fk1
    foreign key( purge_workspace_id, security_group_id ) references wwv_purge_workspaces( id, security_group_id )
    on delete cascade
/

create index wwv_purge_emails_idx1 on wwv_purge_emails ( purge_workspace_id, security_group_id, created_ts )
/

--==============================================================================
create table wwv_purge_workspace_responses(
    id                 number primary key,
    purge_email_id     number not null,
    response_code      varchar2(20) not null,  -- PURGE, SAVE
    created_ts         timestamp )
/

alter table wwv_purge_workspace_responses
    add constraint wwv_purge_workspace_resp_fk1
    foreign key( purge_email_id ) references wwv_purge_emails( id )
    on delete cascade
/


create index wwv_purge_workspace_resp_idx1 on wwv_purge_workspace_responses ( purge_email_id, created_ts )
/

--==============================================================================
create table wwv_purge_datafiles(
    id                 number primary key,
    purge_workspace_id number        not null,
    security_group_id  number        not null,
    tablespace_name    varchar2(30)  not null,
    file_name          varchar2(513) not null,
    bytes              number        not null,
    status             varchar2(30)  not null
                       constraint wwv_purge_datafiles_ck1 check(status in('NOT_EVAL','QUOTA_BY_OTHER','OTHER_WORKSPACE','NOT_FLOW_TABLESPACE','PURGE')),
    created_ts         timestamp )
/

alter table wwv_purge_datafiles
    add constraint wwv_purge_datafiles_fk1
    foreign key( purge_workspace_id, security_group_id ) references wwv_purge_workspaces( id, security_group_id )
    on delete cascade
/

create index wwv_purge_datafiles_idx1 on wwv_purge_datafiles ( purge_workspace_id, security_group_id  )
/

--==============================================================================
create table wwv_purge_schemas(
    id                 number primary key,
    purge_workspace_id number        not null,
    security_group_id  number        not null,
    schema             varchar2(128) not null,
    status             varchar2(30)  not null
                       constraint wwv_purge_schemas_ck1 check(status in('NOT_EVAL','INTERNAL','OTHER_WORKSPACE','RESTRICTED','NOT_FLOW_DEFAULT_TABLESPACE','PURGE')),
    created_ts         timestamp )
/

alter table wwv_purge_schemas
    add constraint wwv_purge_schemas_fk1
    foreign key( purge_workspace_id, security_group_id ) references wwv_purge_workspaces( id, security_group_id )
    on delete cascade
/

create index wwv_purge_schemas_idx1 on wwv_purge_schemas ( purge_workspace_id, security_group_id  )
/

--##############################################################################
--#
--# TEAM DEVELOPMENT
--#
--##############################################################################
prompt TEAM DEVELOPMENT
--==============================================================================
create table wwv_flow_team_tags (
   id                                number,
   tag                               varchar2(255) not null enable,
   tag_type                          varchar2(30)
                                     constraint wwv_flow_team_tags_tp
                                     check (tag_type in ('BUG','FEATURE','FEEDBACK','MILESTONE','DOCUMENT', 'LINK',  'TODO')),
   component_id                      number,
   --
   security_group_id                 number not null
                                     constraint wwv_flow_team_tags_fk
                                      references wwv_flow_companies(provisioning_company_id)
                                      on delete cascade,
   constraint wwv_flow_team_tags_pk  primary key (id) enable
)
/

create index wwv_flow_team_tags_idx1 on wwv_flow_team_tags (security_group_id,tag)
/
create unique index wwv_flow_team_tags_idx2 on wwv_flow_team_tags (component_id,tag)
/
create index wwv_flow_team_tags_idx3 on wwv_flow_team_tags (tag)
/

--##############################################################################
--#
--# cache table constraints
--#
--##############################################################################
prompt ...wwv_flow_cons_sync$
--==============================================================================
create table wwv_flow_cons_sync$ (
    constraint_type       varchar2(1),
    constraint_name       varchar2(255),
    owner                 varchar2(255) not null,
    table_name            varchar2(255) not null,
    column_name           varchar2(255) not null,
    position              number,
    data_type             varchar2(255),
    status                varchar2(10),
    last_change           date,
    r_constraint_name     varchar2(255),
    referenced_owner      varchar2(255),
    referenced_table      varchar2(255),
    referenced_column     varchar2(4000),
    esc_table_name        varchar2(4000),
    esc_column_name       varchar2(4000),
    esc_referenced_table  varchar2(4000),
    esc_referenced_column varchar2(4000) )
/

create index wwv_flow_cons_sync$_idx1 on wwv_flow_cons_sync$ (owner,table_name)
/

create index wwv_flow_cons_sync$_idx2 on wwv_flow_cons_sync$ (referenced_owner, referenced_table)
/

--##############################################################################
--#
--# SQL WORKSHOP > QUERY BUILDER
--#
--##############################################################################
prompt SQL WORKSHOP > QUERY BUILDER

--==============================================================================
create table wwv_flow_qb_saved_query(
    id                number
                      constraint wwv_flow_qb_saved_query_pk primary key,
    query_owner       varchar2(255)      not null,
    title             varchar2(255)      not null,
    qb_sql            clob,
    description       varchar2(4000),
    query_type        varchar2(1)        not null
                      check (query_type in ('P','R','W')),
    created_by        varchar2(255)      not null,
    created_on        date               not null,
    last_updated_by   varchar2(255),
    last_updated_on   date,
    security_group_id number             not null
                      constraint wwv_flow_qb_saved_query_fk
                      references wwv_flow_companies(provisioning_company_id)
                      on delete cascade)
/

create index wwv_flow_qb_saved_query_fkidx on wwv_flow_qb_saved_query (security_group_id)
/
create unique index wwv_flow_qb_saved_query_uk on wwv_flow_qb_saved_query (title, created_by, security_group_id )
/

--==============================================================================
create table wwv_flow_qb_saved_cond(
  id     number                          not null,
  col    varchar2(255)                   not null,
  alias  varchar2(255)                   not null,
  fv     varchar2(255),
  fp     varchar2(255),
  out    varchar2(255)    constraint wwv_flow_qb_saved_cond_out
                          check (out in ('true','false')),
  st     varchar2(255)    constraint wwv_flow_qb_saved_cond_st
                          check (st in ('ASC','DESC')),
  so     varchar2(255),
  grp    varchar2(255)    constraint wwv_flow_qb_saved_cond_grp
                          check (grp in ('true','false')),
  con    varchar2(255),
  ord    number                          not null,
  security_group_id number               not null,
  constraint pk_wwv_flow_qb_saved_cond primary key (id, col),
  foreign key (id)
    references wwv_flow_qb_saved_query (id)
    on delete cascade)
/

--==============================================================================
create table wwv_flow_qb_saved_join(
  id      number                         not null,
  field1  varchar2(255)                  not null,
  field2  varchar2(255)                  not null,
  cond    varchar2(1)                    not null,
  security_group_id number               not null,
  constraint pk_wwv_flow_qb_saved_join primary key (id, field1, field2),
  foreign key (id)
    references wwv_flow_qb_saved_query (id)
    on delete cascade)
/

create table wwv_flow_qb_saved_tabs(
  id     number                             not null,
  oid    number                             not null,
  cnt    number                             not null,
  top    varchar2(255),
  left   varchar2(255),
  tname  varchar2(255)                      not null,
  security_group_id number                  not null,
  constraint pk_wwv_flow_qb_saved_tabs primary key (id, oid, cnt),
  foreign key (id)
    references wwv_flow_qb_saved_query (id)
    on delete cascade)
/

--##############################################################################
--#
--# SQL WORKSHOP > TRANSACTIONS
--#
--##############################################################################

--==============================================================================
create table wwv_flow_sc_trans (
    session_id          number not null
                                  constraint wwv_flow_sc_trans_fk2
                                  references wwv_flow_sessions$(id)
                                  on delete cascade,
    transaction_id      number not null,
    security_group_id   number not null
                                  constraint wwv_flow_sc_trans_fk1
                                  references wwv_flow_companies(provisioning_company_id)
                                  on delete cascade,
    transaction_user    varchar2(2000) not null,
    transaction_schema  varchar2(2000) not null,
    transaction_type    varchar2(10) not null
                                 constraint wwv_flow_sc_trans_ck1
                                 check (transaction_type in (
                                 'STOP',
                                 'SQL',
                                 'PLSQL')),
    transaction_status  varchar2(1) not null
                                constraint wwv_flow_sc_trans_ck2
                                 check (transaction_status in (
                                 'N',
                                 'R')),
    transaction_rows    number not null,
    transaction_binds   varchar2(4000),
    transaction_sql     clob not null,
    transaction_result  clob,
    transaction_output  clob,
    created_on          date not null,
    updated_on          date
    );

alter table wwv_flow_sc_trans add constraint wwv_flow_sc_trans_pk primary key (SESSION_ID, transaction_id)
/

create index wwv_flow_sc_trans_fk1 on wwv_flow_sc_trans (security_group_id)
/

--==============================================================================
create table wwv_flow_sw_results (
    id                    number
                          constraint wwv_flow_sw_result_pk
                          primary key,
    file_id               number not null
                          constraint wwv_flow_sw_result_fk
                          references flows_files.wwv_flow_file_objects$(id)
                          on delete cascade,
    job_id                number,
    run_by                varchar2(255) not null,
    run_as                varchar2(255) not null,
    started               date not null,
    start_time            number not null,
    ended                 date,
    end_time              number,
    status                varchar2(255)
                          constraint wwv_flow_result_status
                          check (status in (
                          'SUBMITTED',
                          'EXECUTING',
                          'COMPLETE',
                          'CANCELED',
                          'CANCELING')),
    run_comments          varchar2(4000),
    security_group_id     number not null
                          constraint wwv_flow_sw_result_fk2
                          references wwv_flow_companies(provisioning_company_id)
                          on delete cascade
    )
/

create index wwv_flow_sw_result_idx1 on wwv_flow_sw_results (file_id)
/
create unique index wwv_flow_sw_result_idx3 on wwv_flow_sw_results (security_group_id,id,status) compress 1
/

--==============================================================================
create table wwv_flow_sw_detail_results (
    id                    number
                          constraint wwv_flow_sw_d_result_pk
                          primary key,
    result_id             number not null
                          constraint wwv_flow_sw_d_result_fk
                          references wwv_flow_sw_results(id)
                          on delete cascade,
    file_id               number not null,
    seq_id                number not null,
    stmt_num              number not null,
    stmt_text             clob default empty_clob(),
    result                clob default empty_clob(),
    result_size           number,
    result_rows           number,
    msg                   varchar2(4000),
    success               varchar2(1) default 'N'
                          constraint wwv_run_success_flg
                          check (success in (
                          'Y',
                          'N')),
    failure               varchar2(1) default 'N'
                          constraint wwv_run_failure_flag
                          check (failure in (
                          'Y',
                          'N')),
    started               date not null,
    start_time            number not null,
    ended                 date,
    end_time              number,
    run_complete          varchar2(1) default 'N'
                          constraint wwv_stmt_run_complete_flag
                          check (run_complete in (
                          'Y',
                          'N')),
    last_updated          date,
    security_group_id     number not null
                          constraint wwv_flow_sw_d_result_fk2
                          references wwv_flow_companies(provisioning_company_id)
                          on delete cascade
    ) lob (stmt_text,result) store as (
        pctversion 0
        cache reads
        enable storage in row )
/

create index wwv_flow_sw_d_result_idx1 on wwv_flow_sw_detail_results (result_id)
/
create index wwv_flow_sw_d_result_idx3 on wwv_flow_sw_detail_results (security_group_id,result_id,file_id) compress 2
/

--==============================================================================
create table wwv_flow_sw_sqlplus_cmd (
    command                varchar2(30) primary key
    )
/

--==============================================================================
create table wwv_flow_sw_sql_cmds (
    id                              number
                                    constraint wwv_flow_sw_sql_cmds_pk
                                    primary key,
    command                         clob,
    parsed_schema                   varchar2(128),
    created_by                      varchar2(255),
    created_on                      date,
    security_group_id               number not null
                                    constraint WWV_FLOW_SW_SQL_CMDS_fk
                                    references wwv_flow_companies(provisioning_company_id)
                                    on delete cascade
    )
/

create unique index WWV_FLOW_SW_SQL_CMDS_FKIDX ON WWV_FLOW_SW_SQL_CMDS(SECURITY_GROUP_ID,PARSED_SCHEMA,id)
/

--==============================================================================
-- Parser output table.  Will store each line of the statement.
prompt ...create wwv_flow_sw_stmts
create table wwv_flow_sw_stmts (
   id                  number
                       constraint wwv_flow_sw_stmts_pk
                       primary key,
   file_id             number not null
                       constraint wwv_flow_sw_stmts_fk
                       references flows_files.wwv_flow_file_objects$(id)
                       on delete cascade,
   stmt_number         number,
   src_line_number     number,
   offset              number,
   length              number,
   stmt_class          number,
   stmt_id             number,
   isrunnable          varchar2(1),
   stmt_vc2            varchar2(4000),
   stmt                clob,
   security_group_id   number not null
                       constraint wwv_flow_sw_stmts_fk2
                       references wwv_flow_companies(provisioning_company_id)
                       on delete cascade
) lob (stmt) store as (
    pctversion 0
    cache reads
    enable storage in row )
/

create index wwv_flow_sw_stmts_idx on wwv_flow_sw_stmts (file_id);
create index wwv_flow_sw_stmts_idx2 on wwv_flow_sw_stmts (security_group_id,file_id,isrunnable,stmt_id,stmt_number) compress 2;

--==============================================================================
-- Holds the list of non special-character first keywords
create table wwv_flow_sw_main_keywords (
    id         number
               constraint wwv_flow_sw_mkeywords_pk
               primary key,
    keyword    VARCHAR2(20),
    stmt_class INTEGER,
    stmt_id    INTEGER,
    isrunnable VARCHAR2(1)
  );

create unique index wwv_flow_sw_mkeywords_idx on wwv_flow_sw_main_keywords (keyword);

prompt ...done create tables
set define '^'
