prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.17'
,p_default_workspace_id=>20
,p_default_application_id=>8940
,p_default_id_offset=>0
,p_default_owner=>'ORACLE'
);
end;
/
 
prompt APPLICATION 8940 - Universal Theme Sample Application
--
-- Application Export:
--   Application:     8940
--   Name:            Universal Theme Sample Application
--   Exported By:     APEX_190200
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    125
--       Items:                  156
--       Processes:                5
--       Regions:                976
--       Buttons:                266
--       Dynamic Actions:         27
--     Shared Components:
--       Logic:
--       Navigation:
--         Parent Tabs:            2
--         Lists:                 37
--         Breadcrumbs:            2
--           Entries:            107
--         NavBar Entries:         1
--       Security:
--         Authentication:         1
--       User Interface:
--         Themes:                 1
--         Templates:
--           Page:                 9
--           Region:              16
--           Label:                7
--           List:                12
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:               3
--           Report:              11
--         LOVs:                   4
--         Shortcuts:              2
--         Plug-ins:               2
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Included
--       Install scripts:          1
--   Version:         19.2.0.00.17
--   Instance ID:     248353129556926
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'ORACLE')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Universal Theme Sample Application')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'8940')
,p_application_group=>23856082517251495
,p_application_group_name=>'19.2 Sample Apps'
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'N'
,p_checksum_salt_last_reset=>'20190923043253'
,p_bookmark_checksum_function=>'MD5'
,p_max_session_length_sec=>28800
,p_compatibility_mode=>'19.2'
,p_flow_language=>'en-us'
,p_flow_language_derived_from=>'FLOW_PRIMARY_LANGUAGE'
,p_allow_feedback_yn=>'Y'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_documentation_banner=>'Created 08/12/2004 11:25:08 AM'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(6617513688278274885)
,p_application_tab_set=>1
,p_logo_type=>'T'
,p_logo_text=>'Universal Theme'
,p_favicons=>'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/app-sample-universal-theme.ico"><link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/app-sample-universal-theme-16x16.png"><link rel="icon" sizes="32x32" href="#IMA'
||'GE_PREFIX#apex_ui/img/favicons/app-sample-universal-theme-32x32.png"><link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/app-sample-universal-theme.png">'
,p_public_user=>'HTMLDB_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'1.3.1'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_frame=>'S'
,p_deep_linking=>'Y'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'P'
,p_csv_encoding=>'N'
,p_auto_time_zone=>'N'
,p_substitution_string_02=>'CODEMIRROR_PATH'
,p_substitution_value_02=>'#IMAGE_PREFIX#libraries/codemirror/5.48.4'
,p_substitution_string_03=>'APP_DATE_FMT'
,p_substitution_value_03=>'Day Month DD, YYYY'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190923043253'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_files_version=>54
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/ut_application_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(404960847609814309)
,p_name=>'UT - Application Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404961057623814311)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Getting Started'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-mouse-pointer'
,p_list_text_01=>'getting_started'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Design'
,p_list_item_link_target=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-design'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790211978341702368)
,p_list_item_display_sequence=>750
,p_list_item_link_text=>'Colors'
,p_list_item_link_target=>'f?p=&APP_ID.:402:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-eyedropper'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790212244932703684)
,p_list_item_display_sequence=>760
,p_list_item_link_text=>'Customization'
,p_list_item_link_target=>'f?p=&APP_ID.:403:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790212527342704563)
,p_list_item_display_sequence=>770
,p_list_item_link_text=>'Data Entry'
,p_list_item_link_target=>'f?p=&APP_ID.:404:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790212848859705878)
,p_list_item_display_sequence=>780
,p_list_item_link_text=>'Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-3row'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_text_10=>'700'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713375871653885764)
,p_list_item_display_sequence=>830
,p_list_item_link_text=>'Grid Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790212848859705878)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'300'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404962634570814314)
,p_list_item_display_sequence=>840
,p_list_item_link_text=>'Page Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790212848859705878)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790216425887716634)
,p_list_item_display_sequence=>850
,p_list_item_link_text=>'Responsive Design'
,p_list_item_link_target=>'f?p=&APP_ID.:701:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(790212848859705878)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790213137543706961)
,p_list_item_display_sequence=>790
,p_list_item_link_text=>'Notifications and Messaging'
,p_list_item_link_target=>'f?p=&APP_ID.:406:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790213493149707798)
,p_list_item_display_sequence=>800
,p_list_item_link_text=>'Navigation'
,p_list_item_link_target=>'f?p=&APP_ID.:407:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713416031033967219)
,p_list_item_display_sequence=>810
,p_list_item_link_text=>'UI Patterns'
,p_list_item_link_target=>'f?p=&APP_ID.:5000:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790206689515692874)
,p_list_item_display_sequence=>690
,p_list_item_link_text=>'Login Page'
,p_list_item_link_target=>'f?p=&APP_ID.:5001:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(713416031033967219)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790208910412694520)
,p_list_item_display_sequence=>700
,p_list_item_link_text=>'Home and Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:5002:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(713416031033967219)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790209281981695461)
,p_list_item_display_sequence=>710
,p_list_item_link_text=>'Filter Page'
,p_list_item_link_target=>'f?p=&APP_ID.:5003:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(713416031033967219)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790209512553696422)
,p_list_item_display_sequence=>720
,p_list_item_link_text=>'Marquee page'
,p_list_item_link_target=>'f?p=&APP_ID.:5004:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(713416031033967219)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790209819506697499)
,p_list_item_display_sequence=>730
,p_list_item_link_text=>'Modal Dialogs'
,p_list_item_link_target=>'f?p=&APP_ID.:5005:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(713416031033967219)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(662087081340490957)
,p_list_item_display_sequence=>820
,p_list_item_link_text=>'Mobile Patterns'
,p_list_item_link_target=>'f?p=&APP_ID.:420:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-mobile'
,p_parent_list_item_id=>wwv_flow_api.id(790181588986588997)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(747800042111773242)
,p_list_item_display_sequence=>570
,p_list_item_link_text=>'Navigation'
,p_list_item_link_target=>'f?p=&APP_ID.:421:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(662087081340490957)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(747800481356773242)
,p_list_item_display_sequence=>580
,p_list_item_link_text=>'Headers and Footers'
,p_list_item_link_target=>'f?p=&APP_ID.:422:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(662087081340490957)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(747800881252773242)
,p_list_item_display_sequence=>590
,p_list_item_link_text=>'Data Entry'
,p_list_item_link_target=>'f?p=&APP_ID.:423:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(662087081340490957)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(747801294056773242)
,p_list_item_display_sequence=>600
,p_list_item_link_text=>'Touch Gestures'
,p_list_item_link_target=>'f?p=&APP_ID.:424:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(662087081340490957)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(747801668191773243)
,p_list_item_display_sequence=>610
,p_list_item_link_text=>'jQuery Mobile Components'
,p_list_item_link_target=>'f?p=&APP_ID.:425:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(662087081340490957)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Components'
,p_list_item_link_target=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-shapes'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404979442701814329)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Activity Timeline'
,p_list_item_link_target=>'f?p=&APP_ID.:1406:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-history'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404972651333814323)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Alert'
,p_list_item_link_target=>'f?p=&APP_ID.:1202:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-alert'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404971453126814322)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Badges List'
,p_list_item_link_target=>'f?p=&APP_ID.:1304:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-badge-list'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790254803403841579)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Breadcrumb'
,p_list_item_link_target=>'f?p=&APP_ID.:3810:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-breadcrumb'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404964288241814317)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Buttons'
,p_list_item_link_target=>'f?p=&APP_ID.:1500:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-button'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404976257639814325)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>'Text Only'
,p_list_item_link_target=>'f?p=&APP_ID.:1501:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404964288241814317)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404976611148814326)
,p_list_item_display_sequence=>440
,p_list_item_link_text=>'Icon Only'
,p_list_item_link_target=>'f?p=&APP_ID.:1502:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404964288241814317)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404977006637814326)
,p_list_item_display_sequence=>450
,p_list_item_link_text=>'Text with Icon'
,p_list_item_link_target=>'f?p=&APP_ID.:1503:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404964288241814317)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404973453969814323)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Button Group'
,p_list_item_link_target=>'f?p=&APP_ID.:1204:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-button-group'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790255856031844227)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Button Container'
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-button-container'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404965070284814317)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Calendars'
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-calendar'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404965851915814318)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>'Cards'
,p_list_item_link_target=>'f?p=&APP_ID.:3100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cards'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404973885709814324)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>'Carousel'
,p_list_item_link_target=>'f?p=&APP_ID.:1205:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-carousel'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790265128676888907)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Charts'
,p_list_item_link_target=>'f?p=&APP_ID.:1902:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-bar-chart'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404974282533814324)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Collapsible'
,p_list_item_link_target=>'f?p=&APP_ID.:1206:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-collapsible'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404979026242814329)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1405:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-comments-o'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(350269099343744384)
,p_list_item_display_sequence=>225
,p_list_item_link_text=>'Content Row'
,p_list_item_link_target=>'f?p=&APP_ID.:1407:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-list-left'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1407'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404967011884814319)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Data Tables and Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:3400:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404977409522814326)
,p_list_item_display_sequence=>520
,p_list_item_link_text=>'Classic Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404967011884814319)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404977886452814327)
,p_list_item_display_sequence=>530
,p_list_item_link_text=>'Interactive Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404967011884814319)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790268545349916852)
,p_list_item_display_sequence=>540
,p_list_item_link_text=>'Interactive Grid'
,p_list_item_link_target=>'f?p=&APP_ID.:1410:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404967011884814319)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315960897745901520)
,p_list_item_display_sequence=>550
,p_list_item_link_text=>'Reflow Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1710:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404967011884814319)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315969693867057913)
,p_list_item_display_sequence=>560
,p_list_item_link_text=>'Column Toggle Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1720:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404967011884814319)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1720'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404964628365814317)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Forms'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-forms'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404975439087814325)
,p_list_item_display_sequence=>460
,p_list_item_link_text=>'Form Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:1601:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404964628365814317)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404975876769814325)
,p_list_item_display_sequence=>470
,p_list_item_link_text=>'Multi Column Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:1602:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404964628365814317)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(459023291133671112)
,p_list_item_display_sequence=>480
,p_list_item_link_text=>'Floating Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:1603:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404964628365814317)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790269502035934295)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Help Text'
,p_list_item_link_target=>'f?p=&APP_ID.:1903:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-question-circle-o'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404973086247814323)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'Hero'
,p_list_item_link_target=>'f?p=&APP_ID.:1203:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-hero'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404963476164814315)
,p_list_item_display_sequence=>270
,p_list_item_link_text=>'Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:1300:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404971091531814322)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'Links List'
,p_list_item_link_target=>'f?p=&APP_ID.:1303:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404963476164814315)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404969862307814321)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Media List'
,p_list_item_link_target=>'f?p=&APP_ID.:1301:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(404963476164814315)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315960556742899480)
,p_list_item_display_sequence=>280
,p_list_item_link_text=>'List View'
,p_list_item_link_target=>'f?p=&APP_ID.:1700:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404971867315814322)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Menu Bar'
,p_list_item_link_target=>'f?p=&APP_ID.:1305:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055949222457173047)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Menu Popup'
,p_list_item_link_target=>'f?p=&APP_ID.:1306:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list-alt'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790276453845986993)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Modal Dialogs and Popups'
,p_list_item_link_target=>'f?p=&APP_ID.:1906:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-header'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790276737645989387)
,p_list_item_display_sequence=>910
,p_list_item_link_text=>'Page Dialog'
,p_list_item_link_target=>'f?p=&APP_ID.:1910:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790276453845986993)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790277208146991379)
,p_list_item_display_sequence=>920
,p_list_item_link_text=>'Inline Dialog'
,p_list_item_link_target=>'f?p=&APP_ID.:1911:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790276453845986993)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(210177885358595795)
,p_list_item_display_sequence=>930
,p_list_item_link_text=>'Inline Popup'
,p_list_item_link_target=>'f?p=&APP_ID.:1915:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790276453845986993)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790277525593993484)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'PL/SQL Dynamic Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1908:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-dynamic-content'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790277868047999295)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Tabs and Region Display Selector'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404972205392814323)
,p_list_item_display_sequence=>350
,p_list_item_link_text=>'Standard Region'
,p_list_item_link_target=>'f?p=&APP_ID.:1201:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-window'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790279267001011450)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Static Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1905:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-code'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404974609886814324)
,p_list_item_display_sequence=>370
,p_list_item_link_text=>'Title Bar Region'
,p_list_item_link_target=>'f?p=&APP_ID.:1207:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-breadcrumb'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790285419368017835)
,p_list_item_display_sequence=>380
,p_list_item_link_text=>'Tree'
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tree-org'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404978249669814328)
,p_list_item_display_sequence=>390
,p_list_item_link_text=>'Value Attribute Pairs Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1403:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-th-list'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404975096292814325)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Wizards'
,p_list_item_link_target=>'f?p=&APP_ID.:1208:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-wizard'
,p_parent_list_item_id=>wwv_flow_api.id(404962211197814314)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(404965403854814318)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Migration Guides'
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tasks'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790240668963732669)
,p_list_item_display_sequence=>490
,p_list_item_link_text=>'Updating Universal Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:1909:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-arrow-up'
,p_parent_list_item_id=>wwv_flow_api.id(404965403854814318)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790240986197737670)
,p_list_item_display_sequence=>500
,p_list_item_link_text=>'From Other Themes'
,p_list_item_icon=>'fa-window-arrow-up'
,p_parent_list_item_id=>wwv_flow_api.id(404965403854814318)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(431029421608761404)
,p_list_item_display_sequence=>860
,p_list_item_link_text=>'Why Migrate'
,p_list_item_link_target=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790240986197737670)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(431029745944763173)
,p_list_item_display_sequence=>870
,p_list_item_link_text=>'Migration Steps'
,p_list_item_link_target=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790240986197737670)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(431030318199767164)
,p_list_item_display_sequence=>880
,p_list_item_link_text=>'Post Migration'
,p_list_item_link_target=>'f?p=&APP_ID.:2030:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790240986197737670)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(431030688725769883)
,p_list_item_display_sequence=>890
,p_list_item_link_text=>'Bookmarklet'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790240986197737670)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(431030913878770752)
,p_list_item_display_sequence=>900
,p_list_item_link_text=>'FAQ'
,p_list_item_link_target=>'f?p=&APP_ID.:2050:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(790240986197737670)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(599863267040037658)
,p_list_item_display_sequence=>510
,p_list_item_link_text=>'From jQuery Mobile'
,p_list_item_link_target=>'f?p=&APP_ID.:2060:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-mobile'
,p_parent_list_item_id=>wwv_flow_api.id(404965403854814318)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(558383049237173693)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Icons'
,p_list_item_link_target=>'f?p=&APP_ID.:4000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-apex'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Reference'
,p_list_item_link_target=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cogs'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6000,6306'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2089704419056989065)
,p_list_item_display_sequence=>620
,p_list_item_link_text=>'Button Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:6100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-button'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2089707066709007706)
,p_list_item_display_sequence=>630
,p_list_item_link_text=>'Responsive Classes'
,p_list_item_link_target=>'f?p=&APP_ID.:6301:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-expand'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2089707755638016479)
,p_list_item_display_sequence=>640
,p_list_item_link_text=>'Color and Status Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:6302:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-eyedropper'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7639293462804912)
,p_list_item_display_sequence=>641
,p_list_item_link_text=>'Layout Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:6303:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-fit-to-size'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(7639749289812861)
,p_list_item_display_sequence=>642
,p_list_item_link_text=>'Content Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:6304:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-text-height'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2089708048733018188)
,p_list_item_display_sequence=>650
,p_list_item_link_text=>'JavaScript Events'
,p_list_item_link_target=>'f?p=&APP_ID.:6200:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-mouse-pointer'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(458968332337637149)
,p_list_item_display_sequence=>660
,p_list_item_link_text=>'JavaScript APIs'
,p_list_item_link_target=>'f?p=&APP_ID.:6201:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-code-fork'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2089709547365020270)
,p_list_item_display_sequence=>670
,p_list_item_link_text=>'Component Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:6307:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2089709850880021459)
,p_list_item_display_sequence=>680
,p_list_item_link_text=>'Region Types'
,p_list_item_link_target=>'f?p=&APP_ID.:6308:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(364288651901511169)
,p_list_item_display_sequence=>690
,p_list_item_link_text=>'Change Log'
,p_list_item_link_target=>'f?p=&APP_ID.:6305:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-history'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(713402133307911730)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_regions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(476431339368267518)
,p_name=>'Template - Regions'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476431982778267525)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Alert'
,p_list_item_link_target=>'f?p=&APP_ID.:1202:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-exclamation-triangle'
,p_list_text_01=>'Alert Notify your users with alerts, confirmations, and other action-oriented messages.'
,p_list_text_03=>'LS'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476432769034267526)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Buttons Container'
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-square-o'
,p_list_text_01=>'Organize your button bars, toolbars, and simple horizontal forms.'
,p_list_text_03=>'BC'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476433117077267527)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Carousel'
,p_list_item_link_target=>'f?p=&APP_ID.:1205:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-arrows-h'
,p_list_text_01=>'Show off one sub region at a time. For example, displaying a report and a chart, a slideshow, or different views of the same data.'
,p_list_text_03=>'CS'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476433516807267527)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Collapsible'
,p_list_item_link_target=>'f?p=&APP_ID.:1206:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-folder-open-o'
,p_list_text_01=>'Allow your users to toggle the visibility of a region''s content on the page.'
,p_list_text_03=>'DL'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285532804560449971)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Content Block'
,p_list_item_icon=>'fa-file'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476432369863267526)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Hero'
,p_list_item_link_target=>'f?p=&APP_ID.:1203:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-bullhorn'
,p_list_text_01=>'Capture your users'' attention on homepage, dashboard, and other introductory-style pages. This region template displays an icon, heading and sub headings, and buttons.'
,p_list_text_03=>'HR'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285533100472449972)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Inline Dialog'
,p_list_item_link_target=>'f?p=&APP_ID.:1911:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-header'
,p_list_text_01=>'An inline dialog displays a region on the current page within a modal dialog.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285533511986449972)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Interactive Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-sort-amount-desc'
,p_list_text_01=>'Interactive Reports provide powerful features for customizing your report such as searching, filtering, sorting, highlighting, group-by, pivot, aggregations, calculations, charting, and more.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285533945570449972)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Login'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:other:&DEBUG.::::'
,p_list_item_icon=>'fa-file-o'
,p_list_text_01=>'A generic login screen.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476431536940267523)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Standard'
,p_list_item_link_target=>'f?p=&APP_ID.:1201:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-align-justify'
,p_list_text_01=>'The generic region template. It works well with all widgets and can be heavily customized.'
,p_list_text_03=>'SD'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285534382993449973)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Tab Container'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.:tab_container:&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_list_text_01=>'The Tabs Container Region Template can be used to create a set tabs within your page.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476433944551267527)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Title Bar'
,p_list_item_link_target=>'f?p=&APP_ID.:1207:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-adn'
,p_list_text_01=>'Group breadcrumbs, page title, and primary page actions at the top of the page.'
,p_list_text_03=>'TB'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476440377156621616)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Wizard Container'
,p_list_item_link_target=>'f?p=&APP_ID.:1208:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-magic'
,p_list_text_01=>'Use this region template for the Wizard Progress list, and as the container for your forms.'
,p_list_text_03=>'WZ'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_lists
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(476573383197691871)
,p_name=>'Template - Lists'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285509281144327151)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Badge List'
,p_list_item_link_target=>'f?p=&APP_ID.:1304:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-badge-list'
,p_list_text_01=>'This list template is useful for displaying badges or counters.'
,p_list_text_03=>'BL'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285509725445331674)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Cards'
,p_list_item_link_target=>'f?p=&APP_ID.:3100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cards'
,p_list_text_01=>'Presents a variety of information in small blocks and can be heavily customized'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476574301796691880)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Links List'
,p_list_item_link_target=>'f?p=&APP_ID.:1303:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_list_text_01=>'This list template provides a list of links which can be used for navigation and other action-oriented tasks. You can optionally show badges, icons, sub list items, and more.'
,p_list_text_03=>'LS'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476573563215691877)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Media List'
,p_list_item_link_target=>'f?p=&APP_ID.:1301:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-media-list'
,p_list_text_01=>'This list template is a very common design pattern involving an icon, heading, description, and a badge.'
,p_list_text_03=>'ML'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285510075083331674)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Menu Bar'
,p_list_item_link_target=>'f?p=&APP_ID.:1305:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_list_text_01=>'This list template is used to display a menu bar control and is useful for building pages with advanced interaction.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285510481150331675)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Menu Popup'
,p_list_item_link_target=>'f?p=&APP_ID.:1306:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list-alt'
,p_list_text_01=>'You can easily create a popup menu in your application by using Lists and associating a button with the menu.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285510865297331675)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Navigation Bar'
,p_list_item_link_target=>'f?p=&APP_ID.:407:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-breadcrumb'
,p_list_text_01=>'Navigation is an important part of your application and can determine the how your users navigate within your application.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285511255005331675)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.:tab_list:&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_list_text_01=>'You can use Tabs within your application pages to improve navigation,'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285511637712331676)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Wizard Progress'
,p_list_item_link_target=>'f?p=&APP_ID.:1208:&SESSION.:wizard_list:&DEBUG.::::'
,p_list_item_icon=>'fa-wizard'
,p_list_text_01=>'The Wizard Progress List Template is used to display the total steps of a wizard along with a marker of the current step the user is on.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(476579719264733455)
,p_name=>'Template - Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285561707719536226)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Alerts'
,p_list_item_link_target=>'f?p=&APP_ID.:1202:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-exclamation-triangle'
,p_list_text_01=>'Display alerts, confirmations, and other action-oriented messages.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285562001417536227)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Badge List'
,p_list_item_link_target=>'f?p=&APP_ID.:1304:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-badge-list'
,p_list_text_01=>'Displaying badges or counters.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2182543778758267099)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Cards'
,p_list_item_link_target=>'f?p=&APP_ID.:3100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cards'
,p_list_text_01=>'This report template provides the Cards UI and is useful for presenting a variety of information. Cards can be displayed in three styles, with icons or initials, and you can control the layout.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476581538439733458)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1405:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-comments-o'
,p_list_text_01=>'This report template is used to display user comments and status updates.'
,p_list_text_03=>'CM'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476579975751733455)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Standard'
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table'
,p_list_text_01=>'This is the default report template used for displaying tabular data.'
,p_list_text_03=>'RP'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476583558130758825)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Timeline'
,p_list_item_link_target=>'f?p=&APP_ID.:1406:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-clock-o'
,p_list_text_01=>'This timeline report template is useful for displaying recent updates and interactions within an application.'
,p_list_text_03=>'TL'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476580797814733457)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Value Attribute Pairs'
,p_list_item_link_target=>'f?p=&APP_ID.:1403:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-pause'
,p_list_text_01=>'This report template is useful for displaying attribute value / key value pairs and works well with both Row or Column based queries.'
,p_list_text_03=>'VA'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2302998102575626036)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Search Results'
,p_list_item_icon=>'fa-table'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_buttons
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(476584406006772879)
,p_name=>'Template - Buttons'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476584644680772879)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Text Only'
,p_list_item_link_target=>'f?p=&APP_ID.:1501:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-file-text-o'
,p_list_text_01=>'This is your standard button in Universal Theme'
,p_list_text_03=>'TO'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476585035303772880)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Icon Only'
,p_list_item_link_target=>'f?p=&APP_ID.:1502:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-photo'
,p_list_text_01=>'This list template provides the Cards UI and is useful for presenting a variety of information. Cards can be displayed in three styles, with icons or initials, and you can control the layout.'
,p_list_text_03=>'IO'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476585408801772881)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Text With Icon'
,p_list_item_link_target=>'f?p=&APP_ID.:1503:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-file-picture-o'
,p_list_text_01=>'This template enables you to display an icon next to your button label. You can easily position the icon to the right or left of the label using Template Options.'
,p_list_text_03=>'TI'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_forms
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(476588768580793809)
,p_name=>'Template - Forms'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476588928305793810)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Form Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:1601:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-forms'
,p_list_text_01=>'This is a basic form which can be customized using Template Options of the Region they are in.'
,p_list_text_03=>'FM'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(476589362742793811)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Multi Column Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:1602:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-columns'
,p_list_text_01=>'These examples show how complex form layout can achieved in Universal Theme.'
,p_list_text_03=>'MC'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(458994195620648265)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Floating Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:1603:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cloud-cursor'
,p_list_text_01=>'This form style features labels that automatically shrink as data is entered.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_migration_guide
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(558263404439591029)
,p_name=>'UT - Migration Guide'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(558263675345591030)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Why Migrate'
,p_list_item_link_target=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-question'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(558264058382591032)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Migration Steps'
,p_list_item_link_target=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list-ol'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(558264495416591033)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Post Migration'
,p_list_item_link_target=>'f?p=&APP_ID.:2030:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-check'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(558264826389591033)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Bookmarklet'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-bookmark-o'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(558265275145591033)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'FAQ'
,p_list_item_link_target=>'f?p=&APP_ID.:2050:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_wizard_progress
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(561122940005233277)
,p_name=>'UT - Wizard Progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(561123101558233277)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Step 1'
,p_list_item_icon=>'fa-check-circle'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(561124892979236826)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Step 2'
,p_list_item_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cloud'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(561123463797233277)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Step 3'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-comment'
,p_list_item_current_type=>'ALWAYS'
,p_list_item_current_for_pages=>'1112'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(561125155004236826)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Step 4'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-dashboard'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_mobile_patterns
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(608043492397034627)
,p_name=>'UT - Mobile Patterns'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(608043606699034632)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Navigation'
,p_list_item_link_target=>'f?p=&APP_ID.:421:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-breadcrumb'
,p_list_text_06=>'u-color-3'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(608044068623034633)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Headers and Footers'
,p_list_item_link_target=>'f?p=&APP_ID.:422:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-header-footer'
,p_list_text_06=>'u-color-3'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(608049594314081832)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Data Entry'
,p_list_item_link_target=>'f?p=&APP_ID.:423:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-forms'
,p_list_text_06=>'u-color-3'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(608044438288034634)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Touch Gestures'
,p_list_item_link_target=>'f?p=&APP_ID.:424:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-hand-o-right'
,p_list_text_06=>'u-color-3'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(608044828577034634)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Mobile Components'
,p_list_item_link_target=>'f?p=&APP_ID.:425:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cubes'
,p_list_text_06=>'u-color-3'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_media_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(620486248054927814)
,p_name=>'UT - Sample Media List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(620486432502927815)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Amet Incorporated'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-cloud'
,p_list_text_01=>'Mauris nulla. Integer urna. Vivamus molestie dapibus ligula. Aliquam erat volutpat. Nulla dignissim. Maecenas ornare egestas ligula. Nullam feugiat placerat'
,p_list_text_02=>'4'
,p_list_text_03=>'ML'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(620486740028927816)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Ridiculus LLP'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-comments-o'
,p_list_text_01=>'Phasellus nulla. Integer vulputate, risus a ultricies adipiscing, enim mi tempor lorem, eget mollis lectus pede et risus. Quisque libero.'
,p_list_text_02=>'12'
,p_list_text_03=>'AR'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(620487004353927816)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tristique LLC'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-calendar'
,p_list_text_01=>'Aliquam nisl. Nulla eu neque pellentesque massa lobortis ultrices. Vivamus rhoncus. Donec est. Nunc ullamcorper, velit in aliquet lobortis, nisi.'
,p_list_text_02=>'4'
,p_list_text_03=>'SR'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(620487305645927816)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Cras Interdum Consulting'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-envelope-o'
,p_list_text_01=>'Integer tincidunt aliquam arcu. Aliquam ultrices iaculis odio. Nam interdum enim non nisi. Aenean eget metus. In nec orci.'
,p_list_text_02=>'431'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(620487683994927816)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Felis Associates'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-dashboard'
,p_list_text_01=>'Aenean gravida nunc sed pede. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Proin vel arcu.'
,p_list_text_02=>'Pending'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(620490918520958475)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Eros Nec Corporation'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-credit-card-terminal'
,p_list_text_01=>'Purus gravida sagittis. Duis gravida. Praesent eu nulla at sem molestie sodales. Mauris blandit enim consequat purus. Maecenas libero est.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/badge_list_sample
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(637608094510847311)
,p_name=>'Badge List Sample'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(637608253885847312)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Active Bugs'
,p_list_item_link_target=>'#'
,p_list_text_01=>'12'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(637608579786847312)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Closed Bugs'
,p_list_item_link_target=>'#'
,p_list_text_01=>'31'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(637609104207847317)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Users'
,p_list_item_link_target=>'#'
,p_list_text_01=>'188'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(637609462006847317)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Projects'
,p_list_item_link_target=>'#'
,p_list_text_01=>'34'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(637611479729856126)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Milestones'
,p_list_item_link_target=>'#'
,p_list_text_01=>'3'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905914759695861881)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Action Items'
,p_list_item_link_target=>'#'
,p_list_text_01=>'15'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_migration_guide_from_jquery_mobile
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(654287896600461596)
,p_name=>'UT - Migration Guide from jQuery Mobile'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(654288022871461596)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Migrating from jQuery Mobile to Universal Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:2060:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-check'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_utility_classes
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(713403702397911733)
,p_name=>'UT - Utility Classes'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713404031145911737)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Responsive Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:6301:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-mobile'
,p_list_text_01=>'CSS utility classes that enable fine grain control on how your application responds to different screen sizes.'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713404428801911737)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Color and Status Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:6302:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-eyedropper'
,p_list_text_01=>'These color and status modifier classes enable you to add color to custom components.'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713404881513911737)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Layout Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:6303:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-th'
,p_list_text_01=>'These CSS classes enable you to modify layout blocks by setting margins, paddings, and more.'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713405204403911738)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Content Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:6304:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-keyboard-o'
,p_list_text_01=>'These content modifiers enable you to control the appearance of text, headings, and paragraphs.'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_tools
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(713405900484911743)
,p_name=>'UT - Tools'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713406261353911743)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Button Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:6100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tools'
,p_list_text_01=>'Get the HTML markup or link attributes you need to add buttons to report columns, static content regions, and more.'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713406618862911743)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Icon Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:4000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tools'
,p_list_text_01=>'Get the HTML markup or icon classes you need to add icons within your UI components.'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_javascript_utilities
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(713407327666911744)
,p_name=>'UT - JavaScript Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713460604663425801)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'JavaScript Events'
,p_list_item_link_target=>'f?p=&APP_ID.:6200:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-code'
,p_list_text_01=>'Listen and respond to these documented events in Universal Theme'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713407680446911744)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Javascript APIs'
,p_list_item_link_target=>'f?p=&APP_ID.:6201:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-code'
,p_list_text_01=>'Extend Universal Theme with the following widget APIs'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_design_patterns
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(713419631491967228)
,p_name=>'UT - Design Patterns'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713419977147967228)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Login Page'
,p_list_item_link_target=>'f?p=&APP_ID.:5001:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-key'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713420325392967229)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Home and Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:5002:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-home'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713420748995967229)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Filter Page'
,p_list_item_link_target=>'f?p=&APP_ID.:5003:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-header-sidebar-left'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713421166924967229)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Marquee Page'
,p_list_item_link_target=>'f?p=&APP_ID.:5004:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-check-circle-o'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(713421594146967229)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Modal Dialogs'
,p_list_item_link_target=>'f?p=&APP_ID.:5005:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-blank'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_miscellaneous
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(790289546548048869)
,p_name=>'UT - Miscellaneous'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1808782715624849532)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Component Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:6307:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_list_text_01=>'See a list of all available templates grouped by component type'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055910706772108747)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Region Types'
,p_list_item_link_target=>'f?p=&APP_ID.:6308:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_list_text_01=>'See a list of the region types available in Application Express and Universal Theme'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790289728055048870)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Change Log'
,p_list_item_link_target=>'f?p=&APP_ID.:6305:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list-ol'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'See the changes in the new version of Universal Theme'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(790290111386048870)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'FAQ'
,p_list_item_link_target=>'f?p=&APP_ID.:6306:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-question-circle'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'Answers to commonly asked questions.'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_components_dynamic_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(879773454971203054)
,p_name=>'UT - Components Dynamic List'
,p_list_type=>'SQL_QUERY'
,p_list_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null,',
'       entry_text as label,',
'       entry_target as target,',
'       null is_current',
'from APEX_APPLICATION_LIST_entries',
'where application_id = :APP_ID',
'and list_name = ''UT - Application Navigation''',
'and parent_entry_text = ''Components'''))
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1398847823861474656)
,p_name=>'Navigation Bar'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_migration_guide_from_ut_1_0
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1566181754433295518)
,p_name=>'UT - Migration Guide from UT 1.0'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1566181961278295519)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Updating to the Latest Universal Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:1909:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-check'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_components
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1725945334801719893)
,p_name=>'UT - Components'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3451869176279065064)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Activity Timeline'
,p_list_item_link_target=>'f?p=&APP_ID.:1406:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-history'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3451869508721065064)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Alert'
,p_list_item_link_target=>'f?p=&APP_ID.:1202:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-alert'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3451869956760065064)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Badges List'
,p_list_item_link_target=>'f?p=&APP_ID.:1304:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-badge-list'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3451871675858075137)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Breadcrumb'
,p_list_item_link_target=>'f?p=&APP_ID.:3810:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-breadcrumb'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3451871945196075138)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Buttons'
,p_list_item_link_target=>'f?p=&APP_ID.:1500:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-button'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880115227856078764)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Button Group'
,p_list_item_link_target=>'f?p=&APP_ID.:1204:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-button-group'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(3451872775172075138)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Button Container'
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-button-container'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880126123242134609)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Calendars'
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-calendar'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880126504818134610)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Cards'
,p_list_item_link_target=>'f?p=&APP_ID.:3100:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cards'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880126931084134610)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Carousel'
,p_list_item_link_target=>'f?p=&APP_ID.:1205:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-carousel'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880127350993134610)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Charts'
,p_list_item_link_target=>'f?p=&APP_ID.:1902:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-bar-chart'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880129106086146408)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Collapsible'
,p_list_item_link_target=>'f?p=&APP_ID.:1206:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-collapsible'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880129543851146408)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1405:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-comments-o'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(350310925826944427)
,p_list_item_display_sequence=>145
,p_list_item_link_text=>'Content Row'
,p_list_item_link_target=>'f?p=&APP_ID.:1407:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-list-left'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880129910819146408)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Data Tables and Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:3400:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880130304764146409)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Forms'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-forms'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880130709946146409)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Help Text'
,p_list_item_link_target=>'f?p=&APP_ID.:1903:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>' fa-question-circle-o'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880131194073146409)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>'Hero'
,p_list_item_link_target=>'f?p=&APP_ID.:1203:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-hero'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880131566736146409)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>'Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:1300:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315903431361516015)
,p_list_item_display_sequence=>195
,p_list_item_link_text=>'List View'
,p_list_item_link_target=>'f?p=&APP_ID.:1700:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2043131267392766073)
,p_list_item_display_sequence=>205
,p_list_item_link_text=>'Menu Bar'
,p_list_item_link_target=>'f?p=&APP_ID.:1305:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055915043795158217)
,p_list_item_display_sequence=>208
,p_list_item_link_text=>'Menu Popup'
,p_list_item_link_target=>'f?p=&APP_ID.:1306:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list-alt'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880133052623157537)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Modal Dialogs'
,p_list_item_link_target=>'f?p=&APP_ID.:1906:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-header'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880133421998157538)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'PL/SQL Dynamic Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1908:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-dynamic-content'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880133824287157539)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Region Display Selector'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315903718951517698)
,p_list_item_display_sequence=>235
,p_list_item_link_text=>'Responsive Tables'
,p_list_item_link_target=>'f?p=&APP_ID.:1710:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880134271673157540)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Standard Region'
,p_list_item_link_target=>'f?p=&APP_ID.:1201:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-header'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880134615922157540)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Static Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1905:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-code'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285564102824543354)
,p_list_item_display_sequence=>255
,p_list_item_link_text=>'Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880135085745157541)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'Title Bar Region'
,p_list_item_link_target=>'f?p=&APP_ID.:1207:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-breadcrumb'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880136098908163523)
,p_list_item_display_sequence=>270
,p_list_item_link_text=>'Tree'
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tree-org'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880136496854163523)
,p_list_item_display_sequence=>280
,p_list_item_link_text=>'URL'
,p_list_item_icon=>'fa-link'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880136848200163523)
,p_list_item_display_sequence=>290
,p_list_item_link_text=>'Value Attribute Pairs Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1403:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-th-list'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(880137211946163525)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Wizards'
,p_list_item_link_target=>'f?p=&APP_ID.:1208:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-wizard'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_navigation_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1885182092683398328)
,p_name=>'UT - Sample Navigation Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885182283423398329)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Menu Item 1'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-home'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885182672140398330)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Menu Item 2'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-user'
,p_list_item_current_type=>'ALWAYS'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885184691788408418)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Sub Menu Item 2.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885182672140398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885184984396409366)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Sub Menu Item 2.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885182672140398330)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885185272292410226)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Sub Menu Item 2.3'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885182672140398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885183052997398330)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Menu Item 3'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-play-circle-o'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885185559326412330)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Sub Menu Item 3.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885183052997398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885185839680413231)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Sub Menu Item 3.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885183052997398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885186193096414318)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Sub Menu Item 3.2.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885185839680413231)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885186480799415361)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Sub Menu Item 3.2.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885185839680413231)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885186992360416271)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Sub Menu Item 3.2.3'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885185839680413231)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885183403248398330)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Menu Item 4'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-gear'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885187277976417908)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Sub Menu Item 4.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885183403248398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885187536343418647)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Sub Menu Item 4.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885183403248398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885183834267398330)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Menu Item 5'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-alert'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885187804094419799)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Sub Menu Item 5.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885183834267398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1885188154676420435)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Sub Menu Item 5.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(1885183834267398330)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_cards_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1905294320111585320)
,p_name=>'UT - Sample Cards List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905294505697585323)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Amet Incorporated Amet Incorporated'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-cloud'
,p_list_text_01=>'Mauris nulla. Integer urna. Vivamus molestie dapibus ligula. Aliquam erat volutpat. Nulla dignissim. Maecenas ornare egestas ligula. Nullam feugiat placerat'
,p_list_text_02=>'4 Widgets'
,p_list_text_03=>'AM'
,p_list_text_07=>'New York'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905294935989585324)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Ridiculus LLP Ridiculus LLP'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-comments-o'
,p_list_text_01=>'Phasellus nulla. Integer vulputate, risus a ultricies adipiscing, enim mi tempor lorem, eget mollis lectus pede et risus. Quisque libero.'
,p_list_text_02=>'12 Widgets'
,p_list_text_03=>'RD'
,p_list_text_07=>'Reston'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905295369724585324)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tristique LLC Tristique LLC'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-calendar'
,p_list_text_01=>'Aliquam nisl. Nulla eu neque pellentesque massa lobortis ultrices. Vivamus rhoncus. Donec est. Nunc ullamcorper, velit in aliquet lobortis, nisi.'
,p_list_text_02=>'4 Widgets'
,p_list_text_03=>'TR'
,p_list_text_07=>'Columbus'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905295764296585326)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Cras Interdum Consulting Cras Interdum Consulting'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-envelope-o'
,p_list_text_01=>'Integer tincidunt aliquam arcu. Aliquam ultrices iaculis odio. Nam interdum enim non nisi. Aenean eget metus. In nec orci.'
,p_list_text_02=>'431 Widgets'
,p_list_text_03=>'CI'
,p_list_text_07=>'Vienna'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_links_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1905596320814687297)
,p_name=>'UT - Sample Links List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905596536207687297)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Amet Incorporated'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-cloud'
,p_list_text_01=>'4'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905596969485687298)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Ridiculus LLP'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-comments'
,p_list_text_01=>'12'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905597364739687298)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tristique LLC'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-calendar'
,p_list_text_01=>'4'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905597791472687298)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Cras Interdum Consulting'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-envelope'
,p_list_text_01=>'431'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905598144786687299)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Felis Associates'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-dashboard'
,p_list_text_01=>'Pending'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905598584337687301)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Eros Nec Corporation'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-user'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_links_list_nested
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1905725173247765454)
,p_name=>'UT - Sample Links List (Nested)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905725317963765454)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Amet Incorporated'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-cloud'
,p_list_text_01=>'4'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905725746257765455)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Ridiculus LLP'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-comments'
,p_list_text_01=>'12'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905726107658765455)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tristique LLC'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-calendar'
,p_list_text_01=>'4'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905726569807765455)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Cras Interdum Consulting'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-envelope'
,p_parent_list_item_id=>wwv_flow_api.id(1905726107658765455)
,p_list_text_01=>'431'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905726936888765456)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Felis Associates'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-dashboard'
,p_parent_list_item_id=>wwv_flow_api.id(1905726107658765455)
,p_list_text_01=>'Pending'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905727314446765456)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Eros Nec Corporation'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-user'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_menu_bar_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1905952052314948882)
,p_name=>'UT - Sample Menu Bar List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905952607959948883)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Menu Item 1'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-cloud'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905954215593948883)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Sub Menu Item 1.1'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-area-chart'
,p_parent_list_item_id=>wwv_flow_api.id(1905952607959948883)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905954674933948884)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Sub Menu Item 1.2'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-bar-chart'
,p_parent_list_item_id=>wwv_flow_api.id(1905952607959948883)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905955080502948884)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Sub Menu Item 1.3'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-bar-chart-o'
,p_parent_list_item_id=>wwv_flow_api.id(1905952607959948883)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905953072764948883)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Menu Item 2'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-anchor'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905955483020948884)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Sub Menu Item 2.1'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-bars'
,p_parent_list_item_id=>wwv_flow_api.id(1905953072764948883)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905955894256948884)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Sub Menu Item 2.2'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-beer'
,p_parent_list_item_id=>wwv_flow_api.id(1905953072764948883)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905956281189948884)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Sub Menu Item 2.2.1'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-binoculars'
,p_parent_list_item_id=>wwv_flow_api.id(1905955894256948884)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905956672130948884)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Sub Menu Item 2.2.2'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-bomb'
,p_parent_list_item_id=>wwv_flow_api.id(1905955894256948884)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905957019149948885)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Sub Menu Item 2.2.3'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-bug'
,p_parent_list_item_id=>wwv_flow_api.id(1905955894256948884)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905953487146948883)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Menu Item 3'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-archive'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905957411424948886)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Sub Menu Item 3.1'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-briefcase'
,p_parent_list_item_id=>wwv_flow_api.id(1905953487146948883)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1905957883540948886)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Sub Menu Item 3.2'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-camera'
,p_parent_list_item_id=>wwv_flow_api.id(1905953487146948883)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2449454871874145996)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Menu Item 4'
,p_list_item_link_target=>'#'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_navigation_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1909492128497202180)
,p_name=>'UT - Sample Navigation Bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1909492392340202182)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Help'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-question-circle'
,p_list_text_02=>'icon-only'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1909492704734202182)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Notifications'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-inbox'
,p_list_text_01=>'3'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1909493151686202183)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'&APP_USER.'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-user'
,p_list_text_02=>'has-username'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1909493570863202183)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Sign Out'
,p_list_item_link_target=>'&LOGOUT_URL.'
,p_parent_list_item_id=>wwv_flow_api.id(1909493151686202183)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_pages
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(1917756475003302943)
,p_name=>'Template - Pages'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1917854764902086401)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Both Side Columns'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:both_sides:&DEBUG.::::'
,p_list_item_icon=>'fa fa-columns'
,p_list_text_01=>'This page template features both the left side column and the collapsible right-side column and is well suited for very complex pages.'
,p_list_text_03=>'BS'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1917758219558302948)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Dialog Page'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:dialog:&DEBUG.::::'
,p_list_item_icon=>'fa-comment'
,p_list_text_01=>'These page templates can be loaded as either modal or non-modal (pop-up) dialogs and are very useful for displaying commonly used forms, reports, and other components.'
,p_list_text_03=>'DP'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1917757070091302947)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Left Side Column'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:left_side:&DEBUG.::::'
,p_list_item_icon=>'fa-layout-2col'
,p_list_text_01=>'Features a left-side display position for search filters, charts, and other interactive widgets.'
,p_list_text_03=>'LC'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1917759284120309798)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Login Page'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:other:&DEBUG.::::'
,p_list_item_icon=>'fa-file-o'
,p_list_text_01=>'The Login page template'
,p_list_text_03=>'LP'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1917757817164302947)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Master Detail'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:master_detail:&DEBUG.::::'
,p_list_item_icon=>'fa-layout-3col-1col'
,p_list_text_01=>'This page template features a collapsible right side column and a title-bar area which contains primary information.'
,p_list_text_03=>'MD'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285497438316229565)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Minimal (No Navigation)'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:other:&DEBUG.::::'
,p_list_item_icon=>'fa-file-o'
,p_list_text_01=>'It is useful for single page applications or pages where where navigation is not necessary.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285501589504274877)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Modal Dialog'
,p_list_item_link_target=>'f?p=&APP_ID.:1910:&SESSION.:other:&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-header'
,p_list_text_01=>'Modal dialogs are a great way to get user input, display information, and speed up user interactions without changing context or leaving the current page.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1917757429622302947)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Right Side Column'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:right_side:&DEBUG.::::'
,p_list_item_icon=>'fa-layout-2col'
,p_list_text_01=>'This page template features a collapsible right-side display position and is especially useful for displaying action-oriented controls such as buttons or lists.'
,p_list_text_03=>'RS'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(1917756637934302944)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Standard'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.:standard:&DEBUG.::::'
,p_list_item_icon=>'fa-file-o'
,p_list_text_01=>'The default page template.'
,p_list_text_03=>'ST'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285503483961293818)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Wizard Modal Dialog'
,p_list_item_link_target=>'f?p=&APP_ID.:1208:&SESSION.:other:&DEBUG.::::'
,p_list_item_icon=>'fa-wizard'
,p_list_text_01=>'Wizards can be very useful in simplifying complex flows into smaller, more manageable steps.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/top_data_tables_and_reports
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2010946567680071816)
,p_name=>'Top - Data Tables and Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2010946713391071818)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Classic Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table'
,p_list_text_01=>'This is the default report template used for displaying tabular data.'
,p_list_text_03=>'CR'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2010947167731071820)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Interactive Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table-pointer'
,p_list_text_01=>'Customizing your report such as searching, filtering, sorting, highlighting, group-by, pivot, aggregations, calculations, charting, and more.'
,p_list_text_03=>'IR'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2010969252333081300)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Interactive Grid'
,p_list_item_link_target=>'f?p=&APP_ID.:1410:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table-cursor'
,p_list_text_01=>'Extensible and Customizable, makeing it effortless to create master-detail relationships.'
,p_list_text_03=>'IG'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315967780734034756)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Reflow Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1710:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tablet'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(315968035924038409)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Column Toggle Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1710:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-toggle-on'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/top_modal_dialogs
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2011053202038416818)
,p_name=>'Top - Modal Dialogs'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2011053433081416822)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page Dialog'
,p_list_item_link_target=>'f?p=&APP_ID.:1910:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-header'
,p_list_text_01=>'Include a full page inside another page. You will be able to utilize Page Process and Page Validation from that page.'
,p_list_text_03=>'PM'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2011053895828416824)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Inline Dialog'
,p_list_item_link_target=>'f?p=&APP_ID.:1911:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-header'
,p_list_text_01=>'Essentially a hidden Region on the same page displayed as a dialog.'
,p_list_text_03=>'ID'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(210177198989587652)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Inline Popup'
,p_list_item_link_target=>'f?p=&APP_ID.:1915:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-blank'
,p_list_text_01=>'Essentially a hidden Region on the same page displayed as an inline popup.'
,p_list_text_03=>'IP'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/templates_region_types
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2055911789926116545)
,p_name=>'Templates - Region Types'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055911953028116548)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Breadcrumb'
,p_list_item_link_target=>'f?p=&APP_ID.:3810:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-breadcrumb'
,p_list_text_01=>'A hierarchical list of links that indicates where the user is within the application from a hierarchical perspective.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055912389249116549)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Calendar'
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-calendar'
,p_list_text_01=>'calendar is based on the Full Calendar library and supports drag and drop, multiple views, and more'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055960954361299471)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Chart'
,p_list_item_link_target=>'f?p=&APP_ID.:1902:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-area-chart'
,p_list_text_01=>'Charts are based on Oracle JavaScript Extension Toolkit (JET) Data Visualizations'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055962902260318939)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Help Text'
,p_list_item_link_target=>'f?p=&APP_ID.:1903:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-info-circle'
,p_list_text_01=>'Page-level help'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2056017212222817190)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Classic Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-align-justify'
,p_list_text_01=>'The default report template used for displaying tabular data'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(342347434760422392)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Column Toggle Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1720:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-toggle-on'
,p_list_text_01=>'Quickly choose columns to display when screen size is limited.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2056017656799817190)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Interactive Grid'
,p_list_item_link_target=>'f?p=&APP_ID.:1410:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-modal-grid-2x'
,p_list_text_01=>'A native APEX component and provides powerful features for customizing your report'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2056018038357817190)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Interactive Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-sort-amount-asc'
,p_list_text_01=>'All the features you expect for powerful reporting, including fixed headers, frozen columns, scroll pagination, multiple filters, sorting, aggregates, computations, and more'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(334869847605736365)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'List View'
,p_list_item_link_target=>'f?p=&APP_ID.:1700:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list'
,p_list_text_01=>'This is a port of the jQuery Mobile List View component and provides a simple list with a number of settings.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055963503129328008)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Map Chart'
,p_list_item_link_target=>'f?p=&APP_ID.:1904:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-globe'
,p_list_text_01=>'Visualize geo related data'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055964176626333376)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'PL/SQL Dynamic Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1908:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-terminal'
,p_list_text_01=>'Render HTML or text using the PL/SQL Web Toolkit'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055964651808337740)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Region Display Selector'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tabs'
,p_list_text_01=>'Show and hide controls for regions'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(342149812969419468)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Reflow Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1710:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tablet'
,p_list_text_01=>'Display data vertically to save space when screen size becomes small'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055965040665342525)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Static Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1905:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-layout-blank'
,p_list_text_01=>'Use HTML markup directly'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2055965552556347381)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Tree'
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tree-org'
,p_list_text_01=>'Hierarchical navigational control based on a SQL query'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_menu_popup
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2151851130486915930)
,p_name=>'UT - Sample Menu Popup'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2151851347742915931)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Action A'
,p_list_item_link_target=>'#'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2151851768475915933)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Action B'
,p_list_item_link_target=>'#'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2151852970586915934)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Sub Item A'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2151851768475915933)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2151967813182919356)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Sub Item B'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2151851768475915933)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2151852114030915934)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Action C'
,p_list_item_link_target=>'#'
,p_list_item_current_for_pages=>'#'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2151852574926915934)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Action D'
,p_list_item_link_target=>'#'
,p_list_item_current_for_pages=>'#'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_menu_popup_actions
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2152333587573851637)
,p_name=>'UT - Sample Menu Popup (Actions)'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2152333734855851640)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'New'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-file-o'
,p_list_text_01=>'action_a'
,p_list_text_05=>'Ctrl+Alt+D'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2152334191341851641)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Open'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-folder-open-o'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2152335373302851642)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Spreadsheet'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-file-excel-o'
,p_parent_list_item_id=>wwv_flow_api.id(2152334191341851641)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2152335728933851643)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Image'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-file-image-o'
,p_parent_list_item_id=>wwv_flow_api.id(2152334191341851641)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2152334571721851641)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2152334936858851642)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Exit'
,p_list_item_link_target=>'#'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_get_started_navigation
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2199914850856725555)
,p_name=>'UT - Get Started Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199915038780725558)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Getting Started'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-mouse-pointer'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'getting_started'
,p_list_text_05=>'u-color-1'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Design'
,p_list_item_link_target=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-design'
,p_list_text_06=>'u-color-3'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199925451619725568)
,p_list_item_display_sequence=>680
,p_list_item_link_text=>'Overview'
,p_list_item_link_target=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199925889085725568)
,p_list_item_display_sequence=>690
,p_list_item_link_text=>'Colors'
,p_list_item_link_target=>'f?p=&APP_ID.:402:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199926220386725568)
,p_list_item_display_sequence=>700
,p_list_item_link_text=>'Customization'
,p_list_item_link_target=>'f?p=&APP_ID.:403:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199926683759725569)
,p_list_item_display_sequence=>710
,p_list_item_link_text=>'Data Entry'
,p_list_item_link_target=>'f?p=&APP_ID.:404:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199927045499725569)
,p_list_item_display_sequence=>720
,p_list_item_link_text=>'Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_text_10=>'700'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199915471527725560)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Grid Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199927045499725569)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'300'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199917052595725561)
,p_list_item_display_sequence=>34
,p_list_item_link_text=>'Page Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199927045499725569)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199928692650725570)
,p_list_item_display_sequence=>760
,p_list_item_link_text=>'Responsive Design'
,p_list_item_link_target=>'f?p=&APP_ID.:701:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(2199927045499725569)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199927456431725569)
,p_list_item_display_sequence=>730
,p_list_item_link_text=>'Notifications and Messaging'
,p_list_item_link_target=>'f?p=&APP_ID.:406:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199927829440725570)
,p_list_item_display_sequence=>740
,p_list_item_link_text=>'Navigation'
,p_list_item_link_target=>'f?p=&APP_ID.:407:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199928259636725570)
,p_list_item_display_sequence=>750
,p_list_item_link_text=>'UI Patterns'
,p_list_item_link_target=>'f?p=&APP_ID.:5000:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_parent_list_item_id=>wwv_flow_api.id(2199915813984725560)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5000'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199923492905725566)
,p_list_item_display_sequence=>630
,p_list_item_link_text=>'Login Page'
,p_list_item_link_target=>'f?p=&APP_ID.:5001:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199928259636725570)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199923821118725566)
,p_list_item_display_sequence=>640
,p_list_item_link_text=>'Home and Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:5002:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199928259636725570)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199924258051725567)
,p_list_item_display_sequence=>650
,p_list_item_link_text=>'Filter Page'
,p_list_item_link_target=>'f?p=&APP_ID.:5003:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199928259636725570)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199924654552725567)
,p_list_item_display_sequence=>660
,p_list_item_link_text=>'Marquee page'
,p_list_item_link_target=>'f?p=&APP_ID.:5004:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199928259636725570)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199925080599725568)
,p_list_item_display_sequence=>670
,p_list_item_link_text=>'Modal Dialogs'
,p_list_item_link_target=>'f?p=&APP_ID.:5005:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199928259636725570)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Components'
,p_list_item_link_target=>'f?p=&APP_ID.:3000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-shapes'
,p_list_text_06=>'u-color-15'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199929865854725571)
,p_list_item_display_sequence=>1000
,p_list_item_link_text=>'Activity Timeline'
,p_list_item_link_target=>'f?p=&APP_ID.:1406:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199930236532725571)
,p_list_item_display_sequence=>1010
,p_list_item_link_text=>'Alert'
,p_list_item_link_target=>'f?p=&APP_ID.:1202:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199930620624725572)
,p_list_item_display_sequence=>1020
,p_list_item_link_text=>'Badges List'
,p_list_item_link_target=>'f?p=&APP_ID.:1304:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199931063021725572)
,p_list_item_display_sequence=>1040
,p_list_item_link_text=>'Breadcrumb'
,p_list_item_link_target=>'f?p=&APP_ID.:3810:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199931421447725572)
,p_list_item_display_sequence=>1050
,p_list_item_link_text=>'Buttons'
,p_list_item_link_target=>'f?p=&APP_ID.:1500:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199920230321725564)
,p_list_item_display_sequence=>380
,p_list_item_link_text=>'Text Only'
,p_list_item_link_target=>'f?p=&APP_ID.:1501:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199931421447725572)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199920697586725564)
,p_list_item_display_sequence=>385
,p_list_item_link_text=>'Icon Only'
,p_list_item_link_target=>'f?p=&APP_ID.:1502:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199931421447725572)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199921017032725564)
,p_list_item_display_sequence=>390
,p_list_item_link_text=>'Text with Icon'
,p_list_item_link_target=>'f?p=&APP_ID.:1503:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199931421447725572)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199931813796725573)
,p_list_item_display_sequence=>1060
,p_list_item_link_text=>'Button Group'
,p_list_item_link_target=>'f?p=&APP_ID.:1204:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199932247847725573)
,p_list_item_display_sequence=>1070
,p_list_item_link_text=>'Button Container Region'
,p_list_item_link_target=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199932671914725573)
,p_list_item_display_sequence=>1080
,p_list_item_link_text=>'Calendars'
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199933013206725573)
,p_list_item_display_sequence=>1090
,p_list_item_link_text=>'Cards'
,p_list_item_link_target=>'f?p=&APP_ID.:3100:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199933487059725574)
,p_list_item_display_sequence=>1090
,p_list_item_link_text=>'Carousel'
,p_list_item_link_target=>'f?p=&APP_ID.:1205:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199933890141725574)
,p_list_item_display_sequence=>1100
,p_list_item_link_text=>'Charts'
,p_list_item_link_target=>'f?p=&APP_ID.:1902:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199934236802725574)
,p_list_item_display_sequence=>1110
,p_list_item_link_text=>'Collapsible'
,p_list_item_link_target=>'f?p=&APP_ID.:1206:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199934636509725575)
,p_list_item_display_sequence=>1120
,p_list_item_link_text=>'Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1405:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199935042466725575)
,p_list_item_display_sequence=>1130
,p_list_item_link_text=>'Data Tables and Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:3400:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199935812483725576)
,p_list_item_display_sequence=>1140
,p_list_item_link_text=>'Classic Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199935042466725575)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199936247089725576)
,p_list_item_display_sequence=>1150
,p_list_item_link_text=>'Interactive Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199935042466725575)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199937458556725577)
,p_list_item_display_sequence=>1160
,p_list_item_link_text=>'Interactive Grid'
,p_list_item_link_target=>'f?p=&APP_ID.:1410:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199935042466725575)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199935466844725576)
,p_list_item_display_sequence=>1140
,p_list_item_link_text=>'Forms'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199919456634725563)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Form Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:1601:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199935466844725576)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199919801571725563)
,p_list_item_display_sequence=>370
,p_list_item_link_text=>'Multi Column Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:1602:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199935466844725576)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199936645857725576)
,p_list_item_display_sequence=>1150
,p_list_item_link_text=>'Help Text'
,p_list_item_link_target=>'f?p=&APP_ID.:1903:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199937014553725577)
,p_list_item_display_sequence=>1160
,p_list_item_link_text=>'Hero'
,p_list_item_link_target=>'f?p=&APP_ID.:1203:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199937816517725578)
,p_list_item_display_sequence=>1180
,p_list_item_link_text=>'Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:1300:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199938264055725578)
,p_list_item_display_sequence=>1180
,p_list_item_link_text=>'Links List'
,p_list_item_link_target=>'f?p=&APP_ID.:1303:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199937816517725578)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199938673155725578)
,p_list_item_display_sequence=>1190
,p_list_item_link_text=>'Media List'
,p_list_item_link_target=>'f?p=&APP_ID.:1301:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199937816517725578)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199939015849725579)
,p_list_item_display_sequence=>1208
,p_list_item_link_text=>'Map Chart'
,p_list_item_link_target=>'f?p=&APP_ID.:1904:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199939488521725579)
,p_list_item_display_sequence=>1209
,p_list_item_link_text=>'Menu Bar'
,p_list_item_link_target=>'f?p=&APP_ID.:1305:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199940248049725579)
,p_list_item_display_sequence=>1210
,p_list_item_link_text=>'Menu Popup'
,p_list_item_link_target=>'f?p=&APP_ID.:1306:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199939871074725579)
,p_list_item_display_sequence=>1210
,p_list_item_link_text=>'Modal Dialogs'
,p_list_item_link_target=>'f?p=&APP_ID.:1906:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199940604541725580)
,p_list_item_display_sequence=>1220
,p_list_item_link_text=>'Page Modal'
,p_list_item_link_target=>'f?p=&APP_ID.:1910:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199939871074725579)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199941064558725580)
,p_list_item_display_sequence=>1230
,p_list_item_link_text=>'Inline Modal'
,p_list_item_link_target=>'f?p=&APP_ID.:1911:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199939871074725579)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199941457938725580)
,p_list_item_display_sequence=>1240
,p_list_item_link_text=>'PL/SQL Dynamic Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1908:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199941824973725580)
,p_list_item_display_sequence=>1250
,p_list_item_link_text=>'Region Display Selector'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199942279010725581)
,p_list_item_display_sequence=>1260
,p_list_item_link_text=>'Standard Region'
,p_list_item_link_target=>'f?p=&APP_ID.:1201:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199942630089725581)
,p_list_item_display_sequence=>1270
,p_list_item_link_text=>'Static Content'
,p_list_item_link_target=>'f?p=&APP_ID.:1905:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199943091597725581)
,p_list_item_display_sequence=>1280
,p_list_item_link_text=>'Title Bar Region'
,p_list_item_link_target=>'f?p=&APP_ID.:1207:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199943487824725581)
,p_list_item_display_sequence=>1290
,p_list_item_link_text=>'Tree'
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199943813522725582)
,p_list_item_display_sequence=>1310
,p_list_item_link_text=>'Value Attribute Pairs Report'
,p_list_item_link_target=>'f?p=&APP_ID.:1403:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199944253783725582)
,p_list_item_display_sequence=>1320
,p_list_item_link_text=>'Wizards'
,p_list_item_link_target=>'f?p=&APP_ID.:1208:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199916206798725560)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199917882611725561)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Migration Guide'
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-tasks'
,p_list_text_06=>'u-color-11'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199929086519725570)
,p_list_item_display_sequence=>770
,p_list_item_link_text=>'From Universal Theme v1.0'
,p_list_item_link_target=>'f?p=&APP_ID.:1909:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199917882611725561)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199929423586725571)
,p_list_item_display_sequence=>780
,p_list_item_link_text=>'From Other Themes'
,p_parent_list_item_id=>wwv_flow_api.id(2199917882611725561)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199921480975725564)
,p_list_item_display_sequence=>530
,p_list_item_link_text=>'Why Migrate'
,p_list_item_link_target=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199929423586725571)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199921899733725565)
,p_list_item_display_sequence=>540
,p_list_item_link_text=>'Migration Steps'
,p_list_item_link_target=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199929423586725571)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199922235425725565)
,p_list_item_display_sequence=>550
,p_list_item_link_text=>'Post Migration'
,p_list_item_link_target=>'f?p=&APP_ID.:2030:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199929423586725571)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199922629181725565)
,p_list_item_display_sequence=>560
,p_list_item_link_text=>'Bookmarklet'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199929423586725571)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199923016509725566)
,p_list_item_display_sequence=>570
,p_list_item_link_text=>'FAQ'
,p_list_item_link_target=>'f?p=&APP_ID.:2050:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199929423586725571)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199918228951725562)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Icons'
,p_list_item_link_target=>'f?p=&APP_ID.:4000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-apex'
,p_list_text_06=>'u-color-9'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199918651863725562)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Reference'
,p_list_item_link_target=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-cogs'
,p_list_text_06=>'u-color-13'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'6000,6303,6304,6305,6306,2,6201'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199944661376725582)
,p_list_item_display_sequence=>1330
,p_list_item_link_text=>'Button Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:6100:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199918651863725562)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199945031619725582)
,p_list_item_display_sequence=>1340
,p_list_item_link_text=>'Responsive Classes'
,p_list_item_link_target=>'f?p=&APP_ID.:6301:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199918651863725562)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199945441839725584)
,p_list_item_display_sequence=>1350
,p_list_item_link_text=>'Color and Status Modifiers'
,p_list_item_link_target=>'f?p=&APP_ID.:6302:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199918651863725562)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199945827934725585)
,p_list_item_display_sequence=>1360
,p_list_item_link_text=>'JavaScript Events'
,p_list_item_link_target=>'f?p=&APP_ID.:6200:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199918651863725562)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199946285768725585)
,p_list_item_display_sequence=>1370
,p_list_item_link_text=>'Component Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:6307:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199918651863725562)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2199946614195725585)
,p_list_item_display_sequence=>1380
,p_list_item_link_text=>'Region Types'
,p_list_item_link_target=>'f?p=&APP_ID.:6308:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_api.id(2199918651863725562)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_progress_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2285450736180797899)
,p_name=>'Wizard Progress List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285451805253797903)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Step 1'
,p_list_item_link_target=>'f?p=&APP_ID.:1920:&SESSION.::&DEBUG.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285456678636797921)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Step 2'
,p_list_item_link_target=>'f?p=&APP_ID.:1921:&SESSION.::&DEBUG.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285462162578797926)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Step 3'
,p_list_item_link_target=>'f?p=&APP_ID.:1922:&SESSION.::&DEBUG.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_tabs_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2285543718406476760)
,p_name=>'UT - Sample Tabs List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285543917158476761)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Tab 1'
,p_list_item_link_target=>'javascript:void(0);'
,p_list_item_icon=>'fa-user'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1907'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285544391396476761)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Tab 2'
,p_list_item_link_target=>'javascript:void(0);'
,p_list_item_icon=>'fa-heart-o'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2285544741435476761)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tab 3'
,p_list_item_link_target=>'javascript:void(0);'
,p_list_item_icon=>'fa-cloud'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/ut_sample_menu_bar_variation_1_list
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(2505356324704497838)
,p_name=>'UT - Sample Menu Bar Variation 1 List'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505356552464497840)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Menu Item 1'
,p_list_item_icon=>'fa-cloud'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505357768390497842)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Sub Menu Item 1.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505356552464497840)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505358168401497842)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Sub Menu Item 1.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505356552464497840)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505358574874497843)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Sub Menu Item 1.3'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505356552464497840)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505356955981497842)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Menu Item 2'
,p_list_item_icon=>'fa-anchor'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505358996211497844)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Sub Menu Item 2.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505356955981497842)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505359340862497844)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Sub Menu Item 2.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505356955981497842)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505360557572497844)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Sub Menu Item 2.2.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505359340862497844)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505360991574497844)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Sub Menu Item 2.2.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505359340862497844)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505361327831497845)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Sub Menu Item 2.2.3'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505359340862497844)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505357383685497842)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Menu Item 3'
,p_list_item_icon=>'fa-archive'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505359775199497844)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Sub Menu Item 3.1'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505357383685497842)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505360190070497844)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Sub Menu Item 3.2'
,p_list_item_link_target=>'#'
,p_parent_list_item_id=>wwv_flow_api.id(2505357383685497842)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(2505361729012497845)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Menu Item 4'
,p_list_item_link_target=>'#'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/files/img_app_user_jpg
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '89504E470D0A1A0A0000000D4948445200000080000000800800000000E6553E170000047C494441547801EDDB09A7F34E1B80F1E7FB7F9A2B2346082118CB38861027448C2AB154A9200891FB59FFCF7EB2BD337DB773D96BFB35E936F7AD1FAEFFE63E';
wwv_flow_api.g_varchar2_table(2) := '5CFECD7DB85EFEAD5DDF01E701EF8077C03BE01DF00EF08D33B956289D1BD7F827037C5526FC5C5256FE7980CE2A409BFA7A7B0C8FDBB5361A50B67B0EC0DB04747D5BE447CBADD69058FF04409D42719DE5F7E66B01691D1BE00D649745FED672C9C0F8';
wwv_flow_api.g_varchar2_table(3) := 'A8802E0337CB5BCD0EB22E22A04D497B59AB4F49DB688056910DB2DE90A1DA488056514CB2D554A0DA2800AFC927D96ECAD13E02C017E851F6346A0A1F1E6049EEB2AF7B820D0E68C1CBDE3CB481013EC7C8FE0CB90F0B70A851F6372A5C508057B472A4';
wwv_flow_api.g_varchar2_table(4) := '16E543021C7A9623CD1A1710E0155E8EE5513E1CA046CF72AC59538703E4D472B49A3C18A083518E3642170AE028E578252E1420A795E3B5E481001E0639DE003E0CA041CB99344D1880C3C8992C2E0CA0A49533B594610019BD9CA9270B038041CE3440';
wwv_flow_api.g_varchar2_table(5) := '10808749CE34810F01E840CE055D08408B967369DA1080E63420A30903C8CE03FE276E410B722EC2003CCC72A6197C18C0F90FA220808B3EFD51ACFF47BE8C2C56CE64B1610035999C29A30E03F030CAF146F06100978C4E8EE7C92E81001623C733D850';
wwv_flow_api.g_varchar2_table(6) := '80966492A34D096D28C025A391A335649760808A6C96632D192EE8F1FC2AC7BA063D9E5F2CF9C101458E0D3CA2F141E7132786547A92FD4D1A17784CA7B1B23F8BF6610197067AD95B0F4DF051AD410DB2AF4161220CAB73F249F634E5E43E3CE0D2A594';
wwv_flow_api.g_varchar2_table(7) := 'B36C3797A45DAC8585D916CC26CAC2E24B8DA21865BDB140359738802F82EC2E6BDD335413736DA7499A45DE6A69127417777159427193BF772BA0F4B157B79502F337C2CD80AA9EB0BC6E018A6E949F1B7D01D05E9E0068C00014CEDF86699A869B7705';
wwv_flow_api.g_varchar2_table(8) := '8081E619800AFDE85DC6AF65AE7FA454CF00BC500C8FC7A37FB585024015F6B5FFF4C850F0F20C80C12ED3F8F8D2FD76BBDD1F5F1AA7C5629E0128A945E49361181E5F1B86715A44A4A67C0620C7CBB7E6AFC9B73AF26700527AF97B3D697CC0DAC06400';
wwv_flow_api.g_varchar2_table(9) := '1F1FD0BC3D329AA08D0FA8D0F2569A3A3EC052CA5B15BCC4071438792B47191DD025F4EB07C2C88072EDA03C6B4C64805D3F9F7450C50474253859693124D64702F8AA54E016596B2A41DB363CA0738502F455369A6B056853FB8080C6E600CA5E67D96E';
wwv_flow_api.g_varchar2_table(10) := 'AC730055BA2E04C057467FFBC533CBDE86CE2400B96DF603562E3C45F390834DBDD300DA547E1DB079E18D1FE554CBBD2E0054F1D21E05F8DA7CF56F5FF8F5466F1440666ABF1FD09914A0A8EF8BFCEBCDB72A03D0C6EF04546AE5C29F6B68CB04D26A17';
wwv_flow_api.g_varchar2_table(11) := 'C041E62709DDD469703B00359849623419927A13E035E52C719A4BB4DF0238D428B11A156E0B50E0245E8E620B90D24BBC7AD20D4007A3C46B846E1DD0C02CF19AA1590754688999A65A07BC504ACC4A5ED601062B31B3987540492531AB28D701399DC4';
wwv_flow_api.g_varchar2_table(12) := 'AC235F07687A89598F5E0724DC256677921540D0CFA1954FA215C02BC922315B125ED7001599C42DA35A03584A895B895D0318ACC4CD62D60025B5C4ADA6FC15F0E61032529EFCB73FBFFF92A697B8F5E8EBCF7D042C723226C80BEC8A0000000049454E';
wwv_flow_api.g_varchar2_table(13) := '44AE426082';
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(360786884434746476)
,p_file_name=>'img/app_user.jpg'
,p_mime_type=>'image/jpeg'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/bookmarklet_js
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '0A2F2A210A20202020436F707972696768742028632920323031342C204F7261636C6520616E642F6F722069747320616666696C69617465732E20416C6C207269676874732072657365727665642E0A202A2F0A2866756E6374696F6E2829207B0A2020';
wwv_flow_api.g_varchar2_table(2) := '20206966202877696E646F772E24203D3D3D20756E646566696E656429207B0A2020202020202020616C6572742822546F20757365207468697320626F6F6B6D61726B6C65742C20796F75206E65656420746F2C2066697273742C206472616720697420';
wwv_flow_api.g_varchar2_table(3) := '696E746F20796F757220626F6F6B6D61726B206261727320616E64207468656E20636C69636B206F6E206974206F6E207061676520333836206F6620746865207468656D65207377697463682077697A6172642122293B0A202020202020202072657475';
wwv_flow_api.g_varchar2_table(4) := '726E3B0A202020207D0A0A0A0A202020207661722057524954455F4D4F4445203D20747275653B0A0A0A20202020766172207468656D653231416E645468656D6532324D617070696E67203D207B0A20202020202020202242726561646372756D62223A';
wwv_flow_api.g_varchar2_table(5) := '207B0A2020202020202020202020202242726561646372756D62204D656E75223A202242726561646372756D62220A20202020202020207D2C0A202020202020202022427574746F6E223A207B0A20202020202020202020202022486F7420427574746F';
wwv_flow_api.g_varchar2_table(6) := '6E202852656429223A202254657874222C0A20202020202020202020202022486F7420427574746F6E2028426C61636B29223A202254657874222C0A20202020202020202020202022486F7420427574746F6E2028526564204F75746C696E6529223A20';
wwv_flow_api.g_varchar2_table(7) := '2254657874222C0A20202020202020202020202022536D616C6C20427574746F6E223A202254657874222C0A20202020202020202020202022427574746F6E223A202254657874222C0A2020202020202020202020202248544D4C20627574746F6E2028';
wwv_flow_api.g_varchar2_table(8) := '6C6567616379202D20415045582035206D6967726174696F6E29223A202254657874222C0A2020202020202020202020202248544D4C20696D61676520286C6567616379202D20415045582035206D6967726174696F6E29223A202254657874222C0A20';
wwv_flow_api.g_varchar2_table(9) := '202020202020202020202022536D616C6C20486F7420427574746F6E202852656429223A202254657874220A20202020202020207D2C0A2020202020202020224C6162656C223A207B0A202020202020202020202020225265717569726564223A202252';
wwv_flow_api.g_varchar2_table(10) := '65717569726564222C0A20202020202020202020202022526571756972656420776974682068656C70223A20225265717569726564222C0A202020202020202020202020224F7074696F6E616C223A20224F7074696F6E616C222C0A2020202020202020';
wwv_flow_api.g_varchar2_table(11) := '20202020224E6F204C6162656C223A202248696464656E222C0A202020202020202020202020224F7074696F6E616C20776974682068656C70223A20224F7074696F6E616C220A20202020202020207D2C0A2020202020202020224C6567616379204361';
wwv_flow_api.g_varchar2_table(12) := '6C656E646172223A207B0A2020202020202020202020202243616C656E646172223A202243616C656E646172222C0A2020202020202020202020202243616C656E6461722C20416C7465726E61746976652031223A202243616C656E646172222C0A2020';
wwv_flow_api.g_varchar2_table(13) := '2020202020202020202022536D616C6C2043616C656E646172223A202243616C656E646172220A20202020202020207D2C0A2020202020202020224C697374223A207B0A20202020202020202020202022486F72697A6F6E74616C205461627320526F75';
wwv_flow_api.g_varchar2_table(14) := '6E646564204C697374202846756C6C20576964746829223A202254616273222C0A2020202020202020202020202248696572617263686963616C20457870616E64696E67223A20224C696E6B73204C697374222C0A20202020202020202020202022486F';
wwv_flow_api.g_varchar2_table(15) := '72697A6F6E74616C20496D616765732077697468204C6162656C204C697374223A20224D65646961204C697374222C0A20202020202020202020202022566572746963616C20496D61676573204C697374223A20224D65646961204C697374222C0A2020';
wwv_flow_api.g_varchar2_table(16) := '2020202020202020202022546162626564204E617669676174696F6E204C697374223A202254616273222C0A202020202020202020202020224448544D4C2054726565223A20224C696E6B73204C697374222C0A2020202020202020202020202257697A';
wwv_flow_api.g_varchar2_table(17) := '6172642050726F6772657373204C6973742C20486F72697A6F6E74616C20547261696E223A202257697A6172642050726F6772657373222C0A2020202020202020202020202257697A6172642050726F6772657373204C697374223A202257697A617264';
wwv_flow_api.g_varchar2_table(18) := '2050726F6772657373222C0A20202020202020202020202022566572746963616C20556E6F726465726564204C69737420776974682042756C6C6574732C20416C7465726E6174697665223A20224C696E6B73204C697374222C0A202020202020202020';
wwv_flow_api.g_varchar2_table(19) := '2020202250756C6C20446F776E204D656E75207769746820496D616765223A20224C696E6B73204C697374222C0A20202020202020202020202022427574746F6E204C697374223A20224C696E6B73204C697374222C0A20202020202020202020202022';
wwv_flow_api.g_varchar2_table(20) := '486F72697A6F6E74616C205461627320526F756E646564204C697374223A202254616273222C0A20202020202020202020202022566572746963616C204F726465726564204C697374223A20224C696E6B73204C697374222C0A20202020202020202020';
wwv_flow_api.g_varchar2_table(21) := '202022566572746963616C20556E6F726465726564204C69737420776974686F75742042756C6C657473223A20224C696E6B73204C697374222C0A20202020202020202020202022566572746963616C20556E6F726465726564204C6973742077697468';
wwv_flow_api.g_varchar2_table(22) := '2042756C6C657473223A20224C696E6B73204C697374222C0A2020202020202020202020202250756C6C20446F776E204D656E75223A20224C696E6B73204C697374222C0A20202020202020202020202022486F72697A6F6E74616C204C696E6B73204C';
wwv_flow_api.g_varchar2_table(23) := '697374223A20224D65646961204C697374222C0A2020202020202020202020202250616765204C6576656C2054616273204C697374223A2022546F70204E617669676174696F6E204D656E75222C0A20202020202020202020202022566572746963616C';
wwv_flow_api.g_varchar2_table(24) := '2053696465626172204C697374223A20224C696E6B73204C697374222C0A2020202020202020202020202243656E74657265642054616220536574223A202254616273220A20202020202020207D2C0A20202020202020202250616765223A207B0A2020';
wwv_flow_api.g_varchar2_table(25) := '20202020202020202020224F6E65204C6576656C2054616273202D204C65667420616E642052696768742053696465626172202866697865642D7769647468202F20444956206C65667420616E64206F7074696F6E616C207461626C652D626173656420';
wwv_flow_api.g_varchar2_table(26) := '726967687429223A20224C65667420616E64205269676874205369646520436F6C756D6E73222C0A202020202020202020202020224E6F2054616273202D205269676874205369646562617220286F7074696F6E616C202F207461626C652D6261736564';
wwv_flow_api.g_varchar2_table(27) := '29223A20225374616E64617264222C0A202020202020202020202020225072696E74657220467269656E646C79223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A202020202020202020202020224C6F67696E223A20224C6F67';
wwv_flow_api.g_varchar2_table(28) := '696E222C0A2020202020202020202020202254776F204C6576656C2054616273202D204C6566742053696465626172202866697865642D7769647468202F2044495620626173656429223A20224C656674205369646520436F6C756D6E222C0A20202020';
wwv_flow_api.g_varchar2_table(29) := '2020202020202020224E6F2054616273202D2052696768742053696465626172202866697865642D7769647468202F2044495620626173656429223A20225269676874205369646520436F6C756D6E222C0A2020202020202020202020202254776F204C';
wwv_flow_api.g_varchar2_table(30) := '6576656C2054616273202D2052696768742053696465626172202866697865642D7769647468202F2044495620626173656429223A20225269676874205369646520436F6C756D6E222C0A202020202020202020202020224E6F2054616273202D204C65';
wwv_flow_api.g_varchar2_table(31) := '66742053696465626172202866697865642D7769647468202F2044495620626173656429223A20224C656674205369646520436F6C756D6E222C0A202020202020202020202020224F6E65204C6576656C2054616273202D204C65667420536964656261';
wwv_flow_api.g_varchar2_table(32) := '72202866697865642D7769647468202F2044495620626173656429223A20224C656674205369646520436F6C756D6E222C0A20202020202020202020202022506F707570223A20224D696E696D616C20284E6F204E617669676174696F6E29220A202020';
wwv_flow_api.g_varchar2_table(33) := '20202020207D2C0A202020202020202022526567696F6E223A207B0A2020202020202020202020202249525220526567696F6E2054656D706C617465223A2022496E746572616374697665205265706F7274222C0A202020202020202020202020224272';
wwv_flow_api.g_varchar2_table(34) := '6561646372756D6220526567696F6E223A20225469746C6520426172222C0A202020202020202020202020225265706F72747320526567696F6E223A20225374616E64617264222C0A2020202020202020202020202257697A61726420526567696F6E22';
wwv_flow_api.g_varchar2_table(35) := '3A20225374616E64617264222C0A202020202020202020202020225369646562617220526567696F6E2C20426F726465726564223A20225374616E64617264222C0A20202020202020202020202022427261636B6574656420526567696F6E223A202253';
wwv_flow_api.g_varchar2_table(36) := '74616E64617264222C0A2020202020202020202020202243656E7465726564205461622053657420526567696F6E223A20225374616E64617264222C0A202020202020202020202020225369646562617220526567696F6E223A20225374616E64617264';
wwv_flow_api.g_varchar2_table(37) := '222C0A202020202020202020202020225265706F72747320526567696F6E204E6F205469746C652C20416C7465726E61746976652031223A20225374616E64617264222C0A202020202020202020202020224E617669676174696F6E20526567696F6E22';
wwv_flow_api.g_varchar2_table(38) := '3A20225374616E64617264222C0A20202020202020202020202022466F726D20526567696F6E223A20225374616E64617264222C0A202020202020202020202020225369646562617220526567696F6E2C20426F72646572656420416C7465726E617469';
wwv_flow_api.g_varchar2_table(39) := '7665223A20225374616E64617264222C0A20202020202020202020202022427574746F6E20526567696F6E2077697468205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A20202020202020202020202022536964656261722052';
wwv_flow_api.g_varchar2_table(40) := '6567696F6E2C20416C7465726E61746976652031223A20225374616E64617264222C0A202020202020202020202020224E657374656420526567696F6E223A20225374616E64617264222C0A202020202020202020202020225265706F72747320526567';
wwv_flow_api.g_varchar2_table(41) := '696F6E204E6F205469746C65223A20225374616E64617264222C0A20202020202020202020202022427574746F6E20526567696F6E20776974686F7574205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A202020202020202020';
wwv_flow_api.g_varchar2_table(42) := '202020225265706F72747320526567696F6E2C20416C7465726E61746976652031223A20225374616E64617264222C0A202020202020202020202020224869646520616E642053686F7720526567696F6E223A2022436F6C6C61707369626C65222C0A20';
wwv_flow_api.g_varchar2_table(43) := '2020202020202020202020224368617274204C697374223A20225374616E64617264222C0A20202020202020202020202022526567696F6E20776974686F7574205469746C65223A20225374616E64617264222C0A202020202020202020202020225265';
wwv_flow_api.g_varchar2_table(44) := '67696F6E20776974686F757420427574746F6E7320616E64205469746C6573223A20225374616E64617264222C0A20202020202020202020202022426F726465726C65737320526567696F6E202D204E6F205469746C65223A2022426C616E6B20776974';
wwv_flow_api.g_varchar2_table(45) := '682041747472696275746573222C0A202020202020202020202020225265706F72747320526567696F6E2031303025205769647468223A20225374616E64617264222C0A20202020202020202020202022436861727420526567696F6E223A2022537461';
wwv_flow_api.g_varchar2_table(46) := '6E64617264222C0A20202020202020202020202022426F726465726C65737320526567696F6E223A20225374616E64617264222C0A202020202020202020202020224E617669676174696F6E20526567696F6E2C20416C7465726E61746976652031223A';
wwv_flow_api.g_varchar2_table(47) := '20225374616E64617264222C0A2020202020202020202020202257697A61726420526567696F6E20776974682049636F6E223A20225374616E64617264220A20202020202020207D2C0A2020202020202020225265706F7274223A207B0A202020202020';
wwv_flow_api.g_varchar2_table(48) := '202020202020225374616E64617264223A20225374616E64617264222C0A2020202020202020202020202256616C756520417474726962757465205061697273202D20446976223A202256616C756520417474726962757465205061697273202D20436F';
wwv_flow_api.g_varchar2_table(49) := '6C756D6E222C0A202020202020202020202020225374616E646172642C20416C7465726E6174696E6720526F7720436F6C6F7273223A20225374616E64617264222C0A2020202020202020202020202246697865642048656164657273223A2022537461';
wwv_flow_api.g_varchar2_table(50) := '6E64617264222C0A20202020202020202020202022426F726465726C657373205265706F7274223A202253656172636820526573756C7473222C0A2020202020202020202020202254776F20436F6C756D6E20506F72746C6574223A202256616C756520';
wwv_flow_api.g_varchar2_table(51) := '417474726962757465205061697273202D20526F77222C0A20202020202020202020202022486F72697A6F6E74616C20426F72646572223A20225374616E64617264222C0A2020202020202020202020202253656172636820526573756C747320526570';
wwv_flow_api.g_varchar2_table(52) := '6F7274202853454C454354206C696E6B5F746578742C206C696E6B5F7461726765742C2064657461696C312C2064657461696C322C206C6173745F6D6F64696669656429223A202253656172636820526573756C7473220A20202020202020207D0A2020';
wwv_flow_api.g_varchar2_table(53) := '20207D3B0A0A202020202F2A2A0A20202020202A204D616B6520616E79204A534F4E206368616E67657320746F20746865206F626A6563742062656C6F772E0A20202020202A2F0A2020202076617220737570706F727465645468656D6573203D207B0A';
wwv_flow_api.g_varchar2_table(54) := '202020202020202032363A207B0A202020202020202020202020696D6167653A202268747470733A2F2F617065782E6F7261636C652E636F6D2F706C732F617065782F617065785F706D2F722F34322F66696C65732F7374617469632F7638342F2F692F';
wwv_flow_api.g_varchar2_table(55) := '7468656D6532362E706E67222C0A202020202020202020202020746578743A20225468656D65203236202D2050726F647563746976697479204170706C69636174696F6E73222C0A2020202020202020202020206D617070696E67733A207B0A20202020';
wwv_flow_api.g_varchar2_table(56) := '2020202020202020202020202242726561646372756D62223A207B0A20202020202020202020202020202020202020202242726561646372756D62204D656E75223A202242726561646372756D62222C0A20202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(57) := '202248696572617263686963616C204D656E75223A202242726561646372756D62220A202020202020202020202020202020207D2C0A2020202020202020202020202020202022427574746F6E223A207B0A202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(58) := '2020225B202B205D2041646420427574746F6E223A202249636F6E222C0A2020202020202020202020202020202020202020225B203E205D20476F20546F20427574746F6E223A202249636F6E222C0A2020202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(59) := '225B2054657874205D20427574746F6E223A202254657874222C0A202020202020202020202020202020202020202022427574746F6E223A202254657874222C0A20202020202020202020202020202020202020202248544D4C20627574746F6E20286C';
wwv_flow_api.g_varchar2_table(60) := '6567616379202D20415045582035206D6967726174696F6E29223A202254657874222C0A202020202020202020202020202020202020202022496E746572616374697665205265706F727420427574746F6E20284E65787429223A202254657874207769';
wwv_flow_api.g_varchar2_table(61) := '74682049636F6E222C0A202020202020202020202020202020202020202022496E746572616374697665205265706F727420427574746F6E223A202254657874222C0A2020202020202020202020202020202020202020224C6172676520427574746F6E';
wwv_flow_api.g_varchar2_table(62) := '20284E65787429223A20225465787420776974682049636F6E222C0A2020202020202020202020202020202020202020224C6172676520427574746F6E202850726576696F757329223A20225465787420776974682049636F6E222C0A20202020202020';
wwv_flow_api.g_varchar2_table(63) := '20202020202020202020202020224C6172676520427574746F6E223A202254657874222C0A202020202020202020202020202020202020202022536D616C6C20427574746F6E223A202254657874220A202020202020202020202020202020207D2C0A20';
wwv_flow_api.g_varchar2_table(64) := '202020202020202020202020202020224C6162656C223A207B0A20202020202020202020202020202020202020202248696464656E206C6162656C2C20726561642062792073637265656E20726561646572223A202248696464656E222C0A2020202020';
wwv_flow_api.g_varchar2_table(65) := '202020202020202020202020202020224E6F204C6162656C223A202248696464656E222C0A2020202020202020202020202020202020202020224F7074696F6E616C20776974682068656C70223A20224F7074696F6E616C222C0A202020202020202020';
wwv_flow_api.g_varchar2_table(66) := '2020202020202020202020224F7074696F6E616C223A20224F7074696F6E616C222C0A202020202020202020202020202020202020202022526571756972656420776974682068656C70223A20225265717569726564222C0A2020202020202020202020';
wwv_flow_api.g_varchar2_table(67) := '202020202020202020225265717569726564223A20225265717569726564220A202020202020202020202020202020207D2C0A20202020202020202020202020202020224C65676163792043616C656E646172223A207B0A202020202020202020202020';
wwv_flow_api.g_varchar2_table(68) := '20202020202020202243616C656E646172202D20416C7465726E6174697665223A202243616C656E646172222C0A20202020202020202020202020202020202020202243616C656E646172223A202243616C656E646172222C0A20202020202020202020';
wwv_flow_api.g_varchar2_table(69) := '2020202020202020202022536D616C6C2043616C656E646172223A202243616C656E646172220A202020202020202020202020202020207D2C0A20202020202020202020202020202020224C697374223A207B0A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(70) := '2020202022427574746F6E204C697374223A20224C696E6B73204C697374222C0A2020202020202020202020202020202020202020224448544D4C2054726565223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(71) := '20224665617475726564204C69737420776974682053756274657874223A20224D65646961206C697374222C0A20202020202020202020202020202020202020202248696572617263686963616C20457870616E64696E67223A20224C696E6B73204C69';
wwv_flow_api.g_varchar2_table(72) := '7374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C20496D616765732077697468204C6162656C204C697374223A20224D65646961204C697374222C0A202020202020202020202020202020202020202022486F72';
wwv_flow_api.g_varchar2_table(73) := '697A6F6E74616C204C696E6B73204C697374223A20224D65646961204C697374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C2057697A6172642050726F6772657373204C697374223A202257697A617264205072';
wwv_flow_api.g_varchar2_table(74) := '6F6772657373222C0A20202020202020202020202020202020202020202250616765204C6576656C2054616273204C697374223A2022546F70204E617669676174696F6E204D656E75222C0A20202020202020202020202020202020202020202250756C';
wwv_flow_api.g_varchar2_table(75) := '6C20446F776E204D656E75207769746820496D616765223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202250756C6C20446F776E204D656E75223A20224C696E6B73204C697374222C0A202020202020202020';
wwv_flow_api.g_varchar2_table(76) := '2020202020202020202020225365617263682046696C7465722054616273223A202254616273222C0A202020202020202020202020202020202020202022546162626564204E617669676174696F6E204C697374223A202254616273222C0A2020202020';
wwv_flow_api.g_varchar2_table(77) := '20202020202020202020202020202022566572746963616C20496D61676573204C697374223A20224D65646961204C697374222C0A202020202020202020202020202020202020202022566572746963616C204C69737420776974682053756274657874';
wwv_flow_api.g_varchar2_table(78) := '20616E642049636F6E223A20224D65646961204C697374222C0A202020202020202020202020202020202020202022566572746963616C204F726465726564204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(79) := '202020202022566572746963616C2053696465626172204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022566572746963616C20556E6F726465726564204C69737420776974682042756C6C6574';
wwv_flow_api.g_varchar2_table(80) := '73223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022566572746963616C20556E6F726465726564204C69737420776974686F75742042756C6C657473223A20224C696E6B73204C697374222C0A2020202020';
wwv_flow_api.g_varchar2_table(81) := '2020202020202020202020202020202257697A6172642050726F6772657373204C697374202D20566572746963616C223A202257697A6172642050726F6772657373220A202020202020202020202020202020207D2C0A20202020202020202020202020';
wwv_flow_api.g_varchar2_table(82) := '2020202250616765223A207B0A2020202020202020202020202020202020202020224469616C6F67223A20224D6F64616C204469616C6F67222C0A2020202020202020202020202020202020202020224C6F67696E223A20224C6F67696E222C0A202020';
wwv_flow_api.g_varchar2_table(83) := '2020202020202020202020202020202020224D696E696D616C2050616765223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A2020202020202020202020202020202020202020224E6F2054616273202D204C65667420616E6420';
wwv_flow_api.g_varchar2_table(84) := '52696768742053696465626172223A20224C65667420616E64205269676874205369646520436F6C756D6E73222C0A2020202020202020202020202020202020202020224E6F2054616273202D204C6566742053696465626172223A20224C6566742053';
wwv_flow_api.g_varchar2_table(85) := '69646520436F6C756D6E222C0A2020202020202020202020202020202020202020224E6F2054616273202D204E6F2053696465626172223A20225374616E64617264222C0A2020202020202020202020202020202020202020224E6F2054616273202D20';
wwv_flow_api.g_varchar2_table(86) := '52696768742053696465626172223A20225269676874205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D20436F6E74656E74204672616D65223A20224D61737465722044';
wwv_flow_api.g_varchar2_table(87) := '657461696C222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C65667420616E642052696768742053696465626172223A20224C65667420616E64205269676874205369646520436F6C756D6E222C';
wwv_flow_api.g_varchar2_table(88) := '0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C6566742053696465626172223A20224C656674205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C';
wwv_flow_api.g_varchar2_table(89) := '6576656C2054616273202D204E6F2053696465626172223A20225374616E64617264222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D2052696768742053696465626172223A20225269676874205369';
wwv_flow_api.g_varchar2_table(90) := '646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D205365617263682046696C74657220426172223A20224C656674205369646520436F6C756D6E222C0A20202020202020202020';
wwv_flow_api.g_varchar2_table(91) := '20202020202020202020224F6E65204C6576656C2054616273202D2057697A6172642050616765223A20225374616E64617264222C0A202020202020202020202020202020202020202022506F707570223A20224D696E696D616C20284E6F204E617669';
wwv_flow_api.g_varchar2_table(92) := '676174696F6E29222C0A2020202020202020202020202020202020202020225072696E74657220467269656E646C79223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A2020202020202020202020202020202020202020225477';
wwv_flow_api.g_varchar2_table(93) := '6F204C6576656C2054616273202D204C65667420616E642052696768742053696465626172223A20224C65667420616E64205269676874205369646520436F6C756D6E73222C0A20202020202020202020202020202020202020202254776F204C657665';
wwv_flow_api.g_varchar2_table(94) := '6C2054616273202D204C6566742053696465626172223A20224C656674205369646520436F6C756D6E222C0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D204E6F2053696465626172223A20225374616E';
wwv_flow_api.g_varchar2_table(95) := '64617264222C0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D2052696768742053696465626172223A20225269676874205369646520436F6C756D6E220A202020202020202020202020202020207D2C0A';
wwv_flow_api.g_varchar2_table(96) := '2020202020202020202020202020202022526567696F6E223A207B0A20202020202020202020202020202020202020202249525220526567696F6E2054656D706C617465223A2022496E746572616374697665205265706F7274222C0A20202020202020';
wwv_flow_api.g_varchar2_table(97) := '202020202020202020202020202241636365737369626C6520526567696F6E20776974682048656164696E67223A20225374616E64617264222C0A202020202020202020202020202020202020202022416C65727420526567696F6E223A2022416C6572';
wwv_flow_api.g_varchar2_table(98) := '74222C0A202020202020202020202020202020202020202022426F726465726C65737320526567696F6E20286E6F2068656164696E6729223A20225374616E64617264222C0A202020202020202020202020202020202020202022426F726465726C6573';
wwv_flow_api.g_varchar2_table(99) := '7320526567696F6E223A20225374616E64617264222C0A202020202020202020202020202020202020202022427261636B6574656420526567696F6E223A20225374616E64617264222C0A20202020202020202020202020202020202020202242726561';
wwv_flow_api.g_varchar2_table(100) := '646372756D6220526567696F6E223A20225469746C6520426172222C0A202020202020202020202020202020202020202022427574746F6E20526567696F6E2077697468205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A2020';
wwv_flow_api.g_varchar2_table(101) := '20202020202020202020202020202020202022427574746F6E20526567696F6E20776974686F7574205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A2020202020202020202020202020202020202020224368617274204C6973';
wwv_flow_api.g_varchar2_table(102) := '74223A20225374616E64617264222C0A202020202020202020202020202020202020202022436861727420526567696F6E223A20225374616E64617264222C0A202020202020202020202020202020202020202022436F6E74656E74204672616D652042';
wwv_flow_api.g_varchar2_table(103) := '6F647920436F6E7461696E6572223A2022426C616E6B20776974682041747472696275746573222C0A20202020202020202020202020202020202020202244495620526567696F6E2077697468204944223A2022426C616E6B2077697468204174747269';
wwv_flow_api.g_varchar2_table(104) := '6275746573222C0A202020202020202020202020202020202020202022466F726D20526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020224869646520616E642053686F7720526567696F6E20284869';
wwv_flow_api.g_varchar2_table(105) := '6464656E20466972737429202D20426F726465726C657373223A2022436F6C6C61707369626C65222C0A2020202020202020202020202020202020202020224869646520616E642053686F7720526567696F6E202D20426F726465726C657373223A2022';
wwv_flow_api.g_varchar2_table(106) := '436F6C6C61707369626C65222C0A2020202020202020202020202020202020202020224869646520616E642053686F7720526567696F6E223A2022436F6C6C61707369626C65222C0A202020202020202020202020202020202020202022496E74657261';
wwv_flow_api.g_varchar2_table(107) := '6374697665205265706F727420526567696F6E223A2022496E746572616374697665205265706F7274222C0A2020202020202020202020202020202020202020226A5175657279204D6F64616C20526567696F6E2054656D706C617465223A2022496E6C';
wwv_flow_api.g_varchar2_table(108) := '696E65204469616C6F67222C0A2020202020202020202020202020202020202020224C6F67696E20526567696F6E223A20224C6F67696E222C0A2020202020202020202020202020202020202020224D6F64616C20526567696F6E223A2022496E6C696E';
wwv_flow_api.g_varchar2_table(109) := '65204469616C6F67222C0A2020202020202020202020202020202020202020224E617669676174696F6E20526567696F6E202D2048656164696E6720496E73696465223A20225374616E64617264222C0A20202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(110) := '20224E617669676174696F6E20526567696F6E223A20225374616E64617264222C0A202020202020202020202020202020202020202022526567696F6E20776974686F757420427574746F6E7320616E64205469746C6573223A20225374616E64617264';
wwv_flow_api.g_varchar2_table(111) := '222C0A202020202020202020202020202020202020202022526567696F6E20776974686F7574205469746C65223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F72742046696C746572202D2053696E67';
wwv_flow_api.g_varchar2_table(112) := '6C6520526F77223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F7274204C697374223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F72747320526567';
wwv_flow_api.g_varchar2_table(113) := '696F6E202D2031303025205769647468223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F72747320526567696F6E202D2048656164696E6720496E73696465223A20225374616E64617264222C0A2020';
wwv_flow_api.g_varchar2_table(114) := '202020202020202020202020202020202020225265706F72747320526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020225363726F6C6C61626C6520436F6E74656E7420526567696F6E223A20225374';
wwv_flow_api.g_varchar2_table(115) := '616E64617264222C0A2020202020202020202020202020202020202020225365617263682046696C74657220526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020225369646562617220526567696F6E';
wwv_flow_api.g_varchar2_table(116) := '202D2048656164696E6720496E73696465223A20225374616E64617264222C0A2020202020202020202020202020202020202020225369646562617220526567696F6E223A20225374616E64617264222C0A202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(117) := '20202257697A61726420427574746F6E73223A2022427574746F6E7320436F6E7461696E6572222C0A20202020202020202020202020202020202020202257697A61726420526567696F6E20776974682049636F6E223A20225374616E64617264222C0A';
wwv_flow_api.g_varchar2_table(118) := '20202020202020202020202020202020202020202257697A61726420526567696F6E223A20225374616E64617264220A202020202020202020202020202020207D2C0A20202020202020202020202020202020225265706F7274223A207B0A2020202020';
wwv_flow_api.g_varchar2_table(119) := '20202020202020202020202020202022426F726465726C657373205265706F7274223A20225374616E64617264222C0A202020202020202020202020202020202020202022436F6D6D656E7420427562626C6573223A2022436F6D6D656E7473222C0A20';
wwv_flow_api.g_varchar2_table(120) := '202020202020202020202020202020202020202246697865642048656164657273223A20225374616E64617264222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C20426F72646572223A20225374616E64617264222C';
wwv_flow_api.g_varchar2_table(121) := '0A2020202020202020202020202020202020202020224F6E6520436F6C756D6E20556E6F726465726564204C697374223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202253656172636820526573756C747320';
wwv_flow_api.g_varchar2_table(122) := '5265706F7274202853454C454354206C696E6B5F746578742C206C696E6B5F7461726765742C2064657461696C312C2064657461696C322C206C6173745F6D6F64696669656429223A202253656172636820526573756C7473222C0A2020202020202020';
wwv_flow_api.g_varchar2_table(123) := '202020202020202020202020225374616E64617264202D20416C7465726E6174697665223A20225374616E64617264222C0A2020202020202020202020202020202020202020225374616E64617264223A20225374616E64617264222C0A202020202020';
wwv_flow_api.g_varchar2_table(124) := '20202020202020202020202020202254776F20436F6C756D6E20506F72746C6574223A202256616C756520417474726962757465205061697273202D20526F77222C0A20202020202020202020202020202020202020202256616C756520417474726962';
wwv_flow_api.g_varchar2_table(125) := '757465205061697273202D204C65667420416C69676E6564223A202256616C756520417474726962757465205061697273202D20436F6C756D6E222C0A20202020202020202020202020202020202020202256616C756520417474726962757465205061';
wwv_flow_api.g_varchar2_table(126) := '697273223A202256616C756520417474726962757465205061697273202D20436F6C756D6E220A202020202020202020202020202020207D0A2020202020202020202020207D0A20202020202020207D2C0A202020202020202032353A207B0A20202020';
wwv_flow_api.g_varchar2_table(127) := '2020202020202020746578743A20225468656D65203235202D20426C756520526573706F6E73697665222C0A202020202020202020202020696D6167653A202268747470733A2F2F617065782E6F7261636C652E636F6D2F706C732F617065782F617065';
wwv_flow_api.g_varchar2_table(128) := '785F706D2F722F34322F66696C65732F7374617469632F7638342F2F692F7468656D6532352E706E67222C0A2020202020202020202020206D617070696E67733A207B0A202020202020202020202020202020202242726561646372756D62223A207B0A';
wwv_flow_api.g_varchar2_table(129) := '20202020202020202020202020202020202020202242726561646372756D62204D656E75223A202242726561646372756D62220A202020202020202020202020202020207D2C0A2020202020202020202020202020202022427574746F6E223A207B0A20';
wwv_flow_api.g_varchar2_table(130) := '2020202020202020202020202020202020202022427574746F6E202D2049636F6E204F6E6C79223A2249636F6E222C0A202020202020202020202020202020202020202022427574746F6E202D2049636F6E223A225465787420776974682049636F6E22';
wwv_flow_api.g_varchar2_table(131) := '2C0A202020202020202020202020202020202020202022427574746F6E223A202254657874222C0A20202020202020202020202020202020202020202248544D4C20627574746F6E20286C6567616379202D20415045582035206D6967726174696F6E29';
wwv_flow_api.g_varchar2_table(132) := '223A202254657874222C0A2020202020202020202020202020202020202020224C6172676520427574746F6E202D2049636F6E204F6E6C79223A202254657874222C0A2020202020202020202020202020202020202020224C6172676520427574746F6E';
wwv_flow_api.g_varchar2_table(133) := '202D2049636F6E223A202249636F6E222C0A2020202020202020202020202020202020202020224C6172676520427574746F6E223A202249636F6E220A202020202020202020202020202020207D2C0A20202020202020202020202020202020224C6162';
wwv_flow_api.g_varchar2_table(134) := '656C223A207B0A20202020202020202020202020202020202020202248696464656E204C6162656C2028526561642062792053637265656E205265616465727329223A202248696464656E222C0A2020202020202020202020202020202020202020224F';
wwv_flow_api.g_varchar2_table(135) := '7074696F6E616C2028486F72697A6F6E74616C202D204C65667420416C69676E656429223A20224F7074696F6E616C222C0A2020202020202020202020202020202020202020224F7074696F6E616C2028486F72697A6F6E74616C202D20526967687420';
wwv_flow_api.g_varchar2_table(136) := '416C69676E656429223A20224F7074696F6E616C222C0A2020202020202020202020202020202020202020224F7074696F6E616C20284C6162656C2041626F766529223A20224F7074696F6E616C222C0A20202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(137) := '202252657175697265642028486F72697A6F6E74616C202D204C65667420416C69676E656429223A20224F7074696F6E616C222C0A20202020202020202020202020202020202020202252657175697265642028486F72697A6F6E74616C202D20526967';
wwv_flow_api.g_varchar2_table(138) := '687420416C69676E656429223A20224F7074696F6E616C222C0A202020202020202020202020202020202020202022526571756972656420284C6162656C2041626F766529223A20224F7074696F6E616C220A202020202020202020202020202020207D';
wwv_flow_api.g_varchar2_table(139) := '2C0A20202020202020202020202020202020224C65676163792043616C656E646172223A207B0A20202020202020202020202020202020202020202243616C656E646172223A202243616C656E646172220A202020202020202020202020202020207D2C';
wwv_flow_api.g_varchar2_table(140) := '0A20202020202020202020202020202020224C697374223A207B0A202020202020202020202020202020202020202022427574746F6E204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022466561';
wwv_flow_api.g_varchar2_table(141) := '7475726564204C69737420776974682053756274657874223A224D65646961204C697374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C20496D616765732077697468204C6162656C204C697374223A20224D6564';
wwv_flow_api.g_varchar2_table(142) := '6961204C697374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C204C696E6B73204C697374223A20224D65646961204C697374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C';
wwv_flow_api.g_varchar2_table(143) := '2057697A6172642050726F6772657373204C697374223A202257697A6172642050726F6772657373222C0A20202020202020202020202020202020202020202250616765204C6576656C2054616273204C697374223A2022546F70204E61766967617469';
wwv_flow_api.g_varchar2_table(144) := '6F6E204D656E75222C0A202020202020202020202020202020202020202022546162626564204E617669676174696F6E204C697374223A2254616273222C0A202020202020202020202020202020202020202022566572746963616C20496D6167657320';
wwv_flow_api.g_varchar2_table(145) := '4C697374223A20224D65646961204C697374222C0A202020202020202020202020202020202020202022566572746963616C204C6973742077697468205375627465787420616E642049636F6E223A224D65646961204C697374222C0A20202020202020';
wwv_flow_api.g_varchar2_table(146) := '2020202020202020202020202022566572746963616C204F726465726564204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022566572746963616C2053696465626172204C697374223A20224C69';
wwv_flow_api.g_varchar2_table(147) := '6E6B73204C697374222C0A202020202020202020202020202020202020202022566572746963616C20556E6F726465726564204C69737420776974682042756C6C657473223A20224C696E6B73204C697374222C0A202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(148) := '202020202022566572746963616C20556E6F726465726564204C69737420776974686F75742042756C6C657473223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202257697A6172642050726F6772657373204C';
wwv_flow_api.g_varchar2_table(149) := '697374202D20566572746963616C223A202257697A6172642050726F6772657373220A202020202020202020202020202020207D2C0A202020202020202020202020202020202250616765223A207B0A2020202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(150) := '224469616C6F67223A224D6F64616C204469616C6F67222C0A2020202020202020202020202020202020202020224C6F67696E223A20224C6F67696E222C0A2020202020202020202020202020202020202020224E6F2054616273202D204C6566742061';
wwv_flow_api.g_varchar2_table(151) := '6E642052696768742053696465626172223A224C65667420616E64205269676874205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224E6F2054616273202D204C6566742053696465626172223A20224C65667420';
wwv_flow_api.g_varchar2_table(152) := '5369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224E6F2054616273202D204E6F2053696465626172223A20225374616E64617264222C0A2020202020202020202020202020202020202020224E6F2054616273202D';
wwv_flow_api.g_varchar2_table(153) := '2052696768742053696465626172223A225269676874205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D20436F6E74656E74204672616D65223A20224D61737465722044';
wwv_flow_api.g_varchar2_table(154) := '657461696C222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C65667420616E642052696768742053696465626172223A20224C65667420616E64205269676874205369646520436F6C756D6E222C';
wwv_flow_api.g_varchar2_table(155) := '0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C6566742053696465626172223A20224C656674205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C';
wwv_flow_api.g_varchar2_table(156) := '6576656C2054616273202D204E6F2053696465626172223A20225374616E64617264222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D2052696768742053696465626172223A20225269676874205369';
wwv_flow_api.g_varchar2_table(157) := '646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D2057697A6172642050616765223A20225374616E64617264222C0A202020202020202020202020202020202020202022506F70';
wwv_flow_api.g_varchar2_table(158) := '7570223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A2020202020202020202020202020202020202020225072696E74657220467269656E646C79223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A20';
wwv_flow_api.g_varchar2_table(159) := '202020202020202020202020202020202020202254776F204C6576656C2054616273202D204C65667420616E642052696768742053696465626172223A20224C65667420616E64205269676874205369646520436F6C756D6E222C0A2020202020202020';
wwv_flow_api.g_varchar2_table(160) := '2020202020202020202020202254776F204C6576656C2054616273202D204C6566742053696465626172223A20224C656674205369646520436F6C756D6E222C0A20202020202020202020202020202020202020202254776F204C6576656C2054616273';
wwv_flow_api.g_varchar2_table(161) := '202D204E6F2053696465626172223A20225374616E64617264222C0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D2052696768742053696465626172223A20225269676874205369646520436F6C756D6E';
wwv_flow_api.g_varchar2_table(162) := '220A202020202020202020202020202020207D2C0A2020202020202020202020202020202022526567696F6E223A207B0A20202020202020202020202020202020202020202249525220526567696F6E2054656D706C617465223A2022496E7465726163';
wwv_flow_api.g_varchar2_table(163) := '74697665205265706F7274222C0A20202020202020202020202020202020202020202241636365737369626C6520526567696F6E20776974682048656164696E67223A20225374616E64617264222C0A2020202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(164) := '22416C65727420526567696F6E223A22416C657274222C0A202020202020202020202020202020202020202022426F726465726C65737320526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020224272';
wwv_flow_api.g_varchar2_table(165) := '6561646372756D6220526567696F6E223A20225469746C6520426172222C0A202020202020202020202020202020202020202022427574746F6E20526567696F6E2077697468205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A';
wwv_flow_api.g_varchar2_table(166) := '202020202020202020202020202020202020202022427574746F6E20526567696F6E20776974686F7574205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A202020202020202020202020202020202020202022436F6E74656E74';
wwv_flow_api.g_varchar2_table(167) := '204672616D6520426F647920436F6E7461696E6572223A2022426C616E6B20776974682041747472696275746573222C0A20202020202020202020202020202020202020202244495620526567696F6E2077697468204944223A2022426C616E6B207769';
wwv_flow_api.g_varchar2_table(168) := '74682041747472696275746573222C0A202020202020202020202020202020202020202022466F726D20526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020224869646520616E642053686F77205265';
wwv_flow_api.g_varchar2_table(169) := '67696F6E2028457870616E64656429223A2022436F6C6C61707369626C65222C0A2020202020202020202020202020202020202020224869646520616E642053686F7720526567696F6E202848696464656E29223A2022436F6C6C61707369626C65222C';
wwv_flow_api.g_varchar2_table(170) := '0A202020202020202020202020202020202020202022496E746572616374697665205265706F727420526567696F6E223A2022496E746572616374697665205265706F7274222C0A2020202020202020202020202020202020202020224D6F64616C2052';
wwv_flow_api.g_varchar2_table(171) := '6567696F6E223A22496E6C696E65204469616C6F67222C0A202020202020202020202020202020202020202022526567696F6E20776974686F757420427574746F6E7320616E64205469746C6573223A20225374616E64617264222C0A20202020202020';
wwv_flow_api.g_varchar2_table(172) := '20202020202020202020202020225369646562617220526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020225374616E6461726420526567696F6E202D204E6F2050616464696E67223A20225374616E';
wwv_flow_api.g_varchar2_table(173) := '64617264222C0A2020202020202020202020202020202020202020225374616E6461726420526567696F6E223A20225374616E64617264222C0A20202020202020202020202020202020202020202257697A61726420427574746F6E73223A2022427574';
wwv_flow_api.g_varchar2_table(174) := '746F6E7320436F6E7461696E6572220A202020202020202020202020202020207D2C0A20202020202020202020202020202020225265706F7274223A207B0A202020202020202020202020202020202020202022426F726465726C657373205265706F72';
wwv_flow_api.g_varchar2_table(175) := '74223A20225374616E64617264222C0A202020202020202020202020202020202020202022436F6D6D656E7420427562626C6573223A2022436F6D6D656E7473222C0A202020202020202020202020202020202020202022466978656420486561646572';
wwv_flow_api.g_varchar2_table(176) := '73223A20225374616E64617264222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C20426F72646572223A20225374616E64617264222C0A2020202020202020202020202020202020202020224F6E6520436F6C756D6E';
wwv_flow_api.g_varchar2_table(177) := '20556E6F726465726564204C697374223A224C696E6B73204C697374222C0A20202020202020202020202020202020202020202253656172636820526573756C7473205265706F7274202853454C454354206C696E6B5F746578742C206C696E6B5F7461';
wwv_flow_api.g_varchar2_table(178) := '726765742C2064657461696C312C2064657461696C322C206C6173745F6D6F64696669656429223A202253656172636820526573756C7473222C0A2020202020202020202020202020202020202020225374616E64617264202D20416C7465726E617469';
wwv_flow_api.g_varchar2_table(179) := '7665223A20225374616E64617264222C0A2020202020202020202020202020202020202020225374616E64617264223A20225374616E64617264222C0A20202020202020202020202020202020202020202254776F20436F6C756D6E20506F72746C6574';
wwv_flow_api.g_varchar2_table(180) := '223A202256616C756520417474726962757465205061697273202D20526F77222C0A20202020202020202020202020202020202020202256616C756520417474726962757465205061697273202D204C65667420416C69676E6564223A202256616C7565';
wwv_flow_api.g_varchar2_table(181) := '20417474726962757465205061697273202D20436F6C756D6E222C0A20202020202020202020202020202020202020202256616C756520417474726962757465205061697273223A202256616C756520417474726962757465205061697273202D20436F';
wwv_flow_api.g_varchar2_table(182) := '6C756D6E220A202020202020202020202020202020207D0A2020202020202020202020207D0A20202020202020207D2C0A202020202020202032343A207B0A202020202020202020202020746578743A20225468656D652032342D20436C6F756479222C';
wwv_flow_api.g_varchar2_table(183) := '0A202020202020202020202020696D6167653A202268747470733A2F2F617065782E6F7261636C652E636F6D2F706C732F617065782F617065785F706D2F722F34322F66696C65732F7374617469632F7638342F2F692F7468656D6532342E706E67222C';
wwv_flow_api.g_varchar2_table(184) := '0A2020202020202020202020206D617070696E67733A207B0A202020202020202020202020202020202242726561646372756D62223A207B0A20202020202020202020202020202020202020202242726561646372756D62204D656E75223A2022427265';
wwv_flow_api.g_varchar2_table(185) := '61646372756D62222C0A20202020202020202020202020202020202020202248696572617263686963616C204D656E75223A2242726561646372756D62220A202020202020202020202020202020207D2C0A202020202020202020202020202020202242';
wwv_flow_api.g_varchar2_table(186) := '7574746F6E223A207B0A2020202020202020202020202020202020202020225B202B205D2041646420427574746F6E223A2249636F6E222C0A2020202020202020202020202020202020202020225B2054657874205D20427574746F6E223A2254657874';
wwv_flow_api.g_varchar2_table(187) := '222C0A202020202020202020202020202020202020202022427574746F6E223A202254657874222C0A20202020202020202020202020202020202020202248544D4C20627574746F6E20286C6567616379202D20415045582035206D6967726174696F6E';
wwv_flow_api.g_varchar2_table(188) := '29223A202254657874222C0A202020202020202020202020202020202020202022496E746572616374697665205265706F727420427574746F6E223A202254657874222C0A2020202020202020202020202020202020202020224C617267652042757474';
wwv_flow_api.g_varchar2_table(189) := '6F6E223A202254657874222C0A202020202020202020202020202020202020202022536D616C6C20427574746F6E223A202254657874220A202020202020202020202020202020207D2C0A20202020202020202020202020202020224C6162656C223A20';
wwv_flow_api.g_varchar2_table(190) := '7B0A2020202020202020202020202020202020202020224C6162656C2048696464656E206C6162656C2C20726561642062792073637265656E20726561646572223A2248696464656E222C0A2020202020202020202020202020202020202020224E6F20';
wwv_flow_api.g_varchar2_table(191) := '4C6162656C223A202248696464656E222C0A2020202020202020202020202020202020202020224F7074696F6E616C20776974682068656C70223A20224F7074696F6E616C222C0A2020202020202020202020202020202020202020224F7074696F6E61';
wwv_flow_api.g_varchar2_table(192) := '6C223A20224F7074696F6E616C222C0A202020202020202020202020202020202020202022526571756972656420776974682068656C70223A20225265717569726564222C0A202020202020202020202020202020202020202022526571756972656422';
wwv_flow_api.g_varchar2_table(193) := '3A20225265717569726564220A202020202020202020202020202020207D2C0A20202020202020202020202020202020224C65676163792043616C656E646172223A207B0A20202020202020202020202020202020202020202243616C656E646172202D';
wwv_flow_api.g_varchar2_table(194) := '20416C7465726E6174697665223A202243616C656E646172222C0A20202020202020202020202020202020202020202243616C656E646172223A202243616C656E646172222C0A202020202020202020202020202020202020202022536D616C6C204361';
wwv_flow_api.g_varchar2_table(195) := '6C656E646172223A202243616C656E646172220A202020202020202020202020202020207D2C0A20202020202020202020202020202020224C697374223A207B0A202020202020202020202020202020202020202022427574746F6E204C697374223A20';
wwv_flow_api.g_varchar2_table(196) := '224C696E6B73204C697374222C0A2020202020202020202020202020202020202020224448544D4C2054726565223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202248696572617263686963616C2045787061';
wwv_flow_api.g_varchar2_table(197) := '6E64696E67223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C20496D616765732077697468204C6162656C204C697374223A20224D65646961204C697374222C0A20202020202020';
wwv_flow_api.g_varchar2_table(198) := '2020202020202020202020202022486F72697A6F6E74616C204C696E6B73204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C2057697A6172642050726F677265737320';
wwv_flow_api.g_varchar2_table(199) := '4C697374223A202257697A6172642050726F6772657373222C0A20202020202020202020202020202020202020202250616765204C6576656C2054616273204C697374223A22546F70204E617669676174696F6E204D656E75222C0A2020202020202020';
wwv_flow_api.g_varchar2_table(200) := '2020202020202020202020202250756C6C20446F776E204D656E75207769746820496D616765223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202250756C6C20446F776E204D656E75223A20224C696E6B7320';
wwv_flow_api.g_varchar2_table(201) := '4C697374222C0A202020202020202020202020202020202020202022546162626564204E617669676174696F6E204C697374223A202254616273222C0A202020202020202020202020202020202020202022566572746963616C20496D61676573204C69';
wwv_flow_api.g_varchar2_table(202) := '7374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022566572746963616C204C6973742077697468205375627465787420616E642049636F6E223A224D65646961204C697374222C0A202020202020202020';
wwv_flow_api.g_varchar2_table(203) := '202020202020202020202022566572746963616C204F726465726564204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022566572746963616C2053696465626172204C697374223A20224C696E6B';
wwv_flow_api.g_varchar2_table(204) := '73204C697374222C0A202020202020202020202020202020202020202022566572746963616C20556E6F726465726564204C69737420776974682042756C6C657473223A20224C696E6B73204C697374222C0A2020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(205) := '20202022566572746963616C20556E6F726465726564204C69737420776974686F75742042756C6C657473223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202257697A6172642050726F6772657373204C6973';
wwv_flow_api.g_varchar2_table(206) := '74202D20566572746963616C223A202257697A6172642050726F6772657373220A202020202020202020202020202020207D2C0A202020202020202020202020202020202250616765223A207B0A20202020202020202020202020202020202020202244';
wwv_flow_api.g_varchar2_table(207) := '69616C6F67223A224D6F64616C204469616C6F67222C0A2020202020202020202020202020202020202020224C6F67696E223A20224C6F67696E222C0A2020202020202020202020202020202020202020224E6F2054616273202D204C65667420616E64';
wwv_flow_api.g_varchar2_table(208) := '2052696768742053696465626172223A224C65667420616E64205269676874205369646520436F6C756D6E73222C0A2020202020202020202020202020202020202020224E6F2054616273202D204C6566742053696465626172223A20224C6566742053';
wwv_flow_api.g_varchar2_table(209) := '69646520436F6C756D6E222C0A2020202020202020202020202020202020202020224E6F2054616273202D204E6F2053696465626172223A20225374616E64617264222C0A2020202020202020202020202020202020202020224E6F2054616273202D20';
wwv_flow_api.g_varchar2_table(210) := '52696768742053696465626172223A20225269676874205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D20436F6E74656E74204672616D65223A224D6173746572204465';
wwv_flow_api.g_varchar2_table(211) := '7461696C222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C65667420616E642052696768742053696465626172223A20224C65667420616E64205269676874205369646520436F6C756D6E73222C';
wwv_flow_api.g_varchar2_table(212) := '0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C6566742053696465626172223A20224C656674205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C';
wwv_flow_api.g_varchar2_table(213) := '6576656C2054616273202D2052696768742053696465626172223A20225269676874205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D2057697A6172642050616765223A';
wwv_flow_api.g_varchar2_table(214) := '225374616E64617264222C0A202020202020202020202020202020202020202022506F707570223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A2020202020202020202020202020202020202020225072696E74657220467269';
wwv_flow_api.g_varchar2_table(215) := '656E646C79223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D204C65667420616E642052696768742053696465626172223A224C65';
wwv_flow_api.g_varchar2_table(216) := '667420616E64205269676874205369646520436F6C756D6E73222C0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D204C6566742053696465626172223A20224C656674205369646520436F6C756D6E222C';
wwv_flow_api.g_varchar2_table(217) := '0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D204E6F2053696465626172223A20225374616E64617264222C0A20202020202020202020202020202020202020202254776F204C6576656C205461627320';
wwv_flow_api.g_varchar2_table(218) := '2D2052696768742053696465626172223A20225269676874205369646520436F6C756D6E220A202020202020202020202020202020207D2C0A2020202020202020202020202020202022526567696F6E223A207B0A202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(219) := '20202020202249525220526567696F6E2054656D706C617465223A2022496E746572616374697665205265706F7274222C0A202020202020202020202020202020202020202022416C65727420526567696F6E223A22416C657274222C0A202020202020';
wwv_flow_api.g_varchar2_table(220) := '202020202020202020202020202022426F726465726C65737320526567696F6E223A20225374616E64617264222C0A202020202020202020202020202020202020202022427261636B6574656420526567696F6E223A20225374616E64617264222C0A20';
wwv_flow_api.g_varchar2_table(221) := '202020202020202020202020202020202020202242726561646372756D6220526567696F6E223A20225469746C6520426172222C0A202020202020202020202020202020202020202022427574746F6E20526567696F6E2077697468205469746C65223A';
wwv_flow_api.g_varchar2_table(222) := '2022427574746F6E7320436F6E7461696E6572222C0A202020202020202020202020202020202020202022427574746F6E20526567696F6E20776974686F7574205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A202020202020';
wwv_flow_api.g_varchar2_table(223) := '2020202020202020202020202020224368617274204C697374223A20225374616E64617264222C0A202020202020202020202020202020202020202022436861727420526567696F6E223A20225374616E64617264222C0A202020202020202020202020';
wwv_flow_api.g_varchar2_table(224) := '202020202020202022436F6E74656E74204672616D6520426F647920436F6E7461696E6572223A22426C616E6B20776974682041747472696275746573222C0A20202020202020202020202020202020202020202244495620526567696F6E2077697468';
wwv_flow_api.g_varchar2_table(225) := '204944223A22426C616E6B20776974682041747472696275746573222C0A202020202020202020202020202020202020202022466F726D20526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020224869';
wwv_flow_api.g_varchar2_table(226) := '646520616E642053686F7720526567696F6E202848696464656E20466972737429202D20426F726465726C657373223A22436F6C6C61707369626C65222C0A2020202020202020202020202020202020202020224869646520616E642053686F77205265';
wwv_flow_api.g_varchar2_table(227) := '67696F6E202D20426F726465726C657373223A2022436F6C6C61707369626C65222C0A2020202020202020202020202020202020202020224869646520616E642053686F7720526567696F6E223A2022436F6C6C61707369626C65222C0A202020202020';
wwv_flow_api.g_varchar2_table(228) := '2020202020202020202020202020226A5175657279204D6F64616C20526567696F6E2054656D706C617465223A22496E6C696E65204469616C6F67222C0A2020202020202020202020202020202020202020224C6F67696E20526567696F6E223A224C6F';
wwv_flow_api.g_varchar2_table(229) := '67696E222C0A2020202020202020202020202020202020202020224D6F64616C20526567696F6E223A22496E6C696E65204469616C6F67222C0A2020202020202020202020202020202020202020224E617669676174696F6E20526567696F6E202D2048';
wwv_flow_api.g_varchar2_table(230) := '656164696E6720496E73696465223A20225374616E64617264222C0A2020202020202020202020202020202020202020224E617669676174696F6E20526567696F6E223A20225374616E64617264222C0A20202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(231) := '2022526567696F6E20776974686F757420427574746F6E7320616E64205469746C6573223A20225374616E64617264222C0A202020202020202020202020202020202020202022526567696F6E20776974686F7574205469746C65223A20225374616E64';
wwv_flow_api.g_varchar2_table(232) := '617264222C0A2020202020202020202020202020202020202020225265706F72742046696C746572202D2053696E676C6520526F77223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F7274204C697374';
wwv_flow_api.g_varchar2_table(233) := '223A225374616E64617264222C0A2020202020202020202020202020202020202020225265706F72747320526567696F6E202D2031303025205769647468223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265';
wwv_flow_api.g_varchar2_table(234) := '706F72747320526567696F6E202D2048656164696E6720496E73696465223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F72747320526567696F6E223A20225374616E64617264222C0A202020202020';
wwv_flow_api.g_varchar2_table(235) := '2020202020202020202020202020225363726F6C6C61626C6520436F6E74656E7420526567696F6E223A225374616E64617264222C0A2020202020202020202020202020202020202020225365617263682046696C74657220526567696F6E223A225374';
wwv_flow_api.g_varchar2_table(236) := '616E64617264222C0A2020202020202020202020202020202020202020225369646562617220526567696F6E202D2048656164696E6720496E73696465223A20225374616E64617264222C0A202020202020202020202020202020202020202022536964';
wwv_flow_api.g_varchar2_table(237) := '6562617220526567696F6E223A20225374616E64617264222C0A20202020202020202020202020202020202020202257697A61726420427574746F6E73223A22427574746F6E7320436F6E7461696E6572222C0A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(238) := '202020202257697A61726420526567696F6E20776974682049636F6E223A20225374616E64617264222C0A20202020202020202020202020202020202020202257697A61726420526567696F6E223A20225374616E64617264220A202020202020202020';
wwv_flow_api.g_varchar2_table(239) := '202020202020207D2C0A20202020202020202020202020202020225265706F7274223A207B0A202020202020202020202020202020202020202022426F726465726C657373205265706F7274223A20225374616E64617264222C0A202020202020202020';
wwv_flow_api.g_varchar2_table(240) := '202020202020202020202022436F6D6D656E7420427562626C6573223A22436F6D6D656E7473222C0A20202020202020202020202020202020202020202246697865642048656164657273223A20225374616E64617264222C0A20202020202020202020';
wwv_flow_api.g_varchar2_table(241) := '2020202020202020202022486F72697A6F6E74616C20426F72646572223A20225374616E64617264222C0A2020202020202020202020202020202020202020224F6E6520436F6C756D6E20556E6F726465726564204C697374223A224C696E6B73204C69';
wwv_flow_api.g_varchar2_table(242) := '7374222C0A20202020202020202020202020202020202020202253656172636820526573756C7473205265706F7274202853454C454354206C696E6B5F746578742C206C696E6B5F7461726765742C2064657461696C312C2064657461696C322C206C61';
wwv_flow_api.g_varchar2_table(243) := '73745F6D6F64696669656429223A202253656172636820526573756C7473222C0A2020202020202020202020202020202020202020225374616E64617264202D20416C7465726E6174697665223A20225374616E64617264222C0A202020202020202020';
wwv_flow_api.g_varchar2_table(244) := '2020202020202020202020225374616E64617264223A20225374616E64617264222C0A20202020202020202020202020202020202020202254776F20436F6C756D6E20506F72746C6574223A202256616C75652041747472696275746520506169727320';
wwv_flow_api.g_varchar2_table(245) := '2D20526F77222C0A20202020202020202020202020202020202020202256616C756520417474726962757465205061697273202D204C65667420416C69676E6564223A2256616C756520417474726962757465205061697273202D20436F6C756D6E222C';
wwv_flow_api.g_varchar2_table(246) := '0A20202020202020202020202020202020202020202256616C756520417474726962757465205061697273223A202256616C756520417474726962757465205061697273202D20436F6C756D6E220A202020202020202020202020202020207D0A202020';
wwv_flow_api.g_varchar2_table(247) := '2020202020202020207D0A20202020202020207D2C0A202020202020202032333A207B0A202020202020202020202020746578743A20225468656D65203233202D204372696D736F6E222C0A202020202020202020202020696D6167653A202268747470';
wwv_flow_api.g_varchar2_table(248) := '733A2F2F617065782E6F7261636C652E636F6D2F706C732F617065782F617065785F706D2F722F34322F66696C65732F7374617469632F7638342F2F692F7468656D6532332E706E67222C0A2020202020202020202020206D617070696E67733A207B0A';
wwv_flow_api.g_varchar2_table(249) := '202020202020202020202020202020202242726561646372756D62223A207B0A20202020202020202020202020202020202020202242726561646372756D62204D656E75223A202242726561646372756D62220A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(250) := '7D2C0A2020202020202020202020202020202022427574746F6E223A207B0A2020202020202020202020202020202020202020224C6172676520427574746F6E223A202254657874222C0A202020202020202020202020202020202020202022536D616C';
wwv_flow_api.g_varchar2_table(251) := '6C20427574746F6E223A202254657874222C0A202020202020202020202020202020202020202022427574746F6E223A202254657874222C0A202020202020202020202020202020202020202022496E746572616374697665205265706F727420427574';
wwv_flow_api.g_varchar2_table(252) := '746F6E223A202254657874222C0A20202020202020202020202020202020202020202248544D4C20627574746F6E20286C6567616379202D20415045582035206D6967726174696F6E29223A202254657874220A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(253) := '7D2C0A20202020202020202020202020202020224C6162656C223A207B0A2020202020202020202020202020202020202020224F7074696F6E616C20776974682068656C70223A20224F7074696F6E616C222C0A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(254) := '20202020224F7074696F6E616C223A20224F7074696F6E616C222C0A2020202020202020202020202020202020202020225265717569726564223A20225265717569726564222C0A2020202020202020202020202020202020202020224E6F204C616265';
wwv_flow_api.g_varchar2_table(255) := '6C223A202248696464656E222C0A202020202020202020202020202020202020202022526571756972656420776974682068656C70223A20225265717569726564220A202020202020202020202020202020207D2C0A2020202020202020202020202020';
wwv_flow_api.g_varchar2_table(256) := '2020224C65676163792043616C656E646172223A207B0A20202020202020202020202020202020202020202243616C656E646172223A202243616C656E646172222C0A202020202020202020202020202020202020202022536D616C6C2043616C656E64';
wwv_flow_api.g_varchar2_table(257) := '6172223A202243616C656E646172222C0A20202020202020202020202020202020202020202243616C656E646172202D20416C7465726E6174697665223A202243616C656E646172220A202020202020202020202020202020207D2C0A20202020202020';
wwv_flow_api.g_varchar2_table(258) := '202020202020202020224C697374223A207B0A202020202020202020202020202020202020202022486F72697A6F6E74616C2057697A6172642050726F6772657373204C697374223A202257697A6172642050726F6772657373222C0A20202020202020';
wwv_flow_api.g_varchar2_table(259) := '2020202020202020202020202022566572746963616C204F726465726564204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022566572746963616C2053696465626172204C697374223A20224C69';
wwv_flow_api.g_varchar2_table(260) := '6E6B73204C697374222C0A20202020202020202020202020202020202020202257697A6172642050726F6772657373204C697374202D20566572746963616C223A202257697A6172642050726F6772657373222C0A202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(261) := '202020202022566572746963616C20556E6F726465726564204C69737420776974682042756C6C657473223A20224C696E6B73204C697374222C0A2020202020202020202020202020202020202020224448544D4C2054726565223A20224C696E6B7320';
wwv_flow_api.g_varchar2_table(262) := '4C697374222C0A20202020202020202020202020202020202020202248696572617263686963616C20457870616E64696E67223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202250756C6C20446F776E204D65';
wwv_flow_api.g_varchar2_table(263) := '6E75207769746820496D616765223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022427574746F6E204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022';
wwv_flow_api.g_varchar2_table(264) := '50616765204C6576656C2054616273204C697374223A2022546F70204E617669676174696F6E204D656E75222C0A202020202020202020202020202020202020202022546162626564204E617669676174696F6E204C697374223A202254616273222C0A';
wwv_flow_api.g_varchar2_table(265) := '202020202020202020202020202020202020202022566572746963616C20556E6F726465726564204C69737420776974686F75742042756C6C657473223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022486F';
wwv_flow_api.g_varchar2_table(266) := '72697A6F6E74616C204C696E6B73204C697374223A20224C696E6B73204C697374222C0A20202020202020202020202020202020202020202250756C6C20446F776E204D656E75223A20224C696E6B73204C697374222C0A202020202020202020202020';
wwv_flow_api.g_varchar2_table(267) := '202020202020202022566572746963616C20496D61676573204C697374223A20224C696E6B73204C697374222C0A202020202020202020202020202020202020202022486F72697A6F6E74616C20496D616765732077697468204C6162656C204C697374';
wwv_flow_api.g_varchar2_table(268) := '223A20224D65646961204C697374220A202020202020202020202020202020207D2C0A202020202020202020202020202020202250616765223A207B0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D204C';
wwv_flow_api.g_varchar2_table(269) := '6566742053696465626172223A20224C656674205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224E6F2054616273202D204E6F2053696465626172223A20225374616E64617264222C0A20202020202020202020';
wwv_flow_api.g_varchar2_table(270) := '20202020202020202020225072696E74657220467269656E646C79223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A2020202020202020202020202020202020202020224C6F67696E223A20224C6F67696E222C0A2020202020';
wwv_flow_api.g_varchar2_table(271) := '20202020202020202020202020202022506F707570223A20224D696E696D616C20284E6F204E617669676174696F6E29222C0A20202020202020202020202020202020202020202254776F204C6576656C2054616273202D205269676874205369646562';
wwv_flow_api.g_varchar2_table(272) := '6172223A20225269676874205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224E6F2054616273202D2052696768742053696465626172223A20225269676874205369646520436F6C756D6E222C0A202020202020';
wwv_flow_api.g_varchar2_table(273) := '2020202020202020202020202020224E6F2054616273202D204C6566742053696465626172223A20224C656674205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C65';
wwv_flow_api.g_varchar2_table(274) := '66742053696465626172223A20224C656674205369646520436F6C756D6E222C0A2020202020202020202020202020202020202020224F6E65204C6576656C2054616273202D204C65667420616E642052696768742053696465626172223A20224C6566';
wwv_flow_api.g_varchar2_table(275) := '7420616E64205269676874205369646520436F6C756D6E73220A202020202020202020202020202020207D2C0A2020202020202020202020202020202022526567696F6E223A207B0A202020202020202020202020202020202020202022495252205265';
wwv_flow_api.g_varchar2_table(276) := '67696F6E2054656D706C617465223A2022496E746572616374697665205265706F7274222C0A202020202020202020202020202020202020202022427574746F6E20526567696F6E2077697468205469746C65223A2022427574746F6E7320436F6E7461';
wwv_flow_api.g_varchar2_table(277) := '696E6572222C0A2020202020202020202020202020202020202020225265706F72747320526567696F6E202D2048656164696E6720496E73696465223A20225374616E64617264222C0A2020202020202020202020202020202020202020224E61766967';
wwv_flow_api.g_varchar2_table(278) := '6174696F6E20526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F72742046696C746572202D2053696E676C6520526F77223A20225374616E64617264222C0A2020202020202020202020';
wwv_flow_api.g_varchar2_table(279) := '20202020202020202022427261636B6574656420526567696F6E223A20225374616E64617264222C0A202020202020202020202020202020202020202022436861727420526567696F6E223A20225374616E64617264222C0A2020202020202020202020';
wwv_flow_api.g_varchar2_table(280) := '202020202020202020224E617669676174696F6E20526567696F6E202D2048656164696E6720496E73696465223A20225374616E64617264222C0A202020202020202020202020202020202020202022466F726D20526567696F6E223A20225374616E64';
wwv_flow_api.g_varchar2_table(281) := '617264222C0A202020202020202020202020202020202020202022526567696F6E20776974686F7574205469746C65223A20225374616E64617264222C0A202020202020202020202020202020202020202022526567696F6E20776974686F7574204275';
wwv_flow_api.g_varchar2_table(282) := '74746F6E7320616E64205469746C6573223A20225374616E64617264222C0A20202020202020202020202020202020202020202257697A61726420526567696F6E20776974682049636F6E223A20225374616E64617264222C0A20202020202020202020';
wwv_flow_api.g_varchar2_table(283) := '20202020202020202020225369646562617220526567696F6E202D2048656164696E6720496E73696465223A20225374616E64617264222C0A2020202020202020202020202020202020202020225265706F72747320526567696F6E223A20225374616E';
wwv_flow_api.g_varchar2_table(284) := '64617264222C0A2020202020202020202020202020202020202020224869646520616E642053686F7720526567696F6E202848696464656E20466972737429223A2022436F6C6C61707369626C65222C0A20202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(285) := '2022426F726465726C65737320526567696F6E223A20225374616E64617264222C0A2020202020202020202020202020202020202020224368617274204C697374223A20225374616E64617264222C0A2020202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(286) := '224869646520616E642053686F7720526567696F6E202D20426F726465726C657373223A2022436F6C6C61707369626C65222C0A20202020202020202020202020202020202020202242726561646372756D6220526567696F6E223A20225469746C6520';
wwv_flow_api.g_varchar2_table(287) := '426172222C0A20202020202020202020202020202020202020202257697A61726420526567696F6E223A202257697A61726420436F6E7461696E6572222C0A2020202020202020202020202020202020202020225369646562617220526567696F6E223A';
wwv_flow_api.g_varchar2_table(288) := '20225374616E64617264222C0A2020202020202020202020202020202020202020224869646520616E642053686F7720526567696F6E223A2022436F6C6C61707369626C65222C0A202020202020202020202020202020202020202022427574746F6E20';
wwv_flow_api.g_varchar2_table(289) := '526567696F6E20776974686F7574205469746C65223A2022427574746F6E7320436F6E7461696E6572222C0A2020202020202020202020202020202020202020225265706F72747320526567696F6E202D2031303025205769647468223A20225374616E';
wwv_flow_api.g_varchar2_table(290) := '64617264220A202020202020202020202020202020207D2C0A20202020202020202020202020202020225265706F7274223A207B0A20202020202020202020202020202020202020202254776F20436F6C756D6E20506F72746C6574223A202256616C75';
wwv_flow_api.g_varchar2_table(291) := '6520417474726962757465205061697273202D20526F77222C0A20202020202020202020202020202020202020202246697865642048656164657273223A20225374616E64617264222C0A202020202020202020202020202020202020202022486F7269';
wwv_flow_api.g_varchar2_table(292) := '7A6F6E74616C20426F72646572223A20225374616E64617264222C0A20202020202020202020202020202020202020202253656172636820526573756C7473205265706F7274202853454C454354206C696E6B5F746578742C206C696E6B5F7461726765';
wwv_flow_api.g_varchar2_table(293) := '742C2064657461696C312C2064657461696C322C206C6173745F6D6F64696669656429223A202253656172636820526573756C7473222C0A20202020202020202020202020202020202020202256616C756520417474726962757465205061697273223A';
wwv_flow_api.g_varchar2_table(294) := '202256616C756520417474726962757465205061697273202D20436F6C756D6E222C0A2020202020202020202020202020202020202020225374616E64617264223A20225374616E64617264222C0A202020202020202020202020202020202020202022';
wwv_flow_api.g_varchar2_table(295) := '5374616E64617264202D20416C7465726E6174697665223A20225374616E64617264222C0A202020202020202020202020202020202020202022426F726465726C657373205265706F7274223A20225374616E64617264220A2020202020202020202020';
wwv_flow_api.g_varchar2_table(296) := '20202020207D0A2020202020202020202020207D0A20202020202020207D2C0A202020202020202032323A207B0A202020202020202020202020696D6167653A202268747470733A2F2F617065782E6F7261636C652E636F6D2F706C732F617065782F61';
wwv_flow_api.g_varchar2_table(297) := '7065785F706D2F722F34322F66696C65732F7374617469632F7638342F2F692F7468656D6532322E706E67222C0A202020202020202020202020746578743A20225468656D652032322D20426C7565204A6179222C0A2020202020202020202020206D61';
wwv_flow_api.g_varchar2_table(298) := '7070696E67733A207468656D653231416E645468656D6532324D617070696E670A20202020202020207D2C0A202020202020202032313A207B0A202020202020202020202020746578743A20225468656D65203231202D20536361726C6574222C0A2020';
wwv_flow_api.g_varchar2_table(299) := '20202020202020202020696D6167653A202268747470733A2F2F617065782E6F7261636C652E636F6D2F706C732F617065782F617065785F706D2F722F34322F66696C65732F7374617469632F7638342F2F692F7468656D6532312E706E67222C0A2020';
wwv_flow_api.g_varchar2_table(300) := '202020202020202020206D617070696E67733A207468656D653231416E645468656D6532324D617070696E670A20202020202020207D0A202020207D3B0A0A0A202020202F2A2A0A20202020202A20426F6F6B6D61726B6C657420636F64652073746172';
wwv_flow_api.g_varchar2_table(301) := '747320686572652E0A20202020202A2F0A20202020766172206469616C6F67446976243B0A20202020766172206469616C6F67203D2066756E6374696F6E28207469746C652C206D6573736167652C206578747261436F6E74656E74242C20627574746F';
wwv_flow_api.g_varchar2_table(302) := '6E732029207B0A20202020202020206966202821627574746F6E7329207B0A202020202020202020202020627574746F6E73203D20207B0A202020202020202020202020202020202243616E63656C223A2066756E6374696F6E2829207B0A2020202020';
wwv_flow_api.g_varchar2_table(303) := '2020202020202020202020202020202428207468697320292E6469616C6F67282022636C6F73652220293B0A202020202020202020202020202020207D0A2020202020202020202020207D0A20202020202020207D0A0A2020202020202020766172206F';
wwv_flow_api.g_varchar2_table(304) := '6B427574746F6E24203D202428273C627574746F6E20636C6173733D22612D427574746F6E20612D427574746F6E20612D427574746F6E2D2D7061644C656674223E4F6B61793C2F627574746F6E3E27293B0A20202020202020206469616C6F67446976';
wwv_flow_api.g_varchar2_table(305) := '242E6469616C6F6728226F7074696F6E222C20227469746C65222C207469746C65292E6469616C6F6728226F7074696F6E222C2022627574746F6E73222C20627574746F6E73293B0A20202020202020206469616C6F67446976242E68746D6C28223C64';
wwv_flow_api.g_varchar2_table(306) := '6976207374796C653D2770616464696E673A323070783B273E22202B206D657373616765202B2020223C2F6469763E22293B0A20202020202020206469616C6F67446976242E6368696C6472656E28292E666972737428292E617070656E642820657874';
wwv_flow_api.g_varchar2_table(307) := '7261436F6E74656E742420293B0A20202020202020206469616C6F67446976242E6469616C6F6728226F70656E22293B0A202020207D3B0A0A202020207661722063686F6F73655468656D65546F5772697465203D2066756E6374696F6E28207468656D';
wwv_flow_api.g_varchar2_table(308) := '654E756D6265722029207B0A2020202020202020766172206C69737424203D202428273C756C20636C6173733D22612D49636F6E4C6973742D2D77697A61726420612D49636F6E4C6973742220726F6C653D226C697374626F78223E3C2F756C3E27293B';
wwv_flow_api.g_varchar2_table(309) := '0A2020202020202020666F722028766172206B657920696E20737570706F727465645468656D657329207B0A2020202020202020202020202866756E6374696F6E2829207B0A20202020202020202020202020202020766172207468656D65546F577269';
wwv_flow_api.g_varchar2_table(310) := '74654B6579203D206B65793B0A20202020202020202020202020202020766172206974656D24203D20202428273C6C6920636C6173733D2277697A6172642D73656C656374696F6E20612D49636F6E4C6973742D6974656D2075742D6D6967726174696F';
wwv_flow_api.g_varchar2_table(311) := '6E2D68656C7065722220726F6C653D226F7074696F6E2220746162696E6465783D2230223E3C2F6C693E27293B0A20202020202020202020202020202020766172207468656D65546F5772697465203D206765745468656D65546F577269746528207468';
wwv_flow_api.g_varchar2_table(312) := '656D65546F57726974654B657920293B0A202020202020202020202020202020206974656D242E617070656E6428273C6469763E3C696D67207372633D2227202B207468656D65546F57726974652E696D616765202B202722202F3E3C2F6469763E2729';
wwv_flow_api.g_varchar2_table(313) := '3B0A202020202020202020202020202020206974656D242E617070656E6428273C7370616E20636C6173733D22612D49636F6E4C6973742D69636F6E4E616D65223E27202B207468656D65546F57726974652E74657874202B273C2F7370616E3E27293B';
wwv_flow_api.g_varchar2_table(314) := '0A202020202020202020202020202020206974656D242E636C69636B2866756E6374696F6E2829207B0A20202020202020202020202020202020202020206469616C6F67446976242E6469616C6F672822636C6F736522293B0A20202020202020202020';
wwv_flow_api.g_varchar2_table(315) := '202020202020202020206170657854656D706C61746548656C7065722E777269746528207468656D65546F577269746520293B0A202020202020202020202020202020207D293B0A202020202020202020202020202020206C697374242E617070656E64';
wwv_flow_api.g_varchar2_table(316) := '286974656D24293B0A2020202020202020202020207D2928293B0A20202020202020207D0A20202020202020206469616C6F67280A2020202020202020202020202253656C656374207468652062617365207468656D65206E756D626572222C0A202020';
wwv_flow_api.g_varchar2_table(317) := '2020202020202020202254686520626F6F6B6D61726B6C657420697320636F6D70617469626C65207769746820612066657720276261736527207468656D65732E2022202B0A2020202020202020202020202253656C65637420746865206F6E65207468';
wwv_flow_api.g_varchar2_table(318) := '61742062657374206D61746368657320796F7572732062656C6F7720746F206170706C792074686520636F7272656374207468656D65206D617070696E6720222C0A2020202020202020202020206C697374242C0A202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(319) := '207B7D293B0A202020207D3B0A0A20202020696620282177696E646F772E75744D6967726174696F6E53637269707441637469766529207B0A20202020202020202428226865616422292E617070656E6428223C7374796C653E22202B0A202020202020';
wwv_flow_api.g_varchar2_table(320) := '202020202020222E7468656D652D6D6967726174696F6E2D2D69732D75706461746564207B206261636B67726F756E642D636F6C6F723A20234341463743373B207D2022202B0A202020202020202020202020222E7468656D652D6D6967726174696F6E';
wwv_flow_api.g_varchar2_table(321) := '2D2D69732D6572726F72207B206261636B67726F756E642D636F6C6F723A20234644453541343B207D22202B0A202020202020202020202020222E75742D6D6967726174696F6E2D68656C70657220646976207B2077696474683A20393070783B206865';
wwv_flow_api.g_varchar2_table(322) := '696768743A20363070783B206F766572666C6F773A68696464656E3B206D617267696E3A206175746F3B207D22202B0A202020202020202020202020222E75742D6D6967726174696F6E2D68656C70657220696D67207B2077696474683A203238307078';
wwv_flow_api.g_varchar2_table(323) := '3B206865696768743A2031323070783B206D617267696E2D746F703A202D313070783B207D22202B0A202020202020202020202020222E75742D6D6967726174696F6E2D68656C706572207B20746578742D616C69676E3A63656E7465723B20626F7264';
wwv_flow_api.g_varchar2_table(324) := '65723A20317078207768697465736D6F6B6520736F6C69643B20626F726465722D7261646975733A203270783B207D2022202B0A202020202020202020202020222E75742D6D6967726174696F6E2D68656C706572202E612D49636F6E4C6973742D6963';
wwv_flow_api.g_varchar2_table(325) := '6F6E4E616D65207B206865696768743A20353070783B20646973706C61793A696E6C696E652D626C6F636B3B206D617267696E2D746F703A3570783B207D22202B0A2020202020202020223C2F7374796C653E22293B0A202020202020202077696E646F';
wwv_flow_api.g_varchar2_table(326) := '772E75744D6967726174696F6E44697624203D206469616C6F6744697624203D202428223C6469763E22293B0A2020202020202020242822626F647922292E617070656E64286469616C6F6744697624293B0A2020202020202020617065782E7468656D';
wwv_flow_api.g_varchar2_table(327) := '652E696E6974526573706F6E736976654469616C6F677328293B0A20202020202020206469616C6F67446976242E6469616C6F67280A2020202020202020202020207B0A202020202020202020202020202020206175746F4F70656E3A2066616C73652C';
wwv_flow_api.g_varchar2_table(328) := '0A202020202020202020202020202020206D696E57696474683A203530302C0A202020202020202020202020202020202F2F6D696E4865696768743A203330302C0A20202020202020202020202020202020636C6F7365546578743A20224F6B220A2020';
wwv_flow_api.g_varchar2_table(329) := '202020202020202020207D293B0A202020207D20656C7365207B0A20202020202020206469616C6F6744697624203D2077696E646F772E75744D6967726174696F6E446976243B0A202020207D0A2020202077696E646F772E75744D6967726174696F6E';
wwv_flow_api.g_varchar2_table(330) := '536372697074416374697665203D20747275653B0A0A20202020766172206170657854656D706C61746548656C706572203D202866756E6374696F6E2829207B0A2020202020202020766172206275696C6450616765526570726573656E746174696F6E';
wwv_flow_api.g_varchar2_table(331) := '203D2066756E6374696F6E2829207B0A2020202020202020202020207661722070616765526570726573656E746174696F6E203D207B7D3B0A2020202020202020202020207661722063757272656E7454656D706C617465547970653B0A202020202020';
wwv_flow_api.g_varchar2_table(332) := '2020202020202428222E612D5265706F72742D7265706F727422292E66696E64282274626F647922292E66696E642822747222292E656163682866756E6374696F6E2829207B0A20202020202020202020202020202020766172207461626C65526F7724';
wwv_flow_api.g_varchar2_table(333) := '203D20242874686973293B0A202020202020202020202020202020207661722074656D706C6174655479706524203D207461626C65526F77242E66696E64282274645B686561646572733D2754454D505F54595045275D22293B0A202020202020202020';
wwv_flow_api.g_varchar2_table(334) := '202020202020207661722066726F6D54656D706C61746524203D207461626C65526F77242E66696E64282274645B686561646572733D2746524F4D5F54454D504C415445275D22293B0A202020202020202020202020202020207661722073656C656374';
wwv_flow_api.g_varchar2_table(335) := '4D617070696E6724203D207461626C65526F77242E66696E64282274645B686561646572733D274C4F56275D22292E66696E64282273656C65637422293B0A202020202020202020202020202020207661722074656D706C61746554797065203D207465';
wwv_flow_api.g_varchar2_table(336) := '6D706C61746554797065242E7465787428292E7472696D28293B0A202020202020202020202020202020207661722066726F6D54656D706C617465203D2066726F6D54656D706C617465242E7465787428292E7472696D28293B0A202020202020202020';
wwv_flow_api.g_varchar2_table(337) := '202020202020206966202874656D706C617465547970652026262074656D706C617465547970652E7472696D282920213D3D20222229207B0A202020202020202020202020202020202020202063757272656E7454656D706C61746554797065203D2074';
wwv_flow_api.g_varchar2_table(338) := '656D706C617465547970653B0A202020202020202020202020202020207D0A20202020202020202020202020202020696620282170616765526570726573656E746174696F6E5B63757272656E7454656D706C617465547970655D29207B0A2020202020';
wwv_flow_api.g_varchar2_table(339) := '20202020202020202020202020202070616765526570726573656E746174696F6E5B63757272656E7454656D706C617465547970655D203D207B0A20202020202020202020202020202020202020207D3B0A202020202020202020202020202020207D0A';
wwv_flow_api.g_varchar2_table(340) := '2020202020202020202020202020202070616765526570726573656E746174696F6E5B63757272656E7454656D706C617465547970655D5B66726F6D54656D706C6174655D203D207B0A20202020202020202020202020202020202020202273656C6563';
wwv_flow_api.g_varchar2_table(341) := '7424223A2073656C6563744D617070696E67242C0A202020202020202020202020202020202020202022726F7724223A207461626C65526F77242C0A20202020202020202020202020202020202020202273656C6563746564223A2073656C6563744D61';
wwv_flow_api.g_varchar2_table(342) := '7070696E67242E66696E6428223A73656C656374656422292E7465787428290A202020202020202020202020202020207D3B0A2020202020202020202020207D293B0A20202020202020202020202072657475726E2070616765526570726573656E7461';
wwv_flow_api.g_varchar2_table(343) := '74696F6E3B0A20202020202020207D3B0A0A202020202020202076617220697465726174655468726F756768526570726573656E746174696F6E203D2066756E6374696F6E20282070616765526570726573656E746174696F6E2C2063616C6C6261636B';
wwv_flow_api.g_varchar2_table(344) := '2029207B0A202020202020202020202020666F7220287661722074656D706C6174655479706520696E2070616765526570726573656E746174696F6E29207B0A202020202020202020202020202020207661722074656D706C6174655479706573203D20';
wwv_flow_api.g_varchar2_table(345) := '70616765526570726573656E746174696F6E5B74656D706C617465547970655D3B0A20202020202020202020202020202020666F7220287661722066726F6D54656D706C61746520696E2074656D706C617465547970657329207B0A2020202020202020';
wwv_flow_api.g_varchar2_table(346) := '20202020202020202020202063616C6C6261636B282074656D706C61746554797065735B66726F6D54656D706C6174655D2C2074656D706C617465547970652C2066726F6D54656D706C617465293B0A202020202020202020202020202020207D0A2020';
wwv_flow_api.g_varchar2_table(347) := '202020202020202020207D0A20202020202020207D3B0A0A20202020202020207661722067657454656D706C6174654A736F6E203D2066756E6374696F6E2829207B0A2020202020202020202020207661722070616765526570726573656E746174696F';
wwv_flow_api.g_varchar2_table(348) := '6E203D206275696C6450616765526570726573656E746174696F6E28293B0A202020202020202020202020697465726174655468726F756768526570726573656E746174696F6E2870616765526570726573656E746174696F6E2C2066756E6374696F6E';
wwv_flow_api.g_varchar2_table(349) := '28206F7074696F6E2C2074656D706C617465547970652C2066726F6D54656D706C6174652029207B0A2020202020202020202020202020202070616765526570726573656E746174696F6E5B74656D706C617465547970655D5B66726F6D54656D706C61';
wwv_flow_api.g_varchar2_table(350) := '74655D203D20206F7074696F6E2E73656C65637465643B0A2020202020202020202020207D293B0A20202020202020202020202072657475726E204A534F4E2E737472696E676966792870616765526570726573656E746174696F6E293B0A2020202020';
wwv_flow_api.g_varchar2_table(351) := '2020207D3B0A0A20202020202020207661722073656C6563745265736574436F6C6F72203D2066756E6374696F6E2829207B0A202020202020202020202020242874686973292E72656D6F7665436C61737328227468656D652D6D6967726174696F6E2D';
wwv_flow_api.g_varchar2_table(352) := '2D69732D6572726F7222292E72656D6F7665436C61737328227468656D652D6D6967726174696F6E2D2D69732D7570646174656422293B0A20202020202020207D3B0A0A20202020202020207661722073656C6563744F7074696F6E427954657874203D';
wwv_flow_api.g_varchar2_table(353) := '2066756E6374696F6E282073656C656374242C20726F77242C2020746578742029207B0A20202020202020202020202073656C656374242E6F666628276368616E6765272C2073656C6563745265736574436F6C6F72293B0A2020202020202020202020';
wwv_flow_api.g_varchar2_table(354) := '20766172206F7074696F6E24203D2073656C656374242E66696E6428226F7074696F6E3A636F6E7461696E73282722202B2074657874202B202022272922290A202020202020202020202020202020202E66696C7465722866756E6374696F6E2869297B';
wwv_flow_api.g_varchar2_table(355) := '0A202020202020202020202020202020202020202072657475726E20242874686973292E746578742829203D3D3D20746578743B0A202020202020202020202020202020207D293B0A20202020202020202020202073656C656374242E6F6E2822636861';
wwv_flow_api.g_varchar2_table(356) := '6E6765222C2073656C6563745265736574436F6C6F72293B0A20202020202020202020202073656C656374242E72656D6F7665436C61737328227468656D652D6D6967726174696F6E2D2D69732D6572726F7222292E72656D6F7665436C617373282274';
wwv_flow_api.g_varchar2_table(357) := '68656D652D6D6967726174696F6E2D2D69732D7570646174656422293B0A202020202020202020202020696620286F7074696F6E242E6C656E677468203C3D203029207B0A2020202020202020202020202020202073656C656374242E616464436C6173';
wwv_flow_api.g_varchar2_table(358) := '7328227468656D652D6D6967726174696F6E2D2D69732D6572726F7222293B0A2020202020202020202020202020202072657475726E202D313B0A2020202020202020202020207D0A2020202020202020202020206966202873656C656374242E76616C';
wwv_flow_api.g_varchar2_table(359) := '2829203D3D3D206F7074696F6E242E76616C282929207B0A2020202020202020202020202020202072657475726E20303B0A2020202020202020202020207D0A20202020202020202020202073656C656374242E76616C286F7074696F6E242E76616C28';
wwv_flow_api.g_varchar2_table(360) := '29293B0A20202020202020202020202073656C656374242E616464436C61737328227468656D652D6D6967726174696F6E2D2D69732D7570646174656422293B0A20202020202020202020202072657475726E20313B0A20202020202020207D3B0A0A0A';
wwv_flow_api.g_varchar2_table(361) := '2020202020202020766172207772697465203D2066756E6374696F6E2028207468656D652029207B0A202020202020202020202020766172206E657750616765526570726573656E746174696F6E203D207468656D652E6D617070696E67733B0A202020';
wwv_flow_api.g_varchar2_table(362) := '2020202020202020206966202820747970656F66206E657750616765526570726573656E746174696F6E203D3D3D2022737472696E67222029207B0A202020202020202020202020202020206E657750616765526570726573656E746174696F6E203D20';
wwv_flow_api.g_varchar2_table(363) := '4A534F4E2E7061727365286E657750616765526570726573656E746174696F6E293B0A2020202020202020202020207D0A2020202020202020202020207661722070616765526570726573656E746174696F6E203D206275696C64506167655265707265';
wwv_flow_api.g_varchar2_table(364) := '73656E746174696F6E28293B0A20202020202020202020202076617220746F7563686564203D20303B0A20202020202020202020202076617220706172736564203D20303B0A202020202020202020202020766172206368616E676564203D20303B0A20';
wwv_flow_api.g_varchar2_table(365) := '2020202020202020202020766172206572726F7273203D207B7D3B0A202020202020202020202020697465726174655468726F756768526570726573656E746174696F6E2870616765526570726573656E746174696F6E2C2066756E6374696F6E202820';
wwv_flow_api.g_varchar2_table(366) := '6F7074696F6E2C2074656D706C617465547970652C2066726F6D54656D706C6174652029207B0A2020202020202020202020202020202069662028216E657750616765526570726573656E746174696F6E5B74656D706C617465547970655D29207B0A20';
wwv_flow_api.g_varchar2_table(367) := '2020202020202020202020202020202020202069662028216572726F72735B74656D706C617465547970655D29207B0A2020202020202020202020202020202020202020202020206572726F72735B74656D706C617465547970655D203D20747275653B';
wwv_flow_api.g_varchar2_table(368) := '0A20202020202020202020202020202020202020207D0A202020202020202020202020202020207D20656C73652069662028216E657750616765526570726573656E746174696F6E5B74656D706C617465547970655D5B66726F6D54656D706C6174655D';
wwv_flow_api.g_varchar2_table(369) := '29207B0A202020202020202020202020202020202020202069662028216572726F72735B74656D706C617465547970655D29207B0A2020202020202020202020202020202020202020202020206572726F72735B74656D706C617465547970655D203D20';
wwv_flow_api.g_varchar2_table(370) := '7B7D0A20202020202020202020202020202020202020207D0A20202020202020202020202020202020202020206572726F72735B74656D706C617465547970655D5B66726F6D54656D706C6174655D203D20303B0A202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(371) := '207D20656C7365207B0A2020202020202020202020202020202020202020766172206F7074696F6E4368616E676564203D0A20202020202020202020202020202020202020202020202073656C6563744F7074696F6E42795465787428206F7074696F6E';
wwv_flow_api.g_varchar2_table(372) := '2E73656C656374242C206F7074696F6E2E726F77242C20206E657750616765526570726573656E746174696F6E5B74656D706C617465547970655D5B66726F6D54656D706C6174655D20293B0A2020202020202020202020202020202020202020696620';
wwv_flow_api.g_varchar2_table(373) := '286F7074696F6E4368616E676564203D3D3D203129207B0A2020202020202020202020202020202020202020202020206368616E6765642B2B3B0A20202020202020202020202020202020202020207D20656C73652069662028206F7074696F6E436861';
wwv_flow_api.g_varchar2_table(374) := '6E676564203D3D3D202D3129207B0A20202020202020202020202020202020202020202020202069662028216572726F72735B74656D706C617465547970655D29207B0A202020202020202020202020202020202020202020202020202020206572726F';
wwv_flow_api.g_varchar2_table(375) := '72735B74656D706C617465547970655D203D207B7D0A2020202020202020202020202020202020202020202020207D0A2020202020202020202020202020202020202020202020206572726F72735B74656D706C617465547970655D5B66726F6D54656D';
wwv_flow_api.g_varchar2_table(376) := '706C6174655D203D20313B0A20202020202020202020202020202020202020207D0A2020202020202020202020202020202020202020746F75636865642B2B3B0A202020202020202020202020202020207D0A2020202020202020202020202020202070';
wwv_flow_api.g_varchar2_table(377) := '61727365642B2B3B0A2020202020202020202020207D293B0A202020202020202020202020766172206572726F724D657373616765203D20223C756C3E223B0A2020202020202020202020207661722066726F6D54656D706C6174654E6F74496E4D6170';
wwv_flow_api.g_varchar2_table(378) := '70696E67203D205B5D3B0A2020202020202020202020207661722066726F6D54656D706C617465496E4D617070696E674275744E6F74496E53656C6563744C697374203D20303B0A202020202020202020202020666F722028766172206B657920696E20';
wwv_flow_api.g_varchar2_table(379) := '6572726F727329207B0A20202020202020202020202020202020696620286572726F72735B6B65795D29207B0A2020202020202020202020202020202020202020696620286572726F72735B6B65795D20213D3D207472756529207B0A20202020202020';
wwv_flow_api.g_varchar2_table(380) := '2020202020202020202020202020202020666F7220287661722066726F6D54656D706C61746520696E206572726F72735B6B65795D29207B0A20202020202020202020202020202020202020202020202020202020696620286572726F72735B6B65795D';
wwv_flow_api.g_varchar2_table(381) := '5B66726F6D54656D706C6174655D203D3D3D20302026262066726F6D54656D706C61746520213D3D202249525220526567696F6E2054656D706C6174652229207B0A20202020202020202020202020202020202020202020202020202020202020206672';
wwv_flow_api.g_varchar2_table(382) := '6F6D54656D706C6174654E6F74496E4D617070696E672E707573682866726F6D54656D706C617465293B0A202020202020202020202020202020202020202020202020202020207D20656C7365207B0A2020202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(383) := '20202020202020202020202066726F6D54656D706C617465496E4D617070696E674275744E6F74496E53656C6563744C6973742B2B3B0A202020202020202020202020202020202020202020202020202020207D0A202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(384) := '2020202020202020207D0A20202020202020202020202020202020202020207D20656C7365207B0A2020202020202020202020202020202020202020202020206572726F724D657373616765202B3D20223C6C693E3C623E22202B206B6579202B20223C';
wwv_flow_api.g_varchar2_table(385) := '2F623E2074656D706C6174652074797065206973206E6F7420696E20746865206D617070696E673C2F6C693E223B0A20202020202020202020202020202020202020207D0A202020202020202020202020202020207D0A2020202020202020202020207D';
wwv_flow_api.g_varchar2_table(386) := '0A2020202020202020202020206572726F724D657373616765202B3D20223C2F756C3E223B0A2020202020202020202020207661722066726F6D54656D706C6174654572726F72203D2066726F6D54656D706C6174654E6F74496E4D617070696E672E6C';
wwv_flow_api.g_varchar2_table(387) := '656E677468203E2030203F0A202020202020202020202020202020202020202028273C623E27202B2066726F6D54656D706C6174654E6F74496E4D617070696E672E6C656E677468202B20273C2F623E202266726F6D2074656D706C617465732220636F';
wwv_flow_api.g_varchar2_table(388) := '756C64206E6F7420626520666F756E6420696E20746865206D617070696E672E203C62722F3E2827202B2066726F6D54656D706C6174654E6F74496E4D617070696E672E6A6F696E28222C20222920202B20272927290A20202020202020202020202020';
wwv_flow_api.g_varchar2_table(389) := '202020202020203A2022223B0A202020202020202020202020766172206E6F74496E53656C6563744C6973744572726F72203D2066726F6D54656D706C617465496E4D617070696E674275744E6F74496E53656C6563744C697374203E2030203F0A2020';
wwv_flow_api.g_varchar2_table(390) := '20202020202020202020202020202020202028273C623E27202B2066726F6D54656D706C617465496E4D617070696E674275744E6F74496E53656C6563744C697374202B2020273C2F623E2074656D706C617465206D617070696E677320636F756C6420';
wwv_flow_api.g_varchar2_table(391) := '6E6F742062652073657427202B0A20202020202020202020202020202020272062656361757365207468652073656C656374206C69737420646964206E6F74206861766520746865207370656369666965642076616C7565732E3C7374726F6E673E4469';
wwv_flow_api.g_varchar2_table(392) := '6420796F752073657420224D617463682054656D706C61746520436C61737365732220746F20224E6F2220696E207468652070726576696F757320737465703F3C2F7374726F6E673E270A202020202020202020202020202020202020202029203A2022';
wwv_flow_api.g_varchar2_table(393) := '223B0A2020202020202020202020206572726F724D657373616765203D2066726F6D54656D706C6174654572726F72202B206E6F74496E53656C6563744C6973744572726F72202B206572726F724D6573736167653B0A20202020202020202020202076';
wwv_flow_api.g_varchar2_table(394) := '61722073756D6D6172794D657373616765203D20223C623E22202B20746F7563686564202B20223C2F623E206F7574206F66203C623E22202B20706172736564202B20223C2F623E2074656D706C617465206D617070696E672873292077657265207265';
wwv_flow_api.g_varchar2_table(395) := '636F676E697A6564206279207468697320626F6F6B6D61726B6C65742E3C62722F3E204F662074686573652C203C623E22202B206368616E676564202B20223C2F623E2074656D706C617465206D617070696E67287329207765726520616C7465726564';
wwv_flow_api.g_varchar2_table(396) := '2E3C62722F3E223B0A20202020202020202020202076617220686561646572203D202253756363657373223B0A202020202020202020202020766172206469616C6F674D657373616765203D2022223B0A20202020202020202020202076617220627574';
wwv_flow_api.g_varchar2_table(397) := '746F6E73203D20205B0A202020202020202020202020202020207B20746578743A2022436C6F7365222C20636C69636B3A2066756E6374696F6E202829207B20202428207468697320292E6469616C6F67282022636C6F73652220293B20207D2C20636C';
wwv_flow_api.g_varchar2_table(398) := '6173733A22612D427574746F6E2D2D686F74227D0A2020202020202020202020205D3B0A20202020202020202020202069662028206572726F724D65737361676520213D3D20223C756C3E3C2F756C3E222029207B0A2020202020202020202020202020';
wwv_flow_api.g_varchar2_table(399) := '2020686561646572203D20225761726E696E67223B0A202020202020202020202020202020206469616C6F674D657373616765203D206572726F724D6573736167653B0A20202020202020202020202020202020627574746F6E73203D205B0A20202020';
wwv_flow_api.g_varchar2_table(400) := '202020202020202020202020202020207B20746578743A20224D617020746F206120446966666572656E74205468656D65222C20636C69636B3A2066756E6374696F6E202829207B202428207468697320292E6469616C6F67282022636C6F7365222029';
wwv_flow_api.g_varchar2_table(401) := '3B2063686F6F73655468656D65546F577269746528293B207D2C20636C6173733A22227D2C0A20202020202020202020202020202020202020207B20746578743A2022436C6F7365222C20636C69636B3A2066756E6374696F6E202829207B2020242820';
wwv_flow_api.g_varchar2_table(402) := '7468697320292E6469616C6F67282022636C6F73652220293B20207D2C20636C6173733A22612D427574746F6E2D2D686F74227D0A202020202020202020202020202020205D0A2020202020202020202020207D0A20202020202020202020202073756D';
wwv_flow_api.g_varchar2_table(403) := '6D6172794D657373616765203D0A20202020202020202020202020202020273C64697620636C6173733D22612D416C65727420612D416C6572742D2D64656661756C7449636F6E7320612D416C6572742D2D636F6C6F72424720612D416C6572742D2D27';
wwv_flow_api.g_varchar2_table(404) := '202B206865616465722E746F4C6F776572436173652829202B20202720612D416C6572742D2D686F72697A6F6E74616C223E27202B0A2020202020202020202020202020202020202020273C64697620636C6173733D22612D416C6572742D7772617022';
wwv_flow_api.g_varchar2_table(405) := '3E27202B0A202020202020202020202020202020202020202020202020273C64697620636C6173733D22612D416C6572742D69636F6E223E3C7370616E20636C6173733D22612D49636F6E20223E3C2F7370616E3E3C2F6469763E27202B0A2020202020';
wwv_flow_api.g_varchar2_table(406) := '20202020202020202020202020202020202020273C64697620636C6173733D22612D416C6572742D636F6E74656E74223E27202B0A20202020202020202020202020202020202020202020202020202020273C64697620636C6173733D22612D416C6572';
wwv_flow_api.g_varchar2_table(407) := '742D686561646572223E3C683220636C6173733D22612D416C6572742D7469746C65223E272B2020686561646572202B273C2F68323E3C2F6469763E27202B0A20202020202020202020202020202020202020202020202020202020273C64697620636C';
wwv_flow_api.g_varchar2_table(408) := '6173733D22612D416C6572742D626F6479223E27202B20206469616C6F674D657373616765202B20273C2F6469763E27202B0A202020202020202020202020202020202020202020202020273C2F6469763E27202B0A2020202020202020202020202020';
wwv_flow_api.g_varchar2_table(409) := '202020202020273C2F6469763E27202B0A20202020202020202020202020202020273C2F6469763E27202B0A2020202020202020202020202020202073756D6D6172794D6573736167653B0A2020202020202020202020206469616C6F67282022417070';
wwv_flow_api.g_varchar2_table(410) := '6C696564205C2222202B207468656D652E74657874202B20225C22206D617070696E6773222C2073756D6D6172794D6573736167652C2022222C20627574746F6E73293B0A20202020202020207D3B0A0A202020202020202076617220746F5461626C65';
wwv_flow_api.g_varchar2_table(411) := '203D2066756E6374696F6E2829207B0A202020202020202020202020766172207461626C65203D20223C7461626C653E3C74723E3C74683E5468656D653C2F747274683E3C74683E54656D706C61746520547970653C2F74683E3C74683E46726F6D2054';
wwv_flow_api.g_varchar2_table(412) := '656D706C6174653C2F74683E3C74683E56616C75653C2F74683E3C2F74723E223B0A202020202020202020202020666F722028766172206B657920696E20737570706F727465645468656D657329207B0A20202020202020202020202020202020766172';
wwv_flow_api.g_varchar2_table(413) := '207072696E745468656D65203D20747275653B0A202020202020202020202020202020207661722070726576696F757354656D706C61746554797065203D206E756C6C3B0A20202020202020202020202020202020697465726174655468726F75676852';
wwv_flow_api.g_varchar2_table(414) := '6570726573656E746174696F6E28737570706F727465645468656D65735B6B65795D2E6D617070696E67732C2066756E6374696F6E286F7074696F6E2C2074656D706C617465547970652C2066726F6D54656D706C61746529207B0A2020202020202020';
wwv_flow_api.g_varchar2_table(415) := '202020202020202020202020766172207072696E7454656D706C61746554797065203D2066616C73653B0A20202020202020202020202020202020202020206966202874656D706C6174655479706520213D3D2070726576696F757354656D706C617465';
wwv_flow_api.g_varchar2_table(416) := '5479706529207B0A2020202020202020202020202020202020202020202020207072696E7454656D706C61746554797065203D20747275653B0A20202020202020202020202020202020202020207D0A2020202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(417) := '70726576696F757354656D706C61746554797065203D2074656D706C617465547970653B0A2020202020202020202020202020202020202020766172207472203D0A202020202020202020202020202020202020202020202020223C74723E22202B0A20';
wwv_flow_api.g_varchar2_table(418) := '2020202020202020202020202020202020202020202020223C74643E22202B0A202020202020202020202020202020202020202020202020287072696E745468656D65203F206B6579203A202222202920202B0A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(419) := '2020202020202020223C2F74643E22202B0A202020202020202020202020202020202020202020202020223C74643E22202B0A202020202020202020202020202020202020202020202020287072696E7454656D706C61746554797065203F2074656D70';
wwv_flow_api.g_varchar2_table(420) := '6C61746554797065203A20222229202B0A202020202020202020202020202020202020202020202020223C2F74643E22202B0A202020202020202020202020202020202020202020202020223C74643E22202B0A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(421) := '202020202020202066726F6D54656D706C617465202B0A202020202020202020202020202020202020202020202020223C2F74643E22202B0A202020202020202020202020202020202020202020202020223C74643E22202B0A20202020202020202020';
wwv_flow_api.g_varchar2_table(422) := '2020202020202020202020202020737570706F727465645468656D65735B6B65795D2E6D617070696E67735B74656D706C617465547970655D5B66726F6D54656D706C6174655D202B0A2020202020202020202020202020202020202020202020202022';
wwv_flow_api.g_varchar2_table(423) := '3C2F74643E22202B0A20202020202020202020202020202020202020202020202020223C2F74723E223B0A2020202020202020202020202020202020202020207461626C65202B3D2074723B0A2020202020202020202020202020202020202020202F2F';
wwv_flow_api.g_varchar2_table(424) := '7072696E745468656D65203D2066616C73653B0A20202020202020202020202020202020207D293B0A202020202020202020202020207D0A202020202020202020202020207461626C65202B3D20223C2F7461626C653E223B0A20202020202020202020';
wwv_flow_api.g_varchar2_table(425) := '202020242822626F647922292E68746D6C287461626C65293B0A2020202020202020207D3B0A0A20202020202020202072657475726E207B0A20202020202020202020202020746F4A534F4E3A2067657454656D706C6174654A736F6E2C0A2020202020';
wwv_flow_api.g_varchar2_table(426) := '202020202020202077726974653A2077726974652C0A20202020202020202020202020746F5461626C653A20746F5461626C650A2020202020202020207D3B0A20202020207D2829293B0A0A0A2020202020766172206765745468656D65546F57726974';
wwv_flow_api.g_varchar2_table(427) := '65203D2066756E6374696F6E287468656D654E756D62657229207B0A20202020202020202069662028217468656D654E756D62657229207B0A2020202020202020202020202072657475726E20756E646566696E65643B0A2020202020202020207D0A20';
wwv_flow_api.g_varchar2_table(428) := '202020202020202072657475726E20737570706F727465645468656D65735B7468656D654E756D6265725D3B0A20202020207D3B0A0A20202020206966202857524954455F4D4F444529207B0A2020202020202020202866756E6374696F6E2829207B0A';
wwv_flow_api.g_varchar2_table(429) := '20202020202020202020202020766172207468656D654E756D626572537472696E67203D2024282223503338365F4143544956455F5448454D4522292E7465787428293B0A20202020202020202020202020766172207468656D654E756D626572417272';
wwv_flow_api.g_varchar2_table(430) := '6179203D202F285C642B295C2E2F2E65786563287468656D654E756D626572537472696E67293B0A20202020202020202020202020766172207468656D65546F57726974653B0A2020202020202020202020202069662028217468656D654E756D626572';
wwv_flow_api.g_varchar2_table(431) := '4172726179207C7C207468656D654E756D62657241727261792E6C656E677468203C3D2031207C7C20217468656D654E756D62657241727261795B315D29207B0A20202020202020202020202020202020206469616C6F6728224572726F72222C202254';
wwv_flow_api.g_varchar2_table(432) := '686973206973206E6F7420746865205468656D652053776974636820506167652028333836292E20506C6561736520747279207573696E6720746865206D617070696E6720626F6F6B6D61726B6C6574206F6E2074686520636F72726563742070616765';
wwv_flow_api.g_varchar2_table(433) := '2E22293B0A202020202020202020202020202020202072657475726E3B0A202020202020202020202020207D0A20202020202020202020202020747279207B0A2020202020202020202020202020202020766172207468656D654E756D626572203D2070';
wwv_flow_api.g_varchar2_table(434) := '61727365496E74287468656D654E756D62657241727261795B315D293B0A20202020202020202020202020202020207468656D65546F5772697465203D206765745468656D65546F577269746528207468656D654E756D62657220293B0A202020202020';
wwv_flow_api.g_varchar2_table(435) := '202020202020202020202069662028217468656D65546F577269746529207B0A202020202020202020202020202020202020202063686F6F73655468656D65546F577269746528207468656D654E756D62657220293B0A20202020202020202020202020';
wwv_flow_api.g_varchar2_table(436) := '2020202020202072657475726E3B0A20202020202020202020202020202020207D0A202020202020202020202020207D20636174636820286529207B0A20202020202020202020202020202020206469616C6F6728224572726F722070617273696E6720';
wwv_flow_api.g_varchar2_table(437) := '7468656D65206E756D626572222C202065202B20222E20506C6561736520676F20746F20687474703A2F2F617065782E6F7261636C652E636F6D20666F72206D6F726520696E666F726D6174696F6E2E22293B0A20202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(438) := '2072657475726E3B0A202020202020202020202020207D0A202020202020202020202020206170657854656D706C61746548656C7065722E777269746528207468656D65546F577269746520293B0A2020202020202020207D2829293B0A20202020207D';
wwv_flow_api.g_varchar2_table(439) := '20656C7365207B0A202020202020202020636F6E736F6C652E6C6F67286170657854656D706C61746548656C7065722E746F4A534F4E2829293B0A2020202020202020206170657854656D706C61746548656C7065722E746F5461626C6528293B0A0A20';
wwv_flow_api.g_varchar2_table(440) := '202020207D0A207D2829293B0A';
null;
end;
/
begin
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(600810791676723173)
,p_file_name=>'bookmarklet.js'
,p_mime_type=>'application/javascript'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
null;
end;
/
prompt --application/shared_components/files/bookmarklet_html
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '3C7374796C653E0A20202020626F6479207B0A2020202020202020746578742D616C69676E3A63656E7465723B0A202020207D0A2020202061207B0A2020202020202020666F6E742D66616D696C793A202748656C766574696361204E657565272C2027';
wwv_flow_api.g_varchar2_table(2) := '5365676F65205549272C2048656C7665746963612C20417269616C2C2073616E732D73657269663B0A2020202020202020666F6E742D73697A653A20312E35656D3B0A2020202020202020636F6C6F723A20233233373063323B0A202020202020202074';
wwv_flow_api.g_varchar2_table(3) := '6578742D6465636F726174696F6E3A206E6F6E653B0A202020207D0A202020207461626C65207B0A2020202020202020666F6E742D66616D696C793A202748656C766574696361204E657565272C20275365676F65205549272C2048656C766574696361';
wwv_flow_api.g_varchar2_table(4) := '2C20417269616C2C2073616E732D73657269663B0A2020202020202020666F6E742D73697A653A202E3735656D3B0A202020202020202077696474683A2033303070783B0A20202020202020206D617267696E3A206175746F3B0A20202020202020206D';
wwv_flow_api.g_varchar2_table(5) := '617267696E2D746F703A20323070783B0A202020207D0A202020207464207B0A2020202020202020766572746963616C2D616C69676E3A20746F703B0A2020202020202020626F726465723A20317078206772617920736F6C69643B0A202020207D0A20';
wwv_flow_api.g_varchar2_table(6) := '20202074643A66697273742D6368696C64207B0A2020202020202020666F6E742D7765696768743A20626F6C643B0A202020207D0A3C2F7374796C653E0A3C612069643D22636F64654F75742220687265663D276A6176617363726970743A2866756E63';
wwv_flow_api.g_varchar2_table(7) := '74696F6E28297B2866756E6374696F6E28297B69662877696E646F772E243D3D3D756E646566696E6564297B616C6572742822546F20757365207468697320626F6F6B6D61726B6C65742C20796F75206E65656420746F2C2066697273742C2064726167';
wwv_flow_api.g_varchar2_table(8) := '20697420696E746F20796F757220626F6F6B6D61726B206261727320616E64207468656E20636C69636B206F6E206974206F6E207061676520333836206F6620746865207468656D65207377697463682077697A6172642122293B72657475726E3B7D24';
wwv_flow_api.g_varchar2_table(9) := '2E676574536372697074282268747470733A2F2F617065782E6F7261636C652E636F6D2F706C732F617065782F617065785F706D2F722F34322F66696C65732F7374617469632F7639332F626F6F6B6D61726B6C65742E6A7322292E646F6E652866756E';
wwv_flow_api.g_varchar2_table(10) := '6374696F6E287363726970742C74657874537461747573297B636F6E736F6C652E6C6F672874657874537461747573293B7D292E6661696C2866756E6374696F6E286A717868722C73657474696E67732C657863657074696F6E297B7D293B7D2928293B';
wwv_flow_api.g_varchar2_table(11) := '7D2928293B273E556E6976657273616C205468656D65204D6967726174696F6E2048656C7065722056312E313C2F613E0A3C7461626C653E0A202020203C74686561643E0A20202020202020203C74723E0A2020202020202020202020203C74683E0A20';
wwv_flow_api.g_varchar2_table(12) := '20202020202020202020202020202056657273696F6E0A2020202020202020202020203C2F74683E0A2020202020202020202020203C74683E0A20202020202020202020202020202020446174650A2020202020202020202020203C2F74683E0A202020';
wwv_flow_api.g_varchar2_table(13) := '2020202020202020203C74683E0A202020202020202020202020202020204368616E6765730A2020202020202020202020203C2F74683E0A20202020202020203C2F74723E0A202020203C2F74686561643E0A202020203C74626F64793E0A2020202020';
wwv_flow_api.g_varchar2_table(14) := '2020203C74723E0A2020202020202020202020203C74643E0A20202020202020202020202020202020312E310A2020202020202020202020203C2F74643E0A2020202020202020202020203C74643E0A20202020202020202020202020202020362F3139';
wwv_flow_api.g_varchar2_table(15) := '2F31350A2020202020202020202020203C2F74643E0A2020202020202020202020203C74643E0A202020202020202020202020202020205468656D652032312C2032322C20323320737570706F72743C62722F3E496E7465726E6574204578706C6F7265';
wwv_flow_api.g_varchar2_table(16) := '7220537570706F72742E203C62722F3E204175746F205570646174696E670A2020202020202020202020203C2F74643E0A20202020202020203C2F74723E0A20202020202020203C74723E0A2020202020202020202020203C74643E0A20202020202020';
wwv_flow_api.g_varchar2_table(17) := '202020202020202020312E30310A2020202020202020202020203C2F74643E0A2020202020202020202020203C74643E0A20202020202020202020202020202020352F31332F31350A2020202020202020202020203C2F74643E0A202020202020202020';
wwv_flow_api.g_varchar2_table(18) := '2020203C74643E0A2020202020202020202020202020202046697265666F7820537570706F72740A2020202020202020202020203C2F74643E0A20202020202020203C2F74723E0A20202020202020203C74723E0A2020202020202020202020203C7464';
wwv_flow_api.g_varchar2_table(19) := '3E0A20202020202020202020202020202020312E300A2020202020202020202020203C2F74643E0A2020202020202020202020203C74643E0A0A2020202020202020202020203C2F74643E0A2020202020202020202020203C74643E0A20202020202020';
wwv_flow_api.g_varchar2_table(20) := '202020202020202020496E697469616C2052656C656173650A2020202020202020202020203C2F74643E0A20202020202020203C2F74723E0A202020203C2F74626F64793E0A3C2F7461626C653E0A';
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(600811073501723584)
,p_file_name=>'bookmarklet.html'
,p_mime_type=>'text/html'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(91982914389572371)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(821272426124330293)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1765084935075712071)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1831787808583994192)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1917660199250940025)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'classic'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1937475917086479910)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.D3.BUBBLE45203'
,p_attribute_01=>'1.333'
,p_attribute_02=>'3'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1999311583087033598)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(10645977349305910813)
,p_icon_sequence=>10
,p_icon_subtext=>'Logout'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Logout'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_items
begin
null;
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
wwv_flow_api.create_toplevel_tab(
 p_id=>wwv_flow_api.id(10345291198234495493)
,p_tab_set=>'Page Templates2'
,p_tab_sequence=>10
,p_tab_name=>'T_PARENTTABTEST2'
,p_tab_text=>'Parent&nbsp;Tab&nbsp;Test&nbsp;2'
,p_tab_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:::'
,p_current_on_tabset=>'TS1'
);
wwv_flow_api.create_toplevel_tab(
 p_id=>wwv_flow_api.id(10345288219718477677)
,p_tab_set=>'Page Templates2'
,p_tab_sequence=>20
,p_tab_name=>'T_PAGE TEMPLATES2'
,p_tab_text=>'Parent&nbsp;Tab&nbsp;Test&nbsp;1'
,p_tab_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:::'
,p_current_on_tabset=>'PageTemplates'
);
end;
/
prompt --application/shared_components/user_interface/lovs/availability
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(160414337382963894)
,p_lov_name=>'AVAILABILITY'
,p_lov_query=>'.'||wwv_flow_api.id(160414337382963894)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160414723240963895)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Immediate'
,p_lov_return_value=>'IMMEDIATE'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160415176616963895)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Next Month'
,p_lov_return_value=>'NEXTMONTH'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160415520833963895)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Not Available'
,p_lov_return_value=>'NOTAVAILABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/font_animations
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(562737530366047618)
,p_lov_name=>'FONT_ANIMATIONS'
,p_lov_query=>'.'||wwv_flow_api.id(562737530366047618)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(562738521271047624)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spin'
,p_lov_return_value=>'fa-anim-spin'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(562737797145047621)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Spin in Steps'
,p_lov_return_value=>'fa-anim-spin-step'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(562738178804047623)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Flash'
,p_lov_return_value=>'fa-anim-flash'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(562751360586120648)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Horizontal Shake'
,p_lov_return_value=>'fa-anim-horizontal-shake'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(562751771179120648)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Vertical Shake'
,p_lov_return_value=>'fa-anim-vertical-shake'
);
end;
/
prompt --application/shared_components/user_interface/lovs/role
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(160417043060963896)
,p_lov_name=>'ROLE'
,p_lov_query=>'.'||wwv_flow_api.id(160417043060963896)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160417472388963897)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Developer'
,p_lov_return_value=>'DEVELOP'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160417816503963897)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Designer'
,p_lov_return_value=>'DESIGN'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160418263172963897)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Manager'
,p_lov_return_value=>'MANAGER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/skills
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(160409448640963882)
,p_lov_name=>'SKILLS'
,p_lov_query=>'.'||wwv_flow_api.id(160409448640963882)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160409850103963886)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'APEX'
,p_lov_return_value=>'APEX'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160410273789963888)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'HTML'
,p_lov_return_value=>'HTML'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160410626679963888)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'JavaScript'
,p_lov_return_value=>'JS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160411086984963888)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'CSS'
,p_lov_return_value=>'CSS'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160411457066963888)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Java'
,p_lov_return_value=>'Java'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160411823871963889)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Scala'
,p_lov_return_value=>'Scala'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(160412272089963889)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Ruby on Rails'
,p_lov_return_value=>'Ruby on Rails'
);
end;
/
prompt --application/pages/page_groups
begin
wwv_flow_api.create_page_group(
 p_id=>wwv_flow_api.id(405064482015020227)
,p_group_name=>'Components'
);
wwv_flow_api.create_page_group(
 p_id=>wwv_flow_api.id(558266987012620477)
,p_group_name=>'Design'
);
wwv_flow_api.create_page_group(
 p_id=>wwv_flow_api.id(431032219555845082)
,p_group_name=>'Migration Guide'
);
wwv_flow_api.create_page_group(
 p_id=>wwv_flow_api.id(713639924515207048)
,p_group_name=>'Tools and Utilities'
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/universal_theme_breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(1725934084712570512)
,p_name=>'Universal Theme Breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(7673360602846008)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Layout Modifiers'
,p_link=>'f?p=&APP_ID.:6303:&SESSION.'
,p_page_id=>6303
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(7685388498866322)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Content Modifiers'
,p_link=>'f?p=&APP_ID.:6304:&SESSION.'
,p_page_id=>6304
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(210168877180558147)
,p_parent_id=>wwv_flow_api.id(881157505434754791)
,p_short_name=>'Inline Popup'
,p_link=>'f?p=&APP_ID.:1915:&SESSION.'
,p_page_id=>1915
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(315966332257005007)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'List View'
,p_link=>'f?p=&APP_ID.:1700:&SESSION.::&DEBUG.:::'
,p_page_id=>1700
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(316475931504323548)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Reflow Report'
,p_link=>'f?p=&APP_ID.:1710:&SESSION.::&DEBUG.:::'
,p_page_id=>1710
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(316476488861330022)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Column Toggle Report'
,p_link=>'f?p=&APP_ID.:1720:&SESSION.::&DEBUG.:::'
,p_page_id=>1720
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(350283341012744451)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Content Row'
,p_link=>'f?p=&APP_ID.:1407:&SESSION.'
,p_page_id=>1407
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405016342125846517)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Standard Region'
,p_link=>'f?p=&APP_ID.:1201:&SESSION.::&DEBUG.:::'
,p_page_id=>1201
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405040484449865679)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Alert'
,p_link=>'f?p=&APP_ID.:1202:&SESSION.::&DEBUG.:::'
,p_page_id=>1202
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405062644608003720)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Hero'
,p_link=>'f?p=&APP_ID.:1203:&SESSION.::&DEBUG.:::'
,p_page_id=>1203
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405108427828686806)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Button Group'
,p_link=>'f?p=&APP_ID.:1204:&SESSION.::&DEBUG.:::'
,p_page_id=>1204
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405191402701156577)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Carousel'
,p_link=>'f?p=&APP_ID.:1205:&SESSION.::&DEBUG.:::'
,p_page_id=>1205
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405231916079328330)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Collapsible'
,p_link=>'f?p=&APP_ID.:1206:&SESSION.::&DEBUG.:::'
,p_page_id=>1206
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405259632803407094)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Title Bar Region'
,p_link=>'f?p=&APP_ID.:1207:&SESSION.::&DEBUG.:::'
,p_page_id=>1207
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405315415623757810)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Wizards'
,p_link=>'f?p=&APP_ID.:1208:&SESSION.::&DEBUG.:::'
,p_page_id=>1208
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405358438291967114)
,p_parent_id=>wwv_flow_api.id(1911030665098394574)
,p_short_name=>'Text Only'
,p_link=>'f?p=&APP_ID.:1501:&SESSION.'
,p_page_id=>1501
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405404246911043708)
,p_parent_id=>wwv_flow_api.id(1911030665098394574)
,p_short_name=>'Icon Only'
,p_link=>'f?p=&APP_ID.:1502:&SESSION.'
,p_page_id=>1502
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405722108370782715)
,p_parent_id=>wwv_flow_api.id(1911030665098394574)
,p_short_name=>'Text With Icon'
,p_link=>'f?p=&APP_ID.:1503:&SESSION.'
,p_page_id=>1503
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405776641189895027)
,p_parent_id=>wwv_flow_api.id(405777134403900984)
,p_short_name=>'Media List '
,p_link=>'f?p=&APP_ID.:1301:&SESSION.::&DEBUG.:::'
,p_page_id=>1301
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(405777134403900984)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Lists'
,p_link=>'f?p=&APP_ID.:1300:&SESSION.::&DEBUG.:::'
,p_page_id=>1300
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(415729531119475692)
,p_parent_id=>wwv_flow_api.id(405777134403900984)
,p_short_name=>'Links List'
,p_link=>'f?p=&APP_ID.:1303:&SESSION.::&DEBUG.:::'
,p_page_id=>1303
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(415752454589532129)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Badge List'
,p_link=>'f?p=&APP_ID.:1304:&SESSION.::&DEBUG.:::'
,p_page_id=>1304
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(415772729409701356)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Menu Bar'
,p_link=>'f?p=&APP_ID.:1305:&SESSION.::&DEBUG.:::'
,p_page_id=>1305
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(415798956596821823)
,p_parent_id=>wwv_flow_api.id(881194233909445309)
,p_short_name=>'Classic Report'
,p_link=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.:::'
,p_page_id=>1401
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(415955727913117791)
,p_parent_id=>wwv_flow_api.id(881194233909445309)
,p_short_name=>'Interactive Report'
,p_link=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.:::'
,p_page_id=>1402
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(416129372898571323)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>' Value Attribute Pairs'
,p_link=>'f?p=&APP_ID.:1403:&SESSION.::&DEBUG.:::'
,p_page_id=>1403
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(416218025971740499)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Comments'
,p_link=>'f?p=&APP_ID.:1405:&SESSION.::&DEBUG.:::'
,p_page_id=>1405
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(416303482217820050)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Timeline'
,p_link=>'f?p=&APP_ID.:1406:&SESSION.::&DEBUG.:::'
,p_page_id=>1406
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(416369132735887980)
,p_parent_id=>wwv_flow_api.id(416370450953899013)
,p_short_name=>'Form Modifiers'
,p_link=>'f?p=&APP_ID.:1601:&SESSION.::&DEBUG.:::'
,p_page_id=>1601
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(416370450953899013)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Forms'
,p_link=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.:::'
,p_page_id=>1600
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(416507407538131265)
,p_parent_id=>wwv_flow_api.id(416370450953899013)
,p_short_name=>'Multi Column Layout'
,p_link=>'f?p=&APP_ID.:1602:&SESSION.'
,p_page_id=>1602
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(430904312030166974)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Calendar'
,p_link=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.:::'
,p_page_id=>1800
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(431026239113724261)
,p_parent_id=>wwv_flow_api.id(431031703087824044)
,p_short_name=>'Why Migrate'
,p_link=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.:::'
,p_page_id=>2010
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(431031703087824044)
,p_parent_id=>0
,p_short_name=>'Migration Guides'
,p_link=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.:::'
,p_page_id=>2000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(431044436003209545)
,p_parent_id=>wwv_flow_api.id(431031703087824044)
,p_short_name=>'Bookmarklet'
,p_link=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.:::'
,p_page_id=>2040
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(431272858361902943)
,p_parent_id=>wwv_flow_api.id(431031703087824044)
,p_short_name=>'FAQ'
,p_link=>'f?p=&APP_ID.:2050:&SESSION.'
,p_page_id=>2050
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(435211113342906473)
,p_parent_id=>wwv_flow_api.id(431031703087824044)
,p_short_name=>'Migration Steps'
,p_link=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.:::'
,p_page_id=>2020
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(435224098597129018)
,p_parent_id=>wwv_flow_api.id(431031703087824044)
,p_short_name=>'Post Migration'
,p_link=>'f?p=&APP_ID.:2030:&SESSION.'
,p_page_id=>2030
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(459020312700661741)
,p_parent_id=>wwv_flow_api.id(416370450953899013)
,p_short_name=>'Floating Labels'
,p_link=>'f?p=&APP_ID.:1603:&SESSION.'
,p_page_id=>1603
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(480671848759352791)
,p_short_name=>'About'
,p_link=>'f?p=&APP_ID.:600:&SESSION.'
,p_page_id=>600
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Components'
,p_link=>'f?p=&APP_ID.:3000:&SESSION.'
,p_page_id=>3000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(599865283849044119)
,p_parent_id=>wwv_flow_api.id(431031703087824044)
,p_short_name=>'Migrating from jQuery Mobile'
,p_link=>'f?p=&APP_ID.:2060:&SESSION.'
,p_page_id=>2060
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(662088705999490988)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'Mobile Patterns'
,p_link=>'f?p=&APP_ID.:420:&SESSION.'
,p_page_id=>420
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(673646648036520165)
,p_parent_id=>wwv_flow_api.id(662088705999490988)
,p_short_name=>'Navigation'
,p_link=>'f?p=&APP_ID.:421:&SESSION.'
,p_page_id=>421
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(713440476208313042)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'JavaScript Events'
,p_link=>'f?p=&APP_ID.:6200:&SESSION.::&DEBUG.:::'
,p_page_id=>6200
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(713441110976327619)
,p_parent_id=>0
,p_short_name=>'Reference'
,p_link=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.:::'
,p_page_id=>6000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(713639758730194276)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Button Builder'
,p_link=>'f?p=&APP_ID.:6100:&SESSION.'
,p_page_id=>6100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(732954489982714238)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Standard Page Template'
,p_link=>'f?p=&APP_ID.:1115:&SESSION.'
,p_page_id=>1115
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(736913114356128770)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Responsive Utilities'
,p_link=>'f?p=&APP_ID.:6301:&SESSION.::&DEBUG.:::'
,p_page_id=>6301
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(747876825088794510)
,p_parent_id=>wwv_flow_api.id(662088705999490988)
,p_short_name=>'Headers and Footers'
,p_link=>'f?p=&APP_ID.:422:&SESSION.'
,p_page_id=>422
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(752552499874333310)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Color and Status Modifiers'
,p_link=>'f?p=&APP_ID.:6302:&SESSION.'
,p_page_id=>6302
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(756678249191197562)
,p_parent_id=>wwv_flow_api.id(878820395161346399)
,p_short_name=>'Page Footer'
,p_link=>'f?p=&APP_ID.:1117:&SESSION.'
,p_page_id=>1117
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(756755896005683553)
,p_parent_id=>wwv_flow_api.id(662088705999490988)
,p_short_name=>'Data Entry'
,p_link=>'f?p=&APP_ID.:423:&SESSION.'
,p_page_id=>423
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(756768285839753736)
,p_parent_id=>wwv_flow_api.id(756755896005683553)
,p_short_name=>'Mobile Forms Example'
,p_link=>'f?p=&APP_ID.:1604:&SESSION.'
,p_page_id=>1604
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(756831656565273988)
,p_parent_id=>wwv_flow_api.id(662088705999490988)
,p_short_name=>'Touch Gestures'
,p_link=>'f?p=&APP_ID.:424:&SESSION.'
,p_page_id=>424
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(790468275074051539)
,p_parent_id=>wwv_flow_api.id(662088705999490988)
,p_short_name=>'jQuery Mobile Components'
,p_link=>'f?p=&APP_ID.:425:&SESSION.::&DEBUG.:::'
,p_page_id=>425
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878800086315994991)
,p_parent_id=>0
,p_short_name=>'Design'
,p_link=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.:::'
,p_page_id=>401
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878803110284040666)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'Colors'
,p_link=>'f?p=&APP_ID.:402:&SESSION.'
,p_page_id=>402
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878805148812052134)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'Customization'
,p_link=>'f?p=&APP_ID.:403:&SESSION.'
,p_page_id=>403
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878806872645056196)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'Data Entry'
,p_link=>'f?p=&APP_ID.:404:&SESSION.'
,p_page_id=>404
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878808536733061977)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'Notifications and Messaging'
,p_link=>'f?p=&APP_ID.:406:&SESSION.'
,p_page_id=>406
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878810707644066974)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'Navigation'
,p_link=>'f?p=&APP_ID.:407:&SESSION.'
,p_page_id=>407
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878820013807343793)
,p_parent_id=>wwv_flow_api.id(878820395161346399)
,p_short_name=>'Login Page'
,p_link=>'f?p=&APP_ID.:5001:&SESSION.::&DEBUG.:::'
,p_page_id=>5001
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878820395161346399)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'UI Patterns'
,p_link=>'f?p=&APP_ID.:5000:&SESSION.::&DEBUG.:::'
,p_page_id=>5000
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878822705619358077)
,p_parent_id=>wwv_flow_api.id(878820395161346399)
,p_short_name=>'Home and Dashboard'
,p_link=>'f?p=&APP_ID.:5002:&SESSION.'
,p_page_id=>5002
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878823819415362574)
,p_parent_id=>wwv_flow_api.id(878820395161346399)
,p_short_name=>'Filter Page'
,p_link=>'f?p=&APP_ID.:5003:&SESSION.::&DEBUG.:::'
,p_page_id=>5003
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878824976710375281)
,p_parent_id=>wwv_flow_api.id(878820395161346399)
,p_short_name=>'Marquee Page'
,p_link=>'f?p=&APP_ID.:5004:&SESSION.'
,p_page_id=>5004
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878826051998379262)
,p_parent_id=>wwv_flow_api.id(878820395161346399)
,p_short_name=>'Modal Dialogs'
,p_link=>'f?p=&APP_ID.:5005:&SESSION.'
,p_page_id=>5005
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878827168982388181)
,p_parent_id=>wwv_flow_api.id(878800086315994991)
,p_short_name=>'Layout'
,p_link=>'f?p=&APP_ID.:700:&SESSION.'
,p_page_id=>700
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878830369710409691)
,p_parent_id=>wwv_flow_api.id(878827168982388181)
,p_short_name=>'Responsive Design'
,p_link=>'f?p=&APP_ID.:701:&SESSION.'
,p_page_id=>701
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(878835075205587954)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Breadcrumb'
,p_link=>'f?p=&APP_ID.:3810:&SESSION.'
,p_page_id=>3810
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(879740912488795988)
,p_parent_id=>wwv_flow_api.id(878827168982388181)
,p_short_name=>'Grid Layout'
,p_link=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:::'
,p_page_id=>300
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881066848076282529)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Tree'
,p_link=>'f?p=&APP_ID.:1901:&SESSION.'
,p_page_id=>1901
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881111039740601975)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Charts'
,p_link=>'f?p=&APP_ID.:1902:&SESSION.'
,p_page_id=>1902
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881116326102723830)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Help Text'
,p_link=>'f?p=&APP_ID.:1903:&SESSION.'
,p_page_id=>1903
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881118152890734670)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Map Chart'
,p_link=>'f?p=&APP_ID.:1904:&SESSION.'
,p_page_id=>1904
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881121800279740598)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Static Content'
,p_link=>'f?p=&APP_ID.:1905:&SESSION.::&DEBUG.:::'
,p_page_id=>1905
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881157505434754791)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Modal Dialogs and Popups'
,p_link=>'f?p=&APP_ID.:1906:&SESSION.::&DEBUG.:::'
,p_page_id=>1906
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881163895342772753)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Tabs and Region Display Selector'
,p_link=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.:::'
,p_page_id=>1907
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881167366244202617)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'PL/SQL Dynamic Content'
,p_link=>'f?p=&APP_ID.:1908:&SESSION.'
,p_page_id=>1908
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881168623211214610)
,p_parent_id=>wwv_flow_api.id(431031703087824044)
,p_short_name=>'Updating Universal Theme'
,p_link=>'f?p=&APP_ID.:1909:&SESSION.::&DEBUG.:::'
,p_page_id=>1909
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881170097767222220)
,p_parent_id=>wwv_flow_api.id(881157505434754791)
,p_short_name=>'Page Dialog'
,p_link=>'f?p=&APP_ID.:1910:&SESSION.::&DEBUG.:::'
,p_page_id=>1910
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881172314139238857)
,p_parent_id=>wwv_flow_api.id(881157505434754791)
,p_short_name=>'Inline Dialog'
,p_link=>'f?p=&APP_ID.:1911:&SESSION.::&DEBUG.:::'
,p_page_id=>1911
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881194233909445309)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Data Tables and Reports'
,p_link=>'f?p=&APP_ID.:3400:&SESSION.'
,p_page_id=>3400
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881228626406484346)
,p_parent_id=>wwv_flow_api.id(881194233909445309)
,p_short_name=>'Interactive Grid'
,p_link=>'f?p=&APP_ID.:1410:&SESSION.::&DEBUG.:::'
,p_page_id=>1410
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881374476202981669)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Change Log'
,p_link=>'f?p=&APP_ID.:6305:&SESSION.'
,p_page_id=>6305
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(881376276477993941)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'FAQ'
,p_link=>'f?p=&APP_ID.:6306:&SESSION.'
,p_page_id=>6306
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1758435596542435858)
,p_parent_id=>wwv_flow_api.id(878827168982388181)
,p_short_name=>'Page Templates'
,p_link=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.:::'
,p_page_id=>1100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1773976871138980525)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Standard Page Template'
,p_link=>'f?p=&APP_ID.:1101:&SESSION.'
,p_page_id=>1101
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1808784107265857503)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Component Templates'
,p_link=>'f?p=&APP_ID.:6307:&SESSION.'
,p_page_id=>6307
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1885245761685551804)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Standard Page Template'
,p_link=>'f?p=&APP_ID.:1102:&SESSION.'
,p_page_id=>1102
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1885259462750625674)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Left Column Page with Side Navigation'
,p_link=>'f?p=&APP_ID.:1103:&SESSION.'
,p_page_id=>1103
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1885267674882727203)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Left Column Page with Top Navigation'
,p_link=>'f?p=&APP_ID.:1104:&SESSION.'
,p_page_id=>1104
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1890860434385160978)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Right Column Page with Top Navigation'
,p_link=>'f?p=&APP_ID.:1105:&SESSION.'
,p_page_id=>1105
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1890864473059172587)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Right Column Page with Top Navigation'
,p_link=>'f?p=&APP_ID.:1106:&SESSION.'
,p_page_id=>1106
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1890868915075211375)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Marquee Detail Page with Side Navigation'
,p_link=>'f?p=&APP_ID.:1107:&SESSION.::&DEBUG.:::'
,p_page_id=>1107
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1891239718441396761)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Marquee Detail Page with Top Navigation'
,p_link=>'f?p=&APP_ID.:1108:&SESSION.::&DEBUG.:::'
,p_page_id=>1108
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1897720798714999483)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Side Columns Page with Side Navigation'
,p_link=>'f?p=&APP_ID.:1109:&SESSION.'
,p_page_id=>1109
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1897734087043021074)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Side Columns Page with Top Navigation'
,p_link=>'f?p=&APP_ID.:1110:&SESSION.'
,p_page_id=>1110
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1898478875532595926)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Standard Dialog Page'
,p_link=>'f?p=&APP_ID.:1111:&SESSION.'
,p_page_id=>1111
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1899238584269120733)
,p_parent_id=>wwv_flow_api.id(1758435596542435858)
,p_short_name=>'Minimal Page Template'
,p_link=>'f?p=&APP_ID.:1113:&SESSION.'
,p_page_id=>1113
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1911030665098394574)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Buttons'
,p_link=>'f?p=&APP_ID.:1500:&SESSION.::&DEBUG.:::'
,p_page_id=>1500
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2055956183257222899)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Menu Popup'
,p_link=>'f?p=&APP_ID.:1306:&SESSION.'
,p_page_id=>1306
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2089777306376286802)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Cards'
,p_link=>'f?p=&APP_ID.:3100:&SESSION.'
,p_page_id=>3100
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2176455778526356925)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'JavaScript APIs'
,p_link=>'f?p=&APP_ID.:6201:&SESSION.'
,p_page_id=>6201
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2182465237568964508)
,p_parent_id=>wwv_flow_api.id(558267818619623839)
,p_short_name=>'Button Container'
,p_link=>'f?p=&APP_ID.:1250:&SESSION.::&DEBUG.:::'
,p_page_id=>1250
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(2190812909868353587)
,p_parent_id=>wwv_flow_api.id(713441110976327619)
,p_short_name=>'Region Types'
,p_link=>'f?p=&APP_ID.:6308:&SESSION.::&DEBUG.:::'
,p_page_id=>6308
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/legacy_breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(10646235150665492431)
,p_name=>'Legacy Breadcrumb'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/master_detail
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(549332834543365415)
,p_theme_id=>42
,p_name=>'Marquee'
,p_internal_name=>'MASTER_DETAIL'
,p_is_popup=>false
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.stickyTableHeader#MIN#.js?v=#APEX_VERSION#',
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#'))
,p_javascript_code_onload=>'apex.theme42.initializePage.masterDetail();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--masterDetail t-PageBody--hideLeft no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-info" id="t_Body_info">#REGION_POSITION_02#</div>',
'        <div class="t-Body-contentInner" role="main">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'  <div class="t-Body-actions" id="t_Body_actions">',
'    <button class="t-Body-actionsToggle" title="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" id="t_Button_rightControlButton" type="button"><span class="t-Body-actionsControlsIcon" aria-hidden="true"></span></button>',
'    <div class="t-Body-actionsContent" role="complementary">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026135033193806)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026259383193856)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026302468193858)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Master Detail'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026459439193860)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Right Side Column'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>4
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026514723193861)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026613257193863)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026707805193864)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026843032193866)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026951804193868)
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
end;
/
prompt --application/shared_components/user_interface/templates/page/modal_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(651378991620880020)
,p_theme_id=>42
,p_name=>'Modal Dialog'
,p_internal_name=>'MODAL_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.theme42.initializePage.modalDialog();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-Dialog-page t-Dialog-page--standard #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD#>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="t-Dialog-header">#REGION_POSITION_01#</div>',
'  <div class="t-Dialog-bodyWrapperOut">',
'    <div class="t-Dialog-bodyWrapperIn">',
'      <div class="t-Dialog-body" role="main">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION##BODY#</div>',
'    </div>',
'  </div>',
'  <div class="t-Dialog-footer">#REGION_POSITION_03#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},''t-Dialog-page--standard ''+#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'auto'
,p_dialog_width=>'720'
,p_dialog_max_width=>'960'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027761432193879)
,p_page_template_id=>wwv_flow_api.id(651378991620880020)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027843455193881)
,p_page_template_id=>wwv_flow_api.id(651378991620880020)
,p_name=>'Dialog Header'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027960279193882)
,p_page_template_id=>wwv_flow_api.id(651378991620880020)
,p_name=>'Dialog Footer'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/login
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(652129338145143712)
,p_theme_id=>42
,p_name=>'Login'
,p_internal_name=>'LOGIN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.appLogin();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody--login no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD#>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Login-container">',
'  <header class="t-Login-containerHeader">#REGION_POSITION_01#</header>',
'  <main class="t-Login-containerBody" id="main">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION##BODY#</main>',
'  <footer class="t-Login-containerFooter">#REGION_POSITION_02#</footer>',
'</div>',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>6
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(238833681160466736)
,p_page_template_id=>wwv_flow_api.id(652129338145143712)
,p_name=>'Body Footer'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025989579193803)
,p_page_template_id=>wwv_flow_api.id(652129338145143712)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898026037066193804)
,p_page_template_id=>wwv_flow_api.id(652129338145143712)
,p_name=>'Body Header'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/wizard_modal_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(672766417768219611)
,p_theme_id=>42
,p_name=>'Wizard Modal Dialog'
,p_internal_name=>'WIZARD_MODAL_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.theme42.initializePage.wizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-Dialog-page t-Dialog-page--wizard #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD#>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="t-Dialog-header">#REGION_POSITION_01#</div>',
'  <div class="t-Dialog-bodyWrapperOut">',
'    <div class="t-Dialog-bodyWrapperIn">',
'      <div class="t-Dialog-body" role="main">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION##BODY#</div>',
'    </div>',
'  </div>',
'  <div class="t-Dialog-footer">#REGION_POSITION_03#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>3
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},''t-Dialog-page--wizard ''+#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'auto'
,p_dialog_width=>'720'
,p_dialog_max_width=>'960'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029543229193907)
,p_page_template_id=>wwv_flow_api.id(672766417768219611)
,p_name=>'Wizard Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029677647193908)
,p_page_template_id=>wwv_flow_api.id(672766417768219611)
,p_name=>'Wizard Progress Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029796003193910)
,p_page_template_id=>wwv_flow_api.id(672766417768219611)
,p_name=>'Wizard Buttons'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/left_side_column
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1077614758642401794)
,p_theme_id=>42
,p_name=>'Left Side Column'
,p_internal_name=>'LEFT_SIDE_COLUMN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.leftSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--showLeft t-PageBody--hideActions no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-side" id="t_Body_side">#REGION_POSITION_02#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024222202193732)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024367682193743)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024448183193745)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Left Column'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>4
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024532396193746)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024677698193748)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024722418193749)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024819634193750)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898024932142193752)
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>8
);
end;
/
prompt --application/shared_components/user_interface/templates/page/right_side_column
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1077618304322444671)
,p_theme_id=>42
,p_name=>'Right Side Column'
,p_internal_name=>'RIGHT_SIDE_COLUMN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.rightSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8"> ',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--hideLeft no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'  <div class="t-Body-actions" id="t_Body_actions">',
'    <button class="t-Body-actionsToggle" aria-label="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" title="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" id="t_Button_rightControlButton" type="button"><span class="t-Body-actionsControlsIcon" aria-hidden="true"></span></button'
||'>',
'    <div class="t-Body-actionsContent" role="complementary">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028034231193884)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028155004193885)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028292859193887)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Right Column'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>4
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028375002193889)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028459934193890)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028510530193892)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028667980193893)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028715321193895)
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
end;
/
prompt --application/shared_components/user_interface/templates/page/left_and_right_side_columns
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1077621880644450151)
,p_theme_id=>42
,p_name=>'Left and Right Side Columns'
,p_internal_name=>'LEFT_AND_RIGHT_SIDE_COLUMNS'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.bothSideCols();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">  ',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>',
'</head>',
'<body class="t-PageBody t-PageBody--showLeft no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-side" id="t_Body_side">#REGION_POSITION_02#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'  <div class="t-Body-actions" id="t_Body_actions">',
'    <button class="t-Body-actionsToggle" title="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" id="t_Button_rightControlButton" type="button"><span class="t-Body-actionsControlsIcon" aria-hidden="true"></span></button>',
'    <div class="t-Body-actionsContent" role="complementary">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025094277193753)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>6
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025169785193755)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025218727193756)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Left Column'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>3
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025307072193757)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Right Column'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>3
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025400630193759)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025522864193760)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>6
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025653552193798)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025767532193800)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898025829378193801)
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>6
);
end;
/
prompt --application/shared_components/user_interface/templates/page/minimal_no_navigation
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1530046751615002521)
,p_theme_id=>42
,p_name=>'Minimal (No Navigation)'
,p_internal_name=>'MINIMAL_NO_NAVIGATION'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.noSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#  ',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--hideLeft t-PageBody--hideActions no-anim #PAGE_CSS_CLASSES# t-PageBody--noNav" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Icon fa fa-bars" aria-hidden="true"'
||'></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'</header>',
'    '))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>',
''))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar t-NavigationBar--classic" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027097506193870)
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027153015193872)
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027208668193873)
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027379730193874)
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027406825193876)
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027540226193877)
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898027682364193878)
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/page/standard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(2623327345562852400)
,p_theme_id=>42
,p_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.noSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--hideLeft t-PageBody--hideActions no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>',
''))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar t-NavigationBar--classic" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028805728193896)
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898028986053193898)
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029024317193899)
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029147558193901)
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029298175193902)
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029317528193904)
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(1898029472887193905)
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/button/text_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(633800930240492718)
,p_template_name=>'Text with Icon'
,p_internal_name=>'TEXT_WITH_ICON'
,p_template=>'<button class="t-Button t-Button--icon #BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#"><span class="t-Icon t-Icon--left #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-Button-label">#LABEL#'
||'</span><span class="t-Icon t-Icon--right #ICON_CSS_CLASSES#" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="t-Button t-Button--icon #BUTTON_CSS_CLASSES# t-Button--hot" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#"><span class="t-Icon t-Icon--left #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-Button-'
||'label">#LABEL#</span><span class="t-Icon t-Icon--right #ICON_CSS_CLASSES#" aria-hidden="true"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>4
,p_preset_template_options=>'t-Button--iconRight'
,p_theme_id=>42
);
end;
/
prompt --application/shared_components/user_interface/templates/button/icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(900079107762114354)
,p_template_name=>'Icon'
,p_internal_name=>'ICON'
,p_template=>'<button class="t-Button t-Button--noLabel t-Button--icon #BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL#" aria-label="#LABEL#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"><'
||'/span></button>'
,p_hot_template=>'<button class="t-Button t-Button--noLabel t-Button--icon #BUTTON_CSS_CLASSES# t-Button--hot" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL#" aria-label="#LABEL#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>5
,p_theme_id=>42
);
end;
/
prompt --application/shared_components/user_interface/templates/button/text
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(2623334346116852418)
,p_template_name=>'Text'
,p_internal_name=>'TEXT'
,p_template=>'<button onclick="#JAVASCRIPT#" class="t-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><span class="t-Button-label">#LABEL#</span></button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="t-Button t-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><span class="t-Button-label">#LABEL#</span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>42
);
end;
/
prompt --application/shared_components/user_interface/templates/region/inline_popup
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(36340727081178326)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#_parent">',
'<div id="#REGION_STATIC_ID#"  class="t-DialogRegion #REGION_CSS_CLASSES# js-regionPopup" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="t-DialogRegion-wrap">',
'    <div class="t-DialogRegion-bodyWrapperOut"><div class="t-DialogRegion-bodyWrapperIn"><div class="t-DialogRegion-body">#BODY#</div></div></div>',
'    <div class="t-DialogRegion-buttons">',
'       <div class="t-ButtonRegion t-ButtonRegion--dialogRegion">',
'         <div class="t-ButtonRegion-wrap">',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--left"><div class="t-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--right"><div class="t-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'         </div>',
'       </div>',
'    </div>',
'  </div>',
'</div>',
'</div>'))
,p_page_plug_template_name=>'Inline Popup'
,p_internal_name=>'INLINE_POPUP'
,p_theme_id=>42
,p_theme_class_id=>24
,p_preset_template_options=>'js-dialog-size600x400'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(36341067236178344)
,p_plug_template_id=>wwv_flow_api.id(36340727081178326)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(591654834181983844)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-header">',
'        <h2 class="t-Alert-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'      </div>',
'      <div class="t-Alert-body">#BODY#</div>',
'    </div>',
'    <div class="t-Alert-buttons">#PREVIOUS##CLOSE##CREATE##NEXT#</div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Alert'
,p_internal_name=>'ALERT'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>21
,p_preset_template_options=>'t-Alert--horizontal:t-Alert--defaultIcons:t-Alert--warning'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(591655247569983854)
,p_plug_template_id=>wwv_flow_api.id(591654834181983844)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/interactive_report
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(651498026300583706)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="t-IRR-region #REGION_CSS_CLASSES#">',
'  <h2 class="u-VisuallyHidden" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'#PREVIOUS##BODY##SUB_REGIONS##NEXT#',
'</div>'))
,p_page_plug_template_name=>'Interactive Report'
,p_internal_name=>'INTERACTIVE_REPORT'
,p_theme_id=>42
,p_theme_class_id=>9
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(670020401234384587)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Wizard #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-Wizard-header">',
'    <h1 class="t-Wizard-title">#TITLE#</h1>',
'    <div class="u-Table t-Wizard-controls">',
'      <div class="u-Table-fit t-Wizard-buttons">#PREVIOUS##CLOSE#</div>',
'      <div class="u-Table-fill t-Wizard-steps">',
'        #BODY#',
'      </div>',
'      <div class="u-Table-fit t-Wizard-buttons">#NEXT#</div>',
'    </div>',
'  </div>',
'  <div class="t-Wizard-body">',
'    #SUB_REGIONS#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Wizard Container'
,p_internal_name=>'WIZARD_CONTAINER'
,p_theme_id=>42
,p_theme_class_id=>8
,p_preset_template_options=>'t-Wizard--hideStepsXSmall'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(2078063386176426255)
,p_plug_template_id=>wwv_flow_api.id(670020401234384587)
,p_name=>'Wizard Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>false
);
end;
/
prompt --application/shared_components/user_interface/templates/region/buttons_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(677400524731372757)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ButtonRegion t-Form--floatLeft #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-ButtonRegion-wrap">',
'    <div class="t-ButtonRegion-col t-ButtonRegion-col--left"><div class="t-ButtonRegion-buttons">#PREVIOUS##CLOSE##DELETE#</div></div>',
'    <div class="t-ButtonRegion-col t-ButtonRegion-col--content">',
'      <h2 class="t-ButtonRegion-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'      #BODY#',
'      <div class="t-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="t-ButtonRegion-col t-ButtonRegion-col--right"><div class="t-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Buttons Container'
,p_internal_name=>'BUTTONS_CONTAINER'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>17
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(677400902423372768)
,p_plug_template_id=>wwv_flow_api.id(677400524731372757)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(677401435884372770)
,p_plug_template_id=>wwv_flow_api.id(677400524731372757)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/content_block
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(873087052820635270)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ContentBlock #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-ContentBlock-header">',
'    <div class="t-ContentBlock-headerItems t-ContentBlock-headerItems--title">',
'      <span class="t-ContentBlock-headerIcon"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span></span>',
'      <h1 class="t-ContentBlock-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h1>',
'      #EDIT#',
'    </div>',
'    <div class="t-ContentBlock-headerItems t-ContentBlock-headerItems--buttons">#CHANGE#</div>',
'  </div>',
'  <div class="t-ContentBlock-body">#BODY#</div>',
'  <div class="t-ContentBlock-buttons">#PREVIOUS##NEXT#</div>',
'</div>',
''))
,p_page_plug_template_name=>'Content Block'
,p_internal_name=>'CONTENT_BLOCK'
,p_theme_id=>42
,p_theme_class_id=>21
,p_preset_template_options=>'t-ContentBlock--h1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/title_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1082434711915925186)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="t-BreadcrumbRegion #REGION_CSS_CLASSES#"> ',
'  <div class="t-BreadcrumbRegion-body">',
'    <div class="t-BreadcrumbRegion-breadcrumb">',
'      #BODY#',
'    </div>',
'    <div class="t-BreadcrumbRegion-title">',
'      <h1 class="t-BreadcrumbRegion-titleText">#TITLE#</h1>',
'    </div>',
'  </div>',
'  <div class="t-BreadcrumbRegion-buttons">#PREVIOUS##CLOSE##DELETE##HELP##CHANGE##EDIT##COPY##CREATE##NEXT#</div>',
'</div>'))
,p_page_plug_template_name=>'Title Bar'
,p_internal_name=>'TITLE_BAR'
,p_theme_id=>42
,p_theme_class_id=>6
,p_default_template_options=>'t-BreadcrumbRegion--showBreadcrumb'
,p_preset_template_options=>'t-BreadcrumbRegion--useBreadcrumbTitle'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/collapsible
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1215306280710140812)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Region t-Region--hideShow #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
' <div class="t-Region-header">',
'  <div class="t-Region-headerItems  t-Region-headerItems--controls"><button class="t-Button t-Button--icon t-Button--hideShow" type="button"></button></div>',
'  <div class="t-Region-headerItems t-Region-headerItems--title">',
'    <h2 class="t-Region-title">#TITLE#</h2>',
'  </div>',
'  <div class="t-Region-headerItems t-Region-headerItems--buttons">#EDIT#</div>',
' </div>',
' <div class="t-Region-bodyWrap">',
'   <div class="t-Region-buttons t-Region-buttons--top">',
'    <div class="t-Region-buttons-left">#CLOSE#</div>',
'    <div class="t-Region-buttons-right">#CREATE#</div>',
'   </div>',
'   <div class="t-Region-body">',
'     #COPY#',
'     #BODY#',
'     #SUB_REGIONS#',
'     #CHANGE#',
'   </div>',
'   <div class="t-Region-buttons t-Region-buttons--bottom">',
'    <div class="t-Region-buttons-left">#PREVIOUS#</div>',
'    <div class="t-Region-buttons-right">#NEXT#</div>',
'   </div>',
' </div>',
'</div>'))
,p_page_plug_template_name=>'Collapsible'
,p_internal_name=>'COLLAPSIBLE'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>1
,p_preset_template_options=>'is-expanded:t-Region--scrollBody'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1215306610603140813)
,p_plug_template_id=>wwv_flow_api.id(1215306280710140812)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1215307164553140813)
,p_plug_template_id=>wwv_flow_api.id(1215306280710140812)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/inline_dialog
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1223645131968329858)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#_parent">',
'<div id="#REGION_STATIC_ID#"  class="t-DialogRegion #REGION_CSS_CLASSES# js-regionDialog" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="t-DialogRegion-wrap">',
'    <div class="t-DialogRegion-bodyWrapperOut"><div class="t-DialogRegion-bodyWrapperIn"><div class="t-DialogRegion-body">#BODY#</div></div></div>',
'    <div class="t-DialogRegion-buttons">',
'       <div class="t-ButtonRegion t-ButtonRegion--dialogRegion">',
'         <div class="t-ButtonRegion-wrap">',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--left"><div class="t-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--right"><div class="t-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'         </div>',
'       </div>',
'    </div>',
'  </div>',
'</div>',
'</div>'))
,p_page_plug_template_name=>'Inline Dialog'
,p_internal_name=>'INLINE_DIALOG'
,p_theme_id=>42
,p_theme_class_id=>24
,p_default_template_options=>'js-modal:js-draggable:js-resizable'
,p_preset_template_options=>'js-dialog-size600x400'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(2078379876172179331)
,p_plug_template_id=>wwv_flow_api.id(1223645131968329858)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/hero
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1224989219520090364)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-HeroRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-HeroRegion-wrap">',
'    <div class="t-HeroRegion-col t-HeroRegion-col--left"><span class="t-HeroRegion-icon t-Icon #ICON_CSS_CLASSES#"></span></div>',
'    <div class="t-HeroRegion-col t-HeroRegion-col--content">',
'      <h1 class="t-HeroRegion-title">#TITLE#</h1>',
'      #BODY#',
'    </div>',
'    <div class="t-HeroRegion-col t-HeroRegion-col--right"><div class="t-HeroRegion-form">#SUB_REGIONS#</div><div class="t-HeroRegion-buttons">#NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Hero'
,p_internal_name=>'HERO'
,p_theme_id=>42
,p_theme_class_id=>22
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1412035210013638440)
,p_plug_template_id=>wwv_flow_api.id(1224989219520090364)
,p_name=>'Region Body'
,p_placeholder=>'#BODY#'
,p_has_grid_support=>false
,p_glv_new_row=>false
);
end;
/
prompt --application/shared_components/user_interface/templates/region/login
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1225129382632869472)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Login-region t-Form--stretchInputs t-Form--labelsAbove #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-Login-header">',
'    <span class="t-Login-logo #ICON_CSS_CLASSES#"></span>',
'    <h1 class="t-Login-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h1>',
'  </div>',
'  <div class="t-Login-body">#BODY#</div>',
'  <div class="t-Login-buttons">#NEXT#</div>',
'  <div class="t-Login-links">#EDIT##CREATE#</div>',
'  <div class="t-Login-subRegions">#SUB_REGIONS#</div>',
'</div>'))
,p_page_plug_template_name=>'Login'
,p_internal_name=>'LOGIN'
,p_theme_id=>42
,p_theme_class_id=>23
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1895482490835588056)
,p_plug_template_id=>wwv_flow_api.id(1225129382632869472)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/carousel_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1418258663404351882)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Region t-Region--carousel #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
' <div class="t-Region-header">',
'  <div class="t-Region-headerItems t-Region-headerItems--title">',
'    <span class="t-Region-headerIcon"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span></span>',
'    <h2 class="t-Region-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'  </div>',
'  <div class="t-Region-headerItems t-Region-headerItems--buttons">#COPY##EDIT#<span class="js-maximizeButtonContainer"></span></div>',
' </div>',
' <div class="t-Region-bodyWrap">',
'   <div class="t-Region-buttons t-Region-buttons--top">',
'    <div class="t-Region-buttons-left">#PREVIOUS#</div>',
'    <div class="t-Region-buttons-right">#NEXT#</div>',
'   </div>',
'   <div class="t-Region-body">',
'     #BODY#',
'   <div class="t-Region-carouselRegions">',
'     #SUB_REGIONS#',
'   </div>',
'   </div>',
'   <div class="t-Region-buttons t-Region-buttons--bottom">',
'    <div class="t-Region-buttons-left">#CLOSE##HELP#</div>',
'    <div class="t-Region-buttons-right">#DELETE##CHANGE##CREATE#</div>',
'   </div>',
' </div>',
'</div>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div data-label="#SUB_REGION_TITLE#" id="SR_#SUB_REGION_ID#">',
'  #SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'Carousel Container'
,p_internal_name=>'CAROUSEL_CONTAINER'
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#',
'#IMAGE_PREFIX#plugins/com.oracle.apex.carousel/1.1/com.oracle.apex.carousel#MIN#.js?v=#APEX_VERSION#'))
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>5
,p_default_template_options=>'t-Region--showCarouselControls'
,p_preset_template_options=>'t-Region--hiddenOverflow'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1418259019553351884)
,p_plug_template_id=>wwv_flow_api.id(1418258663404351882)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1418259515441351885)
,p_plug_template_id=>wwv_flow_api.id(1418258663404351882)
,p_name=>'Slides'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/tabs_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1774143203700285855)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-TabsRegion #REGION_CSS_CLASSES# apex-tabs-region" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  <div class="t-TabsRegion-items">',
'    #SUB_REGIONS#',
'  </div>',
'</div>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div data-label="#SUB_REGION_TITLE#" id="SR_#SUB_REGION_ID#">',
'  #SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'Tabs Container'
,p_internal_name=>'TABS_CONTAINER'
,p_javascript_file_urls=>'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#'
,p_theme_id=>42
,p_theme_class_id=>5
,p_preset_template_options=>'t-TabsRegion-mod--simple'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1774183925743302430)
,p_plug_template_id=>wwv_flow_api.id(1774143203700285855)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1777381553192669666)
,p_plug_template_id=>wwv_flow_api.id(1774143203700285855)
,p_name=>'Tabs'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/blank_with_attributes_no_grid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1922209187092703219)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="#REGION_CSS_CLASSES#">#PREVIOUS##BODY##SUB_REGIONS##NEXT#</div>'
,p_page_plug_template_name=>'Blank with Attributes (No Grid)'
,p_internal_name=>'BLANK_WITH_ATTRIBUTES_NO_GRID'
,p_theme_id=>42
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1922210004201708852)
,p_plug_template_id=>wwv_flow_api.id(1922209187092703219)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(1922210541525708854)
,p_plug_template_id=>wwv_flow_api.id(1922209187092703219)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/standard
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(2623330321607852408)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Region #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
' <div class="t-Region-header">',
'  <div class="t-Region-headerItems t-Region-headerItems--title">',
'    <span class="t-Region-headerIcon"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span></span>',
'    <h2 class="t-Region-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'  </div>',
'  <div class="t-Region-headerItems t-Region-headerItems--buttons">#COPY##EDIT#<span class="js-maximizeButtonContainer"></span></div>',
' </div>',
' <div class="t-Region-bodyWrap">',
'   <div class="t-Region-buttons t-Region-buttons--top">',
'    <div class="t-Region-buttons-left">#PREVIOUS#</div>',
'    <div class="t-Region-buttons-right">#NEXT#</div>',
'   </div>',
'   <div class="t-Region-body">',
'     #BODY#',
'     #SUB_REGIONS#',
'   </div>',
'   <div class="t-Region-buttons t-Region-buttons--bottom">',
'    <div class="t-Region-buttons-left">#CLOSE##HELP#</div>',
'    <div class="t-Region-buttons-right">#DELETE##CHANGE##CREATE#</div>',
'   </div>',
' </div>',
'</div>',
''))
,p_page_plug_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>8
,p_preset_template_options=>'t-Region--scrollBody'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(864307425592021306)
,p_plug_template_id=>wwv_flow_api.id(2623330321607852408)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(864307829600021306)
,p_plug_template_id=>wwv_flow_api.id(2623330321607852408)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/blank_with_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(3052412050530173647)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="#REGION_CSS_CLASSES#">#PREVIOUS##BODY##SUB_REGIONS##NEXT#</div>'
,p_page_plug_template_name=>'Blank with Attributes'
,p_internal_name=>'BLANK_WITH_ATTRIBUTES'
,p_theme_id=>42
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/top_navigation_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(5429749254678674)
,p_list_template_current=>'<li class="t-NavTabs-item #A03# is-active" id="#A01#"><a href="#LINK#" class="t-NavTabs-link #A04# " title="#TEXT_ESC_SC#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-NavTabs-label">#TEXT_ESC_SC#</span><span class'
||'="t-NavTabs-badge #A05#">#A02#</span></a></li>'
,p_list_template_noncurrent=>'<li class="t-NavTabs-item #A03#" id="#A01#"><a href="#LINK#" class="t-NavTabs-link #A04# " title="#TEXT_ESC_SC#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-NavTabs-label">#TEXT_ESC_SC#</span><span class="t-NavTab'
||'s-badge #A05#">#A02#</span></a></li>'
,p_list_template_name=>'Top Navigation Tabs'
,p_internal_name=>'TOP_NAVIGATION_TABS'
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-NavTabs--inlineLabels-lg:t-NavTabs--displayLabels-sm'
,p_list_template_before_rows=>'<ul class="t-NavTabs #COMPONENT_CSS_CLASSES#" id="#PARENT_STATIC_ID#_navtabs">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'List Item ID'
,p_a02_label=>'Badge Value'
,p_a03_label=>'List Item Class'
,p_a04_label=>'Link Class'
,p_a05_label=>'Badge Class'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(561120526789187584)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-WizardSteps-step is-active" id="#LIST_ITEM_ID#"><div class="t-WizardSteps-wrap" data-link="#LINK#"><span class="t-WizardSteps-marker"></span><span class="t-WizardSteps-label">#TEXT# <span class="t-WizardSteps-labelState"></span></span></'
||'div></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-WizardSteps-step" id="#LIST_ITEM_ID#"><div class="t-WizardSteps-wrap" data-link="#LINK#"><span class="t-WizardSteps-marker"></span><span class="t-WizardSteps-label">#TEXT# <span class="t-WizardSteps-labelState"></span></span></div></li>',
''))
,p_list_template_name=>'Wizard Progress'
,p_internal_name=>'WIZARD_PROGRESS'
,p_javascript_code_onload=>'apex.theme.initWizardProgressBar();'
,p_theme_id=>42
,p_theme_class_id=>17
,p_preset_template_options=>'t-WizardSteps--displayLabels'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="t-WizardSteps #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'))
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/menu_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(561127424267431983)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_name=>'Menu Bar'
,p_internal_name=>'MENU_BAR'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menubar", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup( e );',
'}',
'e.menu({',
'  behaveLikeTabs: e.hasClass("js-tabLike"),',
'  menubarShowSubMenuIcon: e.hasClass("js-showSubMenuIcons") || null,',
'  iconType: ''fa'',',
'  slide: e.hasClass("js-slide"),',
'  menubar: true,',
'  menubarOverflow: true,',
'  callout: e.hasClass("js-menu-callout")',
'});'))
,p_theme_id=>42
,p_theme_class_id=>20
,p_default_template_options=>'js-showSubMenuIcons'
,p_list_template_before_rows=>'<div class="t-MenuBar #COMPONENT_CSS_CLASSES#" id="#PARENT_STATIC_ID#_menubar"><ul style="display:none">'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/badge_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(614901035349879760)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item #A02#">',
'  <a class="t-BadgeList-wrap u-color #A04#" href="#LINK#" #A03#>',
'  <span class="t-BadgeList-label">#TEXT#</span>',
'  <span class="t-BadgeList-value">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item #A02#">',
'  <a class="t-BadgeList-wrap u-color #A04#" href="#LINK#" #A03#>',
'  <span class="t-BadgeList-label">#TEXT#</span>',
'  <span class="t-BadgeList-value">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_name=>'Badge List'
,p_internal_name=>'BADGE_LIST'
,p_theme_id=>42
,p_theme_class_id=>3
,p_preset_template_options=>'t-BadgeList--large:t-BadgeList--cols t-BadgeList--3cols:t-BadgeList--circular'
,p_list_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'Value'
,p_a02_label=>'List item CSS Classes'
,p_a03_label=>'Link Attributes'
,p_a04_label=>'Link Classes'
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'A01: Large Number',
'A02: List Item Classes',
'A03: Link Attributes'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(618966256865274517)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item is-active #A04#">',
'    <a href="#LINK#" class="t-MediaList-itemWrap #A05#" #A03#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#TEXT#</h3>',
'            <p class="t-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item  #A04#">',
'    <a href="#LINK#" class="t-MediaList-itemWrap #A05#" #A03#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#TEXT#</h3>',
'            <p class="t-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'Media List'
,p_internal_name=>'MEDIA_LIST'
,p_theme_id=>42
,p_theme_class_id=>5
,p_default_template_options=>'t-MediaList--showIcons:t-MediaList--showDesc'
,p_list_template_before_rows=>'<ul class="t-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'Description'
,p_a02_label=>'Badge Value'
,p_a03_label=>'Link Attributes'
,p_a04_label=>'List Item CSS Classes'
,p_a05_label=>'Link Class'
,p_a06_label=>'Icon Color Class'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/side_navigation_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1018710602436487872)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_name=>'Side Navigation Menu'
,p_internal_name=>'SIDE_NAVIGATION_MENU'
,p_javascript_file_urls=>'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.treeView#MIN#.js?v=#APEX_VERSION#'
,p_javascript_code_onload=>'apex.jQuery(''body'').addClass(''t-PageBody--leftNav'');'
,p_theme_id=>42
,p_theme_class_id=>19
,p_preset_template_options=>'js-navCollapsed--default:t-TreeNav--styleA'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-nav" id="t_Body_nav" role="navigation" aria-label="&APP_TITLE!ATTR.">',
'<div class="t-TreeNav #COMPONENT_CSS_CLASSES#" id="t_TreeNav" data-id="#PARENT_STATIC_ID#_tree" aria-label="&APP_TITLE!ATTR."><ul style="display:none">'))
,p_list_template_after_rows=>'</ul></div></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_a01_label=>'ID Attribute'
,p_a02_label=>'Disabled True/False'
,p_a04_label=>'Title'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/top_navigation_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1077726089382032168)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_name=>'Top Navigation Menu'
,p_internal_name=>'TOP_NAVIGATION_MENU'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("#t_MenuNav", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  if ( apex.actions ) {',
'    apex.actions.addFromMarkup( e );',
'  } else {',
'    apex.debug.warn("Include actions.js to support menu shortcuts");',
'  }',
'}',
'e.menu({',
'  behaveLikeTabs: e.hasClass("js-tabLike"),',
'  menubarShowSubMenuIcon: e.hasClass("js-showSubMenuIcons") || null,',
'  slide: e.hasClass("js-slide"),',
'  menubar: true,',
'  menubarOverflow: true,',
'  callout: e.hasClass("js-menu-callout")',
'});'))
,p_theme_id=>42
,p_theme_class_id=>20
,p_default_template_options=>'js-tabLike'
,p_list_template_before_rows=>'<div class="t-Header-nav-list #COMPONENT_CSS_CLASSES#" id="t_MenuNav"><ul style="display:none">'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_a01_label=>'ID Attribute'
,p_a02_label=>'Disabled True / False'
,p_a03_label=>'Hide'
,p_a04_label=>'Title Attribute'
,p_a05_label=>'Shortcut Key'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/navigation_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1398514441042912293)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item is-active #A02#">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item #A02#">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_name=>'Navigation Bar'
,p_internal_name=>'NAVIGATION_BAR'
,p_theme_id=>42
,p_theme_class_id=>20
,p_list_template_before_rows=>'<ul class="t-NavigationBar #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<div class="t-NavigationBar-menu" style="display: none" id="menu_#PARENT_LIST_ITEM_ID#"><ul>'
,p_after_sub_list=>'</ul></div></li>'
,p_sub_list_item_current=>'<li data-current="true" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-current="false" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item is-active #A02#">',
'  <button class="t-Button t-Button--icon t-Button t-Button--header t-Button--navBar js-menuButton" type="button" id="#LIST_ITEM_ID#" data-menu="menu_#LIST_ITEM_ID#">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span><span class="a-Icon icon-down-arrow"></span>',
'  </button>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item #A02#">',
'  <button class="t-Button t-Button--icon t-Button t-Button--header t-Button--navBar js-menuButton" type="button" id="#LIST_ITEM_ID#" data-menu="menu_#LIST_ITEM_ID#">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span><span class="a-Icon icon-down-arrow"></span>',
'  </button>'))
,p_sub_templ_curr_w_child=>'<li data-current="true" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li data-current="false" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_a01_label=>'Badge Value'
,p_a02_label=>'List  Item CSS Classes'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/cards
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1437740873962425604)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item is-active #A04#">',
'  <div class="t-Card">',
'    <a href="#LINK#" class="t-Card-wrap" #A05#>',
'      <div class="t-Card-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#"><span class="t-Card-initials" role="presentation">#A03#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#TEXT#</h3><h4 class="t-Card-subtitle">#A07#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#A01#</div>',
'        <div class="t-Card-info">#A02#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #A06#"></span>',
'    </a>',
'  </div>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item #A04#">',
'  <div class="t-Card">',
'    <a href="#LINK#" class="t-Card-wrap" #A05#>',
'      <div class="t-Card-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#"><span class="t-Card-initials" role="presentation">#A03#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#TEXT#</h3><h4 class="t-Card-subtitle">#A07#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#A01#</div>',
'        <div class="t-Card-info">#A02#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #A06#"></span>',
'    </a>',
'  </div>',
'</li>'))
,p_list_template_name=>'Cards'
,p_internal_name=>'CARDS'
,p_theme_id=>42
,p_theme_class_id=>4
,p_preset_template_options=>'t-Cards--animColorFill:t-Cards--3cols:t-Cards--basic'
,p_list_template_before_rows=>'<ul class="t-Cards #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'Description'
,p_a02_label=>'Secondary Information'
,p_a03_label=>'Initials'
,p_a04_label=>'List Item CSS Classes'
,p_a05_label=>'Link Attributes'
,p_a06_label=>'Card Color Class'
,p_a07_label=>'Subtitle'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1840624874773603093)
,p_list_template_current=>'<li class="t-Tabs-item is-active"><a href="#LINK#" class="t-Tabs-link"><span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Tabs-label">#TEXT#</span></a></li>'
,p_list_template_noncurrent=>'<li class="t-Tabs-item"><a href="#LINK#" class="t-Tabs-link"><span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Tabs-label">#TEXT#</span></a></li>'
,p_list_template_name=>'Tabs'
,p_internal_name=>'TABS'
,p_javascript_file_urls=>'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#'
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-Tabs--simple'
,p_list_template_before_rows=>'<ul class="t-Tabs #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2044682192514224742)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'Menu Popup'
,p_internal_name=>'MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup( e );',
'}',
'e.menu({ slide: e.hasClass("js-slide"), iconType: ''fa'', callout: e.hasClass("js-menu-callout")});'))
,p_theme_id=>42
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_a01_label=>'Data ID'
,p_a02_label=>'Disabled (True/False)'
,p_a03_label=>'Hidden (True/False)'
,p_a04_label=>'Title Attribute'
,p_a05_label=>'Shortcut'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(2623332529225852414)
,p_list_template_current=>'<li class="t-LinksList-item is-current #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-b'
||'adge">#A01#</span></a></li>'
,p_list_template_noncurrent=>'<li class="t-LinksList-item #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_name=>'Links List'
,p_internal_name=>'LINKS_LIST'
,p_theme_id=>42
,p_theme_class_id=>18
,p_list_template_before_rows=>'<ul class="t-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul class="t-LinksList-list">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="t-LinksList-item is-current #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-b'
||'adge">#A01#</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="t-LinksList-item #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-badge">#A01#'
||'</span></a></li>'
,p_item_templ_curr_w_child=>'<li class="t-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t'
||'-LinksList-badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="t-LinksList-item #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-badge">#A01#'
||'</span></a></li>'
,p_a01_label=>'Badge Value'
,p_a02_label=>'Link Attributes'
,p_a03_label=>'List Item CSS Classes'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/timeline
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(65791776421862960)
,p_row_template_name=>'Timeline'
,p_internal_name=>'TIMELINE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Timeline-item #EVENT_MODIFIERS#" #EVENT_ATTRIBUTES#>',
'  <div class="t-Timeline-wrap">',
'    <div class="t-Timeline-user">',
'      <div class="t-Timeline-avatar #USER_COLOR#">',
'        #USER_AVATAR#',
'      </div>',
'      <div class="t-Timeline-userinfo">',
'        <span class="t-Timeline-username">#USER_NAME#</span>',
'        <span class="t-Timeline-date">#EVENT_DATE#</span>',
'      </div>',
'    </div>',
'    <div class="t-Timeline-content">',
'      <div class="t-Timeline-typeWrap">',
'        <div class="t-Timeline-type #EVENT_STATUS#">',
'          <span class="t-Icon #EVENT_ICON#"></span>',
'          <span class="t-Timeline-typename">#EVENT_TYPE#</span>',
'        </div>',
'      </div>',
'      <div class="t-Timeline-body">',
'        <h3 class="t-Timeline-title">#EVENT_TITLE#</h3>',
'        <p class="t-Timeline-desc">#EVENT_DESC#</p>',
'      </div>',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_condition1=>':EVENT_LINK is null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Timeline-item #EVENT_MODIFIERS#" #EVENT_ATTRIBUTES#>',
'  <a href="#EVENT_LINK#" class="t-Timeline-wrap">',
'    <div class="t-Timeline-user">',
'      <div class="t-Timeline-avatar #USER_COLOR#">',
'        #USER_AVATAR#',
'      </div>',
'      <div class="t-Timeline-userinfo">',
'        <span class="t-Timeline-username">#USER_NAME#</span>',
'        <span class="t-Timeline-date">#EVENT_DATE#</span>',
'      </div>',
'    </div>',
'    <div class="t-Timeline-content">',
'      <div class="t-Timeline-typeWrap">',
'        <div class="t-Timeline-type #EVENT_STATUS#">',
'          <span class="t-Icon #EVENT_ICON#"></span>',
'          <span class="t-Timeline-typename">#EVENT_TYPE#</span>',
'        </div>',
'      </div>',
'      <div class="t-Timeline-body">',
'        <h3 class="t-Timeline-title">#EVENT_TITLE#</h3>',
'        <p class="t-Timeline-desc">#EVENT_DESC#</p>',
'      </div>',
'    </div>',
'  </a>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-Timeline #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_timeline" data-region-id="#REGION_STATIC_ID#">',
''))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/content_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(350261643030073247)
,p_row_template_name=>'Content Row'
,p_internal_name=>'CONTENT_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-ContentRow-item #ITEM_CLASSES#">',
'  <div class="t-ContentRow-wrap">',
'    <div class="t-ContentRow-selection">#SELECTION#</div>',
'    <div class="t-ContentRow-iconWrap">',
'      <span class="t-ContentRow-icon #ICON_CLASS#">#ICON_HTML#</span>',
'    </div>',
'    <div class="t-ContentRow-body">',
'      <div class="t-ContentRow-content">',
'        <h3 class="t-ContentRow-title">#TITLE#</h3>',
'        <div class="t-ContentRow-description">#DESCRIPTION#</div>',
'      </div>',
'      <div class="t-ContentRow-misc">#MISC#</div>',
'      <div class="t-ContentRow-actions">#ACTIONS#</div>',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-ContentRow #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'#PAGINATION#'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>4
);
end;
/
prompt --application/shared_components/user_interface/templates/report/media_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(644575648490092151)
,p_row_template_name=>'Media List'
,p_internal_name=>'MEDIA_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item #LIST_CLASS#">',
'    <a href="#LINK#" class="t-MediaList-itemWrap #LINK_CLASS#" #LINK_ATTR#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #ICON_COLOR_CLASS#"><span class="t-Icon #ICON_CLASS#"></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#LIST_TITLE#</h3>',
'            <p class="t-MediaList-desc">#LIST_TEXT#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#LIST_BADGE#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_row_template_condition1=>':LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item #LIST_CLASS#">',
'    <div class="t-MediaList-itemWrap #LINK_CLASS#" #LINK_ATTR#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #ICON_COLOR_CLASS#"><span class="t-Icon #ICON_CLASS#"></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#LIST_TITLE#</h3>',
'            <p class="t-MediaList-desc">#LIST_TEXT#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#LIST_BADGE#</span>',
'        </div>',
'    </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-MediaList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_report" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>1
,p_default_template_options=>'t-MediaList--showDesc:t-MediaList--showIcons'
,p_preset_template_options=>'t-MediaList--stack'
,p_row_template_comment=>' (SELECT link_text, link_target, detail1, detail2, last_modified)'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/value_attribute_pairs_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(651486509760474849)
,p_row_template_name=>'Value Attribute Pairs - Row'
,p_internal_name=>'VALUE_ATTRIBUTE_PAIRS_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<dt class="t-AVPList-label">',
'  #1#',
'</dt>',
'<dd class="t-AVPList-value">',
'  #2#',
'</dd>'))
,p_row_template_before_rows=>'<dl class="t-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</dl>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-AVPList--leftAligned'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/value_attribute_pairs_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(651486824354474850)
,p_row_template_name=>'Value Attribute Pairs - Column'
,p_internal_name=>'VALUE_ATTRIBUTE_PAIRS_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<dt class="t-AVPList-label">',
'  #COLUMN_HEADER#',
'</dt>',
'<dd class="t-AVPList-value">',
'  #COLUMN_VALUE#',
'</dd>'))
,p_row_template_before_rows=>'<dl class="t-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</dl>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>6
,p_preset_template_options=>'t-AVPList--leftAligned'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/badge_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(655615347857707855)
,p_row_template_name=>'Badge List'
,p_internal_name=>'BADGE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
' <span class="t-BadgeList-wrap u-color">',
'  <span class="t-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="t-BadgeList-value">#COLUMN_VALUE#</span>',
' </span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>6
,p_preset_template_options=>'t-BadgeList--large:t-BadgeList--fixed:t-BadgeList--circular'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1089625725920080767)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td class="t-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES# data-region-id="#REGION_STATIC_ID#">',
'  <div class="t-Report-wrap">',
'    <table class="t-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="t-Report-tableWrap">',
'    <table class="t-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="t-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="t-Report-pagination t-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="t-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</thead>',
'<tbody>'))
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>4
,p_preset_template_options=>'t-Report--altRowsDefault:t-Report--rowHighlight'
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1089625725920080767)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/comments
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1164140200812557328)
,p_row_template_name=>'Comments'
,p_internal_name=>'COMMENTS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Comments-item #COMMENT_MODIFIERS#">',
'    <div class="t-Comments-icon">',
'        <div class="t-Comments-userIcon #ICON_MODIFIER#" aria-hidden="true">#USER_ICON#</div>',
'    </div>',
'    <div class="t-Comments-body">',
'        <div class="t-Comments-info">',
'            #USER_NAME# <span class="t-Comments-date">#COMMENT_DATE#</span> <span class="t-Comments-actions">#ACTIONS#</span>',
'        </div>',
'        <div class="t-Comments-comment">',
'            #COMMENT_TEXT##ATTRIBUTE_1##ATTRIBUTE_2##ATTRIBUTE_3##ATTRIBUTE_4#',
'        </div>',
'    </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-Comments #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_report" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>',
''))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-Comments--chat'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/alerts
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1433874327034140123)
,p_row_template_name=>'Alerts'
,p_internal_name=>'ALERTS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--horizontal t-Alert--colorBG t-Alert--defaultIcons t-Alert--#ALERT_TYPE#" role="alert">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-header">',
'        <h2 class="t-Alert-title">#ALERT_TITLE#</h2>',
'      </div>',
'      <div class="t-Alert-body">',
'        #ALERT_DESC#',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      #ALERT_ACTION#',
'    </div>',
'  </div>',
'</div>'))
,p_row_template_before_rows=>'<div class="t-Alerts #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_alerts" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>14
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/cards
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1525953837592492828)
,p_row_template_name=>'Cards'
,p_internal_name=>'CARDS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item #CARD_MODIFIERS#">',
'  <div class="t-Card">',
'    <a href="#CARD_LINK#" class="t-Card-wrap">',
'      <div class="t-Card-icon u-color #CARD_COLOR#"><span class="t-Icon fa #CARD_ICON#"><span class="t-Card-initials" role="presentation">#CARD_INITIALS#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#CARD_TITLE#</h3><h4 class="t-Card-subtitle">#CARD_SUBTITLE#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#CARD_TEXT#</div>',
'        <div class="t-Card-info">#CARD_SUBTEXT#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #CARD_COLOR#"></span>',
'    </a>',
'  </div>',
'</li>'))
,p_row_template_condition1=>':CARD_LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item #CARD_MODIFIERS#">',
'  <div class="t-Card">',
'    <div class="t-Card-wrap">',
'      <div class="t-Card-icon u-color #CARD_COLOR#"><span class="t-Icon fa #CARD_ICON#"><span class="t-Card-initials" role="presentation">#CARD_INITIALS#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#CARD_TITLE#</h3><h4 class="t-Card-subtitle">#CARD_SUBTITLE#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#CARD_TEXT#</div>',
'        <div class="t-Card-info">#CARD_SUBTEXT#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #CARD_COLOR#"></span>',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-Cards #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_cards" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-Cards--animColorFill:t-Cards--3cols:t-Cards--basic'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/search_results
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(2623331619605852412)
,p_row_template_name=>'Search Results'
,p_internal_name=>'SEARCH_RESULTS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'    </div>',
'  </li>'))
,p_row_template_condition1=>':LABEL_02 is null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'      <span class="t-SearchResults-misc">#LABEL_02#: #VALUE_02#</span>',
'    </div>',
'  </li>'))
,p_row_template_condition2=>':LABEL_03 is null'
,p_row_template3=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'      <span class="t-SearchResults-misc">#LABEL_02#: #VALUE_02#</span>',
'      <span class="t-SearchResults-misc">#LABEL_03#: #VALUE_03#</span>',
'    </div>',
'  </li>'))
,p_row_template_condition3=>':LABEL_04 is null'
,p_row_template4=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'      <span class="t-SearchResults-misc">#LABEL_02#: #VALUE_02#</span>',
'      <span class="t-SearchResults-misc">#LABEL_03#: #VALUE_03#</span>',
'      <span class="t-SearchResults-misc">#LABEL_04#: #VALUE_04#</span>',
'    </div>',
'  </li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-SearchResults #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_report" data-region-id="#REGION_STATIC_ID#">',
'<ul class="t-SearchResults-list">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>',
'</div>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_row_template_comment=>' (SELECT link_text, link_target, detail1, detail2, last_modified)'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_floating
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(160093352808944961)
,p_template_name=>'Optional - Floating'
,p_internal_name=>'OPTIONAL_FLOATING'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--floatingLabel #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/required_floating
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(160093532401945979)
,p_template_name=>'Required - Floating'
,p_internal_name=>'REQUIRED_FLOATING'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'  <label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--floatingLabel is-required #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(591757292230152601)
,p_template_name=>'Hidden'
,p_internal_name=>'HIDDEN'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer t-Form-labelContainer--hiddenLabel col col-#LABEL_COLUMN_SPAN_NUMBER#">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label u-VisuallyHidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--hiddenLabel rel-col #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer col col-#ITEM_COLUMN_SPAN_NUMBER#"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>13
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(869572400154599626)
,p_template_name=>'Optional'
,p_internal_name=>'OPTIONAL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer col col-#LABEL_COLUMN_SPAN_NUMBER#">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>',
''))
,p_before_item=>'<div class="t-Form-fieldContainer rel-col #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer col col-#ITEM_COLUMN_SPAN_NUMBER#"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1077732000333505897)
,p_template_name=>'Required'
,p_internal_name=>'REQUIRED'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer col col-#LABEL_COLUMN_SPAN_NUMBER#">',
'  <label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer is-required rel-col #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer col col-#ITEM_COLUMN_SPAN_NUMBER#"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1582533052086761500)
,p_template_name=>'Optional - Above'
,p_internal_name=>'OPTIONAL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/required_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1582533317526763209)
,p_template_name=>'Required - Above'
,p_internal_name=>'REQUIRED_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'  <label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label> #HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--stacked is-required #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(2623334730651852421)
,p_name=>'Breadcrumb'
,p_internal_name=>'BREADCRUMB'
,p_before_first=>'<ul class="t-Breadcrumb #COMPONENT_CSS_CLASSES#">'
,p_current_page_option=>'<li class="t-Breadcrumb-item is-active"><h1 class="t-Breadcrumb-label">#NAME#</h1></li>'
,p_non_current_page_option=>'<li class="t-Breadcrumb-item"><a href="#LINK#" class="t-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>42
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(1437816705917664972)
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#THEME_STYLE_CSS#',
'#FAVICONS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="t-Page t-Page--popupLOV"'
,p_before_field_text=>'<div class="t-PopupLOV-actions t-Form--large">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="apex-item-text"'
,p_find_button_text=>'Search'
,p_find_button_attr=>'class="t-Button t-Button--hot t-Button--padLeft"'
,p_close_button_text=>'Close'
,p_close_button_attr=>'class="t-Button u-pullRight"'
,p_next_button_text=>'Next &gt;'
,p_next_button_attr=>'class="t-Button t-PopupLOV-button"'
,p_prev_button_text=>'&lt; Previous'
,p_prev_button_attr=>'class="t-Button t-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_result_row_x_of_y=>'<div class="t-PopupLOV-pagination">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>100
,p_before_result_set=>'<div class="t-PopupLOV-links">'
,p_theme_id=>42
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(2623334936060852422)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th id="#DY#" scope="col" class="t-ClassicCalendar-dayColumn">',
'  <span class="visible-md visible-lg">#IDAY#</span>',
'  <span class="hidden-md hidden-lg">#IDY#</span>',
'</th>'))
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar">',
'<h1 class="t-ClassicCalendar-title">#IMONTH# #YYYY#</h1>'))
,p_month_open_format=>'<table class="t-ClassicCalendar-calendar" cellpadding="0" cellspacing="0" border="0" aria-label="#IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>',
''))
,p_day_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#">#TITLE_FORMAT#<div class="t-ClassicCalendar-dayEvents">#DATA#</div>'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#">#TITLE_FORMAT#<div class="t-ClassicCalendar-dayEvents">#DATA#</div>'
,p_weekend_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_weekend_open_format=>'<td class="t-ClassicCalendar-day is-weekend" headers="#DY#">#TITLE_FORMAT#<div class="t-ClassicCalendar-dayEvents">#DATA#</div>'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_nonday_open_format=>'<td class="t-ClassicCalendar-day is-inactive" headers="#DY#">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar t-ClassicCalendar--weekly">',
'<h1 class="t-ClassicCalendar-title">#WTITLE#</h1>'))
,p_weekly_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th scope="col" class="t-ClassicCalendar-dayColumn" id="#DY#">',
'  <span class="visible-md visible-lg">#DD# #IDAY#</span>',
'  <span class="hidden-md hidden-lg">#DD# #IDY#</span>',
'</th>'))
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" aria-label="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t-ClassicCalendar-calendar">'
,p_weekly_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_weekly_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_weekly_day_close_format=>'</div></td>'
,p_weekly_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_weekly_weekend_open_format=>'<td class="t-ClassicCalendar-day is-weekend" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_weekly_weekend_close_format=>'</div></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t-ClassicCalendar-day t-ClassicCalendar-timeCol">'
,p_weekly_time_close_format=>'</th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" id="#DY#" class="t-ClassicCalendar-dayColumn">#IDAY#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar t-ClassicCalendar--daily">',
'<h1 class="t-ClassicCalendar-title">#IMONTH# #DD#, #YYYY#</h1>'))
,p_daily_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" aria-label="#CALENDAR_TITLE# #START_DL#" class="t-ClassicCalendar-calendar">'
,p_daily_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_daily_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_daily_day_close_format=>'</div></td>'
,p_daily_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_daily_time_open_format=>'<th scope="row" class="t-ClassicCalendar-day t-ClassicCalendar-timeCol" id="#TIME#">'
,p_daily_time_close_format=>'</th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar">',
'<h1 class="t-ClassicCalendar-title">#IMONTH# #YYYY#</h1>'))
,p_cust_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th id="#DY#" scope="col" class="t-ClassicCalendar-dayColumn">',
'  <span class="visible-md visible-lg">#IDAY#</span>',
'  <span class="hidden-md hidden-lg">#IDY#</span>',
'</th>'))
,p_cust_month_open_format=>'<table class="t-ClassicCalendar-calendar" cellpadding="0" cellspacing="0" border="0" aria-label="#IMONTH# #YYYY#">'
,p_cust_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_cust_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#">'
,p_cust_nonday_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_cust_nonday_open_format=>'<td class="t-ClassicCalendar-day is-inactive" headers="#DY#">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_cust_weekend_open_format=>'<td class="t-ClassicCalendar-day is-weekend" headers="#DY#">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th scope="row" class="t-ClassicCalendar-day t-ClassicCalendar-timeCol">'
,p_cust_time_close_format=>'</th>'
,p_cust_wk_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar">',
'<h1 class="t-ClassicCalendar-title">#WTITLE#</h1>'))
,p_cust_wk_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th scope="col" class="t-ClassicCalendar-dayColumn" id="#DY#">',
'  <span class="visible-md visible-lg">#DD# #IDAY#</span>',
'  <span class="hidden-md hidden-lg">#DD# #IDY#</span>',
'</th>'))
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t-ClassicCalendar-calendar">'
,p_cust_wk_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_cust_wk_week_open_format=>'<tr>'
,p_cust_wk_week_close_format=>'</tr> '
,p_cust_wk_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_cust_wk_day_close_format=>'</div></td>'
,p_cust_wk_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_cust_wk_weekend_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#">'
,p_cust_wk_weekend_close_format=>'</td>'
,p_agenda_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar t-ClassicCalendar--list">',
'  <div class="t-ClassicCalendar-title">#IMONTH# #YYYY#</div>',
'  <ul class="t-ClassicCalendar-list">',
'    #DAYS#',
'  </ul>',
'</div>'))
,p_agenda_past_day_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-ClassicCalendar-listTitle is-past">',
'    <span class="t-ClassicCalendar-listDayTitle">#IDAY#</span><span class="t-ClassicCalendar-listDayDate">#IMONTH# #DD#</span>',
'  </li>'))
,p_agenda_today_day_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-ClassicCalendar-listTitle is-today">',
'    <span class="t-ClassicCalendar-listDayTitle">#IDAY#</span><span class="t-ClassicCalendar-listDayDate">#IMONTH# #DD#</span>',
'  </li>'))
,p_agenda_future_day_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-ClassicCalendar-listTitle is-future">',
'    <span class="t-ClassicCalendar-listDayTitle">#IDAY#</span><span class="t-ClassicCalendar-listDayDate">#IMONTH# #DD#</span>',
'  </li>'))
,p_agenda_past_entry_format=>'  <li class="t-ClassicCalendar-listEvent is-past">#DATA#</li>'
,p_agenda_today_entry_format=>'  <li class="t-ClassicCalendar-listEvent is-today">#DATA#</li>'
,p_agenda_future_entry_format=>'  <li class="t-ClassicCalendar-listEvent is-future">#DATA#</li>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'<span class="t-ClassicCalendar-event">#DATA#</span>'
,p_theme_id=>42
,p_theme_class_id=>1
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_api.create_theme(
 p_id=>wwv_flow_api.id(2623335322494852446)
,p_theme_id=>42
,p_theme_name=>'Universal Theme'
,p_theme_internal_name=>'UNIVERSAL_THEME'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'L'
,p_nav_bar_type=>'LIST'
,p_is_locked=>false
,p_default_page_template=>wwv_flow_api.id(2623327345562852400)
,p_default_dialog_template=>wwv_flow_api.id(651378991620880020)
,p_error_template=>wwv_flow_api.id(652129338145143712)
,p_printer_friendly_template=>wwv_flow_api.id(2623327345562852400)
,p_breadcrumb_display_point=>'REGION_POSITION_01'
,p_sidebar_display_point=>'REGION_POSITION_02'
,p_login_template=>wwv_flow_api.id(652129338145143712)
,p_default_button_template=>wwv_flow_api.id(2623334346116852418)
,p_default_region_template=>wwv_flow_api.id(2623330321607852408)
,p_default_chart_template=>wwv_flow_api.id(2623330321607852408)
,p_default_form_template=>wwv_flow_api.id(2623330321607852408)
,p_default_reportr_template=>wwv_flow_api.id(2623330321607852408)
,p_default_tabform_template=>wwv_flow_api.id(2623330321607852408)
,p_default_wizard_template=>wwv_flow_api.id(2623330321607852408)
,p_default_menur_template=>wwv_flow_api.id(1082434711915925186)
,p_default_listr_template=>wwv_flow_api.id(2623330321607852408)
,p_default_irr_template=>wwv_flow_api.id(651498026300583706)
,p_default_report_template=>wwv_flow_api.id(1089625725920080767)
,p_default_label_template=>wwv_flow_api.id(160093352808944961)
,p_default_menu_template=>wwv_flow_api.id(2623334730651852421)
,p_default_calendar_template=>wwv_flow_api.id(2623334936060852422)
,p_default_list_template=>wwv_flow_api.id(2623332529225852414)
,p_default_nav_list_template=>wwv_flow_api.id(1077726089382032168)
,p_default_top_nav_list_temp=>wwv_flow_api.id(1077726089382032168)
,p_default_side_nav_list_temp=>wwv_flow_api.id(1018710602436487872)
,p_default_nav_list_position=>'SIDE'
,p_default_dialogbtnr_template=>wwv_flow_api.id(677400524731372757)
,p_default_dialogr_template=>wwv_flow_api.id(3052412050530173647)
,p_default_option_label=>wwv_flow_api.id(160093352808944961)
,p_default_required_label=>wwv_flow_api.id(160093532401945979)
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_default_navbar_list_template=>wwv_flow_api.id(1398514441042912293)
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(42),'#IMAGE_PREFIX#themes/theme_42/1.4/')
,p_files_version=>64
,p_icon_library=>'FONTAPEX'
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.stickyWidget#MIN#.js?v=#APEX_VERSION#',
'#THEME_IMAGES#js/theme42#MIN#.js?v=#APEX_VERSION#'))
,p_css_file_urls=>'#THEME_IMAGES#css/Core#MIN#.css?v=#APEX_VERSION#'
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(490875900505711269)
,p_theme_id=>42
,p_name=>'Vita - Red'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita-Red.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita-Red#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(1272293502653387589)
,p_theme_id=>42
,p_name=>'Vita'
,p_is_current=>true
,p_is_public=>true
,p_is_accessible=>true
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(1844401536064988062)
,p_theme_id=>42
,p_name=>'Vita - Slate'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita-Slate.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita-Slate#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(2095766600097112746)
,p_theme_id=>42
,p_name=>'Vita - Dark'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita-Dark.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita-Dark#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(2560094491605782871)
,p_theme_id=>42
,p_name=>'Vista'
,p_css_file_urls=>'#THEME_IMAGES#css/Vista#MIN#.css?v=#APEX_VERSION#'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_read_only=>true
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(215635458665067919)
,p_theme_id=>42
,p_name=>'ICON_HOVER_ANIMATION'
,p_display_name=>'Icon Hover Animation'
,p_display_sequence=>55
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(238836143358553477)
,p_theme_id=>42
,p_name=>'PAGE_LAYOUT'
,p_display_name=>'Page Layout'
,p_display_sequence=>10
,p_template_types=>'PAGE'
,p_null_text=>'Floating (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(238836456250556001)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND'
,p_display_name=>'Page Background'
,p_display_sequence=>20
,p_template_types=>'PAGE'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(240331572408240607)
,p_theme_id=>42
,p_name=>'ICON_SHAPE'
,p_display_name=>'Icon Shape'
,p_display_sequence=>60
,p_template_types=>'LIST'
,p_help_text=>'Determines the shape of the icon.'
,p_null_text=>'Circle'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(240331900166242117)
,p_theme_id=>42
,p_name=>'ICON_SHAPE'
,p_display_name=>'Icon Shape'
,p_display_sequence=>60
,p_template_types=>'REPORT'
,p_help_text=>'Determines the shape of the icon.'
,p_null_text=>'Circle'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(240334389763319806)
,p_theme_id=>42
,p_name=>'COLLAPSIBLE_ICON_POSITION'
,p_display_name=>'Collapsible Icon Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Determines the position of the expand and collapse toggle for the region.'
,p_null_text=>'Start'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(240335211940344543)
,p_theme_id=>42
,p_name=>'COLLAPSIBLE_BUTTON_ICONS'
,p_display_name=>'Collapsible Button Icons'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Determines which arrows to use to represent the icons for the collapse and expand button.'
,p_null_text=>'Arrows'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(253590311653377102)
,p_theme_id=>42
,p_name=>'ICON_SHAPE'
,p_display_name=>'Icon Shape'
,p_display_sequence=>60
,p_template_types=>'REGION'
,p_help_text=>'Determines the shape of the icon.'
,p_null_text=>'Rounded Corners'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(254246764314801329)
,p_theme_id=>42
,p_name=>'CALLOUT_POSITION'
,p_display_name=>'Callout Position'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Determines where the callout for the popup will be positioned relative to its parent.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(323023042025382157)
,p_theme_id=>42
,p_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_sequence=>90
,p_template_types=>'LIST'
,p_help_text=>'Determines the display for a desktop-sized screen'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(323023383838383536)
,p_theme_id=>42
,p_name=>'MOBILE'
,p_display_name=>'Mobile'
,p_display_sequence=>100
,p_template_types=>'LIST'
,p_help_text=>'Determines the display for a mobile-sized screen'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(330622871777976980)
,p_theme_id=>42
,p_name=>'LOGIN_HEADER'
,p_display_name=>'Login Header'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Controls the display of the Login region header.'
,p_null_text=>'Icon and Title (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(341348731255729287)
,p_theme_id=>42
,p_name=>'COLLAPSE_STYLE'
,p_display_name=>'Collapse Mode'
,p_display_sequence=>30
,p_template_types=>'LIST'
,p_null_text=>'Icon (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(350784197398221961)
,p_theme_id=>42
,p_name=>'COL_SELECTION'
,p_display_name=>'Selection'
,p_display_sequence=>100
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(350784424517223601)
,p_theme_id=>42
,p_name=>'COL_ICON'
,p_display_name=>'Icon'
,p_display_sequence=>110
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(350784797183225680)
,p_theme_id=>42
,p_name=>'COL_CONTENT_TITLE'
,p_display_name=>'Title'
,p_display_sequence=>120
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(350785031716227530)
,p_theme_id=>42
,p_name=>'COL_CONTENT_DESCRIPTION'
,p_display_name=>'Description'
,p_display_sequence=>130
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(350785337301229407)
,p_theme_id=>42
,p_name=>'COL_MISC'
,p_display_name=>'Misc'
,p_display_sequence=>140
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(350785675912230663)
,p_theme_id=>42
,p_name=>'COL_ACTIONS'
,p_display_name=>'Actions'
,p_display_sequence=>150
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(355501396300309305)
,p_theme_id=>42
,p_name=>'CONTENT_ALIGNMENT'
,p_display_name=>'Content Alignment'
,p_display_sequence=>90
,p_template_types=>'REPORT'
,p_null_text=>'Center (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(385801771488104515)
,p_theme_id=>42
,p_name=>'PAGINATION_DISPLAY'
,p_display_name=>'Pagination Display'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Controls the display of pagination for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(446733723296185373)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>35
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(582142591229178435)
,p_theme_id=>42
,p_name=>'SPACING_TOP'
,p_display_name=>'Spacing Top'
,p_display_sequence=>90
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the top of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(582143096365182722)
,p_theme_id=>42
,p_name=>'SPACING_BOTTOM'
,p_display_name=>'Spacing Bottom'
,p_display_sequence=>100
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the bottom of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686928892790028100)
,p_theme_id=>42
,p_name=>'ICON_STYLE'
,p_display_name=>'Icon Style'
,p_display_sequence=>35
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686929122234028100)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>10
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the size of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686929314140028100)
,p_theme_id=>42
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686930381900028100)
,p_theme_id=>42
,p_name=>'ALERT_DISPLAY'
,p_display_name=>'Alert Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the layout of the Alert Region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686930518563028100)
,p_theme_id=>42
,p_name=>'HEADER'
,p_display_name=>'Header'
,p_display_sequence=>20
,p_template_types=>'REGION'
,p_help_text=>'Determines the display of the Region Header which also contains the Region Title.'
,p_null_text=>'Visible - Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686930602304028100)
,p_theme_id=>42
,p_name=>'LABEL_DISPLAY'
,p_display_name=>'Label Display'
,p_display_sequence=>50
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686930751269028100)
,p_theme_id=>42
,p_name=>'ALTERNATING_ROWS'
,p_display_name=>'Alternating Rows'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Shades alternate rows in the report with slightly different background colors.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686930833556028100)
,p_theme_id=>42
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>50
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the position of the icon relative to the label.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686931442667028100)
,p_theme_id=>42
,p_name=>'BODY_OVERFLOW'
,p_display_name=>'Body Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Determines the scroll behavior when the region contents are larger than their container.'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686931906521028101)
,p_theme_id=>42
,p_name=>'ITEM_SIZE'
,p_display_name=>'Item Size'
,p_display_sequence=>110
,p_template_types=>'REGION'
,p_help_text=>'Sets the size of the form items within this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686932039417028101)
,p_theme_id=>42
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>80
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the right of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686932190740028101)
,p_theme_id=>42
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>40
,p_template_types=>'BUTTON'
,p_help_text=>'Enables you to group many buttons together into a pill. You can use this option to specify where the button is within this set. Set the option to Default if this button is not part of a button set.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686932580235028101)
,p_theme_id=>42
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>30
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686932753785028101)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>40
,p_template_types=>'REGION'
,p_help_text=>'Determines how the region is styled. Use the "Remove Borders" template option to remove the region''s borders and shadows.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686932883424028101)
,p_theme_id=>42
,p_name=>'ACCENT'
,p_display_name=>'Accent'
,p_display_sequence=>30
,p_template_types=>'REGION'
,p_help_text=>'Set the Region''s accent. This accent corresponds to a Theme-Rollable color and sets the background of the Region''s Header.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686932933875028101)
,p_theme_id=>42
,p_name=>'HIDE_STEPS_FOR'
,p_display_name=>'Hide Steps For'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686934198962028101)
,p_theme_id=>42
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>70
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686934361014028101)
,p_theme_id=>42
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>30
,p_template_types=>'REPORT'
,p_help_text=>'Controls the display of the Report''s borders.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686934797631028101)
,p_theme_id=>42
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>30
,p_template_types=>'REPORT'
,p_help_text=>'Determines the layout of Cards in the report.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686934921941028101)
,p_theme_id=>42
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing Left'
,p_display_sequence=>70
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the left of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686935492736028101)
,p_theme_id=>42
,p_name=>'ITEM_PADDING'
,p_display_name=>'Item Padding'
,p_display_sequence=>100
,p_template_types=>'REGION'
,p_help_text=>'Sets the padding around items within this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686935554787028101)
,p_theme_id=>42
,p_name=>'BODY_HEIGHT'
,p_display_name=>'Body Height'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Sets the Region Body height. You can also specify a custom height by modifying the Region''s CSS Classes and using the height helper classes "i-hXXX" where XXX is any increment of 10 from 100 to 800.'
,p_null_text=>'Auto - Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686935600596028101)
,p_theme_id=>42
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>3
,p_template_types=>'REGION'
,p_help_text=>'Sets the type of alert which can be used to determine the icon, icon color, and the background color.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686935738222028101)
,p_theme_id=>42
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>30
,p_template_types=>'LIST'
,p_null_text=>'No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686935812869028101)
,p_theme_id=>42
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>20
,p_template_types=>'REPORT'
,p_help_text=>'Determines whether you want the row to be highlighted on hover.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686936339267028101)
,p_theme_id=>42
,p_name=>'TYPE'
,p_display_name=>'Type'
,p_display_sequence=>20
,p_template_types=>'BUTTON'
,p_null_text=>'Normal'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686936498799028101)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>30
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the style of the button. Use the "Simple" option for secondary actions or sets of buttons. Use the "Remove UI Decoration" option to make the button appear as text.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686937130886028102)
,p_theme_id=>42
,p_name=>'WIDTH'
,p_display_name=>'Width'
,p_display_sequence=>60
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the width of the button.'
,p_null_text=>'Auto - Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(686938015244028102)
,p_theme_id=>42
,p_name=>'BODY_PADDING'
,p_display_name=>'Body Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the Region Body padding for the region.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(720406663650878470)
,p_theme_id=>42
,p_name=>'DISPLAY_ICON'
,p_display_name=>'Display Icon'
,p_display_sequence=>50
,p_template_types=>'REGION'
,p_help_text=>'Display the Hero Region icon.'
,p_null_text=>'Yes (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(872906013962098469)
,p_theme_id=>42
,p_name=>'ITEM_PRE_TEXT'
,p_display_name=>'Item Pre Text'
,p_display_sequence=>20
,p_template_types=>'FIELD'
,p_help_text=>'Adjust the display of the Item Pre Text'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(872906399664100106)
,p_theme_id=>42
,p_name=>'ITEM_POST_TEXT'
,p_display_name=>'Item Post Text'
,p_display_sequence=>30
,p_template_types=>'FIELD'
,p_help_text=>'Adjust the display of the Item Post Text'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(880962127232017732)
,p_theme_id=>42
,p_name=>'ANIMATION'
,p_display_name=>'Animation'
,p_display_sequence=>80
,p_template_types=>'LIST'
,p_help_text=>'Sets the hover and focus animation.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(880963719987020955)
,p_theme_id=>42
,p_name=>'ANIMATION'
,p_display_name=>'Animation'
,p_display_sequence=>70
,p_template_types=>'REPORT'
,p_help_text=>'Sets the hover and focus animation.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(940959055224631412)
,p_theme_id=>42
,p_name=>'LABEL_ALIGNMENT'
,p_display_name=>'Label Alignment'
,p_display_sequence=>130
,p_template_types=>'REGION'
,p_help_text=>'Set the label text alignment for items within this region.'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(940979718001664041)
,p_theme_id=>42
,p_name=>'LABEL_POSITION'
,p_display_name=>'Label Position'
,p_display_sequence=>140
,p_template_types=>'REGION'
,p_help_text=>'Sets the position of the label relative to the form item.'
,p_null_text=>'Inline - Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1038527687487780252)
,p_theme_id=>42
,p_name=>'ALERT_TITLE'
,p_display_name=>'Alert Title'
,p_display_sequence=>40
,p_template_types=>'REGION'
,p_help_text=>'Determines how the title of the alert is displayed.'
,p_null_text=>'Visible - Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1048200623912835168)
,p_theme_id=>42
,p_name=>'REGION_TOP_MARGIN'
,p_display_name=>'Top Margin'
,p_display_sequence=>200
,p_template_types=>'REGION'
,p_help_text=>'Set the top margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1048201178198836942)
,p_theme_id=>42
,p_name=>'REGION_BOTTOM_MARGIN'
,p_display_name=>'Bottom Margin'
,p_display_sequence=>210
,p_template_types=>'REGION'
,p_help_text=>'Set the bottom margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1048203232599844933)
,p_theme_id=>42
,p_name=>'REGION_LEFT_MARGIN'
,p_display_name=>'Left Margin'
,p_display_sequence=>220
,p_template_types=>'REGION'
,p_help_text=>'Set the left margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1048203592334847309)
,p_theme_id=>42
,p_name=>'REGION_RIGHT_MARGIN'
,p_display_name=>'Right Margin'
,p_display_sequence=>230
,p_template_types=>'REGION'
,p_help_text=>'Set the right margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1093528122542993730)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>10
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1215309761905148163)
,p_theme_id=>42
,p_name=>'DEFAULT_STATE'
,p_display_name=>'Default State'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the default state of the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1217903970492295002)
,p_theme_id=>42
,p_name=>'ITEM_WIDTH'
,p_display_name=>'Item Width'
,p_display_sequence=>120
,p_template_types=>'REGION'
,p_help_text=>'Sets the width of the form items within this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1223646971237343931)
,p_theme_id=>42
,p_name=>'DIALOG_SIZE'
,p_display_name=>'Dialog Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1332170055887643649)
,p_theme_id=>42
,p_name=>'ANIMATION'
,p_display_name=>'Animation'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Sets the animation when navigating within the Carousel Region.'
,p_null_text=>'Fade'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1332170259565645642)
,p_theme_id=>42
,p_name=>'TIMER'
,p_display_name=>'Timer'
,p_display_sequence=>2
,p_template_types=>'REGION'
,p_help_text=>'Sets the timer for when to automatically navigate to the next region within the Carousel Region.'
,p_null_text=>'No Timer'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1337807492374178719)
,p_theme_id=>42
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1341358060911539894)
,p_theme_id=>42
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the source of the Title Bar region''s title.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1373692906398577433)
,p_theme_id=>42
,p_name=>'TOP_MARGIN'
,p_display_name=>'Top Margin'
,p_display_sequence=>200
,p_template_types=>'FIELD'
,p_help_text=>'Set the top margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1373693355147580605)
,p_theme_id=>42
,p_name=>'BOTTOM_MARGIN'
,p_display_name=>'Bottom Margin'
,p_display_sequence=>220
,p_template_types=>'FIELD'
,p_help_text=>'Set the bottom margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1373693635931582685)
,p_theme_id=>42
,p_name=>'LEFT_MARGIN'
,p_display_name=>'Left Margin'
,p_display_sequence=>220
,p_template_types=>'FIELD'
,p_help_text=>'Set the left margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1373694106751588886)
,p_theme_id=>42
,p_name=>'RIGHT_MARGIN'
,p_display_name=>'Right Margin'
,p_display_sequence=>230
,p_template_types=>'FIELD'
,p_help_text=>'Set the right margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1437744671284475130)
,p_theme_id=>42
,p_name=>'COLOR_ACCENTS'
,p_display_name=>'Color Accents'
,p_display_sequence=>50
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1437745695703477673)
,p_theme_id=>42
,p_name=>'ICONS'
,p_display_name=>'Icons'
,p_display_sequence=>20
,p_template_types=>'LIST'
,p_null_text=>'No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1437746379683480702)
,p_theme_id=>42
,p_name=>'BODY_TEXT'
,p_display_name=>'Body Text'
,p_display_sequence=>40
,p_template_types=>'LIST'
,p_help_text=>'Determines the height of the card body.'
,p_null_text=>'Auto'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1443062277679626593)
,p_theme_id=>42
,p_name=>'RADIO_GROUP_DISPLAY'
,p_display_name=>'Item Group Display'
,p_display_sequence=>300
,p_template_types=>'FIELD'
,p_help_text=>'Determines the display style for radio and check box items.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1512514270407882520)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>10
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1517530105045469419)
,p_theme_id=>42
,p_name=>'COMMENTS_STYLE'
,p_display_name=>'Comments Style'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Determines the style in which comments are displayed.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1525956956755555832)
,p_theme_id=>42
,p_name=>'BODY_TEXT'
,p_display_name=>'Body Text'
,p_display_sequence=>40
,p_template_types=>'REPORT'
,p_help_text=>'Determines the height of the card body.'
,p_null_text=>'Auto'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1525957196240557785)
,p_theme_id=>42
,p_name=>'COLOR_ACCENTS'
,p_display_name=>'Color Accents'
,p_display_sequence=>50
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1525957399615559004)
,p_theme_id=>42
,p_name=>'ICONS'
,p_display_name=>'Icons'
,p_display_sequence=>20
,p_template_types=>'REPORT'
,p_help_text=>'Controls how to handle icons in the report.'
,p_null_text=>'No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1525957602312561277)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Determines the overall style for the component.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1583514852507574967)
,p_theme_id=>42
,p_name=>'PRESERVE_LABEL_SPACING'
,p_display_name=>'Preserve Label Spacing'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_help_text=>'Preserves the label space and enables use of the Label Column Span property.'
,p_null_text=>'Yes'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1819504545813380867)
,p_theme_id=>42
,p_name=>'ALERT_ICONS'
,p_display_name=>'Alert Icons'
,p_display_sequence=>2
,p_template_types=>'REGION'
,p_help_text=>'Sets how icons are handled for the Alert Region.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1840639733836662642)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1857478787516903577)
,p_theme_id=>42
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1857479096126905096)
,p_theme_id=>42
,p_name=>'TAB_STYLE'
,p_display_name=>'Tab Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(1857480037379911594)
,p_theme_id=>42
,p_name=>'TABS_SIZE'
,p_display_name=>'Tabs Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(2152178420884088035)
,p_theme_id=>42
,p_name=>'BODY_STYLE'
,p_display_name=>'Body Style'
,p_display_sequence=>20
,p_template_types=>'REGION'
,p_help_text=>'Controls the display of the region''s body container.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(36341567142178351)
,p_theme_id=>42
,p_name=>'AUTO_HEIGHT_INLINE_DIALOG'
,p_display_name=>'Auto Height'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-dialog-autoheight'
,p_template_types=>'REGION'
,p_help_text=>'This option will set the height of the dialog to fit its contents.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(36342386197178363)
,p_theme_id=>42
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_api.id(1223646971237343931)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(36342743089178365)
,p_theme_id=>42
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_api.id(1223646971237343931)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(36344019112178367)
,p_theme_id=>42
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_api.id(1223646971237343931)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(36345016860199829)
,p_theme_id=>42
,p_name=>'NONE'
,p_display_name=>'None'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-dialog-nosize'
,p_group_id=>wwv_flow_api.id(1223646971237343931)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(136984374131672603)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'t-DialogRegion--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes the padding around the region body.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(136984645774677058)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>5
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'t-DialogRegion--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes the padding around the region body.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(138686562864078208)
,p_theme_id=>42
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(2044682192514224742)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
,p_help_text=>'Enables you to define a keyboard shortcut to activate the menu item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(139249009997129834)
,p_theme_id=>42
,p_name=>'SHOW_REGION_ICON'
,p_display_name=>'Show Region Icon'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(873087052820635270)
,p_css_classes=>'t-ContentBlock--showIcon'
,p_template_types=>'REGION'
,p_help_text=>'Displays the region icon in the region header beside the region title'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(139425226067120175)
,p_theme_id=>42
,p_name=>'STYLE_A'
,p_display_name=>'Style A'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_css_classes=>'t-TreeNav--styleA'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
,p_help_text=>'Style Variation A'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(139425499017121455)
,p_theme_id=>42
,p_name=>'STYLE_B'
,p_display_name=>'Style B'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_css_classes=>'t-TreeNav--styleB'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
,p_help_text=>'Style Variation B'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(171426272527047412)
,p_theme_id=>42
,p_name=>'WIZARD_PROGRESS_LINKS'
,p_display_name=>'Make Wizard Steps Clickable'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(561120526789187584)
,p_css_classes=>'js-wizardProgressLinks'
,p_template_types=>'LIST'
,p_help_text=>'This option will make the wizard steps clickable links.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(174928601863682667)
,p_theme_id=>42
,p_name=>'STYLE_C'
,p_display_name=>'Classic'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_css_classes=>'t-TreeNav--classic'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
,p_help_text=>'Classic Style'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(182676470096796084)
,p_theme_id=>42
,p_name=>'COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(65791776421862960)
,p_css_classes=>'t-Timeline--compact'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
,p_help_text=>'Displays a compact version of timeline with smaller text and fewer columns.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(215603298226026242)
,p_theme_id=>42
,p_name=>'HIDE_LABEL_ON_MOBILE'
,p_display_name=>'Hide Label on Mobile'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_css_classes=>'t-Button--mobileHideLabel'
,p_template_types=>'BUTTON'
,p_help_text=>'This template options hides the button label on small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(215636050096082468)
,p_theme_id=>42
,p_name=>'SPIN'
,p_display_name=>'Spin'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_css_classes=>'t-Button--hoverIconSpin'
,p_group_id=>wwv_flow_api.id(215635458665067919)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will spin on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(215636422248085038)
,p_theme_id=>42
,p_name=>'PUSH'
,p_display_name=>'Push'
,p_display_sequence=>20
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_css_classes=>'t-Button--hoverIconPush'
,p_group_id=>wwv_flow_api.id(215635458665067919)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will animate to the right or left on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(215642794957092725)
,p_theme_id=>42
,p_name=>'SPIN'
,p_display_name=>'Spin'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_css_classes=>'t-Button--hoverIconSpin'
,p_group_id=>wwv_flow_api.id(215635458665067919)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will spin on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(215643345060093995)
,p_theme_id=>42
,p_name=>'PUSH'
,p_display_name=>'Push'
,p_display_sequence=>20
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_css_classes=>'t-Button--hoverIconPush'
,p_group_id=>wwv_flow_api.id(215635458665067919)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will animate to the right or left on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(239920721902752792)
,p_theme_id=>42
,p_name=>'REMOVE_PAGE_OVERLAY'
,p_display_name=>'Remove Page Overlay'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-popup-noOverlay'
,p_template_types=>'REGION'
,p_help_text=>'This option will display the inline dialog without an overlay on the background.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(240332596533273672)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--iconsSquare'
,p_group_id=>wwv_flow_api.id(240331572408240607)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(240332914288277171)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--iconsSquare'
,p_group_id=>wwv_flow_api.id(240331572408240607)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(240333389335280467)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--iconsSquare'
,p_group_id=>wwv_flow_api.id(240331900166242117)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(240333685105283106)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1164140200812557328)
,p_css_classes=>'t-Comments--iconsSquare'
,p_group_id=>wwv_flow_api.id(240331900166242117)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(240333953355286064)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--iconsSquare'
,p_group_id=>wwv_flow_api.id(240331900166242117)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(240336838431350961)
,p_theme_id=>42
,p_name=>'ICONS_PLUS_OR_MINUS'
,p_display_name=>'Plus or Minus'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--hideShowIconsMath'
,p_group_id=>wwv_flow_api.id(240335211940344543)
,p_template_types=>'REGION'
,p_help_text=>'Use the plus and minus icons for the expand and collapse button.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(240337400241354943)
,p_theme_id=>42
,p_name=>'CONRTOLS_POSITION_END'
,p_display_name=>'End'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--controlsPosEnd'
,p_group_id=>wwv_flow_api.id(240334389763319806)
,p_template_types=>'REGION'
,p_help_text=>'Position the expand / collapse button to the end of the region header.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(241863902970571755)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--iconsRounded'
,p_group_id=>wwv_flow_api.id(240331572408240607)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(241864573774577986)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--iconsRounded'
,p_group_id=>wwv_flow_api.id(240331900166242117)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(241872609228581726)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--iconsRounded'
,p_group_id=>wwv_flow_api.id(240331572408240607)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(241873954103585234)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--iconsRounded'
,p_group_id=>wwv_flow_api.id(240331900166242117)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(241874505626588903)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1164140200812557328)
,p_css_classes=>'t-Comments--iconsRounded'
,p_group_id=>wwv_flow_api.id(240331900166242117)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(248035289187741665)
,p_theme_id=>42
,p_name=>'PAGE_LAYOUT_SPLIT'
,p_display_name=>'Split'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(652129338145143712)
,p_css_classes=>'t-LoginPage--split'
,p_group_id=>wwv_flow_api.id(238836143358553477)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(248035509228744610)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND_1'
,p_display_name=>'Background 1'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(652129338145143712)
,p_css_classes=>'t-LoginPage--bg1'
,p_group_id=>wwv_flow_api.id(238836456250556001)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(248035809643746378)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND_2'
,p_display_name=>'Background 2'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(652129338145143712)
,p_css_classes=>'t-LoginPage--bg2'
,p_group_id=>wwv_flow_api.id(238836456250556001)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(253590809515383098)
,p_theme_id=>42
,p_name=>'ICONS_CIRCULAR'
,p_display_name=>'Circle'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1224989219520090364)
,p_css_classes=>'t-HeroRegion--iconsCircle'
,p_group_id=>wwv_flow_api.id(253590311653377102)
,p_template_types=>'REGION'
,p_help_text=>'The icons are displayed within a circle.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(253591054883386658)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1224989219520090364)
,p_css_classes=>'t-HeroRegion--iconsSquare'
,p_group_id=>wwv_flow_api.id(253590311653377102)
,p_template_types=>'REGION'
,p_help_text=>'The icons are displayed within a square.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(253997974882550974)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND_3'
,p_display_name=>'Background 3'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(652129338145143712)
,p_css_classes=>'t-LoginPage--bg3'
,p_group_id=>wwv_flow_api.id(238836456250556001)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254244493501769393)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(561127424267431983)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254244711403772753)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(2044682192514224742)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu. Note that callout will only be displayed if the data-parent-element custom attribute is defined.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254245025797780615)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254245588692791119)
,p_theme_id=>42
,p_name=>'DISPLAY_POPUP_CALLOUT'
,p_display_name=>'Display Popup Callout'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-popup-callout'
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add display a callout for the popup. Note that callout will only be displayed if the data-parent-element custom attribute is defined.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254247399124810318)
,p_theme_id=>42
,p_name=>'BEFORE'
,p_display_name=>'Before'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-popup-pos-before'
,p_group_id=>wwv_flow_api.id(254246764314801329)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout before or typically to the left of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254247601687811782)
,p_theme_id=>42
,p_name=>'AFTER'
,p_display_name=>'After'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-popup-pos-after'
,p_group_id=>wwv_flow_api.id(254246764314801329)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout after or typically to the right of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254247931980813673)
,p_theme_id=>42
,p_name=>'ABOVE'
,p_display_name=>'Above'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-popup-pos-above'
,p_group_id=>wwv_flow_api.id(254246764314801329)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout above or typically on top of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254248268785815794)
,p_theme_id=>42
,p_name=>'BELOW'
,p_display_name=>'Below'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-popup-pos-below'
,p_group_id=>wwv_flow_api.id(254246764314801329)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout below or typically to the bottom of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(254248572094818502)
,p_theme_id=>42
,p_name=>'INSIDE'
,p_display_name=>'Inside'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(36340727081178326)
,p_css_classes=>'js-popup-pos-inside'
,p_group_id=>wwv_flow_api.id(254246764314801329)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout inside of the parent. This is useful when the parent is sufficiently large, such as a report or large region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(323024443186403293)
,p_theme_id=>42
,p_name=>'LABEL_INLINE_LG'
,p_display_name=>'Display labels inline'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(5429749254678674)
,p_css_classes=>'t-NavTabs--inlineLabels-lg'
,p_group_id=>wwv_flow_api.id(323023042025382157)
,p_template_types=>'LIST'
,p_help_text=>'Display the label inline with the icon and badge'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(323024784490409002)
,p_theme_id=>42
,p_name=>'LABEL_ABOVE_LG'
,p_display_name=>'Display labels above'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(5429749254678674)
,p_css_classes=>'t-NavTabs--stacked'
,p_group_id=>wwv_flow_api.id(323023042025382157)
,p_template_types=>'LIST'
,p_help_text=>'Display the label stacked above the icon and badge'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(323025261908423830)
,p_theme_id=>42
,p_name=>'NO_LABEL_LG'
,p_display_name=>'Do not display labels'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(5429749254678674)
,p_css_classes=>'t-NavTabs--hiddenLabels-lg'
,p_group_id=>wwv_flow_api.id(323023042025382157)
,p_template_types=>'LIST'
,p_help_text=>'Hides the label for the list item'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(323044096831435346)
,p_theme_id=>42
,p_name=>'DISPLAY_LABELS_SM'
,p_display_name=>'Display labels'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(5429749254678674)
,p_css_classes=>'t-NavTabs--displayLabels-sm'
,p_group_id=>wwv_flow_api.id(323023383838383536)
,p_template_types=>'LIST'
,p_help_text=>'Displays the label for the list items below the icon'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(323044326011438615)
,p_theme_id=>42
,p_name=>'HIDE_LABELS_SM'
,p_display_name=>'Do not display labels'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(5429749254678674)
,p_css_classes=>'t-NavTabs--hiddenLabels-sm'
,p_group_id=>wwv_flow_api.id(323023383838383536)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(330619183951965588)
,p_theme_id=>42
,p_name=>'LOGIN_HEADER_ICON'
,p_display_name=>'Icon'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1225129382632869472)
,p_css_classes=>'t-Login-region--headerIcon'
,p_group_id=>wwv_flow_api.id(330622871777976980)
,p_template_types=>'REGION'
,p_help_text=>'Displays only the Region Icon in the Login region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(330619403821967325)
,p_theme_id=>42
,p_name=>'LOGIN_HEADER_TITLE'
,p_display_name=>'Title'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1225129382632869472)
,p_css_classes=>'t-Login-region--headerTitle'
,p_group_id=>wwv_flow_api.id(330622871777976980)
,p_template_types=>'REGION'
,p_help_text=>'Displays only the Region Title in the Login region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(330619758143968581)
,p_theme_id=>42
,p_name=>'LOGO_HEADER_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1225129382632869472)
,p_css_classes=>'t-Login-region--headerHidden'
,p_group_id=>wwv_flow_api.id(330622871777976980)
,p_template_types=>'REGION'
,p_help_text=>'Hides both the Region Icon and Title from the Login region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(330624992191999827)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1398514441042912293)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(334241145487690857)
,p_theme_id=>42
,p_name=>'DISPLAY_SUBTITLE'
,p_display_name=>'Display Subtitle'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--displaySubtitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(334721208695984399)
,p_theme_id=>42
,p_name=>'BLOCK'
,p_display_name=>'Block'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--featured t-Cards--block force-fa-lg'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(334851471331443195)
,p_theme_id=>42
,p_name=>'BLOCK'
,p_display_name=>'Block'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--featured t-Cards--block force-fa-lg'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(334851708965445205)
,p_theme_id=>42
,p_name=>'DISPLAY_SUBTITLE'
,p_display_name=>'Display Subtitle'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--displaySubtitle'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(335457279389178312)
,p_theme_id=>42
,p_name=>'SHOW_REGION_ICON'
,p_display_name=>'Show Region Icon'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--showIcon'
,p_template_types=>'REGION'
,p_help_text=>'Displays the region icon in the region header beside the region title'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(341352557131809035)
,p_theme_id=>42
,p_name=>'COLLAPSE_STYLE_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_css_classes=>'js-navCollapsed--hidden'
,p_group_id=>wwv_flow_api.id(341348731255729287)
,p_template_types=>'LIST'
,p_help_text=>'Completely hide the navigation menu when it is collapsed.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(345588708808550765)
,p_theme_id=>42
,p_name=>'SHOW_REGION_ICON'
,p_display_name=>'Show Region Icon'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--showIcon'
,p_template_types=>'REGION'
,p_help_text=>'Displays the region icon in the region header beside the region title'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(350798785322250277)
,p_theme_id=>42
,p_name=>'TITLE_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--hideTitle'
,p_group_id=>wwv_flow_api.id(350784797183225680)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Title from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(350801269373255760)
,p_theme_id=>42
,p_name=>'SELECTION_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--hideSelection'
,p_group_id=>wwv_flow_api.id(350784197398221961)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Selection column from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(350801554087257419)
,p_theme_id=>42
,p_name=>'ICON_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--hideIcon'
,p_group_id=>wwv_flow_api.id(350784424517223601)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Icon from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(350801875813261741)
,p_theme_id=>42
,p_name=>'DESCRIPTION_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--hideDescription'
,p_group_id=>wwv_flow_api.id(350785031716227530)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Description from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(350802111464263493)
,p_theme_id=>42
,p_name=>'MISC_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--hideMisc'
,p_group_id=>wwv_flow_api.id(350785337301229407)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Misc column from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(350802409866265726)
,p_theme_id=>42
,p_name=>'ACTIONS_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--hideActions'
,p_group_id=>wwv_flow_api.id(350785675912230663)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Actions column from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(355501726269314508)
,p_theme_id=>42
,p_name=>'ALIGNMENT_TOP'
,p_display_name=>'Top'
,p_display_sequence=>100
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--alignTop'
,p_group_id=>wwv_flow_api.id(355501396300309305)
,p_template_types=>'REPORT'
,p_help_text=>'Aligns the content to the top of the row. This is useful when you expect that yours rows will vary in height (e.g. some rows will have longer descriptions than others).'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(360797139177944340)
,p_theme_id=>42
,p_name=>'STYLE_COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(350261643030073247)
,p_css_classes=>'t-ContentRow--styleCompact'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
,p_help_text=>'This option reduces the padding and font sizes to present a compact display of the same information.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(385802123000140486)
,p_theme_id=>42
,p_name=>'HIDE_WHEN_ALL_ROWS_DISPLAYED'
,p_display_name=>'Hide when all rows displayed'
,p_display_sequence=>10
,p_css_classes=>'t-Report--hideNoPagination'
,p_group_id=>wwv_flow_api.id(385801771488104515)
,p_template_types=>'REPORT'
,p_help_text=>'This option will hide the pagination when all rows are displayed.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(389540278597397799)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'u-colors'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(389540525192400322)
,p_theme_id=>42
,p_name=>'CIRCULAR'
,p_display_name=>'Circular'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--circular'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(389540821020401488)
,p_theme_id=>42
,p_name=>'GRID'
,p_display_name=>'Grid'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--dash'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(389542129155407029)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'u-colors'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(389542429691408764)
,p_theme_id=>42
,p_name=>'CIRCULAR'
,p_display_name=>'Circular'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--circular'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(389542753799409875)
,p_theme_id=>42
,p_name=>'GRID'
,p_display_name=>'Grid'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--dash'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(446734458710189573)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--large force-fa-lg'
,p_group_id=>wwv_flow_api.id(446733723296185373)
,p_template_types=>'REPORT'
,p_help_text=>'Increases the size of the text and icons in the list.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(455321834594513591)
,p_theme_id=>42
,p_name=>'USE_COMPACT_STYLE'
,p_display_name=>'Use Compact Style'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1082434711915925186)
,p_css_classes=>'t-BreadcrumbRegion--compactTitle'
,p_template_types=>'REGION'
,p_help_text=>'Uses a compact style for the breadcrumbs.'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(481104777436103223)
,p_theme_id=>42
,p_name=>'TEXT_CONTENT'
,p_display_name=>'Text Content'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--textContent'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Useful for displaying primarily text-based content, such as FAQs and more.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(525375534202309688)
,p_theme_id=>42
,p_name=>'ICON_DEFAULT'
,p_display_name=>'Icon (Default)'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_css_classes=>'js-navCollapsed--default'
,p_group_id=>wwv_flow_api.id(341348731255729287)
,p_template_types=>'LIST'
,p_help_text=>'Display icons when the navigation menu is collapsed for large screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(533164987261211784)
,p_theme_id=>42
,p_name=>'COLLAPSED_DEFAULT'
,p_display_name=>'Collapsed by Default'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_css_classes=>'js-defaultCollapsed'
,p_template_types=>'LIST'
,p_help_text=>'This option will load the side navigation menu in a collapsed state by default.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(536323872783725783)
,p_theme_id=>42
,p_name=>'STRETCH_TO_FIT_WINDOW'
,p_display_name=>'Stretch to Fit Window'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(651378991620880020)
,p_css_classes=>'ui-dialog--stretch'
,p_template_types=>'PAGE'
,p_help_text=>'Stretch the dialog to fit the browser window.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(536325439502731177)
,p_theme_id=>42
,p_name=>'STRETCH_TO_FIT_WINDOW'
,p_display_name=>'Stretch to Fit Window'
,p_display_sequence=>10
,p_page_template_id=>wwv_flow_api.id(672766417768219611)
,p_css_classes=>'ui-dialog--stretch'
,p_template_types=>'PAGE'
,p_help_text=>'Stretch the dialog to fit the browser window.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(562970700525845496)
,p_theme_id=>42
,p_name=>'AUTO_HEIGHT_INLINE_DIALOG'
,p_display_name=>'Auto Height'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'js-dialog-autoheight'
,p_template_types=>'REGION'
,p_help_text=>'This option will set the height of the dialog to fit its contents.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(582142144315170056)
,p_theme_id=>42
,p_name=>'DISPLAY_AS_LINK'
,p_display_name=>'Display as Link'
,p_display_sequence=>30
,p_css_classes=>'t-Button--link'
,p_group_id=>wwv_flow_api.id(686936498799028101)
,p_template_types=>'BUTTON'
,p_help_text=>'This option makes the button appear as a text link.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(582143375393191970)
,p_theme_id=>42
,p_name=>'SMALLTOPMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padTop'
,p_group_id=>wwv_flow_api.id(582142591229178435)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(582143651912193762)
,p_theme_id=>42
,p_name=>'LARGETOPMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapTop'
,p_group_id=>wwv_flow_api.id(582142591229178435)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(582143967848196059)
,p_theme_id=>42
,p_name=>'SMALLBOTTOMMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padBottom'
,p_group_id=>wwv_flow_api.id(582143096365182722)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(582144229162198170)
,p_theme_id=>42
,p_name=>'LARGEBOTTOMMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapBottom'
,p_group_id=>wwv_flow_api.id(582143096365182722)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(582152958347346516)
,p_theme_id=>42
,p_name=>'TINY'
,p_display_name=>'Tiny'
,p_display_sequence=>10
,p_css_classes=>'t-Button--tiny'
,p_group_id=>wwv_flow_api.id(686929122234028100)
,p_template_types=>'BUTTON'
,p_help_text=>'A very small button.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(600035619556705078)
,p_theme_id=>42
,p_name=>'NOBORDER'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--noBorder'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes borders from the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602853461239198628)
,p_theme_id=>42
,p_name=>'NOBODYPADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes padding from region body.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602853620109202595)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stack Region'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--stacked'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes side borders and shadows, and can be useful for accordions and regions that need to be grouped together vertically.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602893817874299585)
,p_theme_id=>42
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'i-h240'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 240px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602894866897301163)
,p_theme_id=>42
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'i-h320'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 320px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602900228684367254)
,p_theme_id=>42
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--wizard'
,p_group_id=>wwv_flow_api.id(686930381900028100)
,p_template_types=>'REGION'
,p_help_text=>'Show the alert in a wizard style region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602900497107369926)
,p_theme_id=>42
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(686930381900028100)
,p_template_types=>'REGION'
,p_help_text=>'Show horizontal alert with buttons to the right.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602900803681376271)
,p_theme_id=>42
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--warning'
,p_group_id=>wwv_flow_api.id(686935600596028101)
,p_template_types=>'REGION'
,p_help_text=>'Show a warning alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602901061803377891)
,p_theme_id=>42
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--success'
,p_group_id=>wwv_flow_api.id(686935600596028101)
,p_template_types=>'REGION'
,p_help_text=>'Show success alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602901212250385190)
,p_theme_id=>42
,p_name=>'DANGER'
,p_display_name=>'Danger'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--danger'
,p_group_id=>wwv_flow_api.id(686935600596028101)
,p_template_types=>'REGION'
,p_help_text=>'Show an error or danger alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602902611617394912)
,p_theme_id=>42
,p_name=>'COLOREDBACKGROUND'
,p_display_name=>'Highlight Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--colorBG'
,p_template_types=>'REGION'
,p_help_text=>'Set alert background color to that of the alert type (warning, success, etc.)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602902878720396440)
,p_theme_id=>42
,p_name=>'INFORMATION'
,p_display_name=>'Information'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--info'
,p_group_id=>wwv_flow_api.id(686935600596028101)
,p_template_types=>'REGION'
,p_help_text=>'Show informational alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(602908977429443127)
,p_theme_id=>42
,p_name=>'USEDEFAULTICONS'
,p_display_name=>'Show Default Icons'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--defaultIcons'
,p_group_id=>wwv_flow_api.id(1819504545813380867)
,p_template_types=>'REGION'
,p_help_text=>'Uses default icons for alert types.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620482902253879261)
,p_theme_id=>42
,p_name=>'SPANHORIZONTAL'
,p_display_name=>'Span Horizontal'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Show all list items in one horizontal row.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620483121048882086)
,p_theme_id=>42
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--cols t-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620483509964884914)
,p_theme_id=>42
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--cols t-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620483726066885981)
,p_theme_id=>42
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--cols t-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620483948191887217)
,p_theme_id=>42
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--cols t-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620539348195152034)
,p_theme_id=>42
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>70
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--float'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Float badges to left'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620539512442154321)
,p_theme_id=>42
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>80
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Use flexbox to arrange items'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620541965646162313)
,p_theme_id=>42
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>60
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Span badges horizontally'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620542157011164636)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stacked'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Stack badges on top of each other'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620542572920168235)
,p_theme_id=>42
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in a two column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620553729890174648)
,p_theme_id=>42
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in a 3 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620553913715176130)
,p_theme_id=>42
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in 4 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620554128698178151)
,p_theme_id=>42
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in a 5 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620556013388184603)
,p_theme_id=>42
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--small'
,p_group_id=>wwv_flow_api.id(686934198962028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620556208977186747)
,p_theme_id=>42
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(686934198962028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620556460887189232)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--large'
,p_group_id=>wwv_flow_api.id(686934198962028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(620556848772193409)
,p_theme_id=>42
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(686934198962028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(631232387342532111)
,p_theme_id=>42
,p_name=>'ALLSTEPS'
,p_display_name=>'All Steps'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(561120526789187584)
,p_css_classes=>'t-WizardSteps--displayLabels'
,p_group_id=>wwv_flow_api.id(686930602304028100)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(631232765266535093)
,p_theme_id=>42
,p_name=>'CURRENTSTEPONLY'
,p_display_name=>'Current Step Only'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(561120526789187584)
,p_css_classes=>'t-WizardSteps--displayCurrentLabelOnly'
,p_group_id=>wwv_flow_api.id(686930602304028100)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(631233887528541325)
,p_theme_id=>42
,p_name=>'HIDELABELS'
,p_display_name=>'Hide Labels'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(561120526789187584)
,p_css_classes=>'t-WizardSteps--hideLabels'
,p_group_id=>wwv_flow_api.id(686930602304028100)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(631238384520579676)
,p_theme_id=>42
,p_name=>'SCROLLBODY'
,p_display_name=>'Scroll - Default'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--scrollBody'
,p_group_id=>wwv_flow_api.id(686931442667028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632850642362803892)
,p_theme_id=>42
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(614901035349879760)
,p_css_classes=>'t-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(686934198962028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632852164656819345)
,p_theme_id=>42
,p_name=>'SHOWICONS'
,p_display_name=>'For All Items'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(2623332529225852414)
,p_css_classes=>'t-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(686935738222028101)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632855381042841052)
,p_theme_id=>42
,p_name=>'HIDEREGIONHEADER'
,p_display_name=>'Hidden but accessible'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(686930518563028100)
,p_template_types=>'REGION'
,p_help_text=>'This option will hide the region header.  Note that the region title will still be audible for Screen Readers. Buttons placed in the region header will be hidden and inaccessible.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632929080064468607)
,p_theme_id=>42
,p_name=>'REMOVEALLBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--noBorders'
,p_group_id=>wwv_flow_api.id(686934361014028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632929223441470267)
,p_theme_id=>42
,p_name=>'STRETCHREPORT'
,p_display_name=>'Stretch Report'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--stretch'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632929446541476696)
,p_theme_id=>42
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'No Outer Borders'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--inline'
,p_group_id=>wwv_flow_api.id(686934361014028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632929602414480112)
,p_theme_id=>42
,p_name=>'ALTROWCOLORSDISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(686930751269028100)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632929846310482325)
,p_theme_id=>42
,p_name=>'ALTROWCOLORSENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--altRowsDefault'
,p_group_id=>wwv_flow_api.id(686930751269028100)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632930608553506317)
,p_theme_id=>42
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Only'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(686934361014028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632930811468507680)
,p_theme_id=>42
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Only'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(686934361014028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632932511116537063)
,p_theme_id=>42
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(686935812869028101)
,p_template_types=>'REPORT'
,p_help_text=>'Enable row highlighting on mouse over'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(632932708101540953)
,p_theme_id=>42
,p_name=>'ROWHIGHLIGHTDISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1089625725920080767)
,p_css_classes=>'t-Report--rowHighlightOff'
,p_group_id=>wwv_flow_api.id(686935812869028101)
,p_template_types=>'REPORT'
,p_help_text=>'Disable row highlighting on mouse over'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(637548659512161172)
,p_theme_id=>42
,p_name=>'SHOWGOTOARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(2623332529225852414)
,p_css_classes=>'t-LinksList--showArrow'
,p_template_types=>'LIST'
,p_help_text=>'Show arrow to the right of link'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(637548802658166014)
,p_theme_id=>42
,p_name=>'DISABLETEXTWRAPPING'
,p_display_name=>'Disable Text Wrapping'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(2623332529225852414)
,p_css_classes=>'t-LinksList--nowrap'
,p_template_types=>'LIST'
,p_help_text=>'Do not allow link text to wrap to new lines. Truncate with ellipsis.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(637549022650170015)
,p_theme_id=>42
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(2623332529225852414)
,p_css_classes=>'t-LinksList--showBadge'
,p_template_types=>'LIST'
,p_help_text=>'Show badge to right of link (requires Attribute 1 to be populated)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(637596471768731223)
,p_theme_id=>42
,p_name=>'SHOWTOPICONS'
,p_display_name=>'For Top Level Items Only'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(2623332529225852414)
,p_css_classes=>'t-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(686935738222028101)
,p_template_types=>'LIST'
,p_help_text=>'This will show icons for top level items of the list only. It will not show icons for sub lists.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(642559281767120949)
,p_theme_id=>42
,p_name=>'HIDEOVERFLOW'
,p_display_name=>'Hide'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--hiddenOverflow'
,p_group_id=>wwv_flow_api.id(686931442667028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644576242429100106)
,p_theme_id=>42
,p_name=>'2_COLUMN_GRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--cols t-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644576556343101535)
,p_theme_id=>42
,p_name=>'3_COLUMN_GRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--cols t-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644576881273102676)
,p_theme_id=>42
,p_name=>'4_COLUMN_GRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--cols t-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644577152378104341)
,p_theme_id=>42
,p_name=>'5_COLUMN_GRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--cols t-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644581268880124694)
,p_theme_id=>42
,p_name=>'STACK'
,p_display_name=>'Stack'
,p_display_sequence=>5
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--stack'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644581505592126644)
,p_theme_id=>42
,p_name=>'SPAN_HORIZONTAL'
,p_display_name=>'Span Horizontal'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644582003102129455)
,p_theme_id=>42
,p_name=>'SHOW_ICONS'
,p_display_name=>'Show Icons'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--showIcons'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644582770755132175)
,p_theme_id=>42
,p_name=>'SHOW_DESCRIPTION'
,p_display_name=>'Show Description'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--showDesc'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644583027884133496)
,p_theme_id=>42
,p_name=>'SHOW_BADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'t-MediaList--showBadges'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(644583396537134489)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(644575648490092151)
,p_css_classes=>'u-colors'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655580565028370985)
,p_theme_id=>42
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(651498026300583706)
,p_css_classes=>'t-IRR-region--noBorders'
,p_template_types=>'REGION'
,p_help_text=>'Removes borders around the Interactive Report'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655618661385728558)
,p_theme_id=>42
,p_name=>'128PX'
,p_display_name=>'128px'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(686929314140028100)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655618845630730307)
,p_theme_id=>42
,p_name=>'32PX'
,p_display_name=>'32px'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--small'
,p_group_id=>wwv_flow_api.id(686929314140028100)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655619007069730954)
,p_theme_id=>42
,p_name=>'48PX'
,p_display_name=>'48px'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(686929314140028100)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655619408394731732)
,p_theme_id=>42
,p_name=>'64PX'
,p_display_name=>'64px'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--large'
,p_group_id=>wwv_flow_api.id(686929314140028100)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655619658172732738)
,p_theme_id=>42
,p_name=>'96PX'
,p_display_name=>'96px'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(686929314140028100)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655620810758737160)
,p_theme_id=>42
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_help_text=>'Arrange badges in a two column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655621033870739147)
,p_theme_id=>42
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_help_text=>'Arrange badges in a 3 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655621265054740302)
,p_theme_id=>42
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655621457712741266)
,p_theme_id=>42
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655621625387742361)
,p_theme_id=>42
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>80
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655621875247743157)
,p_theme_id=>42
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>70
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--float'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655622017439744047)
,p_theme_id=>42
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(655622279322744947)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stacked'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(655615347857707855)
,p_css_classes=>'t-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(668308099618062345)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>20
,p_page_template_id=>wwv_flow_api.id(651378991620880020)
,p_css_classes=>'t-Dialog--noPadding'
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(668310294328068024)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>20
,p_page_template_id=>wwv_flow_api.id(672766417768219611)
,p_css_classes=>'t-Dialog--noPadding'
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(670141940193619051)
,p_theme_id=>42
,p_name=>'HIDESMALLSCREENS'
,p_display_name=>'Small Screens (Tablet)'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(670020401234384587)
,p_css_classes=>'t-Wizard--hideStepsSmall'
,p_group_id=>wwv_flow_api.id(686932933875028101)
,p_template_types=>'REGION'
,p_help_text=>'Hides the wizard progress steps for screens that are smaller than 768px wide.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(670142159644622493)
,p_theme_id=>42
,p_name=>'HIDEXSMALLSCREENS'
,p_display_name=>'X Small Screens (Mobile)'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(670020401234384587)
,p_css_classes=>'t-Wizard--hideStepsXSmall'
,p_group_id=>wwv_flow_api.id(686932933875028101)
,p_template_types=>'REGION'
,p_help_text=>'Hides the wizard progress steps for screens that are smaller than 768px wide.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672662339530258211)
,p_theme_id=>42
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>10
,p_css_classes=>'t-Button--primary'
,p_group_id=>wwv_flow_api.id(686936339267028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672662696819258212)
,p_theme_id=>42
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>10
,p_css_classes=>'t-Button--stretch'
,p_group_id=>wwv_flow_api.id(686937130886028102)
,p_template_types=>'BUTTON'
,p_help_text=>'Stretches button to fill container'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672662911341258213)
,p_theme_id=>42
,p_name=>'DANGER'
,p_display_name=>'Danger'
,p_display_sequence=>30
,p_css_classes=>'t-Button--danger'
,p_group_id=>wwv_flow_api.id(686936339267028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672663283794258213)
,p_theme_id=>42
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>40
,p_css_classes=>'t-Button--success'
,p_group_id=>wwv_flow_api.id(686936339267028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672663844828258213)
,p_theme_id=>42
,p_name=>'NOUI'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>20
,p_css_classes=>'t-Button--noUI'
,p_group_id=>wwv_flow_api.id(686936498799028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672664184112258213)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>30
,p_css_classes=>'t-Button--large'
,p_group_id=>wwv_flow_api.id(686929122234028100)
,p_template_types=>'BUTTON'
,p_help_text=>'A large button.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672664470249258213)
,p_theme_id=>42
,p_name=>'SMALLLEFTMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padLeft'
,p_group_id=>wwv_flow_api.id(686934921941028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672664788706258214)
,p_theme_id=>42
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'t-Button--small'
,p_group_id=>wwv_flow_api.id(686929122234028100)
,p_template_types=>'BUTTON'
,p_help_text=>'A small button.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672665035925258214)
,p_theme_id=>42
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>20
,p_css_classes=>'t-Button--warning'
,p_group_id=>wwv_flow_api.id(686936339267028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672665682932258214)
,p_theme_id=>42
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>10
,p_css_classes=>'t-Button--simple'
,p_group_id=>wwv_flow_api.id(686936498799028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672665998112258215)
,p_theme_id=>42
,p_name=>'LARGELEFTMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(686934921941028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672666225547258215)
,p_theme_id=>42
,p_name=>'SMALLRIGHTMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padRight'
,p_group_id=>wwv_flow_api.id(686932039417028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672666554971258215)
,p_theme_id=>42
,p_name=>'LARGERIGHTMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapRight'
,p_group_id=>wwv_flow_api.id(686932039417028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672666808305258216)
,p_theme_id=>42
,p_name=>'PILLSTART'
,p_display_name=>'First Button'
,p_display_sequence=>10
,p_css_classes=>'t-Button--pillStart'
,p_group_id=>wwv_flow_api.id(686932190740028101)
,p_template_types=>'BUTTON'
,p_help_text=>'Use this for the start of a pill button.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672667103292258216)
,p_theme_id=>42
,p_name=>'PILL'
,p_display_name=>'Inner Button'
,p_display_sequence=>20
,p_css_classes=>'t-Button--pill'
,p_group_id=>wwv_flow_api.id(686932190740028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(672667464496258217)
,p_theme_id=>42
,p_name=>'PILLEND'
,p_display_name=>'Last Button'
,p_display_sequence=>30
,p_css_classes=>'t-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(686932190740028101)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(673224766759925807)
,p_theme_id=>42
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_css_classes=>'t-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(686930833556028100)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(673224976885926841)
,p_theme_id=>42
,p_name=>'RIGHTICON'
,p_display_name=>'Right'
,p_display_sequence=>20
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_css_classes=>'t-Button--iconRight'
,p_group_id=>wwv_flow_api.id(686930833556028100)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(677454643993813297)
,p_theme_id=>42
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>4
,p_region_template_id=>wwv_flow_api.id(677400524731372757)
,p_css_classes=>'t-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(677454804770815157)
,p_theme_id=>42
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(677400524731372757)
,p_css_classes=>'t-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(677469563819099303)
,p_theme_id=>42
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>5
,p_region_template_id=>wwv_flow_api.id(677400524731372757)
,p_css_classes=>'t-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(686938015244028102)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(677469976402100363)
,p_theme_id=>42
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(677400524731372757)
,p_css_classes=>'t-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(686938015244028102)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(677533426928384394)
,p_theme_id=>42
,p_name=>'HIDDENHEADERNOAT'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--removeHeader'
,p_group_id=>wwv_flow_api.id(686930518563028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(678341816064160644)
,p_theme_id=>42
,p_name=>'FORMLEFTLABELS'
,p_display_name=>'Left'
,p_display_sequence=>20
,p_css_classes=>'t-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(940959055224631412)
,p_template_types=>'REGION'
,p_help_text=>'Align form labels to left.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(678345091102220861)
,p_theme_id=>42
,p_name=>'FORMSIZELARGE'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_css_classes=>'t-Form--large'
,p_group_id=>wwv_flow_api.id(686931906521028101)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(678345257809222117)
,p_theme_id=>42
,p_name=>'FORMSIZEXLARGE'
,p_display_name=>'X Large'
,p_display_sequence=>20
,p_css_classes=>'t-Form--xlarge'
,p_group_id=>wwv_flow_api.id(686931906521028101)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(678346090849233251)
,p_theme_id=>42
,p_name=>'FORMSLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>10
,p_css_classes=>'t-Form--slimPadding'
,p_group_id=>wwv_flow_api.id(686935492736028101)
,p_template_types=>'REGION'
,p_help_text=>'Reduces form item padding to 4px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(678346529637235955)
,p_theme_id=>42
,p_name=>'FORMREMOVEPADDING'
,p_display_name=>'Remove Padding'
,p_display_sequence=>20
,p_css_classes=>'t-Form--noPadding'
,p_group_id=>wwv_flow_api.id(686935492736028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes padding between items.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(678350070302310559)
,p_theme_id=>42
,p_name=>'SHOWFORMLABELSABOVE'
,p_display_name=>'Show Form Labels Above'
,p_display_sequence=>10
,p_css_classes=>'t-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(940979718001664041)
,p_template_types=>'REGION'
,p_help_text=>'Show form labels above input fields.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720403722871842452)
,p_theme_id=>42
,p_name=>'FEATURED'
,p_display_name=>'Featured'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1224989219520090364)
,p_css_classes=>'t-HeroRegion--featured'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720404048327844150)
,p_theme_id=>42
,p_name=>'STACKED_FEATURED'
,p_display_name=>'Stacked Featured'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1224989219520090364)
,p_css_classes=>'t-HeroRegion--featured t-HeroRegion--centered'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(720408287624887878)
,p_theme_id=>42
,p_name=>'DISPLAY_ICON_NO'
,p_display_name=>'No'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1224989219520090364)
,p_css_classes=>'t-HeroRegion--hideIcon'
,p_group_id=>wwv_flow_api.id(720406663650878470)
,p_template_types=>'REGION'
,p_help_text=>'Hide the Hero Region icon.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(752336251168448492)
,p_theme_id=>42
,p_name=>'STICK_TO_BOTTOM'
,p_display_name=>'Stick to Bottom for Mobile'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(677400524731372757)
,p_css_classes=>'t-ButtonRegion--stickToBottom'
,p_template_types=>'REGION'
,p_help_text=>'This will position the button container region to the bottom of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(767873229249082891)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(1077614758642401794)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(767876055517107778)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(1077621880644450151)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(767877353755110428)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(549332834543365415)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(767878173152112950)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(1530046751615002521)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(767879415863114863)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(1077618304322444671)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(767880286329116551)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(2623327345562852400)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(821849890024783638)
,p_theme_id=>42
,p_name=>'STRETCH_FORM_FIELDS'
,p_display_name=>'Stretch Form Fields'
,p_display_sequence=>10
,p_css_classes=>'t-Form--stretchInputs'
,p_group_id=>wwv_flow_api.id(1217903970492295002)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(872907273778156106)
,p_theme_id=>42
,p_name=>'PRE_TEXT_BLOCK'
,p_display_name=>'Display as Block'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--preTextBlock'
,p_group_id=>wwv_flow_api.id(872906013962098469)
,p_template_types=>'FIELD'
,p_help_text=>'Displays the Item Pre Text in a block style immediately before the item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(872951050567163172)
,p_theme_id=>42
,p_name=>'POST_TEXT_BLOCK'
,p_display_name=>'Display as Block'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--postTextBlock'
,p_group_id=>wwv_flow_api.id(872906399664100106)
,p_template_types=>'FIELD'
,p_help_text=>'Displays the Item Post Text in a block style immediately after the item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(878937325735229972)
,p_theme_id=>42
,p_name=>'CONTENT_TITLE_H1'
,p_display_name=>'Heading Level 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(873087052820635270)
,p_css_classes=>'t-ContentBlock--h1'
,p_group_id=>wwv_flow_api.id(1341358060911539894)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(878937610197231714)
,p_theme_id=>42
,p_name=>'CONTENT_TITLE_H2'
,p_display_name=>'Heading Level 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(873087052820635270)
,p_css_classes=>'t-ContentBlock--h2'
,p_group_id=>wwv_flow_api.id(1341358060911539894)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(878937951862233641)
,p_theme_id=>42
,p_name=>'CONTENT_TITLE_H3'
,p_display_name=>'Heading Level 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(873087052820635270)
,p_css_classes=>'t-ContentBlock--h3'
,p_group_id=>wwv_flow_api.id(1341358060911539894)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(880961536593004135)
,p_theme_id=>42
,p_name=>'CARDS_STACKED'
,p_display_name=>'Stacked'
,p_display_sequence=>5
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--stacked'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Stacks the cards on top of each other.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(880994985213035290)
,p_theme_id=>42
,p_name=>'COLOR_FILL'
,p_display_name=>'Color Fill'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--animColorFill'
,p_group_id=>wwv_flow_api.id(880962127232017732)
,p_template_types=>'LIST'
,p_help_text=>'Fills the card background with the color of the icon or default link style.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(880995210301040201)
,p_theme_id=>42
,p_name=>'RAISE_CARD'
,p_display_name=>'Raise Card'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--animRaiseCard'
,p_group_id=>wwv_flow_api.id(880962127232017732)
,p_template_types=>'LIST'
,p_help_text=>'Raises the card so it pops up.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926197662242631445)
,p_theme_id=>42
,p_name=>'CARDS_COLOR_FILL'
,p_display_name=>'Color Fill'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--animColorFill'
,p_group_id=>wwv_flow_api.id(880963719987020955)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(926197931815632977)
,p_theme_id=>42
,p_name=>'CARD_RAISE_CARD'
,p_display_name=>'Raise Card'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--animRaiseCard'
,p_group_id=>wwv_flow_api.id(880963719987020955)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(929108783400916047)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1224989219520090364)
,p_css_classes=>'t-HeroRegion--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes the padding around the hero region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1018709610060466208)
,p_theme_id=>42
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add shortcuts for menu items. Note that actions.js must be included on your page to support this functionality.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1018709716596467415)
,p_theme_id=>42
,p_name=>'BEHAVE_LIKE_TABS'
,p_display_name=>'Behave Like Tabs'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_css_classes=>'js-tabLike'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1018709886010468787)
,p_theme_id=>42
,p_name=>'ENABLE_SLIDE_ANIMATION'
,p_display_name=>'Enable Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1018709987192470221)
,p_theme_id=>42
,p_name=>'SHOW_SUB_MENU_ICONS'
,p_display_name=>'Show Sub Menu Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_css_classes=>'js-showSubMenuIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1038541038338811097)
,p_theme_id=>42
,p_name=>'HIDDENHEADERNOAT'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--removeHeading'
,p_group_id=>wwv_flow_api.id(1038527687487780252)
,p_template_types=>'REGION'
,p_help_text=>'Hides the Alert Title from being displayed.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1038541830986818587)
,p_theme_id=>42
,p_name=>'HIDDENHEADER'
,p_display_name=>'Hidden but Accessible'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--accessibleHeading'
,p_group_id=>wwv_flow_api.id(1038527687487780252)
,p_template_types=>'REGION'
,p_help_text=>'Visually hides the alert title, but assistive technologies can still read it.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048248796692887121)
,p_theme_id=>42
,p_name=>'RTM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-top-none'
,p_group_id=>wwv_flow_api.id(1048200623912835168)
,p_template_types=>'REGION'
,p_help_text=>'Removes the top margin for this region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048635493780005125)
,p_theme_id=>42
,p_name=>'RTM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-top-sm'
,p_group_id=>wwv_flow_api.id(1048200623912835168)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small top margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048846342126014919)
,p_theme_id=>42
,p_name=>'RTM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-top-md'
,p_group_id=>wwv_flow_api.id(1048200623912835168)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium top margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048848116422021751)
,p_theme_id=>42
,p_name=>'RTM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-top-lg'
,p_group_id=>wwv_flow_api.id(1048200623912835168)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large top margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048848939283025656)
,p_theme_id=>42
,p_name=>'RBM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-bottom-none'
,p_group_id=>wwv_flow_api.id(1048201178198836942)
,p_template_types=>'REGION'
,p_help_text=>'Removes the bottom margin for this region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048849411342027598)
,p_theme_id=>42
,p_name=>'RBM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-bottom-sm'
,p_group_id=>wwv_flow_api.id(1048201178198836942)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small bottom margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048849892231043339)
,p_theme_id=>42
,p_name=>'RBM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-bottom-md'
,p_group_id=>wwv_flow_api.id(1048201178198836942)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium bottom margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1048850193128045302)
,p_theme_id=>42
,p_name=>'RBM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-bottom-lg'
,p_group_id=>wwv_flow_api.id(1048201178198836942)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large bottom margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049118140679276825)
,p_theme_id=>42
,p_name=>'RRM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-right-none'
,p_group_id=>wwv_flow_api.id(1048203592334847309)
,p_template_types=>'REGION'
,p_help_text=>'Removes the right margin from the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049118439434279314)
,p_theme_id=>42
,p_name=>'RRM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-right-sm'
,p_group_id=>wwv_flow_api.id(1048203592334847309)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049118706290281287)
,p_theme_id=>42
,p_name=>'RRM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-right-md'
,p_group_id=>wwv_flow_api.id(1048203592334847309)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049325821430297888)
,p_theme_id=>42
,p_name=>'RRM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-right-lg'
,p_group_id=>wwv_flow_api.id(1048203592334847309)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049326160547300240)
,p_theme_id=>42
,p_name=>'RLM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-left-none'
,p_group_id=>wwv_flow_api.id(1048203232599844933)
,p_template_types=>'REGION'
,p_help_text=>'Removes the left margin from the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049326448074301934)
,p_theme_id=>42
,p_name=>'RLM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-left-sm'
,p_group_id=>wwv_flow_api.id(1048203232599844933)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small left margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049326799354304380)
,p_theme_id=>42
,p_name=>'RLM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-left-md'
,p_group_id=>wwv_flow_api.id(1048203232599844933)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1049327057112305913)
,p_theme_id=>42
,p_name=>'RLM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-left-lg'
,p_group_id=>wwv_flow_api.id(1048203232599844933)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1086837203572201036)
,p_theme_id=>42
,p_name=>'HIDE_BREADCRUMB'
,p_display_name=>'Show Breadcrumbs'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1082434711915925186)
,p_css_classes=>'t-BreadcrumbRegion--showBreadcrumb'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1086840862081264691)
,p_theme_id=>42
,p_name=>'GET_TITLE_FROM_BREADCRUMB'
,p_display_name=>'Use Current Breadcrumb Entry'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1082434711915925186)
,p_css_classes=>'t-BreadcrumbRegion--useBreadcrumbTitle'
,p_group_id=>wwv_flow_api.id(1341358060911539894)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1093532280453002873)
,p_theme_id=>42
,p_name=>'ACTIONS'
,p_display_name=>'Actions'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(2623332529225852414)
,p_css_classes=>'t-LinksList--actions'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
,p_help_text=>'Render as actions to be placed on the right side column.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1163585239016086733)
,p_theme_id=>42
,p_name=>'ACCENT_1'
,p_display_name=>'Accent 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent1'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1163600524316087929)
,p_theme_id=>42
,p_name=>'ACCENT_2'
,p_display_name=>'Accent 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent2'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1163615853975088682)
,p_theme_id=>42
,p_name=>'ACCENT_3'
,p_display_name=>'Accent 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent3'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1163631142738089505)
,p_theme_id=>42
,p_name=>'ACCENT_4'
,p_display_name=>'Accent 4'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent4'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1163646438942118978)
,p_theme_id=>42
,p_name=>'ACCENT_5'
,p_display_name=>'Accent 5'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent5'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215307599608140815)
,p_theme_id=>42
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'i-h240'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 240px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215307684575140816)
,p_theme_id=>42
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'i-h320'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 320px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215307773157140816)
,p_theme_id=>42
,p_name=>'ACCENT_1'
,p_display_name=>'Accent 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--accent1'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215307890924140817)
,p_theme_id=>42
,p_name=>'ACCENT_2'
,p_display_name=>'Accent 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--accent2'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215307912337140817)
,p_theme_id=>42
,p_name=>'ACCENT_3'
,p_display_name=>'Accent 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--accent3'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215308029393140817)
,p_theme_id=>42
,p_name=>'ACCENT_4'
,p_display_name=>'Accent 4'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--accent4'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215308126025140817)
,p_theme_id=>42
,p_name=>'ACCENT_5'
,p_display_name=>'Accent 5'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--accent5'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215308347474140817)
,p_theme_id=>42
,p_name=>'HIDEOVERFLOW'
,p_display_name=>'Hide'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--hiddenOverflow'
,p_group_id=>wwv_flow_api.id(686931442667028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215308508887140817)
,p_theme_id=>42
,p_name=>'NOBODYPADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes padding from region body.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215308643803140817)
,p_theme_id=>42
,p_name=>'NOBORDER'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--noBorder'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes borders from the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215308765948140817)
,p_theme_id=>42
,p_name=>'SCROLLBODY'
,p_display_name=>'Scroll - Default'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--scrollBody'
,p_group_id=>wwv_flow_api.id(686931442667028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215308998812140817)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stack Region'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--stacked'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes side borders and shadows, and can be useful for accordions and regions that need to be grouped together vertically.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215310211128151927)
,p_theme_id=>42
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(1215309761905148163)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1215310333891152708)
,p_theme_id=>42
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(1215309761905148163)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1218415969638455617)
,p_theme_id=>42
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'i-h480'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1218431551037457207)
,p_theme_id=>42
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'i-h640'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1222904331453859153)
,p_theme_id=>42
,p_name=>'LEFT_ALIGNED_DETAILS'
,p_display_name=>'Left Aligned Details'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--leftAligned'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1222904556477862903)
,p_theme_id=>42
,p_name=>'RIGHT_ALIGNED_DETAILS'
,p_display_name=>'Right Aligned Details'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--rightAligned'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1223645823728337255)
,p_theme_id=>42
,p_name=>'DRAGGABLE'
,p_display_name=>'Draggable'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'js-draggable'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1223645984531338199)
,p_theme_id=>42
,p_name=>'MODAL'
,p_display_name=>'Modal'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'js-modal'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1223646175209340625)
,p_theme_id=>42
,p_name=>'RESIZABLE'
,p_display_name=>'Resizable'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'js-resizable'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1223647395661348388)
,p_theme_id=>42
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_api.id(1223646971237343931)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1223647449707349925)
,p_theme_id=>42
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_api.id(1223646971237343931)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1223647571774352414)
,p_theme_id=>42
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1223645131968329858)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_api.id(1223646971237343931)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1337808790879184277)
,p_theme_id=>42
,p_name=>'FIXED_SMALL'
,p_display_name=>'Fixed - Small'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--fixedLabelSmall'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1337808809121185907)
,p_theme_id=>42
,p_name=>'FIXED_MEDIUM'
,p_display_name=>'Fixed - Medium'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--fixedLabelMedium'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1337808929715187155)
,p_theme_id=>42
,p_name=>'FIXED_LARGE'
,p_display_name=>'Fixed - Large'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--fixedLabelLarge'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1337814316699252841)
,p_theme_id=>42
,p_name=>'VARIABLE_SMALL'
,p_display_name=>'Variable - Small'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--variableLabelSmall'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1337814565215254423)
,p_theme_id=>42
,p_name=>'VARIABLE_MEDIUM'
,p_display_name=>'Variable - Medium'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--variableLabelMedium'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1337814741366256496)
,p_theme_id=>42
,p_name=>'VARIABLE_LARGE'
,p_display_name=>'Variable - Large'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(651486824354474850)
,p_css_classes=>'t-AVPList--variableLabelLarge'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1339941266115695177)
,p_theme_id=>42
,p_name=>'REMEMBER_COLLAPSIBLE_STATE'
,p_display_name=>'Remember Collapsible State'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'js-useLocalStorage'
,p_template_types=>'REGION'
,p_help_text=>'This option saves the current state of the collapsible region for the duration of the session.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1341251441834337073)
,p_theme_id=>42
,p_name=>'REGION_HEADER_VISIBLE'
,p_display_name=>'Use Region Title'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(1082434711915925186)
,p_css_classes=>'t-BreadcrumbRegion--useRegionTitle'
,p_group_id=>wwv_flow_api.id(1341358060911539894)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1375597646117638183)
,p_theme_id=>42
,p_name=>'FBM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-bottom-none'
,p_group_id=>wwv_flow_api.id(1373693355147580605)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378328832968677986)
,p_theme_id=>42
,p_name=>'FBM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-bottom-sm'
,p_group_id=>wwv_flow_api.id(1373693355147580605)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378713756151680136)
,p_theme_id=>42
,p_name=>'FBM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-bottom-md'
,p_group_id=>wwv_flow_api.id(1373693355147580605)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378769704340685428)
,p_theme_id=>42
,p_name=>'FBM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-bottom-lg'
,p_group_id=>wwv_flow_api.id(1373693355147580605)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378770022187689290)
,p_theme_id=>42
,p_name=>'FLM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-left-none'
,p_group_id=>wwv_flow_api.id(1373693635931582685)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378770379746691757)
,p_theme_id=>42
,p_name=>'FLM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-left-sm'
,p_group_id=>wwv_flow_api.id(1373693635931582685)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378770694691694065)
,p_theme_id=>42
,p_name=>'FLM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-left-md'
,p_group_id=>wwv_flow_api.id(1373693635931582685)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378770937661695459)
,p_theme_id=>42
,p_name=>'FLM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-left-lg'
,p_group_id=>wwv_flow_api.id(1373693635931582685)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378771565626697748)
,p_theme_id=>42
,p_name=>'FRM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-right-none'
,p_group_id=>wwv_flow_api.id(1373694106751588886)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378772152957700625)
,p_theme_id=>42
,p_name=>'FRM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-right-sm'
,p_group_id=>wwv_flow_api.id(1373694106751588886)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378772410120702706)
,p_theme_id=>42
,p_name=>'FRM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-right-md'
,p_group_id=>wwv_flow_api.id(1373694106751588886)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378772881362704577)
,p_theme_id=>42
,p_name=>'FRM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-right-lg'
,p_group_id=>wwv_flow_api.id(1373694106751588886)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378773116389706743)
,p_theme_id=>42
,p_name=>'FTM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-top-none'
,p_group_id=>wwv_flow_api.id(1373692906398577433)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378830040159708376)
,p_theme_id=>42
,p_name=>'FTM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-top-sm'
,p_group_id=>wwv_flow_api.id(1373692906398577433)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378860278347710857)
,p_theme_id=>42
,p_name=>'FTM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-top-md'
,p_group_id=>wwv_flow_api.id(1373692906398577433)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1378861132203713659)
,p_theme_id=>42
,p_name=>'FTM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-top-lg'
,p_group_id=>wwv_flow_api.id(1373692906398577433)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418259913240351888)
,p_theme_id=>42
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'i-h240'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 240px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260000857351889)
,p_theme_id=>42
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'i-h320'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 320px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260129668351889)
,p_theme_id=>42
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'i-h480'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260247851351889)
,p_theme_id=>42
,p_name=>'5_SECONDS'
,p_display_name=>'5 Seconds'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'js-cycle5s'
,p_group_id=>wwv_flow_api.id(1332170259565645642)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260323918351889)
,p_theme_id=>42
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'i-h640'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260444632351889)
,p_theme_id=>42
,p_name=>'ACCENT_1'
,p_display_name=>'Accent 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--accent1'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260504366351890)
,p_theme_id=>42
,p_name=>'ACCENT_2'
,p_display_name=>'Accent 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--accent2'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260609155351890)
,p_theme_id=>42
,p_name=>'ACCENT_3'
,p_display_name=>'Accent 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--accent3'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260712321351890)
,p_theme_id=>42
,p_name=>'ACCENT_4'
,p_display_name=>'Accent 4'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--accent4'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260800620351890)
,p_theme_id=>42
,p_name=>'ACCENT_5'
,p_display_name=>'Accent 5'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--accent5'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418260985010351890)
,p_theme_id=>42
,p_name=>'HIDDENHEADERNOAT'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--removeHeader'
,p_group_id=>wwv_flow_api.id(686930518563028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261092473351890)
,p_theme_id=>42
,p_name=>'HIDEOVERFLOW'
,p_display_name=>'Hide'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--hiddenOverflow'
,p_group_id=>wwv_flow_api.id(686931442667028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261173740351890)
,p_theme_id=>42
,p_name=>'HIDEREGIONHEADER'
,p_display_name=>'Hidden but accessible'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(686930518563028100)
,p_template_types=>'REGION'
,p_help_text=>'This option will hide the region header.  Note that the region title will still be audible for Screen Readers. Buttons placed in the region header will be hidden and inaccessible.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261232399351892)
,p_theme_id=>42
,p_name=>'NOBODYPADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes padding from region body.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261385403351892)
,p_theme_id=>42
,p_name=>'NOBORDER'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--noBorder'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes borders from the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261416549351892)
,p_theme_id=>42
,p_name=>'REMEMBER_CAROUSEL_SLIDE'
,p_display_name=>'Remember Carousel Slide'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'js-useLocalStorage'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261504053351892)
,p_theme_id=>42
,p_name=>'SCROLLBODY'
,p_display_name=>'Scroll'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--scrollBody'
,p_group_id=>wwv_flow_api.id(686931442667028100)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261725191351892)
,p_theme_id=>42
,p_name=>'SLIDE'
,p_display_name=>'Slide'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--carouselSlide'
,p_group_id=>wwv_flow_api.id(1332170055887643649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261802204351892)
,p_theme_id=>42
,p_name=>'SPIN'
,p_display_name=>'Spin'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--carouselSpin'
,p_group_id=>wwv_flow_api.id(1332170055887643649)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1418261981748351892)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stack Region'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--stacked'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes side borders and shadows, and can be useful for accordions and regions that need to be grouped together vertically.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437741778445448541)
,p_theme_id=>42
,p_name=>'SPAN_HORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>70
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--spanHorizontally'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437742958039452375)
,p_theme_id=>42
,p_name=>'FLOAT'
,p_display_name=>'Float'
,p_display_sequence=>60
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--float'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437743045630454254)
,p_theme_id=>42
,p_name=>'2_COLUMNS'
,p_display_name=>'2 Columns'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437743149992455426)
,p_theme_id=>42
,p_name=>'3_COLUMNS'
,p_display_name=>'3 Columns'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--3cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437743219909456740)
,p_theme_id=>42
,p_name=>'4_COLUMNS'
,p_display_name=>'4 Columns'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--4cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437743363957458086)
,p_theme_id=>42
,p_name=>'5_COLUMNS'
,p_display_name=>'5 Columns'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--5cols'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437747093491485543)
,p_theme_id=>42
,p_name=>'FEATURED'
,p_display_name=>'Featured'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--featured force-fa-lg'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437747326008486736)
,p_theme_id=>42
,p_name=>'BASIC'
,p_display_name=>'Basic'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--basic'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437747933658490046)
,p_theme_id=>42
,p_name=>'USE_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'u-colors'
,p_template_types=>'LIST'
,p_help_text=>'Applies the colors from the theme''s color palette to the icons or initials within cards.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437749744766501856)
,p_theme_id=>42
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--displayIcons'
,p_group_id=>wwv_flow_api.id(1437745695703477673)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437750157836506330)
,p_theme_id=>42
,p_name=>'DISPLAY_INITIALS'
,p_display_name=>'Display Initials'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--displayInitials'
,p_group_id=>wwv_flow_api.id(1437745695703477673)
,p_template_types=>'LIST'
,p_help_text=>'Initials come from List Attribute 3'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437755216777546994)
,p_theme_id=>42
,p_name=>'2_LINES'
,p_display_name=>'2 Lines'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--desc-2ln'
,p_group_id=>wwv_flow_api.id(1437746379683480702)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437765346354548059)
,p_theme_id=>42
,p_name=>'3_LINES'
,p_display_name=>'3 Lines'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--desc-3ln'
,p_group_id=>wwv_flow_api.id(1437746379683480702)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1437765447649549085)
,p_theme_id=>42
,p_name=>'4_LINES'
,p_display_name=>'4 Lines'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--desc-4ln'
,p_group_id=>wwv_flow_api.id(1437746379683480702)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1443062563414634703)
,p_theme_id=>42
,p_name=>'DISPLAY_AS_PILL_BUTTON'
,p_display_name=>'Display as Pill Button'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--radioButtonGroup'
,p_group_id=>wwv_flow_api.id(1443062277679626593)
,p_template_types=>'FIELD'
,p_help_text=>'Displays the radio buttons to look like a button set / pill button.  Note that the the radio buttons must all be in the same row for this option to work.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1475818147587546912)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'u-colors'
,p_template_types=>'LIST'
,p_help_text=>'Applies colors from the Theme''s color palette to icons in the list.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1480493812321779714)
,p_theme_id=>42
,p_name=>'LIST_SIZE_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--large force-fa-lg'
,p_group_id=>wwv_flow_api.id(1840639733836662642)
,p_template_types=>'LIST'
,p_help_text=>'Increases the size of the text and icons in the list.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485035212186308480)
,p_theme_id=>42
,p_name=>'ACCENT_6'
,p_display_name=>'Accent 6'
,p_display_sequence=>60
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent6'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485035823673309547)
,p_theme_id=>42
,p_name=>'ACCENT_7'
,p_display_name=>'Accent 7'
,p_display_sequence=>70
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent7'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485036183062310522)
,p_theme_id=>42
,p_name=>'ACCENT_8'
,p_display_name=>'Accent 8'
,p_display_sequence=>80
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent8'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485036432555311364)
,p_theme_id=>42
,p_name=>'ACCENT_9'
,p_display_name=>'Accent 9'
,p_display_sequence=>90
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent9'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485036830356312411)
,p_theme_id=>42
,p_name=>'ACCENT_10'
,p_display_name=>'Accent 10'
,p_display_sequence=>100
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent10'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485037124929313435)
,p_theme_id=>42
,p_name=>'ACCENT_11'
,p_display_name=>'Accent 11'
,p_display_sequence=>110
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent11'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485037698030314203)
,p_theme_id=>42
,p_name=>'ACCENT_12'
,p_display_name=>'Accent 12'
,p_display_sequence=>120
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent12'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485037997456315237)
,p_theme_id=>42
,p_name=>'ACCENT_13'
,p_display_name=>'Accent 13'
,p_display_sequence=>130
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent13'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485038362270316173)
,p_theme_id=>42
,p_name=>'ACCENT_14'
,p_display_name=>'Accent 14'
,p_display_sequence=>140
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent14'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1485038691002317127)
,p_theme_id=>42
,p_name=>'ACCENT_15'
,p_display_name=>'Accent 15'
,p_display_sequence=>150
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--accent15'
,p_group_id=>wwv_flow_api.id(686932883424028101)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1512514737713894421)
,p_theme_id=>42
,p_name=>'LARGE_FIELD'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--large'
,p_group_id=>wwv_flow_api.id(1512514270407882520)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1512525751558899364)
,p_theme_id=>42
,p_name=>'X_LARGE_SIZE'
,p_display_name=>'X Large'
,p_display_sequence=>20
,p_css_classes=>'t-Form-fieldContainer--xlarge'
,p_group_id=>wwv_flow_api.id(1512514270407882520)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1517589895250620683)
,p_theme_id=>42
,p_name=>'BASIC'
,p_display_name=>'Basic'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1164140200812557328)
,p_css_classes=>'t-Comments--basic'
,p_group_id=>wwv_flow_api.id(1517530105045469419)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1517606339615707631)
,p_theme_id=>42
,p_name=>'SPEECH_BUBBLES'
,p_display_name=>'Speech Bubbles'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1164140200812557328)
,p_css_classes=>'t-Comments--chat'
,p_group_id=>wwv_flow_api.id(1517530105045469419)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525955285853519017)
,p_theme_id=>42
,p_name=>'2_COLUMNS'
,p_display_name=>'2 Columns'
,p_display_sequence=>15
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525955315642520219)
,p_theme_id=>42
,p_name=>'3_COLUMNS'
,p_display_name=>'3 Columns'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--3cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525955418102521363)
,p_theme_id=>42
,p_name=>'4_COLUMNS'
,p_display_name=>'4 Columns'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--4cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525955521199522870)
,p_theme_id=>42
,p_name=>'5_COLUMNS'
,p_display_name=>'5 Columns'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--5cols'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525955691292525016)
,p_theme_id=>42
,p_name=>'FLOAT'
,p_display_name=>'Float'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--float'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1525955790333526146)
,p_theme_id=>42
,p_name=>'SPAN_HORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>70
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--spanHorizontally'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526010171047577420)
,p_theme_id=>42
,p_name=>'2_LINES'
,p_display_name=>'2 Lines'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--desc-2ln'
,p_group_id=>wwv_flow_api.id(1525956956755555832)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526010276258578315)
,p_theme_id=>42
,p_name=>'3_LINES'
,p_display_name=>'3 Lines'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--desc-3ln'
,p_group_id=>wwv_flow_api.id(1525956956755555832)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526010377091579347)
,p_theme_id=>42
,p_name=>'4_LINES'
,p_display_name=>'4 Lines'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--desc-4ln'
,p_group_id=>wwv_flow_api.id(1525956956755555832)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526010408723581538)
,p_theme_id=>42
,p_name=>'USE_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'u-colors'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526010588016583255)
,p_theme_id=>42
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--displayIcons'
,p_group_id=>wwv_flow_api.id(1525957399615559004)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526010628778584429)
,p_theme_id=>42
,p_name=>'DISPLAY_INITIALS'
,p_display_name=>'Display Initials'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--displayInitials'
,p_group_id=>wwv_flow_api.id(1525957399615559004)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526010706303585631)
,p_theme_id=>42
,p_name=>'FEATURED'
,p_display_name=>'Featured'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--featured force-fa-lg'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1526011053786591079)
,p_theme_id=>42
,p_name=>'BASIC'
,p_display_name=>'Basic'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--basic'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1582559994988798658)
,p_theme_id=>42
,p_name=>'STRETCH_FORM_ITEM'
,p_display_name=>'Stretch Form Item'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--stretchInputs'
,p_template_types=>'FIELD'
,p_help_text=>'Stretches the form item to fill its container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1758443150640520811)
,p_theme_id=>42
,p_name=>'SHOW_NEXT_AND_PREVIOUS_BUTTONS'
,p_display_name=>'Show Next and Previous Buttons'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'t-Region--showCarouselControls'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1773833130039489732)
,p_theme_id=>42
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(561127424267431983)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add shortcuts for menu items. Note that actions.js must be included on your page to support this functionality.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1773833327247490563)
,p_theme_id=>42
,p_name=>'BEHAVE_LIKE_TABS'
,p_display_name=>'Behave Like Tabs'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(561127424267431983)
,p_css_classes=>'js-tabLike'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1773833549635491487)
,p_theme_id=>42
,p_name=>'ENABLE_SLIDE_ANIMATION'
,p_display_name=>'Enable Slide Animation'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(561127424267431983)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1773833721985493171)
,p_theme_id=>42
,p_name=>'SHOW_SUB_MENU_ICONS'
,p_display_name=>'Show Sub Menu Icons'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(561127424267431983)
,p_css_classes=>'js-showSubMenuIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1779026382934967345)
,p_theme_id=>42
,p_name=>'REMEMBER_ACTIVE_TAB'
,p_display_name=>'Remember Active Tab'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1774143203700285855)
,p_css_classes=>'js-useLocalStorage'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805577058603291412)
,p_theme_id=>42
,p_name=>'FIXED_SMALL'
,p_display_name=>'Fixed - Small'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--fixedLabelSmall'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805577215396293454)
,p_theme_id=>42
,p_name=>'FIXED_MEDIUM'
,p_display_name=>'Fixed - Medium'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--fixedLabelMedium'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805577485230295260)
,p_theme_id=>42
,p_name=>'FIXED_LARGE'
,p_display_name=>'Fixed - Large'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--fixedLabelLarge'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805577734956298543)
,p_theme_id=>42
,p_name=>'VARIABLE_LARGE'
,p_display_name=>'Variable - Large'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--variableLabelLarge'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805578291414302969)
,p_theme_id=>42
,p_name=>'VARIABLE_MEDIUM'
,p_display_name=>'Variable - Medium'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--variableLabelMedium'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805578496665305272)
,p_theme_id=>42
,p_name=>'VARIABLE_SMALL'
,p_display_name=>'Variable - Small'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--variableLabelSmall'
,p_group_id=>wwv_flow_api.id(1337807492374178719)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805578790687308244)
,p_theme_id=>42
,p_name=>'LEFT_ALIGNED_DETAILS'
,p_display_name=>'Left Aligned Details'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--leftAligned'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1805578907543309384)
,p_theme_id=>42
,p_name=>'RIGHT_ALIGNED_DETAILS'
,p_display_name=>'Right Aligned Details'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(651486509760474849)
,p_css_classes=>'t-AVPList--rightAligned'
,p_group_id=>wwv_flow_api.id(686934797631028101)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1819505187528387194)
,p_theme_id=>42
,p_name=>'HIDE_ICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--noIcon'
,p_group_id=>wwv_flow_api.id(1819504545813380867)
,p_template_types=>'REGION'
,p_help_text=>'Hides alert icons'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1819505330686391846)
,p_theme_id=>42
,p_name=>'SHOW_CUSTOM_ICONS'
,p_display_name=>'Show Custom Icons'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(591654834181983844)
,p_css_classes=>'t-Alert--customIcons'
,p_group_id=>wwv_flow_api.id(1819504545813380867)
,p_template_types=>'REGION'
,p_help_text=>'Set custom icons by modifying the Alert Region''s Icon CSS Classes property.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1823214089216124154)
,p_theme_id=>42
,p_name=>'COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--compact'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
,p_help_text=>'Use this option when you want to show smaller cards.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1823218623268133955)
,p_theme_id=>42
,p_name=>'HIDDEN_BODY_TEXT'
,p_display_name=>'Hidden'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_css_classes=>'t-Cards--hideBody'
,p_group_id=>wwv_flow_api.id(1437746379683480702)
,p_template_types=>'LIST'
,p_help_text=>'This option hides the card body which contains description and subtext.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1823341639365252326)
,p_theme_id=>42
,p_name=>'COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--compact'
,p_group_id=>wwv_flow_api.id(1525957602312561277)
,p_template_types=>'REPORT'
,p_help_text=>'Use this option when you want to show smaller cards.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1823341832326254505)
,p_theme_id=>42
,p_name=>'HIDDEN_BODY_TEXT'
,p_display_name=>'Hidden'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(1525953837592492828)
,p_css_classes=>'t-Cards--hideBody'
,p_group_id=>wwv_flow_api.id(1525956956755555832)
,p_template_types=>'REPORT'
,p_help_text=>'This option hides the card body which contains description and subtext.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1840640333182666537)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1840624874773603093)
,p_css_classes=>'t-Tabs--large'
,p_group_id=>wwv_flow_api.id(1840639733836662642)
,p_template_types=>'LIST'
,p_help_text=>'Increases font size and white space around tab items.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1840640584632670330)
,p_theme_id=>42
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1840624874773603093)
,p_css_classes=>'t-Tabs--simple'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
,p_help_text=>'A very simplistic tab UI.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1840640714366677118)
,p_theme_id=>42
,p_name=>'PILL'
,p_display_name=>'Pill'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1840624874773603093)
,p_css_classes=>'t-Tabs--pill'
,p_group_id=>wwv_flow_api.id(1093528122542993730)
,p_template_types=>'LIST'
,p_help_text=>'Displays tabs in a pill container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1840640959032680779)
,p_theme_id=>42
,p_name=>'INLINE_WITH_LABEL'
,p_display_name=>'Inline with Label'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(1840624874773603093)
,p_css_classes=>'t-Tabs--inlineIcons'
,p_group_id=>wwv_flow_api.id(1437745695703477673)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1840641188331684977)
,p_theme_id=>42
,p_name=>'ABOVE_LABEL'
,p_display_name=>'Above Label'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(1840624874773603093)
,p_css_classes=>'t-Tabs--iconsAbove'
,p_group_id=>wwv_flow_api.id(1437745695703477673)
,p_template_types=>'LIST'
,p_help_text=>'Places icons above tab label.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1840771248368857341)
,p_theme_id=>42
,p_name=>'FILL_LABELS'
,p_display_name=>'Fill Labels'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(1840624874773603093)
,p_css_classes=>'t-Tabs--fillLabels'
,p_group_id=>wwv_flow_api.id(686932580235028101)
,p_template_types=>'LIST'
,p_help_text=>'Stretch tabs to fill to the width of the tabs container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1840772056805868916)
,p_theme_id=>42
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>5
,p_list_template_id=>wwv_flow_api.id(1840624874773603093)
,p_css_classes=>'t-Tabs--small'
,p_group_id=>wwv_flow_api.id(1840639733836662642)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1857525073392915857)
,p_theme_id=>42
,p_name=>'FILL_TAB_LABELS'
,p_display_name=>'Fill Tab Labels'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1774143203700285855)
,p_css_classes=>'t-TabsRegion-mod--fillLabels'
,p_group_id=>wwv_flow_api.id(1857478787516903577)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1857525298156917410)
,p_theme_id=>42
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1774143203700285855)
,p_css_classes=>'t-TabsRegion-mod--simple'
,p_group_id=>wwv_flow_api.id(1857479096126905096)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1857528892294919146)
,p_theme_id=>42
,p_name=>'PILL'
,p_display_name=>'Pill'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1774143203700285855)
,p_css_classes=>'t-TabsRegion-mod--pill'
,p_group_id=>wwv_flow_api.id(1857479096126905096)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1857529220071921213)
,p_theme_id=>42
,p_name=>'TABS_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(1774143203700285855)
,p_css_classes=>'t-TabsRegion-mod--small'
,p_group_id=>wwv_flow_api.id(1857480037379911594)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1857540160986922312)
,p_theme_id=>42
,p_name=>'TABSLARGE'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1774143203700285855)
,p_css_classes=>'t-TabsRegion-mod--large'
,p_group_id=>wwv_flow_api.id(1857480037379911594)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1945816593056340775)
,p_theme_id=>42
,p_name=>'SHOW_ICONS'
,p_display_name=>'Show Icons'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--showIcons'
,p_template_types=>'LIST'
,p_help_text=>'Display an icon next to the list item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1945817529318346106)
,p_theme_id=>42
,p_name=>'SHOW_DESCRIPTION'
,p_display_name=>'Show Description'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--showDesc'
,p_template_types=>'LIST'
,p_help_text=>'Shows the description (Attribute 1) for each list item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(1945817867103351016)
,p_theme_id=>42
,p_name=>'SHOW_BADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_css_classes=>'t-MediaList--showBadges'
,p_template_types=>'LIST'
,p_help_text=>'Show a badge (Attribute 2) to the right of the list item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2152176995371063683)
,p_theme_id=>42
,p_name=>'ADD_BODY_PADDING'
,p_display_name=>'Add Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(873087052820635270)
,p_css_classes=>'t-ContentBlock--padded'
,p_template_types=>'REGION'
,p_help_text=>'Adds padding to the region''s body container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2152188547704242450)
,p_theme_id=>42
,p_name=>'SHADOW_BACKGROUND'
,p_display_name=>'Shadow Background'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(873087052820635270)
,p_css_classes=>'t-ContentBlock--shadowBG'
,p_group_id=>wwv_flow_api.id(2152178420884088035)
,p_template_types=>'REGION'
,p_help_text=>'Gives the region body a slightly darker background.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2152188840015248645)
,p_theme_id=>42
,p_name=>'LIGHT_BACKGROUND'
,p_display_name=>'Light Background'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(873087052820635270)
,p_css_classes=>'t-ContentBlock--lightBG'
,p_group_id=>wwv_flow_api.id(2152178420884088035)
,p_template_types=>'REGION'
,p_help_text=>'Gives the region body a slightly lighter background.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2250019549067012060)
,p_theme_id=>42
,p_name=>'SHOW_MAXIMIZE_BUTTON'
,p_display_name=>'Show Maximize Button'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'js-showMaximizeButton'
,p_template_types=>'REGION'
,p_help_text=>'Displays a button in the Region Header to maximize the region. Clicking this button will toggle the maximize state and stretch the region to fill the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2250073074620085614)
,p_theme_id=>42
,p_name=>'SHOW_MAXIMIZE_BUTTON'
,p_display_name=>'Show Maximize Button'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(651498026300583706)
,p_css_classes=>'js-showMaximizeButton'
,p_template_types=>'REGION'
,p_help_text=>'Displays a button in the Interactive Reports toolbar to maximize the report. Clicking this button will toggle the maximize state and stretch the report to fill the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2250125868908110127)
,p_theme_id=>42
,p_name=>'SHOW_MAXIMIZE_BUTTON'
,p_display_name=>'Show Maximize Button'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'js-showMaximizeButton'
,p_template_types=>'REGION'
,p_help_text=>'Displays a button in the Region Header to maximize the region. Clicking this button will toggle the maximize state and stretch the region to fill the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2264893908431592276)
,p_theme_id=>42
,p_name=>'VERTICAL_LIST'
,p_display_name=>'Vertical Orientation'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(561120526789187584)
,p_css_classes=>'t-WizardSteps--vertical'
,p_template_types=>'LIST'
,p_help_text=>'Displays the wizard progress list in a vertical orientation and is suitable for displaying within a side column of a page.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2380813654357274785)
,p_theme_id=>42
,p_name=>'10_SECONDS'
,p_display_name=>'10 Seconds'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'js-cycle10s'
,p_group_id=>wwv_flow_api.id(1332170259565645642)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2380813825009276231)
,p_theme_id=>42
,p_name=>'15_SECONDS'
,p_display_name=>'15 Seconds'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'js-cycle15s'
,p_group_id=>wwv_flow_api.id(1332170259565645642)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2380814252918279535)
,p_theme_id=>42
,p_name=>'20_SECONDS'
,p_display_name=>'20 Seconds'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(1418258663404351882)
,p_css_classes=>'js-cycle20s'
,p_group_id=>wwv_flow_api.id(1332170259565645642)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2380826718554404144)
,p_theme_id=>42
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'i-h480'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets body height to 480px.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2380826978315406723)
,p_theme_id=>42
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'i-h640'
,p_group_id=>wwv_flow_api.id(686935554787028101)
,p_template_types=>'REGION'
,p_help_text=>'Sets body height to 640px.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2380838853145460918)
,p_theme_id=>42
,p_name=>'SHOW_TITLE'
,p_display_name=>'Show Title'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(670020401234384587)
,p_css_classes=>'t-Wizard--showTitle'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2470780003349555916)
,p_theme_id=>42
,p_name=>'REMOVE_UI_DECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(1215306280710140812)
,p_css_classes=>'t-Region--noUI'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes UI decoration (borders, backgrounds, shadows, etc) from the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(2471213186329560663)
,p_theme_id=>42
,p_name=>'REMOVE_UI_DECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(2623330321607852408)
,p_css_classes=>'t-Region--noUI'
,p_group_id=>wwv_flow_api.id(686932753785028101)
,p_template_types=>'REGION'
,p_help_text=>'Removes UI decoration (borders, backgrounds, shadows, etc) from the region.'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(10646301435715879852)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>'Would you like to perform this delete action?'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(10647329157070899202)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>'Are you sure you want to leave this page without saving?'
);
end;
/
prompt --application/shared_components/security/authentications/application_express
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(6617513688278274885)
,p_name=>'Application Express'
,p_scheme_type=>'NATIVE_APEX_ACCOUNTS'
,p_invalid_session_type=>'LOGIN'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_comments=>'Based on authentication scheme from gallery:Existing Login Page: Use Application Express Account Credentials'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_disp_template_options
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(808180558331983447)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.DISP_TEMPLATE_OPTIONS'
,p_display_name=>'Display Template Options'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.DISP_TEMPLATE_OPTIONS'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_default (',
'  p_template_type   in varchar2,',
'  p_template_name   in varchar2,',
'  p_css             in varchar2',
') return varchar2',
'is',
'    l_vc_arr2       APEX_APPLICATION_GLOBAL.VC_ARR2;',
'    stmt            varchar2(4000);',
'    l_table_name    varchar2(255);',
'    l_def_opt       varchar2(255);',
'    l_preset_opt    varchar2(255);',
'    l_flag          varchar2(1) := ''N'';',
'    ',
'begin',
'',
'  if p_template_type = ''REGION'' then',
'    l_table_name := ''APEX_APPLICATION_TEMP_REGION'';',
'  elsif p_template_type = ''BUTTON'' then',
'    l_table_name := ''APEX_APPLICATION_TEMP_BUTTON'';',
'  elsif p_template_type = ''PAGE'' then',
'    l_table_name := ''APEX_APPLICATION_TEMP_PAGE'';',
'  elsif p_template_type = ''REPORT'' then',
'    l_table_name := ''APEX_APPLICATION_TEMP_REPORT'';',
'  elsif p_template_type = ''FIELD'' then',
'    l_table_name := ''APEX_APPLICATION_TEMP_LABEL'';',
'  elsif p_template_type = ''LIST'' then',
'    l_table_name := ''APEX_APPLICATION_TEMP_LIST'';',
'  end if;',
'    ',
'  stmt := ''begin ',
'            select default_template_options, preset_template_options ',
'              into :into_bind_default, :into_bind_preset  from  '' ',
'                || l_table_name ',
'                || '' where template_name = :bind_name and application_id = ''||v(''APP_ID'')||''; end;'';',
'  ',
'   execute immediate stmt',
'               using out l_def_opt,',
'                     out l_preset_opt, ',
'                      IN p_template_name;',
'',
'    ',
'    if l_def_opt = p_css then',
'      l_flag :=''Y'';',
'    else',
'      l_vc_arr2 := APEX_UTIL.STRING_TO_TABLE(l_preset_opt);',
'      FOR z IN 1..l_vc_arr2.count LOOP',
'          if p_css = l_vc_arr2(z) then',
'            l_flag := ''Y'';',
'          end if;',
'      END LOOP;',
'    end if;',
'    ',
'    return l_flag;',
'    ',
'    exception when others then return ''N'';',
'    ',
'end is_default;',
'',
'',
'FUNCTION render(',
'    p_region              IN apex_plugin.t_region,',
'    p_plugin              IN apex_plugin.t_plugin,',
'    p_is_printer_friendly IN BOOLEAN )',
'  RETURN apex_plugin.t_region_render_result',
'IS',
'  p_template_type               varchar2(100) := p_region.attribute_01;',
'  p_template_name               varchar2(100) := COALESCE( p_region.attribute_02,',
'                                                           p_region.attribute_03,',
'                                                           p_region.attribute_04,',
'                                                           p_region.attribute_05,',
'                                                           p_region.attribute_06,',
'                                                           p_region.attribute_07);',
'  l_output_li                   clob;',
'  l_advanced_html               varchar2(100);',
'  l_advanced_class              varchar2(100);',
'  l_is_default_class            varchar2(100);',
'  l_default_icon                varchar2(100);',
'  l_general_icon                varchar2(100);',
'',
'  l_is_default                  varchar2(1);',
'  is_postfix_added              boolean := false;',
'  is_default_added_for_global   boolean := false;',
'  is_default_found              boolean := false;',
'  is_outside_set                boolean := true;',
'  l_rows                        clob;',
'',
'BEGIN',
'',
'    for c1 in ( select distinct',
'                    o.application_id,',
'                    nvl(g.display_name, ''General'') as group_name,',
'                    nvl(g.display_sequence, 0) display_sequence,',
'                    nvl(g.is_advanced, ''N'') is_advanced,',
'                    ''N'' as is_global,',
'                    g.null_text as default_text,',
'                    g.help_text,',
'                    o.group_id',
'                from apex_appl_template_options o,',
'                    apex_appl_template_opt_groups g',
'                where o.application_id = v(''APP_ID'')',
'                    and o.group_id         = g.template_opt_group_id (+)',
'                    and o.theme_number     = 42',
'                    and case p_template_type',
'                            when ''BUTTON'' then o.button_template',
'                            when ''REPORT'' then o.report_template',
'                            when ''REGION'' then o.region_template',
'                            when ''LIST''   then o.list_template',
'                            when ''PAGE''   then o.page_template',
'                        end = p_template_name',
'                union all',
'                select distinct',
'                    o.application_id,',
'                    nvl(g.display_name, ''General'') as group_name,',
'                    nvl(g.display_sequence, 0) display_sequence,',
'                    nvl(g.is_advanced, ''N'') is_advanced,',
'                    ''Y'' as is_global,',
'                    g.null_text as default_text,',
'                    g.help_text,',
'                    o.group_id',
'                from apex_appl_template_options o,',
'                    apex_appl_template_opt_groups g',
'                where o.application_id   = v(''APP_ID'')',
'                    and o.group_id = g.template_opt_group_id (+)',
'                    and o.theme_number = 42',
'                    and virtual_template_id is null',
'                    and o.template_types = p_template_type',
'                order by is_advanced,',
'                    display_sequence,',
'                    group_name ) loop',
'        -- Are we advanced?',
'        if c1.is_advanced = ''Y'' then',
'            l_advanced_html    := ''<span class="dm-TO-groupType">Advanced</span>'';',
'            l_advanced_class   := '' is-advanced'';',
'        end if;',
'        -- Emit the header',
'        l_output_li := l_output_li||''<li class="dm-TO-group''||l_advanced_class||'' row">',
'            <div class="dm-TO-info col col-4">''||l_advanced_html||',
'            ''<h3 class="dm-TO-groupTitle">''||c1.group_name||''</h3>',
'            <p class="dm-TO-groupDesc">'' || c1.help_text || ''</p>',
'            </div><div class="dm-TO-body col col-8">',
'            <ul class="dm-TO-optionsList container">'';',
'',
'        -- Do the rows',
'        is_default_found := false;',
'        l_rows           := null;',
'',
'        for c2 in ( select case p_template_type',
'                            when ''BUTTON'' then button_template',
'                            when ''REPORT'' then report_template',
'                            when ''FIELD''  then field_template',
'                            when ''REGION'' then region_template',
'                            when ''LIST''   then list_template',
'                            when ''PAGE''   then page_template',
'                        end as template_type,',
'                        o.display_name,',
'                        o.css_classes,',
'                        o.help_text,',
'                        nvl(o.display_sequence, 0) display_sequence',
'                    from apex_appl_template_options o',
'                    where o.application_id = c1.application_id',
'                        and o.theme_number = 42',
'                        and case p_template_type',
'                                when ''BUTTON'' then o.button_template',
'                                when ''REPORT'' then o.report_template',
'                                when ''REGION'' then o.region_template',
'                                when ''LIST''   then o.list_template',
'                                when ''PAGE''   then o.page_template',
'                            end = p_template_name',
'                        and ( (c1.group_id is null and o.group_id is null)',
'                            or o.group_id = c1.group_id )',
'                    union all',
'                    select ''Global'' as template_type,',
'                        o.display_name,',
'                        o.css_classes,',
'                        o.help_text,',
'                        nvl(o.display_sequence, 0) display_sequence',
'                    from apex_appl_template_options o',
'                    where o.application_id = c1.application_id',
'                        and o.theme_number = 42',
'                        and o.virtual_template_id is null',
'                        and o.template_types = p_template_type',
'                        and ( (c1.group_id is null and o.group_id is null)',
'                            or o.group_id = c1.group_id )',
'                    order by display_sequence ) loop',
'                    ',
'            if is_default(p_template_type, c2.template_type, c2.css_classes) = ''Y'' then',
'                is_default_found    := true;',
'                l_is_default_class  := ''is-default'';',
'                l_default_icon      := ''<span class="t-Icon fa fa-check-circle"></span>'';',
'                l_general_icon      := null;',
'            else',
'                l_is_default_class  := null;',
'                l_default_icon      := null;',
'                if c1.group_name = ''General'' then',
'                  l_general_icon    := ''<span class="t-Icon fa fa-square-o"></span>'';',
'                else',
'                  l_general_icon := null;',
'                end if;',
'            end if;',
'            ',
'            l_rows := l_rows || ''<li class="dm-TO-options '' || l_is_default_class || '' row">',
'                                <div class="dm-TO-option col col-4">'' || l_default_icon || l_general_icon || c2.display_name || ''</div>',
'                                <div class="dm-TO-desc col col-8">'' || c2.help_text ||''</div>',
'                              </li>'';',
'        end loop;',
'',
'        if is_default_found = false then',
'            if c1.default_text is not null then',
'                l_rows := ''<li class="dm-TO-options is-default row">',
'                                <div class="dm-TO-option col col-4"><span class="t-Icon fa fa-check-circle"></span>'' || c1.default_text || ''</div>',
'                                <div class="dm-TO-desc col col-8"></div>',
'                              </li>'' || l_rows;',
'            else',
'                l_rows := ''<li class="dm-TO-options is-default row">',
'                    <div class="dm-TO-option col col-4"><span class="t-Icon fa fa-check-square"></span>Use Template Defaults</div>',
'                    <div class="dm-TO-desc col col-8"></div>',
'                  </li>'' || l_rows;',
'            end if;',
'        end if;',
'            ',
'        l_output_li := l_output_li || l_rows;',
'        l_output_li := l_output_li || ''</ul></div></li>'';',
'    end loop;',
'',
'    sys.htp.p(''<div class="dm-TO"><ul class="dm-TO-list container">'' || l_output_li || ''</ul></div>'');',
'    return null;',
'END render;',
''))
,p_api_version=>1
,p_render_function=>'render'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(823033390057708888)
,p_plugin_id=>wwv_flow_api.id(808180558331983447)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Template Type'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUTTON'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823037512102740417)
,p_plugin_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_display_sequence=>10
,p_display_value=>'BUTTON'
,p_return_value=>'BUTTON'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823037950320740869)
,p_plugin_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_display_sequence=>20
,p_display_value=>'REPORT'
,p_return_value=>'REPORT'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823039524085771184)
,p_plugin_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_display_sequence=>30
,p_display_value=>'FIELD'
,p_return_value=>'FIELD'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823039954491771597)
,p_plugin_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_display_sequence=>40
,p_display_value=>'REGION'
,p_return_value=>'REGION'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823040360957772040)
,p_plugin_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_display_sequence=>50
,p_display_value=>'LIST'
,p_return_value=>'LIST'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823040752870772577)
,p_plugin_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_display_sequence=>60
,p_display_value=>'PAGE'
,p_return_value=>'PAGE'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(823034000947718905)
,p_plugin_id=>wwv_flow_api.id(808180558331983447)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Region'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'Alert'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'REGION'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823038953543763025)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>10
,p_display_value=>'Alert'
,p_return_value=>'Alert'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823045746594845103)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>20
,p_display_value=>'Hero'
,p_return_value=>'Hero'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(210194939364690813)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>25
,p_display_value=>'Inline Popup'
,p_return_value=>'Inline Popup'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823046182555845862)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>30
,p_display_value=>'Inline Dialog'
,p_return_value=>'Inline Dialog'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823046581875846577)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>40
,p_display_value=>'Collapsible'
,p_return_value=>'Collapsible'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823046918104847089)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>50
,p_display_value=>'Buttons Container'
,p_return_value=>'Buttons Container'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823047490234847725)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>60
,p_display_value=>'Tabs Container'
,p_return_value=>'Tabs Container'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823047835559848224)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>70
,p_display_value=>'Title Bar'
,p_return_value=>'Title Bar'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823048227162848609)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>80
,p_display_value=>'Standard'
,p_return_value=>'Standard'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823048697502849086)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>90
,p_display_value=>'Carousel Container'
,p_return_value=>'Carousel Container'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823049069689849527)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>100
,p_display_value=>'Interactive Report'
,p_return_value=>'Interactive Report'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823049510693850101)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>110
,p_display_value=>'Wizard Container'
,p_return_value=>'Wizard Container'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(2199876750823529983)
,p_plugin_attribute_id=>wwv_flow_api.id(823034000947718905)
,p_display_sequence=>120
,p_display_value=>'Blank with Attributes'
,p_return_value=>'Blank with Attributes'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(823073294173864568)
,p_plugin_id=>wwv_flow_api.id(808180558331983447)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Page'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'Modal Dialog'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'PAGE'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823073817001864938)
,p_plugin_attribute_id=>wwv_flow_api.id(823073294173864568)
,p_display_sequence=>10
,p_display_value=>'Modal Dialog'
,p_return_value=>'Modal Dialog'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823074280607865458)
,p_plugin_attribute_id=>wwv_flow_api.id(823073294173864568)
,p_display_sequence=>20
,p_display_value=>'Wizard Modal Dialog'
,p_return_value=>'Wizard Modal Dialog'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(823075516629874833)
,p_plugin_id=>wwv_flow_api.id(808180558331983447)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'List'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'Wizard Progress'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'LIST'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823076194435875579)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>10
,p_display_value=>'Wizard Progress'
,p_return_value=>'Wizard Progress'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823076596813875841)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>20
,p_display_value=>'Top Navigation Menu'
,p_return_value=>'Top Navigation Menu'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823076972491876781)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>30
,p_display_value=>'Links List'
,p_return_value=>'Links List'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823077454907877558)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>40
,p_display_value=>'Menu Bar'
,p_return_value=>'Menu Bar'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823077901514878094)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>50
,p_display_value=>'Badge List'
,p_return_value=>'Badge List'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823078328093878516)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>60
,p_display_value=>'Media List'
,p_return_value=>'Media List'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823078761986878944)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>70
,p_display_value=>'Cards'
,p_return_value=>'Cards'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823079125883879358)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>80
,p_display_value=>'Tabs'
,p_return_value=>'Tabs'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(737134508194738569)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>90
,p_display_value=>'Side Navigation Menu'
,p_return_value=>'Side Navigation Menu'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(737147367827739764)
,p_plugin_attribute_id=>wwv_flow_api.id(823075516629874833)
,p_display_sequence=>100
,p_display_value=>'Top Navigation Tabs'
,p_return_value=>'Top Navigation Tabs'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(823081886408890801)
,p_plugin_id=>wwv_flow_api.id(808180558331983447)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Report'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'Standard'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'REPORT'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823082493882891283)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'Standard'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823082831912891686)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>20
,p_display_value=>'Cards'
,p_return_value=>'Cards'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823083279872892128)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>30
,p_display_value=>'Timeline'
,p_return_value=>'Timeline'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823083693760892515)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>40
,p_display_value=>'Badge List'
,p_return_value=>'Badge List'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823084041437892910)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>50
,p_display_value=>'Comments'
,p_return_value=>'Comments'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823084506456893484)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>60
,p_display_value=>'Value Attribute Pairs - Row'
,p_return_value=>'Value Attribute Pairs - Row'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823084974421893910)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>70
,p_display_value=>'Value Attribute Pairs - Column'
,p_return_value=>'Value Attribute Pairs - Column'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(360878897464270468)
,p_plugin_attribute_id=>wwv_flow_api.id(823081886408890801)
,p_display_sequence=>80
,p_display_value=>'Content Row'
,p_return_value=>'Content Row'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(823085368895900725)
,p_plugin_id=>wwv_flow_api.id(808180558331983447)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Button'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'Text with Icon'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'BUTTON'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823085953858901844)
,p_plugin_attribute_id=>wwv_flow_api.id(823085368895900725)
,p_display_sequence=>10
,p_display_value=>'Text with Icon'
,p_return_value=>'Text with Icon'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823095249812003861)
,p_plugin_attribute_id=>wwv_flow_api.id(823085368895900725)
,p_display_sequence=>20
,p_display_value=>'Icon Only'
,p_return_value=>'-'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823095633327004906)
,p_plugin_attribute_id=>wwv_flow_api.id(823085368895900725)
,p_display_sequence=>30
,p_display_value=>'Text Only'
,p_return_value=>'-'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(823088048062913500)
,p_plugin_id=>wwv_flow_api.id(808180558331983447)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Field'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_default_value=>'Field'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(823033390057708888)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'FIELD'
,p_lov_type=>'STATIC'
);
wwv_flow_api.create_plugin_attr_value(
 p_id=>wwv_flow_api.id(823090315167933226)
,p_plugin_attribute_id=>wwv_flow_api.id(823088048062913500)
,p_display_sequence=>10
,p_display_value=>'Field'
,p_return_value=>'Field'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_how_to_instructions
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(1645378874274309670)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_display_name=>'How To Instructions'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure concat (',
'    p_result in out nocopy varchar2,',
'    p_text   in            varchar2 )',
'is',
'begin',
'    if p_text is not null then',
'        p_result := p_result || p_text; ',
'    end if;',
'end concat;',
'',
'function yes_or_no (',
'    p_true_or_false in boolean )',
'    return varchar2',
'is',
'begin',
'    return case when     p_true_or_false then ''Yes''',
'                when not p_true_or_false then ''No''',
'                else null',
'           end;',
'end yes_or_no;',
'',
'procedure tr_td (',
'  l_result in out nocopy varchar2,',
'  l_label  in            varchar2,',
'  l_text   in            varchar2)',
'is',
'  l_text_print varchar2(32767);',
'begin ',
'    if l_label is not null and l_text is not null then',
'        l_text_print := l_text;',
'        if l_text = ''Y'' or l_text= ''N'' then',
'            l_text_print := yes_or_no(l_text = ''Y'');',
'        end if;',
'        concat(l_result, ''<li class="dm-Instructions-listItem"><span class="dm-Instructions-label">'' || l_label || ''</span><span class="dm-Instructions-value">'' || l_text_print || ''</span></li>'');',
'    end if;',
'end tr_td;',
'',
'',
'procedure append_item (',
'    p_result in out nocopy varchar2,',
'    p_text   in            varchar2,',
'    p_prefix in            varchar2 )',
'is',
'begin',
'    if p_text is not null then',
'        concat( p_result, ''<div>'' || p_prefix || '' <strong>'' || p_text || ''</strong></div>''); ',
'    end if;',
'end append_item;',
'',
'procedure write_section_header (',
'  l_result       in out nocopy varchar2,',
'  l_header_title in            varchar2 )',
'is',
'begin',
'  concat(l_result, ''<table><tr><th colspan="2">'' || l_header_title || ''</th></tr>'');',
'end write_section_header;',
'',
'function get_grid_options (',
'    p_table_name in varchar2,',
'    p_id_column  in varchar2,',
'    p_id_value   in number )',
'    return varchar2',
'is',
'    l_result                  varchar2( 32767 );',
'    l_new_grid                varchar(3);',
'    l_new_grid_row            varchar(3);',
'    l_new_grid_column         varchar(3);',
'    l_grid_column             number;',
'    l_grid_column_span        number;',
'    l_grid_column_attributes  varchar(255);',
'    l_grid_column_css_classes varchar(255);',
'begin',
'    execute immediate',
'        ''select new_grid, new_grid_column, grid_column, grid_column_span, grid_column_attributes, grid_column_css_classes from '' || p_table_name || '' where '' || p_id_column || ''= :id''',
'       into l_new_grid, l_new_grid_column, l_grid_column, l_grid_column_span, l_grid_column_attributes, l_grid_column_css_classes',
'      using in p_id_value;',
'',
'    concat(l_result, ''<ul class="dm-Instructions-list">'');',
'    tr_td(l_result, ''New Grid'', yes_or_no(l_new_grid = ''Yes''));',
'    tr_td(l_result, ''New Grid Row'', yes_or_no(l_new_grid_row = ''Yes''));',
'    tr_td(l_result, ''New Grid Column'', yes_or_no(l_new_grid_column = ''Yes''));',
'    if l_grid_column is null then',
'      tr_td(l_result, ''Grid Column'', ''Automatic'');',
'    else',
'      tr_td(l_result, ''Grid Column'', l_grid_column);',
'    end if; ',
'    if l_grid_column_span is null then',
'      tr_td(l_result, ''Grid Column Span'', ''Automatic'');',
'    else',
'      tr_td(l_result, ''Grid Column Span'', l_grid_column_span);',
'    end if; ',
'    tr_td(l_result, ''Column Attributes'', l_grid_column_attributes);',
'    tr_td(l_result, ''Column CSS Classes'', l_grid_column_css_classes);',
'    return l_result || ''</ul>'';',
'end get_grid_options;',
'',
'',
'function get_template_option_descr (',
'    p_template_id      in number,',
'    p_template_type    in varchar2,',
'    p_template_options in varchar2 )',
'    return varchar2',
'is',
'    l_options            wwv_flow_global.vc_arr2;',
'    l_result             varchar2( 32767 ) := ''<ul class="dm-Instructions-list">'';',
'    l_has_result         boolean := false;',
'    l_label              varchar2( 32767 ) := null;',
'    l_text               varchar2( 32767 ) := null;',
'    l_group_display_name apex_appl_template_opt_groups.display_name%type;',
'    l_display_name       apex_appl_template_options.display_name%type;',
'    l_is_advanced        apex_appl_template_opt_groups.is_advanced%type;',
'begin',
'    l_options := wwv_flow_utilities.string_to_table2( p_template_options );',
'',
'    for i in 1 .. l_options.count loop',
'        if l_options(i) = ''#DEFAULT#'' then',
'            l_label:= ''Use Default'';',
'            l_text := ''<strong>Yes</strong>'';',
'        else',
'            /* if the first entry isn''t the #DEFAULT# placeholder, we still want to show that default has to be set to No */',
'            if i = 1 then',
'                tr_td(l_result, ''Use Default'', ''<strong>No</strong>'');',
'            end if;',
'            begin',
'               l_text := l_options( i );',
'               select g.display_name as group_display_name,',
'                      o.display_name,',
'                      g.is_advanced',
'                 into l_group_display_name,',
'                      l_display_name,',
'                      l_is_advanced',
'                 from apex_appl_template_options o,',
'                      apex_appl_template_opt_groups g',
'                where o.application_id = apex_application.g_flow_id',
'                  and o.theme_number   = 42',
'                  and (  ( o.virtual_template_type = p_template_type and o.virtual_template_id = p_template_id )',
'                      or ( o.virtual_template_id is null and o.template_types = p_template_type )',
'                      )',
'                  and o.css_classes    = l_options( i )',
'                  and g.template_opt_group_id (+) = o.group_id;',
'                if l_group_display_name is not null then',
'                    if l_is_advanced = ''Y'' then',
'                        l_label := ''Advanced '' || l_group_display_name;',
'                    else',
'                        l_label := l_group_display_name;',
'                    end if;',
'                    l_text := l_display_name;',
'                else',
'                    l_label := l_display_name;',
'                    l_text := ''Yes'';',
'                end if;',
'            exception when no_data_found then',
'                l_text := ''Unknown Option '' || l_options( i );',
'            end;',
'        end if;',
'        --concat(l_result, l_label);',
'        --concat(l_result, l_text);',
'        tr_td(l_result, l_label, l_text);',
'        l_label := null;',
'        l_text := null;',
'    end loop;',
'    return l_result || ''</ul>'';',
'end get_template_option_descr;',
'',
'function get_region_items_descr (',
'    p_region_id         in number,',
'    p_show_grid_options in boolean )',
'    return varchar2',
'is',
'    l_result    varchar2( 32767 ) := ''<div class="dm-Instructions-title">Region Items<div>'';',
'    l_has_items boolean := false;',
'begin',
'    for l_item in ( select item_id,',
'                           item_name,',
'                           display_as,',
'                           item_template_options,',
'                           item_source_type,',
'                           item_default_type,',
'                           item_data_type',
'                      from apex_application_page_items',
'                     where region_id = p_region_id',
'                     order by display_sequence )',
'    loop',
'        l_has_items := true;',
'        l_result := l_result || ',
'             ''<div><span class="how-to-page-item-title">'' || l_item.display_as || '' <strong>'' ||  l_item.item_name || ''</strong></span><div>Template Options'' || ',
'             get_template_option_descr(',
'                 p_template_options => l_item.item_template_options,',
'                 p_template_type    => ''THEME'',',
'                 p_template_id      => 1',
'             ) || ''</div></div>'';',
'      if p_show_grid_options then',
'          l_result := l_result || ''Grid Options: '' ||',
'                      get_grid_options(',
'                          p_table_name => ''apex_application_page_items'',',
'                          p_id_column  => ''item_id'',',
'                          p_id_value   => l_item.item_id);',
'      end if;',
'      --concat(l_result, ''</div>'');',
'      concat(l_result, l_item.item_source_type || '' - '' || l_item.item_default_type || '' - '' || l_item.item_data_type);',
'      end loop;',
'    concat(l_result, ''</div></div>'');',
'    if not l_has_items then',
'       l_result := null;',
'    end if;',
'    return l_result;',
'end get_region_items_descr;',
'',
'function get_region_buttons_descr (',
'    p_region_id      in number )',
'    return varchar2',
'is',
'    l_result      varchar2( 32767 ) := ''<h4 class="dm-Instructions-subTitle">Region Buttons</h4>'';',
'    l_has_buttons boolean := false;',
'begin',
'    for l_button in ( select button_name,',
'                             button_template,',
'                             display_position,',
'                             button_css_classes,',
'                             icon_css_classes,',
'                             button_template_options,',
'                             button_template_id',
'                        from apex_application_page_buttons',
'                       where region_id = p_region_id',
'                       order by button_sequence )',
'    loop',
'       l_has_buttons := true;',
'       l_result := l_result || ',
'            ''<div class="dm-Instructions-buttonRow"><ul class="dm-Instructions-list"><li class="dm-Instructions-listItem"><span class="dm-Instructions-label">'' || l_button.button_template || ''</span><span class="dm-Instructions-value">'' ||  l_button.'
||'button_name || ''</span></li></ul></div>'' || ',
'            get_template_option_descr(',
'                p_template_options => l_button.button_template_options,',
'                p_template_type    => ''BUTTON'',',
'                p_template_id      => l_button.button_template_id );',
'        concat(l_result, ''<ul class="dm-Instructions-list">'');',
'        tr_td(l_result, ''Button Template'', l_button.button_template);',
'        tr_td(l_result, ''Button Position'', l_button.display_position);',
'        concat(l_result, ''</ul>'');',
'        concat(l_result, ''</div>'');',
'    end loop;',
'    concat(l_result, ''</div></div>'');',
'',
'    if not l_has_buttons then',
'       l_result := null;',
'    end if;',
'    return l_result;',
'end get_region_buttons_descr;',
'',
'function get_plugin_attributes (',
'    p_plugin_name in varchar2,',
'    p_plugin_type in varchar2,',
'    p_values      in apex_application_global.vc_arr2 )',
'    return varchar2',
'is',
'    c_application_id constant number := case when p_plugin_name like ''NATIVE_%'' then 4411 else apex_application.g_flow_id end;',
'',
'    l_result         varchar2( 32767 ) := ''<ul class="dm-Instructions-list">'';',
'    l_display_value  varchar2( 255 );',
'    l_has_attributes boolean := false;',
'begin',
'    for l_attribute in ( select plugin_attribute_id,',
'                                prompt,',
'                                attribute_sequence as attribute_no,',
'                                attribute_type,',
'                                default_value',
'                           from apex_appl_plugins p,',
'                                apex_appl_plugin_attributes a',
'                          where p.application_id  = c_application_id',
'                            and p.name            = substr( p_plugin_name, 8 )',
'                            and p.plugin_type     = p_plugin_type',
'                            and a.plugin_id       = p.plugin_id',
'                            and a.attribute_scope = ''Component''',
'                          order by a.display_sequence )',
'    loop',
'        if not p_values.exists ( l_attribute.attribute_no ) then',
'            continue;',
'        end if;',
'',
'        l_display_value := p_values( l_attribute.attribute_no );',
'',
'        -- No need to show the attribute if it''s the default',
'        if l_display_value = l_attribute.default_value then',
'            continue;',
'        end if;',
'',
'        l_has_attributes := true;',
'        if l_attribute.attribute_type = ''Select List'' then',
'            begin',
'                select display_value',
'                  into l_display_value',
'                  from apex_appl_plugin_attr_values',
'                 where plugin_attribute_id = l_attribute.plugin_attribute_id',
'                   and return_value        = l_display_value;',
'            exception when no_data_found then',
'                l_display_value := l_display_value || ''***'';',
'            end;',
'        end if;',
'        tr_td(l_result, apex_escape.html( l_attribute.prompt ), apex_escape.html( l_display_value ));',
'        --concat( l_result, ''<li>'' || apex_escape.html( l_attribute.prompt ) || '':'' || apex_escape.html( l_display_value ) || ''</li>'' );',
'    end loop;',
'    if not l_has_attributes then',
'        l_result := null;',
'    else',
'        concat( l_result, ''</ul>'' );',
'    end if;',
'    return l_result;',
'end get_plugin_attributes;',
'',
'procedure show_region_descr (',
'    p_region_id               in number,',
'    p_show_template_options   in boolean,',
'    p_show_grid               in boolean,',
'    p_show_sub_regions        in boolean,',
'    p_show_title              in boolean,',
'    p_show_select_region_type in boolean',
')',
'is',
'    l_has_subregions boolean := false;',
'    l_values         apex_application_global.vc_arr2;',
'begin',
'    for l_region in ( select region_name,',
'                             source_type,',
'                             source_type_plugin_name,',
'                             template,',
'                             template_id,',
'                             region_template_options,',
'                             list_template_override,',
'                             list_template_override_id,',
'                             breadcrumb_template,',
'                             breadcrumb_template_id,',
'                             component_template_options,',
'                             report_template,',
'                             report_template_id,',
'                             condition_type',
'                        from apex_application_page_regions',
'                       where region_id = p_region_id )',
'    loop',
'        if l_region.condition_type = ''Never'' then',
'            continue;',
'        end if;',
'',
'        -- get all plug-in attributes',
'        l_values.delete;',
'        for i in ( select attribute_01,',
'                                      attribute_02,',
'                                      attribute_03,',
'                                      attribute_04,',
'                                      attribute_05,',
'                                      attribute_06,',
'                                      attribute_07,',
'                                      attribute_08,',
'                                      attribute_09,',
'                                      attribute_10,',
'                                      attribute_11,',
'                                      attribute_12,',
'                                      attribute_13,',
'                                      attribute_14,',
'                                      attribute_15,',
'                                      attribute_16,',
'                                      attribute_17,',
'                                      attribute_18,',
'                                      attribute_19,',
'                                      attribute_20,',
'                                      attribute_21,',
'                                      attribute_22,',
'                                      attribute_23,',
'                                      attribute_24,',
'                                      attribute_25',
'               from apex_application_page_regions',
'              where region_id = p_region_id )',
'          loop',
'              l_values(1) := i.attribute_01;',
'              l_values(2) := i.attribute_02;',
'              l_values(3) := i.attribute_03;',
'              l_values(4) := i.attribute_04;',
'              l_values(5) := i.attribute_05;',
'              l_values(6) := i.attribute_06;',
'              l_values(7) := i.attribute_07;',
'              l_values(8) := i.attribute_08;',
'              l_values(9) := i.attribute_09;',
'              l_values(10) := i.attribute_10;',
'              l_values(11) := i.attribute_11;',
'              l_values(12) := i.attribute_12;',
'              l_values(13) := i.attribute_13;',
'              l_values(14) := i.attribute_14;',
'              l_values(15) := i.attribute_15;',
'              l_values(16) := i.attribute_16;',
'              l_values(17) := i.attribute_17;',
'              l_values(18) := i.attribute_18;',
'              l_values(19) := i.attribute_19;',
'              l_values(20) := i.attribute_20;',
'              l_values(21) := i.attribute_21;',
'              l_values(22) := i.attribute_22;',
'              l_values(23) := i.attribute_23;',
'              l_values(24) := i.attribute_24;',
'              l_values(25) := i.attribute_25;',
'          end loop;',
'        ',
'        if p_show_title then',
'            sys.htp.p(''<h3>'' || l_region.region_name || ''</h3>'' );',
'        end if;',
'        sys.htp.p( ''<div class="dm-Instructions-section">'' );',
'        if p_show_template_options then',
'            if p_show_select_region_type then',
'                sys.htp.p( ''<div>Select <b>'' || l_region.source_type || ''</b> for Region Type.</div>'' );',
'            end if;',
'            --sys.htp.p( ''<div>Select <b>'' || l_region.template || ''</b> as Region Template.</div>'' );',
'            sys.htp.p(',
'                ''<h3 class="dm-Instructions-title">Region Template Options</h3> '' ||',
'                get_template_option_descr(',
'                    p_template_id      => l_region.template_id,',
'                    p_template_type    => ''REGION'',',
'                    p_template_options => l_region.region_template_options )',
'                );',
'        end if;',
'        if l_region.source_type_plugin_name = ''NATIVE_LIST'' then',
'            --sys.htp.p( ''<div>Use the list template  <b>'' || l_region.list_template_override || ''</b></div>'' );',
'            sys.htp.p(',
'                ''<h3 class="dm-Instructions-title">List Template Options</h3> '' ||',
'                get_template_option_descr(',
'                    p_template_id      => l_region.list_template_override_id,',
'                    p_template_type    => ''LIST'',',
'                    p_template_options => l_region.component_template_options )',
'                );',
'        elsif l_region.source_type_plugin_name = ''NATIVE_BREADCRUMB'' then',
'            --sys.htp.p( ''<div>Breadcrumb Template: '' || l_region.breadcrumb_template || ''</div>'' );',
'            sys.htp.p(',
'                ''<h3 class="dm-Instructions-title">Breadcrumb Template Options</h3> '' ||',
'                get_template_option_descr(',
'                    p_template_id      => l_region.breadcrumb_template_id,',
'                    p_template_type    => ''BREADCRUMB'',',
'                    p_template_options => l_region.component_template_options )',
'                    );',
'        elsif l_region.source_type_plugin_name = ''NATIVE_SQL_REPORT'' then',
'           -- sys.htp.p( ''<div>Report: '' || l_region.report_template || ''</div>'' );',
'            sys.htp.p(',
'                ''<h3 class="dm-Instructions-title">Report Template Options</h3> '' ||',
'                get_template_option_descr(',
'                    p_template_id      => l_region.report_template_id,',
'                    p_template_type    => ''REPORT'',',
'                    p_template_options => l_region.component_template_options )',
'                    );',
'        elsif l_region.source_type_plugin_name = ''NATIVE_IR'' then',
'            --sys.htp.p( ''<div>Interactive Report: '' || l_region.report_template || ''</div>'' );',
'            null;',
'        elsif l_region.source_type_plugin_name = ''NATIVE_CSS_CALENDAR'' then',
'            sys.htp.p(',
'                ''<div>'' ||',
'                get_plugin_attributes(',
'                    p_plugin_name => l_region.source_type_plugin_name,',
'                    p_plugin_type => ''Region Type'',',
'                    p_values      => l_values ) ||',
'                ''</div>'' );',
'        end if;',
'        sys.htp.p( ''</div>'' );',
'        if p_show_grid then',
'            sys.htp.p(',
'                ''<div class="dm-Instructions-section"><h3 class="dm-Instructions-title">Grid Options: '' ||',
'                get_grid_options(',
'                    p_table_name => ''apex_application_page_regions'',',
'                    p_id_column  => ''region_id'',',
'                    p_id_value   => p_region_id ) ||',
'                ''</h3></div>'');',
'        end if;',
'        -- sys.htp.p( ''<div class="dm-Instructions-section">'' );',
'        -- sys.htp.p(get_region_items_descr( p_region_id, p_show_grid ));',
'        -- sys.htp.p( ''</div>'' );',
'        -- sys.htp.p( ''<div class="dm-Instructions-section">'' );',
'        -- sys.htp.p(get_region_buttons_descr( p_region_id ));',
'        -- sys.htp.p( ''</div>'' );',
'        if p_show_sub_regions then',
'            for l_sub_region in ( select region_id',
'                                    from apex_application_page_regions',
'                                   where parent_region_id = p_region_id',
'                                   order by display_sequence )',
'            loop',
'                  if not l_has_subregions then',
'                      sys.htp.p( ''<div class="dm-Instructions-section dm-Instructions-section--sub">'' );',
'                      l_has_subregions := true;',
'                  end if;',
'                  show_region_descr(',
'                      p_region_id               => l_sub_region.region_id,',
'                      p_show_template_options   => p_show_template_options,',
'                      p_show_grid               => p_show_grid,',
'                      p_show_sub_regions        => p_show_sub_regions,',
'                      p_show_title              => p_show_title,',
'                      p_show_select_region_type => p_show_select_region_type );',
'            end loop;',
'            if l_has_subregions = true then',
'                sys.htp.p( ''</div>'' );',
'            end if;',
'        end if;',
'    end loop;',
'',
'end show_region_descr;',
'',
'',
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'begin',
'    for l_region in ( select r2.region_id',
'                        from apex_application_page_regions r1,',
'                             apex_application_page_regions r2',
'                       where r1.region_id        = p_region.id',
'                         and r2.parent_region_id = r1.parent_region_id',
'                         and r2.region_id       <> r1.region_id )',
'    loop',
'        show_region_descr(',
'            p_region_id               => l_region.region_id,',
'            p_show_template_options   => ( p_region.attribute_01 = ''Y'' ),',
'            p_show_grid               => ( p_region.attribute_02 = ''Y'' ),',
'            p_show_sub_regions        => ( p_region.attribute_03 = ''Y'' ),',
'            p_show_title              => ( p_region.attribute_04 = ''Y'' ),',
'            p_show_select_region_type => ( p_region.attribute_05 = ''Y'' )',
'            );',
'    end loop;',
'',
'    return null;',
'end render;'))
,p_api_version=>1
,p_render_function=>'render'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1687619288674340180)
,p_plugin_id=>wwv_flow_api.id(1645378874274309670)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Show Region Template Options'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1688273989223831255)
,p_plugin_id=>wwv_flow_api.id(1645378874274309670)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Show Grid Values'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1689429149513534602)
,p_plugin_id=>wwv_flow_api.id(1645378874274309670)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Sub Regions'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1689442314595663907)
,p_plugin_id=>wwv_flow_api.id(1645378874274309670)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Show Region Title'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(1712328418313712311)
,p_plugin_id=>wwv_flow_api.id(1645378874274309670)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Show Select Region Type'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_api.id(1687619288674340180)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'Y'
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(821272323468330288)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_seq=>10
,p_use_auto_detect=>false
,p_is_default=>true
,p_theme_id=>42
,p_home_url=>'f?p=&APP_ID.:100:&SESSION.'
,p_login_url=>'f?p=&APP_ID.:LOGIN:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>0
,p_navigation_list_id=>wwv_flow_api.id(404960847609814309)
,p_navigation_list_position=>'SIDE'
,p_navigation_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_nav_list_template_options=>'#DEFAULT#:js-navCollapsed--hidden:t-TreeNav--styleA'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#pkgapp_ui/css/5.0#MIN#.css',
'#THEME_IMAGES#css/Demo#MIN#.css',
'&CODEMIRROR_PATH./codemirror-custom.min.css'))
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#THEME_IMAGES#demo/demo.js',
'&CODEMIRROR_PATH./codemirror-custom.min.js'))
,p_nav_bar_type=>'LIST'
,p_nav_bar_list_id=>wwv_flow_api.id(1398847823861474656)
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>0
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Page Zero'
,p_step_title=>'Page Zero'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190131100706'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3082211826105906231)
,p_plug_name=>'Woops.'
,p_icon_css_classes=>'fa-emoji-grin-sweat'
,p_region_template_options=>'#DEFAULT#:t-Alert--wizard:t-Alert--customIcons:t-Alert--info'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'You''ve stumbled on a page that doesn''t exist.'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'CURRENT_PAGE_IN_CONDITION'
,p_plug_display_when_condition=>'400,403,404,406,5001,5002,5003,5004,5005,6306,700,701'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00100
begin
wwv_flow_api.create_page(
 p_id=>100
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Home '
,p_step_title=>'Oracle APEX Universal Theme'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_inline_css=>'.t-Header,.t-Footer {display: none;}'
,p_step_template=>wwv_flow_api.id(1530046751615002521)
,p_page_css_classes=>'dm-Home dm-Page dm-Page--center ut-bg'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190123074306'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2015299727112052604)
,p_plug_name=>'Hero Region'
,p_region_css_classes=>'dm-Hero'
,p_region_template_options=>'#DEFAULT#:margin-bottom-lg'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Logo app-sample-universal-theme"></span>',
'<h1><span>Oracle Application Express </span>Universal Theme</h1>',
'<p class="margin-top-lg">Universal Theme is a responsive, versatile, and customizable user interface for your Application Express apps. It is designed uniquely for Oracle APEX to make it easy for developers to build beautiful, modern applications, at'
||' any scale, for any purpose, that work on any device. </p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2015299814283052605)
,p_plug_name=>'Navigation'
,p_region_template_options=>'#DEFAULT#:margin-bottom-lg'
,p_component_template_options=>'#DEFAULT#:t-Cards--featured force-fa-lg:t-Cards--displayIcons:t-Cards--3cols:t-Cards--hideBody:t-Cards--animColorFill'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(404960847609814309)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00300
begin
wwv_flow_api.create_page(
 p_id=>300
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Grid Layout'
,p_step_title=>'Grid Layout - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.u-Report small {display: block;}',
'.text-nowrap {white-space: nowrap;}'))
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075409'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364817488434107779)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1391858395538720788)
,p_plug_name=>'Column Modifier Classes'
,p_region_css_classes=>'margin-top-xl'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can fine tune the responsive behavior of the components on your page by modifying the <strong>Column CSS Classes</strong> property of your regions.</p>',
'',
'<table class="u-Report u-Report--stretch">',
'    <thead>',
'        <tr>',
'            <th></th>',
'            <th><small>&le;640px</small></th>',
'            <th><small>&gt;640 and &lt;768px</small></th>',
'            <th><small>&ge;768px and &lt;992px</small></th>',
'            <th><small>&ge;992px and &lt;1200px</small></th>',
'            <th><small>&ge;1200px</small></th>',
'        </tr>',
'    </thead>',
'    <tbody>',
'        <tr>',
'            <th class="text-nowrap" scope="row">Class prefix</th>',
'            <td><code>.col-xxs-</code></td>',
'            <td><code>.col-xs-</code></td>',
'            <td><code>.col-sm-</code></td>',
'            <td><code>.col-md-</code></td>',
'            <td><code>.col-lg-</code></td>',
'        </tr>',
'    </tbody>',
'</table>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1391858551507720790)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Universal Theme uses a 12-column flexible grid for arranging page components and is based on the <a href="http://getbootstrap.com/" target="_blank">Bootstrap</a> grid system.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364816815966107772)
,p_plug_name=>'View Layout Columns'
,p_parent_plug_id=>wwv_flow_api.id(1391858551507720790)
,p_region_css_classes=>'margin-bottom-xl'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--defaultIcons:t-Alert--info:t-Alert--removeHeading'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Click the <b>Toggle Layout Columns</b> button to overlay the grid behind this page.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1515420815675817004)
,p_plug_name=>'Grid Layout Container'
,p_parent_plug_id=>wwv_flow_api.id(1391858551507720790)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364813833721107743)
,p_plug_name=>'Region 2'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814009089107744)
,p_plug_name=>'Region 4'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814047057107745)
,p_plug_name=>'Region 6'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814123257107746)
,p_plug_name=>'Region 8'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>140
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814300015107747)
,p_plug_name=>'Region 10'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>160
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814415097107748)
,p_plug_name=>'Region 1'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814433008107749)
,p_plug_name=>'Region 3'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814543844107750)
,p_plug_name=>'Region 5'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>110
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814659998107751)
,p_plug_name=>'Region 7'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814773692107752)
,p_plug_name=>'Region 9'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>150
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814892942107753)
,p_plug_name=>'Region 11'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>170
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364814953012107754)
,p_plug_name=>'Region 12'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>180
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815095339107755)
,p_plug_name=>'Region 1'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>190
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815140361107756)
,p_plug_name=>'Region 2'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>200
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815221052107757)
,p_plug_name=>'Region 3'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815375714107758)
,p_plug_name=>'Region 4'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>220
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815459560107759)
,p_plug_name=>'Region 5'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>230
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815555965107760)
,p_plug_name=>'Region 6'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>240
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815617091107761)
,p_plug_name=>'Region 1'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>250
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815768618107762)
,p_plug_name=>'Region 2'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>260
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815836674107763)
,p_plug_name=>'Region 3'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>270
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364815983433107764)
,p_plug_name=>'Region 4'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>280
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364816290558107767)
,p_plug_name=>'Region 1'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>290
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364816375522107768)
,p_plug_name=>'Region 2'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>300
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364816490757107769)
,p_plug_name=>'Region 3'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>310
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364816587180107770)
,p_plug_name=>'Region 1'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>320
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1364816657802107771)
,p_plug_name=>'Region 2'
,p_parent_plug_id=>wwv_flow_api.id(1515420815675817004)
,p_region_css_classes=>'dm-Grid-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>330
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(713382252223885774)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1364816815966107772)
,p_button_name=>'TOGGLE_GRID_LAYOUT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Toggle Layout Columns'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(713385993518885780)
,p_name=>'Toggle Grid Layout'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(713382252223885774)
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'apex.jQuery(''body'').hasClass(''grid-debug-on'')'
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(713386427737885781)
,p_event_id=>wwv_flow_api.id(713385993518885780)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REMOVE_CLASS'
,p_affected_elements_type=>'JQUERY_SELECTOR'
,p_affected_elements=>'body'
,p_attribute_01=>'grid-debug-on'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(713386919137885782)
,p_event_id=>wwv_flow_api.id(713385993518885780)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ADD_CLASS'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(713382252223885774)
,p_attribute_01=>'is-active'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(713387477809885782)
,p_event_id=>wwv_flow_api.id(713385993518885780)
,p_event_result=>'FALSE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ADD_CLASS'
,p_affected_elements_type=>'JQUERY_SELECTOR'
,p_affected_elements=>'body'
,p_attribute_01=>'grid-debug-on'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(713387929121885783)
,p_event_id=>wwv_flow_api.id(713385993518885780)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REMOVE_CLASS'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_api.id(713382252223885774)
,p_attribute_01=>'is-active'
);
end;
/
prompt --application/pages/page_00400
begin
wwv_flow_api.create_page(
 p_id=>400
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Design'
,p_step_title=>'Design - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190124090610'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3000967705093695623)
,p_plug_name=>'Design'
,p_icon_css_classes=>'fa-pencil'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1224989219520090364)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00401
begin
wwv_flow_api.create_page(
 p_id=>401
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Design Overview'
,p_step_title=>'Design Overview - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190124090610'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(766161687376482427)
,p_plug_name=>'Design'
,p_icon_css_classes=>'fa-lg fa-design u-color-3'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1224989219520090364)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(873485800997520031)
,p_plug_name=>'Key Principles'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>There are three key aspects of Universal Theme that make it ideally suited for Application Express development: Responsive Design, Versatile UI Components, and Easy Customization.</p>',
'',
'<h3 class="margin-top-lg"><span class="fa fa-number-1 fa-lg u-color-3-txt"></span> Responsive Design</h3>',
'<p>Universal Theme has been designed from the very beginning to work just as well on small screen devices (phones, tablet) as it does on larger screen devices (laptops, desktops).</p>',
'<p>This means that the UI components in Universal Theme work across varying screen resolutions while maintaining the same or similar functionality.  In addition, Universal Theme takes full advantage of ultra high screen resolutions by utilizing vecto'
||'r graphics where possible, and relying upon CSS3 features for UI styling.</p>',
'',
'<h3 class="margin-top-lg"><span class="fa fa-number-2 fa-lg u-color-3-txt"></span> Versatile UI</h3>',
'<p>Universal Theme provides the components / building blocks necessary to build practically any type of business application UI.</p>',
'<p>From Cards, Forms, Menus, Tabs, Reports, and so much more, these components have been developed with the best practices following common and popular UI patterns. You can browse all of the components provided with Universal Theme by navigating to t'
||'he Components section of this application.</p>',
'',
'<h3 class="margin-top-lg"><span class="fa fa-number-3 fa-lg u-color-3-txt"></span> Easy Customization</h3>',
'<p>Even for the most basic of requirements, theming and customization is a key and necessary ingredient to the success of your application.</p>',
'<p>With Universal Theme, you can effortlessly customize and fully control the look and feel of your applications without becoming an expert in UI design, HTML, CSS, or JavaScript. Using Theme Roller and Template Options, you can easily customize your'
||' application to fit your company''s brand, and customize the look and feel of various components using Template Options. All of this is possible during runtime, so what you see is what you really get.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1752384660634560279)
,p_plug_name=>'What is Universal Theme?'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Universal Theme is a user interface for Application Express that enables developers to build modern web applications without requiring extensive knowledge of HTML, CSS, or JavaScript. With some working knowledge of Application Express, you can use'
||' Universal Theme to easily build a responsive application that is highly accessible, easily customizable, and easy to maintain.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00402
begin
wwv_flow_api.create_page(
 p_id=>402
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Colors'
,p_step_title=>'Colors - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075408'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(844155314244515514)
,p_plug_name=>'Stateful Colors'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Stateful colors are used for convey additional meaning for a given UI component. For example, you may choose to color a warning alert with a yellow tint.</p>',
'',
'<p>There are 6 stateful colors: normal, hot, informational, danger, warning, and success. You may customize these colors by modifying the Status Colors within Theme Roller.</p>',
'',
'<div class="color-blocks color-blocks--large">',
'  <div class="color-block u-normal">Normal State</div>',
'  <div class="color-block u-hot">Hot State</div>',
'  <div class="color-block u-info">Info State</div>',
'</div>',
'<div class="color-blocks color-blocks--large">',
'  <div class="color-block u-danger">Danger State</div>',
'  <div class="color-block u-warning">Warning</div>',
'  <div class="color-block u-success">Success</div>',
'</div>',
'',
'<p><strong>Note:</strong> Color alone should not be used to convey information as it may not always be accessible.</strong></p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1644963483147523074)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3064597545922501763)
,p_plug_name=>'Introduction'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Universal Theme uses a consistent set of colors across the included components. These colors can be grouped into two palettes: <strong>General Colors</strong> and <strong>Stateful Colors</strong>.</p>',
'<p>You can learn how to use these colors in your own custom UI components by viewing the <a href="f?p=&APP_ID.:6302:&APP_SESSION.">CSS modifier classes</a> in the <a href="f?p=&APP_ID.:6000:&APP_SESSION.">Reference</a> section.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3064597770745502788)
,p_plug_name=>'General Colors'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>General colors are used for adding color accents to several application components such as Charts, Cards, and and more.</p>',
'',
'<p>There are 15 primary colors which are modified to become slightly lighter or darker to create a total of 45 color options. You can customize these colors by modifying the Color Palette within Theme Roller.</p>',
'',
'<p><strong>Primary Colors</strong></p>',
'',
'<div class="color-blocks">',
'  <div class="color-block u-color-1">1</div>',
'  <div class="color-block u-color-2">2</div>',
'  <div class="color-block u-color-3">3</div>',
'  <div class="color-block u-color-4">4</div>',
'  <div class="color-block u-color-5">5</div>',
'  <div class="color-block u-color-6">6</div>',
'  <div class="color-block u-color-7">7</div>',
'  <div class="color-block u-color-8">8</div>',
'  <div class="color-block u-color-9">9</div>',
'  <div class="color-block u-color-10">10</div>',
'  <div class="color-block u-color-11">11</div>',
'  <div class="color-block u-color-12">12</div>',
'  <div class="color-block u-color-13">13</div>',
'  <div class="color-block u-color-14">14</div>',
'  <div class="color-block u-color-15">15</div>',
'</div>',
'',
'<p><strong>Primary Colors - Lighter</strong></p>',
'',
'<div class="color-blocks">',
'  <div class="color-block u-color-16">16</div>',
'  <div class="color-block u-color-17">17</div>',
'  <div class="color-block u-color-18">18</div>',
'  <div class="color-block u-color-19">19</div>',
'  <div class="color-block u-color-20">20</div>',
'  <div class="color-block u-color-21">21</div>',
'  <div class="color-block u-color-22">22</div>',
'  <div class="color-block u-color-23">23</div>',
'  <div class="color-block u-color-24">24</div>',
'  <div class="color-block u-color-25">25</div>',
'  <div class="color-block u-color-26">26</div>',
'  <div class="color-block u-color-27">27</div>',
'  <div class="color-block u-color-28">28</div>',
'  <div class="color-block u-color-29">29</div>',
'  <div class="color-block u-color-30">30</div>',
'</div>',
'',
'<p><strong>Primary Colors - Darker</strong></p>',
'<div class="color-blocks">',
'  <div class="color-block u-color-31">31</div>',
'  <div class="color-block u-color-32">32</div>',
'  <div class="color-block u-color-33">33</div>',
'  <div class="color-block u-color-34">34</div>',
'  <div class="color-block u-color-35">35</div>',
'  <div class="color-block u-color-36">36</div>',
'  <div class="color-block u-color-37">37</div>',
'  <div class="color-block u-color-38">38</div>',
'  <div class="color-block u-color-39">39</div>',
'  <div class="color-block u-color-40">40</div>',
'  <div class="color-block u-color-41">41</div>',
'  <div class="color-block u-color-42">42</div>',
'  <div class="color-block u-color-43">43</div>',
'  <div class="color-block u-color-44">44</div>',
'  <div class="color-block u-color-45">45</div>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00403
begin
wwv_flow_api.create_page(
 p_id=>403
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Customization'
,p_step_title=>'Customization - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081317'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2523767231244575200)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00404
begin
wwv_flow_api.create_page(
 p_id=>404
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Data Entry'
,p_step_title=>'Data Entry - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081317'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3402572660921631388)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00406
begin
wwv_flow_api.create_page(
 p_id=>406
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Notifications and Messaging'
,p_step_title=>'Notifications and Messaging - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081317'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4281379858328693354)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00407
begin
wwv_flow_api.create_page(
 p_id=>407
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Navigation'
,p_step_title=>'Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075408'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1515421145173817007)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Navigation is an important part of your application and can determine the how your users navigate within your application.  There are two navigation concepts that are key for Universal Theme: Navigation Menus and Navigation Bar.'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1515421235412817008)
,p_plug_name=>'Navigation Menus'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The primary navigation structure for your application is defined as a <b>Navigation Menu</b> and is based on the <b>List</b> component in APEX. Navigation Menus are hierarchical and can be any level deep.  This navigation control and can be both d'
||'ynamic (based on a query), or static (based on static list entries).  In addition, you can choose to position your navigation to the top or side of your screen.</p>',
'',
'<p>To change your application''s Navigation Menu settings, navigate to Shared Components &rarr; User Interface Defaults and then click on the edit icon next to the Desktop User Interface. From here, you can navigate to the Navigation Menu region and c'
||'hange the options listed.</p>',
'',
'<h3>Top Position</h3>',
'<p>Navigation placed in the top position can rendered as a menu bar using the <b>Top Navigation Menu</b> template, or as tabs using the <b>Top Navigation Tabs</b> template.</p>',
'',
'<h3>Side Position - Tree Based Navigation</h3>',
'<p>Navigation placed in the side position is rendered as a tree widget and can be collapsed to simply icons, or completely off screen depending on the screen size.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1515421395231817009)
,p_plug_name=>'Navigation Bar'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The Navigation Bar is positioned near the end of the application''s header, and typically contains links for user authentication, help, feedback, and other global items.</p>',
'',
'<p>Navigation Bars are also based on the <b>List</b> component in APEX. However, as of APEX 5.1, you may only have a two-level deep menu.</p>',
'',
'<p>To change your application''s Navigation Bar settings, navigate to Shared Components &rarr; User Interface Defaults and then click on the edit icon next to the Desktop User Interface. From here, you can navigate to the Navigation Bar region and cha'
||'nge the options listed.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5160189184423760318)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00420
begin
wwv_flow_api.create_page(
 p_id=>420
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Mobile Patterns'
,p_step_title=>'Mobile Patterns'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190123074904'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606904582240638640)
,p_plug_name=>'Mobile Patterns'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2:t-ContentBlock--lightBG'
,p_component_template_options=>'t-MediaList--showIcons:u-colors'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(608043492397034627)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(618966256865274517)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2307050152134014008)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3726684214908992697)
,p_plug_name=>'Introduction'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Here are a number of common UI patterns that may be useful if you are building apps that will primarily be used on small screen devices.  These mobile design patterns are especially optimized for maximum usability when using a hand held device suc'
||'h as a smart phone or small tablet, and may incorporate other features such as touch gestures and more.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00421
begin
wwv_flow_api.create_page(
 p_id=>421
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Navigation'
,p_step_title=>'Navigation'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190725081241'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606904609891638641)
,p_plug_name=>'Side Menu'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>This common navigation pattern is typically referred to as a <b>hamburger menu</b>, drawer menu, or tree navigation and is well suited for applications that have many navigation items, or require nested navigation. On small screens, you simply tap'
||' on the hamburger icon near the top left (or top right when using right-to-left languages) corner of your screen and the menu will slide out. You can make a selection and immediately navigate to the selected item.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606904726197638642)
,p_plug_name=>'Instructions'
,p_parent_plug_id=>wwv_flow_api.id(606904609891638641)
,p_region_css_classes=>'dm-Hero-steps'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><strong>Steps</strong></p>',
'',
'<ul>',
'  <li>Go to Shared Components &rarr; User Interface Attributes &rarr; Edit Desktop</li>',
'  <li>Scroll to Navigation Menu and set <b>Position</b> to Side</li>',
'  <li>Set the <b>List Template</b> to Side Navigation Menu</li>',
'</ul>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606905024109638645)
,p_plug_name=>'Template Options'
,p_parent_plug_id=>wwv_flow_api.id(606904609891638641)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3:margin-top-md'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.DISP_TEMPLATE_OPTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'LIST'
,p_attribute_04=>'Side Navigation Menu'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1928343924705643460)
,p_plug_name=>'Side Menu Sample'
,p_parent_plug_id=>wwv_flow_api.id(606904609891638641)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page side-nav-one-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1101:&APP_SESSION.'',''Page with Side Menu'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1928343394258643448)
,p_plug_name=>'Tab Menu'
,p_region_name=>'standard'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Tabs are another very common navigation pattern for small screen devices.  These tabs will automatically position themselves near the top or bottom of the screen depending on the device screensize.  On small screens, the tabs menu will be displaye'
||'d at the bottom of the screen allowing for comfortable use with one hand. On larger screens, the tabs will be near the top of the screen.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606904861448638643)
,p_plug_name=>'Instructions'
,p_parent_plug_id=>wwv_flow_api.id(1928343394258643448)
,p_region_css_classes=>'dm-Hero-steps'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>50
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><strong>Steps</strong></p>',
'',
'<ul>',
'  <li>Go to Shared Components &rarr; User Interface Attributes &rarr; Edit Desktop</li>',
'  <li>Scroll to Navigation Menu and set <b>Position</b> to Top</li>',
'  <li>Set the <b>List Template</b> to Top Navigation Tabs</li>',
'</ul>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606904972531638644)
,p_plug_name=>'Template Options'
,p_parent_plug_id=>wwv_flow_api.id(1928343394258643448)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3:margin-top-md'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.DISP_TEMPLATE_OPTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'LIST'
,p_attribute_04=>'Top Navigation Tabs'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1928344381816643460)
,p_plug_name=>'Tab Menu Sample'
,p_parent_plug_id=>wwv_flow_api.id(1928343394258643448)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page top-nav-one-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1115:&APP_SESSION.'',''Page with Tabs Menu'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2980695377329534171)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4400329440104512860)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Navigation within your application is critical to its success. When building applications for mobile, it is important to keep in mind the complexity of the application you are developing and which navigation pattern makes most sense for your speci'
||'fic use case. Here are two of the mobile-friendly navigation patterns available in Universal Theme and when to pick one over the other.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00422
begin
wwv_flow_api.create_page(
 p_id=>422
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Headers and Footers'
,p_step_title=>'Headers and Footers'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075409'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606905233065638647)
,p_plug_name=>'Mobile Page Footer'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can configure a <b>Buttons Container</b> region so that it sticks to the bottom of the page for small screen devices.  This could be useful for when you want to have one set of buttons for a given page and position them to the bottom when a sm'
||'all screen device is used.</p>',
'',
'<p><b>Steps</b></p>',
'<ol>',
'  <li>Create a Region with the region template set to <b>Buttons Container</b></li>',
'  <li>Modify the Template Options for this region and check the <b>Stick to Bottom on Mobile</b> option</li>',
'</ol>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(756694554592321910)
,p_plug_name=>'Page Footer Examples'
,p_parent_plug_id=>wwv_flow_api.id(606905233065638647)
,p_icon_css_classes=>'fa-mouse-pointer'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info:t-Alert--removeHeading:margin-top-md'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<b>Page Footer Examples</b>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1354777993915433145)
,p_plug_name=>'Mobile Page Header'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The <b>Breadcrumb Bar</b> region position on any given Page Template within Universal Theme is designed to persist on large screens as the user scrolls.  This is the position where the Breadcrumbs component, or Hero region, is typically placed.</p'
||'>',
'',
'<p>By default, the contents of this region are not stuck to the top of the screen for small screen devices as it can take away valuable screen realestate on small screens. However, if you wish to persist this header to always be visible on a given pa'
||'ge, you can add the following JavaScript API call to make this happen.</p>',
'',
'<p><b>Steps</b></p>',
'<ol>',
'  <li>Select the Page in Page Designer</li>',
'  <li>Modify the Template Options for the page and check the <b>Sticky Header on Mobile</b> option</li>',
'</ol>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(756694239498321907)
,p_plug_name=>'Page Header Examples'
,p_parent_plug_id=>wwv_flow_api.id(1354777993915433145)
,p_icon_css_classes=>'fa-mouse-pointer'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info:t-Alert--removeHeading:margin-top-md'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<b>Page Header Examples</b>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3728568761353328675)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5148202824128307364)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Many mobile apps share a common pattern for placement of buttons and other content. This content is typically positioned on the header or footer of the page which is easily accessible and on screen for quick actions. This page explains how you can'
||' apply this pattern for your own apps.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756694311439321908)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(756694239498321907)
,p_button_name=>'HEADER_1'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Header Example 1'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1116:&APP_SESSION.:sample1'',''Sticky Page Header'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756694842125321913)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(756694554592321910)
,p_button_name=>'FOOTER_1'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Footer Example 1'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1117:&APP_SESSION.:sample1'',''Sticky Page Header'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756694455465321909)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(756694239498321907)
,p_button_name=>'HEADER_2'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Header Example 2'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1116:&APP_SESSION.:sample2'',''Sticky Page Header'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756694985660321914)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(756694554592321910)
,p_button_name=>'FOOTER_2'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Footer Example 2'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1117:&APP_SESSION.:sample2'',''Sticky Page Header'');'
,p_icon_css_classes=>'fa-external-link-square'
);
end;
/
prompt --application/pages/page_00423
begin
wwv_flow_api.create_page(
 p_id=>423
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Data Entry'
,p_step_title=>'Data Entry'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075409'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(756696138389321926)
,p_plug_name=>'Good Design Practices'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Here are some good design practices to follow when designing pages and apps for small screen devices.</p>',
'',
'<ul class="dm-UL">',
'<li><strong>Limit the number of fields to fill out</strong><br />',
'      Fewer fields to complete means a higher successrate of users completing the form. Whenever possible, use smart defaults, and employ HTML5 apis such as <a href="https://developer.mozilla.org/en-US/docs/Web/API/Geolocation/Using_geolocation" targ'
||'et="_blank">geolocation</a> to capture location data rather than asking the user to enter it manually.</li>',
'<li><strong>Use radio buttons in place of select lists when possible</strong><br />',
'      You can improve the usability of your form by replacing select lists which have a few options to a radio button.  This will result in fewer taps to see the available options as they will already be displayed on screen.  You can go even further '
||'by setting the <a href="f?p=&APP_ID.:1204">Display as Pill Button</a> template option to provide a more user friendly control.</li>',
'<li><strong>Position submit buttons near the end of the form</strong><br />',
'      This simple trick will make it far more easier to reach and tap on the submit button.</li>',
'<li><strong>Avoid using heavy controls and widgets</strong><br />',
'      While it may be tempting to use Interactive Grid on a phone, there may be alternatives that provide better usability and mobile performance. When in doubt, try to avoid large controls like Interactive Grids on mobile screens and instead try to '
||'optimize for user experience.</li>',
'</ul>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2111529969112116668)
,p_plug_name=>'Form Design'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>When designing your data entry screens for mobile, consider using the <b>Floating Labels</b> field templates for your page items.  These templates are especially optimized for mobile use cases as they provide a much larger tap area to gain focus a'
||'nd provides larger text for improved readibility.  The field label will automatically shrink as a value is populated, but still remaining on screen so context is not lost.</p>',
'',
'<p>Be sure to visit the <a href="f?p=&APP_ID.:1603">Components &rarr; Forms &rarr; Floating Labels</a> page for additional examples.</p>',
'',
'<p><b>Steps</b></p>',
'<ol>',
'  <li>Select the page item in Page Designer</li>',
'  <li>Modify the Template property under Appearance</li>',
'  <li>Select either the <b>Optional - Floating</b> or <b>Required - Floating</b> template from the select list.</li>',
'</ol>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1513446214695005430)
,p_plug_name=>'Mobile Form Example'
,p_parent_plug_id=>wwv_flow_api.id(2111529969112116668)
,p_icon_css_classes=>'fa-mouse-pointer'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info:t-Alert--removeHeading:margin-top-md'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<b>Mobile Form Examples</b>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4485320736550012198)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5904954799324990887)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Data entry is a key component of many APEX apps and should be very carefully considered when designing screens for mobile use cases.  This page outlines a few patterns that Universal Theme provides as well as some general guidelines when designing'
||' forms and data entry pages for small screens.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756752904920683542)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1513446214695005430)
,p_button_name=>'FORM_1'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Form Sample 1'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1604:&APP_SESSION.:sample1'',''Sticky Page Header'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756753360272683543)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1513446214695005430)
,p_button_name=>'FORM_2'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Form Sample 2'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1604:&APP_SESSION.:sample2'',''Sticky Page Header'');'
,p_icon_css_classes=>'fa-external-link-square'
);
end;
/
prompt --application/pages/page_00424
begin
wwv_flow_api.create_page(
 p_id=>424
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Touch Gestures'
,p_step_title=>'Touch Gestures'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075409'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790286805160406320)
,p_plug_name=>'Press'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790286978766406321)
,p_plug_name=>'Touch Region'
,p_region_name=>'press_region'
,p_parent_plug_id=>wwv_flow_api.id(790286805160406320)
,p_region_css_classes=>'touch-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="anim-icon">',
'<span class="fa fa-hand-pointer-o fa-lg js-event-icon" aria-hidden="true"></span> <span class="js-event-text">Press me!</span>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790287072207406322)
,p_plug_name=>'Details'
,p_parent_plug_id=>wwv_flow_api.id(790286805160406320)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><b>Notable <code>press</code> event data</b></p>',
'<ul>',
'  <li><code>this.data.pointerType</code> type of pointer (mouse or touch)</li>',
'</ul>',
'<p>Note: <code>press</code> events can also be triggered by clicking and holding</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790287185097406323)
,p_plug_name=>'Swipe'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790287205991406324)
,p_plug_name=>'Touch Region'
,p_region_name=>'swipe_region'
,p_parent_plug_id=>wwv_flow_api.id(790287185097406323)
,p_region_css_classes=>'touch-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="anim-icon">',
'<span class="fa fa-hand-pointer-o fa-lg js-event-icon" aria-hidden="true"></span> <span class="js-event-text">Swipe me!</span>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790287322919406325)
,p_plug_name=>'Details'
,p_parent_plug_id=>wwv_flow_api.id(790287185097406323)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><b>Notable <code>swipe</code> event data</b></p>',
'<ul>',
'  <li><code>this.data.offsetDirection</code> swipe direction (2 left, 4 right)</li>',
'  <li><code>this.data.distance</code> distance of the swipe gesture</li>',
'  <li><code>this.data.pointerType</code> type of pointer (mouse or touch)</li>',
'</ul>',
'<p>Note: <code>swipe</code> events can also be triggered by clicking and quickly moving the cursor to the right or left</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790287498277406326)
,p_plug_name=>'Pan'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790287523852406327)
,p_plug_name=>'Touch Region'
,p_region_name=>'pan_region'
,p_parent_plug_id=>wwv_flow_api.id(790287498277406326)
,p_region_css_classes=>'touch-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="anim-icon">',
'<span class="fa fa-hand-pointer-o fa-lg js-event-icon" aria-hidden="true"></span> <span class="js-event-text">Pan me!</span>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790287628781406328)
,p_plug_name=>'Details'
,p_parent_plug_id=>wwv_flow_api.id(790287498277406326)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><b>Notable <code>pan</code> event data</b></p>',
'<ul>',
'  <li><code>this.data.offsetDirection</code> swipe direction (2 left, 4 right, 8 up, 16 down)</li>',
'  <li><code>this.data.isFinal</code> returns <code>true</code> if it is the last input</li>',
'  <li><code>this.data.pointerType</code> type of pointer (mouse or touch)</li>',
'</ul>',
'<p>Note: <code>pan</code> events can also be triggered by clicking and dragging</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1513525009799595890)
,p_plug_name=>'Tap'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(768342462273393721)
,p_plug_name=>'Touch Region'
,p_region_name=>'tap_region'
,p_parent_plug_id=>wwv_flow_api.id(1513525009799595890)
,p_region_css_classes=>'touch-region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="anim-icon">',
'<span class="fa fa-hand-pointer-o fa-lg js-event-icon" aria-hidden="true"></span> <span class="js-event-text">Tap me!</span>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(768342534459393722)
,p_plug_name=>'Details'
,p_parent_plug_id=>wwv_flow_api.id(1513525009799595890)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p><b>Notable <code>tap</code> event data</b></p>',
'<ul>',
'  <li><code>this.data.tapCount</code> number of times the screen was tapped</li>',
'  <li><code>this.data.pointerType</code> type of pointer (mouse or touch)</li>',
'</ul>',
'<p>Note: <code>tap</code> events can also be triggered by clicking</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2868358840522390632)
,p_plug_name=>'Available Gestures'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>APEX 18.1 provides declarative support for the following touch gestures via Dynamic Actions:</p>',
'',
'<ul>',
'  <li>tap and double tap</li>',
'  <li>press</li>',
'  <li>swipe</li>',
'  <li>pan</li>',
'</ul>',
'',
'<p>Note: While APEX wraps these touch events to make them accessible via Dynamic Actions, the underlying touch support is powered using the <a href="http://hammerjs.github.io/" target="_blank">hammer.js</a> library.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5242149607960286162)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6661783670735264851)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Adding touch support to your APEX apps help provide an improved and more natural mobile experience. This is especially important if your apps are more likely to be used on touch devices, such as smartphones or tablest. This page walks you through '
||'how you can use declarative touch events, introduced in APEX 18.1, to build touch friendly UIs.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(756697923515321944)
,p_name=>'Tap'
,p_event_sequence=>10
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(768342462273393721)
,p_bind_type=>'bind'
,p_bind_event_type=>'apextap'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(756698098440321945)
,p_event_id=>wwv_flow_api.id(756697923515321944)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var tapCount = this.data.tapCount;',
'var touchRegion$ = $(this.triggeringElement);',
'touchRegion$.find(".js-event-text").text("Tapped " + tapCount + " times!");',
'',
'var animationEvent = ''webkitAnimationEnd oanimationend msAnimationEnd animationend'';',
'touchRegion$.addClass(''is-active'');',
'touchRegion$.one(animationEvent, function(event) {',
'    touchRegion$.removeClass(''is-active'');',
'});'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(756698344331321948)
,p_name=>'Press'
,p_event_sequence=>30
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(790286978766406321)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexpress'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(756698461288321949)
,p_event_id=>wwv_flow_api.id(756698344331321948)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var touchRegion$ = $(this.triggeringElement);',
'touchRegion$.find(".js-event-text").text("Pressed!");',
'',
'var animationEvent = ''webkitAnimationEnd oanimationend msAnimationEnd animationend'';',
'',
'touchRegion$.addClass(''is-active'');',
'touchRegion$.find(".js-event-icon").removeClass("fa-hand-pointer-o").addClass("fa-hand-grab-o");',
'touchRegion$.one(animationEvent, function(event) {',
'    touchRegion$.removeClass(''is-active'').find(".js-event-icon").addClass("fa-hand-pointer-o").removeClass("fa-hand-grab-o");',
'});'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(768341253404393709)
,p_name=>'Swipe'
,p_event_sequence=>40
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(790287205991406324)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexswipe'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(768341323051393710)
,p_event_id=>wwv_flow_api.id(768341253404393709)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var touchRegion$ = $(this.triggeringElement);',
'var text$ = touchRegion$.find(".js-event-text");',
'var icon$ = touchRegion$.find(".js-event-icon");',
'var swipeDir = this.data.offsetDirection;',
'',
'var message, icon;',
'',
'if (swipeDir === 2) {',
'    message = ''Swiped Left!''',
'    icon = ''fa-hand-o-left''',
'} else if (swipeDir === 4) {',
'    message = ''Swiped Right!''',
'    icon = ''fa-hand-o-right''',
'}',
'',
'text$.text(message);',
'',
'icon$.removeClass("fa-hand-pointer-o fa-hand-o-right fa-hand-o-left").addClass(icon);',
'var animationEvent = ''webkitAnimationEnd oanimationend msAnimationEnd animationend'';',
'touchRegion$.addClass(''is-active'');',
'touchRegion$.one(animationEvent, function(event) {',
'    touchRegion$.removeClass(''is-active'');',
'});'))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(768341424992393711)
,p_name=>'Pan'
,p_event_sequence=>50
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_api.id(790287523852406327)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexpan'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(768341575041393712)
,p_event_id=>wwv_flow_api.id(768341424992393711)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var touchRegion$ = $(this.triggeringElement);',
'var text$ = touchRegion$.find(".js-event-text");',
'var icon$ = touchRegion$.find(".js-event-icon");',
'var swipeDir = this.data.offsetDirection;',
'',
'var offsetX = (touchRegion$.outerWidth() / 2) - 24;',
'',
'var message, icon;',
'',
'if (swipeDir === 2) {',
'    message = ''Panning Left!''',
'    icon = ''fa-hand-o-left''',
'} else if (swipeDir === 4) {',
'    message = ''Panning Right!''',
'    icon = ''fa-hand-o-right''',
'}',
'',
'if (this.data.isFinal ) {',
'    icon$.css("position","static");',
'} else {',
'    icon$.css({',
'        position: "absolute",',
'        left: this.data.deltaX + offsetX',
'    })',
'}',
'',
'// reset icon after 1000 ms',
'setTimeout(function(){',
'    icon$.css("position","static");',
'}, 1000);',
'',
'text$.text(message);',
'icon$.removeClass("fa-hand-pointer-o fa-hand-o-right fa-hand-o-left fa-hand-o-up fa-hand-o-down").addClass(icon);'))
);
end;
/
prompt --application/pages/page_00425
begin
wwv_flow_api.create_page(
 p_id=>425
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'jQuery Mobile Components'
,p_step_title=>'jQuery Mobile Components'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075409'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790288487018406336)
,p_plug_name=>'Column Toggle Report'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The column toggle table mode selectively hides columns at narrower widths as a sensible default but also offers a menu to let users manually control which columns they want to see.',
'',
'<p>The Column Toggle Report provides a responsive table-based report that can selectively hide columns based on the width of the screen. There is also a column selection control where you can manually set the columns to display. This component is ide'
||'ally suited for display tabular data in an easily consumable manner for small screen devices.</p>',
'',
'<p>Be sure to visit the <a href="f?p=&APP_ID.:1720">Components &rarr; Data Tables and Reports &rarr; Column Toggle Report</a> page for additional examples.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790288503092406337)
,p_plug_name=>'Column Toggle Examples'
,p_parent_plug_id=>wwv_flow_api.id(790288487018406336)
,p_icon_css_classes=>'fa-mouse-pointer'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info:t-Alert--removeHeading:margin-top-md'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<b>Column Toggle Examples</b>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790511944527235906)
,p_plug_name=>'Reflow Report'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The Reflow Report provides another responsive table-based report where on small screens, the table columns become stacked and each row becomes a block of data.',
'This is an alternative display to the Column Toggle Report and can be useful when you want to display all columns of a tabular report in a way that works well for small screens.</p>',
'',
'<p>Be sure to visit the <a href="f?p=&APP_ID.:1710">Components &rarr; Data Tables and Reports &rarr; Reflow Report</a> page for additional examples.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(790512059163235907)
,p_plug_name=>'Reflow Report Examples'
,p_parent_plug_id=>wwv_flow_api.id(790511944527235906)
,p_icon_css_classes=>'fa-mouse-pointer'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info:t-Alert--removeHeading:margin-top-md'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<b>Reflow Report Examples</b>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2901995465613168183)
,p_plug_name=>'List View'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The List View component provides a simple list-based user interface that has a wide range of features. This component has built in search, list dividers, counters, nested lists, and more.</p>',
'',
'<p>Be sure to visit the <a href="f?p=&APP_ID.:1700">Components &rarr; List View</a> page for additional examples.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2303911711196056945)
,p_plug_name=>'List View Examples'
,p_parent_plug_id=>wwv_flow_api.id(2901995465613168183)
,p_icon_css_classes=>'fa-mouse-pointer'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info:t-Alert--removeHeading:margin-top-md'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<b>List View Examples</b>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(5275786233051063713)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(6695420295826042402)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>APEX 18.1 introduces three new Region Types that have been ported from the jQuery Mobile user interface. These components are light weight, mobile friendly, and can help to simplify your apps transition from jQuery Mobile to Universal Theme.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(790288682680406338)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(790288503092406337)
,p_button_name=>'COL_TOGGLE_1'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Example 1'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1721:&APP_SESSION.:sample1'',''Column Toggle Report'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(790466406120051534)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(2303911711196056945)
,p_button_name=>'LIST_1'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Example 1'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1701:&APP_SESSION.:sample1'',''List View'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(790512163100235908)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(790512059163235907)
,p_button_name=>'REFLOW_1'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Example 1'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1711:&APP_SESSION.:sample1'',''Reflow Report'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(790288729450406339)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(790288503092406337)
,p_button_name=>'COL_TOGGLE_2'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Example 2'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1721:&APP_SESSION.:sample2'',''Column Toggle Report'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(790512266399235909)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(790512059163235907)
,p_button_name=>'REFLOW_2'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Example 2'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1711:&APP_SESSION.:sample2'',''Reflow Report'');'
,p_icon_css_classes=>'fa-external-link-square'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(790466803294051534)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(2303911711196056945)
,p_button_name=>'LIST_2'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Example 2'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'javascript:apex.theme42demo.openMobileSamplePage(''f?p=&APP_ID.:1701:&APP_SESSION.:sample2'',''List View'');'
,p_icon_css_classes=>'fa-external-link-square'
);
end;
/
prompt --application/pages/page_00500
begin
wwv_flow_api.create_page(
 p_id=>500
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Getting Started'
,p_alias=>'GETTING_STARTED'
,p_step_title=>'Getting Started - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190124090610'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(480456949718117288)
,p_plug_name=>'How do I start using Universal Theme?'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>It is easy to get started using Universal Theme. Just follow the Create Application wizard to get something up and running. From here you can start to build out your application, start customizing it using Template Options and Theme Roller, and le'
||'arn all about it in this very app.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2122543010035810118)
,p_plug_name=>'Getting Started'
,p_icon_css_classes=>'fa-lg fa-mouse-pointer u-color-1'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1224989219520090364)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2152195088034275439)
,p_plug_name=>'Explore Universal Theme'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_component_template_options=>'#DEFAULT#:t-Cards--featured force-fa-lg:t-Cards--displayIcons:t-Cards--3cols:t-Cards--hideBody:t-Cards--animColorFill'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(2199914850856725555)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(1437740873962425604)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00600
begin
wwv_flow_api.create_page(
 p_id=>600
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'About'
,p_alias=>'ABOUT'
,p_step_title=>'About - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20180111091335'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(480671031654352774)
,p_plug_name=>'Hero'
,p_region_css_classes=>'dm-Hero dm-Hero--primary'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<h1>About</h1>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(480671561256352791)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(480954877218755872)
,p_plug_name=>'Region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(693720241683042113)
,p_name=>'P600_PICK_FILES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(480954877218755872)
,p_prompt=>'Pick files'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(869572400154599626)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APEX_APPLICATION_TEMP_FILES'
,p_attribute_09=>'SESSION'
,p_attribute_10=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(693720306661042114)
,p_name=>'P600_PICK_FILE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(480954877218755872)
,p_prompt=>'Pick files'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(869572400154599626)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APEX_APPLICATION_TEMP_FILES'
,p_attribute_09=>'SESSION'
,p_attribute_10=>'N'
);
end;
/
prompt --application/pages/page_00700
begin
wwv_flow_api.create_page(
 p_id=>700
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Layout'
,p_step_title=>'Layout - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081317'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1644987997495870601)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_00701
begin
wwv_flow_api.create_page(
 p_id=>701
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Responsive Design'
,p_step_title=>'Responsive Design - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(558266987012620477)
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081317'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2523817529264280284)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
end;
/
prompt --application/pages/page_01100
begin
wwv_flow_api.create_page(
 p_id=>1100
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Pages'
,p_alias=>'PAGES'
,p_step_title=>'Pages - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(405064482015020227)
,p_javascript_code_onload=>'apex.theme42demo.jump(''&REQUEST.'');'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_css_classes=>'dm-Page'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_page_comment=>'apex.theme42demo.noNavigate();'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075409'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(879725051497769501)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208177424805979201)
,p_plug_name=>'Standard Page'
,p_region_name=>'standard'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The default page template. Ideal for home pages, dashboards, large reports, and other layouts where maximum screen real-estate is desired.<p>',
'<p class="dm-Hero-steps">Set <strong>Standard</strong> as the Page Template</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208177955252979213)
,p_plug_name=>'Standard Page with Side Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208177424805979201)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page side-nav-one-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1101:&APP_SESSION.'',''Standard with Side Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208178412363979213)
,p_plug_name=>'Standard Page with Top Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208177424805979201)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page top-nav-one-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1102:&APP_SESSION.'',''Standard with Top Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208510599141392012)
,p_plug_name=>'Left Side Column'
,p_region_name=>'left_side'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Features a left-side display position for search filters, charts, and other interactive widgets.<p>',
'<p class="dm-Hero-steps">Set <strong>Left Side Column</strong> as the Page Template</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208516421329446152)
,p_plug_name=>'Left Side Column with Side Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208510599141392012)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>60
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page side-nav-left-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1103:&APP_SESSION.'',''Left Side Column Page with Side Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208516914292446153)
,p_plug_name=>'Left Side Column with Top Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208510599141392012)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page top-nav-left-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1104:&APP_SESSION.'',''Left Side Column Page with Top Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208582755068851134)
,p_plug_name=>'Right Side Column'
,p_region_name=>'right_side'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page template features a collapsible right-side display position and is especially useful for displaying action-oriented controls such as buttons or lists.<p>',
'<p class="dm-Hero-steps">Set <strong>Right Side Column</strong> as the Page Template</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208588399024861465)
,p_plug_name=>'Right Side Column with Side Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208582755068851134)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>90
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page side-nav-right-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1105:&APP_SESSION.'',''Right Side Column Page with Side Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208588921163861465)
,p_plug_name=>'Right Side Column with Top Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208582755068851134)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>100
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page top-nav-right-column"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1106:&APP_SESSION.'',''Right Side Column Page with Top Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208592780290878079)
,p_plug_name=>'Both Side Column'
,p_region_name=>'both_sides'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page template features both the left side column and the collapsible right-side column and is well suited for very complex pages.<p>',
'<p class="dm-Hero-steps">Set <strong>Left and Right Side Columns</strong> as the Page Template</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208598100460891250)
,p_plug_name=>'Side Columns Page with Side Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208592780290878079)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>120
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page side-nav-side-columns"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1109:&APP_SESSION.'',''Left and Right Side Columns Page with Side Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208598434970891250)
,p_plug_name=>'Side Columns Page with Top Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208592780290878079)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>130
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page top-nav-side-columns"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1110:&APP_SESSION.'',''Left and Right Side Columns Page with Top Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208604537937911419)
,p_plug_name=>'Marquee Detail'
,p_region_name=>'master_detail'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This page template features a collapsible right side column and a title-bar area which contains primary information. This page template is well suited for displaying information about a master record with detailed reports or charts in the body.<p>',
'<p class="dm-Hero-steps">Set <strong>Marquee Detail</strong> as the Page Template</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208618639365930634)
,p_plug_name=>'Master Detail Page with Side Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208604537937911419)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>150
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page side-nav-master-detail-page"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1107:&APP_SESSION.'',''Master Detail Page with Side Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208619170202930635)
,p_plug_name=>'Right Column Page with Top Navigation'
,p_parent_plug_id=>wwv_flow_api.id(1208604537937911419)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>160
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="dm-Icon dm-Icon--page top-nav-master-detail-page"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1108:&APP_SESSION.'',''Master Detail Page with Top Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208636311646946895)
,p_plug_name=>'Dialog'
,p_region_name=>'dialog'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>These page templates can be loaded as either modal or non-modal (pop-up) dialogs and are very useful for displaying commonly used forms, reports, and other components.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208640476642953023)
,p_plug_name=>'Standard Dialog Page'
,p_parent_plug_id=>wwv_flow_api.id(1208636311646946895)
,p_region_css_classes=>'dm-Hero-screenshot'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>150
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p class="dm-Hero-steps dm-Hero-steps--slim">Set <strong>Standard Dialog</strong> as the Page Template</p>',
'<span class="dm-Icon dm-Icon--page standard-dialog"></span>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208641280982953025)
,p_plug_name=>'Wizard Dialog Page'
,p_parent_plug_id=>wwv_flow_api.id(1208636311646946895)
,p_region_css_classes=>'dm-Hero-screenshot'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>160
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p class="dm-Hero-steps dm-Hero-steps--slim">Set <strong>Wizard Dialog</strong> as the Page Template</p>',
'<span class="dm-Icon dm-Icon--page wizard-dialog"></span>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208659039984989922)
,p_plug_name=>'Other'
,p_region_name=>'other'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The <strong>Login</strong> page template provides an elegant user interface for your app''s log in page.<p>',
'<p>The <strong>Minimal Page</strong> page template is useful for single page applications or pages where where navigation is not necessary.<p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208663557461994609)
,p_plug_name=>'Minimal Page Template'
,p_parent_plug_id=>wwv_flow_api.id(1208659039984989922)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>150
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p class="dm-Hero-steps dm-Hero-steps--slim">Set <strong>Minimal (No  Navigation)</strong> as the Page Template</p>',
'<span class="dm-Icon dm-Icon--page minimal-page"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1113:&APP_SESSION.'',''Minimal Page without Navigation'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1208664067487994609)
,p_plug_name=>'Login Page Template'
,p_parent_plug_id=>wwv_flow_api.id(1208659039984989922)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>160
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p class="dm-Hero-steps dm-Hero-steps--slim">Set <strong>Login</strong> as the Page Template</p>',
'<span class="dm-Icon dm-Icon--page login-page"></span>',
'<button class="t-Button t-Button--icon t-Button--iconRight" onclick="apex.theme42demo.openSamplePage(''f?p=&APP_ID.:1114:&APP_SESSION.'',''Login Page'')" type="button">View Sample</span>',
'</button>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885099481441050902)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Page Templates define the layout and purpose of your pages. This page shows samples of all the available page templates. Universal Theme supports two types of Navigation Menus: tree-based navigation on the side, and tab-like navigation on the top.'
||'</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(791529844939869733)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1208640476642953023)
,p_button_name=>'STD_DIALOG_VIEW'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'View Sample'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:1111:&SESSION.::&DEBUG.:RP::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(791530539726869734)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1208641280982953025)
,p_button_name=>'WIZ_DIALOG_VIEW'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'View Sample'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:1112:&SESSION.::&DEBUG.:RP::'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1917934323891455542)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(879725051497769501)
,p_button_name=>'TEMPLATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Page Template'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:6307:&SESSION.:page:&DEBUG.:RP::'
,p_icon_css_classes=>'fa-file-o'
);
end;
/
prompt --application/pages/page_01101
begin
wwv_flow_api.create_page(
 p_id=>1101
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Standard Page Template with Side Navigation'
,p_step_title=>'Standard Page Template with Side Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'SIDE'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1773976052307980488)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1773976524495980524)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101514886050923)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101681922050924)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_01102
begin
wwv_flow_api.create_page(
 p_id=>1102
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Standard Page Template with Top Navigation'
,p_step_title=>'Standard Page Template with Top Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885099751850050905)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101715079050925)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101828783050926)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885245355685551804)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01103
begin
wwv_flow_api.create_page(
 p_id=>1103
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Left Column Page with Side Navigation '
,p_step_title=>'Left Column Page with Side Navigation- &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(1077614758642401794)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'SIDE'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101080098050918)
,p_plug_name=>'Side Region'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885103837640050946)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885103913944050947)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885257828714625667)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885259067967625674)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01104
begin
wwv_flow_api.create_page(
 p_id=>1104
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Left Column Page with Top Navigation'
,p_step_title=>'Left Column Page with Top Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(1077614758642401794)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885104081496050948)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885104191890050949)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885265682494727198)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885266423191727202)
,p_plug_name=>'Side Region'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885267243543727203)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01105
begin
wwv_flow_api.create_page(
 p_id=>1105
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Right Column Page with Side Navigation'
,p_step_title=>'Right Column Page with Side Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(1077618304322444671)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'SIDE'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885104227154050950)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890858497587160975)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890858852526160976)
,p_plug_name=>'Side Region'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890860048222160978)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897788679843086001)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_01106
begin
wwv_flow_api.create_page(
 p_id=>1106
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Right Column Page with Top Navigation'
,p_step_title=>'Right Column Page with Top Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(1077618304322444671)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890862418217172583)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890862818128172585)
,p_plug_name=>'Side Region'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890864003005172586)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897788897680086003)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897788957351086004)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_01107
begin
wwv_flow_api.create_page(
 p_id=>1107
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Marquee Detail Page with Side Navigation'
,p_step_title=>'Marquee Detail Page with Side Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(549332834543365415)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'SIDE'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20180720114320'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101187334050919)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101219323050920)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h320'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101388924050921)
,p_plug_name=>'Main Content'
,p_region_css_classes=>'dm-Placeholder h240'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-report"></span>',
'<h3>Main Content Report</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885101422359050922)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder h320'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890866935589211371)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h320'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890867353532211373)
,p_plug_name=>'Side Content'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1890868575399211375)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01108
begin
wwv_flow_api.create_page(
 p_id=>1108
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Marquee Detail Page with Top Navigation'
,p_step_title=>'Marquee Detail Page with Top Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(549332834543365415)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20180720114359'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1891236182800396749)
,p_plug_name=>'Main Content'
,p_region_css_classes=>'dm-Placeholder h240'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-report"></span>',
'<h3>Main Content Report</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1891236566190396749)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder h320'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1891236990097396750)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1891237342508396750)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h320'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1891237786108396758)
,p_plug_name=>'Side Content'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1891238103880396759)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h320'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1891239365191396761)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01109
begin
wwv_flow_api.create_page(
 p_id=>1109
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Side Columns Page with Side Navigation'
,p_step_title=>'Side Columns Page with Side Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(1077621880644450151)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'SIDE'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885103503851050943)
,p_plug_name=>'Side Content'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Left Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885103641333050944)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1885103709302050945)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897718715135999477)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897719107181999481)
,p_plug_name=>'Side Content'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Right Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897720315230999483)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01110
begin
wwv_flow_api.create_page(
 p_id=>1110
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Side Columns Page with Top Navigation'
,p_step_title=>'Side Columns Page with Top Navigation - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(1077621880644450151)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897730832631021070)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897731211761021071)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897732004510021072)
,p_plug_name=>'Side Content'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Left Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897732462096021072)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897732879666021072)
,p_plug_name=>'Side Content'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Right Side Region</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897733616582021074)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01111
begin
wwv_flow_api.create_page(
 p_id=>1111
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Standard Dialog Page'
,p_page_mode=>'MODAL'
,p_step_title=>'Standard Dialog Page - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(651378991620880020)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20180102130552'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897789529396086010)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1897789666099086011)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1898476875759595924)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_01112
begin
wwv_flow_api.create_page(
 p_id=>1112
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Wizard Dialog Page'
,p_page_mode=>'MODAL'
,p_step_title=>'Wizard Dialog Page - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(672766417768219611)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20180102130608'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1898625483273662544)
,p_plug_name=>'Wizard Progress'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:t-WizardSteps--displayLabels'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_list_id=>wwv_flow_api.id(561122940005233277)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(561120526789187584)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1898625892787662544)
,p_plug_name=>'Region Footer'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(677400524731372757)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1898626629544662545)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1898627034847662546)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1898626281059662545)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1898625892787662544)
,p_button_name=>'NEXT_STEP'
,p_button_static_id=>'next_button'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--large:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Next'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'fa-chevron-right'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1897789993983086014)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1898625892787662544)
,p_button_name=>'PREV_STEP'
,p_button_static_id=>'prev_button'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--large'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Previous'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_icon_css_classes=>'fa-chevron-left'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1898627448622662546)
,p_name=>'Close Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'#prev_button, #next_button'
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1898627994032662547)
,p_event_id=>wwv_flow_api.id(1898627448622662546)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
end;
/
prompt --application/pages/page_01113
begin
wwv_flow_api.create_page(
 p_id=>1113
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Minimal Page Template'
,p_step_title=>'Minimal Page Template - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(1530046751615002521)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20160729081315'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1899236298329120711)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1899236693537120715)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1899237456403120715)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1899238137245120733)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
end;
/
prompt --application/pages/page_01114
begin
wwv_flow_api.create_page(
 p_id=>1114
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Login Page Template'
,p_step_title=>'Login Page Template - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_step_template=>wwv_flow_api.id(652129338145143712)
,p_page_template_options=>'#DEFAULT#:t-LoginPage--bg3'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1077726089382032168)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190715140249'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1899240689882125402)
,p_plug_name=>'Login Region'
,p_icon_css_classes=>'app-sample-universal-theme'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1225129382632869472)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1897790784065086022)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1899240689882125402)
,p_button_name=>'P1114_LOGIN'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Log In'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1897790557366086020)
,p_name=>'P1114_USER'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1899240689882125402)
,p_prompt=>'User Name'
,p_placeholder=>'username'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(591757292230152601)
,p_item_icon_css_classes=>'fa-user'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1897790694922086021)
,p_name=>'P1114_PASSWORD'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1899240689882125402)
,p_prompt=>'Password'
,p_placeholder=>'password'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>30
,p_tag_css_classes=>'icon-login-password'
,p_field_template=>wwv_flow_api.id(591757292230152601)
,p_item_icon_css_classes=>'fa-key'
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
end;
/
prompt --application/pages/page_01115
begin
wwv_flow_api.create_page(
 p_id=>1115
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Standard Page Template with Tabs Navigation'
,p_step_title=>'Standard Page Template with Tabs Navigation'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(5429749254678674)
,p_nav_list_template_options=>'#DEFAULT#:t-NavTabs--inlineLabels-lg:t-NavTabs--displayLabels-sm'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20180329125819'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2506928802273694723)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2506929274461694759)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2618054264851765158)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2618054431887765159)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder h180'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_01116
begin
wwv_flow_api.create_page(
 p_id=>1116
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Sticky Mobile Header'
,p_step_title=>'Sticky Mobile Header'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#:js-pageStickyMobileHeader'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'TOP'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(5429749254678674)
,p_nav_list_template_options=>'#DEFAULT#:t-NavTabs--inlineLabels-lg:t-NavTabs--displayLabels-sm'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190124090610'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(606905183851638646)
,p_plug_name=>'Page Header'
,p_icon_css_classes=>'fa-check-circle u-color-1'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1224989219520090364)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_plug_display_when_condition=>'sample1'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(756693698683321901)
,p_plug_name=>'Header Buttons'
,p_region_template_options=>'#DEFAULT#:t-ButtonRegion--slimPadding:t-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_api.id(677400524731372757)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source=>'Mobile Page Header'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_plug_display_when_condition=>'sample2'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3254836868438555553)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h480'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3365962331016625988)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h480'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(3365962498052625989)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder h480'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756693854783321903)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(756693698683321901)
,p_button_name=>'EDIT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--link'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Edit'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756693974166321904)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(606905183851638646)
,p_button_name=>'ACTIONS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Actions'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-angle-down'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756693794498321902)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(756693698683321901)
,p_button_name=>'BACK'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--link'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Back'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-chevron-circle-left'
);
end;
/
prompt --application/pages/page_01117
begin
wwv_flow_api.create_page(
 p_id=>1117
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Sticky Mobile Footer'
,p_step_title=>'Sticky Mobile Footer'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_javascript_code_onload=>'apex.theme42demo.noNavigate();'
,p_step_template=>wwv_flow_api.id(2623327345562852400)
,p_page_template_options=>'#DEFAULT#:js-pageStickyMobileHeader'
,p_overwrite_navigation_list=>'Y'
,p_navigation_list_position=>'SIDE'
,p_navigation_list_id=>wwv_flow_api.id(1885182092683398328)
,p_navigation_list_template_id=>wwv_flow_api.id(1018710602436487872)
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_upd_yyyymmddhh24miss=>'20180403065859'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(756677873894197561)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(756695034650321915)
,p_plug_name=>'Page Footer 2'
,p_region_css_classes=>'u-tC'
,p_region_template_options=>'#DEFAULT#:t-ButtonRegion--stickToBottom:t-ButtonRegion--slimPadding'
,p_plug_template=>wwv_flow_api.id(677400524731372757)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'Page Footer'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_plug_display_when_condition=>'sample2'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1363581342422836136)
,p_plug_name=>'Page Footer 1'
,p_region_template_options=>'#DEFAULT#:t-ButtonRegion--stickToBottom:t-ButtonRegion--slimPadding'
,p_plug_template=>wwv_flow_api.id(677400524731372757)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_plug_display_when_condition=>'sample1'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4011513027009753043)
,p_plug_name=>'Region A'
,p_region_css_classes=>'dm-Placeholder h480'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4122638489587823478)
,p_plug_name=>'Region B'
,p_region_css_classes=>'dm-Placeholder h480'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(4122638656623823479)
,p_plug_name=>'Region C'
,p_region_css_classes=>'dm-Placeholder h480'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(606905426347638649)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(1363581342422836136)
,p_button_name=>'MENU'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Menu'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-bars'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756695154452321916)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(756695034650321915)
,p_button_name=>'BUTTON_B'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Button B'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-pencil-square-o'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(756695245524321917)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(756695034650321915)
,p_button_name=>'BUTTON_A'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--link'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Button A'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-list-ul'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(606905539573638650)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1363581342422836136)
,p_button_name=>'PREVIOUS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--link:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Back'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-chevron-circle-left'
);
end;
/
prompt --application/pages/page_01201
begin
wwv_flow_api.create_page(
 p_id=>1201
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Regions - Standard'
,p_alias=>'STANDARD_REGION'
,p_step_title=>'Standard Region - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(405064482015020227)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.button-bar .t-Region-buttons.t-Region-buttons--top {',
'  border-bottom: 1px solid rgba(0,0,0,.1);',
'  background-color: rgba(0,0,0,.05);',
'}'))
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075408'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405001279057846486)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The generic region template. It works well with all widgets and can be heavily customized.</p>',
'<p class="dm-Hero-steps">Set <strong>Standard </strong> as Region Template.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405001723120846493)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405002281522846494)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405002796728846494)
,p_plug_name=>'Examples'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405003240543846495)
,p_plug_name=>'1. Default'
,p_parent_plug_id=>wwv_flow_api.id(405002796728846494)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405003740688846495)
,p_plug_name=>'Standard Region Template'
,p_parent_plug_id=>wwv_flow_api.id(405003240543846495)
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(2623330321607852408)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405004218770846496)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405003240543846495)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405004734816846497)
,p_plug_name=>'2. Hidden Heading'
,p_parent_plug_id=>wwv_flow_api.id(405002796728846494)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405005223088846497)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405004734816846497)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405005744401846498)
,p_plug_name=>'Standard Region Template'
,p_parent_plug_id=>wwv_flow_api.id(405004734816846497)
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody:t-Region--hideHeader'
,p_plug_template=>wwv_flow_api.id(2623330321607852408)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405006286304846498)
,p_plug_name=>'3. Icon in Region Header'
,p_parent_plug_id=>wwv_flow_api.id(405002796728846494)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405006786681846499)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405006286304846498)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>120
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405007218246846499)
,p_plug_name=>'Standard Region Template'
,p_parent_plug_id=>wwv_flow_api.id(405006286304846498)
,p_icon_css_classes=>'fa-line-chart'
,p_region_template_options=>'#DEFAULT#:t-Region--showIcon:i-h240:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(2623330321607852408)
,p_plug_display_sequence=>100
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>',
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>',
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405007792785846500)
,p_plug_name=>'4. Variation B'
,p_parent_plug_id=>wwv_flow_api.id(405002796728846494)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405008227709846500)
,p_plug_name=>'Standard Region Template'
,p_parent_plug_id=>wwv_flow_api.id(405007792785846500)
,p_region_template_options=>'#DEFAULT#:js-showMaximizeButton:i-h240:t-Region--accent2:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(2623330321607852408)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>',
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>',
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405008772612846502)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405007792785846500)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405009288923846503)
,p_plug_name=>'Button Positions'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(481014591124886801)
,p_plug_name=>'About'
,p_parent_plug_id=>wwv_flow_api.id(405009288923846503)
,p_region_template_options=>'#DEFAULT#:margin-bottom-sm'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p class="dm-Hero-steps">The following region shows all possible button positions.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(481014652070886802)
,p_plug_name=>'Region Title'
,p_parent_plug_id=>wwv_flow_api.id(405009288923846503)
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(2623330321607852408)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405015006685846510)
,p_plug_name=>'Use Cases'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405009717585846503)
,p_plug_name=>'Region with Button Bar'
,p_parent_plug_id=>wwv_flow_api.id(405015006685846510)
,p_region_css_classes=>'button-bar'
,p_icon_css_classes=>'fa-window-user'
,p_region_template_options=>'#DEFAULT#:t-Region--showIcon:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(2623330321607852408)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>This region demonstrates a button bar that can be used to navigate between widgets, and also display menu buttons.</p>',
'',
'<p>This region also has a custom style applied to the button container. You can style these "button containers" relatively easily by adding some custom CSS to the page. <br />',
'For example, the class <strong>button-bar</strong> has been applied to the region in Page Designer, and the following CSS has been added to the page:</p>',
'',
'<code>',
'.button-bar .t-Region-buttons.t-Region-buttons--top {',
'  border-bottom: 1px solid rgba(0,0,0,.1);',
'  background-color: rgba(0,0,0,.05);',
'}',
'</code>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405015549018846511)
,p_plug_name=>'Advanced'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481014728072886803)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Change_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Change'
,p_button_position=>'REGION_TEMPLATE_CHANGE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481014852273886804)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Close_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481014949174886805)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Copy_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Copy'
,p_button_position=>'REGION_TEMPLATE_COPY'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481015019928886806)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Create_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Create'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481015180805886807)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Delete_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Delete'
,p_button_position=>'REGION_TEMPLATE_DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481015246460886808)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Edit_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Edit'
,p_button_position=>'REGION_TEMPLATE_EDIT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481015327855886809)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Help_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Help'
,p_button_position=>'REGION_TEMPLATE_HELP'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481015629798886812)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Next_1_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Next'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405013311816846508)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(405009717585846503)
,p_button_name=>'Next_2'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--small:t-Button--pillStart'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Previous'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'fa-angle-left'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405013730859846509)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(405009717585846503)
,p_button_name=>'Next_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--small:t-Button--pillEnd'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Next'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_icon_css_classes=>'fa-angle-right'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405014104372846509)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(405009717585846503)
,p_button_name=>'Save'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--small'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1917870983654289187)
,p_button_sequence=>110
,p_button_plug_id=>wwv_flow_api.id(405002281522846494)
,p_button_name=>'TEMPLATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Region Template'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:6307:&SESSION.:region:&DEBUG.:RP::'
,p_icon_css_classes=>'fa-window-alt-2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(481015887399886814)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(481014652070886802)
,p_button_name=>'Previous_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Previous'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405014533297846509)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(405009717585846503)
,p_button_name=>'Menu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--small:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Menu Button'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_icon_css_classes=>'fa-angle-down'
);
end;
/
prompt --application/pages/page_01202
begin
wwv_flow_api.create_page(
 p_id=>1202
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Region - Alert'
,p_alias=>'ALERT_REGION'
,p_step_title=>'Alert - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(405064482015020227)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190725081241'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405030026238865667)
,p_plug_name=>'Button Positions'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405030534855865669)
,p_plug_name=>'Alert Region with Buttons'
,p_parent_plug_id=>wwv_flow_api.id(405030026238865667)
,p_region_template_options=>'#DEFAULT#:t-Alert--wizard:t-Alert--customIcons:t-Alert--success'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Your request has been submitted successfully. Please check again later in 30 minutes.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405032626695865671)
,p_plug_name=>'Use Cases'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(430900888269155819)
,p_plug_name=>'Order Created Successfully'
,p_parent_plug_id=>wwv_flow_api.id(405032626695865671)
,p_icon_css_classes=>'fa-check-circle'
,p_region_template_options=>'#DEFAULT#:t-Alert--colorBG:t-Alert--wizard:t-Alert--customIcons:t-Alert--success'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>180
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>A confirmation email has been sent to you. This order will be delivered in one week.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(430901183258155822)
,p_plug_name=>'Access Denied'
,p_parent_plug_id=>wwv_flow_api.id(405032626695865671)
,p_icon_css_classes=>'fa-warning'
,p_region_template_options=>'#DEFAULT#:t-Alert--colorBG:t-Alert--wizard:t-Alert--customIcons:t-Alert--danger'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>190
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>You have insufficient privilege. Please contact your Administrator for more information.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405033676790865672)
,p_plug_name=>'Overview'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use the Alert region template to display alerts, confirmations, and other action-oriented messages within the context of a page.</p>',
'<p class="dm-Hero-steps">Set <strong>Alert </strong> as Region Template.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405034198676865672)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405034650920865673)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'JUMP'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405035186562865673)
,p_plug_name=>'Examples'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405035677557865673)
,p_plug_name=>'1. Default'
,p_parent_plug_id=>wwv_flow_api.id(405035186562865673)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405036191818865674)
,p_plug_name=>'Alert Region'
,p_parent_plug_id=>wwv_flow_api.id(405035677557865673)
,p_region_template_options=>'#DEFAULT#:t-Alert--defaultIcons:t-Alert--warning:t-Alert--horizontal'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>140
,p_plug_display_point=>'BODY'
,p_plug_source=>'Region Body'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405036658445865675)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405035677557865673)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>150
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405037115772865675)
,p_plug_name=>'2. Wizard Style'
,p_parent_plug_id=>wwv_flow_api.id(405035186562865673)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405037686380865676)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405037115772865675)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>190
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405038189844865677)
,p_plug_name=>'Alert Region'
,p_parent_plug_id=>wwv_flow_api.id(405037115772865675)
,p_region_template_options=>'#DEFAULT#:t-Alert--colorBG:t-Alert--wizard:t-Alert--defaultIcons:t-Alert--warning'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>170
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder dm-Placeholder--slim"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405038673707865677)
,p_plug_name=>'3. Custom Icon'
,p_parent_plug_id=>wwv_flow_api.id(405035186562865673)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405039109779865678)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405038673707865677)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>210
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405039698654865678)
,p_plug_name=>'Alert Region'
,p_parent_plug_id=>wwv_flow_api.id(405038673707865677)
,p_icon_css_classes=>'fa-cog'
,p_region_template_options=>'#DEFAULT#:t-Alert--customIcons:t-Alert--info:t-Alert--wizard'
,p_plug_template=>wwv_flow_api.id(591654834181983844)
,p_plug_display_sequence=>200
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder dm-Placeholder--slim"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(766161226059482423)
,p_plug_name=>'Template Options'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.DISP_TEMPLATE_OPTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'REGION'
,p_attribute_02=>'Alert'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405030971068865669)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(405030534855865669)
,p_button_name=>'Close'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405031334493865669)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(405030534855865669)
,p_button_name=>'Create'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Create'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(430901013868155821)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(430900888269155819)
,p_button_name=>'Continue'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Continue Shopping'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(389368688647558720)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(405034198676865672)
,p_button_name=>'TEMPLATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Region Template'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:6307:&SESSION.:region:&DEBUG.:RP::'
,p_icon_css_classes=>'fa-window-alt-2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(430901219380155823)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(430901183258155822)
,p_button_name=>'Contact'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Contact Administrator'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(430900933877155820)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(430900888269155819)
,p_button_name=>'View'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconRight'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'View Order'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-chevron-right'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405031704189865670)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(405030534855865669)
,p_button_name=>'Next'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Next'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405032137845865670)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(405030534855865669)
,p_button_name=>'Previous'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Previous'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
end;
/
prompt --application/pages/page_01203
begin
wwv_flow_api.create_page(
 p_id=>1203
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Region - Hero'
,p_alias=>'HERO_REGION'
,p_step_title=>'Hero Region - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(405064482015020227)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190124090610'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405052695327003708)
,p_plug_name=>'Button Positions'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404406547571489329)
,p_plug_name=>'Hero Region With Buttons'
,p_parent_plug_id=>wwv_flow_api.id(405052695327003708)
,p_icon_css_classes=>'fa-pie-chart'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1224989219520090364)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405055158500003711)
,p_plug_name=>'Use Cases'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405055601712003711)
,p_plug_name=>'Advanced'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405056193248003712)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Capture your users'' attention on homepage, dashboard, and other introductory-style pages. This region template displays an icon, heading and sub headings, and buttons.</p>',
'<p class="dm-Hero-steps">Set <strong>Hero </strong> as Region Template.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405056618535003713)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405057183508003713)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405057660846003713)
,p_plug_name=>'Examples'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405078149280135513)
,p_plug_name=>'1. Default'
,p_parent_plug_id=>wwv_flow_api.id(405057660846003713)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>230
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405078697563135514)
,p_plug_name=>'Hero Region Template'
,p_parent_plug_id=>wwv_flow_api.id(405078149280135513)
,p_icon_css_classes=>'app-sample-universal-theme'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1224989219520090364)
,p_plug_display_sequence=>240
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Region Body</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405079110421135514)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405078149280135513)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>250
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405079628962135515)
,p_plug_name=>'2. Custom Icon'
,p_parent_plug_id=>wwv_flow_api.id(405057660846003713)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>260
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405080170071135515)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405079628962135515)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>280
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405080603894135515)
,p_plug_name=>'Hero Region Template'
,p_parent_plug_id=>wwv_flow_api.id(405079628962135515)
,p_icon_css_classes=>'fa-area-chart'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1224989219520090364)
,p_plug_display_sequence=>270
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Region Body</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405054264010003710)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(404406547571489329)
,p_button_name=>'Button'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Button'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1917874487212313185)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(405056618535003713)
,p_button_name=>'TEMPLATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Region Template'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:6307:&SESSION.:region:&DEBUG.:RP::'
,p_icon_css_classes=>'fa-window-alt-2'
);
end;
/
prompt --application/pages/page_01204
begin
wwv_flow_api.create_page(
 p_id=>1204
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Region - Button Container'
,p_alias=>'BUTTON_CONTAINER_REGION'
,p_step_title=>'Button Container - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(405064482015020227)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190102075409'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405102577413686799)
,p_plug_name=>'Use Cases'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405103093799686799)
,p_plug_name=>'Advanced'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405103508324686800)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>'<p>Button Groups are a series of buttons that appear together to make a single conrol.  You can create button groups in APEX using the button component, or as a customized radio group page item.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405104083056686801)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405104570099686801)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405110226728724407)
,p_plug_name=>'Using Page Buttons'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can turn a set of buttons into a button group simply by modifying the template options. Follow these instructions to create a simple button group of the following three buttons.</p>',
'<div class="dm-Hero-steps margin-bottom-md">',
'<strong>Step 1.</strong> Create three buttons in the same button position<br>',
'<strong>Step 2.</strong> Update each of the buttons'' Template Options as follows<br>',
'<ol>',
'  <li>Button A: set <em>Button Set</em> to <b>First Button</b></li>',
'  <li>Button B: set <em>Button Set</em> to <b>Inner Button</b></li>',
'  <li>Button C: set <em>Button Set</em> to <b>Last Button</b></li>',
'</ol>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405104970129686802)
,p_plug_name=>'Additional Example'
,p_parent_plug_id=>wwv_flow_api.id(405110226728724407)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3:margin-top-lg'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>You can have any number of buttons within a button group.  Here is an example of a music player toolbar styled the same method.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2152193383509275422)
,p_plug_name=>'Using Page Items'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>You can also style the <strong>radio button</strong> or <strong>checkbox</strong> items to appear as a Button Group. This is particularly useful when you want to use store the selection in Session State and if you want to Dynamic Actions to perfor'
||'m some client side behavior as you interact with the control.</p>',
'<p>For example, in several Packaged Apps, this technique is used to switch between different displays of the same data.</p>',
'<p>Follow the instrutions below to convert a Radio Group item into a Button Group.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2152194026178275429)
,p_plug_name=>'Step 1'
,p_parent_plug_id=>wwv_flow_api.id(2152193383509275422)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Hero-steps">',
'<strong>Step 1.</strong> Create a Radio Group item and set the following properties:<br>',
'<ol>',
'  <li>Set <em>Number of Columns</em> to the number of buttons you want to have in the button group. In this example, it is set to 3.</li>',
'  <li>Under <strong>List of Values</strong>, make sure that <em>Display Extra Values</em> and <em>Display Null Value</em> are set to <strong>No</strong></li>',
'</ol>',
'<p>After competing this step, you should have a button group that looks like the item below.</p>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(2152194171836275430)
,p_plug_name=>'Step 2'
,p_parent_plug_id=>wwv_flow_api.id(2152193383509275422)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1922209187092703219)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Hero-steps">',
'<p><strong>Step 2.</strong> Update the Radio Group item''s Template Options and set <em>Item Group Display</em> to <strong>Display as Pill Button</strong></p>',
'<p>That''s it. Your Radio Group item will now appear as a Button Group.</p>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405111569535724409)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(405110226728724407)
,p_button_name=>'BTN_GRP_A'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pillStart'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Button A'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-angle-left'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2152192663941275415)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(405110226728724407)
,p_button_name=>'BTN_GRP_B'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pill'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Button B'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-angle-left'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405111907244724409)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(405110226728724407)
,p_button_name=>'BTN_GRP_C'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pillEnd'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Button C'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-angle-right'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2152192730436275416)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(405104970129686802)
,p_button_name=>'BTN_GRP_2A'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pillStart'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Previous'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-step-backward'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2152192829930275417)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(405104970129686802)
,p_button_name=>'BTN_GRP_2B'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pill'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Rewind'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-backward'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2152193196109275420)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(405104970129686802)
,p_button_name=>'BTN_GRP_2C'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pill'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Play'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-play'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2152193271849275421)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(405104970129686802)
,p_button_name=>'BTN_GRP_2D'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pill'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Stop'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-stop'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2152192959102275418)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(405104970129686802)
,p_button_name=>'BTN_GRP_2E'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pill'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Forward'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-forward'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(2152193034453275419)
,p_button_sequence=>110
,p_button_plug_id=>wwv_flow_api.id(405104970129686802)
,p_button_name=>'BTN_GRP_2F'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--pillEnd'
,p_button_template_id=>wwv_flow_api.id(900079107762114354)
,p_button_image_alt=>'Next'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-step-forward'
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1917874743798315882)
,p_button_sequence=>130
,p_button_plug_id=>wwv_flow_api.id(405104083056686801)
,p_button_name=>'TEMPLATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Button Template'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:6307:&SESSION.:button:&DEBUG.:RP::'
,p_icon_css_classes=>'fa-button'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2152193751719275426)
,p_name=>'P1204_RADIO_A'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2152194026178275429)
,p_item_default=>'A'
,p_prompt=>'Radio Group'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_lov=>'STATIC2:Option A;A,Option B;B,Option C;C'
,p_field_template=>wwv_flow_api.id(869572400154599626)
,p_item_template_options=>'#DEFAULT#:margin-top-md'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'3'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(2152194255538275431)
,p_name=>'P1204_RADIO_B'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(2152194171836275430)
,p_item_default=>'A'
,p_prompt=>'Radio Button Group'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_lov=>'STATIC2:Option A;A,Option B;B,Option C;C'
,p_field_template=>wwv_flow_api.id(869572400154599626)
,p_item_template_options=>'#DEFAULT#:margin-top-md:t-Form-fieldContainer--radioButtonGroup'
,p_lov_display_extra=>'NO'
,p_attribute_01=>'3'
,p_attribute_02=>'NONE'
);
end;
/
prompt --application/pages/page_01205
begin
wwv_flow_api.create_page(
 p_id=>1205
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Region - Carousel'
,p_alias=>'CAROUSEL_REGION'
,p_step_title=>'Carousel Region - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(405064482015020227)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190725081241'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405179639694156564)
,p_plug_name=>'Use Cases'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405180198055156564)
,p_plug_name=>'Advanced'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NEVER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405180664967156565)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Show off one sub region at a time. For example, displaying a report and a chart, a slideshow, or different views of the same data.</p>',
'<p class="dm-Hero-steps">Set <strong>Carousel Container</strong> as Region Template.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405181163279156566)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405181667338156566)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405182113971156566)
,p_plug_name=>'Examples'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405192271255165690)
,p_plug_name=>'1. Default'
,p_parent_plug_id=>wwv_flow_api.id(405182113971156566)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>400
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405192787677165690)
,p_plug_name=>'Carousel Region'
,p_parent_plug_id=>wwv_flow_api.id(405192271255165690)
,p_region_template_options=>'#DEFAULT#:t-Region--hiddenOverflow'
,p_plug_template=>wwv_flow_api.id(1418258663404351882)
,p_plug_display_sequence=>410
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405193236108165691)
,p_plug_name=>'Region A'
,p_parent_plug_id=>wwv_flow_api.id(405192787677165690)
,p_region_css_classes=>'dm-ColorBlock u-color-1 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>420
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405193784157165691)
,p_plug_name=>'Region B'
,p_parent_plug_id=>wwv_flow_api.id(405192787677165690)
,p_region_css_classes=>'dm-ColorBlock u-color-2 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>430
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405194257246165692)
,p_plug_name=>'Region C'
,p_parent_plug_id=>wwv_flow_api.id(405192787677165690)
,p_region_css_classes=>'dm-ColorBlock u-color-3 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>440
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405194783904165692)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405192271255165690)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>450
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405195226267165693)
,p_plug_name=>'2. Spin and Cycle'
,p_parent_plug_id=>wwv_flow_api.id(405182113971156566)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>810
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405195754410165693)
,p_plug_name=>'Carousel Region'
,p_parent_plug_id=>wwv_flow_api.id(405195226267165693)
,p_region_template_options=>'t-Region--carouselSpin:js-cycle5s:t-Region--hiddenOverflow'
,p_plug_template=>wwv_flow_api.id(1418258663404351882)
,p_plug_display_sequence=>410
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405196298963165694)
,p_plug_name=>'Region A'
,p_parent_plug_id=>wwv_flow_api.id(405195754410165693)
,p_region_css_classes=>'dm-ColorBlock u-color-4 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>420
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405196702552165695)
,p_plug_name=>'Region C'
,p_parent_plug_id=>wwv_flow_api.id(405195754410165693)
,p_region_css_classes=>'dm-ColorBlock u-color-6 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>440
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405197216513165695)
,p_plug_name=>'Region B'
,p_parent_plug_id=>wwv_flow_api.id(405195754410165693)
,p_region_css_classes=>'dm-ColorBlock u-color-5 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>430
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405197722102165696)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405195226267165693)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>450
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405198253897165696)
,p_plug_name=>'3. Remember Slide'
,p_parent_plug_id=>wwv_flow_api.id(405182113971156566)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>820
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405198718058165696)
,p_plug_name=>'Carousel Region'
,p_parent_plug_id=>wwv_flow_api.id(405198253897165696)
,p_region_template_options=>'#DEFAULT#:js-useLocalStorage:t-Region--hiddenOverflow'
,p_plug_template=>wwv_flow_api.id(1418258663404351882)
,p_plug_display_sequence=>410
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405199255923165697)
,p_plug_name=>'Region A'
,p_parent_plug_id=>wwv_flow_api.id(405198718058165696)
,p_region_css_classes=>'dm-ColorBlock u-color-7 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>420
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405199723225165698)
,p_plug_name=>'Region C'
,p_parent_plug_id=>wwv_flow_api.id(405198718058165696)
,p_region_css_classes=>'dm-ColorBlock u-color-9 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>440
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405200247907165698)
,p_plug_name=>'Region B'
,p_parent_plug_id=>wwv_flow_api.id(405198718058165696)
,p_region_css_classes=>'dm-ColorBlock u-color-8 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>430
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405200768144165699)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405198253897165696)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>450
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405187617287156572)
,p_plug_name=>'Button Positions'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405188182953156572)
,p_plug_name=>'Carousel Region with Buttons'
,p_parent_plug_id=>wwv_flow_api.id(405187617287156572)
,p_region_template_options=>'#DEFAULT#:t-Region--carouselSlide:js-cycle10s:t-Region--hiddenOverflow'
,p_plug_template=>wwv_flow_api.id(1418258663404351882)
,p_plug_display_sequence=>370
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404406709752489331)
,p_plug_name=>'Region A'
,p_parent_plug_id=>wwv_flow_api.id(405188182953156572)
,p_region_css_classes=>'dm-ColorBlock u-color-7 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region A</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404406814520489332)
,p_plug_name=>'Region B'
,p_parent_plug_id=>wwv_flow_api.id(405188182953156572)
,p_region_css_classes=>'dm-ColorBlock u-color-8 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region B</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404406906359489333)
,p_plug_name=>'Region C'
,p_parent_plug_id=>wwv_flow_api.id(405188182953156572)
,p_region_css_classes=>'dm-ColorBlock u-color-9 h200'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region C</h3>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(714379152428623415)
,p_plug_name=>'Template Options'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.DISP_TEMPLATE_OPTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'REGION'
,p_attribute_02=>'Carousel Container'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405188538219156573)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_CHG'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Change'
,p_button_position=>'REGION_TEMPLATE_CHANGE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405188959895156573)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_CLOSE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(404407071977489334)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_COY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Copy'
,p_button_position=>'REGION_TEMPLATE_COPY'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405189351884156575)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_CREATE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Create'
,p_button_position=>'REGION_TEMPLATE_CREATE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405189703444156575)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_DEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Delete'
,p_button_position=>'REGION_TEMPLATE_DELETE'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405190166572156575)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_EDIT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Edit'
,p_button_position=>'REGION_TEMPLATE_EDIT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(404407126038489335)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_HELP'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Help'
,p_button_position=>'REGION_TEMPLATE_HELP'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405190523812156576)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_NEXT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Next'
,p_button_position=>'REGION_TEMPLATE_NEXT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1917875079922318142)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(405181163279156566)
,p_button_name=>'TEMPLATE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--noUI:t-Button--iconLeft'
,p_button_template_id=>wwv_flow_api.id(633800930240492718)
,p_button_image_alt=>'Region Template'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:6307:&SESSION.:region:&DEBUG.:RP::'
,p_icon_css_classes=>'fa-window-alt-2'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(405190989343156576)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(405188182953156572)
,p_button_name=>'BTN_BP_PREV'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(2623334346116852418)
,p_button_image_alt=>'Previous'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
);
end;
/
prompt --application/pages/page_01206
begin
wwv_flow_api.create_page(
 p_id=>1206
,p_user_interface_id=>wwv_flow_api.id(821272323468330288)
,p_name=>'Region - Collapsible'
,p_alias=>'COLLAPSIBLE_REGION'
,p_step_title=>'Collapsible Region - &APP_TITLE.'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_group_id=>wwv_flow_api.id(405064482015020227)
,p_page_css_classes=>'dm-Page dm-Page--center'
,p_page_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20190725081241'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405224560308328320)
,p_plug_name=>'Button Positions'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(404407372971489337)
,p_plug_name=>'Collapsible Region With Buttons'
,p_parent_plug_id=>wwv_flow_api.id(405224560308328320)
,p_region_template_options=>'#DEFAULT#:is-expanded:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(1215306280710140812)
,p_plug_display_sequence=>480
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder h180">',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405225927915328322)
,p_plug_name=>'Template Options'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.DISP_TEMPLATE_OPTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'REGION'
,p_attribute_02=>'Collapsible'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405226928846328323)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Allow your users to toggle the visibility of a region''s content on the page.</p>',
'<p class="dm-Hero-steps">Set <strong>Collapsible</strong> as Region Template.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405227422312328324)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#:t-BreadcrumbRegion--useBreadcrumbTitle'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1082434711915925186)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_01'
,p_menu_id=>wwv_flow_api.id(1725934084712570512)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(2623334730651852421)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405227909448328325)
,p_plug_name=>'Region Display Selector'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405228474578328325)
,p_plug_name=>'Examples'
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h2'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405234650779342794)
,p_plug_name=>'1. Default'
,p_parent_plug_id=>wwv_flow_api.id(405228474578328325)
,p_region_template_options=>'#DEFAULT#:t-ContentBlock--h3'
,p_plug_template=>wwv_flow_api.id(873087052820635270)
,p_plug_display_sequence=>470
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405235122404342795)
,p_plug_name=>'Collapsible Region'
,p_parent_plug_id=>wwv_flow_api.id(405234650779342794)
,p_region_template_options=>'#DEFAULT#:is-expanded:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(1215306280710140812)
,p_plug_display_sequence=>480
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="dm-Placeholder h180"> ',
'<span class="a-Icon icon-template-region"></span>',
'<h3>Region Body</h3>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405235617069342795)
,p_plug_name=>'Demo How To'
,p_parent_plug_id=>wwv_flow_api.id(405234650779342794)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(3052412050530173647)
,p_plug_display_sequence=>490
,p_plug_display_point=>'BODY'
,p_plug_source_type=>'PLUGIN_COM.ORACLE.APEX.HOW_TO_INSTRUCTIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(405236161874342796)