
Rem  Copyright (c) Oracle Corporation 2011 - 2017. All Rights Reserved.
Rem
Rem    NAME
Rem      types.sql
Rem
Rem    DESCRIPTION
Rem      Object types used by Oracle APEX packages.
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem    pawolf      05/02/2011 - Created (moved object types from tab.sql and flowu.sql)
Rem    cneumuel    04/26/2013 - renamed vc4000array to wwv_flow_t_varchar2
Rem    cneumuel    05/22/2013 - Added wwv_flow_t_number
Rem    cneumuel    10/31/2013 - Added wwv_flow_t_ldap_attribute, wwv_flow_t_ldap_attributes (feature #3)
Rem    jstraub     03/27/2015 - Removed force keyword from wwv_flow_t_ldap_attribute, not valid syntax for 11.1 (bug 20783772)
Rem    pawolf      05/22/2016 - Renamed t_temp_lov_value and t_temp_lov_data to wwv_flow_...
Rem    cczarski    09/04/2017 - Added wwv_flow_t_clob for web sources "fetch multiple pages" functionality (feature #2092)
Rem    cneumuel    10/05/2017 - Added wwv_flow_t_export_file, wwv_flow_t_export_files (feature #2224)
Rem    cneumuel    10/10/2017 - Added force attribute to types, to make script re-runnable

set define '^'

--------------------------------------------------------------------------------
-- T R E E S
--------------------------------------------------------------------------------

-- These types define tree entries and arrays of these entries. The array of
-- tree entries represents a list of sub-tree entries.

prompt creating object type wwv_flow_tree_entry

create or replace type wwv_flow_tree_entry force as object
( seq      number,
  lev      number,
  id       varchar2(4000),
  pid      varchar2(4000),
  kids     number,
  expand   varchar2(1),
  indent   varchar2(4000),
  name     varchar2(4000),
  link     varchar2(4000),
  a1       varchar2(4000),
  a2       varchar2(4000) )
/

prompt creating object type wwv_flow_tree_subs

create or replace type wwv_flow_tree_subs as table of wwv_flow_tree_entry not null;
/

prompt creating object type wwv_flow_tree_num_arr

create or replace type wwv_flow_tree_num_arr as table of number not null
/

--------------------------------------------------------------------------------
-- Object types used in flowu.sql
--------------------------------------------------------------------------------

prompt creating object type wwv_flow_t_varchar2

create or replace type wwv_flow_t_varchar2 as table of varchar2(32767)
/

prompt creating object type wwv_flow_t_clob

create or replace type wwv_flow_t_clob as table of clob
/

prompt creating object type wwv_flow_t_number

create or replace type wwv_flow_t_number as table of number
/

prompt creating object type wwv_flow_t_temp_lov_value

create or replace type wwv_flow_t_temp_lov_value force is object (
    insert_order number,
    disp         varchar2(4000),
    val          varchar2(4000) )
/

prompt creating object type wwv_flow_t_temp_lov_data

create or replace type wwv_flow_t_temp_lov_data is table of wwv_flow_t_temp_lov_value
/

--##############################################################################
--#
--# TYPES FOR APEX_LDAP
--#
--##############################################################################

create or replace type wwv_flow_t_ldap_attribute force is object (
    dn   varchar2(4000),
    name varchar2(4000),
    val  varchar2(4000)
)
/
show err
create or replace type wwv_flow_t_ldap_attributes is table of wwv_flow_t_ldap_attribute
/
show err

--##############################################################################
--#
--# TYPES FOR APEX_EXPORT
--#
--##############################################################################
create or replace type wwv_flow_t_export_file force is object (
    name     varchar2(255),
    contents clob
)
/
show err
create or replace type wwv_flow_t_export_files is table of wwv_flow_t_export_file
/
show err


--##############################################################################
--#
--# TYPES FOR DATA PARSER
--#
--##############################################################################

create or replace type wwv_flow_t_parser_row as object(
    line_number number,
    --
    col001 varchar2(4000), col002 varchar2(4000), col003 varchar2(4000), col004 varchar2(4000), col005 varchar2(4000),
    col006 varchar2(4000), col007 varchar2(4000), col008 varchar2(4000), col009 varchar2(4000), col010 varchar2(4000),
    col011 varchar2(4000), col012 varchar2(4000), col013 varchar2(4000), col014 varchar2(4000), col015 varchar2(4000),
    col016 varchar2(4000), col017 varchar2(4000), col018 varchar2(4000), col019 varchar2(4000), col020 varchar2(4000),
    col021 varchar2(4000), col022 varchar2(4000), col023 varchar2(4000), col024 varchar2(4000), col025 varchar2(4000),
    col026 varchar2(4000), col027 varchar2(4000), col028 varchar2(4000), col029 varchar2(4000), col030 varchar2(4000),
    col031 varchar2(4000), col032 varchar2(4000), col033 varchar2(4000), col034 varchar2(4000), col035 varchar2(4000),
    col036 varchar2(4000), col037 varchar2(4000), col038 varchar2(4000), col039 varchar2(4000), col040 varchar2(4000),
    col041 varchar2(4000), col042 varchar2(4000), col043 varchar2(4000), col044 varchar2(4000), col045 varchar2(4000),
    col046 varchar2(4000), col047 varchar2(4000), col048 varchar2(4000), col049 varchar2(4000), col050 varchar2(4000),
    col051 varchar2(4000), col052 varchar2(4000), col053 varchar2(4000), col054 varchar2(4000), col055 varchar2(4000),
    col056 varchar2(4000), col057 varchar2(4000), col058 varchar2(4000), col059 varchar2(4000), col060 varchar2(4000),
    col061 varchar2(4000), col062 varchar2(4000), col063 varchar2(4000), col064 varchar2(4000), col065 varchar2(4000),
    col066 varchar2(4000), col067 varchar2(4000), col068 varchar2(4000), col069 varchar2(4000), col070 varchar2(4000),
    col071 varchar2(4000), col072 varchar2(4000), col073 varchar2(4000), col074 varchar2(4000), col075 varchar2(4000),
    col076 varchar2(4000), col077 varchar2(4000), col078 varchar2(4000), col079 varchar2(4000), col080 varchar2(4000),
    col081 varchar2(4000), col082 varchar2(4000), col083 varchar2(4000), col084 varchar2(4000), col085 varchar2(4000),
    col086 varchar2(4000), col087 varchar2(4000), col088 varchar2(4000), col089 varchar2(4000), col090 varchar2(4000),
    col091 varchar2(4000), col092 varchar2(4000), col093 varchar2(4000), col094 varchar2(4000), col095 varchar2(4000),
    col096 varchar2(4000), col097 varchar2(4000), col098 varchar2(4000), col099 varchar2(4000), col100 varchar2(4000), 

    col101 varchar2(4000), col102 varchar2(4000), col103 varchar2(4000), col104 varchar2(4000), col105 varchar2(4000),
    col106 varchar2(4000), col107 varchar2(4000), col108 varchar2(4000), col109 varchar2(4000), col110 varchar2(4000),
    col111 varchar2(4000), col112 varchar2(4000), col113 varchar2(4000), col114 varchar2(4000), col115 varchar2(4000),
    col116 varchar2(4000), col117 varchar2(4000), col118 varchar2(4000), col119 varchar2(4000), col120 varchar2(4000),
    col121 varchar2(4000), col122 varchar2(4000), col123 varchar2(4000), col124 varchar2(4000), col125 varchar2(4000),
    col126 varchar2(4000), col127 varchar2(4000), col128 varchar2(4000), col129 varchar2(4000), col130 varchar2(4000),
    col131 varchar2(4000), col132 varchar2(4000), col133 varchar2(4000), col134 varchar2(4000), col135 varchar2(4000),
    col136 varchar2(4000), col137 varchar2(4000), col138 varchar2(4000), col139 varchar2(4000), col140 varchar2(4000),
    col141 varchar2(4000), col142 varchar2(4000), col143 varchar2(4000), col144 varchar2(4000), col145 varchar2(4000),
    col146 varchar2(4000), col147 varchar2(4000), col148 varchar2(4000), col149 varchar2(4000), col150 varchar2(4000),
    col151 varchar2(4000), col152 varchar2(4000), col153 varchar2(4000), col154 varchar2(4000), col155 varchar2(4000),
    col156 varchar2(4000), col157 varchar2(4000), col158 varchar2(4000), col159 varchar2(4000), col160 varchar2(4000),
    col161 varchar2(4000), col162 varchar2(4000), col163 varchar2(4000), col164 varchar2(4000), col165 varchar2(4000),
    col166 varchar2(4000), col167 varchar2(4000), col168 varchar2(4000), col169 varchar2(4000), col170 varchar2(4000),
    col171 varchar2(4000), col172 varchar2(4000), col173 varchar2(4000), col174 varchar2(4000), col175 varchar2(4000),
    col176 varchar2(4000), col177 varchar2(4000), col178 varchar2(4000), col179 varchar2(4000), col180 varchar2(4000),
    col181 varchar2(4000), col182 varchar2(4000), col183 varchar2(4000), col184 varchar2(4000), col185 varchar2(4000),
    col186 varchar2(4000), col187 varchar2(4000), col188 varchar2(4000), col189 varchar2(4000), col190 varchar2(4000),
    col191 varchar2(4000), col192 varchar2(4000), col193 varchar2(4000), col194 varchar2(4000), col195 varchar2(4000),
    col196 varchar2(4000), col197 varchar2(4000), col198 varchar2(4000), col199 varchar2(4000), col200 varchar2(4000), 

    col201 varchar2(4000), col202 varchar2(4000), col203 varchar2(4000), col204 varchar2(4000), col205 varchar2(4000),
    col206 varchar2(4000), col207 varchar2(4000), col208 varchar2(4000), col209 varchar2(4000), col210 varchar2(4000),
    col211 varchar2(4000), col212 varchar2(4000), col213 varchar2(4000), col214 varchar2(4000), col215 varchar2(4000),
    col216 varchar2(4000), col217 varchar2(4000), col218 varchar2(4000), col219 varchar2(4000), col220 varchar2(4000),
    col221 varchar2(4000), col222 varchar2(4000), col223 varchar2(4000), col224 varchar2(4000), col225 varchar2(4000),
    col226 varchar2(4000), col227 varchar2(4000), col228 varchar2(4000), col229 varchar2(4000), col230 varchar2(4000),
    col231 varchar2(4000), col232 varchar2(4000), col233 varchar2(4000), col234 varchar2(4000), col235 varchar2(4000),
    col236 varchar2(4000), col237 varchar2(4000), col238 varchar2(4000), col239 varchar2(4000), col240 varchar2(4000),
    col241 varchar2(4000), col242 varchar2(4000), col243 varchar2(4000), col244 varchar2(4000), col245 varchar2(4000),
    col246 varchar2(4000), col247 varchar2(4000), col248 varchar2(4000), col249 varchar2(4000), col250 varchar2(4000),
    col251 varchar2(4000), col252 varchar2(4000), col253 varchar2(4000), col254 varchar2(4000), col255 varchar2(4000),
    col256 varchar2(4000), col257 varchar2(4000), col258 varchar2(4000), col259 varchar2(4000), col260 varchar2(4000),
    col261 varchar2(4000), col262 varchar2(4000), col263 varchar2(4000), col264 varchar2(4000), col265 varchar2(4000),
    col266 varchar2(4000), col267 varchar2(4000), col268 varchar2(4000), col269 varchar2(4000), col270 varchar2(4000),
    col271 varchar2(4000), col272 varchar2(4000), col273 varchar2(4000), col274 varchar2(4000), col275 varchar2(4000),
    col276 varchar2(4000), col277 varchar2(4000), col278 varchar2(4000), col279 varchar2(4000), col280 varchar2(4000),
    col281 varchar2(4000), col282 varchar2(4000), col283 varchar2(4000), col284 varchar2(4000), col285 varchar2(4000),
    col286 varchar2(4000), col287 varchar2(4000), col288 varchar2(4000), col289 varchar2(4000), col290 varchar2(4000),
    col291 varchar2(4000), col292 varchar2(4000), col293 varchar2(4000), col294 varchar2(4000), col295 varchar2(4000),
    col296 varchar2(4000), col297 varchar2(4000), col298 varchar2(4000), col299 varchar2(4000), col300 varchar2(4000),
    --
    clob01 clob, clob02 clob, clob03 clob, clob04 clob, clob05 clob,
    clob06 clob, clob07 clob, clob08 clob, clob09 clob, clob10 clob,
    clob11 clob, clob12 clob, clob13 clob, clob14 clob, clob15 clob,
    clob16 clob, clob17 clob, clob18 clob, clob19 clob, clob20 clob,
    --
    row_info varchar2(4000)
)
/
show err

create type wwv_flow_t_parser_table as table of wwv_flow_t_parser_row
/
show err

create type wwv_flow_t_parser_worksheet as object(
    sheet_sequence          number,
    sheet_display_name      varchar2(4000),
    sheet_file_name         varchar2(4000),
    sheet_path              varchar2(4000) )
/
show err

create type wwv_flow_t_parser_worksheets as table of wwv_flow_t_parser_worksheet
/
show err

create type wwv_flow_t_parser_column as object(
    column_position     number(5),
    column_name         varchar2(128),
    data_type           varchar2(128),
    format_mask         varchar2(255),
    decimal_char        varchar2(2),
    clob_content_column varchar2(128) )
/
show err

create type wwv_flow_t_parser_columns as table of wwv_flow_t_parser_column
/
show err

prompt ...done create object types
