set define '^' verify off
prompt ...wwv_flow_authentication_saml.sql
create or replace package wwv_flow_authentication_saml as
--------------------------------------------------------------------------------
--
-- Copyright (c) Oracle Corporation 1999 - 2019. All Rights Reserved.
--
-- NAME
--   wwv_flow_authentication_saml.sql
--
-- DESCRIPTION
--
-- RUNTIME DEPLOYMENT: YES
-- PUBLIC:             NO
--
-- MODIFIED   (MM/DD/YYYY)
--   cneumuel  06/04/2019 - Created
--
--------------------------------------------------------------------------------

--==============================================================================
-- SAML authentication scheme hook.
--==============================================================================
function invalid_session (
    p_authentication in wwv_flow_plugin_api.t_authentication )
    return wwv_flow_plugin_api.t_authentication_inval_result;

--==============================================================================
-- SAML authentication scheme hook.
--==============================================================================
function ajax (
    p_plugin         in wwv_flow_plugin_api.t_plugin,
    p_authentication in wwv_flow_plugin_api.t_authentication )
    return wwv_flow_plugin_api.t_authentication_ajax_result;

--==============================================================================
-- SAML authentication scheme hook.
--==============================================================================
function post_logout (
    p_authentication in wwv_flow_plugin_api.t_authentication )
    return wwv_flow_plugin_api.t_authentication_logout_result;

--==============================================================================
-- Implementation of wwv_flow_authentication_api.saml_callback.
--==============================================================================
procedure saml_callback (
    SAMLResponse      in varchar2,
    RelayState        in varchar2,
    SigAlg            in varchar2,
    Signature         in varchar2 );

end wwv_flow_authentication_saml;
/
show err

