set define '^' verify off
prompt ...wwv_flow_css_calendar
create or replace package wwv_flow_css_calendar
as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2013 - 2019. All Rights Reserved.
--
--    NAME
--      wwv_flow_css_calendar.sql
--
--    DESCRIPTION
--      This package is resonsible for handling css calendar native region plugin.
--
--    MODIFIED      (MM/DD/YYYY)
--    pmanirah       07/30/2013  - Created
--    pmanirah       07/30/2013  - Removed calls to render_calendar and ajax_calendar.
--                                 these calls will me made through render_region of wwv_flow_region_native.plb
--    pmanirah       08/01/2013  - Added a mew constant g_css_class_default which will be used to set default css class for event
--    pmanirah       11/25/2013  - Updated the t_event type by adding new attribute - description feature#1315
--    pmanirah       03/17/2014  - Added new function to retrieve first of day of the week and time format getFirstDayofWeek and getTimeFormat
--    pmanirah       06/06/2014  - Added a new function to transform the application date format to Fullcalendar date format
--    pmanirah       08/13/2014  - Added new parameters to p_allday_slot to mobile_week_view and mobile_day_view
--    pmanirah       11/10/2014  - Added new global variables g_xml_data, g_template_xslt, g_print_config and g_export_blob 
--    pmanirah       11/10/2014   - Moved render_css_calendar and ajax_css_calendar functions to seperate package wwv_flow_css_calendar
--    pmanirah       01/14/2015   - Added a new attribute to t_event record, this will be used during the sorting algorithm
--    cczarski       03/18/2016   - removed db_to_fc_format_mask - no longer needed
--
    
--==============================================================================
-- Renders the CSS Calendar region type based on the configuration of
-- the region.
--==============================================================================    
procedure render_css_calendar (
    p_plugin              in wwv_flow_plugin_api.t_plugin,
    p_region              in wwv_flow_plugin_api.t_region,
    p_is_printer_friendly in boolean );

--==============================================================================
-- Returns the CSS Calendar events.
--==============================================================================

procedure ajax_css_calendar (
    p_region              in wwv_flow_plugin_api.t_region );

end wwv_flow_css_calendar;
/
show errors
