set define '^' verify off
prompt ...wwv_flow_exec_web_src_oci.sql
create or replace package wwv_flow_exec_web_src_oci as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999 - 2019. All Rights Reserved.
--
--    NAME
--      wwv_flow_exec_web_src_oci.sql
--
--    DESCRIPTION
--      Web source implementation for Oracle Cloud Infrastructure (OCI) REST Services
--
--
--    MODIFIED   (MM/DD/YYYY)
--    cczarski    07/15/2019 Created
--
--------------------------------------------------------------------------------


c_use_page_size        constant pls_integer := 1000;

--======================================================================================================================
-- returns the capabilities of this OCI REST Service
-- 
-- RETURNS
--     wwv_flow_exec_web_src record structure containing web source capabilities
--======================================================================================================================
function get_capabilities( p_web_src_module_id in number ) return wwv_flow_exec_api.t_source_capabilities;

--======================================================================================================================
-- Invokes a GET COLLECTION REST request on an ORDS REST service. This procedure executes the HTTP request and 
-- retrieves the response data as a CLOB. p_context.web_source_result is populated with response data.
-- 
-- PARAMETERS
--     p_context              IN     context object with execution details
--     p_web_source_operation IN     web source operation details (to look up the data profile) 
--======================================================================================================================
procedure invoke_query(
    p_context              in out nocopy wwv_flow_exec.t_context,
    p_web_source_operation in            wwv_flow_exec_web_src.t_web_source_operation,
    p_response_clob        in out nocopy clob );

procedure invoke_query(
    p_context              in out nocopy wwv_flow_exec.t_context,
    p_web_source_operation in            wwv_flow_exec_web_src.t_web_source_operation,
    p_result_array         in out nocopy wwv_flow_t_clob );

end wwv_flow_exec_web_src_oci;
/
show err

set define '^'
