set define '^' verify off
prompt ...wwv_flow_exec_web_src_ords.sql
create or replace package wwv_flow_exec_web_src_ords as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999 - 2017. All Rights Reserved.
--
--    NAME
--      wwv_flow_exec_web_src_ords.sql
--
--    DESCRIPTION
--      Web source implementation for ORDS REST Services
--
--
--    MODIFIED   (MM/DD/YYYY)
--    cczarski    03/14/2017 - Created
--    cczarski    09/04/2017 - added "fetch all rows" functionality; code improvements
--    cczarski    09/28/2017 - Moved wwv_flow_exec_api.t_context to wwv_flow_exec
--    cczarski    11/29/2018 - added Read/Write support for REST and REST Enabled SQL and Form support (feature #2374,#2376)
--
--------------------------------------------------------------------------------

--======================================================================================================================
-- returns the capabilities of this ORDS REST Services
-- 
-- RETURNS
--     wwv_flow_exec_web_src record structure containing web source capabilities
--======================================================================================================================
function get_capabilities( p_web_src_module_id in number ) return wwv_flow_exec_api.t_source_capabilities;

--======================================================================================================================
-- converts wwv_flow_exec_api.t_filters (contains component filters) to ORDS JSON filter syntax
-- 
-- PARAMETERS
--     p_filters                 IN context object with execution details
--
-- RETURNS
--     ORDS filter syntax (JSON format) which represents the component filters
--======================================================================================================================
function generate_json_filter(
    p_filters              in wwv_flow_exec_api.t_filters,
    p_web_source_operation in wwv_flow_exec_web_src.t_web_source_operation,
    p_filter_local         in boolean default false
) return varchar2;

--======================================================================================================================
-- converts wwv_flow_exec_api.t_order_bys array to ORDS JSON syntax
-- 
-- PARAMETERS
--     p_order_bys                 IN array of ORDER BYs to convert
--
-- RETURNS
--     ORDS order by syntax (JSON format) which represents the component order bys
--======================================================================================================================
function generate_json_orderby(
    p_order_bys            in wwv_flow_exec_api.t_order_bys,
    p_web_source_operation in wwv_flow_exec_web_src.t_web_source_operation
) return varchar2;

--======================================================================================================================
-- Invokes a GET COLLECTION REST request on an ORDS REST service. This procedure executes the HTTP request and 
-- retrieves the response data as a CLOB. p_context.web_source_result is populated with response data.
-- 
-- PARAMETERS
--     p_context                    context object with execution details
--     p_web_source_operation       web source operation details (to look up the data profile) 
--======================================================================================================================
procedure invoke_query(
    p_context              in out nocopy wwv_flow_exec.t_context,
    p_first_row            in            pls_integer default null,
    p_max_rows             in            pls_integer default null,
    p_web_source_operation in            wwv_flow_exec_web_src.t_web_source_operation,
    p_first_page           in            boolean default true,
    p_response_clob        in out nocopy clob );

procedure invoke_query(
    p_context              in out nocopy wwv_flow_exec.t_context,
    p_web_source_operation in            wwv_flow_exec_web_src.t_web_source_operation,
    p_result_array         in out nocopy wwv_flow_t_clob );


--======================================================================================================================
-- Performs DML execution for a given row within the context object on an ORDS web source. 
--
-- PARAMETERS
--     p_context                    context object with execution details
--     p_operation                  web source operation to be executed (POST, PUT, DELETE)
--     p_row_idx                    index of the row within the context object to perform the DML operation for
--     
--     p_response_clob              JSON response to be passed back to the caller
--     p_parse_context              parse context to use in order to parse the JSON response
--======================================================================================================================
function execute_dml (
    p_context                    in out nocopy wwv_flow_exec.t_context,
    p_operation                  in            wwv_flow_exec_web_src.t_web_source_operation,
    p_row_idx                    in            pls_integer,
    --
    p_response_clob              in out nocopy clob,
    p_parse_context              in out nocopy wwv_flow_exec.t_context ) return boolean;

end wwv_flow_exec_web_src_ords;
/
show err

set define '^'
