set define '^' verify off
prompt ...wwv_flow_faceted_search_dev.sql
create or replace package wwv_flow_faceted_search_dev as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999 - 2019. All Rights Reserved.
--
--    NAME
--      wwv_flow_faceted_search_dev.sql
--
--    DESCRIPTION
--      Builder-specific procedures for faceted search regions
--
--    MODIFIED   (MM/DD/YYYY)
--    cbcho       05/28/2019 - created (feature #2416)
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Public type definitions
--------------------------------------------------------------------------------
subtype t_result_region_type is pls_integer range 1..2;
--------------------------------------------------------------------------------
-- Public constant definitions
--------------------------------------------------------------------------------
c_result_region_classic       constant t_result_region_type := 1;
c_result_region_card          constant t_result_region_type := 2;

c_report_max_row_count        constant pls_integer  := 100000;
c_no_of_buckets               constant pls_integer  := 5;           -- Number of buckets for range item types

--======================================================================================================================
-- returns date columns types, to ignore for 19.2
--======================================================================================================================
function get_date_col_types return wwv_flow_t_varchar2;
--======================================================================================================================
-- gets all the facet column names
--======================================================================================================================
function get_facet_column_names(
    p_table_owner    in varchar2 default null,
    p_table_name     in varchar2 default null ) return wwv_flow_t_varchar2;
--======================================================================================================================
-- gets the top 5 scored columns
--======================================================================================================================
function get_top5_facet_columns(
    p_table_owner    in varchar2,
    p_table_name     in varchar2 ) return wwv_flow_t_varchar2;
--======================================================================================================================
-- checks if the report source has searchable columns or columns to create facets
-- if neither exist, cannot create faceted search
--======================================================================================================================
function valid_faceted_search_source(
    p_parse_as_schema      in varchar2,
    p_location             in wwv_flow_exec_api.t_location    default wwv_flow_exec_api.c_location_local_db,
    p_query_type           in wwv_flow_exec_api.t_query_type, 
    p_table_owner          in varchar2                        default null,
    p_table_name           in varchar2                        default null,
    p_table_where          in varchar2                        default null,
    p_table_order_by       in varchar2                        default null,
    p_sql_plsql_source     in varchar2                        default null,
    --
    p_remote_server_id     in number                          default null,
    p_web_source_module_id in number                          default null,
    --
    p_facet_columns        in wwv_flow_t_varchar2             default null,
    p_searchable_columns   in varchar2                        default null,
    p_report_columns       in wwv_flow_t_varchar2             default null  ) return boolean;

--======================================================================================================================
-- creates a faceted search region on an existing page
--======================================================================================================================
procedure create_faceted_search_region(
    p_flow_id                   in number,
    p_result_region_type        in t_result_region_type                default c_result_region_classic,
    p_page_id                   in number,
    p_page_mode                 in varchar2,
    p_form_page_id              in number                              default null,
    --
    p_user_interface_id         in number                              default null,
    p_use_ui_default            in boolean                             default false,
    --
    p_location                  in wwv_flow_exec_api.t_location        default wwv_flow_exec_api.c_location_local_db,
    p_query_type                in wwv_flow_exec_api.t_query_type,    
    p_table_owner               in varchar2                            default null,
    p_table_name                in varchar2                            default null,
    p_table_where               in varchar2                            default null,
    p_table_order_by            in varchar2                            default null,
    p_sql_plsql_source          in varchar2                            default null,
    --
    p_remote_server_id          in number                              default null,
    p_web_source_module_id      in number                              default null,
    --
    p_card_record               in wwv_flow_report_dev.t_card_record   default null,
    p_facet_columns             in wwv_flow_t_varchar2                 default null,
    p_primary_key_columns       in wwv_flow_t_varchar2                 default null,
    p_report_columns            in wwv_flow_t_varchar2                 default null,
    --
    p_do_validation             in boolean                             default false );

--======================================================================================================================
-- creates a report page with faceted search controls
--======================================================================================================================
procedure create_faceted_search_page(
    p_flow_id                    in number,
    p_result_region_type         in t_result_region_type                default c_result_region_classic,
    p_page_id                    in number,
    p_page_name                  in varchar2,
    p_page_mode                  in varchar2,
    p_form_page_id               in number                              default null,
    p_user_interface_id          in number,
    p_use_ui_default             in boolean                             default false,
    --
    p_tab_set                    in varchar2                            default null,
    p_tab_name                   in varchar2                            default null,
    p_tab_text                   in varchar2                            default null,
    --
    p_nav_list_id                in number                              default null,
    p_nav_list_item_id           in number                              default null,
    p_nav_list_item_name         in varchar2                            default null,
    p_nav_list_parent_item_id    in number                              default null,
    p_nav_list_child_item_name   in varchar2                            default null,
    --
    p_breadcrumb_id              in number                              default null,
    p_breadcrumb_entry_name      in varchar2                            default null,
    p_parent_breadcrumb_entry_id in number                              default null,
    --
    p_location                   in wwv_flow_exec_api.t_location        default wwv_flow_exec_api.c_location_local_db,
    p_query_type                 in wwv_flow_exec_api.t_query_type,
    p_table_owner                in varchar2                            default null,
    p_table_name                 in varchar2                            default null,
    p_table_where                in varchar2                            default null,
    p_table_order_by             in varchar2                            default null,
    p_sql_plsql_source           in varchar2                            default null,
    --
    p_remote_server_id           in number                              default null,
    p_web_source_module_id       in number                              default null,
    --
    p_card_record                in wwv_flow_report_dev.t_card_record   default null,
    p_facet_columns              in wwv_flow_t_varchar2                 default null,
    p_primary_key_columns        in wwv_flow_t_varchar2                 default null,
    p_report_columns             in wwv_flow_t_varchar2                 default null,
    --
    p_do_validation              in boolean                             default false );

--======================================================================================================================
-- Returns default buckets for a numeric column based on min max values
--======================================================================================================================
function get_buckets (
    p_min_value     in number,
    p_max_value     in number,
    p_no_of_buckets in number default c_no_of_buckets,
    p_format_mask   in varchar2 default '999G999G999G999G999G999G999G999G999G990' ) return wwv_flow_exec_api.t_filter_buckets;

--======================================================================================================================
-- Returns default buckets for a numeric column based on column stats
--======================================================================================================================
function get_buckets(
    p_schema_name   in varchar2,
    p_table_name    in varchar2,
    p_column_name   in varchar2,
    p_sample_size   in number default c_report_max_row_count,
    p_no_of_buckets in number default c_no_of_buckets,
    p_format_mask   in varchar2 default '999G999G999G999G999G999G999G999G999G990' ) return wwv_flow_exec_api.t_filter_buckets;

--======================================================================================================================
-- Returns buckets as static LOV definition (Display1;Min1|Max1,Display2;Min2|Max2)
--======================================================================================================================
function to_static_lov (
    p_buckets   in wwv_flow_exec_api.t_filter_buckets ) return varchar2;

end wwv_flow_faceted_search_dev;
/
show err

set define '^'

