set define '^' verify off
prompt ...wwv_flow_lov_api
create or replace package wwv_flow_lov_api authid current_user as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2009 - 2019. All Rights Reserved.
--
--    NAME
--      wwv_flow_lov_api.sql
--
--    DESCRIPTION
--      Public API for LOV related functions
--
--    MODIFIED   (MM/DD/YYYY)
--    cczarski    04/04/2019 - Created
--
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Public type definitions
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Public constant definitions
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Global variables
--------------------------------------------------------------------------------


--======================================================================================================================
-- Function used by IG to split up a multi value string into a wwv_flow_t_temp_lov_data for further processing.
--
-- PARAMETERS
--     p_values       String with values, separated by ":"
--
-- RETURNS
--     array of LOV values as instance of wwv_flow_t_temp_lov_data type
--======================================================================================================================
function get_multi_value_lov_data ( p_values in varchar2 ) return wwv_flow_t_temp_lov_data;

--======================================================================================================================
-- fetches Display and Return values for a shared LOV based on a remote data source.
--
-- PARAMETERS
--     p_lov_id       Shared LOV ID to fetch data from
--     p_return_value If given, only data for this return value is fetched. 
--
-- RETURNS
--     Display and return values as the wwv_flow_t_temp_lov_data table type.
--======================================================================================================================
function get_remote_lov_data( 
    p_lov_id       in number,
    p_return_value in varchar2 default null ) return wwv_flow_t_temp_lov_data pipelined;

--======================================================================================================================
-- INTERNAL USE ONLY - do not document.
--======================================================================================================================
-- fetches Display and Return values for a static LOV, which has already been pre-processed by wwv_flow_lov.
--
-- PARAMETERS
--     p_lov_cache_idx   Cache Index of a pre-processed static LOV
--
-- RETURNS
--     Display and return values as the wwv_flow_t_temp_lov_data table type.
--======================================================================================================================
function get_static_lov_data( p_lov_cache_idx in pls_integer ) return wwv_flow_t_temp_lov_data;

--
--
end wwv_flow_lov_api;
/
show errors
