set define '^' verify off
prompt ...wwv_flow_report_dev.sql
create or replace package wwv_flow_report_dev as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999 - 2019. All Rights Reserved.
--
--    NAME
--      wwv_flow_report_dev.sql
--
--    DESCRIPTION
--      Builder-specific procedures for handling report (CR, IR, IG) page and region
--
--    MODIFIED   (MM/DD/YYYY)
--    cbcho       08/28/2019 - created
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Public type definitions
--------------------------------------------------------------------------------
subtype t_report_implementation is pls_integer range 1..4;

type t_card_record is record(
    title_column   varchar2(255),
    desc_column    varchar2(255),
    add_txt_column varchar2(255) );

type t_report_column is record(
    name               wwv_flow_worksheet_columns.db_column_name%type,
    label              wwv_flow_worksheet_columns.column_label%type,
    type               wwv_flow_worksheet_columns.column_type%type,
    display_text_as    wwv_flow_worksheet_columns.display_text_as%type,
    display_as         wwv_flow_worksheet_columns.display_as%type,
    item_type          wwv_flow_region_columns.item_type%type,
    --
    lov_id             number,
    --
    format_mask        wwv_flow_worksheet_columns.format_mask%type,
    alignment          wwv_flow_worksheet_columns.column_alignment%type,
    --
    display_order      wwv_flow_worksheet_columns.display_order%type,
    --
    group_id           wwv_flow_worksheet_columns.group_id%type,
    --
    column_link        wwv_flow_worksheet_columns.column_link%type,
    column_linktext    wwv_flow_worksheet_columns.column_linktext%type,
    --
    is_visible         boolean,
    sort_order         number,
    allow_sorting      boolean,
    allow_filtering    boolean,
    allow_highlighting boolean,
    allow_ctrl_breaks  boolean,
    allow_aggregations boolean,
    allow_computations boolean,
    allow_charting     boolean,
    allow_group_by     boolean,
    allow_pivot        boolean,
    allow_hide         boolean,
    include_in_export  boolean,
    tz_dependent       boolean,
    show_filter_lov    char(1),
    --
    help_text          wwv_flow_worksheet_columns.help_text%type,
    --
    descr_column_info  wwv_flow_exec_api.t_column );

type t_report_columns is table of t_report_column index by pls_integer;

type t_column_group is record(
    display_seq        number,
    group_name         varchar2(32767 ) );

type t_column_groups is table of t_column_group index by pls_integer;
--------------------------------------------------------------------------------
-- Public constant definitions
--------------------------------------------------------------------------------
c_report_impl_classic       constant t_report_implementation := 1;
c_report_impl_interactive   constant t_report_implementation := 2;
c_report_impl_listview      constant t_report_implementation := 3;
c_report_impl_ig            constant t_report_implementation := 4;

--======================================================================================================================
-- Creates new shared LOV if [table, display, return values] not found and returns the new ID.
-- If found, returns existing LOV ID.
--======================================================================================================================
function get_shared_lov_id(
    p_app_id               in number,
    p_table_owner          in varchar2,
    p_table_name           in varchar2,
    p_display_column       in varchar2,
    p_return_column        in varchar2 ) return number;

--======================================================================================================================
-- Creates a classic report region
--======================================================================================================================
procedure create_cr_region(
    p_id                    in number                        default null,
    p_app_id                in number,
    p_page_id               in number,
    p_title                 in varchar2,
    p_display_sequence      in number                        default 10,
    p_region_template_id    in number                        default null,
    p_report_template_id    in number                        default null,
    p_new_grid_row          in boolean                       default true,
    p_new_grid_column       in boolean                       default true,
    --
    p_form_page_id          in number                        default null,
    -- 
    p_location              in varchar2                      default wwv_flow_exec_api.c_location_local_db,
    p_query_type            in varchar2                      default wwv_flow_exec_api.c_query_type_sql_query,
    p_web_source_module_id  in number                        default null,
    p_remote_server_id      in number                        default null,
    p_table_owner           in varchar2                      default null,
    p_table_name            in varchar2                      default null,
    p_table_where           in varchar2                      default null,
    p_include_rowid_column  in boolean                       default false,
    p_sql_plsql_source      in varchar2                      default null,
    --
    p_primary_key_columns   in wwv_flow_t_varchar2           default null,
    p_report_columns        in wwv_flow_t_varchar2           default null,
    p_hidden_columns        in wwv_flow_t_varchar2           default null,
    --
    p_csv_output            in boolean                       default false,
    p_csv_output_link_text  in varchar2                      default wwv_flow_lang.system_message( 'DOWNLOAD' ),
    --
    p_max_row_count         in number                        default null,
    -- 
    p_use_dictionary_cache    in boolean                     default false );

--======================================================================================================================
-- Creates a classic report page
--======================================================================================================================
procedure create_cr_page(
    p_app_id                     in number,
    p_page_id                    in number,
    p_page_name                  in varchar2,
    p_group_name                 in varchar2                            default null,
    p_page_mode                  in varchar2,
    p_user_interface_id          in number,
    p_use_ui_default             in varchar2                            default 'Y',
    --
    p_form_page_id               in number                              default null,
    --
    p_tab_set                    in varchar2                            default null,
    p_tab_name                   in varchar2                            default null,
    p_tab_text                   in varchar2                            default null,
    --
    p_nav_list_id                in number                              default null,
    p_nav_list_item_id           in number                              default null,
    p_nav_list_item_name         in varchar2                            default null,
    p_nav_list_parent_item_id    in number                              default null,
    p_nav_list_child_item_name   in varchar2                            default null,
    --
    p_breadcrumb_id              in number                              default null,
    p_breadcrumb_entry_name      in varchar2                            default null,
    p_parent_breadcrumb_entry_id in number                              default null,
    --
    p_region_title               in varchar2,
    p_region_template_id         in number                              default null,
    p_report_template_id         in number                              default null,
    --
    p_location                   in wwv_flow_exec_api.t_location        default wwv_flow_exec_api.c_location_local_db,
    p_query_type                 in wwv_flow_exec_api.t_query_type,
    p_table_owner                in varchar2                            default null,
    p_table_name                 in varchar2                            default null,
    p_table_where                in varchar2                            default null,
    p_sql_plsql_source           in varchar2                            default null,
    --
    p_remote_server_id           in number                              default null,
    p_web_source_module_id       in number                              default null,
    --
    p_primary_key_columns        in wwv_flow_t_varchar2                 default null,
    p_report_columns             in wwv_flow_t_varchar2                 default null,
    p_hidden_columns             in wwv_flow_t_varchar2                 default null,
    --                
    p_csv_output                 in boolean                             default false,
    p_csv_output_link_text       in varchar2                            default wwv_flow_lang.system_message( 'DOWNLOAD' ),
    --                
    p_max_row_count              in number                              default null,
    --            
    p_use_dictionary_cache       in boolean                             default false );

--======================================================================================================================
-- Creates a classic report region using card report template
--======================================================================================================================
procedure create_card_region(
    p_id                      in number                        default null,
    p_app_id                  in number,
    p_page_id                 in number,
    p_title                   in varchar2,
    p_display_sequence        in number                        default 10,
    p_region_template_id      in number                        default null,
    p_report_template_id      in number                        default null,
    p_new_grid_row            in boolean                       default true,
    p_new_grid_column         in boolean                       default true,
    --
    p_form_page_id           in number                         default null,
    --  
    p_location                in varchar2                      default wwv_flow_exec_api.c_location_local_db,
    p_web_source_module_id    in number                        default null,
    p_remote_server_id        in number                        default null,
    p_table_owner             in varchar2                      default null,
    p_table_name              in varchar2                      default null,
    --
    p_primary_key_columns     in wwv_flow_t_varchar2           default null,
    p_card_record             in t_card_record                 default null,
    p_hidden_columns          in wwv_flow_t_varchar2           default null,
    --                
    p_max_row_count           in number                        default null,
    -- 
    p_use_dictionary_cache    in boolean                       default false );

--======================================================================================================================
-- Creates a classic report page using card report template
--======================================================================================================================
procedure create_card_page(
    p_app_id                     in number,
    p_page_id                    in number,
    p_page_name                  in varchar2,
    p_group_name                 in varchar2                            default null,
    p_page_mode                  in varchar2,
    p_user_interface_id          in number,
    p_use_ui_default             in varchar2                            default 'Y',
    --
    p_form_page_id               in number                              default null,
    --
    p_tab_set                    in varchar2                            default null,
    p_tab_name                   in varchar2                            default null,
    p_tab_text                   in varchar2                            default null,
    --
    p_nav_list_id                in number                              default null,
    p_nav_list_item_id           in number                              default null,
    p_nav_list_item_name         in varchar2                            default null,
    p_nav_list_parent_item_id    in number                              default null,
    p_nav_list_child_item_name   in varchar2                            default null,
    --
    p_breadcrumb_id              in number                              default null,
    p_breadcrumb_entry_name      in varchar2                            default null,
    p_parent_breadcrumb_entry_id in number                              default null,
    --
    p_region_title               in varchar2,
    p_region_template_id         in number                              default null,
    p_report_template_id         in number                              default null,
    --
    p_location                   in wwv_flow_exec_api.t_location        default wwv_flow_exec_api.c_location_local_db,
    p_table_owner                in varchar2                            default null,
    p_table_name                 in varchar2                            default null,
    p_table_where                in varchar2                            default null,
    --
    p_remote_server_id           in number                              default null,
    p_web_source_module_id       in number                              default null,
    --
    p_primary_key_columns        in wwv_flow_t_varchar2                 default null,
    p_card_record                in t_card_record                       default null,
    p_hidden_columns             in wwv_flow_t_varchar2                 default null,
    --
    p_max_row_count              in number                              default null,
    --            
    p_use_dictionary_cache       in boolean                             default false );

end wwv_flow_report_dev;
/
show err

set define '^'

