set define '^' verify off
prompt ...wwv_flow_web_src_ords_dev.sql
create or replace package wwv_flow_web_src_ords_dev authid current_user as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999 - 2019. All Rights Reserved.
--
--    NAME
--      wwv_flow_web_src_ords_dev.sql
--
--    DESCRIPTION
--      Web source implementation
--
--
--    MODIFIED   (MM/DD/YYYY)
--    cczarski    05/30/2017 - Created
--    cczarski    09/13/2017 - added support for UTL_HTTP p_https_host argument (ignored pre-12.2)
--    cczarski    11/29/2018 - added Read/Write support for REST and REST Enabled SQL and Form support (feature #2374,#2376)
--    cczarski    12/07/2018 - support "scope" attribute in wwv_credentials for OAuth2 Authentication (bug #29028213)
--
--------------------------------------------------------------------------------


--==============================================================================
-- Global types 
--==============================================================================

--==============================================================================
-- contants
--==============================================================================

--==============================================================================
-- Discovers the data profile for the ORDS service. The procedure will try to
-- follow the "describedBy" link which is part of the REST service response and
-- when that is not sufficient, the web service response will be sampled.
--
-- PARAMETERS
--     p_ords_url_endpoint      URL endpoint of the ORDS service
--     p_auth_scheme            Authentication schema: BASIC, OAUTH, none
--     p_oauth_token_url        Authentication server URL to use for OAuth token retrieval
--     p_client_id              OAuth Client ID or Basic Username
--     p_client_secret          OAuth Client ID or Basic Password
--     p_https_host             HTTPS host to use for SNI (Server Name indication)
--     
--     p_status_code            HTTP status code being passed back to the caller
--     p_pk_url_path            URL to access a row by primary key which has been determined during discovery
--       
--     p_response               JSON response being retrieved during discovery
--     p_data_profile           discovered data profile 
--==============================================================================
procedure discover_data_profile( 
    p_ords_url_endpoint   in            varchar2,
    p_oauth_token_url     in            varchar2 default null,
    p_credential          in            wwv_flow_credential_api.t_credential,
    p_https_host          in            varchar2 default null,
    --
    p_status_code         out           pls_integer,
    p_pk_url_path         out           varchar2,
    --
    p_response            in out nocopy clob,
    p_data_profile        in out nocopy wwv_flow_data_profile.t_data_profile );

--==============================================================================
-- Detects whether the JSON response is the "ORDS Legacy JSON syntax".
--
-- PARAMETERS
--     p_response               JSON response to parse
--     p_is_legacy              true, if the JSON is ORDS Legacy
--     p_page_size              the page size, if we were able to detect
--==============================================================================
procedure detect_legacy_ords(
    p_response            in out nocopy clob,
    p_page_size           out           number,
    p_is_legacy           out           boolean );

--==============================================================================
-- Performs the OPTIONS request in order to fetch the allowed methods on a REST
-- service.
--
-- PARAMETERS
--     p_ords_url_endpoint      URL endpoint of the ORDS instance, end typically with "/ords"
--     p_pk_url_path            URL to access a row by primary key
--     p_auth_scheme            Authentication schema: BASIC, OAUTH, none
--     p_oauth_token_url        Authentication server URL to use for OAuth token retrieval
--     p_https_host             HTTPS host to use for SNI (Server Name indication)
--     p_client_id              OAuth Client ID or Basic Username
--     p_client_secret          OAuth Client ID or Basic Password
--
--     p_collection_name        name of the collection to populate
--
-- RETURNS
--     true if a metadata catalog exists, false otherwise
--==============================================================================
procedure fetch_available_methods(
    p_ords_url_endpoint   in varchar2,
    p_pk_url_path         in varchar2 default null,
    p_oauth_token_url     in varchar2 default null,
    p_https_host          in varchar2 default null,
    p_credential          in wwv_flow_credential_api.t_credential,
    --
    p_collection_name     in varchar2 ); 


end wwv_flow_web_src_ords_dev;
/
show err

set define '^'

