set define '^' verify off
create or replace package wwv_flow_id as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
--
--    DESCRIPTION
--      Unique id generation utility
--
--    SECURITY
--     Publicly executable
--
--    NOTES
--      This package generates sequence numbers which
--      are, for all practial purposes, globally unique.
--      This assumes the following: "create sequence wwv_seq"
--
--    MODIFIED   (MM/DD/YYYY)
--      mhichwa   08/04/1999 - Created
--      mhichwa   02/22/2000 - Changed name to wwv_flow_id
--      mhichwa   03/01/2001 - enhanced uniqueness
--      sdillon   03/05/2001 - changed dbms_random.random to wwv_flow_random.rand
--      mhichwa   07/23/2001 - Added grant on wwv seq to public
--      jkallman  02/26/2014 - Changed cache to 100
--
--------------------------------------------------------------------------------

function curr_val return number;
pragma restrict_references( curr_val, wnds, rnds, wnps );

function next_val return number;

end wwv_flow_id;
/
show errors
