(function( $, undefined ) {

var uid = 0,
    hideProps = {},
    showProps = {};

hideProps.height = hideProps.paddingTop = hideProps.paddingBottom =
    hideProps.borderTopWidth = hideProps.borderBottomWidth = "hide";
showProps.height = showProps.paddingTop = showProps.paddingBottom =
    showProps.borderTopWidth = showProps.borderBottomWidth = "show";

$.widget( "ui.accordion", {
    version: "1.10.4",
    options: {
        active: 0,
        animate: {},
        collapsible: false,
        event: "click",
        header: "> li > :first-child,> :not(li):even",
        heightStyle: "auto",
        icons: {
            activeHeader: "ui-icon-triangle-1-s",
            header: "ui-icon-triangle-1-e"
        },

        // callbacks
        activate: null,
        beforeActivate: null
    },

    _create: function() {
        var options = this.options;
        this.prevShow = this.prevHide = $();
        this.element.addClass( "ui-accordion ui-widget ui-helper-reset" )
            // ARIA
            .attr( "role", "tablist" );

        // don't allow collapsible: false and active: false / null
        if ( !options.collapsible && (options.active === false || options.active == null) ) {
            options.active = 0;
        }

        this._processPanels();
        // handle negative values
        if ( options.active < 0 ) {
            options.active += this.headers.length;
        }
        this._refresh();
    },

    _getCreateEventData: function() {
        return {
            header: this.active,
            panel: !this.active.length ? $() : this.active.next(),
            content: !this.active.length ? $() : this.active.next()
        };
    },

    _createIcons: function() {
        var icons = this.options.icons;
        if ( icons ) {
            $( "<span>" )
                .addClass( "ui-accordion-header-icon ui-icon " + icons.header )
                .prependTo( this.headers );
            this.active.children( ".ui-accordion-header-icon" )
                .removeClass( icons.header )
                .addClass( icons.activeHeader );
            this.headers.addClass( "ui-accordion-icons" );
        }
    },

    _destroyIcons: function() {
        this.headers
            .removeClass( "ui-accordion-icons" )
            .children( ".ui-accordion-header-icon" )
                .remove();
    },

    _destroy: function() {
        var contents;

        // clean up main element
        this.element
            .removeClass( "ui-accordion ui-widget ui-helper-reset" )
            .removeAttr( "role" );

        // clean up headers
        this.headers
            .removeClass( "ui-accordion-header ui-accordion-header-active ui-helper-reset ui-state-default ui-corner-all ui-state-active ui-state-disabled ui-corner-top" )
            .removeAttr( "role" )
            .removeAttr( "aria-expanded" )
            .removeAttr( "aria-selected" )
            .removeAttr( "aria-controls" )
            .removeAttr( "tabIndex" )
            .each(function() {
                if ( /^ui-accordion/.test( this.id ) ) {
                    this.removeAttribute( "id" );
                }
            });
        this._destroyIcons();

        // clean up content panels
        contents = this.headers.next()
            .css( "display", "" )
            .removeAttr( "role" )
            .removeAttr( "aria-hidden" )
            .removeAttr( "aria-labelledby" )
            .removeClass( "ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active ui-state-disabled" )
            .each(function() {
                if ( /^ui-accordion/.test( this.id ) ) {
                    this.removeAttribute( "id" );
                }
            });
        if ( this.options.heightStyle !== "content" ) {
            contents.css( "height", "" );
        }
    },

    _setOption: function( key, value ) {
        if ( key === "active" ) {
            // _activate() will handle invalid values and update this.options
            this._activate( value );
            return;
        }

        if ( key === "event" ) {
            if ( this.options.event ) {
                this._off( this.headers, this.options.event );
            }
            this._setupEvents( value );
        }

        this._super( key, value );

        // setting collapsible: false while collapsed; open first panel
        if ( key === "collapsible" && !value && this.options.active === false ) {
            this._activate( 0 );
        }

        if ( key === "icons" ) {
            this._destroyIcons();
            if ( value ) {
                this._createIcons();
            }
        }

        // #5332 - opacity doesn't cascade to positioned elements in IE
        // so we need to add the disabled class to the headers and panels
        if ( key === "disabled" ) {
            this.headers.add( this.headers.next() )
                .toggleClass( "ui-state-disabled", !!value );
        }
    },

    _keydown: function( event ) {
        if ( event.altKey || event.ctrlKey ) {
            return;
        }

        var keyCode = $.ui.keyCode,
            length = this.headers.length,
            currentIndex = this.headers.index( event.target ),
            toFocus = false;

        switch ( event.keyCode ) {
            case keyCode.RIGHT:
            case keyCode.DOWN:
                toFocus = this.headers[ ( currentIndex + 1 ) % length ];
                break;
            case keyCode.LEFT:
            case keyCode.UP:
                toFocus = this.headers[ ( currentIndex - 1 + length ) % length ];
                break;
            case keyCode.SPACE:
            case keyCode.ENTER:
                this._eventHandler( event );
                break;
            case keyCode.HOME:
                toFocus = this.headers[ 0 ];
                break;
            case keyCode.END:
                toFocus = this.headers[ length - 1 ];
                break;
        }

        if ( toFocus ) {
            $( event.target ).attr( "tabIndex", -1 );
            $( toFocus ).attr( "tabIndex", 0 );
            toFocus.focus();
            event.preventDefault();
        }
    },

    _panelKeyDown : function( event ) {
        if ( event.keyCode === $.ui.keyCode.UP && event.ctrlKey ) {
            $( event.currentTarget ).prev().focus();
        }
    },

    refresh: function() {
        var options = this.options;
        this._processPanels();

        // was collapsed or no panel
        if ( ( options.active === false && options.collapsible === true ) || !this.headers.length ) {
            options.active = false;
            this.active = $();
        // active false only when collapsible is true
        } else if ( options.active === false ) {
            this._activate( 0 );
        // was active, but active panel is gone
        } else if ( this.active.length && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {
            // all remaining panel are disabled
            if ( this.headers.length === this.headers.find(".ui-state-disabled").length ) {
                options.active = false;
                this.active = $();
            // activate previous panel
            } else {
                this._activate( Math.max( 0, options.active - 1 ) );
            }
        // was active, active panel still exists
        } else {
            // make sure active index is correct
            options.active = this.headers.index( this.active );
        }

        this._destroyIcons();

        this._refresh();
    },

    _processPanels: function() {
        this.headers = this.element.find( this.options.header )
            .addClass( "ui-accordion-header ui-helper-reset ui-state-default ui-corner-all" );

        this.headers.next()
            .addClass( "ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom" )
            .filter(":not(.ui-accordion-content-active)")
            .hide();
    },

    _refresh: function() {
        var maxHeight,
            options = this.options,
            heightStyle = options.heightStyle,
            parent = this.element.parent(),
            accordionId = this.accordionId = "ui-accordion-" +
                (this.element.attr( "id" ) || ++uid);

        this.active = this._findActive( options.active )
            .addClass( "ui-accordion-header-active ui-state-active ui-corner-top" )
            .removeClass( "ui-corner-all" );
        this.active.next()
            .addClass( "ui-accordion-content-active" )
            .show();

        this.headers
            .attr( "role", "tab" )
            .each(function( i ) {
                var header = $( this ),
                    headerId = header.attr( "id" ),
                    panel = header.next(),
                    panelId = panel.attr( "id" );
                if ( !headerId ) {
                    headerId = accordionId + "-header-" + i;
                    header.attr( "id", headerId );
                }
                if ( !panelId ) {
                    panelId = accordionId + "-panel-" + i;
                    panel.attr( "id", panelId );
                }
                header.attr( "aria-controls", panelId );
                panel.attr( "aria-labelledby", headerId );
            })
            .next()
                .attr( "role", "tabpanel" );

        this.headers
            .not( this.active )
            .attr({
                "aria-selected": "false",
                "aria-expanded": "false",
                tabIndex: -1
            })
            .next()
                .attr({
                    "aria-hidden": "true"
                })
                .hide();

        // make sure at least one header is in the tab order
        if ( !this.active.length ) {
            this.headers.eq( 0 ).attr( "tabIndex", 0 );
        } else {
            this.active.attr({
                "aria-selected": "true",
                "aria-expanded": "true",
                tabIndex: 0
            })
            .next()
                .attr({
                    "aria-hidden": "false"
                });
        }

        this._createIcons();

        this._setupEvents( options.event );

        if ( heightStyle === "fill" ) {
            maxHeight = parent.height();
            this.element.siblings( ":visible" ).each(function() {
                var elem = $( this ),
                    position = elem.css( "position" );

                if ( position === "absolute" || position === "fixed" ) {
                    return;
                }
                maxHeight -= elem.outerHeight( true );
            });

            this.headers.each(function() {
                maxHeight -= $( this ).outerHeight( true );
            });

            this.headers.next()
                .each(function() {
                    $( this ).height( Math.max( 0, maxHeight -
                        $( this ).innerHeight() + $( this ).height() ) );
                })
                .css( "overflow", "auto" );
        } else if ( heightStyle === "auto" ) {
            maxHeight = 0;
            this.headers.next()
                .each(function() {
                    maxHeight = Math.max( maxHeight, $( this ).css( "height", "" ).height() );
                })
                .height( maxHeight );
        }
    },

    _activate: function( index ) {
        var active = this._findActive( index )[ 0 ];

        // trying to activate the already active panel
        if ( active === this.active[ 0 ] ) {
            return;
        }

        // trying to collapse, simulate a click on the currently active header
        active = active || this.active[ 0 ];

        this._eventHandler({
            target: active,
            currentTarget: active,
            preventDefault: $.noop
        });
    },

    _findActive: function( selector ) {
        return typeof selector === "number" ? this.headers.eq( selector ) : $();
    },

    _setupEvents: function( event ) {
        var events = {
            keydown: "_keydown"
        };
        if ( event ) {
            $.each( event.split(" "), function( index, eventName ) {
                events[ eventName ] = "_eventHandler";
            });
        }

        this._off( this.headers.add( this.headers.next() ) );
        this._on( this.headers, events );
        this._on( this.headers.next(), { keydown: "_panelKeyDown" });
        this._hoverable( this.headers );
        this._focusable( this.headers );
    },

    _eventHandler: function( event ) {
        var options = this.options,
            active = this.active,
            clicked = $( event.currentTarget ),
            clickedIsActive = clicked[ 0 ] === active[ 0 ],
            collapsing = clickedIsActive && options.collapsible,
            toShow = collapsing ? $() : clicked.next(),
            toHide = active.next(),
            eventData = {
                oldHeader: active,
                oldPanel: toHide,
                newHeader: collapsing ? $() : clicked,
                newPanel: toShow
            };

        event.preventDefault();

        if (
                // click on active header, but not collapsible
                ( clickedIsActive && !options.collapsible ) ||
                // allow canceling activation
                ( this._trigger( "beforeActivate", event, eventData ) === false ) ) {
            return;
        }

        options.active = collapsing ? false : this.headers.index( clicked );

        // when the call to ._toggle() comes after the class changes
        // it causes a very odd bug in IE 8 (see #6720)
        this.active = clickedIsActive ? $() : clicked;
        this._toggle( eventData );

        // switch classes
        // corner classes on the previously active header stay after the animation
        active.removeClass( "ui-accordion-header-active ui-state-active" );
        if ( options.icons ) {
            active.children( ".ui-accordion-header-icon" )
                .removeClass( options.icons.activeHeader )
                .addClass( options.icons.header );
        }

        if ( !clickedIsActive ) {
            clicked
                .removeClass( "ui-corner-all" )
                .addClass( "ui-accordion-header-active ui-state-active ui-corner-top" );
            if ( options.icons ) {
                clicked.children( ".ui-accordion-header-icon" )
                    .removeClass( options.icons.header )
                    .addClass( options.icons.activeHeader );
            }

            clicked
                .next()
                .addClass( "ui-accordion-content-active" );
        }
    },

    _toggle: function( data ) {
        var toShow = data.newPanel,
            toHide = this.prevShow.length ? this.prevShow : data.oldPanel;

        // handle activating a panel during the animation for another activation
        this.prevShow.add( this.prevHide ).stop( true, true );
        this.prevShow = toShow;
        this.prevHide = toHide;

        if ( this.options.animate ) {
            this._animate( toShow, toHide, data );
        } else {
            toHide.hide();
            toShow.show();
            this._toggleComplete( data );
        }

        toHide.attr({
            "aria-hidden": "true"
        });
        toHide.prev().attr( "aria-selected", "false" );
        // if we're switching panels, remove the old header from the tab order
        // if we're opening from collapsed state, remove the previous header from the tab order
        // if we're collapsing, then keep the collapsing header in the tab order
        if ( toShow.length && toHide.length ) {
            toHide.prev().attr({
                "tabIndex": -1,
                "aria-expanded": "false"
            });
        } else if ( toShow.length ) {
            this.headers.filter(function() {
                return $( this ).attr( "tabIndex" ) === 0;
            })
            .attr( "tabIndex", -1 );
        }

        toShow
            .attr( "aria-hidden", "false" )
            .prev()
                .attr({
                    "aria-selected": "true",
                    tabIndex: 0,
                    "aria-expanded": "true"
                });
    },

    _animate: function( toShow, toHide, data ) {
        var total, easing, duration,
            that = this,
            adjust = 0,
            down = toShow.length &&
                ( !toHide.length || ( toShow.index() < toHide.index() ) ),
            animate = this.options.animate || {},
            options = down && animate.down || animate,
            complete = function() {
                that._toggleComplete( data );
            };

        if ( typeof options === "number" ) {
            duration = options;
        }
        if ( typeof options === "string" ) {
            easing = options;
        }
        // fall back from options to animation in case of partial down settings
        easing = easing || options.easing || animate.easing;
        duration = duration || options.duration || animate.duration;

        if ( !toHide.length ) {
            return toShow.animate( showProps, duration, easing, complete );
        }
        if ( !toShow.length ) {
            return toHide.animate( hideProps, duration, easing, complete );
        }

        total = toShow.show().outerHeight();
        toHide.animate( hideProps, {
            duration: duration,
            easing: easing,
            step: function( now, fx ) {
                fx.now = Math.round( now );
            }
        });
        toShow
            .hide()
            .animate( showProps, {
                duration: duration,
                easing: easing,
                complete: complete,
                step: function( now, fx ) {
                    fx.now = Math.round( now );
                    if ( fx.prop !== "height" ) {
                        adjust += fx.now;
                    } else if ( that.options.heightStyle !== "content" ) {
                        fx.now = Math.round( total - toHide.outerHeight() - adjust );
                        adjust = 0;
                    }
                }
            });
    },

    _toggleComplete: function( data ) {
        var toHide = data.oldPanel;

        toHide
            .removeClass( "ui-accordion-content-active" )
            .prev()
                .removeClass( "ui-corner-top" )
                .addClass( "ui-corner-all" );

        // Work around for rendering bug in IE (#5421)
        if ( toHide.length ) {
            toHide.parent()[0].className = toHide.parent()[0].className;
        }
        this._trigger( "activate", null, data );
    }
});

})( jQuery );
(function( $, undefined ) {

// number of pages in a slider
// (how many times can you page up/down to go through the whole range)
var numPages = 5;

$.widget( "ui.slider", $.ui.mouse, {
    version: "1.10.4",
    widgetEventPrefix: "slide",

    options: {
        animate: false,
        distance: 0,
        max: 100,
        min: 0,
        orientation: "horizontal",
        range: false,
        step: 1,
        value: 0,
        values: null,

        // callbacks
        change: null,
        slide: null,
        start: null,
        stop: null
    },

    _create: function() {
        this._keySliding = false;
        this._mouseSliding = false;
        this._animateOff = true;
        this._handleIndex = null;
        this._detectOrientation();
        this._mouseInit();

        this.element
            .addClass( "ui-slider" +
                " ui-slider-" + this.orientation +
                " ui-widget" +
                " ui-widget-content" +
                " ui-corner-all");

        this._refresh();
        this._setOption( "disabled", this.options.disabled );

        this._animateOff = false;
    },

    _refresh: function() {
        this._createRange();
        this._createHandles();
        this._setupEvents();
        this._refreshValue();
    },

    _createHandles: function() {
        var i, handleCount,
            options = this.options,
            existingHandles = this.element.find( ".ui-slider-handle" ).addClass( "ui-state-default ui-corner-all" ),
            handle = "<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>",
            handles = [];

        handleCount = ( options.values && options.values.length ) || 1;

        if ( existingHandles.length > handleCount ) {
            existingHandles.slice( handleCount ).remove();
            existingHandles = existingHandles.slice( 0, handleCount );
        }

        for ( i = existingHandles.length; i < handleCount; i++ ) {
            handles.push( handle );
        }

        this.handles = existingHandles.add( $( handles.join( "" ) ).appendTo( this.element ) );

        this.handle = this.handles.eq( 0 );

        this.handles.each(function( i ) {
            $( this ).data( "ui-slider-handle-index", i );
        });
    },

    _createRange: function() {
        var options = this.options,
            classes = "";

        if ( options.range ) {
            if ( options.range === true ) {
                if ( !options.values ) {
                    options.values = [ this._valueMin(), this._valueMin() ];
                } else if ( options.values.length && options.values.length !== 2 ) {
                    options.values = [ options.values[0], options.values[0] ];
                } else if ( $.isArray( options.values ) ) {
                    options.values = options.values.slice(0);
                }
            }

            if ( !this.range || !this.range.length ) {
                this.range = $( "<div></div>" )
                    .appendTo( this.element );

                classes = "ui-slider-range" +
                // note: this isn't the most fittingly semantic framework class for this element,
                // but worked best visually with a variety of themes
                " ui-widget-header ui-corner-all";
            } else {
                this.range.removeClass( "ui-slider-range-min ui-slider-range-max" )
                    // Handle range switching from true to min/max
                    .css({
                        "left": "",
                        "bottom": ""
                    });
            }

            this.range.addClass( classes +
                ( ( options.range === "min" || options.range === "max" ) ? " ui-slider-range-" + options.range : "" ) );
        } else {
            if ( this.range ) {
                this.range.remove();
            }
            this.range = null;
        }
    },

    _setupEvents: function() {
        var elements = this.handles.add( this.range ).filter( "a" );
        this._off( elements );
        this._on( elements, this._handleEvents );
        this._hoverable( elements );
        this._focusable( elements );
    },

    _destroy: function() {
        this.handles.remove();
        if ( this.range ) {
            this.range.remove();
        }

        this.element
            .removeClass( "ui-slider" +
                " ui-slider-horizontal" +
                " ui-slider-vertical" +
                " ui-widget" +
                " ui-widget-content" +
                " ui-corner-all" );

        this._mouseDestroy();
    },

    _mouseCapture: function( event ) {
        var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,
            that = this,
            o = this.options;

        if ( o.disabled ) {
            return false;
        }

        this.elementSize = {
            width: this.element.outerWidth(),
            height: this.element.outerHeight()
        };
        this.elementOffset = this.element.offset();

        position = { x: event.pageX, y: event.pageY };
        normValue = this._normValueFromMouse( position );
        distance = this._valueMax() - this._valueMin() + 1;
        this.handles.each(function( i ) {
            var thisDistance = Math.abs( normValue - that.values(i) );
            if (( distance > thisDistance ) ||
                ( distance === thisDistance &&
                    (i === that._lastChangedValue || that.values(i) === o.min ))) {
                distance = thisDistance;
                closestHandle = $( this );
                index = i;
            }
        });

        allowed = this._start( event, index );
        if ( allowed === false ) {
            return false;
        }
        this._mouseSliding = true;

        this._handleIndex = index;

        closestHandle
            .addClass( "ui-state-active" )
            .focus();

        offset = closestHandle.offset();
        mouseOverHandle = !$( event.target ).parents().addBack().is( ".ui-slider-handle" );
        this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {
            left: event.pageX - offset.left - ( closestHandle.width() / 2 ),
            top: event.pageY - offset.top -
                ( closestHandle.height() / 2 ) -
                ( parseInt( closestHandle.css("borderTopWidth"), 10 ) || 0 ) -
                ( parseInt( closestHandle.css("borderBottomWidth"), 10 ) || 0) +
                ( parseInt( closestHandle.css("marginTop"), 10 ) || 0)
        };

        if ( !this.handles.hasClass( "ui-state-hover" ) ) {
            this._slide( event, index, normValue );
        }
        this._animateOff = true;
        return true;
    },

    _mouseStart: function() {
        return true;
    },

    _mouseDrag: function( event ) {
        var position = { x: event.pageX, y: event.pageY },
            normValue = this._normValueFromMouse( position );

        this._slide( event, this._handleIndex, normValue );

        return false;
    },

    _mouseStop: function( event ) {
        this.handles.removeClass( "ui-state-active" );
        this._mouseSliding = false;

        this._stop( event, this._handleIndex );
        this._change( event, this._handleIndex );

        this._handleIndex = null;
        this._clickOffset = null;
        this._animateOff = false;

        return false;
    },

    _detectOrientation: function() {
        this.orientation = ( this.options.orientation === "vertical" ) ? "vertical" : "horizontal";
    },

    _normValueFromMouse: function( position ) {
        var pixelTotal,
            pixelMouse,
            percentMouse,
            valueTotal,
            valueMouse;

        if ( this.orientation === "horizontal" ) {
            pixelTotal = this.elementSize.width;
            pixelMouse = position.x - this.elementOffset.left - ( this._clickOffset ? this._clickOffset.left : 0 );
        } else {
            pixelTotal = this.elementSize.height;
            pixelMouse = position.y - this.elementOffset.top - ( this._clickOffset ? this._clickOffset.top : 0 );
        }

        percentMouse = ( pixelMouse / pixelTotal );
        if ( percentMouse > 1 ) {
            percentMouse = 1;
        }
        if ( percentMouse < 0 ) {
            percentMouse = 0;
        }
        if ( this.orientation === "vertical" ) {
            percentMouse = 1 - percentMouse;
        }

        valueTotal = this._valueMax() - this._valueMin();
        valueMouse = this._valueMin() + percentMouse * valueTotal;

        return this._trimAlignValue( valueMouse );
    },

    _start: function( event, index ) {
        var uiHash = {
            handle: this.handles[ index ],
            value: this.value()
        };
        if ( this.options.values && this.options.values.length ) {
            uiHash.value = this.values( index );
            uiHash.values = this.values();
        }
        return this._trigger( "start", event, uiHash );
    },

    _slide: function( event, index, newVal ) {
        var otherVal,
            newValues,
            allowed;

        if ( this.options.values && this.options.values.length ) {
            otherVal = this.values( index ? 0 : 1 );

            if ( ( this.options.values.length === 2 && this.options.range === true ) &&
                    ( ( index === 0 && newVal > otherVal) || ( index === 1 && newVal < otherVal ) )
                ) {
                newVal = otherVal;
            }

            if ( newVal !== this.values( index ) ) {
                newValues = this.values();
                newValues[ index ] = newVal;
                // A slide can be canceled by returning false from the slide callback
                allowed = this._trigger( "slide", event, {
                    handle: this.handles[ index ],
                    value: newVal,
                    values: newValues
                } );
                otherVal = this.values( index ? 0 : 1 );
                if ( allowed !== false ) {
                    this.values( index, newVal );
                }
            }
        } else {
            if ( newVal !== this.value() ) {
                // A slide can be canceled by returning false from the slide callback
                allowed = this._trigger( "slide", event, {
                    handle: this.handles[ index ],
                    value: newVal
                } );
                if ( allowed !== false ) {
                    this.value( newVal );
                }
            }
        }
    },

    _stop: function( event, index ) {
        var uiHash = {
            handle: this.handles[ index ],
            value: this.value()
        };
        if ( this.options.values && this.options.values.length ) {
            uiHash.value = this.values( index );
            uiHash.values = this.values();
        }

        this._trigger( "stop", event, uiHash );
    },

    _change: function( event, index ) {
        if ( !this._keySliding && !this._mouseSliding ) {
            var uiHash = {
                handle: this.handles[ index ],
                value: this.value()
            };
            if ( this.options.values && this.options.values.length ) {
                uiHash.value = this.values( index );
                uiHash.values = this.values();
            }

            //store the last changed value index for reference when handles overlap
            this._lastChangedValue = index;

            this._trigger( "change", event, uiHash );
        }
    },

    value: function( newValue ) {
        if ( arguments.length ) {
            this.options.value = this._trimAlignValue( newValue );
            this._refreshValue();
            this._change( null, 0 );
            return;
        }

        return this._value();
    },

    values: function( index, newValue ) {
        var vals,
            newValues,
            i;

        if ( arguments.length > 1 ) {
            this.options.values[ index ] = this._trimAlignValue( newValue );
            this._refreshValue();
            this._change( null, index );
            return;
        }

        if ( arguments.length ) {
            if ( $.isArray( arguments[ 0 ] ) ) {
                vals = this.options.values;
                newValues = arguments[ 0 ];
                for ( i = 0; i < vals.length; i += 1 ) {
                    vals[ i ] = this._trimAlignValue( newValues[ i ] );
                    this._change( null, i );
                }
                this._refreshValue();
            } else {
                if ( this.options.values && this.options.values.length ) {
                    return this._values( index );
                } else {
                    return this.value();
                }
            }
        } else {
            return this._values();
        }
    },

    _setOption: function( key, value ) {
        var i,
            valsLength = 0;

        if ( key === "range" && this.options.range === true ) {
            if ( value === "min" ) {
                this.options.value = this._values( 0 );
                this.options.values = null;
            } else if ( value === "max" ) {
                this.options.value = this._values( this.options.values.length-1 );
                this.options.values = null;
            }
        }

        if ( $.isArray( this.options.values ) ) {
            valsLength = this.options.values.length;
        }

        $.Widget.prototype._setOption.apply( this, arguments );

        switch ( key ) {
            case "orientation":
                this._detectOrientation();
                this.element
                    .removeClass( "ui-slider-horizontal ui-slider-vertical" )
                    .addClass( "ui-slider-" + this.orientation );
                this._refreshValue();
                break;
            case "value":
                this._animateOff = true;
                this._refreshValue();
                this._change( null, 0 );
                this._animateOff = false;
                break;
            case "values":
                this._animateOff = true;
                this._refreshValue();
                for ( i = 0; i < valsLength; i += 1 ) {
                    this._change( null, i );
                }
                this._animateOff = false;
                break;
            case "min":
            case "max":
                this._animateOff = true;
                this._refreshValue();
                this._animateOff = false;
                break;
            case "range":
                this._animateOff = true;
                this._refresh();
                this._animateOff = false;
                break;
        }
    },

    //internal value getter
    // _value() returns value trimmed by min and max, aligned by step
    _value: function() {
        var val = this.options.value;
        val = this._trimAlignValue( val );

        return val;
    },

    //internal values getter
    // _values() returns array of values trimmed by min and max, aligned by step
    // _values( index ) returns single value trimmed by min and max, aligned by step
    _values: function( index ) {
        var val,
            vals,
            i;

        if ( arguments.length ) {
            val = this.options.values[ index ];
            val = this._trimAlignValue( val );

            return val;
        } else if ( this.options.values && this.options.values.length ) {
            // .slice() creates a copy of the array
            // this copy gets trimmed by min and max and then returned
            vals = this.options.values.slice();
            for ( i = 0; i < vals.length; i+= 1) {
                vals[ i ] = this._trimAlignValue( vals[ i ] );
            }

            return vals;
        } else {
            return [];
        }
    },

    // returns the step-aligned value that val is closest to, between (inclusive) min and max
    _trimAlignValue: function( val ) {
        if ( val <= this._valueMin() ) {
            return this._valueMin();
        }
        if ( val >= this._valueMax() ) {
            return this._valueMax();
        }
        var step = ( this.options.step > 0 ) ? this.options.step : 1,
            valModStep = (val - this._valueMin()) % step,
            alignValue = val - valModStep;

        if ( Math.abs(valModStep) * 2 >= step ) {
            alignValue += ( valModStep > 0 ) ? step : ( -step );
        }

        // Since JavaScript has problems with large floats, round
        // the final value to 5 digits after the decimal point (see #4124)
        return parseFloat( alignValue.toFixed(5) );
    },

    _valueMin: function() {
        return this.options.min;
    },

    _valueMax: function() {
        return this.options.max;
    },

    _refreshValue: function() {
        var lastValPercent, valPercent, value, valueMin, valueMax,
            oRange = this.options.range,
            o = this.options,
            that = this,
            animate = ( !this._animateOff ) ? o.animate : false,
            _set = {};

        if ( this.options.values && this.options.values.length ) {
            this.handles.each(function( i ) {
                valPercent = ( that.values(i) - that._valueMin() ) / ( that._valueMax() - that._valueMin() ) * 100;
                _set[ that.orientation === "horizontal" ? "left" : "bottom" ] = valPercent + "%";
                $( this ).stop( 1, 1 )[ animate ? "animate" : "css" ]( _set, o.animate );
                if ( that.options.range === true ) {
                    if ( that.orientation === "horizontal" ) {
                        if ( i === 0 ) {
                            that.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { left: valPercent + "%" }, o.animate );
                        }
                        if ( i === 1 ) {
                            that.range[ animate ? "animate" : "css" ]( { width: ( valPercent - lastValPercent ) + "%" }, { queue: false, duration: o.animate } );
                        }
                    } else {
                        if ( i === 0 ) {
                            that.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { bottom: ( valPercent ) + "%" }, o.animate );
                        }
                        if ( i === 1 ) {
                            that.range[ animate ? "animate" : "css" ]( { height: ( valPercent - lastValPercent ) + "%" }, { queue: false, duration: o.animate } );
                        }
                    }
                }
                lastValPercent = valPercent;
            });
        } else {
            value = this.value();
            valueMin = this._valueMin();
            valueMax = this._valueMax();
            valPercent = ( valueMax !== valueMin ) ?
                    ( value - valueMin ) / ( valueMax - valueMin ) * 100 :
                    0;
            _set[ this.orientation === "horizontal" ? "left" : "bottom" ] = valPercent + "%";
            this.handle.stop( 1, 1 )[ animate ? "animate" : "css" ]( _set, o.animate );

            if ( oRange === "min" && this.orientation === "horizontal" ) {
                this.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { width: valPercent + "%" }, o.animate );
            }
            if ( oRange === "max" && this.orientation === "horizontal" ) {
                this.range[ animate ? "animate" : "css" ]( { width: ( 100 - valPercent ) + "%" }, { queue: false, duration: o.animate } );
            }
            if ( oRange === "min" && this.orientation === "vertical" ) {
                this.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { height: valPercent + "%" }, o.animate );
            }
            if ( oRange === "max" && this.orientation === "vertical" ) {
                this.range[ animate ? "animate" : "css" ]( { height: ( 100 - valPercent ) + "%" }, { queue: false, duration: o.animate } );
            }
        }
    },

    _handleEvents: {
        keydown: function( event ) {
            var allowed, curVal, newVal, step,
                index = $( event.target ).data( "ui-slider-handle-index" );

            switch ( event.keyCode ) {
                case $.ui.keyCode.HOME:
                case $.ui.keyCode.END:
                case $.ui.keyCode.PAGE_UP:
                case $.ui.keyCode.PAGE_DOWN:
                case $.ui.keyCode.UP:
                case $.ui.keyCode.RIGHT:
                case $.ui.keyCode.DOWN:
                case $.ui.keyCode.LEFT:
                    event.preventDefault();
                    if ( !this._keySliding ) {
                        this._keySliding = true;
                        $( event.target ).addClass( "ui-state-active" );
                        allowed = this._start( event, index );
                        if ( allowed === false ) {
                            return;
                        }
                    }
                    break;
            }

            step = this.options.step;
            if ( this.options.values && this.options.values.length ) {
                curVal = newVal = this.values( index );
            } else {
                curVal = newVal = this.value();
            }

            switch ( event.keyCode ) {
                case $.ui.keyCode.HOME:
                    newVal = this._valueMin();
                    break;
                case $.ui.keyCode.END:
                    newVal = this._valueMax();
                    break;
                case $.ui.keyCode.PAGE_UP:
                    newVal = this._trimAlignValue( curVal + ( (this._valueMax() - this._valueMin()) / numPages ) );
                    break;
                case $.ui.keyCode.PAGE_DOWN:
                    newVal = this._trimAlignValue( curVal - ( (this._valueMax() - this._valueMin()) / numPages ) );
                    break;
                case $.ui.keyCode.UP:
                case $.ui.keyCode.RIGHT:
                    if ( curVal === this._valueMax() ) {
                        return;
                    }
                    newVal = this._trimAlignValue( curVal + step );
                    break;
                case $.ui.keyCode.DOWN:
                case $.ui.keyCode.LEFT:
                    if ( curVal === this._valueMin() ) {
                        return;
                    }
                    newVal = this._trimAlignValue( curVal - step );
                    break;
            }

            this._slide( event, index, newVal );
        },
        click: function( event ) {
            event.preventDefault();
        },
        keyup: function( event ) {
            var index = $( event.target ).data( "ui-slider-handle-index" );

            if ( this._keySliding ) {
                this._keySliding = false;
                this._stop( event, index );
                this._change( event, index );
                $( event.target ).removeClass( "ui-state-active" );
            }
        }
    }

});

}(jQuery));
