/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */

/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */

/*!
 *
 * JET Chart widget
 * Copyright (c) 1999, 2019, Oracle and/or its affiliates. All rights reserved.
 *
 */

define("ojs/internal-deps/dvt/DvtLegend",["./DvtToolkit"],function(e){"use strict";return function(e){e.Legend=function(){},e.Obj.createSubclass(e.Legend,e.BaseComponent),e.Legend.newInstance=function(t,i,r){var n=new e.Legend;return n.Init(t,i,r),n},e.Legend.getDefaults=function(e){return(new i).getDefaults(e)},e.Legend.prototype.Init=function(t,n,a){e.Legend.superclass.Init.call(this,t,n,a),this.setId("legend1000"+Math.floor(1e9*Math.random())),this.Defaults=new i(t),this.EventManager=new r(this),this.EventManager.addListeners(this),this._peers=[],this._navigablePeers=[],this._bounds=null,this._titles=[]},e.Legend.prototype.SetOptions=function(e){this.getOptionsCache().clearCache(),e?(this.Options=this.Defaults.calcOptions(e),this._transferVisibilityProperties(this.Options.sections)):this.Options||(this.Options=this.GetDefaults())},e.Legend.prototype.getPreferredSize=function(t,i,r){this.SetOptions(t),this.getOptions().isLayout=!0;var n=new e.Rectangle(0,0,i,r),a=o.render(this,n);return this.getOptions().isLayout=!1,new e.Dimension(a.w,a.h)},e.Legend.prototype.render=function(t,i,r){this.getCache().clearCache(),this.SetOptions(t),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r),this.getOptions().isLayout=!1;for(var a=this.getNumChildren(),s=0;s<a;s++)this.getChildAt(s).destroy();this.removeChildren(),this._peers=[],this._navigablePeers=[],this._bounds=null,this._titles=[],e.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new n(this.EventManager,this)),this.UpdateAriaAttributes();var l=new e.Rectangle(0,0,this.Width,this.Height);this._contentDimensions=o.render(this,l);var h=this.getOptions().highlightedCategories;return h&&h.length>0&&this.highlight(h),this.RenderComplete(),this._contentDimensions},e.Legend.prototype.highlight=function(t){this.getOptions().highlightedCategories=t&&t.length>0?t.slice():null,e.CategoryRolloverHandler.highlight(t,this.__getObjects(),!0)},e.Legend.prototype.processEvent=function(t,i){if("categoryHighlight"==t.type&&"dim"==this.getOptions().hoverBehavior){var r=this.__getObjects();this!=i&&this.highlight(t.categories);for(var n=0;n<r.length;n++)if(e.Obj.compareValues(this.getCtx(),r[n].getId(),t.categories)){this.container.scrollIntoView(r[n].getDisplayables()[0]);break}}this==i&&this.dispatchEvent(t)},e.Legend.prototype.__registerObject=function(t){if(t.getDisplayables()[0]instanceof e.Button)this._navigablePeers.push(t);else{var i=this.getOptions().hideAndShowBehavior;(null!=t.getDatatip()||t.isDrillable()||"none"!=i&&"off"!=i)&&this._navigablePeers.push(t),this._peers.push(t)}},e.Legend.prototype.__getObjects=function(){return this._peers},e.Legend.prototype.__getKeyboardObjects=function(){return this._navigablePeers},e.Legend.prototype.__setBounds=function(e){this._bounds=e.clone()},e.Legend.prototype.__getBounds=function(){return this._bounds},e.Legend.prototype.__registerTitle=function(e){this._titles.push(e)},e.Legend.prototype.__getTitles=function(){return this._titles},e.Legend.prototype.getAutomation=function(){return new t(this)},e.Legend.prototype.getKeyboardFocus=function(){return null!=this.EventManager?this.EventManager.getFocus():null},e.Legend.prototype.setKeyboardFocus=function(t,i){if(null!=this.EventManager){for(var r=this.__getKeyboardObjects(),n=0;n<r.length;n++)if(e.Obj.compareValues(this.getCtx(),r[n].getId(),t.getId())){this.EventManager.setFocusObj(r[n]),i&&r[n].showKeyboardFocusEffect();break}var a=this.getKeyboardFocus();if(a){var o=a.getDisplayables()[0];o.setAriaProperty("label",a.getAriaLabel()),this.getCtx().setActiveElement(o)}}},e.Legend.prototype.getDimensions=function(t){var i=new e.Rectangle(0,0,this.Width,this.Height);return t&&t!==this?this.ConvertCoordSpaceRect(i,t):i},e.Legend.prototype.getContentDimensions=function(e){return e&&e!==this?this.ConvertCoordSpaceRect(this._contentDimensions,e):this._contentDimensions},e.Legend.prototype._transferVisibilityProperties=function(e){if(e&&!(e.length<=0))for(var t=this.getOptions().hiddenCategories,i=0;i<e.length;i++){var r=e[i];r.sections&&this._transferVisibilityProperties(r.sections);var n=r.items;if(n&&!(n.length<=0))for(var a=0;a<n.length;a++){var s=n[a],l=o.getItemCategory(s,this);"hidden"==s.categoryVisibility&&t.indexOf(l)<0&&t.push(l),s.categoryVisibility=null}}},e.Legend.prototype.UpdateAriaAttributes=function(){if(this.IsParentRoot()){var t=this.getOptions(),i=t.translations,r=t.hideAndShowBehavior;("off"!=r&&"none"!=r||"dim"==t.hoverBehavior)&&(this.getCtx().setAriaRole("application"),this.getCtx().setAriaLabel(e.ResourceUtils.format(i.labelAndValue,[i.labelDataVisualization,e.TextUtils.processAriaLabel(this.GetComponentDescription())])))}},e.Legend.prototype.isNavigable=function(){return this._navigablePeers.length>0},e.Legend.getItemCount=function(t){var i=t.getOptionsCache().getFromCache("itemsCount");if(null!=i)return i;i=0;for(var r=t.getOptions().sections,n=0;n<r.length;n++){var a=r[n];i+=e.Legend.getSectionItemsCount(a)}return t.getOptionsCache().putToCache("itemsCount",i),i},e.Legend.getSectionItemsCount=function(t){var i=0;if(t.items&&(i+=t.items.length),t.sections)for(var r=t.sections,n=0;n<r.length;n++)i+=e.Legend.getSectionItemsCount(r[n]);return i};var t=function(e){this._legend=e,this._options=this._legend.getOptions()};e.Obj.createSubclass(t,e.Automation),t.prototype.GetSubIdForDomElement=function(e){var t=this._legend.getEventManager().GetLogicalObject(e);if(t&&t instanceof a){var i=t.getData(),r=this._getIndicesFromItem(i,this._options);if(r)return"section"+r}return null},t.prototype._getIndicesFromItem=function(e,t){if(t.sections&&t.sections.length>0){for(var i=0;i<t.sections.length;i++){if(t.sections[i]==e)return"["+i+"]";var r=this._getIndicesFromItem(e,t.sections[i]);if(r)return"["+i+"]"+r}return null}if(t.items&&t.items.length>0){for(var n=0;n<t.items.length;n++)if(t.items[n]==e)return":item["+n+"]";return null}},t.prototype.getIndicesFromSeries=function(e,t){if(t.sections&&t.sections.length>0){for(var i=0;i<t.sections.length;i++){var r=this.getIndicesFromSeries(e,t.sections[i]);if(r)return"["+i+"]"+r}return null}if(t.items&&t.items.length>0){for(var n=0;n<t.items.length;n++)if(t.items[n].text==e.name)return":item["+n+"]";return null}},t.prototype.getLegendItem=function(e,t){var i=t.indexOf("["),r=t.indexOf("]");if(i>=0&&r>=0){var n=t.substring(i+1,r),a=t.indexOf(":"),o=(t=t.substring(r+1)).indexOf("["),s=t.indexOf("]");return o>=0&&s>=0?this.getLegendItem(e.sections[n],t):0==a?e.items[n]:e.sections[n]}},t.prototype.getDomElementForSubId=function(t){if(t==e.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._legend);for(var i=this.getLegendItem(this._options,t),r=this._legend.__getObjects(),n=0;n<r.length;n++)if(i==r[n].getData())return r[n].getDisplayables()[0].getElem();return null},t.prototype.getTitle=function(){return this._options.title},t.prototype.getItem=function(e){var t,i=e.shift(),r=this._options;if(!r.sections||0===r.sections.length)return null;for(;null!=i;)e.length>0?r=r.sections[i]:t=r.items[i],i=e.shift();return t?{text:t.text?t.text:null}:null},t.prototype.getSection=function(e){var t,i=e.shift(),r=this._options;if(!r.sections||0===r.sections.length)return null;for(;null!=i;)e.length>0?r=r.sections[i]:t=r.sections[i],i=e.shift();return{title:t.title?t.title:null,items:t.items?this._generateItemObjects(t.items):null,sections:t.sections?this._generateSectionObjects(t.sections):null}},t.prototype._generateItemObjects=function(e){for(var t=[],i=0;i<e.length;i++)t.push({text:e[i].text});return t},t.prototype._generateSectionObjects=function(e){for(var t=[],i=0;i<e.length;i++)t.push({title:e[i].title?e[i].title:null,items:e[i].items?this._generateItemObjects(e[i].items):null,sections:e[i].sections?this._generateSectionObjects(e[i].sections):null});return t};var i=function(e){this.Init({alta:i.SKIN_ALTA},e)};e.Obj.createSubclass(i,e.BaseComponentDefaults),i.SKIN_ALTA={skin:e.CSSStyle.SKIN_ALTA,orientation:"vertical",position:null,backgroundColor:null,borderColor:null,textStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),titleStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #737373;"),_sectionTitleStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #737373;"),titleHalign:"start",hiddenCategories:[],hideAndShowBehavior:"off",hoverBehavior:"none",hoverBehaviorDelay:200,scrolling:"asNeeded",halign:"start",valign:"top",drilling:"off",dnd:{drag:{series:{}},drop:{legend:{}}},_color:"#a6acb1",_markerShape:"square",_lineWidth:3,layout:{outerGapWidth:3,outerGapHeight:3,titleGapWidth:17,titleGapHeight:9,symbolGapWidth:7,symbolGapHeight:4,rowGap:4,columnGap:10,sectionGapHeight:16,sectionGapWidth:24},isLayout:!1},i.getGapSize=function(t,i){var r=Math.min(e.TextUtils.getTextStringHeight(t.getCtx(),t.getOptions().textStyle)/14,1);return Math.ceil(i*r)},i.prototype.getNoCloneObject=function(e){return{sections:{items:{_dataContext:!0}}}};var r=function(e){this.Init(e.getCtx(),e.processEvent,e,e),this._legend=e};e.Obj.createSubclass(r,e.EventManager),r.prototype.OnClick=function(e){r.superclass.OnClick.call(this,e);var t=this.GetLogicalObject(e.target);if(t){var i=this.processHideShowEvent(t),n=this.handleClick(t,e);(i||n)&&e.stopPropagation()}},r.prototype.OnMouseOver=function(t){r.superclass.OnMouseOver.call(this,t);var i=this.GetLogicalObject(t.target);if(i){var n=i instanceof e.SimpleObjPeer?i.getParams():null;n&&n.isCollapsible&&n.button&&n.button.drawOverState(),this.UpdateActiveElement(i)}},r.prototype.OnMouseOut=function(t){r.superclass.OnMouseOut.call(this,t);var i=this.GetLogicalObject(t.target);if(i){var n=i instanceof e.SimpleObjPeer?i.getParams():null;n&&n.isCollapsible&&n.button&&n.button.drawUpState()}},r.prototype.HandleTouchClickInternal=function(e){var t=this.GetLogicalObject(e.target);if(t){var i=e.touchEvent,r=this.processHideShowEvent(t),n=this.handleClick(t,e);(r||n)&&i&&i.preventDefault()}},r.prototype.processHideShowEvent=function(t){var i=this._legend.getOptions().hideAndShowBehavior;if("none"==i||"off"==i)return!1;var r=t.getCategories?t.getCategories():null;if(!r||r.length<=0)return!1;var n=t.getCategories()[0],a=this._legend.getOptions().hiddenCategories||[];a=a.slice();for(var s=t.getDisplayables(),l=0;l<s.length;l++){var h=s[l];h instanceof e.SimpleMarker?h.setHollow(t.getColor()):h instanceof e.Rect&&t.updateAriaLabel()}var u,g=r[0];return o.isCategoryHidden(n,this._legend)?(a.splice(a.indexOf(n),1),u=e.EventFactory.newCategoryShowEvent(g,a)):(a.push(n),u=e.EventFactory.newCategoryHideEvent(g,a)),this._legend.getOptions().hiddenCategories=a,this.FireEvent(u,this._legend),!0},r.prototype.handleClick=function(t,i){if(t instanceof a&&t.isDrillable()){var r=t.getId();return this.FireEvent(e.EventFactory.newChartDrillEvent(r,r,null),this._legend),!0}var n=t instanceof e.SimpleObjPeer?t.getParams():null;return!(!n||!n.isCollapsible||(this.toggleSectionCollapse(i,n.id),0))},r.prototype.ProcessRolloverEvent=function(t,i,r){var n=this._legend.getOptions();if(!("none"==n.hoverBehavior||i.getDisplayables&&i.getDisplayables()[0]instanceof e.Button)){var a=i.getCategories?i.getCategories():[];n.highlightedCategories=r?a.slice():null;var o=e.EventFactory.newCategoryHighlightEvent(n.highlightedCategories,r),s=e.CSSStyle.getTimeMilliseconds(n.hoverBehaviorDelay);this.RolloverHandler.processEvent(o,this._legend.__getObjects(),s,!0)}},r.prototype.onCollapseButtonClick=function(e,t){var i=t.getId();this.toggleSectionCollapse(e,i)},r.prototype.toggleSectionCollapse=function(t,i){for(var r=this._legend.getOptions(),n=r.expanded,a=this._legend.getOptions(),o=null,s=0;s<i.length;s++)a=a.sections[i[s]];if(n?n.has(a.id)?(r.expanded=n.delete([a.id]),o=!1):(r.expanded=n.add([a.id]),o=!0):a.expanded="off"==a.expanded?"on":"off",t.type==e.MouseEvent.CLICK){var l=this.GetLogicalObject(t.target);l.getNextNavigable&&this.setFocusObj(l.getNextNavigable(t))}var h=this._legend.getKeyboardFocus(),u=!!h&&h.isShowingKeyboardFocusEffect();this._legend.render(),h&&this._legend.setKeyboardFocus(h,u),this.hideTooltip(),null!=o&&(t=new e.EventFactory.newExpandCollapseEvent(o?"expand":"collapse",a.id,a,this._legend.getOptions()._widgetConstructor,r.expanded),this.FireEvent(t,this._legend))},r.prototype.GetTouchResponse=function(){return this._legend.getOptions()._isScrollingLegend?e.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:e.EventManager.TOUCH_RESPONSE_TOUCH_START},r.prototype.isDndSupported=function(){return!0},r.prototype.GetDragSourceType=function(e){var t=this.DragSource.getDragObject();return t instanceof a&&null!=t.getData()._dataContext?"series":null},r.prototype.GetDragDataContexts=function(t){var i=this.DragSource.getDragObject();if(i instanceof a){var r=i.getData()._dataContext;return t&&(r=e.JsonUtils.clone(r,null,{component:!0,componentElement:!0}),e.ToolkitUtils.cleanDragDataContext(r)),[r]}return[]},r.prototype.GetDropTargetType=function(e){var t=this._legend.stageToLocal(this.getCtx().pageToStageCoords(e.pageX,e.pageY)),i=this._legend.getOptions().dnd.drop,r=this._legend.__getBounds();return Object.keys(i.legend).length>0&&r.containsPoint(t.x,t.y)?"legend":null},r.prototype.GetDropEventPayload=function(e){return{}},r.prototype.ShowDropEffect=function(e){if("legend"==this.GetDropTargetType(e)){var t=this._legend.getOptions()._dropColor,i=this._legend.getCache().getFromCache("background");i&&(i.setSolidFill(t),i.setClassName("oj-active-drop"))}},r.prototype.ClearDropEffect=function(){var t=this._legend.getCache().getFromCache("background");if(t){var i=this._legend.getOptions().backgroundColor;i?t.setSolidFill(i):t.setInvisibleFill(),e.ToolkitUtils.removeClassName(t.getElem(),"oj-invalid-drop"),e.ToolkitUtils.removeClassName(t.getElem(),"oj-active-drop")}},r.prototype.ShowRejectedDropEffect=function(e){if("legend"==this.GetDropTargetType(e)){var t=this._legend.getCache().getFromCache("background");t&&t.setClassName("oj-invalid-drop")}};var n=function(e,t){this.Init(e,t)};e.Obj.createSubclass(n,e.KeyboardHandler),n.prototype.Init=function(e,t){n.superclass.Init.call(this,e),this._legend=t},n.prototype.processKeyDown=function(t){var i=t.keyCode,r=this._eventManager.getFocus(),a=r&&r.getDisplayables()[0]instanceof e.Button,o=null;if(null==r&&i==e.KeyboardEvent.TAB){var s=this._legend.__getKeyboardObjects();s.length>0&&(e.EventManager.consumeEvent(t),o=this.getDefaultNavigable(s))}else r&&(i==e.KeyboardEvent.TAB?(e.EventManager.consumeEvent(t),o=r):i==e.KeyboardEvent.ENTER||i==e.KeyboardEvent.SPACE?(i==e.KeyboardEvent.ENTER&&this._eventManager.handleClick(r,t),a?this._eventManager.onCollapseButtonClick(t,r.getDisplayables()[0]):this._eventManager.processHideShowEvent(r),e.EventManager.consumeEvent(t)):!a||i!=e.KeyboardEvent.LEFT_ARROW&&i!=e.KeyboardEvent.RIGHT_ARROW?o=n.superclass.processKeyDown.call(this,t):(this._eventManager.onCollapseButtonClick(t,r.getDisplayables()[0]),e.EventManager.consumeEvent(t)));return o&&this._legend.container.scrollIntoView(o.getDisplayables()[0]),o};var a=function(e,t,i,r,n,a){this.Init(e,t,i,r,n,a)};e.Obj.createSubclass(a,e.Obj),a.prototype.Init=function(t,i,r,n,a,s){if(this._legend=t,this._displayables=i,this._item=r,this._category=o.getItemCategory(this._item,this._legend),this._id=this._category?this._category:r.title,this._drillable=s,this._tooltip=n,this._datatip=a,this._isShowingKeyboardFocusEffect=!1,this._drillable)for(var l=0;l<this._displayables.length;l++)this._displayables[l].setCursor(e.SelectionEffectUtils.getSelectingCursor())},a.associate=function(e,t,i,r,n,o){if(!e||!i)return null;var s=new a(t,e,i,r,n,o);t.__registerObject(s);for(var l=0;l<e.length;l++)t.getEventManager().associate(e[l],s);return s},a.prototype.getData=function(){return this._item},a.prototype.getColor=function(){return this._item.color},a.prototype.getId=function(){return this._id},a.prototype.getDisplayables=function(){return this._displayables},a.prototype.getCategories=function(e){return null!=this._category?[this._category]:null},a.prototype.isDrillable=function(){return this._drillable},a.prototype.getAriaLabel=function(){var t=[],i=this._legend.getOptions().translations,r=this._legend.getOptions().hideAndShowBehavior,n=o.isCategoryHidden(this._category,this._legend),a=this.getData();return this._displayables[0]instanceof e.Button?(t.push(i[o.isSectionCollapsed(a,this._legend)?"stateCollapsed":"stateExpanded"]),e.Displayable.generateAriaLabel(a.title,t)):("off"!=r&&"none"!=r&&t.push(i[n?"stateHidden":"stateVisible"]),this.isDrillable()&&t.push(i.stateDrillable),null!=a.shortDesc?e.Displayable.generateAriaLabel(a.shortDesc,t):t.length>0?e.Displayable.generateAriaLabel(a.text,t):null)},a.prototype.updateAriaLabel=function(){!e.Agent.deferAriaCreation()&&this._displayables[0]&&this._displayables[0].setAriaProperty("label",this.getAriaLabel())},a.prototype.getNextNavigable=function(t){if(t.type==e.MouseEvent.CLICK)return this;var i=this._legend.__getKeyboardObjects();return e.KeyboardHandler.getNextNavigable(this,t,i,!0)},a.prototype.getKeyboardBoundingBox=function(t){return this._displayables[0]?this._displayables[0].getDimensions(t):new e.Rectangle(0,0,0,0)},a.prototype.getTargetElem=function(){return this._displayables[0]?this._displayables[0].getElem():null},a.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this._displayables[0]&&(this._displayables[0]instanceof e.Button?this._displayables[0].drawOverState():this._displayables[0].setSolidStroke(e.Agent.getFocusColor()))},a.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this._displayables[0]&&(this._displayables[0]instanceof e.Button?this._displayables[0].drawUpState():this._displayables[0].setStroke(null))},a.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},a.prototype.getTooltip=function(e){return this._tooltip},a.prototype.getDatatip=function(e){return this._datatip},a.prototype.getDatatipColor=function(e){return this._item.color},a.prototype.isDragAvailable=function(e){return!0},a.prototype.getDragTransferable=function(e,t){return[this.getId()]},a.prototype.getDragFeedback=function(e,t){return this.getDisplayables()};var o=new Object;e.Obj.createSubclass(o,e.Obj),o._DEFAULT_LINE_WIDTH_WITH_MARKER=2,o._LINE_MARKER_SIZE_FACTOR=.6,o._DEFAULT_SYMBOL_SIZE=10,o._BUTTON_SIZE=12,o._FOCUS_GAP=2,o.render=function(t,r){var n=t.getOptions(),a=t.getCtx(),s=e.Agent.isRightToLeft(a);t.__setBounds(r),n.isLayout||o._renderBackground(t,r);var l=new e.SimpleScrollableContainer(a,r.w,r.h),h=new e.Container(a);l.getScrollingPane().addChild(h),t.addChild(l),t.container=l;var u=i.getGapSize(t,n.layout.outerGapWidth),g=i.getGapSize(t,n.layout.outerGapHeight);if(r.x+=u,r.y+=g,r.w-=2*u,r.h-=2*g,r.w<=0||r.h<=0)return new e.Dimension(0,0);var d=o._renderContents(t,h,new e.Rectangle(r.x,r.y,r.w,r.h));if(0==d.w||0==d.h)return new e.Dimension(0,0);l.prepareContentPane(),d.h>r.h?(d.h=r.h,n._isScrollingLegend=!0):n._isScrollingLegend=!1;var p=0,c=0,_=null!=n.hAlign?n.hAlign:n.halign;"center"==_?p=r.x-d.x+(r.w-d.w)/2:"end"==_&&(p=s?r.x-d.x:r.x-d.x+r.w-d.w);var f=null!=n.vAlign?n.vAlign:n.valign;"middle"==f?c=r.y-d.y+(r.h-d.h)/2:"bottom"==f&&(c=r.y-d.y+r.h-d.h);var m=new e.Rectangle(d.x+p-u,d.y+c-g,d.w+2*u,d.h+2*g);if(n.isLayout)return m;(p||c)&&h.setTranslate(p,c);for(var v=t.__getTitles(),y=0;y<v.length;y++)e.LayoutUtils.align(d,v[y].halign,v[y].text,v[y].text.getDimensions().w);return m},o._renderContents=function(e,t,r){var n=e.getOptions();r=r.clone();var a=o._renderTitle(e,t,n.title,r,null,!0);if(a){var s=a.getDimensions(),l=i.getGapSize(e,n.layout.titleGapHeight);r.y+=s.h+l,r.h-=Math.floor(s.h+l)}var h=o._renderSections(e,t,n.sections,r,[]);return a?s.getUnion(h):h},o._renderBackground=function(t,i){var r=t.getOptions(),n=r.backgroundColor,a=r.borderColor,o=r.dnd?r.dnd.drop.legend:{},s=r.dnd?r.dnd.drag.series:{};if(n||a||Object.keys(o).length>0||Object.keys(s).length>0){var l=new e.Rect(t.getCtx(),i.x,i.y,i.w,i.h);n?l.setSolidFill(n):l.setInvisibleFill(),a&&(l.setSolidStroke(a),l.setPixelHinting(!0)),t.addChild(l),t.getCache().putToCache("background",l)}},o._renderTitle=function(t,i,r,n,a,o,s,l){var h=t.getOptions(),u=i.getCtx(),g=e.Agent.isRightToLeft(u);if(!r)return null;var d=new e.OutputText(u,r,n.x,n.y),p=h.titleStyle;if(a&&a.titleStyle?p=new e.CSSStyle(a.titleStyle):a&&h._sectionTitleStyle&&(p=h._sectionTitleStyle),d.setCSSStyle(p),e.TextUtils.fitText(d,n.w,1/0,i)){if(g&&d.setX(n.x+n.w-d.getDimensions().w),h.isLayout)i.removeChild(d);else{var c={id:s,button:l};if(c.isCollapsible=a&&("on"==a.collapsible||1==a.collapsible),t.getEventManager().associate(d,new e.SimpleObjPeer(d.getUntruncatedTextString(),null,null,c)),o){var _=a&&a.titleHalign?a.titleHalign:h.titleHalign;t.__registerTitle({text:d,halign:_})}}return d}return null},o._renderSections=function(t,r,n,a,s){if(!n||0==n.length)return new e.Rectangle(0,0,0,0);var l=t.getOptions();l.symbolWidth||l.symbolHeight?(l.symbolWidth?l.symbolHeight||(l.symbolHeight=l.symbolWidth):l.symbolWidth=l.symbolHeight,l.symbolWidth=parseInt(l.symbolWidth),l.symbolHeight=parseInt(l.symbolHeight)):(l.symbolWidth=o._DEFAULT_SYMBOL_SIZE,l.symbolHeight=o._DEFAULT_SYMBOL_SIZE);for(var h,u=i.getGapSize(t,l.layout.sectionGapHeight),g=i.getGapSize(t,l.layout.titleGapHeight),d=i.getGapSize(t,l.layout.sectionGapWidth),p=o._getRowHeight(t),c="vertical"!=l.orientation,_=null,f=a.clone(),m=0;m<n.length;m++){var v=s.concat([m]),y=o.isSectionCollapsed(n[m],t)?g:u;c?(h=o._renderHorizontalSection(t,r,n[m],f,p)).w>f.w?(f.w<a.w&&(a.y+=h.h+y,a.h-=h.h+y),h=h.w<=a.w?o._renderHorizontalSection(t,r,n[m],a,p):o._renderVerticalSection(t,r,n[m],a,p,v,!0),a.y+=h.h+y,a.h-=h.h+y,f=a.clone()):(f.w-=h.w+d,e.Agent.isRightToLeft(t.getCtx())||(f.x+=h.w+d)):(h=o._renderVerticalSection(t,r,n[m],a,p,v,!1),a.y+=h.h+y,a.h-=h.h+y),_=_?_.getUnion(h):h}return _},o._createButton=function(t,i,r,n,s,l,h,u,g,d,p){var c=o._createButtonImage(t,n,s+"Enabled",l,h),_=o._createButtonImage(t,n,s+"Over",l,h),f=o._createButtonImage(t,n,s+"Down",l,h),m=new e.Button(t,c,_,f,null,g,d,p),v=a.associate([m],i,r,u,null,!1);return m.setAriaRole("button"),v.updateAriaLabel(),m},o._createButtonImage=function(t,i,r,n,a){var s=e.Agent.isRightToLeft(t)?"RTL":"",l=i[r+s]?i[r+s]:i[r],h=new e.Image(t,l,n,a,o._BUTTON_SIZE,o._BUTTON_SIZE);return h.setInvisibleFill(),h},o._renderVerticalSection=function(t,r,n,a,s,l,h){if(n){var u,g=t.getOptions(),d=i.getGapSize(t,g.layout.symbolGapWidth),p=i.getGapSize(t,g.layout.rowGap),c=i.getGapSize(t,g.layout.columnGap),_=t.getCtx(),f=e.Agent.isRightToLeft(_),m=null!=n.sections&&n.sections.length>0,v=null!=n.items&&n.items.length>0,y=a.clone();"off"!=g.scrolling&&(y.h=1/0);var S,C="on"==n.collapsible||1==n.collapsible;if(C){var A=f?y.x+y.w-o._BUTTON_SIZE:y.x;if(!g.isLayout){var b=o.isSectionCollapsed(n,t),x=b?"closed":"open",M=g.translations[b?"tooltipExpand":"tooltipCollapse"],O=t.getEventManager();S=o._createButton(_,t,n,g._resources,x,A,y.y,M,l,O.onCollapseButtonClick,O),r.addChild(S)}u=new e.Rectangle(A,y.y,o._BUTTON_SIZE,o._BUTTON_SIZE);var T=i.getGapSize(t,g.layout.symbolGapWidth);f||(y.x+=o._BUTTON_SIZE+T),y.w-=o._BUTTON_SIZE+T}var w=o._renderTitle(t,r,n.title,y,n,!C&&l.length<=1,l,S),D=w?w.getDimensions():new e.Rectangle(f?y.x+y.w:y.x,y.y,0,0),E=u?D.getUnion(u):D;if(!v&&!m||o.isSectionCollapsed(n,t))return E;if(E.h>0){var I=i.getGapSize(t,g.layout.titleGapHeight);y.y+=E.h+I,y.h-=E.h+I}if(m){var P=o._renderSections(t,r,n.sections,y,l);E=E.getUnion(P)}if(!v)return E;var L=o._calcColumns(t,y,s,n.items,h),R=L.numCols,B=L.numRows,k=L.width,z=y.y;if(0==B||0==R)return E;var H=B*(s+p)-p,F=Math.min(R*(k+c)-c,y.w),N=new e.Rectangle(f?y.x+y.w-F:y.x,y.y,F,H);if(E=E.getUnion(N),g.isLayout)return E;for(var W=k-g.symbolWidth-d,G=0,j=1,U=n.items.length,V=0;V<U;V++){var X=n.items[V];if(o._createLegendItem(t,r,X,y,W,s,V),y.y+=s+p,++G===B&&j!==R&&(y.y=z,y.w-=k+c,f||(y.x+=k+c),G=0,j++),G===B)break}return E}},o._renderHorizontalSection=function(t,r,n,a,s){if(n){var l=t.getOptions(),h=l.symbolWidth,u=i.getGapSize(t,l.layout.symbolGapWidth),g=i.getGapSize(t,l.layout.columnGap),d=i.getGapSize(t,l.layout.titleGapWidth),p=null!=n.items&&n.items.length>0,c=e.Agent.isRightToLeft(t.getCtx()),_=a.clone(),f=o._renderTitle(t,r,n.title,a,n,!1),m=f?f.getDimensions():new e.Rectangle(c?a.x+a.w:a.x,a.y,0,0);if(!p)return m;m.w>0&&(_.w-=m.w+d,c||(_.x+=m.w+d));var v,y,S,C=[],A=a.w-_.w,b=n.items.length;for(S=0;S<b;S++)v=n.items[S],A+=(y=Math.ceil(e.TextUtils.getTextStringWidth(t.getCtx(),v.text,l.textStyle)))+h+u+g,C.push(y);b>0&&(A-=g);var x,M=new e.Rectangle(c?a.x+a.w-A:a.x,a.y,A,Math.max(s,m.h));if(l.isLayout||A>a.w)return r.removeChild(f),M;for(S=0;S<b;S++)v=n.items[S],o._createLegendItem(t,r,v,_,C[S],s,S),x=C[S]+h+u,_.w-=x+g,c||(_.x+=x+g);return M}},o._calcColumns=function(t,r,n,a,o){for(var s=t.getOptions(),l=[],h=0;h<a.length;h++)l.push(a[h].text);var u,g,d,p=e.TextUtils.getMaxTextStringWidth(t.getCtx(),l,s.textStyle),c=s.symbolWidth,_=i.getGapSize(t,s.layout.symbolGapWidth),f=i.getGapSize(t,s.layout.rowGap),m=i.getGapSize(t,s.layout.columnGap),v=Math.ceil(c+_+p);o?(d=Math.min(Math.max(Math.floor((r.w+m)/(v+m)),1),a.length),u=Math.min(Math.floor((r.h+f)/(n+f)),Math.ceil(a.length/d)),d=Math.ceil(a.length/u),u=Math.ceil(a.length/d)):r.h==1/0?(d=1,u=a.length):(u=Math.min(Math.floor((r.h+f)/(n+f)),a.length),d=Math.ceil(a.length/u),u=Math.ceil(a.length/d));var y=(r.w-m*(d-1))/d;return(g=Math.min(v,y))<c?{width:0,numCols:0,numRows:0}:{width:g,numCols:d,numRows:u}},o._getRowHeight=function(t){var r=t.getOptions(),n=e.TextUtils.getTextStringHeight(t.getCtx(),r.textStyle),a=r.symbolHeight+i.getGapSize(t,r.layout.symbolGapHeight);return Math.ceil(Math.max(n,a))},o._createLegendItem=function(t,r,n,s,l,h,u){var g,d=t.getOptions(),p=t.getCtx(),c=e.Agent.isRightToLeft(p),_=d.symbolWidth,f=i.getGapSize(t,d.layout.symbolGapWidth),m=c?s.x+s.w-_:s.x,v=c?s.x+s.w-_-f:s.x+_+f,y=o._createLegendSymbol(t,m,s.y,h,n,u),S=n.text;if(null!=S){var C=d.textStyle;(g=o._createLegendText(r,l,S,C))&&(g.setX(v),e.TextUtils.centerTextVertically(g,s.y+h/2),c&&g.alignRight())}r.addChild(y);var A=new e.Rect(p,c?v-l-o._FOCUS_GAP:m-o._FOCUS_GAP,s.y-o._FOCUS_GAP,_+f+l+2*o._FOCUS_GAP,h+2*o._FOCUS_GAP);A.setInvisibleFill();var b=d.hideAndShowBehavior;"none"!=b&&"off"!=b&&A.setCursor("pointer"),r.addChild(A);var x=[A,y];null!=g&&x.push(g);var M=a.associate(x,t,n,null!=g?g.getUntruncatedTextString():null,n.shortDesc,o._isItemDrillable(t,n));o.isCategoryHidden(o.getItemCategory(n,t),t)&&(y.setHollow(M.getColor()),y.setStyle().setClassName()),("none"!=b&&"off"!=b||null!=n.shortDesc)&&(A.setAriaRole("img"),M.updateAriaLabel())},o._isItemDrillable=function(e,t){return"on"==t.drilling||"off"!=t.drilling&&"on"==e.getOptions().drilling},o._createLegendText=function(t,i,r,n){var a=new e.OutputText(t.getCtx(),r);return a.setCSSStyle(n),a=e.TextUtils.fitText(a,i,1/0,t)?a:null},o._createLegendSymbol=function(t,i,r,n,a,s){var l=t.getOptions(),h=t.getCtx(),u=null!=a.type?a.type:a.symbolType;a.markerShape||(a.markerShape=l._markerShape),a.color||(a.color=l._color),a.lineWidth||(a.lineWidth="lineWithMarker"==u?o._DEFAULT_LINE_WIDTH_WITH_MARKER:l._lineWidth);var g,d=l.symbolWidth,p=l.symbolHeight,c=r+n/2,_=i+d/2;if("line"==u)g=o._createLine(h,i,r,d,n,a);else if("lineWithMarker"==u)g=o._createLine(h,i,r,d,n,a),o.isCategoryHidden(o.getItemCategory(a,t),t)||g.addChild(o._createMarker(t,_,c,d*o._LINE_MARKER_SIZE_FACTOR,p*o._LINE_MARKER_SIZE_FACTOR,a));else if("image"==u)g=o._createImage(t,i,r,d,p,n,a);else if("_verticalBoxPlot"==u)p=Math.max(4*Math.round(p/4),4),(g=new e.Container(h)).addChild(o._createMarker(t,_,c+p/4,d,p/2,o._getBoxPlotOptions(a,"q2"))),g.addChild(o._createMarker(t,_,c-p/4,d,p/2,o._getBoxPlotOptions(a,"q3")));else if("_horizontalBoxPlot"==u){var f=e.Agent.isRightToLeft(h),m=(d=Math.max(4*Math.round(d/4),4))/4*(f?1:-1);(g=new e.Container(h)).addChild(o._createMarker(t,_+m,c,d/2,p,o._getBoxPlotOptions(a,"q2"))),g.addChild(o._createMarker(t,_-m,c,d/2,p,o._getBoxPlotOptions(a,"q3")))}else g=o._createMarker(t,_,c,d,p,a);return g},o._createImage=function(t,i,r,n,a,o,s){var l=t.getCtx(),h=r+o/2,u=i+n/2;return new e.ImageMarker(l,u,h,n,a,null,s.source)},o._createMarker=function(t,i,r,n,a,o){var s,l=t.getCtx(),h=(t.getOptions(),o.markerShape),u=o.symbolType&&"lineWithMarker"==o.symbolType&&o.markerColor?o.markerColor:o.color,g=o.markerStyle||o.markerSvgStyle?o.markerStyle||o.markerSvgStyle:o.style||o.svgStyle,d=o.markerClassName||o.markerSvgClassName?o.markerClassName||o.markerSvgClassName:o.className||o.svgClassName,p=o.pattern;if(p&&"none"!=p?((s=new e.SimpleMarker(l,h,0,0,n,a,null,null,!0)).setFill(new e.PatternFill(p,u,"#FFFFFF")),s.setTranslate(i,r)):(s=new e.SimpleMarker(l,h,i,r,n,a,null,null,!0)).setSolidFill(u),o.borderColor){var c=o._borderWidth?o._borderWidth:1;s.setSolidStroke(o.borderColor,null,c)}return"square"!=h&&"rectangle"!=h||s.setPixelHinting(!0),s.setClassName(d).setStyle(g),s},o._createLine=function(t,i,r,n,a,o){var s=r+a/2;n=n%2==1?n+1:n;var l,h=new e.Line(t,i,Math.round(s),i+n,Math.round(s)),u=o.lineStyle;"dashed"==u?l={dashArray:"4,2,4"}:"dotted"==u&&(l={dashArray:"2"});var g=new e.Stroke(o.color,1,o.lineWidth,!1,l);return h.setClassName(o.className||o.svgClassName).setStyle(o.style||o.svgStyle),h.setStroke(g),h.setPixelHinting(!0),h},o._getBoxPlotOptions=function(e,t){return{markerShape:"rectangle",color:e._boxPlot[t+"Color"],pattern:e._boxPlot["_"+t+"Pattern"],className:e._boxPlot[t+"ClassName"]||e._boxPlot[t+"svgClassName"],style:e._boxPlot[t+"Style"]||e._boxPlot[t+"svgStyle"]}},o.getItemCategory=function(e,t){var i=null,r=null!=t.getOptions().data;return e.categories&&e.categories.length>0?i=e.categories[0]:r||(i=e.id?e.id:e.text),i},o.isCategoryHidden=function(e,t){var i=t.getOptions().hiddenCategories;return!(!i||i.length<=0)&&-1!==i.indexOf(e)},o.isSectionCollapsed=function(e,t){var i=t.getOptions();return"off"==e.expanded||0==e.expanded||i.expanded&&0==i.expanded.has(e.id)}}(e),e}),define("ojs/internal-deps/dvt/DvtOverview",["./DvtToolkit"],function(e){"use strict";return function(e){e.OverviewUtils=new Object,e.OverviewUtils.supportsTouch=function(){return e.Agent.isTouchDevice()},e.Obj.createSubclass(e.OverviewUtils,e.Obj),e.OverviewUtils.getDatePosition=function(e,t,i,r){var n=(i-e)*r,a=t-e;return 0==n||0==a?0:n/a},e.OverviewUtils.getPositionDate=function(e,t,i,r){var n=i*(t-e);return 0==n||0==r?e:n/r+e},e.Overview=function(e,t,i){this.Init(e,t,i)},e.Obj.createSubclass(e.Overview,e.Container),e.Overview.MIN_WINDOW_SIZE=10,e.Overview.DEFAULT_VERTICAL_TIMEAXIS_SIZE=40,e.Overview.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE=20,e.Overview.HANDLE_PADDING_SIZE=20,e.Overview.prototype.Init=function(t,r,n){e.Overview.superclass.Init.call(this,t),this.initDefaults(),this._callback=r,this._callbackObj=n,this._lastChildIndex=6,(null!=this._callback||null!=this._callbackObj)&&(this.EventManager=new i(this,t,r,n),this.EventManager.addListeners(this),e.OverviewUtils.supportsTouch()?(this.addEvtListener(e.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.addEvtListener(e.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.addEvtListener(e.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.addEvtListener(e.MouseEvent.CLICK,this.HandleShapeClick,!1,this)):(this.addEvtListener(e.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.addEvtListener(e.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.addEvtListener(e.MouseEvent.CLICK,this.HandleShapeClick,!1,this)))},e.Overview.prototype.initDefaults=function(){this.Defaults=new t},e.Overview.prototype.setViewportRange=function(e,t,i,n){if(null!=e&&null!=t){var a=this.getDateXPosition(e),o=this.getDateXPosition(t);if(o>a){a<this.getMinimumPositionX()&&(a=this.getMinimumPositionX()),o>this.getMaximumPositionX()&&(o=this.getMaximumPositionX());var s=Math.max(o-a,this.getMinimumWindowWidth()),l=this.getSlidingWindow()
;this.isRTL()?this.setSlidingWindowPosX(l,this.Width-(a+s)):this.setSlidingWindowPosX(l,a),r._setSlidingWindowWidth(this,l,s)}}if(null!=i&&null!=n){var h=this.getDateYPosition(i),u=this.getDateYPosition(n);if(u>h){h<this.getMinimumPositionY()&&(h=this.getMinimumPositionY()),u>this.getMaximumPositionY()&&(u=this.getMaximumPositionY());var g=Math.max(u-h,this.getMinimumWindowHeight());l=this.getSlidingWindow(),this.setSlidingWindowPosY(l,h),r._setSlidingWindowHeight(this,l,g)}}r._updateBorderAroundSlidingWindow(this)},e.Overview.prototype.isFeatureOff=function(e){return null!=this._featuresOff&&-1!=this._featuresOff.indexOf(e)},e.Overview.prototype.isAnimationOnClick=function(){return!("off"===this._animationOnClick)},e.Overview.prototype.render=function(t,i,n){if(null!=i&&null!=n&&(this.Width=i,this.Height=n),null==t){var a=this.getSlidingWindow();if(this._xMin&&this._xMax){var o=this.getSlidingWindowPosX(a);null!=a&&0!=o&&(this._x1=e.OverviewUtils.getPositionDate(this._xMin,this._xMax,o,this.Width))}this._yMin&&this._yMax&&(o=this.getSlidingWindowPosY(a),null!=a&&0!=o&&(this._y1=e.OverviewUtils.getPositionDate(this._yMin,this._yMax,o,this.Height))),this.removeChildren()}else{this.SetOptions(t);var s=this.Parse(this.Options);this._applyParsedProperties(s)}r.renderOverview(this)},e.Overview.prototype.SetOptions=function(e){this.Options=this.Defaults.calcOptions(e)},e.Overview.prototype.getParser=function(t){return new e.OverviewParser(this)},e.Overview.prototype.Parse=function(e){return this.getParser(e).parse(e)},e.Overview.prototype._applyParsedProperties=function(t){this._xMin=t.xMin,this._xMax=t.xMax,this._x1=t.x1,this._x2=t.x2,this._yMin=t.yMin,this._yMax=t.yMax,this._y1=t.y1,this._y2=t.y2,this._currentTime=t.currentTime,this._animationOnClick=t.animationOnClick,this._leftMargin=Math.max(0,t.leftMargin),this._rightMargin=Math.max(0,t.rightMargin),isNaN(this._leftMargin)&&(this._leftMargin=0),isNaN(this._rightMargin)&&(this._rightMargin=0),this._orientation=t.orientation,this._isRtl=t.isRtl,null!=t.featuresOff&&(this._featuresOff=t.featuresOff.split(" ")),null!=t.minimumWindowSize&&t.minimumWindowSize>0&&(this._minimumWindowSize=t.minimumWindowSize),this._timeAxisInfo=t.timeAxisInfo,null!=t.timeAxisInfo&&(this._ticks=this._timeAxisInfo.ticks),this._formattedTimeRanges=t.formattedTimeRanges,this._borderTopStyle=n.getBorderTopStyle(this.Options),this._borderTopColor=n.getBorderTopColor(this.Options),this._windowBackgroundColor=n.getWindowBackgroundColor(this.Options),this._windowBackgroundAlpha=n.getWindowBackgroundAlpha(this.Options),this._windowBorderTopStyle=n.getWindowBorderTopStyle(this.Options),this._windowBorderRightStyle=n.getWindowBorderRightStyle(this.Options),this._windowBorderBottomStyle=n.getWindowBorderBottomStyle(this.Options),this._windowBorderLeftStyle=n.getWindowBorderLeftStyle(this.Options),this._windowBorderTopColor=n.getWindowBorderTopColor(this.Options),this._windowBorderRightColor=n.getWindowBorderRightColor(this.Options),this._windowBorderBottomColor=n.getWindowBorderBottomColor(this.Options),this._windowBorderLeftColor=n.getWindowBorderLeftColor(this.Options),this._handleTextureColor=n.getHandleTextureColor(this.Options),this._handleFillColor=n.getHandleFillColor(this.Options),this._horHandleBackgroundImage=n.getHandleBackgroundImage(this.Options,!1),this._horHandleWidth=n.getHandleWidth(this.Options,!1),this._horHandleHeight=n.getHandleHeight(this.Options,!1),this._vertHandleBackgroundImage=n.getHandleBackgroundImage(this.Options,!0),this._vertHandleWidth=n.getHandleWidth(this.Options,!0),this._vertHandleHeight=n.getHandleHeight(this.Options,!0),this._overviewBackgroundColor=n.getOverviewBackgroundColor(this.Options),this._currentTimeIndicatorColor=n.getCurrentTimeIndicatorColor(this.Options),this._timeIndicatorColor=n.getTimeIndicatorColor(this.Options),this._timeAxisBarColor=n.getTimeAxisBarColor(this.Options),this._timeAxisBarOpacity=n.getTimeAxisBarAlpha(this.Options),this._leftFilterPanelColor=n.getLeftFilterPanelColor(this.Options),this._leftFilterPanelAlpha=n.getLeftFilterPanelAlpha(this.Options),this._rightFilterPanelColor=n.getRightFilterPanelColor(this.Options),this._rightFilterPanelAlpha=n.getRightFilterPanelAlpha(this.Options),this._labelStyle=new e.CSSStyle("font-weight:bold")},e.Overview.prototype.getDateXPosition=function(t){return Math.max(this.getMinimumPositionX(),e.OverviewUtils.getDatePosition(this._xMin,this._xMax,t,this.getOverviewWidth())+this._leftMargin)},e.Overview.prototype.getDateYPosition=function(t){return Math.max(this.getMinimumPositionY(),e.OverviewUtils.getDatePosition(this._yMin,this._yMax,t,this.getOverviewHeight()))},e.Overview.prototype.getXPositionDate=function(t){return e.OverviewUtils.getPositionDate(this._xMin,this._xMax,Math.max(this.getMinimumPositionX()-this._leftMargin,t-this._leftMargin),this.getOverviewWidth())},e.Overview.prototype.getYPositionDate=function(t){return e.OverviewUtils.getPositionDate(this._yMin,this._yMax,Math.max(this.getMinimumPositionY(),t),this.getOverviewHeight())},e.Overview.prototype.isRTL=function(){return"true"==this._isRtl},e.Overview.prototype.isHorizontalRTL=function(){return this.isRTL()&&!this.isVertical()},e.Overview.prototype.isVertical=function(){return"vertical"==this._orientation},e.Overview.prototype.isOverviewAbove=function(){return"above"==this.Options.overviewPosition},e.Overview.prototype.setMargins=function(e,t){!isNaN(e)&&null!=e&&e>0&&(this._leftMargin=e),!isNaN(t)&&null!=t&&t>0&&(this._rightMargin=t)},e.Overview.prototype.getOverviewSize=function(){return this.isVertical()?this.Height-this._leftMargin-this._rightMargin:this.Width-this._leftMargin-this._rightMargin},e.Overview.prototype.getOverviewWidth=function(){return this.Width-this._leftMargin-this._rightMargin},e.Overview.prototype.getOverviewHeight=function(){return this.Height},e.Overview.prototype.getMinimumPositionX=function(){return this._leftMargin},e.Overview.prototype.getMinimumPositionY=function(){return 0},e.Overview.prototype.getMaximumPositionX=function(){return this.Width-this._rightMargin},e.Overview.prototype.getMaximumPositionY=function(){return this.Height},e.Overview.prototype.getMinimumWindowWidth=function(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=e.OverviewUtils.getDatePosition(this._xMin,this._xMax,this._xMin+this._minimumWindowSize,this.getOverviewWidth()),this._minWinSize):e.Overview.MIN_WINDOW_SIZE},e.Overview.prototype.getMinimumWindowHeight=function(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=e.OverviewUtils.getDatePosition(this._yMin,this._yMax,this._yMin+this._minimumWindowSize,this.getOverviewHeight()),this._minWinSize):e.Overview.MIN_WINDOW_SIZE},e.Overview.prototype.getMaximumWindowWidth=function(){return this.Width},e.Overview.prototype.getMaximumWindowHeight=function(){return this.Height},e.Overview.prototype.getGrippySize=function(){return 10},e.Overview.prototype.getHandleStart=function(){return e.OverviewUtils.supportsTouch()?this.getHandleSize()/2:0},e.Overview.prototype.getHandleSize=function(){return e.OverviewUtils.supportsTouch()?30:10},e.Overview.prototype.isHandle=function(e){var t=e.getId();return"lh"==t||"rh"==t||"lhb"==t||"rhb"==t||"th"==t||"bh"==t||"thb"==t||"bhb"==t||"hgrpy"==t||"vgrpy"==t||"lbgrh"==t||"rbgrh"==t||null!=e.getParent()&&("hgrpy"==e.getParent().getId()||"vgrpy"==e.getParent().getId())},e.Overview.prototype.isLeftOrRightHandle=function(e){var t=e.getId();return"lh"==t||"rh"==t||"lhb"==t||"rhb"==t||"hgrpy"==t||"lbgrh"==t||"rbgrh"==t||null!=e.getParent()&&"hgrpy"==e.getParent().getId()},e.Overview.prototype.isTopOrBottomHandle=function(e){var t=e.getId();return"th"==t||"bh"==t||"thb"==t||"bhb"==t||"vgrpy"==t||null!=e.getParent()&&"vgrpy"==e.getParent().getId()},e.Overview.prototype.getTimeAxisWidth=function(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisWidth){var t=parseInt(this._timeAxisInfo.width,10);!isNaN(t)&&t<this.Width?this._timeAxisWidth=t:this._timeAxisWidth=e.Overview.DEFAULT_VERTICAL_TIMEAXIS_SIZE}return this._timeAxisWidth},e.Overview.prototype.getTimeAxisHeight=function(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisHeight){var t=parseInt(this._timeAxisInfo.height,10);!isNaN(t)&&t<this.Height?this._timeAxisHeight=t:this._timeAxisHeight=e.Overview.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE}return this._timeAxisHeight},e.Overview.prototype.getPageX=function(t){return e.OverviewUtils.supportsTouch()&&null!=t.targetTouches?t.targetTouches.length>0?t.targetTouches[0].pageX:null:t.pageX},e.Overview.prototype.getPageY=function(t){return e.OverviewUtils.supportsTouch()&&null!=t.targetTouches?t.targetTouches.length>0?t.targetTouches[0].pageY:null:t.pageY},e.Overview.prototype.isBackgroundRendered=function(){return!0},e.Overview.prototype.isLeftAndRightFilterRendered=function(){return!1},e.Overview.prototype.getSlidingWindow=function(){return this.getChildAt(1)},e.Overview.prototype.getSlidingWindowWidth=function(){if(this.isHorizontalScrollingEnabled()){var t=Math.max(this.getMinimumPositionX(),e.OverviewUtils.getDatePosition(this._xMin,this._xMax,this._x1,this.Width));return Math.min(this.getMaximumPositionX(),Math.max(this.getMinimumPositionX(),e.OverviewUtils.getDatePosition(this._xMin,this._xMax,this._x2,this.Width)))-t}return this.Width},e.Overview.prototype.getSlidingWindowHeight=function(){if(this.isVerticalScrollingEnabled()){var t=Math.max(this.getMinimumPositionY(),e.OverviewUtils.getDatePosition(this._yMin,this._yMax,this._y1,this.Height));return Math.min(this.getMaximumPositionY(),Math.max(this.getMinimumPositionY(),e.OverviewUtils.getDatePosition(this._yMin,this._yMax,this._y2,this.Height)))-t}return this.Height},e.Overview.prototype.getLeftBackground=function(){return this.isLeftAndRightFilterRendered()?this.getChildAt(3):null},e.Overview.prototype.getRightBackground=function(){return this.isLeftAndRightFilterRendered()?this.getChildAt(4):null},e.Overview.prototype.getLeftBackgroundHandle=function(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(5):null},e.Overview.prototype.getRightBackgroundHandle=function(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(6):null},e.Overview.prototype.getLeftHandle=function(){return this._leftHandle},e.Overview.prototype.getRightHandle=function(){return this._rightHandle},e.Overview.prototype.getLeftTopBar=function(){var e=this._lastChildIndex-2;return this.getChildAt(this.getNumChildren()-e)},e.Overview.prototype.getRightTopBar=function(){var e=this._lastChildIndex-3;return this.getChildAt(this.getNumChildren()-e)},e.Overview.prototype.getBottomBar=function(){var e=this._lastChildIndex-4;return this.getChildAt(this.getNumChildren()-e)},e.Overview.prototype.getTopBar=function(){var e=this._lastChildIndex-5;return this.getChildAt(this.getNumChildren()-e)},e.Overview.prototype.setLinePos=function(e,t,i){this.isVertical()?(-1!=t&&e.setY1(t),-1!=i&&e.setY2(i)):(-1!=t&&e.setX1(t),-1!=i&&e.setX2(i))},e.Overview.prototype.setLinePosX=function(e,t,i){-1!=t&&e.setX1(t),-1!=i&&e.setX2(i)},e.Overview.prototype.setLinePosY=function(e,t,i){-1!=t&&e.setY1(t),-1!=i&&e.setY2(i)},e.Overview.prototype.getLinePos1=function(e){return this.isVertical()?e.getY1():e.getX1()},e.Overview.prototype._findDrawable=function(e){var t=e.target;if(null!=t){var i=t.getId();if(null==i)return null;if("_border"==i.substr(i.length-7))return this.getChildAfter(t);if("tick"!=i.substr(0,4)&&"ltb"!=i&&"rtb"!=i&&"bb"!=i&&"tab"!=i)return t}return null},e.Overview.prototype.isMovable=function(e){return!("window"!=e.getId()&&"ftr"!=e.getId()&&"sta"!=e.getId()&&!this.isHandle(e))},e.Overview.prototype.setRectPos=function(e,t){this.isVertical()?e.setY(t):e.setX(t)},e.Overview.prototype.getRectPos=function(e){return this.isVertical()?e.getY():e.getX()},e.Overview.prototype.getRectSize=function(e){return this.isVertical()?e.getHeight():e.getWidth()},e.Overview.prototype.setRectSize=function(e,t){this.isVertical()?e.setHeight(t):e.setWidth(t)},e.Overview.prototype.getSlidingWindowPos=function(e){return this.isVertical()?e.getTranslateY():e.getTranslateX()},e.Overview.prototype.getSlidingWindowPosX=function(e){return e.getTranslateX()},e.Overview.prototype.getSlidingWindowPosY=function(e){return e.getTranslateY()},e.Overview.prototype.setSlidingWindowPosX=function(t,i){if(i=Math.max(this.getMinimumPositionX(),i),t.setTranslateX(i),this.isLeftAndRightFilterRendered()){this.getLeftBackground().setWidth(i);var r=i+this.getSlidingWindowSize(t),n=this.getRightBackground();if(n.setX(r),n.setWidth(Math.max(0,this.Width-r)),e.OverviewUtils.supportsTouch()&&!this.isFeatureOff("zoom")){var a=this.getHandleStart();this.getLeftBackgroundHandle().setX(i-a),this.getRightBackgroundHandle().setX(r)}}},e.Overview.prototype.setSlidingWindowPosY=function(e,t){t=Math.max(this.getMinimumPositionY(),t),e.setTranslateY(t)},e.Overview.prototype.getSlidingWindowSize=function(e){return this.getRectSize(e)},e.Overview.prototype.renderData=function(e,t){},e.Overview.prototype.animateSlidingWindow=function(t,i){var r=this.getSlidingWindow();if(null!=t&&t!=this.getSlidingWindowPosX(r)||null!=i&&i!=this.getSlidingWindowPosY(r)){var n=this.getLeftHandle(),a=this.getRightHandle(),o=this.getLeftTopBar(),s=this.getRightTopBar(),l=this.getBottomBar(),h=this.getTopBar(),u=!1,g=this.isAnimationOnClick()?new e.Animator(this.getCtx(),.5,0,e.Easing.linear):null;if(this.isVerticalScrollingEnabled()&&null!=i){var d=r.getTranslateY,p=r.setTranslateY,c=n.getY1,_=n.setY1,f=n.getY2,m=n.setY2,v=a.getY1,y=a.setY1,S=a.getY2,C=a.setY2,A=l.getY1,b=l.setY1,x=l.getY2,M=l.setY2,O=h.getY1,T=h.setY1,w=h.getY2,D=h.setY2,E=this.getMinimumPositionY(),I=this.getMaximumPositionY(),P=r.getHeight();i=Math.max(E,Math.min(I-P,i)),this.animateProperty(g,r,d,p,i),this.isVertical()?(this.animateProperty(g,n,c,_,i),this.animateProperty(g,n,f,m,i),this.animateProperty(g,a,v,y,i+P),this.animateProperty(g,a,S,C,i+P),this.animateProperty(g,l,A,b,i),this.animateProperty(g,h,O,T,i),this.animateProperty(g,l,x,M,i+P),this.animateProperty(g,h,w,D,i+P),this.animateProperty(g,o,o.getY2,o.setY2,i+1),this.animateProperty(g,s,s.getY1,s.setY1,i+P-1)):(this.animateProperty(g,n,c,_,i),this.animateProperty(g,n,f,m,i+P),this.animateProperty(g,a,v,y,i),this.animateProperty(g,a,S,C,i+P),this.animateProperty(g,l,A,b,i+P),this.animateProperty(g,h,O,T,i),this.animateProperty(g,l,x,M,i+P),this.animateProperty(g,h,w,D,i)),u=!0}if(this.isHorizontalScrollingEnabled()&&null!=t){var L=r.getTranslateX,R=r.setTranslateX,B=n.getX1,k=n.setX1,z=n.getX2,H=n.setX2,F=a.getX1,N=a.setX1,W=a.getX2,G=a.setX2,j=l.getX1,U=l.setX1,V=l.getX2,X=l.setX2,q=h.getX1,Y=h.setX1,K=h.getX2,Z=h.setX2,J=this.getMinimumPositionX(),Q=this.getMaximumPositionX(),$=r.getWidth();t=Math.max(J,Math.min(Q-$,t)),this.animateProperty(g,r,L,R,t),this.animateProperty(g,n,B,k,t),this.animateProperty(g,n,z,H,t),this.animateProperty(g,a,F,N,t+$),this.animateProperty(g,a,W,G,t+$),this.isVertical()||(this.animateProperty(g,o,o.getX2,o.setX2,t+1),this.animateProperty(g,s,s.getX1,s.setX1,t+$-1)),this.animateProperty(g,l,j,U,t),this.animateProperty(g,h,q,Y,t),this.animateProperty(g,l,V,X,t+$),this.animateProperty(g,h,K,Z,t+$),u=!0}if(this.isLeftAndRightFilterRendered()){var ee=this.getLeftBackground(),te=ee.getWidth,ie=ee.setWidth;this.animateProperty(g,ee,te,ie,t);var re=t+$,ne=this.getRightBackground(),ae=ne.getWidth,oe=ne.setWidth,se=ne.getX,le=ne.setX;if(this.animateProperty(g,ne,ae,oe,this.Width-re),this.animateProperty(g,ne,se,le,re),e.OverviewUtils.supportsTouch()&&!this.isFeatureOff("zoom")){var he=this.getHandleStart(),ue=this.getLeftBackgroundHandle(),ge=ue.getX,de=ue.setX,pe=this.getRightBackgroundHandle(),ce=pe.getX,_e=pe.setX;this.animateProperty(g,ue,ge,de,t-he),this.animateProperty(g,pe,ce,_e,re)}u=!0}null!=g&&u&&g.play()}},e.Overview.prototype.animateProperty=function(t,i,r,n,a){null!=t?t.addProp(e.Animator.TYPE_NUMBER,i,r,n,a):n.call(i,a)},e.Overview.prototype.HandleShapeMouseOver=function(t){var i=this._findDrawable(t);if(i&&"bg"!=i.getId()&&"ocd"!=i.getId())if("label"==i.getId().substr(0,5)&&(i instanceof e.OutputText||i instanceof e.BackgroundOutputText))i.isTruncated()&&this.getCtx().getTooltipManager().showDatatip(t.pageX,t.pageY,i._rawText,"#000000");else if("window"!=i.getId()&&"ftr"!=i.getId()&&"arr"!=i.getId()&&!this.isHandle(i))return i},e.Overview.prototype.HandleShapeMouseOut=function(e){null==this._moveDrawable&&this.setCursor("default");var t=this._findDrawable(e);if(null!=t)return t},e.Overview.prototype.HandleShapeClick=function(t,i,r){t.stopPropagation();var n=this._findDrawable(t);if(n&&"window"!=n.getId()&&!this.isHandle(n)){if("bg"!=n.getId()&&"label"!=n.getId().substr(0,5)&&"ocd"!=n.getId()&&"lbg"!=n.getId()&&"rbg"!=n.getId())return n;null==i&&(i=t.pageX),null==r&&(r=t.pageY);var a=this.getCtx().pageToStageCoords(i,r);a=this.stageToLocal(a);var o,s,l,h,u=this.getSlidingWindow();if(this.isVerticalScrollingEnabled())var g=a.y,d=this.Height,p=g-u.getHeight()/2;if(this.isHorizontalScrollingEnabled()){var c=a.x,_=this.Width,f=c-u.getWidth()/2;this.isRTL()&&(c=_-c)}if(this.animateSlidingWindow(f,p),null!=f){var m=u.getWidth();f=Math.max(this.getMinimumPositionX(),Math.min(f,_-m)),this.isRTL()?(o=this.getXPositionDate(_-(f+m)),s=this.getXPositionDate(_-f)):(o=this.getXPositionDate(f),s=this.getXPositionDate(f+m))}if(null!=p){var v=u.getHeight();p=Math.max(this.getMinimumPositionY(),Math.min(p,d-v)),l=this.getYPositionDate(p),h=this.getYPositionDate(p+v)}var y=e.EventFactory.newOverviewEvent("scrollTime",o,s,l,h);this.dispatchEvent(y)}},e.Overview.prototype.beginDragPan=function(t,i,r){var n=this._findDrawable(t);if(null!=n&&this.isMovable(n)){if("ftr"!=n.getId()&&"sta"!=n.getId()||(n=this.getSlidingWindow()),this._initX=i,this._initY=r,this.isHandle(n)){var a=this.getSlidingWindow();"hgrpy"!=n.getParent().getId()&&"vgrpy"!=n.getParent().getId()||(n=n.getParent());var o=n.getId();"hgrpy"!=o&&"vgrpy"!=o||(o=(n=a.getChildBefore(n)).getId()),"lh"!=o&&"rh"!=o&&"th"!=o&&"bh"!=o||(o=(n=a.getChildBefore(n)).getId()),"lbgrh"==o&&(n=a.getChildAt(0)),"rbgrh"==o&&(n=a.getChildAt(a.getNumChildren()-3)),this.isLeftOrRightHandle(n)?(this._isHorizontalResize=!0,this.isRTL()?(this._oldEndPosX=this.Width-a.getX(),this._oldStartPosX=this._oldEndPosX-a.getWidth()):(this._oldStartPosX=a.getX(),this._oldEndPosX=this._oldStartPosX+a.getWidth()),e.OverviewUtils.supportsTouch()||(n.setX(0-e.Overview.HANDLE_PADDING_SIZE),n.setWidth(2*(n.getWidth()+e.Overview.HANDLE_PADDING_SIZE)))):(this._isHorizontalResize=!1,this._oldStartPosY=a.getY(),this._oldEndPosY=this._oldStartPosY+a.getHeight(),e.OverviewUtils.supportsTouch()||(n.setY(0-e.Overview.HANDLE_PADDING_SIZE),n.setHeight(2*(n.getHeight()+e.Overview.HANDLE_PADDING_SIZE)))),this.overrideCursors(n.getCursor())}this._moveDrawable=n;var s=e.EventFactory.newOverviewEvent("dropCallback");return this.dispatchEvent(s),!0}return!1},e.Overview.prototype.overrideCursors=function(e){var t=this.getSlidingWindow();if(null!=t&&t.setCursor(e),this.isLeftAndRightFilterRendered()){var i=this.getLeftBackground(),r=this.getRightBackground();null!=i&&null!=r&&(i.setCursor(e),r.setCursor(e))}},e.Overview.prototype.resetCursors=function(){var e=this.getSlidingWindow();if(null!=e&&e.setCursor("move"),this.isLeftAndRightFilterRendered()){var t=this.getLeftBackground(),i=this.getRightBackground();null!=t&&null!=i&&(t.setCursor("default"),i.setCursor("default"))}},e.Overview.prototype.endDragPan=function(){null!=this._moveDrawable&&1==this._isDragPanning&&("window"==this._moveDrawable.getId()?this.handleWindowDrag("scrollEnd"):this.isHandle(this._moveDrawable)&&(this.finishHandleDrag(0,0),e.OverviewUtils.supportsTouch()||(this.isTopOrBottomHandle(this._moveDrawable)?(this._moveDrawable.setY(0),this._moveDrawable.setHeight(this.getHandleSize())):this.isLeftOrRightHandle(this._moveDrawable)&&(this._moveDrawable.setX(0),this._moveDrawable.setWidth(this.getHandleSize()))),this.resetCursors()),this._isDragPanning=!1,this._moveDrawable=null,this._initX=-1)},e.Overview.prototype.contDragPan=function(e,t,i){if(null!=this._moveDrawable&&-1!=this._initX){this._isDragPanning=!0;var r=t-this._initX,n=i-this._initY;this._initX=t,this._initY=i,"window"==this._moveDrawable.getId()?this.handleWindowDrag("scrollPos",r,n):"lh"==this._moveDrawable.getId()||"lhb"==this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(e,r,!0):"rh"==this._moveDrawable.getId()||"rhb"==this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(e,r,!1):"th"==this._moveDrawable.getId()||"thb"==this._moveDrawable.getId()?this.handleTopOrBottomHandleDragPositioning(e,n,!0):"bh"!=this._moveDrawable.getId()&&"bhb"!=this._moveDrawable.getId()||this.handleTopOrBottomHandleDragPositioning(e,n,!1)}},e.Overview.prototype.HandleTouchStart=function(e){var t=e.touches;this._touchStartX=t[0].pageX,this._touchStartY=t[0].pageY,2==t.length&&(e.preventDefault(),this._touchStartX2=t[1].pageX,this._touchStartY2=t[1].pageY,Math.abs(this._touchStartY-this._touchStartY2)<20?this._counter=0:(this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null))},e.Overview.prototype.HandleTouchMove=function(e){e.preventDefault();var t=e.touches;if(null!=this._touchStartX2&&null!=this._touchStartY2){if(this._counter<50)return void this._counter++;var i=t[1].pageX-this._touchStartX2;this.handleRightHandleDragPositioning(null,i,0),this._touchStartX2=t[1].pageX,this._counter=0}else{var r=Math.abs(this._touchStartX-t[0].pageX),n=Math.abs(this._touchStartY-t[0].pageY);(r>3||n>3)&&(this._touchStartX=null,this._touchStartY=null)}},e.Overview.prototype.HandleTouchEnd=function(e){null!=this._touchStartX2&&null!=this._touchStartY2?this.finishHandleDrag(0,0):null!=this._touchStartX&&null!=this._touchStartY&&this.HandleShapeClick(e,this._touchStartX,this._touchStartY),this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null},e.Overview.prototype.stopDragAction=function(){this.endDragPan()},e.Overview.prototype.handleWindowDrag=function(e,t,i){var n,a,o,s,l=this.getSlidingWindow(),h=!1,u=this.getSlidingWindowPosX(l),g=this.getSlidingWindowPosY(l),d=l.getWidth(),p=l.getHeight();if("scrollPos"===e){if(this.isHorizontalScrollingEnabled()&&0!==t){var c=this.getMinimumPositionX(),_=this.getMaximumPositionX();u+t<=c?this.setSlidingWindowPosX(l,c):u+d+t>=_?this.setSlidingWindowPosX(l,_-d):this.setSlidingWindowPosX(l,u+t);var f=this.getSlidingWindowPosX(l);f!==u&&(u=f,h=!0)}if(this.isVerticalScrollingEnabled()&&0!==i){var m=this.getMinimumPositionY(),v=this.getMaximumPositionY();g+i<=m?this.setSlidingWindowPosY(l,m):g+p+i>=v?this.setSlidingWindowPosY(l,v-p):this.setSlidingWindowPosY(l,g+i);var y=this.getSlidingWindowPosY(l);y!==g&&(g=y,h=!0)}h&&r._updateBorderAroundSlidingWindow(this)}this.isHorizontalScrollingEnabled()&&(this.isRTL()?(n=this.getXPositionDate(this.Width-(u+d)),a=this.getXPositionDate(this.Width-u)):(n=this.getXPositionDate(u),a=this.getXPositionDate(u+d))),this.isVerticalScrollingEnabled()&&(o=this.getYPositionDate(g),s=this.getYPositionDate(g+p)),this.fireScrollEvent(e,n,a,o,s)},e.Overview.prototype.fireScrollEvent=function(t,i,r,n,a){var o,s,l,h;this.isHorizontalScrollingEnabled()&&(o=i,s=r),this.isVerticalScrollingEnabled()&&(l=n,h=a);var u=e.EventFactory.newOverviewEvent(t,o,s,l,h);this.dispatchEvent(u)},e.Overview.prototype.handleLeftOrRightHandleDragPositioning=function(t,i,n){if(0!=i){var a=this.getSlidingWindow(),o=this.getSlidingWindowPosX(a),s=a.getWidth();if(n){if(s-i<=this.getMinimumWindowWidth())return;if(o+i<=this.getMinimumPositionX())return;var l=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).x;if(l=this.stageToLocal(l),i>0&&l<=o)return;if(i<0&&l>=o)return;this.setSlidingWindowPosX(a,o+i),r._setSlidingWindowWidth(this,a,s-i)}else{if(s+i<=this.getMinimumWindowWidth())return;if(o+s+i>=this.getMaximumPositionX())return;if(l=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).x,l=this.stageToLocal(l),i>0&&l<=o+s)return;if(i<0&&l>=o+s)return;r._setSlidingWindowWidth(this,a,s+i)}if(r._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var h,u;this.isRTL()?(h=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(a)+a.getWidth())),u=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(a))):(h=this.getXPositionDate(this.getSlidingWindowPosX(a)),u=this.getXPositionDate(this.getSlidingWindowPosX(a)+a.getWidth()));var g=e.EventFactory.newOverviewEvent("rangeChanging",h,u);this.dispatchEvent(g)}}},e.Overview.prototype.handleTopOrBottomHandleDragPositioning=function(t,i,n){if(0!=i){var a=this.getSlidingWindow(),o=this.getSlidingWindowPosY(a),s=a.getHeight();if(n){if(s-i<=this.getMinimumWindowHeight())return;if(o+i<=this.getMinimumPositionY())return;var l=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).y;if(l=this.stageToLocal(l),i>0&&l<=o)return;if(i<0&&l>=o)return;this.setSlidingWindowPosY(a,o+i),r._setSlidingWindowHeight(this,a,s-i)}else{if(s+i<=this.getMinimumWindowHeight())return;if(o+s+i>=this.getMaximumPositionY())return;if(l=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).y,l=this.stageToLocal(l),i>0&&l<=o+s)return;if(i<0&&l>=o+s)return;r._setSlidingWindowHeight(this,a,s+i)}if(r._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var h=this.getYPositionDate(this.getSlidingWindowPosY(a)),u=this.getYPositionDate(this.getSlidingWindowPosY(a)+a.getHeight()),g=e.EventFactory.newOverviewEvent("rangeChanging",void 0,void 0,h,u);this.dispatchEvent(g)}}},e.Overview.prototype.isHorizontalScrollingEnabled=function(){return null!=this._xMin&&null!=this._xMax},e.Overview.prototype.isVerticalScrollingEnabled=function(){return null!=this._yMin&&null!=this._yMax},e.Overview.prototype.isRangeChangingSupported=function(){return!0},e.Overview.prototype.finishHandleDrag=function(t,i){var r,n=this.getSlidingWindow();if(this._isHorizontalResize){var a=this.getXPositionDate(this._oldStartPosX),o=this.getXPositionDate(this._oldEndPosX);if(this.isRTL())var s=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(n)+n.getWidth())),l=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(n));else s=this.getXPositionDate(this.getSlidingWindowPosX(n)),l=this.getXPositionDate(this.getSlidingWindowPosX(n)+n.getWidth());r=e.EventFactory.newOverviewEvent("rangeChange",s,l,void 0,void 0,a,o)}else{var h=this.getYPositionDate(this._oldStartPosY),u=this.getYPositionDate(this._oldEndPosY),g=this.getYPositionDate(this.getSlidingWindowPosY(n)),d=this.getYPositionDate(this.getSlidingWindowPosY(n)+n.getHeight());r=e.EventFactory.newOverviewEvent("rangeChange",void 0,void 0,g,d,void 0,void 0,h,u)}this.dispatchEvent(r)},e.Overview.prototype.dispatchEvent=function(e){this._callback.call(this._callbackObj,e,this)},e.Overview.prototype.destroy=function(){this.EventManager&&(this.EventManager.removeListeners(this),this.EventManager.destroy(),this.EventManager=null),e.OverviewUtils.supportsTouch()?(this.removeEvtListener(e.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.removeEvtListener(e.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.removeEvtListener(e.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.removeEvtListener(e.MouseEvent.CLICK,this.HandleShapeClick,!1,this)):(this.removeEvtListener(e.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.removeEvtListener(e.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.removeEvtListener(e.MouseEvent.CLICK,this.HandleShapeClick,!1,this),this.removeEvtListener(e.KeyboardEvent.KEYDOWN,this.HandleKeyDown,!1,this),this.removeEvtListener(e.KeyboardEvent.KEYUP,this.HandleKeyUp,!1,this)),e.Overview.superclass.destroy.call(this)};var t=function(){this.Init({alta:t.VERSION_1})};e.Obj.createSubclass(t,e.BaseComponentDefaults),t.VERSION_1={overviewPosition:"below",style:{currentTimeIndicatorColor:"#c000d1",handleFillColor:"#ffffff",handleTextureColor:"#b3c6db",leftFilterPanelAlpha:.7,leftFilterPanelColor:"#ffffff",overviewBackgroundColor:"#e6ecf3",rightFilterPanelAlpha:.7,rightFilterPanelColor:"#ffffff",timeAxisBarColor:"#e5e5e5",timeAxisBarAlpha:1,timeIndicatorColor:"#bcc7d2",windowBackgroundAlpha:1,windowBackgroundColor:"#ffffff",windowBorderBottomColor:"#4f4f4f",windowBorderBottomStyle:"solid",windowBorderLeftColor:"#4f4f4f",windowBorderLeftStyle:"solid",windowBorderRightColor:"#4f4f4f",windowBorderRightStyle:"solid",windowBorderTopColor:"#4f4f4f",windowBorderTopStyle:"solid"}},e.OverviewParser=function(e){this.Init(e)},e.Obj.createSubclass(e.OverviewParser,e.Obj),e.OverviewParser.prototype.Init=function(e){this._view=e},e.OverviewParser.prototype.parse=function(e){var t=e;return this.ParseRootAttributes(t)},e.OverviewParser.prototype.ParseRootAttributes=function(t){var i=new Object;return i.animationOnClick=t.animationOnClick,null!=t.xMin&&(i.xMin=t.xMin),null!=t.xMax&&(i.xMax=t.xMax),null!=t.x1&&(i.x1=t.x1),null!=t.x2&&(i.x2=t.x2),null!=t.yMin&&(i.yMin=t.yMin),null!=t.yMax&&(i.yMax=t.yMax),null!=t.y1&&(i.y1=t.y1),null!=t.y2&&(i.y2=t.y2),null!=t.currentTime&&(i.currentTime=t.currentTime),i.orientation="horizontal",null!=t.orientation&&(i.orientation=t.orientation),i.featuresOff=t.featuresOff,i.minimumWindowSize=t.minimumWindowSize,i.leftMargin=t.leftMargin,i.rightMargin=t.rightMargin,i.overviewPosition="below",i.selectionMode="none",i.isRtl=e.Agent.isRightToLeft(this._view.getCtx()).toString(),null!=t.rtl&&(i.isRtl=t.rtl.toString()),i},e.OverviewParser.prototype.calculateWidth=function(e,t,i,r,n){var a=n*(t-e),o=r-i;return 0==a||0==o?0:a/o};var i=function(e){this.Init(e.getCtx(),e.processEvent,e),this._overview=e};e.Obj.createSubclass(i,e.EventManager),i.prototype.addListeners=function(t){e.SvgDocumentUtils.addDragListeners(this._overview,this._onDragStart,this._onDragMove,this._onDragEnd,this)},i.prototype._onDragStart=function(t){return e.Agent.isTouchDevice()?this._onTouchDragStart(t):this._onMouseDragStart(t)},i.prototype._onDragMove=function(t){return e.Agent.isTouchDevice()?this._onTouchDragMove(t):this._onMouseDragMove(t)},i.prototype._onDragEnd=function(t){return e.Agent.isTouchDevice()?this._onTouchDragEnd(t):this._onMouseDragEnd(t)},i.prototype._getRelativePosition=function(t,i){return this._stageAbsolutePosition||(this._stageAbsolutePosition=this._context.getStageAbsolutePosition()),new e.Point(t-this._stageAbsolutePosition.x,i-this._stageAbsolutePosition.y)},i.prototype._onMouseDragStart=function(t){if(t.button!=e.MouseEvent.RIGHT_CLICK_BUTTON){var i=this._getRelativePosition(t.pageX,t.pageY);return this._overview.beginDragPan(t,i.x,i.y)}return!1},i.prototype._onMouseDragMove=function(e){var t=this._getRelativePosition(e.pageX,e.pageY);return this._overview.contDragPan(e,t.x,t.y),!0},i.prototype._onMouseDragEnd=function(e){this._overview.endDragPan(),this._stageAbsolutePosition=null},i.prototype._onTouchDragStart=function(e){var t=e.touches;if(e.stopPropagation(),1==t.length){var i=this._getRelativePosition(t[0].pageX,t[0].pageY);return e.preventDefault(),this._overview.beginDragPan(e,i.x,i.y)}return!1},i.prototype._onTouchDragMove=function(e){var t=e.touches;if(1==t.length){var i=this._getRelativePosition(t[0].pageX,t[0].pageY);this._overview.contDragPan(e,i.x,i.y),e.preventDefault()}e.stopPropagation()},i.prototype._onTouchDragEnd=function(t){this._overview.endDragPan(),e.EventManager.consumeEvent(t),this._stageAbsolutePosition=null};var r=new Object;e.Obj.createSubclass(r,e.Obj),r.renderOverview=function(e){e.isBackgroundRendered()&&r._renderBackground(e);var t=null!=e._callback||null!=e._callbackObj;t&&r._renderSlidingWindow(e),r._renderTimeAxis(e),r._parseFilledTimeRanges(e),r._updateCurrentTime(e),e.renderData(e.Width,e.Height),t&&(r._createBorderAroundSlidingWindow(e),r._updateSlidingWindow(e))},r._renderBackground=function(t){
var i=new e.Rect(t.getCtx(),0,0,t.Width,t.Height,"bg");i.setSolidFill(t._overviewBackgroundColor),i.setPixelHinting(!0),t.addChild(i)},r._renderSlidingWindow=function(t){var i=t.Width,n=t.Height,a=new e.Rect(t.getCtx(),0,0,i,n,"window");if(a.setSolidFill(t._windowBackgroundColor,t._windowBackgroundAlpha),a.setPixelHinting(!0),!t.isFeatureOff("zoom")){var o=t.getHandleSize(),s=t.getHandleStart(),l=t.getGrippySize();if(t.isVerticalScrollingEnabled()){var h=t.getSlidingWindowWidth(),u=e.PathUtils.moveTo(0,0)+e.PathUtils.quadTo(3,6,8,8)+e.PathUtils.lineTo(28,8)+e.PathUtils.quadTo(33,6,36,0);e.PathUtils.closePath();var g=e.PathUtils.moveTo(0,0)+e.PathUtils.quadTo(3,-6,8,-8)+e.PathUtils.lineTo(28,-8)+e.PathUtils.quadTo(33,-6,36,0);e.PathUtils.closePath();var d=new e.Rect(t.getCtx(),0,0,h,o,"thb"),p=new e.Rect(t.getCtx(),0,0,h,o,"bhb");if(b="row-resize",t._vertHandleBackgroundImage)var c=r._createGrippyImage(t,h,l,!0),_=r._createGrippyImage(t,h,l,!0);else c=r._createGrippy(t,!0),_=r._createGrippy(t,!0);d.setSolidFill(t._windowBackgroundColor,0),p.setSolidFill(t._windowBackgroundColor,0),d.setPixelHinting(!0),p.setPixelHinting(!0);var f=new e.Path(t.getCtx(),u,"th"),m=new e.Path(t.getCtx(),g,"bh");f.setSolidFill(t._handleFillColor),f.setSolidStroke(t._handleFillColor),m.setSolidFill(t._handleFillColor),m.setSolidStroke(t._handleFillColor),t._windowBackgroundColor==t._handleFillColor&&(f.setPixelHinting(!0),m.setPixelHinting(!0)),d.setCursor(b),p.setCursor(b),f.setCursor(b),m.setCursor(b),c.setCursor(b),_.setCursor(b),a.addChild(d),t._windowTopHandleBackground=d,a.addChild(f),t._windowTopHandle=f,a.addChild(c),t._windowTopGrippy=c,a.addChild(p),t._windowBottomHandleBackground=p,a.addChild(m),t._windowBottomHandle=m,a.addChild(_),t._windowBottomGrippy=_}if(t.isHorizontalScrollingEnabled()){var v=t.getSlidingWindowHeight(),y=e.PathUtils.moveTo(0,0)+e.PathUtils.quadTo(6,3,8,8)+e.PathUtils.lineTo(8,28)+e.PathUtils.quadTo(6,33,0,36);e.PathUtils.closePath();var S=e.PathUtils.moveTo(0,0)+e.PathUtils.quadTo(-6,3,-8,8)+e.PathUtils.lineTo(-8,28)+e.PathUtils.quadTo(-6,33,0,36);e.PathUtils.closePath();var C=new e.Rect(t.getCtx(),0-s,0,o,v,"lhb"),A=new e.Rect(t.getCtx(),s,0,o,v,"rhb"),b="col-resize";if(t._horHandleBackgroundImage)var x=r._createGrippyImage(t,l,v,!1),M=r._createGrippyImage(t,l,v,!1);else x=r._createGrippy(t,!1),M=r._createGrippy(t,!1);C.setSolidFill(t._windowBackgroundColor,0),A.setSolidFill(t._windowBackgroundColor,0),C.setPixelHinting(!0),A.setPixelHinting(!0);var O=new e.Path(t.getCtx(),y,"lh"),T=new e.Path(t.getCtx(),S,"rh");O.setSolidFill(t._handleFillColor),O.setSolidStroke(t._handleFillColor),T.setSolidFill(t._handleFillColor),T.setSolidStroke(t._handleFillColor),t._windowBackgroundColor==t._handleFillColor&&(O.setPixelHinting(!0),T.setPixelHinting(!0)),C.setCursor(b),A.setCursor(b),O.setCursor(b),T.setCursor(b),x.setCursor(b),M.setCursor(b),a.addChild(C),t._windowLeftHandleBackground=C,a.addChild(O),t._windowLeftHandle=O,a.addChild(x),t._windowLeftGrippy=x,a.addChild(A),t._windowRightHandleBackground=A,a.addChild(T),t._windowRightHandle=T,a.addChild(M),t._windowRightGrippy=M}}a.setCursor("move"),t.addChild(a),r._renderTimeAxisTopBar(t),r._renderLeftAndRightFilters(t,s)},r._createGrippyImage=function(t,i,r,n){if(n){var a=(r-t._vertHandleHeight)/2;s=new e.Image(t.getCtx(),t._vertHandleBackgroundImage,0,a,t._vertHandleWidth,t._vertHandleHeight,"vgrpy")}else var o=(i-t._horHandleWidth)/2,s=new e.Image(t.getCtx(),t._horHandleBackgroundImage,o,0,t._horHandleWidth,t._horHandleHeight,"hgrpy");return s.setMouseEnabled(!1),s},r._createGrippy=function(t,i){var r=t._handleTextureColor;if(i){for(var n=new e.Container(t.getCtx(),"vgrpy"),a=8,o=3,s=0;s<9;s++){var l=new e.Line(t.getCtx(),a+2*s,o,a+2*s+1,o,"dot1"+s);l.setSolidStroke(r),n.addChild(l),o+=2,(l=new e.Line(t.getCtx(),a+1+2*s,o,a+1+2*s+1,o,"dot2"+s)).setSolidStroke(r),n.addChild(l),o+=2,(l=new e.Line(t.getCtx(),a+2*s,o,a+2*s+1,o,"dot3"+s)).setSolidStroke(r),n.addChild(l),o=3}(l=new e.Line(t.getCtx(),a+18,o,a+18+1,o,"dot4")).setSolidStroke(r),n.addChild(l),o+=4,(l=new e.Line(t.getCtx(),a+18,o,a+18+1,o,"dot5")).setSolidStroke(r),n.addChild(l)}else{for(n=new e.Container(t.getCtx(),"hgrpy"),a=3,o=8,s=0;s<9;s++)(l=new e.Line(t.getCtx(),a,o+2*s,a,o+2*s+1,"dot1"+s)).setSolidStroke(r),n.addChild(l),a+=2,(l=new e.Line(t.getCtx(),a,o+1+2*s,a,o+1+2*s+1,"dot2"+s)).setSolidStroke(r),n.addChild(l),a+=2,(l=new e.Line(t.getCtx(),a,o+2*s,a,o+2*s+1,"dot3"+s)).setSolidStroke(r),n.addChild(l),a=3;(l=new e.Line(t.getCtx(),a,o+18,a,o+18+1,"dot4")).setSolidStroke(r),n.addChild(l),a+=4,(l=new e.Line(t.getCtx(),a,o+18,a,o+18+1,"dot5")).setSolidStroke(r),n.addChild(l)}return n.setPixelHinting(!0),n},r._createBorderAroundSlidingWindow=function(t){var i=t.Width,r=t.Height,a=t.getSlidingWindow(),o=n._DEFAULT_WINDOW_BORDER_WIDTH/2;if(t.isVertical())var s=a.getY(),l=s+o,h=s+a.getHeight(),u=h-o,g=0,d=o,p=i,c=p-o,_=new e.Line(t.getCtx(),g,l,i,l,"lh"),f=new e.Line(t.getCtx(),g,u,i,u,"rh"),m=new e.Line(t.getCtx(),d,0,d,s,"ltb"),v=new e.Line(t.getCtx(),d,h,d,r,"rtb"),y=new e.Line(t.getCtx(),c,s,c,h,"bb"),S=new e.Line(t.getCtx(),d,s,d,h,"tb");else l=(s=0)+o,u=(h=r)-o,d=(g=a.getX())+o,c=(p=g+a.getWidth())-o,_=new e.Line(t.getCtx(),d,s,d,h,"lh"),f=new e.Line(t.getCtx(),c,s,c,h,"rh"),m=new e.Line(t.getCtx(),0,l,g+1,l,"ltb"),v=new e.Line(t.getCtx(),p-1,l,i,l,"rtb"),y=new e.Line(t.getCtx(),g,u,p,u,"bb"),S=new e.Line(t.getCtx(),g,l,p,l,"tb");_.setPixelHinting(!0),f.setPixelHinting(!0),m.setPixelHinting(!0),v.setPixelHinting(!0),y.setPixelHinting(!0),S.setPixelHinting(!0),"none"!=t._windowBorderLeftStyle&&_.setSolidStroke(t._windowBorderLeftColor),t.addChild(_),t._leftHandle=_,"none"!=t._windowBorderRightStyle&&f.setSolidStroke(t._windowBorderRightColor),t.addChild(f),t._rightHandle=f,"none"!=t._borderTopStyle&&t._borderTopColor&&(m.setSolidStroke(t._borderTopColor),v.setSolidStroke(t._borderTopColor)),t.addChild(m),t.addChild(v),"none"!=t._windowBorderBottomStyle&&y.setSolidStroke(t._windowBorderBottomColor),t.addChild(y),"none"!=t._windowBorderTopStyle&&S.setSolidStroke(t._windowBorderTopColor),t.addChild(S)},r._updateBorderAroundSlidingWindow=function(e){var t=e.getSlidingWindow(),i=n._DEFAULT_WINDOW_BORDER_WIDTH/2,r=e.getLeftHandle(),a=e.getRightHandle(),o=e.getLeftTopBar(),s=e.getRightTopBar(),l=e.getBottomBar(),h=e.getTopBar();if(e.isVertical()){if(e.isHorizontalScrollingEnabled()){var u=t.getWidth(),g=e.getSlidingWindowPosX(t),d=g+i,p=g+u-i;e.setLinePosX(r,d,p),e.setLinePosX(a,d,p),e.setLinePosX(h,d,d),e.setLinePosX(l,p,p)}if(e.isVerticalScrollingEnabled()){var c=t.getHeight(),_=e.getSlidingWindowPosY(t),f=_+i,m=_+c-i;e.setLinePosY(r,f,f),e.setLinePosY(a,m,m),e.setLinePosY(h,f,m),e.setLinePosY(l,f,m)}}else e.isHorizontalScrollingEnabled()&&(u=t.getWidth(),d=(g=e.getSlidingWindowPosX(t))+i,p=g+u-i,e.setLinePosX(r,d,d),e.setLinePosX(a,p,p),e.setLinePosX(h,d,p),e.setLinePosX(l,d,p)),e.isVerticalScrollingEnabled()&&(c=t.getHeight(),f=(_=e.getSlidingWindowPosY(t))+i,m=_+c-i,e.setLinePosY(r,f,m),e.setLinePosY(a,f,m),e.setLinePosY(h,f,f),e.setLinePosY(l,m,m));e.setLinePos(o,-1,e.getSlidingWindowPos(t)),e.setLinePos(s,e.getLinePos1(a),-1)},r._updateSlidingWindow=function(t){var i=t.getSlidingWindow(),n=t.Width,a=t.Height;if(t.isHorizontalScrollingEnabled()){var o=Math.max(t.getMinimumPositionX(),e.OverviewUtils.getDatePosition(t._xMin,t._xMax,t._x1,n)),s=Math.min(t.getMaximumPositionX(),Math.max(t.getMinimumPositionX(),e.OverviewUtils.getDatePosition(t._xMin,t._xMax,t._x2,n)));t.isRTL()?t.setSlidingWindowPosX(i,n-s):t.setSlidingWindowPosX(i,o),r._setSlidingWindowWidth(t,i,s-o)}else r._setSlidingWindowWidth(t,i,n);if(t.isVerticalScrollingEnabled()){var l=Math.max(t.getMinimumPositionY(),e.OverviewUtils.getDatePosition(t._yMin,t._yMax,t._y1,a)),h=Math.min(t.getMaximumPositionY(),Math.max(t.getMinimumPositionY(),e.OverviewUtils.getDatePosition(t._yMin,t._yMax,t._y2,a)));t.setSlidingWindowPosY(i,l),r._setSlidingWindowHeight(t,i,h-l)}else r._setSlidingWindowHeight(t,i,a);r._updateBorderAroundSlidingWindow(t)},r._setSlidingWindowWidth=function(t,i,r){if(r=Math.min(t.getMaximumWindowWidth(),Math.max(t.getMinimumWindowWidth(),r)),i.setWidth(r),t.isLeftAndRightFilterRendered()){var n=t.getSlidingWindowPosX(i)+r,a=t.getRightBackground();a.setX(n),a.setWidth(Math.max(0,t.Width-n)),e.OverviewUtils.supportsTouch()&&!t.isFeatureOff("zoom")&&t.getRightBackgroundHandle().setX(n)}if(!t.isFeatureOff("zoom")){if(t.isHorizontalScrollingEnabled()){var o=t._windowRightHandleBackground,s=t._windowRightHandle,l=t._windowRightGrippy;s.setTranslateX(r),o.setTranslateX(r-t.getHandleSize()),l.setTranslateX(r-t.getGrippySize())}if(t.isVerticalScrollingEnabled()){var h=(i.getWidth()-36)/2;if(t._vertHandleBackgroundImage)var u=(r-t._vertHandleWidth)/2;else u=h;var g=t._windowTopHandleBackground,d=t._windowTopHandle,p=t._windowTopGrippy;d.setTranslateX(h),g.setWidth(r),p.setTranslateX(u);var c=t._windowBottomHandleBackground,_=t._windowBottomHandle,f=t._windowBottomGrippy;_.setTranslateX(h),c.setWidth(r),f.setTranslateX(u)}}},r._setSlidingWindowHeight=function(e,t,i){if(i=Math.min(e.getMaximumWindowHeight(),Math.max(e.getMinimumWindowHeight(),i)),t.setHeight(i),!e.isFeatureOff("zoom")){if(e.isHorizontalScrollingEnabled()){var r=(i-36)/2;if(e._horHandleBackgroundImage)var n=(i-e._horHandleHeight)/2;else n=r;var a=e._windowLeftHandleBackground,o=e._windowLeftHandle,s=e._windowLeftGrippy;o.setTranslateY(r),a.setHeight(i),s.setTranslateY(n);var l=e._windowRightHandleBackground,h=e._windowRightHandle,u=e._windowRightGrippy;h.setTranslateY(r),l.setHeight(i),u.setTranslateY(n)}if(e.isVerticalScrollingEnabled()){var g=e._windowBottomHandleBackground,d=e._windowBottomHandle,p=e._windowBottomGrippy;d.setTranslateY(i),g.setTranslateY(i-e.getHandleSize()),p.setTranslateY(i-e.getGrippySize())}}},r._renderTimeAxisTopBar=function(t){var i=t.Width,r=t.Height;if(t.isVertical())if(t.isRTL())var n=new e.Line(t.getCtx(),t.getTimeAxisWidth(),0,t.getTimeAxisWidth(),r,"tab");else n=new e.Line(t.getCtx(),i-t.getTimeAxisWidth(),0,i-t.getTimeAxisWidth(),r,"tab");else n=t.isOverviewAbove()?new e.Line(t.getCtx(),0,t.getTimeAxisHeight(),i,t.getTimeAxisHeight(),"tab"):new e.Line(t.getCtx(),0,r-t.getTimeAxisHeight(),i,r-t.getTimeAxisHeight(),"tab");n.setSolidStroke(t._timeAxisBarColor,t._timeAxisBarOpacity),n.setPixelHinting(!0),t._timeAxisTopBar=n,t.addChild(n)},r._renderLeftAndRightFilters=function(t,i){var r=t.Width,n=t.Height;if(t.isLeftAndRightFilterRendered()){if(t.isVertical())var a=new e.Rect(t.getCtx(),0,0,r,0,"lbg"),o=new e.Rect(t.getCtx(),0,0,r,0,"rbg");else a=new e.Rect(t.getCtx(),0,0,0,n,"lbg"),o=new e.Rect(t.getCtx(),0,0,0,n,"rbg");if(a.setSolidFill(t._leftFilterPanelColor,t._leftFilterPanelAlpha),t.addChild(a),o.setSolidFill(t._rightFilterPanelColor,t._rightFilterPanelAlpha),t.addChild(o),e.OverviewUtils.supportsTouch()&&null!=i){if(t.isVertical())var s=new e.Rect(t.getCtx(),0,0,r,i,"lbgrh"),l=new e.Rect(t.getCtx(),0,0,r,i,"rbgrh");else s=new e.Rect(t.getCtx(),0,0,i,n,"lbgrh"),l=new e.Rect(t.getCtx(),0,0,i,n,"rbgrh");s.setSolidFill(t._leftFilterPanelColor,0),t.addChild(s),l.setSolidFill(t._rightFilterPanelColor,0),t.addChild(l)}}},r._renderTimeAxis=function(e){if(null!=e._ticks)for(var t=e.Width,i=e.Height,a=e.isVertical(),o=e.getOverviewSize(),s=0;s<e._ticks.length;s++){var l=e._ticks[s],h=parseInt(l.time,10);if(a)var u=e.getDateYPosition(h);else u=e.getDateXPosition(h);var g=l.label,d=0;if(s+1<e._ticks.length){var p=parseInt(e._ticks[s+1].time,10);if(a)var c=e.getDateYPosition(p);else c=e.getDateXPosition(p);d=c-u}else d=o-u;e.isHorizontalRTL()&&(u=o-u),a&&(d=t),d-=2*n._DEFAULT_AXIS_LABEL_PADDING,r._addTick(e,u,t,i,"tick"+s),r._addLabel(e,u,g,i,d,"label"+s,e._labelStyle)}},r._addTick=function(t,i,r,n,a){if(t.isVertical())var o=new e.Line(t.getCtx(),0,i,r,i,a);else o=new e.Line(t.getCtx(),i,0,i,n,a);var s=new e.Stroke(t._timeIndicatorColor,1,1,!1,{dashArray:"3"});o.setStroke(s),o.setPixelHinting(!0),t.addChild(o)},r._addLabel=function(t,i,r,a,o,s,l){if(t.isVertical()){var h=new e.OutputText(t.getCtx(),r,4,i,s);if(h.setCSSStyle(l),t.isRTL()){var u=h.getDimensions();h.setX(Math.max(4,t.Width-u.w-4))}}else{if(t.isOverviewAbove())var g=2;else g=a-t.getTimeAxisHeight()+2;var d=n._DEFAULT_AXIS_LABEL_PADDING;(h=new e.OutputText(t.getCtx(),r,i+d,g,s)).setCSSStyle(l),t.isHorizontalRTL()&&(u=h.getDimensions(),h.setX(i-Math.min(u.w,o)-d))}e.TextUtils.fitText(h,o,1/0,t),h._rawText=h.getUntruncatedTextString()},r._parseFilledTimeRanges=function(e){if(null!=e._formattedTimeRanges)for(var t=0;t<e._formattedTimeRanges.length;t++){var i=e._formattedTimeRanges[t];r._addFilledTimeRange(e,i,e.Width,e.Height)}},r._addFilledTimeRange=function(t,i,r,n){var a=parseInt(i.rs,10),o=parseInt(i.re,10);if(null!=a&&null!=o){var s=i.c,l=t.getOverviewSize();if(t.isVertical())h=t.getDateYPosition(a),u=t.getDateYPosition(o);else var h=t.getDateXPosition(a),u=t.getDateXPosition(o);var g=u-h;if(t.isHorizontalRTL()&&(h=l-h-g,u=l-u-g),t.isVertical())var d=new e.Rect(t.getCtx(),0,h,r-t.getTimeAxisWidth(),g,"ftr");else d=new e.Rect(t.getCtx(),h,t.isOverviewAbove()?t.getTimeAxisHeight():0,g,n-t.getTimeAxisHeight(),"ftr");null!=s&&d.setSolidFill(s,.4),d.setCursor("move"),d.setPixelHinting(!0),t.addChild(d)}},r._updateCurrentTime=function(t){var i=t.Width,r=t.Height;if(!(null==t._currentTime||isNaN(t._currentTime)||t._currentTime<t._xMin||t._currentTime>t._xMax)){if(t.isVertical())var n=t.getDateYPosition(t._currentTime),a=new e.Line(t.getCtx(),0,n,i,n,"ocd");else n=t.getDateXPosition(t._currentTime),t.isRTL()&&(n=i-n),a=new e.Line(t.getCtx(),n,0,n,r,"ocd");a.setSolidStroke(t._currentTimeIndicatorColor),a.setPixelHinting(!0),t.addChild(a)}};var n=new Object;e.Obj.createSubclass(n,e.Obj),n._DEFAULT_AXIS_LABEL_PADDING=5,n._DEFAULT_WINDOW_BORDER_WIDTH=1,n.getHandleFillColor=function(e){return null!=e._hfc?e._hfc:e.style.handleFillColor},n.getHandleTextureColor=function(e){return null!=e._htc?e._htc:e.style.handleTextureColor},n.getHandleBackgroundImage=function(e,t){return t?null!=e._vhbi?e._vhbi:e.style.vertHandleBackgroundImage:null!=e._hbi?e._hbi:e.style.handleBackgroundImage},n.getHandleWidth=function(e,t){return t?null!=e._vhw?e._vhw:e.style.vertHandleWidth:null!=e._hw?e._hw:e.style.handleWidth},n.getHandleHeight=function(e,t){return t?null!=e._vhh?e._vhh:e.style.vertHandleHeight:null!=e._hh?e._hh:e.style.handleHeight},n.getBorderTopColor=function(e){return null!=e._btc?e._btc:e.style.borderTopColor},n.getBorderTopStyle=function(e){return null!=e._bts?e._bts:e.style.borderTopStyle},n.getWindowBackgroundColor=function(e){return null!=e._wbc?e._wbc:e.style.windowBackgroundColor},n.getWindowBackgroundAlpha=function(e){return e.style.windowBackgroundAlpha},n.getWindowBorderTopStyle=function(e){return null!=e._wbts?e._wbts:e.style.windowBorderTopStyle},n.getWindowBorderRightStyle=function(e){return null!=e._wbrs?e._wbrs:e.style.windowBorderRightStyle},n.getWindowBorderBottomStyle=function(e){return null!=e._wbbs?e._wbbs:e.style.windowBorderBottomStyle},n.getWindowBorderLeftStyle=function(e){return null!=e._wbls?e._wbls:e.style.windowBorderLeftStyle},n.getWindowBorderTopColor=function(e){return null!=e._wbtc?e._wbtc:e.style.windowBorderTopColor},n.getWindowBorderRightColor=function(e){return null!=e._wbrc?e._wbrc:e.style.windowBorderRightColor},n.getWindowBorderBottomColor=function(e){return null!=e._wbbc?e._wbbc:e.style.windowBorderBottomColor},n.getWindowBorderLeftColor=function(e){return null!=e._wblc?e._wblc:e.style.windowBorderLeftColor},n.getOverviewBackgroundColor=function(e){return null!=e._obc?e._obc:e.style.overviewBackgroundColor},n.getCurrentTimeIndicatorColor=function(e){return null!=e._ctic?e._ctic:e.style.currentTimeIndicatorColor},n.getTimeAxisBarColor=function(e){return null!=e._tabc?e._tabc:e.style.timeAxisBarColor},n.getTimeAxisBarAlpha=function(e){return null!=e._tabo?e._tabo:e.style.timeAxisBarAlpha},n.getTimeIndicatorColor=function(e){return null!=e._tic?e._tic:e.style.timeIndicatorColor},n.getLeftFilterPanelColor=function(e){return e.style.leftFilterPanelColor},n.getLeftFilterPanelAlpha=function(e){return e.style.leftFilterPanelAlpha},n.getRightFilterPanelColor=function(e){return e.style.rightFilterPanelColor},n.getRightFilterPanelAlpha=function(e){return e.style.rightFilterPanelAlpha}}(e),e}),define("ojs/internal-deps/dvt/DvtChart",["./DvtToolkit","./DvtAxis","./DvtLegend","./DvtOverview"],function(e){"use strict";return function(e){e.Chart=function(e,t,i){this.Init(e,t,i)},e.Obj.createSubclass(e.Chart,e.BaseComponent),e.Chart.newInstance=function(t,i,r){return new e.Chart(t,i,r)},e.Chart.getDefaults=function(e){return(new s).getDefaults(e)},e.Chart.prototype.Init=function(t,r,n){e.Chart.superclass.Init.call(this,t,r,n),this.Defaults=new s(t),this.EventManager=new i(this),this.EventManager.addListeners(this),e.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("chart1000"+Math.floor(1e9*Math.random())),this.legend=null,this.xAxis=null,this.yAxis=null,this.y2Axis=null,this.overview=null,this.xScrollbar=null,this.yScrollbar=null,this.dragButtons=null,this.pieChart=null,this.pieCenterDiv=null,this.Peers=[],this.SeriesStyleArray=[],this._numFrontObjs=0,this._numSelectedObjsInFront=0,this._dataLabels=null,this._rawOptions=null},e.Chart.prototype.GetComponentDescription=function(){var t=this.getOptions(),i=t.translations.componentName,r="",n=e.Context.ARIA_LABEL_DESC_DELIMITER;return t.title.text&&(r+=this.Options.title.text,t.subtitle.text&&(r+=n+this.Options.subtitle.text)),t.footnote.text&&(r=0==r.length?this.Options.footnote.text:r.concat(n,this.Options.footnote.text)),r.length>0?e.ResourceUtils.format(this.Options.translations.labelAndValue,[i,r]):i},e.Chart.prototype.SetOptions=function(t){t?(this._rawOptions=t,this.Options=this.Defaults.calcOptions(t),this.getOptionsCache().clearCache(),J.processDataObject(this),(e.Agent.isEnvironmentTest()||ne.isScatterBubble(this)&&J.getSeriesCount(this)*J.getGroupCount(this)>pe.FILTER_THRESHOLD_SCATTER_BUBBLE)&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults());var i=this.Options.selectionMode;this._selectionHandler="single"==i?new e.SelectionHandler(this.getCtx(),e.SelectionHandler.TYPE_SINGLE):"multiple"==i?new e.SelectionHandler(this.getCtx(),e.SelectionHandler.TYPE_MULTIPLE):null,this.EventManager.setSelectionHandler(this._selectionHandler)},e.Chart.prototype.render=function(t,i,r){this.getCache().clearCache();var n=this.getCtx(),a=this.Options?this.Options.animationOnDataChange:"none",o="none"!=a?new N(this):null,s=this.__cacheChartFocus();this._container&&this.__cleanUp(),this.SetOptions(t),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r);var l=new e.Container(n);this.addChild(l),ue.render(this,l,new e.Rectangle(0,0,this.Width,this.Height)),ne.isSpark(this)&&this.EventManager.removeListeners(this),this.StopAnimation();var h=te.getAnimationOnDisplay(this),u=te.getAnimationDuration(this),g=new e.Rectangle(0,0,this.Width,this.Height),d=!1;if(this._container){if("none"!=a&&t)if(this.Animation=e.BlackBoxAnimationHandler.getCombinedAnimation(n,a,this._container,l,g,u),this.Animation)d=!0;else if("auto"==a&&this.getPlotArea()){var p=this.__getPlotAreaSpace();this._delContainer=pe.createClippedGroup(this,this._container,new e.Rectangle(0,0,p.w,p.h)),this.Animation=F.createAnimation(o,this,a,u,this._delContainer),this._delContainer.getNumChildren()>0&&this.getPlotArea().addChild(this._delContainer)}}else"none"!=h&&(this.Animation=e.BlackBoxAnimationHandler.getInAnimation(n,h,l,g,u),this.Animation||"auto"!=h||(this.Animation=H.createAnimation(this,h,u)));this.Animation?(this.EventManager.removeListeners(this),e.Playable.appendOnEnd(this.Animation,this._onAnimationEnd,this),this.Animation.play(),this._oldContainer=this._container,!d&&this._oldContainer&&this._oldContainer.removeFromParent()):this._container&&(this._container.removeFromParent(),this._container.destroy(),this._container=null),this._container=l,this._dataCursor=ue.renderDataCursor(this),this.UpdateAriaAttributes(),this.__restoreChartFocus(s),this.Animation||this.RenderComplete()},e.Chart.prototype.__cleanUp=function(){this._dataCursor&&(this.removeChild(this._dataCursor),this._dataCursor=null),this.EventManager&&(this.EventManager.hideHoverFeedback(),this.EventManager.setPanZoomHandler(null),this.EventManager.setMarqueeZoomHandler(null),this.EventManager.setMarqueeSelectHandler(null),this.EventManager.panButton=null,this.EventManager.zoomButton=null,this.EventManager.selectButton=null),this.pieCenterDiv&&(this.getCtx().getContainer().removeChild(this.pieCenterDiv),this.pieCenterDiv=null),this.Peers=[],this.xScrollbar=null,this.yScrollbar=null,this.dragButtons&&(this.removeChild(this.dragButtons),this.dragButtons.destroy(),this.dragButtons=null),this._plotArea=null,this._areaContainer=null,this._dataLabels=null,this.getCache().clearCache()},e.Chart.prototype.__cleanUpAxisAndPlotArea=function(){this.EventManager.hideHoverFeedback(),this.Peers=[],this.xAxis&&(this._container.removeChild(this.xAxis),this.xAxis.destroy()),this.yAxis&&(this._container.removeChild(this.yAxis),this.yAxis.destroy()),this.y2Axis&&(this._container.removeChild(this.y2Axis),this.y2Axis.destroy()),this._plotArea&&this._plotArea==this._panZoomTarget?this._plotArea.setVisible(!1):this._plotArea&&(this._container.removeChild(this._plotArea),this._plotArea.destroy()),this._plotArea=null,this.getCache().clearCache()},e.Chart.prototype._onAnimationEnd=function(){this._oldContainer&&(this._oldContainer.removeFromParent(),this._oldContainer.destroy(),this._oldContainer=null),this._delContainer&&(this._delContainer.removeFromParent(),this._delContainer.destroy(),this._delContainer=null),this.AnimationStopped||this.RenderComplete(),this.EventManager.addListeners(this),this.Animation=null,this.AnimationStopped=!1},e.Chart.prototype.CreateKeyboardHandler=function(e){return new r(e,this)},e.Chart.prototype.getAutomation=function(){return new t(this)},e.Chart.prototype.getValuesAt=function(e,t){var i=this.__getPlotAreaSpace(),r=e-i.x,n=t-i.y,a=ne.isPolar(this),o=ne.isHorizontal(this);if(a){r-=i.w/2,n-=i.h/2;var s=Math.sqrt(r*r+n*n),l=Math.atan2(r,-n);return l<0&&(l+=2*Math.PI),{x:this.xAxis?this.xAxis.getValueAt(l):null,y:this.yAxis?this.yAxis.getValueAt(s):null}}return{x:this.xAxis?this.xAxis.getValueAt(o?n:r):null,y:this.yAxis?this.yAxis.getValueAt(o?r:n):null,y2:this.y2Axis?this.y2Axis.getValueAt(o?r:n):null}},e.Chart.prototype.filter=function(e,t){var i="out"==t?"hidden":"visible";Q.setVisibility(this,e,i),this.render(this.Options)},e.Chart.prototype.highlight=function(t){this.getOptions().highlightedCategories=e.JsonUtils.clone(t),e.CategoryRolloverHandler.highlight(t,this.getObjects(),"any"==this.getOptions().highlightMatch),this.legend&&this.legend.highlight(t),this.pieChart&&this.pieChart.highlight(t),this.overview&&this.overview.getBackgroundChart().highlight(t)},e.Chart.prototype.select=function(t){this.getOptions().selection=e.JsonUtils.clone(t);var i=J.getInitialSelection(this);Q.setInitialSelection(this,i),this.pieChart&&this.pieChart.setInitialSelection()},e.Chart.prototype.positionDataCursor=function(t){var i=this.getEventManager().getDataCursorHandler();if(i){if(t){var r=this.xAxis&&null!=t.x?this.xAxis.getCoordAt(t.x):null,n=null;if(ne.isBLAC(this)?this.yAxis&&null!=t.y?n=this.yAxis.getBoundedCoordAt(t.y):this.y2Axis&&null!=t.y2&&(n=this.yAxis.getBoundedCoordAt(t.y2)):n=this.yAxis&&null!=t.y?this.yAxis.getCoordAt(t.y):null,null!=r&&null!=n){var a=this.__getPlotAreaSpace(),o=pe.convertAxisCoord(this,new e.Point(r,n),a);return void i.processMove(new e.Point(a.x+o.x,a.y+o.y),!0)}}i.processEnd(!0)}},e.Chart.prototype.processEvent=function(e,t){var i=e.type;if("categoryHide"==i||"categoryShow"==i)this.filter(e.category,"categoryHide"==i?"out":"in");else if("categoryHighlight"==i)this!=t&&this.highlight(e.categories),this.legend&&this.legend!=t&&this.legend.processEvent(e,t);else if("selection"==i)e=this._processSelectionEvent(e);else if("dvtPanZoom"==i)e=this._processPanZoomEvent(e);else if("dvtMarquee"==i)e=this._processMarqueeEvent(e);else if("overview"==i){var r=e.subtype;if("dropCallback"==r)return;var n="scrollTime"==r||"scrollEnd"==r||"rangeChange"==r;e=this._processScrollbarEvent(e.newX1,e.newX2,n,t)}else if("dvtSimpleScrollbar"==i)e=this._processScrollbarEvent(e.newMin,e.newMax,"end"==e.subtype,t);else if("ready"==i&&this!=t)return;if(e){if("selection"==(i=e.type)){var a,o,s=this.getOptions(),l=s.selection,h=J.getCurrentSelection(this);e.complete&&(s.selection=h),l=l||[],h=h||[];var u={};for(a=0;a<l.length;a++)u[l[a].id]=!0;var g={};for(o=0;o<h.length;o++)g[h[o].id]=!0;var d={};for(o=0;o<h.length;o++){var p=h[o].id;u[p]||(d[p]=!0)}var c={};for(a=0;a<l.length;a++){var _=l[a].id;g[_]||(c[_]=!0)}e.addedSet=d,e.removedSet=c;for(var f=0;f<e.selection.length;f++)Q.addEventData(this,e.selection[f]);e.component=this.getOptions()._widgetConstructor}else"drill"==i&&(Q.addEventData(this,e),e.component=this.getOptions()._widgetConstructor);this.dispatchEvent(e)}},e.Chart.prototype._processSelectionEvent=function(t){var i=Q.processIds(this,t.selection);return this._updateOverviewSelection(),e.EventFactory.newChartSelectionEvent(i,!0)},e.Chart.prototype._processPanZoomEvent=function(t){var i=t.subtype;return"panStart"==i||"pinchStart"==i?(e.Agent.isTouchDevice()&&this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=this._plotArea),null):(this._lastPanZoomEvent?(t.dxMin+=this._lastPanZoomEvent.dxMin,t.dxMax+=this._lastPanZoomEvent.dxMax,t.dyMin+=this._lastPanZoomEvent.dyMin,t.dyMax+=this._lastPanZoomEvent.dyMax):e.Context.requestAnimationFrame(e.Obj.createCallback(this,this._animatePanZoomEvent)),this._lastPanZoomEvent=t,null)},e.Chart.prototype._animatePanZoomEvent=function(){var t=this._lastPanZoomEvent;this._lastPanZoomEvent=null;var i,r,n=t.subtype,a="panEnd"==n||"zoom"==n||"pinchEnd"==n;Q.isLiveScroll(this)?(i=Q.getAxisBoundsByDelta(this,t.dxMin,t.dxMax,t.dyMin,t.dyMax),this._setScrollbarViewport(i),this._setViewport(i,a)):(i=Q.getAxisBoundsByDelta(this,t.dxMinTotal,t.dxMaxTotal,t.dyMinTotal,t.dyMaxTotal),this._setScrollbarViewport(i),a&&this._setViewport(i,a)),a&&(ue._setEventHandlers(this),this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=null)),(a||!i.unchanged)&&(r=ne.isBLAC(this)?e.EventFactory.newChartViewportChangeEvent(a,i.xMin,i.xMax,i.startGroup,i.endGroup,null,null):e.EventFactory.newChartViewportChangeEvent(a,i.xMin,i.xMax,null,null,i.yMin,i.yMax),this.dispatchEvent(r))},e.Chart.prototype._processMarqueeEvent=function(t){var r,n=t.subtype,a=this.EventManager;if(Q.adjustBounds(t),a.getDragMode()==i.DRAG_MODE_SELECT){var o=a.getSelectionHandler();if("start"==n)this._initSelection=t.ctrlKey?o.getSelectedIds():[];else{var s=Q.getBoundedObjects(this,t);o.processInitialSelections(this._initSelection,this.getChartObjPeers()),o.processGroupSelection(s,!0)}var l=o.getSelectedIds();r=Q.getAxisBounds(this,t,!1);var h="end"==n,u=e.EventFactory.newChartSelectionEvent(l,h,r.xMin,r.xMax,r.startGroup,r.endGroup,r.yMin,r.yMax,r.y2Min,r.y2Max);return"end"==n&&this._updateOverviewSelection(),u}return a.getDragMode()==i.DRAG_MODE_ZOOM?"end"!=n?null:(r=Q.getAxisBounds(this,t,!0),this._setViewport(r,!0),this._setScrollbarViewport(r),ue._setEventHandlers(this),ne.isBLAC(this)?e.EventFactory.newChartViewportChangeEvent(!0,r.xMin,r.xMax,r.startGroup,r.endGroup,null,null):e.EventFactory.newChartViewportChangeEvent(!0,r.xMin,r.xMax,null,null,r.yMin,r.yMax)):null},e.Chart.prototype._processScrollbarEvent=function(t,i,r,n){return this._lastScrollbarEvent||e.Context.requestAnimationFrame(e.Obj.createCallback(this,this._animateScrollbarEvent)),this._lastScrollbarEvent={start:t,end:i,actionDone:r,source:n},null},e.Chart.prototype._animateScrollbarEvent=function(){var t=this._lastScrollbarEvent.start,i=this._lastScrollbarEvent.end,r=this._lastScrollbarEvent.actionDone,n=this._lastScrollbarEvent.source;this._lastScrollbarEvent=null;var a=n==this.yScrollbar?this.yAxis:this.xAxis,o=Q.getActualMinMax(a,t,i);if(t=o.min,i=o.max,(Q.isLiveScroll(this)||r)&&(n==this.yScrollbar?this._setViewport({yMin:t,yMax:i},r):this._setViewport({xMin:t,xMax:i,unchanged:o.unchanged},r)),r||!o.unchanged){var s;if(n==this.yScrollbar)s=e.EventFactory.newChartViewportChangeEvent(r,null,null,null,null,t,i,null,null);else{var l=Q.getAxisStartEndGroup(this.xAxis,t,i);s=e.EventFactory.newChartViewportChangeEvent(r,t,i,l.startGroup,l.endGroup,null,null,null,null)}this.dispatchEvent(s)}},e.Chart.prototype._updateOverviewSelection=function(){if(this.overview){var e=this.overview.getBackgroundChart();e.getOptions().selection=J.getCurrentSelection(this),e.render()}},e.Chart.prototype.changeOption=function(t,i,r){this.getOptions()[t]=i,this.dispatchEvent(e.EventFactory.newOptionChangeEvent(t,i,r))},e.Chart.prototype.registerObject=function(e){this.Peers.push(e)},e.Chart.prototype.getObjects=function(){return this.Peers},e.Chart.prototype.getChartObjPeers=function(){for(var e=[],t=0;t<this.Peers.length;t++)this.Peers[t]instanceof n&&e.push(this.Peers[t]);return e},e.Chart.prototype.getRefObjPeers=function(){for(var e=[],t=0;t<this.Peers.length;t++)this.Peers[t]instanceof a&&e.push(this.Peers[t]);return e},e.Chart.prototype.getObject=function(e,t){for(var i=0;i<this.Peers.length;i++)if(this.Peers[i]instanceof n&&this.Peers[i].getSeriesIndex()==e&&this.Peers[i].getGroupIndex()==t)return this.Peers[i];return null},e.Chart.prototype.getWidth=function(){return this.Width},e.Chart.prototype.getHeight=function(){return this.Height},e.Chart.prototype.getSeriesStyleArray=function(){return this.SeriesStyleArray},e.Chart.prototype.getPlotArea=function(){return this._plotArea},e.Chart.prototype.setPlotArea=function(e){this._plotArea=e},e.Chart.prototype.getType=function(){return this.getOptions().type},e.Chart.prototype.getSkin=function(){return this.getOptions().skin},e.Chart.prototype.getGapWidthRatio=function(){var e=this.getOptions();return null!==e.layout.gapWidthRatio?e.layout.gapWidthRatio:Math.min(this.Width/400,1)},e.Chart.prototype.getGapHeightRatio=function(){var e=this.getOptions();return null!==e.layout.gapHeightRatio?e.layout.gapHeightRatio:Math.min(this.Height/300,1)},e.Chart.prototype.getSelectionHandler=function(){return this._selectionHandler},e.Chart.prototype.isSelectionSupported=function(){return!!this._selectionHandler},e.Chart.prototype._setViewport=function(e,t){!t&&e.unchanged||(null!=e.xMax&&(this.Options.xAxis.viewportMax=e.xMax),null!=e.xMin&&(this.Options.xAxis.viewportMin=e.xMin),ne.isBLAC(this)?(this.Options.xAxis.viewportStartGroup=null,this.Options.xAxis.viewportEndGroup=null,this.Options._initialZoomed=!1):(null!=e.yMax&&(this.Options.yAxis.viewportMax=e.yMax),null!=e.yMin&&(this.Options.yAxis.viewportMin=e.yMin)),this.Options._duringZoomAndScroll=!t,ue.rerenderAxisAndPlotArea(this,this._container))},e.Chart.prototype._setScrollbarViewport=function(e){if(this.xAxis&&null!=e.xMin&&null!=e.xMax){var t=this.xAxis.actualToLinear(e.xMin),i=this.xAxis.actualToLinear(e.xMax);this.overview&&this.overview.setViewportRange(t,i),this.xScrollbar&&this.xScrollbar.setViewportRange(t,i)}if(this.yAxis&&null!=e.yMin&&null!=e.yMax){var r=this.yAxis.actualToLinear(e.yMin),n=this.yAxis.actualToLinear(e.yMax);this.yScrollbar&&this.yScrollbar.setViewportRange(r,n)}},e.Chart.prototype.__setAxisSpace=function(e){var t,i;this._axisSpace=e,Z.isAxisRendered(this,"x")?(t=.8*e.w,i=e.h-4*Z.getTickLabelHeight(this,"x")):Z.isAxisRendered(this,"y")?(t=e.w,i=e.h-Z.getTickLabelHeight(this,"y")):(t=e.w,i=e.h),this._radius=Math.min(t,i)/2},e.Chart.prototype.__getAxisSpace=function(){return this._axisSpace},e.Chart.prototype.__setPlotAreaSpace=function(e){this._plotAreaSpace=e},
e.Chart.prototype.__getPlotAreaSpace=function(){return this._plotAreaSpace},e.Chart.prototype.__setAreaContainer=function(e){this._areaContainer=e},e.Chart.prototype.__getAreaContainer=function(){return this._areaContainer},e.Chart.prototype.getRadius=function(){return this._radius},e.Chart.prototype.showDragButtons=function(){this.dragButtons&&this.dragButtons.setVisible(!0)},e.Chart.prototype.hideDragButtons=function(){this.dragButtons&&this.dragButtons.setVisible(!1)},e.Chart.prototype.addDataLabel=function(e){this.getDataLabels().push(e)},e.Chart.prototype.getDataLabels=function(){return this._dataLabels||(this._dataLabels=[]),this._dataLabels},e.Chart.prototype.__cacheChartFocus=function(){var e=this.EventManager.getFocus();if(e)var t=e.isShowingKeyboardFocusEffect();if(this.xAxis){var i=this.xAxis.getKeyboardFocus();if(i)var r=i.isShowingKeyboardFocusEffect()}if(this.legend){var n=this.legend.getKeyboardFocus();if(n)var a=n.isShowingKeyboardFocusEffect()}return{chartFocus:e,chartShowingFocusEffect:t,axisFocus:i,axisShowingFocusEffect:r,legendFocus:n,legendShowingFocusEffect:a}},e.Chart.prototype.__restoreChartFocus=function(e){if(!ne.isOverview(this)&&!ne.isSpark(this)){var t=[this];if(this.xAxis&&this.xAxis.isNavigable()&&t.push(this.xAxis),this.legend&&this.legend.isNavigable()&&t.push(this.legend),this.getCtx().setKeyboardFocusArray(t),e.chartFocus){for(var i=Q.getKeyboardNavigables(this),r=!1,n=0;n<i.length;n++){var a=i[n].id;if(a instanceof o&&a.equals(e.chartFocus.getId())){this.EventManager.setFocusObj(i[n]),e.chartShowingFocusEffect&&i[n].showKeyboardFocusEffect(),r=!0;break}}r||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(i))}e.axisFocus&&(this.xAxis.setKeyboardFocus(e.axisFocus,e.axisShowingFocusEffect),e.axisShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.xAxis)),e.legendFocus&&(this.legend.setKeyboardFocus(e.legendFocus,e.legendShowingFocusEffect),e.legendShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.legend))}},e.Chart.prototype.getRawOptions=function(){return this._rawOptions};var t=function(e){this._chart=e,this._options=this._chart.getOptions(),this._legend=this._chart.legend,this._xAxis=this._chart.xAxis,this._yAxis=this._chart.yAxis,this._y2Axis=this._chart.y2Axis,this._legendAutomation=this._legend?this._legend.getAutomation():null,this._xAxisAutomation=this._xAxis?this._xAxis.getAutomation():null,this._yAxisAutomation=this._yAxis?this._yAxis.getAutomation():null,this._y2AxisAutomation=this._y2Axis?this._y2Axis.getAutomation():null};e.Obj.createSubclass(t,e.Automation),t.PLOT_AREA_SUBID="plotArea",t.PIE_CENTER_LABEL_SUBID="pieCenterLabel",t.prototype.GetSubIdForDomElement=function(i){var r=null;if(i.isDescendantOf(this._xAxis))return(r=this._xAxisAutomation.GetSubIdForDomElement(i))?this._convertAxisSubIdToChartSubId(r,"xAxis"):null;if(i.isDescendantOf(this._yAxis))return(r=this._yAxisAutomation.GetSubIdForDomElement(i))?this._convertAxisSubIdToChartSubId(r,"yAxis"):null;if(i.isDescendantOf(this._y2Axis))return(r=this._y2AxisAutomation.GetSubIdForDomElement(i))?this._convertAxisSubIdToChartSubId(r,"y2Axis"):null;if(i.isDescendantOf(this._legend)){var o=this._legendAutomation.GetSubIdForDomElement(i);return o?this._convertLegendSubIdToChartSubId(o):null}var s=this._chart.getEventManager().GetLogicalObject(i);if(!s)return null;if(s instanceof e.SimpleObjPeer){var l=s.getParams().type;if("pieCenterLabel"==l)return t.PIE_CENTER_LABEL_SUBID;if("plotArea"==l)return t.PLOT_AREA_SUBID}if(s instanceof z)return"dataItem["+s.getSeriesIndex()+"]";if(s instanceof n){var h=s.getSeriesIndex(),u=s.getGroupIndex();if(null!=h&&u>=0&&("funnel"!=this._options.type||"pyramid"!=this._options.type))return"dataItem["+h+"]["+u+"]";if(null!=h&&u==ce._GROUP_INDEX&&("funnel"==this._options.type||"pyramid"==this._options.type))return"dataItem["+h+"]";if(null!=h&&(null==u||u<0))return"series["+h+"]"}else if(s instanceof a){var g=s.getAxisType(),d=s.getIndex();return g&&d>=0?g+":referenceObject["+d+"]":null}return null},t.prototype._convertLegendSubIdToChartSubId=function(e){var t=this._legend.getOptions(),i=this._legendAutomation.getLegendItem(t,e);if(i){for(var r=0;r<this._options.series.length;r++)if(this._options.series[r].name==i.text)return"series["+r+"]";return"legend:"+e}return null},t.prototype._convertAxisSubIdToChartSubId=function(e,t){if("title"==e&&t)return t+":"+e;var i=e.substring(e.indexOf("["));return i?"group"+i:null},t.prototype.getDomElementForSubId=function(i){if(i==e.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._chart,re.isDataCursorEnabled(this._chart)?L.TOOLTIP_ID:null);if(i==t.PIE_CENTER_LABEL_SUBID)return this._chart.pieChart.getCenterLabel().getElem();if(i==t.PLOT_AREA_SUBID)return this._chart.getPlotArea().getElem();var r,n,a,o=i.indexOf("["),s=i.indexOf("]"),l=i.indexOf(":");if(o>0&&s>0||l>0){var h=l<0?i.substring(0,o):i.substring(0,l);if("group"==h)return this._xAxisAutomation.getDomElementForSubId(i);if("series"==h)return i=this._convertToLegendSubId(i),this._legendAutomation.getDomElementForSubId(i);if("legend"==i.substring(0,l))return i=i.substring(l+1),this._legendAutomation.getDomElementForSubId(i);var u,g=i.substring(o+1,s);if("xAxis"==h||"yAxis"==h||"y2Axis"==h){var d=i.substring(l+1);if("title"==d){if("xAxis"==h)return this._xAxisAutomation.getDomElementForSubId(d);if("yAxis"==h)return this._yAxisAutomation.getDomElementForSubId(d);if("y2Axis"==h)return this._y2AxisAutomation.getDomElementForSubId(d)}else if(r=d.indexOf("["),n=d.indexOf("]"),"referenceObject"==d.substring(0,r)){var p=d.substring(r+1,n);if(a=this._getRefObjPeer(p))return a.getDisplayables()[0].getElem()}}if("pie"==this._options.type){var c=this._chart.pieChart.getSliceDisplayable(g);if(c)return c.getElem()}if("funnel"==this._options.type?u=ce._GROUP_INDEX:"pyramid"==this._options.type?u=_e._GROUP_INDEX:(r=(i=i.substring(s+1)).indexOf("["),n=i.indexOf("]"),r>=0&&n>=0&&(u=i.substring(r+1,n))),a=this._getChartObjPeer(g,u))return a.getDisplayables()[0].getElem()}return null},t.prototype._getChartObjPeer=function(e,t){for(var i=this._chart.getChartObjPeers(),r=0;r<i.length;r++){var n=i[r].getSeriesIndex(),a=i[r].getGroupIndex();if(n==e&&a==t)return i[r]}return null},t.prototype._getRefObjPeer=function(e){for(var t=this._chart.getRefObjPeers(),i=0;i<t.length;i++)if(e==t[i].getIndex())return t[i];return null},t.prototype._convertToLegendSubId=function(e){var t=e.indexOf("["),i=e.indexOf("]"),r=e.substring(t+1,i),n=this._legend.getOptions(),a=this._options.series[r];return"section"+this._legendAutomation.getIndicesFromSeries(a,n)},t.prototype.getDataItem=function(e,t){"pie"!=this._options.type&&"funnel"!=this._options.type&&"pyramid"!=this._options.type||(t=0);var i=J.getDataItem(this._chart,e,t);return i?{borderColor:te.getBorderColor(this._chart,e,t),color:te.getColor(this._chart,e,t),label:J.getDataLabel(this._chart,e,t),targetValue:J.getTargetValue(this._chart,e,t),tooltip:re.getDatatip(this._chart,e,t,null,!1),value:J.getValue(this._chart,e,t),open:i.open,close:i.close,high:J.getHighValue(this._chart,e,t),low:J.getLowValue(this._chart,e,t),volume:i.volume,x:J.getXValue(this._chart,e,t),y:i.y,z:i.z,min:i.min,max:i.max,group:J.getGroup(this._chart,t),series:J.getSeries(this._chart,e),selected:J.isDataSelected(this._chart,e,t)}:null},t.prototype.getGroup=function(e){return J.getGroup(this._chart,e)},t.prototype.getSeries=function(e){return this._options.series[e].name},t.prototype.getGroupCount=function(){return J.getGroupCount(this._chart)},t.prototype.getSeriesCount=function(){return this._options.series.length},t.prototype.getTitle=function(){return this._options.title.text},t.prototype.getLegend=function(){var t=this._legend.__getBounds(),i=this._legend.localToStage(new e.Point(t.x,t.y));return{bounds:{x:i.x,y:i.y,width:t.w,height:t.h},title:this._legend.getOptions().title}},t.prototype.getPlotArea=function(){var e=this._chart.__getPlotAreaSpace();return{bounds:{x:e.x,y:e.y,width:e.w,height:e.h}}},t.prototype.getXAxis=function(){return this._getAxis("x")},t.prototype.getYAxis=function(){return this._getAxis("y")},t.prototype.getY2Axis=function(){return this._getAxis("y2")},t.prototype._getAxis=function(t){var i="x"==t?this._xAxis:"y"==t?this._yAxis:this._y2Axis;if(i){var r=i.__getBounds(),n=i.localToStage(new e.Point(r.x,r.y)),a={x:n.x,y:n.y,width:r.w,height:r.h},o=this._chart;return{bounds:a,title:this._options[t+"Axis"].title,getPreferredSize:function(e,r){var n,a=i.getOptions(),s=a.position,l=Z.getTickLabelGapSize(o,t),h=ne.isStandaloneXAxis(o)||ne.isStandaloneYAxis(o)||ne.isStandaloneY2Axis(o)?2:0;return"top"==s||"bottom"==s?(n=i.getPreferredSize(a,e,r-l-h)).h=Math.ceil(n.h+l+h):(n=i.getPreferredSize(a,e-l-h,r)).w=Math.ceil(n.w+l+h),{width:n.w,height:n.h}}}}return null},e.Automation.prototype.IsTooltipElement=function(t){var i=t.getAttribute("id");return!(!i||0!=i.indexOf(L.TOOLTIP_ID)&&0!=i.indexOf(e.HtmlTooltipManager._TOOLTIP_DIV_ID))};var i=function(t){i.superclass.Init.call(this,t.getCtx(),t.processEvent,t,t),this._chart=t,this._dragMode=null,this._dragButtonsVisible=e.Agent.isTouchDevice(),this.panButton=null,this.zoomButton=null,this.selectButton=null,this._dataCursorHandler=null,this._panZoomHandler=null,this._marqueeZoomHandler=null,this._marqueeSelectHandler=null};e.Obj.createSubclass(i,e.EventManager),i.DRAG_MODE_PAN="pan",i.DRAG_MODE_ZOOM="zoom",i.DRAG_MODE_SELECT="select",i.DRAG_MODE_OFF="off",i.prototype.addListeners=function(t){e.SvgDocumentUtils.addDragListeners(this._chart,this._onDragStart,this._onDragMove,this._onDragEnd,this),i.superclass.addListeners.call(this,t),e.Agent.isTouchDevice()||t.addEvtListener(e.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)},i.prototype.RemoveListeners=function(t){i.superclass.RemoveListeners.call(this,t),e.Agent.isTouchDevice()||t.removeEvtListener(e.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)},i.prototype.getLogicalObject=function(e){return this.GetLogicalObject(e,!0)},i.prototype._getDragHandler=function(e){return e&&"user"==this._chart.getOptions().dragMode&&ne.isBLAC(this._chart)&&(this._dragMode==i.DRAG_MODE_PAN||this._dragMode==i.DRAG_MODE_ZOOM)&&(this._panZoomHandler&&this._panZoomHandler.isWithinBounds(e)?this._dragMode=i.DRAG_MODE_PAN:this._dragMode=i.DRAG_MODE_ZOOM),this._dragMode==i.DRAG_MODE_PAN?this._panZoomHandler:this._dragMode==i.DRAG_MODE_ZOOM?this._marqueeZoomHandler:this._dragMode==i.DRAG_MODE_SELECT?this._marqueeSelectHandler:null},i.prototype._onDragStart=function(t){return e.Agent.isTouchDevice()?this._onTouchDragStart(t):this._onMouseDragStart(t)},i.prototype._onDragMove=function(t){return e.Agent.isTouchDevice()?this._onTouchDragMove(t):this._onMouseDragMove(t)},i.prototype._onDragEnd=function(t){return e.Agent.isTouchDevice()?this._onTouchDragEnd(t):this._onMouseDragEnd(t)},i.prototype._onMouseDragStart=function(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler(i),n=this.GetLogicalObject(e.target);return!(n&&n.isSelectable&&n.isSelectable())&&0==e.button&&r&&((t=r.processDragStart(i,e.ctrlKey))&&this._callback.call(this._callbackObj,t),this._chart.setCursor(r.getCursor(i)),this.setDragButtonsVisible(!1),this._chart!=this.getCtx().getCurrentKeyboardFocus()&&this.getCtx().setCurrentKeyboardFocus(this._chart)),!!t&&(this._dataCursorHandler&&this._dataCursorHandler.processEnd(),!0)},i.prototype._onMouseDragMove=function(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler();r&&(t=r.processDragMove(i,e.ctrlKey))&&(this._callback.call(this._callbackObj,t),this.setDragButtonsVisible(!1)),t&&e.stopPropagation()},i.prototype._onMouseDragEnd=function(e){var t,i=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._getDragHandler();if(r){(t=r.processDragEnd(i,e.ctrlKey))&&(this._callback.call(this._callbackObj,t),this.autoToggleZoomButton()),this._chart.setCursor(r.getCursor(i));var n=this._chart.__getAxisSpace();n&&this.setDragButtonsVisible(n.containsPoint(i.x,i.y))}},i.prototype.OnMouseMove=function(t){i.superclass.OnMouseMove.call(this,t);var r=this._context.pageToStageCoords(t.pageX,t.pageY);this._dataCursorHandler&&(this.GetLogicalObjectAndDisplayable(t.target).displayable instanceof e.Button?this._dataCursorHandler.processEnd():this._dataCursorHandler.processMove(r));var n=this._getDragHandler(r);n?this._chart.setCursor(n.getCursor(r)):this._chart.setCursor("default")},i.prototype.OnMouseOut=function(e){i.superclass.OnMouseOut.call(this,e);var t=this._context.pageToStageCoords(e.pageX,e.pageY),r=this._chart.__getAxisSpace();r&&this.setDragButtonsVisible(r.containsPoint(t.x,t.y)),this._dataCursorHandler&&this._dataCursorHandler.processOut(t),this.GetLogicalObject(e.target)},i.prototype.OnMouseWheel=function(e){if(Q.isZoomable(this._chart)){var t=null!=e.wheelDelta?e.wheelDelta:0,i=this._context.pageToStageCoords(e.pageX,e.pageY);if(this._panZoomHandler){var r=this._panZoomHandler.processMouseWheel(i,t);r&&(e.preventDefault(),e.stopPropagation(),this._callback.call(this._callbackObj,r),this._dataCursorHandler&&this._dataCursorHandler.processMove(i))}}},i.prototype.ShowFocusEffect=function(t,r){if(this._dataCursorHandler){var n=r.getDataPosition();if(n){var a=this._chart.__getPlotAreaSpace();this._dataCursorHandler.processMove(new e.Point(n.x+a.x,n.y+a.y))}}i.superclass.ShowFocusEffect.call(this,t,r)},i.prototype.OnBlur=function(e){this._dataCursorHandler&&this._dataCursorHandler.processEnd(),i.superclass.OnBlur.call(this,e)},i.prototype.OnClickInternal=function(e){var t=this.GetLogicalObject(e.target),i=this._context.pageToStageCoords(e.pageX,e.pageY);this.SeriesFocusHandler&&this.SeriesFocusHandler.processSeriesFocus(i,t),t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))},i.prototype.OnDblClickInternal=function(e){var t=this.GetLogicalObject(e.target);t&&t.isSelectable&&t.isSelectable()&&this.processDrillEvent(t)},i.prototype.HandleTouchHoverStartInternal=function(e){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var t=this._context.pageToStageCoords(e.touch.pageX,e.touch.pageY);return this._dataCursorHandler.processMove(t),!1}var i=this.GetLogicalObject(e.target);return this.TouchManager.setTooltipEnabled(e.touch.identifier,this.getTooltipsEnabled(i)),!1},i.prototype.HandleTouchHoverMoveInternal=function(e){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var t=this._context.pageToStageCoords(e.touch.pageX,e.touch.pageY);return this._dataCursorHandler.processMove(t),!1}var i=this.GetLogicalObject(e.target);return this.TouchManager.setTooltipEnabled(e.touch.identifier,this.getTooltipsEnabled(i)),!1},i.prototype.HandleTouchHoverEndInternal=function(e){this.endDrag();var t=this.GetLogicalObject(e.target);t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))},i.prototype.HandleTouchClickInternal=function(e){var t=this.GetLogicalObject(e.target);t&&(t.isSelectable&&t.isSelectable()||this.processDrillEvent(t))},i.prototype.HandleTouchDblClickInternal=function(e){var t=this.GetLogicalObject(e.target);t&&t.isSelectable&&t.isSelectable()&&(e.preventDefault(),e.stopPropagation(),this.processDrillEvent(t))},i.prototype.processDrillEvent=function(t){if(t&&t.isDrillable&&t.isDrillable()){var i=t.getId();t instanceof n?this.FireEvent(e.EventFactory.newChartDrillEvent(null!=i.id?i.id:i,t.getSeries(),t.getGroup())):t instanceof z&&this.FireEvent(e.EventFactory.newChartDrillEvent(i.id,i.series,i.group))}},i.prototype.ProcessRolloverEvent=function(t,i,r){var n=this._chart.getOptions();if("dim"==Q.getHoverBehavior(this._chart)){var a=i.getCategories?i.getCategories():[];n.highlightedCategories=r?a.slice():null;var o=e.EventFactory.newCategoryHighlightEvent(n.highlightedCategories,r),s=te.getHoverBehaviorDelay(this._chart),l=this._chart.getObjects();this._chart.pieChart&&(l=l.concat(this._chart.pieChart.__getSlices())),this.RolloverHandler.processEvent(o,l,s,"any"==n.highlightMatch)}},i.prototype._onTouchDragStart=function(e){var t,i,r=e.touches;if(1==r.length){var n=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),a=this._getDragHandler();a?t=a.processDragStart(n,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(n),i=!0)}else if(2==r.length&&this._panZoomHandler&&Q.isZoomable(this._chart)){this.endDrag();var o=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),s=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);t=this._panZoomHandler.processPinchStart(o,s)}return t&&(this._callback.call(this._callbackObj,t),this.getCtx().getTooltipManager().hideTooltip()),!(!t&&!i||(e.preventDefault(),e.stopPropagation(),this.setDragButtonsVisible(!1),0))},i.prototype._onTouchDragMove=function(e){var t,i,r=e.touches;if(1==r.length){var n=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),a=this._getDragHandler();a?t=a.processDragMove(n,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(n),i=!0)}else if(2==r.length&&this._panZoomHandler&&Q.isZoomable(this._chart)){var o=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),s=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);t=this._panZoomHandler.processPinchMove(o,s)}(t||i)&&e.preventDefault(),t&&(this._callback.call(this._callbackObj,t),this.getCtx().getTooltipManager().hideTooltip())},i.prototype._onTouchDragEnd=function(e){var t,i=this.endDrag();if(this._panZoomHandler&&Q.isZoomable(this._chart)&&(t=this._panZoomHandler.processPinchEnd())&&this._callback.call(this._callbackObj,t),i||t){e.preventDefault(),this.getCtx().getTooltipManager().hideTooltip();var r=this.getTouchManager(),n=1==e.changedTouches.length?e.changedTouches[0].identifier:null,a=null!=n?r.getTouchInfo(n):null;a&&!a.touchMoved||r.reset()}this.setDragButtonsVisible(!0)},i.prototype.endDrag=function(){var e,t=this._getDragHandler();return t&&(e=t.processDragEnd(null,!0)),this._dataCursorHandler&&this._dataCursorHandler.processEnd(),e&&this._callback.call(this._callbackObj,e),e},i.prototype.zoomBy=function(e){if(this._panZoomHandler&&Q.isZoomable(this._chart)){var t=this._panZoomHandler.zoomBy(e);t&&this._callback.call(this._callbackObj,t)}},i.prototype.panBy=function(e,t){if(this._panZoomHandler&&Q.isScrollable(this._chart)){var i=this._panZoomHandler.panBy(e,t);i&&this._callback.call(this._callbackObj,i)}},i.prototype.hideHoverFeedback=function(){this.hideTooltip(),this._dataCursorHandler&&this._dataCursorHandler.processEnd()},i.prototype.hideTooltip=function(){this._dataCursorHandler&&this._dataCursorHandler.isDataCursorShown()||i.superclass.hideTooltip.call(this)},i.prototype.getTooltipsEnabled=function(e){return(!this._dataCursorHandler||!(e instanceof n||e instanceof a||this._dataCursorHandler.isDataCursorShown()))&&i.superclass.getTooltipsEnabled.call(this)},i.prototype.getDataCursorHandler=function(){return this._dataCursorHandler},i.prototype.setDataCursorHandler=function(e){this._dataCursorHandler=e},i.prototype.setPanZoomHandler=function(e){this._panZoomHandler=e},i.prototype.setMarqueeZoomHandler=function(e){this._marqueeZoomHandler=e},i.prototype.setMarqueeSelectHandler=function(e){this._marqueeSelectHandler=e},i.prototype.getMarqueeGlassPane=function(){return this._dragMode==i.DRAG_MODE_ZOOM?this._marqueeZoomHandler.getGlassPane():this._dragMode==i.DRAG_MODE_SELECT?this._marqueeSelectHandler.getGlassPane():null},i.prototype.cancelMarquee=function(e){this._dragMode==i.DRAG_MODE_ZOOM?this._marqueeZoomHandler.cancelMarquee()&&e.preventDefault():this._dragMode==i.DRAG_MODE_SELECT&&this._marqueeSelectHandler&&this._marqueeSelectHandler.cancelMarquee()&&this._chart.render()},i.prototype.getDragMode=function(){return this._dragMode},i.prototype.setDragMode=function(e){this._dragMode=null==e?this._getDefaultDragMode():e,!this._chart.xAxis.isFullViewport()||this._chart.yAxis&&!this._chart.yAxis.isFullViewport()||this.autoToggleZoomButton()},i.prototype._getDefaultDragMode=function(){return e.Agent.isTouchDevice()?i.DRAG_MODE_OFF:Q.isScrollable(this._chart)?i.DRAG_MODE_PAN:"multiple"==this._chart.getOptions().selectionMode?i.DRAG_MODE_SELECT:null},i.prototype.onZoomButtonClick=function(e){this.zoomButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(i.DRAG_MODE_ZOOM)):this.setDragMode(null)},i.prototype.onPanButtonClick=function(e){this.panButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(i.DRAG_MODE_PAN)):this.setDragMode(null)},i.prototype.onSelectButtonClick=function(e){this.selectButton.isToggled()?(this.zoomButton&&this.zoomButton.setToggled(!1),this.panButton&&this.panButton.setToggled(!1),this.setDragMode(i.DRAG_MODE_SELECT)):this.setDragMode(null)},i.prototype.setDragButtonsVisible=function(e){e&&!this._dragButtonsVisible?(this._chart.showDragButtons(),this._dragButtonsVisible=!0):!e&&this._dragButtonsVisible&&(this._chart.hideDragButtons(),this._dragButtonsVisible=!1)},i.prototype.areDragButtonsVisible=function(){return this._dragButtonsVisible},i.prototype.autoToggleZoomButton=function(){!e.Agent.isTouchDevice()&&this.zoomButton&&(this._chart.xAxis.isFullViewport()&&this._chart.yAxis.isFullViewport()?this._dragMode==i.DRAG_MODE_PAN&&(this.zoomButton.setToggled(!0),this.onZoomButtonClick(null)):this._dragMode==i.DRAG_MODE_ZOOM&&(this.zoomButton.setToggled(!1),this.onZoomButtonClick(null)))},i.prototype.GetTouchResponse=function(){return this._dragMode&&this._dragMode!=i.DRAG_MODE_OFF?e.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:this._chart.getOptions().touchResponse},i.prototype.isDndSupported=function(){return!0},i.prototype.GetDragSourceType=function(e){var t=this.DragSource.getDragObject();return t instanceof n&&t.getSeriesIndex()>=0&&t.getGroupIndex()>=0||t instanceof z?"items":null},i.prototype.GetDragDataContexts=function(t){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],a=0;a<i.length;a++){var o=J.getDataContext(this._chart,i[a].getSeriesIndex(),i[a].getGroupIndex(),i[a].getNestedDataItemIndex());t&&e.ToolkitUtils.cleanDragDataContext(o),r.push(o)}return r}var s=this.DragSource.getDragObject(),l=null;return s instanceof n&&(l=J.getDataContext(this._chart,s.getSeriesIndex(),s.getGroupIndex(),s.getNestedDataItemIndex())),s instanceof z&&(l=J.getDataContext(this._chart,s.getSeriesIndex(),0)),l&&t&&e.ToolkitUtils.cleanDragDataContext(l),l?[l]:null},i.prototype.GetDropOffset=function(t){var i=this.DragSource.getDragObject();if(i instanceof n){var r=i.getDataPosition();if(r){r=this._chart.getPlotArea().localToStage(r);var a=this._context.pageToStageCoords(t.pageX,t.pageY);return new e.Point(r.x-a.x,r.y-a.y)}}return null},i.prototype.GetDropTargetType=function(e){var t=this._context.pageToStageCoords(e.pageX,e.pageY),i=this._chart.getOptions().dnd.drop,r=this._chart.__getPlotAreaSpace();return Object.keys(i.plotArea).length>0&&r.containsPoint(t.x,t.y)?"plotArea":Object.keys(i.xAxis).length>0&&Z.isAxisRendered(this._chart,"x")&&Z.axisContainsPoint(this._chart.xAxis,t)?"xAxis":Object.keys(i.yAxis).length>0&&Z.isAxisRendered(this._chart,"y")&&Z.axisContainsPoint(this._chart.yAxis,t)?"yAxis":Object.keys(i.y2Axis).length>0&&Z.isAxisRendered(this._chart,"y2")&&Z.axisContainsPoint(this._chart.y2Axis,t)?"y2Axis":null},i.prototype.GetDropEventPayload=function(t){var i=t.getNativeEvent().dataTransfer,r=Number(i.getData(e.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,n=Number(i.getData(e.EventManager.DROP_OFFSET_Y_DATA_TYPE))||0,a=this._context.pageToStageCoords(t.pageX,t.pageY);return this._chart.getValuesAt(a.x+r,a.y+n)},i.prototype.ShowDropEffect=function(e){var t=this._getDropObject(e);t&&(t.setClassName("oj-active-drop"),t.setSolidFill(this._chart.getOptions()._dropColor))},i.prototype.ClearDropEffect=function(){var t=this._chart.getCache().getFromCache("plotAreaBackground");if(t){var i=te.getBackgroundColor(this._chart);i?t.setSolidFill(i):t.setInvisibleFill(),e.ToolkitUtils.removeClassName(t.getElem(),"oj-invalid-drop"),e.ToolkitUtils.removeClassName(t.getElem(),"oj-active-drop")}var r=function(t){if(t){var i=t.getCache().getFromCache("background");i&&(i.setInvisibleFill(),e.ToolkitUtils.removeClassName(i.getElem(),"oj-invalid-drop"),e.ToolkitUtils.removeClassName(i.getElem(),"oj-active-drop"))}};r(this._chart.xAxis),r(this._chart.yAxis),r(this._chart.y2Axis)},i.prototype.ShowRejectedDropEffect=function(e){var t=this._getDropObject(e);t&&t.setClassName("oj-invalid-drop")},i.prototype._getDropObject=function(e){var t,i=this.GetDropTargetType(e);return"plotArea"==i?t=this._chart.getCache().getFromCache("plotAreaBackground"):"xAxis"==i?t=this._chart.xAxis.getCache().getFromCache("background"):"yAxis"==i?t=this._chart.yAxis.getCache().getFromCache("background"):"y2Axis"==i&&(t=this._chart.y2Axis.getCache().getFromCache("background")),t},i.prototype.isClearMenuAllowed=function(e){return e&&e.getParams&&"plotArea"==e.getParams().type};var r=function(e,t){this.Init(e,t)};e.Obj.createSubclass(r,e.KeyboardHandler),r.prototype.Init=function(e,t){r.superclass.Init.call(this,e),this._chart=t},r.prototype.isSelectionEvent=function(e){return this.isNavigationEvent(e)&&!e.ctrlKey},r.prototype.isMultiSelectEvent=function(t){return t.keyCode==e.KeyboardEvent.SPACE&&t.ctrlKey},r.prototype.processKeyDown=function(t){var i=t.keyCode;if(i==e.KeyboardEvent.TAB){if(a=this._eventManager.getFocus())return e.EventManager.consumeEvent(t),a;var n=Q.getKeyboardNavigables(this._chart);if(n.length>0)return e.EventManager.consumeEvent(t),this.getDefaultNavigable(n)}else if(i==e.KeyboardEvent.ENTER){var a;if(a=this._eventManager.getFocus())return this._eventManager.processDrillEvent(a),e.EventManager.consumeEvent(t),a}else i==e.KeyboardEvent.ESCAPE?this._eventManager.cancelMarquee(t):i==e.KeyboardEvent.PAGE_UP?((t.ctrlKey||t.shiftKey||ne.isBLAC(this._chart))&&ne.isVertical(this._chart)?this._eventManager.panBy(-.25,0):this._eventManager.panBy(0,-.25),e.EventManager.consumeEvent(t)):i==e.KeyboardEvent.PAGE_DOWN?((t.ctrlKey||t.shiftKey||ne.isBLAC(this._chart))&&ne.isVertical(this._chart)?this._eventManager.panBy(.25,0):this._eventManager.panBy(0,.25),e.EventManager.consumeEvent(t)):e.KeyboardEvent.isEquals(t)||e.KeyboardEvent.isPlus(t)?this._eventManager.zoomBy(1.5):(e.KeyboardEvent.isMinus(t)||e.KeyboardEvent.isUnderscore(t))&&this._eventManager.zoomBy(1/1.5);return r.superclass.processKeyDown.call(this,t)},r.prototype.getDefaultNavigable=function(e){if(!e||e.length<=0)return null;for(var t,i,r,n,a=ne.isPie(this._chart),o=0;o<e.length;o++)n=e[o],!t||n.getSeriesIndex()<i?(t=n,i=n.getSeriesIndex(),a||(r=n.getGroupIndex())):!a&&n.getGroupIndex()<r&&(t=n,i=n.getSeriesIndex(),r=n.getGroupIndex());return t};var n=function(e,t,i,r,n,a){this.Init(e,t,i,r,n,a)};e.Obj.createSubclass(n,e.Obj),n.prototype.Init=function(t,i,r,n,a,o){if(this._chart=t,this._displayables=i,this._seriesIndex=null!=r&&r>=0?r:-1,this._groupIndex=null!=n&&n>=0?n:-1,this._itemIndex=null!=a&&a>=0?a:-1,this._dataPos=o,this._isSelected=!1,this._isShowingKeyboardFocusEffect=!1,this._series=J.getSeries(t,r),this._group=J.getGroup(t,n),this._categories=J.getCategories(t,r,n,a),-1!=this._itemIndex?(this._dataItemId=J.getNestedDataItemId(t,r,n,a),this._drillable=Q.isDataItemDrillable(t,r,n,a)):-1!=this._groupIndex?J.getDataItem(t,r,n)&&(this._dataItemId=J.getDataItemId(t,r,n),this._drillable=Q.isDataItemDrillable(t,r,n)):J.getSeriesItem(t,r)&&(this._drillable=Q.isSeriesDrillable(t,r)),this._drillable)for(var s=0;s<this._displayables.length;s++)this._displayables[s].setCursor(e.SelectionEffectUtils.getSelectingCursor());for(var l=0;l<i.length;l++){var h=i[l];h instanceof w||h.setAriaRole("img"),this._updateAriaLabel(h)}},n.associate=function(e,t,i,r,a,o){if(e&&!t.getOptions()._duringZoomAndScroll){var s=new n(t,[e],i,r,a,o);t.registerObject(s),t.getEventManager().associate(e,s)}},n.prototype.getId=function(){return this._seriesIndex>=0&&this._groupIndex>=0?new o(this._dataItemId,this.getSeries(),this.getGroup(),this._chart.getCtx()):this._seriesIndex>=0?this.getSeries():null},n.prototype.getDataItemId=function(){return this._dataItemId},n.prototype.getNestedDataItemIndex=function(){return this._itemIndex},n.prototype.getSeries=function(){return this._series},n.prototype.getSeriesIndex=function(){return this._seriesIndex},n.prototype.getGroup=function(){return this._group},n.prototype.getGroupIndex=function(){return this._groupIndex},n.prototype.isDrillable=function(){return this._drillable},n.prototype.isDoubleClickable=function(){return this.isSelectable()&&this.isDrillable()},n.prototype.getChart=function(){return this._chart},n.prototype.getDatatip=function(e){return re.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!0)},n.prototype.getDatatipColor=function(){return re.getDatatipColor(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex)},n.prototype.isSelectable=function(){return te.isSelectable(this.getChart(),this.getSeriesIndex(),this.getGroupIndex())},n.prototype.isSelected=function(){return this._isSelected},n.prototype.setSelected=function(e){this._isSelected=e;for(var t=0;t<this._displayables.length;t++)this._displayables[t].setSelected&&(this._displayables[t].setSelected(e),this._updateAriaLabel(this._displayables[t]))},n.prototype.showHoverEffect=function(){for(var e=0;e<this._displayables.length;e++)this._displayables[e].showHoverEffect&&this._displayables[e].showHoverEffect()},n.prototype.hideHoverEffect=function(){for(var e=0;e<this._displayables.length;e++)this._displayables[e].hideHoverEffect&&this._displayables[e].hideHoverEffect()},n.prototype.getDisplayables=function(){return this._displayables},n.prototype.getAriaLabel=function(){var t=[],i=this.getChart().getOptions().translations;this.isSelectable()&&t.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),this.isDrillable()&&t.push(i.stateDrillable);var r=re.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!1);return null==r&&this._groupIndex<0&&t.length>0&&(r=J.getSeriesLabel(this._chart,this._seriesIndex)),e.Displayable.generateAriaLabel(r,t)},n.prototype._updateAriaLabel=function(t){e.Agent.deferAriaCreation()||t.setAriaProperty("label",this.getAriaLabel())},n.prototype.getCategories=function(e){return this._categories},n.prototype.getDataPosition=function(){return this._dataPos},n.prototype.getNextNavigable=function(t){var i,r;if(i=t.keyCode,t.type==e.MouseEvent.CLICK)return this;if(i==e.KeyboardEvent.SPACE&&t.ctrlKey)return this;for(var n=this._chart,a=n.getChartObjPeers(),o=[],s=0;s<a.length;s++)a[s].isNavigable()&&o.push(a[s]);var l=t.keyCode==e.KeyboardEvent.UP_ARROW||t.keyCode==e.KeyboardEvent.DOWN_ARROW,h=ne.isHorizontal(n),u=e.Agent.isRightToLeft(n.getCtx());return ne.isScatterBubble(n)||ne.isBoxPlot(n)&&(l&&!h||!l&&h)?r=e.KeyboardHandler.getNextAdjacentNavigable(this,t,o):ne.isLineArea(n)||ne.isStacked(n)||ne.isPolar(n)?r=this._findNextNavigable(t):ne.isFunnel(n)&&l?(t.keyCode=u?t.keyCode==e.KeyboardEvent.UP_ARROW?e.KeyboardEvent.RIGHT_ARROW:e.KeyboardEvent.LEFT_ARROW:t.keyCode-1,r=e.KeyboardHandler.getNextNavigable(this,t,o)):ne.isPyramid(n)&&!l?(t.keyCode=u?t.keyCode==e.KeyboardEvent.RIGHT_ARROW?e.KeyboardEvent.DOWN_ARROW:e.KeyboardEvent.UP_ARROW:t.keyCode==e.KeyboardEvent.RIGHT_ARROW?e.KeyboardEvent.UP_ARROW:e.KeyboardEvent.DOWN_ARROW,r=e.KeyboardHandler.getNextNavigable(this,t,o)):r=e.KeyboardHandler.getNextNavigable(this,t,o,!0),r},n.prototype.getKeyboardBoundingBox=function(t){return this._displayables[0]?this._displayables[0].getDimensions(t):new e.Rectangle(0,0,0,0)},n.prototype.getTargetElem=function(){return this._displayables[0]?this._displayables[0].getElem():null},n.prototype.showKeyboardFocusEffect=function(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect())},n.prototype.hideKeyboardFocusEffect=function(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect())
},n.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},n.prototype.isNavigable=function(){return-1!=this.getGroupIndex()&&-1!=this.getSeriesIndex()},n.prototype._findNextNavigable=function(t){var i,r,n=t.keyCode,a=this._chart,o=a.getCtx(),s=this.getSeriesIndex(),l=this.getGroupIndex(),h=J.getGroupCount(a),u=ne.isHorizontal(a),g=ne.isPolar(a),d=e.Agent.isRightToLeft(o),p=u?d?n==e.KeyboardEvent.LEFT_ARROW:n==e.KeyboardEvent.RIGHT_ARROW:n==e.KeyboardEvent.UP_ARROW,c=u?d?n==e.KeyboardEvent.RIGHT_ARROW:n==e.KeyboardEvent.LEFT_ARROW:n==e.KeyboardEvent.DOWN_ARROW,_=u?n==e.KeyboardEvent.UP_ARROW:d?n==e.KeyboardEvent.RIGHT_ARROW:n==e.KeyboardEvent.LEFT_ARROW,f=u?n==e.KeyboardEvent.DOWN_ARROW:d?n==e.KeyboardEvent.LEFT_ARROW:n==e.KeyboardEvent.RIGHT_ARROW;if(p)r=l,i=this._findNextUpSeries(a,s,l);else if(c)r=l,i=this._findNextDownSeries(a,s,l);else if(f){i=s,r=l;do{r++,g&&r>=h&&(r=0)}while(null==a.getObject(i,r)&&r<h)}else if(_){i=s,r=l;do{r--,g&&r<0&&(r=h-1)}while(null==a.getObject(i,r)&&r>-1)}var m=a.getObject(i,r);return m&&m.isNavigable()?m:this},n.prototype._findNextUpSeries=function(e,t,i){for(var r=J.getSeriesCount(e),n=J.getCumulativeValue(e,t,i),a=null,o=null,s=0;s<r;s++)if(te.isSeriesRendered(e,s)&&null!=J.getValue(e,s,i)){var l=J.getCumulativeValue(e,s,i);(l>n||l==n&&s>t)&&(null!==a&&l<a||null==a)&&(a=l,o=s)}return o},n.prototype._findNextDownSeries=function(e,t,i){for(var r=J.getSeriesCount(e),n=J.getCumulativeValue(e,t,i),a=null,o=null,s=r-1;s>=0;s--)if(te.isSeriesRendered(e,s)&&null!=J.getValue(e,s,i)){var l=J.getCumulativeValue(e,s,i);(l<n||l==n&&s<t)&&(null!==a&&l>a||null==a)&&(a=l,o=s)}return o},n.prototype.isDragAvailable=function(e){return!0},n.prototype.getDragTransferable=function(e,t){return[this.getId()]},n.prototype.getDragFeedback=function(e,t){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],n=0;n<i.length;n++)r=r.concat(i[n].getDisplayables());return r}return this._displayables};var a=function(e,t,i,r,n){this.Init(e,t,i,r,n)};e.Obj.createSubclass(a,e.Obj),a.prototype.Init=function(e,t,i,r,n){this._chart=e,this._displayables=t,this._refObj=i,this._categories=$.getRefObjCategories(this._refObj),this._index=r,this._axisType=n;for(var a=0;a<t.length;a++){var o=t[a];o.setAriaRole("img"),o.setAriaProperty("label",i.shortDesc)}},a.prototype.getCategories=function(){return this._categories},a.prototype.getDisplayables=function(){return this._displayables},a.prototype.getIndex=function(){return this._index},a.prototype.getAxisType=function(){return this._axisType},a.prototype.getDatatip=function(e){return re.getRefObjTooltip(this._chart,this._refObj,this._axisType,this._index)},a.prototype.getDatatipColor=function(){return $.getColor(this._refObj)};var o=function(e,t,i,r){this.id=e,this.series=t,this.group=i,this.context=r};e.Obj.createSubclass(o,e.Obj),o.prototype.equals=function(e){return e instanceof o&&(null!=this.id||null!=e.id?J.isEqualId(this.id,e.id,this.context):J.isEqualId(this.series,e.series,this.context)&&J.isEqualId(this.group,e.group,this.context))},o.prototype.toString=function(){return null!=this.id&&"object"!=typeof this.id?this.id.toString():J.createDataItemId(this.series,this.group)},o.prototype.valueOf=function(){return this.toString()};var s=function(e){this.Init({alta:s.SKIN_ALTA},e)};e.Obj.createSubclass(s,e.BaseComponentDefaults),s.SKIN_ALTA={skin:e.CSSStyle.SKIN_ALTA,emptyText:null,type:"bar",stack:"off",stackLabel:"off",orientation:"vertical",polarGridShape:"circle",selectionMode:"none",hideAndShowBehavior:"none",hoverBehavior:"none",zoomAndScroll:"off",zoomDirection:"auto",initialZooming:"none",dragMode:"user",sorting:"off",otherThreshold:0,animationOnDataChange:"none",animationOnDisplay:"none",__sparkBarSpacing:"subpixel",__spark:!1,dataCursor:"auto",dataCursorBehavior:"auto",drilling:"off",highlightMatch:"all",series:[],groups:[],title:{style:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_13+"color: #252525;"),halign:"start"},subtitle:{style:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #252525;")},footnote:{style:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),halign:"start"},titleSeparator:{upperColor:"#74779A",lowerColor:"#FFFFFF",rendered:"off"},touchResponse:"auto",_statusMessageStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_13+"color: #252525;"),_dropColor:"#D9F4FA",xAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"on"},scale:"linear"},yAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear"},y2Axis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear",alignTickMarks:"on"},zAxis:{},pieCenter:{labelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA)},plotArea:{backgroundColor:null},legend:{position:"auto",rendered:"auto",layout:{gapRatio:1},seriesSection:{},referenceObjectSection:{},sections:[]},overview:{rendered:"off"},dnd:{drag:{items:{},series:{},groups:{}},drop:{plotArea:{},xAxis:{},yAxis:{},y2Axis:{},legend:{}}},styleDefaults:{colors:e.CSSStyle.COLORS_ALTA,borderColor:"auto",borderWidth:"auto",patterns:["smallDiagonalRight","smallChecker","smallDiagonalLeft","smallTriangle","smallCrosshatch","smallDiamond","largeDiagonalRight","largeChecker","largeDiagonalLeft","largeTriangle","largeCrosshatch","largeDiamond"],shapes:["square","circle","diamond","plus","triangleDown","triangleUp"],seriesEffect:"color",threeDEffect:"off",selectionEffect:"highlight",animationDuration:1e3,animationIndicators:"all",animationUpColor:"#0099FF",animationDownColor:"#FF3300",lineStyle:"solid",lineType:"auto",markerDisplayed:"auto",markerColor:null,markerShape:"auto",markerSize:10,marqueeColor:"rgba(255,255,255,0.4)",marqueeBorderColor:"#0572ce",pieFeelerColor:"#BAC5D6",pieInnerRadius:0,selectedInnerColor:"#ffffff",selectedOuterColor:"#5a5a5a",sliceLabelType:"percent",otherColor:"#4b4b4b",stockRisingColor:"#6b6f74",stockFallingColor:"#ED6647",stockRangeColor:"#B8B8B8",dataItemGaps:"auto",dataLabelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_11),dataLabelPosition:"auto",funnelBackgroundColor:"#EDEDED",x1Format:{},y1Format:{},y2Format:{},zFormat:{},_defaultSliceLabelColor:"#333333",_scrollbarHeight:3,_scrollbarTrackColor:"#F0F0F0",_scrollbarHandleColor:"#9E9E9E",hoverBehaviorDelay:200,dataCursor:{markerSize:8,markerDisplayed:"on",lineColor:"#5a5a5a",lineWidth:2,lineStyle:"solid"},groupSeparators:{rendered:"on",color:"rgba(138,141,172,0.4)"},padding:"auto",_tooltipStyle:new e.CSSStyle("border-collapse: separate; border-spacing: 2px; overflow: hidden; display: block;"),tooltipLabelStyle:new e.CSSStyle("color: #666666; padding: 0px 2px; white-space: nowrap;"),tooltipValueStyle:new e.CSSStyle("color: #333333; padding: 0px 2px;"),stackLabelStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_11),boxPlot:{whiskerSvgStyle:{},whiskerEndSvgStyle:{strokeWidth:2},whiskerEndLength:9,medianSvgStyle:{strokeWidth:3}}},layout:{gapWidthRatio:null,gapHeightRatio:null,outerGapWidth:10,outerGapHeight:8,titleSubtitleGapWidth:14,titleSubtitleGapHeight:4,titleSeparatorGap:6,titlePlotAreaGap:16,footnoteGap:10,verticalAxisGap:6,legendGapWidth:15,legendGapHeight:10,tickLabelGapHeight:8,tickLabelGapWidth:9},_locale:"en-us",_resources:{}},s.getGapWidth=function(e,t){return Math.ceil(t*e.getGapWidthRatio())},s.getGapHeight=function(e,t){return Math.ceil(t*e.getGapHeightRatio())},s.prototype.getNoCloneObject=function(e){return{}};var l=function(e,t){this.Init(e,t)};e.Obj.createSubclass(l,e.Obj),l.prototype.Init=function(e,t){this._context=e.getCtx(),this._dataCursorShown=!1,this._dataCursor=t,this._chart=e},l.prototype.processMove=function(e,t){var i=this._chart.__getPlotAreaSpace();return i&&i.containsPoint(e.x,e.y)&&!this._chart.getOptions()._duringZoomAndScroll?(this._showDataCursor(i,e.x,e.y,t),!0):(this._removeDataCursor(t),!1)},l.prototype.processEnd=function(e){this._removeDataCursor(e)},l.prototype.processOut=function(e,t){var i=this._chart.__getPlotAreaSpace();i&&!i.containsPoint(e.x,e.y)&&this._removeDataCursor(t)},l.prototype._showDataCursor=function(e,t,i,r){if(this._context.isOffscreen(!0))this._removeDataCursor(r);else{var n=this._dataCursor,a=this._getClosestMatch(t,i);if(null!=a){var o=a.matchRegion.getCenter(),s=t,l=i;n.getBehavior()==L.BEHAVIOR_SNAP&&(n.isHorizontal()?l=Math.min(Math.max(o.y,e.y),e.y+e.h):s=Math.min(Math.max(o.x,e.x),e.x+e.w));var h=a.logicalObject,u=re.getDatatip(this._chart,h.getSeriesIndex(),h.getGroupIndex(),h.getNestedDataItemIndex(),!0);if(null!=u){n.setVisible(!0);var g=re.getDatatipColor(this._chart,h.getSeriesIndex(),h.getGroupIndex(),h.getNestedDataItemIndex()),d=n.isHorizontal()?l:s;if(n.render(e,o.x,o.y,d,u,g),this._dataCursorShown=!0,!r){var p=this._chart.getValuesAt(t,i);this._chart.changeOption("dataCursorPosition",p)}}else n.setVisible(!1)}else this._removeDataCursor(r)}},l.prototype._removeDataCursor=function(e){this._dataCursor.getVisible()&&this._dataCursor.setVisible(!1),this._context.getTooltipManager(L.TOOLTIP_ID).hideTooltip(),this._dataCursorShown=!1,e||this._chart.changeOption("dataCursorPosition",null)},l.prototype.isDataCursorShown=function(){return this._dataCursorShown},l._getClosestMatchSecondDirection=function(e,t,i,r){for(var n=null,a=1/0,o=0;o<e.length;o++){var s=e[o],l=t?i:r,h=((t?s.matchRegion.x:s.matchRegion.y)+(t?s.matchRegion.x+s.matchRegion.w:s.matchRegion.y+s.matchRegion.h))/2,u=Math.round(Math.abs(h-l));u<a&&(a=u,n=s)}return n},l._getClosestMatchesFirstDirection=function(e,t,i,r,n){for(var a=1/0,o=new Array,s=0;s<e.length;s++){var l=e[s];if(n(l.logicalObject)){var h=l.matchRegion,u=t?r:i,g=((t?h.y:h.x)+(t?h.y+h.h:h.x+h.w))/2,d=Math.round(Math.abs(g-u));d<=a&&(d<a&&(o=new Array),o.push(l),a=d)}}return o},l.prototype._findMatches=function(){var e=this._context.getStage(),t=this._chart.getEventManager(),i=[];if(!this._chart._currentMarkers)return null;for(var r=0;r<this._chart._currentMarkers.length;r++)for(var n=this._chart._currentMarkers[r],a=n.length,o=0;o<a;o++){var s=n[o],l=t.GetLogicalObject(s),h={matchRegion:s.getDimensionsSelf?s.getDimensionsSelf(e):s.getDimensions(e),logicalObject:l};i.push(h)}return i},l.prototype._getClosestMatch=function(t,i){var r=ne.isHorizontal(this._chart),n=ne.isLineArea(this._chart)&&!Z.isMixedFrequency(this._chart),a=this._findMatches(),o=te.getHighlightedCategories(this._chart),s="all"==this._chart.getOptions().highlightMatch,h=o.length>0?s?e.ArrayUtils.hasAllItems:e.ArrayUtils.hasAnyItem:null,u=function(e){return!h||h(e.getCategories(),o)},g=l._getClosestMatchesFirstDirection(a,r,t,i,u);if(!ne.isScatterBubble(this._chart)){for(var d=1/0,p=-1/0,c=null,_=0;_<g.length;_++){var f=g[_];d=Math.min(d,r?f.matchRegion.y:f.matchRegion.x),p=Math.max(p,r?f.matchRegion.y+f.matchRegion.h:f.matchRegion.x+f.matchRegion.w),c=f.logicalObject.getGroupIndex()}for(_=0;_<a.length;_++){var m=a[_];if(u(m.logicalObject))if(n)m.logicalObject.getGroupIndex()==c&&g.push(m);else{var v=((r?m.matchRegion.y:m.matchRegion.x)+(r?m.matchRegion.y+m.matchRegion.h:m.matchRegion.x+m.matchRegion.w))/2;p>=v&&d<=v&&g.push(m)}}}return l._getClosestMatchSecondDirection(g,r,t,i)};var h=function(){};e.Obj.createSubclass(h,e.BaseComponent),h.newInstance=function(e,t,i){var r=new h;return r.Init(e,t,i),r},h.getDefaults=function(e){return(new d).getDefaults(e)},h.prototype.Init=function(t,i,r){h.superclass.Init.call(this,t,i,r),this.Defaults=new d(t),this.EventManager=new p(this),this.EventManager.addListeners(this),e.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new c(this.EventManager,this)),this._bounds=null},h.prototype.SetOptions=function(e){e?this.Options="off"==e.rendered?e:this.Defaults.calcOptions(e):this.Options||(this.Options=this.GetDefaults())},h.prototype.getPreferredSize=function(e,t,i){return this.SetOptions(e),_.getPreferredSize(this,t,i)},h.prototype.render=function(t,i,r,n,a){this.getCache().clearCache(),this.SetOptions(t),this._navigablePeers=[],this.Width=i,this.Height=r,this.removeChildren(),n||(n=0),a||(a=0);var o=new e.Rectangle(n,a,i,r);_.render(this,o)},h.prototype.__registerObject=function(e){(null!=e.getDatatip()||e.isDrillable())&&this._navigablePeers.push(e)},h.prototype.__getKeyboardObjects=function(){return this._navigablePeers},h.prototype.isNavigable=function(){return this._navigablePeers.length>0},h.prototype.getKeyboardFocus=function(){return null!=this.EventManager?this.EventManager.getFocus():null},h.prototype.setKeyboardFocus=function(t,i){if(null!=this.EventManager){for(var r=this.__getKeyboardObjects(),n=t.getId(),a=!1,o=0;o<r.length;o++){var s=r[o].getId();if(n instanceof Array&&s instanceof Array&&e.ArrayUtils.equals(n,s)||n===s){this.EventManager.setFocusObj(r[o]),a=!0,i&&r[o].showKeyboardFocusEffect();break}}a||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(r));var l=this.getKeyboardFocus();if(l){var h=l.getDisplayable();h.setAriaProperty("label",l.getAriaLabel()),this.getCtx().setActiveElement(h)}}},h.prototype.processEvent=function(e,t){this===t&&this.dispatchEvent(e)},h.prototype.getInfo=function(){return this.Info},h.prototype.__setInfo=function(e){this.Info=e},h.prototype.getWidth=function(){return this.Width},h.prototype.getHeight=function(){return this.Height},h.prototype.__setBounds=function(e){this._bounds=e},h.prototype.__getBounds=function(){return this._bounds},h.prototype.getAutomation=function(){return new g(this)};var u={};e.Obj.createSubclass(u,e.Obj),u.TICK_LABEL="tickLabel",u.TITLE="title";var g=function(e){this._axis=e,this._options=this._axis.getOptions(),this._axisInfo=this._axis.getInfo()};e.Obj.createSubclass(g,e.Automation),g.prototype.GetSubIdForDomElement=function(t){var i=this._axis.getEventManager().GetLogicalObject(t);if(i&&i instanceof e.SimpleObjPeer){if(i.getParams().type==u.TITLE)return"title";if(this._options.groups){for(var r=i.getParams().level,n=this._axisInfo.getStartIndex(i.getParams().index,r),a="",o=0;o<=r;o++)for(var s=this._axisInfo.getLabels(this._axis.getCtx(),o),l=0;l<s.length;l++){var h=this._axisInfo.getLabelIndex(s[l]);this._axisInfo.getStartIndex(h,o)<=n&&this._axisInfo.getEndIndex(h,o)>=n&&(a+="["+this._axisInfo.getPosition(h,o)+"]")}if(a.length>0)return"item"+a}}return null},g.prototype.getDomElementForSubId=function(e){if("title"==e){var t=this._axisInfo.getTitle();if(t)return t.getElem()}else if(this._axisInfo instanceof v)for(var i=e.split("[").length-1-1,r=0,n=0,a=0;a<=i;a++){var o=e.indexOf("["),s=e.indexOf("]"),l=e.substring(o+1,s);e=e.substring(s+1);for(var h,u=this._axisInfo.getLabels(this._axis.getCtx(),a),g=0;g<u.length;g++)if(h=this._axisInfo.getLabelIndex(u[g]),this._axisInfo.getStartIndex(h,a)==n){r=h;break}for(var d=r;d<u.length;d++)if(h=this._axisInfo.getLabelIndex(u[d]),this._axisInfo.getPosition(h,a)==l){if(0==e.length)return u[d].getElem();n=this._axisInfo.getStartIndex(h,a);break}}return null};var d=function(e){this.Init({alta:d.SKIN_ALTA},e)};e.Obj.createSubclass(d,e.BaseComponentDefaults),d.SKIN_ALTA={position:null,baselineScaling:"zero",axisLine:{lineColor:"#9E9E9E",lineWidth:1,rendered:"on"},majorTick:{lineColor:"rgba(196,206,215,0.4)",baselineColor:"auto",lineWidth:1,rendered:"auto",lineStyle:"solid"},minorTick:{lineColor:"rgba(196,206,215,0.2)",lineWidth:1,rendered:"off",lineStyle:"solid"},tickLabel:{scaling:"auto",style:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),rotation:"auto",rendered:"on"},titleStyle:new e.CSSStyle(e.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #737373;"),startGroupOffset:0,endGroupOffset:0,layout:{titleGap:6,radialLabelGap:5,insideLabelGapWidth:4,insideLabelGapHeight:2,hierarchicalLabelGapHeight:8,hierarchicalLabelGapWidth:15},_locale:"en-us"},d.getGapSize=function(t,i,r){var n=Math.min(e.TextUtils.getTextStringHeight(t,i.tickLabel.style)/14,1);return Math.ceil(r*n)};var p=function(e){this.Init(e.getCtx(),e.processEvent,e,e),this._axis=e};e.Obj.createSubclass(p,e.EventManager),p.getUIParams=function(e,t,i,r){return{type:e,id:t,index:i,level:r}},p.prototype.OnClick=function(e){p.superclass.OnClick.call(this,e);var t=this.GetLogicalObject(e.target);t&&this.processDrillEvent(t)&&e.stopPropagation()},p.prototype.HandleTouchClickInternal=function(e){var t=this.GetLogicalObject(e.target);if(t){var i=e.touchEvent;this.processDrillEvent(t)&&i&&i.preventDefault()}},p.prototype.processDrillEvent=function(t){return!!(t instanceof y&&t.isDrillable())&&(this.FireEvent(e.EventFactory.newChartDrillEvent(t.getId(),null,t.getGroup()),this._axis),!0)},p.prototype.isDndSupported=function(){return!0},p.prototype.GetDragSourceType=function(e){var t=this.DragSource.getDragObject();return t instanceof y&&null!=t.getGroup()?"groups":null},p.prototype.GetDragDataContexts=function(t){var i=this.DragSource.getDragObject();if(i instanceof y){var r={id:i.getId(),group:i.getGroup(),label:i.getLabel().getTextString()};return t&&e.ToolkitUtils.cleanDragDataContext(r),[r]}return[]};var c=function(e,t){this.Init(e,t)};e.Obj.createSubclass(c,e.KeyboardHandler),c.prototype.Init=function(e,t){c.superclass.Init.call(this,e),this._axis=t},c.prototype.processKeyDown=function(t){var i=t.keyCode,r=this._eventManager.getFocus(),n=null;if(i==e.KeyboardEvent.TAB){r&&(e.EventManager.consumeEvent(t),n=r);var a=this._axis.__getKeyboardObjects();a.length>0&&(e.EventManager.consumeEvent(t),n=this.getDefaultNavigable(a))}else i==e.KeyboardEvent.ENTER?r&&(this._eventManager.processDrillEvent(r),e.EventManager.consumeEvent(t)):n=c.superclass.processKeyDown.call(this,t);return n};var _=new Object;e.Obj.createSubclass(_,e.Obj),_._MAX_TITLE_LINE_WRAP=3,_.getPreferredSize=function(t,i,r){var n=_._createAxisInfo(t,new e.Rectangle(0,0,i,r)),a=t.getCtx(),o=t.getOptions(),s="top"==o.position||"bottom"==o.position;if("off"==o.rendered||i<=0||r<=0)return s?new e.Dimension(i,0):new e.Dimension(0,r);var l=_.getTitleHeight(a,o,.8*(s?i:r),.8*(s?r:i)),h=0!=l?l+_._getTitleGap(t):0;if("on"==o.tickLabel.rendered&&"inside"!=o.tickLabel.position)if(s){var u=e.TextUtils.getTextStringHeight(a,o.tickLabel.style);n instanceof m?h+=u:n instanceof S?h+=null!=n.getLabels(a,1)?2*u:u:n instanceof v&&(h=_._getGroupAxisPreferredSize(t,n,h,r,s))}else if(n instanceof m)h+=e.TextUtils.getMaxTextStringWidth(a,n.getAllLabels(a,!0),n.Options.tickLabel.style);else if(n instanceof S){var g=n.getLabels(a),d=e.TextUtils.getMaxTextDimensions(g).w,p=n.getLabels(a,1),c=null!=p?e.TextUtils.getMaxTextDimensions(p).w:0;h+=Math.max(d,c)}else n instanceof v&&(h=_._getGroupAxisPreferredSize(t,n,h,i,s));return s?new e.Dimension(i,Math.min(h,r)):new e.Dimension(Math.min(h,i),r)},_.render=function(e,t){var i=_._createAxisInfo(e,t);"off"!=e.getOptions().rendered&&(e.__setBounds(t.clone()),_._renderBackground(e,t),_._renderTitle(e,i,t),_._renderLabels(e,i,t))},_._createAxisInfo=function(e,t){var i=f.newInstance(e.getCtx(),e.getOptions(),t);return e.__setInfo(i),i},_._getTitleGap=function(e){var t=e.getOptions();return d.getGapSize(e.getCtx(),t,t.layout.titleGap)},_._renderBackground=function(t,i){var r=t.getOptions();if(r.dnd){var n=r.dnd.drop,a=Object.keys(n.xAxis).length>0||Object.keys(n.yAxis).length>0||Object.keys(n.y2Axis).length>0,o=r.dnd.drag,s=Object.keys(o.groups).length>0&&t.getInfo()instanceof v;if(a||s){var l=r.position,h="top"==l||"bottom"==l,u=h?4:10,g=h?10:4,d=new e.Rect(t.getCtx(),i.x-g,i.y-u,i.w+2*g,i.h+2*u);s&&d.setClassName("oj-draggable"),d.setInvisibleFill(),t.getCache().putToCache("background",d),t.addChild(d)}}},_._renderTitle=function(t,i,r){var n=t.getOptions();if(n.title){var a=n.position;if("radial"!=a&&"tangential"!=a){var o="top"==n.position||"bottom"==n.position,s=o?r.w:r.h,l=o?r.h:r.w,h=n.titleStyle,g=_.isWrapEnabled(h),d=_._createText(t.getEventManager(),t,n.title,h,0,0,s,l,p.getUIParams(u.TITLE),g);if(d){var c=_._getTitleGap(t),f=(i.getStartOverflow()-i.getEndOverflow())/2,m=e.Agent.isRightToLeft(t.getCtx()),v=d.getDimensions().h;d.alignCenter(),"top"==a?(d.setX(r.x+f+r.w/2),d.setY(r.y),r.y+=v+c,r.h-=v+c):"bottom"==a?(d.setX(r.x+f+r.w/2),d.setY(r.y+r.h-v),r.h-=v+c):"left"==a?(d.alignMiddle(),d.setRotation(m?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+v/2,r.y+r.h/2),r.x+=v+c,r.w-=v+c):"right"==a&&(d.alignMiddle(),d.setRotation(m?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+r.w-v/2,r.y+r.h/2),r.w-=v+c),i.setTitle(d)}}}},_._renderLabels=function(e,t,i){var r=e.getOptions();if("on"==r.tickLabel.rendered){var n=r.position;"top"==n||"bottom"==n?_._renderLabelsHoriz(e,t,i):"tangential"==n?_._renderLabelsTangent(e,t,i):_._renderLabelsVert(e,t,i),_._renderGroupSeparators(e,t,i)}},_._renderLabelsHoriz=function(t,i,r){var n=t.getCtx(),a=t.getOptions(),o=a.position,s="inside"==a.tickLabel.position,l=e.Agent.isRightToLeft(n),h=i instanceof v,g=h&&i.getNumLevels()>1,c=g?0:null,_=i.getLabels(n,c);for(x=g?d.getGapSize(n,a,a.layout.hierarchicalLabelGapHeight):0;_;){for(var f=0,m=0,C=0;C<_.length;C++){var A=_[C];if(null!=A){var b=A instanceof e.MultilineText||A instanceof e.BackgroundMultilineText;if(i.isLabelRotated(c)){if((!b||b&&!A.isWrapEnabled())&&!e.TextUtils.fitText(A,r.h,r.w,t))continue;l?A.alignLeft():A.alignRight(),g?(f=A.getDimensions().w,A.setTranslateY(r.h-f),m=Math.max(m,f)):A.setTranslateY(r.y)}else{if(!s&&A.getDimensions().h-1>r.h)continue;if(g&&"bottom"==o?A.setY(r.h):"bottom"==o?A.setY(r.y):A.setY(r.y+r.h),!g&&("bottom"==o&&!s||"top"==o&&s)?A.alignTop():g&&"top"==o?A.alignTop():A.alignBottom(),g)m=Math.max(m,A.getDimensions().h);else if(s){var x=d.getGapSize(n,a,a.layout.insideLabelGapWidth);l?A.alignRight():A.alignLeft(),A.setX(A.getX()+x*(l?-1:1))}}var M=h?i.getLabelIndex(A):C,O=i.getDatatip(M,c),T=A.getUntruncatedTextString(),w=i.isDrillable(M,c),D=i.getGroup(M,c),E=p.getUIParams(u.TICK_LABEL,A.getTextString(),M,c);t.getEventManager().associate(A,new y(t,A,D,w,T,O,E)),g?i.setLastRenderedLevel(c):m=Math.max(m,A.getDimensions().h),t.addChild(A)}}if(g){for(C=0;C<_.length;C++)if(null!=(A=_[C])){var I=i.isLabelRotated(c),P=c<i.getNumLevels()-1;!I&&P?(A.setY(r.h-m/2),A.alignMiddle()):A.setTranslateY(r.h-m)}r.y+=m+x,r.h-=m+x,c++,_=i.getLabels(t.getCtx(),c)}else r.y+=m,r.h-=m,_=null}if(i instanceof S){_=i.getLabels(t.getCtx());var L=i.getLabels(t.getCtx(),1),R=0;if(null!=L)for(C=0;C<L.length;C++)if(null!=(A=L[C])&&!(A.getDimensions().h-1>r.h)){t.getEventManager().associate(A,new e.SimpleObjPeer(null,null,null,p.getUIParams(u.TICK_LABEL,A.getTextString())));var B=0,k=0,z=i.getOptions()._maxOverflowCoord,H=i.getOptions()._minOverflowCoord;if(null!=_[C]&&(R=_[C].getDimensions().w/2,B=i._level1Overflow[C],k=i._level2Overflow[C]),0==B&&0==k){var F,N=A.getX();l?(F=N+R<=z?N+R:z,A.setX(F)):(F=N-R>=H?N-R:H,A.setX(F))}else B<0?A.setX(H):B>0&&A.setX(z);A.alignTop(),A.setY(r.y),t.addChild(A)}}},_._renderLabelsVert=function(t,i,r){var n,a,o,s=t.getOptions(),l=s.position,h=t.getCtx(),g=e.Agent.isRightToLeft(h),c=i instanceof m,_="inside"==s.tickLabel.position,f=i instanceof v,C=f&&i.getNumLevels()>1,A=C?0:null;n=i.getLabels(t.getCtx(),A);var b=0;C?(a=d.getGapSize(h,s,s.layout.hierarchicalLabelGapWidth),o=e.TextUtils.getMaxTextDimensions(n).w):"radial"==l?(a=d.getGapSize(h,s,s.layout.radialLabelGap),b=r.x+r.w/2,g?b+=a+e.TextUtils.getMaxTextDimensions(n).w:b-=a):"left"==l?(b=r.x+r.w,c&&_&&(b+=e.TextUtils.getMaxTextDimensions(n).w)):(b=r.x,c&&!_&&(b+=e.TextUtils.getMaxTextDimensions(n).w));for(var x=function(a,m){var v=a instanceof e.MultilineText||a instanceof e.BackgroundMultilineText,S=!v||v&&!a.isWrapEnabled();if(!(C&&e.TextUtils.getMaxTextDimensions(n).w-1>r.w)&&(C||_||!S||e.TextUtils.fitText(a,r.w,r.h,t))){m=f?i.getLabelIndex(a):m;var x=i.getDatatip(m,A),M=a.getUntruncatedTextString(),O=i.isDrillable(m,A),T=i.getGroup(m,A),w=p.getUIParams(u.TICK_LABEL,a.getTextString(),m,A);if(t.getEventManager().associate(a,new y(t,a,T,O,M,x,w)),C)a.alignRight(),a.setX(g?r.w:r.x+o),i.setLastRenderedLevel(A);else if(a.setX(b),c||"right"!=l?a.alignRight():a.alignLeft(),_&&(a.alignBottom(),a.setY(a.getY()-d.getGapSize(h,s,s.layout.insideLabelGapHeight))),"radial"==l){var D=a.getY();a.setY(r.y+r.h/2-D);var E=a.getDimensions(),I=.15*E.h,P=e.PathUtils.roundedRectangle(E.x-I,E.y,E.w+2*I,E.h,2,2,2,2),L=new e.Path(t.getCtx(),P),R=a.getCSSStyle().getStyle(e.CSSStyle.BACKGROUND_COLOR),B=D+E.h/2>i.getEndCoord()&&"circle"==t.getOptions().polarGridShape?1:.3;R?L.setSolidFill(R):L.setSolidFill("#FFFFFF",B),t.addChild(L)}t.addChild(a)}};n;){for(var M=0;M<n.length;M++){var O=n[M];null!=O&&x(O,M)}if(!C)break;r.x+=o+a,r.w-=o+a,A++,n=i.getLabels(t.getCtx(),A),o=n?e.TextUtils.getMaxTextDimensions(n).w:null}if(i instanceof S){var T=i.getLabels(t.getCtx(),1);if(null!=T)for(M=0;M<T.length;M++)null!=(O=T[M])&&x(O,M)}},_._renderLabelsTangent=function(t,i,r){for(var n=i.getLabels(t.getCtx()),a=0;a<n.length;a++){var o=n[a];if(null!=o){var s=r.w/2-Math.abs(o.getX()),l=r.h/2-Math.abs(o.getY());if(e.TextUtils.fitText(o,s,l,t)){var h=i instanceof v?i.getLabelIndex(o):a,g=i.getDatatip(h),d=o.getUntruncatedTextString(),c=i.isDrillable(h),_=i.getGroup(h),f=p.getUIParams(u.TICK_LABEL,o.getTextString(),h);t.getEventManager().associate(o,new y(t,o,_,c,d,g,f)),o.setTranslateX(r.x+r.w/2),o.setTranslateY(r.y+r.h/2),t.addChild(o)}}}},_._createText=function(t,i,r,n,a,o,s,l,h,u){var g;return u?((g=new e.MultilineText(i.getCtx(),r,a,o)).setMaxLines(_._MAX_TITLE_LINE_WRAP),g.setCSSStyle(n),g.wrapText(s,l,1)):(g=new e.OutputText(i.getCtx(),r,a,o)).setCSSStyle(n),e.TextUtils.fitText(g,s,l,i)?(t.associate(g,new e.SimpleObjPeer(g.getUntruncatedTextString(),null,null,h)),g):null},_._renderGroupSeparators=function(t,i,r){if(i instanceof v&&i.areSeparatorsRendered()){var n=i.getNumLevels(),a=i.getSeparatorStartLevel();if(n<=1||a<=0)return;for(var o,s,l,h,u,g,p=t.getOptions(),c=p.position,f="top"==c||"bottom"==c,m=t.getCtx(),y=e.Agent.isRightToLeft(m),S=i.getSeparatorColor(),C=new e.Stroke(S,1,1),A=0,b=f?d.getGapSize(m,p,p.layout.hierarchicalLabelGapHeight):d.getGapSize(m,p,p.layout.hierarchicalLabelGapWidth),x=p.startGroupOffset,M=p.endGroupOffset,O=a;O>=0;O--){var T=i.getLabels(t.getCtx(),O),w=e.TextUtils.getMaxTextDimensions(T),D=i.isLabelRotated(O),E=D||!f?w.w:w.h;if(0!=E){var I=!1,P=null;if(O<a)for(var L=0;L<T.length;L++){var R=T[L];if(null!=R){var B=i.getLabelIndex(R),k=0==i.getLabelAt(B,O).length;if(!k){var z=k&&0==O&&(0==B||B==T.length-1),H=R&&null==T[B-1],F=R&&null==T[B+1],N=i.getStartIndex(B,O),W=i.getEndIndex(B,O);if(f){var G;if(R&&(G=R instanceof e.MultilineText||R instanceof e.BackgroundMultilineText?R.getYAlignCoord():R.getY(),o=i.getCoordAt(N-x),s=D?G+.5*A:G-E/2-.5*A-b,l=i.getCoordAt(W+M),h=D?G+E+A+2*b:G,k&&z||0!=I||null==o||_._addSeparatorLine(t,C,o,h,o,s),null==l||z||_._addSeparatorLine(t,C,l,h,l,s)),!k){if(R)var j=D?R.getDimensions().h:R.getDimensions().w;o=H&&0==P?i.getStartCoord():i.getBoundedCoordAt(N-x),H&&(H=!1);var U=i.getLabelAt(B+1,O);if(l=F&&U&&U.length>0?i.getEndCoord():i.getBoundedCoordAt(W+M),u=R?y?R.getX()+.5*j:R.getX()-.5*j:i.getBoundedCoordAt(W+M),g=R?y?R.getX()-.5*j:R.getX()+.5*j:i.getBoundedCoordAt(N-x),R)if(D)_._addSeparatorLine(t,C,o,h,l,h);else{var V=y?.5*-R.getDimensions().h:.5*R.getDimensions().h,X=y?g+V>l:g+V<l;(y?o>u-V:o<u-V)&&_._addSeparatorLine(t,C,o,h,u-V,h),X&&_._addSeparatorLine(t,C,g+V,h,l,h)}}}else R&&(o=y?R.getX()-E-.5*b:R.getX()+.5*b,s=i.getCoordAt(N-x),l=y?R.getX()+.5*b:R.getX()-E-.5*b,h=i.getCoordAt(W+M),(!k&&0==I||0==B&&k&&0!=O)&&null!=s&&_._addSeparatorLine(t,C,o,s,l,s),null==h||z||_._addSeparatorLine(t,C,l,h,o,h)),k||(s=H&&0==P?0:i.getBoundedCoordAt(N-x),H&&(H=!1),U=i.getLabelAt(B+1,O),h=F&&U&&U.length>0?i.getEndCoord():i.getBoundedCoordAt(W+M),R&&_._addSeparatorLine(t,C,l,s,l,h));I=!k&&null!=R,P=null!=R||null==R&&k}}}A=E}else A=E}}},_._addSeparatorLine=function(t,i,r,n,a,o){var s=new e.Line(t.getCtx(),r,n,a,o);s.setStroke(i),s.setPixelHinting(!0),t.addChild(s)},_._getGroupAxisPreferredSize=function(t,i,r,n,a){for(var o=t.getCtx(),s=t.getOptions(),l=i.getNumLevels(),h=a?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",u=l>1?d.getGapSize(o,s,s.layout[h]):0,g=0;g<l;g++){var p;if(i.isAutoRotate()){for(var c=[],_=[],f=i.getSkipIncrement(),m=0;m<i.getGroupCount();m+=f){c.push(i.getLabelAt(m,0));var v=i.getLabelStyleAt(m,0);v||(v=i.Options.tickLabel.style),_.push(v)}p=e.TextUtils.getMaxTextStringWidth(o,c,_)}else{var y=i.getLabels(o,g);if(a){var S=e.TextUtils.getMaxTextDimensions(y);p=i.isLabelRotated(g)?S.w:S.h}else p=e.TextUtils.getMaxTextDimensions(y).w}if(!(r+p<=n)){0==g&&(r=n);break}r+=p+u}return 0!=g&&(r-=u),r},_.getTitleHeight=function(t,i,r,n){var a=0;if(i.title)if(_.isWrapEnabled(i.titleStyle)){var o=new e.MultilineText(t,i.title,0,0);o.setMaxLines(_._MAX_TITLE_LINE_WRAP),o.setCSSStyle(i.titleStyle),o.wrapText(r,n,1),a=e.TextUtils.getTextStringHeight(t,i.titleStyle)*o.getLineCount()}else a=e.TextUtils.getTextStringHeight(t,i.titleStyle);return a},_.isWrapEnabled=function(t){var i=t.getStyle(e.CSSStyle.WHITE_SPACE);return"nowrap"!=i&&"noWrap"!=i};var f=function(){};e.Obj.createSubclass(f,e.BaseAxisInfo),f.newInstance=function(e,t,i){return t.timeAxisType&&"disabled"!=t.timeAxisType?new S(e,t,i):t._isGroupAxis?new v(e,t,i):new m(e,t,i)},f.prototype.Init=function(e,t,i){f.superclass.Init.call(this,e,t,i),this._title=null},f.prototype.getLabels=function(e,t){return null},f.prototype.getTitle=function(){return this._title},f.prototype.setTitle=function(e){this._title=e},f.prototype.getMajorTickCoords=function(){return[]},f.prototype.getMinorTickCoords=function(){return[]},f.prototype.getBaselineCoord=function(){return null},f.prototype.getDatatip=function(e,t){return null},f.prototype.getLabelBackground=function(e,t){return null},f.prototype.isDrillable=function(e){return null},f.prototype.isLabelRotated=function(){return!1},f.prototype.CreateLabel=function(t,i,r,n,a){var o;if("tangential"==this.Position){var s=16/180*Math.PI,l=1/180*Math.PI,h=.5*this.getTickLabelHeight(),u=this._radius+h;(r<l||r>2*Math.PI-l)&&(u+=h);var g=Math.round(u*Math.sin(r)),d=Math.round(-u*Math.cos(r));o=n?new e.BackgroundOutputText(t,i,g,d,n):new e.OutputText(t,i,g,d),r<l||Math.abs(r-Math.PI)<l||r>2*Math.PI-l?o.alignCenter():r<Math.PI?o.alignLeft():o.alignRight(),Math.abs(r-Math.PI/2)<s||Math.abs(r-3*Math.PI/2)<s?o.alignMiddle():r<Math.PI/2||r>3*Math.PI/2?o.alignBottom():o.alignTop()}else a?o=n?new e.BackgroundMultilineText(t,i,r,r,n):new e.MultilineText(t,i,r,r):(o=n?new e.BackgroundOutputText(t,i,r,r,n):new e.OutputText(t,i,r,r)).alignMiddle(),o.alignCenter();return(o instanceof e.OutputText||o instanceof e.MultilineText)&&o.setCSSStyle(this.Options.tickLabel.style),o},f.prototype.IsOverlapping=function(t,i,r){if(!t||t.length<=0)return!1;for(var n,a,o,s,l="left"==this.Position||"right"==this.Position||"radial"==this.Position,h=e.Agent.isRightToLeft(this.getCtx()),u=this.GetTickLabelGapSize(),g=0;g<t.length;g+=i+1)if(null!=t[g]){if(null!=r&&t[g].w>r[g])return!0;if(null!=n&&null!=a){if(l){if(o=t[g].y,s=t[g].y+t[g].h,o>=n&&o-u<a)return!0;if(o<n&&s+u>n)return!0}else{if(o=t[g].x,s=t[g].x+t[g].w,!h&&o-u<a)return!0;if(h&&s+u>n)return!0}n=o,a=s}else l?(n=t[g].y,a=t[g].y+t[g].h):(n=t[g].x,a=t[g].x+t[g].w)}return!1},f.prototype.IsOverlappingDims=function(e,t){if(!e||!t)return!1;var i=e.y,r=e.y+e.h,n=e.x,a=e.x+e.w,o=t.y,s=t.y+t.h,l=t.x,h=t.x+t.w;return(n<=l&&l<=a||n<=h&&h<=a||l<=n&&n<=h||l<=a&&a<=h)&&(o>=i&&o<r||o<=i&&s>=i)},f.prototype.GetTickLabelGapSize=function(){var e=this.getTickLabelHeight(),t=this instanceof v?.24*e:.79*e,i=this instanceof v?.08*e:.28*e;return"left"==this.Position||"right"==this.Position||"radial"==this.Position||this.isLabelRotated()?i:t},f.prototype.getTickLabelHeight=function(){return e.TextUtils.getTextStringHeight(this.getCtx(),this.Options.tickLabel.style)},f.prototype.SkipLabels=function(e,t){
for(var i=0,r=this.IsOverlapping(t,i);r;)i++,r=this.IsOverlapping(t,i);if(i>0){for(var n=[],a=0;a<e.length;a+=i+1)n.push(e[a]);return n}return e},f.prototype.SkipTangentialLabels=function(e,t){var i=[],r=e.length,n=null;if(r>1){for(var a,o=0;o<r;o++)t[o]&&(!a||a&&!this.IsOverlappingDims(a,t[o]))&&(n||(n=t[o]),i.push(e[o]),a=t[o]);return this.IsOverlappingDims(a,n)&&i.pop(),i}return e},f.prototype.GetLabelDims=function(e,t,i){for(var r=[],n=this.isLabelRotated(i),a=0;a<e.length;a++){var o=e[a];if(null!=o){var s=o.getDimensions(t);null!=i&&(s.x=(n?o.getTranslateX():o.getX())-s.w/2,s.y=(n?o.getTranslateY():o.getY())-s.h/2),s.w&&s.h?r.push(s):r.push(null)}else r.push(null)}return r},f.prototype.getMajorTickCount=function(){return null},f.prototype.getMinorTickCount=function(){return null},f.prototype.getMajorIncrement=function(){return null},f.prototype.getMinorIncrement=function(){return null},f.prototype.getGlobalMin=function(){return this.GlobalMin},f.prototype.getGlobalMax=function(){return this.GlobalMax},f.prototype.getViewportMin=function(){return this.MinValue},f.prototype.getViewportMax=function(){return this.MaxValue},f.prototype.getDataMin=function(){return this.DataMin},f.prototype.getDataMax=function(){return this.DataMax},f.prototype.getMinimumExtent=function(){return 0},f.prototype.getStartCoord=function(){return this.StartCoord},f.prototype.getEndCoord=function(){return this.EndCoord},f.prototype.getStartOverflow=function(){return this.StartOverflow},f.prototype.getEndOverflow=function(){return this.EndOverflow},f.prototype.getGroupWidth=function(){return 0},f.prototype.getGroup=function(e,t){return null},f.prototype.linearToActual=function(e){return e},f.prototype.actualToLinear=function(e){return e},f.prototype.alignLogScaleToTickCount=function(e,t){return e},f.prototype.getLogScaleUnit=function(){return null};var m=function(e,t,i){this.Init(e,t,i)};e.Obj.createSubclass(m,f),m.prototype.Init=function(e,t,i){m.superclass.Init.call(this,e,t,i),this.MixinInit.call(this,e,t,i)},m.MAX_ZOOM_FACTOR=64,m.prototype.getMinLabel=function(){return this.ZeroBaseline||"on"==this.Options._continuousExtent&&null==this.Options.min?Math.ceil(this.LinearMinValue/this.MajorIncrement)*this.MajorIncrement:Math.ceil((this.LinearMinValue-this.LinearGlobalMin)/this.MajorIncrement)*this.MajorIncrement+this.LinearGlobalMin},m.prototype.getLabels=function(e,t){if(t&&t>0)return null;var i=this.getAllLabels(e),r=[],n=e.getStage();return"tangential"!=this.Position&&(r=this.GetLabelDims(i,n),i=this.SkipLabels(i,r)),i},m.prototype.getAllLabels=function(t,i){var r=[];if(this.Options.tickLabel&&this.Options.tickLabel.scaling){var n=this.Options.tickLabel.autoPrecision?this.Options.tickLabel.autoPrecision:"on";this._axisValueFormatter=new e.LinearScaleAxisValueFormatter(t,this.LinearMinValue,this.LinearMaxValue,this.MajorIncrement,this.Options.tickLabel.scaling,n,this.Options.translations)}for(var a=0;a<=this.MajorTickCount;a++){var o=a*this.MajorIncrement+this.getMinLabel();if(o-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;var s,l=this.GetUnboundedCoordAt(o);if(this.Options._skipHighestTick){if(o==this.LinearMaxValue)continue;if("tangential"!=this.Position&&Math.abs(l-this.MaxCoord)<this.getTickLabelHeight())continue}this.IsLog?(o=this.linearToActual(o),this._axisValueFormatter=new e.LinearScaleAxisValueFormatter(t,o,o,o,this.Options.tickLabel.scaling,n,this.Options.translations),s=this._formatValue(o)):s=this._formatValue(o),i?r.push(s):r.push(this.CreateLabel(t,s,l))}return r},m.prototype.getMajorTickCoords=function(){for(var e=[],t=0;t<=this.MajorTickCount;t++){var i=t*this.MajorIncrement+this.getMinLabel();if(i-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;if(!this.Options._skipHighestTick||i!=this.LinearMaxValue){var r=this.GetUnboundedCoordAt(i);e.push(r)}}return e},m.prototype.getMinorTickCoords=function(){for(var t=[],i=-1;i<=this.MajorTickCount;i++){var r=i*this.MajorIncrement+this.getMinLabel();if(this.IsLog&&1==this.MajorIncrement&&1==this.MinorIncrement)for(var n=2;n<=9;n++){var a=r+e.Math.log10(n);if(a>this.LinearMaxValue)break;a<this.LinearMinValue||(s=this.GetUnboundedCoordAt(a),t.push(s))}else for(n=1;n<this.MinorTickCount;n++){var o=r+n*this.MinorIncrement;if(o>this.LinearMaxValue)break;if(!(o<this.LinearMinValue)){var s=this.GetUnboundedCoordAt(o);t.push(s)}}}return t},m.prototype._formatValue=function(t){if(!this.Converter||!this.Converter.getAsString&&!this.Converter.format){if(this._axisValueFormatter)return this._axisValueFormatter.format(t);var i=e.Math.log10(this.MajorIncrement),r=Math.max(Math.ceil(-i),0);return t.toFixed(r)}return this._axisValueFormatter?this._axisValueFormatter.format(t,this.Converter):this.Converter.getAsString?this.Converter.getAsString(t):this.Converter.format?this.Converter.format(t):void 0},m.prototype.getMajorTickCount=function(){return this.MajorTickCount},m.prototype.getMinorTickCount=function(){return this.MinorTickCount},m.prototype.getMajorIncrement=function(){return this.linearToActual(this.MajorIncrement)},m.prototype.getMinorIncrement=function(){return this.linearToActual(this.MinorIncrement)},m.prototype.getMinimumExtent=function(){return(this.LinearGlobalMax-this.LinearGlobalMin)/this.MAX_ZOOM_FACTOR},m.prototype.getStartOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!e.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow},m.prototype.getEndOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!e.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow},m.prototype.alignLogScaleToTickCount=function(e,t){if(this.IsLog)for(var i=this.getMajorTickCount();t<i;)this.MajorIncrement=null,this.MajorTickCount=null,this.MinorIncrement=null,this.MinorTickCount=null,e++,this.CalcMajorMinorIncr(e),i=this.getMajorTickCount();return e},m.prototype.getLogScaleUnit=function(){return this.LogScaleUnit},e.DataAxisInfoMixin.call(m.prototype);var v=function(e,t,i){this.Init(e,t,i)};e.Obj.createSubclass(v,f),v._MAX_LINE_WRAP=3,v._ROTATE_THRESHOLD=12,v.prototype.Init=function(t,i,r){v.superclass.Init.call(this,t,i,r);var n=e.Agent.isRightToLeft(t),a="top"==this.Position||"bottom"==this.Position;if(a&&n){var o=this.StartCoord;this.StartCoord=this.EndCoord,this.EndCoord=o}this._levelsArray=[],this._groupCount=this._generateLevelsArray(i.groups,0,this._levelsArray,0),this._numLevels=this._levelsArray.length,this._areSeparatorsRendered="off"!=i.groupSeparators.rendered,this._separatorColor=i.groupSeparators.color,this._lastRenderedLevel=null,this._drilling=i.drilling;var s=i.endGroupOffset>0?Number(i.endGroupOffset):0,l=i.startGroupOffset>0?Number(i.startGroupOffset):0;this.DataMin=0,this.DataMax=this._groupCount-1,this.GlobalMin=null==i.min?this.DataMin-l:i.min,this.GlobalMax=null==i.max?this.DataMax+s:i.max;var h=this.getGroupIndex(i.viewportStartGroup),u=this.getGroupIndex(i.viewportEndGroup);-1!=h&&(this.MinValue=h-l),-1!=u&&(this.MaxValue=u+s),null!=i.viewportMin&&(this.MinValue=i.viewportMin),null!=i.viewportMax&&(this.MaxValue=i.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._groupWidthRatios=i._groupWidthRatios,this._processGroupWidthRatios(),this._startBuffer=n?i.rightBuffer:i.leftBuffer,this._endBuffer=n?i.leftBuffer:i.rightBuffer,this._isLabelRotated=[];for(var g=0;g<this._numLevels;g++)this._isLabelRotated.push(!1);if(this._renderGridAtLabels=i._renderGridAtLabels,this._labels=null,this._maxSpace=a?r.h:r.w,"off"!=i.rendered){var p=_.getTitleHeight(t,i,a?r.w:r.h,a?r.h:r.w);this._maxSpace-=0!=p?p+d.getGapSize(t,i,i.layout.titleGap):0}this._maxLineWrap=v._MAX_LINE_WRAP},v.prototype._processGroupWidthRatios=function(){if(!this._groupWidthRatios||this._groupWidthRatios.length<2)this._groupWidthRatios=null;else{for(var e,t,i=0,r=0;r<this._groupCount;r++)e=0==r?this.MinValue:Math.max(r-.5,this.MinValue),(t=r==this._groupCount-1?this.MaxValue:Math.min(r+.5,this.MaxValue))>e&&(i+=(t-e)*this._groupWidthRatios[r]);var n=this.EndCoord-this.StartCoord;for(this._groupWidths=this._groupWidthRatios.map(function(e){return e*n/i}),this._borderValues=[],r=0;r<this._groupWidthRatios.length-1;r++)this._borderValues.push(r+.5);this._borderCoords=[];var a=Math.min(Math.max(Math.round(this.MinValue),0),this._borderValues.length-1);for(this._borderCoords[a]=this.StartCoord+(this._borderValues[a]-this.MinValue)*this._groupWidths[a],r=a+1;r<this._borderValues.length;r++)this._borderCoords[r]=this._borderCoords[r-1]+this._groupWidths[r];for(r=a-1;r>=0;r--)this._borderCoords[r]=this._borderCoords[r+1]-this._groupWidths[r+1]}},v.prototype._rotateLabels=function(t,i,r,n){var a,o,s=this.getCtx(),l=e.Agent.isRightToLeft(s),h=this._numLevels>1;null==n&&(n=this._numLevels-1),this._isLabelRotated[n]=!0,h||this._setOverflow(r,r,t);for(var u=0;u<t.length;u++)if(null!=(a=t[u])){if(o=a.getX(),a instanceof e.MultilineText||a instanceof e.BackgroundMultilineText){var g=this.getGroupWidth()*(this.getEndIndex(u,n)-this.getStartIndex(u,n)+1);2*a.getLineHeight()<g&&this._maxSpace>0?a.wrapText(this._maxSpace,a.getLineHeight()*v._MAX_LINE_WRAP,1):a.setWrapEnabled(!1)}a.setX(0),a.setY(0),l?a.setRotation(Math.PI/2):a.setRotation(3*Math.PI/2),a.setTranslateX(o)}var d=this.GetLabelDims(t,i,n);return _.isWrapEnabled(this.Options.tickLabel.style)&&this._maxSpace>0&&this._sanitizeWrappedText(s,d,t,!0,h)&&(d=this.GetLabelDims(t,i,n)),this.SkipLabels(t,d)},v.prototype._sanitizeWrappedText=function(t,i,r,n,a){for(var o=this._calculateMaxWrap(i,r,n),s=0,l=0;l<r.length;l++){var h=r[l];if(h){var u=h instanceof e.MultilineText||h instanceof e.BackgroundMultilineText;o&&u&&h.isWrapEnabled()&&h.wrapText(this._maxSpace,h.getLineHeight()*this._maxLineWrap,1),a&&(s=Math.max(s,h.getDimensions().w)),h.alignMiddle()}}if(a){var g=n?this.Options.layout.hierarchicalLabelGapHeight:this.Options.layout.hierarchicalLabelGapWidth;this._maxSpace-=s+d.getGapSize(t,this.Options,g)}return o},v.prototype._calculateMaxWrap=function(t,i,r){for(var n=!1;this.IsOverlapping(t,0)&&this._maxLineWrap>1;){n=!0;for(var a=0;a<i.length;a++){var o=i[a];if((o instanceof e.MultilineText||o instanceof e.BackgroundMultilineText)&&o.getLineCount()==this._maxLineWrap){var s=o.getLineHeight();r?t[a].w-=s:(t[a].y+=.5*s,t[a].h-=s)}}this._maxLineWrap--}return n},v.prototype.isLabelRotated=function(e){return null==e&&(e=this._numLevels-1),this._isLabelRotated[e]},v.prototype._setOverflow=function(t,i,r){t=Math.max(t-this._startBuffer,0),i=Math.max(i-this._endBuffer,0);var n=e.Agent.isRightToLeft(this.getCtx());this.StartCoord+=(t-this.StartOverflow)*(n?-1:1),this.EndCoord-=(i-this.EndOverflow)*(n?-1:1),this._processGroupWidthRatios();for(var a=0;a<this._numLevels;a++){r=this._labels[a];for(var o=0;o<r.length;o++){var s=r[o];if(s){var l=this._getLabelCoord(a,this.getLabelIndex(s));s.setX(l)}}}this.StartOverflow=t,this.EndOverflow=i},v.prototype.getLabels=function(e,t){return null==t&&(t=this._numLevels-1),this._labels||this._generateLabels(e),this._labels[t]},v.prototype._getLabelCoord=function(e,t){var i=this.getStartIndex(t,e),r=this.getEndIndex(t,e);if(null==i||null==r)return null;i<this.MinValue&&r>this.MinValue&&(i=this.MinValue),r>this.MaxValue&&i<this.MaxValue&&(r=this.MaxValue);var n=r?i+(r-i)/2:i;return this.getCoordAt(n)},v.prototype._generateLabels=function(t){var i=[];this._labels=[];for(var r,n,a,o,s,l=t.getStage(),h="top"==this.Position||"bottom"==this.Position,u=e.Agent.isRightToLeft(t),g=this._numLevels>1,p=this.getGroupWidth(),c=this._maxSpace,f=h?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",m=g?d.getGapSize(t,this.Options,this.Options.layout[f]):0,v="auto"==this.Options.tickLabel.rotation&&h,y={},S=this.isAutoRotate(),C=this.Options.tickLabel.style,A=_.isWrapEnabled(this.Options.tickLabel.style)&&"tangential"!=this.Position&&p>e.TextUtils.getTextStringHeight(t,C),b=0;b<this._numLevels;b++){var x=this._levelsArray[b],M=S?this.getSkipIncrement():1;y[b]=[];for(var O=0;O<x.length;O+=M)if(x[O]){if(""===(r=this.getLabelAt(O,b))||!r&&0!=r){i.push(null);continue}var T=this._getLabelCoord(b,O);if(null!=T){o=this.getLabelStyleAt(O,b);var w=!S&&A&&"number"!=typeof r&&r.indexOf(" ")>=0;s=this.CreateLabel(t,r,T,o,w);var D=p*(this.getEndIndex(O,b)-this.getStartIndex(O,b)+1);y[b].push(D),w&&this._isTextWrapNeeded(t,r,o,v,h?D:c)&&c>0?h?s.wrapText(D,c,1,!0):s.wrapText(c,s.getLineHeight()*this._maxLineWrap,1,!1):w&&(!h||c<0)&&s.setWrapEnabled(!1),s._index=O,i.push(s),n||0!=b||(n=s),0==b&&(a=s)}else i.push(null)}else i.push(null);if(A&&g){for(var E=0,I=0;I<i.length;I++)if(i[I]){var P=i[I].getDimensions();E=Math.max(E,h?P.h:P.w)}c-=E+m}this._labels.push(i),i=[]}i=this._labels[this._numLevels-1];var L=[];if(n){if("tangential"==this.Position)return L=this.GetLabelDims(i,l),void(this._labels[0]=this.SkipTangentialLabels(i,L));var R=n.getDimensions();if(h){var B,k;if(null!=this.Options._startOverflow&&null!=this.Options._endOverflow)B=this.Options._startOverflow,k=this.Options._endOverflow;else{var z=a.getDimensions();B=u?R.w+R.x-this.StartCoord:this.StartCoord-R.x,k=u?this.EndCoord-z.x:z.w+z.x-this.EndCoord}!S&&(B>this._startBuffer||k>this._endBuffer)&&this._setOverflow(B,k,i)}for(b=0;b<this._numLevels;b++)if(i=this._labels[b],S)this._labels[b]=this._rotateLabels(i,l,R.h/2,b);else{L=this.GetLabelDims(i,l,b);var H=this.IsOverlapping(L,0,y[b]);if(H||(this._labels[b]=i),h)if(v){if(H)this._labels[b]=this._rotateLabels(i,l,R.h/2,b);else if(this._labels[b]=i,g){var F=0;for(I=0;I<L.length;I++)L[I]&&(F=Math.max(F,L[I].h));this._maxSpace-=F+m}}else L=this.GetLabelDims(i,l),this._labels[b]=this.SkipLabels(i,L);else A&&this._sanitizeWrappedText(t,L,i,!1,g)&&(L=this.GetLabelDims(i,l,b)),this._labels[b]=this.SkipLabels(i,L)}}},v.prototype.getMajorTickCoords=function(){for(var e,t=[],i="tangential"==this.Position?this.getGroupCount():this.getGroupCount()-1,r=0;r<this._levelsArray[0].length;r++)if(this._levelsArray[0][r]){var n=this.getStartIndex(r,0),a=this.getEndIndex(r,0);null!=(e=this._renderGridAtLabels?this.getCoordAt(n+.5*(a-n)):a+.5<i?this.getCoordAt(a+.5):null)&&t.push(e)}return t},v.prototype.getMinorTickCoords=function(){var e,t=[];if(!this._levelsArray[1])return t;for(var i=0;i<this._levelsArray[1].length;i++)if(this._levelsArray[1][i]){var r=this.getStartIndex(i,1),n=this.getEndIndex(i,1);null!=(e=this._renderGridAtLabels?this.getCoordAt(r+.5*(n-r)):n+.5<this.getGroupCount()-1?this.getCoordAt(n+.5):null)&&t.push(e)}return t},v.prototype.getUnboundedValueAt=function(e){if(null==e)return null;if(this._groupWidthRatios){for(var t=this._borderCoords.length,i=0;i<this._borderCoords.length;i++)if(e<=this._borderCoords[i]){t=i;break}return 0==t?this._borderValues[0]-(this._borderCoords[0]-e)/this._groupWidths[0]:this._borderValues[t-1]+(e-this._borderCoords[t-1])/this._groupWidths[t]}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.MinValue+(e-this.StartCoord)/r},v.prototype.getUnboundedCoordAt=function(e){if(null==e)return null;if(this._groupWidthRatios){for(var t=this._borderValues.length,i=0;i<this._borderValues.length;i++)if(e<=this._borderValues[i]){t=i;break}return 0==t?this._borderCoords[0]-this._groupWidths[0]*(this._borderValues[0]-e):this._borderCoords[t-1]+this._groupWidths[t]*(e-this._borderValues[t-1])}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.StartCoord+(e-this.MinValue)*r},v.prototype.getLabelAt=function(e,t){if(null==t&&(t=this._numLevels-1),(e=Math.round(e))<0)return null;var i=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;return i&&(i.name?i=i.name:null!=i.id&&(i="")),i},v.prototype.getGroupAt=function(e,t){if(null==t&&(t=this._numLevels-1),(e=Math.round(e))<0)return null;var i=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;if(i){if(i.id)return i.id;if(i.name||""===i.name)return i.name}return i},v.prototype.getLabelStyleAt=function(t,i){var r=this._getGroupAttribute(t,i,"labelStyle");if(r){var n=new e.CSSStyle(r);return n.getStyle("font-size")||n.setStyle("font-size",this.Options.tickLabel.style.getStyle("font-size")),n}return null},v.prototype.getDatatip=function(e,t){return this._getGroupAttribute(e,t,"shortDesc")},v.prototype.isDrillable=function(e,t){var i=this._getGroupAttribute(e,t,"drilling");return"on"==i||"off"!=i&&("on"==this._drilling||"groupsOnly"==this._drilling)},v.prototype.getGroup=function(e,t){if(e<0||e>this.getGroupCount()-1)return null;if(1==this._numLevels)return this.getGroupAt(e);var i=[];null==t&&(t=this._numLevels-1);for(var r=this.getStartIndex(e,t),n=0;n<=t;n++)for(var a=this._levelsArray[n],o=0;o<a.length;o++)this.getStartIndex(o,n)<=r&&this.getEndIndex(o,n)>=r&&i.push(this.getGroupAt(o,n));return i.length>0?1==i.length?i[0]:i:null},v.prototype.getLabelBackground=function(t,i,r){null==r&&(r=this._numLevels-1);var n=t.getCSSStyle();if(n){var a=n.getStyle(e.CSSStyle.BACKGROUND_COLOR),o=n.getStyle(e.CSSStyle.BORDER_COLOR),s=n.getStyle(e.CSSStyle.BORDER_WIDTH),l=n.getStyle(e.CSSStyle.BORDER_RADIUS);if(null!=a||null!=o||null!=s||null!=l){var h=t.getDimensions(),u=.15*h.h;"chrome"!==e.Agent.browser&&"ie"!==e.Agent.browser&&"edge"!==e.Agent.browser||t.getVertAlignment()!==e.OutputText.V_ALIGN_BOTTOM||(h.y+=h.h/2);var g=new e.Rect(i,h.x-u,h.y,h.w+2*u,h.h),d=new e.CSSStyle;return null!=a?d.setStyle(e.CSSStyle.BACKGROUND_COLOR,a):g.setInvisibleFill(),d.setStyle(e.CSSStyle.BORDER_COLOR,o),d.setStyle(e.CSSStyle.BORDER_WIDTH,s),d.setStyle(e.CSSStyle.BORDER_RADIUS,l),g.setCSSStyle(d),this._isLabelRotated[r]&&g.setMatrix(t.getMatrix()),g.setMouseEnabled(!1),g}return null}return null},v.prototype.getGroupIndex=function(t){if(null==t)return-1;for(var i=-1,r=0;r<this._groupCount;r++){var n=this.getGroup(r);if(t instanceof Array&&n instanceof Array?e.ArrayUtils.equals(t,n):t==n){i=r;break}}return i},v.prototype.getMinimumExtent=function(){return 1},v.prototype.getGroupWidth=function(){return Math.abs(this.EndCoord-this.StartCoord)/Math.abs(this.MaxValue-this.MinValue)},v.prototype.getGroupCount=function(){return this._groupCount},v.prototype.getNumLevels=function(){return this._numLevels},v.prototype._generateLevelsArray=function(e,t,i,r){for(var n=0;n<e.length;n++)if(i[t]||(i[t]=[]),i[t].push({item:e[n],start:r,end:r,position:n}),e[n]&&e[n].groups){var a=i[t].length-1,o=this._generateLevelsArray(e[n].groups,t+1,i,i[t][a].start);r!=o?(i[t][a].end=o-1,r=o):r++}else r++;return r},v.prototype._getGroupAttribute=function(e,t,i){null==t&&(t=this._numLevels-1);var r=this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].item:null;return r?r[i]:null},v.prototype.areSeparatorsRendered=function(){return this._areSeparatorsRendered},v.prototype.getSeparatorColor=function(){return this._separatorColor},v.prototype.getStartIndex=function(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].start:null},v.prototype.getEndIndex=function(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].end:null},v.prototype.getPosition=function(e,t){return null==t&&(t=this._numLevels-1),this._levelsArray[t]&&this._levelsArray[t][e]?this._levelsArray[t][e].position:null},v.prototype.isRenderGridAtLabels=function(){return this._renderGridAtLabels},v.prototype.setLastRenderedLevel=function(e){this._lastRenderedLevel=e},v.prototype.getLastRenderedLevel=function(){return this._lastRenderedLevel},v.prototype.getSeparatorStartLevel=function(){for(var e=this._lastRenderedLevel,t=this._lastRenderedLevel-1;t>=0;t--)this._labels[t].length!=this._levelsArray[t].length&&(e=t);return e},v.prototype.getLabelIndex=function(e){return e._index>=0?e._index:null},v.prototype.getMaxLineWrap=function(){return this._maxLineWrap},v.prototype._isTextWrapNeeded=function(t,i,r,n,a){var o=e.TextUtils.getTextStringWidth(t,i,r);return o>=a&&(o/this._maxLineWrap<a||!n)},v.prototype.isAutoRotate=function(){var e="top"==this.Position||"bottom"==this.Position,t=this._numLevels>1,i=this.getGroupWidth(),r="auto"==this.Options.tickLabel.rotation&&e;return!t&&r&&i<v._ROTATE_THRESHOLD},v.prototype.getSkipIncrement=function(){var e=1;return e=v._ROTATE_THRESHOLD/(2*this.getGroupWidth()),this.Options._duringZoomAndScroll&&(e*=4),Math.max(1,Math.floor(e))};var y=function(e,t,i,r,n,a,o){this.Init(e,t,i,r,n,a,o)};e.Obj.createSubclass(y,e.SimpleObjPeer),y.prototype.Init=function(t,i,r,n,a,o,s){y.superclass.Init.call(this,a,o,null,s),this._axis=t,this._label=i,this._group=r,this._drillable=n,this._drillable&&i.setCursor(e.SelectionEffectUtils.getSelectingCursor()),t.__registerObject(this)},y.prototype.getLabel=function(){return this._label},y.prototype.getId=function(){return this._group},y.prototype.isDrillable=function(){return this._drillable},y.prototype.getGroup=function(){return this._group},y.prototype.getNextNavigable=function(t){if(t.type==e.MouseEvent.CLICK)return this;var i=this._axis.__getKeyboardObjects();return e.KeyboardHandler.getNextNavigable(this,t,i,!1,this._axis.getCtx().getStage())},y.prototype.getKeyboardBoundingBox=function(t){return this._label?this._label.getDimensions(t):new e.Rectangle(0,0,0,0)},y.prototype.getDisplayable=function(){return this._label},y.prototype.getTargetElem=function(){return this._label?this._label.getElem():null},y.prototype.showKeyboardFocusEffect=function(){if(this._isShowingKeyboardFocusEffect=!0,this._label){var t=this.getKeyboardBoundingBox();this._overlayRect=new e.Rect(this._axis.getCtx(),t.x,t.y,t.w,t.h),this._overlayRect.setSolidStroke(e.Agent.getFocusColor()),this._overlayRect.setInvisibleFill(),this._overlayRect.setMatrix(this._label.getMatrix()),this._axis.addChild(this._overlayRect)}},y.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this._label&&(this._axis.removeChild(this._overlayRect),this._overlayRect=null)},y.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},y.prototype.getAriaLabel=function(){var t;return this.isDrillable()&&(t=[this._axis.getOptions().translations.stateDrillable]),null!=this.getDatatip()?e.Displayable.generateAriaLabel(this.getDatatip(),t):null!=t?e.Displayable.generateAriaLabel(this.getLabel().getTextString(),t):void 0},y.prototype.isDragAvailable=function(e){return!0},y.prototype.getDragTransferable=function(e,t){return[this.getId()]},y.prototype.getDragFeedback=function(e,t){return[this.getDisplayable()]};var S=function(e,t,i){this.Init(e,t,i)};e.Obj.createSubclass(S,f),S.TIME_SECOND=1e3,S.TIME_MINUTE=60*S.TIME_SECOND,S.TIME_HOUR=60*S.TIME_MINUTE,S.TIME_DAY=24*S.TIME_HOUR,S.TIME_MONTH_MIN=28*S.TIME_DAY,S.TIME_MONTH_MAX=31*S.TIME_DAY,S.TIME_YEAR_MIN=365*S.TIME_DAY,S.TIME_YEAR_MAX=366*S.TIME_DAY,S.prototype.Init=function(t,i,r){S.superclass.Init.call(this,t,i,r),"top"==this.Position||"bottom"==this.Position?(i._isOverview||"on"!=i.tickLabel.rendered||(this.StartOverflow=Math.max(e.BaseAxisInfo.MINIMUM_AXIS_BUFFER-i.leftBuffer,0),this.EndOverflow=Math.max(e.BaseAxisInfo.MINIMUM_AXIS_BUFFER-i.rightBuffer,0)),e.Agent.isRightToLeft(t)?(this._startCoord=this.EndCoord-this.EndOverflow,this._endCoord=this.StartCoord+this.StartOverflow):(this._startCoord=this.StartCoord+this.StartOverflow,this._endCoord=this.EndCoord-this.EndOverflow)):(this._startCoord=this.StartCoord,this._endCoord=this.EndCoord);var n=null!=i.tickLabel?i.tickLabel.converter:null;this._label1Converter=n&&n[0]?n[0]:n,this._label2Converter=n&&n[1]?n[1]:null,this._dateToIsoWithTimeZoneConverter=t.getLocaleHelpers().dateToIsoWithTimeZoneConverter,this._groups=i.groups;var a=i.timeAxisType;this._skipGaps="skipGaps"==a,this._mixedFrequency="mixedFrequency"==a,this.DataMin=i.dataMin,this.DataMax=i.dataMax,this._groups.length>1?this._averageInterval=(this.DataMax-this.DataMin)/(this._groups.length-1):this.DataMax-this.DataMin>0?this._averageInterval=this.DataMax-this.DataMin:this._averageInterval=6*S.TIME_MINUTE,this._step=i.step;var o=i.endGroupOffset>0?i.endGroupOffset*this._averageInterval:0,s=i.startGroupOffset>0?i.startGroupOffset*this._averageInterval:0;this.GlobalMin=null!=i.min?i.min:this.DataMin-s,this.GlobalMax=null!=i.max?i.max:this.DataMax+o,null!=i.viewportStartGroup&&(this.MinValue=i.viewportStartGroup-s),null!=i.viewportEndGroup&&(this.MaxValue=i.viewportEndGroup+o),null!=i.viewportMin&&(this.MinValue=i.viewportMin),null!=i.viewportMax&&(this.MaxValue=i.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._timeRange=this.MaxValue-this.MinValue,this._level1Labels=null,this._level2Labels=null,this._level1Coords=null,this._level2Coords=null,this._isOneLevel=!0,this._level1Overflow=[],this._level2Overflow=[],this._locale=i._locale.toLowerCase(),this._monthResources=t.LocaleData.getMonthNames("abbreviated")},S._getAMString=function(e){var t=e.substring(0,2);if("en-au"==e||"en-ie"==e||"en-ph"==e)return"am";if("en-gb"==e)return"";switch(t){case"en":return"AM";case"ar":return"ص";case"el":return"πμ";case"ko":return"오전";case"zh":return"上午";default:return""}},S._getPMString=function(e){var t=e.substring(0,2);if("en-au"==e||"en-ie"==e||"en-ph"==e)return"pm";if("en-gb"==e)return"";switch(t){case"en":return"PM";case"ar":return"م";case"el":return"μμ";case"ko":return"오후";case"zh":return"下午";default:return""}},S._getAMPMBefore=function(e){var t=e.substring(0,2);return"ko"==t||"zh"==t},S._getDMYOrder=function(e){var t=e.substring(0,2);return"en-us"==e||"en-ph"==e?"MDY":"fa"==t||"hu"==t||"ja"==t||"ko"==t||"lt"==t||"mn"==t||"zh"==t?"YMD":"DMY"},S._getYearTrailingCharacters=function(e){return 0==e.indexOf("ja")||0==e.indexOf("zh")?"年":0==e.indexOf("ko")?"년":""},S._getDayTrailingCharacters=function(e){return 0==e.indexOf("ja")||0==e.indexOf("zh")?"日":0==e.indexOf("ko")?"일":""},S.prototype.formatLabel=function(e){var t=new Date(e),i=this._formatAxisLabel(t,null,!0);return null!=i[1]?"YMD"==S._getDMYOrder(this._locale)||this._timeRange<S.TIME_MONTH_MIN&&this._step<S.TIME_DAY?i[1]+" "+i[0]:i[0]+" "+i[1]:i[0]},S.prototype._formatAxisLabelWithConverter=function(e,t,i){if(i){var r=null,n=null;if(i.getAsString?(r=i.getAsString(e),n=i.getAsString(t)):i.format&&(r=i.format(this._dateToIsoWithTimeZoneConverter&&e?this._dateToIsoWithTimeZoneConverter(e):e),n=i.format(this._dateToIsoWithTimeZoneConverter&&t?this._dateToIsoWithTimeZoneConverter(t):t)),n!=r)return r}return null},S.prototype._formatAxisLabel=function(e,t,i){var r=null,n=null,a="left"==this.Position||"right"==this.Position;return this._label1Converter||this._label2Converter?(this._label1Converter&&(r=this._formatAxisLabelWithConverter(e,t,this._label1Converter)),this._label2Converter&&(n=this._formatAxisLabelWithConverter(e,t,this._label2Converter)),[r,n]):(this._step>=S.TIME_YEAR_MIN||this._timeRange>=6*S.TIME_YEAR_MIN?r=this._formatDate(e,!1,!1,!0):this._step>=S.TIME_MONTH_MIN||this._timeRange>=6*S.TIME_MONTH_MIN?(null!=t&&t.getMonth()==e.getMonth()||(r=this._formatDate(e,!1,!0,!1)),null!=t&&t.getYear()==e.getYear()||(n=this._formatDate(e,!1,!1,!0))):this._step>=S.TIME_DAY||this._timeRange>=6*S.TIME_DAY?i?r=this._formatDate(e,!0,!0,!0):(null!=t&&t.getDate()==e.getDate()||(r=this._formatDate(e,!0,!1,!1)),null==t||t.getYear()!=e.getYear()?n=this._formatDate(e,!1,!0,!0):t.getMonth()!=e.getMonth()&&(n=this._formatDate(e,!1,!0,!1))):(this._step>=S.TIME_HOUR||this._timeRange>=6*S.TIME_HOUR?null!=t&&t.getHours()==e.getHours()||(r=this._formatTime(e,!1,!1)):this._step>=S.TIME_MINUTE||this._timeRange>=6*S.TIME_MINUTE?null!=t&&t.getMinutes()==e.getMinutes()||(r=this._formatTime(e,!0,!1)):null!=t&&t.getSeconds()==e.getSeconds()||(r=this._formatTime(e,!0,!0)),a?null!=t&&t.getDate()==e.getDate()||(n=this._formatDate(e,!0,!0,!1)):null==t||t.getYear()!=e.getYear()?n=this._formatDate(e,!0,!0,!0):t.getMonth()!=e.getMonth()?n=this._formatDate(e,!0,!0,!1):t.getDate()!=e.getDate()&&(n=this._formatDate(e,!0,!1,!1))),[r,n])},S.prototype._formatDate=function(e,t,i,r){var n,a="th"==this._locale.substring(0,2)&&"jet"!=this.Options._environment?e.getFullYear()+543:e.getFullYear();n=this._monthResources&&this._monthResources.length>=12?this._monthResources[e.getMonth()]:e.toString().split(" ")[1];var o=e.getDate();a+=S._getYearTrailingCharacters(this._locale),o+=S._getDayTrailingCharacters(this._locale);for(var s=S._getDMYOrder(this._locale),l="",h=0;h<s.length;h++)t&&"D"==s[h]?l+=o+" ":i&&"M"==s[h]?l+=n+" ":r&&"Y"==s[h]&&(l+=a+" ");return l.length>0?l.slice(0,l.length-1):l},S.prototype._formatTime=function(t,i,r){var n,a=t.getHours(),o=t.getMinutes(),s=t.getSeconds(),l=S._getAMString(this._locale),h=S._getPMString(this._locale),u=S._getAMPMBefore(this._locale),g=""!=l&&""!=h,d="";return e.Agent.isRightToLeft(this.getCtx())&&(d="‏"),g?(a<12?(n=l,0==a&&(a=12)):(n=h,a>12&&(a-=12)),d+=a,(i||0!=o)&&(d+=":"+this._doubleDigit(o))):d+=this._doubleDigit(a)+":"+this._doubleDigit(o),r&&(d+=":"+this._doubleDigit(s)),g?u?n+" "+d:d+" "+n:d},S.prototype._doubleDigit=function(e){return e<10?"0"+e:""+e},S.prototype._getMixedFrequencyStep=function(){return this._timeRange>=6*S.TIME_YEAR_MIN?S.TIME_YEAR_MIN:this._timeRange>=6*S.TIME_MONTH_MIN?S.TIME_MONTH_MIN:this._timeRange>=6*S.TIME_DAY?S.TIME_DAY:this._timeRange>=S.TIME_DAY?3*S.TIME_HOUR:this._timeRange>=6*S.TIME_HOUR?S.TIME_HOUR:this._timeRange>=S.TIME_HOUR?15*S.TIME_MINUTE:this._timeRange>=30*S.TIME_MINUTE?5*S.TIME_MINUTE:this._timeRange>=6*S.TIME_MINUTE?S.TIME_MINUTE:this._timeRange>=S.TIME_MINUTE?15*S.TIME_SECOND:this._timeRange>=30*S.TIME_SECOND?5*S.TIME_SECOND:S.TIME_SECOND},S._getLabelPositions=function(e,t,i){var r=new Date(e),n=r.getTimezoneOffset();r.setMonth(0,1),r.setHours(0,0,0,0);var a=60*(n-r.getTimezoneOffset())*1e3,o=r.getTime()+a,s=[];if(i>=S.TIME_YEAR_MIN&&i<=S.TIME_YEAR_MAX){for(;o<e;)o=S._addOneYear(o);for(;o<=t;)s.push(o),o=S._addOneYear(o)}else if(i>=S.TIME_MONTH_MIN&&i<=S.TIME_MONTH_MAX){for(;o<e;)o=S._addOneMonth(o);for(;o<=t;)s.push(o),o=S._addOneMonth(o)}else for(o+=Math.ceil((e-o)/i)*i;o<=t;)s.push(o),o+=i;return s},S._addOneYear=function(e){var t=new Date(e);return t.setFullYear(t.getFullYear()+1),t.getTime()},S._addOneMonth=function(e){var t=new Date(e);return t.setMonth(t.getMonth()+1),t.getTime()},S.prototype._generateLabels=function(t){var i=[],r=[],n=[],a=[],o=[],s=null,l=0,h=0,u=t.getStage(t),g=e.Agent.isRightToLeft(t),d="left"==this.Position||"right"==this.Position,p="off"!=this.Options.zoomAndScroll,c=!0,_=0;d&&"chrome"===e.Agent.browser&&(_=.16*this.getTickLabelHeight());var f=[];if(null!=this._step)f=S._getLabelPositions(this.MinValue,this.MaxValue,this._step);else if(this._mixedFrequency)this._step=this._getMixedFrequencyStep(),f=S._getLabelPositions(this.MinValue,this.MaxValue,this._step);else{for(var m=0;m<this._groups.length;m++)this._groups[m]>=this.MinValue&&this._groups[m]<=this.MaxValue&&f.push(this._groups[m]);if(this._step=this._averageInterval,!this._skipGaps){var v;if(d)v=e.TextUtils.getTextStringHeight(t,this.Options.tickLabel.style);else{var y=this._formatAxisLabel(new Date(f[0]))[0];v=e.TextUtils.getTextStringWidth(t,y,this.Options.tickLabel.style)}(v+this.GetTickLabelGapSize())*(f.length-1)>Math.abs(this._endCoord-this._startCoord)&&(this._step=this._getMixedFrequencyStep(),f=S._getLabelPositions(this.MinValue,this.MaxValue,this._step))}}for(0==f.length&&(f=[this.MinValue]),m=0;m<f.length;m++){var C=f[m],A=this.getCoordAt(C);if(null!=A){var b=new Date(C),x=this._formatAxisLabel(b,s),M=x[0],O=x[1];if(null!=M?(n.push({text:M,coord:null!=O?A+_:A}),a.push(A),l++):(n.push(null),a.push(null)),i.push(null),p&&c&&(A=this.MinValue?this.getCoordAt(this.MinValue):A),c=!1,null!=O){var T=this.CreateLabel(t,O,null!=O?A-_:A);o.push(A),
d||(g?T.alignRight():T.alignLeft()),r.push(T),this._isOneLevel=!1,h++}else r.push(null),o.push(null);s=b}}if(l=this._skipLabelsUniform(n,i,u,!1,g),!p&&h>1&&l<1.5*h){i=r,r=null;for(var w=0;w<i.length;w++)null!=i[w]&&i[w].alignCenter();l=this._skipLabelsGreedy(i,this.GetLabelDims(i,u),!1,g)}else 0==(h=this._skipLabelsGreedy(r,this.GetLabelDims(r,u),!0,g))&&(r=null);d&&null!=r&&this._skipVertLabels(i,r,u),this._level1Labels=i,this._level2Labels=r,this._level1Coords=a,this._level2Coords=o},S._isOverlapping=function(e,t,i,r,n){return i>=e&&i-n<t||i<e&&r+n>e},S.prototype._getLabelOverflow=function(e,t,i,r){var n=e-(i?r?t:0:.5*t);if(n<this.Options._minOverflowCoord)return Math.floor(n-this.Options._minOverflowCoord);var a=e+(i?r?0:t:.5*t);return a>this.Options._maxOverflowCoord?Math.ceil(a-this.Options._maxOverflowCoord):0},S.prototype._skipLabelsGreedy=function(e,t,i,r){if(!t||t.length<=0)return!1;for(var n,a,o,s,l,h="left"==this.Position||"right"==this.Position,u=this.getTickLabelHeight(),g=h?.08*u:.24*u,d=0,p=Math.abs(this._endCoord-this._startCoord),c=0;c<t.length;c++)if(this._level2Overflow.push(0),null!=e[c]){var _=(l=e[c]).getDimensions().w;if(t[c].w>p)e[c]=null;else{var f=this._getLabelOverflow(l.getX(),_,i,r);this._level2Overflow[c]=f,0!=f&&(l.setX(l.getX()-f),t[c].x-=f)}}for(c=0;c<t.length;c++)null!=t[c]&&(h?(o=t[c].y,s=t[c].y+t[c].h):(o=t[c].x,s=t[c].x+t[c].w),null!=n&&null!=a&&S._isOverlapping(n,a,o,s,g)&&(e[c]=null),null!=e[c]&&(n=o,a=s,d++));return d},S.prototype._skipLabelsUniform=function(e,t,i,r){for(var n=[],a=[],o=Math.abs(this._endCoord-this._startCoord),s=0;s<e.length;s++)null!=e[s]&&(n.push(e[s]),a.push(null),this._level1Overflow.push(0));for(var l="left"==this.Position||"right"==this.Position,h=this,u=function(e){if(null==a[e])if(n[e].label=h.CreateLabel(i.getCtx(),n[e].text,n[e].coord),a[e]=n[e].label.getDimensions(i),a[e].w>o)n[e].label=null,a[e].w=0,a[e].h=0;else{var t=h._getLabelOverflow(n[e].coord,a[e].w,!1,r);0!=t&&(n[e].coord-=t,a[e].x-=t,n[e].label.setX(n[e].label.getX()-t),h._level1Overflow[e]=t)}return l?a[e].h:a[e].w},g=(u(0)+this.GetTickLabelGapSize())*(n.length-1),d=o>0?Math.ceil(g/o)-1:0,p=!0;p;){for(s=0;s<n.length;s++)s%(d+1)==0?(u(s),n[s].skipped=!1):n[s].skipped=!0;p=this.IsOverlapping(a,d),d++}var c=0;for(s=0;s<e.length;s++)null==e[s]||e[s].skipped||(t[s]=e[s].label,c++);return c},S.prototype._skipVertLabels=function(e,t,i){for(var r=.08*this.getTickLabelHeight(),n=function(e,t){return S._isOverlapping(e.y,e.y+e.h,t.y,t.y+t.h,r)},a=null,o=!1,s=0;s<e.length;s++)if(e[s]&&t[s]){if(e[s].alignTop(),t[s].alignBottom(),a&&n(a,t[s].getDimensions())){o=!0;break}a=e[s].getDimensions()}else if(e[s]||t[s]){var l=e[s]?e[s]:t[s];if(a&&n(a,l.getDimensions())){o=!0;break}a=l.getDimensions()}if(o){var h,u=null,g=null,d=null;for(s=0;s<e.length;s++)t[s]?(e[s]=null,t[s].alignMiddle(),h=t[s].getDimensions(),g&&n(g,h)&&(e[u]=null),d=h):e[s]&&(h=e[s].getDimensions(),d&&n(d,h)?e[s]=null:(g=h,u=s))}},S.prototype.getLabels=function(e,t){return t&&t>1?null:(this._level1Labels||this._generateLabels(e),1==t?this._level2Labels:this._level1Labels)},S.prototype.getMajorTickCoords=function(){var e=[];if(this._isOneLevel)for(var t=0;t<this._level1Coords.length;t++)null!=this._level1Coords[t]&&null!=this._level1Labels[t]&&e.push(this._level1Coords[t]);else for(t=1;t<this._level2Coords.length;t++)null!=this._level2Coords[t]&&e.push(this._level2Coords[t]);return e},S.prototype.getMinorTickCoords=function(){if(this._isOneLevel)return[];for(var e=[],t=0;t<this._level1Coords.length;t++)null!=this._level1Coords[t]&&null!=this._level1Labels[t]&&e.push(this._level1Coords[t]);return e},S.prototype.getUnboundedValueAt=function(e){if(null==e)return null;var t=(e-this._startCoord)/(this._endCoord-this._startCoord);if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);return this._indexToTime(i+t*(r-i))}return this.MinValue+t*(this.MaxValue-this.MinValue)},S.prototype.getUnboundedCoordAt=function(e){if(null==e)return null;var t;if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);t=(this._timeToIndex(e)-i)/(r-i)}else t=(e-this.MinValue)/(this.MaxValue-this.MinValue);return this._startCoord+t*(this._endCoord-this._startCoord)},S.prototype.linearToActual=function(e){return null==e?null:this._skipGaps?this._indexToTime(e):e},S.prototype.actualToLinear=function(e){return null==e?null:this._skipGaps?this._timeToIndex(e):e},S.prototype._timeToIndex=function(e){for(var t=this._groups.length,i=0;i<this._groups.length;i++)if(e<=this._groups[i]){t=i;break}var r=t-1,n=void 0!==this._groups[r]?this._groups[r]:this._groups[0]-this._averageInterval;return r+(e-n)/((void 0!==this._groups[t]?this._groups[t]:this._groups[this._groups.length-1]+this._averageInterval)-n)},S.prototype._indexToTime=function(e){var t=Math.min(Math.max(Math.ceil(e),0),this._groups.length),i=t-1,r=void 0!==this._groups[i]?this._groups[i]:this._groups[0]-this._averageInterval;return r+(e-i)*((void 0!==this._groups[t]?this._groups[t]:this._groups[this._groups.length-1]+this._averageInterval)-r)},S.prototype.getGroupWidth=function(){return this._skipGaps?Math.abs(this.getUnboundedCoordAt(this._indexToTime(1))-this.getUnboundedCoordAt(this._indexToTime(0))):Math.abs(this.getUnboundedCoordAt(this.MinValue+this._averageInterval)-this.getUnboundedCoordAt(this.MinValue))},S.prototype.getMinimumExtent=function(){return this._skipGaps?1:this._mixedFrequency?Math.min((this.getGlobalMax()-this.getGlobalMin())/8,this._averageInterval):this._averageInterval},S.prototype.getStartOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!e.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow},S.prototype.getEndOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!e.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow};var C=function(e,t,i,r,n,a,o,s,l,h){this.Init(e,null,h),this.setWedgeParams(t,i,r,n,a,o,s,l)};e.Obj.createSubclass(C,e.Path),C._OUTER_BORDER_WIDTH=2,C._OUTER_BORDER_WIDTH_HOVER=1.25,C._INNER_BORDER_WIDTH=1,C.prototype.Init=function(e,t,i){C.superclass.Init.call(this,e,t,i)},C.prototype.setWedgeParams=function(e,t,i,r,n,a,o,s){this._cx=e,this._cy=t,this._rx=i,this._ry=r,this._sa=n,this._ae=a,this._gap=o,this._ir=s;var l=this._makeWedgePath(0);this.setCmds(l)},C.prototype._makeWedgePath=function(t){var i,r=Math.max(this._rx-t,0),n=Math.max(this._ry-t,0),a=360==this._ae||r<t?0:this._gap+2*t,o=this._ir?this._ir+t:0,s=360==this._ae?e.Math.degreesToRads(359.99):e.Math.degreesToRads(this._ae),l=e.Math.degreesToRads(this._sa),h=a/2,u=h<r?Math.asin(h/r):0,g=-s/2-l,d=Math.min(5*h,s>0?Math.abs(h/Math.sin(s/2)):0),p=0==r?d:d*n/r,c=this._cx+Math.cos(g)*d,_=this._cy+Math.sin(g)*p,f=this._cx+Math.cos(-u-l)*r,m=this._cy+Math.sin(-u-l)*n,v=this._cx+Math.cos(-l-s+u)*r,y=this._cy+Math.sin(-l-s+u)*n,S=e.Math.calculateAngleBetweenTwoVectors(v-this._cx,y-this._cy,f-this._cx,m-this._cy);if(S=Math.min(S,s),o>0){var C=h<o?Math.asin(h/o):0,A=this._cx+Math.cos(-C-l)*o,b=this._cy+Math.sin(-C-l)*o,x=this._cx+Math.cos(-l-s+C)*o,M=this._cy+Math.sin(-l-s+C)*o,O=e.Math.calculateAngleBetweenTwoVectors(x-this._cx,M-this._cy,A-this._cx,b-this._cy);O=Math.min(O,S,s),360==this._ae?(i=e.PathUtils.moveTo(v,y),i+=e.PathUtils.arcTo(r,n,s,1,f,m),i+=e.PathUtils.lineTo(v,y),i+=e.PathUtils.moveTo(A,b),i+=e.PathUtils.arcTo(o,o,s,0,x,M)):(i=e.PathUtils.moveTo(x,M),i+=e.PathUtils.lineTo(v,y),i+=e.PathUtils.arcTo(r,n,S,1,f,m),i+=e.PathUtils.lineTo(A,b),i+=e.PathUtils.arcTo(o,o,O,0,x,M))}else 360==this._ae?(i=e.PathUtils.moveTo(v,y),i+=e.PathUtils.arcTo(r,n,s,1,f,m)):(i=e.PathUtils.moveTo(c,_),i+=e.PathUtils.lineTo(v,y),i+=e.PathUtils.arcTo(r,n,S,1,f,m));return i+=e.PathUtils.closePath()},C.prototype._initializeSelectionEffects=function(){var t=this.isSelected()?C._OUTER_BORDER_WIDTH:C._OUTER_BORDER_WIDTH_HOVER,i=this._makeWedgePath(t),r=this._makeWedgePath(t+C._INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setCmds(i),void this.InnerChild.setCmds(r);this.OuterChild=new e.Path(this.getCtx(),i),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new e.Path(this.getCtx(),r),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)},C.prototype._showNestedBorders=function(e,t){this._initializeSelectionEffects(),t?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(t),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):e?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._shapeStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())},C.prototype.setStyleProperties=function(t,i,r,n,a,o,s){this._fill=t,this._shapeStroke=i,this._hoverColor=e.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=n,this._outerColor=a,this._shapeClassName=o,this._shapeStyle=s,this.setStyle(s).setClassName(o),this.setFill(t),i&&this.setStroke(i)},C.prototype.showHoverEffect=function(){this.IsShowingHoverEffect=!0,this._showNestedBorders(this._hoverColor,this._innerColor)},C.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect=!1,this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()},C.prototype.setSelected=function(e){this.IsSelected!=e&&(this.IsSelected=e,this.isHoverEffectShown()?this._showNestedBorders(this._hoverColor,this._innerColor):this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())},C.prototype.UpdateSelectionEffect=function(){};var A=function(e,t,i){this._x1=Math.min(t[0],t[4]),this._x2=Math.max(t[0],t[4]),this._y1=Math.min(t[1],t[5]),this._y2=Math.max(t[1],t[5]),this.Init(e,[this._x1,this._y1,this._x2,this._y1,this._x2,this._y2,this._x1,this._y2],i)};e.Obj.createSubclass(A,e.Polygon),A.OUTER_BORDER_WIDTH=2,A.OUTER_BORDER_WIDTH_HOVER=1.25,A.INNER_BORDER_WIDTH=1,A.prototype.setStyleProperties=function(t,i,r,n,a,o,s){this._fill=t,this._borderStroke=i,this._hoverColor=e.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=n,this._outerColor=a,this._shapeClassName=o,this._shapeStyle=s,this.setStyle(s).setClassName(o),this.setFill(t),i&&this.setStroke(i)},A.prototype.setAnimationParams=function(e){this._x1=Math.min(e[0],e[4]),this._x2=Math.max(e[0],e[4]),this._y1=Math.min(e[1],e[5]),this._y2=Math.max(e[1],e[5]),this.setPoints(e),this._initializeSelectionEffects()},A.prototype.showHoverEffect=function(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this._showNestedBorders(this._hoverColor,this._innerColor))},A.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())},A.prototype.setSelected=function(e){this.IsSelected!=e&&(this.IsSelected=e,this.isHoverEffectShown()?this._showNestedBorders(this._hoverColor,this._innerColor):this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())},A.prototype.UpdateSelectionEffect=function(){},A.prototype.getPrimaryFill=function(){return this._fill},A.prototype._initializeSelectionEffects=function(){var t=this.isSelected()?A.OUTER_BORDER_WIDTH:A.OUTER_BORDER_WIDTH_HOVER,i=this._createPointsArray(t),r=this._createPointsArray(t+A.INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setPoints(i),void this.InnerChild.setPoints(r);this.OuterChild=new e.Polygon(this.getCtx(),i),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new e.Polygon(this.getCtx(),r),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)},A.prototype._showNestedBorders=function(e,t){this._initializeSelectionEffects(),t?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(t),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):e?(this.setSolidFill(e),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._borderStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())},A.prototype._createPointsArray=function(e){var t=this._x1+e,i=this._x2-e,r=this._y1+e,n=this._y2-e;return[t,r,i,r,i,n,t,n]};var b=function(e,t,i){this.Init(e,t,i)};e.Obj.createSubclass(b,h),b.prototype.axisToPlotArea=function(e){if("tangential"==this.getOptions().position)return e;if(null==e)return null;var t=e-this.getLeftOverflow();return Math.round(10*t)/10},b.prototype.plotAreaToAxis=function(e,t){if("tangential"==this.getOptions().position)return e;if(null==e)return null;var i=e+this.getLeftOverflow();return!1===t?i:Math.round(i)},b.prototype.linearToActual=function(e){return this.Info.linearToActual(e)},b.prototype.actualToLinear=function(e){return this.Info.actualToLinear(e)},b.prototype.getValueAt=function(e){return this.Info.getValueAt(this.plotAreaToAxis(e))},b.prototype.getCoordAt=function(e){return this.axisToPlotArea(this.Info.getCoordAt(e))},b.prototype.getBoundedCoordAt=function(e){return this.axisToPlotArea(this.Info.getBoundedCoordAt(e))},b.prototype.getUnboundedValueAt=function(e){return this.Info.getUnboundedValueAt(this.plotAreaToAxis(e))},b.prototype.getUnboundedCoordAt=function(e){return this.axisToPlotArea(this.Info.getUnboundedCoordAt(e))},b.prototype.getBaselineCoord=function(){return this.axisToPlotArea(this.Info.getBaselineCoord())},b.prototype.getPosition=function(){return this.getOptions().position},b.prototype.isGroupAxis=function(){return this.Info instanceof v},b.prototype.getMajorTickCoords=function(){for(var e=this.Info?this.Info.getMajorTickCoords():[],t=0;t<e.length;t++)e[t]=this.axisToPlotArea(e[t]);return e},b.prototype.getMinorTickCoords=function(){for(var e=this.Info?this.Info.getMinorTickCoords():[],t=0;t<e.length;t++)e[t]=this.axisToPlotArea(e[t]);return e},b.prototype.getBaselineCoord=function(){return this.axisToPlotArea(this.Info.getBaselineCoord())},b.prototype.getLinearGlobalMin=function(){return this.actualToLinear(this.Info.getGlobalMin())},b.prototype.getLinearGlobalMax=function(){return this.actualToLinear(this.Info.getGlobalMax())},b.prototype.getLinearViewportMin=function(){return this.actualToLinear(this.Info.getViewportMin())},b.prototype.getLinearViewportMax=function(){return this.actualToLinear(this.Info.getViewportMax())},b.prototype.getUnboundedLinearValueAt=function(e){return this.Info.actualToLinear(this.getUnboundedValueAt(e))},b.prototype.isFullViewport=function(){return this.Info.getViewportMin()==this.Info.getGlobalMin()&&this.Info.getViewportMax()==this.Info.getGlobalMax()},b.prototype.getLeftOverflow=function(){return e.Agent.isRightToLeft(this.getCtx())?this.Info.getEndOverflow():this.Info.getStartOverflow()},b.prototype.getRightOverflow=function(){return e.Agent.isRightToLeft(this.getCtx())?this.Info.getStartOverflow():this.Info.getEndOverflow()},b.prototype.getLength=function(){return Math.abs(this.Info.getStartCoord()-this.Info.getEndCoord())},b.prototype.getMinCoord=function(){return this.axisToPlotArea(Math.min(this.Info.getStartCoord(),this.Info.getEndCoord()))},b.prototype.getMaxCoord=function(){return this.axisToPlotArea(Math.max(this.Info.getStartCoord(),this.Info.getEndCoord()))};var x=function(e,t,i,r,n,a,o){o||this.Init(e.getCtx()),this._bHoriz=ne.isHorizontal(e),this._bStacked=ne.isStacked(e),this._barGapRatio=te.getBarGapRatio(e),this._dataItemGaps=te.getDataItemGaps(e),this._axisCoord=t,this._doNotRender=!!o,this._setBarCoords(i,r,n,a,!0)};e.Obj.createSubclass(x,A),x._INDICATOR_OFFSET=8,x._MIN_BAR_WIDTH_FOR_GAPS=5,x._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING=15,x._MIN_BAR_LENGTH_FOR_GAPS=5,x._MAX_GAP_SIZE=2,x.prototype.setSelected=function(e){this.IsSelected!=e&&(this.IsSelected=e,this.isSelected()?(this._tempX1=this._x1,this._tempX2=this._x2,this._tempBaselineCoord=this._baselineCoord,this._x1=this._origX1,this._x2=this._origX2,this._baselineCoord=this._origBaselineCoord,this.setPoints(this._createPointsArray()),this._showNestedBorders(this.isHoverEffectShown()?this._hoverColor:this._outerColor,this._innerColor)):(this._x1=this._tempX1,this._x2=this._tempX2,this._baselineCoord=this._tempBaselineCoord,this.setPoints(this._createPointsArray()),this._showNestedBorders(this.isHoverEffectShown()?this._hoverColor:null)))},x.prototype.getAnimationParams=function(e){return e?this._bHoriz?[this._x2,this._x1,this._baselineCoord,this._endCoord]:[this._x1,this._x2,this._endCoord,this._baselineCoord]:[this._baselineCoord,this._endCoord,this._x1,this._x2]},x.prototype.setAnimationParams=function(e,t){if(this._setBarCoords(e[0],e[1],e[2],e[3],!1),t){var i=this.getIndicatorPosition();t.setTranslate(i.x,i.y),t.setAlpha(1),t.getParent().addChild(t)}},x.prototype.getDisplayAnimation=function(t){var i=this.getAnimationParams();this.setAnimationParams([this._axisCoord,this._axisCoord,this._x1,this._x2]);var r=new e.CustomAnimation(this.getCtx(),this,t);return r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r},x.prototype.getDeleteAnimation=function(t){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new e.CustomAnimation(this.getCtx(),this,t);return r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r},x.prototype.getInsertAnimation=function(t){this.setAlpha(0);var i=this.getDisplayAnimation(t);return i.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i},x.prototype.getIndicatorPosition=function(){var t,i,r=(this._x1+this._x2)/2;if(this._bStacked){var n=(this._endCoord+this._baselineCoord)/2;t=this._bHoriz?n:r,i=this._bHoriz?r:n}else{var a=this._endCoord>=this._baselineCoord?this._endCoord+x._INDICATOR_OFFSET:this._endCoord-x._INDICATOR_OFFSET;t=this._bHoriz?a:r,i=this._bHoriz?r:a}return new e.Point(t,i)},x.prototype._setBarCoords=function(t,i,r,n,a){this._baselineCoord=t,this._endCoord=i,this._x1=r,this._x2=n;var o=this._x2-this._x1;if(o<1&&(this._x1=Math.floor(this._x1),this._x2=this._x1+1,o=1),this._origX1=this._x1,this._origX2=this._x2,this._origBaselineCoord=this._baselineCoord,this._origSize=this._x2-this._x1,this._dataItemGaps>0&&a&&!this.isSelected()){var s=Math.ceil(x._MAX_GAP_SIZE*this._dataItemGaps),l=Math.abs(this._baselineCoord-this._endCoord),h=this._axisCoord==this._baselineCoord;l>=x._MIN_BAR_LENGTH_FOR_GAPS&&this._bStacked&&!h&&(this._baselineCoord+=this._endCoord>this._baselineCoord?s:-s),o>=x._MIN_BAR_WIDTH_FOR_GAPS&&(1==e.Agent.getDevicePixelRatio()&&this._barGapRatio>0&&o>x._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING?("firefox"===e.Agent.browser||this._doNotRender||this.setPixelHinting(!0),this._x1=Math.round(this._x1),this._x2=Math.round(this._x2),this._origX1=this._x1,this._origX2=this._x2,this._x2-=s):(this._x1+=s/2,this._x2-=s/2),this._origSize-=s)}if(!this._doNotRender){var u=this._createPointsArray();this.setPoints(u),this.OuterChild&&this.OuterChild.setPoints(this._createPointsArray(A.OUTER_BORDER_WIDTH)),this.InnerChild&&this.InnerChild.setPoints(this._createPointsArray(A.OUTER_BORDER_WIDTH+A.INNER_BORDER_WIDTH))}},x.prototype._createPointsArray=function(e){var t=this._baselineCoord,i=this._endCoord,r=this._x1,n=this._x2;if(e>0){if(Math.abs(r-n)<2*e||Math.abs(t-i)<2*e)return[];r+=e,n-=e,i<t?(t-=e,i+=e):(t+=e,i-=e)}return this._bHoriz?[i,r,i,n,t,n,t,r]:[r,i,n,i,n,t,r,t]},x.prototype.getBoundingBox=function(){var t=Math.min(this._x2,this._x1),i=Math.min(this._endCoord,this._baselineCoord),r=Math.abs(this._x2-this._x1),n=Math.abs(this._endCoord-this._baselineCoord);return this._bHoriz?new e.Rectangle(i,t,n,r):new e.Rectangle(t,i,r,n)},x.prototype.getOriginalBarSize=function(){return this._origSize},x.prototype.getDimensionsSelf=function(e){return this.ConvertCoordSpaceRect(this.getBoundingBox(),e)};var M=function(t,i,r,n,a,o,s,l,h){this.Init(t.getCtx()),this._chart=t,this._bHoriz=ne.isHorizontal(t),this._styleOptions=h,this._innerColor=te.getSelectedInnerColor(this._chart),this._outerColor=te.getSelectedOuterColor(this._chart),this._hoverColor=e.SelectionEffectUtils.getHoverBorderColor(this._styleOptions._color);var u=i-r/2,g=i+r/2;te.getDataItemGaps(t)>0&&r>x._MIN_BAR_WIDTH_FOR_GAPS&&g--,this._render(u,g,n,a,o,s,l)};e.Obj.createSubclass(M,e.Shape),M.prototype._render=function(t,i,r,n,a,o,s){this._cleanUp();var l=this.getCtx();this._x1=Math.round(t),this._x2=Math.round(i),this._low=Math.round(r),this._q1=Math.round(n),this._q2=Math.round(a),this._q3=Math.round(o),this._high=Math.round(s);var h=i-t,u=te.getSizeInPixels(this._styleOptions.whiskerEndLength,h);u=Math.min(h,u),u=2*Math.floor((u-1)/2)+1;var g=Math.floor((t+i)/2)+.5,d=g-Math.floor(u/2)-.5,p=g+Math.floor(u/2)+.5;this._drawLine(g,this._low,g,this._high,"whisker"),this._drawLine(d,this._low,p,this._low,"whiskerEnd"),this._drawLine(d,this._high,p,this._high,"whiskerEnd"),this._q2Box=new e.Polygon(l,this._createQ2PointsArray(0));var c=ee.getRectangleFill(this._chart,this._styleOptions.q2Color,this._styleOptions._q2Pattern,h);this._q2Box.setFill(c),this._applyCustomStyle(this._q2Box,"q2"),this.addChild(this._q2Box),this._q3Box=new e.Polygon(l,this._createQ3PointsArray(0));var _=ee.getRectangleFill(this._chart,this._styleOptions.q3Color,this._styleOptions._q3Pattern,h);this._q3Box.setFill(_),this._applyCustomStyle(this._q3Box,"q3"),this.addChild(this._q3Box),this._drawMedianLine(0),this._borderColor=this._styleOptions.borderColor,this._borderColor&&(this._borderWidth=this._styleOptions.borderWidth,this._drawBorders(this._borderColor,this._borderWidth)),this.IsSelected&&(this.IsSelected=!1,this.setSelected(!0))},M.prototype.showHoverEffect=function(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this.isSelected()?this._drawBorders(this._hoverColor,A.OUTER_BORDER_WIDTH,this._innerColor,A.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,A.OUTER_BORDER_WIDTH_HOVER,this._innerColor,A.INNER_BORDER_WIDTH))},M.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this.isSelected()?this._drawBorders(this._outerColor,A.OUTER_BORDER_WIDTH,this._innerColor,A.INNER_BORDER_WIDTH):this._drawBorders(this._borderColor,this._borderWidth))},M.prototype.setSelected=function(e){this.IsSelected!=e&&(this.IsSelected=e,this.isHoverEffectShown()?e?this._drawBorders(this._hoverColor,A.OUTER_BORDER_WIDTH,this._innerColor,A.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,A.OUTER_BORDER_WIDTH_HOVER,this._innerColor,A.INNER_BORDER_WIDTH):e?this._drawBorders(this._outerColor,A.OUTER_BORDER_WIDTH,this._innerColor,A.INNER_BORDER_WIDTH):this._drawBorders(this._borderColor,this._borderWidth))},M.prototype.UpdateSelectionEffect=function(){},M.prototype.getDisplayAnimation=function(e){return this.getInsertAnimation(e)},M.prototype.getDeleteAnimation=function(t){var i=new e.CustomAnimation(this.getCtx(),this,t),r=[this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2];return i.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,r),i.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i},M.prototype.getInsertAnimation=function(t){var i=new e.CustomAnimation(this.getCtx(),this,t),r=this._getAnimationParams();return this._setAnimationParams([this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2]),i.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,r),this.setAlpha(0),i.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i},M.prototype.getUpdateAnimation=function(t,i){var r=new e.CustomAnimation(this.getCtx(),this,t),n=i._getQ2Fill(),a=this._getQ2Fill();n.equals(a)||(this._setQ2Fill(n),r.getAnimator().addProp(e.Animator.TYPE_FILL,this,this._getQ2Fill,this._setQ2Fill,a));var o=i._getQ3Fill(),s=this._getQ3Fill();o.equals(s)||(this._setQ3Fill(o),r.getAnimator().addProp(e.Animator.TYPE_FILL,this,this._getQ3Fill,this._setQ3Fill,s));var l=this._getAnimationParams();return this._setAnimationParams(i._getAnimationParams()),r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,l),r},M.prototype._getAnimationParams=function(){return[this._x1,this._x2,this._low,this._q1,this._q2,this._q3,this._high]},M.prototype._setAnimationParams=function(e){this._render(e[0],e[1],e[2],e[3],e[4],e[5],e[6])},M.prototype._getQ2Fill=function(){return new e.SolidFill(this._styleOptions.q2Color)},M.prototype._setQ2Fill=function(e){this._styleOptions.q2Color=e.getColor()},M.prototype._getQ3Fill=function(){return new e.SolidFill(this._styleOptions.q3Color)},M.prototype._setQ3Fill=function(e){this._styleOptions.q3Color=e.getColor()},M.prototype._drawLine=function(t,i,r,n,a){var o=this._bHoriz?new e.Line(this.getCtx(),i,t,n,r):new e.Line(this.getCtx(),t,i,r,n);return this._applyCustomStyle(o,a),o.setPixelHinting(!0),this.addChild(o),o},M.prototype._drawMedianLine=function(t){if(!this._medianLine){var i=new e.Line(this.getCtx(),0,0,0,0);this._applyCustomStyle(i,"median"),i.setPixelHinting(!0),this.addChild(i),this._medianLine=i}var r=this._x1+t,n=this._x2-t,a=this._q2;this._bHoriz?(this._medianLine.setX1(a),this._medianLine.setX2(a),this._medianLine.setY1(r),this._medianLine.setY2(n)):(this._medianLine.setY1(a),this._medianLine.setY2(a),this._medianLine.setX1(r),this._medianLine.setX2(n))},M.prototype._drawBorders=function(t,i,r,n){if(!this._outerBorderShape){var a=this.getChildIndex(this._q2Box);this._innerBorderShape=new e.Polygon(this.getCtx()),this._innerBorderShape.setInvisibleFill(),this.addChildAt(this._innerBorderShape,a),this._outerBorderShape=new e.Polygon(this.getCtx()),this._outerBorderShape.setInvisibleFill(),this.addChildAt(this._outerBorderShape,a)}var o=0;i?(this._outerBorderShape.setPoints(this._createBoxPointsArray(0)),this._outerBorderShape.setSolidFill(t),o+=i,n?(this._innerBorderShape.setPoints(this._createBoxPointsArray(i)),this._innerBorderShape.setSolidFill(r),o+=n):this._innerBorderShape.setInvisibleFill()):(this._outerBorderShape.setInvisibleFill(),this._innerBorderShape.setInvisibleFill()),this._q2Box.setPoints(this._createQ2PointsArray(o)),this._q3Box.setPoints(this._createQ3PointsArray(o)),this._drawMedianLine(o)},M.prototype._createBoxPointsArray=function(e){var t,i,r=this._x1+e,n=this._x2-e;return this._q1<this._q3?(t=this._q1+e,i=this._q3-e):(t=this._q1-e,i=this._q3+e),this._createPointsArray(r,n,t,i)},M.prototype._createQ3PointsArray=function(e){var t,i=this._x1+e,r=this._x2-e,n=this._q2;return t=this._q2<this._q3?this._q3-e:this._q3+e,this._createPointsArray(i,r,n,t)},M.prototype._createQ2PointsArray=function(e){var t,i=this._x1+e,r=this._x2-e,n=this._q2;return t=this._q2<this._q1?this._q1-e:this._q1+e,this._createPointsArray(i,r,t,n)},M.prototype._createPointsArray=function(e,t,i,r){return this._bHoriz?[i,e,i,t,r,t,r,e]:[e,i,t,i,t,r,e,r]},M.prototype._applyCustomStyle=function(e,t){e.setStyle(this._styleOptions[t+"Style"]||this._styleOptions[t+"SvgStyle"],!0),e.setClassName(this._styleOptions[t+"ClassName"]||this._styleOptions[t+"SvgClassName"],!0)},M.prototype._cleanUp=function(){this.removeChildren(),this._q2Box=null,this._q3Box=null,this._medianLine=null,this._outerBorderShape=null,this._innerBorderShape=null};var O=function(e,t,i,r,n,a,o){this.Init(e),i=Math.max(2*Math.round(i/2),1);var s=Math.min(2*Math.ceil(O._BAR_WIDTH*i/2),i),l=Math.round(t)-i/2,h=l+i;if(null!=a&&null!=o){var u=Math.round(t)-s/2,g=u+s;this._rangeShape=new A(e,[u,a,g,a,g,o,u,o]),this.addChild(this._rangeShape)}this._changeShape=new A(e,[l,r,h,r,h,n,l,n]),this.addChild(this._changeShape),this.setPixelHinting(!0)};e.Obj.createSubclass(O,e.Container),O._BAR_WIDTH=.3,O.prototype.setChangeStyle=function(e,t,i,r,n){this._changeShape.setStyleProperties(e,t,i,r,n)},O.prototype.setRangeStyle=function(e,t,i,r){this._rangeShape&&this._rangeShape.setStyleProperties(e,t,i,null,r)},O.prototype.setSelected=function(e){this._changeShape.setSelected(e),this._rangeShape&&this._rangeShape.setSelected(e)},O.prototype.showHoverEffect=function(){this._changeShape.showHoverEffect(),this._rangeShape&&this._rangeShape.showHoverEffect()},O.prototype.hideHoverEffect=function(){this._changeShape.hideHoverEffect(),this._rangeShape&&this._rangeShape.hideHoverEffect()},O.prototype.getDisplayAnimation=function(t){var i=new e.CustomAnimation(this.getCtx(),this,t),r=this._changeShape.getPoints();if(this._changeShape.setPoints(O._getInitialPoints(r)),i.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimationParams,r),this._rangeShape){var n=this._rangeShape.getPoints();this._rangeShape.setPoints(O._getInitialPoints(n)),i.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimationParams,n)}return i},O.prototype.getDeleteAnimation=function(t){var i=new e.CustomAnimation(this.getCtx(),this,t),r=O._getInitialPoints(this._changeShape.getPoints());if(i.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimationParams,r),this._rangeShape){var n=O._getInitialPoints(this._rangeShape.getPoints());i.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimationParams,n)}return i.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i},O.prototype.getInsertAnimation=function(t){this.setAlpha(0);var i=this.getDisplayAnimation(t);return i.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i},O.prototype.getUpdateAnimation=function(t,i){var r=new e.CustomAnimation(this.getCtx(),this,t),n=this._changeShape.getPoints();this._changeShape.setPoints(i._changeShape.getPoints()),r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimationParams,n);var a=i._changeShape.getPrimaryFill(),o=this._changeShape.getPrimaryFill();if(i._changeShape.isSelected()||this._changeShape.isSelected()||a.equals(o)||(this._changeShape.setFill(a),r.getAnimator().addProp(e.Animator.TYPE_FILL,this._changeShape,this._changeShape.getFill,this._changeShape.setFill,o)),this._rangeShape&&i._rangeShape){var s=this._rangeShape.getPoints();this._rangeShape.setPoints(i._rangeShape.getPoints()),r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimationParams,s)}return r},O.prototype.UpdateSelectionEffect=function(){},O._getInitialPoints=function(e){var t=e[0],i=e[2],r=(e[1]+e[5])/2;return[t,r,i,r,i,r,t,r]};var T=function(e,t,i,r,n,a){this.x=e,this.y1=t,this.y2=i,this.groupIndex=r,this.group=n,this.filtered=a}
;e.Obj.createSubclass(T,e.Obj),T.prototype.isUpstep=function(e){return Math.abs(this.y2-e)>Math.abs(this.y1-e)},T.prototype.clone=function(){return new T(this.x,this.y1,this.y2,this.groupIndex,this.group,this.filtered)};var w=function(e,t,i,r,n,a,o,s,l,h,u,g){this.Init(e.getCtx()),this._chart=e,this._bArea=t,this._availSpace=i,this._baseline=r,this._style=n,this._className=a,this._fill=o,this._stroke=s,this._type=l,this._baseType=u||l,this._indicatorMap={},this.setCoords(h,g)};e.Obj.createSubclass(w,e.Container),w._INDICATOR_OFFSET=8,w.prototype.setCoords=function(e,t){this._arCoord=e,t&&(this._arBaseCoord=t),this.removeChildren(),this._bArea?this._renderAreas():this._renderLines(),this._positionIndicators()},w.prototype.getCoords=function(){return this._arCoord},w.prototype.getBaseCoords=function(){return this._arBaseCoord},w.prototype.getBaseline=function(){return this._baseline},w.prototype.isArea=function(){return this._bArea},w.prototype._getPointArrays=function(t,i){var r=[],n=[];r.push(n),t=w._convertToPointCoords(t);var a,o,s,l,h,u=ne.isPolar(this._chart),g="centeredStepped"==i||"centeredSegmented"==i,d=g||"stepped"==i||"segmented"==i,p=te.getGroupWidth(this._chart),c=e.Agent.isRightToLeft(this.getCtx())&&ne.isVertical(this._chart)?-1:1;u&&(a=t[t.length-1]);for(var _=!1,f=0;f<t.length;f++)null!=t[f]?(o=t[f],l=t[f]._isY2,s=g?o.x-p/2*c:o.x,l&&(_&&d&&(s+=p*c),_=!_),"curved"==i&&l&&n.push(null,null),a&&d&&this._pushCoord(n,s,a.y),this._bArea||"segmented"!=i&&"centeredSegmented"!=i||(n=[],r.push(n)),this._pushCoord(n,s,o.y),a=o):(Z.isMixedFrequency(this._chart)||d&&!u&&a&&!l&&(h=g?a.x+.5*p*c:a.x+p*c,this._pushCoord(n,h,a.y)),"jet"!=this._chart.getOptions()._environment&&Z.isMixedFrequency(this._chart)||(n=[],r.push(n),a=null));if(d&&!u&&a&&!l&&(h=g?a.x+.5*p*c:a.x+p*c,this._pushCoord(n,h,a.y)),u&&r.length>1){var m=r.pop();r[0]=m.concat(r[0])}return r},w.prototype._pushCoord=function(t,i,r){var n=pe.convertAxisCoord(this._chart,new e.Point(i,r),this._availSpace);t.push(Math.round(10*n.x)/10,Math.round(10*n.y)/10)},w.prototype._isRing=function(){if(!ne.isPolar(this._chart)||!Z.hasGroupAxis(this._chart)||this._arCoord.length<J.getGroupCount(this._chart))return!1;for(var e=0;e<this._arCoord.length;e++)if(null==this._arCoord[e].x)return!1;return!0},w.prototype._getSplineType=function(){return ne.isScatterBubble(this._chart)?e.PathUtils.SPLINE_TYPE_CARDINAL:ne.isPolar(this._chart)?this._isRing()?e.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED:e.PathUtils.SPLINE_TYPE_CARDINAL:ne.isHorizontal(this._chart)?e.PathUtils.SPLINE_TYPE_MONOTONE_HORIZONTAL:e.PathUtils.SPLINE_TYPE_MONOTONE_VERTICAL},w.prototype._renderLines=function(){for(var t,i=this._getPointArrays(this._arCoord,this._type),r=0;r<i.length;r++){var n=i[r];if(n&&n.length>1){if("curved"==this._type){var a=w._getCurvedPathCommands(n,!1,this._getSplineType());(t=new e.Path(this.getCtx(),a)).setFill(null)}else this._isRing()?(t=new e.Polygon(this.getCtx(),n)).setFill(null):t=new e.Polyline(this.getCtx(),n);t.setStroke(this._stroke),t.setClassName(this._className).setStyle(this._style),this.addChild(t)}}},w.prototype._renderAreas=function(){var t=this._arCoord,i=this._arBaseCoord;!ne.isPolar(this._chart)&&t.length>0&&i.length>0&&(t=t.slice(0),i=i.slice(0),null!=t[0].x&&null!=i[0].x&&(w._removeAreaEdge(t,0,this._baseline),w._removeAreaEdge(i,0,this._baseline),i[0].x=t[0].x),null!=t[t.length-1].x&&null!=i[i.length-1].x&&(w._removeAreaEdge(t,t.length-1,this._baseline),w._removeAreaEdge(i,i.length-1,this._baseline),i[i.length-1].x=t[t.length-1].x));var r=this._getPointArrays(t,this._type),n=this._getPointArrays(i,this._baseType);if(r.length==n.length)for(var a,o=0;o<r.length;o++){var s=r[o],l=n[o];if(!(s.length<2)){var h="curved"==this._type,u="curved"==this._baseType;this._isRing()&&(h||s.push(s[0],s[1]),l.length>=2&&!u&&l.push(l[0],l[1]));for(var g=[],d=0;d<l.length;d+=2)g.unshift(l[d],l[d+1]);if(h||u){var p=this._getSplineType(),c=h?w._getCurvedPathCommands(s,!1,p):e.PathUtils.polyline(s,!1);c+=u?w._getCurvedPathCommands(g,!0,p):e.PathUtils.polyline(g,!0),c+=e.PathUtils.closePath(),a=new e.Path(this.getCtx(),c)}else{var _=g.concat(s);a=new e.Polygon(this.getCtx(),_)}a.setFill(this._fill),a.setClassName(this._className).setStyle(this._style),this._stroke&&a.setStroke(this._stroke),this.addChild(a)}}},w.prototype._positionIndicators=function(){for(var t,i,r,n,a,o=0;o<this._arCoord.length;o++)a=this._arCoord[o],(t=this._indicatorMap[a.groupIndex])&&t.indicator&&(n=(a.isUpstep(this._baseline)?a.y2:a.y1)+w._INDICATOR_OFFSET*(t.direction==q.DIR_UP?-1:1),r=pe.convertAxisCoord(this._chart,new e.Point(a.x,n),this._availSpace),(i=t.indicator).setTranslate(r.x,r.y),i.setAlpha(1),i.getParent().addChild(i))},w.prototype.getAnimationParams=function(e){return w._coordsToAnimationParams(this._arCoord,e?e._arCoord:null,this._baseline)},w.prototype.setAnimationParams=function(e){var t=w._animationParamsToCoords(e);this.setCoords(t)},w.prototype.getBaseAnimationParams=function(e){return w._coordsToAnimationParams(this._arBaseCoord,e?e._arBaseCoord:null,this._baseline)},w.prototype.setBaseAnimationParams=function(e){this._arBaseCoord=w._animationParamsToCoords(e)},w.prototype.getCommonGroupIndices=function(e){for(var t=[],i=0;i<this._arCoord.length;i++)if(!this._arCoord[i].filtered&&null!=this._arCoord[i].x)for(var r=0;r<e._arCoord.length;r++)if(!e._arCoord[r].filtered&&null!=e._arCoord[r].x&&this._arCoord[i].group==e._arCoord[r].group){t.push(this._arCoord[i].groupIndex);break}return t},w.prototype.addIndicator=function(e,t,i){i.setAlpha(0),this._indicatorMap[e]={direction:t,indicator:i}},w.prototype.removeIndicators=function(){for(var e in this._indicatorMap){var t=this._indicatorMap[e].indicator;t&&t.getParent().removeChild(t)}this._indicatorMap={}},w._convertToPointCoords=function(t){for(var i=[],r=0;r<t.length;r++)if(!t[r].filtered)if(null==t[r].x)i.push(null);else if(i.push(new e.Point(t[r].x,t[r].y1)),t[r].y1!=t[r].y2){var n=new e.Point(t[r].x,t[r].y2);n._isY2=!0,i.push(n)}return i},w._coordsToAnimationParams=function(e,t,i){if(t&&t.length>0)if(e&&e.length>0){e=e.slice(0);for(var r,n,a,o=w._coordsToGroups(t),s=w._coordsToGroups(e),l=e.length,h=o.length-1;h>=0;h--)r=o[h],-1==(n=s.indexOf(r))?(0==l?(a=e[0].clone(),e[0]=e[0].clone(),w._removeCoordJump(a,e[0],i)):(a=e[l-1].clone(),e[l-1]=e[l-1].clone(),w._removeCoordJump(e[l-1],a,i)),a.groupIndex=-1,e.splice(l,0,a)):l=n}else for(e=[],h=0;h<t.length;h++)e.push(new T(t[h].x,i,i));for(var u=[],g=0;g<e.length;g++)e[g].filtered||(null==e[g].x?(u.push(1/0),u.push(1/0),u.push(1/0)):(u.push(e[g].x),u.push(e[g].y1),u.push(e[g].y2)),u.push(e[g].groupIndex));return u},w._animationParamsToCoords=function(e){for(var t=[],i=0;i<e.length;i+=4)e[i]==1/0||isNaN(e[i])?t.push(new T(null,null,null,e[i+3])):t.push(new T(e[i],e[i+1],e[i+2],e[i+3]));return t},w._coordsToGroups=function(e){for(var t=[],i=0;i<e.length;i++)e[i].filtered||t.push(e[i].group);return t},w._removeCoordJump=function(e,t,i){e.isUpstep(i)?t.y1=t.y2:e.y2=e.y1},w._getCurvedPathCommands=function(t,i,r){var n=[],a=[];n.push(a);for(var o=0;o<t.length;o+=2)null==t[o]?(a=[],n.push(a)):a.push(t[o],t[o+1]);if(r==e.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED&&n.length>1){var s=n.pop();n[0]=s.concat(n[0]),r=e.PathUtils.SPLINE_TYPE_CARDINAL}var l="";for(o=0;o<n.length;o++)a=n[o],l+=e.PathUtils.curveThroughPoints(a,i,r),i=!0;return l},w._removeAreaEdge=function(e,t,i){var r=e[t].clone();r.isUpstep(i)?r.y1=r.y2:r.y2=r.y1,e[t]=r};var D=function(e,t,i,r,n,a){this.Init(e,t,i,r,n,n,null,null,!0),a&&this.setStroke(D.DEFAULT_STROKE)};e.Obj.createSubclass(D,e.SimpleMarker),D.DEFAULT_STROKE=new e.Stroke("none"),D.SELECTED_FILL=new e.SolidFill("#FFFFFF"),D.SELECTED_STROKE=new e.Stroke("#5A5A5A",1,1.5),D.prototype.setDataColor=function(t){this._dataColor=t,this._hoverStroke=new e.Stroke(t,1,1.5)},D.prototype.getDataColor=function(){return this._dataColor},D.prototype.showHoverEffect=function(){this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)},D.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?D.SELECTED_STROKE:D.DEFAULT_STROKE)},D.prototype.setSelected=function(e){this.IsSelected!=e&&(this.IsSelected=e,this.isSelected()?(this.setFill(D.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.DEFAULT_STROKE)))},D.prototype.UpdateSelectionEffect=function(){};var E=function(e){this.Init(e.getCtx(),e.processEvent,e),this._parentChart=e,this._chart=e.overview?e.overview.getBackgroundChart():null,this._id=e.getId()+"_overview"};e.Obj.createSubclass(E,e.Overview),E.prototype._renderChart=function(t,i,r){this._chartContainer=new e.Container(this.getCtx()),this.addChild(this._chartContainer),t=e.JsonUtils.merge({legend:{rendered:"off",size:null},xAxis:{viewportMin:null,viewportMax:null,viewportStartGroup:null,viewportEndGroup:null,axisLine:{rendered:"off"},size:null,maxSize:.5,title:null},yAxis:{rendered:"off",size:null},y2Axis:{rendered:"off",size:null},splitDualY:"off",title:{text:null},subtitle:{text:null},footnote:{text:null},titleSeparator:{rendered:"off"},styleDefaults:{animationIndicators:"none"},layout:{outerGapWidth:0,outerGapHeight:0},_isOverview:!0},t),Z.hasGroupAxis(this._parentChart)&&(t.xAxis.tickLabel.rendered="off"),ne.isStock(this._parentChart)&&t.series&&t.series[0]&&(t.series=[t.series[0]],t.series[0].type="lineWithArea");var n=this._parentChart.getOptions().overview.content,a="on"===(t=e.JsonUtils.merge(n,t)).yAxis.rendered,o="on"===t.y2Axis.rendered;t.zoomAndScroll="off",this._chart||(this._chart=e.Chart.newInstance(this.getCtx()),this._chart.setId(this._id));var s=i,l=this._parentChart.__getPlotAreaSpace().x;a&&(s=l+i,t.yAxis.size=l),o&&(s=this._parentChart.getWidth()-(a?0:l),t.y2Axis.size=this._parentChart.getWidth()-(l+i)),this._chartContainer.addChild(this._chart),this._chart.render(t,s,r);var h=new e.Rect(this.getCtx(),0,0,s,r);h.setInvisibleFill(),this._chartContainer.addChild(h),this._chart.getEventManager().setKeyboardHandler(null);var u=this._chart.__getPlotAreaSpace();if(a){var g=this._chartContainer.getTranslateX()-u.x;this._chartContainer.setTranslateX(g)}return new e.Dimension(i,u.h+u.y)},E.prototype.render=function(e,t,i){e.style={overviewBackgroundColor:"rgba(0,0,0,0)",windowBackgroundColor:"rgba(0,0,0,0)",windowBorderTopColor:"#333333",windowBorderRightColor:"#333333",windowBorderBottomColor:"#333333",windowBorderLeftColor:"#333333",leftFilterPanelColor:"rgba(5,65,135,0.1)",rightFilterPanelColor:"rgba(5,65,135,0.1)",handleBackgroundImage:e.chart._resources.overviewGrippy,handleWidth:3,handleHeight:15,handleFillColor:"rgba(0,0,0,0)"},e.animationOnClick="off";var r=this._renderChart(e.chart,t,i);E.superclass.render.call(this,e,r.w,r.h)},E.prototype.destroy=function(){E.superclass.destroy.call(this),this._parentChart=null,this._chart=null},E.prototype.getBackgroundChart=function(){return this._chart},E.prototype.isBackgroundRendered=function(){return!1},E.prototype.isLeftAndRightFilterRendered=function(){return!0},E.prototype.HandleKeyDown=function(e){},E.prototype.HandleKeyUp=function(e){};var I=function(e,t,i,r,n,a,o){this.Init(e.getCtx()),this._axisCoord=t,this._availSpace=o.clone(),this._bbox=null,this._dataItemGaps=te.getDataItemGaps(e)*I._MAX_DATA_ITEM_GAP,this._setBarCoords(i,r,n,a)};e.Obj.createSubclass(I,C),I._MIN_BAR_LENGTH_FOR_GAPS=4,I._MAX_DATA_ITEM_GAP=3,I.prototype.getAnimationParams=function(){return[this._baselineCoord,this._endCoord,this._x1,this._x2]},I.prototype.setAnimationParams=function(e,t){this._setBarCoords(e[0],e[1],e[2],e[3])},I.prototype.getPrimaryFill=function(){return this.getFill()},I.prototype.getDisplayAnimation=function(t){var i=this.getAnimationParams();this.setAnimationParams([this._axisCoord,this._axisCoord,0,0]);var r=new e.CustomAnimation(this.getCtx(),this,t);return r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r},I.prototype.getDeleteAnimation=function(t){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new e.CustomAnimation(this.getCtx(),this,t);return r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r},I.prototype.getInsertAnimation=function(t){this.setAlpha(0);var i=this.getAnimationParams();this.setAnimationParams([this._baselineCoord,this._baselineCoord,this._x1,this._x2]);var r=new e.CustomAnimation(this.getCtx(),this,t);return r.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),r},I.prototype._setBarCoords=function(t,i,r,n){var a=this._availSpace.x+this._availSpace.w/2,o=this._availSpace.y+this._availSpace.h/2,s=Math.max(i,t),l=Math.abs(i-t)>=I._MIN_BAR_LENGTH_FOR_GAPS&&this._axisCoord!=t?Math.min(i,t)+this._dataItemGaps:Math.min(i,t),h=360-e.Math.radsToDegrees(Math.max(r,n))+90,u=e.Math.radsToDegrees(Math.abs(n-r));this.setWedgeParams(a,o,s,s,h,u,this._dataItemGaps,l);var g=pe.polarToCartesian(t,r,this._availSpace),d=pe.polarToCartesian(t,n,this._availSpace),p=pe.polarToCartesian(i,r,this._availSpace),c=pe.polarToCartesian(i,n,this._availSpace),_=Math.min(g.x,d.x,p.x,c.x),f=Math.max(g.x,d.x,p.x,c.x),m=Math.min(g.y,d.y,p.y,c.y),v=Math.max(g.y,d.y,p.y,c.y);this._bbox=new e.Rectangle(_,m,f-_,v-m),this._baselineCoord=t,this._endCoord=i,this._x1=r,this._x2=n},I.prototype.getBoundingBox=function(){return this._bbox},I.prototype.getOriginalBarSize=function(){return this._bbox.w};var P=function(e,t,i,r,n,a,o){this.Init(e),this._markerSize=a,this._isInvisible=o,this._drawPath(t,i,r,n)};e.Obj.createSubclass(P,e.Path),P.prototype._drawPath=function(t,i,r,n){var a=Math.atan2(n-i,r-t),o=this._markerSize/2,s=Math.PI/8,l=e.PathUtils.moveTo(t+o*Math.cos(a+s),i+o*Math.sin(a+s))+e.PathUtils.arcTo(o,o,2*(Math.PI-s),1,t+o*Math.cos(a-s),i+o*Math.sin(a-s))+e.PathUtils.lineTo(r-o*Math.cos(a+s),n-o*Math.sin(a+s))+e.PathUtils.arcTo(o,o,2*(Math.PI-s),1,r-o*Math.cos(a-s),n-o*Math.sin(a-s))+e.PathUtils.closePath();this.setCmds(l),this._x1=t,this._y1=i,this._x2=r,this._y2=n},P.prototype.setStyleProperties=function(t,i,r,n,a){this._dataColor=r;var o=e.SelectionEffectUtils.getHoverBorderColor(r);this._isInvisible?(this.setInvisibleFill(),this._hoverStroke=new e.Stroke(o,1,1.5)):(this.setFill(t),this.setStroke(i),this.setHoverStroke(new e.Stroke(n,1,1),new e.Stroke(o,1,3.5)),this.setSelectedStroke(new e.Stroke(n,1,1.5),new e.Stroke(a,1,4.5)),this.setSelectedHoverStroke(new e.Stroke(n,1,1.5),new e.Stroke(o,1,4.5)))},P.prototype.getDataColor=function(){return this._dataColor},P.prototype.showHoverEffect=function(){this._isInvisible?(this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)):P.superclass.showHoverEffect.call(this)},P.prototype.hideHoverEffect=function(){this._isInvisible?(this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?D.SELECTED_STROKE:D.DEFAULT_STROKE)):P.superclass.hideHoverEffect.call(this)},P.prototype.setSelected=function(e){if(this._isInvisible){if(this.IsSelected==e)return;this.IsSelected=e,this.isSelected()?(this.setFill(D.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.DEFAULT_STROKE))}else P.superclass.setSelected.call(this,e)},P.prototype.UpdateSelectionEffect=function(){this._isInvisible||P.superclass.UpdateSelectionEffect.call(this)},P.prototype.getAnimationParams=function(){return[this._x1,this._y1,this._x2,this._y2]},P.prototype.setAnimationParams=function(e){this._drawPath(e[0],e[1],e[2],e[3])},P.prototype.isInvisible=function(){return this._isInvisible},P.prototype.getBoundingBox=function(){return this.getBoundingBox1().getUnion(this.getBoundingBox2())},P.prototype.getBoundingBox1=function(){return new e.Rectangle(this._x1-this._markerSize/2,this._y1-this._markerSize/2,this._markerSize,this._markerSize)},P.prototype.getBoundingBox2=function(){return new e.Rectangle(this._x2-this._markerSize/2,this._y2-this._markerSize/2,this._markerSize,this._markerSize)};var L=function(e,t,i){this.Init(e,t,i)};e.Obj.createSubclass(L,e.Container),L.BEHAVIOR_SNAP="SNAP",L.BEHAVIOR_SMOOTH="SMOOTH",L.BEHAVIOR_AUTO="AUTO",L.TOOLTIP_ID="_dvtDataCursor",L.prototype.Init=function(t,i,r){L.superclass.Init.call(this,t),this._bHoriz=r,this._options=i,this.setMouseEnabled(!1),this.setVisible(!1);var n=i.lineWidth,a=i.lineColor,o=new e.Stroke(a,1,n,!1,e.Stroke.getDefaultDashProps(i.lineStyle,n));if(this._cursorLine=new e.Line(this.getCtx(),0,0,0,0,"dcLine"),this._cursorLine.setStroke(o),this.addChild(this._cursorLine),"off"!=i.markerDisplayed){this._marker=new e.Container(this._context),this._marker.setMouseEnabled(!1),this.addChild(this._marker);var s=i.markerSize,l=new e.SimpleMarker(this._context,e.SimpleMarker.CIRCLE,0,0,s+4*n,s+4*n);l.setSolidFill(a),this._marker.addChild(l);var h=new e.SimpleMarker(this._context,e.SimpleMarker.CIRCLE,0,0,s+2*n,s+2*n);h.setSolidFill("white"),this._marker.addChild(h),this._markerInnerCircle=new e.SimpleMarker(this._context,e.SimpleMarker.CIRCLE,0,0,s,s),this._marker.addChild(this._markerInnerCircle)}},L.prototype.render=function(t,i,r,n,a,o){var s,l=this.isHorizontal(),h=e.Agent.isRightToLeft(this.getCtx());if(null!=a&&""!=a){var u=this.getCtx().getStageAbsolutePosition(),g=this.getCtx().getTooltipManager(L.TOOLTIP_ID);g.showDatatip(i+u.x,r+u.y,a,o,!1),s=g.getTooltipBounds();var d,p,c=this._options.markerSize+4*this._options.lineWidth;l?(d=h?t.x-.75*s.w:t.x+t.w-s.w/4,p=n-s.h/2,!h&&d-i<c?d=i+c:h&&i-(d+s.w)<c&&(d=i-c-s.w)):(d=n-s.w/2,r-((p=t.y-.75*s.h)+s.h)<c&&(p=r-c-s.h)),g.positionTip(d+u.x,p+u.y),(s=g.getTooltipBounds()).x-=u.x,s.y-=u.y}if(l?(this._cursorLine.setTranslateY(n),h?(this._cursorLine.setX1(s?s.x+s.w-1:t.x),this._cursorLine.setX2(t.x+t.w)):(this._cursorLine.setX1(t.x),this._cursorLine.setX2(s?s.x+1:t.x+t.w))):(this._cursorLine.setTranslateX(n),this._cursorLine.setY1(s?s.y+s.h-1:t.y),this._cursorLine.setY2(t.y+t.h)),this._marker){this._marker.setTranslate(i,r);var _=this._options.markerColor;this._markerInnerCircle.setSolidFill(_||o),e.Agent.workaroundFirefoxRepaint(this._marker)}},L.prototype.isHorizontal=function(){return this._bHoriz},L.prototype.getBehavior=function(){return this._behavior?this._behavior:L.BEHAVIOR_AUTO},L.prototype.setBehavior=function(e){this._behavior=e};var R=function(e,t,i,r,n,a,o,s,l){this.Init(e,t,i,r,n,a,o,s,l)};e.Obj.createSubclass(R,e.Path),R.prototype.Init=function(t,i,r,n,a,o,s,l,h){R.superclass.Init.call(this,t.getCtx()),this._chart=t;var u=t.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._funnelWidth=n,this._funnelHeight=a,this._startPercent=o,this._valuePercent=s,this._fillPercent=l,this._3dRatio="on"==u.threeDEffect?1:0,this._gap=h;var g=this._getPath();this._dataColor=te.getColor(this._chart,this._seriesIndex,0),this._backgroundColor=u.backgroundColor?u.backgroundColor:u.funnelBackgroundColor,this.setCmds(g.slice),g.bar&&(this._bar=new e.Path(this.getCtx(),g.bar),this.addChild(this._bar),this._bar.setMouseEnabled(!1)),this._setColorProperties(g.sliceBounds),this._label=this._getSliceLabel(g.sliceBounds,g.barBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))},R._FUNNEL_3D_WIDTH_RATIO=.08,R._FUNNEL_ANGLE_2D=36,R._FUNNEL_RATIO=1/3,R._BORDER_COLOR="#FFFFFF",R._MIN_CHARS_DATA_LABEL=3,R._LINE_FRACTION=2/3,R._AREA_FRACTION=.41,R._HEIGHT_FRACTION=.28,R._LINE_FRACTION_2=.4,R._AREA_FRACTION_2=.8,R._HEIGHT_FRACTION_2=.7,R.prototype._getPath=function(){var t=e.Agent.isRightToLeft(this.getCtx()),i=J.getSeriesCount(this._chart),r=(this._numDrawnSeries+1)*this._gap,n=e.Math.degreesToRads(R._FUNNEL_ANGLE_2D-2*this._3dRatio),a=this._funnelWidth-i*this._gap,o=a/Math.sin(e.Math.degreesToRads(R._FUNNEL_ANGLE_2D)),s=this._funnelHeight/Math.sin(n),l=this._3dRatio*this._funnelWidth/this._funnelHeight*R._FUNNEL_3D_WIDTH_RATIO;l<1e-5&&(l=0);var h,u,g,d,p,c,_,f,m,v,y,S,C=this._funnelHeight,A=this._funnelHeight*R._FUNNEL_RATIO;this._startPercent<R._AREA_FRACTION?(h=this._startPercent,g=C,p=this._funnelHeight*R._LINE_FRACTION,_=R._AREA_FRACTION,m=a*R._HEIGHT_FRACTION,y=a*(1-R._HEIGHT_FRACTION)):this._startPercent<R._AREA_FRACTION_2?(h=this._startPercent-R._AREA_FRACTION,g=this._funnelHeight*R._LINE_FRACTION,p=this._funnelHeight*R._LINE_FRACTION_2,_=R._AREA_FRACTION_2-R._AREA_FRACTION,m=a*(R._HEIGHT_FRACTION_2-R._HEIGHT_FRACTION),y=a*(1-R._HEIGHT_FRACTION_2)):(h=this._startPercent-R._AREA_FRACTION_2,g=this._funnelHeight*R._LINE_FRACTION_2,p=A,_=1-R._AREA_FRACTION_2,m=a*(1-R._HEIGHT_FRACTION_2),y=0),this._startPercent+this._valuePercent<R._AREA_FRACTION?(d=C,c=this._funnelHeight*R._LINE_FRACTION,u=this._startPercent+this._valuePercent,f=R._AREA_FRACTION,v=a*R._HEIGHT_FRACTION,S=a*(1-R._HEIGHT_FRACTION)):this._startPercent+this._valuePercent<R._AREA_FRACTION_2?(d=this._funnelHeight*R._LINE_FRACTION,c=this._funnelHeight*R._LINE_FRACTION_2,u=this._startPercent+this._valuePercent-R._AREA_FRACTION,f=R._AREA_FRACTION_2-R._AREA_FRACTION,v=a*(R._HEIGHT_FRACTION_2-R._HEIGHT_FRACTION),S=a*(1-R._HEIGHT_FRACTION_2)):(d=this._funnelHeight*R._LINE_FRACTION_2,c=A,u=this._startPercent+this._valuePercent-R._AREA_FRACTION_2,f=1-R._AREA_FRACTION_2,v=a*(1-R._HEIGHT_FRACTION_2),S=0);var b,x,M,O=Math.sqrt((_-h)/_*g*g+h/_*p*p),T=Math.sqrt((f-u)/f*d*d+u/f*c*c),w=.98*Math.asin(((O-p)*m/(g-p)+y)/o),D=.98*Math.asin(((T-c)*v/(d-c)+S)/o),E=(1+R._FUNNEL_RATIO)/2*this._funnelHeight+s,I=(1-R._FUNNEL_RATIO)/2*this._funnelHeight-s;t?(b=[o*Math.sin(w)+r,E-s*Math.cos(w),o*Math.sin(D)+r,E-s*Math.cos(D),o*Math.sin(D)+r,I+s*Math.cos(D),o*Math.sin(w)+r,I+s*Math.cos(w)],x=0,M=1):(b=[this._funnelWidth-r-o*Math.sin(w),E-s*Math.cos(w),this._funnelWidth-r-o*Math.sin(D),E-s*Math.cos(D),this._funnelWidth-r-o*Math.sin(D),I+s*Math.cos(D),this._funnelWidth-r-o*Math.sin(w),I+s*Math.cos(w)],x=1,M=0);var P=e.PathUtils.moveTo(b[0],b[1]),L=null;P+=e.PathUtils.arcTo(l*(b[1]-b[7])/2,(b[1]-b[7])/2,Math.PI,M,b[6],b[7]),P+=e.PathUtils.arcTo(l*(b[1]-b[7])/2,(b[1]-b[7])/2,Math.PI,M,b[0],b[1]),P+=e.PathUtils.arcTo(o,s,n,x,b[2],b[3]),P+=e.PathUtils.arcTo(l*(b[3]-b[5])/2,(b[3]-b[5])/2,Math.PI,M,b[4],b[5]),P+=e.PathUtils.arcTo(o,s,n,x,b[6],b[7]);var B=new e.Rectangle(Math.min(b[0],b[2]),b[5],Math.abs(b[0]-b[2]),Math.abs(b[3]-b[5]));if(null!=this._fillPercent){var k=Math.max(Math.min(this._fillPercent,1),0),z=t?-k*Math.PI:k*Math.PI;L=e.PathUtils.moveTo(b[0],b[1]),L+=e.PathUtils.arcTo(o,s,n,x,b[2],b[3]),L+=e.PathUtils.arcTo(l*(b[3]-b[5])/2,(b[3]-b[5])/2,z,M,b[2]+l*(b[3]-b[5])/2*Math.sin(z),(b[5]+b[3])/2+(b[3]-b[5])/2*Math.cos(z)),this._fillPercent>.95?L+=e.PathUtils.arcTo(o,s,n,x,b[6],b[1]+k*(b[7]-b[1])):this._fillPercent<.05?L+=e.PathUtils.arcTo(o,s,n,M,b[6],b[1]+k*(b[7]-b[1])):L+=e.PathUtils.lineTo(b[6]+l*(b[1]-b[7])/2*Math.sin(z),(b[7]+b[1])/2+(b[1]-b[7])/2*Math.cos(z)),L+=e.PathUtils.arcTo(l*(b[1]-b[7])/2,(b[1]-b[7])/2,z,x,b[0],b[1]),L+=e.PathUtils.closePath();var H=new e.Rectangle(Math.min(b[0],b[2]),b[5]+Math.abs(b[3]-b[5])*(1-k),Math.abs(b[0]-b[2]),Math.abs(b[3]-b[5])*k)}return{slice:P,bar:L,sliceBounds:B,barBounds:L?H:B}},R.prototype._getSliceLabel=function(t,i){var r=J.getDataLabel(this._chart,this._seriesIndex,0);if(r||(r=J.getSeriesLabel(this._chart,this._seriesIndex)),r&&"none"!=te.getDataLabelPosition(this._chart,this._seriesIndex,0)){var n=new e.MultilineText(this.getCtx(),r,0,0),a=null!=te.getPattern(this._chart,this._seriesIndex,0),o=[this._chart.getOptions().styleDefaults.dataLabelStyle,new e.CSSStyle(J.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],s=e.CSSStyle.mergeStyles(o);if(n.setCSSStyle(s),e.TextUtils.fitText(n,t.h-this._3dRatio*(.8-this._valuePercent)*50,t.w,this,R._MIN_CHARS_DATA_LABEL)){var l=n.getDimensions(),h=this._getLabelPosition(t);if(a){var u=.15*l.h,g=e.Agent.isRightToLeft(this.getCtx())?.5:-.5,d=e.PathUtils.roundedRectangle(l.x-u,l.y,l.w+2*u,l.h,2,2,2,2),p=new e.Path(this.getCtx(),d);p.setSolidFill("#FFFFFF",.9),h=h.translate(g*l.h,-g*l.w),p.setMatrix(h),this.addChild(p)}var c=a?"#000000":i.containsPoint(t.x,t.y+(t.h-l.w)/2)?e.ColorUtils.getContrastingTextColor(this._dataColor):e.ColorUtils.getContrastingTextColor(this._backgroundColor);return s.getStyle("color")&&!e.Agent.isHighContrast()||n.setCSSStyle(s.setStyle("color",c)),n.setMatrix(this._getLabelPosition(t)),n.alignCenter(),n.alignMiddle(),n}}},R.prototype._getLabelPosition=function(t){var i=this._3dRatio*(t.h*this._funnelWidth/this._funnelHeight*R._FUNNEL_3D_WIDTH_RATIO/2),r=new e.Matrix;return r=e.Agent.isRightToLeft(this.getCtx())?(r=r.rotate(Math.PI/2)).translate(t.x+t.w/2-i,t.y+t.h/2):(r=r.rotate(3*Math.PI/2)).translate(t.x+t.w/2+i,t.y+t.h/2)},R.prototype._setColorProperties=function(t){var i=ee.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,t),r=te.getBorderColor(this._chart,this._seriesIndex,0);null==r&&this._3dRatio>0&&(r=R._BORDER_COLOR);var n=te.getBorderWidth(this._chart,this._seriesIndex,0),a=e.SelectionEffectUtils.getHoverBorderColor(this._dataColor),o=ee.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._backgroundColor,t,!0);this._bar?(this.setFill(o),this._bar.setFill(i),this._bar.setStyle(te.getStyle(this._chart,this._seriesIndex,0)),this._bar.setClassName(te.getClassName(this._chart,this._seriesIndex,0))):(this.setFill(i),this.setStyle(te.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(te.getClassName(this._chart,this._seriesIndex,0))),r&&this.setSolidStroke(r,null,n),this.OriginalStroke=this.getStroke();var s=null!=this._bar?this._bar:this;if(s.setHoverStroke(new e.Stroke(a,1,2)),this._chart.isSelectionSupported()){var l=te.getSelectedInnerColor(this._chart),h=te.getSelectedOuterColor(this._chart)?te.getSelectedOuterColor(this._chart):this._dataColor;s.setSelectedStroke(new e.Stroke(l,1,1.5),new e.Stroke(h,1,4.5)),s.setSelectedHoverStroke(new e.Stroke(l,1,1.5),new e.Stroke(a,1,4.5)),this.setCursor(e.SelectionEffectUtils.getSelectingCursor())}},R.prototype.getAnimationParams=function(){return[this._startPercent,this._valuePercent,this._fillPercent,this.getAlpha(),this._3dRatio]},R.prototype.setAnimationParams=function(e){this._startPercent=e[0],this._valuePercent=e[1],this._fillPercent=null!=this._fillPercent?e[2]:null,this.setAlpha(e[3]),this._3dRatio=e[4];var t=this._getPath();this.setCmds(t.slice),t.bar&&this._bar&&this._bar.setCmds(t.bar),this._label&&this._label.setMatrix(this._getLabelPosition(t.sliceBounds))},R.prototype.setSelected=function(e){if(null!=this._bar){if(this.IsSelected==e)return;this.IsSelected=e,this._bar.setSelected(e)}else R.superclass.setSelected.call(this,e);var t=this.getDimensions(),i=null!=this._bar?this._bar:this,r=t.w;e?(i.setScaleX((r-3)/r),i.setTranslateX(Math.ceil(1.5)+3/r*t.x)):(i.setScaleX(1),i.setTranslateX(0))},R.prototype.showHoverEffect=function(){null!=this._bar?this._bar.showHoverEffect():R.superclass.showHoverEffect.call(this)},R.prototype.hideHoverEffect=function(){null!=this._bar?this._bar.hideHoverEffect():R.superclass.hideHoverEffect.call(this)},R.prototype.copyShape=function(){return new R(this._chart,this._seriesIndex,this._numDrawnSeries,this._funnelWidth,this._funnelHeight,this._startPercent,this._valuePercent,this._fillPercent,this._gap)};var B=function(e,t,i,r,n,a,o,s){this.Init(e,t,i,r,n,a,o,s)};e.Obj.createSubclass(B,e.Path),B.prototype.Init=function(t,i,r,n,a,o,s,l){B.superclass.Init.call(this,t.getCtx()),this._chart=t;var h=t.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._pyramidWidth=n,this._pyramidHeight=a,this._startPercent=o,this._valuePercent=s,this._3dRatio="on"==h.threeDEffect?1:0,this._gap=l;var u=this._getPath();this._dataColor=te.getColor(this._chart,this._seriesIndex,0),this._3dRatio>0?(this.setCmds(u.threeDPathTop),this._threeDPathSide=new e.Path(this.getCtx(),u.threeDPathSide),this._mainFace=new e.Path(this.getCtx(),u.slice),this.addChild(this._threeDPathSide),this.addChild(this._mainFace)):this.setCmds(u.slice),this._setColorProperties(u.sliceBounds),this._label=this._getSliceLabel(u.sliceBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))},B._BORDER_COLOR="#FFFFFF",B._MIN_CHARS_DATA_LABEL=3,B._SLICE_LABEL_HORIZONTAL_PADDING=4,B._3D_WIDTH_FACTOR=.2,B.prototype._getPath=function(){var t,i,r,n,a,o,s=e.Agent.isRightToLeft(this.getCtx()),l=J.getSeriesCount(this._chart),h=(l-this._numDrawnSeries-1)*this._gap,u=this._3dRatio*B._3D_WIDTH_FACTOR*.98*this._pyramidWidth,g=this._chart.getOptions(),d=Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent)),p=this._startPercent+this._valuePercent>=1?0:Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent-this._valuePercent)),c=.98*(1-this._3dRatio*B._3D_WIDTH_FACTOR)*this._pyramidWidth*(p/this._pyramidHeight),_=0==this._numDrawnSeries?d:d-this._gap,f=.98*(1-this._3dRatio*B._3D_WIDTH_FACTOR)*this._pyramidWidth*(_/this._pyramidHeight);if(s?(i=[this._pyramidWidth-.5*this._pyramidWidth+u/2-c/2,h+p],n=[this._pyramidWidth-.5*this._pyramidWidth+u/2-f/2,h+d],r=[this._pyramidWidth-.5*this._pyramidWidth+u/2+f/2,h+d],t=[this._pyramidWidth-.5*this._pyramidWidth+u/2+c/2,h+p]):(t=[.5*this._pyramidWidth-u/2-c/2,h+p],r=[.5*this._pyramidWidth-u/2-f/2,h+d],n=[.5*this._pyramidWidth-u/2+f/2,h+d],i=[.5*this._pyramidWidth-u/2+c/2,h+p]),"on"==g.styleDefaults.threeDEffect){var m=this._3dRatio*B._3D_WIDTH_FACTOR*f*Math.sqrt(2)/2,v=this._3dRatio*B._3D_WIDTH_FACTOR*c*Math.sqrt(2)/2;a=e.PathUtils.moveTo(i[0],i[1]),a+=e.PathUtils.lineTo(i[0]+(s?-1:1)*Math.max(v,1),i[1]-Math.max(v,.5)),a+=e.PathUtils.lineTo(t[0]+(s?-1:1)*Math.max(v,1),t[1]-Math.max(v,.5)),a+=e.PathUtils.lineTo(t[0],t[1]),a+=e.PathUtils.closePath(),o=e.PathUtils.moveTo(i[0],i[1]),o+=e.PathUtils.lineTo(i[0]+(s?-1:1)*Math.max(v,1),i[1]-Math.max(v,.5)),o+=e.PathUtils.lineTo(n[0]+(s?-1:1)*m,n[1]-m),o+=e.PathUtils.lineTo(n[0],n[1]),o+=e.PathUtils.closePath()}var y=e.PathUtils.moveTo(i[0],i[1]);y+=e.PathUtils.lineTo(n[0],n[1]),y+=e.PathUtils.lineTo(r[0],r[1]),y+=e.PathUtils.lineTo(t[0],t[1]),y+=e.PathUtils.closePath();var S=c/f,C=.5*Math.abs(t[1]-r[1])*(1+S),A=.5*Math.abs(n[0]-r[0])*(1+S)-B._SLICE_LABEL_HORIZONTAL_PADDING,b=r[1]-C,x=r[0]+(f-A)/2*(s?-1:1);return{slice:y,sliceBounds:new e.Rectangle(x,b,A,C),threeDPathTop:a,threeDPathSide:o}},B.prototype._getSliceLabel=function(t){var i=J.getDataLabel(this._chart,this._seriesIndex,0);if(i||(i=J.getSeriesLabel(this._chart,this._seriesIndex)),i&&"none"!=te.getDataLabelPosition(this._chart,this._seriesIndex,0)){var r=new e.MultilineText(this.getCtx(),i,0,0),n=null!=te.getPattern(this._chart,this._seriesIndex,0),a=[this._chart.getOptions().styleDefaults.dataLabelStyle,new e.CSSStyle(J.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],o=e.CSSStyle.mergeStyles(a);if(r.setCSSStyle(o),e.TextUtils.fitText(r,t.w,t.h,this,B._MIN_CHARS_DATA_LABEL)){var s=r.getDimensions(),l=this._getLabelPosition(t);if(n){var h=.15*s.h,u=e.PathUtils.roundedRectangle(s.x-h,s.y,s.w+2*h,s.h,2,2,2,2),g=new e.Path(this.getCtx(),u);g.setSolidFill("#FFFFFF",.9),l=l.translate(-.5*s.w,-.5*s.h),g.setMatrix(l),this.addChild(g)}var d=n?"#000000":t.containsPoint(t.x+(t.w-s.w)/2,t.y)?e.ColorUtils.getContrastingTextColor(this._dataColor):e.ColorUtils.getContrastingTextColor(null);return o.getStyle("color")&&!e.Agent.isHighContrast()||r.setCSSStyle(o.setStyle("color",d)),r.setMatrix(this._getLabelPosition(t)),r.alignCenter(),r.alignMiddle(),r}}},B.prototype._getLabelPosition=function(t){var i=new e.Matrix;return i=e.Agent.isRightToLeft(this.getCtx())?i.translate(t.x-t.w/2,t.y+t.h/2):i.translate(t.x+t.w/2,t.y+t.h/2)},B.prototype._setColorProperties=function(t){
var i=ee.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,t),r=te.getBorderColor(this._chart,this._seriesIndex,0);null==r&&this._3dRatio>0&&(r=B._BORDER_COLOR);var n=te.getBorderWidth(this._chart,this._seriesIndex,0),a=e.SelectionEffectUtils.getHoverBorderColor(this._dataColor);if(this._3dRatio>0){var o=!i.getPattern&&!i.getAlphas;this._mainFace.setFill(i),this._mainFace.setStyle(te.getStyle(this._chart,this._seriesIndex,0)),this._mainFace.setClassName(te.getClassName(this._chart,this._seriesIndex,0)),this._threeDPathSide.setFill(o?new e.SolidFill(e.ColorUtils.getDarker(i.getColor(),.3)):i),this._threeDPathSide.setStyle(te.getStyle(this._chart,this._seriesIndex,0)),this._threeDPathSide.setClassName(te.getClassName(this._chart,this._seriesIndex,0)),this.setFill(o?new e.SolidFill(e.ColorUtils.getDarker(i.getColor(),.3)):i),this.setStyle(te.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(te.getClassName(this._chart,this._seriesIndex,0))}else this.setFill(i),this.setStyle(te.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(te.getClassName(this._chart,this._seriesIndex,0));if(r&&(this.setSolidStroke(r,null,n),this._3dRatio>0&&(this._threeDPathSide.setSolidStroke(r,null,n),this._mainFace.setSolidStroke(r,null,n))),this.OriginalStroke=this.getStroke(),this.setHoverStroke(new e.Stroke(a,1,2)),this._3dRatio>0&&(this._threeDPathSide.setHoverStroke(new e.Stroke(a,1,2)),this._mainFace.setHoverStroke(new e.Stroke(a,1,2))),this._chart.isSelectionSupported()){var s=te.getSelectedInnerColor(this._chart),l=te.getSelectedOuterColor(this._chart)?te.getSelectedOuterColor(this._chart):this._dataColor;this._3dRatio>0?(this._mainFace.setSelectedStroke(new e.Stroke(s,1,1.5),new e.Stroke(l,1,4.5)),this._mainFace.setSelectedHoverStroke(new e.Stroke(s,1,1.5),new e.Stroke(a,1,4.5)),this._mainFace.setCursor(e.SelectionEffectUtils.getSelectingCursor()),this._threeDPathSide.setCursor(e.SelectionEffectUtils.getSelectingCursor()),this.setCursor(e.SelectionEffectUtils.getSelectingCursor())):(this.setSelectedStroke(new e.Stroke(s,1,1.5),new e.Stroke(l,1,4.5)),this.setSelectedHoverStroke(new e.Stroke(s,1,1.5),new e.Stroke(a,1,4.5)),this.setCursor(e.SelectionEffectUtils.getSelectingCursor()))}},B.prototype.getAnimationParams=function(){return[this._startPercent,this._valuePercent,this.getAlpha(),this._3dRatio]},B.prototype.setAnimationParams=function(e){this._startPercent=e[0],this._valuePercent=e[1],this.setAlpha(e[2]),this._3dRatio=e[3];var t=this._getPath();this._threeDPathSide&&this._mainFace?(this.setCmds(t.threeDPathTop),this._threeDPathSide.setCmds(t.threeDPathSide),this._mainFace.setCmds(t.slice)):this.setCmds(t.slice),this._label&&this._label.setMatrix(this._getLabelPosition(t.sliceBounds))},B.prototype.setSelected=function(e){if(this._3dRatio>0)if(this._mainFace.setSelected(e),e){var t=this.getDimensions(),i=t.w,r=t.h,n=(i-3)/i,a=(r-5)/r;this._mainFace.setScaleX(n),this._mainFace.setScaleY(a),this._mainFace.setTranslateX(Math.ceil(1.5)+3/i*t.x),this._mainFace.setTranslateY(Math.ceil(2.5)+5/r*t.y)}else this._mainFace.setScaleX(1),this._mainFace.setScaleY(1),this._mainFace.setTranslateX(0),this._mainFace.setTranslateY(0);else B.superclass.setSelected.call(this,e)},B.prototype.showHoverEffect=function(){B.superclass.showHoverEffect.call(this),this._3dRatio>0&&(this._threeDPathSide.showHoverEffect(),this._mainFace.showHoverEffect())},B.prototype.hideHoverEffect=function(){B.superclass.hideHoverEffect.call(this),this._3dRatio>0&&(this._threeDPathSide.hideHoverEffect(),this._mainFace.hideHoverEffect())},B.prototype.copyShape=function(){return new B(this._chart,this._seriesIndex,this._numDrawnSeries,this._pyramidWidth,this._pyramidHeight,this._startPercent,this._valuePercent,this._gap)},B.prototype.getPrimaryFill=function(){return this._mainFace?this._mainFace.getFill():this.getFill()};var k=function(e,t,i,r){this.Init(e,t,i,r)};k._THREED_TILT=.59,k._THREED_DEPTH=.1,k._RADIUS=.45,k._RADIUS_LABELS=.38,k._MIN_ARC_LENGTH=1.5,e.Obj.createSubclass(k,e.Container),k.prototype.Init=function(t,i,r,n){k.superclass.Init.call(this,t.getCtx()),this.chart=t,this._options=t.getOptions(),this._frame=i.clone(),t.pieChart=this;for(var a=this.getLabelPosition(),o=J.getSeriesCount(t),s=0;s<o;s++){var l=J.getDataItem(t,s,0);!l||"center"!=a&&"none"!=a||"outsideSlice"!=l.labelPosition||(a="outsideSlice")}this._center=new e.Point(i.x+Math.floor(i.w/2),i.y+Math.floor(i.h/2));var h="center"==a||"none"==a?k._RADIUS:k._RADIUS_LABELS;this._radiusX=Math.floor(Math.min(i.w,i.h)*h),this._radiusY=this._radiusX,this._depth=0,this._anchorOffset=90,this.is3D()&&(this._depth=i.h*k._THREED_DEPTH,this._center.y-=Math.floor(this._depth/2),this._radiusY*=k._THREED_TILT),this._slices=this._createSlices(),this._centerLabel=null,this._shapesContainer=new e.Container(this.getCtx()),this._numFrontObjs=0,this._numSelectedObjsInFront=0},k.prototype.getOptions=function(){return this._options},k.prototype.highlight=function(t){e.CategoryRolloverHandler.highlight(t,this._slices,"any"==this.getOptions().highlightMatch)},k.prototype._createSlices=function(){for(var t,i,r=[],n=oe.getRenderedSeriesIndices(this.chart),a=oe.getOtherValue(this.chart),o=0;o<n.length;o++)if(i=n[o],te.isDataItemRendered(this.chart,i)){var s=(t=new z(this,i)).getValue();null==s||s<=0||r.push(t)}var l=te.getHiddenCategories(this.chart).indexOf(oe.OTHER_SLICE_SERIES_ID)>=0;if(a>0&&!l){var h=new z(this);"ascending"==this.chart.getOptions().sorting?r.unshift(h):r.push(h)}return e.Agent.isRightToLeft(this.getCtx())&&r.reverse(),r},k.prototype.setInitialSelection=function(){var e=this.chart.getSelectionHandler();if(e){for(var t=J.getInitialSelection(this.chart),i=[],r=0;r<t.length;r++)for(var n=0;n<this._slices.length;n++){var a=this._slices[n].getId();null!=a&&(null!=t[r].id&&a.id==t[r].id||a.series==t[r].series&&a.group==t[r].group)&&i.push(a)}if(oe.isOtherSliceSelected(this.chart,t)){var o=oe.getOtherSliceId(this.chart);i.push(o)}e.processInitialSelections(i,this._slices)}},k.prototype.render=function(){Q.addPlotAreaDnDBackground(this.chart,this,this._frame,!0),this.contains(this._shapesContainer)||(this._shapesContainer||(this._shapesContainer=new e.Container(this.getCtx())),this.addChild(this._shapesContainer)),k._layoutSlices(this._slices,this._anchorOffset);for(var t=2*Math.PI*this.getRadiusX(),i=0,r={},n=this.chart.getOptionsCache().getFromCache("hasLargeSeriesCount"),a=0;a<this._slices.length;a++){if(n){var o=this._slices[a].getAngleExtent(),s=o/360*t,l=(this._slices[a].getAngleStart()+o)/360*t;if(s<k._MIN_ARC_LENGTH&&Math.abs(i-l)<k._MIN_ARC_LENGTH){r[this._slices[a].getSeriesIndex()]=!0;continue}i=l}this._slices[a].preRender()}var h=k._orderSlicesForRendering(this._slices);for(this._duringDisplayAnim||(he.createPieCenter(this),he.layoutLabelsAndFeelers(this)),a=0;a<h.length;a++)r[h[a].getSeriesIndex()]||h[a].render(this._duringDisplayAnim);"safari"!==e.Agent.browser&&e.Agent.browser,this.setInitialSelection(),this.highlight(te.getHighlightedCategories(this.chart))},k.prototype.getTotalValue=function(){for(var e=0,t=0;t<this._slices.length;t++){var i=this._slices[t].getValue();i>=0&&(e+=i)}return e},k._layoutSlices=function(e,t){var i,r,n=0,a=e?e.length:0;t>360&&(t-=360),t<0&&(t+=360);var o=0;a>0&&(o=e[0].getPieChart().getTotalValue());for(var s=0;s<a;s++){var l=(i=e[s]).getValue();(r=t-(n=3.6*(l==o?100:0==o?0:Math.min(l/o*100,99.99))))<0&&(r+=360),i.setAngleStart(r),i.setAngleExtent(n),t=i.getAngleStart()}},k._orderSlicesForRendering=function(e){for(var t,i,r,n,a=[],o=e?e.length:0,s=-1,l=0;l<o;l++)if((r=(i=(t=e[l]).getAngleStart())+t.getAngleExtent())>360&&(r-=360),r<0&&(r+=360),90==r||i<90&&r>90){s=l,n=r-90;break}var h=[];for(l=s;l<o;l++)h.push(e[l]);for(l=0;l<s;l++)h.push(e[l]);var u=0,g=0,d=180+n;for(l=0;l<o;l++)if(t=h[l]){if(u+t.getAngleExtent()>d){g=l;break}a.push(t),u+=t.getAngleExtent()}for(l=o-1;l>=g;l--)(t=h[l])&&a.push(t);return a},k.prototype.is3D=function(){return"on"==this._options.styleDefaults.threeDEffect},k.prototype.__calcMaxExplodeDistance=function(){var e=.5/k._RADIUS-1;return this._radiusX*e},k.prototype.getAnimationDuration=function(){return te.getAnimationDuration(this.chart)},k.prototype.getDisplayAnimation=function(){this._duringDisplayAnim=!0;var t=new e.DataAnimationHandler(this.getCtx(),this),i=this.getAnimationDuration(),r=z.createFillerSlice(this,this.getTotalValue());this._slices.push(r);var n=new e.CustomAnimation(this.getCtx(),r,i);n.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,r,r.GetAnimationParams,r.SetAnimationParams,r.getDeletedAnimationParams()),n.setOnEnd(r._removeDeletedSlice,r),t.add(n,0);for(var a=0;a<this._slices.length-1;a++)this._slices[a].animateInsert(t);var o=new e.CustomAnimation(this.getCtx(),this,i);o.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,this._getAnimationParams()),t.add(o,0);var s=[];for(a=0;a<this._slices.length;a++)s=s.concat(this._slices[a].getLabelAndFeeler());var l=new e.AnimFadeIn(this._context,s,i);t.add(l,0),this._setAnimationParams();var h=t.getAnimation(!0);return h.setOnEnd(this._onEnd,this),h},k.prototype._onEnd=function(){this._duringDisplayAnim=!1,this._setAnimationParams()},k.prototype.getCenter=function(){return this._center},k.prototype.getId=function(){return"chart/pie"},k.prototype.getInnerRadius=function(){return this.is3D()?0:this._options.styleDefaults.pieInnerRadius*Math.min(this._radiusX,this._radiusY)*.95},k.prototype.__getFrame=function(){return this._frame},k.prototype.getRadiusX=function(){return this._radiusX},k.prototype.getRadiusY=function(){return this._radiusY},k.prototype.getDepth=function(){return this._depth},k.prototype.getSliceDisplayable=function(e){var t=oe.getSliceBySeriesIndex(this.chart,e);return t?t.getTopDisplayable():null},k.prototype.__getShapesContainer=function(){return this._shapesContainer},k.prototype.__getSlices=function(){return this._slices},k.prototype.animateUpdate=function(t,i){var r=new e.DataAnimationHandler(this.getCtx(),this);r.constructAnimation(i.__getSlices(),this.__getSlices());var n=r.getAnimation(!0),a=new e.CustomAnimation(this.getCtx(),this,this.getAnimationDuration());a.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,this._getAnimationParams());var o=new e.ParallelPlayable(this.getCtx(),n,a);o.setOnEnd(this._setAnimationParams,this),t.add(o,0),this._setAnimationParams([i.getDepth(),i.getRadiusY(),i.getCenter().y])},k.prototype.animateInsert=function(e){},k.prototype.animateDelete=function(e,t){},k.prototype._getAnimationParams=function(){return[this._depth,this._radiusY,this._center.y]},k.prototype._setAnimationParams=function(e){this.removeChildren(),this._shapesContainer&&this._shapesContainer.destroy(),this._shapesContainer=null,e&&(this._depth=e[0],this._radiusY=e[1],this._center.y=e[2]),this.render()},k.prototype.bringToFrontOfSelection=function(e){var t=e.getPieChart()._shapesContainer;if(t){var i=t.getNumChildren();if(i-this._numFrontObjs>1){t.removeChild(e._topSurface[0]);var r=i-this._numFrontObjs-1;t.addChildAt(e._topSurface[0],r)}}},k.prototype.pushToBackOfSelection=function(e){for(var t=this._slices.length,i=0,r=0;r<t;r++)this._slices[r].isSelected()&&i++;this._numSelectedObjsInFront=i;var n=e.getPieChart()._shapesContainer;if(n){var a=n.getNumChildren()-this._numFrontObjs-1-this._numSelectedObjsInFront;a>=0&&(n.removeChild(e._topSurface[0]),n.addChildAt(e._topSurface[0],a))}},k.prototype.getLabelPosition=function(){return k.parseLabelPosition(this._options.styleDefaults.dataLabelPosition)},k.prototype.getSeriesLabelPosition=function(e){var t=this.getLabelPosition(),i=J.getDataItem(this.chart,e,0);return i&&i.labelPosition&&(t=i.labelPosition),k.parseLabelPosition(t)},k.parseLabelPosition=function(e){return"center"==e||"inside"==e?"center":"outsideSlice"==e||"outside"==e?"outsideSlice":"none"==e?"none":"auto"},k.prototype.getSkin=function(){return this._options.skin},k.prototype.setCenterLabel=function(e){this._centerLabel=e},k.prototype.getCenterLabel=function(){return this._centerLabel};var z=function(e,t){this.Init(e,t)};e.Obj.createSubclass(z,e.Obj),z.prototype.Init=function(e,t){this._pieChart=e,this._chart=e.chart,this._angleStart=0,this._angleExtent=0,this._topSurface=null,this._leftSurface=null,this._rightSurface=null,this._crustSurface=null,this._explodeOffsetX=0,this._explodeOffsetY=0,this._sliceLabel=null,this._sliceLabelString=null,this._hasFeeler=!1,this._feelerRad=null,this._feelerHoriz=null,this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._selected=!1,this._selecting=!1,this._centerX=this._pieChart.getCenter().x,this._centerY=this._pieChart.getCenter().y,this._radiusX=this._pieChart.getRadiusX(),this._radiusY=this._pieChart.getRadiusY(),this._depth=this._pieChart.getDepth();var i=this._chart.getOptions();if(null!=t){var r=J.getDataItem(this._chart,t,0);this._value=J.getValue(this._chart,t,0),this._explode=oe.getSliceExplode(this._chart,t),this._fillColor=te.getColor(this._chart,t,0),this._fillPattern=te.getPattern(this._chart,t,0),this._strokeColor=te.getBorderColor(this._chart,t),this._borderWidth=te.getBorderWidth(this._chart,t),this._customLabel=r?r.label:null,this._seriesLabel=J.getSeries(this._chart,t),this._drillable=Q.isDataItemDrillable(this._chart,t,0),this._id=oe.getSliceId(this._chart,t),this._seriesIndex=t,this._categories=J.getCategories(this._chart,t,0)}else this._value=oe.getOtherValue(this._chart),this._explode=0,this._fillColor=i.styleDefaults.otherColor,this._fillPattern=null,this._strokeColor=i.styleDefaults.borderColor,this._borderWidth=i.styleDefaults.borderWidth,this._customLabel=null,this._seriesLabel=i.translations.labelOther,this._drillable=!1,this._id=oe.getOtherSliceId(this._chart)},z.prototype.getPieChart=function(){return this._pieChart},z.prototype.render=function(t){for(var i=z._sortPieSurfaces(this._topSurface,this._leftSurface,this._rightSurface,this._crustSurface,this._angleStart,this._angleExtent),r=i.length,n=0;n<r;n++)for(var a=i[n],o=a.length,s=0;s<o;s++)this._pieChart.__getShapesContainer().addChild(a[s]),a[s].render&&a[s].render();if(this._sliceLabel&&(this._pieChart.addChild(this._sliceLabel),se.associate(this,[this._sliceLabel]),t?(this._pieChart.addChild(this._feelerRad),this._pieChart.addChild(this._feelerHoriz)):this._renderOutsideFeeler()),this._explodeSlice(),this._drillable||this._pieChart.chart.isSelectionSupported()){var l=this.getDisplayables();for(n=0;n<l.length;n++)l[n].setCursor(e.SelectionEffectUtils.getSelectingCursor())}var h=this.getTopDisplayable();h&&(h.setAriaRole("img"),this._updateAriaLabel())},z.prototype._feelerFromPts=function(t,i){var r=new e.Line(this._pieChart.getCtx(),t.x,t.y,i.x,i.y),n=this._pieChart.getOptions().styleDefaults.pieFeelerColor,a=new e.Stroke(n);return r.setStroke(a),this._pieChart.addChild(r),r},z.prototype._renderOutsideFeeler=function(){if(this._hasFeeler){var e=this._feelerFromPts(this._outsideFeelerStart,this._outsideFeelerMid),t=this._feelerFromPts(this._outsideFeelerMid,this._outsideFeelerEnd);this._feelerRad=e,this._feelerHoriz=t}},z.prototype.preRender=function(){var t,i=this._bFillerSlice?"color":te.getSeriesEffect(this._chart),r=this.getFillColor(),n=this.getFillPattern();if("pattern"==i||null!=n)t=new e.PatternFill(n,r),i="pattern";else if("gradient"==i){var a=this._pieChart.is3D()?"3D":"2D",o=se.getGradientColors(e.ColorUtils.getRGB(r),a),s=se.getGradientAlphas(e.ColorUtils.getAlpha(r),a),l=[Math.floor(this._centerX-this._radiusX),Math.floor(this._centerY-this._radiusY),Math.ceil(2*this._radiusX),Math.ceil(2*this._radiusY)];t=new e.LinearGradientFill(270,o,s,[0,1],l)}else t=new e.SolidFill(r);if(this._topSurface=se.createTopSurface(this,t),this._depth>0||this._radiusX!=this._radiusY){var h="gradient"==i,u=new e.SolidFill(e.ColorUtils.getDarker(r,.4)),g=h?se.generateLateralGradientFill(this,se.SIDE):u,d=h?se.generateLateralGradientFill(this,se.CRUST):u;this._leftSurface=se.createLateralSurface(this,se.SURFACE_LEFT,g),this._rightSurface=se.createLateralSurface(this,se.SURFACE_RIGHT,g),this._crustSurface=se.createLateralSurface(this,se.SURFACE_CRUST,d)}this.setSliceLabel(null),this.setNoOutsideFeeler()},z._sortPieSurfaces=function(e,t,i,r,n,a){var o=[];return t&&i&&r&&(n<=270&&n+a>270?(o.push(t),o.push(i),o.push(r)):n>270||n+a<=90?(o.push(t),o.push(r),o.push(i)):(o.push(i),o.push(r),o.push(t))),o.push(e),o},z.oppositeDirection=function(e,t,i){return e-t>0!=e-i>0},z.prototype._explodeSlice=function(){if(0!=this._explode){var t=this._angleExtent,i=(360-(this._angleStart+t/2))*e.Math.RADS_PER_DEGREE,r=this._pieChart.is3D()?k._THREED_TILT:1,n=this._explode*this._pieChart.__calcMaxExplodeDistance();this._explodeOffsetX=Math.cos(i)*n,this._explodeOffsetY=Math.sin(i)*r*n,"safari"!==e.Agent.browser&&"chrome"!==e.Agent.browser||(this._explodeOffsetX=Math.round(this._explodeOffsetX),this._explodeOffsetY=Math.round(this._explodeOffsetY))}else this._explodeOffsetX=0,this._explodeOffsetY=0;if(this._topSurface){var a=this._pieChart.is3D()&&this._topSurface[0].getSelectionOffset?this._topSurface[0].getSelectionOffset():[];z._translateShapes(this._topSurface,a[0]?a[0]+this._explodeOffsetX:this._explodeOffsetX,a[1]?a[1]+this._explodeOffsetY:this._explodeOffsetY)}if(this._rightSurface&&z._translateShapes(this._rightSurface,this._explodeOffsetX,this._explodeOffsetY),this._leftSurface&&z._translateShapes(this._leftSurface,this._explodeOffsetX,this._explodeOffsetY),this._crustSurface&&z._translateShapes(this._crustSurface,this._explodeOffsetX,this._explodeOffsetY),this._hasFeeler){var o=this._outsideFeelerStart.x,s=this._outsideFeelerStart.y,l=o+this._explodeOffsetX,h=s+this._explodeOffsetY;this._feelerRad.setX1(l),this._feelerRad.setY1(h);var u=this._outsideFeelerMid.x,g=this._outsideFeelerMid.y;z.oppositeDirection(u,o,l)?(this._feelerRad.setX2(l),this._feelerHoriz.setX1(l)):(this._feelerRad.setX2(u),this._feelerHoriz.setX1(u)),z.oppositeDirection(g,s,h)?(this._feelerRad.setY2(h),this._feelerHoriz.setY1(h)):(this._feelerRad.setY2(g),this._feelerHoriz.setY1(g))}this._sliceLabel&&!this._hasFeeler&&this._sliceLabel.setTranslate(this._explodeOffsetX,this._explodeOffsetY)},z._translateShapes=function(e,t,i){if(e)for(var r=e.length,n=0;n<r;n++)e[n].setTranslate(t,i)},z.prototype.getRadiusX=function(){return this._radiusX},z.prototype.getRadiusY=function(){return this._radiusY},z.prototype.getCenter=function(){return new e.Point(this._centerX,this._centerY)},z.prototype.getDepth=function(){return this._depth},z.prototype.getAngleExtent=function(){return this._angleExtent},z.prototype.setAngleExtent=function(e){this._angleExtent=e},z.prototype.getAngleStart=function(){return this._angleStart},z.prototype.setAngleStart=function(e){this._angleStart=e},z.prototype.__getExplodeOffsetX=function(){return this._explodeOffsetX},z.prototype.__getExplodeOffsetY=function(){return this._explodeOffsetY},z.prototype.setOutsideFeelerPoints=function(e,t,i){this._outsideFeelerStart=e,this._outsideFeelerMid=t,this._outsideFeelerEnd=i,this._hasFeeler=!0},z.prototype.setNoOutsideFeeler=function(){this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._hasFeeler=!1},z.prototype.getLabelAndFeeler=function(){var e=[];return this._sliceLabel&&e.push(this._sliceLabel),this._feelerRad&&e.push(this._feelerRad),this._feelerHoriz&&e.push(this._feelerHoriz),e},z.prototype.getSliceLabel=function(){return this._sliceLabel},z.prototype.setSliceLabel=function(e){this._sliceLabel=e},z.prototype.getSliceLabelString=function(){return this._sliceLabelString},z.prototype.setSliceLabelString=function(e){this._sliceLabelString=e},z.prototype.getTopSurface=function(){return this._topSurface},z.prototype.getValue=function(){return this._value},z.prototype.getId=function(){return this._id},z.prototype.getSeriesIndex=function(){return this._seriesIndex},z._shapeIsSelectable=function(e){return e instanceof C},z.prototype.contains=function(e,t){for(var i=this._pieChart.getInnerRadius(),r=this._pieChart.getCenter(),n=(e-r.x)/this._radiusX,a=(t-r.y)/this._radiusY,o=-Math.atan2(a,n)*(180/Math.PI);o<this._angleStart;)o+=360;for(;o-this._angleStart>=360;)o-=360;var s=Math.pow(n,2)+Math.pow(a,2),l=Math.sqrt(s)>i/this._radiusX&&s<=1,h=o<=this._angleStart+this._angleExtent;return l&&h},z.prototype.GetAnimationParams=function(){var t=e.ColorUtils.getRed(this._fillColor),i=e.ColorUtils.getGreen(this._fillColor),r=e.ColorUtils.getBlue(this._fillColor),n=e.ColorUtils.getAlpha(this._fillColor);return[this._value,this._radiusX,this._radiusY,this._explode,this._centerX,this._centerY,this._depth,t,i,r,n]},z.prototype.SetAnimationParams=function(t){this._value=t[0],this._radiusX=t[1],this._radiusY=t[2],this._explode=t[3],this._centerX=t[4],this._centerY=t[5],this._depth=t[6];var i=Math.round(t[7]),r=Math.round(t[8]),n=Math.round(t[9]),a=Math.round(t[10]);this._fillColor=e.ColorUtils.makeRGBA(i,r,n,a)},z.prototype.getDeletedAnimationParams=function(){var e=this.GetAnimationParams();return e[0]=0,e[1]=this.getInnerRadius(),e[2]=this.getInnerRadius(),e[3]=0,e},z.prototype.animateUpdate=function(t,i){var r=i.GetAnimationParams(),n=this.GetAnimationParams();if(!e.ArrayUtils.equals(r,n)){var a=new e.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimationDuration());a.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,n),t.add(a,0),this.SetAnimationParams(r)}},z.prototype.animateInsert=function(t){var i=new e.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimationDuration());i.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,this.GetAnimationParams()),t.add(i,0),this.SetAnimationParams(this.getDeletedAnimationParams())},z.prototype.animateDelete=function(t,i){var r=i.__getSlices(),n=this.getPieChart().__getSlices(),a=n.indexOf(this)-1;if(a>=0){for(var o=n[a].getId(),s=0;s<r.length;s++)if(r[s].getId().equals(o)){r.splice(s+1,0,this);break}}else r.splice(0,0,this);this._pieChart=i;var l=new e.CustomAnimation(i.getCtx(),this,this.getPieChart().getAnimationDuration());l.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,this.getDeletedAnimationParams()),l.setOnEnd(this._removeDeletedSlice,this),t.add(l,0)},z.prototype._removeDeletedSlice=function(){var e=this.getPieChart().__getSlices(),t=e.indexOf(this);t>=0&&e.splice(t,1)},z.prototype.getDisplayables=function(){var e=new Array;return this._topSurface&&(e=e.concat(this._topSurface)),this._leftSurface&&(e=e.concat(this._leftSurface)),this._rightSurface&&(e=e.concat(this._rightSurface)),this._crustSurface&&(e=e.concat(this._crustSurface)),this._sliceLabel&&e.push(this._sliceLabel),this._feelerRad&&e.push(this._feelerRad),this._feelerHoriz&&e.push(this._feelerHoriz),e},z.prototype.getAriaLabel=function(){var t,i=this._pieChart.getOptions().translations;t=null==this._seriesIndex?re.getOtherSliceDatatip(this._chart,this._value,!1):re.getDatatip(this._chart,this._seriesIndex,0,null,!1);var r=i.labelPercentage,n=he.generateSlicePercentageString(this);t+="; "+e.ResourceUtils.format(i.labelAndValue,[r,n]);var a=[];return this.isSelectable()&&a.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),Q.isDataItemDrillable(this._chart,this._seriesIndex,this._groupIndex)&&a.push(i.stateDrillable),e.Displayable.generateAriaLabel(t,a)},z.prototype._updateAriaLabel=function(){var t=this.getTopDisplayable();t&&!e.Agent.deferAriaCreation()&&t.setAriaProperty("label",this.getAriaLabel())},z.prototype.getTopDisplayable=function(){return this._topSurface&&this._topSurface.length>0?this._topSurface[0]:null},z.prototype.isSelectable=function(){return this._chart.isSelectionSupported()},z.prototype.isSelected=function(){return this._selected},z.prototype.setSelected=function(t,i){if(this._selected=t,this.getTopSurface()){if(this._selected?this._pieChart.bringToFrontOfSelection(this):this._selecting||this._pieChart.pushToBackOfSelection(this),te.isSelectionHighlighted(this._chart))for(var r=this.getDisplayables(),n=0;n<r.length;n++)z._shapeIsSelectable(r[n])&&r[n].setSelected(t);if(te.isSelectionExploded(this._chart)){var a=t?1:0;if(i||"none"==te.getAnimationOnDataChange(this._chart))this.setExplode(a);else{var o=new e.CustomAnimation(this._pieChart.getCtx(),this,this._pieChart.getAnimationDuration()/2);o.getAnimator().addProp(e.Animator.TYPE_NUMBER,this,this.getExplode,this.setExplode,a),o.play()}}this._updateAriaLabel()}},z.prototype.showHoverEffect=function(){this._selecting=!0,this._pieChart.bringToFrontOfSelection(this);for(var e=this.getDisplayables(),t=0;t<e.length;t++)z._shapeIsSelectable(e[t])&&e[t].showHoverEffect()},z.prototype.hideHoverEffect=function(){this._selecting=!1,this._selected||this._pieChart.pushToBackOfSelection(this);for(var e=this.getDisplayables(),t=0;t<e.length;t++)z._shapeIsSelectable(e[t])&&e[t].hideHoverEffect()},z.prototype.getDatatip=function(e,t,i){return e==this._sliceLabel&&this._sliceLabel&&this._sliceLabel.isTruncated()?this.getSliceLabelString():this.getTooltip()},z.prototype.getDatatipColor=function(){return this.getFillColor()},z.prototype.getCategories=function(){return this._categories&&this._categories.length>0?this._categories:[this.getId().series]},z.prototype.getNextNavigable=function(t){var i=t.keyCode;if(t.type==e.MouseEvent.CLICK)return this;if(i==e.KeyboardEvent.SPACE&&t.ctrlKey)return this;var r=e.Agent.isRightToLeft(this._chart.getCtx()),n=this._pieChart.__getSlices(),a=n.indexOf(this),o=null;return i==e.KeyboardEvent.RIGHT_ARROW||i==e.KeyboardEvent.DOWN_ARROW&&!r||i==e.KeyboardEvent.UP_ARROW&&r?o=a<n.length-1?n[a+1]:n[0]:(i==e.KeyboardEvent.LEFT_ARROW||i==e.KeyboardEvent.DOWN_ARROW&&r||i==e.KeyboardEvent.UP_ARROW&&!r)&&(o=0==a?n[n.length-1]:n[a-1]),o},z.prototype.getKeyboardBoundingBox=function(t){var i=this.getDisplayables();return i[0]?i[0].getDimensions(t):new e.Rectangle(0,0,0,0)},z.prototype.getTargetElem=function(){var e=this.getDisplayables();return e[0]?e[0].getElem():null},z.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect()},z.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()},z.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},z.prototype.isDragAvailable=function(e){return!0},z.prototype.getDragTransferable=function(e,t){return[this.getId()]},z.prototype.getDragFeedback=function(e,t){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],n=0;n<i.length;n++)r=r.concat(i[n].getDisplayables());return r}return this.getDisplayables()},z.prototype.getExplode=function(){return this._explode},z.prototype.setExplode=function(e){this._explode=e,this._explodeSlice()},z.prototype.getCustomLabel=function(){return this._customLabel},z.prototype.getSeriesLabel=function(){return this._seriesLabel},z.prototype.getFillColor=function(){return this._fillColor},z.prototype.getFillPattern=function(){return this._fillPattern},z.prototype.getStrokeColor=function(){return this._strokeColor},z.prototype.getBorderWidth=function(){return this._borderWidth},z.prototype.getSliceGaps=function(){return 0==this._depth?3*te.getDataItemGaps(this._chart):0},z.prototype.getInnerRadius=function(){return this._pieChart.getInnerRadius()},z.prototype.getTooltip=function(){return null==this._seriesIndex?re.getOtherSliceDatatip(this._chart,this._value,!0):re.getDatatip(this._chart,this._seriesIndex,0,null,!0)},z.prototype.isDrillable=function(){return this._drillable},z.createFillerSlice=function(e,t){var i=new z(e);return i._value=t,i._bFillerSlice=!0,i._centerX=e.getCenter().x,i._centerY=e.getCenter().y,i._fillColor="rgba(255,255,255,0)",i._strokeColor="rgba(255,255,255,0)",i._id=new o(null,null,null,null),i},z.prototype.getSeriesIndex=function(){return this._seriesIndex};var H=function(){};e.Obj.createSubclass(H,e.Obj),H.createAnimation=function(t,i,r){var n=[];if(ne.isBLAC(t))H._animBarLineArea(t,r,n);else if(ne.isScatterBubble(t)||ne.isFunnel(t)||ne.isPyramid(t))H._animBubbleScatterFunnelPyramid(t,r,n);else if(ne.isPie(t)&&t.pieChart)return t.pieChart.getDisplayAnimation();return n.length>0?new e.ParallelPlayable(t.getCtx(),n):null},H._animBarLineArea=function(t,i,r){var n=t.getChartObjPeers(),a=n?n.length:0;if(a)for(var o,s,l,h=0;h<a;h++){o=(s=n[h]).getDisplayables()[0];var u=te.getSeriesType(s.getChart(),s.getSeriesIndex());if(l=null,o instanceof x||o instanceof I||o instanceof O||o instanceof M)l=o.getDisplayAnimation(i);else if(o instanceof w)l="line"==u?H._getLinePlayable(t,o,i):H._getAreaPlayable(t,o,i);else if(o instanceof e.SimpleMarker||o instanceof P){if(o instanceof D&&!o.isSelected())continue;l=new e.AnimFadeIn(t.getCtx(),o,i-.8,.8)}l&&r.push(l)}},H._animBubbleScatterFunnelPyramid=function(t,i,r){var n=t.getObjects(),a=n?n.length:0;if(a)for(var o,s,l=0;l<a;l++)(o=n[l].getDisplayables()[0])instanceof e.SimpleMarker?s=new e.AnimPopIn(t.getCtx(),o,!0,i):(o instanceof R||o instanceof B)&&(s=H._getFunnelPyramidPlayable(t,o,i)),s&&r.push(s)},H._getAreaPlayable=function(t,i,r){var n,a=t.getCtx(),o=i.getBaseline();if(i.isArea()){for(var s=i.getBaseCoords(),l=i.getBaseAnimationParams(),h=l.slice(0),u=0;u<l.length;u++)u%4!=1&&u%4!=2||(l[u]=o);i.setBaseAnimationParams(l),(n=new e.CustomAnimation(a,i,r)).getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,i,i.getBaseAnimationParams,i.setBaseAnimationParams,h)}var g=i.getCoords(),d=i.getAnimationParams(),p=d.slice(0);for(u=0;u<d.length;u++)u%4!=1&&u%4!=2||(d[u]=o);i.setAnimationParams(d);var c=new e.CustomAnimation(a,i,r);c.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,p);var _=new e.ParallelPlayable(t.getCtx(),n,c);return _.setOnEnd(function(){i.setCoords(g,s)}),_},H._getFunnelPyramidPlayable=function(t,i,r){var n=t.getCtx(),a=i.getAnimationParams(),o=a.slice(0),s=a.slice(0);a[0]=0,ne.isFunnel(t)&&(a[2]=0,o[2]=0),i.setAnimationParams(a);var l=new e.CustomAnimation(n,i,r/2);l.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,o);var h=new e.CustomAnimation(n,i,r/2);return h.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,s),new e.SequentialPlayable(n,[l,h])},H._getLinePlayable=function(t,i,r){var n=i.getCoords(),a=i.getAnimationParams(),o=a.slice(0);H._getMeanPoints(a),i.setAnimationParams(a);var s=new e.CustomAnimation(t.getCtx(),i,r);return s.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,o),s.setOnEnd(function(){i.setCoords(n)}),s},H._getMeanPoints=function(e){var t,i=0,r=Number.MAX_VALUE,n=Number.MIN_VALUE,a=e.length;for(t=0;t<a;t++){var o=e[t];t%4!=0&&t%4!=3&&o!=1/0&&(o<r&&(r=o),o>n&&(n=o),i+=o)}for(a>8?(i-=2*r,i-=2*n,i/=a/2-4):i/=a/2,t=0;t<a;t++)t%4!=1&&t%4!=2||(e[t]=i)};var F=function(){};e.Obj.createSubclass(F,e.Obj),F.createAnimation=function(t,i,r,n,a){if(!F._canAnimate(t,i))return null;var o,s=i.getCtx(),l=[],h=[];ne.isPie(i)?(l.push(t.pieChart),h.push(i.pieChart)):F._buildAnimLists(s,l,t,h,i,n);var u=new e.DataAnimationHandler(s,a);u.constructAnimation(l,h),u.getNumPlayables()>0&&(o=u.getAnimation(!0));var g=i.getDataLabels();if(o&&g.length>0){for(var d=0;d<g.length;d++)g[d].setAlpha(0);o=new e.SequentialPlayable(s,o,new e.AnimFadeIn(s,g,n/4))}return o},F._buildAnimLists=function(t,i,r,n,a,o){var s,l,h,u,g,d=r.getChartObjPeers(),p=i,c=a.getCache().getFromCache("dataFiltered");for(s=0;s<2;s++){var _={},f={};for(l=0;l<d.length;l++){if(g=null,(u=(h=d[l]).getDisplayables()[0])instanceof R)g=new Y(h,o);else if(u instanceof B)g=new K(h,o);else if(u instanceof x||u instanceof I){if(g=new G(h,o),c){var m=h.getSeries();_[m]=_[m]?_[m]+1:1,
g.setId(m+"/"+_[m]+"/bar")}}else if(u instanceof w){var v=(g=new U(h,o)).getId();f[v]=f[v]?f[v]+1:1,g.setId(v+"/"+f[v])}else if(u instanceof e.SimpleMarker){if(u instanceof D&&!u.isSelected())continue;g=new V(h,o)}else if(u instanceof P){if(u.isInvisible()&&!u.isSelected())continue;g=new X(h,o)}else u instanceof O?g=new W(h,o):u instanceof M&&(g=new j(h,o));g&&(p.push(g),g.setOldChart(r))}p=n,d=a.getChartObjPeers()}},F._canAnimate=function(e,t){return ne.isPie(e)&&ne.isPie(t)?e&&t:!!(ne.isPolar(e)==ne.isPolar(t)&&(ne.isBLAC(e)&&ne.isBLAC(t)||ne.isScatterBubble(e)&&ne.isScatterBubble(t)||e.getType()==t.getType()))};var N=function(t){this.Options=t.Options,this.Peers=t.Peers,this.SeriesStyleArray=t.SeriesStyleArray,this.Cache=t.Cache,this.pieChart=t.pieChart,this._optionsCache=new e.BaseComponentCache,this._cache=new e.BaseComponentCache};e.Obj.createSubclass(N,e.Chart),N.prototype.getCache=function(){return this._cache},N.prototype.getOptionsCache=function(){return this._optionsCache};var W=function(e,t){this.Init(e,t)};e.Obj.createSubclass(W,e.Obj),W.prototype.animateUpdate=function(e,t){var i=t._shape;this._shape&&this._shape.getUpdateAnimation&&e.add(this._shape.getUpdateAnimation(this._updateDuration,i),1)},W.prototype.animateInsert=function(t){if(this._shape&&this._shape.getInsertAnimation)t.add(this._shape.getInsertAnimation(this._insertDuration),2);else{var i=new e.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);t.add(i,0)}},W.prototype.animateDelete=function(t,i){if(i.addChild(this._shape),this._shape&&this._shape.getDeleteAnimation)t.add(this._shape.getDeleteAnimation(this._deleteDuration),0);else{var r=new e.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);t.add(r,0)}},W.prototype.getId=function(){return this._animId},W.prototype.setId=function(e){this._animId=e},W.prototype.Init=function(e,t){this._peer=e,this._updateDuration=.75*t,this._insertDuration=.5*t,this._deleteDuration=.5*t,this._shape=e.getDisplayables()[0],this._animId=e.getDataItemId()||e.getSeries()+"/"+e.getGroup()},W.prototype.setOldChart=function(e){this._oldChart=e};var G=function(e,t){this.Init(e,t)};e.Obj.createSubclass(G,W),G.prototype.Init=function(e,t){G.superclass.Init.call(this,e,t),this._indicator=null,this._animId+="/bar"},G.prototype.animateInsert=function(e){var t=this._shape.getInsertAnimation(this._insertDuration);e.add(t,2)},G.prototype.animateDelete=function(e,t){t.addChild(this._shape);var i=this._shape.getDeleteAnimation(this._deleteDuration);e.add(i,0)},G.prototype.animateUpdate=function(t,i){var r=this._oldChart,n=this._peer.getChart(),a=ne.isHorizontal(r)!=ne.isHorizontal(n),o=i._getAnimationParams(a),s=this._getAnimationParams(),l=i._shape.getPrimaryFill(),h=this._shape.getPrimaryFill(),u=i._shape.isSelected()||this._shape.isSelected()||l.equals(h);if(!e.ArrayUtils.equals(o,s)||!l.equals(h)){var g=this._peer.getSeriesIndex(),d=i._peer.getSeriesIndex(),p=this._peer.getGroupIndex(),c=i._peer.getGroupIndex();"none"!==te.getAnimationIndicators(n)&&(this._indicator=q.makeIndicator(r,d,c,n,g,p)),this._setAnimationParams(o),u||this._shape.setFill(l);var _=new e.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);_.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,s),u||_.getAnimator().addProp(e.Animator.TYPE_FILL,this._shape,this._shape.getFill,this._shape.setFill,h),this._indicator&&(_.setOnEnd(this._onEndAnimation,this),this._indicator.setAlpha(0)),t.add(_,1)}},G.prototype._getAnimationParams=function(e){return this._shape.getAnimationParams(e)},G.prototype._setAnimationParams=function(e){this._shape.setAnimationParams(e,this._indicator)},G.prototype._onEndAnimation=function(){this._indicator&&(this._indicator.getParent().removeChild(this._indicator),this._indicator=null)};var j=function(e,t){this.Init(e,t)};e.Obj.createSubclass(j,W),j.prototype.Init=function(e,t){j.superclass.Init.call(this,e,t),this._animId+="/boxAndWhisker"};var U=function(e,t){this.Init(e,t)};e.Obj.createSubclass(U,W),U.prototype.animateUpdate=function(t,i){this._baseCoords=this._shape.getBaseCoords(),this._coords=this._shape.getCoords();var r,n,a=this._shape.isArea(),o=this._oldChart,s=this._chart,l=this._peer.getSeriesIndex(),h=i._peer.getSeriesIndex(),u=this._shape.getCommonGroupIndices(i._shape),g=i._shape.getCommonGroupIndices(this._shape);if(a){var d=i._getBaseAnimationParams(this._shape),p=this._getBaseAnimationParams(i._shape);U._matchGroupIndices(d,p),e.ArrayUtils.equals(d,p)||(this._setBaseAnimationParams(d),(r=new e.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getBaseAnimationParams,this._setBaseAnimationParams,p))}var c=i._getAnimationParams(this._shape),_=this._getAnimationParams(i._shape);U._matchGroupIndices(c,_),e.ArrayUtils.equals(c,_)||(this._setAnimationParams(c),(n=new e.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,_));var f=te.getSeriesType(this._peer.getChart(),l);if("none"!==te.getAnimationIndicators(s)&&(!a||"lineWithArea"!=f))for(var m,v,y=0;y<u.length;y++)m=q.getDirection(o,h,g[y],s,l,u[y]),(v=q.makeIndicator(o,h,g[y],s,l,u[y]))&&this._shape.addIndicator(u[y],m,v);if(r||n){var S=new e.ParallelPlayable(this._context,r,n);S.setOnEnd(this._onAnimationEnd,this),t.add(S,1)}},U.prototype.animateInsert=function(t){this._shape.setAlpha(0);var i=new e.AnimFadeIn(this._context,this._shape,this._insertDuration);t.add(i,2)},U.prototype.animateDelete=function(t,i){var r;if("area"==te.getSeriesType(this._oldChart,this._peer.getSeriesIndex())){var n=this._chart.__getAreaContainer();if(this._deletedAreas=this._shape.getParent().getParent(),!n)return;n.addChild(this._deletedAreas),(r=new e.AnimFadeOut(this._context,this._deletedAreas,this._deleteDuration)).setOnEnd(this._removeDeletedAreas,this),t.add(r,0)}else i.addChild(this._shape),r=new e.AnimFadeOut(this._context,this._shape,this._deleteDuration),t.add(r,0)},U.prototype._removeDeletedAreas=function(){var e=this._chart.__getAreaContainer();e&&e.removeChild(this._deletedAreas)},U.prototype._getAnimationParams=function(e){return this._shape.getAnimationParams(e)},U.prototype._setAnimationParams=function(e){this._shape.setAnimationParams(e)},U.prototype._getBaseAnimationParams=function(e){return this._shape.getBaseAnimationParams(e)},U.prototype._setBaseAnimationParams=function(e){this._shape.setBaseAnimationParams(e)},U.prototype._onAnimationEnd=function(){this._shape.removeIndicators(),this._shape.setCoords(this._coords,this._baseCoords)},U._matchGroupIndices=function(e,t){for(var i=3;i<e.length;i+=4)e[i]=t[i]},U.prototype.Init=function(e,t){U.superclass.Init.call(this,e,t),this._context=this._shape.getCtx(),this._chart=this._peer.getChart(),this._animId+="/"+(this._shape.isArea()?"area":"line")};var V=function(e,t){this.Init(e,t)};e.Obj.createSubclass(V,W),V.prototype.animateUpdate=function(t,i){var r=i._shape.getCenterDimensions(),n=this._shape.getCenterDimensions();if(!n.equals(r)){this._shape.setCenterDimensions(r);var a=new e.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);a.getAnimator().addProp(e.Animator.TYPE_RECTANGLE,this._shape,this._shape.getCenterDimensions,this._shape.setCenterDimensions,n);var o=this._peer.getChart();if(this.isValueChange(i)&&"none"!=te.getAnimationIndicators(o)&&ne.isScatterBubble(o)){var s=i._shape;s.setSolidFill("#FFFF2B",.9),s.setCenterDimensions(r),this._peer.getChart().getPlotArea().addChild(s),a.getAnimator().addProp(e.Animator.TYPE_RECTANGLE,s,s.getCenterDimensions,s.setCenterDimensions,n),a.getAnimator().addProp(e.Animator.TYPE_NUMBER,s,s.getAlpha,s.setAlpha,0),this._overlay=s,a.setOnEnd(this._onEndAnimation,this)}t.add(a,1)}},V.prototype.animateInsert=function(t){this._shape.setAlpha(0);var i=new e.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);t.add(i,2)},V.prototype.animateDelete=function(t,i){i.addChild(this._shape);var r=new e.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);t.add(r,0)},V.prototype.isValueChange=function(e){var t=!1;if(e){var i=e._peer.getSeriesIndex(),r=e._peer.getGroupIndex(),n=this._peer.getSeriesIndex(),a=this._peer.getGroupIndex(),o=e._oldChart.getOptions(),s=this._peer.getChart().getOptions(),l=o.series[i].items[r].x,h=o.series[i].items[r].y,u=o.series[i].items[r].z,g=s.series[n].items[a].x,d=s.series[n].items[a].y,p=s.series[n].items[a].z;t=g!==l||d!==h||p!==u}return t},V.prototype._onEndAnimation=function(){this._overlay&&(this._peer.getChart().getPlotArea().removeChild(this._overlay),this._overlay=null)},V.prototype.Init=function(e,t){V.superclass.Init.call(this,e,t),this._animId+="/marker"};var X=function(e,t){this.Init(e,t)};e.Obj.createSubclass(X,W),X.prototype.Init=function(e,t){X.superclass.Init.call(this,e,t),this._animId+="/rangeMarker"},X.prototype.animateInsert=function(t){this._shape.setAlpha(0);var i=new e.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);t.add(i,2)},X.prototype.animateDelete=function(t,i){i.addChild(this._shape);var r=new e.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);t.add(r,0)},X.prototype.animateUpdate=function(t,i){var r=i._shape.getAnimationParams(),n=this._shape.getAnimationParams();this._shape.setAnimationParams(r);var a=new e.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);a.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,this._shape,this._shape.getAnimationParams,this._shape.setAnimationParams,n),t.add(a,1)};var q=new Object;e.Obj.createSubclass(q,e.Obj),q.DIR_UP=0,q.DIR_DOWN=1,q.DIR_NOCHANGE=2,q.makeIndicator=function(e,t,i,r,n,a){if(ne.isPolar(r))return null;var o=q.getDirection(e,t,i,r,n,a);if(o==q.DIR_NOCHANGE)return null;var s=o===q.DIR_DOWN,l=s?te.getAnimationDownColor(r):te.getAnimationUpColor(r),h=q._drawIndicator(r.getCtx(),s,ne.isHorizontal(r),l);return r.getPlotArea().addChild(h),h},q.getDirection=function(e,t,i,r,n,a){var o=J.getValue(e,t,i),s=J.getValue(r,n,a);return null==s||null==o||s==o?q.DIR_NOCHANGE:s>o?q.DIR_UP:q.DIR_DOWN},q._drawIndicator=function(t,i,r,n){var a;a=r?(e.Agent.isRightToLeft(t)?!i:i)?"M3.5,-5L3.5,5L-3.5,0L3.5,-5":"M-3.5,-5L-3.5,5L3.5,0L-3.5,-5":i?"M-5,-3.5L5,-3.5L0,3.5L-5,-3.5Z":"M-5,3.5L5,3.5L0,-3.5L-5,3.5Z";var o=new e.Path(t,a);return o.setSolidFill(n),o};var Y=function(e,t){this.Init(e,t)};e.Obj.createSubclass(Y,W),Y.prototype.animateUpdate=function(t,i){var r=this._shape,n=i._shape.getAnimationParams(),a=r.getAnimationParams(),o=i._shape.getFill(),s=this._shape.getFill();if(!e.ArrayUtils.equals(n,a)||!o.equals(s)){r.setAnimationParams(n);var l=new e.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,a),o.equals(s)||(this._shape.setFill(o),l.getAnimator().addProp(e.Animator.TYPE_FILL,r,r.getFill,r.setFill,s)),this._indicator&&l.setOnEnd(this._onEndAnimation,this),t.add(l,1)}},Y.prototype.animateInsert=function(t){var i=this._shape,r=i.getAnimationParams(),n=r.slice(0);n[0]+=n[1]/2,n[1]=0,n[3]=0,i.setAnimationParams(n);var a=new e.CustomAnimation(i.getCtx(),this,this._insertDuration);a.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,r),t.add(a,2)},Y.prototype.animateDelete=function(t,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var n=r.getAnimationParams(),a=n.slice(0);a[0]+=n[1]/2,a[1]=0,a[3]=0;var o=new e.CustomAnimation(r.getCtx(),this,this._deleteDuration);o.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,a),t.add(o,0)},Y.prototype.Init=function(e,t){Y.superclass.Init.call(this,e,t),this._animId+="/funnel"};var K=function(e,t){this.Init(e,t)};e.Obj.createSubclass(K,W),K.prototype.animateUpdate=function(t,i){var r=this._shape,n=i._shape.getAnimationParams(),a=r.getAnimationParams(),o=i._shape.getPrimaryFill(),s=this._shape.getPrimaryFill();if(!e.ArrayUtils.equals(n,a)||!o.equals(s)){r.setAnimationParams(n);var l=new e.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,a),o.equals(s)||(this._shape.setFill(o),l.getAnimator().addProp(e.Animator.TYPE_FILL,r,r.getFill,r.setFill,s)),t.add(l,1)}},K.prototype.animateInsert=function(t){var i=this._shape,r=i.getAnimationParams(),n=r.slice(0);n[1]=0,n[2]=0,i.setAnimationParams(n);var a=new e.CustomAnimation(i.getCtx(),this,this._insertDuration);a.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,r),t.add(a,2)},K.prototype.animateDelete=function(t,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var n=r.getAnimationParams().slice(0);n[1]=0,n[2]=0;var a=new e.CustomAnimation(r.getCtx(),this,this._deleteDuration);a.getAnimator().addProp(e.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,n),t.add(a,0)},K.prototype.Init=function(e,t){K.superclass.Init.call(this,e,t),this._animId+="/pyramid"};var Z=new Object;e.Obj.createSubclass(Z,e.Obj),Z.getXAxisPosition=function(t){return ne.isPolar(t)?"tangential":ne.isHorizontal(t)?e.Agent.isRightToLeft(t.getCtx())?"right":"left":"bottom"},Z.getBaselineScaling=function(e,t){var i=t+"Axis",r=e.getOptions()[i].baselineScaling;return!r||"zero"!=r&&"min"!=r?ne.isStock(e)?"min":"zero":r},Z.getYAxisPosition=function(t){var i=t.getOptions().yAxis.position;return ne.isPolar(t)?"radial":ne.isHorizontal(t)?!i||"top"!=i&&"bottom"!=i?"bottom":i:(ne.isStock(t)&&(i=i||"end"),e.Agent.isRightToLeft(t.getCtx())?i&&"end"==i?"left":"right":i&&"end"==i?"right":"left")},Z.getY2AxisPosition=function(t){var i=t.getOptions().y2Axis.position;return ne.isHorizontal(t)?!i||"top"!=i&&"bottom"!=i?"top":i:e.Agent.isRightToLeft(t.getCtx())?i&&"start"==i?"right":"left":i&&"start"==i?"left":"right"},Z.hasTimeAxis=function(e){return ne.isBLAC(e)&&"disabled"!=Z.getTimeAxisType(e)},Z.hasGroupAxis=function(e){return ne.isBLAC(e)&&"disabled"==Z.getTimeAxisType(e)},Z.getTimeAxisType=function(e){var t=e.getOptions().timeAxisType;return t&&"auto"!=t&&ne.isBLAC(e)&&!ne.isPolar(e)?t:ne.isStock(e)?"skipGaps":"disabled"},Z.isMixedFrequency=function(e){return"mixedFrequency"==Z.getTimeAxisType(e)},Z.getAxisOffset=function(e){var t=e.getCache().getFromCache("axisOffset");if(null!=t)return t;var i=e.getOptions().styleDefaults.groupSeparators;if(Z.hasGroupAxis(e)&&J.getNumLevels(e)>1&&"on"==i.rendered)t=.5;else if(ne.hasBarSeries(e)||ne.hasCenteredSeries(e)||ne.hasCandlestickSeries(e)||ne.hasBoxPlotSeries(e)||ne.isBLAC(e)&&1==J.getGroupCount(e))t=.5;else if(ne.isSpark(e)||Q.isScrollable(e)||ne.isOverview(e))t=0;else{var r=ne.isHorizontal(e)?.2:.5;t=r-r/Math.sqrt(J.getGroupCount(e))}return e.getCache().putToCache("axisOffset",t),t},Z.isGridShifted=function(e){if(!ne.isBLAC(e))return!1;if(J.getNumLevels(e)>1)return!0;for(var t=J.getSeriesCount(e),i=0;i<t;i++)if(te.isSeriesRendered(e,i)){var r=te.getSeriesType(e,i),n=te.getLineType(e,i);if("bar"!=r&&"centeredSegmented"!=n&&"centeredStepped"!=n)return!1}return!0},Z.isGridPolygonal=function(e){return!(!ne.isBLAC(e)||ne.hasBarSeries(e))&&"polygon"==e.getOptions().polarGridShape},Z.isAxisRendered=function(e,t){if("y"==t&&ne.hasY2DataOnly(e))return!1;if("y2"==t&&!ne.hasY2Data(e))return!1;var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&!("off"==i.tickLabel.rendered&&!i.title)},Z.isAxisLineRendered=function(e,t){var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.axisLine.rendered&&!("auto"==i.axisLine.rendered&&"x"!=t&&ne.isBLAC(e)&&!ne.isPolar(e))},Z.isMajorTickRendered=function(e,t){var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.majorTick.rendered&&!("auto"==i.majorTick.rendered&&"x"==t&&ne.isBLAC(e)&&!ne.isPolar(e))},Z.isMinorTickRendered=function(e,t){var i=e.getOptions()[t+"Axis"];return"off"!=i.rendered&&"off"!=i.minorTick.rendered&&("on"==i.minorTick.rendered||Z.isLog(e,t))},Z.isLog=function(e,t){return"log"==e.getOptions()[t+"Axis"].scale},Z.getTickLabelHeight=function(t,i){var r=t.getOptions(),n=r[i+"Axis"].tickLabel.style;return n instanceof e.CSSStyle||(n=new e.CSSStyle(n)),n.mergeUnder(h.getDefaults(r.skin).tickLabel.style),e.TextUtils.getTextStringHeight(t.getCtx(),n)},Z.getTickLabelGapSize=function(e,t){if(Z.isTickLabelInside(e,t))return 0;var i=e.getOptions(),r=ne.isHorizontal(e),n=Z.getGapScalingFactor(e,t),a=Math.ceil(i.layout.tickLabelGapWidth*n),o=Math.ceil(i.layout.tickLabelGapHeight*n);return"x"==t?r?a:o:r?o:a},Z.getGapScalingFactor=function(e,t){return Z.isAxisRendered(e,t)?Z.getTickLabelHeight(e,t)/14:0},Z.isTickLabelInside=function(e,t){return!(ne.isPolar(e)||ne.isScatterBubble(e)||ne.isBLAC(e)&&"x"==t)&&"inside"==e.getOptions()[t+"Axis"].tickLabel.position},Z.getXAxisViewportMinMax=function(e,t){var i=t?"xAxisViewportMinMaxUG":"xAxisViewportMinMax",r=e.getCache().getFromCache(i);if(r)return r;var n=e.getOptions().xAxis,a=Z.hasGroupAxis(e),o=Z.getAxisOffset(e);if(t)var s=Z.getXAxisGlobalMinMax(e);var l=null;null!=n.viewportMin?l=n.viewportMin:null!=n.viewportStartGroup?l=a?J.getGroupIndex(e,n.viewportStartGroup)-o:n.viewportStartGroup:t&&(l=s.min);var h=null;return null!=n.viewportMax?h=n.viewportMax:null!=n.viewportEndGroup?h=a?J.getGroupIndex(e,n.viewportEndGroup)+o:n.viewportEndGroup:t&&(h=s.max),r={min:l,max:h},e.getCache().putToCache(i,r),r},Z.getXAxisGlobalMinMax=function(e){var t=e.getOptions().xAxis,i=Z.hasGroupAxis(e),r=Z.getAxisOffset(e);if(!i)var n=J.getMinMaxValue(e,"x");return{min:null!=t.min?t.min:i?0-r:n.min,max:null!=t.max?t.max:i?J.getGroupCount(e)-1+r:n.max}},Z.applyInitialZooming=function(e,t){var i=e.getOptions(),r=i.xAxis,n=i.initialZooming;if(ne.isBLAC(e)&&"off"!=i.zoomAndScroll&&"none"!=n){i._initialZoomed&&("last"==n?r.viewportMin=null:r.viewportMax=null);var a=Z.getXAxisViewportMinMax(e,!1),o=a.min,s=a.max;if(!("last"==n&&null!=o||"first"==n&&null!=s)){var l=ne.isHorizontal(e)?t.h:t.w,h=Math.floor(l/(2*Z.getTickLabelHeight(e,"x")))+Z.getAxisOffset(e),u=J.getGroupCount(e)-1;if(!(u<=h)){var g,d;if(Z.hasGroupAxis(e))g=0,d=u;else{var p=J.getMinMaxValue(e,"x");g=p.min,d=p.max}var c=h/u*(d-g);"last"==i.initialZooming?(null==s&&(s=d),r.viewportMin=Math.max(s-c,g)):(null==o&&(o=g),r.viewportMax=Math.min(o+c,d)),i._initialZoomed=!0}}}},Z.getGroupWidthRatios=function(e){if(!ne.hasBarSeries(e)&&!ne.hasCandlestickSeries(e)&&!ne.hasBoxPlotSeries(e))return null;var t=e.getOptions(),i=te.getBarGapRatio(e);if(i>=1)return t._averageGroupZ=1/0,null;t._averageGroupZ=0;var r,n,a,o,s,l,h=J.getGroupCount(e),u=ne.isSplitDualY(e),g=J.getStackCategories(e,"bar"),d=g.y.length,p=g.y2.length;if(e.getOptionsCache().getFromCache("hasConstantZValue")){var c=e.getOptionsCache().getFromCache("constantZValue")*(u?Math.max(d,p):d+p);l=(s=c*h)*i/(1-i),r=null}else{for(var _=[],f=0;f<h;f++){for(n=0,o=0;o<d;o++)n+=J.getBarCategoryZ(e,g.y[o],f,!1);for(a=0,o=0;o<p;o++)a+=J.getBarCategoryZ(e,g.y2[o],f,!0);_.push(u?Math.max(n,a):n+a)}s=_.reduce(function(e,t){return e+t}),l=s*i/(1-i),r=_.map(function(e){return e+l/h})}return t._averageGroupZ=(s+l)/h,r},Z.isYAdjustmentNeeded=function(e){var t=e.getOptions().styleDefaults.dataLabelPosition,i=e.getOptionsCache().getFromCache("hasDataOutsideBarEdge"),r="outsideBarEdge"==t||i,n=te.isStackLabelRendered(e);return!(!ne.hasBarSeries(e)||!r&&!n)},Z.axisContainsPoint=function(e,t){if(!e)return!1;var i=e.getOptions().position,r="top"==i||"bottom"==i,n=r?4:10,a=r?10:4,o=e.__getBounds().clone();o.x-=a,o.y-=n,o.w+=2*a,o.h+=2*n;var s=e.stageToLocal(t);return o.containsPoint(s.x,s.y)};var J=new Object;e.Obj.createSubclass(J,e.Obj),J.hasData=function(e){var t=e.getOptions();if(!t||!t.series||t.series.length<1)return!1;for(var i=J.getSeriesCount(e),r=0;r<i;r++){var n=J.getSeriesItem(e,r);if(n&&n.items&&n.items.length>=1)return!0}return!1},J.hasInvalidData=function(e){return!J.hasData(e)||J.hasInvalidTimeData(e)},J.hasInvalidTimeData=function(e){if(ne.isFunnel(e)||ne.isPie(e)||ne.isPyramid(e))return!1;var t,i,r=e.getOptions(),n=J.getGroupCount(e);if(!r||!r.series||r.series.length<1)return!0;if(n<1)return!0;var a=J.getSeriesCount(e);if(Z.isMixedFrequency(e))for(t=0;t<a;t++)for(i=0;i<n;i++){var o=J.getDataItem(e,t,i);if(o&&(null==o.x||isNaN(o.x)))return!0}else if(Z.hasTimeAxis(e))for(i=0;i<n;i++){var s=J.getGroup(e,i);if(null==s||isNaN(s))return!0}return!1},J.hasSeriesData=function(e,t){var i=J.getSeriesItem(e,t).items;if(i)for(var r=0;r<i.length;r++)if(null!=i[r])return!0;return!1},J.processDataObject=function(t){if(J.hasData(t)){var i=t.getOptions(),r=t.getOptionsCache(),n=J.getSeriesCount(t);ne.isValidType(t)||(i.type="bar");var a=!1,o=!1,s=!0,l=null,h=!1,u=!1,g=!1,d=ne.isStock(t);d&&n>1&&(i.series=i.series.slice(0,1),n=1);var p=Z.isMixedFrequency(t),c=n>100;r.putToCache("hasLargeSeriesCount",c);for(var _=0,f=t.getSeriesStyleArray(),m=0;m<n;m++){var v=J.getSeries(t,m);!c&&null!=v&&f.indexOf(v)<0&&f.push(v);var y=J.getSeriesItem(t,m);if(y.items&&y.items.length>_&&(_=y.items.length),"hidden"==y.visibility){var S=te.getHiddenCategories(t);S.indexOf(v)<0&&S.push(v)}if(y.visibility=null,"on"==y.assignedToY2&&(a=!0),y&&y.items)for(var C=y.items,A=0;A<C.length;A++)null!=C[A]&&("object"!=typeof(w=C[A])&&(w={y:w},C[A]=w),p||null==w.x||(w.x=Number(w.x)),null!=w.y&&(w.y=Number(w.y),w.y<0&&(u=!0)),null!=w.z?(w.z=Number(w.z),null==l?l=w.z:l!=w.z&&(s=!1)):l=1,null!=w.value&&(w.value=Number(w.value),w.value<0&&(u=!0)),null!=w.targetValue&&(w.targetValue=Number(w.targetValue)),null!=w.open&&(w.open=Number(w.open),h=!0),null!=w.close&&(w.close=Number(w.close),h=!0,w.close<0&&(u=!0)),null!=w.low&&(w.low=Number(w.low),h=!0),null!=w.high&&(w.high=Number(w.high),h=!0),null!=w.volume&&(w.volume=Number(w.volume),o=!0),(w.color||w.borderColor||w.borderWidth||w.style||w.svgStyle||w.className||w.svgClassName)&&r.putToCachedMap("itemStyleSet",m,!0),"outsideBarEdge"==w.labelPosition&&(g=!0))}if(r.putToCache("hasVolume",o),r.putToCache("hasConstantZValue",s),r.putToCache("constantZValue",s?l:null),r.putToCache("hasLowHighSeries",h),r.putToCache("hasNegativeValues",u),r.putToCache("hasDataOutsideBarEdge",g),d&&J.hasVolumeSeries(t)&&!ne.isOverview(t)){var b=e.JsonUtils.clone(J.getSeriesItem(t,0));b.assignedToY2="on",a=!0,b.type="bar",b.categories=J.getCategories(t,0),b.id="_volume",b._selectable="off",b.items=[];for(var x=0;x<y.items.length;x++){var M={};M.color=te.getStockVolumeColor(t,0,x),M.x=y.items[x].x,M.value=y.items[x].volume,M.drilling="off",b.items.push(M)}i.series.push(b),r.putToCachedMap("itemStyleSet",i.series.length-1,!0)}r.putToCache("hasY2Assignment",a);for(var O=$.getRefObjs(t),T=0;T<O.length;T++)if(C=O[T].items)for(A=0;A<C.length;A++){var w;(w=C[A])&&("object"!=typeof w?C[A]=Number(w):(!Z.isMixedFrequency(t)&&w.x&&(w.x=Number(w.x)),w.max&&(w.max=Number(w.max)),w.min&&(w.min=Number(w.min)),w.value&&(w.value=Number(w.value))))}i.groups||(i.groups=new Array);var D=J.getGroupCount(t);for(T=0;T<_-D;T++){var E=i.translations.labelDefaultGroupName||"Group {0}",I=e.ResourceUtils.format(E,[i.groups.length+1]);i.groups.push(I)}r.putToCache("groupsArray",null),J._processTimeAxis(t);var P=i.sorting;if(P="on"==P?"descending":"ascending"!=P&&"descending"!=P?"off":P,ne.isBLAC(t)&&Z.hasGroupAxis(t)&&"off"!=P&&1==J.getNumLevels(t)){var L=J.getGroups(t),R={};for(A=0;A<L.length;A++){var B=0;for(T=0;T<=n;T++)if(te.isSeriesRendered(t,T)&&!J.isAssignedToY2(t,T)){var k=J.getValue(t,T,A);B+=null==k||isNaN(k)?0:k}R[L[A]]={index:A,total:B,group:i.groups[A]}}for("ascending"==P?L.sort(function(e,t){return R[e].total-R[t].total}):L.sort(function(e,t){return R[t].total-R[e].total}),T=0;T<n;T++){var z=[];for(A=0;A<L.length;A++)z.push(J.getDataItem(t,T,R[L[A]].index));i.series[T].items=z}var H=[];for(A=0;A<L.length;A++)H.push(R[L[A]].group);i.groups=H,r.putToCache("groupsArray",null),r.putToCache("value",null)}J._sanitizeAxis(i.xAxis),J._sanitizeAxis(i.yAxis),J._sanitizeAxis(i.y2Axis)}},J._sanitizeAxis=function(e){e.min==e.max&&(e.min=null,e.max=null)},J._sanitizeDateTime=function(e,t){var i=null,r=e.getLocaleHelpers().isoToDateConverter;if(r){try{i=r(t)}catch(e){i=null}i=null!=i&&i.getTime?i.getTime():null}return null==i&&(i=Date.parse(t)),isNaN(i)&&(i=Number(t)),i},J._processTimeAxis=function(e){var t,i,r=e.getCtx(),n=e.getOptions(),a=J.getSeriesCount(e),o=J.getGroupCount(e);if(Z.isMixedFrequency(e))for(t=0;t<a;t++)for(i=0;i<o;i++){var s=J.getDataItem(e,t,i);null!=s&&"string"==typeof s.x&&null!=s.x&&(s.x=J._sanitizeDateTime(r,s.x))}else if(Z.hasTimeAxis(e)){for(i=0;i<o;i++){var l=J.getGroup(e,i);null!=l&&(n.groups[i]=J._sanitizeDateTime(r,l))}e.getOptionsCache().putToCache("groupsArray",null)}if(Z.hasTimeAxis(e)){var h=n.xAxis;null!=h.dataMin&&(h.dataMin=J._sanitizeDateTime(r,h.dataMin)),null!=h.dataMax&&(h.dataMax=J._sanitizeDateTime(r,h.dataMax)),null!=h.min&&(h.min=J._sanitizeDateTime(r,h.min)),null!=h.max&&(h.max=J._sanitizeDateTime(r,h.max)),null!=h.viewportMin&&(h.viewportMin=J._sanitizeDateTime(r,h.viewportMin)),null!=h.viewportMax&&(h.viewportMax=J._sanitizeDateTime(r,h.viewportMax)),null!=h.viewportStartGroup&&(h.viewportStartGroup=J._sanitizeDateTime(r,h.viewportStartGroup)),null!=h.viewportEndGroup&&(h.viewportEndGroup=J._sanitizeDateTime(r,h.viewportEndGroup));for(var u=$.getRefObjs(e),g=0;g<u.length;g++){var d=u[g].items;if(d)for(var p=0;p<d.length;p++)d[p]&&null!=d[p].x&&(d[p].x=J._sanitizeDateTime(r,d[p].x))}}},J.isEqualId=function(t,i,r){return null!=t&&null!=i&&e.Obj.compareValues(r,t,i)},J.getSeriesCount=function(e){var t=e.getOptions().series;return t?t.length:0},J.getY2SeriesCount=function(e,t,i){for(var r=0,n=J.getSeriesCount(e),a=0;a<n;a++)t&&te.getSeriesType(e,a)!=t||(i||te.isSeriesRendered(e,a))&&J.isAssignedToY2(e,a)&&r++;return r},J.getSeries=function(e,t){var i=J.getSeriesItem(e,t);return i?i.id?i.id:i.name||""===i.name?i.name:String(t):null},J.getSeriesLabel=function(e,t){var i=J.getSeriesItem(e,t);return i&&(i.name||""===i.name)?i.name:null},J.getSeriesIndex=function(e,t){for(var i=J.getSeriesCount(e),r=0;r<i;r++)if(J.getSeries(e,r)==t)return r;return-1},J.getSeriesStyleIndex=function(e,t){if(e.getOptionsCache().getFromCache("hasLargeSeriesCount"))return t;var i=J.getSeries(e,t);return null==i?t:e.getSeriesStyleArray().indexOf(i)},J.getSeriesItem=function(e,t){if(isNaN(t)||null==t||t<0)return null;var i=e.getOptions();return i.series&&i.series.length>t?i.series[t]:void 0},J.getDataItem=function(e,t,i){if(isNaN(i)||null==i||i<0)return null;var r=J.getSeriesItem(e,t);return r&&r.items&&r.items.length>i?r.items[i]:null},J.getDataItemId=function(e,t,i){var r=J.getDataItem(e,t,i);return r?null!=r.id?r.id:J.createDataItemId(J.getSeries(e,t),J.getGroup(e,i)):null},J.createDataItemId=function(e,t){return e+"; "+t},J.getNestedDataItem=function(e,t,i,r){if(isNaN(r)||null==r||r<0)return null;var n=J.getDataItem(e,t,i);return n&&n.items&&n.items.length>r?n.items[r]:null},J.getNestedDataItemCount=function(e,t,i){var r=J.getDataItem(e,t,i);return r&&r.items?r.items.length:0},J.getNestedDataItemId=function(e,t,i,r){var n=J.getNestedDataItem(e,t,i,r);return n?null!=n.id?n.id:J.getDataItemId(e,t,i)+"; "+String(r):null},J.getNestedDataItemIndex=function(e,t,i,r){for(var n=J.getNestedDataItemCount(e,t,i),a=0;a<n;a++){var o=J.getNestedDataItemId(e,t,i,a);if(J.isEqualId(o,r,e.getCtx()))return a}return-1},J.getGroupCount=function(e){return J._getGroupsArray(e).length},J.getGroup=function(e,t){if(null!=t&&t>=0&&t<J.getGroupCount(e)){var i=J._getGroupsArray(e)[t];if(i)return null!=i.id?i.id:null!=i.name?i.name:String(t)}return null},J.getGroupIndex=function(t,i){for(var r=J.getGroups(t),n=0;n<r.length;n++)if(i instanceof Array&&r[n]instanceof Array?e.ArrayUtils.equals(i,r[n]):i===r[n])return n;return-1},J.getGroupLabel=function(e,t){if(t>=0&&t<J.getGroupCount(e)){var i=J._getGroupsArray(e)[t];if(i)return null!=i.name?i.name:null!=i.id||"string"!=typeof i?"":i}return null},J.getGroups=function(e){var t=e.getOptionsCache().getFromCache("groups");if(!t){var i=J.getGroupCount(e);t=[];for(var r=0;r<i;r++)t.push(J.getGroup(e,r));e.getOptionsCache().putToCache("groups",t)}return t},J._getGroupsArray=function(e){var t=e.getOptions(),i=e.getOptionsCache().getFromCache("groupsArray");if(!i){i=[],t.groups&&(i=J._getNestedGroups(t.groups,i));for(var r=0;r<i.length;r++)1==i[r].id.length&&(i[r].id=i[r].id[0],i[r].name=i[r].name[0]);e.getOptionsCache().putToCache("groupsArray",i)}return i},J._getNestedGroups=function(e,t){if(!e||e&&0==e.length)return[];for(var i=0;i<e.length;i++){var r=e[i],n=null,a=null;if(null!=r&&(n=r.id?r.id:r.name?r.name:r,a=r.name?r.name:r),"object"==typeof n&&(n=null),"object"==typeof a&&(a=null),r&&r.groups){var o=J._getNestedGroups(r.groups,[]);0==o.length&&o.push({id:[],name:[]});for(var s=0;s<o.length;s++)o[s].id.unshift(n),o[s].name.unshift(a);t=t.concat(o)}else t.push({id:[n],name:[a]})}return t},J.getNumLevels=function(e){var t=e.getOptionsCache().getFromCache("groupsNumLevels");if(null!=t)return t;t=0;for(var i=J._getGroupsArray(e),r=0;r<i.length;r++){var n=i[r];if(n&&n.id){var a=Array.isArray(n.id)?n.id.length:1;t=Math.max(t,a)}}return e.getOptionsCache().putToCache("groupsNumLevels",t),t},J.getValue=function(e,t,i,r){var n,a="number"==typeof r&&r>=0;if(!a&&void 0!==(n=e.getOptionsCache().getFromCachedMap2D("value",t,i)))return n;var o=a?J.getNestedDataItem(e,t,i,r):J.getDataItem(e,t,i);return n=null,null!=o&&("object"!=typeof o?n=o:ne.isStock(e)&&null!=o.close?n=o.close:null!=o.value?n=o.value:null!=o.y&&(n=o.y)),n=n||(0===n?0:null),a||e.getOptionsCache().putToCachedMap2D("value",t,i,n),n},J.getCumulativeValue=function(e,t,i,r){if(!ne.isStacked(e))return J.getValue(e,t,i);var n=r?"cumValueH":"cumValue",a=e.getCache().getFromCachedMap2D(n,t,i);if(void 0!==a)return a;var o=te.getSeriesType(e,t),s=J.isAssignedToY2(e,t),l=J.getValue(e,t,i),h=J.getStackCategory(e,t),u="bar"==o?l<0:J.isSeriesNegative(e,t);a=0;for(var g=t;g>=0;g--)if((r||te.isDataItemRendered(e,g,i))&&o==te.getSeriesType(e,g)&&s==J.isAssignedToY2(e,g)&&J.getStackCategory(e,g)==h){var d=J.getValue(e,g,i),p="bar"==o?d<0:J.isSeriesNegative(e,g);if(u&&p||!u&&!p){var c=e.getCache().getFromCachedMap2D(n,g,i);if(void 0!==c){a=l+(c||0);break}a+=null==d||isNaN(d)?0:d}}return e.getCache().putToCachedMap2D(n,t,i,a),a},J.getLowValue=function(e,t,i){var r=J.getDataItem(e,t,i);return null==r?null:"candlestick"==te.getSeriesType(e,t)?null==r.low&&null!=r.close?null!=r.open?Math.min(r.close,r.open):r.close:r.low:null!=r.low&&null==r.close?r.low:null},J.getHighValue=function(e,t,i){var r=J.getDataItem(e,t,i);return null==r?null:"candlestick"==te.getSeriesType(e,t)?null==r.high?null!=r.open?Math.max(r.close,r.open):r.close:r.high:null!=r.high&&null==r.close?r.high:null},J.getXValue=function(e,t,i){var r=J.getDataItem(e,t,i);return J.getXValueFromItem(e,r,i)},J.getXValueFromItem=function(e,t,i){return null!=t&&null!=t.x?t.x:Z.hasGroupAxis(e)?i:Z.hasTimeAxis(e)&&!Z.isMixedFrequency(e)?J.getGroupLabel(e,i):null},J.getTargetValue=function(e,t){var i=J.getDataItem(e,t,0);return null==i||"object"!=typeof i?null:i.targetValue},J.getZValue=function(e,t,i,r){var n=J.getDataItem(e,t,i);return null==n||"object"!=typeof n?r:null!=n.z?Math.max(0,n.z):r},J.isStockValueRising=function(e,t,i){var r=J.getDataItem(e,t,i);return!r||r.open<=r.close},J.getCategories=function(e,t,i,r){var n=J.getNestedDataItem(e,t,i,r);if(n&&n.categories)return n.categories;var a=J.getDataItem(e,t,i);if(a&&a.categories)return a.categories;var o=J.getSeriesItem(e,t);if(o&&o.categories)return o.categories;var s=J.getSeries(e,t);return null!=s?[s]:[]},J.getViewportMinMaxGroupIndex=function(e,t){var i=Z.getXAxisViewportMinMax(e,!0),r=Z.hasGroupAxis(e),n=J.getGroupCount(e),a=i.min,o=0;if(null!=a)if(r)o=Math.ceil(a);else for(var s=0;s<n;s++)if(J.getXValue(e,t,s)>=a){o=s;break}var l=i.max,h=n-1;if(null!=h)if(r)h=Math.floor(l);else for(s=n-1;s>=o;s--)if(J.getXValue(e,t,s)<=l){h=s;break}return{min:o,max:h}},
J.getViewportGroupCount=function(e){var t=Z.getXAxisViewportMinMax(e,!0),i=Z.getXAxisGlobalMinMax(e),r=(t.max-t.min)/(i.max-i.min);return isNaN(r)?1:r*J.getGroupCount(e)},J._computeYAlongLine=function(t,i,r,n,a,o){t&&(r=e.Math.log10(r),a=e.Math.log10(a));var s=r+(a-r)*(o-i)/(n-i);return t?Math.pow(10,s):s},J.getMinMaxValue=function(e,t,i){var r=t+(i?"MinMaxDO":"MinMax"),n=e.getCache().getFromCache(r);if(n)return n;var a=e.getOptions()[t+"Axis"];if(null!=a.dataMax&&null!=a.dataMin&&i)return n={min:a.dataMin,max:a.dataMax},e.getCache().putToCache(r,n),n;var o=Z.hasTimeAxis(e);if(null!=a.max&&null!=a.min&&!i&&!o)return n={min:a.min,max:a.max},e.getCache().putToCache(r,n),n;var s="z"!=t&&Z.isLog(e,t),l="y2"==t;l&&(t="y");for(var h="y"==t,u=!i&&h&&ne.isBLAC(e),g="withoutRescale"==Q.getHideAndShowBehavior(e)||"x"==t&&Z.hasTimeAxis(e),d=-1/0,p=1/0,c=J.getSeriesCount(e),_=0;_<c;_++){var f=J.getSeriesItem(e,_),m=te.getSeriesType(e,_),v=h&&(te.isRangeSeries(e,_)||"candlestick"==m||"boxPlot"==m);if(g||te.isSeriesRendered(e,_)){var y=J.isAssignedToY2(e,_);if(!h||l==y){var S=f.items;if(S){var C=0,A=S.length-1;if(u){var b=J.getViewportMinMaxGroupIndex(e,_);C=b.min,A=b.max}for(var x=C;x<=A;x++)if(g||te.isDataItemRendered(e,_,x)){var M=S[x],O=null;if(h?v||(O=J.getCumulativeValue(e,_,x,g)):"x"==t&&o&&!Z.isMixedFrequency(e)?(O=J.getGroupLabel(e,x),null!=M&&(M.x=O)):null!=M&&(O=M[t]),!("z"==t&&O<=0)){if(!(v||null==O||"number"!=typeof O||s&&O<=0)){var T=0;ne.isBubble(e)&&!i&&"z"!=t&&(T=ae.getBubbleAxisRadius(e,t,M.markerSize)),d=Math.max(d,s?O*Math.pow(10,T):O+T),p=Math.min(p,s?O/Math.pow(10,T):O-T)}if(v){var w=J.getHighValue(e,_,x),D=J.getLowValue(e,_,x);s&&(w<=0||D<=0)||(d=Math.max(d,w,D),p=Math.min(p,w,D))}if(u&&!v){var E=null,I=null;if(C>0&&x==C?(E=x-1,I=Z.getXAxisViewportMinMax(e,!0).min):A<S.length-1&&x==A&&(E=x+1,I=Z.getXAxisViewportMinMax(e,!0).max),null!=E){var P=J.getXValue(e,_,x),L=J.getXValue(e,_,E),R=J.getCumulativeValue(e,_,E),B=J._computeYAlongLine(s,P,O||0,L,R||0,I);d=Math.max(d,B),p=Math.min(p,B)}}}}}}}}var k=null;if("x"==t?k=$.getAxisRefObjs(e,"x"):l?k=$.getAxisRefObjs(e,"y2"):h&&(k=$.getAxisRefObjs(e,"y")),null!=k)for(var z=0;z<k.length;z++){var H=k[z],F=H.items,N="withRescale"==Q.getHideAndShowBehavior(e)&&"hidden"==H.visibility;if(!N)if(F&&!N){var W=0,G=F.length-1;if(u){var j=$.getViewportMinMaxIndex(e,F);W=j.min,G=j.max}for(var U=W;U<=G;U++)if(null!=F[U]){D=$.getLowValue(F[U]),w=$.getHighValue(F[U]);var V=isNaN(F[U])?F[U].value:F[U];null!=D&&isFinite(D)&&(p=Math.min(p,D),d=Math.max(d,D)),null!=w&&isFinite(w)&&(p=Math.min(p,w),d=Math.max(d,w)),null!=V&&isFinite(V)&&(p=Math.min(p,V),d=Math.max(d,V))}}else D=$.getLowValue(H),w=$.getHighValue(H),V=H.value,null!=D&&isFinite(D)&&(p=Math.min(p,D),d=Math.max(d,D)),null!=w&&isFinite(w)&&(p=Math.min(p,w),d=Math.max(d,w)),null!=V&&isFinite(V)&&(p=Math.min(p,V),d=Math.max(d,V))}return n={min:p,max:d},e.getCache().putToCache(r,n),n},J.isAssignedToY2=function(e,t){if(!e.getOptionsCache().getFromCache("hasY2Assignment"))return!1;var i=J.getSeriesItem(e,t);return!(!i||"on"!=i.assignedToY2||!ne.isDualY(e))},J.getInitialSelection=function(e){var t=e.getOptions().selection,i=null!=e.getOptions().data;t||(t=[]);for(var r=e.getChartObjPeers(),n=0;n<t.length;n++){var a=null==t[n].id||i?t[n]:t[n].id;if(null!=t[n].id||t[n].series||t[n].group||(t[n]={id:a}),!(null==a||t[n].series&&t[n].group))for(var o=0;o<r.length;o++){var s=r[o];if(J.isEqualId(a,s.getDataItemId(),e.getCtx())){t[n].series=s.getSeries(),t[n].group=s.getGroup();break}}}return t},J.getCurrentSelection=function(e){var t=[],i=e.getSelectionHandler();if(i)for(var r=i.getSelectedIds(),n=0;n<r.length;n++){var a=r[n];t.push({series:a.series,group:a.group,id:a.id})}return t},J.hasVolumeSeries=function(e){return e.getOptionsCache().getFromCache("hasVolume")||!1},J.isDataSelected=function(e,t,i,r){var n=!isNaN(r)&&null!=r&&r>=0?J.getNestedDataItemId(e,t,i,r):J.getDataItemId(e,t,i),a=J.getSeries(e,t),o=J.getGroup(e,i),s=e.getOptions().selection;s||(s=[]);for(var l=0;l<s.length;l++){if(J.isEqualId(n,s[l],e.getCtx())||J.isEqualId(n,s[l].id,e.getCtx()))return!0;if(null==s[l].id&&J.isEqualId(a,s[l].series,e.getCtx())&&J.isEqualId(o,s[l].group,e.getCtx()))return!0}return!1},J.getDataLabel=function(e,t,i,r,n,a){var o,s=J.getDefaultDataLabel(e,t,i,r,n,a),l=e.getOptions().dataLabel;if(l&&!a){var h=J.getDataContext(e,t,i,r);if(h.label=s,"number"==typeof(o=l(h))){var u=re.getValueFormat(e,"label");o=re.formatValue(e,u,o)}}return o||s},J.getDefaultDataLabel=function(e,t,i,r,n,a){var o;if(a)o=J.getCumulativeValue(e,t,i);else{var s=!isNaN(r)&&null!=r&&r>=0?J.getNestedDataItem(e,t,i,r):J.getDataItem(e,t,i);if(!s)return null;o=s.label,"low"==n?o=o instanceof Array?o[0]:o:"high"==n&&(o=o instanceof Array?o[1]:null)}if(null!=o){if("number"==typeof o){var l,h,u,g=J.isAssignedToY2(e,t)&&e.y2Axis?e.y2Axis:e.yAxis;if(g){var d=g.getInfo();l=d.getGlobalMin(),h=d.getGlobalMax(),u=d.getMajorIncrement()}var p=re.getValueFormat(e,"label");return re.formatValue(e,p,o,l,h,u)}return o}return null},J.getStackCategory=function(e,t){var i=e.getCache().getFromCachedMap("stackCategory",t);return void 0!==i?i:(i=ne.isStacked(e)?J.getSeriesItem(e,t).stackCategory||null:J.getSeries(e,t)||null,e.getCache().putToCachedMap("stackCategory",t,i),i)},J.getStackCategories=function(e,t,i){var r=[],n=[],a={},o={},s=e.getCache().getFromCachedMap2D("stackCategories",t,i);if(s)return s;for(var l=J.getSeriesCount(e),h=0;h<l;h++)if(te.isSeriesRendered(e,h)||i){if(t){var u=te.getSeriesType(e,h);if("candlestick"!=u&&"boxPlot"!=u||(u="bar"),t!=u)continue}var g=J.getStackCategory(e,h);J.isAssignedToY2(e,h)?o[g]||(n.push(g),o[g]=!0):a[g]||(r.push(g),a[g]=!0)}return s={y:r,y2:n},e.getCache().putToCachedMap2D("stackCategories",t,i,s),s},J.getBarCategoryZ=function(e,t,i,r){for(var n=0,a=J.getSeriesCount(e),o=0;o<a;o++){var s=te.getSeriesType(e,o);if(("bar"==s||"candlestick"==s||"boxPlot"==s)&&J.getStackCategory(e,o)==t&&te.isSeriesRendered(e,o)){var l=J.isAssignedToY2(e,o);(r&&l||!r&&!l)&&(n=Math.max(n,J.getZValue(e,o,i,1)))}}return n},J.getBarInfo=function(t,i,r,n){var a,o,s=ne.isHorizontal(t),l=ne.isStacked(t),h=e.Agent.isRightToLeft(t.getCtx()),u=t.xAxis,g=te.isRangeSeries(t,i),d=te.getBarCategoryOffsetMap(t,r),p=J.getXValue(t,i,r),c=u.getUnboundedCoordAt(p),_=J.isAssignedToY2(t,i),f=_?t.y2Axis:t.yAxis,m=f.getBaselineCoord();if(g){var v=J.getLowValue(t,i,r),y=J.getHighValue(t,i,r);if(null==v||isNaN(v)||null==y||isNaN(y))return null;if((a=f.getBoundedCoordAt(v))==(o=f.getBoundedCoordAt(y))&&null==f.getCoordAt(v))return null}else{var S=J.getValue(t,i,r),C=J.getCumulativeValue(t,i,r);if(null==S||isNaN(S))return null;if((a=f.getBoundedCoordAt(C))==(o=l?f.getBoundedCoordAt(C-S):m)&&null==f.getCoordAt(C))return null}var A=J.getStackCategory(t,i),b=te.getBarWidth(t,i,r),x=l?te.getBarStackWidth(t,A,r,_):b;if("pixel"==te.getBarSpacing(t)&&"firefox"===e.Agent.browser){var M=b/(1-te.getBarGapRatio(t));b>1&&M-b<2&&(x=--b)}var O=d[_?"y2":"y"][A]+.5*(x-b),T=h&&!s?c-O-b:c+O,w=T+b,D=(T+w)/2,E=g?(a+o)/2:a;return{x1:T,x2:w,axisCoord:m,baseCoord:o,yCoord:a,dataPos:pe.convertAxisCoord(t,new e.Point(D,E),n),barWidth:b}},J.getMarkerPosition=function(t,i,r,n,a){var o,s,l=t.xAxis,h=J.isAssignedToY2(t,i)?t.y2Axis:t.yAxis,u=ne.isPolar(t),g=te.isRangeSeries(t,i),d=!isNaN(n)&&null!=n&&n>=0,p=J.getXValue(t,i,r),c=d?J.getValue(t,i,r,n):J.getCumulativeValue(t,i,r);if(ne.isBubble(t)){if(u&&c<h.getInfo().getViewportMin())return null;o=u?l.getCoordAt(p):l.getUnboundedCoordAt(p),s=h.getUnboundedCoordAt(c)}else if(g){var _=h.getCoordAt(J.getLowValue(t,i,r)),f=h.getCoordAt(J.getHighValue(t,i,r));o=l.getCoordAt(J.getXValue(t,i,r)),s=(_+f)/2}else o=l.getCoordAt(p),s=h.getCoordAt(c);return null==o||null==s?null:pe.convertAxisCoord(t,new e.Point(o,s),a)},J.getScatterBubbleMarkerPosition=function(t,i,r){var n=t.xAxis,a=t.yAxis,o=J.getXValue(t,i,r),s=J.getValue(t,i,r),l=n.getCoordAt(o),h=a.getCoordAt(s);return null==l||null==h?null:new e.Point(l,h)},J.isSeriesNegative=function(e,t){if(!e.getOptionsCache().getFromCache("hasNegativeValues"))return!1;var i=e.getOptionsCache().getFromCachedMap("isSeriesNegative",t);if(null!=i)return i;var r=J.getGroupCount(e);i=!0;for(var n=0;n<r;n++)if(J.getValue(e,t,n)>0){i=!1;break}return e.getOptionsCache().putToCachedMap("isSeriesNegative",t,i),i},J.getDataContext=function(e,t,i,r){var n,a=J.getSeriesItem(e,t),o=J.getDataItem(e,t,i),s=J.getNestedDataItem(e,t,i,r),l=e.getRawOptions(),h=ne.isPie(e)&&(null==t||t<0),u=e.getOptions();if(h){var g=u.translations.labelOther;n={id:g,series:g,value:oe.getOtherValue(e),color:u.styleDefaults.otherColor}}else if(s)(d=l.series[t].items[i])._noTemplate?d=d._itemData:delete d._itemData,n={id:J.getNestedDataItemId(e,t,i,r),data:[d,d.items[r]],value:J.getValue(e,t,i,r),y:J.getValue(e,t,i,r),color:te.getMarkerColor(e,t,i,r),itemData:u.series[t].items[i]._itemData};else if(o){var d;(d=l.series[t].items[i])._noTemplate?d=d._itemData:delete d._itemData,n={id:J.getDataItemId(e,t,i),data:d,value:J.getValue(e,t,i),targetValue:J.getTargetValue(e,t,i),x:J.getXValue(e,t,i),y:J.getValue(e,t,i),z:J.getZValue(e,t,i),low:J.getLowValue(e,t,i),high:J.getHighValue(e,t,i),open:o.open,close:o.close,volume:o.volume,color:te.getColor(e,t,i),itemData:u.series[t].items[i]._itemData}}else a&&(n={id:J.getSeries(e,t),color:te.getColor(e,t)});if(n){n.component=u._widgetConstructor,(h||s||o)&&(n.group=J.getGroup(e,i),n.groupData=J.getGroupsDataForContext(e)[i]),!h&&(s||o||a)&&(n.series=J.getSeries(e,t),n.seriesData=l.series[t]),ne.isPie(e)&&e.pieChart&&(n.totalValue=e.pieChart.getTotalValue());var p=e.getOptionsCache().getFromCachedMap2D("barDims",t,i);p&&(n.dimensions=p),n=e.getCtx().fixRendererContext(n)}return n||{}},J.getGroupsDataForContext=function(e){var t=e.getOptionsCache().getFromCache("groupsDataArray");if(!t){var i=e.getRawOptions();t=J._getNestedGroupsData(i.groups),e.getOptionsCache().putToCache("groupsDataArray",t)}return t},J._getNestedGroupsData=function(e){if(!e)return[];for(var t=[],i=0;i<e.length;i++){var r=e[i];if(r.groups){for(var n=J._getNestedGroupsData(r.groups),a=0;a<n.length;a++)n[a].unshift(r);t=t.concat(n)}else t.push([r])}return t},J._computeOutermostBarMap=function(e){if(!e.getOptionsCache().getFromCache("outermostBar")){for(var t={},i=J.getSeriesCount(e),r=e.getOptionsCache().getFromCache("hasNegativeValues"),n=i-1;n>=0;n--)if(te.isSeriesRendered(e,n)&&"bar"==te.getSeriesType(e,n)){var a=(J.getStackCategory(e,n)||"")+J.isAssignedToY2(e,n);t[a]?t[a].push(n):t[a]=[n]}var o=J.getGroupCount(e);for(var s in t)for(var l=t[s],h=0;h<o;h++)for(var u=!1,g=!1,d=0;d<l.length&&!(!r&&u||u&&g);d++)if(n=l[d],te.isDataItemRendered(e,n,h)){var p=J.getValue(e,n,h);null==p?e.getOptionsCache().putToCachedMap2D("outermostBar",n,h,!1):!u&&p>=0?(u=!0,e.getOptionsCache().putToCachedMap2D("outermostBar",n,h,!0)):!g&&p<0&&(g=!0,e.getOptionsCache().putToCachedMap2D("outermostBar",n,h,!0))}}},J.isOutermostBar=function(e,t,i){return J._computeOutermostBarMap(e),e.getOptionsCache().getFromCachedMap2D("outermostBar",t,i)||!1},J.isDataItemFiltered=function(e,t,i){var r=J.getDataItem(e,t,i);return!(!r||!r._filtered)},J.getFilteredChartObjPeers=function(e){if(!e.getCache().getFromCache("dataFiltered"))return[];var t=e.getCache().getFromCache("filteredChartObjPeers");if(!t){t=[];for(var i=0;i<J.getSeriesCount(e);i++)for(var r=0;r<J.getGroupCount(e);r++){var a;J.isDataItemFiltered(e,i,r)&&(a="bar"==te.getSeriesType(e,i)?J.getBarInfo(e,i,r).dataPos:J.getMarkerPosition(e,i,r),t.push(new n(e,[],i,r,null,a)))}e.getCache().putToCache("filteredChartObjPeers",t)}return t};var Q=new Object;e.Obj.createSubclass(Q,e.Obj),Q.getHideAndShowBehavior=function(e){return e.getOptions().hideAndShowBehavior},Q.getHoverBehavior=function(e){return e.getOptions().hoverBehavior},Q.setVisibility=function(e,t,i){var r=$.getRefObj(e,t);null!=r&&(r.visibility=i);var n=te.getHiddenCategories(e),a=n.indexOf(t);"hidden"==i&&a<0?n.push(t):"visible"==i&&a>=0&&n.splice(a,1);var o=e.getOptions();if(o&&o.legend&&o.legend.sections){for(var s=0;s<o.legend.sections.length;s++){var l=o.legend.sections[s];if(l&&l.items)for(var h=0;h<l.items.length;h++)l.items[h].id==t&&(l.items[h].categoryVisibility=i)}return!0}return!1},Q.isScrollable=function(e){return!!ne.isScrollSupported(e)&&"off"!=e.getOptions().zoomAndScroll},Q.isZoomable=function(e){if(!ne.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"live"==t||"delayed"==t},Q.getZoomDirection=function(e){return ne.isScatterBubble(e)?e.getOptions().zoomDirection:"auto"},Q.isLiveScroll=function(e){if(!ne.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"live"==t||"liveScrollOnly"==t},Q.isDelayedScroll=function(e){if(!ne.isScrollSupported(e))return!1;var t=e.getOptions().zoomAndScroll;return"delayed"==t||"delayedScrollOnly"==t},Q.processIds=function(e,t){for(var i=[],r=0;r<t.length;r++){var n=t[r];if(n.series==oe.OTHER_SLICE_SERIES_ID){var a=oe.getOtherSliceIds(e);i=i.concat(a)}else i.push(n)}return i},Q.adjustBounds=function(e){null!=e.x&&(e.x-=1),null!=e.w&&(e.w+=2),null!=e.y&&(e.y-=1),null!=e.h&&(e.h+=2)},Q.getBoundedObjects=function(e,t){for(var i=e.getChartObjPeers().concat(J.getFilteredChartObjPeers(e)),r=[],n=0;n<i.length;n++){var a=i[n],o=a.getDataPosition();if(o){o=e.getPlotArea().localToStage(o);var s=null==t.x||o.x>=t.x&&o.x<=t.x+t.w,l=null==t.y||o.y>=t.y&&o.y<=t.y+t.h;s&&l&&r.push(a)}}return r},Q.getAxisBounds=function(t,i,r){var n=t.getPlotArea(),a=n.stageToLocal(new e.Point(i.x,i.y)),o=n.stageToLocal(new e.Point(i.x+i.w,i.y+i.h));null==i.x&&(a.x=null,o.x=null),null==i.y&&(a.y=null,o.y=null);var s=Q._convertToAxisCoord(t,a.x,o.x,a.y,o.y),l={},h={},u={},g={};return t.xAxis&&(l=Q._getAxisMinMax(t.xAxis,s.xMin,s.xMax,r),g=Q.getAxisStartEndGroup(t.xAxis,l.min,l.max)),t.yAxis&&(h=Q._getAxisMinMax(t.yAxis,s.yMin,s.yMax,r)),t.y2Axis&&(u=Q._getAxisMinMax(t.y2Axis,s.yMin,s.yMax,r)),{xMin:l.min,xMax:l.max,unchanged:l.unchanged,yMin:h.min,yMax:h.max,y2Min:u.min,y2Max:u.max,startGroup:g.startGroup,endGroup:g.endGroup}},Q._getAxisMinMax=function(e,t,i,r){if(null==t||null==i)return{min:null,max:null};var n=e.getUnboundedLinearValueAt(t),a=e.getUnboundedLinearValueAt(i);if(r){var o=e.getInfo().getMinimumExtent();if(a-n<o){var s=(a+n)/2;a=s+o/2,n=s-o/2}return Q._limitToGlobal(e,n,a)}return Q.getActualMinMax(e,n,a)},Q.getAxisBoundsByDelta=function(e,t,i,r,n){var a=Q._convertToAxisCoord(e,t,i,r,n),o=Q.getZoomDirection(e),s={},l={},h={},u={};return e.xAxis&&"y"!=o&&(s=Q._getAxisMinMaxByDelta(e.xAxis,a.xMin,a.xMax),u=Q.getAxisStartEndGroup(e.xAxis,s.min,s.max)),e.yAxis&&"x"!=o&&(l=Q._getAxisMinMaxByDelta(e.yAxis,a.yMin,a.yMax)),e.y2Axis&&(h=Q._getAxisMinMaxByDelta(e.y2Axis,a.yMin,a.yMax)),{xMin:s.min,xMax:s.max,unchanged:s.unchanged,yMin:l.min,yMax:l.max,y2Min:h.min,y2Max:h.max,startGroup:u.startGroup,endGroup:u.endGroup}},Q._getAxisMinMaxByDelta=function(e,t,i){var r=e.getLinearViewportMin(),n=e.getLinearViewportMax();if(i==t&&e.isFullViewport())return Q.getActualMinMax(e,r,n);var a=e.getUnboundedLinearValueAt(t)-e.getUnboundedLinearValueAt(0),o=e.getUnboundedLinearValueAt(i)-e.getUnboundedLinearValueAt(0),s=1,l=n+o-(r+a),h=e.getInfo().getMinimumExtent();return t!=i&&l<h&&(s=(n-r-h)/(a-o)),r+=a*s,n+=o*s,Q._limitToGlobal(e,r,n)},Q._convertToAxisCoord=function(t,i,r,n,a){var o={},s=e.Agent.isRightToLeft(t.getCtx());return ne.isHorizontal(t)?(o.xMin=n,o.xMax=a,o.yMin=s?r:i,o.yMax=s?i:r):(o.xMin=s?r:i,o.xMax=s?i:r,o.yMin=a,o.yMax=n),o},Q._limitToGlobal=function(e,t,i){var r=e.getLinearGlobalMin(),n=e.getLinearGlobalMax();return i-t>=n-r?(t=r,i=n):t<r?(i+=r-t,t=r):i>n&&(t-=i-n,i=n),Q.getActualMinMax(e,t,i)},Q.getActualMinMax=function(e,t,i){var r={min:e.linearToActual(t),max:e.linearToActual(i)};if(e.isGroupAxis()){var n=e.getLinearViewportMin(),a=e.getLinearViewportMax();Math.abs(t-n)<1e-4&&Math.abs(i-a)<1e-4&&(r.unchanged=!0)}return r},Q.getAxisStartEndGroup=function(e,t,i){if(e.isGroupAxis()&&null!=t&&null!=i){var r=Math.ceil(t),n=Math.floor(i);if(n>=r)return{startGroup:e.getInfo().getGroup(r),endGroup:e.getInfo().getGroup(n)}}return{startGroup:null,endGroup:null}},Q.setInitialSelection=function(e,t){var i=e.getSelectionHandler();if(i)if(t&&0!=t.length){for(var r=[],n=0;n<t.length;n++)null!=t[n].id?r.push(t[n].id):null!=t[n].series&&null!=t[n].group&&r.push(J.createDataItemId(t[n].series,t[n].group));for(var a=new(e.getCtx().KeySetImpl)(r),o=e.getChartObjPeers(),s=[],l=0;l<o.length;l++){var h=o[l];if(h.isSelectable()){var u=h.getDataItemId(),g=J.createDataItemId(h.getSeries(),h.getGroup());(a.has(u)||a.has(g))&&s.push(h.getId())}}i.processInitialSelections(s,o)}else i.clearSelection()},Q.getKeyboardNavigables=function(e){var t=[];if(ne.isPie(e))for(var i=e.pieChart.__getSlices(),r=0;r<i.length;r++)te.isSeriesRendered(e,i[r].getSeriesIndex())&&t.push(i[r]);else{var n=e.getChartObjPeers();for(r=0;r<n.length;r++)n[r].isNavigable()&&t.push(n[r])}return t},Q.isSeriesDrillable=function(e,t){var i=J.getSeriesItem(e,t),r=null!=i?i.drilling:"inherit";return"on"==r||"off"!=r&&("on"==(r=e.getOptions().drilling)||"seriesOnly"==r)},Q.isDataItemDrillable=function(e,t,i,r){var n=J.getNestedDataItem(e,t,i,r);n||(n=J.getDataItem(e,t,i));var a=null!=n?n.drilling:"inherit";return"on"==a||"off"!=a&&"on"==(a=e.getOptions().drilling)},Q.addEventData=function(e,t){var i=J.getSeriesIndex(e,t.series),r=J.getGroupIndex(e,t.group),n=J.getNestedDataItemIndex(e,i,r,t.id),a=J.getDataContext(e,i,r,n);a&&(t.data=a.data,t.itemData=a.itemData,t.seriesData=a.seriesData,a.groupData?t.groupData=a.groupData:null!=r&&(t.groupData=J.getGroupsDataForContext(e)[r]))},Q.isPlotAreaDraggable=function(e){var t=e.getOptions(),i=t.dnd?t.dnd.drag.items:{};return Object.keys(i).length>0},Q.isPlotAreaDropTarget=function(e){var t=e.getOptions(),i=t.dnd?t.dnd.drop.plotArea:{};return Object.keys(i).length>0},Q.addPlotAreaDnDBackground=function(t,i,r,n){var a=Q.isPlotAreaDraggable(t);(Q.isPlotAreaDropTarget(t)||a)&&(background=new e.Rect(t.getCtx(),0,0,n?r.w:r.h,n?r.h:r.w),background.setInvisibleFill(),i.addChild(background),t.getCache().putToCache("plotAreaBackground",background),a&&background.setClassName("oj-draggable"))};var $=new Object;e.Obj.createSubclass($,e.Obj),$.getRefObjs=function(e){var t=$.getAxisRefObjs(e,"x"),i=$.getAxisRefObjs(e,"y"),r=$.getAxisRefObjs(e,"y2");return t.concat(i,r)},$.getAxisRefObjs=function(e,t){var i=e.getOptions();return i&&i[t+"Axis"]&&i[t+"Axis"].referenceObjects?i[t+"Axis"].referenceObjects:[]},$.getType=function(e){return"area"==e.type?"area":"line"},$.getLocation=function(e){return"front"==e.location?"front":"back"},$.getColor=function(e){return e.color?e.color:"#333333"},$.getLineWidth=function(e){return e.lineWidth?e.lineWidth:1},$.getLineType=function(e){return e.lineType?e.lineType:"straight"},$.isObjectRendered=function(t,i){var r=te.getHiddenCategories(t);if(r.length>0){var n=$.getRefObjCategories(i);if(n&&e.ArrayUtils.hasAnyItem(r,n))return!1}return!("hidden"==i.visibility)},$.getId=function(e){return null!=e.id?e.id:e.text},$.getRefObjCategories=function(e){return e.categories?e.categories:[$.getId(e)]},$.getRefObj=function(e,t){for(var i=$.getRefObjs(e),r=0;r<i.length;r++)if($.getId(i[r])==t)return i[r]},$.getLowValue=function(e){return null==e?null:e.low},$.getHighValue=function(e){return null==e?null:e.high},$.getXValue=function(e,t,i){return J.getXValueFromItem(e,t[i],i)},$.getViewportMinMaxIndex=function(e,t){var i=Z.getXAxisViewportMinMax(e,!0),r=Z.hasGroupAxis(e),n=i.min,a=0;if(null!=n)if(r)a=Math.ceil(n);else for(var o=0;o<t.length;o++)if($.getXValue(e,t,o)>=n){a=o;break}var s=i.max,l=t.length-1;if(null!=l)if(r)l=Math.floor(s);else for(o=t.length-1;o>=a;o--)if(J.getXValue(e,t,o)<=s){l=o;break}return{min:a,max:l}};var ee=new Object;e.Obj.createSubclass(ee,e.Obj),ee.getBarFill=function(e,t,i,r){var n=te.getColor(e,t,i),a=te.getPattern(e,t,i);return ee.getRectangleFill(e,n,a,r)},ee.getRectangleFill=function(t,i,r,n){var a=te.getSeriesEffect(t);if(r)return new e.PatternFill(r,i);if("gradient"==a&&n>3){var o,s,l=ne.isHorizontal(t)?270:0;return o=[e.ColorUtils.adjustHSL(i,0,-.09,.04),e.ColorUtils.adjustHSL(i,0,-.04,-.05)],s=[0,1],new e.LinearGradientFill(l,o,null,s)}return new e.SolidFill(i)},ee.getAreaFill=function(t,i){var r,n="lineWithArea"==te.getSeriesType(t,i),a=J.getSeriesItem(t,i);a&&a.areaColor?r=a.areaColor:(r=te.getColor(t,i),n&&(r=e.ColorUtils.setAlpha(r,.2)));var o=te.getPattern(t,i),s=te.getSeriesEffect(t);if(o)return new e.PatternFill(o,r);if("gradient"==s){var l,h,u=ne.isHorizontal(t)?180:270;if(n){var g=e.ColorUtils.getAlpha(r);l=[e.ColorUtils.setAlpha(r,Math.min(g+.2,1)),e.ColorUtils.setAlpha(r,Math.max(g-.15,0))],h=[0,1]}else l=[e.ColorUtils.adjustHSL(r,0,-.09,.04),e.ColorUtils.adjustHSL(r,0,-.04,-.05)],h=[0,1];return new e.LinearGradientFill(u,l,null,h)}return new e.SolidFill(r)},ee.getMarkerFill=function(t,i,r,n){var a=te.getMarkerColor(t,i,r,n),o=te.getPattern(t,i,r,n);if(o)return new e.PatternFill(o,a);if(ne.isBubble(t)&&"gradient"==te.getSeriesEffect(t)){var s=[e.ColorUtils.adjustHSL(a,0,-.09,.04),e.ColorUtils.adjustHSL(a,0,-.04,-.05)];return new e.LinearGradientFill(270,s,null,[0,1])}return new e.SolidFill(a)},ee.getFunnelPyramidSliceFill=function(t,i,r,n,a){var o,s=te.getPattern(t,i,0),l=te.getSeriesEffect(t);if(s&&!a)return("vertical"==t.getOptions().orientation||ne.isPyramid(t))&&(o=e.Agent.isRightToLeft(t.getCtx())?new e.Matrix(0,-1,1,0):new e.Matrix(0,1,-1,0)),new e.PatternFill(s,r,null,o);if("gradient"==l){var h,u,g=ne.isPyramid(t)?180:90;return"on"==t.getOptions().styleDefaults.threeDEffect?(h=[e.ColorUtils.adjustHSL(r,0,0,-.1),e.ColorUtils.adjustHSL(r,0,0,.12),r],u=[0,.65,1]):(h=[e.ColorUtils.adjustHSL(r,0,-.09,.04),e.ColorUtils.adjustHSL(r,0,-.04,-.05)],u=[0,1]),new e.LinearGradientFill(g,h,null,u,[n.x,n.y,n.w,n.h])}return new e.SolidFill(r)};var te=new Object;e.Obj.createSubclass(te,e.Obj),te._SERIES_TYPE_RAMP=["bar","line","area"],te.getSeriesType=function(e,t){var i=e.getOptionsCache().getFromCachedMap("seriesType",t);if(i)return i;if(!ne.isBLAC(e))return e.getOptionsCache().putToCachedMap("seriesType",t,"auto"),"auto";var r=J.getSeriesItem(e,t);if(i=r?r.type:null,ne.isStock(e)||"candlestick"!=i||(i="auto"),!i||"auto"==i)if(ne.isBar(e))i="bar";else if(ne.isLine(e))i="line";else if(ne.isArea(e))i="area";else if(ne.isLineWithArea(e))i="lineWithArea";else if(ne.isStock(e))i="candlestick";else if(ne.isBoxPlot(e))i="boxPlot";else if(ne.isCombo(e)){var n=J.getSeriesStyleIndex(e,t)%te._SERIES_TYPE_RAMP.length;i=te._SERIES_TYPE_RAMP[n]}return e.getOptionsCache().putToCachedMap("seriesType",t,i),i},te.isRangeSeries=function(e,t){var i=e.getOptionsCache();if(!i.getFromCache("hasLowHighSeries"))return!1;var r=i.getFromCachedMap("isRange",t);if(null!=r)return r;r=!1;var n=te.getSeriesType(e,t);if("bar"==n||"area"==n)for(var a=0;a<J.getGroupCount(e);a++)if(null!=J.getLowValue(e,t,a)||null!=J.getHighValue(e,t,a)){r=!0;break}return e.getOptionsCache().putToCachedMap("isRange",t,r),r},te.getSeriesEffect=function(e){return e.getOptions().styleDefaults.seriesEffect},te.getColor=function(e,t,i){var r=J.getDataItem(e,t,i);if(r&&r.color)return r.color;var n=J.getSeriesItem(e,t);if(n&&n.color)return n.color;if("candlestick"==te.getSeriesType(e,t))return te.getStockItemColor(e,t,i);var a=e.getOptions().styleDefaults.colors;return a[J.getSeriesStyleIndex(e,t)%a.length]},te.getStockItemColor=function(e,t,i){var r=e.getOptions();return J.isStockValueRising(e,t,i)?r.styleDefaults.stockRisingColor:r.styleDefaults.stockFallingColor},te.getStockVolumeColor=function(e,t,i){var r=J.getDataItem(e,t,i);if(r&&r.color)return r.color;var n=e.getOptions();return n.styleDefaults.stockVolumeColor?n.styleDefaults.stockVolumeColor:te.getStockItemColor(e,t,i)},te.getSplitterPosition=function(e){var t=e.getOptions().splitterPosition;return null!=t?t:ne.isStock(e)?.8:.5},te.getPattern=function(t,i,r,n){var a=J.getNestedDataItem(t,i,r,n);if(a&&a.pattern&&"auto"!=a.pattern)return a.pattern;var o=J.getDataItem(t,i,r);if(o&&o.pattern&&"auto"!=o.pattern)return o.pattern;var s=te.getSeriesType(t,i);if(("line"==s||"area"==s)&&null!=r)return null;var l=J.getSeriesItem(t,i);if(l&&l.pattern&&"auto"!=l.pattern)return l.pattern;if("pattern"==te.getSeriesEffect(t)){if(ne.isStock&&"candlestick"==te.getSeriesType(t,i)){var h=J.isStockValueRising(t,i,r),u=e.Agent.isRightToLeft(t.getCtx());return h?u?"smallDiagonalLeft":"smallDiagonalRight":u?"smallDiagonalRight":"smallDiagonalLeft"}var g=t.getOptions().styleDefaults.patterns;return g[J.getSeriesStyleIndex(t,i)%g.length]}return null},te.getMarkerBorderColor=function(t,i,r,n){var a=te.getBorderColor(t,i,r,n);if(a)return a;if(te.getDataItemGaps(t)>0&&"lineWithArea"!=te.getSeriesType(t,i))return te.getBackgroundColor(t,!0);if(ne.isBubble(t)&&"gradient"!=te.getSeriesEffect(t)){var o=te.getMarkerColor(t,i,r);if(o)return e.ColorUtils.adjustHSL(o,0,.15,-.25)}return null},te.getBorderColor=function(e,t,i,r){var n=J.getNestedDataItem(e,t,i,r);if(n&&n.borderColor)return n.borderColor;var a=J.getDataItem(e,t,i);if(a&&a.borderColor)return a.borderColor;var o=J.getSeriesItem(e,t);if(o&&o.borderColor)return o.borderColor;var s=e.getOptions().styleDefaults;return"auto"!=s.borderColor?s.borderColor:null},te.getBorderWidth=function(e,t,i,r){var n=J.getNestedDataItem(e,t,i,r);if(n&&null!=n.borderWidth)return n.borderWidth;var a=J.getDataItem(e,t,i);if(a&&null!=a.borderWidth)return a.borderWidth;var o=J.getSeriesItem(e,t);if(o&&null!=o.borderWidth)return o.borderWidth;var s=e.getOptions().styleDefaults;return"auto"!=s.borderWidth?s.borderWidth:ne.isScatterBubble(e)||ne.isLineArea(e)?1.25:1},te.getMarkerColor=function(e,t,i,r){if(!te.isMarkerDisplayed(e,t,i,r))return te.getColor(e,t,i);var n=J.getNestedDataItem(e,t,i,r);if(n&&n.color)return n.color;var a=J.getDataItem(e,t,i);if(a&&a.color)return a.color;var o=J.getSeriesItem(e,t);return o&&o.markerColor?o.markerColor:e.getOptions().styleDefaults.markerColor||te.getColor(e,t,i)},te.getMarkerShape=function(e,t,i,r){var n=e.getOptions(),a=n.styleDefaults.markerShape,o=J.getSeriesItem(e,t);o&&o.markerShape&&(a=o.markerShape);var s=J.getDataItem(e,t,i);s&&s.markerShape&&(a=s.markerShape);var l=J.getNestedDataItem(e,t,i,r);if(l&&l.markerShape&&(a=l.markerShape),"auto"==a)if(ne.isBubble(e)||"boxPlot"==te.getSeriesType(e,t)||te.isRangeSeries(e,t))a="circle";else{var h=J.getSeriesStyleIndex(e,t),u=n.styleDefaults.shapes;a=u[h%u.length]}return a},te.getMarkerSize=function(e,t,i,r){var n,a=J.getNestedDataItem(e,t,i,r);if(a&&null!=a.markerSize)n=Number(a.markerSize);else{var o=J.getDataItem(e,t,i);if(o&&null!=o.markerSize)n=Number(o.markerSize);else{var s=J.getSeriesItem(e,t);n=s&&null!=s.markerSize?Number(s.markerSize):Number(e.getOptions().styleDefaults.markerSize)}}return ne.isOverview(e)&&(n=Math.ceil(.6*n)),n},te.isMarkerDisplayed=function(e,t,i,r){var n,a=J.getNestedDataItem(e,t,i,r);if(a&&null!=a.markerDisplayed)n=a.markerDisplayed;else{var o=J.getDataItem(e,t,i);if(o&&null!=o.markerDisplayed)n=o.markerDisplayed;else{var s=J.getSeriesItem(e,t);n=s&&null!=s.markerDisplayed?s.markerDisplayed:e.getOptions().styleDefaults.markerDisplayed}}return"on"==n||"off"!=n&&(ne.isScatterBubble(e)||"boxPlot"==te.getSeriesType(e,t)||"none"==te.getLineType(e,t))},te.getImageSource=function(e,t,i,r,n){var a=J.getNestedDataItem(e,t,i,r);if(a&&a[n])return a[n];var o=J.getDataItem(e,t,i);if(o&&o[n])return o[n];var s=J.getSeriesItem(e,t);return s&&s[n]?s[n]:void 0},te.getLineWidth=function(e,t){var i,r=J.getSeriesItem(e,t),n=e.getOptions();return i=r&&r.lineWidth?r.lineWidth:n.styleDefaults.lineWidth?n.styleDefaults.lineWidth:"lineWithArea"==te.getSeriesType(e,t)?2:3,ne.isOverview(e)&&(i=Math.ceil(.6*i)),i},te.getLineStyle=function(e,t){var i=J.getSeriesItem(e,t);return i&&i.lineStyle?i.lineStyle:e.getOptions().styleDefaults.lineStyle},te.getLineType=function(e,t){var i,r=J.getSeriesItem(e,t);return"auto"==(i=r&&r.lineType?r.lineType:e.getOptions().styleDefaults.lineType)&&(i=ne.isScatterBubble(e)?"none":"straight"),(ne.isPolar(e)||ne.isScatterBubble(e))&&("centeredSegmented"==i&&(i="segmented"),"centeredStepped"==i&&(i="stepped")),i},te.getBarSpacing=function(e){return e.getOptions().__sparkBarSpacing},te.getBarGapRatio=function(e){var t=e.getCache().getFromCache("barGapRatio");if(t)return t;if("string"==typeof(t=e.getOptions().styleDefaults.barGapRatio)&&"%"==t.slice(-1)&&(t=Number(t.slice(0,-1))/100),null!=t&&!isNaN(t))return t;var i=J.getStackCategories(e,"bar"),r=i.y.length,n=i.y2.length,a=ne.isSplitDualY(e)?Math.max(r,n):r+n;return t=ne.isPolar(e)?1==a?0:.25:1==a?.37+.26/J.getViewportGroupCount(e):.25,e.getCache().putToCache("barGapRatio",t),t},te.getMaxBarWidth=function(e){var t=e.getOptions().styleDefaults.maxBarWidth;return null==t||ne.isPolar(e)?1/0:t},te.getBarWidth=function(e,t,i){e.getOptionsCache().getFromCache("hasConstantZValue")&&(t=0,i=0);var r=e.getCache().getFromCachedMap2D("barWidth",t,i);if(null!=r)return r;var n=J.getZValue(e,t,i,1)/e.getOptions()._averageGroupZ;return r=Math.min(n*te.getGroupWidth(e),te.getMaxBarWidth(e)),e.getCache().putToCachedMap2D("barWidth",t,i,r),r},te.getBarStackWidth=function(e,t,i,r){e.getOptionsCache().getFromCache("hasConstantZValue")&&(i=0);var n=r?"y2BarStackWidth":"yBarStackWidth",a=e.getCache().getFromCachedMap2D(n,t,i);if(null!=a)return a;var o=J.getBarCategoryZ(e,t,i,r)/e.getOptions()._averageGroupZ;return a=Math.min(o*te.getGroupWidth(e),te.getMaxBarWidth(e)),e.getCache().putToCachedMap2D(n,t,i,a),a},te.getBarCategoryOffsetMap=function(e,t){e.getOptionsCache().getFromCache("hasConstantZValue")&&(t=0);var i=e.getCache().getFromCachedMap("barCategoryOffsetMap",t);if(i)return i;var r,n=ne.isStacked(e),a=J.getStackCategories(e,"bar"),o=Z.isMixedFrequency(e),s=ne.isSplitDualY(e),l={},h={},u=0,g=0;if(n){for(p=0;p<a.y.length;p++)r=te.getBarStackWidth(e,a.y[p],t,!1),o?l[a.y[p]]=-.5*r:(l[a.y[p]]=u,u+=r);for(s||(g=u),p=0;p<a.y2.length;p++)r=te.getBarStackWidth(e,a.y2[p],t,!0),o?h[a.y2[p]]=-.5*r:(h[a.y2[p]]=g,g+=r);s||(u=g)}else for(var d=J.getSeriesCount(e),p=0;p<d;p++){var c=te.getSeriesType(e,p);if(("bar"==c||"candlestick"==c||"boxPlot"==c)&&te.isSeriesRendered(e,p)){var _=J.isAssignedToY2(e,p),f=J.getStackCategory(e,p);r=te.getBarWidth(e,p,t),_?o?h[f]=-.5*r:(h[f]=g,g+=r):o?l[f]=-.5*r:(l[f]=u,u+=r)}}for(var f in l)l[f]-=s||n?u/2:(u+g)/2;for(var f in h)h[f]-=s||n?g/2:(u+g)/2-u;return i={y:l,y2:h},e.getCache().putToCachedMap("barCategoryOffsetMap",t,i),i},te.getDataItemGaps=function(e){var t=e.getOptionsCache().getFromCache("dataItemGaps");if(null!=t)return t;var i=e.getOptions();if(null!=i.styleDefaults.sliceGaps)t=i.styleDefaults.sliceGaps;else{var r=i.styleDefaults.dataItemGaps;"auto"==r&&(r="on"==i.styleDefaults.threeDEffect?"0%":"50%");var n=r&&r.indexOf?r.indexOf("%"):-1;t=n>=0?(r=r.substring(0,n))/100:0}return e.getOptionsCache().putToCache("dataItemGaps",t),t},te.isSelectable=function(e,t,i){var r=J.getSeriesItem(e,t);return(!r||"off"!=r._selectable)&&e.isSelectionSupported()&&null!=t&&t>=0&&null!=i&&i>=0},te.isSeriesRendered=function(t,i){var r=te.getHiddenCategories(t);return!(r.length>0&&e.ArrayUtils.hasAnyItem(r,J.getCategories(t,i)))},te.isDataItemRendered=function(t,i,r,n){var a,o=!isNaN(n)&&null!=n&&n>=0;if(!o&&void 0!==(a=t.getOptionsCache().getFromCachedMap2D("isDataItemRendered",i,r)))return a;if(a=!0,te.isSeriesRendered(t,i)){var s=te.getHiddenCategories(t);s.length>0&&((ne.isPie(t)||ne.isFunnel(t)||ne.isPyramid(t))&&(r=0),e.ArrayUtils.hasAnyItem(s,J.getCategories(t,i,r))&&(a=!1),e.ArrayUtils.hasAnyItem(s,J.getCategories(t,i,r,n))&&(a=!1))}else a=!1;return o||t.getOptionsCache().putToCachedMap2D("isDataItemRendered",i,r,a),a},te.getAnimationOnDisplay=function(e){return e.getOptions().animationOnDisplay},te.getAnimationOnDataChange=function(e){return e.getOptions().animationOnDataChange},te.getAnimationDuration=function(t){return e.CSSStyle.getTimeMilliseconds(t.getOptions().styleDefaults.animationDuration)/1e3},
te.getAnimationIndicators=function(e){return e.getOptions().styleDefaults.animationIndicators},te.getAnimationUpColor=function(e){return e.getOptions().styleDefaults.animationUpColor},te.getAnimationDownColor=function(e){return e.getOptions().styleDefaults.animationDownColor},te.getHiddenCategories=function(e){var t=e.getOptions();return t.hiddenCategories||(t.hiddenCategories=[]),t.hiddenCategories},te.getHighlightedCategories=function(e){var t=e.getOptions();return t.highlightedCategories||(t.highlightedCategories=[]),t.highlightedCategories},te.getSelectedInnerColor=function(e){return e.getOptions().styleDefaults.selectedInnerColor},te.getSelectedOuterColor=function(e){return e.getOptions().styleDefaults.selectedOuterColor},te.isSelectionHighlighted=function(e){var t=e.getOptions().styleDefaults.selectionEffect;return"highlight"==t||"highlightAndExplode"==t},te.isSelectionExploded=function(e){var t=e.getOptions().styleDefaults.selectionEffect;return"explode"==t||"highlightAndExplode"==t},te.getDataLabelStyle=function(t,i,r,n,a,o,s){var l,h=[];!a||"bar"!=te.getSeriesType(t,i)&&!ne.isBubble(t)||"center"!=o&&"inBottom"!=o&&"inTop"!=o&&"inRight"!=o&&"inLeft"!=o?h.push(new e.CSSStyle("color: #333333;")):(l=null!=te.getPattern(t,i,r,n)?"#000000":e.ColorUtils.getContrastingTextColor(a),h.push(new e.CSSStyle("color: "+l+";"))),h.push(te._parseLowHighArray(t.getOptions().styleDefaults.dataLabelStyle,s));var u=J.getDataItem(t,i,r);u&&h.push(new e.CSSStyle(te._parseLowHighArray(u.labelStyle,s)));var g=J.getNestedDataItem(t,i,r,n);return g&&h.push(new e.CSSStyle(te._parseLowHighArray(g.labelStyle,s))),l&&e.Agent.isHighContrast()&&h.push(new e.CSSStyle("color: "+l+";")),e.CSSStyle.mergeStyles(h)},te.getDataLabelPosition=function(t,i,r,n,a,o){var s,l=J.getNestedDataItem(t,i,r,n),h=J.getDataItem(t,i,r);if(o)s="outsideBarEdge";else if((s=l&&l.labelPosition?l.labelPosition:h.labelPosition)||(s=t.getOptions().styleDefaults.dataLabelPosition),"none"==(s=te._parseLowHighArray(s,a)))return"none";var u=e.Agent.isRightToLeft(t.getCtx()),g=ne.isHorizontal(t),d=ne.isPolar(t);if(ne.isFunnel(t)||ne.isPyramid(t))return"center";if("bar"==te.getSeriesType(t,i)){if("center"==s||d)return"center";var p,c=ne.isStacked(t);if("insideBarEdge"!=s){if(c&&!o)return"center";"outsideBarEdge"!=s&&(s="insideBarEdge")}if("insideBarEdge"==s&&!c){var _,f=t.getOptions().styleDefaults.dataLabelStyle,m=h.labelStyle?e.CSSStyle.mergeStyles([f,new e.CSSStyle(h.labelStyle)]):f;if(g){var v=J.getDataLabel(t,i,r,n,a);_=e.TextUtils.getTextStringWidth(t.getCtx(),v,m)}else _=e.TextUtils.getTextStringHeight(t.getCtx(),m);var y=J.getBarInfo(t,i,r);(y?Math.abs(y.baseCoord-y.yCoord):0)<=_&&(s="outsideBarEdge")}return p="low"==a?h.low<=h.high:"high"==a?h.high<h.low:J.getValue(t,i,r,n)<0,"outsideBarEdge"==s?g?!p&&!u||p&&u?"right":"left":p?"bottom":"top":g?!p&&!u||p&&u?"inRight":"inLeft":p?"inBottom":"inTop"}if("center"==s)return"center";if("belowMarker"==s)return"bottom";if("aboveMarker"==s)return"top";if("afterMarker"!=s&&"beforeMarker"!=s){if(ne.isBubble(t))return"center";if("low"!=a||d)if("high"!=a||d)s="afterMarker";else{if(!g)return"top";s="afterMarker"}else{if(!g)return"bottom";s="beforeMarker"}}return!u&&"afterMarker"==s||u&&"beforeMarker"==s?"right":"left"},te._parseLowHighArray=function(e,t){return e instanceof Array?"high"==t?e[1]:e[0]:e},te.isOverviewRendered=function(e){var t=e.getOptions();return ne.isOverviewSupported(e)&&"off"!=t.overview.rendered},te.getOverviewHeight=function(e){var t=e.getOptions().overview.height;return null==t&&(t=Z.hasTimeAxis(e)?.25:.2),te.getSizeInPixels(t,e.getHeight())},te.getSizeInPixels=function(e,t){if("string"==typeof e){if("%"==e.slice(-1))return t*Number(e.slice(0,-1))/100;if("px"==e.slice(-2))return Number(e.slice(0,-2));e=Number(e)}return"number"==typeof e?e<=1?t*e:e:0},te.getBackgroundColor=function(e,t){var i=e.getOptions();return i.plotArea.backgroundColor?i.plotArea.backgroundColor:t?"#FFFFFF":null},te.getHoverBehaviorDelay=function(t){var i=t.getOptions().styleDefaults.hoverBehaviorDelay;return i?(i=e.CSSStyle.getTimeMilliseconds(i),ne.isScatterBubble(t)||ne.isLine(t)?.75*i:1.25*i):0},te.optimizeMarkerStroke=function(e){return ne.isScatterBubble(e)||ne.isBoxPlot(e)},te.getGroupWidth=function(e){var t=e.getCache().getFromCache("groupWidth");return null==t&&(t=e.xAxis.getInfo().getGroupWidth(),e.getCache().putToCache("groupWidth",t)),t},te.isStackLabelRendered=function(e){var t=e.getOptions();return!(!ne.isStacked(e)||"on"!=t.stackLabel)},te.optimizeMarkerFill=function(e){return ne.isLineArea(e)},te.getClassName=function(e,t,i){var r=J.getDataItem(e,t,i);if(r&&(r.className||r.svgClassName))return r.className||r.svgClassName;var n=J.getSeriesItem(e,t);return n&&(n.className||n.svgClassName)?n.className||n.svgClassName:null},te.getAreaClassName=function(e,t){var i=J.getSeriesItem(e,t);return i&&(i.areaClassName||i.areaSvgClassName)?i.areaClassName||i.areaSvgClassName:i&&(i.className||i.svgClassName)?i.className||i.svgClassName:null},te.getMarkerClassName=function(e,t,i,r){var n=J.getNestedDataItem(e,t,i,r);if(n&&(n.className||n.svgClassName))return n.className||n.svgClassName;var a=J.getDataItem(e,t,i);if(a&&(a.className||a.svgClassName))return a.className||a.svgClassName;var o=J.getSeriesItem(e,t);return o&&(o.markerClassName||o.markerSvgClassName)?o.markerClassName||o.markerSvgClassName:ne.isScatterBubble(e)&&o&&(o.className||o.svgClassName)?o.className||o.svgClassName:null},te.getStyle=function(e,t,i){var r=J.getDataItem(e,t,i);if(r&&(r.style||r.svgStyle))return r.style||r.svgStyle;var n=J.getSeriesItem(e,t);return n&&(n.style||n.svgStyle)?n.style||n.svgStyle:null},te.getAreaStyle=function(e,t){var i=J.getSeriesItem(e,t);return i&&(i.areaStyle||i.areaSvgStyle)?i.areaStyle||i.areaSvgStyle:i&&(i.style||i.svgStyle)?i.style||i.svgStyle:null},te.getMarkerStyle=function(e,t,i,r){var n=J.getNestedDataItem(e,t,i,r);if(n&&(n.style||n.svgStyle))return n.style||n.svgStyle;var a=J.getDataItem(e,t,i);if(a&&(a.style||a.svgStyle))return a.style||a.svgStyle;var o=J.getSeriesItem(e,t);return o&&(o.markerStyle||o.markerSvgStyle)?o.markerStyle||o.markerSvgStyle:ne.isScatterBubble(e)&&o&&(o.style||o.svgStyle)?o.style||o.svgStyle:null},te.getBoxPlotStyleOptions=function(t,i,r){var n=J.getDataItem(t,i,r),a=n&&n.boxPlot?n.boxPlot:{},o=J.getSeriesItem(t,i),s=o&&o.boxPlot?o.boxPlot:{},l=t.getOptions().styleDefaults.boxPlot,h=e.JsonUtils.merge(a,e.JsonUtils.merge(s,l)),u=te.getColor(t,i,r);h._color=u;var g=e.ColorUtils.getBrighter(u,.8);if(h.q2Color||(h.q2Color=g),h.q3Color||(h.q3Color=g),"pattern"==te.getSeriesEffect(t)){var d=te.getPattern(t,i,r);h._q2Pattern=d,h._q3Pattern=d}var p=te.getBorderColor(t,i,r);h.borderColor=p||u,h.borderWidth=te.getBorderWidth(t,i,r);var c=e.ColorUtils.getDarker(u,.1);return te._setBoxPlotDefaultLineColor(h,"whisker",c),te._setBoxPlotDefaultLineColor(h,"whiskerEnd",c),te._setBoxPlotDefaultLineColor(h,"median",c),h},te._setBoxPlotDefaultLineColor=function(t,i,r){var n=e.JsonUtils.merge(t[i+"Style"],t[i+"SvgStyle"]);t[i+"SvgStyle"]=n,t[i+"Style"]=null,!n||n.stroke||t[i+"ClassName"]||t[i+"SvgClassName"]||(t[i+"SvgStyle"].stroke=r)};var ie=new Object;e.Obj.createSubclass(ie,e.Obj),ie.createText=function(t,i,r,n,a,o,s,l){var h=new e.OutputText(i.getCtx(),r,a,o);return h.setCSSStyle(n),e.TextUtils.fitText(h,s,l,i)?(t.associate(h,new e.SimpleObjPeer(h.getUntruncatedTextString())),h):null},ie.areTitlesRendered=function(e){var t=e.getOptions();return t.title.text||t.subtitle.text||t.footnote.text};var re=new Object;e.Obj.createSubclass(re,e.Obj),re.getDatatipColor=function(e,t,i,r){return ne.isStock(e)?te.getColor(e,0,i):null!=r&&r>=0?te.getMarkerColor(e,t,i,r):te.getColor(e,t,i)},re.getDatatip=function(e,t,i,r,n){if(ne.isSpark(e)||ne.isOverview(e))return null;if(t<0||i<0)return null;var a,o=J.getDataItem(e,t,i),s=e.getOptions().tooltip,l=s?s.renderer:null;if(n&&l){var h=e.getCtx().getTooltipManager(re.isDataCursorEnabled(e)?L.TOOLTIP_ID:null),u=J.getDataContext(e,t,i,r);if(ne.isPie(e)){var g=oe.getSliceBySeriesIndex(e,t);u.label=g.getSliceLabelString()}else u.label=J.getDataLabel(e,t,i,r);return h.getCustomTooltip(l,u)}return o&&null!=o.shortDesc?o.shortDesc:(ne.isStock(e)?a=re._getStockDatatip(e,0,i,n):(a=[],re._addSeriesDatatip(a,e,t,i,n),re._addGroupDatatip(a,e,t,i,n),re._addValueDatatip(a,e,t,i,r,n)),re._processDatatip(a,e,n))},re.getOtherSliceDatatip=function(e,t,i){var r=e.getOptions().translations.labelOther,n=e.getOptions().tooltip,a=n?n.renderer:null;if(i&&a){var o=oe.getSliceBySeriesIndex(e,null),s=J.getDataContext(e,null,0);return s.label=o.getSliceLabelString(),e.getCtx().getTooltipManager().getCustomTooltip(a,s)}var l=[];return re._addDatatipRow(l,e,"series","labelSeries",r,i),re._addGroupDatatip(l,e,0,0,i),re._addDatatipRow(l,e,"value","labelValue",t,i),re._processDatatip(l,e,i)},re._processDatatip=function(t,i,r){return 0===t.length?null:r?e.HtmlTooltipManager.createElement("table",i.getOptions().styleDefaults._tooltipStyle,t):t.join("")},re.getRefObjTooltip=function(e,t,i,r){var n=e.getOptions().tooltip,a=n?n.renderer:null;if(a&&null!=t.id){var o=e.getCtx().getTooltipManager(re.isDataCursorEnabled(e)?L.TOOLTIP_ID:null),s={id:$.getId(t),label:t.text,data:e.getRawOptions()[i].referenceObjects[r],value:t.value,low:$.getLowValue(t),high:$.getHighValue(t),color:$.getColor(t)};return o.getCustomTooltip(a,s)}return t.shortDesc},re._getStockDatatip=function(e,t,i,r){var n=J.getDataItem(e,t,i),a=[];return re._addGroupDatatip(a,e,t,i,r),n&&(re._addDatatipRow(a,e,"open","labelOpen",n.open,r),re._addDatatipRow(a,e,"close","labelClose",n.close,r),re._addDatatipRow(a,e,"high","labelHigh",n.high,r),re._addDatatipRow(a,e,"low","labelLow",n.low,r),re._addDatatipRow(a,e,"volume","labelVolume",n.volume,r)),a},re._addSeriesDatatip=function(e,t,i,r,n){var a=J.getSeriesLabel(t,i);re._addDatatipRow(e,t,"series","labelSeries",a,n)},re._addGroupDatatip=function(e,t,i,r,n){var a;if(Z.hasTimeAxis(t)){var o=re.getValueFormat(t,"group"),s=J.getXValue(t,i,r);null==(a=re.formatDateValue(o,new Date(s)))&&(a=t.xAxis.getInfo().formatLabel(s))}else a=J.getGroupLabel(t,r);var l=J.getNumLevels(t),h="labelGroup";if(1!=l&&Array.isArray(a))for(var u=l-1;u>=0;u--)re._addDatatipRow(e,t,"group",h,a[u],n,u),a[u]&&(h=null);else re._addDatatipRow(e,t,"group",h,a,n)},re._addValueDatatip=function(e,t,i,r,n,a){var o=J.getValue(t,i,r,n),s=J.getXValue(t,i,r),l=J.getZValue(t,i,r),h=J.getLowValue(t,i,r),u=J.getHighValue(t,i,r),g=null!=n&&n>=0;if(ne.isScatterBubble(t))re._addDatatipRow(e,t,"x","labelX",s,a),re._addDatatipRow(e,t,"y","labelY",o,a),ne.isBubble(t)&&re._addDatatipRow(e,t,"z","labelZ",l,a);else if(ne.isPie(t)||ne.isPyramid(t))re._addDatatipRow(e,t,"value","labelValue",o,a);else if(ne.isFunnel(t)){re._addDatatipRow(e,t,"value","labelValue",o,a);var d=J.getTargetValue(t,i);null!=d&&re._addDatatipRow(e,t,"targetValue","labelTargetValue",d,a)}else if("boxPlot"!=te.getSeriesType(t,i)||g){if(ne.isBLAC(t)){var p=J.isAssignedToY2(t,i)?"y2":"y";null==h&&null==u||g?null==l||g?re._addDatatipRow(e,t,p,"labelValue",o,a):(re._addDatatipRow(e,t,p,"labelY",o,a),re._addDatatipRow(e,t,"z","labelZ",l,a)):(re._addDatatipRow(e,t,"high","labelHigh",u,a),re._addDatatipRow(e,t,"low","labelLow",h,a),null!=l&&re._addDatatipRow(e,t,"z","labelZ",l,a))}}else{var c=J.getDataItem(t,i,r);re._addDatatipRow(e,t,"high","labelHigh",u,a),re._addDatatipRow(e,t,"q3","labelQ3",c.q3,a),re._addDatatipRow(e,t,"q2","labelQ2",c.q2,a),re._addDatatipRow(e,t,"q1","labelQ1",c.q1,a),re._addDatatipRow(e,t,"low","labelLow",h,a),null!=l&&re._addDatatipRow(e,t,"z","labelZ",l,a)}},re._addDatatipRow=function(t,i,r,n,a,o,s){if(null!=a&&""!==a){var l,h=i.getOptions().styleDefaults,u=re.getValueFormat(i,r),g=u.tooltipDisplay,d=i.getOptions().translations;if(g&&"auto"!=g||"group"==r&&(ne.isPie(i)||ne.isFunnel(i))&&(g="off"),"off"!=g)if("string"==typeof u.tooltipLabel?l=u.tooltipLabel:Array.isArray(u.tooltipLabel)&&(l=u.tooltipLabel[s||0]),null==l&&(l=null==n?"":"labelGroup"==n&&Z.hasTimeAxis(i)?d.labelDate:d[n]),"series"!=r&&"group"!=r&&(a=re.formatValue(i,u,a)),o){var p=e.Agent.isRightToLeft(i.getCtx());h.tooltipLabelStyle.setStyle(e.CSSStyle.TEXT_ALIGN,p?"left":"right"),h.tooltipValueStyle.setStyle(e.CSSStyle.TEXT_ALIGN,p?"right":"left");var c=[e.HtmlTooltipManager.createElement("td",h.tooltipLabelStyle,l),e.HtmlTooltipManager.createElement("td",h.tooltipValueStyle,a)];t.push(e.HtmlTooltipManager.createElement("tr",null,c))}else t.push((t.length>0?"<br>":"")+e.ResourceUtils.format(d.labelAndValue,[l,a]))}},re.getValueFormat=function(e,t){var i=e.getOptions().valueFormats;return i?i[t]?i[t]:"group"==t&&Z.hasTimeAxis(e)?re.getValueFormat(e,"x"):"y"!=t&&"y2"!=t&&"min"!=t&&"max"!=t||!ne.isBLAC(e)?{}:re.getValueFormat(e,"value"):{}},re.formatValue=function(t,i,r,n,a,o){var s,l="auto",h="on";i.scaling&&(l=i.scaling),i.autoPrecision&&(h=i.autoPrecision),i.converter&&(s=i.converter),n=null!=n?n:r,a=null!=a?a:r,o=null!=o?o:0;var u=new e.LinearScaleAxisValueFormatter(t.getCtx(),n,a,o,l,h,t.getOptions().translations);return s&&(s.getAsString||s.format)?u.format(r,s):u.format(r)},re.formatDateValue=function(e,t){var i=e.converter;return i?i.getAsString?i.getAsString(t):i.format?i.format(t):null:null},re.isDataCursorEnabled=function(t){if(ne.isPie(t)||ne.isFunnel(t)||ne.isPolar(t)||ne.isPyramid(t))return!1;var i=t.getOptions();return"on"==i.dataCursor||"off"!=i.dataCursor&&e.Agent.isTouchDevice()&&ne.isLineArea(t)},re.getDataCursorBehavior=function(e){var t=e.getOptions().dataCursorBehavior;return"snap"==t?L.BEHAVIOR_SNAP:"smooth"==t?L.BEHAVIOR_SMOOTH:ne.isLineArea(e)?L.BEHAVIOR_SMOOTH:L.BEHAVIOR_SNAP};var ne=new Object;e.Obj.createSubclass(ne,e.Obj),ne._SUPPORTED_TYPES=["bar","line","area","lineWithArea","combo","pie","bubble","scatter","funnel","pyramid","stock","boxPlot"],ne.isValidType=function(e){return ne._SUPPORTED_TYPES.indexOf(e.getType())>=0},ne.isSpark=function(e){return e.getOptions().__spark},ne.isOverview=function(e){return e.getOptions()._isOverview},ne.isVertical=function(e){return!ne.isHorizontal(e)&&!ne.isPolar(e)},ne.isHorizontal=function(e){return"horizontal"==e.getOptions().orientation&&!ne.isPolar(e)&&!ne.isStock(e)&&(ne.isBLAC(e)||ne.isFunnel(e))},ne.isPolar=function(e){return"polar"==e.getOptions().coordinateSystem&&!ne.isStock(e)&&!ne.isBoxPlot(e)},ne.isStacked=function(e){return!("on"!=e.getOptions().stack||Z.isMixedFrequency(e)||J.getSeriesCount(e)<2)&&ne.isBLAC(e)},ne.isCombo=function(e){return"combo"==e.getType()},ne.isBar=function(e){return"bar"==e.getType()},ne.isLine=function(e){return"line"==e.getType()},ne.isLineWithArea=function(e){return"lineWithArea"==e.getType()},ne.isArea=function(e){return"area"==e.getType()},ne.isStock=function(e){return"stock"==e.getType()},ne.isBoxPlot=function(e){return"boxPlot"==e.getType()},ne.isScatter=function(e){return"scatter"==e.getType()},ne.isBubble=function(e){return"bubble"==e.getType()},ne.isPie=function(e){return"pie"==e.getType()},ne.isFunnel=function(e){return"funnel"==e.getType()},ne.isPyramid=function(e){return"pyramid"==e.getType()},ne.isDualY=function(e){return!(!ne.hasAxes(e)||ne.isScatterBubble(e)||ne.isPolar(e))},ne.isSplitDualY=function(e){return!(!ne.isStock(e)||!J.hasVolumeSeries(e)||ne.isOverview(e))||"on"==e.getOptions().splitDualY&&ne.hasY2Data(e)&&!ne.hasY2DataOnly(e)},ne.isBLAC=function(e){var t=e.getType();return"bar"==t||"line"==t||"area"==t||"lineWithArea"==t||"combo"==t||"stock"==t||"boxPlot"==t},ne.isScatterBubble=function(e){var t=e.getType();return"scatter"==t||"bubble"==t},ne.isLineArea=function(e){var t=e.getType();return"line"==t||"area"==t||"lineWithArea"==t},ne.isScrollSupported=function(e){return!(ne.isPie(e)||ne.isFunnel(e)||ne.isPolar(e)||ne.isPyramid(e))},ne.isOverviewSupported=function(e){return ne.isBLAC(e)&&ne.isVertical(e)},ne.isHorizScrollbarSupported=function(e){var t=Q.getZoomDirection(e);return!ne.isPolar(e)&&(ne.isBLAC(e)&&ne.isVertical(e)||ne.isScatterBubble(e)&&"y"!=t)},ne.isVertScrollbarSupported=function(e){var t=Q.getZoomDirection(e);return!ne.isPolar(e)&&(ne.isBLAC(e)&&ne.isHorizontal(e)||ne.isScatterBubble(e)&&"x"!=t)},ne.hasAxes=function(e){return!("pie"==e.getType()||"funnel"==e.getType()||"pyramid"==e.getType())},ne.hasY2DataOnly=function(e){return!!ne.isDualY(e)&&J.getY2SeriesCount(e,null,!0)==J.getSeriesCount(e)},ne.hasY2Data=function(e,t){return!!ne.isDualY(e)&&J.getY2SeriesCount(e,null,!0)>0},ne.hasY2BarData=function(e){return ne.hasY2Data(e,"bar")},ne.hasBarSeries=function(e){return ne._hasSeriesType(e,"bar")},ne.hasLineSeries=function(e){return ne._hasSeriesType(e,"line")},ne.hasAreaSeries=function(e){return ne._hasSeriesType(e,"area")},ne.hasLineWithAreaSeries=function(e){return ne._hasSeriesType(e,"lineWithArea")},ne.hasCandlestickSeries=function(e){return ne._hasSeriesType(e,"candlestick")},ne.hasBoxPlotSeries=function(e){return ne._hasSeriesType(e,"boxPlot")},ne._hasSeriesType=function(e,t){if(ne.isBLAC(e))for(var i=J.getSeriesCount(e),r=0;r<i;r++)if(te.isSeriesRendered(e,r)&&te.getSeriesType(e,r)==t)return!0;return!1},ne.hasCenteredSeries=function(e){if(!ne.isBLAC(e))return!1;for(var t=J.getSeriesCount(e),i=0;i<t;i++)if(te.isSeriesRendered(e,i)&&"bar"!=te.getSeriesType(e,i)){var r=te.getLineType(e,i);if("centeredSegmented"==r||"centeredStepped"==r)return!0}return!1},ne.hasUncenteredSeries=function(e){if(!ne.isBLAC(e))return!1;for(var t=J.getSeriesCount(e),i=0;i<t;i++)if(te.isSeriesRendered(e,i)&&"bar"!=te.getSeriesType(e,i)){var r=te.getLineType(e,i);if("segmented"==r||"stepped"==r)return!0}return!1},ne.isStandalonePlotArea=function(e){var t=e.getOptions();return!(ie.areTitlesRendered(e)||"off"!=t.legend.rendered||Z.isAxisRendered(e,"x")||Z.isAxisRendered(e,"y")||Z.isAxisRendered(e,"y2"))},ne.isStandaloneXAxis=function(e){var t=e.getOptions();return!ie.areTitlesRendered(e)&&"off"==t.legend.rendered&&"off"==t.plotArea.rendered&&!Z.isAxisRendered(e,"y")&&!Z.isAxisRendered(e,"y2")},ne.isStandaloneYAxis=function(e){var t=e.getOptions();return!ie.areTitlesRendered(e)&&"off"==t.legend.rendered&&!Z.isAxisRendered(e,"x")&&"off"==t.plotArea.rendered&&!Z.isAxisRendered(e,"y2")},ne.isStandaloneY2Axis=function(e){var t=e.getOptions();return!ie.areTitlesRendered(e)&&"off"==t.legend.rendered&&!Z.isAxisRendered(e,"x")&&!Z.isAxisRendered(e,"y")&&"off"==t.plotArea.rendered};var ae=new Object;e.Obj.createSubclass(ae,e.Obj),ae._MIN_BUBBLE_SIZE=6,ae._MAX_BUBBLE_SIZE_RATIO=.5,ae.calcBubbleSizes=function(t,i){for(var r,n,a=J.getMinMaxValue(t,"z"),o=a.min,s=a.max,l=ae._MIN_BUBBLE_SIZE,h=ae._MAX_BUBBLE_SIZE_RATIO*Math.min(i.w,i.h),u=J.getSeriesCount(t),g="withoutRescale"==Q.getHideAndShowBehavior(t),d=0;d<u;d++)if(g||te.isSeriesRendered(t,d))for(var p=J.getSeriesItem(t,d),c=p.items?p.items.length:0,_=0;_<c;_++){var f=p.items[_];if(f){var m=e.LayoutUtils.getBubbleSize(f.z,o,s,l,h);f.markerSize=m}}ne.isPolar(t)?(r=1/0,n=t.getRadius()):(r=i.w-2.4*Z.getTickLabelHeight(t,"y"),n=i.h-1.6*Z.getTickLabelHeight(t,"x")),r-=.5*h,n-=.5*h;var v=t.getCache(),y=ae._getAxisValueRange(t,"x");v.putToCache("_xAxisBubbleRatio",y/r);var S=ae._getAxisValueRange(t,"y");v.putToCache("_yAxisBubbleRatio",S/n)},ae.getBubbleAxisRadius=function(e,t,i){if(!i)return 0;var r="x"==t?"_xAxisBubbleRatio":"_yAxisBubbleRatio";return i/2*e.getCache().getFromCache(r)},ae._getAxisValueRange=function(t,i){var r=t.getOptions()[i+"Axis"],n=Z.isLog(t,i),a=!n&&"zero"==Z.getBaselineScaling(t,i),o=J.getMinMaxValue(t,i,!0),s=r.min;null==s&&(s=a?Math.min(0,o.min):o.min);var l=r.max;return null==l&&(l=a?Math.max(0,o.max):o.max),n&&l>0&&s>0?l==s?6:e.Math.log10(l/s):l==s?60:l-s},ae.sortMarkers=function(e){e.sort(ae._compareSize)},ae.sortMarkerInfos=function(e){e.sort(ae._compareInfoSize)},ae._compareSize=function(e,t){return t.getSize()-e.getSize()},ae._compareInfoSize=function(e,t){return t.size-e.size},ae.checkPixelMap=function(e,t,i,r){var n=r/2,a=Math.max(Math.floor(t-n),0),o=Math.max(Math.floor(i-n),0),s=Math.max(Math.ceil(t+n),0),l=Math.max(Math.ceil(i+n),0);return e.isObscured(a,o,s,l)},ae.updatePixelMap=function(e,t,i,r,n){var a=.4*r,o=Math.max(Math.round(t-a),0),s=Math.max(Math.round(t+a),0),l=Math.max(Math.round(i-a),0),h=Math.max(Math.round(i+a),0);e.obscure(o,l,s,h,n)};var oe=new Object;e.Obj.createSubclass(oe,e.Obj),oe.OTHER_SLICE_SERIES_ID="_dvtOther",oe.getSliceId=function(e,t){var i=J.getDataItem(e,t,0),r=i?i.id:null,n=J.getSeries(e,t),a=J.getGroup(e,0);return new o(r,n,a,e.getCtx())},oe.getOtherSliceId=function(e){var t=J.getGroup(e,0);return new o(null,oe.OTHER_SLICE_SERIES_ID,t,e.getCtx())},oe.getRenderedSeriesIndices=function(e){return oe._getSeriesIndicesArrays(e).rendered},oe.hasOtherSeries=function(e){return oe._getSeriesIndicesArrays(e).other.length>0},oe.getOtherValue=function(e){for(var t=oe._getSeriesIndicesArrays(e).other,i=0,r=0;r<t.length;r++){var n=t[r];if(te.isSeriesRendered(e,n)){var a=J.getValue(e,n,0);a>0&&(i+=a)}}return i},oe.getOtherSliceIds=function(e){for(var t=oe._getSeriesIndicesArrays(e).other,i=[],r=0;r<t.length;r++){var n=t[r];i.push(oe.getSliceId(e,n))}return i},oe.isOtherSliceSelected=function(e,t){for(var i=oe.getOtherSliceIds(e),r=0;r<i.length;r++){for(var n=i[r],a=!1,o=0;o<t.length;o++)if(null!=t[o].id&&n.id===t[o].id||n.series===t[o].series&&n.group===t[o].group){a=!0;break}if(!a)return!1}return!0},oe._getSeriesIndicesArrays=function(e){for(var t=[],i=[],r=J.getSeriesCount(e),n=e.getOptions(),a=n.otherThreshold*oe.getTotalValue(e),o=0;o<r;o++){var s=J.getValue(e,o,0);a>0&&s<a?i.push(o):t.push(o)}return"ascending"==n.sorting?t.sort(function(t,i){return J.getValue(e,t,0)-J.getValue(e,i,0)}):"on"!=n.sorting&&"descending"!=n.sorting||t.sort(function(t,i){return J.getValue(e,i,0)-J.getValue(e,t,0)}),{rendered:t,other:i}},oe.getTotalValue=function(e){for(var t=J.getSeriesCount(e),i=0,r=0;r<t;r++){var n=J.getValue(e,r,0);n>0&&(i+=n)}return i},oe.getSliceExplode=function(e,t){var i=J.getSeriesItem(e,t);return i&&i.pieSliceExplode?i.pieSliceExplode:0},oe.getSliceBySeriesIndex=function(e,t){for(var i=e.pieChart.__getSlices(),r=0;r<i.length;r++)if(i[r].getSeriesIndex()==t)return i[r];return null};var se=function(){};e.Obj.createSubclass(se,e.Obj),se.TWOD="2D",se.THREED="3D",se.CRUST="CRUST",se.SIDE="SIDE",se.BORDER="BORDER",se.SURFACE_CRUST=0,se.SURFACE_LEFT=1,se.SURFACE_RIGHT=2,se.SURFACE_TOP=3,se.reflectAngleOverYAxis=function(t,i,r,n,a){var o=e.Math.degreesToRads(360-t);return{x:i+Math.cos(o)*n,y:r+Math.sin(o)*a}},se.getGradientColors=function(t,i){return i==se.TWOD||i==se.THREED?[e.ColorUtils.adjustHSL(t,0,-.04,-.05),e.ColorUtils.adjustHSL(t,0,-.09,.04)]:i==se.CRUST?[e.ColorUtils.adjustHSL(t,0,-.04,-.05),e.ColorUtils.adjustHSL(t,0,0,-.14)]:i==se.SIDE?[e.ColorUtils.adjustHSL(t,0,-.1,.06),e.ColorUtils.adjustHSL(t,0,-.04,-.05)]:void 0},se.getGradientAlphas=function(e,t){var i=null==e||isNaN(e)||0==e?1:e;return t==se.TWOD?[i,i,i]:t==se.BORDER?[i/1.59375,i/5.3125,i/(255/96)]:t==se.THREED?[i,i,i,i,i]:t==se.CRUST?[i,i,i,i]:t==se.SIDE?[i,i]:void 0},se.createTopSurface=function(t,i){var r=t.getPieChart(),n=r.getCtx(),a=t.getCenter(),o=t.getInnerRadius(),s=r.is3D()||t.getSliceGaps()>Math.sin(e.Math.degreesToRads(t.getAngleExtent()))*t._radiusX+1?null:t.getSliceGaps(),l=new C(n,a.x,a.y,t._radiusX,t._radiusY,t.getAngleStart(),t.getAngleExtent(),s,o),h=te.getSelectedInnerColor(r.chart),u=te.getSelectedOuterColor(r.chart),g=new e.Stroke(t.getStrokeColor(),1,t.getBorderWidth()),d=t.getSeriesIndex(),p=te.getClassName(r.chart,d,0),c=te.getStyle(r.chart,d,0);l.setStyleProperties(i,g,t.getFillColor(),h,u,p,c);var _=[l];return se.associate(t,_),_},se.associate=function(e,t){if(t)for(var i=0;i<t.length;i++)e.getPieChart().chart.getEventManager().associate(t[i],e)},se.createLateralSurface=function(t,i,r){if(0==t.getAngleExtent())return[];var n=[];if(e.ColorUtils.getAlpha(t.getFillColor())>0)if(i==se.SURFACE_LEFT||i==se.SURFACE_RIGHT)n.push(se._generateLateralShape(t,i,null,r));else if(i==se.SURFACE_CRUST)for(var a=se._createCrustPathCommands(t),o=a.length,s=0;s<o;s++)n.push(se._generateLateralShape(t,i,a[s],r));return se.associate(t,n),n},se.generateLateralGradientFill=function(t,i){t.getPieChart(),i==se.CRUST&&t.getDepth();var r=se.getGradientColors(e.ColorUtils.getRGB(t.getFillColor()),i),n=se.getGradientAlphas(e.ColorUtils.getAlpha(t.getFillColor()),i);return new e.LinearGradientFill(270,r,n,[0,1],null)},se._generateLateralShape=function(t,i,r,n){var a=t.getPieChart().getCtx();if(i==se.SURFACE_LEFT||i==se.SURFACE_RIGHT){for(var o=t.getAngleStart(),s=t.getAngleExtent(),l=t.getCenter().x,h=t.getCenter().y,u=t._radiusX,g=t._radiusY,d=t.getDepth(),p=i==se.SURFACE_LEFT?se.reflectAngleOverYAxis(o+s,l,h,u,g):se.reflectAngleOverYAxis(o,l,h,u,g),c=se._generateInnerPoints(l,h,p.x,p.y,d),_=[],f=0;f<c.length;f++)_.push(c[f].x,c[f].y);var m=new e.Polygon(a,_);return m.setFill(n),t.getStrokeColor()&&m.setSolidStroke(t.getStrokeColor()),m}if(r){var v=new e.Path(a,null);return v.setCmds(r),v.setTranslate(t.__getExplodeOffsetX(),t.__getExplodeOffsetY()),v.setFill(n),t.getStrokeColor()&&v.setSolidStroke(t.getStrokeColor()),v}return null},se._createCrustPathCommands=function(e){var t=e.getAngleStart(),i=e.getAngleExtent(),r=t+i,n=e.getCenter().x,a=e.getCenter().y,o=e._radiusX,s=e._radiusY,l=e.getDepth(),h=[];return t<180&&r>360?(h.push(se._makeOuterPath(n,a,o,s,l,t,180-t)),h.push(se._makeOuterPath(n,a,o,s,l,360,r-360)),h.push(se._makeOuterPath(n,a,o,s,l,180,180))):r>360?(h.push(se._makeOuterPath(n,a,o,s,l,t,360-t)),h.push(se._makeOuterPath(n,a,o,s,l,360,r-360))):t<180&&r>180?(h.push(se._makeOuterPath(n,a,o,s,l,t,180-t)),h.push(se._makeOuterPath(n,a,o,s,l,180,r-180))):h.push(se._makeOuterPath(n,a,o,s,l,t,i)),h},se._makeOuterPath=function(t,i,r,n,a,o,s){var l=e.Math.degreesToRads(s),h=-(e.Math.degreesToRads(o)+l),u=se.reflectAngleOverYAxis(o,t,i,r,n),g=t+Math.cos(h)*r,d=i+Math.sin(h)*n,p=e.PathUtils.moveTo(u.x,u.y);return p+=e.PathUtils.arcTo(r,n,l,0,g,d),p+=e.PathUtils.lineTo(g,d+a),p+=e.PathUtils.arcTo(r,n,l,1,u.x,u.y+a),p+=e.PathUtils.lineTo(u.x,u.y)},se._generateInnerPoints=function(e,t,i,r,n){var a=[];return a.push({x:e,y:t}),a.push({x:i,y:r}),a.push({x:i,y:r+n}),a.push({x:e,y:t+n}),a};var le=function(){this._init()};e.Obj.createSubclass(le,e.Obj),le.prototype._init=function(){this._sliceLabel=null,this._slice=null,this._angle=-1,this._position=-1,this._width=-1,this._height=-1,this._x=-1,this._y=-1,this._initialNumLines=-1,this._hasFeeler=!1,this._maxY=-1,this._minY=-1},le.prototype.getAngle=function(){return this._angle},le.prototype.setAngle=function(e){this._angle=e},le.prototype.getHeight=function(){return this._height},le.prototype.setHeight=function(e){this._height=e},le.prototype.getInitialNumLines=function(){return this._initialNumLines},le.prototype.setInitialNumLines=function(e){this._initialNumLines=e},le.prototype.getMaxY=function(){return this._maxY},le.prototype.setMaxY=function(e){this._maxY=e},le.prototype.getMinY=function(){return this._minY},le.prototype.setMinY=function(e){this._minY=e},le.prototype.boundY=function(e){return this._minY<=this._maxY&&(e=Math.max(e,this._minY),e=Math.min(e,this._maxY)),e},le.prototype.hasFeeler=function(){return this._hasFeeler},le.prototype.setHasFeeler=function(e){this._hasFeeler=e},le.prototype.getPosition=function(){return this._position},le.prototype.setPosition=function(e){this._position=e},le.prototype.getSlice=function(){return this._slice},le.prototype.setSlice=function(e){this._slice=e},le.prototype.getSliceLabel=function(){return this._sliceLabel},le.prototype.setSliceLabel=function(e){this._sliceLabel=e},le.prototype.getWidth=function(){return this._width},le.prototype.setWidth=function(e){this._width=e},le.prototype.getX=function(){return this._x},le.prototype.setX=function(e){this._x=e},le.prototype.getY=function(){return this._y},le.prototype.setY=function(e){this._y=e};var he=function(){};e.Obj.createSubclass(he,e.Obj),he._MAX_LINES_PER_LABEL=3,he._COLLISION_MARGIN=1,he._LEFT_SIDE_LABELS=1,he._RIGHT_SIDE_LABELS=2,he._OUTSIDE_LABEL_DISTANCE=1.04,he._FEELER_RAD_MINSIZE=.1,he._FEELER_HORIZ_MINSIZE=.1,he._LABEL_TO_FEELER_OFFSET=.5,he._LABEL_TO_FEELER_DISTANCE=3,he._NO_COLLISION=0,he._HALF_COLLISION=1,he._ALL_COLLISION=2,he.layoutLabelsAndFeelers=function(e){var t=e.getLabelPosition();he._layoutInsideLabels(e,"auto"==t),he._layoutOutsideLabelsAndFeelers(e)},he._layoutInsideLabels=function(t,i){for(var r=t.__getSlices(),n=0;n<r.length;n++){var a=r[n],o=t.getSeriesLabelPosition(a.getSeriesIndex());if("none"!=o&&"outsideSlice"!=o&&!he._skipSliceLabel(t,a)){var s=a.getAngleStart()+a.getAngleExtent()/2,l=a.getInnerRadius(),h=a.getCenter(),u=0,g=0,d=he._createLabel(a,!0);if(1==r.length)u=h.x,g=h.y;else{var p=Math.max(.45,.65-.45*l/Math.max(a.getRadiusY(),.001)),c=se.reflectAngleOverYAxis(s,h.x,h.y,l+(a.getRadiusX()-l)*p,l+(a.getRadiusY()-l)*p);u=c.x,g=c.y}d.setX(u),d.setY(g),d.alignMiddle(),d.alignCenter();for(var _=d.getDimensions(),f=u,m=u,v=g-_.h/2,y=g+_.h/2;a.contains(f,v)&&a.contains(f,y);)f--;for(;a.contains(m,v)&&a.contains(m,y);)m++;f=Math.ceil(f+3),m=Math.floor(m-3);var S=2*Math.min(u-f,m-u);if(S<_.w&&(d.setX((f+m)/2),S=m-f),i&&"center"!=o)d.getDimensions().w<S?a.setSliceLabel(d):a.setSliceLabel(null);else{var C=t.getCtx().getStage(),A=he._isTextLabel(t,a)?null:d.getTextString().length;e.TextUtils.fitText(d,S,_.h,C,A)&&(C.removeChild(d),a.setSliceLabel(d))}null!=a.getSliceLabel()&&a.setNoOutsideFeeler()}}},he._layoutOutsideLabelsAndFeelers=function(e){var t,i,r=he._generateInitialLayout(e);t=r[0],i=r[1];var n=he._refineInitialLayout(e,t,he._LEFT_SIDE_LABELS),a=he._refineInitialLayout(e,i,he._RIGHT_SIDE_LABELS);n==he._HALF_COLLISION&&a!=he._NO_COLLISION&&he._columnLabels(e,t,!0,!0,!0),n!=he._NO_COLLISION&&a==he._HALF_COLLISION&&he._columnLabels(e,i,!1,!0,!0),he._setLabelsAndFeelers(e,t,he._LEFT_SIDE_LABELS),he._setLabelsAndFeelers(e,i,he._RIGHT_SIDE_LABELS)},he._createLabel=function(t,i){var r=t.getPieChart(),n=r.getCtx(),a=i?new e.OutputText(n):new e.MultilineText(n),o=r.getOptions().styleDefaults,s=[o.dataLabelStyle],l=J.getDataItem(r.chart,t.getSeriesIndex(),0);l&&s.push(new e.CSSStyle(l.labelStyle));var h=e.CSSStyle.mergeStyles(s),u=null!=h.getStyle("color");if(!i||u&&!e.Agent.isHighContrast())u||h.setStyle("color",o._defaultSliceLabelColor);else{var g=e.ColorUtils.getContrastingTextColor(t.getFillColor());h.setStyle("color",g)}a.setCSSStyle(h);var d=he.generateSliceLabelString(t,o.sliceLabelType);return a.setTextString(d),t.setSliceLabelString(d),a},he.createPieCenter=function(t){var i=t.getOptions(),r=t.getCtx(),n=he.getPieCenterOptions(i),a=n.label,o=n.renderer,s=t.getLabelPosition(),l=i.tooltip,h=l?l.renderer:null,u=t.getCenter(),g=t.getInnerRadius();if(a||o){var d=t.getRadiusX(),p=(g=g>0?g:"outsideSlice"==s?.9*d:.5*d)*Math.sqrt(2);if(a){var c=new e.MultilineText(r),_=n.labelStyle;if(c.setCSSStyle(_),"number"==typeof a&&(a=re.formatValue(t,n,a,a,a,0)),c.setTextString(a),e.TextUtils.fitText(c,p,p,t)){var f=c.getDimensions();c.setY(u.y-f.h/2),c.setX(u.x),c.alignCenter(),h||t.chart.getEventManager().associate(c,new e.SimpleObjPeer(c.getTextString(),null,null,{type:"pieCenterLabel"})),t.addChild(c),t.setCenterLabel(c)}}if(h){var m=new e.Circle(r,u.x,u.y,g);m.setInvisibleFill(),t.addChild(m);var v=t.getCtx().getTooltipManager();t.chart.getEventManager().associate(m,new e.CustomDatatipPeer(v,h,"#4b4b4b",{component:i._widgetConstructor,label:a}))}if(o){var y={outerBounds:{x:u.x-g,y:u.y-g,width:2*g,height:2*g},innerBounds:{x:u.x-p/2,y:u.y-p/2,width:p,height:p},label:a,totalValue:t.getTotalValue(),component:i._widgetConstructor};y=r.fixRendererContext(y);var S=r.getContainer(),C=t.chart.pieCenterDiv;C&&S.removeChild(C);var A=o(y);if(!A)return;var b=r.createOverlayDiv();Array.isArray(A)?A.forEach(function(e){b.appendChild(e)}):b.appendChild(A),t.chart.pieCenterDiv=b,S.appendChild(b);var x=r.getOverlayAttachedCallback();x&&x(b)}}},he.generateSliceLabelString=function(e,t){var i,r=he.getDefaultSliceLabelString(e,t),n=e.getPieChart().getOptions().dataLabel
;if(n){var a=J.getDataContext(e._chart,e.getSeriesIndex(),0);if(a.label=r,"number"==typeof(i=n(a))){var o=re.getValueFormat(e.getPieChart().chart,"label");i=re.formatValue(e.getPieChart(),o,i)}}return i||r},he.getDefaultSliceLabelString=function(e,t){var i=e.getPieChart(),r=e.getCustomLabel(),n=re.getValueFormat(i.chart,"label");return null!=r?"number"==typeof r?re.formatValue(i,n,r):r:"percent"==t?he.generateSlicePercentageString(e):"number"==t?re.formatValue(i,n,e.getValue()):"text"==t?e.getSeriesLabel():"textAndPercent"==t?e.getSeriesLabel()+", "+he.generateSlicePercentageString(e):null},he.generateSlicePercentageString=function(e){var t=e.getPieChart(),i=t.getTotalValue(),r=0==i?0:e.getValue()/i,n=r<.01?3:r<.1?2:r<1?1:0;2*t.getRadiusX()<150&&(n=Math.max(n-1,0));var a=t.getCtx().getNumberConverter({style:"percent",maximumFractionDigits:n,minimumFractionDigits:n}),o="";return a&&a.getAsString?o=a.getAsString(r):a&&a.format?o=a.format(r):(r*=100,o=re.formatValue(t,{},r,null,null,100==r?1:Math.pow(10,-1*n))+"%"),o},he._refineInitialLayout=function(e,t,i){if(t&&t.length>0){for(var r,n=e.__getFrame().y,a=!1,o=!1,s=!1,l=0,h=!1,u=h,g=i==he._LEFT_SIDE_LABELS,d=0;d<t.length;d++)u=h,(r=t[d]).getPosition()>90&&(h=!0),l=r.getY()+r.getHeight(),n-r.getY()>he._COLLISION_MARGIN&&(h?h&&!u?o=!0:s=!0:a=!0),l>n&&(n=l);return a&&s||o?(he._columnLabels(e,t,g,!0,!0),he._ALL_COLLISION):a?(he._columnLabels(e,t,g,!0,!1),he._HALF_COLLISION):s?(he._columnLabels(e,t,g,!1,!0),he._HALF_COLLISION):he._NO_COLLISION}},he._setLabelsAndFeelers=function(t,i,r){if(!(null==i||i.length<=0)){var n,a,o,s,l,h=r==he._LEFT_SIDE_LABELS,u=t.__getFrame(),g=1/0;for(n=0;n<i.length;n++)if(a=(s=i[n]).getSlice(),s.hasFeeler()){l=he._calculateFeeler(s,a,h);var d=e.TextUtils.getTextStringHeight(t.getCtx(),s.getSliceLabel().getCSSStyle()),p=s.getWidth(),c=he._isTextLabel(t,a)?Math.min(2*d,p):p;if(he.getMaxLabelWidth(t,s.getX(),h)+l<c||0==s.getWidth()){s.setSliceLabel(null),a.setNoOutsideFeeler();continue}g=Math.min(g,l)}else a.setNoOutsideFeeler();for(n=0;n<i.length;n++)a=(s=i[n]).getSlice(),(o=s.getSliceLabel())&&(s.hasFeeler()&&(h?s.setX(s.getX()+g):s.setX(s.getX()-g),he._calculateFeeler(s,a,h)),o.setY(s.getY()),o.setX(s.getX()),s.getY()<u.y||s.getY()+s.getHeight()>u.y+u.h?(a.setSliceLabel(null),a.setNoOutsideFeeler()):(he._truncateSliceLabel(t,a,s,h),0==s.getWidth()||0==s.getHeight()?(a.setSliceLabel(null),a.setNoOutsideFeeler()):a.setSliceLabel(o)))}},he._calculateFeeler=function(t,i,r){var n,a=t.getX(),o=t.getY()+t.getHeight()*he._LABEL_TO_FEELER_OFFSET,s=he._FEELER_HORIZ_MINSIZE*i.getRadiusX(),l={x:r?(a+=he._LABEL_TO_FEELER_DISTANCE)+s:(a-=he._LABEL_TO_FEELER_DISTANCE)-s,y:o},h={x:a,y:o},u=t.getAngle(),g=he._adjustForDepth(u,i.getDepth());n=se.reflectAngleOverYAxis(u,i.getCenter().x,i.getCenter().y+g,i.getRadiusX(),i.getRadiusY());var d=e.Math.degreesToRads(t.getPosition()),p=Math.abs(Math.atan2(l.x-n.x,n.y-l.y)),c=(n.y-l.y)*Math.tan(d);return(d>Math.PI/2&&p>Math.PI/2&&p<d||d<Math.PI/2&&p<Math.PI/2&&p>d)&&(l.x=r?n.x-c:n.x+c),i.setOutsideFeelerPoints(n,l,h),Math.abs(h.x-l.x)-s},he._adjustForDepth=function(e,t){var i=0;return e>189&&e<351&&(i=t),i},he._getMiddleLabel=function(e){for(var t=91,i=-1,r=0;r<e.length;r++){var n=e[r].getPosition();Math.abs(n-90)<t&&(t=Math.abs(n-90),i=r)}return i},he._setOptimalLabelPosition=function(t,i,r,n){i.setX(r);var a=t.getRadiusY()*(1+he._FEELER_RAD_MINSIZE),o=e.Math.degreesToRads(i.getPosition()),s=a*Math.cos(o),l=he._adjustForDepth(i.getAngle(),t.getDepth()),h=t.getCenter().y-s-i.getHeight()*he._LABEL_TO_FEELER_OFFSET+l;i.setY(i.boundY(h))},he._getRadFeelerAngle=function(e,t,i){var r=e.getSlice(),n=r.getCenter(),a=e.getAngle(),o=he._adjustForDepth(a,r.getDepth()),s=se.reflectAngleOverYAxis(a,n.x,n.y+o,r.getRadiusX(),r.getRadiusY());return Math.atan2(Math.abs(t-s.x),s.y-i)},he._columnLabels=function(t,i,r,n,a){var o,s,l,h=t.__getFrame(),u=h.y,g=h.y+h.h,d=0,p=t.getCenter().x,c=t.getRadiusX()*(1+he._FEELER_RAD_MINSIZE+he._FEELER_HORIZ_MINSIZE);for(l=r?(p-=c)+t.getRadiusX()*he._FEELER_HORIZ_MINSIZE:(p+=c)-t.getRadiusX()*he._FEELER_HORIZ_MINSIZE,o=0;o<i.length;o++)s=i[o],d=e.Math.degreesToRads(s.getPosition()),he._getRadFeelerAngle(s,l,u)-d>.45*Math.PI||he._skipSliceLabel(t,s.getSlice())?(i.splice(o,1),o--):(i[o].setMinY(u),u+=i[o].getHeight());for(o=i.length-1;o>=0;o--)s=i[o],(d=e.Math.degreesToRads(s.getPosition()))-he._getRadFeelerAngle(s,l,g)>.45*Math.PI||he._skipSliceLabel(t,s.getSlice())?i.splice(o,1):(g-=i[o].getHeight(),i[o].setMaxY(g));if(0!=i.length){var _=he._getMiddleLabel(i),f=i[_];n&&!a&&f.getMinY()+f.getHeight()>t.getCenter().y&&(a=!0),a&&!n&&f.getMaxY()<t.getCenter().y&&(n=!0);var m=f.getPosition();(a&&n||m>90&&a||m<=90&&n)&&(he._setOptimalLabelPosition(t,f,p,r),f.setHasFeeler(!0));var v,y,S=f.getY(),C=f.getY()+f.getHeight();if(n)for(o=_-1;o>=0;o--)y=(s=i[o]).getHeight(),he._setOptimalLabelPosition(t,s,p,r),s.setHasFeeler(!0),(v=s.getY())+y<S?S=v:S-=y,s.setY(S);if(a)for(o=_+1;o<i.length;o++)y=(s=i[o]).getHeight(),he._setOptimalLabelPosition(t,s,p,r),s.setHasFeeler(!0),(v=s.getY())>C?C=v+y:C+=y,s.setY(C-y)}},he._truncateSliceLabel=function(e,t,i,r){var n,a,o=i.getSliceLabel(),s=o.getCSSStyle(),l=e.getNumChildren(),h=!1;e.contains(o)||(e.addChild(o),h=!0),o.setCSSStyle(s);var u=t.getSliceLabelString();return o.setTextString(u),h&&e.removeChildAt(l),n=he.getMaxLabelWidth(e,i.getX(),r),a=he._getTextDimension(e,t,o,n,i.getInitialNumLines()),i.setWidth(a.x),i.getHeight()!=a.y&&(i.setHeight(a.y),!0)},he._generateInitialLayout=function(e){for(var t=new Array(2),i=[],r=[],n=e.__getSlices(),a=e.__getFrame(),o=0;o<n.length;o++){var s=n[o],l=e.getSeriesLabelPosition(s.getSeriesIndex());if(null==s.getSliceLabel()&&"none"!=l&&"center"!=l&&!he._skipSliceLabel(e,s)){var h=he._createLabel(s,!1),u=s.getAngleStart()+s.getAngleExtent()/2;u>360&&(u-=360),u<0&&(u+=360);var g=se.reflectAngleOverYAxis(u,e.getCenter().x,e.getCenter().y,e.getRadiusX()*he._OUTSIDE_LABEL_DISTANCE,e.getRadiusY()*he._OUTSIDE_LABEL_DISTANCE),d=u>=90&&u<270,p=he.getMaxLabelWidth(e,g.x,d),c=he._getTextDimension(e,s,h,p,he._MAX_LINES_PER_LABEL);u<165&&u>15?g.y-=1*c.y:u<15||u>345?(g.y-=.5*c.y,g.x+=.2*c.y):u>165&&u<195&&(g.y-=.5*c.y,g.x-=.2*c.y);var _,f=he._adjustForDepth(u,e.getDepth());g.y+=f,1==n.length&&(g.x-=c.x/2),g.y<a.y||g.y+c.y>a.y+a.h||(u>=90&&u<270?(h.alignRight(),_=u-90,he._createLabelInfo(s,h,u,_,c,g,i)):(_=u<=90?Math.abs(90-u):180-(u-270),he._createLabelInfo(s,h,u,_,c,g,r)))}}return t[0]=i,t[1]=r,t},he._createLabelInfo=function(e,t,i,r,n,a,o){for(var s,l=-1,h=t,u=0;u<o.length;u++)if((s=o[u]).getPosition()>r){l=u;break}-1==l&&(l=o.length),(s=new le).setPosition(r),s.setAngle(i),s.setSliceLabel(h),s.setSlice(e),s.setWidth(n.x),s.setHeight(n.y),s.setX(a.x),s.setY(a.y),s.setInitialNumLines(h.getLineCount()),o.splice(l,0,s)},he._getTextDimension=function(t,i,r,n,a){r.setMaxLines(a);var o=he._isTextLabel(t,i)?null:r.getTextString().length;if(e.TextUtils.fitText(r,n,1/0,t,o)){t.addChild(r);var s=r.getDimensions();return t.removeChild(r),{x:s.w,y:s.h}}return{x:0,y:0}},he._isTextLabel=function(e,t){var i=t.getCustomLabel(),r=null!=e.getOptions().dataLabel;return-1!=e.getOptions().styleDefaults.sliceLabelType.indexOf("text")||null!=i&&"number"!=typeof i||r},he.getMaxLabelWidth=function(e,t,i){var r=e.__getFrame();return i?t-r.x:r.x+r.w-t},he.getPieCenterOptions=function(t){var i=e.JsonUtils.clone(t.pieCenter),r=t.pieCenterLabel;if(r){var n=r.style,a=r.text;a&&(i.label=a),n&&(i.labelStyle=new e.CSSStyle(n))}return i},he._skipSliceLabel=function(e,t){return t.getAngleExtent()<3&&J.getSeriesCount(e.chart)>120};var ue=new Object;e.Obj.createSubclass(ue,e.Obj),ue._BUTTON_SIZE=16,ue._BUTTON_PADDING=5,ue._BUTTON_CORNER_DIST=4,ue._BUTTON_OPACITY=.8,ue._MOUSE_WHEEL_ZOOM_RATE_SLOW=.05,ue._MOUSE_WHEEL_ZOOM_RATE_FAST=.2,ue.render=function(e,t,i){if(ue._renderBackground(e,t,i),J.hasInvalidData(e))ue.renderEmptyText(e,t,i);else{ne.isOverview(e)||(e.getOptions()._maxOverflowCoord=i.x+i.w,e.getOptions()._minOverflowCoord=i.x),ue._addOuterGaps(e,i);var r=i.clone();ue._renderTitles(e,t,i),ue._adjustAvailSpace(i),de.render(e,t,i),ue._adjustAvailSpace(i);var n=ue._prerenderHorizScrollbar(e,t,i),a=ue._prerenderVertScrollbar(e,t,i);ue._adjustAvailSpace(i),e.__setAxisSpace(i.clone()),ge.render(e,t,i),ue._adjustAvailSpace(i),ue._positionLegend(e.legend,i),e.__setPlotAreaSpace(i.clone()),ue._setEventHandlers(e),ue._renderScrollbars(e,n,a),ue._updateTitles(e,t,r,i),ue._renderPlotArea(e,t,i),ne.isPolar(e)&&t.addChild(e.yAxis),ue._renderDragButtons(e,t)}},ue._setEventHandlers=function(t){var i=t.getOptions(),r=t.getEventManager();if(ne.hasAxes(t)&&!ne.isOverview(t)){var n,a,o=new e.Rectangle(0,0,t.getWidth(),t.getHeight()),s=t.__getPlotAreaSpace(),l=t.__getAxisSpace(),h=new e.Rectangle(s.x,l.y,s.w,l.h),u=new e.Rectangle(l.x,s.y,l.w,s.h),g=new e.SolidFill(i.styleDefaults.marqueeColor),d=new e.Stroke(i.styleDefaults.marqueeBorderColor);if(Q.isScrollable(t)){var p=Q.isDelayedScroll(t)?ue._MOUSE_WHEEL_ZOOM_RATE_FAST:ue._MOUSE_WHEEL_ZOOM_RATE_SLOW;if((a=new e.PanZoomHandler(t,s,o,p)).setPanCursor(i._resources.panCursorUp,i._resources.panCursorDown),r.setPanZoomHandler(a),Q.isZoomable(t)){var c=Q.getZoomDirection(t);n=ne.isHorizontal(t)||"y"==c?new e.MarqueeHandler(t,s,o,g,d,!1,!0,null,u):ne.isBLAC(t)||"x"==c?new e.MarqueeHandler(t,s,o,g,d,!0,!1,h,null):new e.MarqueeHandler(t,s,o,g,d,!0,!0,h,u),r.setMarqueeZoomHandler(n)}}"multiple"==i.selectionMode&&(n=new e.MarqueeHandler(t,s,o,g,d,!0,!0,h,u),r.setMarqueeSelectHandler(n))}},ue.rerenderAxisAndPlotArea=function(e,t){if(!J.hasInvalidData(e)){var i=e.__getAxisSpace().clone(),r=e.getSelectionHandler();if(r)var n=r.getSelectedIds();var a=e.__cacheChartFocus();e.__cleanUpAxisAndPlotArea(),ge.render(e,t,i),ue._adjustAvailSpace(i),e.__setPlotAreaSpace(i.clone()),ue._renderPlotArea(e,t,i),r&&r.processInitialSelections(n,e.getChartObjPeers()),e.getEventManager().autoToggleZoomButton(),ue.positionDragButtons(e),e.highlight(te.getHighlightedCategories(e)),e.__restoreChartFocus(a)}},ue._renderBackground=function(t,i,r){var n=new e.Rect(t.getCtx(),r.x,r.y,r.w,r.h);n.setInvisibleFill(),i.addChild(n)},ue._addOuterGaps=function(e,t){var i=e.getOptions(),r=s.getGapWidth(e,i.layout.outerGapWidth),n=s.getGapHeight(e,i.layout.outerGapHeight);("none"==i.styleDefaults.padding||ne.isStandalonePlotArea(e)||ne.isStandaloneXAxis(e)||ne.isStandaloneYAxis(e)||ne.isStandaloneY2Axis(e))&&(r=Math.min(r,1),n=Math.min(n,1)),t.x+=r,t.w-=2*r,t.y+=n,t.h-=2*n},ue._renderTitles=function(t,i,r){var n=t.getOptions();if(n.title.text){var a,o,l=ie.createText(t.getEventManager(),i,n.title.text,n.title.style,r.x,r.y,r.w,r.h),h=null!=n.title.hAlign?n.title.hAlign:n.title.halign,u="plotArea"==h.substring(0,8);if(l?(a=(o=l.getDimensions()).h,l.setAriaProperty("hidden",null)):(a=0,o=new e.Rectangle(0,0,0,0)),n.subtitle.text){var g=new e.OutputText(t.getCtx(),n.subtitle.text,r.x,r.y);if(g){g.setCSSStyle(n.subtitle.style),i.addChild(g);var d=g.getDimensions(),p=s.getGapWidth(t,n.layout.titleSubtitleGapWidth),c=o.w+p+d.w;if(c>r.w||u)p=s.getGapHeight(t,n.layout.titleSubtitleGapHeight),g.setY(r.y+a+p),e.TextUtils.fitText(g,r.w,r.h,i)&&(a+=(d=g.getDimensions()).h+p,e.Agent.isRightToLeft(t.getCtx())&&(g&&g.setX(r.w-d.w),l&&l.setX(r.w-o.w)));else{var _=o.h-d.h;g.setY(_+r.y),l&&(e.LayoutUtils.align(r,h,l,c),e.Agent.isRightToLeft(t.getCtx())?(g.setX(l.getX()),l&&l.setX(l.getX()+d.w+p)):g.setX(l.getX()+c-d.w))}g.setAriaProperty("hidden",null),t.getEventManager().associate(g,new e.SimpleObjPeer(g.getUntruncatedTextString()))}}else e.LayoutUtils.align(r,h,l,o.w);u&&(t.getCache().putToCache("title",l),t.getCache().putToCache("subtitle",g));var f="on"==n.titleSeparator.rendered?n.layout.titleSeparatorGap:n.layout.titlePlotAreaGap;if(r.y+=a+s.getGapHeight(t,f),r.h-=a+s.getGapHeight(t,f),"on"==n.titleSeparator.rendered){var m=new e.Line(t.getCtx(),r.x,r.y,r.x+r.w,r.y),v=new e.Line(t.getCtx(),r.x,r.y+1,r.x+r.w,r.y+1);m.setSolidStroke(n.titleSeparator.upperColor),v.setSolidStroke(n.titleSeparator.lowerColor),i.addChild(m),i.addChild(v);var y=2+s.getGapHeight(t,n.layout.titlePlotAreaGap);r.y+=y,r.h-=y}}if(n.footnote.text){var S=ie.createText(t.getEventManager(),i,n.footnote.text,n.footnote.style,r.x,0,r.w,r.h),C=null!=n.footnote.hAlign?n.footnote.hAlign:n.footnote.halign,A="plotArea"==C.substring(0,8);if(S){var b=S.getDimensions();S.setY(r.y+r.h-b.h),r.h-=b.h+s.getGapHeight(t,n.layout.footnoteGap),e.LayoutUtils.align(r,C,S,b.w),S.setAriaProperty("hidden",null)}A&&t.getCache().putToCache("footnote",S)}},ue._updateTitles=function(e,t,i,r){var n=e.getOptions(),a=null!=n.title.hAlign?n.title.hAlign:n.title.halign,o=null!=n.footnote.hAlign?n.footnote.hAlign:n.footnote.halign,s=n.title.text&&"plotArea"==a.substring(0,8),l=n.footnote.text&&"plotArea"==o.substring(0,8);if(i.x=r.x,i.w=r.w,s){var h,u=e.getCache().getFromCache("title"),g=e.getCache().getFromCache("subtitle"),d=u.getDimensions();ue._alignTextToPlotArea(t,i,a,u,d.w),g&&(h=g.getDimensions(),ue._alignTextToPlotArea(t,i,a,g,h.w))}if(l){var p=e.getCache().getFromCache("footnote"),c=p.getDimensions();ue._alignTextToPlotArea(t,i,o,p,c.w)}},ue._alignTextToPlotArea=function(t,i,r,n,a){e.TextUtils.fitText(n,i.w,i.h,t)&&("plotAreaStart"==r?e.LayoutUtils.align(i,"start",n,a):"plotAreaCenter"==r?e.LayoutUtils.align(i,"center",n,a):"plotAreaEnd"==r&&e.LayoutUtils.align(i,"end",n,a))},ue._renderPlotArea=function(t,i,r){if(ne.hasAxes(t)){var n=new e.Container(t.getCtx());n.setTranslate(r.x,r.y),i.addChild(n),t.setPlotArea(n),t.getEventManager().associate(n,new e.SimpleObjPeer(null,null,null,{type:"plotArea"}));var a=new e.Rectangle(0,0,r.w,r.h);pe.render(t,n,a)}else if(ne.isPie(t)){var o=new k(t,r);o.__getSlices().length>0?(i.addChild(o),t.setPlotArea(o),o.render()):ue.renderEmptyText(t,i,r)}else ne.isFunnel(t)?ce.render(t,i,r):ne.isPyramid(t)&&_e.render(t,i,r);r.w=0,r.h=0},ue.renderEmptyText=function(t,i,r){var n=t.getOptions();if(J.hasInvalidTimeData(t)&&J.hasData(t))var a=n.translations.labelInvalidData;else(a=n.emptyText)||(a=n.translations.labelNoData);e.TextUtils.renderEmptyText(i,a,new e.Rectangle(r.x,r.y,r.w,r.h),t.getEventManager(),n._statusMessageStyle)},ue._prerenderHorizScrollbar=function(t,i,r){var n=r.w,a=0;return Q.isScrollable(t)&&ne.isHorizScrollbarSupported(t)?te.isOverviewRendered(t)?(a=Math.min(te.getOverviewHeight(t),r.h))>0&&(t.overview=new E(t),i.addChild(t.overview),e.LayoutUtils.position(r,"bottom",t.overview,n,a,10)):(a=t.getOptions().styleDefaults._scrollbarHeight,t.xScrollbar=new e.SimpleScrollbar(t.getCtx(),t.processEvent,t),i.addChild(t.xScrollbar),e.LayoutUtils.position(r,"bottom",t.xScrollbar,n,a,8),t.overview=null):t.overview=null,new e.Dimension(n,a)},ue._prerenderVertScrollbar=function(t,i,r){var n=0,a=r.h;if(Q.isScrollable(t)&&ne.isVertScrollbarSupported(t)){n=t.getOptions().styleDefaults._scrollbarHeight;var o=new e.SimpleScrollbar(t.getCtx(),t.processEvent,t);i.addChild(o),e.LayoutUtils.position(r,e.Agent.isRightToLeft(t.getCtx())?"right":"left",o,n,a,8),ne.isHorizontal(t)?t.xScrollbar=o:t.yScrollbar=o}return new e.Dimension(n,a)},ue._renderScrollbars=function(t,i,r){var n=t.getOptions(),a={color:n.styleDefaults._scrollbarHandleColor,backgroundColor:n.styleDefaults._scrollbarTrackColor},o=t.__getPlotAreaSpace();if(t.xScrollbar&&(a.min=t.xAxis.getLinearGlobalMin(),a.max=t.xAxis.getLinearGlobalMax(),ne.isHorizontal(t)?(a.isHorizontal=!1,a.isReversed=!1,t.xScrollbar.setTranslateY(o.y),t.xScrollbar.render(a,r.w,o.h)):(a.isHorizontal=!0,a.isReversed=e.Agent.isRightToLeft(t.getCtx()),t.xScrollbar.setTranslateX(o.x),t.xScrollbar.render(a,o.w,i.h)),t.xScrollbar.setViewportRange(t.xAxis.getLinearViewportMin(),t.xAxis.getLinearViewportMax())),t.yScrollbar&&(a.min=t.yAxis.getLinearGlobalMin(),a.max=t.yAxis.getLinearGlobalMax(),a.isHorizontal=!1,a.isReversed=!0,t.yScrollbar.setTranslateY(o.y),t.yScrollbar.render(a,r.w,o.h),t.yScrollbar.setViewportRange(t.yAxis.getLinearViewportMin(),t.yAxis.getLinearViewportMax())),t.overview){var s={xMin:t.xAxis.getLinearGlobalMin(),xMax:t.xAxis.getLinearGlobalMax(),x1:t.xAxis.getLinearViewportMin(),x2:t.xAxis.getLinearViewportMax(),minimumWindowSize:t.xAxis.getInfo().getMinimumExtent(),chart:e.JsonUtils.clone(n)};Q.isZoomable(t)||(s.featuresOff="zoom"),s.chart._minOverflowCoord=n._minOverflowCoord-o.x,s.chart._maxOverflowCoord=n._maxOverflowCoord-o.x,t.overview.setTranslateX(o.x),t.overview.render(s,o.w,i.h),t.overview.setViewportRange(t.xAxis.getLinearViewportMin(),t.xAxis.getLinearViewportMax())}},ue._positionLegend=function(e,t){if(e){var i=e.getDimensions(),r=e.getOptions().orientation;"vertical"==r&&i.h<=t.h?e.setTranslateY(Math.round(t.y+t.h/2-i.h/2)):"horizontal"==r&&i.w<=t.w&&e.setTranslateX(Math.round(t.x+t.w/2-i.w/2))}},ue._renderDragButtons=function(t,r){var n=ue._BUTTON_SIZE+2*(ue._BUTTON_PADDING+ue._BUTTON_CORNER_DIST),a=t.__getPlotAreaSpace();if(!(!ne.hasAxes(t)||ne.isOverview(t)||a.w<n||a.h<n)){var o=t.getOptions(),s=o.translations,l=t.getEventManager(),h=o.dragMode;if("user"==h){var u,g,d=e.Agent.isTouchDevice(),p=Q.isScrollable(t);t.dragButtons=new e.Container(t.getCtx());var c="multiple"==o.selectionMode&&(d||p),_=p&&d,f=p&&!d&&Q.isZoomable(t)&&ne.isScatterBubble(t);c&&(g=_||f?"end":"solo",l.selectButton=ue._createDragButton(t,t.dragButtons,"select",l.onSelectButtonClick,l,g),u=s.tooltipSelect,l.selectButton.setTooltip(u),l.associate(l.selectButton,l.selectButton)),_&&(g=c?"start":"solo",l.panButton=ue._createDragButton(t,t.dragButtons,"pan",l.onPanButtonClick,l,g),u=s.tooltipPan,l.panButton.setTooltip(u),l.associate(l.panButton,l.panButton)),f&&(g=c?"start":"solo",l.zoomButton=ue._createDragButton(t,t.dragButtons,"zoom",l.onZoomButtonClick,l,g),u=s.tooltipZoom,l.zoomButton.setTooltip(u),l.associate(l.zoomButton,l.zoomButton)),ue.positionDragButtons(t),l.setDragMode(null),t.dragButtons.getNumChildren()>0&&(t.addChild(t.dragButtons),d?p&&(l.panButton.setToggled(!0),l.onPanButtonClick(null)):t.hideDragButtons(),t.dragButtons.setCursor("default"))}else"pan"==h?l.setDragMode(i.DRAG_MODE_PAN):"zoom"==h?l.setDragMode(i.DRAG_MODE_ZOOM):"select"==h?l.setDragMode(i.DRAG_MODE_SELECT):l.setDragMode(i.DRAG_MODE_OFF)}},ue._positionDragButton=function(t,i,r){var n;e.Agent.isRightToLeft(t.getCtx())?(n=r.x+ue._BUTTON_PADDING,r.x+=ue._BUTTON_SIZE+2*ue._BUTTON_PADDING):n=r.x+r.w-ue._BUTTON_SIZE-ue._BUTTON_PADDING,r.w-=ue._BUTTON_SIZE+2*ue._BUTTON_PADDING,i.setTranslate(n,r.y+ue._BUTTON_PADDING)},ue.positionDragButtons=function(e){var t=e.__getPlotAreaSpace().clone();t.x+=ue._BUTTON_CORNER_DIST,t.w-=2*ue._BUTTON_CORNER_DIST,t.y+=ue._BUTTON_CORNER_DIST;var i=e.getEventManager();i.selectButton&&ue._positionDragButton(e,i.selectButton,t),i.panButton&&ue._positionDragButton(e,i.panButton,t),i.zoomButton&&ue._positionDragButton(e,i.zoomButton,t)},ue._createDragButtonBackground=function(t,i,r){var n=2,a=2,o=e.Agent.isRightToLeft(t);"start"==i?o?n=0:a=0:"end"==i&&(o?a=0:n=0);var s=n,l=a,h=-ue._BUTTON_PADDING,u=ue._BUTTON_SIZE+2*ue._BUTTON_PADDING,g=e.PathUtils.roundedRectangle(h,h,u,u,s,a,l,n),d=new e.Path(t,g);return e.Agent.getDevicePixelRatio()>1?(d.setSolidStroke(r,ue._BUTTON_OPACITY,1),d.setPixelHinting(!0)):d.setSolidStroke(r,ue._BUTTON_OPACITY,1),d},ue._createDragButton=function(t,i,r,n,a,o){var s=t.getCtx(),l=t.getOptions()._resources,h=ue._createDragButtonBackground(s,o,"#C4CED7"),u=l[r+"Up"];h.setFill(new e.LinearGradientFill(270,["#FFFFFF","#F1F3F4","#E8EBED","#E4E8EA"],[ue._BUTTON_OPACITY,ue._BUTTON_OPACITY,ue._BUTTON_OPACITY,ue._BUTTON_OPACITY],[0,.0364,.5,1])),h.addChild(new e.Image(s,u,0,0,ue._BUTTON_SIZE,ue._BUTTON_SIZE));var g=ue._createDragButtonBackground(s,o,"#C4CED7"),d=l[r+"UpHover"]?l[r+"UpHover"]:u;g.setSolidFill("#F7F8F9",ue._BUTTON_OPACITY),g.addChild(new e.Image(s,d,0,0,ue._BUTTON_SIZE,ue._BUTTON_SIZE));var p=ue._createDragButtonBackground(s,o,"#0572CE"),c=l[r+"Down"];p.setSolidFill("#0572CE",ue._BUTTON_OPACITY),p.addChild(new e.Image(s,c,0,0,ue._BUTTON_SIZE,ue._BUTTON_SIZE));var _=ue._createDragButtonBackground(s,o,"#0572CE"),f=l[r+"DownHover"]?l[r+"DownHover"]:c;_.setSolidFill("#0572CE",ue._BUTTON_OPACITY),_.addChild(new e.Image(s,f,0,0,ue._BUTTON_SIZE,ue._BUTTON_SIZE));var m=new e.Button(s,h,g,p,null,null,n,a);if(m.setOverDownState(_),m.setToggleEnabled(!0),i.addChild(m),m.addEvtListener(e.MouseEvent.MOUSEDOWN,function(e){e.stopPropagation()}),e.Agent.isTouchDevice()){var v,y=e.Agent.isRightToLeft(s),S=2*ue._BUTTON_PADDING;(v="solo"==o?new e.Rect(s,-S,-S,ue._BUTTON_SIZE+2*S,ue._BUTTON_SIZE+2*S):"start"==o&&!y||"end"==o&&y?new e.Rect(s,-S,-S,ue._BUTTON_SIZE+1.5*S,ue._BUTTON_SIZE+2*S):new e.Rect(s,-.5*S,-S,ue._BUTTON_SIZE+1.5*S,ue._BUTTON_SIZE+2*S)).setInvisibleFill(),m.addChild(v)}return m},ue._adjustAvailSpace=function(e){e.x=Math.round(e.x),e.y=Math.round(e.y),e.w=Math.round(e.w),e.h=Math.round(e.h)},ue.renderDataCursor=function(e){var t=null,i=e.getOptions(),r=e.getEventManager();if(re.isDataCursorEnabled(e)){(t=new L(e.getCtx(),i.styleDefaults.dataCursor,ne.isHorizontal(e))).setBehavior(re.getDataCursorBehavior(e)),e.addChild(t);var n=new l(e,t);r.setDataCursorHandler(n),e.positionDataCursor(i.dataCursorPosition)}else r.setDataCursorHandler(null);return t};var ge=new Object;e.Obj.createSubclass(ge,e.Obj),ge._DEFAULT_AXIS_MAX_SIZE=.33,ge.render=function(e,t,i){ne.hasAxes(e)&&(Z.applyInitialZooming(e,i),ne.isBubble(e)&&ae.calcBubbleSizes(e,i),ne.isPolar(e)?ge._renderPolar(e,t,i):ge._renderCartesian(e,t,i))},ge._renderCartesian=function(t,i,r){var n=t.getOptions(),a=ne.isHorizontal(t),o=ne.isSplitDualY(t),s=r.clone(),l=Z.getYAxisPosition(t),h=Z.getY2AxisPosition(t);ge._addAxisGaps(t,r),o&&l==h&&(n.yAxis._skipHighestTick=a,n.y2Axis._skipHighestTick=!a);var u=ge._createYAxis(t,i,r,s),g=ge._createY2Axis(t,i,r,s),d=!o&&"on"==n.y2Axis.alignTickMarks&&null==n.y2Axis.step;d&&u&&g&&(ge._alignYAxes(t,u,g),a||(g.dim=ge._getPreferredSize(t,g.axis,t.y2Axis,g.options,"y2",r,s)));var p,c=Z.getTickLabelGapSize(t,"y"),_=Z.getTickLabelGapSize(t,"y2");o&&l==h?(a?(p=Math.max(u.dim.h+c,g.dim.h+_),u.dim.h=p-c,g.dim.h=p-_):(p=Math.max(u.dim.w+c,g.dim.w+_),u.dim.w=p-c,g.dim.w=p-_),ge._positionAxis(r.clone(),u,c),ge._positionAxis(r,g,_)):(ge._positionAxis(r,u,c),ge._positionAxis(r,g,_));var f=J.getGroupCount(t);if("pixel"==te.getBarSpacing(t)&&ne.isBar(t)&&r.w>f){var m=Math.floor(r.w/f)*f;r.x+=(r.w-m)/2,r.w=m}var v=ge._createXAxis(t,i,r,s);v.axis.render(v.options,v.dim.w,v.dim.h),ge._positionAxis(r,v,Z.getTickLabelGapSize(t,"x"));var y=te.getSplitterPosition(t),S=e.Agent.isRightToLeft(t.getCtx()),C=ge._getSplitAvailSpace(r,y,a,a&&S),A=ge._getSplitAvailSpace(r,1-y,a,!a||!S);a?(u&&(u.axis.setTranslateX(r.x),o?u.axis.render(u.options,C.w,u.dim.h,C.x,0):u.axis.render(u.options,r.w,u.dim.h)),d&&u&&g&&ge._alignYAxes(t,u,g),g&&(g.axis.setTranslateX(r.x),o?g.axis.render(g.options,A.w,g.dim.h,A.x,0):g.axis.render(g.options,r.w,g.dim.h)),ge._setOverflow(r,u,v)):(u&&(o?u.axis.render(u.options,u.dim.w,C.h,0,C.y):u.axis.render(u.options,u.dim.w,r.h)),d&&u&&g&&ge._alignYAxes(t,u,g),g&&(o?g.axis.render(g.options,g.dim.w,A.h,0,A.y):g.axis.render(g.options,g.dim.w,r.h)),ge._setOverflow(r,v,u,g)),ge._storeAxes(t,v,u,g)},ge._renderPolar=function(e,t,i){var r=ge._createXAxis(e,t,i,i);r.axis.setTranslateX(i.x),r.axis.setTranslateY(i.y),r.axis.render(r.options,i.w,i.h);var n=ge._createYAxis(e,t,i,i);n.axis.setTranslateX(i.x),n.axis.setTranslateY(i.y),n.axis.render(n.options,i.w,i.h),ge._storeAxes(e,r,n)},ge._createXAxis=function(t,i,r,n){var a=t.getOptions(),o=Z.getXAxisPosition(t),s=e.JsonUtils.clone(a.xAxis);s.position=o,s.isStandalone=ne.isStandaloneXAxis(t),s.groupSeparators=a.styleDefaults.groupSeparators,ge._addCommonAxisAttributes(s,"x",t),s.groups=a.groups,s._groupWidthRatios=Z.getGroupWidthRatios(t),s.timeAxisType=Z.getTimeAxisType(t),s._environment=a._environment,s._locale=a._locale,s.drilling=a.drilling,s._isGroupAxis=Z.hasGroupAxis(t);var l="top"==o||"bottom"==o,h=Z.isGridShifted(t);if("tangential"==o&&Z.hasGroupAxis(t))h?(s.startGroupOffset=.5,s.endGroupOffset=.5):s.endGroupOffset=1;else{var u=Z.getAxisOffset(t);if(s.startGroupOffset=u,s.endGroupOffset=u,ne.hasUncenteredSeries(t)&&(s.endGroupOffset+=1),!Q.isScrollable(t)&&!ne.isOverview(t)){var g=J.getGroupCount(t);Z.isAxisRendered(t,"y")&&Z.isTickLabelInside(t,"y")&&(s[(l?"start":"end")+"GroupOffset"]+=.04*g),Z.isAxisRendered(t,"y2")&&Z.isTickLabelInside(t,"y2")&&(s[(l?"end":"start")+"GroupOffset"]+=.04*g)}}s.leftBuffer=l?r.x-n.x:0,s.rightBuffer=l?n.w+n.x-(r.w+r.x):0,s._renderGridAtLabels=!h||Z.hasTimeAxis(t),s.translations=a.translations;var d=new b(t.getCtx(),t.processEvent,t);i.addChild(d);var p=ge._getPreferredSize(t,d,t.xAxis,s,"x",r,n);return s._minOverflowCoord=a._minOverflowCoord-r.x,s._maxOverflowCoord=a._maxOverflowCoord-r.x,{axis:d,options:s,dim:p}},ge._createYAxis=function(t,i,r,n){var a=t.getOptions();if(ne.hasY2DataOnly(t))return null;var o=e.JsonUtils.clone(a.yAxis);o.position=Z.getYAxisPosition(t),o.isStandalone=ne.isStandaloneYAxis(t),ge._addCommonAxisAttributes(o,"y",t),ge._addCommonYAxisAttributes(o,t),o.translations=a.translations;var s=new b(t.getCtx(),t.processEvent,t);i.addChild(s);var l=ge._getPreferredSize(t,s,t.yAxis,o,"y",r,n);return ge._adjustYAxisForLabels(s,o,t,"y"),a.yAxis.min=o.min,a.yAxis.max=o.max,{axis:s,options:o,dim:l}},ge._createY2Axis=function(t,i,r,n){var a=t.getOptions();if(ne.hasY2Data(t)){var o=e.JsonUtils.clone(a.y2Axis);o.position=Z.getY2AxisPosition(t),o.isStandalone=ne.isStandaloneY2Axis(t),ge._addCommonAxisAttributes(o,"y2",t),ge._addCommonYAxisAttributes(o,t),o.translations=a.translations;var s=new b(t.getCtx(),t.processEvent,t);i.addChild(s);var l=ge._getPreferredSize(t,s,t.y2Axis,o,"y2",r,n);return ge._adjustYAxisForLabels(s,o,t,"y2"),a.y2Axis.min=o.min,a.y2Axis.max=o.max,{axis:s,options:o,dim:l}}},ge._addCommonAxisAttributes=function(e,t,i){var r=i.getOptions();if(e.skin=r.skin,e.tickLabel.position=Z.isTickLabelInside(i,t)?"inside":"outside",e.baselineScaling=Z.getBaselineScaling(i,t),(Z.isTickLabelInside(i,t)||"tangential"==e.position)&&(e._skipHighestTick=!0),e.zoomAndScroll=ne.isPolar(i)?"off":r.zoomAndScroll,e._isOverview=ne.isOverview(i),e._duringZoomAndScroll=r._duringZoomAndScroll,"x"!=t||!Z.hasGroupAxis(i)){var n=J.getMinMaxValue(i,t);e.dataMin=null!=e.dataMin?e.dataMin:n.min,e.dataMax=null!=e.dataMax?e.dataMax:n.max}ne.isPolar(i)&&(e.polarGridShape=Z.isGridPolygonal(i)?"polygon":"circle",e._radius=i.getRadius()),e.dnd=r.dnd},ge._addCommonYAxisAttributes=function(t,i){if(t.timeAxisType="disabled",Q.isLiveScroll(i)&&ne.isBLAC(i)&&!ne.isPolar(i)&&(t._continuousExtent="on"),t.isStandalone)t.leftBuffer=0,t.rightBuffer=0;else if(ne.isSplitDualY(i))t.leftBuffer=1/0,t.rightBuffer=1/0;else{var r=e.Agent.isRightToLeft(i.getCtx());t.leftBuffer=r?0:e.BaseAxisInfo.MINIMUM_AXIS_BUFFER,t.rightBuffer=r?e.BaseAxisInfo.MINIMUM_AXIS_BUFFER:0}},ge._adjustYAxisForLabels=function(t,i,r,n){var a=r.getOptions();if(Z.isYAdjustmentNeeded(r)){var o=a.styleDefaults.dataLabelStyle,s=a.styleDefaults.stackLabelStyle,l=t.getInfo(),h=te.isStackLabelRendered(r),u=e.TextUtils.getTextStringHeight(r.getCtx(),h?s:o),g=0;if("log"==i.scale)g=t.getUnboundedValueAt(t.getUnboundedCoordAt(l.getDataMax())-u)-l.getDataMax();else{var d=1;ne.isSplitDualY(r)&&(d="y"==n?te.getSplitterPosition(r):1-te.getSplitterPosition(r));var p=Math.abs(l.getEndCoord()-l.getStartCoord())*d;g=Math.abs(l.getViewportMax()-l.getViewportMin())/p*u}ne.isHorizontal(r)?g*=4:g*=2,l.getDataMin()-l.getGlobalMin()<=g&&l.getDataMin()<0&&(i.dataMin-=g),l.getGlobalMax()-l.getDataMax()<=g&&l.getDataMax()>0&&(i.dataMax+=g)}},ge._getPreferredSize=function(t,i,r,n,a,o,s){var l=n.isStandalone,h=n.position,u="top"==h||"bottom"==h,g=Z.getTickLabelGapSize(t,a),d=n.maxSize,p=n.size,c=o.w,_=o.h;if("radial"==h||"tangential"==h)c=0,_=0;else if("off"==n.rendered)u?_=0:c=0;else if(l)u?_=o.h-g:c=o.w-g;else if(null!=p)u?(_=te.getSizeInPixels(p,s.h)-g,null!=d&&(_=Math.min(_,te.getSizeInPixels(d,s.h)-g))):(c=te.getSizeInPixels(p,s.w)-g,null!=d&&(c=Math.min(c,te.getSizeInPixels(d,s.w)-g)));else{if(!t.getOptions()._duringZoomAndScroll||!r)return d=null==d?ge._DEFAULT_AXIS_MAX_SIZE:d,u?i.getPreferredSize(n,o.w,te.getSizeInPixels(d,s.h)-g):i.getPreferredSize(n,te.getSizeInPixels(d,s.w)-g,o.h);if(u){var f=e.Agent.isRightToLeft(t.getCtx());n._startOverflow=f?r.getRightOverflow():r.getLeftOverflow(),n._endOverflow=f?r.getLeftOverflow():r.getRightOverflow(),_=r.getHeight()}else c=r.getWidth()}return Z.isYAdjustmentNeeded(t)&&i.getPreferredSize(n,c,_),new e.Dimension(c,_)},ge._addAxisGaps=function(e,t){var i=ne.isHorizontal(e),r=Z.getYAxisPosition(e),n=Z.getY2AxisPosition(e),a=Z.isAxisRendered(e,"x"),o=Z.isAxisRendered(e,"y"),s=Z.isAxisRendered(e,"y2"),l=e.getOptions().layout.verticalAxisGap;l*=i?Z.getGapScalingFactor(e,"x"):Math.max(Z.getGapScalingFactor(e,"y"),Z.getGapScalingFactor(e,"y2")),l=Math.ceil(l),(!i||"top"==r&&o||"top"==n&&s)&&i||(t.y+=l,t.h-=l),(!i||"bottom"==r&&o||"bottom"==n&&s)&&(i||a)||(t.h-=l)},ge._positionAxis=function(t,i,r){i&&e.LayoutUtils.position(t,i.options.position,i.axis,i.dim.w,i.dim.h,r)},ge._alignYAxes=function(e,t,i){var r=t.axis.getInfo();if(r){var n=r.getMajorTickCount(),a=r.getMinorTickCount(),o=i.options,s=i.axis.getInfo();s&&Z.isLog(e,"y")&&Z.isLog(e,"y2")&&n<s.getMajorTickCount()&&(o._logScaleUnit=s.alignLogScaleToTickCount(s.getLogScaleUnit(),n)),o._majorTickCount=n,o._minorTickCount=a}},ge._getSplitAvailSpace=function(e,t,i,r){var n=e.clone();return i?(n.w=e.w*t,n.x=r?e.w*(1-t):0):(n.h=e.h*t,n.y=r?e.h*(1-t):0),n},ge._setOverflow=function(e,t,i,r){if(t){var n=t.axis.getLeftOverflow(),a=t.axis.getRightOverflow();e.x+=n,e.w-=n+a,i&&i.axis.setTranslateX(i.axis.getTranslateX()+("left"==i.options.position?n:-a)),r&&r.axis.setTranslateX(r.axis.getTranslateX()+("left"==r.options.position?n:-a))}},ge._storeAxes=function(e,t,i,r){e.xAxis&&(e.xAxis.destroy(),e.removeChild(e.xAxis)),e.yAxis&&(e.yAxis.destroy(),e.removeChild(e.yAxis)),e.y2Axis&&(e.y2Axis.destroy(),e.removeChild(e.y2Axis)),e.xAxis=t.axis,e.yAxis=i?i.axis:null,e.y2Axis=r?r.axis:null};var de=new Object;e.Obj.createSubclass(de,e.Obj),de._DEFAULT_LINE_WIDTH_WITH_MARKER=2,de._DEFAULT_MAX_SIZE=.3,de._PIE_SIZE_RATIO=1.2,de.render=function(t,i,r){var n=t.getOptions(),a=n.legend.position;if(!("off"==n.legend.rendered||"auto"==n.legend.rendered&&t.getOptionsCache().getFromCache("hasLargeSeriesCount"))){var o=e.JsonUtils.clone(n.legend);delete o.position,o.skin=n.skin,o.hideAndShowBehavior=Q.getHideAndShowBehavior(t),o.hoverBehavior=Q.getHoverBehavior(t),o.hoverBehaviorDelay=te.getHoverBehaviorDelay(t),o.hiddenCategories=te.getHiddenCategories(t),o.highlightedCategories=te.getHighlightedCategories(t),o.dnd=n.dnd,o._dropColor=n._dropColor,o.translations=n.translations,"auto"==a&&(a=r.w>=r.h?"end":"bottom");var l="top"==a||"bottom"==a;if(o.orientation=l?"horizontal":"vertical","start"==a&&(o.halign="end"),"start"!=a&&"end"!=a||(o.valign="middle"),"top"==a&&(o.valign="bottom"),"top"!=a&&"bottom"!=a||(o.halign="center"),de._addLegendData(t,o),0!=o.sections.length){var h,u=e.Legend.newInstance(t.getCtx(),t.processEvent,t);if(null!=t.getId()&&u.setId(t.getId()+"legend"),i.addChild(u),null!=o.size)h=l?new e.Dimension(r.w,te.getSizeInPixels(o.size,r.h)):new e.Dimension(te.getSizeInPixels(o.size,r.w),r.h);else{var g=o.maxSize;if(null==g&&(g=de._DEFAULT_MAX_SIZE,ne.isPie(t))){var d=1-de._PIE_SIZE_RATIO*(l?r.w/r.h:r.h/r.w);g=Math.max(g,d)}var p=l?r.w:te.getSizeInPixels(g,r.w),c=l?te.getSizeInPixels(g,r.h):r.h;h=u.getPreferredSize(o,p,c)}u.render(o,h.w,h.h);var _=l?s.getGapHeight(t,n.layout.legendGapHeight):s.getGapWidth(t,n.layout.legendGapWidth);e.LayoutUtils.position(r,a,u,h.w,h.h,_);var f=Object.keys(o.dnd.drag.series).length>0,m=u.getCache().getFromCache("background");f&&m&&m.setClassName("oj-draggable");var v=u.__getBounds(),y=u.localToStage(new e.Point(v.x,v.y));if(!ne.isOverview(t)){var S=e.Agent.isRightToLeft(t.getCtx())
;"end"==a?S?n._minOverflowCoord=y.x+v.w+_/2:n._maxOverflowCoord=y.x-_/2:"start"==a&&(S?n._maxOverflowCoord=y.x-_/2:n._minOverflowCoord=y.x+v.w+_/2)}t.legend&&(t.legend.destroy(),i.removeChild(t.legend)),t.legend=u}}},de._addLegendData=function(e,t){var i=de._getSeriesItems(e,"vertical"==t.orientation);if(i.length>0){var r=t.seriesSection;r.items=i,t.sections.unshift(r),delete t.seriesSection}var n=de._getRefObjItems(e);if(n.length>0){var a=t.referenceObjectSection;a.items=n,t.sections.push(a),delete t.referenceObjectSection}},de._getSeriesItems=function(e,t){var i,r,n=[];if("pie"==e.getType()||"pyramid"==e.getType()||"funnel"==e.getType()){var a=oe.getRenderedSeriesIndices(e);"pyramid"==e.getType()&&t&&(a=a.reverse());for(var o=0;o<a.length;o++){r=a[o];var s=J.getValue(e,r,0);s>=0&&null!=s&&(i=de._createLegendItem(e,r))&&n.push(i)}oe.hasOtherSeries(e)&&(i={id:oe.OTHER_SLICE_SERIES_ID,text:e.getOptions().translations.labelOther,categoryVisibility:te.getHiddenCategories(e).indexOf(oe.OTHER_SLICE_SERIES_ID)>=0?"hidden":"visible",symbolType:"marker",color:e.getOptions().styleDefaults.otherColor,borderColor:e.getOptions().styleDefaults.borderColor},n.push(i))}else{var l={},h={},u=J.getSeriesCount(e);for(r=0;r<u;r++)if(i=de._createLegendItem(e,r)){var g=J.getStackCategory(e,r);J.isAssignedToY2(e,r)?h[g]?h[g].push(i):h[g]=[i]:l[g]?l[g].push(i):l[g]=[i]}var d=J.getStackCategories(e,null,!0),p=ne.isStacked(e)&&ne.isVertical(e)&&t;n=de._getSeriesItemsForAxis(l,d.y,p,n),n=de._getSeriesItemsForAxis(h,d.y2,p,n)}return n},de._getSeriesItemsForAxis=function(e,t,i,r){for(var n,a=0;a<t.length;a++)(n=e[t[a]])&&(r=i?r.concat(n.reverse()):r.concat(n));return r},de._createLegendItem=function(e,t){var i=J.getSeriesItem(e,t),r=e.getType(),n=te.getSeriesType(e,t),a=te.getLineType(e,t),o=i.displayInLegend;if(!i||"off"==o)return null;if("on"!=o&&(ne.isFunnel(e)||ne.isPyramid(e)||ne.isStock(e)))return null;if("on"!=o&&!J.hasSeriesData(e,t))return null;var s=J.getSeriesLabel(e,t);if("on"!=o&&(null==s||"string"==typeof s&&0===s.trim().length))return null;var l={id:J.getSeries(e,t),text:s,categories:J.getCategories(e,t),categoryVisibility:te.isSeriesRendered(e,t)?"visible":"hidden",_dataContext:J.getDataContext(e,t,-1)};if("line"==n||"lineWithArea"==n||"scatter"==r||"bubble"==r)if(l.lineStyle=te.getLineStyle(e,t),l.lineWidth=te.getLineWidth(e,t),te.isMarkerDisplayed(e,t)){var h=te.getImageSource(e,t,null,null,"source");h?(l.symbolType="image",l.source=h):(l.symbolType="none"==a?"marker":"lineWithMarker","lineWithMarker"==l.symbolType&&(l.lineWidth=Math.min(de._DEFAULT_LINE_WIDTH_WITH_MARKER,l.lineWidth)),l.markerShape=te.getMarkerShape(e,t),l.markerColor=te.getMarkerColor(e,t))}else l.symbolType="line";else if("boxPlot"==n){var u=te.getBoxPlotStyleOptions(e,t);u.q2Color!=u.q3Color?(l.symbolType=ne.isHorizontal(e)?"_horizontalBoxPlot":"_verticalBoxPlot",l._boxPlot=u):l.symbolType="marker"}else l.symbolType="marker","none"==te.getLineType(e,t)&&(l.markerShape=te.getMarkerShape(e,t));return l.color=te.getColor(e,t),l.borderColor=te.getBorderColor(e,t),l.pattern=te.getPattern(e,t),l.svgStyle="area"==n?te.getAreaStyle(e,t):te.getStyle(e,t),l.svgClassName="area"==n?te.getAreaClassName(e,t):te.getClassName(e,t),l.markerSvgStyle=te.getMarkerStyle(e,t),l.markerSvgClassName=te.getMarkerClassName(e,t),l.drilling=Q.isSeriesDrillable(e,t)?"on":"off",l.shortDesc=i.shortDesc,l},de._getRefObjItems=function(e){var t=$.getRefObjs(e);if(t.length<=0)return[];for(var i=[],r=0;r<t.length;r++){var n=t[r];if(n&&"on"==n.displayInLegend&&n.text){var a=$.getType(n);i.push({symbolType:"area"==a?"square":"line",text:n.text,color:$.getColor(n),lineStyle:n.lineStyle,lineWidth:$.getLineWidth(n),categories:$.getRefObjCategories(n),categoryVisibility:$.isObjectRendered(e,n)?"visible":"hidden",shortDesc:n.shortDesc,svgStyle:n.style||n.svgStyle,svgClassName:n.className||n.svgClassName})}}return i};var pe=new Object;e.Obj.createSubclass(pe,e.Obj),pe._MIN_TOUCH_MARKER_SIZE=16,pe._MARKER_DATA_LABEL_GAP=4,pe._MIN_CHARS_DATA_LABEL=3,pe.FILTER_THRESHOLD_SCATTER_BUBBLE=1e4,pe.render=function(e,t,i){"off"==e.getOptions().plotArea.rendered?pe._renderAxisLines(e,t,i):i.w>0&&i.h>0&&(e._currentMarkers=new Array,e._currentAreas=new Array,pe._renderBackgroundObjects(e,t,i),pe._renderTicks(e,t,i),pe._renderForegroundObjects(e,t,i))},pe._renderBackgroundObjects=function(t,i,r){var n=t.getOptions(),a=pe._getBackgroundShape(t,r),o=te.getBackgroundColor(t);if(o?a.setSolidFill(o):a.setInvisibleFill(),i.addChild(a),t.getCache().putToCache("plotAreaBackground",a),Q.isPlotAreaDraggable(t)&&a.setClassName("oj-draggable"),n.xAxis.referenceObjects||n.yAxis.referenceObjects||n.y2Axis.referenceObjects){var s=pe.createClippedGroup(t,i,r);fe.renderBackgroundObjects(t,s,r)}if(ne.isBLAC(t)){var l=new e.Container(t.getCtx());i.addChild(l),t.__setAreaContainer(l),ne.hasAreaSeries(t)&&pe._renderAreas(t,l,r,!1)}},pe._getBackgroundShape=function(t,i){var r,n=t.getCtx();if(ne.isPolar(t)){var a=i.x+i.w/2,o=i.y+i.h/2;if(Z.isGridPolygonal(t)){var s=e.PolygonUtils.getRegularPolygonPoints(a,o,J.getGroupCount(t),t.getRadius(),0);r=new e.Polygon(n,s)}else r=new e.Circle(n,a,o,t.getRadius())}else r=new e.Rect(n,i.x,i.y,i.w,i.h);return r},pe._renderTicks=function(e,t,i){e.xAxis&&Z.isMinorTickRendered(e,"x")&&pe._renderMinorTicks(e,t,e.xAxis,i),e.yAxis&&Z.isMinorTickRendered(e,"y")&&pe._renderMinorTicks(e,t,e.yAxis,i),e.y2Axis&&Z.isMinorTickRendered(e,"y2")&&pe._renderMinorTicks(e,t,e.y2Axis,i),e.xAxis&&Z.isMajorTickRendered(e,"x")&&pe._renderMajorTicks(e,t,e.xAxis,i),e.yAxis&&Z.isMajorTickRendered(e,"y")&&pe._renderMajorTicks(e,t,e.yAxis,i),e.y2Axis&&Z.isMajorTickRendered(e,"y2")&&pe._renderMajorTicks(e,t,e.y2Axis,i)},pe._renderAxisLines=function(e,t,i){e.xAxis&&e.yAxis&&Z.isAxisLineRendered(e,"x")&&pe._renderAxisLine(e,t,e.xAxis,e.yAxis,i),e.xAxis&&e.y2Axis&&Z.isAxisLineRendered(e,"x")&&(e.yAxis&&!ne.isSplitDualY(e)||pe._renderAxisLine(e,t,e.xAxis,e.y2Axis,i)),e.yAxis&&e.xAxis&&Z.isAxisLineRendered(e,"y")&&pe._renderAxisLine(e,t,e.yAxis,e.xAxis,i),e.y2Axis&&e.xAxis&&Z.isAxisLineRendered(e,"y2")&&pe._renderAxisLine(e,t,e.y2Axis,e.xAxis,i)},pe._renderMajorTicks=function(e,t,i,r){pe._renderGridlines(e,t,i.getOptions().majorTick,i.getPosition(),i.getMajorTickCoords(),i.getBaselineCoord(),r)},pe._renderMinorTicks=function(e,t,i,r){pe._renderGridlines(e,t,i.getOptions().minorTick,i.getPosition(),i.getMinorTickCoords(),null,r)},pe._renderAxisLine=function(e,t,i,r,n){var a=i.getOptions(),o=a.position,s="bottom"==o||"right"==o||"tangential"==o?r.getMaxCoord():r.getMinCoord();pe._renderGridlines(e,t,a.axisLine,r.getPosition(),[s],null,n)},pe._renderGridlines=function(t,i,r,n,a,o,s){var l=r.lineColor,h=r.lineStyle,u=new e.Stroke(l,1,r.lineWidth,!1,e.Stroke.getDefaultDashProps(h,r.lineWidth)),g=u.getColor();"inherit"!=r.baselineColor&&(g="auto"==r.baselineColor?e.ColorUtils.getDarker(l,.6):r.baselineColor);for(var d=null!=r.baselineWidth?r.baselineWidth:r.lineWidth,p=r.baselineStyle?r.baselineStyle:r.lineStyle,c=new e.Stroke(g,1,d,!1,e.Stroke.getDefaultDashProps(p,d)),_="",f=0;f<a.length;f++){var m=null!=o&&a[f]==o;"radial"==n||"tangential"==n||m?pe._renderGridline(t,i,n,a[f],m?c:u,s):_+="top"==n||"bottom"==n?e.PathUtils.moveTo(a[f],s.y)+e.PathUtils.verticalLineTo(s.y+s.h):e.PathUtils.moveTo(s.x,a[f])+e.PathUtils.horizontalLineTo(s.x+s.w)}if(""!=_){var v=new e.Path(t.getCtx(),_);(!e.Agent.isTouchDevice()||e.Agent.getDevicePixelRatio()>1)&&v.setPixelHinting(!0),v.setStroke(u),v.setMouseEnabled(!1),i.addChild(v)}},pe._renderGridline=function(t,i,r,n,a,o){var s,l=i.getCtx(),h=!e.Agent.isTouchDevice()||e.Agent.getDevicePixelRatio()>1;if("radial"==r){if(Z.isGridPolygonal(t)){var u=e.PolygonUtils.getRegularPolygonPoints(0,0,J.getGroupCount(t),n,0);s=new e.Polygon(l,u)}else s=new e.Circle(l,0,0,n);s.setInvisibleFill(),s.setTranslate(o.x+o.w/2,o.y+o.h/2)}else if("tangential"==r){s=new e.Line(l,0,0,t.getRadius()*Math.sin(n),-t.getRadius()*Math.cos(n));var g=n%(Math.PI/2);(g<.001||g>Math.PI/2-.001)&&h&&s.setPixelHinting(!0),s.setTranslate(o.x+o.w/2,o.y+o.h/2)}else s="top"==r||"bottom"==r?new e.Line(l,n,o.y,n,o.y+o.h):new e.Line(l,o.x,n,o.x+o.w,n),h&&s.setPixelHinting(!0);s.setStroke(a),s.setMouseEnabled(!1),i.addChild(s)},pe._renderForegroundObjects=function(e,t,i){var r=e.getOptions(),n=pe.createClippedGroup(e,t,i);pe._renderAxisLines(e,t,i);var a=r.plotArea.borderColor,o=r.plotArea.borderWidth;if(a&&0!=o){var s=pe._getBackgroundShape(e,i);s.setInvisibleFill(),s.setSolidStroke(a,null,o),s.setMouseEnabled(!1),t.addChild(s)}ne.isBLAC(e)?(ne.hasLineWithAreaSeries(e)&&pe._renderAreas(e,t,i,!0),ne.hasBarSeries(e)&&pe._renderBars(e,n,i),ne.hasCandlestickSeries(e)&&pe._renderStock(e,n,i),ne.hasBoxPlotSeries(e)&&pe._renderBoxPlot(e,n,i),ne.hasLineSeries(e)&&pe._renderLines(e,t,n,i)):ne.isScatterBubble(e)&&pe._renderScatterBubble(e,t,n,!0,i),(r.xAxis.referenceObjects||r.yAxis.referenceObjects||r.y2Axis.referenceObjects)&&(n=pe.createClippedGroup(e,t,i),fe.renderForegroundObjects(e,n,i));var l=J.getInitialSelection(e);Q.setInitialSelection(e,l),e.highlight(te.getHighlightedCategories(e))},pe._renderDataLabel=function(t,i,r,n,a,o,s,l,h,u){if(!ne.isOverview(t)){var g="bar"==te.getSeriesType(t,n),d=ne.isHorizontal(t),p={width:d?r.w:u,height:d?u:r.h};g&&t.getOptionsCache().putToCachedMap2D("barDims",n,a,p);var c=J.getDataLabel(t,n,a,o,l,h);if(null!=c){var _=te.getDataLabelPosition(t,n,a,o,l,h);if("none"!=_){var f=new e.OutputText(t.getCtx(),c,0,0);f.setMouseEnabled(!1);var m=h?t.getOptions().styleDefaults.stackLabelStyle:te.getDataLabelStyle(t,n,a,o,s,_,l);f.setCSSStyle(m),f.setY(r.y+r.h/2),f.setX(r.x+r.w/2),f.alignCenter(),f.alignMiddle();var v=f.getDimensions();if("left"==_)f.setX(r.x-v.w/2-pe._MARKER_DATA_LABEL_GAP);else if("right"==_)f.setX(r.x+r.w+v.w/2+pe._MARKER_DATA_LABEL_GAP);else if("top"==_)f.setY(r.y-v.h/2);else if("bottom"==_)f.setY(r.y+r.h+v.h/2+pe._MARKER_DATA_LABEL_GAP/2);else{if(g){if(v.w>p.width||v.h>p.height)return;"inLeft"==_?f.setX(r.x+v.w/2+pe._MARKER_DATA_LABEL_GAP):"inRight"==_?f.setX(r.x+r.w-v.w/2-pe._MARKER_DATA_LABEL_GAP):"inTop"==_?f.setY(r.y+v.h/2+pe._MARKER_DATA_LABEL_GAP):"inBottom"==_&&f.setY(r.y+r.h-v.h/2-pe._MARKER_DATA_LABEL_GAP/2)}else if(ne.isBubble(t)){r.x+=pe._MARKER_DATA_LABEL_GAP,r.y+=pe._MARKER_DATA_LABEL_GAP,r.h-=2*pe._MARKER_DATA_LABEL_GAP,r.w-=2*pe._MARKER_DATA_LABEL_GAP;var y=e.TextUtils.getOptimalFontSize(f.getCtx(),f.getTextString(),f.getCSSStyle(),r);if(f.setFontSize(y),!e.TextUtils.fitText(f,r.w,r.h,i,pe._MIN_CHARS_DATA_LABEL))return}if(null!=te.getPattern(t,n,a)){var S=.15*(v=f.getDimensions()).h,C=e.PathUtils.roundedRectangle(v.x-S,v.y,v.w+2*S,v.h,2,2,2,2),A=new e.Path(t.getCtx(),C);A.setSolidFill("#FFFFFF",.9),i.addChild(A)}}if(ne.isBar(t)){var b=t.getCache().getFromCache("plotAreaDims");b||(b=t.getPlotArea().getDimensions(),t.getCache().putToCache("plotAreaDims",b));var x,M=f.getDimensions(),O=!1;if("left"==_&&M.x<0)O=!0,x=r.x-pe._MARKER_DATA_LABEL_GAP;else if("right"==_&&M.x+M.w>b.w+pe._MARKER_DATA_LABEL_GAP)O=!0,x=b.w-r.w-pe._MARKER_DATA_LABEL_GAP;else{if("top"==_&&M.y<0)return;if("bottom"==_&&M.y+M.h>b.y+b.h+pe._MARKER_DATA_LABEL_GAP)return}if(O){if(!isNaN(c))return;if(!e.TextUtils.fitText(f,x,r.h,i,1))return;v=f.getDimensions(),"left"==_?f.setX(r.x-v.w/2-pe._MARKER_DATA_LABEL_GAP):"right"==_&&f.setX(r.x+r.w+v.w/2+pe._MARKER_DATA_LABEL_GAP)}}te.optimizeMarkerStroke(t)&&f.setSolidStroke("none"),i.addChild(f),t.addDataLabel(f)}}}},pe._renderDataLabelForMarker=function(t,i,r){var n=t.getEventManager().getLogicalObject(r);if(n){var a=n.getSeriesIndex(),o=n.getGroupIndex(),s=n.getNestedDataItemIndex();if(r instanceof e.SimpleMarker){var l=new e.Rectangle(r.getCx()-r.getWidth()/2,r.getCy()-r.getHeight()/2,r.getWidth(),r.getHeight());pe._renderDataLabel(t,i,l,a,o,s,r.getDataColor())}else r instanceof P&&(pe._renderDataLabel(t,i,r.getBoundingBox1(),a,o,s,r.getDataColor(),"low"),pe._renderDataLabel(t,i,r.getBoundingBox2(),a,o,s,r.getDataColor(),"high"))}},pe._renderScatterBubble=function(t,i,r,n,a){var o,s=pe._filterScatterBubble(t,n,a),l=J.getSeriesCount(t);for(o=0;o<l;o++)"none"!=te.getLineType(t,o)&&pe._renderLinesForSeries(t,r,o,a);var h=te.getMarkerBorderColor(t),u=te.getBorderWidth(t),g=new e.Stroke(h,1,u),d=[];if(s)for(var p=te.optimizeMarkerStroke(t),c=p?g.getColor():null,_=p?g.getWidth():null,f=0;f<s.length;f++){var m=s[f],v=pe._createMarker(t,m,c,_);d.push(v)}else{for(o=0;o<l;o++){var y=pe._getMarkersForSeries(t,o,a,g);d=d.concat(y)}n&&ae.sortMarkers(d)}ne.isBubble(t)?pe._addMarkersToContainer(t,r,d,g):pe._addMarkersToContainer(t,i,d,g)},pe._renderMarkersForSeries=function(t,i,r,n){var a,o=te.getMarkerBorderColor(t,r),s=te.getBorderWidth(t,r),l=new e.Stroke(o,1,s);a=te.isRangeSeries(t,r)?pe._getRangeMarkersForSeries(t,r,n):pe._getMarkersForSeries(t,r,n,l),pe._addMarkersToContainer(t,i,a,l)},pe._addMarkersToContainer=function(t,i,r,n){var a=i,o=te.optimizeMarkerStroke(t),s=te.optimizeMarkerFill(t);(o||s)&&(a=new e.Container(t.getCtx()),o?a.setStroke(n):a.setInvisibleFill(),i.addChild(a));for(var l=0;l<r.length;l++)a.addChild(r[l]),pe._renderDataLabelForMarker(t,a,r[l]);t._currentMarkers.push(r)},pe._getMarkerInfo=function(t,i,r,n,a){var o=t.getOptions(),s=J.getValue(t,i,r,n);if(null==s||isNaN(s))return null;if(J.isDataItemFiltered(t,i,r))return null;var l=J.getGroupCount(t),h=te.isMarkerDisplayed(t,i,r,n);if(!h&&(null==n||n<0))if("jet"!=o._environment&&Z.isMixedFrequency(t))l<2&&(h=!0);else{var u=l-1,g=ne.isPolar(t),d=g&&u>0&&0==r?u:r-1,p=g&&u>0&&r==u?0:r+1,c=J.getValue(t,i,d),_=J.getValue(t,i,p);null!=c&&!isNaN(c)||null!=_&&!isNaN(_)||(h=!0)}if(!h){if(ne.isSpark(t))return null;if((o._duringZoomAndScroll||ne.isOverview(t))&&!J.isDataSelected(t,i,r,n))return null}if(!te.isDataItemRendered(t,i,r,n))return!1;var f=!0,m=J.getMarkerPosition(t,i,r,n,a),v=te.getMarkerSize(t,i,r,n);return a&&m&&v&&(f=a.intersects(new e.Rectangle(m.x-v/2,m.y-v/2,v,v))),m&&f?{seriesIndex:i,groupIndex:r,itemIndex:n,x:m.x,y:m.y,size:v,markerDisplayed:h}:null},pe._getScatterBubbleMarkerInfo=function(e,t,i,r){if(!te.isDataItemRendered(e,t,i))return!1;var n=J.getScatterBubbleMarkerPosition(e,t,i);if(!n)return null;var a=te.getMarkerSize(e,t,i);return a?{seriesIndex:t,groupIndex:i,x:n.x,y:n.y,size:a}:null},pe._getMarkersForSeries=function(e,t,i,r){if(!te.isSeriesRendered(e,t))return[];for(var n=te.optimizeMarkerStroke(e),a=n?r.getColor():null,o=n?r.getWidth():null,s=[],l=J.getGroupCount(e),h=0;h<l;h++){var u=pe._getMarkerInfo(e,t,h,null,i);if(u){var g=pe._createMarker(e,u,a,o);null!=g&&s.push(g)}}return s},pe._createMarker=function(t,i,r,a){var o,s=e.Agent.isTouchDevice(),l=t.getCtx(),h=te.optimizeMarkerStroke(t),u=te.optimizeMarkerFill(t),g=i.seriesIndex,d=i.groupIndex,p=i.itemIndex,c=te.getMarkerColor(t,g,d,p),_=te.getMarkerShape(t,g,d,p),f=i.markerDisplayed;if(null==f&&(f=te.isMarkerDisplayed(t,g,d,p)),f){var m=te.getImageSource(t,g,d,p,"source");if(m){var v=te.getImageSource(t,g,d,p,"sourceSelected"),y=te.getImageSource(t,g,d,p,"sourceHover"),S=te.getImageSource(t,g,d,p,"sourceHoverSelected");o=new e.ImageMarker(l,i.x,i.y,i.size,i.size,null,m,v,y,S)}else{(o=new e.SimpleMarker(l,_,i.x,i.y,i.size,i.size,null,null,!0)).setFill(ee.getMarkerFill(t,g,d,p));var C=te.getMarkerBorderColor(t,g,d,p),A=te.getBorderWidth(t,g,d,p);C==r&&A==a||o.setSolidStroke(C,null,A),o.setDataColor(c,!0);var b=e.SelectionEffectUtils.getHoverBorderColor(c),x=te.getSelectedInnerColor(t),M=te.getSelectedOuterColor(t);o.setHoverStroke(new e.Stroke(x,1,1),new e.Stroke(b,1,3.5)),o.setSelectedStroke(new e.Stroke(x,1,1.5),new e.Stroke(M,1,4.5)),o.setSelectedHoverStroke(new e.Stroke(x,1,1.5),new e.Stroke(b,1,4.5)),o.setClassName(te.getMarkerClassName(t,g,d,p)),o.setStyle(te.getMarkerStyle(t,g,d,p))}te.isSelectable(t,g,d)&&o.setCursor(e.SelectionEffectUtils.getSelectingCursor()),s&&i.size<pe._MIN_TOUCH_MARKER_SIZE&&pe._addMarkerHitArea(o,i.x,i.y,h)}else te.isSelectable(t,g,d)?((o=new D(l,_,i.x,i.y,i.size,h)).setCursor(e.SelectionEffectUtils.getSelectingCursor()),s&&pe._addMarkerHitArea(o,i.x,i.y,h)):(s&&(i.size=pe._MIN_TOUCH_MARKER_SIZE),o=new D(l,e.SimpleMarker.SQUARE,i.x,i.y,i.size,h)),null!=o&&(u||o.setInvisibleFill(),o.setDataColor(c));return null!=o&&n.associate(o,t,g,d,p,i),o},pe._addMarkerHitArea=function(t,i,r,n){var a=new e.Rect(t.getCtx(),i-pe._MIN_TOUCH_MARKER_SIZE/2,r-pe._MIN_TOUCH_MARKER_SIZE/2,pe._MIN_TOUCH_MARKER_SIZE,pe._MIN_TOUCH_MARKER_SIZE);n&&a.setSolidStroke("none"),a.setInvisibleFill(),t.addChild(a)},pe._getRangeMarkersForSeries=function(t,i,r){if(!te.isSeriesRendered(t,i))return[];for(var a=e.Agent.isTouchDevice(),o=t.getCtx(),s=t.xAxis,l=J.isAssignedToY2(t,i)?t.y2Axis:t.yAxis,h=t.getOptions(),u=J.getGroupCount(t),g=[],d=0;d<u;d++)if(!J.isDataItemFiltered(t,i,d)&&te.isDataItemRendered(t,i,d)){var p=s.getCoordAt(J.getXValue(t,i,d)),c=l.getUnboundedCoordAt(J.getLowValue(t,i,d)),_=l.getUnboundedCoordAt(J.getHighValue(t,i,d));if(null!=p&&null!=c&&null!=_){var f=te.isMarkerDisplayed(t,i,d);if(!f){var m=u-1,v=ne.isPolar(t),y=v&&m>0&&0==d?m:d-1,S=v&&m>0&&d==m?0:d+1,C=J.getLowValue(t,i,y),A=J.getHighValue(t,i,y),b=J.getLowValue(t,i,S),x=J.getHighValue(t,i,y);null==C&&null==A&&null==b&&null==x&&(f=!0)}if(!(h._duringZoomAndScroll||ne.isOverview(t)||ne.isSpark(t))||f||J.isDataSelected(t,i,d)){var M=pe.convertAxisCoord(t,new e.Point(p,c),r),O=pe.convertAxisCoord(t,new e.Point(p,_),r),T=new e.Point((M.x+O.x)/2,(M.y+O.y)/2),w=te.getMarkerSize(t,i,d),D=new P(o,M.x,M.y,O.x,O.y,w,!f),E=ee.getMarkerFill(t,i,d),I=te.getMarkerBorderColor(t,i,d),L=te.getBorderWidth(t,i,d),R=new e.Stroke(I,1,L),B=te.getMarkerColor(t,i,d),k=te.getSelectedInnerColor(t),z=te.getSelectedOuterColor(t);D.setStyleProperties(E,R,B,k,z),te.isSelectable(t,i,d)&&D.setCursor(e.SelectionEffectUtils.getSelectingCursor());var H=new e.Line(o,M.x,M.y,O.x,O.y);H.setSolidStroke("rgba(0,0,0,0)",null,a?Math.max(w,pe._MIN_TOUCH_MARKER_SIZE):w),D.addChild(H),g.push(D),n.associate(D,t,i,d,null,T)}}}return g},pe._renderBars=function(t,i,r){for(var a=ne.isHorizontal(t),o=ne.isPolar(t),s=ne.isStock(t),l="pixel"==te.getBarSpacing(t),h=e.Agent.isRightToLeft(t.getCtx()),u=te.isStackLabelRendered(t),g=ne.isStacked(t),d=te.getSelectedInnerColor(t),p=te.getSelectedOuterColor(t),c=t.getOptions()._duringZoomAndScroll,_=te.getGroupWidth(t),f={},m=0;m<J.getSeriesCount(t);m++)if("bar"==te.getSeriesType(t,m)){pe._filterPointsForSeries(t,m);for(var v="",y=t.getOptionsCache().getFromCachedMap("itemStyleSet",m),S=J.getStackCategory(t,m)||"",C=J.isAssignedToY2(t,m),A=J.getViewportMinMaxGroupIndex(t,m),b=A.min-1;b<=A.max+1;b++)if(!J.isDataItemFiltered(t,m,b)&&te.isDataItemRendered(t,m,b)&&0!=J.getZValue(t,m,b)){var M=J.getBarInfo(t,m,b,r);if(null!=M){var O=M.yCoord,T=M.baseCoord,w=M.axisCoord,D=M.x1,E=M.x2,P=M.barWidth;if(g){var L=""+b+S+C+(J.getValue(t,m,b)<0);if(Math.abs(T-O)<.5&&Math.abs(O-f[L])<.5&&!J.isOutermostBar(t,m,b))continue;f[L]&&(T=f[L]),f[L]=O}var R,B=!1;if(Math.abs(O-T)<1&&(te.isRangeSeries(t,m)?O--:g&&!J.isOutermostBar(t,m,b)||(B=!0,O=O>T||a&&!h&&O==T?T+3:T-3)),o)R=new I(t,w,T,O,D,E,r);else{var k=c&&_<5&&!y;if(R=new x(t,w,T,O,D,E,k),k){var z=R.getBoundingBox();v+=e.PathUtils.moveTo(z.x,z.y)+e.PathUtils.horizontalLineTo(z.x+z.w)+e.PathUtils.verticalLineTo(z.y+z.h)+e.PathUtils.horizontalLineTo(z.x)+e.PathUtils.closePath();continue}}i.addChild(R),te.isSelectable(t,m,b)&&R.setCursor(e.SelectionEffectUtils.getSelectingCursor());var H,F=null;if(B)H=e.SolidFill.invisibleFill();else{H=ee.getBarFill(t,m,b,P);var N=te.getBorderColor(t,m,b),W=te.getBorderWidth(t,m,b);N&&(F=new e.Stroke(N,1,W))}var G=te.getColor(t,m,b),j=te.getClassName(t,m,b),U=te.getStyle(t,m,b);R.setStyleProperties(H,F,G,d,p,j,U),l&&R.setPixelHinting(!0),n.associate(R,t,m,b,null,M.dataPos),te.isRangeSeries(t,m)?(pe._renderDataLabel(t,i,R.getBoundingBox(),m,b,null,G,"low",!1,R.getOriginalBarSize()),pe._renderDataLabel(t,i,R.getBoundingBox(),m,b,null,G,"high",!1,R.getOriginalBarSize())):pe._renderDataLabel(t,i,R.getBoundingBox(),m,b,null,G,null,!1,R.getOriginalBarSize());var V=new Array;V.push(R),s&&0!=m||t._currentMarkers.push(V),u&&J.isOutermostBar(t,m,b)&&pe._renderDataLabel(t,i,R.getBoundingBox(),m,b,null,null,null,!0,R.getOriginalBarSize())}}if(v){var X=new e.Path(t.getCtx(),v),q=te.getColor(t,m);X.setSolidFill(q);var Y=te.getBorderColor(t,m);if(Y){var K=te.getBorderWidth(t,m);X.setSolidStroke(Y,null,K)}var Z=te.getClassName(t,m),Q=te.getStyle(t,m);X.setClassName(Z).setStyle(Q),l&&X.setPixelHinting(!0),i.addChild(X)}}},pe._renderStock=function(t,i,r){var a=t.getOptions(),o=t.xAxis,s=t.yAxis;if("candlestick"==te.getSeriesType(t,0))for(var l=J.getViewportMinMaxGroupIndex(t,0),h=l.min-1;h<=l.max+1;h++)if(te.isDataItemRendered(t,0,h)){var u=J.getDataItem(t,0,h);if(u){var g=u.open,d=u.close,p=u.low,c=u.high,_=null!=p&&null!=c;if(null!=g&&null!=d){var f,m=J.getXValue(t,0,h),v=o.getUnboundedCoordAt(m),y=te.getBarWidth(t,0,h),S=s.getBoundedCoordAt(g),C=s.getBoundedCoordAt(d),A=null;_&&(f=s.getBoundedCoordAt(p),A=s.getBoundedCoordAt(c));var b=new O(t.getCtx(),v,y,S,C,f,A);i.addChild(b),te.isSelectable(t,0,h)&&b.setCursor(e.SelectionEffectUtils.getSelectingCursor());var x=ee.getBarFill(t,0,h,y),M=null,T=te.getBorderColor(t,0,h),w=te.getBorderWidth(t,0,h);T?M=new e.Stroke(T,1,w):x instanceof e.PatternFill&&(M=new e.Stroke(x.getColor(),1,w));var D=te.getColor(t,0,h),E=te.getSelectedInnerColor(t),I=te.getSelectedOuterColor(t),P=a.styleDefaults.stockRangeColor;b.setChangeStyle(x,M,D,E,I),b.setRangeStyle(new e.SolidFill(P),M,P,I);var L=new e.Point(v,(S+C)/2);n.associate(b,t,0,h,null,L);var R=new Array;R.push(b._changeShape),t._currentMarkers.push(R)}}}},pe._renderBoxPlot=function(t,i,r){for(var a=t.xAxis,o=0;o<J.getSeriesCount(t);o++)for(var s=J.getViewportMinMaxGroupIndex(t,o),l=s.min-1;l<=s.max+1;l++)if(te.isDataItemRendered(t,o,l)&&"boxPlot"==te.getSeriesType(t,o)){var h=J.getDataItem(t,o,l);if(h){var u=h.low,g=h.q1,d=h.q2,p=h.q3,c=h.high;if(null!=u&&null!=g&&null!=d&&null!=p&&null!=c){var _=te.getBarWidth(t,o,l),f=te.getBarCategoryOffsetMap(t,l),m=J.isAssignedToY2(t,o),v=J.getStackCategory(t,o),y=f[m?"y2":"y"][v]+_/2;e.Agent.isRightToLeft(t.getCtx())&&ne.isVertical(t)&&(y*=-1);var S=J.getXValue(t,o,l),C=a.getUnboundedCoordAt(S)+y,A=m?t.y2Axis:t.yAxis,b=A.getBoundedCoordAt(u),x=A.getBoundedCoordAt(g),O=A.getBoundedCoordAt(d),T=A.getBoundedCoordAt(p),w=A.getBoundedCoordAt(c),D=te.getBoxPlotStyleOptions(t,o,l),E=new M(t,C,_,b,x,O,T,w,D);i.addChild(E),te.isSelectable(t,o,l)&&E.setCursor(e.SelectionEffectUtils.getSelectingCursor());var I=pe.convertAxisCoord(t,new e.Point(C,O),r);n.associate(E,t,o,l,null,I),pe._renderBoxPlotMarkers(t,i,o,l,r,C),t._currentMarkers.push([E._medianLine])}}}},pe._renderBoxPlotMarkers=function(t,i,r,n,a,o){for(var s=te.getMarkerBorderColor(t,r,n),l=te.getBorderWidth(t,r,n),h=new e.Stroke(s,1,l),u=[],g=J.getNestedDataItemCount(t,r,n),d=0;d<g;d++){var p=pe._getMarkerInfo(t,r,n,d,a);if(p){ne.isHorizontal(t)?p.y=o:p.x=o;var c=pe._createMarker(t,p,s,l);null!=c&&u.push(c)}}pe._addMarkersToContainer(t,i,u,h)},pe._renderLines=function(e,t,i,r){var n,a=[],o=J.getSeriesCount(e);for(n=0;n<o;n++)te.isSeriesRendered(e,n)&&"line"==te.getSeriesType(e,n)&&a.push(n);for(var s=0;s<a.length;s++)n=a[s],"none"!=te.getLineType(e,n)&&(pe._filterPointsForSeries(e,n),pe._renderLinesForSeries(e,i,n,r));for(s=0;s<a.length;s++)pe._renderMarkersForSeries(e,t,a[s],r)},pe._renderAreas=function(e,t,i,r){for(var n=J.getSeriesCount(e),a=r?"lineWithArea":"area",o=[],s=[],l=0;l<n;l++)te.isSeriesRendered(e,l)&&te.getSeriesType(e,l)==a&&(J.isAssignedToY2(e,l)?s.push(l):o.push(l));o.length>0&&pe._renderAreasForAxis(e,t,o,e.yAxis.getBaselineCoord(),i,r),s.length>0&&pe._renderAreasForAxis(e,t,s,e.y2Axis.getBaselineCoord(),i,r)},pe._renderAreasForAxis=function(t,i,r,a,o,s){for(var l=ne.isStacked(t),h=pe.createClippedGroup(t,i,o),u={},g={},d={},p={},c=[],_=J.getGroupCount(t),f=0;f<_;f++)c.push(new T(null,a,a,f,J.getGroup(t,f),!0));for(var m=0;m<r.length;m++){var v=r[m],y=J.getStackCategory(t,v),S=J.isSeriesNegative(t,v),C=u[y],A=g[y],b=d[y],x=p[y];if("none"!=te.getLineType(t,v)){var M,O,D,E=ee.getAreaFill(t,v),I=te.getBorderColor(t,v),P=te.getBorderWidth(t,v),L=te.getAreaClassName(t,v),R=te.getAreaStyle(t,v),B=I?new e.Stroke(I,1,P):null,k=te.getLineType(t,v);pe._filterPointsForSeries(t,v),te.isRangeSeries(t,v)?(M=pe._getCoordsForSeries(t,v,o,"high"),O=pe._getCoordsForSeries(t,v,o,"low"),D=k):S?(M=pe._getAreaCoordsForSeries(t,v,o,b||c),O=b||[],D=x):(M=pe._getAreaCoordsForSeries(t,v,o,C||c),O=C||[],D=A);var z=new w(t,!0,o,a,R,L,E,B,k,M,D,O);h.addChild(z),t._currentAreas.push(z),n.associate(z,t,v),S?(d[y]=M,p[y]=k):(u[y]=M,g[y]=k),l||((s||te.getDataItemGaps(t)>0&&!I)&&pe._renderLinesForSeries(t,h,v,o,!s),s||pe._renderMarkersForSeries(t,i,v,o),m+1<r.length&&(h=pe.createClippedGroup(t,i,o)))}else pe._renderMarkersForSeries(t,i,v,o)}for(m=0;m<r.length;m++)if(v=r[m],"none"!=te.getLineType(t,v)){var H=te.getBorderColor(t,v)||te.getBorderColor(t,v+1);l&&(s||te.getDataItemGaps(t)>0&&!H)&&pe._renderLinesForSeries(t,h,v,o,!s),(l||s)&&pe._renderMarkersForSeries(t,i,v,o)}},pe._getAreaCoordsForSeries=function(e,t,i,r){for(var n=pe._getCoordsForSeries(e,t,i),a=[],o=0;o<r.length;o++)a.push(r[o].clone());var s=n.length-1,l=ne.isPolar(e);for(o=0;o<n.length;o++)if(null!=n[o].x){var h=a[n[o].groupIndex],u=l&&0==o?s:o-1,g=l&&o==s?0:o+1;u>=0&&null!=n[u].x&&(h.y1=n[o].y1),g<=s&&null!=n[g].x&&(h.y2=n[o].y2),h.x=n[o].x,h.filtered=h.y1==h.y2&&n[o].filtered}return a},pe._renderLinesForSeries=function(t,i,r,a,o){var s;if(o){var l=2.5*te.getDataItemGaps(t);s=new e.Stroke(te.getBackgroundColor(t,!0),1,l)}else{var h=te.getColor(t,r),u=te.getLineWidth(t,r),g=te.getLineStyle(t,r);s=new e.Stroke(h,1,u,!1,e.Stroke.getDefaultDashProps(g,u))}var d=J.isAssignedToY2(t,r)?t.y2Axis.getBaselineCoord():t.yAxis.getBaselineCoord(),p=te.getLineType(t,r),c=te.getClassName(t,r),_=te.getStyle(t,r),f=function(e){var o=pe._getCoordsForSeries(t,r,a,e),l=new w(t,!1,a,d,_,c,null,s,p,o);i.addChild(l),n.associate(l,t,r)};te.isRangeSeries(t,r)?(f("high"),f("low")):f("value")},pe._filterScatterBubble=function(t,i,r){var n,a=J.getSeriesCount(t),o=J.getGroupCount(t);if(a*o<pe.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;for(var s=[],l=0;l<a;l++)if(te.isSeriesRendered(t,l))for(var h=0;h<o;h++)null!=(n=pe._getScatterBubbleMarkerInfo(t,l,h,r))&&s.push(n);if(s.length<pe.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;i&&ae.sortMarkerInfos(s);for(var u=new e.PixelMap(25,new e.PixelMap(5,new e.PixelMap)),g=[],d=s.length-1;d>=0;d--)if(n=s[d],!ae.checkPixelMap(u,n.x,n.y,n.size)){var p=te.getColor(t,n.seriesIndex,n.groupIndex),c=te.isMarkerDisplayed(t,l,h)?e.ColorUtils.getAlpha(p):0;c>0&&(ae.updatePixelMap(u,n.x,n.y,n.size,c),g.push(n))}return t.getCache().putToCache("dataFiltered",!0),g.reverse(),g},pe._filterPointsForSeries=function(e,t){if(!ne.isPolar(e)&&!te.isRangeSeries(e,t)){var i=e.__getPlotAreaSpace().w,r=J.getSeriesItem(e,t).items,n="bar"==te.getSeriesType(e,t),a=e.xAxis.getInfo(),o=(a.getDataMax()-a.getDataMin())/(a.getViewportMax()-a.getViewportMin()),s=n?.5:2,l=o?Math.round(s*(r.length/o)/i):1;if(l<(n?2:3))for(var h=0;h<r.length;h++)(c=r[h])&&(c._filtered=!1);else{var u,g,d,p,c,_,f=!1;for(h=0;h<r.length;h+=l){u=-1,g=-1/0,d=-1,p=1/0;for(var m=h;m<Math.min(h+l,r.length);m++)_=J.getCumulativeValue(e,t,m),c=r[m],null!=_&&null!=c&&((!n||_>0)&&_>g&&(u=m,g=_),(!n||_<0)&&_<p&&(d=m,p=_),c._filtered=!0,f=!0);for(m=h;m<Math.min(h+l,r.length);m++)null!=(c=r[m])&&(m!=u&&m!=d||(c._filtered=!1))}e.getCache().putToCache("dataFiltered",f)}}},pe._getCoordsForSeries=function(e,t,i,r){var n=e.xAxis,a=e.yAxis;J.isAssignedToY2(e,t)&&(a=e.y2Axis);for(var o=[],s=J.getViewportMinMaxGroupIndex(e,t),l=s.min-1;l<=s.max+1;l++){var h=J.getGroup(e,l);if(null!=h){var u=J.getXValue(e,t,l),g=null;if("low"==r?g=J.getLowValue(e,t,l):"high"==r?g=J.getHighValue(e,t,l):null!=J.getValue(e,t,l)&&(g=J.getCumulativeValue(e,t,l)),null!=g&&!isNaN(g)&&te.isDataItemRendered(e,t,l)){ne.isPolar(e)&&(g=Math.max(g,a.getInfo().getViewportMin()));var d=n.getUnboundedCoordAt(u),p=a.getUnboundedCoordAt(g);if(null!=d&&null!=p){var c=new T(d,p,p,l,h,J.isDataItemFiltered(e,t,l));o.push(c)}else o.push(new T(null,null,null,l,h,!1))}else o.push(new T(null,null,null,l,h,!1))}}return o},pe.createClippedGroup=function(t,i,r){var n=new e.Container(i.getCtx());i.addChild(n);var a=new e.ClipPath(t.getId()),o=pe._extendClipGroup(t);if(ne.isPolar(t)){var s=r.x+r.w/2,l=r.y+r.h/2;if(Z.isGridPolygonal(t)){var h=e.PolygonUtils.getRegularPolygonPoints(s,l,J.getGroupCount(t),t.getRadius(),0);a.addPolygon(h)}else a.addCircle(s,l,t.getRadius())}else ne.isHorizontal(t)?a.addRect(r.x-o,r.y,r.w+2*o,r.h):a.addRect(r.x,r.y-o,r.w,r.h+2*o);return n.setClipPath(a),n},pe.polarToCartesian=function(t,i,r){var n=r.x+r.w/2+t*Math.sin(i),a=r.y+r.h/2-t*Math.cos(i);return new e.Point(n,a)},pe.convertAxisCoord=function(t,i,r){if(ne.isPolar(t)){var n=pe.polarToCartesian(i.y,i.x,r);return new e.Point(n.x,n.y)}return ne.isHorizontal(t)?new e.Point(i.y,i.x):new e.Point(i.x,i.y)},pe._extendClipGroup=function(e){if((ne.hasLineSeries(e)||ne.hasLineWithAreaSeries(e))&&!ne.isSpark(e)){var t=te.getLineWidth(e),i=function(e){var i=e.getInfo(),r=i.getCoordAt(i.getGlobalMax()),n=i.getCoordAt(i.getDataMax()),a=i.getCoordAt(i.getGlobalMin()),o=i.getCoordAt(i.getDataMin());return null!=r&&null!=n&&n-r<=t/2||null!=a&&null!=o&&a-o<=t/2};if(e.yAxis&&i(e.yAxis)||e.y2Axis&&i(e.y2Axis))return Math.ceil(t/2)}return 0};var ce=new Object;e.Obj.createSubclass(ce,e.Obj),ce._DEFAULT_3D_GAP_RATIO=1/36,ce._DEFAULT_2D_GAP_RATIO=1/70,ce._MAX_WIDTH_FOR_GAPS=.25,ce._GROUP_INDEX=0,ce._SLICE_VALUE_THRESHOLD=1e-4,ce.render=function(t,i,r){var n=new e.Container(t.getCtx());n.setTranslate(r.x,r.y),i.addChild(n),t.setPlotArea(n);var a,o=ne.isHorizontal(t);if(o)a=new e.Rectangle(0,0,r.w,r.h);else{var s=new e.Matrix,l=e.Agent.isRightToLeft(t.getCtx())?-1:1;s=(s=(s=s.translate(-r.h/2,-r.w/2)).rotate(l*Math.PI/2)).translate(r.x+r.w/2,r.y+r.h/2),a=new e.Rectangle(0,0,r.h,r.w),n.setMatrix(s)}Q.addPlotAreaDnDBackground(t,n,r,o),ce._renderFunnelSlices(t,n,a)||ue.renderEmptyText(t,i,r);var h=J.getInitialSelection(t);Q.setInitialSelection(t,h),t.highlight(te.getHighlightedCategories(t))},ce._renderFunnelSlices=function(e,t,i){for(var r=e.getOptions(),a=J.getSeriesCount(e),o=te.getDataItemGaps(e),s=("on"==r.styleDefaults.threeDEffect?ce._DEFAULT_3D_GAP_RATIO:ce._DEFAULT_2D_GAP_RATIO)*i.w,l=o*Math.min(ce._MAX_WIDTH_FOR_GAPS*i.w/(a-1),s),h=0,u=0,g=0,d=0;d<a;d++)te.isDataItemRendered(e,d)&&(null==(c=J.getTargetValue(e,d))&&(c=J.getValue(e,d,ce._GROUP_INDEX)),c<=0||(h+=c));if(0==h)return!1;for(d=a-1;d>=0;d--)if(te.isDataItemRendered(e,d)){var p,c=J.getValue(e,d,ce._GROUP_INDEX),_=J.getTargetValue(e,d);c<=0&&null==_||null!=_&&_<=0||(null!=_?_:c)<ce._SLICE_VALUE_THRESHOLD*h||(null!=_?(g+=_/h,p=new R(e,d,u,i.w,i.h,1-g,_/h,c/_,l)):(g+=c/h,p=new R(e,d,u,i.w,i.h,1-g,c/h,null,l)),u++,t.addChild(p),n.associate(p,e,d,ce._GROUP_INDEX))}return!0};var _e=new Object;e.Obj.createSubclass(_e,e.Obj),_e._DEFAULT_GAP_RATIO=1/70,_e._MAX_HEIGHT_FOR_GAPS=.25,_e._GROUP_INDEX=0,_e.render=function(t,i,r){var n=new e.Container(t.getCtx());n.setTranslate(r.x,r.y),i.addChild(n),t.setPlotArea(n);var a=new e.Rectangle(0,0,r.w,r.h);Q.addPlotAreaDnDBackground(t,n,r,!0),_e._renderPyramidSlices(t,n,a)||ue.renderEmptyText(t,i,r);var o=J.getInitialSelection(t);Q.setInitialSelection(t,o),t.highlight(te.getHighlightedCategories(t))},_e._renderPyramidSlices=function(e,t,i){for(var r=J.getSeriesCount(e),a=te.getDataItemGaps(e),o=_e._DEFAULT_GAP_RATIO*i.h,s=a*Math.min(_e._MAX_HEIGHT_FOR_GAPS*i.h/(r-1),o),l=0,h=0,u=0,g=0;g<r;g++)te.isDataItemRendered(e,g)&&((d=J.getValue(e,g,_e._GROUP_INDEX))<=0||(l+=d));if(0==l)return!1;for(g=0;g<r;g++){var d;if(te.isDataItemRendered(e,g)&&!((d=J.getValue(e,g,_e._GROUP_INDEX))<=0)){var p=new B(e,g,h,i.w,i.h,u,d/l,s);u+=d/l,h++,t.addChild(p),n.associate(p,e,g,_e._GROUP_INDEX)}}return!0};var fe=new Object;e.Obj.createSubclass(fe,e.Obj),
fe.renderBackgroundObjects=function(e,t,i){fe._renderObjects(e,t,i,"back")},fe.renderForegroundObjects=function(e,t,i){fe._renderObjects(e,t,i,"front")},fe._renderObjects=function(e,t,i,r){fe._renderObjectsForAxis(e,t,i,r,e.xAxis,$.getAxisRefObjs(e,"x")),fe._renderObjectsForAxis(e,t,i,r,e.yAxis,$.getAxisRefObjs(e,"y")),fe._renderObjectsForAxis(e,t,i,r,e.y2Axis,$.getAxisRefObjs(e,"y2"))},fe._renderObjectsForAxis=function(e,t,i,r,n,o){if(o&&n)for(var s=0;s<o.length;s++){var l=o[s];if($.isObjectRendered(e,l)&&l&&$.getLocation(l)==r){var h,u=$.getType(l);if("area"==u?h=fe._createReferenceArea(l,e,i,n):"line"==u&&(h=fe._createReferenceLine(l,e,i,n)),null!=h){var g=n==e.xAxis?"xAxis":n==e.yAxis?"yAxis":"y2Axis",d=new a(e,[h],l,s,g);e.registerObject(d),e.getEventManager().associate(h,d),t.addChild(h)}}}},fe._createReferenceArea=function(t,i,r,n){var a,o=i.getCtx(),s=n.getPosition(),l="top"==s||"bottom"==s,h="radial"==s,u=$.getColor(t),g=$.getLineType(t),d=t.style||t.svgStyle,p=t.className||t.svgClassName;if(null==t.items||n!=i.yAxis&&n!=i.y2Axis){var c=$.getLowValue(t),_=$.getHighValue(t);null!=c&&c!=-1/0||(c=n.getInfo().getGlobalMin()),null!=_&&_!=1/0||(_=n.getInfo().getGlobalMax());var f=fe._getAxisCoord(i,n,c),m=fe._getAxisCoord(i,n,_);if(ne.isPolar(i)){var v,y=r.x+r.w/2,S=r.y+r.h/2;if(h)if(Z.isGridPolygonal(i)){var C=J.getGroupCount(i),A=e.PolygonUtils.getRegularPolygonPoints(y,S,C,m,0,1),b=e.PolygonUtils.getRegularPolygonPoints(y,S,C,f,0,0);v=e.PathUtils.polyline(A)+e.PathUtils.polyline(b)+e.PathUtils.closePath()}else v=e.PathUtils.moveTo(y,S-m)+e.PathUtils.arcTo(m,m,Math.PI,1,y,S+m)+e.PathUtils.arcTo(m,m,Math.PI,1,y,S-m)+e.PathUtils.moveTo(y,S-f)+e.PathUtils.arcTo(f,f,Math.PI,0,y,S+f)+e.PathUtils.arcTo(f,f,Math.PI,0,y,S-f)+e.PathUtils.closePath();else{var x=i.getRadius(),M=pe.polarToCartesian(x,f,r),O=pe.polarToCartesian(x,m,r);v=e.PathUtils.moveTo(y,S)+e.PathUtils.lineTo(M.x,M.y)+e.PathUtils.arcTo(x,x,m-f,e.Agent.isRightToLeft(o)?0:1,O.x,O.y)+e.PathUtils.lineTo(O.x,O.y)+e.PathUtils.closePath()}a=new e.Path(o,v)}else{var D;D=l?[f,0,m,0,m,r.h,f,r.h]:[0,f,0,m,r.w,m,r.w,f],a=new e.Polygon(o,D)}a.setSolidFill(u),a.setStyle(d).setClassName(p)}else{var E=t.items,I=[],P=[];if(i.xAxis.isGroupAxis())for(;E.length<J.getGroupCount(i);)E.push(null);for(var L=0;L<E.length;L++){var R=E[L],B=$.getLowValue(R),k=$.getHighValue(R);if(null!=B&&null!=k){var z=n.getUnboundedCoordAt(B),H=n.getUnboundedCoordAt(k),F=i.xAxis.getUnboundedCoordAt($.getXValue(i,E,L));I.push(new T(F,H,H)),P.push(new T(F,z,z))}else I.push(new T),P.push(new T)}a=new w(i,!0,r,null,d,p,new e.SolidFill(u),null,g,I,g,P)}return a},fe._createReferenceLine=function(t,i,r,n){var a,o=n.getPosition(),s="top"==o||"bottom"==o,l="radial"==o,h="tangential"==o,u=$.getLineWidth(t),g=$.getLineType(t),d=$.getColor(t),p=t.style||t.svgStyle,c=t.className||t.svgClassName,_=new e.Stroke(d,1,u,!1,e.Stroke.getDefaultDashProps(t.lineStyle,u)),f=i.getCtx();if(null==t.items||n!=i.yAxis&&n!=i.y2Axis){if(!t.value)return null;var m=fe._getAxisCoord(i,n,t.value);if(null==m||m==1/0||m==-1/0)return null;var v=r.x+r.w/2,y=r.y+r.h/2;if(l)Z.isGridPolygonal(i)?(C=e.PolygonUtils.getRegularPolygonPoints(v,y,J.getGroupCount(i),m,0),a=new e.Polygon(f,C)):a=new e.Circle(f,v,y,m),a.setFill(null);else if(h){var S=pe.polarToCartesian(i.getRadius(),m,r);a=new e.Line(f,v,y,S.x,S.y)}else(a=s?new e.Line(f,m,0,m,r.h):new e.Line(f,0,m,r.w,m)).setPixelHinting(!0);a.setStroke(_),a.setStyle(p).setClassName(c)}else{var C,A=t.items;if([].push(C=[]),i.xAxis.isGroupAxis())for(;A.length<J.getGroupCount(i);)A.push(null);for(var b=[],x=0;x<A.length;x++){var M=A[x],O=null;if(null!=M&&("object"!=typeof M?O=M:null!=M.value&&(O=M.value)),null!=O){var D=n.getUnboundedCoordAt(O),E=i.xAxis.getUnboundedCoordAt($.getXValue(i,A,x));b.push(new T(E,D,D))}else b.push(new T)}a=new w(i,!1,r,null,p,c,null,_,g,b)}return a},fe._getAxisCoord=function(e,t,i){if(t.isGroupAxis()){var r=J.getGroupIndex(e,i);if(r>=0)return t.getUnboundedCoordAt(r)}return isNaN(i)?null:t.getUnboundedCoordAt(i)},e.SparkChart=function(){},e.Obj.createSubclass(e.SparkChart,e.BaseComponent),e.SparkChart.newInstance=function(t,i,r){var n=new e.SparkChart;return t.getStage().setCursor(""),n.Init(t,i,r),n},e.SparkChart.getDefaults=function(e){return(new ve).getDefaults(e)},e.SparkChart.prototype.Init=function(t,i,r){e.SparkChart.superclass.Init.call(this,t,i,r),this.Defaults=new ve(t),this.EventManager=new ye(this),this.EventManager.addListeners(this),this._chart=e.Chart.newInstance(t,this._onRenderEnd,this),this.addChild(this._chart),e.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new e.KeyboardHandler(this.EventManager,this)),this._tooltipMask=new e.Rect(t),this.addChild(this._tooltipMask),this.setId("sparkChart1000"+Math.floor(1e9*Math.random()))},e.SparkChart.prototype.SetOptions=function(t){t?(this.Options=this.Defaults.calcOptions(t),e.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults())},e.SparkChart.prototype.setId=function(t){e.SparkChart.superclass.setId.call(this,t),this._chart&&this._chart.setId(t+"chart")},e.SparkChart.prototype.render=function(t,i,r){this.SetOptions(t),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r),this._eventReceived=!1,this._isDoneRendering=!1,Se.render(this,this.Width,this.Height);var n=this.Options.shortDesc;this._tooltipMask.setWidth(this.Width),this._tooltipMask.setHeight(this.Height),this._tooltipMask.setInvisibleFill();var a=this.Options.tooltip,o=a?a.renderer:null,s=this.Options.color;if(o){var l={component:this.Options._widgetConstructor,color:s};this._peer=new e.CustomDatatipPeer(this.getCtx().getTooltipManager(),o,s,l),this.EventManager.associate(this._tooltipMask,this._peer)}else n?(this._peer=new e.SimpleObjPeer(null,n,s),this.EventManager.associate(this._tooltipMask,this._peer)):this._peer=null;this.Options._selectingCursor&&this.setCursor(e.SelectionEffectUtils.getSelectingCursor()),this.UpdateAriaAttributes(),this._eventReceived&&this.RenderComplete(),this._isDoneRendering=!0},e.SparkChart.prototype._onRenderEnd=function(e){this._eventReceived=!0,"ready"==e.type&&this._isDoneRendering&&this.RenderComplete()},e.SparkChart.prototype.__getChart=function(){return this._chart},e.SparkChart.prototype.getAutomation=function(){return new me(this)},e.SparkChart.prototype.UpdateAriaAttributes=function(){var t=e.Displayable.generateAriaLabel(e.TextUtils.processAriaLabel(this.GetComponentDescription()),this.Options.shortDesc?[this.Options.shortDesc]:null),i=this.Options.translations;this.IsParentRoot()?(this.getCtx().setAriaRole("img"),this.getCtx().setAriaLabel(e.ResourceUtils.format(i.labelAndValue,[i.labelDataVisualization,t]))):(this.setAriaRole("img"),this.setAriaProperty("label",t))},e.SparkChart.prototype.__getLogicalObject=function(){return this._peer};var me=function(e){this._sparkChart=e};e.Obj.createSubclass(me,e.Automation),me.prototype.getDataItem=function(e){var t=this._sparkChart.__getChart().getAutomation().getDataItem(0,e);return t?{borderColor:t.borderColor,color:t.color,date:t.x,low:t.low,high:t.high,value:null==t.low||null==t.high?t.value:t.high-t.low}:null};var ve=function(e){this.Init({alta:ve.SKIN_ALTA},e)};e.Obj.createSubclass(ve,e.BaseComponentDefaults),ve.SKIN_ALTA={skin:e.CSSStyle.SKIN_ALTA,type:"line",animationOnDisplay:"none",animationOnDataChange:"none",areaSvgClassName:"",emptyText:null,color:"#267db3",firstColor:"",lastColor:"",highColor:"",lowColor:"",visualEffects:"auto",baselineScaling:"min",barSpacing:"auto",lineWidth:1,lineStyle:"solid",lineType:"straight",markerSize:5,markerShape:"auto",barGapRatio:.25,referenceObjects:[],svgClassName:"",_statusMessageStyle:new e.CSSStyle("font-size: 12px; color: #404259;")},ve.prototype.getAnimationDuration=function(e){return e.animationDuration};var ye=function(e){this.Init(e.getCtx(),e.dispatchEvent,e,e),this._sparkChart=e};e.Obj.createSubclass(ye,e.EventManager),ye.prototype.ProcessKeyboardEvent=function(t){if(!this.KeyboardHandler)return!1;if(t.keyCode==e.KeyboardEvent.TAB){var i=this._sparkChart.getCtx().getStageAbsolutePosition();this.ProcessObjectTooltip(t,i.x,i.y,this._sparkChart.__getLogicalObject(),this._sparkChart)}return!1},ye.prototype.OnBlur=function(e){ye.superclass.OnBlur.call(this,e),this.hideTooltip()};var Se=new Object;e.Obj.createSubclass(Se,e.Obj),Se.render=function(e,t,i){var r=e.__getChart(),n=Se._convertOptionsObj(e),a=e.getOptions();if("area"==a.type||"line"==a.type||"lineWithArea"==a.type){var o=Se._getDataItems(e),s=!1;if(a.firstColor||a.lastColor||a.highColor||a.lowColor)s=!0;else for(var l=0;l<o.length;l++)if(o[l]&&"on"==o[l].markerDisplayed){s=!0;break}if(s&&o.length>0||"none"==a.lineType){var h=a.markerSize/2;t-=2*h,i-=2*h,r.setTranslate(h,h)}}r.render(n,t,i)},Se._getDataItems=function(e){var t=e.getOptions();return t&&t.items?t.items:[]},Se._convertOptionsObj=function(t){var i=t.getOptions(),r={styleDefaults:{},xAxis:{},yAxis:{},groups:[]};r.translations=i.translations;for(var n=[],a=-1,o=-1,s=-1/0,l=1/0,h=Se._getDataItems(t),u=0;u<h.length;u++){var g=h[u],d={};g instanceof Object?(d.value=g.value,d.low=g.low,d.high=g.high,g.date&&(r.timeAxisType="enabled",r.groups.push(g.date)),"on"==g.markerDisplayed&&(d.markerDisplayed="on"),g.color&&(d.color=g.color),g.borderColor&&(d.borderColor=g.borderColor),g.markerShape&&(d.markerShape=g.markerShape),g.markerSize&&(d.markerSize=g.markerSize),(g.className||g.svgClassName)&&(d.svgClassName=g.className||g.svgClassName),(g.style||g.svgStyle)&&(d.svgStyle=g.style||g.svgStyle)):d.value=g,n.push(d);var p=null!=d.value?d.value:Math.max(d.low,d.high);s<p&&(s=p,a=u);var c=null!=d.value?d.value:Math.min(d.low,d.high);l>c&&(l=c,o=u)}i.highColor&&a>=0&&(n[a].markerDisplayed="on",n[a].color||(n[a].color=i.highColor)),i.lowColor&&o>=0&&(n[o].markerDisplayed="on",n[o].color||(n[o].color=i.lowColor)),i.firstColor&&n.length>0&&(n[0].markerDisplayed="on",n[0].color||(n[0].color=i.firstColor)),i.lastColor&&n.length>0&&(n[n.length-1].markerDisplayed="on",n[n.length-1].color||(n[n.length-1].color=i.lastColor)),r.series=[{items:n,areaColor:i.areaColor,svgClassName:i.className||i.svgClassName,svgStyle:i.style||i.svgStyle,areaSvgClassName:i.areaClassName||i.areaSvgClassName,areaStyle:i.areaStyle||i.areaSvgStyle}],i.referenceObjects&&i.referenceObjects.length>0&&(r.yAxis.referenceObjects=i.referenceObjects),r.__spark=!0;var _=i.barSpacing;"auto"==_&&(_=e.Agent.getDevicePixelRatio()>1?"subpixel":"pixel"),r.__sparkBarSpacing=_,r.type=i.type,r.animationOnDataChange=i.animationOnDataChange,r.animationOnDisplay=i.animationOnDisplay,r.emptyText=i.emptyText,i.color&&(r.styleDefaults.colors=[i.color]),r.styleDefaults.animationDuration=i.animationDuration,r.styleDefaults.animationIndicators="none",r.styleDefaults.lineWidth=i.lineWidth,r.styleDefaults.lineStyle=i.lineStyle,r.styleDefaults.lineType=i.lineType,r.styleDefaults.markerSize=i.markerSize,r.styleDefaults.markerShape=i.markerShape,r.styleDefaults.barGapRatio=i.barGapRatio,r.styleDefaults.dataItemGaps="0%",r.xAxis.rendered="off",r.yAxis.rendered="off";var f="zero"==i.baselineScaling,m=s!=l?.1*(s-l):.1*Math.abs(s);return r.yAxis.min=f&&l>=0?0:l-m,r.yAxis.max=f&&s<=0?0:s+m,"none"==i.visualEffects||"area"!=i.type&&"lineWithArea"!=i.type?r.styleDefaults.seriesEffect="color":r.styleDefaults.seriesEffect="gradient",r.layout={gapWidthRatio:0,gapHeightRatio:0},r.legend={rendered:"off"},r._statusMessageStyle=i._statusMessageStyle,r}}(e),e}),define("ojs/ojchart",["ojs/ojcore","jquery","ojs/ojconfig","ojs/ojcomponentcore","ojs/ojdvt-base","ojs/internal-deps/dvt/DvtChart","ojs/ojattributegrouphandler","ojs/ojkeyset","ojs/ojlogger","ojs/ojmap","ojs/ojvalidation-base","ojs/ojvalidation-number"],function(e,t,i,r,n,a,o,s,l,h,u){"use strict";var g={properties:{animationOnDataChange:{type:"string",enumValues:["auto","none","slideToLeft","slideToRight"],value:"none"},animationOnDisplay:{type:"string",enumValues:["alphaFade","auto","none","zoom"],value:"none"},as:{type:"string",value:""},coordinateSystem:{type:"string",enumValues:["cartesian","polar"],value:"cartesian"},data:{type:"object"},dataCursor:{type:"string",enumValues:["auto","off","on"],value:"auto"},dataCursorBehavior:{type:"string",enumValues:["auto","smooth","snap"],value:"auto"},dataCursorPosition:{type:"object",writeback:!0,properties:{x:{type:"number|string"},y:{type:"number"},y2:{type:"number"}}},dataLabel:{type:"function"},dnd:{type:"object",properties:{drag:{type:"object",properties:{groups:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},items:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},series:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}}}},drop:{type:"object",properties:{legend:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},plotArea:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},xAxis:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},y2Axis:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},yAxis:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}}}}}},dragMode:{type:"string",enumValues:["off","pan","select","user","zoom"],value:"user"},drilling:{type:"string",enumValues:["groupsOnly","off","on","seriesOnly"],value:"off"},groupComparator:{type:"function"},groups:{type:"Array<string>|Array<Object>|Promise"},hiddenCategories:{type:"Array<string>",writeback:!0,value:[]},hideAndShowBehavior:{type:"string",enumValues:["none","withRescale","withoutRescale"],value:"none"},highlightMatch:{type:"string",enumValues:["all","any"],value:"all"},highlightedCategories:{type:"Array<string>",writeback:!0,value:[]},hoverBehavior:{type:"string",enumValues:["dim","none"],value:"none"},initialZooming:{type:"string",enumValues:["first","last","none"],value:"none"},legend:{type:"object",properties:{backgroundColor:{type:"string"},borderColor:{type:"string"},maxSize:{type:"string"},position:{type:"string",enumValues:["auto","bottom","end","start","top"],value:"auto"},referenceObjectSection:{type:"object",properties:{title:{type:"string"},titleHalign:{type:"string",enumValues:["center","end","start"],value:"start"},titleStyle:{type:"object",value:{}}}},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"},scrolling:{type:"string",enumValues:["asNeeded","off"],value:"asNeeded"},sections:{type:"Array<Object>",value:[]},seriesSection:{type:"object",properties:{title:{type:"string"},titleHalign:{type:"string",enumValues:["center","end","start"],value:"start"},titleStyle:{type:"object",value:{}}}},size:{type:"string"},symbolHeight:{type:"number"},symbolWidth:{type:"number"},textStyle:{type:"object",value:{}},title:{type:"string"},titleHalign:{type:"string",enumValues:["center","end","start"],value:"start"},titleStyle:{type:"object",value:{}}}},orientation:{type:"string",enumValues:["horizontal","vertical"],value:"vertical"},otherThreshold:{type:"number",value:0},overview:{type:"object",properties:{content:{type:"object",value:{}},height:{type:"string"},rendered:{type:"string",enumValues:["off","on"],value:"off"}}},pieCenter:{type:"object",properties:{converter:{type:"object"},label:{type:"string"},labelStyle:{type:"object",value:{}},renderer:{type:"function"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"}}},plotArea:{type:"object",properties:{backgroundColor:{type:"string"},borderColor:{type:"string"},borderWidth:{type:"number"},rendered:{type:"string",enumValues:["off","on"],value:"on"}}},polarGridShape:{type:"string",enumValues:["circle","polygon"],value:"circle"},selection:{type:"Array<any>",writeback:!0,value:[]},selectionMode:{type:"string",enumValues:["multiple","none","single"],value:"none"},series:{type:"Array<Object>|Promise"},seriesComparator:{type:"function"},sorting:{type:"string",enumValues:["ascending","descending","off"],value:"off"},splitDualY:{type:"string",enumValues:["auto","off","on"],value:"auto"},splitterPosition:{type:"number",value:.5},stack:{type:"string",enumValues:["off","on"],value:"off"},stackLabel:{type:"string",enumValues:["off","on"],value:"off"},styleDefaults:{type:"object",properties:{animationDownColor:{type:"string"},animationDuration:{type:"number"},animationIndicators:{type:"string",enumValues:["all","none"],value:"all"},animationUpColor:{type:"string"},barGapRatio:{type:"number"},borderColor:{type:"string"},borderWidth:{type:"number"},boxPlot:{type:"object",properties:{medianSvgClassName:{type:"string",value:""},medianSvgStyle:{type:"object",value:{}},whiskerEndLength:{type:"string"},whiskerEndSvgClassName:{type:"string",value:""},whiskerEndSvgStyle:{type:"object",value:{}},whiskerSvgClassName:{type:"string",value:""},whiskerSvgStyle:{type:"object",value:{}}}},colors:{type:"Array<string>"},dataCursor:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},markerColor:{type:"string"},markerDisplayed:{type:"string",enumValues:["off","on"],value:"on"},markerSize:{type:"number"}}},dataItemGaps:{type:"string"},dataLabelPosition:{type:"string|Array<string>",enumValues:["aboveMarker","afterMarker","auto","beforeMarker","belowMarker","center","insideBarEdge","none","outsideBarEdge","outsideSlice"],value:"auto"},dataLabelStyle:{type:"object|Array<Object>"},funnelBackgroundColor:{type:"string"},groupSeparators:{type:"object",properties:{color:{type:"string"},rendered:{type:"string",enumValues:["auto","off"],value:"auto"}}},hoverBehaviorDelay:{type:"number"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineType:{type:"string",enumValues:["auto","centeredSegmented","centeredStepped","curved","none","segmented","stepped","straight"],value:"auto"},lineWidth:{type:"number"},markerColor:{type:"string"},markerDisplayed:{type:"string",enumValues:["auto","off","on"],value:"auto"},markerShape:{type:"string",value:"auto"},markerSize:{type:"number"},marqueeBorderColor:{type:"string"},marqueeColor:{type:"string"},maxBarWidth:{type:"number"},otherColor:{type:"string"},patterns:{type:"Array<string>"},pieFeelerColor:{type:"string"},pieInnerRadius:{type:"number",value:0},selectionEffect:{type:"string",enumValues:["explode","highlight","highlightAndExplode"],value:"highlight"},seriesEffect:{type:"string",enumValues:["color","gradient","pattern"],value:"gradient"},shapes:{type:"Array<string>"},stackLabelStyle:{type:"object",value:{}},stockFallingColor:{type:"string"},stockRangeColor:{type:"string"},stockRisingColor:{type:"string"},stockVolumeColor:{type:"string"},threeDEffect:{type:"string",enumValues:["off","on"],value:"off"},tooltipLabelStyle:{type:"object",value:{}},tooltipValueStyle:{type:"object",value:{}}}},timeAxisType:{type:"string",enumValues:["auto","disabled","enabled","mixedFrequency","skipGaps"],value:"auto"},tooltip:{type:"object",properties:{renderer:{type:"function"}}},touchResponse:{type:"string",enumValues:["auto","touchStart"],value:"auto"},trackResize:{type:"string",enumValues:["off","on"],value:"on"},translations:{type:"object",value:{},properties:{componentName:{type:"string"},labelAndValue:{type:"string"},labelClearSelection:{type:"string"},labelClose:{type:"string"},labelCountWithTotal:{type:"string"},labelDataVisualization:{type:"string"},labelDate:{type:"string"},labelDefaultGroupName:{type:"string"},labelGroup:{type:"string"},labelHigh:{type:"string"},labelInvalidData:{type:"string"},labelLow:{type:"string"},labelNoData:{type:"string"},labelOpen:{type:"string"},labelOther:{type:"string"},labelPercentage:{type:"string"},labelQ1:{type:"string"},labelQ2:{type:"string"},labelQ3:{type:"string"},labelSeries:{type:"string"},labelTargetValue:{type:"string"},labelValue:{type:"string"},labelVolume:{type:"string"},labelX:{type:"string"},labelY:{type:"string"},labelZ:{type:"string"},stateCollapsed:{type:"string"},stateDrillable:{type:"string"},stateExpanded:{type:"string"},stateHidden:{type:"string"},stateIsolated:{type:"string"},stateMaximized:{type:"string"},stateMinimized:{type:"string"},stateSelected:{type:"string"},stateUnselected:{type:"string"},stateVisible:{type:"string"},tooltipPan:{type:"string"},tooltipSelect:{type:"string"},tooltipZoom:{type:"string"}}},type:{type:"string",enumValues:["area","bar","boxPlot","bubble","combo","funnel","line","lineWithArea","pie","pyramid","scatter","stock"],value:"bar"},valueFormats:{type:"object",properties:{close:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},group:{type:"object",properties:{tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string|Array<string>"}}},high:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},label:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"}}},low:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},open:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},q1:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},q2:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},q3:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},series:{type:"object",properties:{tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},targetValue:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},value:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},volume:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},x:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},y:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},y2:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}},z:{type:"object",properties:{converter:{type:"object"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},tooltipDisplay:{type:"string",enumValues:["auto","off"],value:"auto"},tooltipLabel:{type:"string"}}}}},xAxis:{type:"object",properties:{axisLine:{type:"object",properties:{lineColor:{type:"string"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["off","on"],value:"on"}}},baselineScaling:{type:"string",enumValues:["min","zero"],value:"zero"},dataMax:{type:"number"},dataMin:{type:"number"},majorTick:{type:"object",properties:{baselineColor:{type:"string",enumValues:["auto","inherit"],value:"auto"},baselineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},baselineWidth:{type:"number"},lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},max:{type:"number|string"},maxSize:{type:"string"},min:{type:"number|string"},minStep:{type:"number"},minorStep:{type:"number"},minorTick:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},referenceObjects:{type:"Array<Object>",value:[]},rendered:{type:"string",enumValues:["off","on"],value:"on"},scale:{type:"string",enumValues:["linear","log"],value:"linear"},size:{type:"string"},step:{type:"number"},tickLabel:{type:"object",properties:{converter:{type:"object"},rendered:{type:"string",enumValues:["off","on"],value:"on"},rotation:{type:"string",enumValues:["auto","none"],value:"auto"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}}}},title:{type:"string"},titleStyle:{type:"object",value:{}},viewportEndGroup:{type:"number|string"},viewportMax:{type:"number|string"},viewportMin:{type:"number|string"},viewportStartGroup:{type:"number|string"}}},y2Axis:{type:"object",properties:{alignTickMarks:{type:"string",enumValues:["off","on"],value:"on"},axisLine:{type:"object",properties:{lineColor:{type:"string"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},baselineScaling:{type:"string",enumValues:["min","zero"],value:"zero"},dataMax:{type:"number"},dataMin:{type:"number"},majorTick:{type:"object",properties:{baselineColor:{type:"string",enumValues:["auto","inherit"],value:"auto"},baselineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},baselineWidth:{type:"number"},lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},max:{type:"number"},maxSize:{type:"string"},min:{type:"number"},minStep:{type:"number"},minorStep:{type:"number"},minorTick:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},position:{type:"string",enumValues:["auto","bottom","end","start","top"],value:"auto"},referenceObjects:{type:"Array<Object>",value:[]},rendered:{type:"string",enumValues:["off","on"],value:"on"},scale:{type:"string",enumValues:["linear","log"],value:"linear"},size:{type:"string"},step:{type:"number"},tickLabel:{type:"object",properties:{converter:{type:"object"},position:{type:"string",enumValues:["inside","outside"],value:"outside"},rendered:{type:"string",enumValues:["off","on"],value:"on"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}}}},title:{type:"string"},titleStyle:{type:"object",value:{}}}},yAxis:{type:"object",properties:{axisLine:{type:"object",properties:{lineColor:{type:"string"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},baselineScaling:{type:"string",enumValues:["min","zero"],value:"zero"},dataMax:{type:"number"},dataMin:{type:"number"},majorTick:{type:"object",properties:{baselineColor:{type:"string",enumValues:["auto","inherit"],value:"auto"},baselineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},baselineWidth:{type:"number"},lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},max:{type:"number"},maxSize:{type:"string"},min:{type:"number"},minStep:{type:"number"},minorStep:{type:"number"},minorTick:{type:"object",properties:{lineColor:{type:"string"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineWidth:{type:"number"},rendered:{type:"string",enumValues:["auto","off","on"],value:"auto"}}},position:{type:"string",enumValues:["auto","bottom","end","start","top"],value:"auto"},referenceObjects:{type:"Array<Object>",value:[]},rendered:{type:"string",enumValues:["off","on"],value:"on"},scale:{type:"string",enumValues:["linear","log"],value:"linear"},size:{type:"string"},step:{type:"number"},tickLabel:{type:"object",properties:{converter:{type:"object"},position:{type:"string",enumValues:["inside","outside"],value:"outside"},rendered:{type:"string",enumValues:["off","on"],value:"on"},scaling:{type:"string",enumValues:["auto","billion","million","none","quadrillion","thousand","trillion"],value:"auto"},style:{type:"object",value:{}}}},title:{type:"string"},titleStyle:{type:"object",value:{}},viewportMax:{type:"number"},viewportMin:{type:"number"}}},zoomAndScroll:{type:"string",enumValues:["delayed","delayedScrollOnly","live","liveScrollOnly","off"],value:"off"},zoomDirection:{type:"string",enumValues:["auto","x","y"],value:"auto"}},methods:{getGroup:{},getSeries:{},getGroupCount:{},getSeriesCount:{},getDataItem:{},getLegend:{},getPlotArea:{},getXAxis:{},getY2Axis:{},getValuesAt:{},getContextByNode:{},refresh:{},setProperty:{},getProperty:{},setProperties:{},getYAxis:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojSelectInput:{},ojViewportChange:{},ojViewportChangeInput:{},ojDrill:{}},extension:{}},d={properties:{drilling:{type:"string",enumValues:["inherit","off","on"],value:"inherit"},labelStyle:{type:"object"},name:{type:"string"},shortDesc:{type:"string"}},extension:{}
},p={properties:{borderColor:{type:"string"},borderWidth:{type:"number"},boxPlot:{type:"object",properties:{medianSvgClassName:{type:"string"},medianSvgStyle:{type:"object"},q2Color:{type:"string"},q2SvgClassName:{type:"string"},q2SvgStyle:{type:"object"},q3Color:{type:"string"},q3SvgClassName:{type:"string"},q3SvgStyle:{type:"object"},whiskerEndLength:{type:"string"},whiskerEndSvgClassName:{type:"string"},whiskerEndSvgStyle:{type:"object"},whiskerSvgClassName:{type:"string"},whiskerSvgStyle:{type:"object"}}},categories:{type:"Array<string>"},close:{type:"number"},color:{type:"string"},drilling:{type:"string",enumValues:["inherit","off","on"],value:"inherit"},groupId:{type:"Array<(string|number)>"},high:{type:"number"},items:{type:"Array<Object>|Array<number>"},label:{type:"string|Array<string>"},labelPosition:{type:"string|Array<string>",enumValues:["aboveMarker","afterMarker","auto","beforeMarker","belowMarker","center","insideBarEdge","none","outsideBarEdge","outsideSlice"]},labelStyle:{type:"object|Array<Object>"},low:{type:"number"},markerDisplayed:{type:"string",enumValues:["auto","off","on"]},markerShape:{type:"string"},markerSize:{type:"number"},open:{type:"number"},pattern:{type:"string",enumValues:["auto","largeChecker","largeCrosshatch","largeDiagonalLeft","largeDiagonalRight","largeDiamond","largeTriangle","smallChecker","smallCrosshatch","smallDiagonalLeft","smallDiagonalRight","smallDiamond","smallTriangle"],value:"auto"},q1:{type:"number"},q2:{type:"number"},q3:{type:"number"},seriesId:{type:"string|number"},shortDesc:{type:"string"},source:{type:"string"},sourceHover:{type:"string"},sourceHoverSelected:{type:"string"},sourceSelected:{type:"string"},svgClassName:{type:"string"},svgStyle:{type:"object"},targetValue:{type:"number"},value:{type:"number"},volume:{type:"number"},x:{type:"number|string"},y:{type:"number"},z:{type:"number"}},extension:{}},c={properties:{areaColor:{type:"string"},areaSvgClassName:{type:"string"},areaSvgStyle:{type:"object"},assignedToY2:{type:"string",enumValues:["off","on"],value:"off"},borderColor:{type:"string"},borderWidth:{type:"number"},boxPlot:{type:"object",properties:{medianSvgClassName:{type:"string"},medianSvgStyle:{type:"object"},q2Color:{type:"string"},q2SvgClassName:{type:"string"},q2SvgStyle:{type:"object"},q3Color:{type:"string"},q3SvgClassName:{type:"string"},q3SvgStyle:{type:"object"},whiskerEndLength:{type:"string"},whiskerEndSvgClassName:{type:"string"},whiskerEndSvgStyle:{type:"object"},whiskerSvgClassName:{type:"string"},whiskerSvgStyle:{type:"object"}}},categories:{type:"Array<string>"},color:{type:"string"},displayInLegend:{type:"string",enumValues:["auto","off","on"],value:"auto"},drilling:{type:"string",enumValues:["inherit","off","on"],value:"inherit"},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineType:{type:"string",enumValues:["auto","centeredSegmented","centeredStepped","curved","none","segmented","stepped","straight"],value:"auto"},lineWidth:{type:"number"},markerColor:{type:"string"},markerDisplayed:{type:"string",enumValues:["auto","off","on"],value:"auto"},markerShape:{type:"string",value:"auto"},markerSize:{type:"number"},markerSvgClassName:{type:"string"},markerSvgStyle:{type:"object"},name:{type:"string"},pattern:{type:"string",enumValues:["auto","largeChecker","largeCrosshatch","largeDiagonalLeft","largeDiagonalRight","largeDiamond","largeTriangle","smallChecker","smallCrosshatch","smallDiagonalLeft","smallDiagonalRight","smallDiamond","smallTriangle"],value:"auto"},pieSliceExplode:{type:"number",value:0},shortDesc:{type:"string"},source:{type:"string"},sourceHover:{type:"string"},sourceHoverSelected:{type:"string"},sourceSelected:{type:"string"},stackCategory:{type:"string"},svgClassName:{type:"string"},svgStyle:{type:"object"},type:{type:"string",enumValues:["area","auto","bar","boxPlot","candlestick","line","lineWithArea"],value:"auto"}},extension:{}},_={properties:{animationDuration:{type:"number"},animationOnDataChange:{type:"string",enumValues:["auto","none"],value:"none"},animationOnDisplay:{type:"string",enumValues:["auto","none"],value:"none"},areaColor:{type:"string",value:""},areaSvgClassName:{type:"string",value:""},areaSvgStyle:{type:"object",value:{}},as:{type:"string",value:""},barGapRatio:{type:"number",value:.25},baselineScaling:{type:"string",enumValues:["min","zero"],value:"min"},color:{type:"string"},data:{type:"object"},firstColor:{type:"string",value:""},highColor:{type:"string",value:""},items:{type:"Array<Object>|Array<number>|Promise"},lastColor:{type:"string",value:""},lineStyle:{type:"string",enumValues:["dashed","dotted","solid"],value:"solid"},lineType:{type:"string",enumValues:["centeredSegmented","centeredStepped","curved","none","segmented","stepped","straight"],value:"straight"},lineWidth:{type:"number",value:1},lowColor:{type:"string",value:""},markerShape:{type:"string",value:"auto"},markerSize:{type:"number",value:5},referenceObjects:{type:"Array<Object>",value:[]},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}},tooltip:{type:"object",properties:{renderer:{type:"function"}}},trackResize:{type:"string",enumValues:["off","on"],value:"on"},translations:{type:"object",value:{},properties:{componentName:{type:"string"},labelAndValue:{type:"string"},labelClearSelection:{type:"string"},labelCountWithTotal:{type:"string"},labelDataVisualization:{type:"string"},labelInvalidData:{type:"string"},labelNoData:{type:"string"},stateCollapsed:{type:"string"},stateDrillable:{type:"string"},stateExpanded:{type:"string"},stateHidden:{type:"string"},stateIsolated:{type:"string"},stateMaximized:{type:"string"},stateMinimized:{type:"string"},stateSelected:{type:"string"},stateUnselected:{type:"string"},stateVisible:{type:"string"}}},type:{type:"string",enumValues:["area","bar","line","lineWithArea"],value:"line"},visualEffects:{type:"string",enumValues:["auto","none"],value:"auto"}},methods:{getDataItem:{},refresh:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}},f={properties:{borderColor:{type:"string",value:""},color:{type:"string",value:""},date:{type:"string",value:""},high:{type:"number"},low:{type:"number"},markerDisplayed:{type:"string",enumValues:["off","on"],value:"off"},markerShape:{type:"string"},markerSize:{type:"number"},svgClassName:{type:"string",value:""},svgStyle:{type:"object",value:{}},value:{type:"number"}},extension:{}};e.ChartDataProviderHandler=function(e,t,i,r){this._component=e,this._templateEngine=t,this._items=i,this._dataProperty=r,this.Init()},e.Object.createSubclass(e.ChartDataProviderHandler,e.Object,"oj.ChartDataProviderHandler"),e.ChartDataProviderHandler.prototype.Init=function(){this._parentElement=this._component.element[0],this._templateHandler=this._component._TemplateHandler,this._templates=this._templateHandler.getTemplates(),this._seriesTemplate=this._templates.seriesTemplate?this._templates.seriesTemplate[0]:null,this._groupTemplate=this._templates.groupTemplate?this._templates.groupTemplate[0]:null,this._seriesComparator=this._component.options.seriesComparator,this._groupComparator=this._component.options.groupComparator,this._itemMap=new Map,this._seriesContexts=new Map,this._groupContexts=new Map;var e=0,t=0;this._chartDataItems=[];for(var i=0;i<this._items.length;i++){var r=this._items[i];if(!this._itemMap.has(r.seriesId)||!this._itemMap.get(r.seriesId).has(r.groupId)){this._chartDataItems.push(r);var n={data:r._itemData,key:r.id,index:i},a=r.seriesId;if(!this._seriesContexts.has(a)){var o;o={componentElement:this._parentElement,id:a,items:[],index:e},this._seriesContexts.set(a,o),e+=1}this._seriesContexts.get(a).items.push(n);var s=r.groupId,l=t;this._groupContexts.has(s.slice(0,s.length-1))||(t+=1),this._addToGroupContexts(n,s,1,l),this._itemMap.has(r.seriesId)||this._itemMap.set(r.seriesId,new h),this._itemMap.get(r.seriesId).set(r.groupId,r)}}this._chartDataItems.length>0&&(this._groups=this._createGroups(),this._groupComparator&&this._sortGroups(this._groups),this._series=this._createSeries(this._groups),this._seriesComparator&&this._sortSeries(this._series))},e.ChartDataProviderHandler.prototype.getSeries=function(){return this._series||[]},e.ChartDataProviderHandler.prototype.getGroups=function(){return this._groups||[]},e.ChartDataProviderHandler.prototype._addToGroupContexts=function(e,t,i,r){var n=i-1;if(n<t.length){var a=t[n],o=this._groupContexts.get(a);o?o.items.push(e):this._groupContexts.set(a,{ids:t,componentElement:this._parentElement,items:[e],depth:i,leaf:i===t.length,index:r});var s=o?o.items.length-1:0;this._addToGroupContexts(e,t,i+1,s)}},e.ChartDataProviderHandler.prototype._createSeries=function(e){var t=[],i=!1;return this._seriesContexts.forEach(function(e,r){try{var n;i||((n=this._seriesTemplate?this._templateHandler.processNodeTemplate(this._dataProperty,this._templateEngine,this._seriesTemplate,"oj-chart-series",e,r):{}).id=r,n.name=n.name||r+"",t.push(n))}catch(e){l.error(e),t=[],i=!0}},this),this._addItemsToSeries(t,e),t},e.ChartDataProviderHandler.prototype._addItemsToSeries=function(e,t){var i,r=function(e){if(!e.groups)return[e.id];for(var t=[],i=0;i<e.groups.length;i++)for(var n=r(e.groups[i]),a=0;a<n.length;a++){var o=[e.id];Array.isArray(n[a])?o=o.concat(n[a]):o.push(n[a]),t.push(o)}return t},n=[];for(i=0;i<t.length;i++){var a=t[i],o=r(a);n=n.concat(o)}for(i=0;i<e.length;i++){for(var s=e[i],l=[],h=0;h<n.length;h++){var u=Array.isArray(n[h])?n[h]:[n[h]],g=this._itemMap.get(s.id).get(u)||null;g&&(delete g.groupId,delete g.seriesId),l.push(g)}e[i].items=l}},e.ChartDataProviderHandler.prototype._createGroups=function(){var e,t={},i=!1;this._groupContexts.forEach(function(e,r){try{var n;i||((n=this._groupTemplate?this._templateHandler.processNodeTemplate(this._dataProperty,this._templateEngine,this._groupTemplate,"oj-chart-group",e,r):{}).id=r,n.name=n.name||r+"",t[r]=n)}catch(e){l.error(e),t={},i=!0}},this);var r=[];if(!i)for(e=0;e<this._chartDataItems.length;e++){var n=this._chartDataItems[e];r=this._addGroupItem(n,n.groupId,r,t)}return r},e.ChartDataProviderHandler.prototype._addGroupItem=function(e,t,i,r){i||(i=[]);for(var n,a=t[0],o=null,s=0;s<i.length;s++)i[s].id===a&&(o=s);return null!=o?n=i[o]:(n=r[a],i.push(n)),t.length>1&&(n.groups=this._addGroupItem(e,t.slice(1),n.groups,r)),i},e.ChartDataProviderHandler.prototype._sortSeries=function(e){var t,i;e.sort((t=this._seriesContexts,i=this._seriesComparator,function(e,r){return i(t.get(e.id),t.get(r.id))}));for(var r=0;r<e.length;r++){var n=e[r].id;this._seriesContexts.get(n).index=r}},e.ChartDataProviderHandler.prototype._sortGroups=function(e){var t,i;e.sort((t=this._groupContexts,i=this._groupComparator,function(e,r){var n=e.id,a=r.id,o=t.get(n),s=t.get(a);return i(o,s)}));for(var r=0;r<e.length;r++){var n=e[r].id;this._groupContexts.get(n).index=r,e[r].groups&&this._sortGroups(e[r].groups)}},e.__registerWidget("oj.ojChart",t.oj.dvtBaseComponent,{widgetEventPrefix:"oj",options:{data:null,series:null,groups:null,selectInput:null,tooltip:{renderer:null},viewportChange:null,viewportChangeInput:null,drill:null},_ComponentCreate:function(){this._super(),this._SetLocaleHelpers(u)},_CreateDvtComponent:function(e,t,i){return a.Chart.newInstance(e,t,i)},_ConvertLocatorToSubId:function(e){var t=e.subId;return"oj-chart-item"===t?t="dataItem["+e.seriesIndex+"]["+e.itemIndex+"]":"oj-chart-group"===t?t="group"+this._GetStringFromIndexPath(e.indexPath):"oj-chart-series"===t?t="series["+e.index+"]":"oj-chart-axis-title"===t?t=e.axis+":title":"oj-chart-reference-object"===t?t=e.axis+":referenceObject["+e.index+"]":"oj-legend-item"===t?(t="legend:section"+this._GetStringFromIndexPath(e.sectionIndexPath),t+=":item["+e.itemIndex+"]"):"oj-chart-tooltip"===t?t="tooltip":"oj-chart-pie-center-label"===t&&(t="pieCenterLabel"),t},_ProcessTemplates:function(t,i,r,n,a,o,s){var l=o?this._TemplateHandler.getComponentResults(t):null;if(!l){var h=this._super(t,i,r,n,a,o,s),u=new e.ChartDataProviderHandler(this,r,h.values[0],t);l={paths:["series","groups"],values:[u.getSeries(),u.getGroups()]},o&&this._TemplateHandler.setComponentResults(t,l)}return l},_GetSimpleDataProviderConfigs:function(){return{data:{templateName:"itemTemplate",templateElementName:"oj-chart-item",resultPath:"_item"}}},_ProcessOptions:function(){this._super();var e=this.options.pieCenter;e&&e._renderer&&(e.renderer=this._GetTemplateRenderer(e._renderer,"center"));var t=this.options.selection;this._IsCustomElement()&&t&&"object"==typeof t[0]&&!this.options.data&&(this.options.selection=null)},_ConvertSubIdToLocator:function(e){var t={};if(0===e.indexOf("dataItem")){var i=this._GetIndexPath(e);t.subId="oj-chart-item",t.seriesIndex=i[0],t.itemIndex=i[1]}else if(0===e.indexOf("group"))t.subId="oj-chart-group",t.indexPath=this._GetIndexPath(e);else if(0===e.indexOf("series"))t.subId="oj-chart-series",t.index=this._GetFirstIndex(e);else if(e.indexOf("Axis:title")>0)t.subId="oj-chart-axis-title",t.axis=e.substring(0,e.indexOf(":"));else if(e.indexOf("Axis:referenceObject")>0)t.subId="oj-chart-reference-object",t.axis=e.substring(0,e.indexOf(":")),t.index=this._GetFirstIndex(e);else if(0===e.indexOf("legend")){if(e.indexOf(":item")>0){var r=e.indexOf(":item"),n=e.substring(0,r),a=e.substring(r);t.subId="oj-legend-item",t.sectionIndexPath=this._GetIndexPath(n),t.itemIndex=this._GetFirstIndex(a)}}else"tooltip"===e?t.subId="oj-chart-tooltip":"pieCenterLabel"===e&&(t.subId="oj-chart-pie-center-label");return t},_ProcessStyles:function(){if(this._super(),this.options.styleDefaults||(this.options.styleDefaults={}),!this.options.styleDefaults.colors){var e=new o.ColorAttributeGroupHandler;this.options.styleDefaults.colors=e.getValueRamp()}},_GetComponentRendererOptions:function(){return[{path:"tooltip/renderer",slot:"tooltipTemplate"},{path:"pieCenter/renderer",slot:"pieCenterTemplate"}]},_GetComponentStyleClasses:function(){var e=this._super();return e.push("oj-chart"),e},_GetChildStyleClasses:function(){var e=this._super();return e["oj-chart-data-label"]={path:"styleDefaults/dataLabelStyle",property:"TEXT"},e["oj-chart-data-cursor-line"]={path:"styleDefaults/dataCursor/lineColor",property:"color"},e["oj-chart-stack-label"]={path:"styleDefaults/stackLabelStyle",property:"TEXT"},e["oj-chart-pie-center-label"]={path:"pieCenter/labelStyle",property:"TEXT"},e["oj-chart-slice-label"]={path:"styleDefaults/sliceLabelStyle",property:"TEXT"},e["oj-chart-stock-falling"]={path:"styleDefaults/stockFallingColor",property:"background-color"},e["oj-chart-stock-range"]={path:"styleDefaults/stockRangeColor",property:"background-color"},e["oj-chart-stock-rising"]={path:"styleDefaults/stockRisingColor",property:"background-color"},e["oj-chart-tooltip-label"]={path:"styleDefaults/tooltipLabelStyle",property:"TEXT"},e["oj-chart-xaxis-tick-label"]={path:"xAxis/tickLabel/style",property:"TEXT"},e["oj-chart-xaxis-title"]={path:"xAxis/titleStyle",property:"TEXT"},e["oj-chart-yaxis-tick-label"]={path:"yAxis/tickLabel/style",property:"TEXT"},e["oj-chart-yaxis-title"]={path:"yAxis/titleStyle",property:"TEXT"},e["oj-chart-y2axis-tick-label"]={path:"y2Axis/tickLabel/style",property:"TEXT"},e["oj-chart-y2axis-title"]={path:"y2Axis/titleStyle",property:"TEXT"},e["oj-legend"]={path:"legend/textStyle",property:"TEXT"},e["oj-legend-title"]={path:"legend/titleStyle",property:"TEXT"},e},_GetEventTypes:function(){return["drill","optionChange","selectInput","viewportChange","viewportChangeInput"]},_HandleEvent:function(e){var t=e.type;if("selection"===t){var i=e.selection;if(i){for(var r=[],n=[],a=0;a<i.length;a++){var o;o=this._IsCustomElement()?i[a].id:{id:i[a].id,series:i[a].series,group:i[a].group};var s={data:i[a].data,seriesData:i[a].seriesData,groupData:i[a].groupData,itemData:i[a].itemData};r.push(o),n.push(s)}var l={endGroup:e.endGroup,startGroup:e.startGroup,xMax:e.xMax,xMin:e.xMin,yMax:e.yMax,yMin:e.yMin,y2Max:e.y2Max,y2Min:e.y2Min,selectionData:n};this._IsCustomElement()||(l.component=e.component),e.complete?this._UserOptionChange("selection",r,l):(l.items=r,this._trigger("selectInput",null,l))}}else if("viewportChange"===t){var h={endGroup:e.endGroup,startGroup:e.startGroup,xMax:e.xMax,xMin:e.xMin,yMax:e.yMax,yMin:e.yMin};e.complete&&(this.options.xAxis||(this.options.xAxis={}),this.options.yAxis||(this.options.yAxis={}),this.options.xAxis.viewportStartGroup=null,this.options.xAxis.viewportEndGroup=null,null!=e.xMin&&null!=e.xMax&&(this.options.xAxis.viewportMin=e.xMin,this.options.xAxis.viewportMax=e.xMax),null!=e.yMin&&null!=e.yMax&&(this.options.yAxis.viewportMin=e.yMin,this.options.yAxis.viewportMax=e.yMax)),this._trigger(e.complete?"viewportChange":"viewportChangeInput",null,h)}else"drill"===t?this._trigger("drill",null,{id:e.id,series:e.series,group:e.group,data:e.data,seriesData:e.seriesData,groupData:e.groupData,itemData:e.itemData,component:e.component}):this._super(e)},_LoadResources:function(){null==this.options._resources&&(this.options._resources={});var e=this.options._resources;e.overviewGrippy=i.getResourceUrl("resources/internal-deps/dvt/chart/drag_horizontal.png"),e.panCursorDown=i.getResourceUrl("resources/internal-deps/dvt/chart/hand-closed.cur"),e.panCursorUp=i.getResourceUrl("resources/internal-deps/dvt/chart/hand-open.cur"),e.panUp="oj-chart-pan-icon",e.panUpHover="oj-chart-pan-icon oj-hover",e.panDown="oj-chart-pan-icon oj-active",e.panDownHover="oj-chart-pan-icon oj-hover oj-active",e.selectUp="oj-chart-select-icon",e.selectUpHover="oj-chart-select-icon oj-hover",e.selectDown="oj-chart-select-icon oj-active",e.selectDownHover="oj-chart-select-icon oj-hover oj-active",e.zoomUp="oj-chart-zoom-icon",e.zoomUpHover="oj-chart-zoom-icon oj-hover",e.zoomDown="oj-chart-zoom-icon oj-active",e.zoomDownHover="oj-chart-zoom-icon oj-hover oj-active"},getTitle:function(){return this._component.getAutomation().getTitle()},getGroup:function(e){return this._component.getAutomation().getGroup(e)},getSeries:function(e){return this._component.getAutomation().getSeries(e)},getGroupCount:function(){return this._component.getAutomation().getGroupCount()},getSeriesCount:function(){return this._component.getAutomation().getSeriesCount()},getDataItem:function(e,t){return this._component.getAutomation().getDataItem(e,t)},getLegend:function(){return this._component.getAutomation().getLegend()},getPlotArea:function(){return this._component.getAutomation().getPlotArea()},getXAxis:function(){return this._component.getAutomation().getXAxis()},getYAxis:function(){return this._component.getAutomation().getYAxis()},getY2Axis:function(){return this._component.getAutomation().getY2Axis()},getValuesAt:function(e,t){return this._component.getValuesAt(e,t)},getContextByNode:function(e){var t=this.getSubIdByNode(e);return t&&"oj-chart-tooltip"!==t.subId?t:null},_GetComponentDeferredDataPaths:function(){return{root:["groups","series","data"]}},_CompareOptionValues:function(t,i,r){return"dataCursorPosition"===t?e.Object.compareValues(i,r):this._super(t,i,r)}}),e.__registerWidget("oj.ojSparkChart",t.oj.dvtBaseComponent,{widgetEventPrefix:"oj",options:{as:"",data:null,items:null,referenceObjects:[],tooltip:{renderer:null},type:"line",color:"#267DB3",areaColor:"",areaSvgClassName:"",areaSvgStyle:{},svgClassName:"",svgStyle:{},firstColor:"",lastColor:"",highColor:"",lowColor:"",animationDuration:void 0,animationOnDataChange:"none",animationOnDisplay:"none",visualEffects:"auto",baselineScaling:"min",lineWidth:1,lineStyle:"solid",lineType:"straight",markerShape:"auto",markerSize:5,barGapRatio:.25},_CreateDvtComponent:function(e,t,i){return this._focusable({element:this.element,applyHighlight:!0}),a.SparkChart.newInstance(e,t,i)},_GetComponentStyleClasses:function(){var e=this._super();return e.push("oj-sparkchart"),e},_GetChildStyleClasses:function(){var e=this._super();return e["oj-dvtbase oj-sparkchart"]={path:"animationDuration",property:"ANIM_DUR"},e},_Render:function(){this.element.attr("title")?(this.options.shortDesc=this.element.attr("title"),this.element.data(this.element,"title",this.element.attr("title")),this.element.removeAttr("title")):this.element.data("title")&&(this.options.shortDesc=this.element.data("title")),this._super()},getDataItem:function(e){var t=this._component.getAutomation().getDataItem(e);return this._AddAutomationGetters(t),t&&(t.getFloatValue=t.getLow),t},_GetComponentDeferredDataPaths:function(){return{root:["items","data"]}},_GetSimpleDataProviderConfigs:function(){return{data:{templateName:"itemTemplate",templateElementName:"oj-spark-chart-item",resultPath:"items"}}},_AddAutomationGetters:function(e){if(e){for(var t={},i=Object.keys(e),r=0;r<i.length;r++)this._addGetter(e,i[r],t);Object.defineProperties(e,t)}},_addGetter:function(e,t,i){i[("selected"===t?"is":"get")+t.charAt(0).toUpperCase()+t.slice(1)]={value:function(){return e[t]}}}}),function(){g.extension._WIDGET_NAME="ojChart";var t=n.shapeParseFunction({"style-defaults.marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0});e.CustomElementBridge.register("oj-chart",{metadata:g,parseFunction:function(e,i,r,n){return"number|string"===r.type?isNaN(e)?e:Number(e):"style-defaults.data-label-style"===i?JSON.parse(e):t(e,i,r,n)}})}(),function(){p.extension._CONSTRUCTOR=function(){},e.CustomElementBridge.register("oj-chart-item",{metadata:p,parseFunction:n.shapeParseFunction({"marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0})})}(),function(){c.extension._CONSTRUCTOR=function(){},e.CustomElementBridge.register("oj-chart-series",{metadata:c,parseFunction:n.shapeParseFunction({"marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0})})}(),d.extension._CONSTRUCTOR=function(){},e.CustomElementBridge.register("oj-chart-group",{metadata:d}),function(){_.extension._WIDGET_NAME="ojSparkChart",e.CustomElementBridge.register("oj-spark-chart",{metadata:_,parseFunction:n.shapeParseFunction({"marker-shape":!0},{square:!0,circle:!0,diamond:!0,plus:!0,triangleDown:!0,triangleUp:!0,human:!0,star:!0,auto:!0})})}(),f.extension._CONSTRUCTOR=function(){},e.CustomElementBridge.register("oj-spark-chart-item",{metadata:f})}),define("ojtranslations/nls/timezoneData",{root:{supplemental:{version:{_number:"Revision: 12447",cldrVersion:"32"},metazones:{Africa:{Algiers:[{usesMetazone:{_to:"1979-10-25 23:00",_mzone:"Europe_Central",_from:"1977-10-20 23:00"}},{usesMetazone:{_to:"1981-05-01 00:00",_mzone:"Europe_Western",_from:"1979-10-25 23:00"}},{usesMetazone:{_mzone:"Europe_Central",_from:"1981-05-01 00:00"}},{usesMetazone:{_to:"1977-10-20 23:00",_mzone:"Europe_Western"}}],Cairo:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Casablanca:[{usesMetazone:{_to:"1985-12-31 23:00",_mzone:"Europe_Central",_from:"1984-03-16 00:00"}},{usesMetazone:{_mzone:"Europe_Western",_from:"1985-12-31 23:00"}},{usesMetazone:{_to:"1984-03-16 00:00",_mzone:"Europe_Western"}}],Harare:[{usesMetazone:{_mzone:"Africa_Central"}}],Lagos:[{usesMetazone:{_mzone:"Africa_Western"}}],Nairobi:[{usesMetazone:{_mzone:"Africa_Eastern"}}],Djibouti:[{usesMetazone:{_mzone:"Africa_Eastern"}}],Johannesburg:[{usesMetazone:{_mzone:"Africa_Southern"}}],Khartoum:[{usesMetazone:{_mzone:"Africa_Eastern",_from:"2000-01-15 10:00"}},{usesMetazone:{_to:"2000-01-15 10:00",_mzone:"Africa_Central"}}],Mogadishu:[{usesMetazone:{_mzone:"Africa_Eastern"}}],Nouakchott:[{usesMetazone:{_mzone:"GMT"}}],Tripoli:[{usesMetazone:{_to:"1990-05-03 23:00",_mzone:"Europe_Central",_from:"1981-12-31 22:00"}},{usesMetazone:{_to:"1996-09-29 22:00",_mzone:"Europe_Eastern",_from:"1990-05-03 23:00"}},{usesMetazone:{_to:"1997-10-03 22:00",_mzone:"Europe_Central",_from:"1996-09-29 22:00"}},{usesMetazone:{_to:"2012-11-10 00:00",_mzone:"Europe_Eastern",_from:"1997-10-03 22:00"}},{usesMetazone:{_mzone:"Europe_Central",_from:"2012-11-10 00:00"}},{usesMetazone:{_to:"1981-12-31 22:00",_mzone:"Europe_Eastern"}}],Tunis:[{usesMetazone:{_mzone:"Europe_Central"}}]},America:{Anchorage:[{usesMetazone:{_to:"1983-11-30 09:00",_mzone:"Yukon",_from:"1983-10-30 11:00"}},{usesMetazone:{_mzone:"Alaska",_from:"1983-11-30 09:00"}},{usesMetazone:{_to:"1983-10-30 11:00",_mzone:"Alaska_Hawaii"}}],Buenos_Aires:[{usesMetazone:{_mzone:"Argentina"}}],Bogota:[{usesMetazone:{_mzone:"Colombia"}}],Caracas:[{usesMetazone:{_mzone:"Venezuela"}}],Chicago:[{usesMetazone:{_mzone:"America_Central"}}],Chihuahua:[{usesMetazone:{_mzone:"America_Mountain",_from:"1998-04-05 09:00"}},{usesMetazone:{_to:"1998-04-05 09:00",_mzone:"America_Central"}}],Costa_Rica:[{usesMetazone:{_mzone:"America_Central"}}],Denver:[{usesMetazone:{_mzone:"America_Mountain"}}],Edmonton:[{usesMetazone:{_mzone:"America_Mountain"}}],El_Salvador:[{usesMetazone:{_mzone:"America_Central"}}],Godthab:[{usesMetazone:{_mzone:"Greenland_Western"}}],Guatemala:[{usesMetazone:{_mzone:"America_Central"}}],Guayaquil:[{usesMetazone:{_mzone:"Ecuador"}}],Halifax:[{usesMetazone:{_mzone:"Atlantic"}}],Indianapolis:[{usesMetazone:{_mzone:"America_Eastern"}}],Lima:[{usesMetazone:{_mzone:"Peru"}}],Los_Angeles:[{usesMetazone:{_mzone:"America_Pacific"}}],Managua:[{usesMetazone:{_to:"1975-02-16 05:00",_mzone:"America_Eastern",_from:"1973-05-01 06:00"}},{usesMetazone:{_to:"1992-01-01 10:00",_mzone:"America_Central",_from:"1975-02-16 05:00"}},{usesMetazone:{_to:"1992-09-24 05:00",_mzone:"America_Eastern",_from:"1992-01-01 10:00"}},{usesMetazone:{_to:"1993-01-01 06:00",_mzone:"America_Central",_from:"1992-09-24 05:00"}},{usesMetazone:{_to:"1997-01-01 05:00",_mzone:"America_Eastern",_from:"1993-01-01 06:00"}},{usesMetazone:{_mzone:"America_Central",_from:"1997-01-01 05:00"}},{usesMetazone:{_to:"1973-05-01 06:00",_mzone:"America_Central"}}],Mazatlan:[{usesMetazone:{_mzone:"America_Mountain",_from:"1970-01-01 08:00"}},{usesMetazone:{_to:"1970-01-01 08:00",_mzone:"America_Pacific"}}],Mexico_City:[{usesMetazone:{_mzone:"America_Central"}}],Toronto:[{usesMetazone:{_mzone:"America_Eastern"}}],New_York:[{usesMetazone:{_mzone:"America_Eastern"}}],Noronha:[{usesMetazone:{_mzone:"Noronha"}}],Panama:[{usesMetazone:{_mzone:"America_Eastern"}}],Phoenix:[{usesMetazone:{_mzone:"America_Mountain"}}],Puerto_Rico:[{usesMetazone:{_mzone:"Atlantic"}}],Regina:[{usesMetazone:{_mzone:"America_Central"}}],Santiago:[{usesMetazone:{_mzone:"Chile"}}],Sao_Paulo:[{usesMetazone:{_mzone:"Brasilia"}}],St_Johns:[{usesMetazone:{_mzone:"Newfoundland"}}],Tijuana:[{usesMetazone:{_mzone:"America_Pacific"}}],Vancouver:[{usesMetazone:{_mzone:"America_Pacific"}}],Winnipeg:[{usesMetazone:{_mzone:"America_Central"}}]},Asia:{Aden:[{usesMetazone:{_mzone:"Arabian"}}],Almaty:[{usesMetazone:{_mzone:"Kazakhstan_Eastern",_from:"2005-03-14 18:00"}},{usesMetazone:{_to:"2005-03-14 18:00",_mzone:"Almaty"}}],Amman:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Baghdad:[{usesMetazone:{_mzone:"Arabian"}}],Bahrain:[{usesMetazone:{_mzone:"Arabian",_from:"1972-05-31 20:00"}},{usesMetazone:{_to:"1972-05-31 20:00",_mzone:"Gulf"}}],Baku:[{usesMetazone:{_mzone:"Azerbaijan",_from:"1991-08-29 20:00"}},{usesMetazone:{_to:"1991-08-29 20:00",_mzone:"Baku"}}],Bangkok:[{usesMetazone:{_mzone:"Indochina"}}],Beirut:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Colombo:[{usesMetazone:{_to:"2006-04-14 18:30",_mzone:"Lanka",_from:"1996-05-24 18:30"}},{usesMetazone:{_mzone:"India",_from:"2006-04-14 18:30"}},{usesMetazone:{_to:"1996-05-24 18:30",_mzone:"India"}}],Damascus:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Dhaka:[{usesMetazone:{_mzone:"Bangladesh",_from:"1971-03-25 18:00"}},{usesMetazone:{_to:"1971-03-25 18:00",_mzone:"Dacca"}}],Dubai:[{usesMetazone:{_mzone:"Gulf"}}],Saigon:[{usesMetazone:{_mzone:"Indochina"}}],Hong_Kong:[{usesMetazone:{_mzone:"Hong_Kong"}}],Irkutsk:[{usesMetazone:{_mzone:"Irkutsk"}}],Jakarta:[{usesMetazone:{_mzone:"Indonesia_Western"}}],Jerusalem:[{usesMetazone:{_mzone:"Israel"}}],Kabul:[{usesMetazone:{_mzone:"Afghanistan"}}],Kamchatka:[{usesMetazone:{_mzone:"Magadan",_from:"2010-03-27 14:00"}},{usesMetazone:{_to:"2010-03-27 14:00",_mzone:"Kamchatka"}}],Karachi:[{usesMetazone:{_mzone:"Pakistan",_from:"1971-03-25 19:00"}},{usesMetazone:{_to:"1971-03-25 19:00",_mzone:"Karachi"}}],Calcutta:[{usesMetazone:{_mzone:"India"}}],Krasnoyarsk:[{usesMetazone:{_mzone:"Krasnoyarsk"}}],Kuala_Lumpur:[{usesMetazone:{_mzone:"Malaysia",_from:"1981-12-31 16:30"}},{usesMetazone:{_to:"1981-12-31 16:30",_mzone:"Malaya"}}],Kuwait:[{usesMetazone:{_mzone:"Arabian"}}],Magadan:[{usesMetazone:{_mzone:"Magadan"}}],Manila:[{usesMetazone:{_mzone:"Philippines"}}],Muscat:[{usesMetazone:{_mzone:"Gulf"}}],Nicosia:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Novosibirsk:[{usesMetazone:{_mzone:"Novosibirsk"}}],Qatar:[{usesMetazone:{_mzone:"Arabian",_from:"1972-05-31 20:00"}},{usesMetazone:{_to:"1972-05-31 20:00",_mzone:"Gulf"}}],Rangoon:[{usesMetazone:{_mzone:"Myanmar"}}],Riyadh:[{usesMetazone:{_mzone:"Arabian"}}],Seoul:[{usesMetazone:{_mzone:"Korea"}}],Shanghai:[{usesMetazone:{_mzone:"China"}}],Singapore:[{usesMetazone:{_mzone:"Singapore"}}],Taipei:[{usesMetazone:{_mzone:"Taipei"}}],Tashkent:[{usesMetazone:{_mzone:"Uzbekistan",_from:"1991-08-31 18:00"}},{usesMetazone:{_to:"1991-08-31 18:00",_mzone:"Tashkent"}}],Tehran:[{usesMetazone:{_mzone:"Iran"}}],Tokyo:[{usesMetazone:{_mzone:"Japan"}}],Vladivostok:[{usesMetazone:{_mzone:"Vladivostok"}}],Yakutsk:[{usesMetazone:{_mzone:"Yakutsk"}}],Yekaterinburg:[{usesMetazone:{_mzone:"Yekaterinburg",_from:"1992-01-18 22:00"}},{usesMetazone:{_to:"1992-01-18 22:00",_mzone:"Sverdlovsk"}}]},Atlantic:{Azores:[{usesMetazone:{_to:"1993-03-28 01:00",_mzone:"Europe_Western",_from:"1992-09-27 02:00"}},{usesMetazone:{_mzone:"Azores",_from:"1993-03-28 01:00"}},{usesMetazone:{_to:"1992-09-27 02:00",_mzone:"Azores"}}],Cape_Verde:[{usesMetazone:{_mzone:"Cape_Verde"}}],Reykjavik:[{usesMetazone:{_mzone:"GMT"}}]},Australia:{Adelaide:[{usesMetazone:{_mzone:"Australia_Central"}}],Brisbane:[{usesMetazone:{_mzone:"Australia_Eastern"}}],Darwin:[{usesMetazone:{_mzone:"Australia_Central"}}],Hobart:[{usesMetazone:{_mzone:"Australia_Eastern"}}],Perth:[{usesMetazone:{_mzone:"Australia_Western"}}],Sydney:[{usesMetazone:{_mzone:"Australia_Eastern"}}]},Europe:{Amsterdam:[{usesMetazone:{_mzone:"Europe_Central"}}],Athens:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Belgrade:[{usesMetazone:{_mzone:"Europe_Central"}}],Berlin:[{usesMetazone:{_mzone:"Europe_Central"}}],Brussels:[{usesMetazone:{_mzone:"Europe_Central"}}],Bucharest:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Budapest:[{usesMetazone:{_mzone:"Europe_Central"}}],Copenhagen:[{usesMetazone:{_mzone:"Europe_Central"}}],Dublin:[{usesMetazone:{_mzone:"GMT",_from:"1971-10-31 02:00"}},{usesMetazone:{_to:"1971-10-31 02:00",_mzone:"Irish"}}],Helsinki:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Istanbul:[{usesMetazone:{_to:"1985-04-19 21:00",_mzone:"Turkey",_from:"1978-10-14 21:00"}},{usesMetazone:{_mzone:"Europe_Eastern",_from:"1985-04-19 21:00"}},{usesMetazone:{_to:"1978-10-14 21:00",_mzone:"Europe_Eastern"}}],Kiev:[{usesMetazone:{_mzone:"Europe_Eastern",_from:"1990-06-30 23:00"}},{usesMetazone:{_to:"1990-06-30 23:00",_mzone:"Moscow"}}],Lisbon:[{usesMetazone:{_to:"1992-09-27 01:00",_mzone:"Europe_Western",_from:"1976-09-26 00:00"}},{usesMetazone:{_to:"1996-03-31 01:00",_mzone:"Europe_Central",_from:"1992-09-27 01:00"}},{usesMetazone:{_mzone:"Europe_Western",_from:"1996-03-31 01:00"}},{usesMetazone:{_to:"1976-09-26 00:00",_mzone:"Europe_Central"}}],London:[{usesMetazone:{_mzone:"GMT",_from:"1971-10-31 02:00"}},{usesMetazone:{_to:"1971-10-31 02:00",_mzone:"British"}}],Luxembourg:[{usesMetazone:{_mzone:"Europe_Central"}}],Madrid:[{usesMetazone:{_mzone:"Europe_Central"}}],Moscow:[{usesMetazone:{_to:"1992-01-19 00:00",_mzone:"Europe_Eastern",_from:"1991-03-30 23:00"}},{usesMetazone:{_mzone:"Moscow",_from:"1992-01-19 00:00"}},{usesMetazone:{_to:"1991-03-30 23:00",_mzone:"Moscow"}}],Oslo:[{usesMetazone:{_mzone:"Europe_Central"}}],Paris:[{usesMetazone:{
_mzone:"Europe_Central"}}],Prague:[{usesMetazone:{_mzone:"Europe_Central"}}],Riga:[{usesMetazone:{_mzone:"Europe_Eastern",_from:"1989-03-25 23:00"}},{usesMetazone:{_to:"1989-03-25 23:00",_mzone:"Moscow"}}],Rome:[{usesMetazone:{_mzone:"Europe_Central"}}],Sofia:[{usesMetazone:{_mzone:"Europe_Eastern"}}],Stockholm:[{usesMetazone:{_mzone:"Europe_Central"}}],Tallinn:[{usesMetazone:{_mzone:"Europe_Eastern",_from:"1989-03-25 23:00"}},{usesMetazone:{_to:"1989-03-25 23:00",_mzone:"Moscow"}}],Tirane:[{usesMetazone:{_mzone:"Europe_Central"}}],Vienna:[{usesMetazone:{_mzone:"Europe_Central"}}],Vilnius:[{usesMetazone:{_to:"1998-03-29 01:00",_mzone:"Europe_Eastern",_from:"1991-03-30 23:00"}},{usesMetazone:{_to:"1999-10-31 01:00",_mzone:"Europe_Central",_from:"1998-03-29 01:00"}},{usesMetazone:{_mzone:"Europe_Eastern",_from:"1999-10-31 01:00"}},{usesMetazone:{_to:"1991-03-30 23:00",_mzone:"Moscow"}}],Warsaw:[{usesMetazone:{_mzone:"Europe_Central"}}],Zurich:[{usesMetazone:{_mzone:"Europe_Central"}}]},Pacific:{Auckland:[{usesMetazone:{_mzone:"New_Zealand"}}],Fiji:[{usesMetazone:{_mzone:"Fiji"}}],Guam:[{usesMetazone:{_mzone:"Chamorro",_from:"2000-12-22 14:00"}},{usesMetazone:{_to:"2000-12-22 14:00",_mzone:"Guam"}}],Honolulu:[{usesMetazone:{_mzone:"Hawaii_Aleutian",_from:"1983-10-30 11:00"}},{usesMetazone:{_to:"1983-10-30 11:00",_mzone:"Alaska_Hawaii"}}],Midway:[{usesMetazone:{_mzone:"Samoa",_from:"1983-10-30 12:00"}},{usesMetazone:{_to:"1983-10-30 12:00",_mzone:"Bering"}}],Pago_Pago:[{usesMetazone:{_mzone:"Samoa",_from:"1983-10-30 12:00"}},{usesMetazone:{_to:"1983-10-30 12:00",_mzone:"Bering"}}],Tongatapu:[{usesMetazone:{_mzone:"Tonga"}}]}},timeZoneData:{version:"2019b",zones:{"Africa/Abidjan":"GMT|0|0|","Africa/Addis_Ababa":"EAT|-30|0|","Africa/Algiers":"CET|-10|0|","Africa/Bangui":"WAT|-10|0|","Africa/Blantyre":"CAT|-20|0|","Africa/Cairo":"EET EEST|-20 -30|01010101010101010101010101010|1dNW0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 WL0 1qN0 Rb0 1wp0 On0 1zd0 Lz0 1EN0 Fb0 c10 8n0 8Nd0 gL0 e10 mn0","Africa/Casablanca":"+00 +01|0 -10|0101010101010101010101010101010101010101010101010101010101010101010101010101|1xwo0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 28M0 e00 2600 e00 28M0 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 28M0 e00 2600 e00 28M0 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0","Africa/Ceuta":"CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAN0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","Africa/Johannesburg":"SAST|-20|0|","Africa/Khartoum":"CAT EAT|-20 -30|010|1d8y0 HjL0","Africa/Tripoli":"EET CET CEST|-20 -10 -20|0120|1IlA0 TA0 1o00","Africa/Tunis":"CET CEST|-10 -20|010101010|1q1z0 10N0 1aN0 1qM0 WM0 1qM0 11A0 1o00","America/Anchorage":"AKST AKDT|90 80|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDL0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Anguilla":"AST|40|0|","America/Argentina/Buenos_Aires":"-03 -02|30 20|01010|1wuP0 uL0 1qN0 WL0","America/Atikokan":"EST|50|0|","America/Belem":"-03|30|0|","America/Belize":"CST|60|0|","America/Bogota":"-05|50|0|","America/Boise":"MST MDT|70 60|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDJ0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Caracas":"-04 -0430|40 4u|010|1wmv0 kqo0","America/Chicago":"CST CDT|60 50|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDI0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Chihuahua":"MST MDT|70 60|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDJ0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0","America/Creston":"MST|70|0|","America/Dawson":"PST PDT|80 70|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDK0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Detroit":"EST EDT|50 40|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDH0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Ensenada":"PST PDT|80 70|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDK0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Fort_Wayne":"EST EDT|50 40|01010101010101010101010101010101010101010101010101010101010101010|1sg70 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Glace_Bay":"AST ADT|40 30|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDG0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Godthab":"-03 -02|30 20|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAN0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","America/Guatemala":"CST CDT|60 50|010|1sri0 11z0","America/Guyana":"-04|40|0|","America/Managua":"CST CDT|60 50|01010|1pRi0 19X0 1o30 11y0","America/Merida":"CST CDT|60 50|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDI0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0","America/Noronha":"-01 -02|10 20|010101|1dpB0 1tB0 2L0 2pB0 On0","America/Santiago":"-03 -04|30 40|010101010101010101010101010101010101010101010101010101010101010101010101010|1dvf0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1zb0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0","America/Sao_Paulo":"-02 -03|20 30|0101010101010101010101010101010101010101|1dpC0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1HB0 FX0","America/Scoresbysund":"-01 +00|10 0|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAN0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","America/St_Johns":"NST NDT|3u 2u|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDDv 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","America/Winnipeg":"CST CDT|60 50|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDI0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0","Antarctica/DumontDUrville":"+10|-a0|0|","Antarctica/McMurdo":"NZDT NZST|-d0 -c0|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dxO0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00","Antarctica/Syowa":"+03|-30|0|","Antarctica/Vostok":"+06|-60|0|","Asia/Almaty":"+06 +07|-60 -70|01010101010|1dAI0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0","Asia/Amman":"EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010|1dCm0 1dc0 1co0 1dc0 1cM0 1cM0 1cM0 1o00 11A0 1lc0 17c0 1cM0 1cM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 4bX0 Dd0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0","Asia/Anadyr":"+12 +13 +11|-c0 -d0 -b0|01010101010101010101020|1dAC0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0","Asia/Ashgabat":"+05|-50|0|","Asia/Baghdad":"+03 +04|-30 -40|01010101010101010|1dDc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0","Asia/Baku":"+04 +05|-40 -50|010101010101010101010101010101010|1dAM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00","Asia/Bangkok":"+07|-70|0|","Asia/Beirut":"EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAK0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0","Asia/Brunei":"+08|-80|0|","Asia/Calcutta":"IST|-5u|0|","Asia/Chongqing":"CST|-80|0|","Asia/Colombo":"+06 +0530|-60 -5u|01|1sl6u","Asia/Dacca":"+06 +07|-60 -70|010|1A5R0 1i00","Asia/Damascus":"EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dDa0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 19z0 1fB0 1qL0 11B0 1on0 Wp0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0","Asia/Dubai":"+04|-40|0|","Asia/Hong_Kong":"HKT|-80|0|","Asia/Irkutsk":"+08 +09|-80 -90|0101010101010101010101010|1dAG0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0","Asia/Istanbul":"EET EEST +03|-20 -30 -30|01010101010101010101010101010101012|1dAL0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WO0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 Xc0 1qo0 WM0 1qM0 11A0 1o00 1200 1nA0 11A0 1tA0 U00 15w0","Asia/Jakarta":"WIB|-70|0|","Asia/Jerusalem":"IST IDT|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dIo0 19W0 1e10 17b0 1ep0 1gL0 18N0 1fz0 1eN0 17b0 1gq0 1gn0 19d0 1dz0 1c10 17X0 1hB0 1gn0 19d0 1dz0 1c10 17X0 1kp0 1dz0 1c10 1aL0 1eN0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0","Asia/Kabul":"+0430|-4u|0|","Asia/Karachi":"PKT PKST|-50 -60|0101010|1ixv0 1cL0 dK10 11b0 1610 1jX0","Asia/Kathmandu":"+0545|-5J|0|","Asia/Krasnoyarsk":"+07 +08|-70 -80|0101010101010101010101010|1dAH0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0","Asia/Magadan":"+11 +12 +10|-b0 -c0 -a0|01010101010101010101010120|1dAD0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Cq0","Asia/Manila":"PST|-80|0|","Asia/Nicosia":"EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAN0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","Asia/Novosibirsk":"+06 +07|-60 -70|01010101010101010101010101|1dAI0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 4eN0","Asia/Rangoon":"+0630|-6u|0|","Asia/Seoul":"KST|-90|0|","Asia/Tehran":"+0330 +0430|-3u -4u|0101010101010101010101010101010101010101010101010101010101010101010101010|1dyIu 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 64p0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0","Asia/Tokyo":"JST|-90|0|","Asia/Vladivostok":"+10 +11|-a0 -b0|0101010101010101010101010|1dAE0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0","Asia/Yakutsk":"+09 +10|-90 -a0|0101010101010101010101010|1dAF0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0","Asia/Yekaterinburg":"+05 +06|-50 -60|0101010101010101010101010|1dAJ0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0","Atlantic/Canary":"WET WEST|0 -10|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAN0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","Atlantic/Cape_Verde":"-01|10|0|","Atlantic/South_Georgia":"-02|20|0|","Australia/ACT":"AEDT AEST|-b0 -a0|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAE0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0","Australia/Adelaide":"ACDT ACST|-au -9u|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAEu 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0","Australia/Brisbane":"AEST|-a0|0|","Australia/Currie":"AEDT AEST|-b0 -a0|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAE0 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0","Australia/Darwin":"ACST|-9u|0|","Australia/Perth":"AWST AWDT|-80 -90|0101010|1tRS0 IM0 1qM0 11A0 1o00 11A0",Eire:"GMT IST|0 -10|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAN0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","Etc/GMT+10":"-10|a0|0|","Etc/GMT+11":"-11|b0|0|","Etc/GMT+12":"-12|c0|0|","Etc/GMT+6":"-06|60|0|","Etc/GMT+7":"-07|70|0|","Etc/GMT+8":"-08|80|0|","Etc/GMT+9":"-09|90|0|","Etc/GMT-1":"+01|-10|0|","Etc/GMT-11":"+11|-b0|0|","Etc/GMT-12":"+12|-c0|0|","Etc/GMT-13":"+13|-d0|0|","Etc/GMT-14":"+14|-e0|0|","Etc/GMT-2":"+02|-20|0|","Etc/GMT-9":"+09|-90|0|","Etc/UCT":"UTC|0|0|","Europe/Belfast":"GMT BST|0 -10|01010101010101010101010101010101010101010101010101010101010101010101010101010|1dAN0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","Europe/Moscow":"MSK MSD MSK|-30 -40 -40|0101010101010101010101020|1dAL0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0","Europe/Riga":"EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010|1g2p0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","Europe/Tallinn":"EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010|1iuN0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00","Europe/Vilnius":"EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010|1kUp0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00",HST:"HST|a0|0|","Pacific/Fiji":"+13 +12|-d0 -c0|010101010101010101010101010101010101010101010101010101010101|1dpq0 nJc0 LA0 1o00 Rc0 1wo0 Ao0 1Nc0 Ao0 1Q00 xz0 1SN0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0","Pacific/Guam":"GST ChST|-a0 -a0|01|1fpq0","Pacific/Midway":"SST|b0|0|","Pacific/Tongatapu":"+14 +13|-e0 -d0|01010101|1dxN0 1wo0 xz0 1Q10 xz0 zWN0 s00"},links:{"Africa/Djibouti":"Africa/Addis_Ababa","Africa/Harare":"Africa/Blantyre","Africa/Lagos":"Africa/Bangui","Africa/Maputo":"Africa/Blantyre","Africa/Mogadishu":"Africa/Addis_Ababa","Africa/Nairobi":"Africa/Addis_Ababa","Africa/Nouakchott":"Africa/Abidjan","America/Buenos_Aires":"America/Argentina/Buenos_Aires","America/Costa_Rica":"America/Belize","America/Denver":"America/Boise","America/Edmonton":"America/Boise","America/El_Salvador":"America/Belize","America/Guayaquil":"America/Bogota","America/Halifax":"America/Glace_Bay","America/Indianapolis":"America/Fort_Wayne","America/Lima":"America/Bogota","America/Los_Angeles":"America/Dawson","America/Mazatlan":"America/Chihuahua","America/Mexico_City":"America/Merida","America/Montreal":"America/Detroit","America/New_York":"America/Detroit","America/Panama":"America/Atikokan","America/Phoenix":"America/Creston","America/Puerto_Rico":"America/Anguilla","America/Regina":"America/Belize","America/Tijuana":"America/Ensenada","America/Toronto":"America/Detroit","America/Vancouver":"America/Dawson","Asia/Aden":"Antarctica/Syowa","Asia/Bahrain":"Antarctica/Syowa","Asia/Dhaka":"Asia/Dacca","Asia/Ho_Chi_Minh":"Asia/Bangkok","Asia/Kamchatka":"Asia/Anadyr","Asia/Katmandu":"Asia/Kathmandu","Asia/Kolkata":"Asia/Calcutta","Asia/Kuala_Lumpur":"Asia/Brunei","Asia/Kuwait":"Antarctica/Syowa","Asia/Muscat":"Asia/Dubai","Asia/Qatar":"Antarctica/Syowa","Asia/Riyadh":"Antarctica/Syowa","Asia/Saigon":"Asia/Bangkok","Asia/Shanghai":"Asia/Chongqing","Asia/Singapore":"Asia/Brunei","Asia/Taipei":"Asia/Chongqing","Asia/Tashkent":"Asia/Ashgabat","Atlantic/Azores":"America/Scoresbysund","Atlantic/Reykjavik":"Africa/Abidjan","Australia/Hobart":"Australia/Currie","Australia/Sydney":"Australia/ACT","Etc/GMT+0":"Africa/Abidjan","Etc/GMT+1":"Atlantic/Cape_Verde","Etc/GMT+2":"Atlantic/South_Georgia","Etc/GMT+3":"America/Belem","Etc/GMT+4":"America/Guyana","Etc/GMT+5":"America/Bogota","Etc/GMT-10":"Antarctica/DumontDUrville","Etc/GMT-3":"Antarctica/Syowa","Etc/GMT-4":"Asia/Dubai","Etc/GMT-5":"Asia/Ashgabat","Etc/GMT-6":"Antarctica/Vostok","Etc/GMT-7":"Asia/Bangkok","Etc/GMT-8":"Asia/Brunei","Etc/UTC":"Etc/UCT","Etc/Zulu":"Etc/UCT","Europe/Amsterdam":"Africa/Ceuta","Europe/Athens":"Asia/Nicosia","Europe/Belgrade":"Africa/Ceuta","Europe/Berlin":"Africa/Ceuta","Europe/Brussels":"Africa/Ceuta","Europe/Bucharest":"Asia/Nicosia","Europe/Budapest":"Africa/Ceuta","Europe/Copenhagen":"Africa/Ceuta","Europe/Dublin":"Eire","Europe/Helsinki":"Asia/Nicosia","Europe/Istanbul":"Asia/Istanbul","Europe/Kiev":"Asia/Nicosia","Europe/Lisbon":"Atlantic/Canary","Europe/London":"Europe/Belfast","Europe/Luxembourg":"Africa/Ceuta","Europe/Madrid":"Africa/Ceuta","Europe/Oslo":"Africa/Ceuta","Europe/Paris":"Africa/Ceuta","Europe/Prague":"Africa/Ceuta","Europe/Rome":"Africa/Ceuta","Europe/Sofia":"Asia/Nicosia","Europe/Stockholm":"Africa/Ceuta","Europe/Tirane":"Africa/Ceuta","Europe/Vienna":"Africa/Ceuta","Europe/Warsaw":"Africa/Ceuta","Europe/Zurich":"Africa/Ceuta","Pacific/Auckland":"Antarctica/McMurdo","Pacific/Honolulu":"HST","Pacific/Pago_Pago":"Pacific/Midway",UCT:"Etc/UCT",UTC:"Etc/UCT"}}}},ar:1,"ar-AE":1,"ar-BH":1,"ar-DZ":1,"ar-EG":1,"ar-IQ":1,"ar-JO":1,"ar-KW":1,"ar-LB":1,"ar-LY":1,"ar-MA":1,"ar-OM":1,"ar-QA":1,"ar-SA":1,"ar-SD":1,"ar-SY":1,"ar-TN":1,"ar-YE":1,as:1,be:1,"be-BY":1,bg:1,"bg-BG":1,bn:1,bo:1,"bo-IN":1,brx:1,ca:1,"ca-ES":1,cs:1,"cs-CZ":1,da:1,"da-DK":1,de:1,"de-AT":1,"de-CH":1,"de-DE":1,"de-LU":1,el:1,"el-CY":1,"el-GR":1,en:1,"en-AU":1,"en-CA":1,"en-GB":1,"en-IE":1,"en-IN":1,"en-MT":1,"en-NZ":1,"en-PH":1,"en-SG":1,"en-US":1,"en-ZA":1,es:1,"es-AR":1,"es-BO":1,"es-CL":1,"es-CO":1,"es-CR":1,"es-CU":1,"es-DO":1,"es-EC":1,"es-ES":1,"es-GT":1,"es-HN":1,"es-MX":1,"es-NI":1,"es-PA":1,"es-PE":1,"es-PR":1,"es-PY":1,"es-SV":1,"es-US":1,"es-UY":1,"es-VE":1,et:1,"et-EE":1,fi:1,"fi-FI":1,fr:1,"fr-BE":1,"fr-CA":1,"fr-CH":1,"fr-FR":1,"fr-LU":1,ga:1,"ga-IE":1,gu:1,he:1,"he-IL":1,hi:1,"hi-IN":1,hr:1,"hr-HR":1,hu:1,"hu-HU":1,id:1,"id-ID":1,is:1,"is-IS":1,it:1,"it-CH":1,"it-IT":1,ja:1,"ja-JP":1,kn:1,ko:1,"ko-KR":1,kok:1,ks:1,lt:1,"lt-LT":1,lv:1,"lv-LV":1,mk:1,"mk-MK":1,ml:1,mr:1,ms:1,"ms-MY":1,mt:1,"mt-MT":1,nb:1,"nb-NO":1,ne:1,"ne-IN":1,nl:1,"nl-BE":1,"nl-NL":1,nn:1,"nn-NO":1,no:1,"no-NO":1,or:1,pa:1,pl:1,"pl-PL":1,pt:1,"pt-BR":1,"pt-PT":1,ro:1,"ro-RO":1,ru:1,"ru-RU":1,sk:1,"sk-SK":1,sl:1,"sl-SI":1,sq:1,"sq-AL":1,sr:1,"sr-Cyrl":1,"sr-Cyrl-BA":1,"sr-Cyrl-ME":1,"sr-Cyrl-RS":1,"sr-Latn":1,"sr-Latn-BA":1,"sr-Latn-ME":1,"sr-Latn-RS":1,sv:1,"sv-SE":1,ta:1,te:1,th:1,"th-TH":1,tr:1,"tr-TR":1,uk:1,"uk-UA":1,ur:1,"ur-IN":1,vi:1,"vi-VN":1,zh:1,"zh-Hans":1,"zh-Hans-CN":1,"zh-Hans-SG":1,"zh-Hant":1,"zh-Hant-HK":1,"zh-Hant-MO":1,"zh-Hant-TW":1,__noOverlay:!0,__defaultNoOverlayLocale:"en-US"}),define("ojs/ojtimezonedata",["ojs/ojcore","ojL10n!ojtranslations/nls/timezoneData","ojs/ojlocaledata","ojs/ojvalidation-base"],function(e,t,i){"use strict";e.TimezoneData={},e.TimezoneData.__mergeIntoLocaleElements=function(t){var r=i.__getBundle();e.CollectionUtils.copyInto(r,t,void 0,!0)},e.TimezoneData.__getBundleNames=function(){return e.TimezoneData._bundleNames},e.TimezoneData.__registerBundleName=function(t){e.TimezoneData._bundleNames.push(t)},e.TimezoneData._bundleNames=[],e.TimezoneData.__registerBundleName("/timezoneData"),e.TimezoneData.__mergeIntoLocaleElements(void 0===t?{}:t)}),function(e,t,i,r,n,a,o,s){"use strict";apex.widget.jetChart={init:function(l,h,u,g,d,p,c,_){require(["ojs/ojcore","jquery","ojs/ojchart","ojs/ojgauge","ojs/ojgantt","ojs/ojvalidation","ojs/ojtimezonedata"],function(d){function f(){if(e("#"+i.escapeCSS(l)).hasClass("is-maximized"))S.css("max-width","100%").css("height",e(window).height()/100*80);else{var t="100%",r=null;h&&(t=h+"px"),u?r=u+"px":"gantt"===C.type&&(r="100%"),S.css("width","100%").css("max-width",t),r?S.css("height",r):S.css("height",""),"dial"!==C.type&&S.css("min-width","100px")}}function m(){t.plugin(_,{pageItems:C.pageItems},{dataType:"json",refreshObject:S,loadingIndicator:S,loadingIndicatorPosition:"centered",success:v})}function v(t){function i(e){for(o in e)if(e.hasOwnProperty(o)&&e[o].items.length>0)for(h in e[o].items)if(e[o].items[h].labelDisplay)return e[o].items[h].labelDisplay}function n(e,t,i){function r(e,t,i){var r;for(r=0;r<e.length;r++)if("pie"===C.type||"funnel"===C.type||"pyramid"===C.type){if(e[r].name===t)return e[r].link}else if("stock"===C.type){var n=new Date(e[r].name),a=n.getTime();if(a===i||n===i)return e[r].link}else{if(e[r].name===i)return e[r].link;var o=new Date(e[r].name),s=o.getTime();if(s===i||o===i)return e[r].link}}var n;for(n in e)if(e.hasOwnProperty(n))if(e[n].id){if((e[n].id===t||e[n].name===t)&&e[n].items.length>0)return r(e[n].items,t,i)}else if(e[n].name&&e[n].name===t&&e[n].items.length>0)return r(e[n].items,t,i)}var o,l,h,u=["pie","funnel","pyramid","scatter","bubble","gantt","stock"],g=0,_="dial"===C.type?"dial":"chart",v="gantt"===C.type?"gantt":_;if(e.isFunction(C.dataFilter)&&(t=C.dataFilter(t)),"dial"===_)C.title&&S.closest("div").attr("title",C.title.replace(/#VALUE#/g,t.value).replace(/#MAX#/g,t.max));else if(-1===e.inArray(C.type,u)&&t.series.length>1&&"mixedFrequency"!==C.timeAxisType&&"skipGaps"!==C.timeAxisType&&C.sorting){s.chartSortArray(t.groups,C.sorting);for(var y=0;y<t.series.length;y++){s.chartFillGaps(t.groups,t.series[y].items,C.sorting,p);for(var A=0;A<t.series[y].items.length;A++)t.series[y].items[A].id=""+g,g++}}v={chart:"ojChart",dial:"ojStatusMeterGauge",gantt:"ojGantt"}[v],S[v](t),s.onVisibilityChange(S[0],function(e){e?(d.Components.subtreeShown(S[0]),f(),S[v]("refresh")):d.Components.subtreeHidden(S[0])}),e(window).on("apexwindowresized",function(){f()}),"ojChart"===v&&("pie"===C.type?S[v]({drill:function(e,t){(l=t.data.link)&&(r.log("Chart link: "+l),a.redirect(l))},dataLabel:function(r){var n,a,o,s,l,h;switch(n=Math.round(r.value/r.totalValue*100)+"%",o=r.value,s=i(t.series),C.valueFormats&&C.valueFormats.value&&C.valueFormats.value.converter&&(h=C.valueFormats.value.converter,o=h.format(r.value)),-1!==e.inArray(s,["LABEL","ALL","LBL_VAL"])&&(a=r.seriesData?r.seriesData.name:"Other"),s){case"VALUE":l=o;break;case"PERCENT":l=n;break;case"LABEL":l=a;break;case"LBL_VAL":l=a+" - "+o;break;case"ALL":l=a+" - "+n+" ( "+o+" )";break;case"COMBO":l=n+" ( "+o+" )"}return l}}):S[v]({drill:function(i,o){-1===e.inArray(C.type,u)?o.group&&o.series&&(l=n(t.series,o.series,o.group)):l=o.data.link,l&&(r.log("Chart link: "+l),a.redirect(l))}})),"ojStatusMeterGauge"===v&&S[v]({tooltip:{renderer:function(e){var i;return t.tooltipRendered&&(i=t.customTooltip?t.customTooltip:e.label),i}}}),"ojGantt"===v&&t.tooltip&&S[v]({tooltip:{renderer:function(e){return e.data.customTooltip}}}),c>0&&setTimeout(function(){m()},1e3*c)}var y,S=e("#"+i.escapeCSS(l)+"_jet",apex.gPageContext$),C=g||{};y="dial"===C.type?"ojStatusMeterGauge":"gantt"===C.type?"ojGantt":"ojChart",o.jetChart.formatData(C,!1),S[y](C),n.create(l,{type:"JetChart",widgetName:y,refresh:function(){f(),m()},focus:function(){S.focus()},widget:function(){return S}}),n(l).refresh()})},initReportChart:function(r,n,a,l,h){require(["ojs/ojcore","jquery","ojs/ojchart","ojs/ojvalidation"],function(u){function g(){f.css("width","100%"),f.css("max-width","100%"),f.css("height","500px"),f.css("min-width","100px")}function d(){var e={p_widget_name:"worksheet",
p_widget_mod:"GET_CHART_JSON",x01:n,x02:a};t.plugin(l,e,{dataType:"json",type:"GET",success:function(e){o.jetChart.formatData(e,!0),f[c](e),f[c]({dataLabel:function(t){var i,r,n;return r=t.value,e.valueFormats&&e.valueFormats.value&&e.valueFormats.value.converter&&(n=e.valueFormats.value.converter,r=n.format(r)),i=t.seriesData?t.seriesData.name:"Other","pie"===t.seriesData.type?i+" - "+r:null}})}})}function p(){t.widget("wsChart",{x01:h},{dataType:"json",success:function(e){o.jetChart.formatData(e,!0),f[c](e),f[c]({dataLabel:function(t){var i,r,n;return r=t.value,e.valueFormats&&e.valueFormats.value&&e.valueFormats.value.converter&&(n=e.valueFormats.value.converter,r=n.format(r)),i=t.seriesData?t.seriesData.name:"Other","pie"===t.seriesData.type?i+" - "+r:null}})}})}var c,_,f=e("#"+i.escapeCSS(r),apex.gPageContext$);_={legend:{rendered:"off"},animationOnDisplay:"auto",animationOnDataChange:"auto",hoverBehavior:"dim",groups:[],series:[],valueFormats:[]},c="ojChart",f[c](_),function(){g(),h?p():d()}(),s.onVisibilityChange(f[0],function(e){e?(u.Components.subtreeShown(f[0]),g(),f[c]("refresh")):u.Components.subtreeHidden(f[0])})})},formatData:function(t,i){var r,n,a,o,s=t,l=new oj.ColorAttributeGroupHandler;if(i)if("bar"!==s.type){for(o=s.series,n=0;n<o.length;n++)o[n].color=l.getValue(o[n].name);s.series=o}else{for(o=s.series[0].items,n=0;n<o.length;n++)o[n].color=l.getValue(o[n].name);s.series[0].items=o}if("gantt"!==s.type)"dial"===s.type?s.metricLabel&&e.each(s.metricLabel,function(e){"converter"===e&&(s.metricLabel[e]=oj.Validation.converterFactory("number").createConverter(s.metricLabel[e]))}):(s.valueFormats&&e.each(s.valueFormats,function(t){e.each(s.valueFormats[t],function(e,i){"converter"===e&&(r=i.formatType?"datetime":"number",s.valueFormats[t][e]=oj.Validation.converterFactory(r).createConverter(s.valueFormats[t][e]))})}),s.xAxis&&s.xAxis.tickLabel&&e.each(s.xAxis.tickLabel,function(e,t){"converter"===e&&(r=t.formatType?"datetime":"number",s.xAxis.tickLabel[e]=oj.Validation.converterFactory(r).createConverter(s.xAxis.tickLabel[e]))}),s.yAxis&&s.yAxis.tickLabel&&e.each(s.yAxis.tickLabel,function(e,t){"converter"===e&&(r=t.formatType?"datetime":"number",s.yAxis.tickLabel[e]=oj.Validation.converterFactory(r).createConverter(s.yAxis.tickLabel[e]))}),s.y2Axis&&s.y2Axis.tickLabel&&e.each(s.y2Axis.tickLabel,function(e,t){"converter"===e&&(r=t.formatType?"datetime":"number",s.y2Axis.tickLabel[e]=oj.Validation.converterFactory(r).createConverter(s.y2Axis.tickLabel[e]))}));else{if(s.majorAxis&&s.majorAxis.converter)for(a in s.majorAxis.converter)r="datetime",s.majorAxis.converter[a]=oj.Validation.converterFactory(r).createConverter(s.majorAxis.converter[a]);if(s.minorAxis&&s.minorAxis.converter)for(a in s.minorAxis.converter)r="datetime",s.minorAxis.converter[a]=oj.Validation.converterFactory(r).createConverter(s.minorAxis.converter[a])}return s}}}(apex.jQuery,apex.server,apex.util,apex.debug,apex.region,apex.navigation,apex.widget,apex.widget.util),define("jetChart",function(){}),define("chartBundle.min",function(){});