/**
 * @license
 * Copyright (c) 2014, 2019, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */

/*!
 Input Search - APEX widget for autocomplete style text fields, based on Oracle JET Input Search form control
 Copyright (c) 2017, 2018, Oracle and/or its affiliates. All rights reserved.
 */

define("ojs/ojanimation",["ojs/ojcore","jquery","ojs/ojthemeutils","ojs/ojlogger","promise","ojs/ojcomponentcore"],function(e,t,i,s){"use strict";return e.AnimationUtils={},e.AnimationUtils,e.AnimationUtils._getName=function(t,i){if(!e.AnimationUtils._nameMap){e.AnimationUtils._nameMap={};var s=e.AnimationUtils._nameMap,n=t.style;s.backfaceVisibility=void 0!==n.webkitBackfaceVisibility?"webkitBackfaceVisibility":"backfaceVisibility",s.transform=void 0!==n.webkitTransform?"webkitTransform":"transform",s.transformOrigin=void 0!==n.webkitTransformOrigin?"webkitTransformOrigin":"transformOrigin",s.transition=void 0!==n.webkitTransition?"webkitTransition":"transition",s.transitionend=void 0!==n.webkitTransition?"webkitTransitionEnd":"transitionend"}return e.AnimationUtils._nameMap[i]||i},e.AnimationUtils._getElementStyle=function(t,i){return t.style[e.AnimationUtils._getName(t,i)]},e.AnimationUtils._setElementStyle=function(t,i,s){t.style[e.AnimationUtils._getName(t,i)]=s},e.AnimationUtils._animate=function(i,s,n,o,r,a){var l=[].concat(r),u=function(t,u){function c(){_||(d&&(window.cancelAnimationFrame(d),d=0),i.removeEventListener(e.AnimationUtils._getName(i,"transitionend"),h),t&&t(!0),_=!0)}function p(){d=0,e.AnimationUtils._applyState(i,n,f>1)}var h=function(t){var i=0===t.propertyName.indexOf("-webkit-")?t.propertyName.substr(8):t.propertyName;i=e.AnimationUtils._getCamelCasePropName(i);var s=l.indexOf(i);s>-1&&(l.length>1?l.splice(s,1):c())},d=0,_=!1;null==n&&(n={}),null==n.css&&(n.css={}),n.css.transition=e.AnimationUtils._createTransitionValue(i,r,o);var f=e.AnimationUtils._saveStyle(i,s,n,o,a||r);e.AnimationUtils._applyState(i,s,f>1),i.addEventListener(e.AnimationUtils._getName(i,"transitionend"),h);var g=o.duration,v=o.delay,m=o._skipPromise;null==s?p():(o._noReflow||(e.AnimationUtils._x=i.offsetWidth),d=window.requestAnimationFrame(p));var y=e.AnimationUtils._getTotalTiming(g,v);m||setTimeout(c,y+100)};return o._skipPromise?(u(null),null):new Promise(u).then(function(){s&&s.addClass&&t(i).removeClass(s.addClass),n&&n.addClass&&t(i).removeClass(n.addClass),e.AnimationUtils._restoreStyle(i)})},e.AnimationUtils._saveCssValues=function(t,i,s,n){for(var o=Object.keys(i),r=Object.prototype.hasOwnProperty,a=0;a<o.length;a++){var l=o[a];r.call(s,l)||n&&-1!==n.indexOf(l)||(s[l]=e.AnimationUtils._getElementStyle(t,l))}},e.AnimationUtils._saveStyle=function(t,i,s,n,o){var r=t._ojSavedStyle||{},a=i&&i.css?i.css:{},l=s&&s.css?s.css:{},u=o;n&&"all"===n.persist||(u=null),e.AnimationUtils._saveCssValues(t,a,r,u),e.AnimationUtils._saveCssValues(t,l,r,u),t._ojSavedStyle=r;var c=t._ojEffectCount||0;return c+=1,t._ojEffectCount=c,c},e.AnimationUtils._restoreStyle=function(t){var i=t,s=i._ojEffectCount;if(s>1)i._ojEffectCount=s-1;else{var n=i._ojSavedStyle;if(n){for(var o=Object.keys(n),r=0;r<o.length;r++){var a=o[r];e.AnimationUtils._setElementStyle(i,a,n[a])}delete i._ojSavedStyle,delete i._ojEffectCount}}},e.AnimationUtils._getCamelCasePropName=function(e){if(e.indexOf("-")>=0){for(var t="",i=e.split("-"),s=0;s<i.length;s++){var n=i[s];n&&(t?t+=n.charAt(0).toUpperCase()+n.slice(1):t=n)}return t}return e},e.AnimationUtils._getHyphenatedPropName=function(e){var t=e.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();return 0===t.indexOf("webkit")&&(t="-"+t),t},e.AnimationUtils._concatMultiValue=function(t,i,s,n,o){if(i.css[s]){var r=e.AnimationUtils._getElementStyle(t,s);r&&0!==r.indexOf(n)&&(i.css[s]=r+o+i.css[s])}},e.AnimationUtils._splitTransform=function(e){var t=[];if(e&&"none"!==e)for(var i=e,s=i.indexOf(")");s>0;){var n=i.substr(0,s+1);t.push(n.trim()),s=(i=i.slice(s+1)).indexOf(")")}return t},e.AnimationUtils._getTransformFuncName=function(e){var t=e.indexOf("(");return t>=1?e.substr(0,t):e},e.AnimationUtils._applyTransform=function(t,i){for(var s=e.AnimationUtils._getElementStyle(t,"transform"),n=e.AnimationUtils._splitTransform(s),o=e.AnimationUtils._splitTransform(i),r=[],a=0;a<o.length;a++){var l=e.AnimationUtils._getTransformFuncName(o[a]),u=!1;if(l)for(var c=0;c<n.length;c++)0===n[c].indexOf(l+"(")&&(n[c]=o[a],u=!0);u||r.push(o[a])}return(n=n.concat(r)).join(" ")},e.AnimationUtils._applyState=function(i,s,n){if(s){if(s.css){n&&e.AnimationUtils._concatMultiValue(i,s,"transition","all",", "),s.css.transform&&(s.css.transform=e.AnimationUtils._applyTransform(i,s.css.transform));for(var o=s.css,r=Object.keys(o),a=0;a<r.length;a++){var l=r[a];e.AnimationUtils._setElementStyle(i,l,o[l])}}s.addClass&&t(i).addClass(s.addClass),s.removeClass&&t(i).removeClass(s.removeClass)}},e.AnimationUtils._getTimingValue=function(e){var t=parseFloat(e);return isNaN(t)?0:e.indexOf("ms")>-1?t:1e3*t},e.AnimationUtils._getTotalTiming=function(t,i){var s=e.AnimationUtils._getTimingValue(t);return s>0?s+(i?e.AnimationUtils._getTimingValue(i):0):0},e.AnimationUtils._calcCssTime=function(t,i,s){for(var n=t.split(","),o=i.split(","),r=s.split(","),a=n.length,l=o.length,u=r.length,c=0,p=0;p<a;p++){var h=r[p%u],d=o[p%l],_=e.AnimationUtils._getTotalTiming(h,d);c=Math.max(c,_)}return c},e.AnimationUtils._calcEffectTime=function(t){var i,s,n,o=window.getComputedStyle(t);i=o.animationName||o.webkitAnimationName,s=o.animationDelay||o.webkitAnimationDelay,n=o.animationDuration||o.webkitAnimationDuration;var r=e.AnimationUtils._calcCssTime(i,s,n);i=o.transitionProperty||o.webkitTransitionProperty,s=o.transitionDelay||o.webkitTransitionDelay,n=o.transitionDuration||o.webkitTransitionDuration;var a=e.AnimationUtils._calcCssTime(i,s,n);return Math.max(r,a)},e.AnimationUtils._fillEmptyOptions=function(e,t){e.delay=e.delay||t.delay,e.duration=e.duration||t.duration,e.timingFunction=e.timingFunction||t.timingFunction,e.persist=e.persist||t.persist},e.AnimationUtils._triggerEvent=function(e,t,i,s){var n;if(s&&s._trigger)n=!s._trigger(t,null,i);else{var o="oj"+t.substr(0,1).toUpperCase()+t.substr(1),r=new CustomEvent(o,{detail:i,bubbles:!0,cancelable:!0}),a=s||e;a.dispatchEvent&&a.dispatchEvent(r),n=r.defaultPrevented}return n},e.AnimationUtils.startAnimation=function(i,s,n,o){return i=t(i)[0],new Promise(function(r,a){var l=t(i),u="oj-animate-"+s,c=u+"-active",p=!1,h=!1,d=function(){if(p&&h){l.removeClass(u),l.removeClass(c),e.AnimationUtils._restoreStyle(i),r(!0);var t={action:s,element:i};e.AnimationUtils._triggerEvent(i,"animateEnd",t,o)}},_=function(){p=!0,d()},f=function(){h=!0,d()};e.AnimationUtils._saveStyle(i,null,null,null,null);var g={action:s,element:i,endCallback:_};if(!e.AnimationUtils._triggerEvent(i,"animateStart",g,o)){for(var v=[].concat(n),m=[],y={},b=0;b<v.length;b++){var E,S=v[b],O="";null!=S&&"none"!==S&&("string"==typeof S?(O=S,E={}):"object"==typeof S&&(O=S.effect,E=t.extend({},S)),e.AnimationUtils._fillEmptyOptions(E,y),y=t.extend({},E)),O&&e.AnimationUtils[O]&&m.push(e.AnimationUtils[O](i,E))}m.length?Promise.all(m).then(_):_()}l.addClass(u);var C=window.requestAnimationFrame(function(){C=0,l.addClass(c);var t=e.AnimationUtils._calcEffectTime(i);t>0?setTimeout(f,t+100):f()});setTimeout(function(){C&&(window.cancelAnimationFrame(C),C=0,f())},1e3)})},e.AnimationUtils._mergeOptions=function(s,n){return null==e.AnimationUtils._defaultOptions&&(e.AnimationUtils._defaultOptions=i.parseJSONFromFontFamily("oj-animation-effect-default-options")),t.extend({duration:"400ms"},e.AnimationUtils._defaultOptions?e.AnimationUtils._defaultOptions[s]:null,n)},e.AnimationUtils._createTransitionValue=function(t,i,s){var n="";if(i)for(var o=0;o<i.length;o++){var r=e.AnimationUtils._getName(t,i[o]);n+=(o>0?", ":"")+e.AnimationUtils._getHyphenatedPropName(r)+" "+s.duration,s.timingFunction&&(n+=" "+s.timingFunction),s.delay&&(n+=" "+s.delay)}return n},e.AnimationUtils._fade=function(t,i,s,n,o){var r=e.AnimationUtils._mergeOptions(s,i),a={css:{opacity:n}},l={css:{opacity:o}};return r&&(r.startOpacity&&(a.css.opacity=r.startOpacity),r.endOpacity&&(l.css.opacity=r.endOpacity)),e.AnimationUtils._animate(t,a,l,r,["opacity"])},e.AnimationUtils.fadeIn=function(t,i){return e.AnimationUtils._fade(t,i,"fadeIn",0,1)},e.AnimationUtils.fadeOut=function(t,i){return e.AnimationUtils._fade(t,i,"fadeOut",1,0)},e.AnimationUtils.expand=function(t,i){return e.AnimationUtils._expandCollapse(t,i,!0)},e.AnimationUtils.collapse=function(t,i){return e.AnimationUtils._expandCollapse(t,i,!1)},e.AnimationUtils._wrapRowContent=function(e,t){var i,s,n=[],o=e.children,r=[],a=[];for(e._ojSavedHeight=e.style.height,s=0;s<o.length;s++){i=o[s];var l=window.getComputedStyle(i);r.push(l.padding),a.push(l.textAlign),i._ojSavedPadding=i.style.padding}for(s=0;s<o.length;s++){i=o[s];var u=document.createElement("div");u.style.overflow="hidden;";var c=document.createElement("div");for(c.style.display="table-cell",c.style.verticalAlign="middle",c.style.boxSizing="border-box",c.style.height=t,c.style.padding=r[s],c.style.textAlign=a[s],u.appendChild(c);i.firstChild;)c.appendChild(i.firstChild);i.appendChild(u),i.style.padding="0",n.push(u)}return e.style.height="0",n},e.AnimationUtils._unwrapRowContent=function(e){for(var t=e.children,i=0;i<t.length;i++){var s=t[i],n=s.children[0];if(n){var o=n.children[0];if(o)for(;o.firstChild;)s.appendChild(o.firstChild);s.removeChild(n)}s.style.padding=s._ojSavedPadding,delete s._ojSavedPadding}e.style.height=e._ojSavedHeight,delete e._ojSavedHeight},e.AnimationUtils._expandCollapseRow=function(i,s,n){var o,r=i.offsetHeight+"px",a=e.AnimationUtils._wrapRowContent(i,r),l=t.extend({},s);if(n?l.endMaxHeight||(l.endMaxHeight=r):l.startMaxHeight||(l.startMaxHeight=r),l.persist="all",l._noReflow=!0,a.length)for(var u=0;u<a.length;u++)0===u?(l._skipPromise=!1,o=e.AnimationUtils._expandCollapse(a[u],l,n)):(l._skipPromise=!0,e.AnimationUtils._expandCollapse(a[u],l,n));else o=Promise.resolve();return o.then(function(){null!=s&&"all"===s.persist||e.AnimationUtils._unwrapRowContent(i)})},e.AnimationUtils._getSizeLimit=function(e,t,i,s,n){var o=i;if(!o)if(s)o="0";else{var r=n?t.maxWidth:t.maxHeight;o="none"!==r?r:(n?e.offsetWidth:e.offsetHeight)+"px"}return o},e.AnimationUtils._expandCollapse=function(t,i,s){if(t&&"TR"===t.tagName)return e.AnimationUtils._expandCollapseRow(t,i,s);var n=e.AnimationUtils._mergeOptions(s?"expand":"collapse",i),o={css:{}},r={css:{}},a=n.direction||"height",l=o.css,u=r.css,c=window.getComputedStyle(t),p=[];if("both"===a||"height"===a){var h=e.AnimationUtils._getSizeLimit(t,c,n.startMaxHeight,s,!1),d=e.AnimationUtils._getSizeLimit(t,c,n.endMaxHeight,!s,!1);l.maxHeight=h,u.maxHeight=d,p.push("maxHeight")}if("both"===a||"width"===a){var _=e.AnimationUtils._getSizeLimit(t,c,n.startMaxWidth,s,!0),f=e.AnimationUtils._getSizeLimit(t,c,n.endMaxWidth,!s,!0);l.maxWidth=_,u.maxWidth=f,p.push("maxWidth")}l.overflow=n.overflow?n.overflow:"hidden";var g=[].concat(p);return g.push("overflow"),e.AnimationUtils._animate(t,o,r,n,p,g)},e.AnimationUtils.zoomIn=function(t,i){return e.AnimationUtils._zoom(t,i,!0)},e.AnimationUtils.zoomOut=function(t,i){return e.AnimationUtils._zoom(t,i,!1)},e.AnimationUtils._zoom=function(t,i,s){var n,o=e.AnimationUtils._mergeOptions(s?"zoomIn":"zoomOut",i),r={css:{}},a={css:{}},l=o.axis||"both";n="both"===l?"scale":"x"===l?"scaleX":"scaleY";var u=r.css,c=a.css;return u.transform=n+"("+(s?0:1)+") translateZ(0)",c.transform=n+"("+(s?1:0)+") translateZ(0)",u.transformOrigin=o.transformOrigin||"center",e.AnimationUtils._animate(t,r,a,o,["transform"])},e.AnimationUtils.slideIn=function(t,i){return e.AnimationUtils._slide(t,i,!0)},e.AnimationUtils.slideOut=function(t,i){return e.AnimationUtils._slide(t,i,!1)},e.AnimationUtils._slide=function(t,i,s){var n=e.AnimationUtils._mergeOptions(s?"slideIn":"slideOut",i),o={css:{}},r={css:{}},a=n.direction||"start",l="0",u="0",c=o.css,p=r.css;if(n.offsetX||n.offsetY)n.offsetX&&(l=n.offsetX),n.offsetY&&(u=n.offsetY);else{var h="rtl"===e.DomUtils.getReadingDirection();switch(a){case"left":l=(s?t.offsetWidth:-t.offsetWidth)+"px";break;case"right":l=(s?-t.offsetWidth:t.offsetWidth)+"px";break;case"top":u=(s?t.offsetHeight:-t.offsetHeight)+"px";break;case"bottom":u=(s?-t.offsetHeight:t.offsetHeight)+"px";break;case"end":l=(s?-t.offsetWidth:t.offsetWidth)*(h?-1:1)+"px";break;default:l=(s?t.offsetWidth:-t.offsetWidth)*(h?-1:1)+"px"}}return s?(c.transform="translate("+l+","+u+") translateZ(0)",p.transform="translate(0,0) translateZ(0)"):(c.transform="translate(0,0) translateZ(0)",p.transform="translate("+l+","+u+") translateZ(0)"),e.AnimationUtils._animate(t,o,r,n,["transform"])},e.AnimationUtils.ripple=function(i,s){var n=e.AnimationUtils._mergeOptions("ripple",s),o={css:{}},r={css:{}},a=i.offsetWidth,l=i.offsetHeight,u=t("<div>").css({position:"absolute",overflow:"hidden"}),c=t("<div class='oj-animation-effect-ripple oj-animation-rippler'>"),p="static"===window.getComputedStyle(i).position?{left:i.offsetLeft,top:i.offsetTop}:{left:0,top:0};i.insertBefore(u[0],i.firstChild),u.css({left:p.left+"px",top:p.top+"px",width:a+"px",height:l+"px"}),u.prepend(c);var h=o.css,d=r.css;return e.AnimationUtils._setRippleOptions(h,c,u,n),h.transform="scale(0) translateZ(0)",h.opacity=n.startOpacity||c.css("opacity"),d.transform="scale(1) translateZ(0)",d.opacity=n.endOpacity||0,n.persist="all",e.AnimationUtils._animate(c[0],o,r,n,["transform","opacity"]).then(function(){u.remove()})},e.AnimationUtils._setRippleOptions=function(t,i,s,n){var o=t,r=i.width(),a=s.width(),l=s.height();if(n.diameter){var u=n.diameter,c=parseInt(u,10);isNaN(c)||(r="%"===u.charAt(u.length-1)?Math.floor(Math.min(a,l)*(c/100)):c,o.width=r+"px",o.height=r+"px")}var p,h="static"===s.css("position")?s.position():{left:0,top:0};null!=(p=e.AnimationUtils._calcRippleOffset(n.offsetX,r,a,h.left))&&(o.left=p+"px"),null!=(p=e.AnimationUtils._calcRippleOffset(n.offsetY,r,l,h.top))&&(o.top=p+"px"),n.color&&(o.backgroundColor=n.color)},e.AnimationUtils._calcRippleOffset=function(e,t,i,s){var n,o=e||"50%",r=parseInt(o,10);return isNaN(r)||(n="%"===o.charAt(o.length-1)?i*(r/100)-t/2:r-t/2,n=Math.floor(n+s)),n},e.AnimationUtils._removeRipple=function(i,n){var o=n||{},r=o.removeEffect||"fadeOut",a=t(".oj-animation-rippler",i);if(0!==a.length)return r in{fadeOut:1,collapse:1,zoomOut:1,slideOut:1}?e.AnimationUtils[r](a,o).then(function(){a.remove()}):a.remove();s.warn("No rippler so returning")},e.AnimationUtils._calcBackfaceAngle=function(e){var t,i=e.match(/^([+-]?\d*\.?\d*)(.*)$/),n=parseFloat(i[1]),o=i[2];switch(o){case"deg":t=n-180+o;break;case"grad":t=n-200+o;break;case"rad":t=n-3.1416+o;break;case"turn":t=n-.5+o;break;default:s.error("Unknown angle unit in flip animation: "+o)}return t},e.AnimationUtils._flip=function(i,s,n,o,r){if(s&&"children"===s.flipTarget){var a,l=[],u=t(i).children(),c=t.extend({},s);delete c.flipTarget;var p=t.extend({},c);p.startAngle=e.AnimationUtils._calcBackfaceAngle(s.startAngle||o),p.endAngle=e.AnimationUtils._calcBackfaceAngle(s.endAngle||r);for(var h=0;h<u.length;h++)a=t(u[h]).hasClass("oj-animation-backface")?p:c,l.push(e.AnimationUtils._flip(u[h],a,n,o,r));return Promise.all(l)}var d,_={},f={},g={css:_},v={css:f},m="rotateY(",y="2000px",b="hidden",E="center";return(s=e.AnimationUtils._mergeOptions(n,s))&&("x"===s.axis&&(m="rotateX("),s.startAngle&&(o=s.startAngle),s.endAngle&&(r=s.endAngle),s.perspective&&(y=s.perspective),s.backfaceVisibility&&(b=s.backfaceVisibility),s.transformOrigin&&(E=s.transformOrigin)),d="perspective("+y+") "+m,_.transform=d+o+")",_.backfaceVisibility=b,_.transformOrigin=E,f.transform=d+r+")",e.AnimationUtils._animate(i,g,v,s,["transform"],["transform","backfaceVisibility","transformOrigin"])},e.AnimationUtils.flipIn=function(t,i){return e.AnimationUtils._flip(t,i,"flipIn","-180deg","0deg")},e.AnimationUtils.flipOut=function(t,i){return e.AnimationUtils._flip(t,i,"flipOut","0deg","180deg")},e.AnimationUtils.addTransition=function(t,i){var s=e.AnimationUtils._mergeOptions("addTransition",i);return e.AnimationUtils._animate(t,null,null,s,s.transitionProperties)},e.AnimationUtils}),define("ojs/ojjquery-hammer",["ojs/ojcore","jquery","hammerjs","ojs/ojlogger"],function(e,t,i,s){"use strict";var n;i?(t.fn.ojHammer=function(e){switch(e){case"instance":return this.data("ojHammer");case"destroy":return this.each(function(){var e=t(this),i=e.data("ojHammer");i&&(i.destroy(),e.removeData("ojHammer"))});default:return this.each(function(){var s=t(this);s.data("ojHammer")||s.data("ojHammer",new i.Manager(s[0],e))})}},i.Manager.prototype.emit=(n=i.Manager.prototype.emit,function(e,i){n.call(this,e,i),t(this.element).trigger({type:e,gesture:i})})):s.warn("Hammer jQuery extension loaded without Hammer.")}),define("ojs/ojpopupcore",["ojs/ojcore","jquery","ojs/ojcontext","ojs/ojcomponentcore","ojs/ojlogger","promise","jqueryui-amd/position"],function(e,t,i,s,n){"use strict";e.PopupService=function(){this.Init()},e.Object.createSubclass(e.PopupService,e.Object,"oj.PopupService"),e.PopupService.prototype.Init=function(){e.PopupService.superclass.Init.call(this)},e.PopupService.getInstance=function(t){return e.PopupService._popupService||(e.PopupService._popupService=new e.PopupServiceImpl),e.PopupService._popupService},e.PopupService.prototype.open=function(t){e.Assert.failedInAbstractFunction()},e.PopupService.prototype.close=function(t){e.Assert.failedInAbstractFunction()},e.PopupService.prototype.changeOptions=function(t){e.Assert.failedInAbstractFunction()},e.PopupService.prototype.triggerOnDescendents=function(t,i,s){e.Assert.failedInAbstractFunction()},e.PopupService.prototype.destroy=function(){e.PopupService._popupService=null},e.PopupService.MODALITY={NONE:"none",MODAL:"modal",MODELESS:"modeless"},e.PopupService.EVENT={POPUP_REMOVE:"ojPopupRemove",POPUP_CLOSE:"ojPopupClose",POPUP_REFRESH:"ojPopupRefresh",POPUP_AUTODISMISS:"ojPopupAutoDismiss",POPUP_BEFORE_OPEN:"ojPopupBeforeOpen",POPUP_AFTER_OPEN:"ojPopupAfterOpen",POPUP_BEFORE_CLOSE:"ojPopupBeforeClose",POPUP_AFTER_CLOSE:"ojPopupAfterClose"},e.PopupService.LAYER_LEVEL={TOP_LEVEL:"topLevel",NEAREST_ANCESTOR:"nearestAncestor"},e.PopupService.OPTION={POPUP:"popup",EVENTS:"events",MODALITY:"modality",LAUNCHER:"launcher",POSITION:"position",LAYER_SELECTORS:"layerSelectors",LAYER_LEVEL:"layerLevel",CONTEXT:"context",CUSTOM_ELEMENT:"customElement"},e.PopupServiceImpl=function(){this.Init()},e.Object.createSubclass(e.PopupServiceImpl,e.PopupService,"oj.PopupServiceImpl"),e.PopupServiceImpl.prototype.open=function(i){e.Assert.assertObject(i);var o=i[e.PopupService.OPTION.POPUP];e.Assert.assertPrototype(o,t);var r=e.ZOrderUtils.getStatus(o);if(r===e.ZOrderUtils.STATUS.UNKNOWN||r===e.ZOrderUtils.STATUS.BEFORE_OPEN||r===e.ZOrderUtils.STATUS.CLOSE){var a=i[e.PopupService.OPTION.LAUNCHER];e.Assert.assertPrototype(a,t);var l=i[e.PopupService.OPTION.POSITION];e.Assert.assertObjectOrNull(l);var u=i[e.PopupService.OPTION.EVENTS];e.Assert.assertObject(u);var c=i[e.PopupService.OPTION.MODALITY];(!c||e.PopupService.MODALITY.MODELESS!==c&&e.PopupService.MODALITY.MODAL!==c)&&(c=e.PopupService.MODALITY.NONE);var p=i[e.PopupService.OPTION.LAYER_SELECTORS];e.Assert.assertString(p);var h=i[e.PopupService.OPTION.CUSTOM_ELEMENT],d=i[e.PopupService.OPTION.LAYER_LEVEL];(!d||e.PopupService.LAYER_LEVEL.TOP_LEVEL!==d&&e.PopupService.LAYER_LEVEL.NEAREST_ANCESTOR!==d)&&(d=e.PopupService.LAYER_LEVEL.NEAREST_ANCESTOR);var _=u[e.PopupService.EVENT.POPUP_BEFORE_OPEN];_&&t.isFunction(_)||(_=e.PopupServiceImpl._defaultBeforeOpenCallback);var f=u[e.PopupService.EVENT.POPUP_AFTER_OPEN];e.ZOrderUtils.setStatus(o,e.ZOrderUtils.STATUS.OPENING),e.DomUtils.setLogicalParent(o,a),e.ZOrderUtils.addToAncestorLayer(o,a,c,p,d,h);var g,v=function(){try{o.removeAttr("aria-hidden"),this._assertEventSink(),s.subtreeShown(o[0])}catch(e){n.error("Error opening popup:\n%o",e)}finally{e.ZOrderUtils.setStatus(o,e.ZOrderUtils.STATUS.OPEN),f&&f(i);var r=e.ZOrderUtils.getFirstAncestorLayer(o);e.Assert.assertPrototype(r,t),e.ZOrderUtils.applyEvents(r,u),!e.ZOrderUtils._getSurrogate(r)&&t.isFunction(u[e.PopupService.EVENT.POPUP_REMOVE])&&(0,u[e.PopupService.EVENT.POPUP_REMOVE])()}};v=v.bind(this);try{g=_(i)}catch(e){n.error("Error before open popup:\n%o",e)}finally{g&&g instanceof Promise?g.then(v):v()}}else this._assertEventSink()},e.PopupServiceImpl._defaultBeforeOpenCallback=function(i){var s=i[e.PopupService.OPTION.POPUP];e.Assert.assertPrototype(s,t);var n=i[e.PopupService.OPTION.POSITION];s.show(),n&&s.position(n)},e.PopupServiceImpl.prototype.close=function(i){e.Assert.assertObject(i);var o=i[e.PopupService.OPTION.POPUP];e.Assert.assertPrototype(o,t);var r=e.ZOrderUtils.getOpenPopupLayer(o);e.Assert.assertPrototype(r,t);var a=i[e.PopupService.OPTION.EVENTS];a?a=t.extend(e.ZOrderUtils.getEvents(r),a):(a=e.ZOrderUtils.getEvents(r),i[e.PopupService.OPTION.EVENTS]=a);var l=e.ZOrderUtils.getStatus(o);if(l!==e.ZOrderUtils.STATUS.OPEN&&l!==e.ZOrderUtils.STATUS.BEFORE_CLOSE||!a)this._assertEventSink();else{var u=a[e.PopupService.EVENT.POPUP_BEFORE_CLOSE];u&&t.isFunction(u)||(u=e.PopupServiceImpl._defaultBeforeCloseCallback);var c=a[e.PopupService.EVENT.POPUP_AFTER_CLOSE];e.ZOrderUtils.setStatus(o,e.ZOrderUtils.STATUS.CLOSING),e.ZOrderUtils.applyEvents(r,{});var p,h=function(){try{o.hide(),o.attr("aria-hidden","true"),o.css({top:"auto",bottom:"auto",left:"auto",right:"auto"}),e.ZOrderUtils.removeFromAncestorLayer(o),e.DomUtils.setLogicalParent(o,null),this._assertEventSink(),s.subtreeHidden(o[0])}catch(e){n.error("Error closing popup:\n%o",e)}finally{e.ZOrderUtils.setStatus(o,e.ZOrderUtils.STATUS.CLOSE),c&&t.isFunction(c)&&c(i)}};h=h.bind(this);try{p=u(i)}catch(e){n.error("Error before close popup:\n%o",e)}finally{p&&p instanceof Promise?p.then(h):h()}}},e.PopupServiceImpl._defaultBeforeCloseCallback=function(i){var s=i[e.PopupService.OPTION.POPUP];e.Assert.assertPrototype(s,t),s.hide()},e.PopupServiceImpl.prototype.changeOptions=function(i){e.Assert.assertObject(i);var s=i[e.PopupService.OPTION.POPUP];if(e.Assert.assertPrototype(s,t),e.ZOrderUtils.getStatus(s)===e.ZOrderUtils.STATUS.OPEN){var n=e.ZOrderUtils.getOpenPopupLayer(s);e.Assert.assertPrototype(n,t);var o=i[e.PopupService.OPTION.EVENTS];o&&e.ZOrderUtils.applyEvents(n,o);var r=i[e.PopupService.OPTION.MODALITY];r&&e.ZOrderUtils.applyModality(n,r);var a=i[e.PopupService.OPTION.LAYER_SELECTORS];e.StringUtils.isEmptyOrUndefined(a)||n.attr("class",a)}},e.PopupServiceImpl.prototype.triggerOnDescendents=function(t,i,s){if(e.ZOrderUtils.isPopupOpen(t)){var n={};n.event=i,n.argsArray=s;var o=e.ZOrderUtils.getFirstAncestorLayer(t);e.ZOrderUtils.postOrderVisit(o,this._triggerOnDescendentsVisitCallback,n)}},e.PopupServiceImpl.prototype._triggerOnDescendentsVisitCallback=function(i,s){var n=s.event,o=s.argsArray,r=e.ZOrderUtils.getEvents(i);return r&&t.isFunction(r[n])&&r[n].apply(this,o),e.ZOrderUtils.VISIT_RESULT.ACCEPT},e.PopupServiceImpl.prototype._assertEventSink=function(){var t,i,s,n=e.ZOrderUtils.hasPopupsOpen(),o=this._callbackEventFilter;if(!n&&o){for(window.removeEventListener("resize",e.PopupServiceImpl._refreshCallback,!0),window.removeEventListener("scroll",e.PopupServiceImpl._refreshCallback,!0),(i=document.documentElement).removeEventListener("mousewheel",e.PopupServiceImpl._refreshCallback,!0),i.removeEventListener("DOMMouseScroll",e.PopupServiceImpl._refreshCallback,!0),this._callbackEventFilter=null,t=0;t<e.PopupServiceImpl._REDISTRIBUTE_EVENTS.length;t++)s=e.PopupServiceImpl._REDISTRIBUTE_EVENTS[t],i.removeEventListener(s,o,!0);var r=this._simpleTapRecognizer;r&&(r.destroy(),this._simpleTapRecognizer=null)}else if(n&&!o){for(window.addEventListener("resize",e.PopupServiceImpl._refreshCallback,!0),window.addEventListener("scroll",e.PopupServiceImpl._refreshCallback,!0),(i=document.documentElement).addEventListener("mousewheel",e.PopupServiceImpl._refreshCallback,!0),i.addEventListener("DOMMouseScroll",e.PopupServiceImpl._refreshCallback,!0),o=this._eventFilterCallback.bind(this),this._callbackEventFilter=o,t=0;t<e.PopupServiceImpl._REDISTRIBUTE_EVENTS.length;t++)s=e.PopupServiceImpl._REDISTRIBUTE_EVENTS[t],i.addEventListener(s,o,!0);e.DomUtils.isTouchSupported()&&(this._simpleTapRecognizer=new e.SimpleTapRecognizer(o))}},e.PopupServiceImpl.prototype._eventFilterCallback=function(i){var s=t(i.target);if(e.ZOrderUtils.hasPopupsOpen()){if(!e.DomUtils.isChromeEvent(i)&&("focus"!==i.type||s.is(":focusable"))){var n=e.ZOrderUtils.getDefaultLayer();if("keydown"!==i.type||!e.ZOrderUtils.hasModalDialogOpen()||e.DomUtils.isAncestor(n[0],s[0])){var o,r=e.ZOrderUtils.getFirstAncestorLayer(s);if(n[0]!==r[0]?r.hasClass(e.PopupServiceImpl._FOCUS_WITHIN_SELECTOR)||((o=this._lastFocusLayer)&&o.removeClass(e.PopupServiceImpl._FOCUS_WITHIN_SELECTOR),r.addClass(e.PopupServiceImpl._FOCUS_WITHIN_SELECTOR),this._lastFocusLayer=r):(o=this._lastFocusLayer)&&(o.removeClass(e.PopupServiceImpl._FOCUS_WITHIN_SELECTOR),this._lastFocusLayer=null),"focus"!==i.type||"-1"!==s.attr("tabindex")){for(var a={},l=e.PopupServiceImpl._COPY_SAFE_EVENT_PROPERTIES,u={},c=0;c<l.length;c++){var p=l[c],h=i[p];void 0===h||t.isFunction(h)||(u[p]=h)}a.event=t.Event(i,u),e.ZOrderUtils.postOrderVisit(n,e.PopupServiceImpl._redistributeVisitCallback,a)}}else e.ZOrderUtils.eatEvent(i)}}else this._assertEventSink()},e.PopupServiceImpl._redistributeVisitCallback=function(i,s){var n=e.ZOrderUtils.getEvents(i),o=s.event;return n&&t.isFunction(n[e.PopupService.EVENT.POPUP_AUTODISMISS])&&n[e.PopupService.EVENT.POPUP_AUTODISMISS](o),e.ZOrderUtils.VISIT_RESULT.ACCEPT},e.PopupServiceImpl._refreshCallback=function(i){var s=e.PopupServiceImpl._refreshTimerId;isNaN(s)&&(e.PopupServiceImpl._refreshTimerId=window.setTimeout(function(){e.PopupServiceImpl._refreshTimerId=Number.NaN;var i=e.ZOrderUtils.getDefaultLayer();t.isFunction(window.requestAnimationFrame)?e.PopupServiceImpl._afRequestId=window.requestAnimationFrame(function(){e.PopupServiceImpl._afRequestId=null,e.ZOrderUtils.postOrderVisit(i,e.PopupServiceImpl._refreshVisitCallback)}):e.ZOrderUtils.postOrderVisit(i,e.PopupServiceImpl._refreshVisitCallback)},e.PopupServiceImpl._REFRESH_DELAY))},e.PopupServiceImpl._refreshVisitCallback=function(i,s){if(s.level>0)return e.ZOrderUtils.VISIT_RESULT.REJECT;var n=e.ZOrderUtils.getEvents(i);return n&&t.isFunction(n[e.PopupService.EVENT.POPUP_REFRESH])&&n[e.PopupService.EVENT.POPUP_REFRESH](),e.ZOrderUtils.VISIT_RESULT.ACCEPT},e.PopupServiceImpl.prototype.destroy=function(){e.PopupServiceImpl.superclass.destroy.call(this)},e.PopupServiceImpl._FOCUS_WITHIN_SELECTOR="oj-focus-within",e.PopupServiceImpl._REDISTRIBUTE_EVENTS=["focus","mousedown","keydown"],e.PopupServiceImpl._COPY_SAFE_EVENT_PROPERTIES=["altKey","bubbles","cancelable","ctrlKey","currentTarget","eventPhase","metaKey","relatedTarget","shiftKey","target","timeStamp","view","which","button","buttons","clientX","clientY","offsetX","offsetY","pageX","pageY","screenX","screenY","toElement","char","charCode","key","keyCode"],e.PopupServiceImpl._REFRESH_DELAY=10,e.ZOrderUtils={},e.ZOrderUtils.STATUS={UNKNOWN:0,BEFORE_OPEN:.5,OPENING:1,OPEN:2,BEFORE_CLOSE:2.5,CLOSING:3,CLOSE:4},e.ZOrderUtils._STATUS_DATA="oj-popup-status",e.ZOrderUtils.getStatus=function(i){i instanceof Element&&(i=t(i));var s=i.data(e.ZOrderUtils._STATUS_DATA);return isNaN(s)?e.ZOrderUtils.STATUS.UNKNOWN:s},e.ZOrderUtils.setStatus=function(i,s){i instanceof Element&&(i=t(i)),s>e.ZOrderUtils.STATUS.UNKNOWN&&s<=e.ZOrderUtils.STATUS.CLOSE&&i.data(e.ZOrderUtils._STATUS_DATA,s)},e.ZOrderUtils.getFirstAncestorLayer=function(t){if(!t)return e.ZOrderUtils.getDefaultLayer();for(var i=t;i&&i.length>0&&i.attr(e.ZOrderUtils._SURROGATE_ATTR)!==e.ZOrderUtils._DEFAULT_LAYER_ID;){if(e.ZOrderUtils._hasSurrogate(i[0]))return i;i=i.parent()}return e.ZOrderUtils.getDefaultLayer()},e.ZOrderUtils.getDefaultLayer=function(){var i=t(document.getElementById(e.ZOrderUtils._DEFAULT_LAYER_ID));return i.length>0?i:((i=t("<div>")).attr("role","presentation"),i.attr("id",e.ZOrderUtils._DEFAULT_LAYER_ID),i.prependTo(t(document.body)),i)},e.ZOrderUtils.addToAncestorLayer=function(i,n,o,r,a,l){var u=i[0];if(e.ZOrderUtils._hasSurrogate(u.parentNode))throw new Error("JET Popup is already open - id: "+u.getAttribute("id"));var c=e.ZOrderUtils.getFirstAncestorLayer(a===e.PopupService.LAYER_LEVEL.TOP_LEVEL?null:n),p=t("<div>"),h=i.attr("id");e.StringUtils.isEmptyOrUndefined(h)?p.uniqueId():p.attr("id",[h,"layer"].join("_")),p.attr("role","presentation"),p.addClass(r),i.after(p),e.ZOrderUtils._createSurrogate(p,l),s.subtreeDetached(u),i.appendTo(p),i.data(e.ZOrderUtils._LAYER_ID_DATA,p.attr("id")),p.appendTo(c),s.subtreeAttached(u),e.ZOrderUtils.applyModality(p,o)},e.ZOrderUtils._getSurrogate=function(t){var i=t.attr(e.ZOrderUtils._SURROGATE_ATTR);if(i)return document.getElementById(i)},e.ZOrderUtils.applyEvents=function(i,n,o){o||(o=t(e.ZOrderUtils._getSurrogate(i))),i.data(e.ZOrderUtils._EVENTS_DATA,n),o.length>0&&n&&t.isFunction(n[e.PopupService.EVENT.POPUP_REMOVE])&&s.setComponentOption(o[0],"beforeDestroy",n[e.PopupService.EVENT.POPUP_REMOVE])},e.ZOrderUtils.getEvents=function(t){return t.data(e.ZOrderUtils._EVENTS_DATA)},e.ZOrderUtils._createSurrogate=function(i,s){var n="script";s&&(n="oj-surrogate");var o=t(document.createElement(n)),r=i.attr("id");e.StringUtils.isEmptyOrUndefined(r)||o.attr("id",[r,"surrogate"].join("_")),s&&o.attr("data-oj-binding-provider","none"),o.insertBefore(i),s||o.ojSurrogate();var a=o.attr("id");return i.attr(e.ZOrderUtils._SURROGATE_ATTR,a),o},e.ZOrderUtils._removeSurrogate=function(i){var n=i.attr(e.ZOrderUtils._SURROGATE_ATTR);i.removeAttr(e.ZOrderUtils._SURROGATE_ATTR);var o=t(document.getElementById(n)),r=o.length>0;return r&&(i.insertAfter(o),s.setComponentOption(o[0],"beforeDestroy",null),o.remove()),r},e.ZOrderUtils.getOpenPopupLayer=function(i){var s=i.parent();if(!s||0===s.length){var n=i.data(e.ZOrderUtils._LAYER_ID_DATA);s=t(document.getElementById(n))}return s},e.ZOrderUtils.removeFromAncestorLayer=function(t){var i=e.ZOrderUtils.getOpenPopupLayer(t);e.ZOrderUtils.preOrderVisit(i,e.ZOrderUtils._closeDescendantPopupsCallback),e.ZOrderUtils._removeOverlayFromAncestorLayer(i),i.removeData(e.ZOrderUtils._EVENTS_DATA),i.removeData(e.ZOrderUtils._MODALITY_DATA),t.removeData(e.ZOrderUtils._LAYER_ID_DATA);var n=t[0];s.subtreeDetached(n),e.ZOrderUtils._removeSurrogate(i)&&n&&n.parentElement?(e.DomUtils.unwrap(t,i),s.subtreeAttached(n)):i.remove()},e.ZOrderUtils._closeDescendantPopupsCallback=function(i,s){if(s.level>0)return e.ZOrderUtils.VISIT_RESULT.REJECT;var n=i.data(e.ZOrderUtils._EVENTS_DATA);return n&&t.isFunction(n[e.PopupService.EVENT.POPUP_CLOSE])&&n[e.PopupService.EVENT.POPUP_CLOSE](),e.ZOrderUtils.VISIT_RESULT.ACCEPT},e.ZOrderUtils.applyModality=function(t,i){var s=t.data(e.ZOrderUtils._MODALITY_DATA);t.data(e.ZOrderUtils._MODALITY_DATA,i),e.StringUtils.isEmptyOrUndefined(s)?e.PopupService.MODALITY.MODAL===i?e.ZOrderUtils._addOverlayToAncestorLayer(t):e.ZOrderUtils._removeOverlayFromAncestorLayer(t):s!==i&&(i!==s&&i===e.PopupService.MODALITY.MODAL?e.ZOrderUtils._addOverlayToAncestorLayer(t):e.ZOrderUtils._removeOverlayFromAncestorLayer(t)),i===e.PopupService.MODALITY.MODAL?t.attr("aria-modal","true"):t.removeAttr("aria-modal")},e.ZOrderUtils.hasModalDialogOpen=function(){for(var i=e.ZOrderUtils.getDefaultLayer().children(),s=i.length-1;s>-1;s--)if(t(i[s]).hasClass(e.ZOrderUtils._OVERLAY_SELECTOR))return!0;return!1},e.ZOrderUtils._addOverlayToAncestorLayer=function(i){var s=t("<div>");s.addClass(e.ZOrderUtils._OVERLAY_SELECTOR),s.addClass(i[0].className),s.attr("role","presentation");var n=i.attr("id");e.StringUtils.isEmptyOrUndefined(n)?s.uniqueId():s.attr("id",[n,"overlay"].join("_")),i.before(s);var o=s.attr("id");i.attr(e.ZOrderUtils._OVERLAY_ATTR,o)},e.ZOrderUtils._removeOverlayFromAncestorLayer=function(i){var s=i.attr(e.ZOrderUtils._OVERLAY_ATTR);e.StringUtils.isEmptyOrUndefined(s)||(i.removeAttr(e.ZOrderUtils._OVERLAY_ATTR),t(document.getElementById(s)).remove())},e.ZOrderUtils.VISIT_RESULT={ACCEPT:0,REJECT:1,COMPLETE:2},e.ZOrderUtils._VISIT_TRAVERSAL={PRE_ORDER:0,POST_ORDER:1},e.ZOrderUtils.postOrderVisit=function(t,i,s){var n=s;s||(n={}),n.level=0,
n.type=e.ZOrderUtils._VISIT_TRAVERSAL.POST_ORDER,e.ZOrderUtils._visitTree(t,i,n)},e.ZOrderUtils.preOrderVisit=function(t,i,s){var n=s;s||(n={}),n.level=0,n.type=e.ZOrderUtils._VISIT_TRAVERSAL.PRE_ORDER,e.ZOrderUtils._visitTree(t,i,n)},e.ZOrderUtils._visitTree=function(i,s,n){for(var o=n.level,r=i.children(),a=r.length-1;a>-1;a--){var l=t(r[a]);if(e.ZOrderUtils._hasSurrogate(l[0])){var u;if(n.type===e.ZOrderUtils._VISIT_TRAVERSAL.PRE_ORDER){if((u=s(l,n))===e.ZOrderUtils.VISIT_RESULT.COMPLETE)return u;if(u===e.ZOrderUtils.VISIT_RESULT.REJECT)break}if(n.level=o+1,u=e.ZOrderUtils._visitTree(l,s,n),n.level=o,u===e.ZOrderUtils.VISIT_RESULT.COMPLETE)return u;if(n.type===e.ZOrderUtils._VISIT_TRAVERSAL.POST_ORDER){if((u=s(l,n))===e.ZOrderUtils.VISIT_RESULT.COMPLETE)return u;if(u===e.ZOrderUtils.VISIT_RESULT.REJECT)break}}}return e.ZOrderUtils.VISIT_RESULT.ACCEPT},e.ZOrderUtils._hasSurrogate=function(t){return!(!t||1!==t.nodeType||!t.hasAttribute(e.ZOrderUtils._SURROGATE_ATTR))},e.ZOrderUtils.hasPopupsOpen=function(){return e.ZOrderUtils.getDefaultLayer().children().length>0},e.ZOrderUtils.getOpenPopupCount=function(){var t={popupCount:0},i=e.ZOrderUtils.getDefaultLayer();return e.ZOrderUtils.preOrderVisit(i,e.ZOrderUtils._openPopupCountCallback,t),t.popupCount},e.ZOrderUtils._openPopupCountCallback=function(t,i){return i.popupCount+=1,e.ZOrderUtils.VISIT_RESULT.ACCEPT},e.ZOrderUtils.findOpenPopups=function(){var i={},s=[];i.popups=s;var n=e.ZOrderUtils.getDefaultLayer();return e.ZOrderUtils.preOrderVisit(n,e.ZOrderUtils._openPopupsCallback,i),s=i.popups,t(s)},e.ZOrderUtils._openPopupsCallback=function(t,i){return i.popups.push(t[0]),e.ZOrderUtils.VISIT_RESULT.ACCEPT},e.ZOrderUtils.isAboveTopModalLayer=function(i){if(!i||!e.ZOrderUtils.hasPopupsOpen())return!0;var s=function(){var i={topLayer:null},s=e.ZOrderUtils.getDefaultLayer();if(e.ZOrderUtils.preOrderVisit(s,function(i,s){if(s.level>0)return e.ZOrderUtils.VISIT_RESULT.REJECT;var n=s.topLayer;return n?e.ZOrderUtils.compareStackingContexts(t(i),t(n))>0&&(s.topLayer=i):s.topLayer=i,e.ZOrderUtils.VISIT_RESULT.ACCEPT},i),i.topLayer)return i.topLayer[0]}();if(!s)return!0;var n=function(i){var s={topModalPopup:null};if(i.hasAttribute(e.ZOrderUtils._OVERLAY_ATTR)&&(s.topModalPopup=t(i)),e.ZOrderUtils.postOrderVisit(t(i),function(t,i){return t[0].hasAttribute(e.ZOrderUtils._OVERLAY_ATTR)?(i.topModalPopup=t,e.ZOrderUtils.VISIT_RESULT.COMPLETE):e.ZOrderUtils.VISIT_RESULT.ACCEPT},s),s.topModalPopup)return s.topModalPopup[0]}(s);return!n||e.DomUtils.isAncestorOrSelf(n,i)||e.ZOrderUtils.compareStackingContexts(t(n),t(i))<0},e.ZOrderUtils.compareStackingContexts=function(i,s){function n(i,s){var n,o=["absolute","relative","fixed"],r=i.parents(),a=[];for(n=r.length-1;n>-1;n--)a.push(t(r[n]));(r=a).push(i);var l=[],u=0;for(n=0;n<r.length;n++){var c=r[n],p=c.css("position"),h=e.DomUtils.getCSSLengthAsFloat(c.css("opacity")),d=e.DomUtils.getCSSLengthAsInt(c.css("z-index")),_=t.inArray(c[0],c.parent().children());t.inArray(p,o)>-1&&d>0?(l.push({weight:[u,d,_],order:[_]}),u+=1):h<1?(l.push({weight:[u,1,_],order:[_]}),u+=1):s&&l.push({weight:[0,0,_],order:[_]})}return l}function o(e,t){for(var i=Math.max(e.length,t.length),s=0;s<i;s++){var n=s<e.length?e[s]:0,o=s<t.length?t[s]:0;if(n!==o)return n<o?-1:1}return 0}e.Assert.assertPrototype(i,t),e.Assert.assertPrototype(s,t);var r,a,l=n(i,!1),u=n(s,!1),c=Math.max(l.length,u.length);for(r=0;r<c;r++)if(0!==(a=o(r<l.length?l[r].weight:[-1],r<u.length?u[r].weight:[-1])))return a;for(l=n(i,!0),u=n(s,!0),c=Math.max(l.length,u.length),r=0;r<c;r++)if(0!==(a=o(r<l.length?l[r].order:[-1],r<u.length?u[r].order:[-1])))return a;return 0},e.ZOrderUtils.eatEvent=function(e){e.stopPropagation(),e.preventDefault()},e.ZOrderUtils.isPopupOpen=function(t){var i=t.parent();return!(!i||1!==i.length||!e.ZOrderUtils._hasSurrogate(i[0]))},e.ZOrderUtils._EVENTS_DATA="oj-popup-events",e.ZOrderUtils._MODALITY_DATA="oj-popup-modality",e.ZOrderUtils._DEFAULT_LAYER_ID="__oj_zorder_container",e.ZOrderUtils._SURROGATE_ATTR="data-oj-surrogate-id",e.ZOrderUtils._LAYER_ID_DATA="oj-popup-layer-id",e.ZOrderUtils._OVERLAY_ATTR="data-oj-overlayid",e.ZOrderUtils._OVERLAY_SELECTOR="oj-component-overlay",e.__registerWidget("oj.ojSurrogate",t.oj.baseComponent,{version:"1.0.0",widgetEventPrefix:"oj",options:{beforeDestroy:null},_ComponentCreate:function(){this._super(),this.element.uniqueId()},_invokeBeforeDestroy:function(){var e=this.options.beforeDestroy;this.options.beforeDestroy=null,e&&e()},_destroy:function(){this._invokeBeforeDestroy(),this.element.removeUniqueId(),this._super()},_NotifyDetached:function(){this._invokeBeforeDestroy(),this._super()}}),e.CustomElementBridge.register("oj-surrogate",{metadata:{properties:{beforeDestroy:{type:"function"}},extension:{_WIDGET_NAME:"ojSurrogate"}}}),e.SimpleTapRecognizer=function(e){this._tapCallback=e,this.Init()},e.Object.createSubclass(e.SimpleTapRecognizer,e.Object,"oj.SimpleTapRecognizer"),e.SimpleTapRecognizer.prototype.Init=function(){e.SimpleTapRecognizer.superclass.Init.call(this);var t=this._eventHandler.bind(this);this._eventHandlerCallback=t;for(var i=document.documentElement,s=0;s<e.SimpleTapRecognizer._TOUCHEVENTS.length;s++)i.addEventListener(e.SimpleTapRecognizer._TOUCHEVENTS[s],t,!0)},e.SimpleTapRecognizer.prototype._eventHandler=function(t){var i=this._tapCallback,s=t.type;if("touchstart"===s)this._touchStartEvent=t,this._touchStartEvent._tapStart=(new Date).getTime();else if("touchmove"===s||"touchcancel"===s)this._touchStartEvent=null;else if("touchend"===s){if(this._touchStartEvent){var n=this._touchStartEvent._tapStart;isNaN(n)?i(this._touchStartEvent):(new Date).getTime()-n<e.SimpleTapRecognizer._PRESSHOLDTHRESSHOLD&&i(this._touchStartEvent)}this._touchStartEvent=null}},e.SimpleTapRecognizer.prototype.destroy=function(){this._tapCallback=null;var t=this._eventHandlerCallback;this._eventHandlerCallback=null;for(var i=document.documentElement,s=0;s<e.SimpleTapRecognizer._TOUCHEVENTS.length;s++)i.removeEventListener(e.SimpleTapRecognizer._TOUCHEVENTS[s],t,!0)},e.SimpleTapRecognizer._TOUCHEVENTS=["touchstart","touchmove","touchcancel","touchend"],e.SimpleTapRecognizer._PRESSHOLDTHRESSHOLD=700,e.PopupLiveRegion=function(){this.Init()},e.Object.createSubclass(e.PopupLiveRegion,e.Object,"oj.PopupLiveRegion"),e.PopupLiveRegion.prototype.Init=function(){e.PopupLiveRegion.superclass.Init.call(this),isNaN(e.PopupLiveRegion._refCounter)?e.PopupLiveRegion._refCounter=1:e.PopupLiveRegion._refCounter+=1},e.PopupLiveRegion.prototype.destroy=function(){if(!isNaN(e.PopupLiveRegion._refCounter)&&(e.PopupLiveRegion._refCounter-=1,e.PopupLiveRegion._refCounter<1)){var i=t(document.getElementById(e.PopupLiveRegion._POPUP_LIVE_REGION_ID));i.length>0&&i.remove()}},e.PopupLiveRegion.prototype.announce=function(i){if(!e.StringUtils.isEmpty(i)){var s=e.PopupLiveRegion._getLiveRegion();s.children().remove(),t("<div>").text(i).appendTo(s)}},e.PopupLiveRegion._getLiveRegion=function(){var i=t(document.getElementById(e.PopupLiveRegion._POPUP_LIVE_REGION_ID));return 0===i.length&&((i=t("<div>")).attr({id:e.PopupLiveRegion._POPUP_LIVE_REGION_ID,role:"log","aria-live":"polite","aria-relevant":"additions"}),i.addClass("oj-helper-hidden-accessible"),i.appendTo(document.body)),i},e.PopupLiveRegion._POPUP_LIVE_REGION_ID="__oj_popup_arialiveregion",e.PopupSkipLink=function(i,s,n,o,r){e.Assert.assertPrototype(i,t),e.Assert.assertString(s),e.Assert.assertFunction(n),e.Assert.assertStringOrNull(o),this._options={insertBefore:!1,preventKeyEvents:!0},r&&(this._options=Object.assign({},this._options,r)),this._sibling=i,this._message=s,this._callback=n,this._id=o,this.Init()},e.Object.createSubclass(e.PopupSkipLink,e.Object,"oj.PopupSkipLink"),e.PopupSkipLink.prototype.Init=function(){e.PopupSkipLink.superclass.Init.call(this);var i=this._sibling,s=this._callback,n=this._message,o=this._options.insertBefore,r=this._options.preventKeyEvents;this._message=null;var a=this._id;this._id=null;var l=t(document.getElementById(a));l.length<1&&(l=t("<a>").attr({tabindex:"-1",href:"#",role:"link"})),l.attr("id",a),l.addClass("oj-helper-hidden-accessible"),l.text(n),o?l.insertBefore(i):l.insertAfter(i),l.on("click",e.PopupSkipLink._activateHandler.bind(this,s)),r&&l.on("keydown keyup keypress",e.PopupSkipLink._keyHandler),i.data(e.PopupSkipLink._SKIPLINK_ATTR,l)},e.PopupSkipLink._activateHandler=function(t,i){e.ZOrderUtils.eatEvent(i),window.setImmediate(t)},e.PopupSkipLink._keyHandler=function(i){i.keyCode===t.ui.keyCode.ENTER&&e.ZOrderUtils.eatEvent(i)},e.PopupSkipLink.prototype.destroy=function(){var t=this._sibling;if(delete this._sibling,delete this._callback,t){var i=t.data(e.PopupSkipLink._SKIPLINK_ATTR);t.removeData(e.PopupSkipLink._SKIPLINK_ATTR),i&&(i.off("click keydown keyup keypress"),i.remove())}},e.PopupSkipLink.prototype.getLink=function(){var t,i=this._sibling;return i&&(t=i.data(e.PopupSkipLink._SKIPLINK_ATTR)),t},e.PopupSkipLink._SKIPLINK_ATTR="oj-skiplink",e.PopupWhenReadyMediator=function(e,t,i,s){this._element=e,this._operation=t,this._widgetName=i,this._isCustomElement=!!s,this.Init()},e.Object.createSubclass(e.PopupWhenReadyMediator,e.Object,"oj.PopupWhenReadyMediator"),e.PopupWhenReadyMediator.prototype.Init=function(){e.PopupWhenReadyMediator.superclass.Init.call(this),this._resolvedQueue=[],this._callback=this._eventHandler.bind(this);var t=this._operation,s=["oj"];this._isCustomElement?(s.push(t.charAt(0).toUpperCase()),s.push(t.slice(1))):s.push(t);var n=s.join("");this._eventType=n,this._element.on(n,this._callback);var o=i.getContext(this._element[0]).getBusyContext(),r={description:this._getBusyStateDescription.bind(this,this._element,this._operation,this._widgetName)},a=o.addBusyState(r);this.AddPromiseExecutor(a),this._whenReadyPromise=new Promise(this.AddPromiseExecutor.bind(this))},e.PopupWhenReadyMediator.prototype._getBusyStateDescription=function(e,t,i){return i+" identified by '"+e.attr("id")+"' is busy animating on the '"+t+"' operation."},e.PopupWhenReadyMediator.prototype._deliverResolved=function(e){var t=this._resolvedQueue;this._resolvedQueue=null;var i=e||this._operation;this._operation=null;for(var s=0;s<t.length;s++)try{t[s](i)}catch(e){n.error("Error resolving whenReady promises:\n%o",e)}this._whenReadyPromise=Promise.resolve("none")},e.PopupWhenReadyMediator.prototype.destroy=function(){if(this._resolvedQueue&&this._deliverResolved("none"),this._callback){var e=this._eventType;this._element.off(e,this._callback)}this._callback=null,this._element=null,this._operation=null,this._whenReadyPromise=null,this._widgetName=null,this._eventType=null},e.PopupWhenReadyMediator.prototype.getWhenReadyPromise=function(){return this._whenReadyPromise},e.PopupWhenReadyMediator.prototype._eventHandler=function(e){e.target===this._element[0]&&(this._element.off(e.type,this._callback),this._deliverResolved(),this._callback=null)},e.PopupWhenReadyMediator.prototype._getPendingOperation=function(){return this._operation?this._operation:"none"},e.PopupWhenReadyMediator.prototype.AddPromiseExecutor=function(e,t){this._resolvedQueue&&this._resolvedQueue.push(e)},e.PopupWhenReadyMediator.prototype.isOperationPending=function(e,t,i,s){var o=!1,r=this._widgetName,a=this._getPendingOperation();return t===a?(n.info("An %s instance invoked a '%s' operation while pending animation of the same type of operation.  The second request will be ignored.",r,t),o=!0):"none"!==a&&(n.info("An %s instance invoked a '%s' operation while pending animation of a '%s' operation. The second request will be invoked after the pending operation completes.",r,t,a),new Promise(this.AddPromiseExecutor.bind(this)).then(function(){this[i].apply(this,s)}.bind(e)),o=!0),o},e.PositionUtils={},e.PositionUtils.normalizeHorizontalAlignment=function(i,s){for(var n=t.extend({},i),o=0;o<e.PositionUtils._ALIGN_RULE_PROPERTIES.length;o++){var r=e.PositionUtils._ALIGN_RULE_PROPERTIES[o],a=n[r];if(a)if(e.StringUtils.isString(a))n[r]=a.replace("start",s?"right":"left").replace("end",s?"left":"right").replace("<",s?"+":"-").replace(">",s?"-":"+");else for(var l=0;l<e.PositionUtils._SUB_ALIGN_RULE_PROPERTIES.length;l++){var u=e.PositionUtils._SUB_ALIGN_RULE_PROPERTIES[l],c=a[u];e.StringUtils.isString(c)&&(a[u]=c.replace("start",s?"right":"left").replace("end",s?"left":"right").replace("<",s?"+":"-").replace(">",s?"-":"+"))}}return n},e.PositionUtils.normalizePositionOf=function(e,t,i){return"event"===e?i:null==e||"launcher"===e?t:e},e.PositionUtils._normalizeEventForPosition=function(e){t.each(["pageX","pageY"],function(t,i){if(e&&void 0===e[i]&&e.originalEvent){var s,n=e.originalEvent,o=n.type;if(s="touchstart"===o||"touchmove"===o?"touches":"touchend"===o?"changedTouches":null){var r=n[s][0];r&&(e[i]=r[i])}}})},e.PositionUtils._ALIGN_RULE_PROPERTIES=["my","at"],e.PositionUtils._SUB_ALIGN_RULE_PROPERTIES=["vertical","horizontal"],e.PositionUtils.isAligningPositionClipped=function(t){if(t.target&&t.target.height>0&&t.target.width>0){var i=t.target.element;return!e.PositionUtils.isWithinViewport(i)}return!1},e.PositionUtils.isWithinViewport=function(i){function s(e){var i=e[0];if(1===i.nodeType){var s=t.extend({},i.getBoundingClientRect());return s.overflowX=e.css("overflow-x"),s.overflowY=e.css("overflow-y"),s.innerHeight=e.innerHeight(),s.innerWidth=e.innerWidth(),s.scrollHeight=i.scrollHeight,s.scrollWidth=i.scrollWidth,s}return{height:0,width:0}}function n(t){return["fixed","absolute","relative"].indexOf(t.css("position"))>-1&&(Math.abs(e.DomUtils.getCSSLengthAsInt(t.css("top")))>0||Math.abs(e.DomUtils.getCSSLengthAsInt(t.css("bottom")))>0||Math.abs(e.DomUtils.getCSSLengthAsInt(t.css("left")))>0||Math.abs(e.DomUtils.getCSSLengthAsInt(t.css("right")))>0)}if(!i)return!1;if(t.isWindow(i[0])||n(i))return!0;for(var o,r=s(i),a=!0,l=i.parent();a&&l&&l.length>0&&"BODY"!==l[0].nodeName&&1===l[0].nodeType&&!n(l);){if("visible"!==(o=l).css("overflow-x")||"visible"!==o.css("overflow-y")){var u=s(l);u.height>0&&u.width>0&&(a=function(t,i){var s;if(["hidden","scroll","auto"].indexOf(i.overflowY)>-1){if(t.bottom-i.top<-1)return!1;if(s="auto"===i.overflowX&&i.scrollWidth>i.innerWidth||"scroll"===i.overflowX?e.DomUtils.getScrollBarWidth():0,i.bottom-s-t.top<1)return!1}return!(["hidden","scroll","auto"].indexOf(i.overflowX)>-1&&(s="auto"===i.overflowY&&i.scrollHeight>i.innerHeight||"scroll"===i.overflowY?e.DomUtils.getScrollBarWidth():0,t.right-(i.left+("rtl"===e.DomUtils.getReadingDirection()?s:0))<-1||t.left-(i.right-("ltr"===e.DomUtils.getReadingDirection()?s:0))>-1))}(r,u))}l=l.parent()}return a},e.PositionUtils._ANIMATION_TRANSFORM_ORIGIN_RULES={"right-top":"right top","right-middle":"right center","right-bottom":"right bottom","left-top":"left top","left-middle":"left center","left-bottom":"left bottom","center-top":"center top","center-middle":"center center","center-bottom":"center bottom"},e.PositionUtils._ALIGN_MNEMONIC_DATA="oj-popup-align-mnemonic",e.PositionUtils.captureTransformOriginAnimationEffectsOption=function(t,i){var s=[i.horizontal,i.vertical].join("-");t.data(e.PositionUtils._ALIGN_MNEMONIC_DATA,s)},e.PositionUtils.addTransformOriginAnimationEffectsOption=function(t,i){var s,n;e.StringUtils.isString(i)?(n=!0,s=i):(n=!1,s=JSON.stringify(i));var o=/#myPosition/g;if(s.match(o)){var r=t.data(e.PositionUtils._ALIGN_MNEMONIC_DATA);e.StringUtils.isEmptyOrUndefined(r)&&(r="center-middle");var a=e.PositionUtils._ANIMATION_TRANSFORM_ORIGIN_RULES[r];s=s.replace(o,a),i=n?s:JSON.parse(s)}return i},e.PositionUtils._JQUI_MNEMONIC_GRP_REGX=/^(\w+)(\+|-)?(\d+)?/,e.PositionUtils._VERTICAL_ENUM_TST_REGX=/^top$|^center$|^bottom$/,e.PositionUtils._HORIZONTAL_ENUM_TST_REGX=/^start$|^left$|^center$|^end$|^right$/,e.PositionUtils._COLLISION_ENUM_TST_REGX=/^none$|^flip$|^flipfit$|^fit$|^flipcenter$/,e.PositionUtils._parsePositionNmnemonic=function(t,i){var s=[null,Number.NaN],n=e.PositionUtils._JQUI_MNEMONIC_GRP_REGX.exec(t);if(n[1]&&i.test(n[1])&&(s[0]=n[1],n[2])){var o=parseInt(n[3],10);isNaN(o)||(o*="-"===n[2]?-1:1,s[1]=o)}return s},e.PositionUtils._parseJSON=function(t){if(e.StringUtils.isString(t)&&/^{/.test(t)&&/}$/.test(t))try{return JSON.parse(t)}catch(e){}return null},e.PositionUtils._coerceMyAtToJet=function(i,s,n,o){var r=e.PositionUtils._parseJSON(s);r&&(s=r),(r=e.PositionUtils._parseJSON(n))&&(n=r),o||(o={});var a,l=t.extend({},o),u={x:0,y:0};if(n&&"x"in n&&"y"in n&&(u.x=e.DomUtils.getCSSLengthAsInt(n.x),u.y=e.DomUtils.getCSSLengthAsInt(n.y)),e.StringUtils.isString(s)){var c=s.split(/\s/);c.length>0&&!e.StringUtils.isEmpty(c[0])&&(a=e.PositionUtils._parsePositionNmnemonic(c[0],e.PositionUtils._HORIZONTAL_ENUM_TST_REGX))[0]&&(l.horizontal=a[0],isNaN(a[1])||(u.x=a[1])),c.length>1&&!e.StringUtils.isEmpty(c[1])&&(a=e.PositionUtils._parsePositionNmnemonic(c[1],e.PositionUtils._VERTICAL_ENUM_TST_REGX))[0]&&(l.vertical=a[0],isNaN(a[1])||(u.y=a[1]))}else s&&("horizontal"in s&&(a=e.PositionUtils._parsePositionNmnemonic(s.horizontal,e.PositionUtils._HORIZONTAL_ENUM_TST_REGX))[0]&&(l.horizontal=a[0],isNaN(a[1])||(u.x=a[1])),"vertical"in s&&(a=e.PositionUtils._parsePositionNmnemonic(s.vertical,e.PositionUtils._VERTICAL_ENUM_TST_REGX))[0]&&(l.vertical=a[0],isNaN(a[1])||(u.y=a[1])));var p={};return p[i]=l,p.offset=u,p},e.PositionUtils._coerceCollisionToJet=function(t,i){var s=i;return e.PositionUtils._COLLISION_ENUM_TST_REGX.test(t)&&(s=t),{collision:s}},e.PositionUtils._coerceOfToJet=function(i,s){var n=e.PositionUtils._parseJSON(i);n&&(i=n);var o=s;return e.StringUtils.isString(i)?o=i:t.isWindow(i)?o="window":i instanceof Element||i instanceof t?((i=t(i)).uniqueId(),o="#"+function(e){for(var t=[],i=/\w|_|-/,s=0;s<e.length;s++){var n=e.substring(s,s+1);i.test(n)?t.push(n):t.push("\\"+n)}return t.join("")}(i.attr("id"))):i instanceof Event||i instanceof t.Event?("pageX"in i||"pageY"in i)&&((o={}).x=e.DomUtils.getCSSLengthAsFloat(i.pageX),o.y=e.DomUtils.getCSSLengthAsFloat(i.pageY)):i&&("x"in i||"y"in i)&&((o={}).x=e.DomUtils.getCSSLengthAsFloat(i.x),o.y=e.DomUtils.getCSSLengthAsFloat(i.y)),{of:o}},e.PositionUtils.coerceToJet=function(i,s){i||(i={});var n=e.PositionUtils._parseJSON(i);n&&(i=n),s||(s={});var o=s.my,r=s.at,a=s.collision,l=s.of,u=e.PositionUtils._coerceMyAtToJet("my",i.my,i.offset,o),c=e.PositionUtils._coerceMyAtToJet("at",i.at,null,r),p={offset:{x:u.offset.x+c.offset.x,y:u.offset.y+c.offset.y}};return delete u.offset,delete c.offset,t.extend({},u,c,p,e.PositionUtils._coerceCollisionToJet(i.collision,a),e.PositionUtils._coerceOfToJet(i.of,l),function(e,i){return{using:t.isFunction(e)?e:void 0}}(i.using))},e.PositionUtils.coerceToJqUi=function(i){function s(e,t){var s=[];if(i[e][t]?s.push(i[e][t]):s.push("center"),"my"===e&&i.offset){var n="horizontal"===t?"x":"y",o=i.offset[n];isNaN(o)||0===o||(s.push(o>0?"+":""),s.push(Math.floor(o).toString()))}return s.join("")}var n={};["my","at"].forEach(function(e){if(i[e]){var t=[];t.push(s(e,"horizontal")),t.push(" "),t.push(s(e,"vertical")),n[e]=t.join("")}});var o=i.of;if(e.StringUtils.isString(o))n.of="window"===o?window:o;else if(o&&!e.StringUtils.isString(o)&&"x"in o&&"y"in o){var r=o.x,a=o.y,l=document.createEvent("MouseEvents");l.initMouseEvent("click",!0,!0,window,1,r,a,r,a,!1,!1,!1,!1,0,null),n.of=t.Event(l,{pageX:r,pageY:a})}else n.of=o;return i.collision&&(n.collision=i.collision),i.using&&(n.using=i.using),n},t.ui.position.flipcenter={left:function(i,s){var n=i.left;t.ui.position.flip.left.call(this,i,s);var o=s.within,r=o.isWindow?o.scrollLeft:o.offset.left,a=o.width,l=i.left-s.collisionPosition.marginLeft,u=r-l,c=l+s.collisionWidth-a-r;(u>0||c>0)&&("right"===s.at[0]?n-=s.targetWidth/2:"left"===s.at[0]&&(n+=s.targetWidth/2),n-=("rtl"===e.DomUtils.getReadingDirection()?-1:1)*(s.elemWidth/2),i.left=Math.max(0,n))},top:function(e,i){var s=e.top;t.ui.position.flip.top.call(this,e,i);var n=i.within,o=n.isWindow?n.scrollTop:n.offset.top,r=i.within.height,a=e.top-i.collisionPosition.marginTop,l=o-a,u=a+i.collisionHeight-r-o;(l>0||u>0)&&("top"===i.at[1]?s+=i.targetHeight/2:"bottom"===i.at[1]&&(s-=i.targetHeight/2),s+=i.elemHeight/2,e.top=Math.max(0,s))}};var o=t.ui.position.flip.left;t.ui.position.flip={left:o.bind(this),top:function(e,t){var i,s,n=t.within,o=n.offset.top+n.scrollTop,r=n.height,a=n.isWindow?n.scrollTop:n.offset.top,l=e.top-t.collisionPosition.marginTop,u=l-a,c=l+t.collisionHeight-r-a;i="top"===t.my[1]?-t.elemHeight:"bottom"===t.my[1]?t.elemHeight:0,s="top"===t.at[1]?t.targetHeight:"bottom"===t.at[1]?-t.targetHeight:0;var p,h,d=-2*t.offset[1];u<0?((p=e.top+i+s+d+t.collisionHeight-r-o)<0||p<Math.abs(u))&&c<0&&u>c&&(e.top+=i+s+d):c>0&&((h=e.top-t.collisionPosition.marginTop+i+s+d-a)>0||Math.abs(h)<c)&&(e.top+=i+s+d)}}}),define("ojs/ojpopup",["ojs/ojcore","jquery","ojs/ojcontext","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojanimation","promise","ojs/ojpopupcore"],function(e,t,i,s,n,o){"use strict";var r,a,l={properties:{autoDismiss:{type:"string",enumValues:["focusLoss","none"],value:"focusLoss"},chrome:{type:"string",enumValues:["default","none"],value:"default"},initialFocus:{type:"string",enumValues:["auto","firstFocusable","none","popup"],value:"auto"},modality:{type:"string",enumValues:["modal","modeless"],value:"modeless"},position:{type:"object",properties:{at:{type:"object",properties:{horizontal:{type:"string",enumValues:["center","end","left","right","start"],value:"start"},vertical:{type:"string",enumValues:["bottom","center","top"],value:"bottom"}}},collision:{type:"string",enumValues:["fit","flip","flipcenter","flipfit","none"],value:"flip"},my:{type:"object",properties:{horizontal:{type:"string",enumValues:["center","end","left","right","start"],value:"start"},vertical:{type:"string",enumValues:["bottom","center","top"],value:"top"}}},of:{type:"string|object"},offset:{type:"object",properties:{x:{type:"number",value:0},y:{type:"number",value:0}}}}},tail:{type:"string",enumValues:["none","simple"],value:"none"},translations:{type:"object",value:{},properties:{ariaCloseSkipLink:{type:"string"},ariaFocusSkipLink:{type:"string"},ariaLiveRegionInitialFocusFirstFocusable:{type:"string"},ariaLiveRegionInitialFocusFirstFocusableTouch:{type:"string"},ariaLiveRegionInitialFocusNone:{type:"string"},ariaLiveRegionInitialFocusNoneTouch:{type:"string"}}}},methods:{open:{},close:{},isOpen:{},refresh:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojBeforeOpen:{},ojOpen:{},ojBeforeClose:{},ojClose:{},ojFocus:{},ojAnimateStart:{},ojAnimateEnd:{}},extension:{}};r=["oj-left","oj-center","oj-right","oj-top","oj-middle","oj-bottom"],a={"right-top":"oj-right oj-top","right-middle":"oj-right oj-middle","right-bottom":"oj-right oj-bottom","left-top":"oj-left oj-top","left-middle":"oj-left oj-middle","left-bottom":"oj-left oj-bottom","center-top":"oj-center oj-top","center-middle":"oj-left oj-middle","center-bottom":"oj-center oj-bottom"},e.__registerWidget("oj.ojPopup",t.oj.baseComponent,{widgetEventPrefix:"oj",options:{animation:null,autoDismiss:"focusLoss",chrome:"default",initialFocus:"auto",position:{my:{horizontal:"start",vertical:"top"},offset:{x:0,y:0},at:{horizontal:"start",vertical:"bottom"},of:void 0,collision:"flip"},tail:"none",modality:"modeless",role:"tooltip",beforeOpen:null,open:null,beforeClose:null,close:null,focus:null,animateStart:null,animateEnd:null},_ComponentCreate:function(){this._super();var i=this._getRootStyle(),s=this.element;s.hide().addClass(i).attr("aria-hidden","true"),s.addClass("oj-component");var n=t("<div>");n.addClass([i,"content"].join("-")),n.attr("role","presentation"),n.append(s[0].childNodes),n.appendTo(s),this._content=n,this._setChrome(),this._setupFocus(s);var o=this.options;o.position=e.PositionUtils.coerceToJet(o.position)},_AfterCreate:function(){this._super(),this.element.uniqueId(),this._createTail()},_destroy:function(){e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._closeImplicitly(),this._setWhenReady("none"),this._destroyTail(),delete this._popupServiceEvents;var t=this.element;t.hide().attr("aria-hidden","true").removeUniqueId();var i=this._content;delete this._content,t.append(i[0].childNodes),i.remove();var s=this._closeDelayTimer;s&&(delete this._closeDelayTimer,s()),this._super()},open:function(t,i){if(!this._isOperationPending("open",[t,i])){e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._closeImplicitly();var s=this.element,n=e.ZOrderUtils.getStatus(s);if(n===e.ZOrderUtils.STATUS.CLOSE||n===e.ZOrderUtils.STATUS.UNKNOWN)if(e.ZOrderUtils.setStatus(s,e.ZOrderUtils.STATUS.BEFORE_OPEN),!1!==this._trigger("beforeOpen")){this._setWhenReady("open"),this._setLauncher(t);var o=this._launcher,r=this.options;(i=i||r.position).of||(this._hasPositionOfLauncherOverride=!0,i.of=o),this._setPosition(i),this._setAutoDismiss(r.autoDismiss),this._addDescribedBy(),this._IsCustomElement()&&s[0].hasAttribute("role")||s.attr("role",r.role);var a=this._getPositionAsJqUi(),l=this._getRootStyle(),u=[l,"layer"].join("-"),c=r.tail;"none"!==c&&(u+=" "+[l,"tail",c].join("-"));var p={};p[e.PopupService.OPTION.POPUP]=s,p[e.PopupService.OPTION.LAUNCHER]=o,p[e.PopupService.OPTION.POSITION]=a,p[e.PopupService.OPTION.EVENTS]=this._getPopupServiceEvents(),p[e.PopupService.OPTION.LAYER_SELECTORS]=u,p[e.PopupService.OPTION.MODALITY]=r.modality,p[e.PopupService.OPTION.CUSTOM_ELEMENT]=this._IsCustomElement(),e.PopupService.getInstance().open(p)}else e.ZOrderUtils.setStatus(this.element,n)}},_beforeOpenHandler:function(t){var i=t[e.PopupService.OPTION.POPUP],s=t[e.PopupService.OPTION.POSITION];i.show(),i.position(s);var n=this.options.animation;if(n&&n.open){var r=n.actionPrefix,a=r?[r,"open"].join("-"):"open";return o.startAnimation(i[0],a,e.PositionUtils.addTransformOriginAnimationEffectsOption(i,n.open),this)}},_afterOpenHandler:function(t){var i=t[e.PopupService.OPTION.POPUP],s=t[e.PopupService.OPTION.LAUNCHER];this._initVoiceOverAssist(),this._trigger("open"),this._intialFocus(),this._on(i,{keydown:this._keyHandler}),s&&s.length>0&&this._on(s,{keydown:this._keyHandler})},_GetContextMenu:function(){if(!this._IsCustomElement())return this._super();var t=e.BaseCustomElementBridge.getSlotMap(this._content[0]).contextMenu;return t&&t.length>0?t[0]:void 0},close:function(){if(!this._isOperationPending("close",[])){var t=this.element,i=e.ZOrderUtils.getStatus(t);if(i===e.ZOrderUtils.STATUS.OPEN)if(e.ZOrderUtils.setStatus(t,e.ZOrderUtils.STATUS.BEFORE_CLOSE),!1!==this._trigger("beforeClose")||this._ignoreBeforeCloseResultant){this._setWhenReady("close");var s=this._launcher;this._off(t,"keydown"),s&&s.length>0&&this._off(s,"keydown"),this._restoreFocus(),this._destroyVoiceOverAssist();var n={};n[e.PopupService.OPTION.POPUP]=t,e.PopupService.getInstance().close(n)}else e.ZOrderUtils.setStatus(t,i)}},_beforeCloseHandler:function(t){var i=t[e.PopupService.OPTION.POPUP],s=this.options.animation;if(!this._ignoreBeforeCloseResultant&&s&&s.close){var n=s.actionPrefix,r=n?[n,"close"].join("-"):"close";return o.startAnimation(i[0],r,e.PositionUtils.addTransformOriginAnimationEffectsOption(i,s.close),this).then(function(){i.hide()})}i.hide()},_afterCloseHandler:function(e){this._removeDescribedBy(),this._setAutoDismiss(),delete this._launcher,this._trigger("close"),this._hasPositionOfLauncherOverride&&(this.options.position.of=null,delete this._hasPositionOfLauncherOverride)},isOpen:function(){var t=e.ZOrderUtils.getStatus(this.element);return t===e.ZOrderUtils.STATUS.OPENING||t===e.ZOrderUtils.STATUS.OPEN||t===e.ZOrderUtils.STATUS.BEFORE_CLOSE||t===e.ZOrderUtils.STATUS.CLOSING},refresh:function(){if(this._super(),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._reposition()){var t=this.element;e.PopupService.getInstance().triggerOnDescendents(t,e.PopupService.EVENT.POPUP_REFRESH)}},_setOption:function(t,i){var s=this.options;switch(t){case"tail":i!==s.tail&&this._setTail(i);break;case"chrome":i!==s.chrome&&this._setChrome(i);break;case"position":return this._setPosition(i),void this.refresh();case"autoDismiss":e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&i!==s.autoDismiss&&this._setAutoDismiss(i);break;case"modality":if(e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var n=this.element,o={};o[e.PopupService.OPTION.POPUP]=n,o[e.PopupService.OPTION.MODALITY]=i,e.PopupService.getInstance().changeOptions(o)}}this._superApply(arguments)},_getRootStyle:function(){return"oj-popup"},_setTail:function(e){this._destroyTail(),this._createTail(e),this._reposition()},_createTail:function(i){var s=i||this.options.tail;if("none"!==s){var n=this._getRootStyle(),o=[n,"tail"].join("-"),r=[o,s].join("-"),a=t("<div>").hide();a.addClass(o).addClass(r),a.attr("role","presentation"),this._tailId=a.attr("id",this._getSubId("tail")).attr("id");var l=this.element;if(a.appendTo(l),l.addClass(r),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var u=[n,"layer"].join("-");u+=" "+r;var c={};c[e.PopupService.OPTION.POPUP]=l,c[e.PopupService.OPTION.LAYER_SELECTORS]=u,e.PopupService.getInstance().changeOptions(c)}}},_getTail:function(){var e=this._tailId;return e?t(document.getElementById(e)):null},_destroyTail:function(){var t=this._getTail();t&&t.remove(),delete this._tailId;var i=this.options.tail,s=this._getRootStyle(),n=[s,"tail",i].join("-"),o=this.element;if(o.removeClass(n),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var r=[s,"layer"].join("-"),a={};a[e.PopupService.OPTION.POPUP]=o,a[e.PopupService.OPTION.LAYER_SELECTORS]=r,e.PopupService.getInstance().changeOptions(a)}},_setChrome:function(e){var t=e||this.options.chrome,i=[this._getRootStyle(),"no-chrome"].join("-"),s=this.element;"default"===t&&s.hasClass(i)?s.removeClass(i):"none"!==t||s.hasClass(i)||s.addClass(i)},_setLauncher:function(i){var s=i;if(s?"string"===t.type(s)?s=t(s):1===s.nodeType&&(s=t(s)):s=t(document.activeElement),s instanceof t&&s.length>1)for(var n=this.element,o=0;o<s.length;o++){var r=s[0];if(!e.DomUtils.isAncestorOrSelf(n[0],r)){s=t(r);break}}else s instanceof t&&!(s instanceof t&&0===s.length)||(s=t(document.activeElement));this._launcher=s},_setPosition:function(t){var i=this.options;t&&(i.position=e.PositionUtils.coerceToJet(t,i.position))},_getPositionAsJqUi:function(){var i=this.options,s=e.PositionUtils.coerceToJqUi(i.position),n="rtl"===this._GetReadingDirection(),o=(s=e.PositionUtils.normalizeHorizontalAlignment(s,n)).using;return o=t.isFunction(o)?o:null,s.using=this._usingHandler.bind(this,o),s},_resolveBusyStateAndCloseImplicitly:function(e){e(),delete this._closeDelayTimer,this._closeImplicitly()},_resolveBusyStateAndCancelDelayedClosure:function(e,t){window.clearTimeout(e),t()},_usingHandler:function(t,s,n){var o=n.element.element;if(s.top!==o.css("top")||s.left!==o.css("left")){var l=this._getTail();if(l){l.hide();for(var u=0;u<r.length;u++)l.removeClass(r[u]),o.removeClass(r[u]);if(l.removeAttr("style"),n.target&&0===n.target.height&&0===n.target.width){var c="rtl"===this._GetReadingDirection(),p=e.PositionUtils.normalizeHorizontalAlignment(this.options.position,c).my;if(!e.StringUtils.isEmptyOrUndefined(p)){var h="center"===p.horizontal?p.horizontal:n.horizontal,d="center"===p.vertical?"middle":p.vertical;n.horizontal=h,n.vertical=d}}var _,f,g=[n.horizontal,n.vertical].join("-"),v=a[g];if(l.addClass(v),o.addClass(v),l.show(),"left"===n.horizontal?(_=l.outerWidth(),_-=_+e.DomUtils.getCSSLengthAsInt(l.css("left")),s.left+=_-2):"right"===n.horizontal&&(_=l.outerWidth(),_-=_+e.DomUtils.getCSSLengthAsInt(l.css("right")),s.left-=_-2),"top"===n.vertical?(f=l.outerHeight(),f-=f+e.DomUtils.getCSSLengthAsInt(l.css(n.vertical)),s.top+=f-2):"bottom"===n.vertical&&(f=l.outerHeight(),f-=f+e.DomUtils.getCSSLengthAsInt(l.css(n.vertical)),s.top-=f-2),o.css(s),"center"===n.horizontal&&"middle"!==n.vertical){var m=o.width(),y=Math.round((m/2-l.outerWidth()/2)/m*100);l.css({left:y+"%"})}else if("middle"===n.vertical){
var b=o.height(),E=Math.round((b/2-l.outerHeight()/2)/b*100);l.css({top:E+"%"})}}else o.css(s);if(e.PositionUtils.captureTransformOriginAnimationEffectsOption(o,n),t&&t(s,n),"focusLoss"===this.options.autoDismiss&&e.PositionUtils.isAligningPositionClipped(n)){this._ignoreRestoreFocus=!0;var S=i.getContext(this.element[0]).getBusyContext(),O={description:["ojPopup identified by '",this.element.attr("id"),"' is pending implicit closure."].join("")},C=S.addBusyState(O),A=window.setTimeout(this._resolveBusyStateAndCloseImplicitly.bind(this,C),0);this._closeDelayTimer=this._resolveBusyStateAndCancelDelayedClosure.bind(this,A,C)}}},_reposition:function(){var i=this.element,s=this._getPositionAsJqUi();if(e.StringUtils.isString(s.of)){var n=t(s.of);if(0===n.length)return!1;s.of=n}return i.position(s),!0},_intialFocus:function(e){var t=this._deriveInitialFocus();(e||"none"!==t)&&(this.GetFocusElement().focus(),this._trigger("focus"))},GetFocusElement:function(){var i=document.activeElement;if(i&&this._isFocusInPopup(i))return i;var s,n=this._deriveInitialFocus();if("none"===n&&(n="popup"),"firstFocusable"===n){for(var o=this._content.find(":focusable"),r=0;r<o.length;r++)if(e.FocusUtils.isFocusable(o[r])){s=t(o[r]);break}s||(n="popup")}if("popup"===n){var a=this._closeSkipLink;a?s=a.getLink():(s=this.element).attr("tabindex","-1")}return s[0]},_deriveInitialFocus:function(){var t=this.options,i=t.initialFocus;return"auto"===i&&(i="modal"===t.modality?e.DomUtils.isTouchSupported()?"popup":"firstFocusable":"none"),i},_isFocusInPopup:function(t,i){if(t||(t=document.activeElement),!t)return!1;var s=this.element;return i&&(s=s.parent()),e.DomUtils.isAncestorOrSelf(s[0],t)},_isFocusInLauncher:function(t){t||(t=document.activeElement);var i=this._launcher;return e.DomUtils.isAncestorOrSelf(i[0],t)},_restoreFocus:function(){this._ignoreRestoreFocus?delete this._ignoreRestoreFocus:this._isFocusInPopup(null,!0)&&this._launcher.focus()},_keyHandler:function(e){if(!e.isDefaultPrevented()){var i=this._content,s=e.target;if(e.keyCode===t.ui.keyCode.ESCAPE&&(this._isFocusInPopup(s)||this._isFocusInLauncher(s)))e.preventDefault(),this.close();else if(117===e.keyCode)this._isFocusInPopup(s)?"modeless"===this.options.modality?(e.preventDefault(),this._launcher.focus()):this.close():this._isFocusInLauncher(s)&&(e.preventDefault(),this._intialFocus(!0));else if(e.keyCode===t.ui.keyCode.TAB&&this._isFocusInPopup(s)){var n=i.find(":tabbable");if(n.length>0){var o=n[0],r=n[n.length-1],a=this.element;o!==s&&a[0]!==s||!e.shiftKey?r!==s||e.shiftKey||(e.preventDefault(),r===o?(a.attr("tabindex","-1"),a.focus()):t(o).focus()):(e.preventDefault(),o===r&&o===s?(a.attr("tabindex","-1"),a.focus()):t(r).focus())}else e.preventDefault(),"modeless"===this.options.modality?this._launcher.focus():this.close()}}},_setAutoDismiss:function(t){var i=this._focusLossCallback,s=this._getPopupServiceEvents();if(i&&(delete s[e.PopupService.EVENT.POPUP_AUTODISMISS],delete this._focusLossCallback),"focusLoss"===t&&(i=this._dismissalHandler.bind(this),this._focusLossCallback=i,s[e.PopupService.EVENT.POPUP_AUTODISMISS]=i),e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var n=this.element,o={};o[e.PopupService.OPTION.POPUP]=n,o[e.PopupService.OPTION.EVENTS]=s,e.PopupService.getInstance().changeOptions(o)}},_dismissalHandler:function(t){if(e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN){var i=this._launcher,s=this.element.parent(),n=t.target,o=this._focusSkipLink;if(o){var r=o.getLink();if(r&&e.DomUtils.isAncestorOrSelf(r[0],n))return}if(!e.DomUtils.isAncestorOrSelf(i[0],n)&&!e.DomUtils.isAncestorOrSelf(s[0],n)){if(e.FocusUtils.isFocusable(n)){if("mousedown"===t.type||"touchstart"===t.type)return;this._ignoreRestoreFocus=!0}this.close()}}},_addDescribedBy:function(){var e=this._launcher,i=this.element.attr("id"),s=e.attr("aria-describedby"),n=s?s.split(/\s+/):[];n.push(i),s=t.trim(n.join(" ")),e.attr("aria-describedby",s)},_removeDescribedBy:function(){var e=this._launcher,i=this.element;if(e&&0!==e.length){var s=i.attr("id"),n=e.attr("aria-describedby"),o=n?n.split(/\s+/):[],r=t.inArray(s,o);-1!==r&&o.splice(r,1),(n=t.trim(o.join(" ")))?e.attr("aria-describedby",n):e.removeAttr("aria-describedby")}},_initVoiceOverAssist:function(){var t,i=e.AgentUtils.getAgentInfo().os===e.AgentUtils.OS.IOS||e.AgentUtils.getAgentInfo().os===e.AgentUtils.OS.ANDROID,s=this._liveRegion;s||(s=new e.PopupLiveRegion,this._liveRegion=s);var n=this._deriveInitialFocus();if(t=i?this.getTranslatedString("none"===n?"ariaLiveRegionInitialFocusNoneTouch":"ariaLiveRegionInitialFocusFirstFocusableTouch"):this.getTranslatedString("none"===n?"ariaLiveRegionInitialFocusNone":"ariaLiveRegionInitialFocusFirstFocusable"),s.announce(t),i){var o=this._getSubId("focusSkipLink"),r=this._launcher,a=this._intialFocus.bind(this,!0);t=this.getTranslatedString("ariaFocusSkipLink"),this._focusSkipLink=new e.PopupSkipLink(r,t,a,o);var l=this._content,u=this._getSubId("closeSkipLink");a=this._closeImplicitly.bind(this),t=this.getTranslatedString("ariaCloseSkipLink"),this._closeSkipLink=new e.PopupSkipLink(l,t,a,u)}},_destroyVoiceOverAssist:function(){this._liveRegion.destroy(),delete this._liveRegion;var e=this._focusSkipLink;e&&(e.destroy(),delete this._focusSkipLink);var t=this._closeSkipLink;t&&(t.destroy(),delete this._closeSkipLink)},_getSubId:function(t){var i=this.element.attr("id");return e.StringUtils.isEmptyOrUndefined(i)&&(i=this.uuid),[i,t].join("_")},_surrogateRemoveHandler:function(){var t=this.element;e.ZOrderUtils.getStatus(t)===e.ZOrderUtils.STATUS.OPEN&&t.remove()},_getPopupServiceEvents:function(){if(!this._popupServiceEvents){var t={};this._popupServiceEvents=t,t[e.PopupService.EVENT.POPUP_CLOSE]=this._closeImplicitly.bind(this),t[e.PopupService.EVENT.POPUP_REMOVE]=this._surrogateRemoveHandler.bind(this),t[e.PopupService.EVENT.POPUP_REFRESH]=this.refresh.bind(this),t[e.PopupService.EVENT.POPUP_BEFORE_OPEN]=this._beforeOpenHandler.bind(this),t[e.PopupService.EVENT.POPUP_AFTER_OPEN]=this._afterOpenHandler.bind(this),t[e.PopupService.EVENT.POPUP_BEFORE_CLOSE]=this._beforeCloseHandler.bind(this),t[e.PopupService.EVENT.POPUP_AFTER_CLOSE]=this._afterCloseHandler.bind(this)}return this._popupServiceEvents},_closeImplicitly:function(){this._ignoreBeforeCloseResultant=!0,this.close(),delete this._ignoreBeforeCloseResultant},_setWhenReady:function(t){var i=this._whenReadyMediator;i&&(i.destroy(),delete this._whenReadyMediator),["open","close"].indexOf(t)<0||(this._whenReadyMediator=new e.PopupWhenReadyMediator(this.element,t,"ojPopup",this._IsCustomElement()))},_isOperationPending:function(e,t){var i=this._whenReadyMediator;return!!i&&i.isOperationPending(this,e,e,t)},_setupFocus:function(e){var i=this;this._focusable({applyHighlight:!0,setupHandlers:function(s,n){i._on(e,{focus:function(e){s(t(e.currentTarget))},blur:function(e){n(t(e.currentTarget))}})}})},_NotifyDetached:function(){e.ZOrderUtils.getStatus(this.element)===e.ZOrderUtils.STATUS.OPEN&&this._closeImplicitly(),this._super()}}),n.setDefaultOptions({ojPopup:{modality:n.createDynamicPropertyGetter(function(){return(s.parseJSONFromFontFamily("oj-popup-option-defaults")||{}).modality}),animation:n.createDynamicPropertyGetter(function(){return(s.parseJSONFromFontFamily("oj-popup-option-defaults")||{}).animation})}}),l.extension._WIDGET_NAME="ojPopup",e.CustomElementBridge.register("oj-popup",{metadata:l})}),define("ojs/ojlabel",["ojs/ojcore","jquery","hammerjs","ojs/ojlogger","ojs/ojcontext","ojs/ojjquery-hammer","ojs/ojcomponentcore","ojs/ojpopup"],function(e,t,i,s,n){"use strict";var o={properties:{for:{type:"string"},help:{type:"object",value:{definition:null,source:null},properties:{definition:{type:"string"},source:{type:"string"}}},labelId:{type:"string"},showRequired:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{tooltipHelp:{type:"string"},tooltipRequired:{type:"string"}}}},methods:{refresh:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};e.__registerWidget("oj.ojLabel",t.oj.baseComponent,{version:"1.0.0",defaultElement:"<label>",widgetEventPrefix:"oj",options:{for:null,help:{definition:null,source:null},labelId:null,showRequired:!1,rootAttributes:null},_BUNDLE_KEY:{_TOOLTIP_HELP:"tooltipHelp",_TOOLTIP_REQUIRED:"tooltipRequired"},widget:function(){return this.uiLabel},refresh:function(){this._super(),this._refreshRequired(),this._refreshHelp(),this._addIdsToDom()},_InitOptions:function(e,t){this._super(e,t),this._isCustomElement=this._IsCustomElement(),this._checkRequiredOption()},_ComponentCreate:function(){this._super(),this._touchEatClickNamespace=this.eventNamespace+"TouchEatClick",this._touchEatContextMenuNamespace=this.eventNamespace+"TouchEatContextMenu",this._helpDefPopupNamespace=this.eventNamespace+"HelpDefPopup",this._bTouchSupported=e.DomUtils.isTouchSupported(),this._drawOnCreate()},_AfterCreate:function(){var e,t,i,o=this,r=this.options.for,a=this.options.showRequired;if(this.OuterWrapper&&(e=this.OuterWrapper.getAttribute("data-oj-input-id"),t=this.OuterWrapper.getAttribute("data-oj-set-id")),e?this.element[0].setAttribute("for",e):t&&(this._targetElement=document.getElementById(t),i=this._targetElement,this._needsHelpIcon()&&o._addHelpSpanIdOnTarget(o.helpSpanId,i),o.options.showRequired&&o._addRequiredDescribedByOnCustomFormElement(i)),r&&this._isCustomElement){var l=n.getContext(this.OuterWrapper).getBusyContext().addBusyState({description:"The oj-label id='"+this.OuterWrapper.id+"' is looking for its form component with id "+r});setTimeout(function(){if(o._targetElement=document.getElementById(r),o._targetElement){if(i=o._targetElement,o._needsHelpIcon()&&o._addHelpSpanIdOnTarget(o.helpSpanId,i),a&&o._addRequiredDescribedByOnCustomFormElement(i),!e)if(o._isElementCustomElement(i)){var t=o.OuterWrapper.id;o._addElementAttribute(i,t,"labelled-by")}else o.element[0].setAttribute("for",r)}else s.info("could not find an element with forOption "+r);l()},0)}else this._isCustomElement&&this.options.labelId&&(this._targetElement=this._getTargetElementFromLabelledAttr("aria-labelledby",this.options.labelId),(i=this._targetElement)&&this._needsHelpIcon()&&this._addHelpSpanIdOnTarget(this.helpSpanId,i))},_SaveAttributes:function(e){this._IsCustomElement()||(this._savedClasses=e.attr("class"))},_RestoreAttributes:function(){this._IsCustomElement()||(this._savedClasses?this.element.attr("class",this._savedClasses):this.element.removeAttr("class"))},_NotifyDetached:function(){this._superApply(arguments),this._handleCloseHelpDefPopup()},_NotifyHidden:function(){this._superApply(arguments),this._handleCloseHelpDefPopup()},_GetTranslationsSectionName:function(){return this._IsCustomElement(),"oj-ojLabel"},_WatchedAttributeChanged:function(e,t,i){switch(this._superApply(arguments),e){case"data-oj-input-id":this.element[0].setAttribute("for",i);break;case"data-oj-set-id":this._targetElement=document.getElementById(i);var s=this._targetElement,o=this._needsHelpIcon(),r=this.options.showRequired;if(o||r){var a=n.getContext(this.OuterWrapper).getBusyContext().addBusyState({description:"The oj-label is writing described-by on its target."}),l=this;setTimeout(function(){o&&l._addHelpSpanIdOnTarget(l.helpSpanId,s),l.options.showRequired&&l._addRequiredDescribedByOnCustomFormElement(s),a()},0)}}},_drawOnCreate:function(){var e,i=null;this.OuterWrapper?(this.uiLabel=t(this.OuterWrapper).append(this.element.wrap(this._createOjLabelGroupDom()).parent()),this.uiLabel.addClass("oj-label oj-component")):this.uiLabel=this.element.wrap(this._createRootDomElement()).closest(".oj-component"),this._addIdsToDom(),e=this.element[0].id,this.helpSpanId=e+"_helpIcon",this.requiredSpanId=e+"_requiredIcon",this._isCustomElement||this._moveLabelStyleClassesToRootDom(),this.options.showRequired&&this._createRequiredIconSpanDom(),this._needsHelpIcon()&&(i=this._createIconSpan(this.helpSpanId,!0),this._createHelp(i))},_addRequiredDescribedByOnCustomFormElement:function(e){e&&this._isElementCustomElementAriaRequiredUnsupported(e)&&this._addElementAttribute(e,this.requiredSpanId,"described-by")},_removeRequiredDescribedByOnCustomFormElement:function(e){e&&this._isElementCustomElementAriaRequiredUnsupported(e)&&this._removeElementAttribute(e,this.requiredSpanId,"described-by")},_addHelpSpanIdOnTarget:function(e,t){var i;i=this._getAriaAttributeForTarget(t),this._addElementAttribute(t,e,i)},_removeHelpSpanIdOnTarget:function(e,t){var i;i=this._getAriaAttributeForTarget(t),this._removeElementAttribute(t,e,i)},_getAriaAttributeForTarget:function(e){return this._isElementCustomElement(e)?"described-by":"group"===e.getAttribute("role")?"aria-labelledby":"aria-describedby"},_getTargetElementFromLabelledAttr:function(e,t){var i;return i="["+e+"~='"+t+"']",document.querySelector(i)},_isElementCustomElement:function(t){return e.Assert.assertDomElement(t),-1!==t.tagName.indexOf("-")},_isElementCustomElementAriaRequiredUnsupported:function(t){var i;e.Assert.assertDomElement(t);var s,n=["oj-radioset","oj-checkboxset"],o=n.length,r=!1;s=t.tagName.toLowerCase();for(var a=0;a<o&&!r;a++)i=n[a],0===s.indexOf(i)&&(r=!0);return r},_addElementAttribute:function(e,t,i){var s,n,o=e.getAttribute(i);-1===(n=o?o.split(/\s+/):[]).indexOf(t)&&n.push(t),s=n.join(" ").trim(),e.setAttribute(i,s)},_removeElementAttribute:function(e,t,i){var s,n,o,r=e.getAttribute(i);-1!==(n=(o=r?r.split(/\s+/):[]).indexOf(t))&&o.splice(n,1),(s=o.join(" ").trim())?e.setAttribute(i,s):e.setAttribute(i,"")},_createHelp:function(e){var i=this.options.help.definition,s=this.options.help.source,n=this._createHelpIconAnchorDomElement(i,s);t(e).prepend(n),this._attachHelpDefToIconAnchor(),this._focusable({element:n,applyHighlight:!0})},_createRequiredIconSpanDom:function(){this._createIconSpan(this.requiredSpanId,!1).appendChild(this._createRequiredIconDomElement())},_checkRequiredOption:function(){var e=this.options.showRequired;if("boolean"!=typeof e)throw new Error("Option 'showRequired' has invalid value set: "+e)},_addIdsToDom:function(){this._isCustomElement&&(this.OuterWrapper.id||t(this.OuterWrapper).uniqueId(),this._refreshLabelId()),null==this.element.attr("id")&&this.element.uniqueId()},_moveLabelStyleClassesToRootDom:function(){var e,t,i,s=this.element.attr("class");if(s){i=(e=s.split(/\s+/)).length;for(var n=0;n<i;n++)(t=e[n]).indexOf("-label")>0&&(this.uiLabel.addClass(t),this.element.removeClass(t))}},_createIconSpan:function(e,t){var i=document.createElement("span");return i.setAttribute("id",e),t?this.uiLabel.find(".oj-label-group").prepend(i):this.element.before(i),i},_createRootDomElement:function(){var e,t,i=this.options.rootAttributes,s="oj-label oj-component";return i&&(e=i.class),e&&(s=s+" "+e),(t=document.createElement("div")).className=s,t.appendChild(this._createOjLabelGroupDom()),t},_createOjLabelGroupDom:function(){var e;return(e=document.createElement("div")).className="oj-label-group",e},_createRequiredIconDomElement:function(){var e=this.getTranslatedString(this._BUNDLE_KEY._TOOLTIP_REQUIRED),t=document.createElement("span");return t.className="oj-label-required-icon oj-component-icon",t.setAttribute("role","img"),t.setAttribute("title",e),t.setAttribute("aria-label",e),t},_createHelpIconAnchorDomElement:function(t,i){var s;if((s=document.createElement("a")).setAttribute("tabindex","0"),s.setAttribute("target","_blank"),s.className="oj-label-help-icon-anchor oj-label-help-icon oj-component-icon oj-clickable-icon-nocontext",i)try{e.DomUtils.validateURL(i),s.setAttribute("href",i)}catch(e){throw new Error(e+". The source option ("+i+") is invalid.")}else s.setAttribute("role","img");return t?s.setAttribute("aria-label",t):s.setAttribute("aria-label",this.getTranslatedString(this._BUNDLE_KEY._TOOLTIP_HELP)),s},_attachHelpDefToIconAnchor:function(){var e,t,i,s=this;0!==(t=this.widget().find(".oj-label-help-icon-anchor")).length&&(this._bTouchSupported&&(this._eatClickOnHelpIconListener&&this.widget().off(this._touchEatClickNamespace),this._eatClickOnHelpIconListener=function(){return!1},t.on("contextmenu"+this._touchEatContextMenuNamespace,!1)),this._openPopupForHelpDefCallbackListener=function(n){null==e&&(e=s._createHelpDefPopupDiv(),i={my:"start bottom",at:"end top",collision:"flipcenter",of:t},e.ojPopup({position:i,modality:"modeless",animation:{open:null,close:null}})),s._handleOpenHelpDefPopup(n,e,t)},this._closePopupForHelpDefCallbackListener=function(){s._handleCloseHelpDefPopup()},this._addShowHelpDefinitionEventHandlers(t))},_createHelpDefPopupDiv:function(){var e,i,s,n;return n=this.options.help.definition||this.getTranslatedString(this._BUNDLE_KEY._TOOLTIP_HELP),this._helpDefPopupDivId?(s=t(document.getElementById(this._helpDefPopupDivId))).length&&s.find(".oj-help-popup-container").first().text(n):((i=document.createElement("div")).className="oj-help-popup",i.style.display="none",(s=t(i)).uniqueId(),this._helpDefPopupDivId=s.prop("id"),(e=document.createElement("div")).className="oj-help-popup-container",i.appendChild(e),t(e).text(n),document.getElementsByTagName("body")[0].appendChild(i)),s},_addShowHelpDefinitionEventHandlers:function(t){var s;t.on("focusin"+this._helpDefPopupNamespace+" mouseenter"+this._helpDefPopupNamespace,this._openPopupForHelpDefCallbackListener),t.on("mouseleave"+this._helpDefPopupNamespace,this._closePopupForHelpDefCallbackListener),this._bTouchSupported&&(this.options.help.source?(s={recognizers:[[i.Press,{time:e.DomUtils.PRESS_HOLD_THRESHOLD}]]},t.ojHammer(s),this._on(t,{press:this._openPopupForHelpDefCallbackListener})):(s={recognizers:[[i.Tap],[i.Press,{time:e.DomUtils.PRESS_HOLD_THRESHOLD}]]},t.ojHammer(s),this._on(t,{press:this._openPopupForHelpDefCallbackListener,tap:this._openPopupForHelpDefCallbackListener})))},_handleOpenHelpDefPopup:function(t,i,s){if(!i.ojPopup("isOpen"))if(this._bTouchSupported){if("press"===t.type){var n=this.widget();n.on("click"+this._touchEatClickNamespace,this._eatClickOnHelpIconListener);var o=this;i.on("ojclose",function(){n.off(o._touchEatClickNamespace)})}else i.off("ojclose");"press"!==t.type&&"tap"!==t.type&&(e.DomUtils.recentTouchStart()||"focusin"!==t.type&&"mouseenter"!==t.type)||i.ojPopup("open",s)}else i.ojPopup("open",s)},_handleCloseHelpDefPopup:function(){null!=this._helpDefPopupDivId&&t(document.getElementById(this._helpDefPopupDivId)).ojPopup("close")},_removeHelpDefIconEventListeners:function(e){this._bTouchSupported&&(this.widget().off(this._touchEatClickNamespace),e.off(this._touchEatContextMenuNamespace),this._eatClickOnHelpIconListener=null,this._eatContextMenuOnHelpIconListener=null,e.ojHammer("destroy")),e.off(this._helpDefPopupNamespace),this._openPopupForHelpDefCallbackListener=null,this._closePopupForHelpDefCallbackListener=null},_removeHelpDefPopup:function(){var e;null!=this._helpDefPopupDivId&&((e=t(document.getElementById(this._helpDefPopupDivId)))&&(e.ojPopup("destroy"),e.remove()),this._helpDefPopupDivId=null)},_needsHelpIcon:function(){var e,t,i=this.options,s=i.help.source;return(t=""!==s&&null!=s)||(t=""!==(e=i.help.definition)&&null!=e),t},_refreshHelp:function(){var e,t,i=this.helpSpanId,s=this._targetElement;1===(t=this.uiLabel.find(".oj-label-help-icon")).length&&(this._removeHelpDefIconEventListeners(t),this._removeHelpDefPopup(),t.remove()),e=document.getElementById(i),this._needsHelpIcon()?(null==e&&(e=this._createIconSpan(i,!0)),this._createHelp(e),this._isCustomElement&&this._addHelpSpanIdOnTarget(i,s)):null!==e&&(e.parentNode.removeChild(e),this._isCustomElement&&this._removeHelpSpanIdOnTarget(i,s))},_refreshRequired:function(){var e,t,i=this.requiredSpanId;e=document.getElementById(i),this.options.showRequired?e?(t=this.getTranslatedString(this._BUNDLE_KEY._TOOLTIP_REQUIRED),this.uiLabel.find(".oj-label-required-icon").attr("title",t)):(this._createRequiredIconSpanDom(),this._isCustomElement&&this._addRequiredDescribedByOnCustomFormElement(this._targetElement)):(null!==(e=document.getElementById(i))&&e.parentNode.removeChild(e),this._isCustomElement&&this._removeRequiredDescribedByOnCustomFormElement(this._targetElement))},_refreshFor:function(e,t){var i=this.element[0],s=this.OuterWrapper.id;if(e){i.removeAttribute("for"),this.OuterWrapper.removeAttribute("data-oj-input-id");var n=document.getElementById(e);if(n){var o=n.getAttribute("labelled-by");if(o)if(o===s)n.removeAttribute("labelled-by");else{var r=o.split(/\s+/).filter(function(e){return e!==s}).join(" ");n.setAttribute("labelled-by",r)}}}if(this._targetElement=document.getElementById(this.options.for),this._targetElement){var a=this._targetElement;this._isElementCustomElement(a)?(this._addElementAttribute(a,s,"labelled-by"),this._needsHelpIcon()&&this._addHelpSpanIdOnTarget(this.helpSpanId,a),this.options.showRequired&&this._addRequiredDescribedByOnCustomFormElement(a)):i.setAttribute("for",t)}},_refreshLabelId:function(){var e,t;(e=this.options.labelId)?this.element.attr("id",e):(t=this.uiLabel.attr("id"))&&this.element.attr("id",t+"|label")},_setOption:function(e,t){var i=this.options[e];switch(this._superApply(arguments),e){case"showRequired":this._refreshRequired();break;case"help":this._refreshHelp();break;case"for":this._isCustomElement&&this._refreshFor(i,t);break;case"labelId":this._refreshLabelId()}},getNodeBySubId:function(e){var t;return(t=this._super(e))||"oj-label-help-icon"===e.subId&&(t=this.widget().find(".oj-label-help-icon")[0]),t||null},getSubIdByNode:function(e){var t=null;return null!=e&&e===this.widget().find(".oj-label-help-icon")[0]&&(t={subId:"oj-label-help-icon"}),t||this._superApply(arguments)},_destroy:function(){var t=this.uiLabel.find(".oj-label-help-icon");return this._removeHelpDefIconEventListeners(t),this._removeHelpDefPopup(),this.helpSpanId=null,this.requiredSpanId=null,this._isCustomElement=null,e.DomUtils.unwrap(this.element,this.uiLabel),this._super()}}),o.extension._WIDGET_NAME="ojLabel",o.extension._INNER_ELEM="label",o.extension._GLOBAL_TRANSFER_ATTRS=["accesskey"],o.extension._WATCHED_ATTRS=["data-oj-input-id","data-oj-set-id"],e.CustomElementBridge.register("oj-label",{metadata:o})}),define("ojs/ojlabelledbyutils",["ojs/ojcore","jquery","ojs/ojlabel"],function(e,t){"use strict";var i={CUSTOM_LABEL_ELEMENT_ID:"|label",_updateLabelledBy:function(e,t,s,n){var o,r,a,l,u=i.CUSTOM_LABEL_ELEMENT_ID;if(this._IsCustomElement())if(!t&&s)for(r=s.split(/\s+/),l=0;l<r.length;l++)o=r[l],i._addAriaLabelledBy(n,o+u),i._addSetIdOnLabel(o,e.id);else if(t&&!s)for(r=t.split(/\s+/),l=0;l<r.length;l++)o=r[l],i._removeAriaLabelledBy(n,o+u),i._removeDescribedByWithPrefix(e,o+"|");else if(t&&s){for(r=s.split(/\s+/),a=t.split(/\s+/),l=0;l<a.length;l++)o=a[l],-1===s.indexOf(o)&&(i._removeAriaLabelledBy(n,o+u),i._removeDescribedByWithPrefix(e,o+"|"));for(l=0;l<r.length;l++)o=r[l],-1===t.indexOf(o)&&(i._addAriaLabelledBy(n,o+u),i._addSetIdOnLabel(o,e.id))}},_addAriaLabelledBy:function(e,t){e.each(function(){var e,i=this.getAttribute("aria-labelledby");e=i?i.split(/\s+/):[],-1===e.indexOf(t)&&e.push(t),null==(i=e.join(" ").trim())?this.removeAttribute("aria-labelledBy"):this.setAttribute("aria-labelledBy",i)})},_addSetIdOnLabel:function(e,t){var i=document.getElementById(e);i&&!i.getAttribute("data-oj-set-id")&&i.setAttribute("data-oj-set-id",t)},_removeAriaLabelledBy:function(e,t){var i;e.each(function(){var e,s;-1!==(e=(s=(i=this.getAttribute("aria-labelledby"))?i.split(/\s+/):[]).indexOf(t))&&s.splice(e,1),(i=s.join(" ").trim())?this.setAttribute("aria-labelledby",i):this.removeAttribute("aria-labelledby")})},_removeDescribedByWithPrefix:function(e,t){var i;(i=((i=e.getAttribute("described-by"))?i.split(/\s+/):[]).filter(function(e){return-1===e.indexOf(t)}).join(" ").trim())?e.setAttribute("described-by",i):e.removeAttribute("described-by")},_updateDescribedBy:function(e,t){var i,s,n,o;if(this._IsCustomElement())if(!e&&t)for(s=t.split(/\s+/),o=0;o<s.length;o++)i=s[o],this._addAriaDescribedBy(i);else if(e&&!t)for(s=e.split(/\s+/),o=0;o<s.length;o++)i=s[o],this._removeAriaDescribedBy(i);else if(e&&t){for(s=t.split(/\s+/),n=e.split(/\s+/),o=0;o<n.length;o++)i=n[o],-1===t.indexOf(i)&&this._removeAriaDescribedBy(i);for(o=0;o<s.length;o++)i=s[o],-1===e.indexOf(i)&&this._addAriaDescribedBy(i)}},_addAriaDescribedBy:function(e){this._GetContentElement().each(function(){var t,i=this.getAttribute("aria-describedby");t=i?i.split(/\s+/):[],-1===t.indexOf(e)&&t.push(e),null==(i=t.join(" ").trim())?this.removeAttribute("aria-describedby"):this.setAttribute("aria-describedby",i)})},_removeAriaDescribedBy:function(e){this._GetContentElement().each(function(){var t,i,s;-1!==(i=(s=(t=this.getAttribute("aria-describedby"))?t.split(/\s+/):[]).indexOf(e))&&s.splice(i,1),(t=s.join(" ").trim())?this.setAttribute("aria-describedby",t):this.removeAttribute("aria-describedby")})}};return i}),define("ojs/ojeditablevalue",["ojs/ojcore","jquery","hammerjs","ojs/ojtranslation","ojs/ojcontext","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojanimation","ojs/ojmessaging","ojs/ojvalidation-base","ojs/ojlogger","ojs/ojlabelledbyutils","ojs/ojjquery-hammer","promise","ojs/ojpopup","ojs/ojlabel"],function(e,t,i,s,n,o,r,a,l,u,c,p){"use strict";e.EditableValueUtils={},e.EditableValueUtils.validationContext={COMPONENT_CREATE:1,CONVERTER_OPTION_CHANGE:2,DISABLED_OPTION_CHANGE:3,READONLY_OPTION_CHANGE:4,REFRESH_METHOD:5,REQUIRED_OPTION_CHANGE:6,RESET_METHOD:7,USER_ACTION:8,VALIDATE_METHOD:9,VALIDATORS_OPTION_CHANGE:10,VALUE_OPTION_CHANGE:11},e.EditableValueUtils.validateMethodOptions={doValueChangeCheck:!1,validationContext:e.EditableValueUtils.validationContext.VALIDATE_METHOD},e.EditableValueUtils.converterOptionOptions={doValueChangeCheck:!1,doNotClearMessages:!0,validationContext:e.EditableValueUtils.validationContext.CONVERTER_OPTION_CHANGE},e.EditableValueUtils.disabledOptionOptions={doValueChangeCheck:!1,doNotClearMessages:!0,validationContext:e.EditableValueUtils.validationContext.DISABLED_OPTION_CHANGE},e.EditableValueUtils.requiredOptionOptions={doValueChangeCheck:!1,doNotClearMessages:!0,validationContext:e.EditableValueUtils.validationContext.REQUIRED_OPTION_CHANGE},e.EditableValueUtils.readOnlyOptionOptions={doValueChangeCheck:!1,doNotClearMessages:!0,validationContext:e.EditableValueUtils.validationContext.READONLY_OPTION_CHANGE},e.EditableValueUtils.refreshMethodOptions={doValueChangeCheck:!1,doNotClearMessages:!0,validationContext:e.EditableValueUtils.validationContext.REFRESH_METHOD},e.EditableValueUtils.validatorsOptionOptions={doValueChangeCheck:!1,doNotClearMessages:!0,validationContext:e.EditableValueUtils.validationContext.VALIDATORS_OPTION_CHANGE},e.EditableValueUtils.VALIDATE_VALUES={VALID:"valid",INVALID:"invalid"},e.EditableValueUtils.getAttributeValue=function(e,t){var i,s={};if(e&&t){var n=e[0];switch(t){case"disabled":i=n.hasAttribute("disabled")?!!n.disabled:void 0;break;case"pattern":i=n.pattern||void 0;break;case"placeholder":i=n.placeholder||void 0;break;case"readonly":i=n.hasAttribute("readonly")?!!n.readOnly:void 0;break;case"required":if(n.hasAttribute("required")){var o=n.required;i=void 0===o||!!o}else i=void 0;break;case"title":i=n.hasAttribute("title")?n.title:void 0;break;case"value":i=e.val()||void 0;break;case"min":case"max":default:i=n.getAttribute(t)||void 0}}return void 0!==i?(s.fromDom=!0,s.value=i):s.fromDom=!1,s},e.EditableValueUtils.initializeOptionsFromDom=function(t,i,s,n){for(var o={},r=0;r<t.length;r++){var a,l,u=t[r],c=u.attribute,p=u.option||c,h=u.coerceDomValue,d=u.validateOption,_=s.element,f=s.options[p];void 0===i[p]&&(f=s.options[p],(l=e.EditableValueUtils.getAttributeValue(_,c)).fromDom&&(a=l.value,h&&("boolean"==typeof h?a=e.EditableValueUtils.coerceDomValueForOption(p,a):"function"==typeof h&&(a=h.call(s,a))),o[p]=a));var g=p in o?o[p]:f;d&&"boolean"==typeof d&&e.EditableValueUtils.validateValueForOption(p,g)}null!=n&&n(o),s.option(o,{_context:{writeback:!0,internalSet:!0}})},e.EditableValueUtils.validateValueForOption=function(e,t){var i=!1;switch(e){case"required":null!==t&&"boolean"!=typeof t&&(i=!0);break;case"readOnly":case"disabled":null!==t&&"boolean"!=typeof t&&(i=!0)}if(i)throw new Error("Option '"+e+"' has invalid value set: "+t)},e.EditableValueUtils.coerceDomValueForOption=function(e,t){var i=t;switch(e){case"required":i=!!t}return i},e.EditableValueUtils.setPickerAttributes=function(e,t){if(e&&t){var i=t.class;if(i)for(var s=i.split(" "),n=0,o=s.length;n<o;++n)e[0].classList.add(s[n]);var r=t.style;if(r){var a=e[0],l=a.getAttribute("style");l?a.setAttribute("style",l+";"+r):a.setAttribute("style",r)}}},e.EditableValueUtils.hasNoLabelFlag=function(e){return e[0].hasAttribute("data-oj-no-labelledby")},e.EditableValueUtils._getOjLabelAriaLabelledBy=function(t,i){var s,n=e.EditableValueUtils._getCustomOjLabelElements(t);if(n){s="";for(var o=0;o<n.length;o++){var r=n[o],a=r.getAttribute("label-id");if(!a){var l=r.querySelector("label");l?a=l.getAttribute("id"):(r.setAttribute("label-id",i),a=i)}s+=a,o+1<n.length&&(s+=" ")}}return s},e.EditableValueUtils._getCustomOjLabelElements=function(e){var t=[];if(e)for(var i=e.split(/\s+/),s=0;s<i.length;s++){var n=i[s],o=document.getElementById(n);o?t.push(o):c.info("Cannot find oj-label with id "+o)}return t},e.EditableValueUtils._setInputId=function(t,i,s){if(i){e.EditableValueUtils.setSubIdForCustomLabelFor(t,i);var n=e.EditableValueUtils._getCustomOjLabelElements(s);if(n)for(var o=t.id,r=0;r<n.length;r++)n[r].setAttribute("data-oj-input-id",o)}},e.EditableValueUtils._labelledByChangedForInputComp=function(t,i){var s=e.EditableValueUtils._getCustomOjLabelElements(t);if(s)for(var n=0;n<s.length;n++)s[n].setAttribute("data-oj-input-id",i),this._IsRequired()&&this.options.translations.required&&(this._implicitReqValidator=null,this._getImplicitRequiredValidator())},e.EditableValueUtils.validate=function(){var e;if(e=this._SetValue(this._GetDisplayValue(),null,this._VALIDATE_METHOD_OPTIONS),this._IsCustomElement()){if(e instanceof Promise)return e.then(function(e){return Promise.resolve(e?"valid":"invalid")});e=Promise.resolve(e?"valid":"invalid")}return e},e.EditableValueUtils.setSubIdForCustomLabelFor=function(e,t){e.setAttribute("id",t+"|input")},e.EditableValueUtils._refreshRequired=function(e){var t,i,s,n=this._AriaRequiredUnsupported();this._refreshTheming("required",e),n||(i=this._GetContentElement(),(s=e)&&i?i[0].setAttribute("aria-required",s):i[0].removeAttribute("aria-required")),this._IsCustomElement()||(this.$label||this._createOjLabel(),this.$label&&(this.$label.ojLabel("option","showRequired",e),n&&(t=this._getAriaLabelledById(this.element))&&(e?this._addAriaDescribedBy(t+"_requiredIcon"):this._removeAriaDescribedBy(t+"_requiredIcon"))))},e.EditableValueUtils._AfterSetOptionRequired=function(t){this._refreshRequired(this._IsRequired()),this._runMixedValidationAfterSetOption(e.EditableValueUtils.requiredOptionOptions)},e.EditableValueUtils._AfterSetOptionValidators=function(){var t;this._ResetAllValidators(),this._hasInvalidMessagesShowing()&&(this._clearComponentMessages(),t=this._GetDisplayValue(),this._SetValue(t,null,e.EditableValueUtils.validatorsOptionOptions))},e.EditableValueUtils._AfterSetOptionAsyncValidators=function(){this._AfterSetOptionValidators()},e.EditableValueUtils._AfterSetOptionConverter=function(){this._converter=null,this._converterChangedCounter+=1;var e=this._GetConverter();if(e instanceof Promise){var t=this;this._setBusyStateAsyncConverterLoading();var i=this._converterChangedCounter;this._loadingConverter(e).then(function(){i===t._converterChangedCounter&&t._ResetConverter(),t._clearBusyStateAsyncConverterLoading()})}else this._ResetConverter()},e.EditableValueUtils._AfterCreateConverterCached=function(){this._HasPlaceholderSet()&&(this._SetPlaceholder(this.options.placeholder),this._customPlaceholderSet=!0),this._initComponentMessaging(this._MESSAGING_CONTENT_UPDATE_TYPE.ALL),this._Refresh("value",this.options.value,!1),
this.options.messagesShown.length>0&&this._setMessagesOption("messagesShown",this.options.messagesShown,null,!0)},e.EditableValueUtils._ResetConverter=function(){var t;this._getComponentMessaging().update(this._getMessagingContent(this._MESSAGING_CONTENT_UPDATE_TYPE.CONVERTER_HINT)),this._hasInvalidMessagesShowing()?(this._clearComponentMessages(),t=this._GetDisplayValue(),this._SetValue(t,null,e.EditableValueUtils.converterOptionOptions)):this._Refresh("converter",this.options.converter,!0)},e.EditableValueUtils._GetNormalizedValidatorsFromOption=function(){var t,i,s,n,o,r,a=!0,l=[];if(s=this.options.validators)for(t=0;t<s.length;t++)"object"==typeof(i=s[t])?(i.validate&&"function"==typeof i.validate||(a=!1),a||(r=i.type)&&"string"==typeof r&&((o=u.Validation.validatorFactory(r))?((n=e.CollectionUtils.copyInto({},i.options)||{}).converter=n.converter||this._GetConverter(),n.label=n.label||this._getLabelText(),i=o.createValidator(n)):c.error("Unable to locate a validatorFactory for the requested type: "+r)),l.push(i)):c.error("Unable to parse the validator provided:"+i);return l},e.EditableValueUtils._GetNormalizedAsyncValidatorsFromOption=function(){var e,t,i,s=[];for(i=this.options.asyncValidators,e=0;e<i.length;e++)"object"==typeof(t=i[e])?t.validate&&"function"==typeof t.validate&&s.push(t):c.error("Unable to parse the validator provided:"+t);return s},e.EditableValueUtils._GetConverter=function(){var e,t,i,s=this;if(!this._converter){if((e=this.options.converter)instanceof Promise?i=e:(t=u.IntlConverterUtils.getConverterInstance(e))instanceof Promise&&(i=t),i)return i.then(function(e){return s._converter=e,s._converter||null});this._converter=t}return this._converter||null},e.EditableValueUtils._SetBusyState=function(e){void 0===this._resolveBusyStateAsyncMap&&(this._resolveBusyStateAsyncMap=new Map);var t=this._resolveBusyStateAsyncMap.get(e);if(!t){var i=this.element[0],s=n.getContext(i).getBusyContext(),o="The page is waiting for async validators for displayValue "+e;i&&i.id&&(o+=' for "'+i.id+'" '),o+="to finish.",t=s.addBusyState({description:o}),this._resolveBusyStateAsyncMap.set(e,t)}},e.EditableValueUtils._ClearBusyState=function(e){var t;void 0!==this._resolveBusyStateAsyncMap&&(t=this._resolveBusyStateAsyncMap.get(e))&&(t(),this._resolveBusyStateAsyncMap.delete(e))},e.EditableValueUtils._SetBusyStateAsyncValidatorHint=function(e){void 0===this._resolveBusyStateAsyncValidatorHintMap&&(this._resolveBusyStateAsyncValidatorHintMap=new Map);var t=this._resolveBusyStateAsyncValidatorHintMap.get(e);if(!t){var i=this.element[0],s=n.getContext(i).getBusyContext(),o="The page is waiting for async validator hint for counter "+e;i&&i.id&&(o+=' for "'+i.id+'" '),o+="to finish.",t=s.addBusyState({description:o}),this._resolveBusyStateAsyncValidatorHintMap.set(e,t)}},e.EditableValueUtils._ClearBusyStateAsyncValidatorHint=function(e){var t;void 0!==this._resolveBusyStateAsyncValidatorHintMap&&(t=this._resolveBusyStateAsyncValidatorHintMap.get(e))&&(t(),this._resolveBusyStateAsyncValidatorHintMap.delete(e))},e.EditableValueUtils._SetBusyStateAsyncConverterLoading=function(){if(!this._resolveBusyStateAsyncConverterLoading){var e=this.element[0],t=n.getContext(e).getBusyContext(),i="The page is waiting for async converter loading ";e&&e.id&&(i+='for "'+e.id+'" '),i+="to finish.",this._resolveBusyStateAsyncConverterLoading=t.addBusyState({description:i})}},e.EditableValueUtils._ClearBusyStateAsyncConverterLoading=function(){void 0!==this._resolveBusyStateAsyncConverterLoading&&(this._resolveBusyStateAsyncConverterLoading(),delete this._resolveBusyStateAsyncConverterLoading)},e.EditableValueUtils._getShowLoadingDelay=function(){null==this._defaultOptions&&(this._defaultOptions=o.parseJSONFromFontFamily("oj-form-control-option-defaults"));var e=parseInt(this._defaultOptions.showIndicatorDelay,10);return isNaN(e)?0:e},e.EditableValueUtils._SetInputType=function(t){var i="text",s=e.AgentUtils.getAgentInfo();if(s.os===e.AgentUtils.OS.ANDROID||s.os===e.AgentUtils.OS.IOS||s.os===e.AgentUtils.OS.WINDOWSPHONE)if(t.indexOf(this.options.virtualKeyboard)>=0)i=this.options.virtualKeyboard;else{var n=this._GetConverter();if(n&&n.resolvedOptions){var o=n.resolvedOptions();t.indexOf(o.virtualKeyboardHint)>=0&&(i=o.virtualKeyboardHint)}}null==i?this.element[0].removeAttribute("type"):this.element[0].setAttribute("type",i)};var h="invalidShown";e.__registerWidget("oj.editableValue",t.oj.baseComponent,{widgetEventPrefix:"oj",options:{describedBy:null,disabled:!1,displayOptions:{},help:void 0,helpHints:{definition:"",source:""},labelHint:"",messagesCustom:[],messagesHidden:void 0,messagesShown:void 0,title:"",valid:void 0,value:void 0,animateStart:null,animateEnd:null},getNodeBySubId:function(e){var t;if(!(t=this._super(e))&&!this._IsCustomElement()&&"oj-label-help-icon"===e.subId){var i=this._GetLabelElement();i&&(t=i.parent().find(".oj-label-help-icon"))}return t||null},getSubIdByNode:function(e){var i,s,n,o=null;return null!=e&&null!=(i=t(e).closest("a.oj-label-help-icon"))&&null!=(s=i.closest(".oj-label"))&&(n=s.find("label")[0])&&n===this._GetLabelElement()[0]&&(o={subId:"oj-label-help-icon"}),o},isValid:function(){return void 0===this._valid&&(this._valid=!this._hasInvalidMessages()),this._valid},refresh:function(){this._super(),this._doRefresh()},reset:function(){this._clearAllMessages(),this._runDeferredValidation(this._VALIDATION_CONTEXT.RESET_METHOD),this._refreshComponentDisplayValue(this.options.value,!0)},showMessages:function(){var t,i,s,n=[],o=this.options.messagesHidden,r=o.length>0;for(t=0;t<o.length;t++)(i=o[t])instanceof e.ComponentMessage?(i._forceDisplayToShown(),s=i.clone()):s=new l(i.summary,i.detail,i.severity),n.push(s);r&&(this._clearMessages("messagesHidden"),this._updateMessagesOption("messagesShown",n),this._setValidOption(h,null))},_VALIDATION_MODE:{FULL:1,VALIDATORS_ONLY:2,REQUIRED_VALIDATOR_ONLY:3},_VALIDATION_CONTEXT:e.EditableValueUtils.validationContext,_VALIDATE_METHOD_OPTIONS:e.EditableValueUtils.validateMethodOptions,_InitOptions:function(e,t){this._super(e,t)},_ComponentCreate:function(){var e=this.element,t=this._GetSavedAttributes(e);if(this._super(),this.options.messagesCustom=this.options.messagesCustom||[],this.options.messagesHidden=[],this.options.messagesShown=this.options.messagesCustom.length>0?this._cloneMessagesBeforeSet(this.options.messagesCustom):[],this._SetDisabledDom(e),t&&!this._IsCustomElement()){var i=e[0].tagName.toLowerCase();"input"!==i&&"textarea"!==i||["required","title","pattern"].forEach(function(i){i in t&&e.removeAttr(i)})}},_AfterCreate:function(){var t,i,s=this;if(this._super(),this._refreshTheming("disabled",this.options.disabled),this.widget()[0].classList.add("oj-form-control"),this.widget().uniqueId(),this._IsCustomElement()){if(this.options.labelledBy){var n=e.EditableValueUtils._getCustomOjLabelElements(this.options.labelledBy);if(n)for(i=0;i<n.length;i++)n[i].classList.add(this._GetDefaultStyleClass()+"-label")}}else this._createOjLabel();if(t=this.options.describedBy){var o=t.split(/\s+/);for(i=0;i<o.length;i++)this._addAriaDescribedBy(o[i])}this._runDeferredValidation(this._VALIDATION_CONTEXT.COMPONENT_CREATE);var r=this._GetConverter();r instanceof Promise?(this._setBusyStateAsyncConverterLoading(),this._converterChangedCounter=0,this._loadingConverter(r).then(function(){s._AfterCreateConverterCached(),s._clearBusyStateAsyncConverterLoading()})):(this._AfterCreateConverterCached(),this._setValidOption(this._determineValidFromMessagesOptions(),null))},_SaveAttributes:function(e){this._IsCustomElement()||this._SaveAllAttributes(e)},_RestoreAttributes:function(e){this._IsCustomElement()||this._RestoreAllAttributes(e)},_AfterSetOption:function(t,i){switch(t){case"disabled":this._AfterSetOptionDisabledReadOnly(t,e.EditableValueUtils.disabledOptionOptions);break;case"displayOptions":this._initComponentMessaging();break;case"help":this._IsCustomElement()?this._getComponentMessaging().update(this._getMessagingContent(this._MESSAGING_CONTENT_UPDATE_TYPE.TITLE)):this._Refresh(t,this.options[t]);break;case"messagesCustom":this._messagesCustomOptionChanged(i),this._setValidOption(this._determineValidFromMessagesOptions(),null);break;case"placeholder":this._placeholderOptionChanged(i);break;case"title":this._IsCustomElement()||this._getComponentMessaging().update(this._getMessagingContent(this._MESSAGING_CONTENT_UPDATE_TYPE.TITLE));break;case"translations":this.refresh();break;case"value":this._AfterSetOptionValue(t,i)}},_AfterSetOptionDisabledReadOnly:function(e,t){var i=!this.options[e];this._Refresh(e,this.options[e]),i&&this._runMixedValidationAfterSetOption(t)},_AfterSetOptionValue:function(e,t){var i,s=t?t._context:null,n=!1;s&&(n=!!s.originalEvent,i=s.doNotClearMessages||!1),n||(i||this._clearAllMessages(null),this._runDeferredValidation(this._VALIDATION_CONTEXT.VALUE_OPTION_CHANGE)),this._Refresh(e,this.options[e],!0)},_CanSetValue:function(){return!this.options.disabled},_destroy:function(){var e,i,s=this._super();if(this._clearAllMessages(null,!0),this._getComponentMessaging().deactivate(),this.widget().removeUniqueId(),this.$label)for(i=this.$label.length,e=0;e<i;e++)this.$label[e]&&null!=r.__GetWidgetConstructor(this.$label[e])&&t(this.$label[e]).ojLabel("destroy");return s},GetFocusElement:function(){return this._GetContentElement()[0]},_setOption:function(t,i,s){var n,o,r,a,l=!1;switch(t){case"messagesHidden":case"messagesShown":case"rawValue":l=!0;break;case"describedBy":o=this.options.describedBy,r=i,this._updateDescribedBy(o,r);break;case"labelledBy":if(i){var u=e.EditableValueUtils._getCustomOjLabelElements(i);if(u)for(a=0;a<u.length;a++)u[a].classList.add(this._GetDefaultStyleClass()+"-label")}}return l?(c.error(t+" option cannot be set"),this):(n=this._superApply(arguments),this._AfterSetOption(t,s),n)},_GetContentElement:function(){return this.element},_GetLabelElement:function(){var i;if(this.$label)return this.$label;if(e.EditableValueUtils.hasNoLabelFlag(this.widget()))return null;var s=this._getAriaLabelledByElement(this.element);if(null!==s&&0!==s.length)return s;var n=this.element[0].id;return void 0!==n&&0!==(s=t("label[for='"+n+"']")).length?s:0!==(i=this.element.closest("[aria-labelledby]")).length&&null!==(s=this._getAriaLabelledByElement(i))&&0!==s.length?s:null},_GetElementValue:function(){return this.element.val()},_GetMessagingLauncherElement:function(){return this._GetContentElement()},_GetConverter:function(){return null},_GetImplicitSyncValidators:function(){return this._implicitSyncValidators||(this._implicitSyncValidators={}),this._implicitSyncValidators},_GetImplicitAsyncValidators:function(){return this._implicitAsyncValidators||(this._implicitAsyncValidators={}),this._implicitAsyncValidators},_GetDisplayValue:function(e){return this._GetContentElement().val()},_GetNormalizedValidatorsFromOption:function(){return[]},_GetNormalizedAsyncValidatorsFromOption:function(){return[]},_GetAllSyncValidators:function(){var e,t,i,s,n;if(!this._allValidators){e=[],i=this._GetImplicitSyncValidators(),s=[];var o,r=Object.keys(i),a=r.length;if(a>0){for(t=0;t<a;t++)o=r[t],s.push(i[o]);e=e.concat(s)}(n=this._GetNormalizedValidatorsFromOption()).length>0&&(e=e.concat(n)),this._allValidators=e}return this._allValidators||[]},_ResetAllValidators:function(){this._allValidators&&(this._allValidators.length=0),this._allValidators=null,this._allAsyncValidators&&(this._allAsyncValidators.length=0),this._allAsyncValidators=null,this._IsCustomElement()?this._updateValidatorMessagingHint():this._getComponentMessaging().update(this._getMessagingContent(this._MESSAGING_CONTENT_UPDATE_TYPE.VALIDATOR_HINTS))},_getAllAsyncValidators:function(){var e,t,i,s,n;if(!this._allAsyncValidators){e=[],t=this._GetImplicitAsyncValidators(),i=[];var o,r=Object.keys(t),a=r.length;if(a>0){for(s=0;s<a;s++)o=r[s],i.push(t[o]);e=e.concat(i)}(n=this._GetNormalizedAsyncValidatorsFromOption()).length>0&&(e=e.concat(n)),this._allAsyncValidators=e}return this._allAsyncValidators||[]},_getAllAsyncValidatorsWithHint:function(){var e,t,i=this._getAllAsyncValidators(),s=[];if(i.length>0)for(e=0;e<i.length;e++)"hint"in(t=i[e])&&s.push(t);return s},_initAsyncValidatorMessagingHint:function(){var e,t,i=this._getAllAsyncValidatorsWithHint(),s=this;this._asyncValidatorHintCounter=0,i.length>0&&(t=s._getMessagingContent(s._MESSAGING_CONTENT_UPDATE_TYPE.VALIDATOR_HINTS),e=this._asyncValidatorHintCounter,this._setBusyStateAsyncValidatorHint(e),this._addAsyncValidatorsHintsMessagingContent(i,t).then(function(){s._clearBusyStateAsyncValidatorHint(e)}))},_updateValidatorMessagingHint:function(){var e,t=this._getAllAsyncValidatorsWithHint(),i=this._getComponentMessaging(),s=this,n=this._getMessagingContent(this._MESSAGING_CONTENT_UPDATE_TYPE.VALIDATOR_HINTS);t.length>0?(this._asyncValidatorHintCounter+=1,e=this._asyncValidatorHintCounter,this._setBusyStateAsyncValidatorHint(e),this._addAsyncValidatorsHintsMessagingContent(t,n).then(function(){s._clearBusyStateAsyncValidatorHint(e)})):i.update(n)},_addAsyncValidatorsHintsMessagingContent:function(e,t){function i(e){return e.then(function(e){var i,s={};return a._asyncValidatorHintCounter===n?(null!==e&&(r.push(e),s.validatorHint=t.validatorHint.concat(r),o.update(s)),i="resolved"):i="ignore",{v:e,status:i}},function(e){return{e:e,status:"rejected"}})}var s,n=this._asyncValidatorHintCounter,o=this._getComponentMessaging(),r=[],a=this,l=[];for(s=0;s<e.length;s++)l.push(e[s].hint);return new Promise(function(e){Promise.all(l.map(i)).then(function(){e(r)})})},_IsRequired:function(){return!1},_HandleChangeEvent:function(e){var t=this._GetDisplayValue();this._SetValue(t,e)},_SetRawValue:function(e,t){var i={};i._context={originalEvent:t,writeback:!0,internalSet:!0,readOnly:!0},this._CompareOptionValues("rawValue",this.options.rawValue,e)||this.option("rawValue",e,i)},_Refresh:function(e,t,i){var s,n;switch(e){case"converter":var o=this.options.value;this._refreshComponentDisplayValue(o,i);break;case"disabled":this._refreshTheming("disabled",this.options.disabled);break;case"help":this._IsCustomElement()||this.$label&&(s=this.options.help.definition,n=this.options.help.source,this.$label.ojLabel("option","help",{definition:s,source:n}),this._refreshDescribedByForLabel());break;case"value":this._refreshComponentDisplayValue(t,i)}},_NotifyHidden:function(){this._superApply(arguments),this._getComponentMessaging().close()},_NotifyDetached:function(){this._superApply(arguments),this._getComponentMessaging().close()},_ResetComponentState:function(){this.$label&&this.$label.ojLabel("refresh"),this._implicitReqValidator=null,this._converter=null,this._ResetAllValidators()},_SetDisplayValue:function(e){var t=this._GetContentElement();t.val()!==e&&t.val(e)},_SetDisabledDom:function(e){"boolean"==typeof this.options.disabled&&(e[0].disabled=this.options.disabled)},_SetPlaceholder:function(e){var t=this._GetContentElement()[0];t&&(null==e?t.removeAttribute("placeholder"):t.setAttribute("placeholder",e))},_SetPlaceholderOption:function(e){this.options.placeholder=e},_HasPlaceholderSet:function(){return this.options.placeholder},_ClearPlaceholder:function(){this._SetPlaceholderOption(""),this._SetPlaceholder("")},_SetValue:function(e,t,i){var s,n,o,r=!i||"boolean"!=typeof i.doValueChangeCheck||i.doValueChangeCheck,a=this,l=!1;return void 0===e?(c.warn("Attempt to set a value of undefined"),!1):(r&&e===a._getLastDisplayValue()?c.level>c.LEVEL_WARN&&c.info((e.toString,e.toString())):(s=e+"_"+(this._asyncValidatorValidateCounter+1),(n=this._AsyncValidate(e,t,i,s))instanceof Promise?l=n.then(function(e){return o=e,a._afterAsyncValidateUpdateValue(e,t,i)}).then(function(){return a._clearBusyState(s),void 0!==o}):(this._afterAsyncValidateUpdateValue(n,t,i),l=void 0!==n)),l)},_ParseValueShowErrors:function(e,t){var i;this._clearAllMessages(t);try{return this._parseValue(e,t)}catch(e){i=this._processValidationErrors(e),this._updateMessagesOption("messagesShown",i,t),this._setValidOption(h,t)}},_AsyncValidate:function(e,t,i,s){var n,o,r,a=i&&i.validationMode?i.validationMode:this._VALIDATION_MODE.FULL,l=i&&i.validationContext?i.validationContext:this._VALIDATION_CONTEXT.USER_ACTION,u=i&&i.doNotClearMessages||!1;if(void 0!==e){if(this._CanSetValue()){u||this._clearAllMessages(t);try{return this._asyncValidatorValidateCounter+=1,a===this._VALIDATION_MODE.FULL?(this._setLastDisplayValue(e),o=this._parseValue(e,t,!0)):o=e,(r=this._asyncValidateValue(o,t,l))instanceof Promise?(this._setBusyState(s),r.then(function(e){if("valid"===e)return o})):r}catch(e){n=this._processValidationErrors(e,l),this._updateMessagesOption("messagesShown",n,t),this._setValidOption(h,t)}}else c.level>c.LEVEL_WARN&&c.info("Validation skipped and value option not set as component state does not  allow setting value. For example if the component is readonly or disabled.");return r}c.warn("Attempt to set a value of undefined")},_afterAsyncValidateUpdateValue:function(e,t,i){var s,n=!1;return void 0!==e&&(i&&!0===i.doNotClearMessages?this.isValid()||!this._hasInvalidComponentMessagesShowing():this.isValid())&&(i&&i._context&&(s=i._context),this._updateValueOption(e,t,i&&i.validationContext,s,i),n=!0),n},_CompareOptionValues:function(t,i,s){return"value"===t||"rawValue"===t?e.Object.compareValues(i,s):0===t.indexOf("messages")?this._messagesEquals(i,s):this._superApply(arguments)},_GetDefaultStyleClass:function(){return e.Assert.failedInAbstractFunction(),""},_MESSAGING_CONTENT_UPDATE_TYPE:{ALL:1,VALIDITY_STATE:2,CONVERTER_HINT:3,VALIDATOR_HINTS:4,TITLE:5},_OPTION_TO_CSS_MAPPING:{disabled:"oj-disabled",required:"oj-required"},_clearAllMessages:function(e,t){t?(this.options.messagesHidden=[],this.options.messagesShown=[],this.options.messagesCustom=[]):(this._clearMessages("messagesHidden",e),this._clearMessages("messagesShown",e),this._clearMessages("messagesCustom",e))},_clearComponentMessages:function(){var t,i=this.options.messagesShown;t=i.length,this._clearMessages("messagesHidden");for(var s=t-1;s>=0;s--)i[s]instanceof e.ComponentMessage&&i.splice(s,1);i.length!==t&&this._setMessagesOption("messagesShown",i,null,!0)},_setMessagesOption:function(e,t,i,s){var n={},o=0===t.length&&0===this.options[e].length;!s&&o||(n._context={originalEvent:i,writeback:!0,internalSet:!0},"messagesCustom"!==e&&(n._context.readOnly=!0),n.changed=s||!o,this._resetValid(),this.option(e,t,n),this._updateMessagingContent())},_setValidOption:function(e,t){var i={};"pending"===e&&"valid"!==this._determineValidFromMessagesOptions()||(i._context={originalEvent:t,writeback:!0,internalSet:!0,readOnly:!0},this.option("valid",e,i))},_clearMessages:function(e,t){this._setMessagesOption(e,[],t)},_cloneMessagesBeforeSet:function(e){var t,i,s,n=[];if(e&&e.length>0)for(t=0;t<e.length;t++)s=e[t],i=new l(s.summary,s.detail,s.severity),i=Object.freeze?Object.freeze(i):i,n.push(i);return n},_createOjLabel:function(){var e,t;this._IsCustomElement()||(this.$label=this._GetLabelElement(),this.$label&&(e=this.options.help.definition,t=this.options.help.source,this.$label.ojLabel({rootAttributes:{class:this._GetDefaultStyleClass()+"-label"},help:{definition:e,source:t}}),this._createDescribedByForLabel()))},_createDescribedByForLabel:function(){var e,t=this.options.help.definition;if(null!=this.options.help.source||null!=t){var i=this.$label[0];i&&(e=i.id),e&&this._addAriaDescribedBy(e+"_helpIcon")}},_refreshDescribedByForLabel:function(){var e,t=this.options.help.definition,i=this.options.help.source,s=this.$label[0];s&&(e=s.id),e&&(null!=i||null!=t?this._addAriaDescribedBy(e+"_helpIcon"):this._removeAriaDescribedBy(e+"_helpIcon"))},_doRefresh:function(){var t,i=!1;this._ResetComponentState(),this._initComponentMessaging(),this._Refresh("disabled",this.options.disabled),this._hasInvalidMessagesShowing()&&(i=!0),this._clearComponentMessages(),i?(t=this._GetDisplayValue(),this._SetValue(t,null,e.EditableValueUtils.refreshMethodOptions)):(this._IsRequired()&&this._runDeferredValidation(e.EditableValueUtils.refreshMethodOptions.validationContext),this._Refresh("value",this.options.value,!0))},_getLastModelValue:function(){return this._oj_lastModelValue},_getLastDisplayValue:function(){return void 0===this._oj_lastElementValue&&(this._oj_lastElementValue=""),this._oj_lastElementValue},_getAriaLabelledByElement:function(e){var i=e[0].getAttribute("aria-labelledby");return void 0!==i?t("label[id='"+i+"']"):null},_getAriaLabelledById:function(e){var t=null,i=this._getAriaLabelledByElement(e);return null!==i&&0!==i.length&&(t=i[0].getAttribute("id")),t},_getMessages:function(){return this.options.messagesShown.concat(this.options.messagesHidden)},_getLabelText:function(){if(this.$label)return this.$label[0].textContent;var t=e.EditableValueUtils._getCustomOjLabelElements(this.options.labelledBy),i=null;if(t)for(var s=0;s<t.length;s++)s>0&&(i+=" "),i=t[s].textContent;return i},_getValidityState:function(){return this._validityState?this._validityState:(this._validityState=new e.ComponentValidity(this.isValid(),this._getMessages()),this._validityState)},_hasInvalidMessages:function(){return!l.isValid(this._getMessages())},_hasInvalidMessagesShowing:function(){return!this.isValid()&&this.options.messagesShown.length>0},_hasInvalidComponentMessagesShowing:function(){for(var t,i,s=this.options.messagesShown,n=0;n<s.length;n++)(i=s[n])instanceof e.ComponentMessage&&i._isMessageAddedByComponent()&&(t=t||[]).push(i);return void 0!==t&&!l.isValid(t)},_initComponentMessaging:function(){var e=this._getComponentMessaging(),t=this._GetMessagingLauncherElement(),i=this._GetContentElement(),s=this._getMessagingContent(this._MESSAGING_CONTENT_UPDATE_TYPE.ALL);this._customPlaceholderSet||this._ClearPlaceholder(),e.activate(t,i,s),this._IsCustomElement()&&(this._initAsyncValidatorMessagingHint(),this._asyncValidatorValidateCounter=0)},_messagesCustomOptionChanged:function(t){var i,s,n=t?t._context:null,o=this.options.messagesCustom,r=this.options.messagesShown,a=[];for(i=0;i<r.length;i++)(s=r[i])instanceof e.ComponentMessage&&s._isMessageAddedByComponent()&&a.push(s);for(i=0;i<o.length;i++)a.push(o[i]);this._setMessagesOption("messagesShown",a,n?n.originalEvent:null,t&&t.changed)},_placeholderOptionChanged:function(e){var t=!(e&&e._context||{}).internalMessagingSet,i=this.options.placeholder;this._SetPlaceholder(i),t?(this._customPlaceholderSet=!0,this._GetConverter()&&this._initComponentMessaging()):this._customPlaceholderSet=!1},_setLastModelValue:function(e){this._oj_lastModelValue=e},_setLastDisplayValue:function(e){this._oj_lastElementValue=e},_updateMessagesOption:function(e,t,i){var s,n,o;if("object"==typeof t&&Array.isArray(t))for(o=this.options[e],n=t.length,s=0;s<n;s++)o.push(t[s]);this._setMessagesOption(e,o,i,!0)},_updateMessagingContent:function(){this._getComponentMessaging().update(this._getMessagingContent(this._MESSAGING_CONTENT_UPDATE_TYPE.VALIDITY_STATE))},_updateValueOption:function(e,t,i,s,n){var o,r,a=s||{};switch(t&&(a.originalEvent=t),i){case this._VALIDATION_CONTEXT.CONVERTER_OPTION_CHANGE:case this._VALIDATION_CONTEXT.DISABLED_OPTION_CHANGE:case this._VALIDATION_CONTEXT.READONLY_OPTION_CHANGE:case this._VALIDATION_CONTEXT.REFRESH_METHOD:case this._VALIDATION_CONTEXT.REQUIRED_OPTION_CHANGE:case this._VALIDATION_CONTEXT.VALIDATE_METHOD:case this._VALIDATION_CONTEXT.VALIDATORS_OPTION_CHANGE:a.writeback=!0,a.doNotClearMessages=!0}if(a.internalSet=!0,n&&n.targetOptions){o={},r=!1;for(var l=0;l<n.targetOptions.length;l++)o[n.targetOptions[l]]=e,r=r||"value"===n.targetOptions[l]}else o={value:e},r=!0;this.option(o,{_context:a}),r&&this._AfterSetOptionValue("value",{_context:a})},_resetValid:function(){this._valid=void 0},_determineValidFromMessagesOptions:function(){var e=this.options.messagesHidden,t=this.options.messagesShown,i="valid";return t&&0!==t.length&&!l.isValid(t)?i=h:e&&0!==e.length&&!l.isValid(e)&&(i="invalidHidden"),i},_formatValue:function(e){var t=e,i=this._GetConverter();return i&&"object"==typeof i&&(i.format&&"function"==typeof i.format?t=i.format(e):c.level>c.LEVEL_WARN&&c.info("converter does not support the format method.")),t},_getComponentMessaging:function(){return this._componentMessaging||(this._componentMessaging=new e.ComponentMessaging(this)),this._componentMessaging},_getHintsForAllValidators:function(e){var t,i,s=[],n="";for(this._IsRequired()&&(i=this._getImplicitRequiredValidator()).getHint&&"function"==typeof i.getHint&&(n=i.getHint())&&s.push(n),t=0;t<e.length;t++)n="","object"==typeof(i=e[t])&&i.getHint&&"function"==typeof i.getHint&&(n=i.getHint())&&s.push(n);return s},_getImplicitRequiredValidator:function(){var t,i,s={};return null==this._implicitReqValidator&&(i={hint:(s=this.options.translations&&this.options.translations.required||{}).hint||null,label:this._getLabelText(),messageSummary:s.messageSummary||null,messageDetail:s.messageDetail||null},t=u.Validation.validatorFactory(e.ValidatorFactory.VALIDATOR_TYPE_REQUIRED),this._implicitReqValidator=t?t.createValidator(i):null),this._implicitReqValidator},_getMessagingContent:function(e){var t,i,s,n={},o="",r=[];if((e=e||this._MESSAGING_CONTENT_UPDATE_TYPE.VALIDITY_STATE)!==this._MESSAGING_CONTENT_UPDATE_TYPE.ALL&&e!==this._MESSAGING_CONTENT_UPDATE_TYPE.VALIDITY_STATE||(s=this._getMessages(),this._getValidityState().update(this.isValid(),s),n.validityState=this._getValidityState()),e!==this._MESSAGING_CONTENT_UPDATE_TYPE.ALL&&e!==this._MESSAGING_CONTENT_UPDATE_TYPE.CONVERTER_HINT||((i=this._GetConverter())&&"object"==typeof i&&i.getHint&&"function"==typeof i.getHint&&(o=i.getHint()||""),n.converterHint=o),e!==this._MESSAGING_CONTENT_UPDATE_TYPE.ALL&&e!==this._MESSAGING_CONTENT_UPDATE_TYPE.VALIDATOR_HINTS||(t=this._GetAllSyncValidators(),r=this._getHintsForAllValidators(t)||[],n.validatorHint=r),e===this._MESSAGING_CONTENT_UPDATE_TYPE.ALL||e===this._MESSAGING_CONTENT_UPDATE_TYPE.TITLE){var a;if(this._IsCustomElement()){var l=this.options.help;null!=l&&(a=l.instruction)}else a=this.options.title;n.title=a||""}return n},_messagesEquals:function(e,i){var s,n=-1,o=!0,r=t.extend([],e),a=t.extend([],i);return r.length===a.length&&(r.forEach(function(e){e instanceof l?s=e:(s=new l(e.summary,e.detail,e.severity),s=Object.freeze?Object.freeze(s):s),n=-1,a.forEach(function(e,t){l.getSeverityLevel(s.severity)===l.getSeverityLevel(e.severity)&&s.summary===e.summary&&s.detail===e.detail&&(n=t)}),n>-1?a.splice(n,1):o=!1}),o)},_parseValue:function(e,t,i){var s=this._GetConverter(),n=e;if(s&&"object"==typeof s)if(s.parse&&"function"==typeof s.parse)try{i&&this._setValidOption("pending",t),n=s.parse(e)}catch(e){throw e}else c.level>c.LEVEL_WARN&&c.info("converter does not support the parse method.");return n},_addValidationError:function(t,i){var n,o,r,a;t instanceof e.ConverterError||t instanceof e.ValidatorError?(o=(r=t.getMessage()).severity||l.SEVERITY_LEVEL.ERROR,a=r.summary||s.getTranslatedString("oj-message.error"),n=r.detail||s.getTranslatedString("oj-converter.detail")):t.summary||t.detail?(o=l.SEVERITY_LEVEL.ERROR,a=t.summary||s.getTranslatedString("oj-message.error"),n=t.detail||s.getTranslatedString("oj-converter.detail")):(o=l.SEVERITY_LEVEL.ERROR,a=s.getTranslatedString("oj-message.error"),n=t.message||s.getTranslatedString("oj-converter.detail")),i.push({summary:a,detail:n,severity:o})},_processValidationErrors:function(t,i,s){var n,o=[],r=t._messages||[],a={};a.context=i||0,a.display=s||e.ComponentMessage.DISPLAY.SHOWN,0===r.length&&this._addValidationError(t,r);for(var l=0;l<r.length;l++)n=r[l],o.push(this._createComponentMessage(n.summary,n.detail,n.severity,a));return o||null},_createComponentMessage:function(t,i,s,n){var o;return o=new e.ComponentMessage(t,i,s,n),o=Object.seal?Object.seal(o):o},_refreshComponentDisplayValue:function(e,t){var i;return(t||e!==this._getLastModelValue())&&(i=this._UpdateElementDisplayValue(e)),i},_refreshTheming:function(e,t){-1!==Object.keys(this._OPTION_TO_CSS_MAPPING).indexOf(e)&&(t?this.widget()[0].classList.add(this._OPTION_TO_CSS_MAPPING[e]):this.widget()[0].classList.remove(this._OPTION_TO_CSS_MAPPING[e]))},_runDeferredValidation:function(e){this._CanSetValue()?this._validateValueForRequiredOnly(this.options.value,e):c.level>c.LEVEL_WARN&&c.info("Deferred validation skipped as component is readonly or disabled."),this._setValidOption(this._determineValidFromMessagesOptions(),null)},_runMixedValidationAfterSetOption:function(e){var t,i=!1;this._hasInvalidMessagesShowing()&&(i=!0),this._clearComponentMessages(),i&&(t=this._GetDisplayValue(),this._SetValue(t,null,e)),!i&&this._IsRequired()?this._runDeferredValidation(e.validationContext):this._setValidOption(this._determineValidFromMessagesOptions(),null)},_UpdateElementDisplayValue:function(e,t){var i,s;i=e;try{i=this._formatValue(e);try{this._setLastModelValue(e),this._afterConverterFormat(i)}catch(e){throw e}s=i}catch(n){t||this._afterConverterFormatFailure(n),this._setLastModelValue(e),this._afterConverterFormat(i),s=void 0}return s},_SetLoading:function(){var e=this.widget()[0],t=this.GetFocusElement();e.classList.add("oj-loading"),this._saveAriaLabel=t.getAttribute("aria-label");var i=s.getTranslatedString("oj-ojEditableValue.loading");t.setAttribute("aria-label",i)},_ClearLoading:function(){var e=this.widget()[0],t=this.GetFocusElement();e.classList.remove("oj-loading"),this._saveAriaLabel?t.setAttribute("aria-label",this._saveAriaLabel):t.removeAttribute("aria-label")},_afterConverterFormat:function(e){var t;this._SetDisplayValue(e),t=this._GetDisplayValue(),this._setLastDisplayValue(t),this._SetRawValue(t,null)},_afterConverterFormatFailure:function(e){var t;t=this._processValidationErrors(e),this._updateMessagesOption("messagesShown",t),this._setValidOption(h,null)},_loadingConverter:function(t){var i=this,s=e.EditableValueUtils._getShowLoadingDelay(),n=this._converterChangedCounter,o=setTimeout(function(){n===i._converterChangedCounter&&i._SetLoading()},s);return t.then(function(e){return i._ClearLoading(),clearTimeout(o),e})},_validateValueForRequiredOnly:function(t,i){var s,n;if(this._IsRequired()){n=this._getImplicitRequiredValidator();try{this._setValidOption("pending",null),n.validate(e.StringUtils.trim(t))}catch(t){(s=this._processValidationErrors(t,i,e.ComponentMessage.DISPLAY.HIDDEN))&&this._updateMessagesOption("messagesHidden",s)}}},_validateValue:function(t,i,s){var n,o,r,a,l=this._GetAllSyncValidators(),u=this._IsRequired(),p=!1,d=[];if((u||l.length>0)&&this._setValidOption("pending",i),u){r=this._getImplicitRequiredValidator();try{r.validate(e.StringUtils.trim(t))}catch(e){this._addValidationError(e,d),this._setValidOption(h,i),p=!0}}for(n=0;n<l.length;n++)if("object"==typeof(r=l[n]))if(r.validate&&"function"==typeof r.validate)try{r.validate(t)}catch(e){this._addValidationError(e,d),p||(this._setValidOption(h,i),p=!0)}else c.level>c.LEVEL_WARN&&c.info("validator does not support the validate method.");return d.length>0&&((a=new Error)._messages=d,o=this._processValidationErrors(a,s),this._updateMessagesOption("messagesShown",o,i)),0===d.length},_asyncValidateValue:function(t,i,s){function n(e){return e.then(function(e){var i;return _._asyncValidatorValidateCounter===f?i="resolved":(c.level>c.LEVEL_WARN&&c.info("Validate ignored because new value came in before async validator finished for "+t),i="ignore"),{v:e,status:i}},function(e){var n;return _._asyncValidatorValidateCounter===f?(a=_._processValidationErrors(e,s),_._updateMessagesOption("messagesShown",a,i),p||(_._setValidOption(h,i),p=!0),n="rejected"):(c.level>c.LEVEL_WARN&&c.info("Validate ignored because new value came in before async validator finished for "+t),n="ignore"),{e:e,status:n}})}var o,r,a,l,u=this._getAllAsyncValidators(),p=!1,d=u.length>0,_=this,f=this._asyncValidatorValidateCounter;if(d&&this._setValidOption("pending",i),l=this._validateValue(t,i,s),!d)return l&&this._setValidOption(_._determineValidFromMessagesOptions(),i),l?t:void 0;var g=[]
;for(o=0;o<u.length;o++)g.push(u[o].validate(e.StringUtils.trim(t)));return new Promise(function(e){Promise.all(g.map(n)).then(function(t){t.filter(function(e){return"ignore"===e.status}).length>0?r="ignoreValidation":(r=p?h:"valid",_._setValidOption(_._determineValidFromMessagesOptions(),i)),e(r)})})},_updateDescribedBy:p._updateDescribedBy,_addAriaDescribedBy:p._addAriaDescribedBy,_removeAriaDescribedBy:p._removeAriaDescribedBy,_setBusyState:e.EditableValueUtils._SetBusyState,_clearBusyState:e.EditableValueUtils._ClearBusyState,_setBusyStateAsyncValidatorHint:e.EditableValueUtils._SetBusyStateAsyncValidatorHint,_clearBusyStateAsyncValidatorHint:e.EditableValueUtils._ClearBusyStateAsyncValidatorHint,_setBusyStateAsyncConverterLoading:e.EditableValueUtils._SetBusyStateAsyncConverterLoading,_clearBusyStateAsyncConverterLoading:e.EditableValueUtils._ClearBusyStateAsyncConverterLoading,_AfterCreateConverterCached:e.EditableValueUtils._AfterCreateConverterCached},!0),r.setDefaultOptions({editableValue:{displayOptions:r.createDynamicPropertyGetter(function(e){var t={messages:e.containers.indexOf("ojDataGrid")>=0||e.containers.indexOf("ojTable")>=0?["notewindow"]:["inline"],converterHint:["placeholder","notewindow"],validatorHint:["notewindow"]};return t[e.isCustomElement?"helpInstruction":"title"]=["notewindow"],t}),help:r.createDynamicPropertyGetter(function(e){return e.isCustomElement?{instruction:""}:{definition:null,source:null}})}}),e.InlineMessagingStrategy=function(e){this.Init(e)},e.ComponentMessaging.registerMessagingStrategy(e.ComponentMessaging._DISPLAY_TYPE.INLINE,e.InlineMessagingStrategy),e.Object.createSubclass(e.InlineMessagingStrategy,e.MessagingStrategy,"oj.InlineMessagingStrategy"),e.InlineMessagingStrategy.prototype.reactivate=function(t){e.InlineMessagingStrategy.superclass.reactivate.call(this,t),this._updateInlineMessage()},e.InlineMessagingStrategy.prototype.shouldUpdate=function(e){return!(!e||void 0===e.validityState)},e.InlineMessagingStrategy.prototype.update=function(){e.InlineMessagingStrategy.superclass.update.call(this),this._updateInlineMessage()},e.InlineMessagingStrategy.prototype.deactivate=function(){this._removeMessagingContentRootDom(),e.InlineMessagingStrategy.superclass.deactivate.call(this)},e.InlineMessagingStrategy.prototype._getDefaultAnimation=function(){if(!e.InlineMessagingStrategy._defaultAnimation){var t=(o.parseJSONFromFontFamily("oj-messaging-inline-option-defaults")||{}).animation;t=t||{},e.InlineMessagingStrategy._defaultAnimation=t}return e.InlineMessagingStrategy._defaultAnimation},e.InlineMessagingStrategy.prototype._replaceAnimationOptions=function(t,i){var s,n;e.StringUtils.isString(t)?(n=!0,s=t+""):(n=!1,s=JSON.stringify(t));for(var o=Object.keys(i),r=0;r<o.length;r++){var a=o[r];s=s.replace(new RegExp(a,"g"),i[a])}return n?s:JSON.parse(s)},e.InlineMessagingStrategy.prototype._determineAnimation=function(e,t){var i,s,n,o=this._getDefaultAnimation();if(o){var r,a=e[0],l=a.innerHTML,u=a.offsetHeight;a.innerHTML=t,r=a.offsetHeight,a.innerHTML=l,"noanimation"!=(i=r>u?"open":r<u?"close":"noanimation")&&(s=o[i])&&(n=this._replaceAnimationOptions(s,{"#oldHeight":u+"px","#newHeight":r+"px"}))}return{action:i,effect:n}},e.InlineMessagingStrategy.prototype._setBusyState=function(){if(!this._resolveBusyState){var e=this.GetComponent(),t=e?e.element:null,i=t?t[0]:null,s=n.getContext(i).getBusyContext(),o="The page is waiting for inline message ";i&&i.id&&(o+='for "'+i.id+'" '),o+="to open/close",this._resolveBusyState=s.addBusyState({description:o})}},e.InlineMessagingStrategy.prototype._clearBusyState=function(){this._resolveBusyState&&(this._resolveBusyState(),this._resolveBusyState=null)},e.InlineMessagingStrategy.prototype._queueAction=function(e){var t=this,i=this.$messagingContentRoot;t._inInlineMessagingAnimation?this._currentContentToShow=e:(this._currentContentToShow=null,this._setBusyState(),this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=setTimeout(function(){if(t._timeoutId=null,i&&i[0]){var s=t._determineAnimation(i,e),n=s.action,o=s.effect;"noanimation"===n?(i[0].innerHTML=e,t._clearBusyState()):("close"===n?i[0].setAttribute("aria-live","off"):i[0].setAttribute("aria-live","polite"),"open"===n&&(i[0].innerHTML=e),t._inInlineMessagingAnimation=!0,a.startAnimation(i[0],"inline-"+n,o,t.GetComponent()).then(function(){var s;t._inInlineMessagingAnimation=!1,"close"===n&&(i[0].setAttribute("aria-live","polite"),i[0].innerHTML=e),null!==t._currentContentToShow?(s=t._currentContentToShow,t._currentContentToShow=null,t._queueAction(s)):t._clearBusyState()}))}else t._clearBusyState()},0))},e.InlineMessagingStrategy.prototype._updateInlineMessage=function(){var e;(e=this._buildInlineHtml())&&null==this.$messagingContentRoot&&this._createInlineMessage(),this.$messagingContentRoot&&this.$messagingContentRoot[0]&&(this.GetComponent()._IsCustomElement()?this._queueAction(e):e?this.$messagingContentRoot[0].innerHTML=e:this._removeMessagingContentRootDom())},e.InlineMessagingStrategy.prototype._createInlineMessage=function(){this.$messagingContentRoot=t(this._getInlineContentHtml()),this._addAriaDescribedBy(this.$messagingContentRoot),this._addAriaLive(this.$messagingContentRoot),this.GetComponent().widget()[0].appendChild(this.$messagingContentRoot[0])},e.InlineMessagingStrategy.prototype._getInlineContentHtml=function(){return"<div class='oj-messaging-inline-container'></div>"},e.InlineMessagingStrategy.prototype._removeMessagingContentRootDom=function(){if(null!=this.$messagingContentRoot){var e=this.$messagingContentRoot[0];this._removeAriaDescribedBy(this.$messagingContentRoot),e.parentNode.removeChild(e),this.$messagingContentRoot=null}},e.InlineMessagingStrategy.prototype._addAriaDescribedBy=function(i){var s,n,o,r,a=(n=this.GetLauncher())[0];e.Assert.assertPrototype(n,t),e.Assert.assertPrototype(i,t),o=i.uniqueId()[0].getAttribute("id"),(r=(s=a.getAttribute("aria-describedby"))?s.split(/\s+/):[]).push(o),null==(s=r.join(" ").trim())?a.removeAttribute("aria-describedby"):a.setAttribute("aria-describedby",s)},e.InlineMessagingStrategy.prototype._addAriaLive=function(i){e.Assert.assertPrototype(i,t),i[0].setAttribute("aria-live","polite")},e.InlineMessagingStrategy.prototype._removeAriaDescribedBy=function(i){var s,n,o,r,a;o=this.GetLauncher(),e.Assert.assertPrototype(o,t),e.Assert.assertPrototype(i,t),r=i[0].getAttribute("id"),-1!==(n=(a=(s=o[0].getAttribute("aria-describedby"))?s.split(/\s+/):[]).indexOf(r))&&a.splice(n,1),(s=a.join(" ").trim())?o[0].setAttribute("aria-describedby",s):o[0].removeAttribute("aria-describedby")},e.InlineMessagingStrategy.prototype._buildInlineHtml=function(){var e;return this.ShowMessages()?(e=this.GetComponent().document[0],this._buildMessagesHtml(e)):""},e.InlineMessagingStrategy.prototype._buildMessagesHtml=function(t){var i,s,n="";return this.HasMessages()&&(s=this.GetMessages(),i=this.GetMaxSeverity(),n=e.PopupMessagingStrategyUtils.buildMessagesHtml(t,s,i,!0)),n},e.PopupMessagingStrategy=function(e){this.Init(e)},e.ComponentMessaging.registerMessagingStrategy(e.ComponentMessaging._DISPLAY_TYPE.NOTEWINDOW,e.PopupMessagingStrategy),e.Object.createSubclass(e.PopupMessagingStrategy,e.MessagingStrategy,"oj.PopupMessagingStrategy"),e.PopupMessagingStrategy._DEFAULTS_BY_COMPONENT={ojRadioset:{position:"launcher",events:{open:"focusin mouseenter press",close:"mouseleave"}},ojCheckboxset:{position:"launcher",events:{open:"focusin mouseenter press",close:"mouseleave"}},ojInputText:{position:"launcher",events:{open:"focusin"}},ojTextArea:{position:"launcher",events:{open:"focusin"}},ojInputPassword:{position:"launcher",events:{open:"focusin"}},ojSwitch:{position:"launcher",events:{open:"focusin mouseenter",close:"mouseleave"}},ojSlider:{position:"launcher",events:{open:"focusin mouseenter",close:"mouseleave"}},ojColorSpectrum:{position:"launcher",events:{open:"focusin mouseenter",close:"mouseleave"}},ojColorPalette:{position:"launcher",events:{open:"focusin mouseenter",close:"mouseleave"}},default:{position:"launcher-wrapper",events:{open:"focusin"}}},e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT="oj-form-control-hint",e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT_CONVERTER="oj-form-control-hint-converter",e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT_VALIDATOR="oj-form-control-hint-validator",e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT_TITLE="oj-form-control-hint-title",e.PopupMessagingStrategy._OPEN_NAMESPACE=".ojPopupMessagingOpen",e.PopupMessagingStrategy._CLOSE_NAMESPACE=".ojPopupMessagingClose",e.PopupMessagingStrategy.prototype.activate=function(t){e.PopupMessagingStrategy.superclass.activate.call(this,t),this._initMessagingPopup()},e.PopupMessagingStrategy.prototype.reactivate=function(t){e.PopupMessagingStrategy.superclass.reactivate.call(this,t),this._updatePopupIfOpenOrComponentHasFocus()},e.PopupMessagingStrategy.prototype.update=function(){e.PopupMessagingStrategy.superclass.update.call(this),this._updatePopupIfOpenOrComponentHasFocus()},e.PopupMessagingStrategy.prototype.deactivate=function(){this._unregisterLauncherEvents(),this._destroyTooltip(),e.PopupMessagingStrategy.superclass.deactivate.call(this)},e.PopupMessagingStrategy.prototype.close=function(){this._closePopup()},e.PopupMessagingStrategy.prototype._closePopup=function(){this._queueAction(function(e){if(this._isPopupInitialized())return e&&this._setActionResolver(this.$messagingContentRoot,"close",e),void this.$messagingContentRoot.ojPopup("close");e&&e(!0)}.bind(this))},e.PopupMessagingStrategy.prototype._initMessagingPopup=function(){this._openPopupCallback||this._registerLauncherEvents()},e.PopupMessagingStrategy.prototype._addAnimateEventListeners=function(e){var t=function(e,t,i){var s=this.GetComponent();s&&s._trigger&&(t.stopPropagation(),s._trigger(e,null,i)||t.preventDefault())};e.on("ojanimatestart.notewindow",t.bind(this,"animateStart")),e.on("ojanimateend.notewindow",t.bind(this,"animateEnd"))},e.PopupMessagingStrategy.prototype._removeAnimateEventListeners=function(e){e.off("ojanimatestart.notewindow"),e.off("ojanimateend.notewindow")},e.PopupMessagingStrategy.prototype._setBusyState=function(e){var t=this.GetComponent(),i=t?t.element:null,s=i?i[0]:null,o=n.getContext(s).getBusyContext(),r="The page is waiting for note window ";return s&&s.id&&(r+='for "'+s.id+'" '),r+="to "+e,o.addBusyState({description:r})},e.PopupMessagingStrategy.prototype._setActionResolver=function(e,t,i){var s;this._actionCount>1&&(s=e.ojPopup("option","animation"),e.ojPopup("option","animation",null));var n=this._setBusyState(t);e.one("oj"+t,function(){s&&e.ojPopup("option","animation",s),n(),i(!0)})},e.PopupMessagingStrategy.prototype._queueAction=function(e){if(this.GetComponent()._IsCustomElement()){var t=this,i=function(e){var i=new Promise(e);return i.then(function(){t._actionCount-=1}),i};this._actionCount?(this._actionCount+=1,this._actionPromise=this._actionPromise.then(function(){return i(e)})):(this._actionCount=1,this._actionPromise=i(e))}else e(null)},e.PopupMessagingStrategy.prototype._openPopup=function(t){this._queueAction(function(i){var s,n,o;if(this._canOpenPopup()&&(n=this._buildPopupHtml(),!e.StringUtils.isEmptyOrUndefined(n))){var r=this._getPopupElement(),a=r.ojPopup("isOpen");if((s=e.PopupMessagingStrategyPoolUtils.getPopupContentNode(r)).innerHTML="",s.innerHTML=n,!a)return o=this.GetLauncher(),t&&"press"===t.type&&this._openPopupOnPressEvent(o),i&&this._setActionResolver(r,"open",i),void r.ojPopup("open",o);a&&r.ojPopup("refresh")}i&&i(!0)}.bind(this))},e.PopupMessagingStrategy.prototype._openPopupOnPressEvent=function(e){this._inPressEvent=!0,e[0].addEventListener("click",this._eatChangeAndClickOnPress,!0),e[0].addEventListener("change",this._eatChangeAndClickOnPress,!0),e.one("touchend",function(){setTimeout(function(){this._inPressEvent=!1},50)})},e.PopupMessagingStrategy.prototype._eatChangeAndClickOnPress=function(e){this._inPressEvent&&(e.preventDefault(),e.stopPropagation(),"click"===e.type&&(this._inPressEvent=!1))},e.PopupMessagingStrategy.prototype._canOpenPopup=function(){var e=this.GetComponent().options,t=e.disabled||!1,i=e.readOnly||!1;return!(t||i)},e.PopupMessagingStrategy.prototype._updatePopupIfOpenOrComponentHasFocus=function(){var t,i,s,n;t=this._buildPopupHtml(),null!=this.GetLauncher()&&(s=this.GetLauncher()[0].contains(document.activeElement),this._isPopupInitialized()?(n=this._getPopupElement()).ojPopup("isOpen")&&(t?((i=e.PopupMessagingStrategyPoolUtils.getPopupContentNode(n)).innerHTML="",i.innerHTML=t,n.ojPopup("refresh")):n.ojPopup("close")):s&&t&&this._openPopup(void 0))},e.PopupMessagingStrategy.prototype._unregisterLauncherEvents=function(){var t=this.GetLauncher();t.off(e.PopupMessagingStrategy._OPEN_NAMESPACE),t.off(e.PopupMessagingStrategy._CLOSE_NAMESPACE),t[0].removeEventListener("click",this._eatChangeAndClickOnPress,!0),t[0].removeEventListener("change",this._eatChangeAndClickOnPress,!0),e.DomUtils.isTouchSupported()&&(t.ojHammer().off("press"),t.ojHammer("destroy"),t.off("contextmenu",this._eatContextMenuOnOpenPopupListener),this._eatContextMenuOnOpenPopupListener=null,this._inPressEvent=null),this._openPopupCallback=null,this._closePopupCallback=null},e.PopupMessagingStrategy.prototype._registerLauncherEvents=function(){var t,s,n,o,r,a,l,u,c=this.GetLauncher();(o=(n=e.PopupMessagingStrategy._DEFAULTS_BY_COMPONENT[this.GetComponent().widgetName])?n.events:e.PopupMessagingStrategy._DEFAULTS_BY_COMPONENT.default.events).open&&((l=this._openPopupCallback)||(l=this._openPopup.bind(this),this._openPopupCallback=l),u=o.open.indexOf("press"),a=this._getNamespacedEvents(o.open.replace("press",""),e.PopupMessagingStrategy._OPEN_NAMESPACE),c.on(a,l),e.DomUtils.isTouchSupported()&&-1!==u&&(this._eatContextMenuOnOpenPopupListener=function(){return!1},c.on("contextmenu",this._eatContextMenuOnOpenPopupListener),r={recognizers:[[i.Press,{time:750}]]},c.ojHammer(r).on("press",l))),o.close&&((s=this._closePopupCallback)||(s=this._closePopup.bind(this),this._closePopupCallback=s),t=this._getNamespacedEvents(o.close,e.PopupMessagingStrategy._CLOSE_NAMESPACE),c.on(t,s))},e.PopupMessagingStrategy.prototype._getNamespacedEvents=function(e,t){var i,s,n;if(""===e||""===t)return e;n=(i=e.split(" ")).length,s=[];for(var o=0;o<n;o++)i[o]&&s.push(i[o]+t);return s.join(" ")},e.PopupMessagingStrategy.prototype._getPopupPosition=function(){var t,i,s;return(t=(i=e.PopupMessagingStrategy._DEFAULTS_BY_COMPONENT[this.GetComponent().widgetName])?i.position:e.PopupMessagingStrategy._DEFAULTS_BY_COMPONENT.default.position)&&("launcher"===t?s=this.GetLauncher():"launcher-wrapper"===t&&(s=this.GetLauncher().parent())),s||(s=this.GetComponent().widget()),{my:"start bottom",at:"end top",collision:"flipcenter",of:s}},e.PopupMessagingStrategy.prototype._getPopupElement=function(){var t,i;if(this.$messagingContentRoot)return this.$messagingContentRoot;if(t=e.PopupMessagingStrategyPoolUtils.getNextFreePopup(),i=this._getPopupPosition(),t.ojPopup("option","position",i),t.ojPopup("option","beforeClose",this._popupBeforeCloseCallback.bind(this)),t.ojPopup("option","close",this._popupCloseCallback.bind(this)),t.ojPopup("option","open",this._popupOpenCallback.bind(this)),this.GetComponent()._IsCustomElement()){var s=(o.parseJSONFromFontFamily("oj-messaging-popup-option-defaults")||{}).animation;s.actionPrefix="notewindow",t.ojPopup("option","animation",s),this._addAnimateEventListeners(t)}else t.ojPopup("option","animation",null);return this.$messagingContentRoot=t,this.$messagingContentRoot},e.PopupMessagingStrategy.prototype._popupOpenCallback=function(e){var i=t(e.target),s=this;window.setTimeout(function(){r.isComponentInitialized(i,"ojPopup")?i.ojPopup("option","autoDismiss","focusLoss"):delete s.$messagingContentRoot},10)},e.PopupMessagingStrategy.prototype._popupBeforeCloseCallback=function(){this._resolveBusyState=this._setBusyState("close")},e.PopupMessagingStrategy.prototype._popupCloseCallback=function(i){var s=this.GetLauncher(),n=t(i.target);this._removeAnimateEventListeners(n),r.isComponentInitialized(n,"ojPopup")&&(n.ojPopup("option","autoDismiss","none"),n.ojPopup("option","open",null),n.ojPopup("option","close",null),n.ojPopup("option","beforeClose",null)),s&&s[0]&&(s[0].removeEventListener("click",this._eatChangeAndClickOnPress,!0),s[0].removeEventListener("change",this._eatChangeAndClickOnPress,!0)),this.$messagingContentRoot=null,this._inPressEvent=null,e.PopupMessagingStrategyPoolUtils.getPopupContentNode(n).innerHTML="",this._resolveBusyState&&(this._resolveBusyState(),this._resolveBusyState=null)},e.PopupMessagingStrategy.prototype._destroyTooltip=function(){this._closePopup(),e.PopupMessagingStrategyPoolUtils.destroyFreePopup()},e.PopupMessagingStrategy.prototype._buildPopupHtml=function(){var t=!1,i=this.GetComponent().document[0],s=[],n="";return this.ShowMessages()&&s.push(this._buildMessagesHtml(i)),(this.ShowConverterHint()||this.ShowValidatorHint()||this.ShowTitle())&&s.push(this._buildHintsHtml(i)),s.forEach(function(s){s&&(t?n=n.concat(e.PopupMessagingStrategyUtils.getSeparatorHtml(i)):t=!0,n=n.concat(s))}),n},e.PopupMessagingStrategy.prototype._buildMessagesHtml=function(t){var i,s="",n=this.GetMaxSeverity();return this.HasMessages()&&(i=this.GetMessages(),s=e.PopupMessagingStrategyUtils.buildMessagesHtml(t,i,n,!1)),s},e.PopupMessagingStrategy.prototype._buildHintsHtml=function(t){var i,s,n=[],o="";if(this.ShowConverterHint()&&(i=(n=this.GetConverterHint()).length?n[0]:"",o+=e.PopupMessagingStrategyUtils.buildHintHtml(t,e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT_CONVERTER,i,!1,e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT)),this.ShowValidatorHint())for(n=this.GetValidatorHints(),s=0;s<n.length;s++)o+=e.PopupMessagingStrategyUtils.buildHintHtml(t,e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT_VALIDATOR,n[s],!1,e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT);return this.ShowTitle()&&(o+=e.PopupMessagingStrategyUtils.buildHintHtml(t,e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT_TITLE,this.GetTitle(),!0,e.PopupMessagingStrategy._SELECTOR_FORMCONTROL_HINT)),o?"<div class='oj-form-control-hints'>"+o+"</div>":""},e.PopupMessagingStrategy.prototype._isPopupInitialized=function(){return!!this.$messagingContentRoot&&r.isComponentInitialized(this.$messagingContentRoot,"ojPopup")},e.PopupMessagingStrategyUtils={},e.PopupMessagingStrategyUtils.buildHintHtml=function(t,i,s,n,o){var r;if(s){r=t.createElement("div");for(var a=o.split(" "),l=0,u=a.length;l<u;++l)r.classList.add(a[l]);r.classList.add(i),e.PopupMessagingStrategyUtils._appendTextDom(r,e.PopupMessagingStrategyUtils._getTextDom(t,s,n))}return r?r.outerHTML:""},e.PopupMessagingStrategyUtils.getSeverityTranslatedString=function(e){var t;switch(e){case l.SEVERITY_LEVEL.FATAL:t=s.getTranslatedString("oj-message.fatal");break;case l.SEVERITY_LEVEL.ERROR:t=s.getTranslatedString("oj-message.error");break;case l.SEVERITY_LEVEL.WARNING:t=s.getTranslatedString("oj-message.warning");break;case l.SEVERITY_LEVEL.INFO:t=s.getTranslatedString("oj-message.info");break;case l.SEVERITY_LEVEL.CONFIRMATION:t=s.getTranslatedString("oj-message.confirmation")}return t},e.PopupMessagingStrategyUtils.getSeparatorHtml=function(e){var i;return(i=t(e.createElement("hr")))?i.get(0).outerHTML:""},e.PopupMessagingStrategyUtils.buildMessagesHtml=function(t,i,s,n){var o,r,a,u,c,p,h,d,_="",f=[],g={};for(r=0;r<i.length;r++)c=(u=i[r])instanceof l?u:new l(u.summary,u.detail,u.severity),g[p=l.getSeverityLevel(c.severity)]||(g[p]=[]),g[p].push(c);for(r=s;r>=l.SEVERITY_LEVEL.CONFIRMATION;r--)for(f=g[r]||[],a=0;a<f.length;a++)u=f[a],p=l.getSeverityLevel(u.severity),h=e.PopupMessagingStrategyUtils.getSeverityTranslatedString(p),d=u.summary||h,o=u.detail||"",_=_.concat(e.PopupMessagingStrategyUtils.buildMessageHtml(t,d,o,p,n));return _},e.PopupMessagingStrategyUtils.buildMessageHtml=function(t,i,s,n,o){var r,a,l,u,c,p=e.PopupMessagingStrategyUtils.getSeverityTranslatedString(n);if((l=t.createElement("div")).classList.add(e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE),o)for(var h=e.PopupMessagingStrategyUtils._getSeveritySelector(n).split(" "),d=0,_=h.length;d<_;++d)l.classList.add(h[d]);u=t.createElement("span");for(var f=e.PopupMessagingStrategyUtils._getSeverityIconSelector(n).split(" "),g=0,v=f.length;g<v;++g)u.classList.add(f[g]);if(null==p?u.removeAttribute("title"):u.setAttribute("title",p),u.setAttribute("role","img"),l.appendChild(u),(r=t.createElement("span")).classList.add(e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_CONTENT),(c=t.createElement("div")).classList.add(e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_SUMMARY),c.textContent=i,r.appendChild(c),s){var m=e.PopupMessagingStrategyUtils._getTextDom(t,s,!0);(a=t.createElement("div")).classList.add(e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_DETAIL),e.PopupMessagingStrategyUtils._appendTextDom(a,m),r.appendChild(a)}return l.appendChild(r),l.outerHTML},e.PopupMessagingStrategyUtils._getSeverityIconSelector=function(t){var i;switch(t){case l.SEVERITY_LEVEL.FATAL:case l.SEVERITY_LEVEL.ERROR:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_ERROR_ICON;break;case l.SEVERITY_LEVEL.WARNING:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_WARNING_ICON;break;case l.SEVERITY_LEVEL.INFO:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_INFO_ICON;break;case l.SEVERITY_LEVEL.CONFIRMATION:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_CONFIRMATION_ICON}return e.PopupMessagingStrategyUtils._DEFAULT_STATUS_ICON_SELECTORS+i},e.PopupMessagingStrategyUtils._getSeveritySelector=function(t){var i;switch(t){case l.SEVERITY_LEVEL.FATAL:case l.SEVERITY_LEVEL.ERROR:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_ERROR;break;case l.SEVERITY_LEVEL.WARNING:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_WARNING;break;case l.SEVERITY_LEVEL.INFO:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_INFO;break;case l.SEVERITY_LEVEL.CONFIRMATION:default:i=e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_CONFIRMATION}return i},e.PopupMessagingStrategyUtils._getTextDom=function(t,i,s){var n=null;return e.StringUtils.isString(i)&&(s&&e.DomUtils.isHTMLContent(i)?n=e.DomUtils.cleanHtml(i.substring(6,i.length-7)):(n=t.createElement("span")).textContent=i),n},e.PopupMessagingStrategyUtils._appendTextDom=function(t,i){e.StringUtils.isString(i)?t.innerHTML=i:t.appendChild(i)},e.PopupMessagingStrategyUtils._DEFAULT_STATUS_ICON_SELECTORS="oj-component-icon oj-message-status-icon ",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE="oj-message",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_SUMMARY="oj-message-summary",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_DETAIL="oj-message-detail",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_CONTENT="oj-message-content",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_ERROR_ICON="oj-message-error-icon",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_WARNING_ICON="oj-message-warning-icon",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_INFO_ICON="oj-message-info-icon",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_CONFIRMATION_ICON="oj-message-confirmation-icon",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_ERROR="oj-message-error",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_WARNING="oj-message-warning",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_INFO="oj-message-info",e.PopupMessagingStrategyUtils._SELECTOR_MESSAGE_CONFIRMATION="oj-message-confirmation",e.PopupMessagingStrategyPoolUtils={},e.PopupMessagingStrategyPoolUtils.getNextFreePopup=function(){var i,s=e.PopupMessagingStrategyPoolUtils._getPool(),n=s.find("."+e.PopupMessagingStrategyPoolUtils._SELECTOR_MESSAGING);return 0===n.length?((i=t(e.PopupMessagingStrategyPoolUtils._getPopupContentHtml()))[0].style.display="none",i.appendTo(s),i.ojPopup({initialFocus:"none",tail:"simple",autoDismiss:"none",modality:"modeless",animation:{open:null,close:null}})):i=t(n[0]),i},e.PopupMessagingStrategyPoolUtils.getPopupContentNode=function(t){return t.find("."+e.PopupMessagingStrategyPoolUtils._SELECTOR_MESSAGING_CONTAINER)[0]},e.PopupMessagingStrategyPoolUtils.destroyFreePopup=function(){var t;if(e.PopupMessagingStrategyPoolUtils._getFreePoolCount()>0){var i=(t=e.PopupMessagingStrategyPoolUtils.getNextFreePopup())[0];t.ojPopup("destroy"),i.parentNode.removeChild(i)}},e.PopupMessagingStrategyPoolUtils._getPool=function(){var i=t("#"+e.PopupMessagingStrategyPoolUtils._MESSAGING_POPUP_POOL_ID);if(i.length>0)return i;var s=(i=t("<div>"))[0];return s.setAttribute("id",e.PopupMessagingStrategyPoolUtils._MESSAGING_POPUP_POOL_ID),s.setAttribute("role","presentation"),document.body.appendChild(s),i},e.PopupMessagingStrategyPoolUtils._getFreePoolCount=function(){return e.PopupMessagingStrategyPoolUtils._getPool().find("."+e.PopupMessagingStrategyPoolUtils._SELECTOR_MESSAGING).length},e.PopupMessagingStrategyPoolUtils._getPopupContentHtml=function(){return'<div class="'+e.PopupMessagingStrategyPoolUtils._SELECTOR_MESSAGING+'"><div class="'+e.PopupMessagingStrategyPoolUtils._SELECTOR_MESSAGING_CONTAINER+'"></div></div>'},e.PopupMessagingStrategyPoolUtils._SELECTOR_MESSAGING_CONTAINER="oj-messaging-popup-container",e.PopupMessagingStrategyPoolUtils._SELECTOR_MESSAGING="oj-messaging-popup",e.PopupMessagingStrategyPoolUtils._MESSAGING_POPUP_POOL_ID="__oj_messaging_popup_pool"}),define("ojs/ojoptgroup",["ojs/ojcore","jquery","ojs/ojcomponentcore"],function(e,t){"use strict";function i(e){this.updateDOM=function(){var t=e.element.customOptgroupRenderer;t&&"function"==typeof t&&t(e.element)}}var s={properties:{disabled:{type:"boolean",value:!1},label:{type:"string"}},methods:{setProperty:{},getProperty:{},refresh:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};s.properties.customOptgroupRenderer={},s.extension._CONSTRUCTOR=i,e.CustomElementBridge.register("oj-optgroup",{metadata:s})}),define("ojs/ojoption",["ojs/ojcore","jquery","ojs/ojcomponentcore"],function(e,t){"use strict";function i(i){function s(i){var s=e.BaseCustomElementBridge.getSlotMap(i),n=["startIcon","","endIcon"];t.each(s,function(e,s){-1===n.indexOf(e)&&function(e,i){t.each(i,function(t,i){e.removeChild(i)})}(i,s)}),t.each(n,function(e,n){s[n]&&function(e,i){t.each(i,function(t,i){e.appendChild(i)})}(i,s[n])})}this.updateDOM=function(){var e=i.element.customOptionRenderer;s(i.element),e&&"function"==typeof e&&e(i.element)}}var s={properties:{disabled:{type:"boolean",value:!1},value:{type:"any"}},methods:{setProperty:{},getProperty:{},refresh:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};s.properties.customOptionRenderer={},s.extension._CONSTRUCTOR=i,e.CustomElementBridge.register("oj-option",{metadata:s})}),define("ojs/ojeventtarget",["ojs/ojcore"],function(e){"use strict";var t=function(){function e(){}return e.prototype.addEventListener=function(e,t){this._eventListeners||(this._eventListeners=[]),this._eventListeners.push({type:e.toLowerCase(),listener:t})},e.prototype.removeEventListener=function(e,t){if(this._eventListeners){var i=void 0;for(i=this._eventListeners.length-1;i>=0;i--)this._eventListeners[i].type==e&&this._eventListeners[i].listener==t&&this._eventListeners.splice(i,1)}},e.prototype.dispatchEvent=function(e){if(this._eventListeners){var t,i=this._eventListeners.slice(0);for(t=0;t<i.length;t++){var s=i[t];if(e&&e.type&&s.type==e.type.toLowerCase()&&!1===s.listener.apply(this,[e]))return!1}}return!0},e.applyMixin=function(t){[e].forEach(function(e){Object.getOwnPropertyNames(e.prototype).forEach(function(i){"constructor"!==i&&(t.prototype[i]=e.prototype[i])})})},e}();e.EventTargetMixin=t;var i=function(){return function(e,t){this.type=e,this.options=t,null!=t&&(this.detail=t.detail)}}();e.GenericEvent=i}),define("ojs/ojdataprovider",["ojs/ojcore","ojs/ojeventtarget"],function(e){"use strict";var t,i,s=e.GenericEvent;!function(e){!function(e){e.$co="$co",e.$eq="$eq",e.$ew="$ew",e.$pr="$pr",e.$gt="$gt",e.$ge="$ge",e.$lt="$lt",e.$le="$le",e.$ne="$ne",e.$regex="$regex",e.$sw="$sw"}(e.AttributeOperator||(e.AttributeOperator={}))}(t||(t={})),e.AttributeFilterOperator=t,e.AttributeFilterOperator.AttributeOperator=t.AttributeOperator,function(e){!function(e){e.$and="$and",e.$or="$or"}(e.CompoundOperator||(e.CompoundOperator={}))}(i||(i={})),e.CompoundFilterOperator=i,e.CompoundFilterOperator.CompoundOperator=i.CompoundOperator;var n=function(e){function t(i){var s={};return s[t._DETAIL]=i,e.call(this,"mutate",s)||this}return __extends(t,e),t._DETAIL="detail",t}(s);e.DataProviderMutationEvent=n,e.DataProviderMutationEvent=n;var o=function(e){function t(){return e.call(this,"refresh")||this}return __extends(t,e),t}(s);e.DataProviderRefreshEvent=o,e.DataProviderRefreshEvent=o,e.DataProvider=function(){};var r=function(){function e(){}return e.prototype.fetchByKeys=function(e){var t=0,i=this.getIterationLimit?this.getIterationLimit():-1,s={size:25},n=new Map,o=this.fetchFirst(s)[Symbol.asyncIterator]();return function e(s,n,o){return n.next().then(function(r){var a=r.value,l=a.data,u=a.metadata,c=u.map(function(e){return e.key}),p=!0;return s.keys.forEach(function(e){o.has(e)||c.map(function(t,i){t==e&&o.set(t,{metadata:u[i],data:l[i]})}),o.has(e)||(p=!1)}),t+=l.length,p||r.done?o:-1!=i&&t>=i?o:e(s,n,o)})}(e,o,n).then(function(t){var i=new Map;return t.forEach(function(e,t){var s=[e];i.set(t,s[0])}),{fetchParameters:e,results:i}})},e.prototype.containsKeys=function(e){return this.fetchByKeys(e).then(function(t){var i=new Set;return e.keys.forEach(function(e){null!=t.results.get(e)&&i.add(e)}),Promise.resolve({containsParameters:e,results:i})})},e.prototype.getCapability=function(e){if("fetchByKeys"==e)return{implementation:"iteration"};var t=null;if(!0!==this._ojSkipLastCapability){this._ojSkipLastCapability=!0;for(var i=1;this["_ojLastGetCapability"+i];)++i;for(--i;i>0&&!(t=this["_ojLastGetCapability"+i](e));i--);delete this._ojSkipLastCapability}return t},e.applyMixin=function(t){var i=t.prototype.getCapability;if([e].forEach(function(e){Object.getOwnPropertyNames(e.prototype).forEach(function(i){"constructor"!==i&&(t.prototype[i]=e.prototype[i])})}),i){for(var s=1;t.prototype["_ojLastGetCapability"+s];)++s;t.prototype["_ojLastGetCapability"+s]=i}},e}();e.FetchByKeysMixin=r,e.FetchByKeysMixin.applyMixin=r.applyMixin;var a=function(){function e(){}return e.prototype.fetchByOffset=function(e){var t=e&&e.size>0?e.size:25,i=e?e.sortCriteria:null,s=e&&e.offset>0?e.offset:0,n=0,o=this.getIterationLimit?this.getIterationLimit():-1,r=!1,a={};a.size=t,a.sortCriteria=i;var l=new Array,u=this.fetchFirst(a)[Symbol.asyncIterator]();return function e(i,a,l){return a.next().then(function(u){r=u.done;var c=u.value,p=c.data,h=c.metadata,d=p.length;if(s<n+d)for(var _=s<=n?0:s-n;_<d&&l.length!=t;_++)l.push({metadata:h[_],data:p[_]});return n+=d,l.length<t&&!r?-1!=o&&n>=o?l:e(i,a,l):l})}(e,u,l).then(function(t){return{fetchParameters:e,results:t,done:r}})},e.prototype.getCapability=function(e){if("fetchByOffset"==e)return{implementation:"iteration"};var t=null;if(!0!==this._ojSkipLastCapability){this._ojSkipLastCapability=!0;for(var i=1;this["_ojLastGetCapability"+i];)++i;for(--i;i>0&&!(t=this["_ojLastGetCapability"+i](e));i--);delete this._ojSkipLastCapability}return t},e.applyMixin=function(t){var i=t.prototype.getCapability;if([e].forEach(function(e){Object.getOwnPropertyNames(e.prototype).forEach(function(i){"constructor"!==i&&(t.prototype[i]=e.prototype[i])})}),i){for(var s=1;t.prototype["_ojLastGetCapability"+s];)++s;t.prototype["_ojLastGetCapability"+s]=i}},e}();e.FetchByOffsetMixin=a,e.FetchByOffsetMixin.applyMixin=a.applyMixin;var l=function(){function t(e){var t=e?e.filterDef:null;t&&(this.op=t.op),t.value?(this.value=t.value,t.attribute&&(this.attribute=t.attribute)):t&&(this.criteria=t.criteria)}return t.prototype.filter=function(i,s,n){return e.FilterUtils.satisfy(t._transformFilter(this),i)},t._transformFilter=function(e){var i;if(e){var s=e.op
;if("$le"===s?s="$lte":"$ge"===s?s="$gte":"$pr"===s&&(s="$exists"),"$and"!=s&&"$or"!=s){var n=e.value;i={};var o=e.attribute;if(o){var r={};"$sw"!==s&&"$ew"!==s&&"$co"!==s||(s="$regex",n=t._fixStringExpr(s,n)),r[s]=n,i[o]=r}else{var a=[];t._transformObjectExpr(n,s,null,a),i.$and=a}}else{var l=[];e.criteria.forEach(function(e){l.push(t._transformFilter(e))}),(i={})[s]=l}}return i},t._transformObjectExpr=function(e,i,s,n){if(Object.keys(e).length>0)Object.keys(e).forEach(function(o){var r=e[o],a=s?s+"."+o:o;if(r instanceof Object)t._transformObjectExpr(r,i,a,n);else{var l={};"$sw"!==i&&"$ew"!==i&&"$co"!==i||(i="$regex",r=t._fixStringExpr(i,r)),l[i]=r;var u={};u[a]=l,n.push(u)}});else{var o={};o[i]=e;var r={};r[s]=o,n.push(r)}},t._fixStringExpr=function(e,t){return("string"==typeof t||t instanceof String)&&("$sw"===e?t="^"+t:"$ew"===e&&(t+="$")),t},t}(),u=function(){function e(){}return e.getFilter=function(e){return new l(e)},e}();e.FilterFactory=u,e.FilterUtils=function(){function e(e,t){var i=!1;for(var n in t)if(t.hasOwnProperty(n)){var o=t[n];if(i||!s(n))throw new Error("parsing error "+t);e.operator=n,e.right=o,i=!0}}function t(e,t,i){var s;if("$lt"===e)return(i=(s=o(i,t))[0])<(t=s[1]);if("$gt"===e)return(i=(s=o(i,t))[0])>(t=s[1]);if("$lte"===e)return(i=(s=o(i,t))[0])<=(t=s[1]);if("$gte"===e)return(i=(s=o(i,t))[0])>=(t=s[1]);if("$eq"===e)return i===t;if("$ne"===e)return i!==t;if("$regex"===e)return!!i&&("string"==typeof i||i instanceof String||(i=new String(i)),null!==i.match(t));if("$exists"===e)return t?null!=i:null==i;throw new Error("not a valid expression! "+expTree)}function i(e){return"$and"===e||"$or"===e}function s(e){return"$lt"===e||"$gt"===e||"$lte"===e||"$gte"===e||"$eq"===e||"$ne"===e||"$regex"===e||"$exists"===e}function n(e){return null!=e&&(e instanceof String||"string"==typeof e)}function o(e,t){return n(e)&&null==t?t="":n(t)&&null==e&&(e=""),[e,t]}function r(e,t){for(var i=e.split("."),s=t,n=0;n<i.length;n++)s=s[i[n]];return s}return{satisfy:function(n,o){return!n||function e(n,o){var a=n.operator;if(i(a)){if(!n.left&&n.array instanceof Array){for(var l,u=n.array,c=0;c<u.length;c++){var p=e(u[c],o);if("$or"===a&&!0===p)return!0;if("$and"===a&&!1===p)return!1;l=p}return l}throw new Error("invalid expression tree!"+n)}if(s(a)){var h,d=n.right;if("*"!=n.left)return h=r(n.left,o),t(a,d,h);var _,f=Object.keys(o);for(_=0;_<f.length;_++)if(h=r(f[_],o),t(a,d,h))return!0;return!1}throw new Error("not a valid expression!"+n)}(function t(n){var o,r=[];for(var a in n)if(n.hasOwnProperty(a)){var l=n[a];if(0===a.indexOf("$")){if(i(a)){if(!(l instanceof Array))throw new Error("not a valid expression: "+n);o={operator:a,array:[]};for(var u=0;u<l.length;u++){var c=t(l[u]);o.array.push(c)}}else if(s(a))throw new Error("not a valid expression: "+n)}else if("object"!=typeof l)r.push({left:a,right:l,operator:"$eq"});else{var p={left:a};e(p,l),r.push(p)}}return r.length>1?o={operator:"$and",array:r}:1===r.length&&(o=r[0]),o}(n),o)},getValue:r,assembleObject:function(e,t){var i;if(t){i={};for(var s=0;s<t.length;s++)for(var n=i,o=e,r=t[s].split("."),a=0;a<r.length;a++)o=o[r[a]],!n[r[a]]&&a<r.length-1&&(n[r[a]]={}),a===r.length-1?n[r[a]]=o:n=n[r[a]]}else i=e;return i}}}();var c={};return c.FetchByKeysMixin=e.FetchByKeysMixin,c.FetchByOffsetMixin=e.FetchByOffsetMixin,c.FilterFactory=e.FilterFactory,c}),define("ojs/ojlistdataproviderview",["ojs/ojcore","jquery","ojs/ojdataprovider","ojs/ojcomponentcore","ojs/ojeventtarget","ojs/ojdataprovider"],function(e,t,i){"use strict";var s=function(){function t(e,i){this.dataProvider=e,this.options=i,this._noFilterSupport=!1,this.AsyncIterable=function(){return function(e,t){this._parent=e,this._asyncIterator=t,this[Symbol.asyncIterator]=function(){return this._asyncIterator}}}(),this.AsyncIterator=function(){function e(e,t,i){this._parent=e,this._nextFunc=t,this._params=i}return e.prototype.next=function(){var e=this._nextFunc(this._params);return Promise.resolve(e)},e}(),this.AsyncIteratorResult=function(){return function(e,i,s){this._parent=e,this.value=i,this.done=s,this[t._VALUE]=i,this[t._DONE]=s}}(),this.FetchListResult=function(){return function(e,i,s,n){this._parent=e,this.fetchParameters=i,this.data=s,this.metadata=n,this[t._FETCHPARAMETERS]=i,this[t._DATA]=s,this[t._METADATA]=n}}(),this.Item=function(){return function(e,i,s){this._parent=e,this.metadata=i,this.data=s,this[t._METADATA]=i,this[t._DATA]=s}}(),this.ItemMetadata=function(){return function(e,i){this._parent=e,this.key=i,this[t._KEY]=i}}(),this.FetchListParameters=function(){return function(e,i,s,n,o){this._parent=e,this.size=i,this.sortCriteria=s,this.filterCriterion=n,this.attributes=o,this[t._SIZE]=i,this[t._SORTCRITERIA]=s,this[t._FILTERCRITERION]=n,this[t._FETCHATTRIBUTES]=o}}(),this.FetchByKeysParameters=function(){return function(e,i,s){this._parent=e,this.keys=i,this.attributes=s,this[t._KEYS]=i,this[t._FETCHATTRIBUTES]=s}}(),this.FetchByOffsetParameters=function(){return function(e,i,s,n,o,r){this._parent=e,this.offset=i,this.size=s,this.sortCriteria=n,this.filterCriterion=o,this.attributes=r,this[t._SIZE]=s,this[t._SORTCRITERIA]=n,this[t._OFFSET]=i,this[t._FILTERCRITERION]=o,this[t._FETCHATTRIBUTES]=r}}(),this.FetchByKeysResults=function(){return function(e,i,s){this._parent=e,this.fetchParameters=i,this.results=s,this[t._FETCHPARAMETERS]=i,this[t._RESULTS]=s}}(),this.ContainsKeysResults=function(){return function(e,i,s){this._parent=e,this.containsParameters=i,this.results=s,this[t._CONTAINSPARAMETERS]=i,this[t._RESULTS]=s}}(),this.FetchByOffsetResults=function(){return function(e,i,s,n){this._parent=e,this.fetchParameters=i,this.results=s,this.done=n,this[t._FETCHPARAMETERS]=i,this[t._RESULTS]=s,this[t._DONE]=n}}(),this[t._FROM]=null==this.options?null:this.options[t._FROM],this[t._OFFSET]=null==this.options?0:this.options[t._OFFSET]>0?this.options[t._OFFSET]:0,this[t._SORTCRITERIA]=null==this.options?null:this.options[t._SORTCRITERIA],this[t._DATAMAPPING]=null==this.options?null:this.options[t._DATAMAPPING],this[t._FETCHATTRIBUTES]=null==this.options?null:this.options[t._FETCHATTRIBUTES],this[t._FILTERCRITERION]=null==this.options?null:this.options[t._FILTERCRITERION],this._addEventListeners(e),e.getCapability&&!e.getCapability("filter")&&(this._noFilterSupport=!0)}return t.prototype.containsKeys=function(e){var i=this;return this.dataProvider[t._CONTAINSKEYS]?this.dataProvider[t._CONTAINSKEYS](e):this.fetchByKeys(e).then(function(s){var n=new Set;return e[t._KEYS].forEach(function(e){null!=s[t._RESULTS].get(e)&&n.add(e)}),Promise.resolve(new i.ContainsKeysResults(i,e,n))})},t.prototype.fetchByKeys=function(e){var i=this,s=null!=e?e[t._KEYS]:null,n=null!=e?e[t._FETCHATTRIBUTES]:null;null==n&&(n=this[t._FETCHATTRIBUTES]);var o=new i.FetchByKeysParameters(i,s,n);if(this.dataProvider[t._FETCHBYKEYS])return this.dataProvider[t._FETCHBYKEYS](o).then(function(e){var s=e[t._RESULTS],n=new Map;return s.forEach(function(e,t){var s=i._getMappedItems([e]);n.set(t,s[0])}),new i.FetchByKeysResults(i,o,n)});var r=new this.FetchListParameters(this,t._DEFAULT_SIZE,null,null,n),a=new Map,l=this.dataProvider[t._FETCHFIRST](r)[Symbol.asyncIterator]();return this._fetchNextSet(e,l,a).then(function(e){var t=new Map;return e.forEach(function(e,s){var n=i._getMappedItems([e]);t.set(s,n[0])}),new i.FetchByKeysResults(i,o,t)})},t.prototype.fetchByOffset=function(e){var i=this,s=null!=e?e[t._OFFSET]:null,n=null!=e?e[t._SIZE]:null,o=null!=e?e[t._FETCHATTRIBUTES]:null;null==o&&(o=this[t._FETCHATTRIBUTES]);var r=null!=e?e[t._SORTCRITERIA]:null;null==r&&(r=this[t._SORTCRITERIA]);var a=this._getMappedSortCriteria(r),l=null!=e?e[t._FILTERCRITERION]:null,u=this._getMappedFilterCriterion(l),c=new i.FetchByOffsetParameters(i,s,n,a,u,o);return this.dataProvider[t._FETCHBYOFFSET](c).then(function(e){var s=e[t._RESULTS],n=e[t._DONE],o=new Array;return s.forEach(function(e){var t=i._getMappedItems([e]);o.push(t[0])}),new i.FetchByOffsetResults(i,c,o,n)})},t.prototype.fetchFirst=function(e){var i={};i[t._ITEMS]=[],i[t._DONE]=!1,i[t._STARTINDEX]=0;var s=null!=e?e[t._SIZE]:null,n=null!=e?e[t._SORTCRITERIA]:null;null==n&&(n=this[t._SORTCRITERIA]);var o=this._getMappedSortCriteria(n),r=null!=e?e[t._FILTERCRITERION]:null;null==r&&(r=this[t._FILTERCRITERION]);var a=this._getMappedFilterCriterion(r),l=null!=e?e[t._FETCHATTRIBUTES]:null;null==l&&(l=this[t._FETCHATTRIBUTES]);var u=this;if(null==u[t._FROM]&&u[t._OFFSET]>0){var c=u[t._OFFSET];return new this.AsyncIterable(this,new this.AsyncIterator(this,function(e){return function(){var i=new u.FetchByOffsetParameters(u,c,s,o,a,l);return u.dataProvider[t._FETCHBYOFFSET](i).then(function(i){var n=i.results;c+=n.length;var o=u._getMappedItems(n);u._cacheResult(e,o),e[t._DONE]=i[t._DONE];var r=o.map(function(e){return e[t._DATA]}),a=o.map(function(e){return e[t._METADATA]}),l=i[t._FETCHPARAMETERS],p=null!=l?l[t._SORTCRITERIA]:null,h=null!=l?l[t._FILTERCRITERION]:null,d=u._getUnmappedSortCriteria(p),_=u._getUnmappedFilterCriterion(h),f=new u.FetchByOffsetParameters(u,u[t._OFFSET],s,d,_);return Promise.resolve(new u.AsyncIteratorResult(u,new u.FetchListResult(u,f,r,a),e[t._DONE]))})}}(i),e))}var p=new this.FetchListParameters(this,s,o,a,l),h=this.dataProvider[t._FETCHFIRST](p)[Symbol.asyncIterator]();return new this.AsyncIterable(this,new this.AsyncIterator(this,function(i,s){return function(){return s.next().then(function(n){var o=n[t._VALUE][t._DATA],r=n[t._VALUE][t._METADATA],l=o.map(function(e,t){return new u.Item(u,r[t],o[t])});u._noFilterSupport&&u._filterResult(a,l);var c=u._getMappedItems(l);u._cacheResult(i,c),i[t._DONE]=n[t._DONE];var p=null!=e?e[t._SIZE]:null,h=(null!=e&&e[t._OFFSET],n[t._VALUE][t._FETCHPARAMETERS]),d=null!=h?h[t._SORTCRITERIA]:null,_=null!=h?h[t._FILTERCRITERION]:null,f=u._getUnmappedSortCriteria(d),g=u._getUnmappedFilterCriterion(_),v=new u.FetchListParameters(u,p,f,g);return u._fetchUntilKey(v,u[t._FROM],i,s).then(function(){return u._fetchUntilOffset(v,u[t._OFFSET]+i[t._STARTINDEX],o.length,i,s)})})}}(i,h),e))},t.prototype.getCapability=function(e){return this.dataProvider.getCapability(e)},t.prototype.getTotalSize=function(){return this.dataProvider.getTotalSize()},t.prototype.isEmpty=function(){return this.dataProvider.isEmpty()},t.prototype._fetchNextSet=function(i,s,n){var o=this;return s.next().then(function(r){var a=r[t._VALUE],l=a[t._DATA],u=a[t._METADATA],c=u.map(function(e){return e[t._KEY]}),p=!0;return i[t._KEYS].forEach(function(t){n.has(t)||c.map(function(i,s){e.Object.compareValues(i,t)&&n.set(t,new o.Item(o,u[s],l[s]))}),n.has(t)||(p=!1)}),p||r[t._DONE]?n:o._fetchNextSet(i,s,n)})},t.prototype._fetchUntilKey=function(i,s,n,o){var r=this;if(null!=s){var a=n[t._ITEMS].filter(function(i){if(e.KeyUtils.equals(i[t._METADATA][t._KEY],s))return!0});if(a.length>0){var l=n[t._ITEMS].indexOf(a[0]);n[t._ITEMS]=n[t._ITEMS].slice(l,n[t._ITEMS].length)}else{if(!n[t._DONE])return o.next().then(function(e){var i=e[t._VALUE][t._DATA],s=e[t._VALUE][t._METADATA],a=i.map(function(e,t){return new r.Item(r,s[t],i[t])}),l=r._getMappedItems(a);return r._cacheResult(n,l),n[t._DONE]=e[t._DONE],r._fetchUntilKey(e[t._FETCHPARAMETERS],l[t._KEYS],n,o)});n[t._ITEMS]=[]}}return Promise.resolve(null)},t.prototype._fetchUntilOffset=function(e,i,s,n,o){var r=this,a=null!=e&&e[t._SIZE]>0?e[t._SIZE]:s;i=i>0?i:0;var l=n[t._ITEMS].slice(i,i+a);if(this._noFilterSupport){var u=this._getMappedFilterCriterion(e[t._FILTERCRITERION]);this._filterResult(u,l)}if(l.length<a){if(n[t._DONE]){n[t._STARTINDEX]=n[t._STARTINDEX]+l.length;var c=l.map(function(e){return e[t._DATA]}),p=l.map(function(e){return e[t._METADATA]});return Promise.resolve(new r.AsyncIteratorResult(r,new r.FetchListResult(r,e,c,p),!0))}return o.next().then(function(s){var a=s[t._VALUE][t._DATA],l=s[t._VALUE][t._METADATA],u=a.map(function(e,t){return new r.Item(r,l[t],a[t])});if(r._noFilterSupport){var c=r._getMappedFilterCriterion(e[t._FILTERCRITERION]);r._filterResult(c,u)}var p=r._getMappedItems(u);return r._cacheResult(n,p),n[t._DONE]=s[t._DONE],r._fetchUntilOffset(s[t._VALUE][t._FETCHPARAMETERS],i,a.length,n,o)})}return n[t._STARTINDEX]=n[t._STARTINDEX]+l.length,c=l.map(function(e){return e[t._DATA]}),p=l.map(function(e){return e[t._METADATA]}),Promise.resolve(new r.AsyncIteratorResult(r,new r.FetchListResult(r,e,c,p),n[t._DONE]))},t.prototype._cacheResult=function(e,i){i.map(function(i){e[t._ITEMS].push(i)})},t.prototype._filterResult=function(e,s){if(e){e.filter||(e=i.FilterFactory.getFilter({filterDef:e}));for(var n=s.length-1;n>=0;)e.filter(s[n][t._DATA])||s.splice(n,1),n--}},t.prototype._getMappedItems=function(e){var i=this;if(null!=this[t._DATAMAPPING]){var s=this[t._DATAMAPPING][t._MAPFIELDS];if(null!=s&&null!=e&&e.length>0)return new Array,e.map(function(e){return s.bind(i)(e)})}return e},t.prototype._getMappedFilterCriterion=function(e){if(null!=this[t._DATAMAPPING]){var i=this[t._DATAMAPPING][t._MAPFILTERCRITERION];if(null!=i&&null!=e)return i(e)}return e},t.prototype._getMappedSortCriteria=function(e){if(null!=this[t._DATAMAPPING]){var i=this[t._DATAMAPPING][t._MAPSORTCRITERIA];if(null!=i&&null!=e&&e.length>0)return i(e)}return e},t.prototype._getUnmappedSortCriteria=function(e){if(null!=this[t._DATAMAPPING]){var i=this[t._DATAMAPPING][t._UNMAPSORTCRITERIA];if(null!=i&&null!=e&&e.length>0)return i(e)}return e},t.prototype._getUnmappedFilterCriterion=function(e){if(null!=this[t._DATAMAPPING]){var i=this[t._DATAMAPPING][t._UNMAPFILTERCRITERION];if(null!=i&&null!=e)return i(e)}return e},t.prototype._addEventListeners=function(e){var i=this;e[t._ADDEVENTLISTENER](t._REFRESH,function(e){i.dispatchEvent(e)}),e[t._ADDEVENTLISTENER](t._MUTATE,function(e){i.dispatchEvent(e)})},t._KEY="key",t._KEYS="keys",t._DATA="data",t._STARTINDEX="startIndex",t._SORT="sort",t._SORTCRITERIA="sortCriteria",t._FILTERCRITERION="filterCriterion",t._METADATA="metadata",t._ITEMS="items",t._FROM="from",t._OFFSET="offset",t._REFRESH="refresh",t._MUTATE="mutate",t._SIZE="size",t._FETCHPARAMETERS="fetchParameters",t._VALUE="value",t._DONE="done",t._DATAMAPPING="dataMapping",t._MAPFIELDS="mapFields",t._MAPSORTCRITERIA="mapSortCriteria",t._MAPFILTERCRITERION="mapFilterCriterion",t._UNMAPSORTCRITERIA="unmapSortCriteria",t._UNMAPFILTERCRITERION="unmapFilterCriterion",t._RESULTS="results",t._CONTAINSPARAMETERS="containsParameters",t._DEFAULT_SIZE=25,t._CONTAINSKEYS="containsKeys",t._FETCHBYKEYS="fetchByKeys",t._FETCHBYOFFSET="fetchByOffset",t._FETCHFIRST="fetchFirst",t._ADDEVENTLISTENER="addEventListener",t._FETCHATTRIBUTES="attributes",t}();return e.ListDataProviderView=s,e.ListDataProviderView=s,e.EventTargetMixin.applyMixin(s),s}),define("ojs/ojtreedataproviderview",["ojs/ojcore","jquery","ojs/ojlistdataproviderview","ojs/ojcomponentcore","ojs/ojeventtarget","ojs/ojdataprovider"],function(e,t,i){"use strict";var s=function(){function e(e,t){this.dataProvider=e,this.options=t,this._listDataProviderView=new i(e,t)}return e.prototype.getChildDataProvider=function(t,i){var s=this.dataProvider.getChildDataProvider(t,i);return s?new e(s,this.options):null},e.prototype.containsKeys=function(e){return this._listDataProviderView.containsKeys(e)},e.prototype.fetchByKeys=function(e){return this._listDataProviderView.fetchByKeys(e)},e.prototype.fetchByOffset=function(e){return this._listDataProviderView.fetchByOffset(e)},e.prototype.fetchFirst=function(e){return this._listDataProviderView.fetchFirst(e)},e.prototype.getCapability=function(e){return this._listDataProviderView.getCapability(e)},e.prototype.getTotalSize=function(){return this._listDataProviderView.getTotalSize()},e.prototype.isEmpty=function(){return this._listDataProviderView.isEmpty()},e.prototype.addEventListener=function(e,t){this._listDataProviderView.addEventListener(e,t)},e.prototype.removeEventListener=function(e,t){this._listDataProviderView.removeEventListener(e,t)},e.prototype.dispatchEvent=function(e){return this._listDataProviderView.dispatchEvent(e)},e}();return e.TreeDataProviderView=s,e.TreeDataProviderView=s,s}),define("ojs/ojselectcombobox",["ojs/ojcore","jquery","ojs/ojcontext","ojs/ojthemeutils","ojs/ojtimerutils","ojs/ojcomponentcore","ojs/ojlogger","ojs/ojeditablevalue","ojs/ojoptgroup","ojs/ojoption","promise","ojs/ojlistdataproviderview","ojs/ojtreedataproviderview"],function(e,t,i,s,n,o,r){"use strict";var a,l={properties:{asyncValidators:{type:"Array<Object>",value:[]},converter:{type:"object",properties:{type:{type:"string",enumValues:["datetime","number"]},options:{type:"object"}}},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string",value:["placeholder","notewindow"]},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string",value:["inline"]},validatorHint:{type:"Array<string>|string",value:["notewindow"]}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelHint:{type:"string",value:""},labelledBy:{type:"string"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},minLength:{type:"number",value:0},optionRenderer:{type:"function"},options:{type:"Array<Object>|object"},optionsKeys:{type:"object",properties:{childKeys:{type:"object",properties:{label:{type:"string"},value:{type:"string"},children:{type:"string"},childKeys:{type:"object",properties:{label:{type:"string"},value:{type:"string"},children:{type:"string"},childKeys:{type:"object"}}}}},children:{type:"string"},label:{type:"string"},value:{type:"string"}}},pickerAttributes:{type:"object",properties:{style:{type:"string"},class:{type:"string"}}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},required:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{filterFurther:{type:"string"},moreMatchesFound:{type:"string"},noMatchesFound:{type:"string"},oneMatchesFound:{type:"string"},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}}}},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array",value:[]},value:{type:"Array<any>",writeback:!0},valueOptions:{type:"Array<Object>",writeback:!0}},methods:{refresh:{},validate:{},reset:{},showMessages:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateStart:{},ojAnimateEnd:{}},extension:{}},u={properties:{asyncValidators:{type:"Array<Object>",value:[]},converter:{type:"object",properties:{type:{type:"string",enumValues:["datetime","number"]},options:{type:"object"}}},describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string",value:["placeholder","notewindow"]},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string",value:["inline"]},validatorHint:{type:"Array<string>|string",value:["notewindow"]}}},filterOnOpen:{type:"string",enumValues:["none","rawValue"],value:"none"},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelHint:{type:"string",value:""},labelledBy:{type:"string"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},minLength:{type:"number",value:0},optionRenderer:{type:"function"},options:{type:"Array<Object>|object"},optionsKeys:{type:"object",properties:{childKeys:{type:"object",properties:{label:{type:"string"},value:{type:"string"},children:{type:"string"},childKeys:{type:"object",properties:{label:{type:"string"},value:{type:"string"},children:{type:"string"},childKeys:{type:"object"}}}}},children:{type:"string"},label:{type:"string"},value:{type:"string"}}},pickerAttributes:{type:"object",properties:{style:{type:"string"},class:{type:"string"}}},placeholder:{type:"string"},rawValue:{type:"string",writeback:!0,readOnly:!0},readonly:{type:"boolean",value:!1},required:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{filterFurther:{type:"string"},moreMatchesFound:{type:"string"},noMatchesFound:{type:"string"},oneMatchesFound:{type:"string"},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}}}},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},validators:{type:"Array",value:[]},value:{type:"any",writeback:!0},valueOption:{type:"object",writeback:!0,properties:{value:{type:"any"},label:{type:"string"}}}},methods:{refresh:{},validate:{},reset:{},showMessages:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojValueUpdated:{},ojAnimateStart:{},ojAnimateEnd:{}},extension:{}},c={properties:{describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string",value:["placeholder","notewindow"]},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string",value:["inline"]},validatorHint:{type:"Array<string>|string",value:["notewindow"]}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelHint:{type:"string",value:""},labelledBy:{type:"string"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},minimumResultsForSearch:{type:"number",value:15},optionRenderer:{type:"function"},options:{type:"Array<Object>|object"},optionsKeys:{type:"object",properties:{childKeys:{type:"object",properties:{label:{type:"string"},value:{type:"string"},children:{type:"string"},childKeys:{type:"object"}}},children:{type:"string"},label:{type:"string"},value:{type:"string"}}},pickerAttributes:{type:"object",properties:{style:{type:"string"},class:{type:"string"}}},placeholder:{type:"string"},readonly:{type:"boolean",value:!1},renderMode:{type:"string",enumValues:["jet","native"]},required:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{filterFurther:{type:"string"},moreMatchesFound:{type:"string"},noMatchesFound:{type:"string"},oneMatchesFound:{type:"string"},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}},searchField:{type:"string"}}},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},value:{type:"Array<any>",writeback:!0},valueOptions:{type:"Array<Object>",writeback:!0}},methods:{refresh:{},validate:{},reset:{},showMessages:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateStart:{},ojAnimateEnd:{}},extension:{}},p={properties:{describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string",value:["placeholder","notewindow"]},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string",value:["inline"]},validatorHint:{type:"Array<string>|string",value:["notewindow"]}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelHint:{type:"string",value:""},labelledBy:{type:"string"},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},minimumResultsForSearch:{type:"number",value:15},optionRenderer:{type:"function"},options:{type:"Array<Object>|object"},optionsKeys:{type:"object",properties:{childKeys:{type:"object",properties:{label:{type:"string"},value:{type:"string"},children:{type:"string"},childKeys:{type:"object"}}},children:{type:"string"},label:{type:"string"},value:{type:"string"}}},pickerAttributes:{type:"object",properties:{style:{type:"string"},class:{type:"string"}}},placeholder:{type:"string"},readonly:{type:"boolean",value:!1},renderMode:{type:"string",enumValues:["jet","native"]},required:{type:"boolean",value:!1},translations:{type:"object",value:{},properties:{filterFurther:{type:"string"},moreMatchesFound:{type:"string"},noMatchesFound:{type:"string"},oneMatchesFound:{type:"string"},required:{type:"object",properties:{hint:{type:"string"},messageDetail:{type:"string"},messageSummary:{type:"string"}}},searchField:{type:"string"}}},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},value:{type:"any",writeback:!0},valueOption:{type:"object",writeback:!0,properties:{value:{type:"any"},label:{type:"string"}}}},methods:{refresh:{},validate:{},reset:{},showMessages:{},setProperty:{},getProperty:{},setProperties:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateStart:{},ojAnimateEnd:{}},extension:{}},h={GENERATED_OPTIONS_SELECTOR:"oj-select-options-generated",KEY:{TAB:9,ENTER:13,ESC:27,SPACE:32,LEFT:37,UP:38,RIGHT:39,DOWN:40,SHIFT:16,CTRL:17,ALT:18,PAGE_UP:33,PAGE_DOWN:34,HOME:36,END:35,BACKSPACE:8,DELETE:46,isControl:function(e){switch(e.which){case h.KEY.SHIFT:case h.KEY.CTRL:case h.KEY.ALT:return!0;default:return!!e.metaKey}},isFunctionKey:function(e){var t=e.which?e.which:e;return t>=112&&t<=123}},DEFAULT_FETCH_SIZE:15,FILTERING_FETCH_SIZE:100,DEFAULT_QUERY_DELAY:70,ValueChangeTriggerTypes:{ENTER_PRESSED:"enter_pressed",OPTION_SELECTED:"option_selected",BLUR:"blur",SEARCH_ICON_CLICKED:"search_icon_clicked"},lastMousePosition:{x:0,y:0},nextUid:(a=1,function(){var e=a;return a+=1,e}),scrollBarDimensions:null,each2:function(e,i){for(var s=t(t.isFunction(e[0])?e[0]():e[0]),n=-1,o=e.length;++n<o&&(s.context=s[0]=t.isFunction(e[0])?e[n]():e[n])&&!1!==i.call(s[0],n,s););return e},measureScrollbar:function(){var e=t("<div class='oj-listbox-measure-scrollbar'></div>");e.appendTo("body");var i={width:e.width()-e[0].clientWidth,height:e.height()-e[0].clientHeight};return e.remove(),i},splitVal:function(e,i){var s,n,o;if(null===e||e.length<1)return[];for(n=0,o=(s=e.split(i)).length;n<o;n++)s[n]=t.trim(s[n]);return s},getSideBorderPadding:function(e){return e.outerWidth(!1)-e.width()},installKeyUpChangeEvent:function(e){var i="keyup-change-value";e.on("keydown",function(){void 0===t.data(e,i)&&t.data(e,i,e.val())}),e.on("keyup",function(s){if(s.which!==h.KEY.ENTER){var n=t.data(e,i);void 0!==n&&e.val()!==n&&(t.removeData(e,i),e.trigger("keyup-change"))}else s.preventDefault()})},getSearchText:function(e){var t,i=e.which||e.keyCode;return e&&"keydown"===e.type&&(32===i||i>47&&i<58||i>64&&i<91||i>95&&i<112||i>185&&i<193||i>218&&i<223)&&(i>=96&&i<=105&&(i-=48),t=String.fromCharCode(i),e.shiftKey||(t=t.toLowerCase()),e.preventDefault()),t},installFilteredMouseMove:function(e){e.on("mousemove",function(e){var i=h.lastMousePosition;void 0!==i&&i.x===e.pageX&&i.y===e.pageY||(t(e.target).trigger("mousemove-filtered",e),h.lastMousePosition.x=e.pageX,h.lastMousePosition.y=e.pageY)})},thunk:function(e){var t,i=!1;return function(){return!1===i&&(t=e(),i=!0),t}},_focus:function(e,t){if(t[0]!==document.activeElement){var i=h._addBusyState(e.container,"setting focus");n.getTimer(40).getPromise().then(function(){var e,s=t[0],n=t.val().length;t.focus(),t.is(":visible")&&s===document.activeElement&&(s.setSelectionRange?s.setSelectionRange(n,n):s.createTextRange&&((e=s.createTextRange()).collapse(!1),e.select())),i()})}},getCursorInfo:function(e){var i=t(e)[0],s=0,n=0;if("selectionStart"in i)s=i.selectionStart,n=i.selectionEnd-s;else if("selection"in document){i.focus();var o=document.selection.createRange();n=document.selection.createRange().text.length,o.moveStart("character",-i.value.length),s=o.text.length-n}return{offset:s,length:n}},killEvent:function(e){e.preventDefault()},local:function(e,i){var s,n,o=e,r=function(e){return""+e.label};t.isArray(o)&&(o={results:n=o}),!1===t.isFunction(o)&&(n=o,o=function(){return n});var a=o();return a&&a.text&&(r=a.text,t.isFunction(r)||(s=a.text,r=function(e){return e[s]})),function(e){var s=e.term,n={results:[]};""!==s||i?(o()&&h.each2(t(o().results),function(t,s){h._processData(e,s,n.results,i,!0,r)}),e.callback(n)):e.callback(o())}},createOptionTag:function(e,i,s,n){var o=t("<option>");return o.addClass("oj-listbox-result oj-listbox-result-selectable oj-listbox-results-depth-"+e),o.attr("role","option"),o.attr("id","oj-listbox-result-label-"+h.nextUid()),o.text(n(s)),o.attr("value",i),o},createOptgroupTag:function(e,i,s){var n=t("<optgroup>");return n.addClass("oj-listbox-results-sub"),n.attr("label",s(i)),e.addClass("oj-listbox-result-with-children"),n},listPopulateResults:function(e,i,s){var n=function(e,i,o){var r,a,l,u;i.each(function(){(a=t(this)).is("li")&&(a.children("ul").length>0?(l=a.contents().filter(function(){return 1!==this.nodeType||"ul"!==this.tagName.toLowerCase()}).text(),r=h.createOptgroupTag(e,l,s),u=a.children("ul"),n(r,u.children(),o+1)):r=h.createOptionTag(o,a.attr("oj-data-value"),a.text(),s),r.appendTo(e))})};n(e,i,0)},ojOptionPopulateResults:function(e,i,s){var n=function(e,i,o){var r,a,l;i.each(function(){(a=t(this)).is("oj-option")?(l=a.text()||a.attr("label"),r=h.createOptionTag(o,a.prop("value"),l,s)):a.is("oj-optgroup")?(l=a.text()||a.attr("label"),r=h.createOptgroupTag(e,l,s),n(r,a.children(),o+1)):a.is("option")&&(r=a),r.appendTo(e)})};n(e,i,0)},lookupOptionKeys:function(e,t,i){return e[t[i]||i]},arrayPopulateResults:function(e,t,i,s){var n=function(e,t,s,o){for(var r,a,l,u,c,p=0,d=t.length;p<d;p++)r=t[p],l=h.lookupOptionKeys(r,o,"children"),u=h.lookupOptionKeys(r,o,"label"),l&&l.length>0?(a=h.createOptgroupTag(e,u,i),n(a,l,s+1,o.childKeys||{})):(c=h.lookupOptionKeys(r,o,"value"),a=h.createOptionTag(s,c,u,i)),a.appendTo(e)};n(e,t,0,s||{})},cleanupResults:function(e){e.children().not("oj-option, oj-optgroup").remove(),e.removeClass("oj-listbox-result-with-children")},_addBusyState:function(e,t){var s={description:"The component identified by '"+e.attr("id")+"' "+t};return i.getContext(e[0]).getBusyContext().addBusyState(s)},_clearBusyState:function(e){e&&e()},isDataProvider:function(t){return!(!t||!e.DataProviderFeatureChecker)&&e.DataProviderFeatureChecker.isDataProvider(t)},isTreeDataProvider:function(t){return!(!t||!e.DataProviderFeatureChecker)&&e.DataProviderFeatureChecker.isTreeDataProvider(t)},getDataProvider:function(e){if(e){var t=e._dataProvider||e.options;if(h.isDataProvider(t))return t}return null},clearDataProviderWrapper:function(e){e.options._dataProvider=null},_findOption:function(t,i){if(t.children){var s=h._findOption(t.children,i);if(s)return s}else if(e.Object.compareValues(i,t.value))return t;return null},findOption:function(e,t){if(Array.isArray(e)){for(var i=0,s=e.length;i<s;i++){var n=h._findOption(e[i],t);if(n)return n}return null}return h._findOption(e,t)},findOptions:function(e,t){for(var i=[],s=0;s<t.length;s++){var n=h.findOption(e,t[s]);n&&i.push(n)}return i},findOptionFromResult:function(e,t,i){var s,n=h.getLastQueryResult(e);return n&&(s=h.findOption(n,t)),s?{value:t,label:s.label}:i},mergeValueAndValueOptions:function(e){var t=e.options.value,i=!1;if(e.multiple){var s,n=e.options.valueOptions;t&&t.length>0?(n&&n.length&&(s=h.findOptions(n,t)),s&&s.length===n.length||(i=!0)):n&&h.syncValueWithValueOptions(e,n,t,null)}else{var o,r=e.options.valueOption;null!=t?(r&&(o=h.findOption(r,t)),o||(i=!0)):r&&h.syncValueWithValueOption(e,r,t,null)}return i},syncValueWithValueOption:function(i,s,n,o){var r,a=!0;if(h.isValueOptionsForPlaceholder(!1,s)?h.isValueForPlaceholder(!1,n)?(r=n,a=!1):r=null:r=s?s.value:null,e.Object.compareValues(r,n)){if(!0===o){var l=i.element[0];t(l.options[l.selectedIndex]).text(h.getLabel(s))}else if(!1===o){var u=i.select||i.combobox
;u&&a&&u._updateSelection(s)}}else h._forceSetValue(i,r)},syncValueWithValueOptions:function(i,s,n,o){var r,a=!0;if(h.isValueOptionsForPlaceholder(!0,s))h.isValueForPlaceholder(!0,n)?(r=n,a=!1):r=h.getValueForPlaceholder(!0),e.Object.compareValues(r,n)||h._forceSetValue(i,r);else if(s){r=[];for(var l=0;l<s.length;l++)r.push(s[l].value);if(e.Object.compareValues(r,n)){if(!0===o){var u=0;i.element.find("option").each(function(){if(this.selected){var e=h.getLabel(s[u]);this.text!=e&&t(this).text(e),u+=1}})}else if(!1===o){var c=i.select||i.combobox;c&&a&&c._updateSelection(s)}}else h._forceSetValue(i,r)}},_forceSetValue:function(e,t){var i=e;i.forceCanSetValue=!0;try{i._SetValue(t,null,{doValueChangeCheck:!1,_context:{internalSet:!0,writeback:!0}})}finally{delete i.forceCanSetValue}},isPlaceholderSpecified:function(e){return"string"==typeof e.placeholder},getFixupValueOptionsForPlaceholder:function(e){return e?[]:{value:null,label:null}},isValueOptionsForPlaceholder:function(t,i){return null==i||!t&&null==i.value||e.Object.compareValues(i,h.getFixupValueOptionsForPlaceholder(t))},getValueOptionsForPlaceholder:function(e,t){var i=e.multiple;return e._IsCustomElement()&&h.isPlaceholderSpecified(e.options)&&h.isValueOptionsForPlaceholder(i,t)&&(t=h.getFixupValueOptionsForPlaceholder(i)),t},getValueForPlaceholder:function(e){return e?[]:""},isValueForPlaceholder:function(t,i){return null==i||e.Object.compareValues(i,h.getValueForPlaceholder(t))},setValueOptions:function(e,t){var i,s,n={internalSet:!0,changed:!0,writeback:!0};if(e.combobox&&e.combobox.opts?i=e.combobox.opts:e.select&&e.select.opts&&(i=e.select.opts),e.multiple){if(t&&t.length){s=[];for(var o=0;o<t.length;o++)s.push({value:t[o].value,label:t[o].label})}else s=t;e.option("valueOptions",s,{_context:n}),i&&(i.valueOptions=s)}else{var r=t;Array.isArray(t)&&(r=t[0]),r&&!h.isValueOptionsForPlaceholder(e.multiple,r)?(s={value:r.value,label:r.label},e.option("valueOption",{value:r.value,label:r.label},{_context:n})):s=r,e.option("valueOption",s,{_context:n}),i&&(i.valueOption=s)}},updateValueOptions:function(e){if(e){var t=e.datalist?e.datalist:e.opts.element;e.opts.initSelection.call(null,t,function(t){var i=e.ojContext.multiple,s=t;if(void 0===s&&"oj-combobox"===e._classNm){var n=e.ojContext.options.value;if(i){s=[];for(var o=0;o<n.length;o++)s.push(e.opts.manageNewEntry(n[o]))}else s=e.opts.manageNewEntry(n)}s&&(e.setValOpts(s),i?e._updateSelection(s):e._updateSelectedOption(s))})}},applyValueOptions:function(e,t){if(e&&!e.ojContext._resolveValueOptionsLater&&("oj-combobox"===e._classNm||"oj-select"===e._classNm)){var i=e.ojContext.multiple,s=i?t.valueOptions:t.valueOption;if(h.isValueOptionsForPlaceholder(i,s))return!1;if(s)return e._updateSelection(s),!0}return!1},isValueChanged:function(e){return e._valueHasChanged},setValueChanged:function(e,t){e._valueHasChanged=t},wrapDataProviderIfNeeded:function(t,i){var s=t.options,n=s.options;if(h.isDataProvider(n)){var o,r=s.optionsKeys;if(r&&(null!=r.label||null!=r.value)){var a=h.isTreeDataProvider(n);if(a&&!(n instanceof e.TreeDataProviderView)||!a&&!(n instanceof e.ListDataProviderView)){var l=function(e){for(var t=e.data,i={data:{}},s=Object.keys(t),n=0;n<s.length;n++){var o=s[n];i.data[o]=t[o]}return null!=r.label&&(i.data.label=t[r.label]),null!=r.value&&(i.data.value=t[r.value]),i.metadata={key:t[r.value]},i};o=a?new e.TreeDataProviderView(n,{dataMapping:{mapFields:l}}):new e.ListDataProviderView(n,{dataMapping:{mapFields:l}})}}o&&(s._dataProvider=o,i&&(i._dataProvider=o))}},getLabel:function(e){return null!=e.label?e.label:String(e.value)},_handleDataProviderEvents:function(e,t){if("mutate"===t.type&&null!=t.detail.remove){for(var i=t.detail.remove.data,s=!1,n=[].concat(e.options.value),o=0;o<i.length;o++){var r=n.indexOf(i[o].value);r>=0&&(n.splice(r,1),s=!0)}s&&e._setOption("value",n)}e._setOption("options",e.options.options)},addDataProviderEventListeners:function(e){var t=h.getDataProvider(e.options);if(t){h.removeDataProviderEventListeners(e);var i=h._handleDataProviderEvents.bind(null,e);e._saveDataProviderEH=i,t.addEventListener("mutate",i),t.addEventListener("refresh",i)}},removeDataProviderEventListeners:function(e){var t=h.getDataProvider(e.options),i=e._saveDataProviderEH;null!=t&&i&&(t.removeEventListener("mutate",i),t.removeEventListener("refresh",i),e._saveDataProviderEH=void 0)},addLoadingIndicator:function(e){var i=e;if(void 0===i._loadingIndicatorCount?i._loadingIndicatorCount=1:i._loadingIndicatorCount+=1,null==i._saveLoadingIndicator){var s=t(document.createElement("div"));s.uniqueId().attr("role","presentation").addClass("oj-listbox-loading-icon-container");var n=t(document.createElement("div"));n.addClass("oj-icon oj-listbox-loading-icon"),s.append(n),i.prepend(s),i._saveLoadingIndicator=s}},removeLoadingIndicator:function(e){var t=e;void 0!==t._loadingIndicatorCount&&(1===t._loadingIndicatorCount?(t._loadingIndicatorCount=void 0,null!=t._saveLoadingIndicator&&(t._saveLoadingIndicator.remove(),t._saveLoadingIndicator=void 0)):t._loadingIndicatorCount-=1)},addDropdownMessage:function(e,i,s){if(!e._saveDropdownMessage){var n=t(document.createElement("div"));n.addClass("oj-listbox-filter-message-box");var o=t(document.createElement("div"));o.addClass("oj-listbox-filter-message-text oj-listbox-liveregion"),o.attr({role:"region","aria-live":"polite"});var r=t(document.createElement("div"));r.addClass("oj-listbox-filter-message-separator"),n.append(o),n.append(r),e.prepend(n),o.text(s),e._saveDropdownMessage=n}},removeDropdownMessage:function(e){e._saveDropdownMessage&&(e._saveDropdownMessage.remove(),e._saveDropdownMessage=void 0)},fetchFlatData:function(e,t,i,s,n,o){var r=[],a=t.fetchFirst(i)[Symbol.asyncIterator]();return a.next().then(function t(l){if(l){var u=l.value.data;if(u)if(i.filterCriterion){if(u.length>0&&r.length<o){var c=u.slice(0,o-r.length);r=r.concat(c)}}else for(var p,d=0;d<u.length&&r.length<o;d++)p=u[d],s&&s.matcher&&!s.matcher(s.term,h.getLabel(p),p)||r.push(p);if(n&&h.removeDropdownMessage(n),n&&!l.done&&r.length>=o)h.addDropdownMessage(n,e,e.getTranslatedString("filterFurther")),e._hasMore=!0;else{if(!l.done&&r.length<o)return a.next().then(t);e._hasMore=!1}}return Promise.resolve(r)})},fetchTreeData:function(e,t,i,s,n){var o=i.size;return e._hasMore=!1,n&&h.removeDropdownMessage(n),function t(n){i.size=o;var r=[],a=n.fetchFirst(i)[Symbol.asyncIterator]();return a.next().then(function l(u){function c(e,t){var a=!s||!s.matcher||i.filterCriterion||s.matcher(s.term,h.getLabel(e),e),l=null==n.getChildDataProvider(e.value);if(l||(a=!1),a&&0===t.length&&(o-=1),a||t.length>0){var u={label:e.label,value:e.value,data:e};e.disabled&&(u.disabled=!0),l&&!u.disabled||(u._jetUnSelectable=!0),t.length>0&&(u.children=t),r.push(u)}}var p=u.value.data;return function i(s){if(s<p.length){if(o>0){var a=p[s],l=n.getChildDataProvider(a.value);return l?t(l).then(function(e){return c(a,e),i(s+1)}):(c(a,[]),i(s+1))}e._hasMore=!0}return Promise.resolve(r)}(0).then(function(){return u.done||o<=0?(u.done||(e._hasMore=!0),Promise.resolve(r)):a.next().then(l)})})}(t).then(function(t){return e._hasMore&&n&&h.addDropdownMessage(n,e,e.getTranslatedString("filterFurther")),t})},fetchFilteredData:function(t,i,s,n){var o=h.getDataProvider(t.options),r={size:i},a=o.getCapability("filter"),l=e.AttributeFilterOperator.AttributeOperator.$co,u=e.AttributeFilterOperator.AttributeOperator.$regex,c=!1,p=!1;if(a){var d=a.operators;d&&d.length>0&&(d.indexOf(l)>=0||d.indexOf(u)>=0)&&(c=!0,d.indexOf(u)>=0&&(p=!0))}var _=h.isTreeDataProvider(o);if(s&&s.term)if(c){var f,g=t.options.optionsKeys;f=g&&g.label?g.label:"label",r.filterCriterion=p?{op:u,attribute:f,value:new RegExp(s.term,"i")}:{op:l,attribute:f,value:s.term}}else _||(r.size=h.FILTERING_FETCH_SIZE);return _?h.fetchTreeData(t,o,r,s,n):h.fetchFlatData(t,o,r,s,n,i)},rejectedError:{},fetchFromDataProvider:function(e,t,i,s){var n=e.ojContext;n._fetchResolveFunc||(n._fetchResolveFunc=h._addBusyState(e.container,"fetching data")),n._saveRejectFunc&&n._saveRejectFunc(h.rejectedError);var o=new Promise(function(e,t){n._saveRejectFunc=t});e.selection&&"init"===t.fetchType&&!n._spinnerContainer&&(n._spinnerContainer=e.selection,h.addLoadingIndicator(n._spinnerContainer),t.fetchType=null);var r=s||t.fetchSize||h.DEFAULT_FETCH_SIZE,a=h.fetchFilteredData(n,r,i,e.dropdown).then(function(e){return n._resultCount=e?e.length:0,e});Promise.race([o,a]).then(function(t){n._saveRejectFunc=null,n._spinnerContainer&&(h.removeLoadingIndicator(n._spinnerContainer),n._spinnerContainer=void 0),n._resolveSearchBoxLater&&e._showSearchBox(""),i.callback({results:t}),n._fetchResolveFunc&&(n._fetchResolveFunc(),n._fetchResolveFunc=null)},function(e){e!==h.rejectedError&&n._fetchResolveFunc&&(i.callback(),n._fetchResolveFunc(),n._fetchResolveFunc=null)})},fetchFirstBlockFromDataProvider:function(e,t,i){var s=h.getDataProvider(t),n=h._addBusyState(e,"fetching selected data"),o={size:i||h.DEFAULT_FETCH_SIZE};return h.isTreeDataProvider(s)?h.fetchTreeData({},s,o,null,null).then(function(e){if(1===i&&e&&e.length>0){for(var t=e[0];t.children;)t=t.children[0];e=[t]}return h._clearBusyState(n),e},function(){return h._clearBusyState(n),null}):s.fetchFirst(o)[Symbol.asyncIterator]().next().then(function(e){return h._clearBusyState(n),e.value.data},function(){return h._clearBusyState(n),null})},duringFetchByKey:function(e){return e._fetchByKeys},fetchByKeyFromDataProvider:function(t,i,s){var n,o=h.getDataProvider(i),r=t&&t.selection?t.container:t,a=h._addBusyState(r,"fetching selected data");t&&t.selection&&("init"!==t.opts.fetchType||r._spinnerContainer||(r._spinnerContainer=t.selection,h.addLoadingIndicator(r._spinnerContainer))),r._fetchByKeys&&r._fetchByKeys.promise&&e.Object.compareValues(s.value,r._fetchByKeys.key)?n=r._fetchByKeys.promise:(n=o.fetchByKeys({keys:s.value}),r._fetchByKeys={key:s.value,promise:n}),n.then(function(e){r._fetchByKeys=void 0,r._spinnerContainer&&(h.removeLoadingIndicator(r._spinnerContainer),r._spinnerContainer=void 0);var t=[];e.results.forEach(function(e){t.push(e.data)}),s.callback({results:t}),h._clearBusyState(a)},function(){r._fetchByKeys=void 0,s.callback(),h._clearBusyState(a)})},validateFromDataProvider:function(e,t,i){return new Promise(function(s,n){h.fetchByKeyFromDataProvider(e,t,{value:Array.isArray(i)?i:[i],callback:function(e){var t=null;if(e&&e.results.length){(t={}).value=[],t.valueOptions=[];for(var i=0;i<e.results.length;i++)t.valueOptions.push(e.results[i]),t.value.push(e.results[i].value)}s(t)}})})},isReadonly:function(e){return e._IsCustomElement()&&(e.options.readOnly||"loading"===e.options.loading)},remote:function(e,i){return function(s){var n={component:this.ojContext};s.value?n.value=s.value:n.term=s.term||"",e(n).then(function(e){var n={results:[]};e&&h.each2(t(e),function(e,t){h._processData(s,t,n.results,i,!1)}),s.callback(n)})}},_processData:function(e,i,s,n,o,r){var a,l=i[0];if(!l.label&&n&&n.label&&(l.label=l[n.label]),!l.value&&n&&n.value&&(l.value=l[n.value]),!l.children&&n&&n.children&&(l.children=l[n.children],delete l[n.children]),l.children){a={};for(var u=Object.keys(l),c=0;c<u.length;c++){var p=u[c];a[p]=l[p]}a.children=[],h.each2(t(l.children),function(t,i){h._processData(e,i,a.children,n&&n.childKeys?n.childKeys:null,o,r)}),(!o||e.matcher(e.term,r(a),l)||a.children.length)&&s.push(a)}else o&&!e.matcher(e.term,r(l),l)||s.push(l)},checkFormatter:function(e,i,s){if(t.isFunction(i))return!0;if(!i)return!1;throw new Error(s+" must be a function or a false value")},clazz:function(i,s){var n=function(){};return e.Object.createSubclass(n,i,""),n.prototype=t.extend(n.prototype,s),n},LAST_QUERY_RESULT:"last-query-result",getLastQueryResult:function(e){return t.data(e.container,e._classNm+"-"+h.LAST_QUERY_RESULT)},saveLastQueryResult:function(e,i){t.data(e.container,e._classNm+"-"+h.LAST_QUERY_RESULT,i)}},d={closeOnSelect:!0,openOnEnter:!0,formatNoMatches:function(e){return e.getTranslatedString("noMatchesFound")},formatMoreMatches:function(e,t){return 1===t?e.getTranslatedString("oneMatchesFound"):e.getTranslatedString("moreMatchesFound",{num:""+t})},id:function(e){return e.id},matcher:function(e,t){return(""+t).toUpperCase().indexOf((""+e).toUpperCase())>=0},separator:","},_=h.clazz(Object,{_bind:function(e){var t=this;return function(){e.apply(t,arguments)}},_customOptionRenderer:function(e){var i,s=this;e.each(function(){(i=t(this)).is("oj-option")?i.wrap("<li></li>"):i.is("oj-optgroup")&&(i.wrap("<li></li>"),s._customOptionRenderer(i.children()),i.children().wrapAll("<ul class='oj-listbox-result-sub'></ul>"))})},_init:function(e){var i,s,n=this._classNm,o=this._elemNm;this.ojContext=e.ojContext;var r=this._prepareOpts(e);this.opts=r,this.id=r.id,this.headerInitialized=!1,this.isOjOption=this.ojContext._IsCustomElement()&&!r.options&&r.element.find("oj-option").length>0,void 0!==r.element.data(o)&&null!==r.element.data(o)&&r.element.data(o)._destroy(),this.container=this._createContainer(),this.container.find(".oj-listbox-drop").css("display","none");var a=r.rootAttributes;this.containerId=a&&a.id?a.id:"ojChoiceId_"+(this._getAttribute("id")||"autogen"+h.nextUid()),this.containerSelector="#"+this.containerId.replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g,"\\$1"),this.container.attr("id",this.containerId),this.body=h.thunk(function(){return r.element.closest("body")}),this._getAttribute("style")&&this.container.attr("style",this._getAttribute("style")),this.elementTabIndex=this._getAttribute("tabindex"),this.opts.element.data(o,this).attr("tabindex","-1").before(this.container),this.container.data(o,this),this.dropdown=this.container.find(".oj-listbox-drop"),this.dropdown.data("ojlistbox",this),this._setPickerAttributes(r.pickerAttributes);var l=this.containerId;if(this.dropdown.attr("data-oj-containerid",l),i=this.container.find(".oj-listbox-results"),this.results=i,this.results.on("click",h.killEvent),!this.ojContext._IsCustomElement()){var u=this.ojContext.element.attr("aria-label");u&&i.attr("aria-label",u)}if(r.list&&t("#"+r.list).is("ul")){var c=t("#"+r.list);this.dropdownListParent=c.parent(),c.addClass("oj-listbox-results").attr("role","listbox"),this.results.replaceWith(c),i=this.container.find(".oj-listbox-results"),this.results=i,this.results.css("display","")}if(this.isOjOption){var p=r.element.children();this._customOptionRenderer(p),this.results.append(r.element.children()),this.datalist=this.results}s="oj-select"===n?this.container.find("input.oj-listbox-input"):this.container.find("input."+n+"-input"),this.search=s,this.queryCount=0,this.resultsPage=0,this.context=null,this._initContainer(),this.container.on("click",h.killEvent),h.installFilteredMouseMove(this.results),this.dropdown.on("mousemove-filtered touchstart touchmove touchend",".oj-listbox-results",this._bind(this._highlightUnderEvent)),t(this.container).on("change","."+n+"-input",function(e){e.stopPropagation()}),t(this.dropdown).on("change","."+n+"-input",function(e){e.stopPropagation()});var d=this;if(h.installKeyUpChangeEvent(s),s.on("keyup-change input paste",this._bind(this._updateResults)),s.on("focus",function(){s.addClass(n+"-focused"),"oj-select"!==n&&d.container.addClass("oj-focus")}),s.on("blur",function(){s.removeClass(n+"-focused"),"oj-select"!==n&&d.container.removeClass("oj-focus")}),this.dropdown.on("mouseup",".oj-listbox-results",this._bind(function(e){t(e.target).closest(".oj-listbox-result-selectable").length>0&&(this._highlightUnderEvent(e),this._selectHighlighted(null,e))})),this.dropdown.on("click mouseup mousedown",function(e){e.stopPropagation()}),t.isFunction(this.opts.initSelection)){this.opts.fetchType="init";var _=this.getValOpts();(!this.ojContext.multiple||_&&0!==_.length)&&(this.ojContext.multiple||_)||(_=null),this._initSelection(_)}var f=r.element.prop("readonly");void 0===f&&(f=!1),this._readonly(f);var g=r.element.prop("disabled");void 0===g&&(g=!1),this._enable(!g),h.scrollBarDimensions=h.scrollBarDimensions||h.measureScrollbar(),this.autofocus=r.element.prop("autofocus"),r.element.prop("autofocus",!1),this.autofocus&&this._focus(),h.addDataProviderEventListeners(r.ojContext),this.applyReadonlyState()},applyReadonlyState:function(){var t=this.ojContext._GetContentElement();if(h.isReadonly(this.ojContext)){if(this.container.addClass("oj-read-only"),"oj-combobox"===this._classNm)if(this.ojContext.multiple){if(t=null,this.selection.attr("tabindex","0"),this.ojContext.options.labelledBy){var i=this.uuid+"_Label",s=e.EditableValueUtils._getOjLabelAriaLabelledBy(this.ojContext.options.labelledBy,i);s&&this.selection.attr("aria-labelledby",s)}}else t.attr("readonly",!0);else"oj-select"===this._classNm&&t.attr("aria-readonly","true");t&&(t.removeAttr("role"),t.removeAttr("aria-expanded"))}else this.container.removeClass("oj-read-only"),"oj-combobox"===this._classNm?this.ojContext.multiple?(t=null,this.selection.removeAttr("tabindex"),this.selection.removeAttr("aria-labelledby")):t.removeAttr("readonly",!0):"oj-select"===this._classNm&&t.removeAttr("aria-readonly"),t&&(t.attr("role","combobox"),t.attr("aria-expanded","false"));this._enableInterface()},_clickAwayHandler:function(e){var i=this.dropdown;t(e.target).closest(i).length||t(e.target).closest("#"+t.escapeSelector(i.attr("data-oj-containerid"))).length||i.length>0&&i.data("ojlistbox").close(e)},_surrogateRemoveHandler:function(){this.dropdown&&this.dropdown.remove()},_destroy:function(){var e=this._closeDelayTimer;isNaN(e)||(delete this._closeDelayTimer,window.clearTimeout(e));var t=this.opts.element,i=t.data(this._elemNm);this.close(),this.propertyObserver&&(delete this.propertyObserver,this.propertyObserver=null),this.opts.list&&this.results?(this._cleanupList(this.results),this.dropdownListParent&&this.dropdownListParent.append(this.results)):this.isOjOption&&this.results&&(this._unwrapOjOptions(this.results),this.opts.element.append(this.results.children())),void 0!==i&&(i.container.after(t),i.container.remove(),i.dropdown.remove(),t.removeAttr("aria-hidden").removeData(this._elemNm).off("."+this._classNm).prop("autofocus",this.autofocus||!1),this.elementTabIndex?t.attr({tabindex:this.elementTabIndex}):t.removeAttr("tabindex"),t.show())},_unwrapOjOptions:function(e){var i,s=this;e.children().each(function(){(i=t(this)).is("li")&&(i.hasClass("oj-listbox-result-with-children")||i.children("oj-optgroup").length>0?(i.hasClass("oj-listbox-result-with-children")&&i.children(".oj-listbox-result-label").remove(),s._unwrapOjOptions(i.find("oj-optgroup").children()),i.find("oj-optgroup").children().children().unwrap(),i.find("oj-optgroup").unwrap()):i.hasClass("oj-listbox-result")?i.find("oj-option").unwrap().unwrap():i.find("oj-option").unwrap())})},_cleanupList:function(e){if(e&&e.is("ul")){e.removeClass("oj-listbox-results oj-listbox-result-sub"),e.removeAttr("role");for(var i=e.children().length-1;i>=0;i--)this._cleanupList(t(e.children()[i]))}else if(e.is("li")){(e.hasClass("oj-listbox-placeholder")||e.hasClass("oj-listbox-no-results"))&&e.remove(),e.attr("class")&&e.attr("class",e.attr("class").replace(/oj-listbox-\S+/g,""));var s=e.children(".oj-listbox-result-label");s&&s.contents().unwrap(),"none"===e.css("display")&&e.css("display",""),this._cleanupList(e.children("ul"))}},_optionToData:function(e){if(e.is("option")||e.is("oj-option"))return{value:e.prop("value")||e.attr("value"),label:e.text().trim()||e.attr("label"),element:e.get(),css:e.attr("class"),disabled:e.prop("disabled"),locked:"locked"===e.attr("locked")||!0===e.data("locked")};if(e.is("optgroup")||e.is("oj-optgroup"))return{label:e.prop("label")||e.attr("label"),disabled:e.prop("disabled"),children:[],element:e.get(),css:e.attr("class")};if(e.is("li")){var t,i,s,n=null,o=e.children();if(o&&o.length>0&&o.is("ul"))t=e.attr("oj-data-label")?e.attr("oj-data-label"):e.clone().children().remove().end().text().trim(),i=e.attr("oj-data-value"),n=[];else if(o&&o.length>0&&o.is("oj-optgroup"))t=o.prop("label"),s=o.prop("disabled"),n=[];else{var r=e.find("oj-option");t=e.attr("oj-data-label")?e.attr("oj-data-label"):e.text().trim(),i=r.length>0?r.prop("value"):e.attr("oj-data-value"),s=r.length>0?r.prop("disabled"):void 0}return{value:i,label:t,disabled:s,element:e.get(),css:e.attr("class"),children:n}}},_prepareOpts:function(e){var i,s,n=e,o=this;n.options&&Array.isArray(n.options)&&n.optionsKeys&&(n.options=t.extend(!0,[],n.options));var r=(i=n.element).get(0).tagName.toLowerCase();if(n.ojContext._IsCustomElement()?!n.options&&n.element.children().length>0&&(s=t(i),this.datalist=s):"input"===r&&i.attr("list")?(s=t("#"+i.attr("list")),this.datalist=s):"select"===r&&i.children().length>0?(s=i,this.datalist=s):n.list&&(s=t("#"+n.list),this.datalist=s),(n=t.extend({},{populateResults:function(e,i,s,a){var l,u=this.opts.id,c=h.isTreeDataProvider(h.getDataProvider(this.opts)),p=this.opts.optionRenderer;if("function"!=typeof p&&(p=null),this.opts.ojContext._IsCustomElement()&&p){var d=p;p=function(e){var t=d(e);return!t||"OJ-OPTION"!==t.tagName&&"OJ-OPTGROUP"!==t.tagName?t&&t.insert?t.insert:null:(t.hasAttribute("data-oj-binding-provider")||t.setAttribute("data-oj-binding-provider","none"),t)}}(l=function(e,i,a,d,_){var f,g,v,m,y,b,E,S,O=function(e,i){if(i.children&&i.children.length>0){var s=i.element&&t(i.element[0]).is("li")&&t(i.element[0]).children("ul"),n=s?t(i.element[0]).children("ul"):t("<ul></ul>");n.hasClass("oj-listbox-result-sub")||n.addClass("oj-listbox-result-sub"),l(i,i.children,n,d+1,!1),s||e.append(n)}},C=function(e,t,i){e.length&&i&&i.length&&e.each(function(){!function e(i,s){var n=0;if(3===i.nodeType){var o=i.data.toUpperCase().indexOf(s);if(o>=0){var r=document.createElement("span");r.className=t;var a=i.splitText(Math.min(o,i.data.length));a.splitText(Math.min(s.length,a.data.length));var l=a.cloneNode(!0);r.appendChild(l),a.parentNode.replaceChild(r,a),n=1}}else if(1===i.nodeType&&i.childNodes&&!/(script|style)/i.test(i.tagName))for(var u=0;u<i.childNodes.length;u++)u+=e(i.childNodes[u],s);return n}(this,i.toUpperCase())})},A=function(e){if(n.highlightTermInOptions(s)){var t=e.find(".oj-listbox-highlighter-section");t.length||(t=e),C(t,"oj-listbox-highlighter",s.term)}},P=o._getPlaceholder();for(_&&null!==P&&!s.term&&a.find(".oj-listbox-placeholder").length<=0&&("select"!==r||!o.ojContext._IsRequired())&&(v={value:"",label:P},(b=t("<li></li>")).addClass("oj-listbox-placeholder oj-listbox-results-depth-0 oj-listbox-result oj-listbox-result-selectable"),b.attr("role","presentation"),(E=t(document.createElement("div"))).addClass("oj-listbox-result-label"),E.attr("id","oj-listbox-result-label-"+h.nextUid()),E.attr("role","option"),void 0!==(S=n.formatResult(v))&&E.text(S),E.attr("aria-label",S),b.append(E),b.data(o._elemNm,v),a.prepend(b)),f=0,g=i.length;f<g;f++){y=!0===(v=i[f]).disabled,m=c?!v._jetUnSelectable:!y&&void 0!==u(v);var T=v.element&&t(v.element[0]).is("li");if((b=t(T?v.element[0]:"<li></li>")).hasClass("oj-listbox-result"))v.children&&v.children.length>0&&O(b,v),A(t(v.element[0]).children("div")),t(v.element[0]).css("display","");else{b.addClass("oj-listbox-results-depth-"+d),b.addClass("oj-listbox-result"),b.addClass(m?"oj-listbox-result-selectable":"oj-listbox-result-unselectable"),y&&b.addClass("oj-disabled"),v.children&&b.addClass("oj-listbox-result-with-children"),b.attr("role","presentation");var j="oj-listbox-result-label-"+h.nextUid();if((E=t(document.createElement("div"))).addClass("oj-listbox-result-label"),E.attr("id",j),E.attr("role","option"),y&&E.attr("aria-disabled","true"),e&&e.ariaLabelledById?v.ariaLabelledById=e.ariaLabelledById+" "+j:v.ariaLabelledById=j,!T){var I=function(t,i){var s;if(p){var o=c?i.data:i,r={index:f,depth:d,leaf:!i.children,parent:e,data:o,component:n.ojContext,parentElement:t.get(0)};n.ojContext._FixRendererContext&&(r=n.ojContext._FixRendererContext(r));var a=p.call(n.ojContext,r);null!==a&&(null===a.parentNode||a.parentNode instanceof DocumentFragment)&&(t.get(0).appendChild(a),s=a)}else void 0!==(S=n.formatResult(i))&&(t.text(S),t.attr("aria-label",S));return A(t),s}(E,v);if(b.append(E),I&&("OJ-OPTION"===I.tagName||"OJ-OPTGROUP"===I.tagName)&&(I.getAttribute("disabled")&&(b.removeClass("oj-listbox-result-selectable"),b.addClass("oj-listbox-result-unselectable oj-disabled"),E.attr("aria-disabled","true")),"OJ-OPTGROUP"===I.tagName&&I.hasAttribute("label"))){var R=I.getAttribute("label"),U=document.createTextNode(R);I.insertBefore(U,I.firstChild)}}if(v.children&&v.children.length>0&&O(b,v),b.data(o._elemNm,v),T){var L=t(v.element[0]);if(L.children("oj-optgroup").length>0){var V=L.children("oj-optgroup").prop("label")+"";L.prepend(E.text(V))}else L.children("oj-option").length>0?L.contents().wrapAll(E):L.contents().filter(function(){return"UL"!==this.tagName}).wrapAll(E);A(L.children("div")),L.css("display","")}else a.append(b)}}})(null,i,e,0,a)},highlightTermInOptions:function(e){return!(!0===e.initial)}},d,n)).id=function(e){return e.value},n.formatResult=function(e){var t=h.getLabel(e);return isNaN(t)?t:this.ojContext._formatValue(t)},n.formatSelection=function(e){var t=h.getLabel(e);if(e&&t)return isNaN(t)?t:this.ojContext._formatValue(t)},"select"!==r&&null!==n.manageNewEntry&&(n.manageNewEntry=function(e){var i={};return i.label=t.trim(e),i.value=i.label,i}),this.datalist)n.query=this._bind(function(e){var t,i,s={results:[],more:!1},n=e.term;i=function(t,s){var r,a,l=t.children()&&t.children().length>0&&(t.children().is("ul")||t.children().is("oj-optgroup"));t.is("option")||t.is("oj-option")||t.is("li")&&!l?e.matcher(n,t.text()||t.attr("label"),t)&&s.push(o._optionToData(t)):(t.is("optgroup")||t.is("oj-optgroup")||t.is("li")&&l)&&(r=o._optionToData(t),t.is("optgroup")||t.is("oj-optgroup")?a=t.children():t.children("oj-optgroup")?a=t.children().children("ul").children():t.children("ul").children(),h.each2(a,function(e,t){i(t,r.children)}),r.children.length>0&&s.push(r))},t=this.datalist.children(),void 0!==this._getPlaceholder()&&t.length>0&&""===t.first().attr("value")&&(t=t.slice(1)),h.each2(t,function(e,t){i(t,s.results)}),e.callback(s)});else if("options"in n){var a=n.options;h.getDataProvider(n)?n.query=function(e){e.value?h.fetchByKeyFromDataProvider(o,n,e):h.fetchFromDataProvider(o,n,e)}:t.isFunction(a)?n.query=h.remote(a,n.optionsKeys?n.optionsKeys:null):n.query=h.local(a,n.optionsKeys?n.optionsKeys:null)}return n},_createHeader:function(){var e=this.opts.element.find(".oj-listbox-header");if(e.length){this.header=t("<li>",{class:"oj-listbox-result-header oj-listbox-result-unselectable",role:"presentation"}),this.header.append(e.children()),this._initializeHeaderItems();var i=t("<ul>",{class:"oj-listbox-results-with-header",role:"listbox"});i.append(this.header),i.appendTo(this.results.parent());var s=t("<li>",{role:"presentation"});i.append(s),this.results.attr("role","presentation"),this.results.appendTo(s)}this.headerInitialized=!0},_initializeHeaderItems:function(){this.headerItems=this.header.find("li[role='option'], li:not([role])"),this.headerItems.uniqueId(),this.header.find("ul").attr("role","presentation"),this.header.find("li:not([role])").attr("role","option"),this.header.find("a, input, select, textarea, button, object, .oj-component-initnode").each(function(){t(this).attr("tabIndex",-1)})},_isHeaderItem:function(e){var i=!1;return this.headerItems.each(function(){return t(this).attr("id")!==e||(i=!0,!1)}),i},_getNextHeaderItem:function(e){if(!this.headerItems)return null;if(!e)return this.headerItems.first();var i=!1,s=null;return this.headerItems.each(function(){return i?(s=t(this),!1):(i=t(this).attr("id")===e,!0)}),s},_getPreviousHeaderItem:function(e){if(!this.headerItems)return null;var i=null;return this.headerItems.each(function(){return t(this).attr("id")!==e&&(i=t(this),!0)}),i},_setFocusOnHeaderItem:function(e){var t=e.find(".oj-component .oj-enabled").first();0===t.length&&0===(t=e.find("a, input, select, textarea, button, object, .oj-component-initnode").first()).length&&(t=e.children().first()),t&&t.addClass("oj-focus oj-focus-highlight oj-focus-only")},_removeHighlightFromHeaderItems:function(){this.headerItems&&this.headerItems.find(".oj-focus").removeClass("oj-focus oj-focus-highlight oj-focus-only")},_triggerSelect:function(e){var i=t.Event(this._elemNm+"-selecting",{val:this.id(e),object:e});return this.opts.element.trigger(i),!i.isDefaultPrevented()},_isInterfaceEnabled:function(){return!0===this.enabledInterface},_enableInterface:function(){var e=this._enabled&&!(h.isReadonly(this.ojContext)||this._readonly);return e!==this.enabledInterface&&(h.isReadonly(this.ojContext)||this.container.toggleClass("oj-disabled",!e),this.close(),this.enabledInterface=e,!0)},_enable:function(e){var t=e;void 0===t&&(t=!0),this._enabled!==t&&(this._enabled=t,this.opts.element.prop("disabled",!(t||h.isReadonly(this.ojContext))),this.container.toggleClass("oj-enabled",t),this._enableInterface())},_disable:function(){this._enable(!1)},_readonly:function(e){var t=e;return void 0===t&&(t=!1),this._readonly!==t&&(this._readonly=t,this.opts.element.prop("readonly",t),this._enableInterface(),!0)},_opened:function(){return this.container.hasClass("oj-listbox-dropdown-open")},_getDropdownPositionElement:function(){return this.container.children().first()},_usingHandler:function(i,s){if(e.PositionUtils.isAligningPositionClipped(s)){var n=h._addBusyState(this.container,"closing popup");this._closeDelayTimer=window.setTimeout(function(){t.proxy(this.close,this),n()},1)}else{var o=this.container,r=s.element.element;r.css(i),"bottom"===s.vertical?(o.addClass("oj-listbox-drop-above"),r.addClass("oj-listbox-drop-above")):(o.removeClass("oj-listbox-drop-above"),r.removeClass("oj-listbox-drop-above"))}},_getDropdownPosition:function(){var i={my:"start top",at:"start bottom",of:this._getDropdownPositionElement(),collision:"flip",using:t.proxy(this._usingHandler,this)},s="rtl"===e.DomUtils.getReadingDirection();return e.PositionUtils.normalizeHorizontalAlignment(i,s)},_positionDropdown:function(){var e=this.dropdown,t=this._getDropdownPosition(),i=this.container;e.css("width",i.outerWidth()),e.position(t)},_shouldOpen:function(e){if(this._opened())return!1;if(!1===this._enabled||h.isReadonly(this.ojContext)||!0===this._readonly)return!1;var t={component:this.opts.element};return this.ojContext._trigger("beforeExpand",e,t)},_clearDropdownAlignmentPreference:function(){this.container.removeClass("oj-listbox-drop-above"),this.dropdown.removeClass("oj-listbox-drop-above")},open:function(e,t){return!!this._shouldOpen(e)&&(this._opening(e,t),!0)},_opening:function(){this.headerInitialized||this._createHeader(),this.container.addClass("oj-listbox-dropdown-open")},_showDropDown:function(){if(this._opened()&&"true"!==this._getActiveContainer().attr("aria-expanded")){this._clearDropdownAlignmentPreference();var i=this.dropdown.parent();if("oj-select"===this._classNm&&!0!==this.opts.multiple&&i&&i.hasClass("oj-listbox-drop-layer"))e.PopupService.getInstance().triggerOnDescendents(i,e.PopupService.EVENT.POPUP_REFRESH);else{this.dropdown[0]!==this.body().children().last()[0]&&this.dropdown.detach().appendTo(this.body()),this.dropdown.appendTo(this.body()),this.header&&(this.dropdown.find(".oj-listbox-results-with-header").prepend(this.header),this.header.show());var s={};s[e.PopupService.EVENT.POPUP_CLOSE]=t.proxy(this.close,this),s[e.PopupService.EVENT.POPUP_REMOVE]=t.proxy(this._surrogateRemoveHandler,this),s[e.PopupService.EVENT.POPUP_AUTODISMISS]=t.proxy(this._clickAwayHandler,this),s[e.PopupService.EVENT.POPUP_REFRESH]=t.proxy(this._positionDropdown,this);var n={};n[e.PopupService.OPTION.POPUP]=this.dropdown,n[e.PopupService.OPTION.LAUNCHER]=this.opts.element,n[e.PopupService.OPTION.EVENTS]=s,n[e.PopupService.OPTION.POSITION]=this._getDropdownPosition(),n[e.PopupService.OPTION.LAYER_SELECTORS]="oj-listbox-drop-layer",n[e.PopupService.OPTION.CUSTOM_ELEMENT]=this.ojContext._IsCustomElement(),
e.PopupService.getInstance().open(n),t("#oj-listbox-drop").removeAttr("id"),this.dropdown.attr("id","oj-listbox-drop");var o=this.containerId;this.dropdown.attr("data-oj-containerid",o)}this._positionDropdown(),this._getActiveContainer().attr("aria-expanded",!0)}},close:function(i){if(this._opened()){this.container.removeClass("oj-listbox-dropdown-open");var s=this._getActiveContainer().attr("aria-expanded");if(delete this.ojContext._resolveSearchBoxLater,s&&"false"!==s){var n=this.containerId,o="scroll."+n,r="resize."+n,a="orientationchange."+n;this.container.parents().add(window).each(function(){t(this).off(o).off(r).off(a)}),this._clearDropdownAlignmentPreference();var l={};l[e.PopupService.OPTION.POPUP]=this.dropdown,e.PopupService.getInstance().close(l),this.header&&(this.header.hide(),this.header.appendTo(this.container)),this.dropdown.removeAttr("data-oj-containerid"),this.dropdown.removeAttr("id"),this.opts.list||this.isOjOption?this._removeHighlight():(this.dropdown.detach(),this.results.empty()),this._getActiveContainer().attr("aria-expanded",!1),"ojcombobox"===this._elemNm&&this._getActiveContainer().removeAttr("aria-activedescendant"),t.removeData(this.container,this._classNm+"-last-term")}}},_setPickerAttributes:function(t){e.EditableValueUtils.setPickerAttributes(this.dropdown,t)},_clearSearch:function(){},_ensureHighlightVisible:function(){var e,i,s,n,o,r,a=this.results,l=this._highlight();l<0||(e=this._findHighlightableChoices(),s=(i=t(e[l])).offset().top+i.outerHeight(!0),l===e.length-1&&(r=a.find("li.oj-listbox-more-results")).length>0&&(s=r.offset().top+r.outerHeight(!0)),s>(n=a.offset().top+a.outerHeight(!0))&&a.scrollTop(a.scrollTop()+(s-n)),(o=i.offset().top-a.offset().top)<0&&"none"!==i.css("display")&&a.scrollTop(a.scrollTop()+o))},_findHighlightableChoices:function(){return this.results.find(".oj-listbox-result-selectable:not(.oj-disabled, .oj-selected)").filter(function(){return"none"!==t(this).css("display")})},_moveHighlight:function(e){var i=this._findHighlightableChoices(),s=this._highlight();if(this.header&&(s<=0||s===i.length-1)){var n=this._getActiveContainer().attr("aria-activedescendant"),o=this._isHeaderItem(n);o||(n=null);var r=null;if(e>0&&(s<0||s===i.length-1)?r=this._getNextHeaderItem(n):e<0&&(o&&s<0||0===s)&&(r=this._getPreviousHeaderItem(n)),r)return this._removeHighlight(),this._setFocusOnHeaderItem(r),void this._getActiveContainer().attr("aria-activedescendant",r.attr("id"));o&&e<0&&(s=0)}for(;s>=-1&&s<i.length;){(s+=e)===i.length?s=0:-1===s&&(s=i.length-1);var a=t(i[s]);if(a.hasClass("oj-listbox-result-selectable")&&!a.hasClass("oj-disabled")&&!a.hasClass("oj-selected")){this._highlight(s);break}}},_highlight:function(e){var i,s=e,n=this._findHighlightableChoices();if(0===arguments.length){var o=n.filter(".oj-hover");return o.length||(o=n.children(".oj-hover").closest(".oj-listbox-result")),this._updateMatchesCount(o.text()),n.get().indexOf(o[0])}if(s>=n.length&&(s=n.length-1),s<0&&(s=0),this._removeHighlight(),(i=t(n[s])).hasClass("oj-listbox-result-with-children")){var r=i.children(".oj-listbox-result-label");r.addClass("oj-hover"),this._updateMatchesCount(r.text())}else i.addClass("oj-hover"),this._updateMatchesCount(i.text());return this._getActiveContainer().attr("aria-activedescendant",i.find(".oj-listbox-result-label").attr("id")),this._ensureHighlightVisible(),0},_removeHighlight:function(){this.results.find(".oj-hover").removeClass("oj-hover"),this._removeHighlightFromHeaderItems(),"ojcombobox"===this._elemNm&&this._getActiveContainer().removeAttr("aria-activedescendant")},_highlightUnderEvent:function(e){var i=t(e.target).closest(".oj-listbox-result-selectable");if(i.length>0&&!i.is(".oj-hover")){var s=this._findHighlightableChoices();this._highlight(s.index(i))}else 0===i.length&&this._removeHighlight()},_updateMatchesCount:function(e){if(!this.dropdown.find(".oj-listbox-filter-message-text").length){var t=this.container.find(".oj-listbox-liveregion");t.length&&t.text(e)}},_updateResults:function(e){var i=this.search,s=this,o=i.val(),r=t.data(this.container,this._classNm+"-last-term");if((!0===e||!r||o!==r||!0===this.opts.multiple)&&(r||o||!e||"input"!==e.type)){t.data(this.container,this._classNm+"-last-term",o);var a=this.opts.minLength||0;o.length>=a?(this._queryTimer&&this._queryTimer.clear(),e&&!0!==e?(this._queryResolveBusyState=h._addBusyState(this.container,"query results"),this._queryTimer=n.getTimer(h.DEFAULT_QUERY_DELAY),this._queryTimer.getPromise().then(function(t){t&&s._queryResults(e)}).then(this._queryResolveBusyState)):this._queryResults(e)):this.close()}},_queryResults:function(e){function t(){if(a._positionDropdown(),a.header&&a.headerItems.length){var e=a._findHighlightableChoices(),t=a.headerItems.length+e.length;if(a.headerItems.attr("aria-setsize",t),e.length){var i=e.children("[role='option']");i.attr("aria-setsize",t),i.first().attr("aria-posinset",a.headerItems.length+1)}}}var i,s,n=this.search,o=this.results,r=this.opts,a=this,l=n.val();(r.minLength||0)>l.length?this.close():(this.open(null,!0),this.queryCount+=1,s=this.queryCount,this._removeHighlight(),l=null!=(i=this.search.val())&&(!0!==e||r.inputSearch||"rawValue"===r.filterOnOpen||r.minLength>0)?i:"",this.resultsPage=1,r.query({element:r.element,term:l,page:this.resultsPage,context:null,matcher:r.matcher,callback:this._bind(function(i){if(s===this.queryCount&&this._opened())if(r.ojContext._hasMore||h.removeDropdownMessage(a.dropdown),this.context=i&&void 0!==i.context?i.context:null,(!i||i.results&&0===i.results.length||this._isDataSelected(i)&&this.ojContext.isValid())&&h.checkFormatter(a.ojContext,r.formatNoMatches,"formatNoMatches")){var l=r.formatNoMatches(a.ojContext,n.val());if("oj-select"===this._classNm||this.header){if(this._showDropDown(),this._preprocessResults(o),t(),h.addDropdownMessage(a.dropdown,a.ojContext,l),!this._hasSearchBox()){var u=a.dropdown.find(".oj-listbox-filter-message-separator");u.length&&u.css("display","none")}}else this.close();this._updateMatchesCount(l)}else h.saveLastQueryResult(this,i.results),this._showDropDown(),this._preprocessResults(o),a.opts.populateResults.call(this,o,i.results,{term:n.val(),page:this.resultsPage,context:null,initial:e},this._showPlaceholder()),this._postprocessResults(i,e),t(),this._updateMatchesCount(r.formatMoreMatches(a.ojContext,this._findHighlightableChoices().length))})}))},_preprocessResults:function(e){if(this.opts.list||this.isOjOption){var t=e.children();this._hideResultList(t)}else e.empty()},_processAriaLabelForHierarchy:function(){var e=this.results.find(".oj-listbox-result-with-children");if(0!==e.length){var i=this,s=function(e){var t=e.find(".oj-listbox-result-label"),s=e.data(i._elemNm).ariaLabelledById;s&&t&&t.attr("aria-labelledby",s)};h.each2(e,function(e,i){var n=i.find(".oj-listbox-result-selectable:visible");n&&n.length>0&&(s(t(n[0])),n.length>1&&s(t(n[n.length-1])))})}},_normalizeHighlighterLabel:function(e){var i,s;if(e.children("div").children("oj-option").length>0?(i=e.children("div").children("oj-option").find(".oj-listbox-highlighter"),s=e.children("div").children("oj-option")[0]):(i=e.children("div").children(".oj-listbox-highlighter"),s=e.children("div")[0]),i.length>0){for(var n=0;n<i.length;n++)t(i[n].childNodes).unwrap();s.normalize()}},_hideResultList:function(e){for(var i=0;i<e.length;i++){var s,n=t(e[i]);n.is("LI")&&((n.hasClass("oj-listbox-no-results")||n.hasClass("oj-listbox-placeholder"))&&n.remove(),n.css("display","none"),n.hasClass("oj-selected")&&n.removeClass("oj-selected"),this._normalizeHighlighterLabel(n)),(s=n.children("oj-optgroup")?n.children("oj-optgroup").children("ul"):n.children("ul"))&&s.children()&&this._hideResultList(s.children())}},_cancel:function(e){this.close(e)},_focusSearch:function(){h._focus(this,this.search)},_selectHighlighted:function(e,i){var s=e;if(this.header){var n=this._getActiveContainer().attr("aria-activedescendant");if(this._isHeaderItem(n)){var o=t("#"+n),r=o.find("a, input, select, textarea, button, object").first();return 0===r.length&&(r=o.children()),r.length&&r[0].click(),void this.close(i)}}var a=this._highlight(),l=this.results.find(".oj-hover").closest(".oj-listbox-result").data(this._elemNm);if(l){this._highlight(a);var u=this.getVal();(s=s||{}).trigger=h.ValueChangeTriggerTypes.OPTION_SELECTED,this._onSelect(l,s,i),this._triggerUpdateEvent(l,s,i),this._triggerValueUpdatedEvent(l,u),i&&"keydown"===i.type&&(this.enterKeyEventHandled=!0)}else s&&s.noFocus&&this.close(i)},_getPlaceholder:function(){return this.opts.element.attr("placeholder")||this.opts.element.attr("data-placeholder")||this.opts.element.data("placeholder")||this.opts.placeholder},_setPlaceholder:function(){var e=this._getPlaceholder();e&&(this.ojContext.multiple&&"oj-select"===this._classNm?this.selection.find(".oj-select-default").text(e):this.search.attr("placeholder",e))},_initContainerWidth:function(){var e=function(){var e,t,i,s,n;if(null!=(e=this._getAttribute("style")))for(s=0,n=(t=e.split(";")).length;s<n;s++)if(null!==(i=t[s].replace(/\s/g,"").match(/^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i))&&i.length>=1)return i[1];return null}.call(this);null!==e&&this.container.css("width",e)},valHasChanged:function(){var e=this.container;if(h.duringFetchByKey(e)){h.setValueChanged(this.ojContext,!0);var t=this.selection;t._saveLoadingIndicator&&!this.ojContext.multiple&&h.removeLoadingIndicator(t)}},getVal:function(){return this.ojContext.option("value")},setVal:function(t,i,s){this.valHasChanged();var n={doValueChangeCheck:!1};s&&(n._context=s);var o=this.ojContext.multiple;if(!this._skipSetValueOptions)if(h.isValueForPlaceholder(o,t)&&null!==this._getPlaceholder())this.setValOpts(h.getFixupValueOptionsForPlaceholder(o));else{var r,a=h.getLastQueryResult(this);a&&(r=o?h.findOptions(a,t):h.findOption(a,t)),r?this.setValOpts(r):"oj-combobox"===this._classNm?this.ojContext._resolveValueOptionsLater=null!=h.findOption(this.getValOpts(),t):this.ojContext._resolveValueOptionsLater=!0}var l=this.getVal();Array.isArray(t)||this.ojContext._IsCustomElement()?e.Object.compareValues(l,t)||this.ojContext._SetValue(t,i,n):e.Object.compareValues(l,[t])||this.ojContext._SetValue([t],i,n)},getValOpts:function(){var e=this.ojContext;return e.multiple?e.option("valueOptions"):e.option("valueOption")},setValOpts:function(t){var i=this.ojContext,s=i.multiple,n=h.getFixupValueOptionsForPlaceholder(s),o=s?i.options.valueOptions:i.options.valueOption;h.isValueOptionsForPlaceholder(s,t)&&h.isValueOptionsForPlaceholder(s,o)&&h.isPlaceholderSpecified(i.options)?s?i.options.valueOptions=n:i.options.valueOption=n:e.Object.compareValues(t,this.getValOpts())||h.setValueOptions(i,t),s?this.opts.valueOptions=t:this.opts.valueOption=t},_triggerUpdateEvent:function(e,t,i){},_triggerValueUpdatedEvent:function(e,t){},_showPlaceholder:function(){return!1},_getActiveContainer:function(){return this.search},_getAttribute:function(e){return this.opts.ojContext._IsCustomElement()?this.opts.ojContext.OuterWrapper.getAttribute(e):this.opts.element.attr(e)},_showSearchBox:function(e){var i=!1,s=this.dropdown.find(".oj-listbox-search");if(s&&(this._hasSearchBox()?(this.dropdown.find(".oj-listbox-search-wrapper").removeClass("oj-helper-hidden-accessible"),t(s).removeAttr("aria-hidden"),this.search.val(e),i=!0):(this.dropdown.find(".oj-listbox-search-wrapper").addClass("oj-helper-hidden-accessible"),t(s).attr("aria-hidden","true"))),h._focus(this,i?this.search:this.selection),i){var n=this;s.find(".oj-listbox-spyglass-box").on("mouseup click",function(e){n.search.focus(),e.preventDefault()})}},_hasSearchBox:function(){if(this._userTyping)return!0;var e,i=this.opts.minimumResultsForSearch;return this.opts.list?e=t("#"+this.opts.list).find("li").length:h.isDataProvider(this.opts.options)?void 0===this.ojContext._resultCount?(e=i+1,this.ojContext._resolveSearchBoxLater=!0):(e=this.ojContext._resultCount,delete this.ojContext._resolveSearchBoxLater):this.datalist?e=this.ojContext._IsCustomElement()?this.datalist.children().find("oj-option").length:this.datalist[0].length:this.opts.options&&(e=this.opts.options.length),e>i},_isDataSelected:function(e){return!1},_findItem:function(e,i){for(var s=0;s<e.length;s++)if(t(e[s]).data(this._elemNm).value===i)return e[s];return null}}),f=h.clazz(_,{_enableInterface:function(){f.superclass._enableInterface.apply(this,arguments)&&this.search.prop("disabled",!(this._isInterfaceEnabled()||h.isReadonly(this.ojContext)))},_focus:function(){this._opened()&&this.close()},_destroy:function(){t("label[for='"+this.search.attr("id")+"']").attr("for",this.opts.element.attr("id")),f.superclass._destroy.apply(this,arguments)},_clear:function(e){if(this.selection.data(this._elemNm)){e||r.warn("Event should not be null when user modified the value in UI");var t=this.ojContext._IsCustomElement()?"":[];"oj-select"===this._classNm&&this.ojContext._IsRequired()||this.setVal(t,e),this.search.val(""),this.selection.removeData(this._elemNm)}this._setPlaceholder()},_initSelection:function(){if(!h.applyValueOptions(this,this.opts)){var e=this.datalist?this.datalist:this.opts.element;this.opts.initSelection.call(null,e,this._bind(this._updateSelectedOption))}},_containerKeydownHandler:function(e){if(this._isInterfaceEnabled())if(e.which!==h.KEY.PAGE_UP&&e.which!==h.KEY.PAGE_DOWN){switch(e.which){case h.KEY.UP:case h.KEY.DOWN:return this._opened()?this._moveHighlight(e.which===h.KEY.UP?-1:1):this.open(e),void e.preventDefault();case h.KEY.ENTER:return this._opened()&&e.stopPropagation(),this._selectHighlighted(null,e),e.preventDefault(),void(this._opened()||(this._userTyping=!1));case h.KEY.TAB:return this.close(e),void(this._userTyping=!1);case h.KEY.ESC:return this._opened()&&(this._cancel(e),e.preventDefault()),void(this._userTyping=!1)}this._userTyping=!0}else e.preventDefault()},_containerKeyupHandler:function(e){this._isInterfaceEnabled()&&(this._opened()||this.open(e))},_initContainer:function(){var e=this.container,i=this.opts.rootAttributes,s=i&&i.id?i.id:this._getAttribute("id")||h.nextUid(),n=e.find("."+this._classNm+"-choice");this.selection=n,n.attr("id",this._classNm+"-choice-"+s),n.find("."+this._classNm+"-input").attr("id",this._classNm+"-input-"+s),this.results.attr("id")||this.results.attr("id","oj-listbox-results-"+s);var o=e.find(".oj-listbox-liveregion");if(o.length&&o.attr("id","oj-listbox-live-"+s),"oj-select"!==this._classNm&&this.search.attr("aria-owns",this.results.attr("id")),!this.ojContext._IsCustomElement()){var r=t("label[for='"+this._getAttribute("id")+"']");r.attr("id")||r.attr("id",this._classNm+"-label-"+s),this.search.attr("aria-labelledby",r.attr("id")),this.opts.element.attr("aria-labelledby",r.attr("id")),this.search.attr("id")&&r.attr("for",this.search.attr("id"))}this._getAttribute("aria-label")&&this.search.attr("aria-label",this._getAttribute("aria-label")),this._getAttribute("aria-controls")&&this.search.attr("aria-controls",this._getAttribute("aria-controls")),n.on("keydown",this._bind(this._containerKeydownHandler)),n.on("mousedown",this._bind(function(e){if(!("end"===e.target.getAttribute("slot")||t(this._endSlot).find(e.target).length>0)){this.opts.element.prop("disabled")&&h.killEvent(e),n.removeClass("oj-focus-highlight"),this._opened()?this.close(e):this._isInterfaceEnabled()&&this.open(e);var i=this.search.parent().attr("aria-hidden");i&&"true"===i?this.selection.focus():this.search.focus(),t(e.target).hasClass("oj-combobox-open-icon")&&h.killEvent(e),this.container.addClass("oj-active")}})),n.on("mouseup",this._bind(function(){this.container.removeClass("oj-active")})),n.on("focus",this._bind(function(e){h.killEvent(e)})),this.search.on("compositionstart",this._bind(function(){this.ojContext._isComposing=!0})),this.search.on("compositionend",this._bind(function(e){this.ojContext._isComposing=!1,this.ojContext._SetRawValue(this.search.val(),e)})),this.search.on("input",this._bind(function(e){this.ojContext._isComposing||this.ojContext._SetRawValue(this.search.val(),e)})),this.search.on("focus",this._bind(function(){this._previousDisplayValue=this.search.val()})),this.search.on("blur keyup",this._bind(function(e){if("keyup"!==e.type||10===e.keyCode||13===e.keyCode){if(void 0!==this.search.val()&&this.results.find(".oj-hover").length<=0&&("keyup"!==e.type||!this.enterKeyEventHandled))if(this.opts.manageNewEntry){var t=this.search.val(),i=this.opts.manageNewEntry(t),s={trigger:"blur"===e.type?h.ValueChangeTriggerTypes.BLUR:h.ValueChangeTriggerTypes.ENTER_PRESSED},n=this.selection.data(this._elemNm),o=this.getVal();!n&&""!==t||n&&n.label!==t||!this.ojContext.isValid()&&t!==this._previousDisplayValue?(this._onSelect(i,s,e),"blur"!==e.type&&(this._triggerUpdateEvent(i,s,e),this._triggerValueUpdatedEvent(i,o))):"keyup"===e.type&&(n&&n.label===t&&(i=n),this._triggerUpdateEvent(i,s,e),this._triggerValueUpdatedEvent(i,o))}else if(null==this.opts.manageNewEntry){var r=this.selection.data(this._elemNm);if(""===this.search.val())"oj-select"!==this._classNm&&this._clear(e);else if(r||""===this.search.val()){if("oj-select"!==this._classNm){var a=this.opts.formatSelection(r);void 0!==a&&this.search.val(a)}}else this._clearSearch()}this.search.removeClass(this._classNm+"-focused"),this.container.removeClass("oj-focus"),this.enterKeyEventHandled=!1}})),this._initContainerWidth(),this.opts.element.hide().attr("aria-hidden",!0),this.container.append(this.opts.element),this._setPlaceholder()},_prepareOpts:function(){var i=f.superclass._prepareOpts.apply(this,arguments),s=this,n=i.element.get(0).tagName.toLowerCase();if("input"===n&&i.element.attr("list")||"select"===n&&i.element.children().length>0||i.ojContext._IsCustomElement()&&!i.options||i.list){var o=i.list?"li":"option";i.ojContext._IsCustomElement()&&(o="oj-option"),i.initSelection=function(r,a){var l,u=s.getVal();Array.isArray(u)&&!i.ojContext._IsCustomElement()&&(u=u[0]),null!=u&&(l=s._optionToData(r.find(o).filter(function(){var t;return"li"===o?t=this.getAttribute("oj-data-value"):"option"!==o&&"oj-option"!==o||(t=this.value),e.Object.compareValues(t,u)})),"select"===n&&void 0===l&&(u=null)),null==u&&(l=s._optionToData(r.find(o).filter(function(){return"li"===o?!0===this.getAttribute("oj-data-selected"):"option"===o&&this.selected})),"oj-select"===s._classNm&&void 0===l&&i.ojContext._IsCustomElement()&&(l=s._optionToData(t(r.find(o)[0])),e.Logger.info("Select identified by "+s.container.attr("id")+" defaults to first option because the value is not set."))),a(l)},i.validate=function(t,i){var n;return null!=i&&(n=s._optionToData(t.find(o).filter(function(){var t;return"li"===o?t=this.getAttribute("oj-data-value"):"option"!==o&&"oj-option"!==o||(t=this.value),e.Object.compareValues(t,i)}))),!!n}}else("options"in i||this.getVal()&&this.getVal().length>0)&&(h.isDataProvider(i.options)||t.isFunction(i.options)?i.initSelection=function(o,r){var a=function(t,s){for(var n=0,o=t.length;n<o;n++){var r=t[n];if(e.Object.compareValues(s,i.id(r)))return r;if(r.children){var l=a(r.children,s);if(l)return l}}return null},l=s._getValueItem(),u=null;if(l){var c=h.getLastQueryResult(s);if(c&&(u=a(c,l)),!u){var p=s.currentItem;p&&p.length&&e.Object.compareValues(l,i.id(p[0]))&&(u=p[0],e.Logger.info("Select identified by "+s.container.attr("id")+" defaults to first option due to invalid value."))}u||s.valueChangeTrigger?r(u):i.query({value:[l],callback:t.isFunction(r)?function(t){(!h.isDataProvider(i.options)||e.Object.compareValues(l,s.getVal())&&!h.isValueChanged(s.ojContext))&&(t&&t.results&&(u=a(t.results,l)),r(u),h.setValueChanged(s.ojContext,void 0))}:t.noop})}else{var d=s.ojContext.options.optionsKeys;"select"!==n||s.ojContext._HasPlaceholderSet()||d&&(d.value||d.label)?r(u):h.fetchFirstBlockFromDataProvider(s.container,i,1).then(function(t){t&&t.length>0&&(r(t[0]),e.Logger.info("Select identified by "+s.container.attr("id")+" defaults to first option because the value is not set."))})}}:(i.initSelection=function(o,r){var a=s._getValueItem(),l="select"===n&&s.ojContext._HasPlaceholderSet()&&!s.ojContext._IsRequired(),u=l?s._getPlaceholder():null,c=null;i.query({matcher:function(t,s,n){var o=e.Object.compareValues(a,i.id(n));return o&&(c=n),null==u&&(u=n),o},callback:t.isFunction(r)?function(){c||"select"!==n||s.ojContext._isOptionDataPending()||(c=u,e.Logger.info("Select identified by "+s.container.attr("id")+" defaults to "+(l?"placeholder":"first option")+" due to invalid value.")),r(c)}:t.noop})},i.validate=function(s,n){var o=n,r=null;return i.query({matcher:function(t,s,n){var a=e.Object.compareValues(o,i.id(n));return a&&(r=n),a},callback:t.noop}),!!r}));return i},_postprocessResults:function(t,i,s){var n,o=-1,r=this;n=this._findHighlightableChoices(),h.each2(n,function(t,i){var s=r._getValueItem();return!s||!e.Object.compareValues(s,r.id(i.data(r._elemNm)))||(o=t,!1)}),!1!==s&&!0===i&&o>=0&&this._highlight(o),this._processAriaLabelForHierarchy()},_onSelect:function(e,t,i){if(this._triggerSelect(e)){var s,n;t&&t.trigger&&(s={optionMetadata:{trigger:t.trigger}}),this.close(i);var o=e;0===this.id(e).length?(n=this.ojContext._IsCustomElement()?h.getValueForPlaceholder(!1):[],o=h.getFixupValueOptionsForPlaceholder(!1)):n=this.id(e),"oj-combobox"===this._classNm&&(this._skipSetValueOptions=!0,this.setValOpts(h.findOptionFromResult(this,n,o))),this.setVal(n,i,s),this._skipSetValueOptions=!1,"blur"!==i.type&&this._focusSearch()}},_clearSearch:function(){this.search.val("")},_getValueItem:function(){var e=null,t=this.getVal();return null!=t&&(e=!this.ojContext._IsCustomElement()&&t.length?t[0]:t),e}}),g=h.clazz(f,{_elemNm:"ojcombobox",_classNm:"oj-combobox",_createContainer:function(){var i=t(document.createElement("div")).attr({class:"oj-combobox oj-component"}).html(["<div class='oj-combobox-choice' tabindex='-1' role='presentation'>","   <input type='text' autocomplete='off' autocorrect='off' autocapitalize='off'","       spellcheck='false' class='oj-combobox-input' role='combobox' aria-expanded='false' aria-autocomplete='list' />","   <abbr class='oj-combobox-clear-entry' role='presentation'></abbr>","   <span class='oj-combobox-divider' role='presentation'></span>","   <a class='oj-combobox-arrow oj-combobox-icon oj-component-icon oj-clickable-icon-nocontext oj-combobox-open-icon'","       role='button' aria-label='expand'></a>","</div>","<div class='oj-listbox-drop' role='presentation'>","   <ul class='oj-listbox-results' role='listbox'>","   </ul>","</div>","<div role='region' class='oj-helper-hidden-accessible oj-listbox-liveregion' aria-live='polite'></div>"].join(""));if(this.ojContext._IsCustomElement()){var s=e.BaseCustomElementBridge.getSlotMap(this.ojContext.OuterWrapper).end;s&&(i.find(".oj-combobox-divider").remove(),i.find(".oj-combobox-arrow").remove(),i.find(".oj-combobox-choice").append(s),this._endSlot=s)}return i},_triggerValueUpdatedEvent:function(e,t){if(this.ojContext._IsCustomElement()){var i=this.id(e);if(null==i&&(i=e.label?e.label:""),this.ojContext.isValid()){var s={},n=this.ojContext.OuterWrapper;s.value=i,s.previousValue=t;var o=new CustomEvent("ojValueUpdated",{detail:s});n.dispatchEvent(o)}}},_enable:function(e){g.superclass._enable.apply(this,arguments),this._enabled?this.container.find(".oj-combobox-arrow").removeClass("oj-disabled"):this.container.find(".oj-combobox-arrow").addClass("oj-disabled")},close:function(e){this._opened()&&g.superclass.close.apply(this,arguments)},_opening:function(e,t){g.superclass._opening.apply(this,arguments),t||this._updateResults(!0)},_containerKeydownHandler:function(e){"end"===e.target.getAttribute("slot")||t(this._endSlot).find(e.target).length>0||h.KEY.isControl(e)||h.KEY.isFunctionKey(e)||g.superclass._containerKeydownHandler.apply(this,arguments)},_updateSelection:function(e){var t,i=[];this.selection.data(this._elemNm,e),null!==e&&0!==e.length?(void 0!==(t=this.opts.formatSelection(e))&&this.search.val()!==t&&this.search.val(t),this.search.removeClass(this._classNm+"-default"),i.push(e)):(this.search.val(""),this._setPlaceholder()),this.currentItem=i},_updateSelectedOption:function(e){if(null!=e)this._updateSelection(e),this.setValOpts(e);else{var t,i=this.getVal();t=i?Array.isArray(i)?i.length?{label:i[0]}:null:{label:i}:null,this._updateSelection(t),!e&&i?this.setValOpts({value:i,label:h.getLabel({value:i})}):this.setValOpts(e)}}}),v=h.clazz(f,{_elemNm:"ojselect",_classNm:"oj-select",_userTyping:!1,_createContainer:function(){return t(document.createElement("div")).attr({class:"oj-select oj-component"}).html(["<div class='oj-select-choice' tabindex='0' role='combobox' ","     aria-autocomplete='none' aria-expanded='false'>","  <span class='oj-select-chosen'></span>","  <abbr class='oj-select-search-choice-close' role='presentation'></abbr>","  <a class='oj-select-arrow oj-component-icon oj-clickable-icon-nocontext oj-select-open-icon' role='presentation'>","</a></div>","<div class='oj-listbox-drop' role='dialog'>","  <div class='oj-listbox-search-wrapper'>","  <div class='oj-listbox-search'>","    <input type='text' autocomplete='off' autocorrect='off' autocapitalize='off'","           spellcheck='false' class='oj-listbox-input' title='Search field' ","           role='combobox' aria-expanded='false' aria-autocomplete='list' />","    <span class='oj-listbox-spyglass-box'>","      <span class='oj-component-icon oj-clickable-icon-nocontext oj-listbox-search-icon' role='presentation'>","       <b role='presentation'></b></span>","    </span>","  </div>","  </div>","   <ul class='oj-listbox-results' role='listbox'>","   </ul>","</div>","<div role='region' class='oj-helper-hidden-accessible oj-listbox-liveregion' aria-live='polite'></div>"].join(""))},_enable:function(e){v.superclass._enable.apply(this,arguments),this._enabled?(this.selection.attr("tabindex","0"),this.container.find(".oj-select-arrow").removeClass("oj-disabled")):(this.selection.attr("tabindex","-1"),this.container.find(".oj-select-arrow").addClass("oj-disabled"))},close:function(e){this._opened()&&(v.superclass.close.apply(this,arguments),this.selection.attr("aria-expanded",!1).removeAttr("aria-haspopup").removeAttr("aria-owns"),this.search.attr("aria-expanded",!1).removeAttr("aria-controls"),this._testClear(e)||this._clearSearch(),e instanceof MouseEvent&&e.target!==this.selection&&e.target!==this.search||h._focus(this,this.selection),this.container.find(".oj-listbox-spyglass-box").off("mouseup click"))},_opening:function(e,t){v.superclass._opening.apply(this,arguments),this._showDropDown();var i=h.getSearchText(e);this._showSearchBox(i),t||(i?this._updateResults():this._updateResults(!0))},_showDropDown:function(){if(this._opened()){var e="true"!==this.selection.attr("aria-expanded");v.superclass._showDropDown.apply(this,arguments),e&&(this.selection.attr("aria-expanded",!0).attr("aria-haspopup","dialog").attr("aria-owns",this.results.attr("id")),this.search.attr("aria-expanded",!0).attr("aria-controls",this.results.attr("id")+" "+this.container.find(".oj-listbox-liveregion").attr("id")))}},_initContainer:function(){var e=this.containerId+"_selected";this.text=this.container.find(".oj-select-chosen").attr("id",e),v.superclass._initContainer.apply(this,arguments),this.selection.attr({"aria-labelledby":this.search.attr("aria-labelledby"),"aria-describedby":e});var t=this._getAttribute("aria-label");t&&this.selection.attr("aria-label",t),this.search.on("keydown",this._bind(this._containerKeydownHandler)),this.search.on("keyup-change input",this._bind(this._containerKeyupHandler)),this.search.attr("title",this.ojContext.getTranslatedString("searchField"));var i=this;this.selection.on("blur",function(e){i._testClear(e)})},_initSelection:function(){this._isPlaceholderOptionSelected()?(this._updateSelection(null),this.close(),this._setPlaceholder()):v.superclass._initSelection.apply(this,arguments)},_updateSelectedOption:function(t){if(null!=t){var i,s=this.getVal();Array.isArray(s)&&!this.ojContext._IsCustomElement()&&(s=s[0]),void 0===(i=this.opts.id(t))&&(i=null),e.Object.compareValues(s,i)||this.ojContext._setInitialSelectedValue(i),this.setValOpts(t),this._updateSelection(t),this.close()}else this.setValOpts(null)},_updateSelection:function(e){this.selection.data(this._elemNm,e),null!==e&&this.text.text("string"==typeof e?e:h.getLabel(e)),e&&""!==e.id&&this.text.removeClass(this._classNm+"-default")},_getActiveContainer:function(){return this.search.attr("aria-expanded")&&this._hasSearchBox()?this.search:this.selection},_isPlaceholderOptionSelected:function(){if(null===this._getPlaceholder())return!1;var e=this.getVal();return e=Array.isArray(e)?e[0]:e,h.isValueForPlaceholder(!1,e)},_getPlaceholder:function(){return this.opts.placeholder},_showPlaceholder:function(){return!0},_setPlaceholder:function(){var e=this._getPlaceholder();this._isPlaceholderOptionSelected()&&void 0!==e&&this.text.text(e).addClass(this._classNm+"-default")},setVal:function(e,t,i){v.superclass.setVal.call(this,e,t,i),this.selection.data("selectVal",e)},_containerKeydownHandler:function(e){if(!(h.KEY.isControl(e)&&e.which!==h.KEY.SHIFT||e.which===h.KEY.SHIFT||h.KEY.isFunctionKey(e))){switch(e.which){case h.KEY.TAB:return this.close(e),this.selection.focus(),void this._testClear(e);case h.KEY.ENTER:if(e.target===this.selection[0]&&!this._opened())return this.open(e),void e.preventDefault()}if(v.superclass._containerKeydownHandler.apply(this,arguments),this._userTyping&&(this.open(e),this._opened())){var i=this.dropdown.find(".oj-listbox-search");if("true"===t(i).attr("aria-hidden")){var s=h.getSearchText(e);s&&(this._showSearchBox(s),this._updateResults())}}}},_testClear:function(e){return!(""!==this.text.text()||this.datalist&&this.selection.data(this._elemNm)&&this.selection.data(this._elemNm).value||!h.isValueForPlaceholder(!1,this.ojContext.options.value)||(this._clear(e),0))}}),m=h.clazz(_,{_prepareOpts:function(){var i=m.superclass._prepareOpts.apply(this,arguments),s=this,n=i.element.get(0).tagName.toLowerCase();if("input"===n&&i.element.attr("list")||"select"===n&&i.element.children().length>0||i.ojContext._IsCustomElement()&&!i.options||i.list){var o=i.list?"li":"option";i.ojContext._IsCustomElement()&&(o="oj-option"),i.initSelection=function(t,i){var r,a=[];if(s.getVal())for(var l=s.getVal(),u=0;u<l.length;u++){var c=l[u];(r=t.find(o).filter(function(){var t;return"li"===o?t=this.getAttribute("oj-data-value"):"option"!==o&&"oj-option"!==o||(t=this.value),e.Object.compareValues(t,c)}))&&r.length?a.push(s._optionToData(r)):"ojcombobox"===s._elemNm&&a.push({value:c,label:c})}else"select"!==n&&(r=t.find(o).filter(function(){return"option"===o?this.selected:"li"===o?!0===this.getAttribute("oj-data-selected"):"oj-option"===o&&!0===this.getAttribute("selected")}),h.each2(r,function(e,t){a.push(s._optionToData(t))}));i(a)}}else"options"in i&&(h.isDataProvider(i.options)||t.isFunction(i.options)?i.initSelection=function(n,o){var r=function(e,s){for(var n=[],o=0,a=e.length;o<a;o++){var l=e[o];if(s.indexOf(i.id(l))>=0&&n.push(l),l.children){var u=r(l.children,s);u&&u.length&&t.merge(n,u)}}return n},a=s.getVal(),l=[],u=h.getLastQueryResult(s);u&&(l=r(u,a));var c=function(){for(var t=[],n=0;n<a.length;n++){for(var r=a[n],u=!1,c=0;c<l.length;c++){var p=l[c];if(e.Object.compareValues(r,i.id(p))){t.push(p),l.splice(c,1),u=!0;break}}if(!u){var h=s.currentItem;if(h&&h.length)for(var d=0;d<h.length;d++)if(e.Object.compareValues(r,i.id(h[d]))){t.push(h[d]),u=!0;break}u||"ojcombobox"!==s._elemNm||t.push({value:r,label:r})}}o(t)};s.valueChangeTrigger?c():i.query({value:a,callback:function(n){if(n&&n.results){var o=r(n.results,a);if(o&&o.length){var u=o;if(h.isDataProvider(i.options)){u=[];var p=s.getVal();if(e.Object.compareValues(a,p)&&!h.isValueChanged(s.ojContext))u=o;else{var d,_,f=s.getValOpts();p.forEach(function(t){for(_=!1,d=0;d<f.length;d++)if(e.Object.compareValues(f[d].value,t)){_=!0,u.push(f[d]);break}
if(!_)for(d=0;d<o.length;d++)if(e.Object.compareValues(o[d].value,t)){u.push({value:o[d].value,label:o[d].label});break}}),a=p,h.setValueOptions(s.ojContext,u)}}t.merge(l,u)}}h.setValueChanged(s.ojContext,void 0),c()}})}:i.initSelection=function(n,o){var r=s.getVal();if(r&&0!==r.length){var a=[];i.query({matcher:function(s,n,o){var l=t.grep(r,function(t){return e.Object.compareValues(t,i.id(o))}).length;return l&&a.push(o),l},callback:t.isFunction(o)?function(){for(var t=[],n=0;n<r.length;n++){for(var l=r[n],u=!1,c=0;c<a.length;c++){var p=a[c];if(e.Object.compareValues(l,i.id(p))){t.push(p),a.splice(c,1),u=!0;break}}u||"ojcombobox"!==s._elemNm||t.push({value:l,label:l})}o(t)}:t.noop})}});return i},_selectChoice:function(e){var t=this.container.find("."+this._classNm+"-selected-choice.oj-focus"),i=t&&t.length>0,s=e&&e.length>0;(!i&&s||i&&!s||i&&s&&e[0]!==t[0])&&(i&&(this.opts.element.trigger("choice-deselected",t),t.removeClass("oj-focus")),s&&(this.close(),e.addClass("oj-focus"),this.container.find("."+this._classNm+"-description").text(e.attr("valueText")+". Press back space to delete.").attr("aria-live","assertive"),this.opts.element.trigger("choice-selected",e)))},_destroy:function(){t("label[for='"+this.search.attr("id")+"']").attr("for",this.opts.element.attr("id")),m.superclass._destroy.apply(this,arguments)},_initContainer:function(){var e,i="."+this._classNm+"-choices",s=h.nextUid();this.searchContainer=this.container.find("."+this._classNm+"-search-field");var n=this.container.find(i);this.selection=n;var o=this;this.selection.on("click","."+this._classNm+"-selected-choice:not(."+this._classNm+"-locked)",function(){"ojcombobox"===o._elemNm&&o.search[0].focus(),o._selectChoice(t(this))}),"ojselect"===this._elemNm&&this.selection.on("blur",function(){o._selectChoice(null)}),this._contentElement="ojcombobox"===this._elemNm?this.search:this.selection,n.find("."+this._classNm+"-input").attr("id",this._classNm+"-input-"+s),this.results.attr("id")||this.results.attr("id","oj-listbox-results-"+s),this._contentElement.attr("aria-owns",this.results.attr("id")),this.ojContext._IsCustomElement()||((e=t("label[for='"+this._getAttribute("id")+"']")).attr("id")||e.attr("id",this._classNm+"-label-"+s),this._contentElement.attr("aria-labelledby",e.attr("id")),this.opts.element.attr("aria-labelledby",e.attr("id")),this.search.attr("id")&&e.attr("for",this.search.attr("id"))),this._getAttribute("aria-label")&&this._contentElement.attr("aria-label",this._getAttribute("aria-label")),this._getAttribute("aria-controls")&&this._contentElement.attr("aria-controls",this._getAttribute("aria-controls")),this.elementTabIndex&&this._contentElement.attr("tabindex",this.elementTabIndex),this.keydowns=0,"ojselect"===this._elemNm&&(this.selection.on("keydown",this._bind(this._containerKeydownHandler)),this.selection.on("keyup",this._bind(function(){this.keydowns=0}))),this.search.on("keydown",this._bind(this._containerKeydownHandler)),this.search.on("keyup",this._bind(function(){this.keydowns=0})),this.search.on("compositionstart",this._bind(function(){this.ojContext._isComposing=!0})),this.search.on("compositionend",this._bind(function(e){this.ojContext._isComposing=!1,this.ojContext._SetRawValue(this.search.val(),e)})),this.search.on("input",this._bind(function(e){this.ojContext._isComposing||this.ojContext._SetRawValue(this.search.val(),e)})),this.search.on("blur keyup",this._bind(function(e){if("keyup"!==e.type||10===e.keyCode||13===e.keyCode){if(this.opts.manageNewEntry&&this.search.val()&&this.results.find(".oj-hover").length<=0){var t=this.opts.manageNewEntry(this.search.val()),i={trigger:"blur"===e.type?h.ValueChangeTriggerTypes.BLUR:h.ValueChangeTriggerTypes.ENTER_PRESSED};this._onSelect(t,i,e)}this.search.removeClass(this._classNm+"-focused"),this.container.removeClass("oj-focus"),this._selectChoice(null),!this._opened()&&"oj-select"!==this._classNm&&this.ojContext.isValid()&&this._clearSearch(),e.stopImmediatePropagation()}})),this.container.on("click touchstart",i,this._bind(function(e){this._isInterfaceEnabled()&&(t(e.target).closest("."+this._classNm+"-selected-choice").length>0||(this._selectChoice(null),this._opened()?this.close(e):(this.open(e),("ojcombobox"===this._elemNm||this._hasSearchBox())&&this._focusSearch()),e.preventDefault()))})),this._initContainerWidth(),this.opts.element.hide().attr("aria-hidden",!0),this.container.append(this.opts.element),this._clearSearch()},_containerKeydownHandler:function(e){if(this._isInterfaceEnabled()){this.keydowns+=1;var t=this.selection.find("."+this._classNm+"-selected-choice.oj-focus"),i=t.prev("."+this._classNm+"-selected-choice:not(."+this._classNm+"-locked)"),s=t.next("."+this._classNm+"-selected-choice:not(."+this._classNm+"-locked)"),n="ojselect"!==this._elemNm||this._userTyping?h.getCursorInfo(this.search):h.getCursorInfo(this.selection);if(t.length&&(e.which===h.KEY.LEFT||e.which===h.KEY.RIGHT||e.which===h.KEY.BACKSPACE||e.which===h.KEY.DELETE||e.which===h.KEY.ENTER)){var o=t;return e.which===h.KEY.LEFT&&i.length?o=i:e.which===h.KEY.RIGHT?o=s.length?s:null:e.which===h.KEY.BACKSPACE?(this._unselect(t.first(),e),this._resetSearchWidth(),o=i.length?i:s):e.which===h.KEY.DELETE?(this._unselect(t.first(),e),this._resetSearchWidth(),o=s.length?s:null):e.which===h.KEY.ENTER&&(o=null),this._selectChoice(o),e.preventDefault(),void(o&&o.length||this.open(e))}if(this._isBackNavAllowed()&&0===n.offset&&!n.length&&(e.which===h.KEY.BACKSPACE&&1===this.keydowns||e.which===h.KEY.LEFT))return this._selectChoice(this.selection.find("."+this._classNm+"-selected-choice:not(."+this._classNm+"-locked)").last()),void e.preventDefault();if(this._selectChoice(null),this._opened()){switch(e.which){case h.KEY.UP:case h.KEY.DOWN:return this._moveHighlight(e.which===h.KEY.UP?-1:1),void e.preventDefault();case h.KEY.ENTER:return this._selectHighlighted(null,e),e.preventDefault(),void e.stopPropagation();case h.KEY.TAB:return void this.close(e);case h.KEY.ESC:return this._cancel(e),void e.preventDefault()}!1!==this._userTyping||h.KEY.isControl(e)||h.KEY.isFunctionKey(e)||(this._userTyping=!0,this.close())}if(!(e.which===h.KEY.TAB||h.KEY.isControl(e)||h.KEY.isFunctionKey(e)||e.which===h.KEY.ESC||e.which===h.KEY.ENTER&&this.search.val()&&"ojcombobox"===this._elemNm)){switch(e.which){case h.KEY.UP:case h.KEY.DOWN:return this.open(e),void e.preventDefault();case h.KEY.PAGE_UP:case h.KEY.PAGE_DOWN:case h.KEY.ENTER:return void e.preventDefault()}this._userTyping=!0}}},_isBackNavAllowed:function(){return"ojselect"!==this._elemNm||document.activeElement!==this.search[0]},_enableInterface:function(){m.superclass._enableInterface.apply(this,arguments)&&this.search.prop("disabled",!(this._isInterfaceEnabled()||h.isReadonly(this.ojContext)))},_initSelection:function(e){var t=this.getVal();if(null!==t&&0!==t.length||"oj-select"!==this._classNm&&""!==this.opts.element.text().trim()||(this._updateSelection(e||[]),this.close(),this._clearSearch()),this.datalist||null!==this.getVal()&&this.getVal().length){var i,s=this;i=this.datalist?this.datalist:this.opts.element,h.applyValueOptions(this,this.opts)||this.opts.initSelection.call(null,i,function(e){null!=e&&0!==e.length&&(s._updateSelection(e),s.close(),s._clearSearch())})}},close:function(e){this._opened()&&m.superclass.close.apply(this,arguments)},_focus:function(){this.close(),this.search.focus()},_updateSelection:function(e){var i=[],s=[],n=this;t(e).each(function(){i.indexOf(n.id(this))<0&&(i.push(n.id(this)),s.push(this))}),"init"===this.opts.fetchType&&s&&s.length>0&&("oj-combobox"===this._classNm||"oj-select"===this._classNm)&&this.setValOpts(s),this.selection.find("."+this._classNm+"-selected-choice").remove(),this._contentElement.attr("aria-describedBy",""),this.selection.find(".oj-select-default").remove(),t(s).each(function(){n._addSelectedChoice(this)}),this.currentItem=s,this.currentValue=i,n._postprocessResults()},_onSelect:function(e,i,s){if(this._triggerSelect(e)){var n;i&&i.trigger&&(n={optionMetadata:{trigger:i.trigger}});var o=this.id(e),r=this.getVal()?this.getVal().slice(0):[],a=this.getValOpts()?this.getValOpts().slice(0):[],l=a.slice(0),u="oj-combobox"===this._classNm||"oj-select"===this._classNm;this.ojContext.isValid()||(r=this.currentValue.slice(0));var c=this;t(e).each(function(t){r.indexOf(o)<0&&""!==o&&(r.push(o),u&&(Array.isArray(e)?l.push(h.findOptionFromResult(c,o,e[t])):l.push(h.findOptionFromResult(c,o,e))))}),u&&(this._skipSetValueOptions=!0,this.setValOpts(l)),this.setVal(r,s,n),u&&!this.ojContext.isValid()&&this.setValOpts(a),this._skipSetValueOptions=!1,!this.select&&this.opts.closeOnSelect||this._postprocessResults(e,!1,!0===this.opts.closeOnSelect),this.opts.closeOnSelect&&(this.close(s),this.ojContext.isValid()&&this._resetSearchWidth()),i&&i.noFocus||"ojcombobox"!==this._elemNm||this._focusSearch()}},_cancel:function(e){this.close(e),"ojcombobox"===this._elemNm&&this._focusSearch()},_addSelectedChoice:function(e){var i,s=!e.locked,n=t("<li class='"+this._classNm+"-selected-choice'>    <div></div>    <a href='#' onclick='return false;' role='button' aria-label='remove' class='"+this._classNm+"-clear-entry       oj-component-icon oj-clickable-icon-nocontext "+this._classNm+"-clear-entry-icon' tabindex='-1'>    </a></li>"),o=t("<li class='"+this._classNm+"-selected-choice "+this._classNm+"-locked'><div></div></li>"),r=s?n:o;if(void 0!==(i=this.opts.formatSelection(e))){var a=this._classNm+"-selected-choice-label-"+h.nextUid();r.find("div").addClass(this._classNm+"-selected-choice-label").text(i).attr("id",a),r.find("."+this._classNm+"-clear-entry").attr("aria-label",i+" remove"),r.attr("valueText",i);var l=this._contentElement.attr("aria-describedBy");this._contentElement.attr("aria-describedBy",(l?l+" ":"")+a),"oj-combobox"===this._classNm&&this.selection.attr("aria-describedBy",(l?l+" ":"")+a)}s&&r.find("."+this._classNm+"-clear-entry").on("mousedown",h.killEvent).on("click dblclick",this._bind(function(e){this._isInterfaceEnabled()&&(t(e.target).closest("."+this._classNm+"-selected-choice").fadeOut("fast",this._bind(function(){this._unselect(t(e.target),e),this.selection.find("."+this._classNm+"-selected-choice.oj-focus").removeClass("oj-focus"),this.close(e),"ojcombobox"===this._elemNm&&this._focusSearch()})).dequeue(),h.killEvent(e))})),r.data(this._elemNm,e),"ojcombobox"===this._elemNm?r.insertBefore(this.searchContainer):this.selection.append(r)},_syncValueOptions:function(t,i,s){var n=[];if(i&&s){for(var o=0;o<i.length;o++)for(var r=0;r<s.length;r++){var a=s[r];e.Object.compareValues(a.value,i[o])&&n.push(a)}h.setValueOptions(t,n)}},_unselect:function(e,t){var i=this.getVal()?this.getVal().slice(0):[],s=e.closest("."+this._classNm+"-selected-choice");if(0===s.length)throw new Error("Invalid argument: "+s+". Must be ."+this._classNm+"-selected-choice");var n=s.data(this._elemNm);if(n){this.ojContext.isValid()||(i=this.currentValue);for(var o=i.indexOf(this.id(n));o>=0;)i.splice(o,1),this._syncValueOptions(this.ojContext,i,this.getValOpts()),this._skipSetValueOptions=!0,this.setVal(i,t),this._skipSetValueOptions=!1,this.select&&this._postprocessResults(),o=i.indexOf(this.id(n));s.remove()}},_postprocessResults:function(e,t,i){if(this.ojContext.isValid()){var s=this.getVal(),n=this.results.find(".oj-listbox-result"),o=this.results.find(".oj-listbox-result-with-children"),r=this;h.each2(n,function(e,t){var i=r.id(t.data(r._elemNm));s&&s.indexOf(i)>=0&&(t.addClass("oj-selected"),t.find(".oj-listbox-result-selectable").addClass("oj-selected"))}),h.each2(o,function(e,t){t.is(".oj-listbox-result-selectable")||0!==t.find(".oj-listbox-result-selectable:not(.oj-selected)").length||t.addClass("oj-selected")}),this._processAriaLabelForHierarchy(),!n.filter(".oj-listbox-result:not(.oj-selected)").length>0&&"oj-select"!==this._classNm&&this.close()}},_isDataSelected:function(e){var t=this.getVal();if(!t||0===t.length)return!1;for(var i=e.results,s=0;s<i.length;s++)if(-1===t.indexOf(this.id(i[s])))return!1;return!0},_resetSearchWidth:function(){},setVal:function(t,i,s){var n=[],o=t;this.valHasChanged(),"string"==typeof t&&(o=h.splitVal(t,this.opts.separator));for(var r=0;r<o.length;r++)n.indexOf(o[r])<0&&n.push(o[r]);var a={doValueChangeCheck:!1};if(s&&(a._context=s),!this._skipSetValueOptions){var l,u=h.getLastQueryResult(this);u&&(l=h.findOptions(u,o)),l&&l.length&&h.setValueOptions(this.ojContext,l)}var c=this.getVal();e.Object.compareValues(c,n)||this.ojContext._SetValue(n,i,a),(this.ojContext.isValid()||0===n.length)&&(this.currentValue=n),this.search.attr("aria-activedescendant",this.opts.element.attr("id"))}}),y=h.clazz(m,{_elemNm:"ojcombobox",_classNm:"oj-combobox",_createContainer:function(){return t(document.createElement("div")).attr({class:"oj-combobox oj-combobox-multi oj-component"}).html(["<ul class='oj-combobox-choices'>","  <li class='oj-combobox-search-field'><span class='oj-helper-hidden'>&nbsp;</span>","    <input type='text' role='combobox' aria-expanded='false' aria-autocomplete='list' autocomplete='off' autocorrect='off' autocapitalize='off' spellcheck='false' class='oj-combobox-input'>","  </li>","</ul>","<div class='oj-combobox-description oj-helper-hidden-accessible'/>","<div class='oj-listbox-drop oj-listbox-drop-multi'>","   <ul class='oj-listbox-results' role='listbox'>","   </ul>","</div>","<div role='region' class='oj-helper-hidden-accessible oj-listbox-liveregion' aria-live='polite'></div>"].join(""))},_opening:function(e,t){this._resizeSearch(),y.superclass._opening.apply(this,arguments),this._focusSearch(),t||this._updateResults(!0),this.search.focus()},_clearSearch:function(){var e=this._getPlaceholder(),t=this._getMaxSearchWidth();null!=e&&h.isValueForPlaceholder(!0,this.getVal())&&h.isValueOptionsForPlaceholder(!0,this.getValOpts())?(this.search.attr("placeholder",e),this.search.val("").width(t>0?t:this.container.css("width")),this.searchContainer.width("100%")):(this.search.attr("placeholder",""),this.search.val("").width(10),this.searchContainer.width("auto"))},_resetSearchWidth:function(){this.search.width(10)},_getMaxSearchWidth:function(){return this.selection.width()-h.getSideBorderPadding(this.search)},_textWidth:function(e){var i=document.createElement("span"),s=document.createTextNode(e);i.style.display="none",i.appendChild(s),t("body").append(i);var n=t("body").find("span:last").width();return t("body").find("span:last").remove(),n},_resizeSearch:function(){var e,t,i,s,n=h.getSideBorderPadding(this.search);e=this._textWidth(this.search.val())+10,t=this.search.offset().left,(s=(i=this.selection.width())-(t-this.selection.offset().left)-n)<e&&(s=i-n),s<40&&(s=i-n),s<=0&&(s=e),this.search.width(Math.floor(s))}}),b=h.clazz(m,{_elemNm:"ojselect",_classNm:"oj-select",_userTyping:!1,_createContainer:function(){return t(document.createElement("div")).attr({class:"oj-select oj-select-multi oj-component"}).html(["<ul class='oj-select-choices' tabindex='0' role='combobox' ","  aria-autocomplete='none' aria-expanded='false'>","</ul>","<div class='oj-select-description oj-helper-hidden-accessible'/>","<div class='oj-listbox-drop' role='dialog'>","  <div class='oj-listbox-search-wrapper'>","  <div class='oj-listbox-search'>","    <input type='text' autocomplete='off' autocorrect='off' autocapitalize='off'","           spellcheck='false' class='oj-listbox-input' title='Search field' ","           role='combobox' aria-expanded='false' aria-autocomplete='list' />","    <span class='oj-listbox-spyglass-box'>","      <span class='oj-component-icon oj-clickable-icon-nocontext oj-listbox-search-icon' role='presentation'>","       <b role='presentation'></b></span>","    </span>","  </div>","  </div>","   <ul class='oj-listbox-results' role='listbox'>","   </ul>","</div>","<div role='region' class='oj-helper-hidden-accessible oj-listbox-liveregion' aria-live='polite'></div>"].join(""))},_containerKeydownHandler:function(e){b.superclass._containerKeydownHandler.apply(this,arguments),this._userTyping&&!this._opened()&&this.open(e)},_opening:function(e,t){b.superclass._opening.apply(this,arguments),this._showDropDown();var i=h.getSearchText(e);this._showSearchBox(i),t||(i?this._updateResults():this._updateResults(!0))},close:function(e){!0===this._userTyping&&(this._userTyping=!1),b.superclass.close.apply(this,arguments),!e||e instanceof MouseEvent&&e.target!==this.selection&&e.target!==this.search||h._focus(this,this.selection)},_clearSearch:function(){var e=this._getPlaceholder();if(null!=e&&h.isValueForPlaceholder(!0,this.getVal())&&h.isValueOptionsForPlaceholder(!0,this.getValOpts())){var i=t("<li></li>");i.addClass("oj-select-default"),i.text(e),this.selection.append(i)}}}),E=h.clazz(g,{_elemNm:"ojinputsearch",_classNm:"oj-inputsearch",_createContainer:function(){var e=t(document.createElement("div")).attr({class:"oj-inputsearch oj-component"}).html(["<div class='oj-inputsearch-choice' tabindex='-1' role='presentation'>","   <input type='text' autocomplete='off' autocorrect='off' autocapitalize='off'","       spellcheck='false' class='oj-inputsearch-input' role='combobox' aria-expanded='false' aria-autocomplete='list' />","   <a class='oj-inputsearch-search-button oj-inputsearch-search-icon oj-component-icon oj-clickable-icon-nocontext'","       role='button' aria-label='search'></a>","</div>","<div class='oj-listbox-drop' role='presentation'>","   <ul class='oj-listbox-results' role='listbox'>","   </ul>","</div>","<div role='region' class='oj-helper-hidden-accessible oj-listbox-liveregion' aria-live='polite'></div>"].join("")),i=e.find(".oj-inputsearch-search-button");return this._attachSearchIconClickHandler(i),e},_attachSearchIconClickHandler:function(e){var t=this;e.on("click",function(e){if(t._isInterfaceEnabled()){if(t.opts.manageNewEntry){var i=t.search.val(),s=t.opts.manageNewEntry(i),n={trigger:h.ValueChangeTriggerTypes.SEARCH_ICON_CLICKED},o=t.selection.data(t._elemNm);!o&&""!==i||o&&o.label!==i||!t.ojContext.isValid()&&i!==t._previousDisplayValue?(t._onSelect(s,n,e),t._triggerUpdateEvent(s,n,e)):(o&&o.label===i&&(s=o),t._triggerUpdateEvent(s,n,e))}return!1}}).on("mousedown",function(e){return e.stopPropagation(),!1})},_enable:function(e){E.superclass._enable.apply(this,arguments),this._enabled?this.container.find(".oj-inputsearch-search-button").removeClass("oj-disabled"):this.container.find(".oj-inputsearch-search-button").addClass("oj-disabled")},_triggerUpdateEvent:function(e,t,i){var s;t&&(s=t.trigger);var n={_context:{optionMetadata:{trigger:s}}},o=this.id(e);if(o&&0!==o.length||(o=e.label?e.label:[]),void 0!==this.ojContext._AsyncValidate(o,i,n)&&this.ojContext.isValid()){"string"==typeof o&&(o=[o]);var r={value:o,optionMetadata:{trigger:s}};this.ojContext._trigger("update",i,r)}},_prepareOpts:function(e){var t=E.superclass._prepareOpts.apply(this,arguments);return t.highlightTermInOptions=function(){return!0},t}});e.__registerWidget("oj.ojCombobox",t.oj.editableValue,{defaultElement:"<input>",widgetEventPrefix:"oj",options:{asyncValidators:[],converter:null,filterOnOpen:"none",labelledBy:null,placeholder:null,options:null,optionsKeys:{},pickerAttributes:null,optionRenderer:null,minLength:0,rawValue:null,required:!1,readOnly:!1,validators:[],valueOption:null,valueOptions:null,valueUpdated:null},widget:function(){return this.combobox.container},_ComponentCreate:function(){this._super(),h.wrapDataProviderIfNeeded(this,null),this._setup()},_AfterCreate:function(){this._super(),this._IsCustomElement()&&e.EditableValueUtils._setInputId(this._GetContentElement()[0],this.OuterWrapper.id,this.options.labelledBy)},_InitOptions:function(t,i){if(this._super(t,i),e.EditableValueUtils.initializeOptionsFromDom([{attribute:"disabled",validateOption:!0},{attribute:"placeholder"},{attribute:"required",coerceDomValue:!0,validateOption:!0},{attribute:"title"}],i,this),this.multiple=this._IsCustomElement()?"OJ-COMBOBOX-MANY"===this.OuterWrapper.nodeName:this.options.multiple,void 0===this.options.value)this._IsCustomElement()||(this.options.value=void 0!==this.element.attr("value")?h.splitVal(this.element.val(),","):null);else{var s=this.options.value;Array.isArray(s)?this._IsCustomElement()||(s=s.slice(0)):"string"==typeof s&&(!0===this.multiple?s=h.splitVal(s,","):this._IsCustomElement()||(s=[s])),this.options.value=s}},_IsRequired:function(){return this.options.required},_labelledByChangedForInputComp:e.EditableValueUtils._labelledByChangedForInputComp,_AfterSetOptionRequired:e.EditableValueUtils._AfterSetOptionRequired,_AfterSetOptionValidators:e.EditableValueUtils._AfterSetOptionValidators,_AfterSetOptionAsyncValidators:e.EditableValueUtils._AfterSetOptionAsyncValidators,_AfterSetOptionConverter:e.EditableValueUtils._AfterSetOptionConverter,_ResetConverter:e.EditableValueUtils._ResetConverter,_GetConverter:e.EditableValueUtils._GetConverter,_GetNormalizedValidatorsFromOption:e.EditableValueUtils._GetNormalizedValidatorsFromOption,_GetNormalizedAsyncValidatorsFromOption:e.EditableValueUtils._GetNormalizedAsyncValidatorsFromOption,_setup:function(){var e={},i=this.multiple;e.element=this.element,e.ojContext=this,h.isValueForPlaceholder(i,this.options.value)&&(i?this.options.valueOptions=h.getValueOptionsForPlaceholder(this,this.options.valueOptions):this.options.valueOption=h.getValueOptionsForPlaceholder(this,this.options.valueOption)),e=t.extend(this.options,e),this.combobox=i?new y:new g,this.combobox._init(e),this._refreshRequired(this.options.required),this._resolveValueOptionsLater=h.mergeValueAndValueOptions(this)},_refreshRequired:e.EditableValueUtils._refreshRequired,_AriaRequiredUnsupported:function(){return!1},_destroy:function(){this.combobox._destroy(),this._super()},refresh:function(){this._super(),this.combobox._destroy(),this._setup(),this._SetRootAttributes()},_setOption:function(e,t,i){var s=t,n=this.multiple;if("value"===e&&(Array.isArray(s)?this._IsCustomElement()||(s=s.slice(0)):"string"==typeof s&&(!0===n?s=h.splitVal(s,","):this._IsCustomElement()||(s=[s])),i&&i._context&&i._context.optionMetadata?this.combobox.valueChangeTrigger=i._context.optionMetadata.trigger:this.combobox.valueChangeTrigger=null,"string"==typeof this.options.placeholder&&(null==s||s&&0===s.length||this._IsCustomElement()&&h.isValueForPlaceholder(n,s))))return h.setValueOptions(this,h.getFixupValueOptionsForPlaceholder(n)),void this._super(e,s,i);if("options"===e?(h.removeDataProviderEventListeners(this),h.clearDataProviderWrapper(this)):"valueOption"===e&&!0!==n?(s=h.getValueOptionsForPlaceholder(this,s),this.combobox.opts.valueOption=s):"valueOptions"===e&&!0===n&&(s=h.getValueOptionsForPlaceholder(this,s),this.combobox.opts.valueOptions=s),this._super(e,s,i),"valueOption"===e&&!0!==n)h.syncValueWithValueOption(this,s,this.options.value,!1);else if("valueOptions"===e&&!0===n)h.syncValueWithValueOptions(this,s,this.options.value,!1);else if("value"===e)h.updateValueOptions(this.combobox);else if("options"===e)h.isDataProvider(s)&&(h.wrapDataProviderIfNeeded(this,this.combobox?this.combobox.opts:null),h.addDataProviderEventListeners(this)),this.combobox.opts.options=s,this.combobox.opts=this.combobox._prepareOpts(this.combobox.opts);else if("disabled"===e)s?this.combobox._disable():this.combobox._enable();else if("readOnly"===e)this.combobox.applyReadonlyState();else if("labelledBy"===e&&this.options.labelledBy){var o=this._GetContentElement()[0].id;this._labelledByChangedForInputComp(this.options.labelledBy,o)}},_AfterSetOption:function(e,t,i){switch(this._superApply(arguments),e){case"required":this._AfterSetOptionRequired(e);break;case"validators":this._AfterSetOptionValidators(e);break;case"converter":this._AfterSetOptionConverter(e);break;case"asyncValidators":this._AfterSetOptionAsyncValidators(e)}},_NotifyDetached:function(){this._superApply(arguments),this.combobox.close()},_NotifyHidden:function(){this._superApply(arguments),this.combobox.close()},_VerifyConnectedForSetup:function(){return!0},_SetDisplayValue:function(e){h.applyValueOptions(this.combobox,this.options)?this.multiple&&this.combobox._clearSearch():this.combobox._initSelection(),this._resolveValueOptionsLater=!1},_SetPlaceholder:function(e){this.combobox&&(this.combobox.opts.placeholder=e,this.combobox._setPlaceholder&&this.combobox._setPlaceholder())},_parseValue:function(e){var t,i=e;if("string"==typeof i&&(!0===this.multiple?i=h.splitVal(i,","):this._IsCustomElement()||(i=[i])),Array.isArray(i)){t=[];for(var s=0;s<i.length;s++){var n=this._super(i[s]);t.push(n)}}else t=this._super(i);return t},_GetMessagingLauncherElement:function(){return this.combobox.search},_NotifyContextMenuGesture:function(e,t,i){var s=this._GetMessagingLauncherElement();this._OpenContextMenu(t,i,{launcher:s})},_GetContentElement:function(){return this.combobox.search},_GetDefaultStyleClass:function(){return"oj-combobox"},_SetLoading:function(){this._super(),this.combobox.applyReadonlyState()},_ClearLoading:function(){this._super(),this.combobox.applyReadonlyState()},validate:function(){var e,t=this._getDisplayValueForSetValue();return e=this._SetValue(t,null,this._VALIDATE_METHOD_OPTIONS),this._IsCustomElement()&&(e=e instanceof Promise?e.then(function(e){return Promise.resolve(e?"valid":"invalid")}):Promise.resolve(e?"valid":"invalid")),e},_CanSetValue:function(){return!!this.forceCanSetValue||this._super()},_getDisplayValueForSetValue:function(){var e=null,t=null;if(!0!==this.multiple)e=this.combobox.getValOpts()?this.combobox.getValOpts().value:null,t=this._IsCustomElement()?e:null==e||""===e?[]:[e];else{var i=this.combobox.getVal()?this.combobox.getVal():[];null==(e=this.combobox.search.val())||""===e?t=i:(i.push(e),t=i)}return t},_getDropdown:function(){if(this.combobox&&this.combobox._opened())for(var e=t(".oj-listbox-drop"),i=0;i<e.length;i++)if("oj-listbox-drop"===t(e[i]).attr("id")&&t(e[i]).attr("data-oj-containerid")===this.combobox.containerId)return t(e[i]);return null},_findItem:function(e,i){for(var s=0;s<e.length;s++)if(t(e[s]).data("ojcombobox").value===i)return e[s];return null},getNodeBySubId:function(e){var i,s=null;if(null==e)return this.combobox.container?this.combobox.container[0]:null;if(!(s=this._super(e))){"oj-combobox-drop"===(i=e.subId)&&(i="oj-listbox-drop"),"oj-combobox-results"===i&&(i="oj-listbox-results"),"oj-combobox-selection"===i&&(i="oj-combobox-selected-choice");var n=this._getDropdown();switch(i){case"oj-combobox-input":case"oj-combobox-arrow":s=this.widget().find("."+i)[0];break;case"oj-listitem":if(n){var o=n.find(".oj-listbox-result");s=this._findItem(o,e.value)}break;case"oj-combobox-remove":var r=this.widget().find(".oj-combobox-selected-choice"),a=this._findItem(r,e.value);s=a?t(a).find(".oj-combobox-clear-entry-icon")[0]:null;break;case"oj-listbox-drop":n&&(s=n[0]);break;case"oj-listbox-results":n&&(s=n.find("."+i)[0]);break;case"oj-combobox-selected-choice":s=this.widget().find("."+i).toArray()}}return s||null},getSubIdByNode:function(e){var i=null;if(null!=e){var s=t(e);i=s.hasClass("oj-combobox-input")?{subId:"oj-combobox-input"}:s.hasClass("oj-combobox-arrow")?{subId:"oj-combobox-arrow"}:s.hasClass("oj-listbox-result")?{subId:"oj-listitem",value:s.data("ojcombobox").value}:s.hasClass("oj-combobox-clear-entry-icon")?{subId:"oj-combobox-remove",value:s.closest(".oj-combobox-selected-choice").data("ojcombobox").value}:this._super(e)}return i}}),e.__registerWidget("oj.ojInputSearch",t.oj.editableValue,{defaultElement:"<input>",widgetEventPrefix:"oj",options:{placeholder:void 0,required:!1,list:void 0,options:null,optionsKeys:null,pickerAttributes:null,optionRenderer:null,minLength:0,beforeExpand:null,rawValue:void 0,optionChange:null,update:null,validators:void 0},widget:function(){return this.inputSearch.container},_ComponentCreate:function(){this._super(),this._setup()},_InitOptions:function(t,i){if(this._super(t,i),e.EditableValueUtils.initializeOptionsFromDom([{attribute:"disabled",validateOption:!0},{attribute:"placeholder"},{attribute:"required",coerceDomValue:!0,validateOption:!0},{attribute:"title"}],i,this),void 0===this.options.value)this.options.value=void 0!==this.element.attr("value")?h.splitVal(this.element.val(),","):null;else{var s=this.options.value;Array.isArray(s)?s=s.slice(0):"string"==typeof s&&(s=[s]),this.options.value=s}},_AfterSetOption:function(e,t,i){switch(this._superApply(arguments),e){case"required":this._AfterSetOptionRequired(e);break;case"validators":this._AfterSetOptionValidators(e)}},_IsRequired:function(){return this.options.required},_AfterSetOptionRequired:e.EditableValueUtils._AfterSetOptionRequired,_AfterSetOptionValidators:e.EditableValueUtils._AfterSetOptionValidators,_refreshRequired:e.EditableValueUtils._refreshRequired,_GetNormalizedValidatorsFromOption:e.EditableValueUtils._GetNormalizedValidatorsFromOption,_AriaRequiredUnsupported:function(){return!1},_setup:function(){var e={};e.element=this.element,e.ojContext=this,e.inputSearch=!0,e=t.extend(this.options,e),this.inputSearch=new E,this.inputSearch._init(e),this._refreshRequired(this.options.required)},_destroy:function(){this.inputSearch._destroy(),this._super()},refresh:function(){this._super(),this.inputSearch._destroy(),this._setup(),this._SetRootAttributes()},_setOption:function(e,t,i){var s=t;"value"===e&&(null!=s&&(Array.isArray(s)?s=s.slice(0):"string"==typeof s?s=[s]:r.error("ojInputSearch value has to be an array of string or a string.")),i&&i._context&&i._context.optionMetadata?this.inputSearch.valueChangeTrigger=i._context.optionMetadata.trigger:this.inputSearch.valueChangeTrigger=null),this._super(e,s,i),"options"===e&&(this.inputSearch.opts.options=s,this.inputSearch.opts=this.inputSearch._prepareOpts(this.inputSearch.opts)),"disabled"===e&&(s?this.inputSearch._disable():this.inputSearch._enable())},_NotifyDetached:function(){this._superApply(arguments),this.inputSearch.close()},_NotifyHidden:function(){this._superApply(arguments),this.inputSearch.close()},_SetDisplayValue:function(e){this.inputSearch._initSelection()},_SetPlaceholder:function(e){this.inputSearch&&(this.inputSearch.opts.placeholder=e,this.inputSearch._setPlaceholder&&this.inputSearch._setPlaceholder())},validate:function(){var e=this.inputSearch.search.val(),t=null,i=[];return this.isValid()&&(i=this.inputSearch.getVal()),t=null==e||""===e?i:[e],this._SetValue(t,null,this._VALIDATE_METHOD_OPTIONS)},_parseValue:function(e){var t,i=[];if(null==e)return i;if(Array.isArray(e))for(var s=0;s<e.length;s++)t=this._super(e[s]),i.push(t.toString());else"string"==typeof e?(t=this._super(e),i.push(t.toString())):r.error("ojInputSearch value has to be an array of string or a string.");return i},_GetMessagingLauncherElement:function(){return this.inputSearch.search},_GetContentElement:function(){return this.inputSearch.search},_GetDefaultStyleClass:function(){return"oj-inputsearch"},_getDropdown:function(){if(this.inputSearch&&this.inputSearch._opened())for(var e=t(".oj-listbox-drop"),i=0;i<e.length;i++)if("oj-listbox-drop"===t(e[i]).attr("id")&&t(e[i]).attr("data-oj-containerid")===this.inputSearch.containerId)return t(e[i]);return null},expand:function(){this.inputSearch.open()},collapse:function(){this.inputSearch.close()},getNodeBySubId:function(e){var t,i=null;if(null===e)return this.inputSearch.container?this.inputSearch.container[0]:null;if(!(i=this._super(e)))switch("oj-inputsearch-search"===(t=e.subId)&&(t="oj-inputsearch-search-button"),t){case"oj-inputsearch-input":case"oj-inputsearch-search-button":i=this.widget().find("."+t)[0];break;case"oj-listitem":var s=this._getDropdown();if(s){var n=s.find(".oj-listbox-result");i=this.inputSearch._findItem(n,e.value)}}return i||null},getSubIdByNode:function(e){var i=null;if(null!=e){var s=t(e);i=s.hasClass("oj-inputsearch-input")?{subId:"oj-inputsearch-input"}:s.hasClass("oj-inputsearch-search-button")?{subId:"oj-inputsearch-search"}:s.hasClass("oj-listbox-result")?{subId:"oj-listitem",value:s.data("ojinputsearch").value}:this._super(e)}return i}}),
e.__registerWidget("oj.ojSelect",t.oj.editableValue,{defaultElement:"<select>",widgetEventPrefix:"oj",options:{labelledBy:null,minimumResultsForSearch:15,placeholder:null,optionRenderer:null,options:null,optionsKeys:{},pickerAttributes:null,required:!1,readOnly:!1,renderMode:"jet",valueOption:null,valueOptions:null},widget:function(){return this.select?this.select.container:this.element.parent()},_ComponentCreate:function(){this._super(),h.wrapDataProviderIfNeeded(this,null),this._setup()},_AfterCreate:function(){var t;if(this._super(),this._IsCustomElement()&&this.options.labelledBy){var i=this.uuid+"_Label";!(t=e.EditableValueUtils._getOjLabelAriaLabelledBy(this.options.labelledBy,i))||this.multiple&&h.isReadonly(this)||this._GetContentElement().attr("aria-labelledby",t),this._IsRequired()&&this.options.translations.required&&(this._implicitReqValidator=null,this._getImplicitRequiredValidator())}},_AfterSetOption:function(e,t,i){switch(this._superApply(arguments),e){case"required":this._AfterSetOptionRequired(e)}},_IsRequired:function(){return this.options.required},_AfterSetOptionRequired:e.EditableValueUtils._AfterSetOptionRequired,_nativeSetDisabled:function(e){e?(this.element.attr("disabled",""),this.element.parent().addClass("oj-disabled").removeClass("oj-enabled")):(this.element.removeAttr("disabled"),this.element.parent().removeClass("oj-disabled").addClass("oj-enabled"))},_nativeChangeHandler:function(e){var i=[],s=[],n=!this._IsRequired()&&this._HasPlaceholderSet();t(e.target).find("option").each(function(){this.selected&&(this.value||n&&""===this.value)&&(i.push(this.value),s.push({value:this.value,label:this.text}))}),h.duringFetchByKey(this.element)&&h.setValueChanged(this,!0),this._IsCustomElement()&&!0!==this.multiple?(this._SetValue(i[0],e,{doValueChangeCheck:!1,_context:{internalSet:!0}}),h.setValueOptions(this,s[0])):(this._SetValue(i,e,{doValueChangeCheck:!1,_context:{internalSet:!0}}),h.setValueOptions(this,s))},_nativeQueryCallback:function(e){if(e){var t=this.element;h.arrayPopulateResults(t,e,this._formatValue.bind(this),h.isDataProvider(this.options.options)?null:this.options.optionsKeys),t.addClass(h.GENERATED_OPTIONS_SELECTOR)}},_nativeSetSelected:function(e){var t=null;if(e)t=e;else if(this._HasPlaceholderSet()&&(this.options.required&&(t=this._nativeFindFirstEnabledOptionValue()),this._SetPlaceholder(this.options.placeholder)),null===t){var i=this._nativeFindFirstEnabledOption();t=this._nativeFindFirstEnabledOptionValue(i),h.setValueOptions(this,{value:t,label:i.text()})}this._setInitialSelectedValue(t)},_nativeFetchFromDataProvider:function(){var e=this;h.fetchFirstBlockFromDataProvider(this.element,e.options).then(function(t){if(e._nativeQueryCallback(t),t.length){var i=e.options.value;i?h.validateFromDataProvider(e.element,e.options,i).then(function(t){var i,s;if(h.isValueChanged(e)&&!1===e.multiple)h.setValueChanged(e,void 0);else if(h.isValueChanged(e)&&e.multiple&&(s=e.options.valueOptions,i=e.options.value,h.setValueChanged(e,void 0)),t){var n=t.valueOptions;Array.isArray(n)&&n.length&&h.setValueOptions(e,s?n.concat(s):n);var o=t.value;if(Array.isArray(o)&&o.length){i=i?o.concat(i):o;var r=e.multiple?i:o[0];e._nativeSetSelected(r),e.multiple&&1!==r.length||(e.element[0].value=r)}}}):e._nativeSetSelected()}})},_nativeSetup:function(){var e=this.element;if(e.wrap("<div>").parent().addClass("oj-select-native oj-component oj-select oj-form-control"),e.addClass("oj-select-select oj-component-initnode"),this.multiple?(e[0].multiple||(e[0].multiple=!0),e.parent().prepend("<a class='oj-select-arrow oj-component-icon oj-clickable-icon-nocontext oj-select-multiple-open-icon' role='presentation'></a>")):e.parent().prepend("<a class='oj-select-arrow oj-component-icon oj-clickable-icon-nocontext oj-select-open-icon' role='presentation'></a>"),this._nativeSetDisabled(this.options.disabled),this.options.list)h.listPopulateResults(e,t("#"+this.options.list).children(),this._formatValue.bind(this)),e.addClass(h.GENERATED_OPTIONS_SELECTOR);else if(this.options.options)h.getDataProvider(this.options)?this._nativeFetchFromDataProvider():this._nativeQueryCallback(this.options.options);else if(this._IsCustomElement()){var i=e.children();1===i.length&&i.hasClass("oj-listbox-placeholder")||(h.ojOptionPopulateResults(e,i,this._formatValue.bind(this)),e.addClass(h.GENERATED_OPTIONS_SELECTOR))}this._focusable({element:e,applyHighlight:!0}),this.options.value||this._HasPlaceholderSet()||h.getDataProvider(this.options)||this._setInitialSelectedValue(this._nativeFindFirstEnabledOptionValue()),e.change(this._nativeChangeHandler.bind(this)),h.addDataProviderEventListeners(this)},_jetSetup:function(){var e={};e.element=this.element,e.ojContext=this,e=t.extend(this.options,e),this.select=this.multiple?new b:new v,this.select._init(e),this.select.container.addClass("oj-select-jet oj-form-control"),this._focusable({element:this.select.selection,applyHighlight:!0})},_setInitialSelectedValue:function(e){var t;t=this._IsCustomElement()?e:Array.isArray(e)?e:[e],this._SetValue(t,null,{doValueChangeCheck:!1,_context:{internalSet:!0,writeback:!0},changed:!0})},_setup:function(){h.isValueForPlaceholder(this.multiple,this.options.value)&&(this.multiple?this.options.valueOptions=h.getValueOptionsForPlaceholder(this,this.options.valueOptions):this.options.valueOption=h.getValueOptionsForPlaceholder(this,this.options.valueOption)),this._resolveValueOptionsLater=h.mergeValueAndValueOptions(this),this._isNative()?this._nativeSetup():this._jetSetup(),this._refreshRequired(this.options.required)},refresh:function(){this._super(),this._cleanup(),this._setup(),this._isNative()&&this.options.value&&this.element.val(this.options.value),this._SetRootAttributes()},_refreshRequired:e.EditableValueUtils._refreshRequired,_AriaRequiredUnsupported:function(){return!1},_destroy:function(){this._cleanup(),this._super()},_NotifyDetached:function(){this._superApply(arguments),this.select&&this.select.close()},_NotifyHidden:function(){this._superApply(arguments),this.select&&this.select.close()},_VerifyConnectedForSetup:function(){return!0},_SetPlaceholder:function(e){if(this._isNative()&&null!=e){var i=t(this.element.children("option:first-child"));i&&""===i.attr("value")?(i.text(this.options.placeholder),i.attr("value","")):((i=h.createOptionTag(0,"",e,this._formatValue.bind(this))).addClass("oj-listbox-placeholder"),this._hidePlaceholder(i,this._IsRequired()),i.prependTo(this.element))}},_HasPlaceholderSet:function(){return h.isPlaceholderSpecified(this.options)},_ClearPlaceholder:function(){this._SetPlaceholderOption(null),this._SetPlaceholder(null)},_InitOptions:function(t,i){if(this._super(t,i),e.EditableValueUtils.initializeOptionsFromDom([{attribute:"disabled",validateOption:!0},{attribute:"placeholder"},{attribute:"required",coerceDomValue:!0,validateOption:!0},{attribute:"title"}],i,this),this.multiple=this._IsCustomElement()?"OJ-SELECT-MANY"===this.OuterWrapper.nodeName:this.options.multiple,void 0===this.options.value)this._IsCustomElement()||(this.options.value=void 0!==this.element.attr("value")?h.splitVal(this.element.val(),","):null);else{var s=this.options.value;Array.isArray(s)&&(this._IsCustomElement()||(s=s.slice(0))),this.options.value=s}},_SetDisplayValue:function(e){if(this.select)h.applyValueOptions(this.select,this.options)||this.select._initSelection(),this._resolveValueOptionsLater=!1;else{var t;if(null==e)this._HasPlaceholderSet()&&(this.element[0].selectedIndex=0,this.element.addClass("oj-select-default")),this._resolveValueOptionsLater&&h.setValueOptions(this,h.getFixupValueOptionsForPlaceholder(this.multiple));else{var i,s=!1,n=e;if(this.multiple||(Array.isArray(e)&&(n=e[0]),null===(i=this._nativeFindLabel(n))&&(r.warn("JET select: selected value not found"),this.element[0].options&&this.element[0].options.length>0?(this.element[0].selectedIndex=0,n=this.element[0].value,i=this.element[0].text,s=!0):i=String(e))),s||this.element.val(e),e=n,this._resolveValueOptionsLater){if(this.multiple){var o=0;t=[],this.element.find("option").each(function(){this.selected&&(t.push({value:e[o],label:this.text}),o+=1)})}else t={value:e,label:i};h.setValueOptions(this,t)}}this._resolveValueOptionsLater=!1}},validate:function(){var e;if(!0===this.multiple){var t=this.select.search.val(),i=this.select.getVal()?this.select.getVal():[],s=null;null==t||""===t?s=i:(i.push(t),s=i),e=this._SetValue(s,null,this._VALIDATE_METHOD_OPTIONS)}return this.select&&(e=this._SetValue(this.select.getVal(),null,this._VALIDATE_METHOD_OPTIONS)),this._IsCustomElement()&&(e=Promise.resolve(e?"valid":"invalid")),e},_CanSetValue:function(){return!!this.forceCanSetValue||this._super()},_nativeFindFirstEnabledOption:function(){var e;return(e=h.isTreeDataProvider(this.options.options)?this.element.find("option:not(:disabled)"):this.element.children("option:not(:disabled)")).length>0?t(e[0]):null},_nativeFindFirstEnabledOptionValue:function(e){return e||(e=this._nativeFindFirstEnabledOption()),e?this._IsCustomElement()?e.attr("value"):[e.attr("value")]:null},_nativeSetOptions:function(e){var t=this.options.value,i=this.element;if(i.hasClass(h.GENERATED_OPTIONS_SELECTOR))h.cleanupResults(i);else{var s=i.children();s.length>0&&s.remove()}if(h.isDataProvider(e))this._nativeFetchFromDataProvider();else{h.arrayPopulateResults(i,e,this._formatValue.bind(this),this.options.optionsKeys);var n=null;this._HasPlaceholderSet()&&(this.options.required&&(n=this._nativeFindFirstEnabledOptionValue()),this._SetPlaceholder()),null===n&&(n=this._nativeFindFirstEnabledOptionValue()),this.options.value=n,this.option("value",t)}i.addClass(h.GENERATED_OPTIONS_SELECTOR)},_removePlaceholderInMultiValues:function(e){for(var t,i=[],s=0;s<e.length;s++)null!=(t=e[s])&&(t.length>0?(1===i.length&&""===i[0]&&i.pop(),i.push(t)):0===i.length&&i.push(t));return i},_nativeFindLabel:function(e){var i=this.element[0].options;if(i&&i.length>0)for(var s=0;s<i.length;s++)if(i[s].value===e)return t(i[s]).text();return null},_setOption:function(i,s,n){var o,r=s,a=this,l=this._super,u=this.multiple;if("value"!==i)if("placeholder"===i?this.select?(this.select.opts.placeholder=r,h.isValueForPlaceholder(u,this.options.value)&&this.select._setPlaceholder()):(o=this.options.value)&&0!==o.length&&o[0]||(this.element[0].selectedIndex=0):"minimumResultsForSearch"===i?this.select&&(this.select.opts.minimumResultsForSearch=r):"renderMode"===i&&(this._cleanup(),this.options.renderMode=r,this.refresh()),"options"===i?(h.removeDataProviderEventListeners(this),h.clearDataProviderWrapper(this)):"valueOption"===i&&!0!==u?(r=h.getValueOptionsForPlaceholder(this,r),this.select&&(this.select.opts.valueOption=r)):"valueOptions"===i&&!0===u&&(r=h.getValueOptionsForPlaceholder(this,r),this.select&&(this.select.opts.valueOptions=r)),this._super(i,r,n),"disabled"===i)this.select?r?this.select._disable():this.select._enable():this._nativeSetDisabled(r);else if("readOnly"===i)this.select&&this.select.applyReadonlyState(),"native"===this.options.renderMode&&this.refresh();else if("valueOption"===i&&!0!==u)h.syncValueWithValueOption(this,r,this.options.value,this._isNative());else if("valueOptions"===i&&!0===u)h.syncValueWithValueOptions(this,r,this.options.value,this._isNative());else if("options"===i)h.isDataProvider(r)&&(h.wrapDataProviderIfNeeded(this,this.select?this.select.opts:null),h.addDataProviderEventListeners(this)),this.select?(o=this.select.getVal(),h.getDataProvider(this.options)&&o?h.applyValueOptions(this.select,this.options)?(this.select.opts.options=r,this.select.opts=a.select._prepareOpts(this.select.opts)):h.validateFromDataProvider(this.select.container,this.options,this.options.value).then(function(e){var t=e?e.value:null;if(t){var i=e.valueOptions;Array.isArray(i)&&i.length&&h.setValueOptions(a,i),Array.isArray(t)&&t.length&&l.call(a,"value",u?t:t[0])}else a.options.placeholder?u||a.select._updateSelectedOption(a.options.placeholder):h.fetchFirstBlockFromDataProvider(a.select.container,a.options,1).then(function(e){e&&e.length>0&&o===a.select.getVal()?a.select._updateSelectedOption(e[0]):(l.call(a,"value",null),u||a.select.text.text(""))});a.select.opts.options=r,a.select.opts=a.select._prepareOpts(a.select.opts)}):(this.select.opts.options=r,this.select.opts=this.select._prepareOpts(this.select.opts),this.select.setValOpts(null),this._super("value",o))):this._nativeSetOptions(r);else if("required"===i&&this._isNative()){var c=t(this.element.find(".oj-listbox-placeholder"));c&&""===c.attr("value")&&this._hidePlaceholder(c,r)}else if("multiple"!==i||this._IsCustomElement()){if("labelledBy"===i&&this.options.labelledBy){var p=this.uuid+"_Label",d=e.EditableValueUtils._getOjLabelAriaLabelledBy(this.options.labelledBy,p);!d||this.multiple&&h.isReadonly(this)||this._GetContentElement().attr("aria-labelledby",d),this._IsRequired()&&this.options.translations.required&&(this._implicitReqValidator=null,this._getImplicitRequiredValidator())}}else this.multiple=r;else{if(this._HasPlaceholderSet()&&(r&&0===r.length||this._IsCustomElement()&&h.isValueForPlaceholder(u,r)))return h.setValueOptions(this,h.getFixupValueOptionsForPlaceholder(u)),void this._super(i,r,n);var _;this.select&&((_=this.select.datalist)||(_=this.select.opts.element));var f=this._IsCustomElement()&&!u;if(Array.isArray(r)||f||(r=[r]),this._isNative()&&(f||(r=this._removePlaceholderInMultiValues(r)),!this._IsCustomElement()&&1===r.length&&""===r[0]||this._IsCustomElement()&&this._HasPlaceholderSet()&&h.isValueForPlaceholder(u,r)?this.element.addClass("oj-select-default"):this.element.removeClass("oj-select-default")),h.getDataProvider(this.options)&&r)return this.select&&(this.select.opts.options=this.options.options),void h.validateFromDataProvider(this._isNative()?this.element:this.select.container,this.options,r).then(function(e){if(e){var t=e.valueOptions;Array.isArray(t)&&t.length&&h.setValueOptions(a,t);var s=e.value;if(Array.isArray(s)&&s.length){var n=u?s:s[0];l.call(a,i,n),a._isNative()&&(a.element[0].value=n)}}});if(!f){for(var g=[],v=0;v<r.length;v++)this.select?(!this.select.opts.validate||this.select.opts.validate(_,r[v])||this._isOptionDataPending())&&g.push(r[v]):this.element.find("option[value='"+r[v]+"']").length>0&&g.push(r[v]);return void((g.length>0||u)&&(this._isNative()?this._nativeSetSelected(g):(this._super(i,g,n),h.updateValueOptions(this.select))))}this.select&&this.select.opts.validate&&!this.select.opts.validate(_,r)&&!this._isOptionDataPending()||(this._super(i,r,n),h.updateValueOptions(this.select))}},_isOptionDataPending:function(){var e=this.options.options,t=this.select.datalist;if(t){if(0===t.children().length)return!0}else{if(h.isDataProvider(e))return!0;if(!e||0===e.length)return!0}return!1},_getDropdown:function(){if(this.select&&this.select._opened()){var e=this.select.dropdown;if(e&&e.attr("data-oj-containerid")===this.select.containerId)return e}return null},_hidePlaceholder:function(e,t){t?(e.attr("disabled",""),e.attr("hidden","")):(e.removeAttr("disabled"),e.removeAttr("hidden"))},_isNative:function(){return"native"===this.options.renderMode&&!h.isReadonly(this)},_cleanup:function(){this.element.parent().hasClass("oj-select-native")?(this.element.off("change"),this.element.hasClass(h.GENERATED_OPTIONS_SELECTOR)&&h.cleanupResults(this.element),this.element.parent().hasClass("oj-select-native")&&(this.element.parent().children(".oj-select-arrow").remove(),this.element.unwrap()),this.element.removeClass("oj-select-select oj-component-initnode"),this.element.attr({"aria-labelledby":""})):this.select&&(this.select._destroy(),this.select=void 0)},getNodeBySubId:function(e){var i,s=null;if(null==e){var n=this.widget();return n?n[0]:null}if(this._isNative())return null;if(!(s=this._super(e))){var o=this._getDropdown();switch(i=e.subId){case"oj-select-drop":o&&(s=o[0]);break;case"oj-select-results":o&&(s=o.find(".oj-listbox-results")[0]);break;case"oj-select-search":o&&(s=o.find(".oj-listbox-search")[0]);break;case"oj-select-input":case"oj-listbox-input":o&&(s=o.find(".oj-listbox-input")[0]);break;case"oj-select-choice":case"oj-select-chosen":case"oj-select-arrow":s=this.widget().find("."+i)[0];break;case"oj-listitem":if(o){var r=o.find(".oj-listbox-result");s=this.select._findItem(r,e.value)}break;case"oj-select-remove":var a=this.widget().find(".oj-select-selected-choice"),l=this.select._findItem(a,e.value);s=l?t(l).find(".oj-select-clear-entry-icon")[0]:null;break;case"oj-listbox-result-label":if(o){var u=t("#"+this.select.results.attr("id")).children(),c=e.index;u.length&&c<u.length&&(s=u.eq(c).find("."+i)[0])}}}return s||null},getSubIdByNode:function(e){if(this._isNative())return this._super(e);var i=null;if(null!=e){var s=t(e);i=s.hasClass("oj-listbox-input")?{subId:"oj-select-input"}:s.hasClass("oj-select-arrow")?{subId:"oj-select-arrow"}:s.hasClass("oj-listbox-result")?{subId:"oj-listitem",value:s.data("ojselect").value}:s.hasClass("oj-select-clear-entry-icon")?{subId:"oj-select-remove",value:s.closest(".oj-select-selected-choice").data("ojselect").value}:this._super(e)}return i},_GetDefaultStyleClass:function(){return"oj-select"},_GetMessagingLauncherElement:function(){return this.select?this.select.selection:this.element},_GetContentElement:function(){return this.select?this.select.selection:this.element}}),o.setDefaultOptions({ojSelect:{displayOptions:{converterHint:["none"]},renderMode:o.createDynamicPropertyGetter(function(){return(s.parseJSONFromFontFamily("oj-select-option-defaults")||{}).renderMode})}}),u.extension._WIDGET_NAME="ojCombobox",u.extension._INNER_ELEM="input",u.extension._ALIASED_PROPS={readonly:"readOnly"},e.CustomElementBridge.register("oj-combobox-one",{metadata:u}),l.extension._WIDGET_NAME="ojCombobox",l.extension._INNER_ELEM="input",l.extension._ALIASED_PROPS={readonly:"readOnly"},e.CustomElementBridge.register("oj-combobox-many",{metadata:l}),p.extension._WIDGET_NAME="ojSelect",p.extension._INNER_ELEM="select",p.extension._ALIASED_PROPS={readonly:"readOnly"},e.CustomElementBridge.register("oj-select-one",{metadata:p}),c.extension._WIDGET_NAME="ojSelect",c.extension._INNER_ELEM="select",c.extension._ALIASED_PROPS={readonly:"readOnly"},e.CustomElementBridge.register("oj-select-many",{metadata:c})}),function(e,t,i,s,n,o){"use strict";var r={};n.inputSearch=function(t,s,a){function l(e){var t,i=[];for(t=0;t<e.length;t++)i.push({label:e[t],value:e[t]});return i}function u(){f.trigger("apexbeforerefresh"),r={},o(t).setValue(""),f.ojInputSearch(m),f.trigger("apexafterrefresh")}var c,p,h,d,_,f=e("#"+i.escapeCSS(t+"_HIDDEN"),apex.gPageContext$),g=e("#"+i.escapeCSS(t)+"_LABEL",apex.gPageContext$),v=e("#"+i.escapeCSS(t),apex.gPageContext$),m=e.extend({ajaxIdentifier:null,itemsToSubmit:"",dependingOnSelector:"",optimizeRefresh:!0,matchCaseSensitive:!1,matchContains:!0,maxOptions:null,lazyLoad:!1,cache:!0,width:null,maxLength:null,elementAttributes:null,isEscaped:!0,minLength:1,placeholder:"",title:""},a),y=e.ui.keyCode;!m.lazyLoad&&s&&(m.options=l(s)),d=o.create(t,{enable:function(){f.ojInputSearch({disabled:!1})},disable:function(){f.ojInputSearch({disabled:!0})},getValue:function(){return p.val()},setValue:function(e){f.val(e),p.val(e)},setFocusTo:function(){return p},getPopupSelector:function(){return".oj-listbox-results"},reinit:function(e){r={},this.setValue(e,null,!0)},delayLoading:!0,isChanged:function(){return _!==p.val()},setStyleTo:function(){return p}}),require(["ojs/ojcore","ojs/ojselectcombobox"],function(s){var o;if(c=m.options,m.options=function(s){return new Promise(function(o,a){var u,p,h,d="",_="",g=[],v=s.term;if(void 0!==s.term)if(m.lazyLoad){if(m.cache&&(u=t+"_"+v,r[u]))return void o(r[u]);n.util.cascadingLov(f,m.ajaxIdentifier,{x01:v,pageItems:e(m.itemsToSubmit,apex.gPageContext$)},{optimizeRefresh:m.optimizeRefresh,dependingOn:e(m.dependingOnSelector,apex.gPageContext$),success:function(e){var t=l(e);m.cache&&(r[u]=t),o(t)},target:f})}else{for(m.matchContains||(d="^"),d+=i.escapeRegExp(v),m.matchCaseSensitive||(_="i"),h=new RegExp(d,_),p=0;p<c.length&&(!m.maxOptions||g.length<m.maxOptions);p++)c[p].label.match(h)&&g.push(c[p]);o(g)}})},f.ojInputSearch(m),_=f.val(),m.dependingOnSelector&&e(a.dependingOnSelector,apex.gPageContext$).change(function(){f.trigger("apexrefresh")}),f.on("apexrefresh",u),p=e(f.ojInputSearch("getNodeBySubId",{subId:"oj-inputsearch-input"})),h=e(f.ojInputSearch("getNodeBySubId",{subId:"oj-inputsearch-search"})),m.width&&p.attr("size",m.width),m.maxLength&&p.attr("maxlength",m.maxLength),m.elementAttributes){var b,E,S,O=i.htmlBuilder();O.markup("<input ").attr("id","customAttrHolder").attr("class","uVisuallyHidden").markup(m.elementAttributes).markup(" />"),e("body").append(O.toString()),b=e("#customAttrHolder"),S=b[0].attributes;for(E in S)S.hasOwnProperty(E)&&-1===e.inArray(S[E].name,["id","class"])&&p.attr(S[E].name,S[E].value);b.remove()}f.removeClass("oj-component-initnode"),o=f.attr("class"),f.attr("class","oj-component-initnode"),p.addClass("apex-item-text apex-item-auto-complete").addClass(o).attr("aria-labelledby",i.escapeCSS(t)+"_LABEL").val(_),f.on("ojbeforeexpand",function(){var t=i.escapeCSS(p.attr("aria-owns"));e("#"+t).attr("tabindex","-1")}),p.on("keydown",function(e){e.which===y.ENTER&&v.toggleClass("js-uses-enter",p.closest(".oj-inputsearch").hasClass("oj-listbox-dropdown-open"))}),g.on("click",function(){p.focus()}),h.remove(),v.find("span.apex-item-icon").insertAfter(p),d.resolve()})}}(apex.jQuery,apex.server,apex.util,apex.debug,apex.widget,apex.item),define("inputSearch",function(){}),define("inputSearchBundle.min",function(){});