# Oracle JET version 7.2.0

## About Oracle JET
Oracle JET is targeted at intermediate to advanced JavaScript developers working on client-side applications. It's a collection of open source JavaScript libraries along with a set of Oracle contributed JavaScript libraries that make it as simple and efficient as possible to build applications that consume and interact with Oracle products and services, especially Oracle Cloud services.

This is an open source project maintained by Oracle Corp.

### Features and Benefits:
Oracle JET is a modular toolkit allowing developers to use as much or as little of the features as they desire. Watch a short overview of what Oracle JET can do for you.

* Complete JavaScript development toolkit 
* Leverages popular open-source technologies
* Full lifecycle management for template based SPA
* Built in accessibility support
* Support for internationalization (28 languages and 160+ locales)
* Rich set of UI components
* Advanced two-way binding with a common model layer
* Powerful routing system supporting single-page application navigation
* Smart resource management
* For intermediate & advanced JS devs

## Examples
Here is a list of places to see Oracle JET in action:
* [Oracle JET website](http://oraclejet.org)
* [Oracle JET Cookbook](http://www.oracle.com/webfolder/technetwork/jet/jetCookbook.html) - Every component with live code demos
* [Sample applications and Tutorials](http://www.oracle.com/webfolder/technetwork/jet/globalExamples.html)


## Installation
Oracle JET provides a command-line interface to help scaffold up your applications.  To install and build a blank app, type:

```
npm install -g @oracle/ojet-cli

ojet create <app name>
```
See the [Oracle JET Developer Guide](http://www.oracle.com/pls/topic/lookup?ctx=jet720&id=homepage) for complete installation details, including prerequisites.

## Related GitHub Projects
All related projects on GitHub are associated under the [oracle-jet topic](https://github.com/search?q=topic%3Aoracle-jet+org%3Aoracle&type=Repositories).

## [Documentation](http://www.oracle.com/pls/topic/lookup?ctx=jet720&id=homepage)
Oracle JET comes with a full [Developers Guide](http://www.oracle.com/pls/topic/lookup?ctx=jet720&id=homepage) to help with Getting Started and many common issues.

## [Contributing](https://github.com/oracle/oraclejet/tree/master/CONTRIBUTING.md)
Oracle JET is an open source project. Pull Requests are currently not being accepted. See 
[CONTRIBUTING](https://github.com/oracle/oraclejet/tree/master/CONTRIBUTING.md)
for details.

## [License](https://github.com/oracle/oraclejet/tree/master/LICENSE.md)
Copyright (c) 2014, 2019 Oracle and/or its affiliates
The Universal Permissive License (UPL), Version 1.0