/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit', './DvtAxis', './DvtLegend', './DvtOverview'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){t.Chart=function(t,e,i){this.Init(t,e,i)},t.Obj.createSubclass(t.Chart,t.BaseComponent),t.Chart.newInstance=function(e,i,r){return new t.Chart(e,i,r)},t.Chart.getDefaults=function(t){return(new o).getDefaults(t)},t.Chart.prototype.Init=function(e,r,a){t.Chart.superclass.Init.call(this,e,r,a),this.Defaults=new o(e),this.EventManager=new i(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("chart1000"+Math.floor(1e9*Math.random())),this.legend=null,this.xAxis=null,this.yAxis=null,this.y2Axis=null,this.overview=null,this.xScrollbar=null,this.yScrollbar=null,this.dragButtons=null,this.pieChart=null,this.pieCenterDiv=null,this.Peers=[],this.SeriesStyleArray=[],this._numFrontObjs=0,this._numSelectedObjsInFront=0,this._dataLabels=null,this._rawOptions=null},t.Chart.prototype.GetComponentDescription=function(){var e=this.getOptions(),i=e.translations.componentName,r="",a=t.Context.ARIA_LABEL_DESC_DELIMITER;return e.title.text&&(r+=this.Options.title.text,e.subtitle.text&&(r+=a+this.Options.subtitle.text)),e.footnote.text&&(r=0==r.length?this.Options.footnote.text:r.concat(a,this.Options.footnote.text)),r.length>0?t.ResourceUtils.format(this.Options.translations.labelAndValue,[i,r]):i},t.Chart.prototype.SetOptions=function(e){e?(this._rawOptions=e,this.Options=this.Defaults.calcOptions(e),this.getOptionsCache().clearCache(),Q.processDataObject(this),(t.Agent.isEnvironmentTest()||at.isScatterBubble(this)&&Q.getSeriesCount(this)*Q.getGroupCount(this)>ct.FILTER_THRESHOLD_SCATTER_BUBBLE)&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults());var i=this.Options.selectionMode;this._selectionHandler="single"==i?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"==i?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):null,this.EventManager.setSelectionHandler(this._selectionHandler)},t.Chart.prototype.render=function(e,i,r){this.getCache().clearCache();var a=this.getCtx(),n=this.Options?this.Options.animationOnDataChange:"none",s="none"!=n?new G(this):null,o=this.__cacheChartFocus();this._container&&this.__cleanUp(),this.SetOptions(e),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r);var l=new t.Container(a);this.addChild(l),ut.render(this,l,new t.Rectangle(0,0,this.Width,this.Height)),at.isSpark(this)&&this.EventManager.removeListeners(this),this.StopAnimation();var h=et.getAnimationOnDisplay(this),u=et.getAnimationDuration(this),g=new t.Rectangle(0,0,this.Width,this.Height),d=!1;if(this._container){if("none"!=n&&e)if(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(a,n,this._container,l,g,u),this.Animation)d=!0;else if("auto"==n&&this.getPlotArea()){var c=this.__getPlotAreaSpace();this._delContainer=ct.createClippedGroup(this,this._container,new t.Rectangle(0,0,c.w,c.h)),this.Animation=H.createAnimation(s,this,n,u,this._delContainer),this._delContainer.getNumChildren()>0&&this.getPlotArea().addChild(this._delContainer)}}else"none"!=h&&(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(a,h,l,g,u),this.Animation||"auto"!=h||(this.Animation=N.createAnimation(this,h,u)));this.Animation?(this.EventManager.removeListeners(this),t.Playable.appendOnEnd(this.Animation,this._onAnimationEnd,this),this.Animation.play(),this._oldContainer=this._container,!d&&this._oldContainer&&this._oldContainer.removeFromParent()):this._container&&(this._container.removeFromParent(),this._container.destroy(),this._container=null),this._container=l,this._dataCursor=ut.renderDataCursor(this),this.UpdateAriaAttributes(),this.__restoreChartFocus(o),this.Animation||this.RenderComplete()},t.Chart.prototype.__cleanUp=function(){this._dataCursor&&(this.removeChild(this._dataCursor),this._dataCursor=null),this.EventManager&&(this.EventManager.hideHoverFeedback(),this.EventManager.setPanZoomHandler(null),this.EventManager.setMarqueeZoomHandler(null),this.EventManager.setMarqueeSelectHandler(null),this.EventManager.panButton=null,this.EventManager.zoomButton=null,this.EventManager.selectButton=null),this.pieCenterDiv&&(this.getCtx().getContainer().removeChild(this.pieCenterDiv),this.pieCenterDiv=null),this.Peers=[],this.xScrollbar=null,this.yScrollbar=null,this.dragButtons&&(this.removeChild(this.dragButtons),this.dragButtons.destroy(),this.dragButtons=null),this._plotArea=null,this._areaContainer=null,this._dataLabels=null,this.getCache().clearCache()},t.Chart.prototype.__cleanUpAxisAndPlotArea=function(){this.EventManager.hideHoverFeedback(),this.Peers=[],this.xAxis&&(this._container.removeChild(this.xAxis),this.xAxis.destroy()),this.yAxis&&(this._container.removeChild(this.yAxis),this.yAxis.destroy()),this.y2Axis&&(this._container.removeChild(this.y2Axis),this.y2Axis.destroy()),this._plotArea&&this._plotArea==this._panZoomTarget?this._plotArea.setVisible(!1):this._plotArea&&(this._container.removeChild(this._plotArea),this._plotArea.destroy()),this._plotArea=null,this.getCache().clearCache()},t.Chart.prototype._onAnimationEnd=function(){this._oldContainer&&(this._oldContainer.removeFromParent(),this._oldContainer.destroy(),this._oldContainer=null),this._delContainer&&(this._delContainer.removeFromParent(),this._delContainer.destroy(),this._delContainer=null),this.AnimationStopped||this.RenderComplete(),this.EventManager.addListeners(this),this.Animation=null,this.AnimationStopped=!1},t.Chart.prototype.CreateKeyboardHandler=function(t){return new r(t,this)},t.Chart.prototype.getAutomation=function(){return new e(this)},t.Chart.prototype.getValuesAt=function(t,e){var i=this.__getPlotAreaSpace(),r=t-i.x,a=e-i.y,n=at.isPolar(this),s=at.isHorizontal(this);if(n){r-=i.w/2,a-=i.h/2;var o=Math.sqrt(r*r+a*a),l=Math.atan2(r,-a);return l<0&&(l+=2*Math.PI),{x:this.xAxis?this.xAxis.getValueAt(l):null,y:this.yAxis?this.yAxis.getValueAt(o):null}}return{x:this.xAxis?this.xAxis.getValueAt(s?a:r):null,y:this.yAxis?this.yAxis.getValueAt(s?r:a):null,y2:this.y2Axis?this.y2Axis.getValueAt(s?r:a):null}},t.Chart.prototype.filter=function(t,e){var i="out"==e?"hidden":"visible";J.setVisibility(this,t,i),this.render(this.Options)},t.Chart.prototype.highlight=function(e){this.getOptions().highlightedCategories=t.JsonUtils.clone(e),t.CategoryRolloverHandler.highlight(e,this.getObjects(),"any"==this.getOptions().highlightMatch),this.legend&&this.legend.highlight(e),this.pieChart&&this.pieChart.highlight(e),this.overview&&this.overview.getBackgroundChart().highlight(e)},t.Chart.prototype.select=function(e){this.getOptions().selection=t.JsonUtils.clone(e);var i=Q.getInitialSelection(this);J.setInitialSelection(this,i),this.pieChart&&this.pieChart.setInitialSelection()},t.Chart.prototype.positionDataCursor=function(e){var i=this.getEventManager().getDataCursorHandler();if(i){if(e){var r=this.xAxis&&null!=e.x?this.xAxis.getCoordAt(e.x):null,a=null;if(at.isBLAC(this)?this.yAxis&&null!=e.y?a=this.yAxis.getBoundedCoordAt(e.y):this.y2Axis&&null!=e.y2&&(a=this.yAxis.getBoundedCoordAt(e.y2)):a=this.yAxis&&null!=e.y?this.yAxis.getCoordAt(e.y):null,null!=r&&null!=a){var n=this.__getPlotAreaSpace(),s=ct.convertAxisCoord(this,new t.Point(r,a),n);return void i.processMove(new t.Point(n.x+s.x,n.y+s.y),!0)}}i.processEnd(!0)}},t.Chart.prototype.processEvent=function(t,e){var i=t.type;if("categoryHide"==i||"categoryShow"==i)this.filter(t.category,"categoryHide"==i?"out":"in");else if("categoryHighlight"==i)this!=e&&this.highlight(t.categories),this.legend&&this.legend!=e&&this.legend.processEvent(t,e);else if("selection"==i)t=this._processSelectionEvent(t);else if("dvtPanZoom"==i)t=this._processPanZoomEvent(t);else if("dvtMarquee"==i)t=this._processMarqueeEvent(t);else if("overview"==i){var r=t.subtype;if("dropCallback"==r)return;var a="scrollTime"==r||"scrollEnd"==r||"rangeChange"==r;t=this._processScrollbarEvent(t.newX1,t.newX2,a,e)}else if("dvtSimpleScrollbar"==i)t=this._processScrollbarEvent(t.newMin,t.newMax,"end"==t.subtype,e);else if("ready"==i&&this!=e)return;if(t){if("selection"==(i=t.type)){var n,s,o=this.getOptions(),l=o.selection,h=Q.getCurrentSelection(this);t.complete&&(o.selection=h),l=l||[],h=h||[];var u={};for(n=0;n<l.length;n++)u[l[n].id]=!0;var g={};for(s=0;s<h.length;s++)g[h[s].id]=!0;var d={};for(s=0;s<h.length;s++){var c=h[s].id;u[c]||(d[c]=!0)}var p={};for(n=0;n<l.length;n++){var _=l[n].id;g[_]||(p[_]=!0)}t.addedSet=d,t.removedSet=p;for(var f=0;f<t.selection.length;f++)J.addEventData(this,t.selection[f]);t.component=this.getOptions()._widgetConstructor}else"drill"==i&&(J.addEventData(this,t),t.component=this.getOptions()._widgetConstructor);this.dispatchEvent(t)}},t.Chart.prototype._processSelectionEvent=function(e){var i=J.processIds(this,e.selection);return this._updateOverviewSelection(),t.EventFactory.newChartSelectionEvent(i,!0)},t.Chart.prototype._processPanZoomEvent=function(e){var i=e.subtype;return"panStart"==i||"pinchStart"==i?(t.Agent.isTouchDevice()&&this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=this._plotArea),null):(this._lastPanZoomEvent?(e.dxMin+=this._lastPanZoomEvent.dxMin,e.dxMax+=this._lastPanZoomEvent.dxMax,e.dyMin+=this._lastPanZoomEvent.dyMin,e.dyMax+=this._lastPanZoomEvent.dyMax):t.Context.requestAnimationFrame(t.Obj.createCallback(this,this._animatePanZoomEvent)),this._lastPanZoomEvent=e,null)},t.Chart.prototype._animatePanZoomEvent=function(){var e=this._lastPanZoomEvent;this._lastPanZoomEvent=null;var i,r,a=e.subtype,n="panEnd"==a||"zoom"==a||"pinchEnd"==a;(J.isLiveScroll(this)?(i=J.getAxisBoundsByDelta(this,e.dxMin,e.dxMax,e.dyMin,e.dyMax),this._setScrollbarViewport(i),this._setViewport(i,n)):(i=J.getAxisBoundsByDelta(this,e.dxMinTotal,e.dxMaxTotal,e.dyMinTotal,e.dyMaxTotal),this._setScrollbarViewport(i),n&&this._setViewport(i,n)),n&&(ut._setEventHandlers(this),this._panZoomTarget!=this._plotArea&&(this._container.removeChild(this._panZoomTarget),this._panZoomTarget=null)),n||!i.unchanged)&&(r=at.isBLAC(this)?t.EventFactory.newChartViewportChangeEvent(n,i.xMin,i.xMax,i.startGroup,i.endGroup,null,null):t.EventFactory.newChartViewportChangeEvent(n,i.xMin,i.xMax,null,null,i.yMin,i.yMax),this.dispatchEvent(r))},t.Chart.prototype._processMarqueeEvent=function(e){var r,a=e.subtype,n=this.EventManager;if(J.adjustBounds(e),n.getDragMode()==i.DRAG_MODE_SELECT){var s=n.getSelectionHandler();if("start"==a)this._initSelection=e.ctrlKey?s.getSelectedIds():[];else{var o=J.getBoundedObjects(this,e);s.processInitialSelections(this._initSelection,this.getChartObjPeers()),s.processGroupSelection(o,!0)}var l=s.getSelectedIds();r=J.getAxisBounds(this,e,!1);var h="end"==a,u=t.EventFactory.newChartSelectionEvent(l,h,r.xMin,r.xMax,r.startGroup,r.endGroup,r.yMin,r.yMax,r.y2Min,r.y2Max);return"end"==a&&this._updateOverviewSelection(),u}return n.getDragMode()==i.DRAG_MODE_ZOOM?"end"!=a?null:(r=J.getAxisBounds(this,e,!0),this._setViewport(r,!0),this._setScrollbarViewport(r),ut._setEventHandlers(this),at.isBLAC(this)?t.EventFactory.newChartViewportChangeEvent(!0,r.xMin,r.xMax,r.startGroup,r.endGroup,null,null):t.EventFactory.newChartViewportChangeEvent(!0,r.xMin,r.xMax,null,null,r.yMin,r.yMax)):null},t.Chart.prototype._processScrollbarEvent=function(e,i,r,a){return this._lastScrollbarEvent||t.Context.requestAnimationFrame(t.Obj.createCallback(this,this._animateScrollbarEvent)),this._lastScrollbarEvent={start:e,end:i,actionDone:r,source:a},null},t.Chart.prototype._animateScrollbarEvent=function(){var e=this._lastScrollbarEvent.start,i=this._lastScrollbarEvent.end,r=this._lastScrollbarEvent.actionDone,a=this._lastScrollbarEvent.source;this._lastScrollbarEvent=null;var n=a==this.yScrollbar?this.yAxis:this.xAxis,s=J.getActualMinMax(n,e,i);if(e=s.min,i=s.max,(J.isLiveScroll(this)||r)&&(a==this.yScrollbar?this._setViewport({yMin:e,yMax:i},r):this._setViewport({xMin:e,xMax:i,unchanged:s.unchanged},r)),r||!s.unchanged){var o;if(a==this.yScrollbar)o=t.EventFactory.newChartViewportChangeEvent(r,null,null,null,null,e,i,null,null);else{var l=J.getAxisStartEndGroup(this.xAxis,e,i);o=t.EventFactory.newChartViewportChangeEvent(r,e,i,l.startGroup,l.endGroup,null,null,null,null)}this.dispatchEvent(o)}},t.Chart.prototype._updateOverviewSelection=function(){if(this.overview){var t=this.overview.getBackgroundChart();t.getOptions().selection=Q.getCurrentSelection(this),t.render()}},t.Chart.prototype.changeOption=function(e,i,r){this.getOptions()[e]=i,this.dispatchEvent(t.EventFactory.newOptionChangeEvent(e,i,r))},t.Chart.prototype.registerObject=function(t){this.Peers.push(t)},t.Chart.prototype.getObjects=function(){return this.Peers},t.Chart.prototype.getChartObjPeers=function(){for(var t=[],e=0;e<this.Peers.length;e++)this.Peers[e]instanceof a&&t.push(this.Peers[e]);return t},t.Chart.prototype.getRefObjPeers=function(){for(var t=[],e=0;e<this.Peers.length;e++)this.Peers[e]instanceof n&&t.push(this.Peers[e]);return t},t.Chart.prototype.getObject=function(t,e){for(var i=0;i<this.Peers.length;i++)if(this.Peers[i]instanceof a&&this.Peers[i].getSeriesIndex()==t&&this.Peers[i].getGroupIndex()==e)return this.Peers[i];return null},t.Chart.prototype.getWidth=function(){return this.Width},t.Chart.prototype.getHeight=function(){return this.Height},t.Chart.prototype.getSeriesStyleArray=function(){return this.SeriesStyleArray},t.Chart.prototype.getPlotArea=function(){return this._plotArea},t.Chart.prototype.setPlotArea=function(t){this._plotArea=t},t.Chart.prototype.getType=function(){return this.getOptions().type},t.Chart.prototype.getSkin=function(){return this.getOptions().skin},t.Chart.prototype.getGapWidthRatio=function(){var t=this.getOptions();return null!==t.layout.gapWidthRatio?t.layout.gapWidthRatio:Math.min(this.Width/400,1)},t.Chart.prototype.getGapHeightRatio=function(){var t=this.getOptions();return null!==t.layout.gapHeightRatio?t.layout.gapHeightRatio:Math.min(this.Height/300,1)},t.Chart.prototype.getSelectionHandler=function(){return this._selectionHandler},t.Chart.prototype.isSelectionSupported=function(){return!!this._selectionHandler},t.Chart.prototype._setViewport=function(t,e){!e&&t.unchanged||(null!=t.xMax&&(this.Options.xAxis.viewportMax=t.xMax),null!=t.xMin&&(this.Options.xAxis.viewportMin=t.xMin),at.isBLAC(this)?(this.Options.xAxis.viewportStartGroup=null,this.Options.xAxis.viewportEndGroup=null,this.Options._initialZoomed=!1):(null!=t.yMax&&(this.Options.yAxis.viewportMax=t.yMax),null!=t.yMin&&(this.Options.yAxis.viewportMin=t.yMin)),this.Options._duringZoomAndScroll=!e,ut.rerenderAxisAndPlotArea(this,this._container))},t.Chart.prototype._setScrollbarViewport=function(t){if(this.xAxis&&null!=t.xMin&&null!=t.xMax){var e=this.xAxis.actualToLinear(t.xMin),i=this.xAxis.actualToLinear(t.xMax);this.overview&&this.overview.setViewportRange(e,i),this.xScrollbar&&this.xScrollbar.setViewportRange(e,i)}if(this.yAxis&&null!=t.yMin&&null!=t.yMax){var r=this.yAxis.actualToLinear(t.yMin),a=this.yAxis.actualToLinear(t.yMax);this.yScrollbar&&this.yScrollbar.setViewportRange(r,a)}},t.Chart.prototype.__setAxisSpace=function(t){var e,i;this._axisSpace=t,q.isAxisRendered(this,"x")?(e=.8*t.w,i=t.h-4*q.getTickLabelHeight(this,"x")):q.isAxisRendered(this,"y")?(e=t.w,i=t.h-q.getTickLabelHeight(this,"y")):(e=t.w,i=t.h),this._radius=Math.min(e,i)/2},t.Chart.prototype.__getAxisSpace=function(){return this._axisSpace},t.Chart.prototype.__setPlotAreaSpace=function(t){this._plotAreaSpace=t},t.Chart.prototype.__getPlotAreaSpace=function(){return this._plotAreaSpace},t.Chart.prototype.__setAreaContainer=function(t){this._areaContainer=t},t.Chart.prototype.__getAreaContainer=function(){return this._areaContainer},t.Chart.prototype.getRadius=function(){return this._radius},t.Chart.prototype.showDragButtons=function(){this.dragButtons&&this.dragButtons.setVisible(!0)},t.Chart.prototype.hideDragButtons=function(){this.dragButtons&&this.dragButtons.setVisible(!1)},t.Chart.prototype.addDataLabel=function(t){this.getDataLabels().push(t)},t.Chart.prototype.getDataLabels=function(){return this._dataLabels||(this._dataLabels=[]),this._dataLabels},t.Chart.prototype.__cacheChartFocus=function(){var t=this.EventManager.getFocus();if(t)var e=t.isShowingKeyboardFocusEffect();if(this.xAxis){var i=this.xAxis.getKeyboardFocus();if(i)var r=i.isShowingKeyboardFocusEffect()}if(this.legend){var a=this.legend.getKeyboardFocus();if(a)var n=a.isShowingKeyboardFocusEffect()}return{chartFocus:t,chartShowingFocusEffect:e,axisFocus:i,axisShowingFocusEffect:r,legendFocus:a,legendShowingFocusEffect:n}},t.Chart.prototype.__restoreChartFocus=function(t){if(!at.isOverview(this)&&!at.isSpark(this)){var e=[this];if(this.xAxis&&this.xAxis.isNavigable()&&e.push(this.xAxis),this.legend&&this.legend.isNavigable()&&e.push(this.legend),this.getCtx().setKeyboardFocusArray(e),t.chartFocus){for(var i=J.getKeyboardNavigables(this),r=!1,a=0;a<i.length;a++){var n=i[a].id;if(n instanceof s&&n.equals(t.chartFocus.getId())){this.EventManager.setFocusObj(i[a]),t.chartShowingFocusEffect&&i[a].showKeyboardFocusEffect(),r=!0;break}}r||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(i))}t.axisFocus&&(this.xAxis.setKeyboardFocus(t.axisFocus,t.axisShowingFocusEffect),t.axisShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.xAxis)),t.legendFocus&&(this.legend.setKeyboardFocus(t.legendFocus,t.legendShowingFocusEffect),t.legendShowingFocusEffect&&this.getCtx().setCurrentKeyboardFocus(this.legend))}},t.Chart.prototype.getRawOptions=function(){return this._rawOptions};var e=function(t){this._chart=t,this._options=this._chart.getOptions(),this._legend=this._chart.legend,this._xAxis=this._chart.xAxis,this._yAxis=this._chart.yAxis,this._y2Axis=this._chart.y2Axis,this._legendAutomation=this._legend?this._legend.getAutomation():null,this._xAxisAutomation=this._xAxis?this._xAxis.getAutomation():null,this._yAxisAutomation=this._yAxis?this._yAxis.getAutomation():null,this._y2AxisAutomation=this._y2Axis?this._y2Axis.getAutomation():null};t.Obj.createSubclass(e,t.Automation),e.PLOT_AREA_SUBID="plotArea",e.PIE_CENTER_LABEL_SUBID="pieCenterLabel",e.prototype.GetSubIdForDomElement=function(i){var r=null;if(i.isDescendantOf(this._xAxis))return(r=this._xAxisAutomation.GetSubIdForDomElement(i))?this._convertAxisSubIdToChartSubId(r,"xAxis"):null;if(i.isDescendantOf(this._yAxis))return(r=this._yAxisAutomation.GetSubIdForDomElement(i))?this._convertAxisSubIdToChartSubId(r,"yAxis"):null;if(i.isDescendantOf(this._y2Axis))return(r=this._y2AxisAutomation.GetSubIdForDomElement(i))?this._convertAxisSubIdToChartSubId(r,"y2Axis"):null;if(i.isDescendantOf(this._legend)){var s=this._legendAutomation.GetSubIdForDomElement(i);return s?this._convertLegendSubIdToChartSubId(s):null}var o=this._chart.getEventManager().GetLogicalObject(i);if(!o)return null;if(o instanceof t.SimpleObjPeer){var l=o.getParams().type;if("pieCenterLabel"==l)return e.PIE_CENTER_LABEL_SUBID;if("plotArea"==l)return e.PLOT_AREA_SUBID}if(o instanceof F)return"dataItem["+o.getSeriesIndex()+"]";if(o instanceof a){var h=o.getSeriesIndex(),u=o.getGroupIndex();if(null!=h&&u>=0&&("funnel"!=this._options.type||"pyramid"!=this._options.type))return"dataItem["+h+"]["+u+"]";if(null!=h&&u==pt._GROUP_INDEX&&("funnel"==this._options.type||"pyramid"==this._options.type))return"dataItem["+h+"]";if(null!=h&&(null==u||u<0))return"series["+h+"]"}else if(o instanceof n){var g=o.getAxisType(),d=o.getIndex();return g&&d>=0?g+":referenceObject["+d+"]":null}return null},e.prototype._convertLegendSubIdToChartSubId=function(t){var e=this._legend.getOptions(),i=this._legendAutomation.getLegendItem(e,t);if(i){for(var r=0;r<this._options.series.length;r++){if(this._options.series[r].name==i.text)return"series["+r+"]"}return"legend:"+t}return null},e.prototype._convertAxisSubIdToChartSubId=function(t,e){if("title"==t&&e)return e+":"+t;var i=t.substring(t.indexOf("["));return i?"group"+i:null},e.prototype.getDomElementForSubId=function(i){if(i==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._chart,rt.isDataCursorEnabled(this._chart)?w.TOOLTIP_ID:null);if(i==e.PIE_CENTER_LABEL_SUBID)return this._chart.pieChart.getCenterLabel().getElem();if(i==e.PLOT_AREA_SUBID)return this._chart.getPlotArea().getElem();var r,a,n,s=i.indexOf("["),o=i.indexOf("]"),l=i.indexOf(":");if(s>0&&o>0||l>0){var h=l<0?i.substring(0,s):i.substring(0,l);if("group"==h)return this._xAxisAutomation.getDomElementForSubId(i);if("series"==h)return i=this._convertToLegendSubId(i),this._legendAutomation.getDomElementForSubId(i);if("legend"==i.substring(0,l))return i=i.substring(l+1),this._legendAutomation.getDomElementForSubId(i);var u,g=i.substring(s+1,o);if("xAxis"==h||"yAxis"==h||"y2Axis"==h){var d=i.substring(l+1);if("title"==d){if("xAxis"==h)return this._xAxisAutomation.getDomElementForSubId(d);if("yAxis"==h)return this._yAxisAutomation.getDomElementForSubId(d);if("y2Axis"==h)return this._y2AxisAutomation.getDomElementForSubId(d)}else if(r=d.indexOf("["),a=d.indexOf("]"),"referenceObject"==d.substring(0,r)){var c=d.substring(r+1,a);if(n=this._getRefObjPeer(c))return n.getDisplayables()[0].getElem()}}if("pie"==this._options.type){var p=this._chart.pieChart.getSliceDisplayable(g);if(p)return p.getElem()}if("funnel"==this._options.type?u=pt._GROUP_INDEX:"pyramid"==this._options.type?u=_t._GROUP_INDEX:(r=(i=i.substring(o+1)).indexOf("["),a=i.indexOf("]"),r>=0&&a>=0&&(u=i.substring(r+1,a))),n=this._getChartObjPeer(g,u))return n.getDisplayables()[0].getElem()}return null},e.prototype._getChartObjPeer=function(t,e){for(var i=this._chart.getChartObjPeers(),r=0;r<i.length;r++){var a=i[r].getSeriesIndex(),n=i[r].getGroupIndex();if(a==t&&n==e)return i[r]}return null},e.prototype._getRefObjPeer=function(t){for(var e=this._chart.getRefObjPeers(),i=0;i<e.length;i++)if(t==e[i].getIndex())return e[i];return null},e.prototype._convertToLegendSubId=function(t){var e=t.indexOf("["),i=t.indexOf("]"),r=t.substring(e+1,i),a=this._legend.getOptions(),n=this._options.series[r];return"section"+this._legendAutomation.getIndicesFromSeries(n,a)},e.prototype.getDataItem=function(t,e){"pie"!=this._options.type&&"funnel"!=this._options.type&&"pyramid"!=this._options.type||(e=0);var i=Q.getDataItem(this._chart,t,e);return i?{borderColor:et.getBorderColor(this._chart,t,e),color:et.getColor(this._chart,t,e),label:Q.getDataLabel(this._chart,t,e),targetValue:Q.getTargetValue(this._chart,t,e),tooltip:rt.getDatatip(this._chart,t,e,null,!1),value:Q.getValue(this._chart,t,e),open:i.open,close:i.close,high:Q.getHighValue(this._chart,t,e),low:Q.getLowValue(this._chart,t,e),volume:i.volume,x:Q.getXValue(this._chart,t,e),y:i.y,z:i.z,min:i.min,max:i.max,group:Q.getGroup(this._chart,e),series:Q.getSeries(this._chart,t),selected:Q.isDataSelected(this._chart,t,e)}:null},e.prototype.getGroup=function(t){return Q.getGroup(this._chart,t)},e.prototype.getSeries=function(t){return this._options.series[t].name},e.prototype.getGroupCount=function(){return Q.getGroupCount(this._chart)},e.prototype.getSeriesCount=function(){return this._options.series.length},e.prototype.getTitle=function(){return this._options.title.text},e.prototype.getLegend=function(){var e=this._legend.__getBounds(),i=this._legend.localToStage(new t.Point(e.x,e.y));return{bounds:{x:i.x,y:i.y,width:e.w,height:e.h},title:this._legend.getOptions().title}},e.prototype.getPlotArea=function(){var t=this._chart.__getPlotAreaSpace();return{bounds:{x:t.x,y:t.y,width:t.w,height:t.h}}},e.prototype.getXAxis=function(){return this._getAxis("x")},e.prototype.getYAxis=function(){return this._getAxis("y")},e.prototype.getY2Axis=function(){return this._getAxis("y2")},e.prototype._getAxis=function(e){var i="x"==e?this._xAxis:"y"==e?this._yAxis:this._y2Axis;if(i){var r=i.__getBounds(),a=i.localToStage(new t.Point(r.x,r.y)),n={x:a.x,y:a.y,width:r.w,height:r.h},s=this._chart;return{bounds:n,title:this._options[e+"Axis"].title,getPreferredSize:function(t,r){var a,n=i.getOptions(),o=n.position,l=q.getTickLabelGapSize(s,e),h=at.isStandaloneXAxis(s)||at.isStandaloneYAxis(s)||at.isStandaloneY2Axis(s)?2:0;return"top"==o||"bottom"==o?(a=i.getPreferredSize(n,t,r-l-h)).h=Math.ceil(a.h+l+h):(a=i.getPreferredSize(n,t-l-h,r)).w=Math.ceil(a.w+l+h),{width:a.w,height:a.h}}}}return null},t.Automation.prototype.IsTooltipElement=function(e){var i=e.getAttribute("id");return!(!i||0!=i.indexOf(w.TOOLTIP_ID)&&0!=i.indexOf(t.HtmlTooltipManager._TOOLTIP_DIV_ID))};var i=function(e){i.superclass.Init.call(this,e.getCtx(),e.processEvent,e,e),this._chart=e,this._dragMode=null,this._dragButtonsVisible=t.Agent.isTouchDevice(),this.panButton=null,this.zoomButton=null,this.selectButton=null,this._dataCursorHandler=null,this._panZoomHandler=null,this._marqueeZoomHandler=null,this._marqueeSelectHandler=null};t.Obj.createSubclass(i,t.EventManager),i.DRAG_MODE_PAN="pan",i.DRAG_MODE_ZOOM="zoom",i.DRAG_MODE_SELECT="select",i.DRAG_MODE_OFF="off",i.prototype.addListeners=function(e){t.SvgDocumentUtils.addDragListeners(this._chart,this._onDragStart,this._onDragMove,this._onDragEnd,this),i.superclass.addListeners.call(this,e),t.Agent.isTouchDevice()||e.addEvtListener(t.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)},i.prototype.RemoveListeners=function(e){i.superclass.RemoveListeners.call(this,e),t.Agent.isTouchDevice()||e.removeEvtListener(t.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this)},i.prototype.getLogicalObject=function(t){return this.GetLogicalObject(t,!0)},i.prototype._getDragHandler=function(t){return t&&"user"==this._chart.getOptions().dragMode&&at.isBLAC(this._chart)&&(this._dragMode==i.DRAG_MODE_PAN||this._dragMode==i.DRAG_MODE_ZOOM)&&(this._panZoomHandler&&this._panZoomHandler.isWithinBounds(t)?this._dragMode=i.DRAG_MODE_PAN:this._dragMode=i.DRAG_MODE_ZOOM),this._dragMode==i.DRAG_MODE_PAN?this._panZoomHandler:this._dragMode==i.DRAG_MODE_ZOOM?this._marqueeZoomHandler:this._dragMode==i.DRAG_MODE_SELECT?this._marqueeSelectHandler:null},i.prototype._onDragStart=function(e){return t.Agent.isTouchDevice()?this._onTouchDragStart(e):this._onMouseDragStart(e)},i.prototype._onDragMove=function(e){return t.Agent.isTouchDevice()?this._onTouchDragMove(e):this._onMouseDragMove(e)},i.prototype._onDragEnd=function(e){return t.Agent.isTouchDevice()?this._onTouchDragEnd(e):this._onMouseDragEnd(e)},i.prototype._onMouseDragStart=function(t){var e,i=this._context.pageToStageCoords(t.pageX,t.pageY),r=this._getDragHandler(i),a=this.GetLogicalObject(t.target);return!(a&&a.isSelectable&&a.isSelectable())&&0==t.button&&r&&((e=r.processDragStart(i,t.ctrlKey))&&this._callback.call(this._callbackObj,e),this._chart.setCursor(r.getCursor(i)),this.setDragButtonsVisible(!1),this._chart!=this.getCtx().getCurrentKeyboardFocus()&&this.getCtx().setCurrentKeyboardFocus(this._chart)),!!e&&(this._dataCursorHandler&&this._dataCursorHandler.processEnd(),!0)},i.prototype._onMouseDragMove=function(t){var e,i=this._context.pageToStageCoords(t.pageX,t.pageY),r=this._getDragHandler();r&&(e=r.processDragMove(i,t.ctrlKey))&&(this._callback.call(this._callbackObj,e),this.setDragButtonsVisible(!1)),e&&t.stopPropagation()},i.prototype._onMouseDragEnd=function(t){var e,i=this._context.pageToStageCoords(t.pageX,t.pageY),r=this._getDragHandler();if(r){(e=r.processDragEnd(i,t.ctrlKey))&&(this._callback.call(this._callbackObj,e),this.autoToggleZoomButton()),this._chart.setCursor(r.getCursor(i));var a=this._chart.__getAxisSpace();a&&this.setDragButtonsVisible(a.containsPoint(i.x,i.y))}},i.prototype.OnMouseMove=function(e){i.superclass.OnMouseMove.call(this,e);var r=this._context.pageToStageCoords(e.pageX,e.pageY);this._dataCursorHandler&&(this.GetLogicalObjectAndDisplayable(e.target).displayable instanceof t.Button?this._dataCursorHandler.processEnd():this._dataCursorHandler.processMove(r));var a=this._getDragHandler(r);a?this._chart.setCursor(a.getCursor(r)):this._chart.setCursor("default")},i.prototype.OnMouseOut=function(t){i.superclass.OnMouseOut.call(this,t);var e=this._context.pageToStageCoords(t.pageX,t.pageY),r=this._chart.__getAxisSpace();r&&this.setDragButtonsVisible(r.containsPoint(e.x,e.y)),this._dataCursorHandler&&this._dataCursorHandler.processOut(e);this.GetLogicalObject(t.target)},i.prototype.OnMouseWheel=function(t){if(J.isZoomable(this._chart)){var e=null!=t.wheelDelta?t.wheelDelta:0,i=this._context.pageToStageCoords(t.pageX,t.pageY);if(this._panZoomHandler){var r=this._panZoomHandler.processMouseWheel(i,e);r&&(t.preventDefault(),t.stopPropagation(),this._callback.call(this._callbackObj,r),this._dataCursorHandler&&this._dataCursorHandler.processMove(i))}}},i.prototype.ShowFocusEffect=function(e,r){if(this._dataCursorHandler){var a=r.getDataPosition();if(a){var n=this._chart.__getPlotAreaSpace();this._dataCursorHandler.processMove(new t.Point(a.x+n.x,a.y+n.y))}}i.superclass.ShowFocusEffect.call(this,e,r)},i.prototype.OnBlur=function(t){this._dataCursorHandler&&this._dataCursorHandler.processEnd(),i.superclass.OnBlur.call(this,t)},i.prototype.OnClickInternal=function(t){var e=this.GetLogicalObject(t.target),i=this._context.pageToStageCoords(t.pageX,t.pageY);this.SeriesFocusHandler&&this.SeriesFocusHandler.processSeriesFocus(i,e),e&&(e.isSelectable&&e.isSelectable()||this.processDrillEvent(e))},i.prototype.OnDblClickInternal=function(t){var e=this.GetLogicalObject(t.target);e&&e.isSelectable&&e.isSelectable()&&this.processDrillEvent(e)},i.prototype.HandleTouchHoverStartInternal=function(t){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var e=this._context.pageToStageCoords(t.touch.pageX,t.touch.pageY);return this._dataCursorHandler.processMove(e),!1}var i=this.GetLogicalObject(t.target);return this.TouchManager.setTooltipEnabled(t.touch.identifier,this.getTooltipsEnabled(i)),!1},i.prototype.HandleTouchHoverMoveInternal=function(t){if(this._dataCursorHandler&&!this.isTouchResponseTouchStart()){var e=this._context.pageToStageCoords(t.touch.pageX,t.touch.pageY);return this._dataCursorHandler.processMove(e),!1}var i=this.GetLogicalObject(t.target);return this.TouchManager.setTooltipEnabled(t.touch.identifier,this.getTooltipsEnabled(i)),!1},i.prototype.HandleTouchHoverEndInternal=function(t){this.endDrag();var e=this.GetLogicalObject(t.target);e&&(e.isSelectable&&e.isSelectable()||this.processDrillEvent(e))},i.prototype.HandleTouchClickInternal=function(t){var e=this.GetLogicalObject(t.target);e&&(e.isSelectable&&e.isSelectable()||this.processDrillEvent(e))},i.prototype.HandleTouchDblClickInternal=function(t){var e=this.GetLogicalObject(t.target);e&&e.isSelectable&&e.isSelectable()&&(t.preventDefault(),t.stopPropagation(),this.processDrillEvent(e))},i.prototype.processDrillEvent=function(e){if(e&&e.isDrillable&&e.isDrillable()){var i=e.getId();e instanceof a?this.FireEvent(t.EventFactory.newChartDrillEvent(null!=i.id?i.id:i,e.getSeries(),e.getGroup())):e instanceof F&&this.FireEvent(t.EventFactory.newChartDrillEvent(i.id,i.series,i.group))}},i.prototype.ProcessRolloverEvent=function(e,i,r){var a=this._chart.getOptions();if("dim"==J.getHoverBehavior(this._chart)){var n=i.getCategories?i.getCategories():[];a.highlightedCategories=r?n.slice():null;var s=t.EventFactory.newCategoryHighlightEvent(a.highlightedCategories,r),o=et.getHoverBehaviorDelay(this._chart),l=this._chart.getObjects();this._chart.pieChart&&(l=l.concat(this._chart.pieChart.__getSlices())),this.RolloverHandler.processEvent(s,l,o,"any"==a.highlightMatch)}},i.prototype._onTouchDragStart=function(t){var e,i,r=t.touches;if(1==r.length){var a=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),n=this._getDragHandler();n?e=n.processDragStart(a,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(a),i=!0)}else if(2==r.length&&this._panZoomHandler&&J.isZoomable(this._chart)){this.endDrag();var s=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),o=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);e=this._panZoomHandler.processPinchStart(s,o)}return e&&(this._callback.call(this._callbackObj,e),this.getCtx().getTooltipManager().hideTooltip()),!(!e&&!i)&&(t.preventDefault(),t.stopPropagation(),this.setDragButtonsVisible(!1),!0)},i.prototype._onTouchDragMove=function(t){var e,i,r=t.touches;if(1==r.length){var a=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),n=this._getDragHandler();n?e=n.processDragMove(a,!0):this._dataCursorHandler&&this.isTouchResponseTouchStart()&&(this._dataCursorHandler.processMove(a),i=!0)}else if(2==r.length&&this._panZoomHandler&&J.isZoomable(this._chart)){var s=this._context.pageToStageCoords(r[0].pageX,r[0].pageY),o=this._context.pageToStageCoords(r[1].pageX,r[1].pageY);e=this._panZoomHandler.processPinchMove(s,o)}(e||i)&&t.preventDefault(),e&&(this._callback.call(this._callbackObj,e),this.getCtx().getTooltipManager().hideTooltip())},i.prototype._onTouchDragEnd=function(t){var e,i=this.endDrag();if(this._panZoomHandler&&J.isZoomable(this._chart)&&(e=this._panZoomHandler.processPinchEnd())&&this._callback.call(this._callbackObj,e),i||e){t.preventDefault(),this.getCtx().getTooltipManager().hideTooltip();var r=this.getTouchManager(),a=1==t.changedTouches.length?t.changedTouches[0].identifier:null,n=null!=a?r.getTouchInfo(a):null;n&&!n.touchMoved||r.reset()}this.setDragButtonsVisible(!0)},i.prototype.endDrag=function(){var t,e=this._getDragHandler();return e&&(t=e.processDragEnd(null,!0)),this._dataCursorHandler&&this._dataCursorHandler.processEnd(),t&&this._callback.call(this._callbackObj,t),t},i.prototype.zoomBy=function(t){if(this._panZoomHandler&&J.isZoomable(this._chart)){var e=this._panZoomHandler.zoomBy(t);e&&this._callback.call(this._callbackObj,e)}},i.prototype.panBy=function(t,e){if(this._panZoomHandler&&J.isScrollable(this._chart)){var i=this._panZoomHandler.panBy(t,e);i&&this._callback.call(this._callbackObj,i)}},i.prototype.hideHoverFeedback=function(){this.hideTooltip(),this._dataCursorHandler&&this._dataCursorHandler.processEnd()},i.prototype.hideTooltip=function(){this._dataCursorHandler&&this._dataCursorHandler.isDataCursorShown()||i.superclass.hideTooltip.call(this)},i.prototype.getTooltipsEnabled=function(t){return(!this._dataCursorHandler||!(t instanceof a||t instanceof n||this._dataCursorHandler.isDataCursorShown()))&&i.superclass.getTooltipsEnabled.call(this)},i.prototype.getDataCursorHandler=function(){return this._dataCursorHandler},i.prototype.setDataCursorHandler=function(t){this._dataCursorHandler=t},i.prototype.setPanZoomHandler=function(t){this._panZoomHandler=t},i.prototype.setMarqueeZoomHandler=function(t){this._marqueeZoomHandler=t},i.prototype.setMarqueeSelectHandler=function(t){this._marqueeSelectHandler=t},i.prototype.getMarqueeGlassPane=function(){return this._dragMode==i.DRAG_MODE_ZOOM?this._marqueeZoomHandler.getGlassPane():this._dragMode==i.DRAG_MODE_SELECT?this._marqueeSelectHandler.getGlassPane():null},i.prototype.cancelMarquee=function(t){this._dragMode==i.DRAG_MODE_ZOOM?this._marqueeZoomHandler.cancelMarquee()&&t.preventDefault():this._dragMode==i.DRAG_MODE_SELECT&&this._marqueeSelectHandler&&this._marqueeSelectHandler.cancelMarquee()&&this._chart.render()},i.prototype.getDragMode=function(){return this._dragMode},i.prototype.setDragMode=function(t){this._dragMode=null==t?this._getDefaultDragMode():t,!this._chart.xAxis.isFullViewport()||this._chart.yAxis&&!this._chart.yAxis.isFullViewport()||this.autoToggleZoomButton()},i.prototype._getDefaultDragMode=function(){return t.Agent.isTouchDevice()?i.DRAG_MODE_OFF:J.isScrollable(this._chart)?i.DRAG_MODE_PAN:"multiple"==this._chart.getOptions().selectionMode?i.DRAG_MODE_SELECT:null},i.prototype.onZoomButtonClick=function(t){this.zoomButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(i.DRAG_MODE_ZOOM)):this.setDragMode(null)},i.prototype.onPanButtonClick=function(t){this.panButton.isToggled()?(this.selectButton&&this.selectButton.setToggled(!1),this.setDragMode(i.DRAG_MODE_PAN)):this.setDragMode(null)},i.prototype.onSelectButtonClick=function(t){this.selectButton.isToggled()?(this.zoomButton&&this.zoomButton.setToggled(!1),this.panButton&&this.panButton.setToggled(!1),this.setDragMode(i.DRAG_MODE_SELECT)):this.setDragMode(null)},i.prototype.setDragButtonsVisible=function(t){t&&!this._dragButtonsVisible?(this._chart.showDragButtons(),this._dragButtonsVisible=!0):!t&&this._dragButtonsVisible&&(this._chart.hideDragButtons(),this._dragButtonsVisible=!1)},i.prototype.areDragButtonsVisible=function(){return this._dragButtonsVisible},i.prototype.autoToggleZoomButton=function(){!t.Agent.isTouchDevice()&&this.zoomButton&&(this._chart.xAxis.isFullViewport()&&this._chart.yAxis.isFullViewport()?this._dragMode==i.DRAG_MODE_PAN&&(this.zoomButton.setToggled(!0),this.onZoomButtonClick(null)):this._dragMode==i.DRAG_MODE_ZOOM&&(this.zoomButton.setToggled(!1),this.onZoomButtonClick(null)))},i.prototype.GetTouchResponse=function(){return this._dragMode&&this._dragMode!=i.DRAG_MODE_OFF?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:this._chart.getOptions().touchResponse},i.prototype.isDndSupported=function(){return!0},i.prototype.GetDragSourceType=function(t){var e=this.DragSource.getDragObject();return e instanceof a&&e.getSeriesIndex()>=0&&e.getGroupIndex()>=0||e instanceof F?"items":null},i.prototype.GetDragDataContexts=function(e){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],n=0;n<i.length;n++){var s=Q.getDataContext(this._chart,i[n].getSeriesIndex(),i[n].getGroupIndex(),i[n].getNestedDataItemIndex());e&&t.ToolkitUtils.cleanDragDataContext(s),r.push(s)}return r}var o=this.DragSource.getDragObject(),l=null;return o instanceof a&&(l=Q.getDataContext(this._chart,o.getSeriesIndex(),o.getGroupIndex(),o.getNestedDataItemIndex())),o instanceof F&&(l=Q.getDataContext(this._chart,o.getSeriesIndex(),0)),l&&e&&t.ToolkitUtils.cleanDragDataContext(l),l?[l]:null},i.prototype.GetDropOffset=function(e){var i=this.DragSource.getDragObject();if(i instanceof a){var r=i.getDataPosition();if(r){r=this._chart.getPlotArea().localToStage(r);var n=this._context.pageToStageCoords(e.pageX,e.pageY);return new t.Point(r.x-n.x,r.y-n.y)}}return null},i.prototype.GetDropTargetType=function(t){var e=this._context.pageToStageCoords(t.pageX,t.pageY),i=this._chart.getOptions().dnd.drop,r=this._chart.__getPlotAreaSpace();return Object.keys(i.plotArea).length>0&&r.containsPoint(e.x,e.y)?"plotArea":Object.keys(i.xAxis).length>0&&q.isAxisRendered(this._chart,"x")&&q.axisContainsPoint(this._chart.xAxis,e)?"xAxis":Object.keys(i.yAxis).length>0&&q.isAxisRendered(this._chart,"y")&&q.axisContainsPoint(this._chart.yAxis,e)?"yAxis":Object.keys(i.y2Axis).length>0&&q.isAxisRendered(this._chart,"y2")&&q.axisContainsPoint(this._chart.y2Axis,e)?"y2Axis":null},i.prototype.GetDropEventPayload=function(e){var i=e.getNativeEvent().dataTransfer,r=Number(i.getData(t.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,a=Number(i.getData(t.EventManager.DROP_OFFSET_Y_DATA_TYPE))||0,n=this._context.pageToStageCoords(e.pageX,e.pageY);return this._chart.getValuesAt(n.x+r,n.y+a)},i.prototype.ShowDropEffect=function(t){var e=this._getDropObject(t);e&&(e.setClassName("oj-active-drop"),e.setSolidFill(this._chart.getOptions()._dropColor))},i.prototype.ClearDropEffect=function(){var e=this._chart.getCache().getFromCache("plotAreaBackground");if(e){var i=et.getBackgroundColor(this._chart);i?e.setSolidFill(i):e.setInvisibleFill(),t.ToolkitUtils.removeClassName(e.getElem(),"oj-invalid-drop"),t.ToolkitUtils.removeClassName(e.getElem(),"oj-active-drop")}var r=function(e){if(e){var i=e.getCache().getFromCache("background");i&&(i.setInvisibleFill(),t.ToolkitUtils.removeClassName(i.getElem(),"oj-invalid-drop"),t.ToolkitUtils.removeClassName(i.getElem(),"oj-active-drop"))}};r(this._chart.xAxis),r(this._chart.yAxis),r(this._chart.y2Axis)},i.prototype.ShowRejectedDropEffect=function(t){var e=this._getDropObject(t);e&&e.setClassName("oj-invalid-drop")},i.prototype._getDropObject=function(t){var e,i=this.GetDropTargetType(t);return"plotArea"==i?e=this._chart.getCache().getFromCache("plotAreaBackground"):"xAxis"==i?e=this._chart.xAxis.getCache().getFromCache("background"):"yAxis"==i?e=this._chart.yAxis.getCache().getFromCache("background"):"y2Axis"==i&&(e=this._chart.y2Axis.getCache().getFromCache("background")),e},i.prototype.isClearMenuAllowed=function(t){return t&&t.getParams&&"plotArea"==t.getParams().type};var r=function(t,e){this.Init(t,e)};t.Obj.createSubclass(r,t.KeyboardHandler),r.prototype.Init=function(t,e){r.superclass.Init.call(this,t),this._chart=e},r.prototype.isSelectionEvent=function(t){return this.isNavigationEvent(t)&&!t.ctrlKey},r.prototype.isMultiSelectEvent=function(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey},r.prototype.processKeyDown=function(e){var i=e.keyCode;if(i==t.KeyboardEvent.TAB){if(n=this._eventManager.getFocus())return t.EventManager.consumeEvent(e),n;var a=J.getKeyboardNavigables(this._chart);if(a.length>0)return t.EventManager.consumeEvent(e),this.getDefaultNavigable(a)}else if(i==t.KeyboardEvent.ENTER){var n;if(n=this._eventManager.getFocus())return this._eventManager.processDrillEvent(n),t.EventManager.consumeEvent(e),n}else i==t.KeyboardEvent.ESCAPE?this._eventManager.cancelMarquee(e):i==t.KeyboardEvent.PAGE_UP?((e.ctrlKey||e.shiftKey||at.isBLAC(this._chart))&&at.isVertical(this._chart)?this._eventManager.panBy(-.25,0):this._eventManager.panBy(0,-.25),t.EventManager.consumeEvent(e)):i==t.KeyboardEvent.PAGE_DOWN?((e.ctrlKey||e.shiftKey||at.isBLAC(this._chart))&&at.isVertical(this._chart)?this._eventManager.panBy(.25,0):this._eventManager.panBy(0,.25),t.EventManager.consumeEvent(e)):t.KeyboardEvent.isEquals(e)||t.KeyboardEvent.isPlus(e)?this._eventManager.zoomBy(1.5):(t.KeyboardEvent.isMinus(e)||t.KeyboardEvent.isUnderscore(e))&&this._eventManager.zoomBy(1/1.5);return r.superclass.processKeyDown.call(this,e)},r.prototype.getDefaultNavigable=function(t){if(!t||t.length<=0)return null;for(var e,i,r,a,n=at.isPie(this._chart),s=0;s<t.length;s++)a=t[s],!e||a.getSeriesIndex()<i?(e=a,i=a.getSeriesIndex(),n||(r=a.getGroupIndex())):!n&&a.getGroupIndex()<r&&(e=a,i=a.getSeriesIndex(),r=a.getGroupIndex());return e};var a=function(t,e,i,r,a,n){this.Init(t,e,i,r,a,n)};t.Obj.createSubclass(a,t.Obj),a.prototype.Init=function(e,i,r,a,n,s){if(this._chart=e,this._displayables=i,this._seriesIndex=null!=r&&r>=0?r:-1,this._groupIndex=null!=a&&a>=0?a:-1,this._itemIndex=null!=n&&n>=0?n:-1,this._dataPos=s,this._isSelected=!1,this._isShowingKeyboardFocusEffect=!1,this._series=Q.getSeries(e,r),this._group=Q.getGroup(e,a),this._categories=Q.getCategories(e,r,a,n),-1!=this._itemIndex)this._dataItemId=Q.getNestedDataItemId(e,r,a,n),this._drillable=J.isDataItemDrillable(e,r,a,n);else if(-1!=this._groupIndex){Q.getDataItem(e,r,a)&&(this._dataItemId=Q.getDataItemId(e,r,a),this._drillable=J.isDataItemDrillable(e,r,a))}else{Q.getSeriesItem(e,r)&&(this._drillable=J.isSeriesDrillable(e,r))}if(this._drillable)for(var o=0;o<this._displayables.length;o++)this._displayables[o].setCursor(t.SelectionEffectUtils.getSelectingCursor());for(var l=0;l<i.length;l++){var h=i[l];h instanceof O||h.setAriaRole("img"),this._updateAriaLabel(h)}},a.associate=function(t,e,i,r,n,s){if(t&&!e.getOptions()._duringZoomAndScroll){var o=new a(e,[t],i,r,n,s);e.registerObject(o),e.getEventManager().associate(t,o)}},a.prototype.getId=function(){return this._seriesIndex>=0&&this._groupIndex>=0?new s(this._dataItemId,this.getSeries(),this.getGroup(),this._chart.getCtx()):this._seriesIndex>=0?this.getSeries():null},a.prototype.getDataItemId=function(){return this._dataItemId},a.prototype.getNestedDataItemIndex=function(){return this._itemIndex},a.prototype.getSeries=function(){return this._series},a.prototype.getSeriesIndex=function(){return this._seriesIndex},a.prototype.getGroup=function(){return this._group},a.prototype.getGroupIndex=function(){return this._groupIndex},a.prototype.isDrillable=function(){return this._drillable},a.prototype.isDoubleClickable=function(){return this.isSelectable()&&this.isDrillable()},a.prototype.getChart=function(){return this._chart},a.prototype.getDatatip=function(t){return rt.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!0)},a.prototype.getDatatipColor=function(){return rt.getDatatipColor(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex)},a.prototype.isSelectable=function(){return et.isSelectable(this.getChart(),this.getSeriesIndex(),this.getGroupIndex())},a.prototype.isSelected=function(){return this._isSelected},a.prototype.setSelected=function(t){this._isSelected=t;for(var e=0;e<this._displayables.length;e++)this._displayables[e].setSelected&&(this._displayables[e].setSelected(t),this._updateAriaLabel(this._displayables[e]))},a.prototype.showHoverEffect=function(){for(var t=0;t<this._displayables.length;t++)this._displayables[t].showHoverEffect&&this._displayables[t].showHoverEffect()},a.prototype.hideHoverEffect=function(){for(var t=0;t<this._displayables.length;t++)this._displayables[t].hideHoverEffect&&this._displayables[t].hideHoverEffect()},a.prototype.getDisplayables=function(){return this._displayables},a.prototype.getAriaLabel=function(){var e=[],i=this.getChart().getOptions().translations;this.isSelectable()&&e.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),this.isDrillable()&&e.push(i.stateDrillable);var r=rt.getDatatip(this._chart,this._seriesIndex,this._groupIndex,this._itemIndex,!1);return null==r&&this._groupIndex<0&&e.length>0&&(r=Q.getSeriesLabel(this._chart,this._seriesIndex)),t.Displayable.generateAriaLabel(r,e)},a.prototype._updateAriaLabel=function(e){t.Agent.deferAriaCreation()||e.setAriaProperty("label",this.getAriaLabel())},a.prototype.getCategories=function(t){return this._categories},a.prototype.getDataPosition=function(){return this._dataPos},a.prototype.getNextNavigable=function(e){var i,r;if(i=e.keyCode,e.type==t.MouseEvent.CLICK)return this;if(i==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;for(var a=this._chart,n=a.getChartObjPeers(),s=[],o=0;o<n.length;o++)n[o].isNavigable()&&s.push(n[o]);var l=e.keyCode==t.KeyboardEvent.UP_ARROW||e.keyCode==t.KeyboardEvent.DOWN_ARROW,h=at.isHorizontal(a),u=t.Agent.isRightToLeft(a.getCtx());return at.isScatterBubble(a)||at.isBoxPlot(a)&&(l&&!h||!l&&h)?r=t.KeyboardHandler.getNextAdjacentNavigable(this,e,s):at.isLineArea(a)||at.isStacked(a)||at.isPolar(a)?r=this._findNextNavigable(e):at.isFunnel(a)&&l?(e.keyCode=u?e.keyCode==t.KeyboardEvent.UP_ARROW?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW:e.keyCode-1,r=t.KeyboardHandler.getNextNavigable(this,e,s)):at.isPyramid(a)&&!l?(e.keyCode=u?e.keyCode==t.KeyboardEvent.RIGHT_ARROW?t.KeyboardEvent.DOWN_ARROW:t.KeyboardEvent.UP_ARROW:e.keyCode==t.KeyboardEvent.RIGHT_ARROW?t.KeyboardEvent.UP_ARROW:t.KeyboardEvent.DOWN_ARROW,r=t.KeyboardHandler.getNextNavigable(this,e,s)):r=t.KeyboardHandler.getNextNavigable(this,e,s,!0),r},a.prototype.getKeyboardBoundingBox=function(e){return this._displayables[0]?this._displayables[0].getDimensions(e):new t.Rectangle(0,0,0,0)},a.prototype.getTargetElem=function(){return this._displayables[0]?this._displayables[0].getElem():null},a.prototype.showKeyboardFocusEffect=function(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect())},a.prototype.hideKeyboardFocusEffect=function(){this.isNavigable()&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect())},a.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},a.prototype.isNavigable=function(){return-1!=this.getGroupIndex()&&-1!=this.getSeriesIndex()},a.prototype._findNextNavigable=function(e){var i,r,a=e.keyCode,n=this._chart,s=n.getCtx(),o=this.getSeriesIndex(),l=this.getGroupIndex(),h=Q.getGroupCount(n),u=at.isHorizontal(n),g=at.isPolar(n),d=t.Agent.isRightToLeft(s),c=u?d?a==t.KeyboardEvent.LEFT_ARROW:a==t.KeyboardEvent.RIGHT_ARROW:a==t.KeyboardEvent.UP_ARROW,p=u?d?a==t.KeyboardEvent.RIGHT_ARROW:a==t.KeyboardEvent.LEFT_ARROW:a==t.KeyboardEvent.DOWN_ARROW,_=u?a==t.KeyboardEvent.UP_ARROW:d?a==t.KeyboardEvent.RIGHT_ARROW:a==t.KeyboardEvent.LEFT_ARROW,f=u?a==t.KeyboardEvent.DOWN_ARROW:d?a==t.KeyboardEvent.LEFT_ARROW:a==t.KeyboardEvent.RIGHT_ARROW;if(c)r=l,i=this._findNextUpSeries(n,o,l);else if(p)r=l,i=this._findNextDownSeries(n,o,l);else if(f){i=o,r=l;do{r++,g&&r>=h&&(r=0)}while(null==n.getObject(i,r)&&r<h)}else if(_){i=o,r=l;do{r--,g&&r<0&&(r=h-1)}while(null==n.getObject(i,r)&&r>-1)}var v=n.getObject(i,r);return v&&v.isNavigable()?v:this},a.prototype._findNextUpSeries=function(t,e,i){for(var r=Q.getSeriesCount(t),a=Q.getCumulativeValue(t,e,i),n=null,s=null,o=0;o<r;o++)if(et.isSeriesRendered(t,o)&&null!=Q.getValue(t,o,i)){var l=Q.getCumulativeValue(t,o,i);(l>a||l==a&&o>e)&&(null!==n&&l<n||null==n)&&(n=l,s=o)}return s},a.prototype._findNextDownSeries=function(t,e,i){for(var r=Q.getSeriesCount(t),a=Q.getCumulativeValue(t,e,i),n=null,s=null,o=r-1;o>=0;o--)if(et.isSeriesRendered(t,o)&&null!=Q.getValue(t,o,i)){var l=Q.getCumulativeValue(t,o,i);(l<a||l==a&&o<e)&&(null!==n&&l>n||null==n)&&(n=l,s=o)}return s},a.prototype.isDragAvailable=function(t){return!0},a.prototype.getDragTransferable=function(t,e){return[this.getId()]},a.prototype.getDragFeedback=function(t,e){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],a=0;a<i.length;a++)r=r.concat(i[a].getDisplayables());return r}return this._displayables};var n=function(t,e,i,r,a){this.Init(t,e,i,r,a)};t.Obj.createSubclass(n,t.Obj),n.prototype.Init=function(t,e,i,r,a){this._chart=t,this._displayables=e,this._refObj=i,this._categories=$.getRefObjCategories(this._refObj),this._index=r,this._axisType=a;for(var n=0;n<e.length;n++){var s=e[n];s.setAriaRole("img"),s.setAriaProperty("label",i.shortDesc)}},n.prototype.getCategories=function(){return this._categories},n.prototype.getDisplayables=function(){return this._displayables},n.prototype.getIndex=function(){return this._index},n.prototype.getAxisType=function(){return this._axisType},n.prototype.getDatatip=function(t){return rt.getRefObjTooltip(this._chart,this._refObj,this._axisType,this._index)},n.prototype.getDatatipColor=function(){return $.getColor(this._refObj)};var s=function(t,e,i,r){this.id=t,this.series=e,this.group=i,this.context=r};t.Obj.createSubclass(s,t.Obj),s.prototype.equals=function(t){return t instanceof s&&(null!=this.id||null!=t.id?Q.isEqualId(this.id,t.id,this.context):Q.isEqualId(this.series,t.series,this.context)&&Q.isEqualId(this.group,t.group,this.context))},s.prototype.toString=function(){return null!=this.id&&"object"!=typeof this.id?this.id.toString():Q.createDataItemId(this.series,this.group)},s.prototype.valueOf=function(){return this.toString()};var o=function(t){this.Init({alta:o.SKIN_ALTA},t)};t.Obj.createSubclass(o,t.BaseComponentDefaults),o.SKIN_ALTA={skin:t.CSSStyle.SKIN_ALTA,emptyText:null,type:"bar",stack:"off",stackLabel:"off",orientation:"vertical",polarGridShape:"circle",selectionMode:"none",hideAndShowBehavior:"none",hoverBehavior:"none",zoomAndScroll:"off",zoomDirection:"auto",initialZooming:"none",dragMode:"user",sorting:"off",otherThreshold:0,animationOnDataChange:"none",animationOnDisplay:"none",__sparkBarSpacing:"subpixel",__spark:!1,dataCursor:"auto",dataCursorBehavior:"auto",drilling:"off",highlightMatch:"all",series:[],groups:[],title:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_13+"color: #252525;"),halign:"start"},subtitle:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #252525;")},footnote:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),halign:"start"},titleSeparator:{upperColor:"#74779A",lowerColor:"#FFFFFF",rendered:"off"},touchResponse:"auto",_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_13+"color: #252525;"),_dropColor:"#D9F4FA",xAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"on"},scale:"linear"},yAxis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear"},y2Axis:{tickLabel:{rendered:"on"},majorTick:{rendered:"auto"},minorTick:{rendered:"auto"},axisLine:{rendered:"auto"},scale:"linear",alignTickMarks:"on"},zAxis:{},pieCenter:{labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA)},plotArea:{backgroundColor:null},legend:{position:"auto",rendered:"auto",layout:{gapRatio:1},seriesSection:{},referenceObjectSection:{},sections:[]},overview:{rendered:"off"},dnd:{drag:{items:{},series:{},groups:{}},drop:{plotArea:{},xAxis:{},yAxis:{},y2Axis:{},legend:{}}},styleDefaults:{colors:t.CSSStyle.COLORS_ALTA,borderColor:"auto",borderWidth:"auto",patterns:["smallDiagonalRight","smallChecker","smallDiagonalLeft","smallTriangle","smallCrosshatch","smallDiamond","largeDiagonalRight","largeChecker","largeDiagonalLeft","largeTriangle","largeCrosshatch","largeDiamond"],shapes:["square","circle","diamond","plus","triangleDown","triangleUp"],seriesEffect:"color",threeDEffect:"off",selectionEffect:"highlight",animationDuration:1e3,animationIndicators:"all",animationUpColor:"#0099FF",animationDownColor:"#FF3300",lineStyle:"solid",lineType:"auto",markerDisplayed:"auto",markerColor:null,markerShape:"auto",markerSize:10,marqueeColor:"rgba(255,255,255,0.4)",marqueeBorderColor:"#0572ce",pieFeelerColor:"#BAC5D6",pieInnerRadius:0,selectedInnerColor:"#ffffff",selectedOuterColor:"#5a5a5a",sliceLabelType:"percent",otherColor:"#4b4b4b",stockRisingColor:"#6b6f74",stockFallingColor:"#ED6647",stockRangeColor:"#B8B8B8",dataItemGaps:"auto",dataLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11),dataLabelPosition:"auto",funnelBackgroundColor:"#EDEDED",x1Format:{},y1Format:{},y2Format:{},zFormat:{},_defaultSliceLabelColor:"#333333",_scrollbarHeight:3,_scrollbarTrackColor:"#F0F0F0",_scrollbarHandleColor:"#9E9E9E",hoverBehaviorDelay:200,dataCursor:{markerSize:8,markerDisplayed:"on",lineColor:"#5a5a5a",lineWidth:2,lineStyle:"solid"},groupSeparators:{rendered:"on",color:"rgba(138,141,172,0.4)"},padding:"auto",_tooltipStyle:new t.CSSStyle("border-collapse: separate; border-spacing: 2px; overflow: hidden; display: block;"),tooltipLabelStyle:new t.CSSStyle("color: #666666; padding: 0px 2px; white-space: nowrap;"),tooltipValueStyle:new t.CSSStyle("color: #333333; padding: 0px 2px;"),stackLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_11),boxPlot:{whiskerSvgStyle:{},whiskerEndSvgStyle:{strokeWidth:2},whiskerEndLength:9,medianSvgStyle:{strokeWidth:3}}},layout:{gapWidthRatio:null,gapHeightRatio:null,outerGapWidth:10,outerGapHeight:8,titleSubtitleGapWidth:14,titleSubtitleGapHeight:4,titleSeparatorGap:6,titlePlotAreaGap:16,footnoteGap:10,verticalAxisGap:6,legendGapWidth:15,legendGapHeight:10,tickLabelGapHeight:8,tickLabelGapWidth:9},_locale:"en-us",_resources:{}},o.getGapWidth=function(t,e){return Math.ceil(e*t.getGapWidthRatio())},o.getGapHeight=function(t,e){return Math.ceil(e*t.getGapHeightRatio())},o.prototype.getNoCloneObject=function(t){return{}};var l=function(t,e){this.Init(t,e)};t.Obj.createSubclass(l,t.Obj),l.prototype.Init=function(t,e){this._context=t.getCtx(),this._dataCursorShown=!1,this._dataCursor=e,this._chart=t},l.prototype.processMove=function(t,e){var i=this._chart.__getPlotAreaSpace();return i&&i.containsPoint(t.x,t.y)&&!this._chart.getOptions()._duringZoomAndScroll?(this._showDataCursor(i,t.x,t.y,e),!0):(this._removeDataCursor(e),!1)},l.prototype.processEnd=function(t){this._removeDataCursor(t)},l.prototype.processOut=function(t,e){var i=this._chart.__getPlotAreaSpace();i&&!i.containsPoint(t.x,t.y)&&this._removeDataCursor(e)},l.prototype._showDataCursor=function(t,e,i,r){if(this._context.isOffscreen(!0))this._removeDataCursor(r);else{var a=this._dataCursor,n=this._getClosestMatch(e,i);if(null!=n){var s=n.matchRegion.getCenter(),o=e,l=i;a.getBehavior()==w.BEHAVIOR_SNAP&&(a.isHorizontal()?l=Math.min(Math.max(s.y,t.y),t.y+t.h):o=Math.min(Math.max(s.x,t.x),t.x+t.w));var h=n.logicalObject,u=rt.getDatatip(this._chart,h.getSeriesIndex(),h.getGroupIndex(),h.getNestedDataItemIndex(),!0);if(null!=u){a.setVisible(!0);var g=rt.getDatatipColor(this._chart,h.getSeriesIndex(),h.getGroupIndex(),h.getNestedDataItemIndex()),d=a.isHorizontal()?l:o;if(a.render(t,s.x,s.y,d,u,g),this._dataCursorShown=!0,!r){var c=this._chart.getValuesAt(e,i);this._chart.changeOption("dataCursorPosition",c)}}else a.setVisible(!1)}else this._removeDataCursor(r)}},l.prototype._removeDataCursor=function(t){this._dataCursor.getVisible()&&this._dataCursor.setVisible(!1),this._context.getTooltipManager(w.TOOLTIP_ID).hideTooltip(),this._dataCursorShown=!1,t||this._chart.changeOption("dataCursorPosition",null)},l.prototype.isDataCursorShown=function(){return this._dataCursorShown},l._getClosestMatchSecondDirection=function(t,e,i,r){for(var a=null,n=1/0,s=0;s<t.length;s++){var o=t[s],l=e?i:r,h=((e?o.matchRegion.x:o.matchRegion.y)+(e?o.matchRegion.x+o.matchRegion.w:o.matchRegion.y+o.matchRegion.h))/2,u=Math.round(Math.abs(h-l));u<n&&(n=u,a=o)}return a},l._getClosestMatchesFirstDirection=function(t,e,i,r,a){for(var n=1/0,s=new Array,o=0;o<t.length;o++){var l=t[o];if(a(l.logicalObject)){var h=l.matchRegion,u=e?r:i,g=((e?h.y:h.x)+(e?h.y+h.h:h.x+h.w))/2,d=Math.round(Math.abs(g-u));d<=n&&(d<n&&(s=new Array),s.push(l),n=d)}}return s},l.prototype._findMatches=function(){var t=this._context.getStage(),e=this._chart.getEventManager(),i=[];if(!this._chart._currentMarkers)return null;for(var r=0;r<this._chart._currentMarkers.length;r++)for(var a=this._chart._currentMarkers[r],n=a.length,s=0;s<n;s++){var o=a[s],l=e.GetLogicalObject(o),h={matchRegion:o.getDimensionsSelf?o.getDimensionsSelf(t):o.getDimensions(t),logicalObject:l};i.push(h)}return i},l.prototype._getClosestMatch=function(e,i){var r=at.isHorizontal(this._chart),a=at.isLineArea(this._chart)&&!q.isMixedFrequency(this._chart),n=this._findMatches(),s=et.getHighlightedCategories(this._chart),o="all"==this._chart.getOptions().highlightMatch,h=s.length>0?o?t.ArrayUtils.hasAllItems:t.ArrayUtils.hasAnyItem:null,u=function(t){return!h||h(t.getCategories(),s)},g=l._getClosestMatchesFirstDirection(n,r,e,i,u);if(!at.isScatterBubble(this._chart)){for(var d=1/0,c=-1/0,p=null,_=0;_<g.length;_++){var f=g[_];d=Math.min(d,r?f.matchRegion.y:f.matchRegion.x),c=Math.max(c,r?f.matchRegion.y+f.matchRegion.h:f.matchRegion.x+f.matchRegion.w),p=f.logicalObject.getGroupIndex()}for(_=0;_<n.length;_++){var v=n[_];if(u(v.logicalObject))if(a)v.logicalObject.getGroupIndex()==p&&g.push(v);else{var m=((r?v.matchRegion.y:v.matchRegion.x)+(r?v.matchRegion.y+v.matchRegion.h:v.matchRegion.x+v.matchRegion.w))/2;c>=m&&d<=m&&g.push(v)}}}return l._getClosestMatchSecondDirection(g,r,e,i)};var h=function(){};t.Obj.createSubclass(h,t.BaseComponent),h.newInstance=function(t,e,i){var r=new h;return r.Init(t,e,i),r},h.getDefaults=function(t){return(new d).getDefaults(t)},h.prototype.Init=function(e,i,r){h.superclass.Init.call(this,e,i,r),this.Defaults=new d(e),this.EventManager=new c(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new p(this.EventManager,this)),this._bounds=null},h.prototype.SetOptions=function(t){t?this.Options="off"==t.rendered?t:this.Defaults.calcOptions(t):this.Options||(this.Options=this.GetDefaults())},h.prototype.getPreferredSize=function(t,e,i){return this.SetOptions(t),_.getPreferredSize(this,e,i)},h.prototype.render=function(e,i,r,a,n){this.getCache().clearCache(),this.SetOptions(e),this._navigablePeers=[],this.Width=i,this.Height=r,this.removeChildren(),a||(a=0),n||(n=0);var s=new t.Rectangle(a,n,i,r);_.render(this,s)},h.prototype.__registerObject=function(t){(null!=t.getDatatip()||t.isDrillable())&&this._navigablePeers.push(t)},h.prototype.__getKeyboardObjects=function(){return this._navigablePeers},h.prototype.isNavigable=function(){return this._navigablePeers.length>0},h.prototype.getKeyboardFocus=function(){return null!=this.EventManager?this.EventManager.getFocus():null},h.prototype.setKeyboardFocus=function(e,i){if(null!=this.EventManager){for(var r=this.__getKeyboardObjects(),a=e.getId(),n=!1,s=0;s<r.length;s++){var o=r[s].getId();if(a instanceof Array&&o instanceof Array&&t.ArrayUtils.equals(a,o)||a===o){this.EventManager.setFocusObj(r[s]),n=!0,i&&r[s].showKeyboardFocusEffect();break}}n||this.EventManager.setFocusObj(this.EventManager.getKeyboardHandler().getDefaultNavigable(r));var l=this.getKeyboardFocus();if(l){var h=l.getDisplayable();h.setAriaProperty("label",l.getAriaLabel()),this.getCtx().setActiveElement(h)}}},h.prototype.processEvent=function(t,e){this===e&&this.dispatchEvent(t)},h.prototype.getInfo=function(){return this.Info},h.prototype.__setInfo=function(t){this.Info=t},h.prototype.getWidth=function(){return this.Width},h.prototype.getHeight=function(){return this.Height},h.prototype.__setBounds=function(t){this._bounds=t},h.prototype.__getBounds=function(){return this._bounds},h.prototype.getAutomation=function(){return new g(this)};var u={};t.Obj.createSubclass(u,t.Obj),u.TICK_LABEL="tickLabel",u.TITLE="title";var g=function(t){this._axis=t,this._options=this._axis.getOptions(),this._axisInfo=this._axis.getInfo()};t.Obj.createSubclass(g,t.Automation),g.prototype.GetSubIdForDomElement=function(e){var i=this._axis.getEventManager().GetLogicalObject(e);if(i&&i instanceof t.SimpleObjPeer){if(i.getParams().type==u.TITLE)return"title";if(this._options.groups){for(var r=i.getParams().level,a=this._axisInfo.getStartIndex(i.getParams().index,r),n="",s=0;s<=r;s++)for(var o=this._axisInfo.getLabels(this._axis.getCtx(),s),l=0;l<o.length;l++){var h=this._axisInfo.getLabelIndex(o[l]);this._axisInfo.getStartIndex(h,s)<=a&&this._axisInfo.getEndIndex(h,s)>=a&&(n+="["+this._axisInfo.getPosition(h,s)+"]")}if(n.length>0)return"item"+n}}return null},g.prototype.getDomElementForSubId=function(t){if("title"==t){var e=this._axisInfo.getTitle();if(e)return e.getElem()}else if(this._axisInfo instanceof m)for(var i=t.split("[").length-1-1,r=0,a=0,n=0;n<=i;n++){var s=t.indexOf("["),o=t.indexOf("]"),l=t.substring(s+1,o);t=t.substring(o+1);for(var h,u=this._axisInfo.getLabels(this._axis.getCtx(),n),g=0;g<u.length;g++)if(h=this._axisInfo.getLabelIndex(u[g]),this._axisInfo.getStartIndex(h,n)==a){r=h;break}for(var d=r;d<u.length;d++)if(h=this._axisInfo.getLabelIndex(u[d]),this._axisInfo.getPosition(h,n)==l){if(0==t.length)return u[d].getElem();a=this._axisInfo.getStartIndex(h,n);break}}return null};var d=function(t){this.Init({alta:d.SKIN_ALTA},t)};t.Obj.createSubclass(d,t.BaseComponentDefaults),d.SKIN_ALTA={position:null,baselineScaling:"zero",axisLine:{lineColor:"#9E9E9E",lineWidth:1,rendered:"on"},majorTick:{lineColor:"rgba(196,206,215,0.4)",baselineColor:"auto",lineWidth:1,rendered:"auto",lineStyle:"solid"},minorTick:{lineColor:"rgba(196,206,215,0.2)",lineWidth:1,rendered:"off",lineStyle:"solid"},tickLabel:{scaling:"auto",style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11+"color: #333333;"),rotation:"auto",rendered:"on"},titleStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #737373;"),startGroupOffset:0,endGroupOffset:0,layout:{titleGap:6,radialLabelGap:5,insideLabelGapWidth:4,insideLabelGapHeight:2,hierarchicalLabelGapHeight:8,hierarchicalLabelGapWidth:15},_locale:"en-us"},d.getGapSize=function(e,i,r){var a=Math.min(t.TextUtils.getTextStringHeight(e,i.tickLabel.style)/14,1);return Math.ceil(r*a)};var c=function(t){this.Init(t.getCtx(),t.processEvent,t,t),this._axis=t};t.Obj.createSubclass(c,t.EventManager),c.getUIParams=function(t,e,i,r){return{type:t,id:e,index:i,level:r}},c.prototype.OnClick=function(t){c.superclass.OnClick.call(this,t);var e=this.GetLogicalObject(t.target);e&&(this.processDrillEvent(e)&&t.stopPropagation())},c.prototype.HandleTouchClickInternal=function(t){var e=this.GetLogicalObject(t.target);if(e){var i=t.touchEvent;this.processDrillEvent(e)&&i&&i.preventDefault()}},c.prototype.processDrillEvent=function(e){return!!(e instanceof S&&e.isDrillable())&&(this.FireEvent(t.EventFactory.newChartDrillEvent(e.getId(),null,e.getGroup()),this._axis),!0)},c.prototype.isDndSupported=function(){return!0},c.prototype.GetDragSourceType=function(t){var e=this.DragSource.getDragObject();return e instanceof S&&null!=e.getGroup()?"groups":null},c.prototype.GetDragDataContexts=function(e){var i=this.DragSource.getDragObject();if(i instanceof S){var r={id:i.getId(),group:i.getGroup(),label:i.getLabel().getTextString()};return e&&t.ToolkitUtils.cleanDragDataContext(r),[r]}return[]};var p=function(t,e){this.Init(t,e)};t.Obj.createSubclass(p,t.KeyboardHandler),p.prototype.Init=function(t,e){p.superclass.Init.call(this,t),this._axis=e},p.prototype.processKeyDown=function(e){var i=e.keyCode,r=this._eventManager.getFocus(),a=null;if(i==t.KeyboardEvent.TAB){r&&(t.EventManager.consumeEvent(e),a=r);var n=this._axis.__getKeyboardObjects();n.length>0&&(t.EventManager.consumeEvent(e),a=this.getDefaultNavigable(n))}else i==t.KeyboardEvent.ENTER?r&&(this._eventManager.processDrillEvent(r),t.EventManager.consumeEvent(e)):a=p.superclass.processKeyDown.call(this,e);return a};var _=new Object;t.Obj.createSubclass(_,t.Obj),_._MAX_TITLE_LINE_WRAP=3,_.getPreferredSize=function(e,i,r){var a=_._createAxisInfo(e,new t.Rectangle(0,0,i,r)),n=e.getCtx(),s=e.getOptions(),o="top"==s.position||"bottom"==s.position;if("off"==s.rendered||i<=0||r<=0)return o?new t.Dimension(i,0):new t.Dimension(0,r);var l=_.getTitleHeight(n,s,.8*(o?i:r),.8*(o?r:i)),h=0!=l?l+_._getTitleGap(e):0;if("on"==s.tickLabel.rendered&&"inside"!=s.tickLabel.position)if(o){var u=t.TextUtils.getTextStringHeight(n,s.tickLabel.style);a instanceof v?h+=u:a instanceof C?h+=null!=a.getLabels(n,1)?2*u:u:a instanceof m&&(h=_._getGroupAxisPreferredSize(e,a,h,r,o))}else if(a instanceof v)h+=t.TextUtils.getMaxTextStringWidth(n,a.getAllLabels(n,!0),a.Options.tickLabel.style);else if(a instanceof C){var g=a.getLabels(n),d=t.TextUtils.getMaxTextDimensions(g).w,c=a.getLabels(n,1),p=null!=c?t.TextUtils.getMaxTextDimensions(c).w:0;h+=Math.max(d,p)}else a instanceof m&&(h=_._getGroupAxisPreferredSize(e,a,h,i,o));return o?new t.Dimension(i,Math.min(h,r)):new t.Dimension(Math.min(h,i),r)},_.render=function(t,e){var i=_._createAxisInfo(t,e);"off"!=t.getOptions().rendered&&(t.__setBounds(e.clone()),_._renderBackground(t,e),_._renderTitle(t,i,e),_._renderLabels(t,i,e))},_._createAxisInfo=function(t,e){var i=f.newInstance(t.getCtx(),t.getOptions(),e);return t.__setInfo(i),i},_._getTitleGap=function(t){var e=t.getOptions();return d.getGapSize(t.getCtx(),e,e.layout.titleGap)},_._renderBackground=function(e,i){var r=e.getOptions();if(r.dnd){var a=r.dnd.drop,n=Object.keys(a.xAxis).length>0||Object.keys(a.yAxis).length>0||Object.keys(a.y2Axis).length>0,s=r.dnd.drag,o=Object.keys(s.groups).length>0&&e.getInfo()instanceof m;if(n||o){var l=r.position,h="top"==l||"bottom"==l,u=h?4:10,g=h?10:4,d=new t.Rect(e.getCtx(),i.x-g,i.y-u,i.w+2*g,i.h+2*u);o&&d.setClassName("oj-draggable"),d.setInvisibleFill(),e.getCache().putToCache("background",d),e.addChild(d)}}},_._renderTitle=function(e,i,r){var a=e.getOptions();if(a.title){var n=a.position;if("radial"!=n&&"tangential"!=n){var s="top"==a.position||"bottom"==a.position,o=s?r.w:r.h,l=s?r.h:r.w,h=a.titleStyle,g=_.isWrapEnabled(h),d=_._createText(e.getEventManager(),e,a.title,h,0,0,o,l,c.getUIParams(u.TITLE),g);if(d){var p=_._getTitleGap(e),f=(i.getStartOverflow()-i.getEndOverflow())/2,v=t.Agent.isRightToLeft(e.getCtx()),m=d.getDimensions().h;d.alignCenter(),"top"==n?(d.setX(r.x+f+r.w/2),d.setY(r.y),r.y+=m+p,r.h-=m+p):"bottom"==n?(d.setX(r.x+f+r.w/2),d.setY(r.y+r.h-m),r.h-=m+p):"left"==n?(d.alignMiddle(),d.setRotation(v?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+m/2,r.y+r.h/2),r.x+=m+p,r.w-=m+p):"right"==n&&(d.alignMiddle(),d.setRotation(v?Math.PI/2:3*Math.PI/2),d.setTranslate(r.x+r.w-m/2,r.y+r.h/2),r.w-=m+p),i.setTitle(d)}}}},_._renderLabels=function(t,e,i){var r=t.getOptions();if("on"==r.tickLabel.rendered){var a=r.position;"top"==a||"bottom"==a?_._renderLabelsHoriz(t,e,i):"tangential"==a?_._renderLabelsTangent(t,e,i):_._renderLabelsVert(t,e,i),_._renderGroupSeparators(t,e,i)}},_._renderLabelsHoriz=function(e,i,r){var a=e.getCtx(),n=e.getOptions(),s=n.position,o="inside"==n.tickLabel.position,l=t.Agent.isRightToLeft(a),h=i instanceof m,g=h&&i.getNumLevels()>1,p=g?0:null,_=i.getLabels(a,p);for(b=g?d.getGapSize(a,n,n.layout.hierarchicalLabelGapHeight):0;_;){for(var f=0,v=0,y=0;y<_.length;y++){var x=_[y];if(null!=x){var A=x instanceof t.MultilineText||x instanceof t.BackgroundMultilineText;if(i.isLabelRotated(p)){if((!A||A&&!x.isWrapEnabled())&&!t.TextUtils.fitText(x,r.h,r.w,e))continue;l?x.alignLeft():x.alignRight(),g?(f=x.getDimensions().w,x.setTranslateY(r.h-f),v=Math.max(v,f)):x.setTranslateY(r.y)}else{if(!o&&x.getDimensions().h-1>r.h)continue;if(g&&"bottom"==s?x.setY(r.h):"bottom"==s?x.setY(r.y):x.setY(r.y+r.h),!g&&("bottom"==s&&!o||"top"==s&&o)?x.alignTop():g&&"top"==s?x.alignTop():x.alignBottom(),g)v=Math.max(v,x.getDimensions().h);else if(o){var b=d.getGapSize(a,n,n.layout.insideLabelGapWidth);l?x.alignRight():x.alignLeft(),x.setX(x.getX()+b*(l?-1:1))}}var M=h?i.getLabelIndex(x):y,T=i.getDatatip(M,p),I=x.getUntruncatedTextString(),O=i.isDrillable(M,p),D=i.getGroup(M,p),E=c.getUIParams(u.TICK_LABEL,x.getTextString(),M,p);e.getEventManager().associate(x,new S(e,x,D,O,I,T,E)),g?i.setLastRenderedLevel(p):v=Math.max(v,x.getDimensions().h),e.addChild(x)}}if(g){for(y=0;y<_.length;y++)if(null!=(x=_[y])){var P=i.isLabelRotated(p),L=p<i.getNumLevels()-1;!P&&L?(x.setY(r.h-v/2),x.alignMiddle()):x.setTranslateY(r.h-v)}r.y+=v+b,r.h-=v+b,p++,_=i.getLabels(e.getCtx(),p)}else r.y+=v,r.h-=v,_=null}if(i instanceof C){_=i.getLabels(e.getCtx());var w=i.getLabels(e.getCtx(),1),R=0;if(null!=w)for(y=0;y<w.length;y++)if(null!=(x=w[y])&&!(x.getDimensions().h-1>r.h)){e.getEventManager().associate(x,new t.SimpleObjPeer(null,null,null,c.getUIParams(u.TICK_LABEL,x.getTextString())));var B=0,k=0,F=i.getOptions()._maxOverflowCoord,N=i.getOptions()._minOverflowCoord;if(null!=_[y]&&(R=_[y].getDimensions().w/2,B=i._level1Overflow[y],k=i._level2Overflow[y]),0==B&&0==k){var H,G=x.getX();l?(H=G+R<=F?G+R:F,x.setX(H)):(H=G-R>=N?G-R:N,x.setX(H))}else B<0?x.setX(N):B>0&&x.setX(F);x.alignTop(),x.setY(r.y),e.addChild(x)}}},_._renderLabelsVert=function(e,i,r){var a,n,s,o=e.getOptions(),l=o.position,h=e.getCtx(),g=t.Agent.isRightToLeft(h),p=i instanceof v,_="inside"==o.tickLabel.position,f=i instanceof m,y=f&&i.getNumLevels()>1,x=y?0:null;a=i.getLabels(e.getCtx(),x);var A=0;y?(n=d.getGapSize(h,o,o.layout.hierarchicalLabelGapWidth),s=t.TextUtils.getMaxTextDimensions(a).w):"radial"==l?(n=d.getGapSize(h,o,o.layout.radialLabelGap),A=r.x+r.w/2,g?A+=n+t.TextUtils.getMaxTextDimensions(a).w:A-=n):"left"==l?(A=r.x+r.w,p&&_&&(A+=t.TextUtils.getMaxTextDimensions(a).w)):(A=r.x,p&&!_&&(A+=t.TextUtils.getMaxTextDimensions(a).w));for(var b=function(n,v){var m=n instanceof t.MultilineText||n instanceof t.BackgroundMultilineText,C=!m||m&&!n.isWrapEnabled();if(!(y&&t.TextUtils.getMaxTextDimensions(a).w-1>r.w)&&(y||_||!C||t.TextUtils.fitText(n,r.w,r.h,e))){v=f?i.getLabelIndex(n):v;var b=i.getDatatip(v,x),M=n.getUntruncatedTextString(),T=i.isDrillable(v,x),I=i.getGroup(v,x),O=c.getUIParams(u.TICK_LABEL,n.getTextString(),v,x);if(e.getEventManager().associate(n,new S(e,n,I,T,M,b,O)),y)n.alignRight(),n.setX(g?r.w:r.x+s),i.setLastRenderedLevel(x);else if(n.setX(A),p||"right"!=l?n.alignRight():n.alignLeft(),_&&(n.alignBottom(),n.setY(n.getY()-d.getGapSize(h,o,o.layout.insideLabelGapHeight))),"radial"==l){var D=n.getY();n.setY(r.y+r.h/2-D);var E=n.getDimensions(),P=.15*E.h,L=t.PathUtils.roundedRectangle(E.x-P,E.y,E.w+2*P,E.h,2,2,2,2),w=new t.Path(e.getCtx(),L),R=n.getCSSStyle().getStyle(t.CSSStyle.BACKGROUND_COLOR),B=D+E.h/2>i.getEndCoord()&&"circle"==e.getOptions().polarGridShape?1:.3;R?w.setSolidFill(R):w.setSolidFill("#FFFFFF",B),e.addChild(w)}e.addChild(n)}};a;){for(var M=0;M<a.length;M++){var T=a[M];null!=T&&b(T,M)}if(!y)break;r.x+=s+n,r.w-=s+n,x++,a=i.getLabels(e.getCtx(),x),s=a?t.TextUtils.getMaxTextDimensions(a).w:null}if(i instanceof C){var I=i.getLabels(e.getCtx(),1);if(null!=I)for(M=0;M<I.length;M++)null!=(T=I[M])&&b(T,M)}},_._renderLabelsTangent=function(e,i,r){for(var a=i.getLabels(e.getCtx()),n=0;n<a.length;n++){var s=a[n];if(null!=s){var o=r.w/2-Math.abs(s.getX()),l=r.h/2-Math.abs(s.getY());if(t.TextUtils.fitText(s,o,l,e)){var h=i instanceof m?i.getLabelIndex(s):n,g=i.getDatatip(h),d=s.getUntruncatedTextString(),p=i.isDrillable(h),_=i.getGroup(h),f=c.getUIParams(u.TICK_LABEL,s.getTextString(),h);e.getEventManager().associate(s,new S(e,s,_,p,d,g,f)),s.setTranslateX(r.x+r.w/2),s.setTranslateY(r.y+r.h/2),e.addChild(s)}}}},_._createText=function(e,i,r,a,n,s,o,l,h,u){var g;return u?((g=new t.MultilineText(i.getCtx(),r,n,s)).setMaxLines(_._MAX_TITLE_LINE_WRAP),g.setCSSStyle(a),g.wrapText(o,l,1)):(g=new t.OutputText(i.getCtx(),r,n,s)).setCSSStyle(a),t.TextUtils.fitText(g,o,l,i)?(e.associate(g,new t.SimpleObjPeer(g.getUntruncatedTextString(),null,null,h)),g):null},_._renderGroupSeparators=function(e,i,r){if(i instanceof m&&i.areSeparatorsRendered()){var a=i.getNumLevels(),n=i.getSeparatorStartLevel();if(a<=1||n<=0)return;for(var s,o,l,h,u,g,c=e.getOptions(),p=c.position,f="top"==p||"bottom"==p,v=e.getCtx(),S=t.Agent.isRightToLeft(v),C=i.getSeparatorColor(),y=new t.Stroke(C,1,1),x=0,A=f?d.getGapSize(v,c,c.layout.hierarchicalLabelGapHeight):d.getGapSize(v,c,c.layout.hierarchicalLabelGapWidth),b=c.startGroupOffset,M=c.endGroupOffset,T=n;T>=0;T--){var I=i.getLabels(e.getCtx(),T),O=t.TextUtils.getMaxTextDimensions(I),D=i.isLabelRotated(T),E=D||!f?O.w:O.h;if(0!=E){var P=!1,L=null;if(T<n)for(var w=0;w<I.length;w++){var R=I[w];if(null!=R){var B=i.getLabelIndex(R),k=0==i.getLabelAt(B,T).length;if(!k){var F=k&&0==T&&(0==B||B==I.length-1),N=R&&null==I[B-1],H=R&&null==I[B+1],G=i.getStartIndex(B,T),U=i.getEndIndex(B,T);if(f){var V;if(R)V=R instanceof t.MultilineText||R instanceof t.BackgroundMultilineText?R.getYAlignCoord():R.getY(),s=i.getCoordAt(G-b),o=D?V+.5*x:V-E/2-.5*x-A,l=i.getCoordAt(U+M),h=D?V+E+x+2*A:V,k&&F||0!=P||null==s||_._addSeparatorLine(e,y,s,h,s,o),null==l||F||_._addSeparatorLine(e,y,l,h,l,o);if(!k){if(R)var j=D?R.getDimensions().h:R.getDimensions().w;s=N&&0==L?i.getStartCoord():i.getBoundedCoordAt(G-b),N&&(N=!1);var Y=i.getLabelAt(B+1,T);if(l=H&&Y&&Y.length>0?i.getEndCoord():i.getBoundedCoordAt(U+M),u=R?S?R.getX()+.5*j:R.getX()-.5*j:i.getBoundedCoordAt(U+M),g=R?S?R.getX()-.5*j:R.getX()+.5*j:i.getBoundedCoordAt(G-b),R)if(D)_._addSeparatorLine(e,y,s,h,l,h);else{var W=S?.5*-R.getDimensions().h:.5*R.getDimensions().h,z=S?g+W>l:g+W<l;(S?s>u-W:s<u-W)&&_._addSeparatorLine(e,y,s,h,u-W,h),z&&_._addSeparatorLine(e,y,g+W,h,l,h)}}}else R&&(s=S?R.getX()-E-.5*A:R.getX()+.5*A,o=i.getCoordAt(G-b),l=S?R.getX()+.5*A:R.getX()-E-.5*A,h=i.getCoordAt(U+M),(!k&&0==P||0==B&&k&&0!=T)&&null!=o&&_._addSeparatorLine(e,y,s,o,l,o),null==h||F||_._addSeparatorLine(e,y,l,h,s,h)),k||(o=N&&0==L?0:i.getBoundedCoordAt(G-b),N&&(N=!1),Y=i.getLabelAt(B+1,T),h=H&&Y&&Y.length>0?i.getEndCoord():i.getBoundedCoordAt(U+M),R&&_._addSeparatorLine(e,y,l,o,l,h));P=!k&&null!=R,L=null!=R||null==R&&k}}}x=E}else x=E}}},_._addSeparatorLine=function(e,i,r,a,n,s){var o=new t.Line(e.getCtx(),r,a,n,s);o.setStroke(i),o.setPixelHinting(!0),e.addChild(o)},_._getGroupAxisPreferredSize=function(e,i,r,a,n){for(var s=e.getCtx(),o=e.getOptions(),l=i.getNumLevels(),h=n?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",u=l>1?d.getGapSize(s,o,o.layout[h]):0,g=0;g<l;g++){var c;if(i.isAutoRotate()){for(var p=[],_=[],f=i.getSkipIncrement(),v=0;v<i.getGroupCount();v+=f){p.push(i.getLabelAt(v,0));var m=i.getLabelStyleAt(v,0);m||(m=i.Options.tickLabel.style),_.push(m)}c=t.TextUtils.getMaxTextStringWidth(s,p,_)}else{var S=i.getLabels(s,g);if(n){var C=t.TextUtils.getMaxTextDimensions(S);c=i.isLabelRotated(g)?C.w:C.h}else c=t.TextUtils.getMaxTextDimensions(S).w}if(!(r+c<=a)){0==g&&(r=a);break}r+=c+u}return 0!=g&&(r-=u),r},_.getTitleHeight=function(e,i,r,a){var n=0;if(i.title)if(_.isWrapEnabled(i.titleStyle)){var s=new t.MultilineText(e,i.title,0,0);s.setMaxLines(_._MAX_TITLE_LINE_WRAP),s.setCSSStyle(i.titleStyle),s.wrapText(r,a,1),n=t.TextUtils.getTextStringHeight(e,i.titleStyle)*s.getLineCount()}else n=t.TextUtils.getTextStringHeight(e,i.titleStyle);return n},_.isWrapEnabled=function(e){var i=e.getStyle(t.CSSStyle.WHITE_SPACE);return"nowrap"!=i&&"noWrap"!=i};var f=function(){};t.Obj.createSubclass(f,t.BaseAxisInfo),f.newInstance=function(t,e,i){return e.timeAxisType&&"disabled"!=e.timeAxisType?new C(t,e,i):e._isGroupAxis?new m(t,e,i):new v(t,e,i)},f.prototype.Init=function(t,e,i){f.superclass.Init.call(this,t,e,i),this._title=null},f.prototype.getLabels=function(t,e){return null},f.prototype.getTitle=function(){return this._title},f.prototype.setTitle=function(t){this._title=t},f.prototype.getMajorTickCoords=function(){return[]},f.prototype.getMinorTickCoords=function(){return[]},f.prototype.getBaselineCoord=function(){return null},f.prototype.getDatatip=function(t,e){return null},f.prototype.getLabelBackground=function(t,e){return null},f.prototype.isDrillable=function(t){return null},f.prototype.isLabelRotated=function(){return!1},f.prototype.CreateLabel=function(e,i,r,a,n){var s;if("tangential"==this.Position){var o=16/180*Math.PI,l=1/180*Math.PI,h=.5*this.getTickLabelHeight(),u=this._radius+h;(r<l||r>2*Math.PI-l)&&(u+=h);var g=Math.round(u*Math.sin(r)),d=Math.round(-u*Math.cos(r));s=a?new t.BackgroundOutputText(e,i,g,d,a):new t.OutputText(e,i,g,d),r<l||Math.abs(r-Math.PI)<l||r>2*Math.PI-l?s.alignCenter():r<Math.PI?s.alignLeft():s.alignRight(),Math.abs(r-Math.PI/2)<o||Math.abs(r-3*Math.PI/2)<o?s.alignMiddle():r<Math.PI/2||r>3*Math.PI/2?s.alignBottom():s.alignTop()}else n?s=a?new t.BackgroundMultilineText(e,i,r,r,a):new t.MultilineText(e,i,r,r):(s=a?new t.BackgroundOutputText(e,i,r,r,a):new t.OutputText(e,i,r,r)).alignMiddle(),s.alignCenter();return(s instanceof t.OutputText||s instanceof t.MultilineText)&&s.setCSSStyle(this.Options.tickLabel.style),s},f.prototype.IsOverlapping=function(e,i,r){if(!e||e.length<=0)return!1;for(var a,n,s,o,l="left"==this.Position||"right"==this.Position||"radial"==this.Position,h=t.Agent.isRightToLeft(this.getCtx()),u=this.GetTickLabelGapSize(),g=0;g<e.length;g+=i+1)if(null!=e[g]){if(null!=r&&e[g].w>r[g])return!0;if(null!=a&&null!=n){if(l){if(s=e[g].y,o=e[g].y+e[g].h,s>=a&&s-u<n)return!0;if(s<a&&o+u>a)return!0}else{if(s=e[g].x,o=e[g].x+e[g].w,!h&&s-u<n)return!0;if(h&&o+u>a)return!0}a=s,n=o}else l?(a=e[g].y,n=e[g].y+e[g].h):(a=e[g].x,n=e[g].x+e[g].w)}return!1},f.prototype.IsOverlappingDims=function(t,e){if(!t||!e)return!1;var i=t.y,r=t.y+t.h,a=t.x,n=t.x+t.w,s=e.y,o=e.y+e.h,l=e.x,h=e.x+e.w;return(a<=l&&l<=n||a<=h&&h<=n||l<=a&&a<=h||l<=n&&n<=h)&&(s>=i&&s<r||s<=i&&o>=i)},f.prototype.GetTickLabelGapSize=function(){var t=this.getTickLabelHeight(),e=this instanceof m?.24*t:.79*t,i=this instanceof m?.08*t:.28*t;return"left"==this.Position||"right"==this.Position||"radial"==this.Position||this.isLabelRotated()?i:e},f.prototype.getTickLabelHeight=function(){return t.TextUtils.getTextStringHeight(this.getCtx(),this.Options.tickLabel.style)},f.prototype.SkipLabels=function(t,e){for(var i=0,r=this.IsOverlapping(e,i);r;)i++,r=this.IsOverlapping(e,i);if(i>0){for(var a=[],n=0;n<t.length;n+=i+1)a.push(t[n]);return a}return t},f.prototype.SkipTangentialLabels=function(t,e){var i=[],r=t.length,a=null;if(r>1){for(var n,s=0;s<r;s++)e[s]&&(!n||n&&!this.IsOverlappingDims(n,e[s]))&&(a||(a=e[s]),i.push(t[s]),n=e[s]);return this.IsOverlappingDims(n,a)&&i.pop(),i}return t},f.prototype.GetLabelDims=function(t,e,i){for(var r=[],a=this.isLabelRotated(i),n=0;n<t.length;n++){var s=t[n];if(null!=s){var o=s.getDimensions(e);null!=i&&(o.x=(a?s.getTranslateX():s.getX())-o.w/2,o.y=(a?s.getTranslateY():s.getY())-o.h/2),o.w&&o.h?r.push(o):r.push(null)}else r.push(null)}return r},f.prototype.getMajorTickCount=function(){return null},f.prototype.getMinorTickCount=function(){return null},f.prototype.getMajorIncrement=function(){return null},f.prototype.getMinorIncrement=function(){return null},f.prototype.getGlobalMin=function(){return this.GlobalMin},f.prototype.getGlobalMax=function(){return this.GlobalMax},f.prototype.getViewportMin=function(){return this.MinValue},f.prototype.getViewportMax=function(){return this.MaxValue},f.prototype.getDataMin=function(){return this.DataMin},f.prototype.getDataMax=function(){return this.DataMax},f.prototype.getMinimumExtent=function(){return 0},f.prototype.getStartCoord=function(){return this.StartCoord},f.prototype.getEndCoord=function(){return this.EndCoord},f.prototype.getStartOverflow=function(){return this.StartOverflow},f.prototype.getEndOverflow=function(){return this.EndOverflow},f.prototype.getGroupWidth=function(){return 0},f.prototype.getGroup=function(t,e){return null},f.prototype.linearToActual=function(t){return t},f.prototype.actualToLinear=function(t){return t},f.prototype.alignLogScaleToTickCount=function(t,e){return t},f.prototype.getLogScaleUnit=function(){return null};var v=function(t,e,i){this.Init(t,e,i)};t.Obj.createSubclass(v,f),v.prototype.Init=function(t,e,i){v.superclass.Init.call(this,t,e,i),this.MixinInit.call(this,t,e,i)},v.MAX_ZOOM_FACTOR=64,v.prototype.getMinLabel=function(){return this.ZeroBaseline||"on"==this.Options._continuousExtent&&null==this.Options.min?Math.ceil(this.LinearMinValue/this.MajorIncrement)*this.MajorIncrement:Math.ceil((this.LinearMinValue-this.LinearGlobalMin)/this.MajorIncrement)*this.MajorIncrement+this.LinearGlobalMin},v.prototype.getLabels=function(t,e){if(e&&e>0)return null;var i=this.getAllLabels(t),r=[],a=t.getStage();return"tangential"!=this.Position&&(r=this.GetLabelDims(i,a),i=this.SkipLabels(i,r)),i},v.prototype.getAllLabels=function(e,i){var r=[];if(this.Options.tickLabel&&this.Options.tickLabel.scaling){var a=this.Options.tickLabel.autoPrecision?this.Options.tickLabel.autoPrecision:"on";this._axisValueFormatter=new t.LinearScaleAxisValueFormatter(e,this.LinearMinValue,this.LinearMaxValue,this.MajorIncrement,this.Options.tickLabel.scaling,a,this.Options.translations)}for(var n=0;n<=this.MajorTickCount;n++){var s=n*this.MajorIncrement+this.getMinLabel();if(s-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;var o,l=this.GetUnboundedCoordAt(s);if(this.Options._skipHighestTick){if(s==this.LinearMaxValue)continue;if("tangential"!=this.Position&&Math.abs(l-this.MaxCoord)<this.getTickLabelHeight())continue}this.IsLog?(s=this.linearToActual(s),this._axisValueFormatter=new t.LinearScaleAxisValueFormatter(e,s,s,s,this.Options.tickLabel.scaling,a,this.Options.translations),o=this._formatValue(s)):o=this._formatValue(s),i?r.push(o):r.push(this.CreateLabel(e,o,l))}return r},v.prototype.getMajorTickCoords=function(){for(var t=[],e=0;e<=this.MajorTickCount;e++){var i=e*this.MajorIncrement+this.getMinLabel();if(i-this.LinearMaxValue>this.MAJOR_TICK_INCREMENT_BUFFER)break;if(!this.Options._skipHighestTick||i!=this.LinearMaxValue){var r=this.GetUnboundedCoordAt(i);t.push(r)}}return t},v.prototype.getMinorTickCoords=function(){for(var e=[],i=-1;i<=this.MajorTickCount;i++){var r=i*this.MajorIncrement+this.getMinLabel();if(this.IsLog&&1==this.MajorIncrement&&1==this.MinorIncrement)for(var a=2;a<=9;a++){var n=r+t.Math.log10(a);if(n>this.LinearMaxValue)break;n<this.LinearMinValue||(o=this.GetUnboundedCoordAt(n),e.push(o))}else for(a=1;a<this.MinorTickCount;a++){var s=r+a*this.MinorIncrement;if(s>this.LinearMaxValue)break;if(!(s<this.LinearMinValue)){var o=this.GetUnboundedCoordAt(s);e.push(o)}}}return e},v.prototype._formatValue=function(e){if(!this.Converter||!this.Converter.getAsString&&!this.Converter.format){if(this._axisValueFormatter)return this._axisValueFormatter.format(e);var i=t.Math.log10(this.MajorIncrement),r=Math.max(Math.ceil(-i),0);return e.toFixed(r)}return this._axisValueFormatter?this._axisValueFormatter.format(e,this.Converter):this.Converter.getAsString?this.Converter.getAsString(e):this.Converter.format?this.Converter.format(e):void 0},v.prototype.getMajorTickCount=function(){return this.MajorTickCount},v.prototype.getMinorTickCount=function(){return this.MinorTickCount},v.prototype.getMajorIncrement=function(){return this.linearToActual(this.MajorIncrement)},v.prototype.getMinorIncrement=function(){return this.linearToActual(this.MinorIncrement)},v.prototype.getMinimumExtent=function(){return(this.LinearGlobalMax-this.LinearGlobalMin)/this.MAX_ZOOM_FACTOR},v.prototype.getStartOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow},v.prototype.getEndOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow},v.prototype.alignLogScaleToTickCount=function(t,e){if(this.IsLog)for(var i=this.getMajorTickCount();e<i;)this.MajorIncrement=null,this.MajorTickCount=null,this.MinorIncrement=null,this.MinorTickCount=null,t++,this.CalcMajorMinorIncr(t),i=this.getMajorTickCount();return t},v.prototype.getLogScaleUnit=function(){return this.LogScaleUnit},t.DataAxisInfoMixin.call(v.prototype);var m=function(t,e,i){this.Init(t,e,i)};t.Obj.createSubclass(m,f),m._MAX_LINE_WRAP=3,m._ROTATE_THRESHOLD=12,m.prototype.Init=function(e,i,r){m.superclass.Init.call(this,e,i,r);var a=t.Agent.isRightToLeft(e),n="top"==this.Position||"bottom"==this.Position;if(n&&a){var s=this.StartCoord;this.StartCoord=this.EndCoord,this.EndCoord=s}this._levelsArray=[],this._groupCount=this._generateLevelsArray(i.groups,0,this._levelsArray,0),this._numLevels=this._levelsArray.length,this._areSeparatorsRendered="off"!=i.groupSeparators.rendered,this._separatorColor=i.groupSeparators.color,this._lastRenderedLevel=null,this._drilling=i.drilling;var o=i.endGroupOffset>0?Number(i.endGroupOffset):0,l=i.startGroupOffset>0?Number(i.startGroupOffset):0;this.DataMin=0,this.DataMax=this._groupCount-1,this.GlobalMin=null==i.min?this.DataMin-l:i.min,this.GlobalMax=null==i.max?this.DataMax+o:i.max;var h=this.getGroupIndex(i.viewportStartGroup),u=this.getGroupIndex(i.viewportEndGroup);-1!=h&&(this.MinValue=h-l),-1!=u&&(this.MaxValue=u+o),null!=i.viewportMin&&(this.MinValue=i.viewportMin),null!=i.viewportMax&&(this.MaxValue=i.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._groupWidthRatios=i._groupWidthRatios,this._processGroupWidthRatios(),this._startBuffer=a?i.rightBuffer:i.leftBuffer,this._endBuffer=a?i.leftBuffer:i.rightBuffer,this._isLabelRotated=[];for(var g=0;g<this._numLevels;g++)this._isLabelRotated.push(!1);if(this._renderGridAtLabels=i._renderGridAtLabels,this._labels=null,this._maxSpace=n?r.h:r.w,"off"!=i.rendered){var c=_.getTitleHeight(e,i,n?r.w:r.h,n?r.h:r.w);this._maxSpace-=0!=c?c+d.getGapSize(e,i,i.layout.titleGap):0}this._maxLineWrap=m._MAX_LINE_WRAP},m.prototype._processGroupWidthRatios=function(){if(!this._groupWidthRatios||this._groupWidthRatios.length<2)this._groupWidthRatios=null;else{for(var t,e,i=0,r=0;r<this._groupCount;r++)t=0==r?this.MinValue:Math.max(r-.5,this.MinValue),(e=r==this._groupCount-1?this.MaxValue:Math.min(r+.5,this.MaxValue))>t&&(i+=(e-t)*this._groupWidthRatios[r]);var a=this.EndCoord-this.StartCoord;this._groupWidths=this._groupWidthRatios.map(function(t){return t*a/i}),this._borderValues=[];for(r=0;r<this._groupWidthRatios.length-1;r++)this._borderValues.push(r+.5);this._borderCoords=[];var n=Math.min(Math.max(Math.round(this.MinValue),0),this._borderValues.length-1);this._borderCoords[n]=this.StartCoord+(this._borderValues[n]-this.MinValue)*this._groupWidths[n];for(r=n+1;r<this._borderValues.length;r++)this._borderCoords[r]=this._borderCoords[r-1]+this._groupWidths[r];for(r=n-1;r>=0;r--)this._borderCoords[r]=this._borderCoords[r+1]-this._groupWidths[r+1]}},m.prototype._rotateLabels=function(e,i,r,a){var n,s,o=this.getCtx(),l=t.Agent.isRightToLeft(o),h=this._numLevels>1;null==a&&(a=this._numLevels-1),this._isLabelRotated[a]=!0,h||this._setOverflow(r,r,e);for(var u=0;u<e.length;u++)if(null!=(n=e[u])){if(s=n.getX(),n instanceof t.MultilineText||n instanceof t.BackgroundMultilineText){var g=this.getGroupWidth()*(this.getEndIndex(u,a)-this.getStartIndex(u,a)+1);2*n.getLineHeight()<g&&this._maxSpace>0?n.wrapText(this._maxSpace,n.getLineHeight()*m._MAX_LINE_WRAP,1):n.setWrapEnabled(!1)}n.setX(0),n.setY(0),l?n.setRotation(Math.PI/2):n.setRotation(3*Math.PI/2),n.setTranslateX(s)}var d=this.GetLabelDims(e,i,a);_.isWrapEnabled(this.Options.tickLabel.style)&&this._maxSpace>0&&(this._sanitizeWrappedText(o,d,e,!0,h)&&(d=this.GetLabelDims(e,i,a)));return this.SkipLabels(e,d)},m.prototype._sanitizeWrappedText=function(e,i,r,a,n){for(var s=this._calculateMaxWrap(i,r,a),o=0,l=0;l<r.length;l++){var h=r[l];if(h){var u=h instanceof t.MultilineText||h instanceof t.BackgroundMultilineText;s&&u&&h.isWrapEnabled()&&h.wrapText(this._maxSpace,h.getLineHeight()*this._maxLineWrap,1),n&&(o=Math.max(o,h.getDimensions().w)),h.alignMiddle()}}if(n){var g=a?this.Options.layout.hierarchicalLabelGapHeight:this.Options.layout.hierarchicalLabelGapWidth;this._maxSpace-=o+d.getGapSize(e,this.Options,g)}return s},m.prototype._calculateMaxWrap=function(e,i,r){for(var a=!1;this.IsOverlapping(e,0)&&this._maxLineWrap>1;){a=!0;for(var n=0;n<i.length;n++){var s=i[n];if((s instanceof t.MultilineText||s instanceof t.BackgroundMultilineText)&&s.getLineCount()==this._maxLineWrap){var o=s.getLineHeight();r?e[n].w-=o:(e[n].y+=.5*o,e[n].h-=o)}}this._maxLineWrap--}return a},m.prototype.isLabelRotated=function(t){return null==t&&(t=this._numLevels-1),this._isLabelRotated[t]},m.prototype._setOverflow=function(e,i,r){e=Math.max(e-this._startBuffer,0),i=Math.max(i-this._endBuffer,0);var a=t.Agent.isRightToLeft(this.getCtx());this.StartCoord+=(e-this.StartOverflow)*(a?-1:1),this.EndCoord-=(i-this.EndOverflow)*(a?-1:1),this._processGroupWidthRatios();for(var n=0;n<this._numLevels;n++){r=this._labels[n];for(var s=0;s<r.length;s++){var o=r[s];if(o){var l=this._getLabelCoord(n,this.getLabelIndex(o));o.setX(l)}}}this.StartOverflow=e,this.EndOverflow=i},m.prototype.getLabels=function(t,e){return null==e&&(e=this._numLevels-1),this._labels||this._generateLabels(t),this._labels[e]},m.prototype._getLabelCoord=function(t,e){var i=this.getStartIndex(e,t),r=this.getEndIndex(e,t);if(null==i||null==r)return null;i<this.MinValue&&r>this.MinValue&&(i=this.MinValue),r>this.MaxValue&&i<this.MaxValue&&(r=this.MaxValue);var a=r?i+(r-i)/2:i;return this.getCoordAt(a)},m.prototype._generateLabels=function(e){var i=[];this._labels=[];for(var r,a,n,s,o,l=e.getStage(),h="top"==this.Position||"bottom"==this.Position,u=t.Agent.isRightToLeft(e),g=this._numLevels>1,c=this.getGroupWidth(),p=this._maxSpace,f=h?"hierarchicalLabelGapHeight":"hierarchicalLabelGapWidth",v=g?d.getGapSize(e,this.Options,this.Options.layout[f]):0,m="auto"==this.Options.tickLabel.rotation&&h,S={},C=this.isAutoRotate(),y=this.Options.tickLabel.style,x=_.isWrapEnabled(this.Options.tickLabel.style)&&"tangential"!=this.Position&&c>t.TextUtils.getTextStringHeight(e,y),A=0;A<this._numLevels;A++){var b=this._levelsArray[A],M=C?this.getSkipIncrement():1;S[A]=[];for(var T=0;T<b.length;T+=M)if(b[T]){if(""===(r=this.getLabelAt(T,A))||!r&&0!=r){i.push(null);continue}var I=this._getLabelCoord(A,T);if(null!=I){s=this.getLabelStyleAt(T,A);var O=!C&&x&&"number"!=typeof r&&r.indexOf(" ")>=0;o=this.CreateLabel(e,r,I,s,O);var D=c*(this.getEndIndex(T,A)-this.getStartIndex(T,A)+1);S[A].push(D),O&&this._isTextWrapNeeded(e,r,s,m,h?D:p)&&p>0?h?o.wrapText(D,p,1,!0):o.wrapText(p,o.getLineHeight()*this._maxLineWrap,1,!1):O&&(!h||p<0)&&o.setWrapEnabled(!1),o._index=T,i.push(o),a||0!=A||(a=o),0==A&&(n=o)}else i.push(null)}else i.push(null);if(x&&g){for(var E=0,P=0;P<i.length;P++)if(i[P]){var L=i[P].getDimensions();E=Math.max(E,h?L.h:L.w)}p-=E+v}this._labels.push(i),i=[]}i=this._labels[this._numLevels-1];var w=[];if(a){if("tangential"==this.Position)return w=this.GetLabelDims(i,l),void(this._labels[0]=this.SkipTangentialLabels(i,w));var R=a.getDimensions();if(h){var B,k;if(null!=this.Options._startOverflow&&null!=this.Options._endOverflow)B=this.Options._startOverflow,k=this.Options._endOverflow;else{var F=n.getDimensions();B=u?R.w+R.x-this.StartCoord:this.StartCoord-R.x,k=u?this.EndCoord-F.x:F.w+F.x-this.EndCoord}!C&&(B>this._startBuffer||k>this._endBuffer)&&this._setOverflow(B,k,i)}for(A=0;A<this._numLevels;A++)if(i=this._labels[A],C)this._labels[A]=this._rotateLabels(i,l,R.h/2,A);else{w=this.GetLabelDims(i,l,A);var N=this.IsOverlapping(w,0,S[A]);if(N||(this._labels[A]=i),h)if(m){if(N)this._labels[A]=this._rotateLabels(i,l,R.h/2,A);else if(this._labels[A]=i,g){var H=0;for(P=0;P<w.length;P++)w[P]&&(H=Math.max(H,w[P].h));this._maxSpace-=H+v}}else w=this.GetLabelDims(i,l),this._labels[A]=this.SkipLabels(i,w);else{if(x)this._sanitizeWrappedText(e,w,i,!1,g)&&(w=this.GetLabelDims(i,l,A));this._labels[A]=this.SkipLabels(i,w)}}}},m.prototype.getMajorTickCoords=function(){for(var t,e=[],i="tangential"==this.Position?this.getGroupCount():this.getGroupCount()-1,r=0;r<this._levelsArray[0].length;r++)if(this._levelsArray[0][r]){var a=this.getStartIndex(r,0),n=this.getEndIndex(r,0);null!=(t=this._renderGridAtLabels?this.getCoordAt(a+.5*(n-a)):n+.5<i?this.getCoordAt(n+.5):null)&&e.push(t)}return e},m.prototype.getMinorTickCoords=function(){var t,e=[];if(!this._levelsArray[1])return e;for(var i=0;i<this._levelsArray[1].length;i++)if(this._levelsArray[1][i]){var r=this.getStartIndex(i,1),a=this.getEndIndex(i,1);null!=(t=this._renderGridAtLabels?this.getCoordAt(r+.5*(a-r)):a+.5<this.getGroupCount()-1?this.getCoordAt(a+.5):null)&&e.push(t)}return e},m.prototype.getUnboundedValueAt=function(t){if(null==t)return null;if(this._groupWidthRatios){for(var e=this._borderCoords.length,i=0;i<this._borderCoords.length;i++)if(t<=this._borderCoords[i]){e=i;break}return 0==e?this._borderValues[0]-(this._borderCoords[0]-t)/this._groupWidths[0]:this._borderValues[e-1]+(t-this._borderCoords[e-1])/this._groupWidths[e]}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.MinValue+(t-this.StartCoord)/r},m.prototype.getUnboundedCoordAt=function(t){if(null==t)return null;if(this._groupWidthRatios){for(var e=this._borderValues.length,i=0;i<this._borderValues.length;i++)if(t<=this._borderValues[i]){e=i;break}return 0==e?this._borderCoords[0]-this._groupWidths[0]*(this._borderValues[0]-t):this._borderCoords[e-1]+this._groupWidths[e]*(t-this._borderValues[e-1])}var r=(this.EndCoord-this.StartCoord)/(this.MaxValue-this.MinValue);return this.StartCoord+(t-this.MinValue)*r},m.prototype.getLabelAt=function(t,e){if(null==e&&(e=this._numLevels-1),(t=Math.round(t))<0)return null;var i=this._levelsArray[e]&&this._levelsArray[e][t]?this._levelsArray[e][t].item:null;return i&&(i.name?i=i.name:null!=i.id&&(i="")),i},m.prototype.getGroupAt=function(t,e){if(null==e&&(e=this._numLevels-1),(t=Math.round(t))<0)return null;var i=this._levelsArray[e]&&this._levelsArray[e][t]?this._levelsArray[e][t].item:null;if(i){if(i.id)return i.id;if(i.name||""===i.name)return i.name}return i},m.prototype.getLabelStyleAt=function(e,i){var r=this._getGroupAttribute(e,i,"labelStyle");if(r){var a=new t.CSSStyle(r);return a.getStyle("font-size")||a.setStyle("font-size",this.Options.tickLabel.style.getStyle("font-size")),a}return null},m.prototype.getDatatip=function(t,e){return this._getGroupAttribute(t,e,"shortDesc")},m.prototype.isDrillable=function(t,e){var i=this._getGroupAttribute(t,e,"drilling");return"on"==i||"off"!=i&&("on"==this._drilling||"groupsOnly"==this._drilling)},m.prototype.getGroup=function(t,e){if(t<0||t>this.getGroupCount()-1)return null;if(1==this._numLevels)return this.getGroupAt(t);var i=[];null==e&&(e=this._numLevels-1);for(var r=this.getStartIndex(t,e),a=0;a<=e;a++)for(var n=this._levelsArray[a],s=0;s<n.length;s++)this.getStartIndex(s,a)<=r&&this.getEndIndex(s,a)>=r&&i.push(this.getGroupAt(s,a));return i.length>0?1==i.length?i[0]:i:null},m.prototype.getLabelBackground=function(e,i,r){null==r&&(r=this._numLevels-1);var a=e.getCSSStyle();if(a){var n=a.getStyle(t.CSSStyle.BACKGROUND_COLOR),s=a.getStyle(t.CSSStyle.BORDER_COLOR),o=a.getStyle(t.CSSStyle.BORDER_WIDTH),l=a.getStyle(t.CSSStyle.BORDER_RADIUS);if(null!=n||null!=s||null!=o||null!=l){var h=e.getDimensions(),u=.15*h.h;"chrome"!==t.Agent.browser&&"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||e.getVertAlignment()!==t.OutputText.V_ALIGN_BOTTOM||(h.y+=h.h/2);var g=new t.Rect(i,h.x-u,h.y,h.w+2*u,h.h),d=new t.CSSStyle;return null!=n?d.setStyle(t.CSSStyle.BACKGROUND_COLOR,n):g.setInvisibleFill(),d.setStyle(t.CSSStyle.BORDER_COLOR,s),d.setStyle(t.CSSStyle.BORDER_WIDTH,o),d.setStyle(t.CSSStyle.BORDER_RADIUS,l),g.setCSSStyle(d),this._isLabelRotated[r]&&g.setMatrix(e.getMatrix()),g.setMouseEnabled(!1),g}return null}return null},m.prototype.getGroupIndex=function(e){if(null==e)return-1;for(var i=-1,r=0;r<this._groupCount;r++){var a=this.getGroup(r);if(e instanceof Array&&a instanceof Array?t.ArrayUtils.equals(e,a):e==a){i=r;break}}return i},m.prototype.getMinimumExtent=function(){return 1},m.prototype.getGroupWidth=function(){return Math.abs(this.EndCoord-this.StartCoord)/Math.abs(this.MaxValue-this.MinValue)},m.prototype.getGroupCount=function(){return this._groupCount},m.prototype.getNumLevels=function(){return this._numLevels},m.prototype._generateLevelsArray=function(t,e,i,r){for(var a=0;a<t.length;a++)if(i[e]||(i[e]=[]),i[e].push({item:t[a],start:r,end:r,position:a}),t[a]&&t[a].groups){var n=i[e].length-1,s=this._generateLevelsArray(t[a].groups,e+1,i,i[e][n].start);r!=s?(i[e][n].end=s-1,r=s):r++}else r++;return r},m.prototype._getGroupAttribute=function(t,e,i){null==e&&(e=this._numLevels-1);var r=this._levelsArray[e]&&this._levelsArray[e][t]?this._levelsArray[e][t].item:null;return r?r[i]:null},m.prototype.areSeparatorsRendered=function(){return this._areSeparatorsRendered},m.prototype.getSeparatorColor=function(){return this._separatorColor},m.prototype.getStartIndex=function(t,e){return null==e&&(e=this._numLevels-1),this._levelsArray[e]&&this._levelsArray[e][t]?this._levelsArray[e][t].start:null},m.prototype.getEndIndex=function(t,e){return null==e&&(e=this._numLevels-1),this._levelsArray[e]&&this._levelsArray[e][t]?this._levelsArray[e][t].end:null},m.prototype.getPosition=function(t,e){return null==e&&(e=this._numLevels-1),this._levelsArray[e]&&this._levelsArray[e][t]?this._levelsArray[e][t].position:null},m.prototype.isRenderGridAtLabels=function(){return this._renderGridAtLabels},m.prototype.setLastRenderedLevel=function(t){this._lastRenderedLevel=t},m.prototype.getLastRenderedLevel=function(){return this._lastRenderedLevel},m.prototype.getSeparatorStartLevel=function(){for(var t=this._lastRenderedLevel,e=this._lastRenderedLevel-1;e>=0;e--)this._labels[e].length!=this._levelsArray[e].length&&(t=e);return t},m.prototype.getLabelIndex=function(t){return t._index>=0?t._index:null},m.prototype.getMaxLineWrap=function(){return this._maxLineWrap},m.prototype._isTextWrapNeeded=function(e,i,r,a,n){var s=t.TextUtils.getTextStringWidth(e,i,r);return s>=n&&(s/this._maxLineWrap<n||!a)},m.prototype.isAutoRotate=function(){var t="top"==this.Position||"bottom"==this.Position,e=this._numLevels>1,i=this.getGroupWidth(),r="auto"==this.Options.tickLabel.rotation&&t;return!e&&r&&i<m._ROTATE_THRESHOLD},m.prototype.getSkipIncrement=function(){var t=1;return t=m._ROTATE_THRESHOLD/(2*this.getGroupWidth()),this.Options._duringZoomAndScroll&&(t*=4),Math.max(1,Math.floor(t))};var S=function(t,e,i,r,a,n,s){this.Init(t,e,i,r,a,n,s)};t.Obj.createSubclass(S,t.SimpleObjPeer),S.prototype.Init=function(e,i,r,a,n,s,o){S.superclass.Init.call(this,n,s,null,o),this._axis=e,this._label=i,this._group=r,this._drillable=a,this._drillable&&i.setCursor(t.SelectionEffectUtils.getSelectingCursor()),e.__registerObject(this)},S.prototype.getLabel=function(){return this._label},S.prototype.getId=function(){return this._group},S.prototype.isDrillable=function(){return this._drillable},S.prototype.getGroup=function(){return this._group},S.prototype.getNextNavigable=function(e){if(e.type==t.MouseEvent.CLICK)return this;var i=this._axis.__getKeyboardObjects();return t.KeyboardHandler.getNextNavigable(this,e,i,!1,this._axis.getCtx().getStage())},S.prototype.getKeyboardBoundingBox=function(e){return this._label?this._label.getDimensions(e):new t.Rectangle(0,0,0,0)},S.prototype.getDisplayable=function(){return this._label},S.prototype.getTargetElem=function(){return this._label?this._label.getElem():null},S.prototype.showKeyboardFocusEffect=function(){if(this._isShowingKeyboardFocusEffect=!0,this._label){var e=this.getKeyboardBoundingBox();this._overlayRect=new t.Rect(this._axis.getCtx(),e.x,e.y,e.w,e.h),this._overlayRect.setSolidStroke(t.Agent.getFocusColor()),this._overlayRect.setInvisibleFill(),this._overlayRect.setMatrix(this._label.getMatrix()),this._axis.addChild(this._overlayRect)}},S.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this._label&&(this._axis.removeChild(this._overlayRect),this._overlayRect=null)},S.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},S.prototype.getAriaLabel=function(){var e;return this.isDrillable()&&(e=[this._axis.getOptions().translations.stateDrillable]),null!=this.getDatatip()?t.Displayable.generateAriaLabel(this.getDatatip(),e):null!=e?t.Displayable.generateAriaLabel(this.getLabel().getTextString(),e):void 0},S.prototype.isDragAvailable=function(t){return!0},S.prototype.getDragTransferable=function(t,e){return[this.getId()]},S.prototype.getDragFeedback=function(t,e){return[this.getDisplayable()]};var C=function(t,e,i){this.Init(t,e,i)};t.Obj.createSubclass(C,f),C.TIME_SECOND=1e3,C.TIME_MINUTE=60*C.TIME_SECOND,C.TIME_HOUR=60*C.TIME_MINUTE,C.TIME_DAY=24*C.TIME_HOUR,C.TIME_MONTH_MIN=28*C.TIME_DAY,C.TIME_MONTH_MAX=31*C.TIME_DAY,C.TIME_YEAR_MIN=365*C.TIME_DAY,C.TIME_YEAR_MAX=366*C.TIME_DAY,C.prototype.Init=function(e,i,r){C.superclass.Init.call(this,e,i,r),"top"==this.Position||"bottom"==this.Position?(i._isOverview||"on"!=i.tickLabel.rendered||(this.StartOverflow=Math.max(t.BaseAxisInfo.MINIMUM_AXIS_BUFFER-i.leftBuffer,0),this.EndOverflow=Math.max(t.BaseAxisInfo.MINIMUM_AXIS_BUFFER-i.rightBuffer,0)),t.Agent.isRightToLeft(e)?(this._startCoord=this.EndCoord-this.EndOverflow,this._endCoord=this.StartCoord+this.StartOverflow):(this._startCoord=this.StartCoord+this.StartOverflow,this._endCoord=this.EndCoord-this.EndOverflow)):(this._startCoord=this.StartCoord,this._endCoord=this.EndCoord);var a=null!=i.tickLabel?i.tickLabel.converter:null;this._label1Converter=a&&a[0]?a[0]:a,this._label2Converter=a&&a[1]?a[1]:null,this._dateToIsoWithTimeZoneConverter=e.getLocaleHelpers().dateToIsoWithTimeZoneConverter,this._groups=i.groups;var n=i.timeAxisType;this._skipGaps="skipGaps"==n,this._mixedFrequency="mixedFrequency"==n,this.DataMin=i.dataMin,this.DataMax=i.dataMax,this._groups.length>1?this._averageInterval=(this.DataMax-this.DataMin)/(this._groups.length-1):this.DataMax-this.DataMin>0?this._averageInterval=this.DataMax-this.DataMin:this._averageInterval=6*C.TIME_MINUTE,this._step=i.step;var s=i.endGroupOffset>0?i.endGroupOffset*this._averageInterval:0,o=i.startGroupOffset>0?i.startGroupOffset*this._averageInterval:0;this.GlobalMin=null!=i.min?i.min:this.DataMin-o,this.GlobalMax=null!=i.max?i.max:this.DataMax+s,null!=i.viewportStartGroup&&(this.MinValue=i.viewportStartGroup-o),null!=i.viewportEndGroup&&(this.MaxValue=i.viewportEndGroup+s),null!=i.viewportMin&&(this.MinValue=i.viewportMin),null!=i.viewportMax&&(this.MaxValue=i.viewportMax),null==this.MinValue&&(this.MinValue=this.GlobalMin),null==this.MaxValue&&(this.MaxValue=this.GlobalMax),this.GlobalMin>this.MinValue&&(this.GlobalMin=this.MinValue),this.GlobalMax<this.MaxValue&&(this.GlobalMax=this.MaxValue),this._timeRange=this.MaxValue-this.MinValue,this._level1Labels=null,this._level2Labels=null,this._level1Coords=null,this._level2Coords=null,this._isOneLevel=!0,this._level1Overflow=[],this._level2Overflow=[],this._locale=i._locale.toLowerCase(),this._monthResources=e.LocaleData.getMonthNames("abbreviated")},C._getAMString=function(t){var e=t.substring(0,2);if("en-au"==t||"en-ie"==t||"en-ph"==t)return"am";if("en-gb"==t)return"";switch(e){case"en":return"AM";case"ar":return"ص";case"el":return"πμ";case"ko":return"오전";case"zh":return"上午";default:return""}},C._getPMString=function(t){var e=t.substring(0,2);if("en-au"==t||"en-ie"==t||"en-ph"==t)return"pm";if("en-gb"==t)return"";switch(e){case"en":return"PM";case"ar":return"م";case"el":return"μμ";case"ko":return"오후";case"zh":return"下午";default:return""}},C._getAMPMBefore=function(t){var e=t.substring(0,2);return"ko"==e||"zh"==e},C._getDMYOrder=function(t){var e=t.substring(0,2);return"en-us"==t||"en-ph"==t?"MDY":"fa"==e||"hu"==e||"ja"==e||"ko"==e||"lt"==e||"mn"==e||"zh"==e?"YMD":"DMY"},C._getYearTrailingCharacters=function(t){return 0==t.indexOf("ja")||0==t.indexOf("zh")?"年":0==t.indexOf("ko")?"년":""},C._getDayTrailingCharacters=function(t){return 0==t.indexOf("ja")||0==t.indexOf("zh")?"日":0==t.indexOf("ko")?"일":""},C.prototype.formatLabel=function(t){var e=new Date(t),i=this._formatAxisLabel(e,null,!0);return null!=i[1]?"YMD"==C._getDMYOrder(this._locale)||this._timeRange<C.TIME_MONTH_MIN&&this._step<C.TIME_DAY?i[1]+" "+i[0]:i[0]+" "+i[1]:i[0]},C.prototype._formatAxisLabelWithConverter=function(t,e,i){if(i){var r=null,a=null;if(i.getAsString?(r=i.getAsString(t),a=i.getAsString(e)):i.format&&(r=i.format(this._dateToIsoWithTimeZoneConverter&&t?this._dateToIsoWithTimeZoneConverter(t):t),a=i.format(this._dateToIsoWithTimeZoneConverter&&e?this._dateToIsoWithTimeZoneConverter(e):e)),a!=r)return r}return null},C.prototype._formatAxisLabel=function(t,e,i){var r=null,a=null,n="left"==this.Position||"right"==this.Position;return this._label1Converter||this._label2Converter?(this._label1Converter&&(r=this._formatAxisLabelWithConverter(t,e,this._label1Converter)),this._label2Converter&&(a=this._formatAxisLabelWithConverter(t,e,this._label2Converter)),[r,a]):(this._step>=C.TIME_YEAR_MIN||this._timeRange>=6*C.TIME_YEAR_MIN?r=this._formatDate(t,!1,!1,!0):this._step>=C.TIME_MONTH_MIN||this._timeRange>=6*C.TIME_MONTH_MIN?(null!=e&&e.getMonth()==t.getMonth()||(r=this._formatDate(t,!1,!0,!1)),null!=e&&e.getYear()==t.getYear()||(a=this._formatDate(t,!1,!1,!0))):this._step>=C.TIME_DAY||this._timeRange>=6*C.TIME_DAY?i?r=this._formatDate(t,!0,!0,!0):(null!=e&&e.getDate()==t.getDate()||(r=this._formatDate(t,!0,!1,!1)),null==e||e.getYear()!=t.getYear()?a=this._formatDate(t,!1,!0,!0):e.getMonth()!=t.getMonth()&&(a=this._formatDate(t,!1,!0,!1))):(this._step>=C.TIME_HOUR||this._timeRange>=6*C.TIME_HOUR?null!=e&&e.getHours()==t.getHours()||(r=this._formatTime(t,!1,!1)):this._step>=C.TIME_MINUTE||this._timeRange>=6*C.TIME_MINUTE?null!=e&&e.getMinutes()==t.getMinutes()||(r=this._formatTime(t,!0,!1)):null!=e&&e.getSeconds()==t.getSeconds()||(r=this._formatTime(t,!0,!0)),n?null!=e&&e.getDate()==t.getDate()||(a=this._formatDate(t,!0,!0,!1)):null==e||e.getYear()!=t.getYear()?a=this._formatDate(t,!0,!0,!0):e.getMonth()!=t.getMonth()?a=this._formatDate(t,!0,!0,!1):e.getDate()!=t.getDate()&&(a=this._formatDate(t,!0,!1,!1))),[r,a])},C.prototype._formatDate=function(t,e,i,r){var a,n="th"==this._locale.substring(0,2)&&"jet"!=this.Options._environment?t.getFullYear()+543:t.getFullYear();a=this._monthResources&&this._monthResources.length>=12?this._monthResources[t.getMonth()]:t.toString().split(" ")[1];var s=t.getDate();n+=C._getYearTrailingCharacters(this._locale),s+=C._getDayTrailingCharacters(this._locale);for(var o=C._getDMYOrder(this._locale),l="",h=0;h<o.length;h++)e&&"D"==o[h]?l+=s+" ":i&&"M"==o[h]?l+=a+" ":r&&"Y"==o[h]&&(l+=n+" ");return l.length>0?l.slice(0,l.length-1):l},C.prototype._formatTime=function(e,i,r){var a,n=e.getHours(),s=e.getMinutes(),o=e.getSeconds(),l=C._getAMString(this._locale),h=C._getPMString(this._locale),u=C._getAMPMBefore(this._locale),g=""!=l&&""!=h,d="";return t.Agent.isRightToLeft(this.getCtx())&&(d="‏"),g?(n<12?(a=l,0==n&&(n=12)):(a=h,n>12&&(n-=12)),d+=n,(i||0!=s)&&(d+=":"+this._doubleDigit(s))):d+=this._doubleDigit(n)+":"+this._doubleDigit(s),r&&(d+=":"+this._doubleDigit(o)),g?u?a+" "+d:d+" "+a:d},C.prototype._doubleDigit=function(t){return t<10?"0"+t:""+t},C.prototype._getMixedFrequencyStep=function(){return this._timeRange>=6*C.TIME_YEAR_MIN?C.TIME_YEAR_MIN:this._timeRange>=6*C.TIME_MONTH_MIN?C.TIME_MONTH_MIN:this._timeRange>=6*C.TIME_DAY?C.TIME_DAY:this._timeRange>=C.TIME_DAY?3*C.TIME_HOUR:this._timeRange>=6*C.TIME_HOUR?C.TIME_HOUR:this._timeRange>=C.TIME_HOUR?15*C.TIME_MINUTE:this._timeRange>=30*C.TIME_MINUTE?5*C.TIME_MINUTE:this._timeRange>=6*C.TIME_MINUTE?C.TIME_MINUTE:this._timeRange>=C.TIME_MINUTE?15*C.TIME_SECOND:this._timeRange>=30*C.TIME_SECOND?5*C.TIME_SECOND:C.TIME_SECOND},C._getLabelPositions=function(t,e,i){var r=new Date(t),a=r.getTimezoneOffset();r.setMonth(0,1),r.setHours(0,0,0,0);var n=60*(a-r.getTimezoneOffset())*1e3,s=r.getTime()+n,o=[];if(i>=C.TIME_YEAR_MIN&&i<=C.TIME_YEAR_MAX){for(;s<t;)s=C._addOneYear(s);for(;s<=e;)o.push(s),s=C._addOneYear(s)}else if(i>=C.TIME_MONTH_MIN&&i<=C.TIME_MONTH_MAX){for(;s<t;)s=C._addOneMonth(s);for(;s<=e;)o.push(s),s=C._addOneMonth(s)}else for(s+=Math.ceil((t-s)/i)*i;s<=e;)o.push(s),s+=i;return o},C._addOneYear=function(t){var e=new Date(t);return e.setFullYear(e.getFullYear()+1),e.getTime()},C._addOneMonth=function(t){var e=new Date(t);return e.setMonth(e.getMonth()+1),e.getTime()},C.prototype._generateLabels=function(e){var i=[],r=[],a=[],n=[],s=[],o=null,l=0,h=0,u=e.getStage(e),g=t.Agent.isRightToLeft(e),d="left"==this.Position||"right"==this.Position,c="off"!=this.Options.zoomAndScroll,p=!0,_=0;d&&"chrome"===t.Agent.browser&&(_=.16*this.getTickLabelHeight());var f=[];if(null!=this._step)f=C._getLabelPositions(this.MinValue,this.MaxValue,this._step);else if(this._mixedFrequency)this._step=this._getMixedFrequencyStep(),f=C._getLabelPositions(this.MinValue,this.MaxValue,this._step);else{for(var v=0;v<this._groups.length;v++)this._groups[v]>=this.MinValue&&this._groups[v]<=this.MaxValue&&f.push(this._groups[v]);if(this._step=this._averageInterval,!this._skipGaps){var m;if(d)m=t.TextUtils.getTextStringHeight(e,this.Options.tickLabel.style);else{var S=this._formatAxisLabel(new Date(f[0]))[0];m=t.TextUtils.getTextStringWidth(e,S,this.Options.tickLabel.style)}(m+this.GetTickLabelGapSize())*(f.length-1)>Math.abs(this._endCoord-this._startCoord)&&(this._step=this._getMixedFrequencyStep(),f=C._getLabelPositions(this.MinValue,this.MaxValue,this._step))}}0==f.length&&(f=[this.MinValue]);for(v=0;v<f.length;v++){var y=f[v],x=this.getCoordAt(y);if(null!=x){var A=new Date(y),b=this._formatAxisLabel(A,o),M=b[0],T=b[1];if(null!=M?(a.push({text:M,coord:null!=T?x+_:x}),n.push(x),l++):(a.push(null),n.push(null)),i.push(null),c&&p&&(x=this.MinValue?this.getCoordAt(this.MinValue):x),p=!1,null!=T){var I=this.CreateLabel(e,T,null!=T?x-_:x);s.push(x),d||(g?I.alignRight():I.alignLeft()),r.push(I),this._isOneLevel=!1,h++}else r.push(null),s.push(null);o=A}}if(l=this._skipLabelsUniform(a,i,u,!1,g),!c&&h>1&&l<1.5*h){i=r,r=null;for(var O=0;O<i.length;O++)null!=i[O]&&i[O].alignCenter();l=this._skipLabelsGreedy(i,this.GetLabelDims(i,u),!1,g)}else 0==(h=this._skipLabelsGreedy(r,this.GetLabelDims(r,u),!0,g))&&(r=null);d&&null!=r&&this._skipVertLabels(i,r,u),this._level1Labels=i,this._level2Labels=r,this._level1Coords=n,this._level2Coords=s},C._isOverlapping=function(t,e,i,r,a){return i>=t&&i-a<e||i<t&&r+a>t},C.prototype._getLabelOverflow=function(t,e,i,r){var a=t-(i?r?e:0:.5*e);if(a<this.Options._minOverflowCoord)return Math.floor(a-this.Options._minOverflowCoord);var n=t+(i?r?0:e:.5*e);return n>this.Options._maxOverflowCoord?Math.ceil(n-this.Options._maxOverflowCoord):0},C.prototype._skipLabelsGreedy=function(t,e,i,r){if(!e||e.length<=0)return!1;for(var a,n,s,o,l,h="left"==this.Position||"right"==this.Position,u=this.getTickLabelHeight(),g=h?.08*u:.24*u,d=0,c=Math.abs(this._endCoord-this._startCoord),p=0;p<e.length;p++)if(this._level2Overflow.push(0),null!=t[p]){var _=(l=t[p]).getDimensions().w;if(e[p].w>c)t[p]=null;else{var f=this._getLabelOverflow(l.getX(),_,i,r);this._level2Overflow[p]=f,0!=f&&(l.setX(l.getX()-f),e[p].x-=f)}}for(p=0;p<e.length;p++)null!=e[p]&&(h?(s=e[p].y,o=e[p].y+e[p].h):(s=e[p].x,o=e[p].x+e[p].w),null!=a&&null!=n&&C._isOverlapping(a,n,s,o,g)&&(t[p]=null),null!=t[p]&&(a=s,n=o,d++));return d},C.prototype._skipLabelsUniform=function(t,e,i,r){for(var a=[],n=[],s=Math.abs(this._endCoord-this._startCoord),o=0;o<t.length;o++)null!=t[o]&&(a.push(t[o]),n.push(null),this._level1Overflow.push(0));for(var l="left"==this.Position||"right"==this.Position,h=this,u=function(t){if(null==n[t])if(a[t].label=h.CreateLabel(i.getCtx(),a[t].text,a[t].coord),n[t]=a[t].label.getDimensions(i),n[t].w>s)a[t].label=null,n[t].w=0,n[t].h=0;else{var e=h._getLabelOverflow(a[t].coord,n[t].w,!1,r);0!=e&&(a[t].coord-=e,n[t].x-=e,a[t].label.setX(a[t].label.getX()-e),h._level1Overflow[t]=e)}return l?n[t].h:n[t].w},g=(u(0)+this.GetTickLabelGapSize())*(a.length-1),d=s>0?Math.ceil(g/s)-1:0,c=!0;c;){for(o=0;o<a.length;o++)o%(d+1)==0?(u(o),a[o].skipped=!1):a[o].skipped=!0;c=this.IsOverlapping(n,d),d++}var p=0;for(o=0;o<t.length;o++)null==t[o]||t[o].skipped||(e[o]=t[o].label,p++);return p},C.prototype._skipVertLabels=function(t,e,i){for(var r=.08*this.getTickLabelHeight(),a=function(t,e){return C._isOverlapping(t.y,t.y+t.h,e.y,e.y+e.h,r)},n=null,s=!1,o=0;o<t.length;o++)if(t[o]&&e[o]){if(t[o].alignTop(),e[o].alignBottom(),n&&a(n,e[o].getDimensions())){s=!0;break}n=t[o].getDimensions()}else if(t[o]||e[o]){var l=t[o]?t[o]:e[o];if(n&&a(n,l.getDimensions())){s=!0;break}n=l.getDimensions()}if(s){var h,u=null,g=null,d=null;for(o=0;o<t.length;o++)e[o]?(t[o]=null,e[o].alignMiddle(),h=e[o].getDimensions(),g&&a(g,h)&&(t[u]=null),d=h):t[o]&&(h=t[o].getDimensions(),d&&a(d,h)?t[o]=null:(g=h,u=o))}},C.prototype.getLabels=function(t,e){return e&&e>1?null:(this._level1Labels||this._generateLabels(t),1==e?this._level2Labels:this._level1Labels)},C.prototype.getMajorTickCoords=function(){var t=[];if(this._isOneLevel)for(var e=0;e<this._level1Coords.length;e++)null!=this._level1Coords[e]&&null!=this._level1Labels[e]&&t.push(this._level1Coords[e]);else for(e=1;e<this._level2Coords.length;e++)null!=this._level2Coords[e]&&t.push(this._level2Coords[e]);return t},C.prototype.getMinorTickCoords=function(){if(this._isOneLevel)return[];for(var t=[],e=0;e<this._level1Coords.length;e++)null!=this._level1Coords[e]&&null!=this._level1Labels[e]&&t.push(this._level1Coords[e]);return t},C.prototype.getUnboundedValueAt=function(t){if(null==t)return null;var e=(t-this._startCoord)/(this._endCoord-this._startCoord);if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);return this._indexToTime(i+e*(r-i))}return this.MinValue+e*(this.MaxValue-this.MinValue)},C.prototype.getUnboundedCoordAt=function(t){if(null==t)return null;var e;if(this._skipGaps){var i=this._timeToIndex(this.MinValue),r=this._timeToIndex(this.MaxValue);e=(this._timeToIndex(t)-i)/(r-i)}else e=(t-this.MinValue)/(this.MaxValue-this.MinValue);return this._startCoord+e*(this._endCoord-this._startCoord)},C.prototype.linearToActual=function(t){return null==t?null:this._skipGaps?this._indexToTime(t):t},C.prototype.actualToLinear=function(t){return null==t?null:this._skipGaps?this._timeToIndex(t):t},C.prototype._timeToIndex=function(t){for(var e=this._groups.length,i=0;i<this._groups.length;i++)if(t<=this._groups[i]){e=i;break}var r=e-1,a=void 0!==this._groups[r]?this._groups[r]:this._groups[0]-this._averageInterval;return r+(t-a)/((void 0!==this._groups[e]?this._groups[e]:this._groups[this._groups.length-1]+this._averageInterval)-a)},C.prototype._indexToTime=function(t){var e=Math.min(Math.max(Math.ceil(t),0),this._groups.length),i=e-1,r=void 0!==this._groups[i]?this._groups[i]:this._groups[0]-this._averageInterval;return r+(t-i)*((void 0!==this._groups[e]?this._groups[e]:this._groups[this._groups.length-1]+this._averageInterval)-r)},C.prototype.getGroupWidth=function(){return this._skipGaps?Math.abs(this.getUnboundedCoordAt(this._indexToTime(1))-this.getUnboundedCoordAt(this._indexToTime(0))):Math.abs(this.getUnboundedCoordAt(this.MinValue+this._averageInterval)-this.getUnboundedCoordAt(this.MinValue))},C.prototype.getMinimumExtent=function(){return this._skipGaps?1:this._mixedFrequency?Math.min((this.getGlobalMax()-this.getGlobalMin())/8,this._averageInterval):this._averageInterval},C.prototype.getStartOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.StartOverflow:this.EndOverflow},C.prototype.getEndOverflow=function(){return"top"!=this.Position&&"bottom"!=this.Position||!t.Agent.isRightToLeft(this.getCtx())?this.EndOverflow:this.StartOverflow};var y=function(t,e,i,r,a,n,s,o,l,h){this.Init(t,null,h),this.setWedgeParams(e,i,r,a,n,s,o,l)};t.Obj.createSubclass(y,t.Path),y._OUTER_BORDER_WIDTH=2,y._OUTER_BORDER_WIDTH_HOVER=1.25,y._INNER_BORDER_WIDTH=1,y.prototype.Init=function(t,e,i){y.superclass.Init.call(this,t,e,i)},y.prototype.setWedgeParams=function(t,e,i,r,a,n,s,o){this._cx=t,this._cy=e,this._rx=i,this._ry=r,this._sa=a,this._ae=n,this._gap=s,this._ir=o;var l=this._makeWedgePath(0);this.setCmds(l)},y.prototype._makeWedgePath=function(e){var i,r=Math.max(this._rx-e,0),a=Math.max(this._ry-e,0),n=360==this._ae||r<e?0:this._gap+2*e,s=this._ir?this._ir+e:0,o=360==this._ae?t.Math.degreesToRads(359.99):t.Math.degreesToRads(this._ae),l=t.Math.degreesToRads(this._sa),h=n/2,u=h<r?Math.asin(h/r):0,g=-o/2-l,d=Math.min(5*h,o>0?Math.abs(h/Math.sin(o/2)):0),c=0==r?d:d*a/r,p=this._cx+Math.cos(g)*d,_=this._cy+Math.sin(g)*c,f=this._cx+Math.cos(-u-l)*r,v=this._cy+Math.sin(-u-l)*a,m=this._cx+Math.cos(-l-o+u)*r,S=this._cy+Math.sin(-l-o+u)*a,C=t.Math.calculateAngleBetweenTwoVectors(m-this._cx,S-this._cy,f-this._cx,v-this._cy);if(C=Math.min(C,o),s>0){var y=h<s?Math.asin(h/s):0,x=this._cx+Math.cos(-y-l)*s,A=this._cy+Math.sin(-y-l)*s,b=this._cx+Math.cos(-l-o+y)*s,M=this._cy+Math.sin(-l-o+y)*s,T=t.Math.calculateAngleBetweenTwoVectors(b-this._cx,M-this._cy,x-this._cx,A-this._cy);T=Math.min(T,C,o),360==this._ae?(i=t.PathUtils.moveTo(m,S),i+=t.PathUtils.arcTo(r,a,o,1,f,v),i+=t.PathUtils.lineTo(m,S),i+=t.PathUtils.moveTo(x,A),i+=t.PathUtils.arcTo(s,s,o,0,b,M)):(i=t.PathUtils.moveTo(b,M),i+=t.PathUtils.lineTo(m,S),i+=t.PathUtils.arcTo(r,a,C,1,f,v),i+=t.PathUtils.lineTo(x,A),i+=t.PathUtils.arcTo(s,s,T,0,b,M))}else 360==this._ae?(i=t.PathUtils.moveTo(m,S),i+=t.PathUtils.arcTo(r,a,o,1,f,v)):(i=t.PathUtils.moveTo(p,_),i+=t.PathUtils.lineTo(m,S),i+=t.PathUtils.arcTo(r,a,C,1,f,v));return i+=t.PathUtils.closePath()},y.prototype._initializeSelectionEffects=function(){var e=this.isSelected()?y._OUTER_BORDER_WIDTH:y._OUTER_BORDER_WIDTH_HOVER,i=this._makeWedgePath(e),r=this._makeWedgePath(e+y._INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setCmds(i),void this.InnerChild.setCmds(r);this.OuterChild=new t.Path(this.getCtx(),i),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new t.Path(this.getCtx(),r),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)},y.prototype._showNestedBorders=function(t,e){this._initializeSelectionEffects(),e?(this.setSolidFill(t),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(e),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):t?(this.setSolidFill(t),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._shapeStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())},y.prototype.setStyleProperties=function(e,i,r,a,n,s,o){this._fill=e,this._shapeStroke=i,this._hoverColor=t.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=a,this._outerColor=n,this._shapeClassName=s,this._shapeStyle=o,this.setStyle(o).setClassName(s),this.setFill(e),i&&this.setStroke(i)},y.prototype.showHoverEffect=function(){this.IsShowingHoverEffect=!0,this._showNestedBorders(this._hoverColor,this._innerColor)},y.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect=!1,this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders()},y.prototype.setSelected=function(t){this.IsSelected!=t&&(this.IsSelected=t,this.isHoverEffectShown()?this._showNestedBorders(this._hoverColor,this._innerColor):this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())},y.prototype.UpdateSelectionEffect=function(){};var x=function(t,e,i){this._x1=Math.min(e[0],e[4]),this._x2=Math.max(e[0],e[4]),this._y1=Math.min(e[1],e[5]),this._y2=Math.max(e[1],e[5]),this.Init(t,[this._x1,this._y1,this._x2,this._y1,this._x2,this._y2,this._x1,this._y2],i)};t.Obj.createSubclass(x,t.Polygon),x.OUTER_BORDER_WIDTH=2,x.OUTER_BORDER_WIDTH_HOVER=1.25,x.INNER_BORDER_WIDTH=1,x.prototype.setStyleProperties=function(e,i,r,a,n,s,o){this._fill=e,this._borderStroke=i,this._hoverColor=t.SelectionEffectUtils.getHoverBorderColor(r),this._innerColor=a,this._outerColor=n,this._shapeClassName=s,this._shapeStyle=o,this.setStyle(o).setClassName(s),this.setFill(e),i&&this.setStroke(i)},x.prototype.setAnimationParams=function(t){this._x1=Math.min(t[0],t[4]),this._x2=Math.max(t[0],t[4]),this._y1=Math.min(t[1],t[5]),this._y2=Math.max(t[1],t[5]),this.setPoints(t),this._initializeSelectionEffects()},x.prototype.showHoverEffect=function(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this._showNestedBorders(this._hoverColor,this._innerColor))},x.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())},x.prototype.setSelected=function(t){this.IsSelected!=t&&(this.IsSelected=t,this.isHoverEffectShown()?this._showNestedBorders(this._hoverColor,this._innerColor):this.isSelected()?this._showNestedBorders(this._outerColor,this._innerColor):this._showNestedBorders())},x.prototype.UpdateSelectionEffect=function(){},x.prototype.getPrimaryFill=function(){return this._fill},x.prototype._initializeSelectionEffects=function(){var e=this.isSelected()?x.OUTER_BORDER_WIDTH:x.OUTER_BORDER_WIDTH_HOVER,i=this._createPointsArray(e),r=this._createPointsArray(e+x.INNER_BORDER_WIDTH);if(this.OuterChild)return this.OuterChild.setPoints(i),void this.InnerChild.setPoints(r);this.OuterChild=new t.Polygon(this.getCtx(),i),this.OuterChild.setInvisibleFill(),this.OuterChild.setMouseEnabled(!0),this.addChild(this.OuterChild),this.InnerChild=new t.Polygon(this.getCtx(),r),this.InnerChild.setInvisibleFill(),this.InnerChild.setMouseEnabled(!0),this.addChild(this.InnerChild)},x.prototype._showNestedBorders=function(t,e){this._initializeSelectionEffects(),e?(this.setSolidFill(t),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setSolidFill(e),this.OuterChild.setClassName().setStyle(),this.InnerChild.setFill(this._fill),this.InnerChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle)):t?(this.setSolidFill(t),this.setStroke(null),this.setClassName().setStyle(),this.OuterChild.setFill(this._fill),this.OuterChild.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle()):(this.setFill(this._fill),this.setStroke(this._borderStroke),this.setClassName(this._shapeClassName).setStyle(this._shapeStyle),this.OuterChild.setInvisibleFill(),this.OuterChild.setClassName().setStyle(),this.InnerChild.setInvisibleFill(),this.InnerChild.setClassName().setStyle())},x.prototype._createPointsArray=function(t){var e=this._x1+t,i=this._x2-t,r=this._y1+t,a=this._y2-t;return[e,r,i,r,i,a,e,a]};var A=function(t,e,i){this.Init(t,e,i)};t.Obj.createSubclass(A,h),A.prototype.axisToPlotArea=function(t){if("tangential"==this.getOptions().position)return t;if(null==t)return null;var e=t-this.getLeftOverflow();return Math.round(10*e)/10},A.prototype.plotAreaToAxis=function(t,e){if("tangential"==this.getOptions().position)return t;if(null==t)return null;var i=t+this.getLeftOverflow();return!1===e?i:Math.round(i)},A.prototype.linearToActual=function(t){return this.Info.linearToActual(t)},A.prototype.actualToLinear=function(t){return this.Info.actualToLinear(t)},A.prototype.getValueAt=function(t){return this.Info.getValueAt(this.plotAreaToAxis(t))},A.prototype.getCoordAt=function(t){return this.axisToPlotArea(this.Info.getCoordAt(t))},A.prototype.getBoundedCoordAt=function(t){return this.axisToPlotArea(this.Info.getBoundedCoordAt(t))},A.prototype.getUnboundedValueAt=function(t){return this.Info.getUnboundedValueAt(this.plotAreaToAxis(t))},A.prototype.getUnboundedCoordAt=function(t){return this.axisToPlotArea(this.Info.getUnboundedCoordAt(t))},A.prototype.getBaselineCoord=function(){return this.axisToPlotArea(this.Info.getBaselineCoord())},A.prototype.getPosition=function(){return this.getOptions().position},A.prototype.isGroupAxis=function(){return this.Info instanceof m},A.prototype.getMajorTickCoords=function(){for(var t=this.Info?this.Info.getMajorTickCoords():[],e=0;e<t.length;e++)t[e]=this.axisToPlotArea(t[e]);return t},A.prototype.getMinorTickCoords=function(){for(var t=this.Info?this.Info.getMinorTickCoords():[],e=0;e<t.length;e++)t[e]=this.axisToPlotArea(t[e]);return t},A.prototype.getBaselineCoord=function(){return this.axisToPlotArea(this.Info.getBaselineCoord())},A.prototype.getLinearGlobalMin=function(){return this.actualToLinear(this.Info.getGlobalMin())},A.prototype.getLinearGlobalMax=function(){return this.actualToLinear(this.Info.getGlobalMax())},A.prototype.getLinearViewportMin=function(){return this.actualToLinear(this.Info.getViewportMin())},A.prototype.getLinearViewportMax=function(){return this.actualToLinear(this.Info.getViewportMax())},A.prototype.getUnboundedLinearValueAt=function(t){return this.Info.actualToLinear(this.getUnboundedValueAt(t))},A.prototype.isFullViewport=function(){return this.Info.getViewportMin()==this.Info.getGlobalMin()&&this.Info.getViewportMax()==this.Info.getGlobalMax()},A.prototype.getLeftOverflow=function(){return t.Agent.isRightToLeft(this.getCtx())?this.Info.getEndOverflow():this.Info.getStartOverflow()},A.prototype.getRightOverflow=function(){return t.Agent.isRightToLeft(this.getCtx())?this.Info.getStartOverflow():this.Info.getEndOverflow()},A.prototype.getLength=function(){return Math.abs(this.Info.getStartCoord()-this.Info.getEndCoord())},A.prototype.getMinCoord=function(){return this.axisToPlotArea(Math.min(this.Info.getStartCoord(),this.Info.getEndCoord()))},A.prototype.getMaxCoord=function(){return this.axisToPlotArea(Math.max(this.Info.getStartCoord(),this.Info.getEndCoord()))};var b=function(t,e,i,r,a,n,s){s||this.Init(t.getCtx()),this._bHoriz=at.isHorizontal(t),this._bStacked=at.isStacked(t),this._barGapRatio=et.getBarGapRatio(t),this._dataItemGaps=et.getDataItemGaps(t),this._axisCoord=e,this._doNotRender=!!s,this._setBarCoords(i,r,a,n,!0)};t.Obj.createSubclass(b,x),b._INDICATOR_OFFSET=8,b._MIN_BAR_WIDTH_FOR_GAPS=5,b._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING=15,b._MIN_BAR_LENGTH_FOR_GAPS=5,b._MAX_GAP_SIZE=2,b.prototype.setSelected=function(t){this.IsSelected!=t&&(this.IsSelected=t,this.isSelected()?(this._tempX1=this._x1,this._tempX2=this._x2,this._tempBaselineCoord=this._baselineCoord,this._x1=this._origX1,this._x2=this._origX2,this._baselineCoord=this._origBaselineCoord,this.setPoints(this._createPointsArray()),this._showNestedBorders(this.isHoverEffectShown()?this._hoverColor:this._outerColor,this._innerColor)):(this._x1=this._tempX1,this._x2=this._tempX2,this._baselineCoord=this._tempBaselineCoord,this.setPoints(this._createPointsArray()),this._showNestedBorders(this.isHoverEffectShown()?this._hoverColor:null)))},b.prototype.getAnimationParams=function(t){return t?this._bHoriz?[this._x2,this._x1,this._baselineCoord,this._endCoord]:[this._x1,this._x2,this._endCoord,this._baselineCoord]:[this._baselineCoord,this._endCoord,this._x1,this._x2]},b.prototype.setAnimationParams=function(t,e){if(this._setBarCoords(t[0],t[1],t[2],t[3],!1),e){var i=this.getIndicatorPosition();e.setTranslate(i.x,i.y),e.setAlpha(1),e.getParent().addChild(e)}},b.prototype.getDisplayAnimation=function(e){var i=this.getAnimationParams();this.setAnimationParams([this._axisCoord,this._axisCoord,this._x1,this._x2]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r},b.prototype.getDeleteAnimation=function(e){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r},b.prototype.getInsertAnimation=function(e){this.setAlpha(0);var i=this.getDisplayAnimation(e);return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i},b.prototype.getIndicatorPosition=function(){var e,i,r=(this._x1+this._x2)/2;if(this._bStacked){var a=(this._endCoord+this._baselineCoord)/2;e=this._bHoriz?a:r,i=this._bHoriz?r:a}else{var n=this._endCoord>=this._baselineCoord?this._endCoord+b._INDICATOR_OFFSET:this._endCoord-b._INDICATOR_OFFSET;e=this._bHoriz?n:r,i=this._bHoriz?r:n}return new t.Point(e,i)},b.prototype._setBarCoords=function(e,i,r,a,n){this._baselineCoord=e,this._endCoord=i,this._x1=r,this._x2=a;var s=this._x2-this._x1;if(s<1&&(this._x1=Math.floor(this._x1),this._x2=this._x1+1,s=1),this._origX1=this._x1,this._origX2=this._x2,this._origBaselineCoord=this._baselineCoord,this._origSize=this._x2-this._x1,this._dataItemGaps>0&&n&&!this.isSelected()){var o=Math.ceil(b._MAX_GAP_SIZE*this._dataItemGaps),l=Math.abs(this._baselineCoord-this._endCoord),h=this._axisCoord==this._baselineCoord;l>=b._MIN_BAR_LENGTH_FOR_GAPS&&this._bStacked&&!h&&(this._baselineCoord+=this._endCoord>this._baselineCoord?o:-o),s>=b._MIN_BAR_WIDTH_FOR_GAPS&&(1==t.Agent.getDevicePixelRatio()&&this._barGapRatio>0&&s>b._MIN_BAR_WIDTH_FOR_GAPS_PIXEL_HINTING?("firefox"===t.Agent.browser||this._doNotRender||this.setPixelHinting(!0),this._x1=Math.round(this._x1),this._x2=Math.round(this._x2),this._origX1=this._x1,this._origX2=this._x2,this._x2-=o):(this._x1+=o/2,this._x2-=o/2),this._origSize-=o)}if(!this._doNotRender){var u=this._createPointsArray();this.setPoints(u),this.OuterChild&&this.OuterChild.setPoints(this._createPointsArray(x.OUTER_BORDER_WIDTH)),this.InnerChild&&this.InnerChild.setPoints(this._createPointsArray(x.OUTER_BORDER_WIDTH+x.INNER_BORDER_WIDTH))}},b.prototype._createPointsArray=function(t){var e=this._baselineCoord,i=this._endCoord,r=this._x1,a=this._x2;if(t>0){if(Math.abs(r-a)<2*t||Math.abs(e-i)<2*t)return[];r+=t,a-=t,i<e?(e-=t,i+=t):(e+=t,i-=t)}return this._bHoriz?[i,r,i,a,e,a,e,r]:[r,i,a,i,a,e,r,e]},b.prototype.getBoundingBox=function(){var e=Math.min(this._x2,this._x1),i=Math.min(this._endCoord,this._baselineCoord),r=Math.abs(this._x2-this._x1),a=Math.abs(this._endCoord-this._baselineCoord);return this._bHoriz?new t.Rectangle(i,e,a,r):new t.Rectangle(e,i,r,a)},b.prototype.getOriginalBarSize=function(){return this._origSize},b.prototype.getDimensionsSelf=function(t){return this.ConvertCoordSpaceRect(this.getBoundingBox(),t)};var M=function(e,i,r,a,n,s,o,l,h){this.Init(e.getCtx()),this._chart=e,this._bHoriz=at.isHorizontal(e),this._styleOptions=h,this._innerColor=et.getSelectedInnerColor(this._chart),this._outerColor=et.getSelectedOuterColor(this._chart),this._hoverColor=t.SelectionEffectUtils.getHoverBorderColor(this._styleOptions._color);var u=i-r/2,g=i+r/2;et.getDataItemGaps(e)>0&&r>b._MIN_BAR_WIDTH_FOR_GAPS&&g--,this._render(u,g,a,n,s,o,l)};t.Obj.createSubclass(M,t.Shape),M.prototype._render=function(e,i,r,a,n,s,o){this._cleanUp();var l=this.getCtx();this._x1=Math.round(e),this._x2=Math.round(i),this._low=Math.round(r),this._q1=Math.round(a),this._q2=Math.round(n),this._q3=Math.round(s),this._high=Math.round(o);var h=i-e,u=et.getSizeInPixels(this._styleOptions.whiskerEndLength,h);u=Math.min(h,u),u=2*Math.floor((u-1)/2)+1;var g=Math.floor((e+i)/2)+.5,d=g-Math.floor(u/2)-.5,c=g+Math.floor(u/2)+.5;this._drawLine(g,this._low,g,this._high,"whisker"),this._drawLine(d,this._low,c,this._low,"whiskerEnd"),this._drawLine(d,this._high,c,this._high,"whiskerEnd"),this._q2Box=new t.Polygon(l,this._createQ2PointsArray(0));var p=tt.getRectangleFill(this._chart,this._styleOptions.q2Color,this._styleOptions._q2Pattern,h);this._q2Box.setFill(p),this._applyCustomStyle(this._q2Box,"q2"),this.addChild(this._q2Box),this._q3Box=new t.Polygon(l,this._createQ3PointsArray(0));var _=tt.getRectangleFill(this._chart,this._styleOptions.q3Color,this._styleOptions._q3Pattern,h);this._q3Box.setFill(_),this._applyCustomStyle(this._q3Box,"q3"),this.addChild(this._q3Box),this._drawMedianLine(0),this._borderColor=this._styleOptions.borderColor,this._borderColor&&(this._borderWidth=this._styleOptions.borderWidth,this._drawBorders(this._borderColor,this._borderWidth)),this.IsSelected&&(this.IsSelected=!1,this.setSelected(!0))},M.prototype.showHoverEffect=function(){this.IsShowingHoverEffect||(this.IsShowingHoverEffect=!0,this.isSelected()?this._drawBorders(this._hoverColor,x.OUTER_BORDER_WIDTH,this._innerColor,x.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,x.OUTER_BORDER_WIDTH_HOVER,this._innerColor,x.INNER_BORDER_WIDTH))},M.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect&&(this.IsShowingHoverEffect=!1,this.isSelected()?this._drawBorders(this._outerColor,x.OUTER_BORDER_WIDTH,this._innerColor,x.INNER_BORDER_WIDTH):this._drawBorders(this._borderColor,this._borderWidth))},M.prototype.setSelected=function(t){this.IsSelected!=t&&(this.IsSelected=t,this.isHoverEffectShown()?t?this._drawBorders(this._hoverColor,x.OUTER_BORDER_WIDTH,this._innerColor,x.INNER_BORDER_WIDTH):this._drawBorders(this._hoverColor,x.OUTER_BORDER_WIDTH_HOVER,this._innerColor,x.INNER_BORDER_WIDTH):t?this._drawBorders(this._outerColor,x.OUTER_BORDER_WIDTH,this._innerColor,x.INNER_BORDER_WIDTH):this._drawBorders(this._borderColor,this._borderWidth))},M.prototype.UpdateSelectionEffect=function(){},M.prototype.getDisplayAnimation=function(t){return this.getInsertAnimation(t)},M.prototype.getDeleteAnimation=function(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=[this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2];return i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,r),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i},M.prototype.getInsertAnimation=function(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=this._getAnimationParams();return this._setAnimationParams([this._x1,this._x2,this._q2,this._q2,this._q2,this._q2,this._q2]),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,r),this.setAlpha(0),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i},M.prototype.getUpdateAnimation=function(e,i){var r=new t.CustomAnimation(this.getCtx(),this,e),a=i._getQ2Fill(),n=this._getQ2Fill();a.equals(n)||(this._setQ2Fill(a),r.getAnimator().addProp(t.Animator.TYPE_FILL,this,this._getQ2Fill,this._setQ2Fill,n));var s=i._getQ3Fill(),o=this._getQ3Fill();s.equals(o)||(this._setQ3Fill(s),r.getAnimator().addProp(t.Animator.TYPE_FILL,this,this._getQ3Fill,this._setQ3Fill,o));var l=this._getAnimationParams();return this._setAnimationParams(i._getAnimationParams()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,l),r},M.prototype._getAnimationParams=function(){return[this._x1,this._x2,this._low,this._q1,this._q2,this._q3,this._high]},M.prototype._setAnimationParams=function(t){this._render(t[0],t[1],t[2],t[3],t[4],t[5],t[6])},M.prototype._getQ2Fill=function(){return new t.SolidFill(this._styleOptions.q2Color)},M.prototype._setQ2Fill=function(t){this._styleOptions.q2Color=t.getColor()},M.prototype._getQ3Fill=function(){return new t.SolidFill(this._styleOptions.q3Color)},M.prototype._setQ3Fill=function(t){this._styleOptions.q3Color=t.getColor()},M.prototype._drawLine=function(e,i,r,a,n){var s=this._bHoriz?new t.Line(this.getCtx(),i,e,a,r):new t.Line(this.getCtx(),e,i,r,a);return this._applyCustomStyle(s,n),s.setPixelHinting(!0),this.addChild(s),s},M.prototype._drawMedianLine=function(e){if(!this._medianLine){var i=new t.Line(this.getCtx(),0,0,0,0);this._applyCustomStyle(i,"median"),i.setPixelHinting(!0),this.addChild(i),this._medianLine=i}var r=this._x1+e,a=this._x2-e,n=this._q2;this._bHoriz?(this._medianLine.setX1(n),this._medianLine.setX2(n),this._medianLine.setY1(r),this._medianLine.setY2(a)):(this._medianLine.setY1(n),this._medianLine.setY2(n),this._medianLine.setX1(r),this._medianLine.setX2(a))},M.prototype._drawBorders=function(e,i,r,a){if(!this._outerBorderShape){var n=this.getChildIndex(this._q2Box);this._innerBorderShape=new t.Polygon(this.getCtx()),this._innerBorderShape.setInvisibleFill(),this.addChildAt(this._innerBorderShape,n),this._outerBorderShape=new t.Polygon(this.getCtx()),this._outerBorderShape.setInvisibleFill(),this.addChildAt(this._outerBorderShape,n)}var s=0;i?(this._outerBorderShape.setPoints(this._createBoxPointsArray(0)),this._outerBorderShape.setSolidFill(e),s+=i,a?(this._innerBorderShape.setPoints(this._createBoxPointsArray(i)),this._innerBorderShape.setSolidFill(r),s+=a):this._innerBorderShape.setInvisibleFill()):(this._outerBorderShape.setInvisibleFill(),this._innerBorderShape.setInvisibleFill()),this._q2Box.setPoints(this._createQ2PointsArray(s)),this._q3Box.setPoints(this._createQ3PointsArray(s)),this._drawMedianLine(s)},M.prototype._createBoxPointsArray=function(t){var e,i,r=this._x1+t,a=this._x2-t;return this._q1<this._q3?(e=this._q1+t,i=this._q3-t):(e=this._q1-t,i=this._q3+t),this._createPointsArray(r,a,e,i)},M.prototype._createQ3PointsArray=function(t){var e,i=this._x1+t,r=this._x2-t,a=this._q2;return e=this._q2<this._q3?this._q3-t:this._q3+t,this._createPointsArray(i,r,a,e)},M.prototype._createQ2PointsArray=function(t){var e,i=this._x1+t,r=this._x2-t,a=this._q2;return e=this._q2<this._q1?this._q1-t:this._q1+t,this._createPointsArray(i,r,e,a)},M.prototype._createPointsArray=function(t,e,i,r){return this._bHoriz?[i,t,i,e,r,e,r,t]:[t,i,e,i,e,r,t,r]},M.prototype._applyCustomStyle=function(t,e){t.setStyle(this._styleOptions[e+"Style"]||this._styleOptions[e+"SvgStyle"],!0),t.setClassName(this._styleOptions[e+"ClassName"]||this._styleOptions[e+"SvgClassName"],!0)},M.prototype._cleanUp=function(){this.removeChildren(),this._q2Box=null,this._q3Box=null,this._medianLine=null,this._outerBorderShape=null,this._innerBorderShape=null};var T=function(t,e,i,r,a,n,s){this.Init(t),i=Math.max(2*Math.round(i/2),1);var o=Math.min(2*Math.ceil(T._BAR_WIDTH*i/2),i),l=Math.round(e)-i/2,h=l+i;if(null!=n&&null!=s){var u=Math.round(e)-o/2,g=u+o;this._rangeShape=new x(t,[u,n,g,n,g,s,u,s]),this.addChild(this._rangeShape)}this._changeShape=new x(t,[l,r,h,r,h,a,l,a]),this.addChild(this._changeShape),this.setPixelHinting(!0)};t.Obj.createSubclass(T,t.Container),T._BAR_WIDTH=.3,T.prototype.setChangeStyle=function(t,e,i,r,a){this._changeShape.setStyleProperties(t,e,i,r,a)},T.prototype.setRangeStyle=function(t,e,i,r){this._rangeShape&&this._rangeShape.setStyleProperties(t,e,i,null,r)},T.prototype.setSelected=function(t){this._changeShape.setSelected(t),this._rangeShape&&this._rangeShape.setSelected(t)},T.prototype.showHoverEffect=function(){this._changeShape.showHoverEffect(),this._rangeShape&&this._rangeShape.showHoverEffect()},T.prototype.hideHoverEffect=function(){this._changeShape.hideHoverEffect(),this._rangeShape&&this._rangeShape.hideHoverEffect()},T.prototype.getDisplayAnimation=function(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=this._changeShape.getPoints();if(this._changeShape.setPoints(T._getInitialPoints(r)),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimationParams,r),this._rangeShape){var a=this._rangeShape.getPoints();this._rangeShape.setPoints(T._getInitialPoints(a)),i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimationParams,a)}return i},T.prototype.getDeleteAnimation=function(e){var i=new t.CustomAnimation(this.getCtx(),this,e),r=T._getInitialPoints(this._changeShape.getPoints());if(i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimationParams,r),this._rangeShape){var a=T._getInitialPoints(this._rangeShape.getPoints());i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimationParams,a)}return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),i},T.prototype.getInsertAnimation=function(e){this.setAlpha(0);var i=this.getDisplayAnimation(e);return i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),i},T.prototype.getUpdateAnimation=function(e,i){var r=new t.CustomAnimation(this.getCtx(),this,e),a=this._changeShape.getPoints();this._changeShape.setPoints(i._changeShape.getPoints()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._changeShape,this._changeShape.getPoints,this._changeShape.setAnimationParams,a);var n=i._changeShape.getPrimaryFill(),s=this._changeShape.getPrimaryFill();if(i._changeShape.isSelected()||this._changeShape.isSelected()||n.equals(s)||(this._changeShape.setFill(n),r.getAnimator().addProp(t.Animator.TYPE_FILL,this._changeShape,this._changeShape.getFill,this._changeShape.setFill,s)),this._rangeShape&&i._rangeShape){var o=this._rangeShape.getPoints();this._rangeShape.setPoints(i._rangeShape.getPoints()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._rangeShape,this._rangeShape.getPoints,this._rangeShape.setAnimationParams,o)}return r},T.prototype.UpdateSelectionEffect=function(){},T._getInitialPoints=function(t){var e=t[0],i=t[2],r=(t[1]+t[5])/2;return[e,r,i,r,i,r,e,r]};var I=function(t,e,i,r,a,n){this.x=t,this.y1=e,this.y2=i,this.groupIndex=r,this.group=a,this.filtered=n};t.Obj.createSubclass(I,t.Obj),I.prototype.isUpstep=function(t){return Math.abs(this.y2-t)>Math.abs(this.y1-t)},I.prototype.clone=function(){return new I(this.x,this.y1,this.y2,this.groupIndex,this.group,this.filtered)};var O=function(t,e,i,r,a,n,s,o,l,h,u,g){this.Init(t.getCtx()),this._chart=t,this._bArea=e,this._availSpace=i,this._baseline=r,this._style=a,this._className=n,this._fill=s,this._stroke=o,this._type=l,this._baseType=u||l,this._indicatorMap={},this.setCoords(h,g)};t.Obj.createSubclass(O,t.Container),O._INDICATOR_OFFSET=8,O.prototype.setCoords=function(t,e){this._arCoord=t,e&&(this._arBaseCoord=e),this.removeChildren(),this._bArea?this._renderAreas():this._renderLines(),this._positionIndicators()},O.prototype.getCoords=function(){return this._arCoord},O.prototype.getBaseCoords=function(){return this._arBaseCoord},O.prototype.getBaseline=function(){return this._baseline},O.prototype.isArea=function(){return this._bArea},O.prototype._getPointArrays=function(e,i){var r=[],a=[];r.push(a),e=O._convertToPointCoords(e);var n,s,o,l,h,u=at.isPolar(this._chart),g="centeredStepped"==i||"centeredSegmented"==i,d=g||"stepped"==i||"segmented"==i,c=et.getGroupWidth(this._chart),p=t.Agent.isRightToLeft(this.getCtx())&&at.isVertical(this._chart)?-1:1;u&&(n=e[e.length-1]);for(var _=!1,f=0;f<e.length;f++)null!=e[f]?(s=e[f],l=e[f]._isY2,o=g?s.x-c/2*p:s.x,l&&(_&&d&&(o+=c*p),_=!_),"curved"==i&&l&&a.push(null,null),n&&d&&this._pushCoord(a,o,n.y),this._bArea||"segmented"!=i&&"centeredSegmented"!=i||(a=[],r.push(a)),this._pushCoord(a,o,s.y),n=s):(q.isMixedFrequency(this._chart)||d&&!u&&n&&!l&&(h=g?n.x+.5*c*p:n.x+c*p,this._pushCoord(a,h,n.y)),"jet"!=this._chart.getOptions()._environment&&q.isMixedFrequency(this._chart)||(a=[],r.push(a),n=null));if(d&&!u&&n&&!l&&(h=g?n.x+.5*c*p:n.x+c*p,this._pushCoord(a,h,n.y)),u&&r.length>1){var v=r.pop();r[0]=v.concat(r[0])}return r},O.prototype._pushCoord=function(e,i,r){var a=ct.convertAxisCoord(this._chart,new t.Point(i,r),this._availSpace);e.push(Math.round(10*a.x)/10,Math.round(10*a.y)/10)},O.prototype._isRing=function(){if(!at.isPolar(this._chart)||!q.hasGroupAxis(this._chart)||this._arCoord.length<Q.getGroupCount(this._chart))return!1;for(var t=0;t<this._arCoord.length;t++)if(null==this._arCoord[t].x)return!1;return!0},O.prototype._getSplineType=function(){return at.isScatterBubble(this._chart)?t.PathUtils.SPLINE_TYPE_CARDINAL:at.isPolar(this._chart)?this._isRing()?t.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED:t.PathUtils.SPLINE_TYPE_CARDINAL:at.isHorizontal(this._chart)?t.PathUtils.SPLINE_TYPE_MONOTONE_HORIZONTAL:t.PathUtils.SPLINE_TYPE_MONOTONE_VERTICAL},O.prototype._renderLines=function(){for(var e,i=this._getPointArrays(this._arCoord,this._type),r=0;r<i.length;r++){var a=i[r];if(a&&a.length>1){if("curved"==this._type){var n=O._getCurvedPathCommands(a,!1,this._getSplineType());(e=new t.Path(this.getCtx(),n)).setFill(null)}else this._isRing()?(e=new t.Polygon(this.getCtx(),a)).setFill(null):e=new t.Polyline(this.getCtx(),a);e.setStroke(this._stroke),e.setClassName(this._className).setStyle(this._style),this.addChild(e)}}},O.prototype._renderAreas=function(){var e=this._arCoord,i=this._arBaseCoord;!at.isPolar(this._chart)&&e.length>0&&i.length>0&&(e=e.slice(0),i=i.slice(0),null!=e[0].x&&null!=i[0].x&&(O._removeAreaEdge(e,0,this._baseline),O._removeAreaEdge(i,0,this._baseline),i[0].x=e[0].x),null!=e[e.length-1].x&&null!=i[i.length-1].x&&(O._removeAreaEdge(e,e.length-1,this._baseline),O._removeAreaEdge(i,i.length-1,this._baseline),i[i.length-1].x=e[e.length-1].x));var r=this._getPointArrays(e,this._type),a=this._getPointArrays(i,this._baseType);if(r.length==a.length)for(var n,s=0;s<r.length;s++){var o=r[s],l=a[s];if(!(o.length<2)){var h="curved"==this._type,u="curved"==this._baseType;this._isRing()&&(h||o.push(o[0],o[1]),l.length>=2&&!u&&l.push(l[0],l[1]));for(var g=[],d=0;d<l.length;d+=2)g.unshift(l[d],l[d+1]);if(h||u){var c=this._getSplineType(),p=h?O._getCurvedPathCommands(o,!1,c):t.PathUtils.polyline(o,!1);p+=u?O._getCurvedPathCommands(g,!0,c):t.PathUtils.polyline(g,!0),p+=t.PathUtils.closePath(),n=new t.Path(this.getCtx(),p)}else{var _=g.concat(o);n=new t.Polygon(this.getCtx(),_)}n.setFill(this._fill),n.setClassName(this._className).setStyle(this._style),this._stroke&&n.setStroke(this._stroke),this.addChild(n)}}},O.prototype._positionIndicators=function(){for(var e,i,r,a,n,s=0;s<this._arCoord.length;s++)n=this._arCoord[s],(e=this._indicatorMap[n.groupIndex])&&e.indicator&&(a=(n.isUpstep(this._baseline)?n.y2:n.y1)+O._INDICATOR_OFFSET*(e.direction==X.DIR_UP?-1:1),r=ct.convertAxisCoord(this._chart,new t.Point(n.x,a),this._availSpace),(i=e.indicator).setTranslate(r.x,r.y),i.setAlpha(1),i.getParent().addChild(i))},O.prototype.getAnimationParams=function(t){return O._coordsToAnimationParams(this._arCoord,t?t._arCoord:null,this._baseline)},O.prototype.setAnimationParams=function(t){var e=O._animationParamsToCoords(t);this.setCoords(e)},O.prototype.getBaseAnimationParams=function(t){return O._coordsToAnimationParams(this._arBaseCoord,t?t._arBaseCoord:null,this._baseline)},O.prototype.setBaseAnimationParams=function(t){this._arBaseCoord=O._animationParamsToCoords(t)},O.prototype.getCommonGroupIndices=function(t){for(var e=[],i=0;i<this._arCoord.length;i++)if(!this._arCoord[i].filtered&&null!=this._arCoord[i].x)for(var r=0;r<t._arCoord.length;r++)if(!t._arCoord[r].filtered&&null!=t._arCoord[r].x&&this._arCoord[i].group==t._arCoord[r].group){e.push(this._arCoord[i].groupIndex);break}return e},O.prototype.addIndicator=function(t,e,i){i.setAlpha(0),this._indicatorMap[t]={direction:e,indicator:i}},O.prototype.removeIndicators=function(){for(var t in this._indicatorMap){var e=this._indicatorMap[t].indicator;e&&e.getParent().removeChild(e)}this._indicatorMap={}},O._convertToPointCoords=function(e){for(var i=[],r=0;r<e.length;r++)if(!e[r].filtered)if(null==e[r].x)i.push(null);else if(i.push(new t.Point(e[r].x,e[r].y1)),e[r].y1!=e[r].y2){var a=new t.Point(e[r].x,e[r].y2);a._isY2=!0,i.push(a)}return i},O._coordsToAnimationParams=function(t,e,i){if(e&&e.length>0)if(t&&t.length>0){t=t.slice(0);for(var r,a,n,s=O._coordsToGroups(e),o=O._coordsToGroups(t),l=t.length,h=s.length-1;h>=0;h--)r=s[h],-1==(a=o.indexOf(r))?(0==l?(n=t[0].clone(),t[0]=t[0].clone(),O._removeCoordJump(n,t[0],i)):(n=t[l-1].clone(),t[l-1]=t[l-1].clone(),O._removeCoordJump(t[l-1],n,i)),n.groupIndex=-1,t.splice(l,0,n)):l=a}else{t=[];for(h=0;h<e.length;h++)t.push(new I(e[h].x,i,i))}for(var u=[],g=0;g<t.length;g++)t[g].filtered||(null==t[g].x?(u.push(1/0),u.push(1/0),u.push(1/0)):(u.push(t[g].x),u.push(t[g].y1),u.push(t[g].y2)),u.push(t[g].groupIndex));return u},O._animationParamsToCoords=function(t){for(var e=[],i=0;i<t.length;i+=4)t[i]==1/0||isNaN(t[i])?e.push(new I(null,null,null,t[i+3])):e.push(new I(t[i],t[i+1],t[i+2],t[i+3]));return e},O._coordsToGroups=function(t){for(var e=[],i=0;i<t.length;i++)t[i].filtered||e.push(t[i].group);return e},O._removeCoordJump=function(t,e,i){t.isUpstep(i)?e.y1=e.y2:t.y2=t.y1},O._getCurvedPathCommands=function(e,i,r){var a=[],n=[];a.push(n);for(var s=0;s<e.length;s+=2)null==e[s]?(n=[],a.push(n)):n.push(e[s],e[s+1]);if(r==t.PathUtils.SPLINE_TYPE_CARDINAL_CLOSED&&a.length>1){var o=a.pop();a[0]=o.concat(a[0]),r=t.PathUtils.SPLINE_TYPE_CARDINAL}var l="";for(s=0;s<a.length;s++)n=a[s],l+=t.PathUtils.curveThroughPoints(n,i,r),i=!0;return l},O._removeAreaEdge=function(t,e,i){var r=t[e].clone();r.isUpstep(i)?r.y1=r.y2:r.y2=r.y1,t[e]=r};var D=function(t,e,i,r,a,n){this.Init(t,e,i,r,a,a,null,null,!0),n&&this.setStroke(D.DEFAULT_STROKE)};t.Obj.createSubclass(D,t.SimpleMarker),D.DEFAULT_STROKE=new t.Stroke("none"),D.SELECTED_FILL=new t.SolidFill("#FFFFFF"),D.SELECTED_STROKE=new t.Stroke("#5A5A5A",1,1.5),D.prototype.setDataColor=function(e){this._dataColor=e,this._hoverStroke=new t.Stroke(e,1,1.5)},D.prototype.getDataColor=function(){return this._dataColor},D.prototype.showHoverEffect=function(){this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)},D.prototype.hideHoverEffect=function(){this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?D.SELECTED_STROKE:D.DEFAULT_STROKE)},D.prototype.setSelected=function(t){this.IsSelected!=t&&(this.IsSelected=t,this.isSelected()?(this.setFill(D.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.DEFAULT_STROKE)))},D.prototype.UpdateSelectionEffect=function(){};var E=function(t){this.Init(t.getCtx(),t.processEvent,t),this._parentChart=t,this._chart=t.overview?t.overview.getBackgroundChart():null,this._id=t.getId()+"_overview"};t.Obj.createSubclass(E,t.Overview),E.prototype._renderChart=function(e,i,r){this._chartContainer=new t.Container(this.getCtx()),this.addChild(this._chartContainer);e=t.JsonUtils.merge({legend:{rendered:"off",size:null},xAxis:{viewportMin:null,viewportMax:null,viewportStartGroup:null,viewportEndGroup:null,axisLine:{rendered:"off"},size:null,maxSize:.5,title:null},yAxis:{rendered:"off",size:null},y2Axis:{rendered:"off",size:null},splitDualY:"off",title:{text:null},subtitle:{text:null},footnote:{text:null},titleSeparator:{rendered:"off"},styleDefaults:{animationIndicators:"none"},layout:{outerGapWidth:0,outerGapHeight:0},_isOverview:!0},e),q.hasGroupAxis(this._parentChart)&&(e.xAxis.tickLabel.rendered="off"),at.isStock(this._parentChart)&&e.series&&e.series[0]&&(e.series=[e.series[0]],e.series[0].type="lineWithArea");var a=this._parentChart.getOptions().overview.content,n="on"===(e=t.JsonUtils.merge(a,e)).yAxis.rendered,s="on"===e.y2Axis.rendered;e.zoomAndScroll="off",this._chart||(this._chart=t.Chart.newInstance(this.getCtx()),this._chart.setId(this._id));var o=i,l=this._parentChart.__getPlotAreaSpace().x;n&&(o=l+i,e.yAxis.size=l),s&&(o=this._parentChart.getWidth()-(n?0:l),e.y2Axis.size=this._parentChart.getWidth()-(l+i)),this._chartContainer.addChild(this._chart),this._chart.render(e,o,r);var h=new t.Rect(this.getCtx(),0,0,o,r);h.setInvisibleFill(),this._chartContainer.addChild(h),this._chart.getEventManager().setKeyboardHandler(null);var u=this._chart.__getPlotAreaSpace();if(n){var g=this._chartContainer.getTranslateX()-u.x;this._chartContainer.setTranslateX(g)}return new t.Dimension(i,u.h+u.y)},E.prototype.render=function(t,e,i){t.style={overviewBackgroundColor:"rgba(0,0,0,0)",windowBackgroundColor:"rgba(0,0,0,0)",windowBorderTopColor:"#333333",windowBorderRightColor:"#333333",windowBorderBottomColor:"#333333",windowBorderLeftColor:"#333333",leftFilterPanelColor:"rgba(5,65,135,0.1)",rightFilterPanelColor:"rgba(5,65,135,0.1)",handleBackgroundImage:t.chart._resources.overviewGrippy,handleWidth:3,handleHeight:15,handleFillColor:"rgba(0,0,0,0)"},t.animationOnClick="off";var r=this._renderChart(t.chart,e,i);E.superclass.render.call(this,t,r.w,r.h)},E.prototype.destroy=function(){E.superclass.destroy.call(this),this._parentChart=null,this._chart=null},E.prototype.getBackgroundChart=function(){return this._chart},E.prototype.isBackgroundRendered=function(){return!1},E.prototype.isLeftAndRightFilterRendered=function(){return!0},E.prototype.HandleKeyDown=function(t){},E.prototype.HandleKeyUp=function(t){};var P=function(t,e,i,r,a,n,s){this.Init(t.getCtx()),this._axisCoord=e,this._availSpace=s.clone(),this._bbox=null,this._dataItemGaps=et.getDataItemGaps(t)*P._MAX_DATA_ITEM_GAP,this._setBarCoords(i,r,a,n)};t.Obj.createSubclass(P,y),P._MIN_BAR_LENGTH_FOR_GAPS=4,P._MAX_DATA_ITEM_GAP=3,P.prototype.getAnimationParams=function(){return[this._baselineCoord,this._endCoord,this._x1,this._x2]},P.prototype.setAnimationParams=function(t,e){this._setBarCoords(t[0],t[1],t[2],t[3])},P.prototype.getPrimaryFill=function(){return this.getFill()},P.prototype.getDisplayAnimation=function(e){var i=this.getAnimationParams();this.setAnimationParams([this._axisCoord,this._axisCoord,0,0]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r},P.prototype.getDeleteAnimation=function(e){var i=[this._baselineCoord,this._baselineCoord,this._x1,this._x2],r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,0),r},P.prototype.getInsertAnimation=function(e){this.setAlpha(0);var i=this.getAnimationParams();this.setAnimationParams([this._baselineCoord,this._baselineCoord,this._x1,this._x2]);var r=new t.CustomAnimation(this.getCtx(),this,e);return r.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.getAnimationParams,this.setAnimationParams,i),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getAlpha,this.setAlpha,1),r},P.prototype._setBarCoords=function(e,i,r,a){var n=this._availSpace.x+this._availSpace.w/2,s=this._availSpace.y+this._availSpace.h/2,o=Math.max(i,e),l=Math.abs(i-e)>=P._MIN_BAR_LENGTH_FOR_GAPS&&this._axisCoord!=e?Math.min(i,e)+this._dataItemGaps:Math.min(i,e),h=360-t.Math.radsToDegrees(Math.max(r,a))+90,u=t.Math.radsToDegrees(Math.abs(a-r));this.setWedgeParams(n,s,o,o,h,u,this._dataItemGaps,l);var g=ct.polarToCartesian(e,r,this._availSpace),d=ct.polarToCartesian(e,a,this._availSpace),c=ct.polarToCartesian(i,r,this._availSpace),p=ct.polarToCartesian(i,a,this._availSpace),_=Math.min(g.x,d.x,c.x,p.x),f=Math.max(g.x,d.x,c.x,p.x),v=Math.min(g.y,d.y,c.y,p.y),m=Math.max(g.y,d.y,c.y,p.y);this._bbox=new t.Rectangle(_,v,f-_,m-v),this._baselineCoord=e,this._endCoord=i,this._x1=r,this._x2=a},P.prototype.getBoundingBox=function(){return this._bbox},P.prototype.getOriginalBarSize=function(){return this._bbox.w};var L=function(t,e,i,r,a,n,s){this.Init(t),this._markerSize=n,this._isInvisible=s,this._drawPath(e,i,r,a)};t.Obj.createSubclass(L,t.Path),L.prototype._drawPath=function(e,i,r,a){var n=Math.atan2(a-i,r-e),s=this._markerSize/2,o=Math.PI/8,l=t.PathUtils.moveTo(e+s*Math.cos(n+o),i+s*Math.sin(n+o))+t.PathUtils.arcTo(s,s,2*(Math.PI-o),1,e+s*Math.cos(n-o),i+s*Math.sin(n-o))+t.PathUtils.lineTo(r-s*Math.cos(n+o),a-s*Math.sin(n+o))+t.PathUtils.arcTo(s,s,2*(Math.PI-o),1,r-s*Math.cos(n-o),a-s*Math.sin(n-o))+t.PathUtils.closePath();this.setCmds(l),this._x1=e,this._y1=i,this._x2=r,this._y2=a},L.prototype.setStyleProperties=function(e,i,r,a,n){this._dataColor=r;var s=t.SelectionEffectUtils.getHoverBorderColor(r);this._isInvisible?(this.setInvisibleFill(),this._hoverStroke=new t.Stroke(s,1,1.5)):(this.setFill(e),this.setStroke(i),this.setHoverStroke(new t.Stroke(a,1,1),new t.Stroke(s,1,3.5)),this.setSelectedStroke(new t.Stroke(a,1,1.5),new t.Stroke(n,1,4.5)),this.setSelectedHoverStroke(new t.Stroke(a,1,1.5),new t.Stroke(s,1,4.5)))},L.prototype.getDataColor=function(){return this._dataColor},L.prototype.showHoverEffect=function(){this._isInvisible?(this.IsShowingHoverEffect=!0,this.setStroke(this._hoverStroke)):L.superclass.showHoverEffect.call(this)},L.prototype.hideHoverEffect=function(){this._isInvisible?(this.IsShowingHoverEffect=!1,this.setStroke(this.isSelected()?D.SELECTED_STROKE:D.DEFAULT_STROKE)):L.superclass.hideHoverEffect.call(this)},L.prototype.setSelected=function(t){if(this._isInvisible){if(this.IsSelected==t)return;this.IsSelected=t,this.isSelected()?(this.setFill(D.SELECTED_FILL),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.SELECTED_STROKE)):(this.setInvisibleFill(),this.setStroke(this.isHoverEffectShown()?this._hoverStroke:D.DEFAULT_STROKE))}else L.superclass.setSelected.call(this,t)},L.prototype.UpdateSelectionEffect=function(){this._isInvisible||L.superclass.UpdateSelectionEffect.call(this)},L.prototype.getAnimationParams=function(){return[this._x1,this._y1,this._x2,this._y2]},L.prototype.setAnimationParams=function(t){this._drawPath(t[0],t[1],t[2],t[3])},L.prototype.isInvisible=function(){return this._isInvisible},L.prototype.getBoundingBox=function(){return this.getBoundingBox1().getUnion(this.getBoundingBox2())},L.prototype.getBoundingBox1=function(){return new t.Rectangle(this._x1-this._markerSize/2,this._y1-this._markerSize/2,this._markerSize,this._markerSize)},L.prototype.getBoundingBox2=function(){return new t.Rectangle(this._x2-this._markerSize/2,this._y2-this._markerSize/2,this._markerSize,this._markerSize)};var w=function(t,e,i){this.Init(t,e,i)};t.Obj.createSubclass(w,t.Container),w.BEHAVIOR_SNAP="SNAP",w.BEHAVIOR_SMOOTH="SMOOTH",w.BEHAVIOR_AUTO="AUTO",w.TOOLTIP_ID="_dvtDataCursor",w.prototype.Init=function(e,i,r){w.superclass.Init.call(this,e),this._bHoriz=r,this._options=i,this.setMouseEnabled(!1),this.setVisible(!1);var a=i.lineWidth,n=i.lineColor,s=new t.Stroke(n,1,a,!1,t.Stroke.getDefaultDashProps(i.lineStyle,a));if(this._cursorLine=new t.Line(this.getCtx(),0,0,0,0,"dcLine"),this._cursorLine.setStroke(s),this.addChild(this._cursorLine),"off"!=i.markerDisplayed){this._marker=new t.Container(this._context),this._marker.setMouseEnabled(!1),this.addChild(this._marker);var o=i.markerSize,l=new t.SimpleMarker(this._context,t.SimpleMarker.CIRCLE,0,0,o+4*a,o+4*a);l.setSolidFill(n),this._marker.addChild(l);var h=new t.SimpleMarker(this._context,t.SimpleMarker.CIRCLE,0,0,o+2*a,o+2*a);h.setSolidFill("white"),this._marker.addChild(h),this._markerInnerCircle=new t.SimpleMarker(this._context,t.SimpleMarker.CIRCLE,0,0,o,o),this._marker.addChild(this._markerInnerCircle)}},w.prototype.render=function(e,i,r,a,n,s){var o,l=this.isHorizontal(),h=t.Agent.isRightToLeft(this.getCtx());if(null!=n&&""!=n){var u=this.getCtx().getStageAbsolutePosition(),g=this.getCtx().getTooltipManager(w.TOOLTIP_ID);g.showDatatip(i+u.x,r+u.y,n,s,!1),o=g.getTooltipBounds();var d,c,p=this._options.markerSize+4*this._options.lineWidth;l?(d=h?e.x-.75*o.w:e.x+e.w-o.w/4,c=a-o.h/2,!h&&d-i<p?d=i+p:h&&i-(d+o.w)<p&&(d=i-p-o.w)):(d=a-o.w/2,r-((c=e.y-.75*o.h)+o.h)<p&&(c=r-p-o.h)),g.positionTip(d+u.x,c+u.y),(o=g.getTooltipBounds()).x-=u.x,o.y-=u.y}if(l?(this._cursorLine.setTranslateY(a),h?(this._cursorLine.setX1(o?o.x+o.w-1:e.x),this._cursorLine.setX2(e.x+e.w)):(this._cursorLine.setX1(e.x),this._cursorLine.setX2(o?o.x+1:e.x+e.w))):(this._cursorLine.setTranslateX(a),this._cursorLine.setY1(o?o.y+o.h-1:e.y),this._cursorLine.setY2(e.y+e.h)),this._marker){this._marker.setTranslate(i,r);var _=this._options.markerColor;this._markerInnerCircle.setSolidFill(_||s),t.Agent.workaroundFirefoxRepaint(this._marker)}},w.prototype.isHorizontal=function(){return this._bHoriz},w.prototype.getBehavior=function(){return this._behavior?this._behavior:w.BEHAVIOR_AUTO},w.prototype.setBehavior=function(t){this._behavior=t};var R=function(t,e,i,r,a,n,s,o,l){this.Init(t,e,i,r,a,n,s,o,l)};t.Obj.createSubclass(R,t.Path),R.prototype.Init=function(e,i,r,a,n,s,o,l,h){R.superclass.Init.call(this,e.getCtx()),this._chart=e;var u=e.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._funnelWidth=a,this._funnelHeight=n,this._startPercent=s,this._valuePercent=o,this._fillPercent=l,this._3dRatio="on"==u.threeDEffect?1:0,this._gap=h;var g=this._getPath();this._dataColor=et.getColor(this._chart,this._seriesIndex,0),this._backgroundColor=u.backgroundColor?u.backgroundColor:u.funnelBackgroundColor,this.setCmds(g.slice),g.bar&&(this._bar=new t.Path(this.getCtx(),g.bar),this.addChild(this._bar),this._bar.setMouseEnabled(!1)),this._setColorProperties(g.sliceBounds),this._label=this._getSliceLabel(g.sliceBounds,g.barBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))},R._FUNNEL_3D_WIDTH_RATIO=.08,R._FUNNEL_ANGLE_2D=36,R._FUNNEL_RATIO=1/3,R._BORDER_COLOR="#FFFFFF",R._MIN_CHARS_DATA_LABEL=3,R._LINE_FRACTION=2/3,R._AREA_FRACTION=.41,R._HEIGHT_FRACTION=.28,R._LINE_FRACTION_2=.4,R._AREA_FRACTION_2=.8,R._HEIGHT_FRACTION_2=.7,R.prototype._getPath=function(){var e=t.Agent.isRightToLeft(this.getCtx()),i=Q.getSeriesCount(this._chart),r=(this._numDrawnSeries+1)*this._gap,a=t.Math.degreesToRads(R._FUNNEL_ANGLE_2D-2*this._3dRatio),n=this._funnelWidth-i*this._gap,s=n/Math.sin(t.Math.degreesToRads(R._FUNNEL_ANGLE_2D)),o=this._funnelHeight/Math.sin(a),l=this._3dRatio*this._funnelWidth/this._funnelHeight*R._FUNNEL_3D_WIDTH_RATIO;l<1e-5&&(l=0);var h,u,g,d,c,p,_,f,v,m,S,C,y=this._funnelHeight,x=this._funnelHeight*R._FUNNEL_RATIO;this._startPercent<R._AREA_FRACTION?(h=this._startPercent,g=y,c=this._funnelHeight*R._LINE_FRACTION,_=R._AREA_FRACTION,v=n*R._HEIGHT_FRACTION,S=n*(1-R._HEIGHT_FRACTION)):this._startPercent<R._AREA_FRACTION_2?(h=this._startPercent-R._AREA_FRACTION,g=this._funnelHeight*R._LINE_FRACTION,c=this._funnelHeight*R._LINE_FRACTION_2,_=R._AREA_FRACTION_2-R._AREA_FRACTION,v=n*(R._HEIGHT_FRACTION_2-R._HEIGHT_FRACTION),S=n*(1-R._HEIGHT_FRACTION_2)):(h=this._startPercent-R._AREA_FRACTION_2,g=this._funnelHeight*R._LINE_FRACTION_2,c=x,_=1-R._AREA_FRACTION_2,v=n*(1-R._HEIGHT_FRACTION_2),S=0),this._startPercent+this._valuePercent<R._AREA_FRACTION?(d=y,p=this._funnelHeight*R._LINE_FRACTION,u=this._startPercent+this._valuePercent,f=R._AREA_FRACTION,m=n*R._HEIGHT_FRACTION,C=n*(1-R._HEIGHT_FRACTION)):this._startPercent+this._valuePercent<R._AREA_FRACTION_2?(d=this._funnelHeight*R._LINE_FRACTION,p=this._funnelHeight*R._LINE_FRACTION_2,u=this._startPercent+this._valuePercent-R._AREA_FRACTION,f=R._AREA_FRACTION_2-R._AREA_FRACTION,m=n*(R._HEIGHT_FRACTION_2-R._HEIGHT_FRACTION),C=n*(1-R._HEIGHT_FRACTION_2)):(d=this._funnelHeight*R._LINE_FRACTION_2,p=x,u=this._startPercent+this._valuePercent-R._AREA_FRACTION_2,f=1-R._AREA_FRACTION_2,m=n*(1-R._HEIGHT_FRACTION_2),C=0);var A,b,M,T=Math.sqrt((_-h)/_*g*g+h/_*c*c),I=Math.sqrt((f-u)/f*d*d+u/f*p*p),O=.98*Math.asin(((T-c)*v/(g-c)+S)/s),D=.98*Math.asin(((I-p)*m/(d-p)+C)/s),E=(1+R._FUNNEL_RATIO)/2*this._funnelHeight+o,P=(1-R._FUNNEL_RATIO)/2*this._funnelHeight-o;e?(A=[s*Math.sin(O)+r,E-o*Math.cos(O),s*Math.sin(D)+r,E-o*Math.cos(D),s*Math.sin(D)+r,P+o*Math.cos(D),s*Math.sin(O)+r,P+o*Math.cos(O)],b=0,M=1):(A=[this._funnelWidth-r-s*Math.sin(O),E-o*Math.cos(O),this._funnelWidth-r-s*Math.sin(D),E-o*Math.cos(D),this._funnelWidth-r-s*Math.sin(D),P+o*Math.cos(D),this._funnelWidth-r-s*Math.sin(O),P+o*Math.cos(O)],b=1,M=0);var L=t.PathUtils.moveTo(A[0],A[1]),w=null;L+=t.PathUtils.arcTo(l*(A[1]-A[7])/2,(A[1]-A[7])/2,Math.PI,M,A[6],A[7]),L+=t.PathUtils.arcTo(l*(A[1]-A[7])/2,(A[1]-A[7])/2,Math.PI,M,A[0],A[1]),L+=t.PathUtils.arcTo(s,o,a,b,A[2],A[3]),L+=t.PathUtils.arcTo(l*(A[3]-A[5])/2,(A[3]-A[5])/2,Math.PI,M,A[4],A[5]),L+=t.PathUtils.arcTo(s,o,a,b,A[6],A[7]);var B=new t.Rectangle(Math.min(A[0],A[2]),A[5],Math.abs(A[0]-A[2]),Math.abs(A[3]-A[5]));if(null!=this._fillPercent){var k=Math.max(Math.min(this._fillPercent,1),0),F=e?-k*Math.PI:k*Math.PI;w=t.PathUtils.moveTo(A[0],A[1]),w+=t.PathUtils.arcTo(s,o,a,b,A[2],A[3]),w+=t.PathUtils.arcTo(l*(A[3]-A[5])/2,(A[3]-A[5])/2,F,M,A[2]+l*(A[3]-A[5])/2*Math.sin(F),(A[5]+A[3])/2+(A[3]-A[5])/2*Math.cos(F)),this._fillPercent>.95?w+=t.PathUtils.arcTo(s,o,a,b,A[6],A[1]+k*(A[7]-A[1])):this._fillPercent<.05?w+=t.PathUtils.arcTo(s,o,a,M,A[6],A[1]+k*(A[7]-A[1])):w+=t.PathUtils.lineTo(A[6]+l*(A[1]-A[7])/2*Math.sin(F),(A[7]+A[1])/2+(A[1]-A[7])/2*Math.cos(F)),w+=t.PathUtils.arcTo(l*(A[1]-A[7])/2,(A[1]-A[7])/2,F,b,A[0],A[1]),w+=t.PathUtils.closePath();var N=new t.Rectangle(Math.min(A[0],A[2]),A[5]+Math.abs(A[3]-A[5])*(1-k),Math.abs(A[0]-A[2]),Math.abs(A[3]-A[5])*k)}return{slice:L,bar:w,sliceBounds:B,barBounds:w?N:B}},R.prototype._getSliceLabel=function(e,i){var r=Q.getDataLabel(this._chart,this._seriesIndex,0);if(r||(r=Q.getSeriesLabel(this._chart,this._seriesIndex)),r&&"none"!=et.getDataLabelPosition(this._chart,this._seriesIndex,0)){var a=new t.MultilineText(this.getCtx(),r,0,0),n=null!=et.getPattern(this._chart,this._seriesIndex,0),s=[this._chart.getOptions().styleDefaults.dataLabelStyle,new t.CSSStyle(Q.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],o=t.CSSStyle.mergeStyles(s);if(a.setCSSStyle(o),t.TextUtils.fitText(a,e.h-this._3dRatio*(.8-this._valuePercent)*50,e.w,this,R._MIN_CHARS_DATA_LABEL)){var l=a.getDimensions(),h=this._getLabelPosition(e);if(n){var u=.15*l.h,g=t.Agent.isRightToLeft(this.getCtx())?.5:-.5,d=t.PathUtils.roundedRectangle(l.x-u,l.y,l.w+2*u,l.h,2,2,2,2),c=new t.Path(this.getCtx(),d);c.setSolidFill("#FFFFFF",.9),h=h.translate(g*l.h,-g*l.w),c.setMatrix(h),this.addChild(c)}var p=n?"#000000":i.containsPoint(e.x,e.y+(e.h-l.w)/2)?t.ColorUtils.getContrastingTextColor(this._dataColor):t.ColorUtils.getContrastingTextColor(this._backgroundColor);return o.getStyle("color")&&!t.Agent.isHighContrast()||a.setCSSStyle(o.setStyle("color",p)),a.setMatrix(this._getLabelPosition(e)),a.alignCenter(),a.alignMiddle(),a}}},R.prototype._getLabelPosition=function(e){var i=this._3dRatio*(e.h*this._funnelWidth/this._funnelHeight*R._FUNNEL_3D_WIDTH_RATIO/2),r=new t.Matrix;return r=t.Agent.isRightToLeft(this.getCtx())?(r=r.rotate(Math.PI/2)).translate(e.x+e.w/2-i,e.y+e.h/2):(r=r.rotate(3*Math.PI/2)).translate(e.x+e.w/2+i,e.y+e.h/2)},R.prototype._setColorProperties=function(e){var i=tt.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,e),r=et.getBorderColor(this._chart,this._seriesIndex,0);null==r&&this._3dRatio>0&&(r=R._BORDER_COLOR);var a=et.getBorderWidth(this._chart,this._seriesIndex,0),n=t.SelectionEffectUtils.getHoverBorderColor(this._dataColor),s=tt.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._backgroundColor,e,!0);this._bar?(this.setFill(s),this._bar.setFill(i),this._bar.setStyle(et.getStyle(this._chart,this._seriesIndex,0)),this._bar.setClassName(et.getClassName(this._chart,this._seriesIndex,0))):(this.setFill(i),this.setStyle(et.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(et.getClassName(this._chart,this._seriesIndex,0))),r&&this.setSolidStroke(r,null,a),this.OriginalStroke=this.getStroke();var o=null!=this._bar?this._bar:this;if(o.setHoverStroke(new t.Stroke(n,1,2)),this._chart.isSelectionSupported()){var l=et.getSelectedInnerColor(this._chart),h=et.getSelectedOuterColor(this._chart)?et.getSelectedOuterColor(this._chart):this._dataColor;o.setSelectedStroke(new t.Stroke(l,1,1.5),new t.Stroke(h,1,4.5)),o.setSelectedHoverStroke(new t.Stroke(l,1,1.5),new t.Stroke(n,1,4.5)),this.setCursor(t.SelectionEffectUtils.getSelectingCursor())}},R.prototype.getAnimationParams=function(){return[this._startPercent,this._valuePercent,this._fillPercent,this.getAlpha(),this._3dRatio]},R.prototype.setAnimationParams=function(t){this._startPercent=t[0],this._valuePercent=t[1],this._fillPercent=null!=this._fillPercent?t[2]:null,this.setAlpha(t[3]),this._3dRatio=t[4];var e=this._getPath();this.setCmds(e.slice),e.bar&&this._bar&&this._bar.setCmds(e.bar),this._label&&this._label.setMatrix(this._getLabelPosition(e.sliceBounds))},R.prototype.setSelected=function(t){if(null!=this._bar){if(this.IsSelected==t)return;this.IsSelected=t,this._bar.setSelected(t)}else R.superclass.setSelected.call(this,t);var e=this.getDimensions(),i=null!=this._bar?this._bar:this,r=e.w;t?(i.setScaleX((r-3)/r),i.setTranslateX(Math.ceil(1.5)+3/r*e.x)):(i.setScaleX(1),i.setTranslateX(0))},R.prototype.showHoverEffect=function(){null!=this._bar?this._bar.showHoverEffect():R.superclass.showHoverEffect.call(this)},R.prototype.hideHoverEffect=function(){null!=this._bar?this._bar.hideHoverEffect():R.superclass.hideHoverEffect.call(this)},R.prototype.copyShape=function(){return new R(this._chart,this._seriesIndex,this._numDrawnSeries,this._funnelWidth,this._funnelHeight,this._startPercent,this._valuePercent,this._fillPercent,this._gap)};var B=function(t,e,i,r,a,n,s,o){this.Init(t,e,i,r,a,n,s,o)};t.Obj.createSubclass(B,t.Path),B.prototype.Init=function(e,i,r,a,n,s,o,l){B.superclass.Init.call(this,e.getCtx()),this._chart=e;var h=e.getOptions().styleDefaults;this._seriesIndex=i,this._numDrawnSeries=r,this._pyramidWidth=a,this._pyramidHeight=n,this._startPercent=s,this._valuePercent=o,this._3dRatio="on"==h.threeDEffect?1:0,this._gap=l;var u=this._getPath();this._dataColor=et.getColor(this._chart,this._seriesIndex,0),this._3dRatio>0?(this.setCmds(u.threeDPathTop),this._threeDPathSide=new t.Path(this.getCtx(),u.threeDPathSide),this._mainFace=new t.Path(this.getCtx(),u.slice),this.addChild(this._threeDPathSide),this.addChild(this._mainFace)):this.setCmds(u.slice),this._setColorProperties(u.sliceBounds),this._label=this._getSliceLabel(u.sliceBounds),null!=this._label&&(this._label.setMouseEnabled(!1),this.addChild(this._label))},B._BORDER_COLOR="#FFFFFF",B._MIN_CHARS_DATA_LABEL=3,B._SLICE_LABEL_HORIZONTAL_PADDING=4,B._3D_WIDTH_FACTOR=.2,B.prototype._getPath=function(){var e,i,r,a,n,s,o=t.Agent.isRightToLeft(this.getCtx()),l=Q.getSeriesCount(this._chart),h=(l-this._numDrawnSeries-1)*this._gap,u=this._3dRatio*B._3D_WIDTH_FACTOR*.98*this._pyramidWidth,g=this._chart.getOptions(),d=Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent)),c=this._startPercent+this._valuePercent>=1?0:Math.sqrt(Math.pow(this._pyramidHeight-(l-1)*this._gap,2)*(1-this._startPercent-this._valuePercent)),p=.98*(1-this._3dRatio*B._3D_WIDTH_FACTOR)*this._pyramidWidth*(c/this._pyramidHeight),_=0==this._numDrawnSeries?d:d-this._gap,f=.98*(1-this._3dRatio*B._3D_WIDTH_FACTOR)*this._pyramidWidth*(_/this._pyramidHeight);if(o?(i=[this._pyramidWidth-.5*this._pyramidWidth+u/2-p/2,h+c],a=[this._pyramidWidth-.5*this._pyramidWidth+u/2-f/2,h+d],r=[this._pyramidWidth-.5*this._pyramidWidth+u/2+f/2,h+d],e=[this._pyramidWidth-.5*this._pyramidWidth+u/2+p/2,h+c]):(e=[.5*this._pyramidWidth-u/2-p/2,h+c],r=[.5*this._pyramidWidth-u/2-f/2,h+d],a=[.5*this._pyramidWidth-u/2+f/2,h+d],i=[.5*this._pyramidWidth-u/2+p/2,h+c]),"on"==g.styleDefaults.threeDEffect){var v=this._3dRatio*B._3D_WIDTH_FACTOR*f*Math.sqrt(2)/2,m=this._3dRatio*B._3D_WIDTH_FACTOR*p*Math.sqrt(2)/2;n=t.PathUtils.moveTo(i[0],i[1]),n+=t.PathUtils.lineTo(i[0]+(o?-1:1)*Math.max(m,1),i[1]-Math.max(m,.5)),n+=t.PathUtils.lineTo(e[0]+(o?-1:1)*Math.max(m,1),e[1]-Math.max(m,.5)),n+=t.PathUtils.lineTo(e[0],e[1]),n+=t.PathUtils.closePath(),s=t.PathUtils.moveTo(i[0],i[1]),s+=t.PathUtils.lineTo(i[0]+(o?-1:1)*Math.max(m,1),i[1]-Math.max(m,.5)),s+=t.PathUtils.lineTo(a[0]+(o?-1:1)*v,a[1]-v),s+=t.PathUtils.lineTo(a[0],a[1]),s+=t.PathUtils.closePath()}var S=t.PathUtils.moveTo(i[0],i[1]);S+=t.PathUtils.lineTo(a[0],a[1]),S+=t.PathUtils.lineTo(r[0],r[1]),S+=t.PathUtils.lineTo(e[0],e[1]),S+=t.PathUtils.closePath();var C=p/f,y=.5*Math.abs(e[1]-r[1])*(1+C),x=.5*Math.abs(a[0]-r[0])*(1+C)-B._SLICE_LABEL_HORIZONTAL_PADDING,A=r[1]-y,b=r[0]+(f-x)/2*(o?-1:1);return{slice:S,sliceBounds:new t.Rectangle(b,A,x,y),threeDPathTop:n,threeDPathSide:s}},B.prototype._getSliceLabel=function(e){var i=Q.getDataLabel(this._chart,this._seriesIndex,0);if(i||(i=Q.getSeriesLabel(this._chart,this._seriesIndex)),i&&"none"!=et.getDataLabelPosition(this._chart,this._seriesIndex,0)){var r=new t.MultilineText(this.getCtx(),i,0,0),a=null!=et.getPattern(this._chart,this._seriesIndex,0),n=[this._chart.getOptions().styleDefaults.dataLabelStyle,new t.CSSStyle(Q.getDataItem(this._chart,this._seriesIndex,0).labelStyle)],s=t.CSSStyle.mergeStyles(n);if(r.setCSSStyle(s),t.TextUtils.fitText(r,e.w,e.h,this,B._MIN_CHARS_DATA_LABEL)){var o=r.getDimensions(),l=this._getLabelPosition(e);if(a){var h=.15*o.h,u=t.PathUtils.roundedRectangle(o.x-h,o.y,o.w+2*h,o.h,2,2,2,2),g=new t.Path(this.getCtx(),u);g.setSolidFill("#FFFFFF",.9),l=l.translate(-.5*o.w,-.5*o.h),g.setMatrix(l),this.addChild(g)}var d=a?"#000000":e.containsPoint(e.x+(e.w-o.w)/2,e.y)?t.ColorUtils.getContrastingTextColor(this._dataColor):t.ColorUtils.getContrastingTextColor(null);return s.getStyle("color")&&!t.Agent.isHighContrast()||r.setCSSStyle(s.setStyle("color",d)),r.setMatrix(this._getLabelPosition(e)),r.alignCenter(),r.alignMiddle(),r}}},B.prototype._getLabelPosition=function(e){var i=new t.Matrix;return i=t.Agent.isRightToLeft(this.getCtx())?i.translate(e.x-e.w/2,e.y+e.h/2):i.translate(e.x+e.w/2,e.y+e.h/2)},B.prototype._setColorProperties=function(e){var i=tt.getFunnelPyramidSliceFill(this._chart,this._seriesIndex,this._dataColor,e),r=et.getBorderColor(this._chart,this._seriesIndex,0);null==r&&this._3dRatio>0&&(r=B._BORDER_COLOR);var a=et.getBorderWidth(this._chart,this._seriesIndex,0),n=t.SelectionEffectUtils.getHoverBorderColor(this._dataColor);if(this._3dRatio>0){var s=!i.getPattern&&!i.getAlphas;this._mainFace.setFill(i),this._mainFace.setStyle(et.getStyle(this._chart,this._seriesIndex,0)),this._mainFace.setClassName(et.getClassName(this._chart,this._seriesIndex,0)),this._threeDPathSide.setFill(s?new t.SolidFill(t.ColorUtils.getDarker(i.getColor(),.3)):i),this._threeDPathSide.setStyle(et.getStyle(this._chart,this._seriesIndex,0)),this._threeDPathSide.setClassName(et.getClassName(this._chart,this._seriesIndex,0)),this.setFill(s?new t.SolidFill(t.ColorUtils.getDarker(i.getColor(),.3)):i),this.setStyle(et.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(et.getClassName(this._chart,this._seriesIndex,0))}else this.setFill(i),this.setStyle(et.getStyle(this._chart,this._seriesIndex,0)),this.setClassName(et.getClassName(this._chart,this._seriesIndex,0));if(r&&(this.setSolidStroke(r,null,a),this._3dRatio>0&&(this._threeDPathSide.setSolidStroke(r,null,a),this._mainFace.setSolidStroke(r,null,a))),this.OriginalStroke=this.getStroke(),this.setHoverStroke(new t.Stroke(n,1,2)),this._3dRatio>0&&(this._threeDPathSide.setHoverStroke(new t.Stroke(n,1,2)),this._mainFace.setHoverStroke(new t.Stroke(n,1,2))),this._chart.isSelectionSupported()){var o=et.getSelectedInnerColor(this._chart),l=et.getSelectedOuterColor(this._chart)?et.getSelectedOuterColor(this._chart):this._dataColor;this._3dRatio>0?(this._mainFace.setSelectedStroke(new t.Stroke(o,1,1.5),new t.Stroke(l,1,4.5)),this._mainFace.setSelectedHoverStroke(new t.Stroke(o,1,1.5),new t.Stroke(n,1,4.5)),this._mainFace.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._threeDPathSide.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.setCursor(t.SelectionEffectUtils.getSelectingCursor())):(this.setSelectedStroke(new t.Stroke(o,1,1.5),new t.Stroke(l,1,4.5)),this.setSelectedHoverStroke(new t.Stroke(o,1,1.5),new t.Stroke(n,1,4.5)),this.setCursor(t.SelectionEffectUtils.getSelectingCursor()))}},B.prototype.getAnimationParams=function(){return[this._startPercent,this._valuePercent,this.getAlpha(),this._3dRatio]},B.prototype.setAnimationParams=function(t){this._startPercent=t[0],this._valuePercent=t[1],this.setAlpha(t[2]),this._3dRatio=t[3];var e=this._getPath();this._threeDPathSide&&this._mainFace?(this.setCmds(e.threeDPathTop),this._threeDPathSide.setCmds(e.threeDPathSide),this._mainFace.setCmds(e.slice)):this.setCmds(e.slice),this._label&&this._label.setMatrix(this._getLabelPosition(e.sliceBounds))},B.prototype.setSelected=function(t){if(this._3dRatio>0)if(this._mainFace.setSelected(t),t){var e=this.getDimensions(),i=e.w,r=e.h,a=(i-3)/i,n=(r-5)/r;this._mainFace.setScaleX(a),this._mainFace.setScaleY(n),this._mainFace.setTranslateX(Math.ceil(1.5)+3/i*e.x),this._mainFace.setTranslateY(Math.ceil(2.5)+5/r*e.y)}else this._mainFace.setScaleX(1),this._mainFace.setScaleY(1),this._mainFace.setTranslateX(0),this._mainFace.setTranslateY(0);else B.superclass.setSelected.call(this,t)},B.prototype.showHoverEffect=function(){B.superclass.showHoverEffect.call(this),this._3dRatio>0&&(this._threeDPathSide.showHoverEffect(),this._mainFace.showHoverEffect())},B.prototype.hideHoverEffect=function(){B.superclass.hideHoverEffect.call(this),this._3dRatio>0&&(this._threeDPathSide.hideHoverEffect(),this._mainFace.hideHoverEffect())},B.prototype.copyShape=function(){return new B(this._chart,this._seriesIndex,this._numDrawnSeries,this._pyramidWidth,this._pyramidHeight,this._startPercent,this._valuePercent,this._gap)},B.prototype.getPrimaryFill=function(){return this._mainFace?this._mainFace.getFill():this.getFill()};var k=function(t,e,i,r){this.Init(t,e,i,r)};k._THREED_TILT=.59,k._THREED_DEPTH=.1,k._RADIUS=.45,k._RADIUS_LABELS=.38,k._MIN_ARC_LENGTH=1.5,t.Obj.createSubclass(k,t.Container),k.prototype.Init=function(e,i,r,a){k.superclass.Init.call(this,e.getCtx()),this.chart=e,this._options=e.getOptions(),this._frame=i.clone(),e.pieChart=this;for(var n=this.getLabelPosition(),s=Q.getSeriesCount(e),o=0;o<s;o++){var l=Q.getDataItem(e,o,0);!l||"center"!=n&&"none"!=n||"outsideSlice"!=l.labelPosition||(n="outsideSlice")}this._center=new t.Point(i.x+Math.floor(i.w/2),i.y+Math.floor(i.h/2));var h="center"==n||"none"==n?k._RADIUS:k._RADIUS_LABELS;this._radiusX=Math.floor(Math.min(i.w,i.h)*h),this._radiusY=this._radiusX,this._depth=0,this._anchorOffset=90,this.is3D()&&(this._depth=i.h*k._THREED_DEPTH,this._center.y-=Math.floor(this._depth/2),this._radiusY*=k._THREED_TILT),this._slices=this._createSlices(),this._centerLabel=null,this._shapesContainer=new t.Container(this.getCtx()),this._numFrontObjs=0,this._numSelectedObjsInFront=0},k.prototype.getOptions=function(){return this._options},k.prototype.highlight=function(e){t.CategoryRolloverHandler.highlight(e,this._slices,"any"==this.getOptions().highlightMatch)},k.prototype._createSlices=function(){for(var e,i,r=[],a=st.getRenderedSeriesIndices(this.chart),n=st.getOtherValue(this.chart),s=0;s<a.length;s++)if(i=a[s],et.isDataItemRendered(this.chart,i)){var o=(e=new F(this,i)).getValue();null==o||o<=0||r.push(e)}var l=et.getHiddenCategories(this.chart).indexOf(st.OTHER_SLICE_SERIES_ID)>=0;if(n>0&&!l){var h=new F(this);"ascending"==this.chart.getOptions().sorting?r.unshift(h):r.push(h)}return t.Agent.isRightToLeft(this.getCtx())&&r.reverse(),r},k.prototype.setInitialSelection=function(){var t=this.chart.getSelectionHandler();if(t){for(var e=Q.getInitialSelection(this.chart),i=[],r=0;r<e.length;r++)for(var a=0;a<this._slices.length;a++){var n=this._slices[a].getId();null!=n&&(null!=e[r].id&&n.id==e[r].id||n.series==e[r].series&&n.group==e[r].group)&&i.push(n)}if(st.isOtherSliceSelected(this.chart,e)){var s=st.getOtherSliceId(this.chart);i.push(s)}t.processInitialSelections(i,this._slices)}},k.prototype.render=function(){J.addPlotAreaDnDBackground(this.chart,this,this._frame,!0),this.contains(this._shapesContainer)||(this._shapesContainer||(this._shapesContainer=new t.Container(this.getCtx())),this.addChild(this._shapesContainer)),k._layoutSlices(this._slices,this._anchorOffset);for(var e=2*Math.PI*this.getRadiusX(),i=0,r={},a=this.chart.getOptionsCache().getFromCache("hasLargeSeriesCount"),n=0;n<this._slices.length;n++){if(a){var s=this._slices[n].getAngleExtent(),o=s/360*e,l=(this._slices[n].getAngleStart()+s)/360*e;if(o<k._MIN_ARC_LENGTH&&Math.abs(i-l)<k._MIN_ARC_LENGTH){r[this._slices[n].getSeriesIndex()]=!0;continue}i=l}this._slices[n].preRender()}var h=k._orderSlicesForRendering(this._slices);this._duringDisplayAnim||(ht.createPieCenter(this),ht.layoutLabelsAndFeelers(this));for(n=0;n<h.length;n++)r[h[n].getSeriesIndex()]||h[n].render(this._duringDisplayAnim);"safari"!==t.Agent.browser&&t.Agent.browser,this.setInitialSelection(),this.highlight(et.getHighlightedCategories(this.chart))},k.prototype.getTotalValue=function(){for(var t=0,e=0;e<this._slices.length;e++){var i=this._slices[e].getValue();i>=0&&(t+=i)}return t},k._layoutSlices=function(t,e){var i,r,a=0,n=t?t.length:0;e>360&&(e-=360),e<0&&(e+=360);var s=0;n>0&&(s=t[0].getPieChart().getTotalValue());for(var o=0;o<n;o++){var l=(i=t[o]).getValue();(r=e-(a=3.6*(l==s?100:0==s?0:Math.min(l/s*100,99.99))))<0&&(r+=360),i.setAngleStart(r),i.setAngleExtent(a),e=i.getAngleStart()}},k._orderSlicesForRendering=function(t){for(var e,i,r,a,n=[],s=t?t.length:0,o=-1,l=0;l<s;l++)if((r=(i=(e=t[l]).getAngleStart())+e.getAngleExtent())>360&&(r-=360),r<0&&(r+=360),90==r||i<90&&r>90){o=l,a=r-90;break}var h=[];for(l=o;l<s;l++)h.push(t[l]);for(l=0;l<o;l++)h.push(t[l]);var u=0,g=0,d=180+a;for(l=0;l<s;l++)if(e=h[l]){if(u+e.getAngleExtent()>d){g=l;break}n.push(e),u+=e.getAngleExtent()}for(l=s-1;l>=g;l--)(e=h[l])&&n.push(e);return n},k.prototype.is3D=function(){return"on"==this._options.styleDefaults.threeDEffect},k.prototype.__calcMaxExplodeDistance=function(){var t=.5/k._RADIUS-1;return this._radiusX*t},k.prototype.getAnimationDuration=function(){return et.getAnimationDuration(this.chart)},k.prototype.getDisplayAnimation=function(){this._duringDisplayAnim=!0;var e=new t.DataAnimationHandler(this.getCtx(),this),i=this.getAnimationDuration(),r=F.createFillerSlice(this,this.getTotalValue());this._slices.push(r);var a=new t.CustomAnimation(this.getCtx(),r,i);a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.GetAnimationParams,r.SetAnimationParams,r.getDeletedAnimationParams()),a.setOnEnd(r._removeDeletedSlice,r),e.add(a,0);for(var n=0;n<this._slices.length-1;n++)this._slices[n].animateInsert(e);var s=new t.CustomAnimation(this.getCtx(),this,i);s.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,this._getAnimationParams()),e.add(s,0);var o=[];for(n=0;n<this._slices.length;n++)o=o.concat(this._slices[n].getLabelAndFeeler());var l=new t.AnimFadeIn(this._context,o,i);e.add(l,0),this._setAnimationParams();var h=e.getAnimation(!0);return h.setOnEnd(this._onEnd,this),h},k.prototype._onEnd=function(){this._duringDisplayAnim=!1,this._setAnimationParams()},k.prototype.getCenter=function(){return this._center},k.prototype.getId=function(){return"chart/pie"},k.prototype.getInnerRadius=function(){return this.is3D()?0:this._options.styleDefaults.pieInnerRadius*Math.min(this._radiusX,this._radiusY)*.95},k.prototype.__getFrame=function(){return this._frame},k.prototype.getRadiusX=function(){return this._radiusX},k.prototype.getRadiusY=function(){return this._radiusY},k.prototype.getDepth=function(){return this._depth},k.prototype.getSliceDisplayable=function(t){var e=st.getSliceBySeriesIndex(this.chart,t);return e?e.getTopDisplayable():null},k.prototype.__getShapesContainer=function(){return this._shapesContainer},k.prototype.__getSlices=function(){return this._slices},k.prototype.animateUpdate=function(e,i){var r=new t.DataAnimationHandler(this.getCtx(),this);r.constructAnimation(i.__getSlices(),this.__getSlices());var a=r.getAnimation(!0),n=new t.CustomAnimation(this.getCtx(),this,this.getAnimationDuration());n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,this._getAnimationParams());var s=new t.ParallelPlayable(this.getCtx(),a,n);s.setOnEnd(this._setAnimationParams,this),e.add(s,0),this._setAnimationParams([i.getDepth(),i.getRadiusY(),i.getCenter().y])},k.prototype.animateInsert=function(t){},k.prototype.animateDelete=function(t,e){},k.prototype._getAnimationParams=function(){return[this._depth,this._radiusY,this._center.y]},k.prototype._setAnimationParams=function(t){this.removeChildren(),this._shapesContainer&&this._shapesContainer.destroy(),this._shapesContainer=null,t&&(this._depth=t[0],this._radiusY=t[1],this._center.y=t[2]),this.render()},k.prototype.bringToFrontOfSelection=function(t){var e=t.getPieChart()._shapesContainer;if(e){var i=e.getNumChildren();if(i-this._numFrontObjs>1){e.removeChild(t._topSurface[0]);var r=i-this._numFrontObjs-1;e.addChildAt(t._topSurface[0],r)}}},k.prototype.pushToBackOfSelection=function(t){for(var e=this._slices.length,i=0,r=0;r<e;r++)this._slices[r].isSelected()&&i++;this._numSelectedObjsInFront=i;var a=t.getPieChart()._shapesContainer;if(a){var n=a.getNumChildren()-this._numFrontObjs-1-this._numSelectedObjsInFront;n>=0&&(a.removeChild(t._topSurface[0]),a.addChildAt(t._topSurface[0],n))}},k.prototype.getLabelPosition=function(){return k.parseLabelPosition(this._options.styleDefaults.dataLabelPosition)},k.prototype.getSeriesLabelPosition=function(t){var e=this.getLabelPosition(),i=Q.getDataItem(this.chart,t,0);return i&&i.labelPosition&&(e=i.labelPosition),k.parseLabelPosition(e)},k.parseLabelPosition=function(t){return"center"==t||"inside"==t?"center":"outsideSlice"==t||"outside"==t?"outsideSlice":"none"==t?"none":"auto"},k.prototype.getSkin=function(){return this._options.skin},k.prototype.setCenterLabel=function(t){this._centerLabel=t},k.prototype.getCenterLabel=function(){return this._centerLabel};var F=function(t,e){this.Init(t,e)};t.Obj.createSubclass(F,t.Obj),F.prototype.Init=function(t,e){this._pieChart=t,this._chart=t.chart,this._angleStart=0,this._angleExtent=0,this._topSurface=null,this._leftSurface=null,this._rightSurface=null,this._crustSurface=null,this._explodeOffsetX=0,this._explodeOffsetY=0,this._sliceLabel=null,this._sliceLabelString=null,this._hasFeeler=!1,this._feelerRad=null,this._feelerHoriz=null,this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._selected=!1,this._selecting=!1,this._centerX=this._pieChart.getCenter().x,this._centerY=this._pieChart.getCenter().y,this._radiusX=this._pieChart.getRadiusX(),this._radiusY=this._pieChart.getRadiusY(),this._depth=this._pieChart.getDepth();var i=this._chart.getOptions();if(null!=e){var r=Q.getDataItem(this._chart,e,0);this._value=Q.getValue(this._chart,e,0),this._explode=st.getSliceExplode(this._chart,e),this._fillColor=et.getColor(this._chart,e,0),this._fillPattern=et.getPattern(this._chart,e,0),this._strokeColor=et.getBorderColor(this._chart,e),this._borderWidth=et.getBorderWidth(this._chart,e),this._customLabel=r?r.label:null,this._seriesLabel=Q.getSeries(this._chart,e),this._drillable=J.isDataItemDrillable(this._chart,e,0),this._id=st.getSliceId(this._chart,e),this._seriesIndex=e,this._categories=Q.getCategories(this._chart,e,0)}else this._value=st.getOtherValue(this._chart),this._explode=0,this._fillColor=i.styleDefaults.otherColor,this._fillPattern=null,this._strokeColor=i.styleDefaults.borderColor,this._borderWidth=i.styleDefaults.borderWidth,this._customLabel=null,this._seriesLabel=i.translations.labelOther,this._drillable=!1,this._id=st.getOtherSliceId(this._chart)},F.prototype.getPieChart=function(){return this._pieChart},F.prototype.render=function(e){for(var i=F._sortPieSurfaces(this._topSurface,this._leftSurface,this._rightSurface,this._crustSurface,this._angleStart,this._angleExtent),r=i.length,a=0;a<r;a++)for(var n=i[a],s=n.length,o=0;o<s;o++){this._pieChart.__getShapesContainer().addChild(n[o]),n[o].render&&n[o].render()}if(this._sliceLabel&&(this._pieChart.addChild(this._sliceLabel),ot.associate(this,[this._sliceLabel]),e?(this._pieChart.addChild(this._feelerRad),this._pieChart.addChild(this._feelerHoriz)):this._renderOutsideFeeler()),this._explodeSlice(),this._drillable||this._pieChart.chart.isSelectionSupported()){var l=this.getDisplayables();for(a=0;a<l.length;a++)l[a].setCursor(t.SelectionEffectUtils.getSelectingCursor())}var h=this.getTopDisplayable();h&&(h.setAriaRole("img"),this._updateAriaLabel())},F.prototype._feelerFromPts=function(e,i){var r=new t.Line(this._pieChart.getCtx(),e.x,e.y,i.x,i.y),a=this._pieChart.getOptions().styleDefaults.pieFeelerColor,n=new t.Stroke(a);return r.setStroke(n),this._pieChart.addChild(r),r},F.prototype._renderOutsideFeeler=function(){if(this._hasFeeler){var t=this._feelerFromPts(this._outsideFeelerStart,this._outsideFeelerMid),e=this._feelerFromPts(this._outsideFeelerMid,this._outsideFeelerEnd);this._feelerRad=t,this._feelerHoriz=e}},F.prototype.preRender=function(){var e,i=this._bFillerSlice?"color":et.getSeriesEffect(this._chart),r=this.getFillColor(),a=this.getFillPattern();if("pattern"==i||null!=a)e=new t.PatternFill(a,r),i="pattern";else if("gradient"==i){var n=this._pieChart.is3D()?"3D":"2D",s=ot.getGradientColors(t.ColorUtils.getRGB(r),n),o=ot.getGradientAlphas(t.ColorUtils.getAlpha(r),n),l=[Math.floor(this._centerX-this._radiusX),Math.floor(this._centerY-this._radiusY),Math.ceil(2*this._radiusX),Math.ceil(2*this._radiusY)];e=new t.LinearGradientFill(270,s,o,[0,1],l)}else e=new t.SolidFill(r);if(this._topSurface=ot.createTopSurface(this,e),this._depth>0||this._radiusX!=this._radiusY){var h="gradient"==i,u=new t.SolidFill(t.ColorUtils.getDarker(r,.4)),g=h?ot.generateLateralGradientFill(this,ot.SIDE):u,d=h?ot.generateLateralGradientFill(this,ot.CRUST):u;this._leftSurface=ot.createLateralSurface(this,ot.SURFACE_LEFT,g),this._rightSurface=ot.createLateralSurface(this,ot.SURFACE_RIGHT,g),this._crustSurface=ot.createLateralSurface(this,ot.SURFACE_CRUST,d)}this.setSliceLabel(null),this.setNoOutsideFeeler()},F._sortPieSurfaces=function(t,e,i,r,a,n){var s=[];return e&&i&&r&&(a<=270&&a+n>270?(s.push(e),s.push(i),s.push(r)):a>270||a+n<=90?(s.push(e),s.push(r),s.push(i)):(s.push(i),s.push(r),s.push(e))),s.push(t),s},F.oppositeDirection=function(t,e,i){return t-e>0!=t-i>0},F.prototype._explodeSlice=function(){if(0!=this._explode){var e=this._angleExtent,i=(360-(this._angleStart+e/2))*t.Math.RADS_PER_DEGREE,r=this._pieChart.is3D()?k._THREED_TILT:1,a=this._explode*this._pieChart.__calcMaxExplodeDistance();this._explodeOffsetX=Math.cos(i)*a,this._explodeOffsetY=Math.sin(i)*r*a,"safari"!==t.Agent.browser&&"chrome"!==t.Agent.browser||(this._explodeOffsetX=Math.round(this._explodeOffsetX),this._explodeOffsetY=Math.round(this._explodeOffsetY))}else this._explodeOffsetX=0,this._explodeOffsetY=0;if(this._topSurface){var n=this._pieChart.is3D()&&this._topSurface[0].getSelectionOffset?this._topSurface[0].getSelectionOffset():[];F._translateShapes(this._topSurface,n[0]?n[0]+this._explodeOffsetX:this._explodeOffsetX,n[1]?n[1]+this._explodeOffsetY:this._explodeOffsetY)}if(this._rightSurface&&F._translateShapes(this._rightSurface,this._explodeOffsetX,this._explodeOffsetY),this._leftSurface&&F._translateShapes(this._leftSurface,this._explodeOffsetX,this._explodeOffsetY),this._crustSurface&&F._translateShapes(this._crustSurface,this._explodeOffsetX,this._explodeOffsetY),this._hasFeeler){var s=this._outsideFeelerStart.x,o=this._outsideFeelerStart.y,l=s+this._explodeOffsetX,h=o+this._explodeOffsetY;this._feelerRad.setX1(l),this._feelerRad.setY1(h);var u=this._outsideFeelerMid.x,g=this._outsideFeelerMid.y;F.oppositeDirection(u,s,l)?(this._feelerRad.setX2(l),this._feelerHoriz.setX1(l)):(this._feelerRad.setX2(u),this._feelerHoriz.setX1(u)),F.oppositeDirection(g,o,h)?(this._feelerRad.setY2(h),this._feelerHoriz.setY1(h)):(this._feelerRad.setY2(g),this._feelerHoriz.setY1(g))}this._sliceLabel&&!this._hasFeeler&&this._sliceLabel.setTranslate(this._explodeOffsetX,this._explodeOffsetY)},F._translateShapes=function(t,e,i){if(t)for(var r=t.length,a=0;a<r;a++){t[a].setTranslate(e,i)}},F.prototype.getRadiusX=function(){return this._radiusX},F.prototype.getRadiusY=function(){return this._radiusY},F.prototype.getCenter=function(){return new t.Point(this._centerX,this._centerY)},F.prototype.getDepth=function(){return this._depth},F.prototype.getAngleExtent=function(){return this._angleExtent},F.prototype.setAngleExtent=function(t){this._angleExtent=t},F.prototype.getAngleStart=function(){return this._angleStart},F.prototype.setAngleStart=function(t){this._angleStart=t},F.prototype.__getExplodeOffsetX=function(){return this._explodeOffsetX},F.prototype.__getExplodeOffsetY=function(){return this._explodeOffsetY},F.prototype.setOutsideFeelerPoints=function(t,e,i){this._outsideFeelerStart=t,this._outsideFeelerMid=e,this._outsideFeelerEnd=i,this._hasFeeler=!0},F.prototype.setNoOutsideFeeler=function(){this._outsideFeelerStart=null,this._outsideFeelerMid=null,this._outsideFeelerEnd=null,this._hasFeeler=!1},F.prototype.getLabelAndFeeler=function(){var t=[];return this._sliceLabel&&t.push(this._sliceLabel),this._feelerRad&&t.push(this._feelerRad),this._feelerHoriz&&t.push(this._feelerHoriz),t},F.prototype.getSliceLabel=function(){return this._sliceLabel},F.prototype.setSliceLabel=function(t){this._sliceLabel=t},F.prototype.getSliceLabelString=function(){return this._sliceLabelString},F.prototype.setSliceLabelString=function(t){this._sliceLabelString=t},F.prototype.getTopSurface=function(){return this._topSurface},F.prototype.getValue=function(){return this._value},F.prototype.getId=function(){return this._id},F.prototype.getSeriesIndex=function(){return this._seriesIndex},F._shapeIsSelectable=function(t){return t instanceof y},F.prototype.contains=function(t,e){for(var i=this._pieChart.getInnerRadius(),r=this._pieChart.getCenter(),a=(t-r.x)/this._radiusX,n=(e-r.y)/this._radiusY,s=-Math.atan2(n,a)*(180/Math.PI);s<this._angleStart;)s+=360;for(;s-this._angleStart>=360;)s-=360;var o=Math.pow(a,2)+Math.pow(n,2),l=Math.sqrt(o)>i/this._radiusX&&o<=1,h=s<=this._angleStart+this._angleExtent;return l&&h},F.prototype.GetAnimationParams=function(){var e=t.ColorUtils.getRed(this._fillColor),i=t.ColorUtils.getGreen(this._fillColor),r=t.ColorUtils.getBlue(this._fillColor),a=t.ColorUtils.getAlpha(this._fillColor);return[this._value,this._radiusX,this._radiusY,this._explode,this._centerX,this._centerY,this._depth,e,i,r,a]},F.prototype.SetAnimationParams=function(e){this._value=e[0],this._radiusX=e[1],this._radiusY=e[2],this._explode=e[3],this._centerX=e[4],this._centerY=e[5],this._depth=e[6];var i=Math.round(e[7]),r=Math.round(e[8]),a=Math.round(e[9]),n=Math.round(e[10]);this._fillColor=t.ColorUtils.makeRGBA(i,r,a,n)},F.prototype.getDeletedAnimationParams=function(){var t=this.GetAnimationParams();return t[0]=0,t[1]=this.getInnerRadius(),t[2]=this.getInnerRadius(),t[3]=0,t},F.prototype.animateUpdate=function(e,i){var r=i.GetAnimationParams(),a=this.GetAnimationParams();if(!t.ArrayUtils.equals(r,a)){var n=new t.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimationDuration());n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,a),e.add(n,0),this.SetAnimationParams(r)}},F.prototype.animateInsert=function(e){var i=new t.CustomAnimation(this._pieChart.getCtx(),this,this.getPieChart().getAnimationDuration());i.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,this.GetAnimationParams()),e.add(i,0),this.SetAnimationParams(this.getDeletedAnimationParams())},F.prototype.animateDelete=function(e,i){var r=i.__getSlices(),a=this.getPieChart().__getSlices(),n=a.indexOf(this)-1;if(n>=0){for(var s=a[n].getId(),o=0;o<r.length;o++)if(r[o].getId().equals(s)){r.splice(o+1,0,this);break}}else r.splice(0,0,this);this._pieChart=i;var l=new t.CustomAnimation(i.getCtx(),this,this.getPieChart().getAnimationDuration());l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,this.getDeletedAnimationParams()),l.setOnEnd(this._removeDeletedSlice,this),e.add(l,0)},F.prototype._removeDeletedSlice=function(){var t=this.getPieChart().__getSlices(),e=t.indexOf(this);e>=0&&t.splice(e,1)},F.prototype.getDisplayables=function(){var t=new Array;return this._topSurface&&(t=t.concat(this._topSurface)),this._leftSurface&&(t=t.concat(this._leftSurface)),this._rightSurface&&(t=t.concat(this._rightSurface)),this._crustSurface&&(t=t.concat(this._crustSurface)),this._sliceLabel&&t.push(this._sliceLabel),this._feelerRad&&t.push(this._feelerRad),this._feelerHoriz&&t.push(this._feelerHoriz),t},F.prototype.getAriaLabel=function(){var e,i=this._pieChart.getOptions().translations;e=null==this._seriesIndex?rt.getOtherSliceDatatip(this._chart,this._value,!1):rt.getDatatip(this._chart,this._seriesIndex,0,null,!1);var r=i.labelPercentage,a=ht.generateSlicePercentageString(this);e+="; "+t.ResourceUtils.format(i.labelAndValue,[r,a]);var n=[];return this.isSelectable()&&n.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),J.isDataItemDrillable(this._chart,this._seriesIndex,this._groupIndex)&&n.push(i.stateDrillable),t.Displayable.generateAriaLabel(e,n)},F.prototype._updateAriaLabel=function(){var e=this.getTopDisplayable();e&&!t.Agent.deferAriaCreation()&&e.setAriaProperty("label",this.getAriaLabel())},F.prototype.getTopDisplayable=function(){return this._topSurface&&this._topSurface.length>0?this._topSurface[0]:null},F.prototype.isSelectable=function(){return this._chart.isSelectionSupported()},F.prototype.isSelected=function(){return this._selected},F.prototype.setSelected=function(e,i){if(this._selected=e,this.getTopSurface()){if(this._selected?this._pieChart.bringToFrontOfSelection(this):this._selecting||this._pieChart.pushToBackOfSelection(this),et.isSelectionHighlighted(this._chart))for(var r=this.getDisplayables(),a=0;a<r.length;a++)F._shapeIsSelectable(r[a])&&r[a].setSelected(e);if(et.isSelectionExploded(this._chart)){var n=e?1:0;if(i||"none"==et.getAnimationOnDataChange(this._chart))this.setExplode(n);else{var s=new t.CustomAnimation(this._pieChart.getCtx(),this,this._pieChart.getAnimationDuration()/2);s.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getExplode,this.setExplode,n),s.play()}}this._updateAriaLabel()}},F.prototype.showHoverEffect=function(){this._selecting=!0,this._pieChart.bringToFrontOfSelection(this);for(var t=this.getDisplayables(),e=0;e<t.length;e++)F._shapeIsSelectable(t[e])&&t[e].showHoverEffect()},F.prototype.hideHoverEffect=function(){this._selecting=!1,this._selected||this._pieChart.pushToBackOfSelection(this);for(var t=this.getDisplayables(),e=0;e<t.length;e++)F._shapeIsSelectable(t[e])&&t[e].hideHoverEffect()},F.prototype.getDatatip=function(t,e,i){return t==this._sliceLabel&&this._sliceLabel&&this._sliceLabel.isTruncated()?this.getSliceLabelString():this.getTooltip()},F.prototype.getDatatipColor=function(){return this.getFillColor()},F.prototype.getCategories=function(){return this._categories&&this._categories.length>0?this._categories:[this.getId().series]},F.prototype.getNextNavigable=function(e){var i=e.keyCode;if(e.type==t.MouseEvent.CLICK)return this;if(i==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;var r=t.Agent.isRightToLeft(this._chart.getCtx()),a=this._pieChart.__getSlices(),n=a.indexOf(this),s=null;return i==t.KeyboardEvent.RIGHT_ARROW||i==t.KeyboardEvent.DOWN_ARROW&&!r||i==t.KeyboardEvent.UP_ARROW&&r?s=n<a.length-1?a[n+1]:a[0]:(i==t.KeyboardEvent.LEFT_ARROW||i==t.KeyboardEvent.DOWN_ARROW&&r||i==t.KeyboardEvent.UP_ARROW&&!r)&&(s=0==n?a[a.length-1]:a[n-1]),s},F.prototype.getKeyboardBoundingBox=function(e){var i=this.getDisplayables();return i[0]?i[0].getDimensions(e):new t.Rectangle(0,0,0,0)},F.prototype.getTargetElem=function(){var t=this.getDisplayables();return t[0]?t[0].getElem():null},F.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect()},F.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()},F.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},F.prototype.isDragAvailable=function(t){return!0},F.prototype.getDragTransferable=function(t,e){return[this.getId()]},F.prototype.getDragFeedback=function(t,e){if(this._chart.isSelectionSupported()&&this._chart.getSelectionHandler().getSelectedCount()>1){for(var i=this._chart.getSelectionHandler().getSelection(),r=[],a=0;a<i.length;a++)r=r.concat(i[a].getDisplayables());return r}return this.getDisplayables()},F.prototype.getExplode=function(){return this._explode},F.prototype.setExplode=function(t){this._explode=t,this._explodeSlice()},F.prototype.getCustomLabel=function(){return this._customLabel},F.prototype.getSeriesLabel=function(){return this._seriesLabel},F.prototype.getFillColor=function(){return this._fillColor},F.prototype.getFillPattern=function(){return this._fillPattern},F.prototype.getStrokeColor=function(){return this._strokeColor},F.prototype.getBorderWidth=function(){return this._borderWidth},F.prototype.getSliceGaps=function(){return 0==this._depth?3*et.getDataItemGaps(this._chart):0},F.prototype.getInnerRadius=function(){return this._pieChart.getInnerRadius()},F.prototype.getTooltip=function(){return null==this._seriesIndex?rt.getOtherSliceDatatip(this._chart,this._value,!0):rt.getDatatip(this._chart,this._seriesIndex,0,null,!0)},F.prototype.isDrillable=function(){return this._drillable},F.createFillerSlice=function(t,e){var i=new F(t);return i._value=e,i._bFillerSlice=!0,i._centerX=t.getCenter().x,i._centerY=t.getCenter().y,i._fillColor="rgba(255,255,255,0)",i._strokeColor="rgba(255,255,255,0)",i._id=new s(null,null,null,null),i},F.prototype.getSeriesIndex=function(){return this._seriesIndex};var N=function(){};t.Obj.createSubclass(N,t.Obj),N.createAnimation=function(e,i,r){var a=[];if(at.isBLAC(e))N._animBarLineArea(e,r,a);else if(at.isScatterBubble(e)||at.isFunnel(e)||at.isPyramid(e))N._animBubbleScatterFunnelPyramid(e,r,a);else if(at.isPie(e)&&e.pieChart)return e.pieChart.getDisplayAnimation();return a.length>0?new t.ParallelPlayable(e.getCtx(),a):null},N._animBarLineArea=function(e,i,r){var a=e.getChartObjPeers(),n=a?a.length:0;if(n)for(var s,o,l,h=0;h<n;h++){s=(o=a[h]).getDisplayables()[0];var u=et.getSeriesType(o.getChart(),o.getSeriesIndex());if(l=null,s instanceof b||s instanceof P||s instanceof T||s instanceof M)l=s.getDisplayAnimation(i);else if(s instanceof O)l="line"==u?N._getLinePlayable(e,s,i):N._getAreaPlayable(e,s,i);else if(s instanceof t.SimpleMarker||s instanceof L){if(s instanceof D&&!s.isSelected())continue;l=new t.AnimFadeIn(e.getCtx(),s,i-.8,.8)}l&&r.push(l)}},N._animBubbleScatterFunnelPyramid=function(e,i,r){var a=e.getObjects(),n=a?a.length:0;if(n)for(var s,o,l=0;l<n;l++)(s=a[l].getDisplayables()[0])instanceof t.SimpleMarker?o=new t.AnimPopIn(e.getCtx(),s,!0,i):(s instanceof R||s instanceof B)&&(o=N._getFunnelPyramidPlayable(e,s,i)),o&&r.push(o)},N._getAreaPlayable=function(e,i,r){var a,n=e.getCtx(),s=i.getBaseline();if(i.isArea()){for(var o=i.getBaseCoords(),l=i.getBaseAnimationParams(),h=l.slice(0),u=0;u<l.length;u++)u%4!=1&&u%4!=2||(l[u]=s);i.setBaseAnimationParams(l),(a=new t.CustomAnimation(n,i,r)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getBaseAnimationParams,i.setBaseAnimationParams,h)}var g=i.getCoords(),d=i.getAnimationParams(),c=d.slice(0);for(u=0;u<d.length;u++)u%4!=1&&u%4!=2||(d[u]=s);i.setAnimationParams(d);var p=new t.CustomAnimation(n,i,r);p.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,c);var _=new t.ParallelPlayable(e.getCtx(),a,p);return _.setOnEnd(function(){i.setCoords(g,o)}),_},N._getFunnelPyramidPlayable=function(e,i,r){var a=e.getCtx(),n=i.getAnimationParams(),s=n.slice(0),o=n.slice(0);n[0]=0,at.isFunnel(e)&&(n[2]=0,s[2]=0),i.setAnimationParams(n);var l=new t.CustomAnimation(a,i,r/2);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,s);var h=new t.CustomAnimation(a,i,r/2);return h.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,o),new t.SequentialPlayable(a,[l,h])},N._getLinePlayable=function(e,i,r){var a=i.getCoords(),n=i.getAnimationParams(),s=n.slice(0);N._getMeanPoints(n),i.setAnimationParams(n);var o=new t.CustomAnimation(e.getCtx(),i,r);return o.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,s),o.setOnEnd(function(){i.setCoords(a)}),o},N._getMeanPoints=function(t){var e,i=0,r=Number.MAX_VALUE,a=Number.MIN_VALUE,n=t.length;for(e=0;e<n;e++){var s=t[e];e%4!=0&&e%4!=3&&s!=1/0&&(s<r&&(r=s),s>a&&(a=s),i+=s)}for(n>8?(i-=2*r,i-=2*a,i/=n/2-4):i/=n/2,e=0;e<n;e++)e%4!=1&&e%4!=2||(t[e]=i)};var H=function(){};t.Obj.createSubclass(H,t.Obj),H.createAnimation=function(e,i,r,a,n){if(!H._canAnimate(e,i))return null;var s,o=i.getCtx(),l=[],h=[];at.isPie(i)?(l.push(e.pieChart),h.push(i.pieChart)):H._buildAnimLists(o,l,e,h,i,a);var u=new t.DataAnimationHandler(o,n);u.constructAnimation(l,h),u.getNumPlayables()>0&&(s=u.getAnimation(!0));var g=i.getDataLabels();if(s&&g.length>0){for(var d=0;d<g.length;d++)g[d].setAlpha(0);s=new t.SequentialPlayable(o,s,new t.AnimFadeIn(o,g,a/4))}return s},H._buildAnimLists=function(e,i,r,a,n,s){var o,l,h,u,g,d=r.getChartObjPeers(),c=i,p=n.getCache().getFromCache("dataFiltered");for(o=0;o<2;o++){var _={},f={};for(l=0;l<d.length;l++){if(g=null,(u=(h=d[l]).getDisplayables()[0])instanceof R)g=new Z(h,s);else if(u instanceof B)g=new K(h,s);else if(u instanceof b||u instanceof P){if(g=new V(h,s),p){var v=h.getSeries();_[v]=_[v]?_[v]+1:1,g.setId(v+"/"+_[v]+"/bar")}}else if(u instanceof O){var m=(g=new Y(h,s)).getId();f[m]=f[m]?f[m]+1:1,g.setId(m+"/"+f[m])}else if(u instanceof t.SimpleMarker){if(u instanceof D&&!u.isSelected())continue;g=new W(h,s)}else if(u instanceof L){if(u.isInvisible()&&!u.isSelected())continue;g=new z(h,s)}else u instanceof T?g=new U(h,s):u instanceof M&&(g=new j(h,s));g&&(c.push(g),g.setOldChart(r))}c=a,d=n.getChartObjPeers()}},H._canAnimate=function(t,e){return at.isPie(t)&&at.isPie(e)?t&&e:at.isPolar(t)==at.isPolar(e)&&(!(!at.isBLAC(t)||!at.isBLAC(e))||(!(!at.isScatterBubble(t)||!at.isScatterBubble(e))||t.getType()==e.getType()))};var G=function(e){this.Options=e.Options,this.Peers=e.Peers,this.SeriesStyleArray=e.SeriesStyleArray,this.Cache=e.Cache,this.pieChart=e.pieChart,this._optionsCache=new t.BaseComponentCache,this._cache=new t.BaseComponentCache};t.Obj.createSubclass(G,t.Chart),G.prototype.getCache=function(){return this._cache},G.prototype.getOptionsCache=function(){return this._optionsCache};var U=function(t,e){this.Init(t,e)};t.Obj.createSubclass(U,t.Obj),U.prototype.animateUpdate=function(t,e){var i=e._shape;this._shape&&this._shape.getUpdateAnimation&&t.add(this._shape.getUpdateAnimation(this._updateDuration,i),1)},U.prototype.animateInsert=function(e){if(this._shape&&this._shape.getInsertAnimation)e.add(this._shape.getInsertAnimation(this._insertDuration),2);else{var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,0)}},U.prototype.animateDelete=function(e,i){if(i.addChild(this._shape),this._shape&&this._shape.getDeleteAnimation)e.add(this._shape.getDeleteAnimation(this._deleteDuration),0);else{var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)}},U.prototype.getId=function(){return this._animId},U.prototype.setId=function(t){this._animId=t},U.prototype.Init=function(t,e){this._peer=t,this._updateDuration=.75*e,this._insertDuration=.5*e,this._deleteDuration=.5*e,this._shape=t.getDisplayables()[0],this._animId=t.getDataItemId()||t.getSeries()+"/"+t.getGroup()},U.prototype.setOldChart=function(t){this._oldChart=t};var V=function(t,e){this.Init(t,e)};t.Obj.createSubclass(V,U),V.prototype.Init=function(t,e){V.superclass.Init.call(this,t,e),this._indicator=null,this._animId+="/bar"},V.prototype.animateInsert=function(t){var e=this._shape.getInsertAnimation(this._insertDuration);t.add(e,2)},V.prototype.animateDelete=function(t,e){e.addChild(this._shape);var i=this._shape.getDeleteAnimation(this._deleteDuration);t.add(i,0)},V.prototype.animateUpdate=function(e,i){var r=this._oldChart,a=this._peer.getChart(),n=at.isHorizontal(r)!=at.isHorizontal(a),s=i._getAnimationParams(n),o=this._getAnimationParams(),l=i._shape.getPrimaryFill(),h=this._shape.getPrimaryFill(),u=i._shape.isSelected()||this._shape.isSelected()||l.equals(h);if(!t.ArrayUtils.equals(s,o)||!l.equals(h)){var g=this._peer.getSeriesIndex(),d=i._peer.getSeriesIndex(),c=this._peer.getGroupIndex(),p=i._peer.getGroupIndex();"none"!==et.getAnimationIndicators(a)&&(this._indicator=X.makeIndicator(r,d,p,a,g,c)),this._setAnimationParams(s),u||this._shape.setFill(l);var _=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);_.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,o),u||_.getAnimator().addProp(t.Animator.TYPE_FILL,this._shape,this._shape.getFill,this._shape.setFill,h),this._indicator&&(_.setOnEnd(this._onEndAnimation,this),this._indicator.setAlpha(0)),e.add(_,1)}},V.prototype._getAnimationParams=function(t){return this._shape.getAnimationParams(t)},V.prototype._setAnimationParams=function(t){this._shape.setAnimationParams(t,this._indicator)},V.prototype._onEndAnimation=function(){this._indicator&&(this._indicator.getParent().removeChild(this._indicator),this._indicator=null)};var j=function(t,e){this.Init(t,e)};t.Obj.createSubclass(j,U),j.prototype.Init=function(t,e){j.superclass.Init.call(this,t,e),this._animId+="/boxAndWhisker"};var Y=function(t,e){this.Init(t,e)};t.Obj.createSubclass(Y,U),Y.prototype.animateUpdate=function(e,i){this._baseCoords=this._shape.getBaseCoords(),this._coords=this._shape.getCoords();var r,a,n=this._shape.isArea(),s=this._oldChart,o=this._chart,l=this._peer.getSeriesIndex(),h=i._peer.getSeriesIndex(),u=this._shape.getCommonGroupIndices(i._shape),g=i._shape.getCommonGroupIndices(this._shape);if(n){var d=i._getBaseAnimationParams(this._shape),c=this._getBaseAnimationParams(i._shape);Y._matchGroupIndices(d,c),t.ArrayUtils.equals(d,c)||(this._setBaseAnimationParams(d),(r=new t.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getBaseAnimationParams,this._setBaseAnimationParams,c))}var p=i._getAnimationParams(this._shape),_=this._getAnimationParams(i._shape);Y._matchGroupIndices(p,_),t.ArrayUtils.equals(p,_)||(this._setAnimationParams(p),(a=new t.CustomAnimation(this._context,this,this._updateDuration)).getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this._getAnimationParams,this._setAnimationParams,_));var f=et.getSeriesType(this._peer.getChart(),l);if("none"!==et.getAnimationIndicators(o)&&(!n||"lineWithArea"!=f))for(var v,m,S=0;S<u.length;S++)v=X.getDirection(s,h,g[S],o,l,u[S]),(m=X.makeIndicator(s,h,g[S],o,l,u[S]))&&this._shape.addIndicator(u[S],v,m);if(r||a){var C=new t.ParallelPlayable(this._context,r,a);C.setOnEnd(this._onAnimationEnd,this),e.add(C,1)}},Y.prototype.animateInsert=function(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._context,this._shape,this._insertDuration);e.add(i,2)},Y.prototype.animateDelete=function(e,i){var r;if("area"==et.getSeriesType(this._oldChart,this._peer.getSeriesIndex())){var a=this._chart.__getAreaContainer();if(this._deletedAreas=this._shape.getParent().getParent(),!a)return;a.addChild(this._deletedAreas),(r=new t.AnimFadeOut(this._context,this._deletedAreas,this._deleteDuration)).setOnEnd(this._removeDeletedAreas,this),e.add(r,0)}else i.addChild(this._shape),r=new t.AnimFadeOut(this._context,this._shape,this._deleteDuration),e.add(r,0)},Y.prototype._removeDeletedAreas=function(){var t=this._chart.__getAreaContainer();t&&t.removeChild(this._deletedAreas)},Y.prototype._getAnimationParams=function(t){return this._shape.getAnimationParams(t)},Y.prototype._setAnimationParams=function(t){this._shape.setAnimationParams(t)},Y.prototype._getBaseAnimationParams=function(t){return this._shape.getBaseAnimationParams(t)},Y.prototype._setBaseAnimationParams=function(t){this._shape.setBaseAnimationParams(t)},Y.prototype._onAnimationEnd=function(){this._shape.removeIndicators(),this._shape.setCoords(this._coords,this._baseCoords)},Y._matchGroupIndices=function(t,e){for(var i=3;i<t.length;i+=4)t[i]=e[i]},Y.prototype.Init=function(t,e){Y.superclass.Init.call(this,t,e),this._context=this._shape.getCtx(),this._chart=this._peer.getChart(),this._animId+="/"+(this._shape.isArea()?"area":"line")};var W=function(t,e){this.Init(t,e)};t.Obj.createSubclass(W,U),W.prototype.animateUpdate=function(e,i){var r=i._shape.getCenterDimensions(),a=this._shape.getCenterDimensions();if(!a.equals(r)){this._shape.setCenterDimensions(r);var n=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);n.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,this._shape,this._shape.getCenterDimensions,this._shape.setCenterDimensions,a);var s=this._peer.getChart();if(this.isValueChange(i)&&"none"!=et.getAnimationIndicators(s)&&at.isScatterBubble(s)){var o=i._shape;o.setSolidFill("#FFFF2B",.9),o.setCenterDimensions(r),this._peer.getChart().getPlotArea().addChild(o),n.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,o,o.getCenterDimensions,o.setCenterDimensions,a),n.getAnimator().addProp(t.Animator.TYPE_NUMBER,o,o.getAlpha,o.setAlpha,0),this._overlay=o,n.setOnEnd(this._onEndAnimation,this)}e.add(n,1)}},W.prototype.animateInsert=function(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,2)},W.prototype.animateDelete=function(e,i){i.addChild(this._shape);var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)},W.prototype.isValueChange=function(t){var e=!1;if(t){var i=t._peer.getSeriesIndex(),r=t._peer.getGroupIndex(),a=this._peer.getSeriesIndex(),n=this._peer.getGroupIndex(),s=t._oldChart.getOptions(),o=this._peer.getChart().getOptions(),l=s.series[i].items[r].x,h=s.series[i].items[r].y,u=s.series[i].items[r].z,g=o.series[a].items[n].x,d=o.series[a].items[n].y,c=o.series[a].items[n].z;e=g!==l||d!==h||c!==u}return e},W.prototype._onEndAnimation=function(){this._overlay&&(this._peer.getChart().getPlotArea().removeChild(this._overlay),this._overlay=null)},W.prototype.Init=function(t,e){W.superclass.Init.call(this,t,e),this._animId+="/marker"};var z=function(t,e){this.Init(t,e)};t.Obj.createSubclass(z,U),z.prototype.Init=function(t,e){z.superclass.Init.call(this,t,e),this._animId+="/rangeMarker"},z.prototype.animateInsert=function(e){this._shape.setAlpha(0);var i=new t.AnimFadeIn(this._shape.getCtx(),this._shape,this._insertDuration);e.add(i,2)},z.prototype.animateDelete=function(e,i){i.addChild(this._shape);var r=new t.AnimFadeOut(this._shape.getCtx(),this._shape,this._deleteDuration);e.add(r,0)},z.prototype.animateUpdate=function(e,i){var r=i._shape.getAnimationParams(),a=this._shape.getAnimationParams();this._shape.setAnimationParams(r);var n=new t.CustomAnimation(this._shape.getCtx(),this,this._updateDuration);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this._shape,this._shape.getAnimationParams,this._shape.setAnimationParams,a),e.add(n,1)};var X=new Object;t.Obj.createSubclass(X,t.Obj),X.DIR_UP=0,X.DIR_DOWN=1,X.DIR_NOCHANGE=2,X.makeIndicator=function(t,e,i,r,a,n){if(at.isPolar(r))return null;var s=X.getDirection(t,e,i,r,a,n);if(s==X.DIR_NOCHANGE)return null;var o=s===X.DIR_DOWN,l=o?et.getAnimationDownColor(r):et.getAnimationUpColor(r),h=X._drawIndicator(r.getCtx(),o,at.isHorizontal(r),l);return r.getPlotArea().addChild(h),h},X.getDirection=function(t,e,i,r,a,n){var s=Q.getValue(t,e,i),o=Q.getValue(r,a,n);return null==o||null==s||o==s?X.DIR_NOCHANGE:o>s?X.DIR_UP:X.DIR_DOWN},X._drawIndicator=function(e,i,r,a){var n;r?n=(t.Agent.isRightToLeft(e)?!i:i)?"M3.5,-5L3.5,5L-3.5,0L3.5,-5":"M-3.5,-5L-3.5,5L3.5,0L-3.5,-5":n=i?"M-5,-3.5L5,-3.5L0,3.5L-5,-3.5Z":"M-5,3.5L5,3.5L0,-3.5L-5,3.5Z";var s=new t.Path(e,n);return s.setSolidFill(a),s};var Z=function(t,e){this.Init(t,e)};t.Obj.createSubclass(Z,U),Z.prototype.animateUpdate=function(e,i){var r=this._shape,a=i._shape.getAnimationParams(),n=r.getAnimationParams(),s=i._shape.getFill(),o=this._shape.getFill();if(!t.ArrayUtils.equals(a,n)||!s.equals(o)){r.setAnimationParams(a);var l=new t.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,n),s.equals(o)||(this._shape.setFill(s),l.getAnimator().addProp(t.Animator.TYPE_FILL,r,r.getFill,r.setFill,o)),this._indicator&&l.setOnEnd(this._onEndAnimation,this),e.add(l,1)}},Z.prototype.animateInsert=function(e){var i=this._shape,r=i.getAnimationParams(),a=r.slice(0);a[0]+=a[1]/2,a[1]=0,a[3]=0,i.setAnimationParams(a);var n=new t.CustomAnimation(i.getCtx(),this,this._insertDuration);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,r),e.add(n,2)},Z.prototype.animateDelete=function(e,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var a=r.getAnimationParams(),n=a.slice(0);n[0]+=a[1]/2,n[1]=0,n[3]=0;var s=new t.CustomAnimation(r.getCtx(),this,this._deleteDuration);s.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,n),e.add(s,0)},Z.prototype.Init=function(t,e){Z.superclass.Init.call(this,t,e),this._animId+="/funnel"};var K=function(t,e){this.Init(t,e)};t.Obj.createSubclass(K,U),K.prototype.animateUpdate=function(e,i){var r=this._shape,a=i._shape.getAnimationParams(),n=r.getAnimationParams(),s=i._shape.getPrimaryFill(),o=this._shape.getPrimaryFill();if(!t.ArrayUtils.equals(a,n)||!s.equals(o)){r.setAnimationParams(a);var l=new t.CustomAnimation(r.getCtx(),this,this._updateDuration);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,n),s.equals(o)||(this._shape.setFill(s),l.getAnimator().addProp(t.Animator.TYPE_FILL,r,r.getFill,r.setFill,o)),e.add(l,1)}},K.prototype.animateInsert=function(e){var i=this._shape,r=i.getAnimationParams(),a=r.slice(0);a[1]=0,a[2]=0,i.setAnimationParams(a);var n=new t.CustomAnimation(i.getCtx(),this,this._insertDuration);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,i,i.getAnimationParams,i.setAnimationParams,r),e.add(n,2)},K.prototype.animateDelete=function(e,i){var r=this._shape;i.setClipPath(null),i.addChild(r);var a=r.getAnimationParams().slice(0);a[1]=0,a[2]=0;var n=new t.CustomAnimation(r.getCtx(),this,this._deleteDuration);n.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimationParams,r.setAnimationParams,a),e.add(n,0)},K.prototype.Init=function(t,e){K.superclass.Init.call(this,t,e),this._animId+="/pyramid"};var q=new Object;t.Obj.createSubclass(q,t.Obj),q.getXAxisPosition=function(e){return at.isPolar(e)?"tangential":at.isHorizontal(e)?t.Agent.isRightToLeft(e.getCtx())?"right":"left":"bottom"},q.getBaselineScaling=function(t,e){var i=e+"Axis",r=t.getOptions()[i].baselineScaling;return!r||"zero"!=r&&"min"!=r?at.isStock(t)?"min":"zero":r},q.getYAxisPosition=function(e){var i=e.getOptions().yAxis.position;return at.isPolar(e)?"radial":at.isHorizontal(e)?!i||"top"!=i&&"bottom"!=i?"bottom":i:(at.isStock(e)&&(i=i||"end"),t.Agent.isRightToLeft(e.getCtx())?i&&"end"==i?"left":"right":i&&"end"==i?"right":"left")},q.getY2AxisPosition=function(e){var i=e.getOptions().y2Axis.position;return at.isHorizontal(e)?!i||"top"!=i&&"bottom"!=i?"top":i:t.Agent.isRightToLeft(e.getCtx())?i&&"start"==i?"right":"left":i&&"start"==i?"left":"right"},q.hasTimeAxis=function(t){return at.isBLAC(t)&&"disabled"!=q.getTimeAxisType(t)},q.hasGroupAxis=function(t){return at.isBLAC(t)&&"disabled"==q.getTimeAxisType(t)},q.getTimeAxisType=function(t){var e=t.getOptions().timeAxisType;return e&&"auto"!=e&&at.isBLAC(t)&&!at.isPolar(t)?e:at.isStock(t)?"skipGaps":"disabled"},q.isMixedFrequency=function(t){return"mixedFrequency"==q.getTimeAxisType(t)},q.getAxisOffset=function(t){var e=t.getCache().getFromCache("axisOffset");if(null!=e)return e;var i=t.getOptions().styleDefaults.groupSeparators;if(q.hasGroupAxis(t)&&Q.getNumLevels(t)>1&&"on"==i.rendered)e=.5;else if(at.hasBarSeries(t)||at.hasCenteredSeries(t)||at.hasCandlestickSeries(t)||at.hasBoxPlotSeries(t)||at.isBLAC(t)&&1==Q.getGroupCount(t))e=.5;else if(at.isSpark(t)||J.isScrollable(t)||at.isOverview(t))e=0;else{var r=at.isHorizontal(t)?.2:.5;e=r-r/Math.sqrt(Q.getGroupCount(t))}return t.getCache().putToCache("axisOffset",e),e},q.isGridShifted=function(t){if(!at.isBLAC(t))return!1;if(Q.getNumLevels(t)>1)return!0;for(var e=Q.getSeriesCount(t),i=0;i<e;i++)if(et.isSeriesRendered(t,i)){var r=et.getSeriesType(t,i),a=et.getLineType(t,i);if("bar"!=r&&"centeredSegmented"!=a&&"centeredStepped"!=a)return!1}return!0},q.isGridPolygonal=function(t){return!(!at.isBLAC(t)||at.hasBarSeries(t))&&"polygon"==t.getOptions().polarGridShape},q.isAxisRendered=function(t,e){if("y"==e&&at.hasY2DataOnly(t))return!1;if("y2"==e&&!at.hasY2Data(t))return!1;var i=t.getOptions()[e+"Axis"];return"off"!=i.rendered&&!("off"==i.tickLabel.rendered&&!i.title)},q.isAxisLineRendered=function(t,e){var i=t.getOptions()[e+"Axis"];return"off"!=i.rendered&&"off"!=i.axisLine.rendered&&!("auto"==i.axisLine.rendered&&"x"!=e&&at.isBLAC(t)&&!at.isPolar(t))},q.isMajorTickRendered=function(t,e){var i=t.getOptions()[e+"Axis"];return"off"!=i.rendered&&"off"!=i.majorTick.rendered&&!("auto"==i.majorTick.rendered&&"x"==e&&at.isBLAC(t)&&!at.isPolar(t))},q.isMinorTickRendered=function(t,e){var i=t.getOptions()[e+"Axis"];return"off"!=i.rendered&&"off"!=i.minorTick.rendered&&("on"==i.minorTick.rendered||q.isLog(t,e))},q.isLog=function(t,e){return"log"==t.getOptions()[e+"Axis"].scale},q.getTickLabelHeight=function(e,i){var r=e.getOptions(),a=r[i+"Axis"].tickLabel.style;return a instanceof t.CSSStyle||(a=new t.CSSStyle(a)),a.mergeUnder(h.getDefaults(r.skin).tickLabel.style),t.TextUtils.getTextStringHeight(e.getCtx(),a)},q.getTickLabelGapSize=function(t,e){if(q.isTickLabelInside(t,e))return 0;var i=t.getOptions(),r=at.isHorizontal(t),a=q.getGapScalingFactor(t,e),n=Math.ceil(i.layout.tickLabelGapWidth*a),s=Math.ceil(i.layout.tickLabelGapHeight*a);return"x"==e?r?n:s:r?s:n},q.getGapScalingFactor=function(t,e){return q.isAxisRendered(t,e)?q.getTickLabelHeight(t,e)/14:0},q.isTickLabelInside=function(t,e){return!(at.isPolar(t)||at.isScatterBubble(t)||at.isBLAC(t)&&"x"==e)&&"inside"==t.getOptions()[e+"Axis"].tickLabel.position},q.getXAxisViewportMinMax=function(t,e){var i=e?"xAxisViewportMinMaxUG":"xAxisViewportMinMax",r=t.getCache().getFromCache(i);if(r)return r;var a=t.getOptions().xAxis,n=q.hasGroupAxis(t),s=q.getAxisOffset(t);if(e)var o=q.getXAxisGlobalMinMax(t);var l=null;null!=a.viewportMin?l=a.viewportMin:null!=a.viewportStartGroup?l=n?Q.getGroupIndex(t,a.viewportStartGroup)-s:a.viewportStartGroup:e&&(l=o.min);var h=null;return null!=a.viewportMax?h=a.viewportMax:null!=a.viewportEndGroup?h=n?Q.getGroupIndex(t,a.viewportEndGroup)+s:a.viewportEndGroup:e&&(h=o.max),r={min:l,max:h},t.getCache().putToCache(i,r),r},q.getXAxisGlobalMinMax=function(t){var e=t.getOptions().xAxis,i=q.hasGroupAxis(t),r=q.getAxisOffset(t);if(!i)var a=Q.getMinMaxValue(t,"x");return{min:null!=e.min?e.min:i?0-r:a.min,max:null!=e.max?e.max:i?Q.getGroupCount(t)-1+r:a.max}},q.applyInitialZooming=function(t,e){var i=t.getOptions(),r=i.xAxis,a=i.initialZooming;if(at.isBLAC(t)&&"off"!=i.zoomAndScroll&&"none"!=a){i._initialZoomed&&("last"==a?r.viewportMin=null:r.viewportMax=null);var n=q.getXAxisViewportMinMax(t,!1),s=n.min,o=n.max;if(!("last"==a&&null!=s||"first"==a&&null!=o)){var l=at.isHorizontal(t)?e.h:e.w,h=Math.floor(l/(2*q.getTickLabelHeight(t,"x")))+q.getAxisOffset(t),u=Q.getGroupCount(t)-1;if(!(u<=h)){var g,d;if(q.hasGroupAxis(t))g=0,d=u;else{var c=Q.getMinMaxValue(t,"x");g=c.min,d=c.max}var p=h/u*(d-g);"last"==i.initialZooming?(null==o&&(o=d),r.viewportMin=Math.max(o-p,g)):(null==s&&(s=g),r.viewportMax=Math.min(s+p,d)),i._initialZoomed=!0}}}},q.getGroupWidthRatios=function(t){if(!at.hasBarSeries(t)&&!at.hasCandlestickSeries(t)&&!at.hasBoxPlotSeries(t))return null;var e=t.getOptions(),i=et.getBarGapRatio(t);if(i>=1)return e._averageGroupZ=1/0,null;e._averageGroupZ=0;var r,a,n,s,o,l,h=Q.getGroupCount(t),u=at.isSplitDualY(t),g=Q.getStackCategories(t,"bar"),d=g.y.length,c=g.y2.length;if(t.getOptionsCache().getFromCache("hasConstantZValue")){var p=t.getOptionsCache().getFromCache("constantZValue")*(u?Math.max(d,c):d+c);l=(o=p*h)*i/(1-i),r=null}else{for(var _=[],f=0;f<h;f++){for(a=0,s=0;s<d;s++)a+=Q.getBarCategoryZ(t,g.y[s],f,!1);for(n=0,s=0;s<c;s++)n+=Q.getBarCategoryZ(t,g.y2[s],f,!0);_.push(u?Math.max(a,n):a+n)}o=_.reduce(function(t,e){return t+e}),l=o*i/(1-i),r=_.map(function(t){return t+l/h})}return e._averageGroupZ=(o+l)/h,r},q.isYAdjustmentNeeded=function(t){var e=t.getOptions().styleDefaults.dataLabelPosition,i=t.getOptionsCache().getFromCache("hasDataOutsideBarEdge"),r="outsideBarEdge"==e||i,a=et.isStackLabelRendered(t);return!(!at.hasBarSeries(t)||!r&&!a)},q.axisContainsPoint=function(t,e){if(!t)return!1;var i=t.getOptions().position,r="top"==i||"bottom"==i,a=r?4:10,n=r?10:4,s=t.__getBounds().clone();s.x-=n,s.y-=a,s.w+=2*n,s.h+=2*a;var o=t.stageToLocal(e);return s.containsPoint(o.x,o.y)};var Q=new Object;t.Obj.createSubclass(Q,t.Obj),Q.hasData=function(t){var e=t.getOptions();if(!e||!e.series||e.series.length<1)return!1;for(var i=Q.getSeriesCount(t),r=0;r<i;r++){var a=Q.getSeriesItem(t,r);if(a&&a.items&&a.items.length>=1)return!0}return!1},Q.hasInvalidData=function(t){return!Q.hasData(t)||Q.hasInvalidTimeData(t)},Q.hasInvalidTimeData=function(t){if(at.isFunnel(t)||at.isPie(t)||at.isPyramid(t))return!1;var e,i,r=t.getOptions(),a=Q.getGroupCount(t);if(!r||!r.series||r.series.length<1)return!0;if(a<1)return!0;var n=Q.getSeriesCount(t);if(q.isMixedFrequency(t))for(e=0;e<n;e++)for(i=0;i<a;i++){var s=Q.getDataItem(t,e,i);if(s&&(null==s.x||isNaN(s.x)))return!0}else if(q.hasTimeAxis(t))for(i=0;i<a;i++){var o=Q.getGroup(t,i);if(null==o||isNaN(o))return!0}return!1},Q.hasSeriesData=function(t,e){var i=Q.getSeriesItem(t,e).items;if(i)for(var r=0;r<i.length;r++)if(null!=i[r])return!0;return!1},Q.processDataObject=function(e){if(Q.hasData(e)){var i=e.getOptions(),r=e.getOptionsCache(),a=Q.getSeriesCount(e);at.isValidType(e)||(i.type="bar");var n=!1,s=!1,o=!0,l=null,h=!1,u=!1,g=!1,d=at.isStock(e);d&&a>1&&(i.series=i.series.slice(0,1),a=1);var c=q.isMixedFrequency(e),p=a>100;r.putToCache("hasLargeSeriesCount",p);for(var _=0,f=e.getSeriesStyleArray(),v=0;v<a;v++){var m=Q.getSeries(e,v);!p&&null!=m&&f.indexOf(m)<0&&f.push(m);var S=Q.getSeriesItem(e,v);if(S.items&&S.items.length>_&&(_=S.items.length),"hidden"==S.visibility){var C=et.getHiddenCategories(e);C.indexOf(m)<0&&C.push(m)}if(S.visibility=null,"on"==S.assignedToY2&&(n=!0),S&&S.items)for(var y=S.items,x=0;x<y.length;x++)null!=y[x]&&("object"!=typeof(O=y[x])&&(O={y:O},y[x]=O),c||null==O.x||(O.x=Number(O.x)),null!=O.y&&(O.y=Number(O.y),O.y<0&&(u=!0)),null!=O.z?(O.z=Number(O.z),null==l?l=O.z:l!=O.z&&(o=!1)):l=1,null!=O.value&&(O.value=Number(O.value),O.value<0&&(u=!0)),null!=O.targetValue&&(O.targetValue=Number(O.targetValue)),null!=O.open&&(O.open=Number(O.open),h=!0),null!=O.close&&(O.close=Number(O.close),h=!0,O.close<0&&(u=!0)),null!=O.low&&(O.low=Number(O.low),h=!0),null!=O.high&&(O.high=Number(O.high),h=!0),null!=O.volume&&(O.volume=Number(O.volume),s=!0),(O.color||O.borderColor||O.borderWidth||O.style||O.svgStyle||O.className||O.svgClassName)&&r.putToCachedMap("itemStyleSet",v,!0),"outsideBarEdge"==O.labelPosition&&(g=!0))}if(r.putToCache("hasVolume",s),r.putToCache("hasConstantZValue",o),r.putToCache("constantZValue",o?l:null),r.putToCache("hasLowHighSeries",h),r.putToCache("hasNegativeValues",u),r.putToCache("hasDataOutsideBarEdge",g),d&&Q.hasVolumeSeries(e)&&!at.isOverview(e)){var A=t.JsonUtils.clone(Q.getSeriesItem(e,0));A.assignedToY2="on",n=!0,A.type="bar",A.categories=Q.getCategories(e,0),A.id="_volume",A._selectable="off",A.items=[];for(var b=0;b<S.items.length;b++){var M={};M.color=et.getStockVolumeColor(e,0,b),M.x=S.items[b].x,M.value=S.items[b].volume,M.drilling="off",A.items.push(M)}i.series.push(A),r.putToCachedMap("itemStyleSet",i.series.length-1,!0)}r.putToCache("hasY2Assignment",n);for(var T=$.getRefObjs(e),I=0;I<T.length;I++){if(y=T[I].items)for(x=0;x<y.length;x++){var O;(O=y[x])&&("object"!=typeof O?y[x]=Number(O):(!q.isMixedFrequency(e)&&O.x&&(O.x=Number(O.x)),O.max&&(O.max=Number(O.max)),O.min&&(O.min=Number(O.min)),O.value&&(O.value=Number(O.value))))}}i.groups||(i.groups=new Array);var D=Q.getGroupCount(e);for(I=0;I<_-D;I++){var E=i.translations.labelDefaultGroupName||"Group {0}",P=t.ResourceUtils.format(E,[i.groups.length+1]);i.groups.push(P)}r.putToCache("groupsArray",null),Q._processTimeAxis(e);var L=i.sorting;if(L="on"==L?"descending":"ascending"!=L&&"descending"!=L?"off":L,at.isBLAC(e)&&q.hasGroupAxis(e)&&"off"!=L&&1==Q.getNumLevels(e)){var w=Q.getGroups(e),R={};for(x=0;x<w.length;x++){var B=0;for(I=0;I<=a;I++)if(et.isSeriesRendered(e,I)&&!Q.isAssignedToY2(e,I)){var k=Q.getValue(e,I,x);B+=null==k||isNaN(k)?0:k}R[w[x]]={index:x,total:B,group:i.groups[x]}}"ascending"==L?w.sort(function(t,e){return R[t].total-R[e].total}):w.sort(function(t,e){return R[e].total-R[t].total});for(I=0;I<a;I++){var F=[];for(x=0;x<w.length;x++)F.push(Q.getDataItem(e,I,R[w[x]].index));i.series[I].items=F}var N=[];for(x=0;x<w.length;x++)N.push(R[w[x]].group);i.groups=N,r.putToCache("groupsArray",null),r.putToCache("value",null)}Q._sanitizeAxis(i.xAxis),Q._sanitizeAxis(i.yAxis),Q._sanitizeAxis(i.y2Axis)}},Q._sanitizeAxis=function(t){t.min==t.max&&(t.min=null,t.max=null)},Q._sanitizeDateTime=function(t,e){var i=null,r=t.getLocaleHelpers().isoToDateConverter;if(r){try{i=r(e)}catch(t){i=null}i=null!=i&&i.getTime?i.getTime():null}return null==i&&(i=Date.parse(e)),isNaN(i)&&(i=Number(e)),i},Q._processTimeAxis=function(t){var e,i,r=t.getCtx(),a=t.getOptions(),n=Q.getSeriesCount(t),s=Q.getGroupCount(t);if(q.isMixedFrequency(t))for(e=0;e<n;e++)for(i=0;i<s;i++){var o=Q.getDataItem(t,e,i);null!=o&&"string"==typeof o.x&&null!=o.x&&(o.x=Q._sanitizeDateTime(r,o.x))}else if(q.hasTimeAxis(t)){for(i=0;i<s;i++){var l=Q.getGroup(t,i);null!=l&&(a.groups[i]=Q._sanitizeDateTime(r,l))}t.getOptionsCache().putToCache("groupsArray",null)}if(q.hasTimeAxis(t)){var h=a.xAxis;null!=h.dataMin&&(h.dataMin=Q._sanitizeDateTime(r,h.dataMin)),null!=h.dataMax&&(h.dataMax=Q._sanitizeDateTime(r,h.dataMax)),null!=h.min&&(h.min=Q._sanitizeDateTime(r,h.min)),null!=h.max&&(h.max=Q._sanitizeDateTime(r,h.max)),null!=h.viewportMin&&(h.viewportMin=Q._sanitizeDateTime(r,h.viewportMin)),null!=h.viewportMax&&(h.viewportMax=Q._sanitizeDateTime(r,h.viewportMax)),null!=h.viewportStartGroup&&(h.viewportStartGroup=Q._sanitizeDateTime(r,h.viewportStartGroup)),null!=h.viewportEndGroup&&(h.viewportEndGroup=Q._sanitizeDateTime(r,h.viewportEndGroup));for(var u=$.getRefObjs(t),g=0;g<u.length;g++){var d=u[g].items;if(d)for(var c=0;c<d.length;c++)d[c]&&null!=d[c].x&&(d[c].x=Q._sanitizeDateTime(r,d[c].x))}}},Q.isEqualId=function(e,i,r){return null!=e&&null!=i&&t.Obj.compareValues(r,e,i)},Q.getSeriesCount=function(t){var e=t.getOptions().series;return e?e.length:0},Q.getY2SeriesCount=function(t,e,i){for(var r=0,a=Q.getSeriesCount(t),n=0;n<a;n++)e&&et.getSeriesType(t,n)!=e||(i||et.isSeriesRendered(t,n))&&Q.isAssignedToY2(t,n)&&r++;return r},Q.getSeries=function(t,e){var i=Q.getSeriesItem(t,e);return i?i.id?i.id:i.name||""===i.name?i.name:String(e):null},Q.getSeriesLabel=function(t,e){var i=Q.getSeriesItem(t,e);return i&&(i.name||""===i.name)?i.name:null},Q.getSeriesIndex=function(t,e){for(var i=Q.getSeriesCount(t),r=0;r<i;r++){if(Q.getSeries(t,r)==e)return r}return-1},Q.getSeriesStyleIndex=function(t,e){if(t.getOptionsCache().getFromCache("hasLargeSeriesCount"))return e;var i=Q.getSeries(t,e);return null==i?e:t.getSeriesStyleArray().indexOf(i)},Q.getSeriesItem=function(t,e){if(isNaN(e)||null==e||e<0)return null;var i=t.getOptions();return i.series&&i.series.length>e?i.series[e]:void 0},Q.getDataItem=function(t,e,i){if(isNaN(i)||null==i||i<0)return null;var r=Q.getSeriesItem(t,e);return r&&r.items&&r.items.length>i?r.items[i]:null},Q.getDataItemId=function(t,e,i){var r=Q.getDataItem(t,e,i);return r?null!=r.id?r.id:Q.createDataItemId(Q.getSeries(t,e),Q.getGroup(t,i)):null},Q.createDataItemId=function(t,e){return t+"; "+e},Q.getNestedDataItem=function(t,e,i,r){if(isNaN(r)||null==r||r<0)return null;var a=Q.getDataItem(t,e,i);return a&&a.items&&a.items.length>r?a.items[r]:null},Q.getNestedDataItemCount=function(t,e,i){var r=Q.getDataItem(t,e,i);return r&&r.items?r.items.length:0},Q.getNestedDataItemId=function(t,e,i,r){var a=Q.getNestedDataItem(t,e,i,r);return a?null!=a.id?a.id:Q.getDataItemId(t,e,i)+"; "+String(r):null},Q.getNestedDataItemIndex=function(t,e,i,r){for(var a=Q.getNestedDataItemCount(t,e,i),n=0;n<a;n++){var s=Q.getNestedDataItemId(t,e,i,n);if(Q.isEqualId(s,r,t.getCtx()))return n}return-1},Q.getGroupCount=function(t){return Q._getGroupsArray(t).length},Q.getGroup=function(t,e){if(null!=e&&e>=0&&e<Q.getGroupCount(t)){var i=Q._getGroupsArray(t)[e];if(i)return null!=i.id?i.id:null!=i.name?i.name:String(e)}return null},Q.getGroupIndex=function(e,i){for(var r=Q.getGroups(e),a=0;a<r.length;a++)if(i instanceof Array&&r[a]instanceof Array?t.ArrayUtils.equals(i,r[a]):i===r[a])return a;return-1},Q.getGroupLabel=function(t,e){if(e>=0&&e<Q.getGroupCount(t)){var i=Q._getGroupsArray(t)[e];if(i)return null!=i.name?i.name:null!=i.id||"string"!=typeof i?"":i}return null},Q.getGroups=function(t){var e=t.getOptionsCache().getFromCache("groups");if(!e){var i=Q.getGroupCount(t);e=[];for(var r=0;r<i;r++)e.push(Q.getGroup(t,r));t.getOptionsCache().putToCache("groups",e)}return e},Q._getGroupsArray=function(t){var e=t.getOptions(),i=t.getOptionsCache().getFromCache("groupsArray");if(!i){i=[],e.groups&&(i=Q._getNestedGroups(e.groups,i));for(var r=0;r<i.length;r++)1==i[r].id.length&&(i[r].id=i[r].id[0],i[r].name=i[r].name[0]);t.getOptionsCache().putToCache("groupsArray",i)}return i},Q._getNestedGroups=function(t,e){if(!t||t&&0==t.length)return[];for(var i=0;i<t.length;i++){var r=t[i],a=null,n=null;if(null!=r&&(a=r.id?r.id:r.name?r.name:r,n=r.name?r.name:r),"object"==typeof a&&(a=null),"object"==typeof n&&(n=null),r&&r.groups){var s=Q._getNestedGroups(r.groups,[]);0==s.length&&s.push({id:[],name:[]});for(var o=0;o<s.length;o++)s[o].id.unshift(a),s[o].name.unshift(n);e=e.concat(s)}else e.push({id:[a],name:[n]})}return e},Q.getNumLevels=function(t){var e=t.getOptionsCache().getFromCache("groupsNumLevels");if(null!=e)return e;e=0;for(var i=Q._getGroupsArray(t),r=0;r<i.length;r++){var a=i[r];if(a&&a.id){var n=Array.isArray(a.id)?a.id.length:1;e=Math.max(e,n)}}return t.getOptionsCache().putToCache("groupsNumLevels",e),e},Q.getValue=function(t,e,i,r){var a,n="number"==typeof r&&r>=0;if(!n&&void 0!==(a=t.getOptionsCache().getFromCachedMap2D("value",e,i)))return a;var s=n?Q.getNestedDataItem(t,e,i,r):Q.getDataItem(t,e,i);return a=null,null!=s&&("object"!=typeof s?a=s:at.isStock(t)&&null!=s.close?a=s.close:null!=s.value?a=s.value:null!=s.y&&(a=s.y)),a=a||(0===a?0:null),n||t.getOptionsCache().putToCachedMap2D("value",e,i,a),a},Q.getCumulativeValue=function(t,e,i,r){if(!at.isStacked(t))return Q.getValue(t,e,i);var a=r?"cumValueH":"cumValue",n=t.getCache().getFromCachedMap2D(a,e,i);if(void 0!==n)return n;var s=et.getSeriesType(t,e),o=Q.isAssignedToY2(t,e),l=Q.getValue(t,e,i),h=Q.getStackCategory(t,e),u="bar"==s?l<0:Q.isSeriesNegative(t,e);n=0;for(var g=e;g>=0;g--)if((r||et.isDataItemRendered(t,g,i))&&s==et.getSeriesType(t,g)&&o==Q.isAssignedToY2(t,g)&&Q.getStackCategory(t,g)==h){var d=Q.getValue(t,g,i),c="bar"==s?d<0:Q.isSeriesNegative(t,g);if(u&&c||!u&&!c){var p=t.getCache().getFromCachedMap2D(a,g,i);if(void 0!==p){n=l+(p||0);break}n+=null==d||isNaN(d)?0:d}}return t.getCache().putToCachedMap2D(a,e,i,n),n},Q.getLowValue=function(t,e,i){var r=Q.getDataItem(t,e,i);return null==r?null:"candlestick"==et.getSeriesType(t,e)?null==r.low&&null!=r.close?null!=r.open?Math.min(r.close,r.open):r.close:r.low:null!=r.low&&null==r.close?r.low:null},Q.getHighValue=function(t,e,i){var r=Q.getDataItem(t,e,i);return null==r?null:"candlestick"==et.getSeriesType(t,e)?null==r.high?null!=r.open?Math.max(r.close,r.open):r.close:r.high:null!=r.high&&null==r.close?r.high:null},Q.getXValue=function(t,e,i){var r=Q.getDataItem(t,e,i);return Q.getXValueFromItem(t,r,i)},Q.getXValueFromItem=function(t,e,i){return null!=e&&null!=e.x?e.x:q.hasGroupAxis(t)?i:q.hasTimeAxis(t)&&!q.isMixedFrequency(t)?Q.getGroupLabel(t,i):null},Q.getTargetValue=function(t,e){var i=Q.getDataItem(t,e,0);return null==i||"object"!=typeof i?null:i.targetValue},Q.getZValue=function(t,e,i,r){var a=Q.getDataItem(t,e,i);return null==a||"object"!=typeof a?r:null!=a.z?Math.max(0,a.z):r},Q.isStockValueRising=function(t,e,i){var r=Q.getDataItem(t,e,i);return!r||r.open<=r.close},Q.getCategories=function(t,e,i,r){var a=Q.getNestedDataItem(t,e,i,r);if(a&&a.categories)return a.categories;var n=Q.getDataItem(t,e,i);if(n&&n.categories)return n.categories;var s=Q.getSeriesItem(t,e);if(s&&s.categories)return s.categories;var o=Q.getSeries(t,e);return null!=o?[o]:[]},Q.getViewportMinMaxGroupIndex=function(t,e){var i=q.getXAxisViewportMinMax(t,!0),r=q.hasGroupAxis(t),a=Q.getGroupCount(t),n=i.min,s=0;if(null!=n)if(r)s=Math.ceil(n);else for(var o=0;o<a;o++){if(Q.getXValue(t,e,o)>=n){s=o;break}}var l=i.max,h=a-1;if(null!=h)if(r)h=Math.floor(l);else for(o=a-1;o>=s;o--){if(Q.getXValue(t,e,o)<=l){h=o;break}}return{min:s,max:h}},Q.getViewportGroupCount=function(t){var e=q.getXAxisViewportMinMax(t,!0),i=q.getXAxisGlobalMinMax(t),r=(e.max-e.min)/(i.max-i.min);return isNaN(r)?1:r*Q.getGroupCount(t)},Q._computeYAlongLine=function(e,i,r,a,n,s){e&&(r=t.Math.log10(r),n=t.Math.log10(n));var o=r+(n-r)*(s-i)/(a-i);return e?Math.pow(10,o):o},Q.getMinMaxValue=function(t,e,i){var r=e+(i?"MinMaxDO":"MinMax"),a=t.getCache().getFromCache(r);if(a)return a;var n=t.getOptions()[e+"Axis"];if(null!=n.dataMax&&null!=n.dataMin&&i)return a={min:n.dataMin,max:n.dataMax},t.getCache().putToCache(r,a),a;var s=q.hasTimeAxis(t);if(null!=n.max&&null!=n.min&&!i&&!s)return a={min:n.min,max:n.max},t.getCache().putToCache(r,a),a;var o="z"!=e&&q.isLog(t,e),l="y2"==e;l&&(e="y");for(var h="y"==e,u=!i&&h&&at.isBLAC(t),g="withoutRescale"==J.getHideAndShowBehavior(t)||"x"==e&&q.hasTimeAxis(t),d=-1/0,c=1/0,p=Q.getSeriesCount(t),_=0;_<p;_++){var f=Q.getSeriesItem(t,_),v=et.getSeriesType(t,_),m=h&&(et.isRangeSeries(t,_)||"candlestick"==v||"boxPlot"==v);if(g||et.isSeriesRendered(t,_)){var S=Q.isAssignedToY2(t,_);if(!h||l==S){var C=f.items;if(C){var y=0,x=C.length-1;if(u){var A=Q.getViewportMinMaxGroupIndex(t,_);y=A.min,x=A.max}for(var b=y;b<=x;b++)if(g||et.isDataItemRendered(t,_,b)){var M=C[b],T=null;if(h?m||(T=Q.getCumulativeValue(t,_,b,g)):"x"==e&&s&&!q.isMixedFrequency(t)?(T=Q.getGroupLabel(t,b),null!=M&&(M.x=T)):null!=M&&(T=M[e]),!("z"==e&&T<=0)){if(!(m||null==T||"number"!=typeof T||o&&T<=0)){var I=0;at.isBubble(t)&&!i&&"z"!=e&&(I=nt.getBubbleAxisRadius(t,e,M.markerSize)),d=Math.max(d,o?T*Math.pow(10,I):T+I),c=Math.min(c,o?T/Math.pow(10,I):T-I)}if(m){var O=Q.getHighValue(t,_,b),D=Q.getLowValue(t,_,b);o&&(O<=0||D<=0)||(d=Math.max(d,O,D),c=Math.min(c,O,D))}if(u&&!m){var E=null,P=null;if(y>0&&b==y?(E=b-1,P=q.getXAxisViewportMinMax(t,!0).min):x<C.length-1&&b==x&&(E=b+1,P=q.getXAxisViewportMinMax(t,!0).max),null!=E){var L=Q.getXValue(t,_,b),w=Q.getXValue(t,_,E),R=Q.getCumulativeValue(t,_,E),B=Q._computeYAlongLine(o,L,T||0,w,R||0,P);d=Math.max(d,B),c=Math.min(c,B)}}}}}}}}var k=null;if("x"==e?k=$.getAxisRefObjs(t,"x"):l?k=$.getAxisRefObjs(t,"y2"):h&&(k=$.getAxisRefObjs(t,"y")),null!=k)for(var F=0;F<k.length;F++){var N=k[F],H=N.items,G="withRescale"==J.getHideAndShowBehavior(t)&&"hidden"==N.visibility;if(!G)if(H&&!G){var U=0,V=H.length-1;if(u){var j=$.getViewportMinMaxIndex(t,H);U=j.min,V=j.max}for(var Y=U;Y<=V;Y++)if(null!=H[Y]){D=$.getLowValue(H[Y]),O=$.getHighValue(H[Y]);var W=isNaN(H[Y])?H[Y].value:H[Y];null!=D&&isFinite(D)&&(c=Math.min(c,D),d=Math.max(d,D)),null!=O&&isFinite(O)&&(c=Math.min(c,O),d=Math.max(d,O)),null!=W&&isFinite(W)&&(c=Math.min(c,W),d=Math.max(d,W))}}else{D=$.getLowValue(N),O=$.getHighValue(N),W=N.value;null!=D&&isFinite(D)&&(c=Math.min(c,D),d=Math.max(d,D)),null!=O&&isFinite(O)&&(c=Math.min(c,O),d=Math.max(d,O)),null!=W&&isFinite(W)&&(c=Math.min(c,W),d=Math.max(d,W))}}return a={min:c,max:d},t.getCache().putToCache(r,a),a},Q.isAssignedToY2=function(t,e){if(!t.getOptionsCache().getFromCache("hasY2Assignment"))return!1;var i=Q.getSeriesItem(t,e);return!(!i||"on"!=i.assignedToY2||!at.isDualY(t))},Q.getInitialSelection=function(t){var e=t.getOptions().selection,i=null!=t.getOptions().data;e||(e=[]);for(var r=t.getChartObjPeers(),a=0;a<e.length;a++){var n=null==e[a].id||i?e[a]:e[a].id;if(null!=e[a].id||e[a].series||e[a].group||(e[a]={id:n}),!(null==n||e[a].series&&e[a].group))for(var s=0;s<r.length;s++){var o=r[s];if(Q.isEqualId(n,o.getDataItemId(),t.getCtx())){e[a].series=o.getSeries(),e[a].group=o.getGroup();break}}}return e},Q.getCurrentSelection=function(t){var e=[],i=t.getSelectionHandler();if(i)for(var r=i.getSelectedIds(),a=0;a<r.length;a++){var n=r[a];e.push({series:n.series,group:n.group,id:n.id})}return e},Q.hasVolumeSeries=function(t){var e=t.getOptionsCache().getFromCache("hasVolume");return e||!1},Q.isDataSelected=function(t,e,i,r){var a=!isNaN(r)&&null!=r&&r>=0?Q.getNestedDataItemId(t,e,i,r):Q.getDataItemId(t,e,i),n=Q.getSeries(t,e),s=Q.getGroup(t,i),o=t.getOptions().selection;o||(o=[]);for(var l=0;l<o.length;l++){if(Q.isEqualId(a,o[l],t.getCtx())||Q.isEqualId(a,o[l].id,t.getCtx()))return!0;if(null==o[l].id&&Q.isEqualId(n,o[l].series,t.getCtx())&&Q.isEqualId(s,o[l].group,t.getCtx()))return!0}return!1},Q.getDataLabel=function(t,e,i,r,a,n){var s,o=Q.getDefaultDataLabel(t,e,i,r,a,n),l=t.getOptions().dataLabel;if(l&&!n){var h=Q.getDataContext(t,e,i,r);if(h.label=o,"number"==typeof(s=l(h))){var u=rt.getValueFormat(t,"label");s=rt.formatValue(t,u,s)}}return s||o},Q.getDefaultDataLabel=function(t,e,i,r,a,n){var s;if(n)s=Q.getCumulativeValue(t,e,i);else{var o=!isNaN(r)&&null!=r&&r>=0?Q.getNestedDataItem(t,e,i,r):Q.getDataItem(t,e,i);if(!o)return null;s=o.label,"low"==a?s=s instanceof Array?s[0]:s:"high"==a&&(s=s instanceof Array?s[1]:null)}if(null!=s){if("number"==typeof s){var l,h,u,g=Q.isAssignedToY2(t,e)&&t.y2Axis?t.y2Axis:t.yAxis;if(g){var d=g.getInfo();l=d.getGlobalMin(),h=d.getGlobalMax(),u=d.getMajorIncrement()}var c=rt.getValueFormat(t,"label");return rt.formatValue(t,c,s,l,h,u)}return s}return null},Q.getStackCategory=function(t,e){var i=t.getCache().getFromCachedMap("stackCategory",e);return void 0!==i?i:(i=at.isStacked(t)?Q.getSeriesItem(t,e).stackCategory||null:Q.getSeries(t,e)||null,t.getCache().putToCachedMap("stackCategory",e,i),i)},Q.getStackCategories=function(t,e,i){var r=[],a=[],n={},s={},o=t.getCache().getFromCachedMap2D("stackCategories",e,i);if(o)return o;for(var l=Q.getSeriesCount(t),h=0;h<l;h++)if(et.isSeriesRendered(t,h)||i){if(e){var u=et.getSeriesType(t,h);if("candlestick"!=u&&"boxPlot"!=u||(u="bar"),e!=u)continue}var g=Q.getStackCategory(t,h);Q.isAssignedToY2(t,h)?s[g]||(a.push(g),s[g]=!0):n[g]||(r.push(g),n[g]=!0)}return o={y:r,y2:a},t.getCache().putToCachedMap2D("stackCategories",e,i,o),o},Q.getBarCategoryZ=function(t,e,i,r){for(var a=0,n=Q.getSeriesCount(t),s=0;s<n;s++){var o=et.getSeriesType(t,s);if(("bar"==o||"candlestick"==o||"boxPlot"==o)&&Q.getStackCategory(t,s)==e&&et.isSeriesRendered(t,s)){var l=Q.isAssignedToY2(t,s);(r&&l||!r&&!l)&&(a=Math.max(a,Q.getZValue(t,s,i,1)))}}return a},Q.getBarInfo=function(e,i,r,a){var n,s,o=at.isHorizontal(e),l=at.isStacked(e),h=t.Agent.isRightToLeft(e.getCtx()),u=e.xAxis,g=et.isRangeSeries(e,i),d=et.getBarCategoryOffsetMap(e,r),c=Q.getXValue(e,i,r),p=u.getUnboundedCoordAt(c),_=Q.isAssignedToY2(e,i),f=_?e.y2Axis:e.yAxis,v=f.getBaselineCoord();if(g){var m=Q.getLowValue(e,i,r),S=Q.getHighValue(e,i,r);if(null==m||isNaN(m)||null==S||isNaN(S))return null;if((n=f.getBoundedCoordAt(m))==(s=f.getBoundedCoordAt(S))&&null==f.getCoordAt(m))return null}else{var C=Q.getValue(e,i,r),y=Q.getCumulativeValue(e,i,r);if(null==C||isNaN(C))return null;if((n=f.getBoundedCoordAt(y))==(s=l?f.getBoundedCoordAt(y-C):v)&&null==f.getCoordAt(y))return null}var x=Q.getStackCategory(e,i),A=et.getBarWidth(e,i,r),b=l?et.getBarStackWidth(e,x,r,_):A;if("pixel"==et.getBarSpacing(e)&&"firefox"===t.Agent.browser){var M=A/(1-et.getBarGapRatio(e));A>1&&M-A<2&&(b=--A)}var T=d[_?"y2":"y"][x]+.5*(b-A),I=h&&!o?p-T-A:p+T,O=I+A,D=(I+O)/2,E=g?(n+s)/2:n;return{x1:I,x2:O,axisCoord:v,baseCoord:s,yCoord:n,dataPos:ct.convertAxisCoord(e,new t.Point(D,E),a),barWidth:A}},Q.getMarkerPosition=function(e,i,r,a,n){var s,o,l=e.xAxis,h=Q.isAssignedToY2(e,i)?e.y2Axis:e.yAxis,u=at.isPolar(e),g=et.isRangeSeries(e,i),d=!isNaN(a)&&null!=a&&a>=0,c=Q.getXValue(e,i,r),p=d?Q.getValue(e,i,r,a):Q.getCumulativeValue(e,i,r);if(at.isBubble(e)){if(u&&p<h.getInfo().getViewportMin())return null;s=u?l.getCoordAt(c):l.getUnboundedCoordAt(c),o=h.getUnboundedCoordAt(p)}else if(g){var _=h.getCoordAt(Q.getLowValue(e,i,r)),f=h.getCoordAt(Q.getHighValue(e,i,r));s=l.getCoordAt(Q.getXValue(e,i,r)),o=(_+f)/2}else s=l.getCoordAt(c),o=h.getCoordAt(p);return null==s||null==o?null:ct.convertAxisCoord(e,new t.Point(s,o),n)},Q.getScatterBubbleMarkerPosition=function(e,i,r){var a=e.xAxis,n=e.yAxis,s=Q.getXValue(e,i,r),o=Q.getValue(e,i,r),l=a.getCoordAt(s),h=n.getCoordAt(o);return null==l||null==h?null:new t.Point(l,h)},Q.isSeriesNegative=function(t,e){if(!t.getOptionsCache().getFromCache("hasNegativeValues"))return!1;var i=t.getOptionsCache().getFromCachedMap("isSeriesNegative",e);if(null!=i)return i;var r=Q.getGroupCount(t);i=!0;for(var a=0;a<r;a++){if(Q.getValue(t,e,a)>0){i=!1;break}}return t.getOptionsCache().putToCachedMap("isSeriesNegative",e,i),i},Q.getDataContext=function(t,e,i,r){var a,n=Q.getSeriesItem(t,e),s=Q.getDataItem(t,e,i),o=Q.getNestedDataItem(t,e,i,r),l=t.getRawOptions(),h=at.isPie(t)&&(null==e||e<0),u=t.getOptions();if(h){var g=u.translations.labelOther;a={id:g,series:g,value:st.getOtherValue(t),color:u.styleDefaults.otherColor}}else if(o){(d=l.series[e].items[i])._noTemplate?d=d._itemData:delete d._itemData,a={id:Q.getNestedDataItemId(t,e,i,r),data:[d,d.items[r]],value:Q.getValue(t,e,i,r),y:Q.getValue(t,e,i,r),color:et.getMarkerColor(t,e,i,r),itemData:u.series[e].items[i]._itemData}}else if(s){var d;(d=l.series[e].items[i])._noTemplate?d=d._itemData:delete d._itemData,a={id:Q.getDataItemId(t,e,i),data:d,value:Q.getValue(t,e,i),targetValue:Q.getTargetValue(t,e,i),x:Q.getXValue(t,e,i),y:Q.getValue(t,e,i),z:Q.getZValue(t,e,i),low:Q.getLowValue(t,e,i),high:Q.getHighValue(t,e,i),open:s.open,close:s.close,volume:s.volume,color:et.getColor(t,e,i),itemData:u.series[e].items[i]._itemData}}else n&&(a={id:Q.getSeries(t,e),color:et.getColor(t,e)});if(a){a.component=u._widgetConstructor,(h||o||s)&&(a.group=Q.getGroup(t,i),a.groupData=Q.getGroupsDataForContext(t)[i]),!h&&(o||s||n)&&(a.series=Q.getSeries(t,e),a.seriesData=l.series[e]),at.isPie(t)&&t.pieChart&&(a.totalValue=t.pieChart.getTotalValue());var c=t.getOptionsCache().getFromCachedMap2D("barDims",e,i);c&&(a.dimensions=c),a=t.getCtx().fixRendererContext(a)}return a||{}},Q.getGroupsDataForContext=function(t){var e=t.getOptionsCache().getFromCache("groupsDataArray");if(!e){var i=t.getRawOptions();e=Q._getNestedGroupsData(i.groups),t.getOptionsCache().putToCache("groupsDataArray",e)}return e},Q._getNestedGroupsData=function(t){if(!t)return[];for(var e=[],i=0;i<t.length;i++){var r=t[i];if(r.groups){for(var a=Q._getNestedGroupsData(r.groups),n=0;n<a.length;n++)a[n].unshift(r);e=e.concat(a)}else e.push([r])}return e},Q._computeOutermostBarMap=function(t){if(!t.getOptionsCache().getFromCache("outermostBar")){for(var e={},i=Q.getSeriesCount(t),r=t.getOptionsCache().getFromCache("hasNegativeValues"),a=i-1;a>=0;a--)if(et.isSeriesRendered(t,a)&&"bar"==et.getSeriesType(t,a)){var n=(Q.getStackCategory(t,a)||"")+Q.isAssignedToY2(t,a);e[n]?e[n].push(a):e[n]=[a]}var s=Q.getGroupCount(t);for(var o in e)for(var l=e[o],h=0;h<s;h++)for(var u=!1,g=!1,d=0;d<l.length&&!(!r&&u||u&&g);d++)if(a=l[d],et.isDataItemRendered(t,a,h)){var c=Q.getValue(t,a,h);null==c?t.getOptionsCache().putToCachedMap2D("outermostBar",a,h,!1):!u&&c>=0?(u=!0,t.getOptionsCache().putToCachedMap2D("outermostBar",a,h,!0)):!g&&c<0&&(g=!0,t.getOptionsCache().putToCachedMap2D("outermostBar",a,h,!0))}}},Q.isOutermostBar=function(t,e,i){return Q._computeOutermostBarMap(t),t.getOptionsCache().getFromCachedMap2D("outermostBar",e,i)||!1},Q.isDataItemFiltered=function(t,e,i){var r=Q.getDataItem(t,e,i);return!(!r||!r._filtered)},Q.getFilteredChartObjPeers=function(t){if(!t.getCache().getFromCache("dataFiltered"))return[];var e=t.getCache().getFromCache("filteredChartObjPeers");if(!e){e=[];for(var i=0;i<Q.getSeriesCount(t);i++)for(var r=0;r<Q.getGroupCount(t);r++){var n;if(Q.isDataItemFiltered(t,i,r))n="bar"==et.getSeriesType(t,i)?Q.getBarInfo(t,i,r).dataPos:Q.getMarkerPosition(t,i,r),e.push(new a(t,[],i,r,null,n))}t.getCache().putToCache("filteredChartObjPeers",e)}return e};var J=new Object;t.Obj.createSubclass(J,t.Obj),J.getHideAndShowBehavior=function(t){return t.getOptions().hideAndShowBehavior},J.getHoverBehavior=function(t){return t.getOptions().hoverBehavior},J.setVisibility=function(t,e,i){var r=$.getRefObj(t,e);null!=r&&(r.visibility=i);var a=et.getHiddenCategories(t),n=a.indexOf(e);"hidden"==i&&n<0?a.push(e):"visible"==i&&n>=0&&a.splice(n,1);var s=t.getOptions();if(s&&s.legend&&s.legend.sections){for(var o=0;o<s.legend.sections.length;o++){var l=s.legend.sections[o];if(l&&l.items)for(var h=0;h<l.items.length;h++)l.items[h].id==e&&(l.items[h].categoryVisibility=i)}return!0}return!1},J.isScrollable=function(t){return!!at.isScrollSupported(t)&&"off"!=t.getOptions().zoomAndScroll},J.isZoomable=function(t){if(!at.isScrollSupported(t))return!1;var e=t.getOptions().zoomAndScroll;return"live"==e||"delayed"==e},J.getZoomDirection=function(t){return at.isScatterBubble(t)?t.getOptions().zoomDirection:"auto"},J.isLiveScroll=function(t){if(!at.isScrollSupported(t))return!1;var e=t.getOptions().zoomAndScroll;return"live"==e||"liveScrollOnly"==e},J.isDelayedScroll=function(t){if(!at.isScrollSupported(t))return!1;var e=t.getOptions().zoomAndScroll;return"delayed"==e||"delayedScrollOnly"==e},J.processIds=function(t,e){for(var i=[],r=0;r<e.length;r++){var a=e[r];if(a.series==st.OTHER_SLICE_SERIES_ID){var n=st.getOtherSliceIds(t);i=i.concat(n)}else i.push(a)}return i},J.adjustBounds=function(t){null!=t.x&&(t.x-=1),null!=t.w&&(t.w+=2),null!=t.y&&(t.y-=1),null!=t.h&&(t.h+=2)},J.getBoundedObjects=function(t,e){for(var i=t.getChartObjPeers().concat(Q.getFilteredChartObjPeers(t)),r=[],a=0;a<i.length;a++){var n=i[a],s=n.getDataPosition();if(s){s=t.getPlotArea().localToStage(s);var o=null==e.x||s.x>=e.x&&s.x<=e.x+e.w,l=null==e.y||s.y>=e.y&&s.y<=e.y+e.h;o&&l&&r.push(n)}}return r},J.getAxisBounds=function(e,i,r){var a=e.getPlotArea(),n=a.stageToLocal(new t.Point(i.x,i.y)),s=a.stageToLocal(new t.Point(i.x+i.w,i.y+i.h));null==i.x&&(n.x=null,s.x=null),null==i.y&&(n.y=null,s.y=null);var o=J._convertToAxisCoord(e,n.x,s.x,n.y,s.y),l={},h={},u={},g={};return e.xAxis&&(l=J._getAxisMinMax(e.xAxis,o.xMin,o.xMax,r),g=J.getAxisStartEndGroup(e.xAxis,l.min,l.max)),e.yAxis&&(h=J._getAxisMinMax(e.yAxis,o.yMin,o.yMax,r)),e.y2Axis&&(u=J._getAxisMinMax(e.y2Axis,o.yMin,o.yMax,r)),{xMin:l.min,xMax:l.max,unchanged:l.unchanged,yMin:h.min,yMax:h.max,y2Min:u.min,y2Max:u.max,startGroup:g.startGroup,endGroup:g.endGroup}},J._getAxisMinMax=function(t,e,i,r){if(null==e||null==i)return{min:null,max:null};var a=t.getUnboundedLinearValueAt(e),n=t.getUnboundedLinearValueAt(i);if(r){var s=t.getInfo().getMinimumExtent();if(n-a<s){var o=(n+a)/2;n=o+s/2,a=o-s/2}return J._limitToGlobal(t,a,n)}return J.getActualMinMax(t,a,n)},J.getAxisBoundsByDelta=function(t,e,i,r,a){var n=J._convertToAxisCoord(t,e,i,r,a),s=J.getZoomDirection(t),o={},l={},h={},u={};return t.xAxis&&"y"!=s&&(o=J._getAxisMinMaxByDelta(t.xAxis,n.xMin,n.xMax),u=J.getAxisStartEndGroup(t.xAxis,o.min,o.max)),t.yAxis&&"x"!=s&&(l=J._getAxisMinMaxByDelta(t.yAxis,n.yMin,n.yMax)),t.y2Axis&&(h=J._getAxisMinMaxByDelta(t.y2Axis,n.yMin,n.yMax)),{xMin:o.min,xMax:o.max,unchanged:o.unchanged,yMin:l.min,yMax:l.max,y2Min:h.min,y2Max:h.max,startGroup:u.startGroup,endGroup:u.endGroup}},J._getAxisMinMaxByDelta=function(t,e,i){var r=t.getLinearViewportMin(),a=t.getLinearViewportMax();if(i==e&&t.isFullViewport())return J.getActualMinMax(t,r,a);var n=t.getUnboundedLinearValueAt(e)-t.getUnboundedLinearValueAt(0),s=t.getUnboundedLinearValueAt(i)-t.getUnboundedLinearValueAt(0),o=1,l=a+s-(r+n),h=t.getInfo().getMinimumExtent();return e!=i&&l<h&&(o=(a-r-h)/(n-s)),r+=n*o,a+=s*o,J._limitToGlobal(t,r,a)},J._convertToAxisCoord=function(e,i,r,a,n){var s={},o=t.Agent.isRightToLeft(e.getCtx());return at.isHorizontal(e)?(s.xMin=a,s.xMax=n,s.yMin=o?r:i,s.yMax=o?i:r):(s.xMin=o?r:i,s.xMax=o?i:r,s.yMin=n,s.yMax=a),s},J._limitToGlobal=function(t,e,i){var r=t.getLinearGlobalMin(),a=t.getLinearGlobalMax();return i-e>=a-r?(e=r,i=a):e<r?(i+=r-e,e=r):i>a&&(e-=i-a,i=a),J.getActualMinMax(t,e,i)},J.getActualMinMax=function(t,e,i){var r={min:t.linearToActual(e),max:t.linearToActual(i)};if(t.isGroupAxis()){var a=t.getLinearViewportMin(),n=t.getLinearViewportMax();Math.abs(e-a)<1e-4&&Math.abs(i-n)<1e-4&&(r.unchanged=!0)}return r},J.getAxisStartEndGroup=function(t,e,i){if(t.isGroupAxis()&&null!=e&&null!=i){var r=Math.ceil(e),a=Math.floor(i);if(a>=r)return{startGroup:t.getInfo().getGroup(r),endGroup:t.getInfo().getGroup(a)}}return{startGroup:null,endGroup:null}},J.setInitialSelection=function(t,e){var i=t.getSelectionHandler();if(i)if(e&&0!=e.length){for(var r=[],a=0;a<e.length;a++)null!=e[a].id?r.push(e[a].id):null!=e[a].series&&null!=e[a].group&&r.push(Q.createDataItemId(e[a].series,e[a].group));for(var n=new(t.getCtx().KeySetImpl)(r),s=t.getChartObjPeers(),o=[],l=0;l<s.length;l++){var h=s[l];if(h.isSelectable()){var u=h.getDataItemId(),g=Q.createDataItemId(h.getSeries(),h.getGroup());(n.has(u)||n.has(g))&&o.push(h.getId())}}i.processInitialSelections(o,s)}else i.clearSelection()},J.getKeyboardNavigables=function(t){var e=[];if(at.isPie(t))for(var i=t.pieChart.__getSlices(),r=0;r<i.length;r++)et.isSeriesRendered(t,i[r].getSeriesIndex())&&e.push(i[r]);else{var a=t.getChartObjPeers();for(r=0;r<a.length;r++)a[r].isNavigable()&&e.push(a[r])}return e},J.isSeriesDrillable=function(t,e){var i=Q.getSeriesItem(t,e),r=null!=i?i.drilling:"inherit";return"on"==r||"off"!=r&&("on"==(r=t.getOptions().drilling)||"seriesOnly"==r)},J.isDataItemDrillable=function(t,e,i,r){var a=Q.getNestedDataItem(t,e,i,r);a||(a=Q.getDataItem(t,e,i));var n=null!=a?a.drilling:"inherit";return"on"==n||"off"!=n&&"on"==(n=t.getOptions().drilling)},J.addEventData=function(t,e){var i=Q.getSeriesIndex(t,e.series),r=Q.getGroupIndex(t,e.group),a=Q.getNestedDataItemIndex(t,i,r,e.id),n=Q.getDataContext(t,i,r,a);n&&(e.data=n.data,e.itemData=n.itemData,e.seriesData=n.seriesData,n.groupData?e.groupData=n.groupData:null!=r&&(e.groupData=Q.getGroupsDataForContext(t)[r]))},J.isPlotAreaDraggable=function(t){var e=t.getOptions(),i=e.dnd?e.dnd.drag.items:{};return Object.keys(i).length>0},J.isPlotAreaDropTarget=function(t){var e=t.getOptions(),i=e.dnd?e.dnd.drop.plotArea:{};return Object.keys(i).length>0},J.addPlotAreaDnDBackground=function(e,i,r,a){var n=J.isPlotAreaDraggable(e);(J.isPlotAreaDropTarget(e)||n)&&(background=new t.Rect(e.getCtx(),0,0,a?r.w:r.h,a?r.h:r.w),background.setInvisibleFill(),i.addChild(background),e.getCache().putToCache("plotAreaBackground",background),n&&background.setClassName("oj-draggable"))};var $=new Object;t.Obj.createSubclass($,t.Obj),$.getRefObjs=function(t){var e=$.getAxisRefObjs(t,"x"),i=$.getAxisRefObjs(t,"y"),r=$.getAxisRefObjs(t,"y2");return e.concat(i,r)},$.getAxisRefObjs=function(t,e){var i=t.getOptions();return i&&i[e+"Axis"]&&i[e+"Axis"].referenceObjects?i[e+"Axis"].referenceObjects:[]},$.getType=function(t){return"area"==t.type?"area":"line"},$.getLocation=function(t){return"front"==t.location?"front":"back"},$.getColor=function(t){return t.color?t.color:"#333333"},$.getLineWidth=function(t){return t.lineWidth?t.lineWidth:1},$.getLineType=function(t){return t.lineType?t.lineType:"straight"},$.isObjectRendered=function(e,i){var r=et.getHiddenCategories(e);if(r.length>0){var a=$.getRefObjCategories(i);if(a&&t.ArrayUtils.hasAnyItem(r,a))return!1}return!("hidden"==i.visibility)},$.getId=function(t){return null!=t.id?t.id:t.text},$.getRefObjCategories=function(t){return t.categories?t.categories:[$.getId(t)]},$.getRefObj=function(t,e){for(var i=$.getRefObjs(t),r=0;r<i.length;r++)if($.getId(i[r])==e)return i[r]},$.getLowValue=function(t){return null==t?null:t.low},$.getHighValue=function(t){return null==t?null:t.high},$.getXValue=function(t,e,i){return Q.getXValueFromItem(t,e[i],i)},$.getViewportMinMaxIndex=function(t,e){var i=q.getXAxisViewportMinMax(t,!0),r=q.hasGroupAxis(t),a=i.min,n=0;if(null!=a)if(r)n=Math.ceil(a);else for(var s=0;s<e.length;s++){if($.getXValue(t,e,s)>=a){n=s;break}}var o=i.max,l=e.length-1;if(null!=l)if(r)l=Math.floor(o);else for(s=e.length-1;s>=n;s--){if(Q.getXValue(t,e,s)<=o){l=s;break}}return{min:n,max:l}};var tt=new Object;t.Obj.createSubclass(tt,t.Obj),tt.getBarFill=function(t,e,i,r){var a=et.getColor(t,e,i),n=et.getPattern(t,e,i);return tt.getRectangleFill(t,a,n,r)},tt.getRectangleFill=function(e,i,r,a){var n=et.getSeriesEffect(e);if(r)return new t.PatternFill(r,i);if("gradient"==n&&a>3){var s,o,l=at.isHorizontal(e)?270:0;return s=[t.ColorUtils.adjustHSL(i,0,-.09,.04),t.ColorUtils.adjustHSL(i,0,-.04,-.05)],o=[0,1],new t.LinearGradientFill(l,s,null,o)}return new t.SolidFill(i)},tt.getAreaFill=function(e,i){var r,a="lineWithArea"==et.getSeriesType(e,i),n=Q.getSeriesItem(e,i);n&&n.areaColor?r=n.areaColor:(r=et.getColor(e,i),a&&(r=t.ColorUtils.setAlpha(r,.2)));var s=et.getPattern(e,i),o=et.getSeriesEffect(e);if(s)return new t.PatternFill(s,r);if("gradient"==o){var l,h,u=at.isHorizontal(e)?180:270;if(a){var g=t.ColorUtils.getAlpha(r);l=[t.ColorUtils.setAlpha(r,Math.min(g+.2,1)),t.ColorUtils.setAlpha(r,Math.max(g-.15,0))],h=[0,1]}else l=[t.ColorUtils.adjustHSL(r,0,-.09,.04),t.ColorUtils.adjustHSL(r,0,-.04,-.05)],h=[0,1];return new t.LinearGradientFill(u,l,null,h)}return new t.SolidFill(r)},tt.getMarkerFill=function(e,i,r,a){var n=et.getMarkerColor(e,i,r,a),s=et.getPattern(e,i,r,a);if(s)return new t.PatternFill(s,n);if(at.isBubble(e)&&"gradient"==et.getSeriesEffect(e)){var o=[t.ColorUtils.adjustHSL(n,0,-.09,.04),t.ColorUtils.adjustHSL(n,0,-.04,-.05)];return new t.LinearGradientFill(270,o,null,[0,1])}return new t.SolidFill(n)},tt.getFunnelPyramidSliceFill=function(e,i,r,a,n){var s,o=et.getPattern(e,i,0),l=et.getSeriesEffect(e);if(o&&!n)return("vertical"==e.getOptions().orientation||at.isPyramid(e))&&(s=t.Agent.isRightToLeft(e.getCtx())?new t.Matrix(0,-1,1,0):new t.Matrix(0,1,-1,0)),new t.PatternFill(o,r,null,s);if("gradient"==l){var h,u,g=at.isPyramid(e)?180:90;return"on"==e.getOptions().styleDefaults.threeDEffect?(h=[t.ColorUtils.adjustHSL(r,0,0,-.1),t.ColorUtils.adjustHSL(r,0,0,.12),r],u=[0,.65,1]):(h=[t.ColorUtils.adjustHSL(r,0,-.09,.04),t.ColorUtils.adjustHSL(r,0,-.04,-.05)],u=[0,1]),new t.LinearGradientFill(g,h,null,u,[a.x,a.y,a.w,a.h])}return new t.SolidFill(r)};var et=new Object;t.Obj.createSubclass(et,t.Obj),et._SERIES_TYPE_RAMP=["bar","line","area"],et.getSeriesType=function(t,e){var i=t.getOptionsCache().getFromCachedMap("seriesType",e);if(i)return i;if(!at.isBLAC(t))return t.getOptionsCache().putToCachedMap("seriesType",e,"auto"),"auto";var r=Q.getSeriesItem(t,e);if(i=r?r.type:null,at.isStock(t)||"candlestick"!=i||(i="auto"),!i||"auto"==i)if(at.isBar(t))i="bar";else if(at.isLine(t))i="line";else if(at.isArea(t))i="area";else if(at.isLineWithArea(t))i="lineWithArea";else if(at.isStock(t))i="candlestick";else if(at.isBoxPlot(t))i="boxPlot";else if(at.isCombo(t)){var a=Q.getSeriesStyleIndex(t,e)%et._SERIES_TYPE_RAMP.length;i=et._SERIES_TYPE_RAMP[a]}return t.getOptionsCache().putToCachedMap("seriesType",e,i),i},et.isRangeSeries=function(t,e){var i=t.getOptionsCache();if(!i.getFromCache("hasLowHighSeries"))return!1;var r=i.getFromCachedMap("isRange",e);if(null!=r)return r;r=!1;var a=et.getSeriesType(t,e);if("bar"==a||"area"==a)for(var n=0;n<Q.getGroupCount(t);n++)if(null!=Q.getLowValue(t,e,n)||null!=Q.getHighValue(t,e,n)){r=!0;break}return t.getOptionsCache().putToCachedMap("isRange",e,r),r},et.getSeriesEffect=function(t){return t.getOptions().styleDefaults.seriesEffect},et.getColor=function(t,e,i){var r=Q.getDataItem(t,e,i);if(r&&r.color)return r.color;var a=Q.getSeriesItem(t,e);if(a&&a.color)return a.color;if("candlestick"==et.getSeriesType(t,e))return et.getStockItemColor(t,e,i);var n=t.getOptions().styleDefaults.colors;return n[Q.getSeriesStyleIndex(t,e)%n.length]},et.getStockItemColor=function(t,e,i){var r=t.getOptions();return Q.isStockValueRising(t,e,i)?r.styleDefaults.stockRisingColor:r.styleDefaults.stockFallingColor},et.getStockVolumeColor=function(t,e,i){var r=Q.getDataItem(t,e,i);if(r&&r.color)return r.color;var a=t.getOptions();return a.styleDefaults.stockVolumeColor?a.styleDefaults.stockVolumeColor:et.getStockItemColor(t,e,i)},et.getSplitterPosition=function(t){var e=t.getOptions().splitterPosition;return null!=e?e:at.isStock(t)?.8:.5},et.getPattern=function(e,i,r,a){var n=Q.getNestedDataItem(e,i,r,a);if(n&&n.pattern&&"auto"!=n.pattern)return n.pattern;var s=Q.getDataItem(e,i,r);if(s&&s.pattern&&"auto"!=s.pattern)return s.pattern;var o=et.getSeriesType(e,i);if(("line"==o||"area"==o)&&null!=r)return null;var l=Q.getSeriesItem(e,i);if(l&&l.pattern&&"auto"!=l.pattern)return l.pattern;if("pattern"==et.getSeriesEffect(e)){if(at.isStock&&"candlestick"==et.getSeriesType(e,i)){var h=Q.isStockValueRising(e,i,r),u=t.Agent.isRightToLeft(e.getCtx());return h?u?"smallDiagonalLeft":"smallDiagonalRight":u?"smallDiagonalRight":"smallDiagonalLeft"}var g=e.getOptions().styleDefaults.patterns;return g[Q.getSeriesStyleIndex(e,i)%g.length]}return null},et.getMarkerBorderColor=function(e,i,r,a){var n=et.getBorderColor(e,i,r,a);if(n)return n;if(et.getDataItemGaps(e)>0&&"lineWithArea"!=et.getSeriesType(e,i))return et.getBackgroundColor(e,!0);if(at.isBubble(e)&&"gradient"!=et.getSeriesEffect(e)){var s=et.getMarkerColor(e,i,r);if(s)return t.ColorUtils.adjustHSL(s,0,.15,-.25)}return null},et.getBorderColor=function(t,e,i,r){var a=Q.getNestedDataItem(t,e,i,r);if(a&&a.borderColor)return a.borderColor;var n=Q.getDataItem(t,e,i);if(n&&n.borderColor)return n.borderColor;var s=Q.getSeriesItem(t,e);if(s&&s.borderColor)return s.borderColor;var o=t.getOptions().styleDefaults;return"auto"!=o.borderColor?o.borderColor:null},et.getBorderWidth=function(t,e,i,r){var a=Q.getNestedDataItem(t,e,i,r);if(a&&null!=a.borderWidth)return a.borderWidth;var n=Q.getDataItem(t,e,i);if(n&&null!=n.borderWidth)return n.borderWidth;var s=Q.getSeriesItem(t,e);if(s&&null!=s.borderWidth)return s.borderWidth;var o=t.getOptions().styleDefaults;return"auto"!=o.borderWidth?o.borderWidth:at.isScatterBubble(t)||at.isLineArea(t)?1.25:1},et.getMarkerColor=function(t,e,i,r){if(!et.isMarkerDisplayed(t,e,i,r))return et.getColor(t,e,i);var a=Q.getNestedDataItem(t,e,i,r);if(a&&a.color)return a.color;var n=Q.getDataItem(t,e,i);if(n&&n.color)return n.color;var s=Q.getSeriesItem(t,e);if(s&&s.markerColor)return s.markerColor;var o=t.getOptions().styleDefaults.markerColor;return o||et.getColor(t,e,i)},et.getMarkerShape=function(t,e,i,r){var a=t.getOptions(),n=a.styleDefaults.markerShape,s=Q.getSeriesItem(t,e);s&&s.markerShape&&(n=s.markerShape);var o=Q.getDataItem(t,e,i);o&&o.markerShape&&(n=o.markerShape);var l=Q.getNestedDataItem(t,e,i,r);if(l&&l.markerShape&&(n=l.markerShape),"auto"==n)if(at.isBubble(t)||"boxPlot"==et.getSeriesType(t,e)||et.isRangeSeries(t,e))n="circle";else{var h=Q.getSeriesStyleIndex(t,e),u=a.styleDefaults.shapes;n=u[h%u.length]}return n},et.getMarkerSize=function(t,e,i,r){var a,n=Q.getNestedDataItem(t,e,i,r);if(n&&null!=n.markerSize)a=Number(n.markerSize);else{var s=Q.getDataItem(t,e,i);if(s&&null!=s.markerSize)a=Number(s.markerSize);else{var o=Q.getSeriesItem(t,e);a=o&&null!=o.markerSize?Number(o.markerSize):Number(t.getOptions().styleDefaults.markerSize)}}return at.isOverview(t)&&(a=Math.ceil(.6*a)),a},et.isMarkerDisplayed=function(t,e,i,r){var a,n=Q.getNestedDataItem(t,e,i,r);if(n&&null!=n.markerDisplayed)a=n.markerDisplayed;else{var s=Q.getDataItem(t,e,i);if(s&&null!=s.markerDisplayed)a=s.markerDisplayed;else{var o=Q.getSeriesItem(t,e);a=o&&null!=o.markerDisplayed?o.markerDisplayed:t.getOptions().styleDefaults.markerDisplayed}}return"on"==a||"off"!=a&&(at.isScatterBubble(t)||"boxPlot"==et.getSeriesType(t,e)||"none"==et.getLineType(t,e))},et.getImageSource=function(t,e,i,r,a){var n=Q.getNestedDataItem(t,e,i,r);if(n&&n[a])return n[a];var s=Q.getDataItem(t,e,i);if(s&&s[a])return s[a];var o=Q.getSeriesItem(t,e);return o&&o[a]?o[a]:void 0},et.getLineWidth=function(t,e){var i,r=Q.getSeriesItem(t,e),a=t.getOptions();return i=r&&r.lineWidth?r.lineWidth:a.styleDefaults.lineWidth?a.styleDefaults.lineWidth:"lineWithArea"==et.getSeriesType(t,e)?2:3,at.isOverview(t)&&(i=Math.ceil(.6*i)),i},et.getLineStyle=function(t,e){var i=Q.getSeriesItem(t,e);return i&&i.lineStyle?i.lineStyle:t.getOptions().styleDefaults.lineStyle},et.getLineType=function(t,e){var i,r=Q.getSeriesItem(t,e);return"auto"==(i=r&&r.lineType?r.lineType:t.getOptions().styleDefaults.lineType)&&(i=at.isScatterBubble(t)?"none":"straight"),(at.isPolar(t)||at.isScatterBubble(t))&&("centeredSegmented"==i&&(i="segmented"),"centeredStepped"==i&&(i="stepped")),i},et.getBarSpacing=function(t){return t.getOptions().__sparkBarSpacing},et.getBarGapRatio=function(t){var e=t.getCache().getFromCache("barGapRatio");if(e)return e;if("string"==typeof(e=t.getOptions().styleDefaults.barGapRatio)&&"%"==e.slice(-1)&&(e=Number(e.slice(0,-1))/100),null!=e&&!isNaN(e))return e;var i=Q.getStackCategories(t,"bar"),r=i.y.length,a=i.y2.length,n=at.isSplitDualY(t)?Math.max(r,a):r+a;return e=at.isPolar(t)?1==n?0:.25:1==n?.37+.26/Q.getViewportGroupCount(t):.25,t.getCache().putToCache("barGapRatio",e),e},et.getMaxBarWidth=function(t){var e=t.getOptions().styleDefaults.maxBarWidth;return null==e||at.isPolar(t)?1/0:e},et.getBarWidth=function(t,e,i){t.getOptionsCache().getFromCache("hasConstantZValue")&&(e=0,i=0);var r=t.getCache().getFromCachedMap2D("barWidth",e,i);if(null!=r)return r;var a=Q.getZValue(t,e,i,1)/t.getOptions()._averageGroupZ;return r=Math.min(a*et.getGroupWidth(t),et.getMaxBarWidth(t)),t.getCache().putToCachedMap2D("barWidth",e,i,r),r},et.getBarStackWidth=function(t,e,i,r){t.getOptionsCache().getFromCache("hasConstantZValue")&&(i=0);var a=r?"y2BarStackWidth":"yBarStackWidth",n=t.getCache().getFromCachedMap2D(a,e,i);if(null!=n)return n;var s=Q.getBarCategoryZ(t,e,i,r)/t.getOptions()._averageGroupZ;return n=Math.min(s*et.getGroupWidth(t),et.getMaxBarWidth(t)),t.getCache().putToCachedMap2D(a,e,i,n),n},et.getBarCategoryOffsetMap=function(t,e){t.getOptionsCache().getFromCache("hasConstantZValue")&&(e=0);var i=t.getCache().getFromCachedMap("barCategoryOffsetMap",e);if(i)return i;var r,a=at.isStacked(t),n=Q.getStackCategories(t,"bar"),s=q.isMixedFrequency(t),o=at.isSplitDualY(t),l={},h={},u=0,g=0;if(a){for(c=0;c<n.y.length;c++)r=et.getBarStackWidth(t,n.y[c],e,!1),s?l[n.y[c]]=-.5*r:(l[n.y[c]]=u,u+=r);for(o||(g=u),c=0;c<n.y2.length;c++)r=et.getBarStackWidth(t,n.y2[c],e,!0),s?h[n.y2[c]]=-.5*r:(h[n.y2[c]]=g,g+=r);o||(u=g)}else for(var d=Q.getSeriesCount(t),c=0;c<d;c++){var p=et.getSeriesType(t,c);if(("bar"==p||"candlestick"==p||"boxPlot"==p)&&et.isSeriesRendered(t,c)){var _=Q.isAssignedToY2(t,c),f=Q.getStackCategory(t,c);r=et.getBarWidth(t,c,e),_?s?h[f]=-.5*r:(h[f]=g,g+=r):s?l[f]=-.5*r:(l[f]=u,u+=r)}}for(var f in l)l[f]-=o||a?u/2:(u+g)/2;for(var f in h)h[f]-=o||a?g/2:(u+g)/2-u;return i={y:l,y2:h},t.getCache().putToCachedMap("barCategoryOffsetMap",e,i),i},et.getDataItemGaps=function(t){var e=t.getOptionsCache().getFromCache("dataItemGaps");if(null!=e)return e;var i=t.getOptions();if(null!=i.styleDefaults.sliceGaps)e=i.styleDefaults.sliceGaps;else{var r=i.styleDefaults.dataItemGaps;"auto"==r&&(r="on"==i.styleDefaults.threeDEffect?"0%":"50%");var a=r&&r.indexOf?r.indexOf("%"):-1;e=a>=0?(r=r.substring(0,a))/100:0}return t.getOptionsCache().putToCache("dataItemGaps",e),e},et.isSelectable=function(t,e,i){var r=Q.getSeriesItem(t,e);return(!r||"off"!=r._selectable)&&(t.isSelectionSupported()&&null!=e&&e>=0&&null!=i&&i>=0)},et.isSeriesRendered=function(e,i){var r=et.getHiddenCategories(e);return!(r.length>0&&t.ArrayUtils.hasAnyItem(r,Q.getCategories(e,i)))},et.isDataItemRendered=function(e,i,r,a){var n,s=!isNaN(a)&&null!=a&&a>=0;if(!s&&void 0!==(n=e.getOptionsCache().getFromCachedMap2D("isDataItemRendered",i,r)))return n;if(n=!0,et.isSeriesRendered(e,i)){var o=et.getHiddenCategories(e);o.length>0&&((at.isPie(e)||at.isFunnel(e)||at.isPyramid(e))&&(r=0),t.ArrayUtils.hasAnyItem(o,Q.getCategories(e,i,r))&&(n=!1),t.ArrayUtils.hasAnyItem(o,Q.getCategories(e,i,r,a))&&(n=!1))}else n=!1;return s||e.getOptionsCache().putToCachedMap2D("isDataItemRendered",i,r,n),n},et.getAnimationOnDisplay=function(t){return t.getOptions().animationOnDisplay},et.getAnimationOnDataChange=function(t){return t.getOptions().animationOnDataChange},et.getAnimationDuration=function(e){return t.CSSStyle.getTimeMilliseconds(e.getOptions().styleDefaults.animationDuration)/1e3},et.getAnimationIndicators=function(t){return t.getOptions().styleDefaults.animationIndicators},et.getAnimationUpColor=function(t){return t.getOptions().styleDefaults.animationUpColor},et.getAnimationDownColor=function(t){return t.getOptions().styleDefaults.animationDownColor},et.getHiddenCategories=function(t){var e=t.getOptions();return e.hiddenCategories||(e.hiddenCategories=[]),e.hiddenCategories},et.getHighlightedCategories=function(t){var e=t.getOptions();return e.highlightedCategories||(e.highlightedCategories=[]),e.highlightedCategories},et.getSelectedInnerColor=function(t){return t.getOptions().styleDefaults.selectedInnerColor},et.getSelectedOuterColor=function(t){return t.getOptions().styleDefaults.selectedOuterColor},et.isSelectionHighlighted=function(t){var e=t.getOptions().styleDefaults.selectionEffect;return"highlight"==e||"highlightAndExplode"==e},et.isSelectionExploded=function(t){var e=t.getOptions().styleDefaults.selectionEffect;return"explode"==e||"highlightAndExplode"==e},et.getDataLabelStyle=function(e,i,r,a,n,s,o){var l,h=[];!n||"bar"!=et.getSeriesType(e,i)&&!at.isBubble(e)||"center"!=s&&"inBottom"!=s&&"inTop"!=s&&"inRight"!=s&&"inLeft"!=s?h.push(new t.CSSStyle("color: #333333;")):(l=null!=et.getPattern(e,i,r,a)?"#000000":t.ColorUtils.getContrastingTextColor(n),h.push(new t.CSSStyle("color: "+l+";"))),h.push(et._parseLowHighArray(e.getOptions().styleDefaults.dataLabelStyle,o));var u=Q.getDataItem(e,i,r);u&&h.push(new t.CSSStyle(et._parseLowHighArray(u.labelStyle,o)));var g=Q.getNestedDataItem(e,i,r,a);return g&&h.push(new t.CSSStyle(et._parseLowHighArray(g.labelStyle,o))),l&&t.Agent.isHighContrast()&&h.push(new t.CSSStyle("color: "+l+";")),t.CSSStyle.mergeStyles(h)},et.getDataLabelPosition=function(e,i,r,a,n,s){var o,l=Q.getNestedDataItem(e,i,r,a),h=Q.getDataItem(e,i,r);if(s)o="outsideBarEdge";else if((o=l&&l.labelPosition?l.labelPosition:h.labelPosition)||(o=e.getOptions().styleDefaults.dataLabelPosition),"none"==(o=et._parseLowHighArray(o,n)))return"none";var u=t.Agent.isRightToLeft(e.getCtx()),g=at.isHorizontal(e),d=at.isPolar(e);if(at.isFunnel(e)||at.isPyramid(e))return"center";if("bar"==et.getSeriesType(e,i)){if("center"==o||d)return"center";var c,p=at.isStacked(e);if("insideBarEdge"!=o){if(p&&!s)return"center";"outsideBarEdge"!=o&&(o="insideBarEdge")}if("insideBarEdge"==o&&!p){var _,f=e.getOptions().styleDefaults.dataLabelStyle,v=h.labelStyle?t.CSSStyle.mergeStyles([f,new t.CSSStyle(h.labelStyle)]):f;if(g){var m=Q.getDataLabel(e,i,r,a,n);_=t.TextUtils.getTextStringWidth(e.getCtx(),m,v)}else _=t.TextUtils.getTextStringHeight(e.getCtx(),v);var S=Q.getBarInfo(e,i,r);(S?Math.abs(S.baseCoord-S.yCoord):0)<=_&&(o="outsideBarEdge")}return c="low"==n?h.low<=h.high:"high"==n?h.high<h.low:Q.getValue(e,i,r,a)<0,"outsideBarEdge"==o?g?!c&&!u||c&&u?"right":"left":c?"bottom":"top":g?!c&&!u||c&&u?"inRight":"inLeft":c?"inBottom":"inTop"}if("center"==o)return"center";if("belowMarker"==o)return"bottom";if("aboveMarker"==o)return"top";if("afterMarker"!=o&&"beforeMarker"!=o){if(at.isBubble(e))return"center";if("low"!=n||d)if("high"!=n||d)o="afterMarker";else{if(!g)return"top";o="afterMarker"}else{if(!g)return"bottom";o="beforeMarker"}}return!u&&"afterMarker"==o||u&&"beforeMarker"==o?"right":"left"},et._parseLowHighArray=function(t,e){return t instanceof Array?"high"==e?t[1]:t[0]:t},et.isOverviewRendered=function(t){var e=t.getOptions();return at.isOverviewSupported(t)&&"off"!=e.overview.rendered},et.getOverviewHeight=function(t){var e=t.getOptions().overview.height;return null==e&&(e=q.hasTimeAxis(t)?.25:.2),et.getSizeInPixels(e,t.getHeight())},et.getSizeInPixels=function(t,e){if("string"==typeof t){if("%"==t.slice(-1))return e*Number(t.slice(0,-1))/100;if("px"==t.slice(-2))return Number(t.slice(0,-2));t=Number(t)}return"number"==typeof t?t<=1?e*t:t:0},et.getBackgroundColor=function(t,e){var i=t.getOptions();return i.plotArea.backgroundColor?i.plotArea.backgroundColor:e?"#FFFFFF":null},et.getHoverBehaviorDelay=function(e){var i=e.getOptions().styleDefaults.hoverBehaviorDelay;return i?(i=t.CSSStyle.getTimeMilliseconds(i),at.isScatterBubble(e)||at.isLine(e)?.75*i:1.25*i):0},et.optimizeMarkerStroke=function(t){return at.isScatterBubble(t)||at.isBoxPlot(t)},et.getGroupWidth=function(t){var e=t.getCache().getFromCache("groupWidth");return null==e&&(e=t.xAxis.getInfo().getGroupWidth(),t.getCache().putToCache("groupWidth",e)),e},et.isStackLabelRendered=function(t){var e=t.getOptions();return!(!at.isStacked(t)||"on"!=e.stackLabel)},et.optimizeMarkerFill=function(t){return at.isLineArea(t)},et.getClassName=function(t,e,i){var r=Q.getDataItem(t,e,i);if(r&&(r.className||r.svgClassName))return r.className||r.svgClassName;var a=Q.getSeriesItem(t,e);return a&&(a.className||a.svgClassName)?a.className||a.svgClassName:null},et.getAreaClassName=function(t,e){var i=Q.getSeriesItem(t,e);return i&&(i.areaClassName||i.areaSvgClassName)?i.areaClassName||i.areaSvgClassName:i&&(i.className||i.svgClassName)?i.className||i.svgClassName:null},et.getMarkerClassName=function(t,e,i,r){var a=Q.getNestedDataItem(t,e,i,r);if(a&&(a.className||a.svgClassName))return a.className||a.svgClassName;var n=Q.getDataItem(t,e,i);if(n&&(n.className||n.svgClassName))return n.className||n.svgClassName;var s=Q.getSeriesItem(t,e);return s&&(s.markerClassName||s.markerSvgClassName)?s.markerClassName||s.markerSvgClassName:at.isScatterBubble(t)&&s&&(s.className||s.svgClassName)?s.className||s.svgClassName:null},et.getStyle=function(t,e,i){var r=Q.getDataItem(t,e,i);if(r&&(r.style||r.svgStyle))return r.style||r.svgStyle;var a=Q.getSeriesItem(t,e);return a&&(a.style||a.svgStyle)?a.style||a.svgStyle:null},et.getAreaStyle=function(t,e){var i=Q.getSeriesItem(t,e);return i&&(i.areaStyle||i.areaSvgStyle)?i.areaStyle||i.areaSvgStyle:i&&(i.style||i.svgStyle)?i.style||i.svgStyle:null},et.getMarkerStyle=function(t,e,i,r){var a=Q.getNestedDataItem(t,e,i,r);if(a&&(a.style||a.svgStyle))return a.style||a.svgStyle;var n=Q.getDataItem(t,e,i);if(n&&(n.style||n.svgStyle))return n.style||n.svgStyle;var s=Q.getSeriesItem(t,e);return s&&(s.markerStyle||s.markerSvgStyle)?s.markerStyle||s.markerSvgStyle:at.isScatterBubble(t)&&s&&(s.style||s.svgStyle)?s.style||s.svgStyle:null},et.getBoxPlotStyleOptions=function(e,i,r){var a=Q.getDataItem(e,i,r),n=a&&a.boxPlot?a.boxPlot:{},s=Q.getSeriesItem(e,i),o=s&&s.boxPlot?s.boxPlot:{},l=e.getOptions().styleDefaults.boxPlot,h=t.JsonUtils.merge(n,t.JsonUtils.merge(o,l)),u=et.getColor(e,i,r);h._color=u;var g=t.ColorUtils.getBrighter(u,.8);if(h.q2Color||(h.q2Color=g),h.q3Color||(h.q3Color=g),"pattern"==et.getSeriesEffect(e)){var d=et.getPattern(e,i,r);h._q2Pattern=d,h._q3Pattern=d}var c=et.getBorderColor(e,i,r);h.borderColor=c||u,h.borderWidth=et.getBorderWidth(e,i,r);var p=t.ColorUtils.getDarker(u,.1);return et._setBoxPlotDefaultLineColor(h,"whisker",p),et._setBoxPlotDefaultLineColor(h,"whiskerEnd",p),et._setBoxPlotDefaultLineColor(h,"median",p),h},et._setBoxPlotDefaultLineColor=function(e,i,r){var a=t.JsonUtils.merge(e[i+"Style"],e[i+"SvgStyle"]);e[i+"SvgStyle"]=a,e[i+"Style"]=null,!a||a.stroke||e[i+"ClassName"]||e[i+"SvgClassName"]||(e[i+"SvgStyle"].stroke=r)};var it=new Object;t.Obj.createSubclass(it,t.Obj),it.createText=function(e,i,r,a,n,s,o,l){var h=new t.OutputText(i.getCtx(),r,n,s);return h.setCSSStyle(a),t.TextUtils.fitText(h,o,l,i)?(e.associate(h,new t.SimpleObjPeer(h.getUntruncatedTextString())),h):null},it.areTitlesRendered=function(t){var e=t.getOptions();return e.title.text||e.subtitle.text||e.footnote.text};var rt=new Object;t.Obj.createSubclass(rt,t.Obj),rt.getDatatipColor=function(t,e,i,r){return at.isStock(t)?et.getColor(t,0,i):null!=r&&r>=0?et.getMarkerColor(t,e,i,r):et.getColor(t,e,i)},rt.getDatatip=function(t,e,i,r,a){if(at.isSpark(t)||at.isOverview(t))return null;if(e<0||i<0)return null;var n,s=Q.getDataItem(t,e,i),o=t.getOptions().tooltip,l=o?o.renderer:null;if(a&&l){var h=t.getCtx().getTooltipManager(rt.isDataCursorEnabled(t)?w.TOOLTIP_ID:null),u=Q.getDataContext(t,e,i,r);if(at.isPie(t)){var g=st.getSliceBySeriesIndex(t,e);u.label=g.getSliceLabelString()}else u.label=Q.getDataLabel(t,e,i,r);return h.getCustomTooltip(l,u)}return s&&null!=s.shortDesc?s.shortDesc:(at.isStock(t)?n=rt._getStockDatatip(t,0,i,a):(n=[],rt._addSeriesDatatip(n,t,e,i,a),rt._addGroupDatatip(n,t,e,i,a),rt._addValueDatatip(n,t,e,i,r,a)),rt._processDatatip(n,t,a))},rt.getOtherSliceDatatip=function(t,e,i){var r=t.getOptions().translations.labelOther,a=t.getOptions().tooltip,n=a?a.renderer:null;if(i&&n){var s=st.getSliceBySeriesIndex(t,null),o=Q.getDataContext(t,null,0);return o.label=s.getSliceLabelString(),t.getCtx().getTooltipManager().getCustomTooltip(n,o)}var l=[];return rt._addDatatipRow(l,t,"series","labelSeries",r,i),rt._addGroupDatatip(l,t,0,0,i),rt._addDatatipRow(l,t,"value","labelValue",e,i),rt._processDatatip(l,t,i)},rt._processDatatip=function(e,i,r){return 0===e.length?null:r?t.HtmlTooltipManager.createElement("table",i.getOptions().styleDefaults._tooltipStyle,e):e.join("")},rt.getRefObjTooltip=function(t,e,i,r){var a=t.getOptions().tooltip,n=a?a.renderer:null;if(n&&null!=e.id){var s=t.getCtx().getTooltipManager(rt.isDataCursorEnabled(t)?w.TOOLTIP_ID:null),o={id:$.getId(e),label:e.text,data:t.getRawOptions()[i].referenceObjects[r],value:e.value,low:$.getLowValue(e),high:$.getHighValue(e),color:$.getColor(e)};return s.getCustomTooltip(n,o)}return e.shortDesc},rt._getStockDatatip=function(t,e,i,r){var a=Q.getDataItem(t,e,i),n=[];return rt._addGroupDatatip(n,t,e,i,r),a&&(rt._addDatatipRow(n,t,"open","labelOpen",a.open,r),rt._addDatatipRow(n,t,"close","labelClose",a.close,r),rt._addDatatipRow(n,t,"high","labelHigh",a.high,r),rt._addDatatipRow(n,t,"low","labelLow",a.low,r),rt._addDatatipRow(n,t,"volume","labelVolume",a.volume,r)),n},rt._addSeriesDatatip=function(t,e,i,r,a){var n=Q.getSeriesLabel(e,i);rt._addDatatipRow(t,e,"series","labelSeries",n,a)},rt._addGroupDatatip=function(t,e,i,r,a){var n;if(q.hasTimeAxis(e)){var s=rt.getValueFormat(e,"group"),o=Q.getXValue(e,i,r);null==(n=rt.formatDateValue(s,new Date(o)))&&(n=e.xAxis.getInfo().formatLabel(o))}else n=Q.getGroupLabel(e,r);var l=Q.getNumLevels(e),h="labelGroup";if(1!=l&&Array.isArray(n))for(var u=l-1;u>=0;u--)rt._addDatatipRow(t,e,"group",h,n[u],a,u),n[u]&&(h=null);else rt._addDatatipRow(t,e,"group",h,n,a)},rt._addValueDatatip=function(t,e,i,r,a,n){var s=Q.getValue(e,i,r,a),o=Q.getXValue(e,i,r),l=Q.getZValue(e,i,r),h=Q.getLowValue(e,i,r),u=Q.getHighValue(e,i,r),g=null!=a&&a>=0;if(at.isScatterBubble(e))rt._addDatatipRow(t,e,"x","labelX",o,n),rt._addDatatipRow(t,e,"y","labelY",s,n),at.isBubble(e)&&rt._addDatatipRow(t,e,"z","labelZ",l,n);else if(at.isPie(e)||at.isPyramid(e))rt._addDatatipRow(t,e,"value","labelValue",s,n);else if(at.isFunnel(e)){rt._addDatatipRow(t,e,"value","labelValue",s,n);var d=Q.getTargetValue(e,i);null!=d&&rt._addDatatipRow(t,e,"targetValue","labelTargetValue",d,n)}else if("boxPlot"!=et.getSeriesType(e,i)||g){if(at.isBLAC(e)){var c=Q.isAssignedToY2(e,i)?"y2":"y";null==h&&null==u||g?null==l||g?rt._addDatatipRow(t,e,c,"labelValue",s,n):(rt._addDatatipRow(t,e,c,"labelY",s,n),rt._addDatatipRow(t,e,"z","labelZ",l,n)):(rt._addDatatipRow(t,e,"high","labelHigh",u,n),rt._addDatatipRow(t,e,"low","labelLow",h,n),null!=l&&rt._addDatatipRow(t,e,"z","labelZ",l,n))}}else{var p=Q.getDataItem(e,i,r);rt._addDatatipRow(t,e,"high","labelHigh",u,n),rt._addDatatipRow(t,e,"q3","labelQ3",p.q3,n),rt._addDatatipRow(t,e,"q2","labelQ2",p.q2,n),rt._addDatatipRow(t,e,"q1","labelQ1",p.q1,n),rt._addDatatipRow(t,e,"low","labelLow",h,n),null!=l&&rt._addDatatipRow(t,e,"z","labelZ",l,n)}},rt._addDatatipRow=function(e,i,r,a,n,s,o){if(null!=n&&""!==n){var l,h=i.getOptions().styleDefaults,u=rt.getValueFormat(i,r),g=u.tooltipDisplay,d=i.getOptions().translations;if(g&&"auto"!=g||"group"==r&&(at.isPie(i)||at.isFunnel(i))&&(g="off"),"off"!=g)if("string"==typeof u.tooltipLabel?l=u.tooltipLabel:Array.isArray(u.tooltipLabel)&&(l=u.tooltipLabel[o||0]),null==l&&(l=null==a?"":"labelGroup"==a&&q.hasTimeAxis(i)?d.labelDate:d[a]),"series"!=r&&"group"!=r&&(n=rt.formatValue(i,u,n)),s){var c=t.Agent.isRightToLeft(i.getCtx());h.tooltipLabelStyle.setStyle(t.CSSStyle.TEXT_ALIGN,c?"left":"right"),h.tooltipValueStyle.setStyle(t.CSSStyle.TEXT_ALIGN,c?"right":"left");var p=[t.HtmlTooltipManager.createElement("td",h.tooltipLabelStyle,l),t.HtmlTooltipManager.createElement("td",h.tooltipValueStyle,n)];e.push(t.HtmlTooltipManager.createElement("tr",null,p))}else e.push((e.length>0?"<br>":"")+t.ResourceUtils.format(d.labelAndValue,[l,n]))}},rt.getValueFormat=function(t,e){var i=t.getOptions().valueFormats;return i?i[e]?i[e]:"group"==e&&q.hasTimeAxis(t)?rt.getValueFormat(t,"x"):"y"!=e&&"y2"!=e&&"min"!=e&&"max"!=e||!at.isBLAC(t)?{}:rt.getValueFormat(t,"value"):{}},rt.formatValue=function(e,i,r,a,n,s){var o,l="auto",h="on";i.scaling&&(l=i.scaling),i.autoPrecision&&(h=i.autoPrecision),i.converter&&(o=i.converter),a=null!=a?a:r,n=null!=n?n:r,s=null!=s?s:0;var u=new t.LinearScaleAxisValueFormatter(e.getCtx(),a,n,s,l,h,e.getOptions().translations);return o&&(o.getAsString||o.format)?u.format(r,o):u.format(r)},rt.formatDateValue=function(t,e){var i=t.converter;return i?i.getAsString?i.getAsString(e):i.format?i.format(e):null:null},rt.isDataCursorEnabled=function(e){if(at.isPie(e)||at.isFunnel(e)||at.isPolar(e)||at.isPyramid(e))return!1;var i=e.getOptions();return"on"==i.dataCursor||"off"!=i.dataCursor&&(t.Agent.isTouchDevice()&&at.isLineArea(e))},rt.getDataCursorBehavior=function(t){var e=t.getOptions().dataCursorBehavior;return"snap"==e?w.BEHAVIOR_SNAP:"smooth"==e?w.BEHAVIOR_SMOOTH:at.isLineArea(t)?w.BEHAVIOR_SMOOTH:w.BEHAVIOR_SNAP};var at=new Object;t.Obj.createSubclass(at,t.Obj),at._SUPPORTED_TYPES=["bar","line","area","lineWithArea","combo","pie","bubble","scatter","funnel","pyramid","stock","boxPlot"],at.isValidType=function(t){return at._SUPPORTED_TYPES.indexOf(t.getType())>=0},at.isSpark=function(t){return t.getOptions().__spark},at.isOverview=function(t){return t.getOptions()._isOverview},at.isVertical=function(t){return!at.isHorizontal(t)&&!at.isPolar(t)},at.isHorizontal=function(t){return"horizontal"==t.getOptions().orientation&&!at.isPolar(t)&&!at.isStock(t)&&(at.isBLAC(t)||at.isFunnel(t))},at.isPolar=function(t){return"polar"==t.getOptions().coordinateSystem&&!at.isStock(t)&&!at.isBoxPlot(t)},at.isStacked=function(t){return!("on"!=t.getOptions().stack||q.isMixedFrequency(t)||Q.getSeriesCount(t)<2)&&at.isBLAC(t)},at.isCombo=function(t){return"combo"==t.getType()},at.isBar=function(t){return"bar"==t.getType()},at.isLine=function(t){return"line"==t.getType()},at.isLineWithArea=function(t){return"lineWithArea"==t.getType()},at.isArea=function(t){return"area"==t.getType()},at.isStock=function(t){return"stock"==t.getType()},at.isBoxPlot=function(t){return"boxPlot"==t.getType()},at.isScatter=function(t){return"scatter"==t.getType()},at.isBubble=function(t){return"bubble"==t.getType()},at.isPie=function(t){return"pie"==t.getType()},at.isFunnel=function(t){return"funnel"==t.getType()},at.isPyramid=function(t){return"pyramid"==t.getType()},at.isDualY=function(t){return!(!at.hasAxes(t)||at.isScatterBubble(t)||at.isPolar(t))},at.isSplitDualY=function(t){return!(!at.isStock(t)||!Q.hasVolumeSeries(t)||at.isOverview(t))||"on"==t.getOptions().splitDualY&&at.hasY2Data(t)&&!at.hasY2DataOnly(t)},at.isBLAC=function(t){var e=t.getType();return"bar"==e||"line"==e||"area"==e||"lineWithArea"==e||"combo"==e||"stock"==e||"boxPlot"==e},at.isScatterBubble=function(t){var e=t.getType();return"scatter"==e||"bubble"==e},at.isLineArea=function(t){var e=t.getType();return"line"==e||"area"==e||"lineWithArea"==e},at.isScrollSupported=function(t){return!(at.isPie(t)||at.isFunnel(t)||at.isPolar(t)||at.isPyramid(t))},at.isOverviewSupported=function(t){return at.isBLAC(t)&&at.isVertical(t)},at.isHorizScrollbarSupported=function(t){var e=J.getZoomDirection(t);return!at.isPolar(t)&&(at.isBLAC(t)&&at.isVertical(t)||at.isScatterBubble(t)&&"y"!=e)},at.isVertScrollbarSupported=function(t){var e=J.getZoomDirection(t);return!at.isPolar(t)&&(at.isBLAC(t)&&at.isHorizontal(t)||at.isScatterBubble(t)&&"x"!=e)},at.hasAxes=function(t){return!("pie"==t.getType()||"funnel"==t.getType()||"pyramid"==t.getType())},at.hasY2DataOnly=function(t){return!!at.isDualY(t)&&Q.getY2SeriesCount(t,null,!0)==Q.getSeriesCount(t)},at.hasY2Data=function(t,e){return!!at.isDualY(t)&&Q.getY2SeriesCount(t,null,!0)>0},at.hasY2BarData=function(t){return at.hasY2Data(t,"bar")},at.hasBarSeries=function(t){return at._hasSeriesType(t,"bar")},at.hasLineSeries=function(t){return at._hasSeriesType(t,"line")},at.hasAreaSeries=function(t){return at._hasSeriesType(t,"area")},at.hasLineWithAreaSeries=function(t){return at._hasSeriesType(t,"lineWithArea")},at.hasCandlestickSeries=function(t){return at._hasSeriesType(t,"candlestick")},at.hasBoxPlotSeries=function(t){return at._hasSeriesType(t,"boxPlot")},at._hasSeriesType=function(t,e){if(at.isBLAC(t))for(var i=Q.getSeriesCount(t),r=0;r<i;r++)if(et.isSeriesRendered(t,r)&&et.getSeriesType(t,r)==e)return!0;return!1},at.hasCenteredSeries=function(t){if(!at.isBLAC(t))return!1;for(var e=Q.getSeriesCount(t),i=0;i<e;i++)if(et.isSeriesRendered(t,i)&&"bar"!=et.getSeriesType(t,i)){var r=et.getLineType(t,i);if("centeredSegmented"==r||"centeredStepped"==r)return!0}return!1},at.hasUncenteredSeries=function(t){if(!at.isBLAC(t))return!1;for(var e=Q.getSeriesCount(t),i=0;i<e;i++)if(et.isSeriesRendered(t,i)&&"bar"!=et.getSeriesType(t,i)){var r=et.getLineType(t,i);if("segmented"==r||"stepped"==r)return!0}return!1},at.isStandalonePlotArea=function(t){var e=t.getOptions();return!it.areTitlesRendered(t)&&("off"==e.legend.rendered&&(!q.isAxisRendered(t,"x")&&(!q.isAxisRendered(t,"y")&&!q.isAxisRendered(t,"y2"))))},at.isStandaloneXAxis=function(t){var e=t.getOptions();return!it.areTitlesRendered(t)&&("off"==e.legend.rendered&&("off"==e.plotArea.rendered&&(!q.isAxisRendered(t,"y")&&!q.isAxisRendered(t,"y2"))))},at.isStandaloneYAxis=function(t){var e=t.getOptions();return!it.areTitlesRendered(t)&&("off"==e.legend.rendered&&(!q.isAxisRendered(t,"x")&&("off"==e.plotArea.rendered&&!q.isAxisRendered(t,"y2"))))},at.isStandaloneY2Axis=function(t){var e=t.getOptions();return!it.areTitlesRendered(t)&&("off"==e.legend.rendered&&(!q.isAxisRendered(t,"x")&&(!q.isAxisRendered(t,"y")&&"off"==e.plotArea.rendered)))};var nt=new Object;t.Obj.createSubclass(nt,t.Obj),nt._MIN_BUBBLE_SIZE=6,nt._MAX_BUBBLE_SIZE_RATIO=.5,nt.calcBubbleSizes=function(e,i){for(var r,a,n=Q.getMinMaxValue(e,"z"),s=n.min,o=n.max,l=nt._MIN_BUBBLE_SIZE,h=nt._MAX_BUBBLE_SIZE_RATIO*Math.min(i.w,i.h),u=Q.getSeriesCount(e),g="withoutRescale"==J.getHideAndShowBehavior(e),d=0;d<u;d++)if(g||et.isSeriesRendered(e,d))for(var c=Q.getSeriesItem(e,d),p=c.items?c.items.length:0,_=0;_<p;_++){var f=c.items[_];if(f){var v=t.LayoutUtils.getBubbleSize(f.z,s,o,l,h);f.markerSize=v}}at.isPolar(e)?(r=1/0,a=e.getRadius()):(r=i.w-2.4*q.getTickLabelHeight(e,"y"),a=i.h-1.6*q.getTickLabelHeight(e,"x")),r-=.5*h,a-=.5*h;var m=e.getCache(),S=nt._getAxisValueRange(e,"x");m.putToCache("_xAxisBubbleRatio",S/r);var C=nt._getAxisValueRange(e,"y");m.putToCache("_yAxisBubbleRatio",C/a)},nt.getBubbleAxisRadius=function(t,e,i){if(!i)return 0;var r="x"==e?"_xAxisBubbleRatio":"_yAxisBubbleRatio";return i/2*t.getCache().getFromCache(r)},nt._getAxisValueRange=function(e,i){var r=e.getOptions()[i+"Axis"],a=q.isLog(e,i),n=!a&&"zero"==q.getBaselineScaling(e,i),s=Q.getMinMaxValue(e,i,!0),o=r.min;null==o&&(o=n?Math.min(0,s.min):s.min);var l=r.max;return null==l&&(l=n?Math.max(0,s.max):s.max),a&&l>0&&o>0?l==o?6:t.Math.log10(l/o):l==o?60:l-o},nt.sortMarkers=function(t){t.sort(nt._compareSize)},nt.sortMarkerInfos=function(t){t.sort(nt._compareInfoSize)},nt._compareSize=function(t,e){return e.getSize()-t.getSize()},nt._compareInfoSize=function(t,e){return e.size-t.size},nt.checkPixelMap=function(t,e,i,r){var a=r/2,n=Math.max(Math.floor(e-a),0),s=Math.max(Math.floor(i-a),0),o=Math.max(Math.ceil(e+a),0),l=Math.max(Math.ceil(i+a),0);return t.isObscured(n,s,o,l)},nt.updatePixelMap=function(t,e,i,r,a){var n=.4*r,s=Math.max(Math.round(e-n),0),o=Math.max(Math.round(e+n),0),l=Math.max(Math.round(i-n),0),h=Math.max(Math.round(i+n),0);t.obscure(s,l,o,h,a)};var st=new Object;t.Obj.createSubclass(st,t.Obj),st.OTHER_SLICE_SERIES_ID="_dvtOther",st.getSliceId=function(t,e){var i=Q.getDataItem(t,e,0),r=i?i.id:null,a=Q.getSeries(t,e),n=Q.getGroup(t,0);return new s(r,a,n,t.getCtx())},st.getOtherSliceId=function(t){var e=Q.getGroup(t,0);return new s(null,st.OTHER_SLICE_SERIES_ID,e,t.getCtx())},st.getRenderedSeriesIndices=function(t){return st._getSeriesIndicesArrays(t).rendered},st.hasOtherSeries=function(t){return st._getSeriesIndicesArrays(t).other.length>0},st.getOtherValue=function(t){for(var e=st._getSeriesIndicesArrays(t).other,i=0,r=0;r<e.length;r++){var a=e[r];if(et.isSeriesRendered(t,a)){var n=Q.getValue(t,a,0);n>0&&(i+=n)}}return i},st.getOtherSliceIds=function(t){for(var e=st._getSeriesIndicesArrays(t).other,i=[],r=0;r<e.length;r++){var a=e[r];i.push(st.getSliceId(t,a))}return i},st.isOtherSliceSelected=function(t,e){for(var i=st.getOtherSliceIds(t),r=0;r<i.length;r++){for(var a=i[r],n=!1,s=0;s<e.length;s++)if(null!=e[s].id&&a.id===e[s].id||a.series===e[s].series&&a.group===e[s].group){n=!0;break}if(!n)return!1}return!0},st._getSeriesIndicesArrays=function(t){for(var e=[],i=[],r=Q.getSeriesCount(t),a=t.getOptions(),n=a.otherThreshold*st.getTotalValue(t),s=0;s<r;s++){var o=Q.getValue(t,s,0);n>0&&o<n?i.push(s):e.push(s)}return"ascending"==a.sorting?e.sort(function(e,i){return Q.getValue(t,e,0)-Q.getValue(t,i,0)}):"on"!=a.sorting&&"descending"!=a.sorting||e.sort(function(e,i){return Q.getValue(t,i,0)-Q.getValue(t,e,0)}),{rendered:e,other:i}},st.getTotalValue=function(t){for(var e=Q.getSeriesCount(t),i=0,r=0;r<e;r++){var a=Q.getValue(t,r,0);a>0&&(i+=a)}return i},st.getSliceExplode=function(t,e){var i=Q.getSeriesItem(t,e);return i&&i.pieSliceExplode?i.pieSliceExplode:0},st.getSliceBySeriesIndex=function(t,e){for(var i=t.pieChart.__getSlices(),r=0;r<i.length;r++)if(i[r].getSeriesIndex()==e)return i[r];return null};var ot=function(){};t.Obj.createSubclass(ot,t.Obj),ot.TWOD="2D",ot.THREED="3D",ot.CRUST="CRUST",ot.SIDE="SIDE",ot.BORDER="BORDER",ot.SURFACE_CRUST=0,ot.SURFACE_LEFT=1,ot.SURFACE_RIGHT=2,ot.SURFACE_TOP=3,ot.reflectAngleOverYAxis=function(e,i,r,a,n){var s=t.Math.degreesToRads(360-e);return{x:i+Math.cos(s)*a,y:r+Math.sin(s)*n}},ot.getGradientColors=function(e,i){return i==ot.TWOD||i==ot.THREED?[t.ColorUtils.adjustHSL(e,0,-.04,-.05),t.ColorUtils.adjustHSL(e,0,-.09,.04)]:i==ot.CRUST?[t.ColorUtils.adjustHSL(e,0,-.04,-.05),t.ColorUtils.adjustHSL(e,0,0,-.14)]:i==ot.SIDE?[t.ColorUtils.adjustHSL(e,0,-.1,.06),t.ColorUtils.adjustHSL(e,0,-.04,-.05)]:void 0},ot.getGradientAlphas=function(t,e){var i=null==t||isNaN(t)||0==t?1:t;return e==ot.TWOD?[i,i,i]:e==ot.BORDER?[i/1.59375,i/5.3125,i/(255/96)]:e==ot.THREED?[i,i,i,i,i]:e==ot.CRUST?[i,i,i,i]:e==ot.SIDE?[i,i]:void 0},ot.createTopSurface=function(e,i){var r=e.getPieChart(),a=r.getCtx(),n=e.getCenter(),s=e.getInnerRadius(),o=r.is3D()||e.getSliceGaps()>Math.sin(t.Math.degreesToRads(e.getAngleExtent()))*e._radiusX+1?null:e.getSliceGaps(),l=new y(a,n.x,n.y,e._radiusX,e._radiusY,e.getAngleStart(),e.getAngleExtent(),o,s),h=et.getSelectedInnerColor(r.chart),u=et.getSelectedOuterColor(r.chart),g=new t.Stroke(e.getStrokeColor(),1,e.getBorderWidth()),d=e.getSeriesIndex(),c=et.getClassName(r.chart,d,0),p=et.getStyle(r.chart,d,0);l.setStyleProperties(i,g,e.getFillColor(),h,u,c,p);var _=[l];return ot.associate(e,_),_},ot.associate=function(t,e){if(e)for(var i=0;i<e.length;i++)t.getPieChart().chart.getEventManager().associate(e[i],t)},ot.createLateralSurface=function(e,i,r){if(0==e.getAngleExtent())return[];var a=[];if(t.ColorUtils.getAlpha(e.getFillColor())>0)if(i==ot.SURFACE_LEFT||i==ot.SURFACE_RIGHT)a.push(ot._generateLateralShape(e,i,null,r));else if(i==ot.SURFACE_CRUST)for(var n=ot._createCrustPathCommands(e),s=n.length,o=0;o<s;o++)a.push(ot._generateLateralShape(e,i,n[o],r));return ot.associate(e,a),a},ot.generateLateralGradientFill=function(e,i){e.getPieChart(),i==ot.CRUST&&e.getDepth();var r=ot.getGradientColors(t.ColorUtils.getRGB(e.getFillColor()),i),a=ot.getGradientAlphas(t.ColorUtils.getAlpha(e.getFillColor()),i);return new t.LinearGradientFill(270,r,a,[0,1],null)},ot._generateLateralShape=function(e,i,r,a){var n=e.getPieChart().getCtx();if(i==ot.SURFACE_LEFT||i==ot.SURFACE_RIGHT){for(var s=e.getAngleStart(),o=e.getAngleExtent(),l=e.getCenter().x,h=e.getCenter().y,u=e._radiusX,g=e._radiusY,d=e.getDepth(),c=i==ot.SURFACE_LEFT?ot.reflectAngleOverYAxis(s+o,l,h,u,g):ot.reflectAngleOverYAxis(s,l,h,u,g),p=ot._generateInnerPoints(l,h,c.x,c.y,d),_=[],f=0;f<p.length;f++)_.push(p[f].x,p[f].y);var v=new t.Polygon(n,_);return v.setFill(a),e.getStrokeColor()&&v.setSolidStroke(e.getStrokeColor()),v}if(r){var m=new t.Path(n,null);return m.setCmds(r),m.setTranslate(e.__getExplodeOffsetX(),e.__getExplodeOffsetY()),m.setFill(a),e.getStrokeColor()&&m.setSolidStroke(e.getStrokeColor()),m}return null},ot._createCrustPathCommands=function(t){var e=t.getAngleStart(),i=t.getAngleExtent(),r=e+i,a=t.getCenter().x,n=t.getCenter().y,s=t._radiusX,o=t._radiusY,l=t.getDepth(),h=[];return e<180&&r>360?(h.push(ot._makeOuterPath(a,n,s,o,l,e,180-e)),h.push(ot._makeOuterPath(a,n,s,o,l,360,r-360)),h.push(ot._makeOuterPath(a,n,s,o,l,180,180))):r>360?(h.push(ot._makeOuterPath(a,n,s,o,l,e,360-e)),h.push(ot._makeOuterPath(a,n,s,o,l,360,r-360))):e<180&&r>180?(h.push(ot._makeOuterPath(a,n,s,o,l,e,180-e)),h.push(ot._makeOuterPath(a,n,s,o,l,180,r-180))):h.push(ot._makeOuterPath(a,n,s,o,l,e,i)),h},ot._makeOuterPath=function(e,i,r,a,n,s,o){var l=t.Math.degreesToRads(o),h=-(t.Math.degreesToRads(s)+l),u=ot.reflectAngleOverYAxis(s,e,i,r,a),g=e+Math.cos(h)*r,d=i+Math.sin(h)*a,c=t.PathUtils.moveTo(u.x,u.y);return c+=t.PathUtils.arcTo(r,a,l,0,g,d),c+=t.PathUtils.lineTo(g,d+n),c+=t.PathUtils.arcTo(r,a,l,1,u.x,u.y+n),c+=t.PathUtils.lineTo(u.x,u.y)},ot._generateInnerPoints=function(t,e,i,r,a){var n=[];return n.push({x:t,y:e}),n.push({x:i,y:r}),n.push({x:i,y:r+a}),n.push({x:t,y:e+a}),n};var lt=function(){this._init()};t.Obj.createSubclass(lt,t.Obj),lt.prototype._init=function(){this._sliceLabel=null,this._slice=null,this._angle=-1,this._position=-1,this._width=-1,this._height=-1,this._x=-1,this._y=-1,this._initialNumLines=-1,this._hasFeeler=!1,this._maxY=-1,this._minY=-1},lt.prototype.getAngle=function(){return this._angle},lt.prototype.setAngle=function(t){this._angle=t},lt.prototype.getHeight=function(){return this._height},lt.prototype.setHeight=function(t){this._height=t},lt.prototype.getInitialNumLines=function(){return this._initialNumLines},lt.prototype.setInitialNumLines=function(t){this._initialNumLines=t},lt.prototype.getMaxY=function(){return this._maxY},lt.prototype.setMaxY=function(t){this._maxY=t},lt.prototype.getMinY=function(){return this._minY},lt.prototype.setMinY=function(t){this._minY=t},lt.prototype.boundY=function(t){return this._minY<=this._maxY&&(t=Math.max(t,this._minY),t=Math.min(t,this._maxY)),t},lt.prototype.hasFeeler=function(){return this._hasFeeler},lt.prototype.setHasFeeler=function(t){this._hasFeeler=t},lt.prototype.getPosition=function(){return this._position},lt.prototype.setPosition=function(t){this._position=t},lt.prototype.getSlice=function(){return this._slice},lt.prototype.setSlice=function(t){this._slice=t},lt.prototype.getSliceLabel=function(){return this._sliceLabel},lt.prototype.setSliceLabel=function(t){this._sliceLabel=t},lt.prototype.getWidth=function(){return this._width},lt.prototype.setWidth=function(t){this._width=t},lt.prototype.getX=function(){return this._x},lt.prototype.setX=function(t){this._x=t},lt.prototype.getY=function(){return this._y},lt.prototype.setY=function(t){this._y=t};var ht=function(){};t.Obj.createSubclass(ht,t.Obj),ht._MAX_LINES_PER_LABEL=3,ht._COLLISION_MARGIN=1,ht._LEFT_SIDE_LABELS=1,ht._RIGHT_SIDE_LABELS=2,ht._OUTSIDE_LABEL_DISTANCE=1.04,ht._FEELER_RAD_MINSIZE=.1,ht._FEELER_HORIZ_MINSIZE=.1,ht._LABEL_TO_FEELER_OFFSET=.5,ht._LABEL_TO_FEELER_DISTANCE=3,ht._NO_COLLISION=0,ht._HALF_COLLISION=1,ht._ALL_COLLISION=2,ht.layoutLabelsAndFeelers=function(t){var e=t.getLabelPosition();ht._layoutInsideLabels(t,"auto"==e),ht._layoutOutsideLabelsAndFeelers(t)},ht._layoutInsideLabels=function(e,i){for(var r=e.__getSlices(),a=0;a<r.length;a++){var n=r[a],s=e.getSeriesLabelPosition(n.getSeriesIndex());if("none"!=s&&"outsideSlice"!=s&&!ht._skipSliceLabel(e,n)){var o=n.getAngleStart()+n.getAngleExtent()/2,l=n.getInnerRadius(),h=n.getCenter(),u=0,g=0,d=ht._createLabel(n,!0);if(1==r.length)u=h.x,g=h.y;else{var c=Math.max(.45,.65-.45*l/Math.max(n.getRadiusY(),.001)),p=ot.reflectAngleOverYAxis(o,h.x,h.y,l+(n.getRadiusX()-l)*c,l+(n.getRadiusY()-l)*c);u=p.x,g=p.y}d.setX(u),d.setY(g),d.alignMiddle(),d.alignCenter();for(var _=d.getDimensions(),f=u,v=u,m=g-_.h/2,S=g+_.h/2;n.contains(f,m)&&n.contains(f,S);)f--;for(;n.contains(v,m)&&n.contains(v,S);)v++;f=Math.ceil(f+3),v=Math.floor(v-3);var C=2*Math.min(u-f,v-u);if(C<_.w&&(d.setX((f+v)/2),C=v-f),i&&"center"!=s){d.getDimensions().w<C?n.setSliceLabel(d):n.setSliceLabel(null)}else{var y=e.getCtx().getStage(),x=ht._isTextLabel(e,n)?null:d.getTextString().length;t.TextUtils.fitText(d,C,_.h,y,x)&&(y.removeChild(d),n.setSliceLabel(d))}null!=n.getSliceLabel()&&n.setNoOutsideFeeler()}}},ht._layoutOutsideLabelsAndFeelers=function(t){var e,i,r=ht._generateInitialLayout(t);e=r[0],i=r[1];var a=ht._refineInitialLayout(t,e,ht._LEFT_SIDE_LABELS),n=ht._refineInitialLayout(t,i,ht._RIGHT_SIDE_LABELS);a==ht._HALF_COLLISION&&n!=ht._NO_COLLISION&&ht._columnLabels(t,e,!0,!0,!0),a!=ht._NO_COLLISION&&n==ht._HALF_COLLISION&&ht._columnLabels(t,i,!1,!0,!0),ht._setLabelsAndFeelers(t,e,ht._LEFT_SIDE_LABELS),ht._setLabelsAndFeelers(t,i,ht._RIGHT_SIDE_LABELS)},ht._createLabel=function(e,i){var r=e.getPieChart(),a=r.getCtx(),n=i?new t.OutputText(a):new t.MultilineText(a),s=r.getOptions().styleDefaults,o=[s.dataLabelStyle],l=Q.getDataItem(r.chart,e.getSeriesIndex(),0);l&&o.push(new t.CSSStyle(l.labelStyle));var h=t.CSSStyle.mergeStyles(o),u=null!=h.getStyle("color");if(!i||u&&!t.Agent.isHighContrast())u||h.setStyle("color",s._defaultSliceLabelColor);else{var g=t.ColorUtils.getContrastingTextColor(e.getFillColor());h.setStyle("color",g)}n.setCSSStyle(h);var d=ht.generateSliceLabelString(e,s.sliceLabelType);return n.setTextString(d),e.setSliceLabelString(d),n},ht.createPieCenter=function(e){var i=e.getOptions(),r=e.getCtx(),a=ht.getPieCenterOptions(i),n=a.label,s=a.renderer,o=e.getLabelPosition(),l=i.tooltip,h=l?l.renderer:null,u=e.getCenter(),g=e.getInnerRadius();if(n||s){var d=e.getRadiusX(),c=(g=g>0?g:"outsideSlice"==o?.9*d:.5*d)*Math.sqrt(2);if(n){var p=new t.MultilineText(r),_=a.labelStyle;if(p.setCSSStyle(_),"number"==typeof n&&(n=rt.formatValue(e,a,n,n,n,0)),p.setTextString(n),t.TextUtils.fitText(p,c,c,e)){var f=p.getDimensions();p.setY(u.y-f.h/2),p.setX(u.x),p.alignCenter(),h||e.chart.getEventManager().associate(p,new t.SimpleObjPeer(p.getTextString(),null,null,{type:"pieCenterLabel"})),e.addChild(p),e.setCenterLabel(p)}}if(h){var v=new t.Circle(r,u.x,u.y,g);v.setInvisibleFill(),e.addChild(v);var m=e.getCtx().getTooltipManager();e.chart.getEventManager().associate(v,new t.CustomDatatipPeer(m,h,"#4b4b4b",{component:i._widgetConstructor,label:n}))}if(s){var S={outerBounds:{x:u.x-g,y:u.y-g,width:2*g,height:2*g},innerBounds:{x:u.x-c/2,y:u.y-c/2,width:c,height:c},label:n,totalValue:e.getTotalValue(),component:i._widgetConstructor};S=r.fixRendererContext(S);var C=r.getContainer(),y=e.chart.pieCenterDiv;y&&C.removeChild(y);var x=s(S);if(!x)return;var A=r.createOverlayDiv();Array.isArray(x)?x.forEach(function(t){A.appendChild(t)}):A.appendChild(x),e.chart.pieCenterDiv=A,C.appendChild(A);var b=r.getOverlayAttachedCallback();b&&b(A)}}},ht.generateSliceLabelString=function(t,e){var i,r=ht.getDefaultSliceLabelString(t,e),a=t.getPieChart().getOptions().dataLabel;if(a){var n=Q.getDataContext(t._chart,t.getSeriesIndex(),0);if(n.label=r,"number"==typeof(i=a(n))){var s=rt.getValueFormat(t.getPieChart().chart,"label");i=rt.formatValue(t.getPieChart(),s,i)}}return i||r},ht.getDefaultSliceLabelString=function(t,e){var i=t.getPieChart(),r=t.getCustomLabel(),a=rt.getValueFormat(i.chart,"label");return null!=r?"number"==typeof r?rt.formatValue(i,a,r):r:"percent"==e?ht.generateSlicePercentageString(t):"number"==e?rt.formatValue(i,a,t.getValue()):"text"==e?t.getSeriesLabel():"textAndPercent"==e?t.getSeriesLabel()+", "+ht.generateSlicePercentageString(t):null},ht.generateSlicePercentageString=function(t){var e=t.getPieChart(),i=e.getTotalValue(),r=0==i?0:t.getValue()/i,a=r<.01?3:r<.1?2:r<1?1:0;2*e.getRadiusX()<150&&(a=Math.max(a-1,0));var n=e.getCtx().getNumberConverter({style:"percent",maximumFractionDigits:a,minimumFractionDigits:a}),s="";return n&&n.getAsString?s=n.getAsString(r):n&&n.format?s=n.format(r):(r*=100,s=rt.formatValue(e,{},r,null,null,100==r?1:Math.pow(10,-1*a))+"%"),s},ht._refineInitialLayout=function(t,e,i){if(e&&e.length>0){for(var r,a=t.__getFrame().y,n=!1,s=!1,o=!1,l=0,h=!1,u=h,g=i==ht._LEFT_SIDE_LABELS,d=0;d<e.length;d++)u=h,(r=e[d]).getPosition()>90&&(h=!0),l=r.getY()+r.getHeight(),a-r.getY()>ht._COLLISION_MARGIN&&(h?h&&!u?s=!0:o=!0:n=!0),l>a&&(a=l);return n&&o||s?(ht._columnLabels(t,e,g,!0,!0),ht._ALL_COLLISION):n?(ht._columnLabels(t,e,g,!0,!1),ht._HALF_COLLISION):o?(ht._columnLabels(t,e,g,!1,!0),ht._HALF_COLLISION):ht._NO_COLLISION}},ht._setLabelsAndFeelers=function(e,i,r){if(!(null==i||i.length<=0)){var a,n,s,o,l,h=r==ht._LEFT_SIDE_LABELS,u=e.__getFrame(),g=1/0;for(a=0;a<i.length;a++)if(n=(o=i[a]).getSlice(),o.hasFeeler()){l=ht._calculateFeeler(o,n,h);var d=t.TextUtils.getTextStringHeight(e.getCtx(),o.getSliceLabel().getCSSStyle()),c=o.getWidth(),p=ht._isTextLabel(e,n)?Math.min(2*d,c):c;if(ht.getMaxLabelWidth(e,o.getX(),h)+l<p||0==o.getWidth()){o.setSliceLabel(null),n.setNoOutsideFeeler();continue}g=Math.min(g,l)}else n.setNoOutsideFeeler();for(a=0;a<i.length;a++)n=(o=i[a]).getSlice(),(s=o.getSliceLabel())&&(o.hasFeeler()&&(h?o.setX(o.getX()+g):o.setX(o.getX()-g),ht._calculateFeeler(o,n,h)),s.setY(o.getY()),s.setX(o.getX()),o.getY()<u.y||o.getY()+o.getHeight()>u.y+u.h?(n.setSliceLabel(null),n.setNoOutsideFeeler()):(ht._truncateSliceLabel(e,n,o,h),0==o.getWidth()||0==o.getHeight()?(n.setSliceLabel(null),n.setNoOutsideFeeler()):n.setSliceLabel(s)))}},ht._calculateFeeler=function(e,i,r){var a,n=e.getX(),s=e.getY()+e.getHeight()*ht._LABEL_TO_FEELER_OFFSET,o=ht._FEELER_HORIZ_MINSIZE*i.getRadiusX(),l={x:r?(n+=ht._LABEL_TO_FEELER_DISTANCE)+o:(n-=ht._LABEL_TO_FEELER_DISTANCE)-o,y:s},h={x:n,y:s},u=e.getAngle(),g=ht._adjustForDepth(u,i.getDepth());a=ot.reflectAngleOverYAxis(u,i.getCenter().x,i.getCenter().y+g,i.getRadiusX(),i.getRadiusY());var d=t.Math.degreesToRads(e.getPosition()),c=Math.abs(Math.atan2(l.x-a.x,a.y-l.y)),p=(a.y-l.y)*Math.tan(d);return(d>Math.PI/2&&c>Math.PI/2&&c<d||d<Math.PI/2&&c<Math.PI/2&&c>d)&&(l.x=r?a.x-p:a.x+p),i.setOutsideFeelerPoints(a,l,h),Math.abs(h.x-l.x)-o},ht._adjustForDepth=function(t,e){var i=0;return t>189&&t<351&&(i=e),i},ht._getMiddleLabel=function(t){for(var e=91,i=-1,r=0;r<t.length;r++){var a=t[r].getPosition();Math.abs(a-90)<e&&(e=Math.abs(a-90),i=r)}return i},ht._setOptimalLabelPosition=function(e,i,r,a){i.setX(r);var n=e.getRadiusY()*(1+ht._FEELER_RAD_MINSIZE),s=t.Math.degreesToRads(i.getPosition()),o=n*Math.cos(s),l=ht._adjustForDepth(i.getAngle(),e.getDepth()),h=e.getCenter().y-o-i.getHeight()*ht._LABEL_TO_FEELER_OFFSET+l;i.setY(i.boundY(h))},ht._getRadFeelerAngle=function(t,e,i){var r=t.getSlice(),a=r.getCenter(),n=t.getAngle(),s=ht._adjustForDepth(n,r.getDepth()),o=ot.reflectAngleOverYAxis(n,a.x,a.y+s,r.getRadiusX(),r.getRadiusY());return Math.atan2(Math.abs(e-o.x),o.y-i)},ht._columnLabels=function(e,i,r,a,n){var s,o,l,h=e.__getFrame(),u=h.y,g=h.y+h.h,d=0,c=e.getCenter().x,p=e.getRadiusX()*(1+ht._FEELER_RAD_MINSIZE+ht._FEELER_HORIZ_MINSIZE);for(l=r?(c-=p)+e.getRadiusX()*ht._FEELER_HORIZ_MINSIZE:(c+=p)-e.getRadiusX()*ht._FEELER_HORIZ_MINSIZE,s=0;s<i.length;s++)o=i[s],d=t.Math.degreesToRads(o.getPosition()),ht._getRadFeelerAngle(o,l,u)-d>.45*Math.PI||ht._skipSliceLabel(e,o.getSlice())?(i.splice(s,1),s--):(i[s].setMinY(u),u+=i[s].getHeight());for(s=i.length-1;s>=0;s--)o=i[s],(d=t.Math.degreesToRads(o.getPosition()))-ht._getRadFeelerAngle(o,l,g)>.45*Math.PI||ht._skipSliceLabel(e,o.getSlice())?i.splice(s,1):(g-=i[s].getHeight(),i[s].setMaxY(g));if(0!=i.length){var _=ht._getMiddleLabel(i),f=i[_];a&&!n&&f.getMinY()+f.getHeight()>e.getCenter().y&&(n=!0),n&&!a&&f.getMaxY()<e.getCenter().y&&(a=!0);var v=f.getPosition();(n&&a||v>90&&n||v<=90&&a)&&(ht._setOptimalLabelPosition(e,f,c,r),f.setHasFeeler(!0));var m,S,C=f.getY(),y=f.getY()+f.getHeight();if(a)for(s=_-1;s>=0;s--)S=(o=i[s]).getHeight(),ht._setOptimalLabelPosition(e,o,c,r),o.setHasFeeler(!0),(m=o.getY())+S<C?C=m:C-=S,o.setY(C);if(n)for(s=_+1;s<i.length;s++)S=(o=i[s]).getHeight(),ht._setOptimalLabelPosition(e,o,c,r),o.setHasFeeler(!0),(m=o.getY())>y?y=m+S:y+=S,o.setY(y-S)}},ht._truncateSliceLabel=function(t,e,i,r){var a,n,s=i.getSliceLabel(),o=s.getCSSStyle(),l=t.getNumChildren(),h=!1;t.contains(s)||(t.addChild(s),h=!0),s.setCSSStyle(o);var u=e.getSliceLabelString();return s.setTextString(u),h&&t.removeChildAt(l),a=ht.getMaxLabelWidth(t,i.getX(),r),n=ht._getTextDimension(t,e,s,a,i.getInitialNumLines()),i.setWidth(n.x),i.getHeight()!=n.y&&(i.setHeight(n.y),!0)},ht._generateInitialLayout=function(t){for(var e=new Array(2),i=[],r=[],a=t.__getSlices(),n=t.__getFrame(),s=0;s<a.length;s++){var o=a[s],l=t.getSeriesLabelPosition(o.getSeriesIndex());if(null==o.getSliceLabel()&&"none"!=l&&"center"!=l&&!ht._skipSliceLabel(t,o)){var h=ht._createLabel(o,!1),u=o.getAngleStart()+o.getAngleExtent()/2;u>360&&(u-=360),u<0&&(u+=360);var g=ot.reflectAngleOverYAxis(u,t.getCenter().x,t.getCenter().y,t.getRadiusX()*ht._OUTSIDE_LABEL_DISTANCE,t.getRadiusY()*ht._OUTSIDE_LABEL_DISTANCE),d=u>=90&&u<270,c=ht.getMaxLabelWidth(t,g.x,d),p=ht._getTextDimension(t,o,h,c,ht._MAX_LINES_PER_LABEL);u<165&&u>15?g.y-=1*p.y:u<15||u>345?(g.y-=.5*p.y,g.x+=.2*p.y):u>165&&u<195&&(g.y-=.5*p.y,g.x-=.2*p.y);var _,f=ht._adjustForDepth(u,t.getDepth());if(g.y+=f,1==a.length&&(g.x-=p.x/2),!(g.y<n.y||g.y+p.y>n.y+n.h))u>=90&&u<270?(h.alignRight(),_=u-90,ht._createLabelInfo(o,h,u,_,p,g,i)):(_=u<=90?Math.abs(90-u):180-(u-270),ht._createLabelInfo(o,h,u,_,p,g,r))}}return e[0]=i,e[1]=r,e},ht._createLabelInfo=function(t,e,i,r,a,n,s){for(var o,l=-1,h=e,u=0;u<s.length;u++)if((o=s[u]).getPosition()>r){l=u;break}-1==l&&(l=s.length),(o=new lt).setPosition(r),o.setAngle(i),o.setSliceLabel(h),o.setSlice(t),o.setWidth(a.x),o.setHeight(a.y),o.setX(n.x),o.setY(n.y),o.setInitialNumLines(h.getLineCount()),s.splice(l,0,o)},ht._getTextDimension=function(e,i,r,a,n){r.setMaxLines(n);var s=ht._isTextLabel(e,i)?null:r.getTextString().length;if(t.TextUtils.fitText(r,a,1/0,e,s)){e.addChild(r);var o=r.getDimensions();return e.removeChild(r),{x:o.w,y:o.h}}return{x:0,y:0}},ht._isTextLabel=function(t,e){var i=e.getCustomLabel(),r=null!=t.getOptions().dataLabel;return-1!=t.getOptions().styleDefaults.sliceLabelType.indexOf("text")||null!=i&&"number"!=typeof i||r},ht.getMaxLabelWidth=function(t,e,i){var r=t.__getFrame();return i?e-r.x:r.x+r.w-e},ht.getPieCenterOptions=function(e){var i=t.JsonUtils.clone(e.pieCenter),r=e.pieCenterLabel;if(r){var a=r.style,n=r.text;n&&(i.label=n),a&&(i.labelStyle=new t.CSSStyle(a))}return i},ht._skipSliceLabel=function(t,e){return e.getAngleExtent()<3&&Q.getSeriesCount(t.chart)>120};var ut=new Object;t.Obj.createSubclass(ut,t.Obj),ut._BUTTON_SIZE=16,ut._BUTTON_PADDING=5,ut._BUTTON_CORNER_DIST=4,ut._BUTTON_OPACITY=.8,ut._MOUSE_WHEEL_ZOOM_RATE_SLOW=.05,ut._MOUSE_WHEEL_ZOOM_RATE_FAST=.2,ut.render=function(t,e,i){if(ut._renderBackground(t,e,i),Q.hasInvalidData(t))ut.renderEmptyText(t,e,i);else{at.isOverview(t)||(t.getOptions()._maxOverflowCoord=i.x+i.w,t.getOptions()._minOverflowCoord=i.x),ut._addOuterGaps(t,i);var r=i.clone();ut._renderTitles(t,e,i),ut._adjustAvailSpace(i),dt.render(t,e,i),ut._adjustAvailSpace(i);var a=ut._prerenderHorizScrollbar(t,e,i),n=ut._prerenderVertScrollbar(t,e,i);ut._adjustAvailSpace(i),t.__setAxisSpace(i.clone()),gt.render(t,e,i),ut._adjustAvailSpace(i),ut._positionLegend(t.legend,i),t.__setPlotAreaSpace(i.clone()),ut._setEventHandlers(t),ut._renderScrollbars(t,a,n),ut._updateTitles(t,e,r,i),ut._renderPlotArea(t,e,i),at.isPolar(t)&&e.addChild(t.yAxis),ut._renderDragButtons(t,e)}},ut._setEventHandlers=function(e){var i=e.getOptions(),r=e.getEventManager();if(at.hasAxes(e)&&!at.isOverview(e)){var a,n,s=new t.Rectangle(0,0,e.getWidth(),e.getHeight()),o=e.__getPlotAreaSpace(),l=e.__getAxisSpace(),h=new t.Rectangle(o.x,l.y,o.w,l.h),u=new t.Rectangle(l.x,o.y,l.w,o.h),g=new t.SolidFill(i.styleDefaults.marqueeColor),d=new t.Stroke(i.styleDefaults.marqueeBorderColor);if(J.isScrollable(e)){var c=J.isDelayedScroll(e)?ut._MOUSE_WHEEL_ZOOM_RATE_FAST:ut._MOUSE_WHEEL_ZOOM_RATE_SLOW;if((n=new t.PanZoomHandler(e,o,s,c)).setPanCursor(i._resources.panCursorUp,i._resources.panCursorDown),r.setPanZoomHandler(n),J.isZoomable(e)){var p=J.getZoomDirection(e);a=at.isHorizontal(e)||"y"==p?new t.MarqueeHandler(e,o,s,g,d,!1,!0,null,u):at.isBLAC(e)||"x"==p?new t.MarqueeHandler(e,o,s,g,d,!0,!1,h,null):new t.MarqueeHandler(e,o,s,g,d,!0,!0,h,u),r.setMarqueeZoomHandler(a)}}"multiple"==i.selectionMode&&(a=new t.MarqueeHandler(e,o,s,g,d,!0,!0,h,u),r.setMarqueeSelectHandler(a))}},ut.rerenderAxisAndPlotArea=function(t,e){if(!Q.hasInvalidData(t)){var i=t.__getAxisSpace().clone(),r=t.getSelectionHandler();if(r)var a=r.getSelectedIds();var n=t.__cacheChartFocus();t.__cleanUpAxisAndPlotArea(),gt.render(t,e,i),ut._adjustAvailSpace(i),t.__setPlotAreaSpace(i.clone()),ut._renderPlotArea(t,e,i),r&&r.processInitialSelections(a,t.getChartObjPeers()),t.getEventManager().autoToggleZoomButton(),ut.positionDragButtons(t),t.highlight(et.getHighlightedCategories(t)),t.__restoreChartFocus(n)}},ut._renderBackground=function(e,i,r){var a=new t.Rect(e.getCtx(),r.x,r.y,r.w,r.h);a.setInvisibleFill(),i.addChild(a)},ut._addOuterGaps=function(t,e){var i=t.getOptions(),r=o.getGapWidth(t,i.layout.outerGapWidth),a=o.getGapHeight(t,i.layout.outerGapHeight);("none"==i.styleDefaults.padding||at.isStandalonePlotArea(t)||at.isStandaloneXAxis(t)||at.isStandaloneYAxis(t)||at.isStandaloneY2Axis(t))&&(r=Math.min(r,1),a=Math.min(a,1)),e.x+=r,e.w-=2*r,e.y+=a,e.h-=2*a},ut._renderTitles=function(e,i,r){var a=e.getOptions();if(a.title.text){var n,s,l=it.createText(e.getEventManager(),i,a.title.text,a.title.style,r.x,r.y,r.w,r.h),h=null!=a.title.hAlign?a.title.hAlign:a.title.halign,u="plotArea"==h.substring(0,8);if(l?(n=(s=l.getDimensions()).h,l.setAriaProperty("hidden",null)):(n=0,s=new t.Rectangle(0,0,0,0)),a.subtitle.text){var g=new t.OutputText(e.getCtx(),a.subtitle.text,r.x,r.y);if(g){g.setCSSStyle(a.subtitle.style),i.addChild(g);var d=g.getDimensions(),c=o.getGapWidth(e,a.layout.titleSubtitleGapWidth),p=s.w+c+d.w;if(p>r.w||u)c=o.getGapHeight(e,a.layout.titleSubtitleGapHeight),g.setY(r.y+n+c),t.TextUtils.fitText(g,r.w,r.h,i)&&(n+=(d=g.getDimensions()).h+c,t.Agent.isRightToLeft(e.getCtx())&&(g&&g.setX(r.w-d.w),l&&l.setX(r.w-s.w)));else{var _=s.h-d.h;g.setY(_+r.y),l&&(t.LayoutUtils.align(r,h,l,p),t.Agent.isRightToLeft(e.getCtx())?(g.setX(l.getX()),l&&l.setX(l.getX()+d.w+c)):g.setX(l.getX()+p-d.w))}g.setAriaProperty("hidden",null),e.getEventManager().associate(g,new t.SimpleObjPeer(g.getUntruncatedTextString()))}}else t.LayoutUtils.align(r,h,l,s.w);u&&(e.getCache().putToCache("title",l),e.getCache().putToCache("subtitle",g));var f="on"==a.titleSeparator.rendered?a.layout.titleSeparatorGap:a.layout.titlePlotAreaGap;if(r.y+=n+o.getGapHeight(e,f),r.h-=n+o.getGapHeight(e,f),"on"==a.titleSeparator.rendered){var v=new t.Line(e.getCtx(),r.x,r.y,r.x+r.w,r.y),m=new t.Line(e.getCtx(),r.x,r.y+1,r.x+r.w,r.y+1);v.setSolidStroke(a.titleSeparator.upperColor),m.setSolidStroke(a.titleSeparator.lowerColor),i.addChild(v),i.addChild(m);var S=2+o.getGapHeight(e,a.layout.titlePlotAreaGap);r.y+=S,r.h-=S}}if(a.footnote.text){var C=it.createText(e.getEventManager(),i,a.footnote.text,a.footnote.style,r.x,0,r.w,r.h),y=null!=a.footnote.hAlign?a.footnote.hAlign:a.footnote.halign,x="plotArea"==y.substring(0,8);if(C){var A=C.getDimensions();C.setY(r.y+r.h-A.h),r.h-=A.h+o.getGapHeight(e,a.layout.footnoteGap),t.LayoutUtils.align(r,y,C,A.w),C.setAriaProperty("hidden",null)}x&&e.getCache().putToCache("footnote",C)}},ut._updateTitles=function(t,e,i,r){var a=t.getOptions(),n=null!=a.title.hAlign?a.title.hAlign:a.title.halign,s=null!=a.footnote.hAlign?a.footnote.hAlign:a.footnote.halign,o=a.title.text&&"plotArea"==n.substring(0,8),l=a.footnote.text&&"plotArea"==s.substring(0,8);if(i.x=r.x,i.w=r.w,o){var h,u=t.getCache().getFromCache("title"),g=t.getCache().getFromCache("subtitle"),d=u.getDimensions();ut._alignTextToPlotArea(e,i,n,u,d.w),g&&(h=g.getDimensions(),ut._alignTextToPlotArea(e,i,n,g,h.w))}if(l){var c=t.getCache().getFromCache("footnote"),p=c.getDimensions();ut._alignTextToPlotArea(e,i,s,c,p.w)}},ut._alignTextToPlotArea=function(e,i,r,a,n){t.TextUtils.fitText(a,i.w,i.h,e)&&("plotAreaStart"==r?t.LayoutUtils.align(i,"start",a,n):"plotAreaCenter"==r?t.LayoutUtils.align(i,"center",a,n):"plotAreaEnd"==r&&t.LayoutUtils.align(i,"end",a,n))},ut._renderPlotArea=function(e,i,r){if(at.hasAxes(e)){var a=new t.Container(e.getCtx());a.setTranslate(r.x,r.y),i.addChild(a),e.setPlotArea(a),e.getEventManager().associate(a,new t.SimpleObjPeer(null,null,null,{type:"plotArea"}));var n=new t.Rectangle(0,0,r.w,r.h);ct.render(e,a,n)}else if(at.isPie(e)){var s=new k(e,r);s.__getSlices().length>0?(i.addChild(s),e.setPlotArea(s),s.render()):ut.renderEmptyText(e,i,r)}else at.isFunnel(e)?pt.render(e,i,r):at.isPyramid(e)&&_t.render(e,i,r);r.w=0,r.h=0},ut.renderEmptyText=function(e,i,r){var a=e.getOptions();if(Q.hasInvalidTimeData(e)&&Q.hasData(e))var n=a.translations.labelInvalidData;else(n=a.emptyText)||(n=a.translations.labelNoData);t.TextUtils.renderEmptyText(i,n,new t.Rectangle(r.x,r.y,r.w,r.h),e.getEventManager(),a._statusMessageStyle)},ut._prerenderHorizScrollbar=function(e,i,r){var a=r.w,n=0;return J.isScrollable(e)&&at.isHorizScrollbarSupported(e)?et.isOverviewRendered(e)?(n=Math.min(et.getOverviewHeight(e),r.h))>0&&(e.overview=new E(e),i.addChild(e.overview),t.LayoutUtils.position(r,"bottom",e.overview,a,n,10)):(n=e.getOptions().styleDefaults._scrollbarHeight,e.xScrollbar=new t.SimpleScrollbar(e.getCtx(),e.processEvent,e),i.addChild(e.xScrollbar),t.LayoutUtils.position(r,"bottom",e.xScrollbar,a,n,8),e.overview=null):e.overview=null,new t.Dimension(a,n)},ut._prerenderVertScrollbar=function(e,i,r){var a=0,n=r.h;if(J.isScrollable(e)&&at.isVertScrollbarSupported(e)){a=e.getOptions().styleDefaults._scrollbarHeight;var s=new t.SimpleScrollbar(e.getCtx(),e.processEvent,e);i.addChild(s),t.LayoutUtils.position(r,t.Agent.isRightToLeft(e.getCtx())?"right":"left",s,a,n,8),at.isHorizontal(e)?e.xScrollbar=s:e.yScrollbar=s}return new t.Dimension(a,n)},ut._renderScrollbars=function(e,i,r){var a=e.getOptions(),n={color:a.styleDefaults._scrollbarHandleColor,backgroundColor:a.styleDefaults._scrollbarTrackColor},s=e.__getPlotAreaSpace();if(e.xScrollbar&&(n.min=e.xAxis.getLinearGlobalMin(),n.max=e.xAxis.getLinearGlobalMax(),at.isHorizontal(e)?(n.isHorizontal=!1,n.isReversed=!1,e.xScrollbar.setTranslateY(s.y),e.xScrollbar.render(n,r.w,s.h)):(n.isHorizontal=!0,n.isReversed=t.Agent.isRightToLeft(e.getCtx()),e.xScrollbar.setTranslateX(s.x),e.xScrollbar.render(n,s.w,i.h)),e.xScrollbar.setViewportRange(e.xAxis.getLinearViewportMin(),e.xAxis.getLinearViewportMax())),e.yScrollbar&&(n.min=e.yAxis.getLinearGlobalMin(),n.max=e.yAxis.getLinearGlobalMax(),n.isHorizontal=!1,n.isReversed=!0,e.yScrollbar.setTranslateY(s.y),e.yScrollbar.render(n,r.w,s.h),e.yScrollbar.setViewportRange(e.yAxis.getLinearViewportMin(),e.yAxis.getLinearViewportMax())),e.overview){var o={xMin:e.xAxis.getLinearGlobalMin(),xMax:e.xAxis.getLinearGlobalMax(),x1:e.xAxis.getLinearViewportMin(),x2:e.xAxis.getLinearViewportMax(),minimumWindowSize:e.xAxis.getInfo().getMinimumExtent(),chart:t.JsonUtils.clone(a)};J.isZoomable(e)||(o.featuresOff="zoom"),o.chart._minOverflowCoord=a._minOverflowCoord-s.x,o.chart._maxOverflowCoord=a._maxOverflowCoord-s.x,e.overview.setTranslateX(s.x),e.overview.render(o,s.w,i.h),e.overview.setViewportRange(e.xAxis.getLinearViewportMin(),e.xAxis.getLinearViewportMax())}},ut._positionLegend=function(t,e){if(t){var i=t.getDimensions(),r=t.getOptions().orientation;"vertical"==r&&i.h<=e.h?t.setTranslateY(Math.round(e.y+e.h/2-i.h/2)):"horizontal"==r&&i.w<=e.w&&t.setTranslateX(Math.round(e.x+e.w/2-i.w/2))}},ut._renderDragButtons=function(e,r){var a=ut._BUTTON_SIZE+2*(ut._BUTTON_PADDING+ut._BUTTON_CORNER_DIST),n=e.__getPlotAreaSpace();if(!(!at.hasAxes(e)||at.isOverview(e)||n.w<a||n.h<a)){var s=e.getOptions(),o=s.translations,l=e.getEventManager(),h=s.dragMode;if("user"==h){var u,g,d=t.Agent.isTouchDevice(),c=J.isScrollable(e);e.dragButtons=new t.Container(e.getCtx());var p="multiple"==s.selectionMode&&(d||c),_=c&&d,f=c&&!d&&J.isZoomable(e)&&at.isScatterBubble(e);p&&(g=_||f?"end":"solo",l.selectButton=ut._createDragButton(e,e.dragButtons,"select",l.onSelectButtonClick,l,g),u=o.tooltipSelect,l.selectButton.setTooltip(u),l.associate(l.selectButton,l.selectButton)),_&&(g=p?"start":"solo",l.panButton=ut._createDragButton(e,e.dragButtons,"pan",l.onPanButtonClick,l,g),u=o.tooltipPan,l.panButton.setTooltip(u),l.associate(l.panButton,l.panButton)),f&&(g=p?"start":"solo",l.zoomButton=ut._createDragButton(e,e.dragButtons,"zoom",l.onZoomButtonClick,l,g),u=o.tooltipZoom,l.zoomButton.setTooltip(u),l.associate(l.zoomButton,l.zoomButton)),ut.positionDragButtons(e),l.setDragMode(null),e.dragButtons.getNumChildren()>0&&(e.addChild(e.dragButtons),d?c&&(l.panButton.setToggled(!0),l.onPanButtonClick(null)):e.hideDragButtons(),e.dragButtons.setCursor("default"))}else"pan"==h?l.setDragMode(i.DRAG_MODE_PAN):"zoom"==h?l.setDragMode(i.DRAG_MODE_ZOOM):"select"==h?l.setDragMode(i.DRAG_MODE_SELECT):l.setDragMode(i.DRAG_MODE_OFF)}},ut._positionDragButton=function(e,i,r){var a;t.Agent.isRightToLeft(e.getCtx())?(a=r.x+ut._BUTTON_PADDING,r.x+=ut._BUTTON_SIZE+2*ut._BUTTON_PADDING):a=r.x+r.w-ut._BUTTON_SIZE-ut._BUTTON_PADDING,r.w-=ut._BUTTON_SIZE+2*ut._BUTTON_PADDING,i.setTranslate(a,r.y+ut._BUTTON_PADDING)},ut.positionDragButtons=function(t){var e=t.__getPlotAreaSpace().clone();e.x+=ut._BUTTON_CORNER_DIST,e.w-=2*ut._BUTTON_CORNER_DIST,e.y+=ut._BUTTON_CORNER_DIST;var i=t.getEventManager();i.selectButton&&ut._positionDragButton(t,i.selectButton,e),i.panButton&&ut._positionDragButton(t,i.panButton,e),i.zoomButton&&ut._positionDragButton(t,i.zoomButton,e)},ut._createDragButtonBackground=function(e,i,r){var a=2,n=2,s=t.Agent.isRightToLeft(e);"start"==i?s?a=0:n=0:"end"==i&&(s?n=0:a=0);var o=a,l=n,h=-ut._BUTTON_PADDING,u=ut._BUTTON_SIZE+2*ut._BUTTON_PADDING,g=t.PathUtils.roundedRectangle(h,h,u,u,o,n,l,a),d=new t.Path(e,g);return t.Agent.getDevicePixelRatio()>1?(d.setSolidStroke(r,ut._BUTTON_OPACITY,1),d.setPixelHinting(!0)):d.setSolidStroke(r,ut._BUTTON_OPACITY,1),d},ut._createDragButton=function(e,i,r,a,n,s){var o=e.getCtx(),l=e.getOptions()._resources,h=ut._createDragButtonBackground(o,s,"#C4CED7"),u=l[r+"Up"];h.setFill(new t.LinearGradientFill(270,["#FFFFFF","#F1F3F4","#E8EBED","#E4E8EA"],[ut._BUTTON_OPACITY,ut._BUTTON_OPACITY,ut._BUTTON_OPACITY,ut._BUTTON_OPACITY],[0,.0364,.5,1])),h.addChild(new t.Image(o,u,0,0,ut._BUTTON_SIZE,ut._BUTTON_SIZE));var g=ut._createDragButtonBackground(o,s,"#C4CED7"),d=l[r+"UpHover"]?l[r+"UpHover"]:u;g.setSolidFill("#F7F8F9",ut._BUTTON_OPACITY),g.addChild(new t.Image(o,d,0,0,ut._BUTTON_SIZE,ut._BUTTON_SIZE));var c=ut._createDragButtonBackground(o,s,"#0572CE"),p=l[r+"Down"];c.setSolidFill("#0572CE",ut._BUTTON_OPACITY),c.addChild(new t.Image(o,p,0,0,ut._BUTTON_SIZE,ut._BUTTON_SIZE));var _=ut._createDragButtonBackground(o,s,"#0572CE"),f=l[r+"DownHover"]?l[r+"DownHover"]:p;_.setSolidFill("#0572CE",ut._BUTTON_OPACITY),_.addChild(new t.Image(o,f,0,0,ut._BUTTON_SIZE,ut._BUTTON_SIZE));var v=new t.Button(o,h,g,c,null,null,a,n);if(v.setOverDownState(_),v.setToggleEnabled(!0),i.addChild(v),v.addEvtListener(t.MouseEvent.MOUSEDOWN,function(t){t.stopPropagation()}),t.Agent.isTouchDevice()){var m,S=t.Agent.isRightToLeft(o),C=2*ut._BUTTON_PADDING;(m="solo"==s?new t.Rect(o,-C,-C,ut._BUTTON_SIZE+2*C,ut._BUTTON_SIZE+2*C):"start"==s&&!S||"end"==s&&S?new t.Rect(o,-C,-C,ut._BUTTON_SIZE+1.5*C,ut._BUTTON_SIZE+2*C):new t.Rect(o,-.5*C,-C,ut._BUTTON_SIZE+1.5*C,ut._BUTTON_SIZE+2*C)).setInvisibleFill(),v.addChild(m)}return v},ut._adjustAvailSpace=function(t){t.x=Math.round(t.x),t.y=Math.round(t.y),t.w=Math.round(t.w),t.h=Math.round(t.h)},ut.renderDataCursor=function(t){var e=null,i=t.getOptions(),r=t.getEventManager();if(rt.isDataCursorEnabled(t)){(e=new w(t.getCtx(),i.styleDefaults.dataCursor,at.isHorizontal(t))).setBehavior(rt.getDataCursorBehavior(t)),t.addChild(e);var a=new l(t,e);r.setDataCursorHandler(a),t.positionDataCursor(i.dataCursorPosition)}else r.setDataCursorHandler(null);return e};var gt=new Object;t.Obj.createSubclass(gt,t.Obj),gt._DEFAULT_AXIS_MAX_SIZE=.33,gt.render=function(t,e,i){at.hasAxes(t)&&(q.applyInitialZooming(t,i),at.isBubble(t)&&nt.calcBubbleSizes(t,i),at.isPolar(t)?gt._renderPolar(t,e,i):gt._renderCartesian(t,e,i))},gt._renderCartesian=function(e,i,r){var a=e.getOptions(),n=at.isHorizontal(e),s=at.isSplitDualY(e),o=r.clone(),l=q.getYAxisPosition(e),h=q.getY2AxisPosition(e);gt._addAxisGaps(e,r),s&&l==h&&(a.yAxis._skipHighestTick=n,a.y2Axis._skipHighestTick=!n);var u=gt._createYAxis(e,i,r,o),g=gt._createY2Axis(e,i,r,o),d=!s&&"on"==a.y2Axis.alignTickMarks&&null==a.y2Axis.step;d&&u&&g&&(gt._alignYAxes(e,u,g),n||(g.dim=gt._getPreferredSize(e,g.axis,e.y2Axis,g.options,"y2",r,o)));var c,p=q.getTickLabelGapSize(e,"y"),_=q.getTickLabelGapSize(e,"y2");s&&l==h?(n?(c=Math.max(u.dim.h+p,g.dim.h+_),u.dim.h=c-p,g.dim.h=c-_):(c=Math.max(u.dim.w+p,g.dim.w+_),u.dim.w=c-p,g.dim.w=c-_),gt._positionAxis(r.clone(),u,p),gt._positionAxis(r,g,_)):(gt._positionAxis(r,u,p),gt._positionAxis(r,g,_));var f=Q.getGroupCount(e);if("pixel"==et.getBarSpacing(e)&&at.isBar(e)&&r.w>f){var v=Math.floor(r.w/f)*f;r.x+=(r.w-v)/2,r.w=v}var m=gt._createXAxis(e,i,r,o);m.axis.render(m.options,m.dim.w,m.dim.h),gt._positionAxis(r,m,q.getTickLabelGapSize(e,"x"));var S=et.getSplitterPosition(e),C=t.Agent.isRightToLeft(e.getCtx()),y=gt._getSplitAvailSpace(r,S,n,n&&C),x=gt._getSplitAvailSpace(r,1-S,n,!n||!C);n?(u&&(u.axis.setTranslateX(r.x),s?u.axis.render(u.options,y.w,u.dim.h,y.x,0):u.axis.render(u.options,r.w,u.dim.h)),d&&u&&g&&gt._alignYAxes(e,u,g),g&&(g.axis.setTranslateX(r.x),s?g.axis.render(g.options,x.w,g.dim.h,x.x,0):g.axis.render(g.options,r.w,g.dim.h)),gt._setOverflow(r,u,m)):(u&&(s?u.axis.render(u.options,u.dim.w,y.h,0,y.y):u.axis.render(u.options,u.dim.w,r.h)),d&&u&&g&&gt._alignYAxes(e,u,g),g&&(s?g.axis.render(g.options,g.dim.w,x.h,0,x.y):g.axis.render(g.options,g.dim.w,r.h)),gt._setOverflow(r,m,u,g)),gt._storeAxes(e,m,u,g)},gt._renderPolar=function(t,e,i){var r=gt._createXAxis(t,e,i,i);r.axis.setTranslateX(i.x),r.axis.setTranslateY(i.y),r.axis.render(r.options,i.w,i.h);var a=gt._createYAxis(t,e,i,i);a.axis.setTranslateX(i.x),a.axis.setTranslateY(i.y),a.axis.render(a.options,i.w,i.h),gt._storeAxes(t,r,a)},gt._createXAxis=function(e,i,r,a){var n=e.getOptions(),s=q.getXAxisPosition(e),o=t.JsonUtils.clone(n.xAxis);o.position=s,o.isStandalone=at.isStandaloneXAxis(e),o.groupSeparators=n.styleDefaults.groupSeparators,gt._addCommonAxisAttributes(o,"x",e),o.groups=n.groups,o._groupWidthRatios=q.getGroupWidthRatios(e),o.timeAxisType=q.getTimeAxisType(e),o._environment=n._environment,o._locale=n._locale,o.drilling=n.drilling,o._isGroupAxis=q.hasGroupAxis(e);var l="top"==s||"bottom"==s,h=q.isGridShifted(e);if("tangential"==s&&q.hasGroupAxis(e))h?(o.startGroupOffset=.5,o.endGroupOffset=.5):o.endGroupOffset=1;else{var u=q.getAxisOffset(e);if(o.startGroupOffset=u,o.endGroupOffset=u,at.hasUncenteredSeries(e)&&(o.endGroupOffset+=1),!J.isScrollable(e)&&!at.isOverview(e)){var g=Q.getGroupCount(e);q.isAxisRendered(e,"y")&&q.isTickLabelInside(e,"y")&&(o[(l?"start":"end")+"GroupOffset"]+=.04*g),q.isAxisRendered(e,"y2")&&q.isTickLabelInside(e,"y2")&&(o[(l?"end":"start")+"GroupOffset"]+=.04*g)}}o.leftBuffer=l?r.x-a.x:0,o.rightBuffer=l?a.w+a.x-(r.w+r.x):0,o._renderGridAtLabels=!h||q.hasTimeAxis(e),o.translations=n.translations;var d=new A(e.getCtx(),e.processEvent,e);i.addChild(d);var c=gt._getPreferredSize(e,d,e.xAxis,o,"x",r,a);return o._minOverflowCoord=n._minOverflowCoord-r.x,o._maxOverflowCoord=n._maxOverflowCoord-r.x,{axis:d,options:o,dim:c}},gt._createYAxis=function(e,i,r,a){var n=e.getOptions();if(at.hasY2DataOnly(e))return null;var s=t.JsonUtils.clone(n.yAxis);s.position=q.getYAxisPosition(e),s.isStandalone=at.isStandaloneYAxis(e),gt._addCommonAxisAttributes(s,"y",e),gt._addCommonYAxisAttributes(s,e),s.translations=n.translations;var o=new A(e.getCtx(),e.processEvent,e);i.addChild(o);var l=gt._getPreferredSize(e,o,e.yAxis,s,"y",r,a);return gt._adjustYAxisForLabels(o,s,e,"y"),n.yAxis.min=s.min,n.yAxis.max=s.max,{axis:o,options:s,dim:l}},gt._createY2Axis=function(e,i,r,a){var n=e.getOptions();if(at.hasY2Data(e)){var s=t.JsonUtils.clone(n.y2Axis);s.position=q.getY2AxisPosition(e),s.isStandalone=at.isStandaloneY2Axis(e),gt._addCommonAxisAttributes(s,"y2",e),gt._addCommonYAxisAttributes(s,e),s.translations=n.translations;var o=new A(e.getCtx(),e.processEvent,e);i.addChild(o);var l=gt._getPreferredSize(e,o,e.y2Axis,s,"y2",r,a);return gt._adjustYAxisForLabels(o,s,e,"y2"),n.y2Axis.min=s.min,n.y2Axis.max=s.max,{axis:o,options:s,dim:l}}},gt._addCommonAxisAttributes=function(t,e,i){var r=i.getOptions();if(t.skin=r.skin,t.tickLabel.position=q.isTickLabelInside(i,e)?"inside":"outside",t.baselineScaling=q.getBaselineScaling(i,e),(q.isTickLabelInside(i,e)||"tangential"==t.position)&&(t._skipHighestTick=!0),t.zoomAndScroll=at.isPolar(i)?"off":r.zoomAndScroll,t._isOverview=at.isOverview(i),t._duringZoomAndScroll=r._duringZoomAndScroll,"x"!=e||!q.hasGroupAxis(i)){var a=Q.getMinMaxValue(i,e);t.dataMin=null!=t.dataMin?t.dataMin:a.min,t.dataMax=null!=t.dataMax?t.dataMax:a.max}at.isPolar(i)&&(t.polarGridShape=q.isGridPolygonal(i)?"polygon":"circle",t._radius=i.getRadius()),t.dnd=r.dnd},gt._addCommonYAxisAttributes=function(e,i){if(e.timeAxisType="disabled",J.isLiveScroll(i)&&at.isBLAC(i)&&!at.isPolar(i)&&(e._continuousExtent="on"),e.isStandalone)e.leftBuffer=0,e.rightBuffer=0;else if(at.isSplitDualY(i))e.leftBuffer=1/0,e.rightBuffer=1/0;else{var r=t.Agent.isRightToLeft(i.getCtx());e.leftBuffer=r?0:t.BaseAxisInfo.MINIMUM_AXIS_BUFFER,e.rightBuffer=r?t.BaseAxisInfo.MINIMUM_AXIS_BUFFER:0}},gt._adjustYAxisForLabels=function(e,i,r,a){var n=r.getOptions();if(q.isYAdjustmentNeeded(r)){var s=n.styleDefaults.dataLabelStyle,o=n.styleDefaults.stackLabelStyle,l=e.getInfo(),h=et.isStackLabelRendered(r),u=t.TextUtils.getTextStringHeight(r.getCtx(),h?o:s),g=0;if("log"==i.scale){g=e.getUnboundedValueAt(e.getUnboundedCoordAt(l.getDataMax())-u)-l.getDataMax()}else{var d=1;at.isSplitDualY(r)&&(d="y"==a?et.getSplitterPosition(r):1-et.getSplitterPosition(r));var c=Math.abs(l.getEndCoord()-l.getStartCoord())*d;g=Math.abs(l.getViewportMax()-l.getViewportMin())/c*u}at.isHorizontal(r)?g*=4:g*=2,l.getDataMin()-l.getGlobalMin()<=g&&l.getDataMin()<0&&(i.dataMin-=g),l.getGlobalMax()-l.getDataMax()<=g&&l.getDataMax()>0&&(i.dataMax+=g)}},gt._getPreferredSize=function(e,i,r,a,n,s,o){var l=a.isStandalone,h=a.position,u="top"==h||"bottom"==h,g=q.getTickLabelGapSize(e,n),d=a.maxSize,c=a.size,p=s.w,_=s.h;if("radial"==h||"tangential"==h)p=0,_=0;else if("off"==a.rendered)u?_=0:p=0;else if(l)u?_=s.h-g:p=s.w-g;else if(null!=c)u?(_=et.getSizeInPixels(c,o.h)-g,null!=d&&(_=Math.min(_,et.getSizeInPixels(d,o.h)-g))):(p=et.getSizeInPixels(c,o.w)-g,null!=d&&(p=Math.min(p,et.getSizeInPixels(d,o.w)-g)));else{if(!e.getOptions()._duringZoomAndScroll||!r)return d=null==d?gt._DEFAULT_AXIS_MAX_SIZE:d,u?i.getPreferredSize(a,s.w,et.getSizeInPixels(d,o.h)-g):i.getPreferredSize(a,et.getSizeInPixels(d,o.w)-g,s.h);if(u){var f=t.Agent.isRightToLeft(e.getCtx());a._startOverflow=f?r.getRightOverflow():r.getLeftOverflow(),a._endOverflow=f?r.getLeftOverflow():r.getRightOverflow(),_=r.getHeight()}else p=r.getWidth()}return q.isYAdjustmentNeeded(e)&&i.getPreferredSize(a,p,_),new t.Dimension(p,_)},gt._addAxisGaps=function(t,e){var i=at.isHorizontal(t),r=q.getYAxisPosition(t),a=q.getY2AxisPosition(t),n=q.isAxisRendered(t,"x"),s=q.isAxisRendered(t,"y"),o=q.isAxisRendered(t,"y2"),l=t.getOptions().layout.verticalAxisGap;l*=i?q.getGapScalingFactor(t,"x"):Math.max(q.getGapScalingFactor(t,"y"),q.getGapScalingFactor(t,"y2")),l=Math.ceil(l),(!i||"top"==r&&s||"top"==a&&o)&&i||(e.y+=l,e.h-=l),(!i||"bottom"==r&&s||"bottom"==a&&o)&&(i||n)||(e.h-=l)},gt._positionAxis=function(e,i,r){i&&t.LayoutUtils.position(e,i.options.position,i.axis,i.dim.w,i.dim.h,r)},gt._alignYAxes=function(t,e,i){var r=e.axis.getInfo();if(r){var a=r.getMajorTickCount(),n=r.getMinorTickCount(),s=i.options,o=i.axis.getInfo();o&&q.isLog(t,"y")&&q.isLog(t,"y2")&&a<o.getMajorTickCount()&&(s._logScaleUnit=o.alignLogScaleToTickCount(o.getLogScaleUnit(),a)),s._majorTickCount=a,s._minorTickCount=n}},gt._getSplitAvailSpace=function(t,e,i,r){var a=t.clone();return i?(a.w=t.w*e,a.x=r?t.w*(1-e):0):(a.h=t.h*e,a.y=r?t.h*(1-e):0),a},gt._setOverflow=function(t,e,i,r){if(e){var a=e.axis.getLeftOverflow(),n=e.axis.getRightOverflow();t.x+=a,t.w-=a+n,i&&i.axis.setTranslateX(i.axis.getTranslateX()+("left"==i.options.position?a:-n)),r&&r.axis.setTranslateX(r.axis.getTranslateX()+("left"==r.options.position?a:-n))}},gt._storeAxes=function(t,e,i,r){t.xAxis&&(t.xAxis.destroy(),t.removeChild(t.xAxis)),t.yAxis&&(t.yAxis.destroy(),t.removeChild(t.yAxis)),t.y2Axis&&(t.y2Axis.destroy(),t.removeChild(t.y2Axis)),t.xAxis=e.axis,t.yAxis=i?i.axis:null,t.y2Axis=r?r.axis:null};var dt=new Object;t.Obj.createSubclass(dt,t.Obj),dt._DEFAULT_LINE_WIDTH_WITH_MARKER=2,dt._DEFAULT_MAX_SIZE=.3,dt._PIE_SIZE_RATIO=1.2,dt.render=function(e,i,r){var a=e.getOptions(),n=a.legend.position;if(!("off"==a.legend.rendered||"auto"==a.legend.rendered&&e.getOptionsCache().getFromCache("hasLargeSeriesCount"))){var s=t.JsonUtils.clone(a.legend);delete s.position,s.skin=a.skin,s.hideAndShowBehavior=J.getHideAndShowBehavior(e),s.hoverBehavior=J.getHoverBehavior(e),s.hoverBehaviorDelay=et.getHoverBehaviorDelay(e),s.hiddenCategories=et.getHiddenCategories(e),s.highlightedCategories=et.getHighlightedCategories(e),s.dnd=a.dnd,s._dropColor=a._dropColor,s.translations=a.translations,"auto"==n&&(n=r.w>=r.h?"end":"bottom");var l="top"==n||"bottom"==n;if(s.orientation=l?"horizontal":"vertical","start"==n&&(s.halign="end"),"start"!=n&&"end"!=n||(s.valign="middle"),"top"==n&&(s.valign="bottom"),"top"!=n&&"bottom"!=n||(s.halign="center"),dt._addLegendData(e,s),0!=s.sections.length){var h,u=t.Legend.newInstance(e.getCtx(),e.processEvent,e);if(null!=e.getId()&&u.setId(e.getId()+"legend"),i.addChild(u),null!=s.size)h=l?new t.Dimension(r.w,et.getSizeInPixels(s.size,r.h)):new t.Dimension(et.getSizeInPixels(s.size,r.w),r.h);else{var g=s.maxSize;if(null==g&&(g=dt._DEFAULT_MAX_SIZE,at.isPie(e))){var d=1-dt._PIE_SIZE_RATIO*(l?r.w/r.h:r.h/r.w);g=Math.max(g,d)}var c=l?r.w:et.getSizeInPixels(g,r.w),p=l?et.getSizeInPixels(g,r.h):r.h;h=u.getPreferredSize(s,c,p)}u.render(s,h.w,h.h);var _=l?o.getGapHeight(e,a.layout.legendGapHeight):o.getGapWidth(e,a.layout.legendGapWidth);t.LayoutUtils.position(r,n,u,h.w,h.h,_);var f=Object.keys(s.dnd.drag.series).length>0,v=u.getCache().getFromCache("background");f&&v&&v.setClassName("oj-draggable");var m=u.__getBounds(),S=u.localToStage(new t.Point(m.x,m.y));if(!at.isOverview(e)){var C=t.Agent.isRightToLeft(e.getCtx());"end"==n?C?a._minOverflowCoord=S.x+m.w+_/2:a._maxOverflowCoord=S.x-_/2:"start"==n&&(C?a._maxOverflowCoord=S.x-_/2:a._minOverflowCoord=S.x+m.w+_/2)}e.legend&&(e.legend.destroy(),i.removeChild(e.legend)),e.legend=u}}},dt._addLegendData=function(t,e){var i=dt._getSeriesItems(t,"vertical"==e.orientation);if(i.length>0){var r=e.seriesSection;r.items=i,e.sections.unshift(r),delete e.seriesSection}var a=dt._getRefObjItems(t);if(a.length>0){var n=e.referenceObjectSection;n.items=a,e.sections.push(n),delete e.referenceObjectSection}},dt._getSeriesItems=function(t,e){var i,r,a=[];if("pie"==t.getType()||"pyramid"==t.getType()||"funnel"==t.getType()){var n=st.getRenderedSeriesIndices(t);"pyramid"==t.getType()&&e&&(n=n.reverse());for(var s=0;s<n.length;s++){r=n[s];var o=Q.getValue(t,r,0);o>=0&&null!=o&&(i=dt._createLegendItem(t,r))&&a.push(i)}st.hasOtherSeries(t)&&(i={id:st.OTHER_SLICE_SERIES_ID,text:t.getOptions().translations.labelOther,categoryVisibility:et.getHiddenCategories(t).indexOf(st.OTHER_SLICE_SERIES_ID)>=0?"hidden":"visible",symbolType:"marker",color:t.getOptions().styleDefaults.otherColor,borderColor:t.getOptions().styleDefaults.borderColor},a.push(i))}else{var l={},h={},u=Q.getSeriesCount(t);for(r=0;r<u;r++)if(i=dt._createLegendItem(t,r)){var g=Q.getStackCategory(t,r);Q.isAssignedToY2(t,r)?h[g]?h[g].push(i):h[g]=[i]:l[g]?l[g].push(i):l[g]=[i]}var d=Q.getStackCategories(t,null,!0),c=at.isStacked(t)&&at.isVertical(t)&&e;a=dt._getSeriesItemsForAxis(l,d.y,c,a),a=dt._getSeriesItemsForAxis(h,d.y2,c,a)}return a},dt._getSeriesItemsForAxis=function(t,e,i,r){for(var a,n=0;n<e.length;n++)(a=t[e[n]])&&(r=i?r.concat(a.reverse()):r.concat(a));return r},dt._createLegendItem=function(t,e){var i=Q.getSeriesItem(t,e),r=t.getType(),a=et.getSeriesType(t,e),n=et.getLineType(t,e),s=i.displayInLegend;if(!i||"off"==s)return null;if("on"!=s&&(at.isFunnel(t)||at.isPyramid(t)||at.isStock(t)))return null;if("on"!=s&&!Q.hasSeriesData(t,e))return null;var o=Q.getSeriesLabel(t,e);if("on"!=s&&(null==o||"string"==typeof o&&0===o.trim().length))return null;var l={id:Q.getSeries(t,e),text:o,categories:Q.getCategories(t,e),categoryVisibility:et.isSeriesRendered(t,e)?"visible":"hidden",_dataContext:Q.getDataContext(t,e,-1)};if("line"==a||"lineWithArea"==a||"scatter"==r||"bubble"==r)if(l.lineStyle=et.getLineStyle(t,e),l.lineWidth=et.getLineWidth(t,e),et.isMarkerDisplayed(t,e)){var h=et.getImageSource(t,e,null,null,"source");h?(l.symbolType="image",l.source=h):(l.symbolType="none"==n?"marker":"lineWithMarker","lineWithMarker"==l.symbolType&&(l.lineWidth=Math.min(dt._DEFAULT_LINE_WIDTH_WITH_MARKER,l.lineWidth)),l.markerShape=et.getMarkerShape(t,e),l.markerColor=et.getMarkerColor(t,e))}else l.symbolType="line";else if("boxPlot"==a){var u=et.getBoxPlotStyleOptions(t,e);u.q2Color!=u.q3Color?(l.symbolType=at.isHorizontal(t)?"_horizontalBoxPlot":"_verticalBoxPlot",l._boxPlot=u):l.symbolType="marker"}else l.symbolType="marker","none"==et.getLineType(t,e)&&(l.markerShape=et.getMarkerShape(t,e));return l.color=et.getColor(t,e),l.borderColor=et.getBorderColor(t,e),l.pattern=et.getPattern(t,e),l.svgStyle="area"==a?et.getAreaStyle(t,e):et.getStyle(t,e),l.svgClassName="area"==a?et.getAreaClassName(t,e):et.getClassName(t,e),l.markerSvgStyle=et.getMarkerStyle(t,e),l.markerSvgClassName=et.getMarkerClassName(t,e),l.drilling=J.isSeriesDrillable(t,e)?"on":"off",l.shortDesc=i.shortDesc,l},dt._getRefObjItems=function(t){var e=$.getRefObjs(t);if(e.length<=0)return[];for(var i=[],r=0;r<e.length;r++){var a=e[r];if(a&&"on"==a.displayInLegend&&a.text){var n=$.getType(a);i.push({symbolType:"area"==n?"square":"line",text:a.text,color:$.getColor(a),lineStyle:a.lineStyle,lineWidth:$.getLineWidth(a),categories:$.getRefObjCategories(a),categoryVisibility:$.isObjectRendered(t,a)?"visible":"hidden",shortDesc:a.shortDesc,svgStyle:a.style||a.svgStyle,svgClassName:a.className||a.svgClassName})}}return i};var ct=new Object;t.Obj.createSubclass(ct,t.Obj),ct._MIN_TOUCH_MARKER_SIZE=16,ct._MARKER_DATA_LABEL_GAP=4,ct._MIN_CHARS_DATA_LABEL=3,ct.FILTER_THRESHOLD_SCATTER_BUBBLE=1e4,ct.render=function(t,e,i){"off"==t.getOptions().plotArea.rendered?ct._renderAxisLines(t,e,i):i.w>0&&i.h>0&&(t._currentMarkers=new Array,t._currentAreas=new Array,ct._renderBackgroundObjects(t,e,i),ct._renderTicks(t,e,i),ct._renderForegroundObjects(t,e,i))},ct._renderBackgroundObjects=function(e,i,r){var a=e.getOptions(),n=ct._getBackgroundShape(e,r),s=et.getBackgroundColor(e);if(s?n.setSolidFill(s):n.setInvisibleFill(),i.addChild(n),e.getCache().putToCache("plotAreaBackground",n),J.isPlotAreaDraggable(e)&&n.setClassName("oj-draggable"),a.xAxis.referenceObjects||a.yAxis.referenceObjects||a.y2Axis.referenceObjects){var o=ct.createClippedGroup(e,i,r);ft.renderBackgroundObjects(e,o,r)}if(at.isBLAC(e)){var l=new t.Container(e.getCtx());i.addChild(l),e.__setAreaContainer(l),at.hasAreaSeries(e)&&ct._renderAreas(e,l,r,!1)}},ct._getBackgroundShape=function(e,i){var r,a=e.getCtx();if(at.isPolar(e)){var n=i.x+i.w/2,s=i.y+i.h/2;if(q.isGridPolygonal(e)){var o=t.PolygonUtils.getRegularPolygonPoints(n,s,Q.getGroupCount(e),e.getRadius(),0);r=new t.Polygon(a,o)}else r=new t.Circle(a,n,s,e.getRadius())}else r=new t.Rect(a,i.x,i.y,i.w,i.h);return r},ct._renderTicks=function(t,e,i){t.xAxis&&q.isMinorTickRendered(t,"x")&&ct._renderMinorTicks(t,e,t.xAxis,i),t.yAxis&&q.isMinorTickRendered(t,"y")&&ct._renderMinorTicks(t,e,t.yAxis,i),t.y2Axis&&q.isMinorTickRendered(t,"y2")&&ct._renderMinorTicks(t,e,t.y2Axis,i),t.xAxis&&q.isMajorTickRendered(t,"x")&&ct._renderMajorTicks(t,e,t.xAxis,i),t.yAxis&&q.isMajorTickRendered(t,"y")&&ct._renderMajorTicks(t,e,t.yAxis,i),t.y2Axis&&q.isMajorTickRendered(t,"y2")&&ct._renderMajorTicks(t,e,t.y2Axis,i)},ct._renderAxisLines=function(t,e,i){t.xAxis&&t.yAxis&&q.isAxisLineRendered(t,"x")&&ct._renderAxisLine(t,e,t.xAxis,t.yAxis,i),t.xAxis&&t.y2Axis&&q.isAxisLineRendered(t,"x")&&(t.yAxis&&!at.isSplitDualY(t)||ct._renderAxisLine(t,e,t.xAxis,t.y2Axis,i)),t.yAxis&&t.xAxis&&q.isAxisLineRendered(t,"y")&&ct._renderAxisLine(t,e,t.yAxis,t.xAxis,i),t.y2Axis&&t.xAxis&&q.isAxisLineRendered(t,"y2")&&ct._renderAxisLine(t,e,t.y2Axis,t.xAxis,i)},ct._renderMajorTicks=function(t,e,i,r){ct._renderGridlines(t,e,i.getOptions().majorTick,i.getPosition(),i.getMajorTickCoords(),i.getBaselineCoord(),r)},ct._renderMinorTicks=function(t,e,i,r){ct._renderGridlines(t,e,i.getOptions().minorTick,i.getPosition(),i.getMinorTickCoords(),null,r)},ct._renderAxisLine=function(t,e,i,r,a){var n=i.getOptions(),s=n.position,o="bottom"==s||"right"==s||"tangential"==s?r.getMaxCoord():r.getMinCoord();ct._renderGridlines(t,e,n.axisLine,r.getPosition(),[o],null,a)},ct._renderGridlines=function(e,i,r,a,n,s,o){var l=r.lineColor,h=r.lineStyle,u=new t.Stroke(l,1,r.lineWidth,!1,t.Stroke.getDefaultDashProps(h,r.lineWidth)),g=u.getColor();"inherit"!=r.baselineColor&&(g="auto"==r.baselineColor?t.ColorUtils.getDarker(l,.6):r.baselineColor);for(var d=null!=r.baselineWidth?r.baselineWidth:r.lineWidth,c=r.baselineStyle?r.baselineStyle:r.lineStyle,p=new t.Stroke(g,1,d,!1,t.Stroke.getDefaultDashProps(c,d)),_="",f=0;f<n.length;f++){var v=null!=s&&n[f]==s;"radial"==a||"tangential"==a||v?ct._renderGridline(e,i,a,n[f],v?p:u,o):_+="top"==a||"bottom"==a?t.PathUtils.moveTo(n[f],o.y)+t.PathUtils.verticalLineTo(o.y+o.h):t.PathUtils.moveTo(o.x,n[f])+t.PathUtils.horizontalLineTo(o.x+o.w)}if(""!=_){var m=new t.Path(e.getCtx(),_);(!t.Agent.isTouchDevice()||t.Agent.getDevicePixelRatio()>1)&&m.setPixelHinting(!0),m.setStroke(u),m.setMouseEnabled(!1),i.addChild(m)}},ct._renderGridline=function(e,i,r,a,n,s){var o,l=i.getCtx(),h=!t.Agent.isTouchDevice()||t.Agent.getDevicePixelRatio()>1;if("radial"==r){if(q.isGridPolygonal(e)){var u=t.PolygonUtils.getRegularPolygonPoints(0,0,Q.getGroupCount(e),a,0);o=new t.Polygon(l,u)}else o=new t.Circle(l,0,0,a);o.setInvisibleFill(),o.setTranslate(s.x+s.w/2,s.y+s.h/2)}else if("tangential"==r){o=new t.Line(l,0,0,e.getRadius()*Math.sin(a),-e.getRadius()*Math.cos(a));var g=a%(Math.PI/2);(g<.001||g>Math.PI/2-.001)&&h&&o.setPixelHinting(!0),o.setTranslate(s.x+s.w/2,s.y+s.h/2)}else o="top"==r||"bottom"==r?new t.Line(l,a,s.y,a,s.y+s.h):new t.Line(l,s.x,a,s.x+s.w,a),h&&o.setPixelHinting(!0);o.setStroke(n),o.setMouseEnabled(!1),i.addChild(o)},ct._renderForegroundObjects=function(t,e,i){var r=t.getOptions(),a=ct.createClippedGroup(t,e,i);ct._renderAxisLines(t,e,i);var n=r.plotArea.borderColor,s=r.plotArea.borderWidth;if(n&&0!=s){var o=ct._getBackgroundShape(t,i);o.setInvisibleFill(),o.setSolidStroke(n,null,s),o.setMouseEnabled(!1),e.addChild(o)}at.isBLAC(t)?(at.hasLineWithAreaSeries(t)&&ct._renderAreas(t,e,i,!0),at.hasBarSeries(t)&&ct._renderBars(t,a,i),at.hasCandlestickSeries(t)&&ct._renderStock(t,a,i),at.hasBoxPlotSeries(t)&&ct._renderBoxPlot(t,a,i),at.hasLineSeries(t)&&ct._renderLines(t,e,a,i)):at.isScatterBubble(t)&&ct._renderScatterBubble(t,e,a,!0,i),(r.xAxis.referenceObjects||r.yAxis.referenceObjects||r.y2Axis.referenceObjects)&&(a=ct.createClippedGroup(t,e,i),ft.renderForegroundObjects(t,a,i));var l=Q.getInitialSelection(t);J.setInitialSelection(t,l),t.highlight(et.getHighlightedCategories(t))},ct._renderDataLabel=function(e,i,r,a,n,s,o,l,h,u){if(!at.isOverview(e)){var g="bar"==et.getSeriesType(e,a),d=at.isHorizontal(e),c={width:d?r.w:u,height:d?u:r.h};g&&e.getOptionsCache().putToCachedMap2D("barDims",a,n,c);var p=Q.getDataLabel(e,a,n,s,l,h);if(null!=p){var _=et.getDataLabelPosition(e,a,n,s,l,h);if("none"!=_){var f=new t.OutputText(e.getCtx(),p,0,0);f.setMouseEnabled(!1);var v=h?e.getOptions().styleDefaults.stackLabelStyle:et.getDataLabelStyle(e,a,n,s,o,_,l);f.setCSSStyle(v),f.setY(r.y+r.h/2),f.setX(r.x+r.w/2),f.alignCenter(),f.alignMiddle();var m=f.getDimensions();if("left"==_)f.setX(r.x-m.w/2-ct._MARKER_DATA_LABEL_GAP);else if("right"==_)f.setX(r.x+r.w+m.w/2+ct._MARKER_DATA_LABEL_GAP);else if("top"==_)f.setY(r.y-m.h/2);else if("bottom"==_)f.setY(r.y+r.h+m.h/2+ct._MARKER_DATA_LABEL_GAP/2);else{if(g){if(m.w>c.width||m.h>c.height)return;"inLeft"==_?f.setX(r.x+m.w/2+ct._MARKER_DATA_LABEL_GAP):"inRight"==_?f.setX(r.x+r.w-m.w/2-ct._MARKER_DATA_LABEL_GAP):"inTop"==_?f.setY(r.y+m.h/2+ct._MARKER_DATA_LABEL_GAP):"inBottom"==_&&f.setY(r.y+r.h-m.h/2-ct._MARKER_DATA_LABEL_GAP/2)}else if(at.isBubble(e)){r.x+=ct._MARKER_DATA_LABEL_GAP,r.y+=ct._MARKER_DATA_LABEL_GAP,r.h-=2*ct._MARKER_DATA_LABEL_GAP,r.w-=2*ct._MARKER_DATA_LABEL_GAP;var S=t.TextUtils.getOptimalFontSize(f.getCtx(),f.getTextString(),f.getCSSStyle(),r);if(f.setFontSize(S),!t.TextUtils.fitText(f,r.w,r.h,i,ct._MIN_CHARS_DATA_LABEL))return}if(null!=et.getPattern(e,a,n)){var C=.15*(m=f.getDimensions()).h,y=t.PathUtils.roundedRectangle(m.x-C,m.y,m.w+2*C,m.h,2,2,2,2),x=new t.Path(e.getCtx(),y);x.setSolidFill("#FFFFFF",.9),i.addChild(x)}}if(at.isBar(e)){var A=e.getCache().getFromCache("plotAreaDims");A||(A=e.getPlotArea().getDimensions(),e.getCache().putToCache("plotAreaDims",A));var b,M=f.getDimensions(),T=!1;if("left"==_&&M.x<0)T=!0,b=r.x-ct._MARKER_DATA_LABEL_GAP;else if("right"==_&&M.x+M.w>A.w+ct._MARKER_DATA_LABEL_GAP)T=!0,b=A.w-r.w-ct._MARKER_DATA_LABEL_GAP;else{if("top"==_&&M.y<0)return;if("bottom"==_&&M.y+M.h>A.y+A.h+ct._MARKER_DATA_LABEL_GAP)return}if(T){if(!isNaN(p))return;if(!t.TextUtils.fitText(f,b,r.h,i,1))return;m=f.getDimensions(),"left"==_?f.setX(r.x-m.w/2-ct._MARKER_DATA_LABEL_GAP):"right"==_&&f.setX(r.x+r.w+m.w/2+ct._MARKER_DATA_LABEL_GAP)}}et.optimizeMarkerStroke(e)&&f.setSolidStroke("none"),i.addChild(f),e.addDataLabel(f)}}}},ct._renderDataLabelForMarker=function(e,i,r){var a=e.getEventManager().getLogicalObject(r);if(a){var n=a.getSeriesIndex(),s=a.getGroupIndex(),o=a.getNestedDataItemIndex();if(r instanceof t.SimpleMarker){var l=new t.Rectangle(r.getCx()-r.getWidth()/2,r.getCy()-r.getHeight()/2,r.getWidth(),r.getHeight());ct._renderDataLabel(e,i,l,n,s,o,r.getDataColor())}else r instanceof L&&(ct._renderDataLabel(e,i,r.getBoundingBox1(),n,s,o,r.getDataColor(),"low"),ct._renderDataLabel(e,i,r.getBoundingBox2(),n,s,o,r.getDataColor(),"high"))}},ct._renderScatterBubble=function(e,i,r,a,n){var s,o=ct._filterScatterBubble(e,a,n),l=Q.getSeriesCount(e);for(s=0;s<l;s++)"none"!=et.getLineType(e,s)&&ct._renderLinesForSeries(e,r,s,n);var h=et.getMarkerBorderColor(e),u=et.getBorderWidth(e),g=new t.Stroke(h,1,u),d=[];if(o)for(var c=et.optimizeMarkerStroke(e),p=c?g.getColor():null,_=c?g.getWidth():null,f=0;f<o.length;f++){var v=o[f],m=ct._createMarker(e,v,p,_);d.push(m)}else{for(s=0;s<l;s++){var S=ct._getMarkersForSeries(e,s,n,g);d=d.concat(S)}a&&nt.sortMarkers(d)}at.isBubble(e)?ct._addMarkersToContainer(e,r,d,g):ct._addMarkersToContainer(e,i,d,g)},ct._renderMarkersForSeries=function(e,i,r,a){var n,s=et.getMarkerBorderColor(e,r),o=et.getBorderWidth(e,r),l=new t.Stroke(s,1,o);n=et.isRangeSeries(e,r)?ct._getRangeMarkersForSeries(e,r,a):ct._getMarkersForSeries(e,r,a,l),ct._addMarkersToContainer(e,i,n,l)},ct._addMarkersToContainer=function(e,i,r,a){var n=i,s=et.optimizeMarkerStroke(e),o=et.optimizeMarkerFill(e);(s||o)&&(n=new t.Container(e.getCtx()),s?n.setStroke(a):n.setInvisibleFill(),i.addChild(n));for(var l=0;l<r.length;l++)n.addChild(r[l]),ct._renderDataLabelForMarker(e,n,r[l]);e._currentMarkers.push(r)},ct._getMarkerInfo=function(e,i,r,a,n){var s=e.getOptions(),o=Q.getValue(e,i,r,a);if(null==o||isNaN(o))return null;if(Q.isDataItemFiltered(e,i,r))return null;var l=Q.getGroupCount(e),h=et.isMarkerDisplayed(e,i,r,a);if(!h&&(null==a||a<0))if("jet"!=s._environment&&q.isMixedFrequency(e))l<2&&(h=!0);else{var u=l-1,g=at.isPolar(e),d=g&&u>0&&0==r?u:r-1,c=g&&u>0&&r==u?0:r+1,p=Q.getValue(e,i,d),_=Q.getValue(e,i,c);null!=p&&!isNaN(p)||null!=_&&!isNaN(_)||(h=!0)}if(!h){if(at.isSpark(e))return null;if((s._duringZoomAndScroll||at.isOverview(e))&&!Q.isDataSelected(e,i,r,a))return null}if(!et.isDataItemRendered(e,i,r,a))return!1;var f=!0,v=Q.getMarkerPosition(e,i,r,a,n),m=et.getMarkerSize(e,i,r,a);return n&&v&&m&&(f=n.intersects(new t.Rectangle(v.x-m/2,v.y-m/2,m,m))),v&&f?{seriesIndex:i,groupIndex:r,itemIndex:a,x:v.x,y:v.y,size:m,markerDisplayed:h}:null},ct._getScatterBubbleMarkerInfo=function(t,e,i,r){if(!et.isDataItemRendered(t,e,i))return!1;var a=Q.getScatterBubbleMarkerPosition(t,e,i);if(!a)return null;var n=et.getMarkerSize(t,e,i);return n?{seriesIndex:e,groupIndex:i,x:a.x,y:a.y,size:n}:null},ct._getMarkersForSeries=function(t,e,i,r){if(!et.isSeriesRendered(t,e))return[];for(var a=et.optimizeMarkerStroke(t),n=a?r.getColor():null,s=a?r.getWidth():null,o=[],l=Q.getGroupCount(t),h=0;h<l;h++){var u=ct._getMarkerInfo(t,e,h,null,i);if(u){var g=ct._createMarker(t,u,n,s);null!=g&&o.push(g)}}return o},ct._createMarker=function(e,i,r,n){var s,o=t.Agent.isTouchDevice(),l=e.getCtx(),h=et.optimizeMarkerStroke(e),u=et.optimizeMarkerFill(e),g=i.seriesIndex,d=i.groupIndex,c=i.itemIndex,p=et.getMarkerColor(e,g,d,c),_=et.getMarkerShape(e,g,d,c),f=i.markerDisplayed;if(null==f&&(f=et.isMarkerDisplayed(e,g,d,c)),f){var v=et.getImageSource(e,g,d,c,"source");if(v){var m=et.getImageSource(e,g,d,c,"sourceSelected"),S=et.getImageSource(e,g,d,c,"sourceHover"),C=et.getImageSource(e,g,d,c,"sourceHoverSelected");s=new t.ImageMarker(l,i.x,i.y,i.size,i.size,null,v,m,S,C)}else{(s=new t.SimpleMarker(l,_,i.x,i.y,i.size,i.size,null,null,!0)).setFill(tt.getMarkerFill(e,g,d,c));var y=et.getMarkerBorderColor(e,g,d,c),x=et.getBorderWidth(e,g,d,c);y==r&&x==n||s.setSolidStroke(y,null,x),s.setDataColor(p,!0);var A=t.SelectionEffectUtils.getHoverBorderColor(p),b=et.getSelectedInnerColor(e),M=et.getSelectedOuterColor(e);s.setHoverStroke(new t.Stroke(b,1,1),new t.Stroke(A,1,3.5)),s.setSelectedStroke(new t.Stroke(b,1,1.5),new t.Stroke(M,1,4.5)),s.setSelectedHoverStroke(new t.Stroke(b,1,1.5),new t.Stroke(A,1,4.5)),s.setClassName(et.getMarkerClassName(e,g,d,c)),s.setStyle(et.getMarkerStyle(e,g,d,c))}et.isSelectable(e,g,d)&&s.setCursor(t.SelectionEffectUtils.getSelectingCursor()),o&&i.size<ct._MIN_TOUCH_MARKER_SIZE&&ct._addMarkerHitArea(s,i.x,i.y,h)}else et.isSelectable(e,g,d)?((s=new D(l,_,i.x,i.y,i.size,h)).setCursor(t.SelectionEffectUtils.getSelectingCursor()),o&&ct._addMarkerHitArea(s,i.x,i.y,h)):(o&&(i.size=ct._MIN_TOUCH_MARKER_SIZE),s=new D(l,t.SimpleMarker.SQUARE,i.x,i.y,i.size,h)),null!=s&&(u||s.setInvisibleFill(),s.setDataColor(p));return null!=s&&a.associate(s,e,g,d,c,i),s},ct._addMarkerHitArea=function(e,i,r,a){var n=new t.Rect(e.getCtx(),i-ct._MIN_TOUCH_MARKER_SIZE/2,r-ct._MIN_TOUCH_MARKER_SIZE/2,ct._MIN_TOUCH_MARKER_SIZE,ct._MIN_TOUCH_MARKER_SIZE);a&&n.setSolidStroke("none"),n.setInvisibleFill(),e.addChild(n)},ct._getRangeMarkersForSeries=function(e,i,r){if(!et.isSeriesRendered(e,i))return[];for(var n=t.Agent.isTouchDevice(),s=e.getCtx(),o=e.xAxis,l=Q.isAssignedToY2(e,i)?e.y2Axis:e.yAxis,h=e.getOptions(),u=Q.getGroupCount(e),g=[],d=0;d<u;d++)if(!Q.isDataItemFiltered(e,i,d)&&et.isDataItemRendered(e,i,d)){var c=o.getCoordAt(Q.getXValue(e,i,d)),p=l.getUnboundedCoordAt(Q.getLowValue(e,i,d)),_=l.getUnboundedCoordAt(Q.getHighValue(e,i,d));if(null!=c&&null!=p&&null!=_){var f=et.isMarkerDisplayed(e,i,d);if(!f){var v=u-1,m=at.isPolar(e),S=m&&v>0&&0==d?v:d-1,C=m&&v>0&&d==v?0:d+1,y=Q.getLowValue(e,i,S),x=Q.getHighValue(e,i,S),A=Q.getLowValue(e,i,C),b=Q.getHighValue(e,i,S);null==y&&null==x&&null==A&&null==b&&(f=!0)}if(!(h._duringZoomAndScroll||at.isOverview(e)||at.isSpark(e))||f||Q.isDataSelected(e,i,d)){var M=ct.convertAxisCoord(e,new t.Point(c,p),r),T=ct.convertAxisCoord(e,new t.Point(c,_),r),I=new t.Point((M.x+T.x)/2,(M.y+T.y)/2),O=et.getMarkerSize(e,i,d),D=new L(s,M.x,M.y,T.x,T.y,O,!f),E=tt.getMarkerFill(e,i,d),P=et.getMarkerBorderColor(e,i,d),w=et.getBorderWidth(e,i,d),R=new t.Stroke(P,1,w),B=et.getMarkerColor(e,i,d),k=et.getSelectedInnerColor(e),F=et.getSelectedOuterColor(e);D.setStyleProperties(E,R,B,k,F),et.isSelectable(e,i,d)&&D.setCursor(t.SelectionEffectUtils.getSelectingCursor());var N=new t.Line(s,M.x,M.y,T.x,T.y);N.setSolidStroke("rgba(0,0,0,0)",null,n?Math.max(O,ct._MIN_TOUCH_MARKER_SIZE):O),D.addChild(N),g.push(D),a.associate(D,e,i,d,null,I)}}}return g},ct._renderBars=function(e,i,r){for(var n=at.isHorizontal(e),s=at.isPolar(e),o=at.isStock(e),l="pixel"==et.getBarSpacing(e),h=t.Agent.isRightToLeft(e.getCtx()),u=et.isStackLabelRendered(e),g=at.isStacked(e),d=et.getSelectedInnerColor(e),c=et.getSelectedOuterColor(e),p=e.getOptions()._duringZoomAndScroll,_=et.getGroupWidth(e),f={},v=0;v<Q.getSeriesCount(e);v++)if("bar"==et.getSeriesType(e,v)){ct._filterPointsForSeries(e,v);for(var m="",S=e.getOptionsCache().getFromCachedMap("itemStyleSet",v),C=Q.getStackCategory(e,v)||"",y=Q.isAssignedToY2(e,v),x=Q.getViewportMinMaxGroupIndex(e,v),A=x.min-1;A<=x.max+1;A++)if(!Q.isDataItemFiltered(e,v,A)&&et.isDataItemRendered(e,v,A)&&0!=Q.getZValue(e,v,A)){var M=Q.getBarInfo(e,v,A,r);if(null!=M){var T=M.yCoord,I=M.baseCoord,O=M.axisCoord,D=M.x1,E=M.x2,L=M.barWidth;if(g){var w=""+A+C+y+(Q.getValue(e,v,A)<0);if(Math.abs(I-T)<.5&&Math.abs(T-f[w])<.5&&!Q.isOutermostBar(e,v,A))continue;f[w]&&(I=f[w]),f[w]=T}var R,B=!1;if(Math.abs(T-I)<1&&(et.isRangeSeries(e,v)?T--:g&&!Q.isOutermostBar(e,v,A)||(B=!0,T=T>I||n&&!h&&T==I?I+3:I-3)),s)R=new P(e,O,I,T,D,E,r);else{var k=p&&_<5&&!S;if(R=new b(e,O,I,T,D,E,k),k){var F=R.getBoundingBox();m+=t.PathUtils.moveTo(F.x,F.y)+t.PathUtils.horizontalLineTo(F.x+F.w)+t.PathUtils.verticalLineTo(F.y+F.h)+t.PathUtils.horizontalLineTo(F.x)+t.PathUtils.closePath();continue}}i.addChild(R),et.isSelectable(e,v,A)&&R.setCursor(t.SelectionEffectUtils.getSelectingCursor());var N,H=null;if(B)N=t.SolidFill.invisibleFill();else{N=tt.getBarFill(e,v,A,L);var G=et.getBorderColor(e,v,A),U=et.getBorderWidth(e,v,A);G&&(H=new t.Stroke(G,1,U))}var V=et.getColor(e,v,A),j=et.getClassName(e,v,A),Y=et.getStyle(e,v,A);R.setStyleProperties(N,H,V,d,c,j,Y),l&&R.setPixelHinting(!0),a.associate(R,e,v,A,null,M.dataPos),et.isRangeSeries(e,v)?(ct._renderDataLabel(e,i,R.getBoundingBox(),v,A,null,V,"low",!1,R.getOriginalBarSize()),ct._renderDataLabel(e,i,R.getBoundingBox(),v,A,null,V,"high",!1,R.getOriginalBarSize())):ct._renderDataLabel(e,i,R.getBoundingBox(),v,A,null,V,null,!1,R.getOriginalBarSize());var W=new Array;W.push(R),o&&0!=v||e._currentMarkers.push(W),u&&Q.isOutermostBar(e,v,A)&&ct._renderDataLabel(e,i,R.getBoundingBox(),v,A,null,null,null,!0,R.getOriginalBarSize())}}if(m){var z=new t.Path(e.getCtx(),m),X=et.getColor(e,v);z.setSolidFill(X);var Z=et.getBorderColor(e,v);if(Z){var K=et.getBorderWidth(e,v);z.setSolidStroke(Z,null,K)}var q=et.getClassName(e,v),J=et.getStyle(e,v);z.setClassName(q).setStyle(J),l&&z.setPixelHinting(!0),i.addChild(z)}}},ct._renderStock=function(e,i,r){var n=e.getOptions(),s=e.xAxis,o=e.yAxis;if("candlestick"==et.getSeriesType(e,0))for(var l=Q.getViewportMinMaxGroupIndex(e,0),h=l.min-1;h<=l.max+1;h++)if(et.isDataItemRendered(e,0,h)){var u=Q.getDataItem(e,0,h);if(u){var g=u.open,d=u.close,c=u.low,p=u.high,_=null!=c&&null!=p;if(null!=g&&null!=d){var f,v=Q.getXValue(e,0,h),m=s.getUnboundedCoordAt(v),S=et.getBarWidth(e,0,h),C=o.getBoundedCoordAt(g),y=o.getBoundedCoordAt(d),x=null;_&&(f=o.getBoundedCoordAt(c),x=o.getBoundedCoordAt(p));var A=new T(e.getCtx(),m,S,C,y,f,x);i.addChild(A),et.isSelectable(e,0,h)&&A.setCursor(t.SelectionEffectUtils.getSelectingCursor());var b=tt.getBarFill(e,0,h,S),M=null,I=et.getBorderColor(e,0,h),O=et.getBorderWidth(e,0,h);I?M=new t.Stroke(I,1,O):b instanceof t.PatternFill&&(M=new t.Stroke(b.getColor(),1,O));var D=et.getColor(e,0,h),E=et.getSelectedInnerColor(e),P=et.getSelectedOuterColor(e),L=n.styleDefaults.stockRangeColor;A.setChangeStyle(b,M,D,E,P),A.setRangeStyle(new t.SolidFill(L),M,L,P);var w=new t.Point(m,(C+y)/2);a.associate(A,e,0,h,null,w);var R=new Array;R.push(A._changeShape),e._currentMarkers.push(R)}}}},ct._renderBoxPlot=function(e,i,r){for(var n=e.xAxis,s=0;s<Q.getSeriesCount(e);s++)for(var o=Q.getViewportMinMaxGroupIndex(e,s),l=o.min-1;l<=o.max+1;l++)if(et.isDataItemRendered(e,s,l)&&"boxPlot"==et.getSeriesType(e,s)){var h=Q.getDataItem(e,s,l);if(h){var u=h.low,g=h.q1,d=h.q2,c=h.q3,p=h.high;if(null!=u&&null!=g&&null!=d&&null!=c&&null!=p){var _=et.getBarWidth(e,s,l),f=et.getBarCategoryOffsetMap(e,l),v=Q.isAssignedToY2(e,s),m=Q.getStackCategory(e,s),S=f[v?"y2":"y"][m]+_/2;t.Agent.isRightToLeft(e.getCtx())&&at.isVertical(e)&&(S*=-1);var C=Q.getXValue(e,s,l),y=n.getUnboundedCoordAt(C)+S,x=v?e.y2Axis:e.yAxis,A=x.getBoundedCoordAt(u),b=x.getBoundedCoordAt(g),T=x.getBoundedCoordAt(d),I=x.getBoundedCoordAt(c),O=x.getBoundedCoordAt(p),D=et.getBoxPlotStyleOptions(e,s,l),E=new M(e,y,_,A,b,T,I,O,D);i.addChild(E),et.isSelectable(e,s,l)&&E.setCursor(t.SelectionEffectUtils.getSelectingCursor());var P=ct.convertAxisCoord(e,new t.Point(y,T),r);a.associate(E,e,s,l,null,P),ct._renderBoxPlotMarkers(e,i,s,l,r,y),e._currentMarkers.push([E._medianLine])}}}},ct._renderBoxPlotMarkers=function(e,i,r,a,n,s){for(var o=et.getMarkerBorderColor(e,r,a),l=et.getBorderWidth(e,r,a),h=new t.Stroke(o,1,l),u=[],g=Q.getNestedDataItemCount(e,r,a),d=0;d<g;d++){var c=ct._getMarkerInfo(e,r,a,d,n);if(c){at.isHorizontal(e)?c.y=s:c.x=s;var p=ct._createMarker(e,c,o,l);null!=p&&u.push(p)}}ct._addMarkersToContainer(e,i,u,h)},ct._renderLines=function(t,e,i,r){var a,n=[],s=Q.getSeriesCount(t);for(a=0;a<s;a++)et.isSeriesRendered(t,a)&&"line"==et.getSeriesType(t,a)&&n.push(a);for(var o=0;o<n.length;o++)a=n[o],"none"!=et.getLineType(t,a)&&(ct._filterPointsForSeries(t,a),ct._renderLinesForSeries(t,i,a,r));for(o=0;o<n.length;o++)ct._renderMarkersForSeries(t,e,n[o],r)},ct._renderAreas=function(t,e,i,r){for(var a=Q.getSeriesCount(t),n=r?"lineWithArea":"area",s=[],o=[],l=0;l<a;l++)et.isSeriesRendered(t,l)&&et.getSeriesType(t,l)==n&&(Q.isAssignedToY2(t,l)?o.push(l):s.push(l));s.length>0&&ct._renderAreasForAxis(t,e,s,t.yAxis.getBaselineCoord(),i,r),o.length>0&&ct._renderAreasForAxis(t,e,o,t.y2Axis.getBaselineCoord(),i,r)},ct._renderAreasForAxis=function(e,i,r,n,s,o){for(var l=at.isStacked(e),h=ct.createClippedGroup(e,i,s),u={},g={},d={},c={},p=[],_=Q.getGroupCount(e),f=0;f<_;f++)p.push(new I(null,n,n,f,Q.getGroup(e,f),!0));for(var v=0;v<r.length;v++){var m=r[v],S=Q.getStackCategory(e,m),C=Q.isSeriesNegative(e,m),y=u[S],x=g[S],A=d[S],b=c[S];if("none"!=et.getLineType(e,m)){var M,T,D,E=tt.getAreaFill(e,m),P=et.getBorderColor(e,m),L=et.getBorderWidth(e,m),w=et.getAreaClassName(e,m),R=et.getAreaStyle(e,m),B=P?new t.Stroke(P,1,L):null,k=et.getLineType(e,m);ct._filterPointsForSeries(e,m),et.isRangeSeries(e,m)?(M=ct._getCoordsForSeries(e,m,s,"high"),T=ct._getCoordsForSeries(e,m,s,"low"),D=k):C?(M=ct._getAreaCoordsForSeries(e,m,s,A||p),T=A||[],D=b):(M=ct._getAreaCoordsForSeries(e,m,s,y||p),T=y||[],D=x);var F=new O(e,!0,s,n,R,w,E,B,k,M,D,T);h.addChild(F),e._currentAreas.push(F),a.associate(F,e,m),C?(d[S]=M,c[S]=k):(u[S]=M,g[S]=k),l||((o||et.getDataItemGaps(e)>0&&!P)&&ct._renderLinesForSeries(e,h,m,s,!o),o||ct._renderMarkersForSeries(e,i,m,s),v+1<r.length&&(h=ct.createClippedGroup(e,i,s)))}else ct._renderMarkersForSeries(e,i,m,s)}for(v=0;v<r.length;v++)if(m=r[v],"none"!=et.getLineType(e,m)){var N=et.getBorderColor(e,m)||et.getBorderColor(e,m+1);l&&(o||et.getDataItemGaps(e)>0&&!N)&&ct._renderLinesForSeries(e,h,m,s,!o),(l||o)&&ct._renderMarkersForSeries(e,i,m,s)}},ct._getAreaCoordsForSeries=function(t,e,i,r){for(var a=ct._getCoordsForSeries(t,e,i),n=[],s=0;s<r.length;s++)n.push(r[s].clone());var o=a.length-1,l=at.isPolar(t);for(s=0;s<a.length;s++)if(null!=a[s].x){var h=n[a[s].groupIndex],u=l&&0==s?o:s-1,g=l&&s==o?0:s+1;u>=0&&null!=a[u].x&&(h.y1=a[s].y1),g<=o&&null!=a[g].x&&(h.y2=a[s].y2),h.x=a[s].x,h.filtered=h.y1==h.y2&&a[s].filtered}return n},ct._renderLinesForSeries=function(e,i,r,n,s){var o;if(s){var l=2.5*et.getDataItemGaps(e);o=new t.Stroke(et.getBackgroundColor(e,!0),1,l)}else{var h=et.getColor(e,r),u=et.getLineWidth(e,r),g=et.getLineStyle(e,r);o=new t.Stroke(h,1,u,!1,t.Stroke.getDefaultDashProps(g,u))}var d=Q.isAssignedToY2(e,r)?e.y2Axis.getBaselineCoord():e.yAxis.getBaselineCoord(),c=et.getLineType(e,r),p=et.getClassName(e,r),_=et.getStyle(e,r),f=function(t){var s=ct._getCoordsForSeries(e,r,n,t),l=new O(e,!1,n,d,_,p,null,o,c,s);i.addChild(l),a.associate(l,e,r)};et.isRangeSeries(e,r)?(f("high"),f("low")):f("value")},ct._filterScatterBubble=function(e,i,r){var a,n=Q.getSeriesCount(e),s=Q.getGroupCount(e);if(n*s<ct.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;for(var o=[],l=0;l<n;l++)if(et.isSeriesRendered(e,l))for(var h=0;h<s;h++)null!=(a=ct._getScatterBubbleMarkerInfo(e,l,h,r))&&o.push(a);if(o.length<ct.FILTER_THRESHOLD_SCATTER_BUBBLE)return null;i&&nt.sortMarkerInfos(o);for(var u=new t.PixelMap(25,new t.PixelMap(5,new t.PixelMap)),g=[],d=o.length-1;d>=0;d--){if(a=o[d],!nt.checkPixelMap(u,a.x,a.y,a.size)){var c=et.getColor(e,a.seriesIndex,a.groupIndex),p=et.isMarkerDisplayed(e,l,h)?t.ColorUtils.getAlpha(c):0;p>0&&(nt.updatePixelMap(u,a.x,a.y,a.size,p),g.push(a))}}return e.getCache().putToCache("dataFiltered",!0),g.reverse(),g},ct._filterPointsForSeries=function(t,e){if(!at.isPolar(t)&&!et.isRangeSeries(t,e)){var i=t.__getPlotAreaSpace().w,r=Q.getSeriesItem(t,e).items,a="bar"==et.getSeriesType(t,e),n=t.xAxis.getInfo(),s=(n.getDataMax()-n.getDataMin())/(n.getViewportMax()-n.getViewportMin()),o=a?.5:2,l=s?Math.round(o*(r.length/s)/i):1;if(l<(a?2:3))for(var h=0;h<r.length;h++)(p=r[h])&&(p._filtered=!1);else{var u,g,d,c,p,_,f=!1;for(h=0;h<r.length;h+=l){u=-1,g=-1/0,d=-1,c=1/0;for(var v=h;v<Math.min(h+l,r.length);v++)_=Q.getCumulativeValue(t,e,v),p=r[v],null!=_&&null!=p&&((!a||_>0)&&_>g&&(u=v,g=_),(!a||_<0)&&_<c&&(d=v,c=_),p._filtered=!0,f=!0);for(v=h;v<Math.min(h+l,r.length);v++)null!=(p=r[v])&&(v!=u&&v!=d||(p._filtered=!1))}t.getCache().putToCache("dataFiltered",f)}}},ct._getCoordsForSeries=function(t,e,i,r){var a=t.xAxis,n=t.yAxis;Q.isAssignedToY2(t,e)&&(n=t.y2Axis);for(var s=[],o=Q.getViewportMinMaxGroupIndex(t,e),l=o.min-1;l<=o.max+1;l++){var h=Q.getGroup(t,l);if(null!=h){var u=Q.getXValue(t,e,l),g=null;if("low"==r?g=Q.getLowValue(t,e,l):"high"==r?g=Q.getHighValue(t,e,l):null!=Q.getValue(t,e,l)&&(g=Q.getCumulativeValue(t,e,l)),null!=g&&!isNaN(g)&&et.isDataItemRendered(t,e,l)){at.isPolar(t)&&(g=Math.max(g,n.getInfo().getViewportMin()));var d=a.getUnboundedCoordAt(u),c=n.getUnboundedCoordAt(g);if(null!=d&&null!=c){var p=new I(d,c,c,l,h,Q.isDataItemFiltered(t,e,l));s.push(p)}else s.push(new I(null,null,null,l,h,!1))}else s.push(new I(null,null,null,l,h,!1))}}return s},ct.createClippedGroup=function(e,i,r){var a=new t.Container(i.getCtx());i.addChild(a);var n=new t.ClipPath(e.getId()),s=ct._extendClipGroup(e);if(at.isPolar(e)){var o=r.x+r.w/2,l=r.y+r.h/2;if(q.isGridPolygonal(e)){var h=t.PolygonUtils.getRegularPolygonPoints(o,l,Q.getGroupCount(e),e.getRadius(),0);n.addPolygon(h)}else n.addCircle(o,l,e.getRadius())}else at.isHorizontal(e)?n.addRect(r.x-s,r.y,r.w+2*s,r.h):n.addRect(r.x,r.y-s,r.w,r.h+2*s);return a.setClipPath(n),a},ct.polarToCartesian=function(e,i,r){var a=r.x+r.w/2+e*Math.sin(i),n=r.y+r.h/2-e*Math.cos(i);return new t.Point(a,n)},ct.convertAxisCoord=function(e,i,r){if(at.isPolar(e)){var a=ct.polarToCartesian(i.y,i.x,r);return new t.Point(a.x,a.y)}return at.isHorizontal(e)?new t.Point(i.y,i.x):new t.Point(i.x,i.y)},ct._extendClipGroup=function(t){if((at.hasLineSeries(t)||at.hasLineWithAreaSeries(t))&&!at.isSpark(t)){var e=et.getLineWidth(t),i=function(t){var i=t.getInfo(),r=i.getCoordAt(i.getGlobalMax()),a=i.getCoordAt(i.getDataMax()),n=i.getCoordAt(i.getGlobalMin()),s=i.getCoordAt(i.getDataMin());return null!=r&&null!=a&&a-r<=e/2||null!=n&&null!=s&&n-s<=e/2};if(t.yAxis&&i(t.yAxis)||t.y2Axis&&i(t.y2Axis))return Math.ceil(e/2)}return 0};var pt=new Object;t.Obj.createSubclass(pt,t.Obj),pt._DEFAULT_3D_GAP_RATIO=1/36,pt._DEFAULT_2D_GAP_RATIO=1/70,pt._MAX_WIDTH_FOR_GAPS=.25,pt._GROUP_INDEX=0,pt._SLICE_VALUE_THRESHOLD=1e-4,pt.render=function(e,i,r){var a=new t.Container(e.getCtx());a.setTranslate(r.x,r.y),i.addChild(a),e.setPlotArea(a);var n,s=at.isHorizontal(e);if(s)n=new t.Rectangle(0,0,r.w,r.h);else{var o=new t.Matrix,l=t.Agent.isRightToLeft(e.getCtx())?-1:1;o=(o=(o=o.translate(-r.h/2,-r.w/2)).rotate(l*Math.PI/2)).translate(r.x+r.w/2,r.y+r.h/2),n=new t.Rectangle(0,0,r.h,r.w),a.setMatrix(o)}J.addPlotAreaDnDBackground(e,a,r,s),pt._renderFunnelSlices(e,a,n)||ut.renderEmptyText(e,i,r);var h=Q.getInitialSelection(e);J.setInitialSelection(e,h),e.highlight(et.getHighlightedCategories(e))},pt._renderFunnelSlices=function(t,e,i){for(var r=t.getOptions(),n=Q.getSeriesCount(t),s=et.getDataItemGaps(t),o=("on"==r.styleDefaults.threeDEffect?pt._DEFAULT_3D_GAP_RATIO:pt._DEFAULT_2D_GAP_RATIO)*i.w,l=s*Math.min(pt._MAX_WIDTH_FOR_GAPS*i.w/(n-1),o),h=0,u=0,g=0,d=0;d<n;d++){if(et.isDataItemRendered(t,d))null==(p=Q.getTargetValue(t,d))&&(p=Q.getValue(t,d,pt._GROUP_INDEX)),p<=0||(h+=p)}if(0==h)return!1;for(d=n-1;d>=0;d--)if(et.isDataItemRendered(t,d)){var c,p=Q.getValue(t,d,pt._GROUP_INDEX),_=Q.getTargetValue(t,d);if(!(p<=0&&null==_||null!=_&&_<=0))if(!((null!=_?_:p)<pt._SLICE_VALUE_THRESHOLD*h))null!=_?(g+=_/h,c=new R(t,d,u,i.w,i.h,1-g,_/h,p/_,l)):(g+=p/h,c=new R(t,d,u,i.w,i.h,1-g,p/h,null,l)),u++,e.addChild(c),a.associate(c,t,d,pt._GROUP_INDEX)}return!0};var _t=new Object;t.Obj.createSubclass(_t,t.Obj),_t._DEFAULT_GAP_RATIO=1/70,_t._MAX_HEIGHT_FOR_GAPS=.25,_t._GROUP_INDEX=0,_t.render=function(e,i,r){var a=new t.Container(e.getCtx());a.setTranslate(r.x,r.y),i.addChild(a),e.setPlotArea(a);var n=new t.Rectangle(0,0,r.w,r.h);J.addPlotAreaDnDBackground(e,a,r,!0),_t._renderPyramidSlices(e,a,n)||ut.renderEmptyText(e,i,r);var s=Q.getInitialSelection(e);J.setInitialSelection(e,s),e.highlight(et.getHighlightedCategories(e))},_t._renderPyramidSlices=function(t,e,i){for(var r=Q.getSeriesCount(t),n=et.getDataItemGaps(t),s=_t._DEFAULT_GAP_RATIO*i.h,o=n*Math.min(_t._MAX_HEIGHT_FOR_GAPS*i.h/(r-1),s),l=0,h=0,u=0,g=0;g<r;g++){if(et.isDataItemRendered(t,g))(d=Q.getValue(t,g,_t._GROUP_INDEX))<=0||(l+=d)}if(0==l)return!1;for(g=0;g<r;g++){var d;if(et.isDataItemRendered(t,g))if(!((d=Q.getValue(t,g,_t._GROUP_INDEX))<=0)){var c=new B(t,g,h,i.w,i.h,u,d/l,o);u+=d/l,h++,e.addChild(c),a.associate(c,t,g,_t._GROUP_INDEX)}}return!0};var ft=new Object;t.Obj.createSubclass(ft,t.Obj),ft.renderBackgroundObjects=function(t,e,i){ft._renderObjects(t,e,i,"back")},ft.renderForegroundObjects=function(t,e,i){ft._renderObjects(t,e,i,"front")},ft._renderObjects=function(t,e,i,r){ft._renderObjectsForAxis(t,e,i,r,t.xAxis,$.getAxisRefObjs(t,"x")),ft._renderObjectsForAxis(t,e,i,r,t.yAxis,$.getAxisRefObjs(t,"y")),ft._renderObjectsForAxis(t,e,i,r,t.y2Axis,$.getAxisRefObjs(t,"y2"))},ft._renderObjectsForAxis=function(t,e,i,r,a,s){if(s&&a)for(var o=0;o<s.length;o++){var l=s[o];if($.isObjectRendered(t,l)&&(l&&$.getLocation(l)==r)){var h,u=$.getType(l);if("area"==u?h=ft._createReferenceArea(l,t,i,a):"line"==u&&(h=ft._createReferenceLine(l,t,i,a)),null!=h){var g=a==t.xAxis?"xAxis":a==t.yAxis?"yAxis":"y2Axis",d=new n(t,[h],l,o,g);t.registerObject(d),t.getEventManager().associate(h,d),e.addChild(h)}}}},ft._createReferenceArea=function(e,i,r,a){var n,s=i.getCtx(),o=a.getPosition(),l="top"==o||"bottom"==o,h="radial"==o,u=$.getColor(e),g=$.getLineType(e),d=e.style||e.svgStyle,c=e.className||e.svgClassName;if(null==e.items||a!=i.yAxis&&a!=i.y2Axis){var p=$.getLowValue(e),_=$.getHighValue(e);null!=p&&p!=-1/0||(p=a.getInfo().getGlobalMin()),null!=_&&_!=1/0||(_=a.getInfo().getGlobalMax());var f=ft._getAxisCoord(i,a,p),v=ft._getAxisCoord(i,a,_);if(at.isPolar(i)){var m,S=r.x+r.w/2,C=r.y+r.h/2;if(h)if(q.isGridPolygonal(i)){var y=Q.getGroupCount(i),x=t.PolygonUtils.getRegularPolygonPoints(S,C,y,v,0,1),A=t.PolygonUtils.getRegularPolygonPoints(S,C,y,f,0,0);m=t.PathUtils.polyline(x)+t.PathUtils.polyline(A)+t.PathUtils.closePath()}else m=t.PathUtils.moveTo(S,C-v)+t.PathUtils.arcTo(v,v,Math.PI,1,S,C+v)+t.PathUtils.arcTo(v,v,Math.PI,1,S,C-v)+t.PathUtils.moveTo(S,C-f)+t.PathUtils.arcTo(f,f,Math.PI,0,S,C+f)+t.PathUtils.arcTo(f,f,Math.PI,0,S,C-f)+t.PathUtils.closePath();else{var b=i.getRadius(),M=ct.polarToCartesian(b,f,r),T=ct.polarToCartesian(b,v,r);m=t.PathUtils.moveTo(S,C)+t.PathUtils.lineTo(M.x,M.y)+t.PathUtils.arcTo(b,b,v-f,t.Agent.isRightToLeft(s)?0:1,T.x,T.y)+t.PathUtils.lineTo(T.x,T.y)+t.PathUtils.closePath()}n=new t.Path(s,m)}else{var D;D=l?[f,0,v,0,v,r.h,f,r.h]:[0,f,0,v,r.w,v,r.w,f],n=new t.Polygon(s,D)}n.setSolidFill(u),n.setStyle(d).setClassName(c)}else{var E=e.items,P=[],L=[];if(i.xAxis.isGroupAxis())for(;E.length<Q.getGroupCount(i);)E.push(null);for(var w=0;w<E.length;w++){var R=E[w],B=$.getLowValue(R),k=$.getHighValue(R);if(null!=B&&null!=k){var F=a.getUnboundedCoordAt(B),N=a.getUnboundedCoordAt(k),H=i.xAxis.getUnboundedCoordAt($.getXValue(i,E,w));P.push(new I(H,N,N)),L.push(new I(H,F,F))}else P.push(new I),L.push(new I)}n=new O(i,!0,r,null,d,c,new t.SolidFill(u),null,g,P,g,L)}return n},ft._createReferenceLine=function(e,i,r,a){var n,s=a.getPosition(),o="top"==s||"bottom"==s,l="radial"==s,h="tangential"==s,u=$.getLineWidth(e),g=$.getLineType(e),d=$.getColor(e),c=e.style||e.svgStyle,p=e.className||e.svgClassName,_=new t.Stroke(d,1,u,!1,t.Stroke.getDefaultDashProps(e.lineStyle,u)),f=i.getCtx();if(null==e.items||a!=i.yAxis&&a!=i.y2Axis){if(!e.value)return null;var v=ft._getAxisCoord(i,a,e.value);if(null==v||v==1/0||v==-1/0)return null;var m=r.x+r.w/2,S=r.y+r.h/2;if(l){if(q.isGridPolygonal(i)){y=t.PolygonUtils.getRegularPolygonPoints(m,S,Q.getGroupCount(i),v,0);n=new t.Polygon(f,y)}else n=new t.Circle(f,m,S,v);n.setFill(null)}else if(h){var C=ct.polarToCartesian(i.getRadius(),v,r);n=new t.Line(f,m,S,C.x,C.y)}else(n=o?new t.Line(f,v,0,v,r.h):new t.Line(f,0,v,r.w,v)).setPixelHinting(!0);n.setStroke(_),n.setStyle(c).setClassName(p)}else{var y,x=e.items;if([].push(y=[]),i.xAxis.isGroupAxis())for(;x.length<Q.getGroupCount(i);)x.push(null);for(var A=[],b=0;b<x.length;b++){var M=x[b],T=null;if(null!=M&&("object"!=typeof M?T=M:null!=M.value&&(T=M.value)),null!=T){var D=a.getUnboundedCoordAt(T),E=i.xAxis.getUnboundedCoordAt($.getXValue(i,x,b));A.push(new I(E,D,D))}else A.push(new I)}n=new O(i,!1,r,null,c,p,null,_,g,A)}return n},ft._getAxisCoord=function(t,e,i){if(e.isGroupAxis()){var r=Q.getGroupIndex(t,i);if(r>=0)return e.getUnboundedCoordAt(r)}return isNaN(i)?null:e.getUnboundedCoordAt(i)},t.SparkChart=function(){},t.Obj.createSubclass(t.SparkChart,t.BaseComponent),t.SparkChart.newInstance=function(e,i,r){var a=new t.SparkChart;return e.getStage().setCursor(""),a.Init(e,i,r),a},t.SparkChart.getDefaults=function(t){return(new mt).getDefaults(t)},t.SparkChart.prototype.Init=function(e,i,r){t.SparkChart.superclass.Init.call(this,e,i,r),this.Defaults=new mt(e),this.EventManager=new St(this),this.EventManager.addListeners(this),this._chart=t.Chart.newInstance(e,this._onRenderEnd,this),this.addChild(this._chart),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new t.KeyboardHandler(this.EventManager,this)),this._tooltipMask=new t.Rect(e),this.addChild(this._tooltipMask),this.setId("sparkChart1000"+Math.floor(1e9*Math.random()))},t.SparkChart.prototype.SetOptions=function(e){e?(this.Options=this.Defaults.calcOptions(e),t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults())},t.SparkChart.prototype.setId=function(e){t.SparkChart.superclass.setId.call(this,e),this._chart&&this._chart.setId(e+"chart")},t.SparkChart.prototype.render=function(e,i,r){this.SetOptions(e),isNaN(i)||isNaN(r)||(this.Width=i,this.Height=r),this._eventReceived=!1,this._isDoneRendering=!1,Ct.render(this,this.Width,this.Height);var a=this.Options.shortDesc;this._tooltipMask.setWidth(this.Width),this._tooltipMask.setHeight(this.Height),this._tooltipMask.setInvisibleFill();var n=this.Options.tooltip,s=n?n.renderer:null,o=this.Options.color;if(s){var l={component:this.Options._widgetConstructor,color:o};this._peer=new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),s,o,l),this.EventManager.associate(this._tooltipMask,this._peer)}else a?(this._peer=new t.SimpleObjPeer(null,a,o),this.EventManager.associate(this._tooltipMask,this._peer)):this._peer=null;this.Options._selectingCursor&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.UpdateAriaAttributes(),this._eventReceived&&this.RenderComplete(),this._isDoneRendering=!0},t.SparkChart.prototype._onRenderEnd=function(t){this._eventReceived=!0,"ready"==t.type&&this._isDoneRendering&&this.RenderComplete()},t.SparkChart.prototype.__getChart=function(){return this._chart},t.SparkChart.prototype.getAutomation=function(){return new vt(this)},t.SparkChart.prototype.UpdateAriaAttributes=function(){var e=t.Displayable.generateAriaLabel(t.TextUtils.processAriaLabel(this.GetComponentDescription()),this.Options.shortDesc?[this.Options.shortDesc]:null),i=this.Options.translations;this.IsParentRoot()?(this.getCtx().setAriaRole("img"),this.getCtx().setAriaLabel(t.ResourceUtils.format(i.labelAndValue,[i.labelDataVisualization,e]))):(this.setAriaRole("img"),this.setAriaProperty("label",e))},t.SparkChart.prototype.__getLogicalObject=function(){return this._peer};var vt=function(t){this._sparkChart=t};t.Obj.createSubclass(vt,t.Automation),vt.prototype.getDataItem=function(t){var e=this._sparkChart.__getChart().getAutomation().getDataItem(0,t);return e?{borderColor:e.borderColor,color:e.color,date:e.x,low:e.low,high:e.high,value:null==e.low||null==e.high?e.value:e.high-e.low}:null};var mt=function(t){this.Init({alta:mt.SKIN_ALTA},t)};t.Obj.createSubclass(mt,t.BaseComponentDefaults),mt.SKIN_ALTA={skin:t.CSSStyle.SKIN_ALTA,type:"line",animationOnDisplay:"none",animationOnDataChange:"none",areaSvgClassName:"",emptyText:null,color:"#267db3",firstColor:"",lastColor:"",highColor:"",lowColor:"",visualEffects:"auto",baselineScaling:"min",barSpacing:"auto",lineWidth:1,lineStyle:"solid",lineType:"straight",markerSize:5,markerShape:"auto",barGapRatio:.25,referenceObjects:[],svgClassName:"",_statusMessageStyle:new t.CSSStyle("font-size: 12px; color: #404259;")},mt.prototype.getAnimationDuration=function(t){return t.animationDuration};var St=function(t){this.Init(t.getCtx(),t.dispatchEvent,t,t),this._sparkChart=t};t.Obj.createSubclass(St,t.EventManager),St.prototype.ProcessKeyboardEvent=function(e){if(!this.KeyboardHandler)return!1;if(e.keyCode==t.KeyboardEvent.TAB){var i=this._sparkChart.getCtx().getStageAbsolutePosition();this.ProcessObjectTooltip(e,i.x,i.y,this._sparkChart.__getLogicalObject(),this._sparkChart)}return!1},St.prototype.OnBlur=function(t){St.superclass.OnBlur.call(this,t),this.hideTooltip()};var Ct=new Object;t.Obj.createSubclass(Ct,t.Obj),Ct.render=function(t,e,i){var r=t.__getChart(),a=Ct._convertOptionsObj(t),n=t.getOptions();if("area"==n.type||"line"==n.type||"lineWithArea"==n.type){var s=Ct._getDataItems(t),o=!1;if(n.firstColor||n.lastColor||n.highColor||n.lowColor)o=!0;else for(var l=0;l<s.length;l++)if(s[l]&&"on"==s[l].markerDisplayed){o=!0;break}if(o&&s.length>0||"none"==n.lineType){var h=n.markerSize/2;e-=2*h,i-=2*h,r.setTranslate(h,h)}}r.render(a,e,i)},Ct._getDataItems=function(t){var e=t.getOptions();return e&&e.items?e.items:[]},Ct._convertOptionsObj=function(e){var i=e.getOptions(),r={styleDefaults:{},xAxis:{},yAxis:{},groups:[]};r.translations=i.translations;for(var a=[],n=-1,s=-1,o=-1/0,l=1/0,h=Ct._getDataItems(e),u=0;u<h.length;u++){var g=h[u],d={};g instanceof Object?(d.value=g.value,d.low=g.low,d.high=g.high,g.date&&(r.timeAxisType="enabled",r.groups.push(g.date)),"on"==g.markerDisplayed&&(d.markerDisplayed="on"),g.color&&(d.color=g.color),g.borderColor&&(d.borderColor=g.borderColor),g.markerShape&&(d.markerShape=g.markerShape),g.markerSize&&(d.markerSize=g.markerSize),(g.className||g.svgClassName)&&(d.svgClassName=g.className||g.svgClassName),(g.style||g.svgStyle)&&(d.svgStyle=g.style||g.svgStyle)):d.value=g,a.push(d);var c=null!=d.value?d.value:Math.max(d.low,d.high);o<c&&(o=c,n=u);var p=null!=d.value?d.value:Math.min(d.low,d.high);l>p&&(l=p,s=u)}i.highColor&&n>=0&&(a[n].markerDisplayed="on",a[n].color||(a[n].color=i.highColor)),i.lowColor&&s>=0&&(a[s].markerDisplayed="on",a[s].color||(a[s].color=i.lowColor)),i.firstColor&&a.length>0&&(a[0].markerDisplayed="on",a[0].color||(a[0].color=i.firstColor)),i.lastColor&&a.length>0&&(a[a.length-1].markerDisplayed="on",a[a.length-1].color||(a[a.length-1].color=i.lastColor)),r.series=[{items:a,areaColor:i.areaColor,svgClassName:i.className||i.svgClassName,svgStyle:i.style||i.svgStyle,areaSvgClassName:i.areaClassName||i.areaSvgClassName,areaStyle:i.areaStyle||i.areaSvgStyle}],i.referenceObjects&&i.referenceObjects.length>0&&(r.yAxis.referenceObjects=i.referenceObjects),r.__spark=!0;var _=i.barSpacing;"auto"==_&&(_=t.Agent.getDevicePixelRatio()>1?"subpixel":"pixel"),r.__sparkBarSpacing=_,r.type=i.type,r.animationOnDataChange=i.animationOnDataChange,r.animationOnDisplay=i.animationOnDisplay,r.emptyText=i.emptyText,i.color&&(r.styleDefaults.colors=[i.color]),r.styleDefaults.animationDuration=i.animationDuration,r.styleDefaults.animationIndicators="none",r.styleDefaults.lineWidth=i.lineWidth,r.styleDefaults.lineStyle=i.lineStyle,r.styleDefaults.lineType=i.lineType,r.styleDefaults.markerSize=i.markerSize,r.styleDefaults.markerShape=i.markerShape,r.styleDefaults.barGapRatio=i.barGapRatio,r.styleDefaults.dataItemGaps="0%",r.xAxis.rendered="off",r.yAxis.rendered="off";var f="zero"==i.baselineScaling,v=o!=l?.1*(o-l):.1*Math.abs(o);return r.yAxis.min=f&&l>=0?0:l-v,r.yAxis.max=f&&o<=0?0:o+v,"none"==i.visualEffects||"area"!=i.type&&"lineWithArea"!=i.type?r.styleDefaults.seriesEffect="color":r.styleDefaults.seriesEffect="gradient",r.layout={gapWidthRatio:0,gapHeightRatio:0},r.legend={rendered:"off"},r._statusMessageStyle=i._statusMessageStyle,r}}(dvt);
  return dvt;
});
