/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['jquery','./DvtToolkit', './DvtPanZoomCanvas','./DvtOverview'], function($, dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){var e=function(t){this.Init(t)};t.Obj.createSubclass(e,t.Obj,"DvtDiagramLayoutContext"),e.prototype.Init=function(t){this._nodeCount=0,this._linkCount=0,this._bLocaleR2L=!1,this._nodes=new t.ojMap,this._links=new t.ojMap,this._arNodes=[],this._arLinks=[],this._dirtyContext=new t.ojMap,this.Context=t},e.prototype.setLayout=function(t){this._layout=t},e.prototype.getLayout=function(){return this._layout},e.prototype.setLayoutAttributes=function(t){this._layoutAttrs=t},e.prototype.getLayoutAttributes=function(){return this._layoutAttrs},e.prototype.addNode=function(t){this.getNodeById(t.getId())||(this._nodeCount++,this._arNodes.push(t)),this._nodes.set(t.getId(),t)},e.prototype.addNodeToMap=function(t){this._nodes.set(t.getId(),t)},e.prototype.removeNode=function(e,n){n&&(e?t.ArrayUtils.removeItem(e.getChildNodes(),n):(t.ArrayUtils.removeItem(this._arNodes,n),this._nodeCount--),this._nodes.delete(n.getId()))},e.prototype.getNodeById=function(t){return this._nodes.get(t)},e.prototype.getNodeByIndex=function(t){return this._arNodes[t]},e.prototype.getNodeCount=function(){return this._nodeCount},e.prototype.addLink=function(t){this.getLinkById(t.getId())||(this._linkCount++,this._arLinks.push(t)),this._links.set(t.getId(),t)},e.prototype.removeLink=function(e){e&&(this.getLinkById(e.getId())&&(t.ArrayUtils.removeItem(this._arLinks,e),this._linkCount--),this._links.delete(e.getId()))},e.prototype.getLinkById=function(t){return this._links.get(t)},e.prototype.getLinkByIndex=function(t){return this._arLinks[t]},e.prototype.getLinkCount=function(){return this._linkCount},e.prototype.localToGlobal=function(e,n){var i=this.GetGlobalOffset(n);return new t.DiagramPoint(e.x+i.x,e.y+i.y)},e.prototype.GetGlobalOffset=function(e){for(var n=new t.DiagramPoint(0,0);e;){n.x+=e.ContentOffset.x+e.getPosition().x,n.y+=e.ContentOffset.y+e.getPosition().y;var i=e.getContainerId();if(i){if((e=this.getNodeById(i))&&e.isDisclosed()){var o=e.getContainerPadding();o&&(n.x+=o.left,n.y+=o.top)}}else e=null}return n},e.prototype.setLocaleR2L=function(t){this._bLocaleR2L=t},e.prototype.isLocaleR2L=function(){return this._bLocaleR2L},e.prototype.setComponentSize=function(t){this._componentSize=t},e.prototype.getComponentSize=function(){return this._componentSize},e.prototype.setViewport=function(t){this._viewport=t},e.prototype.getViewport=function(){return this._viewport},e.prototype.setContainerId=function(t){this._containerId=t},e.prototype.getContainerId=function(){return this._containerId},e.prototype.setContainerPadding=function(t,e,n,i){this.getContainerId()&&(this._containerPadding={},"number"!=typeof t&&"string"!=typeof t&&(i=t.left,e=t.right,n=t.bottom,t=t.top),this._containerPadding.top=t,this._containerPadding.right=e,this._containerPadding.bottom=n,this._containerPadding.left=i)},e.prototype.getContainerPadding=function(){return this._containerPadding},e.prototype.setCurrentViewport=function(t){this._currentViewport=t},e.prototype.getCurrentViewport=function(){return this._currentViewport},e.prototype.getCommonContainer=function(e,n){for(var i=function(t,e){for(var n=[],i=e.getNodeById(t)?e.getNodeById(t).getContainerId():null;i;)n.push(i),i=e.getNodeById(i)?e.getNodeById(i).getContainerId():null;return n.reverse(),n},o=i(e,this),a=i(n,this),r=null,s=0;s<o.length&&s<a.length&&t.BaseDiagram.compareValues(this.Context,o[s],a[s]);s++)r=o[s];return r},e.prototype.getEventData=function(){return this._eventData},e.prototype.setEventData=function(t){this._eventData=t},e.prototype.setDirtyContext=function(t){this._dirtyContext=t},e.prototype.getDirtyContext=function(){return this._dirtyContext};var n=function(){this.Init()};t.Obj.createSubclass(n,t.Obj,"DvtDiagramLayoutContextLink"),n.prototype.Init=function(){this._startConnectorOffset=0,this._endConnectorOffset=0,this._linkWidth=1,this._selected=!1,this._bPromoted=!1},n.prototype.setId=function(t){this._id=t},n.prototype.getId=function(){return this._id},n.prototype.setStartId=function(t){this._startId=t},n.prototype.getStartId=function(){return this._startId},n.prototype.setEndId=function(t){this._endId=t},n.prototype.getEndId=function(){return this._endId},n.prototype.setPoints=function(e){this._points="string"==typeof e?t.PathUtils.createPathArray(e):e,this.setDirty()},n.prototype.getPoints=function(){return this._points},n.prototype.setLabelPosition=function(t){this._labelPosition=t,this.setDirty()},n.prototype.getLabelPosition=function(){return this._labelPosition},n.prototype.setLabelBounds=function(t){this._labelBounds=t},n.prototype.getLabelBounds=function(){return this._labelBounds},n.prototype.setStartConnectorOffset=function(t){this._startConnectorOffset=t},n.prototype.getStartConnectorOffset=function(){return this._startConnectorOffset},n.prototype.setEndConnectorOffset=function(t){this._endConnectorOffset=t},n.prototype.getEndConnectorOffset=function(){return this._endConnectorOffset},n.prototype.setLinkWidth=function(t){this._linkWidth=t},n.prototype.getLinkWidth=function(){return this._linkWidth},n.prototype.setLayoutAttributes=function(t){this._layoutAttrs=t},n.prototype.getLayoutAttributes=function(){return this._layoutAttrs},n.prototype.setSelected=function(t){this._selected=t},n.prototype.getSelected=function(){return this._selected},n.prototype.setLabelRotationAngle=function(t){this._labelRotAngle=t,this.setDirty()},n.prototype.getLabelRotationAngle=function(){return this._labelRotAngle},n.prototype.setLabelRotationPoint=function(t){this._labelRotPoint=t,this.setDirty()},n.prototype.getLabelRotationPoint=function(){return this._labelRotPoint},n.prototype.setPromoted=function(t){this._bPromoted=t},n.prototype.isPromoted=function(){return this._bPromoted},n.prototype.setLabelValign=function(t){this._labelValign=t,this.setDirty()},n.prototype.setLabelHalign=function(t){this._labelHalign=t,this.setDirty()},n.prototype.getLabelValign=function(){return this._labelValign},n.prototype.getLabelHalign=function(){return this._labelHalign},n.prototype.setCoordinateSpace=function(t){this._coordinateContainerId=t,this.setDirty()},n.prototype.getCoordinateSpace=function(){return this._coordinateContainerId},n.prototype.setData=function(t){this._data=t},n.prototype.getData=function(){return this._data},n.prototype.setDirty=function(){this.LayoutContext&&this.LayoutContext.getDirtyContext().set(this.getId(),!0)},n.prototype.copyFrom=function(t){t&&(this.setPoints(t.getPoints()),this.setLabelPosition(t.getLabelPosition()),this.setLabelRotationAngle(t.getLabelRotationAngle()),this.setLabelRotationPoint(t.getLabelRotationPoint()),this.setLabelValign(t.getLabelValign()),this.setLabelHalign(t.getLabelHalign()),this.setCoordinateSpace(t.getCoordinateSpace()))};var i=function(){this.Init()};t.Obj.createSubclass(i,t.Obj,"DvtDiagramLayoutContextNode"),i.prototype.Init=function(){this._bReadOnly=!1,this._selected=!1,this._bDisclosed=!1,this.IsRendered=!0,this.ContentOffset=new t.DiagramPoint(0,0)},i.prototype.setId=function(t){this._id=t},i.prototype.getId=function(){return this._id},i.prototype.setBounds=function(t){this._bounds=t,this._origBounds=t},i.prototype.getBounds=function(){return!this._bounds&&this.Component&&this.Component.updateNodeDims(this),this._bounds},i.prototype.setContentBounds=function(t){this._contentBounds=t,this._origContentBounds=t},i.prototype.getContentBounds=function(){return!this._contentBounds&&this.Component&&this.Component.updateNodeDims(this),this._contentBounds},i.prototype.setPosition=function(t){this._position=t,this.UpdateParentNodes(),this.setDirty()},i.prototype.getPosition=function(){return this._position},i.prototype.getRelativePosition=function(e){var n=this.LayoutContext;if(n){for(var i=new t.DiagramPoint(0,0),o=this,a=!1;o;){var r=o.getContainerId();if(r){var s=n.getNodeById(r);s&&this.Component&&!s.IsRendered&&this.Component.renderNodeFromContext(s,!0)}if(i.x+=o.ContentOffset.x+o.getPosition().x,i.y+=o.ContentOffset.y+o.getPosition().y,t.BaseDiagram.compareValues(n.Context,r,e))a=!0,o=null;else if((o=n.getNodeById(r))&&o.isDisclosed()){var l=o.getContainerPadding();l&&(i.x+=l.left,i.y+=l.top)}else o=null}return a||(i=null),i}},i.prototype.setLabelPosition=function(t){this._labelPosition=t,this.setDirty()},i.prototype.getLabelPosition=function(){return this._labelPosition},i.prototype.setLabelBounds=function(t){this._labelBounds=t},i.prototype.getLabelBounds=function(){return!this._labelBounds&&this.Component&&this.Component.updateNodeDims(this),this._labelBounds},i.prototype.setLayoutAttributes=function(t){this._layoutAttrs=t},i.prototype.getLayoutAttributes=function(){return this._layoutAttrs},i.prototype.setReadOnly=function(t){this._bReadOnly=t},i.prototype.isReadOnly=function(){return this._bReadOnly},i.prototype.setContainerId=function(t){this._containerId=t},i.prototype.getContainerId=function(){return this._containerId},i.prototype.setSelected=function(t){this._selected=t},i.prototype.getSelected=function(){return this._selected},i.prototype.setLabelRotationAngle=function(t){this._labelRotAngle=t,this.setDirty()},i.prototype.getLabelRotationAngle=function(){return this._labelRotAngle},i.prototype.setLabelRotationPoint=function(t){this._labelRotPoint=t,this.setDirty()},i.prototype.getLabelRotationPoint=function(){return this._labelRotPoint},i.prototype.SetContainerPaddingObj=function(e){this.isDisclosed()&&(this._containerPadding=e,e&&(this._origBounds&&(this._origBounds=new t.DiagramRectangle(this._origBounds.x,this._origBounds.y,this._origBounds.w-(e.left+e.right),this._origBounds.h-(e.top+e.bottom))),this._origContentBounds&&(this._origContentBounds=new t.DiagramRectangle(this._origContentBounds.x,this._origContentBounds.y,this._origContentBounds.w-(e.left+e.right),this._origContentBounds.h-(e.top+e.bottom)))))},i.prototype.setContainerPadding=function(e,n,i,o){this.isDisclosed()&&(this._containerPadding={},"number"!=typeof e&&"string"!=typeof e&&(o=e.left,n=e.right,i=e.bottom,e=e.top),this._containerPadding.top=e,this._containerPadding.right=n,this._containerPadding.bottom=i,this._containerPadding.left=o,this._origBounds&&(this._bounds=new t.DiagramRectangle(this._origBounds.x,this._origBounds.y,this._origBounds.w+o+n,this._origBounds.h+e+i)),this._origContentBounds&&(this._contentBounds=new t.DiagramRectangle(this._origContentBounds.x,this._origContentBounds.y,this._origContentBounds.w+o+n,this._origContentBounds.h+e+i)),this.setDirty())},i.prototype.getContainerPadding=function(){return this._containerPadding},i.prototype.setDisclosed=function(t){this._bDisclosed=t},i.prototype.isDisclosed=function(){return this._bDisclosed},i.prototype.setChildNodes=function(t){this._childNodes=t},i.prototype.getChildNodes=function(){return this._childNodes},i.prototype.setParentNode=function(t){this._parentNode=t},i.prototype.getParentNode=function(){return this._parentNode},i.prototype.UpdateParentNodes=function(){var t=this.getParentNode();t&&t.IsRendered&&(t.Reset(),t.UpdateParentNodes())},i.prototype.Reset=function(){this.IsRendered=!1,this.setBounds(null),this.setContentBounds(null),this.setLabelBounds(null),this.setDirty()},i.prototype.setLabelValign=function(t){this._labelValign=t,this.setDirty()},i.prototype.setLabelHalign=function(t){this._labelHalign=t,this.setDirty()},i.prototype.getLabelValign=function(){return this._labelValign},i.prototype.getLabelHalign=function(){return this._labelHalign},i.prototype.setData=function(t){this._data=t},i.prototype.getData=function(){return this._data},i.prototype.setDirty=function(){this.LayoutContext&&this.LayoutContext.getDirtyContext().set(this.getId(),!0)},i.prototype.copyFrom=function(t){t&&(this.setPosition(t.getPosition()),this.setLabelPosition(t.getLabelPosition()),this.setLabelRotationAngle(t.getLabelRotationAngle()),this.setLabelRotationPoint(t.getLabelRotationPoint()),this.setLabelValign(t.getLabelValign()),this.setLabelHalign(t.getLabelHalign()),t.getContainerPadding()&&this.setContainerPadding(t.getContainerPadding()))};var o=function(t,e){this.Init(t,e)};t.Obj.createSubclass(o,t.Obj,"DvtDiagramPoint"),o.prototype.Init=function(t,e){this.x=null===t||isNaN(t)?0:t,this.y=null===e||isNaN(e)?0:e};var a=function(t,e,n,i){this.Init(t,e,n,i)};t.Obj.createSubclass(a,t.Obj,"DvtDiagramRectangle"),a.prototype.Init=function(t,e,n,i){this.x=null===t||isNaN(t)?0:t,this.y=null===e||isNaN(e)?0:e,this.w=null===n||isNaN(n)?0:n,this.h=null===i||isNaN(i)?0:i},t.DiagramPoint=o,t.DiagramRectangle=a,t.BaseDiagram=function(t,e,n){this.Init(t,e,n)},t.Obj.createSubclass(t.BaseDiagram,t.PanZoomComponent,"dvt.BaseDiagram"),t.BaseDiagram.prototype.Init=function(e,n,i){t.BaseDiagram.superclass.Init.call(this,e,n,i),this.getCtx().getStage().getElem().setAttributeNS(null,"text-rendering","geometricPrecision"),this._linksPane=new t.Container(e),this._nodesPane=new t.Container(e),this._topPane=new t.Container(e),this.InitializeZoomLimits()},t.BaseDiagram.prototype.InitComponentInternal=function(){var t=this.getPanZoomCanvas();t.setMinZoom(this.getMinZoom()),t.setMaxZoom(this.getMaxZoom()),t.setAnimationDuration(this.getAnimationDuration()),t.getContentPane().addChild(this._linksPane),t.getContentPane().addChild(this._nodesPane),t.getContentPane().addChild(this._topPane)},t.BaseDiagram.prototype.getAnimationDuration=function(){return t.PanZoomCanvas.DEFAULT_ANIMATION_DURATION},t.BaseDiagram.prototype.setMaxZoom=function(t){this._maxZoom=t,this.getPanZoomCanvas()&&this.getPanZoomCanvas().setMaxZoom(t)},t.BaseDiagram.prototype.getMaxZoom=function(){return this._maxZoom},t.BaseDiagram.prototype.setMinZoom=function(t){this._minZoom=t,this.getPanZoomCanvas()&&this.getPanZoomCanvas().setMinZoom(t)},t.BaseDiagram.prototype.getMinZoom=function(){return this._minZoom},t.BaseDiagram.prototype.InitializeZoomLimits=function(){this.setMaxZoom(2),this.setMinZoom(0)},t.BaseDiagram.prototype.getNodeById=function(t){return null},t.BaseDiagram.prototype.getLinkById=function(t){return null},t.BaseDiagram.prototype.GetAllLinks=function(){return[]},t.BaseDiagram.prototype.GetAllNodes=function(){return[]},t.BaseDiagram.prototype.GetAllRoots=function(){return[]},t.BaseDiagram.prototype.RefreshEmptyText=function(e){if(e&&this.getEmptyText())this._emptyTextDisplay?(this._emptyTextDisplay.setX(this.Width/2),this._emptyTextDisplay.setY(this.Height/2),t.TextUtils.fitText(this._emptyTextDisplay,this.getWidth()-2*t.TextUtils.EMPTY_TEXT_BUFFER,1/0,this)):this._emptyTextDisplay=this.CreateEmptyText(this.getEmptyText());else if(this._emptyTextDisplay){var n=this._emptyTextDisplay.getParent();n&&n.removeChild(this._emptyTextDisplay),this._emptyTextDisplay=null}},t.BaseDiagram.prototype.CreateEmptyText=function(e){var n=this.getOptions();return t.TextUtils.renderEmptyText(this,e,new t.Rectangle(0,0,this.getWidth(),this.getHeight()),this.getEventManager(),n._statusMessageStyle)},t.BaseDiagram.prototype.setEmptyText=function(t){this._emptyText=t},t.BaseDiagram.prototype.getEmptyText=function(){return this._emptyText},t.BaseDiagram.prototype.SetPanningEnabled=function(t){this._panningEnabled=t},t.BaseDiagram.prototype.IsPanningEnabled=function(){return this._panningEnabled},t.BaseDiagram.prototype.setPanDirection=function(t){this._panDirection=t,this.getPanZoomCanvas()&&this.getPanZoomCanvas().setPanDirection(t)},t.BaseDiagram.prototype.getPanDirection=function(){return this._panDirection},t.BaseDiagram.prototype.SetZoomingEnabled=function(t){this._zoomingEnabled=t},t.BaseDiagram.prototype.IsZoomingEnabled=function(){return this._zoomingEnabled},t.BaseDiagram.prototype.getSelectionHandler=function(){return this._selectionHandler},t.BaseDiagram.prototype.setSelectionMode=function(e){this._selectionHandler="single"==e?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"==e?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):null,this.getEventManager().setSelectionHandler(this._selectionHandler)},t.BaseDiagram.prototype.getSelectionMode=function(){return this._selectionHandler?this._selectionHandler.getType():null},t.BaseDiagram.prototype.isSelectionSupported=function(){return!!this._selectionHandler},t.BaseDiagram.prototype.getNodesPane=function(){return this._nodesPane},t.BaseDiagram.prototype.setNodesPane=function(t){this._nodesPane=t},t.BaseDiagram.prototype.getLinksPane=function(){return this._linksPane},t.BaseDiagram.prototype.setLinksPane=function(t){this._linksPane=t},t.BaseDiagram.prototype.getTopPane=function(){return this._topPane},t.BaseDiagram.prototype.setTopPane=function(t){this._topPane=t},t.BaseDiagram.prototype.getBottomPane=function(){this._bottomPane||(this._bottomPane=new t.Container(this.getCtx()),this.getPanZoomCanvas().getContentPane().addChildAt(this._bottomPane,0));return this._bottomPane},t.BaseDiagram.prototype.CreateEmptyLayoutContext=function(){var n=new e(this.getCtx());return n.setLocaleR2L(t.Agent.isRightToLeft(this.getCtx())),n.setComponentSize(new t.DiagramRectangle(0,0,this.getWidth(),this.getHeight())),n},t.BaseDiagram.prototype.CreateLayoutContextNode=function(e,n,o,a){var r=new i;r.setId(e.getId?e.getId():e.getData().getId()),r.setBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(e.getLayoutBounds())),r.setContentBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(e.getContentBounds()));var s=e.getLayoutAttributes?e.getLayoutAttributes(n):e.getData()._itemData;return r.setLayoutAttributes(s),r.setData(s),r.setLabelBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(e.getLabelBounds())),r.setLabelPosition(t.DiagramLayoutUtils.convertPointToDiagramPoint(e.getLabelPosition())),r.setSelected(1==e.isSelected()),e.isDisclosed()&&(r.setDisclosed(!0),r.SetContainerPaddingObj(t.BaseDiagram.getLayoutContainerPadding(e.getContainerPadding()))),r.setContainerId(e.getGroupId()),r.Component=this,r.IsRendered=!o,r.LayoutContext=a,r},t.BaseDiagram.prototype.CreateLayoutContextLink=function(e,i,o,a,r){var s,l=new n;return l.setId(e.getId?e.getId():e.getData().getId()),l.setStartId(i||e.getData().getStartId()),l.setEndId(o||e.getData().getEndId()),e.isPromoted()?(s=e.getData()._links,this.isDataProviderMode()&&(s=s.map(function(t){return t._itemData}))):s=e.getData()._itemData,l.setLayoutAttributes(s),l.setData(s),l.setLabelBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(e.getLabelBounds())),l.setLabelPosition(t.DiagramLayoutUtils.convertPointToDiagramPoint(e.getLabelPosition())),l.setStartConnectorOffset(e.getStartConnectorOffset()),l.setEndConnectorOffset(e.getEndConnectorOffset()),l.setLinkWidth(e.getLinkWidth()),l.setSelected(1==e.isSelected()),l.setPromoted(1==e.isPromoted()),l.LayoutContext=r,l},t.BaseDiagram.prototype.ApplyLayoutContext=function(e,n){var i=e.getContainerPadding();if(i){var o=e.getContainerId();if(o){var a=this.getNodeById(o);a&&a.setContainerPadding(t.BaseDiagram.getContainerPadding(i))}}for(var r=Number.MAX_VALUE,s=Number.MAX_VALUE,l=0;l<e.getNodeCount();l++){(D=(_=e.getNodeByIndex(l)).getPosition())&&(r=Math.min(r,D.x),s=Math.min(s,D.y));var g=_.getLabelBounds(),u=_.getLabelPosition();g&&u&&(r=Math.min(r,u.x+g.x),s=Math.min(s,u.y+g.y))}for(var d=0;d<e.getLinkCount();d++){if(k=(B=e.getLinkByIndex(d)).getPoints())for(var h=t.DiagramLinkUtils.GetControlPoints(k),p=0;p<h.length;p++){var c=h[p];r=Math.min(r,c.x),s=Math.min(s,c.y)}g=B.getLabelBounds(),u=B.getLabelPosition();g&&u&&(r=Math.min(r,u.x+g.x),s=Math.min(s,u.y+g.y))}var y=new t.Point(-r,-s),m=y.x,C=y.y,f=e.getDirtyContext();for(l=0;l<e.getNodeCount();l++){var _;if((_=e.getNodeByIndex(l)).getContainerId()&&(_.ContentOffset=new t.DiagramPoint(y.x,y.y)),f.has(_.getId())){var D,L=this.getNodeById(_.getId());if((D=_.getPosition())&&L.SetPosition(D.x+m,D.y+C),this.ApplyLabelPosition(_,L,t.DiagramLayoutUtils.convertDiagramPointToPoint(D)),L.isDisclosed()){var b=_.getContainerPadding();b&&L.setContainerPadding(t.BaseDiagram.getContainerPadding(b))}}}for(d=0;d<e.getLinkCount();d++){var B=e.getLinkByIndex(d);if(f.has(B.getId())){var k,P=this.getLinkById(B.getId()),N=this.GetLinkTranslationOffset(P,B,y),x=N.x,v=N.y;if(k=B.getPoints()){k.length>0&&!isNaN(k[0])&&(k=t.DiagramLinkUtils.ConvertToPath(k));var R=[];for(p=0;p<k.length;)isNaN(k[p])?(R.push(k[p]),p++):(R.push(k[p]+x),R.push(k[p+1]+v),p+=2);P.setPoints(R)}this.ApplyLabelPosition(B,P,new t.Point(-x,-v))}}var E=e.getViewport();E&&(this._layoutViewport=new t.Rectangle(E.x+m,E.y+C,E.w,E.h)),n&&(this._layoutOffset=new t.Point(m,C))},t.BaseDiagram.prototype.GetLinkTranslationOffset=function(e,n,i){var o=new t.Point(0,0),a=this.getCtx();if(e.getGroupId()){if(!t.BaseDiagram.compareValues(a,e.getGroupId(),n.getCoordinateSpace())){for(var r=n.getCoordinateSpace(),s=this.getNodeById(e.getGroupId());s;){var l=s.getContainerPadding();o.x-=l.left-s.GetPosition().x,o.y-=l.top-s.GetPosition().y;var g=s.getGroupId();s=t.BaseDiagram.compareValues(a,g,r)?null:this.getNodeById(g)}r||(o.x+=i.x,o.y+=i.y)}}else o=i;return o},t.BaseDiagram.prototype.GetLayoutViewport=function(){return this._layoutViewport},t.BaseDiagram.prototype.IsLayoutViewport=function(){return!!this._layoutViewport},t.BaseDiagram.prototype.ClearLayoutViewport=function(){this._layoutViewport=null},t.BaseDiagram.prototype.AdjustMinZoom=function(t){if(0==this.getMinZoom()){var e=this.getPanZoomCanvas(),n=t||this.GetViewBounds(),i=this.CalculateMinimumScale(n);return e.setMinZoom(this.GetMinZoomFactor()*Math.min(i,e.getMaxZoom())),n}return null},t.BaseDiagram.prototype.GetMinZoomFactor=function(){return 1},t.BaseDiagram.prototype.CalculateMinimumScale=function(t){if(!t)return 0;var e=this.getPanZoomCanvas(),n=(this.Width-2*e.getZoomToFitPadding())/t.w,i=(this.Height-2*e.getZoomToFitPadding())/t.h;return Math.min(n,i)},t.BaseDiagram.prototype.GetViewBounds=function(){for(var t,e,n,i,o,a,r,s,l,g=null,u=this.GetAllRoots(),d=0;d<u.length;d++)o=u[d],(i=this.getNodeById(o))&&i.getVisible()&&(t=i.GetNodeBounds(),e=i.getTranslateX(),n=i.getTranslateY(),t.x+=e,t.y+=n,g?(s=g.x,l=g.y,g.x=Math.min(g.x,t.x),g.y=Math.min(g.y,t.y),g.w=Math.max(s+g.w,t.x+t.w)-g.x,g.h=Math.max(l+g.h,t.y+t.h)-g.y):g=t);var h=this.GetAllLinks();for(d=0;d<h.length;d++)if(r=h[d],(a=this.getLinkById(r))&&a.getVisible()){if(t=a.GetLinkBounds(),a.getGroupId())continue;g?(s=g.x,l=g.y,g.x=Math.min(g.x,t.x),g.y=Math.min(g.y,t.y),g.w=Math.max(s+g.w,t.x+t.w)-g.x,g.h=Math.max(l+g.h,t.y+t.h)-g.y):g=t}return g},t.BaseDiagram.RotateBounds=function(e,n,i){if(null==n&&!i)return e;var o=new t.Point(e.x,e.y),a=new t.Point(e.x+e.w,e.y),r=new t.Point(e.x,e.y+e.h),s=new t.Point(e.x+e.w,e.y+e.h),l=new t.Matrix;null!=n&&(i&&(l=l.translate(-i.x,-i.y)),l=l.rotate(n),i&&(l=l.translate(i.x,i.y)));var g=l.transformPoint(o),u=l.transformPoint(a),d=l.transformPoint(r),h=l.transformPoint(s),p=Math.min(Math.min(g.x,u.x),Math.min(d.x,h.x)),c=Math.max(Math.max(g.x,u.x),Math.max(d.x,h.x)),y=Math.min(Math.min(g.y,u.y),Math.min(d.y,h.y)),m=Math.max(Math.max(g.y,u.y),Math.max(d.y,h.y));return new t.Rectangle(p,y,c-p,m-y)},t.BaseDiagram.prototype.ConstrainPanning=function(t,e,n,i,o){var a=this.getPanZoomCanvas(),r=a.getSize().w/2,s=a.getSize().h/2,l=r-(n+t)*o,g=s-(i+e)*o,u=r-t*o,d=s-e*o;if(this.IsLayoutViewport()){var h,p,c=this.GetLayoutViewport();-c.x*o<l?(l-=h=l+c.x*o,u+=h):-c.x*o>u&&(l-=h=-c.x*o-u,u+=h),-c.y*o<g?(g-=p=g+c.y*o,d+=p):-c.y*o>d&&(g-=p=-c.y*o-d,d+=p)}a.setMinPanX(l),a.setMinPanY(g),a.setMaxPanX(u),a.setMaxPanY(d),this.Overview&&this.Overview.updateConstraints(l,g,u,d)},t.BaseDiagram.getContainerPadding=function(t){var e=new Object;return e.top=t.top,e.right=t.right,e.bottom=t.bottom,e.left=t.left,e},t.BaseDiagram.getLayoutContainerPadding=function(t){var e=new Object;return e.top=t.top,e.right=t.right,e.bottom=t.bottom,e.left=t.left,e},t.BaseDiagram.prototype.ApplyLabelPosition=function(e,n,i){var o=e.getLabelBounds();o=t.DiagramLayoutUtils.convertDiagramRectToRect(o);var a=e.getLabelPosition();if(o&&a){var r=new t.Point(a.x-i.x,a.y-i.y),s=e.getLabelRotationAngle(),l=t.DiagramLayoutUtils.convertDiagramPointToPoint(e.getLabelRotationPoint());n.setLabelBounds(o),n.setLabelPosition(r),n.setLabelAlignments(e.getLabelHalign(),e.getLabelValign()),null!=s&&n.setLabelRotationAngle(s),l&&n.setLabelRotationPoint(l)}},t.BaseDiagram.prototype.getLayoutOffset=function(){return this._layoutOffset?this._layoutOffset:new t.Point(0,0)},t.BaseDiagram.prototype.getCustomObjKeyboardBoundingBox=function(e){var n=e.getElem().getBoundingClientRect(),i=this.getPanZoomCanvas().getContentPane().getElem().getBoundingClientRect(),o=this.getPanZoomCanvas().getContentPane().getMatrix();return new t.Rectangle(n.left-i.left+o.getTx(),n.top-i.top+o.getTy(),n.width,n.height)},t.BaseDiagram.compareValues=function(e,n,i){return!n&&!i||t.Obj.compareValues(e,n,i)},t.BaseDiagramKeyboardHandler=function(t,e){this.Init(t,e)},t.Obj.createSubclass(t.BaseDiagramKeyboardHandler,t.PanZoomCanvasKeyboardHandler,"dvt.BaseDiagramKeyboardHandler"),t.BaseDiagramKeyboardHandler._OUTGOING=0,t.BaseDiagramKeyboardHandler._INGOING=1,t.BaseDiagramKeyboardHandler.prototype.Init=function(e,n){t.BaseDiagramKeyboardHandler.superclass.Init.call(this,e,n),this._diagram=e},t.BaseDiagramKeyboardHandler.prototype.GetDiagram=function(){return this._diagram},t.BaseDiagramKeyboardHandler.prototype.isSelectionEvent=function(e){return e.keyCode!=t.KeyboardEvent.TAB&&(this.isNavigationEvent(e)&&!e.ctrlKey)},t.BaseDiagramKeyboardHandler.prototype.isMultiSelectEvent=function(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey},t.BaseDiagramKeyboardHandler.prototype.getFirstNavigableLink=function(e,n,i){var o=n.keyCode;if(!i||i.length<1||!e)return null;for(var a=i[0],r=e.getKeyboardBoundingBox(),s=r.x+r.w/2,l=0;l<i.length;l++){var g=i[l],u=g.getKeyboardBoundingBox(),d=u.x+u.w/2;if(o==t.KeyboardEvent.OPEN_ANGLED_BRACKET&&d<=s||o==t.KeyboardEvent.CLOSE_ANGLED_BRACKET&&d>=s){a=g;break}}return a},t.BaseDiagramKeyboardHandler.prototype.getNextNavigableLink=function(e,n,i,o){if(!o)return null;if(!n)return o[0];if(!e)return n;this._addSortingAttributes(e,o),o.sort(this._getLinkComparator()),this._removeSortingAttributes(o);for(var a=i.keyCode==t.KeyboardEvent.DOWN_ARROW,r=0,s=0;s<o.length;s++){if(o[s]===n){r=a?s==o.length-1?0:s+1:0==s?o.length-1:s-1;break}}return o[r]},t.BaseDiagramKeyboardHandler.prototype.GetVisibleNode=function(t){return null},t.BaseDiagramKeyboardHandler.prototype._getClockwiseAngle=function(t,e){var n=this.GetVisibleNode(e.getStartId?e.getStartId():e.getData().getStartId()),i=this.GetVisibleNode(e.getEndId?e.getEndId():e.getData().getEndId()),o=t==n?i:n,a=this._getNodeCenter(t),r=this._getNodeCenter(o),s=Math.atan2(r.y-a.y,r.x-a.x);return s=s<0?s+2*Math.PI:s},t.BaseDiagramKeyboardHandler.prototype._getNodeCenter=function(e){var n=e.getKeyboardBoundingBox();return new t.Point(n.x+n.w/2,n.y+n.h/2)},t.BaseDiagramKeyboardHandler.prototype._getNodesDistance=function(t){var e=this.GetVisibleNode(t.getStartId?t.getStartId():t.getData().getStartId()),n=this.GetVisibleNode(t.getEndId?t.getEndId():t.getData().getEndId()),i=this._getNodeCenter(e),o=this._getNodeCenter(n);return Math.sqrt(Math.pow(o.x-i.x,2)+Math.pow(o.y-i.y,2))},t.BaseDiagramKeyboardHandler.prototype._getLinkDirection=function(e,n){return e==this.GetVisibleNode(n.getEndId?n.getEndId():n.getData().getEndId())?t.BaseDiagramKeyboardHandler._INGOING:t.BaseDiagramKeyboardHandler._OUTGOING},t.BaseDiagramKeyboardHandler.prototype._getLinkComparator=function(){return function(e,n){var i=e.__angle,o=n.__angle,a=-1;return!t.BaseDiagramKeyboardHandler._anglesAreEqualWithinTolerance(i,o)&&i>o?a=1:t.BaseDiagramKeyboardHandler._anglesAreEqualWithinTolerance(i,o)&&(e.__distance>n.__distance?a=1:n.__distance==e.__distance&&e.__direction>n.__direction?a=1:n.__distance==e.__distance&&e.__direction==n.__direction&&(a=0)),a}},t.BaseDiagramKeyboardHandler.prototype._removeSortingAttributes=function(t){for(var e=0;e<t.length;e++){var n=t[e];n.__angle=void 0,n.__distance=void 0,n.__direction=void 0}},t.BaseDiagramKeyboardHandler.prototype._addSortingAttributes=function(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.__angle=this._getClockwiseAngle(t,i),i.__distance=this._getNodesDistance(i),i.__direction=this._getLinkDirection(t,i)}},t.BaseDiagramKeyboardHandler._anglesAreEqualWithinTolerance=function(t,e){var n=Math.abs(t-e)<=1e-7;return n||(n=Math.abs(2*Math.PI+Math.min(t,e)-Math.max(t,e))<=1e-7),n},t.BaseDiagramNode=function(t,e,n){this.Init(t,e,n)},t.Obj.createSubclass(t.BaseDiagramNode,t.Container,"dvt.BaseDiagramNode"),t.BaseDiagramNode.prototype.Init=function(e,n,i){t.BaseDiagramNode.superclass.Init.call(this,e,null,n),this._diagram=i,this._bDisclosed=!1,this._selected=!1,this._selectable=!0},t.BaseDiagramNode.prototype.GetDiagram=function(){return this._diagram},t.BaseDiagramNode.prototype.getData=function(){return null},t.BaseDiagramNode.prototype.getLayoutBounds=function(t){return this.getContentBounds(t)},t.BaseDiagramNode.prototype.getContentBounds=function(t){return null},t.BaseDiagramNode.prototype.setLabelPosition=function(e){e&&(this._labelPos=e,t.BaseDiagramNode.PositionLabel(this._labelObj,e,this.getLabelBounds(!0),this.getLabelRotationAngle(),this.getLabelRotationPoint()))},t.BaseDiagramNode.prototype.getLabelPosition=function(){return this._labelPos},t.BaseDiagramNode.prototype.getLabelBounds=function(t){return null},t.BaseDiagramNode.prototype.setLabelBounds=function(t){},t.BaseDiagramNode.prototype.getContainerPadding=function(){return null},t.BaseDiagramNode.prototype.setContainerPadding=function(t,e,n,i){},t.BaseDiagramNode.prototype.isDisclosed=function(){return this._bDisclosed},t.BaseDiagramNode.prototype.setDisclosed=function(t){this._bDisclosed=t},t.BaseDiagramNode.prototype.isSelected=function(){return this._selected},t.BaseDiagramNode.prototype.setSelected=function(t){this._selected=t},t.BaseDiagramNode.prototype.setSelectable=function(t){this._selectable=t},t.BaseDiagramNode.prototype.isSelectable=function(){return this.GetDiagram().isSelectionSupported()&&this._selectable},t.BaseDiagramNode.prototype.setLabelRotationAngle=function(e){this._labelRotAngle=e,t.BaseDiagramNode.PositionLabel(this._labelObj,this.getLabelPosition(),this.getLabelBounds(!0),e,this.getLabelRotationPoint())},t.BaseDiagramNode.prototype.getLabelRotationAngle=function(){return this._labelRotAngle},t.BaseDiagramNode.prototype.setLabelRotationPoint=function(e){this._labelRotPoint=e,t.BaseDiagramNode.PositionLabel(this._labelObj,this.getLabelPosition(),this.getLabelBounds(!0),this.getLabelRotationAngle(),e)},t.BaseDiagramNode.prototype.getLabelRotationPoint=function(){return this._labelRotPoint},t.BaseDiagramNode.prototype.GetNodeBounds=function(){var e=this.getLayoutBounds(!0),n=new t.Rectangle(e.x,e.y,e.w,e.h),i=i=this.getLabelPosition(),o=this.getLabelRotationAngle(),a=this.getLabelRotationPoint(),r=this.getLabelBounds(!0);return i&&r&&(null!=o&&(r=t.BaseDiagram.RotateBounds(r,o,a)),n.x=Math.min(e.x,r.x+i.x),n.y=Math.min(e.y,r.y+i.y),n.w=Math.max(e.x+e.w,r.x+i.x+r.w)-n.x,n.h=Math.max(e.y+e.h,r.y+i.y+r.h)-n.y),n},t.BaseDiagramNode.CalcLabelMatrix=function(e,n,i,o){var a=new t.Matrix;return null!=i&&(o&&(a=a.translate(-o.x,-o.y)),a=a.rotate(i),o&&(a=a.translate(o.x,o.y))),e&&(a=a.translate(e.x,e.y)),a},t.BaseDiagramNode.PositionLabel=function(e,n,i,o,a){if(e){var r=t.BaseDiagramNode.CalcLabelMatrix(n,i,o,a);e.setMatrix(r)}},t.BaseDiagramNode.prototype.SetPosition=function(t,e){this.setTranslate(t,e)},t.BaseDiagramNode.prototype.GetPosition=function(){return new t.Point(this.getTranslateX(),this.getTranslateY())},t.BaseDiagramNode.prototype.getNextNavigable=function(t){return null},t.BaseDiagramNode.prototype.getKeyboardBoundingBox=function(e){if(this._customNodeContent)return this._diagram.getCustomObjKeyboardBoundingBox(this);var n=this.getContentBounds(e),i=this.localToStage(new t.Point(n.x,n.y)),o=this.localToStage(new t.Point(n.x+n.w,n.y+n.h));return new t.Rectangle(i.x,i.y,o.x-i.x,o.y-i.y)},t.BaseDiagramNode.prototype.getTargetElem=function(){return this.getElem()},t.BaseDiagramNode.prototype.showKeyboardFocusEffect=function(){},t.BaseDiagramNode.prototype.hideKeyboardFocusEffect=function(){},t.BaseDiagramNode.prototype.isShowingKeyboardFocusEffect=function(){},t.BaseDiagramNode.prototype.getCategories=function(){return null},t.BaseDiagramNode.prototype.addOutLinkId=function(t){this._outLinkIds||(this._outLinkIds=[]),this._outLinkIds.push(t)},t.BaseDiagramNode.prototype.removeOutLinkId=function(t){if(this._outLinkIds){var e=this._outLinkIds.indexOf(t);-1!=e&&this._outLinkIds.splice(e,1)}},t.BaseDiagramNode.prototype.getOutLinkIds=function(){return this._outLinkIds},t.BaseDiagramNode.prototype.addInLinkId=function(t){this._inLinkIds||(this._inLinkIds=[]),this._inLinkIds.push(t)},t.BaseDiagramNode.prototype.removeInLinkId=function(t){if(this._inLinkIds){var e=this._inLinkIds.indexOf(t);-1!=e&&this._inLinkIds.splice(e,1)}},t.BaseDiagramNode.prototype.getInLinkIds=function(){return this._inLinkIds},t.BaseDiagramNode.prototype.setLabelAlignments=function(t,e){},t.BaseDiagramNode.prototype.getGroupId=function(){return null},t.BaseDiagramLink=function(t,e,n){this.Init(t,e,n)},t.Obj.createSubclass(t.BaseDiagramLink,t.Container,"dvt.BaseDiagramLink"),t.BaseDiagramLink.prototype.Init=function(e,n,i){t.BaseDiagramLink.superclass.Init.call(this,e,null,n),this._diagram=i,this._selected=!1,this._selectable=!0},t.BaseDiagramLink.prototype.GetDiagram=function(){return this._diagram},t.BaseDiagramLink.prototype.setEndConnectorType=function(t){},t.BaseDiagramLink.prototype.getEndConnectorType=function(){return null},t.BaseDiagramLink.prototype.setStartConnectorType=function(t){},t.BaseDiagramLink.prototype.setStartConnector=function(t){this._startConnector=t},t.BaseDiagramLink.prototype.getStartConnector=function(){return this._startConnector},t.BaseDiagramLink.prototype.setEndConnector=function(t){this._endConnector=t},t.BaseDiagramLink.prototype.getEndConnector=function(){return this._endConnector},t.BaseDiagramLink.prototype.setShape=function(t){this._shape=t},t.BaseDiagramLink.prototype.getShape=function(){return this._shape},t.BaseDiagramLink.prototype.setLabelRotationAngle=function(e){this._labelRotAngle=e,t.BaseDiagramLink.PositionLabel(this._labelObj,this.getLabelPosition(),this.getLabelBounds(),e,this.getLabelRotationPoint())},t.BaseDiagramLink.prototype.getLabelRotationAngle=function(){return this._labelRotAngle},t.BaseDiagramLink.prototype.setLabelRotationPoint=function(e){this._labelRotPoint=e,t.BaseDiagramLink.PositionLabel(this._labelObj,this.getLabelPosition(),this.getLabelBounds(),this.getLabelRotationAngle(),e)},t.BaseDiagramLink.prototype.getLabelRotationPoint=function(){return this._labelRotPoint},t.BaseDiagramLink.prototype.getLabelPosition=function(){return this._labelPos},t.BaseDiagramLink.prototype.setLabelPosition=function(e){e&&(this._labelPos=e,t.BaseDiagramLink.PositionLabel(this._labelObj,e,this.getLabelBounds(),this.getLabelRotationAngle(),this.getLabelRotationPoint()))},t.BaseDiagramLink.prototype.getLabelBounds=function(){return null},t.BaseDiagramLink.prototype.setLabelBounds=function(t){},t.BaseDiagramLink.prototype.getStartConnectorOffset=function(){return 0},t.BaseDiagramLink.prototype.getEndConnectorOffset=function(){return 0},t.BaseDiagramLink.prototype.setSelectable=function(t){this._selectable=t},t.BaseDiagramLink.prototype.isSelectable=function(){return this.GetDiagram().isSelectionSupported()&&this._selectable},t.BaseDiagramLink.prototype.isSelected=function(){return this._selected},t.BaseDiagramLink.prototype.setSelected=function(t){this._selected=t},t.BaseDiagramLink.prototype.setPromoted=function(t){this._bPromoted=t},t.BaseDiagramLink.prototype.isPromoted=function(){return this._bPromoted},t.BaseDiagramLink.prototype.setLinkWidth=function(t){},t.BaseDiagramLink.prototype.getLinkWidth=function(){return 1},t.BaseDiagramLink.prototype.setLinkStyle=function(t){},t.BaseDiagramLink.prototype.getLinkStyle=function(){return"solid"},t.BaseDiagramLink.prototype.setLinkColor=function(t){},t.BaseDiagramLink.prototype.getLinkColor=function(){return null},t.BaseDiagramLink.prototype.getConnectorTemplate=function(t){return null},t.BaseDiagramLink.prototype.GetAppliedLinkStyle=function(){return this.getLinkStyle()},t.BaseDiagramLink.prototype.GetAppliedLinkWidth=function(){return this.getLinkWidth()},t.BaseDiagramLink.prototype.GetAppliedLinkColor=function(){return this.getLinkColor()},t.BaseDiagramLink.prototype.CreateConnector=function(e,n,i,o){if(n||o){var a;if(!o){var r=this._shape.getStroke();a=new t.Stroke(r.getColor(),r.getAlpha(),r.getWidth())}var s=t.DiagramLinkConnectorUtils.CreateConnectorShape(this.getCtx(),n,o,a,this);return s&&(this._shape.addChild(s),t.DiagramLinkConnectorUtils.TransformConnector(s,n,o,e,i)),s}},t.BaseDiagramLink.prototype.GetLinkBounds=function(){var e=new t.Rectangle(Number.MAX_VALUE,Number.MAX_VALUE,-Number.MAX_VALUE,-Number.MAX_VALUE),n=this.getPoints();if(n)for(var i,o,a,r,s,l=t.DiagramLinkUtils.GetControlPoints(n),g=0;g<l.length;g++)i=l[g],o=Math.max(e.x+e.w,i.x),a=Math.max(e.y+e.h,i.y),r=Math.min(e.x,i.x),s=Math.min(e.y,i.y),e.x=r,e.y=s,e.w=o-r,e.h=a-s;var u=new t.Rectangle(e.x,e.y,e.w,e.h),d=this.getLabelPosition(),h=this.getLabelRotationAngle(),p=this.getLabelRotationPoint(),c=this.getLabelBounds();return d&&c&&(null!=h&&(c=t.BaseDiagram.RotateBounds(c,h,p)),u.x=Math.min(e.x,c.x+d.x),u.y=Math.min(e.y,c.y+d.y),u.w=Math.max(e.x+e.w,c.x+d.x+c.w)-u.x,u.h=Math.max(e.y+e.h,c.y+d.y+c.h)-u.y),u},t.BaseDiagramLink.prototype.setPoints=function(e){this._arPoints=e,t.DiagramLinkUtils.IsPath(e)?(this._pathCmds=e,this._points=t.DiagramLinkUtils.ConvertToPoints(e)):(this._points=e,this._pathCmds=t.DiagramLinkUtils.ConvertToPath(e)),this._shape&&this._shape instanceof t.Path&&(this._shape.setCommandsArray(this._pathCmds),this._endConnector?t.DiagramLinkConnectorUtils.TransformConnector(this._endConnector,this.getEndConnectorType(),this.getConnectorTemplate(t.DiagramLinkConnectorUtils.END_CONNECTOR),this._points,1):this._endConnector=this.CreateConnector(this._points,this.getEndConnectorType(),1,this.getConnectorTemplate(t.DiagramLinkConnectorUtils.END_CONNECTOR)),this._startConnector?t.DiagramLinkConnectorUtils.TransformConnector(this._startConnector,this.getStartConnectorType(),this.getConnectorTemplate(t.DiagramLinkConnectorUtils.START_CONNECTOR),this._points,0):this._startConnector=this.CreateConnector(this._points,this.getStartConnectorType(),0,this.getConnectorTemplate(t.DiagramLinkConnectorUtils.START_CONNECTOR)));var n=null,i=null;this._linkUnderlay&&this._linkUnderlay.getUnderlay()instanceof t.Path&&this._linkUnderlay.getUnderlay().setCommandsArray(this._pathCmds),this._linkUnderlay&&(n=this._linkUnderlay.getUnderlayStart())&&t.DiagramLinkConnectorUtils.TransformConnector(n,this.getStartConnectorType(),this.getConnectorTemplate(t.DiagramLinkConnectorUtils.START_CONNECTOR),this._points,0),this._linkUnderlay&&(i=this._linkUnderlay.getUnderlayEnd())&&t.DiagramLinkConnectorUtils.TransformConnector(i,this.getEndConnectorType(),this.getConnectorTemplate(t.DiagramLinkConnectorUtils.END_CONNECTOR),this._points,1),this._hitDetectionUnderlay&&this._hitDetectionUnderlay.getUnderlay()instanceof t.Path&&this._hitDetectionUnderlay.getUnderlay().setCommandsArray(this._pathCmds),this._startHandle&&this._startHandle.setPosition(this.getLinkStart()),this._endHandle&&this._endHandle.setPosition(this.getLinkEnd())},t.BaseDiagramLink.prototype.getPoints=function(){return this._arPoints},t.BaseDiagramLink.prototype.getLinkStart=function(){if(!this._points)return null;var e=this._points[0],n=this._points[1];return new t.Point(e,n)},t.BaseDiagramLink.prototype.getLinkEnd=function(){if(!this._points)return null;var e=this._points.length,n=this._points[e-2],i=this._points[e-1];return new t.Point(n,i)},t.BaseDiagramLink.CalcLabelMatrix=function(e,n,i,o){var a=new t.Matrix;return null!=i&&(o&&(a=a.translate(-o.x,-o.y)),a=a.rotate(i),o&&(a=a.translate(o.x,o.y))),e&&(a=a.translate(e.x,e.y)),a},t.BaseDiagramLink.PositionLabel=function(e,n,i,o,a){if(e){var r=t.BaseDiagramLink.CalcLabelMatrix(n,i,o,a);e.setMatrix(r)}},t.BaseDiagramLink.prototype.CreateUnderlay=function(e,n,i,o,a){n||0==n||(n=1),i||0==i||(i=0);var s=this.GetAppliedLinkWidth()+i,l=new t.Stroke(e,n,s,!0);return new r(this.getCtx(),this._pathCmds,l,o,a)},t.BaseDiagramLink.prototype.CreateFeedbackUnderlay=function(e,n,i,o,a){var r=this.CreateUnderlay(e,n,i,o,a);return this._startConnector&&this.getStartConnectorType()&&r.addUnderlayStart(this._points,this.getStartConnectorType(),this.getConnectorTemplate(t.DiagramLinkConnectorUtils.START_CONNECTOR),this),this._endConnector&&this.getEndConnectorType()&&r.addUnderlayEnd(this._points,this.getEndConnectorType(),this.getConnectorTemplate(t.DiagramLinkConnectorUtils.END_CONNECTOR),this),r},t.BaseDiagramLink.prototype.GetStyledLinkStroke=function(e,n,i){var o,a=this.GetAppliedLinkStyle();return"solid"!==strokeType&&(o={dashArray:t.DiagramLinkUtils.GetStrokeDash(a,!0),dashOffset:t.DiagramLinkUtils.GetStrokeDashOffset(a,!0)}),new t.Stroke(n,e.getAlpha(),i,!0,o)},t.BaseDiagramLink.prototype.ReplaceConnectorColor=function(e,n){if(e){var i=null;if(n.getColor&&(i=n.getColor()),i){var o=e.getStroke(),a=e.getFill();o&&e.setStroke(new t.Stroke(i,o.getAlpha(),o.getWidth(),o.isFixedWidth(),o.getDashProps())),a&&e.setFill(a)}}},t.BaseDiagramLink.prototype.getNextNavigable=function(t){return null},t.BaseDiagramLink.prototype.getKeyboardBoundingBox=function(t){return this.getGroupId()&&this._diagram.getOptions().renderer?this._diagram.getCustomObjKeyboardBoundingBox(this):this.getDimensions(t)},t.BaseDiagramLink.prototype.getTargetElem=function(){return this.getElem()},t.BaseDiagramLink.prototype.showKeyboardFocusEffect=function(){},t.BaseDiagramLink.prototype.hideKeyboardFocusEffect=function(){},t.BaseDiagramLink.prototype.isShowingKeyboardFocusEffect=function(){},t.BaseDiagramLink.prototype.setKeyboardFocusNode=function(t){this._keyboardNavNode=t},t.BaseDiagramLink.prototype.getKeyboardFocusNode=function(){return this._keyboardNavNode},t.BaseDiagramLink.prototype.getCategories=function(){return null},t.BaseDiagramLink.prototype.setLabelAlignments=function(t,e){},t.BaseDiagramLink.prototype.getGroupId=function(){return null},t.DiagramLayoutUtils={},t.Obj.createSubclass(t.DiagramLayoutUtils,t.Obj,"dvt.DiagramLayoutUtils"),t.DiagramLayoutUtils.convertRectToDiagramRect=function(e){return void 0===e||null==e?null:new t.DiagramRectangle(e.x,e.y,e.w,e.h)},t.DiagramLayoutUtils.convertPointToDiagramPoint=function(e){return void 0===e||null==e?null:new t.DiagramPoint(e.x,e.y)},t.DiagramLayoutUtils.convertDiagramRectToRect=function(e){return e?new t.Rectangle(e.x,e.y,e.w,e.h):null},t.DiagramLayoutUtils.convertDiagramPointToPoint=function(e){return e?new t.Point(e.x,e.y):null};var r=function(t,e,n,i,o){r.superclass.Init.call(this,t),this.Init(t,e,n,i,o)};t.Obj.createSubclass(r,t.Container,"DvtDiagramLinkUnderlay"),r.prototype.Init=function(e,n,i,o,a){n||(n=["M",0,0,"L",1,0]),this._stroke=i,this._stroke||(this._stroke=new t.Stroke("#ffffff",1,1,!0)),this._underlay=new t.Path(e,n),this._underlay.setStroke(this._stroke),this._underlay.setFill(null),this._underlay.setStyle(o).setClassName(a),this.addChild(this._underlay),this._underlayStart=null,this._underlayStartType=null,this._underlayEnd=null,this._underlayEndType=null},r.prototype.addUnderlayStart=function(t,e,n,i){var o=this.CreateConnectorUnderlay(t,e,n,i,0);this._underlayStart&&this.removeChild(this._underlayStart),this._underlayStart=o,this._underlayStartType=e,this.addChild(this._underlayStart)},r.prototype.addUnderlayEnd=function(t,e,n,i){var o=this.CreateConnectorUnderlay(t,e,n,i,1);this._underlayEnd&&this.removeChild(this._underlayEnd),this._underlayEnd=o,this._underlayEndType=e,this.addChild(this._underlayEnd)},r.prototype.CreateConnectorUnderlay=function(e,n,i,o,a){var r=new t.Stroke(this._stroke.getColor(),this._stroke.getAlpha(),this._stroke.getWidth(),!1,this._stroke.getDashProps()),s=t.DiagramLinkConnectorUtils.CreateConnectorShape(this.getCtx(),n,i,r,o);return t.DiagramLinkConnectorUtils.TransformConnector(s,n,i,e,a),s},r.prototype.getUnderlay=function(){return this._underlay},r.prototype.getUnderlayStart=function(){return this._underlayStart},r.prototype.getUnderlayEnd=function(){return this._underlayEnd},r.prototype.setStroke=function(e,n){var i,o;(this._stroke=e,this._underlay.setStroke(e),this._underlayStart)&&(this._underlayStartType==t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW||this._underlayStartType==t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_CONCAVE?(i=new t.Stroke(e.getColor(),e.getAlpha(),n),this._underlayStart.setSolidFill(e.getColor())):i=new t.Stroke(e.getColor(),e.getAlpha(),e.getWidth()),this._underlayStart.setStroke(i));this._underlayEnd&&(this._underlayEndType==t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW||this._underlayEndType==t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_CONCAVE?(o=new t.Stroke(e.getColor(),e.getAlpha(),n),this._underlayEnd.setSolidFill(e.getColor())):o=new t.Stroke(e.getColor(),e.getAlpha(),e.getWidth()),this._underlayEnd.setStroke(o))},r.prototype.getStroke=function(){return this._stroke},r.prototype.hideUnderlayStart=function(){this._underlayStart&&this.removeChild(this._underlayStart)},r.prototype.hideUnderlayEnd=function(){this._underlayEnd&&this.removeChild(this._underlayEnd)},r.prototype.showUnderlayStart=function(){this._underlayStart&&this.addChild(this._underlayStart)},r.prototype.showUnderlayEnd=function(){this._underlayEnd&&this.addChild(this._underlayEnd)},t.DiagramLinkUtils={},t.Obj.createSubclass(t.DiagramLinkUtils,t.Obj,"dvt.DiagramLinkUtils"),t.DiagramLinkUtils.GetStrokeDash=function(t,e){return"solid"==t?null:"dash"===t?e?"8,2":"6,4":"dot"===t?e?"4,1":"2,3":"dashDot"===t?e?"10,1,4,1":"8,3,2,3":void 0},t.DiagramLinkUtils.GetStrokeDashOffset=function(t,e){return e&&"solid"!=t?1:null},t.DiagramLinkUtils.getStrokeObject=function(e,n){return{_type:e,strokeDasharray:t.DiagramLinkUtils.GetStrokeDash(e,n),strokeDashoffset:t.DiagramLinkUtils.GetStrokeDashOffset(e,n)}},t.DiagramLinkUtils.processStrokeDashArray=function(t){if(t){var e=t.split(/[\s,]+/);return e.length%2>0&&(e=e.concat(e)),e.toString()}return t},t.DiagramLinkUtils.getCustomUnderlay=function(e){if(e){for(var n=e.split(/[\s,]+/),i="",o=0;o<n.length;o++){var a=t.CSSStyle.toNumber(n[o].trim());i+=o%2==0?a+2:a>=2?a-2:0,o<n.length-1&&(i+=", ")}return i}return null},t.DiagramLinkUtils.ConvertToPath=function(t){var e=[];if(t)for(var n=0;n<t.length;n+=2)0==n?e.push("M"):e.push("L"),e.push(t[n]),e.push(t[n+1]);return e},t.DiagramLinkUtils.ConvertToPoints=function(t){var e=[];if(t)for(var n=0;n<t.length;n++)isNaN(t[n])||e.push(t[n]);return e},t.DiagramLinkUtils.IsPath=function(t){return!!(t&&t.length>0)&&isNaN(t[0])},t.DiagramLinkUtils.GetControlPoints=function(e){var n,i=[];n=t.DiagramLinkUtils.IsPath(e)?t.DiagramLinkUtils.ConvertToPoints(e):e;for(var o=0;o<n.length;o+=2)i.push(new t.Point(n[o],n[o+1]));return i},t.DiagramLinkConnectorUtils={},t.Obj.createSubclass(t.DiagramLinkConnectorUtils,t.Obj,"dvt.DiagramLinkConnectorUtils"),t.DiagramLinkConnectorUtils.END_CONNECTOR="endConnector",t.DiagramLinkConnectorUtils.START_CONNECTOR="startConnector",t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_OPEN="arrowOpen",t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW="arrow",t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_CONCAVE="arrowConcave",t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_RECTANGLE="rectangle",t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_RECTANGLE_ROUNDED="rectangleRounded",t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_CIRCLE="circle",t.DiagramLinkConnectorUtils.CreateConnectorShape=function(e,n,i,o,a){if(i)return t.DiagramLinkConnectorUtils.CreateCustomConnector(e,i,a);var r=a.GetAppliedLinkWidth();switch(n){case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW:return t.DiagramLinkConnectorUtils.CreateFilledArrowConnector(e,r,a.getLinkColor());case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_CONCAVE:return t.DiagramLinkConnectorUtils.CreateFilledConcaveArrowConnector(e,r,a.getLinkColor());case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_OPEN:return t.DiagramLinkConnectorUtils.CreateOpenArrowConnector(e,r,o);case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_CIRCLE:return t.DiagramLinkConnectorUtils.CreateCircleConnector(e,r,o);case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_RECTANGLE:return t.DiagramLinkConnectorUtils.CreateRectangleConnector(e,r,o);case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_RECTANGLE_ROUNDED:return t.DiagramLinkConnectorUtils.CreateRoundedRectangleConnector(e,r,o)}return null},t.DiagramLinkConnectorUtils.TransformConnector=function(e,n,i,o,a){var r=t.DiagramLinkConnectorUtils.CalcConnectorTransform(e,n,i,o,a);e.setMatrix(r)},t.DiagramLinkConnectorUtils.CalcConnectorTransform=function(e,n,i,o,a){var r=-1,s=0,l=0,g=0;if(o){var u=o.length;1===a?(u>=2&&(l=o[u-2],g=o[u-1]),u>=4?(r=o[u-4],s=o[u-3]):(r=l-1e-4,s=g)):(u>=2&&(l=o[0],g=o[1]),u>=4?(r=o[2],s=o[3]):(r=l+1e-4,s=g))}else;var d=l,h=g,p=t.DiagramLinkConnectorUtils.CalcConnectorRotation(r,s,l,g),c=e._connectorOrigMat;c||(c=e.getMatrix(),e._connectorOrigMat=c);var y=new t.Matrix;if(i){var m=t.DiagramLinkConnectorUtils._getCachedDims(e),C=e.getScaleX(),f=e.getScaleY(),_=m.w*C*-.5,D=m.h*f*-.5;y=y.translate(_,D)}return(y=(y=y.rotate(p)).translate(d,h)).concat(c)},t.DiagramLinkConnectorUtils._getCachedDims=function(t){var e=t._cachedDims;return e||(e=t.getDimensions(),t._cachedDims=e),e},t.DiagramLinkConnectorUtils.CalcConnectorRotation=function(t,e,n,i){var o=i-e,a=n-t;return Math.atan2(o,a)},t.DiagramLinkConnectorUtils.CreateFilledConcaveArrowConnector=function(e,n,i){var o=6*t.DiagramLinkConnectorUtils._getReduce(n,.5),a=.8*o,r=[-.22*o,-.5*a,.78*o,0,-.22*o,.5*a,0,0],s=new t.Polygon(e,r);return s.setSolidFill(i),s},t.DiagramLinkConnectorUtils.CreateFilledArrowConnector=function(e,n,i){var o=5*t.DiagramLinkConnectorUtils._getReduce(n,.5),a=.8*o,r=[0,-.5*a,o,0,0,.5*a],s=new t.Polygon(e,r);return s.setSolidFill(i),s},t.DiagramLinkConnectorUtils._getReduce=function(t,e){if(t<=1)return t;var n=t-1;return 1+(n*=e)},t.DiagramLinkConnectorUtils.CreateOpenArrowConnector=function(e,n,i){var o=3*n,a=i.getWidth(),r=[-o+a*Math.sqrt(2)/2,-o,a*Math.sqrt(2)/2,0,-o+a*Math.sqrt(2)/2,o],s=new t.Polyline(e,r);return s.setStroke(i),s.setFill(null),s},t.DiagramLinkConnectorUtils.getCircleRadius=function(t){return 2*t},t.DiagramLinkConnectorUtils.getRectangleLength=function(t){return 3*t},t.DiagramLinkConnectorUtils.CreateCircleConnector=function(e,n,i){var o=t.DiagramLinkConnectorUtils.getCircleRadius(n),a=new t.Circle(e,o,0,o);return a.setStroke(i),a.setFill(null),a},t.DiagramLinkConnectorUtils.CreateRectangleConnector=function(e,n,i){var o=t.DiagramLinkConnectorUtils.getRectangleLength(n),a=new t.Rect(e,0,-o/2,o,o);return a.setStroke(i),a.setFill(null),a},t.DiagramLinkConnectorUtils.CreateRoundedRectangleConnector=function(e,n,i){var o=t.DiagramLinkConnectorUtils.CreateRectangleConnector(e,n,i);return o.setCornerRadius(n),o},t.DiagramLinkConnectorUtils.CreateCustomConnector=function(e,n,i){var o=i.GetDiagram().createAfContext();return o.setELContext(i.getData().getElAttributes()),o.setContextCallback(i,i.eventContextCallback),o.setTabStopsArray(i.getTabStopsArray()),t.AfComponentFactory.parseAndLayout(o,n,i)},t.DiagramLinkConnectorUtils.GetConnectorOffset=function(e,n,i,o,a){if(i){var r=t.DiagramLinkConnectorUtils._getCachedDims(e),s=e.getScaleX();return r.w*s*.5}return t.DiagramLinkConnectorUtils.getStandardConnectorOffset(n,a.GetAppliedLinkWidth(),o.getWidth())},t.DiagramLinkConnectorUtils.getStandardConnectorOffset=function(e,n,i){switch(e){case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_OPEN:return i*Math.sqrt(2);case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW:return 5*t.DiagramLinkConnectorUtils._getReduce(n,.5);case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_ARROW_CONCAVE:return.78*(6*t.DiagramLinkConnectorUtils._getReduce(n,.5));case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_CIRCLE:return 2*t.DiagramLinkConnectorUtils.getCircleRadius(i)+i/2;case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_RECTANGLE:case t.DiagramLinkConnectorUtils.CONNECTOR_TYPE_RECTANGLE_ROUNDED:return t.DiagramLinkConnectorUtils.getRectangleLength(i)+i/2;default:return 0}}}(dvt);
!function(t){var e=new Object;t.Obj.createSubclass(e,t.Obj),e.prepareNodeStyle=function(e,i){!e||null==e[i]||e[i]instanceof Object||(e[i]=t.CSSStyle.cssStringToObject(e[i]))},e.prepareLinkStyle=function(e,i){e&&null!=e[i]&&(e[i]instanceof Object?null==e[i]._type&&(e[i]._type=g.CUSTOM_STYLE):e[i]=t.DiagramLinkUtils.getStrokeObject(e[i]))},e.getNodeDefaultStyles=function(t){var i=t.getOptions().styleDefaults.nodeDefaults;return e.prepareNodeStyle(i,"backgroundStyle"),e.prepareNodeStyle(i,"containerStyle"),i},e.getNodeStyles=function(i,o,n){if(i.isDataProviderMode())return t.JsonUtils.merge(o,n,{_itemData:!0,id:!0,nodes:!0});var a=p.ConvertNodeData(o);if(i.getOptions().nodeProperties){var s=t.JsonUtils.clone(i.getOptions().nodeProperties(o));e.prepareNodeStyle(s,"backgroundStyle"),e.prepareNodeStyle(s,"containerStyle"),a=t.JsonUtils.merge(a,s,{_itemData:!0})}return t.JsonUtils.merge(a,n,{_itemData:!0})},e.getLinkDefaultStyles=function(i,o){var n=i.getOptions().styleDefaults[o];e.prepareLinkStyle(n,"style");var a=i.getCtx().isCustomElement()?"svgStyle":"style";return n[a]=t.JsonUtils.merge(n[a],n._style),i.getCtx().isCustomElement()&&["_type"].forEach(function(t){delete n[a][t]}),n},e.getLinkStyles=function(i,o,n){if(i.isDataProviderMode())return t.JsonUtils.merge(o,n,{_itemData:!0,id:!0});var a=g.ConvertLinkData(o);if(i.getOptions().linkProperties){var s=t.JsonUtils.clone(i.getOptions().linkProperties(o));e.prepareLinkStyle(s,"style"),a=t.JsonUtils.merge(a,s,{_itemData:!0})}return t.JsonUtils.merge(a,n,{_itemData:!0})},e.getAnimationDuration=function(e){return t.CSSStyle.getTimeMilliseconds(e.getOptions().styleDefaults.animationDuration)/1e3},e.getAnimationOnDisplay=function(t){return t.getOptions().animationOnDisplay},e.getAnimationOnDataChange=function(t){return t.getOptions().animationOnDataChange};var i=new Object;t.Obj.createSubclass(i,t.Obj),i.GetCollapsedContainers=function(t,e){for(var i=[];e.length>0;){var o=e.shift();if(o.nodes)o.nodes.forEach(function(t){e.push(t)});else{var n=t.getChildDataProvider(o.id);!n||"yes"===n.isEmpty()||"disjoint"===o.descendantsConnectivity||i.push(o)}}return i},i.GetNodeOption=function(e,i){for(var o=[i.getId()];i&&i.getGroupId();){var n=i.getGroupId();o.push(n),i=e.getNodeById(n)}for(var a=o.pop(),s=[e.getOptions()],r=e.getCtx();a&&s[0].nodes;)s=s[0].nodes.filter(function(e){return t.BaseDiagram.compareValues(r,e.id,a)}),a=o.pop();return s[0]};var o={};t.Obj.createSubclass(o,t.Obj,"DvtDiagramOverviewUtils"),o.CalcViewportFromMatrix=function(e){var i=e.getPanZoomCanvas().getContentPaneMatrix(),o=new t.Rectangle(0,0,e.getWidth(),e.getHeight()),n=i.getTx(),a=i.getTy(),s=i.getA(),r=o.x-n/s,d=o.y-a/s,h=o.w/s,l=o.h/s;return new t.Rectangle(r,d,h,l)},o.CreateOverviewWindow=function(e){var i=new t.Container(e.getCtx()),a=new n(e);i.addChild(a),e.addChild(i),a.render(),o._positionOverviewWindow(e,a);var s=a.getOverviewWidth(),r=a.getOverviewHeight(),d=new t.ClipPath(e.getId()+"dgr_ovClip");d.addRect(a.getTranslateX()-1,a.getTranslateY()-1,s+2,r+2),a.setClipPath(d),a.UpdateViewport();var h=e.Options.styleDefaults._overviewStyles,l=new t.Rect(e.getCtx(),0,0,s,r);return l.setInvisibleFill(),l.setStroke(new t.Stroke(h.overview.backgroundColor,1,1)),l.setMouseEnabled(!1),i.addChild(l),a},o.CreateOverviewContent=function(e,i,n,a){var s=new t.Container(e.getCtx());s.setMouseEnabled(!1),i.Nodes=new(e.getCtx().ojMap);var r=e.GetRootNodeObjects();return r.length>0&&(r.forEach(function(t){o.CreateOverviewNode(e,i,t,s)}),o.ZoomToFitOverviewContent(e,i,s,n,a)),s},o.CreateOverviewNode=function(e,i,n,a){if(n){var s=o._createOverviewNodeShape(e,n);if(o._positionOverviewNode(n,s),i.Nodes.set(n.getId(),s),a.addChild(s),n.isDisclosed()){s._ovChildNodePane=new t.Container(e.getCtx()),s.addChild(s._ovChildNodePane);var r=n.getContainerPadding();s._ovChildNodePane.setTranslate(r.left,r.top),n.getChildNodeIds().forEach(function(t){var n=e.getNodeById(t);o.CreateOverviewNode(e,i,n,s._ovChildNodePane)})}}},o.RemoveOverviewWindow=function(t,e){if(e){e.setClipPath(null);var i=e.getParent();t.removeChild(i)}},o.UpdateOverviewWindow=function(e,i){o._positionOverviewWindow(e,i),o._updateOverviewNodes(e,i),i.Nodes.size>0&&o.ZoomToFitOverviewContent(e,i,i.Content,i.Width,i.Height),i.UpdateViewport();var n=i.getOverviewWidth(),a=i.getOverviewHeight();i.setClipPath(null);var s=new t.ClipPath(e.getId()+"dgr_ovClip");s.addRect(i.getTranslateX()-1,i.getTranslateY()-1,n+2,a+2),i.setClipPath(s);var r=i.getParent().getChildIndex(1);r instanceof t.Rect&&(r.setWidth(n),r.setHeight(a))},o.UpdateOverviewContent=function(t,e,i,n){var a=n.data.nodes;if(a&&0!==a.length){var s=n.parentId,r=s?t.getNodeById(s):null,d=[];if("add"==i)if(r){var h=o._findRootNode(t,r);o._removeNode(t,e,h.getId()),d.push(h)}else a.forEach(function(e){d.push(t.getNodeById(e.id))});else if("change"==i){var l=new(t.getCtx().ojMap);a.forEach(function(e){var i=o._findRootNode(t,t.getNodeById(e.id));i&&l.set(i.getId(),i)}),l.forEach(function(i,n,a){o._removeNode(t,e,n),d.push(i)})}else if("remove"==i)if(r){h=o._findRootNode(t,r);o._removeNode(t,e,h.getId()),d.push(h)}else a.forEach(function(i){o._removeNode(t,e,i.id)});d.forEach(function(i){o.CreateOverviewNode(t,e,i,e.Content)})}},o.TransformFromContentToViewportCoords=function(e,i,o){var n=o.getTranslateX(),a=o.getTranslateY(),s=e*o.getScaleX()+n,r=i*o.getScaleY()+a;return new t.Point(s,r)},o.TransformFromViewportToContentCoords=function(e,i,o){var n=o.getTranslateX(),a=o.getTranslateY(),s=(e-n)/o.getScaleX(),r=(i-a)/o.getScaleY();return new t.Point(s,r)},o.ZoomToFitOverviewContent=function(t,e,i,n,a){t=e.Diagram;var s=e.Diagram._cachedViewBounds,r=s||t.GetViewBounds(),d=o._calcOverviewScale(t,r,n,a);i.setScale(d,d);var h=(n-r.w*d)/2-r.x*d,l=(a-r.h*d)/2-r.y*d;i.setTranslate(h,l)},o._calcOverviewScale=function(t,e,i,o){var n=o-20,a=(i-20)/e.w,s=n/e.h;return Math.min(a,s)},o._createOverviewNodeShape=function(e,i){var o=e.Options.styleDefaults._overviewStyles.node;i.getData().overview&&(o=t.JsonUtils.merge(i.getData().overview.icon,o));var n=o.shape;i.isDisclosed()||e.Options.renderer&&"inherit"==n?n="rectangle":"inherit"==n&&(n=i.getData().icon.shape);var a=i.getLayoutBounds(),s=a.w,r=a.h,d=new t.SimpleMarker(e.getCtx(),n,s/2,r/2,s,r,0),h=i.isDisclosed()?"oj-diagram-overview-container-node":"oj-diagram-overview-node";return o.svgClassName&&(h+=" "+o.svgClassName),d.setStyle(o.svgStyle).setClassName(h),d},o._findRootNode=function(t,e){for(var i=e,o=e?e.getGroupId():null;o;)o=(i=t.getNodeById(o)?t.getNodeById(o):i).getGroupId();return i},o._positionOverviewNode=function(t,e){var i=t.getTranslateX(),o=t.getTranslateY();e.setTranslate(i,o)},o._positionOverviewWindow=function(e,i){var o=e.Options.overview.halign,n=e.Options.overview.valign,a=t.CSSStyle.toNumber(e.Options.styleDefaults._overviewStyles.overview.padding),s=i.getOverviewWidth(),r=i.getOverviewHeight(),d=e.Width,h=e.Height;switch(o){case"start":o=t.Agent.isRightToLeft(e.getCtx())?"right":"left";break;case"end":o=t.Agent.isRightToLeft(e.getCtx())?"left":"right"}var l="center"==o?(d-s)/2:"right"==o?d-s-a:a,g="middle"==n?(h-r)/2:"bottom"==n?h-r-a:a;i.getParent().setTranslate(l,g)},o._removeNode=function(t,e,i){var o=e.Nodes.get(i);o&&o.getParent().removeChild(o)},o._updateOverviewNodes=function(t,e){e.Nodes.forEach(function(i,n,a){var s=t.getNodeById(n);s&&i?o._positionOverviewNode(s,i):i&&!s&&e.Nodes.delete(n)})};var n=function(t){this.Init(t.getCtx(),t.processEvent,t),this.Diagram=t,this._id=t.getId()+"_overview"};t.Obj.createSubclass(n,t.Overview),n.prototype.renderData=function(t,e){this.Content=o.CreateOverviewContent(this.Diagram,this,t,e),this.addChild(this.Content),this.Content.setMouseEnabled(!1)},n.prototype.render=function(){var t=Math.min(this.Diagram.Width,this.Diagram.Options.overview.width),e=Math.min(this.Diagram.Height,this.Diagram.Options.overview.height),i=this.Diagram.Options.styleDefaults._overviewStyles,o={xMin:0,xMax:t,yMin:0,yMax:e,x1:0,x2:t,y1:0,y2:e,style:{overviewBackgroundColor:i.overview.backgroundColor,windowBackgroundColor:i.viewport.backgroundColor,windowBorderTopColor:i.viewport.borderColor,windowBorderRightColor:i.viewport.borderColor,windowBorderBottomColor:i.viewport.borderColor,windowBorderLeftColor:i.viewport.borderColor,timeAxisBarColor:"#00000000"},animationOnClick:"off",featuresOff:"zoom"},a=0===this.Diagram.GetAllRoots().length;this._viewportConstraints={xMin:a?0:-Number.MAX_VALUE,yMin:a?0:-Number.MAX_VALUE,xMax:a?t:Number.MAX_VALUE,yMax:a?e:Number.MAX_VALUE},this.Diagram.IsPanningEnabled()||this.setMouseEnabled(!1),n.superclass.render.call(this,o,t,e)},n.prototype.animateUpdate=function(e,i){this.Content.setAlpha(0),e.add(new t.AnimFadeIn(this.getCtx(),this.Content,e.getAnimationDuration()),d.UPDATE);var o=this.getChildIndex(this.Content);this.addChildAt(i.Content,o+1);var n=new t.AnimFadeOut(this.getCtx(),i.Content,e.getAnimationDuration());t.Playable.appendOnEnd(n,function(){i.Content.getParent().removeChild(i.Content)}),e.add(n,d.UPDATE);var a=new t.CustomAnimation(this.getCtx(),null,e.getAnimationDuration()),s=i.GetAnimationParams(),r=this.GetAnimationParams();this.SetAnimationParams(s),a.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,this,this.GetAnimationParams,this.SetAnimationParams,r),e.add(a,d.UPDATE)},n.prototype.updateConstraints=function(t,e,i,n){var a=this.Diagram.getPanZoomCanvas().getZoom(),s=o.TransformFromContentToViewportCoords(-i/a,-n/a,this.Content),r=o.TransformFromContentToViewportCoords(-t/a,-e/a,this.Content),d=this._viewportPosition.x2-this._viewportPosition.x1,h=this._viewportPosition.y2-this._viewportPosition.y1,l=this.Diagram.getPanDirection();this._viewportConstraints={xMin:"y"===l?this._viewportPosition.x1:s.x,xMax:"y"===l?this._viewportPosition.x2:r.x+d,yMin:"x"===l?this._viewportPosition.y1:s.y,yMax:"x"===l?this._viewportPosition.y2:r.y+h}},n.prototype.getMinimumPositionX=function(){return this._viewportConstraints.xMin},n.prototype.getMinimumPositionY=function(){return this._viewportConstraints.yMin},n.prototype.getMaximumPositionX=function(){return this._viewportConstraints.xMax},n.prototype.getMaximumPositionY=function(){return this._viewportConstraints.yMax},n.prototype.getMinimumWindowWidth=function(){return 0},n.prototype.getMaximumWindowWidth=function(){return Number.MAX_VALUE},n.prototype.getMinimumWindowHeight=function(){return 0},n.prototype.getMaximumWindowHeight=function(){return Number.MAX_VALUE},n.prototype.UpdateViewport=function(){if(!this._bCancelUpdateViewport){var t=o.CalcViewportFromMatrix(this.Diagram),e=o.TransformFromContentToViewportCoords(t.x,t.y,this.Content),i=o.TransformFromContentToViewportCoords(t.x+t.w,t.y+t.h,this.Content);this._viewportPosition={x1:e.x,x2:i.x,y1:e.y,y2:i.y},this.setViewportRange(e.x,i.x,e.y,i.y)}},n.prototype.HandleViewportChange=function(t){var e=void 0!==t.newX1?t.newX1:this._viewportPosition.x1,i=void 0!==t.newY1?t.newY1:this._viewportPosition.y1,n=o.TransformFromViewportToContentCoords(this._viewportPosition.x1,this._viewportPosition.y1,this.Content),a=o.TransformFromViewportToContentCoords(e,i,this.Content);this._viewportPosition.x1=e,this._viewportPosition.y1=i;var s=this.Diagram.getPanZoomCanvas().getZoom(),r=(a.x-n.x)*s,d=(a.y-n.y)*s;0===r&&0===d||(this._bCancelUpdateViewport=!0,this.Diagram.getPanZoomCanvas().panBy(-r,-d),this._bCancelUpdateViewport=!1)},n.prototype.GetAnimationParams=function(){var t=[],e=this.getSlidingWindow(),i=this.getLeftHandle(),o=this.getRightHandle(),n=this.getBottomBar(),a=this.getTopBar();return t.push(e.getTranslateX()),t.push(e.getTranslateY()),t.push(e.getWidth()),t.push(e.getHeight()),t.push(i.getX1()),t.push(i.getY1()),t.push(i.getX2()),t.push(i.getY2()),t.push(o.getX1()),t.push(o.getY1()),t.push(o.getX2()),t.push(o.getY2()),t.push(n.getX1()),t.push(n.getY1()),t.push(n.getX2()),t.push(n.getY2()),t.push(a.getX1()),t.push(a.getY1()),t.push(a.getX2()),t.push(a.getY2()),t},n.prototype.SetAnimationParams=function(t){var e=this.getSlidingWindow(),i=this.getLeftHandle(),o=this.getRightHandle(),n=this.getBottomBar(),a=this.getTopBar(),s=0;e.setTranslateX(t[s++]),e.setTranslateY(t[s++]),e.setWidth(t[s++]),e.setHeight(t[s++]),i.setX1(t[s++]),i.setY1(t[s++]),i.setX2(t[s++]),i.setY2(t[s++]),o.setX1(t[s++]),o.setY1(t[s++]),o.setX2(t[s++]),o.setY2(t[s++]),n.setX1(t[s++]),n.setY1(t[s++]),n.setX2(t[s++]),n.setY2(t[s++]),a.setX1(t[s++]),a.setY1(t[s++]),a.setX2(t[s++]),a.setY2(t[s++])},n.prototype.CreateAnimationClone=function(){var e=this.getCtx(),i=new t.Container(e,this.getId());i.setMouseEnabled(!1);var n=new t.Container(e,"ovContentClone");i.addChild(n),i.Content=n,i.Nodes=new e.ojMap,i.Diagram=this.Diagram;var a=this.Diagram.GetRootNodeObjects();a.length>0&&(a.forEach(function(t){o.CreateOverviewNode(i.Diagram,i,t,n)}),o.ZoomToFitOverviewContent(i.Diagram,i,n,this.Width,this.Height));var s=this.GetAnimationParams();return i.GetAnimationParams=function(){return s},i},t.Diagram=function(t,e,i){this.Init(t,e,i)},t.Obj.createSubclass(t.Diagram,t.BaseDiagram),t.Diagram.prototype.Init=function(e,i,o){t.Diagram.superclass.Init.call(this,e,i,o),this.Defaults=new s(e),this.EventManager=new h(e,this.processEvent,this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(new l(this,this.EventManager)),this._nodes=new e.ojMap,this._arNodeIds=[],this._arRootIds=[],this._links=new e.ojMap,this._arLinkIds=[],this._renderCount=0,this._deferredObjCount=0,this._allNodeIdsMap=new e.ojMap,this._unresolvedNodeIds=[],this._nodesToResolve=[],this.setId("diagram")},t.Diagram.newInstance=function(e,i,o){return new t.Diagram(e,i,o)},t.Diagram.prototype.PreRender=function(){!this.IsResize()&&this._bRendered&&("none"!=e.getAnimationOnDataChange(this)&&(this._oldDataAnimState=new r(this)),this._currentViewport=this.getPanZoomCanvas().getViewport(),this._bRendered=!1,this._oldPanZoomCanvas=this.getPanZoomCanvas(),this._setDataSourceListeners(this.getOptions().data,!1)),this.IsResize()?this._layoutContext&&(this._layoutContext.setEventData(null),this._layoutContext.setComponentSize(new t.DiagramRectangle(0,0,this.getWidth(),this.getHeight())),this._layoutContext.setCurrentViewport(null)):(this.ResetNodesAndLinks(),this._oldLayoutContext=this._layoutContext,this._layoutContext=null)},t.Diagram.prototype.ResetNodesAndLinks=function(){var e=this.getCtx();this.setLinksPane(new t.Container(e)),this.setNodesPane(new t.Container(e)),this.setTopPane(new t.Container(e)),this._nodes=new e.ojMap,this._arNodeIds=[],this._arRootIds=[],this._links=new e.ojMap,this._arLinkIds=[],this._highlightedObjects=null,this._promotedLinksMap=null,this._linkToPromotedMap=null,this._collapsedNodes=null,this.isDataProviderMode()||(this.getOptions().nodes=[],this.getOptions().links=[]),this._allNodeIdsMap=new e.ojMap,this._unresolvedNodeIds=[],o.RemoveOverviewWindow(this,this.Overview),this.Overview=null},t.Diagram.prototype._onAnimationEnd=function(){this._deleteContainer&&(this.removeChild(this._deleteContainer),this._deleteContainer.destroy()),this._deleteContainer=null,this.Animation&&this.getEventManager().addListeners(this),this.AnimationStopped||this.RenderComplete(),this.Animation=null,this.AnimationStopped=!1,this._bRendered&&(this._oldDataAnimState=null)},t.Diagram.prototype.animateUpdate=function(e,i){var o=new t.CustomAnimation(this.getCtx(),null,e.getAnimationDuration()),n=i.PanZoomMatrix,a=this.getPanZoomCanvas().getContentPane().getMatrix();n.equals(a)||(this.getPanZoomCanvas().getContentPane().setMatrix(n),o.getAnimator().addProp(t.Animator.TYPE_MATRIX,this.getPanZoomCanvas().getContentPane(),this.getPanZoomCanvas().getContentPane().getMatrix,this.getPanZoomCanvas().getContentPane().setMatrix,a));var s=i.IsPartialUpdate?i.getNewNodes():this.GetRootNodeObjects(),r=i.IsPartialUpdate?i.getNewLinks():this.GetAllLinkObjects();e.constructAnimation(i.getNodes(),s),e.constructAnimation(i.getLinks(),r),e.constructAnimation([i.Overview],[this.Overview]),e.add(o,d.UPDATE)},t.Diagram.prototype._resolveDeferredData=function(t,e){if(null==e||this._isNodeDisclosed(e.id)||this._discoverLinks(t,e)){var i=t.getData(e);this._deferredObjCount++;var o=this,n=this._renderCount;i.then(function(i){o._renderDeferredData(n,t,e||o.getOptions(),i)},function(i){o._renderDeferredData(n,t,e||o.getOptions(),null)})}},t.Diagram.prototype._renderDeferredData=function(t,e,i,o){if(t===this._renderCount&&this.getCtx().isReadyToRender()){if(null!=o){if(i.nodes=o.nodes,Array.isArray(o.links)&&(this.getOptions().links=this.getOptions().links.concat(o.links)),this._findUnresolvedLinks(o),Array.isArray(i.nodes))for(this._nodesToResolve=this._nodesToResolve.concat(i.nodes);this._nodesToResolve.length>0;)this._resolveDeferredData(e,this._nodesToResolve.shift())}else i.nodes=null;this._deferredObjCount--,0===this._deferredObjCount&&this.RenderComponentInternal()}},t.Diagram.prototype._findUnresolvedLinks=function(t,e){if(!("none"===this.getOptions().promotedLinkBehavior||this.isDataProviderMode()&&"lazy"===this.getOptions().promotedLinkBehavior)){var i=function(t,o){Array.isArray(t.nodes)&&t.nodes.forEach(function(t){o.set(t.id,!0),e&&i(t,o)})};i(t,this._allNodeIdsMap);for(var o=this._unresolvedNodeIds.length-1;o>=0;o--)this._allNodeIdsMap.has(this._unresolvedNodeIds[o])&&this._unresolvedNodeIds.splice(o,1);if(Array.isArray(t.links))for(o=0;o<t.links.length;o++){var n=t.links[o];this._allNodeIdsMap.has(n.startNode)||this._unresolvedNodeIds.push(n.startNode),this._allNodeIdsMap.has(n.endNode)||this._unresolvedNodeIds.push(n.endNode)}}},t.Diagram.prototype._discoverLinks=function(t,e){var i=this.getOptions().promotedLinkBehavior;return!("none"===i||0==this._unresolvedNodeIds.length||"lazy"==i&&t.getChildCount(e)<=0)&&"disjoint"!=t.getDescendantsConnectivity(e)},t.Diagram.prototype._setDataSourceListeners=function(t,e){t&&(this._dataSourceAddEventHandler||(this._dataSourceAddEventHandler=this.handleDataSourceChangeEvent.bind(this,"add")),this._dataSourceRemoveEventHandler||(this._dataSourceRemoveEventHandler=this.handleDataSourceChangeEvent.bind(this,"remove")),this._dataSourceChangeEventHandler||(this._dataSourceChangeEventHandler=this.handleDataSourceChangeEvent.bind(this,"change")),e?(t.on("add",this._dataSourceAddEventHandler),t.on("remove",this._dataSourceRemoveEventHandler),t.on("change",this._dataSourceChangeEventHandler)):(t.off("add",this._dataSourceAddEventHandler),t.off("remove",this._dataSourceRemoveEventHandler),t.off("change",this._dataSourceChangeEventHandler)))},t.Diagram.prototype.addDataSourceEventListeners=function(){this._setDataSourceListeners(this.getOptions().data,!0)},t.Diagram.prototype.removeDataSourceEventListeners=function(){this._setDataSourceListeners(this.getOptions().data,!1)},t.Diagram.prototype._fetchDataProviderData=function(t,e){var o=this.isTreeDataProvider()?i.GetCollapsedContainers(t,e,[]):[];if(o.length>0){var n=this,a=o.map(function(e){return n.Options._fetchDataHandler(t,n._context.KeySetImpl([e.id]),e,e.id)}),s=this._renderCount;Promise.all(a).then(function(i){if(s===n._renderCount&&n.getCtx().isReadyToRender()){e=[],i.forEach(function(t){Array.isArray(t)&&t.forEach(function(t){n._allNodeIdsMap.set(t.id,!0),e.push(t)})});for(var o=n._unresolvedNodeIds.length-1;o>=0;o--)n._allNodeIdsMap.has(n._unresolvedNodeIds[o])&&n._unresolvedNodeIds.splice(o,1);n._unresolvedNodeIds.length>0?n._fetchDataProviderData(t,e):n.RenderComponentInternal()}})}else this.RenderComponentInternal()},t.Diagram.prototype.isDataProviderMode=function(){return!!this.getOptions().nodeData},t.Diagram.prototype.isTreeDataProvider=function(){var t=this.getOptions().nodeData;return!(!t||!t.getChildDataProvider)},t.Diagram.prototype.Render=function(){if(t.Diagram.superclass.Render.call(this),this.InitComponentInternal(),this._deferredObjCount=0,this._nodesToResolve=[],this._bRendered||this.IsResize())0===this._deferredObjCount&&this.RenderComponentInternal();else if(this._renderCount++,this.isDataProviderMode()){this._findUnresolvedLinks({nodes:this.Options.nodes,links:this.Options.links},!0);var e=this._unresolvedNodeIds.length>0?this.Options.nodes.slice():[];this._fetchDataProviderData(this.Options.nodeData,e)}else if(this.getOptions().data){var i=this.getOptions().data;this._setDataSourceListeners(i,!1),this._resolveDeferredData(i,null)}else this.RenderComponentInternal()},t.Diagram.prototype.RenderComponentInternal=function(){var t;if(this._bRendered||this.IsResize()||(this._setDataSourceListeners(this.getOptions().data,!0),this.prepareNodes(this.getOptions().nodes),this.renderLinks(this.getOptions().links),this.getCtx().setKeyboardFocusArray([this])),t=0===this._nodes.size)this._processContent(t);else{this.contains(this._oldPanZoomCanvas)||this.addChild(this._oldPanZoomCanvas);var e=this.layout(),i=this,o=this._renderCount;e.then(function(){o===i._renderCount&&i._processContent(t)},function(){o===i._renderCount&&(i.removeChild(i._oldPanZoomCanvas),i._oldPanZoomCanvas=null,i._bRendered=!0,this._currentViewport=null)})}},t.Diagram.prototype._processContent=function(i){var n;if(i||(this.removeChild(this._oldPanZoomCanvas),this._processHighlighting(),this._processInitialSelections(),this._updateKeyboardFocusEffect(),(n=null==this._cachedViewBounds)&&(this._cachedViewBounds=this.GetViewBounds()),this._fitContent()),!this._bRendered){var a=this.getPanZoomCanvas();a.setPanningEnabled(this.IsPanningEnabled()),a.setPanDirection(this.getPanDirection()),a.setZoomingEnabled(this.IsZoomingEnabled()),a.setZoomToFitEnabled(this.IsZoomingEnabled()),this.Options._resources&&a.setPanCursor(this.Options._resources.panCursorUp,this.Options._resources.panCursorDown)}!this.Overview&&this.Options.overview&&"on"==this.Options.overview.rendered?this.Overview=o.CreateOverviewWindow(this):this.Overview&&o.UpdateOverviewWindow(this,this.Overview),this._oldPanZoomCanvas=null,this.StopAnimation(!0);var s=e.getAnimationOnDisplay(this),r=e.getAnimationOnDataChange(this);if(this._bRendered||"none"===s||this._oldDataAnimState){if("none"!==r&&this._oldDataAnimState){this._deleteContainer=new t.Container(this.getCtx(),"Delete Container"),this.addChild(this._deleteContainer);var h=new d(this.getCtx(),this._deleteContainer,this._oldDataAnimState,this);h.constructAnimation([this._oldDataAnimState],[this]),this.Animation=h.getAnimation()}}else this.Animation=t.BlackBoxAnimationHandler.getInAnimation(this.getCtx(),t.BlackBoxAnimationHandler.ALPHA_FADE,this,null,e.getAnimationDuration(this));if(this.Animation?(this.getEventManager().hideTooltip(),this.getEventManager().removeListeners(this),this.Animation.setOnEnd(this._onAnimationEnd,this),this.Animation.play()):this._onAnimationEnd(),this._bRendered=!0,this._currentViewport=null,this.RefreshEmptyText(i),this.IsPanningEnabled()){var l=this._cachedViewBounds;if(null!=l){var g=this.getPanZoomCanvas().getZoom();this.ConstrainPanning(l.x,l.y,l.w,l.h,g)}}this.ClearLayoutViewport(),n&&(this._cachedViewBounds=null)},t.Diagram.prototype._fitContent=function(){var e=this.getPanZoomCanvas();if(this._bRendered){if(this.IsResize()||this._partialUpdate){var i=this.AdjustMinZoom(this._cachedViewBounds);n=(o=this.IsLayoutViewport())?this.GetLayoutViewport():i||this._cachedViewBounds;e.setZoomToFitPadding(o?0:t.PanZoomCanvas.DEFAULT_PADDING),e.setZoomToFitEnabled(!0),e.zoomToFit(null,n),e.setZoomToFitEnabled(this.IsZoomingEnabled())}}else{this.AdjustMinZoom(this._cachedViewBounds);var o,n=(o=this.IsLayoutViewport())?this.GetLayoutViewport():this._cachedViewBounds;o&&e.setZoomToFitPadding(0),e.zoomToFit(null,n)}},t.Diagram.prototype.SetOptions=function(e){t.Diagram.superclass.SetOptions.call(this,e),this.isDataProviderMode()||(this.Options.nodes=[],this.Options.links=[]),this.SetPanningEnabled("none"!=this.Options.panning),this.SetZoomingEnabled("none"!=this.Options.zooming),this.setSelectionMode(this.Options.selectionMode),this.setEmptyText(this.Options.emptyText?this.Options.emptyText:this.Options.translations.labelNoData)},t.Diagram.getDefaults=function(t){return(new s).getDefaults(t)},t.Diagram.prototype.getMaxZoom=function(){var t=this.getOptions().maxZoom,e=parseFloat(t);return e>0?e:1},t.Diagram.prototype.getMinZoom=function(){var t=this.getOptions().minZoom;if(t){var e=parseFloat(t);return e>0&&(t=Math.min(e,this.getMaxZoom())),t}return 0},t.Diagram.prototype.getPanDirection=function(){return this.getOptions().panDirection},t.Diagram.prototype.getAnimationDuration=function(){return e.getAnimationDuration(this)},t.Diagram.prototype.processEvent=function(t,e){var i=t.type;if("categoryHighlight"==i)this._processHighlighting(!0);else if("selection"==i)this.getOptions().selection=t.selection;else if("overview"==i){var o=t.subtype;return void("scrollPos"!=o&&"scrollTime"!=o||this.Overview.HandleViewportChange(t))}t&&this.dispatchEvent(t)},t.Diagram.prototype.prepareNodes=function(t){if(t){this._prepareNodes(null,t);var e=this.getOptions().expanded;e&&(e.has||this.DisclosedNodes)||(this.DisclosedNodes=e?"all"===e?this._arNodeIds.slice(0):e:[])}},t.Diagram.prototype.renderLinks=function(i){if(i){for(var o=e.getLinkDefaultStyles(this,"linkDefaults"),n=0;n<i.length;n++){var a=i[n];if(!this._isLinkPromoted(a)){a=e.getLinkStyles(this,a,o);var s=g.newInstance(this,a,!1),r=s.getId();if(this._arLinkIds.push(r),!s.isHidden()){var d=this.getNodeById(s.getStartId()),h=this.getNodeById(s.getEndId());d.addOutLinkId(r),h.addInLinkId(r),s.render(),this._links.set(r,s)}}}if(this._promotedLinksMap){var l=e.getLinkDefaultStyles(this,"promotedLink"),p=this;this._promotedLinksMap.forEach(function(e,i,o){if(!p._links.has(i)){var n=t.JsonUtils.merge(e,l),a=g.newInstance(p,n,!0),s=a.getId(),r=p.getNodeById(a.getStartId()),d=p.getNodeById(a.getEndId());r.addOutLinkId(s),d.addInLinkId(s),a.render(),p._arLinkIds.push(s),p._links.set(s,a)}})}}},t.Diagram.prototype.layout=function(){var e=this.getOptions().layout,i=this._getLayoutContext();if(i.setDirtyContext(new(this.getCtx().ojMap)),this._currentViewport){var o=this._currentViewport,n=this.getLayoutOffset(),a=new t.DiagramRectangle(o.x-n.x,o.y-n.y,o.w,o.h);i.setCurrentViewport(a)}if(e&&"function"==typeof e){for(var s=i.getNodeCount(),r=0;r<s;r++){var d=i.getNodeByIndex(r);this.renderLeafNodeFromContext(d)}var h=this,l=e(i);l||(l={then:function(t,e){t()}}),this.setAlphas(0);var g=this._renderCount;return l.then(function(t){if(h._renderCount===g||h.IsResize()){h.setAlphas(1),h._oldDataAnimState&&h._oldDataAnimState.updateStateFromLayoutContext(i);for(var e=i.getNodeCount(),o=0;o<e;o++){var n=i.getNodeByIndex(o);h.renderNodeFromContext(n,!0)}h.ApplyLayoutContext(i,!0)}},function(t){}),l}this.Log("dvt.Diagram: Layout function is not defined",1)},t.Diagram.prototype.setAlphas=function(t){this._bRendered||(this.getLinksPane().setAlpha(t),this.getNodesPane().setAlpha(t))},t.Diagram.prototype.getNodeById=function(t){return this._nodes.get(t)},t.Diagram.prototype.getLinkById=function(t){return this._links.get(t)},t.Diagram.prototype.GetAllLinks=function(){return this._arLinkIds},t.Diagram.prototype.GetAllLinksMap=function(){var t=new(this.getCtx().ojMap);return this._links&&this._links.forEach(function(e,i,o){t.set(i,e)}),t},t.Diagram.prototype.GetAllLinkObjects=function(){var t=[];return this._links&&this._links.forEach(function(e,i,o){t.push(e)}),t},t.Diagram.prototype.GetAllNodes=function(){return this._arNodeIds},t.Diagram.prototype.GetAllNodesMap=function(){var t=new(this.getCtx().ojMap);return this._nodes&&this._nodes.forEach(function(e,i,o){t.set(i,e)}),t},t.Diagram.prototype.GetAllNodeObjects=function(){var t=[];return this._nodes&&this._nodes.forEach(function(e,i,o){t.push(e)}),t},t.Diagram.prototype.GetAllRoots=function(){return this._arRootIds},t.Diagram.prototype.GetRootNodeObjects=function(){for(var t=[],e=0;this._arRootIds&&e<this._arRootIds.length;e++){var i=this._nodes.get(this._arRootIds[e]);i&&t.push(i)}return t},t.Diagram.prototype.HandlePanEvent=function(e){t.Diagram.superclass.HandlePanEvent.call(this,e),this.Overview&&this.Overview.UpdateViewport()},t.Diagram.prototype.HandleZoomEvent=function(e){switch(t.Diagram.superclass.HandleZoomEvent.call(this,e),this.Overview&&this.Overview.UpdateViewport(),e.subtype){case"adjustPanConstraints":if(this.IsPanningEnabled()){var i=e.newZoom,o=this._cachedViewBounds?this._cachedViewBounds:this.GetViewBounds();this.ConstrainPanning(o.x,o.y,o.w,o.h,i)}break;case"zoomed":!t.Agent.isTouchDevice()&&this.getOptions().zoomRenderer&&e.oldZoom!==e.newZoom&&this._nodes.forEach(function(t,i,o){t.rerenderOnZoom(e)});break;case"zoomToFitEnd":case"zoomEnd":t.Agent.isTouchDevice()&&this.getOptions().zoomRenderer&&e.oldZoom!==e.newZoom&&this._nodes.forEach(function(t,i,o){t.rerenderOnZoom(e)})}},t.Diagram.prototype.getNavigableLinksForNodeId=function(t){var e=[];return this._links.forEach(function(i,o,n){var a=i.getStartId(),s=i.getEndId();a!=t&&s!=t||!i.getVisible()||e.push(i)}),e},t.Diagram.prototype._processInitialSelections=function(){if(this.Options.selection&&this.isSelectionSupported()){var t=[];this._nodes.forEach(function(e,i,o){t.push(e)}),this._links.forEach(function(e,i,o){t.push(e)}),this.getSelectionHandler().processInitialSelections(this.Options.selection,t)}},t.Diagram.prototype._processHighlighting=function(e){e&&this.EventManager.removeListeners(this,!0),this._highlightedObjects&&(this._updateAlphas(!1,this._highlightedObjects),this._highlightedObjects=null);var i=this.Options.highlightedCategories;if(i&&0!==i.length){var o="any"==this.Options.highlightMatch;this._highlightedObjects=new(this.getCtx().ojMap);var n=[],a=this;this._nodes.forEach(function(e,s,r){(o?t.ArrayUtils.hasAnyItem(e.getCategories(),i):t.ArrayUtils.hasAllItems(e.getCategories(),i))&&(a._highlightedObjects.set(s,e),n.push(e))}),this._processNodeConnections(n);var s=[];if(this._links.forEach(function(e,n,r){(o?t.ArrayUtils.hasAnyItem(e.getCategories(),i):t.ArrayUtils.hasAllItems(e.getCategories(),i))&&(a._highlightedObjects.set(n,e),s.push(e))}),"linkAndNodes"==this.Options.linkHighlightMode&&this._processLinkConnections(s),this._updateAlphas(!0,this._highlightedObjects),e){a=this;setTimeout(function(){a.getEventManager().addListeners(a)},0)}}else e&&this.EventManager.addListeners(this)},t.Diagram.prototype._processNodeConnections=function(t){var e=this.Options.nodeHighlightMode;if("node"!=e){for(var i="nodeAndIncomingLinks"==e||"nodeAndLinks"==e,o="nodeAndOutgoingLinks"==e||"nodeAndLinks"==e,n=[],a=0;a<t.length;a++){var s=t[a],r=i&&s.getInLinkIds()?s.getInLinkIds():[];r=o&&s.getOutLinkIds()?r.concat(s.getOutLinkIds()):r;for(var d=0;d<r.length;d++){var h=r[d];this._highlightedObjects.set(h,this.getLinkById(h)),n.push(this.getLinkById(h))}}this._processLinkConnections(n)}},t.Diagram.prototype._processLinkConnections=function(t){for(var e=0;e<t.length;e++){var i=t[e],o=i.getStartId(),n=i.getEndId();this._highlightedObjects.set(o,this.getNodeById(o)),this._highlightedObjects.set(n,this.getNodeById(n))}},t.Diagram.prototype._updateAlphas=function(t,e){var i=this._nodes.size+this._links.size;if(e.size!==i)if(this._arNodeIds.length==this._arRootIds.length){var o=t?this.Options.styleDefaults._highlightAlpha:1,n=this.getLinksPane(),a=this.getNodesPane();if(e.size>.5*i){var s=this.getBottomPane();s.setAlpha(o),this._links.forEach(function(i,o,a){var r=e.get(o);!r&&t?s.addChild(i):r||n.addChild(i)}),this._nodes.forEach(function(i,o,n){var r=e.get(o);!r&&t?s.addChild(i):r||a.addChild(i)})}else{var r=this.getTopPane();n.setAlpha(o),a.setAlpha(o);var d=[],h=[];e.forEach(function(t,e,i){t instanceof g?d.push(t):t instanceof p&&h.push(t)});for(var l=0;l<d.length;l++)t?r.addChild(d[l]):n.addChild(d[l]);for(l=0;l<h.length;l++)t?r.addChild(h[l]):a.addChild(h[l])}}else t?(e.forEach(function(t,e,i){t.highlight(!0)}),this._nodes.forEach(function(t,i,o){e.has(i)||t.highlight(!1)}),this._links.forEach(function(t,i,o){e.has(i)||t.highlight(!1)})):(this._nodes.forEach(function(t,e,i){t.highlight(!0)}),this._links.forEach(function(t,e,i){t.highlight(!0)}))},t.Diagram.prototype.highlight=function(e){this.Options.highlightedCategories=t.JsonUtils.clone(e),this._processHighlighting()},t.Diagram.prototype.select=function(e){this.Options.selection=t.JsonUtils.clone(e),this._processInitialSelections()},t.Diagram.prototype.getAutomation=function(){return this.Automation||(this.Automation=new c(this)),this.Automation},t.Diagram.prototype.Log=function(t,e){var i=this.getOptions()._logger;if(i)switch(e){case 1:i.error&&i.error(t);break;case 2:i.warn&&i.warn(t);break;case 3:i.info&&i.info(t);break;default:i.log&&i.log(t)}},t.Diagram.prototype.processDefaultHoverEffect=function(t,e){var i=this.getNodeById(t);i&&i.processDefaultHoverEffect(e)},t.Diagram.prototype.processDefaultSelectionEffect=function(t,e){var i=this.getNodeById(t);i&&i.processDefaultSelectionEffect(e)},t.Diagram.prototype.processDefaultFocusEffect=function(t,e){var i=this.getNodeById(t);i&&i.processDefaultFocusEffect(e)},t.Diagram.prototype.updateNodeDims=function(e){if(e.IsRendered){var i=this.getNodeById(e.getId());e.setBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(i.getLayoutBounds(!0))),e.setContentBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(i.getContentBounds(!0))),e.setLabelBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(i.getLabelBounds(!0)))}else this.renderNodeFromContext(e,!0)},t.Diagram.prototype.renderLeafNodeFromContext=function(t){if(this.getNodeById(t.getId()).isDisclosed())for(var e=t.getChildNodes(),i=0;i<e.length;i++){var o=e[i];this.renderLeafNodeFromContext(o)}else this.renderNodeFromContext(t,!1)},t.Diagram.prototype.renderNodeFromContext=function(e,i){if(!e.IsRendered){var o=this.getNodeById(e.getId());if(o.isDisclosed()){var n=this.CreateEmptyLayoutContext();n.setDirtyContext(e.LayoutContext?e.LayoutContext.getDirtyContext():null),this._oldDataAnimState&&this._oldDataAnimState.updateStateFromLayoutContext(n);for(var a=e.getChildNodes(),s=0;s<a.length;s++){var r=a[s];this.renderNodeFromContext(r,!1),n.addNode(r)}for(s=0;s<a.length;s++)this.updateNodeDims(a[s]);this.ApplyLayoutContext(n)}o.render();var d=o.isDisclosed()?o.getContainerPadding():null;d&&e.setContainerPadding(d.top,d.right,d.bottom,d.left),e.setBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(o.getLayoutBounds(i))),e.setContentBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(o.getContentBounds(i))),e.setLabelBounds(t.DiagramLayoutUtils.convertRectToDiagramRect(o.getLabelBounds(i))),e.IsRendered=!0}},t.Diagram.prototype._prepareNodes=function(t,i){if(i)for(var o=e.getNodeDefaultStyles(this),n=0;n<i.length;n++){var a=e.getNodeStyles(this,i[n],o),s=p.newInstance(this,a),r=s.getId();t?(t.addChildNodeId(r),s.setGroupId(t.getId())):this._arRootIds.push(r),this._arNodeIds.push(r),a.nodes&&a.nodes.length>0&&(this._isNodeDisclosed(r)?(s.setDisclosed(!0),this._prepareNodes(s,a.nodes)):this._addToCollapsedArray(s)),s.isHidden()||(t&&t.GetChildNodePane()?t.GetChildNodePane().addChild(s):this.getNodesPane().addChild(s),this._nodes.set(r,s))}},t.Diagram.prototype.setNodeDisclosed=function(e,i){i!=this._isNodeDisclosed(e)&&this.dispatchEvent(new t.EventFactory.newEvent(i?"beforeExpand":"beforeCollapse",e))},t.Diagram.prototype.expand=function(e){var o=!1,n=this.getOptions().expanded;n&&n.has&&!n.has(e)?(o=!0,n=n.add([e]),this.applyOptions({expanded:n},this.Defaults.getNoCloneObject())):(this.DisclosedNodes||(this.DisclosedNodes=[]),this.DisclosedNodes.indexOf(e)<0&&(this.DisclosedNodes.push(e),o=!0));if(o){var a=this.getNodeById(e);if(this.isDataProviderMode()&&!a.getData().nodes){var s=i.GetNodeOption(this,a),r=this,d=this._renderCount;this.getOptions()._fetchDataHandler(this.getOptions().nodeData,n,s,e).then(function(i){d===r._renderCount&&(r.render(r.getOptions(),r.Width,r.Height),r.dispatchEvent(new t.EventFactory.newEvent("expand",e)))})}else this.render(this.getOptions(),this.Width,this.Height),this.dispatchEvent(new t.EventFactory.newEvent("expand",e))}},t.Diagram.prototype.collapse=function(e){var i=!1,o=this.getOptions().expanded;if(o&&o.has&&o.has(e))i=!0,o=o.delete([e]),this.applyOptions({expanded:o},this.Defaults.getNoCloneObject());else{var n=-1;this.DisclosedNodes&&(n=this.DisclosedNodes.indexOf(e)),n>-1&&(this.DisclosedNodes.splice(n,1),i=!0)}i&&(this.render(this.getOptions(),this.Width,this.Height),this.dispatchEvent(new t.EventFactory.newEvent("collapse",e)))},t.Diagram.prototype._addLayoutContextForChildNodes=function(t,e,i,o){if(t.isDisclosed()){var n=t.getChildNodeIds(),a=this._createLayoutContextForChildNodes(e,i,n,o);e.setChildNodes(a)}},t.Diagram.prototype._appendLayoutContextForChildNodes=function(e,i,o,n,a){if(e.isDisclosed()){var s=n.reduce(function(t,e){return t.push(e.id),t},[]),r=this._createLayoutContextForChildNodes(i,o,s,!0),d=i.getChildNodes()||[];r=t.ArrayUtils.insert(d,r,a),i.setChildNodes(r),i.setDisclosed(!0),i.SetContainerPaddingObj(t.BaseDiagram.getLayoutContainerPadding(e.getContainerPadding())),i.UpdateParentNodes()}},t.Diagram.prototype._createLayoutContextForChildNodes=function(t,e,i,o){for(var n=[],a=0;a<i.length;a++){var s=this.getNodeById(i[a]);if(s.getVisible()){var r=this.CreateLayoutContextNode(s,null,o,e);r.copyFrom(this._oldLayoutContext?this._oldLayoutContext.getNodeById(i[a]):null),e.addNodeToMap(r),r.setParentNode(t),n.push(r),this._addLayoutContextForChildNodes(s,r,e,o)}}return n},t.Diagram.prototype._isNodeDisclosed=function(t){var e=this.getOptions().expanded;if(e&&e.has)return e.has(t);var i=this.DisclosedNodes?this.DisclosedNodes:e;return i&&i.indexOf(t)>-1||i&&i.indexOf("all")>-1},t.Diagram.prototype._isLinkPromoted=function(t){var e=this.getNodeById(t.startNode),i=this.getNodeById(t.endNode);if(e&&i||!this._collapsedNodes)return!1;if("none"===this.getOptions().promotedLinkBehavior)return!0;var o=e?e.getId():this._findFirstVisibleAncestor(t.startNode),n=i?i.getId():this._findFirstVisibleAncestor(t.endNode);if(!o||!n)return!1;if(o===n)return!1;var a=g.GetPromotedLinkId(this,o,n);return this._promotedLinksMap||(this._promotedLinksMap=new(this.getCtx().ojMap)),this._promotedLinksMap.has(a)?this._promotedLinksMap.get(a)._links.push(t):this._promotedLinksMap.set(a,{id:a,startNode:o,endNode:n,_links:[t]}),this._linkToPromotedMap||(this._linkToPromotedMap=new(this.getCtx().ojMap)),this._linkToPromotedMap.set(t.id,a),!0},t.Diagram.prototype._addToCollapsedArray=function(t){this._collapsedNodes||(this._collapsedNodes=[]),this._collapsedNodes.push(t)},t.Diagram.prototype._findFirstVisibleAncestor=function(e){for(var i=this.getCtx(),o=function(e,n){if(e)for(var a=0;a<e.length;a++)if(t.BaseDiagram.compareValues(i,e[a].id,n)||o(e[a].nodes,n))return!0;return!1},n=0;n<this._collapsedNodes.length;n++){var a=this._collapsedNodes[n];if(o(a.getData().nodes,e))return a.getId()}return null},t.Diagram.prototype._updateKeyboardFocusEffect=function(){var t,e=this.getEventManager().getFocus(),i=!1;e&&(e instanceof p?t=this.getNodeById(e.getId()):e instanceof g&&(t=this.getLinkById(e.getId())),i=e.isShowingKeyboardFocusEffect(),t&&i&&t.showKeyboardFocusEffect(),this.getEventManager().setFocus(t))},t.Diagram.prototype.clearDisclosedState=function(){this.DisclosedNodes=null},t.Diagram.prototype.ShowLinkCreationFeedback=function(i){if(this.getEventManager().LinkCreationStarted){var o=this._context.pageToStageCoords(i.pageX,i.pageY),n=this.getPanZoomCanvas().getContentPane().stageToLocal({x:o.x,y:o.y});if(this._linkCreationFeedBack){var a=this._linkCreationFeedBack.getPoints();this._linkCreationFeedBack.setPoints([a[0],a[1],n.x,n.y])}else{var s=this.getEventManager().DragSource.getDragObject();if(s instanceof p){var r=this.getEventManager().DragSource.getDragCoords(),d=this.getPanZoomCanvas().getContentPane().stageToLocal({x:r.x,y:r.y}),h=this.getOptions().styleDefaults.linkDefaults;e.prepareLinkStyle(h,"style");var l=this.getOptions().dnd.drag.ports.linkStyle;if(l&&"function"==typeof l){var c=l({dataContext:s.getDataContext(),portElement:s.__dragPort});c&&(h.style=t.JsonUtils.merge(c.svgStyle,h.style),h.svgClassName=c.svgClassName||h.className)}var u={id:"linkFeedback",startNode:s.getId(),endNode:s.getId()};u=t.JsonUtils.merge(u,h);var _=g.newInstance(this,u,!1);this.getNodesPane().addChild(_),_.setMouseEnabled(!1),_.setPoints([d.x,d.y,n.x,n.y]),this._linkCreationFeedBack=_}}}},t.Diagram.prototype.HideLinkCreationFeedback=function(){this.getNodesPane().removeChild(this._linkCreationFeedBack),this._linkCreationFeedBack=null},t.Diagram.prototype.handleDataSourceChangeEvent=function(t,i){if("none"!==e.getAnimationOnDataChange(this)&&(this._oldDataAnimState=new r(this,t,i)),this._currentViewport=this.getPanZoomCanvas().getViewport(),this.IsPanningEnabled()){var o=this.getPanZoomCanvas();o.setMinPanY(null),o.setMaxPanY(null),o.setMinPanX(null),o.setMaxPanX(null)}var n,a,s=i.data.nodes,d=i.data.links;if("add"==t){if(a=(n=i.parentId)?this.getNodeById(n):null,"all"===this.getOptions().expanded&&s){var h=this.DisclosedNodes,l=function(t){for(var e=0;e<t.length;e++)h.push(t[e].id),t[e].nodes&&l(t[e].nodes)};l(s)}a?(a.appendChildNodesData(s,i.index),this._isNodeDisclosed(n)&&(a.setDisclosed(!0),this._prepareNodes(a,s))):this._prepareNodes(null,s),this.renderLinks(d)}else if("change"==t){if(s)for(var g=e.getNodeDefaultStyles(this),p=0;p<s.length;p++){var c=this.getNodeById(s[p].id);if(c){var u=e.getNodeStyles(this,s[p],g);c.setData(u)}}d&&(this._removeLinks(d),this.renderLinks(d))}else"remove"==t&&((a=(n=i.parentId)?this.getNodeById(n):null)?(this._removeNodes(a,s),a.removeChildNodesData(s),a.getData().nodes&&0!==a.getData().nodes.length||a.setDisclosed(!1)):this._removeNodes(null,s),this._removeLinks(d));this._oldDataAnimState&&this._oldDataAnimState.updateStateFromEvent(t,i),this._updateLayoutContext(t,i);var _=0===this.GetAllNodes().length;if(_)this._processContent(_);else{this._renderCount++;var f=this.layout(),m=this,v=this._renderCount;f.then(function(){v===m._renderCount&&(m._partialUpdate=!0,m._updateOverview(t,i),m._processContent(!1),m._partialUpdate=!1)},function(){v===m._renderCount&&(m.removeChild(m._oldPanZoomCanvas),m._oldPanZoomCanvas=null,m._bRendered=!0,this._currentViewport=null)})}},t.Diagram.prototype._updateOverview=function(t,e){this.Overview&&o.UpdateOverviewContent(this,this.Overview,t,e)},t.Diagram.prototype._updateLayoutContext=function(t,e){this._layoutContext||(this._layoutContext=this.CreateEmptyLayoutContext());var i=this._layoutContext;i.setEventData({type:t,data:e});var o,n,a,s,r,d,h=e.data.nodes,l=e.data.links;if(e.parentId&&(s=i.getNodeById(e.parentId),r=this.getNodeById(e.parentId)),"add"==t){if(h)if(s&&r)s.Reset(),this._appendLayoutContextForChildNodes(r,s,i,h,e.index);else for(o=0;o<h.length;o++)a=h[o].id,this.getNodeById(a)&&(n=this.CreateLayoutContextNode(this.getNodeById(a),null,!0,i),this._addLayoutContextForChildNodes(this.getNodeById(a),n,i,!0),i.addNode(n));if(l)for(o=0;o<l.length;o++){if(d=l[o].id,u=this.getLinkById(d)||this.getLinkById(this._linkToPromotedMap.get(d))){if(i.getLinkById(u.getId()))continue;var g=u.getData().startNode,p=u.getData().endNode;i.getNodeById(g)&&i.getNodeById(p)&&i.addLink(this.CreateLayoutContextLink(u,g,p,null,i))}}}else if("change"==t){if(h)for(o=0;o<h.length;o++)a=h[o].id,(n=i.getNodeById(a))&&(n.Reset(),n.UpdateParentNodes());if(l){for(o=i.getLinkCount()-1;o>=0;o--){var c=i.getLinkByIndex(o);this._links.get(c.getId())||i.removeLink(c)}for(o=0;o<l.length;o++){var u;if(d=l[o].id,u=this.getLinkById(d)||this.getLinkById(this._linkToPromotedMap.get(d))){i.removeLink(i.getLinkById(u.getId()));g=u.getData().startNode,p=u.getData().endNode;i.getNodeById(g)&&i.getNodeById(p)&&i.addLink(this.CreateLayoutContextLink(u,g,p,null,i))}}}}else if("remove"==t){if(h){for(o=0;o<h.length;o++)a=h[o].id,n=i.getNodeById(a),i.removeNode(s,n);s&&r&&(s.Reset(),s.UpdateParentNodes(),s.setDisclosed(r.isDisclosed()))}for(o=i.getLinkCount()-1;o>=0;o--){c=i.getLinkByIndex(o);this._links.get(c.getId())||i.removeLink(c)}}},t.Diagram.prototype._getLayoutContext=function(){if(!this._layoutContext){for(var t=this.CreateEmptyLayoutContext(),e=0;e<this._arRootIds.length;e++){var i=this._arRootIds[e];if(this.getNodeById(i)){var o=!this._bRendered,n=this.getNodeById(i),a=this.CreateLayoutContextNode(n,null,o,t);a.copyFrom(this._oldLayoutContext?this._oldLayoutContext.getNodeById(i):null),this._addLayoutContextForChildNodes(n,a,t,o),t.addNode(a)}}var s=this;this._links.forEach(function(e,i,o){var n=e.getData().startNode,a=e.getData().endNode;if(t.getNodeById(n)&&t.getNodeById(a)){var r=s.CreateLayoutContextLink(e,n,a,null,t);r.copyFrom(s._oldLayoutContext?s._oldLayoutContext.getLinkById(i):null),t.addLink(r)}}),this._layoutContext=t,this._oldLayoutContext=null}return this._layoutContext},t.Diagram.prototype._removeNodes=function(e,i){if(i&&(!e||e.isDisclosed())){for(var o=[],n=0;n<i.length;n++){var a=i[n].id,s=this.getNodeById(a);this._removeNodes(s,s.getData().nodes),this._links.forEach(function(t,e,i){t.getStartId()!=a&&t.getEndId()!=a||o.push(t.getData())}),e?e.removeChildNode(s):(t.ArrayUtils.removeItem(this._arRootIds,a),this.getNodesPane().removeChild(s)),t.ArrayUtils.removeItem(this._arNodeIds,a),this._nodes.delete(a)}this._removeLinks(o)}},t.Diagram.prototype._removeLinks=function(e){if(e&&0!=e.length)for(var i=0;i<e.length;i++){var o=e[i].id,n=this.getLinkById(o);if(n){n.getParent().removeChild(n);var a=this.getNodeById(n.getStartId()),s=this.getNodeById(n.getEndId());a&&a.removeOutLinkId(o),s&&s.removeInLinkId(o),t.ArrayUtils.removeItem(this._arLinkIds,o),this._links.delete(o)}else if(this._linkToPromotedMap&&this._linkToPromotedMap.has(o)){var r=this._linkToPromotedMap.get(o),d=this._links.get(r),h=d?d.getData()._links:null;if(h&&1==h.length&&h[0].id==o){d.getParent().removeChild(d);a=this.getNodeById(d.getStartId()),s=this.getNodeById(d.getEndId());a&&a.removeOutLinkId(r),s&&s.removeInLinkId(r),t.ArrayUtils.removeItem(this._arLinkIds,d.getId()),this._links.delete(d.getId()),this._promotedLinksMap.delete(d.getId()),this._linkToPromotedMap.delete(o)}else if(h){for(i=0;i<h.length;i++)t.BaseDiagram.compareValues(this.getCtx(),h[i].id,o)&&h.splice(i,1);this._linkToPromotedMap.delete(o)}}}};var a=function(t,e){a.superclass.constructor.call(this,t,e),this.setHoverDelay(a._HOVER_DELAY),this._diagram=e};t.Obj.createSubclass(a,t.CategoryRolloverHandler,"DvtDiagramCategoryRolloverHandler"),a._HOVER_DELAY=100,a.prototype.GetRolloverCallback=function(e,i,o,n){return t.Obj.createCallback(this,function(){this.SetHighlightMode(!0),this._diagram.processEvent(e)})},a.prototype.GetRolloutCallback=function(e,i,o,n){return t.Obj.createCallback(this,function(){this.SetHighlightModeTimeout(),this._diagram.processEvent(e)})};var s=function(t){this.Init({alta:s.SKIN_ALTA},t)};t.Obj.createSubclass(s,t.BaseComponentDefaults,"DvtDiagramDefaults"),s.SKIN_ALTA={skin:t.CSSStyle.SKIN_ALTA,emptyText:null,selectionMode:"none",animationOnDataChange:"none",animationOnDisplay:"none",maxZoom:1,highlightMatch:"all",nodeHighlightMode:"node",linkHighlightMode:"link",panning:"none",touchResponse:"auto",zooming:"none",promotedLinkBehavior:"lazy",_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),dnd:{drag:{nodes:{},ports:{}},drop:{background:{},nodes:{},links:{},ports:{}}},styleDefaults:{animationDuration:500,hoverBehaviorDelay:200,_highlightAlpha:.1,_overviewStyles:{overview:{backgroundColor:"rgb(228,229,230)"},viewport:{backgroundColor:"rgb(255,255,255)",borderColor:"rgb(74,76,78)"},node:{shape:"inherit"}},nodeDefaults:{_containerStyle:new t.CSSStyle("border-color:#abb3ba;background-color:#f9f9f9;border-width:.5px;border-radius:1px;padding-top:20px;padding-left:20px;padding-bottom:20px;padding-right:20px;"),labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_12+"color:#383A47"),hoverInnerColor:"rgb(255,255,255)",hoverOuterColor:"rgba(0,0,0, .3)",selectionColor:"rgb(0,0,0)",icon:{width:10,height:10,fillPattern:"none",shape:"circle"}},linkDefaults:{startConnectorType:"none",endConnectorType:"none",width:1,_style:{_type:"solid"},hoverInnerColor:"rgb(255,255,255)",hoverOuterColor:"rgba(0,0,0, .3)",selectionColor:"rgb(0,0,0)",labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_12+"color:#383A47"),_hitDetectionOffset:10},promotedLink:{startConnectorType:"none",endConnectorType:"none",width:1,_style:{_type:"dot",strokeDasharray:"2,3"},color:"#778999",hoverInnerColor:"rgb(255,255,255)",hoverOuterColor:"rgba(0,0,0, .3)",selectionColor:"rgb(0,0,0)",_hitDetectionOffset:10}}},s.prototype.getNoCloneObject=function(){return{data:!0,nodeData:!0,linkData:!0,nodes:!0,links:!0}};var r=function(t,e,i){this.Init(t,e,i)};t.Obj.createSubclass(r,t.Obj,"DvtDiagramDataAnimationState"),r.prototype.Init=function(t,e,i){this._diagram=t,this._context=t.getCtx(),this._nodes=[],this._newNodes=[],this._links=[],this._newLinks=[],this._processedObjMap=new this._context.ojMap,this.PanZoomMatrix=this._diagram.getPanZoomCanvas().getContentPane().getMatrix(),this.IsPartialUpdate=!(!e||!i),t.Overview&&(this.Overview=this.IsPartialUpdate?t.Overview.CreateAnimationClone():t.Overview),this.NodesMap=this._diagram.GetAllNodesMap(),this.LinksMap=this._diagram.GetAllLinksMap(),this._setNodes(e,i),this._setLinks(e,i)},r.prototype.getId=function(){return this._diagram.getId()},r.prototype.getOptions=function(){return this._diagram.getOptions()},r.prototype.getNodes=function(){return this._nodes},r.prototype.getLinks=function(){return this._links},r.prototype.getNewNodes=function(){return this._newNodes},r.prototype.getNewLinks=function(){return this._newLinks},r.prototype.updateStateFromEvent=function(t,e){if(e){var i,o,n,a=e.data.nodes,s=e.data.links;if("add"==t){for(i=0;a&&i<a.length;i++){var r=this._diagram.getNodeById(a[i].id);r&&(!0===this._wasParentDisclosed&&this._newNodes.push(r),this._processedObjMap.set(r.getId(),!0))}for(i=0;s&&i<s.length;i++)n=s[i].id,(o=this._diagram.getLinkById(n)||this._diagram._linkToPromotedMap&&this._diagram.getLinkById(this._diagram._linkToPromotedMap[n]))&&(this._newLinks.push(o),this._processedObjMap.set(o.getId(),!0))}else if("change"==t)for(i=0;s&&i<s.length;i++)n=s[i].id,(o=this._diagram.getLinkById(n)||this._diagram._linkToPromotedMap&&this._diagram.getLinkById(this._diagram._linkToPromotedMap[n]))&&(this._newLinks.push(o),this._processedObjMap.set(o.getId(),!0))}},r.prototype.updateStateFromLayoutContext=function(t){if(this.IsPartialUpdate){var e=this;t.getDirtyContext().forEach(function(t,i,o){e._processedObjMap.has(i)||((t=e._diagram.getNodeById(i)||e._diagram.getLinkById(i))instanceof p?(e._nodes.push(t.getAnimationState()),e._newNodes.push(t),e._processedObjMap.set(i,!0)):t instanceof g&&(e._links.push(t.getAnimationState()),e._newLinks.push(t),e._processedObjMap.set(i,!0)))})}},r.prototype._setNodes=function(t,e){if(this.IsPartialUpdate){var i=e.data.nodes,o=e.parentId;if("add"==t)this._addAncestorStates(o);else if("change"==t)for(var n=0;i&&n<i.length;n++){(a=this._diagram.getNodeById(i[n].id))&&(this._addAncestorStates(a.getGroupId()),this._nodes.push(a.getAnimationState()),this._newNodes.push(a),this._processedObjMap.set(a.getId(),!0))}else if("remove"==t&&(this._addAncestorStates(o),i&&!o))for(n=0;n<i.length;n++){var a;(a=this._diagram.getNodeById(i[n].id))&&(this._nodes.push(a),this._processedObjMap.set(a.getId(),!0))}}else this._nodes=this._diagram.GetRootNodeObjects()},r.prototype._setLinks=function(t,e){if(this.IsPartialUpdate){var i,o,n,a=e.data.links;if(!a)return;if("change"==t)for(i=0;i<a.length;i++)n=a[i].id,(o=this._diagram.getLinkById(n)||this._diagram._linkToPromotedMap&&this._diagram.getLinkById(this._diagram._linkToPromotedMap[n]))&&(this._links.push(o.getAnimationState()),this._processedObjMap.set(o.getId(),!0));else if("remove"==t)for(i=0;i<a.length;i++)n=a[i].id,(o=this._diagram.getLinkById(n)||this._diagram._linkToPromotedMap&&this._diagram.getLinkById(this._diagram._linkToPromotedMap[n]))&&(this._links.push(o),this._processedObjMap.set(o.getId(),!0))}else this._links=this._diagram.GetAllLinkObjects()},r.prototype._addAncestorStates=function(e){var i=e?this._diagram.getNodeById(e):null;for(this._wasParentDisclosed=!i||i.isDisclosed();i;){var o=t.BaseDiagram.compareValues(this._context,i.getId(),e)||i.isDisclosed()&&this._diagram.getOptions().renderer,n=i.getAnimationState(o);this._nodes.push(n),this._newNodes.push(i),this._processedObjMap.set(i.getId(),!0),i=i.getGroupId()?this._diagram.getNodeById(i.getGroupId()):null}};var d=function(t,e,i,o){this.Init(t,e,i,o)};t.Obj.createSubclass(d,t.DataAnimationHandler,"DvtDiagramDataAnimationHandler"),d.DELETE=0,d.UPDATE=1,d.INSERT=2,d.prototype.Init=function(t,e,i,o){d.superclass.Init.call(this,t,e),this._oldDiagram=i,this._newDiagram=o},d.prototype.getOldDiagram=function(){return this._oldDiagram},d.prototype.getNewDiagram=function(){return this._newDiagram},d.prototype.getAnimationDuration=function(){return e.getAnimationDuration(this._oldDiagram)},d.prototype.constructAnimation=function(e,i){var o=!1;if(i&&i.length>0&&(o=i[0]instanceof g),o&&!this.getCtx().isOffscreen()){var n,a,s=this.getCtx(),r=d._expandLinksArrayToMap(s,e),h=d._expandLinksArrayToMap(s,i),l=new s.ojMap,p=this;r.forEach(function(e,i,o){if(n=e,a=h.get(i))if(!n.isPromoted()&&!a.isPromoted()||n.isPromoted()&&a.isPromoted()&&t.BaseDiagram.compareValues(s,n.getId(),a.getId()))a.animateUpdate(p,n);else{var d=n.isPromoted()?n.getData()._links.length:1,g=a.isPromoted()?a.getData()._links.length:1;d>g&&!l.has(n.getId())?p._constructExpandCollapseAnimation(n,h,l,!0):d<g&&!l.has(a.getId())?p._constructExpandCollapseAnimation(a,r,l,!1):d==g&&a.animateUpdate(p,n)}else-1==p.getNewDiagram().GetAllLinks().indexOf(n.getId())&&n.animateDelete(p)}),h.forEach(function(t,e,i){n=r.get(e),a=t,n||p.getOldDiagram().LinksMap.has(a.getId())||a.animateInsert(p)})}else d.superclass.constructAnimation.call(this,e,i)},d.prototype._constructExpandCollapseAnimation=function(t,e,i,o){for(var n=[],a=t.getData()._links,s=0;s<a.length;s++){var r=e.get(a[s].id);r&&-1===n.indexOf(r)&&n.push(r)}n.length>0&&(o?t.animateExpand(this,n):t.animateCollapse(this,n),i.set(t.getId(),!0))},d._expandLinksArrayToMap=function(t,e){for(var i=new t.ojMap,o=0;o<e.length;o++){var n=e[o];if(n)if(n.isPromoted())for(var a=n.getData()._links,s=0;s<a.length;s++)i.set(a[s].id,n);else i.set(n.getId(),n)}return i};var h=function(t,e,i){this.Init(t,e,i,i),this._diagram=i,this._linkDragSelector=null,this._linkDropSelector=null,this._prevRolloverEvent=null};t.Obj.createSubclass(h,t.EventManager,"DvtDiagramEventManager"),h.prototype.showFocusEffect=function(t,e){this.ShowFocusEffect(t,e)},h.prototype.ShowFocusEffect=function(t,e){this._diagram.isPanning()||h.superclass.ShowFocusEffect.call(this,t,e)},h.prototype.ProcessRolloverEvent=function(e,i,o){var n=this._diagram.getOptions();if("dim"==n.hoverBehavior&&(!this._prevRolloverEvent||this._prevRolloverEvent.obj!==i||this._prevRolloverEvent.bOver!==o)){var a=i.getCategories?i.getCategories():[];n.highlightedCategories=o?a.slice():null;var s=t.EventFactory.newCategoryHighlightEvent(n.highlightedCategories,o),r=t.CSSStyle.getTimeMilliseconds(n.styleDefaults.hoverBehaviorDelay);this.RolloverHandler.processEvent(s,this._diagram.GetAllNodeObjects(),r,"any"==n.highlightMatch),this._prevRolloverEvent={obj:i,bOver:o}}},h.prototype.CreateCategoryRolloverHandler=function(t,e){return new a(t,e)},h.prototype.ProcessKeyboardEvent=function(i){var o=!0,n=i.keyCode,a=this.getFocus(),s=a instanceof p?a._customNodeContent:null;if(n!=t.KeyboardEvent.TAB&&this._bPassOnEvent)s.fireKeyboardListener(i),i.preventDefault();else if(n==t.KeyboardEvent.TAB&&s instanceof t.BaseComponent)!i.shiftKey&&a.isShowingKeyboardFocusEffect()?(a.hideKeyboardFocusEffect(),s.fireKeyboardListener(i),i.preventDefault(),this._bPassOnEvent=!0):i.shiftKey&&this._bPassOnEvent?(this.ShowFocusEffect(i,a),i.preventDefault(),this._bPassOnEvent=!1):(this._bPassOnEvent&&a.showKeyboardFocusEffect(),o=h.superclass.ProcessKeyboardEvent.call(this,i),this._bPassOnEvent=!1);else if(n==t.KeyboardEvent.SPACE&&i.ctrlKey&&i.shiftKey)a&&a.HandleKeyboardEvent&&a.HandleKeyboardEvent(i);else if((n==t.KeyboardEvent.ZERO||n==t.KeyboardEvent.NUMPAD_ZERO)&&i.ctrlKey&&i.altKey){if(a){var r=this._diagram.getPanZoomCanvas(),d=a.getKeyboardBoundingBox(this.getCtx().getStage()),l=r.getContentPane().stageToLocal({x:d.x,y:d.y}),g=r.getContentPane().stageToLocal({x:d.x+d.w,y:d.y+d.h}),c={x:l.x,y:l.y,w:g.x-l.x,h:g.y-l.y},u="none"!=e.getAnimationOnDataChange(this._diagram)?new t.Animator(this.getCtx(),this._diagram.getAnimationDuration()):null;r.zoomToFit(u,c),u&&u.play()}}else n==t.KeyboardEvent.TAB&&a&&this._diagram.ensureObjInViewport(i,a),o=h.superclass.ProcessKeyboardEvent.call(this,i);return o},h.prototype.GetTouchResponse=function(){var e=this._diagram.getOptions();return"none"!==e.panning||"none"!==e.zooming?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:e.touchResponse===t.EventManager.TOUCH_RESPONSE_TOUCH_START?t.EventManager.TOUCH_RESPONSE_TOUCH_START:t.EventManager.TOUCH_RESPONSE_AUTO},h.prototype.HandleTouchClickInternal=function(e){return this.GetEventInfo(e,t.PanZoomCanvasEventManager.EVENT_INFO_PANNED_KEY)},h.prototype.StoreInfoByEventType=function(e){return e!=t.PanZoomCanvasEventManager.EVENT_INFO_PANNED_KEY&&h.superclass.StoreInfoByEventType.call(this,e)},h.prototype.isDndSupported=function(){return!0},h.prototype.GetDragSourceType=function(t){var e,i=this.DragSource.getDragObject();return i&&i.__dragType?i.__dragType:i instanceof p?(null===this._linkDragSelector&&(this._linkDragSelector=this._diagram.getOptions().dnd.drag.ports.selector),this._linkDragSelector&&(e=this._getPortElement(document.elementFromPoint(t.getNativeEvent().clientX,t.getNativeEvent().clientY),this._linkDragSelector))&&(this.LinkCreationStarted=!0,i.__dragPort=e),i.__dragType=e?"ports":"nodes",i.__dragType):null},h.prototype.GetDragDataContexts=function(e){var i=this.DragSource.getDragObject();if(this._diagram.isSelectionSupported()&&this._diagram.getSelectionHandler().getSelectedCount()>1){for(var o=this._diagram.getSelectionHandler().getSelection(),n=this._getTopLeftContentCorner(o),a=this._diagram.getPanZoomCanvas().getZoom(),s=[],r=0;r<o.length;r++)if(o[r]instanceof p){var d=o[r].getDataContext(),h=o[r].getDimensions(this._context.getStage());d.nodeOffset=new t.Point((h.x-n.x)/a,(h.y-n.y)/a),e&&t.ToolkitUtils.cleanDragDataContext(d),s.push(d)}return s}if(i instanceof p){d=i.getDataContext();return e&&t.ToolkitUtils.cleanDragDataContext(d),"ports"===i.__dragType&&i.__dragPort?e?{dataContext:d}:{dataContext:d,portElement:i.__dragPort}:(d.nodeOffset=new t.Point(0,0),[d])}return[]},h.prototype.GetDropOffset=function(e){var i;if(this._diagram.isSelectionSupported()&&this._diagram.getSelectionHandler().getSelectedCount()>1)i=this._getTopLeftContentCorner(this._diagram.getSelectionHandler().getSelection());else{var o=this.DragSource.getDragObject();o instanceof p&&(i=o.getDimensions(this._context.getStage()))}if(i){var n=this._context.pageToStageCoords(e.pageX,e.pageY),a=this._diagram.getPanZoomCanvas().getZoom();return new t.Point((i.x-n.x)/a,(i.y-n.y)/a)}return null},h.prototype._getTopLeftContentCorner=function(e){if(!e)return null;for(var i=Number.MAX_VALUE,o=Number.MAX_VALUE,n=0;n<e.length;n++)if(e[n]instanceof p){var a=e[n].getDimensions(this._context.getStage());i=a?Math.min(a.x,i):i,o=a?Math.min(a.y,o):o}return new t.Point(i,o)},h.prototype.OnDndDragStart=function(t){var e=this.DragSource.getDragObject();e&&e.__dragType&&(e.__dragType=null,e.__dragPort=null),this.LinkCreationStarted=!1,h.superclass.OnDndDragStart.call(this,t)},h.prototype.OnDndDragOver=function(t){h.superclass.OnDndDragOver.call(this,t),this.LinkCreationStarted&&this._diagram.ShowLinkCreationFeedback(t)},h.prototype.OnDndDragEnd=function(t){h.superclass.OnDndDragEnd.call(this,t),this.LinkCreationStarted&&(this._diagram.HideLinkCreationFeedback(),this.LinkCreationStarted=!1),this._diagram.getPanZoomCanvas().panZoomEnd(),this._setPanningEnabled(!0)},h.prototype._setPanningEnabled=function(t){this._diagram.IsPanningEnabled()&&this._diagram.getPanZoomCanvas().setPanningEnabled(t)},h.prototype.IsDragSupported=function(){if(!this._isDragSupported){var t=this._diagram.getOptions();this._isDragSupported=this.isDndSupported()&&(t.dnd.drag.nodes.dataTypes||t.dnd.drag.ports.dataTypes)}return this._isDragSupported},h.prototype.OnMouseDown=function(t){var e=this.GetLogicalObject(t.target);this.IsDragSupported()&&e instanceof p&&this._setPanningEnabled(!1),h.superclass.OnMouseDown.call(this,t)},h.prototype.OnMouseUp=function(t){h.superclass.OnMouseUp.call(this,t),this._setPanningEnabled(!0)},h.prototype.HandleImmediateTouchStartInternal=function(t){this.IsDragSupported()&&1==t.targetTouches.length&&(this.GetLogicalObject(t.target)instanceof p&&this._setPanningEnabled(!1))},h.prototype.HandleImmediateTouchEndInternal=function(t){this.IsDragSupported()&&this._setPanningEnabled(!0)},h.prototype.GetDropTargetType=function(t){var e,i=this.GetLogicalObject(t.target);return this._diagram.getCache().putToCache("dropTarget",i),i?i instanceof p?(null===this._linkDropSelector&&(this._linkDropSelector=this._diagram.getOptions().dnd.drop.ports.selector),this._linkDropSelector&&(e=this._getPortElement(t.getNativeEvent().target,this._linkDropSelector)),i.__dropPort=e,e?"ports":"nodes"):i instanceof g?"links":null:"background"},h.prototype.GetDropEventPayload=function(e){var i=e.getNativeEvent().dataTransfer,o=Number(i.getData(t.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,n=Number(i.getData(t.EventManager.DROP_OFFSET_Y_DATA_TYPE))||0,a=this._diagram.getPanZoomCanvas().getContentPane().stageToLocal(this.getCtx().pageToStageCoords(e.pageX,e.pageY)),s=this._diagram.getLayoutOffset(),r={x:a.x-s.x+o,y:a.y-s.y+n},d=this.GetLogicalObject(e.target);if(d instanceof p){d.__dropPort?(r.dataContext=d.getDataContext(),r.portElement=d.__dropPort):r.nodeContext=d.getDataContext();var h=d.getDimensions(this._context.getStage()),l=h?this._diagram.getPanZoomCanvas().getContentPane().stageToLocal({x:h.x,y:h.y}):null;r.nodeX=l?a.x-l.x+o:null,r.nodeY=l?a.y-l.y+n:null}else d instanceof g&&(r.linkContext=d.getDataContext());return r},h.prototype.ShowDropEffect=function(e){var i=this.GetDropTargetType(e),o=this._diagram.getCache().getFromCache("dropTarget");"background"===i?this._diagram.getPanZoomCanvas().getBackgroundPane().setClassName("oj-active-drop"):"nodes"===i||"links"===i?o&&o.ShowDropEffect&&o.ShowDropEffect():o&&"ports"===i&&o.__dropPort&&t.ToolkitUtils.addClassName(o.__dropPort,"oj-active-drop")},h.prototype.ShowRejectedDropEffect=function(e){var i=this.GetDropTargetType(e),o=this._diagram.getCache().getFromCache("dropTarget");"background"===i?this._diagram.getPanZoomCanvas().getBackgroundPane().setClassName("oj-invalid-drop"):"nodes"===i||"links"===i?o&&o.ShowRejectedDropEffect&&o.ShowRejectedDropEffect():o&&"ports"===i&&o.__dropPort&&t.ToolkitUtils.addClassName(o.__dropPort,"oj-invalid-drop")},h.prototype.ClearDropEffect=function(){this._diagram.getPanZoomCanvas().getBackgroundPane().setClassName(null);var e=this._diagram.getCache().getFromCache("dropTarget");e&&e.ClearDropEffect&&e.ClearDropEffect(),e&&e.__dropPort&&(t.ToolkitUtils.removeClassName(e.__dropPort,"oj-active-drop"),t.ToolkitUtils.removeClassName(e.__dropPort,"oj-invalid-drop")),this._diagram.getCache().putToCache("dropTarget",null)},h.prototype._getPortElement=function(t,e){return t&&t.closest?t.closest(e):null};var l=function(t,e){this.Init(t,e)};t.Obj.createSubclass(l,t.BaseDiagramKeyboardHandler,"DvtDiagramKeyboardHandler"),l.prototype.isNavigationEvent=function(e){var i=!1;switch(e.keyCode){case t.KeyboardEvent.OPEN_BRACKET:case t.KeyboardEvent.CLOSE_BRACKET:i=!0;break;case t.KeyboardEvent.OPEN_ANGLED_BRACKET:case t.KeyboardEvent.CLOSE_ANGLED_BRACKET:i=!!e.altKey;break;default:i=l.superclass.isNavigationEvent.call(this,e)}return i},l.prototype.processKeyDown=function(e){if(e.keyCode==t.KeyboardEvent.TAB){var i=this._eventManager.getFocus();if(i)return t.EventManager.consumeEvent(e),i;var o=this.GetDiagram().GetRootNodeObjects();if(o.length>0){t.EventManager.consumeEvent(e);var n=this.getDefaultNavigable(o);return this.GetDiagram().ensureObjInViewport(e,n),n}}return l.superclass.processKeyDown.call(this,e)},l.prototype.GetVisibleNode=function(t){return this.GetDiagram().getNodeById(t)};var g=function(t,e,i,o){this.Init(t,e,i,o)};t.Obj.createSubclass(g,t.BaseDiagramLink,"DvtDiagramLink"),g.CUSTOM_STYLE="customStyle",g.newInstance=function(t,e,i){return new g(t.getCtx(),t,e,i)},g.prototype.Init=function(e,i,o,n){g.superclass.Init.call(this,e,o.id,i),this._data=o,this._isHighlighted=!0,this.setPromoted(n),this.isSelectable()&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.setGroupId(g._getCommonAncestorId(this,i))},g.prototype.getData=function(){return this._data},g.prototype.setData=function(t){this._data=t},g.prototype.getId=function(){return this.getData().id},g.prototype.getStartId=function(){return this.getData().startNode},g.prototype.getEndId=function(){return this.getData().endNode},g.prototype.getLabelBounds=function(){var t=null;return this._labelObj&&(t=this._labelObj.getDimensions()),t},g.prototype.getLinkStyle=function(){return this.getData().svgStyle||this.getData().style},g.prototype.getLinkWidth=function(){return this.getData().width},g.prototype.getLinkColor=function(){return this.getData().color},g.prototype.getStartConnectorType=function(){return this.getData().startConnectorType},g.prototype.getEndConnectorType=function(){return this.getData().endConnectorType},g.prototype.getStartConnectorOffset=function(){return this.getStartConnectorType()?t.DiagramLinkConnectorUtils.getStandardConnectorOffset(this.getStartConnectorType(),this.GetAppliedLinkWidth(),this.GetAppliedLinkWidth()):0},g.prototype.getEndConnectorOffset=function(){return this.getEndConnectorType()?t.DiagramLinkConnectorUtils.getStandardConnectorOffset(this.getEndConnectorType(),this.GetAppliedLinkWidth(),this.GetAppliedLinkWidth()):0},g.prototype.render=function(){var e=this.GetDiagram(),i=this.getGroupId(),o=e.getNodeById(this.getStartId()).getGroupId(),n=e.getNodeById(this.getEndId()).getGroupId();if(i){var a=this.getCtx(),s=e.getNodeById(i).GetChildNodePane();t.BaseDiagram.compareValues(a,i,o)&&t.BaseDiagram.compareValues(a,i,n)?s.addChildAt(this,0):s.addChild(this)}else o||n?e.getNodesPane().addChild(this):e.getLinksPane().addChild(this);g._renderLinkLabels(e,this.getData(),this),this.setAriaRole("img"),this.UpdateAriaLabel(),this._diagram.getEventManager().associate(this,this)},g.prototype.setPoints=function(t){!this._pathCmds&&t&&g._renderLinkShape(this.GetDiagram(),this.getData(),this),g.superclass.setPoints.call(this,t)},g._renderLinkShape=function(e,i,o){var n=o._pathCmds;n||(n=["M",0,0,"L",0,0]);var a=i.id,s=i.color,r=i.width,d=i.svgStyle||i.style,h=i._hitDetectionOffset;o._hitDetectionUnderlay=o.CreateUnderlay("#000000",0,h),o.addChildAt(o._hitDetectionUnderlay,0);var l,p=new t.Path(o.getCtx(),n,a),c=i.svgClassName||i.className;if(p.setFill(null),p.setClassName(c),o.getCtx().isCustomElement())p.setStyle(d);else if(d&&d instanceof Object){d._type==g.CUSTOM_STYLE&&d.strokeDasharray&&(d.strokeDasharray=t.DiagramLinkUtils.processStrokeDashArray(d.strokeDasharray)),l={dashArray:d.strokeDasharray,dashOffset:d.strokeDashoffset};var u=t.JsonUtils.clone(d);["_type","strokeDasharray","strokeDashoffset"].forEach(function(t){delete u[t]}),p.setStyle(u)}else"solid"!==d&&(l={dashArray:t.DiagramLinkUtils.GetStrokeDash(d),dashOffset:t.DiagramLinkUtils.GetStrokeDashOffset(d)});var _=new t.Stroke(s,1,r,!0,l);p.setStroke(_),o.setShape(p),o.addChildAt(p,1)},g._renderLinkLabels=function(e,i,o){var n=i.label;if(n){var a=t.Agent.isRightToLeft(e.getCtx()),s=n.indexOf("\n")>0,r=s?a?t.MultilineText.H_ALIGN_RIGHT:t.MultilineText.H_ALIGN_LEFT:a?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT,d=s?t.MultilineText.V_ALIGN_TOP:t.OutputText.V_ALIGN_TOP,h=g.createText(e.getCtx(),n,i.labelStyle,r,d,s),l=i.labelStyle.getMaxWidth()||i.labelStyle.getWidth(),p=t.CSSStyle.toNumber(l);l?p>0&&t.TextUtils.fitText(h,p,1/0,o)&&(o._labelObj=h):(o.addChild(h),o._labelObj=h)}},g.createText=function(e,i,o,n,a,s){var r;return o.hasBackgroundStyles()?r=s?new t.BackgroundMultilineText(e,i,0,0,o,null,!0):new t.BackgroundOutputText(e,i,0,0,o):(r=s?new t.MultilineText(e,i,0,0,null,!0):new t.OutputText(e,i,0,0)).setCSSStyle(o),r.setHorizAlignment(n),r.setVertAlignment(a),r},g.prototype.setSelected=function(t){g.superclass.setSelected.call(this,t),t?this._showFeedback(this._isShowingHoverEffect,!0):this._hideFeedback(),this.UpdateAriaLabel()},g.prototype.isSelectable=function(){return this.GetDiagram().isSelectionSupported()&&"off"!=this.getData().selectable},g.prototype._showFeedback=function(e,i){if(e){this._savedStroke||(this._savedStroke=this.getShape().getStroke());var o=this.getShape().getStroke(),n=new t.Stroke(this.getData().hoverInnerColor,o.getAlpha(),o.getWidth(),o.isFixedWidth(),o.getDashProps());this.getShape().setStroke(n),this.ReplaceConnectorColor(this.getStartConnector(),n),this.ReplaceConnectorColor(this.getEndConnector(),n)}else this._savedStroke&&(this.getShape().setStroke(this._savedStroke),this.ReplaceConnectorColor(this.getStartConnector(),this._savedStroke),this.ReplaceConnectorColor(this.getEndConnector(),this._savedStroke),this._savedStroke=null);this._linkUnderlay||(this._linkUnderlay=this.CreateFeedbackUnderlay("#000000",1,0,this.getData().svgStyle,this.getData().svgClassName),this.addChildAt(this._linkUnderlay,0));var a=i?this.getData().selectionColor:this.getData().hoverOuterColor,s=this._linkUnderlay.getStroke(),r=2+this.GetAppliedLinkWidth(),d=this.GetStyledLinkStroke(s,a,r);this._linkUnderlay.setStroke(d,2)},g.prototype._hideFeedback=function(){this._savedStroke&&(this.getShape().setStroke(this._savedStroke),this.ReplaceConnectorColor(this.getStartConnector(),this._savedStroke),this.ReplaceConnectorColor(this.getEndConnector(),this._savedStroke),this._savedStroke=null),this._linkUnderlay&&(this.removeChild(this._linkUnderlay),this._linkUnderlay.destroy&&this._linkUnderlay.destroy(),this._linkUnderlay=null)},g.prototype.GetStyledLinkStroke=function(e,i,o){if(this.getCtx().isCustomElement())return new t.Stroke(i,e.getAlpha(),o,e.isFixedWidth());var n=this.GetAppliedLinkStyle();if(n&&n instanceof Object){var a,s=n._type;if(s==g.CUSTOM_STYLE){var r=null!=n.strokeDashoffset?t.CSSStyle.toNumber(n.strokeDashoffset)+1:1;a={dashArray:t.DiagramLinkUtils.getCustomUnderlay(n.strokeDasharray),dashOffset:r}}else a={dashArray:t.DiagramLinkUtils.GetStrokeDash(s,!0),dashOffset:t.DiagramLinkUtils.GetStrokeDashOffset(s,!0)};return new t.Stroke(i,e.getAlpha(),o,!0,a)}return g.superclass.GetStyledLinkStroke.call(this,e,i,o)},g.prototype.showHoverEffect=function(){this._isShowingHoverEffect||(this._isShowingHoverEffect=!0,this._showFeedback(!0,this.isSelected()))},g.prototype.hideHoverEffect=function(){this.isSelected()?this._showFeedback(!1,!0):this._hideFeedback(),this._isShowingHoverEffect=!1},g.prototype.highlight=function(t){if(this._isHighlighted!==t){var e=t?1:this._diagram.getOptions().styleDefaults._highlightAlpha;this.setAlpha(e),this._isHighlighted=t}},g.prototype.getDatatip=function(t,e,i){var o=this.GetDiagram().getOptions().tooltip,n=o?o.renderer:null;return n?this.GetDiagram().getCtx().getTooltipManager().getCustomTooltip(n,this.getDataContext()):this.getShortDesc()},g.prototype.getShortDesc=function(){var e=this.GetDiagram().getOptions().translations;if(this.isPromoted()){var i=this.getData()._links.length;return t.ResourceUtils.format(e[i>1?"promotedLinks":"promotedLink"],[i])}return this.getData().shortDesc},g.prototype.getDataContext=function(){var t,e;this.GetDiagram().isDataProviderMode()?this.isPromoted()?(t=this.getData()._links.map(function(t){return t._itemData}),e=this.getData()._links[0]._noTemplate?t:this.getData()._links):(e=this.getData(),t=this.getData()._itemData):e=this.isPromoted()?this.getData()._links:this.getData()._itemData;var i={id:this.getId(),type:this.isPromoted()?"promotedLink":"link",label:this.getData().label,data:e,itemData:t,component:this.GetDiagram().getOptions()._widgetConstructor};return this.getCtx().fixRendererContext(i)},g.prototype.getAriaLabel=function(){var e=[],i=this.GetDiagram().getOptions().translations;return this.isSelectable()&&e.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),this.isPromoted()&&e.push(i.promotedLinkAriaDesc),t.Displayable.generateAriaLabel(this.getShortDesc(),e)},g.prototype.UpdateAriaLabel=function(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty("label",e)}},g.prototype.getNextNavigable=function(e){if(e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;if(e.keyCode==t.KeyboardEvent.UP_ARROW||e.keyCode==t.KeyboardEvent.DOWN_ARROW){(s=this.getKeyboardFocusNode())||(s=this.GetDiagram().getNodeById(this.getStartId()));var i=this,o=this.GetDiagram().getNavigableLinksForNodeId(s.getId()),n=this.GetDiagram().getEventManager().getKeyboardHandler();return n&&n.getNextNavigableLink&&(i=n.getNextNavigableLink(s,this,e,o)),i.setKeyboardFocusNode(s),this._diagram.ensureObjInViewport(e,i),i}if(e.keyCode==t.KeyboardEvent.RIGHT_ARROW||e.keyCode==t.KeyboardEvent.LEFT_ARROW){var a;a=this._movingToStart(e.keyCode)?this.getStartId():this.getEndId();var s=this.GetDiagram().getNodeById(a);return this._diagram.ensureObjInViewport(e,s),s}return e.type==t.MouseEvent.CLICK?this:null},g.prototype._movingToStart=function(e){var i=this.getLinkStart(),o=this.getLinkEnd(),n=i.x<o.x;return!(e==t.KeyboardEvent.RIGHT_ARROW&&n||e==t.KeyboardEvent.LEFT_ARROW&&!n)},g.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect()},g.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()},g.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},g.prototype.getCategories=function(){return this.getData().categories?this.getData().categories:[this.getId()]},g.prototype.isHidden=function(){var e=this.GetDiagram().getOptions().hiddenCategories;return!(!e||!t.ArrayUtils.hasAnyItem(e,this.getCategories()))||(!this.GetDiagram().getNodeById(this.getStartId())||!this.GetDiagram().getNodeById(this.getEndId()))},g.prototype.animateUpdate=function(e,i,o){var n=i.getPoints(),a=this.getPoints(),s=new t.CustomAnimation(this.getCtx(),null,e.getAnimationDuration());if(!t.ArrayUtils.equals(n,a)){this.setPoints(n);var r=t.Animator.TYPE_POLYLINE;a.length>0&&isNaN(a[0])&&(r=t.Animator.TYPE_PATH),s.getAnimator().addProp(r,this,this.getPoints,this.setPoints,a)}if(i._labelObj&&this._labelObj){var h=i._labelObj.getMatrix(),l=this._labelObj.getMatrix();h.equals(l)||(this._labelObj.setMatrix(h),s.getAnimator().addProp(t.Animator.TYPE_MATRIX,this._labelObj,this._labelObj.getMatrix,this._labelObj.setMatrix,l))}if(i.getShape()&&this.getShape()){var g=i.getShape().getStroke(),p=this.getShape().getStroke();g&&p&&g instanceof t.Stroke&&p instanceof t.Stroke&&(g.getColor()!=p.getColor()||g.getWidth()!=p.getWidth())&&(this.getShape().setStroke(g),s.getAnimator().addProp(t.Animator.TYPE_STROKE,this.getShape(),this.getShape().getStroke,this.getShape().setStroke,p))}if(o){var c=this;t.Playable.appendOnEnd(s,function(){c.getParent().removeChild(c)})}e.add(s,d.UPDATE)},g.prototype.animateDelete=function(e,i){this.GetDiagram().getLinksPane().addChild(this);var o=this,n=new t.AnimFadeOut(this.getCtx(),this,e.getAnimationDuration());t.Playable.appendOnEnd(n,function(){o.getParent().removeChild(o),o.destroy()}),e.add(n,d.DELETE)},g.prototype.animateInsert=function(e){this.setAlpha(0),e.add(new t.AnimFadeIn(this.getCtx(),this,e.getAnimationDuration()),d.INSERT)},g.prototype.animateCollapse=function(e,i){if(i&&0!=i.length){var o=this.getPoints().slice();this.animateUpdate(e,i[0]);for(var n=1;n<i.length;n++){var a={id:"_fakeLink"+n+this.getId()};a=t.JsonUtils.merge(a,this.getData());var s=new g(this.GetDiagram().getCtx(),this.GetDiagram(),a,!0);s.render(),s.setPoints(o),s.animateUpdate(e,i[n],!0)}}},g.prototype.animateExpand=function(t,e){if(e&&0!=e.length)for(var i=0;i<e.length;i++)e[i].animateUpdate(t,this)},g.prototype.setLabelAlignments=function(e,i){var o=this._labelObj instanceof t.MultilineText||this._labelObj instanceof t.BackgroundMultilineText;"baseline"==i&&(i=o?t.MultilineText.V_ALIGN_TOP:t.OutputText.V_ALIGN_AUTO),this._labelObj.setHorizAlignment(e),this._labelObj.setVertAlignment(i)},g.prototype.setGroupId=function(t){this._groupId=t},g.prototype.getGroupId=function(){return this._groupId},g._getCommonAncestorId=function(t,e){for(var i=function(t,e){for(var i=[],o=e.getNodeById(t)?e.getNodeById(t).getGroupId():null;o;)i.push(o),o=e.getNodeById(o)?e.getNodeById(o).getGroupId():null;return i},o=i(t.getStartId(),e),n=i(t.getEndId(),e),a=0;a<o.length;a++)if(n.indexOf(o[a])>-1)return o[a];return null},g.GetPromotedLinkId=function(t,e,i){return t.isDataProviderMode()?{name:"_promoted",startId:e,endId:i}:"_plL"+e+"_L"+i},g.prototype.ShowDropEffect=function(){this._dropEffect||this._createDropEffect("oj-diagram-link oj-active-drop")},g.prototype.ShowRejectedDropEffect=function(){this._dropEffect||this._createDropEffect("oj-diagram-link oj-invalid-drop")},g.prototype.ClearDropEffect=function(){this._dropEffect&&(this.removeChild(this._dropEffect),this._dropEffect=null)},g.prototype._createDropEffect=function(t){var e=this.getData()._hitDetectionOffset;this._dropEffect=this.CreateFeedbackUnderlay("#000000",0,e,null,t),this._dropEffect.setMouseEnabled(!1),this.addChild(this._dropEffect)},g.ConvertLinkData=function(t){return{id:t.id,startNode:t.startNode,endNode:t.endNode,label:t.label,selectable:t.selectable,shortDesc:t.shortDesc,categories:t.categories,_itemData:t}},g.prototype.getAnimationState=function(){var t,e,i;this._labelObj&&((t={matrix:this._labelObj.getMatrix()}).getMatrix=function(){return t.matrix}),this.getShape()&&((e={stroke:this.getShape().getStroke()}).getStroke=function(){return e.stroke});var o=this.isPromoted()?this.getData()._links:null;return(i={partialUpdate:!0,id:this.getId(),promoted:this.isPromoted(),includedLinks:o,points:this.getPoints(),shape:e,_labelObj:t}).getId=function(){return i.id},i.isPromoted=function(){return i.promoted},i.getData=function(){return{_links:i.includedLinks}},i.getPoints=function(){return i.points},i.getShape=function(){return i.shape},i};var p=function(t,e,i){this.Init(t,e,i)};t.Obj.createSubclass(p,t.BaseDiagramNode,"DvtDiagramNode"),p.newInstance=function(t,e){return new p(t.getCtx(),t,e)},p.prototype.Init=function(e,i,o){p.superclass.Init.call(this,e,o.id,i),this._data=o,this._isHighlighted=!0,this.isSelectable()&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor())},p.prototype.getData=function(){return this._data},p.prototype.setData=function(t){this._data=t},p.prototype.getId=function(){return this._data.id},p.prototype.getContentBounds=function(t){return!this._contentDims&&t&&(this._contentDims=this._calcContentDims()),this._contentDims},p.prototype.getLabelBounds=function(t){var e=null;return this._labelObj&&t&&(e=this._labelObj.getDimensions()),e},p.prototype.setSelected=function(t){var e=this._getState();p.superclass.setSelected.call(this,t),this._diagram.getOptions().selectionRenderer?this._applyCustomNodeContent(this._diagram.getOptions().selectionRenderer,this._getState(),e):this.processDefaultSelectionEffect(t),this.UpdateAriaLabel()},p.prototype.processDefaultSelectionEffect=function(t){this.getSelectionShape()&&this.getSelectionShape().setSelected(t)},p.prototype.isSelectable=function(){return this.GetDiagram().isSelectionSupported()&&"off"!=this.getData().selectable},p.prototype.GetIcon=function(){return this._shape},p.prototype.render=function(){this._cleanUp();var t=this.getData();if(this._diagram.getOptions().renderer){if(this._applyCustomNodeContent(this._diagram.getOptions().renderer,this._getState(),null),this.isDisclosed()){var e=this.GetDiagram().getPanZoomCanvas().getZoom(),i=this.getElem().getBoundingClientRect(),o=this._childNodePane?this._childNodePane.getElem().getBoundingClientRect():null;this._containerPadding={left:(o.left-i.left)/e,right:(i.right-o.right)/e,top:(o.top-i.top)/e,bottom:(i.bottom-o.bottom)/e}}this._selectionShape&&(this.removeChild(this._selectionShape),this._selectionShape=null)}else this.isDisclosed()?p._renderContainer(this._diagram,t,this):(p._renderNodeBackground(this._diagram,t,this),p._renderNodeIcon(this._diagram,t,this)),p._addHoverSelectionDefaultStrokes(this.getSelectionShape(),t);p._renderNodeLabels(this._diagram,t,this),this._setDraggableStyleClass(),p._renderContainerButton(this._diagram,t,this),this.setAriaRole("img"),this.UpdateAriaLabel(),this._diagram.getEventManager().associate(this,this)},p.prototype._applyCustomNodeContent=function(e,i,o){var n=this._diagram.getOptions()._contextHandler;if(n){var a=this.getDataContext(),s=null;if(this.isDisclosed()){var r=this.GetChildNodePane(),d=r.getDimensions();s={element:r.getElem(),w:d?d.w-d.x:null,h:d?d.h-d.y:null}}var h=e(n(this.getElem(),this._customNodeContent,s,a,i,o));!h&&this._customNodeContent&&this.getCtx().isCustomElement()||(this._customNodeContent&&h!=this._customNodeContent&&(this._customNodeContent.namespaceURI===t.ToolkitUtils.SVG_NS?this.getContainerElem().removeChild(this._customNodeContent):Array.isArray(this._customNodeContent)?this._customNodeContent.forEach(function(t){this.getContainerElem().removeChild(t)}.bind(this)):this.removeChild(h),this._customNodeContent=null),h&&h.namespaceURI===t.ToolkitUtils.SVG_NS?this._customNodeContent||(t.ToolkitUtils.appendChildElem(this.getContainerElem(),h),this._customNodeContent=h):h&&Array.isArray(h)?this._customNodeContent||(h.forEach(function(e){t.ToolkitUtils.appendChildElem(this.getContainerElem(),e)}.bind(this)),this._customNodeContent=h):h instanceof t.BaseComponent?this._customNodeContent||(this.addChild(h),this._customNodeContent=h):h&&this._diagram.Log("dvt.Diagram: could not add custom node content for the node "+this.getId()+h,1))}else this._diagram.Log("dvt.Diagram: could not add custom node content - context handler is undefined",1)},p._renderNodeBackground=function(e,i,o){if(!e.getCtx().isCustomElement()){var n=i.backgroundSvgStyle||i.backgroundStyle,a=t.JsonUtils.clone(n),s=[t.CSSStyle.WIDTH,t.CSSStyle.HEIGHT,t.CSSStyle.BACKGROUND_COLOR,t.CSSStyle.BORDER_COLOR,t.CSSStyle.BORDER_WIDTH,t.CSSStyle.BORDER_RADIUS];if(!(n=p._getNodeCSSStyle(a,i._backgroundStyle,s)).isEmpty()){var r=t.CSSStyle.toNumber(n.getStyle(t.CSSStyle.WIDTH)),d=t.CSSStyle.toNumber(n.getStyle(t.CSSStyle.HEIGHT)),h=n.getStyle(t.CSSStyle.BACKGROUND_COLOR),l=n.getStyle(t.CSSStyle.BORDER_COLOR),g=t.CSSStyle.toNumber(n.getStyle(t.CSSStyle.BORDER_WIDTH)),c=t.CSSStyle.toNumber(n.getStyle(t.CSSStyle.BORDER_RADIUS)),u=new t.Rect(e.getCtx(),0,0,r,d);u.setSolidFill(h),c&&(u.setRx(c),u.setRy(c)),l&&u.setStroke(new t.Stroke(l,1,g)),a&&s.forEach(function(e){delete a[t.CSSStyle.cssStringToObjectProperty(e)]});var _=i.backgroundSvgClassName||i.backgroundClassName;u.setStyle(a).setClassName(_),o.addChild(u),o.setSelectionShape(u),o._background=u}}},p._renderNodeIcon=function(e,i,o){var n=i.icon;if(n){var a,s=n.width,r=n.height,d=n.color,h=n.borderRadius;a=n.source?new t.ImageMarker(e.getCtx(),s/2,r/2,s,r,h,n.source,n.sourceSelected,n.sourceHover,n.sourceHoverSelected):new t.SimpleMarker(e.getCtx(),n.shape,s/2,r/2,s,r,h),"none"!=n.fillPattern?a.setFill(new t.PatternFill(n.fillPattern,d,d)):a.setSolidFill(d),null!=n.opacity&&a.setAlpha(n.opacity),n.borderColor&&a.setStroke(new t.Stroke(n.borderColor,1,n.borderWidth));var l=n.svgStyle||n.style,g=n.svgClassName||n.className;a.setStyle(l).setClassName(g),o.addChild(a),o._shape=a,p._setIconPosition(e,i,o),o._background||o.setSelectionShape(a)}},p._setIconPosition=function(e,i,o){if(o._background){var n=i.icon,a=o._background.getWidth(),s=o._background.getHeight(),r=n.width,d=n.height,h=.5*(a-r),l=.5*(s-d);if(void 0!==n.positionX)h=parseFloat(n.positionX),t.Agent.isRightToLeft(o.getCtx())&&(h=a-h-r);else{var g=n.halign;"start"==g?g=t.Agent.isRightToLeft(o.getCtx())?"right":"left":"end"==g&&(g=t.Agent.isRightToLeft(o.getCtx())?"left":"right"),h="left"==g?0:"right"==g?a-r:h}void 0!==n.positionY?l=parseFloat(n.positionY):"top"==n.valign?l=0:"bottom"==n.valign&&(l=s-d),o._shape.setTranslate(h,l)}},p._renderNodeLabels=function(e,i,o){var n=i.label;if(n){var a=t.Agent.isRightToLeft(e.getCtx()),s=n.indexOf("\n")>0,r=s?a?t.MultilineText.H_ALIGN_RIGHT:t.MultilineText.H_ALIGN_LEFT:a?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT,d=s?t.MultilineText.V_ALIGN_TOP:t.OutputText.V_ALIGN_TOP,h=p.createText(e.getCtx(),n,i.labelStyle,r,d,s),l=i.labelStyle.getMaxWidth()||i.labelStyle.getWidth(),g=t.CSSStyle.toNumber(l);l?g>0&&t.TextUtils.fitText(h,g,1/0,o)&&(o._labelObj=h):(o.addChild(h),o._labelObj=h)}},p.createText=function(e,i,o,n,a,s){var r;return o.hasBackgroundStyles()?r=s?new t.BackgroundMultilineText(e,i,0,0,o,null,!0):new t.BackgroundOutputText(e,i,0,0,o):(r=s?new t.MultilineText(e,i,0,0,null,!0):new t.OutputText(e,i,0,0)).setCSSStyle(o),r.setHorizAlignment(n),r.setVertAlignment(a),r},p._addHoverSelectionDefaultStrokes=function(e,i){var o=i.hoverInnerColor,n=i.hoverOuterColor,a=i.selectionColor,s=new t.Stroke(o,1,4,!0),r=new t.Stroke(n,1,8,!0),d=new t.Stroke(o,1,2,!0),h=new t.Stroke(a,1,6,!0),l=new t.Stroke(o,1,4,!0),g=new t.Stroke(a,1,8,!0);e.setHoverStroke(s,r).setSelectedStroke(d,h).setSelectedHoverStroke(l,g)},p._addHoverSelectionOuterStrokes=function(e,i){var o=i.hoverInnerColor,n=i.hoverOuterColor,a=i.selectionColor,s=new t.Stroke(o,1,2,!0),r=new t.Stroke(n,1,2,!0),d=new t.Stroke(o,1,1,!0),h=new t.Stroke(a,1,2,!0),l=new t.Stroke(o,1,2,!0),g=new t.Stroke(a,1,2,!0);e.setHoverStroke(s,r).setSelectedStroke(d,h).setSelectedHoverStroke(l,g)},p.prototype.setSelectionShape=function(t){this._selectionShape=t},p.prototype.getSelectionShape=function(){if(!this._selectionShape){var e=this.getContentBounds(!0);if(e){var i=new t.Rect(this._diagram.getCtx(),e.x,e.y,e.w,e.h);i.setInvisibleFill(),i.setStrokeAlignment("outer"),this.setSelectionShape(i),this.addChildAt(i,0),p._addHoverSelectionOuterStrokes(i,this.getData()),this._selectionShape=i}}return this._selectionShape},p.prototype.showHoverEffect=function(){if(!this._isShowingHoverEffect){var t=this._getState();this._isShowingHoverEffect=!0,this._diagram.getOptions().hoverRenderer?this._applyCustomNodeContent(this._diagram.getOptions().hoverRenderer,this._getState(),t):this.processDefaultHoverEffect(!0)}},p.prototype.hideHoverEffect=function(){if(this._isShowingHoverEffect){var t=this._getState();this._isShowingHoverEffect=!1,this._diagram.getOptions().hoverRenderer?this._applyCustomNodeContent(this._diagram.getOptions().hoverRenderer,this._getState(),t):this.processDefaultHoverEffect(!1)}},p.prototype.processDefaultHoverEffect=function(t){this.getSelectionShape()&&(t?this.getSelectionShape().showHoverEffect():this.getSelectionShape().hideHoverEffect())},p.prototype.getDatatip=function(t,e,i){var o=this.GetDiagram().getOptions().tooltip,n=o?o.renderer:null;return n?this.GetDiagram().getCtx().getTooltipManager().getCustomTooltip(n,this.getDataContext()):this.getShortDesc()},p.prototype.getShortDesc=function(){return this.getData().shortDesc},p.prototype.getDataContext=function(){var t=this.getData(),e={id:this.getId(),type:"node",label:t.label,data:this.GetDiagram().isDataProviderMode()?t._noTemplate?t._itemData:t:t._itemData,itemData:this.GetDiagram().isDataProviderMode()?t._itemData:null,component:this.GetDiagram().getOptions()._widgetConstructor};return this.getCtx().fixRendererContext(e)},p.prototype.getAriaLabel=function(){var e=[],i=this.GetDiagram().getOptions().translations;return this.isSelectable()&&e.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),this.isContainer()&&e.push(i[this.isDisclosed()?"stateExpanded":"stateCollapsed"]),t.Displayable.generateAriaLabel(this.getShortDesc(),e)},p.prototype.UpdateAriaLabel=function(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty("label",e)}},p.prototype.getNextNavigable=function(e){var i=null;if(e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey)i=this;else if((e.keyCode==t.KeyboardEvent.OPEN_ANGLED_BRACKET||t.KeyboardEvent.CLOSE_ANGLED_BRACKET)&&e.altKey){var o=this.GetDiagram().getNavigableLinksForNodeId(this.getId()),n=this.GetDiagram().getEventManager().getKeyboardHandler();n&&n.getFirstNavigableLink&&(i=n.getFirstNavigableLink(this,e,o)),i?i.setKeyboardFocusNode(this):i=this}else if(e.keyCode==t.KeyboardEvent.OPEN_BRACKET){if(this.isDisclosed())i=this.getChildNodes()[0];else i=this}else if(e.keyCode==t.KeyboardEvent.CLOSE_BRACKET){i=(a=this.getGroupId()?this.GetDiagram().getNodeById(this.getGroupId()):null)||this}else if(e.type==t.MouseEvent.CLICK)i=this;else{var a,s=(a=this.getGroupId()?this.GetDiagram().getNodeById(this.getGroupId()):null)?a.getChildNodes():this.GetDiagram().GetRootNodeObjects();i=t.KeyboardHandler.getNextAdjacentNavigable(this,e,s)}return e instanceof t.KeyboardEvent&&this._diagram.ensureObjInViewport(e,i),i},p.prototype.HandleKeyboardEvent=function(e){e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey&&e.shiftKey&&this.isContainer()&&this.GetDiagram().setNodeDisclosed(this.getId(),!this.isDisclosed())},p.prototype.isContainer=function(){if(this._diagram.isTreeDataProvider()){var t=this._diagram.getOptions().nodeData.getChildDataProvider(this.getId());return!!t&&"yes"!==t.isEmpty()}return!this._diagram.isDataProviderMode()&&0!=this.GetDiagram().getOptions().data.getChildCount(this.getData())},p.prototype.showKeyboardFocusEffect=function(){if(!this.isShowingKeyboardFocusEffect()){var t=this._getState();this._isShowingKeyboardFocusEffect=!0,this._diagram.getOptions().focusRenderer?this._applyCustomNodeContent(this._diagram.getOptions().focusRenderer,this._getState(),t):this.processDefaultFocusEffect(!0)}},p.prototype.hideKeyboardFocusEffect=function(){if(this.isShowingKeyboardFocusEffect()){var t=this._getState();this._isShowingKeyboardFocusEffect=!1,this._diagram.getOptions().focusRenderer?this._applyCustomNodeContent(this._diagram.getOptions().focusRenderer,this._getState(),t):this.processDefaultFocusEffect(!1)}},p.prototype.processDefaultFocusEffect=function(t){this.processDefaultHoverEffect(t)},p.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},p.prototype.getCategories=function(){return this.getData().categories?this.getData().categories:[this.getId()]},p.prototype.isHidden=function(){var e=this.GetDiagram().getOptions().hiddenCategories;return!(!e||!t.ArrayUtils.hasAnyItem(e,this.getCategories()))},p.prototype._calcContentDims=function(){var e,i=null;if(this._customNodeContent)if(this._customNodeContent instanceof t.BaseComponent)(e=this._customNodeContent.getDimensions())&&(i=new t.Rectangle(e.x,e.y,e.w,e.h));else{var o=this._customNodeContent;if(Array.isArray(o))for(var n=0;n<o.length;n++)if(o[n].namespaceURI===t.ToolkitUtils.SVG_NS){o=o[n];break}(e=o.getBBox())&&(i=new t.Rectangle(e.x,e.y,e.width,e.height))}else this.isDisclosed()?i=this._containerShape.GetDimensionsWithStroke(this):(i=this._background?this._background.GetDimensionsWithStroke(this):null)&&this._shape?i=i.getUnion(this._shape.GetDimensionsWithStroke(this)):!i&&this._shape&&(i=this._shape.GetDimensionsWithStroke(this));return i},p.prototype.animateUpdate=function(e,i){var o=new t.CustomAnimation(this.getCtx(),null,e.getAnimationDuration());if(this.isDisclosed()||i.isDisclosed())if(this.isDisclosed()&&i.isDisclosed()){if(i._labelObj&&this._labelObj){u=i._labelObj.getMatrix(),_=this._labelObj.getMatrix();u.equals(_)||(this._labelObj.setMatrix(u),o.getAnimator().addProp(t.Animator.TYPE_MATRIX,this._labelObj,this._labelObj.getMatrix,this._labelObj.setMatrix,_))}if(this._diagram.getOptions().renderer)this._animateCustomUpdate(e,i);else{if(p._animatePosition(o,i,this),p._animateContainer(o,i._containerShape,this._containerShape),t.Agent.isRightToLeft(this.getCtx())&&i._containerButton&&this._containerButton){var n=i._containerButton.getTranslateX(),a=this._containerButton.getTranslateX();n!=a&&(this._containerButton.setTranslateX(n),o.getAnimator().addProp(t.Animator.TYPE_NUMBER,this._containerButton,this._containerButton.getTranslateX,this._containerButton.setTranslateX,a))}if(!i.partialUpdate){for(var s=[],r=[],h=this.getChildNodeIds(),l=0;l<h.length;l++)s.push(this.GetDiagram().getNodeById(h[l]));var g=i.getChildNodeIds(),c=e.getOldDiagram().NodesMap;for(l=0;l<g.length;l++)r.push(c.get(g[l]));e.constructAnimation(r,s)}}}else this._animateCustomUpdate(e,i);else{if(p._animatePosition(o,i,this),i._shape&&this._shape&&(o.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,this._shape,this._shape.getCenterDimensions,this._shape.setCenterDimensions,this._shape.getCenterDimensions()),this._shape.setCenterDimensions(i._shape.getCenterDimensions())),i._labelObj&&this._labelObj){var u=i._labelObj.getMatrix(),_=this._labelObj.getMatrix();u.equals(_)||(this._labelObj.setMatrix(u),o.getAnimator().addProp(t.Animator.TYPE_MATRIX,this._labelObj,this._labelObj.getMatrix,this._labelObj.setMatrix,_))}p._animateFill(o,i._background,this._background),p._animateFill(o,i._shape,this._shape)}e.add(o,d.UPDATE)},p.prototype._animateCustomUpdate=function(e,i){var o=i.getContentBounds(),n=this.getContentBounds();if(o.equals(n)){var a=new t.CustomAnimation(this.getCtx(),null,e.getAnimationDuration());return p._animatePosition(a,i,this),void e.add(a,d.UPDATE)}var s=n.w/o.w,r=o.w/n.w,h=(a=new t.CustomAnimation(this.getCtx(),null,e.getAnimationDuration()),new t.Point(i.getTranslateX()+.5*o.w,i.getTranslateY()+.5*o.h)),l=this.getTranslateX(),g=this.getTranslateY();this.setTranslateX(h.x-n.w*r*.5),this.setTranslateY(h.y-n.w*r*.5),a.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getTranslateX,this.setTranslateX,l),a.getAnimator().addProp(t.Animator.TYPE_NUMBER,this,this.getTranslateY,this.setTranslateY,g),e.add(a,d.UPDATE),this.setScaleX(r),this.setScaleY(r);var c=new t.AnimScaleTo(this.getCtx(),this,new t.Point(1,1),e.getAnimationDuration());e.add(c,d.UPDATE);var u=i.partialUpdate?i.origContent:i;if(u){this.getParent().addChild(u);var _=new t.Point(this.getTranslateX()+.5*n.w,this.getTranslateY()+.5*n.h);a.getAnimator().addProp(t.Animator.TYPE_NUMBER,u,i.getTranslateX,u.setTranslateX,_.x-o.w*s*.5),a.getAnimator().addProp(t.Animator.TYPE_NUMBER,u,i.getTranslateY,u.setTranslateY,_.y-o.h*s*.5);var f=new t.AnimScaleTo(this.getCtx(),u,new t.Point(s,s),e.getAnimationDuration());e.add(f,d.UPDATE);var m=new t.AnimFadeOut(this.getCtx(),u,e.getAnimationDuration());e.add(m,d.UPDATE);var v=this;t.Playable.appendOnEnd(m,function(){v.getParent().removeChild(u)}),this.setAlpha(0);var C=new t.AnimFadeIn(this.getCtx(),this,e.getAnimationDuration());e.add(C,d.UPDATE)}},p._animatePosition=function(e,i,o){if(o&&i){var n=i.getTranslateX(),a=i.getTranslateY(),s=o.getTranslateX(),r=o.getTranslateY();n!=s&&(o.setTranslateX(n),e.getAnimator().addProp(t.Animator.TYPE_NUMBER,o,o.getTranslateX,o.setTranslateX,s)),a!=r&&(o.setTranslateY(a),e.getAnimator().addProp(t.Animator.TYPE_NUMBER,o,o.getTranslateY,o.setTranslateY,r))}},p._animateContainer=function(e,i,o){o&&i&&(p._animateFill(e,i,o),e.getAnimator().addProp(t.Animator.TYPE_NUMBER,o,o.getWidth,o.setWidth,o.getWidth()),o.setWidth(i.getWidth()),e.getAnimator().addProp(t.Animator.TYPE_NUMBER,o,o.getHeight,o.setHeight,o.getHeight()),o.setHeight(i.getHeight()))},p._animateFill=function(e,i,o){i&&o&&o.getFill()instanceof t.SolidFill&&!o.getFill().equals(i.getFill())&&(e.getAnimator().addProp(t.Animator.TYPE_FILL,o,o.getFill,o.setFill,o.getFill()),o.setFill(i.getFill()))},p.prototype.animateDelete=function(e,i){this.GetDiagram().getNodesPane().addChild(this);var o=this,n=new t.AnimFadeOut(this.getCtx(),this,e.getAnimationDuration());t.Playable.appendOnEnd(n,function(){o.getParent().removeChild(o),o.destroy()}),e.add(n,d.DELETE)},p.prototype.animateInsert=function(e){this.setAlpha(0),e.add(new t.AnimFadeIn(this.getCtx(),this,e.getAnimationDuration()),d.INSERT)},p.prototype._getState=function(t){return{hovered:this._isShowingHoverEffect,selected:this.isSelected(),focused:this._isShowingKeyboardFocusEffect,zoom:t||this.GetDiagram().getPanZoomCanvas().getZoom(),expanded:this.isDisclosed()}},p.prototype.rerenderOnZoom=function(t){if(this._diagram.getOptions().zoomRenderer){var e=this._getState(t.oldZoom),i=this._getState(t.newZoom);this._applyCustomNodeContent(this._diagram.getOptions().zoomRenderer,i,e)}},p.prototype.highlight=function(t){if(this._isHighlighted!==t){this._isHighlighted=t;var e=t?1:this._diagram.getOptions().styleDefaults._highlightAlpha;!this._customNodeContent&&this.isDisclosed()?(this._containerShape&&this._containerShape.setAlpha(e),this._containerButton&&this._containerButton.setAlpha(e),this._labelObj&&this._labelObj.setAlpha(e),this._selectionShape&&this._selectionShape.setAlpha(e)):this.setAlpha(e)}},p.prototype.setLabelAlignments=function(e,i){var o=this._labelObj instanceof t.MultilineText||this._labelObj instanceof t.BackgroundMultilineText;"baseline"==i&&(i=o?t.MultilineText.V_ALIGN_TOP:t.OutputText.V_ALIGN_AUTO),this._labelObj.setHorizAlignment(e),this._labelObj.setVertAlignment(i)},p.prototype.getContainerPadding=function(){if(!this._containerPadding&&this._diagram.getOptions().renderer){var t=this.GetDiagram().getPanZoomCanvas().getZoom(),e=this.getElem().getBoundingClientRect(),i=this._childNodePane?this._childNodePane.getElem().getBoundingClientRect():null;this._containerPadding={left:(i.left-e.left)/t,right:(e.right-i.right)/t,top:(i.top-e.top)/t,bottom:(e.bottom-i.bottom)/t}}else if(!this._containerPadding){var o=this._data.containerSvgStyle||this._data.containerStyle,n=p._getNodeCSSStyle(o,this._data._containerStyle,["padding-left","padding-right","padding-top","padding-bottom"]);this._containerPadding={left:n.getPadding("padding-left"),right:n.getPadding("padding-right"),top:n.getPadding("padding-top"),bottom:n.getPadding("padding-bottom")}}return this._containerPadding},p.prototype.getChildNodeIds=function(){return this._childNodeIds},p.prototype.addChildNodeId=function(t){this._childNodeIds||(this._childNodeIds=[]),this._childNodeIds.push(t)},p.prototype.removeChildNodeId=function(e){this._childNodeIds&&t.ArrayUtils.removeItem(this._childNodeIds,e)},p.prototype.removeChildNode=function(t){t&&(this.removeChildNodeId(t.getId()),this._childNodePane.removeChild(t))},p.prototype.getChildNodes=function(){for(var t=[],e=this._childNodeIds?this._childNodeIds.length:-1,i=0;i<e;i++){var o=this.GetDiagram().getNodeById(this._childNodeIds[i]);o&&t.push(o)}return t},p.prototype.setGroupId=function(t){this._groupId=t},p.prototype.getGroupId=function(){return this._groupId},p.prototype.GetChildNodePane=function(){return this._childNodePane||(this._childNodePane=new t.Container(this.getCtx()),this.addChild(this._childNodePane)),this._childNodePane},p.prototype.handleDisclosure=function(e){t.EventManager.consumeEvent(e),this._diagram.setNodeDisclosed(this.getId(),!this.isDisclosed())},p._renderContainer=function(e,i,o){var n=e.getCtx().isCustomElement()?null:i.containerSvgStyle||i.containerStyle,a=t.JsonUtils.clone(n),s=[t.CSSStyle.BACKGROUND_COLOR,t.CSSStyle.BORDER_COLOR,t.CSSStyle.BORDER_WIDTH,t.CSSStyle.BORDER_RADIUS],r=p._getNodeCSSStyle(a,i._containerStyle,s),d=r.getStyle(t.CSSStyle.BACKGROUND_COLOR),h=r.getStyle(t.CSSStyle.BORDER_COLOR),l=t.CSSStyle.toNumber(r.getStyle(t.CSSStyle.BORDER_WIDTH)),g=t.CSSStyle.toNumber(r.getStyle(t.CSSStyle.BORDER_RADIUS)),c=o.GetChildNodePane(),u=o.getContainerPadding();c.setTranslate(u.left,u.top);var _=c.getDimensionsWithStroke(),f=new t.Rect(e.getCtx(),0,0,_.w+u.left+u.right,_.h+u.top+u.bottom);f.setSolidFill(d),g&&(f.setRx(g),f.setRy(g)),h&&f.setStroke(new t.Stroke(h,1,l)),a&&s.forEach(function(e){delete a[t.CSSStyle.cssStringToObjectProperty(e)]});var m=e.getCtx().isCustomElement()?null:i.containerSvgClassName||i.containerClassName;f.setStyle(a).setClassName(m),o.addChildAt(f,0),o.setSelectionShape(f),o._containerShape=f},p._getNodeCSSStyle=function(e,i,o){var n=new t.CSSStyle;return o.forEach(function(o){var a=null,s=t.CSSStyle.cssStringToObjectProperty(o);e&&null!=e[s]?a=e[s]:i&&(a=i.getStyle(o)),n.setStyle(o,a)}),n},p._renderContainerButton=function(e,i,o){if(o.isContainer()&&"off"!=i.showDisclosure){var n,a,s,r=e.getOptions();o.isDisclosed()?(n=r._resources.collapse_ena,a=r._resources.collapse_ovr,s=r._resources.collapse_dwn):(n=r._resources.expand_ena,a=r._resources.expand_ovr,s=r._resources.expand_dwn);var d=new t.Image(e.getCtx(),n.src,0,0,n.width,n.height),h=new t.Image(e.getCtx(),a.src,0,0,a.width,a.height),l=new t.Image(e.getCtx(),s.src,0,0,s.width,s.height),g=new t.Button(e.getCtx(),d,h,l,null,null,o.handleDisclosure,o);o.addChild(g);var p=o.getContentBounds(!0);if(p){var c=t.Agent.isRightToLeft(e.getCtx())?p.x+p.w-n.width:p.x,u=p.y;g.setTranslate(c,u)}o._containerButton=g}},p.prototype.isDragAvailable=function(t){return!0},p.prototype.getDragTransferable=function(t,e){return this._isDraggable()?[this.getId()]:null},p.prototype.getDragFeedback=function(t,e){if(this._diagram.getEventManager().LinkCreationStarted)return null;if(this._diagram.isSelectionSupported()&&this._diagram.getSelectionHandler().getSelectedCount()>1){for(var i=this._diagram.getSelectionHandler().getSelection(),o=[],n=0;n<i.length;n++)o.push(i[n]);return o}return this},p.prototype.ShowDropEffect=function(){this._dropEffect||this._createDropEffect("oj-diagram-node oj-active-drop")},p.prototype.ShowRejectedDropEffect=function(){this._dropEffect||this._createDropEffect("oj-diagram-node oj-invalid-drop")},p.prototype.ClearDropEffect=function(){this._dropEffect&&(this.removeChild(this._dropEffect),this._dropEffect=null)},p.prototype._createDropEffect=function(e){var i;if(this._customNodeContent||this.isDisclosed()||this._background||this._shape&&this._shape instanceof t.ImageMarker){var o=this.getContentBounds(!0);if(o){i=new t.Rect(this._diagram.getCtx(),o.x,o.y,o.w,o.h);var n=this._customNodeContent?null:this.isDisclosed()?this._containerShape.getRx():this._background?this._background.getRx():null;n&&(i.setRx(n),i.setRy(n))}}else this._shape&&this._shape instanceof t.SimpleMarker&&(i=this._shape.copyShape());i.setInvisibleFill(),i.setClassName(e),i.setMouseEnabled(!1),this.addChild(i),this._dropEffect=i},p.prototype._setDraggableStyleClass=function(){if(this._diagram.getEventManager().IsDragSupported()&&this._isDraggable()){var e=this._customNodeContent?this:this.isDisclosed()?this._containerShape:this._background?this._background:this._shape,i=e.getElem()?e.getElem():e;t.ToolkitUtils.addClassName(i,"oj-diagram-node"),t.ToolkitUtils.addClassName(i,"oj-draggable")}},p.prototype._isDraggable=function(){return"off"!==this.getData().draggable&&!1!==this.getData().draggable},p.ConvertNodeData=function(t){return{id:t.id,label:t.label,selectable:t.selectable,shortDesc:t.shortDesc,categories:t.categories,nodes:t.nodes,_itemData:t}},p.prototype._cleanUp=function(e){if(this._containerShape&&(this.removeChild(this._containerShape),e&&e.addChild(this._containerShape),this._containerShape=null),this._background&&(this.removeChild(this._background),e&&e.addChild(this._background),this._background=null),this._shape&&(this.removeChild(this._shape),e&&e.addChild(this._shape),this._shape=null),this._labelObj&&(this.removeChild(this._labelObj),e&&e.addChild(this._labelObj),this._labelObj=null),this._containerButton&&(this.removeChild(this._containerButton),e&&e.addChild(this._containerButton),this._containerButton=null),this._customNodeContent){if(this._childNodePane&&(this._childNodePane.setParent(null),this.addChild(this._childNodePane)),this._customNodeContent.namespaceURI===t.ToolkitUtils.SVG_NS)this.getContainerElem().removeChild(this._customNodeContent),e&&t.ToolkitUtils.appendChildElem(e.getContainerElem(),this._customNodeContent);else if(Array.isArray(this._customNodeContent))for(var i=0;i<this._customNodeContent.length;i++)this.getContainerElem().removeChild(this._customNodeContent[i]),e&&t.ToolkitUtils.appendChildElem(e.getContainerElem(),this._customNodeContent[i]);else this._customNodeContent instanceof t.BaseComponent&&(this.removeChild(this._customNodeContent),e&&e.addChild(this._customNodeContent));this._customNodeContent=null}this._contentDims=null},p.prototype.getAnimationState=function(e){var i,o,n,a,s,r=this.getContentBounds();return this._shape&&((i={centerDimensions:this._shape.getCenterDimensions(),fill:this._shape.getFill()}).getCenterDimensions=function(){return i.centerDimensions},i.getFill=function(){return i.fill}),this._labelObj&&((o={matrix:this._labelObj.getMatrix()}).getMatrix=function(){return o.matrix}),this.isDisclosed()&&this._containerShape&&((n={fill:this._containerShape.getFill(),width:this._containerShape.getWidth(),height:this._containerShape.getHeight()}).getFill=function(){return n.fill},n.getWidth=function(){return n.width},n.getHeight=function(){return n.height}),e&&(s=new t.Container(this.getCtx()),this._cleanUp(s),s.setTranslate(this.getTranslateX(),this.getTranslateY())),(a={partialUpdate:!0,id:this.getId(),disclosed:this.isDisclosed(),tx:this.getTranslateX(),ty:this.getTranslateY(),contentBounds:r,origContent:s,_shape:i,_labelObj:o,_containerShape:n}).getId=function(){return a.id},a.isDisclosed=function(){return a.disclosed},a.getTranslateX=function(){return a.tx},a.getTranslateY=function(){return a.ty},a.getContentBounds=function(){return a.contentBounds},a},p.prototype.appendChildNodesData=function(e,i){this._data.nodes instanceof Array||(this._data.nodes=[]),this._data.nodes=t.ArrayUtils.insert(this._data.nodes,e,i)},p.prototype.removeChildNodesData=function(t){if(this._data.nodes instanceof Array)for(var e=0;e<t.length;e++)for(var i=t[e].id,o=0;o<this._data.nodes.length;o++)if(this._data.nodes[o].id===i){this._data.nodes.splice(o,1);break}};var c=function(t){this.Init(t)};t.Obj.createSubclass(c,t.Automation,"DvtDiagramAutomation"),c.prototype.Init=function(t){this._diagram=t},c.prototype.GetSubIdForDomElement=function(t){var e=this._diagram.getEventManager().GetLogicalObject(t);return e&&e instanceof p?"node["+this._diagram.GetAllNodes().indexOf(e.getId())+"]":e&&e instanceof g?"link["+this._diagram.GetAllLinks().indexOf(e.getId())+"]":null},c.prototype.getDomElementForSubId=function(e){if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._diagram);var i=this._parseSubId(e),o=i.component,n=i.index,a=null;return"node"==o?a=this._getNode(n):"link"==o&&(a=this._getLink(n)),a?a.getElem():null},c.prototype._parseSubId=function(t){var e=t,i=-1,o=t.substring(0,t.indexOf("["));return o&&(e="node"==o||"link"==o?o:null,i=parseInt(t.substring(t.indexOf("[")+1,t.indexOf("]")))),{component:e,index:i}},c.prototype.getNodeCount=function(){return this._diagram.GetAllNodes().length},c.prototype.getLinkCount=function(){return this._diagram.GetAllLinks().length},c.prototype.getNode=function(e){var i=this._getNode(e);if(i){var o={};o.id=i.getId(),o.selected=i.isSelected(),o.tooltip=i.getShortDesc(),o.label=i.getData().label;var n=i.getData().backgroundStyle;return n&&n instanceof Object&&(n=t.CSSStyle.cssObjectToString(n)),o.background=n,o.icon=this._getMarkerData(i.GetIcon()),o.expanded=i.isDisclosed(),o}return null},c.prototype.getLink=function(e){var i=this._getLink(e);if(i){var o={};return o.id=i.getId(),o.selected=i.isSelected(),o.tooltip=i.getShortDesc(),o.label=i.getData().label,o.color=i.getLinkColor(),o.width=i.getLinkWidth(),o.style=this._getLinkStyleFromObject(i.getLinkStyle()),o.startNode=i.getStartId(),o.endNode=i.getEndId(),o.startConnectorType=i.getStartConnectorType(),o.endConnectorType=i.getEndConnectorType(),o.promoted=i.isPromoted(),i.isPromoted()&&(o.links=t.JsonUtils.clone(i.getData()._links)),o}return null},c.prototype.getPromotedLink=function(t,e){var i=this._getNode(t),o=this._getNode(e);if(!i||!o)return null;var n=g.GetPromotedLinkId(this._diagram,i.getId(),o.getId()),a=this._diagram.getLinkById(n);if(a){var s={};return s.id=a.getId(),s.selected=a.isSelected(),s.tooltip=a.getShortDesc(),s.color=a.getLinkColor(),s.width=a.getLinkWidth(),s.style=this._getLinkStyleFromObject(a.getLinkStyle()),s.startNode=a.getStartId(),s.endNode=a.getEndId(),s.startConnectorType=a.getStartConnectorType(),s.endConnectorType=a.getEndConnectorType(),s.count=a.getData()._links.length,s}return null},c.prototype._getLinkStyleFromObject=function(e){if(this._diagram.getCtx().isCustomElement())return t.CSSStyle.cssObjectToString(e);if(e&&e instanceof Object){if(e._type==g.CUSTOM_STYLE){var i=t.JsonUtils.clone(e);return delete i._type,t.CSSStyle.cssObjectToString(i)}return e._type}return e},c.prototype.getExpanded=function(){return this._diagram.DisclosedNodes},c.prototype._getMarkerData=function(e){if(e){var i={};return i.shape=e instanceof t.SimpleMarker?e.getType():"none",e.getFill()&&(i.color=e.getFill().getColor()),i}return null},c.prototype._getNode=function(t){var e=this._diagram.GetAllNodes();return t>=0&&t<e.length?this._diagram.getNodeById(e[t]):null},c.prototype._getLink=function(t){var e=this._diagram.GetAllLinks();return t>=0&&t<e.length?this._diagram.getLinkById(e[t]):null}}(dvt);
  return dvt;
});
