/**
 * Copyright (c) 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit', './DvtTimeComponent', './DvtTimeAxis'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){var e=new Object;t.Obj.createSubclass(e,t.Obj),e._DEFAULT_TIMEAXES_LABEL_STYLE=t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #333333;",e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR="#ffffff",e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR="#d6d7d8",e._DEFAULT_ZOOM_CONTROL_DIAMETER=31,e._DEFAULT_ZOOM_CONTROL_PADDING=10.5,e._DEFAULT_ZOOM_CONTROL_SPACING=9,e._DEFAULT_STANDALONE_TASK_HEIGHT=22,e._DEFAULT_BASELINE_TASK_HEIGHT=6,e._DEFAULT_MILESTONE_BASELINE_Y_OFFSET=6,e._DEFAULT_SUMMARY_THICKNESS=3,e._DEFAULT_ACTUALTASK_HEIGHT=16,e._DEFAULT_TASK_LABEL_PADDING=5,e._DEFAULT_TASK_PADDING=5,e._DEFAULT_TASK_EFFECT_MARGIN=2,e._DEFAULT_TASK_TINT_FILTER_ID="ojGanttTaskTintFilter",e._DEFAULT_TASK_SHADE_FILTER_ID="ojGanttTaskShadeFilter",e._DEFAULT_TASK_TINT_ALPHA=.3,e._DEFAULT_TASK_SHADE_ALPHA=.35,e._DEFAULT_AXIS_HEIGHT=23,e._ROW_LABELS_AXIS_GAP=10,e._ROW_LABEL_EXPAND_COLLAPSE_BUTTON_SIZE=12,e._ROW_LABEL_INDENT_SIZE=e._ROW_LABEL_EXPAND_COLLAPSE_BUTTON_SIZE+9,e._ROW_LABEL_BUTTON_CONTENT_GAP_SIZE=7,e._DEFAULT_DEPENDENCY_LINE_INNER_COLOR="#ffffff",e._DEFAULT_DEPENDENCY_LINE_INNER_WIDTH=2,e._DEFAULT_ANIMATION_DURATION=.5,e._DEPENDENCY_LINE_ARC_RADIUS=0,e._DEPENDENCY_LINE_TASK_FLANK_LENGTH=7,e._DEPENDENCY_MARKER_HEIGHT=8,e._DEPENDENCY_MARKER_WIDTH=6,e._AUTOPAN_EDGE_THRESHOLD=40,e._DEFAULT_TASK_RESIZE_HANDLE_WIDTH=5,e._DEFAULT_TASK_RESIZE_HANDLE_WIDTH_TOUCH=20,e.getHorizontalScrollbarStyle=function(){return new t.CSSStyle(e._DEFAULT_HORIZONTAL_SCROLLBAR_STYLE)},e.getVerticalScrollbarStyle=function(){return new t.CSSStyle(e._DEFAULT_VERTICAL_SCROLLBAR_STYLE)},e.getStandaloneTaskHeight=function(){return e._DEFAULT_STANDALONE_TASK_HEIGHT},e.getActualTaskHeight=function(){return e._DEFAULT_ACTUALTASK_HEIGHT},e.getBaselineTaskHeight=function(){return e._DEFAULT_BASELINE_TASK_HEIGHT},e.getMilestoneBaselineYOffset=function(){return e._DEFAULT_MILESTONE_BASELINE_Y_OFFSET},e.getSummaryThickness=function(){return e._DEFAULT_SUMMARY_THICKNESS},e.getTaskPadding=function(){return e._DEFAULT_TASK_PADDING},e.getTaskLabelPadding=function(){return e._DEFAULT_TASK_LABEL_PADDING},e.getTaskEffectMargin=function(){return e._DEFAULT_TASK_EFFECT_MARGIN},e.getTaskTintFilterId=function(){return e._DEFAULT_TASK_TINT_FILTER_ID},e.getTaskShadeFilterId=function(){return e._DEFAULT_TASK_SHADE_FILTER_ID},e.getTaskTintAlpha=function(){return e._DEFAULT_TASK_TINT_ALPHA},e.getTaskShadeAlpha=function(){return e._DEFAULT_TASK_SHADE_ALPHA},e.getTimeAxisHeight=function(t){return t&&t.height?t.height:e._DEFAULT_AXIS_HEIGHT},e.getMajorAxisLabelStyle=function(a){var n=a._resources,i=e._DEFAULT_TIMEAXES_LABEL_STYLE;return n&&(i=n.majorAxisLabelFontProp),new t.CSSStyle(i)},e.getMinorAxisLabelStyle=function(a){var n=a._resources,i=e._DEFAULT_TIMEAXES_LABEL_STYLE;return n&&(i=n.minorAxisLabelFontProp),new t.CSSStyle(i)},e.getRowAxisGap=function(){return e._ROW_LABELS_AXIS_GAP},e.getDependencyLineTaskFlankLength=function(){return e._DEPENDENCY_LINE_TASK_FLANK_LENGTH},e.getDependencyLineArcRadius=function(){return e._DEPENDENCY_LINE_ARC_RADIUS},e.getDependencyLineMarkerWidth=function(){return e._DEPENDENCY_MARKER_WIDTH},e.getDependencyLineMarkerHeight=function(){return e._DEPENDENCY_MARKER_HEIGHT},e.getDependencyLineTaskGap=function(){return e.getTaskPadding()-1},e.getAutoPanEdgeThreshold=function(){return e._AUTOPAN_EDGE_THRESHOLD},e.getTaskLabelStyle=function(e){var a=e._resources,n="";return a&&(n=a.taskLabelFontProp),new t.CSSStyle(n)},e.getRowLabelStyle=function(e){var a=e._resources,n="";return a&&(n=a.rowLabelFontProp),new t.CSSStyle(n)},e.getRowLabelButtonSize=function(){return e._ROW_LABEL_EXPAND_COLLAPSE_BUTTON_SIZE},e.getRowLabelIndentSize=function(){return e._ROW_LABEL_INDENT_SIZE},e.getRowLabelButtonContentGapSize=function(){return e._ROW_LABEL_BUTTON_CONTENT_GAP_SIZE},e.getChartStrokeWidth=function(e){var a=e._resources;if(a){var n=a.chartArea;if(n){var i=n.strokeWidth;if(i)return t.CSSStyle.toNumber(i)}}return 1},e.getHorizontalGridlineWidth=function(e){return e._resources?t.CSSStyle.toNumber(e._resources.horizontalGridlineWidth):1},e.getAnimationDuration=function(a){var n,i=e._DEFAULT_ANIMATION_DURATION;return a._resources&&(n=a._resources.animationDuration)&&(i=t.CSSStyle.getTimeMilliseconds(n)/1e3),i},e.getZoomInButtonBackgroundColor=function(t){return t.zoomIn_bgc?t.zoomIn_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomInButtonActiveBackgroundColor=function(t){return t.zoomIn_a_bgc?t.zoomIn_a_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomInButtonHoverBackgroundColor=function(t){return t.zoomIn_h_bgc?t.zoomIn_h_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomInButtonDisabledBackgroundColor=function(t){return t.zoomIn_d_bgc?t.zoomIn_d_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomInButtonBorderColor=function(t){return t.zoomIn_bc?t.zoomIn_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getZoomInButtonActiveBorderColor=function(t){return t.zoomIn_a_bc?t.zoomIn_a_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getZoomInButtonHoverBorderColor=function(t){return t.zoomIn_h_bc?t.zoomIn_h_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getZoomInButtonDisabledBorderColor=function(t){return t.zoomIn_d_bc?t.zoomIn_d_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getZoomOutButtonBackgroundColor=function(t){return t.zoomOut_bgc?t.zoomOut_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomOutButtonActiveBackgroundColor=function(t){return t.zoomOut_a_bgc?t.zoomOut_a_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomOutButtonHoverBackgroundColor=function(t){return t.zoomOut_h_bgc?t.zoomOut_h_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomOutButtonDisabledBackgroundColor=function(t){return t.zoomOut_d_bgc?t.zoomOut_d_bgc:e._DEFAULT_ZOOM_CONTROL_BACKGROUND_COLOR},e.getZoomOutButtonBorderColor=function(t){return t.zoomOut_bc?t.zoomOut_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getZoomOutButtonActiveBorderColor=function(t){return t.zoomOut_a_bc?t.zoomOut_a_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getZoomOutButtonHoverBorderColor=function(t){return t.zoomOut_h_bc?t.zoomOut_h_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getZoomOutButtonDisabledBorderColor=function(t){return t.zoomOut_d_bc?t.zoomOut_d_bc:e._DEFAULT_ZOOM_CONTROL_BORDER_COLOR},e.getFocusedDependencyLineInnerColor=function(t){return e._DEFAULT_DEPENDENCY_LINE_INNER_COLOR},e.getFocusedDependencyLineInnerWidth=function(t){return e._DEFAULT_DEPENDENCY_LINE_INNER_WIDTH},e.getTaskResizeHandleWidth=function(){return t.Agent.isTouchDevice()?e._DEFAULT_TASK_RESIZE_HANDLE_WIDTH_TOUCH:e._DEFAULT_TASK_RESIZE_HANDLE_WIDTH},e.getSizeInPixels=function(t,e){if("string"==typeof t){if("%"==t.slice(-1))return e*Number(t.slice(0,-1))/100;if("px"==t.slice(-2))return Number(t.slice(0,-2));t=Number(t)}return"number"==typeof t?t<=1?e*t:t:0};var a=new Object;t.Obj.createSubclass(a,t.Obj),a.getDatatipColor=function(t){var e=t.getTask().getFillColor();return e?e.fill:null},a.getDatatip=function(e,n,i){var s=e.getGantt();if(s.getEventManager().isKeyboardDnDScaleChanged()){var r=s.getEventManager().getKeyboardDnDNavigationScale(),o=s.getEventManager().getKeyboardDnDMode()===l.KEYBOARD_MOVE?"MoveBy":"ResizeBy",h=a._addDatatipRow("",s,"",o,r.charAt(0).toUpperCase()+r.slice(1),n);return a._processDatatip(h,s,n)}var g=s.getOptions().tooltip,d=g?g.renderer:null;if(n&&d){var _=s.getCtx().getTooltipManager(),c=s.getEventManager().isDnDDragging()?e.getSandboxDataContext():e.getDataContext();return _.getCustomTooltip(d,c)}var u=e.getValue("shortDesc");if(null!=u)return u;if(i&&!s.getCtx().isCustomElement()){var p=s.getOptions().valueFormats;if(!p||0==p.length){var b=e.getTask(),f=e.getValue("start"),y=e.getValue("end"),D=e.getValue("baseline","start"),m=e.getValue("baseline","end"),v=b.getProgressValue(),S=s.getOptions(),T=S.translations,O=b.isMilestone("main"),E=b.isMilestone("baseline"),A=!(null==f&&null==y),C=!(null==D&&null==m);if(A)if(O)var R=s.getTimeAxis().formatDate(new Date(null!=f?f:y),null,"general"),k=t.ResourceUtils.format(T.accessibleMilestoneInfo,[R]);else{var w=s.getTimeAxis().formatDate(new Date(f),null,"general"),x=s.getTimeAxis().formatDate(new Date(y),null,"general"),L=e.getDuration(f,y);k=t.ResourceUtils.format(T.accessibleTaskInfo,[w,x,L])}if(C)if(E)var M=s.getTimeAxis().formatDate(new Date(null!=D?D:m),null,"general"),I=T.labelBaselineDate+": "+M;else{var P=s.getTimeAxis().formatDate(new Date(D),null,"general"),j=s.getTimeAxis().formatDate(new Date(m),null,"general");I=(I=T.labelBaselineStart+": "+P)+"; "+T.labelBaselineEnd+": "+j}if(A){var N=e.getValue("label");if(null!=N)var F=T.labelLabel+": "+N;if(null!=v){var H=S._resources;if(H){var B=H.percentConverter;if(B){var G=B.format(v);if(null!=G)var U=T.labelProgress+": "+G}}}}var Y=e.getRowNode(),z=Y.getLabel();null==z&&(z=Y.getIndex()+1);var V=t.ResourceUtils.format(T.accessibleRowInfo,[z]);return k&&(V=V+"; "+k),I&&(V=V+"; "+I),F&&(V=V+"; "+F),U&&(V=V+"; "+U),V}}var K="";return K=a._addRowDatatip(K,e,n),K=a._addTaskDatatip(K,e,n),a._processDatatip(K,s,n)},a._processDatatip=function(t,e,a){return""==t?null:a?'<table class="'+e.GetStyleClass("tooltipTable")+'">'+t+"</table>":t},a._addRowDatatip=function(t,e,n){var i=e.getGantt();if(i.getEventManager().isDnDDragging())var s=e.getSandboxValue("_rowNode");else s=e.getRowNode();var r=s.getLabel();return null==r&&(r=s.getIndex()+1),a._addDatatipRow(t,i,"row","Row",r,n)},a._addTaskDatatip=function(t,e,n){var i=e.getGantt(),s=i.getEventManager().isDnDDragging()?e.getSandboxValue:e.getValue,r=e.getTask(),o=s.call(e,"start"),l=s.call(e,"end"),h=s.call(e,"baseline","start"),g=s.call(e,"baseline","end"),d=s.call(e,"label"),_=r.getProgressValue(),c=!(null==o&&null==l),u=!(null==h&&null==g),p=r.isMilestone("main"),b=r.isMilestone("baseline");return c?(p?(t=a._addDatatipRow(t,i,"date","Date",null!=o?o:l,n),b?t=a._addDatatipRow(t,i,"baselineDate","BaselineDate",null!=h?h:g,n):u&&(t=a._addDatatipRow(t,i,"baselineStart","BaselineStart",h,n),t=a._addDatatipRow(t,i,"baselineEnd","BaselineEnd",g,n))):b?(t=a._addDatatipRow(t,i,"start","Start",o,n),t=a._addDatatipRow(t,i,"end","End",l,n),t=a._addDatatipRow(t,i,"baselineDate","BaselineDate",null!=h?h:g,n)):u?(t=a._addDatatipRow(t,i,"start","Start",o,n),t=a._addDatatipRow(t,i,"baselineStart","BaselineStart",h,n),t=a._addDatatipRow(t,i,"end","End",l,n),t=a._addDatatipRow(t,i,"baselineEnd","BaselineEnd",g,n)):(t=a._addDatatipRow(t,i,"start","Start",o,n),t=a._addDatatipRow(t,i,"end","End",l,n)),t=a._addDatatipRow(t,i,"label","Label",d,n),null!=_&&(t=a._addDatatipRow(t,i,"progress","Progress",_,n))):u&&(t=a._addDatatipRow(t,i,"baselineStart","BaselineStart",h,n),t=a._addDatatipRow(t,i,"baselineEnd","BaselineEnd",g,n)),t},a._addDatatipRow=function(e,n,i,s,r,o,l){if(null==r||""===r)return e;var h,g=a.getValueFormat(n,i);return"off"==g.tooltipDisplay?e:("string"==typeof g.tooltipLabel&&(h=g.tooltipLabel),null==h&&(h=null==s?"":n.getOptions().translations["label"+s]),r=a.formatValue(n,i,g,r),o?e+'<tr><td class="'+n.GetStyleClass("tooltipLabel")+'">'+h+'</td><td class="'+n.GetStyleClass("tooltipValue")+'">'+r+"</td></tr>":(e.length>0&&(e+="<br>"),e+t.ResourceUtils.format(n.getOptions().translations.labelAndValue,[h,r])))},a.getValueFormat=function(t,e){var a=t.getOptions().valueFormats;if(!a)return{};if(a instanceof Array){for(var n={},i=0;i<a.length;i++){var s=a[i];n[s.type]=s}t.getOptions().valueFormats=n,a=n}return a[e]?a[e]:{}},a.formatValue=function(t,e,a,n){var i=a.converter;if("start"==e||"end"==e||"date"==e||"baselineStart"==e||"baselineEnd"==e||"baselineDate"==e)return t.getTimeAxis().formatDate(new Date(n),i,"general");if(i&&i.format)return i.format(n);if("progress"==e){var s=t.getOptions()._resources;if(s){var r=s.percentConverter;if(r)return r.format(n)}}return n};var n=function(t){this.Init(t)};t.Obj.createSubclass(n,t.Obj),n.prototype.Init=function(t){this._gantt=t},n.prototype.prepareForAnimations=function(){var a=this._gantt.getCtx();this._gantt.StopAnimation(),this._animationMode="none",this._animationDuration=e.getAnimationDuration(this._gantt.getOptions()),this._gantt.isInitialRender()?this._gantt.isIRAnimationEnabled&&(this._animationMode="onDisplay"):this._gantt.isDCAnimationEnabled&&(this._animationMode="dataChange"),"onDisplay"===this._animationMode?(this.fadeInElemsIR=[],this.fadeInPlayableIR=new t.AnimFadeIn(a,this.fadeInElemsIR,this._animationDuration,0),this.dimensionsPlayableIR=this._createCustomPlayable(t.Easing.linear),this.translationsPlayableIR=this._createCustomPlayable(t.Easing.cubicInOut)):"dataChange"===this._animationMode&&(this.fadeInElemsDC=[],this.fadeInPlayableDC=new t.AnimFadeIn(a,this.fadeInElemsDC,this._animationDuration,0),this.fadeOutElemsDC=[],this.fadeOutPlayableDC=new t.AnimFadeOut(a,this.fadeOutElemsDC,this._animationDuration,0),this.dimensionsPlayableDC=this._createCustomPlayable(t.Easing.linear),this.translationsPlayableDC=this._createCustomPlayable(t.Easing.cubicInOut)),this._onEnds=[]},n.prototype.getAnimationMode=function(){return this._animationMode},n.prototype.setAnimationMode=function(t){this._animationMode=t},n.prototype._createCustomPlayable=function(e){var a;return(a=new t.CustomAnimation(this._gantt.getCtx(),this._gantt,this._animationDuration)).setEasing(e),a},n.prototype.triggerAnimations=function(){var e,a;if(this._gantt.StopAnimation(),a=this._gantt.getCtx(),"onDisplay"===this._animationMode?(e=[this.fadeInPlayableIR,this.translationsPlayableIR,this.dimensionsPlayableIR],this._gantt.Animation=new t.ParallelPlayable(a,e,this._animationDuration,0)):"dataChange"===this._animationMode&&(e=[this.fadeInPlayableDC,this.translationsPlayableDC,this.dimensionsPlayableDC,this.fadeOutPlayableDC],this._gantt.Animation=new t.ParallelPlayable(a,e,this._animationDuration,0)),this._gantt.Animation){this._hideDepLines(),t.Playable.appendOnEnd(this._gantt.Animation,this._showDepLines,this),this._gantt.isDndEnabled()||(this._gantt.EventManager.removeListeners(this._gantt),this._bListenersRemoved=!0);for(var n=0;n<this._onEnds.length;n++)t.Playable.appendOnEnd(this._gantt.Animation,this._onEnds[n],this);t.Playable.appendOnEnd(this._gantt.Animation,this._onAnimationEnd,this),this._gantt.Animation.play()}},n.prototype._hideDepLines=function(){var e=this._gantt.getDependenciesContainer();null!=e&&t.ToolkitUtils.setAttrNullNS(e.getElem(),"display","none")},n.prototype._showDepLines=function(){var e=this._gantt.getDependenciesContainer();null!=e&&t.ToolkitUtils.removeAttrNullNS(e.getElem(),"display")},n.prototype._onAnimationEnd=function(){this._gantt.AnimationStopped||this._gantt.RenderComplete(),this._bListenersRemoved&&this._gantt.EventManager.addListeners(this._gantt),this._gantt.Animation=null,this._gantt.AnimationStopped=!1,this._animationMode="none",this._gantt.renderViewport()},n.prototype.preAnimateGanttIR=function(t){"onDisplay"===this._animationMode&&this.fadeInElemsIR.push(t._canvas)},n.prototype.preAnimateTaskNode=function(e,a){var n,i=e.getRenderState();"dataChange"===this._animationMode?"add"===i?(e.setTranslate(a.x,a.y),this.fadeInElemsDC.push(e)):"exist"!==i&&"migrate"!==i||((n=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,e,e.getTranslateX,e.setTranslateX,a.x),n.addProp(t.Animator.TYPE_NUMBER,e,e.getTranslateY,e.setTranslateY,a.y)):e.setTranslate(a.x,a.y)},n.prototype.preAnimateTaskNodeRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},n.prototype.preAnimateTaskBaseline=function(e,a,n,i){var s,r,o=e.getRenderState("baseline");"onDisplay"===this._animationMode?(a.setDimensions(n.x,n.y,0,n.h,n.r),i(),(s=this.dimensionsPlayableIR.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getWidth,a.setWidth,n.w)):"dataChange"===this._animationMode?"add"===o?(a.setDimensions(n.x,n.y,0,n.h,n.r),i(),(s=this.dimensionsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getWidth,a.setWidth,n.w)):"exist"===o&&((r=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getX,a.setX,n.x),r.addProp(t.Animator.TYPE_NUMBER,a,a.getY,a.setY,n.y),(s=this.dimensionsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getWidth,a.setWidth,n.w),s.addProp(t.Animator.TYPE_NUMBER,a,a.getHeight,a.setHeight,n.h),a.setBorderRadius(n.r),this._onEnds.push(i)):(a.setDimensions(n.x,n.y,n.w,n.h,n.r),i())},n.prototype.preAnimateTaskBaselineRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},n.prototype.preAnimateTaskMain=function(e,a,n){var i,s,r=e.getRenderState("main");"onDisplay"===this._animationMode?(e.setMainDimensions(a.x,a.y,0,a.h,a.r),n(),(i=this.dimensionsPlayableIR.getAnimator()).addProp(t.Animator.TYPE_NUMBER,e,e.getMainWidth,e.setMainWidth,a.w)):"dataChange"===this._animationMode?"add"===r?(e.setMainDimensions(a.x,a.y,0,a.h,a.r),n(),(i=this.dimensionsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,e,e.getMainWidth,e.setMainWidth,a.w)):"exist"===r&&((s=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,e,e.getMainX,e.setMainX,a.x),s.addProp(t.Animator.TYPE_NUMBER,e,e.getMainY,e.setMainY,a.y),(i=this.dimensionsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,e,e.getMainWidth,e.setMainWidth,a.w),i.addProp(t.Animator.TYPE_NUMBER,e,e.getMainHeight,e.setMainHeight,a.h),e.setMainBorderRadius(a.r),this._onEnds.push(n)):(e.setMainDimensions(a.x,a.y,a.w,a.h,a.r),n())},n.prototype.preAnimateTaskMainRemove=function(t,e,a,n){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),e&&this.fadeOutElemsDC.push(e),a&&this.fadeOutElemsDC.push(a),this._onEnds.push(n)):n()},n.prototype.preAnimateTaskProgress=function(e,a,n,i){var s,r,o=e.getRenderState("progress");"onDisplay"===this._animationMode?(a.setDimensions(n.x,n.y,0,n.h,n.r),i(),(s=this.dimensionsPlayableIR.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getWidth,a.setWidth,n.w)):"dataChange"===this._animationMode?"add"===o?(a.setDimensions(n.x,n.y,0,n.h,n.r),i(),(s=this.dimensionsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getWidth,a.setWidth,n.w)):"exist"===o&&((r=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getX,a.setX,n.x),r.addProp(t.Animator.TYPE_NUMBER,a,a.getY,a.setY,n.y),(s=this.dimensionsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getWidth,a.setWidth,n.w),s.addProp(t.Animator.TYPE_NUMBER,a,a.getHeight,a.setHeight,n.h),a.setBorderRadius(n.r),this._onEnds.push(i)):(a.setDimensions(n.x,n.y,n.w,n.h,n.r),i())},n.prototype.preAnimateTaskProgressRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},n.prototype.preAnimateTaskLabel=function(e,a,n){var i,s=e.getTask(),r=e.getTaskLabel(),o=r.getLabelOutputText(),l=r.getRenderState(),h=s.getRenderState("main");"onDisplay"===this._animationMode?(n(),o.setY(a.y),o.setX(s.getShape("main").getX()),(i=this.translationsPlayableIR.getAnimator()).addProp(t.Animator.TYPE_NUMBER,o,o.getX,o.setX,a.x),i.addProp(t.Animator.TYPE_NUMBER,o,o.getY,o.setY,a.y)):"dataChange"===this._animationMode?"add"===l?(o.setX(a.x),o.setY(a.y),n(),"add"===h?(o.setX(s.getShape("main").getX()),(i=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,o,o.getX,o.setX,a.x),i.addProp(t.Animator.TYPE_NUMBER,o,o.getY,o.setY,a.y)):"exist"===h&&this.fadeInElemsDC.push(o)):"exist"===l&&((i=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,o,o.getX,o.setX,a.x),i.addProp(t.Animator.TYPE_NUMBER,o,o.getY,o.setY,a.y),this._onEnds.push(n)):(o.setX(a.x),o.setY(a.y),n())},n.prototype.preAnimateTaskLabelRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this._onEnds.push(e)):e()},n.prototype.preAnimateHorizontalGridline=function(e,a,n){var i;"dataChange"===this._animationMode?"add"===n?(e.setY1(a.y1),e.setY2(a.y2),e.setX1(a.x1),e.setX2(a.x2),this.fadeInElemsDC.push(e)):"exist"===n&&((i=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,e,e.getX1,e.setX1,a.x1),i.addProp(t.Animator.TYPE_NUMBER,e,e.getX2,e.setX2,a.x2),i.addProp(t.Animator.TYPE_NUMBER,e,e.getY1,e.setY1,a.y1),i.addProp(t.Animator.TYPE_NUMBER,e,e.getY2,e.setY2,a.y2)):(e.setY1(a.y1),e.setY2(a.y2),e.setX1(a.x1),e.setX2(a.x2))},n.prototype.preAnimateRowBackground=function(e,a,n){var i;"dataChange"===this._animationMode?("add"===n&&this.fadeInElemsDC.push(e),(i=this.dimensionsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,e,e.getHeight,e.setHeight,a.h),i.addProp(t.Animator.TYPE_NUMBER,e,e.getWidth,e.setWidth,a.w),this.translationsPlayableDC.getAnimator().addProp(t.Animator.TYPE_NUMBER,e,e.getY,e.setY,a.y)):(e.setY(a.y),e.setHeight(a.h),e.setWidth(a.w))},n.prototype.preAnimateRowNodeRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t),this.fadeOutElemsDC.push(t.getBackground()),this._onEnds.push(e)):e()},n.prototype.preAnimateRowLabel=function(e,a,n){var i,s=e.getRenderState();"dataChange"===this._animationMode?"add"===s?(a.setY(n.y),a.setX(n.x),this.fadeInElemsDC.push(a.getDisplayable())):"exist"===s&&((i=this.translationsPlayableDC.getAnimator()).addProp(t.Animator.TYPE_NUMBER,a,a.getX,a.setX,n.x),i.addProp(t.Animator.TYPE_NUMBER,a,a.getY,a.setY,n.y)):(a.setY(n.y),a.setX(n.x))},n.prototype.preAnimateRowLabelRemove=function(t,e){"dataChange"===this._animationMode?(this.fadeOutElemsDC.push(t.getDisplayable()),this._onEnds.push(e)):e()};var i=function(t){this.Init(t)};t.Obj.createSubclass(i,t.Obj),i.prototype.Init=function(t){this._gantt=t,this._ctx=t.getCtx(),this._rowObjs=[],this._dependencyObjs=[],this._contentHeight=0},i.prototype.clear=function(){this._rowObjs=[],this._dependencyObjs=[],this._contentHeight=0,this._prevScrollMinRowInd=null,this._prevScrollMaxRowInd=null},i.prototype.getRowObjs=function(){return this._rowObjs},i.prototype.getDependencyObjs=function(){return this._dependencyObjs},i.prototype.getContentHeight=function(){return this._contentHeight},i.prototype._getTime=function(t){if(null==t||""===t)return null;var e=new Date(t).getTime();return isNaN(e)?null:e},i.prototype._isOverlap=function(t,e){return t.overallStartTime<e.overallEndTime&&e.overallStartTime<t.overallEndTime},i.prototype._calcTaskHeight=function(t){var a=this._gantt.getOptions().taskDefaults,n=t.data,i=n.progress,s=n.baseline,r=!1,o=n.type?n.type:a.type,l=null!=n.height?n.height:a.height,h=0;!s||null==t.baselineStartTime&&null==t.baselineEndTime||(h=null!=s.height?s.height:a.baseline.height,r="milestone"===o||"auto"===o&&t.baselineStartTime===t.baselineEndTime,null==s.height&&a.baseline.height===e.getBaselineTaskHeight()&&(h=r?e.getActualTaskHeight():a.baseline.height),null==n.height&&a.height===e.getStandaloneTaskHeight()&&(l=e.getActualTaskHeight())),t.height=l,t.baselineHeight=h;var g=r?e.getMilestoneBaselineYOffset()+Math.max(h,l):l+h;if(t.overallHeightNoProgress=g,t.overallHeight=g,t.progressHeight=0,!("milestone"===o||"auto"===o&&t.startTime===t.endTime&&null!=t.startTime)&&i&&"number"==typeof i.value){var d=null!=i.height?i.height:a.progress.height;d="100%"===d?l:e.getSizeInPixels(d,l),t.progressHeight=d,l<d&&(t.overallHeight=Math.max(d,(d-l)/2+g))}},i.prototype._clearAdjacency=function(t){t.previousAdjacentTaskObj=null,t.nextAdjacentTaskObj=null,t.prevAdjMilestoneBaselineTaskObj=null,t.nextAdjMilestoneBaselineTaskObj=null},i.prototype._trackRowLevelBaselineMilestones=function(t,e){for(var a=t.taskObjs,n=[],i=0;i<e;i++)n.push([]);for(var s=0;s<a.length;s++){var r=a[s],o=this._gantt.getOptions().taskDefaults,l=r.data,h=l.type?l.type:o.type;("milestone"===h||"auto"===h&&r.baselineStartTime===r.baselineEndTime)&&n[r._rowLevel].push(r)}for(i=0;i<e;i++)n[i].sort(function(t,e){return e.baselineStartTime-t.baselineStartTime});for(s=0;s<a.length;s++){var g=n[(r=a[s])._rowLevel],d=g.length;if(d>0){var _=g[d-1],c=_.baselineStartTime,u=r.startTime,p=r.endTime;c<u?(r.prevAdjMilestoneBaselineTaskObj=_,g.pop()):c>p&&null==r.nextAdjMilestoneBaselineTaskObj?r.nextAdjMilestoneBaselineTaskObj=_:c!==u&&c!==p||g.pop()}}},i.prototype._calcRowTaskYHeight=function(t,a){for(var n,i=t.taskObjs,s=this._gantt.getOptions(),r=s.rowDefaults.height,o=s.taskDefaults.overlap.behavior,l=s.taskDefaults.overlap.offset,h=[],g=[],d=0;d<i.length;d++){var _=i[d];this._calcTaskHeight(_),this._clearAdjacency(_);var c=_.data,u=c.overlap?c.overlap.behavior:null,p=null!=u?u:o;p="auto"===p?null==r?"stack":"stagger":p,_.overlapBehavior=p;var b=l;if("overlay"===p&&null==n&&(n=_),0!==d){var f=i[d-1],y=this._isOverlap(_,f);y?O.push(_):(O=[_],h.push(O));var D=b||0,m=0;switch(p){case"stack":for(var v=!0,S=0;S<g.length;S++){var T=null;if(!this._isOverlap(_,g[S])){T=g[S],g[S]=_,v=!1;break}m+=1}v&&g.push(_),_.y=null!=b?m*b:0,T&&(_.previousAdjacentTaskObj=T,T.nextAdjacentTaskObj=_);break;case"stagger":y?(_._rowLevel=f._rowLevel,g[f._rowLevel]=_,_._staggerDirection=null!=f._staggerDirection?-f._staggerDirection:-1,_.y=f.y-_._staggerDirection*D):(g[m]=_,_._staggerDirection=1,_.y=0),_.previousAdjacentTaskObj=f,f.nextAdjacentTaskObj=_;break;case"overlay":g[m]=_,_.y=0}_._rowLevel=m}else{g.push(_),_._rowLevel=0;var O=[_];h.push(O),"stagger"===p&&(_._staggerDirection=1),_.y=0}}if(t.earliestOverlayTaskObj=n,null==r)if(null==b){var E=g.map(function(){return 0});i.forEach(function(t){t.overallHeight>E[t._rowLevel]&&(E[t._rowLevel]=t.overallHeight)});var A=E.map(function(t){return t+2*e.getTaskPadding()}).reduce(function(t,e,a){return t.push((t[a-1]||0)+e),t},[]);i.forEach(function(t){t.y+=(A[t._rowLevel-1]||0)+e.getTaskPadding()}),this._trackRowLevelBaselineMilestones(t,g.length)}else i.forEach(function(t){0===t._rowLevel&&(t.y+=e.getTaskPadding())});var C=h.map(function(t){var e=0;return t.forEach(function(t){var a=t.y+t.overallHeight;a>e&&(e=a)}),e});if(null==r){if(0===i.length)return void(t.height=e.getStandaloneTaskHeight()+2*e.getTaskPadding());t.height=C.reduce(function(t,e){return Math.max(t,e)})+e.getTaskPadding(),h.forEach(function(e,a){e.forEach(function(e){e.y+=t.y})})}else t.height=r-a,h.forEach(function(e,a){var n=C[a],i=Number.MAX_VALUE;e.forEach(function(e){e.y+=Math.floor((t.height-e.overallHeight)/2),e.y<i&&(i=e.y)});var s=Math.floor((t.height-n)/2)-i;e.forEach(function(e){"overlay"===e.overlapBehavior?e.y+=t.y:e.y+=t.y+s})})},i.prototype._generateRowObjs=function(t){var a=this._gantt.getOptions(),n=0;this._gantt.isHorizontalGridlinesVisible()&&(n=e.getHorizontalGridlineWidth(a));for(var i=[],s=0,r=0;r<t.length;r++){var o=t[r],l=o.tasks;if(null!=l){var h={id:null!=o.id?o.id:l.length>0?l[0].id:null,data:o,index:r,y:s,renderState:"add"};null!=o._depth&&(h.depth=o._depth,h.expanded=o._expanded,h.parentRowIndex=o._parentFlatIndex,o._depth=void 0,o._expanded=void 0,o._parentFlatIndex=void 0,o._flatIndex=void 0);for(var g=[],d=0;d<l.length;d++){var _=l[d],c={id:_.id,data:_,startTime:_.start&&""!==_.start?this._getTime(_.start):this._getTime(_.end),endTime:_.end&&""!==_.end?this._getTime(_.end):this._getTime(_.start),rowObj:h,renderState:"add"},u=c.startTime,p=c.endTime,b=_.baseline;if(b){var f=b.start&&""!==b.start?this._getTime(b.start):this._getTime(b.end),y=b.end&&""!==b.end?this._getTime(b.end):this._getTime(b.start);null==f&&null==y||(c.baselineStartTime=f,c.baselineEndTime=y,(f<u||null==u)&&(u=f),(y>p||null==p)&&(p=y))}null!=u&&null!=p&&(c.overallStartTime=u,c.overallEndTime=p,g.push(c))}g.sort(function(t,e){return t.startTime-e.startTime}),h.taskObjs=g,i.push(h),this._calcRowTaskYHeight(h,n),s+=h.height+n}}return i},i.prototype._generateDependencyObjs=function(e,a){a=a||this._createIdObjMap(this._rowObjs,"taskObjs");for(var n=[],i=0;i<e.length;i++){var s=e[i],r=s.predecessorTaskId,l=s.successorTaskId,h=null==s.type?o.FINISH_START:s.type,g=null!=r&&a.has(r),d=null!=l&&a.has(l);if(o._isValidType(h)&&g&&d&&!t.Obj.compareValues(this._ctx,r,l)){var _,c,u=a.get(r),p=a.get(l),b=u.rowObj,f=p.rowObj;b.index<=f.index?(_=b,c=f):(_=f,c=b);var y={id:s.id,data:s,index:i,type:h,predecessorTaskObj:u,successorTaskObj:p,rowObjTop:_,rowObjBottom:c};n.push(y)}}n.sort(function(t,e){return t.rowObjTop.index-e.rowObjTop.index});for(var D=0;D<n.length-1;D++)n[D].nextTopDependencyObj=n[D+1],n[D+1].prevTopDependencyObj=n[D];return n.sort(function(t,e){return t.rowObjBottom.index-e.rowObjBottom.index}),n},i.prototype._createIdObjMap=function(t,e){for(var a=new this._ctx.ojMap,n=0;n<t.length;n++){var i=t[n];if(e)for(var s=i[e],r=0;r<s.length;r++){var o=s[r];a.set(o.id,o)}else a.set(i.id,i)}return a},i.prototype._setDifferenceRenderState=function(t,e,a,n){for(var i=0;i<t.length;i++){var s=t[i];if(n)for(var r=s[n],o=0;o<r.length;o++){var l=r[o];if(!e.has(l.id)&&(l.renderState=a,"delete"===a)){var h=l.node;if(h&&h.getParent())"delete"!==s.renderState&&h.remove()}}else if(!e.has(s.id)&&(s.renderState=a,"delete"===a)){var g=s.node;g&&g.getParent()&&g.remove()}}},i.prototype._setIntersectionRenderState=function(e,a,n){for(var i=0;i<a.length;i++){var s=a[i];if(n)for(var r=s[n],o=0;o<r.length;o++){var l=r[o],h=e.get(l.id);if(h){if(t.Obj.compareValues(this._ctx,h.rowObj.id,s.id))l.renderState="exist";else{l.renderState="migrate";var g=h.node;g&&g.getParent()&&"none"===this._gantt.getAnimationManager().getAnimationMode()&&g.getRowNode().removeChild(g)}l._oldObj=h}}else{var d=e.get(s.id);d&&(s.renderState="exist",s._oldObj=d)}}},i.prototype._prepareAnimationDOM=function(e,a,n,i,s){var r=this._gantt.getAnimationManager(),o=r.getAnimationMode();r.setAnimationMode("none"),this._animationFinalStateRowObjs=new Set,this._animationInitialStateRowObjsDelete=[];var l=this._contentHeight,h=e[e.length-1];this._contentHeight=h.y+h.height;var g=this._gantt.scrollPositionToTranslateY(this._gantt.getOptions().scrollPosition),d=this._gantt.getViewportYBounds(g),_=d.yMin,c=d.yMax;this._contentHeight=l;for(var u=this._findRowIndRange(this._rowObjs,_,c),p=u.minRowInd,b=u.maxRowInd,f=p;f<=b;f++){var y=this._rowObjs[f];if(y){this.ensureInDOM(y,"row"),"delete"===y.renderState&&y.node.getRowLabelContent()&&this._animationInitialStateRowObjsDelete.push(y);var D=n.get(y.id);D&&this._animationFinalStateRowObjs.add(D);for(var m=y.taskObjs,v=0;v<m.length;v++){var S=m[v],T=s.get(S.id);if(T){var O=T.rowObj;if(!t.Obj.compareValues(this._ctx,O.id,y.id)){var E=a.get(O.id);E&&this.ensureInDOM(E,"row"),this._animationFinalStateRowObjs.add(O)}}}}}var A=this._findRowIndRange(e,_,c),C=A.minRowInd,R=A.maxRowInd;for(f=C;f<=R;f++){var k=e[f];if(k){this._animationFinalStateRowObjs.add(k);var w=a.get(k.id);w&&this.ensureInDOM(w,"row");var x=k.taskObjs;for(v=0;v<x.length;v++){var L=x[v],M=i.get(L.id);if(M){var I=M.rowObj;if(!t.Obj.compareValues(this._ctx,I.id,k.id)){this.ensureInDOM(I,"row");var P=n.get(I.id);P&&this._animationFinalStateRowObjs.add(P)}}}}}r.setAnimationMode(o),this._keepOldViewport=!0},i.prototype._associateOldNodesAndNewLayoutObjs=function(t){for(var e=0;e<t.length;e++){var a=t[e],n=a._oldObj;if(n){var i=n.node;i&&(a.node=i,i.setLayoutObject(a)),a._oldObj=null}for(var s=a.taskObjs,r=0;r<s.length;r++){var o=s[r],l=o._oldObj;if(l){var h=l.node;h&&(o.node=h,h.setLayoutObject(o),h.isSelected()&&h.clearSelectionState()),o._oldObj=null}}}},i.prototype.calcLayout=function(){var t=this._gantt.getOptions(),e=this._gantt.getRenderState();if(null==e)var a=this._calcRowsLayout(t);else this._expandCollapseRowObject(t,e.state,e.payload);if(this._rowObjs.length>0){var n=this._rowObjs[this._rowObjs.length-1];this._contentHeight=n.y+n.height;var i=t.dependencies;null!=i&&i.length>0&&(this._dependencyObjs=this._generateDependencyObjs(i,a))}},i.prototype._calcRowsLayout=function(t){var e=t.rows;if(null!=e&&0!==e.length){var a=e;this._gantt.isRowsHierarchical()&&(a=this._flattenRows(e,t.expanded));var n=this._generateRowObjs(a);if(this._rowObjs&&!this._gantt.isInitialRender()&&this._gantt.isLastRenderValid()){var i=this._createIdObjMap(this._rowObjs),s=this._createIdObjMap(n),r=this._createIdObjMap(this._rowObjs,"taskObjs"),o=this._createIdObjMap(n,"taskObjs");this._setDifferenceRenderState(this._rowObjs,s,"delete"),this._setDifferenceRenderState(n,i,"add"),this._setIntersectionRenderState(i,n),this._setDifferenceRenderState(this._rowObjs,o,"delete","taskObjs"),this._setDifferenceRenderState(n,r,"add","taskObjs"),this._setIntersectionRenderState(r,n,"taskObjs"),"none"!==this._gantt.getAnimationManager().getAnimationMode()&&this._prepareAnimationDOM(n,i,s,r,o),this._associateOldNodesAndNewLayoutObjs(n)}return this._rowObjs=n,o}this._rowObjs=[]},i.prototype._expandCollapseRowObject=function(t,a,n){var i=this,s=n.index,r=n.data,o=r.rows,l=t.expanded,h=this._gantt.getAnimationManager(),g=h.getAnimationMode(),d="none"!==g;if(d){this._keepOldViewport=!0,this._animationFinalStateRowObjs=new Set;var _=this._gantt.getViewportYBounds(k),c=_.yMin,u=_.yMax-c,p=function(t,e,a){h.setAnimationMode("none");for(var n=0,s=e;s<t.length;s++){var r=t[s];if(i.ensureInDOM(r,"row"),i._animationFinalStateRowObjs.add(r),(n+=r.height)>a)break}h.setAnimationMode(g)}}var b=function(t,e,a,n){for(var i=a;i<n;i++){var s=t[i];if(s.renderState=e,"delete"===e){var r=s.node;r&&r.getParent()&&r.remove()}for(var o=s.taskObjs,l=0;l<o.length;l++){o[l].renderState=e}}};if(n.expanded="expand"===a,r._expanded=n.expanded,b(this._rowObjs,"exist",0,this._rowObjs.length),"expand"===a){var f=this._flattenRows(o,l,n.index+1,n.depth+1),y=this._generateRowObjs(f);b(y,"add",0,y.length),d&&p(this._rowObjs,s,u),this._rowObjs=this._rowObjs.slice(0,s+1).concat(y,this._rowObjs.slice(s+1,this._rowObjs.length))}else{var D=this._calcFlattenedRowsLength(o,l);b(this._rowObjs,"delete",s+1,s+1+D),d&&p(this._rowObjs,s+1+D,u);var m=this._rowObjs.splice(s+1,D);d&&(this._animationInitialStateRowObjsDelete=m)}var v=0;this._gantt.isHorizontalGridlinesVisible()&&(v=e.getHorizontalGridlineWidth(t));for(var S=n.y+n.height+v,T=s+1;T<this._rowObjs.length;T++){var O=this._rowObjs[T];O.index=T;for(var E=O.taskObjs,A=0;A<E.length;A++){var C=E[A];C.y=C.y-O.y+S}O.y=S,S+=O.height+v}if(d){var R=this._rowObjs[this._rowObjs.length-1];this._contentHeight=R.y+R.height;for(var k=this._gantt.scrollPositionToTranslateY(this._gantt.getOptions().scrollPosition),w=this._gantt.getViewportYBounds(k),x=w.yMin,L=w.yMax,M=this._findRowIndRange(this._rowObjs,x,L),I=M.minRowInd,P=M.maxRowInd,j=I;j<=P;j++)this._animationFinalStateRowObjs.add(this._rowObjs[j])}},i.prototype._flattenRows=function(t,e,a,n){a=a||0,n=n||0;var i=this._gantt.getOptions().taskData,s=function(t,e,n,r){return t.reduce(function(t,o){o._depth=r,o._parentFlatIndex=n?n._flatIndex:null,o._flatIndex=a,a+=1;var l=o.rows;if(l){if(e.has(o.id))return o._expanded=!0,t.concat(o,s(l,e,o,r+1));o._expanded=!1}else if(i){var h=i.getChildDataProvider(o.id),g=!h||"yes"===h.isEmpty();o._expanded=!!g&&null}else o._expanded=null;return t.concat(o)},[])};return s(t,e,null,n)},i.prototype._calcFlattenedRowsLength=function(t,e){var a=function(t){return t.reduce(function(t,n){var i=n.rows;return i&&e.has(n.id)?t+1+a(i):t+1},0)};return a(t)},i.prototype.isRoot=function(t){return null==t.parentRowIndex},i.prototype.isHiddenCollapsed=function(t){for(var e=0;e<this._rowObjs;e++)if(this._rowObjs[e]===t)return!1;return!0},i.prototype.getParentRowObj=function(t){var e=t.parentRowIndex;return null!=e?this._rowObjs[e]:null},i.prototype._renderRowObj=function(t){var e=this._gantt.getDatabody(),a=t.node;if(!this._keepOldViewport&&a&&a.getParent())return!1;if(a||((a=new u(this._gantt)).setLayoutObject(t),t.node=a),this._gantt.isRowAxisEnabled()){var n=this._gantt.getRowAxis();if(n){var i=n.getRowLabelContents(),s=t.index,r=i[s];r||((r=new c(n,n.getLabelContentType())).setRowIndex(s),i[s]=r),r.render(t),a.setRowLabelContent(r)}}return a.render(e),!0},i.prototype._renderDependencyObj=function(t){var e=this._gantt.getDependenciesContainer(),a=t.node;if(a&&a.getParent())return!1;var n=this._gantt.getAnimationManager(),i=n.getAnimationMode();return n.setAnimationMode("none"),this._animationFinalStateRowObjs?(this._animationFinalStateRowObjs.has(t.rowObjTop)||this.ensureInDOM(t.rowObjTop,"row"),this._animationFinalStateRowObjs.has(t.rowObjBottom)||this.ensureInDOM(t.rowObjBottom,"row")):(this.ensureInDOM(t.rowObjTop,"row"),this.ensureInDOM(t.rowObjBottom,"row")),n.setAnimationMode(i),a||((a=new o(this._gantt)).setLayoutObject(t),t.node=a),a.render(e),!0},i.prototype.ensureInDOM=function(t,e){if("dependency"!==e){var a;switch(e){case"task":a=t.rowObj;break;case"row":case"rowLabel":a=t}this._renderRowObj(a)}else this._renderDependencyObj(t)},i.prototype._binarySearchLeftMost=function(t,e,a,n,i){if(0===t.length)return 0;for(var s=0,r=t.length;s<r;){var o=Math.floor((s+r)/2),l=n?i?t[o][n][i]:t[o][n]:t[o];l<e?s=o+1:r=o}return s<t.length&&((l=n?i?t[s][n][i]:t[s][n]:t[s])===e||"successor"===a)?s:s>0?s-1:0},i.prototype._findRowIndRange=function(t,e,a){for(var n=this._binarySearchLeftMost(t,e,"predecessor","y"),i=n,s=n;s<t.length;s++){if(!(t[s].y<=a))break;i=s}return{minRowInd:n,maxRowInd:i}},i.prototype.renderViewport=function(e,a,n){var i=-1,s=-1,r=this._gantt.getDatabody();if(r){this._keepOldViewport||n||(r.removeChildren(),this._gantt.getDatabodyBackground().removeChildren());var o=this._gantt.getRowAxis();this._gantt.isRowAxisEnabled()&&o&&!n&&o.removeChildren();var l=this._gantt.getDependenciesContainer();l&&l.removeChildren();var h=this._dependencyObjs.length>0,g=this._findRowIndRange(this._rowObjs,e,a);i=g.minRowInd,s=g.maxRowInd;var d,_=this._gantt.getEventManager();if(!(t.TimeAxis.supportsTouch()&&_&&_.isDnDDragging()))if(n&&null!=this._prevScrollMinRowInd)if(this._prevScrollMinRowInd<i)for(var c=this._prevScrollMinRowInd;c<i;c++)(d=this._rowObjs[c].node)&&d.remove();else if(s<this._prevScrollMaxRowInd)for(c=s+1;c<=this._prevScrollMaxRowInd;c++)(d=this._rowObjs[c].node)&&d.remove();if(this._keepOldViewport&&this._animationFinalStateRowObjs){this._animationFinalStateRowObjs.forEach(this._renderRowObj,this);for(var u=0;u<this._animationInitialStateRowObjsDelete.length;u++){var p=this._animationInitialStateRowObjsDelete[u];if(p.node){var b=p.node.getRowLabelContent();o.addChild(b.getDisplayable())}}}else for(var f=i;f<=s;f++){var y=this._rowObjs[f];if(!this._renderRowObj(y)&&n&&h)for(var D=y.taskObjs,m=0;m<D.length;m++)D[m].node.clearDependencies()}if(this._dependencyObjs.length>0){for(var v=this._binarySearchLeftMost(this._dependencyObjs,i,"successor","rowObjBottom","index"),S=this._dependencyObjs[v],T=S.prevTopDependencyObj;S&&S.rowObjTop.index<=s;)this._renderDependencyObj(S),S=S.nextTopDependencyObj;for(;T;){T.rowObjBottom.index>=i&&this._renderDependencyObj(T),T=T.prevTopDependencyObj}}n?(this._prevScrollMinRowInd=i,this._prevScrollMaxRowInd=s):(this._prevScrollMinRowInd=null,this._prevScrollMaxRowInd=null)}else this._prevScrollMinRowInd=null,this._prevScrollMaxRowInd=null;return this._keepOldViewport=!1,this._animationFinalStateRowObjs=null,this._animationInitialStateRowObjsDelete=[],{minRowInd:i,maxRowInd:s}},t.Gantt=function(t,e,a){this.Init(t,e,a)},t.Obj.createSubclass(t.Gantt,t.TimeComponent),t.Gantt.newInstance=function(e,a,n){return new t.Gantt(e,a,n)},t.Gantt.prototype.Init=function(e,a,n){this._isInitialRender=!0,t.Gantt.superclass.Init.call(this,e,a,n),this.Defaults=new r(e),this.EventManager=new l(this,e,a,n),this.EventManager.addListeners(this),t.Agent.isTouchDevice()?this._keyboardHandler=null:(this._keyboardHandler=new h(this,this.EventManager),this.EventManager.setKeyboardHandler(this._keyboardHandler))},t.Gantt.prototype.SetOptions=function(e){null==e.taskDefaults&&(e.taskDefaults={baseline:{}}),null==e.taskDefaults.baseline&&(e.taskDefaults.baseline={}),e.taskDefaults.height=null==e.taskDefaults.height?void 0:e.taskDefaults.height,e.taskDefaults.baseline.height=null==e.taskDefaults.baseline.height?void 0:e.taskDefaults.baseline.height,t.Gantt.superclass.SetOptions.call(this,e),this.setSelectionMode(this.Options.selectionMode);var a=this.isTaskMoveEnabled(),n=this.isTaskResizeEnabled();if(a||n){this.Options.dnd=t.JsonUtils.merge(this.Options.dnd,{drag:{tasks:{dataTypes:[]},taskResizeHandles:{dataTypes:[]}},drop:{rows:{dataTypes:[]}}});var i=this,s=function(t,e){var a=i.Options.dnd.drag[e].dataTypes;Array.isArray(a)||(i.Options.dnd.drag[e].dataTypes=[a],a=i.Options.dnd.drag[e].dataTypes),a.push(t);var n=i.Options.dnd.drop.rows.dataTypes;Array.isArray(n)||(i.Options.dnd.drop.rows.dataTypes=[n],n=i.Options.dnd.drop.rows.dataTypes),n.push(t)};n&&s(l.RESIZE_TASKS_DATA_TYPE,"taskResizeHandles"),a&&s(l.MOVE_TASKS_DATA_TYPE,"tasks")}},t.Gantt.prototype.getAutomation=function(){return this.Automation||(this.Automation=new s(this)),this.Automation},t.Gantt.prototype.GetStyleClass=function(t){var e=this.getCtx().styleClasses;return null!=e?e[t]:t},t.Gantt.prototype.Parse=function(t){return this._parser=new g,this._parser.parse(t)},t.Gantt.prototype._applyParsedProperties=function(e){this._axisPosition=e.axisPosition,this._selectionMode=e.selectionMode,this._horizontalGridline=e.horizontalGridline,this._verticalGridline=e.verticalGridline,this._viewStartTime=e.viewStart,this._viewEndTime=e.viewEnd,this._rowsData=e.rows,this.isIRAnimationEnabled=e.isIRAnimationEnabled,this.isDCAnimationEnabled=e.isDCAnimationEnabled,this._rowAxisRendered=e.rowAxisRendered,this._rowAxisWidth=e.rowAxisWidth,this._rowAxisMaxWidth=e.rowAxisMaxWidth,this._referenceObjects=e.referenceObjects,t.Gantt.superclass._applyParsedProperties.call(this,e)},t.Gantt.prototype._bundleTimeAxisOptions=function(t,a){var n=this._resources;n.axisClass=this.GetStyleClass(a),n.axisSeparatorClass=this.GetStyleClass(a+"Ticks"),n.axisLabelClass=this.GetStyleClass(a+"Labels");var i,s={start:t.start,end:t.end,_resources:n,shortDesc:t.shortDesc,orientation:"horizontal"};if(t[a]){var r=t[a];r.scale&&(s.scale=r.scale),r.converter&&(s.converter=r.converter),r.zoomOrder&&(s.zoomOrder=r.zoomOrder)}return"majorAxis"==a?i=e.getMajorAxisLabelStyle(t):"minorAxis"==a&&(i=e.getMinorAxisLabelStyle(t)),s.labelStyle=i,s},t.Gantt.prototype._getPreferredSize=function(e,a){return new t.Dimension(e,a)},t.Gantt.prototype.render=function(e,a,s){if(this.getCache().clearCache(),e){this.SetOptions(e),t.Gantt.superclass.render.call(this,e,a,s),this.isDndEnabled()?this.renderAriaLiveRegion():this.removeAriaLiveRegion(),this._animationManager=new n(this),this._animationManager.prepareForAnimations(),this._dataLayoutManager||(this._dataLayoutManager=new i(this)),this._dataLayoutManager.calcLayout(),d.renderRowAxis(this,this.getParent());var r=this.getAxisPosition();if(e.minorAxis){var o=this._bundleTimeAxisOptions(this.Options,"minorAxis");null==this._minorAxis&&(this._minorAxis=new t.TimeAxis(this.getCtx(),null,null),"top"==r?this._minorAxis.setBorderVisibility(!1,!1,!0,!1):this._minorAxis.setBorderVisibility(!0,!1,!1,!1),this._masterAxis=this._minorAxis),this._minorAxis.setCanvasSize(null);var l=this._minorAxis.getPreferredLength(o,this._canvasLength)}var h=e.majorAxis;if(h)if(h.scale){o=this._bundleTimeAxisOptions(this.Options,"majorAxis"),null==this._majorAxis&&(this._majorAxis=new t.TimeAxis(this.getCtx(),null,null),"top"==r?this._majorAxis.setBorderVisibility(!1,!1,!0,!1):this._majorAxis.setBorderVisibility(!0,!1,!1,!1),this._slaveAxis=this._majorAxis),this._majorAxis.setCanvasSize(null);var g=this._majorAxis.getPreferredLength(o,this._canvasLength);l&&g>l&&(this._masterAxis=this._majorAxis,this._slaveAxis=this._minorAxis,l=g)}else this._majorAxis=null;l&&this.setContentLength(l),this._minorAxis&&this._minorAxis.hasValidOptions()&&this.prepareViewportLength(),d.renderGantt(this),this._animationManager.triggerAnimations(),this.UpdateAriaAttributes(),this.Animation||this.RenderComplete(),this._renderState=null,this._isInitialRender=!1}else this._handleResize(a,s)},t.Gantt.prototype.getAnimationManager=function(){return this._animationManager},t.Gantt.prototype.getDataLayoutManager=function(){return this._dataLayoutManager},t.Gantt.prototype.isRowsHierarchical=function(){var e=this.getOptions().taskData;return e&&e.getChildDataProvider||t.Agent.isEnvironmentTest()&&this.getOptions()._isHierarchical},t.Gantt.prototype.getViewportYBounds=function(t){var e=this._backgroundHeight-this.getAxesHeight(),a=0;return null!=t?a=this._translateYToScrollPositionY(t):this._databody&&(a=this._translateYToScrollPositionY(this._databody.getTranslateY())),{yMin:a,yMax:a+e}},t.Gantt.prototype.renderViewport=function(t){var e=this.getViewportYBounds(),a=e.yMin,n=e.yMax;return this._dataLayoutManager.renderViewport(a,n,t)},t.Gantt.prototype.isInitialRender=function(){return this._isInitialRender},t.Gantt.prototype.isLastRenderValid=function(){return this._isLastRenderValid},t.Gantt.prototype.setIsLastRenderValid=function(t){this._isLastRenderValid=t},t.Gantt.prototype.getRenderState=function(){return this._renderState},t.Gantt.prototype.setRenderState=function(t){this._renderState=t},t.Gantt.prototype.isDndEnabled=function(){var t=this.isTaskMoveEnabled(),e=this.isTaskResizeEnabled();return this.getEventManager().isDndSupported()&&(t||e)},t.Gantt.prototype.isTaskMoveEnabled=function(){var t=this.Options.dnd;return t&&t.move&&"enabled"===t.move.tasks},t.Gantt.prototype.isTaskResizeEnabled=function(){var t=this.Options.taskDefaults;return t&&"enabled"===t.resizable},t.Gantt.prototype.renderAriaLiveRegion=function(){if(!this._ariaLiveRegion){var t=this.getCtx();this._ariaLiveRegion=document.createElement("div"),this._ariaLiveRegion.id="_dvtGanttAriaLiveRegion"+t.getStage().getId(),this._ariaLiveRegion.setAttribute("aria-live","assertive"),this._ariaLiveRegion.style.clip="rect(1px, 1px, 1px, 1px)",this._ariaLiveRegion.style.height="1px",this._ariaLiveRegion.style.overflow="hidden",this._ariaLiveRegion.style.position="absolute",this._ariaLiveRegion.style.whiteSpace="nowrap",this._ariaLiveRegion.style.width="1px",t.getContainer().appendChild(this._ariaLiveRegion)}},t.Gantt.prototype.getAriaLiveRegion=function(){return this._ariaLiveRegion},t.Gantt.prototype.updateLiveRegionText=function(t){this._ariaLiveRegion&&(this._ariaLiveRegion.textContent=t)},t.Gantt.prototype.removeAriaLiveRegion=function(){this._ariaLiveRegion&&(context.getContainer().removeChild(this._ariaLiveRegion),this._ariaLiveRegion=null)},t.Gantt.prototype.scroll=function(t){if(this.getDatabody()){var e=this.scrollPositionToTranslateY(t);this.isContentDirScrollbarOn()&&this.contentDirScrollbar&&this.contentDirScrollbar.setViewportRange(e-this.getDatabodyHeight(),e),this.setDataRegionTranslateY(e)}},t.Gantt.prototype.scrollPositionToTranslateY=function(t){var e=t.rowIndex,a=this.getRowLayoutObjs(),n=0;if(null!=e){var i=a[e=Math.min(Math.max(0,e),a.length-1)],s=null!=t.offsetY?t.offsetY:0;n=i.y+s}else null!=t.y&&(n=t.y);return this._scrollPositionYToTranslateY(n)},t.Gantt.prototype._scrollPositionYToTranslateY=function(t){return this.getBoundedContentTranslateY(this.getDatabodyStart()-t)},t.Gantt.prototype._translateYToScrollPositionY=function(t){return this._databody?-(t-this.getDatabodyStart()):0},t.Gantt.prototype.setDataRegionTranslateY=function(e,a){this._databody&&this._databody.setTranslateY(e),this._databodyBackground&&this._databodyBackground.setTranslateY(e),this.isDndEnabled()&&this._dndArtifactsContainer&&this._dndArtifactsContainer.setTranslateY(e),this.isRowAxisEnabled()&&this.getRowAxis().setTranslateY(e+this.getStartYOffset()),this._dependenciesContainer&&this._dependenciesContainer.setTranslateY(e);var n=this.renderViewport(a),i=this._translateYToScrollPositionY(e),s=n.minRowInd;if(-1!==s){var r=i-this.getRowLayoutObjs()[s].y,o=t.EventFactory.newGanttScrollPositionChangeEvent(i,s,r);this.dispatchEvent(o)}},t.Gantt.prototype.processScrollbarEvent=function(e,a){if(t.Gantt.superclass.processScrollbarEvent.call(this,e,a),a==this.contentDirScrollbar){var n=e.newMax;this.setDataRegionTranslateY(n,!0)}},t.Gantt.prototype.createViewportChangeEvent=function(){var e=this._majorAxis?this._majorAxis.getScale():null,a=this._minorAxis?this._minorAxis.getScale():null;return t.EventFactory.newGanttViewportChangeEvent(this._viewStartTime,this._viewEndTime,e,a)},t.Gantt.prototype._handleResize=function(t,e){this.Width=t,this.Height=e,this.applyStyleValues();var a=this.hasValidOptions();if(a&&d.renderRowAxis(this),this.prepareViewportLength(),d._renderBackground(this),a){this.renderTimeZoomCanvas(this._canvas),this.isRowAxisEnabled()&&this.getRowAxis().adjustPosition();var n=this.getTimeZoomCanvas();d._renderAxes(this,n),d._renderDatabodyBackground(this),d._renderVerticalGridline(this,n),d._renderData(this),d._renderReferenceObjects(this,n),d._renderZoomControls(this),this.isDndEnabled()&&d._renderDnDArtifactsContainer(this,n),(this.isTimeDirScrollbarOn()||this.isContentDirScrollbarOn())&&d._renderScrollbars(this,this)}else d._renderEmptyText(this);this.Animation||this.RenderComplete()},t.Gantt.prototype.applyStyleValues=function(){var a=t.Agent.isRightToLeft(this.getCtx()),n=this.getScrollbarPadding();this._borderWidth=e.getChartStrokeWidth(this.Options);var i=2*this._borderWidth;if(this._widthOffset=0,this.timeDirScrollbarStyles=this.getTimeDirScrollbarStyle(),this.contentDirScrollbarStyles=this.getContentDirScrollbarStyle(),this._backgroundWidth=this.Width,this._backgroundHeight=this.Height,this.isTimeDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-t.CSSStyle.toNumber(this.timeDirScrollbarStyles.getHeight())-3*n),this.isContentDirScrollbarOn()){var s=3*n+t.CSSStyle.toNumber(this.contentDirScrollbarStyles.getWidth());this._backgroundWidth=this._backgroundWidth-s,a&&(this._widthOffset=s)}this.setStartXOffset(this._widthOffset+this._borderWidth),this.setStartYOffset(this._borderWidth),this._canvasLength=this._backgroundWidth-i,this._canvasSize=this._backgroundHeight-i},t.Gantt.prototype.getBorderWidth=function(){return this._borderWidth},t.Gantt.prototype.HandleMouseWheel=function(e){if(t.Gantt.superclass.HandleMouseWheel.call(this,e),this.hasValidOptions())if(!e||e.ctrlKey||t.Agent.isTouchDevice()){if(e.zoomWheelDelta){var a=this.getCtx().pageToStageCoords(e.pageX,e.pageY);if(this.getGraphicalAreaBounds().containsPoint(a.x,a.y)){var n=this.getContentLength()*e.zoomWheelDelta,i=e.zoomTime,s=e.zoomCompLoc;this.handleZoomWheel(n,i,s,!0)}}}else{var r=e.wheelDelta?e.wheelDelta*t.TimeComponent.SCROLL_LINE_HEIGHT:0,o=e.wheelDeltaX?e.wheelDeltaX*t.TimeComponent.SCROLL_LINE_HEIGHT:0;if(this.panBy(-o,-r),e.wheelDeltaX){var l=this.createViewportChangeEvent();this.dispatchEvent(l)}}},t.Gantt.prototype.handleZoomWheel=function(e,a,n,i){e>this._masterAxis.getMaxContentLength()?(e=this._masterAxis.getMaxContentLength(),this.disableZoomButton(!0)):this.enableZoomButton(!0),this._canvasLength>e?(e=this._canvasLength,this.disableZoomButton(!1)):this.enableZoomButton(!1);var s=this.getContentLength()<=e;t.Gantt.superclass.handleZoomWheel.call(this,e,a,n,i);var r=this._masterAxis.getZoomLevelLengths();if(s)for(;this._masterAxis.getZoomLevelOrder()>0&&(!this._slaveAxis||this._slaveAxis.getZoomLevelOrder()>0);){var o=r[this._masterAxis.getZoomLevelOrder()-1];if(!(this.getContentLength()>=o))break;this._masterAxis.setZoomLevelOrder(this._masterAxis.getZoomLevelOrder()-1),this._masterAxis.decreaseScale(),this._slaveAxis&&(this._slaveAxis.setZoomLevelOrder(this._slaveAxis.getZoomLevelOrder()-1),this._slaveAxis.decreaseScale())}else for(;this._masterAxis.getZoomLevelOrder()<r.length-1&&(!this._slaveAxis||this._slaveAxis.getZoomLevelOrder()<this._slaveAxis.getZoomLevelLengths().length-1)&&(o=r[this._masterAxis.getZoomLevelOrder()],this.getContentLength()<o);)this._masterAxis.setZoomLevelOrder(this._masterAxis.getZoomLevelOrder()+1),this._masterAxis.increaseScale(),this._slaveAxis&&(this._slaveAxis.setZoomLevelOrder(this._slaveAxis.getZoomLevelOrder()+1),this._slaveAxis.increaseScale());this.isTimeDirScrollbarOn()&&this.timeDirScrollbar&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime);var l=this.getTimeZoomCanvas();if(d._renderAxes(this,l),d._renderDatabodyBackground(this),d._renderVerticalGridline(this,l),d._renderData(this),d._renderReferenceObjects(this,l),this.isDndEnabled()&&d._renderDnDArtifactsContainer(this,l),i){var h=this.createViewportChangeEvent();this.dispatchEvent(h)}},t.Gantt.prototype.getMajorAxis=function(){return this._majorAxis},t.Gantt.prototype.getMinorAxis=function(){return this._minorAxis},t.Gantt.prototype.getTimeAxis=function(){return this._minorAxis?this._minorAxis:this._majorAxis},t.Gantt.prototype.getDatabody=function(){return this._databody},t.Gantt.prototype.setDatabody=function(t){this._databody=t},t.Gantt.prototype.getDatabodyBackground=function(){return this._databodyBackground},t.Gantt.prototype.setDatabodyBackground=function(t){this._databodyBackground=t},t.Gantt.prototype.getDatabodyStart=function(){return this._databodyStart},t.Gantt.prototype.setDatabodyStart=function(t){this._databodyStart=t},t.Gantt.prototype.getDatabodyHeight=function(){return this.getCanvasSize()-this.getAxesHeight()},t.Gantt.prototype.getVerticalGridlines=function(){return this._gridlines},t.Gantt.prototype.setVerticalGridlines=function(t){this._gridlines=t},t.Gantt.prototype.getReferenceObjects=function(){return this._referenceObjects},t.Gantt.prototype.getReferenceObjectsContainer=function(){return this._refObjectsContainer},t.Gantt.prototype.setReferenceObjectsContainer=function(t){this._refObjectsContainer=t},t.Gantt.prototype.getRenderedReferenceObjects=function(){return this._renderedReferenceObjects},t.Gantt.prototype.setRenderedReferenceObjects=function(t){this._renderedReferenceObjects=t},t.Gantt.prototype.getDnDArtifactsContainer=function(){return this._dndArtifactsContainer},t.Gantt.prototype.setDnDArtifactsContainer=function(t){this._dndArtifactsContainer=t},t.Gantt.prototype.setEmptyText=function(t){this._emptyText=t},t.Gantt.prototype.removeEmptyText=function(){this._emptyText&&this._emptyText.getParent()&&(this._emptyText.getParent().removeChild(this._emptyText),delete this._emptyText,this._emptyText=null)},t.Gantt.prototype.getRowsData=function(){return this._rowsData},t.Gantt.prototype.getRowLayoutObjs=function(){return this._dataLayoutManager.getRowObjs()},t.Gantt.prototype.getDependencyLayoutObjs=function(){return this._dataLayoutManager.getDependencyObjs()},t.Gantt.prototype.setRows=function(t){this._rows=t},t.Gantt.prototype.getCurrentRow=function(){return this._currentRow},t.Gantt.prototype.setCurrentRow=function(t){this._currentRow=t},t.Gantt.prototype.getAxisPosition=function(){return this._axisPosition},t.Gantt.prototype.getAxisHeight=function(t){return e.getTimeAxisHeight(t)},t.Gantt.prototype.getStartTime=function(){return this._start},t.Gantt.prototype.getEndTime=function(){return this._end},t.Gantt.prototype.getHoverBehavior=function(){return"none"},t.Gantt.prototype.isHorizontalGridlinesVisible=function(){return"visible"==this._horizontalGridline},t.Gantt.prototype.isVerticalGridlinesVisible=function(){return"visible"==this._verticalGridline},t.Gantt.prototype.getContentHeight=function(){return this._dataLayoutManager.getContentHeight()},t.Gantt.prototype.getAxesHeight=function(){if(null==this._axesHeight){var t=0;this._majorAxis&&(t+=this._majorAxis.getSize()),this._minorAxis&&(t+=this._minorAxis.getSize()),this._axesHeight=t}return this._axesHeight},t.Gantt.prototype.isRowAxisEnabled=function(){return"on"==this._rowAxisRendered},t.Gantt.prototype.getRowAxisWidth=function(){return this._rowAxisWidth},t.Gantt.prototype.getRowAxisMaxWidth=function(){return this._rowAxisMaxWidth},t.Gantt.prototype.getRowAxis=function(){return this._rowAxis},t.Gantt.prototype.setRowAxis=function(t){this._rowAxis=t},t.Gantt.prototype.getViewportDimensions=function(){return new t.Rectangle(this.getStartXOffset()-this.getTimeZoomCanvas().getTranslateX(),this._databodyStart-this._databody.getTranslateY(),this._canvasLength,this._canvasSize-this.getAxesHeight())},t.Gantt.prototype.scrollIntoView=function(e,a,n,i){var s=t.Agent.isRightToLeft(this.getCtx()),r=this.getViewportDimensions(),o=0,l=0;a=a||"auto",n=n||"auto",i=i||0;var h=Math.min(e.x-r.x-i,0),g=Math.max(0,e.x+e.w-(r.x+r.w)+i),d=s?g:h,_=s?h:g;switch(a){case"start":o=d;break;case"end":o=_;break;default:o=(s?_<0:_>0)?_:d}var c=Math.min(e.y-r.y-i,0),u=Math.max(0,e.y+e.h-(r.y+r.h)+i);switch(n){case"top":l=c;break;case"bottom":l=u;break;default:l=c<0?c:u}this.panBy(o,l,!0)},t.Gantt.prototype.autoPanOnEdgeDrag=function(t,e,a,n){var i=this.getViewportDimensions(),s=0,r=0;if(!a){var o=Math.max(t.x-i.x,0),l=Math.max(i.x+i.w-t.x,0);o<e?(s=o-e,s=Math.max(s,-i.x)):l<e&&(s=e-l,s=Math.min(s,this.getContentLength()-(i.x+i.w)))}if(!n){var h=Math.max(t.y-i.y,0),g=Math.max(i.y+i.h-t.y,0);h<e?(r=h-e,r=Math.max(r,-i.y)):g<e&&(r=e-g,r=this.getContentHeight()+this._databodyStart>=this._canvasSize?"bottom"==this.getAxisPosition()?Math.min(r,this._databody.getTranslateY()+this.getContentHeight()-i.h):Math.min(r,this._databody.getTranslateY()+this.getContentHeight()-this._canvasSize):Math.min(r,-i.y))}return this.panBy(s,r,!0),{deltaX:s,deltaY:r}},t.Gantt.prototype.panBy=function(e,a,n){if(n=void 0!==n&&n,0!=e&&(n||Math.abs(e)>Math.abs(a))&&t.Gantt.superclass.panBy.call(this,e,0),this._databody&&0!=a&&(n||Math.abs(a)>Math.abs(e))){var i=this.getBoundedContentTranslateY(this._databody.getTranslateY()-a);this.isContentDirScrollbarOn()&&this.contentDirScrollbar.setViewportRange(i-this.getDatabodyHeight(),i),this.setDataRegionTranslateY(i,!0)}this.isTimeDirScrollbarOn()&&this.timeDirScrollbar&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime)},t.Gantt.prototype.getBoundedContentTranslateY=function(t){var e=this.getContentHeight();if(null==e)return t;var a=this.getDatabodyHeight(),n=this.getDatabodyStart(),i=n+Math.min(0,a-e);return Math.min(n,Math.max(t,i))},t.Gantt.prototype.beginDragPan=function(e,a){t.Gantt.superclass.beginDragPan.call(this,e,a),this._currentViewStartTime=this._viewStartTime,this._currentViewEndTime=this._viewEndTime},t.Gantt.prototype.endDragPan=function(e,a){this._currentViewStartTime==this._viewStartTime&&this._currentViewEndTime==this._viewEndTime&&(this._triggerViewportChange=!1),t.Gantt.superclass.endDragPan.call(this,e,a)},t.Gantt.prototype.setTaskBrightness=function(t,e){null!=(t=this.findTaskNodeById(t.getId()))&&(e?t.darken():t.brighten())},t.Gantt.prototype.findTaskNodeById=function(e){var a=this.getCtx(),n=this.getRows();if(n)for(var i=0;i<n.length;i++)for(var s=n[i].getTasks(),r=0;r<s.length;r++)if(t.Obj.compareValues(a,e,s[r].getId()))return s[r];return null},t.Gantt.prototype.hasValidOptions=function(){var t=!this._majorAxis||this._majorAxis.hasValidOptions(),e=this._minorAxis&&this._minorAxis.hasValidOptions(),a=this._start&&this._end&&this._end>this._start,n=!this._viewStartTime||!this._viewEndTime||this._viewEndTime>this._viewStartTime,i=!this._viewStartTime||this._viewStartTime>=this._start&&this._viewStartTime<this._end,s=!this._viewEndTime||this._viewEndTime>this._start&&this._viewEndTime<=this._end;return t&&e&&a&&n&&i&&s},t.Gantt.prototype.getSelectionHandler=function(){return this._selectionHandler},t.Gantt.prototype.isSelectionSupported=function(){return!!this._selectionHandler},t.Gantt.prototype.setSelectionMode=function(e){this._selectionHandler="single"==e?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"==e?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):null,this.getEventManager().setSelectionHandler(this._selectionHandler)},t.Gantt.prototype.select=function(e){this.isLastRenderValid()&&(this.Options.selection=t.JsonUtils.clone(e),this._processInitialSelections())},t.Gantt.prototype._processInitialSelections=function(){var t=this.Options.selection;if(null!=t&&0!==t.length&&this.isSelectionSupported()){for(var e=new this._context.KeySetImpl(t),a=this.getRowLayoutObjs(),n=[],i=0;i<a.length;i++)for(var s=a[i].taskObjs,r=0;r<s.length;r++){var o=s[r];if(e.has(o.id)){this._dataLayoutManager.ensureInDOM(o,"task");var l=s[r].node;n.push(l)}}this.getSelectionHandler().processInitialSelections(t,n)}},t.Gantt.prototype.getDependenciesContainer=function(){return this._dependenciesContainer},t.Gantt.prototype.setDependenciesContainer=function(t){this._dependenciesContainer=t},t.Gantt.prototype.setDefaultMarkerId=function(t){this._markerId=t},t.Gantt.prototype.getDefaultMarkerId=function(){return this._markerId},t.Gantt.prototype.getNavigableDependencyLinesForTask=function(t,e){return"successor"==e?t.getSuccessorDependencies():t.getPredecessorDependencies()},t.Gantt.prototype.HandleTouchStart=function(t){};var s=function(t){this._gantt=t};t.Obj.createSubclass(s,t.Automation),s.prototype.GetSubIdForDomElement=function(t){var e=this._gantt.getEventManager().GetLogicalObject(t);if(e&&e instanceof p){var a=e.getLayoutObject().rowObj;return"taskbar["+a.index+"]["+a.taskObjs.map(function(t){return t.node}).indexOf(e)+"]"}return e&&e instanceof c?"rowLabel["+e.getRowIndex()+"]":e&&e instanceof o?e.getLayoutObject().index:null},s.prototype.getDomElementForSubId=function(e){if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._gantt);var a=e.indexOf("["),n=e.indexOf("]"),i=e.substring(0,a);if(a>-1&&n>-1)if("taskbar"==i){var s=e.indexOf("[",a+1),r=e.indexOf("]",s+1);if(s>-1&&r>-1){var o=parseInt(e.substring(a+1,n)),l=parseInt(e.substring(s+1,r));if(isNaN(o)||isNaN(l))return null;if((_=this._gantt.getRowLayoutObjs()).length>o){var h=_[o].taskObjs;if(h.length>l){var g=h[l];this._gantt.getDataLayoutManager().ensureInDOM(g,"task");var d=g.node.getTask().getShape("main");if(null!=d)return d.getElem()}}}}else if("rowLabel"==i){var _;if(o=parseInt(e.substring(a+1,n)),(_=this._gantt.getRowLayoutObjs()).length>o){var c=_[o];this._gantt.getDataLayoutManager().ensureInDOM(c,"rowLabel");var u=c.node.getRowLabelContent();if(null!=u)return u.getDisplayable().getElem()}}else if("dependency"==i){var p=parseInt(e.substring(a+1,n)),b=this._gantt.getDependencyLayoutObjs();if(b.length>p)for(var f=0;f<b.length;f++){var y=b[f];if(y.index===p){this._gantt.getDataLayoutManager().ensureInDOM(y,"dependency");var D=y.node;if(null!=D)return D.getElem()}}}return null};var r=function(t){this.Init({alta:r.VERSION_1},t)};t.Obj.createSubclass(r,t.BaseComponentDefaults),r.VERSION_1={axisPosition:"top",animationOnDataChange:"none",animationOnDisplay:"none",scrollbar:{horizontal:"off",vertical:"off"},gridlines:{horizontal:"hidden",vertical:"visible"},selectionMode:"none",scrollPosition:{y:0},rowDefaults:{height:null},taskDefaults:{labelPosition:["end","innerCenter","start","max"],borderRadius:"0",height:e.getStandaloneTaskHeight(),overlap:{behavior:"auto",offset:null},progress:{height:"100%",borderRadius:"0"},baseline:{height:e.getBaselineTaskHeight(),borderRadius:"0"},type:"auto"},rowAxis:{rendered:"off",width:"max-content",maxWidth:"none"}},r.prototype.getNoCloneObject=function(){return{start:!0,end:!0,viewportStart:!0,viewportEnd:!0,rows:!0,dependencies:!0,referenceObjects:{value:!0}}},r.prototype.getAnimationDuration=function(t){return t._resources?t._resources.animationDuration:null};var o=function(t){this.Init(t)};t.Obj.createSubclass(o,t.Container),o.START_START="startStart",o.START_FINISH="startFinish",o.FINISH_START="finishStart",o.FINISH_FINISH="finishFinish",o.CONFLICT_NONE=0,o.CONFLICT_PREDECESSOR=1,o.CONFLICT_SUCCESSOR=2,o.CONFLICT_BOTH=3,o.prototype.Init=function(t){o.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._gantt.getEventManager().associate(this,this)},o.prototype.getGantt=function(){return this._gantt},o.prototype.getId=function(){return this._dependencyObj.id},o.prototype.setLayoutObject=function(t){this._dependencyObj=t},o.prototype.getLayoutObject=function(){return this._dependencyObj},o.prototype.getValue=function(t){var e;switch(t){case"type":e=this._dependencyObj.type;break;case"predecessorTaskId":e=this._dependencyObj.predecessorTaskObj.id;break;case"successorTaskId":e=this._dependencyObj.successorTaskObj.id;break;default:e=this._dependencyObj.data[t]}return e},o.prototype.getPredecessorNode=function(){return this._dependencyObj.predecessorTaskObj.node},o.prototype.getSuccessorNode=function(){return this._dependencyObj.successorTaskObj.node},o._getTaskStart=function(a){var n=t.Agent.isRightToLeft(a.getGantt().getCtx()),i=a.getTask().getShape("main"),s=a.getTaskLabel(),r=s.getLabelOutputText(),o=s.getEffectiveLabelPosition();return n?null!=r&&null!=r.getParent()&&"end"==o?a.getFinalX()+i.getFinalX()-i.getFinalWidth()-i.getPhysicalEndOffset()-r.getDimensions().w-2*e.getTaskLabelPadding():a.getFinalX()+i.getFinalX()-i.getFinalWidth()-i.getPhysicalEndOffset():null!=r&&null!=r.getParent()&&"start"==o?a.getFinalX()+i.getFinalX()-i.getPhysicalStartOffset()-r.getDimensions().w-2*e.getTaskLabelPadding():a.getFinalX()+i.getFinalX()-i.getPhysicalStartOffset()},o._getTaskMiddle=function(t){var e=t.getTask(),a=e.getShape("main"),n=e.isSummary("main")?t.getLayoutObject().height:a.getFinalHeight();return o._getTaskTop(t)+a.getFinalY()+Math.round(n/2)},o._getTaskEnd=function(a){var n=t.Agent.isRightToLeft(a.getGantt().getCtx()),i=a.getTask().getShape("main"),s=a.getTaskLabel(),r=s.getLabelOutputText(),o=s.getEffectiveLabelPosition();return n?null!=r&&null!=r.getParent()&&"start"==o?a.getFinalX()+i.getFinalX()+i.getPhysicalStartOffset()+r.getDimensions().w+2*e.getTaskLabelPadding():a.getFinalX()+i.getFinalX()+i.getPhysicalStartOffset():null!=r&&null!=r.getParent()&&"end"==o?a.getFinalX()+i.getFinalX()+i.getFinalWidth()+i.getPhysicalEndOffset()+r.getDimensions().w+2*e.getTaskLabelPadding():a.getFinalX()+i.getFinalX()+i.getFinalWidth()+i.getPhysicalEndOffset()},o._getTaskTop=function(t){return t.getFinalY()},o._getTaskBottom=function(t){return o._getTaskTop(t)+t.getFinalHeight()},o._isValidType=function(t){return t===o.START_START||t===o.START_FINISH||t===o.FINISH_START||t===o.FINISH_FINISH},o.prototype.render=function(a){this.getParent()!=a&&a.addChild(this),this.setAriaRole("img");var n=this.getGantt(),i=this.getValue("type"),s=this.getPredecessorNode(),r=this.getSuccessorNode();if(s.addSuccessorDependency(this),r.addPredecessorDependency(this),t.TimeAxis.supportsTouch()&&(this.setAriaProperty("label",this.getAriaLabel()),s.refreshAriaLabel(),r.refreshAriaLabel()),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||this._cleanup(),null!=this._line){this._line.setCmds(o._calcDepLine(n.getCtx(),s,r,i));var l=this._line.getElem()}else{var h=new t.Path(n.getCtx(),o._calcDepLine(n.getCtx(),s,r,i));0===e.getDependencyLineArcRadius()&&h.setPixelHinting(!0),l=h.getElem(),t.ToolkitUtils.setAttrNullNS(l,"marker-end",t.ToolkitUtils.getUrlById(n.getDefaultMarkerId())),this.addChild(h);var g=new t.Stroke(e.getFocusedDependencyLineInnerColor(),1,e.getFocusedDependencyLineInnerWidth()),d=new t.Stroke("#000",1,1);h.setHoverStroke(g,d),this._line=h}var _=this.getValue("svgStyle");_&&this._line.setStyle(_);var c=n.GetStyleClass("dependencyLine"),u=this.getValue("svgClassName");u?t.ToolkitUtils.setAttrNullNS(l,"class",c+" "+u):t.ToolkitUtils.setAttrNullNS(l,"class",c)},o.prototype._cleanup=function(){null!=this._line&&(this.removeChild(this._line),this._line=null)},o.prototype._calcConflict=function(){var t=!1,e=!1,a=this.getValue("type"),n=this.getGantt().getNavigableDependencyLinesForTask(this.getPredecessorNode(),"predecessor");if(null!=n)for(var i=0;i<n.length;i++){var s=n[i].getValue("type");(a!=o.START_START&&a!=o.START_FINISH||s!=o.START_START&&s!=o.FINISH_START)&&(a!=o.FINISH_FINISH&&a!=o.FINISH_START||s!=o.FINISH_FINISH&&s!=o.START_FINISH)||(t=!0)}if(null!=(n=this.getGantt().getNavigableDependencyLinesForTask(this.getSuccessorNode(),"successor")))for(i=0;i<n.length;i++)s=n[i].getValue("type"),(a!=o.START_START&&a!=o.FINISH_START||s!=o.START_START&&s!=o.START_FINISH)&&(a!=o.FINISH_FINISH&&a!=o.START_FINISH||s!=o.FINISH_FINISH&&s!=o.FINISH_START)||(e=!0);return t&&e?o.CONFLICT_BOTH:t?o.CONFLICT_PREDECESSOR:e?o.CONFLICT_SUCCESSOR:o.CONFLICT_NONE},o._calcDepLine=function(e,a,n,i){var s=t.Agent.isRightToLeft(e);switch(i){case o.START_START:return s?o._calcDepLineHelper(a,n,!0,!0):o._calcDepLineHelper(a,n,!1,!1);case o.START_FINISH:return s?o._calcDepLineHelper(a,n,!0,!1):o._calcDepLineHelper(a,n,!1,!0);case o.FINISH_START:return s?o._calcDepLineHelper(a,n,!1,!0):o._calcDepLineHelper(a,n,!0,!1);case o.FINISH_FINISH:return s?o._calcDepLineHelper(a,n,!1,!1):o._calcDepLineHelper(a,n,!0,!0)}return null},o._calcDepLineHelper=function(a,n,i,s){var r=e.getDependencyLineArcRadius(),l=e.getDependencyLineTaskFlankLength(),h=e.getDependencyLineMarkerWidth(),g=i?o._getTaskEnd(a):o._getTaskStart(a),d=s?o._getTaskEnd(n):o._getTaskStart(n),_=o._getTaskMiddle(a),c=o._getTaskMiddle(n),u=c>=_?o._getTaskBottom(a)+e.getDependencyLineTaskGap():o._getTaskTop(a)-e.getDependencyLineTaskGap();g=Math.round(g)+.5,d=Math.round(d)+.5,_=Math.round(_)+.5,c=Math.round(c)+.5,u=Math.round(u)+.5;var p=g+(i?1:-1)*l,b=s?d+l+h:d-l-h,f=t.PathUtils.moveTo(g,_);return i&&b<p||!i&&b>p?(f+=t.PathUtils.horizontalLineTo(p+(i?-1:1)*r),c>_?(f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,p,_+r),i&&s||!i&&!s?(f+=t.PathUtils.verticalLineTo(c-r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,p+(i?-1:1)*r,c)):(f+=t.PathUtils.verticalLineTo(u-r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,p+(i?-1:1)*r,u),f+=t.PathUtils.horizontalLineTo(b+(i?1:-1)*r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,b,u+r),f+=t.PathUtils.verticalLineTo(c-r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,b+(i?1:-1)*r,c))):c<_?(f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,p,_-r),i&&s||!i&&!s?(f+=t.PathUtils.verticalLineTo(c+r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,p+(i?-1:1)*r,c)):(f+=t.PathUtils.verticalLineTo(u+r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,p+(i?-1:1)*r,u),f+=t.PathUtils.horizontalLineTo(b+(i?1:-1)*r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,b,u-r),f+=t.PathUtils.verticalLineTo(c+r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,b+(i?1:-1)*r,c))):(f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,p,_+r),f+=t.PathUtils.verticalLineTo(u-r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,p+(i?-1:1)*r,u),f+=t.PathUtils.horizontalLineTo(b+(i?1:-1)*r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,b,u-r),f+=t.PathUtils.verticalLineTo(c+r),f+=s?t.PathUtils.arcTo(r,r,Math.PI/2,0,b-r,c):t.PathUtils.arcTo(r,r,Math.PI/2,1,b+r,c))):c>_?(f+=t.PathUtils.horizontalLineTo(b+(i?-1:1)*r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,b,_+r),f+=t.PathUtils.verticalLineTo(c-r),f+=s?t.PathUtils.arcTo(r,r,Math.PI/2,1,b-r,c):t.PathUtils.arcTo(r,r,Math.PI/2,0,b+r,c)):c<_?(f+=t.PathUtils.horizontalLineTo(b+(i?-1:1)*r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,b,_-r),f+=t.PathUtils.verticalLineTo(c+r),f+=s?t.PathUtils.arcTo(r,r,Math.PI/2,0,b-r,c):t.PathUtils.arcTo(r,r,Math.PI/2,1,b+r,c)):(i&&s||!i&&!s)&&(f+=t.PathUtils.horizontalLineTo(p+(i?-1:1)*r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?1:0,p,_+r),f+=t.PathUtils.verticalLineTo(u-r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,p+(i?1:-1)*r,u),f+=t.PathUtils.horizontalLineTo(b-r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,b,u-r),f+=t.PathUtils.verticalLineTo(c+r),f+=t.PathUtils.arcTo(r,r,Math.PI/2,i?0:1,b+(i?-1:1)*r,c)),f+=t.PathUtils.lineTo(d,c)},o.prototype.getNextNavigable=function(e){if(e.keyCode==t.KeyboardEvent.UP_ARROW||e.keyCode==t.KeyboardEvent.DOWN_ARROW){var a=this.getKeyboardFocusTask();a||(a=this.getPredecessorNode());var n=this,i=this.getGantt().getEventManager().getKeyboardHandler();if(i&&i.getNextNavigableDependencyLine){var s=a==this.getPredecessorNode()?"successor":"predecessor",r=this.getGantt().getNavigableDependencyLinesForTask(a,s);n=i.getNextNavigableDependencyLine(a,this,e,r)}return n.setKeyboardFocusTask(a),n}return e.keyCode==t.KeyboardEvent.RIGHT_ARROW||e.keyCode==t.KeyboardEvent.LEFT_ARROW?t.Agent.isRightToLeft(this.getGantt().getCtx())?e.keyCode==t.KeyboardEvent.LEFT_ARROW?this.getSuccessorNode():this.getPredecessorNode():e.keyCode==t.KeyboardEvent.RIGHT_ARROW?this.getSuccessorNode():this.getPredecessorNode():e.type==t.MouseEvent.CLICK?this:null},o.prototype.setKeyboardFocusTask=function(t){this._keyboardNavNode=t},o.prototype.getKeyboardFocusTask=function(){return this._keyboardNavNode},o.prototype.getKeyboardBoundingBox=function(t){return this.getDimensions(t)},o.prototype.getTargetElem=function(){return this._line.getElem()},o.prototype.showKeyboardFocusEffect=function(){if(this._line){var e=t.ToolkitUtils.getAttrNullNS(this._line.getElem(),"marker-end");t.ToolkitUtils.addClassName(this._line.getElem(),this._gantt.GetStyleClass("focus")),this._line.showHoverEffect(),null!=e&&t.ToolkitUtils.setAttrNullNS(this._line.getElem(),"marker-end",e),this._isShowingKeyboardFocusEffect=!0}},o.prototype.hideKeyboardFocusEffect=function(){this.isShowingKeyboardFocusEffect()&&(this._line.hideHoverEffect(),t.ToolkitUtils.removeClassName(this._line.getElem(),this._gantt.GetStyleClass("focus")),this._isShowingKeyboardFocusEffect=!1)},o.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},o.prototype.getDatatip=function(t,e,a){return this.getAriaLabel()},o.prototype.getAriaLabel=function(){var e=this.getValue("shortDesc");if(null!=e)return e;var a=this._gantt.getOptions().translations,n=this.getValue("predecessorTaskId"),i=this.getValue("successorTaskId"),s=a[this.getValue("type")+"DependencyAriaDesc"];return e=t.ResourceUtils.format(a.accessibleDependencyInfo,[s,n,i])};var l=function(t){l.superclass.constructor.call(this,t),this._gantt=this._comp};t.Obj.createSubclass(l,t.TimeComponentEventManager),l.prototype.getFocus=function(){var t=l.superclass.getFocus.call(this);if(t&&t instanceof p&&null==t.getRowNode().getParent()){for(var e=t.getLayoutObject(),a=e.rowObj,n=this._gantt.getDataLayoutManager();null==e||!n.isRoot(a)&&n.isHiddenCollapsed(a);){var i=(a=n.getParentRowObj(a)).taskObjs;e=i.length>0?i[0]:null}return e?e.node:null}return t},l.prototype.hideTooltip=function(){this._preventHideTooltip||l.superclass.hideTooltip.call(this),this._preventHideTooltip=!1},l.MOVE_TASKS_DATA_TYPE="text/_dvtdndmovetasks",l.RESIZE_TASKS_DATA_TYPE="text/_dvtdndresizetasks",l._HIGH_LEVEL_DND_NAVIGATION_SCALES=["milliseconds","seconds","minutes","hours","days","weeks","months","quarters","years"],l.KEYBOARD_MOVE="move",l.KEYBOARD_RESIZE_START="resizeStart",l.KEYBOARD_RESIZE_END="resizeEnd",l.prototype.isDndSupported=function(){return!0},l.prototype.isDnDDragging=function(){return this._isDndDragging},l.prototype._dragStartSetup=function(){this._dragInitialX=this._gantt.getTimeZoomCanvas().getTranslateX(),this._dragInitialY=this._gantt.getDatabody().getTranslateY(),this._dragInitialViewportStart=this._gantt.getViewportStartTime(),this._dragInitialViewportEnd=this._gantt.getViewportEndTime()},l.prototype._dragCancelCleanup=function(){if(this._dragInitialX){var t=this._gantt.getTimeZoomCanvas().getTranslateX()-this._dragInitialX,e=this._gantt.getDatabody().getTranslateY()-this._dragInitialY;0===t&&0===e||(this._gantt.panBy(t,e,!0),this._gantt.setViewportStartTime(this._dragInitialViewportStart),this._gantt.setViewportEndTime(this._dragInitialViewportEnd))}this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null},l.prototype._dropCleanup=function(){null==this._dragInitialViewportStart||this._dragInitialViewportStart===this._gantt.getViewportStartTime()&&this._dragInitialViewportEnd===this._gantt.getViewportEndTime()||this._gantt.dispatchEvent(this._gantt.createViewportChangeEvent()),this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null,this._isDndDragging=!1},l.prototype.getKeyboardDnDMode=function(){return this._keyboardDnDMode},l.prototype._handleKeyboardDnDInitiation=function(e,a,n,i,s){var r=t.Agent.isRightToLeft(this._gantt.getCtx())?-1:1;this._isDndDragging=!0,this._dragStartSetup();var o=a.getTask().getShape("main");this._gantt.registerAndConstructGlassPane();var h=this._gantt.installGlassPane();this._keyboardDnDScaleRampIndex=l._HIGH_LEVEL_DND_NAVIGATION_SCALES.indexOf(this._gantt.getTimeAxis().getScale()),a.setDraggedObject(n),a.dragStartSetup();var g=a.localToStage({x:o.getFinalX()+("end"===i)*r*o.getFinalWidth(),y:o.getFinalY()});this._keyboardDnDFeedbackLocalPos=this._gantt.getDnDArtifactsContainer().stageToLocal(g),a.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,a.getRowNode(),{x:0,y:0},!0),h&&(this._preventHideTooltip=!0),this._keyboardDnDSourceObj=a,this._keyboardDnDTargetObj=a.getRowNode();var d=a.getValue("start"),_=a.getValue("end"),c=a.getValue("baseline","start")||null,u=a.getValue("baseline","end")||null;this._keyboardDnDFeedbackTime={start:d,end:_,baselineStart:c,baselineEnd:u};var p=this._gantt.getOptions().translations,b=p[s.initiated];if(this._gantt.isSelectionSupported()&&this._keyboardDnDSourceObj.isSelected()){var f=this._gantt.getSelectionHandler().getSelectedCount();f>1&&(b+=". "+t.ResourceUtils.format(p[s.selectionInfo],[f-1]))}b+=". "+p[s.instruction]+".",this._gantt.updateLiveRegionText(b)},l.prototype.handleKeyboardMoveInitiation=function(t,e){this._keyboardDnDMode=l.KEYBOARD_MOVE;var a=e.getTask().getShape("main");this._handleKeyboardDnDInitiation(t,e,a,"start",{initiated:"taskMoveInitiated",selectionInfo:"taskMoveSelectionInfo",instruction:"taskMoveInitiatedInstruction"})},l.prototype.handleKeyboardResizeStartInitiation=function(t,e){this._keyboardDnDMode=l.KEYBOARD_RESIZE_START;var a=e.getTask().getShape("mainResizeHandleStart");this._handleKeyboardDnDInitiation(t,e,a,"start",{initiated:"taskResizeStartInitiated",selectionInfo:"taskResizeSelectionInfo",instruction:"taskResizeInitiatedInstruction"})},l.prototype.handleKeyboardResizeEndInitiation=function(t,e){this._keyboardDnDMode=l.KEYBOARD_RESIZE_END;var a=e.getTask().getShape("mainResizeHandleEnd");this._handleKeyboardDnDInitiation(t,e,a,"end",{initiated:"taskResizeEndInitiated",selectionInfo:"taskResizeSelectionInfo",instruction:"taskResizeInitiatedInstruction"})},l.prototype._handleKeyboardDnDChronologically=function(e,n){var i,s,r=t.Agent.isRightToLeft(this._gantt.getCtx()),o=this.getKeyboardDnDNavigationScale(),h=this._gantt.getStartTime(),g=this._gantt.getEndTime(),d=this._gantt.getContentLength(),_=this._gantt.getTimeAxis(),c="forward"===n?"next":"previous",u=_.getAdjacentDate(this._keyboardDnDFeedbackTime.start,o,c).getTime(),p=_.getAdjacentDate(this._keyboardDnDFeedbackTime.end,o,c).getTime(),b="auto";switch(this._keyboardDnDMode){case l.KEYBOARD_MOVE:("forward"===n&&u<=g||"backward"===n&&p>=h)&&(s=t.TimeAxis.getDatePosition(h,g,this._keyboardDnDFeedbackTime.start,d),this._keyboardDnDFeedbackTime.start=u,this._keyboardDnDFeedbackTime.end=p,this._keyboardDnDFeedbackTime.baselineStart&&(this._keyboardDnDFeedbackTime.baselineStart=_.getAdjacentDate(this._keyboardDnDFeedbackTime.baselineStart,o,c).getTime(),this._keyboardDnDFeedbackTime.baselineEnd=_.getAdjacentDate(this._keyboardDnDFeedbackTime.baselineEnd,o,c).getTime()),i=t.TimeAxis.getDatePosition(h,g,this._keyboardDnDFeedbackTime.start,d));break;case l.KEYBOARD_RESIZE_START:var f=this._keyboardDnDSourceObj.getValue("end");("forward"===n&&u<=f||"backward"===n&&u>=h)&&(s=t.TimeAxis.getDatePosition(h,g,this._keyboardDnDFeedbackTime.start,d),this._keyboardDnDFeedbackTime.start=u,i=t.TimeAxis.getDatePosition(h,g,this._keyboardDnDFeedbackTime.start,d)),b="start";break;case l.KEYBOARD_RESIZE_END:var y=this._keyboardDnDSourceObj.getValue("start");("forward"===n&&p<=g||"backward"===n&&p>=y)&&(s=t.TimeAxis.getDatePosition(h,g,this._keyboardDnDFeedbackTime.end,d),this._keyboardDnDFeedbackTime.end=p,i=t.TimeAxis.getDatePosition(h,g,this._keyboardDnDFeedbackTime.end,d)),b="end"}null!=i&&(i=r?d-i:i,s=r?d-s:s,this._keyboardDnDFeedbackLocalPos.x+=i-s),this._keyboardDnDSourceObj.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDnDTargetObj,{x:0,y:0},!0),this._keyboardDnDSourceObj.scrollIntoView(b,"auto"),this._gantt.updateLiveRegionText(t.TextUtils.processAriaLabel(a.getDatatip(this._keyboardDnDSourceObj,!1)))},l.prototype.handleKeyboardDnDForward=function(t){this._handleKeyboardDnDChronologically(t,"forward")},l.prototype.handleKeyboardDnDBackward=function(t){this._handleKeyboardDnDChronologically(t,"backward")},l.prototype._handleKeyboardDnDScaleChange=function(e,n){this._isKeyboardDnDScaleChanged=!0,this._keyboardDnDScaleRampIndex=Math.max(0,Math.min(this._keyboardDnDScaleRampIndex+n,l._HIGH_LEVEL_DND_NAVIGATION_SCALES.length-1)),this._keyboardDnDSourceObj.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDnDTargetObj,{x:0,y:0},!0),this._gantt.updateLiveRegionText(t.TextUtils.processAriaLabel(a.getDatatip(this._keyboardDnDSourceObj,!1))),this._isKeyboardDnDScaleChanged=!1},l.prototype.isKeyboardDnDScaleChanged=function(){return this._isKeyboardDnDScaleChanged},l.prototype.getKeyboardDnDNavigationScale=function(){return l._HIGH_LEVEL_DND_NAVIGATION_SCALES[this._keyboardDnDScaleRampIndex]},l.prototype.handleKeyboardDnDScaleUp=function(t){this._handleKeyboardDnDScaleChange(t,1)},l.prototype.handleKeyboardDnDScaleDown=function(t){this._handleKeyboardDnDScaleChange(t,-1)},l.prototype._handleKeyboardMoveRowDirection=function(n,i){var s=this._gantt.getRowLayoutObjs(),r=this._keyboardDnDTargetObj.getIndex();if("above"===i&&r>0)var o=s[r-1];else"below"===i&&r<s.length-1&&(o=s[r+1]);if(o){this._gantt.getDataLayoutManager().ensureInDOM(o,"row"),this._keyboardDnDTargetObj=o.node;var l=this._keyboardDnDTargetObj.localToStage({x:0,y:this._keyboardDnDTargetObj.getFinalY()+e.getTaskPadding()});this._keyboardDnDFeedbackLocalPos.y=this._gantt.getDnDArtifactsContainer().stageToLocal(l).y}this._keyboardDnDSourceObj.showDragFeedback(n,this._keyboardDnDFeedbackLocalPos,this._keyboardDnDTargetObj,{x:0,y:0},!0),this._keyboardDnDSourceObj.scrollIntoView("auto","below"===i?"bottom":"top"),this._gantt.updateLiveRegionText(t.TextUtils.processAriaLabel(a.getDatatip(this._keyboardDnDSourceObj,!1)))},l.prototype.handleKeyboardMoveRowAbove=function(t){this._handleKeyboardMoveRowDirection(t,"above")},l.prototype.handleKeyboardMoveRowBelow=function(t){this._handleKeyboardMoveRowDirection(t,"below")},l.prototype.handleKeyboardDnDFinalize=function(e){var a,n,i,s,r,o;this._dropCleanup();var h=this._gantt.getOptions().translations;if(this._keyboardDnDMode===l.KEYBOARD_MOVE){a=this._getDragDataContexts(this._keyboardDnDSourceObj),n=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),i=new Date(this._keyboardDnDFeedbackTime.end).toISOString();var g=null==this._keyboardDnDFeedbackTime.baselineStart?null:new Date(this._keyboardDnDFeedbackTime.baselineStart).toISOString(),d=null==this._keyboardDnDFeedbackTime.baselineEnd?null:new Date(this._keyboardDnDFeedbackTime.baselineEnd).toISOString();s=n;var _=this._keyboardDnDTargetObj.getDataContext();r=t.EventFactory.newGanttMoveEvent(a,s,n,i,g,d,_),o=h.taskMoveFinalized}else if(this._keyboardDnDMode===l.KEYBOARD_RESIZE_END||this._keyboardDnDMode===l.KEYBOARD_RESIZE_START){var c;a=this._getDragDataContexts(this._keyboardDnDSourceObj).map(function(t){return t.dataContext}),n=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),i=new Date(this._keyboardDnDFeedbackTime.end).toISOString(),this._keyboardDnDMode===l.KEYBOARD_RESIZE_END?(s=i,c="end"):this._keyboardDnDMode===l.KEYBOARD_RESIZE_START&&(s=n,c="start"),r=t.EventFactory.newGanttResizeEvent(a,s,n,i,c),o=h.taskResizeFinalized}r&&(this._gantt.dispatchEvent(r),this._gantt.updateLiveRegionText(o)),this._keyboardDnDCleanup()},l.prototype.handleKeyboardDnDCancel=function(){var t=this._gantt.getOptions().translations;this._keyboardDnDMode===l.KEYBOARD_MOVE?this._gantt.updateLiveRegionText(t.taskMoveCancelled):this._keyboardDnDMode!==l.KEYBOARD_RESIZE_END&&this._keyboardDnDMode!==l.KEYBOARD_RESIZE_START||this._gantt.updateLiveRegionText(t.taskResizeCancelled),this._dragCancelCleanup(),this._keyboardDnDCleanup()},l.prototype._keyboardDnDCleanup=function(){null!=this._keyboardDnDMode&&(this._keyboardDnDSourceObj.dragEndCleanup(),this._keyboardDnDMode=null,this._isDndDragging=!1,this._keyboardDnDSourceObj=null,this._keyboardDnDTargetObj=null,this._keyboardDnDFeedbackTime=null,this._keyboardDnDScaleRampIndex=null,this._gantt.unregisterAndDestroyGlassPane())},l.prototype.getDnDTaskSubType=function(t){if(t instanceof y){var e=t.getType();if("main"===e||"progress"===e)return"tasks";if("mainResizeHandleStart"===e||"mainResizeHandleEnd"===e)return"taskResizeHandles";if("baseline"===e)return null}return"tasks"},l.prototype.GetDragSourceType=function(e){switch(this._keyboardDnDMode){case l.KEYBOARD_MOVE:return this.IsDragSupported("tasks")?"tasks":null;case l.KEYBOARD_RESIZE_END:case l.KEYBOARD_RESIZE_START:return this.IsDragSupported("taskResizeHandles")?"taskResizeHandles":null}var a=this.DragSource.getDragObject();if(a instanceof p){if(e&&"dragstart"===e.getNativeEvent().type){var n=e.getNativeEvent(),i=n.clientX,s=n.clientY,r=n.offsetX,o=n.offsetY;if(null==i&&null==s||("ie"===t.Agent.browser||"edge"===t.Agent.browser)&&isNaN(r)&&isNaN(o)){var h=e.target?e.target:a.getTask().getShape("main");a.setDraggedObject(h)}}var g=this.getDnDTaskSubType(a.getDraggedObject());return this.IsDragSupported(g)?g:null}return null},l.prototype._getDragDataContexts=function(e,a){if(e instanceof p){var n=e.getDraggedObject(),i=n.getType?n.getType():null;if(null!=this.getDnDTaskSubType(n)){var s=function(e){var n=e.getDataContext();switch(a&&t.ToolkitUtils.cleanDragDataContext(n),i){case"mainResizeHandleStart":return{dataContext:n,type:"start"};case"mainResizeHandleEnd":return{dataContext:n,type:"end"}}return n},r=[s(e)];if(this._gantt.isSelectionSupported()&&e.isSelected()&&this._gantt.getSelectionHandler().getSelectedCount()>1)for(var o=this._gantt.getSelectionHandler().getSelection(),l=0;l<o.length;l++){var h=o[l];h instanceof p&&h!==e&&r.push(s(h))}return r}}return null},l.prototype.GetDragDataContexts=function(t){var e=this.DragSource.getDragObject();return this._getDragDataContexts(e,t)},l.prototype.GetDropOffset=function(e){var a=this.DragSource.getDragObject();if(a instanceof p&&"tasks"===this.getDnDTaskSubType(a.getDraggedObject())){var n=a.getValue("start"),i=a.getValue("end"),s=a.getTask().getTimeSpanDimensions(n,i),r=this._context.pageToStageCoords(e.pageX,e.pageY),o=this._gantt.getDnDArtifactsContainer().stageToLocal(r);return new t.Point(s.startPos-o.x,a.getFinalY()-o.y)}return new t.Point(0,0)},l.prototype._getDropObject=function(t){if(t){var e=this.GetLogicalObject(t.target),a=this._gantt.getOptions().dnd,n=this._gantt.isTaskMoveEnabled()||this._gantt.isTaskResizeEnabled(),i=a.drop.tasks&&(a.drop.tasks.dataTypes||a.drop.tasks.drop);this._dropObj=e instanceof p&&n&&!i?e.getRowNode():e}return this._dropObj},l.prototype.GetDropTargetType=function(t){var e=this._getDropObject(t);return e instanceof u?"rows":e instanceof p?"tasks":null},l.prototype.GetDropEventPayload=function(e){var a=e.getNativeEvent().dataTransfer,n=Number(a.getData(t.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,i=t.Agent.isRightToLeft(this._gantt.getCtx()),s=this._getDropObject(e);if(s instanceof u||s instanceof p){var r=this._context.pageToStageCoords(e.pageX,e.pageY),o=this._gantt.getTimeZoomCanvas().stageToLocal(r),l=this._gantt.getStartTime(),h=this._gantt.getEndTime(),g=this._gantt.getContentLength(),d={value:new Date(t.TimeAxis.getPositionDate(l,h,i?g-o.x:o.x,g)).toISOString(),start:null,end:null,baselineStart:null,baselineEnd:null,dataContext:s.getDataContext()},_=this.DragSource.getDragObject();if(_ instanceof p){var c=_.getValue("start"),b=_.getValue("end"),f=_.getValue("baseline","start")||null,y=_.getValue("baseline","end")||null,D=_.getDraggedObject(),m=this.getDnDTaskSubType(D);if("tasks"===m)d.start=t.TimeAxis.getPositionDate(l,h,i?g-(o.x+n):o.x+n,g),d.end=d.start+(b-c),null==f&&null==y||(d.baselineStart=new Date(f-c+d.start).toISOString(),d.baselineEnd=new Date(y-b+d.end).toISOString()),d.start=new Date(d.start).toISOString(),d.end=new Date(d.end).toISOString();else if("taskResizeHandles"===m){"mainResizeHandleEnd"===(D.getType?D.getType():null)?(d.start=new Date(c).toISOString(),d.end=new Date(d.value).getTime()-c<0?c:d.value):(d.start=b-new Date(d.value).getTime()<0?b:d.value,d.end=new Date(b).toISOString())}}return d}return null},l.prototype.ShowDropEffect=function(e){var a=this._getDropObject(e);if(this._gantt.isTaskResizeEnabled()){var n=this.DragSource.getDragObject();if(n instanceof p){var i=n.getDraggedObject();if("taskResizeHandles"===this.getDnDTaskSubType(i))return}}if(a&&a instanceof u){var s=a.getBackground().getElem();t.ToolkitUtils.addClassName(s,this._gantt.GetStyleClass("activeDrop"))}},l.prototype.ShowRejectedDropEffect=function(e){var a=this._getDropObject(e);if(this._gantt.isTaskResizeEnabled()){var n=this.DragSource.getDragObject();if(n instanceof p){var i=n.getDraggedObject();if("taskResizeHandles"===this.getDnDTaskSubType(i))return}}if(a&&a instanceof u){var s=a.getBackground().getElem();t.ToolkitUtils.addClassName(s,this._gantt.GetStyleClass("invalidDrop"))}},l.prototype.ClearDropEffect=function(){var e=this._getDropObject();if(e&&e instanceof u){var a=e.getBackground().getElem();t.ToolkitUtils.removeClassName(a,this._gantt.GetStyleClass("invalidDrop")),t.ToolkitUtils.removeClassName(a,this._gantt.GetStyleClass("activeDrop"))}},l.prototype.OnDndDragStart=function(e){l.superclass.OnDndDragStart.call(this,e),this._isDndDragging&&e.preventDefault();var a=e.getNativeEvent();if(a.defaultPrevented)this._gantt.SetPanningEnabled(!0);else{this._isDndDragging=!0,this._dragStartSetup();var n=this.DragSource.getDragObject();if(n instanceof p){n.dragStartSetup(e);var i=a.dataTransfer;this._dropOffset=new t.Point(Number(i.getData(t.EventManager.DROP_OFFSET_X_DATA_TYPE))||0,Number(i.getData(t.EventManager.DROP_OFFSET_Y_DATA_TYPE))||0)}else this._dropOffset=new t.Point(0,0)}},l.prototype.OnDndDragOver=function(e){l.superclass.OnDndDragOver.call(this,e);var n=this;this._lastKnownDragOverEvent=e,n._isDndDragging=!0,this._isDragOverTicking||this._lastProcessedDragOverEvent&&this._lastKnownDragOverEvent.pageX===this._lastProcessedDragOverEvent.pageX&&this._lastKnownDragOverEvent.pageY===this._lastProcessedDragOverEvent.pageY||(requestAnimationFrame(function(){var e=n.DragSource.getDragObject();if(e instanceof p&&n._isDndDragging)if(n._lastKnownDragOverEvent.getNativeEvent().defaultPrevented){var i=n._gantt.getCtx().pageToStageCoords(n._lastKnownDragOverEvent.pageX,n._lastKnownDragOverEvent.pageY),s=n._gantt.getDnDArtifactsContainer().stageToLocal(i);if(e.showDragFeedback(n._lastKnownDragOverEvent,s,n._getDropObject(),n._dropOffset),t.Agent.isTouchDevice()){var r=t.TextUtils.processAriaLabel(a.getDatatip(e,!1));if(n._gantt.isSelectionSupported()&&e.isSelected()){var o=n._gantt.getSelectionHandler().getSelectedCount();o>1&&(r+=". "+t.ResourceUtils.format(n._gantt.getOptions().translations.taskMoveSelectionInfo,[o-1]))}n._prevScreenReaderDragText&&n._prevScreenReaderDragText===r||n._gantt.updateLiveRegionText(r),n._prevScreenReaderDragText=r}}else e.removeDragFeedbacks();n._lastProcessedDragOverEvent=n._lastKnownDragOverEvent,n._isDragOverTicking=!1}),this._isDragOverTicking=!0)},l.prototype.OnDndDragEnd=function(e){l.superclass.OnDndDragEnd.call(this,e);var a=this.DragSource.getDragObject();a instanceof p&&a.dragEndCleanup(),this._isDndDragging=!1,this._dropOffset=new t.Point(0,0),"none"===e.getNativeEvent().dataTransfer.dropEffect&&this.handleKeyboardDnDCancel(),this._gantt.SetPanningEnabled(!0)},l.prototype.OnDndDrop=function(e){l.superclass.OnDndDrop.call(this,e),this._dropCleanup();var a=e.getNativeEvent();if(a.defaultPrevented){var n=this.DragSource.getDragObject(),i=n.getDraggedObject?this.getDnDTaskSubType(n.getDraggedObject()):"tasks";if(this._gantt.isTaskMoveEnabled()&&"tasks"===i){t.Agent.isTouchDevice()&&this._gantt.updateLiveRegionText(this._gantt.getOptions().translations.taskMoveFinalized);var s=this.GetDropEventPayload(e),r=JSON.parse(a.dataTransfer.getData(l.MOVE_TASKS_DATA_TYPE)),o=s.value,h=s.start,g=s.end,d=s.baselineStart,_=s.baselineEnd,c=s.dataContext,u=t.EventFactory.newGanttMoveEvent(r,o,h,g,d,_,c);this._gantt.dispatchEvent(u)}else if(this._gantt.isTaskResizeEnabled()&&"taskResizeHandles"===i){t.Agent.isTouchDevice()&&this._gantt.updateLiveRegionText(this._gantt.getOptions().translations.taskResizeFinalized);s=this.GetDropEventPayload(e);var p=JSON.parse(a.dataTransfer.getData(l.RESIZE_TASKS_DATA_TYPE)),b=p[0].type;r=p.map(function(t){return t.dataContext}),o=s.value,h=s.start,g=s.end,u=t.EventFactory.newGanttResizeEvent(r,o,h,g,b);this._gantt.dispatchEvent(u)}}},l.prototype.IsDragSupported=function(t){if(this.isDndSupported()){var e=this._gantt.getOptions(),a=e.dnd&&e.dnd.drag?e.dnd.drag:null;return a&&a[t]&&a[t].dataTypes&&a[t].dataTypes.length>0}return!1},l.prototype.IsDropSupported=function(t){if(this.isDndSupported()){var e=this._gantt.getOptions(),a=e.dnd&&e.dnd.drop?e.dnd.drop:null;return a&&a[t]&&a[t].dataTypes}return!1},l.prototype.OnMouseDown=function(t){var e=this.GetLogicalObjectAndDisplayable(t.target);if(e.logicalObject instanceof p){var a=this.getDnDTaskSubType(e.displayable);this.IsDragSupported(a)&&(this._gantt.SetPanningEnabled(!1),e.logicalObject.setDraggedObject(e.displayable))}l.superclass.OnMouseDown.call(this,t)},l.prototype.onExpandCollapseButtonClick=function(t,e){var a=this.GetLogicalObject(e).getRowLayoutObject();this.toggleRowExpandCollapse(t,a)},l.prototype.toggleRowExpandCollapse=function(e,a){if(null!=a.expanded){var n,i,s=this._gantt.getOptions().expanded,r=a.id,o=a.data,l=a.taskObjs[0].data,h=l.id,g=l._itemData;s.has(r)?(i=s.delete([r]),n="collapse"):(i=s.add([r]),n="expand"),this._gantt.setRenderState({state:n,payload:a}),this._gantt.isSelectionSupported()&&this._gantt.getSelectionHandler().clearSelection();var d=t.EventFactory.newGanttExpandCollapseEvent(n,h,o,g,i);this._gantt.dispatchEvent(d)}},l.prototype.HandleImmediateTouchStartInternal=function(t){if(1==t.targetTouches.length){var e=this.GetLogicalObjectAndDisplayable(t.target);if(e.logicalObject instanceof p){var a=this.getDnDTaskSubType(e.displayable);this.IsDragSupported(a)&&(this._gantt.SetPanningEnabled(!1),e.logicalObject.setDraggedObject(e.displayable))}}},l.prototype.OnTouchMoveBubble=function(t){this._isDndDragging&&(this._preventHideTooltip=!0),l.superclass.OnTouchMoveBubble.call(this,t)};var h=function(t,e){this.Init(t,e)};t.Obj.createSubclass(h,t.TimeComponentKeyboardHandler),h.prototype.Init=function(t,e){h.superclass.Init.call(this,e),this._gantt=t},h._findPreviousTask=function(t,e,a,n,i){var s=a.taskObjs;if(0===s.length)return 0===n?i:h._findPreviousTask(t,e,e[n-1],n-1,i);var r=s[s.length-1];return t.getDataLayoutManager().ensureInDOM(r,"task"),r.node},h._findNextTask=function(t,e,a,n,i){var s=a.taskObjs;if(0===s.length)return n==e.length-1?i:h._findNextTask(t,e,e[n+1],n+1,i);var r=s[0];return t.getDataLayoutManager().ensureInDOM(r,"task"),r.node},h.getNextNavigable=function(e,a,n,i){if(a instanceof p){var s=a.getRowNode(),r=e.getRowLayoutObjs(),o=s.getTaskObjs(),l=t.Agent.isRightToLeft(e.getCtx()),g=s.getIndex();switch(n.keyCode){case l?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW:var d=o.map(function(t){return t.node}).indexOf(a);if(0!=d){var _=o[d-1];return e.getDataLayoutManager().ensureInDOM(_,"task"),_.node}if(g>0)return h._findPreviousTask(e,r,r[g-1],g-1,a);break;case l?t.KeyboardEvent.LEFT_ARROW:t.KeyboardEvent.RIGHT_ARROW:if((d=o.map(function(t){return t.node}).indexOf(a))!=o.length-1){_=o[d+1];return e.getDataLayoutManager().ensureInDOM(_,"task"),_.node}if(g<r.length-1)return h._findNextTask(e,r,r[g+1],g+1,a);break;case t.KeyboardEvent.UP_ARROW:if(g>0&&null!=(a=h._findPreviousTask(e,r,r[g-1],g-1,a))){_=a.getRowNode().getTaskObjs()[0];return e.getDataLayoutManager().ensureInDOM(_,"task"),_.node}break;case t.KeyboardEvent.DOWN_ARROW:if(g<r.length-1&&null!=(a=h._findNextTask(e,r,r[g+1],g+1,a))){_=a.getRowNode().getTaskObjs()[0];return e.getDataLayoutManager().ensureInDOM(_,"task"),_.node}}return a}return null},h.prototype.isNavigationEvent=function(e){var a=!1;switch(e.keyCode){case t.KeyboardEvent.OPEN_ANGLED_BRACKET:case t.KeyboardEvent.CLOSE_ANGLED_BRACKET:a=!!e.altKey;break;default:a=h.superclass.isNavigationEvent.call(this,e)}return a},h.prototype._getDistance=function(t){var e=t.getValue("type"),a=t.getPredecessorNode(),n=t.getSuccessorNode(),i=e==o.START_START||e==o.START_FINISH?a.getValue("start"):a.getValue("end");if(e==o.START_START||e==o.FINISH_START)var s=n.getValue("start");else s=n.getValue("end");return Math.abs(s-i)},h.prototype._getDependencyComparator=function(){var t=this;return function(e,a){var n=t._getDistance(e),i=t._getDistance(a);return n<i?-1:n>i?1:0}},h.prototype.getFirstNavigableDependencyLine=function(e,a,n){var i=this._gantt.getCtx(),s=a.keyCode;if(!n||n.length<1||!e)return null;for(var r=t.Agent.isRightToLeft(this._gantt.getCtx()),o=null,l=0,h=0;h<n.length;h++){var g=n[h];if(s==t.KeyboardEvent.CLOSE_ANGLED_BRACKET)var d=r?g.getValue("predecessorTaskId"):g.getValue("successorTaskId");else d=r?g.getValue("successorTaskId"):g.getValue("predecessorTaskId");if(!t.Obj.compareValues(i,e.getId(),d)){var _=this._getDistance(g);(null==o||_<l)&&(l=_,o=g)}}return o},h.prototype.getNextNavigableDependencyLine=function(e,a,n,i){if(!i)return null;if(!a)return i[0];if(!e)return a;i.sort(this._getDependencyComparator());for(var s=n.keyCode==t.KeyboardEvent.DOWN_ARROW,r=0,o=0;o<i.length;o++){if(i[o]===a){r=s?o==i.length-1?0:o+1:0==o?i.length-1:o-1;break}}return i[r]},h.prototype.isMoveInitiationEvent=function(e){return e.keyCode===t.KeyboardEvent.M&&e.ctrlKey},h.prototype.isResizeStartInitiationEvent=function(t){return 83===t.keyCode&&t.altKey},h.prototype.isResizeEndInitiationEvent=function(t){return 69===t.keyCode&&t.altKey},h.prototype.isDnDScaleUpEvent=function(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.PAGE_UP},h.prototype.isDnDScaleDownEvent=function(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.PAGE_DOWN},h.prototype.isDnDForwardEvent=function(e){var a=t.Agent.isRightToLeft(this._gantt.getCtx());return this._eventManager.getKeyboardDnDMode()&&e.keyCode===(a?t.KeyboardEvent.LEFT_ARROW:t.KeyboardEvent.RIGHT_ARROW)},h.prototype.isDnDBackwardEvent=function(e){var a=t.Agent.isRightToLeft(this._gantt.getCtx());return this._eventManager.getKeyboardDnDMode()&&e.keyCode===(a?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW)},h.prototype.isMoveRowAboveEvent=function(e){return this._eventManager.getKeyboardDnDMode()===l.KEYBOARD_MOVE&&e.keyCode===t.KeyboardEvent.UP_ARROW},h.prototype.isMoveRowBelowEvent=function(e){return this._eventManager.getKeyboardDnDMode()===l.KEYBOARD_MOVE&&e.keyCode===t.KeyboardEvent.DOWN_ARROW},h.prototype.isDnDFinalizeEvent=function(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.ENTER},h.prototype.isDnDCancelEvent=function(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.ESCAPE},h.prototype.processKeyDown=function(e){var a=e.keyCode;if(a==t.KeyboardEvent.TAB){var n;if(n=this._eventManager.getFocus())return t.EventManager.consumeEvent(e),n;for(var i=this._gantt.getRowLayoutObjs(),s=0;s<i.length;s++){var r=i[s].taskObjs;if(r.length>0){t.EventManager.consumeEvent(e);var o=r[0];return this._gantt.getDataLayoutManager().ensureInDOM(o,"task"),o.node}}}if(this.isMoveInitiationEvent(e)&&((n=this._eventManager.getFocus())&&this._gantt.isTaskMoveEnabled()&&!this._eventManager.isDnDDragging()))return this._eventManager.handleKeyboardMoveInitiation(e,n),t.EventManager.consumeEvent(e),null;if(this.isResizeStartInitiationEvent(e)&&((n=this._eventManager.getFocus())&&this._gantt.isTaskResizeEnabled()&&!this._eventManager.isDnDDragging()))return this._eventManager.handleKeyboardResizeStartInitiation(e,n),t.EventManager.consumeEvent(e),null;if(this.isResizeEndInitiationEvent(e)&&((n=this._eventManager.getFocus())&&this._gantt.isTaskResizeEnabled()&&!this._eventManager.isDnDDragging()))return this._eventManager.handleKeyboardResizeEndInitiation(e,n),t.EventManager.consumeEvent(e),null;if(this.isDnDCancelEvent(e))return this._eventManager.handleKeyboardDnDCancel(),t.EventManager.consumeEvent(e),null;if(this.isDnDScaleUpEvent(e))return this._eventManager.handleKeyboardDnDScaleUp(e),t.EventManager.consumeEvent(e),null;if(this.isDnDScaleDownEvent(e))return this._eventManager.handleKeyboardDnDScaleDown(e),t.EventManager.consumeEvent(e),null;if(this.isDnDForwardEvent(e))return this._eventManager.handleKeyboardDnDForward(e),t.EventManager.consumeEvent(e),null;if(this.isDnDBackwardEvent(e))return this._eventManager.handleKeyboardDnDBackward(e),t.EventManager.consumeEvent(e),null;if(this.isMoveRowAboveEvent(e))return this._eventManager.handleKeyboardMoveRowAbove(e),t.EventManager.consumeEvent(e),null;if(this.isMoveRowBelowEvent(e))return this._eventManager.handleKeyboardMoveRowBelow(e),t.EventManager.consumeEvent(e),null;if(this.isDnDFinalizeEvent(e))return this._eventManager.handleKeyboardDnDFinalize(e),t.EventManager.consumeEvent(e),null;if(a==t.KeyboardEvent.SPACE&&e.ctrlKey&&e.shiftKey&&((n=this._eventManager.getFocus())&&n instanceof p))return t.EventManager.consumeEvent(e),this._eventManager.toggleRowExpandCollapse(e,n.getLayoutObject().rowObj),null;return h.superclass.processKeyDown.call(this,e)};var g=function(){};t.Obj.createSubclass(g,t.Obj),g.prototype.parse=function(t){var e=new Object,a=function(e){var a=typeof t[e];if("number"===a||"string"===a){var n=new Date(t[e]).getTime();if(!isNaN(n))return n}return null};return e.start=a("start"),e.end=a("end"),t.viewportStart&&(e.viewStart=a("viewportStart")),t.viewportEnd&&(e.viewEnd=a("viewportEnd")),e.rows=t.rows,e.dependencies=t.dependencies,e.axisPosition="top",null!=t.axisPosition&&(e.axisPosition=t.axisPosition),e.selectionMode="none",null!=t.selectionMode&&(e.selectionMode=t.selectionMode),e.horizontalGridline="hidden",e.verticalGridline="hidden",null!=t.gridlines&&(null!=t.gridlines.horizontal&&(e.horizontalGridline=t.gridlines.horizontal),null!=t.gridlines.vertical&&(e.verticalGridline=t.gridlines.vertical)),e.xScrollbar="off",e.yScrollbar="off",t.scrollbars&&(t.scrollbars.horizontal&&(e.xScrollbar=t.scrollbars.horizontal),t.scrollbars.vertical&&(e.yScrollbar=t.scrollbars.vertical)),e.isIRAnimationEnabled="auto"==t.animationOnDisplay,e.isDCAnimationEnabled="auto"==t.animationOnDataChange,null!=t.rowAxis&&(e.rowAxisRendered=t.rowAxis.rendered,e.rowAxisWidth=t.rowAxis.width,e.rowAxisMaxWidth=t.rowAxis.maxWidth),e.referenceObjects=t.referenceObjects,e.styleClass=t.className,e.inlineStyle=t.style,e};var d={};t.Obj.createSubclass(d,t.Obj),d.renderGantt=function(t){if(d._renderBackground(t),d._renderScrollableCanvas(t),t.getAnimationManager().preAnimateGanttIR(t),t.removeEmptyText(),t.hasValidOptions()){d._prepareTaskFillFilters(t),t.renderTimeZoomCanvas(t._canvas);var e=t.getTimeZoomCanvas();if(d._renderAxes(t,e),d._renderDatabodyBackground(t,e),d._renderVerticalGridline(t,e),t.isRowAxisEnabled()&&t.getRowAxis().adjustPosition(),d._renderData(t,e),d._renderReferenceObjects(t,e),d._renderZoomControls(t),t.isDndEnabled()&&d._renderDnDArtifactsContainer(t,e),null!=t.getRenderState()){var a=t.getEventManager().getFocus();a&&a instanceof p&&a.refreshAriaLabel()}t._processInitialSelections(),(t.isTimeDirScrollbarOn()||t.isContentDirScrollbarOn())&&d._renderScrollbars(t,t),t.setIsLastRenderValid(!0)}else d._renderEmptyText(t),t.setIsLastRenderValid(!1)},d._prepareTaskFillFilters=function(a){if(!document.getElementById(e.getTaskTintFilterId())){var n=e.getTaskTintAlpha(),i=t.SvgShapeUtils.createElement("filter",e.getTaskTintFilterId()),s=t.SvgShapeUtils.createElement("feColorMatrix");s.setAttribute("color-interpolation-filters","sRGB"),s.setAttribute("type","matrix"),s.setAttribute("values",1-n+" 0 0 0 "+n+" 0 "+(1-n)+" 0 0 "+n+" 0 0 "+(1-n)+" 0 "+n+" 0 0 0 1 0"),i.appendChild(s);var r=e.getTaskShadeAlpha(),o=t.SvgShapeUtils.createElement("filter",e.getTaskShadeFilterId()),l=t.SvgShapeUtils.createElement("feColorMatrix");l.setAttribute("color-interpolation-filters","sRGB"),l.setAttribute("type","matrix"),l.setAttribute("values",1-r+" 0 0 0 0 0 "+(1-r)+" 0 0 0 0 0 "+(1-r)+" 0 0 0 0 0 1 0"),o.appendChild(l),a.appendSharedDefs(i),a.appendSharedDefs(o)}},d._prerenderTimeDirScrollbar=function(e,a,n){var i=n.w,s=t.CSSStyle.toNumber(e.timeDirScrollbarStyles.getHeight());return e.setTimeDirScrollbar(new t.SimpleScrollbar(e.getCtx(),e.HandleEvent,e)),a.addChild(e.timeDirScrollbar),t.LayoutUtils.position(n,"bottom",e.timeDirScrollbar,i,s,0),new t.Dimension(i,s)},d._prerenderContentDirScrollbar=function(e,a,n){var i=t.CSSStyle.toNumber(e.contentDirScrollbarStyles.getWidth()),s=n.h;return e.setContentDirScrollbar(new t.SimpleScrollbar(e.getCtx(),e.HandleEvent,e)),a.addChild(e.contentDirScrollbar),t.LayoutUtils.position(n,t.Agent.isRightToLeft(e.getCtx())?"left":"right",e.contentDirScrollbar,i,s,0),new t.Dimension(i,s)},d._renderScrollbars=function(e,a){var n=e.getDatabody();if(null!=n){var i=e.getDatabodyStart(),s=e.getCtx(),r=e.getScrollbarPadding();if(null==e._scrollbarsCanvas?(e._scrollbarsCanvas=new t.Container(s,"sbCanvas"),a.addChild(e._scrollbarsCanvas)):e._scrollbarsCanvas.removeChildren(),e.isTimeDirScrollbarOn())var o=e.getCanvasLength(),l=e.Height-r,h=d._prerenderTimeDirScrollbar(e,e._scrollbarsCanvas,new t.Rectangle(0,0,o,l));if(e.isContentDirScrollbarOn()){o=e.Width-r,l=e.getCanvasSize()-e.getAxesHeight();var g=t.Agent.isRightToLeft(e.getCtx())?e.getScrollbarPadding():0,_=d._prerenderContentDirScrollbar(e,e._scrollbarsCanvas,new t.Rectangle(g,0,o-g,l))}if(e.timeDirScrollbar){var c={};c.color=e.timeDirScrollbarStyles.getStyle(t.CSSStyle.COLOR),c.backgroundColor=e.timeDirScrollbarStyles.getStyle(t.CSSStyle.BACKGROUND_COLOR),c.min=e._start,c.max=e._end,c.isHorizontal=!0,c.isReversed=t.Agent.isRightToLeft(e.getCtx()),e.timeDirScrollbar.setTranslateX(e.getStartXOffset()),e.timeDirScrollbar.render(c,h.w,h.h),e.timeDirScrollbar.setViewportRange(e._viewStartTime,e._viewEndTime)}if(e.contentDirScrollbar){(c={}).color=e.contentDirScrollbarStyles.getStyle(t.CSSStyle.COLOR),c.backgroundColor=e.contentDirScrollbarStyles.getStyle(t.CSSStyle.BACKGROUND_COLOR),c.min=-(Math.max(e.getContentHeight(),_.h)-i),c.max=i,c.isHorizontal=!1,c.isReversed=!0,e.contentDirScrollbar.setTranslateY(i+e.getStartYOffset()),e.contentDirScrollbar.render(c,_.w,_.h);var u=0;"bottom"==e.getAxisPosition()&&(u=e.getAxesHeight()),e.contentDirScrollbar.setViewportRange(n.getTranslateY()-(e.getCanvasSize()-i-u),n.getTranslateY())}}else null!=e._scrollbarsCanvas&&e._scrollbarsCanvas.removeChildren()},d.renderRowAxis=function(a,n){var i=t.Agent.isRightToLeft(a.getCtx()),s=a.getRowAxis();if(a.isRowAxisEnabled()){s||((s=new _(a)).setPixelHinting(!0),a.setRowAxis(s)),n&&n.addChild(s),s.render(a.Width-e.getRowAxisGap(),null==n);var r=s.getWidth(),o=r>0?r+e.getRowAxisGap():0;a._backgroundWidth=a._backgroundWidth-o,i||(a._widthOffset=a._widthOffset+o,a.setStartXOffset(a.getStartXOffset()+o)),a._canvasLength=a._canvasLength-o}else n&&n.removeChild(s),a.setRowAxis(null)},d._renderBackground=function(e){var a=e._backgroundWidth,n=e._backgroundHeight;e._background?(e._background.setClipPath(null),e._background.setWidth(a),e._background.setHeight(n),e._background.setX(e._widthOffset)):e._background=new t.Rect(e.getCtx(),e._widthOffset,0,a,n,"bg"),e._background.SetSvgProperty("style","stroke-width:"+2*e.getBorderWidth()+"px"),e._background.setClassName(e.GetStyleClass("databody")),e._background.setPixelHinting(!0);var i=new t.ClipPath;i.addRect(e._widthOffset,0,a,n),e._background.setClipPath(i),e._background.getParent()!=e&&e.addChild(e._background)},d._renderDatabodyBackground=function(e,a){var n=e.getDatabodyBackground();null==n&&(n=new t.Container(e.getCtx()),a.addChild(n),e.setDatabodyBackground(n)),null==e.getDatabody()&&n.setTranslateY(e.scrollPositionToTranslateY(e.getOptions().scrollPosition));var i=new t.ClipPath;i.addRect(0,e.getDatabodyStart(),e.getContentLength(),e.getDatabodyHeight()),n.setClipPath(i)},d._renderDnDArtifactsContainer=function(e,a){var n=e.getDatabody();if(n){var i=e.getDnDArtifactsContainer();null==i&&(i=new t.Container(e.getCtx()),e.setDnDArtifactsContainer(i),i.setTranslateY(n.getTranslateY())),a.addChild(i);var s=new t.ClipPath;s.addRect(0,e.getDatabodyStart(),e.getContentLength(),e.getDatabodyHeight()),i.setClipPath(s)}},d._renderScrollableCanvas=function(e){e._canvas||(e._canvas=new t.Container(e.getCtx(),"canvas"),e.addChild(e._canvas))},d._renderAxes=function(t,e){var a=t.getMajorAxis(),n=t.getMinorAxis(),i=t.getAxisPosition(),s=t.getOptions().majorAxis,r=t.getOptions().minorAxis;if("top"==i){var o=0;a&&(d._renderAxis(t,e,a,o,t.getAxisHeight(s)),o+=a.getSize()),n&&(d._renderAxis(t,e,n,o,t.getAxisHeight(r)),o+=n.getSize()),t.setDatabodyStart(o)}else o=t._canvasSize,a&&(d._renderAxis(t,e,a,null,t.getAxisHeight(s)),o-=a.getSize(),d._positionAxis(a,o)),n&&(d._renderAxis(t,e,n,o,t.getAxisHeight(r)),o-=n.getSize(),d._positionAxis(n,o)),t.setDatabodyStart(0)},d._renderAxis=function(t,e,a,n,i){a.getParent()!==e&&e.addChild(a),a.render(null,t.getContentLength(),i),null!=n&&d._positionAxis(a,n)},d._positionAxis=function(e,a){var n=new t.Matrix(1,0,0,1,0,a);e.setMatrix(n)},d._renderZoomControls=function(a){var n=a.getCtx(),i=a._resources,s=t.Agent.isRightToLeft(n),r={zoomInProps:{imageSize:16,cssUrl:i.zoomIn,cssUrlHover:i.zoomIn_h,cssUrlActive:i.zoomIn_a,cssUrlDisabled:i.zoomIn_d,enabledBackgroundColor:e.getZoomInButtonBackgroundColor(i),enabledBorderColor:e.getZoomInButtonBorderColor(i),hoverBackgroundColor:e.getZoomInButtonHoverBackgroundColor(i),hoverBorderColor:e.getZoomInButtonHoverBorderColor(i),activeBackgroundColor:e.getZoomInButtonActiveBackgroundColor(i),activeBorderColor:e.getZoomInButtonActiveBorderColor(i),disabledBackgroundColor:e.getZoomInButtonDisabledBackgroundColor(i),disabledBorderColor:e.getZoomInButtonDisabledBorderColor(i)},zoomOutProps:{imageSize:16,cssUrl:i.zoomOut,cssUrlHover:i.zoomOut_h,cssUrlActive:i.zoomOut_a,cssUrlDisabled:i.zoomOut_d,enabledBackgroundColor:e.getZoomOutButtonBackgroundColor(i),enabledBorderColor:e.getZoomOutButtonBorderColor(i),hoverBackgroundColor:e.getZoomOutButtonHoverBackgroundColor(i),hoverBorderColor:e.getZoomOutButtonHoverBorderColor(i),activeBackgroundColor:e.getZoomOutButtonActiveBackgroundColor(i),activeBorderColor:e.getZoomOutButtonActiveBorderColor(i),disabledBackgroundColor:e.getZoomOutButtonDisabledBackgroundColor(i),disabledBorderColor:e.getZoomOutButtonDisabledBorderColor(i)}};if(s)var o=a.getStartXOffset()+e._DEFAULT_ZOOM_CONTROL_PADDING;else o=a.getCanvasLength()+a.getStartXOffset()-(e._DEFAULT_ZOOM_CONTROL_PADDING+e._DEFAULT_ZOOM_CONTROL_DIAMETER);r.zoomInProps.posX=o,r.zoomOutProps.posX=o;var l=a._startY+e._DEFAULT_ZOOM_CONTROL_PADDING;if("top"==a.getAxisPosition())var h=l;else h=a._backgroundHeight-l;if("top"==a.getAxisPosition())var g=h,d=h+e._DEFAULT_ZOOM_CONTROL_DIAMETER+e._DEFAULT_ZOOM_CONTROL_SPACING;else g=h-2*e._DEFAULT_ZOOM_CONTROL_DIAMETER-e._DEFAULT_ZOOM_CONTROL_SPACING,d=h-e._DEFAULT_ZOOM_CONTROL_DIAMETER;r.zoomInProps.posY=g,r.zoomOutProps.posY=d,a.renderZoomControls(r)},d._renderEmptyText=function(e,a){if(a){var n=e.getDatabody();n&&n.getParent()&&(n.getParent().removeChild(n),e.setDatabody(null)),e.getDataLayoutManager().clear();var i=e.getOptions().translations.labelNoData;e.removeEmptyText()}else i=e.getOptions().translations.labelInvalidData,e.clearComponent();var s=t.TextUtils.renderEmptyText(e._canvas,i,new t.Rectangle(0,0,e._backgroundWidth,e._backgroundHeight),e.EventManager,null);s.setClassName(e.GetStyleClass("nodata")),e.setEmptyText(s)},d._renderDatabody=function(e,a){var n=e.getDatabody();null==n&&(n=new t.Container(e.getCtx(),"db"),a.addChild(n),e.setDatabody(n),n.setTranslateY(e.getDatabodyBackground().getTranslateY()));var i=new t.ClipPath;i.addRect(0,e.getDatabodyStart(),e.getContentLength(),e.getDatabodyHeight()),n.setClipPath(i)},d._renderVerticalGridline=function(e,a){var n=e.getVerticalGridlines();if(null!=n&&n.removeChildren(),e.isVerticalGridlinesVisible()){null==n&&(n=new t.Container(e.getCtx()),a.addChild(n),e.setVerticalGridlines(n));var i=e.GetStyleClass("vgridline"),s=e.getMajorAxis();(null==s||e.getOptions().minorGridline)&&(s=e.getMinorAxis());for(var r=s.getElem().getElementsByTagName("line"),o=0;o<r.length;o++){var l=t.ToolkitUtils.getAttrNullNS(r[o],"x1"),h=new t.Line(e.getCtx(),l,e.getDatabodyStart(),l,e.getDatabodyStart()+e._canvasSize-e.getAxesHeight());h.setPixelHinting(!0),h.setClassName(i,!0),n.addChild(h)}}},d._renderReferenceObjects=function(e,a){var n=e.getCtx(),i=t.Agent.isRightToLeft(n),s=e.getStartTime(),r=e.getEndTime(),o=e.getContentLength(),l=e.getReferenceObjects(),h=e.getReferenceObjectsContainer(),g=e.getRenderedReferenceObjects();if(l){var d=[],_=Math.min(1,l.length);null==h&&(h=new t.Container(n),e.setReferenceObjectsContainer(h),g=[]),a.addChild(h);for(var c=0;c<_;c++){var u=l[c];if(u){var p=u.value,b=new Date(p).getTime();if(null!=p&&!isNaN(b)&&("number"==typeof p||"string"==typeof p)){var f=t.TimeAxis.getDatePosition(s,r,b,o);i&&(f=o-f);var y=g.pop();null!=y?(y.setX1(f),y.setY1(e.getDatabodyStart()),y.setX2(f),y.setY2(e.getDatabodyStart()+e._canvasSize-e.getAxesHeight())):(y=new t.Line(e.getCtx(),f,e.getDatabodyStart(),f,e.getDatabodyStart()+e._canvasSize-e.getAxesHeight())).setPixelHinting(!0),y.getParent()!=h&&h.addChild(y),d.push(y);var D=u.svgStyle;D&&y.setStyle(D);var m=e.GetStyleClass("referenceObject"),v=u.svgClassName;v=v?m+" "+v:m,y.setClassName(v,!0)}}}for(var S=0;S<g.length;S++){var T=g[S];T.getParent().removeChild(T)}e.setRenderedReferenceObjects(d)}else h&&h.removeChildren(),e.setRenderedReferenceObjects([])},d._renderData=function(t,a){var n=t.getOptions(),i=t.getRowLayoutObjs(),s=t.getDependencyLayoutObjs();0!==i.length?(d._renderDatabody(t,a),s.length>0&&d._renderDependenciesContainer(t,a),t.getCache().getFromCache("baseTaskLabelCSSStyle")||t.getCache().putToCache("baseTaskLabelCSSStyle",e.getTaskLabelStyle(n)),t.setDataRegionTranslateY(t.getBoundedContentTranslateY(t.getDatabody().getTranslateY()))):d._renderEmptyText(t,!0)},d._renderDependenciesContainer=function(e,a){var n=e.getDependenciesContainer();null==n&&((n=new t.Container(e.getCtx())).setTranslateY(e.getDatabody().getTranslateY()),a.addChild(n),e.setDependenciesContainer(n),e.setDefaultMarkerId(d._createDefaultMarker(e)));var i=new t.ClipPath;i.addRect(0,e.getDatabodyStart(),e.getContentLength(),e.getDatabodyHeight()),n.setClipPath(i)},d._createDefaultMarker=function(a){var n=a.getCtx(),i=t.SvgShapeUtils.getUniqueId("mrk"),s=t.SvgShapeUtils.createElement("marker",i);t.ToolkitUtils.setAttrNullNS(s,"class",a.GetStyleClass("dependencyLineConnector")),t.ToolkitUtils.setAttrNullNS(s,"markerUnits","userSpaceOnUse");var r=t.SvgShapeUtils.createElement("path"),o=e.getDependencyLineMarkerWidth(),l=e.getDependencyLineMarkerHeight();return t.ToolkitUtils.setAttrNullNS(s,"viewBox","0 0 "+o+" "+l),t.ToolkitUtils.setAttrNullNS(s,"refX",o),t.ToolkitUtils.setAttrNullNS(s,"refY",l/2),t.ToolkitUtils.setAttrNullNS(s,"markerWidth",o),t.ToolkitUtils.setAttrNullNS(s,"markerHeight",l),t.ToolkitUtils.setAttrNullNS(s,"orient","auto"),t.ToolkitUtils.setAttrNullNS(r,"d","M0,0L"+o+","+l/2+",0,"+l+"V0Z"),s.appendChild(r),n.appendDefs(s),i};var _=function(t){this.Init(t)};t.Obj.createSubclass(_,t.Container),_.prototype.Init=function(t){_.superclass.Init.call(this,t.getCtx()),this._gantt=t},_.prototype.getDefaultRowLabelStyle=function(t){var a=this._gantt.getOptions();return t?(this._defaultLabelCSSStyle||(this._defaultLabelCSSStyle=e.getRowLabelStyle(a)),this._defaultLabelCSSStyle):e.getRowLabelStyle(a)},_.prototype._getCSSStyle=function(t){if(null!=t&&""!==t&&0!==Object.keys(t).length){var e=this.getDefaultRowLabelStyle(!1);return e.parseInlineStyle(t),e}return this.getDefaultRowLabelStyle(!0)},_.prototype.getLabelContentType=function(){var t=this._gantt.getOptions().rowAxis;return t.label&&t.label.renderer?"custom":"text"},_.prototype._getAvailableWidth=function(t){var a,n,i=this._gantt.getRowAxisMaxWidth(),s=this._gantt.getRowAxisWidth();return null!=i&&"none"!==i&&(a=Math.min(e.getSizeInPixels(i,t),t)),a=null==a||isNaN(a)?t:a,null!=s&&"max-content"!==s&&(n=e.getSizeInPixels(this._gantt.getRowAxisWidth(),t)),{maxWidth:a,width:n=null==n||isNaN(n)?-1:n,calculatedWidth:-1!==n?Math.min(n,a):a}},_.prototype.getAvailableWidth=function(){return this._availableWidth},_.prototype.getWidth=function(){return this._width},_.prototype.getLabelContentIndentSize=function(t){return t.depth*e.getRowLabelIndentSize()+e.getRowLabelButtonSize()+e.getRowLabelButtonContentGapSize()},_.prototype._getMaxTextContentWidth=function(e,a,n){if(!this._gantt.isRowsHierarchical())return t.TextUtils.getMaxTextStringWidth(e,a,n);for(var i=this._gantt.getRowLayoutObjs(),s=0,r=0;r<a.length;r++){var o=a[r]?a[r]:"",l=n[r],h=t.TextUtils.getTextStringWidth(e,o,l),g=(null==i[r].expanded&&0==o.length?0:this.getLabelContentIndentSize(i[r]))+h;g>s&&(s=g)}return s},_.prototype.render=function(t,e){if(this._availableWidth=this._getAvailableWidth(t),e)-1!==this._availableWidth.width&&(this._width=this._availableWidth.calculatedWidth);else{this._rowLabelContents=[];var a=this.getLabelContentType(),n=this._gantt.getRowLayoutObjs();if(-1===this._availableWidth.width){if("text"===a){for(var i=[],s=[],r=0;r<n.length;r++){var o=n[r].data,l=null!=o.label?o.label:"",h=this._getCSSStyle(o.labelStyle);i.push(l),s.push(h),this._rowLabelContents.push(null)}this._width=this._getMaxTextContentWidth(this._gantt.getCtx(),i,s)}else if("custom"===a){this._width=0;for(r=0;r<n.length;r++){var g=n[r],d=new c(this,a);d.setRowIndex(r),d.render(g),this._width=Math.max(this._width,d.getWidth()),this._rowLabelContents.push(d)}}}else{this._width=this._availableWidth.calculatedWidth;for(r=0;r<n.length;r++)this._rowLabelContents.push(null)}this._width=Math.ceil(Math.min(this._width,this._availableWidth.maxWidth))}},_.prototype.getRowLabelContents=function(){return this._rowLabelContents},_.prototype.adjustPosition=function(){var a=t.Agent.isRightToLeft(this._gantt.getCtx()),n=this._width,i=this._gantt.getCanvasSize()-this._gantt.getAxesHeight();a?this.setTranslateX(this._gantt.getStartXOffset()+this._gantt.getCanvasLength()+this._gantt.getBorderWidth()+e.getRowAxisGap()):this.setTranslateX(0);var s=new t.ClipPath;s.addRect(this.getTranslateX(),this._gantt.getDatabodyStart()+this._gantt.getStartYOffset(),n,i),this.setClipPath(s)};var c=function(t,e){this.Init(t,e)};t.Obj.createSubclass(c,t.Obj),c.prototype.Init=function(t,e){this._rowAxis=t,this._gantt=t._gantt,this._contentType=e},c.prototype.render=function(e){var a=e.data;this._labelString=null!=a.label?a.label:"";var n=t.Agent.isRightToLeft(this._gantt.getCtx()),i=this._rowAxis.getAvailableWidth();this._content||(this._content="custom"===this._contentType?this._getCustomContent(e,i):this._getTextContent(e)),this._contentDisplayable=this._gantt.isRowsHierarchical()?this._addExpandCollapseButton(this._content,e):this._content,this._gantt.getEventManager().associate(this._contentDisplayable,this,!0),this._rowAxis.addChild(this._contentDisplayable);var s=this._contentDisplayable.getDimensions();"g"===this.getDisplayableType()?(this._width=n?-Math.min(0,s.x):s.x+s.w,this._width=Math.max(0,this._width),this._height=s.y+s.h):(this._width=Math.min(s.w,i.calculatedWidth),this._height=s.h)},c.prototype._getCustomContent=function(e,a){var n=e.data,i=new t.Container(this._gantt.getCtx());i.setClassName(this._gantt.GetStyleClass("rowLabel"));var s=n.labelStyle;null!=s&&i.setStyle(s);var r=this._gantt.getOptions().rowAxis.label.renderer,o=this._gantt.getRowAxisMaxWidth();if(-1===a.width&&null!=o&&"none"===o)var l=-1;else l=this._gantt.isRowsHierarchical()?Math.max(0,a.calculatedWidth-this._rowAxis.getLabelContentIndentSize(e)):a.calculatedWidth;var h=e.height,g=i.getContainerElem(),d=r(this.getRendererContext(n,l,h,g));return d&&(Array.isArray(d)?d.forEach(function(e){t.ToolkitUtils.appendChildElem(g,e)}):t.ToolkitUtils.appendChildElem(g,d)),i},c.prototype._getTextContent=function(e){var a=e.data,n=new t.OutputText(this._gantt.getCtx(),this._labelString,0,0);n.setClassName(this._gantt.GetStyleClass("rowLabel"));var i=a.labelStyle;return null!=i&&""!==i&&0!==Object.keys(i).length&&n.setStyle(i),n.setCSSStyle(this._rowAxis._getCSSStyle(i)),n},c.prototype._addExpandCollapseButton=function(a,n){var i=t.Agent.isRightToLeft(this._gantt.getCtx()),s=new t.Container(this._gantt.getCtx()),r=this._rowAxis.getLabelContentIndentSize(n),o=i?-r:r;if(i&&"text"===this._contentType&&(o-=a.getDimensions().w),a.setTranslateX(o),null!=n.expanded){var l=e.getRowLabelButtonSize(),h=r-(l+e.getRowLabelButtonContentGapSize());h=i?-(h+l):h;var g=(a.getDimensions().h-l)/2,d=this._gantt.getEventManager(),_=this._createExpandCollapseButton(this._gantt.getCtx(),this._gantt.getOptions()._resources,n.expanded?"open":"closed",h,g,l,d.onExpandCollapseButtonClick,d);this._button=_,s.addChild(_)}else this._button=null;return s.addChild(a),s},c.prototype._createExpandCollapseButton=function(e,a,n,i,s,r,o,l){var h=this._createButtonImage(e,a[n+"Enabled"],i,s,r),g=this._createButtonImage(e,a[n+"Over"],i,s,r),d=this._createButtonImage(e,a[n+"Down"],i,s,r),_=new t.Button(e,h,g,d,null,null,o,l);return _.setAriaRole("button"),_.setAriaProperty("label",this.getAriaLabel()),this._gantt.getEventManager().associate(_,this),_},c.prototype._createButtonImage=function(e,a,n,i,s){var r=new t.Image(e,a,n,i,s,s);return r.setInvisibleFill(),r},c.prototype.getRendererContext=function(e,a,n,i){var s=this._gantt.getOptions(),r=e.tasks,o=[];if(s.taskData)for(var l=0;l<r.length;l++)o.push(r[l]._itemData);var h={component:s._widgetConstructor,parentElement:i,rowData:t.TimeComponent.sanitizeData(e,"row"),itemData:s.taskData?o:null,maxWidth:a,maxHeight:n};return this._gantt.getCtx().fixRendererContext(h)},c.prototype.getRow=function(){return this._rowNode},c.prototype.setRow=function(t){this._rowNode=t},c.prototype.getRowIndex=function(){return this._rowIndex},c.prototype.setRowIndex=function(t){this._rowIndex=t},c.prototype.getRowLayoutObject=function(){return this._gantt.getRowLayoutObjs()[this.getRowIndex()]},c.prototype.getDisplayable=function(){return this._contentDisplayable},c.prototype.getExpandCollapseButton=function(){return this._button},c.prototype.getLabelString=function(){return this._labelString},c.prototype.getDisplayableType=function(){return this._gantt.isRowsHierarchical()||"custom"===this._contentType?"g":"text"},c.prototype.getContentType=function(){return this._contentType},c.prototype.getX=function(){return"text"===this.getDisplayableType()?this._contentDisplayable.getX():this._contentDisplayable.getTranslateX()},c.prototype.setX=function(t){"text"===this.getDisplayableType()?this._contentDisplayable.setX(t):this._contentDisplayable.setTranslateX(t)},c.prototype.getY=function(){return"text"===this.getDisplayableType()?this._contentDisplayable.getY():this._contentDisplayable.getTranslateY()},c.prototype.setY=function(t){"text"===this.getDisplayableType()?this._contentDisplayable.setY(t):this._contentDisplayable.setTranslateY(t)},c.prototype.getWidth=function(){return this._width},c.prototype.getHeight=function(){return this._height},c.prototype.getAriaLabel=function(){var e=this._gantt.getOptions().translations,a=[],n=this.getRowLayoutObject();return null!=n.expanded&&a.push(e[n.expanded?"stateExpanded":"stateCollapsed"]),t.Displayable.generateAriaLabel(e.labelLevel+" "+n.depth+", "+this.getLabelString(),a)};var u=function(t){this.Init(t)};t.Obj.createSubclass(u,t.Container),u.prototype.Init=function(t){u.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._gantt.getEventManager().associate(this,this)},u.prototype.getId=function(){return this._rowObj.id},u.prototype.getGantt=function(){return this._gantt},u.prototype.setLayoutObject=function(t){this._rowObj=t},u.prototype.getLayoutObject=function(){return this._rowObj},u.prototype.getData=function(e){return e?t.TimeComponent.sanitizeData(this._rowObj.data,"row"):this._rowObj.data},u.prototype.getIndex=function(){return this._rowObj.index},u.prototype.getFinalY=function(){return this._rowObj.y},u.prototype.getLabel=function(){return this._rowObj.data.label},u.prototype.getFinalY=function(){return this._rowObj.y},u.prototype.setRowLabelContent=function(t){this._rowLabelContent=t},u.prototype.getRowLabelContent=function(){return this._rowLabelContent},u.prototype.getRenderState=function(){return this._rowObj.renderState},u.prototype.getTaskObjs=function(){return this._rowObj.taskObjs},u.prototype.getRenderOrderTaskObjs=function(){var t=this._rowObj.taskObjs;if(this._rowObj.earliestOverlayTaskObj){var e=[],a=[];return t.forEach(function(t){"overlay"===t.overlapBehavior?e.push(t):a.push(t)}),a.concat(e)}return t},u.prototype.render=function(t){for(var e=this.getRenderOrderTaskObjs(),a=0;a<e.length;a++){var n,i=e[a];if(!(n=i.node))(n=new p(this._gantt)).setLayoutObject(i),i.node=n;var s=(l=n.getTask()).getTimeSpanDimensions(n.getValue("start"),n.getValue("end"));s||(s=l.getTimeSpanDimensions(n.getValue("baseline","start"),n.getValue("baseline","end"))),i.x=s.startPos,n.render(this)}for(var r=0;r<e.length;r++){var o=(n=(i=e[r]).node).getTaskLabel(),l=n.getTask();o.setAssociatedShape(l.getShape("main")),o.render(),this._gantt.isTaskResizeEnabled()?l.renderMainResizeHandles(n):l.removeHandles()}this._gantt.isRowAxisEnabled()&&this._gantt.getRowAxis()&&this._finalizeRowLabelRender(this._gantt),this._renderBackground(this._gantt,this._gantt.getDatabodyBackground()),this._renderHorizontalGridline(this._gantt,this),t.addChild(this)},u.prototype._finalizeRowLabelRender=function(e){var a=t.Agent.isRightToLeft(e.getCtx()),n=this.getRowLabelContent(),i=this.getFinalY(),s=this._rowObj.height,r=e.getRowAxis();if("g"===n.getDisplayableType())var o=a?r.getWidth():0;else{var l=n.getDisplayable();l.isTruncated()&&l.setTextString(l.getUntruncatedTextString()),t.TextUtils.fitText(l,r.getWidth(),s,r,1),a?o=0:(l.alignRight(),o=r.getWidth())}var h=(i+(i+s)-n.getHeight())/2;n.setRow(this);var g={x:o,y:h},d=this.getLabelState();d&&(n.setY(d.y),n.setX(d.x)),this.recordLabelState(g),this._gantt.getAnimationManager().preAnimateRowLabel(this,n,g)},u.prototype._renderBackground=function(e,a){var n,i=this._rowObj.y,s=e.getContentLength(),r=this._rowObj.height,o="exist";this._background||(this._background=new t.Rect(e.getCtx(),0,i,s,r),this._background.setPixelHinting(!0),this._background.setClassName(e.GetStyleClass("row")),o="add",this._gantt.getEventManager().associate(this._background,this)),a.addChild(this._background),n={y:i,w:s,h:r},this._gantt.getAnimationManager().preAnimateRowBackground(this._background,n,o)},u.prototype.getBackground=function(){return this._background},u.prototype._renderHorizontalGridline=function(a,n){var i,s,r,o,l="exist",h=a.GetStyleClass("hgridline"),g=e.getHorizontalGridlineWidth(a.getOptions())%2*.5;a.isHorizontalGridlinesVisible()?(r=s=this._rowObj.y+this._rowObj.height+g,0,i=a.getContentLength(),this._horizontalLine||(this._horizontalLine=new t.Line(a.getCtx(),0,s,i,r),this._horizontalLine.setPixelHinting(!0),this._horizontalLine.setClassName(h,!0),n.addChild(this._horizontalLine),l="add"),o={x1:0,x2:i,y1:s,y2:r},this._gantt.getAnimationManager().preAnimateHorizontalGridline(this._horizontalLine,o,l)):(this._horizontalLine&&n.removeChild(this._horizontalLine),this._horizontalLine=null)},u.prototype.recordLabelState=function(t){this._rowLabelState=t},u.prototype.getLabelState=function(){return this._rowLabelState},u.prototype.remove=function(){var t,e=this;t=function(){if(e._background){var t=e._background.getParent();t&&t.removeChild(e._background)}var a=e.getParent();a&&a.removeChild(e)},this._gantt.getAnimationManager().preAnimateRowNodeRemove(this,t),this._removeRowLabel()},u.prototype._removeRowLabel=function(){var t,e,a=this.getRowLabelContent(),n=this._gantt.getRowAxis();a&&n&&(t=a.getDisplayable())&&(null==t.getParent()&&n.addChild(t),e=function(){t.getParent()&&t.getParent().removeChild(t)},this._gantt.getAnimationManager().preAnimateRowLabelRemove(a,e))},u.prototype.getDataContext=function(){return{rowData:this.getData(!0),component:this._gantt.getOptions()._widgetConstructor}};var p=function(t){this.Init(t)};t.Obj.createSubclass(p,t.Container),p.prototype.Init=function(t){p.superclass.Init.call(this,t.getCtx(),null),this._gantt=t,this._task=new b(t,this),this._taskLabel=new f(t,this),this._gantt.getEventManager().associate(this,this)},p.prototype.getId=function(){return this._taskObj.id},p.prototype.setLayoutObject=function(t){this._taskObj=t},p.prototype.getLayoutObject=function(){return this._taskObj},p.prototype.getData=function(e){return e?t.TimeComponent.sanitizeData(this._taskObj.data,"task"):this._taskObj.data},p.prototype.getValue=function(t,e){var a,n=this._gantt.getOptions().taskDefaults;switch(t){case"start":a=this._taskObj.startTime;break;case"end":a=this._taskObj.endTime;break;case"height":a=this._taskObj.height;break;case"baseline":if("height"===e){a=this._taskObj.baselineHeight;break}if((a=this._taskObj.data.baseline)&&null!=e)switch(e){case"start":a=this._taskObj.baselineStartTime;break;case"end":a=this._taskObj.baselineEndTime;break;default:a=null!=a[e]?a[e]:n.baseline[e]}break;case"progress":if("height"===e){a=this._taskObj.progressHeight;break}(a=this._taskObj.data.progress)&&null!=e&&(a=null!=a[e]?a[e]:n.progress[e]);break;default:a=null!=this._taskObj.data[t]?this._taskObj.data[t]:n[t]}return a},p.prototype.getSandboxValue=function(t,e){var a=this.getSandboxData(),n=this._gantt.getOptions().taskDefaults,i=a[t],s=n[t];return i&&null!=e&&(i=i[e]),s&&null!=e&&(s=s[e]),null!=i?i:s},p.prototype.getSandboxData=function(){if(!this._sandboxData){this._sandboxData=t.JsonUtils.clone(t.TimeComponent.sanitizeData(this._taskObj.data,"task")),this._sandboxData._rowNode=this.getRowNode(),this._sandboxData.start=this._taskObj.startTime,this._sandboxData.end=this._taskObj.endTime,this._sandboxData.height=this._taskObj.height;var e=this._sandboxData.baseline;e&&(e.start=this._taskObj.baselineStartTime,e.end=this._taskObj.baselineEndTime,e.height=this._taskObj.baselineHeight);var a=this._sandboxData.progress;a&&(a.height=this._taskObj.progressHeight)}return this._sandboxData},p.prototype.getRowNode=function(){return this._taskObj.rowObj.node},p.prototype.getGantt=function(){return this._gantt},p.prototype.getRenderState=function(){return this._taskObj.renderState},p.prototype.getPreviousAdjacentTaskNode=function(){return this._taskObj.previousAdjacentTaskObj?this._taskObj.previousAdjacentTaskObj.node:null},p.prototype.getNextAdjacentTaskNode=function(){return this._taskObj.nextAdjacentTaskObj?this._taskObj.nextAdjacentTaskObj.node:null},p.prototype.getPrevAdjMilestoneBaselineTaskNode=function(){return this._taskObj.prevAdjMilestoneBaselineTaskObj?this._taskObj.prevAdjMilestoneBaselineTaskObj.node:null},p.prototype.getNextAdjMilestoneBaselineTaskNode=function(){return this._taskObj.nextAdjMilestoneBaselineTaskObj?this._taskObj.nextAdjMilestoneBaselineTaskObj.node:null},p.prototype.getTaskShapePhysicalBounds=function(a,n){var i=t.Agent.isRightToLeft(this._gantt.getCtx())?-1:1,s=this._task.getShape(a),r=s.getFinalX()+this.getFinalX(),o=s.getFinalWidth()+s.getPhysicalEndOffset(),l=r-i*s.getPhysicalStartOffset(),h=r+i*o;if(n){var g=this._taskLabel.getLabelOutputText();if(g&&null!=g.getParent()){var d=this._taskLabel.getEffectiveLabelPosition();"end"===d?h+=i*(e.getTaskLabelPadding()+g.getDimensions().w):"start"===d&&(l-=i*(e.getTaskLabelPadding()+g.getDimensions().w))}}return{startPos:l,endPos:h}},p.prototype.scrollIntoView=function(a,n){var i,s,r,o,h=t.Agent.isRightToLeft(this._gantt.getCtx()),g=this._gantt.getDatabody();this._gantt.getDataLayoutManager().ensureInDOM(this.getLayoutObject(),"task");var d,_,c=this._gantt.getEventManager().getKeyboardDnDMode();c===l.KEYBOARD_MOVE&&this._mainDragFeedbacks&&this._mainDragFeedbacks.length>0?(d=this._mainDragFeedbacks[0],_=this._gantt.getDnDArtifactsContainer()):(c===l.KEYBOARD_RESIZE_START||c===l.KEYBOARD_RESIZE_END)&&this._mainResizeHandleDragFeedbacks&&this._mainResizeHandleDragFeedbacks.length>0?(d=this._mainResizeHandleDragFeedbacks[0],_=this._gantt.getDnDArtifactsContainer()):(d=(d=this.getTask().getShape("main"))||this.getTask().getShape("baseline"),_=this),r=d.getWidth()+d.getPhysicalStartOffset()+d.getPhysicalEndOffset(),o=d.getHeight(),i=h?d.getX()-r+d.getPhysicalStartOffset():d.getX()-d.getPhysicalStartOffset(),s=d.getY();var u=g.stageToLocal(_.localToStage({x:i,y:s})),p=new t.Rectangle(u.x,u.y,r,o);this._gantt.scrollIntoView(p,a,n,e.getTaskPadding())},p.prototype.getDraggedObject=function(){return this._draggedObj},p.prototype.setDraggedObject=function(t){this._draggedObj=t},p.prototype.dragStartSetup=function(){this.hideDnDArtifacts(this._draggedObj)},p.prototype.dragEndCleanup=function(){this.hideDnDArtifacts(),this._sandboxData=null},p.prototype.showDragFeedback=function(a,n,i,s,r){var o=this._gantt.getEventManager();if(this._draggedObj&&o){var l,h,g,d,_,c,b,f,y=o.getDnDTaskSubType(this._draggedObj),D=t.Agent.isRightToLeft(this._gantt.getCtx()),m=D?1:-1,v=this._gantt.getDnDArtifactsContainer(),S=this._gantt.getStartTime(),T=this._gantt.getEndTime(),O=this._gantt.getContentLength();switch(y){case"tasks":l=r?{deltaX:0,deltaY:0}:this._gantt.autoPanOnEdgeDrag(n,e.getAutoPanEdgeThreshold(),!1,!1),h=s.x+n.x+l.deltaX,g=s.y+n.y+l.deltaY,this._renderTaskMoveDragFeedback(h,g,v);var E=this.getTask().getShape("main");d=D?O-h:h,c=D?O-(h-E.getFinalWidth()):h+E.getFinalWidth(),_=t.TimeAxis.getPositionDate(S,T,d,O),b=t.TimeAxis.getPositionDate(S,T,c,O),i&&(i instanceof u?f=i:i instanceof p&&(f=i.getRowNode())),this._showDragFeedbackTooltip(a,_,b,this._mainDragFeedbacks[0],"center",f);break;case"taskResizeHandles":l=r?{deltaX:0,deltaY:0}:this._gantt.autoPanOnEdgeDrag(n,e.getAutoPanEdgeThreshold(),!1,!0),h=n.x+l.deltaX,this._renderTaskResizeDragFeedback(h,v);var A="mainResizeHandleEnd"===this._draggedObj.getType();A?(_=this.getValue("start"),c=this._mainResizeHandleDragFeedbacks[0].getX()-m*this._mainResizeHandleDragFeedbacks[0].getWidth(),c=D?O-c:c,b=t.TimeAxis.getPositionDate(S,T,c,O)):(d=this._mainResizeHandleDragFeedbacks[0].getX(),d=D?O-d:d,_=t.TimeAxis.getPositionDate(S,T,d,O),b=this.getValue("end")),this._showDragFeedbackTooltip(a,_,b,this._mainResizeHandleDragFeedbacks[0],A?"end":"start")}}},p.prototype._showDragFeedbackTooltip=function(e,a,n,i,s,r){var o=t.Agent.isRightToLeft(this._gantt.getCtx()),l=this.getSandboxData();r&&(l._rowNode=r),l.start=a,l.end=n;var h,g=i.getDimensions(this.getCtx().getStage());switch(s){case"start":h=new t.Point(g.x+o*g.w,g.y);break;case"end":h=new t.Point(g.x+!o*g.w,g.y);break;default:h=g.getCenter()}var d=this.getCtx().stageToPageCoords(h.x,h.y);this._gantt.getEventManager().ProcessObjectTooltip(e,d.x,d.y,this,i.getElem())},p.prototype._renderTaskMoveDragFeedback=function(e,a,n){var i=t.Agent.isRightToLeft(this._gantt.getCtx()),s=this._gantt.getStartTime(),r=this._gantt.getEndTime(),o=this._gantt.getContentLength(),l=this.getTask().getShape("main");if(this._mainDragFeedbacks)for(var h=0;h<this._mainDragFeedbacks.length;h++){var g=this._mainDragFeedbacks[h],d=this._mainDragFeedbackOffsets[h],_=e+d.x;g.setX(_),g.setY(a+d.y),this._mainDragFeedbackStartTimes[h]=t.TimeAxis.getPositionDate(s,r,i?o-_:_,o)}else{var c=new y(this._gantt.getCtx(),e,a,l.getFinalWidth(),l.getFinalHeight(),l.getBorderRadius(),this.getTask(),"mainDragFeedback");if(this._mainDragFeedbacks=[c],this._mainDragFeedbackOffsets=[new t.Point(0,0)],this._mainDragFeedbackStartTimes=[this.getValue("start")],n.addChild(c),this._gantt.isSelectionSupported()&&this.isSelected()&&this._gantt.getSelectionHandler().getSelectedCount()>1){var u=this._gantt.getSelectionHandler().getSelection();for(h=0;h<u.length;h++){var b=u[h];if(b instanceof p&&b!==this){var f=b.getTask().getShape("main"),D=f.getX()+b.getTranslateX()-(l.getX()+this.getTranslateX()),m=f.getY()+b.getTranslateY()-(l.getY()+this.getTranslateY()),v=e+D,S=a+m;g=new y(this._gantt.getCtx(),v,S,f.getFinalWidth(),f.getFinalHeight(),f.getBorderRadius(),b.getTask(),"mainDragFeedback"),this._mainDragFeedbacks.push(g),this._mainDragFeedbackOffsets.push(new t.Point(D,m)),this._mainDragFeedbackStartTimes.push(b.getValue("start")),n.addChild(g)}}}}},p.prototype._renderTaskResizeDragFeedback=function(e,a){var n,i,s=t.Agent.isRightToLeft(this._gantt.getCtx()),r=s?1:-1,o=this.getTask().getShape("main"),l="mainResizeHandleEnd"===this._draggedObj.getType();l?(n=o.getFinalX()+this.getTranslateX(),i=s?Math.min(e,n):Math.max(e,n)):(n=o.getFinalX()-r*o.getFinalWidth()+this.getTranslateX(),i=s?Math.max(e,n):Math.min(e,n));var h=Math.abs(i-n),g=h-o.getFinalWidth();if(this._mainResizeHandleDragFeedbacks)for(var d=0;d<this._mainResizeHandleDragFeedbacks.length;d++){var _=this._mainResizeHandleDragFeedbacks[d],c=this._mainResizeHandleDragFeedbackSources[d],u=c.getTask().getShape("main"),b=Math.max(0,u.getFinalWidth()+g);if(!l){var f=u.getFinalX()-r*u.getFinalWidth()+c.getTranslateX();_.setX(f+r*b)}_.setWidth(b)}else{var D=new y(this._gantt.getCtx(),l?n:i,o.getFinalY()+this.getTranslateY(),h,o.getFinalHeight(),o.getBorderRadius(),this.getTask(),"mainResizeHandleDragFeedback");if(this._mainResizeHandleDragFeedbacks=[D],this._mainResizeHandleDragFeedbackSources=[this],a.addChild(D),this._gantt.isSelectionSupported()&&this.isSelected()&&this._gantt.getSelectionHandler().getSelectedCount()>1){var m=this._gantt.getSelectionHandler().getSelection();for(d=0;d<m.length;d++){var v=m[d];if(v instanceof p&&v!==this){var S,T=v.getTask().getShape("main"),O=T.getFinalWidth()+g;S=l?T.getFinalX()+v.getTranslateX():T.getFinalX()-r*T.getFinalWidth()+v.getTranslateX()+r*O,_=new y(this._gantt.getCtx(),S,T.getFinalY()+v.getTranslateY(),O,T.getFinalHeight(),T.getBorderRadius(),v.getTask(),"mainResizeHandleDragFeedback"),this._mainResizeHandleDragFeedbacks.push(_),this._mainResizeHandleDragFeedbackSources.push(v),a.addChild(_)}}}}},p.prototype._updateDragFeedbacks=function(){var e,a,n=t.Agent.isRightToLeft(this._gantt.getCtx()),i=this._gantt.getStartTime(),s=this._gantt.getEndTime(),r=this._gantt.getContentLength();if(this._mainDragFeedbacks){var o=t.TimeAxis.getDatePosition(i,s,this._mainDragFeedbackStartTimes[0],r);o=n?r-o:o;for(var l=0;l<this._mainDragFeedbacks.length;l++)e=this._mainDragFeedbacks[l],a=t.TimeAxis.getDatePosition(i,s,this._mainDragFeedbackStartTimes[l],r),a=n?r-a:a,this._mainDragFeedbackOffsets[l].x=a-o,e.setX(a),e.setWidth(this.getTask().getShape("main").getFinalWidth()),0==l&&this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos&&(this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos.x=a)}if(this._mainResizeHandleDragFeedbacks)for(l=0;l<this._mainResizeHandleDragFeedbacks;l++){e=this._mainResizeHandleDragFeedbacks[l];var h=t.TimeAxis.getDatePosition(i,s,this._mainResizeHandleDragFeedbackSources[l].getValue("start"),r),g=t.TimeAxis.getDatePosition(i,s,this._mainResizeHandleDragFeedbackSources[l].getValue("end"),r);a=n?r-h:h,e.setX(a),e.setWidth(Math.abs(g-h)),0==l&&this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos&&(this._gantt.getEventManager()._keyboardDnDFeedbackLocalPos.x=a)}},p.prototype.removeDragFeedbacks=function(){if(this._mainDragFeedbacks){for(var t=0;t<this._mainDragFeedbacks.length;t++)this._mainDragFeedbacks[t].getParent().removeChild(this._mainDragFeedbacks[t]);this._mainDragFeedbacks=null,this._mainDragFeedbackOffsets=null,this._mainDragFeedbackStartTimes=null}if(this._mainResizeHandleDragFeedbacks){for(t=0;t<this._mainResizeHandleDragFeedbacks.length;t++)this._mainResizeHandleDragFeedbacks[t].getParent().removeChild(this._mainResizeHandleDragFeedbacks[t]);this._mainResizeHandleDragFeedbacks=null,this._mainResizeHandleDragFeedbackSources=null}this._gantt.getEventManager().hideTooltip()},p.prototype.hideDnDArtifacts=function(t){this.removeDragFeedbacks()},p.prototype.getTask=function(){return this._task},p.prototype.getTaskLabel=function(){return this._taskLabel},p.prototype.render=function(e){var a;this.clearDependencies(),this.isSelectable()&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.getParent()!=e&&e.addChild(this),this._task.render(),this._getAriaTarget().setAriaRole("img"),t.TimeAxis.supportsTouch()&&this.refreshAriaLabel(),this._updateDragFeedbacks(),a={x:this.getFinalX(),y:this.getFinalY()},this._gantt.getAnimationManager().preAnimateTaskNode(this,a)},p.prototype.remove=function(){var t,e=this;t=function(){e.getRowNode().removeChild(e)},this._gantt.getAnimationManager().preAnimateTaskNodeRemove(this,t)},p.prototype.clearDependencies=function(){this._successors=null,this._predecessors=null},p.prototype.addPredecessorDependency=function(t){null==this._predecessors&&(this._predecessors=[]),this._predecessors.push(t)},p.prototype.getPredecessorDependencies=function(){return this._predecessors},p.prototype.addSuccessorDependency=function(t){null==this._successors&&(this._successors=[]),this._successors.push(t)},p.prototype.getSuccessorDependencies=function(){return this._successors},p.prototype.getFinalX=function(){return this._taskObj.x},p.prototype.getFinalY=function(){return this._taskObj.y},p.prototype.getFinalHeight=function(t){return this._task.getFinalHeight(t)},p.prototype.getDuration=function(e,a){var n=this._gantt.getOptions().translations,i=a-e,s=this._gantt.getMinorAxis().getScale();return"hours"==s||"minutes"==s||"seconds"==s?(i=Math.round(i/36e5*100)/100,t.ResourceUtils.format(n.accessibleDurationHours,[i])):(i=Math.round(i/864e5*100)/100,t.ResourceUtils.format(n.accessibleDurationDays,[i]))},p.prototype.getAriaLabel=function(){var e=[],n=this._gantt.getOptions().translations,i=this.getLayoutObject().rowObj,s="";if(this._gantt.isRowsHierarchical()&&(s=n.labelLevel+" "+i.depth+", "),null!=this._gantt.getRenderState()){var r=i.data.label;return null==r&&(r=n.labelRow+" "+i.index+1),r=s+r,null!=i.expanded&&e.push(n[i.expanded?"stateExpanded":"stateCollapsed"]),t.Displayable.generateAriaLabel(r,e)}this.isSelectable()&&e.push(n[this.isSelected()?"stateSelected":"stateUnselected"]),null!=(i=this.getLayoutObject().rowObj).expanded&&e.push(n.labelRow+" "+n[i.expanded?"stateExpanded":"stateCollapsed"]);var o=a.getDatatip(this,!1,!0);if(this._task.isMilestone("main")?o=n.accessibleTaskTypeMilestone+", "+o:this._task.isSummary("main")&&(o=n.accessibleTaskTypeSummary+", "+o),o=s+o,null!=this._predecessors||null!=this._successors){var l="";if(null!=this._predecessors&&this._predecessors.length>0&&(l=t.ResourceUtils.format(n.accessiblePredecessorInfo,[this._predecessors.length]),t.TimeAxis.supportsTouch()))for(var h=0;h<this._predecessors.length;h++)l=l+", "+this._predecessors[h].getAriaLabel();if(null!=this._successors&&this._successors.length>0&&(l.length>0&&(l+=", "),l+=t.ResourceUtils.format(n.accessibleSuccessorInfo,[this._successors.length]),t.TimeAxis.supportsTouch()))for(h=0;h<this._successors.length;h++)l=l+", "+this._successors[h].getAriaLabel();l.length>0&&(o=o+", "+l)}var g=t.Displayable.generateAriaLabel(o,e),d=this.getAriaProperty("label");return null!=d&&d.indexOf(g)>-1?null:g},p.prototype._getAriaTarget=function(){var e=this.getTask().getShape("main");return t.Agent.isTouchDevice()&&this._gantt.isTaskResizeEnabled()&&e?e:this},p.prototype.refreshAriaLabel=function(){this._updateAriaLabel()},p.prototype._updateAriaLabel=function(){var t=this._getAriaTarget();t.setAriaProperty("label",this.getAriaLabel()),t.applyAriaProperties()},p.prototype.getDataContext=function(){var t=this.getData()._itemData;return{data:this.getData(!0),rowData:this.getRowNode().getData(!0),itemData:t||null,color:a.getDatatipColor(this),component:this._gantt.getOptions()._widgetConstructor}},p.prototype.getSandboxDataContext=function(){var t=this.getSandboxData();if(t.start=new Date(t.start).toISOString(),t.end=new Date(t.end).toISOString(),t.baseline){var e=t.baseline.start,n=t.baseline.end;t.baseline.start=null!=e?new Date(e).toISOString():null,t.baseline.end=null!=n?new Date(n).toISOString():null}var i=this._taskObj.data._itemData;return{data:t,rowData:t._rowNode.getData(!0),itemData:i||null,color:a.getDatatipColor(this),component:this._gantt.getOptions()._widgetConstructor}},p.prototype._setSelected=function(t,e){this._selected=t,this._selected?this._task.showEffect("selected"):this._task.removeEffect("selected",e),this.refreshAriaLabel(),this._gantt.setCurrentRow(this.getRowNode().getId())},p.prototype.clearSelectionState=function(){this._setSelected(!1,!1)},p.prototype.getDatatip=function(){return a.getDatatip(this,!0)},p.prototype.getDatatipColor=function(){return a.getDatatipColor(this)},p.prototype.isSelectable=function(){return"none"!=this._gantt.getOptions().selectionMode},p.prototype.isSelected=function(){return this._selected},p.prototype.setSelected=function(t){this._setSelected(t,!0)},p.prototype.showHoverEffect=function(){this._task.showEffect("hover")},p.prototype.hideHoverEffect=function(){this._task.removeEffect("hover")},p.prototype.getNextNavigable=function(e){var a=null,n=this._gantt.getEventManager().getKeyboardHandler();if(e.type==t.MouseEvent.CLICK||n.isMultiSelectEvent(e))a=this;else if((e.keyCode==t.KeyboardEvent.OPEN_ANGLED_BRACKET||t.KeyboardEvent.CLOSE_ANGLED_BRACKET)&&e.altKey){if((n=this._gantt.getEventManager().getKeyboardHandler())&&n.getFirstNavigableDependencyLine){if(t.Agent.isRightToLeft(this.getGantt().getCtx()))var i=e.keyCode==t.KeyboardEvent.CLOSE_ANGLED_BRACKET?"predecessor":"successor";else i=e.keyCode==t.KeyboardEvent.OPEN_ANGLED_BRACKET?"predecessor":"successor";var s=this._gantt.getNavigableDependencyLinesForTask(this,i);a=n.getFirstNavigableDependencyLine(this,e,s)}a?a.setKeyboardFocusTask(this):a=this}else n.isNavigationEvent(e)&&null==this._gantt.getEventManager().getKeyboardDnDMode()&&(a=h.getNextNavigable(this._gantt,this,e));return a},p.prototype.getTargetElem=function(){return this._task.getShape("main").getElem()},p.prototype.getKeyboardBoundingBox=function(t){return this.getDimensions(t)},p.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this._task.showEffect("focus");var t=this._gantt.getViewportStartTime(),e=this._gantt.getViewportEndTime();this.scrollIntoView(),this._gantt.getViewportStartTime()===t&&this._gantt.getViewportEndTime()===e||this._gantt.dispatchEvent(this._gantt.createViewportChangeEvent())},p.prototype.hideKeyboardFocusEffect=function(){this.isShowingKeyboardFocusEffect()&&(this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect())},p.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},p.prototype.isDragAvailable=function(t){return!0},p.prototype.getDragTransferable=function(t,e){return[this.getId()]},p.prototype.getDragFeedback=function(t,e){return null};var b=function(t,e){this.Init(t,e)};t.Obj.createSubclass(b,t.Obj),b.prototype.Init=function(t,e){this._gantt=t,this._container=e},b.prototype.getGantt=function(){return this._gantt},b.prototype.getContainer=function(){return this._container},b.prototype.getShape=function(t){return"main"===t?this._mainShape:"progress"===t?this._progressShape:"baseline"===t?this._baselineShape:"mainResizeHandleStart"===t?this._mainHandleStart:"mainResizeHandleEnd"===t?this._mainHandleEnd:void 0},b.prototype.getSvgStyle=function(t){return null==t?this._container.getValue("svgStyle"):this._container.getValue(t,"svgStyle")},b.prototype.getSvgClassName=function(t){return null==t?this._container.getValue("svgClassName")||this._container.getValue("className"):this._container.getValue(t,"svgClassName")||this._container.getValue(t,"className")},b.prototype._applyStyles=function(t,e){var a=this.getSvgClassName(e),n=this.getSvgStyle(e);a&&(t.applyDefaultStyleClasses(),t.setClassName(t.getClassName()+" "+a)),n&&t.setStyle(n)},b.prototype.isMilestone=function(t){var e,a,n=this._container.getValue("type");return"milestone"===n||"auto"===n&&("mainDragFeedback"===t||y.MAIN_TYPES.indexOf(t)>-1?(e=this._container.getValue("start"),a=this._container.getValue("end")):y.BASELINE_TYPES.indexOf(t)>-1&&(e=this._container.getValue("baseline","start"),a=this._container.getValue("baseline","end")),null!=e&&e==a)},b.prototype.isSummary=function(t){return"main"===t&&"summary"===this._container.getValue("type")},b.prototype.getTimeSpanDimensions=function(e,a){var n,i,s=this._gantt.getStartTime(),r=this._gantt.getEndTime(),o=this._gantt.getContentLength(),l=t.Agent.isRightToLeft(this._gantt.getCtx());return null!=e||null!=a?(n=t.TimeAxis.getDatePosition(s,r,e,o),i=t.TimeAxis.getDatePosition(s,r,a,o),l&&(n=o-n,i=o-i),{startPos:n,endPos:i,distance:i-n}):null},b.prototype.getFillColor=function(){if(null==this._fillColor){if(null==this._mainShape)return null;this._fillColor=this._mainShape.getFillColor()}return this._fillColor},b.prototype.getFinalHeight=function(t){var e=this._container.getLayoutObject();return t?e.overallHeightNoProgress:e.overallHeight},b.prototype.showEffect=function(t){this.showMainEffect(t)},b.prototype.removeEffect=function(t,e){this.removeMainEffect(t,e)},b.prototype.render=function(){var t=this._container.getValue("progress","height");this.renderBaseline(t),this.renderMain(t),this.renderProgress(t),"summary"===this._container.getValue("type")&&this._mainShape&&this._container.addChild(this._mainShape)},b.prototype.getRenderState=function(t){return"main"===t?this._mainShape.getRenderState():"progress"===t?this._progressShape.getRenderState():"baseline"===t?this._baselineShape.getRenderState():void 0},b.prototype.renderBaseline=function(t){var a,n,i,s,r,o,l,h,g,d,_,c,u,p=this._container.getValue("baseline"),b=this;p?(n=this._container.getValue("baseline","start"),i=this._container.getValue("baseline","end"),(h=this.getTimeSpanDimensions(n,"milestone"===this._container.getValue("type")&&n!=i?n:i))?(o=this.getTimeSpanDimensions(this._container.getValue("start"),n),a=this.isMilestone("baseline"),g=o?o.distance:0,_=Math.abs(h.distance),c=this._container.getValue("baseline","height"),s=a?Math.max(this._container.getValue("height"),c)+e.getMilestoneBaselineYOffset()-c:this._container.getValue("height"),d=Math.max(0,(t-this._container.getValue("height"))/2)+s,u=p.borderRadius,null==this._baselineShape?(this._baselineShape=new y(this._gantt.getCtx(),g,d,_,c,u,this,"baseline"),a?this._container.addChildAt(this._baselineShape,0):this._container.addChild(this._baselineShape),this._baselineShape.setRenderState("add")):(this._baselineShape.setRenderState("exist"),a&&this._container.addChildAt(this._baselineShape,0)),this._baselineShape.setFinalWidth(_),this._baselineShape.setFinalHeight(c),this._baselineShape.setFinalX(g),this._baselineShape.setFinalY(d),l=function(){b._applyStyles(b._baselineShape,"baseline")},r={x:g,y:d,w:_,h:c,r:u},this._gantt.getAnimationManager().preAnimateTaskBaseline(this,this._baselineShape,r,l)):this.removeBaseline()):this.removeBaseline()},b.prototype.removeBaseline=function(){var t,e=this;this._baselineShape&&(t=function(){e._container.removeChild(e._baselineShape),e._baselineShape=null},this._gantt.getAnimationManager().preAnimateTaskBaselineRemove(this._baselineShape,t))},b.prototype.renderMain=function(t){var e,a,n,i,s,r,o,l=this._container.getData(),h=this._container.getValue("height"),g=this._container.getValue("start"),d=this._container.getValue("end"),_=this;l&&(n=this.getTimeSpanDimensions(g,"milestone"===this._container.getValue("type")&&g!=d?g:d))?(0,i=Math.max(0,(t-h)/2),s=Math.abs(n.distance),r=this.isSummary("main")?this._container.getFinalHeight(!0):h,o=this._container.getValue("borderRadius"),null==this._mainShape?(this._mainShape=new y(this._gantt.getCtx(),0,i,s,r,o,this,"main"),this._container.addChild(this._mainShape),this._mainShape.setRenderState("add")):this._mainShape.setRenderState("exist"),this._mainShape.setFinalWidth(s),this._mainShape.setFinalHeight(r),this._mainShape.setFinalX(0),this._mainShape.setFinalY(i),a=function(){_._fillColor=null,_._applyStyles(_._mainShape)},e={x:0,y:i,w:s,h:r,r:o},this._gantt.getAnimationManager().preAnimateTaskMain(this,e,a)):this.removeMain()},b.prototype.showMainEffect=function(t){var e=this._mainShape.getX(),a=this._mainShape.getY(),n=this._mainShape.getWidth(),i=this._mainShape.getHeight(),s=this._mainShape.getBorderRadius(),r=function(t){var e=t.getRowNode().getLayoutObject(),a=t.getLayoutObject(),n=e.earliestOverlayTaskObj,i=t.getParent();if(n&&"overlay"!==a._overlayBehavior){var s=n.node,r=i.getChildIndex(s);i.addChildAt(t,r-1)}else i.addChild(t)};"selected"===t?null==this._mainSelectShape&&(this._mainSelectShape=new y(this._gantt.getCtx(),e,a,n,i,s,this,"mainSelect"),this._container.addChildAt(this._mainSelectShape,0),r(this._container)):"hover"!==t&&"focus"!==t||null==this._mainHoverShape&&(this._mainHoverShape=new y(this._gantt.getCtx(),e,a,n,i,s,this,"mainHover"),this._container.addChildAt(this._mainHoverShape,this._container.getChildIndex(this._mainShape)),r(this._container))},b.prototype.removeMainEffect=function(t,e){if(e=void 0===e||e,"selected"===t?(null!=this._mainSelectShape&&this._container.removeChild(this._mainSelectShape),this._mainSelectShape=null):"hover"!==t&&"focus"!==t||(null!=this._mainHoverShape&&this._container.removeChild(this._mainHoverShape),this._mainHoverShape=null),e){var a=[],n=[],i=this._container.getRowNode();if(this._gantt.isSelectionSupported())for(var s=this._gantt.getSelectionHandler().getSelection(),r=0;r<s.length;r++){if(s[r]instanceof p&&s[r].getRowNode()===i)"overlay"===s[r].getLayoutObject().overlapBehavior?n.push(s[r]):a.push(s[r])}for(var o=this._container.getParent(),l=i.getRenderOrderTaskObjs(),h=i.getLayoutObject().earliestOverlayTaskObj,g=0;g<l.length;g++){var d=l[g].node;d===h&&a.forEach(o.addChild,o),d.isSelected()||o.addChild(d)}null==h&&a.forEach(o.addChild,o),n.forEach(o.addChild,o)}},b.prototype.getMainWidth=function(){return this._mainShape.getWidth()},b.prototype.setMainWidth=function(t){this._mainShape.setWidth(t),this._mainSelectShape&&this._mainSelectShape.setWidth(t),this._mainHoverShape&&this._mainHoverShape.setWidth(t)},b.prototype.getMainHeight=function(){return this._mainShape.getHeight()},b.prototype.setMainHeight=function(t){this._mainShape.setHeight(t),this._mainSelectShape&&this._mainSelectShape.setHeight(t),this._mainHoverShape&&this._mainHoverShape.setHeight(t)},b.prototype.getMainX=function(){return this._mainShape.getX()},b.prototype.setMainX=function(t){this._mainShape.setX(t),this._mainSelectShape&&this._mainSelectShape.setX(t),this._mainHoverShape&&this._mainHoverShape.setX(t)},b.prototype.getMainY=function(){return this._mainShape.getY()},b.prototype.setMainY=function(t){this._mainShape.setY(t),this._mainSelectShape&&this._mainSelectShape.setY(t),this._mainHoverShape&&this._mainHoverShape.setY(t)},b.prototype.getMainBorderRadius=function(){return this._mainShape.getY()},b.prototype.setMainBorderRadius=function(t){this._mainShape.setBorderRadius(t),this._mainSelectShape&&this._mainSelectShape.setBorderRadius(t),this._mainHoverShape&&this._mainHoverShape.setBorderRadius(t)},b.prototype.setMainDimensions=function(t,e,a,n,i){this._mainShape.setDimensions(t,e,a,n,i),this._mainSelectShape&&this._mainSelectShape.setDimensions(t,e,a,n,i),this._mainHoverShape&&this._mainHoverShape.setDimensions(t,e,a,n,i)},b.prototype.removeMain=function(){var t,e=this;this._mainShape&&(t=function(){e.removeMainEffect("selected",!1),e._container.removeChild(e._mainShape),e._mainShape=null,e.removeProgress()},this._gantt.getAnimationManager().preAnimateTaskMainRemove(this._mainShape,this._mainSelectShape,this._mainHoverShape,t))},b.prototype.getProgressValue=function(){var t=this._container.getValue("progress","value");return this.isMilestone("main")||"number"!=typeof t?null:t},b.prototype.renderProgress=function(t){this._container.getValue("progress");var e,a,n,i,s,r=this._container.getValue("height"),o=this.getProgressValue(),l=this;null!==o&&this._mainShape&&!this.isMilestone("main")?(0,n=Math.max(0,(r-t)/2),i=o*this._mainShape.getFinalWidth(),s=this._container.getValue("progress","borderRadius"),null==this._progressShape?(this._progressShape=new y(this._gantt.getCtx(),0,n,i,t,s,this,"progress"),this._container.addChild(this._progressShape),this._progressShape.setRenderState("add")):this._progressShape.setRenderState("exist"),this._progressShape.setFinalWidth(i),this._progressShape.setFinalHeight(t),this._progressShape.setFinalX(0),this._progressShape.setFinalY(n),e=function(){l._applyStyles(l._progressShape,"progress")},a={x:0,y:n,w:i,h:t,r:s},this._gantt.getAnimationManager().preAnimateTaskProgress(this,this._progressShape,a,e)):this.removeProgress()},b.prototype.removeProgress=function(){var t,e=this;this._progressShape&&(t=function(){e._container.removeChild(e._progressShape),e._progressShape=null},this._gantt.getAnimationManager().preAnimateTaskProgressRemove(this._progressShape,t))},b.prototype.renderMainResizeHandles=function(a){var n,i,s,r,o,l=t.Agent.isRightToLeft(this._gantt.getCtx())?-1:1;if(this._mainShape){n=e.getTaskResizeHandleWidth(),i=this._mainShape.getX()-l*this._mainShape.getPhysicalStartOffset(),s=this._mainShape.getY(),r=this._mainShape.getWidth()+this._mainShape.getPhysicalStartOffset()+this._mainShape.getPhysicalEndOffset(),o=this._mainShape.getHeight();var h=this,g=function(e,a){if(t.Agent.isTouchDevice()){var n=h._gantt.getOptions().translations,i="start"===a?n.taskResizeStartHandle:n.taskResizeEndHandle;e.setAriaRole("img"),e.setAriaProperty("label",i),e.applyAriaProperties()}};this._mainHandleStart?this._mainHandleStart.setDimensions(i,s,n,o,"0"):(this._mainHandleStart=new y(this._gantt.getCtx(),i,s,n,o,"0",this,"mainResizeHandleStart"),g(this._mainHandleStart,"start")),a.addChild(this._mainHandleStart),this._mainHandleEnd?this._mainHandleEnd.setDimensions(i+l*(r-n),s,n,o,"0"):(this._mainHandleEnd=new y(this._gantt.getCtx(),i+l*(r-n),s,n,o,"0",this,"mainResizeHandleEnd"),g(this._mainHandleEnd,"end")),a.addChild(this._mainHandleEnd)}},b.prototype.removeHandles=function(t){this._mainHandleStart&&t!==this._mainHandleStart&&(this._mainHandleStart.getParent().removeChild(this._mainHandleStart),this._mainHandleStart=null),this._mainHandleEnd&&t!==this._mainHandleEnd&&(this._mainHandleEnd.getParent().removeChild(this._mainHandleEnd),this._mainHandleEnd=null)};var f=function(t,e,a){this.Init(t,e,a)};t.Obj.createSubclass(f,t.Obj),f.prototype.Init=function(t,e,a){this._gantt=t,this._container=e,this._associatedShape=a,this._renderState="add"},f.prototype.getGantt=function(){return this._gantt},f.prototype.getAssociatedShape=function(){return this._associatedShape},f.prototype.setAssociatedShape=function(t){this._associatedShape=t},f.prototype.getLabelOutputText=function(){return this._labelOutputText},f.prototype.getEffectiveLabelPosition=function(){return this._effectiveLabelPosition},f.prototype.getRenderState=function(){return this._renderState},f.prototype._applyStyles=function(t){var a;null!=t?((a=e.getTaskLabelStyle(this._gantt.getOptions())).parseInlineStyle(t),this._labelOutputText.setStyle(t)):a=this._gantt.getCache().getFromCache("baseTaskLabelCSSStyle"),this._labelOutputText.setCSSStyle(a)},f.prototype._placeLabel=function(a){var n,i,s,r,o,l,h=this._labelOutputText.getDimensions(),g=t.Agent.isRightToLeft(this._gantt.getCtx()),d=e.getTaskLabelPadding();switch("progress"!==a&&"progressStart"!==a||this.setAssociatedShape(this._container.getTask().getShape("progress")),l="main"===this._associatedShape.getType()&&this._container.getTask().isSummary("main")?this._container.getLayoutObject().height:this._associatedShape.getFinalHeight(),o=this._associatedShape.getFinalY()+(l-h.h)/2,this.setFinalY(o),s=this._associatedShape.getFinalWidth(),n=g?this._associatedShape.getPhysicalEndOffset():this._associatedShape.getPhysicalStartOffset(),i=g?this._associatedShape.getPhysicalStartOffset():this._associatedShape.getPhysicalEndOffset(),a){case"end":g?this._labelOutputText.alignRight():this._labelOutputText.alignLeft(),r=s+i+d;break;case"progress":g?this._labelOutputText.alignLeft():this._labelOutputText.alignRight(),r=s-d;break;case"oProgress":g?this._labelOutputText.alignRight():this._labelOutputText.alignLeft(),r=this._container.getTask().getShape("progress").getFinalWidth()+d;break;case"innerStart":case"progressStart":g?this._labelOutputText.alignRight():this._labelOutputText.alignLeft(),r=-n+d;break;case"innerEnd":g?this._labelOutputText.alignLeft():this._labelOutputText.alignRight(),r=s+i-d;break;case"innerCenter":this._labelOutputText.alignCenter(),r=s/2;break;case"start":g?this._labelOutputText.alignLeft():this._labelOutputText.alignRight(),r=-(n+d)}g&&(r=-r),this.setFinalX(r),this._effectiveLabelPosition=a},f.prototype._getAvailableWidth=function(a){var n,i,s,r,o,l,h,g,d,_,c,u,p,b,f,y,D,m,v,S=e.getTaskLabelPadding(),T=t.Agent.isRightToLeft(this._gantt.getCtx()),O=this._gantt.getContentLength(),E=!1;switch(v=O-(m=T?O:0),a){case"end":case"end_ABSOLUTE":if(f="end",i=v,r=this._container.getNextAdjacentTaskNode(),l=this._container.getNextAdjMilestoneBaselineTaskNode(),r&&r.getValue("start")<this._container.getValue("end")&&r.getValue("end")>this._container.getValue("end")){b=0;break}for(;r&&r.getValue("start")<this._container.getValue("end")&&r.getValue("end")<this._container.getValue("end");)r=r.getNextAdjacentTaskNode();r&&(i=r.getTaskShapePhysicalBounds("main").startPos),l&&(i=T?Math.max(i,l.getTaskShapePhysicalBounds("baseline").startPos):Math.min(i,l.getTaskShapePhysicalBounds("baseline").startPos)),b=Math.abs(this._container.getTaskShapePhysicalBounds("main").endPos-i)-2*S;break;case"innerCenter":case"innerStart":case"innerEnd":(r=this._container.getNextAdjacentTaskNode())&&("innerCenter"===a?E=r.getValue("start")<this._container.getValue("start")+(this._container.getValue("end")-this._container.getValue("start"))/2:"innerEnd"===a&&(E=r.getValue("start")<this._container.getValue("end")));case"innerCenter_ABSOLUTE":case"innerStart_ABSOLUTE":case"innerEnd_ABSOLUTE":if("_ABSOLUTE"===a.slice(-"_ABSOLUTE".length)&&(a=a.slice(0,-"_ABSOLUTE".length)),D="number"==typeof this._container.getValue("progress","value"),!(o=this._container.getTask()).isMilestone("main")){if(E){b=0,f=a;break}if(g=this._container.getTaskShapePhysicalBounds("main"),u=Math.abs(g.endPos-g.startPos),D){if(y=this._labelOutputText.getDimensions(),(d=o.getShape("progress"))?(_=d.getFinalWidth(),c=d.getFinalHeight()):(_=0,c=0),p=u-_,"innerStart"===a){if(b=_-2*S,y.w<=b&&y.h<=c){f="progressStart";break}}else if("innerEnd"===a&&(b=p-2*S,y.w<b)){f="innerEnd";break}y.h<=c&&_>p?(b=_-2*S,f="progress"):(b=p-2*S,f="oProgress");break}b=u-2*S,f=a;break}b=0,f=a;break;case"start":case"start_ABSOLUTE":if(f="start",n=m,s=this._container.getPreviousAdjacentTaskNode(),h=this._container.getPrevAdjMilestoneBaselineTaskNode(),s&&s.getValue("end")>this._container.getValue("start")){b=0;break}s&&(n=s.getTaskShapePhysicalBounds("main",!0).endPos),h&&(n=T?Math.min(n,h.getTaskShapePhysicalBounds("baseline").endPos):Math.max(n,h.getTaskShapePhysicalBounds("baseline").endPos)),b=Math.abs(n-this._container.getTaskShapePhysicalBounds("main").startPos)-2*S;break;default:return null}return[f,b]},f.prototype._preprocessLabelPosition=function(t){var e=this._container.getTask().isMilestone("main");if("string"==typeof t){if(e)switch(t){case"innerCenter":case"innerEnd":t="end";break;case"innerStart":t="start"}return[t+"_ABSOLUTE"]}return Array.isArray(t)?e?t.map(function(t){switch(t){case"innerCenter":case"innerEnd":return"end";case"innerStart":return"start";default:return t}}):t:[]},f.prototype._evaluatePosition=function(e){for(var a,n,i,s={},r=this._labelOutputText.getDimensions(),o=r.w,l=(r.h,e=this._preprocessLabelPosition(e),0),h=0;h<e.length;h++){var g=e[h];if("max"!==g){if(s[g]?d=s[g]:(d=this._getAvailableWidth(g),s[g]=d),d){if(a=d[0],o<=(n=d[1]))break;n>l&&(l=n,i=g)}}else if(null!=i){var d=s[i];a=d[0],n=d[1];break}}return null!=a&&(o>n&&t.TextUtils.fitText(this._labelOutputText,n,1/0,this._container,1),this._placeLabel(a),!0)},f.prototype.render=function(){var e,a,n=this._container.getValue("label"),i=this._container.getValue("labelPosition"),s=this._container.getValue("labelStyle"),r=this,o=this._gantt.GetStyleClass("taskLabel");this._renderState="exist",null!=n&&n.length>0&&"none"!==i&&this._associatedShape?(null==this._labelOutputText&&(this._labelOutputText=new t.OutputText(this._gantt.getCtx(),n,0,0),this._gantt.getEventManager().IsDragSupported("tasks")&&(o+=" "+this._gantt.GetStyleClass("draggable")),this._labelOutputText.setClassName(o),this._renderState="add"),null==this._labelOutputText.getParent()&&this._container.addChild(this._labelOutputText),this._labelOutputText.setTextString(n),this._applyStyles(s),this._evaluatePosition(i)?(a=function(){var e,a;switch(r._effectiveLabelPosition){case"innerCenter":case"innerEnd":case"innerStart":case"progressStart":case"progress":case"oProgress":a=r._associatedShape.getFillColor(),null!=(e=t.ColorUtils.getContrastingTextColor(a?a.computedFill:null))&&r._labelOutputText.setFill(new t.SolidFill(e))}},e={x:this.getFinalX(),y:this.getFinalY()},this._gantt.getAnimationManager().preAnimateTaskLabel(this._container,e,a)):this.remove()):this.remove()},f.prototype.remove=function(){var t,e=this;this._labelOutputText&&(t=function(){e._container.removeChild(e._labelOutputText),e._labelOutputText=null,e._effectiveLabelPosition=null},this._gantt.getAnimationManager().preAnimateTaskLabelRemove(this._labelOutputText,t))},f.prototype.getFinalX=function(){return this._finalX},f.prototype.setFinalX=function(t){this._finalX=t},f.prototype.getFinalY=function(){return this._finalY},f.prototype.setFinalY=function(t){this._finalY=t};var y=function(t,e,a,n,i,s,r,o,l){this.Init(t,e,a,n,i,s,r,o,l)};t.Obj.createSubclass(y,t.Path),y.MAIN_TYPES=["main","mainSelect","mainHover"],y.MAIN_EFFECT_TYPES=["mainSelect","mainHover"],y.BASELINE_TYPES=["baseline","baselineSelect","baselineHover"],y.BASELINE_EFFECT_TYPES=["baselineSelect","baselineHover"],y.prototype.Init=function(t,e,a,n,i,s,r,o,l){var h;switch(this._context=t,this._x=e,this._y=a,this._w=n,this._h=i,this._r=null!=s?s:"0",this._task=r,this._type=o,this._renderState="add",this._typeCmdGeneratorMap={main:this._generateRepShapeCmd,mainSelect:this._generateRepShapeCmd,mainHover:this._generateRepShapeCmd,mainDragFeedback:this._generateRepShapeCmd,mainResizeHandleStart:this._generateRectCmd,mainResizeHandleEnd:this._generateRectCmd,mainResizeHandleDragFeedback:this._generateRectCmd,progress:this._generateRectCmd,baseline:this._generateRepShapeCmd,baselineSelect:this._generateRepShapeCmd,baselineHover:this._generateRepShapeCmd},h=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),y.superclass.Init.call(this,t,h,l),this.applyDefaultStyleClasses(),this._type){case"mainDragFeedback":case"mainResizeHandleDragFeedback":this.setMouseEnabled(!1);case"mainResizeHandleStart":case"mainResizeHandleEnd":r.getGantt().getEventManager().associate(this,r.getContainer());case"main":case"progress":case"baseline":this.setPixelHinting(!0)}},y.prototype._generateRepShapeCmd=function(a,n,i,s,r){var o,l=t.Agent.isRightToLeft(this._context),h=(y.MAIN_EFFECT_TYPES.indexOf(this._type)>-1||y.BASELINE_EFFECT_TYPES.indexOf(this._type)>-1)*e.getTaskEffectMargin();return this._task.isMilestone(this._type)&&0==i?(o=h*Math.sqrt(2),this._generateDiamondCmd(a,n-o,s+2*o,r)):this._task.isSummary(this._type)&&"main"===this._type?this._generateSummaryCmd(a,n,i,s,r):this._generateRectCmd(l?a+h:a-h,n-h,i+2*h,s+2*h,r)},y.prototype._generateRectCmd=function(e,a,n,i,s){var r=t.Agent.isRightToLeft(this._context);return"0"===s||"0px"===s?t.PathUtils.moveTo(e,a)+t.PathUtils.horizontalLineTo(r?e-n:e+n)+t.PathUtils.verticalLineTo(a+i)+t.PathUtils.horizontalLineTo(e)+t.PathUtils.closePath():t.PathUtils.rectangleWithBorderRadius(e-r*n,a,n,i,s,Math.min(n,i),"0")},y.prototype._generateSummaryCmd=function(a,n,i,s,r){var o=t.Agent.isRightToLeft(this._context),l=e.getSummaryThickness();if("0"===r||"0px"===r)return i>2*l?t.PathUtils.moveTo(a,n+s)+t.PathUtils.verticalLineTo(n)+t.PathUtils.horizontalLineTo(o?a-i:a+i)+t.PathUtils.verticalLineTo(n+s)+t.PathUtils.horizontalLineTo(o?a-i+l:a+i-l)+t.PathUtils.verticalLineTo(n+l)+t.PathUtils.horizontalLineTo(o?a-l:a+l)+t.PathUtils.verticalLineTo(n+s)+t.PathUtils.closePath():this._generateRectCmd(a,n,i,s,r);var h=Math.min(new t.CSSStyle({"border-radius":r}).getBorderRadius(),Math.min(i,s)),g=Math.max(h-l,0);return i>2*l?t.PathUtils.moveTo(a,n+s)+t.PathUtils.verticalLineTo(n+h)+t.PathUtils.arcTo(h,h,Math.PI/2,o?0:1,o?a-h:a+h,n)+t.PathUtils.horizontalLineTo(o?a-i+h:a+i-h)+t.PathUtils.arcTo(h,h,Math.PI/2,o?0:1,o?a-i:a+i,n+h)+t.PathUtils.verticalLineTo(n+s)+t.PathUtils.horizontalLineTo(o?a-i+l:a+i-l)+t.PathUtils.verticalLineTo(n+l+g)+t.PathUtils.arcTo(g,g,Math.PI/2,o?1:0,o?a-i+l+g:a+i-l-g,n+l)+t.PathUtils.horizontalLineTo(o?a-l-g:a+l+g)+t.PathUtils.arcTo(g,g,Math.PI/2,o?1:0,o?a-l:a+l,n+l+g)+t.PathUtils.verticalLineTo(n+s)+t.PathUtils.closePath():t.PathUtils.rectangleWithBorderRadius(a-o*i,n,i,s,h+"px "+h+"px 0px 0px",Math.min(i,s),"0")},y.prototype._generateDiamondCmd=function(e,a,n,i){var s=n/2;if("0"===i||"0px"===i)return t.PathUtils.moveTo(e,a)+t.PathUtils.lineTo(e+s,a+s)+t.PathUtils.lineTo(e,a+n)+t.PathUtils.lineTo(e-s,a+s)+t.PathUtils.closePath();var r=Math.min(new t.CSSStyle({"border-radius":i}).getBorderRadius(),n/(2*Math.sqrt(2))),o=r/Math.sqrt(2),l=r,h=r;return t.PathUtils.moveTo(e-o,a+o)+t.PathUtils.arcTo(l,h,0,1,e+o,a+o)+t.PathUtils.lineTo(e+s-o,a+s-o)+t.PathUtils.arcTo(l,h,0,1,e+s-o,a+s+o)+t.PathUtils.lineTo(e+o,a+n-o)+t.PathUtils.arcTo(l,h,0,1,e-o,a+n-o)+t.PathUtils.lineTo(e-s+o,a+s+o)+t.PathUtils.arcTo(l,h,0,1,e-s+o,a+s-o)+t.PathUtils.closePath()},y.prototype.applyDefaultStyleClasses=function(){var e,a,n,i,s,r,o=this._task.getGantt(),l=o.getEventManager().IsDragSupported("tasks");"progress"===this._type?(e=o.GetStyleClass("taskProgress"),l&&(e+=" "+o.GetStyleClass("draggable")),this.setClassName(e)):y.MAIN_TYPES.indexOf(this._type)>-1?(e=o.GetStyleClass("task"),a=o.GetStyleClass("taskMilestone"),n=o.GetStyleClass("taskBar"),i=o.GetStyleClass("taskSummary"),this._task.isMilestone(this._type)&&0==this._w?e+=" "+a:this._task.isSummary(this._type)?e+=" "+i:e+=" "+n,"mainSelect"===this._type?(this.setStyle({fill:"none",filter:"none"}),e+=" "+o.GetStyleClass("selected")):"mainHover"===this._type?(e+=" "+o.GetStyleClass("hover"),r={fill:"none"},null!=(s=this._task.getFillColor())&&(this.setStroke(t.SelectionEffectUtils.createSelectingStroke(s.fill)),"none"===s.filter&&(r.filter="none")),this.setStyle(r)):"main"===this._type&&l&&(e+=" "+o.GetStyleClass("draggable")),this.setClassName(e)):y.BASELINE_TYPES.indexOf(this._type)>-1?(e=o.GetStyleClass("baseline"),a=o.GetStyleClass("baselineMilestone"),n=o.GetStyleClass("baselineBar"),this._task.isMilestone(this._type)&&0==this._w?e+=" "+a:e+=" "+n,this.setClassName(e)):"mainDragFeedback"===this._type||"mainResizeHandleDragFeedback"===this._type?(e=o.GetStyleClass("taskDragImage"),this.setClassName(e)):"mainResizeHandleStart"!==this._type&&"mainResizeHandleEnd"!==this._type||(e=o.GetStyleClass("taskResizeHandle"),this.setClassName(e+" "+this._task.getGantt().GetStyleClass("draggable")))},y.prototype.getFillColor=function(){var a,n,i,s,r,o,l;a=(a=null!=(a=this.getElem()).firstChild?a.firstChild:a).cloneNode(!1),(n=this._task.getGantt().getCtx().getSvgDocument()).appendChild(a);try{if(s=(i=window.getComputedStyle(a)).fill,o=i.filter,!(String.prototype.startsWith?s.startsWith("url("):0==s.indexOf("url("))){switch(o){case"url("+JSON.stringify("#"+e.getTaskTintFilterId())+")":case"url(#"+e.getTaskTintFilterId()+")":r=t.ColorUtils.getBrighter(s,e.getTaskTintAlpha());break;case"url("+JSON.stringify("#"+e.getTaskShadeFilterId())+")":case"url(#"+e.getTaskShadeFilterId()+")":r=t.ColorUtils.getDarker(s,e.getTaskShadeAlpha());break;default:r=s}l={fill:s,computedFill:r,filter:o}}}finally{n.removeChild(a)}return l},y.prototype.getType=function(){return this._type},y.prototype.getTask=function(){return this._task},y.prototype.getPhysicalStartOffset=function(){return(y.MAIN_TYPES.indexOf(this._type)>-1||y.BASELINE_TYPES.indexOf(this._type)>-1)&&this._task.isMilestone(this._type)?this._finalHeight/2:0},y.prototype.getPhysicalEndOffset=function(){return(y.MAIN_TYPES.indexOf(this._type)>-1||y.BASELINE_TYPES.indexOf(this._type)>-1)&&this._task.isMilestone(this._type)?this._finalHeight/2:0},y.prototype.getType=function(){return this._type},y.prototype.getRenderState=function(){return this._renderState},y.prototype.setRenderState=function(t){this._renderState=t},y.prototype.getWidth=function(){return this._w},y.prototype.getFinalWidth=function(){return this._finalWidth},y.prototype.setWidth=function(t){var e;!(y.MAIN_TYPES.indexOf(this._type)>-1||y.BASELINE_TYPES.indexOf(this._type)>-1)||0!==this._w&&0!==t||(this._w=t,this.applyDefaultStyleClasses()),this._w=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},y.prototype.setFinalWidth=function(t){this._finalWidth=t},y.prototype.getHeight=function(){return this._h},y.prototype.getFinalHeight=function(){return this._finalHeight},y.prototype.setHeight=function(t){var e;this._h=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},y.prototype.setFinalHeight=function(t){this._finalHeight=t},y.prototype.getX=function(){return this._x},y.prototype.getFinalX=function(){return this._finalX},y.prototype.setX=function(t){var e;this._x=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},y.prototype.setFinalX=function(t){this._finalX=t},y.prototype.getY=function(){return this._y},y.prototype.getFinalY=function(){return this._finalY},y.prototype.setY=function(t){var e;this._y=t,e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},y.prototype.setFinalY=function(t){this._finalY=t},y.prototype.getBorderRadius=function(){return this._r},y.prototype.setBorderRadius=function(t){var e;this._r=null!=t?t:"0",e=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(e)},y.prototype.setDimensions=function(t,e,a,n,i){var s;!(y.MAIN_TYPES.indexOf(this._type)>-1||y.BASELINE_TYPES.indexOf(this._type)>-1)||0!==this._w&&0!==a||(this._w=a,this.applyDefaultStyleClasses()),this._x=t,this._y=e,this._w=a,this._h=n,this._r=null!=i?i:"0",s=this._typeCmdGeneratorMap[this._type].call(this,this._x,this._y,this._w,this._h,this._r),this.setCmds(s)}}(dvt);
  return dvt;
});
