/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit', './DvtAxis'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){var e=function(){};t.Obj.createSubclass(e,t.BaseComponent),e._DEFAULT_MIN_VALUE=0,e._DEFAULT_MAX_VALUE=100,e.prototype.Init=function(a,i,n,r){e.superclass.Init.call(this,a,i,n),a.getStage().setCursor(""),this._bStaticRendering=r,this._bStaticRendering||(this.EventManager=this.CreateEventManager(),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("gauge1000"+Math.floor(1e9*Math.random())),this._editingOverlay=new t.Rect(a,0,0),this._editingOverlay.setInvisibleFill(),this.addChild(this._editingOverlay)),this._bEditing=!1,this._bResizeRender=!1,this._oldValue=null},e.prototype.SetOptions=function(e){this.Options=e,t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none"),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||"auto"!=this.Options.visualEffects||(this.Options.visualEffects="none"),e.className&&(this.Options.svgClassName=e.className),e.style&&(this.Options.svgStyle=e.style)},e.prototype.render=function(a,i,n){if(a?this.SetOptions(a):this.Options||this.SetOptions(null),this.Options.thresholds){var r=this.Options.thresholds;this.Options.thresholds=r.sort(e._thresholdComparator)}"number"==typeof i&&"number"==typeof n&&(0!=this.Width&&this.Width!=i||0!=this.Height&&this.Height!=n?this._bResizeRender=!0:this._bResizeRender=!1,this.Width=i,this.Height=n),this.__oldShapes=this.__shapes,this.__shapes=[];var s=new t.Container(this.getCtx());this.addChildAt(s,0),0!=this.Render(s,this.Width,this.Height)&&this.PostRender(a,s)},e.prototype.PostRender=function(e,a){if(this._setAnimation(a,null!=e,this.__oldShapes,this.Width,this.Height),this._editingOverlay&&(this._editingOverlay.setWidth(this.Width),this._editingOverlay.setHeight(this.Height),this.getEventManager().associate(this._editingOverlay,this.__getLogicalObject(),!0)),this.UpdateAriaAttributes(),!this._bStaticRendering&&!this.Options.readOnly){a.setAriaRole("slider"),a.setAriaProperty("valuemin",this.Options.min),a.setAriaProperty("valuemax",this.Options.max);var i=h.getFormattedMetricLabel(this.Options.value,this);a.setAriaProperty("valuenow",i);var n=h.getTooltipString(this);t.Agent.isTouchDevice()&&(this._container.setAriaProperty("live","assertive"),i!=n&&(n=i+t.Context.ARIA_LABEL_DESC_DELIMITER+n)),i!=n&&a.setAriaProperty("label",n),this._renderCount=null!=this._renderCount?this._renderCount+1:0;var r=this.getId()+"_"+this._renderCount;a.setId(r),this.getCtx().setActiveElement(a)}this.Options._selectingCursor&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.Animation||this.RenderComplete()},e.prototype.__getLogicalObject=function(){var e=this.Options.tooltip,a=e?e.renderer:null,i=l.getColor(this);if(a){var n={component:this.Options._widgetConstructor,label:h.getFormattedMetricLabel(this.Options.value,this),color:i};return new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),a,i,n)}var r=h.getTooltipString(this);return new t.SimpleObjPeer(null,r,i)},e.prototype.Render=function(t,e,a){},e.prototype._setAnimation=function(e,a,i,n,r){this.StopAnimation();var s=!1,o=this._bEditing||this._bResizeRender?"none":this.getOptions().animationOnDataChange,l=this._bEditing||this._bResizeRender?"none":this.getOptions().animationOnDisplay,h=t.CSSStyle.getTimeMilliseconds(this.getOptions().animationDuration)/1e3;if(l||o){var c=new t.Rectangle(0,0,n,r),g=this.getCtx();this._container||"none"===l||null==this.__shapes[0]?this._container&&"none"!=o&&a&&null!=this.__shapes[0]&&(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(g,o,this._container,e,c,h),this.Animation?s=!0:this.Animation=this.CreateAnimationOnDataChange(i,this.__shapes,l,h)):(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(g,l,e,c,h),this.Animation||(this.Animation=this.CreateAnimationOnDisplay(this.__shapes,l,h))),!s&&this._container&&(this.removeChild(this._container),this._container.destroy()),this.Animation&&(this.Animation.play(),this.Animation.setOnEnd(this._onAnimationEnd,this)),s&&(this._oldContainer=this._container),this._container=e}},e.prototype.CreateAnimationOnDisplay=function(t,e,a){return null},e.prototype.CreateAnimationOnDataChange=function(e,a,i,n){for(var r=[],s=0;s<e.length;s++){var o=e[s],l=a[s],h=o.getAnimationParams(),c=l.getAnimationParams();l.setAnimationParams(h);var g=new t.CustomAnimation(this.getCtx(),l,n);g.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,l,l.getAnimationParams,l.setAnimationParams,c),r.push(g)}return new t.ParallelPlayable(this.getCtx(),r)},e.prototype.GetValueAt=function(t,e){return null},e.prototype.renderUpdate=function(){this.render(),this.UpdateAriaLiveValue(this._container)},e.prototype.UpdateAriaLiveValue=function(e,a){a=h.getFormattedMetricLabel(a||this.Options.value,this),e.setAriaProperty("valuenow",a),t.Agent.isTouchDevice()&&e.setAriaProperty("label",a)},e.prototype._onAnimationEnd=function(){this._oldContainer&&(this.removeChild(this._oldContainer),this._oldContainer.destroy(),this._oldContainer=null),this.AnimationStopped||this.RenderComplete(),this.Animation=null,this.AnimationStopped=!1},e.prototype.__processValueChangeStart=function(t,e){this._bEditing=!0,this._oldValue=this.Options.value,this.__processValueChangeMove(t,e)},e.prototype.__processValueChangeMove=function(e,a){if(null!=this._oldValue){var i=h.adjustForStep(this.Options,this.GetValueAt(e,a));i!=this.Options.value&&(this.Options.value=i,this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,this.Options.value,!1)))}},e.prototype.__processValueChangeEnd=function(e,a){if(this.__processValueChangeMove(e,a),t.Agent.isTouchDevice()){var i=h.getFormattedMetricLabel(this.Options.value,this),n=h.getTooltipString(this);i!=n&&(n=i+t.Context.ARIA_LABEL_DESC_DELIMITER+n,this._container.setAriaProperty("label",n))}this.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,this.Options.value,!0)),this._bEditing=!1,this._oldValue=null},e.prototype.__increaseValue=function(){if(!this.Options.readOnly){var e=this.Options.value;if(null!=this.Options.step){var a=this.Options.value+this.Options.step;this.Options.value=h.adjustForStep(this.Options,a)}else{var i=(this.Options.max-this.Options.min)/100;this.Options.value=Math.min(Math.max(this.Options.value+i,this.Options.min),this.Options.max)}this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(e,this.Options.value,!1))}},e.prototype.__decreaseValue=function(){if(!this.Options.readOnly){var e=this.Options.value;if(null!=this.Options.step){var a=this.Options.value-this.Options.step;this.Options.value=h.adjustForStep(this.Options,a)}else{var i=(this.Options.max-this.Options.min)/100;this.Options.value=Math.min(Math.max(this.Options.value-i,this.Options.min),this.Options.max)}this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(e,this.Options.value,!1))}},e.prototype.CreateEventManager=function(){return new s(this)},e._thresholdComparator=function(t,e){return null!=t.max&&null!=e.max?t.max-e.max:t.max?-1/0:1/0},e.prototype.getAutomation=function(){return new a(this)},e.prototype.CreateKeyboardHandler=function(t){return new o(t,this)},e.prototype.UpdateAriaAttributes=function(){if(!this._bStaticRendering){var e=h.getTooltipString(this);if(this.IsParentRoot()){var a=this.Options.translations;this.Options.readOnly?(this.getCtx().setAriaRole("img"),this.getCtx().setAriaLabel(t.ResourceUtils.format(a.labelAndValue,[a.labelDataVisualization,t.Displayable.generateAriaLabel(t.TextUtils.processAriaLabel(this.GetComponentDescription()),e?[e]:null)]))):(this.getCtx().setAriaRole("application"),this.getCtx().setAriaLabel(t.ResourceUtils.format(a.labelAndValue,[a.labelDataVisualization,t.TextUtils.processAriaLabel(this.GetComponentDescription())])))}else this.Options.readOnly&&(this.setAriaRole("img"),this.setAriaProperty("label",t.Displayable.generateAriaLabel(t.TextUtils.processAriaLabel(this.GetComponentDescription()),e?[e]:null)))}};var a=function(t){this._gauge=t};t.Obj.createSubclass(a,t.Automation),a.prototype.getDomElementForSubId=function(e){if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._gauge);if(0==e.indexOf("item")){var a=e.indexOf("["),i=e.indexOf("]");if(a>0&&i>0){var n=e.substring(a+1,i),r=this._gauge.__getRatingGaugeItem(n);if(r)return r.getElem()}}return null},a.prototype.GetSubIdForDomElement=function(t){for(var e=this._gauge.getOptions(),a=0;a<e.max;a++){if(this._gauge.__getRatingGaugeItem(a)==t)return"item["+a+"]"}return null},a.prototype.getValue=function(){return this._gauge.getOptions().value},a.prototype.getMetricLabel=function(){return h.getFormattedMetricLabel(this.getValue(),this._gauge)};var i=function(t,e,a){this.Init(t,e,a)};t.Obj.createSubclass(i,t.BaseAxisInfo),i.prototype.Init=function(t,e,a){i.superclass.Init.call(this,t,e,a),this.MixinInit.call(this,t,e,a)},t.DataAxisInfoMixin.call(i.prototype);var n=function(){};t.Obj.createSubclass(n,t.BaseComponentDefaults),n.SKIN_ALTA={skin:t.CSSStyle.SKIN_ALTA,min:0,max:100,center:{},color:"#393737",borderColor:null,visualEffects:"auto",emptyText:null,animationOnDataChange:"none",animationOnDisplay:"none",animationDuration:500,readOnly:"true",metricLabel:{rendered:"auto",scaling:"auto",style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),textType:"number"},_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),label:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),position:"auto"},_thresholdColors:["#ed6647","#fad55c","#68c182"],__layout:{outerGap:1,labelGap:5}},n.prototype.Init=function(e){var a={alta:t.JsonUtils.merge(e.alta,n.SKIN_ALTA)};n.superclass.Init.call(this,a)},n.prototype.getAnimationDuration=function(t){return t.animationDuration};var r=new Object;t.Obj.createSubclass(r,t.Obj),r.hasData=function(t){var e=t.getOptions();return e&&null!=e.value&&r.hasValidData(t)},r.hasValidData=function(t){var e=t.getOptions();return Number(e.min)<Number(e.max)},r.getValueThresholdIndex=function(t,e){var a=t.getOptions(),i=null!=e?e:a.value,n=a.thresholds;if(!n)return-1;for(var r=0;r<n.length;r++)if(i<=n[r].max)return r;return n.length-1},r.getThreshold=function(t,e){var a=t.getOptions().thresholds;return a&&e>=0&&e<a.length?a[e]:null},r.getReferenceObject=function(t,e){var a=t.getOptions().referenceLines;return a&&e>=0&&e<a.length?a[e]:null};var s=function(t){this.Init(t.getCtx(),t.dispatchEvent,t,t),this._gauge=t,this.IsMouseEditing=!1};t.Obj.createSubclass(s,t.EventManager),s.prototype.OnMouseDown=function(t){if(!1===this._gauge.getOptions().readOnly){this.IsMouseEditing=!0,this.hideTooltip();var e=this.GetRelativePosition(t.pageX,t.pageY);this._gauge.__processValueChangeStart(e.x,e.y),t.preventDefault()}else s.superclass.OnMouseDown.call(this,t)},s.prototype.OnMouseUp=function(t){if(this.IsMouseEditing){this.IsMouseEditing=!1;var e=this.GetRelativePosition(t.pageX,t.pageY);this._gauge.__processValueChangeEnd(e.x,e.y)}else s.superclass.OnMouseUp.call(this,t)},s.prototype.OnMouseMove=function(t){if(this.IsMouseEditing){var e=this.GetRelativePosition(t.pageX,t.pageY);this._gauge.__processValueChangeMove(e.x,e.y)}!this.IsShowingTooltipWhileEditing()&&this.IsMouseEditing||s.superclass.OnMouseMove.call(this,t)},s.prototype.IsShowingTooltipWhileEditing=function(){return!1},s.prototype.PreEventBubble=function(e){if(t.TouchEvent.TOUCHSTART===e.type&&!1===this._gauge.getOptions().readOnly){this.IsMouseEditing=!0;var a=this.GetRelativePosition(e.touches[0].pageX,e.touches[0].pageY);this._gauge.__processValueChangeStart(a.x,a.y),e.preventDefault()}else if(t.TouchEvent.TOUCHMOVE===e.type&&this.IsMouseEditing){a=this.GetRelativePosition(e.touches[0].pageX,e.touches[0].pageY);this._gauge.__processValueChangeMove(a.x,a.y),e.preventDefault()}else if(t.TouchEvent.TOUCHEND===e.type&&this.IsMouseEditing){this.IsMouseEditing=!1;a=this.GetRelativePosition(e.changedTouches[0].pageX,e.changedTouches[0].pageY);this._gauge.__processValueChangeEnd(a.x,a.y),e.preventDefault()}this.IsMouseEditing&&!this.IsShowingTooltipWhileEditing()||s.superclass.PreEventBubble.call(this,e)},s.prototype.ProcessKeyboardEvent=function(e){if(!this.KeyboardHandler)return!1;this.KeyboardHandler.processKeyDown(e);var a=e.keyCode;if(a==t.KeyboardEvent.UP_ARROW||a==t.KeyboardEvent.LEFT_ARROW||a==t.KeyboardEvent.DOWN_ARROW||a==t.KeyboardEvent.RIGHT_ARROW||a==t.KeyboardEvent.TAB){var i=this._gauge.getCtx().getStageAbsolutePosition();this.ProcessObjectTooltip(e,i.x,i.y,this._gauge.__getLogicalObject(),this._gauge)}return!1},s.prototype.OnBlur=function(t){s.superclass.OnBlur.call(this,t),this.hideTooltip()},s.prototype.GetRelativePosition=function(t,e){var a=this.getCtx().pageToStageCoords(t,e);return this._gauge.stageToLocal(a)},s.prototype.UpdateActiveElement=function(t,e){},s.prototype.__isMouseEditing=function(){return this.IsMouseEditing};var o=function(t,e){this.Init(t,e)};t.Obj.createSubclass(o,t.KeyboardHandler),o.prototype.Init=function(t,e){o.superclass.Init.call(this,t),this._gauge=e},o.prototype.processKeyDown=function(e){var a=e.keyCode,i=t.Agent.isRightToLeft(this._gauge.getCtx()),n=this._gauge.getOptions().value;this._gauge.getOptions().readOnly||(a!=t.KeyboardEvent.TAB||this._bEditing?a==t.KeyboardEvent.UP_ARROW||a==(i?t.KeyboardEvent.LEFT_ARROW:t.KeyboardEvent.RIGHT_ARROW)?(this._gauge.__increaseValue(),t.EventManager.consumeEvent(e)):a==t.KeyboardEvent.DOWN_ARROW||a==(i?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW)?(this._gauge.__decreaseValue(),t.EventManager.consumeEvent(e)):!this._bEditing||a!=t.KeyboardEvent.ENTER&&a!=t.KeyboardEvent.TAB||this._oldValue==n||(this._gauge.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,n,!0)),a==t.KeyboardEvent.TAB?(this._bEditing=!1,this._oldValue=null):this._oldValue=n):(this._bEditing=!0,this._oldValue=n))};var l=new Object;t.Obj.createSubclass(l,t.Obj),l._THRESHOLD_COLOR_RAMP=["#ed6647","#fad55c","#68c182"],l._ALTA_CIRCLE={startAngle:202.5,angleExtent:225,anchorX:100,anchorY:103,metricLabelBounds:{x:80,y:86,width:40,height:34},indicatorLength:.85,tickLabelHeight:20,tickLabelWidth:30,radius:60,majorTickCount:6},l._ALTA_DOME={startAngle:202.5,angleExtent:225,anchorX:100,anchorY:103,metricLabelBounds:{x:83,y:86,width:34,height:34},indicatorLength:.85,tickLabelHeight:20,tickLabelWidth:30,radius:60,majorTickCount:6},l._ALTA_RECTANGLE={startAngle:202.5,angleExtent:225,anchorX:100,anchorY:103,metricLabelBounds:{x:83,y:86,width:34,height:34},indicatorLength:.85,tickLabelHeight:20,tickLabelWidth:30,radius:60,majorTickCount:6},l._ANTIQUE_CIRCLE={startAngle:220.5,angleExtent:261.1,anchorX:100,anchorY:100,metricLabelBounds:{x:82,y:133,width:36,height:34},indicatorLength:.85,tickLabelHeight:20,tickLabelWidth:30,radius:61,majorTickCount:6},l._ANTIQUE_DOME={startAngle:195.5,angleExtent:210.8,anchorX:100,anchorY:100,metricLabelBounds:{x:84,y:135,width:32,height:35},indicatorLength:.98,tickLabelHeight:20,tickLabelWidth:30,radius:63,majorTickCount:6},l._ANTIQUE_RECTANGLE={startAngle:207.6,angleExtent:235,anchorX:100,anchorY:95.8,metricLabelBounds:{x:83,y:125,width:34,height:40},indicatorLength:1.05,tickLabelHeight:20,tickLabelWidth:30,radius:64,majorTickCount:6},l._LIGHT_CIRCLE={startAngle:220.5,angleExtent:261.1,anchorX:100,anchorY:100,metricLabelBounds:{x:80,y:82,width:40,height:40},indicatorLength:.82,tickLabelHeight:20,tickLabelWidth:30,radius:58,majorTickCount:6},l._LIGHT_DOME={startAngle:201,angleExtent:222,anchorX:100.2,anchorY:89,metricLabelBounds:{x:80,y:70,width:41,height:39},indicatorLength:1.23,tickLabelHeight:20,tickLabelWidth:30,radius:56,majorTickCount:6},l._LIGHT_RECTANGLE={startAngle:211,angleExtent:242,anchorX:100,anchorY:91.445,metricLabelBounds:{x:78,y:75,width:44,height:38},indicatorLength:1.1,tickLabelHeight:20,tickLabelWidth:30,radius:58,majorTickCount:6},l._DARK_CIRCLE={startAngle:220.5,angleExtent:261.5,metricLabelBounds:{x:80,y:82,width:40,height:40},indicatorLength:.85,tickLabelHeight:20,tickLabelWidth:30,radius:60,majorTickCount:6},l._DARK_DOME={startAngle:201,angleExtent:222,anchorX:100.2,anchorY:89,metricLabelBounds:{x:80,y:73,width:40,height:36},indicatorLength:1.23,tickLabelHeight:20,tickLabelWidth:30,radius:56,majorTickCount:6},l._DARK_RECTANGLE={startAngle:201,angleExtent:222,anchorX:100.2,anchorY:99.5,metricLabelBounds:{x:80,y:83,width:41,height:36},indicatorLength:1.1,tickLabelHeight:20,tickLabelWidth:30,radius:58,majorTickCount:6},l._ANTIQUE_INDICATOR={anchorX:42,anchorY:510},l._ALTA_INDICATOR={anchorX:187,anchorY:388},l._LIGHT_INDICATOR={anchorX:227,anchorY:425},l._DARK_INDICATOR={anchorX:227,anchorY:425},l.getColor=function(e){var a=e.getOptions(),i=r.getValueThresholdIndex(e),n=r.getThreshold(e,i);return!n||e instanceof t.StatusMeterGauge&&!(e instanceof t.StatusMeterGauge&&"onIndicator"==a.thresholdDisplay)?a.color:l.getThresholdColor(e,n,i)},l.getBorderColor=function(e){var a=e.getOptions(),i=r.getValueThresholdIndex(e),n=r.getThreshold(e,i);return n&&n.borderColor&&(!(e instanceof t.StatusMeterGauge)||e instanceof t.StatusMeterGauge&&"onIndicator"==a.thresholdDisplay)?n.borderColor:a.borderColor},l.getPlotAreaColor=function(e){var a=e.getOptions(),i=r.getValueThresholdIndex(e),n=r.getThreshold(e,i);return!n||e instanceof t.StatusMeterGauge&&!(e instanceof t.StatusMeterGauge&&"onIndicator"!=a.thresholdDisplay)?a.plotArea.color:l.getThresholdColor(e,n,i)},l.getPlotAreaBorderColor=function(e){var a=e.getOptions(),i=a.plotArea.borderColor;return e instanceof t.StatusMeterGauge&&"circular"!=a.orientation&&null==i?"#D6DFE6":i},l.getThresholdColor=function(t,e,a){if(e.color)return e.color;var i=t.getOptions(),n=a%i._thresholdColors.length;return i._thresholdColors[n]},l.getDialBackground=function(t){return"rectangleAlta"===t?l._ALTA_RECTANGLE:"domeAlta"===t?l._ALTA_DOME:"circleAntique"===t?l._ANTIQUE_CIRCLE:"rectangleAntique"===t?l._ANTIQUE_RECTANGLE:"domeAntique"===t?l._ANTIQUE_DOME:"circleLight"===t?l._LIGHT_CIRCLE:"rectangleLight"===t?l._LIGHT_RECTANGLE:"domeLight"===t?l._LIGHT_DOME:"circleDark"===t?l._DARK_CIRCLE:"rectangleDark"===t?l._DARK_RECTANGLE:"domeDark"===t?l._DARK_DOME:l._ALTA_CIRCLE},l.getDialIndicator=function(t){return"needleAntique"===t?l._ANTIQUE_INDICATOR:"needleLight"===t?l._LIGHT_INDICATOR:"needleDark"===t?l._DARK_INDICATOR:l._ALTA_INDICATOR},l.hasLabel=function(t){return!!t.label.text};var h=new Object;t.Obj.createSubclass(h,t.Obj),h.renderEmptyText=function(e,a,i){var n=e.getOptions(),s=n.translations,o=n.emptyText;o||(o=s.labelNoData),r.hasValidData(e)||(o=s.labelInvalidData);var l=n._statusMessageStyle;if(l.getStyle("font-size")||l.setStyle("font-size","13px"),e instanceof t.StatusMeterGauge){var h=l.getStyle("color");h=h||"#333333",l.setStyle("color",h)}t.TextUtils.renderEmptyText(a,o,new t.Rectangle(i.x,i.y,i.w,i.h),e.getEventManager(),l)},h.getFormattedMetricLabel=function(t,e){var a=e.getOptions();if(a.metricLabel.text)return a.metricLabel.text;var i=a.metricLabel.converter,n=a.metricLabel.scaling,r=a.metricLabel.autoPrecision?a.metricLabel.autoPrecision:"on",s="percent"==a.metricLabel.textType;return h._formatMetricLabelValue(t,e,i,n,r,s)},h.formatTickLabelValue=function(t,e){var a=e.getOptions(),i=null,n="percent"==a.tickLabel.textType;"on"==a.tickLabel.rendered&&a.tickLabel.converter&&(i=a.tickLabel.converter);var r=null;"on"==a.tickLabel.rendered&&a.tickLabel.scaling&&(r=a.tickLabel.scaling);var s=a.tickLabel.autoPrecision?a.tickLabel.autoPrecision:"on";return h._formatMetricLabelValue(t,e,i,r,s,n)},h._formatMetricLabelValue=function(e,a,i,n,r,s){var o,l=a.getOptions(),c=l.min,g=l.max,u=g-c,d=u<1e3?100:1e3,p=null;isNaN(u)||(p=u/d),s&&(e=h.getFillPercentage(l,l.min,l.max,e,!0));var _=new t.LinearScaleAxisValueFormatter(a.getCtx(),c,g,p,n,r,l.translations);if(i&&i.getAsString)o=_.format(e,i);else if(i&&i.format)o=_.format(e,i);else if(s){var m=a.getCtx().getNumberConverter({style:"percent",maximumFractionDigits:0,minimumFractionDigits:0});o=m&&m.format?m.format(e):String(Math.round(100*e))+"%"}else o=_.format(e);return o},h.getFillPercentage=function(t,e,a,i,n){var r=(i-e)/(t.max-t.min);return r=n?r:Math.min(Math.max(0,r),1)},h.getTooltipString=function(e){var a=e.getOptions(),i=r.getValueThresholdIndex(e),n=r.getThreshold(e,i),s=h.getFormattedMetricLabel(a.value,e);return n&&null!=n.shortDesc?n.shortDesc:null!=a.shortDesc?a.shortDesc:a.label.text?t.ResourceUtils.format(a.translations.labelAndValue,[a.label.text,s]):s},h.renderMetricLabel=function(e,a,i,n,r,s,o){var l=e.getOptions(),c=!1;if("on"==l.metricLabel.rendered||o&&"off"!=l.metricLabel.rendered){var g=h.getFormattedMetricLabel(l.value,e),u=h.getFormattedMetricLabel(l.min,e),d=h.getFormattedMetricLabel(l.max,e),p=new t.OutputText(e.getCtx(),g,i.x+i.w/2,i.y+i.h/2);p.setCSSStyle(l.metricLabel.style);var _=l.metricLabel.style.getStyle("font-size");_||(_=h.calcLabelFontSize([g,u,d],p,i),p.setTextString(g),p.setFontSize(_)),"top"==s?(p.setY(i.y),p.alignTop()):"middle"==s?t.TextUtils.centerTextVertically(p,i.y+i.h/2):"bottom"==s&&(p.setY(i.y+i.h),p.alignBottom()),"center"==r?p.alignCenter():"left"==r?(p.setX(i.x),p.alignLeft()):"right"==r&&(p.setX(i.x+i.w),p.alignRight()),null!=n&&p.setSolidFill(n),c=t.TextUtils.fitText(p,i.w,i.h,a)}return c},h.renderLabel=function(e,a,i,n,r){var s=e.getOptions(),o=!1;if(l.hasLabel(s)){var h=s.label.text,c=s.label.style,g=new t.MultilineText(e.getCtx(),h),u=c.clone();g.setCSSStyle(c);var d=c.getStyle("font-size")||t.TextUtils.getOptimalFontSize(g.getCtx(),g.getTextString(),g.getCSSStyle(),i);u.setFontSize("font-size",d,e.getCtx()),null!=n&&u.setStyle("color",n),g.setCSSStyle(u),o=t.TextUtils.fitText(g,i.w,i.h,e);var p=g.getDimensions().h;"top"==r?g.setY(i.y):"bottom"==r?g.setY(i.y+i.h-p):g.setY(i.y+i.h/2-p/2),g.setX(i.x+i.w/2),g.alignCenter(),a.addChild(g)}return o},h.calcLabelFontSize=function(e,a,i){for(var n=0,r=null,s=0,o=0;o<e.length;o++)a.setTextString(e[o]),(s=a.getDimensions().w)>n&&(r=e[o],n=s);return a.setTextString(r),t.TextUtils.getOptimalFontSize(a.getCtx(),a.getTextString(),a.getCSSStyle(),i)},h.adjustForStep=function(t,e){var a=Number(t.step);if(a&&a>0){var i=e/a;if(i<.5)return t.min;var n=Math.ceil(i)*a;return Math.max(Math.min(t.max,n),t.min)}return e},t.LedGauge=function(){},t.Obj.createSubclass(t.LedGauge,e),t.LedGauge.newInstance=function(e,a,i,n){var r=new t.LedGauge;return r.Init(e,a,i,n),r},t.LedGauge.prototype.Init=function(e,a,i,n){t.LedGauge.superclass.Init.call(this,e,a,i,n),this.Defaults=new c(e)},t.LedGauge.prototype.SetOptions=function(e){(e=t.JsonUtils.clone(e)).title&&(e.label=e.title),t.LedGauge.superclass.SetOptions.call(this,this.Defaults.calcOptions(e)),"auto"==this.Options.animationOnDisplay&&(this.Options.animationOnDisplay="zoom"),"auto"==this.Options.animationOnDataChange&&(this.Options.animationOnDataChange="alphaFade"),this.Options.readOnly=!0},t.LedGauge.prototype.Render=function(t,e,a){g.render(this,t,e,a)};var c=function(t){this.Init({alta:c.SKIN_ALTA},t)};t.Obj.createSubclass(c,n),c.SKIN_ALTA={type:"circle"};var g=new Object;t.Obj.createSubclass(g,t.Obj),g._SHAPE_TRIANGLE_CMDS=[-50,36.6,0,-50,50,36.6],g._SHAPE_STAR_CMDS=[-50,-11.22,-16.69,-17.94,0,-47.55,16.69,-17.94,50,-11.22,26.69,13.8,30.9,47.56,0,33.42,-30.9,47.56,-26.69,13.8],g._SHAPE_ARROW_CMDS=[25,48,25,8,47.5,8,0,-39,-47.5,8,-25,8,-25,48],g._SHAPE_HUMAN_CMDS="M -0.06059525142297417 -50.86842065108466 C -11.4496388584463 -50.86842065108466 -20.708163169810554 -39.024253028220556 -20.708163169810554 -24.413724255650386 C -20.708163169810554 -9.803195483080515 -11.4496388584463 2.040972139783591 -0.06059525142297417 2.040972139783591 C 11.328499974520241 2.040972139783591 20.586972666964613 -9.803195483080515 20.586972666964613 -24.413724255650386 C 20.586972666964613 -39.024253028220556 11.328499974520241 -50.86842065108466 -0.06059525142297417 -50.86842065108466 z M -23.93434565705865 -2.959610715450779 C -30.908061721494278 3.3998402034127153 -42.00096758564793 18.817121073473572 -38.77478509839983 33.65756051481475 C -20.651382358034887 47.30044101688934 14.372054723529814 49.13162219665128 39.298831093003386 32.85101489300273 C 40.26410489318826 16.477493533721187 32.34060070450674 4.7883891459240715 23.167918656763206 -2.959610715450779 C 11.553661702670112 21.074158341552575 -11.029615708066558 16.237465556670102 -23.93434565705865 -2.959610715450779 z ",g.render=function(e,a,i,n){if(r.hasData(e)){var s=e.getOptions(),o=s.__layout.outerGap,c=s&&(s.size>=0||s.size<1)?Math.sqrt(s.size):1,u=new t.Rectangle(o+(i-2*o)*(1-c)/2,o+(n-2*o)*(1-c)/2,(i-2*o)*c,(n-2*o)*c);g._renderShape(e,a,u),g._renderVisualEffects(e,a,u);var d=!1,p=t.ColorUtils.getContrastingTextColor(l.getColor(e));if(l.hasLabel(s)){var _="middle",m=g._getMetricLabelBounds(e,a,u);"on"==s.metricLabel.rendered&&(m.y=m.y+.6*m.h,m.h=.4*m.h,_="top"),d=t.Agent.isHighContrast()||null==s.label.style.getStyle("color")?h.renderLabel(e,a,m,p,_):h.renderLabel(e,a,m,null,_)}if("on"==s.metricLabel.rendered){var v=g._getMetricLabelBounds(e,a,u),b="middle";d&&(v.h=.55*v.h,b="bottom"),t.Agent.isHighContrast()||null==s.metricLabel.style.getStyle("color")?h.renderMetricLabel(e,a,v,p,"center",b):h.renderMetricLabel(e,a,v,null,"center",b)}}else h.renderEmptyText(e,a,new t.Rectangle(0,0,i,n))},g._renderShape=function(e,a,i){var n,r,s=e.getCtx(),o=e.getOptions(),h=o.type,c=l.getColor(e),u=l.getBorderColor(e),d=i.x+i.w/2,p=i.y+i.h/2,_=Math.min(i.w,i.h)/2;g._cache||(g._cache=new t.Cache(50));var m=Math.min(i.w/100,i.h/100);if("square"==h)n=new t.Rect(s,d-_,p-_,2*_,2*_);else if("rectangle"==h)n=new t.Rect(s,i.x,i.y,i.w,i.h);else if("diamond"==h)n=new t.Polygon(s,[d-_,p,d,p-_,d+_,p,d,p+_]);else if("circle"==h)n=new t.Circle(s,d,p,_);else{if("star"==h)r=g._SHAPE_STAR_CMDS;else if("triangle"==h)r=g._SHAPE_TRIANGLE_CMDS;else if("arrow"==h)r=g._SHAPE_ARROW_CMDS;else if("human"==h)r=g._SHAPE_HUMAN_CMDS;else if(!(r=g._cache.get(h))){n=new t.Path(s,h);var v=t.DisplayableUtils.getDimForced(s,n),b=100/Math.max(v.w,v.h);r=t.PathUtils.transformPath(n.getCommandsArray(),-b*(v.x+v.w/2),-b*(v.y+v.h/2),b,b),g._cache.put(h,r)}"triangle"==h||"arrow"==h||"star"==h?(r=t.PolygonUtils.scale(r,m,m),r=t.PolygonUtils.translate(r,i.x+i.w/2,i.y+i.h/2),n=new t.Polygon(s,r)):(r=t.PathUtils.transformPath(t.PathUtils.createPathArray(r),i.x+i.w/2,i.y+i.h/2,m,m),n=new t.Path(s,r))}if("none"==o.visualEffects)n.setSolidFill(c);else{var y=[t.ColorUtils.adjustHSL(c,0,-.09,.04),t.ColorUtils.adjustHSL(c,0,-.04,-.05)],f=o&&o.rotation%90==0?o.rotation:0,C="arrow"==h||"star"==h||"triangle"==h?f-90:270;n.setFill(new t.LinearGradientFill(C,y,[1,1],[0,1]))}u&&n.setSolidStroke(u),n.setClassName(o.svgClassName),n.setStyle(o.svgStyle),(f=o.rotation)&&("arrow"==h||"triangle"==h||n instanceof t.Path&&"human"!=h)&&(n=g._rotate(e,a,n,i)),a.addChild(n)},g._rotate=function(e,a,i,n){var r=e.getOptions(),s=new t.Container(e.getCtx());a.addChild(s),s.addChild(i);var o=r&&r.rotation%90==0?r.rotation:0,l=new t.Matrix;i.setMatrix(l.rotate(Math.PI*o/180));var h=s.getDimensions(),c=n.x+n.w/2-(h.x+h.w/2),g=n.y+n.h/2-(h.y+h.h/2),u=new t.Matrix;return s.setMatrix(u.translate(c,g)),s},g._renderVisualEffects=function(t,e,a){var i=t.getOptions();i.type;i.visualEffects},g._getMetricLabelBounds=function(e,a,i){var n=e.getOptions(),r=n.type,s=n.rotation%90==0?n.rotation:0,o=Math.min(i.w,i.h),l=i.x+i.w/2-o/2,h=i.y+i.h/2-o/2,c=o,g=o;return"triangle"==r?0==s?(l+=.2*o,h+=.25*o,c-=.4*o,g-=.3*o):90==s?(l+=.05*o,h+=.2*o,c-=.3*o,g-=.4*o):180==s?(l+=.2*o,h+=.05*o,c-=.4*o,g-=.3*o):270==s&&(l+=.25*o,h+=.2*o,c-=.3*o,g-=.4*o):"arrow"==r?0==s?(l+=.2*o,h+=.2*o,c-=.4*o,g-=.4*o):90==s?(l+=.05*o,h+=.2*o,c-=.28*o,g-=.4*o):180==s?(l+=.2*o,h+=.2*o,c-=.4*o,g-=.4*o):270==s&&(l+=.23*o,h+=.2*o,c-=.28*o,g-=.4*o):"star"==r?(l+=.25*o,h+=.25*o,c-=.5*o,g-=.4*o):"diamond"==r?(l+=.15*o,h+=.15*o,c-=.3*o,g-=.3*o):"rectangle"==r?(l+=.1*o,h+=.1*o,c-=.2*o,g-=.2*o):(l+=.15*o,h+=.15*o,c-=.3*o,g-=.3*o),new t.Rectangle(l,h,c,g)},t.StatusMeterGauge=function(){},t.Obj.createSubclass(t.StatusMeterGauge,e),t.StatusMeterGauge.newInstance=function(e,a,i){var n=new t.StatusMeterGauge;return n.Init(e,a,i),n},t.StatusMeterGauge.prototype.Init=function(e,a,i){t.StatusMeterGauge.superclass.Init.call(this,e,a,i),this.Defaults=new u(e),this.__axisInfo=null},t.StatusMeterGauge.prototype.SetOptions=function(e){(e=t.JsonUtils.clone(e)).title&&(e.label=e.title),e.plotArea&&(e.plotArea.className&&(e.plotArea.svgClassName=e.plotArea.className),e.plotArea.style&&(e.plotArea.svgStyle=e.plotArea.style)),this.getCtx().isCustomElement()&&(e.readOnly=e.readonly),t.StatusMeterGauge.superclass.SetOptions.call(this,this.Defaults.calcOptions(e))},t.StatusMeterGauge.prototype.Render=function(t,e,a){d.render(this,t,e,a)},t.StatusMeterGauge.prototype.CreateAnimationOnDisplay=function(e,a,i){for(var n=[],r=0;r<e.length;r++){var s=e[r],o=s.getAnimationParams();"horizontal"==this.Options.orientation?s.setAnimationParams([o[0],o[0],o[2],o[3]]):"vertical"==this.Options.orientation?s.setAnimationParams([o[0],o[1],o[3],o[3]]):"circular"==this.Options.orientation&&s.setAnimationParams([o[0],o[1],0,o[3],o[4]]);var l=new t.CustomAnimation(this.getCtx(),s,i);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,s,s.getAnimationParams,s.setAnimationParams,o),l.getAnimator().setEasing(function(e){return t.Easing.backOut(e,.7)}),n.push(l)}return new t.ParallelPlayable(this.getCtx(),n)},t.StatusMeterGauge.prototype.GetValueAt=function(e,a){var i=this.Options,n=t.Agent.isRightToLeft(this.getCtx());if("horizontal"==i.orientation)return this.__axisInfo.getBoundedValueAt(e);if("vertical"==i.orientation)return this.__axisInfo.getBoundedValueAt(a);if("circular"==i.orientation){var r=i.angleExtent,s=Math.atan2(a-this.cy,e-this.cx),o=n?180-(t.Math.radsToDegrees(s)-i.startAngle):t.Math.radsToDegrees(s)-(360-i.startAngle),l=(o=(o+720)%360)/r,h=i.min,c=i.max,g=l*(c-h)+h;return o>r&&(g=(o-r)/(360-r)>.5?0:c),g}};var u=function(t){this.Init({alta:u.SKIN_ALTA},t)};t.Obj.createSubclass(u,n),u.SKIN_ALTA={angleExtent:360,borderRadius:"auto",color:"#393737",indicatorSize:1,innerRadius:.7,metricLabel:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),position:"auto"},orientation:"horizontal",plotArea:{color:"#E4E8EA",rendered:"auto",borderRadius:"auto"},startAngle:90,thresholdDisplay:"onIndicator"};var d=new Object;t.Obj.createSubclass(d,t.Obj),d.render=function(e,a,i,n){if(r.hasData(e)){var s=e.getOptions(),o=s.__layout.outerGap,l=new t.Rectangle(o,o,i-2*o,n-2*o);"horizontal"==s.orientation||"vertical"==s.orientation?(d._hasMetricLabelOutsidePlotArea(s)&&d._renderMetricLabelOutsidePlotArea(e,a,l),d._renderShape(e,a,l)):"circular"==s.orientation&&d._renderCircularGauge(e,a,l)}else h.renderEmptyText(e,a,new t.Rectangle(0,0,i,n))},d._renderCircularGauge=function(e,a,i){var n,r=e.getOptions(),s=i.clone(),o=t.Agent.isRightToLeft(e.getCtx()),c=0,g=null,u=r.value,p=r.innerRadius,_=r.thresholds,m=null,v=t.Math.TWO_PI-t.Math.degreesToRads(r.startAngle),b=t.Math.degreesToRads(r.angleExtent),y=(v+b)%(2*Math.PI);e.cx=i.w/2,e.cy=i.h/2,b!=2*Math.PI&&(g=d._adjustCenterAndBounds(e,p,v,b,y,i,o),m=e.maxInnerDiameter);var f=.5*(n=n||Math.min(i.w,i.h))*p,C=.5*n,x=r.indicatorSize;if(x&&x>1){var A=(1-1/x)/2*(C-f);f+=A,C-=A}var S="middle";g||(m=Math.min(i.w,i.h)*p,g=new t.Rectangle(i.x+i.w/2-m*(3/7),i.y+i.h/2-m*(2.5/7),m*(6/7),m*(5/7)));if(l.hasLabel(r)){var w="middle",O=new t.Rectangle(g.x,g.y,g.w,g.h);"off"!=r.metricLabel.rendered&&(O.y=O.y+.6*O.h,O.h=.4*O.h,w="top"),h.renderLabel(e,a,O,null,w)&&"off"!=r.metricLabel.rendered&&(g.h=.55*g.h,S="bottom")}h.renderMetricLabel(e,a,g,null,"center",S,!0);var L=v,M=c*b,T=l.getPlotAreaBorderColor(e);if(_&&"off"!=r.plotArea.rendered&&"all"==r.thresholdDisplay)for(var E=0;E<_.length;E++){var R=l.getThresholdColor(e,_[E],E),I=_[E].max<r.max?_[E].max:r.max,P=0==E?r.min:_[E-1].max;L=v+b*h.getFillPercentage(r,r.min,I,P),M=(c=h.getFillPercentage(r,P,I,I))*b;var D=_[E].borderColor;d._drawCircularArc(e,a,i,L,M,f,C,R,!0,D||T)}else if("off"!=r.plotArea.rendered&&"all"!=r.thresholdDisplay){var k=l.getPlotAreaColor(e);d._drawCircularArc(e,a,i,v,b,f,C,k,!0,T)}if(f=n*p*.5,C=.5*n,x&&x<1){var G=(1-x)/2*(C-f);f+=G,C-=G}M=(c=h.getFillPercentage(r,r.min,r.max,u))*b,d._drawCircularArc(e,a,i,v,M,f,C,l.getColor(e),!1);var N=r.referenceLines;if(N)for(var U=0;U<N.length;U++){var F=N[U].color?N[U].color:"black",V=N[U].lineWidth?N[U].lineWidth:2,H=N[U].lineStyle;u=N[U].value;var j=v+h.getFillPercentage(r,r.min,r.max,u)*b;d._drawCircularReferenceLine(e,a,i,j,F,V,H)}r.center.renderer&&d._renderCenterContent(e,r,i,s,m)},d._renderShape=function(e,a,n){var r=e.getOptions(),s=t.Agent.isRightToLeft(e.getCtx()),o="vertical"==r.orientation,h={layout:{}};h.layout.gapRatio=0,h.timeAxisType="disabled",h.position=o?"left":"bottom",h.min=r.min,h.max=r.max,h.dataMin=r.min,h.dataMax=r.max,h.tickLabel={rendered:"off"},h.translations=r.translations;var c=new i(e.getCtx(),h,n);e.__axisInfo=c;var g=0;r.max<=0?g=r.max:r.min>=0&&(g=r.min);var u=c.getCoordAt(g);"off"==r.plotArea.rendered||"auto"==r.plotArea.rendered&&"onIndicator"==r.thresholdDisplay||(u=c.getUnboundedCoordAt(r.min));var _=c.getUnboundedCoordAt(r.value);_=o?Math.max(n.y,Math.min(n.y+n.h,_)):Math.max(n.x,Math.min(n.x+n.w,_));var m,v,b,y,f,C,x,A=0,S=(Z=r.indicatorSize)<1?1:Z,w=Z>1?1:Z,O=Math.min(.5,(Math.abs(_-u)-.5)/2);if(o){var L=_>u?-1:1;m=n.x+(1-w)/2*n.w+.5,v=n.x+n.w*(1+w)/2-.5,y=u-L*O,b=_+L*O,f=n.x+(1-1/S)/2*n.w,C=n.x+n.w*(1+1/S)/2,x=n.y,A=n.y+n.h}else{L=(s?_>u:_<u)?-1:1;m=s?u-L*O:u+L*O,v=s?_+L*O:_-L*O,b=n.y+(1-w)/2*n.h+.5,y=n.y+n.h*(1+w)/2-.5,f=n.x,C=n.x+n.w,x=n.y+(1-1/S)/2*n.h,A=n.y+n.h*(1+1/S)/2}var M=!0;r.value==r.min&&(o?b=y:m=v,M=!1);var T=l.getBorderColor(e),E=l.getPlotAreaBorderColor(e),R=r.thresholds,I=o?0:270;if(R&&"off"!=r.plotArea.rendered&&"all"==r.thresholdDisplay)for(var P=R.length-1;P>=0;P--){var D=P,k=d._createShape(e,e.getCtx(),f,C,x,A),G=new t.ClipPath("pacp"+e.getId());if(P==R.length-1)!o&&s?G.addRect(c.getUnboundedCoordAt(r.max)+1,0,n.w+2,n.h+2,0,0):G.addRect(0,0,n.w+2,n.h+2,0,0);else if(o)G.addRect(0,c.getUnboundedCoordAt(r.max),n.w+2,1*(r.max-R[R.length-2-D].max)/Math.abs(r.min-r.max)*n.h,0,0);else if(s){var N=null==R[R.length-2-D].max?100:R[R.length-2-D].max;G.addRect(c.getUnboundedCoordAt(r.max),0,1*(r.max-N)/Math.abs(r.min-r.max)*n.w,n.h+2,0,0)}else G.addRect(0,0,1*(R[D].max-r.min)/Math.abs(r.min-r.max)*n.w,n.h+2,0,0);k.setClipPath(G),(s||o)&&(D=R.length-1-P),k.setSolidFill(l.getThresholdColor(e,R[D],D));var U=R[D].borderColor;k.setSolidStroke(U||E),d._renderPlotAreaVisualEffects(e,a,k,l.getThresholdColor(e,R[D],D),I)}else if("off"!=r.plotArea.rendered&&("auto"!=r.plotArea.rendered||"onIndicator"!=r.thresholdDisplay)&&"all"!=r.thresholdDisplay){k=o?d._createShape(e,e.getCtx(),f,C,c.getUnboundedCoordAt(r.max),c.getUnboundedCoordAt(r.min)):d._createShape(e,e.getCtx(),c.getUnboundedCoordAt(r.min),c.getUnboundedCoordAt(r.max),x,A);var F=l.getPlotAreaColor(e);k.setSolidFill(F),k.setSolidStroke(E),d._renderPlotAreaVisualEffects(e,a,k,F,I)}var V=new p(e,e.getCtx(),m,v,b,y);e.__shapes.push(V);var H=l.getColor(e);if("none"!=r.visualEffects){var j=[t.ColorUtils.adjustHSL(H,0,-.09,.04),t.ColorUtils.adjustHSL(H,0,-.04,-.05)],B=new t.LinearGradientFill(I,j,[1,1],[0,1]);V.setFill(B)}else V.setSolidFill(H);T&&V.setSolidStroke(T),V.setClassName(r.svgClassName),V.setStyle(r.svgStyle),M&&a.addChild(V);var W,z,Y,K,X=d._createShape(e,e.getCtx(),m,v,b,y);d._renderVisualEffects(e,a,X,M,I);var Q=r.referenceLines;if(Q)for(P=0;P<Q.length;P++){var q=Q[P].color?Q[P].color:"white",J=Q[P].value,Z=r.indicatorSize;o?(K=((1-Z)/2+Z)*n.w,W=n.x+(1-Z)/4*n.w,z=c.getUnboundedCoordAt(J),Y=new t.Line(e.getCtx(),W,z,W+K,z)):(K=((1-Z)/2+Z)*n.h,W=c.getUnboundedCoordAt(J),z=n.y+(1-Z)/4*n.h,Y=new t.Line(e.getCtx(),W,z,W,z+K));var $=Q[P].lineWidth?Q[P].lineWidth:2,tt=Q[P].lineStyle,et=new t.Stroke(q,1,$,!1,t.Stroke.getDefaultDashProps(tt,$));if(Y.setStroke(et),a.addChild(Y),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser&&"none"!=r.visualEffects){var at=t.ColorUtils.makeRGBA(0,0,0,.8),it=new t.Shadow(at,.75,3,3,50,1,2);Y.addDrawEffect(it)}}var nt=r.metricLabel.position;if("on"!=r.metricLabel.rendered||d._hasMetricLabelOutsidePlotArea(r)||l.hasLabel(r))l.hasLabel(r)&&d._renderLabel(e,a,n,nt);else{var rt={x1:m,x2:v,y1:b,y2:y},st={x1:f,x2:C,y1:x,y2:A};d._renderMetricLabelInsidePlotArea(e,a,n,H,nt,rt,st)}},d._createShape=function(e,a,i,n,r,s){var o=Math.min(i,n),l=Math.min(r,s),h=Math.abs(i-n),c=Math.abs(s-r),g=e.getOptions(),u="vertical"==g.orientation?h:c,d="auto"!=g.plotArea.borderRadius?g.plotArea.borderRadius:g.borderRadius,p=t.PathUtils.rectangleWithBorderRadius(o,l,h,c,d,u,"15%");return new t.Path(a,p)},d._renderVisualEffects=function(t,e,a,i,n){t.getOptions().visualEffects},d._renderPlotAreaVisualEffects=function(e,a,i,n,r){var s,o,l=e.getOptions();(i.setMouseEnabled(!1),a.addChild(i),"none"!=l.visualEffects)&&(s=[t.ColorUtils.adjustHSL(n,0,-.04,-.05),t.ColorUtils.adjustHSL(n,0,-.09,.04)],o=new t.LinearGradientFill(r,s,[1,1],[0,1]),i.setFill(o),i.setClassName(l.plotArea.svgClassName),i.setStyle(l.plotArea.svgStyle))},d._renderMetricLabelOutsidePlotArea=function(e,a,i){var n=e.getOptions(),r=t.Agent.isRightToLeft(e.getCtx()),s="vertical"==n.orientation,o=new t.OutputText(e.getCtx(),""),l=h.getFormattedMetricLabel(n.value,e),c=n.__layout.labelGap,g=n.metricLabel.style,u=g.getStyle("color");u=u||"#333333";var d=null;if(o.setCSSStyle(g),o.setSolidFill(u),s&&"on"==n.metricLabel.rendered){var p=n.max>0?n.max:n.min,_=h.getFormattedMetricLabel(p,e);(C=new t.OutputText(e.getCtx(),_)).setCSSStyle(g);var m=new t.Rectangle(i.x,i.y+.8*i.h,i.w,.2*i.h),v=g.getStyle("font-size")||t.TextUtils.getOptimalFontSize(C.getCtx(),C.getTextString(),C.getCSSStyle(),m);C.setFontSize(v),d=C.getDimensions(),i.h-=d.h,y=i.y-d.h;var b=d.w;o.setFontSize(v),o.setTextString(l),o.setX(i.x+i.w/2),o.setY(i.y+i.h),i.h-=c,o.alignCenter(),t.TextUtils.fitText(o,i.w,i.h,a)}else if(!s&&"on"==n.metricLabel.rendered){v=g.getStyle("font-size");var y,f=h.getFormattedMetricLabel(n.min,e),C=h.getFormattedMetricLabel(n.max,e);if(void 0===v&&i.h<18&&(v=h.calcLabelFontSize([l,f,C],o,i)),v=v?parseInt(v):13,o.setFontSize(v),n.max>0||"off"!=n.plotArea.rendered||"auto"!=n.plotArea.rendered||"onIndicator"!=n.thresholdDisplay){p=n.max>0?n.max:n.min,_=h.getFormattedMetricLabel(p,e);(C=new t.OutputText(e.getCtx(),_)).setCSSStyle(g),C.setFontSize(v),(d=C.getDimensions()).w=Math.min(d.w,i.w),y=r?i.x+d.w:i.x+i.w,b=d.w,r?(i.x+=d.w+c,i.w-=d.w+c):i.w-=d.w+c}if(n.min<0&&"on"!=n.plotArea.rendered&&("auto"!=n.plotArea.rendered||"onIndicator"!=n.thresholdDisplay)){var x=h.getFormattedMetricLabel(n.min,e);(f=new t.OutputText(e.getCtx(),x)).setCSSStyle(g),f.setFontSize(v);var A=f.getDimensions();(n.value<0||n.max<=0)&&(y=r?i.x+i.w:i.x+A.w,b=A.w),r?i.w-=A.w+c:(i.x+=A.w+c,i.w-=A.w+c)}o.setTextString(l),o.setX(y),t.TextUtils.centerTextVertically(o,i.y+i.h/2),o.alignRight();var S="firefox"===t.Agent.browser?i.h+2:i.h;t.TextUtils.fitText(o,b,S,a)}},d._renderMetricLabelInsidePlotArea=function(e,a,i,n,r,s,o,l){var c=e.getOptions(),g=t.Agent.isRightToLeft(e.getCtx()),u="vertical"==c.orientation,p="on"==c.plotArea.rendered,_="center",m="middle",v=new t.Rectangle(Math.min(s.x1,s.x2),Math.min(s.y1,s.y2),Math.abs(s.x2-s.x1),Math.abs(s.y2-s.y1)),b=c.metricLabel.style.getStyle("color");"center"==r?(b=b||t.ColorUtils.getContrastingTextColor(n),u?(v.h-=v.w,v.y+=v.w/2):(v.w-=v.h,v.x+=v.h/2)):"insideIndicatorEdge"==r?(b=b||t.ColorUtils.getContrastingTextColor(n),u?(v.h-=v.w,v.y+=v.w/2,m=!p&&s.y1>s.y2?"bottom":"top"):(v.w-=v.h,v.x+=v.h/2,_=g?!p&&s.x1<s.x2?"right":"left":!p&&s.x1>s.x2?"left":"right")):"outsideIndicatorEdge"==r&&(u?(v.h=Math.abs(o.y1-s.y1)-v.w,v.y=o.y1+v.w/2,m="bottom",!p&&s.y1>s.y2&&(v.h=Math.abs(o.y2-s.y1)-v.w,v.y=s.y1+v.w/2,m="top")):g?!p&&s.x1<s.x2?(v.w=Math.abs(o.x2-s.x2)-v.h,v.x=s.x2+v.h/2,_="left"):(v.w=Math.abs(o.x1-s.x2)-v.h,v.x=o.x1+v.h/2,_="right"):!p&&s.x1>s.x2?(v.w=Math.abs(o.x1-s.x2)-v.h,v.x=o.x1+v.h/2,_="right"):(v.w=Math.abs(o.x2-s.x2)-v.h,v.x=s.x2+v.h/2,_="left")),h.renderMetricLabel(e,a,v,b,_,m)||l||("outsideIndicatorEdge"==r?d._renderMetricLabelInsidePlotArea(e,a,i,n,"insideIndicatorEdge",s,o,!0):"insideIndicatorEdge"!=r&&"center"!=r||d._renderMetricLabelInsidePlotArea(e,a,i,n,"outsideIndicatorEdge",s,o,!0))},d._renderLabel=function(e,a,i,n){var r=t.Agent.isRightToLeft(e.getCtx()),s=e.getOptions(),o="vertical"==s.orientation,l=new t.Rectangle(i.x,i.y,o?i.w:i.w-i.h,o?i.h-i.w:i.h),c=s.label.text;if(!d._hasMetricLabelOutsidePlotArea(s)&&"on"==s.metricLabel.rendered){var g=h.getFormattedMetricLabel(s.value,e);c=t.ResourceUtils.format(s.translations.labelAndValue,[c,g])}var u=s.label.style,p=u.clone(),_=u.getStyle("font-size");if(!_){var m=new t.OutputText(e.getCtx(),c,0,0);m.setCSSStyle(u),m.setTextString(c),_=o?t.TextUtils.getOptimalFontSize(m.getCtx(),m.getTextString(),m.getCSSStyle(),new t.Rectangle(l.x,l.y,l.w,Number.MAX_VALUE)):t.TextUtils.getOptimalFontSize(m.getCtx(),m.getTextString(),m.getCSSStyle(),new t.Rectangle(l.x,l.y,Number.MAX_VALUE,l.h))}var v=new t.MultilineText(e.getCtx(),c);p.setFontSize("font-size",_,e.getCtx()),v.setCSSStyle(p),t.TextUtils.fitText(v,l.w,l.h,e),"center"==s.label.position||"auto"==s.label.position&&o?(t.TextUtils.centerTextVertically(v,i.y+i.h/2),v.setX(i.x+i.w/2),v.alignCenter()):(t.TextUtils.centerTextVertically(v,i.y+i.h/2),!o&&r?(v.setX(i.x+i.w-l.h/2),v.alignRight()):o||r?o&&(v.setY(i.y+i.h-v.getDimensions().h-l.w/2),v.setX(i.x+i.w/2),v.alignCenter()):(v.setX(i.x+l.h/2),v.alignLeft())),a.addChild(v)},d._calcPointOnArc=function(t,e,a){return{x:Math.cos(a)*e+t.w/2+t.x,y:Math.sin(a)*e+t.h/2+t.y}},d._drawCircularArc=function(e,a,i,n,r,s,o,h,c,g){var u,p=e.getCtx();t.Agent.isRightToLeft(e.getCtx())&&(n=(n=Math.PI-n-r)>0?n:n+2*Math.PI),c?u=new t.Path(p,d.createCircularPathCmd(i,n,r,s,o)):(u=new _(p,i,n,r,s,o),e.__shapes.push(u)),u.setSolidFill(h);var m=l.getBorderColor(e);m&&!c?u.setSolidStroke(m):c&&g&&u.setSolidStroke(g);var v=e.getOptions();u.setClassName(c?v.plotArea.svgClassName:v.svgClassName),u.setStyle(c?v.plotArea.svgStyle:v.svgStyle),a.addChild(u)},d._drawCircularReferenceLine=function(e,a,i,n,r,s,o){var l=e.getCtx(),h=Math.min(i.w,i.h),c=.275*h,g=.5*h;t.Agent.isRightToLeft(e.getCtx())&&(n=(n=Math.PI-n)>0?n:n+2*Math.PI);var u=d._calcPointOnArc(i,c,n),p=d._calcPointOnArc(i,g,n),_=new t.Line(l,u.x,u.y,p.x,p.y),m=new t.Stroke(r,1,s,!1,t.Stroke.getDefaultDashProps(o,s));_.setStroke(m),a.addChild(_)},d.createCircularPathCmd=function(e,a,i,n,r){var s,o,l,h,c;return i<t.Math.TWO_PI?(o=d._calcPointOnArc(e,r,a),l=d._calcPointOnArc(e,r,a+i),h=d._calcPointOnArc(e,n,a+i),c=d._calcPointOnArc(e,n,a),s=t.PathUtils.moveTo(o.x,o.y)+t.PathUtils.arcTo(r,r,i,1,l.x,l.y)+t.PathUtils.lineTo(h.x,h.y)+t.PathUtils.arcTo(n,n,i,0,c.x,c.y)+t.PathUtils.closePath()):(o=d._calcPointOnArc(e,r,a),l=d._calcPointOnArc(e,r,a+i/2),h=d._calcPointOnArc(e,n,a),c=d._calcPointOnArc(e,n,a+i/2),s=t.PathUtils.moveTo(o.x,o.y)+t.PathUtils.arcTo(r,r,i/2,1,l.x,l.y)+t.PathUtils.arcTo(r,r,i/2,1,o.x,o.y),n>0&&(s+=t.PathUtils.moveTo(c.x,c.y)+t.PathUtils.arcTo(n,n,i/2,0,h.x,h.y)+t.PathUtils.arcTo(n,n,i/2,0,c.x,c.y)),s+=t.PathUtils.closePath()),s},d.getAngleQuadrant=function(e,a){var i=1;return a?e>=t.Math.HALF_PI&&e<Math.PI?i=2:e>=Math.PI&&e<1.5*Math.PI?i=3:e>=1.5*Math.PI&&e<t.Math.TWO_PI&&(i=4):e>t.Math.HALF_PI&&e<=Math.PI?i=2:e>Math.PI&&e<=1.5*Math.PI?i=3:(e>1.5*Math.PI&&e<t.Math.TWO_PI||0==e)&&(i=4),i},d._hasMetricLabelOutsidePlotArea=function(t){var e=t.metricLabel.position;return"auto"==e||"outsidePlotArea"==e||("withLabel"==e||"withTitle"==e)&&!l.hasLabel(t)},d._adjustCenterAndBounds=function(e,a,i,n,r,s,o){var l,h,c=null,g=d.getAngleQuadrant(i,!0),u=d.getAngleQuadrant(r,!1),p=s.w,_=s.h,m=p/2,v=_/2;if(g==u&&n<=t.Math.HALF_PI)l=2*Math.min(s.w,s.h),s.w=s.w+l/2,s.h=s.h+l/2,h=l*a,!o&&1==g||o&&2==g?(s.x-=l/2,s.y-=l/2,m=p/2-l/4+1,v=_/2-l/4+1,c=new t.Rectangle(s.x+s.w/2-1,s.y+s.h/2-1,h*(3/7)-2,h*(2.5/7)-2)):!o&&2==g||o&&1==g?(s.y-=l/2,m=p/2+l/4-1,v=_/2-l/4+1,c=new t.Rectangle(s.x+s.w/2-h*(3/7)+1,s.y+s.h/2-1,h*(3/7)-2,h*(2.5/7)-2)):!o&&3==g||o&&4==g?(m=p/2+l/4-1,v=_/2+l/4-1,c=new t.Rectangle(s.x+s.w/2-h*(3/7)+1,s.y+s.h/2-h*(2.5/7)+1,h*(3/7)-2,h*(2.5/7)-2)):(!o&&4==g||o&&3==g)&&(s.x-=l/2,m=p/2-l/4+1,v=_/2+l/4-1,c=new t.Rectangle(s.x+s.w/2-1,s.y+s.h/2-h*(2.5/7)+1,h*(3/7)-2,h*(2.5/7)-2));else if(g%4+1==u&&n<=Math.PI)1==g||3==g?(h=(l=Math.min(s.w,2*s.h))*a,s.w>s.h&&(c=new t.Rectangle(s.x+s.w/2-h*(3/7),s.y+s.h-(s.h-l/2)/2-h*(2.75/7),h*(6/7),h*(2.5/7)),1==g?(c.y=s.y+(s.h-l/2)/2+h*(.5/7),s.y-=l/2-(s.h-l/2)/2,v=_/2-l/4+1):(s.y+=(s.h-l/2)/2,v=_/2+l/4-1),s.h=l)):(h=(l=Math.min(2*s.w,s.h))*a,s.w<s.h&&(c=new t.Rectangle(s.x+s.w-(s.w-l/2)/2-h*(3.25/7),s.y+s.h/2-h*(2.5/7),h*(3/7),h*(5/7)),!o&&4==g||o&&2==g?(c.x=s.x+(s.w-l/2)/2+h*(.25/7),s.x-=l/2-(s.w-l/2)/2,m=p/2-l/4+1):(s.x+=(s.w-l/2)/2,m=p/2+l/4-1),s.w=l));else if(u%4+1==g&&n>Math.PI)if(1==g&&s.h>s.w){var b=(h=(l=Math.min(s.w/(Math.cos(i)+1)*2,s.w/(Math.sin(r-1.5*Math.PI)+1)*2,s.h))*a)*(3/7)*(2*s.w/l-1);o?(c=new t.Rectangle(s.x+s.w-l/2-b,s.y+s.h/2-h*(2.5/7),h*(3/7)+b,h*(5/7)),s.x-=l-s.w,m=-l/2+p):(c=new t.Rectangle(s.x+l/2-h*(3/7),s.y+s.h/2-h*(2.5/7),h*(3/7)*(2*s.w/l-1+1),h*(5/7)),m=l/2),s.w=l}else if(2==g&&s.h<s.w)h=(l=Math.min(s.h/(Math.cos(i-t.Math.HALF_PI)+1)*2,s.h/(Math.sin(r)+1)*2,s.w))*a,c=new t.Rectangle(s.x+s.w/2-h*(3/7),s.y+l/2-h*(2.5/7),h*(6/7),h*(2.5/7)*(2*s.h/l-1+1)),s.h=l,v=l/2;else if(3==g&&s.h>s.w){b=(h=(l=Math.min(s.w/(Math.cos(i-Math.PI)+1)*2,s.w/(Math.sin(r-t.Math.HALF_PI)+1)*2,s.h))*a)*(3/7)*(2*s.w/l-1);o?(c=new t.Rectangle(s.x+l/2-h*(3/7),s.y+s.h/2-h*(2.5/7),h*(3/7)*(2*s.w/l-1+1),h*(5/7)),m=l/2):(c=new t.Rectangle(s.x+s.w-l/2-b,s.y+s.h/2-h*(2.5/7),h*(3/7)+b,h*(5/7)),s.x-=l-s.w,m=-l/2+p),s.w=l}else if(4==g&&s.h<s.w){b=(h=(l=Math.min(s.h/(Math.cos(i-1.5*Math.PI)+1)*2,s.h/(Math.sin(t.Math.TWO_PI-r)+1)*2,s.w))*a)*(2.5/7)*(2*s.h/l-1);c=new t.Rectangle(s.x+s.w/2-h*(3/7),s.y+s.h-l/2-b,h*(6/7),h*(2.5/7)+b),s.y-=l-s.h,s.h=l,v=-l/2+_}return e.cx=m,e.cy=v,e.maxInnerDiameter=h,c},d._renderCenterContent=function(e,a,i,n,r){var s=new t.Rectangle(i.x+.5*(i.w-r),i.y+.5*(i.h-r),r,r);s=s.getIntersection(n);var o=new t.Rectangle(i.x+.5*(i.w-r/Math.sqrt(2)),i.y+.5*(i.h-r/Math.sqrt(2)),r/Math.sqrt(2),r/Math.sqrt(2));o=o.getIntersection(n);var l=a.center.renderer;if(l){var c={outerBounds:{x:s.x,y:s.y,width:s.w,height:s.h},innerBounds:{x:o.x,y:o.y,width:o.w,height:o.h},metricLabel:h.getFormattedMetricLabel(a.value,e),component:a._widgetConstructor},g=e.getCtx();c=g.fixRendererContext(c);var u=g.getContainer(),d=e.centerDiv;d&&u.removeChild(d);var p=l(c);if(!p)return;var _=g.createOverlayDiv();Array.isArray(p)?p.forEach(function(t){_.appendChild(t)}):_.appendChild(p),e.centerDiv=_,u.appendChild(_);var m=g.getOverlayAttachedCallback();m&&m(_)}};var p=function(t,e,a,i,n,r){this.Init(t,e,a,i,n,r)};t.Obj.createSubclass(p,t.Path),p.prototype.Init=function(t,e,a,i,n,r){p.superclass.Init.call(this,e),this._gauge=t,this.setCoords(a,i,n,r)},p.prototype.setCoords=function(e,a,i,n){this._x1=e,this._x2=a,this._y1=i,this._y2=n;var r=Math.min(e,a),s=Math.min(i,n),o=Math.abs(e-a),l=Math.abs(n-i),h=this._gauge.getOptions(),c="vertical"==h.orientation?o:l,g=t.PathUtils.rectangleWithBorderRadius(r,s,o,l,h.borderRadius,c,"15%");this.setCmds(g)},p.prototype.getAnimationParams=function(){return[this._x1,this._x2,this._y1,this._y2]},p.prototype.setAnimationParams=function(t){t&&4==t.length&&this.setCoords(t[0],t[1],t[2],t[3])};var _=function(t,e,a,i,n,r){this.Init(t,e,a,i,n,r)};t.Obj.createSubclass(_,t.Path),_.prototype.Init=function(t,e,a,i,n,r){_.superclass.Init.call(this,t),this.setPath(e,a,i,n,r)},_.prototype.setPath=function(e,a,i,n,r){e&&e instanceof t.Rectangle?this._bounds=e:e=this._bounds,this._startAngle=a,this._angleExtent=i,this._innerRadius=n,this._outerRadius=r,this.setCmds(d.createCircularPathCmd(e,a,i,n,r))},_.prototype.getAnimationParams=function(){return[this._bounds,this._startAngle,this._angleExtent,this._innerRadius,this._outerRadius]},_.prototype.setAnimationParams=function(t){t&&5==t.length&&this.setPath(t[0],t[1],t[2],t[3],t[4])},t.DialGauge=function(){},t.Obj.createSubclass(t.DialGauge,e),t.DialGauge.newInstance=function(e,a,i){var n=new t.DialGauge;return n.Init(e,a,i),n},t.DialGauge.prototype.Init=function(e,a,i){t.DialGauge.superclass.Init.call(this,e,a,i),this.Defaults=new m(e),this.__anchorPt=null},t.DialGauge.prototype.SetOptions=function(e){var a=(e=t.JsonUtils.clone(e)).background,i=e.indicator;"string"==typeof a&&(e.background=l.getDialBackground(a),e.background.images=e._backgroundImages),"string"==typeof i&&(e.indicator=l.getDialIndicator(i),e.indicator.images=e._indicatorImages),t.DialGauge.superclass.SetOptions.call(this,this.Defaults.calcOptions(e))},t.DialGauge.prototype.Render=function(t,e,a){v.render(this,t,e,a)},t.DialGauge.prototype.renderUpdate=function(){v.updateIndicatorAndLabel(this,this._container,this.Width,this.Height);var t=this.getEventManager();t&&t.associate(this._editingOverlay,this.__getLogicalObject(),!0),this.UpdateAriaLiveValue(this._container)},t.DialGauge.prototype.CreateAnimationOnDisplay=function(e,a,i){for(var n=[],r=0;r<e.length;r++){var s=e[r],o=s.getAnimationParams(),l=v.__getStartAngle(this);s.setAngle(l);var h=new t.CustomAnimation(this.getCtx(),s,i);h.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,s,s.getAnimationParams,s.setAnimationParams,o),h.getAnimator().setEasing(function(e){return t.Easing.backOut(e,.7)}),n.push(h)}return new t.ParallelPlayable(this.getCtx(),n)},t.DialGauge.prototype.GetValueAt=function(e,a){var i=Math.atan2(a-this.__anchorPt.y,e-this.__anchorPt.x),n=t.Math.radsToDegrees(i);n<=0&&(n+=360);var r=t.Agent.isRightToLeft(this.getCtx()),s=this.getOptions().background,o=r?180+s.startAngle:360-s.startAngle,l=s.angleExtent,h=o+l;if(r)for(h=o,o-=l;o<0;)o+=360,h+=360;n+360>=o&&n+360<=h?n+=360:n>=o&&n<=h||(n=n>h?o+360-n<n-h?o:h:o-n<n+360-h?o:h);var c=(n-o)/l;r&&(c=1-c);var g=this.Options.min;return c*(this.Options.max-g)+g};var m=function(t){this.Init({alta:m.SKIN_ALTA},t)};t.Obj.createSubclass(m,n),m.SKIN_ALTA={background:{startAngle:180,angleExtent:180,indicatorLength:.7},metricLabel:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA)},tickLabel:{scaling:"auto",style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA)}};var v=new Object;t.Obj.createSubclass(v,t.Obj),v.render=function(e,a,i,n){if(r.hasData(e)){var s=new t.Rectangle(0,0,i,n);v._renderShape(e,a,s),v._renderLabel(e,a,s)}else h.renderEmptyText(e,a,new t.Rectangle(0,0,i,n))},v.updateIndicatorAndLabel=function(e,a,i,n){e.__indicatorContainer.setAngle(v._getRotation(e,e.getOptions().value)),a.removeChild(e.__label),v._renderLabel(e,a,new t.Rectangle(0,0,i,n))},v._renderShape=function(e,a,i){var n=e.getOptions(),r=v._createBackground(e,i);a.addChild(r),n.background.majorTickCount&&n.background.radius&&v._renderTickLabels(e,a,i);var s=v._createIndicator(e,i),o=new t.Container(e.getCtx()),l=new b(e.getCtx());a.addChild(o),o.addChild(l),l.addChild(s);var h=s.getDimensions(),c=v._getRotation(e,n.value),g=v._getBackgroundAnchorPoint(e,i),u=v._getIndicatorAnchorPoint(e,i,h),d=v._getIndicatorScaleFactor(e,i,h),p=new t.Matrix;p=p.translate(-u.x,-u.y),s.setMatrix(p.scale(d,d)),l.setAngle(c),p=new t.Matrix,o.setMatrix(p.translate(g.x,g.y)),e.__shapes.push(l),e.__indicatorContainer=l,e.__anchorPt=g},v._createBackground=function(e,a){var i=e.getOptions().background,n=t.Agent.isRightToLeft(e.getCtx()),r=t.Agent.isTouchDevice(),s=r?2*a.w:a.w,o=r?2*a.h:a.h,l=i.images;if(l&&l.length>0){var h,c,g,u=[];for(h=0;h<l.length;h++){var d="rtl"==l[h].dir;n&&d?u.push(l[h]):n||d||u.push(l[h])}for(l=u.length>0?u:l,h=0;h<l.length;h++){var p=l[h],_=p.src,m=p.width,v=p.height,b=_&&_.search(".svg")>-1;if(0==h&&(c=m,g=v),b||m>=s&&v>=o||h==l.length-1){var y=new t.Image(e.getCtx(),_,0,0,m,v),f=new t.Matrix,C=Math.min(a.w/m,a.h/v),x=(a.w-C*m)/2,A=(a.h-C*v)/2;if(f=f.scale(C,C),y.setMatrix(f.translate(x,A)),b&&("safari"===t.Agent.browser||"chrome"===t.Agent.browser)){var S=t.ImageLoader.loadImage(_,y.__setDimensions.bind(y));S&&y.__setDimensions(S)}if(a.x+=x,a.y+=A,a.w=C*m,a.h=C*v,isNaN(i.anchorX)||isNaN(i.anchorY)||(i._anchorX=n?a.x+a.w-a.w*i.anchorX/c:a.x+a.w*i.anchorX/c,i._anchorY=a.y+a.h*i.anchorY/g),i.metricLabelBounds){var w={};w.width=a.w*i.metricLabelBounds.width/c,w.height=a.h*i.metricLabelBounds.height/g,w.y=a.y+a.h*i.metricLabelBounds.y/g,w.x=n?a.x+a.w-a.w*i.metricLabelBounds.x/c-w.width:a.x+a.w*i.metricLabelBounds.x/c,i._metricLabelBounds=w}var O=Math.min(a.w/c,a.h/g);return i._radius=i.radius*O,i._tickLabelHeight=i.tickLabelHeight*a.h/g,i._tickLabelWidth=i.tickLabelWidth*a.w/c,y}}}return null},v._createIndicator=function(e,a){var i,n,r=e.getOptions().indicator,s=v._getIndicatorLength(e,a),o=t.Agent.isTouchDevice()?2*s:s,l=r.images;if(l&&l.length>0)for(var h=0;h<l.length;h++){var c=l[h],g=c.src,u=c.width,d=c.height,p=g&&g.search(".svg")>-1;if(0==h&&(i=u,n=d),p||d>=o||h==l.length-1){var _=new t.Image(e.getCtx(),g,0,0,u,d);if(p&&("safari"===t.Agent.browser||"chrome"===t.Agent.browser))t.ImageLoader.loadImage(g,_.__setDimensions.bind(_))&&(_.setWidth(u),_.setHeight(d));return isNaN(r.anchorX)||isNaN(r.anchorY)||(r._anchorX=r.anchorX*u/i,r._anchorY=r.anchorY*d/n),_}}return null},v.__getStartAngle=function(e){var a=e.getOptions().background,i=t.Agent.isRightToLeft(e.getCtx())?180-a.startAngle:a.startAngle;return Math.PI*(90-i)/180},v._getRotation=function(e,a){var i=e.getOptions(),n=i.background,r=i.min,s=i.max,o=((a=Math.max(Math.min(a,s),r))-r)/(s-r),l=t.Agent.isRightToLeft(e.getCtx()),h=(l?180-n.startAngle:n.startAngle)-o*(l?-n.angleExtent:n.angleExtent);return Math.PI*(90-h)/180},v._getBackgroundAnchorPoint=function(e,a){var i=e.getOptions().background,n=i._anchorX,r=i._anchorY;return isNaN(n)||isNaN(r)?new t.Point(a.x+a.w/2,a.y+a.h/2):new t.Point(n,r)},v._getIndicatorLength=function(t,e){var a=Math.min(e.w,e.h)/2;return t.getOptions().background.indicatorLength*a},v._getIndicatorAnchorPoint=function(e,a,i){var n=e.getOptions().indicator,r=n._anchorX,s=n._anchorY;return isNaN(r)||isNaN(s)?new t.Point(i.x+i.w/2,i.y+i.h):new t.Point(r,s)},v._getIndicatorScaleFactor=function(t,e,a){return v._getIndicatorLength(t,e)/a.h},v._renderLabel=function(e,a,i){var n=e.getOptions();if("on"==n.metricLabel.rendered){var r=h.getFormattedMetricLabel(n.value,e),s=h.getFormattedMetricLabel(n.min,e),o=h.getFormattedMetricLabel(n.max,e),l=i.x+i.w/2,c=i.y+i.h/2,g=i.w,u=i.h,d=n.background._metricLabelBounds;d&&(l=d.x+d.width/2,c=d.y+d.height/2,i.w=d.width,i.h=d.height);var p=new t.OutputText(e.getCtx(),r,l,c);!n.metricLabel.style.getStyle("color")&&n.background._isDark&&n.metricLabel.style.setStyle("color","#CCCCCC"),p.setCSSStyle(n.metricLabel.style);var _=n.metricLabel.style.getFontSize();_||(_=h.calcLabelFontSize([r,s,o],p,i),p.setTextString(r),p.setFontSize(_)),p.alignCenter(),p.alignMiddle(),t.TextUtils.fitText(p,g,u,a)&&(e.__label=p)}},v._renderTickLabels=function(e,a,i){var n=e.getOptions(),r=t.Agent.isRightToLeft(e.getCtx());if(n.background.radius&&n.background.majorTickCount){var s=n.background._radius,o=n.min,l=n.max,c=n.background.majorTickCount,g=12,u=new t.Rectangle(C,x,i.w,i.h),d=n.metricLabel.style.getStyle("font-size");if(n.background._tickLabelHeight&&!d&&(u.h=n.background._tickLabelHeight),n.background._tickLabelWidth&&!d&&(u.w=n.background._tickLabelWidth),!d){var p=new t.OutputText(e.getCtx(),"",C,x);g=h.calcLabelFontSize([h.formatTickLabelValue(n.max,e),h.formatTickLabelValue(n.min,e)],p,u)}for(var _=0;_<c;_++){var m=o+Math.abs(l-o)*_/(c-1);r&&(m=o+Math.abs(l-o)*(c-1-_)/(c-1));var b=h.formatTickLabelValue(m,e),y=v._getRotation(e,m),f=v._getBackgroundAnchorPoint(e,i),C=f.x+s*Math.cos(y-Math.PI/2),x=f.y+s*Math.sin(y-Math.PI/2);p=new t.OutputText(e.getCtx(),b,C,x);!n.tickLabel.style.getStyle("color")&&n.background._isDark&&n.tickLabel.style.setStyle("color","#CCCCCC"),p.setCSSStyle(n.tickLabel.style),n.tickLabel.style.getStyle("font-size")||p.setFontSize(g),p.alignCenter(),p.alignMiddle(),t.TextUtils.fitText(p,u.w+.5,u.h+.5,a)}}};var b=function(t){this.Init(t)};t.Obj.createSubclass(b,t.Container),b.prototype.setAngle=function(e){var a=new t.Matrix;this.setMatrix(a.rotate(e)),this._angleRads=e},b.prototype.getAnimationParams=function(){return[this._angleRads]},b.prototype.setAnimationParams=function(t){t&&1==t.length&&this.setAngle(t[0])},t.RatingGauge=function(){},t.Obj.createSubclass(t.RatingGauge,e),t.RatingGauge.newInstance=function(e,a,i){var n=new t.RatingGauge;return n.Init(e,a,i),n},t.RatingGauge.prototype.Init=function(e,a,i){t.RatingGauge.superclass.Init.call(this,e,a,i),this.Defaults=new y(e)},t.RatingGauge.prototype.SetOptions=function(e){(e=t.JsonUtils.clone(e)).changedState&&(e.changedState.className&&(e.changedState.svgClassName=e.changedState.className),e.changedState.style&&(e.changedState.svgStyle=e.changedState.style)),e.hoverState&&(e.hoverState.className&&(e.hoverState.svgClassName=e.hoverState.className),e.hoverState.style&&(e.hoverState.svgStyle=e.hoverState.style)),e.selectedState&&(e.selectedState.className&&(e.selectedState.svgClassName=e.selectedState.className),e.selectedState.style&&(e.selectedState.svgStyle=e.selectedState.style)),e.unselectedState&&(e.unselectedState.className&&(e.unselectedState.svgClassName=e.unselectedState.className),e.unselectedState.style&&(e.unselectedState.svgStyle=e.unselectedState.style)),this.getCtx().isCustomElement()&&(e.readOnly=e.readonly),t.RatingGauge.superclass.SetOptions.call(this,this.Defaults.calcOptions(e))},t.RatingGauge.prototype.Render=function(e,a,i){var n=this.Options.__layout.outerGap,r=this.Options.max,s="vertical"==this.Options.orientation,o=this.Options.selectedState.source,l="none"!=this.Options.preserveAspectRatio;if(o&&l){return t.ImageLoader.loadImage(this.Options.selectedState.source,function(o){if("ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||11!=t.Agent.version||!o||0!=o.width||0!=o.height||(o.width=1,o.height=1),o&&o.width&&o.height){var l=o.width/o.height;this.__shapeWidth=s?Math.min(a-2*n,(i-2*n)*l/r):Math.min((i-2*n)*l,(a-2*n)/r),this.__shapeHeight=this.__shapeWidth/l,this.__bounds=s?new t.Rectangle(n,(i-this.__shapeHeight*r)/2,a-2*n,this.__shapeHeight*r):new t.Rectangle((a-this.__shapeWidth*r)/2,n,this.__shapeWidth*r,i-2*n),C.render(this,e,a,i)}this.PostRender(this.Options,e)}.bind(this)),!1}return l?(this.__shapeWidth=s?Math.min(a-2*n,(i-2*n)/r):Math.min(i-2*n,(a-2*n)/r),this.__shapeHeight=this.__shapeWidth):(this.__shapeWidth=s?a-2*n:(a-2*n)/r,this.__shapeHeight=s?(i-2*n)/r:i-2*n),this.__bounds=s?new t.Rectangle(n,(i-this.__shapeHeight*r)/2,a-2*n,this.__shapeHeight*r):new t.Rectangle((a-this.__shapeWidth*r)/2,n,this.__shapeWidth*r,i-2*n),C.render(this,e,a,i),!0},t.RatingGauge.prototype.__getLogicalObject=function(){var e=this.Options.tooltip,a=e?e.renderer:null,i=l.getColor(this);if(a){var n={component:this.Options._widgetConstructor,label:h.getFormattedMetricLabel(this.Options.value,this),color:i};return new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),a,i,n)}return new f(this)},t.RatingGauge.prototype.GetValueAt=function(e,a){var i="vertical"==this.Options.orientation?this.__shapeHeight:this.__shapeWidth;if(r.hasData(this)){if("vertical"==this.Options.orientation)a=Math.max(Math.min(a,this.__bounds.y+this.__bounds.h),this.__bounds.y),n=Math.max((this.__bounds.y+this.__bounds.h-a)/i,this.Options.min);else{e=Math.max(Math.min(e,this.__bounds.x+this.__bounds.w),this.__bounds.x);var n=0;n=t.Agent.isRightToLeft(this.getCtx())?Math.max((this.__bounds.x+this.__bounds.w-e)/i,this.Options.min):Math.max((e-this.__bounds.x)/i,this.Options.min)}return h.adjustForStep(this.Options,n)}return null},t.RatingGauge.prototype.__processHoverEnd=function(e,a){this.__updateClipRects(this.Options.value,"render"),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this.Options.value,this.Options.value,!1))},t.RatingGauge.prototype.__processValueChangeStart=function(t,e){this.__processValueChangeMove(t,e)},t.RatingGauge.prototype.__processValueChangeMove=function(e,a){var i=this.GetValueAt(e,a);this.__updateClipRects(i,"hover"),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this.Options.value,i,!1))},t.RatingGauge.prototype.__processValueChangeEnd=function(e,a){var i=this.Options.value;this.Options.value=this.GetValueAt(e,a),this.Options.changed=!0,this.render(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(i,this.Options.value,!1)),this.dispatchEvent(t.EventFactory.newValueChangeEvent(i,this.Options.value,!0))},t.RatingGauge.prototype.__updateClipRects=function(e,a,i){if(r.hasData(this)){i||(i=this._container);var n=t.Agent.isRightToLeft(this.getCtx()),s="vertical"==this.Options.orientation,o=s?this.__shapeHeight:this.__shapeWidth,l=0,h=(e=Math.max(Math.min(e,this.Options.max),0))*o,c=e*o;if("render"==a&&(l=e*o,h=0),s){var g=i.getChildAt(0);(d=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,this.__bounds.w,this.__bounds.h-c),g.setClipPath(d);var u=i.getChildAt(1);if((p=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y+this.__bounds.h-l,this.__bounds.w,l),u.setClipPath(p),_=i.getChildAt(2))(m=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y+this.__bounds.h-h,this.__bounds.w,h),_.setClipPath(m)}else if(n){g=i.getChildAt(0);(d=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,this.__bounds.w-c,this.__bounds.h),g.setClipPath(d);u=i.getChildAt(1);if((p=new t.ClipPath).addRect(this.__bounds.x+this.__bounds.w-c,this.__bounds.y,l,this.__bounds.h),u.setClipPath(p),_=i.getChildAt(2))(m=new t.ClipPath).addRect(this.__bounds.x+this.__bounds.w-c,this.__bounds.y,h,this.__bounds.h),_.setClipPath(m)}else{var d,g=i.getChildAt(0);(d=new t.ClipPath).addRect(this.__bounds.x+c,this.__bounds.y,this.__bounds.w-c,this.__bounds.h),g.setClipPath(d);var p,_,m,u=i.getChildAt(1);if((p=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,l,this.__bounds.h),u.setClipPath(p),_=i.getChildAt(2))(m=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,h,this.__bounds.h),_.setClipPath(m)}this.UpdateAriaLiveValue(i,e)}},t.RatingGauge.prototype.__getRatingGaugeItem=function(t){return this._container.getChildAt(0).getChildAt(t)},t.RatingGauge.prototype.CreateEventManager=function(){return new x(this)};var y=function(t){this.Init({alta:y.SKIN_ALTA},t)};t.Obj.createSubclass(y,n),y.SKIN_ALTA={min:0,max:5,orientation:"horizontal",unselectedState:{shape:"star",color:"#C4CED7"},selectedState:{shape:"star",color:"#F8C15A"},hoverState:{shape:"star",color:"#007CC8"},changedState:{shape:"star",color:"#ED2C02"},preserveAspectRatio:"meet",step:1};var f=function(t){this.Init(),this._gauge=t};t.Obj.createSubclass(f,t.SimpleObjPeer),f.prototype.getDatatip=function(t,e,a){var i,n=this._gauge.getOptions();i=this._gauge.getEventManager().__isMouseEditing()?r.getValueThresholdIndex(this._gauge,this._gauge.GetValueAt(e,a)):r.getValueThresholdIndex(this._gauge);var s=r.getThreshold(this._gauge,i);return s&&s.shortDesc?s.shortDesc:n.shortDesc};var C=new Object;t.Obj.createSubclass(C,t.Obj),C.render=function(e,a,i,n){if(r.hasData(e)){var s=e.getOptions(),o=r.getValueThresholdIndex(e),l=r.getThreshold(e,o),c=s.selectedState.color,g=s.changedState.color,u=s.selectedState.borderColor,d=s.changedState.borderColor;l&&l.color&&(c=l.color,g=l.color),l&&l.borderColor&&(u=l.borderColor,d=l.borderColor);var p={value:0,type:s.unselectedState.shape,color:s.unselectedState.color,borderColor:s.unselectedState.borderColor,visualEffects:s.visualEffects,source:s.unselectedState.source,svgClassName:s.unselectedState.svgClassName,svgStyle:s.unselectedState.svgStyle},_={value:0,type:s.selectedState.shape,color:c,borderColor:u,visualEffects:s.visualEffects,source:s.selectedState.source,svgClassName:s.selectedState.svgClassName,svgStyle:s.selectedState.svgStyle},m={value:0,type:s.changedState.shape,color:g,borderColor:d,visualEffects:s.visualEffects,source:s.changedState.source,svgClassName:s.changedState.svgClassName,svgStyle:s.changedState.svgStyle},v={value:0,type:s.hoverState.shape,color:s.hoverState.color,borderColor:s.hoverState.borderColor,visualEffects:s.visualEffects,source:s.hoverState.source,svgClassName:s.hoverState.svgClassName,svgStyle:s.hoverState.svgStyle};"dot"==s.unselectedState.shape&&(p.type="circle",p.visualEffects="none",p.size=.05),C._createShapes(e,a,p),C._createShapes(e,a,s.changed?m:_),s.readOnly||C._createShapes(e,a,v),e.__updateClipRects(s.value,"render",a)}else h.renderEmptyText(e,a,new t.Rectangle(0,0,i,n))},C._createShapes=function(e,a,i){var n=e.getCtx(),r=new t.Container(n);a.addChild(r);for(var s=e.getOptions(),o=e.__bounds,l=e.__shapeWidth,h=e.__shapeHeight,c="ie"===t.Agent.browser||"edge"===t.Agent.browser?null:C._createShape(n,0,0,l,h,i,s),g=0;g<s.max;g++){var u,d;if("vertical"==s.orientation?(u=o.x+o.w/2-l/2,d=o.y+o.h-(g+1)*h):t.Agent.isRightToLeft(n)?(u=o.x+o.w-(g+1)*l,d=o.y+o.h/2-h/2):(u=o.x+g*l,d=o.y+o.h/2-h/2),"ie"===t.Agent.browser||"edge"===t.Agent.browser){var p=C._createShape(n,u,d,l,h,i,s);p&&r.addChild(p)}else if(c){var _=new t.Use(n,u,d,c);r.addChild(_)}}},C._createShape=function(e,a,i,n,r,s,o){var l;return s.source?(l=new t.ImageMarker(e,a+n/2,i+r/2,n,r,null,s.source)).setPreserveAspectRatio("none"):"none"!=s.type&&(l=t.LedGauge.newInstance(e,null,null,!0),0!=a&&0!=i&&l.setTranslate(a,i),l.render(s,n,r)),l&&(l.setClassName(o.svgClassName),l.setStyle(o.svgStyle)),l};var x=function(t){this.Init(t.getCtx(),t.dispatchEvent,t,t),this._gauge=t};t.Obj.createSubclass(x,s),x.prototype.OnMouseOver=function(t){if(!1===this._gauge.getOptions().readOnly){var e=this.GetRelativePosition(t.pageX,t.pageY);this._gauge.__processValueChangeStart(e.x,e.y),this.IsMouseEditing=!0}x.superclass.OnMouseOver.call(this,t)},x.prototype.OnMouseOut=function(t){if(!1===this._gauge.getOptions().readOnly){var e=this.GetRelativePosition(t.pageX,t.pageY);this._gauge.__processHoverEnd(e.x,e.y),this.IsMouseEditing=!1}x.superclass.OnMouseOut.call(this,t)},x.prototype.OnMouseMove=function(t){var e=this.GetRelativePosition(t.pageX,t.pageY);!1!==this._gauge.getOptions().readOnly||this.IsMouseEditing||this._gauge.getOptions().value==this._gauge.GetValueAt(e.x,e.y)||(this.IsMouseEditing=!0),x.superclass.OnMouseMove.call(this,t)},x.prototype.OnMouseDown=function(t){s.superclass.OnMouseDown.call(this,t)},x.prototype.ProcessKeyboardEvent=function(t){return this.IsMouseEditing=!1,x.superclass.ProcessKeyboardEvent.call(this,t)},x.prototype.IsShowingTooltipWhileEditing=function(){return!0}}(dvt);
  return dvt;
});
