/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){t.NBox=function(t,e,n){this.Init(t,e,n)},t.Obj.createSubclass(t.NBox,t.BaseComponent),t.NBox.newInstance=function(e,n,o){return new t.NBox(e,n,o)},t.NBox.getDefaults=function(t){return(new e).getDefaults(t)},t.NBox.prototype.Init=function(n,o,a){t.NBox.superclass.Init.call(this,n,o,a),this.Defaults=new e(n),this.EventManager=new g(this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()||this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("nbox1000"+Math.floor(1e9*Math.random())),this._peers=[],this._animationAllowed=!0},t.NBox.prototype.SetOptions=function(e){e||(e=this.getSanitizedOptions()),e?(this.Options=this.Defaults.calcOptions(e),_.processDataObject(this),t.Agent.isEnvironmentTest()&&(this.Options[t.NBoxConstants.ANIMATION_ON_DISPLAY]="none",this.Options[t.NBoxConstants.ANIMATION_ON_DATA_CHANGE]="none")):this.Options||(this.Options=this.GetDefaults()),this._displayables=[],this.Options.__displayableCache=new t.BaseComponentCache;var n=this.Options[t.NBoxConstants.SELECTION_MODE];this._selectionHandler="single"==n?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"==n?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):null,this.EventManager.setSelectionHandler(this._selectionHandler)},t.NBox.prototype.render=function(e,n,o){var a=N.getAnimationOnDataChange(this),i=null;this.Options&&"none"!==a&&((i={options:this.Options,getOptions:function(){return this.options},displayables:this._displayables,getDisplayables:function(){return this.displayables},id:this.getId(),getId:function(){return this.id}}).getOptions=i.getOptions,i.getDisplayables=i.getDisplayables,i.getId=i.getId),this.__cleanUp(),this.SetOptions(e),isNaN(n)||isNaN(o)||(this.Width=n,this.Height=o);var r=new t.Container(this.getCtx());if(this.addChild(r),h.render(this,r,new t.Rectangle(0,0,this.Width,this.Height)),e&&_.getDrawer(this)&&_.getGrouping(this)){var s=_.getDisplayable(this,_.getDrawer(this));this.EventManager.setFocus(s),this.EventManager.setFocused(!1)}this._updateKeyboardFocusEffect(),this.StopAnimation();var g=N.getAnimationOnDisplay(this),d=N.getAnimationDuration(this),u=new t.Rectangle(0,0,this.Width,this.Height),C=!1;if(this._container){if("none"!=a&&e)if(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(this.getCtx(),a,this._container,r,u,d),this.Animation)C=!0;else{this._deleteContainer=new t.Container(this.getCtx(),"DeleteContainer"),this.addChild(this._deleteContainer);var c=new l(this.getCtx(),this._deleteContainer,i,this),x=h.getNodeOrderFunction(this);c.constructAnimation([i],[this]),this.Animation=c.getAnimation(),t.Playable.appendOnEnd(this.Animation,x,this)}}else"none"!==g&&(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(this.getCtx(),g,r,u,d));this.Animation?(this.setMouseEnabled(!1),t.Playable.appendOnEnd(this.Animation,this._getOnAnimationEndFunction(e),this),this.Animation.play()):this._getOnAnimationEndFunction(e).call(this),C?this._oldContainer=this._container:this._container&&(this.removeChild(this._container),this._container.destroy()),this._container=r,this.UpdateAriaAttributes()},t.NBox.prototype.__cleanUp=function(){this.EventManager.hideTooltip(),this._peers.length=0},t.NBox.prototype._getOnAnimationEndFunction=function(e){return function(){this._oldContainer&&(this.removeChild(this._oldContainer),this._oldContainer.destroy(),this._oldContainer=null),this._deleteContainer&&(this.removeChild(this._deleteContainer),this._deleteContainer.destroy()),this._deleteContainer=null,this.setMouseEnabled(!0),this.AnimationStopped||(this.Animation&&("ie"===t.Agent.browser||"edge"===t.Agent.browser)&&t.Agent.version>=12&&(this.Animation=null,this.setAnimationAllowed(!1),this.render(e),this.setAnimationAllowed(!0)),this.RenderComplete()),this.Animation=null,this.AnimationStopped=!1}},t.NBox.prototype.CreateKeyboardHandler=function(t){return new d(t,this)},t.NBox.prototype.getChildContainer=function(){return this._container},t.NBox.prototype.getDeleteContainer=function(){return this._deleteContainer},t.NBox.prototype.getDisplayables=function(){return this._displayables},t.NBox.prototype._updateKeyboardFocusEffect=function(){var t,e=this.EventManager.getFocus(),n=!1;e&&(n=e.isShowingKeyboardFocusEffect(),e.getKeyboardFocusDisplayable&&(t=e.getKeyboardFocusDisplayable()),t&&n&&t.showKeyboardFocusEffect(),this.EventManager.setFocus(t))},t.NBox.prototype.processEvent=function(t,e){var n=t.type;"categoryHighlight"==n?t=this._processRolloverEvent(t):"selection"==n&&(t=this._processSelectionEvent(t)),t&&this.dispatchEvent(t)},t.NBox.prototype._processRolloverEvent=function(t){return this._processHighlighting(t.categories),t},t.NBox.prototype._processSelectionEvent=function(e){var n=e.selection,o=null;if(n){for(var a={},r=0;r<n.length;r++)a[n[r]]=!0;var l=this.getObjects(),g=null;if(_.getGrouping(this))for(r=0;r<l.length;r++)if(l[r]instanceof i){if(a[l[r].getId()]){a[l[r].getId()]=!1;for(var d=l[r].getData().nodeIndices,u=0;u<d.length;u++){a[_.getNode(this,d[u])[t.NBoxConstants.ID]]=!0}}}else l[r]instanceof s&&(g=l[r]);var h=[];for(var C in o=[],a)a[C]&&(h.push(C),o.push(C));e=t.EventFactory.newSelectionEvent(h)}return _.setSelectedItems(this,o),g&&g.UpdateAccessibilityAttributes(),e},t.NBox.prototype.registerObject=function(t){this._peers.push(t)},t.NBox.prototype.getObjects=function(){return this._peers},t.NBox.prototype.getWidth=function(){return this.Width},t.NBox.prototype.getHeight=function(){return this.Height},t.NBox.prototype.getSelectionHandler=function(){return this._selectionHandler},t.NBox.prototype.isSelectionSupported=function(){return!!this._selectionHandler},t.NBox.prototype.animateUpdate=function(t,e){h.animateUpdate(t,e,this)},t.NBox.prototype.getSanitizedOptions=function(){return t.JsonUtils.clone(this.getOptions(),function(t){return 0!=t.indexOf("__")})},t.NBox.prototype.getSubcomponentStyles=function(){return{}},t.NBox.prototype.__isDragAvailable=function(t){return this._selectionHandler?t[0]:null},t.NBox.prototype.__getDragTransferable=function(e){e.isSelected()||(this._selectionHandler.processClick(e,!1),this.EventManager.fireSelectionEvent());for(var n=[],a={},r=this._selectionHandler.getSelection(),s=0;s<r.length;s++){var l=r[s];if(l instanceof o){var g=l.getData()[t.NBoxConstants.ID];n.push(g),a[g]=!0}else if(l instanceof i){for(var d=l.getData().nodeIndices,u=0;u<d.length;u++){var h=_.getNode(this,d[u])[t.NBoxConstants.ID];n.push(h),a[h]=!0}a[l.getData()[t.NBoxConstants.ID]]=!0}}var C=this._selectionHandler.getSelectedIds();for(s=0;s<C.length;s++){if(!a[g=C[s]])if(isNaN(_.getNodeIndex(this,g))){if(_.getGrouping(this)&&_.getCategoryNode(this,g)){for(d=_.getCategoryNode(this,g).nodeIndices,u=0;u<d.length;u++){a[h=_.getNode(this,d[u])[t.NBoxConstants.ID]]||(n.push(h),a[h]=!0)}a[g]=!0}}else n.push(g),a[g]=!0}return n},t.NBox.prototype.__getDragFeedback=function(){return this._selectionHandler.getSelection().slice(0)},t.NBox.prototype.__getCellUnderPoint=function(t,e){for(var n=_.getRowCount(this)*_.getColumnCount(this),o=0;o<n;o++){var a=_.getDisplayable(this,_.getCell(this,o));if(a.contains(t,e))return a}return null},t.NBox.prototype.__showDropSiteFeedback=function(t){return this._dropSiteFeedback&&(this._dropSiteFeedback.getParent().removeChild(this._dropSiteFeedback),this._dropSiteFeedback=null),t&&(this._dropSiteFeedback=t.renderDropSiteFeedback()),this._dropSiteFeedback},t.NBox.prototype.getAutomation=function(){return this.Automation||(this.Automation=new u(this)),this.Automation},t.NBox.prototype.GetComponentDescription=function(){var e=this.getOptions().translations;return _.hasValidData(this)?t.ResourceUtils.format(e.componentName,[_.getColumnCount(this)*_.getRowCount(this)]):e.labelInvalidData},t.NBox.prototype.highlight=function(e){this.Options.highlightedCategories=t.JsonUtils.clone(e),this._processHighlighting(e)},t.NBox.prototype._processHighlighting=function(e){var n=this.getNodeDisplayables(),a=this,r=function(n){if(n instanceof o){if(n.getCategories())return"all"==a.getOptions()[t.NBoxConstants.HIGHLIGHT_MATCH]?t.ArrayUtils.hasAllItems(e,n.getCategories()):t.ArrayUtils.hasAnyItem(e,n.getCategories())}else if(n instanceof i)for(var r=n.getData(),s=r.nodeIndices.length,l=0;l<s;l++){var g=_.getNode(a,r.nodeIndices[l]);if(g[t.NBoxConstants.CATEGORIES]&&("all"==a.getOptions()[t.NBoxConstants.HIGHLIGHT_MATCH]?t.ArrayUtils.hasAllItems(e,g[t.NBoxConstants.CATEGORIES]):t.ArrayUtils.hasAnyItem(e,g[t.NBoxConstants.CATEGORIES])))return!0}return!1},s=_.getRowCount(a)*_.getColumnCount(a);for(a.getOptions().__highlightedMap=null,h=0;h<s;h++){var l=_.getCell(a,h),g=_.getDisplayable(a,l);C.renderHeader(a,l,g,!1)}var d=_.getHighlightedItems(a),u={};if(d)for(var h=0;h<d.length;h++)u[d[h][t.NBoxConstants.ID]]=!0;for(h=0;h<n.length;h++)if(e&&e.length>0&&!r(n[h])?n[h].setAlpha(N.getFadedNodeAlpha(this)):n[h].setAlpha(1),n[h]instanceof i){for(var c=0,p=n[h].getData(),f=0;f<p.nodeIndices.length;f++)u[p.nodeIndices[f]]&&(c+=1);p.highlightedCount=c;var b=null!=N.getStyledCategoryIndicatorIcon(a,p)||null!=N.getCategoryNodeIndicatorColor(a,p);x._renderNodeCount(a,n[h].getData(),n[h],p.__scale,b,p.__gap)}},t.NBox.prototype.getNodeDisplayables=function(){for(var e=[],n=_.getNodeCount(this),o=0;o<n;o++)e.push(_.getNode(this,o));var a=_.getGroupBehavior(this),i=this.getOptions().__groups;if(i)if(a==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){var r=_.getRowCount(this)*_.getColumnCount(this);for(o=0;o<r;o++){var s=i[o+""];for(var l in s)e.push(s[l])}}else for(var l in i)e.push(i[l]);var g=[];for(o=0;o<e.length;o++){var d=_.getDisplayable(this,e[o]);d&&g.push(d)}return g},t.NBox.prototype.isAnimationAllowed=function(){return this._animationAllowed},t.NBox.prototype.setAnimationAllowed=function(t){this._animationAllowed=t},t.NBoxConstants={},t.Obj.createSubclass(t.NBoxConstants,t.Obj),t.NBoxConstants.COLUMN="column",t.NBoxConstants.COLUMNS="columns",t.NBoxConstants.COLUMNS_TITLE="columnsTitle",t.NBoxConstants.COLUMNS_TITLE_STYLE="columnsTitleStyle",t.NBoxConstants.COLUMN_LABEL_STYLE="columnLabelStyle",t.NBoxConstants.MAXIMIZED_COLUMN="maximizedColumn",t.NBoxConstants.ROW="row",t.NBoxConstants.ROWS="rows",t.NBoxConstants.ROWS_TITLE="rowsTitle",t.NBoxConstants.ROWS_TITLE_STYLE="rowsTitleStyle",t.NBoxConstants.ROW_LABEL_STYLE="rowLabelStyle",t.NBoxConstants.MAXIMIZED_ROW="maximizedRow",t.NBoxConstants.CELL="cell",t.NBoxConstants.CELLS="cells",t.NBoxConstants.CELL_DEFAULTS="cellDefaults",t.NBoxConstants.NODES="nodes",t.NBoxConstants.NODE_DEFAULTS="nodeDefaults",t.NBoxConstants.CATEGORIES="categories",t.NBoxConstants.ICON="icon",t.NBoxConstants.ICON_DEFAULTS="iconDefaults",t.NBoxConstants.INDICATOR="indicator",t.NBoxConstants.INDICATOR_ICON="indicatorIcon",t.NBoxConstants.INDICATOR_ICON_DEFAULTS="indicatorIconDefaults",t.NBoxConstants.INDICATOR_COLOR="indicatorColor",t.NBoxConstants.X_PERCENTAGE="xPercentage",t.NBoxConstants.Y_PERCENTAGE="yPercentage",t.NBoxConstants.SELECTION="selection",t.NBoxConstants.SELECTION_MODE="selectionMode",t.NBoxConstants.SELECTION_INFO="selectionInfo",t.NBoxConstants.HAS_SELECTION_LISTENER="hasSelectionListener",t.NBoxConstants.HIGHLIGHTED_CATEGORIES="highlightedCategories",t.NBoxConstants.HIGHLIGHT_MATCH="highlightMatch",t.NBoxConstants.HIDDEN_CATEGORIES="hiddenCategories",t.NBoxConstants.HOVER_BEHAVIOR="hoverBehavior",t.NBoxConstants.GROUP_CATEGORY="groupCategory",t.NBoxConstants.GROUP_ATTRIBUTES="groupAttributes",t.NBoxConstants.GROUP_BEHAVIOR="groupBehavior",t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL="withinCell",t.NBoxConstants.GROUP_BEHAVIOR_ACROSS_CELLS="acrossCells",t.NBoxConstants.OTHER_COLOR="otherColor",t.NBoxConstants.OTHER_THRESHOLD="otherThreshold",t.NBoxConstants.ANIMATION_ON_DATA_CHANGE="animationOnDataChange",t.NBoxConstants.ANIMATION_ON_DISPLAY="animationOnDisplay",t.NBoxConstants.ANIMATION_DURATION="animationDuration",t.NBoxConstants.DRAWER="_drawer",t.NBoxConstants.ID="id",t.NBoxConstants.LABEL="label",t.NBoxConstants.LABEL_STYLE="labelStyle",t.NBoxConstants.LABEL_HALIGN="labelHalign",t.NBoxConstants.SECONDARY_LABEL="secondaryLabel",t.NBoxConstants.SECONDARY_LABEL_STYLE="secondaryLabelStyle",t.NBoxConstants.SHORT_DESC="shortDesc",t.NBoxConstants.SHOW_COUNT="showCount",t.NBoxConstants.STYLE="style",t.NBoxConstants.STYLE_DEFAULTS="styleDefaults",t.NBoxConstants.BORDER_COLOR="borderColor",t.NBoxConstants.BORDER_RADIUS="borderRadius",t.NBoxConstants.BORDER_WIDTH="borderWidth",t.NBoxConstants.COLOR="color",t.NBoxConstants.PATTERN="pattern",t.NBoxConstants.OPACITY="opacity",t.NBoxConstants.SHAPE="shape",t.NBoxConstants.SOURCE="source",t.NBoxConstants.HEIGHT="height",t.NBoxConstants.WIDTH="width";var e=function(t){this.Init({alta:e.SKIN_ALTA},t)};t.Obj.createSubclass(e,t.BaseComponentDefaults),e.SKIN_ALTA={skin:t.CSSStyle.SKIN_ALTA,selectionMode:"multiple",animationOnDataChange:"none",animationOnDisplay:"none",cellMaximize:"on",cellContent:"auto",groupBehavior:"withinCell",otherColor:"#636363",otherThreshold:0,hoverBehavior:"none",highlightMatch:"all",highlightedCategories:[],touchResponse:"auto",_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA+"color: #252525;"),styleDefaults:{animationDuration:500,hoverBehaviorDelay:200,columnLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #252525;"),rowLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color: #252525;"),columnsTitleStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_14+"color: #252525;"),rowsTitleStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_14+"color: #252525;"),cellDefaults:{_style:new t.CSSStyle("background-color:#e9e9e9"),_maximizedStyle:new t.CSSStyle("background-color:#dddddd"),_minimizedStyle:new t.CSSStyle("background-color:#e9e9e9"),labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_14+"color: #252525;"),countLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_14+"color: #252525;"),bodyCountLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA+"color: #252525;"),dropTargetStyle:new t.CSSStyle("background-color:rgba(217, 244, 250, .75);border-color:#ccf6ff"),showCount:"auto",showMaximize:"on"},__scrollbar:{scrollbarBackground:"linear-gradient(bottom, #dce2e7 0%, #f8f8f8 8%)",scrollbarBorderColor:"#dce2e7",scrollbarHandleColor:"#abb0b4",scrollbarHandleHoverColor:"#333333",scrollbarHandleActiveColor:"#333333"},_drawerDefaults:{background:"#e9e9e9",borderColor:"#bcc7d2",borderRadius:1,headerBackground:"linear-gradient(to bottom, #f5f5f5 0%, #f0f0f0 100%)",labelStyle:new t.CSSStyle("color: #252525;"+t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_14),countLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_BOLD_14),countBorderRadius:1},nodeDefaults:{color:"#FFFFFF",labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12),secondaryLabelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_11),alphaFade:.2,borderRadius:1,hoverColor:"#FFFFFF",selectionColor:"#000000",iconDefaults:{preferredSize:19,preferredSizeTouch:34,shapePaddingRatio:.15,sourcePaddingRatio:0,opacity:1,pattern:"none",borderColor:"#000000",borderWidth:0,borderRadius:0,shape:t.SimpleMarker.CIRCLE},indicatorIconDefaults:{width:10,height:10,opacity:1,pattern:"none",borderColor:"#000000",borderWidth:0,borderRadius:0,shape:t.SimpleMarker.CIRCLE}},_categoryNodeDefaults:{labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA)}},__layout:{componentGap:8,titleGap:4,titleComponentGap:4,nodeLabelOnlyStartLabelGap:5,nodeStartLabelGap:3,nodeEndLabelGap:5,nodeSingleLabelGap:2,nodeDualLabelGap:2,nodeInterLabelGap:0,nodeIndicatorGap:3,nodeSwatchSize:10,categoryNodeLabelGap:5,minimumCellSize:34,cellGap:3,gridGap:6,cellStartGap:6,cellEndGap:6,cellTopGap:6,cellBottomGap:6,cellLabelGap:6,cellCloseGap:6,countLabelGap:10,markerGap:3,minimumLabelWidth:55,maximumLabelWidth:148,drawerButtonGap:6,drawerCountHorizontalGap:5,drawerCountVerticalGap:3,drawerStartGap:6,drawerLabelGap:6,drawerHeaderHeight:31}};var n=function(){};t.Obj.createSubclass(n,t.Container),n.newInstance=function(t,e){var o=new n;return o.Init(t,e),o},n.prototype.Init=function(e,o){var a=_.getRowIndex(e,o[t.NBoxConstants.ROW]),i=_.getColumnIndex(e,o[t.NBoxConstants.COLUMN]);n.superclass.Init.call(this,e.getCtx(),null,"c:"+a+","+i),this._nbox=e,this._data=o,this._data.__cacheId="cell:"+this.getId(),this._scrollContainer=!1},n.prototype.getData=function(){return this._data},n.prototype.render=function(t,e){t.addChild(this),_.setDisplayable(this._nbox,this._data,this),C.render(this._nbox,this._data,this,e),this._nbox.EventManager.associate(this,this)},n.prototype.getChildContainer=function(){return this._childContainer},n.prototype.setChildContainer=function(t){this._childContainer=t},n.prototype.animateUpdate=function(t,e){C.animateUpdate(t,e,this)},n.prototype.animateDelete=function(t,e){C.animateDelete(t,this)},n.prototype.animateInsert=function(t){C.animateInsert(t,this)},n.prototype.isDoubleClickable=function(){return _.isMaximizeEnabled(this._nbox)},n.prototype.handleDoubleClick=function(){if(this.isDoubleClickable()){var e,r=_.getMaximizedRow(this._nbox),s=_.getMaximizedColumn(this._nbox);_.fireOptionChangeEvent(this._nbox,t.NBoxConstants.DRAWER,null),r==this._data[t.NBoxConstants.ROW]&&s==this._data[t.NBoxConstants.COLUMN]?(_.fireOptionChangeEvent(this._nbox,t.NBoxConstants.MAXIMIZED_ROW,null),_.fireOptionChangeEvent(this._nbox,t.NBoxConstants.MAXIMIZED_COLUMN,null)):(_.fireOptionChangeEvent(this._nbox,t.NBoxConstants.MAXIMIZED_ROW,this._data[t.NBoxConstants.ROW]),_.fireOptionChangeEvent(this._nbox,t.NBoxConstants.MAXIMIZED_COLUMN,this._data[t.NBoxConstants.COLUMN]));var l=this._nbox.EventManager.getFocus();l?l instanceof o?e=this.getCellIndex()!=_.getCellIndex(this._nbox,l.getData()):l instanceof a?e=this!=l.getParentCell():l instanceof n?e=this.getCellIndex()!=l.getCellIndex():l instanceof i&&(e=this.getCellIndex()!=l.getData().cell):this._nbox.EventManager.setFocusObj(this),e&&(this._nbox.EventManager.setFocusObj(this),this._nbox.EventManager.setFocused(!1)),this._nbox.processEvent(t.EventFactory.newRenderEvent())}},n.prototype.contains=function(t,e){var n=_.getDisplayable(this._nbox,this._data,"background"),o=this.getTranslateX()+n.getX(),a=this.getTranslateY()+n.getY(),i=o+n.getWidth(),r=a+n.getHeight();return o<=t&&t<=i&&a<=e&&e<=r},n.prototype.renderDropSiteFeedback=function(){return C.renderDropSiteFeedback(this._nbox,this)},n.prototype.HandleKeyboardEvent=function(e){var n=_.getMaximizedRow(this._nbox),o=_.getMaximizedColumn(this._nbox),a=n==this._data[t.NBoxConstants.ROW]&&o==this._data[t.NBoxConstants.COLUMN];(!a&&e.keyCode==t.KeyboardEvent.ENTER||a&&e.keyCode==t.KeyboardEvent.ESCAPE)&&this.handleDoubleClick()},n.prototype.getAriaLabel=function(){var e=this.getCellIndex(),n=[],o=this._nbox.getOptions().translations;return _.isCellMaximized(this._nbox,e)?n.push(o.stateMaximized):_.isCellMinimized(this._nbox,e)&&n.push(o.stateMinimized),n.push([o.labelSize,this.getNodeCount()]),t.Displayable.generateAriaLabel(this.getData().shortDesc,n)},n.prototype.getKeyboardBoundingBox=function(t){return d.getKeyboardBoundingBox(this,t)},n.prototype.getTargetElem=function(){return this.getElem()},n.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,_.getDisplayable(this._nbox,this.getData(),"focusEffect").show()},n.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,_.getDisplayable(this._nbox,this.getData(),"focusEffect").hide()},n.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},n.prototype.getNextNavigable=function(e){var n=null;return this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e)&&(n=e.keyCode==t.KeyboardEvent.OPEN_BRACKET?this._getFirstNavigableChild(e):this._getNextSibling(e)),n},n.prototype._getNextSibling=function(e){for(var n=[],o=_.getRowCount(this._nbox)*_.getColumnCount(this._nbox),a=0;a<o;a++)n.push(_.getDisplayable(this._nbox,_.getCell(this._nbox,a)));return t.KeyboardHandler.getNextNavigable(this,e,n)},n.prototype._getFirstNavigableChild=function(e){var n=null,r=_.getMaximizedRow(this._nbox),s=_.getMaximizedColumn(this._nbox),l=_.getDrawer(this._nbox);if(l&&r==this.getData()[t.NBoxConstants.ROW]&&s==this.getData()[t.NBoxConstants.COLUMN])n=_.getDisplayable(this._nbox,l);else{var g=this.getChildContainer();if(g.getScrollingPane&&(g=g.getScrollingPane()),g.getNumChildren()>0&&(g.getChildAt(0)instanceof o||g.getChildAt(0)instanceof a))n=_.getFirstNavigableNode(this._nbox,g);else{for(var u=[],h=0;h<g.getNumChildren();h++){var C=g.getChildAt(h);C instanceof i&&u.push(C)}n=d.getNextNavigableCategoryNode(null,e,u)}}return n},n.prototype.getCellIndex=function(){return _.getCellIndexByRowColumn(this._nbox,this.getData()[t.NBoxConstants.ROW],this.getData()[t.NBoxConstants.COLUMN])},n.prototype.getLabel=function(){var e=this.getData()[t.NBoxConstants.LABEL];return e||null},n.prototype.getCountLabel=function(){var t=this.getData(),e=this._nbox.getOptions().countLabel;return e?e({row:t.row,column:t.column,nodeCount:this.getNodeCount(),highlightedNodeCount:this.getHighlightedNodeCount(),totalNodeCount:_.getNodeCount(this._nbox)}):t.countLabel},n.prototype.getBackground=function(){var e=N.getCellStyle(this._nbox,this.getCellIndex()),n=e.getStyle(t.CSSStyle.BACKGROUND),o=e.getStyle(t.CSSStyle.BACKGROUND_COLOR);return n||o},n.prototype.hasOverflowIndicator=function(){var t=this._nbox.getOptions();if(t&&t.__layout&&t.__layout.__nodeLayout&&t.__layout.__nodeLayout.cellLayouts){var e=this.getCellIndex(),n=t.__layout.__nodeLayout.cellLayouts[e];if(n)return n.overflow}return!1},n.prototype.getNodeCount=function(){return h.getCellCounts(this._nbox).total[this.getCellIndex()]},n.prototype.getHighlightedNodeCount=function(){var t=h.getCellCounts(this._nbox);return t.highlighted?t.highlighted[this.getCellIndex()]:null},n.prototype.getNode=function(e){var n=this._nbox.getOptions()[t.NBoxConstants.NODES];if(n)for(var o=0,a=0;a<n.length;a++)if(this.getData()[t.NBoxConstants.ROW]==n[a][t.NBoxConstants.ROW]&&this.getData()[t.NBoxConstants.COLUMN]==n[a][t.NBoxConstants.COLUMN]&&!_.isNodeHidden(this._nbox,n[a])){if(e==o)return n[a];o++}return null},n.prototype.getDisplayable=function(){return this},n.prototype.getKeyboardFocusDisplayable=function(){return _.getGroupBehavior(this._nbox)==t.NBoxConstants.GROUP_BEHAVIOR_ACROSS_CELLS&&this._nbox.getOptions().__groups?null:_.getDisplayable(this._nbox,_.getCell(this._nbox,_.getCellIndex(this._nbox,this.getData())))};var o=function(t,e){this.Init(t,e)};t.Obj.createSubclass(o,t.Container),o.prototype.Init=function(e,n){o.superclass.Init.call(this,e.getCtx(),null,n[t.NBoxConstants.ID]),this._nbox=e,this._data=n,this._nbox.registerObject(this);var a=this._nbox.getOptions()[t.NBoxConstants.SELECTION_MODE];"single"!=a&&"multiple"!=a||this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._maxAlpha=1},o.prototype.getData=function(){return this._data},o.prototype.render=function(t,e){c.render(this._nbox,this._data,this,e),t.addChild(this),_.setDisplayable(this._nbox,this._data,this),this._nbox.EventManager.associate(this,this)},o.prototype.isSelectable=function(){return!0},o.prototype.isSelected=function(){return this.getSelectionShape().isSelected()},o.prototype.setSelected=function(t){this.getSelectionShape().setSelected(t),this.UpdateAccessibilityAttributes()},o.prototype.showHoverEffect=function(){this.getSelectionShape().showHoverEffect()},o.prototype.hideHoverEffect=function(){this.getSelectionShape().hideHoverEffect()},o.prototype.setSelectionShape=function(t){this._selectionShape=t},o.prototype.getSelectionShape=function(){return this._selectionShape},o.prototype.getDatatip=function(t,e,n){var o=this._nbox.getOptions().tooltip,a=o?o.renderer:null;if(a){var i={id:this._data.id,label:this._data.label,secondaryLabel:this._data.secondaryLabel,row:this._data.row,column:this._data.column,color:N.getNodeColor(this._nbox,this._data),indicatorColor:N.getNodeIndicatorColor(this._nbox,this._data)};return this._nbox.getCtx().getTooltipManager().getCustomTooltip(a,i)}return this.getShortDesc()},o.prototype.getShortDesc=function(){return this._data[t.NBoxConstants.SHORT_DESC]},o.prototype.getDatatipColor=function(){return N.getNodeColor(this._nbox,this._data)},o.prototype.setMaxAlpha=function(t){this._maxAlpha=t,this.setAlpha(this.getAlpha())},o.prototype.getMaxAlpha=function(){return this._maxAlpha},o.prototype.setAlpha=function(t){o.superclass.setAlpha.call(this,Math.min(t,this._maxAlpha))},o.prototype.animateUpdate=function(t,e){c.animateUpdate(t,e,this)},o.prototype.animateDelete=function(t,e){c.animateDelete(t,this)},o.prototype.animateInsert=function(t){c.animateInsert(t,this)},o.prototype.isDoubleClickable=function(){return!0},o.prototype.handleDoubleClick=function(){this._getParentContainer().handleDoubleClick()},o.prototype.isDragAvailable=function(t){return this._nbox.__isDragAvailable(t)},o.prototype.getDragTransferable=function(t,e){return this._nbox.__getDragTransferable(this)},o.prototype.getDragFeedback=function(t,e){return this._nbox.__getDragFeedback()},o.prototype._getParentContainer=function(){var t,e=_.getDrawer(this._nbox);if(e)t=_.getDisplayable(this._nbox,e);else{var n=_.getCellIndex(this._nbox,this._data),o=_.getCell(this._nbox,n);t=_.getDisplayable(this._nbox,o)}return t},o.prototype.UpdateAccessibilityAttributes=function(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty(t.NBoxConstants.LABEL,e)}},o.prototype.getAriaLabel=function(){return _.buildAriaDesc(this._nbox,this,this.getShortDesc(),this.isSelected())},o.prototype.getCategories=function(){return this.getData()[t.NBoxConstants.CATEGORIES]?this.getData()[t.NBoxConstants.CATEGORIES]:[]},o.prototype.getKeyboardBoundingBox=function(t){return d.getKeyboardBoundingBox(this,t)},o.prototype.getTargetElem=function(){return this.getElem()},o.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect();var t=_.getNodeScrollableContainer(this._nbox,this);t&&t.scrollIntoView(this)},o.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()},o.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},o.prototype.getNextNavigable=function(e){var n=null;return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey?this:(this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e)?n=e.keyCode==t.KeyboardEvent.CLOSE_BRACKET?this._getParentContainer():e.keyCode==t.KeyboardEvent.OPEN_BRACKET?this:_.getNextNavigableNode(this._nbox,this,e):e.type==t.MouseEvent.CLICK&&(n=this),n)},o.prototype.HandleKeyboardEvent=function(e){if(_.getDrawer(this._nbox)&&e.keyCode==t.KeyboardEvent.ESCAPE)this.handleDoubleClick();else{var n=_.getMaximizedRow(this._nbox),o=_.getMaximizedColumn(this._nbox),a=n==this._data[t.NBoxConstants.ROW]&&o==this._data[t.NBoxConstants.COLUMN];(!a&&e.keyCode==t.KeyboardEvent.ENTER||a&&e.keyCode==t.KeyboardEvent.ESCAPE)&&this.handleDoubleClick()}},o.prototype.getDisplayable=function(){return this},o.prototype.getKeyboardFocusDisplayable=function(){var e=_.getNode(this._nbox,_.getNodeIndex(this._nbox,this.getData()[t.NBoxConstants.ID]));if(e){var n=_.getDisplayable(this._nbox,e);if(n)return n;var o=_.getCell(this._nbox,_.getCellIndex(this._nbox,e)),i=_.getDisplayable(this._nbox,o),r=_.getLastNavigableNode(this._nbox,i.getChildContainer());if(r instanceof a)return r;var s=this._getParentDrawer();return s?s.getKeyboardFocusDisplayable():i.getKeyboardFocusDisplayable()}return null},o.prototype._getParentDrawer=function(){for(var t=this;t&&t.getParent;)if((t=t.getParent())instanceof s)return t;return null},o.prototype.getChildContainer=function(e){return!e||this._childContainer?this._childContainer:(this._childContainer=new t.Container(this.getCtx()),this.addChild(this._childContainer),this._childContainer)},o.prototype.setChildContainer=function(t){this._childContainer=t};var a=function(){};t.Obj.createSubclass(a,t.Container),a.newInstance=function(t,e){var n=new a;return n.Init(t,e),n},a.prototype.Init=function(t,e){a.superclass.Init.call(this,t.getCtx()),this._nbox=t,this._cell=e,this._button},a.prototype.render=function(e,n,o){var a=this._nbox.getOptions(),i=a._resources.overflow_ena.width,r=a._resources.overflow_ena.height,s=1;(n<i||o<r)&&(s=Math.min(n/i,o/r));var l=(n-(i*=s))/2,g=(o-(r*=s))/2,d=this._nbox.getCtx(),u=new t.Rect(d,0,0,n,o),h=new t.Rect(d,0,0,n,o),C=new t.Rect(d,0,0,n,o),c=new t.Rect(d,0,0,n,o);u.setInvisibleFill(),h.setInvisibleFill(),C.setInvisibleFill(),c.setInvisibleFill();var x=new t.Container(d),p=new t.Container(d),N=new t.Container(d),f=new t.Container(d);x.addChild(u),p.addChild(h),N.addChild(C),f.addChild(c),x.addChild(new t.Image(d,a._resources.overflow_ena.src,l,g,i,r)),p.addChild(new t.Image(d,a._resources.overflow_ovr.src,l,g,i,r)),N.addChild(new t.Image(d,a._resources.overflow_dwn.src,l,g,i,r)),f.addChild(new t.Image(d,a._resources.overflow_dis.src,l,g,i,r)),this._button=new t.Button(d,x,p,N,f,null,this.HandleClick,this),_.isMaximizeEnabled(this._nbox)||(this._button.setEnabled(!1),this._button.drawDisabledState()),this.addChild(this._button);var b=new t.KeyboardFocusEffect(this._nbox.getCtx(),this,new t.Rectangle(-1,-1,n+2,o+2));_.setDisplayable(this._nbox,this,b,"focusEffect"),e.addChild(this),this._addAccessibilityAttributes(),this._nbox.EventManager.associate(this,this)},a.prototype.getParentCell=function(){return this._cell},a.prototype.getButton=function(){return this._button},a.prototype.HandleClick=function(e){t.EventManager.consumeEvent(e),this._cell.handleDoubleClick(!0)},a.prototype.HandleKeyboardEvent=function(e){e.keyCode==t.KeyboardEvent.ENTER&&this._cell.handleDoubleClick()},a.prototype._addAccessibilityAttributes=function(){if(this.setAriaRole("button"),!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty(t.NBoxConstants.LABEL,e)}},a.prototype.getDatatip=function(t,e,n){return this._nbox.getOptions().translations.labelAdditionalData},a.prototype.getAriaLabel=function(){return this.getDatatip()},a.prototype.getKeyboardBoundingBox=function(t){return d.getKeyboardBoundingBox(this,t)},a.prototype.getTargetElem=function(){return this.getElem()},a.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,_.getDisplayable(this._nbox,this,"focusEffect").show()},a.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,_.getDisplayable(this._nbox,this,"focusEffect").hide()},a.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},a.prototype.getNextNavigable=function(e){var n=null;return this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e)&&(n=e.keyCode==t.KeyboardEvent.CLOSE_BRACKET?this.getParentCell():_.getNextNavigableNode(this._nbox,this,e)),n},a.prototype.getDisplayable=function(){return this},a.prototype.getKeyboardFocusDisplayable=function(){var e=this.previousNavigable.getData(),n=_.getNode(this._nbox,_.getNodeIndex(this._nbox,e[t.NBoxConstants.ID]));return _.getDisplayable(this._nbox,n).nextNavigable};var i=function(){};t.Obj.createSubclass(i,t.Container),i.newInstance=function(t,e){var n=new i;return n.Init(t,e),n},i.prototype.Init=function(e,n){i.superclass.Init.call(this,e.getCtx(),null,isNaN(n[t.NBoxConstants.CELL])?n[t.NBoxConstants.ID]:n[t.NBoxConstants.CELL]+":"+n[t.NBoxConstants.ID]),this._nbox=e,this._data=n,this._data.__cacheId="categoryNode:"+this.getId(),this._nbox.registerObject(this),this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._maxAlpha=1},i.prototype.getData=function(){return this._data},i.prototype.render=function(t,e,n){x.render(this._nbox,this._data,this,e,n),t.addChild(this),_.setDisplayable(this._nbox,this._data,this),this._nbox.EventManager.associate(this,this)},i.prototype.isSelectable=function(){return"multiple"==this._nbox.getOptions()[t.NBoxConstants.SELECTION_MODE]},i.prototype.isSelected=function(){return this.getSelectionShape().isSelected()},i.prototype.setSelected=function(t){this.getSelectionShape().setSelected(t),this.UpdateAccessibilityAttributes()},i.prototype.showHoverEffect=function(){this.getSelectionShape().showHoverEffect()},i.prototype.hideHoverEffect=function(){this.getSelectionShape().hideHoverEffect()},i.prototype.setSelectionShape=function(t){this._selectionShape=t},i.prototype.getSelectionShape=function(){return this._selectionShape},i.prototype.getLabel=function(){return _.getCategoryNodeLabels(this._nbox,this._data).join(", ")},i.prototype.getDatatip=function(e,n,o){var a=this._nbox.getOptions().tooltip,i=a?a.renderer:null;if(i){var r={id:this._data.id,color:N.getCategoryNodeColor(this._nbox,this._data),indicatorColor:N.getCategoryNodeIndicatorColor(this._nbox,this._data),size:this._data.nodeIndices.length};return"withinCell"==_.getGroupBehavior(this._nbox)&&(r.row=_.getCell(this._nbox,this._data.cell).row,r.column=_.getCell(this._nbox,this._data.cell).column),this._nbox.getCtx().getTooltipManager().getCustomTooltip(i,r)}var s=this._nbox.getOptions().translations;return this.getShortDesc()+"\n"+t.ResourceUtils.format(s.labelAndValue,[s.labelSize,this._data.nodeIndices.length])},i.prototype.getShortDesc=function(){return _.getCategoryNodeLabels(this._nbox,this._data).join("\n")},i.prototype.getDatatipColor=function(){return N.getCategoryNodeColor(this._nbox,this._data)},i.prototype.setMaxAlpha=function(t){this._maxAlpha=t,this.setAlpha(this.getAlpha())},i.prototype.getMaxAlpha=function(){return this._maxAlpha},i.prototype.setAlpha=function(t){i.superclass.setAlpha.call(this,Math.min(t,this._maxAlpha))},i.prototype.isDoubleClickable=function(){return this.isSelectable()},i.prototype.handleDoubleClick=function(){this.isSelectable()&&this.openDrawer()},i.prototype.openDrawer=function(){_.fireOptionChangeEvent(this._nbox,t.NBoxConstants.DRAWER,{id:this.getId()}),this._nbox.processEvent(t.EventFactory.newRenderEvent())},i.prototype.animateUpdate=function(t,e){x.animateUpdate(t,e,this)},i.prototype.animateDelete=function(t,e){x.animateDelete(t,this)},i.prototype.animateInsert=function(t){x.animateInsert(t,this)},i.prototype.isDragAvailable=function(t){return this._nbox.__isDragAvailable(t)},i.prototype.getDragTransferable=function(t,e){return this._nbox.__getDragTransferable(this)},i.prototype.getDragFeedback=function(t,e){return this._nbox.__getDragFeedback()},i.prototype.HandleKeyboardEvent=function(e){if(e.keyCode==t.KeyboardEvent.ENTER)this.openDrawer();else if(e.keyCode==t.KeyboardEvent.ESCAPE&&_.getGroupBehavior(this._nbox)==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){var n=_.getCell(this._nbox,this._data.cell);_.getDisplayable(this._nbox,n).HandleKeyboardEvent(e)}},i.prototype.UpdateAccessibilityAttributes=function(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty(t.NBoxConstants.LABEL,e)}},i.prototype.getAriaLabel=function(){return _.buildAriaDesc(this._nbox,this,this.getShortDesc(),this.isSelected())},i.prototype.getCategories=function(){var e=this.getData()[t.NBoxConstants.CATEGORIES];if(!e){var n=function(t,e){return t.filter(function(t){return e.indexOf(t)>-1})},o=this.getData().nodeIndices;e=null;for(var a=0;a<o.length;a++){var i=_.getNode(this._nbox,o[a])[t.NBoxConstants.CATEGORIES];if(!i){e=[];break}e=null==e?i:n(e,i)}this.getData()[t.NBoxConstants.CATEGORIES]=e}return e},i.compareSize=function(t,e){var n=t.nodeIndices.length,o=e.nodeIndices.length;return n==o?0:n<o?1:-1},i.prototype.getKeyboardBoundingBox=function(t){return d.getKeyboardBoundingBox(this,t)},i.prototype.getTargetElem=function(){return this.getElem()},i.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect()},i.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()},i.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},i.prototype.getNextNavigable=function(e){var n=null;if(e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;if(e.keyCode==t.KeyboardEvent.CLOSE_BRACKET&&_.getGroupBehavior(this._nbox)==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){var o=_.getCell(this._nbox,this.getData()[t.NBoxConstants.CELL]);n=_.getDisplayable(this._nbox,o)}else if(e.keyCode==t.KeyboardEvent.CLOSE_BRACKET||e.keyCode==t.KeyboardEvent.OPEN_BRACKET)n=this;else if(this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e))if(_.getGroupBehavior(this._nbox)==t.NBoxConstants.GROUP_BEHAVIOR_ACROSS_CELLS){var a=this._nbox.getOptions().__groups,r=[];for(var s in a){var l=_.getDisplayable(this._nbox,a[s]);l&&r.push(l)}n=d.getNextNavigableCategoryNode(this,e,r)}else{for(var g=this.getParent(),u=[],h=0;h<g.getNumChildren();h++)g.getChildAt(h)instanceof i&&u.push(g.getChildAt(h));n=d.getNextNavigableCategoryNode(this,e,u)}else e.type==t.MouseEvent.CLICK&&(n=this);return n},i.prototype.getDisplayable=function(){return this},i.prototype.getKeyboardFocusDisplayable=function(){var t=_.getDrawer(this._nbox);if(t)return _.getDisplayable(this._nbox,t);if(_.getGrouping(this._nbox)){var e=_.getCategoryNode(this._nbox,this.getId());if(e)return _.getDisplayable(this._nbox,e)}return null};var r=function(t,e){r.superclass.constructor.call(this,t,e),this._nbox=e};t.Obj.createSubclass(r,t.CategoryRolloverHandler),r.prototype.GetRolloverCallback=function(t,e,n,o){return function(){this.SetHighlightMode(!0),this._nbox.processEvent(t),this._callback&&this._callback.call(this._callbackObj,t,this._source)}.bind(this)},r.prototype.GetRolloutCallback=function(t,e,n,o){return function(){this.SetHighlightModeTimeout(),this._nbox.processEvent(t),this._callback&&this._callback.call(this._callbackObj,t,this._source)}.bind(this)};var s=function(){};t.Obj.createSubclass(s,t.Container),s.newInstance=function(t,e){var n=new s;return n.Init(t,e),n},s.prototype.Init=function(t,e){s.superclass.Init.call(this,t.getCtx(),null,e.id+"_d"),this._nbox=t,this._data=e,this._data.__cacheId="drawer:"+this.getId(),this._nbox.registerObject(this)},s.prototype.getData=function(){return this._data},s.prototype.render=function(t,e){t.addChild(this),_.setDisplayable(this._nbox,this._data,this),p.render(this._nbox,this._data,this,e),this._nbox.EventManager.associate(this,this)},s.prototype.getChildContainer=function(){return this._childContainer},s.prototype.setChildContainer=function(t){this._childContainer=t},s.prototype.isDoubleClickable=function(){return!0},s.prototype.handleDoubleClick=function(){this.closeDrawer()},s.prototype.closeDrawer=function(){_.fireOptionChangeEvent(this._nbox,t.NBoxConstants.DRAWER,null),this._nbox.processEvent(t.EventFactory.newRenderEvent())},s.prototype.animateUpdate=function(t,e){p.animateUpdate(t,e,this)},s.prototype.animateDelete=function(t,e){p.animateDelete(t,this)},s.prototype.animateInsert=function(t){p.animateInsert(t,this)},s.prototype.HandleKeyboardEvent=function(e){e.keyCode==t.KeyboardEvent.ESCAPE&&this.closeDrawer()},s.prototype.UpdateAccessibilityAttributes=function(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();if(e)(t.Agent.isTouchDevice()?_.getDisplayable(this._nbox,this.getData(),"background"):this).setAriaProperty("label",e)}},s.prototype.getAriaLabel=function(){var t=_.getDisplayable(this._nbox,_.getCategoryNode(this._nbox,this.getData().id)),e=_.isDrawerSelected(this._nbox,t);return _.buildAriaDesc(this._nbox,this,t.getShortDesc(),e)},s.prototype.getKeyboardBoundingBox=function(t){return d.getKeyboardBoundingBox(this,t)},s.prototype.getTargetElem=function(){return this.getElem()},s.prototype.showKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!0,_.getDisplayable(this._nbox,this.getData(),"focusEffect").show()},s.prototype.hideKeyboardFocusEffect=function(){this._isShowingKeyboardFocusEffect=!1,_.getDisplayable(this._nbox,this.getData(),"focusEffect").hide()},s.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},s.prototype.getNextNavigable=function(e){var n=null;if(this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e))if(e.keyCode==t.KeyboardEvent.OPEN_BRACKET){var o=this.getChildContainer();o.getScrollingPane&&(o=o.getScrollingPane());n=_.getFirstNavigableNode(this._nbox,o)}else if(e.keyCode==t.KeyboardEvent.CLOSE_BRACKET){var a=_.getMaximizedCellIndex(this._nbox);n=_.getDisplayable(this._nbox,_.getCell(this._nbox,a))}return n},s.prototype.getDisplayable=function(){return this},s.prototype.getKeyboardFocusDisplayable=function(){if(this._nbox.getOptions()._drawer)return this;var e=_.getCategoryNode(this._nbox,this.getData()[t.NBoxConstants.ID]);return e?_.getDisplayable(this._nbox,e):null};var l=function(t,e,n,o){this.Init(t,e,n,o)};t.Obj.createSubclass(l,t.DataAnimationHandler),l.DELETE=0,l.UPDATE=1,l.INSERT=2,l.prototype.Init=function(t,e,n,o){l.superclass.Init.call(this,t,e),this._oldNBox=n,this._newNBox=o},l.prototype.getOldNBox=function(){return this._oldNBox},l.prototype.getNewNBox=function(){return this._newNBox},l.prototype.getAnimationDuration=function(){return N.getAnimationDuration(this._oldNBox)};var g=function(t){this.Init(t.getCtx(),t.processEvent,t,t),this._nbox=t};t.Obj.createSubclass(g,t.EventManager),g.prototype.OnClickInternal=function(t){var e=this.GetLogicalObject(t.target);e instanceof i&&!e.isSelectable()&&e.openDrawer()},g.prototype.OnDblClickInternal=function(t){this._handleDblClick(t.target)},g.prototype.HandleTouchDblClickInternal=function(t){this._handleDblClick(t.target)},g.prototype.HandleTouchClickInternal=function(t){var e=this.GetLogicalObject(t.target);e instanceof i&&!e.isSelectable()&&e.openDrawer()},g.prototype._handleDblClick=function(t){var e=this.GetLogicalObject(t);e&&e.isDoubleClickable&&e.isDoubleClickable()&&e.handleDoubleClick&&e.handleDoubleClick()},g.prototype.ProcessKeyboardEvent=function(e){var n=!1,a=e.keyCode,r=this.getFocus();return a==t.KeyboardEvent.ENTER||a==t.KeyboardEvent.ESCAPE?(r&&r.HandleKeyboardEvent&&r.HandleKeyboardEvent(e),r=null):e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey?(r instanceof i||r instanceof o)&&(n=g.superclass.ProcessKeyboardEvent.call(this,e)):n=g.superclass.ProcessKeyboardEvent.call(this,e),n},g.prototype.ProcessRolloverEvent=function(e,n,o){var a=this._nbox.getOptions();if("dim"==a.hoverBehavior){var i=n.getCategories?n.getCategories():[];a.highlightedCategories=o?i.slice():null;var r=t.EventFactory.newCategoryHighlightEvent(a.highlightedCategories,o),s=t.CSSStyle.getTimeMilliseconds(a.styleDefaults.hoverBehaviorDelay);this.RolloverHandler.processEvent(r,this._nbox.getNodeDisplayables(),s,"any"==a.highlightMatch)}},g.prototype.CreateCategoryRolloverHandler=function(t,e){return new r(t,e)},g.prototype.GetTouchResponse=function(){var e=this._nbox.getOptions(),n=_.getDrawer(this._nbox),o=_.getCell(this._nbox,_.getMaximizedCellIndex(this._nbox));return n&&_.getDisplayable(this._nbox,n).getChildContainer().hasScrollingContent()||o&&_.getDisplayable(this._nbox,o).getChildContainer().hasScrollingContent()?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:e.touchResponse===t.EventManager.TOUCH_RESPONSE_TOUCH_START?t.EventManager.TOUCH_RESPONSE_TOUCH_START:t.EventManager.TOUCH_RESPONSE_AUTO};var d=function(t,e){this.Init(t,e)};t.Obj.createSubclass(d,t.KeyboardHandler),d.prototype.Init=function(t,e){d.superclass.Init.call(this,t),this._nbox=e},d.prototype.processKeyDown=function(e){if(e.keyCode==t.KeyboardEvent.TAB){var n=this._eventManager.getFocus(),o=null;if(t.EventManager.consumeEvent(e),n)o=n;else{var a=_.getDrawer(this._nbox);if(a)o=_.getDisplayable(this._nbox,a);else if(_.getGroupBehavior(this._nbox)==t.NBoxConstants.GROUP_BEHAVIOR_ACROSS_CELLS){var i=this._nbox.getOptions().__groups;if(i){var r=[];for(var s in i){var l=_.getDisplayable(this._nbox,i[s]);l&&r.push(l)}o=d.getNextNavigableCategoryNode(null,e,r)}}if(!o){var g=_.getColumnCount(this._nbox)*(_.getRowCount(this._nbox)-1);o=_.getDisplayable(this._nbox,_.getCell(this._nbox,g))}}return o}return d.superclass.processKeyDown.call(this,e)},d.prototype.isSelectionEvent=function(e){return e.keyCode!=t.KeyboardEvent.TAB&&(this.isNavigationEvent(e)&&!e.ctrlKey)},d.prototype.isMultiSelectEvent=function(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey},d.getKeyboardBoundingBox=function(e,n){var o=e.getDimensions(),a=e.localToStage(new t.Point(o.x,o.y)),i=e.localToStage(new t.Point(o.x+o.w,o.y+o.h));return new t.Rectangle(a.x,a.y,i.x-a.x,i.y-a.y)},d.prototype.isNavigationEvent=function(e){var n=!1;switch(e.keyCode){case t.KeyboardEvent.OPEN_BRACKET:case t.KeyboardEvent.CLOSE_BRACKET:n=!0;break;default:n=d.superclass.isNavigationEvent.call(this,e)}return n},d.getNextNavigableCategoryNode=function(e,n,o){if(!o||o.length<=0)return null;if(o[0]instanceof i&&o.sort(function(t,e){return i.compareSize(t.getData(),e.getData())}),null==e)return o[0];for(var a=e,r=n.keyCode==t.KeyboardEvent.RIGHT_ARROW||n.keyCode==t.KeyboardEvent.DOWN_ARROW,s=o.length,l=0;l<s;l++){if(o[l]===e){a=o[r?l+1<s?l+1:l:l-1>=0?l-1:l];break}}return a};var u=function(t){this.Init(t)};t.Obj.createSubclass(u,t.Automation),u.prototype.Init=function(t){this._nBox=t},u.prototype.GetSubIdForDomElement=function(e){for(var r=this._getParentObject(e,n),l=this._getParentObject(e,s);e&&!(e instanceof t.NBox);){var g,d,u=this.getComponent();if(e instanceof o){var h=_.getNodeIndex(u,e.getData().id);return g="node"+this._createBrackets([h]),this._createSubId(g,d)}if(r){var C=r.getData().row,c=r.getData().column,x=r.getChildContainer();if(x.getScrollingPane&&(x=x.getScrollingPane()),g="cell"+this._createBrackets([C,c]),e instanceof n)return this._createSubId(g,d);if(e instanceof t.Button){if(this._getParentObject(e,a))return d="overflow",this._createSubId(g,d);if(e==_.getDisplayable(u,r.getData(),"closeButton"))return d="closeButton",this._createSubId(g,d)}if(e instanceof i){var p=e.getData().id;return d="groupNode",_.getNode(u,e.getData().nodeIndices[0]).groupCategory?d+=this._createBrackets([p]):d+=this._createBraces(p.split(";")),this._createSubId(g,d)}}if(l){if(g="dialog",e instanceof s)return this._createSubId(g,d);if(e instanceof t.Button)return d="closeButton",this._createSubId(g,d)}if(e instanceof i){p=e.getData().id;return g="groupNode",_.getNode(u,e.getData().nodeIndices[0]).groupCategory?g+=this._createBrackets([p]):g+=this._createBraces(p.split(";")),this._createSubId(g,d)}e=e.getParent()}return null},u.prototype._createSubId=function(t,e){var n=t;return e&&(n+="#"+e),n},u.prototype.getDomElementForSubId=function(e){var n=this.getComponent();if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(n);var r=this._parseSubId(e),l=r.component,g=r.action,d=null,u=null,h=null;if(0===l.lastIndexOf("node",0)){d=this._parseBrackets(l,!0);var C=_.getNode(n,d[0]);h=_.getDisplayable(n,C)}if(0===l.lastIndexOf("cell",0)){d=this._parseBrackets(l);var c=this._getCellIndexFromValues(d);if(!(C=_.getCell(n,c)))return null;var x=_.getDisplayable(n,C);if(g){if((u=x.getChildContainer()).getScrollingPane&&(u=u.getScrollingPane()),"overflow"==g)for(var p=u.getNumChildren();p>0;p--)if(u.getChildAt(p-1)instanceof a){h=u.getChildAt(p-1).getButton();break}if("closeButton"==g&&(h=_.getDisplayable(n,x.getData(),"closeButton")),0===g.lastIndexOf("node",0)){if((E=(d=this._parseBrackets(g,!0))[0])<0)return null;for(var N=_.getFirstNavigableNode(n,u),f=0;N instanceof o;){if(f==E){h=N;break}N=N.nextNavigable,f++}}if(0===g.lastIndexOf("groupNode",0)){g.indexOf("{")>-1?d=this._parseBraces(g):b=g.substring(g.indexOf("[")+1,g.indexOf("]"));for(p=0;p<u.getNumChildren();p++)if((N=u.getChildAt(p))instanceof i){if(y=N.getData().id,d&&this._compareCategories(d,y.split(";"))){h=N;break}if(b&&b==y){h=N;break}}}}else h=x}else if(0===l.lastIndexOf("groupNode",0)){var b,y;u=n.getChildContainer(),l.indexOf("{")>-1?d=this._parseBraces(l):b=l.substring(l.indexOf("[")+1,l.indexOf("]"));for(p=0;p<u.getNumChildren();p++)if((N=u.getChildAt(p))instanceof i){if(y=N.getData().id,d&&this._compareCategories(d,y.split(";"))){h=N;break}if(b&&b==y){h=N;break}}}else if("dialog"===l&&(u=n.getChildContainer()))for(p=0;p<u.getNumChildren();p++)if(u.getChildAt(p)instanceof s){var S=u.getChildAt(p);if(g){if("closeButton"==g)for(var B=0;B<S.getNumChildren();B++)S.getChildAt(B)instanceof t.Button&&(h=S.getChildAt(B));if(0===g.lastIndexOf("node",0)){var E,v=S.getChildContainer().getScrollingPane();if((E=(d=this._parseBrackets(g,!0))[0])<0)return null;for(N=_.getFirstNavigableNode(n,v),f=0;N instanceof o;){if(f==E){h=N;break}N=N.nextNavigable,f++}}}else h=S;break}return h?h.getElem():null},u.prototype._parseSubId=function(t){var e=null,n=null,o=t.indexOf("#");return-1!==o?(e=t.substring(0,o),n=t.substring(o+1)):e=t,{component:e,action:n}},u.prototype.getComponent=function(){return this._nBox},u.prototype._parseBrackets=function(t,e){var n=t.substring(t.indexOf("[")+1,t.indexOf("]")).split(",");if(e)for(var o=0;o<n.length;o++)n[o]=parseInt(n[o]);return n.length>0?n:null},u.prototype._createBrackets=function(t){return t.length>0?"["+t.join(",")+"]":""},u.prototype._parseBraces=function(t){return t.substring(t.indexOf("{")+1,t.lastIndexOf("}")).split(",")},u.prototype._createBraces=function(t){for(var e="{",n=0;n<t.length;n++)e+=t[n].trim()+",";return e.substring(0,e.length-1)+"}"},u.prototype._compareCategories=function(t,e){if(t.length!=e.length)return!1;t.sort(),e.sort();for(var n=0;n<t.length;n++)if(t[n].trim()!=e[n].trim())return!1;return!0},u.prototype._getCellIndexFromValues=function(t){var e=this.getComponent();if(_.hasValidData(e)){var n=_.getColumnCount(e),o=_.getRowIndex(e,t[0]),a=_.getColumnIndex(e,t[1]);if(null!=a&&null!=o)return a+n*o}return null},u.prototype._getParentObject=function(t,e){for(var n=t;n;){if(n instanceof e)return n;n=n.getParent()}return null},u.prototype.getData=function(t,e){if(this._nBox&&_.hasValidData(this._nBox))if("rowsTitle"==t){if(this._nBox.getOptions().rowsTitle)return this._nBox.getOptions().rowsTitle}else if("rowCount"==t){var n=this._nBox.getOptions().rows;if(n)return n.length}else if("row"==t){if(_.getRowIndex(this._nBox,e)>=0)return(a={}).label=_.getRowLabel(this._nBox,e),a}else if("columnsTitle"==t){if(this._nBox.getOptions().columnsTitle)return this._nBox.getOptions().columnsTitle}else if("columnCount"==t){var o=this._nBox.getOptions().columns;if(o)return o.length}else if("column"==t){var a;if(_.getColumnIndex(this._nBox,e)>=0)return(a={}).label=_.getColumnLabel(this._nBox,e),a}else if("groupBehavior"==t)return _.getGroupBehavior(this._nBox);return null},u.prototype.getGroupNode=function(e){if(e&&_.getGrouping(this._nBox)&&_.getGroupBehavior(this._nBox)==t.NBoxConstants.GROUP_BEHAVIOR_ACROSS_CELLS){if("string"==typeof e)return this._getGroupNodeData(e);var n="";for(var o in e)e[o]?n+=o+":"+e[o]+";":n+=o+";";return this._getGroupNodeData(n.substring(0,n.length-1))}return null},u.prototype._getGroupNodeData=function(t){var e=_.getCategoryNode(this._nBox,t);if(e){var n=_.getDisplayable(this._nBox,e);if(n){var o={};o.selected=n.isSelected(),o.color=N.getCategoryNodeColor(this._nBox,e),o.indicatorColor=N.getCategoryNodeIndicatorColor(this._nBox,e),o.tooltip=n.getShortDesc(),o.size=e.nodeIndices?e.nodeIndices.length:-1;var a=_.getDisplayable(this._nBox,e,"indicatorIcon");return o.indicatorIcon=this._getMarkerData(a),o}}return null},u.prototype.getCell=function(t,e){if(this._nBox&&_.hasValidData(this._nBox)){var n=_.getCellByRowColumn(this._nBox,t,e);if(n){var o=n.getCellIndex(),a={};return a.label=n.getLabel(),a.background=n.getBackground(),a.getNodeCount=function(){return n.getNodeCount()},a.rowValue=t,a.columnValue=e,a.cellIndex=o,a}}return null},u.prototype.getCellNode=function(t,e){if(this._nBox&&_.hasValidData(this._nBox)&&!_.getGrouping(this._nBox)){var n=_.getCellByRowColumn(this._nBox,t.rowValue,t.columnValue).getNode(e);return this._getNode(n)}return null},u.prototype.getNode=function(t){var e=_.getNode(this._nBox,t);return this._getNode(e)},u.prototype._getNode=function(t){if(t){var e=_.getDisplayable(this._nBox,t);if(e){var n={};n.selected=e.isSelected(),n.tooltip=e.getShortDesc(),n.color=N.getNodeColor(this._nBox,t),n.indicatorColor=N.getNodeIndicatorColor(this._nBox,t),t.label&&(n.label=t.label),t.secondaryLabel&&(n.secondaryLabel=t.secondaryLabel);var o=_.getDisplayable(this._nBox,t,"icon");n.icon=this._getMarkerData(o);var a=_.getDisplayable(this._nBox,t,"indicatorIcon");return n.indicatorIcon=this._getMarkerData(a),n}}return null},u.prototype.getCellGroupNode=function(e,n){if(n&&_.getGrouping(this._nBox)&&_.getGroupBehavior(this._nBox)==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){if("string"==typeof n)return this._getGroupNodeData(e.cellIndex+":"+n);var o=e.cellIndex+":";for(var a in n)n[a]?o+=a+":"+n[a]+";":o+=a+";";return this._getGroupNodeData(o.substring(0,o.length-1))}return null},u.prototype._getMarkerData=function(e){if(e){var n={};return n.shape=e instanceof t.SimpleMarker?e.getType():"none",e.getFill()&&(n.color=e.getFill().getColor()),n}return null},u.prototype.getDialog=function(){var t=_.getDrawer(this._nBox);if(t){var e=_.getCategoryNode(this._nBox,t.id);if(e){var n=_.getDisplayable(this._nBox,e),o={};o.label=n.getLabel(),o.getNodeCount=function(){return e.nodeIndices?e.nodeIndices.length:-1};for(var a={},i=e.id.split(";"),r=0;r<i.length;r++){var s=i[r].split(":");s&&2==s.length&&(a[s[0]]=s[1])}return o.groupInfo=a,o}}return null},u.prototype.getDialogNode=function(t){var e=_.getDrawer(this._nBox);if(e){var n=_.getCategoryNode(this._nBox,e.id);if(n&&n.nodeIndices&&null!=n.nodeIndices[t]){var o=_.getNode(this._nBox,n.nodeIndices[t]);return this._getNode(o)}}return null},u.prototype.getNodeIdFromIndex=function(t){return _.getNode(this._nBox,t).id},u.prototype.getNodeIndexFromId=function(t){return _.getNodeIndex(this._nBox,t)};var h=new Object;t.Obj.createSubclass(h,t.Obj),h.render=function(t,e,n){h._renderBackground(t,e,n),_.hasValidData(t)?(h._adjustAvailSpace(n),h._renderTitles(t,e,n),h._adjustAvailSpace(n),h._renderCells(t,e,n),h._renderNodes(t,e,n),h._renderInitialSelection(t)):h._renderEmptyText(t,e,n)},h._renderBackground=function(e,n,o){var a=new t.Rect(e.getCtx(),o.x,o.y,o.w,o.h);a.setInvisibleFill(),n.addChild(a);var i=new t.ClipPath;i.addRect(o.x,o.y,o.w,o.h),n.setClipPath(i)},h._renderTitles=function(e,n,o){var a=e.getOptions(),i=_.getColumnCount(e),r=_.getRowCount(e),s=a.__layout.componentGap,l=a.__layout.titleGap,g=a.__layout.titleComponentGap,d=t.Agent.isRightToLeft(e.getCtx());o.x+=s,o.y+=s,o.w-=2*s,o.h-=2*s;var u=_.getMaximizedColumn(e),c=u?_.getColumnIndex(e,u):-1,x=_.getMaximizedRow(e),p=x?_.getRowIndex(e,x):-1,f=null,b=null,y=[],S=[],B=0,E=0,v=0,D=0,A=0,O=0,I=0,L=0;a[t.NBoxConstants.COLUMNS_TITLE]&&(f=h.createText(e.getCtx(),a[t.NBoxConstants.COLUMNS_TITLE],a[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.COLUMNS_TITLE_STYLE],t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE),n.addChild(f),B=f.getDimensions().h),a[t.NBoxConstants.ROWS_TITLE]&&(b=h.createText(e.getCtx(),a[t.NBoxConstants.ROWS_TITLE],a[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.ROWS_TITLE_STYLE],t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE),n.addChild(b),E=b.getDimensions().h);for(var m=0;m<i;m++){var T=_.getColumn(e,m);if(T[t.NBoxConstants.LABEL]){var R=h.createText(e.getCtx(),T[t.NBoxConstants.LABEL],N.getColumnLabelStyle(e,m),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE);A=Math.max(A,R.getDimensions().h),u&&u!=T[t.NBoxConstants.ID]||(y[m]=R,n.addChild(y[m]))}}for(m=0;m<r;m++){var w=_.getRow(e,m);if(w[t.NBoxConstants.LABEL]){var M=h.createText(e.getCtx(),w[t.NBoxConstants.LABEL],N.getRowLabelStyle(e,m),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE);O=Math.max(O,M.getDimensions().h),x&&x!=w[t.NBoxConstants.ID]||(S[m]=M,n.addChild(S[m]))}}(E||O)&&(I=g,E&&O&&(v=l)),(B||A)&&(L=g,B&&A&&(D=l));var H=E+v+O+I,G=B+D+A+L;o.x+=d?0:H,o.w-=H,o.h-=G,f&&t.TextUtils.fitText(f,o.w,B,n)&&(h.positionText(f,o.x+o.w/2,o.y+o.h+G-B/2),_.setDisplayable(e,e.getOptions(),f,t.NBoxConstants.COLUMNS_TITLE)),b&&t.TextUtils.fitText(b,o.h,E,n)&&(h.positionText(b,o.x+(d?o.w:0)+(d?1:-1)*(H-E/2),o.y+o.h/2,d?Math.PI/2:-Math.PI/2),_.setDisplayable(e,e.getOptions(),b,t.NBoxConstants.ROWS_TITLE));for(m=0;m<i;m++)if(y[m]){var U=C.getCellDimensions(e,-1==p?0:p,m,o);t.TextUtils.fitText(y[m],U.w,A,n)&&(h.positionText(y[m],U.x+U.w/2,o.y+o.h+L+A/2),_.setDisplayable(e,_.getColumn(e,m),y[m],t.NBoxConstants.LABEL))}for(m=0;m<r;m++)if(S[m]){U=C.getCellDimensions(e,m,-1==c?0:c,o);t.TextUtils.fitText(S[m],U.h,O,n)&&(h.positionText(S[m],o.x+(d?o.w:0)+(d?1:-1)*(I+O/2),U.y+U.h/2,d?Math.PI/2:-Math.PI/2),_.setDisplayable(e,_.getRow(e,m),S[m],t.NBoxConstants.LABEL))}},h.createText=function(e,n,o,a,i){var r=new t.OutputText(e,n,0,0);return r.setCSSStyle(o),r.setHorizAlignment(a),r.setVertAlignment(i),r},h._renderCells=function(t,e,o){for(var a=_.getRowCount(t),i=_.getColumnCount(t),r=0;r<a;r++)for(var s=0;s<i;s++){var l=_.getCell(t,r*i+s);n.newInstance(t,l).render(e,o)}},h.getCellCounts=function(t){return t.getOptions().__cellCounts||h._calculateCellCounts(t)},h._calculateCellCounts=function(e){var n=_.getRowCount(e)*_.getColumnCount(e),o=[],a=null,i=_.getHighlightedItems(e),r={};if(i){a=[];for(var s=0;s<i.length;s++)r[i[s][t.NBoxConstants.ID]]=!0}for(s=0;s<n;s++)o[s]=0,a&&(a[s]=0);var l=_.getNodeCount(e);for(s=0;s<l;s++){var g=_.getNode(e,s);if(!_.isNodeHidden(e,g)){var d=_.getCellIndex(e,g);o[d]++,a&&r[g[t.NBoxConstants.ID]]&&a[d]++}}var u={};return u.total=o,a&&(u.highlighted=a),e.getOptions().__cellCounts=u,u},h.calculateNodeOrders=function(e){var n=["normal"],o=_.getHighlightedItems(e),a={};if(o)for(var i=0;i<o.length;i++)a[o[i][t.NBoxConstants.ID]]=!0;var r=_.getSelectedItems(e),s={};if(r)for(i=0;i<r.length;i++)s[r[i]]=!0;o?n=r?["highlighted-selected","highlighted-unselected","unhighlighted-selected","unhighlighted-unselected"]:["highlighted-unselected","unhighlighted-unselected"]:r&&(n=["unhighlighted-selected","unhighlighted-unselected"]);for(var l={},g=_.getNodeCount(e),d=0;d<n.length;d++)for(var u=0;u<g;u++){var h=_.getNode(e,u);if(!_.isNodeHidden(e,h)&&("normal"==n[d]||"highlighted-selected"==n[d]&&a[h[t.NBoxConstants.ID]]&&s[h[t.NBoxConstants.ID]]||"highlighted-unselected"==n[d]&&a[h[t.NBoxConstants.ID]]&&!s[h[t.NBoxConstants.ID]]||"unhighlighted-selected"==n[d]&&!a[h[t.NBoxConstants.ID]]&&s[h[t.NBoxConstants.ID]]||"unhighlighted-unselected"==n[d]&&!a[h[t.NBoxConstants.ID]]&&!s[h[t.NBoxConstants.ID]])){var C=_.getCellIndex(e,h);_.isCellMinimized(e,C)||(l[C]||(l[C]=[]),l[C].push(h))}}return l},h._renderNodes=function(t,e,n){if(_.getNodeCount(t)>0){if("counts"==_.getCellContent(t)){for(var o=_.getRowCount(t),a=_.getColumnCount(t),i=[],r=0;r<o;r++)for(var s=0;s<a;s++)i.push(r*a+s);return void C.renderBodyCountLabels(t,i)}_.getGrouping(t)?(h._renderCategoryNodes(t,e,n),h._renderDrawer(t,e,n)):h._renderIndividualNodes(t,e,n)}},h._renderIndividualNodes=function(e,n,i){var r=e.getOptions().__layout.gridGap,s=t.Agent.isRightToLeft(e.getCtx()),l=N.getFadedNodeAlpha(e),g=_.getHighlightedItems(e),d={};if(g)for(var u=0;u<g.length;u++)d[g[u][t.NBoxConstants.ID]]=!0;for(var x=h.calculateNodeOrders(e),p=c.calculateNodeLayout(e,x),f=p.indicatorSectionWidth+p.iconSectionWidth+p.labelSectionWidth+r,b=p.nodeHeight+r,y=_.getRowCount(e),S=_.getColumnCount(e),B=0;B<y;B++)for(var E=0;E<S;E++){var v=B*S+E,D=x[v];if(D&&D.length){var A=_.getCell(e,v),O=(K=p.cellLayouts[v]).cellRows,I=K.cellColumns;if(!(0==O||0==I||1==O&&1==I&&K.overflow))for(var L=O*I-(K.overflow?1:0),m=0;m<D.length;m++){var T=D[m];if(L<0||m<L){var R=(k=_.getDisplayable(e,A).getChildContainer())instanceof t.SimpleScrollableContainer,w=new o(e,T),M=A.__childArea.x+(A.__childArea.w-K.cellColumns*f+r)/2,H=R?r:A.__childArea.y,G=m%I;s&&(G=I-G-1);var U=Math.floor(m/I);w.setTranslate(M+f*G,H+b*U),w.render(R?k.getScrollingPane():k,p),g&&!d[T[t.NBoxConstants.ID]]&&w.setAlpha(l);var F=m>0?D[m-1]:null;if(F){var P=_.getDisplayable(e,F);w.previousNavigable=P,P.nextNavigable=w}}}}}y=_.getRowCount(e),S=_.getColumnCount(e);var W=[];for(B=0;B<y;B++)for(E=0;E<S;E++){var k,Y=B*S+E;if(!_.isCellMinimized(e,Y)){var K,z=_.getCell(e,Y);A=_.getDisplayable(e,z);if((K=p.cellLayouts[Y]).overflow){O=K.cellRows,I=K.cellColumns;if(0==O||0==I||1==O&&1==I&&K.overflow)W.push(Y);else{var V=a.newInstance(e,A);(P=_.getLastNavigableNode(e,A.getChildContainer()))&&P instanceof o&&(V.previousNavigable=P,P.nextNavigable=V),_.setDisplayable(e,V,V),_.setDisplayable(e,z,V,"overflow");M=z.__childArea.x+(z.__childArea.w-K.cellColumns*f+r)/2,H=z.__childArea.y,G=K.cellColumns-1;s&&(G=0);U=K.cellRows-1;V.setTranslate(M+f*G,H+b*U),V.render(A.getChildContainer(),f-r,b-r)}}}if(_.isCellMaximized(e,Y))(k=_.getDisplayable(e,_.getCell(e,Y)).getChildContainer()).prepareContentPane()}W.length>0&&C.renderBodyCountLabels(e,W)},h._renderCategoryNodes=function(e,n,o){var a,r={},s=_.getNodeCount(e),l=_.getGroupBehavior(e),g=t.Agent.isRightToLeft(e.getCtx()),d=_.getHighlightedItems(e),u={};if(d)for(var C=0;C<d.length;C++)u[d[C][t.NBoxConstants.ID]]=!0;for(var c=0;c<s;c++){var x=_.getNode(e,c);if(!_.isNodeHidden(e,x)){var p=r;if(l==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){var N=_.getCellIndex(e,x)+"";(p=r[N])||(p={},r[N]=p)}(y=p[N=_.getNodeGroupId(x)])||((y={})[t.NBoxConstants.ID]=N,l==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL&&(y[t.NBoxConstants.CELL]=_.getCellIndex(e,x)),y.nodeIndices=[],y.highlightedCount=0,p[N]=y),y.nodeIndices.push(c),u[_.getNode(e,c)[t.NBoxConstants.ID]]&&y.highlightedCount++}}if(l==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL)for(var f in a={},r)a[f]=h._processOtherThreshold(e,r[f]);else a=h._processOtherThreshold(e,r);r=a;if(e.getOptions().__groups=r,l==t.NBoxConstants.GROUP_BEHAVIOR_ACROSS_CELLS){var b=[];for(var y in r)b.push(y);b.sort(function(t,e){return i.compareSize(r[t],r[e])});var S=Math.sqrt(o.w*o.h*.15/s);for(C=0;C<b.length;C++){y=b[C];for(var B=0,E=0,v=(s=r[y].nodeIndices.length,0);v<s;v++){x=_.getNode(e,r[y].nodeIndices[v]);B+=_.getXPercentage(e,x),E+=_.getYPercentage(e,x)}B/=s,E/=s,(R=i.newInstance(e,r[y])).setTranslate(o.x+(g?1-B:B)*o.w,o.y+(1-E)*o.h),R.render(n,S,0),R.setMaxAlpha(.8)}}else if(l==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){var D=_.getRowCount(e)*_.getColumnCount(e),A=[];for(C=0;C<D;C++)if(r[C]&&!_.isCellMinimized(e,C)){var O=_.getCell(e,C);A[C]=h._forceLayoutGroups(r[C],O.__childArea.w,O.__childArea.h)}for(S=40,C=0;C<D;C++)r[C]&&!_.isCellMinimized(e,C)&&(S=Math.min(S,A[C].scale));for(C=0;C<D;C++)if(r[C]&&!_.isCellMinimized(e,C)){var I=A[C].positions,L=A[C].center,m=(O=_.getCell(e,C),_.getDisplayable(e,O).getChildContainer()),T=m instanceof t.SimpleScrollableContainer;for(var y in I){var R;(R=i.newInstance(e,r[C][y])).setTranslate(O.__childArea.x+O.__childArea.w/2+S*(I[y].x-L.x),(T?0:O.__childArea.y)+O.__childArea.h/2+S*(I[y].y-L.y)),R.render(T?m.getScrollingPane():m,S,3)}}}},h.getRowDimensions=function(e,n,o){var a=_.getRowCount(e),i=o.h/a,r=o.y+(a-n-1)*i,s=i;return new t.Rectangle(o.x,r,o.w,s)},h.getColumnDimensions=function(e,n,o){var a=_.getColumnCount(e),i=o.w/a,r=t.Agent.isRightToLeft(e.getCtx()),s=o.x+(r?o.w-i:0)+(r?-1:1)*n*i,l=i;return new t.Rectangle(s,o.y,l,o.h)},h._adjustAvailSpace=function(t){t.x=Math.round(t.x),t.y=Math.round(t.y),t.w=Math.round(t.w),t.h=Math.round(t.h)},h.positionText=function(t,e,n,o){if(t.setX(e),t.setY(n),o){var a=t.getMatrix();a=(a=a.translate(-e,-n)).rotate(o),t.setMatrix(a.translate(e,n))}},h._renderInitialSelection=function(e){if(e.isSelectionSupported()){var n={},o=[],a=_.getSelectedItems(e);if(a){for(var r=0;r<a.length;r++)n[a[r]]=!0;var s=e.getObjects();if(_.getGrouping(e))for(r=0;r<s.length;r++)if(s[r]instanceof i){for(var l=s[r].getData().nodeIndices,g=!0,d=0;d<l.length;d++){var u=_.getNode(e,l[d]);if(!n[u[t.NBoxConstants.ID]]){g=!1;break}}if(g){var h=_.getDrawer(e);if(!h||h[t.NBoxConstants.ID]!==s[r].getId()){for(d=0;d<l.length;d++)n[(u=_.getNode(e,l[d]))[t.NBoxConstants.ID]]=!1;o.push(s[r].getId())}}}for(var C in n)n[C]&&o.push(C)}e.getSelectionHandler().processInitialSelections(o,s)}},h._forceLayoutGroups=function(e,n,o){var a=[];for(var r in e)a.push(r);a.sort(function(t,n){return i.compareSize(e[t],e[n])});for(var s={},l=2*Math.PI/a.length,g=0;g<a.length;g++){var d=g*Math.cos(l*g),u=g*Math.sin(l*g);s[a[g]]=f.create(d,u)}for(var h=1,C=-.25*o/Math.max(n,o),c=-.25*n/Math.max(n,o);h>.005;){var x={};for(g=0;g<a.length;g++){var p=s[O=a[g]],_=e[O].nodeIndices.length;x[O]=f.create(h*C*p.x,h*c*p.y);for(var N=0;N<a.length;N++)if(g!=N){for(var b,y=a[N],S=s[y],B=e[y].nodeIndices.length,E=f.subtract(p,S),v=f.getMagnitude(E),D=Math.atan2(E.y,E.x);D<0;)D+=Math.PI/2;for(;D>=Math.PI/2;)D-=Math.PI/2;if(v<(b=D<Math.PI/4?.5*(Math.sqrt(_)+Math.sqrt(B))/Math.cos(D):.5*(Math.sqrt(_)+Math.sqrt(B))/Math.sin(D))){var A=B/(_+B)*((b-v)/v);x[O]=f.add(x[O],f.scale(E,(1-h)*A))}}}for(g=0;g<a.length;g++){var O;s[O=a[g]]=f.add(s[O],x[O])}h*=.98}var I=Number.MAX_VALUE,L=-Number.MAX_VALUE,m=Number.MAX_VALUE,T=-Number.MAX_VALUE;for(g=0;g<a.length;g++){r=a[g];var R=Math.sqrt(e[r].nodeIndices.length),w=s[r];I=Math.min(I,w.x-R/2),L=Math.max(L,w.x+R/2),m=Math.min(m,w.y-R/2),T=Math.max(T,w.y+R/2)}var M=n/(L-I),H=o/(T-m),G=(I+L)/2,U=(m+T)/2;return{scale:Math.min(M,H),center:new t.Point(G,U),positions:s}},h._processOtherThreshold=function(e,n){var o=_.getNodeCount(e),a=_.getOtherThreshold(e)*o;if(a<=1)return n;var i={},r={};if(_.getGroupBehavior(e)==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL)for(var s in n){var l=n[s];r.cell=l.cell;break}for(var s in r.id="other",r.nodeIndices=[],r.otherNode=!0,n){if((l=n[s]).nodeIndices.length<a)for(var g=0;g<l.nodeIndices.length;g++)r.nodeIndices.push(l.nodeIndices[g]);else i[s]=l}return r.nodeIndices.length>0&&(i.other=r),i},h._renderDrawer=function(e,n,o){var a=_.getDrawer(e);a&&(_.getCategoryNode(e,a.id)?s.newInstance(e,a).render(n,o):(e.getOptions()[t.NBoxConstants.DRAWER]=null,_.fireOptionChangeEvent(e,t.NBoxConstants.DRAWER,null)))},h.getGlobalMatrix=function(t){for(var e=t.getMatrix(),n=t.getParent();n;){var o=n.getMatrix();e=e.translate(o.getTx(),o.getTy()),n=n.getParent()}return e},h.animateUpdate=function(t,e,n){h._animateCells(t,e,n),h._animateNodes(t,e,n);var o=_.getDrawer(e);o=o?o.id:null;var a=_.getDrawer(n);o!=(a=a?a.id:null)&&h._animateDrawer(t,e,n)},h._animateCells=function(e,n,o){for(var a=_.getRowCount(n),i=_.getRowCount(o),r=_.getColumnCount(n),s=_.getColumnCount(o),l=a*r,g=i*s,d=[],u=[],h=0;h<l;h++)d.push(_.getDisplayable(n,_.getCell(n,h)));for(h=0;h<g;h++)u.push(_.getDisplayable(o,_.getCell(o,h)));if(a==i&&r==s){var C=!0;for(h=0;h<i;h++){if(_.getRow(n,h)[t.NBoxConstants.ID]!=_.getRow(o,h)[t.NBoxConstants.ID]){C=!1;break}}if(C)for(h=0;h<s;h++){if(_.getColumn(n,h)[t.NBoxConstants.ID]!=_.getColumn(o,h)[t.NBoxConstants.ID]){C=!1;break}}if(C)return void e.constructAnimation(d,u)}e.constructAnimation(d,[]),e.constructAnimation([],u)},h._animateNodes=function(t,e,n){for(var o=_.getNodeCount(e),a=_.getNodeCount(n),i=[],r=[],s=0;s<o;s++)i.push(_.getDisplayable(e,_.getNode(e,s)));for(s=0;s<a;s++)r.push(_.getDisplayable(n,_.getNode(n,s)));t.constructAnimation(i,r);var l=_.getDrawer(e);if(!_.getDrawer(n)){var g=h._getSortedGroups(e),d=h._getSortedGroups(n);l&&(_.getMaximizedCellIndex(e)!=_.getMaximizedCellIndex(n)?(g=g.filter(function(t){return t.getData().cell!=_.getMaximizedCellIndex(e)}),d=d.filter(function(t){return t.getData().cell!=_.getMaximizedCellIndex(e)})):(g=null,d=null)),t.constructAnimation(g,d)}},h._getSortedGroups=function(e){var n=_.getGroupBehavior(e),o=e.getOptions().__groups,a=[];if(o)if(n==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL)for(var i=_.getRowCount(e)*_.getColumnCount(e),r=0;r<i;r++)for(var s=o[r+""],l=h._getSortedGroupsFromContainer(e,s),g=0;g<l.length;g++)a.push(l[g]);else a=h._getSortedGroupsFromContainer(e,o);return a},h._getSortedGroupsFromContainer=function(t,e){var n=[];for(var o in e){var a=_.getDisplayable(t,e[o]);a&&n.push(a)}return n.sort(function(t,e){var n=t.getId(),o=e.getId();return n==o?0:n<o?-1:1}),n},h._animateDrawer=function(t,e,n){var o=_.getDrawer(e);o=o?[_.getDisplayable(e,o)]:null;var a=_.getDrawer(n);a=a?[_.getDisplayable(n,a)]:[],t.constructAnimation(o,a)},h.setFill=function(e,n){if(0==n.indexOf("linear-gradient")){var o=t.GradientParser.parseCSSGradient(n);o&&e.setFill(new t.LinearGradientFill(o.getAngle(),o.getColors(),o.getAlphas(),o.getRatios()))}else e.setSolidFill(n)},h.getNodeOrderFunction=function(e){var n=[],o=_.getDrawer(e);if(o)for(var a=_.getDisplayable(e,o).getChildContainer().getScrollingPane(),i=0;i<a.getNumChildren();i++)n.push(a.getChildAt(i));else for(var r=_.getRowCount(e)*_.getColumnCount(e),s=0;s<r;s++){var l=[],g=_.getCell(e,s),d=_.getDisplayable(e,g).getChildContainer();d instanceof t.SimpleScrollableContainer&&(d=d.getScrollingPane());for(var u=0;u<d.getNumChildren();u++)l.push(d.getChildAt(u));n.push(l)}return function(){if(n.length)if(n[0]&&isNaN(n[0].length)){var o=_.getDrawer(e);if(o)for(var a=_.getDisplayable(e,o).getChildContainer().getScrollingPane(),i=0;i<n.length;i++)a.addChild(n[i])}else for(var r=0;r<n.length;r++){var s=n[r],l=_.getCell(e,r);if(s.length&&l){var g=_.getDisplayable(e,l).getChildContainer();g instanceof t.SimpleScrollableContainer&&(g=g.getScrollingPane());for(i=0;i<s.length;i++)g.addChild(s[i])}}}},h._renderEmptyText=function(e,n,o){var a=e.getOptions(),i=a.translations.labelInvalidData;t.TextUtils.renderEmptyText(n,i,new t.Rectangle(o.x,o.y,o.w,o.h),e.getEventManager(),a._statusMessageStyle)};var C=new Object;t.Obj.createSubclass(C,t.Obj),C.render=function(e,n,o,a){var i=e.getOptions(),r=i.__layout.cellGap,s=i.__layout.cellStartGap,l=i.__layout.cellEndGap,g=i.__layout.cellTopGap,d=i.__layout.cellBottomGap,u=C.getCellLayout(e),h=_.getRowIndex(e,n[t.NBoxConstants.ROW]),c=_.getColumnIndex(e,n[t.NBoxConstants.COLUMN]),x=C.getCellDimensions(e,h,c,a);o.setTranslate(x.x+r/2,x.y+r/2);var p=h*_.getColumnCount(e)+c,f=new t.Rect(e.getCtx(),0,0,Math.max(x.w-r,0),Math.max(x.h-r,0));f.setPixelHinting(!0);var b=N.getCellStyle(e,p);C._applyStyleToRect(f,b);var y=N.getCellStyleObject(e,p);f.setStyle(y);var S=N.getCellClassName(e,p);f.setClassName(S),o.addChild(f),_.setDisplayable(e,n,f,"background");var B=new t.KeyboardFocusEffect(e.getCtx(),o,new t.Rectangle(-1,-1,f.getWidth()+2,f.getHeight()+2));_.setDisplayable(e,n,B,"focusEffect"),C.renderHeader(e,n,o,!1);var E=_.isCellMaximized(e,p),v=E?u.maximizedHeaderSize:u.headerSize,D=E?u.maximizedLabelHeight:u.labelHeight,A=E?new t.SimpleScrollableContainer(e.getCtx(),f.getWidth(),f.getHeight()-v):new t.Container(e.getCtx());o.addChild(A),o.setChildContainer(A);var O=null;D?(O=C._isLabelVertical(e,n)?new t.Rectangle(v,g,f.getWidth()-v-l,f.getHeight()-g-d):new t.Rectangle(s,v,f.getWidth()-s-l,f.getHeight()-v-d),A instanceof t.SimpleScrollableContainer&&A.setTranslate(0,v)):O=new t.Rectangle(s,g,f.getWidth()-s-l,f.getHeight()-g-d),O.w=Math.max(O.w,0),O.h=Math.max(O.h,0),n.__childArea=O},C.renderHeader=function(e,n,o,a){var i=_.getDisplayable(e,n,t.NBoxConstants.LABEL);i&&(i.getParent().removeChild(i),_.setDisplayable(e,n,null,t.NBoxConstants.LABEL));var r=_.getDisplayable(e,n,"countLabel");r&&(r.getParent().removeChild(r),_.setDisplayable(e,n,null,"countLabel"));var s=_.getDisplayable(e,n,"closeButton");s&&(s.getParent().removeChild(s),_.setDisplayable(e,n,null,"closeButton"));var l=!1;if(n){var g=e.getOptions(),d=g.__layout.countLabelGap,u=g.__layout.cellCloseGap,c=g.__layout.cellStartGap,x=g.__layout.cellEndGap,p=g.__layout.cellTopGap,f=C.getCellLayout(e),b=h.getCellCounts(e),y=_.getDisplayable(e,n,"background"),S=_.getRowIndex(e,n[t.NBoxConstants.ROW]),B=_.getColumnIndex(e,n[t.NBoxConstants.COLUMN]),E=S*_.getColumnCount(e)+B,v=t.Agent.isRightToLeft(e.getCtx()),D=0;if(_.isCellMaximized(e,E)){var A=g._resources.close_ena,O=A.width;if(y.getWidth()-c-x>O){var I=g._resources.close_ovr,L=g._resources.close_dwn,m=new t.Image(e.getCtx(),A.src,0,0,A.width,A.height),T=new t.Image(e.getCtx(),I.src,0,0,I.width,I.height),R=new t.Image(e.getCtx(),L.src,0,0,L.width,L.height),w=new t.Button(e.getCtx(),m,T,R,null,null,o.handleDoubleClick,o),M=v?Math.min((y.getWidth()-O)/2,x):Math.max((y.getWidth()-O)/2,y.getWidth()-x-O);w.setTranslate(M,p),o.addChild(w),D=O+u,_.setDisplayable(e,n,w,"closeButton"),l=!0}}if(n[t.NBoxConstants.LABEL]){var H=f.labelHeight,G=!1,U=N.getLabelHalign(e,n),F=0,P=null,W=0,k=0,Y=null,K=N.getCellShowCount(e,n);if(!a&&"off"!=K){var z=_.getDisplayable(e,n).getCountLabel();z?Y=z:"on"==K&&(Y=""+b.total[E],b.highlighted&&(Y=t.ResourceUtils.format(g.translations.highlightedCount,[b.highlighted[E],Y])))}if(C._isLabelVertical(e,n)){Y&&(P=h.createText(e.getCtx(),Y,N.getCellCountLabelStyle(e),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE),t.TextUtils.fitText(P,y.getHeight()-c-x,y.getWidth()-2*p,o)?(_.setDisplayable(e,n,P,"countLabel"),l=!0,F=P.getDimensions().w+d,k=y.getHeight()/2,W=p+H/2):G=!0);var V=0;if(!G){var j=h.createText(e.getCtx(),n[t.NBoxConstants.LABEL],N.getCellLabelStyle(e,E),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE);if(t.TextUtils.fitText(j,y.getHeight()-c-x-F,y.getWidth()-2*p,o)){_.setDisplayable(e,n,j,t.NBoxConstants.LABEL);var X=j.getDimensions().w;l=!0,h.positionText(j,p+H/2,(y.getHeight()+F)/2,v?Math.PI/2:-Math.PI/2),V=(X+d)/2}}P&&(k-=V,h.positionText(P,W,k,v?Math.PI/2:-Math.PI/2))}else{Y&&(P=h.createText(e.getCtx(),Y,N.getCellCountLabelStyle(e),U,t.OutputText.V_ALIGN_MIDDLE),t.TextUtils.fitText(P,y.getWidth()-c-x-D,y.getHeight()-2*p,o)?(_.setDisplayable(e,n,P,"countLabel"),l=!0,F=P.getDimensions().w+d,W=U==t.OutputText.H_ALIGN_CENTER?y.getWidth()/2:U==t.OutputText.H_ALIGN_RIGHT?y.getWidth()-x:c,k=p+H/2,h.positionText(P,W,k)):G=!0);V=0;if(!G){j=h.createText(e.getCtx(),n[t.NBoxConstants.LABEL],N.getCellLabelStyle(e,E),U,t.OutputText.V_ALIGN_MIDDLE);if(t.TextUtils.fitText(j,y.getWidth()-c-x-D-F,y.getHeight()-2*p,o)){_.setDisplayable(e,n,j,t.NBoxConstants.LABEL);var q;X=j.getDimensions().w;l=!0,U==t.OutputText.H_ALIGN_CENTER?(q=(y.getWidth()-(v?-1:1)*F)/2,V=(v?-1:1)*(X+d)/2):U==t.OutputText.H_ALIGN_RIGHT?(q=y.getWidth()-x-(v?0:1)*F,V=(v?-1:0)*(X+d)):(q=c+(v?1:0)*F,V=(v?0:1)*(X+d));var Z=p+H/2;h.positionText(j,q,Z)}}P&&V&&h.positionText(P,W+V,k)}}}return C._addAccessibilityAttributes(e,n,o),l},C.renderBodyCountLabels=function(e,n){var o=e.getOptions().__layout.cellTopGap,a=e.getOptions().__layout.cellStartGap,i=C.getCellLayout(e),r=h.getCellCounts(e),s=Number.MAX_VALUE,l=!1,g=_.getCell(e,n[0]),d=_.getDisplayable(e,g,t.NBoxConstants.LABEL),u=_.getDisplayable(e,g,"countLabel"),c=d&&d.getCSSStyle()?d.getCSSStyle().getFontSize():null,x=u&&u.getCSSStyle()?u.getCSSStyle().getFontSize():null;c=isNaN(c)?parseFloat(c):c,x=isNaN(x)?parseFloat(x):x,isNaN(c)&&isNaN(x)||(s=isNaN(c)?x:isNaN(x)?c:Math.max(c,x));for(var p=[],f=[],b=0;b<n.length;b++)B=n[b],_.isCellMinimized(e,B)?f.push(B):p.push(B);var y=[],S=[];for(b=0;b<p.length;b++){var B=p[b],E=r.total[B];y[b]=h.createText(e.getCtx(),""+E,N.getCellBodyCountLabelStyle(e),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE)}for(b=0;b<f.length;b++){B=f[b],E=r.total[B];S[b]=h.createText(e.getCtx(),""+E,N.getCellBodyCountLabelStyle(e),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE)}var v=C.getBodyCountLabelsFontSize(e,p,y);(v<=s||u&&!d)&&(l=!0);var D=C.getBodyCountLabelsFontSize(e,f,S);if((D<=s||u&&!d)&&(l=!0),l){for(b=0;b<n.length;b++){g=_.getCell(e,n[b]),d=_.getDisplayable(e,g,t.NBoxConstants.LABEL),u=_.getDisplayable(e,g,"countLabel");var A=g.__childArea,O=!1;d&&(d.getParent().removeChild(d),_.setDisplayable(e,g,null,t.NBoxConstants.LABEL),O=!0),u&&(u.getParent().removeChild(u),_.setDisplayable(e,g,null,"countLabel"),O=!0),O&&(C._isLabelVertical(e,g)?(A.x-=i.headerSize-a,A.w+=i.headerSize-a):(A.y-=i.headerSize-o,A.h+=i.headerSize-o),g.__childArea=A)}v=C.getBodyCountLabelsFontSize(e,p,y),D=C.getBodyCountLabelsFontSize(e,f,S)}for(b=0;b<p.length;b++){B=p[b],g=_.getCell(e,B);var I=_.getDisplayable(e,g);A=g.__childArea;y[b].setFontSize(v),t.TextUtils.fitText(y[b],A.w,A.h,I)&&(l||C.renderHeader(e,g,I,!0),h.positionText(y[b],A.x+A.w/2,A.y+A.h/2))}for(b=0;b<f.length;b++){B=f[b],g=_.getCell(e,B);I=_.getDisplayable(e,g),A=g.__childArea;S[b].setFontSize(D),t.TextUtils.fitText(S[b],A.w,A.h,I)&&(l||C.renderHeader(e,g,I,!0),h.positionText(S[b],A.x+A.w/2,A.y+A.h/2))}},C.getBodyCountLabelsFontSize=function(e,n,o){for(var a=Number.MAX_VALUE,i=0;i<n.length;i++){var r=_.getCell(e,n[i]).__childArea;a=Math.min(a,parseInt(t.TextUtils.getOptimalFontSize(o[i].getCtx(),o[i].getTextString(),o[i].getCSSStyle(),r)))}return a},C._isLabelVertical=function(e,n){var o=_.getMaximizedColumn(e),a=_.getMaximizedRow(e);return!(!o||o==n[t.NBoxConstants.COLUMN]||a&&a!=n[t.NBoxConstants.ROW])},C.getCellDimensions=function(e,n,o,a){var i=e.getOptions().__layout.cellGap,r=C.getCellLayout(e),s=t.Agent.isRightToLeft(e.getCtx()),l=i+r.minimumCellSize,g=_.getRowCount(e),d=_.getColumnCount(e),u=h.getRowDimensions(e,n,a),c=h.getColumnDimensions(e,o,a),x=_.getMaximizedRow(e),p=_.getMaximizedColumn(e),N=c.x,f=u.y,b=c.w,y=u.h,S=!0;if(x){var B=_.getRowIndex(e,x),E=Math.min(a.h/(3*(g-1)),l);n<B?(f=a.y+a.h-(n+1)*E,y=E,S=!1):n==B?(f=a.y+(g-n-1)*E,y=a.h-(g-1)*E):(f=a.y+(g-n-1)*E,y=E,S=!1)}if(p&&S){var v=_.getColumnIndex(e,p),D=Math.min(a.w/(3*(d-1)),l);o<v?(b=D,N=a.x+(s?a.w-D:0)+(s?-1:1)*o*D):o==v?(b=a.w-(d-1)*D,N=a.x+(s?a.w-b:0)+(s?-1:1)*o*D):(b=D,N=a.x+(s?-D:a.w)+(s?1:-1)*(d-o)*D)}return new t.Rectangle(N,f,b,y)},C.getCellLayout=function(t){return t.getOptions().__layout.__cellLayout||C._calculateCellLayout(t)},C._calculateCellLayout=function(e){for(var n=e.getOptions(),o=h.getCellCounts(e),a=n.__layout.cellTopGap,i=n.__layout.cellBottomGap,r=n.__layout.cellLabelGap,s=n.__layout.minimumCellSize,l=0,g=0,d=_.getRowCount(e)*_.getColumnCount(e),u=0;u<d;u++){var C=_.getCell(e,u);if(C&&C[t.NBoxConstants.LABEL]){var c=C[t.NBoxConstants.LABEL_HALIGN],x=h.createText(e.getCtx(),C[t.NBoxConstants.LABEL],N.getCellLabelStyle(e,u),c,t.OutputText.V_ALIGN_MIDDLE).getDimensions().h;if("on"==N.getCellShowCount(e,C)){var p=h.createText(e.getCtx(),o.total[u],N.getCellCountLabelStyle(e),c,t.OutputText.V_ALIGN_MIDDLE).getDimensions().h;x=Math.max(x,p)}l=Math.max(l,x)}}_.getMaximizedRow(e)&&_.getMaximizedColumn(e)&&(g=Math.max(l,n._resources.close_ena.height));var f=l+a+i,b={labelHeight:l,headerSize:l+a+r,maximizedLabelHeight:g,maximizedHeaderSize:g+a+r,minimumCellSize:s=Math.max(f,s)};return n.__layout.__cellLayout=b,b},C.animateUpdate=function(e,n,o){var a=e.getOldNBox(),i=e.getNewNBox(),r=new t.CustomAnimation(i.getCtx(),o,e.getAnimationDuration()),s=o.getChildContainer(),g=s.getMatrix();s.setMatrix(h.getGlobalMatrix(s));var d=o.getParent();d.addChildAt(s,d.getChildIndex(o)+1);var u=o.getTranslateX(),c=o.getTranslateY();r.getAnimator().addProp(t.Animator.TYPE_MATRIX,o,o.getMatrix,o.setMatrix,o.getMatrix()),o.setMatrix(n.getMatrix());var x=_.getDisplayable(a,n.getData(),"background"),p=_.getDisplayable(i,o.getData(),"background"),N=t.Agent.isRightToLeft(i.getCtx())?0:p.getWidth()-x.getWidth();if(p.getFill().equals(x.getFill())||(r.getAnimator().addProp(t.Animator.TYPE_FILL,p,p.getFill,p.setFill,p.getFill()),p.setFill(x.getFill())),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,p,p.getWidth,p.setWidth,p.getWidth()),p.setWidth(x.getWidth()),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,p,p.getHeight,p.setHeight,p.getHeight()),p.setHeight(x.getHeight()),o.isShowingKeyboardFocusEffect()){var f=_.getDisplayable(i,o.getData(),"focusEffect").getEffect();f&&(r.getAnimator().addProp(t.Animator.TYPE_NUMBER,f,f.getWidth,f.setWidth,f.getWidth()),f.setWidth(x.getWidth()+2),r.getAnimator().addProp(t.Animator.TYPE_NUMBER,f,f.getHeight,f.setHeight,f.getHeight()),f.setHeight(x.getHeight()+2))}C._animateLabels(e,n,o,"countLabel"),C._animateLabels(e,n,o,t.NBoxConstants.LABEL);var b=_.getDisplayable(a,n.getData(),"closeButton"),y=_.getDisplayable(i,o.getData(),"closeButton");if(b)if(y)r.getAnimator().addProp(t.Animator.TYPE_MATRIX,y,y.getMatrix,y.setMatrix,y.getMatrix()),y.setMatrix(b.getMatrix());else{var S=h.getGlobalMatrix(b);b.setTranslate(b.getTranslateX()+N+u,b.getTranslateY()+c),e.add(new t.AnimFadeOut(i.getCtx(),b,e.getAnimationDuration()),l.UPDATE),r.getAnimator().addProp(t.Animator.TYPE_MATRIX,b,b.getMatrix,b.setMatrix,b.getMatrix()),b.setMatrix(S),i.getDeleteContainer().addChild(b)}else y&&(e.add(new t.AnimFadeIn(i.getCtx(),y,e.getAnimationDuration()),l.UPDATE),r.getAnimator().addProp(t.Animator.TYPE_MATRIX,y,y.getMatrix,y.setMatrix,y.getMatrix()),y.setTranslate(y.getTranslateX()-N,y.getTranslateY()),y.setAlpha(0));t.Playable.appendOnEnd(r,function(){o.addChild(s),s.setMatrix(g)}),e.add(r,l.UPDATE)},C._animateLabels=function(e,n,o,a){var i=e.getOldNBox(),r=e.getNewNBox(),s=_.getDisplayable(i,n.getData(),a),g=_.getDisplayable(r,o.getData(),a),d=C._isLabelVertical(i,n.getData()),u=C._isLabelVertical(r,o.getData());if(s||g)if(s&&g&&d==u){var c=new t.CustomAnimation(r.getCtx(),g,e.getAnimationDuration()),x=s.getHorizAlignment();x="left"==x?-1:"center"==x?0:1;var p=g.getHorizAlignment(),N=((p="left"==p?-1:"center"==p?0:1)-x)*g.getDimensions().w/2;if(c.getAnimator().addProp(t.Animator.TYPE_NUMBER,g,g.getX,g.setX,g.getX()),g.setX(s.getX()+N),c.getAnimator().addProp(t.Animator.TYPE_NUMBER,g,g.getY,g.setY,g.getY()),g.setY(s.getY()),c.getAnimator().addProp(t.Animator.TYPE_MATRIX,g,g.getMatrix,g.setMatrix,g.getMatrix()),g.setMatrix(s.getMatrix()),e.add(c,l.UPDATE),"countLabel"==a&&s.getTextString()!=g.getTextString()){g.setAlpha(0),o.addChild(s);var f=new t.AnimFadeOut(r.getCtx(),s,e.getAnimationDuration()),b=new t.AnimFadeIn(r.getCtx(),g,e.getAnimationDuration());e.add(f,l.UPDATE),e.add(b,l.INSERT),t.Playable.appendOnEnd(f,function(){r.getDeleteContainer().addChild(s)})}}else s&&(s.setMatrix(h.getGlobalMatrix(s)),r.getDeleteContainer().addChild(s),e.add(new t.AnimFadeOut(r.getCtx(),s,e.getAnimationDuration()),l.UPDATE)),g&&(g.setAlpha(0),e.add(new t.AnimFadeIn(r.getCtx(),g,e.getAnimationDuration()),l.UPDATE))},C.animateDelete=function(e,n){var o=e.getNewNBox(),a=n.getChildContainer();if(a){var i=h.getGlobalMatrix(a),r=n.getParent();r.addChildAt(a,r.getChildIndex(n)+1),a.setMatrix(i)}o.getDeleteContainer().addChild(n),e.add(new t.AnimFadeOut(o.getCtx(),n,e.getAnimationDuration()),l.UPDATE)},C.animateInsert=function(e,n){var o=e.getNewNBox(),a=n.getChildContainer(),i=null;if(a){i=a.getMatrix();var r=h.getGlobalMatrix(n),s=n.getParent();s.addChildAt(a,s.getChildIndex(n)+1),a.setMatrix(r)}n.setAlpha(0);var g=new t.AnimFadeIn(o.getCtx(),n,e.getAnimationDuration());a&&t.Playable.appendOnEnd(g,function(){n.addChild(a),a.setMatrix(i)}),e.add(g,l.UPDATE)},C.renderDropSiteFeedback=function(e,n){var o=_.getDisplayable(e,n.getData(),"background"),a=new t.Rect(e.getCtx(),o.getX(),o.getY(),o.getWidth(),o.getHeight());a.setPixelHinting(!0);var i=N.getCellDropTargetStyle(e);return C._applyStyleToRect(a,i),n.addChildAt(a,n.getChildIndex(o)+1),a},C._applyStyleToRect=function(e,n){var o=n.getStyle(t.CSSStyle.BACKGROUND),a=n.getStyle(t.CSSStyle.BACKGROUND_COLOR),i=o||a;if(i&&h.setFill(e,i),"solid"==n.getStyle(t.CSSStyle.BORDER_STYLE)){var r=n.getStyle(t.CSSStyle.BORDER_COLOR);r=r||"#000000";var s=n.getStyle(t.CSSStyle.BORDER_WIDTH);s=null==s?1:parseFloat(s),e.setSolidStroke(r,null,s)}},C._addAccessibilityAttributes=function(e,n,o){var a=t.Agent.isTouchDevice()?_.getDisplayable(e,n,"background"):o;if(a.setAriaRole("img"),!t.Agent.deferAriaCreation()){var i=o.getAriaLabel();i&&a.setAriaProperty(t.NBoxConstants.LABEL,i)}};var c=new Object;t.Obj.createSubclass(c,t.Obj),c._MIN_CORNER_RADIUS=2.5,c._ASPECT_RATIO_SCALING="xMidYMid slice",c.render=function(t,e,n,o){c._renderNodeBackground(t,e,n,o),c._renderNodeIndicator(t,e,n,o),c._renderNodeIcon(t,e,n,o),c._renderNodeLabels(t,e,n,o),c._addAccessibilityAttributes(t,n);var a=n.getChildContainer();a&&c._clipIfNecessary(t,a,o)},c.calculateNodeLayout=function(e,n){for(var o=e.getOptions(),a=o.__layout.gridGap,i=o.__layout.nodeStartLabelGap,r=o.__layout.nodeLabelOnlyStartLabelGap,s=o.__layout.nodeEndLabelGap,l=o.__layout.nodeSwatchSize,g=o.__layout.maximumLabelWidth,d=c._calculateSimpleNodeLayout(e),u=d.nodeHeight,h=d.indicatorSectionWidth,C=d.iconSectionWidth,x=h||C?i:r,p=_.getNode(e,0),f=_.getIndicatorIcon(e,p),b=_.getIcon(e,p),y=0,S=[],B=0,E=0,v=_.getMaximizedRow(e),D=_.getMaximizedColumn(e),A=_.getRowCount(e),O=_.getColumnCount(e),I=0;I<A;I++)for(var L=0;L<O;L++)S.push({cellRows:0,cellColumns:0,overflow:!1});for(var m=[],T=_.getNodeCount(e),R=0;R<T;R++){var w=_.getNode(e,R);if(!_.isNodeHidden(e,w)){var M=_.getCellIndex(e,w);isNaN(m[M])&&(m[M]=0),m[M]++}}if(v&&D){var H=_.getColumnIndex(e,D)+O*_.getRowIndex(e,v),G=_.getCell(e,H).__childArea;if(null==(y=d.labelSectionWidth)){if("ifRequired"!=o.labelTruncation)y=g+x+s;else{var U=n[H];y=Math.max(g,c._getMaxLabelWidth(e,U))+x+s}y=Math.min(y,G.w-h-C)}if(E=Math.floor((G.w+a)/(h+C+y+a)),p[t.NBoxConstants.LABEL]){var F=new t.Container,P=!1,W=_.getNodeLabel(e,p),k=W.getDimensions().h;if(t.TextUtils.fitText(W,y-x-s,k,F)&&(P=!0),p[t.NBoxConstants.SECONDARY_LABEL]){var Y=_.getNodeSecondaryLabel(e,p),K=Y.getDimensions().h;t.TextUtils.fitText(Y,y-x-s,K,F)&&(P=!0)}P||(y=0,p[t.NBoxConstants.COLOR]&&(f&&!N.getNodeIndicatorColor(e,p)||b&&!b[t.NBoxConstants.SOURCE]||(y=Math.max(0,Math.min(l,G.w-h-C)))))}if(G.w-h-C<0){var z=C;C=Math.max(0,G.w-h)}G.w-h<0&&(h=G.w),S[H]={cellRows:-1,cellColumns:E,overflow:!1}}else{var V=[];if(v){var j=_.getRowIndex(e,v);for(L=0;L<O;L++)V.push(L+j*O)}else if(D){var X=_.getColumnIndex(e,D);for(I=0;I<A;I++)V.push(X+I*O)}else for(R=0;R<S.length;R++)V.push(R);if(null!=d.labelSectionWidth){y=d.labelSectionWidth;G=_.getCell(e,V[0]).__childArea;B=Math.floor((G.h+a)/(u+a)),E=Math.floor((G.w+a)/(h+C+y+a))}else{for(var q=0,Z=0;Z<V.length;Z++)"number"==typeof m[V[Z]]&&(m[V[Z]]>m[q]||"number"!=typeof m[q])&&(q=V[Z]);if("ifRequired"!=o.labelTruncation){G=_.getCell(e,q).__childArea;if((Q=Math.floor((G.h+a)/(u+a)))*($=Math.floor((G.w+a)/(h+C+o.__layout.minimumLabelWidth+x+s+a)))<m[q])y=Math.floor(Math.min(o.__layout.maximumLabelWidth+x+s,(G.w+a)/$-(h+C+a))),B=Q,E=$;else{var J=$;for(y=Math.floor(Math.min(o.__layout.maximumLabelWidth+x+s,(G.w+a)/J-(h+C+a)));y<o.__layout.maximumLabelWidth+x+s&&(J-1)*Q>=m[q];)J--,y=Math.floor(Math.min(o.__layout.maximumLabelWidth+x+s,(G.w+a)/J-(h+C+a)));B=Q,E=J}}else{G=_.getCell(e,V[0]).__childArea;var Q=Math.floor((G.h+a)/(u+a)),$=Math.floor((G.w+a)/(h+C+o.__layout.minimumLabelWidth+x+s+a));B=Q,E=0;for(var tt=0,et=0;E<=$;){E++;var nt=Math.floor((G.w+a)/E-(h+C+a));if(tt>nt){E=Math.max(E-1,1);break}var ot=E*B,at=[];for(I=0;I<A;I++)for(L=0;L<O;L++){if((U=n[rt=_.getColumnIndex(e,L)+O*_.getRowIndex(e,I)])&&U.length){var it=Math.min(U.length,ot);U.length>ot&&it--;for(w=et;w<it;w++)at.push(U[w])}}if((tt=Math.max(tt,Math.ceil(c._getMaxLabelWidth(e,at)+x+s)))>nt){E=Math.max(E-1,1);break}if(ot>=m[q])break;et=ot}(y=tt>(nt=Math.floor((G.w+a)/E-(h+C+a)))?nt:Math.max(tt,Math.min(nt,g+x+s)))<o.__layout.minimumLabelWidth&&(E=0)}}for(Z=0;Z<V.length;Z++){var rt,st=!1;m[rt=V[Z]]>B*E&&(st=!0),S[rt]={cellRows:B,cellColumns:E,overflow:st}}}var lt={nodeHeight:u,indicatorSectionWidth:h,iconSectionWidth:C,iconWidth:z,labelSectionWidth:y,cellLayouts:S};return o.__layout.__nodeLayout=lt,lt},c.calculateNodeDrawerLayout=function(e,n,o){var a,i=e.getOptions(),r=i.__layout.gridGap,s=i.__layout.nodeStartLabelGap,l=i.__layout.nodeLabelOnlyStartLabelGap,g=i.__layout.nodeEndLabelGap,d=i.__layout.nodeSwatchSize,u=i.__layout.maximumLabelWidth,h=_.getNode(e,0),C=_.getIndicatorIcon(e,h),x=_.getIcon(e,h),p=c._calculateSimpleNodeLayout(e),f=p.nodeHeight,b=p.indicatorSectionWidth,y=p.iconSectionWidth,S=b||y?s:l,B=n.__childArea;null==(a=p.labelSectionWidth)&&(a="ifRequired"!=i.labelTruncation?u+S+g:Math.max(u,c._getMaxLabelWidth(e,o))+S+g,a=Math.min(a,B.w-b-y));var E=Math.floor((B.w+r)/(b+y+a+r));if(h[t.NBoxConstants.LABEL]){var v=new t.Container,D=!1,A=_.getNodeLabel(e,h),O=A.getDimensions().h;if(t.TextUtils.fitText(A,a-S-g,O,v)&&(D=!0),h[t.NBoxConstants.SECONDARY_LABEL]){var I=_.getNodeSecondaryLabel(e,h),L=I.getDimensions().h;t.TextUtils.fitText(I,a-S-g,L,v)&&(D=!0)}D||(a=0,h[t.NBoxConstants.COLOR]&&(C&&!N.getNodeIndicatorColor(e,h)||x&&!x[t.NBoxConstants.SOURCE]||(a=Math.max(0,Math.min(d,B.w-b-y)))))}if(B.w-b-y<0){var m=y;y=Math.max(0,B.w-b)}B.w-b<0&&(b=B.w);var T={nodeHeight:f,indicatorSectionWidth:b,iconSectionWidth:y,iconWidth:m,labelSectionWidth:a,drawerLayout:{rows:-1,columns:E}};return i.__layout.__nodeDrawerLayout=T,T},c._calculateSimpleNodeLayout=function(e){var n=e.getOptions(),o=n.__layout.nodeIndicatorGap,a=n.__layout.nodeSingleLabelGap,i=n.__layout.nodeDualLabelGap,r=n.__layout.nodeInterLabelGap,s=n.__layout.nodeSwatchSize,l=_.getNode(e,0),g=0,d=0,u=0,h=null,C=_.getIndicatorIcon(e,l),c=N.getNodeIndicatorColor(e,l),x=_.getIcon(e,l);if(C){var p=C[t.NBoxConstants.WIDTH],f=C[t.NBoxConstants.HEIGHT];d=p+2*o,g=Math.max(g,f+2*o)}else c&&(d=s);if(l[t.NBoxConstants.LABEL]){var b=_.getNodeLabel(e,l).getDimensions().h;if(g=Math.max(g,b+2*a),l[t.NBoxConstants.SECONDARY_LABEL]){var y=_.getNodeSecondaryLabel(e,l).getDimensions().h;g=Math.max(g,b+y+2*i+r)}}else h=0,l[t.NBoxConstants.COLOR]&&(C&&!N.getNodeIndicatorColor(e,l)||x&&!x[t.NBoxConstants.SOURCE]||(h=d||s));if(x){var S=Math.max(g,t.Agent.isTouchDevice()?x.preferredSizeTouch:x.preferredSize),B=(x[t.NBoxConstants.SOURCE]?x.sourcePaddingRatio:x.shapePaddingRatio)*S,E=x[t.NBoxConstants.WIDTH]?x[t.NBoxConstants.WIDTH]:S-2*B,v=x[t.NBoxConstants.HEIGHT]?x[t.NBoxConstants.HEIGHT]:S-2*B;u=E+2*B,g=Math.max(g,v+2*B)}return{nodeHeight:g,indicatorSectionWidth:d,iconSectionWidth:u,labelSectionWidth:h}},c._renderNodeBackground=function(e,n,o,a){var i=a.indicatorSectionWidth+a.iconSectionWidth+a.labelSectionWidth,r=a.nodeHeight,s=N.getNodeBorderRadius(e),l=N.getNodeHoverColor(e),g=N.getNodeSelectionColor(e),d=new t.Rect(e.getCtx(),0,0,i,r);d.setFill(null),s&&(d.setRx(s),d.setRy(s)),d.setHoverStroke(new t.Stroke(l,1,2),new t.Stroke(g,1,4)),d.setSelectedStroke(new t.Stroke(g,1,4),null),d.setSelectedHoverStroke(new t.Stroke(l,1,2),new t.Stroke(g,1,6)),o.addChild(d),o.setSelectionShape(d);var u=new t.Rect(e.getCtx(),0,0,i,r);s&&(u.setRx(s),u.setRy(s));var h=N.getNodeColor(e,n);u.setSolidFill(h),N.getNodeBorderColor(e,n)&&N.getNodeBorderWidth(e,n)&&u.setSolidStroke(N.getNodeBorderColor(e,n),null,N.getNodeBorderWidth(e,n));var C=n.svgStyle||n.style,c=n.svgClassName||n.className;u.setStyle(C).setClassName(c),o.addChild(u),_.setDisplayable(e,n,u,"background")},c._renderNodeIndicator=function(e,n,o,a){var i=N.getNodeColor(e,n),r=t.ColorUtils.getContrastingTextColor(i),s=t.Agent.isRightToLeft(e.getCtx())?a.labelSectionWidth+a.iconSectionWidth:0,l=N.getNodeIndicatorColor(e,n);if(l){r=t.ColorUtils.getContrastingTextColor(l);var g=new t.Rect(e.getCtx(),s,0,a.indicatorSectionWidth,a.nodeHeight);g.setSolidFill(l),c._clipIfNecessary(e,g,a),o.addChild(g),_.setDisplayable(e,n,g,t.NBoxConstants.INDICATOR)}var d=_.getIndicatorIcon(e,n);if(d){var u,h=d[t.NBoxConstants.WIDTH],C=d[t.NBoxConstants.HEIGHT],x=s+a.indicatorSectionWidth/2,p=a.nodeHeight/2,f=h,b=d[t.NBoxConstants.COLOR]?d[t.NBoxConstants.COLOR]:r,y=d[t.NBoxConstants.BORDER_COLOR],S=d[t.NBoxConstants.BORDER_WIDTH],B=d[t.NBoxConstants.BORDER_RADIUS],E=d[t.NBoxConstants.PATTERN];d[t.NBoxConstants.SOURCE]?(u=new t.ImageMarker(e.getCtx(),x,p,h,C,B,d[t.NBoxConstants.SOURCE])).setPreserveAspectRatio(c._ASPECT_RATIO_SCALING):(u=new t.SimpleMarker(e.getCtx(),d[t.NBoxConstants.SHAPE],x,p,h,C,B),S>0&&(f+=S)),S&&u.setSolidStroke(y,null,S),"none"!=E?u.setFill(new t.PatternFill(E,b,i)):u.setSolidFill(b);var v=d.svgStyle||d.style,D=d.svgClassName||d.className;if(u.setStyle(v).setClassName(D),f>a.indicatorSectionWidth)if(B&&d[t.NBoxConstants.SOURCE])o.getChildContainer(!0).addChild(u);else c._clipIfNecessary(e,u,a),o.addChild(u);else o.addChild(u);_.setDisplayable(e,n,u,t.NBoxConstants.INDICATOR_ICON)}},c._renderNodeIcon=function(e,n,o,a){var i=N.getNodeColor(e,n),r=t.ColorUtils.getContrastingTextColor(i),s=t.Agent.isRightToLeft(e.getCtx()),l=_.getIcon(e,n);if(l){var g,d=(l[t.NBoxConstants.SOURCE]?l.sourcePaddingRatio:l.shapePaddingRatio)*a.nodeHeight,u=l[t.NBoxConstants.WIDTH]?l[t.NBoxConstants.WIDTH]:a.iconWidth?a.iconWidth:a.iconSectionWidth-2*d,h=l[t.NBoxConstants.HEIGHT]?l[t.NBoxConstants.HEIGHT]:a.nodeHeight-2*d,C=a[s?"labelSectionWidth":"indicatorSectionWidth"]+Math.max(a.iconSectionWidth/2,a.iconWidth?a.iconWidth/2:0),x=a.nodeHeight/2,p=l[t.NBoxConstants.COLOR]?l[t.NBoxConstants.COLOR]:r,f=l[t.NBoxConstants.BORDER_COLOR],b=l[t.NBoxConstants.BORDER_WIDTH],y=l[t.NBoxConstants.BORDER_RADIUS],S=l[t.NBoxConstants.PATTERN];l[t.NBoxConstants.SOURCE]?(g=new t.ImageMarker(e.getCtx(),C,x,u,h,y,l[t.NBoxConstants.SOURCE])).setPreserveAspectRatio(c._ASPECT_RATIO_SCALING):g=new t.SimpleMarker(e.getCtx(),l[t.NBoxConstants.SHAPE],C,x,u-b,h-b,y),b&&g.setSolidStroke(f,null,b),"none"!=S?g.setFill(new t.PatternFill(S,p,i)):g.setSolidFill(p);var B=l.svgStyle||l.style,E=l.svgClassName||l.className;if(g.setStyle(B).setClassName(E),0==a.indicatorSectionWidth||0==a.labelSectionWidth)if(y&&l[t.NBoxConstants.SOURCE])o.getChildContainer(!0).addChild(g);else c._clipIfNecessary(e,g,a),o.addChild(g);else o.addChild(g);_.setDisplayable(e,n,g,t.NBoxConstants.ICON)}},c._renderNodeLabels=function(e,n,o,a){var i=e.getOptions(),r=i.__layout.nodeInterLabelGap,s=i.__layout.nodeLabelOnlyStartLabelGap,l=i.__layout.nodeStartLabelGap,g=i.__layout.nodeEndLabelGap,d=a.indicatorSectionWidth||a.iconSectionWidth?l:s,u=N.getNodeColor(e,n),C=t.ColorUtils.getContrastingTextColor(u),c=t.Agent.isRightToLeft(e.getCtx())?a.labelSectionWidth-d:a.indicatorSectionWidth+a.iconSectionWidth+d;if(n[t.NBoxConstants.LABEL]){var x=_.getNodeLabel(e,n),p=x.getDimensions().h;if(t.TextUtils.fitText(x,a.labelSectionWidth-d-g,p,o)&&(h.positionText(x,c,a.nodeHeight/2),x.getCSSStyle()&&x.getCSSStyle().getStyle("color")?x.setSolidFill(x.getCSSStyle().getStyle("color")):x.setSolidFill(C),_.setDisplayable(e,n,x,t.NBoxConstants.LABEL)),n[t.NBoxConstants.SECONDARY_LABEL]){var f=_.getNodeSecondaryLabel(e,n),b=f.getDimensions().h;if(t.TextUtils.fitText(f,a.labelSectionWidth-d-g,b,o)){var y=(a.nodeHeight-p-b-r)/2;h.positionText(x,c,y+p/2),h.positionText(f,c,y+p+r+b/2),f.getCSSStyle()&&f.getCSSStyle().getStyle("color")?f.setSolidFill(f.getCSSStyle().getStyle("color")):f.setSolidFill(C),_.setDisplayable(e,n,f,t.NBoxConstants.SECONDARY_LABEL)}}}},c._getMaxLabelWidth=function(e,n){for(var o=[],a=0;a<n.length;a++){var i=n[a];o.push(_.getNodeLabel(e,i)),o.push(_.getNodeSecondaryLabel(e,i))}return t.TextUtils.getMaxTextDimensions(o).w},c._clipIfNecessary=function(e,n,o){var a=N.getNodeBorderRadius(e);if(a=a<c._MIN_CORNER_RADIUS?0:a){var i=o.indicatorSectionWidth+o.iconSectionWidth+o.labelSectionWidth,r=o.nodeHeight,s=new t.ClipPath;s.addRect(0,0,i,r,a,a),n.setClipPath(s)}},c.animateUpdate=function(e,n,o){var a=e.getOldNBox(),i=e.getNewNBox(),r=h.getGlobalMatrix(n),s=h.getGlobalMatrix(o),g=o.getMatrix(),d=o.getParent();n.setAlpha(0),e.getNewNBox().addChild(o),o.setMatrix(r);var u=_.getNodeScrollableContainer(a,n),C=_.getNodeScrollableContainer(i,o);if(u||C){var x,p=new t.ClipPath;if(u){var N=h.getGlobalMatrix(u),f=new t.Rectangle(N.getTx(),N.getTy(),u.getWidth(),u.getHeight()),b=_.getCellIndex(a,n.getData()),y=_.getCell(a,b),S=_.getDisplayable(a,y,"background"),B=h.getGlobalMatrix(S),E=new t.Rectangle(B.getTx(),B.getTy(),S.getWidth(),S.getHeight());x=f.getUnion(E)}if(C){var v=h.getGlobalMatrix(C),D=new t.Rectangle(v.getTx(),v.getTy(),C.getWidth(),C.getHeight()),A=_.getCellIndex(i,o.getData()),O=_.getCell(i,A),I=_.getDisplayable(i,O,"background"),L=h.getGlobalMatrix(I),m=new t.Rectangle(L.getTx(),L.getTy(),I.getWidth(),I.getHeight()),T=D.getUnion(m);x=x?x.getUnion(T):T}x&&(p.addRect(x.x,x.y,x.w,x.h),o.setClipPath(p))}var R=new t.AnimMoveTo(o.getCtx(),o,new t.Point(s.getTx(),s.getTy()),e.getAnimationDuration());t.Playable.appendOnEnd(R,function(){d.addChild(o),o.setMatrix(g),o.setClipPath(null)}),e.add(R,l.UPDATE);var w=new t.CustomAnimation(i.getCtx(),o,e.getAnimationDuration());c._animateFill(w,a,i,n,o,"background"),c._animateFill(w,a,i,n,o,t.NBoxConstants.LABEL),c._animateFill(w,a,i,n,o,t.NBoxConstants.SECONDARY_LABEL),c._animateFill(w,a,i,n,o,t.NBoxConstants.INDICATOR),c._animateFill(w,a,i,n,o,t.NBoxConstants.INDICATOR_ICON),c._animateFill(w,a,i,n,o,t.NBoxConstants.ICON),e.add(w,l.UPDATE)},c._animateFill=function(e,n,o,a,i,r){var s=_.getDisplayable(n,a.getData(),r),l=_.getDisplayable(o,i.getData(),r);s&&l&&l.getFill()instanceof t.SolidFill&&!l.getFill().equals(s.getFill())&&(e.getAnimator().addProp(t.Animator.TYPE_FILL,l,l.getFill,l.setFill,l.getFill()),l.setFill(s.getFill()))},c.animateDelete=function(e,n){var o=l.DELETE,a=e.getOldNBox(),i=e.getNewNBox(),r=a.getOptions().__layout.__nodeLayout;if(r){var s=n.getData(),g=s[t.NBoxConstants.ID],d=_.getNodeIndex(i,g);if(!isNaN(d)){var u=_.getNode(i,d);if(!_.isNodeHidden(i,u))if(o=l.UPDATE,_.getGrouping(i)){var C=i.getOptions().__groups;_.getGroupBehavior(i)==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL&&(C=C[_.getCellIndex(i,u)]);var c=C[_.getNodeGroupId(u)];if(c){var x=_.getDisplayable(i,c);if(x){var p=h.getGlobalMatrix(x),N=new t.Point((r.indicatorSectionWidth+r.iconSectionWidth+r.labelSectionWidth)/2,r.nodeHeight/2);e.add(new t.AnimMoveTo(i.getCtx(),n,new t.Point(p.getTx()-N.x,p.getTy()-N.y),e.getAnimationDuration()),o)}}}else if(s[t.NBoxConstants.ROW]!=u[t.NBoxConstants.ROW]||s[t.NBoxConstants.COLUMN]!=u[t.NBoxConstants.COLUMN]){var f=h.getGlobalMatrix(n),b=n.getDimensions();e.getNewNBox().addChild(n),n.setMatrix(f);var y=_.getCellByRowColumn(i,u[t.NBoxConstants.ROW],u[t.NBoxConstants.COLUMN]),S=_.getDisplayable(i,y.getData(),"overflow");if(S){var B=h.getGlobalMatrix(S);e.add(new t.AnimMoveTo(i.getCtx(),n,new t.Point(B.getTx(),B.getTy()),e.getAnimationDuration()),l.UPDATE)}else{var E=h.getGlobalMatrix(y),v=y.getDimensions();N=new t.Point((r.indicatorSectionWidth+r.iconSectionWidth+r.labelSectionWidth)/2,r.nodeHeight/2);e.add(new t.AnimMoveTo(i.getCtx(),n,new t.Point(E.getTx()+v.w/2-N.x,E.getTy()+v.h/2-N.y),e.getAnimationDuration()),l.UPDATE)}var D=new t.CustomAnimation(i.getCtx(),u,e.getAnimationDuration());return D.getAnimator().addProp(t.Animator.TYPE_NUMBER,n,n.getScaleX,n.setScaleX,.01),D.getAnimator().addProp(t.Animator.TYPE_NUMBER,n,n.getScaleY,n.setScaleY,.01),t.Playable.appendOnEnd(D,function(){i.getDeleteContainer().addChild(n)}),e.add(D,l.INSERT),e.add(new t.AnimMoveBy(i.getCtx(),n,new t.Point(b.w/2,b.h/2),e.getAnimationDuration()),l.INSERT),void e.add(new t.AnimFadeOut(i.getCtx(),n,e.getAnimationDuration()),l.INSERT)}}n.setMatrix(h.getGlobalMatrix(n));var A=_.getNodeScrollableContainer(a,n);if(A){var O=new t.ClipPath,I=h.getGlobalMatrix(A),L=new t.Rectangle(I.getTx(),I.getTy(),A._width,A._height);O.addRect(L.x,L.y,L.w,L.h),n.setClipPath(O)}e.add(new t.AnimFadeOut(i.getCtx(),n,e.getAnimationDuration()),o),i.getDeleteContainer().addChild(n)}},c.animateInsert=function(e,n){var o=l.INSERT,a=e.getOldNBox(),i=e.getNewNBox(),r=i.getOptions().__layout.__nodeLayout;if(r){var s=n.getData()[t.NBoxConstants.ID],g=_.getNodeIndex(a,s);if(!isNaN(g)){var d=_.getNode(a,g);if(!_.isNodeHidden(a,d)&&(o=l.UPDATE,_.getGrouping(a))){var u=a.getOptions().__groups;_.getGroupBehavior(a)==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL&&(u=u[_.getCellIndex(a,d)]);var C=u[_.getNodeGroupId(d)];if(C){var c=_.getDisplayable(a,C);if(c){var x=n.getMatrix(),p=n.getParent(),N=h.getGlobalMatrix(n),f=h.getGlobalMatrix(c),b=new t.Point((r.indicatorSectionWidth+r.iconSectionWidth+r.labelSectionWidth)/2,r.nodeHeight/2);i.addChild(n),n.setMatrix(f.translate(-b.x,-b.y));var y=new t.AnimMoveTo(i.getCtx(),n,new t.Point(N.getTx(),N.getTy()),e.getAnimationDuration());t.Playable.appendOnEnd(y,function(){n.setMatrix(x),p.addChild(n)}),e.add(y,o)}}}}var S=new t.CustomAnimation(i.getCtx(),n,e.getAnimationDuration());S.getAnimator().addProp(t.Animator.TYPE_NUMBER,n,n.getAlpha,n.setAlpha,n.getAlpha()),e.add(S,o),n.setAlpha(0)}},c._addAccessibilityAttributes=function(e,n){if(n.setAriaRole("img"),!t.Agent.deferAriaCreation()){var o=n.getAriaLabel();o&&n.setAriaProperty(t.NBoxConstants.LABEL,o)}};var x=new Object;t.Obj.createSubclass(x,t.Obj),x.render=function(t,e,n,o,a){x._renderNodeBackground(t,e,n,o,a);var i=x._renderNodeIndicator(t,e,n,o,a);x._renderNodeCount(t,e,n,o,i,a),x._addAccessibilityAttributes(t,n)},x._renderNodeBackground=function(e,n,o,a,i){n.__scale=a,n.__gap=i;var r=Math.max(0,x.getSideLength(n)),s=N.getNodeBorderRadius(e),l=N.getNodeHoverColor(e),g=N.getNodeSelectionColor(e),d=new t.Rect(e.getCtx(),-r/2,-r/2,r,r);d.setFill(null),s&&(d.setRx(s),d.setRy(s)),d.setHoverStroke(new t.Stroke(l,1,2),new t.Stroke(g,1,4)),d.setSelectedStroke(new t.Stroke(g,1,4),null),d.setSelectedHoverStroke(new t.Stroke(l,1,2),new t.Stroke(g,1,6)),o.addChild(d),o.setSelectionShape(d);var u=new t.Rect(e.getCtx(),-r/2,-r/2,r,r);s&&(u.setRx(s),u.setRy(s));var h=N.getCategoryNodeColor(e,n);u.setSolidFill(h),o.addChild(u)},x.getSideLength=function(t){return t.__scale*Math.sqrt(t.nodeIndices.length)-t.__gap},x._renderNodeIndicator=function(e,n,o,a,i){var r=!1,s=e.getOptions().__layout.markerGap,l=t.Agent.isRightToLeft(e.getCtx()),g=a*Math.sqrt(n.nodeIndices.length)-i,d=N.getCategoryNodeColor(e,n),u=t.ColorUtils.getContrastingTextColor(d),h=g/4,C=1,c=l?g/2-h:-g/2,x=N.getStyledCategoryIndicatorIcon(e,n);if(x){var p=h/(x[t.NBoxConstants.WIDTH]+2*s),f=g/(x[t.NBoxConstants.HEIGHT]+2*s);C=Math.min(p,f)}var b=N.getCategoryNodeIndicatorColor(e,n);if(b){u=t.ColorUtils.getContrastingTextColor(b);var y=new t.Rect(e.getCtx(),c,-g/2,h,g);y.setSolidFill(b),o.addChild(y),r=!0}if(x){var S=x[t.NBoxConstants.COLOR]?x[t.NBoxConstants.COLOR]:u,B=new t.SimpleMarker(e.getCtx(),x[t.NBoxConstants.SHAPE],(l?1:-1)*(g-h)/2,0,x[t.NBoxConstants.WIDTH]*C,x[t.NBoxConstants.HEIGHT]*C,x[t.NBoxConstants.BORDER_RADIUS]);x[t.NBoxConstants.BORDER_WIDTH]&&B.setSolidStroke(x[t.NBoxConstants.BORDER_COLOR],null,x[t.NBoxConstants.BORDER_WIDTH]),x[t.NBoxConstants.PATTERN]&&"none"!=x[t.NBoxConstants.PATTERN]?B.setFill(new t.PatternFill(x[t.NBoxConstants.PATTERN],S,d)):B.setSolidFill(S),B.setStyle(x.style).setClassName(x.className),o.addChild(B),_.setDisplayable(e,n,B,t.NBoxConstants.INDICATOR_ICON),r=!0}return r},x._renderNodeCount=function(e,n,o,a,i,r){var s,l=e.getOptions().__layout.categoryNodeLabelGap,g=t.Agent.isRightToLeft(e.getCtx()),d=N.getFadedNodeAlpha(e),u=_.getHighlightedItems(e),C=_.getDisplayable(e,n,"label");if(u){if(0==(s=n.highlightedCount))return C&&C.setTextString(""),void o.setAlpha(d)}else s=n.nodeIndices.length;var c=a*Math.sqrt(n.nodeIndices.length)-r,x=i?.75*c:c,p=(g?-1:1)*(c-x)/2,f=N.getCategoryNodeColor(e,n),b=t.ColorUtils.getContrastingTextColor(f),y=new t.Rectangle(0,0,x-2*l,c-2*l);C?C.setTextString(""+s):(C=h.createText(e.getCtx(),""+s,N.getCategoryNodeLabelStyle(e),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE),_.setDisplayable(e,n,C,"label"));var S=t.TextUtils.getOptimalFontSize(C.getCtx(),C.getTextString(),C.getCSSStyle(),y);C.setFontSize(S),t.TextUtils.fitText(C,x-2*l,c-2*l,o)&&(h.positionText(C,p,0),C.setSolidFill(b))},x.animateUpdate=function(e,n,o){var a=h.getGlobalMatrix(n),i=h.getGlobalMatrix(o),r=o.getMatrix(),s=o.getParent();n.setAlpha(0),e.getNewNBox().addChild(o),o.setMatrix(a);var g=new t.AnimMoveTo(o.getCtx(),o,new t.Point(i.getTx(),i.getTy()),e.getAnimationDuration());t.Playable.appendOnEnd(g,function(){s.addChild(o),o.setMatrix(r)}),e.add(g,l.UPDATE)},x.animateDelete=function(e,n){var o=l.UPDATE,a=e.getOldNBox(),i=e.getNewNBox();x.isMaximizeEqual(a,i)&&x.isGroupingEqual(a,i)&&(o=l.DELETE);var r=new t.AnimScaleTo(i.getCtx(),n,new t.Point(.01,.01),e.getAnimationDuration());e.add(r,o);var s=new t.AnimFadeOut(i.getCtx(),n,e.getAnimationDuration());e.add(s,o),n.setMatrix(h.getGlobalMatrix(n)),i.getDeleteContainer().addChild(n)},x.animateInsert=function(e,n){var o=l.UPDATE,a=e.getOldNBox(),i=e.getNewNBox();x.isMaximizeEqual(a,i)&&x.isGroupingEqual(a,i)&&(o=l.INSERT),n.setScaleX(.01),n.setScaleY(.01);var r=new t.AnimScaleTo(i.getCtx(),n,new t.Point(1,1),e.getAnimationDuration());e.add(r,o);var s=new t.CustomAnimation(i.getCtx(),n,e.getAnimationDuration());s.getAnimator().addProp(t.Animator.TYPE_NUMBER,n,n.getAlpha,n.setAlpha,n.getAlpha()),e.add(s,o),n.setAlpha(0)},x.isGroupingEqual=function(t,e){var n=_.getGroupBehavior(t),o=_.getGroupBehavior(e),a=_.getNodeCount(t),i=_.getNodeCount(e),r=!1;if(n==o&&a==i){r=!0;for(var s=0;s<a;s++){if(_.getNodeGroupId(_.getNode(t,s))!=_.getNodeGroupId(_.getNode(e,s))){r=!1;break}}}return r},x.isMaximizeEqual=function(t,e){var n=_.getMaximizedRow(t),o=_.getMaximizedColumn(t),a=_.getMaximizedRow(e),i=_.getMaximizedColumn(e);return n==a&&o==i},x._addAccessibilityAttributes=function(e,n){if(n.setAriaRole("img"),!t.Agent.deferAriaCreation()){var o=n.getAriaLabel();o&&n.setAriaProperty(t.NBoxConstants.LABEL,o)}};var p=new Object;t.Obj.createSubclass(p,t.Obj),p.render=function(e,n,o,a){var i=p.getDrawerBounds(e,n,a);n.__drawerBounds=i,o.setTranslate(i.x,i.y);var r=new t.KeyboardFocusEffect(e.getCtx(),o,new t.Rectangle(-1,-1,i.w+2,i.h+2));_.setDisplayable(e,n,r,"focusEffect"),p._renderBody(e,n,o),p._renderHeader(e,n,o),p._addAccessibilityAttributes(e,n,o)},p._renderHeader=function(e,n,o){var a=e.getOptions(),i=a.__layout.drawerButtonGap,r=a.__layout.drawerStartGap,s=a.__layout.drawerLabelGap,l=a.__layout.drawerCountHorizontalGap,g=a.__layout.drawerCountVerticalGap,d=a.__layout.drawerHeaderHeight,u=a.__layout.nodeIndicatorGap,C=a.__layout.nodeSwatchSize,c=t.Agent.isRightToLeft(e.getCtx()),x=_.getCategoryNode(e,n[t.NBoxConstants.ID]),p=x.nodeIndices.length,f=n.__drawerBounds,b=a._resources.close_ena,y=b.width;if(f.w>y){var S=a._resources.close_ovr,B=a._resources.close_dwn,E=b.height,v=new t.Image(e.getCtx(),b.src,0,0,b.width,b.height),D=new t.Image(e.getCtx(),S.src,0,0,S.width,S.height),A=new t.Image(e.getCtx(),B.src,0,0,B.width,B.height),O=new t.Button(e.getCtx(),v,D,A,null,null,o.closeDrawer,o),I=c?Math.min((f.w-y)/2,i):Math.max((f.w-y)/2,f.w-i-y);O.setTranslate(I,d/2-E/2),o.addChild(O)}var L=N.getCategoryNodeColor(e,x),m=t.ColorUtils.getContrastingTextColor(L),T=N.getCategoryNodeIndicatorColor(e,x),R=T?t.ColorUtils.getContrastingTextColor(T):m,w=N.getStyledCategoryIndicatorIcon(e,x),M=C,H=1;if(w){var G=w[t.NBoxConstants.WIDTH];M=(H=C/w[t.NBoxConstants.HEIGHT])*G,R=w[t.NBoxConstants.COLOR]?w[t.NBoxConstants.COLOR]:R}var U,F=N.getDrawerCountBorderRadius(e),P=c?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT,W=h.createText(e.getCtx(),""+p,N.getDrawerCountLabelStyle(e),P,t.OutputText.V_ALIGN_MIDDLE),k=W.getDimensions(),Y=k.w,K=k.h+2*g,z=w?M+2*u:T?C:0,V=Y+2*l,j=z+V;if(f.w-y-2*i-r>j){var X=t.PathUtils.roundedRectangle(0,0,j,K,F,F,F,F);(U=new t.Path(e.getCtx(),X)).setSolidFill(L),o.addChild(U);var q=c?V:0;if(z>0){if(T){var Z=t.PathUtils.roundedRectangle(q,0,z,K,c?0:F,c?F:0,c?F:0,c?0:F),J=new t.Path(e.getCtx(),Z);J.setSolidFill(T),U.addChild(J)}if(w){var Q=new t.SimpleMarker(e.getCtx(),w[t.NBoxConstants.SHAPE],q+z/2,K/2,w[t.NBoxConstants.WIDTH]*H,w[t.NBoxConstants.HEIGHT]*H,w[t.NBoxConstants.BORDER_RADIUS]);w[t.NBoxConstants.BORDER_WIDTH]&&Q.setSolidStroke(w[t.NBoxConstants.BORDER_COLOR],null,w[t.NBoxConstants.BORDER_WIDTH]),w[t.NBoxConstants.PATTERN]&&"none"!=w[t.NBoxConstants.PATTERN]?Q.setFill(new t.PatternFill(w[t.NBoxConstants.PATTERN],R,T||L)):Q.setSolidFill(R),Q.setStyle(w.style).setClassName(w.className),U.addChild(Q)}}U.addChild(W),W.setSolidFill(m);var $=c?V-l:z+l;h.positionText(W,$,K/2)}var tt=_.getDisplayable(e,x).getLabel(),et=h.createText(e.getCtx(),tt,N.getDrawerLabelStyle(e),P,t.OutputText.V_ALIGN_MIDDLE),nt=0;if(t.TextUtils.fitText(et,f.w-r-s-j-2*i-y,d,o)){var ot=c?f.w-r:r;h.positionText(et,ot,d/2),nt=et.getDimensions().w+s}if(U){var at=c?f.w-r-j-nt:r+nt;U.setTranslate(at,(d-K)/2)}},p._renderBody=function(e,n,a){var i=e.getOptions(),r=i.__layout.gridGap,s=i.__layout.drawerHeaderHeight,l=n.__drawerBounds,g=t.Agent.isRightToLeft(e.getCtx()),d=N.getDrawerBorderRadius(e),u=N.getDrawerBorderColor(e),C=t.PathUtils.roundedRectangle(0,0,l.w,l.h,d,d,d,d),x=new t.Path(e.getCtx(),C);h.setFill(x,N.getDrawerBackground(e)),x.setSolidStroke(u),x.setPixelHinting(!0),a.addChild(x),_.setDisplayable(e,n,x,"background"),n.__childArea=new t.Rectangle(r,s+r,Math.max(l.w-2*r,0),Math.max(l.h-s-2*r,0));var f=new t.SimpleScrollableContainer(e.getCtx(),l.w,l.h-s);f.setTranslate(0,s),a.addChild(f),a.setChildContainer(f);var b=N.getFadedNodeAlpha(e),y=_.getHighlightedItems(e),S={};if(y)for(var B=0;B<y.length;B++)S[y[B][t.NBoxConstants.ID]]=!0;for(var E=p.calculateNodeOrders(e,n),v=c.calculateNodeDrawerLayout(e,n,E),D=v.indicatorSectionWidth+v.iconSectionWidth+v.labelSectionWidth+r,A=v.nodeHeight+r,O=_.getDisplayable(e,n).getChildContainer(),I=0;I<E.length;I++){var L=E[I];if(0!=v.drawerLayout[t.NBoxConstants.COLUMNS]&&0!=v.drawerLayout[t.NBoxConstants.ROWS]){var m=new o(e,L),T=n.__childArea.x+(n.__childArea.w-v.drawerLayout[t.NBoxConstants.COLUMNS]*D+r)/2,R=r,w=I%v.drawerLayout[t.NBoxConstants.COLUMNS];g&&(w=v.drawerLayout[t.NBoxConstants.COLUMNS]-w-1);var M=Math.floor(I/v.drawerLayout[t.NBoxConstants.COLUMNS]);m.setTranslate(T+D*w,R+A*M),m.render(O.getScrollingPane(),v),y&&!S[L[t.NBoxConstants.ID]]&&m.setAlpha(b);var H=I>0?E[I-1]:null;if(H){var G=_.getDisplayable(e,H);m.previousNavigable=G,G.nextNavigable=m}}}O.prepareContentPane()},p.calculateNodeOrders=function(e,n){var o=["normal"],a=_.getHighlightedItems(e),i={};if(a)for(var r=0;r<a.length;r++)i[a[r][t.NBoxConstants.ID]]=!0;var s=_.getSelectedItems(e),l={};if(s)for(r=0;r<s.length;r++)l[s[r]]=!0;a?o=s?["highlighted-selected","highlighted-unselected","unhighlighted-selected","unhighlighted-unselected"]:["highlighted-unselected","unhighlighted-unselected"]:s&&(o=["unhighlighted-selected","unhighlighted-unselected"]);for(var g=[],d=_.getCategoryNode(e,n[t.NBoxConstants.ID]),u=d.nodeIndices.length,h=0;h<o.length;h++)for(var C=0;C<u;C++){var c=_.getNode(e,d.nodeIndices[C]);("normal"==o[h]||"highlighted-selected"==o[h]&&i[c[t.NBoxConstants.ID]]&&l[c[t.NBoxConstants.ID]]||"highlighted-unselected"==o[h]&&i[c[t.NBoxConstants.ID]]&&!l[c[t.NBoxConstants.ID]]||"unhighlighted-selected"==o[h]&&!i[c[t.NBoxConstants.ID]]&&l[c[t.NBoxConstants.ID]]||"unhighlighted-unselected"==o[h]&&!i[c[t.NBoxConstants.ID]]&&!l[c[t.NBoxConstants.ID]])&&g.push(c)}return g},p.getDrawerBounds=function(e,n,o){var a=e.getOptions().__layout.gridGap,i=C.getCellLayout(e),r=new t.Rectangle(o.x+a,o.y+a,Math.max(o.w-2*a,0),Math.max(o.h-2*a,0));if(_.getGroupBehavior(e)==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){var s=parseInt(n.id.substring(0,n[t.NBoxConstants.ID].indexOf(":")));if(_.isCellMaximized(e,s)){var l=_.getCell(e,s),g=_.getRowIndex(e,l[t.NBoxConstants.ROW]),d=_.getColumnIndex(e,l[t.NBoxConstants.COLUMN]),u=C.getCellDimensions(e,g,d,o);r=new t.Rectangle(u.x+a,u.y+a+i.maximizedHeaderSize,Math.max(u.w-2*a,0),Math.max(u.h-i.maximizedHeaderSize-2*a,0))}}return r},p.animateUpdate=function(t,e,n){console.log("********************* DvtNBoxDrawerRenderer.animateUpdate *********************")},p.animateDelete=function(e,n){var o=l.UPDATE,a=e.getNewNBox(),i=n.getData().__drawerBounds,r=n.getData()[t.NBoxConstants.ID],s=_.getCategoryNode(a,r);if(s){var g=x.getSideLength(s),d=g/i.w,u=g/i.h,C=_.getDisplayable(a,s);if(C){var c=h.getGlobalMatrix(C),p=new t.Matrix(d,0,0,u,c.getTx()-g/2,c.getTy()-g/2),N=new t.CustomAnimation(a.getCtx(),n,e.getAnimationDuration());N.getAnimator().addProp(t.Animator.TYPE_MATRIX,n,n.getMatrix,n.setMatrix,p),e.add(N,o)}}a.getDeleteContainer().addChild(n);var f=new t.AnimFadeOut(a.getCtx(),n,e.getAnimationDuration());e.add(f,o)},p.animateInsert=function(e,n){var o=l.UPDATE,a=e.getNewNBox(),i=n.getData().__drawerBounds,r=n.getData()[t.NBoxConstants.ID],s=_.getCategoryNode(a,r);if(s){var g=x.getSideLength(s),d=g/i.w,u=g/i.h,C=_.getDisplayable(a,s);if(C){var c=h.getGlobalMatrix(C),p=new t.Matrix(d,0,0,u,c.getTx()-g/2,c.getTy()-g/2),N=new t.CustomAnimation(a.getCtx(),n,e.getAnimationDuration());N.getAnimator().addProp(t.Animator.TYPE_MATRIX,n,n.getMatrix,n.setMatrix,n.getMatrix());var f=n.getParent();a.addChild(n),t.Playable.appendOnEnd(N,function(){f.addChild(n)}),n.setMatrix(p),e.add(N,o)}}n.setAlpha(0);var b=new t.AnimFadeIn(a.getCtx(),n,e.getAnimationDuration());e.add(b,o)},p._addAccessibilityAttributes=function(e,n,o){var a=t.Agent.isTouchDevice()?_.getDisplayable(e,n,"background"):o;if(a.setAriaRole("img"),!t.Agent.deferAriaCreation()){var i=o.getAriaLabel();i&&a.setAriaProperty(t.NBoxConstants.LABEL,i)}};var _=new Object;t.Obj.createSubclass(_,t.Obj),_.processDataObject=function(e){if(_.hasValidData(e)){var n=e.getOptions(),o=n[t.NBoxConstants.CELLS],a={};if(o)for(var i=0;i<o.length;i++){var r=o[i];a[c=r[t.NBoxConstants.ROW]]||(a[c]={});var s=r[t.NBoxConstants.COLUMN];a[c][s]=r}for(var l=[],g={},d={},u=0;u<_.getRowCount(e);u++){(C=_.getRow(e,u)).__cacheId="row:"+C.id,g[C[t.NBoxConstants.ID]]=u}n.__rowMap=g;for(var h=0;h<_.getColumnCount(e);h++){(x=_.getColumn(e,h)).__cacheId="column:"+x.id,d[x[t.NBoxConstants.ID]]=h}n.__columnMap=d;for(u=0;u<_.getRowCount(e);u++){var C,c=(C=_.getRow(e,u))[t.NBoxConstants.ID];for(h=0;h<_.getColumnCount(e);h++){var x;s=(x=_.getColumn(e,h))[t.NBoxConstants.ID];if(a[c]&&a[c][s]){var p=a[c][s];l.push(p)}else l.push({row:c,column:s})}}n[t.NBoxConstants.CELLS]=l;for(var N=new(e.getCtx().ojMap),f=!1,b=0;b<_.getNodeCount(e);b++){var y=_.getNode(e,b);N.set(y[t.NBoxConstants.ID],b),!f&&(y[t.NBoxConstants.GROUP_CATEGORY]||y._groupCategories||y._groupLabels)&&(f=!0)}n.__nodeMap=N,n.__grouping="none"!=n[t.NBoxConstants.GROUP_BEHAVIOR]&&f,_.getGrouping(e)&&_.getGroupBehavior(e)==t.NBoxConstants.GROUP_BEHAVIOR_ACROSS_CELLS&&(n[t.NBoxConstants.MAXIMIZED_ROW]=null,_.fireOptionChangeEvent(e,t.NBoxConstants.MAXIMIZED_ROW,null),n[t.NBoxConstants.MAXIMIZED_COLUMN]=null,_.fireOptionChangeEvent(e,t.NBoxConstants.MAXIMIZED_COLUMN,null)),(n[t.NBoxConstants.MAXIMIZED_ROW]&&isNaN(g[n[t.NBoxConstants.MAXIMIZED_ROW]])||n[t.NBoxConstants.MAXIMIZED_COLUMN]&&isNaN(d[n[t.NBoxConstants.MAXIMIZED_COLUMN]]))&&(n[t.NBoxConstants.MAXIMIZED_ROW]=null,_.fireOptionChangeEvent(e,t.NBoxConstants.MAXIMIZED_ROW,null),n[t.NBoxConstants.MAXIMIZED_COLUMN]=null,_.fireOptionChangeEvent(e,t.NBoxConstants.MAXIMIZED_COLUMN,null))}},_.hasValidData=function(e){var n=e.getOptions();return!(!n||!n[t.NBoxConstants.ROWS]||n[t.NBoxConstants.ROWS].length<1||!n[t.NBoxConstants.COLUMNS]||n[t.NBoxConstants.COLUMNS].length<1)},_.getColumnCount=function(e){return e.getOptions()[t.NBoxConstants.COLUMNS].length},_.getRowCount=function(e){return e.getOptions()[t.NBoxConstants.ROWS].length},_.getColumnLabel=function(e,n){var o=_.getColumn(e,_.getColumnIndex(e,n));return o&&o[t.NBoxConstants.LABEL]?o[t.NBoxConstants.LABEL]:null},_.getRowLabel=function(e,n){var o=_.getRow(e,_.getRowIndex(e,n));return o&&o[t.NBoxConstants.LABEL]?o[t.NBoxConstants.LABEL]:null},_.getCellByRowColumn=function(t,e,n){var o=_.getCell(t,_.getCellIndexByRowColumn(t,e,n));return o?_.getDisplayable(t,o):null},_.getCellIndexByRowColumn=function(t,e,n){return _.getColumnIndex(t,n)+_.getRowIndex(t,e)*_.getColumnCount(t)},_.getColumn=function(e,n){return e.getOptions()[t.NBoxConstants.COLUMNS][n]},_.getRow=function(e,n){return e.getOptions()[t.NBoxConstants.ROWS][n]},_.getMaximizedRow=function(e){return e.getOptions()[t.NBoxConstants.MAXIMIZED_ROW]},_.getMaximizedColumn=function(e){return e.getOptions()[t.NBoxConstants.MAXIMIZED_COLUMN]},_.getRowIndex=function(t,e){return t.getOptions().__rowMap[e]},_.getColumnIndex=function(t,e){return t.getOptions().__columnMap[e]},_.getCell=function(e,n){return e.getOptions()[t.NBoxConstants.CELLS][n]},_.getNodeCount=function(e){return e.getOptions()[t.NBoxConstants.NODES]?e.getOptions()[t.NBoxConstants.NODES].length:0},_.getNode=function(e,n){return e.getOptions()[t.NBoxConstants.NODES][n]},_.getNodeIndex=function(t,e){var n=t.getOptions().__nodeMap;return n?n.get(e):-1},_.getCellIndex=function(e,n){var o=_.getRowIndex(e,n[t.NBoxConstants.ROW]);return _.getColumnIndex(e,n[t.NBoxConstants.COLUMN])+o*_.getColumnCount(e)},_.getIcon=function(e,n){return n[t.NBoxConstants.ICON]?N.getStyledIcon(e,n[t.NBoxConstants.ICON]):null},_.getIndicatorIcon=function(e,n){return n[t.NBoxConstants.INDICATOR_ICON]?N.getStyledIndicatorIcon(e,n[t.NBoxConstants.INDICATOR_ICON]):null},_.getSelectedItems=function(e){return e.getOptions()[t.NBoxConstants.SELECTION]},_.setSelectedItems=function(e,n){e.getOptions()[t.NBoxConstants.SELECTION]=n},_.getHighlightedItems=function(e){var n,o=e.getOptions()[t.NBoxConstants.HIGHLIGHTED_CATEGORIES];if(o&&o.length>0){n=[];for(var a=0;a<_.getNodeCount(e);a++){var i=_.getNode(e,a);_.isNodeHighlighted(e,i)&&n.push(i)}}return n},_.getGrouping=function(t){return t.getOptions().__grouping},_.getGroupAttributes=function(e){return e.getOptions()[t.NBoxConstants.GROUP_ATTRIBUTES]},_.getGroupBehavior=function(e){return e.getOptions()[t.NBoxConstants.GROUP_BEHAVIOR]},_.getNodeGroupId=function(e){if(e[t.NBoxConstants.GROUP_CATEGORY])return e[t.NBoxConstants.GROUP_CATEGORY];var n=e._groupCategories;return n&&n.length>0?n.join(";"):null},_.getXPercentage=function(e,n){if(!isNaN(n[t.NBoxConstants.X_PERCENTAGE]))return n[t.NBoxConstants.X_PERCENTAGE];var o=_.getColumnCount(e);return(_.getColumnIndex(e,n[t.NBoxConstants.COLUMN])+.5)/o},_.getYPercentage=function(e,n){if(!isNaN(n[t.NBoxConstants.Y_PERCENTAGE]))return n[t.NBoxConstants.Y_PERCENTAGE];var o=_.getRowCount(e);return(_.getRowIndex(e,n[t.NBoxConstants.ROW])+.5)/o},_.getOtherThreshold=function(e){return e.getOptions()[t.NBoxConstants.OTHER_THRESHOLD]},_.getOtherColor=function(e){return e.getOptions()[t.NBoxConstants.OTHER_COLOR]},_.getDrawer=function(e){return e.getOptions()[t.NBoxConstants.DRAWER]},_.getCategoryNode=function(e,n){var o=_.getGroupBehavior(e),a=e.getOptions().__groups,i=n;if(o==t.NBoxConstants.GROUP_BEHAVIOR_WITHIN_CELL){var r=n.substring(0,n.indexOf(":"));i=n.substring(n.indexOf(":")+1),a=a[r]}return a?a[i]:null},_.getCategoryNodeLabels=function(e,n){if(n.__labels)return n.__labels;var o=_.getNode(e,n.nodeIndices[0]);if(o[t.NBoxConstants.GROUP_CATEGORY])return n.__labels=[o[t.NBoxConstants.GROUP_CATEGORY]];if(n.__labels=[],o._groupCategories)for(var a=e.getOptions()._groupLabels,i=0;i<o._groupCategories.length;i++)a&&a[o._groupCategories[i]]?n.__labels[i]=a[o._groupCategories[i]]:n.__labels[i]=o._groupCategories[i];return n.__labels},_.setDisplayable=function(t,e,n,o){var a=t.getDisplayables(),i=o?"__displayable:"+o:"__displayable",r=null==e.__cacheId?e.id:e.__cacheId,s=t.getOptions().__displayableCache,l=null==r?e[i]:s.getFromCachedMap(r,i);null!=l?a[l]=n:(null==r?e[i]=a.length:s.putToCachedMap(r,i,a.length),a.push(n))},_.getDisplayable=function(t,e,n){if(!e)return null;var o=n?"__displayable:"+n:"__displayable",a=null==e.__cacheId?e.id:e.__cacheId,i=t.getOptions().__displayableCache,r=null==a?e[o]:i.getFromCachedMap(a,o),s=t.getDisplayables();return null==r?null:s[r]},_.isMaximizeEnabled=function(t){return"off"!=t.getOptions().cellMaximize},_.getCellContent=function(t){return"counts"==t.getOptions().cellContent?"counts":"auto"},_.isCellMinimized=function(e,n){var o=_.getMaximizedRow(e),a=_.getMaximizedColumn(e);if(!o&&!a)return!1;var i=_.getCell(e,n),r=i[t.NBoxConstants.ROW],s=i[t.NBoxConstants.COLUMN];return o&&a?o!=r||a!=s:o!=r&&a!=s},_.isCellMaximized=function(e,n){var o=_.getMaximizedRow(e),a=_.getMaximizedColumn(e),i=_.getCell(e,n),r=i[t.NBoxConstants.ROW],s=i[t.NBoxConstants.COLUMN];return o==r&&a==s},_.isNodeHidden=function(e,n){var o=e.getOptions();return o[t.NBoxConstants.HIDDEN_CATEGORIES]&&!o.__hiddenMap&&(o.__hiddenMap=t.ArrayUtils.createBooleanMap(o[t.NBoxConstants.HIDDEN_CATEGORIES])),t.ArrayUtils.hasAnyMapItem(o.__hiddenMap,n[t.NBoxConstants.CATEGORIES])},_.isNodeHighlighted=function(e,n){var o=e.getOptions();return o[t.NBoxConstants.HIGHLIGHTED_CATEGORIES]&&!o.__highlightedMap&&(o.__highlightedMap=t.ArrayUtils.createBooleanMap(o[t.NBoxConstants.HIGHLIGHTED_CATEGORIES])),"all"==o[t.NBoxConstants.HIGHLIGHT_MATCH]?t.ArrayUtils.hasAllMapItems(o.__highlightedMap,n[t.NBoxConstants.CATEGORIES]):t.ArrayUtils.hasAnyMapItem(o.__highlightedMap,n[t.NBoxConstants.CATEGORIES])},_.getNodeScrollableContainer=function(t,e){if(!e)return null;var n=_.getDrawer(t);if(n){var o=_.getDisplayable(t,n);if(o)return o.getChildContainer()}var a=_.getCellIndex(t,e.getData());if(_.isCellMaximized(t,a)){var i=_.getCell(t,a);return _.getDisplayable(t,i).getChildContainer()}return null},_.getNodeLabel=function(e,n){if(!n[t.NBoxConstants.LABEL])return null;var o=_.getDisplayable(e,n,t.NBoxConstants.LABEL);if(o)return o;var a=t.Agent.isRightToLeft(e.getCtx())?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT;return o=h.createText(e.getCtx(),n[t.NBoxConstants.LABEL],N.getNodeLabelStyle(e,n),a,t.OutputText.V_ALIGN_MIDDLE),_.setDisplayable(e,n,o,t.NBoxConstants.LABEL),o},_.getNodeSecondaryLabel=function(e,n){if(!n[t.NBoxConstants.SECONDARY_LABEL])return null;var o=_.getDisplayable(e,n,t.NBoxConstants.SECONDARY_LABEL);if(o)return o;var a=t.Agent.isRightToLeft(e.getCtx())?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT;return o=h.createText(e.getCtx(),n[t.NBoxConstants.SECONDARY_LABEL],N.getNodeSecondaryLabelStyle(e,n),a,t.OutputText.V_ALIGN_MIDDLE),_.setDisplayable(e,n,o,t.NBoxConstants.SECONDARY_LABEL),o},_.fireOptionChangeEvent=function(e,n,o){var a=t.EventFactory.newOptionChangeEvent(n,o);e.processEvent(a)},_.getMaximizedCellIndex=function(t){var e=null,n=_.getMaximizedRow(t),o=_.getMaximizedColumn(t);if(n&&o){var a=_.getColumnCount(t);e=_.getColumnIndex(t,o)+a*_.getRowIndex(t,n)}return e},_.isDrawerSelected=function(e,n){var o=!1,a=_.getSelectedItems(e);if(a){for(var i={},r=0;r<a.length;r++)i[a[r]]=!0;var s=n.getData().nodeIndices;o=!0;for(var l=0;l<s.length;l++){if(!i[_.getNode(e,s[l])[t.NBoxConstants.ID]]){o=!1;break}}}return o},_.buildAriaDesc=function(e,n,o,a){var r=e.getOptions().translations,l=n instanceof i||n instanceof s?t.ResourceUtils.format(r.labelAndValue,[r.labelGroup,o]):o,g=[];if(a?g.push(r.stateSelected):g.push(r.stateUnselected),n instanceof i){var d=n.getData().nodeIndices.length;g.push(r.stateCollapsed),g.push(t.ResourceUtils.format(r.labelAndValue,[r.labelSize,d]))}else if(n instanceof s){d=_.getCategoryNode(e,n.getData()[t.NBoxConstants.ID]).nodeIndices.length;g.push(r.stateExpanded),g.push(t.ResourceUtils.format(r.labelAndValue,[r.labelSize,d]))}return t.Displayable.generateAriaLabel(l,g)},_.getFirstNavigableNode=function(t,e){var n=null;if(e.getNumChildren()>0){var i;n=e.getChildAt(0);do{(n instanceof o||n instanceof a)&&(i=n.previousNavigable),n=i||n}while(i)}return n},_.getLastNavigableNode=function(t,e){var n=null,a=e.getNumChildren();if(a>0){var i;n=e.getChildAt(a-1);do{n=(i=n instanceof o?n.nextNavigable:null)||n}while(i)}return n},_.getNextNavigableNode=function(e,n,i){var r,s=i.keyCode==t.KeyboardEvent.RIGHT_ARROW||i.keyCode==t.KeyboardEvent.DOWN_ARROW;return n instanceof o?r=s?n.nextNavigable:n.previousNavigable:n instanceof a&&(r=s?null:n.previousNavigable),r||n};var N=new Object;t.Obj.createSubclass(N,t.Obj),N.getAnimationOnDisplay=function(e){if(!e.isAnimationAllowed())return"none";var n=e.getOptions()[t.NBoxConstants.ANIMATION_ON_DISPLAY];return"auto"==n&&(n=t.BlackBoxAnimationHandler.ALPHA_FADE),n},N.getAnimationOnDataChange=function(e){return e.isAnimationAllowed()?e.getOptions()[t.NBoxConstants.ANIMATION_ON_DATA_CHANGE]:"none"},N.getAnimationDuration=function(e){return t.CSSStyle.getTimeMilliseconds(e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.ANIMATION_DURATION])/1e3},N.getColumnLabelStyle=function(e,n){var o=e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.COLUMN_LABEL_STYLE],a=_.getColumn(e,n);return a[t.NBoxConstants.LABEL_STYLE]?t.JsonUtils.merge(new t.CSSStyle(a[t.NBoxConstants.LABEL_STYLE]),o):o},N.getRowLabelStyle=function(e,n){var o=e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.ROW_LABEL_STYLE],a=_.getRow(e,n);return a[t.NBoxConstants.LABEL_STYLE]?t.JsonUtils.merge(new t.CSSStyle(a[t.NBoxConstants.LABEL_STYLE]),o):o},N.getCellStyle=function(e,n){var o=e.getOptions(),a=N._getCellStyleKeys(e,n),i=N._getCellStyleOption(e,n,a[0],a[1]),r=o[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS]["_"+a[0]],s=new t.CSSStyle;return N._getCellStyleProperties().forEach(function(e){var n=t.CSSStyle.cssStringToObjectProperty(e),o=i&&null!=i[n]?i[n]:r.getStyle(e);s.setStyle(e,o)}),s},N.getCellStyleObject=function(e,n){var o=N._getCellStyleKeys(e,n),a=N._getCellStyleOption(e,n,o[0],o[1]);return a&&N._getCellStyleProperties().forEach(function(e){delete a[t.CSSStyle.cssStringToObjectProperty(e)]}),a},N._getCellStyleKeys=function(e,n){var o=t.NBoxConstants.STYLE,a="svgStyle",i=_.getMaximizedRow(e),r=_.getMaximizedColumn(e);return _.isCellMinimized(e,n)?(o="minimizedStyle",a="minimizedSvgStyle"):!i&&!r||_.isCellMinimized(e,n)||(o="maximizedStyle",a="maximizedSvgStyle"),[o,a]},N._getCellStyleOption=function(e,n,o,a){var i=e.getOptions(),r=_.getCell(e,n),s=i[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS],l=s[a]||s[o];!l||l instanceof Object||(l=t.CSSStyle.cssStringToObject(l));var g=r[a]||r[o];return g?(g instanceof Object||(g=t.CSSStyle.cssStringToObject(g)),g=t.JsonUtils.merge(g,l)):l&&(g=t.JsonUtils.clone(l)),g},N._getCellStyleProperties=function(){return[t.CSSStyle.BACKGROUND,t.CSSStyle.BACKGROUND_COLOR,t.CSSStyle.BORDER_STYLE,t.CSSStyle.BORDER_COLOR,t.CSSStyle.BORDER_WIDTH]},N.getCellClassName=function(t,e){var n="className",o="svgClassName",a=_.getMaximizedRow(t),i=_.getMaximizedColumn(t);_.isCellMinimized(t,e)?(n="minimizedClassName",o="minimizedSvgClassName"):!a&&!i||_.isCellMinimized(t,e)||(n="maximizedClassName",o="maximizedSvgClassName");var r=_.getCell(t,e);return r[o]||r[n]},N.getCellLabelStyle=function(e,n){var o=e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS][t.NBoxConstants.LABEL_STYLE],a=_.getCell(e,n);return a[t.NBoxConstants.LABEL_STYLE]?t.JsonUtils.merge(new t.CSSStyle(a[t.NBoxConstants.LABEL_STYLE]),o):o},N.getCellShowCount=function(e,n){return n[t.NBoxConstants.SHOW_COUNT]?n[t.NBoxConstants.SHOW_COUNT]:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS][t.NBoxConstants.SHOW_COUNT]},N.getCellCountLabelStyle=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS].countLabelStyle},N.getCellBodyCountLabelStyle=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS].bodyCountLabelStyle},N.getCellDropTargetStyle=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS].dropTargetStyle},N.getNodeLabelStyle=function(e,n){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.LABEL_STYLE]},N.getNodeSecondaryLabelStyle=function(e,n){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.SECONDARY_LABEL_STYLE]},N.getNodeColor=function(e,n){return n[t.NBoxConstants.COLOR]?n[t.NBoxConstants.COLOR]:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.COLOR]},N.getNodeBorderColor=function(e,n){var o=n[t.NBoxConstants.BORDER_COLOR]?n[t.NBoxConstants.BORDER_COLOR]:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.BORDER_COLOR];return o||null},N.getNodeBorderWidth=function(e,n){var o=n[t.NBoxConstants.BORDER_WIDTH]?n[t.NBoxConstants.BORDER_WIDTH]:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.BORDER_WIDTH];return o||null},N.getNodeIndicatorColor=function(e,n){return n[t.NBoxConstants.INDICATOR_COLOR]?n[t.NBoxConstants.INDICATOR_COLOR]:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_COLOR]},N.getStyledIcon=function(e,n){return t.JsonUtils.merge(n,e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.ICON_DEFAULTS])},N.getStyledIndicatorIcon=function(e,n){return t.JsonUtils.merge(n,e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_ICON_DEFAULTS])},N.getFadedNodeAlpha=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS].alphaFade},N.getScrollbarStyleMap=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS].__scrollbar},N.getCategoryNodeColor=function(e,n){if("none"==_.getGroupBehavior(e)||_.getGroupAttributes(e)&&-1==_.getGroupAttributes(e).indexOf("color"))return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.COLOR];if(n.otherNode)return _.getOtherColor(e);var o=n.nodeIndices,a=_.getNode(e,o[0])[t.NBoxConstants.COLOR];if(!a)return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.COLOR];for(var i=1;i<o.length;i++){if(a!=_.getNode(e,o[i])[t.NBoxConstants.COLOR])return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.COLOR]}return a},N.getCategoryNodeIndicatorColor=function(e,n){if("none"==_.getGroupBehavior(e)||_.getGroupAttributes(e)&&-1==_.getGroupAttributes(e).indexOf("indicatorColor"))return null;var o=n.nodeIndices,a=_.getNode(e,o[0])[t.NBoxConstants.INDICATOR_COLOR];if(!a)return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_COLOR];for(var i=1;i<o.length;i++){if(a!=_.getNode(e,o[i])[t.NBoxConstants.INDICATOR_COLOR])return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_COLOR]}return a},N.getStyledCategoryIndicatorIcon=function(e,n){if("none"==_.getGroupBehavior(e))return null;if(_.getGroupAttributes(e)&&-1==_.getGroupAttributes(e).indexOf("indicatorIconShape")&&-1==_.getGroupAttributes(e).indexOf("indicatorIconColor")&&-1==_.getGroupAttributes(e).indexOf("indicatorIconPattern"))return null;var o={},a=n.nodeIndices,i=_.getNode(e,a[0])[t.NBoxConstants.INDICATOR_ICON];if(!i)return null;i.width&&(o.width=i.width),i.height&&(o.height=i.height),i.borderWidth&&(o.borderWidth=i.borderWidth),i.borderStyle&&(o.borderStyle=i.borderStyle),i.borderColor&&(o.borderColor=i.borderColor),i.borderRadius&&(o.borderRadius=i.borderRadius),i.style&&(o.style=i.style),i.className&&(o.className=i.className);var r=!0;if(!_.getGroupAttributes(e)||-1!=_.getGroupAttributes(e).indexOf("indicatorIconShape")){for(var s=i[t.NBoxConstants.SHAPE],l=1;l<a.length;l++){(C=_.getNode(e,a[l])[t.NBoxConstants.INDICATOR_ICON])&&s!=C[t.NBoxConstants.SHAPE]&&(r=!1)}o[t.NBoxConstants.SHAPE]=r?s:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_ICON_DEFAULTS][t.NBoxConstants.SHAPE]}if(r=!0,!_.getGroupAttributes(e)||-1!=_.getGroupAttributes(e).indexOf("indicatorIconColor")){for(var g=i[t.NBoxConstants.COLOR],d=1;d<a.length;d++){(C=_.getNode(e,a[d])[t.NBoxConstants.INDICATOR_ICON])&&g!=C[t.NBoxConstants.COLOR]&&(r=!1)}o[t.NBoxConstants.COLOR]=r?g:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_ICON_DEFAULTS][t.NBoxConstants.COLOR]}if(r=!0,!_.getGroupAttributes(e)||-1!=_.getGroupAttributes(e).indexOf("indicatorIconPattern")){for(var u=i[t.NBoxConstants.PATTERN],h=1;h<a.length;h++){var C;(C=_.getNode(e,a[h])[t.NBoxConstants.INDICATOR_ICON])&&u!=C[t.NBoxConstants.PATTERN]&&(r=!1)}o[t.NBoxConstants.PATTERN]=r?u:e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_ICON_DEFAULTS][t.NBoxConstants.PATTERN]}return t.JsonUtils.merge(o,e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.INDICATOR_ICON_DEFAULTS])},N.getDrawerBackground=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._drawerDefaults.background},N.getDrawerHeaderBackground=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._drawerDefaults.headerBackground},N.getDrawerBorderColor=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._drawerDefaults[t.NBoxConstants.BORDER_COLOR]},N.getDrawerBorderRadius=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._drawerDefaults[t.NBoxConstants.BORDER_RADIUS]},N.getDrawerLabelStyle=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._drawerDefaults[t.NBoxConstants.LABEL_STYLE]},N.getDrawerCountLabelStyle=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._drawerDefaults.countLabelStyle},N.getDrawerCountBorderRadius=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._drawerDefaults.countBorderRadius},N.getCategoryNodeLabelStyle=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS]._categoryNodeDefaults.labelStyle},N.getNodeBorderRadius=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS][t.NBoxConstants.BORDER_RADIUS]},N.getNodeHoverColor=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS].hoverColor},N.getNodeSelectionColor=function(e){return e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.NODE_DEFAULTS].selectionColor},N.getLabelHalign=function(e,n){var o=n[t.NBoxConstants.LABEL_HALIGN];o||(o=e.getOptions()[t.NBoxConstants.STYLE_DEFAULTS][t.NBoxConstants.CELL_DEFAULTS][t.NBoxConstants.LABEL_HALIGN]);var a=t.Agent.isRightToLeft(e.getCtx());return"end"==o?a?t.OutputText.H_ALIGN_LEFT:t.OutputText.H_ALIGN_RIGHT:"center"==o?t.OutputText.H_ALIGN_CENTER:a?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT};var f={create:function(t,e){return{x:t,y:e}},add:function(t,e){return f.create(t.x+e.x,t.y+e.y)},subtract:function(t,e){return f.create(t.x-e.x,t.y-e.y)},scale:function(t,e){return f.create(t.x*e,t.y*e)},getMagnitude:function(t){return Math.sqrt(t.x*t.x+t.y*t.y)}}}(dvt);
  return dvt;
});
