/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){t.OverviewUtils=new Object,t.OverviewUtils.supportsTouch=function(){return t.Agent.isTouchDevice()},t.Obj.createSubclass(t.OverviewUtils,t.Obj),t.OverviewUtils.getDatePosition=function(t,i,e,n){var o=(e-t)*n,r=i-t;return 0==o||0==r?0:o/r},t.OverviewUtils.getPositionDate=function(t,i,e,n){var o=e*(i-t);return 0==o||0==n?t:o/n+t},t.Overview=function(t,i,e){this.Init(t,i,e)},t.Obj.createSubclass(t.Overview,t.Container),t.Overview.MIN_WINDOW_SIZE=10,t.Overview.DEFAULT_VERTICAL_TIMEAXIS_SIZE=40,t.Overview.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE=20,t.Overview.HANDLE_PADDING_SIZE=20,t.Overview.prototype.Init=function(i,n,o){t.Overview.superclass.Init.call(this,i),this.initDefaults(),this._callback=n,this._callbackObj=o,this._lastChildIndex=6,(null!=this._callback||null!=this._callbackObj)&&(this.EventManager=new e(this,i,n,o),this.EventManager.addListeners(this),t.OverviewUtils.supportsTouch()?(this.addEvtListener(t.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.addEvtListener(t.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.addEvtListener(t.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.addEvtListener(t.MouseEvent.CLICK,this.HandleShapeClick,!1,this)):(this.addEvtListener(t.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.addEvtListener(t.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.addEvtListener(t.MouseEvent.CLICK,this.HandleShapeClick,!1,this)))},t.Overview.prototype.initDefaults=function(){this.Defaults=new i},t.Overview.prototype.setViewportRange=function(t,i,e,o){if(null!=t&&null!=i){var r=this.getDateXPosition(t),s=this.getDateXPosition(i);if(s>r){r<this.getMinimumPositionX()&&(r=this.getMinimumPositionX()),s>this.getMaximumPositionX()&&(s=this.getMaximumPositionX());var a=Math.max(s-r,this.getMinimumWindowWidth()),l=this.getSlidingWindow();this.isRTL()?this.setSlidingWindowPosX(l,this.Width-(r+a)):this.setSlidingWindowPosX(l,r),n._setSlidingWindowWidth(this,l,a)}}if(null!=e&&null!=o){var h=this.getDateYPosition(e),d=this.getDateYPosition(o);if(d>h){h<this.getMinimumPositionY()&&(h=this.getMinimumPositionY()),d>this.getMaximumPositionY()&&(d=this.getMaximumPositionY());var g=Math.max(d-h,this.getMinimumWindowHeight());l=this.getSlidingWindow(),this.setSlidingWindowPosY(l,h),n._setSlidingWindowHeight(this,l,g)}}n._updateBorderAroundSlidingWindow(this)},t.Overview.prototype.isFeatureOff=function(t){return null!=this._featuresOff&&-1!=this._featuresOff.indexOf(t)},t.Overview.prototype.isAnimationOnClick=function(){return!("off"===this._animationOnClick)},t.Overview.prototype.render=function(i,e,o){if(null!=e&&null!=o&&(this.Width=e,this.Height=o),null==i){var r=this.getSlidingWindow();if(this._xMin&&this._xMax){var s=this.getSlidingWindowPosX(r);null!=r&&0!=s&&(this._x1=t.OverviewUtils.getPositionDate(this._xMin,this._xMax,s,this.Width))}this._yMin&&this._yMax&&(s=this.getSlidingWindowPosY(r),null!=r&&0!=s&&(this._y1=t.OverviewUtils.getPositionDate(this._yMin,this._yMax,s,this.Height))),this.removeChildren()}else{this.SetOptions(i);var a=this.Parse(this.Options);this._applyParsedProperties(a)}n.renderOverview(this)},t.Overview.prototype.SetOptions=function(t){this.Options=this.Defaults.calcOptions(t)},t.Overview.prototype.getParser=function(i){return new t.OverviewParser(this)},t.Overview.prototype.Parse=function(t){return this.getParser(t).parse(t)},t.Overview.prototype._applyParsedProperties=function(i){this._xMin=i.xMin,this._xMax=i.xMax,this._x1=i.x1,this._x2=i.x2,this._yMin=i.yMin,this._yMax=i.yMax,this._y1=i.y1,this._y2=i.y2,this._currentTime=i.currentTime,this._animationOnClick=i.animationOnClick,this._leftMargin=Math.max(0,i.leftMargin),this._rightMargin=Math.max(0,i.rightMargin),isNaN(this._leftMargin)&&(this._leftMargin=0),isNaN(this._rightMargin)&&(this._rightMargin=0),this._orientation=i.orientation,this._isRtl=i.isRtl,null!=i.featuresOff&&(this._featuresOff=i.featuresOff.split(" ")),null!=i.minimumWindowSize&&i.minimumWindowSize>0&&(this._minimumWindowSize=i.minimumWindowSize),this._timeAxisInfo=i.timeAxisInfo,null!=i.timeAxisInfo&&(this._ticks=this._timeAxisInfo.ticks),this._formattedTimeRanges=i.formattedTimeRanges,this._borderTopStyle=o.getBorderTopStyle(this.Options),this._borderTopColor=o.getBorderTopColor(this.Options),this._windowBackgroundColor=o.getWindowBackgroundColor(this.Options),this._windowBackgroundAlpha=o.getWindowBackgroundAlpha(this.Options),this._windowBorderTopStyle=o.getWindowBorderTopStyle(this.Options),this._windowBorderRightStyle=o.getWindowBorderRightStyle(this.Options),this._windowBorderBottomStyle=o.getWindowBorderBottomStyle(this.Options),this._windowBorderLeftStyle=o.getWindowBorderLeftStyle(this.Options),this._windowBorderTopColor=o.getWindowBorderTopColor(this.Options),this._windowBorderRightColor=o.getWindowBorderRightColor(this.Options),this._windowBorderBottomColor=o.getWindowBorderBottomColor(this.Options),this._windowBorderLeftColor=o.getWindowBorderLeftColor(this.Options),this._handleTextureColor=o.getHandleTextureColor(this.Options),this._handleFillColor=o.getHandleFillColor(this.Options),this._horHandleBackgroundImage=o.getHandleBackgroundImage(this.Options,!1),this._horHandleWidth=o.getHandleWidth(this.Options,!1),this._horHandleHeight=o.getHandleHeight(this.Options,!1),this._vertHandleBackgroundImage=o.getHandleBackgroundImage(this.Options,!0),this._vertHandleWidth=o.getHandleWidth(this.Options,!0),this._vertHandleHeight=o.getHandleHeight(this.Options,!0),this._overviewBackgroundColor=o.getOverviewBackgroundColor(this.Options),this._currentTimeIndicatorColor=o.getCurrentTimeIndicatorColor(this.Options),this._timeIndicatorColor=o.getTimeIndicatorColor(this.Options),this._timeAxisBarColor=o.getTimeAxisBarColor(this.Options),this._timeAxisBarOpacity=o.getTimeAxisBarAlpha(this.Options),this._leftFilterPanelColor=o.getLeftFilterPanelColor(this.Options),this._leftFilterPanelAlpha=o.getLeftFilterPanelAlpha(this.Options),this._rightFilterPanelColor=o.getRightFilterPanelColor(this.Options),this._rightFilterPanelAlpha=o.getRightFilterPanelAlpha(this.Options),this._labelStyle=new t.CSSStyle("font-weight:bold")},t.Overview.prototype.getDateXPosition=function(i){return Math.max(this.getMinimumPositionX(),t.OverviewUtils.getDatePosition(this._xMin,this._xMax,i,this.getOverviewWidth())+this._leftMargin)},t.Overview.prototype.getDateYPosition=function(i){return Math.max(this.getMinimumPositionY(),t.OverviewUtils.getDatePosition(this._yMin,this._yMax,i,this.getOverviewHeight()))},t.Overview.prototype.getXPositionDate=function(i){return t.OverviewUtils.getPositionDate(this._xMin,this._xMax,Math.max(this.getMinimumPositionX()-this._leftMargin,i-this._leftMargin),this.getOverviewWidth())},t.Overview.prototype.getYPositionDate=function(i){return t.OverviewUtils.getPositionDate(this._yMin,this._yMax,Math.max(this.getMinimumPositionY(),i),this.getOverviewHeight())},t.Overview.prototype.isRTL=function(){return"true"==this._isRtl},t.Overview.prototype.isHorizontalRTL=function(){return this.isRTL()&&!this.isVertical()},t.Overview.prototype.isVertical=function(){return"vertical"==this._orientation},t.Overview.prototype.isOverviewAbove=function(){return"above"==this.Options.overviewPosition},t.Overview.prototype.setMargins=function(t,i){!isNaN(t)&&null!=t&&t>0&&(this._leftMargin=t),!isNaN(i)&&null!=i&&i>0&&(this._rightMargin=i)},t.Overview.prototype.getOverviewSize=function(){return this.isVertical()?this.Height-this._leftMargin-this._rightMargin:this.Width-this._leftMargin-this._rightMargin},t.Overview.prototype.getOverviewWidth=function(){return this.Width-this._leftMargin-this._rightMargin},t.Overview.prototype.getOverviewHeight=function(){return this.Height},t.Overview.prototype.getMinimumPositionX=function(){return this._leftMargin},t.Overview.prototype.getMinimumPositionY=function(){return 0},t.Overview.prototype.getMaximumPositionX=function(){return this.Width-this._rightMargin},t.Overview.prototype.getMaximumPositionY=function(){return this.Height},t.Overview.prototype.getMinimumWindowWidth=function(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=t.OverviewUtils.getDatePosition(this._xMin,this._xMax,this._xMin+this._minimumWindowSize,this.getOverviewWidth()),this._minWinSize):t.Overview.MIN_WINDOW_SIZE},t.Overview.prototype.getMinimumWindowHeight=function(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=t.OverviewUtils.getDatePosition(this._yMin,this._yMax,this._yMin+this._minimumWindowSize,this.getOverviewHeight()),this._minWinSize):t.Overview.MIN_WINDOW_SIZE},t.Overview.prototype.getMaximumWindowWidth=function(){return this.Width},t.Overview.prototype.getMaximumWindowHeight=function(){return this.Height},t.Overview.prototype.getGrippySize=function(){return 10},t.Overview.prototype.getHandleStart=function(){return t.OverviewUtils.supportsTouch()?this.getHandleSize()/2:0},t.Overview.prototype.getHandleSize=function(){return t.OverviewUtils.supportsTouch()?30:10},t.Overview.prototype.isHandle=function(t){var i=t.getId();return"lh"==i||"rh"==i||"lhb"==i||"rhb"==i||"th"==i||"bh"==i||"thb"==i||"bhb"==i||"hgrpy"==i||"vgrpy"==i||"lbgrh"==i||"rbgrh"==i||null!=t.getParent()&&("hgrpy"==t.getParent().getId()||"vgrpy"==t.getParent().getId())},t.Overview.prototype.isLeftOrRightHandle=function(t){var i=t.getId();return"lh"==i||"rh"==i||"lhb"==i||"rhb"==i||"hgrpy"==i||"lbgrh"==i||"rbgrh"==i||null!=t.getParent()&&"hgrpy"==t.getParent().getId()},t.Overview.prototype.isTopOrBottomHandle=function(t){var i=t.getId();return"th"==i||"bh"==i||"thb"==i||"bhb"==i||"vgrpy"==i||null!=t.getParent()&&"vgrpy"==t.getParent().getId()},t.Overview.prototype.getTimeAxisWidth=function(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisWidth){var i=parseInt(this._timeAxisInfo.width,10);!isNaN(i)&&i<this.Width?this._timeAxisWidth=i:this._timeAxisWidth=t.Overview.DEFAULT_VERTICAL_TIMEAXIS_SIZE}return this._timeAxisWidth},t.Overview.prototype.getTimeAxisHeight=function(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisHeight){var i=parseInt(this._timeAxisInfo.height,10);!isNaN(i)&&i<this.Height?this._timeAxisHeight=i:this._timeAxisHeight=t.Overview.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE}return this._timeAxisHeight},t.Overview.prototype.getPageX=function(i){return t.OverviewUtils.supportsTouch()&&null!=i.targetTouches?i.targetTouches.length>0?i.targetTouches[0].pageX:null:i.pageX},t.Overview.prototype.getPageY=function(i){return t.OverviewUtils.supportsTouch()&&null!=i.targetTouches?i.targetTouches.length>0?i.targetTouches[0].pageY:null:i.pageY},t.Overview.prototype.isBackgroundRendered=function(){return!0},t.Overview.prototype.isLeftAndRightFilterRendered=function(){return!1},t.Overview.prototype.getSlidingWindow=function(){return this.getChildAt(1)},t.Overview.prototype.getSlidingWindowWidth=function(){if(this.isHorizontalScrollingEnabled()){var i=Math.max(this.getMinimumPositionX(),t.OverviewUtils.getDatePosition(this._xMin,this._xMax,this._x1,this.Width));return Math.min(this.getMaximumPositionX(),Math.max(this.getMinimumPositionX(),t.OverviewUtils.getDatePosition(this._xMin,this._xMax,this._x2,this.Width)))-i}return this.Width},t.Overview.prototype.getSlidingWindowHeight=function(){if(this.isVerticalScrollingEnabled()){var i=Math.max(this.getMinimumPositionY(),t.OverviewUtils.getDatePosition(this._yMin,this._yMax,this._y1,this.Height));return Math.min(this.getMaximumPositionY(),Math.max(this.getMinimumPositionY(),t.OverviewUtils.getDatePosition(this._yMin,this._yMax,this._y2,this.Height)))-i}return this.Height},t.Overview.prototype.getLeftBackground=function(){return this.isLeftAndRightFilterRendered()?this.getChildAt(3):null},t.Overview.prototype.getRightBackground=function(){return this.isLeftAndRightFilterRendered()?this.getChildAt(4):null},t.Overview.prototype.getLeftBackgroundHandle=function(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(5):null},t.Overview.prototype.getRightBackgroundHandle=function(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(6):null},t.Overview.prototype.getLeftHandle=function(){return this._leftHandle},t.Overview.prototype.getRightHandle=function(){return this._rightHandle},t.Overview.prototype.getLeftTopBar=function(){var t=this._lastChildIndex-2;return this.getChildAt(this.getNumChildren()-t)},t.Overview.prototype.getRightTopBar=function(){var t=this._lastChildIndex-3;return this.getChildAt(this.getNumChildren()-t)},t.Overview.prototype.getBottomBar=function(){var t=this._lastChildIndex-4;return this.getChildAt(this.getNumChildren()-t)},t.Overview.prototype.getTopBar=function(){var t=this._lastChildIndex-5;return this.getChildAt(this.getNumChildren()-t)},t.Overview.prototype.setLinePos=function(t,i,e){this.isVertical()?(-1!=i&&t.setY1(i),-1!=e&&t.setY2(e)):(-1!=i&&t.setX1(i),-1!=e&&t.setX2(e))},t.Overview.prototype.setLinePosX=function(t,i,e){-1!=i&&t.setX1(i),-1!=e&&t.setX2(e)},t.Overview.prototype.setLinePosY=function(t,i,e){-1!=i&&t.setY1(i),-1!=e&&t.setY2(e)},t.Overview.prototype.getLinePos1=function(t){return this.isVertical()?t.getY1():t.getX1()},t.Overview.prototype._findDrawable=function(t){var i=t.target;if(null!=i){var e=i.getId();if(null==e)return null;if("_border"==e.substr(e.length-7))return this.getChildAfter(i);if("tick"!=e.substr(0,4)&&"ltb"!=e&&"rtb"!=e&&"bb"!=e&&"tab"!=e)return i}return null},t.Overview.prototype.isMovable=function(t){return!("window"!=t.getId()&&"ftr"!=t.getId()&&"sta"!=t.getId()&&!this.isHandle(t))},t.Overview.prototype.setRectPos=function(t,i){this.isVertical()?t.setY(i):t.setX(i)},t.Overview.prototype.getRectPos=function(t){return this.isVertical()?t.getY():t.getX()},t.Overview.prototype.getRectSize=function(t){return this.isVertical()?t.getHeight():t.getWidth()},t.Overview.prototype.setRectSize=function(t,i){this.isVertical()?t.setHeight(i):t.setWidth(i)},t.Overview.prototype.getSlidingWindowPos=function(t){return this.isVertical()?t.getTranslateY():t.getTranslateX()},t.Overview.prototype.getSlidingWindowPosX=function(t){return t.getTranslateX()},t.Overview.prototype.getSlidingWindowPosY=function(t){return t.getTranslateY()},t.Overview.prototype.setSlidingWindowPosX=function(i,e){if(e=Math.max(this.getMinimumPositionX(),e),i.setTranslateX(e),this.isLeftAndRightFilterRendered()){this.getLeftBackground().setWidth(e);var n=e+this.getSlidingWindowSize(i),o=this.getRightBackground();if(o.setX(n),o.setWidth(Math.max(0,this.Width-n)),t.OverviewUtils.supportsTouch()&&!this.isFeatureOff("zoom")){var r=this.getHandleStart();this.getLeftBackgroundHandle().setX(e-r),this.getRightBackgroundHandle().setX(n)}}},t.Overview.prototype.setSlidingWindowPosY=function(t,i){i=Math.max(this.getMinimumPositionY(),i),t.setTranslateY(i)},t.Overview.prototype.getSlidingWindowSize=function(t){return this.getRectSize(t)},t.Overview.prototype.renderData=function(t,i){},t.Overview.prototype.animateSlidingWindow=function(i,e){var n=this.getSlidingWindow();if(null!=i&&i!=this.getSlidingWindowPosX(n)||null!=e&&e!=this.getSlidingWindowPosY(n)){var o=this.getLeftHandle(),r=this.getRightHandle(),s=this.getLeftTopBar(),a=this.getRightTopBar(),l=this.getBottomBar(),h=this.getTopBar(),d=!1,g=this.isAnimationOnClick()?new t.Animator(this.getCtx(),.5,0,t.Easing.linear):null;if(this.isVerticalScrollingEnabled()&&null!=e){var u=n.getTranslateY,v=n.setTranslateY,w=o.getY1,c=o.setY1,p=o.getY2,_=o.setY2,f=r.getY1,m=r.setY1,P=r.getY2,S=r.setY2,y=l.getY1,O=l.setY1,C=l.getY2,x=l.setY2,W=h.getY1,T=h.setY1,H=h.getY2,M=h.setY2,b=this.getMinimumPositionY(),D=this.getMaximumPositionY(),B=n.getHeight();e=Math.max(b,Math.min(D-B,e)),this.animateProperty(g,n,u,v,e),this.isVertical()?(this.animateProperty(g,o,w,c,e),this.animateProperty(g,o,p,_,e),this.animateProperty(g,r,f,m,e+B),this.animateProperty(g,r,P,S,e+B),this.animateProperty(g,l,y,O,e),this.animateProperty(g,h,W,T,e),this.animateProperty(g,l,C,x,e+B),this.animateProperty(g,h,H,M,e+B),this.animateProperty(g,s,s.getY2,s.setY2,e+1),this.animateProperty(g,a,a.getY1,a.setY1,e+B-1)):(this.animateProperty(g,o,w,c,e),this.animateProperty(g,o,p,_,e+B),this.animateProperty(g,r,f,m,e),this.animateProperty(g,r,P,S,e+B),this.animateProperty(g,l,y,O,e+B),this.animateProperty(g,h,W,T,e),this.animateProperty(g,l,C,x,e+B),this.animateProperty(g,h,H,M,e)),d=!0}if(this.isHorizontalScrollingEnabled()&&null!=i){var X=n.getTranslateX,L=n.setTranslateX,A=o.getX1,E=o.setX1,R=o.getX2,I=o.setX2,Y=r.getX1,k=r.setX1,F=r.getX2,U=r.setX2,z=l.getX1,N=l.setX1,V=l.getX2,G=l.setX2,j=h.getX1,Z=h.setX1,K=h.getX2,q=h.setX2,J=this.getMinimumPositionX(),Q=this.getMaximumPositionX(),$=n.getWidth();i=Math.max(J,Math.min(Q-$,i)),this.animateProperty(g,n,X,L,i),this.animateProperty(g,o,A,E,i),this.animateProperty(g,o,R,I,i),this.animateProperty(g,r,Y,k,i+$),this.animateProperty(g,r,F,U,i+$),this.isVertical()||(this.animateProperty(g,s,s.getX2,s.setX2,i+1),this.animateProperty(g,a,a.getX1,a.setX1,i+$-1)),this.animateProperty(g,l,z,N,i),this.animateProperty(g,h,j,Z,i),this.animateProperty(g,l,V,G,i+$),this.animateProperty(g,h,K,q,i+$),d=!0}if(this.isLeftAndRightFilterRendered()){var tt=this.getLeftBackground(),it=tt.getWidth,et=tt.setWidth;this.animateProperty(g,tt,it,et,i);var nt=i+$,ot=this.getRightBackground(),rt=ot.getWidth,st=ot.setWidth,at=ot.getX,lt=ot.setX;if(this.animateProperty(g,ot,rt,st,this.Width-nt),this.animateProperty(g,ot,at,lt,nt),t.OverviewUtils.supportsTouch()&&!this.isFeatureOff("zoom")){var ht=this.getHandleStart(),dt=this.getLeftBackgroundHandle(),gt=dt.getX,ut=dt.setX,vt=this.getRightBackgroundHandle(),wt=vt.getX,ct=vt.setX;this.animateProperty(g,dt,gt,ut,i-ht),this.animateProperty(g,vt,wt,ct,nt)}d=!0}null!=g&&d&&g.play()}},t.Overview.prototype.animateProperty=function(i,e,n,o,r){null!=i?i.addProp(t.Animator.TYPE_NUMBER,e,n,o,r):o.call(e,r)},t.Overview.prototype.HandleShapeMouseOver=function(i){var e=this._findDrawable(i);if(e&&"bg"!=e.getId()&&"ocd"!=e.getId())if("label"==e.getId().substr(0,5)&&(e instanceof t.OutputText||e instanceof t.BackgroundOutputText))e.isTruncated()&&this.getCtx().getTooltipManager().showDatatip(i.pageX,i.pageY,e._rawText,"#000000");else if("window"!=e.getId()&&"ftr"!=e.getId()&&"arr"!=e.getId()&&!this.isHandle(e))return e},t.Overview.prototype.HandleShapeMouseOut=function(t){null==this._moveDrawable&&this.setCursor("default");var i=this._findDrawable(t);if(null!=i)return i},t.Overview.prototype.HandleShapeClick=function(i,e,n){i.stopPropagation();var o=this._findDrawable(i);if(o&&"window"!=o.getId()&&!this.isHandle(o)){if("bg"!=o.getId()&&"label"!=o.getId().substr(0,5)&&"ocd"!=o.getId()&&"lbg"!=o.getId()&&"rbg"!=o.getId())return o;null==e&&(e=i.pageX),null==n&&(n=i.pageY);var r=this.getCtx().pageToStageCoords(e,n);r=this.stageToLocal(r);var s,a,l,h,d=this.getSlidingWindow();if(this.isVerticalScrollingEnabled())var g=r.y,u=this.Height,v=g-d.getHeight()/2;if(this.isHorizontalScrollingEnabled()){var w=r.x,c=this.Width,p=w-d.getWidth()/2;this.isRTL()&&(w=c-w)}if(this.animateSlidingWindow(p,v),null!=p){var _=d.getWidth();p=Math.max(this.getMinimumPositionX(),Math.min(p,c-_)),this.isRTL()?(s=this.getXPositionDate(c-(p+_)),a=this.getXPositionDate(c-p)):(s=this.getXPositionDate(p),a=this.getXPositionDate(p+_))}if(null!=v){var f=d.getHeight();v=Math.max(this.getMinimumPositionY(),Math.min(v,u-f)),l=this.getYPositionDate(v),h=this.getYPositionDate(v+f)}var m=t.EventFactory.newOverviewEvent("scrollTime",s,a,l,h);this.dispatchEvent(m)}},t.Overview.prototype.beginDragPan=function(i,e,n){var o=this._findDrawable(i);if(null!=o&&this.isMovable(o)){if("ftr"!=o.getId()&&"sta"!=o.getId()||(o=this.getSlidingWindow()),this._initX=e,this._initY=n,this.isHandle(o)){var r=this.getSlidingWindow();"hgrpy"!=o.getParent().getId()&&"vgrpy"!=o.getParent().getId()||(o=o.getParent());var s=o.getId();"hgrpy"!=s&&"vgrpy"!=s||(s=(o=r.getChildBefore(o)).getId()),"lh"!=s&&"rh"!=s&&"th"!=s&&"bh"!=s||(s=(o=r.getChildBefore(o)).getId()),"lbgrh"==s&&(o=r.getChildAt(0)),"rbgrh"==s&&(o=r.getChildAt(r.getNumChildren()-3)),this.isLeftOrRightHandle(o)?(this._isHorizontalResize=!0,this.isRTL()?(this._oldEndPosX=this.Width-r.getX(),this._oldStartPosX=this._oldEndPosX-r.getWidth()):(this._oldStartPosX=r.getX(),this._oldEndPosX=this._oldStartPosX+r.getWidth()),t.OverviewUtils.supportsTouch()||(o.setX(0-t.Overview.HANDLE_PADDING_SIZE),o.setWidth(2*(o.getWidth()+t.Overview.HANDLE_PADDING_SIZE)))):(this._isHorizontalResize=!1,this._oldStartPosY=r.getY(),this._oldEndPosY=this._oldStartPosY+r.getHeight(),t.OverviewUtils.supportsTouch()||(o.setY(0-t.Overview.HANDLE_PADDING_SIZE),o.setHeight(2*(o.getHeight()+t.Overview.HANDLE_PADDING_SIZE)))),this.overrideCursors(o.getCursor())}this._moveDrawable=o;var a=t.EventFactory.newOverviewEvent("dropCallback");return this.dispatchEvent(a),!0}return!1},t.Overview.prototype.overrideCursors=function(t){var i=this.getSlidingWindow();if(null!=i&&i.setCursor(t),this.isLeftAndRightFilterRendered()){var e=this.getLeftBackground(),n=this.getRightBackground();null!=e&&null!=n&&(e.setCursor(t),n.setCursor(t))}},t.Overview.prototype.resetCursors=function(){var t=this.getSlidingWindow();if(null!=t&&t.setCursor("move"),this.isLeftAndRightFilterRendered()){var i=this.getLeftBackground(),e=this.getRightBackground();null!=i&&null!=e&&(i.setCursor("default"),e.setCursor("default"))}},t.Overview.prototype.endDragPan=function(){null!=this._moveDrawable&&1==this._isDragPanning&&("window"==this._moveDrawable.getId()?this.handleWindowDrag("scrollEnd"):this.isHandle(this._moveDrawable)&&(this.finishHandleDrag(0,0),t.OverviewUtils.supportsTouch()||(this.isTopOrBottomHandle(this._moveDrawable)?(this._moveDrawable.setY(0),this._moveDrawable.setHeight(this.getHandleSize())):this.isLeftOrRightHandle(this._moveDrawable)&&(this._moveDrawable.setX(0),this._moveDrawable.setWidth(this.getHandleSize()))),this.resetCursors()),this._isDragPanning=!1,this._moveDrawable=null,this._initX=-1)},t.Overview.prototype.contDragPan=function(t,i,e){if(null!=this._moveDrawable&&-1!=this._initX){this._isDragPanning=!0;var n=i-this._initX,o=e-this._initY;this._initX=i,this._initY=e,"window"==this._moveDrawable.getId()?this.handleWindowDrag("scrollPos",n,o):"lh"==this._moveDrawable.getId()||"lhb"==this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(t,n,!0):"rh"==this._moveDrawable.getId()||"rhb"==this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(t,n,!1):"th"==this._moveDrawable.getId()||"thb"==this._moveDrawable.getId()?this.handleTopOrBottomHandleDragPositioning(t,o,!0):"bh"!=this._moveDrawable.getId()&&"bhb"!=this._moveDrawable.getId()||this.handleTopOrBottomHandleDragPositioning(t,o,!1)}},t.Overview.prototype.HandleTouchStart=function(t){var i=t.touches;this._touchStartX=i[0].pageX,this._touchStartY=i[0].pageY,2==i.length&&(t.preventDefault(),this._touchStartX2=i[1].pageX,this._touchStartY2=i[1].pageY,Math.abs(this._touchStartY-this._touchStartY2)<20?this._counter=0:(this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null))},t.Overview.prototype.HandleTouchMove=function(t){t.preventDefault();var i=t.touches;if(null!=this._touchStartX2&&null!=this._touchStartY2){if(this._counter<50)return void this._counter++;var e=i[1].pageX-this._touchStartX2;this.handleRightHandleDragPositioning(null,e,0),this._touchStartX2=i[1].pageX,this._counter=0}else{var n=Math.abs(this._touchStartX-i[0].pageX),o=Math.abs(this._touchStartY-i[0].pageY);(n>3||o>3)&&(this._touchStartX=null,this._touchStartY=null)}},t.Overview.prototype.HandleTouchEnd=function(t){null!=this._touchStartX2&&null!=this._touchStartY2?this.finishHandleDrag(0,0):null!=this._touchStartX&&null!=this._touchStartY&&this.HandleShapeClick(t,this._touchStartX,this._touchStartY),this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null},t.Overview.prototype.stopDragAction=function(){this.endDragPan()},t.Overview.prototype.handleWindowDrag=function(t,i,e){var o,r,s,a,l=this.getSlidingWindow(),h=!1,d=this.getSlidingWindowPosX(l),g=this.getSlidingWindowPosY(l),u=l.getWidth(),v=l.getHeight();if("scrollPos"===t){if(this.isHorizontalScrollingEnabled()&&0!==i){var w=this.getMinimumPositionX(),c=this.getMaximumPositionX();d+i<=w?this.setSlidingWindowPosX(l,w):d+u+i>=c?this.setSlidingWindowPosX(l,c-u):this.setSlidingWindowPosX(l,d+i);var p=this.getSlidingWindowPosX(l);p!==d&&(d=p,h=!0)}if(this.isVerticalScrollingEnabled()&&0!==e){var _=this.getMinimumPositionY(),f=this.getMaximumPositionY();g+e<=_?this.setSlidingWindowPosY(l,_):g+v+e>=f?this.setSlidingWindowPosY(l,f-v):this.setSlidingWindowPosY(l,g+e);var m=this.getSlidingWindowPosY(l);m!==g&&(g=m,h=!0)}h&&n._updateBorderAroundSlidingWindow(this)}this.isHorizontalScrollingEnabled()&&(this.isRTL()?(o=this.getXPositionDate(this.Width-(d+u)),r=this.getXPositionDate(this.Width-d)):(o=this.getXPositionDate(d),r=this.getXPositionDate(d+u))),this.isVerticalScrollingEnabled()&&(s=this.getYPositionDate(g),a=this.getYPositionDate(g+v)),this.fireScrollEvent(t,o,r,s,a)},t.Overview.prototype.fireScrollEvent=function(i,e,n,o,r){var s,a,l,h;this.isHorizontalScrollingEnabled()&&(s=e,a=n),this.isVerticalScrollingEnabled()&&(l=o,h=r);var d=t.EventFactory.newOverviewEvent(i,s,a,l,h);this.dispatchEvent(d)},t.Overview.prototype.handleLeftOrRightHandleDragPositioning=function(i,e,o){if(0!=e){var r=this.getSlidingWindow(),s=this.getSlidingWindowPosX(r),a=r.getWidth();if(o){if(a-e<=this.getMinimumWindowWidth())return;if(s+e<=this.getMinimumPositionX())return;var l=this.getCtx().pageToStageCoords(this.getPageX(i),this.getPageY(i)).x;if(l=this.stageToLocal(l),e>0&&l<=s)return;if(e<0&&l>=s)return;this.setSlidingWindowPosX(r,s+e),n._setSlidingWindowWidth(this,r,a-e)}else{if(a+e<=this.getMinimumWindowWidth())return;if(s+a+e>=this.getMaximumPositionX())return;if(l=this.getCtx().pageToStageCoords(this.getPageX(i),this.getPageY(i)).x,l=this.stageToLocal(l),e>0&&l<=s+a)return;if(e<0&&l>=s+a)return;n._setSlidingWindowWidth(this,r,a+e)}if(n._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var h,d;this.isRTL()?(h=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(r)+r.getWidth())),d=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(r))):(h=this.getXPositionDate(this.getSlidingWindowPosX(r)),d=this.getXPositionDate(this.getSlidingWindowPosX(r)+r.getWidth()));var g=t.EventFactory.newOverviewEvent("rangeChanging",h,d);this.dispatchEvent(g)}}},t.Overview.prototype.handleTopOrBottomHandleDragPositioning=function(i,e,o){if(0!=e){var r=this.getSlidingWindow(),s=this.getSlidingWindowPosY(r),a=r.getHeight();if(o){if(a-e<=this.getMinimumWindowHeight())return;if(s+e<=this.getMinimumPositionY())return;var l=this.getCtx().pageToStageCoords(this.getPageX(i),this.getPageY(i)).y;if(l=this.stageToLocal(l),e>0&&l<=s)return;if(e<0&&l>=s)return;this.setSlidingWindowPosY(r,s+e),n._setSlidingWindowHeight(this,r,a-e)}else{if(a+e<=this.getMinimumWindowHeight())return;if(s+a+e>=this.getMaximumPositionY())return;if(l=this.getCtx().pageToStageCoords(this.getPageX(i),this.getPageY(i)).y,l=this.stageToLocal(l),e>0&&l<=s+a)return;if(e<0&&l>=s+a)return;n._setSlidingWindowHeight(this,r,a+e)}if(n._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var h=this.getYPositionDate(this.getSlidingWindowPosY(r)),d=this.getYPositionDate(this.getSlidingWindowPosY(r)+r.getHeight()),g=t.EventFactory.newOverviewEvent("rangeChanging",void 0,void 0,h,d);this.dispatchEvent(g)}}},t.Overview.prototype.isHorizontalScrollingEnabled=function(){return null!=this._xMin&&null!=this._xMax},t.Overview.prototype.isVerticalScrollingEnabled=function(){return null!=this._yMin&&null!=this._yMax},t.Overview.prototype.isRangeChangingSupported=function(){return!0},t.Overview.prototype.finishHandleDrag=function(i,e){var n,o=this.getSlidingWindow();if(this._isHorizontalResize){var r=this.getXPositionDate(this._oldStartPosX),s=this.getXPositionDate(this._oldEndPosX);if(this.isRTL())var a=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(o)+o.getWidth())),l=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(o));else a=this.getXPositionDate(this.getSlidingWindowPosX(o)),l=this.getXPositionDate(this.getSlidingWindowPosX(o)+o.getWidth());n=t.EventFactory.newOverviewEvent("rangeChange",a,l,void 0,void 0,r,s)}else{var h=this.getYPositionDate(this._oldStartPosY),d=this.getYPositionDate(this._oldEndPosY),g=this.getYPositionDate(this.getSlidingWindowPosY(o)),u=this.getYPositionDate(this.getSlidingWindowPosY(o)+o.getHeight());n=t.EventFactory.newOverviewEvent("rangeChange",void 0,void 0,g,u,void 0,void 0,h,d)}this.dispatchEvent(n)},t.Overview.prototype.dispatchEvent=function(t){this._callback.call(this._callbackObj,t,this)},t.Overview.prototype.destroy=function(){this.EventManager&&(this.EventManager.removeListeners(this),this.EventManager.destroy(),this.EventManager=null),t.OverviewUtils.supportsTouch()?(this.removeEvtListener(t.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.removeEvtListener(t.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.removeEvtListener(t.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.removeEvtListener(t.MouseEvent.CLICK,this.HandleShapeClick,!1,this)):(this.removeEvtListener(t.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.removeEvtListener(t.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.removeEvtListener(t.MouseEvent.CLICK,this.HandleShapeClick,!1,this),this.removeEvtListener(t.KeyboardEvent.KEYDOWN,this.HandleKeyDown,!1,this),this.removeEvtListener(t.KeyboardEvent.KEYUP,this.HandleKeyUp,!1,this)),t.Overview.superclass.destroy.call(this)};var i=function(){this.Init({alta:i.VERSION_1})};t.Obj.createSubclass(i,t.BaseComponentDefaults),i.VERSION_1={overviewPosition:"below",style:{currentTimeIndicatorColor:"#c000d1",handleFillColor:"#ffffff",handleTextureColor:"#b3c6db",leftFilterPanelAlpha:.7,leftFilterPanelColor:"#ffffff",overviewBackgroundColor:"#e6ecf3",rightFilterPanelAlpha:.7,rightFilterPanelColor:"#ffffff",timeAxisBarColor:"#e5e5e5",timeAxisBarAlpha:1,timeIndicatorColor:"#bcc7d2",windowBackgroundAlpha:1,windowBackgroundColor:"#ffffff",windowBorderBottomColor:"#4f4f4f",windowBorderBottomStyle:"solid",windowBorderLeftColor:"#4f4f4f",windowBorderLeftStyle:"solid",windowBorderRightColor:"#4f4f4f",windowBorderRightStyle:"solid",windowBorderTopColor:"#4f4f4f",windowBorderTopStyle:"solid"}},t.OverviewParser=function(t){this.Init(t)},t.Obj.createSubclass(t.OverviewParser,t.Obj),t.OverviewParser.prototype.Init=function(t){this._view=t},t.OverviewParser.prototype.parse=function(t){var i=t;return this.ParseRootAttributes(i)},t.OverviewParser.prototype.ParseRootAttributes=function(i){var e=new Object;return e.animationOnClick=i.animationOnClick,null!=i.xMin&&(e.xMin=i.xMin),null!=i.xMax&&(e.xMax=i.xMax),null!=i.x1&&(e.x1=i.x1),null!=i.x2&&(e.x2=i.x2),null!=i.yMin&&(e.yMin=i.yMin),null!=i.yMax&&(e.yMax=i.yMax),null!=i.y1&&(e.y1=i.y1),null!=i.y2&&(e.y2=i.y2),null!=i.currentTime&&(e.currentTime=i.currentTime),e.orientation="horizontal",null!=i.orientation&&(e.orientation=i.orientation),e.featuresOff=i.featuresOff,e.minimumWindowSize=i.minimumWindowSize,e.leftMargin=i.leftMargin,e.rightMargin=i.rightMargin,e.overviewPosition="below",e.selectionMode="none",e.isRtl=t.Agent.isRightToLeft(this._view.getCtx()).toString(),null!=i.rtl&&(e.isRtl=i.rtl.toString()),e},t.OverviewParser.prototype.calculateWidth=function(t,i,e,n,o){var r=o*(i-t),s=n-e;return 0==r||0==s?0:r/s};var e=function(t){this.Init(t.getCtx(),t.processEvent,t),this._overview=t};t.Obj.createSubclass(e,t.EventManager),e.prototype.addListeners=function(i){t.SvgDocumentUtils.addDragListeners(this._overview,this._onDragStart,this._onDragMove,this._onDragEnd,this)},e.prototype._onDragStart=function(i){return t.Agent.isTouchDevice()?this._onTouchDragStart(i):this._onMouseDragStart(i)},e.prototype._onDragMove=function(i){return t.Agent.isTouchDevice()?this._onTouchDragMove(i):this._onMouseDragMove(i)},e.prototype._onDragEnd=function(i){return t.Agent.isTouchDevice()?this._onTouchDragEnd(i):this._onMouseDragEnd(i)},e.prototype._getRelativePosition=function(i,e){return this._stageAbsolutePosition||(this._stageAbsolutePosition=this._context.getStageAbsolutePosition()),new t.Point(i-this._stageAbsolutePosition.x,e-this._stageAbsolutePosition.y)},e.prototype._onMouseDragStart=function(i){if(i.button!=t.MouseEvent.RIGHT_CLICK_BUTTON){var e=this._getRelativePosition(i.pageX,i.pageY);return this._overview.beginDragPan(i,e.x,e.y)}return!1},e.prototype._onMouseDragMove=function(t){var i=this._getRelativePosition(t.pageX,t.pageY);return this._overview.contDragPan(t,i.x,i.y),!0},e.prototype._onMouseDragEnd=function(t){this._overview.endDragPan(),this._stageAbsolutePosition=null},e.prototype._onTouchDragStart=function(t){var i=t.touches;if(t.stopPropagation(),1==i.length){var e=this._getRelativePosition(i[0].pageX,i[0].pageY);return t.preventDefault(),this._overview.beginDragPan(t,e.x,e.y)}return!1},e.prototype._onTouchDragMove=function(t){var i=t.touches;if(1==i.length){var e=this._getRelativePosition(i[0].pageX,i[0].pageY);this._overview.contDragPan(t,e.x,e.y),t.preventDefault()}t.stopPropagation()},e.prototype._onTouchDragEnd=function(i){this._overview.endDragPan(),t.EventManager.consumeEvent(i),this._stageAbsolutePosition=null};var n=new Object;t.Obj.createSubclass(n,t.Obj),n.renderOverview=function(t){t.isBackgroundRendered()&&n._renderBackground(t);var i=null!=t._callback||null!=t._callbackObj;i&&n._renderSlidingWindow(t),n._renderTimeAxis(t),n._parseFilledTimeRanges(t),n._updateCurrentTime(t),t.renderData(t.Width,t.Height),i&&(n._createBorderAroundSlidingWindow(t),n._updateSlidingWindow(t))},n._renderBackground=function(i){var e=new t.Rect(i.getCtx(),0,0,i.Width,i.Height,"bg");e.setSolidFill(i._overviewBackgroundColor),e.setPixelHinting(!0),i.addChild(e)},n._renderSlidingWindow=function(i){var e=i.Width,o=i.Height,r=new t.Rect(i.getCtx(),0,0,e,o,"window");if(r.setSolidFill(i._windowBackgroundColor,i._windowBackgroundAlpha),r.setPixelHinting(!0),!i.isFeatureOff("zoom")){var s=i.getHandleSize(),a=i.getHandleStart(),l=i.getGrippySize();if(i.isVerticalScrollingEnabled()){var h=i.getSlidingWindowWidth(),d=t.PathUtils.moveTo(0,0)+t.PathUtils.quadTo(3,6,8,8)+t.PathUtils.lineTo(28,8)+t.PathUtils.quadTo(33,6,36,0);t.PathUtils.closePath();var g=t.PathUtils.moveTo(0,0)+t.PathUtils.quadTo(3,-6,8,-8)+t.PathUtils.lineTo(28,-8)+t.PathUtils.quadTo(33,-6,36,0);t.PathUtils.closePath();var u=new t.Rect(i.getCtx(),0,0,h,s,"thb"),v=new t.Rect(i.getCtx(),0,0,h,s,"bhb");if(O="row-resize",i._vertHandleBackgroundImage)var w=n._createGrippyImage(i,h,l,!0),c=n._createGrippyImage(i,h,l,!0);else w=n._createGrippy(i,!0),c=n._createGrippy(i,!0);u.setSolidFill(i._windowBackgroundColor,0),v.setSolidFill(i._windowBackgroundColor,0),u.setPixelHinting(!0),v.setPixelHinting(!0);var p=new t.Path(i.getCtx(),d,"th"),_=new t.Path(i.getCtx(),g,"bh");p.setSolidFill(i._handleFillColor),p.setSolidStroke(i._handleFillColor),_.setSolidFill(i._handleFillColor),_.setSolidStroke(i._handleFillColor),i._windowBackgroundColor==i._handleFillColor&&(p.setPixelHinting(!0),_.setPixelHinting(!0)),u.setCursor(O),v.setCursor(O),p.setCursor(O),_.setCursor(O),w.setCursor(O),c.setCursor(O),r.addChild(u),i._windowTopHandleBackground=u,r.addChild(p),i._windowTopHandle=p,r.addChild(w),i._windowTopGrippy=w,r.addChild(v),i._windowBottomHandleBackground=v,r.addChild(_),i._windowBottomHandle=_,r.addChild(c),i._windowBottomGrippy=c}if(i.isHorizontalScrollingEnabled()){var f=i.getSlidingWindowHeight(),m=t.PathUtils.moveTo(0,0)+t.PathUtils.quadTo(6,3,8,8)+t.PathUtils.lineTo(8,28)+t.PathUtils.quadTo(6,33,0,36);t.PathUtils.closePath();var P=t.PathUtils.moveTo(0,0)+t.PathUtils.quadTo(-6,3,-8,8)+t.PathUtils.lineTo(-8,28)+t.PathUtils.quadTo(-6,33,0,36);t.PathUtils.closePath();var S=new t.Rect(i.getCtx(),0-a,0,s,f,"lhb"),y=new t.Rect(i.getCtx(),a,0,s,f,"rhb"),O="col-resize";if(i._horHandleBackgroundImage)var C=n._createGrippyImage(i,l,f,!1),x=n._createGrippyImage(i,l,f,!1);else C=n._createGrippy(i,!1),x=n._createGrippy(i,!1);S.setSolidFill(i._windowBackgroundColor,0),y.setSolidFill(i._windowBackgroundColor,0),S.setPixelHinting(!0),y.setPixelHinting(!0);var W=new t.Path(i.getCtx(),m,"lh"),T=new t.Path(i.getCtx(),P,"rh");W.setSolidFill(i._handleFillColor),W.setSolidStroke(i._handleFillColor),T.setSolidFill(i._handleFillColor),T.setSolidStroke(i._handleFillColor),i._windowBackgroundColor==i._handleFillColor&&(W.setPixelHinting(!0),T.setPixelHinting(!0)),S.setCursor(O),y.setCursor(O),W.setCursor(O),T.setCursor(O),C.setCursor(O),x.setCursor(O),r.addChild(S),i._windowLeftHandleBackground=S,r.addChild(W),i._windowLeftHandle=W,r.addChild(C),i._windowLeftGrippy=C,r.addChild(y),i._windowRightHandleBackground=y,r.addChild(T),i._windowRightHandle=T,r.addChild(x),i._windowRightGrippy=x}}r.setCursor("move"),i.addChild(r),n._renderTimeAxisTopBar(i),n._renderLeftAndRightFilters(i,a)},n._createGrippyImage=function(i,e,n,o){if(o){var r=(n-i._vertHandleHeight)/2;a=new t.Image(i.getCtx(),i._vertHandleBackgroundImage,0,r,i._vertHandleWidth,i._vertHandleHeight,"vgrpy")}else var s=(e-i._horHandleWidth)/2,a=new t.Image(i.getCtx(),i._horHandleBackgroundImage,s,0,i._horHandleWidth,i._horHandleHeight,"hgrpy");return a.setMouseEnabled(!1),a},n._createGrippy=function(i,e){var n=i._handleTextureColor;if(e){for(var o=new t.Container(i.getCtx(),"vgrpy"),r=8,s=3,a=0;a<9;a++){var l=new t.Line(i.getCtx(),r+2*a,s,r+2*a+1,s,"dot1"+a);l.setSolidStroke(n),o.addChild(l),s+=2,(l=new t.Line(i.getCtx(),r+1+2*a,s,r+1+2*a+1,s,"dot2"+a)).setSolidStroke(n),o.addChild(l),s+=2,(l=new t.Line(i.getCtx(),r+2*a,s,r+2*a+1,s,"dot3"+a)).setSolidStroke(n),o.addChild(l),s=3}(l=new t.Line(i.getCtx(),r+18,s,r+18+1,s,"dot4")).setSolidStroke(n),o.addChild(l),s+=4,(l=new t.Line(i.getCtx(),r+18,s,r+18+1,s,"dot5")).setSolidStroke(n),o.addChild(l)}else{for(o=new t.Container(i.getCtx(),"hgrpy"),r=3,s=8,a=0;a<9;a++)(l=new t.Line(i.getCtx(),r,s+2*a,r,s+2*a+1,"dot1"+a)).setSolidStroke(n),o.addChild(l),r+=2,(l=new t.Line(i.getCtx(),r,s+1+2*a,r,s+1+2*a+1,"dot2"+a)).setSolidStroke(n),o.addChild(l),r+=2,(l=new t.Line(i.getCtx(),r,s+2*a,r,s+2*a+1,"dot3"+a)).setSolidStroke(n),o.addChild(l),r=3;(l=new t.Line(i.getCtx(),r,s+18,r,s+18+1,"dot4")).setSolidStroke(n),o.addChild(l),r+=4,(l=new t.Line(i.getCtx(),r,s+18,r,s+18+1,"dot5")).setSolidStroke(n),o.addChild(l)}return o.setPixelHinting(!0),o},n._createBorderAroundSlidingWindow=function(i){var e=i.Width,n=i.Height,r=i.getSlidingWindow(),s=o._DEFAULT_WINDOW_BORDER_WIDTH/2;if(i.isVertical())var a=r.getY(),l=a+s,h=a+r.getHeight(),d=h-s,g=0,u=s,v=e,w=v-s,c=new t.Line(i.getCtx(),g,l,e,l,"lh"),p=new t.Line(i.getCtx(),g,d,e,d,"rh"),_=new t.Line(i.getCtx(),u,0,u,a,"ltb"),f=new t.Line(i.getCtx(),u,h,u,n,"rtb"),m=new t.Line(i.getCtx(),w,a,w,h,"bb"),P=new t.Line(i.getCtx(),u,a,u,h,"tb");else l=(a=0)+s,d=(h=n)-s,u=(g=r.getX())+s,w=(v=g+r.getWidth())-s,c=new t.Line(i.getCtx(),u,a,u,h,"lh"),p=new t.Line(i.getCtx(),w,a,w,h,"rh"),_=new t.Line(i.getCtx(),0,l,g+1,l,"ltb"),f=new t.Line(i.getCtx(),v-1,l,e,l,"rtb"),m=new t.Line(i.getCtx(),g,d,v,d,"bb"),P=new t.Line(i.getCtx(),g,l,v,l,"tb");c.setPixelHinting(!0),p.setPixelHinting(!0),_.setPixelHinting(!0),f.setPixelHinting(!0),m.setPixelHinting(!0),P.setPixelHinting(!0),"none"!=i._windowBorderLeftStyle&&c.setSolidStroke(i._windowBorderLeftColor),i.addChild(c),i._leftHandle=c,"none"!=i._windowBorderRightStyle&&p.setSolidStroke(i._windowBorderRightColor),i.addChild(p),i._rightHandle=p,"none"!=i._borderTopStyle&&i._borderTopColor&&(_.setSolidStroke(i._borderTopColor),f.setSolidStroke(i._borderTopColor)),i.addChild(_),i.addChild(f),"none"!=i._windowBorderBottomStyle&&m.setSolidStroke(i._windowBorderBottomColor),i.addChild(m),"none"!=i._windowBorderTopStyle&&P.setSolidStroke(i._windowBorderTopColor),i.addChild(P)},n._updateBorderAroundSlidingWindow=function(t){var i=t.getSlidingWindow(),e=o._DEFAULT_WINDOW_BORDER_WIDTH/2,n=t.getLeftHandle(),r=t.getRightHandle(),s=t.getLeftTopBar(),a=t.getRightTopBar(),l=t.getBottomBar(),h=t.getTopBar();if(t.isVertical()){if(t.isHorizontalScrollingEnabled()){var d=i.getWidth(),g=t.getSlidingWindowPosX(i),u=g+e,v=g+d-e;t.setLinePosX(n,u,v),t.setLinePosX(r,u,v),t.setLinePosX(h,u,u),t.setLinePosX(l,v,v)}if(t.isVerticalScrollingEnabled()){var w=i.getHeight(),c=t.getSlidingWindowPosY(i),p=c+e,_=c+w-e;t.setLinePosY(n,p,p),t.setLinePosY(r,_,_),t.setLinePosY(h,p,_),t.setLinePosY(l,p,_)}}else t.isHorizontalScrollingEnabled()&&(d=i.getWidth(),u=(g=t.getSlidingWindowPosX(i))+e,v=g+d-e,t.setLinePosX(n,u,u),t.setLinePosX(r,v,v),t.setLinePosX(h,u,v),t.setLinePosX(l,u,v)),t.isVerticalScrollingEnabled()&&(w=i.getHeight(),p=(c=t.getSlidingWindowPosY(i))+e,_=c+w-e,t.setLinePosY(n,p,_),t.setLinePosY(r,p,_),t.setLinePosY(h,p,p),t.setLinePosY(l,_,_));t.setLinePos(s,-1,t.getSlidingWindowPos(i)),t.setLinePos(a,t.getLinePos1(r),-1)},n._updateSlidingWindow=function(i){var e=i.getSlidingWindow(),o=i.Width,r=i.Height;if(i.isHorizontalScrollingEnabled()){var s=Math.max(i.getMinimumPositionX(),t.OverviewUtils.getDatePosition(i._xMin,i._xMax,i._x1,o)),a=Math.min(i.getMaximumPositionX(),Math.max(i.getMinimumPositionX(),t.OverviewUtils.getDatePosition(i._xMin,i._xMax,i._x2,o)));i.isRTL()?i.setSlidingWindowPosX(e,o-a):i.setSlidingWindowPosX(e,s),n._setSlidingWindowWidth(i,e,a-s)}else n._setSlidingWindowWidth(i,e,o);if(i.isVerticalScrollingEnabled()){var l=Math.max(i.getMinimumPositionY(),t.OverviewUtils.getDatePosition(i._yMin,i._yMax,i._y1,r)),h=Math.min(i.getMaximumPositionY(),Math.max(i.getMinimumPositionY(),t.OverviewUtils.getDatePosition(i._yMin,i._yMax,i._y2,r)));i.setSlidingWindowPosY(e,l),n._setSlidingWindowHeight(i,e,h-l)}else n._setSlidingWindowHeight(i,e,r);n._updateBorderAroundSlidingWindow(i)},n._setSlidingWindowWidth=function(i,e,n){if(n=Math.min(i.getMaximumWindowWidth(),Math.max(i.getMinimumWindowWidth(),n)),e.setWidth(n),i.isLeftAndRightFilterRendered()){var o=i.getSlidingWindowPosX(e)+n,r=i.getRightBackground();if(r.setX(o),r.setWidth(Math.max(0,i.Width-o)),t.OverviewUtils.supportsTouch()&&!i.isFeatureOff("zoom"))i.getRightBackgroundHandle().setX(o)}if(!i.isFeatureOff("zoom")){if(i.isHorizontalScrollingEnabled()){var s=i._windowRightHandleBackground,a=i._windowRightHandle,l=i._windowRightGrippy;a.setTranslateX(n),s.setTranslateX(n-i.getHandleSize()),l.setTranslateX(n-i.getGrippySize())}if(i.isVerticalScrollingEnabled()){var h=(e.getWidth()-36)/2;if(i._vertHandleBackgroundImage)var d=(n-i._vertHandleWidth)/2;else d=h;var g=i._windowTopHandleBackground,u=i._windowTopHandle,v=i._windowTopGrippy;u.setTranslateX(h),g.setWidth(n),v.setTranslateX(d);var w=i._windowBottomHandleBackground,c=i._windowBottomHandle,p=i._windowBottomGrippy;c.setTranslateX(h),w.setWidth(n),p.setTranslateX(d)}}},n._setSlidingWindowHeight=function(t,i,e){if(e=Math.min(t.getMaximumWindowHeight(),Math.max(t.getMinimumWindowHeight(),e)),i.setHeight(e),!t.isFeatureOff("zoom")){if(t.isHorizontalScrollingEnabled()){var n=(e-36)/2;if(t._horHandleBackgroundImage)var o=(e-t._horHandleHeight)/2;else o=n;var r=t._windowLeftHandleBackground,s=t._windowLeftHandle,a=t._windowLeftGrippy;s.setTranslateY(n),r.setHeight(e),a.setTranslateY(o);var l=t._windowRightHandleBackground,h=t._windowRightHandle,d=t._windowRightGrippy;h.setTranslateY(n),l.setHeight(e),d.setTranslateY(o)}if(t.isVerticalScrollingEnabled()){var g=t._windowBottomHandleBackground,u=t._windowBottomHandle,v=t._windowBottomGrippy;u.setTranslateY(e),g.setTranslateY(e-t.getHandleSize()),v.setTranslateY(e-t.getGrippySize())}}},n._renderTimeAxisTopBar=function(i){var e=i.Width,n=i.Height;if(i.isVertical())if(i.isRTL())var o=new t.Line(i.getCtx(),i.getTimeAxisWidth(),0,i.getTimeAxisWidth(),n,"tab");else o=new t.Line(i.getCtx(),e-i.getTimeAxisWidth(),0,e-i.getTimeAxisWidth(),n,"tab");else o=i.isOverviewAbove()?new t.Line(i.getCtx(),0,i.getTimeAxisHeight(),e,i.getTimeAxisHeight(),"tab"):new t.Line(i.getCtx(),0,n-i.getTimeAxisHeight(),e,n-i.getTimeAxisHeight(),"tab");o.setSolidStroke(i._timeAxisBarColor,i._timeAxisBarOpacity),o.setPixelHinting(!0),i._timeAxisTopBar=o,i.addChild(o)},n._renderLeftAndRightFilters=function(i,e){var n=i.Width,o=i.Height;if(i.isLeftAndRightFilterRendered()){if(i.isVertical())var r=new t.Rect(i.getCtx(),0,0,n,0,"lbg"),s=new t.Rect(i.getCtx(),0,0,n,0,"rbg");else r=new t.Rect(i.getCtx(),0,0,0,o,"lbg"),s=new t.Rect(i.getCtx(),0,0,0,o,"rbg");if(r.setSolidFill(i._leftFilterPanelColor,i._leftFilterPanelAlpha),i.addChild(r),s.setSolidFill(i._rightFilterPanelColor,i._rightFilterPanelAlpha),i.addChild(s),t.OverviewUtils.supportsTouch()&&null!=e){if(i.isVertical())var a=new t.Rect(i.getCtx(),0,0,n,e,"lbgrh"),l=new t.Rect(i.getCtx(),0,0,n,e,"rbgrh");else a=new t.Rect(i.getCtx(),0,0,e,o,"lbgrh"),l=new t.Rect(i.getCtx(),0,0,e,o,"rbgrh");a.setSolidFill(i._leftFilterPanelColor,0),i.addChild(a),l.setSolidFill(i._rightFilterPanelColor,0),i.addChild(l)}}},n._renderTimeAxis=function(t){if(null!=t._ticks)for(var i=t.Width,e=t.Height,r=t.isVertical(),s=t.getOverviewSize(),a=0;a<t._ticks.length;a++){var l=t._ticks[a],h=parseInt(l.time,10);if(r)var d=t.getDateYPosition(h);else d=t.getDateXPosition(h);var g=l.label,u=0;if(a+1<t._ticks.length){var v=parseInt(t._ticks[a+1].time,10);if(r)var w=t.getDateYPosition(v);else w=t.getDateXPosition(v);u=w-d}else u=s-d;t.isHorizontalRTL()&&(d=s-d),r&&(u=i),u-=2*o._DEFAULT_AXIS_LABEL_PADDING,n._addTick(t,d,i,e,"tick"+a),n._addLabel(t,d,g,e,u,"label"+a,t._labelStyle)}},n._addTick=function(i,e,n,o,r){if(i.isVertical())var s=new t.Line(i.getCtx(),0,e,n,e,r);else s=new t.Line(i.getCtx(),e,0,e,o,r);var a=new t.Stroke(i._timeIndicatorColor,1,1,!1,{dashArray:"3"});s.setStroke(a),s.setPixelHinting(!0),i.addChild(s)},n._addLabel=function(i,e,n,r,s,a,l){if(i.isVertical()){var h=new t.OutputText(i.getCtx(),n,4,e,a);if(h.setCSSStyle(l),i.isRTL()){var d=h.getDimensions();h.setX(Math.max(4,i.Width-d.w-4))}}else{if(i.isOverviewAbove())var g=2;else g=r-i.getTimeAxisHeight()+2;var u=o._DEFAULT_AXIS_LABEL_PADDING;(h=new t.OutputText(i.getCtx(),n,e+u,g,a)).setCSSStyle(l),i.isHorizontalRTL()&&(d=h.getDimensions(),h.setX(e-Math.min(d.w,s)-u))}t.TextUtils.fitText(h,s,1/0,i),h._rawText=h.getUntruncatedTextString()},n._parseFilledTimeRanges=function(t){if(null!=t._formattedTimeRanges)for(var i=0;i<t._formattedTimeRanges.length;i++){var e=t._formattedTimeRanges[i];n._addFilledTimeRange(t,e,t.Width,t.Height)}},n._addFilledTimeRange=function(i,e,n,o){var r=parseInt(e.rs,10),s=parseInt(e.re,10);if(null!=r&&null!=s){var a=e.c,l=i.getOverviewSize();if(i.isVertical())h=i.getDateYPosition(r),d=i.getDateYPosition(s);else var h=i.getDateXPosition(r),d=i.getDateXPosition(s);var g=d-h;if(i.isHorizontalRTL()&&(h=l-h-g,d=l-d-g),i.isVertical())var u=new t.Rect(i.getCtx(),0,h,n-i.getTimeAxisWidth(),g,"ftr");else u=new t.Rect(i.getCtx(),h,i.isOverviewAbove()?i.getTimeAxisHeight():0,g,o-i.getTimeAxisHeight(),"ftr");null!=a&&u.setSolidFill(a,.4),u.setCursor("move"),u.setPixelHinting(!0),i.addChild(u)}},n._updateCurrentTime=function(i){var e=i.Width,n=i.Height;if(!(null==i._currentTime||isNaN(i._currentTime)||i._currentTime<i._xMin||i._currentTime>i._xMax)){if(i.isVertical())var o=i.getDateYPosition(i._currentTime),r=new t.Line(i.getCtx(),0,o,e,o,"ocd");else o=i.getDateXPosition(i._currentTime),i.isRTL()&&(o=e-o),r=new t.Line(i.getCtx(),o,0,o,n,"ocd");r.setSolidStroke(i._currentTimeIndicatorColor),r.setPixelHinting(!0),i.addChild(r)}};var o=new Object;t.Obj.createSubclass(o,t.Obj),o._DEFAULT_AXIS_LABEL_PADDING=5,o._DEFAULT_WINDOW_BORDER_WIDTH=1,o.getHandleFillColor=function(t){return null!=t._hfc?t._hfc:t.style.handleFillColor},o.getHandleTextureColor=function(t){return null!=t._htc?t._htc:t.style.handleTextureColor},o.getHandleBackgroundImage=function(t,i){return i?null!=t._vhbi?t._vhbi:t.style.vertHandleBackgroundImage:null!=t._hbi?t._hbi:t.style.handleBackgroundImage},o.getHandleWidth=function(t,i){return i?null!=t._vhw?t._vhw:t.style.vertHandleWidth:null!=t._hw?t._hw:t.style.handleWidth},o.getHandleHeight=function(t,i){return i?null!=t._vhh?t._vhh:t.style.vertHandleHeight:null!=t._hh?t._hh:t.style.handleHeight},o.getBorderTopColor=function(t){return null!=t._btc?t._btc:t.style.borderTopColor},o.getBorderTopStyle=function(t){return null!=t._bts?t._bts:t.style.borderTopStyle},o.getWindowBackgroundColor=function(t){return null!=t._wbc?t._wbc:t.style.windowBackgroundColor},o.getWindowBackgroundAlpha=function(t){return t.style.windowBackgroundAlpha},o.getWindowBorderTopStyle=function(t){return null!=t._wbts?t._wbts:t.style.windowBorderTopStyle},o.getWindowBorderRightStyle=function(t){return null!=t._wbrs?t._wbrs:t.style.windowBorderRightStyle},o.getWindowBorderBottomStyle=function(t){return null!=t._wbbs?t._wbbs:t.style.windowBorderBottomStyle},o.getWindowBorderLeftStyle=function(t){return null!=t._wbls?t._wbls:t.style.windowBorderLeftStyle},o.getWindowBorderTopColor=function(t){return null!=t._wbtc?t._wbtc:t.style.windowBorderTopColor},o.getWindowBorderRightColor=function(t){return null!=t._wbrc?t._wbrc:t.style.windowBorderRightColor},o.getWindowBorderBottomColor=function(t){return null!=t._wbbc?t._wbbc:t.style.windowBorderBottomColor},o.getWindowBorderLeftColor=function(t){return null!=t._wblc?t._wblc:t.style.windowBorderLeftColor},o.getOverviewBackgroundColor=function(t){return null!=t._obc?t._obc:t.style.overviewBackgroundColor},o.getCurrentTimeIndicatorColor=function(t){return null!=t._ctic?t._ctic:t.style.currentTimeIndicatorColor},o.getTimeAxisBarColor=function(t){return null!=t._tabc?t._tabc:t.style.timeAxisBarColor},o.getTimeAxisBarAlpha=function(t){return null!=t._tabo?t._tabo:t.style.timeAxisBarAlpha},o.getTimeIndicatorColor=function(t){return null!=t._tic?t._tic:t.style.timeIndicatorColor},o.getLeftFilterPanelColor=function(t){return t.style.leftFilterPanelColor},o.getLeftFilterPanelAlpha=function(t){return t.style.leftFilterPanelAlpha},o.getRightFilterPanelColor=function(t){return t.style.rightFilterPanelColor},o.getRightFilterPanelAlpha=function(t){return t.style.rightFilterPanelAlpha}}(dvt);
  return dvt;
});
