/**
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
define(['./DvtToolkit', './DvtPanZoomCanvas'], function(dvt) {
  "use strict";
  // Internal use only.  All APIs and functionality are subject to change at any time.

!function(t){t.ThematicMap=function(t,e,a){this.Init(t,e,a)},t.Obj.createSubclass(t.ThematicMap,t.PanZoomComponent),t.ThematicMap.DEFAULT_MAX_ZOOM_FACTOR=6,t.ThematicMap.prototype.Init=function(a,i,r){t.ThematicMap.superclass.Init.call(this,a,i,r),this._layers=[],this._createLayers(),this._bRendered=!1,this.Defaults=new e(a),this._initialZooming=!1,this._zooming=!1,this._panning=!1,this._selectedAreas={},this._bListenersRemoved=!1,this._createHandlers(),this.EventManager.associate(this,this)},t.ThematicMap.prototype._createLayers=function(){this._areaLayers=new t.Container(this.getCtx()),this._dataAreaLayers=new t.Container(this.getCtx()),this._dataAreaLayers.setAriaRole("region",!0),this._dataPointLayers=new t.Container(this.getCtx()),this._dataPointLayers.setAriaRole("region",!0),this._labelLayers=new t.Container(this.getCtx()),this._linkLayers=new t.Container(this.getCtx()),this._linkLayers.setAriaRole("region",!0)},t.ThematicMap.prototype._updateAriaForLayers=function(){var t=this.Options.translations;this._dataAreaLayers.setAriaProperty("label",t.areasRegion,!0),this._dataPointLayers.setAriaProperty("label",t.markersRegion,!0),this._linkLayers.setAriaProperty("label",t.linksRegion,!0)},t.ThematicMap.newInstance=function(e,a,i){return new t.ThematicMap(e,a,i)},t.ThematicMap.prototype.SetOptions=function(e){t.ThematicMap.superclass.SetOptions.call(this,e),t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnMapChange="none"),new f(this).parse(this.Options)},t.ThematicMap.prototype.setStyleDefaults=function(t){this._styleDefaults=t},t.ThematicMap.prototype.getStyleDefaults=function(){return this._styleDefaults},t.ThematicMap.prototype.getMaxZoomFactor=function(){var e=this.Options.maxZoom;return this._zooming?isNaN(e)?t.ThematicMap.DEFAULT_MAX_ZOOM_FACTOR:Math.max(e,1):1},t.ThematicMap.prototype.isMarkerZoomBehaviorFixed=function(){return"fixed"==this.Options.markerZoomBehavior},t.ThematicMap.prototype.addLayer=function(t){this._layers.push(t)},t.ThematicMap.prototype.getLayer=function(t){for(var e=0;e<this._layers.length;e++)if(this._layers[e].getLayerName()==t)return this._layers[e]},t.ThematicMap.prototype.getAllLayers=function(){return this._layers},t.ThematicMap.prototype.getAreaLayerContainer=function(){return this._areaLayers},t.ThematicMap.prototype.getDataAreaContainer=function(){return this._dataAreaLayers},t.ThematicMap.prototype.getDataPointContainer=function(){return this._dataPointLayers},t.ThematicMap.prototype.getLabelContainer=function(){return this._labelLayers},t.ThematicMap.prototype.getLinkContainer=function(){return this._linkLayers},t.ThematicMap.prototype.setMapName=function(t){this._bBaseMapChanged=this._mapName&&this._mapName!=t,this._mapName=t},t.ThematicMap.prototype.setAnimationDuration=function(t){this._animationDuration=parseFloat(t)},t.ThematicMap.prototype.getAnimationDuration=function(){return this._animationDuration},t.ThematicMap.prototype.getDisplayTooltips=function(){var t=this.Options.tooltipDisplay;switch(t){case"shortDesc":return"shortDescOnly";case"none":return t;default:return"auto"}},t.ThematicMap.prototype.setInitialZooming=function(t){this._initialZooming=t},t.ThematicMap.prototype.PreRender=function(){t.ThematicMap.superclass.PreRender.call(this),this._bBaseMapChanged=!1,!this.IsResize()&&this._pzcContainer&&(this._oldMapProvider=this.Options.mapProvider,this._layers=[],this._zooming=!0,this._panning=!0,this._oldPzc=this._pzc,this._createLayers(),this.EventManager.removeListeners(this),this._createHandlers(),this._bListenersRemoved=!1,this.EventManager.hideTooltip(),this.EventManager.associate(this,this))},t.ThematicMap.prototype._createHandlers=function(){this.EventManager=new y(this.getCtx(),this.dispatchEvent,this),this.EventManager.addListeners(this),t.Agent.isTouchDevice()?this._keyboardHandler=null:(this._keyboardHandler=new u(this,this.EventManager),this.EventManager.setKeyboardHandler(this._keyboardHandler))},t.ThematicMap.prototype.Render=function(){t.ThematicMap.superclass.Render.call(this);var e=new t.Container(this.getCtx()),a=new t.Container(this.getCtx());if(this._pzc=this.getPanZoomCanvas(),this._pzc.addChild(e),this._pzc.getContentPane().addChild(a),this._render(e,a),this._areaLayer){this.StopAnimation(!0);var i=new t.Rectangle(0,0,this.getWidth(),this.getHeight());if(null==this.getMapName()){var r=this.Options.mapProvider;this._oldMapProvider!==r&&(this._bBaseMapChanged=!0,this._oldMapProvider=r)}if(this._bRendered||this._oldPzc){if(this._bBaseMapChanged&&!this.IsResize()){var n=this.Options.animationOnMapChange;(n="auto"===n?"alphaFade":null)&&(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(this.getCtx(),n,this._oldPzc,this._pzc,i,this._animationDuration),this.addChild(this._oldPzc))}}else{var s=this.Options.animationOnDisplay;(s="auto"===s?"alphaFade":null)&&(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(this.getCtx(),s,this._pzc,i,this._animationDuration))}this.Animation?(this.EventManager.hideTooltip(),this.EventManager.removeListeners(this),this._bListenersRemoved=!0,this.Animation.setOnEnd(this.OnAnimationEnd,this),this.Animation.play()):this.OnAnimationEnd(),this._pzcContainer=e,this.getCtx().setKeyboardFocusArray([this]),this._bRendered=!0}},t.ThematicMap.prototype._calcMinZoom=function(){var t=this._pzc.getZoomToFitPadding(),e=this._areaLayer.getLayerDim(),a=this._pzc.getSize(),i=(a.w-2*t)/e.w,r=(a.h-2*t)/e.h;return Math.min(i,r)},t.ThematicMap.prototype._render=function(t,e){this._updateAriaForLayers(),e.addChild(this._areaLayers),e.addChild(this._dataAreaLayers),this.isMarkerZoomBehaviorFixed()?t.addChild(this._dataPointLayers):e.addChild(this._dataPointLayers),t.addChild(this._labelLayers),t.addChild(this._linkLayers);var a=this._pzc.getContentPane().getMatrix();this._areaLayerRendered=!1;for(var i=0;i<this._layers.length;i++){var r=this._layers[i];(!this._areaLayerRendered&&r instanceof g||!(r instanceof g))&&(r.render(a),!this._areaLayerRendered&&r instanceof g&&(this._areaLayerRendered=!0,this._areaLayer=r))}if(this._areaLayer){var n=this._areaLayer.getIsolatedArea();this._isolatedArea!=n&&(this._isolatedArea=n),this._setInitialKeyboardFocus(),this._pzc.setMinZoom(null),this._pzc.setMaxZoom(null),this._pzc.setZoomingEnabled(!0),this._pzc.setPanningEnabled(!0),this._pzc.zoomToFit(null,this._areaLayer.getLayerDim()),this._updateZoomLimits(),this._pzc.setZoomingEnabled(this._zooming),this._pzc.setPanningEnabled(this._panning),this.Options._resources&&this._pzc.setPanCursor(this.Options._resources.panCursorUp,this.Options._resources.panCursorDown)}},t.ThematicMap.prototype._setInitialKeyboardFocus=function(){if(this._keyboardHandler){var t=this.getNavigableAreas();0==t.length&&(t=this.getNavigableMarkers()),0==t.length&&(t=this.getNavigableLinks()),this.EventManager.setInitialFocus(t[0])}},t.ThematicMap.prototype.updateLayer=function(t,e,a){this._bRendered=!1,this.StopAnimation(!0),new f(this).ParseDataLayers([t],this.getLayer(e),this._areaLayer.getLayerName(),a),this._bRendered=!0,this._setInitialKeyboardFocus(),this.getCtx().setKeyboardFocusArray([this]),this._updateZoomLimits()},t.ThematicMap.prototype._renderCompleted=function(){this.AnimationStopped||this.RenderComplete(),this.Animation=null,this.AnimationStopped=!1},t.ThematicMap.prototype._updateZoomLimits=function(){var t=this._calcMinZoom();this._pzc.setMinZoom(t),this._pzc.setMaxZoom(t*this.getMaxZoomFactor())},t.ThematicMap.prototype.OnUpdateLayerEnd=function(){this._areaLayer.getIsolatedArea()&&this._pzc.zoomToFit(null,this._areaLayer.getLayerDim()),this._initialZooming&&this._zoomData(),this._renderCompleted()},t.ThematicMap.prototype.getMapName=function(){return this._mapName},t.ThematicMap.prototype._transformContainers=function(e){var a=new t.Matrix;a=a.translate(e.getTx(),e.getTy()),this.isMarkerZoomBehaviorFixed()&&this._dataPointLayers.setMatrix(a),this._labelLayers.setMatrix(a),this._linkLayers.setMatrix(a)},t.ThematicMap.prototype._constrainPanning=function(e){var a=this._pzc.getZoomToFitPadding(),i=this._pzc.getSize(),r=new t.Rectangle(a,a,i.w-2*a,i.h-2*a),n=this._areaLayer.getLayerDim(),s=n.x*e,o=n.y*e,l=n.w*e,h=n.h*e;if(l>r.w)this._pzc.setMinPanX(r.x+r.wt-(s+l)),this._pzc.setMaxPanX(r.x-s);else{var c=(r.x+r.w)/2-(s+l/2);this._pzc.setMinPanX(c),this._pzc.setMaxPanX(c)}if(h>r.h)this._pzc.setMinPanY(r.y+r.h-(o+h)),this._pzc.setMaxPanY(r.y-o);else{var _=(r.y+r.h)/2-(o+h/2);this._pzc.setMinPanY(_),this._pzc.setMaxPanY(_)}},t.ThematicMap.prototype._updateAnimator=function(e,a){var i=e.animator;if(i){var r=this._pzc.getContentPane(),n=i.getDestVal(r,r.getMatrix);a&&(this._currentAnimMatrix=r.getMatrix(),i.addProp(t.Animator.TYPE_MATRIX,this,this._getCenteredObjsMatrix,this._setCenteredObjsMatrix,n));var s=new t.Matrix(1,0,0,1,n.getTx(),n.getTy());this.isMarkerZoomBehaviorFixed()&&i.addProp(t.Animator.TYPE_MATRIX,this._dataPointLayers,this._dataPointLayers.getMatrix,this._dataPointLayers.setMatrix,s),i.addProp(t.Animator.TYPE_MATRIX,this._labelLayers,this._labelLayers.getMatrix,this._labelLayers.setMatrix,s),i.addProp(t.Animator.TYPE_MATRIX,this._linkLayers,this._linkLayers.getMatrix,this._linkLayers.setMatrix,s)}},t.ThematicMap.prototype.HandleZoomEvent=function(e){switch(e.subtype){case"adjustPanConstraints":this._panning&&this._constrainPanning(e.newZoom);break;case"zooming":case"elasticAnimBegin":this._updateAnimator(e,!0);break;case"zoomed":var a=e.newZoom;if(null!=a){var i=this._pzc.getContentPane().getMatrix();e.animator=null,this.dispatchEvent(t.EventFactory.newThematicMapViewportChangeEvent(i.getTx(),i.getTy(),a)),this._transformContainers(i);for(var r=0;r<this._layers.length;r++)this._layers[r].HandleZoomEvent(e,i)}break;case"zoomAndCenter":this.fitSelectedRegions();break;case"zoomToFitEnd":this.dispatchEvent(t.EventFactory.newThematicMapViewportChangeEvent())}},t.ThematicMap.prototype.HandlePanEvent=function(e){var a=e.subtype;if("elasticAnimBegin"==a||"panning"==a)this._updateAnimator(e,!1);else if("panned"==a&&null!=e.newX){var i=this._pzc.getContentPane().getMatrix();e.animator=null,this.dispatchEvent(t.EventFactory.newThematicMapViewportChangeEvent(i.getTx(),i.getTy(),this._pzc.getZoom())),this._transformContainers(i);for(var r=0;r<this._layers.length;r++)this._layers[r].HandlePanEvent(i)}},t.ThematicMap.prototype.setZooming=function(t){this._zooming=t},t.ThematicMap.prototype.setPanning=function(t){this._panning=t},t.ThematicMap.prototype._zoomData=function(){var e=this._dataAreaLayers.getDimensions(),a=this._dataPointLayers.getDimensions();if(this.isMarkerZoomBehaviorFixed()){var i=this._pzc.getContentPane().getMatrix();a.w/=i.getA(),a.h/=i.getD(),a.x/=i.getA(),a.y/=i.getD()}var r,n,s=e.getUnion(a);this.StopAnimation(!0),this._pzc.isZoomingEnabled()||(r=this._pzc.getMaxZoom(),this._pzc.setMaxZoom(r*t.ThematicMap.DEFAULT_MAX_ZOOM_FACTOR)),t.Agent.isEnvironmentTest()||(n=new t.Animator(this.getCtx(),.3)),s.w>0&&s.h>0?this._pzc.zoomToFit(n,s):this._pzc.zoomToFit(n,this._areaLayer.getLayerDim()),n&&n.play(),r&&this._pzc.setMaxZoom(r)},t.ThematicMap.prototype._zoomToFitBounds=function(e){var a=new t.Animator(this.getCtx(),.3);this._pzc.zoomToFit(a,e),a.play()},t.ThematicMap.prototype.fitRegion=function(t){t||(t=this._zoomToFitObject),t||(t=this._clickedObject),this._zoomToFitBounds(t.getDimensions())},t.ThematicMap.prototype.fitSelectedRegions=function(){if(this._clickedDataLayerId){var t=this.getLayer(this._clickedLayerName).getDataLayer(this._clickedDataLayerId);if(t){var e=t._selectionHandler;if(e){for(var a=e.getSelection(),i=0;i<a.length;i++)a[i]=a[i].getDisplayable();if(a.length>0){for(var r=a[0].getDimensions(),n=1;n<a.length;n++)r=r.getUnion(a[n].getDimensions());this._zoomToFitBounds(r)}}}}},t.ThematicMap.prototype.fitMap=function(){var e=new t.Animator(this.getCtx(),.3);this._pzc.zoomToFit(e),e.play()},t.ThematicMap.prototype.getNavigableAreas=function(){var t=[];if(this._areaLayer){var e=this._areaLayer.getDataLayers();for(var a in e)t=t.concat(e[a].getNavigableAreaObjects())}return t},t.ThematicMap.prototype.getNavigableMarkers=function(){for(var t=[],e=0;e<this._layers.length;e++){var a=this._layers[e].getDataLayers();for(var i in a)t=t.concat(a[i].getMarkerObjects())}return t},t.ThematicMap.prototype.getNavigableLinks=function(){for(var t=[],e=0;e<this._layers.length;e++){var a=this._layers[e].getDataLayers();for(var i in a)t=t.concat(a[i].getLinkObjects())}return t},t.ThematicMap.prototype._setCenteredObjsMatrix=function(t){if(this._currentAnimMatrix=t,this.isMarkerZoomBehaviorFixed()){for(var e=this.getNavigableMarkers(),a=0;a<e.length;a++)e[a].HandleZoomEvent(t);for(var i=this._labelLayers.getNumChildren(),r=0;r<i;r++)for(var n=this._labelLayers.getChildAt(r),s=n.getNumChildren(),l=0;l<s;l++){var h=n.getChildAt(l);h instanceof o&&h.update(t)}}},t.ThematicMap.prototype._getCenteredObjsMatrix=function(){return this._currentAnimMatrix},t.ThematicMap.prototype.setClickInfo=function(t,e,a){this._clickedLayerName=e,this._clickedDataLayerId=t,this._clickedObject=a},t.ThematicMap.prototype.dispatchEvent=function(e){"selection"==e.type&&this._handleSelectionEvent(e),t.ThematicMap.superclass.dispatchEvent.call(this,e)},t.ThematicMap.prototype._handleSelectionEvent=function(e){if(this._clickedDataLayerId){this._selectedRowKeys=e.selection;var a=this.getLayer(this._clickedLayerName).getDataLayer(this._clickedDataLayerId);this._selectedAreas[this._clickedLayerName]=a.getSelectedAreas(this._selectedRowKeys),e.clientId=this._clickedDataLayerId,this._clickedObject&&!(this._clickedObject instanceof t.SimpleMarker||this._clickedObject instanceof t.ImageMarker)&&(this._zoomToFitObject=this._clickedObject)}else this._zoomToFitObject=null},t.ThematicMap.prototype.destroy=function(){for(var e=this.getAllLayers(),a=0;a<e.length;a++)e[a].destroy();t.ThematicMap.superclass.destroy.call(this)},t.ThematicMap.prototype.OnAnimationEnd=function(){this._oldPzc&&(this.removeChild(this._oldPzc),this._oldPzc=null),this._renderCompleted(),this._initialZooming&&this._zoomData(),this.Options.highlightedCategories&&this.Options.highlightedCategories.length>0&&this.highlight(this.Options.highlightedCategories),this._bListenersRemoved&&(this.EventManager.addListeners(this),this._bListenersRemoved=!1)},t.ThematicMap.prototype.getAutomation=function(){return this.Automation||(this.Automation=new a(this)),this.Automation},t.ThematicMap.prototype.highlight=function(e){this.Options.highlightedCategories=t.JsonUtils.clone(e),t.CategoryRolloverHandler.highlight(e,this.getNavigableAreas().concat(this.getNavigableMarkers()).concat(this.getNavigableLinks()),"any"==this.Options.highlightMatch)},t.ThematicMap.prototype.processDefaultHoverEffect=function(t,e){var a=this._getDataItemById(t);a&&a.processDefaultHoverEffect(e)},t.ThematicMap.prototype.processDefaultSelectionEffect=function(t,e){var a=this._getDataItemById(t);a&&a.processDefaultSelectionEffect(e)},t.ThematicMap.prototype.processDefaultFocusEffect=function(t,e){var a=this._getDataItemById(t);a&&a.processDefaultFocusEffect(e)},t.ThematicMap.prototype._getDataItemById=function(e){for(var a=this.getCtx(),i=0;i<this._layers.length;i++){var r=this._layers[i].getDataLayers();for(var n in r)for(var s=r[n].getMarkerObjects(),o=0;o<s.length;o++)if(t.Obj.compareValues(a,s[o].getId(),e))return s[o]}return null},t.ThematicMap.prototype._getAreaFromDataLayer=function(t,e){for(var a=e.getAreaObjects(),i=0;i<a.length;i++)if(a[i].getLocation()===t)return a[i];return null};var e=function(t){this.Init({alta:e.SKIN_ALTA},t)};t.Obj.createSubclass(e,t.BaseComponentDefaults),e.SKIN_ALTA={animationDuration:500,animationOnDisplay:"none",animationOnMapChange:"none",highlightMatch:"all",hoverBehavior:"none",initialZooming:"none",markerZoomBehavior:"fixed",panning:"none",tooltipDisplay:"auto",touchResponse:"auto",visualEffects:"none",zooming:"none",styleDefaults:{skin:"alta",_areaStyle:{backgroundColor:"#DDDDDD",borderColor:"#FFFFFF"},hoverBehaviorDelay:200,dataAreaDefaults:{borderColor:"#FFFFFF",hoverColor:"#FFFFFF",opacity:1,selectedInnerColor:"#FFFFFF",selectedOuterColor:"#000000"},dataMarkerDefaults:{borderColor:"#FFFFFF",borderStyle:"solid",borderWidth:.5,color:"rgb(51,51,51)",height:8,labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12+"color:#333333"),opacity:1,scaleX:1,scaleY:1,shape:"circle",width:8},linkDefaults:{color:"#9bb2c7",_hoverColor:"#FFFFFF",_selectedColor:"#000000",width:2},labelStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA_12)},resources:{images:{},translations:{}}},e.DEFAULT_AREA_LAYER={animationOnLayerChange:"none",labelDisplay:"auto",labelType:"short"},e.DEFAULT_DATA_LAYER={animationOnDataChange:"none",selectionMode:"none"},e.prototype.calcAreaLayerOptions=function(a,i){var r=e.DEFAULT_AREA_LAYER;return i&&(r=t.JsonUtils.merge({labelDisplay:"off"},r)),t.JsonUtils.merge(a,r)},e.prototype.calcDataLayerOptions=function(a){return t.JsonUtils.merge(a,e.DEFAULT_DATA_LAYER)},e.getGapSize=function(t,e){return Math.ceil(e*t.getGapRatio())},e.prototype.getNoCloneObject=function(){return{mapProvider:!0,areaLayers:{areaDataLayer:{areas:!0,markers:!0,links:!0}},pointDataLayers:{markers:!0,links:!0},areas:!0,markers:!0,links:!0}},e.prototype.getAnimationDuration=function(t){return t.animationDuration};var a=function(t){this._tmap=t};t.Obj.createSubclass(a,t.Automation),a.prototype.GetSubIdForDomElement=function(t){var e=this._tmap.getEventManager().GetLogicalObject(t);return e&&(e instanceof h||e instanceof l)?this._getSubId(e):null},a.prototype.getDomElementForSubId=function(e){if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._tmap);var a=e.indexOf(":"),i=e.indexOf("[");if(a>0&&i>0){var r=e.substring(0,a),n=e.substring(a+1,i),s=parseInt(e.substring(i+1,e.length-1));return this._getDomElement(r,n,s)}return null},a.prototype.getData=function(t,e,a){var i=this._getDataObject(t,e,a);if(i){var r={};r.color=i.getDatatipColor(),r.tooltip=i.getShortDesc();var n=i.getLabel();return r.label=n?n.getTextString():null,r.selected=i.isSelected(),r}return null},a.prototype._getDomElement=function(t,e,a){var i=this._getDataObject(t,e,a);return i?i.getDisplayable().getElem():null},a.prototype._getSubId=function(e){for(var a=e.getDisplayable(),i=this._tmap.getAllLayers(),r=0;r<i.length;r++){var n=i[r].getDataLayers();for(var s in n)if(a instanceof t.Path){for(var o=n[s].getAreaObjects(),l=0;l<o.length;l++)if(o[l]===e)return this._getDataLayerId(s)+":area["+l+"]";var h=n[s].getLinkObjects();for(l=0;l<h.length;l++)if(h[l]===e)return this._getDataLayerId(s)+":link["+l+"]"}else{var c=n[s].getMarkerObjects();for(l=0;l<c.length;l++)if(c[l]===e)return this._getDataLayerId(s)+":marker["+l+"]"}}return null},a.prototype._getDataObject=function(t,e,a){for(var i=this._tmap.getAllLayers(),r=0;r<i.length;r++){var n=i[r].getDataLayers();for(var s in n)if(this._getDataLayerId(s)==t){if("area"==e)return n[s].getDataAreaCollection()[a];if("marker"==e)return n[s].getDataMarkerCollection()[a];if("link"==e)return n[s].getDataLinkCollection()[a]}}return null},a.prototype._getDataLayerId=function(t){var e=t.lastIndexOf(":");return e>0?t.substring(e+1):t};var i=function(t,e){this.Init(t,e)};t.Obj.createSubclass(i,t.Path),i.HOVER_STROKE_WIDTH=2,i.SELECTED_INNER_STROKE_WIDTH=1,i.SELECTED_OUTER_STROKE_WIDTH=4,i.SELECTED_HOVER_OUTER_STROKE_WIDTH=6,i.prototype.Init=function(t,e){i.superclass.Init.call(this,t),this.Zoom=1,this._bSupportsVectorEffects=e},i.prototype.setSelected=function(t){this.IsSelected!=t&&(t&&(this.isHoverEffectShown()?(this.CreateSelectedHoverStrokes(),this.SelectedHoverInnerStroke=this._adjustStrokeZoomWidth(this.SelectedHoverInnerStroke,i.HOVER_STROKE_WIDTH),this.SelectedHoverOuterStroke=this._adjustStrokeZoomWidth(this.SelectedHoverOuterStroke,i.SELECTED_HOVER_OUTER_STROKE_WIDTH)):(this.SelectedInnerStroke=this._adjustStrokeZoomWidth(this.SelectedInnerStroke,i.SELECTED_INNER_STROKE_WIDTH),this.SelectedOuterStroke=this._adjustStrokeZoomWidth(this.SelectedOuterStroke,i.SELECTED_OUTER_STROKE_WIDTH))),i.superclass.setSelected.call(this,t))},i.prototype.showHoverEffect=function(){this.isSelected()?(this.CreateSelectedHoverStrokes(),this.SelectedHoverInnerStroke=this._adjustStrokeZoomWidth(this.SelectedHoverInnerStroke,i.HOVER_STROKE_WIDTH),this.SelectedHoverOuterStroke=this._adjustStrokeZoomWidth(this.SelectedHoverOuterStroke,i.SELECTED_HOVER_OUTER_STROKE_WIDTH)):this.HoverInnerStroke=this._adjustStrokeZoomWidth(this.HoverInnerStroke,i.HOVER_STROKE_WIDTH),i.superclass.showHoverEffect.call(this)},i.prototype.CreateSelectedHoverStrokes=function(){this.SelectedHoverInnerStroke||(this.SelectedHoverInnerStroke=new t.Stroke(this.HoverInnerStroke.getColor(),this.HoverInnerStroke.getAlpha(),i.HOVER_STROKE_WIDTH,this._bSupportsVectorEffects)),this.SelectedHoverOuterStroke||(this.SelectedHoverOuterStroke=new t.Stroke(this.SelectedOuterStroke.getColor(),this.SelectedOuterStroke.getAlpha(),i.SELECTED_HOVER_OUTER_STROKE_WIDTH,this._bSupportsVectorEffects))},i.prototype.hideHoverEffect=function(){this.isSelected()&&(this.SelectedInnerStroke=this._adjustStrokeZoomWidth(this.SelectedInnerStroke,i.SELECTED_INNER_STROKE_WIDTH),this.SelectedOuterStroke=this._adjustStrokeZoomWidth(this.SelectedOuterStroke,i.SELECTED_OUTER_STROKE_WIDTH)),i.superclass.hideHoverEffect.call(this)},i.prototype._updateStrokeZoomWidth=function(e,a){if(!this._bSupportsVectorEffects){var i=e.getStroke();if(i){var r=new t.Stroke(i.getColor(),i.getAlpha(),a/this.Zoom,i.isFixedWidth());e.setStroke(r)}}},i.prototype._adjustStrokeZoomWidth=function(e,a){return this._bSupportsVectorEffects?e:new t.Stroke(e.getColor(),e.getAlpha(),a/this.Zoom,e.isFixedWidth())},i.prototype.handleZoomEvent=function(t){this.Zoom=t.getA(),this.isSelected()?this.isHoverEffectShown()?(this._updateStrokeZoomWidth(this.InnerShape,i.HOVER_STROKE_WIDTH),this._updateStrokeZoomWidth(this,i.SELECTED_HOVER_OUTER_STROKE_WIDTH)):(this._updateStrokeZoomWidth(this.InnerShape,i.SELECTED_INNER_STROKE_WIDTH),this._updateStrokeZoomWidth(this,i.SELECTED_OUTER_STROKE_WIDTH)):this.isHoverEffectShown()?this._updateStrokeZoomWidth(this.InnerShape,i.HOVER_STROKE_WIDTH):this._updateStrokeZoomWidth(this,1)};var r,n=function(t,e,a){this.Init(t,e,a)};t.Obj.createSubclass(n,t.Container),n.prototype.Init=function(e,a,i){if(n.superclass.Init.call(this,e),this._dataItem=a,a instanceof t.BaseComponent)this._width=a.getWidth(),this._height=a.getHeight(),this.addChild(a);else{Array.isArray(a)?a.forEach(function(t){this.getElem().appendChild(t)}.bind(this)):this.getElem().appendChild(a);var r=t.DisplayableUtils.getDimensionsForced(e,this);this._width=r.w,this._height=r.h}this._boundingRect=new t.Rect(e,0,0,this._width,this._height),this._boundingRect.setInvisibleFill();var s=new t.Stroke(i.selectedInnerColor,1,2),o=new t.Stroke("rgb(235, 236, 237)",1,2),l=new t.Stroke(i.selectedInnerColor,1,1),h=new t.Stroke(i.selectedOuterColor,1,2),c=new t.Stroke(i.selectedInnerColor,1,2),_=new t.Stroke(i.selectedOuterColor,1,2);this._boundingRect.setHoverStroke(s,o).setSelectedStroke(l,h).setSelectedHoverStroke(c,_),this._boundingRect.setStrokeAlignment("outer"),this.addChildAt(this._boundingRect,0)},n.prototype.setAriaProperty=function(e,a){t.Agent.isTouchDevice()?this._boundingRect.setAriaProperty(e,a):n.superclass.setAriaProperty.call(this,e,a)},n.prototype.setAriaRole=function(e){t.Agent.isTouchDevice()?this._boundingRect.setAriaRole(e):n.superclass.setAriaRole.call(this,e)},n.prototype.getWidth=function(){return this._width},n.prototype.getHeight=function(){return this._height},n.prototype.setSelectable=function(t){this._boundingRect.setSelectable(t)},n.prototype.isSelectable=function(){return this._boundingRect.isSelectable()},n.prototype.isSelected=function(){return this._boundingRect.isSelected()},n.prototype.setSelected=function(t){this._boundingRect.setSelected(t)},n.prototype.showHoverEffect=function(){this._boundingRect.showHoverEffect()},n.prototype.hideHoverEffect=function(){this._boundingRect.hideHoverEffect()},n.prototype.getRootElement=function(){return this._dataItem},n.prototype.updateRootElement=function(e){this._dataItem!==e&&(this._dataItem&&(this._dataItem instanceof t.BaseComponent?this.removeChild(this._dataItem):Array.isArray(this._dataItem)?this._dataItem.forEach(function(t){this.getElem().removeChild(t)}.bind(this)):this.getElem().removeChild(this._dataItem)),e instanceof t.BaseComponent?this.addChild(e):Array.isArray(e)?e.forEach(function(t){this.getElem().appendChild(t)}.bind(this)):this.getElem().appendChild(e),this._dataItem=e)},n.prototype.fireKeyboardListener=function(e){this._dataItem instanceof t.BaseComponent&&this._dataItem.fireKeyboardListener(e)},this?this.DvtBaseMapManager?r=this.DvtBaseMapManager:(r={},this.DvtBaseMapManager=r,r._UNPROCESSED_MAPS=[[],[],[]],r._UNPROCESSED_PARENT_UPDATES=[[]]):window.DvtBaseMapManager?r=window.DvtBaseMapManager:(r={},window.DvtBaseMapManager=r,r._UNPROCESSED_MAPS=[[],[],[]],r._UNPROCESSED_PARENT_UPDATES=[[]]),t.Obj.createSubclass(r,t.Obj),r.TYPE_LABELS=0,r.TYPE_PATH=1,r.TYPE_PARENTREGION_CHILDREN=2,r.TYPE_LABELINFO=3,r.TYPE_DIM=4,r._INDEX="__index",r._GLOBAL_MAPS=new Object,r.getBaseMapDim=function(e,a){r._processUnprocessedMaps();var i=r._GLOBAL_MAPS[e][a];if(i){var n=i[r.TYPE_DIM];if(n)return new t.Rectangle(n[0],n[1],n[2],n[3])}return null},r.getAreaLabelInfo=function(t,e){r._processUnprocessedMaps();var a=r._GLOBAL_MAPS[t][e];return a?a[r.TYPE_LABELINFO]:null},r.getAreaIds=function(t,e){var a=[],i=r.getAreaPaths(t,e);for(var n in i)a.push(n);return a},r.getAreaLabels=function(t,e){r._processUnprocessedMaps();var a=r._GLOBAL_MAPS[t][e];return a?a[r.TYPE_LABELS]:null},r.getLongAreaLabel=function(t,e,a){r._processUnprocessedMaps();var i,n=r._GLOBAL_MAPS[t][e];return n&&(i=n[r.TYPE_LABELS]),i&&i[a]?i[a][1]:null},r.getCityCoordinates=function(e,a){r._processUnprocessedMaps();var i=r._GLOBAL_MAPS[e];if(i){var n=i.cities;if(n){var s=n[r.TYPE_PATH][a];if(s)return new t.Point(s[0],s[1])}}return null},r.getCityLabel=function(t,e){r._processUnprocessedMaps();var a=r._GLOBAL_MAPS[t];if(a){var i=a.cities;if(i){var n=i[r.TYPE_LABELS][e];if(n)return n[1]}}return null},r.getAreaCenter=function(e,a,i){r._processUnprocessedMaps();var n=r._GLOBAL_MAPS[e];if(n){var s=n[a];if(s){var o=s[r.TYPE_LABELINFO];if(o&&o[i]){var l=o[i][0];return t.Rectangle.create(l).getCenter()}}}return null},r.getAreaPaths=function(t,e,a,i,n){r._processUnprocessedMaps();var s=r._GLOBAL_MAPS[t][e],o=s[r.TYPE_PATH],l=s[r.TYPE_DIM];return l?r._simplifyAreaPaths(o,l[2],l[3],a,i,n):o},r.getPathForArea=function(t,e,a){r._processUnprocessedMaps();var i=r._GLOBAL_MAPS[t][e];return i?i[r.TYPE_PATH][a]:null},r.registerBaseMapLayer=function(t,e,a,i,n,s,o,l){var h=r._GLOBAL_MAPS[t];h||((h=new Object)[r._INDEX]=new Array,r._GLOBAL_MAPS[t]=h);var c=h[e];c||(c=new Object,h[e]=c,null!=o&&(h[r._INDEX][o]=e)),c[r.TYPE_LABELS]=a,c[r.TYPE_PATH]=i,c[r.TYPE_PARENTREGION_CHILDREN]=n,c[r.TYPE_LABELINFO]=s,c[r.TYPE_DIM]=l,c[r._INDEX]=o},r.registerResourceBundle=function(t,e,a){var i,n=r._GLOBAL_MAPS[t];n||(n=new Object,r._GLOBAL_MAPS[t]=n),(i=n[e])||(i=new Object,n[e]=i),(i=n[e])&&(i[r.TYPE_LABELS]=a)},r.updateResourceBundle=function(t,e,a){var i=r._GLOBAL_MAPS[t];if(i){var n=i[e];if(n)for(var s in a)n[r.TYPE_LABELS][s]=a[s]}},r._processUnprocessedMaps=function(){var t,e=r._UNPROCESSED_MAPS;if(e){for(p=0;p<e[0].length;p++)t=e[0][p],r.registerBaseMapLayer(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7]);for(p=0;p<e[1].length;p++)t=e[1][p],r.registerResourceBundle(t[0],t[1],t[2]);for(p=0;p<e[2].length;p++)t=e[2][p],r.updateResourceBundle(t[0],t[1],t[2]);r._UNPROCESSED_MAPS=[[],[],[]]}var a=r._UNPROCESSED_PARENT_UPDATES;if(a){for(p=0;p<a[0].length;p++){var i,n,s=(t=a[0][p])[0],o=t[1],l=t[2],h=r._GLOBAL_MAPS[s];if(h){if(n=h[o]){n[r.TYPE_PARENTREGION_CHILDREN]=t[3],i=n[r.TYPE_DIM];var c=n[r._INDEX],_=h[r._INDEX];_.splice(c,0,l),h[l][r._INDEX]=c;for(var p=c+1;p<_.length;p++){var g=h[_[p]];g&&g[r._INDEX]++}}(n=h[t[2]])&&(n[r.TYPE_DIM]=i)}}r._UNPROCESSED_PARENT_UPDATES=[[]]}},r._simplifyAreaPaths=function(e,a,i,r,n,s){if(s>0){var o=r/a,l=n/i,h=1/(Math.min(o,l)*s);if(h<=1)return e;var c=[];if(e)for(var _ in e){var p=e[_];isNaN(p)&&(p=t.PathUtils.createPathArray(e[_])),c[_]=t.PathUtils.simplifyPath(p,h)}return c}return e},r.getLayerIds=function(t,e){r._processUnprocessedMaps();var a=r._GLOBAL_MAPS[t][e],i={};if(a){var n=a[r.TYPE_LABELS];for(var s in n)i[s]=n[s][1];if("cities"!==e&&!n)for(var o=r.getAreaIds(t,e),l=0;l<o.length;l++)i[o[l]]=null}return i};var s=function(t,e){this.Init(t,e)};t.Obj.createSubclass(s,t.Obj),s.prototype.Init=function(t,e){this._displayable=t,this._category=e},s.prototype.getCategories=function(){return this._category},s.prototype.getDisplayables=function(){return[this._displayable]};var o=function(t,e,a,i,r,n){this.Init(t,e,a,i,r,n)};t.Obj.createSubclass(o,t.OutputText),o.prototype.Init=function(e,a,i,r,n,s){if(o.superclass.Init.call(this,e,a,0,0),this._bSupportsVectorEffects=s,this._boundRectangle=new Array,this.setMouseEnabled(!1),this.alignCenter(),this.alignMiddle(),this._center=null,this._labelDisplay=r,this._parentContainer=n,i&&(this._boundRectangle.push(t.Rectangle.create(i[0])),i.length>1)){this._leaderLines=new Array;for(var l=1;l<i.length;l++){var h=i[l];this._boundRectangle.push(t.Rectangle.create(h[0]));var c=new t.Polyline(e,h[1]);c.setPixelHinting(!0);var _=new t.Stroke("#000000",1,1,this._bSupportsVectorEffects);c.setStroke(_),this._leaderLines.push(c)}}},o.prototype.addBounds=function(t){this._boundRectangle.push(t)},o.prototype.hasBounds=function(){return this._boundRectangle.length>0},o.prototype.update=function(e){for(var a=e.getA(),i=-1,r=this.getDimensions(),n=0;n<this._boundRectangle.length;n++){var s=this._boundRectangle[n].w*a,o=this._boundRectangle[n].h*a;if(r.h<=o&&r.w<=s){i=n;break}}if(-1==i&&"on"==this._labelDisplay&&(i=this._boundRectangle.length-1),this._currentState!=i){if(-1==i)this.reset();else{this.getParent()||this._parentContainer.addChild(this);var l=this._boundRectangle[i].getCenter();if(this.setCenter(l),this._leaderLines)if(this._parentContainer.removeChild(this._leaderLine),this._leaderLine=null,i>0){this._leaderLine=this._leaderLines[i-1],this._parentContainer.addChild(this._leaderLine),(p=this.getCSSStyle()).setStyle(t.CSSStyle.COLOR,"#000000"),this.setCSSStyle(p);var h=this._boundRectangle[i],c=this._leaderLine.getPoints(),_=c.length;h.x>c[_-2]?(this.alignLeft(),this.alignMiddle(),this.setCenter(new t.Point(h.x,l.y))):h.y>c[_-1]?(this.alignTop(),this.alignCenter(),this.setCenter(new t.Point(l.x,h.y))):h.x+h.w<c[_-2]?(this.alignRight(),this.alignMiddle(),this.setCenter(new t.Point(h.x+h.w,l.y))):h.y+h.h<c[_-1]&&(this.alignBottom(),this.alignCenter(),this.setCenter(new t.Point(l.x,h.y+h.h)))}else{var p;this.alignCenter(),this.alignMiddle(),(p=this.getCSSStyle()).setStyle(t.CSSStyle.COLOR,this._labelColor),this.setCSSStyle(p)}}this._currentState=i}if(-1!=this._currentState){var g=new t.Matrix;if(this.setMatrix(g.translate(a*this._center.x-this._center.x,a*this._center.y-this._center.y)),this._leaderLine&&(this._leaderLine.setMatrix(new t.Matrix(a,0,0,a)),!this._bSupportsVectorEffects)){var d=this._leaderLine.getStroke(),u=new t.Stroke(d.getColor(),d.getAlpha(),1/a,d.isFixedWidth());this._leaderLine.setStroke(u)}}},o.prototype.setCenter=function(t){this._center=t,this.setX(t.x),this.setY(t.y)},o.prototype.getLeaderLine=function(){return this._leaderLine},o.prototype.getCenter=function(){return this._center},o.prototype.setCSSStyle=function(e){o.superclass.setCSSStyle.call(this,e),this._labelColor||(this._labelColor=e.getStyle(t.CSSStyle.COLOR))},o.prototype.reset=function(){this._parentContainer.removeChild(this),this._currentState=-1,this._leaderLine&&(this._parentContainer.removeChild(this._leaderLine),this._leaderLine=null)};var l=function(t,e,a,i,r,n){this.Init(t,e,a,i,r,n)};t.Obj.createSubclass(l,t.Obj),l.ANIMATION_DELETE_PRIORITY=0,l.ANIMATION_UPDATE_PRIORITY=1,l.ANIMATION_INSERT_PRIORITY=2,l.prototype.Init=function(t,e,a,i,r,n){if(this._data=t,this._itemData=this._data._itemData,this._dataLayer=e,this.Displayable=a,this._isSelected=!1,this._isShowingHoverEffect=!1,this._isShowingKeyboardFocusEffect=!1,this.Displayable.setDataColor&&this.Displayable.setDataColor(t.color),this._label=i,this._center=r,this.Zoom=1,this._view=e.getMap(),this._locationName=n,this._data.categories||this._label&&(this._data.categories=[this._label.getTextString()]),"auto"==this._view.getDisplayTooltips()&&n&&(this._data.shortDesc=t.shortDesc?n+": "+t.shortDesc:n),this.Displayable){var s=t.svgStyle||t.style,o=t.svgClassName||t.className;this.Displayable.setStyle(s).setClassName(o),this.Displayable.setAriaRole("img")}this.UpdateAriaLabel(),this.setSelectable(this.isSelectable())},l.prototype.getId=function(){return this._data.id},l.prototype.getLocation=function(){return this._data.location},l.prototype.getLocationName=function(){return this._locationName},l.prototype.getCenter=function(){return this._center},l.prototype._setCenter=function(t){this._center=t,this.__recenter()},l.prototype.getDisplayable=function(){return this.Displayable},l.prototype.getLabel=function(){return this._label},l.prototype.getDataLayer=function(){return this._dataLayer},l.prototype.setVisible=function(t){this.Displayable.setVisible(t),this._label&&this._label.setVisible(t)},l.prototype.getShortDesc=function(){return this._data.shortDesc},l.prototype.removeLabel=function(){this._label=null},l.prototype.getSize=function(){return this.Displayable.getWidth?this.Displayable.getWidth()*this.Displayable.getHeight():0},l.prototype.getCategories=function(){var t=this._data.categories;return t||[]},l.prototype.getDatatip=function(){if("none"!=this._view.getDisplayTooltips()){var t=this._view.getOptions()._tooltip;return t?this._view.getCtx().getTooltipManager().getCustomTooltip(t.renderer,this.getDataContext()):this.getShortDesc()}return null},l.prototype.getDataContext=function(){var t=this._data._noTemplate?this._itemData:this._data;return{color:this.getDatatipColor(),component:this._view.getOptions()._widgetConstructor,data:t,id:this.getId(),itemData:this._itemData,label:this._label?this._label.getTextString():null,location:this.getLocation(),locationName:this.getLocationName(),tooltip:this.getShortDesc(),x:this._data.x,y:this._data.y}},l.prototype.getDatatipColor=function(){return this._data.color?this._data.color:"#000000"},l.prototype.getAriaLabel=function(){var e=[];return this.isSelectable()&&e.push(this._view.getOptions().translations[this.isSelected()?"stateSelected":"stateUnselected"]),t.Displayable.generateAriaLabel(this.getShortDesc(),e)},l.prototype.getDisplayables=function(){return[this.getDisplayable()]},l.prototype.UpdateAriaLabel=function(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.Displayable.setAriaProperty("label",e)}},l.prototype.setSelectable=function(e){var a=this.getLabel();this.Displayable.setSelectable&&(this.Displayable.setSelectable(e),a&&e&&a.setCursor(t.SelectionEffectUtils.getSelectingCursor()))},l.prototype.isSelectable=function(){return!!this.Displayable.isSelectable&&("off"!==this._data.selectable&&this._dataLayer.isSelectable())},l.prototype.isSelected=function(){return this._isSelected},l.prototype.setSelected=function(t){if(this.isSelectable()){var e=this._getState();this._isSelected=t,this._dataLayer.getOptions().selectionRenderer?this._callCustomRenderer(this._dataLayer.getOptions().selectionRenderer,this._getState(),e):this.processDefaultSelectionEffect(t),this.UpdateAriaLabel()}},l.prototype.showHoverEffect=function(){if(!this.IsHoverEffectShown()){var t=this._getState();this._isShowingHoverEffect=!0,this._dataLayer.getOptions().hoverRenderer?this._callCustomRenderer(this._dataLayer.getOptions().hoverRenderer,this._getState(),t):this.processDefaultHoverEffect(!0)}},l.prototype.hideHoverEffect=function(){if(this.IsHoverEffectShown()){var t=this._getState();this._isShowingHoverEffect=!1,this._dataLayer.getOptions().hoverRenderer?this._callCustomRenderer(this._dataLayer.getOptions().hoverRenderer,this._getState(),t):this.processDefaultHoverEffect(!1)}},l.prototype.isDragAvailable=function(t){for(var e=this._dataLayer.getClientId(),a=0;a<t.length;a++)if(t[a]==e)return e;return e},l.prototype.getDragTransferable=function(t,e){return this._dataLayer.__getDragTransferable(this)},l.prototype.getDragFeedback=function(t,e){return this._dataLayer.__getDragFeedback()},l.prototype.getNextNavigable=function(e){var a;if(e.type==t.MouseEvent.CLICK)return this;if(e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;if((e.keyCode==t.KeyboardEvent.OPEN_ANGLED_BRACKET||t.KeyboardEvent.CLOSE_ANGLED_BRACKET)&&e.altKey){var i=this.getDataLayer().getNavigableLinksForNodeId(this.getId());a=u.getFirstNavigableLink(this,e,i)}else a=t.KeyboardHandler.getNextAdjacentNavigable(this,e,this.GetNavigables());return this.getDataLayer().getMap().ensureObjInViewport(e,a),a},l.prototype.GetNavigables=function(){return this.getDataLayer().getMap().getNavigableMarkers()},l.prototype.getKeyboardBoundingBox=function(e){return this.Displayable.getParent()?this.Displayable.getDimensions(e||this.Displayable.getCtx().getStage()):new t.Rectangle(0,0,0,0)},l.prototype.getTargetElem=function(){return this.Displayable.getElem()},l.prototype.showKeyboardFocusEffect=function(){if(!this.isShowingKeyboardFocusEffect()){var t=this._getState();this._isShowingKeyboardFocusEffect=!0,this._dataLayer.getOptions().focusRenderer?this._callCustomRenderer(this._dataLayer.getOptions().focusRenderer,this._getState(),t):this.processDefaultFocusEffect(!0)}},l.prototype.hideKeyboardFocusEffect=function(){if(this.isShowingKeyboardFocusEffect()){var t=this._getState();this._isShowingKeyboardFocusEffect=!1,this._dataLayer.getOptions().focusRenderer?this._callCustomRenderer(this._dataLayer.getOptions().focusRenderer,this._getState(),t):this.processDefaultFocusEffect(!1)}},l.prototype.isShowingKeyboardFocusEffect=function(){return this._isShowingKeyboardFocusEffect},l.prototype.HandleZoomEvent=function(t){this.Displayable.getParent()&&(this.Zoom=t.getA(),this.__recenter())},l.prototype.positionLabel=function(){if(this._label){this._label.alignCenter();var e,a=this.Displayable.getCx()*this.Zoom,i=this.Displayable.getCy()*this.Zoom,r=this.Displayable.getHeight(),n=this.Displayable instanceof t.SimpleMarker?this.Displayable.getType():"image",s=this._data.labelPosition;"top"==s?(e=i-r/2-4,this._label.alignBottom()):"bottom"==s?(e=i+r/2,this._label.alignTop()):n==t.SimpleMarker.TRIANGLE_UP?(e=i+r/6,this._label.alignMiddle()):n==t.SimpleMarker.TRIANGLE_DOWN?(e=i-r/6,this._label.alignMiddle()):(e=i,this._label.alignMiddle()),this._label.setX(a).setY(e)}},l.prototype.__recenter=function(){var e=this.Displayable.getWidth(),a=this.Displayable.getHeight();if(null!=e&&null!=a&&this.Displayable.getParent()){var i=0,r=this._center.x,s=this._center.y;this.Displayable.getRotation&&(i=this.Displayable.getRotation(),r=this._center.x*Math.cos(i)-this._center.y*Math.sin(i),s=this._center.x*Math.sin(i)+this._center.y*Math.cos(i)),r=this._center.x*this.Zoom-r,s=this._center.y*this.Zoom-s,this.Displayable instanceof n&&(r+=this._center.x-e/2,s+=this._center.y-a/2),this.Displayable.setTranslate(r,s),t.Agent.workaroundFirefoxRepaint(this.Displayable),this.positionLabel()}},l.prototype.animateUpdate=function(e,a){var i=new t.CustomAnimation(this._view.getCtx(),this.Displayable,this.getDataLayer().getAnimationDuration()),r=a.getDisplayable();if(this.Displayable.getFill){var n=r.getFill(),s=this.Displayable.getFill();if(s instanceof t.SolidFill&&!s.equals(n)){if(this.Displayable.setFill(n),a.getLabel()&&this._label){var o=this._label.getFill();this._label.setFill(a.getLabel().getFill()),o.equals(this._label.getFill())||i.getAnimator().addProp(t.Animator.TYPE_FILL,this._label,this._label.getFill,this._label.setFill,o)}i.getAnimator().addProp(t.Animator.TYPE_FILL,this.Displayable,this.Displayable.getFill,this.Displayable.setFill,s)}}if(this.Displayable.getCenterDimensions){var h=a.getDisplayable().getCenterDimensions(),c=this.Displayable.getCenterDimensions();h.x==c.x&&h.y==c.y&&h.w==c.w&&h.h==c.h||(this.Displayable.setCenterDimensions(h),i.getAnimator().addProp(t.Animator.TYPE_RECTANGLE,this.Displayable,this.Displayable.getCenterDimensions,this.Displayable.setCenterDimensions,c))}var _=r.getRotation(),p=this.Displayable.getRotation();if(_!=p){var g=_-p;g>Math.PI?_-=2*Math.PI:g<-Math.PI&&(_+=2*Math.PI),this.Displayable.setRotation(_),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this.Displayable,this.Displayable.getRotation,this.Displayable.setRotation,p)}var d=a.getCenter(),u=this.getCenter();if(d&&u&&(d.x==u.x&&d.y==u.y&&_==p||(this._setCenter(new t.Point(d.x,d.y)),i.getAnimator().addProp(t.Animator.TYPE_POINT,this,this.getCenter,this._setCenter,new t.Point(u.x,u.y)))),this._label&&a.getLabel()){var y=a.getLabel().getX(),f=this._label.getX();y!=f&&(this._label.setX(y),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this._label,this._label.getX,this._label.setX,f));var S=a.getLabel().getY(),m=this._label.getY();S!=m&&(this._label.setY(S),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this._label,this._label.getY,this._label.setY,m)),a.getLabel().setAlpha(0)}else a.getLabel()&&a.getLabel().setAlpha(0);r.setAlpha(0),e.add(i,l.ANIMATION_UPDATE_PRIORITY)},l.prototype.animateDelete=function(e,a){var i=[this.Displayable],r=this.getLabel();r&&i.push(r);var n=new t.AnimFadeOut(this._view.getCtx(),i,this.getDataLayer().getAnimationDuration());e.add(n,l.ANIMATION_DELETE_PRIORITY)},l.prototype.animateInsert=function(e){var a=[this.Displayable];this.Displayable.setAlpha(0);var i=this.getLabel();i&&(i.setAlpha(0),a.push(i));var r=new t.AnimFadeIn(this._view.getCtx(),a,this.getDataLayer().getAnimationDuration());e.add(r,l.ANIMATION_INSERT_PRIORITY)},l.prototype.processDefaultSelectionEffect=function(t){this.Displayable.setSelected&&this.Displayable.setSelected(t)},l.prototype.processDefaultFocusEffect=function(t){this.processDefaultHoverEffect(t)},l.prototype.processDefaultHoverEffect=function(t){t?this.Displayable.showHoverEffect&&this.Displayable.showHoverEffect():this.Displayable.hideHoverEffect&&!this.isShowingKeyboardFocusEffect()&&this.Displayable.hideHoverEffect()},l.prototype._callCustomRenderer=function(t,e,a){if(this.Displayable instanceof n){var i=this._view.getOptions()._contextHandler;if(i){var r=this.Displayable.getRootElement(),s=t(i(this.Displayable.getElem(),r,this._data,this._itemData,e,a));!s&&r&&this._view.getCtx().isCustomElement()||this.Displayable.updateRootElement(s)}}},l.prototype.IsHoverEffectShown=function(){return this._isShowingHoverEffect},l.prototype._getState=function(){return{hovered:this.IsHoverEffectShown(),selected:this.isSelected(),focused:this.isShowingKeyboardFocusEffect()}};var h=function(t,e,a,i,r){this.Init(t,e,a,i,r)};t.Obj.createSubclass(h,l),h.prototype.Init=function(t,e,a,i,r){h.superclass.Init.call(this,t,e,a,i,null,r)},h.prototype.setAreaLayer=function(t){this._dataAreaLayer=t},h.prototype.setSelected=function(t){this.isSelectable()&&(t&&!this.IsHoverEffectShown()&&this._dataAreaLayer.addChild(this.Displayable),h.superclass.setSelected.call(this,t))},h.prototype.showHoverEffect=function(){this._dataAreaLayer.addChild(this.Displayable),h.superclass.showHoverEffect.call(this)},h.prototype.hideHoverEffect=function(){this.isSelected()?this._dataAreaLayer.addChild(this.Displayable):this._dataAreaLayer.addChildAt(this.Displayable,0),h.superclass.hideHoverEffect.call(this)},h.prototype.HandleZoomEvent=function(t){h.superclass.HandleZoomEvent.call(this,t),this.Displayable.getParent()&&(this.Displayable.handleZoomEvent(t),this.positionLabel(t))},h.prototype.positionLabel=function(t){this.getLabel()&&this.getLabel().update(t)},h.prototype.GetNavigables=function(){return this.getDataLayer().getMap().getNavigableAreas()},h.prototype.animateUpdate=function(t,e){h.superclass.animateUpdate.call(this,t,e),this.getDataLayer().getMapLayer().setAreaRendered(this.getLocation(),!1)},h.prototype.__recenter=function(){};var c=function(t,e,a,i,r,n,s){this.Init(t,e,a,i,r,n,s)};t.Obj.createSubclass(c,l),c.prototype.Init=function(t,e,a,i,r,n,s){c.superclass.Init.call(this,t,e,a),this._startPt=i,this._endPt=r,this._startMarker=n,this._endMarker=s},c.prototype.getStartMarker=function(){return this._startMarker},c.prototype.getEndMarker=function(){return this._endMarker},c.prototype.getStartPoint=function(){return this._startPt},c.prototype.getEndPoint=function(){return this._endPt},c.prototype.getNextNavigable=function(e){var a,i=this._dataLayer.getMap().EventManager.getKeyboardHandler();if(e.type==t.MouseEvent.CLICK)return this;if(e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;if(i.getLinkNavigationType()===u.LINK_NODE_NAV)if(e.keyCode===t.KeyboardEvent.UP_ARROW){var r=i.getLinkMarker().getId(),n=(s=this.getDataLayer().getNavigableLinksForNodeId(r)).indexOf(this);++n===s.length&&(n=0),a=s[n]}else if(e.keyCode===t.KeyboardEvent.DOWN_ARROW){var s;r=i.getLinkMarker().getId(),n=(s=this.getDataLayer().getNavigableLinksForNodeId(r)).indexOf(this);-1===--n&&(n=s.length-1),a=s[n]}else if(e.keyCode===t.KeyboardEvent.LEFT_ARROW)a=this.getStartPoint().x<=this.getEndPoint().x?this.getStartMarker():this.getEndMarker();else{if(e.keyCode!==t.KeyboardEvent.RIGHT_ARROW)return this;a=this.getStartPoint().x>=this.getEndPoint().x?this.getStartMarker():this.getEndMarker()}else a=t.KeyboardHandler.getNextAdjacentNavigable(this,e,this.GetNavigables());return this.getDataLayer().getMap().ensureObjInViewport(e,a),a},c.prototype.GetNavigables=function(){return this.getDataLayer().getMap().getNavigableLinks()},c.prototype.__recenter=function(){if(this.Displayable.getParent()){var e=new t.Point(this._startPt.x*this.Zoom,this._startPt.y*this.Zoom),a=new t.Point(this._endPt.x*this.Zoom,this._endPt.y*this.Zoom),i=f.calcCurve(this._dataLayer,this._startPt,this._endPt,e,a);this.Displayable.setCmds(i),t.Agent.workaroundFirefoxRepaint(this.Displayable)}},c.prototype.animateUpdate=function(e,a){var i=new t.CustomAnimation(this._view.getCtx(),this.Displayable,this.getDataLayer().getAnimationDuration()),r=a.getDisplayable(),n=r.getStroke(),s=this.Displayable.getStroke();s.getColor()!=n.getColor()&&(this.Displayable.setStroke(n),i.getAnimator().addProp(t.Animator.TYPE_STROKE,this.Displayable,this.Displayable.getStroke,this.Displayable.setStroke,s));var o=a.getStartPoint(),h=a.getEndPoint(),c=this.getStartPoint(),_=this.getEndPoint(),p=!0;o.equals(c)&&h.equals(_)||(p=!1,this.Displayable.setAlpha(0),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,this.Displayable,this.Displayable.getAlpha,this.Displayable.setAlpha,1),i.getAnimator().addProp(t.Animator.TYPE_NUMBER,r,r.getAlpha,r.setAlpha,0)),p&&r.setAlpha(0),e.add(i,l.ANIMATION_UPDATE_PRIORITY)};var _=function(t,e,a,i,r,n){this.Init(t,e,a,i,r,n)};t.Obj.createSubclass(_,t.Container),_._DEFAULT_STROKE_WIDTH=1,_.prototype.Init=function(t,e,a,i,r,n){_.superclass.Init.call(this,t),this._areaId=i,this._areaName=r,this._shape=a,this.addChild(this._shape),this._view=e,this._bSupportsVectorEffects=n;var s=a.getStroke();s&&(this._areaStrokeWidth=s.getWidth())},_.prototype.getAreaId=function(){return this._areaId},_.prototype.getDatatip=function(){if("none"!=this._view.getDisplayTooltips()){var t=this._view.getOptions()._tooltip;return t?this._view.getCtx().getTooltipManager().getCustomTooltip(t.renderer,this.getDataContext()):this._tooltip}return null},_.prototype.setDatatip=function(t){this._tooltip=t},_.prototype.getDataContext=function(){return{color:null,component:this._view.getOptions()._widgetConstructor,data:null,id:null,label:null,location:this.getAreaId(),locationName:this._areaName,tooltip:this._tooltip,x:null,y:null}},_.prototype.getStroke=function(){return this._shape instanceof t.Shape?this._shape.getStroke():null},_.prototype.setStroke=function(e){this._shape instanceof t.Shape&&this._shape.setStroke(e)},_.prototype.setFill=function(e){this._shape instanceof t.Shape&&this._shape.setFill(e)},_.prototype.getFill=function(){return this._shape instanceof t.Shape?this._shape.getFill():null},_.prototype.getCmds=function(){return this._shape instanceof t.Path?this._shape.getCmds():null},_.prototype.setCmds=function(e){this._shape instanceof t.Path&&this._shape.setCmds(e)},_.prototype.setSrc=function(e){this._shape instanceof t.Image&&this._shape.setSrc(e)},_.prototype.getDropSiteFeedback=function(){return this._shape.copyShape()},_.prototype.contains=function(t,e){var a=this.getDimensions();return t>=a.x&&t<=a.x+a.w&&e>=a.y&&e<=a.y+a.h},_.prototype.HandleZoomEvent=function(e){if(!this._bSupportsVectorEffects&&this._shape&&this._areaStrokeWidth){var a=this._shape.getStroke(),i=new t.Stroke(a.getColor(),a.getAlpha(),this._areaStrokeWidth/e.getA(),a.isFixedWidth());this._shape.setStroke(i)}};var p=function(t,e,a){this.Init(t,e,a)};t.Obj.createSubclass(p,t.Obj),p.prototype.Init=function(e,a,i){this._tmap=e,this.LayerName=a,this.EventHandler=i,this.DataLayers={},this.PzcMatrix=new t.Matrix},p.prototype.addDataLayer=function(t){this.DataLayers[t.getClientId()]=t},p.prototype.PreDataLayerUpdate=function(){},p.prototype.PostDataLayerUpdate=function(){},p.prototype.updateDataLayer=function(e,a,i){if(this._animation&&this._animation.stop(!0),this.PzcMatrix=a,this._oldDataLayer=this.getDataLayer(e.getClientId()),this.addDataLayer(e),e.render(this.PzcMatrix),e.HandleZoomEvent(t.EventFactory.newZoomEvent("zoomed"),this.PzcMatrix),this._oldDataLayer){var r=e.getAnimation(),n=e.getAnimationDuration();if("auto"==r){var s=new t.DataAnimationHandler(this._tmap.getCtx());s.constructAnimation(this._oldDataLayer.getAllObjects(),e.getAllObjects()),this._animation=s.getAnimation()}else if(t.BlackBoxAnimationHandler.isSupported(r)){this._removeAnimRect=!0;for(var o=new t.Rectangle(0,0,this._tmap.getWidth(),this._tmap.getHeight()),l=this._oldDataLayer.getNonScaledContainers(),h=0;h<l.length;h++){(u=new t.Rect(this._tmap.getCtx(),0,0,this._tmap.getWidth(),this._tmap.getHeight())).setFill(null),l[h].addChild(u)}var c=e.getNonScaledContainers();for(h=0;h<c.length;h++){(u=new t.Rect(this._tmap.getCtx(),0,0,this._tmap.getWidth(),this._tmap.getHeight())).setFill(null),c[h].addChild(u)}var _=t.BlackBoxAnimationHandler.getCombinedAnimation(this._tmap.getCtx(),r,l,c,o,n),p=new t.Rectangle(0,0,this._tmap.getWidth()/this.PzcMatrix.getA(),this._tmap.getHeight()/this.PzcMatrix.getA()),g=this._oldDataLayer.getScaledContainers();for(h=0;h<g.length;h++){(u=new t.Rect(this._tmap.getCtx(),0,0,this._tmap.getWidth()/this.PzcMatrix.getA(),this._tmap.getHeight()/this.PzcMatrix.getA())).setFill(null),g[h].addChild(u)}var d=e.getScaledContainers();for(h=0;h<d.length;h++){var u;(u=new t.Rect(this._tmap.getCtx(),0,0,this._tmap.getWidth()/this.PzcMatrix.getA(),this._tmap.getHeight()/this.PzcMatrix.getA())).setFill(null),d[h].addChild(u)}var y=t.BlackBoxAnimationHandler.getCombinedAnimation(this._tmap.getCtx(),r,g,d,p,n);this._animation=new t.ParallelPlayable(this._tmap.getCtx(),[_,y])}else{var f=this._oldDataLayer.getContainers();for(h=0;h<f.length;h++){f[h].getParent().removeChild(f[h])}}if(this.PreDataLayerUpdate(),this._animation){this.EventHandler.removeListeners(this._callbackObj);var S=this;this._animation.setOnEnd(function(){S.OnAnimationEnd(e)},this),this._animation.play()}}else this.PostDataLayerUpdate(),this._tmap.OnUpdateLayerEnd()},p.prototype.getDataLayers=function(){return this.DataLayers},p.prototype.getDataLayer=function(t){return this.DataLayers?this.DataLayers[t]:null},p.prototype.getLayerName=function(){return this.LayerName},p.prototype.render=function(t){for(var e in this.PzcMatrix=t,this.DataLayers)this.DataLayers[e].render(t)},p.prototype.HandleZoomEvent=function(t,e){for(var a in this.PzcMatrix=e,this.DataLayers)this.DataLayers[a].HandleZoomEvent(t,e)},p.prototype.HandlePanEvent=function(t){for(var e in this.PzcMatrix=t,this.DataLayers)this.DataLayers[e].HandlePanEvent(t)},p.prototype.OnAnimationEnd=function(t){if(this._oldDataLayer)for(var e=this._oldDataLayer.getContainers(),a=0;a<e.length;a++){var i=e[a].getParent();i&&i.removeChild(e[a])}if(this._removeAnimRect){this._removeAnimRect=!1;var r=t.getNonScaledContainers();for(a=0;a<r.length;a++)r[a].removeChildAt(r[a].getNumChildren()-1);var n=t.getScaledContainers();for(a=0;a<n.length;a++)n[a].removeChildAt(n[a].getNumChildren()-1)}this.PostDataLayerUpdate(),this._tmap.OnUpdateLayerEnd(),this._animation=null,this.EventHandler.addListeners(this._callbackObj)},p.prototype.destroy=function(){var t=this.getDataLayers();for(var e in t)t[e].destroy()};var g=function(t,e,a,i,r){this.Init(t,e,a,i,r)};t.Obj.createSubclass(g,p),g._SHORT_NAME=0,g._LONG_NAME=1,g.prototype.Init=function(e,a,i,r,n){g.superclass.Init.call(this,e,a,n),this._labelDisplay=i,this._labelType=r,this._areaLabels=new Object,this.Areas=new Object,this.AreaShapes={},this.AreaLabels=null,this._labelInfo=null,this._renderArea={},this._renderLabel={},this._renderedLabels={},this.AreaContainer=new t.Container(this._tmap.getCtx()),this.LabelContainer=new t.Container(this._tmap.getCtx()),this._tmap.getAreaLayerContainer().addChildAt(this.AreaContainer,0),this._tmap.getLabelContainer().addChildAt(this.LabelContainer,0)},g.prototype.getLabelType=function(){return this._labelType},g.prototype.setAreaShapes=function(t){for(var e in this.AreaShapes=t,t)this.setAreaRendered(e,!0)},g.prototype.setAreaLabels=function(t){for(var e in this.AreaLabels=t,t)this.setLabelRendered(e,!0)},g.prototype.getShortAreaName=function(t){return this.AreaLabels&&this.AreaLabels[t]?this.AreaLabels[t][g._SHORT_NAME]:null},g.prototype.getLongAreaName=function(t){return this.AreaLabels&&this.AreaLabels[t]?this.AreaLabels[t][g._LONG_NAME]:null},g.prototype.setAreaLabelInfo=function(t){this._labelInfo=t},g.prototype.getLabelInfoForArea=function(t){return this._labelInfo?this._labelInfo[t]:null},g.prototype.getArea=function(t){return this.Areas[t]},g.prototype.getAreaShape=function(t){return this.AreaShapes[t]},g.prototype.getLabelDisplay=function(){return this._labelDisplay},g.prototype.setDropSiteCSSStyle=function(t){this._dropSiteCSSStyle=t},g.prototype.setLayerCSSStyle=function(t){this._layerCSSStyle=t},g.prototype.getLayerCSSStyle=function(){return this._layerCSSStyle},g.prototype.setAreaRendered=function(t,e){this._renderArea[t]=e},g.prototype.setLabelRendered=function(t,e){this._renderLabel[t]=e},g.prototype.setIsolatedArea=function(t){for(var e in this._isolatedArea=t,this._layerDim=null,this.AreaShapes)e!=t&&(this._renderArea[e]=!1)},g.prototype.getIsolatedArea=function(){return this._isolatedArea},g.prototype.getLayerDim=function(){if(!this._layerDim){var e=this._tmap.getMapName();if(this._isolatedArea)this._layerDim=e?t.PathUtils.getDimensions(t.PathUtils.createPathArray(r.getPathForArea(this._tmap.getMapName(),this.LayerName,this._isolatedArea))):t.DisplayableUtils.getDimensionsForced(this._tmap.getCtx(),this.getAreaShape(this._isolatedArea));else if(e&&"world"!=e&&"worldRegions"!=e&&(this._layerDim=r.getBaseMapDim(this._tmap.getMapName(),this.LayerName)),!this._layerDim){var a=this.AreaContainer.getDimensions().getUnion(this._tmap.getDataAreaContainer().getDimensions());a.w>0&&a.h>0&&(this._layerDim=a)}}return this._layerDim},g.prototype._createAreaAndLabel=function(e){var a=this.AreaShapes[e];if(a){if(!this.Areas[e]){var i=this._tmap.getCtx(),r=this.AreaLabels&&this.AreaLabels[e]?this.AreaLabels[e][g._LONG_NAME]:null,n=new _(i,this._tmap,a,e,r,this._tmap.supportsVectorEffects());this.Areas[e]=n,this.EventHandler.associate(a,n),n.setDatatip(r)}if(this._renderLabel[e]){var s=this._areaLabels[e];if(!s&&"off"!=this._labelDisplay&&this.AreaLabels){var l="short"==this._labelType?this.AreaLabels[e][g._SHORT_NAME]:this.AreaLabels[e][g._LONG_NAME];if(l){if(this._labelInfo&&this._labelInfo[e])s=new o(this._tmap.getCtx(),l,this._labelInfo[e],this._labelDisplay,this.LabelContainer,this._tmap.supportsVectorEffects());else{var h=t.DisplayableUtils.getDimensionsForced(this._tmap.getCtx(),a);s=new o(this._tmap.getCtx(),l,[[h.x,h.y,h.w,h.h]],this._labelDisplay,this.LabelContainer,this._tmap.supportsVectorEffects())}this._areaLabels[e]=s,this._layerCSSStyle&&s.setCSSStyle(this._layerCSSStyle)}}}}},g.prototype._addAreaAndLabel=function(t,e){if(this.AreaShapes[t]){this.AreaContainer.addChild(this.Areas[t]);var a=this._areaLabels[t];a&&(this._renderLabel[t]?a.update(this.PzcMatrix):a.reset(),this._renderedLabels[t]=this._renderLabel[t]),e&&(e.push(this.Areas[t]),a&&(e.push(a),e.push(a.getLeaderLine())))}},g.prototype.resetRenderedAreas=function(){for(var t in this.AreaLabels)this.setAreaRendered(t,!0),this.setLabelRendered(t,!0)},g.prototype.updateDataLayer=function(t,e,a){if(g.superclass.updateDataLayer.call(this,t,e,a),a==this.getLayerName())for(var i in this.AreaShapes)this._createAreaAndLabel(i),this._renderArea[i]&&this._addAreaAndLabel(i)},g.prototype.render=function(t){for(var e in this.AreaShapes)this._createAreaAndLabel(e),this._renderArea[e]&&this._addAreaAndLabel(e);g.superclass.render.call(this,t)},g.prototype.PreDataLayerUpdate=function(){for(var t in this._renderArea)this._renderArea[t]||(this._createAreaAndLabel(t),this._addAreaAndLabel(t))},g.prototype.PostDataLayerUpdate=function(){for(var t in this._renderArea)if(!this._renderArea[t]){this.AreaContainer.removeChild(this.Areas[t]);var e=this._areaLabels[t];if(e){this._renderedLabels[t]=!1,this.LabelContainer.removeChild(e);var a=e.getLeaderLine();a&&this.LabelContainer.removeChild(a)}}},g.prototype._renderSelectedAreasAndLabels=function(t,e){for(var a=0;a<t.length;a++)this._createAreaAndLabel(t[a]),this._renderArea[t[a]]&&this._addAreaAndLabel(t[a],e)},g.prototype.__getObjectUnderPoint=function(t,e){for(var a in this.Areas)if(this.Areas[a].contains(t,e))return this.Areas[a];return null},g.prototype.__showDropSiteFeedback=function(e){if(this._dropSiteFeedback&&(this.AreaContainer.removeChild(this._dropSiteFeedback),this._dropSiteFeedback=null),e&&(this._dropSiteFeedback=e.getDropSiteFeedback(),this._dropSiteFeedback)){this._dropSiteFeedback.setFill(new t.SolidFill(this._dropSiteCSSStyle.getStyle(t.CSSStyle.BACKGROUND_COLOR)));var a=this._dropSiteCSSStyle.getStyle(t.CSSStyle.BORDER_WIDTH)?this._dropSiteCSSStyle.getStyle(t.CSSStyle.BORDER_WIDTH).substring(0,this._dropSiteCSSStyle.getStyle(t.CSSStyle.BORDER_WIDTH).indexOf("px")):1;this._tmap.supportsVectorEffects()||(a/=this.PzcMatrix.getA());var i=new t.Stroke(this._dropSiteCSSStyle.getStyle(t.CSSStyle.BORDER_COLOR),1,a,this._tmap.supportsVectorEffects());this._dropSiteFeedback.setStroke(i),this.AreaContainer.addChild(this._dropSiteFeedback)}return this._dropSiteFeedback},g.prototype.HandleZoomEvent=function(t,e){if(g.superclass.HandleZoomEvent.call(this,t,e),!this._tmap.supportsVectorEffects())for(var a in this.Areas)this.Areas[a].HandleZoomEvent(e);for(var a in this._renderedLabels)if(this._renderedLabels[a]){var i=this._areaLabels[a];i&&i.update(e)}};var d=function(t,e,a,i,r){this.Init(t,e,a,i,r)};t.Obj.createSubclass(d,t.Obj),d.prototype.Init=function(e,a,i,r,n){this._tmap=e,this._clientId=i,this._options=n,this._areaObjs=[],this._markerObjs=[],this._linkObjs=[],this._dataAreaCollection=[],this._dataMarkerCollection=[],this._dataLinkCollection=[],this._eventHandler=r,this._linkMap={},this._dataAreaLayer=new t.Container(this._tmap.getCtx()),this._dataPointLayer=new t.Container(this._tmap.getCtx()),this._dataLabelLayer=new t.Container(this._tmap.getCtx()),this._dataLinkLayer=new t.Container(this._tmap.getCtx()),this._tmap.getDataAreaContainer().addChildAt(this._dataAreaLayer,0),this._tmap.getDataPointContainer().addChildAt(this._dataPointLayer,0),this._tmap.getLabelContainer().addChildAt(this._dataLabelLayer,0),this._tmap.getLinkContainer().addChildAt(this._dataLinkLayer,0),this._parentLayer=a},d.prototype.getOptions=function(){return this._options},d.prototype.getContainers=function(){return[this._dataAreaLayer,this._dataPointLayer,this._dataLabelLayer,this._dataLinkLayer]},d.prototype.getScaledContainers=function(){return[this._dataAreaLayer]},d.prototype.getNonScaledContainers=function(){var t=[this._dataLabelLayer,this._dataLinkLayer];return this._tmap.isMarkerZoomBehaviorFixed()&&t.push(this._dataPointLayer),t},d.prototype.getDataLabelContainer=function(){return this._dataLabelLayer},d.prototype.getMapLayer=function(){return this._parentLayer},d.prototype.getMap=function(){return this._tmap},d.prototype.getAllObjects=function(){return this._markerObjs.concat(this._areaObjs).concat(this._linkObjs)},d.prototype.getAreaObjects=function(){return this._areaObjs},d.prototype.getMarkerObjects=function(){return this._markerObjs},d.prototype.getLinkObjects=function(){return this._linkObjs},d.prototype.getNavigableAreaObjects=function(){for(var t=[],e=0;e<this._areaObjs.length;e++)t.push(this._areaObjs[e]);return t},d.prototype.addMarkerObject=function(t){if(this._dataMarkerCollection.push(t),t){this._markerObjs.push(t),this._eventHandler.associate(t.getDisplayable(),t);var e=t.getLabel();e&&this._eventHandler.associate(e,t)}},d.prototype.addAreaObject=function(t){this._dataAreaCollection.push(t),t&&(this._areaObjs.push(t),this._eventHandler.associate(t.getDisplayable(),t),t.setAreaLayer(this._dataAreaLayer))},d.prototype.addLinkObject=function(t){this._dataLinkCollection.push(t),t&&(this._linkObjs.push(t),this._eventHandler.associate(t.getDisplayable(),t))},d.prototype.trackLink=function(t,e){var a=d._getLinkKey(t,e);return this._linkMap[a]?this._linkMap[a]++:this._linkMap[a]=1,this._linkMap[a]},d._getLinkKey=function(t,e){return t.x<e.x?t.x.toString()+t.y.toString()+e.x.toString()+e.y.toString():e.x.toString()+e.y.toString()+t.x.toString()+t.y.toString()},d.prototype.getDataAreaCollection=function(){return this._dataAreaCollection},d.prototype.getDataMarkerCollection=function(){return this._dataMarkerCollection},d.prototype.getDataLinkCollection=function(){return this._dataLinkCollection},d.prototype._removeAreaObject=function(t){var e=this._areaObjs.indexOf(t);-1!==e&&this._areaObjs.splice(e,1)},d.prototype.getClientId=function(){return this._clientId},d.prototype.setAnimation=function(t){this._animType=t},d.prototype.getAnimation=function(){return this._animType},d.prototype.setAnimationDuration=function(t){this._animDur=t},d.prototype.getAnimationDuration=function(){return this._animDur},d.prototype.setSelectionMode=function(e){this._selectionMode=e,this._selectionMode&&(this._selectionHandler=new t.SelectionHandler(this._tmap.getCtx(),this._selectionMode),this._eventHandler.setSelectionHandler(this._clientId,this._selectionHandler))},d.prototype.isSelectable=function(){return null!=this._selectionMode},d.prototype.setIsolatedAreaRowKey=function(t){this._isolatedAreaRowKey=t},d.prototype._updateAreaShape=function(t){var e=t.getDisplayable(),a=this._parentLayer.getAreaShape(t.getLocation());return a?(e.setCmds(a.getCmds()),!0):(this._removeAreaObject(t),!1)},d.prototype._renderAreaAndLabel=function(t){if(this._updateAreaShape(this._areaObjs[t])){var e=this._areaObjs[t].getDisplayable();this._dataAreaLayer.addChild(e);var a=this._areaObjs[t].getLabel();if(a){if(!a.hasBounds()){var i=e.getDimensions();a.addBounds(i)}a.update(this._pzcMatrix)}return!0}return!1},d.prototype.render=function(e){this._pzcMatrix=e;var a={},i=this._markerObjs.slice();i.sort(function(t,e){return t.getSize()<e.getSize()?1:t.getSize()>e.getSize()?-1:0});for(var r=0;r<i.length;r++){var n=i[r],s=n.getDisplayable(),o=n.getLabel();if(o){var l=new t.Container(s.getCtx());this._dataPointLayer.addChild(l),l.addChild(s),l.addChild(o),n.positionLabel()}else this._dataPointLayer.addChild(s);var h=n.getLocation();h&&(a[h]=!0)}for(r=0;r<this._areaObjs.length;r++)a[this._areaObjs[r].getLocation()]&&this._areaObjs[r].removeLabel(),this._renderAreaAndLabel(r)||r--;for(r=0;r<this._linkObjs.length;r++)this._dataLinkLayer.addChild(this._linkObjs[r].getDisplayable());this._initSelections&&this._processInitialSelections()},d.prototype.HandleZoomEvent=function(t,e){this._pzcMatrix=e;for(var a=this.getAreaObjects(),i=0;i<a.length;i++)a[i].HandleZoomEvent(e);if(this._tmap.isMarkerZoomBehaviorFixed()){var r=this.getMarkerObjects();for(i=0;i<r.length;i++)r[i].HandleZoomEvent(e)}this._linkMap={};var n=this.getLinkObjects();for(i=0;i<n.length;i++)n[i].HandleZoomEvent(e)},d.prototype.HandlePanEvent=function(t){this._pzcMatrix=t},d.prototype.setInitialSelections=function(t){this._initSelections=t},d.prototype._processInitialSelections=function(){this._selectionHandler&&(this._selectionHandler.processInitialSelections(this._initSelections,this.getAllObjects()),this._initSelections=null)},d.prototype.__getDragTransferable=function(t){if(this._selectionHandler){t.isSelected()||(this._selectionHandler.processClick(t,!1),this._eventHandler.fireSelectionEvent(t));for(var e=[],a=this._selectionHandler.getSelection(),i=0;i<a.length;i++)e.push(a[i].getId());return e}return null},d.prototype.__getDragFeedback=function(){for(var t=[],e=this._selectionHandler.getSelection(),a=0;a<e.length;a++)t.push(e[a].getDisplayable());return t},d.prototype.getSelectedAreas=function(t){for(var e=[],a=this.getAreaObjects(),i=new(this._tmap.getCtx().KeySetImpl)(t),r=0;r<a.length;r++)if(i.has(a[r].getId())){e.push(a[r].getLocation());break}return e},d.prototype.destroy=function(){for(var t=this.getAllObjects(),e=0;e<t.length;e++){var a=t[e].getDisplayable();if(a instanceof n){var i=a.getRootElement();Array.isArray(i)?i.forEach(function(t){i.destroy&&i.destroy()}.bind(this)):i.destroy&&i.destroy()}}this._eventHandler=null},d.prototype.getNavigableLinksForNodeId=function(e){for(var a=[],i=this._tmap.getCtx(),r=0;r<this._dataLinkCollection.length;r++){var n=this._dataLinkCollection[r],s=n.getStartMarker(),o=n.getEndMarker();s&&t.Obj.compareValues(i,s.getId(),e)?a.push(n):o&&t.Obj.compareValues(i,o.getId(),e)&&a.push(n)}return a};var u=function(t,e){this.Init(t,e)};t.Obj.createSubclass(u,t.PanZoomCanvasKeyboardHandler),u.LINK_NODE_NAV="linkNode",u.LINK_NAV="link",u.prototype.Init=function(t,e){u.superclass.Init.call(this,t,e),this._tmap=t,this._linkNavType=u.LINK_NAV},u.prototype.isSelectionEvent=function(t){return this.isNavigationEvent(t)&&!t.ctrlKey},u.prototype.processKeyDown=function(e){var a=e.keyCode,i=this._eventManager.getFocus();if(a==t.KeyboardEvent.CLOSE_BRACKET){this._linkNavType=u.LINK_NAV;var r=[];i instanceof h?0===(r=this._tmap.getNavigableMarkers()).length&&(r=this._tmap.getNavigableLinks()):i instanceof l&&(r=this._tmap.getNavigableLinks()),r.length>0&&(i=t.KeyboardHandler.getNextAdjacentNavigable(i,e,r),this._tmap.ensureObjInViewport(e,i)),this._eventManager.SetClickInfo(i)}else if(a==t.KeyboardEvent.OPEN_BRACKET){this._linkNavType=u.LINK_NAV;r=[];i instanceof c?0===(r=this._tmap.getNavigableMarkers()).length&&(r=this._tmap.getNavigableAreas()):!(i instanceof h)&&i instanceof l&&(r=this._tmap.getNavigableAreas()),r.length>0&&(i=t.KeyboardHandler.getNextAdjacentNavigable(i,e,r),this._tmap.ensureObjInViewport(e,i)),this._eventManager.SetClickInfo(i)}else(e.keyCode==t.KeyboardEvent.OPEN_ANGLED_BRACKET||t.KeyboardEvent.CLOSE_ANGLED_BRACKET)&&e.altKey&&(this._linkMarker=i,this._linkNavType=u.LINK_NODE_NAV),i=u.superclass.processKeyDown.call(this,e),this.isNavigationEvent(e)&&!e.ctrlKey&&this._eventManager.SetClickInfo(i);return i},u.prototype.getLinkNavigationType=function(){return this._linkNavType},u.prototype.getLinkMarker=function(){return this._linkMarker},u.prototype.isMultiSelectEvent=function(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey},u.prototype.isNavigationEvent=function(e){var a=u.superclass.isNavigationEvent.call(this,e);switch(e.keyCode){case t.KeyboardEvent.OPEN_BRACKET:case t.KeyboardEvent.CLOSE_BRACKET:a=!0;break;case t.KeyboardEvent.OPEN_ANGLED_BRACKET:case t.KeyboardEvent.CLOSE_ANGLED_BRACKET:a=!!e.altKey;break;default:a=u.superclass.isNavigationEvent.call(this,e)}return a},u.getFirstNavigableLink=function(e,a,i){var r=a.keyCode;if(!i||i.length<1||!e)return null;for(var n=e.getCenter(),s=e.getDisplayable().getCtx(),o=0;o<i.length;o++){var l,h=i[o];if(l=t.Obj.compareValues(s,e.getId(),h.getStartMarker().getId())?h.getEndPoint():h.getStartPoint(),r==t.KeyboardEvent.OPEN_ANGLED_BRACKET&&l.x<=n.x||r==t.KeyboardEvent.CLOSE_ANGLED_BRACKET&&l.x>=n.x)break}return h};var y=function(t,e,a){this.Init(t,e,a,a)};t.Obj.createSubclass(y,t.EventManager),y.prototype.Init=function(t,e,a,i){y.superclass.Init.call(this,t,e,a,i),this._selectionHandlers=new Object,this._tmap=a,this._bPassOnEvent=!1},y.prototype.getSelectionHandler=function(t){if(t&&t.getDataLayer){var e=t.getDataLayer().getClientId();return this._selectionHandlers[e]}},y.prototype.setSelectionHandler=function(t,e){this._selectionHandlers[t]=e},y.prototype.setInitialFocus=function(t){t&&y.superclass.setFocus.call(this,t)},y.prototype.OnClick=function(e){var a=this.GetLogicalObject(e.target);if(this.SetClickInfo(a),!(a&&a.isSelectable&&a.isSelectable()))for(var i in this._selectionHandlers){if(this._selectionHandlers[i].processClick(null,e.ctrlKey)){var r=t.EventFactory.newSelectionEvent([]);r.clientId=i,this._callback.call(this._callbackObj,r)}}y.superclass.OnClick.call(this,e)},y.prototype.SetClickInfo=function(t){var e=null,a=null,i=null;if(t&&(t instanceof l?i=t.getDisplayable():t instanceof _&&(i=t),t.getDataLayer)){var r=t.getDataLayer();e=r.getClientId(),a=r.getMapLayer().getLayerName()}this._tmap.setClickInfo(e,a,i)},y.prototype.ProcessKeyboardEvent=function(e){var a=!0,i=e.keyCode,r=this.getFocus(),s=r.getDisplayable();return i!=t.KeyboardEvent.TAB&&this._bPassOnEvent?(s.fireKeyboardListener(e),e.preventDefault()):i==t.KeyboardEvent.SPACE&&e.ctrlKey?(this.SetClickInfo(r),this.ProcessSelectionEventHelper(r,!0),e.preventDefault()):i!=t.KeyboardEvent.ZERO&&i!=t.KeyboardEvent.NUMPAD_ZERO||!e.ctrlKey?i==t.KeyboardEvent.TAB&&s instanceof n?!e.shiftKey&&r.isShowingKeyboardFocusEffect()?(r.hideKeyboardFocusEffect(),s.fireKeyboardListener(e),e.preventDefault(),this._bPassOnEvent=!0):e.shiftKey&&this._bPassOnEvent?(this.ShowFocusEffect(e,r),e.preventDefault(),this._bPassOnEvent=!1):(this._bPassOnEvent&&r.showKeyboardFocusEffect(),a=y.superclass.ProcessKeyboardEvent.call(this,e),this._bPassOnEvent=!1):(i==t.KeyboardEvent.TAB&&r&&this._tmap.ensureObjInViewport(e,r),a=y.superclass.ProcessKeyboardEvent.call(this,e)):(e.altKey?this._tmap.fitRegion(s):this._tmap.fitSelectedRegions(),e.preventDefault()),a},y.prototype.OnComponentTouchClick=function(e){if(!this.GetEventInfo(e,t.PanZoomCanvasEventManager.EVENT_INFO_PANNED_KEY)){var a=this.GetLogicalObject(e.target);if(this.SetClickInfo(a),a instanceof t.ThematicMap)for(var i in this._selectionHandlers){if(this._selectionHandlers[i].processClick(null,e.ctrlKey)){for(var r=this._selectionHandlers[i].getSelection(),n=[],s=0;s<r.length;s++)n.push(r[s].getId());var o=t.EventFactory.newSelectionEvent(n);this._callback.call(this._callbackObj,o)}}y.superclass.OnComponentTouchClick.call(this,e)}},y.prototype.HandleTouchActionsEnd=function(t,e){var a=this.GetLogicalObject(t.target);this.SetClickInfo(a),y.superclass.HandleTouchActionsEnd.call(this,t,e)},y.prototype.ProcessRolloverEvent=function(e,a,i){var r=this._tmap.getOptions();if("dim"==r.hoverBehavior){var n=a.getCategories?a.getCategories():[];r.highlightedCategories=i?n.slice():null;var s=t.EventFactory.newCategoryHighlightEvent(r.highlightedCategories,i),o=t.CSSStyle.getTimeMilliseconds(r.styleDefaults.hoverBehaviorDelay);this.RolloverHandler.processEvent(s,this._tmap.getNavigableAreas().concat(this._tmap.getNavigableMarkers()).concat(this._tmap.getNavigableLinks()),o,"any"==r.highlightMatch)}},y.prototype.GetTouchResponse=function(){var e=this._tmap.getOptions();return"none"!==e.panning||"none"!==e.zooming?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:e.touchResponse===t.EventManager.TOUCH_RESPONSE_TOUCH_START?t.EventManager.TOUCH_RESPONSE_TOUCH_START:t.EventManager.TOUCH_RESPONSE_AUTO},y.prototype.StoreInfoByEventType=function(e){return e!=t.PanZoomCanvasEventManager.EVENT_INFO_PANNED_KEY&&y.superclass.StoreInfoByEventType.call(this,e)},y.prototype.showFocusEffect=function(t,e){this.ShowFocusEffect(t,e)},y.prototype.ShowFocusEffect=function(t,e){this._tmap.isPanning()||y.superclass.ShowFocusEffect.call(this,t,e)};var f=function(t){this.Init(t)};t.Obj.createSubclass(f,t.Obj),f._MIN_MARKER_SIZE=6,f._MAX_MARKER_SIZE_RATIO=.5,f._PZC_PADDING=20,f.prototype.Init=function(t){this._tmap=t,this._areaLayerStyle=null,this._areaLayerStyleObject=null},f.prototype.parse=function(t){var e=t.mapProvider;m.containsGeoJson(e)&&(this._mapProvider=e),this._parseMapProperties(t),this._parseStyles(t.styleDefaults),this._parseAreaLayer(t.areaLayers),this.ParseDataLayers(t.pointDataLayers,null,null,!1)},f.prototype._parseMapProperties=function(t){var e=t.animationDuration;"string"==typeof e?"ms"==e.slice(-2)?e=parseInt(e.slice(0,-2))/1e3:"s"==e.slice(-1)&&(e=parseFloat(e.slice(0,-1))):e/=1e3,this._tmap.setAnimationDuration(e),this._mapProvider||this._tmap.setMapName(t.basemap),this._tmap.setInitialZooming("auto"==t.initialZooming),this._tmap.setPanning("auto"==t.panning),this._tmap.setZooming("auto"==t.zooming)},f.prototype._parseAreaLayer=function(e){var a=this._tmap.getCtx(),i=this._tmap.Defaults.calcAreaLayerOptions(e[0],a.isCustomElement()),n=i.layer;if(n||this._mapProvider){var s,o=i.areaSvgStyle||i.areaStyle;if(o){o instanceof Object||(o=t.CSSStyle.cssStringToObject(o));var l=f._getAreaCSSStyle(o);this._areaLayerStyleObject=t.JsonUtils.merge(o,this._areaLayerStyleObject),this._areaLayerStyle.merge(l)}var h=this._tmap.getStyleDefaults().labelStyle;h&&this._areaLayerStyle.merge(h),(h=i.labelStyle)&&this._areaLayerStyle.parseInlineStyle(h),s=new g(this._tmap,n,i.labelDisplay,i.labelType,this._tmap.getEventManager());var c,_,p,d=this._tmap.getMapName();if(this._mapProvider){var u=m.parseMapInfo(a,this._mapProvider);c=u.areas,_=u.labels}else c=r.getAreaPaths(d,n,this._tmap.getWidth(),this._tmap.getHeight(),this._tmap.getMaxZoomFactor()),_=r.getAreaLabels(d,n),p=r.getAreaLabelInfo(d,n);s.setAreaShapes(this._createPathShapes(c)),s.setAreaLabels(_),s.setAreaLabelInfo(p),s.setLayerCSSStyle(this._areaLayerStyle),s.setDropSiteCSSStyle(this._areaDropSiteStyle),this._tmap.addLayer(s),i.areaDataLayer&&this.ParseDataLayers([i.areaDataLayer],s,null,!0),i.pointDataLayers&&this.ParseDataLayers(i.pointDataLayers,s,null,!1)}},f.prototype.ParseDataLayers=function(e,a,i,r){if(e)for(var n=this._tmap.getCtx(),s=0;s<e.length;s++){var o=this._tmap.Defaults.calcDataLayerOptions(e[s]);a?a instanceof g&&r&&a.resetRenderedAreas():(a=new p(this._tmap,o.id,this._tmap.getEventManager()),this._tmap.addLayer(a));var l=new d(this._tmap,a,o.id,this._tmap.getEventManager(),o),h=o.selectionMode;"single"==h?l.setSelectionMode(t.SelectionHandler.TYPE_SINGLE):"multiple"==h&&l.setSelectionMode(t.SelectionHandler.TYPE_MULTIPLE),l.setAnimation(o.animationOnDataChange),l.setAnimationDuration(this._tmap.getAnimationDuration());var c,_=null;a instanceof g&&(_=o.isolatedItem);r=a instanceof g;var u=this._tmap.getOptions().hiddenCategories;if(M=o.areas)for(var y=0;y<M.length;y++)if(u&&t.ArrayUtils.hasAnyItem(u,M[y].categories))l.addAreaObject(null);else{var S=M[y].location;if(_){if(!t.Obj.compareValues(n,_,M[y].id))continue;c=S}(I=this._createArea(a,l,M[y]))&&l.addAreaObject(I)}var m=o.renderer;if(O=o.markers){m||f._calcBubbleSizes(this._tmap,O);for(y=0;y<O.length;y++)if(u&&t.ArrayUtils.hasAnyItem(u,O[y].categories))l.addMarkerObject(null);else{S=O[y].location;if(_){if(!t.Obj.compareValues(n,_,O[y].id))continue;c=S}if(m){var v=O[y]._noTemplate?O[y]._itemData:O[y],A=O[y]._itemData,b=m(this._tmap.getOptions()._contextHandler(this._tmap.getElem(),null,v,A,{hovered:!1,selected:!1,focused:!1},null));I=b&&this._createCustomDataItem(a,l,O[y],b,r)}else I=this._createMarker(a,l,O[y],r);I&&l.addMarkerObject(I)}}var E=o.images;if(E)for(y=0;y<E.length;y++){S=E[y].location;if(_){if(!t.Obj.compareValues(n,_,E[y].id))continue;c=S}(I=this._createImage(a,l,E[y],r))&&l.addMarkerObject(I)}var L=o.links;if(L){var D=new n.ojMap,C=new n.ojMap,O=l.getDataMarkerCollection();for(s=0;s<O.length;s++){var P=O[s];P&&D.set(P.getId(),P)}var M=l.getDataAreaCollection();for(s=0;s<M.length;s++){var T=M[s];T&&C.set(T.getId(),T)}for(y=0;y<L.length;y++){var I;if(u&&t.ArrayUtils.hasAnyItem(u,L[y].categories))l.addAreaObject(null);else(I=this._createLink(l,L[y],D,C))&&l.addLinkObject(I)}}c&&(l.setIsolatedAreaRowKey(_),a.setIsolatedArea(c));var R=o.selection;R&&R.length>0&&l.setInitialSelections(R),i?a.updateDataLayer(l,this._tmap.getPanZoomCanvas().getContentPane().getMatrix(),i):a.addDataLayer(l)}},f.prototype._parseStyles=function(e){var a=e.areaSvgStyle||e.areaStyle;!a||a instanceof Object||(a=t.CSSStyle.cssStringToObject(a)),a=t.JsonUtils.merge(a,e._areaStyle),this._areaLayerStyle=f._getAreaCSSStyle(a),this._areaLayerStyleObject=a,this._areaLayerStyle.parseInlineStyle(e.labelStyle),this._areaDropSiteStyle=new t.CSSStyle(e.dropTargetStyle),this._tmap.setStyleDefaults(e)},f._getAreaCSSStyle=function(e){var a=new t.CSSStyle;return[t.CSSStyle.BORDER_COLOR,t.CSSStyle.BACKGROUND_COLOR].forEach(function(i){var r=null,n=t.CSSStyle.cssStringToObjectProperty(i);e&&null!=e[n]&&(r=e[n],delete e[n]),a.setStyle(i,r)}),a},f.prototype._createPathShapes=function(e){var a={},i=this._tmap.getCtx();for(var r in e){var n=new t.Path(i);n.setCmds(e[r]);var s=this._areaLayerStyle.getStyle(t.CSSStyle.BORDER_COLOR);if(s&&"transparent"!=s){var o=new t.Stroke(s,1,1,this._tmap.supportsVectorEffects());n.setStroke(o)}var l=this._areaLayerStyle.getStyle(t.CSSStyle.BACKGROUND_COLOR);"transparent"!=l?n.setSolidFill(l):n.setFill(null),this._areaLayerStyleObject&&n.setStyle(this._areaLayerStyleObject),a[r]=n}return a},f.prototype._createArea=function(e,a,r){var n=r.location;if(e.getAreaShape(n)){e.setAreaRendered(n,!1);var s=this._tmap.getCtx(),o=new i(s,this._tmap.supportsVectorEffects());(r=t.JsonUtils.merge(r,this._tmap.getStyleDefaults().dataAreaDefaults)).labelStyle||(r.labelStyle=this._tmap.getStyleDefaults().labelStyle);var l=new t.Stroke(r.hoverColor,1,i.HOVER_STROKE_WIDTH,this._tmap.supportsVectorEffects()),c=new t.Stroke(r.selectedInnerColor,1,i.SELECTED_INNER_STROKE_WIDTH,this._tmap.supportsVectorEffects()),_=new t.Stroke(r.selectedOuterColor,1,i.SELECTED_OUTER_STROKE_WIDTH,this._tmap.supportsVectorEffects());o.setHoverStroke(l,null).setSelectedStroke(c,_),e.setLabelRendered(r.location,!1),this._styleDisplayable(r,o);var p=this._createLabel(e,a,r,o,!0),g=f._getLocationName(this._tmap.getMapName(),a,r);return new h(r,a,o,p,g)}return null},f.prototype._createMarker=function(e,a,i,r){var n,s=i._size;if(!(n=this._mapProvider&&!i.location?new t.Point(i.x,-i.y):f.getCenter(a,i.location,i.x,i.y))||0===s)return null;var o,h,c=this._tmap.getStyleDefaults().dataMarkerDefaults,_=c.labelStyle;if(_.parseInlineStyle(i.labelStyle),(i=t.JsonUtils.merge(i,c)).labelStyle=_,null!=s)o=s,h=s;else{var p=i.scaleX;null==p&&(p=1);var g=i.scaleY;null==g&&(g=1);var d=i.width;null==d&&(d=this._tmap.getOptions().styleDefaults.dataMarkerDefaults.width);var u=i.height;null==u&&(u=this._tmap.getOptions().styleDefaults.dataMarkerDefaults.height),o=d*p,h=u*g}var y,S=i.borderRadius;if(i.source)y=new t.ImageMarker(this._tmap.getCtx(),n.x,n.y,o,h,S,i.source,i.sourceSelected,i.sourceHover,i.sourceHoverSelected);else{var m=i.shape?i.shape:this._tmap.getOptions().styleDefaults.dataMarkerDefaults.shape;y=new t.SimpleMarker(this._tmap.getCtx(),m,n.x,n.y,o,h,S)}var v=i.rotation;if(v){var A=v*Math.PI/180;y.setRotation(A)}r&&e.setLabelRendered(i.location,!1),this._styleDisplayable(i,y);var b=this._createLabel(e,a,i,y,r),E=f._getLocationName(this._tmap.getMapName(),a,i);return new l(i,a,y,b,n,E)},f.prototype._createImage=function(e,a,i,r){var n=f.getCenter(a,i.location,i.x,i.y);if(!n)return null;var s=new t.Image(this._tmap.getCtx(),i.url),o=i.width,h=i.height;null!=o&&null!=h&&(s.setX(n.x-o/2),s.setY(n.y-h/2),s.setWidth(o),s.setHeight(h)),r&&e.setLabelRendered(i.location,!1);var c=f._getLocationName(this._tmap.getMapName(),a,i),_=new l(i,a,s,null,n,c);if(!o||!h){t.ImageLoader.loadImage(i.url,function(t){t&&t.width&&t.height&&(s.setWidth(t.width),s.setHeight(t.height),s.setX(n.x-t.width/2),s.setY(n.y-t.height/2),_.__recenter())})}return _},f.prototype._createCustomDataItem=function(e,a,i,r,s){var o;if(!(o=this._mapProvider&&!i.location?new t.Point(i.x,-i.y):f.getCenter(a,i.location,i.x,i.y)))return null;s&&e.setLabelRendered(i.location,!1);var h=new n(this._tmap.getCtx(),r,this._tmap.getStyleDefaults().dataAreaDefaults),c=f._getLocationName(this._tmap.getMapName(),a,i);return new l(i,a,h,null,o,c)},f.prototype._createLink=function(e,a,i,r){var n,s,o,l,h=a.startLocation,_=a.endLocation;if(h.id?(s=i.get(h.id))?n=s.getCenter():(s=r.get(h.id))&&(n=this._getPtFromLocation(e,{location:s.getLocation()})):n=this._getPtFromLocation(e,h),_.id?(l=i.get(_.id))?o=l.getCenter():(l=r.get(_.id))&&(o=this._getPtFromLocation(e,{location:l.getLocation()})):o=this._getPtFromLocation(e,_),!o||!n)return null;var p=new t.Path(this._tmap.getCtx(),f.calcCurve(e,n,o,n,o));p.setFill(null);var g=this._tmap.getStyleDefaults().linkDefaults,d=a.color;d||(d=g.color);var u=a.width;u||(u=g.width);var y=new t.Stroke(d,1,u,!0);p.setStroke(y);var S=g._hoverColor,m=g._selectedColor,v=new t.Stroke(S,1,u),A=new t.Stroke(d,1,u+2),b=new t.Stroke(d,1,u),E=new t.Stroke(m,1,u+2),L=new t.Stroke(S,1,u),D=new t.Stroke(m,1,u+2);return p.setHoverStroke(v,A).setSelectedStroke(b,E).setSelectedHoverStroke(L,D),new c(a,e,p,n,o,s,l)},f.prototype._getPtFromLocation=function(e,a){return this._mapProvider?new t.Point(a.x,-a.y):f.getCenter(e,a.location,a.x,a.y)},f.prototype._createLabel=function(e,a,i,r,n){var s=i.location,l=i.label,h=l?"on":"off";n&&(h=e.getLabelDisplay());var c=r instanceof t.Path;if(!l&&n&&(c&&"off"!=h||!c&&"on"==h)&&(l="long"==e.getLabelType()?e.getLongAreaName(s):e.getShortAreaName(s)),l){var _,p=this._tmap.getCtx();_=c?new o(p,l,e.getLabelInfoForArea?e.getLabelInfoForArea(s):null,h,a.getDataLabelContainer(),this._tmap.supportsVectorEffects()):new t.OutputText(p,l,0,0);var g=c?e.getLayerCSSStyle():new t.CSSStyle;i.labelStyle&&g.merge(i.labelStyle);var d=g.getStyle(t.CSSStyle.COLOR);g.setStyle(t.CSSStyle.COLOR,null),_.setCSSStyle(g),i.color&&_ instanceof o&&(t.Agent.isHighContrast()||!d)&&(d=t.ColorUtils.getContrastingTextColor(i.color)),d&&_.setSolidFill(d)}return _},f.prototype._styleDisplayable=function(e,a){var i=e.color;if(a instanceof t.SimpleMarker){var r=e.borderStyle;if("none"!=r){var n=e.borderWidth;"string"==typeof n&&(n="px"==n.slice(-2)?parseFloat(e.borderWidth.slice(0,-2)):parseFloat(e.borderWidth));var s=new t.Stroke(e.borderColor,1,n,!this._tmap.isMarkerZoomBehaviorFixed(),t.Stroke.getDefaultDashProps(r,n));a.setStroke(s)}var o=e.opacity;i&&a.setSolidFill(i,o)}else if(a instanceof t.Path){var l=e.borderColor;if(l){s=new t.Stroke(l,1,1,this._tmap.supportsVectorEffects());a.setStroke(s)}a.setSolidFill(i,o)}},f.getCenter=function(e,a,i,n){var s=e.getMap(),o=s.getMapName(),l=e.getMapLayer(),h=l.getLayerName();if(a){var c=r.getCityCoordinates(o,a);if(c)return c;var _,p=r.getAreaCenter(o,h,a);if(p)return p;if(!o&&l.getAreaShape){var g=l.getAreaShape(a);if(!g)return null;_=t.DisplayableUtils.getDimensionsForced(s.getCtx(),g)}else{var d=r.getPathForArea(o,h,a);if(!d)return null;var u=t.PathUtils.createPathArray(d);_=t.PathUtils.getDimensions(u)}return _.getCenter()}return S.project(i,n,o)},f._calcBubbleSizes=function(e,a){for(var i=-1/0,r=1/0,n=0;n<a.length;n++){null==(_=a[n].value)||_<=0||(i=Math.max(i,_),r=Math.min(r,_))}if(r!==1/0){var s=2*f._PZC_PADDING,o=e.getWidth()-s,l=e.getHeight()-s,h=o/l;h<1.3?l=2*o/3:h>1.7&&(o=1.5*l);var c=f._MAX_MARKER_SIZE_RATIO*Math.min(o,l);for(n=0;n<a.length;n++){var _=a[n].value;a[n]._size=null==_||_<=0?0:t.LayoutUtils.getBubbleSize(_,r,i,f._MIN_MARKER_SIZE,c)}}},f.calcCurve=function(e,a,i,r,n){var s=r.x,o=r.y,l=n.x,h=n.y,c=e.getMap(),_=t.PathUtils.moveTo(s,o),p=e.trackLink(a,i),g=Math.min(c.getWidth(),c.getHeight())/35;if(l-s==0||h-o==0){if(p>1){if(g*=p-1,l-s==0){var d=.3*Math.abs(o-h);O=o>h?o-d:o+d,m=S=s+g,P=h>o?h-d:h+d}else{d=.3*Math.abs(s-l);S=s>l?s-d:s+d,m=l>s?l-d:l+d,P=O=o-g}_+=t.PathUtils.cubicTo(S,O,m,P,l,h)}else _+=t.PathUtils.lineTo(l,h)}else{var u=(d=Math.sqrt(Math.pow(l-s,2),Math.pow(h-o,2)))/4;p>1&&(u+=(p-1)*g);var y=(h-o)/(l-s),f=-1/y;f>0&&(u*=-1);var S,m,v=.3*d/Math.sqrt(1+Math.pow(y,2)),A=l-s>0,b=s+(A?1:-1)*v,E=y*(b-s)+o,L=l+(A?-1:1)*v,D=y*(L-l)+h,C=u/Math.sqrt(1+Math.pow(f,2)),O=f*((S=b+C)-b)+E,P=f*((m=L+C)-L)+D;_+=t.PathUtils.cubicTo(S,O,m,P,l,h)}return _},f._getLocationName=function(t,e,a){var i=a.location;if(i){var n=e.getMapLayer();return n instanceof g?n.getLongAreaName(i):r.getCityLabel(t,i)}return null};var S={};t.Obj.createSubclass(S,t.Obj),S._VIEWPORT_BOUNDS=new t.Rectangle(0,0,800,500),S._RADIUS=6378206.4,S._NEW_ZEALAND_RECT=new t.Rectangle(500,200,200,200),S._NEW_ZEALAND_BOUNDS=new t.Rectangle(163,-49,17,17),S._AFRICA_BOUNDS=new t.Rectangle(-17.379205428479874,-37.201510854305546,68.66391442808313,77.50071544582713),S._ASIA_BOUNDS=new t.Rectangle(-.8436866097568272,-.7626456732012923,1.8336308036296942,1.5748427214611724),S._AUSTRALIA_BOUNDS=new t.Rectangle(113.29667079927977,-52.89550592498755,65.25257389065216,42.123114617504626),S._EUROPE_BOUNDS=new t.Rectangle(-.47944476148667076,-.0014669405958800579,.7364925893845453,.6293972741802124),S._N_AMERICA_BOUNDS=new t.Rectangle(-.6154469465354344,-.24589767758847714,1.2448236795108683,1.2631535127174947),S._S_AMERICA_BOUNDS=new t.Rectangle(-80.60817722658722,-60.796273249672765,46.608687602908056,66.96595767361796),S._APAC_BOUNDS=new t.Rectangle(68.20516856593524,-52.89892708045518,111.65739821771903,116.55460214469134),S._EMEA_BOUNDS=new t.Rectangle(-24.543831069368586,-37.202500659225905,204.54283106936856,164.9634493690208),S._L_AMERICA_BOUNDS=new t.Rectangle(-117.12451221229134,-54.95921623126266,82.33223251442891,87.67786623127876),S._USA_CANADA_BOUNDS=new t.Rectangle(-.6154656300926513,.0507209798775865,1.0153104799231851,.966537441082997),S._WORLD_BOUNDS=new t.Rectangle(-171.9,-62.6,349.8,150.8),S._ALASKA1_RECT=new t.Rectangle(172,51,8,3),S._ALASKA2_RECT=new t.Rectangle(-180,51,51,21),S._HAWAII_RECT=new t.Rectangle(-178.5,18.9,35,11),S._USA_RECT=new t.Rectangle(-124.8,24.4,58,25.5),S._ALASKA_BOUNDS=new t.Rectangle(-187.5517578125,59.82610321044922,57.562225341796875,43.83738708496094),S._HAWAII_BOUNDS=new t.Rectangle(-160.23606872558594,18.91549301147461,5.4374847412109375,3.3189010620117188),S._USA_BOUNDS=new t.Rectangle(-2386803.25,-1183550.5,4514111,2908402),S._HAWAII_WINDOW=new t.Rectangle(165,400,100,100),S._ALASKA_WINDOW=new t.Rectangle(-75,350,240,150),S._ROBINSON_COORDINATES=[[1,0],[.9986,.0314],[.9954,.0629],[.99,.0943],[.9822,.1258],[.973,.1572],[.96,.1887],[.9427,.2201],[.9216,.2515],[.8962,.2826],[.8679,.3132],[.835,.3433],[.7986,.3726],[.7597,.4008],[.6732,.4532],[.6213,.4765],[.5722,.4951],[.5322,.5072]],S.project=function(e,a,i){var r;switch(i){case"africa":r=S._getAffineProjection(S._AFRICA_BOUNDS,S._getMercatorProjection(e,a));break;case"asia":r=S._getAffineProjection(S._ASIA_BOUNDS,S._getAlbersEqualAreaConicProjection(40,95,20,60,e,a),S.toRadians(5));break;case"australia":r=S._getAustraliaProjection(e,a);break;case"europe":r=S._getAffineProjection(S._EUROPE_BOUNDS,S._getAlbersEqualAreaConicProjection(35,25,40,65,e,a),S.toRadians(10));break;case"northAmerica":r=S._getAffineProjection(S._N_AMERICA_BOUNDS,S._getAlbersEqualAreaConicProjection(23,-96,20,60,e,a));break;case"southAmerica":r=S._getAffineProjection(S._S_AMERICA_BOUNDS,new t.Point(e,a),S.toRadians(5));break;case"apac":r=S._getAffineProjection(S._APAC_BOUNDS,S._getMercatorProjection(e,a));break;case"emea":r=S._getAffineProjection(S._EMEA_BOUNDS,S._getMercatorProjection(e,a));break;case"latinAmerica":r=S._getAffineProjection(S._L_AMERICA_BOUNDS,new t.Point(e,a));break;case"usaAndCanada":r=S._getAffineProjection(S._USA_CANADA_BOUNDS,S._getAlbersEqualAreaConicProjection(23,-96,20,60,e,a));break;case"worldRegions":r=S._getWorldProjection(e,a);break;case"usa":r=S._getUSAProjection(e,a);break;case"world":r=S._getWorldProjection(e,a)}return r?new t.Point(10*r.x,10*r.y):null},S._getUSAProjection=function(e,a){var i,r;return S._ALASKA1_RECT.containsPoint(e,a)||S._ALASKA2_RECT.containsPoint(e,a)?(i=S._getViewPortTransformation(S._ALASKA_BOUNDS,S._ALASKA_WINDOW),r=S._applyAffineTransform(i,S._getMercatorProjection(e,a))):S._HAWAII_RECT.containsPoint(e,a)?(i=S._getViewPortTransformation(S._HAWAII_BOUNDS,S._HAWAII_WINDOW),r=S._applyAffineTransform(i,new t.Point(e,a))):S._USA_RECT.containsPoint(e,a)&&(i=S._getViewPortTransformation(S._USA_BOUNDS,S._VIEWPORT_BOUNDS),r=S._applyAffineTransform(i,S._getOrthographicProjection(new t.Point(-95,36),e,a))),S._getBoundedTransformedPoint(S._VIEWPORT_BOUNDS,r)},S._getWorldProjection=function(t,e){var a=S._getViewPortTransformation(S._WORLD_BOUNDS,S._VIEWPORT_BOUNDS),i=S._applyAffineTransform(a,S._getRobinsonProjection(t,e));return S._getBoundedTransformedPoint(S._VIEWPORT_BOUNDS,i)},S._getAustraliaProjection=function(t,e){var a;a=S._NEW_ZEALAND_BOUNDS.containsPoint(t,e)?S._getViewPortTransformation(S._NEW_ZEALAND_BOUNDS,S._NEW_ZEALAND_RECT):S._getViewPortTransformation(S._AUSTRALIA_BOUNDS,S._VIEWPORT_BOUNDS);var i=S._applyAffineTransform(a,S._getMercatorProjection(t,e));return S._getBoundedTransformedPoint(S._VIEWPORT_BOUNDS,i)},S._getAffineProjection=function(e,a,i){var r=S._getViewPortTransformation(e,S._VIEWPORT_BOUNDS);if(i){var n=new t.Matrix;n=n.rotate(i),r=S._concatAffineTransforms(r,n)}var s=r.transformPoint(a);return S._getBoundedTransformedPoint(S._VIEWPORT_BOUNDS,s)},S._getBoundedTransformedPoint=function(t,e){return e&&t.containsPoint(e.x,e.y)?e:null},S._getAlbersEqualAreaConicProjection=function(e,a,i,r,n,s){var o=S.toRadians(a),l=S.toRadians(e);i=S.toRadians(i),r=S.toRadians(r);var h=.5*(Math.sin(i)+Math.sin(r)),c=Math.pow(Math.cos(i),2)+2*h*Math.sin(i),_=c-2*h*Math.sin(l);_=Math.sqrt(_)/h;var p=S.toRadians(n),g=S.toRadians(s),d=h*(p-o),u=c-2*h*Math.sin(g),y=(u=Math.sqrt(u)/h)*Math.sin(d),f=_-u*Math.cos(d);return new t.Point(y,f)},S._getMercatorProjection=function(e,a){var i=Math.log(Math.tan(.25*Math.PI+.5*S.toRadians(a)));return new t.Point(e,S.toDegrees(i))},S._getOrthographicProjection=function(e,a,i){var r=S.toRadians(a),n=S.toRadians(i),s=S.toRadians(e.x),o=S.toRadians(e.y),l=Math.cos(n)*Math.sin(r-s),h=Math.cos(o)*Math.sin(n)-Math.sin(o)*Math.cos(n)*Math.cos(r-s);return new t.Point(l*S._RADIUS,h*S._RADIUS)},S._getRobinsonProjection=function(e,a){var i=Math.floor(Math.abs(a)/5);i>=S._ROBINSON_COORDINATES.length-1&&(i=S._ROBINSON_COORDINATES.length-2);var r=(Math.abs(a)-5*i)/5,n=S._ROBINSON_COORDINATES[i+1][0]-S._ROBINSON_COORDINATES[i][0],s=S._ROBINSON_COORDINATES[i+1][1]-S._ROBINSON_COORDINATES[i][1],o=e*(S._ROBINSON_COORDINATES[i][0]+r*n),l=S._ROBINSON_COORDINATES[i][1]+r*s;return a<0&&(l*=-1),new t.Point(o,180*l)},S._applyAffineTransform=function(e,a){return new t.Point(a.x*e.getA()+e.getTx(),a.y*e.getD()+e.getTy())},S._concatAffineTransforms=function(e,a){var i=e.getA(),r=a.getA()*i,n=a.getB()*i,s=e.getTx()+a.getTx()*i,o=e.getD(),l=a.getC()*o,h=a.getD()*o,c=e.getTy()+a.getTy()*o;return new t.Matrix(r,n,l,h,s,c)},S._getViewPortTransformation=function(e,a){var i,r=a.x,n=a.y,s=e.w,o=e.h,l=a.w/s,h=a.h/o;i=l<=h?l:h;var c=r-e.x*i,_=n+e.y*i;return c+=(a.w-s*i)/2,_+=a.h-(a.h-o*i)/2,new t.Matrix(i,0,0,-i,c,_)},S.toRadians=function(t){return t*(Math.PI/180)},S.toDegrees=function(t){return t*(180/Math.PI)},S.inverseProject=function(e,a,i){var r;switch(e/=10,a/=10,i){case"africa":r=S._getInverseAffineProjection(S._AFRICA_BOUNDS,new t.Point(e,a)),r=S._getInverseMercatorProjection(r.x,r.y);break;case"asia":r=S._getInverseAffineProjection(S._ASIA_BOUNDS,new t.Point(e,a),S.toRadians(5)),r=S._getInverseAlbersEqualAreaConicProjection(40,95,20,60,r.x,r.y);break;case"australia":r=S._getInverseAustraliaProjection(e,a);break;case"europe":r=S._getInverseAffineProjection(S._EUROPE_BOUNDS,new t.Point(e,a),S.toRadians(10)),r=S._getInverseAlbersEqualAreaConicProjection(35,25,40,65,r.x,r.y);break;case"northAmerica":r=S._getInverseAffineProjection(S._N_AMERICA_BOUNDS,new t.Point(e,a)),r=S._getInverseAlbersEqualAreaConicProjection(23,-96,20,60,r.x,r.y);break;case"southAmerica":r=S._getInverseAffineProjection(S._S_AMERICA_BOUNDS,new t.Point(e,a),S.toRadians(5));break;case"apac":r=S._getInverseAffineProjection(S._APAC_BOUNDS,new t.Point(e,a)),r=S._getInverseMercatorProjection(r.x,r.y);break;case"emea":r=S._getInverseAffineProjection(S._EMEA_BOUNDS,new t.Point(e,a)),r=S._getInverseMercatorProjection(r.x,r.y);break;case"latinAmerica":r=S._getInverseAffineProjection(S._L_AMERICA_BOUNDS,new t.Point(e,a));break;case"usaAndCanada":r=S._getInverseAffineProjection(S._USA_CANADA_BOUNDS,new t.Point(e,a)),r=S._getInverseAlbersEqualAreaConicProjection(23,-96,20,60,r.x,r.y);break;case"worldRegions":r=S._getInverseWorldProjection(e,a);break;case"usa":r=S._getInverseUSAProjection(e,a);break;case"world":r=S._getInverseWorldProjection(e,a)}return r||new t.Point(e,a)},S._getInverseUSAProjection=function(e,a){if(S._ALASKA_WINDOW.containsPoint(e,a)){var i=S._getViewPortTransformation(S._ALASKA_BOUNDS,S._ALASKA_WINDOW).invert().transformPoint(new t.Point(e,a));return S._getInverseMercatorProjection(i.x,i.y)}if(S._HAWAII_WINDOW.containsPoint(e,a))return S._getViewPortTransformation(S._HAWAII_BOUNDS,S._HAWAII_WINDOW).invert().transformPoint(new t.Point(e,a));if(S._VIEWPORT_BOUNDS.containsPoint(e,a)){i=S._getViewPortTransformation(S._USA_BOUNDS,S._VIEWPORT_BOUNDS).invert().transformPoint(new t.Point(e,a));return S._getInverseOrthographicProjection(new t.Point(-95,36),i.x,i.y)}return new t.Point(e,a)},S._getInverseWorldProjection=function(e,a){var i=S._getViewPortTransformation(S._WORLD_BOUNDS,S._VIEWPORT_BOUNDS),r=(i=i.invert()).transformPoint(new t.Point(e,a));return S._getInverseRobinsonProjection(r.x,r.y)},S._getInverseAustraliaProjection=function(e,a){var i=(S._NEW_ZEALAND_RECT.containsPoint(e,a)?S._getViewPortTransformation(S._NEW_ZEALAND_BOUNDS,S._NEW_ZEALAND_RECT):S._getViewPortTransformation(S._AUSTRALIA_BOUNDS,S._VIEWPORT_BOUNDS)).invert().transformPoint(new t.Point(e,a));return S._getInverseMercatorProjection(i.x,i.y)},S._getInverseAffineProjection=function(e,a,i){var r=S._getViewPortTransformation(e,S._VIEWPORT_BOUNDS);if(i){var n=new t.Matrix;n=n.rotate(i),r=S._concatAffineTransforms(r,n)}return(r=r.invert()).transformPoint(a)},S._getInverseAlbersEqualAreaConicProjection=function(e,a,i,r,n,s){var o=S.toRadians(a),l=S.toRadians(e);i=S.toRadians(i),r=S.toRadians(r);var h=.5*(Math.sin(i)+Math.sin(r)),c=Math.pow(Math.cos(i),2)+2*h*Math.sin(i),_=c-2*h*Math.sin(l);_=Math.sqrt(_)/h;var p=Math.sqrt(n*n+(_-s)*(_-s)),g=Math.atan(n/(_-s)),d=Math.asin((c-p*p*h*h)/(2*h)),u=o+g/h;return new t.Point(S.toDegrees(u),S.toDegrees(d))},S._getInverseMercatorProjection=function(e,a){var i=2*Math.atan(Math.exp(S.toRadians(a)))-.5*Math.PI;return new t.Point(e,S.toDegrees(i))},S._getInverseOrthographicProjection=function(e,a,i){var r=a/S._RADIUS,n=i/S._RADIUS,s=S.toRadians(e.x),o=S.toRadians(e.y),l=Math.sqrt(r*r+n*n),h=Math.asin(l),c=Math.asin(Math.cos(h)*Math.sin(o)+n*Math.sin(h)*Math.cos(o)/l),_=s+Math.atan(r*Math.sin(h)/(l*Math.cos(o)*Math.cos(h)-n*Math.sin(o)*Math.sin(h)));return new t.Point(S.toDegrees(_),S.toDegrees(c))},S._getInverseRobinsonProjection=function(e,a){var i=Math.floor(Math.abs(a)/5);i>=S._ROBINSON_COORDINATES.length-1&&(i=S._ROBINSON_COORDINATES.length-2);var r=S._ROBINSON_COORDINATES[i+1][0]-S._ROBINSON_COORDINATES[i][0],n=S._ROBINSON_COORDINATES[i+1][1]-S._ROBINSON_COORDINATES[i][1],s=(Math.abs(a/180)-S._ROBINSON_COORDINATES[i][1])/n,o=5*s+5*i,l=e/(S._ROBINSON_COORDINATES[i][0]+s*r);return a<0&&(o*=-1),new t.Point(l,o)};var m={_MANAGER:"DvtBaseMapManager",_UNPROCESSED:"_UNPROCESSED_MAPS",_TYPE:"type",_GEOMETRY:"geometry",_COORDINATES:"coordinates",_FEATURES:"features",_PROPERTIES:"properties",_TYPE_FEATURE_COLLECTION:"FeatureCollection",_TYPE_GEOMETRY_COLLECTION:"GeometryCollection",_TYPE_FEATURE:"Feature",_TYPE_POLYGON:"Polygon",_TYPE_MULTI_POLYGON:"MultiPolygon",_ID:"id",_SHORT_LABEL:"shortLabel",_LONG_LABEL:"longLabel",containsGeoJson:function(t){return t&&t.geo&&t.geo[m._TYPE]},parseMapInfo:function(t,e){var a={},i={},r=e.geo,n=e.propertiesKeys||{};if(!n[m._ID])throw new Error("Missing required mapProvider.propertiesKeys.id property.");var s=r[m._TYPE];if(s===m._TYPE_FEATURE_COLLECTION)for(var o=r[m._FEATURES],l=0;l<o.length;l++)m._parseFeature(t,o[l],n,i,a);else{if(s!==m._TYPE_FEATURE)throw new Error("GeoJSON type of "+s+" is not supported. Only Feature and FeatureCollection types are supported.");m._parseFeature(t,r,n,i,a)}if(0===Object.keys(i).length)throw new Error("No valid Features found in GeoJSON.");return{labels:a,areas:i}},_parseFeature:function(t,e,a,i,r){var n=e[m._PROPERTIES],s=e[m._GEOMETRY];if(m._isSupportedGeometry(s)){var o=n[a[m._ID]];if(o){var l=n[a[m._SHORT_LABEL]],h=n[a[m._LONG_LABEL]];(l||h)&&(r[o]=[l,h]),i[o]=m._geomToPath(s)}else t.oj.Logger.warn("No 'id' value found in the mapProvider.propertiesKey object. A Feature's 'properties' object must have an id in the field specified by the mapProvider.propertiesKey.id value.")}else t.oj.Logger.warn("A geometry of type "+s[m._TYPE]+" is not supported and will be skipped.")},_isSupportedGeometry:function(t){var e=t[m._TYPE];return e===m._TYPE_POLYGON||e===m._TYPE_MULTI_POLYGON},_geomToPath:function(t){var e="",a=t[m._TYPE],i=t[m._COORDINATES];if(a===m._TYPE_POLYGON)e=m._polygonToPath(i);else if(a===m._TYPE_MULTI_POLYGON)for(var r=0;r<i.length;r++)e+=m._polygonToPath(i[r]);return e},_polygonToPath:function(t){for(var e="",a=0;a<t.length;a++)e+=m._linearRingToPath(t[a]);return e},_linearRingToPath:function(t){var e,a,i,r="M";if(t)for(var n=0;n<t.length;n++){var s=t[n],o=s[0],l=-s[1];if("M"!==r){var h=o-a,c=l-i;if("l"==r){if(a==o){i=l,e=e+(r="v")+c;continue}if(i==l){a=o,e=e+(r="h")+h;continue}e=e+" "+h+" "+c}else r="l",e=e+"l"+h+" "+c;a=o,i=l}else a=o,i=l,r="x",e="M"+o+" "+l}return e+"Z"},_getCoord:function(t,e){for(var a=e;a<t.length;a++){var i=t[a];if("-"!==i&&(isNaN(i)||" "===i)){var r=null;return" "!==i&&(r=i),{coord:parseInt(t.substring(e,a)),idx:a,cmd:r}}}return{}},_pathToPolygon:function(t){var e=[],a=0,i=0,r=t[0];if(t)for(var n=[],s=1;s<t.length;s++){var o=m._getCoord(t,s),l=null;s=o.idx,"v"!==r&&"h"!==r?(l=m._getCoord(t,++s),s=l.idx,a+=o.coord,i+=l.coord):"v"===r?i+=o.coord:"h"===r&&(a+=o.coord),n.push([a,-i]),l?null!=l.cmd&&(r=l.cmd):null!=o.cmd&&(r=o.cmd),"Z"===r&&(e.push(n),n=[],r=t[++s])}return e}}}(dvt);
// To avoid changing the basemaps, which each call the basemap manager, we will
// put the basemap manager onto the returned object. We'll only do this if it's
// not defined, since in min/min-debug mode, the non-exported version is on the window.
if(!dvt['DvtBaseMapManager'])
  dvt['DvtBaseMapManager'] = DvtBaseMapManager;

  return dvt;
});
